// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Returns information about the XML element or attribute that was sanitized in the configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SanitizationWarning {
    /// <p>The name of the XML attribute that has been sanitized.</p>
    pub attribute_name: std::option::Option<std::string::String>,
    /// <p>The name of the XML element that has been sanitized.</p>
    pub element_name: std::option::Option<std::string::String>,
    /// <p>Required. The reason for which the XML elements or attributes were sanitized.</p>
    pub reason: std::option::Option<crate::model::SanitizationWarningReason>,
}
impl SanitizationWarning {
    /// <p>The name of the XML attribute that has been sanitized.</p>
    pub fn attribute_name(&self) -> std::option::Option<&str> {
        self.attribute_name.as_deref()
    }
    /// <p>The name of the XML element that has been sanitized.</p>
    pub fn element_name(&self) -> std::option::Option<&str> {
        self.element_name.as_deref()
    }
    /// <p>Required. The reason for which the XML elements or attributes were sanitized.</p>
    pub fn reason(&self) -> std::option::Option<&crate::model::SanitizationWarningReason> {
        self.reason.as_ref()
    }
}
impl std::fmt::Debug for SanitizationWarning {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SanitizationWarning");
        formatter.field("attribute_name", &self.attribute_name);
        formatter.field("element_name", &self.element_name);
        formatter.field("reason", &self.reason);
        formatter.finish()
    }
}
/// See [`SanitizationWarning`](crate::model::SanitizationWarning)
pub mod sanitization_warning {
    /// A builder for [`SanitizationWarning`](crate::model::SanitizationWarning)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute_name: std::option::Option<std::string::String>,
        pub(crate) element_name: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<crate::model::SanitizationWarningReason>,
    }
    impl Builder {
        /// <p>The name of the XML attribute that has been sanitized.</p>
        pub fn attribute_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.attribute_name = Some(input.into());
            self
        }
        /// <p>The name of the XML attribute that has been sanitized.</p>
        pub fn set_attribute_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attribute_name = input;
            self
        }
        /// <p>The name of the XML element that has been sanitized.</p>
        pub fn element_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.element_name = Some(input.into());
            self
        }
        /// <p>The name of the XML element that has been sanitized.</p>
        pub fn set_element_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.element_name = input;
            self
        }
        /// <p>Required. The reason for which the XML elements or attributes were sanitized.</p>
        pub fn reason(mut self, input: crate::model::SanitizationWarningReason) -> Self {
            self.reason = Some(input);
            self
        }
        /// <p>Required. The reason for which the XML elements or attributes were sanitized.</p>
        pub fn set_reason(
            mut self,
            input: std::option::Option<crate::model::SanitizationWarningReason>,
        ) -> Self {
            self.reason = input;
            self
        }
        /// Consumes the builder and constructs a [`SanitizationWarning`](crate::model::SanitizationWarning)
        pub fn build(self) -> crate::model::SanitizationWarning {
            crate::model::SanitizationWarning {
                attribute_name: self.attribute_name,
                element_name: self.element_name,
                reason: self.reason,
            }
        }
    }
}
impl SanitizationWarning {
    /// Creates a new builder-style object to manufacture [`SanitizationWarning`](crate::model::SanitizationWarning)
    pub fn builder() -> crate::model::sanitization_warning::Builder {
        crate::model::sanitization_warning::Builder::default()
    }
}

/// <p>The reason for which the XML elements or attributes were sanitized.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SanitizationWarningReason {
    #[allow(missing_docs)] // documentation missing in model
    DisallowedAttributeRemoved,
    #[allow(missing_docs)] // documentation missing in model
    DisallowedElementRemoved,
    #[allow(missing_docs)] // documentation missing in model
    InvalidAttributeValueRemoved,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SanitizationWarningReason {
    fn from(s: &str) -> Self {
        match s {
            "DISALLOWED_ATTRIBUTE_REMOVED" => SanitizationWarningReason::DisallowedAttributeRemoved,
            "DISALLOWED_ELEMENT_REMOVED" => SanitizationWarningReason::DisallowedElementRemoved,
            "INVALID_ATTRIBUTE_VALUE_REMOVED" => {
                SanitizationWarningReason::InvalidAttributeValueRemoved
            }
            other => SanitizationWarningReason::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SanitizationWarningReason {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SanitizationWarningReason::from(s))
    }
}
impl SanitizationWarningReason {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SanitizationWarningReason::DisallowedAttributeRemoved => "DISALLOWED_ATTRIBUTE_REMOVED",
            SanitizationWarningReason::DisallowedElementRemoved => "DISALLOWED_ELEMENT_REMOVED",
            SanitizationWarningReason::InvalidAttributeValueRemoved => {
                "INVALID_ATTRIBUTE_VALUE_REMOVED"
            }
            SanitizationWarningReason::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DISALLOWED_ATTRIBUTE_REMOVED",
            "DISALLOWED_ELEMENT_REMOVED",
            "INVALID_ATTRIBUTE_VALUE_REMOVED",
        ]
    }
}
impl AsRef<str> for SanitizationWarningReason {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Returns information about the specified configuration revision.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConfigurationRevision {
    /// <p>Required. The date and time of the configuration revision.</p>
    pub created: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The description of the configuration revision.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Required. The revision number of the configuration.</p>
    pub revision: i32,
}
impl ConfigurationRevision {
    /// <p>Required. The date and time of the configuration revision.</p>
    pub fn created(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created.as_ref()
    }
    /// <p>The description of the configuration revision.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Required. The revision number of the configuration.</p>
    pub fn revision(&self) -> i32 {
        self.revision
    }
}
impl std::fmt::Debug for ConfigurationRevision {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConfigurationRevision");
        formatter.field("created", &self.created);
        formatter.field("description", &self.description);
        formatter.field("revision", &self.revision);
        formatter.finish()
    }
}
/// See [`ConfigurationRevision`](crate::model::ConfigurationRevision)
pub mod configuration_revision {
    /// A builder for [`ConfigurationRevision`](crate::model::ConfigurationRevision)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) created: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) revision: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Required. The date and time of the configuration revision.</p>
        pub fn created(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created = Some(input);
            self
        }
        /// <p>Required. The date and time of the configuration revision.</p>
        pub fn set_created(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created = input;
            self
        }
        /// <p>The description of the configuration revision.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the configuration revision.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Required. The revision number of the configuration.</p>
        pub fn revision(mut self, input: i32) -> Self {
            self.revision = Some(input);
            self
        }
        /// <p>Required. The revision number of the configuration.</p>
        pub fn set_revision(mut self, input: std::option::Option<i32>) -> Self {
            self.revision = input;
            self
        }
        /// Consumes the builder and constructs a [`ConfigurationRevision`](crate::model::ConfigurationRevision)
        pub fn build(self) -> crate::model::ConfigurationRevision {
            crate::model::ConfigurationRevision {
                created: self.created,
                description: self.description,
                revision: self.revision.unwrap_or_default(),
            }
        }
    }
}
impl ConfigurationRevision {
    /// Creates a new builder-style object to manufacture [`ConfigurationRevision`](crate::model::ConfigurationRevision)
    pub fn builder() -> crate::model::configuration_revision::Builder {
        crate::model::configuration_revision::Builder::default()
    }
}

/// <p>The scheduled time period relative to UTC during which Amazon MQ begins to apply pending updates or patches to the broker.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WeeklyStartTime {
    /// <p>Required. The day of the week.</p>
    pub day_of_week: std::option::Option<crate::model::DayOfWeek>,
    /// <p>Required. The time, in 24-hour format.</p>
    pub time_of_day: std::option::Option<std::string::String>,
    /// <p>The time zone, UTC by default, in either the Country/City format, or the UTC offset format.</p>
    pub time_zone: std::option::Option<std::string::String>,
}
impl WeeklyStartTime {
    /// <p>Required. The day of the week.</p>
    pub fn day_of_week(&self) -> std::option::Option<&crate::model::DayOfWeek> {
        self.day_of_week.as_ref()
    }
    /// <p>Required. The time, in 24-hour format.</p>
    pub fn time_of_day(&self) -> std::option::Option<&str> {
        self.time_of_day.as_deref()
    }
    /// <p>The time zone, UTC by default, in either the Country/City format, or the UTC offset format.</p>
    pub fn time_zone(&self) -> std::option::Option<&str> {
        self.time_zone.as_deref()
    }
}
impl std::fmt::Debug for WeeklyStartTime {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WeeklyStartTime");
        formatter.field("day_of_week", &self.day_of_week);
        formatter.field("time_of_day", &self.time_of_day);
        formatter.field("time_zone", &self.time_zone);
        formatter.finish()
    }
}
/// See [`WeeklyStartTime`](crate::model::WeeklyStartTime)
pub mod weekly_start_time {
    /// A builder for [`WeeklyStartTime`](crate::model::WeeklyStartTime)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) day_of_week: std::option::Option<crate::model::DayOfWeek>,
        pub(crate) time_of_day: std::option::Option<std::string::String>,
        pub(crate) time_zone: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Required. The day of the week.</p>
        pub fn day_of_week(mut self, input: crate::model::DayOfWeek) -> Self {
            self.day_of_week = Some(input);
            self
        }
        /// <p>Required. The day of the week.</p>
        pub fn set_day_of_week(
            mut self,
            input: std::option::Option<crate::model::DayOfWeek>,
        ) -> Self {
            self.day_of_week = input;
            self
        }
        /// <p>Required. The time, in 24-hour format.</p>
        pub fn time_of_day(mut self, input: impl Into<std::string::String>) -> Self {
            self.time_of_day = Some(input.into());
            self
        }
        /// <p>Required. The time, in 24-hour format.</p>
        pub fn set_time_of_day(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.time_of_day = input;
            self
        }
        /// <p>The time zone, UTC by default, in either the Country/City format, or the UTC offset format.</p>
        pub fn time_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.time_zone = Some(input.into());
            self
        }
        /// <p>The time zone, UTC by default, in either the Country/City format, or the UTC offset format.</p>
        pub fn set_time_zone(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.time_zone = input;
            self
        }
        /// Consumes the builder and constructs a [`WeeklyStartTime`](crate::model::WeeklyStartTime)
        pub fn build(self) -> crate::model::WeeklyStartTime {
            crate::model::WeeklyStartTime {
                day_of_week: self.day_of_week,
                time_of_day: self.time_of_day,
                time_zone: self.time_zone,
            }
        }
    }
}
impl WeeklyStartTime {
    /// Creates a new builder-style object to manufacture [`WeeklyStartTime`](crate::model::WeeklyStartTime)
    pub fn builder() -> crate::model::weekly_start_time::Builder {
        crate::model::weekly_start_time::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DayOfWeek {
    #[allow(missing_docs)] // documentation missing in model
    Friday,
    #[allow(missing_docs)] // documentation missing in model
    Monday,
    #[allow(missing_docs)] // documentation missing in model
    Saturday,
    #[allow(missing_docs)] // documentation missing in model
    Sunday,
    #[allow(missing_docs)] // documentation missing in model
    Thursday,
    #[allow(missing_docs)] // documentation missing in model
    Tuesday,
    #[allow(missing_docs)] // documentation missing in model
    Wednesday,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DayOfWeek {
    fn from(s: &str) -> Self {
        match s {
            "FRIDAY" => DayOfWeek::Friday,
            "MONDAY" => DayOfWeek::Monday,
            "SATURDAY" => DayOfWeek::Saturday,
            "SUNDAY" => DayOfWeek::Sunday,
            "THURSDAY" => DayOfWeek::Thursday,
            "TUESDAY" => DayOfWeek::Tuesday,
            "WEDNESDAY" => DayOfWeek::Wednesday,
            other => DayOfWeek::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DayOfWeek {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DayOfWeek::from(s))
    }
}
impl DayOfWeek {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DayOfWeek::Friday => "FRIDAY",
            DayOfWeek::Monday => "MONDAY",
            DayOfWeek::Saturday => "SATURDAY",
            DayOfWeek::Sunday => "SUNDAY",
            DayOfWeek::Thursday => "THURSDAY",
            DayOfWeek::Tuesday => "TUESDAY",
            DayOfWeek::Wednesday => "WEDNESDAY",
            DayOfWeek::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "FRIDAY",
            "MONDAY",
            "SATURDAY",
            "SUNDAY",
            "THURSDAY",
            "TUESDAY",
            "WEDNESDAY",
        ]
    }
}
impl AsRef<str> for DayOfWeek {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The list of information about logs to be enabled for the specified broker.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Logs {
    /// <p>Enables audit logging. Every user management action made using JMX or the ActiveMQ Web Console is logged. Does not apply to RabbitMQ brokers.</p>
    pub audit: bool,
    /// <p>Enables general logging.</p>
    pub general: bool,
}
impl Logs {
    /// <p>Enables audit logging. Every user management action made using JMX or the ActiveMQ Web Console is logged. Does not apply to RabbitMQ brokers.</p>
    pub fn audit(&self) -> bool {
        self.audit
    }
    /// <p>Enables general logging.</p>
    pub fn general(&self) -> bool {
        self.general
    }
}
impl std::fmt::Debug for Logs {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Logs");
        formatter.field("audit", &self.audit);
        formatter.field("general", &self.general);
        formatter.finish()
    }
}
/// See [`Logs`](crate::model::Logs)
pub mod logs {
    /// A builder for [`Logs`](crate::model::Logs)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) audit: std::option::Option<bool>,
        pub(crate) general: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Enables audit logging. Every user management action made using JMX or the ActiveMQ Web Console is logged. Does not apply to RabbitMQ brokers.</p>
        pub fn audit(mut self, input: bool) -> Self {
            self.audit = Some(input);
            self
        }
        /// <p>Enables audit logging. Every user management action made using JMX or the ActiveMQ Web Console is logged. Does not apply to RabbitMQ brokers.</p>
        pub fn set_audit(mut self, input: std::option::Option<bool>) -> Self {
            self.audit = input;
            self
        }
        /// <p>Enables general logging.</p>
        pub fn general(mut self, input: bool) -> Self {
            self.general = Some(input);
            self
        }
        /// <p>Enables general logging.</p>
        pub fn set_general(mut self, input: std::option::Option<bool>) -> Self {
            self.general = input;
            self
        }
        /// Consumes the builder and constructs a [`Logs`](crate::model::Logs)
        pub fn build(self) -> crate::model::Logs {
            crate::model::Logs {
                audit: self.audit.unwrap_or_default(),
                general: self.general.unwrap_or_default(),
            }
        }
    }
}
impl Logs {
    /// Creates a new builder-style object to manufacture [`Logs`](crate::model::Logs)
    pub fn builder() -> crate::model::logs::Builder {
        crate::model::logs::Builder::default()
    }
}

/// <p>Optional. The metadata of the LDAP server used to authenticate and authorize connections to the broker.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LdapServerMetadataOutput {
    /// <p>Specifies the location of the LDAP server such as AWS Directory Service for Microsoft Active Directory . Optional failover server.</p>
    pub hosts: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The distinguished name of the node in the directory information tree (DIT) to search for roles or groups. For example, ou=group, ou=corp, dc=corp,
    /// dc=example, dc=com.</p>
    pub role_base: std::option::Option<std::string::String>,
    /// <p>Specifies the LDAP attribute that identifies the group name attribute in the object returned from the group membership query.</p>
    pub role_name: std::option::Option<std::string::String>,
    /// <p>The LDAP search filter used to find roles within the roleBase. The distinguished name of the user matched by userSearchMatching is substituted into the {0} placeholder in the search filter. The client's username is substituted into the {1} placeholder. For example, if you set this option to (member=uid={1})for the user janedoe, the search filter becomes (member=uid=janedoe) after string substitution. It matches all role entries that have a member attribute equal to uid=janedoe under the subtree selected by the roleBase.</p>
    pub role_search_matching: std::option::Option<std::string::String>,
    /// <p>The directory search scope for the role. If set to true, scope is to search the entire subtree.</p>
    pub role_search_subtree: bool,
    /// <p>Service account username. A service account is an account in your LDAP server that has access to initiate a connection. For example, cn=admin,dc=corp, dc=example,
    /// dc=com.</p>
    pub service_account_username: std::option::Option<std::string::String>,
    /// <p>Select a particular subtree of the directory information tree (DIT) to search for user entries. The subtree is specified by a DN, which specifies the base node of the subtree. For example, by setting this option to ou=Users,ou=corp, dc=corp,
    /// dc=example, dc=com, the search for user entries is restricted to the subtree beneath ou=Users, ou=corp, dc=corp, dc=example, dc=com.</p>
    pub user_base: std::option::Option<std::string::String>,
    /// <p>Specifies the name of the LDAP attribute for the user group membership.</p>
    pub user_role_name: std::option::Option<std::string::String>,
    /// <p>The LDAP search filter used to find users within the userBase. The client's username is substituted into the {0} placeholder in the search filter. For example, if this option is set to (uid={0}) and the received username is janedoe, the search filter becomes (uid=janedoe) after string substitution. It will result in matching an entry like uid=janedoe, ou=Users,ou=corp, dc=corp, dc=example,
    /// dc=com.</p>
    pub user_search_matching: std::option::Option<std::string::String>,
    /// <p>The directory search scope for the user. If set to true, scope is to search the entire subtree.</p>
    pub user_search_subtree: bool,
}
impl LdapServerMetadataOutput {
    /// <p>Specifies the location of the LDAP server such as AWS Directory Service for Microsoft Active Directory . Optional failover server.</p>
    pub fn hosts(&self) -> std::option::Option<&[std::string::String]> {
        self.hosts.as_deref()
    }
    /// <p>The distinguished name of the node in the directory information tree (DIT) to search for roles or groups. For example, ou=group, ou=corp, dc=corp,
    /// dc=example, dc=com.</p>
    pub fn role_base(&self) -> std::option::Option<&str> {
        self.role_base.as_deref()
    }
    /// <p>Specifies the LDAP attribute that identifies the group name attribute in the object returned from the group membership query.</p>
    pub fn role_name(&self) -> std::option::Option<&str> {
        self.role_name.as_deref()
    }
    /// <p>The LDAP search filter used to find roles within the roleBase. The distinguished name of the user matched by userSearchMatching is substituted into the {0} placeholder in the search filter. The client's username is substituted into the {1} placeholder. For example, if you set this option to (member=uid={1})for the user janedoe, the search filter becomes (member=uid=janedoe) after string substitution. It matches all role entries that have a member attribute equal to uid=janedoe under the subtree selected by the roleBase.</p>
    pub fn role_search_matching(&self) -> std::option::Option<&str> {
        self.role_search_matching.as_deref()
    }
    /// <p>The directory search scope for the role. If set to true, scope is to search the entire subtree.</p>
    pub fn role_search_subtree(&self) -> bool {
        self.role_search_subtree
    }
    /// <p>Service account username. A service account is an account in your LDAP server that has access to initiate a connection. For example, cn=admin,dc=corp, dc=example,
    /// dc=com.</p>
    pub fn service_account_username(&self) -> std::option::Option<&str> {
        self.service_account_username.as_deref()
    }
    /// <p>Select a particular subtree of the directory information tree (DIT) to search for user entries. The subtree is specified by a DN, which specifies the base node of the subtree. For example, by setting this option to ou=Users,ou=corp, dc=corp,
    /// dc=example, dc=com, the search for user entries is restricted to the subtree beneath ou=Users, ou=corp, dc=corp, dc=example, dc=com.</p>
    pub fn user_base(&self) -> std::option::Option<&str> {
        self.user_base.as_deref()
    }
    /// <p>Specifies the name of the LDAP attribute for the user group membership.</p>
    pub fn user_role_name(&self) -> std::option::Option<&str> {
        self.user_role_name.as_deref()
    }
    /// <p>The LDAP search filter used to find users within the userBase. The client's username is substituted into the {0} placeholder in the search filter. For example, if this option is set to (uid={0}) and the received username is janedoe, the search filter becomes (uid=janedoe) after string substitution. It will result in matching an entry like uid=janedoe, ou=Users,ou=corp, dc=corp, dc=example,
    /// dc=com.</p>
    pub fn user_search_matching(&self) -> std::option::Option<&str> {
        self.user_search_matching.as_deref()
    }
    /// <p>The directory search scope for the user. If set to true, scope is to search the entire subtree.</p>
    pub fn user_search_subtree(&self) -> bool {
        self.user_search_subtree
    }
}
impl std::fmt::Debug for LdapServerMetadataOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LdapServerMetadataOutput");
        formatter.field("hosts", &self.hosts);
        formatter.field("role_base", &self.role_base);
        formatter.field("role_name", &self.role_name);
        formatter.field("role_search_matching", &self.role_search_matching);
        formatter.field("role_search_subtree", &self.role_search_subtree);
        formatter.field("service_account_username", &self.service_account_username);
        formatter.field("user_base", &self.user_base);
        formatter.field("user_role_name", &self.user_role_name);
        formatter.field("user_search_matching", &self.user_search_matching);
        formatter.field("user_search_subtree", &self.user_search_subtree);
        formatter.finish()
    }
}
/// See [`LdapServerMetadataOutput`](crate::model::LdapServerMetadataOutput)
pub mod ldap_server_metadata_output {
    /// A builder for [`LdapServerMetadataOutput`](crate::model::LdapServerMetadataOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hosts: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) role_base: std::option::Option<std::string::String>,
        pub(crate) role_name: std::option::Option<std::string::String>,
        pub(crate) role_search_matching: std::option::Option<std::string::String>,
        pub(crate) role_search_subtree: std::option::Option<bool>,
        pub(crate) service_account_username: std::option::Option<std::string::String>,
        pub(crate) user_base: std::option::Option<std::string::String>,
        pub(crate) user_role_name: std::option::Option<std::string::String>,
        pub(crate) user_search_matching: std::option::Option<std::string::String>,
        pub(crate) user_search_subtree: std::option::Option<bool>,
    }
    impl Builder {
        /// Appends an item to `hosts`.
        ///
        /// To override the contents of this collection use [`set_hosts`](Self::set_hosts).
        ///
        /// <p>Specifies the location of the LDAP server such as AWS Directory Service for Microsoft Active Directory . Optional failover server.</p>
        pub fn hosts(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.hosts.unwrap_or_default();
            v.push(input.into());
            self.hosts = Some(v);
            self
        }
        /// <p>Specifies the location of the LDAP server such as AWS Directory Service for Microsoft Active Directory . Optional failover server.</p>
        pub fn set_hosts(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.hosts = input;
            self
        }
        /// <p>The distinguished name of the node in the directory information tree (DIT) to search for roles or groups. For example, ou=group, ou=corp, dc=corp,
        /// dc=example, dc=com.</p>
        pub fn role_base(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_base = Some(input.into());
            self
        }
        /// <p>The distinguished name of the node in the directory information tree (DIT) to search for roles or groups. For example, ou=group, ou=corp, dc=corp,
        /// dc=example, dc=com.</p>
        pub fn set_role_base(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_base = input;
            self
        }
        /// <p>Specifies the LDAP attribute that identifies the group name attribute in the object returned from the group membership query.</p>
        pub fn role_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_name = Some(input.into());
            self
        }
        /// <p>Specifies the LDAP attribute that identifies the group name attribute in the object returned from the group membership query.</p>
        pub fn set_role_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_name = input;
            self
        }
        /// <p>The LDAP search filter used to find roles within the roleBase. The distinguished name of the user matched by userSearchMatching is substituted into the {0} placeholder in the search filter. The client's username is substituted into the {1} placeholder. For example, if you set this option to (member=uid={1})for the user janedoe, the search filter becomes (member=uid=janedoe) after string substitution. It matches all role entries that have a member attribute equal to uid=janedoe under the subtree selected by the roleBase.</p>
        pub fn role_search_matching(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_search_matching = Some(input.into());
            self
        }
        /// <p>The LDAP search filter used to find roles within the roleBase. The distinguished name of the user matched by userSearchMatching is substituted into the {0} placeholder in the search filter. The client's username is substituted into the {1} placeholder. For example, if you set this option to (member=uid={1})for the user janedoe, the search filter becomes (member=uid=janedoe) after string substitution. It matches all role entries that have a member attribute equal to uid=janedoe under the subtree selected by the roleBase.</p>
        pub fn set_role_search_matching(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.role_search_matching = input;
            self
        }
        /// <p>The directory search scope for the role. If set to true, scope is to search the entire subtree.</p>
        pub fn role_search_subtree(mut self, input: bool) -> Self {
            self.role_search_subtree = Some(input);
            self
        }
        /// <p>The directory search scope for the role. If set to true, scope is to search the entire subtree.</p>
        pub fn set_role_search_subtree(mut self, input: std::option::Option<bool>) -> Self {
            self.role_search_subtree = input;
            self
        }
        /// <p>Service account username. A service account is an account in your LDAP server that has access to initiate a connection. For example, cn=admin,dc=corp, dc=example,
        /// dc=com.</p>
        pub fn service_account_username(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_account_username = Some(input.into());
            self
        }
        /// <p>Service account username. A service account is an account in your LDAP server that has access to initiate a connection. For example, cn=admin,dc=corp, dc=example,
        /// dc=com.</p>
        pub fn set_service_account_username(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_account_username = input;
            self
        }
        /// <p>Select a particular subtree of the directory information tree (DIT) to search for user entries. The subtree is specified by a DN, which specifies the base node of the subtree. For example, by setting this option to ou=Users,ou=corp, dc=corp,
        /// dc=example, dc=com, the search for user entries is restricted to the subtree beneath ou=Users, ou=corp, dc=corp, dc=example, dc=com.</p>
        pub fn user_base(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_base = Some(input.into());
            self
        }
        /// <p>Select a particular subtree of the directory information tree (DIT) to search for user entries. The subtree is specified by a DN, which specifies the base node of the subtree. For example, by setting this option to ou=Users,ou=corp, dc=corp,
        /// dc=example, dc=com, the search for user entries is restricted to the subtree beneath ou=Users, ou=corp, dc=corp, dc=example, dc=com.</p>
        pub fn set_user_base(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_base = input;
            self
        }
        /// <p>Specifies the name of the LDAP attribute for the user group membership.</p>
        pub fn user_role_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_role_name = Some(input.into());
            self
        }
        /// <p>Specifies the name of the LDAP attribute for the user group membership.</p>
        pub fn set_user_role_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.user_role_name = input;
            self
        }
        /// <p>The LDAP search filter used to find users within the userBase. The client's username is substituted into the {0} placeholder in the search filter. For example, if this option is set to (uid={0}) and the received username is janedoe, the search filter becomes (uid=janedoe) after string substitution. It will result in matching an entry like uid=janedoe, ou=Users,ou=corp, dc=corp, dc=example,
        /// dc=com.</p>
        pub fn user_search_matching(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_search_matching = Some(input.into());
            self
        }
        /// <p>The LDAP search filter used to find users within the userBase. The client's username is substituted into the {0} placeholder in the search filter. For example, if this option is set to (uid={0}) and the received username is janedoe, the search filter becomes (uid=janedoe) after string substitution. It will result in matching an entry like uid=janedoe, ou=Users,ou=corp, dc=corp, dc=example,
        /// dc=com.</p>
        pub fn set_user_search_matching(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.user_search_matching = input;
            self
        }
        /// <p>The directory search scope for the user. If set to true, scope is to search the entire subtree.</p>
        pub fn user_search_subtree(mut self, input: bool) -> Self {
            self.user_search_subtree = Some(input);
            self
        }
        /// <p>The directory search scope for the user. If set to true, scope is to search the entire subtree.</p>
        pub fn set_user_search_subtree(mut self, input: std::option::Option<bool>) -> Self {
            self.user_search_subtree = input;
            self
        }
        /// Consumes the builder and constructs a [`LdapServerMetadataOutput`](crate::model::LdapServerMetadataOutput)
        pub fn build(self) -> crate::model::LdapServerMetadataOutput {
            crate::model::LdapServerMetadataOutput {
                hosts: self.hosts,
                role_base: self.role_base,
                role_name: self.role_name,
                role_search_matching: self.role_search_matching,
                role_search_subtree: self.role_search_subtree.unwrap_or_default(),
                service_account_username: self.service_account_username,
                user_base: self.user_base,
                user_role_name: self.user_role_name,
                user_search_matching: self.user_search_matching,
                user_search_subtree: self.user_search_subtree.unwrap_or_default(),
            }
        }
    }
}
impl LdapServerMetadataOutput {
    /// Creates a new builder-style object to manufacture [`LdapServerMetadataOutput`](crate::model::LdapServerMetadataOutput)
    pub fn builder() -> crate::model::ldap_server_metadata_output::Builder {
        crate::model::ldap_server_metadata_output::Builder::default()
    }
}

/// <p>A list of information about the configuration.</p> <important><p>Does not apply to RabbitMQ brokers.</p></important>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConfigurationId {
    /// <p>Required. The unique ID that Amazon MQ generates for the configuration.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The revision number of the configuration.</p>
    pub revision: i32,
}
impl ConfigurationId {
    /// <p>Required. The unique ID that Amazon MQ generates for the configuration.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The revision number of the configuration.</p>
    pub fn revision(&self) -> i32 {
        self.revision
    }
}
impl std::fmt::Debug for ConfigurationId {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConfigurationId");
        formatter.field("id", &self.id);
        formatter.field("revision", &self.revision);
        formatter.finish()
    }
}
/// See [`ConfigurationId`](crate::model::ConfigurationId)
pub mod configuration_id {
    /// A builder for [`ConfigurationId`](crate::model::ConfigurationId)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) revision: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Required. The unique ID that Amazon MQ generates for the configuration.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>Required. The unique ID that Amazon MQ generates for the configuration.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The revision number of the configuration.</p>
        pub fn revision(mut self, input: i32) -> Self {
            self.revision = Some(input);
            self
        }
        /// <p>The revision number of the configuration.</p>
        pub fn set_revision(mut self, input: std::option::Option<i32>) -> Self {
            self.revision = input;
            self
        }
        /// Consumes the builder and constructs a [`ConfigurationId`](crate::model::ConfigurationId)
        pub fn build(self) -> crate::model::ConfigurationId {
            crate::model::ConfigurationId {
                id: self.id,
                revision: self.revision.unwrap_or_default(),
            }
        }
    }
}
impl ConfigurationId {
    /// Creates a new builder-style object to manufacture [`ConfigurationId`](crate::model::ConfigurationId)
    pub fn builder() -> crate::model::configuration_id::Builder {
        crate::model::configuration_id::Builder::default()
    }
}

/// <p>Optional. The authentication strategy used to secure the broker. The default is SIMPLE.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AuthenticationStrategy {
    #[allow(missing_docs)] // documentation missing in model
    Ldap,
    #[allow(missing_docs)] // documentation missing in model
    Simple,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AuthenticationStrategy {
    fn from(s: &str) -> Self {
        match s {
            "LDAP" => AuthenticationStrategy::Ldap,
            "SIMPLE" => AuthenticationStrategy::Simple,
            other => AuthenticationStrategy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AuthenticationStrategy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AuthenticationStrategy::from(s))
    }
}
impl AuthenticationStrategy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AuthenticationStrategy::Ldap => "LDAP",
            AuthenticationStrategy::Simple => "SIMPLE",
            AuthenticationStrategy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["LDAP", "SIMPLE"]
    }
}
impl AsRef<str> for AuthenticationStrategy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Optional. The metadata of the LDAP server used to authenticate and authorize connections to the broker.</p> <important><p>Does not apply to RabbitMQ brokers.</p></important>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LdapServerMetadataInput {
    /// <p>Specifies the location of the LDAP server such as AWS Directory Service for Microsoft Active Directory . Optional failover server.</p>
    pub hosts: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The distinguished name of the node in the directory information tree (DIT) to search for roles or groups. For example, ou=group, ou=corp, dc=corp,
    /// dc=example, dc=com.</p>
    pub role_base: std::option::Option<std::string::String>,
    /// <p>Specifies the LDAP attribute that identifies the group name attribute in the object returned from the group membership query.</p>
    pub role_name: std::option::Option<std::string::String>,
    /// <p>The LDAP search filter used to find roles within the roleBase. The distinguished name of the user matched by userSearchMatching is substituted into the {0} placeholder in the search filter. The client's username is substituted into the {1} placeholder. For example, if you set this option to (member=uid={1})for the user janedoe, the search filter becomes (member=uid=janedoe) after string substitution. It matches all role entries that have a member attribute equal to uid=janedoe under the subtree selected by the roleBase.</p>
    pub role_search_matching: std::option::Option<std::string::String>,
    /// <p>The directory search scope for the role. If set to true, scope is to search the entire subtree.</p>
    pub role_search_subtree: bool,
    /// <p>Service account password. A service account is an account in your LDAP server that has access to initiate a connection. For example, cn=admin,dc=corp, dc=example,
    /// dc=com.</p>
    pub service_account_password: std::option::Option<std::string::String>,
    /// <p>Service account username. A service account is an account in your LDAP server that has access to initiate a connection. For example, cn=admin,dc=corp, dc=example,
    /// dc=com.</p>
    pub service_account_username: std::option::Option<std::string::String>,
    /// <p>Select a particular subtree of the directory information tree (DIT) to search for user entries. The subtree is specified by a DN, which specifies the base node of the subtree. For example, by setting this option to ou=Users,ou=corp, dc=corp,
    /// dc=example, dc=com, the search for user entries is restricted to the subtree beneath ou=Users, ou=corp, dc=corp, dc=example, dc=com.</p>
    pub user_base: std::option::Option<std::string::String>,
    /// <p>Specifies the name of the LDAP attribute for the user group membership.</p>
    pub user_role_name: std::option::Option<std::string::String>,
    /// <p>The LDAP search filter used to find users within the userBase. The client's username is substituted into the {0} placeholder in the search filter. For example, if this option is set to (uid={0}) and the received username is janedoe, the search filter becomes (uid=janedoe) after string substitution. It will result in matching an entry like uid=janedoe, ou=Users,ou=corp, dc=corp, dc=example,
    /// dc=com.</p>
    pub user_search_matching: std::option::Option<std::string::String>,
    /// <p>The directory search scope for the user. If set to true, scope is to search the entire subtree.</p>
    pub user_search_subtree: bool,
}
impl LdapServerMetadataInput {
    /// <p>Specifies the location of the LDAP server such as AWS Directory Service for Microsoft Active Directory . Optional failover server.</p>
    pub fn hosts(&self) -> std::option::Option<&[std::string::String]> {
        self.hosts.as_deref()
    }
    /// <p>The distinguished name of the node in the directory information tree (DIT) to search for roles or groups. For example, ou=group, ou=corp, dc=corp,
    /// dc=example, dc=com.</p>
    pub fn role_base(&self) -> std::option::Option<&str> {
        self.role_base.as_deref()
    }
    /// <p>Specifies the LDAP attribute that identifies the group name attribute in the object returned from the group membership query.</p>
    pub fn role_name(&self) -> std::option::Option<&str> {
        self.role_name.as_deref()
    }
    /// <p>The LDAP search filter used to find roles within the roleBase. The distinguished name of the user matched by userSearchMatching is substituted into the {0} placeholder in the search filter. The client's username is substituted into the {1} placeholder. For example, if you set this option to (member=uid={1})for the user janedoe, the search filter becomes (member=uid=janedoe) after string substitution. It matches all role entries that have a member attribute equal to uid=janedoe under the subtree selected by the roleBase.</p>
    pub fn role_search_matching(&self) -> std::option::Option<&str> {
        self.role_search_matching.as_deref()
    }
    /// <p>The directory search scope for the role. If set to true, scope is to search the entire subtree.</p>
    pub fn role_search_subtree(&self) -> bool {
        self.role_search_subtree
    }
    /// <p>Service account password. A service account is an account in your LDAP server that has access to initiate a connection. For example, cn=admin,dc=corp, dc=example,
    /// dc=com.</p>
    pub fn service_account_password(&self) -> std::option::Option<&str> {
        self.service_account_password.as_deref()
    }
    /// <p>Service account username. A service account is an account in your LDAP server that has access to initiate a connection. For example, cn=admin,dc=corp, dc=example,
    /// dc=com.</p>
    pub fn service_account_username(&self) -> std::option::Option<&str> {
        self.service_account_username.as_deref()
    }
    /// <p>Select a particular subtree of the directory information tree (DIT) to search for user entries. The subtree is specified by a DN, which specifies the base node of the subtree. For example, by setting this option to ou=Users,ou=corp, dc=corp,
    /// dc=example, dc=com, the search for user entries is restricted to the subtree beneath ou=Users, ou=corp, dc=corp, dc=example, dc=com.</p>
    pub fn user_base(&self) -> std::option::Option<&str> {
        self.user_base.as_deref()
    }
    /// <p>Specifies the name of the LDAP attribute for the user group membership.</p>
    pub fn user_role_name(&self) -> std::option::Option<&str> {
        self.user_role_name.as_deref()
    }
    /// <p>The LDAP search filter used to find users within the userBase. The client's username is substituted into the {0} placeholder in the search filter. For example, if this option is set to (uid={0}) and the received username is janedoe, the search filter becomes (uid=janedoe) after string substitution. It will result in matching an entry like uid=janedoe, ou=Users,ou=corp, dc=corp, dc=example,
    /// dc=com.</p>
    pub fn user_search_matching(&self) -> std::option::Option<&str> {
        self.user_search_matching.as_deref()
    }
    /// <p>The directory search scope for the user. If set to true, scope is to search the entire subtree.</p>
    pub fn user_search_subtree(&self) -> bool {
        self.user_search_subtree
    }
}
impl std::fmt::Debug for LdapServerMetadataInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LdapServerMetadataInput");
        formatter.field("hosts", &self.hosts);
        formatter.field("role_base", &self.role_base);
        formatter.field("role_name", &self.role_name);
        formatter.field("role_search_matching", &self.role_search_matching);
        formatter.field("role_search_subtree", &self.role_search_subtree);
        formatter.field("service_account_password", &self.service_account_password);
        formatter.field("service_account_username", &self.service_account_username);
        formatter.field("user_base", &self.user_base);
        formatter.field("user_role_name", &self.user_role_name);
        formatter.field("user_search_matching", &self.user_search_matching);
        formatter.field("user_search_subtree", &self.user_search_subtree);
        formatter.finish()
    }
}
/// See [`LdapServerMetadataInput`](crate::model::LdapServerMetadataInput)
pub mod ldap_server_metadata_input {
    /// A builder for [`LdapServerMetadataInput`](crate::model::LdapServerMetadataInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hosts: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) role_base: std::option::Option<std::string::String>,
        pub(crate) role_name: std::option::Option<std::string::String>,
        pub(crate) role_search_matching: std::option::Option<std::string::String>,
        pub(crate) role_search_subtree: std::option::Option<bool>,
        pub(crate) service_account_password: std::option::Option<std::string::String>,
        pub(crate) service_account_username: std::option::Option<std::string::String>,
        pub(crate) user_base: std::option::Option<std::string::String>,
        pub(crate) user_role_name: std::option::Option<std::string::String>,
        pub(crate) user_search_matching: std::option::Option<std::string::String>,
        pub(crate) user_search_subtree: std::option::Option<bool>,
    }
    impl Builder {
        /// Appends an item to `hosts`.
        ///
        /// To override the contents of this collection use [`set_hosts`](Self::set_hosts).
        ///
        /// <p>Specifies the location of the LDAP server such as AWS Directory Service for Microsoft Active Directory . Optional failover server.</p>
        pub fn hosts(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.hosts.unwrap_or_default();
            v.push(input.into());
            self.hosts = Some(v);
            self
        }
        /// <p>Specifies the location of the LDAP server such as AWS Directory Service for Microsoft Active Directory . Optional failover server.</p>
        pub fn set_hosts(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.hosts = input;
            self
        }
        /// <p>The distinguished name of the node in the directory information tree (DIT) to search for roles or groups. For example, ou=group, ou=corp, dc=corp,
        /// dc=example, dc=com.</p>
        pub fn role_base(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_base = Some(input.into());
            self
        }
        /// <p>The distinguished name of the node in the directory information tree (DIT) to search for roles or groups. For example, ou=group, ou=corp, dc=corp,
        /// dc=example, dc=com.</p>
        pub fn set_role_base(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_base = input;
            self
        }
        /// <p>Specifies the LDAP attribute that identifies the group name attribute in the object returned from the group membership query.</p>
        pub fn role_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_name = Some(input.into());
            self
        }
        /// <p>Specifies the LDAP attribute that identifies the group name attribute in the object returned from the group membership query.</p>
        pub fn set_role_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_name = input;
            self
        }
        /// <p>The LDAP search filter used to find roles within the roleBase. The distinguished name of the user matched by userSearchMatching is substituted into the {0} placeholder in the search filter. The client's username is substituted into the {1} placeholder. For example, if you set this option to (member=uid={1})for the user janedoe, the search filter becomes (member=uid=janedoe) after string substitution. It matches all role entries that have a member attribute equal to uid=janedoe under the subtree selected by the roleBase.</p>
        pub fn role_search_matching(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_search_matching = Some(input.into());
            self
        }
        /// <p>The LDAP search filter used to find roles within the roleBase. The distinguished name of the user matched by userSearchMatching is substituted into the {0} placeholder in the search filter. The client's username is substituted into the {1} placeholder. For example, if you set this option to (member=uid={1})for the user janedoe, the search filter becomes (member=uid=janedoe) after string substitution. It matches all role entries that have a member attribute equal to uid=janedoe under the subtree selected by the roleBase.</p>
        pub fn set_role_search_matching(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.role_search_matching = input;
            self
        }
        /// <p>The directory search scope for the role. If set to true, scope is to search the entire subtree.</p>
        pub fn role_search_subtree(mut self, input: bool) -> Self {
            self.role_search_subtree = Some(input);
            self
        }
        /// <p>The directory search scope for the role. If set to true, scope is to search the entire subtree.</p>
        pub fn set_role_search_subtree(mut self, input: std::option::Option<bool>) -> Self {
            self.role_search_subtree = input;
            self
        }
        /// <p>Service account password. A service account is an account in your LDAP server that has access to initiate a connection. For example, cn=admin,dc=corp, dc=example,
        /// dc=com.</p>
        pub fn service_account_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_account_password = Some(input.into());
            self
        }
        /// <p>Service account password. A service account is an account in your LDAP server that has access to initiate a connection. For example, cn=admin,dc=corp, dc=example,
        /// dc=com.</p>
        pub fn set_service_account_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_account_password = input;
            self
        }
        /// <p>Service account username. A service account is an account in your LDAP server that has access to initiate a connection. For example, cn=admin,dc=corp, dc=example,
        /// dc=com.</p>
        pub fn service_account_username(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_account_username = Some(input.into());
            self
        }
        /// <p>Service account username. A service account is an account in your LDAP server that has access to initiate a connection. For example, cn=admin,dc=corp, dc=example,
        /// dc=com.</p>
        pub fn set_service_account_username(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_account_username = input;
            self
        }
        /// <p>Select a particular subtree of the directory information tree (DIT) to search for user entries. The subtree is specified by a DN, which specifies the base node of the subtree. For example, by setting this option to ou=Users,ou=corp, dc=corp,
        /// dc=example, dc=com, the search for user entries is restricted to the subtree beneath ou=Users, ou=corp, dc=corp, dc=example, dc=com.</p>
        pub fn user_base(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_base = Some(input.into());
            self
        }
        /// <p>Select a particular subtree of the directory information tree (DIT) to search for user entries. The subtree is specified by a DN, which specifies the base node of the subtree. For example, by setting this option to ou=Users,ou=corp, dc=corp,
        /// dc=example, dc=com, the search for user entries is restricted to the subtree beneath ou=Users, ou=corp, dc=corp, dc=example, dc=com.</p>
        pub fn set_user_base(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_base = input;
            self
        }
        /// <p>Specifies the name of the LDAP attribute for the user group membership.</p>
        pub fn user_role_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_role_name = Some(input.into());
            self
        }
        /// <p>Specifies the name of the LDAP attribute for the user group membership.</p>
        pub fn set_user_role_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.user_role_name = input;
            self
        }
        /// <p>The LDAP search filter used to find users within the userBase. The client's username is substituted into the {0} placeholder in the search filter. For example, if this option is set to (uid={0}) and the received username is janedoe, the search filter becomes (uid=janedoe) after string substitution. It will result in matching an entry like uid=janedoe, ou=Users,ou=corp, dc=corp, dc=example,
        /// dc=com.</p>
        pub fn user_search_matching(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_search_matching = Some(input.into());
            self
        }
        /// <p>The LDAP search filter used to find users within the userBase. The client's username is substituted into the {0} placeholder in the search filter. For example, if this option is set to (uid={0}) and the received username is janedoe, the search filter becomes (uid=janedoe) after string substitution. It will result in matching an entry like uid=janedoe, ou=Users,ou=corp, dc=corp, dc=example,
        /// dc=com.</p>
        pub fn set_user_search_matching(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.user_search_matching = input;
            self
        }
        /// <p>The directory search scope for the user. If set to true, scope is to search the entire subtree.</p>
        pub fn user_search_subtree(mut self, input: bool) -> Self {
            self.user_search_subtree = Some(input);
            self
        }
        /// <p>The directory search scope for the user. If set to true, scope is to search the entire subtree.</p>
        pub fn set_user_search_subtree(mut self, input: std::option::Option<bool>) -> Self {
            self.user_search_subtree = input;
            self
        }
        /// Consumes the builder and constructs a [`LdapServerMetadataInput`](crate::model::LdapServerMetadataInput)
        pub fn build(self) -> crate::model::LdapServerMetadataInput {
            crate::model::LdapServerMetadataInput {
                hosts: self.hosts,
                role_base: self.role_base,
                role_name: self.role_name,
                role_search_matching: self.role_search_matching,
                role_search_subtree: self.role_search_subtree.unwrap_or_default(),
                service_account_password: self.service_account_password,
                service_account_username: self.service_account_username,
                user_base: self.user_base,
                user_role_name: self.user_role_name,
                user_search_matching: self.user_search_matching,
                user_search_subtree: self.user_search_subtree.unwrap_or_default(),
            }
        }
    }
}
impl LdapServerMetadataInput {
    /// Creates a new builder-style object to manufacture [`LdapServerMetadataInput`](crate::model::LdapServerMetadataInput)
    pub fn builder() -> crate::model::ldap_server_metadata_input::Builder {
        crate::model::ldap_server_metadata_input::Builder::default()
    }
}

/// <p>Returns a list of all broker users. Does not apply to RabbitMQ brokers.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserSummary {
    /// <p>The type of change pending for the broker user.</p>
    pub pending_change: std::option::Option<crate::model::ChangeType>,
    /// <p>Required. The username of the broker user. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
    pub username: std::option::Option<std::string::String>,
}
impl UserSummary {
    /// <p>The type of change pending for the broker user.</p>
    pub fn pending_change(&self) -> std::option::Option<&crate::model::ChangeType> {
        self.pending_change.as_ref()
    }
    /// <p>Required. The username of the broker user. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
    pub fn username(&self) -> std::option::Option<&str> {
        self.username.as_deref()
    }
}
impl std::fmt::Debug for UserSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserSummary");
        formatter.field("pending_change", &self.pending_change);
        formatter.field("username", &self.username);
        formatter.finish()
    }
}
/// See [`UserSummary`](crate::model::UserSummary)
pub mod user_summary {
    /// A builder for [`UserSummary`](crate::model::UserSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pending_change: std::option::Option<crate::model::ChangeType>,
        pub(crate) username: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of change pending for the broker user.</p>
        pub fn pending_change(mut self, input: crate::model::ChangeType) -> Self {
            self.pending_change = Some(input);
            self
        }
        /// <p>The type of change pending for the broker user.</p>
        pub fn set_pending_change(
            mut self,
            input: std::option::Option<crate::model::ChangeType>,
        ) -> Self {
            self.pending_change = input;
            self
        }
        /// <p>Required. The username of the broker user. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>Required. The username of the broker user. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// Consumes the builder and constructs a [`UserSummary`](crate::model::UserSummary)
        pub fn build(self) -> crate::model::UserSummary {
            crate::model::UserSummary {
                pending_change: self.pending_change,
                username: self.username,
            }
        }
    }
}
impl UserSummary {
    /// Creates a new builder-style object to manufacture [`UserSummary`](crate::model::UserSummary)
    pub fn builder() -> crate::model::user_summary::Builder {
        crate::model::user_summary::Builder::default()
    }
}

/// <p>The type of change pending for the ActiveMQ user.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ChangeType {
    #[allow(missing_docs)] // documentation missing in model
    Create,
    #[allow(missing_docs)] // documentation missing in model
    Delete,
    #[allow(missing_docs)] // documentation missing in model
    Update,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ChangeType {
    fn from(s: &str) -> Self {
        match s {
            "CREATE" => ChangeType::Create,
            "DELETE" => ChangeType::Delete,
            "UPDATE" => ChangeType::Update,
            other => ChangeType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ChangeType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ChangeType::from(s))
    }
}
impl ChangeType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ChangeType::Create => "CREATE",
            ChangeType::Delete => "DELETE",
            ChangeType::Update => "UPDATE",
            ChangeType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CREATE", "DELETE", "UPDATE"]
    }
}
impl AsRef<str> for ChangeType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Returns information about all configurations.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Configuration {
    /// <p>Required. The ARN of the configuration.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>Optional. The authentication strategy associated with the configuration. The default is SIMPLE.</p>
    pub authentication_strategy: std::option::Option<crate::model::AuthenticationStrategy>,
    /// <p>Required. The date and time of the configuration revision.</p>
    pub created: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Required. The description of the configuration.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Required. The type of broker engine. Currently, Amazon MQ supports ACTIVEMQ and RABBITMQ.</p>
    pub engine_type: std::option::Option<crate::model::EngineType>,
    /// <p>Required. The broker engine's version. For a list of supported engine versions, see, <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines</a>.</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>Required. The unique ID that Amazon MQ generates for the configuration.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>Required. The latest revision of the configuration.</p>
    pub latest_revision: std::option::Option<crate::model::ConfigurationRevision>,
    /// <p>Required. The name of the configuration. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 1-150 characters long.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The list of all tags associated with this configuration.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl Configuration {
    /// <p>Required. The ARN of the configuration.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>Optional. The authentication strategy associated with the configuration. The default is SIMPLE.</p>
    pub fn authentication_strategy(
        &self,
    ) -> std::option::Option<&crate::model::AuthenticationStrategy> {
        self.authentication_strategy.as_ref()
    }
    /// <p>Required. The date and time of the configuration revision.</p>
    pub fn created(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created.as_ref()
    }
    /// <p>Required. The description of the configuration.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Required. The type of broker engine. Currently, Amazon MQ supports ACTIVEMQ and RABBITMQ.</p>
    pub fn engine_type(&self) -> std::option::Option<&crate::model::EngineType> {
        self.engine_type.as_ref()
    }
    /// <p>Required. The broker engine's version. For a list of supported engine versions, see, <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines</a>.</p>
    pub fn engine_version(&self) -> std::option::Option<&str> {
        self.engine_version.as_deref()
    }
    /// <p>Required. The unique ID that Amazon MQ generates for the configuration.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>Required. The latest revision of the configuration.</p>
    pub fn latest_revision(&self) -> std::option::Option<&crate::model::ConfigurationRevision> {
        self.latest_revision.as_ref()
    }
    /// <p>Required. The name of the configuration. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 1-150 characters long.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The list of all tags associated with this configuration.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for Configuration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Configuration");
        formatter.field("arn", &self.arn);
        formatter.field("authentication_strategy", &self.authentication_strategy);
        formatter.field("created", &self.created);
        formatter.field("description", &self.description);
        formatter.field("engine_type", &self.engine_type);
        formatter.field("engine_version", &self.engine_version);
        formatter.field("id", &self.id);
        formatter.field("latest_revision", &self.latest_revision);
        formatter.field("name", &self.name);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`Configuration`](crate::model::Configuration)
pub mod configuration {
    /// A builder for [`Configuration`](crate::model::Configuration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) authentication_strategy:
            std::option::Option<crate::model::AuthenticationStrategy>,
        pub(crate) created: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) engine_type: std::option::Option<crate::model::EngineType>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) latest_revision: std::option::Option<crate::model::ConfigurationRevision>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>Required. The ARN of the configuration.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>Required. The ARN of the configuration.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>Optional. The authentication strategy associated with the configuration. The default is SIMPLE.</p>
        pub fn authentication_strategy(
            mut self,
            input: crate::model::AuthenticationStrategy,
        ) -> Self {
            self.authentication_strategy = Some(input);
            self
        }
        /// <p>Optional. The authentication strategy associated with the configuration. The default is SIMPLE.</p>
        pub fn set_authentication_strategy(
            mut self,
            input: std::option::Option<crate::model::AuthenticationStrategy>,
        ) -> Self {
            self.authentication_strategy = input;
            self
        }
        /// <p>Required. The date and time of the configuration revision.</p>
        pub fn created(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created = Some(input);
            self
        }
        /// <p>Required. The date and time of the configuration revision.</p>
        pub fn set_created(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created = input;
            self
        }
        /// <p>Required. The description of the configuration.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Required. The description of the configuration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Required. The type of broker engine. Currently, Amazon MQ supports ACTIVEMQ and RABBITMQ.</p>
        pub fn engine_type(mut self, input: crate::model::EngineType) -> Self {
            self.engine_type = Some(input);
            self
        }
        /// <p>Required. The type of broker engine. Currently, Amazon MQ supports ACTIVEMQ and RABBITMQ.</p>
        pub fn set_engine_type(
            mut self,
            input: std::option::Option<crate::model::EngineType>,
        ) -> Self {
            self.engine_type = input;
            self
        }
        /// <p>Required. The broker engine's version. For a list of supported engine versions, see, <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines</a>.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>Required. The broker engine's version. For a list of supported engine versions, see, <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines</a>.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>Required. The unique ID that Amazon MQ generates for the configuration.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>Required. The unique ID that Amazon MQ generates for the configuration.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>Required. The latest revision of the configuration.</p>
        pub fn latest_revision(mut self, input: crate::model::ConfigurationRevision) -> Self {
            self.latest_revision = Some(input);
            self
        }
        /// <p>Required. The latest revision of the configuration.</p>
        pub fn set_latest_revision(
            mut self,
            input: std::option::Option<crate::model::ConfigurationRevision>,
        ) -> Self {
            self.latest_revision = input;
            self
        }
        /// <p>Required. The name of the configuration. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 1-150 characters long.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Required. The name of the configuration. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 1-150 characters long.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of all tags associated with this configuration.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The list of all tags associated with this configuration.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`Configuration`](crate::model::Configuration)
        pub fn build(self) -> crate::model::Configuration {
            crate::model::Configuration {
                arn: self.arn,
                authentication_strategy: self.authentication_strategy,
                created: self.created,
                description: self.description,
                engine_type: self.engine_type,
                engine_version: self.engine_version,
                id: self.id,
                latest_revision: self.latest_revision,
                name: self.name,
                tags: self.tags,
            }
        }
    }
}
impl Configuration {
    /// Creates a new builder-style object to manufacture [`Configuration`](crate::model::Configuration)
    pub fn builder() -> crate::model::configuration::Builder {
        crate::model::configuration::Builder::default()
    }
}

/// <p>The type of broker engine. Amazon MQ supports ActiveMQ and RabbitMQ.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EngineType {
    #[allow(missing_docs)] // documentation missing in model
    Activemq,
    #[allow(missing_docs)] // documentation missing in model
    Rabbitmq,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EngineType {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVEMQ" => EngineType::Activemq,
            "RABBITMQ" => EngineType::Rabbitmq,
            other => EngineType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EngineType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EngineType::from(s))
    }
}
impl EngineType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EngineType::Activemq => "ACTIVEMQ",
            EngineType::Rabbitmq => "RABBITMQ",
            EngineType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVEMQ", "RABBITMQ"]
    }
}
impl AsRef<str> for EngineType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Returns information about all brokers.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BrokerSummary {
    /// <p>The broker's Amazon Resource Name (ARN).</p>
    pub broker_arn: std::option::Option<std::string::String>,
    /// <p>The unique ID that Amazon MQ generates for the broker.</p>
    pub broker_id: std::option::Option<std::string::String>,
    /// <p>The broker's name. This value is unique in your AWS account, 1-50 characters long, and containing only letters, numbers, dashes, and underscores, and must not contain white spaces, brackets, wildcard characters, or special characters.</p>
    pub broker_name: std::option::Option<std::string::String>,
    /// <p>The broker's status.</p>
    pub broker_state: std::option::Option<crate::model::BrokerState>,
    /// <p>The time when the broker was created.</p>
    pub created: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The broker's deployment mode.</p>
    pub deployment_mode: std::option::Option<crate::model::DeploymentMode>,
    /// <p>The type of broker engine.</p>
    pub engine_type: std::option::Option<crate::model::EngineType>,
    /// <p>The broker's instance type.</p>
    pub host_instance_type: std::option::Option<std::string::String>,
}
impl BrokerSummary {
    /// <p>The broker's Amazon Resource Name (ARN).</p>
    pub fn broker_arn(&self) -> std::option::Option<&str> {
        self.broker_arn.as_deref()
    }
    /// <p>The unique ID that Amazon MQ generates for the broker.</p>
    pub fn broker_id(&self) -> std::option::Option<&str> {
        self.broker_id.as_deref()
    }
    /// <p>The broker's name. This value is unique in your AWS account, 1-50 characters long, and containing only letters, numbers, dashes, and underscores, and must not contain white spaces, brackets, wildcard characters, or special characters.</p>
    pub fn broker_name(&self) -> std::option::Option<&str> {
        self.broker_name.as_deref()
    }
    /// <p>The broker's status.</p>
    pub fn broker_state(&self) -> std::option::Option<&crate::model::BrokerState> {
        self.broker_state.as_ref()
    }
    /// <p>The time when the broker was created.</p>
    pub fn created(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created.as_ref()
    }
    /// <p>The broker's deployment mode.</p>
    pub fn deployment_mode(&self) -> std::option::Option<&crate::model::DeploymentMode> {
        self.deployment_mode.as_ref()
    }
    /// <p>The type of broker engine.</p>
    pub fn engine_type(&self) -> std::option::Option<&crate::model::EngineType> {
        self.engine_type.as_ref()
    }
    /// <p>The broker's instance type.</p>
    pub fn host_instance_type(&self) -> std::option::Option<&str> {
        self.host_instance_type.as_deref()
    }
}
impl std::fmt::Debug for BrokerSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BrokerSummary");
        formatter.field("broker_arn", &self.broker_arn);
        formatter.field("broker_id", &self.broker_id);
        formatter.field("broker_name", &self.broker_name);
        formatter.field("broker_state", &self.broker_state);
        formatter.field("created", &self.created);
        formatter.field("deployment_mode", &self.deployment_mode);
        formatter.field("engine_type", &self.engine_type);
        formatter.field("host_instance_type", &self.host_instance_type);
        formatter.finish()
    }
}
/// See [`BrokerSummary`](crate::model::BrokerSummary)
pub mod broker_summary {
    /// A builder for [`BrokerSummary`](crate::model::BrokerSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) broker_arn: std::option::Option<std::string::String>,
        pub(crate) broker_id: std::option::Option<std::string::String>,
        pub(crate) broker_name: std::option::Option<std::string::String>,
        pub(crate) broker_state: std::option::Option<crate::model::BrokerState>,
        pub(crate) created: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) deployment_mode: std::option::Option<crate::model::DeploymentMode>,
        pub(crate) engine_type: std::option::Option<crate::model::EngineType>,
        pub(crate) host_instance_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The broker's Amazon Resource Name (ARN).</p>
        pub fn broker_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.broker_arn = Some(input.into());
            self
        }
        /// <p>The broker's Amazon Resource Name (ARN).</p>
        pub fn set_broker_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.broker_arn = input;
            self
        }
        /// <p>The unique ID that Amazon MQ generates for the broker.</p>
        pub fn broker_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.broker_id = Some(input.into());
            self
        }
        /// <p>The unique ID that Amazon MQ generates for the broker.</p>
        pub fn set_broker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.broker_id = input;
            self
        }
        /// <p>The broker's name. This value is unique in your AWS account, 1-50 characters long, and containing only letters, numbers, dashes, and underscores, and must not contain white spaces, brackets, wildcard characters, or special characters.</p>
        pub fn broker_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.broker_name = Some(input.into());
            self
        }
        /// <p>The broker's name. This value is unique in your AWS account, 1-50 characters long, and containing only letters, numbers, dashes, and underscores, and must not contain white spaces, brackets, wildcard characters, or special characters.</p>
        pub fn set_broker_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.broker_name = input;
            self
        }
        /// <p>The broker's status.</p>
        pub fn broker_state(mut self, input: crate::model::BrokerState) -> Self {
            self.broker_state = Some(input);
            self
        }
        /// <p>The broker's status.</p>
        pub fn set_broker_state(
            mut self,
            input: std::option::Option<crate::model::BrokerState>,
        ) -> Self {
            self.broker_state = input;
            self
        }
        /// <p>The time when the broker was created.</p>
        pub fn created(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created = Some(input);
            self
        }
        /// <p>The time when the broker was created.</p>
        pub fn set_created(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created = input;
            self
        }
        /// <p>The broker's deployment mode.</p>
        pub fn deployment_mode(mut self, input: crate::model::DeploymentMode) -> Self {
            self.deployment_mode = Some(input);
            self
        }
        /// <p>The broker's deployment mode.</p>
        pub fn set_deployment_mode(
            mut self,
            input: std::option::Option<crate::model::DeploymentMode>,
        ) -> Self {
            self.deployment_mode = input;
            self
        }
        /// <p>The type of broker engine.</p>
        pub fn engine_type(mut self, input: crate::model::EngineType) -> Self {
            self.engine_type = Some(input);
            self
        }
        /// <p>The type of broker engine.</p>
        pub fn set_engine_type(
            mut self,
            input: std::option::Option<crate::model::EngineType>,
        ) -> Self {
            self.engine_type = input;
            self
        }
        /// <p>The broker's instance type.</p>
        pub fn host_instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.host_instance_type = Some(input.into());
            self
        }
        /// <p>The broker's instance type.</p>
        pub fn set_host_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.host_instance_type = input;
            self
        }
        /// Consumes the builder and constructs a [`BrokerSummary`](crate::model::BrokerSummary)
        pub fn build(self) -> crate::model::BrokerSummary {
            crate::model::BrokerSummary {
                broker_arn: self.broker_arn,
                broker_id: self.broker_id,
                broker_name: self.broker_name,
                broker_state: self.broker_state,
                created: self.created,
                deployment_mode: self.deployment_mode,
                engine_type: self.engine_type,
                host_instance_type: self.host_instance_type,
            }
        }
    }
}
impl BrokerSummary {
    /// Creates a new builder-style object to manufacture [`BrokerSummary`](crate::model::BrokerSummary)
    pub fn builder() -> crate::model::broker_summary::Builder {
        crate::model::broker_summary::Builder::default()
    }
}

/// <p>The broker's deployment mode.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeploymentMode {
    #[allow(missing_docs)] // documentation missing in model
    ActiveStandbyMultiAz,
    #[allow(missing_docs)] // documentation missing in model
    ClusterMultiAz,
    #[allow(missing_docs)] // documentation missing in model
    SingleInstance,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeploymentMode {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE_STANDBY_MULTI_AZ" => DeploymentMode::ActiveStandbyMultiAz,
            "CLUSTER_MULTI_AZ" => DeploymentMode::ClusterMultiAz,
            "SINGLE_INSTANCE" => DeploymentMode::SingleInstance,
            other => DeploymentMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeploymentMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeploymentMode::from(s))
    }
}
impl DeploymentMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeploymentMode::ActiveStandbyMultiAz => "ACTIVE_STANDBY_MULTI_AZ",
            DeploymentMode::ClusterMultiAz => "CLUSTER_MULTI_AZ",
            DeploymentMode::SingleInstance => "SINGLE_INSTANCE",
            DeploymentMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTIVE_STANDBY_MULTI_AZ",
            "CLUSTER_MULTI_AZ",
            "SINGLE_INSTANCE",
        ]
    }
}
impl AsRef<str> for DeploymentMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The broker's status.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BrokerState {
    #[allow(missing_docs)] // documentation missing in model
    CreationFailed,
    #[allow(missing_docs)] // documentation missing in model
    CreationInProgress,
    #[allow(missing_docs)] // documentation missing in model
    DeletionInProgress,
    #[allow(missing_docs)] // documentation missing in model
    RebootInProgress,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BrokerState {
    fn from(s: &str) -> Self {
        match s {
            "CREATION_FAILED" => BrokerState::CreationFailed,
            "CREATION_IN_PROGRESS" => BrokerState::CreationInProgress,
            "DELETION_IN_PROGRESS" => BrokerState::DeletionInProgress,
            "REBOOT_IN_PROGRESS" => BrokerState::RebootInProgress,
            "RUNNING" => BrokerState::Running,
            other => BrokerState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BrokerState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BrokerState::from(s))
    }
}
impl BrokerState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BrokerState::CreationFailed => "CREATION_FAILED",
            BrokerState::CreationInProgress => "CREATION_IN_PROGRESS",
            BrokerState::DeletionInProgress => "DELETION_IN_PROGRESS",
            BrokerState::RebootInProgress => "REBOOT_IN_PROGRESS",
            BrokerState::Running => "RUNNING",
            BrokerState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CREATION_FAILED",
            "CREATION_IN_PROGRESS",
            "DELETION_IN_PROGRESS",
            "REBOOT_IN_PROGRESS",
            "RUNNING",
        ]
    }
}
impl AsRef<str> for BrokerState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Returns information about the status of the changes pending for the ActiveMQ user.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserPendingChanges {
    /// <p>Enables access to the the ActiveMQ Web Console for the ActiveMQ user.</p>
    pub console_access: bool,
    /// <p>The list of groups (20 maximum) to which the ActiveMQ user belongs. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
    pub groups: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Required. The type of change pending for the ActiveMQ user.</p>
    pub pending_change: std::option::Option<crate::model::ChangeType>,
}
impl UserPendingChanges {
    /// <p>Enables access to the the ActiveMQ Web Console for the ActiveMQ user.</p>
    pub fn console_access(&self) -> bool {
        self.console_access
    }
    /// <p>The list of groups (20 maximum) to which the ActiveMQ user belongs. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
    pub fn groups(&self) -> std::option::Option<&[std::string::String]> {
        self.groups.as_deref()
    }
    /// <p>Required. The type of change pending for the ActiveMQ user.</p>
    pub fn pending_change(&self) -> std::option::Option<&crate::model::ChangeType> {
        self.pending_change.as_ref()
    }
}
impl std::fmt::Debug for UserPendingChanges {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserPendingChanges");
        formatter.field("console_access", &self.console_access);
        formatter.field("groups", &self.groups);
        formatter.field("pending_change", &self.pending_change);
        formatter.finish()
    }
}
/// See [`UserPendingChanges`](crate::model::UserPendingChanges)
pub mod user_pending_changes {
    /// A builder for [`UserPendingChanges`](crate::model::UserPendingChanges)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) console_access: std::option::Option<bool>,
        pub(crate) groups: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) pending_change: std::option::Option<crate::model::ChangeType>,
    }
    impl Builder {
        /// <p>Enables access to the the ActiveMQ Web Console for the ActiveMQ user.</p>
        pub fn console_access(mut self, input: bool) -> Self {
            self.console_access = Some(input);
            self
        }
        /// <p>Enables access to the the ActiveMQ Web Console for the ActiveMQ user.</p>
        pub fn set_console_access(mut self, input: std::option::Option<bool>) -> Self {
            self.console_access = input;
            self
        }
        /// Appends an item to `groups`.
        ///
        /// To override the contents of this collection use [`set_groups`](Self::set_groups).
        ///
        /// <p>The list of groups (20 maximum) to which the ActiveMQ user belongs. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
        pub fn groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.groups.unwrap_or_default();
            v.push(input.into());
            self.groups = Some(v);
            self
        }
        /// <p>The list of groups (20 maximum) to which the ActiveMQ user belongs. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
        pub fn set_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.groups = input;
            self
        }
        /// <p>Required. The type of change pending for the ActiveMQ user.</p>
        pub fn pending_change(mut self, input: crate::model::ChangeType) -> Self {
            self.pending_change = Some(input);
            self
        }
        /// <p>Required. The type of change pending for the ActiveMQ user.</p>
        pub fn set_pending_change(
            mut self,
            input: std::option::Option<crate::model::ChangeType>,
        ) -> Self {
            self.pending_change = input;
            self
        }
        /// Consumes the builder and constructs a [`UserPendingChanges`](crate::model::UserPendingChanges)
        pub fn build(self) -> crate::model::UserPendingChanges {
            crate::model::UserPendingChanges {
                console_access: self.console_access.unwrap_or_default(),
                groups: self.groups,
                pending_change: self.pending_change,
            }
        }
    }
}
impl UserPendingChanges {
    /// Creates a new builder-style object to manufacture [`UserPendingChanges`](crate::model::UserPendingChanges)
    pub fn builder() -> crate::model::user_pending_changes::Builder {
        crate::model::user_pending_changes::Builder::default()
    }
}

/// <p>Option for host instance type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BrokerInstanceOption {
    /// <p>The list of available az.</p>
    pub availability_zones: std::option::Option<std::vec::Vec<crate::model::AvailabilityZone>>,
    /// <p>The broker's engine type.</p>
    pub engine_type: std::option::Option<crate::model::EngineType>,
    /// <p>The broker's instance type.</p>
    pub host_instance_type: std::option::Option<std::string::String>,
    /// <p>The broker's storage type.</p>
    pub storage_type: std::option::Option<crate::model::BrokerStorageType>,
    /// <p>The list of supported deployment modes.</p>
    pub supported_deployment_modes:
        std::option::Option<std::vec::Vec<crate::model::DeploymentMode>>,
    /// <p>The list of supported engine versions.</p>
    pub supported_engine_versions: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl BrokerInstanceOption {
    /// <p>The list of available az.</p>
    pub fn availability_zones(&self) -> std::option::Option<&[crate::model::AvailabilityZone]> {
        self.availability_zones.as_deref()
    }
    /// <p>The broker's engine type.</p>
    pub fn engine_type(&self) -> std::option::Option<&crate::model::EngineType> {
        self.engine_type.as_ref()
    }
    /// <p>The broker's instance type.</p>
    pub fn host_instance_type(&self) -> std::option::Option<&str> {
        self.host_instance_type.as_deref()
    }
    /// <p>The broker's storage type.</p>
    pub fn storage_type(&self) -> std::option::Option<&crate::model::BrokerStorageType> {
        self.storage_type.as_ref()
    }
    /// <p>The list of supported deployment modes.</p>
    pub fn supported_deployment_modes(
        &self,
    ) -> std::option::Option<&[crate::model::DeploymentMode]> {
        self.supported_deployment_modes.as_deref()
    }
    /// <p>The list of supported engine versions.</p>
    pub fn supported_engine_versions(&self) -> std::option::Option<&[std::string::String]> {
        self.supported_engine_versions.as_deref()
    }
}
impl std::fmt::Debug for BrokerInstanceOption {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BrokerInstanceOption");
        formatter.field("availability_zones", &self.availability_zones);
        formatter.field("engine_type", &self.engine_type);
        formatter.field("host_instance_type", &self.host_instance_type);
        formatter.field("storage_type", &self.storage_type);
        formatter.field(
            "supported_deployment_modes",
            &self.supported_deployment_modes,
        );
        formatter.field("supported_engine_versions", &self.supported_engine_versions);
        formatter.finish()
    }
}
/// See [`BrokerInstanceOption`](crate::model::BrokerInstanceOption)
pub mod broker_instance_option {
    /// A builder for [`BrokerInstanceOption`](crate::model::BrokerInstanceOption)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) availability_zones:
            std::option::Option<std::vec::Vec<crate::model::AvailabilityZone>>,
        pub(crate) engine_type: std::option::Option<crate::model::EngineType>,
        pub(crate) host_instance_type: std::option::Option<std::string::String>,
        pub(crate) storage_type: std::option::Option<crate::model::BrokerStorageType>,
        pub(crate) supported_deployment_modes:
            std::option::Option<std::vec::Vec<crate::model::DeploymentMode>>,
        pub(crate) supported_engine_versions:
            std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `availability_zones`.
        ///
        /// To override the contents of this collection use [`set_availability_zones`](Self::set_availability_zones).
        ///
        /// <p>The list of available az.</p>
        pub fn availability_zones(
            mut self,
            input: impl Into<crate::model::AvailabilityZone>,
        ) -> Self {
            let mut v = self.availability_zones.unwrap_or_default();
            v.push(input.into());
            self.availability_zones = Some(v);
            self
        }
        /// <p>The list of available az.</p>
        pub fn set_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AvailabilityZone>>,
        ) -> Self {
            self.availability_zones = input;
            self
        }
        /// <p>The broker's engine type.</p>
        pub fn engine_type(mut self, input: crate::model::EngineType) -> Self {
            self.engine_type = Some(input);
            self
        }
        /// <p>The broker's engine type.</p>
        pub fn set_engine_type(
            mut self,
            input: std::option::Option<crate::model::EngineType>,
        ) -> Self {
            self.engine_type = input;
            self
        }
        /// <p>The broker's instance type.</p>
        pub fn host_instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.host_instance_type = Some(input.into());
            self
        }
        /// <p>The broker's instance type.</p>
        pub fn set_host_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.host_instance_type = input;
            self
        }
        /// <p>The broker's storage type.</p>
        pub fn storage_type(mut self, input: crate::model::BrokerStorageType) -> Self {
            self.storage_type = Some(input);
            self
        }
        /// <p>The broker's storage type.</p>
        pub fn set_storage_type(
            mut self,
            input: std::option::Option<crate::model::BrokerStorageType>,
        ) -> Self {
            self.storage_type = input;
            self
        }
        /// Appends an item to `supported_deployment_modes`.
        ///
        /// To override the contents of this collection use [`set_supported_deployment_modes`](Self::set_supported_deployment_modes).
        ///
        /// <p>The list of supported deployment modes.</p>
        pub fn supported_deployment_modes(
            mut self,
            input: impl Into<crate::model::DeploymentMode>,
        ) -> Self {
            let mut v = self.supported_deployment_modes.unwrap_or_default();
            v.push(input.into());
            self.supported_deployment_modes = Some(v);
            self
        }
        /// <p>The list of supported deployment modes.</p>
        pub fn set_supported_deployment_modes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DeploymentMode>>,
        ) -> Self {
            self.supported_deployment_modes = input;
            self
        }
        /// Appends an item to `supported_engine_versions`.
        ///
        /// To override the contents of this collection use [`set_supported_engine_versions`](Self::set_supported_engine_versions).
        ///
        /// <p>The list of supported engine versions.</p>
        pub fn supported_engine_versions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.supported_engine_versions.unwrap_or_default();
            v.push(input.into());
            self.supported_engine_versions = Some(v);
            self
        }
        /// <p>The list of supported engine versions.</p>
        pub fn set_supported_engine_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.supported_engine_versions = input;
            self
        }
        /// Consumes the builder and constructs a [`BrokerInstanceOption`](crate::model::BrokerInstanceOption)
        pub fn build(self) -> crate::model::BrokerInstanceOption {
            crate::model::BrokerInstanceOption {
                availability_zones: self.availability_zones,
                engine_type: self.engine_type,
                host_instance_type: self.host_instance_type,
                storage_type: self.storage_type,
                supported_deployment_modes: self.supported_deployment_modes,
                supported_engine_versions: self.supported_engine_versions,
            }
        }
    }
}
impl BrokerInstanceOption {
    /// Creates a new builder-style object to manufacture [`BrokerInstanceOption`](crate::model::BrokerInstanceOption)
    pub fn builder() -> crate::model::broker_instance_option::Builder {
        crate::model::broker_instance_option::Builder::default()
    }
}

/// <p>The broker's storage type.</p> <important><p>EFS is not supported for RabbitMQ engine type.</p></important>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BrokerStorageType {
    #[allow(missing_docs)] // documentation missing in model
    Ebs,
    #[allow(missing_docs)] // documentation missing in model
    Efs,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BrokerStorageType {
    fn from(s: &str) -> Self {
        match s {
            "EBS" => BrokerStorageType::Ebs,
            "EFS" => BrokerStorageType::Efs,
            other => BrokerStorageType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BrokerStorageType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BrokerStorageType::from(s))
    }
}
impl BrokerStorageType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BrokerStorageType::Ebs => "EBS",
            BrokerStorageType::Efs => "EFS",
            BrokerStorageType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["EBS", "EFS"]
    }
}
impl AsRef<str> for BrokerStorageType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Name of the availability zone.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AvailabilityZone {
    /// <p>Id for the availability zone.</p>
    pub name: std::option::Option<std::string::String>,
}
impl AvailabilityZone {
    /// <p>Id for the availability zone.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for AvailabilityZone {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AvailabilityZone");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`AvailabilityZone`](crate::model::AvailabilityZone)
pub mod availability_zone {
    /// A builder for [`AvailabilityZone`](crate::model::AvailabilityZone)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Id for the availability zone.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Id for the availability zone.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`AvailabilityZone`](crate::model::AvailabilityZone)
        pub fn build(self) -> crate::model::AvailabilityZone {
            crate::model::AvailabilityZone { name: self.name }
        }
    }
}
impl AvailabilityZone {
    /// Creates a new builder-style object to manufacture [`AvailabilityZone`](crate::model::AvailabilityZone)
    pub fn builder() -> crate::model::availability_zone::Builder {
        crate::model::availability_zone::Builder::default()
    }
}

/// <p>Types of broker engines.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BrokerEngineType {
    /// <p>The broker's engine type.</p>
    pub engine_type: std::option::Option<crate::model::EngineType>,
    /// <p>The list of engine versions.</p>
    pub engine_versions: std::option::Option<std::vec::Vec<crate::model::EngineVersion>>,
}
impl BrokerEngineType {
    /// <p>The broker's engine type.</p>
    pub fn engine_type(&self) -> std::option::Option<&crate::model::EngineType> {
        self.engine_type.as_ref()
    }
    /// <p>The list of engine versions.</p>
    pub fn engine_versions(&self) -> std::option::Option<&[crate::model::EngineVersion]> {
        self.engine_versions.as_deref()
    }
}
impl std::fmt::Debug for BrokerEngineType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BrokerEngineType");
        formatter.field("engine_type", &self.engine_type);
        formatter.field("engine_versions", &self.engine_versions);
        formatter.finish()
    }
}
/// See [`BrokerEngineType`](crate::model::BrokerEngineType)
pub mod broker_engine_type {
    /// A builder for [`BrokerEngineType`](crate::model::BrokerEngineType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) engine_type: std::option::Option<crate::model::EngineType>,
        pub(crate) engine_versions: std::option::Option<std::vec::Vec<crate::model::EngineVersion>>,
    }
    impl Builder {
        /// <p>The broker's engine type.</p>
        pub fn engine_type(mut self, input: crate::model::EngineType) -> Self {
            self.engine_type = Some(input);
            self
        }
        /// <p>The broker's engine type.</p>
        pub fn set_engine_type(
            mut self,
            input: std::option::Option<crate::model::EngineType>,
        ) -> Self {
            self.engine_type = input;
            self
        }
        /// Appends an item to `engine_versions`.
        ///
        /// To override the contents of this collection use [`set_engine_versions`](Self::set_engine_versions).
        ///
        /// <p>The list of engine versions.</p>
        pub fn engine_versions(mut self, input: impl Into<crate::model::EngineVersion>) -> Self {
            let mut v = self.engine_versions.unwrap_or_default();
            v.push(input.into());
            self.engine_versions = Some(v);
            self
        }
        /// <p>The list of engine versions.</p>
        pub fn set_engine_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EngineVersion>>,
        ) -> Self {
            self.engine_versions = input;
            self
        }
        /// Consumes the builder and constructs a [`BrokerEngineType`](crate::model::BrokerEngineType)
        pub fn build(self) -> crate::model::BrokerEngineType {
            crate::model::BrokerEngineType {
                engine_type: self.engine_type,
                engine_versions: self.engine_versions,
            }
        }
    }
}
impl BrokerEngineType {
    /// Creates a new builder-style object to manufacture [`BrokerEngineType`](crate::model::BrokerEngineType)
    pub fn builder() -> crate::model::broker_engine_type::Builder {
        crate::model::broker_engine_type::Builder::default()
    }
}

/// <p>Id of the engine version.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EngineVersion {
    /// <p>Id for the version.</p>
    pub name: std::option::Option<std::string::String>,
}
impl EngineVersion {
    /// <p>Id for the version.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for EngineVersion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EngineVersion");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`EngineVersion`](crate::model::EngineVersion)
pub mod engine_version {
    /// A builder for [`EngineVersion`](crate::model::EngineVersion)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Id for the version.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Id for the version.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`EngineVersion`](crate::model::EngineVersion)
        pub fn build(self) -> crate::model::EngineVersion {
            crate::model::EngineVersion { name: self.name }
        }
    }
}
impl EngineVersion {
    /// Creates a new builder-style object to manufacture [`EngineVersion`](crate::model::EngineVersion)
    pub fn builder() -> crate::model::engine_version::Builder {
        crate::model::engine_version::Builder::default()
    }
}

/// <p>The list of information about logs currently enabled and pending to be deployed for the specified broker.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LogsSummary {
    /// <p>Enables audit logging. Every user management action made using JMX or the ActiveMQ Web Console is logged.</p>
    pub audit: bool,
    /// <p>The location of the CloudWatch Logs log group where audit logs are sent.</p>
    pub audit_log_group: std::option::Option<std::string::String>,
    /// <p>Enables general logging.</p>
    pub general: bool,
    /// <p>The location of the CloudWatch Logs log group where general logs are sent.</p>
    pub general_log_group: std::option::Option<std::string::String>,
    /// <p>The list of information about logs pending to be deployed for the specified broker.</p>
    pub pending: std::option::Option<crate::model::PendingLogs>,
}
impl LogsSummary {
    /// <p>Enables audit logging. Every user management action made using JMX or the ActiveMQ Web Console is logged.</p>
    pub fn audit(&self) -> bool {
        self.audit
    }
    /// <p>The location of the CloudWatch Logs log group where audit logs are sent.</p>
    pub fn audit_log_group(&self) -> std::option::Option<&str> {
        self.audit_log_group.as_deref()
    }
    /// <p>Enables general logging.</p>
    pub fn general(&self) -> bool {
        self.general
    }
    /// <p>The location of the CloudWatch Logs log group where general logs are sent.</p>
    pub fn general_log_group(&self) -> std::option::Option<&str> {
        self.general_log_group.as_deref()
    }
    /// <p>The list of information about logs pending to be deployed for the specified broker.</p>
    pub fn pending(&self) -> std::option::Option<&crate::model::PendingLogs> {
        self.pending.as_ref()
    }
}
impl std::fmt::Debug for LogsSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LogsSummary");
        formatter.field("audit", &self.audit);
        formatter.field("audit_log_group", &self.audit_log_group);
        formatter.field("general", &self.general);
        formatter.field("general_log_group", &self.general_log_group);
        formatter.field("pending", &self.pending);
        formatter.finish()
    }
}
/// See [`LogsSummary`](crate::model::LogsSummary)
pub mod logs_summary {
    /// A builder for [`LogsSummary`](crate::model::LogsSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) audit: std::option::Option<bool>,
        pub(crate) audit_log_group: std::option::Option<std::string::String>,
        pub(crate) general: std::option::Option<bool>,
        pub(crate) general_log_group: std::option::Option<std::string::String>,
        pub(crate) pending: std::option::Option<crate::model::PendingLogs>,
    }
    impl Builder {
        /// <p>Enables audit logging. Every user management action made using JMX or the ActiveMQ Web Console is logged.</p>
        pub fn audit(mut self, input: bool) -> Self {
            self.audit = Some(input);
            self
        }
        /// <p>Enables audit logging. Every user management action made using JMX or the ActiveMQ Web Console is logged.</p>
        pub fn set_audit(mut self, input: std::option::Option<bool>) -> Self {
            self.audit = input;
            self
        }
        /// <p>The location of the CloudWatch Logs log group where audit logs are sent.</p>
        pub fn audit_log_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.audit_log_group = Some(input.into());
            self
        }
        /// <p>The location of the CloudWatch Logs log group where audit logs are sent.</p>
        pub fn set_audit_log_group(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.audit_log_group = input;
            self
        }
        /// <p>Enables general logging.</p>
        pub fn general(mut self, input: bool) -> Self {
            self.general = Some(input);
            self
        }
        /// <p>Enables general logging.</p>
        pub fn set_general(mut self, input: std::option::Option<bool>) -> Self {
            self.general = input;
            self
        }
        /// <p>The location of the CloudWatch Logs log group where general logs are sent.</p>
        pub fn general_log_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.general_log_group = Some(input.into());
            self
        }
        /// <p>The location of the CloudWatch Logs log group where general logs are sent.</p>
        pub fn set_general_log_group(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.general_log_group = input;
            self
        }
        /// <p>The list of information about logs pending to be deployed for the specified broker.</p>
        pub fn pending(mut self, input: crate::model::PendingLogs) -> Self {
            self.pending = Some(input);
            self
        }
        /// <p>The list of information about logs pending to be deployed for the specified broker.</p>
        pub fn set_pending(
            mut self,
            input: std::option::Option<crate::model::PendingLogs>,
        ) -> Self {
            self.pending = input;
            self
        }
        /// Consumes the builder and constructs a [`LogsSummary`](crate::model::LogsSummary)
        pub fn build(self) -> crate::model::LogsSummary {
            crate::model::LogsSummary {
                audit: self.audit.unwrap_or_default(),
                audit_log_group: self.audit_log_group,
                general: self.general.unwrap_or_default(),
                general_log_group: self.general_log_group,
                pending: self.pending,
            }
        }
    }
}
impl LogsSummary {
    /// Creates a new builder-style object to manufacture [`LogsSummary`](crate::model::LogsSummary)
    pub fn builder() -> crate::model::logs_summary::Builder {
        crate::model::logs_summary::Builder::default()
    }
}

/// <p>The list of information about logs to be enabled for the specified broker.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PendingLogs {
    /// <p>Enables audit logging. Every user management action made using JMX or the ActiveMQ Web Console is logged.</p>
    pub audit: bool,
    /// <p>Enables general logging.</p>
    pub general: bool,
}
impl PendingLogs {
    /// <p>Enables audit logging. Every user management action made using JMX or the ActiveMQ Web Console is logged.</p>
    pub fn audit(&self) -> bool {
        self.audit
    }
    /// <p>Enables general logging.</p>
    pub fn general(&self) -> bool {
        self.general
    }
}
impl std::fmt::Debug for PendingLogs {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PendingLogs");
        formatter.field("audit", &self.audit);
        formatter.field("general", &self.general);
        formatter.finish()
    }
}
/// See [`PendingLogs`](crate::model::PendingLogs)
pub mod pending_logs {
    /// A builder for [`PendingLogs`](crate::model::PendingLogs)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) audit: std::option::Option<bool>,
        pub(crate) general: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Enables audit logging. Every user management action made using JMX or the ActiveMQ Web Console is logged.</p>
        pub fn audit(mut self, input: bool) -> Self {
            self.audit = Some(input);
            self
        }
        /// <p>Enables audit logging. Every user management action made using JMX or the ActiveMQ Web Console is logged.</p>
        pub fn set_audit(mut self, input: std::option::Option<bool>) -> Self {
            self.audit = input;
            self
        }
        /// <p>Enables general logging.</p>
        pub fn general(mut self, input: bool) -> Self {
            self.general = Some(input);
            self
        }
        /// <p>Enables general logging.</p>
        pub fn set_general(mut self, input: std::option::Option<bool>) -> Self {
            self.general = input;
            self
        }
        /// Consumes the builder and constructs a [`PendingLogs`](crate::model::PendingLogs)
        pub fn build(self) -> crate::model::PendingLogs {
            crate::model::PendingLogs {
                audit: self.audit.unwrap_or_default(),
                general: self.general.unwrap_or_default(),
            }
        }
    }
}
impl PendingLogs {
    /// Creates a new builder-style object to manufacture [`PendingLogs`](crate::model::PendingLogs)
    pub fn builder() -> crate::model::pending_logs::Builder {
        crate::model::pending_logs::Builder::default()
    }
}

/// <important><p>Does not apply to RabbitMQ brokers.</p></important> <p>Encryption options for the broker.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EncryptionOptions {
    /// <p>The customer master key (CMK) to use for the AWS Key Management Service (KMS). This key is used to encrypt your data at rest. If not provided, Amazon MQ will use a default CMK to encrypt your data.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>Enables the use of an AWS owned CMK using AWS Key Management Service (KMS). Set to true by default, if no value is provided, for example, for RabbitMQ brokers.</p>
    pub use_aws_owned_key: bool,
}
impl EncryptionOptions {
    /// <p>The customer master key (CMK) to use for the AWS Key Management Service (KMS). This key is used to encrypt your data at rest. If not provided, Amazon MQ will use a default CMK to encrypt your data.</p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>Enables the use of an AWS owned CMK using AWS Key Management Service (KMS). Set to true by default, if no value is provided, for example, for RabbitMQ brokers.</p>
    pub fn use_aws_owned_key(&self) -> bool {
        self.use_aws_owned_key
    }
}
impl std::fmt::Debug for EncryptionOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EncryptionOptions");
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("use_aws_owned_key", &self.use_aws_owned_key);
        formatter.finish()
    }
}
/// See [`EncryptionOptions`](crate::model::EncryptionOptions)
pub mod encryption_options {
    /// A builder for [`EncryptionOptions`](crate::model::EncryptionOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) use_aws_owned_key: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The customer master key (CMK) to use for the AWS Key Management Service (KMS). This key is used to encrypt your data at rest. If not provided, Amazon MQ will use a default CMK to encrypt your data.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The customer master key (CMK) to use for the AWS Key Management Service (KMS). This key is used to encrypt your data at rest. If not provided, Amazon MQ will use a default CMK to encrypt your data.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>Enables the use of an AWS owned CMK using AWS Key Management Service (KMS). Set to true by default, if no value is provided, for example, for RabbitMQ brokers.</p>
        pub fn use_aws_owned_key(mut self, input: bool) -> Self {
            self.use_aws_owned_key = Some(input);
            self
        }
        /// <p>Enables the use of an AWS owned CMK using AWS Key Management Service (KMS). Set to true by default, if no value is provided, for example, for RabbitMQ brokers.</p>
        pub fn set_use_aws_owned_key(mut self, input: std::option::Option<bool>) -> Self {
            self.use_aws_owned_key = input;
            self
        }
        /// Consumes the builder and constructs a [`EncryptionOptions`](crate::model::EncryptionOptions)
        pub fn build(self) -> crate::model::EncryptionOptions {
            crate::model::EncryptionOptions {
                kms_key_id: self.kms_key_id,
                use_aws_owned_key: self.use_aws_owned_key.unwrap_or_default(),
            }
        }
    }
}
impl EncryptionOptions {
    /// Creates a new builder-style object to manufacture [`EncryptionOptions`](crate::model::EncryptionOptions)
    pub fn builder() -> crate::model::encryption_options::Builder {
        crate::model::encryption_options::Builder::default()
    }
}

/// <p>Broker configuration information</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Configurations {
    /// <p>The broker's current configuration.</p>
    pub current: std::option::Option<crate::model::ConfigurationId>,
    /// <p>The history of configurations applied to the broker.</p>
    pub history: std::option::Option<std::vec::Vec<crate::model::ConfigurationId>>,
    /// <p>The broker's pending configuration.</p>
    pub pending: std::option::Option<crate::model::ConfigurationId>,
}
impl Configurations {
    /// <p>The broker's current configuration.</p>
    pub fn current(&self) -> std::option::Option<&crate::model::ConfigurationId> {
        self.current.as_ref()
    }
    /// <p>The history of configurations applied to the broker.</p>
    pub fn history(&self) -> std::option::Option<&[crate::model::ConfigurationId]> {
        self.history.as_deref()
    }
    /// <p>The broker's pending configuration.</p>
    pub fn pending(&self) -> std::option::Option<&crate::model::ConfigurationId> {
        self.pending.as_ref()
    }
}
impl std::fmt::Debug for Configurations {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Configurations");
        formatter.field("current", &self.current);
        formatter.field("history", &self.history);
        formatter.field("pending", &self.pending);
        formatter.finish()
    }
}
/// See [`Configurations`](crate::model::Configurations)
pub mod configurations {
    /// A builder for [`Configurations`](crate::model::Configurations)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) current: std::option::Option<crate::model::ConfigurationId>,
        pub(crate) history: std::option::Option<std::vec::Vec<crate::model::ConfigurationId>>,
        pub(crate) pending: std::option::Option<crate::model::ConfigurationId>,
    }
    impl Builder {
        /// <p>The broker's current configuration.</p>
        pub fn current(mut self, input: crate::model::ConfigurationId) -> Self {
            self.current = Some(input);
            self
        }
        /// <p>The broker's current configuration.</p>
        pub fn set_current(
            mut self,
            input: std::option::Option<crate::model::ConfigurationId>,
        ) -> Self {
            self.current = input;
            self
        }
        /// Appends an item to `history`.
        ///
        /// To override the contents of this collection use [`set_history`](Self::set_history).
        ///
        /// <p>The history of configurations applied to the broker.</p>
        pub fn history(mut self, input: impl Into<crate::model::ConfigurationId>) -> Self {
            let mut v = self.history.unwrap_or_default();
            v.push(input.into());
            self.history = Some(v);
            self
        }
        /// <p>The history of configurations applied to the broker.</p>
        pub fn set_history(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConfigurationId>>,
        ) -> Self {
            self.history = input;
            self
        }
        /// <p>The broker's pending configuration.</p>
        pub fn pending(mut self, input: crate::model::ConfigurationId) -> Self {
            self.pending = Some(input);
            self
        }
        /// <p>The broker's pending configuration.</p>
        pub fn set_pending(
            mut self,
            input: std::option::Option<crate::model::ConfigurationId>,
        ) -> Self {
            self.pending = input;
            self
        }
        /// Consumes the builder and constructs a [`Configurations`](crate::model::Configurations)
        pub fn build(self) -> crate::model::Configurations {
            crate::model::Configurations {
                current: self.current,
                history: self.history,
                pending: self.pending,
            }
        }
    }
}
impl Configurations {
    /// Creates a new builder-style object to manufacture [`Configurations`](crate::model::Configurations)
    pub fn builder() -> crate::model::configurations::Builder {
        crate::model::configurations::Builder::default()
    }
}

/// <p>Returns information about all brokers.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BrokerInstance {
    /// <p>The brokers web console URL.</p>
    pub console_url: std::option::Option<std::string::String>,
    /// <p>The broker's wire-level protocol endpoints.</p>
    pub endpoints: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The IP address of the Elastic Network Interface (ENI) attached to the broker. Does not apply to RabbitMQ brokers.</p>
    pub ip_address: std::option::Option<std::string::String>,
}
impl BrokerInstance {
    /// <p>The brokers web console URL.</p>
    pub fn console_url(&self) -> std::option::Option<&str> {
        self.console_url.as_deref()
    }
    /// <p>The broker's wire-level protocol endpoints.</p>
    pub fn endpoints(&self) -> std::option::Option<&[std::string::String]> {
        self.endpoints.as_deref()
    }
    /// <p>The IP address of the Elastic Network Interface (ENI) attached to the broker. Does not apply to RabbitMQ brokers.</p>
    pub fn ip_address(&self) -> std::option::Option<&str> {
        self.ip_address.as_deref()
    }
}
impl std::fmt::Debug for BrokerInstance {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BrokerInstance");
        formatter.field("console_url", &self.console_url);
        formatter.field("endpoints", &self.endpoints);
        formatter.field("ip_address", &self.ip_address);
        formatter.finish()
    }
}
/// See [`BrokerInstance`](crate::model::BrokerInstance)
pub mod broker_instance {
    /// A builder for [`BrokerInstance`](crate::model::BrokerInstance)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) console_url: std::option::Option<std::string::String>,
        pub(crate) endpoints: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) ip_address: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The brokers web console URL.</p>
        pub fn console_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.console_url = Some(input.into());
            self
        }
        /// <p>The brokers web console URL.</p>
        pub fn set_console_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.console_url = input;
            self
        }
        /// Appends an item to `endpoints`.
        ///
        /// To override the contents of this collection use [`set_endpoints`](Self::set_endpoints).
        ///
        /// <p>The broker's wire-level protocol endpoints.</p>
        pub fn endpoints(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.endpoints.unwrap_or_default();
            v.push(input.into());
            self.endpoints = Some(v);
            self
        }
        /// <p>The broker's wire-level protocol endpoints.</p>
        pub fn set_endpoints(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.endpoints = input;
            self
        }
        /// <p>The IP address of the Elastic Network Interface (ENI) attached to the broker. Does not apply to RabbitMQ brokers.</p>
        pub fn ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip_address = Some(input.into());
            self
        }
        /// <p>The IP address of the Elastic Network Interface (ENI) attached to the broker. Does not apply to RabbitMQ brokers.</p>
        pub fn set_ip_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ip_address = input;
            self
        }
        /// Consumes the builder and constructs a [`BrokerInstance`](crate::model::BrokerInstance)
        pub fn build(self) -> crate::model::BrokerInstance {
            crate::model::BrokerInstance {
                console_url: self.console_url,
                endpoints: self.endpoints,
                ip_address: self.ip_address,
            }
        }
    }
}
impl BrokerInstance {
    /// Creates a new builder-style object to manufacture [`BrokerInstance`](crate::model::BrokerInstance)
    pub fn builder() -> crate::model::broker_instance::Builder {
        crate::model::broker_instance::Builder::default()
    }
}

/// <p>A user associated with the broker. For RabbitMQ brokers, one and only one administrative user is accepted and created when a broker is first provisioned. All subsequent broker users are created by making RabbitMQ API calls directly to brokers or via the RabbitMQ web console.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct User {
    /// <p>Enables access to the ActiveMQ Web Console for the ActiveMQ user. Does not apply to RabbitMQ brokers.</p>
    pub console_access: bool,
    /// <p>The list of groups (20 maximum) to which the ActiveMQ user belongs. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long. Does not apply to RabbitMQ brokers.</p>
    pub groups: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Required. The password of the user. This value must be at least 12 characters long, must contain at least 4 unique characters, and must not contain commas, colons, or equal signs (,:=).</p>
    pub password: std::option::Option<std::string::String>,
    /// <p>important><title>Amazon MQ for ActiveMQ</title> <para>For ActiveMQ brokers, this value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>/important> <important><title>Amazon MQ for RabbitMQ</title> <p>For RabbitMQ brokers, this value can contain only alphanumeric characters, dashes, periods, underscores (- . _). This value must not contain a tilde (~) character. Amazon MQ prohibts using guest as a valid usename. This value must be 2-100 characters long.</p></important></para>
    pub username: std::option::Option<std::string::String>,
}
impl User {
    /// <p>Enables access to the ActiveMQ Web Console for the ActiveMQ user. Does not apply to RabbitMQ brokers.</p>
    pub fn console_access(&self) -> bool {
        self.console_access
    }
    /// <p>The list of groups (20 maximum) to which the ActiveMQ user belongs. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long. Does not apply to RabbitMQ brokers.</p>
    pub fn groups(&self) -> std::option::Option<&[std::string::String]> {
        self.groups.as_deref()
    }
    /// <p>Required. The password of the user. This value must be at least 12 characters long, must contain at least 4 unique characters, and must not contain commas, colons, or equal signs (,:=).</p>
    pub fn password(&self) -> std::option::Option<&str> {
        self.password.as_deref()
    }
    /// <p>important><title>Amazon MQ for ActiveMQ</title> <para>For ActiveMQ brokers, this value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>/important> <important><title>Amazon MQ for RabbitMQ</title> <p>For RabbitMQ brokers, this value can contain only alphanumeric characters, dashes, periods, underscores (- . _). This value must not contain a tilde (~) character. Amazon MQ prohibts using guest as a valid usename. This value must be 2-100 characters long.</p></important></para>
    pub fn username(&self) -> std::option::Option<&str> {
        self.username.as_deref()
    }
}
impl std::fmt::Debug for User {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("User");
        formatter.field("console_access", &self.console_access);
        formatter.field("groups", &self.groups);
        formatter.field("password", &self.password);
        formatter.field("username", &self.username);
        formatter.finish()
    }
}
/// See [`User`](crate::model::User)
pub mod user {
    /// A builder for [`User`](crate::model::User)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) console_access: std::option::Option<bool>,
        pub(crate) groups: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) password: std::option::Option<std::string::String>,
        pub(crate) username: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Enables access to the ActiveMQ Web Console for the ActiveMQ user. Does not apply to RabbitMQ brokers.</p>
        pub fn console_access(mut self, input: bool) -> Self {
            self.console_access = Some(input);
            self
        }
        /// <p>Enables access to the ActiveMQ Web Console for the ActiveMQ user. Does not apply to RabbitMQ brokers.</p>
        pub fn set_console_access(mut self, input: std::option::Option<bool>) -> Self {
            self.console_access = input;
            self
        }
        /// Appends an item to `groups`.
        ///
        /// To override the contents of this collection use [`set_groups`](Self::set_groups).
        ///
        /// <p>The list of groups (20 maximum) to which the ActiveMQ user belongs. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long. Does not apply to RabbitMQ brokers.</p>
        pub fn groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.groups.unwrap_or_default();
            v.push(input.into());
            self.groups = Some(v);
            self
        }
        /// <p>The list of groups (20 maximum) to which the ActiveMQ user belongs. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long. Does not apply to RabbitMQ brokers.</p>
        pub fn set_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.groups = input;
            self
        }
        /// <p>Required. The password of the user. This value must be at least 12 characters long, must contain at least 4 unique characters, and must not contain commas, colons, or equal signs (,:=).</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.password = Some(input.into());
            self
        }
        /// <p>Required. The password of the user. This value must be at least 12 characters long, must contain at least 4 unique characters, and must not contain commas, colons, or equal signs (,:=).</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.password = input;
            self
        }
        /// <p>important><title>Amazon MQ for ActiveMQ</title> <para>For ActiveMQ brokers, this value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>/important> <important><title>Amazon MQ for RabbitMQ</title> <p>For RabbitMQ brokers, this value can contain only alphanumeric characters, dashes, periods, underscores (- . _). This value must not contain a tilde (~) character. Amazon MQ prohibts using guest as a valid usename. This value must be 2-100 characters long.</p></important></para>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>important><title>Amazon MQ for ActiveMQ</title> <para>For ActiveMQ brokers, this value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>/important> <important><title>Amazon MQ for RabbitMQ</title> <p>For RabbitMQ brokers, this value can contain only alphanumeric characters, dashes, periods, underscores (- . _). This value must not contain a tilde (~) character. Amazon MQ prohibts using guest as a valid usename. This value must be 2-100 characters long.</p></important></para>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// Consumes the builder and constructs a [`User`](crate::model::User)
        pub fn build(self) -> crate::model::User {
            crate::model::User {
                console_access: self.console_access.unwrap_or_default(),
                groups: self.groups,
                password: self.password,
                username: self.username,
            }
        }
    }
}
impl User {
    /// Creates a new builder-style object to manufacture [`User`](crate::model::User)
    pub fn builder() -> crate::model::user::Builder {
        crate::model::user::Builder::default()
    }
}
