// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CreateBroker` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateBrokerError {
    /// Kind of error that occurred.
    pub kind: CreateBrokerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateBroker` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateBrokerErrorKind {
    /// <p>Returns information about an error.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Returns information about an error.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Returns information about an error.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Returns information about an error.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Returns information about an error.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateBrokerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateBrokerErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateBrokerErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateBrokerErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateBrokerErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            CreateBrokerErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreateBrokerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateBrokerError {
    fn code(&self) -> Option<&str> {
        CreateBrokerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateBrokerError {
    /// Creates a new `CreateBrokerError`.
    pub fn new(kind: CreateBrokerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateBrokerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateBrokerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateBrokerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateBrokerErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateBrokerErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreateBrokerErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `CreateBrokerErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateBrokerErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateBrokerErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, CreateBrokerErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `CreateBrokerErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBrokerErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBrokerErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, CreateBrokerErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for CreateBrokerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateBrokerErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateBrokerErrorKind::ConflictException(_inner) => Some(_inner),
            CreateBrokerErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateBrokerErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            CreateBrokerErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreateBrokerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateConfigurationError {
    /// Kind of error that occurred.
    pub kind: CreateConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateConfigurationErrorKind {
    /// <p>Returns information about an error.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Returns information about an error.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Returns information about an error.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Returns information about an error.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateConfigurationErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateConfigurationErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateConfigurationErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateConfigurationErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            CreateConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateConfigurationError {
    fn code(&self) -> Option<&str> {
        CreateConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateConfigurationError {
    /// Creates a new `CreateConfigurationError`.
    pub fn new(kind: CreateConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateConfigurationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConfigurationErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateConfigurationErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConfigurationErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateConfigurationErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConfigurationErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateConfigurationErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConfigurationErrorKind::InternalServerErrorException(_)
        )
    }
}
impl std::error::Error for CreateConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateConfigurationErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateConfigurationErrorKind::ConflictException(_inner) => Some(_inner),
            CreateConfigurationErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateConfigurationErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            CreateConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateTagsError {
    /// Kind of error that occurred.
    pub kind: CreateTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateTagsErrorKind {
    /// <p>Returns information about an error.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Returns information about an error.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Returns information about an error.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Returns information about an error.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateTagsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateTagsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateTagsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            CreateTagsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateTagsError {
    fn code(&self) -> Option<&str> {
        CreateTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateTagsError {
    /// Creates a new `CreateTagsError`.
    pub fn new(kind: CreateTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateTagsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateTagsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreateTagsErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `CreateTagsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, CreateTagsErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `CreateTagsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTagsErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTagsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateTagsErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for CreateTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateTagsErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateTagsErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateTagsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            CreateTagsErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateUserError {
    /// Kind of error that occurred.
    pub kind: CreateUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateUserErrorKind {
    /// <p>Returns information about an error.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Returns information about an error.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Returns information about an error.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Returns information about an error.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Returns information about an error.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateUserErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateUserErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateUserErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateUserErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            CreateUserErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateUserError {
    fn code(&self) -> Option<&str> {
        CreateUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateUserError {
    /// Creates a new `CreateUserError`.
    pub fn new(kind: CreateUserErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateUserErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateUserErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreateUserErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `CreateUserErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateUserErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateUserErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, CreateUserErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `CreateUserErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUserErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateUserErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for CreateUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateUserErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateUserErrorKind::ConflictException(_inner) => Some(_inner),
            CreateUserErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateUserErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            CreateUserErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateUserErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteBroker` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteBrokerError {
    /// Kind of error that occurred.
    pub kind: DeleteBrokerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteBroker` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteBrokerErrorKind {
    /// <p>Returns information about an error.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Returns information about an error.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Returns information about an error.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Returns information about an error.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteBrokerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteBrokerErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteBrokerErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteBrokerErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeleteBrokerErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteBrokerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteBrokerError {
    fn code(&self) -> Option<&str> {
        DeleteBrokerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteBrokerError {
    /// Creates a new `DeleteBrokerError`.
    pub fn new(kind: DeleteBrokerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteBrokerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteBrokerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteBrokerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteBrokerErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteBrokerErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteBrokerErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `DeleteBrokerErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, DeleteBrokerErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `DeleteBrokerErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBrokerErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBrokerErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteBrokerErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for DeleteBrokerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteBrokerErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteBrokerErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteBrokerErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteBrokerErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteBrokerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteTagsError {
    /// Kind of error that occurred.
    pub kind: DeleteTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteTagsErrorKind {
    /// <p>Returns information about an error.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Returns information about an error.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Returns information about an error.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Returns information about an error.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteTagsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteTagsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteTagsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeleteTagsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteTagsError {
    fn code(&self) -> Option<&str> {
        DeleteTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteTagsError {
    /// Creates a new `DeleteTagsError`.
    pub fn new(kind: DeleteTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteTagsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteTagsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteTagsErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `DeleteTagsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, DeleteTagsErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `DeleteTagsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTagsErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteTagsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteTagsErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for DeleteTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteTagsErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteTagsErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteTagsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteTagsErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteUserError {
    /// Kind of error that occurred.
    pub kind: DeleteUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteUserErrorKind {
    /// <p>Returns information about an error.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Returns information about an error.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Returns information about an error.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Returns information about an error.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteUserErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteUserErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteUserErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeleteUserErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteUserError {
    fn code(&self) -> Option<&str> {
        DeleteUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteUserError {
    /// Creates a new `DeleteUserError`.
    pub fn new(kind: DeleteUserErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteUserErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteUserErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteUserErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `DeleteUserErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, DeleteUserErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `DeleteUserErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteUserErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for DeleteUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteUserErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteUserErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteUserErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteUserErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteUserErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeBroker` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeBrokerError {
    /// Kind of error that occurred.
    pub kind: DescribeBrokerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeBroker` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeBrokerErrorKind {
    /// <p>Returns information about an error.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Returns information about an error.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Returns information about an error.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Returns information about an error.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeBrokerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeBrokerErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DescribeBrokerErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DescribeBrokerErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DescribeBrokerErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeBrokerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeBrokerError {
    fn code(&self) -> Option<&str> {
        DescribeBrokerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeBrokerError {
    /// Creates a new `DescribeBrokerError`.
    pub fn new(kind: DescribeBrokerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeBrokerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeBrokerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeBrokerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeBrokerErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeBrokerErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DescribeBrokerErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `DescribeBrokerErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, DescribeBrokerErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `DescribeBrokerErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBrokerErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBrokerErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DescribeBrokerErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for DescribeBrokerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeBrokerErrorKind::BadRequestException(_inner) => Some(_inner),
            DescribeBrokerErrorKind::ForbiddenException(_inner) => Some(_inner),
            DescribeBrokerErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DescribeBrokerErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeBrokerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeBrokerEngineTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeBrokerEngineTypesError {
    /// Kind of error that occurred.
    pub kind: DescribeBrokerEngineTypesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeBrokerEngineTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeBrokerEngineTypesErrorKind {
    /// <p>Returns information about an error.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Returns information about an error.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Returns information about an error.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeBrokerEngineTypesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeBrokerEngineTypesErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DescribeBrokerEngineTypesErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DescribeBrokerEngineTypesErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            DescribeBrokerEngineTypesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeBrokerEngineTypesError {
    fn code(&self) -> Option<&str> {
        DescribeBrokerEngineTypesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeBrokerEngineTypesError {
    /// Creates a new `DescribeBrokerEngineTypesError`.
    pub fn new(kind: DescribeBrokerEngineTypesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeBrokerEngineTypesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeBrokerEngineTypesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeBrokerEngineTypesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeBrokerEngineTypesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeBrokerEngineTypesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBrokerEngineTypesErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBrokerEngineTypesErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBrokerEngineTypesErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBrokerEngineTypesErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBrokerEngineTypesErrorKind::InternalServerErrorException(_)
        )
    }
}
impl std::error::Error for DescribeBrokerEngineTypesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeBrokerEngineTypesErrorKind::BadRequestException(_inner) => Some(_inner),
            DescribeBrokerEngineTypesErrorKind::ForbiddenException(_inner) => Some(_inner),
            DescribeBrokerEngineTypesErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            DescribeBrokerEngineTypesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeBrokerInstanceOptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeBrokerInstanceOptionsError {
    /// Kind of error that occurred.
    pub kind: DescribeBrokerInstanceOptionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeBrokerInstanceOptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeBrokerInstanceOptionsErrorKind {
    /// <p>Returns information about an error.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Returns information about an error.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Returns information about an error.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeBrokerInstanceOptionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeBrokerInstanceOptionsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DescribeBrokerInstanceOptionsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DescribeBrokerInstanceOptionsErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            DescribeBrokerInstanceOptionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeBrokerInstanceOptionsError {
    fn code(&self) -> Option<&str> {
        DescribeBrokerInstanceOptionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeBrokerInstanceOptionsError {
    /// Creates a new `DescribeBrokerInstanceOptionsError`.
    pub fn new(
        kind: DescribeBrokerInstanceOptionsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeBrokerInstanceOptionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeBrokerInstanceOptionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeBrokerInstanceOptionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeBrokerInstanceOptionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeBrokerInstanceOptionsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBrokerInstanceOptionsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBrokerInstanceOptionsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBrokerInstanceOptionsErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBrokerInstanceOptionsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBrokerInstanceOptionsErrorKind::InternalServerErrorException(_)
        )
    }
}
impl std::error::Error for DescribeBrokerInstanceOptionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeBrokerInstanceOptionsErrorKind::BadRequestException(_inner) => Some(_inner),
            DescribeBrokerInstanceOptionsErrorKind::ForbiddenException(_inner) => Some(_inner),
            DescribeBrokerInstanceOptionsErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            DescribeBrokerInstanceOptionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeConfigurationError {
    /// Kind of error that occurred.
    pub kind: DescribeConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeConfigurationErrorKind {
    /// <p>Returns information about an error.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Returns information about an error.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Returns information about an error.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Returns information about an error.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeConfigurationErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DescribeConfigurationErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DescribeConfigurationErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DescribeConfigurationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeConfigurationError {
    fn code(&self) -> Option<&str> {
        DescribeConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeConfigurationError {
    /// Creates a new `DescribeConfigurationError`.
    pub fn new(kind: DescribeConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeConfigurationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConfigurationErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeConfigurationErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConfigurationErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeConfigurationErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConfigurationErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeConfigurationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConfigurationErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeConfigurationErrorKind::BadRequestException(_inner) => Some(_inner),
            DescribeConfigurationErrorKind::ForbiddenException(_inner) => Some(_inner),
            DescribeConfigurationErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DescribeConfigurationErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeConfigurationRevision` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeConfigurationRevisionError {
    /// Kind of error that occurred.
    pub kind: DescribeConfigurationRevisionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeConfigurationRevision` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeConfigurationRevisionErrorKind {
    /// <p>Returns information about an error.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Returns information about an error.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Returns information about an error.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Returns information about an error.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeConfigurationRevisionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeConfigurationRevisionErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DescribeConfigurationRevisionErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DescribeConfigurationRevisionErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            DescribeConfigurationRevisionErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeConfigurationRevisionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeConfigurationRevisionError {
    fn code(&self) -> Option<&str> {
        DescribeConfigurationRevisionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeConfigurationRevisionError {
    /// Creates a new `DescribeConfigurationRevisionError`.
    pub fn new(
        kind: DescribeConfigurationRevisionErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeConfigurationRevisionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeConfigurationRevisionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeConfigurationRevisionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeConfigurationRevisionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeConfigurationRevisionErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConfigurationRevisionErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeConfigurationRevisionErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConfigurationRevisionErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeConfigurationRevisionErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConfigurationRevisionErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeConfigurationRevisionErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConfigurationRevisionErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeConfigurationRevisionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeConfigurationRevisionErrorKind::BadRequestException(_inner) => Some(_inner),
            DescribeConfigurationRevisionErrorKind::ForbiddenException(_inner) => Some(_inner),
            DescribeConfigurationRevisionErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            DescribeConfigurationRevisionErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeConfigurationRevisionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeUserError {
    /// Kind of error that occurred.
    pub kind: DescribeUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeUserErrorKind {
    /// <p>Returns information about an error.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Returns information about an error.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Returns information about an error.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Returns information about an error.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeUserErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DescribeUserErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DescribeUserErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DescribeUserErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeUserError {
    fn code(&self) -> Option<&str> {
        DescribeUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeUserError {
    /// Creates a new `DescribeUserError`.
    pub fn new(kind: DescribeUserErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeUserErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeUserErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DescribeUserErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `DescribeUserErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, DescribeUserErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `DescribeUserErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeUserErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeUserErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DescribeUserErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for DescribeUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeUserErrorKind::BadRequestException(_inner) => Some(_inner),
            DescribeUserErrorKind::ForbiddenException(_inner) => Some(_inner),
            DescribeUserErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DescribeUserErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeUserErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListBrokers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListBrokersError {
    /// Kind of error that occurred.
    pub kind: ListBrokersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListBrokers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListBrokersErrorKind {
    /// <p>Returns information about an error.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Returns information about an error.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Returns information about an error.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListBrokersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListBrokersErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListBrokersErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListBrokersErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListBrokersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListBrokersError {
    fn code(&self) -> Option<&str> {
        ListBrokersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListBrokersError {
    /// Creates a new `ListBrokersError`.
    pub fn new(kind: ListBrokersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListBrokersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListBrokersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListBrokersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListBrokersErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListBrokersErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ListBrokersErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `ListBrokersErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, ListBrokersErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `ListBrokersErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBrokersErrorKind::InternalServerErrorException(_)
        )
    }
}
impl std::error::Error for ListBrokersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListBrokersErrorKind::BadRequestException(_inner) => Some(_inner),
            ListBrokersErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListBrokersErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListBrokersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListConfigurationRevisions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListConfigurationRevisionsError {
    /// Kind of error that occurred.
    pub kind: ListConfigurationRevisionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListConfigurationRevisions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListConfigurationRevisionsErrorKind {
    /// <p>Returns information about an error.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Returns information about an error.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Returns information about an error.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Returns information about an error.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListConfigurationRevisionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListConfigurationRevisionsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListConfigurationRevisionsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListConfigurationRevisionsErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            ListConfigurationRevisionsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListConfigurationRevisionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListConfigurationRevisionsError {
    fn code(&self) -> Option<&str> {
        ListConfigurationRevisionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListConfigurationRevisionsError {
    /// Creates a new `ListConfigurationRevisionsError`.
    pub fn new(kind: ListConfigurationRevisionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListConfigurationRevisionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListConfigurationRevisionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListConfigurationRevisionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListConfigurationRevisionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListConfigurationRevisionsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListConfigurationRevisionsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListConfigurationRevisionsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListConfigurationRevisionsErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListConfigurationRevisionsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListConfigurationRevisionsErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListConfigurationRevisionsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListConfigurationRevisionsErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for ListConfigurationRevisionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListConfigurationRevisionsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListConfigurationRevisionsErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListConfigurationRevisionsErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            ListConfigurationRevisionsErrorKind::NotFoundException(_inner) => Some(_inner),
            ListConfigurationRevisionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListConfigurations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListConfigurationsError {
    /// Kind of error that occurred.
    pub kind: ListConfigurationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListConfigurations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListConfigurationsErrorKind {
    /// <p>Returns information about an error.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Returns information about an error.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Returns information about an error.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListConfigurationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListConfigurationsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListConfigurationsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListConfigurationsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListConfigurationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListConfigurationsError {
    fn code(&self) -> Option<&str> {
        ListConfigurationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListConfigurationsError {
    /// Creates a new `ListConfigurationsError`.
    pub fn new(kind: ListConfigurationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListConfigurationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListConfigurationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListConfigurationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListConfigurationsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListConfigurationsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListConfigurationsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListConfigurationsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListConfigurationsErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListConfigurationsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListConfigurationsErrorKind::InternalServerErrorException(_)
        )
    }
}
impl std::error::Error for ListConfigurationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListConfigurationsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListConfigurationsErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListConfigurationsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListConfigurationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsError {
    /// Kind of error that occurred.
    pub kind: ListTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsErrorKind {
    /// <p>Returns information about an error.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Returns information about an error.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Returns information about an error.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Returns information about an error.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListTagsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListTagsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListTagsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsError {
    fn code(&self) -> Option<&str> {
        ListTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsError {
    /// Creates a new `ListTagsError`.
    pub fn new(kind: ListTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ListTagsErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `ListTagsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, ListTagsErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `ListTagsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListTagsErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for ListTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListTagsErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListTagsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListTagsErrorKind::NotFoundException(_inner) => Some(_inner),
            ListTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListUsers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListUsersError {
    /// Kind of error that occurred.
    pub kind: ListUsersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListUsers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListUsersErrorKind {
    /// <p>Returns information about an error.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Returns information about an error.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Returns information about an error.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Returns information about an error.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListUsersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListUsersErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListUsersErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListUsersErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListUsersErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListUsersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListUsersError {
    fn code(&self) -> Option<&str> {
        ListUsersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListUsersError {
    /// Creates a new `ListUsersError`.
    pub fn new(kind: ListUsersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListUsersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListUsersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListUsersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListUsersErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListUsersErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ListUsersErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `ListUsersErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, ListUsersErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `ListUsersErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUsersErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListUsersErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListUsersErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for ListUsersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListUsersErrorKind::BadRequestException(_inner) => Some(_inner),
            ListUsersErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListUsersErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListUsersErrorKind::NotFoundException(_inner) => Some(_inner),
            ListUsersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RebootBroker` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RebootBrokerError {
    /// Kind of error that occurred.
    pub kind: RebootBrokerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RebootBroker` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RebootBrokerErrorKind {
    /// <p>Returns information about an error.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Returns information about an error.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Returns information about an error.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Returns information about an error.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RebootBrokerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RebootBrokerErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            RebootBrokerErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            RebootBrokerErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            RebootBrokerErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            RebootBrokerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RebootBrokerError {
    fn code(&self) -> Option<&str> {
        RebootBrokerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RebootBrokerError {
    /// Creates a new `RebootBrokerError`.
    pub fn new(kind: RebootBrokerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RebootBrokerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RebootBrokerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RebootBrokerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RebootBrokerErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RebootBrokerErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, RebootBrokerErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `RebootBrokerErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, RebootBrokerErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `RebootBrokerErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            RebootBrokerErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `RebootBrokerErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, RebootBrokerErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for RebootBrokerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RebootBrokerErrorKind::BadRequestException(_inner) => Some(_inner),
            RebootBrokerErrorKind::ForbiddenException(_inner) => Some(_inner),
            RebootBrokerErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            RebootBrokerErrorKind::NotFoundException(_inner) => Some(_inner),
            RebootBrokerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateBroker` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateBrokerError {
    /// Kind of error that occurred.
    pub kind: UpdateBrokerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateBroker` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateBrokerErrorKind {
    /// <p>Returns information about an error.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Returns information about an error.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Returns information about an error.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Returns information about an error.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Returns information about an error.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateBrokerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateBrokerErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateBrokerErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateBrokerErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdateBrokerErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdateBrokerErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateBrokerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateBrokerError {
    fn code(&self) -> Option<&str> {
        UpdateBrokerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateBrokerError {
    /// Creates a new `UpdateBrokerError`.
    pub fn new(kind: UpdateBrokerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateBrokerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateBrokerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateBrokerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateBrokerErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateBrokerErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, UpdateBrokerErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `UpdateBrokerErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateBrokerErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UpdateBrokerErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, UpdateBrokerErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `UpdateBrokerErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBrokerErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateBrokerErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateBrokerErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for UpdateBrokerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateBrokerErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateBrokerErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateBrokerErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdateBrokerErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateBrokerErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateBrokerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateConfigurationError {
    /// Kind of error that occurred.
    pub kind: UpdateConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateConfigurationErrorKind {
    /// <p>Returns information about an error.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Returns information about an error.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Returns information about an error.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Returns information about an error.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Returns information about an error.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateConfigurationErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateConfigurationErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateConfigurationErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdateConfigurationErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdateConfigurationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateConfigurationError {
    fn code(&self) -> Option<&str> {
        UpdateConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateConfigurationError {
    /// Creates a new `UpdateConfigurationError`.
    pub fn new(kind: UpdateConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateConfigurationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConfigurationErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateConfigurationErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConfigurationErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateConfigurationErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConfigurationErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateConfigurationErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConfigurationErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateConfigurationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConfigurationErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateConfigurationErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateConfigurationErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateConfigurationErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdateConfigurationErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateConfigurationErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateUserError {
    /// Kind of error that occurred.
    pub kind: UpdateUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateUserErrorKind {
    /// <p>Returns information about an error.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Returns information about an error.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Returns information about an error.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>Returns information about an error.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>Returns information about an error.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateUserErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateUserErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateUserErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdateUserErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdateUserErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateUserError {
    fn code(&self) -> Option<&str> {
        UpdateUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateUserError {
    /// Creates a new `UpdateUserError`.
    pub fn new(kind: UpdateUserErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateUserErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateUserErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, UpdateUserErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `UpdateUserErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateUserErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UpdateUserErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, UpdateUserErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `UpdateUserErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateUserErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for UpdateUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateUserErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateUserErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateUserErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdateUserErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateUserErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateUserErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>Returns information about an error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotFoundException {
    /// <p>The attribute which caused the error.</p>
    pub error_attribute: std::option::Option<std::string::String>,
    /// <p>The explanation of the error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl NotFoundException {
    /// <p>The attribute which caused the error.</p>
    pub fn error_attribute(&self) -> std::option::Option<&str> {
        self.error_attribute.as_deref()
    }
}
impl std::fmt::Debug for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotFoundException");
        formatter.field("error_attribute", &self.error_attribute);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NotFoundException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for NotFoundException {}
/// See [`NotFoundException`](crate::error::NotFoundException)
pub mod not_found_exception {
    /// A builder for [`NotFoundException`](crate::error::NotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_attribute: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The attribute which caused the error.</p>
        pub fn error_attribute(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_attribute = Some(input.into());
            self
        }
        /// <p>The attribute which caused the error.</p>
        pub fn set_error_attribute(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_attribute = input;
            self
        }
        /// <p>The explanation of the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The explanation of the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NotFoundException`](crate::error::NotFoundException)
        pub fn build(self) -> crate::error::NotFoundException {
            crate::error::NotFoundException {
                error_attribute: self.error_attribute,
                message: self.message,
            }
        }
    }
}
impl NotFoundException {
    /// Creates a new builder-style object to manufacture [`NotFoundException`](crate::error::NotFoundException)
    pub fn builder() -> crate::error::not_found_exception::Builder {
        crate::error::not_found_exception::Builder::default()
    }
}

/// <p>Returns information about an error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerErrorException {
    /// <p>The attribute which caused the error.</p>
    pub error_attribute: std::option::Option<std::string::String>,
    /// <p>The explanation of the error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl InternalServerErrorException {
    /// <p>The attribute which caused the error.</p>
    pub fn error_attribute(&self) -> std::option::Option<&str> {
        self.error_attribute.as_deref()
    }
}
impl std::fmt::Debug for InternalServerErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerErrorException");
        formatter.field("error_attribute", &self.error_attribute);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServerErrorException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerErrorException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerErrorException {}
/// See [`InternalServerErrorException`](crate::error::InternalServerErrorException)
pub mod internal_server_error_exception {
    /// A builder for [`InternalServerErrorException`](crate::error::InternalServerErrorException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_attribute: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The attribute which caused the error.</p>
        pub fn error_attribute(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_attribute = Some(input.into());
            self
        }
        /// <p>The attribute which caused the error.</p>
        pub fn set_error_attribute(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_attribute = input;
            self
        }
        /// <p>The explanation of the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The explanation of the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerErrorException`](crate::error::InternalServerErrorException)
        pub fn build(self) -> crate::error::InternalServerErrorException {
            crate::error::InternalServerErrorException {
                error_attribute: self.error_attribute,
                message: self.message,
            }
        }
    }
}
impl InternalServerErrorException {
    /// Creates a new builder-style object to manufacture [`InternalServerErrorException`](crate::error::InternalServerErrorException)
    pub fn builder() -> crate::error::internal_server_error_exception::Builder {
        crate::error::internal_server_error_exception::Builder::default()
    }
}

/// <p>Returns information about an error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ForbiddenException {
    /// <p>The attribute which caused the error.</p>
    pub error_attribute: std::option::Option<std::string::String>,
    /// <p>The explanation of the error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl ForbiddenException {
    /// <p>The attribute which caused the error.</p>
    pub fn error_attribute(&self) -> std::option::Option<&str> {
        self.error_attribute.as_deref()
    }
}
impl std::fmt::Debug for ForbiddenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ForbiddenException");
        formatter.field("error_attribute", &self.error_attribute);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ForbiddenException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ForbiddenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ForbiddenException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ForbiddenException {}
/// See [`ForbiddenException`](crate::error::ForbiddenException)
pub mod forbidden_exception {
    /// A builder for [`ForbiddenException`](crate::error::ForbiddenException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_attribute: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The attribute which caused the error.</p>
        pub fn error_attribute(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_attribute = Some(input.into());
            self
        }
        /// <p>The attribute which caused the error.</p>
        pub fn set_error_attribute(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_attribute = input;
            self
        }
        /// <p>The explanation of the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The explanation of the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ForbiddenException`](crate::error::ForbiddenException)
        pub fn build(self) -> crate::error::ForbiddenException {
            crate::error::ForbiddenException {
                error_attribute: self.error_attribute,
                message: self.message,
            }
        }
    }
}
impl ForbiddenException {
    /// Creates a new builder-style object to manufacture [`ForbiddenException`](crate::error::ForbiddenException)
    pub fn builder() -> crate::error::forbidden_exception::Builder {
        crate::error::forbidden_exception::Builder::default()
    }
}

/// <p>Returns information about an error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    /// <p>The attribute which caused the error.</p>
    pub error_attribute: std::option::Option<std::string::String>,
    /// <p>The explanation of the error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl ConflictException {
    /// <p>The attribute which caused the error.</p>
    pub fn error_attribute(&self) -> std::option::Option<&str> {
        self.error_attribute.as_deref()
    }
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("error_attribute", &self.error_attribute);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_attribute: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The attribute which caused the error.</p>
        pub fn error_attribute(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_attribute = Some(input.into());
            self
        }
        /// <p>The attribute which caused the error.</p>
        pub fn set_error_attribute(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_attribute = input;
            self
        }
        /// <p>The explanation of the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The explanation of the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                error_attribute: self.error_attribute,
                message: self.message,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

/// <p>Returns information about an error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BadRequestException {
    /// <p>The attribute which caused the error.</p>
    pub error_attribute: std::option::Option<std::string::String>,
    /// <p>The explanation of the error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl BadRequestException {
    /// <p>The attribute which caused the error.</p>
    pub fn error_attribute(&self) -> std::option::Option<&str> {
        self.error_attribute.as_deref()
    }
}
impl std::fmt::Debug for BadRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BadRequestException");
        formatter.field("error_attribute", &self.error_attribute);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl BadRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for BadRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "BadRequestException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for BadRequestException {}
/// See [`BadRequestException`](crate::error::BadRequestException)
pub mod bad_request_exception {
    /// A builder for [`BadRequestException`](crate::error::BadRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_attribute: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The attribute which caused the error.</p>
        pub fn error_attribute(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_attribute = Some(input.into());
            self
        }
        /// <p>The attribute which caused the error.</p>
        pub fn set_error_attribute(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_attribute = input;
            self
        }
        /// <p>The explanation of the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The explanation of the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`BadRequestException`](crate::error::BadRequestException)
        pub fn build(self) -> crate::error::BadRequestException {
            crate::error::BadRequestException {
                error_attribute: self.error_attribute,
                message: self.message,
            }
        }
    }
}
impl BadRequestException {
    /// Creates a new builder-style object to manufacture [`BadRequestException`](crate::error::BadRequestException)
    pub fn builder() -> crate::error::bad_request_exception::Builder {
        crate::error::bad_request_exception::Builder::default()
    }
}

/// <p>Returns information about an error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnauthorizedException {
    /// <p>The attribute which caused the error.</p>
    pub error_attribute: std::option::Option<std::string::String>,
    /// <p>The explanation of the error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl UnauthorizedException {
    /// <p>The attribute which caused the error.</p>
    pub fn error_attribute(&self) -> std::option::Option<&str> {
        self.error_attribute.as_deref()
    }
}
impl std::fmt::Debug for UnauthorizedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnauthorizedException");
        formatter.field("error_attribute", &self.error_attribute);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnauthorizedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnauthorizedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnauthorizedException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnauthorizedException {}
/// See [`UnauthorizedException`](crate::error::UnauthorizedException)
pub mod unauthorized_exception {
    /// A builder for [`UnauthorizedException`](crate::error::UnauthorizedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_attribute: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The attribute which caused the error.</p>
        pub fn error_attribute(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_attribute = Some(input.into());
            self
        }
        /// <p>The attribute which caused the error.</p>
        pub fn set_error_attribute(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_attribute = input;
            self
        }
        /// <p>The explanation of the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The explanation of the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnauthorizedException`](crate::error::UnauthorizedException)
        pub fn build(self) -> crate::error::UnauthorizedException {
            crate::error::UnauthorizedException {
                error_attribute: self.error_attribute,
                message: self.message,
            }
        }
    }
}
impl UnauthorizedException {
    /// Creates a new builder-style object to manufacture [`UnauthorizedException`](crate::error::UnauthorizedException)
    pub fn builder() -> crate::error::unauthorized_exception::Builder {
        crate::error::unauthorized_exception::Builder::default()
    }
}
