// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `mq`.
///
/// This client allows ergonomic access to a `mq`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `CreateBroker` operation.
    ///
    /// See [`CreateBroker`](crate::client::fluent_builders::CreateBroker) for more information about the
    /// operation and its arguments.
    pub fn create_broker(&self) -> fluent_builders::CreateBroker<C, M, R> {
        fluent_builders::CreateBroker::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateConfiguration` operation.
    ///
    /// See [`CreateConfiguration`](crate::client::fluent_builders::CreateConfiguration) for more information about the
    /// operation and its arguments.
    pub fn create_configuration(&self) -> fluent_builders::CreateConfiguration<C, M, R> {
        fluent_builders::CreateConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateTags` operation.
    ///
    /// See [`CreateTags`](crate::client::fluent_builders::CreateTags) for more information about the
    /// operation and its arguments.
    pub fn create_tags(&self) -> fluent_builders::CreateTags<C, M, R> {
        fluent_builders::CreateTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateUser` operation.
    ///
    /// See [`CreateUser`](crate::client::fluent_builders::CreateUser) for more information about the
    /// operation and its arguments.
    pub fn create_user(&self) -> fluent_builders::CreateUser<C, M, R> {
        fluent_builders::CreateUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteBroker` operation.
    ///
    /// See [`DeleteBroker`](crate::client::fluent_builders::DeleteBroker) for more information about the
    /// operation and its arguments.
    pub fn delete_broker(&self) -> fluent_builders::DeleteBroker<C, M, R> {
        fluent_builders::DeleteBroker::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteTags` operation.
    ///
    /// See [`DeleteTags`](crate::client::fluent_builders::DeleteTags) for more information about the
    /// operation and its arguments.
    pub fn delete_tags(&self) -> fluent_builders::DeleteTags<C, M, R> {
        fluent_builders::DeleteTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteUser` operation.
    ///
    /// See [`DeleteUser`](crate::client::fluent_builders::DeleteUser) for more information about the
    /// operation and its arguments.
    pub fn delete_user(&self) -> fluent_builders::DeleteUser<C, M, R> {
        fluent_builders::DeleteUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeBroker` operation.
    ///
    /// See [`DescribeBroker`](crate::client::fluent_builders::DescribeBroker) for more information about the
    /// operation and its arguments.
    pub fn describe_broker(&self) -> fluent_builders::DescribeBroker<C, M, R> {
        fluent_builders::DescribeBroker::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeBrokerEngineTypes` operation.
    ///
    /// See [`DescribeBrokerEngineTypes`](crate::client::fluent_builders::DescribeBrokerEngineTypes) for more information about the
    /// operation and its arguments.
    pub fn describe_broker_engine_types(
        &self,
    ) -> fluent_builders::DescribeBrokerEngineTypes<C, M, R> {
        fluent_builders::DescribeBrokerEngineTypes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeBrokerInstanceOptions` operation.
    ///
    /// See [`DescribeBrokerInstanceOptions`](crate::client::fluent_builders::DescribeBrokerInstanceOptions) for more information about the
    /// operation and its arguments.
    pub fn describe_broker_instance_options(
        &self,
    ) -> fluent_builders::DescribeBrokerInstanceOptions<C, M, R> {
        fluent_builders::DescribeBrokerInstanceOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeConfiguration` operation.
    ///
    /// See [`DescribeConfiguration`](crate::client::fluent_builders::DescribeConfiguration) for more information about the
    /// operation and its arguments.
    pub fn describe_configuration(&self) -> fluent_builders::DescribeConfiguration<C, M, R> {
        fluent_builders::DescribeConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeConfigurationRevision` operation.
    ///
    /// See [`DescribeConfigurationRevision`](crate::client::fluent_builders::DescribeConfigurationRevision) for more information about the
    /// operation and its arguments.
    pub fn describe_configuration_revision(
        &self,
    ) -> fluent_builders::DescribeConfigurationRevision<C, M, R> {
        fluent_builders::DescribeConfigurationRevision::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeUser` operation.
    ///
    /// See [`DescribeUser`](crate::client::fluent_builders::DescribeUser) for more information about the
    /// operation and its arguments.
    pub fn describe_user(&self) -> fluent_builders::DescribeUser<C, M, R> {
        fluent_builders::DescribeUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListBrokers` operation.
    ///
    /// See [`ListBrokers`](crate::client::fluent_builders::ListBrokers) for more information about the
    /// operation and its arguments.
    pub fn list_brokers(&self) -> fluent_builders::ListBrokers<C, M, R> {
        fluent_builders::ListBrokers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListConfigurationRevisions` operation.
    ///
    /// See [`ListConfigurationRevisions`](crate::client::fluent_builders::ListConfigurationRevisions) for more information about the
    /// operation and its arguments.
    pub fn list_configuration_revisions(
        &self,
    ) -> fluent_builders::ListConfigurationRevisions<C, M, R> {
        fluent_builders::ListConfigurationRevisions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListConfigurations` operation.
    ///
    /// See [`ListConfigurations`](crate::client::fluent_builders::ListConfigurations) for more information about the
    /// operation and its arguments.
    pub fn list_configurations(&self) -> fluent_builders::ListConfigurations<C, M, R> {
        fluent_builders::ListConfigurations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTags` operation.
    ///
    /// See [`ListTags`](crate::client::fluent_builders::ListTags) for more information about the
    /// operation and its arguments.
    pub fn list_tags(&self) -> fluent_builders::ListTags<C, M, R> {
        fluent_builders::ListTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListUsers` operation.
    ///
    /// See [`ListUsers`](crate::client::fluent_builders::ListUsers) for more information about the
    /// operation and its arguments.
    pub fn list_users(&self) -> fluent_builders::ListUsers<C, M, R> {
        fluent_builders::ListUsers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RebootBroker` operation.
    ///
    /// See [`RebootBroker`](crate::client::fluent_builders::RebootBroker) for more information about the
    /// operation and its arguments.
    pub fn reboot_broker(&self) -> fluent_builders::RebootBroker<C, M, R> {
        fluent_builders::RebootBroker::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateBroker` operation.
    ///
    /// See [`UpdateBroker`](crate::client::fluent_builders::UpdateBroker) for more information about the
    /// operation and its arguments.
    pub fn update_broker(&self) -> fluent_builders::UpdateBroker<C, M, R> {
        fluent_builders::UpdateBroker::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateConfiguration` operation.
    ///
    /// See [`UpdateConfiguration`](crate::client::fluent_builders::UpdateConfiguration) for more information about the
    /// operation and its arguments.
    pub fn update_configuration(&self) -> fluent_builders::UpdateConfiguration<C, M, R> {
        fluent_builders::UpdateConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateUser` operation.
    ///
    /// See [`UpdateUser`](crate::client::fluent_builders::UpdateUser) for more information about the
    /// operation and its arguments.
    pub fn update_user(&self) -> fluent_builders::UpdateUser<C, M, R> {
        fluent_builders::UpdateUser::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateBroker`.
    ///
    /// <p>Creates a broker. Note: This API is asynchronous.</p> <p>To create a broker, you must either use the AmazonMQFullAccess IAM policy or include the following EC2 permissions in your IAM policy.</p> <ul><li><p>ec2:CreateNetworkInterface</p> <p>This permission is required to allow Amazon MQ to create an elastic network interface (ENI) on behalf of your account.</p></li> <li><p>ec2:CreateNetworkInterfacePermission</p> <p>This permission is required to attach the ENI to the broker instance.</p></li> <li><p>ec2:DeleteNetworkInterface</p></li> <li><p>ec2:DeleteNetworkInterfacePermission</p></li> <li><p>ec2:DetachNetworkInterface</p></li> <li><p>ec2:DescribeInternetGateways</p></li> <li><p>ec2:DescribeNetworkInterfaces</p></li> <li><p>ec2:DescribeNetworkInterfacePermissions</p></li> <li><p>ec2:DescribeRouteTables</p></li> <li><p>ec2:DescribeSecurityGroups</p></li> <li><p>ec2:DescribeSubnets</p></li> <li><p>ec2:DescribeVpcs</p></li></ul> <p>For more information, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/amazon-mq-setting-up.html#create-iam-user">Create an IAM User and Get Your AWS Credentials</a> and <a href="https://docs.aws.amazon.com/amazon-mq/latest/developer-guide/connecting-to-amazon-mq.html#never-modify-delete-elastic-network-interface">Never Modify or Delete the Amazon MQ Elastic Network Interface</a> in the <i>Amazon MQ Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateBroker<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_broker_input::Builder,
    }
    impl<C, M, R> CreateBroker<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateBroker`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateBrokerOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateBrokerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateBrokerInputOperationOutputAlias,
                crate::output::CreateBrokerOutput,
                crate::error::CreateBrokerError,
                crate::input::CreateBrokerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Optional. The authentication strategy used to secure the broker. The default is SIMPLE.</p>
        pub fn authentication_strategy(
            mut self,
            inp: crate::model::AuthenticationStrategy,
        ) -> Self {
            self.inner = self.inner.authentication_strategy(inp);
            self
        }
        /// <p>Optional. The authentication strategy used to secure the broker. The default is SIMPLE.</p>
        pub fn set_authentication_strategy(
            mut self,
            input: std::option::Option<crate::model::AuthenticationStrategy>,
        ) -> Self {
            self.inner = self.inner.set_authentication_strategy(input);
            self
        }
        /// <p>Enables automatic upgrades to new minor versions for brokers, as new versions are released and supported by Amazon MQ. Automatic upgrades occur during the scheduled maintenance window of the broker or after a manual broker reboot. Set to true by default, if no value is specified.</p>
        pub fn auto_minor_version_upgrade(mut self, inp: bool) -> Self {
            self.inner = self.inner.auto_minor_version_upgrade(inp);
            self
        }
        /// <p>Enables automatic upgrades to new minor versions for brokers, as new versions are released and supported by Amazon MQ. Automatic upgrades occur during the scheduled maintenance window of the broker or after a manual broker reboot. Set to true by default, if no value is specified.</p>
        pub fn set_auto_minor_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_minor_version_upgrade(input);
            self
        }
        /// <p>Required. The broker's name. This value must be unique in your AWS account, 1-50 characters long, must contain only letters, numbers, dashes, and underscores, and must not contain white spaces, brackets, wildcard characters, or special characters.</p>
        pub fn broker_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.broker_name(inp);
            self
        }
        /// <p>Required. The broker's name. This value must be unique in your AWS account, 1-50 characters long, must contain only letters, numbers, dashes, and underscores, and must not contain white spaces, brackets, wildcard characters, or special characters.</p>
        pub fn set_broker_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_broker_name(input);
            self
        }
        /// <p>A list of information about the configuration.</p>
        pub fn configuration(mut self, inp: crate::model::ConfigurationId) -> Self {
            self.inner = self.inner.configuration(inp);
            self
        }
        /// <p>A list of information about the configuration.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::ConfigurationId>,
        ) -> Self {
            self.inner = self.inner.set_configuration(input);
            self
        }
        /// <p>The unique ID that the requester receives for the created broker. Amazon MQ passes your ID with the API action. Note: We recommend using a Universally Unique Identifier (UUID) for the creatorRequestId. You may omit the creatorRequestId if your application doesn't require idempotency.</p>
        pub fn creator_request_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.creator_request_id(inp);
            self
        }
        /// <p>The unique ID that the requester receives for the created broker. Amazon MQ passes your ID with the API action. Note: We recommend using a Universally Unique Identifier (UUID) for the creatorRequestId. You may omit the creatorRequestId if your application doesn't require idempotency.</p>
        pub fn set_creator_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_creator_request_id(input);
            self
        }
        /// <p>Required. The broker's deployment mode.</p>
        pub fn deployment_mode(mut self, inp: crate::model::DeploymentMode) -> Self {
            self.inner = self.inner.deployment_mode(inp);
            self
        }
        /// <p>Required. The broker's deployment mode.</p>
        pub fn set_deployment_mode(
            mut self,
            input: std::option::Option<crate::model::DeploymentMode>,
        ) -> Self {
            self.inner = self.inner.set_deployment_mode(input);
            self
        }
        /// <p>Encryption options for the broker. Does not apply to RabbitMQ brokers.</p>
        pub fn encryption_options(mut self, inp: crate::model::EncryptionOptions) -> Self {
            self.inner = self.inner.encryption_options(inp);
            self
        }
        /// <p>Encryption options for the broker. Does not apply to RabbitMQ brokers.</p>
        pub fn set_encryption_options(
            mut self,
            input: std::option::Option<crate::model::EncryptionOptions>,
        ) -> Self {
            self.inner = self.inner.set_encryption_options(input);
            self
        }
        /// <p>Required. The type of broker engine. Currently, Amazon MQ supports ACTIVEMQ and RABBITMQ.</p>
        pub fn engine_type(mut self, inp: crate::model::EngineType) -> Self {
            self.inner = self.inner.engine_type(inp);
            self
        }
        /// <p>Required. The type of broker engine. Currently, Amazon MQ supports ACTIVEMQ and RABBITMQ.</p>
        pub fn set_engine_type(
            mut self,
            input: std::option::Option<crate::model::EngineType>,
        ) -> Self {
            self.inner = self.inner.set_engine_type(input);
            self
        }
        /// <p>Required. The broker engine's version. For a list of supported engine versions, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines</a>.</p>
        pub fn engine_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_version(inp);
            self
        }
        /// <p>Required. The broker engine's version. For a list of supported engine versions, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines</a>.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engine_version(input);
            self
        }
        /// <p>Required. The broker's instance type.</p>
        pub fn host_instance_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.host_instance_type(inp);
            self
        }
        /// <p>Required. The broker's instance type.</p>
        pub fn set_host_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_host_instance_type(input);
            self
        }
        /// <p>Optional. The metadata of the LDAP server used to authenticate and authorize connections to the broker. Does not apply to RabbitMQ brokers.</p>
        pub fn ldap_server_metadata(mut self, inp: crate::model::LdapServerMetadataInput) -> Self {
            self.inner = self.inner.ldap_server_metadata(inp);
            self
        }
        /// <p>Optional. The metadata of the LDAP server used to authenticate and authorize connections to the broker. Does not apply to RabbitMQ brokers.</p>
        pub fn set_ldap_server_metadata(
            mut self,
            input: std::option::Option<crate::model::LdapServerMetadataInput>,
        ) -> Self {
            self.inner = self.inner.set_ldap_server_metadata(input);
            self
        }
        /// <p>Enables Amazon CloudWatch logging for brokers.</p>
        pub fn logs(mut self, inp: crate::model::Logs) -> Self {
            self.inner = self.inner.logs(inp);
            self
        }
        /// <p>Enables Amazon CloudWatch logging for brokers.</p>
        pub fn set_logs(mut self, input: std::option::Option<crate::model::Logs>) -> Self {
            self.inner = self.inner.set_logs(input);
            self
        }
        /// <p>The parameters that determine the WeeklyStartTime.</p>
        pub fn maintenance_window_start_time(mut self, inp: crate::model::WeeklyStartTime) -> Self {
            self.inner = self.inner.maintenance_window_start_time(inp);
            self
        }
        /// <p>The parameters that determine the WeeklyStartTime.</p>
        pub fn set_maintenance_window_start_time(
            mut self,
            input: std::option::Option<crate::model::WeeklyStartTime>,
        ) -> Self {
            self.inner = self.inner.set_maintenance_window_start_time(input);
            self
        }
        /// <p>Enables connections from applications outside of the VPC that hosts the broker's subnets. Set to false by default, if no value is provided.</p>
        pub fn publicly_accessible(mut self, inp: bool) -> Self {
            self.inner = self.inner.publicly_accessible(inp);
            self
        }
        /// <p>Enables connections from applications outside of the VPC that hosts the broker's subnets. Set to false by default, if no value is provided.</p>
        pub fn set_publicly_accessible(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_publicly_accessible(input);
            self
        }
        /// Appends an item to `SecurityGroups`.
        ///
        /// To override the contents of this collection use [`set_security_groups`](Self::set_security_groups).
        ///
        /// <p>The list of rules (1 minimum, 125 maximum) that authorize connections to brokers.</p>
        pub fn security_groups(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_groups(inp);
            self
        }
        /// <p>The list of rules (1 minimum, 125 maximum) that authorize connections to brokers.</p>
        pub fn set_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_security_groups(input);
            self
        }
        /// <p>The broker's storage type.</p>
        pub fn storage_type(mut self, inp: crate::model::BrokerStorageType) -> Self {
            self.inner = self.inner.storage_type(inp);
            self
        }
        /// <p>The broker's storage type.</p>
        pub fn set_storage_type(
            mut self,
            input: std::option::Option<crate::model::BrokerStorageType>,
        ) -> Self {
            self.inner = self.inner.set_storage_type(input);
            self
        }
        /// Appends an item to `SubnetIds`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>The list of groups that define which subnets and IP ranges the broker can use from different Availability Zones. If you specify more than one subnet, the subnets must be in different Availability Zones. Amazon MQ will not be able to create VPC endpoints for your broker with multiple subnets in the same Availability Zone. A SINGLE_INSTANCE deployment requires one subnet (for example, the default subnet). An ACTIVE_STANDBY_MULTI_AZ Amazon MQ for ActiveMQ deployment requires two subnets. A CLUSTER_MULTI_AZ Amazon MQ for RabbitMQ deployment has no subnet requirements when deployed with public accessibility. Deployment without public accessibility requires at least one subnet.</p> <important><p>If you specify subnets in a <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-sharing.html">shared VPC</a> for a RabbitMQ broker, the associated VPC to which the specified subnets belong must be owned by your AWS account. Amazon MQ will not be able to create VPC endpoints in VPCs that are not owned by your AWS account.</p></important>
        pub fn subnet_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_ids(inp);
            self
        }
        /// <p>The list of groups that define which subnets and IP ranges the broker can use from different Availability Zones. If you specify more than one subnet, the subnets must be in different Availability Zones. Amazon MQ will not be able to create VPC endpoints for your broker with multiple subnets in the same Availability Zone. A SINGLE_INSTANCE deployment requires one subnet (for example, the default subnet). An ACTIVE_STANDBY_MULTI_AZ Amazon MQ for ActiveMQ deployment requires two subnets. A CLUSTER_MULTI_AZ Amazon MQ for RabbitMQ deployment has no subnet requirements when deployed with public accessibility. Deployment without public accessibility requires at least one subnet.</p> <important><p>If you specify subnets in a <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-sharing.html">shared VPC</a> for a RabbitMQ broker, the associated VPC to which the specified subnets belong must be owned by your AWS account. Amazon MQ will not be able to create VPC endpoints in VPCs that are not owned by your AWS account.</p></important>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subnet_ids(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Create tags when creating the broker.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>Create tags when creating the broker.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// Appends an item to `Users`.
        ///
        /// To override the contents of this collection use [`set_users`](Self::set_users).
        ///
        /// <p>Required. The list of broker users (persons or applications) who can access queues and topics. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p> <important><title>Amazon MQ for RabbitMQ</title> <p>When you create an Amazon MQ for RabbitMQ broker, one and only one administrative user is accepted and created when a broker is first provisioned. All subsequent broker users are created by making RabbitMQ API calls directly to brokers or via the RabbitMQ web console.</p></important>
        pub fn users(mut self, inp: impl Into<crate::model::User>) -> Self {
            self.inner = self.inner.users(inp);
            self
        }
        /// <p>Required. The list of broker users (persons or applications) who can access queues and topics. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p> <important><title>Amazon MQ for RabbitMQ</title> <p>When you create an Amazon MQ for RabbitMQ broker, one and only one administrative user is accepted and created when a broker is first provisioned. All subsequent broker users are created by making RabbitMQ API calls directly to brokers or via the RabbitMQ web console.</p></important>
        pub fn set_users(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::User>>,
        ) -> Self {
            self.inner = self.inner.set_users(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateConfiguration`.
    ///
    /// <p>Creates a new configuration for the specified configuration name. Amazon MQ uses the default configuration (the engine type and version).</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_configuration_input::Builder,
    }
    impl<C, M, R> CreateConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateConfigurationInputOperationOutputAlias,
                crate::output::CreateConfigurationOutput,
                crate::error::CreateConfigurationError,
                crate::input::CreateConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Optional. The authentication strategy associated with the configuration. The default is SIMPLE.</p>
        pub fn authentication_strategy(
            mut self,
            inp: crate::model::AuthenticationStrategy,
        ) -> Self {
            self.inner = self.inner.authentication_strategy(inp);
            self
        }
        /// <p>Optional. The authentication strategy associated with the configuration. The default is SIMPLE.</p>
        pub fn set_authentication_strategy(
            mut self,
            input: std::option::Option<crate::model::AuthenticationStrategy>,
        ) -> Self {
            self.inner = self.inner.set_authentication_strategy(input);
            self
        }
        /// <p>Required. The type of broker engine. Currently, Amazon MQ supports ACTIVEMQ and RABBITMQ.</p>
        pub fn engine_type(mut self, inp: crate::model::EngineType) -> Self {
            self.inner = self.inner.engine_type(inp);
            self
        }
        /// <p>Required. The type of broker engine. Currently, Amazon MQ supports ACTIVEMQ and RABBITMQ.</p>
        pub fn set_engine_type(
            mut self,
            input: std::option::Option<crate::model::EngineType>,
        ) -> Self {
            self.inner = self.inner.set_engine_type(input);
            self
        }
        /// <p>Required. The broker engine's version. For a list of supported engine versions, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines</a>.</p>
        pub fn engine_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_version(inp);
            self
        }
        /// <p>Required. The broker engine's version. For a list of supported engine versions, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines</a>.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engine_version(input);
            self
        }
        /// <p>Required. The name of the configuration. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 1-150 characters long.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>Required. The name of the configuration. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 1-150 characters long.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Create tags when creating the configuration.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>Create tags when creating the configuration.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTags`.
    ///
    /// <p>Add a tag to a resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateTags<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_tags_input::Builder,
    }
    impl<C, M, R> CreateTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateTagsInputOperationOutputAlias,
                crate::output::CreateTagsOutput,
                crate::error::CreateTagsError,
                crate::input::CreateTagsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource tag.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource tag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value pair for the resource tag.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>The key-value pair for the resource tag.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateUser`.
    ///
    /// <p>Creates an ActiveMQ user.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateUser<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_user_input::Builder,
    }
    impl<C, M, R> CreateUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateUserOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateUserInputOperationOutputAlias,
                crate::output::CreateUserOutput,
                crate::error::CreateUserError,
                crate::input::CreateUserInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID that Amazon MQ generates for the broker.</p>
        pub fn broker_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.broker_id(inp);
            self
        }
        /// <p>The unique ID that Amazon MQ generates for the broker.</p>
        pub fn set_broker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_broker_id(input);
            self
        }
        /// <p>Enables access to the ActiveMQ Web Console for the ActiveMQ user.</p>
        pub fn console_access(mut self, inp: bool) -> Self {
            self.inner = self.inner.console_access(inp);
            self
        }
        /// <p>Enables access to the ActiveMQ Web Console for the ActiveMQ user.</p>
        pub fn set_console_access(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_console_access(input);
            self
        }
        /// Appends an item to `Groups`.
        ///
        /// To override the contents of this collection use [`set_groups`](Self::set_groups).
        ///
        /// <p>The list of groups (20 maximum) to which the ActiveMQ user belongs. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
        pub fn groups(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.groups(inp);
            self
        }
        /// <p>The list of groups (20 maximum) to which the ActiveMQ user belongs. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
        pub fn set_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_groups(input);
            self
        }
        /// <p>Required. The password of the user. This value must be at least 12 characters long, must contain at least 4 unique characters, and must not contain commas, colons, or equal signs (,:=).</p>
        pub fn password(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.password(inp);
            self
        }
        /// <p>Required. The password of the user. This value must be at least 12 characters long, must contain at least 4 unique characters, and must not contain commas, colons, or equal signs (,:=).</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_password(input);
            self
        }
        /// <p>The username of the ActiveMQ user. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
        pub fn username(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.username(inp);
            self
        }
        /// <p>The username of the ActiveMQ user. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_username(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBroker`.
    ///
    /// <p>Deletes a broker. Note: This API is asynchronous.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteBroker<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_broker_input::Builder,
    }
    impl<C, M, R> DeleteBroker<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteBroker`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBrokerOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBrokerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteBrokerInputOperationOutputAlias,
                crate::output::DeleteBrokerOutput,
                crate::error::DeleteBrokerError,
                crate::input::DeleteBrokerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID that Amazon MQ generates for the broker.</p>
        pub fn broker_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.broker_id(inp);
            self
        }
        /// <p>The unique ID that Amazon MQ generates for the broker.</p>
        pub fn set_broker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_broker_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTags`.
    ///
    /// <p>Removes a tag from a resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteTags<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_tags_input::Builder,
    }
    impl<C, M, R> DeleteTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteTagsInputOperationOutputAlias,
                crate::output::DeleteTagsOutput,
                crate::error::DeleteTagsError,
                crate::input::DeleteTagsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource tag.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource tag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>An array of tag keys to delete</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>An array of tag keys to delete</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteUser`.
    ///
    /// <p>Deletes an ActiveMQ user.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteUser<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_user_input::Builder,
    }
    impl<C, M, R> DeleteUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteUserOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteUserInputOperationOutputAlias,
                crate::output::DeleteUserOutput,
                crate::error::DeleteUserError,
                crate::input::DeleteUserInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID that Amazon MQ generates for the broker.</p>
        pub fn broker_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.broker_id(inp);
            self
        }
        /// <p>The unique ID that Amazon MQ generates for the broker.</p>
        pub fn set_broker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_broker_id(input);
            self
        }
        /// <p>The username of the ActiveMQ user. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
        pub fn username(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.username(inp);
            self
        }
        /// <p>The username of the ActiveMQ user. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_username(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeBroker`.
    ///
    /// <p>Returns information about the specified broker.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeBroker<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_broker_input::Builder,
    }
    impl<C, M, R> DescribeBroker<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeBroker`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeBrokerOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeBrokerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeBrokerInputOperationOutputAlias,
                crate::output::DescribeBrokerOutput,
                crate::error::DescribeBrokerError,
                crate::input::DescribeBrokerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID that Amazon MQ generates for the broker.</p>
        pub fn broker_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.broker_id(inp);
            self
        }
        /// <p>The unique ID that Amazon MQ generates for the broker.</p>
        pub fn set_broker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_broker_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeBrokerEngineTypes`.
    ///
    /// <p>Describe available engine types and versions.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeBrokerEngineTypes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_broker_engine_types_input::Builder,
    }
    impl<C, M, R> DescribeBrokerEngineTypes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeBrokerEngineTypes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeBrokerEngineTypesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeBrokerEngineTypesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeBrokerEngineTypesInputOperationOutputAlias,
                crate::output::DescribeBrokerEngineTypesOutput,
                crate::error::DescribeBrokerEngineTypesError,
                crate::input::DescribeBrokerEngineTypesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Filter response by engine type.</p>
        pub fn engine_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_type(inp);
            self
        }
        /// <p>Filter response by engine type.</p>
        pub fn set_engine_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_engine_type(input);
            self
        }
        /// <p>The maximum number of brokers that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of brokers that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeBrokerInstanceOptions`.
    ///
    /// <p>Describe available broker instance options.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeBrokerInstanceOptions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_broker_instance_options_input::Builder,
    }
    impl<C, M, R> DescribeBrokerInstanceOptions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeBrokerInstanceOptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeBrokerInstanceOptionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeBrokerInstanceOptionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeBrokerInstanceOptionsInputOperationOutputAlias,
                crate::output::DescribeBrokerInstanceOptionsOutput,
                crate::error::DescribeBrokerInstanceOptionsError,
                crate::input::DescribeBrokerInstanceOptionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Filter response by engine type.</p>
        pub fn engine_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_type(inp);
            self
        }
        /// <p>Filter response by engine type.</p>
        pub fn set_engine_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_engine_type(input);
            self
        }
        /// <p>Filter response by host instance type.</p>
        pub fn host_instance_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.host_instance_type(inp);
            self
        }
        /// <p>Filter response by host instance type.</p>
        pub fn set_host_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_host_instance_type(input);
            self
        }
        /// <p>The maximum number of brokers that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of brokers that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Filter response by storage type.</p>
        pub fn storage_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.storage_type(inp);
            self
        }
        /// <p>Filter response by storage type.</p>
        pub fn set_storage_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_storage_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeConfiguration`.
    ///
    /// <p>Returns information about the specified configuration.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_configuration_input::Builder,
    }
    impl<C, M, R> DescribeConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeConfigurationInputOperationOutputAlias,
                crate::output::DescribeConfigurationOutput,
                crate::error::DescribeConfigurationError,
                crate::input::DescribeConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID that Amazon MQ generates for the configuration.</p>
        pub fn configuration_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_id(inp);
            self
        }
        /// <p>The unique ID that Amazon MQ generates for the configuration.</p>
        pub fn set_configuration_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeConfigurationRevision`.
    ///
    /// <p>Returns the specified configuration revision for the specified configuration.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeConfigurationRevision<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_configuration_revision_input::Builder,
    }
    impl<C, M, R> DescribeConfigurationRevision<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeConfigurationRevision`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeConfigurationRevisionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeConfigurationRevisionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeConfigurationRevisionInputOperationOutputAlias,
                crate::output::DescribeConfigurationRevisionOutput,
                crate::error::DescribeConfigurationRevisionError,
                crate::input::DescribeConfigurationRevisionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID that Amazon MQ generates for the configuration.</p>
        pub fn configuration_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_id(inp);
            self
        }
        /// <p>The unique ID that Amazon MQ generates for the configuration.</p>
        pub fn set_configuration_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_id(input);
            self
        }
        /// <p>The revision of the configuration.</p>
        pub fn configuration_revision(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_revision(inp);
            self
        }
        /// <p>The revision of the configuration.</p>
        pub fn set_configuration_revision(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_revision(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeUser`.
    ///
    /// <p>Returns information about an ActiveMQ user.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeUser<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_user_input::Builder,
    }
    impl<C, M, R> DescribeUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeUserOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeUserInputOperationOutputAlias,
                crate::output::DescribeUserOutput,
                crate::error::DescribeUserError,
                crate::input::DescribeUserInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID that Amazon MQ generates for the broker.</p>
        pub fn broker_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.broker_id(inp);
            self
        }
        /// <p>The unique ID that Amazon MQ generates for the broker.</p>
        pub fn set_broker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_broker_id(input);
            self
        }
        /// <p>The username of the ActiveMQ user. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
        pub fn username(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.username(inp);
            self
        }
        /// <p>The username of the ActiveMQ user. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_username(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListBrokers`.
    ///
    /// <p>Returns a list of all brokers.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListBrokers<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_brokers_input::Builder,
    }
    impl<C, M, R> ListBrokers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListBrokers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBrokersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListBrokersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListBrokersInputOperationOutputAlias,
                crate::output::ListBrokersOutput,
                crate::error::ListBrokersError,
                crate::input::ListBrokersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of brokers that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of brokers that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListConfigurationRevisions`.
    ///
    /// <p>Returns a list of all revisions for the specified configuration.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListConfigurationRevisions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_configuration_revisions_input::Builder,
    }
    impl<C, M, R> ListConfigurationRevisions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListConfigurationRevisions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListConfigurationRevisionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListConfigurationRevisionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListConfigurationRevisionsInputOperationOutputAlias,
                crate::output::ListConfigurationRevisionsOutput,
                crate::error::ListConfigurationRevisionsError,
                crate::input::ListConfigurationRevisionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID that Amazon MQ generates for the configuration.</p>
        pub fn configuration_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_id(inp);
            self
        }
        /// <p>The unique ID that Amazon MQ generates for the configuration.</p>
        pub fn set_configuration_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_id(input);
            self
        }
        /// <p>The maximum number of brokers that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of brokers that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListConfigurations`.
    ///
    /// <p>Returns a list of all configurations.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListConfigurations<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_configurations_input::Builder,
    }
    impl<C, M, R> ListConfigurations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListConfigurations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListConfigurationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListConfigurationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListConfigurationsInputOperationOutputAlias,
                crate::output::ListConfigurationsOutput,
                crate::error::ListConfigurationsError,
                crate::input::ListConfigurationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of brokers that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of brokers that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTags`.
    ///
    /// <p>Lists tags for a resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTags<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_input::Builder,
    }
    impl<C, M, R> ListTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsInputOperationOutputAlias,
                crate::output::ListTagsOutput,
                crate::error::ListTagsError,
                crate::input::ListTagsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource tag.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource tag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListUsers`.
    ///
    /// <p>Returns a list of all ActiveMQ users.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListUsers<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_users_input::Builder,
    }
    impl<C, M, R> ListUsers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListUsers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListUsersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListUsersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListUsersInputOperationOutputAlias,
                crate::output::ListUsersOutput,
                crate::error::ListUsersError,
                crate::input::ListUsersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID that Amazon MQ generates for the broker.</p>
        pub fn broker_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.broker_id(inp);
            self
        }
        /// <p>The unique ID that Amazon MQ generates for the broker.</p>
        pub fn set_broker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_broker_id(input);
            self
        }
        /// <p>The maximum number of brokers that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of brokers that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RebootBroker`.
    ///
    /// <p>Reboots a broker. Note: This API is asynchronous.</p>
    #[derive(std::fmt::Debug)]
    pub struct RebootBroker<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::reboot_broker_input::Builder,
    }
    impl<C, M, R> RebootBroker<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RebootBroker`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RebootBrokerOutput,
            aws_smithy_http::result::SdkError<crate::error::RebootBrokerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RebootBrokerInputOperationOutputAlias,
                crate::output::RebootBrokerOutput,
                crate::error::RebootBrokerError,
                crate::input::RebootBrokerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID that Amazon MQ generates for the broker.</p>
        pub fn broker_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.broker_id(inp);
            self
        }
        /// <p>The unique ID that Amazon MQ generates for the broker.</p>
        pub fn set_broker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_broker_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateBroker`.
    ///
    /// <p>Adds a pending configuration change to a broker.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateBroker<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_broker_input::Builder,
    }
    impl<C, M, R> UpdateBroker<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateBroker`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateBrokerOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateBrokerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateBrokerInputOperationOutputAlias,
                crate::output::UpdateBrokerOutput,
                crate::error::UpdateBrokerError,
                crate::input::UpdateBrokerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Optional. The authentication strategy used to secure the broker. The default is SIMPLE.</p>
        pub fn authentication_strategy(
            mut self,
            inp: crate::model::AuthenticationStrategy,
        ) -> Self {
            self.inner = self.inner.authentication_strategy(inp);
            self
        }
        /// <p>Optional. The authentication strategy used to secure the broker. The default is SIMPLE.</p>
        pub fn set_authentication_strategy(
            mut self,
            input: std::option::Option<crate::model::AuthenticationStrategy>,
        ) -> Self {
            self.inner = self.inner.set_authentication_strategy(input);
            self
        }
        /// <p>Enables automatic upgrades to new minor versions for brokers, as new versions are released and supported by Amazon MQ. Automatic upgrades occur during the scheduled maintenance window of the broker or after a manual broker reboot.</p>
        pub fn auto_minor_version_upgrade(mut self, inp: bool) -> Self {
            self.inner = self.inner.auto_minor_version_upgrade(inp);
            self
        }
        /// <p>Enables automatic upgrades to new minor versions for brokers, as new versions are released and supported by Amazon MQ. Automatic upgrades occur during the scheduled maintenance window of the broker or after a manual broker reboot.</p>
        pub fn set_auto_minor_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_minor_version_upgrade(input);
            self
        }
        /// <p>The unique ID that Amazon MQ generates for the broker.</p>
        pub fn broker_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.broker_id(inp);
            self
        }
        /// <p>The unique ID that Amazon MQ generates for the broker.</p>
        pub fn set_broker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_broker_id(input);
            self
        }
        /// <p>A list of information about the configuration.</p>
        pub fn configuration(mut self, inp: crate::model::ConfigurationId) -> Self {
            self.inner = self.inner.configuration(inp);
            self
        }
        /// <p>A list of information about the configuration.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::ConfigurationId>,
        ) -> Self {
            self.inner = self.inner.set_configuration(input);
            self
        }
        /// <p>The broker engine version. For a list of supported engine versions, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines</a>.</p>
        pub fn engine_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_version(inp);
            self
        }
        /// <p>The broker engine version. For a list of supported engine versions, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines</a>.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engine_version(input);
            self
        }
        /// <p>The broker's host instance type to upgrade to. For a list of supported instance types, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker.html#broker-instance-types">Broker instance types</a>.</p>
        pub fn host_instance_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.host_instance_type(inp);
            self
        }
        /// <p>The broker's host instance type to upgrade to. For a list of supported instance types, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker.html#broker-instance-types">Broker instance types</a>.</p>
        pub fn set_host_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_host_instance_type(input);
            self
        }
        /// <p>Optional. The metadata of the LDAP server used to authenticate and authorize connections to the broker. Does not apply to RabbitMQ brokers.</p>
        pub fn ldap_server_metadata(mut self, inp: crate::model::LdapServerMetadataInput) -> Self {
            self.inner = self.inner.ldap_server_metadata(inp);
            self
        }
        /// <p>Optional. The metadata of the LDAP server used to authenticate and authorize connections to the broker. Does not apply to RabbitMQ brokers.</p>
        pub fn set_ldap_server_metadata(
            mut self,
            input: std::option::Option<crate::model::LdapServerMetadataInput>,
        ) -> Self {
            self.inner = self.inner.set_ldap_server_metadata(input);
            self
        }
        /// <p>Enables Amazon CloudWatch logging for brokers.</p>
        pub fn logs(mut self, inp: crate::model::Logs) -> Self {
            self.inner = self.inner.logs(inp);
            self
        }
        /// <p>Enables Amazon CloudWatch logging for brokers.</p>
        pub fn set_logs(mut self, input: std::option::Option<crate::model::Logs>) -> Self {
            self.inner = self.inner.set_logs(input);
            self
        }
        /// <p>The parameters that determine the WeeklyStartTime.</p>
        pub fn maintenance_window_start_time(mut self, inp: crate::model::WeeklyStartTime) -> Self {
            self.inner = self.inner.maintenance_window_start_time(inp);
            self
        }
        /// <p>The parameters that determine the WeeklyStartTime.</p>
        pub fn set_maintenance_window_start_time(
            mut self,
            input: std::option::Option<crate::model::WeeklyStartTime>,
        ) -> Self {
            self.inner = self.inner.set_maintenance_window_start_time(input);
            self
        }
        /// Appends an item to `SecurityGroups`.
        ///
        /// To override the contents of this collection use [`set_security_groups`](Self::set_security_groups).
        ///
        /// <p>The list of security groups (1 minimum, 5 maximum) that authorizes connections to brokers.</p>
        pub fn security_groups(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_groups(inp);
            self
        }
        /// <p>The list of security groups (1 minimum, 5 maximum) that authorizes connections to brokers.</p>
        pub fn set_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_security_groups(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateConfiguration`.
    ///
    /// <p>Updates the specified configuration.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_configuration_input::Builder,
    }
    impl<C, M, R> UpdateConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateConfigurationInputOperationOutputAlias,
                crate::output::UpdateConfigurationOutput,
                crate::error::UpdateConfigurationError,
                crate::input::UpdateConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID that Amazon MQ generates for the configuration.</p>
        pub fn configuration_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_id(inp);
            self
        }
        /// <p>The unique ID that Amazon MQ generates for the configuration.</p>
        pub fn set_configuration_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_id(input);
            self
        }
        /// <p>Required. The base64-encoded XML configuration.</p>
        pub fn data(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data(inp);
            self
        }
        /// <p>Required. The base64-encoded XML configuration.</p>
        pub fn set_data(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_data(input);
            self
        }
        /// <p>The description of the configuration.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the configuration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateUser`.
    ///
    /// <p>Updates the information for an ActiveMQ user.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateUser<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_user_input::Builder,
    }
    impl<C, M, R> UpdateUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateUserOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateUserInputOperationOutputAlias,
                crate::output::UpdateUserOutput,
                crate::error::UpdateUserError,
                crate::input::UpdateUserInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID that Amazon MQ generates for the broker.</p>
        pub fn broker_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.broker_id(inp);
            self
        }
        /// <p>The unique ID that Amazon MQ generates for the broker.</p>
        pub fn set_broker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_broker_id(input);
            self
        }
        /// <p>Enables access to the the ActiveMQ Web Console for the ActiveMQ user.</p>
        pub fn console_access(mut self, inp: bool) -> Self {
            self.inner = self.inner.console_access(inp);
            self
        }
        /// <p>Enables access to the the ActiveMQ Web Console for the ActiveMQ user.</p>
        pub fn set_console_access(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_console_access(input);
            self
        }
        /// Appends an item to `Groups`.
        ///
        /// To override the contents of this collection use [`set_groups`](Self::set_groups).
        ///
        /// <p>The list of groups (20 maximum) to which the ActiveMQ user belongs. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
        pub fn groups(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.groups(inp);
            self
        }
        /// <p>The list of groups (20 maximum) to which the ActiveMQ user belongs. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
        pub fn set_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_groups(input);
            self
        }
        /// <p>The password of the user. This value must be at least 12 characters long, must contain at least 4 unique characters, and must not contain commas, colons, or equal signs (,:=).</p>
        pub fn password(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.password(inp);
            self
        }
        /// <p>The password of the user. This value must be at least 12 characters long, must contain at least 4 unique characters, and must not contain commas, colons, or equal signs (,:=).</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_password(input);
            self
        }
        /// <p>The username of the ActiveMQ user. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
        pub fn username(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.username(inp);
            self
        }
        /// <p>The username of the ActiveMQ user. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_username(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
