// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CreateProjectInput`](crate::input::CreateProjectInput)
pub mod create_project_input {
    /// A builder for [`CreateProjectInput`](crate::input::CreateProjectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) contents: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) snapshot_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// Name of the project.
        /// </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>
        /// Name of the project.
        /// </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>
        /// Default region where project resources should be created.
        /// </p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>
        /// Default region where project resources should be created.
        /// </p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>
        /// ZIP or YAML file which contains configuration settings to be used when creating
        /// the project. This may be the contents of the file downloaded from the URL provided
        /// in an export project operation.
        /// </p>
        pub fn contents(mut self, input: aws_smithy_types::Blob) -> Self {
            self.contents = Some(input);
            self
        }
        /// <p>
        /// ZIP or YAML file which contains configuration settings to be used when creating
        /// the project. This may be the contents of the file downloaded from the URL provided
        /// in an export project operation.
        /// </p>
        pub fn set_contents(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.contents = input;
            self
        }
        /// <p>
        /// Unique identifier for an exported snapshot of project configuration. This
        /// snapshot identifier is included in the share URL when a project is exported.
        /// </p>
        pub fn snapshot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_id = Some(input.into());
            self
        }
        /// <p>
        /// Unique identifier for an exported snapshot of project configuration. This
        /// snapshot identifier is included in the share URL when a project is exported.
        /// </p>
        pub fn set_snapshot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.snapshot_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateProjectInput`](crate::input::CreateProjectInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateProjectInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateProjectInput {
                name: self.name,
                region: self.region,
                contents: self.contents,
                snapshot_id: self.snapshot_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateProjectInputOperationOutputAlias = crate::operation::CreateProject;
#[doc(hidden)]
pub type CreateProjectInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateProjectInput {
    /// Consumes the builder and constructs an Operation<[`CreateProject`](crate::operation::CreateProject)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateProject,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateProjectInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/projects").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::CreateProjectInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_1) = &_input.name {
                query.push_kv("name", &aws_smithy_http::query::fmt_string(&inner_1));
            }
            if let Some(inner_2) = &_input.region {
                query.push_kv("region", &aws_smithy_http::query::fmt_string(&inner_2));
            }
            if let Some(inner_3) = &_input.snapshot_id {
                query.push_kv("snapshotId", &aws_smithy_http::query::fmt_string(&inner_3));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateProjectInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateProjectInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/octet-stream",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::ser_payload_create_project_input(self.contents)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateProject::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateProject",
            "mobile",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateProjectInput`](crate::input::CreateProjectInput)
    pub fn builder() -> crate::input::create_project_input::Builder {
        crate::input::create_project_input::Builder::default()
    }
}

/// See [`DeleteProjectInput`](crate::input::DeleteProjectInput)
pub mod delete_project_input {
    /// A builder for [`DeleteProjectInput`](crate::input::DeleteProjectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// Unique project identifier.
        /// </p>
        pub fn project_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_id = Some(input.into());
            self
        }
        /// <p>
        /// Unique project identifier.
        /// </p>
        pub fn set_project_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteProjectInput`](crate::input::DeleteProjectInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteProjectInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteProjectInput {
                project_id: self.project_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteProjectInputOperationOutputAlias = crate::operation::DeleteProject;
#[doc(hidden)]
pub type DeleteProjectInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteProjectInput {
    /// Consumes the builder and constructs an Operation<[`DeleteProject`](crate::operation::DeleteProject)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteProject,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteProjectInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_4 = &_input.project_id;
            let input_4 =
                input_4
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "project_id",
                        details: "cannot be empty or unset",
                    })?;
            let project_id = aws_smithy_http::label::fmt_string(input_4, false);
            if project_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "project_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/projects/{projectId}", projectId = project_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteProjectInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteProjectInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteProject::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteProject",
            "mobile",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteProjectInput`](crate::input::DeleteProjectInput)
    pub fn builder() -> crate::input::delete_project_input::Builder {
        crate::input::delete_project_input::Builder::default()
    }
}

/// See [`DescribeBundleInput`](crate::input::DescribeBundleInput)
pub mod describe_bundle_input {
    /// A builder for [`DescribeBundleInput`](crate::input::DescribeBundleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bundle_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// Unique bundle identifier.
        /// </p>
        pub fn bundle_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bundle_id = Some(input.into());
            self
        }
        /// <p>
        /// Unique bundle identifier.
        /// </p>
        pub fn set_bundle_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bundle_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeBundleInput`](crate::input::DescribeBundleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeBundleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeBundleInput {
                bundle_id: self.bundle_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeBundleInputOperationOutputAlias = crate::operation::DescribeBundle;
#[doc(hidden)]
pub type DescribeBundleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeBundleInput {
    /// Consumes the builder and constructs an Operation<[`DescribeBundle`](crate::operation::DescribeBundle)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeBundle,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeBundleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_5 = &_input.bundle_id;
            let input_5 =
                input_5
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bundle_id",
                        details: "cannot be empty or unset",
                    })?;
            let bundle_id = aws_smithy_http::label::fmt_string(input_5, false);
            if bundle_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bundle_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/bundles/{bundleId}", bundleId = bundle_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeBundleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeBundleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeBundle::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeBundle",
            "mobile",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeBundleInput`](crate::input::DescribeBundleInput)
    pub fn builder() -> crate::input::describe_bundle_input::Builder {
        crate::input::describe_bundle_input::Builder::default()
    }
}

/// See [`DescribeProjectInput`](crate::input::DescribeProjectInput)
pub mod describe_project_input {
    /// A builder for [`DescribeProjectInput`](crate::input::DescribeProjectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_id: std::option::Option<std::string::String>,
        pub(crate) sync_from_resources: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>
        /// Unique project identifier.
        /// </p>
        pub fn project_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_id = Some(input.into());
            self
        }
        /// <p>
        /// Unique project identifier.
        /// </p>
        pub fn set_project_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_id = input;
            self
        }
        /// <p>
        /// If set to true, causes AWS Mobile Hub to synchronize information from other services, e.g., update state of AWS CloudFormation stacks in the AWS Mobile Hub project.
        /// </p>
        pub fn sync_from_resources(mut self, input: bool) -> Self {
            self.sync_from_resources = Some(input);
            self
        }
        /// <p>
        /// If set to true, causes AWS Mobile Hub to synchronize information from other services, e.g., update state of AWS CloudFormation stacks in the AWS Mobile Hub project.
        /// </p>
        pub fn set_sync_from_resources(mut self, input: std::option::Option<bool>) -> Self {
            self.sync_from_resources = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeProjectInput`](crate::input::DescribeProjectInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeProjectInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeProjectInput {
                project_id: self.project_id,
                sync_from_resources: self.sync_from_resources.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeProjectInputOperationOutputAlias = crate::operation::DescribeProject;
#[doc(hidden)]
pub type DescribeProjectInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeProjectInput {
    /// Consumes the builder and constructs an Operation<[`DescribeProject`](crate::operation::DescribeProject)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeProject,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeProjectInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/project").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::DescribeProjectInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_6) = &_input.project_id {
                query.push_kv("projectId", &aws_smithy_http::query::fmt_string(&inner_6));
            }
            if _input.sync_from_resources {
                query.push_kv(
                    "syncFromResources",
                    &aws_smithy_types::primitive::Encoder::from(_input.sync_from_resources)
                        .encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeProjectInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeProjectInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeProject::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeProject",
            "mobile",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeProjectInput`](crate::input::DescribeProjectInput)
    pub fn builder() -> crate::input::describe_project_input::Builder {
        crate::input::describe_project_input::Builder::default()
    }
}

/// See [`ExportBundleInput`](crate::input::ExportBundleInput)
pub mod export_bundle_input {
    /// A builder for [`ExportBundleInput`](crate::input::ExportBundleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bundle_id: std::option::Option<std::string::String>,
        pub(crate) project_id: std::option::Option<std::string::String>,
        pub(crate) platform: std::option::Option<crate::model::Platform>,
    }
    impl Builder {
        /// <p>
        /// Unique bundle identifier.
        /// </p>
        pub fn bundle_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bundle_id = Some(input.into());
            self
        }
        /// <p>
        /// Unique bundle identifier.
        /// </p>
        pub fn set_bundle_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bundle_id = input;
            self
        }
        /// <p>
        /// Unique project identifier.
        /// </p>
        pub fn project_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_id = Some(input.into());
            self
        }
        /// <p>
        /// Unique project identifier.
        /// </p>
        pub fn set_project_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_id = input;
            self
        }
        /// <p>
        /// Developer desktop or target application platform.
        /// </p>
        pub fn platform(mut self, input: crate::model::Platform) -> Self {
            self.platform = Some(input);
            self
        }
        /// <p>
        /// Developer desktop or target application platform.
        /// </p>
        pub fn set_platform(mut self, input: std::option::Option<crate::model::Platform>) -> Self {
            self.platform = input;
            self
        }
        /// Consumes the builder and constructs a [`ExportBundleInput`](crate::input::ExportBundleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ExportBundleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ExportBundleInput {
                bundle_id: self.bundle_id,
                project_id: self.project_id,
                platform: self.platform,
            })
        }
    }
}
#[doc(hidden)]
pub type ExportBundleInputOperationOutputAlias = crate::operation::ExportBundle;
#[doc(hidden)]
pub type ExportBundleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ExportBundleInput {
    /// Consumes the builder and constructs an Operation<[`ExportBundle`](crate::operation::ExportBundle)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ExportBundle,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ExportBundleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_7 = &_input.bundle_id;
            let input_7 =
                input_7
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bundle_id",
                        details: "cannot be empty or unset",
                    })?;
            let bundle_id = aws_smithy_http::label::fmt_string(input_7, false);
            if bundle_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bundle_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/bundles/{bundleId}", bundleId = bundle_id)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ExportBundleInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_8) = &_input.project_id {
                query.push_kv("projectId", &aws_smithy_http::query::fmt_string(&inner_8));
            }
            if let Some(inner_9) = &_input.platform {
                query.push_kv("platform", &aws_smithy_http::query::fmt_string(&inner_9));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ExportBundleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ExportBundleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ExportBundle::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ExportBundle",
            "mobile",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ExportBundleInput`](crate::input::ExportBundleInput)
    pub fn builder() -> crate::input::export_bundle_input::Builder {
        crate::input::export_bundle_input::Builder::default()
    }
}

/// See [`ExportProjectInput`](crate::input::ExportProjectInput)
pub mod export_project_input {
    /// A builder for [`ExportProjectInput`](crate::input::ExportProjectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// Unique project identifier.
        /// </p>
        pub fn project_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_id = Some(input.into());
            self
        }
        /// <p>
        /// Unique project identifier.
        /// </p>
        pub fn set_project_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ExportProjectInput`](crate::input::ExportProjectInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ExportProjectInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ExportProjectInput {
                project_id: self.project_id,
            })
        }
    }
}
#[doc(hidden)]
pub type ExportProjectInputOperationOutputAlias = crate::operation::ExportProject;
#[doc(hidden)]
pub type ExportProjectInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ExportProjectInput {
    /// Consumes the builder and constructs an Operation<[`ExportProject`](crate::operation::ExportProject)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ExportProject,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ExportProjectInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_10 = &_input.project_id;
            let input_10 =
                input_10
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "project_id",
                        details: "cannot be empty or unset",
                    })?;
            let project_id = aws_smithy_http::label::fmt_string(input_10, false);
            if project_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "project_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/exports/{projectId}", projectId = project_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ExportProjectInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ExportProjectInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ExportProject::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ExportProject",
            "mobile",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ExportProjectInput`](crate::input::ExportProjectInput)
    pub fn builder() -> crate::input::export_project_input::Builder {
        crate::input::export_project_input::Builder::default()
    }
}

/// See [`ListBundlesInput`](crate::input::ListBundlesInput)
pub mod list_bundles_input {
    /// A builder for [`ListBundlesInput`](crate::input::ListBundlesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// Maximum number of records to list in a single response.
        /// </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>
        /// Maximum number of records to list in a single response.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>
        /// Pagination token. Set to null to start listing bundles from start.
        /// If non-null pagination token is returned in a result, then pass its
        /// value in here in another request to list more bundles.
        /// </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>
        /// Pagination token. Set to null to start listing bundles from start.
        /// If non-null pagination token is returned in a result, then pass its
        /// value in here in another request to list more bundles.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBundlesInput`](crate::input::ListBundlesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListBundlesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListBundlesInput {
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListBundlesInputOperationOutputAlias = crate::operation::ListBundles;
#[doc(hidden)]
pub type ListBundlesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListBundlesInput {
    /// Consumes the builder and constructs an Operation<[`ListBundles`](crate::operation::ListBundles)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListBundles,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListBundlesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/bundles").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListBundlesInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_11) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_11));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListBundlesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListBundlesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListBundles::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListBundles",
            "mobile",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListBundlesInput`](crate::input::ListBundlesInput)
    pub fn builder() -> crate::input::list_bundles_input::Builder {
        crate::input::list_bundles_input::Builder::default()
    }
}

/// See [`ListProjectsInput`](crate::input::ListProjectsInput)
pub mod list_projects_input {
    /// A builder for [`ListProjectsInput`](crate::input::ListProjectsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// Maximum number of records to list in a single response.
        /// </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>
        /// Maximum number of records to list in a single response.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>
        /// Pagination token. Set to null to start listing projects from start.
        /// If non-null pagination token is returned in a result, then pass its
        /// value in here in another request to list more projects.
        /// </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>
        /// Pagination token. Set to null to start listing projects from start.
        /// If non-null pagination token is returned in a result, then pass its
        /// value in here in another request to list more projects.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListProjectsInput`](crate::input::ListProjectsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListProjectsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListProjectsInput {
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListProjectsInputOperationOutputAlias = crate::operation::ListProjects;
#[doc(hidden)]
pub type ListProjectsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListProjectsInput {
    /// Consumes the builder and constructs an Operation<[`ListProjects`](crate::operation::ListProjects)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListProjects,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListProjectsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/projects").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListProjectsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_12) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_12));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListProjectsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListProjectsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListProjects::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListProjects",
            "mobile",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListProjectsInput`](crate::input::ListProjectsInput)
    pub fn builder() -> crate::input::list_projects_input::Builder {
        crate::input::list_projects_input::Builder::default()
    }
}

/// See [`UpdateProjectInput`](crate::input::UpdateProjectInput)
pub mod update_project_input {
    /// A builder for [`UpdateProjectInput`](crate::input::UpdateProjectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) contents: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) project_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// ZIP or YAML file which contains project configuration to be updated. This should
        /// be the contents of the file downloaded from the URL provided in an export project
        /// operation.
        /// </p>
        pub fn contents(mut self, input: aws_smithy_types::Blob) -> Self {
            self.contents = Some(input);
            self
        }
        /// <p>
        /// ZIP or YAML file which contains project configuration to be updated. This should
        /// be the contents of the file downloaded from the URL provided in an export project
        /// operation.
        /// </p>
        pub fn set_contents(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.contents = input;
            self
        }
        /// <p>
        /// Unique project identifier.
        /// </p>
        pub fn project_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_id = Some(input.into());
            self
        }
        /// <p>
        /// Unique project identifier.
        /// </p>
        pub fn set_project_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateProjectInput`](crate::input::UpdateProjectInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateProjectInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateProjectInput {
                contents: self.contents,
                project_id: self.project_id,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateProjectInputOperationOutputAlias = crate::operation::UpdateProject;
#[doc(hidden)]
pub type UpdateProjectInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateProjectInput {
    /// Consumes the builder and constructs an Operation<[`UpdateProject`](crate::operation::UpdateProject)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateProject,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateProjectInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/update").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::UpdateProjectInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_13) = &_input.project_id {
                query.push_kv("projectId", &aws_smithy_http::query::fmt_string(&inner_13));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateProjectInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateProjectInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/octet-stream",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::ser_payload_update_project_input(self.contents)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateProject::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateProject",
            "mobile",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateProjectInput`](crate::input::UpdateProjectInput)
    pub fn builder() -> crate::input::update_project_input::Builder {
        crate::input::update_project_input::Builder::default()
    }
}

/// <p>
/// Request structure used for requests to update project configuration.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateProjectInput {
    /// <p>
    /// ZIP or YAML file which contains project configuration to be updated. This should
    /// be the contents of the file downloaded from the URL provided in an export project
    /// operation.
    /// </p>
    pub contents: std::option::Option<aws_smithy_types::Blob>,
    /// <p>
    /// Unique project identifier.
    /// </p>
    pub project_id: std::option::Option<std::string::String>,
}
impl UpdateProjectInput {
    /// <p>
    /// ZIP or YAML file which contains project configuration to be updated. This should
    /// be the contents of the file downloaded from the URL provided in an export project
    /// operation.
    /// </p>
    pub fn contents(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.contents.as_ref()
    }
    /// <p>
    /// Unique project identifier.
    /// </p>
    pub fn project_id(&self) -> std::option::Option<&str> {
        self.project_id.as_deref()
    }
}
impl std::fmt::Debug for UpdateProjectInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateProjectInput");
        formatter.field("contents", &self.contents);
        formatter.field("project_id", &self.project_id);
        formatter.finish()
    }
}

/// <p>
/// Request structure used to request projects list in AWS Mobile Hub.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListProjectsInput {
    /// <p>
    /// Maximum number of records to list in a single response.
    /// </p>
    pub max_results: i32,
    /// <p>
    /// Pagination token. Set to null to start listing projects from start.
    /// If non-null pagination token is returned in a result, then pass its
    /// value in here in another request to list more projects.
    /// </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListProjectsInput {
    /// <p>
    /// Maximum number of records to list in a single response.
    /// </p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>
    /// Pagination token. Set to null to start listing projects from start.
    /// If non-null pagination token is returned in a result, then pass its
    /// value in here in another request to list more projects.
    /// </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListProjectsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListProjectsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p>
/// Request structure to request all available bundles.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBundlesInput {
    /// <p>
    /// Maximum number of records to list in a single response.
    /// </p>
    pub max_results: i32,
    /// <p>
    /// Pagination token. Set to null to start listing bundles from start.
    /// If non-null pagination token is returned in a result, then pass its
    /// value in here in another request to list more bundles.
    /// </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListBundlesInput {
    /// <p>
    /// Maximum number of records to list in a single response.
    /// </p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>
    /// Pagination token. Set to null to start listing bundles from start.
    /// If non-null pagination token is returned in a result, then pass its
    /// value in here in another request to list more bundles.
    /// </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListBundlesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBundlesInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p>
/// Request structure used in requests to export project configuration details.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExportProjectInput {
    /// <p>
    /// Unique project identifier.
    /// </p>
    pub project_id: std::option::Option<std::string::String>,
}
impl ExportProjectInput {
    /// <p>
    /// Unique project identifier.
    /// </p>
    pub fn project_id(&self) -> std::option::Option<&str> {
        self.project_id.as_deref()
    }
}
impl std::fmt::Debug for ExportProjectInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExportProjectInput");
        formatter.field("project_id", &self.project_id);
        formatter.finish()
    }
}

/// <p>
/// Request structure used to request generation of custom SDK and tool packages
/// required to integrate mobile web or app clients with backed AWS resources.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExportBundleInput {
    /// <p>
    /// Unique bundle identifier.
    /// </p>
    pub bundle_id: std::option::Option<std::string::String>,
    /// <p>
    /// Unique project identifier.
    /// </p>
    pub project_id: std::option::Option<std::string::String>,
    /// <p>
    /// Developer desktop or target application platform.
    /// </p>
    pub platform: std::option::Option<crate::model::Platform>,
}
impl ExportBundleInput {
    /// <p>
    /// Unique bundle identifier.
    /// </p>
    pub fn bundle_id(&self) -> std::option::Option<&str> {
        self.bundle_id.as_deref()
    }
    /// <p>
    /// Unique project identifier.
    /// </p>
    pub fn project_id(&self) -> std::option::Option<&str> {
        self.project_id.as_deref()
    }
    /// <p>
    /// Developer desktop or target application platform.
    /// </p>
    pub fn platform(&self) -> std::option::Option<&crate::model::Platform> {
        self.platform.as_ref()
    }
}
impl std::fmt::Debug for ExportBundleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExportBundleInput");
        formatter.field("bundle_id", &self.bundle_id);
        formatter.field("project_id", &self.project_id);
        formatter.field("platform", &self.platform);
        formatter.finish()
    }
}

/// <p>
/// Request structure used to request details about a project.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeProjectInput {
    /// <p>
    /// Unique project identifier.
    /// </p>
    pub project_id: std::option::Option<std::string::String>,
    /// <p>
    /// If set to true, causes AWS Mobile Hub to synchronize information from other services, e.g., update state of AWS CloudFormation stacks in the AWS Mobile Hub project.
    /// </p>
    pub sync_from_resources: bool,
}
impl DescribeProjectInput {
    /// <p>
    /// Unique project identifier.
    /// </p>
    pub fn project_id(&self) -> std::option::Option<&str> {
        self.project_id.as_deref()
    }
    /// <p>
    /// If set to true, causes AWS Mobile Hub to synchronize information from other services, e.g., update state of AWS CloudFormation stacks in the AWS Mobile Hub project.
    /// </p>
    pub fn sync_from_resources(&self) -> bool {
        self.sync_from_resources
    }
}
impl std::fmt::Debug for DescribeProjectInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeProjectInput");
        formatter.field("project_id", &self.project_id);
        formatter.field("sync_from_resources", &self.sync_from_resources);
        formatter.finish()
    }
}

/// <p>
/// Request structure to request the details of a specific bundle.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeBundleInput {
    /// <p>
    /// Unique bundle identifier.
    /// </p>
    pub bundle_id: std::option::Option<std::string::String>,
}
impl DescribeBundleInput {
    /// <p>
    /// Unique bundle identifier.
    /// </p>
    pub fn bundle_id(&self) -> std::option::Option<&str> {
        self.bundle_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeBundleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeBundleInput");
        formatter.field("bundle_id", &self.bundle_id);
        formatter.finish()
    }
}

/// <p>
/// Request structure used to request a project be deleted.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteProjectInput {
    /// <p>
    /// Unique project identifier.
    /// </p>
    pub project_id: std::option::Option<std::string::String>,
}
impl DeleteProjectInput {
    /// <p>
    /// Unique project identifier.
    /// </p>
    pub fn project_id(&self) -> std::option::Option<&str> {
        self.project_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteProjectInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteProjectInput");
        formatter.field("project_id", &self.project_id);
        formatter.finish()
    }
}

/// <p>
/// Request structure used to request a project be created.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateProjectInput {
    /// <p>
    /// Name of the project.
    /// </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>
    /// Default region where project resources should be created.
    /// </p>
    pub region: std::option::Option<std::string::String>,
    /// <p>
    /// ZIP or YAML file which contains configuration settings to be used when creating
    /// the project. This may be the contents of the file downloaded from the URL provided
    /// in an export project operation.
    /// </p>
    pub contents: std::option::Option<aws_smithy_types::Blob>,
    /// <p>
    /// Unique identifier for an exported snapshot of project configuration. This
    /// snapshot identifier is included in the share URL when a project is exported.
    /// </p>
    pub snapshot_id: std::option::Option<std::string::String>,
}
impl CreateProjectInput {
    /// <p>
    /// Name of the project.
    /// </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>
    /// Default region where project resources should be created.
    /// </p>
    pub fn region(&self) -> std::option::Option<&str> {
        self.region.as_deref()
    }
    /// <p>
    /// ZIP or YAML file which contains configuration settings to be used when creating
    /// the project. This may be the contents of the file downloaded from the URL provided
    /// in an export project operation.
    /// </p>
    pub fn contents(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.contents.as_ref()
    }
    /// <p>
    /// Unique identifier for an exported snapshot of project configuration. This
    /// snapshot identifier is included in the share URL when a project is exported.
    /// </p>
    pub fn snapshot_id(&self) -> std::option::Option<&str> {
        self.snapshot_id.as_deref()
    }
}
impl std::fmt::Debug for CreateProjectInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateProjectInput");
        formatter.field("name", &self.name);
        formatter.field("region", &self.region);
        formatter.field("contents", &self.contents);
        formatter.field("snapshot_id", &self.snapshot_id);
        formatter.finish()
    }
}
