// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CreateProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateProjectError {
    /// Kind of error that occurred.
    pub kind: CreateProjectErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateProjectErrorKind {
    /// <p>
    /// The request cannot be processed because some parameter is not valid or the project
    /// state prevents the operation from being performed.
    /// </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>
    /// The service has encountered an unexpected error condition which prevents it from
    /// servicing the request.
    /// </p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>
    /// There are too many AWS Mobile Hub projects in the account or the account has
    /// exceeded the maximum number of resources in some AWS service. You should create
    /// another sub-account using AWS Organizations or remove some resources and retry
    /// your request.
    /// </p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>
    /// No entity can be found with the specified identifier.
    /// </p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>
    /// The service is temporarily unavailable. The request should be retried after some
    /// time delay.
    /// </p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>
    /// Too many requests have been received for this AWS account in too short a time. The
    /// request should be retried after some time delay.
    /// </p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>
    /// Credentials of the caller are insufficient to authorize the request.
    /// </p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateProjectError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateProjectErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateProjectErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateProjectErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateProjectErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateProjectErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateProjectErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateProjectErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreateProjectErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateProjectError {
    fn code(&self) -> Option<&str> {
        CreateProjectError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateProjectError {
    /// Creates a new `CreateProjectError`.
    pub fn new(kind: CreateProjectErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateProjectError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateProjectErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateProjectError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateProjectErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateProjectErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreateProjectErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `CreateProjectErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProjectErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `CreateProjectErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProjectErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateProjectErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateProjectErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `CreateProjectErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProjectErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `CreateProjectErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProjectErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `CreateProjectErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, CreateProjectErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for CreateProjectError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateProjectErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateProjectErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateProjectErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateProjectErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateProjectErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateProjectErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateProjectErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreateProjectErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteProjectError {
    /// Kind of error that occurred.
    pub kind: DeleteProjectErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteProjectErrorKind {
    /// <p>
    /// The service has encountered an unexpected error condition which prevents it from
    /// servicing the request.
    /// </p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>
    /// No entity can be found with the specified identifier.
    /// </p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>
    /// The service is temporarily unavailable. The request should be retried after some
    /// time delay.
    /// </p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>
    /// Too many requests have been received for this AWS account in too short a time. The
    /// request should be retried after some time delay.
    /// </p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>
    /// Credentials of the caller are insufficient to authorize the request.
    /// </p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteProjectError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteProjectErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteProjectErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteProjectErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteProjectErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteProjectErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteProjectErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteProjectError {
    fn code(&self) -> Option<&str> {
        DeleteProjectError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteProjectError {
    /// Creates a new `DeleteProjectError`.
    pub fn new(kind: DeleteProjectErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteProjectError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteProjectErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteProjectError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteProjectErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteProjectErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProjectErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `DeleteProjectErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteProjectErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `DeleteProjectErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProjectErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `DeleteProjectErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProjectErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `DeleteProjectErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, DeleteProjectErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for DeleteProjectError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteProjectErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteProjectErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteProjectErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteProjectErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteProjectErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteProjectErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeBundle` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeBundleError {
    /// Kind of error that occurred.
    pub kind: DescribeBundleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeBundle` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeBundleErrorKind {
    /// <p>
    /// The request cannot be processed because some parameter is not valid or the project
    /// state prevents the operation from being performed.
    /// </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>
    /// The service has encountered an unexpected error condition which prevents it from
    /// servicing the request.
    /// </p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>
    /// No entity can be found with the specified identifier.
    /// </p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>
    /// The service is temporarily unavailable. The request should be retried after some
    /// time delay.
    /// </p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>
    /// Too many requests have been received for this AWS account in too short a time. The
    /// request should be retried after some time delay.
    /// </p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>
    /// Credentials of the caller are insufficient to authorize the request.
    /// </p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeBundleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeBundleErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DescribeBundleErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribeBundleErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeBundleErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeBundleErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DescribeBundleErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DescribeBundleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeBundleError {
    fn code(&self) -> Option<&str> {
        DescribeBundleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeBundleError {
    /// Creates a new `DescribeBundleError`.
    pub fn new(kind: DescribeBundleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeBundleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeBundleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeBundleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeBundleErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeBundleErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DescribeBundleErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `DescribeBundleErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBundleErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `DescribeBundleErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DescribeBundleErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `DescribeBundleErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBundleErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `DescribeBundleErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBundleErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `DescribeBundleErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBundleErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DescribeBundleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeBundleErrorKind::BadRequestException(_inner) => Some(_inner),
            DescribeBundleErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeBundleErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeBundleErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeBundleErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DescribeBundleErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DescribeBundleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeProjectError {
    /// Kind of error that occurred.
    pub kind: DescribeProjectErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeProjectErrorKind {
    /// <p>
    /// The request cannot be processed because some parameter is not valid or the project
    /// state prevents the operation from being performed.
    /// </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>
    /// The service has encountered an unexpected error condition which prevents it from
    /// servicing the request.
    /// </p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>
    /// No entity can be found with the specified identifier.
    /// </p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>
    /// The service is temporarily unavailable. The request should be retried after some
    /// time delay.
    /// </p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>
    /// Too many requests have been received for this AWS account in too short a time. The
    /// request should be retried after some time delay.
    /// </p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>
    /// Credentials of the caller are insufficient to authorize the request.
    /// </p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeProjectError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeProjectErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DescribeProjectErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribeProjectErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeProjectErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeProjectErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DescribeProjectErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DescribeProjectErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeProjectError {
    fn code(&self) -> Option<&str> {
        DescribeProjectError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeProjectError {
    /// Creates a new `DescribeProjectError`.
    pub fn new(kind: DescribeProjectErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeProjectError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeProjectErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeProjectError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeProjectErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeProjectErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DescribeProjectErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `DescribeProjectErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeProjectErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `DescribeProjectErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DescribeProjectErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `DescribeProjectErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeProjectErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `DescribeProjectErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeProjectErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `DescribeProjectErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeProjectErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DescribeProjectError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeProjectErrorKind::BadRequestException(_inner) => Some(_inner),
            DescribeProjectErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeProjectErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeProjectErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeProjectErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DescribeProjectErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DescribeProjectErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ExportBundle` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ExportBundleError {
    /// Kind of error that occurred.
    pub kind: ExportBundleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ExportBundle` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ExportBundleErrorKind {
    /// <p>
    /// The request cannot be processed because some parameter is not valid or the project
    /// state prevents the operation from being performed.
    /// </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>
    /// The service has encountered an unexpected error condition which prevents it from
    /// servicing the request.
    /// </p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>
    /// No entity can be found with the specified identifier.
    /// </p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>
    /// The service is temporarily unavailable. The request should be retried after some
    /// time delay.
    /// </p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>
    /// Too many requests have been received for this AWS account in too short a time. The
    /// request should be retried after some time delay.
    /// </p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>
    /// Credentials of the caller are insufficient to authorize the request.
    /// </p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ExportBundleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ExportBundleErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ExportBundleErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ExportBundleErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ExportBundleErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ExportBundleErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ExportBundleErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ExportBundleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ExportBundleError {
    fn code(&self) -> Option<&str> {
        ExportBundleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ExportBundleError {
    /// Creates a new `ExportBundleError`.
    pub fn new(kind: ExportBundleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ExportBundleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ExportBundleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ExportBundleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ExportBundleErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ExportBundleErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ExportBundleErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `ExportBundleErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExportBundleErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `ExportBundleErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ExportBundleErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `ExportBundleErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExportBundleErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `ExportBundleErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExportBundleErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `ExportBundleErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, ExportBundleErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for ExportBundleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ExportBundleErrorKind::BadRequestException(_inner) => Some(_inner),
            ExportBundleErrorKind::InternalFailureException(_inner) => Some(_inner),
            ExportBundleErrorKind::NotFoundException(_inner) => Some(_inner),
            ExportBundleErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ExportBundleErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ExportBundleErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ExportBundleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ExportProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ExportProjectError {
    /// Kind of error that occurred.
    pub kind: ExportProjectErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ExportProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ExportProjectErrorKind {
    /// <p>
    /// The request cannot be processed because some parameter is not valid or the project
    /// state prevents the operation from being performed.
    /// </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>
    /// The service has encountered an unexpected error condition which prevents it from
    /// servicing the request.
    /// </p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>
    /// No entity can be found with the specified identifier.
    /// </p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>
    /// The service is temporarily unavailable. The request should be retried after some
    /// time delay.
    /// </p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>
    /// Too many requests have been received for this AWS account in too short a time. The
    /// request should be retried after some time delay.
    /// </p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>
    /// Credentials of the caller are insufficient to authorize the request.
    /// </p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ExportProjectError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ExportProjectErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ExportProjectErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ExportProjectErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ExportProjectErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ExportProjectErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ExportProjectErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ExportProjectErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ExportProjectError {
    fn code(&self) -> Option<&str> {
        ExportProjectError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ExportProjectError {
    /// Creates a new `ExportProjectError`.
    pub fn new(kind: ExportProjectErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ExportProjectError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ExportProjectErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ExportProjectError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ExportProjectErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ExportProjectErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ExportProjectErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `ExportProjectErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExportProjectErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `ExportProjectErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ExportProjectErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `ExportProjectErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExportProjectErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `ExportProjectErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExportProjectErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `ExportProjectErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, ExportProjectErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for ExportProjectError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ExportProjectErrorKind::BadRequestException(_inner) => Some(_inner),
            ExportProjectErrorKind::InternalFailureException(_inner) => Some(_inner),
            ExportProjectErrorKind::NotFoundException(_inner) => Some(_inner),
            ExportProjectErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ExportProjectErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ExportProjectErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ExportProjectErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListBundles` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListBundlesError {
    /// Kind of error that occurred.
    pub kind: ListBundlesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListBundles` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListBundlesErrorKind {
    /// <p>
    /// The request cannot be processed because some parameter is not valid or the project
    /// state prevents the operation from being performed.
    /// </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>
    /// The service has encountered an unexpected error condition which prevents it from
    /// servicing the request.
    /// </p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>
    /// The service is temporarily unavailable. The request should be retried after some
    /// time delay.
    /// </p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>
    /// Too many requests have been received for this AWS account in too short a time. The
    /// request should be retried after some time delay.
    /// </p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>
    /// Credentials of the caller are insufficient to authorize the request.
    /// </p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListBundlesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListBundlesErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListBundlesErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListBundlesErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListBundlesErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListBundlesErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ListBundlesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListBundlesError {
    fn code(&self) -> Option<&str> {
        ListBundlesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListBundlesError {
    /// Creates a new `ListBundlesError`.
    pub fn new(kind: ListBundlesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListBundlesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListBundlesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListBundlesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListBundlesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListBundlesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ListBundlesErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `ListBundlesErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBundlesErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `ListBundlesErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBundlesErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `ListBundlesErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBundlesErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `ListBundlesErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, ListBundlesErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for ListBundlesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListBundlesErrorKind::BadRequestException(_inner) => Some(_inner),
            ListBundlesErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListBundlesErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListBundlesErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListBundlesErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ListBundlesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListProjects` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListProjectsError {
    /// Kind of error that occurred.
    pub kind: ListProjectsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListProjects` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListProjectsErrorKind {
    /// <p>
    /// The request cannot be processed because some parameter is not valid or the project
    /// state prevents the operation from being performed.
    /// </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>
    /// The service has encountered an unexpected error condition which prevents it from
    /// servicing the request.
    /// </p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>
    /// The service is temporarily unavailable. The request should be retried after some
    /// time delay.
    /// </p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>
    /// Too many requests have been received for this AWS account in too short a time. The
    /// request should be retried after some time delay.
    /// </p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>
    /// Credentials of the caller are insufficient to authorize the request.
    /// </p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListProjectsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListProjectsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListProjectsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListProjectsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListProjectsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListProjectsErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ListProjectsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListProjectsError {
    fn code(&self) -> Option<&str> {
        ListProjectsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListProjectsError {
    /// Creates a new `ListProjectsError`.
    pub fn new(kind: ListProjectsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListProjectsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListProjectsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListProjectsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListProjectsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListProjectsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ListProjectsErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `ListProjectsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProjectsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `ListProjectsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProjectsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `ListProjectsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProjectsErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `ListProjectsErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, ListProjectsErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for ListProjectsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListProjectsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListProjectsErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListProjectsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListProjectsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListProjectsErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ListProjectsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateProjectError {
    /// Kind of error that occurred.
    pub kind: UpdateProjectErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateProjectErrorKind {
    /// <p>
    /// Account Action is required in order to continue the request.
    /// </p>
    AccountActionRequiredException(crate::error::AccountActionRequiredException),
    /// <p>
    /// The request cannot be processed because some parameter is not valid or the project
    /// state prevents the operation from being performed.
    /// </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>
    /// The service has encountered an unexpected error condition which prevents it from
    /// servicing the request.
    /// </p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>
    /// There are too many AWS Mobile Hub projects in the account or the account has
    /// exceeded the maximum number of resources in some AWS service. You should create
    /// another sub-account using AWS Organizations or remove some resources and retry
    /// your request.
    /// </p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>
    /// No entity can be found with the specified identifier.
    /// </p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>
    /// The service is temporarily unavailable. The request should be retried after some
    /// time delay.
    /// </p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>
    /// Too many requests have been received for this AWS account in too short a time. The
    /// request should be retried after some time delay.
    /// </p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>
    /// Credentials of the caller are insufficient to authorize the request.
    /// </p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateProjectError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateProjectErrorKind::AccountActionRequiredException(_inner) => _inner.fmt(f),
            UpdateProjectErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateProjectErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            UpdateProjectErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateProjectErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateProjectErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            UpdateProjectErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateProjectErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            UpdateProjectErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateProjectError {
    fn code(&self) -> Option<&str> {
        UpdateProjectError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateProjectError {
    /// Creates a new `UpdateProjectError`.
    pub fn new(kind: UpdateProjectErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateProjectError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateProjectErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateProjectError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateProjectErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateProjectErrorKind::AccountActionRequiredException`.
    pub fn is_account_action_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateProjectErrorKind::AccountActionRequiredException(_)
        )
    }
    /// Returns true if the error kind is `UpdateProjectErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, UpdateProjectErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `UpdateProjectErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateProjectErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `UpdateProjectErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateProjectErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `UpdateProjectErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateProjectErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `UpdateProjectErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateProjectErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `UpdateProjectErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateProjectErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `UpdateProjectErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, UpdateProjectErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for UpdateProjectError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateProjectErrorKind::AccountActionRequiredException(_inner) => Some(_inner),
            UpdateProjectErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateProjectErrorKind::InternalFailureException(_inner) => Some(_inner),
            UpdateProjectErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateProjectErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateProjectErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            UpdateProjectErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateProjectErrorKind::UnauthorizedException(_inner) => Some(_inner),
            UpdateProjectErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>
/// Credentials of the caller are insufficient to authorize the request.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnauthorizedException {
    /// <p>
    /// The Exception Error Message.
    /// </p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnauthorizedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnauthorizedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnauthorizedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnauthorizedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnauthorizedException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnauthorizedException {}
/// See [`UnauthorizedException`](crate::error::UnauthorizedException)
pub mod unauthorized_exception {
    /// A builder for [`UnauthorizedException`](crate::error::UnauthorizedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The Exception Error Message.
        /// </p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>
        /// The Exception Error Message.
        /// </p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnauthorizedException`](crate::error::UnauthorizedException)
        pub fn build(self) -> crate::error::UnauthorizedException {
            crate::error::UnauthorizedException {
                message: self.message,
            }
        }
    }
}
impl UnauthorizedException {
    /// Creates a new builder-style object to manufacture [`UnauthorizedException`](crate::error::UnauthorizedException)
    pub fn builder() -> crate::error::unauthorized_exception::Builder {
        crate::error::unauthorized_exception::Builder::default()
    }
}

/// <p>
/// Too many requests have been received for this AWS account in too short a time. The
/// request should be retried after some time delay.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyRequestsException {
    /// <p>
    /// The Exception Error Message.
    /// </p>
    pub retry_after_seconds: std::option::Option<std::string::String>,
    /// <p>
    /// The Exception Error Message.
    /// </p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyRequestsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyRequestsException");
        formatter.field("retry_after_seconds", &self.retry_after_seconds);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyRequestsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyRequestsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyRequestsException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyRequestsException {}
/// See [`TooManyRequestsException`](crate::error::TooManyRequestsException)
pub mod too_many_requests_exception {
    /// A builder for [`TooManyRequestsException`](crate::error::TooManyRequestsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) retry_after_seconds: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The Exception Error Message.
        /// </p>
        pub fn retry_after_seconds(mut self, input: impl Into<std::string::String>) -> Self {
            self.retry_after_seconds = Some(input.into());
            self
        }
        /// <p>
        /// The Exception Error Message.
        /// </p>
        pub fn set_retry_after_seconds(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.retry_after_seconds = input;
            self
        }
        /// <p>
        /// The Exception Error Message.
        /// </p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>
        /// The Exception Error Message.
        /// </p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyRequestsException`](crate::error::TooManyRequestsException)
        pub fn build(self) -> crate::error::TooManyRequestsException {
            crate::error::TooManyRequestsException {
                retry_after_seconds: self.retry_after_seconds,
                message: self.message,
            }
        }
    }
}
impl TooManyRequestsException {
    /// Creates a new builder-style object to manufacture [`TooManyRequestsException`](crate::error::TooManyRequestsException)
    pub fn builder() -> crate::error::too_many_requests_exception::Builder {
        crate::error::too_many_requests_exception::Builder::default()
    }
}

/// <p>
/// The service is temporarily unavailable. The request should be retried after some
/// time delay.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceUnavailableException {
    /// <p>
    /// The Exception Error Message.
    /// </p>
    pub retry_after_seconds: std::option::Option<std::string::String>,
    /// <p>
    /// The Exception Error Message.
    /// </p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceUnavailableException");
        formatter.field("retry_after_seconds", &self.retry_after_seconds);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceUnavailableException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceUnavailableException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceUnavailableException {}
/// See [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
pub mod service_unavailable_exception {
    /// A builder for [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) retry_after_seconds: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The Exception Error Message.
        /// </p>
        pub fn retry_after_seconds(mut self, input: impl Into<std::string::String>) -> Self {
            self.retry_after_seconds = Some(input.into());
            self
        }
        /// <p>
        /// The Exception Error Message.
        /// </p>
        pub fn set_retry_after_seconds(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.retry_after_seconds = input;
            self
        }
        /// <p>
        /// The Exception Error Message.
        /// </p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>
        /// The Exception Error Message.
        /// </p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
        pub fn build(self) -> crate::error::ServiceUnavailableException {
            crate::error::ServiceUnavailableException {
                retry_after_seconds: self.retry_after_seconds,
                message: self.message,
            }
        }
    }
}
impl ServiceUnavailableException {
    /// Creates a new builder-style object to manufacture [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
    pub fn builder() -> crate::error::service_unavailable_exception::Builder {
        crate::error::service_unavailable_exception::Builder::default()
    }
}

/// <p>
/// No entity can be found with the specified identifier.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotFoundException {
    /// <p>
    /// The Exception Error Message.
    /// </p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NotFoundException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for NotFoundException {}
/// See [`NotFoundException`](crate::error::NotFoundException)
pub mod not_found_exception {
    /// A builder for [`NotFoundException`](crate::error::NotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The Exception Error Message.
        /// </p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>
        /// The Exception Error Message.
        /// </p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NotFoundException`](crate::error::NotFoundException)
        pub fn build(self) -> crate::error::NotFoundException {
            crate::error::NotFoundException {
                message: self.message,
            }
        }
    }
}
impl NotFoundException {
    /// Creates a new builder-style object to manufacture [`NotFoundException`](crate::error::NotFoundException)
    pub fn builder() -> crate::error::not_found_exception::Builder {
        crate::error::not_found_exception::Builder::default()
    }
}

/// <p>
/// There are too many AWS Mobile Hub projects in the account or the account has
/// exceeded the maximum number of resources in some AWS service. You should create
/// another sub-account using AWS Organizations or remove some resources and retry
/// your request.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededException {
    /// <p>
    /// The Exception Error Message.
    /// </p>
    pub retry_after_seconds: std::option::Option<std::string::String>,
    /// <p>
    /// The Exception Error Message.
    /// </p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededException");
        formatter.field("retry_after_seconds", &self.retry_after_seconds);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededException {}
/// See [`LimitExceededException`](crate::error::LimitExceededException)
pub mod limit_exceeded_exception {
    /// A builder for [`LimitExceededException`](crate::error::LimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) retry_after_seconds: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The Exception Error Message.
        /// </p>
        pub fn retry_after_seconds(mut self, input: impl Into<std::string::String>) -> Self {
            self.retry_after_seconds = Some(input.into());
            self
        }
        /// <p>
        /// The Exception Error Message.
        /// </p>
        pub fn set_retry_after_seconds(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.retry_after_seconds = input;
            self
        }
        /// <p>
        /// The Exception Error Message.
        /// </p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>
        /// The Exception Error Message.
        /// </p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededException`](crate::error::LimitExceededException)
        pub fn build(self) -> crate::error::LimitExceededException {
            crate::error::LimitExceededException {
                retry_after_seconds: self.retry_after_seconds,
                message: self.message,
            }
        }
    }
}
impl LimitExceededException {
    /// Creates a new builder-style object to manufacture [`LimitExceededException`](crate::error::LimitExceededException)
    pub fn builder() -> crate::error::limit_exceeded_exception::Builder {
        crate::error::limit_exceeded_exception::Builder::default()
    }
}

/// <p>
/// The service has encountered an unexpected error condition which prevents it from
/// servicing the request.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalFailureException {
    /// <p>
    /// The Exception Error Message.
    /// </p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalFailureException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalFailureException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalFailureException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalFailureException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalFailureException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalFailureException {}
/// See [`InternalFailureException`](crate::error::InternalFailureException)
pub mod internal_failure_exception {
    /// A builder for [`InternalFailureException`](crate::error::InternalFailureException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The Exception Error Message.
        /// </p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>
        /// The Exception Error Message.
        /// </p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalFailureException`](crate::error::InternalFailureException)
        pub fn build(self) -> crate::error::InternalFailureException {
            crate::error::InternalFailureException {
                message: self.message,
            }
        }
    }
}
impl InternalFailureException {
    /// Creates a new builder-style object to manufacture [`InternalFailureException`](crate::error::InternalFailureException)
    pub fn builder() -> crate::error::internal_failure_exception::Builder {
        crate::error::internal_failure_exception::Builder::default()
    }
}

/// <p>
/// The request cannot be processed because some parameter is not valid or the project
/// state prevents the operation from being performed.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BadRequestException {
    /// <p>
    /// The Exception Error Message.
    /// </p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BadRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BadRequestException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl BadRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for BadRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "BadRequestException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for BadRequestException {}
/// See [`BadRequestException`](crate::error::BadRequestException)
pub mod bad_request_exception {
    /// A builder for [`BadRequestException`](crate::error::BadRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The Exception Error Message.
        /// </p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>
        /// The Exception Error Message.
        /// </p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`BadRequestException`](crate::error::BadRequestException)
        pub fn build(self) -> crate::error::BadRequestException {
            crate::error::BadRequestException {
                message: self.message,
            }
        }
    }
}
impl BadRequestException {
    /// Creates a new builder-style object to manufacture [`BadRequestException`](crate::error::BadRequestException)
    pub fn builder() -> crate::error::bad_request_exception::Builder {
        crate::error::bad_request_exception::Builder::default()
    }
}

/// <p>
/// Account Action is required in order to continue the request.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccountActionRequiredException {
    /// <p>
    /// The Exception Error Message.
    /// </p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccountActionRequiredException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccountActionRequiredException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccountActionRequiredException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccountActionRequiredException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccountActionRequiredException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccountActionRequiredException {}
/// See [`AccountActionRequiredException`](crate::error::AccountActionRequiredException)
pub mod account_action_required_exception {
    /// A builder for [`AccountActionRequiredException`](crate::error::AccountActionRequiredException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The Exception Error Message.
        /// </p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>
        /// The Exception Error Message.
        /// </p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccountActionRequiredException`](crate::error::AccountActionRequiredException)
        pub fn build(self) -> crate::error::AccountActionRequiredException {
            crate::error::AccountActionRequiredException {
                message: self.message,
            }
        }
    }
}
impl AccountActionRequiredException {
    /// Creates a new builder-style object to manufacture [`AccountActionRequiredException`](crate::error::AccountActionRequiredException)
    pub fn builder() -> crate::error::account_action_required_exception::Builder {
        crate::error::account_action_required_exception::Builder::default()
    }
}
