// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `AWSMobileService`.
///
/// This client allows ergonomic access to a `AWSMobileService`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `CreateProject` operation.
    ///
    /// See [`CreateProject`](crate::client::fluent_builders::CreateProject) for more information about the
    /// operation and its arguments.
    pub fn create_project(&self) -> fluent_builders::CreateProject<C, M, R> {
        fluent_builders::CreateProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteProject` operation.
    ///
    /// See [`DeleteProject`](crate::client::fluent_builders::DeleteProject) for more information about the
    /// operation and its arguments.
    pub fn delete_project(&self) -> fluent_builders::DeleteProject<C, M, R> {
        fluent_builders::DeleteProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeBundle` operation.
    ///
    /// See [`DescribeBundle`](crate::client::fluent_builders::DescribeBundle) for more information about the
    /// operation and its arguments.
    pub fn describe_bundle(&self) -> fluent_builders::DescribeBundle<C, M, R> {
        fluent_builders::DescribeBundle::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeProject` operation.
    ///
    /// See [`DescribeProject`](crate::client::fluent_builders::DescribeProject) for more information about the
    /// operation and its arguments.
    pub fn describe_project(&self) -> fluent_builders::DescribeProject<C, M, R> {
        fluent_builders::DescribeProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ExportBundle` operation.
    ///
    /// See [`ExportBundle`](crate::client::fluent_builders::ExportBundle) for more information about the
    /// operation and its arguments.
    pub fn export_bundle(&self) -> fluent_builders::ExportBundle<C, M, R> {
        fluent_builders::ExportBundle::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ExportProject` operation.
    ///
    /// See [`ExportProject`](crate::client::fluent_builders::ExportProject) for more information about the
    /// operation and its arguments.
    pub fn export_project(&self) -> fluent_builders::ExportProject<C, M, R> {
        fluent_builders::ExportProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListBundles` operation.
    ///
    /// See [`ListBundles`](crate::client::fluent_builders::ListBundles) for more information about the
    /// operation and its arguments.
    pub fn list_bundles(&self) -> fluent_builders::ListBundles<C, M, R> {
        fluent_builders::ListBundles::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListProjects` operation.
    ///
    /// See [`ListProjects`](crate::client::fluent_builders::ListProjects) for more information about the
    /// operation and its arguments.
    pub fn list_projects(&self) -> fluent_builders::ListProjects<C, M, R> {
        fluent_builders::ListProjects::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateProject` operation.
    ///
    /// See [`UpdateProject`](crate::client::fluent_builders::UpdateProject) for more information about the
    /// operation and its arguments.
    pub fn update_project(&self) -> fluent_builders::UpdateProject<C, M, R> {
        fluent_builders::UpdateProject::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateProject`.
    ///
    /// <p>
    /// Creates an AWS Mobile Hub project.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateProject<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_project_input::Builder,
    }
    impl<C, M, R> CreateProject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateProjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateProjectInputOperationOutputAlias,
                crate::output::CreateProjectOutput,
                crate::error::CreateProjectError,
                crate::input::CreateProjectInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// Name of the project.
        /// </p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>
        /// Name of the project.
        /// </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>
        /// Default region where project resources should be created.
        /// </p>
        pub fn region(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.region(inp);
            self
        }
        /// <p>
        /// Default region where project resources should be created.
        /// </p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_region(input);
            self
        }
        /// <p>
        /// ZIP or YAML file which contains configuration settings to be used when creating
        /// the project. This may be the contents of the file downloaded from the URL provided
        /// in an export project operation.
        /// </p>
        pub fn contents(mut self, inp: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.contents(inp);
            self
        }
        /// <p>
        /// ZIP or YAML file which contains configuration settings to be used when creating
        /// the project. This may be the contents of the file downloaded from the URL provided
        /// in an export project operation.
        /// </p>
        pub fn set_contents(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.inner = self.inner.set_contents(input);
            self
        }
        /// <p>
        /// Unique identifier for an exported snapshot of project configuration. This
        /// snapshot identifier is included in the share URL when a project is exported.
        /// </p>
        pub fn snapshot_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_id(inp);
            self
        }
        /// <p>
        /// Unique identifier for an exported snapshot of project configuration. This
        /// snapshot identifier is included in the share URL when a project is exported.
        /// </p>
        pub fn set_snapshot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_snapshot_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteProject`.
    ///
    /// <p>
    /// Delets a project in AWS Mobile Hub.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteProject<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_project_input::Builder,
    }
    impl<C, M, R> DeleteProject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteProjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteProjectInputOperationOutputAlias,
                crate::output::DeleteProjectOutput,
                crate::error::DeleteProjectError,
                crate::input::DeleteProjectInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// Unique project identifier.
        /// </p>
        pub fn project_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_id(inp);
            self
        }
        /// <p>
        /// Unique project identifier.
        /// </p>
        pub fn set_project_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeBundle`.
    ///
    /// <p>
    /// Get the bundle details for the requested bundle id.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeBundle<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_bundle_input::Builder,
    }
    impl<C, M, R> DescribeBundle<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeBundle`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeBundleOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeBundleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeBundleInputOperationOutputAlias,
                crate::output::DescribeBundleOutput,
                crate::error::DescribeBundleError,
                crate::input::DescribeBundleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// Unique bundle identifier.
        /// </p>
        pub fn bundle_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bundle_id(inp);
            self
        }
        /// <p>
        /// Unique bundle identifier.
        /// </p>
        pub fn set_bundle_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bundle_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeProject`.
    ///
    /// <p>
    /// Gets details about a project in AWS Mobile Hub.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeProject<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_project_input::Builder,
    }
    impl<C, M, R> DescribeProject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeProjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeProjectInputOperationOutputAlias,
                crate::output::DescribeProjectOutput,
                crate::error::DescribeProjectError,
                crate::input::DescribeProjectInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// Unique project identifier.
        /// </p>
        pub fn project_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_id(inp);
            self
        }
        /// <p>
        /// Unique project identifier.
        /// </p>
        pub fn set_project_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_id(input);
            self
        }
        /// <p>
        /// If set to true, causes AWS Mobile Hub to synchronize information from other services, e.g., update state of AWS CloudFormation stacks in the AWS Mobile Hub project.
        /// </p>
        pub fn sync_from_resources(mut self, inp: bool) -> Self {
            self.inner = self.inner.sync_from_resources(inp);
            self
        }
        /// <p>
        /// If set to true, causes AWS Mobile Hub to synchronize information from other services, e.g., update state of AWS CloudFormation stacks in the AWS Mobile Hub project.
        /// </p>
        pub fn set_sync_from_resources(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_sync_from_resources(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ExportBundle`.
    ///
    /// <p>
    /// Generates customized software development kit (SDK) and or tool packages
    /// used to integrate mobile web or mobile app clients with backend AWS resources.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct ExportBundle<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::export_bundle_input::Builder,
    }
    impl<C, M, R> ExportBundle<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ExportBundle`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ExportBundleOutput,
            aws_smithy_http::result::SdkError<crate::error::ExportBundleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ExportBundleInputOperationOutputAlias,
                crate::output::ExportBundleOutput,
                crate::error::ExportBundleError,
                crate::input::ExportBundleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// Unique bundle identifier.
        /// </p>
        pub fn bundle_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bundle_id(inp);
            self
        }
        /// <p>
        /// Unique bundle identifier.
        /// </p>
        pub fn set_bundle_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bundle_id(input);
            self
        }
        /// <p>
        /// Unique project identifier.
        /// </p>
        pub fn project_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_id(inp);
            self
        }
        /// <p>
        /// Unique project identifier.
        /// </p>
        pub fn set_project_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_id(input);
            self
        }
        /// <p>
        /// Developer desktop or target application platform.
        /// </p>
        pub fn platform(mut self, inp: crate::model::Platform) -> Self {
            self.inner = self.inner.platform(inp);
            self
        }
        /// <p>
        /// Developer desktop or target application platform.
        /// </p>
        pub fn set_platform(mut self, input: std::option::Option<crate::model::Platform>) -> Self {
            self.inner = self.inner.set_platform(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ExportProject`.
    ///
    /// <p>
    /// Exports project configuration to a snapshot which can be downloaded and shared.
    /// Note that mobile app push credentials are encrypted in exported projects, so they
    /// can only be shared successfully within the same AWS account.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct ExportProject<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::export_project_input::Builder,
    }
    impl<C, M, R> ExportProject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ExportProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ExportProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::ExportProjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ExportProjectInputOperationOutputAlias,
                crate::output::ExportProjectOutput,
                crate::error::ExportProjectError,
                crate::input::ExportProjectInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// Unique project identifier.
        /// </p>
        pub fn project_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_id(inp);
            self
        }
        /// <p>
        /// Unique project identifier.
        /// </p>
        pub fn set_project_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListBundles`.
    ///
    /// <p>
    /// List all available bundles.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct ListBundles<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_bundles_input::Builder,
    }
    impl<C, M, R> ListBundles<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListBundles`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBundlesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListBundlesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListBundlesInputOperationOutputAlias,
                crate::output::ListBundlesOutput,
                crate::error::ListBundlesError,
                crate::input::ListBundlesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// Maximum number of records to list in a single response.
        /// </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>
        /// Maximum number of records to list in a single response.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>
        /// Pagination token. Set to null to start listing bundles from start.
        /// If non-null pagination token is returned in a result, then pass its
        /// value in here in another request to list more bundles.
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>
        /// Pagination token. Set to null to start listing bundles from start.
        /// If non-null pagination token is returned in a result, then pass its
        /// value in here in another request to list more bundles.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListProjects`.
    ///
    /// <p>
    /// Lists projects in AWS Mobile Hub.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct ListProjects<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_projects_input::Builder,
    }
    impl<C, M, R> ListProjects<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListProjects`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListProjectsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListProjectsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListProjectsInputOperationOutputAlias,
                crate::output::ListProjectsOutput,
                crate::error::ListProjectsError,
                crate::input::ListProjectsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// Maximum number of records to list in a single response.
        /// </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>
        /// Maximum number of records to list in a single response.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>
        /// Pagination token. Set to null to start listing projects from start.
        /// If non-null pagination token is returned in a result, then pass its
        /// value in here in another request to list more projects.
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>
        /// Pagination token. Set to null to start listing projects from start.
        /// If non-null pagination token is returned in a result, then pass its
        /// value in here in another request to list more projects.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateProject`.
    ///
    /// <p>
    /// Update an existing project.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateProject<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_project_input::Builder,
    }
    impl<C, M, R> UpdateProject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateProjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateProjectInputOperationOutputAlias,
                crate::output::UpdateProjectOutput,
                crate::error::UpdateProjectError,
                crate::input::UpdateProjectInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// ZIP or YAML file which contains project configuration to be updated. This should
        /// be the contents of the file downloaded from the URL provided in an export project
        /// operation.
        /// </p>
        pub fn contents(mut self, inp: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.contents(inp);
            self
        }
        /// <p>
        /// ZIP or YAML file which contains project configuration to be updated. This should
        /// be the contents of the file downloaded from the URL provided in an export project
        /// operation.
        /// </p>
        pub fn set_contents(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.inner = self.inner.set_contents(input);
            self
        }
        /// <p>
        /// Unique project identifier.
        /// </p>
        pub fn project_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_id(inp);
            self
        }
        /// <p>
        /// Unique project identifier.
        /// </p>
        pub fn set_project_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_id(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
