// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Migration Hub Strategy Recommendations
///
/// Client for invoking operations on Migration Hub Strategy Recommendations. Each operation on Migration Hub Strategy Recommendations is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_migrationhubstrategy::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_migrationhubstrategy::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_migrationhubstrategy::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`GetApplicationComponentDetails`](crate::client::fluent_builders::GetApplicationComponentDetails) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_component_id(impl Into<String>)`](crate::client::fluent_builders::GetApplicationComponentDetails::application_component_id) / [`set_application_component_id(Option<String>)`](crate::client::fluent_builders::GetApplicationComponentDetails::set_application_component_id): <p> The ID of the application component. The ID is unique within an AWS account.</p>
    /// - On success, responds with [`GetApplicationComponentDetailsOutput`](crate::output::GetApplicationComponentDetailsOutput) with field(s):
    ///   - [`application_component_detail(Option<ApplicationComponentDetail>)`](crate::output::GetApplicationComponentDetailsOutput::application_component_detail): <p> Detailed information about an application component. </p>
    ///   - [`associated_applications(Option<Vec<AssociatedApplication>>)`](crate::output::GetApplicationComponentDetailsOutput::associated_applications): <p> The associated application group as defined in AWS Application Discovery Service. </p>
    ///   - [`more_application_resource(Option<bool>)`](crate::output::GetApplicationComponentDetailsOutput::more_application_resource): <p> Set to true if the application component belongs to more than one application group. </p>
    ///   - [`associated_server_ids(Option<Vec<String>>)`](crate::output::GetApplicationComponentDetailsOutput::associated_server_ids): <p> A list of the IDs of the servers on which the application component is running. </p>
    /// - On failure, responds with [`SdkError<GetApplicationComponentDetailsError>`](crate::error::GetApplicationComponentDetailsError)
    pub fn get_application_component_details(
        &self,
    ) -> fluent_builders::GetApplicationComponentDetails {
        fluent_builders::GetApplicationComponentDetails::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetApplicationComponentStrategies`](crate::client::fluent_builders::GetApplicationComponentStrategies) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_component_id(impl Into<String>)`](crate::client::fluent_builders::GetApplicationComponentStrategies::application_component_id) / [`set_application_component_id(Option<String>)`](crate::client::fluent_builders::GetApplicationComponentStrategies::set_application_component_id): <p> The ID of the application component. The ID is unique within an AWS account.</p>
    /// - On success, responds with [`GetApplicationComponentStrategiesOutput`](crate::output::GetApplicationComponentStrategiesOutput) with field(s):
    ///   - [`application_component_strategies(Option<Vec<ApplicationComponentStrategy>>)`](crate::output::GetApplicationComponentStrategiesOutput::application_component_strategies): <p> A list of application component strategy recommendations. </p>
    /// - On failure, responds with [`SdkError<GetApplicationComponentStrategiesError>`](crate::error::GetApplicationComponentStrategiesError)
    pub fn get_application_component_strategies(
        &self,
    ) -> fluent_builders::GetApplicationComponentStrategies {
        fluent_builders::GetApplicationComponentStrategies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAssessment`](crate::client::fluent_builders::GetAssessment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetAssessment::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetAssessment::set_id): <p> The <code>assessmentid</code> returned by <code>StartAssessment</code>.</p>
    /// - On success, responds with [`GetAssessmentOutput`](crate::output::GetAssessmentOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::GetAssessmentOutput::id): <p> The ID for the specific assessment task. </p>
    ///   - [`data_collection_details(Option<DataCollectionDetails>)`](crate::output::GetAssessmentOutput::data_collection_details): <p> Detailed information about the assessment. </p>
    /// - On failure, responds with [`SdkError<GetAssessmentError>`](crate::error::GetAssessmentError)
    pub fn get_assessment(&self) -> fluent_builders::GetAssessment {
        fluent_builders::GetAssessment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetImportFileTask`](crate::client::fluent_builders::GetImportFileTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetImportFileTask::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetImportFileTask::set_id): <p> The ID of the import file task. This ID is returned in the response of <code>StartImportFileTask</code>. </p>
    /// - On success, responds with [`GetImportFileTaskOutput`](crate::output::GetImportFileTaskOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::GetImportFileTaskOutput::id): <p> The import file task <code>id</code> returned in the response of <code>StartImportFileTask</code>. </p>
    ///   - [`status(Option<ImportFileTaskStatus>)`](crate::output::GetImportFileTaskOutput::status): <p> Status of import file task. </p>
    ///   - [`start_time(Option<DateTime>)`](crate::output::GetImportFileTaskOutput::start_time): <p> Start time of the import task. </p>
    ///   - [`input_s3_bucket(Option<String>)`](crate::output::GetImportFileTaskOutput::input_s3_bucket): <p> The S3 bucket where import file is located. </p>
    ///   - [`input_s3_key(Option<String>)`](crate::output::GetImportFileTaskOutput::input_s3_key): <p> The Amazon S3 key name of the import file. </p>
    ///   - [`status_report_s3_bucket(Option<String>)`](crate::output::GetImportFileTaskOutput::status_report_s3_bucket): <p> The S3 bucket name for status report of import task. </p>
    ///   - [`status_report_s3_key(Option<String>)`](crate::output::GetImportFileTaskOutput::status_report_s3_key): <p> The Amazon S3 key name for status report of import task. The report contains details about whether each record imported successfully or why it did not.</p>
    ///   - [`completion_time(Option<DateTime>)`](crate::output::GetImportFileTaskOutput::completion_time): <p> The time that the import task completed. </p>
    ///   - [`number_of_records_success(Option<i32>)`](crate::output::GetImportFileTaskOutput::number_of_records_success): <p> The number of records successfully imported. </p>
    ///   - [`number_of_records_failed(Option<i32>)`](crate::output::GetImportFileTaskOutput::number_of_records_failed): <p> The number of records that failed to be imported. </p>
    ///   - [`import_name(Option<String>)`](crate::output::GetImportFileTaskOutput::import_name): <p> The name of the import task given in <code>StartImportFileTask</code>. </p>
    /// - On failure, responds with [`SdkError<GetImportFileTaskError>`](crate::error::GetImportFileTaskError)
    pub fn get_import_file_task(&self) -> fluent_builders::GetImportFileTask {
        fluent_builders::GetImportFileTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetPortfolioPreferences`](crate::client::fluent_builders::GetPortfolioPreferences) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::GetPortfolioPreferences::send) it.

    /// - On success, responds with [`GetPortfolioPreferencesOutput`](crate::output::GetPortfolioPreferencesOutput) with field(s):
    ///   - [`prioritize_business_goals(Option<PrioritizeBusinessGoals>)`](crate::output::GetPortfolioPreferencesOutput::prioritize_business_goals): <p> The rank of business goals based on priority. </p>
    ///   - [`application_preferences(Option<ApplicationPreferences>)`](crate::output::GetPortfolioPreferencesOutput::application_preferences): <p> The transformation preferences for non-database applications. </p>
    ///   - [`database_preferences(Option<DatabasePreferences>)`](crate::output::GetPortfolioPreferencesOutput::database_preferences): <p> The transformation preferences for database applications. </p>
    /// - On failure, responds with [`SdkError<GetPortfolioPreferencesError>`](crate::error::GetPortfolioPreferencesError)
    pub fn get_portfolio_preferences(&self) -> fluent_builders::GetPortfolioPreferences {
        fluent_builders::GetPortfolioPreferences::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetPortfolioSummary`](crate::client::fluent_builders::GetPortfolioSummary) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::GetPortfolioSummary::send) it.

    /// - On success, responds with [`GetPortfolioSummaryOutput`](crate::output::GetPortfolioSummaryOutput) with field(s):
    ///   - [`assessment_summary(Option<AssessmentSummary>)`](crate::output::GetPortfolioSummaryOutput::assessment_summary): <p> An assessment summary for the portfolio including the number of servers to rehost and the overall number of anti-patterns. </p>
    /// - On failure, responds with [`SdkError<GetPortfolioSummaryError>`](crate::error::GetPortfolioSummaryError)
    pub fn get_portfolio_summary(&self) -> fluent_builders::GetPortfolioSummary {
        fluent_builders::GetPortfolioSummary::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetRecommendationReportDetails`](crate::client::fluent_builders::GetRecommendationReportDetails) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetRecommendationReportDetails::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetRecommendationReportDetails::set_id): <p> The recommendation report generation task <code>id</code> returned by <code>StartRecommendationReportGeneration</code>. </p>
    /// - On success, responds with [`GetRecommendationReportDetailsOutput`](crate::output::GetRecommendationReportDetailsOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::GetRecommendationReportDetailsOutput::id): <p> The ID of the recommendation report generation task. See the response of <code>StartRecommendationReportGeneration</code>. </p>
    ///   - [`recommendation_report_details(Option<RecommendationReportDetails>)`](crate::output::GetRecommendationReportDetailsOutput::recommendation_report_details): <p> Detailed information about the recommendation report. </p>
    /// - On failure, responds with [`SdkError<GetRecommendationReportDetailsError>`](crate::error::GetRecommendationReportDetailsError)
    pub fn get_recommendation_report_details(
        &self,
    ) -> fluent_builders::GetRecommendationReportDetails {
        fluent_builders::GetRecommendationReportDetails::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetServerDetails`](crate::client::fluent_builders::GetServerDetails) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetServerDetails::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`server_id(impl Into<String>)`](crate::client::fluent_builders::GetServerDetails::server_id) / [`set_server_id(Option<String>)`](crate::client::fluent_builders::GetServerDetails::set_server_id): <p> The ID of the server. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetServerDetails::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetServerDetails::set_next_token): <p> The token from a previous call that you use to retrieve the next set of results. For example, if a previous call to this action returned 100 items, but you set <code>maxResults</code> to 10. You'll receive a set of 10 results along with a token. You then use the returned token to retrieve the next set of 10. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetServerDetails::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetServerDetails::set_max_results): <p> The maximum number of items to include in the response. The maximum value is 100. </p>
    /// - On success, responds with [`GetServerDetailsOutput`](crate::output::GetServerDetailsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::GetServerDetailsOutput::next_token): <p> The token you use to retrieve the next set of results, or null if there are no more results. </p>
    ///   - [`server_detail(Option<ServerDetail>)`](crate::output::GetServerDetailsOutput::server_detail): <p> Detailed information about the server. </p>
    ///   - [`associated_applications(Option<Vec<AssociatedApplication>>)`](crate::output::GetServerDetailsOutput::associated_applications): <p> The associated application group the server belongs to, as defined in AWS Application Discovery Service. </p>
    /// - On failure, responds with [`SdkError<GetServerDetailsError>`](crate::error::GetServerDetailsError)
    pub fn get_server_details(&self) -> fluent_builders::GetServerDetails {
        fluent_builders::GetServerDetails::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetServerStrategies`](crate::client::fluent_builders::GetServerStrategies) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`server_id(impl Into<String>)`](crate::client::fluent_builders::GetServerStrategies::server_id) / [`set_server_id(Option<String>)`](crate::client::fluent_builders::GetServerStrategies::set_server_id): <p> The ID of the server. </p>
    /// - On success, responds with [`GetServerStrategiesOutput`](crate::output::GetServerStrategiesOutput) with field(s):
    ///   - [`server_strategies(Option<Vec<ServerStrategy>>)`](crate::output::GetServerStrategiesOutput::server_strategies): <p> A list of strategy recommendations for the server. </p>
    /// - On failure, responds with [`SdkError<GetServerStrategiesError>`](crate::error::GetServerStrategiesError)
    pub fn get_server_strategies(&self) -> fluent_builders::GetServerStrategies {
        fluent_builders::GetServerStrategies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListApplicationComponents`](crate::client::fluent_builders::ListApplicationComponents) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListApplicationComponents::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_component_criteria(ApplicationComponentCriteria)`](crate::client::fluent_builders::ListApplicationComponents::application_component_criteria) / [`set_application_component_criteria(Option<ApplicationComponentCriteria>)`](crate::client::fluent_builders::ListApplicationComponents::set_application_component_criteria): <p> Criteria for filtering the list of application components. </p>
    ///   - [`filter_value(impl Into<String>)`](crate::client::fluent_builders::ListApplicationComponents::filter_value) / [`set_filter_value(Option<String>)`](crate::client::fluent_builders::ListApplicationComponents::set_filter_value): <p> Specify the value based on the application component criteria type. For example, if <code>applicationComponentCriteria</code> is set to <code>SERVER_ID</code> and <code>filterValue</code> is set to <code>server1</code>, then <code>ListApplicationComponents</code> returns all the application components running on server1. </p>
    ///   - [`sort(SortOrder)`](crate::client::fluent_builders::ListApplicationComponents::sort) / [`set_sort(Option<SortOrder>)`](crate::client::fluent_builders::ListApplicationComponents::set_sort): <p> Specifies whether to sort by ascending (<code>ASC</code>) or descending (<code>DESC</code>) order. </p>
    ///   - [`group_id_filter(Vec<Group>)`](crate::client::fluent_builders::ListApplicationComponents::group_id_filter) / [`set_group_id_filter(Option<Vec<Group>>)`](crate::client::fluent_builders::ListApplicationComponents::set_group_id_filter): <p> The group ID specified in to filter on. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListApplicationComponents::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListApplicationComponents::set_next_token): <p> The token from a previous call that you use to retrieve the next set of results. For example, if a previous call to this action returned 100 items, but you set <code>maxResults</code> to 10. You'll receive a set of 10 results along with a token. You then use the returned token to retrieve the next set of 10. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListApplicationComponents::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListApplicationComponents::set_max_results): <p> The maximum number of items to include in the response. The maximum value is 100. </p>
    /// - On success, responds with [`ListApplicationComponentsOutput`](crate::output::ListApplicationComponentsOutput) with field(s):
    ///   - [`application_component_infos(Option<Vec<ApplicationComponentDetail>>)`](crate::output::ListApplicationComponentsOutput::application_component_infos): <p> The list of application components with detailed information about each component. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListApplicationComponentsOutput::next_token): <p> The token you use to retrieve the next set of results, or null if there are no more results. </p>
    /// - On failure, responds with [`SdkError<ListApplicationComponentsError>`](crate::error::ListApplicationComponentsError)
    pub fn list_application_components(&self) -> fluent_builders::ListApplicationComponents {
        fluent_builders::ListApplicationComponents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListCollectors`](crate::client::fluent_builders::ListCollectors) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListCollectors::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListCollectors::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListCollectors::set_next_token): <p> The token from a previous call that you use to retrieve the next set of results. For example, if a previous call to this action returned 100 items, but you set <code>maxResults</code> to 10. You'll receive a set of 10 results along with a token. You then use the returned token to retrieve the next set of 10. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListCollectors::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListCollectors::set_max_results): <p> The maximum number of items to include in the response. The maximum value is 100. </p>
    /// - On success, responds with [`ListCollectorsOutput`](crate::output::ListCollectorsOutput) with field(s):
    ///   - [`collectors(Option<Vec<Collector>>)`](crate::output::ListCollectorsOutput::collectors): <p> The list of all the installed collectors. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListCollectorsOutput::next_token): <p> The token you use to retrieve the next set of results, or null if there are no more results. </p>
    /// - On failure, responds with [`SdkError<ListCollectorsError>`](crate::error::ListCollectorsError)
    pub fn list_collectors(&self) -> fluent_builders::ListCollectors {
        fluent_builders::ListCollectors::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListImportFileTask`](crate::client::fluent_builders::ListImportFileTask) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListImportFileTask::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListImportFileTask::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListImportFileTask::set_next_token): <p> The token from a previous call that you use to retrieve the next set of results. For example, if a previous call to this action returned 100 items, but you set <code>maxResults</code> to 10. You'll receive a set of 10 results along with a token. You then use the returned token to retrieve the next set of 10. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListImportFileTask::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListImportFileTask::set_max_results): <p> The total number of items to return. The maximum value is 100. </p>
    /// - On success, responds with [`ListImportFileTaskOutput`](crate::output::ListImportFileTaskOutput) with field(s):
    ///   - [`task_infos(Option<Vec<ImportFileTaskInformation>>)`](crate::output::ListImportFileTaskOutput::task_infos): <p> Lists information about the files you import.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListImportFileTaskOutput::next_token): <p> The token you use to retrieve the next set of results, or null if there are no more results. </p>
    /// - On failure, responds with [`SdkError<ListImportFileTaskError>`](crate::error::ListImportFileTaskError)
    pub fn list_import_file_task(&self) -> fluent_builders::ListImportFileTask {
        fluent_builders::ListImportFileTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListServers`](crate::client::fluent_builders::ListServers) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListServers::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`server_criteria(ServerCriteria)`](crate::client::fluent_builders::ListServers::server_criteria) / [`set_server_criteria(Option<ServerCriteria>)`](crate::client::fluent_builders::ListServers::set_server_criteria): <p> Criteria for filtering servers. </p>
    ///   - [`filter_value(impl Into<String>)`](crate::client::fluent_builders::ListServers::filter_value) / [`set_filter_value(Option<String>)`](crate::client::fluent_builders::ListServers::set_filter_value): <p> Specifies the filter value, which is based on the type of server criteria. For example, if <code>serverCriteria</code> is <code>OS_NAME</code>, and the <code>filterValue</code> is equal to <code>WindowsServer</code>, then <code>ListServers</code> returns all of the servers matching the OS name <code>WindowsServer</code>. </p>
    ///   - [`sort(SortOrder)`](crate::client::fluent_builders::ListServers::sort) / [`set_sort(Option<SortOrder>)`](crate::client::fluent_builders::ListServers::set_sort): <p> Specifies whether to sort by ascending (<code>ASC</code>) or descending (<code>DESC</code>) order. </p>
    ///   - [`group_id_filter(Vec<Group>)`](crate::client::fluent_builders::ListServers::group_id_filter) / [`set_group_id_filter(Option<Vec<Group>>)`](crate::client::fluent_builders::ListServers::set_group_id_filter): <p> Specifies the group ID to filter on. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListServers::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListServers::set_next_token): <p> The token from a previous call that you use to retrieve the next set of results. For example, if a previous call to this action returned 100 items, but you set <code>maxResults</code> to 10. You'll receive a set of 10 results along with a token. You then use the returned token to retrieve the next set of 10. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListServers::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListServers::set_max_results): <p> The maximum number of items to include in the response. The maximum value is 100. </p>
    /// - On success, responds with [`ListServersOutput`](crate::output::ListServersOutput) with field(s):
    ///   - [`server_infos(Option<Vec<ServerDetail>>)`](crate::output::ListServersOutput::server_infos): <p> The list of servers with detailed information about each server. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListServersOutput::next_token): <p> The token you use to retrieve the next set of results, or null if there are no more results. </p>
    /// - On failure, responds with [`SdkError<ListServersError>`](crate::error::ListServersError)
    pub fn list_servers(&self) -> fluent_builders::ListServers {
        fluent_builders::ListServers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutPortfolioPreferences`](crate::client::fluent_builders::PutPortfolioPreferences) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`prioritize_business_goals(PrioritizeBusinessGoals)`](crate::client::fluent_builders::PutPortfolioPreferences::prioritize_business_goals) / [`set_prioritize_business_goals(Option<PrioritizeBusinessGoals>)`](crate::client::fluent_builders::PutPortfolioPreferences::set_prioritize_business_goals): <p> The rank of the business goals based on priority. </p>
    ///   - [`application_preferences(ApplicationPreferences)`](crate::client::fluent_builders::PutPortfolioPreferences::application_preferences) / [`set_application_preferences(Option<ApplicationPreferences>)`](crate::client::fluent_builders::PutPortfolioPreferences::set_application_preferences): <p> The transformation preferences for non-database applications. </p>
    ///   - [`database_preferences(DatabasePreferences)`](crate::client::fluent_builders::PutPortfolioPreferences::database_preferences) / [`set_database_preferences(Option<DatabasePreferences>)`](crate::client::fluent_builders::PutPortfolioPreferences::set_database_preferences): <p> The transformation preferences for database applications. </p>
    /// - On success, responds with [`PutPortfolioPreferencesOutput`](crate::output::PutPortfolioPreferencesOutput)

    /// - On failure, responds with [`SdkError<PutPortfolioPreferencesError>`](crate::error::PutPortfolioPreferencesError)
    pub fn put_portfolio_preferences(&self) -> fluent_builders::PutPortfolioPreferences {
        fluent_builders::PutPortfolioPreferences::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartAssessment`](crate::client::fluent_builders::StartAssessment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`s3bucket_for_analysis_data(impl Into<String>)`](crate::client::fluent_builders::StartAssessment::s3bucket_for_analysis_data) / [`set_s3bucket_for_analysis_data(Option<String>)`](crate::client::fluent_builders::StartAssessment::set_s3bucket_for_analysis_data): <p> The S3 bucket used by the collectors to send analysis data to the service. The bucket name must begin with <code>migrationhub-strategy-</code>. </p>
    ///   - [`s3bucket_for_report_data(impl Into<String>)`](crate::client::fluent_builders::StartAssessment::s3bucket_for_report_data) / [`set_s3bucket_for_report_data(Option<String>)`](crate::client::fluent_builders::StartAssessment::set_s3bucket_for_report_data): <p> The S3 bucket where all the reports generated by the service are stored. The bucket name must begin with <code>migrationhub-strategy-</code>. </p>
    /// - On success, responds with [`StartAssessmentOutput`](crate::output::StartAssessmentOutput) with field(s):
    ///   - [`assessment_id(Option<String>)`](crate::output::StartAssessmentOutput::assessment_id): <p> The ID of the assessment. </p>
    /// - On failure, responds with [`SdkError<StartAssessmentError>`](crate::error::StartAssessmentError)
    pub fn start_assessment(&self) -> fluent_builders::StartAssessment {
        fluent_builders::StartAssessment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartImportFileTask`](crate::client::fluent_builders::StartImportFileTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::StartImportFileTask::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::StartImportFileTask::set_name): <p> A descriptive name for the request. </p>
    ///   - [`s3_bucket(impl Into<String>)`](crate::client::fluent_builders::StartImportFileTask::s3_bucket) / [`set_s3_bucket(Option<String>)`](crate::client::fluent_builders::StartImportFileTask::set_s3_bucket): <p> The S3 bucket where the import file is located. The bucket name is required to begin with <code>migrationhub-strategy-</code>.</p>
    ///   - [`s3key(impl Into<String>)`](crate::client::fluent_builders::StartImportFileTask::s3key) / [`set_s3key(Option<String>)`](crate::client::fluent_builders::StartImportFileTask::set_s3key): <p> The Amazon S3 key name of the import file. </p>
    ///   - [`data_source_type(DataSourceType)`](crate::client::fluent_builders::StartImportFileTask::data_source_type) / [`set_data_source_type(Option<DataSourceType>)`](crate::client::fluent_builders::StartImportFileTask::set_data_source_type): <p>Specifies the source that the servers are coming from. By default, Strategy Recommendations assumes that the servers specified in the import file are available in AWS Application Discovery Service. </p>
    ///   - [`group_id(Vec<Group>)`](crate::client::fluent_builders::StartImportFileTask::group_id) / [`set_group_id(Option<Vec<Group>>)`](crate::client::fluent_builders::StartImportFileTask::set_group_id): <p>Groups the resources in the import file together with a unique name. This ID can be as filter in <code>ListApplicationComponents</code> and <code>ListServers</code>. </p>
    ///   - [`s3bucket_for_report_data(impl Into<String>)`](crate::client::fluent_builders::StartImportFileTask::s3bucket_for_report_data) / [`set_s3bucket_for_report_data(Option<String>)`](crate::client::fluent_builders::StartImportFileTask::set_s3bucket_for_report_data): <p> The S3 bucket where Strategy Recommendations uploads import results. The bucket name is required to begin with migrationhub-strategy-. </p>
    /// - On success, responds with [`StartImportFileTaskOutput`](crate::output::StartImportFileTaskOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::StartImportFileTaskOutput::id): <p> The ID for a specific import task. The ID is unique within an AWS account. </p>
    /// - On failure, responds with [`SdkError<StartImportFileTaskError>`](crate::error::StartImportFileTaskError)
    pub fn start_import_file_task(&self) -> fluent_builders::StartImportFileTask {
        fluent_builders::StartImportFileTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartRecommendationReportGeneration`](crate::client::fluent_builders::StartRecommendationReportGeneration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`output_format(OutputFormat)`](crate::client::fluent_builders::StartRecommendationReportGeneration::output_format) / [`set_output_format(Option<OutputFormat>)`](crate::client::fluent_builders::StartRecommendationReportGeneration::set_output_format): <p> The output format for the recommendation report file. The default format is Microsoft Excel. </p>
    ///   - [`group_id_filter(Vec<Group>)`](crate::client::fluent_builders::StartRecommendationReportGeneration::group_id_filter) / [`set_group_id_filter(Option<Vec<Group>>)`](crate::client::fluent_builders::StartRecommendationReportGeneration::set_group_id_filter): <p> Groups the resources in the recommendation report with a unique name. </p>
    /// - On success, responds with [`StartRecommendationReportGenerationOutput`](crate::output::StartRecommendationReportGenerationOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::StartRecommendationReportGenerationOutput::id): <p> The ID of the recommendation report generation task. </p>
    /// - On failure, responds with [`SdkError<StartRecommendationReportGenerationError>`](crate::error::StartRecommendationReportGenerationError)
    pub fn start_recommendation_report_generation(
        &self,
    ) -> fluent_builders::StartRecommendationReportGeneration {
        fluent_builders::StartRecommendationReportGeneration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StopAssessment`](crate::client::fluent_builders::StopAssessment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`assessment_id(impl Into<String>)`](crate::client::fluent_builders::StopAssessment::assessment_id) / [`set_assessment_id(Option<String>)`](crate::client::fluent_builders::StopAssessment::set_assessment_id): <p> The <code>assessmentId</code> returned by <code>StartAssessment</code>. </p>
    /// - On success, responds with [`StopAssessmentOutput`](crate::output::StopAssessmentOutput)

    /// - On failure, responds with [`SdkError<StopAssessmentError>`](crate::error::StopAssessmentError)
    pub fn stop_assessment(&self) -> fluent_builders::StopAssessment {
        fluent_builders::StopAssessment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateApplicationComponentConfig`](crate::client::fluent_builders::UpdateApplicationComponentConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_component_id(impl Into<String>)`](crate::client::fluent_builders::UpdateApplicationComponentConfig::application_component_id) / [`set_application_component_id(Option<String>)`](crate::client::fluent_builders::UpdateApplicationComponentConfig::set_application_component_id): <p> The ID of the application component. The ID is unique within an AWS account. </p>
    ///   - [`inclusion_status(InclusionStatus)`](crate::client::fluent_builders::UpdateApplicationComponentConfig::inclusion_status) / [`set_inclusion_status(Option<InclusionStatus>)`](crate::client::fluent_builders::UpdateApplicationComponentConfig::set_inclusion_status): <p> Indicates whether the application component has been included for server recommendation or not. </p>
    ///   - [`strategy_option(StrategyOption)`](crate::client::fluent_builders::UpdateApplicationComponentConfig::strategy_option) / [`set_strategy_option(Option<StrategyOption>)`](crate::client::fluent_builders::UpdateApplicationComponentConfig::set_strategy_option): <p> The preferred strategy options for the application component. Use values from the <code>GetApplicationComponentStrategies</code> response. </p>
    ///   - [`source_code_list(Vec<SourceCode>)`](crate::client::fluent_builders::UpdateApplicationComponentConfig::source_code_list) / [`set_source_code_list(Option<Vec<SourceCode>>)`](crate::client::fluent_builders::UpdateApplicationComponentConfig::set_source_code_list): <p> The list of source code configurations to update for the application component. </p>
    ///   - [`secrets_manager_key(impl Into<String>)`](crate::client::fluent_builders::UpdateApplicationComponentConfig::secrets_manager_key) / [`set_secrets_manager_key(Option<String>)`](crate::client::fluent_builders::UpdateApplicationComponentConfig::set_secrets_manager_key): <p> Database credentials. </p>
    /// - On success, responds with [`UpdateApplicationComponentConfigOutput`](crate::output::UpdateApplicationComponentConfigOutput)

    /// - On failure, responds with [`SdkError<UpdateApplicationComponentConfigError>`](crate::error::UpdateApplicationComponentConfigError)
    pub fn update_application_component_config(
        &self,
    ) -> fluent_builders::UpdateApplicationComponentConfig {
        fluent_builders::UpdateApplicationComponentConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateServerConfig`](crate::client::fluent_builders::UpdateServerConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`server_id(impl Into<String>)`](crate::client::fluent_builders::UpdateServerConfig::server_id) / [`set_server_id(Option<String>)`](crate::client::fluent_builders::UpdateServerConfig::set_server_id): <p> The ID of the server. </p>
    ///   - [`strategy_option(StrategyOption)`](crate::client::fluent_builders::UpdateServerConfig::strategy_option) / [`set_strategy_option(Option<StrategyOption>)`](crate::client::fluent_builders::UpdateServerConfig::set_strategy_option): <p> The preferred strategy options for the application component. See the response from <code>GetServerStrategies</code>.</p>
    /// - On success, responds with [`UpdateServerConfigOutput`](crate::output::UpdateServerConfigOutput)

    /// - On failure, responds with [`SdkError<UpdateServerConfigError>`](crate::error::UpdateServerConfigError)
    pub fn update_server_config(&self) -> fluent_builders::UpdateServerConfig {
        fluent_builders::UpdateServerConfig::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `GetApplicationComponentDetails`.
    ///
    /// <p> Retrieves details about an application component. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetApplicationComponentDetails {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_application_component_details_input::Builder,
    }
    impl GetApplicationComponentDetails {
        /// Creates a new `GetApplicationComponentDetails`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetApplicationComponentDetailsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetApplicationComponentDetailsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The ID of the application component. The ID is unique within an AWS account.</p>
        pub fn application_component_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_component_id(input.into());
            self
        }
        /// <p> The ID of the application component. The ID is unique within an AWS account.</p>
        pub fn set_application_component_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_component_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetApplicationComponentStrategies`.
    ///
    /// <p> Retrieves a list of all the recommended strategies and tools for an application component running on a server. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetApplicationComponentStrategies {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_application_component_strategies_input::Builder,
    }
    impl GetApplicationComponentStrategies {
        /// Creates a new `GetApplicationComponentStrategies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetApplicationComponentStrategiesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetApplicationComponentStrategiesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The ID of the application component. The ID is unique within an AWS account.</p>
        pub fn application_component_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_component_id(input.into());
            self
        }
        /// <p> The ID of the application component. The ID is unique within an AWS account.</p>
        pub fn set_application_component_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_component_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAssessment`.
    ///
    /// <p> Retrieves the status of an on-going assessment. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAssessment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_assessment_input::Builder,
    }
    impl GetAssessment {
        /// Creates a new `GetAssessment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAssessmentOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAssessmentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The <code>assessmentid</code> returned by <code>StartAssessment</code>.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p> The <code>assessmentid</code> returned by <code>StartAssessment</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetImportFileTask`.
    ///
    /// <p> Retrieves the details about a specific import task. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetImportFileTask {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_import_file_task_input::Builder,
    }
    impl GetImportFileTask {
        /// Creates a new `GetImportFileTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetImportFileTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::GetImportFileTaskError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The ID of the import file task. This ID is returned in the response of <code>StartImportFileTask</code>. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p> The ID of the import file task. This ID is returned in the response of <code>StartImportFileTask</code>. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPortfolioPreferences`.
    ///
    /// <p> Retrieves your migration and modernization preferences. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetPortfolioPreferences {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_portfolio_preferences_input::Builder,
    }
    impl GetPortfolioPreferences {
        /// Creates a new `GetPortfolioPreferences`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPortfolioPreferencesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPortfolioPreferencesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetPortfolioSummary`.
    ///
    /// <p> Retrieves overall summary including the number of servers to rehost and the overall number of anti-patterns. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetPortfolioSummary {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_portfolio_summary_input::Builder,
    }
    impl GetPortfolioSummary {
        /// Creates a new `GetPortfolioSummary`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPortfolioSummaryOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPortfolioSummaryError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetRecommendationReportDetails`.
    ///
    /// <p> Retrieves detailed information about the specified recommendation report. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetRecommendationReportDetails {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_recommendation_report_details_input::Builder,
    }
    impl GetRecommendationReportDetails {
        /// Creates a new `GetRecommendationReportDetails`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRecommendationReportDetailsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRecommendationReportDetailsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The recommendation report generation task <code>id</code> returned by <code>StartRecommendationReportGeneration</code>. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p> The recommendation report generation task <code>id</code> returned by <code>StartRecommendationReportGeneration</code>. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetServerDetails`.
    ///
    /// <p> Retrieves detailed information about a specified server. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetServerDetails {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_server_details_input::Builder,
    }
    impl GetServerDetails {
        /// Creates a new `GetServerDetails`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetServerDetailsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetServerDetailsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetServerDetailsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetServerDetailsPaginator {
            crate::paginator::GetServerDetailsPaginator::new(self.handle, self.inner)
        }
        /// <p> The ID of the server. </p>
        pub fn server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.server_id(input.into());
            self
        }
        /// <p> The ID of the server. </p>
        pub fn set_server_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_server_id(input);
            self
        }
        /// <p> The token from a previous call that you use to retrieve the next set of results. For example, if a previous call to this action returned 100 items, but you set <code>maxResults</code> to 10. You'll receive a set of 10 results along with a token. You then use the returned token to retrieve the next set of 10. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> The token from a previous call that you use to retrieve the next set of results. For example, if a previous call to this action returned 100 items, but you set <code>maxResults</code> to 10. You'll receive a set of 10 results along with a token. You then use the returned token to retrieve the next set of 10. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> The maximum number of items to include in the response. The maximum value is 100. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> The maximum number of items to include in the response. The maximum value is 100. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetServerStrategies`.
    ///
    /// <p> Retrieves recommended strategies and tools for the specified server. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetServerStrategies {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_server_strategies_input::Builder,
    }
    impl GetServerStrategies {
        /// Creates a new `GetServerStrategies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetServerStrategiesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetServerStrategiesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The ID of the server. </p>
        pub fn server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.server_id(input.into());
            self
        }
        /// <p> The ID of the server. </p>
        pub fn set_server_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_server_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListApplicationComponents`.
    ///
    /// <p> Retrieves a list of all the application components (processes). </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListApplicationComponents {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_application_components_input::Builder,
    }
    impl ListApplicationComponents {
        /// Creates a new `ListApplicationComponents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListApplicationComponentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListApplicationComponentsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListApplicationComponentsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListApplicationComponentsPaginator {
            crate::paginator::ListApplicationComponentsPaginator::new(self.handle, self.inner)
        }
        /// <p> Criteria for filtering the list of application components. </p>
        pub fn application_component_criteria(
            mut self,
            input: crate::model::ApplicationComponentCriteria,
        ) -> Self {
            self.inner = self.inner.application_component_criteria(input);
            self
        }
        /// <p> Criteria for filtering the list of application components. </p>
        pub fn set_application_component_criteria(
            mut self,
            input: std::option::Option<crate::model::ApplicationComponentCriteria>,
        ) -> Self {
            self.inner = self.inner.set_application_component_criteria(input);
            self
        }
        /// <p> Specify the value based on the application component criteria type. For example, if <code>applicationComponentCriteria</code> is set to <code>SERVER_ID</code> and <code>filterValue</code> is set to <code>server1</code>, then <code>ListApplicationComponents</code> returns all the application components running on server1. </p>
        pub fn filter_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.filter_value(input.into());
            self
        }
        /// <p> Specify the value based on the application component criteria type. For example, if <code>applicationComponentCriteria</code> is set to <code>SERVER_ID</code> and <code>filterValue</code> is set to <code>server1</code>, then <code>ListApplicationComponents</code> returns all the application components running on server1. </p>
        pub fn set_filter_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_filter_value(input);
            self
        }
        /// <p> Specifies whether to sort by ascending (<code>ASC</code>) or descending (<code>DESC</code>) order. </p>
        pub fn sort(mut self, input: crate::model::SortOrder) -> Self {
            self.inner = self.inner.sort(input);
            self
        }
        /// <p> Specifies whether to sort by ascending (<code>ASC</code>) or descending (<code>DESC</code>) order. </p>
        pub fn set_sort(mut self, input: std::option::Option<crate::model::SortOrder>) -> Self {
            self.inner = self.inner.set_sort(input);
            self
        }
        /// Appends an item to `groupIdFilter`.
        ///
        /// To override the contents of this collection use [`set_group_id_filter`](Self::set_group_id_filter).
        ///
        /// <p> The group ID specified in to filter on. </p>
        pub fn group_id_filter(mut self, input: crate::model::Group) -> Self {
            self.inner = self.inner.group_id_filter(input);
            self
        }
        /// <p> The group ID specified in to filter on. </p>
        pub fn set_group_id_filter(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Group>>,
        ) -> Self {
            self.inner = self.inner.set_group_id_filter(input);
            self
        }
        /// <p> The token from a previous call that you use to retrieve the next set of results. For example, if a previous call to this action returned 100 items, but you set <code>maxResults</code> to 10. You'll receive a set of 10 results along with a token. You then use the returned token to retrieve the next set of 10. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> The token from a previous call that you use to retrieve the next set of results. For example, if a previous call to this action returned 100 items, but you set <code>maxResults</code> to 10. You'll receive a set of 10 results along with a token. You then use the returned token to retrieve the next set of 10. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> The maximum number of items to include in the response. The maximum value is 100. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> The maximum number of items to include in the response. The maximum value is 100. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCollectors`.
    ///
    /// <p> Retrieves a list of all the installed collectors. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListCollectors {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_collectors_input::Builder,
    }
    impl ListCollectors {
        /// Creates a new `ListCollectors`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCollectorsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListCollectorsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListCollectorsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListCollectorsPaginator {
            crate::paginator::ListCollectorsPaginator::new(self.handle, self.inner)
        }
        /// <p> The token from a previous call that you use to retrieve the next set of results. For example, if a previous call to this action returned 100 items, but you set <code>maxResults</code> to 10. You'll receive a set of 10 results along with a token. You then use the returned token to retrieve the next set of 10. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> The token from a previous call that you use to retrieve the next set of results. For example, if a previous call to this action returned 100 items, but you set <code>maxResults</code> to 10. You'll receive a set of 10 results along with a token. You then use the returned token to retrieve the next set of 10. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> The maximum number of items to include in the response. The maximum value is 100. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> The maximum number of items to include in the response. The maximum value is 100. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListImportFileTask`.
    ///
    /// <p> Retrieves a list of all the imports performed. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListImportFileTask {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_import_file_task_input::Builder,
    }
    impl ListImportFileTask {
        /// Creates a new `ListImportFileTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListImportFileTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::ListImportFileTaskError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListImportFileTaskPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListImportFileTaskPaginator {
            crate::paginator::ListImportFileTaskPaginator::new(self.handle, self.inner)
        }
        /// <p> The token from a previous call that you use to retrieve the next set of results. For example, if a previous call to this action returned 100 items, but you set <code>maxResults</code> to 10. You'll receive a set of 10 results along with a token. You then use the returned token to retrieve the next set of 10. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> The token from a previous call that you use to retrieve the next set of results. For example, if a previous call to this action returned 100 items, but you set <code>maxResults</code> to 10. You'll receive a set of 10 results along with a token. You then use the returned token to retrieve the next set of 10. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> The total number of items to return. The maximum value is 100. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> The total number of items to return. The maximum value is 100. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListServers`.
    ///
    /// <p> Returns a list of all the servers. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListServers {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_servers_input::Builder,
    }
    impl ListServers {
        /// Creates a new `ListServers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListServersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListServersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListServersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListServersPaginator {
            crate::paginator::ListServersPaginator::new(self.handle, self.inner)
        }
        /// <p> Criteria for filtering servers. </p>
        pub fn server_criteria(mut self, input: crate::model::ServerCriteria) -> Self {
            self.inner = self.inner.server_criteria(input);
            self
        }
        /// <p> Criteria for filtering servers. </p>
        pub fn set_server_criteria(
            mut self,
            input: std::option::Option<crate::model::ServerCriteria>,
        ) -> Self {
            self.inner = self.inner.set_server_criteria(input);
            self
        }
        /// <p> Specifies the filter value, which is based on the type of server criteria. For example, if <code>serverCriteria</code> is <code>OS_NAME</code>, and the <code>filterValue</code> is equal to <code>WindowsServer</code>, then <code>ListServers</code> returns all of the servers matching the OS name <code>WindowsServer</code>. </p>
        pub fn filter_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.filter_value(input.into());
            self
        }
        /// <p> Specifies the filter value, which is based on the type of server criteria. For example, if <code>serverCriteria</code> is <code>OS_NAME</code>, and the <code>filterValue</code> is equal to <code>WindowsServer</code>, then <code>ListServers</code> returns all of the servers matching the OS name <code>WindowsServer</code>. </p>
        pub fn set_filter_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_filter_value(input);
            self
        }
        /// <p> Specifies whether to sort by ascending (<code>ASC</code>) or descending (<code>DESC</code>) order. </p>
        pub fn sort(mut self, input: crate::model::SortOrder) -> Self {
            self.inner = self.inner.sort(input);
            self
        }
        /// <p> Specifies whether to sort by ascending (<code>ASC</code>) or descending (<code>DESC</code>) order. </p>
        pub fn set_sort(mut self, input: std::option::Option<crate::model::SortOrder>) -> Self {
            self.inner = self.inner.set_sort(input);
            self
        }
        /// Appends an item to `groupIdFilter`.
        ///
        /// To override the contents of this collection use [`set_group_id_filter`](Self::set_group_id_filter).
        ///
        /// <p> Specifies the group ID to filter on. </p>
        pub fn group_id_filter(mut self, input: crate::model::Group) -> Self {
            self.inner = self.inner.group_id_filter(input);
            self
        }
        /// <p> Specifies the group ID to filter on. </p>
        pub fn set_group_id_filter(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Group>>,
        ) -> Self {
            self.inner = self.inner.set_group_id_filter(input);
            self
        }
        /// <p> The token from a previous call that you use to retrieve the next set of results. For example, if a previous call to this action returned 100 items, but you set <code>maxResults</code> to 10. You'll receive a set of 10 results along with a token. You then use the returned token to retrieve the next set of 10. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> The token from a previous call that you use to retrieve the next set of results. For example, if a previous call to this action returned 100 items, but you set <code>maxResults</code> to 10. You'll receive a set of 10 results along with a token. You then use the returned token to retrieve the next set of 10. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> The maximum number of items to include in the response. The maximum value is 100. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> The maximum number of items to include in the response. The maximum value is 100. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutPortfolioPreferences`.
    ///
    /// <p> Saves the specified migration and modernization preferences. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutPortfolioPreferences {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_portfolio_preferences_input::Builder,
    }
    impl PutPortfolioPreferences {
        /// Creates a new `PutPortfolioPreferences`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutPortfolioPreferencesOutput,
            aws_smithy_http::result::SdkError<crate::error::PutPortfolioPreferencesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The rank of the business goals based on priority. </p>
        pub fn prioritize_business_goals(
            mut self,
            input: crate::model::PrioritizeBusinessGoals,
        ) -> Self {
            self.inner = self.inner.prioritize_business_goals(input);
            self
        }
        /// <p> The rank of the business goals based on priority. </p>
        pub fn set_prioritize_business_goals(
            mut self,
            input: std::option::Option<crate::model::PrioritizeBusinessGoals>,
        ) -> Self {
            self.inner = self.inner.set_prioritize_business_goals(input);
            self
        }
        /// <p> The transformation preferences for non-database applications. </p>
        pub fn application_preferences(
            mut self,
            input: crate::model::ApplicationPreferences,
        ) -> Self {
            self.inner = self.inner.application_preferences(input);
            self
        }
        /// <p> The transformation preferences for non-database applications. </p>
        pub fn set_application_preferences(
            mut self,
            input: std::option::Option<crate::model::ApplicationPreferences>,
        ) -> Self {
            self.inner = self.inner.set_application_preferences(input);
            self
        }
        /// <p> The transformation preferences for database applications. </p>
        pub fn database_preferences(mut self, input: crate::model::DatabasePreferences) -> Self {
            self.inner = self.inner.database_preferences(input);
            self
        }
        /// <p> The transformation preferences for database applications. </p>
        pub fn set_database_preferences(
            mut self,
            input: std::option::Option<crate::model::DatabasePreferences>,
        ) -> Self {
            self.inner = self.inner.set_database_preferences(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartAssessment`.
    ///
    /// <p> Starts the assessment of an on-premises environment. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartAssessment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_assessment_input::Builder,
    }
    impl StartAssessment {
        /// Creates a new `StartAssessment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartAssessmentOutput,
            aws_smithy_http::result::SdkError<crate::error::StartAssessmentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The S3 bucket used by the collectors to send analysis data to the service. The bucket name must begin with <code>migrationhub-strategy-</code>. </p>
        pub fn s3bucket_for_analysis_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.s3bucket_for_analysis_data(input.into());
            self
        }
        /// <p> The S3 bucket used by the collectors to send analysis data to the service. The bucket name must begin with <code>migrationhub-strategy-</code>. </p>
        pub fn set_s3bucket_for_analysis_data(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_s3bucket_for_analysis_data(input);
            self
        }
        /// <p> The S3 bucket where all the reports generated by the service are stored. The bucket name must begin with <code>migrationhub-strategy-</code>. </p>
        pub fn s3bucket_for_report_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.s3bucket_for_report_data(input.into());
            self
        }
        /// <p> The S3 bucket where all the reports generated by the service are stored. The bucket name must begin with <code>migrationhub-strategy-</code>. </p>
        pub fn set_s3bucket_for_report_data(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_s3bucket_for_report_data(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartImportFileTask`.
    ///
    /// <p> Starts a file import. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartImportFileTask {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_import_file_task_input::Builder,
    }
    impl StartImportFileTask {
        /// Creates a new `StartImportFileTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartImportFileTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::StartImportFileTaskError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> A descriptive name for the request. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p> A descriptive name for the request. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p> The S3 bucket where the import file is located. The bucket name is required to begin with <code>migrationhub-strategy-</code>.</p>
        pub fn s3_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.s3_bucket(input.into());
            self
        }
        /// <p> The S3 bucket where the import file is located. The bucket name is required to begin with <code>migrationhub-strategy-</code>.</p>
        pub fn set_s3_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_s3_bucket(input);
            self
        }
        /// <p> The Amazon S3 key name of the import file. </p>
        pub fn s3key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.s3key(input.into());
            self
        }
        /// <p> The Amazon S3 key name of the import file. </p>
        pub fn set_s3key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_s3key(input);
            self
        }
        /// <p>Specifies the source that the servers are coming from. By default, Strategy Recommendations assumes that the servers specified in the import file are available in AWS Application Discovery Service. </p>
        pub fn data_source_type(mut self, input: crate::model::DataSourceType) -> Self {
            self.inner = self.inner.data_source_type(input);
            self
        }
        /// <p>Specifies the source that the servers are coming from. By default, Strategy Recommendations assumes that the servers specified in the import file are available in AWS Application Discovery Service. </p>
        pub fn set_data_source_type(
            mut self,
            input: std::option::Option<crate::model::DataSourceType>,
        ) -> Self {
            self.inner = self.inner.set_data_source_type(input);
            self
        }
        /// Appends an item to `groupId`.
        ///
        /// To override the contents of this collection use [`set_group_id`](Self::set_group_id).
        ///
        /// <p>Groups the resources in the import file together with a unique name. This ID can be as filter in <code>ListApplicationComponents</code> and <code>ListServers</code>. </p>
        pub fn group_id(mut self, input: crate::model::Group) -> Self {
            self.inner = self.inner.group_id(input);
            self
        }
        /// <p>Groups the resources in the import file together with a unique name. This ID can be as filter in <code>ListApplicationComponents</code> and <code>ListServers</code>. </p>
        pub fn set_group_id(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Group>>,
        ) -> Self {
            self.inner = self.inner.set_group_id(input);
            self
        }
        /// <p> The S3 bucket where Strategy Recommendations uploads import results. The bucket name is required to begin with migrationhub-strategy-. </p>
        pub fn s3bucket_for_report_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.s3bucket_for_report_data(input.into());
            self
        }
        /// <p> The S3 bucket where Strategy Recommendations uploads import results. The bucket name is required to begin with migrationhub-strategy-. </p>
        pub fn set_s3bucket_for_report_data(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_s3bucket_for_report_data(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartRecommendationReportGeneration`.
    ///
    /// <p> Starts generating a recommendation report. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartRecommendationReportGeneration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_recommendation_report_generation_input::Builder,
    }
    impl StartRecommendationReportGeneration {
        /// Creates a new `StartRecommendationReportGeneration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartRecommendationReportGenerationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::StartRecommendationReportGenerationError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The output format for the recommendation report file. The default format is Microsoft Excel. </p>
        pub fn output_format(mut self, input: crate::model::OutputFormat) -> Self {
            self.inner = self.inner.output_format(input);
            self
        }
        /// <p> The output format for the recommendation report file. The default format is Microsoft Excel. </p>
        pub fn set_output_format(
            mut self,
            input: std::option::Option<crate::model::OutputFormat>,
        ) -> Self {
            self.inner = self.inner.set_output_format(input);
            self
        }
        /// Appends an item to `groupIdFilter`.
        ///
        /// To override the contents of this collection use [`set_group_id_filter`](Self::set_group_id_filter).
        ///
        /// <p> Groups the resources in the recommendation report with a unique name. </p>
        pub fn group_id_filter(mut self, input: crate::model::Group) -> Self {
            self.inner = self.inner.group_id_filter(input);
            self
        }
        /// <p> Groups the resources in the recommendation report with a unique name. </p>
        pub fn set_group_id_filter(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Group>>,
        ) -> Self {
            self.inner = self.inner.set_group_id_filter(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopAssessment`.
    ///
    /// <p> Stops the assessment of an on-premises environment. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StopAssessment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::stop_assessment_input::Builder,
    }
    impl StopAssessment {
        /// Creates a new `StopAssessment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopAssessmentOutput,
            aws_smithy_http::result::SdkError<crate::error::StopAssessmentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The <code>assessmentId</code> returned by <code>StartAssessment</code>. </p>
        pub fn assessment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_id(input.into());
            self
        }
        /// <p> The <code>assessmentId</code> returned by <code>StartAssessment</code>. </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateApplicationComponentConfig`.
    ///
    /// <p> Updates the configuration of an application component. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateApplicationComponentConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_application_component_config_input::Builder,
    }
    impl UpdateApplicationComponentConfig {
        /// Creates a new `UpdateApplicationComponentConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateApplicationComponentConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateApplicationComponentConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The ID of the application component. The ID is unique within an AWS account. </p>
        pub fn application_component_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_component_id(input.into());
            self
        }
        /// <p> The ID of the application component. The ID is unique within an AWS account. </p>
        pub fn set_application_component_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_component_id(input);
            self
        }
        /// <p> Indicates whether the application component has been included for server recommendation or not. </p>
        pub fn inclusion_status(mut self, input: crate::model::InclusionStatus) -> Self {
            self.inner = self.inner.inclusion_status(input);
            self
        }
        /// <p> Indicates whether the application component has been included for server recommendation or not. </p>
        pub fn set_inclusion_status(
            mut self,
            input: std::option::Option<crate::model::InclusionStatus>,
        ) -> Self {
            self.inner = self.inner.set_inclusion_status(input);
            self
        }
        /// <p> The preferred strategy options for the application component. Use values from the <code>GetApplicationComponentStrategies</code> response. </p>
        pub fn strategy_option(mut self, input: crate::model::StrategyOption) -> Self {
            self.inner = self.inner.strategy_option(input);
            self
        }
        /// <p> The preferred strategy options for the application component. Use values from the <code>GetApplicationComponentStrategies</code> response. </p>
        pub fn set_strategy_option(
            mut self,
            input: std::option::Option<crate::model::StrategyOption>,
        ) -> Self {
            self.inner = self.inner.set_strategy_option(input);
            self
        }
        /// Appends an item to `sourceCodeList`.
        ///
        /// To override the contents of this collection use [`set_source_code_list`](Self::set_source_code_list).
        ///
        /// <p> The list of source code configurations to update for the application component. </p>
        pub fn source_code_list(mut self, input: crate::model::SourceCode) -> Self {
            self.inner = self.inner.source_code_list(input);
            self
        }
        /// <p> The list of source code configurations to update for the application component. </p>
        pub fn set_source_code_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SourceCode>>,
        ) -> Self {
            self.inner = self.inner.set_source_code_list(input);
            self
        }
        /// <p> Database credentials. </p>
        pub fn secrets_manager_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secrets_manager_key(input.into());
            self
        }
        /// <p> Database credentials. </p>
        pub fn set_secrets_manager_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_secrets_manager_key(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateServerConfig`.
    ///
    /// <p> Updates the configuration of the specified server. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateServerConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_server_config_input::Builder,
    }
    impl UpdateServerConfig {
        /// Creates a new `UpdateServerConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateServerConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateServerConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The ID of the server. </p>
        pub fn server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.server_id(input.into());
            self
        }
        /// <p> The ID of the server. </p>
        pub fn set_server_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_server_id(input);
            self
        }
        /// <p> The preferred strategy options for the application component. See the response from <code>GetServerStrategies</code>.</p>
        pub fn strategy_option(mut self, input: crate::model::StrategyOption) -> Self {
            self.inner = self.inner.strategy_option(input);
            self
        }
        /// <p> The preferred strategy options for the application component. See the response from <code>GetServerStrategies</code>.</p>
        pub fn set_strategy_option(
            mut self,
            input: std::option::Option<crate::model::StrategyOption>,
        ) -> Self {
            self.inner = self.inner.set_strategy_option(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
