// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>
/// Information about all the available strategy options for migrating and modernizing an application component.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StrategyOption {
    /// <p>
    /// Type of transformation. For example, Rehost, Replatform, and so on.
    /// </p>
    pub strategy: std::option::Option<crate::model::Strategy>,
    /// <p>
    /// The name of the tool that can be used to transform an application component using this strategy.
    /// </p>
    pub tool_name: std::option::Option<crate::model::TransformationToolName>,
    /// <p>
    /// Destination information about where the application component can migrate to. For example, <code>EC2</code>, <code>ECS</code>, and so on.
    /// </p>
    pub target_destination: std::option::Option<crate::model::TargetDestination>,
    /// <p>
    /// Indicates if a specific strategy is preferred for the application component.
    /// </p>
    pub is_preferred: std::option::Option<bool>,
}
impl StrategyOption {
    /// <p>
    /// Type of transformation. For example, Rehost, Replatform, and so on.
    /// </p>
    pub fn strategy(&self) -> std::option::Option<&crate::model::Strategy> {
        self.strategy.as_ref()
    }
    /// <p>
    /// The name of the tool that can be used to transform an application component using this strategy.
    /// </p>
    pub fn tool_name(&self) -> std::option::Option<&crate::model::TransformationToolName> {
        self.tool_name.as_ref()
    }
    /// <p>
    /// Destination information about where the application component can migrate to. For example, <code>EC2</code>, <code>ECS</code>, and so on.
    /// </p>
    pub fn target_destination(&self) -> std::option::Option<&crate::model::TargetDestination> {
        self.target_destination.as_ref()
    }
    /// <p>
    /// Indicates if a specific strategy is preferred for the application component.
    /// </p>
    pub fn is_preferred(&self) -> std::option::Option<bool> {
        self.is_preferred
    }
}
impl std::fmt::Debug for StrategyOption {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StrategyOption");
        formatter.field("strategy", &self.strategy);
        formatter.field("tool_name", &self.tool_name);
        formatter.field("target_destination", &self.target_destination);
        formatter.field("is_preferred", &self.is_preferred);
        formatter.finish()
    }
}
/// See [`StrategyOption`](crate::model::StrategyOption)
pub mod strategy_option {
    /// A builder for [`StrategyOption`](crate::model::StrategyOption)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) strategy: std::option::Option<crate::model::Strategy>,
        pub(crate) tool_name: std::option::Option<crate::model::TransformationToolName>,
        pub(crate) target_destination: std::option::Option<crate::model::TargetDestination>,
        pub(crate) is_preferred: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>
        /// Type of transformation. For example, Rehost, Replatform, and so on.
        /// </p>
        pub fn strategy(mut self, input: crate::model::Strategy) -> Self {
            self.strategy = Some(input);
            self
        }
        /// <p>
        /// Type of transformation. For example, Rehost, Replatform, and so on.
        /// </p>
        pub fn set_strategy(mut self, input: std::option::Option<crate::model::Strategy>) -> Self {
            self.strategy = input;
            self
        }
        /// <p>
        /// The name of the tool that can be used to transform an application component using this strategy.
        /// </p>
        pub fn tool_name(mut self, input: crate::model::TransformationToolName) -> Self {
            self.tool_name = Some(input);
            self
        }
        /// <p>
        /// The name of the tool that can be used to transform an application component using this strategy.
        /// </p>
        pub fn set_tool_name(
            mut self,
            input: std::option::Option<crate::model::TransformationToolName>,
        ) -> Self {
            self.tool_name = input;
            self
        }
        /// <p>
        /// Destination information about where the application component can migrate to. For example, <code>EC2</code>, <code>ECS</code>, and so on.
        /// </p>
        pub fn target_destination(mut self, input: crate::model::TargetDestination) -> Self {
            self.target_destination = Some(input);
            self
        }
        /// <p>
        /// Destination information about where the application component can migrate to. For example, <code>EC2</code>, <code>ECS</code>, and so on.
        /// </p>
        pub fn set_target_destination(
            mut self,
            input: std::option::Option<crate::model::TargetDestination>,
        ) -> Self {
            self.target_destination = input;
            self
        }
        /// <p>
        /// Indicates if a specific strategy is preferred for the application component.
        /// </p>
        pub fn is_preferred(mut self, input: bool) -> Self {
            self.is_preferred = Some(input);
            self
        }
        /// <p>
        /// Indicates if a specific strategy is preferred for the application component.
        /// </p>
        pub fn set_is_preferred(mut self, input: std::option::Option<bool>) -> Self {
            self.is_preferred = input;
            self
        }
        /// Consumes the builder and constructs a [`StrategyOption`](crate::model::StrategyOption)
        pub fn build(self) -> crate::model::StrategyOption {
            crate::model::StrategyOption {
                strategy: self.strategy,
                tool_name: self.tool_name,
                target_destination: self.target_destination,
                is_preferred: self.is_preferred,
            }
        }
    }
}
impl StrategyOption {
    /// Creates a new builder-style object to manufacture [`StrategyOption`](crate::model::StrategyOption)
    pub fn builder() -> crate::model::strategy_option::Builder {
        crate::model::strategy_option::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TargetDestination {
    #[allow(missing_docs)] // documentation missing in model
    AwsElasticBeanstalk,
    #[allow(missing_docs)] // documentation missing in model
    AwsFargate,
    #[allow(missing_docs)] // documentation missing in model
    AmazonDocumentdb,
    #[allow(missing_docs)] // documentation missing in model
    AmazonDynamodb,
    #[allow(missing_docs)] // documentation missing in model
    AmazonElasticCloudCompute,
    #[allow(missing_docs)] // documentation missing in model
    AmazonElasticContainerService,
    #[allow(missing_docs)] // documentation missing in model
    AmazonElasticKubernetesService,
    #[allow(missing_docs)] // documentation missing in model
    AmazonRds,
    #[allow(missing_docs)] // documentation missing in model
    AmazonRdsMysql,
    #[allow(missing_docs)] // documentation missing in model
    AmazonRdsPostgresql,
    #[allow(missing_docs)] // documentation missing in model
    AuroraMysql,
    #[allow(missing_docs)] // documentation missing in model
    AuroraPostgresql,
    #[allow(missing_docs)] // documentation missing in model
    NoneSpecified,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TargetDestination {
    fn from(s: &str) -> Self {
        match s {
            "AWS Elastic BeanStalk" => TargetDestination::AwsElasticBeanstalk,
            "AWS Fargate" => TargetDestination::AwsFargate,
            "Amazon DocumentDB" => TargetDestination::AmazonDocumentdb,
            "Amazon DynamoDB" => TargetDestination::AmazonDynamodb,
            "Amazon Elastic Cloud Compute (EC2)" => TargetDestination::AmazonElasticCloudCompute,
            "Amazon Elastic Container Service (ECS)" => {
                TargetDestination::AmazonElasticContainerService
            }
            "Amazon Elastic Kubernetes Service (EKS)" => {
                TargetDestination::AmazonElasticKubernetesService
            }
            "Amazon Relational Database Service" => TargetDestination::AmazonRds,
            "Amazon Relational Database Service on MySQL" => TargetDestination::AmazonRdsMysql,
            "Amazon Relational Database Service on PostgreSQL" => {
                TargetDestination::AmazonRdsPostgresql
            }
            "Aurora MySQL" => TargetDestination::AuroraMysql,
            "Aurora PostgreSQL" => TargetDestination::AuroraPostgresql,
            "None specified" => TargetDestination::NoneSpecified,
            other => TargetDestination::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TargetDestination {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TargetDestination::from(s))
    }
}
impl TargetDestination {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TargetDestination::AwsElasticBeanstalk => "AWS Elastic BeanStalk",
            TargetDestination::AwsFargate => "AWS Fargate",
            TargetDestination::AmazonDocumentdb => "Amazon DocumentDB",
            TargetDestination::AmazonDynamodb => "Amazon DynamoDB",
            TargetDestination::AmazonElasticCloudCompute => "Amazon Elastic Cloud Compute (EC2)",
            TargetDestination::AmazonElasticContainerService => {
                "Amazon Elastic Container Service (ECS)"
            }
            TargetDestination::AmazonElasticKubernetesService => {
                "Amazon Elastic Kubernetes Service (EKS)"
            }
            TargetDestination::AmazonRds => "Amazon Relational Database Service",
            TargetDestination::AmazonRdsMysql => "Amazon Relational Database Service on MySQL",
            TargetDestination::AmazonRdsPostgresql => {
                "Amazon Relational Database Service on PostgreSQL"
            }
            TargetDestination::AuroraMysql => "Aurora MySQL",
            TargetDestination::AuroraPostgresql => "Aurora PostgreSQL",
            TargetDestination::NoneSpecified => "None specified",
            TargetDestination::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AWS Elastic BeanStalk",
            "AWS Fargate",
            "Amazon DocumentDB",
            "Amazon DynamoDB",
            "Amazon Elastic Cloud Compute (EC2)",
            "Amazon Elastic Container Service (ECS)",
            "Amazon Elastic Kubernetes Service (EKS)",
            "Amazon Relational Database Service",
            "Amazon Relational Database Service on MySQL",
            "Amazon Relational Database Service on PostgreSQL",
            "Aurora MySQL",
            "Aurora PostgreSQL",
            "None specified",
        ]
    }
}
impl AsRef<str> for TargetDestination {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TransformationToolName {
    #[allow(missing_docs)] // documentation missing in model
    App2Container,
    #[allow(missing_docs)] // documentation missing in model
    Mgn,
    #[allow(missing_docs)] // documentation missing in model
    Dms,
    #[allow(missing_docs)] // documentation missing in model
    Emp,
    #[allow(missing_docs)] // documentation missing in model
    InPlaceOsUpgrade,
    #[allow(missing_docs)] // documentation missing in model
    NativeSql,
    #[allow(missing_docs)] // documentation missing in model
    PortingAssistant,
    #[allow(missing_docs)] // documentation missing in model
    Sct,
    #[allow(missing_docs)] // documentation missing in model
    StrategyRecommendationSupport,
    #[allow(missing_docs)] // documentation missing in model
    Wwama,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TransformationToolName {
    fn from(s: &str) -> Self {
        match s {
            "App2Container" => TransformationToolName::App2Container,
            "Application Migration Service" => TransformationToolName::Mgn,
            "Database Migration Service" => TransformationToolName::Dms,
            "End of Support Migration" => TransformationToolName::Emp,
            "In Place Operating System Upgrade" => TransformationToolName::InPlaceOsUpgrade,
            "Native SQL Server Backup/Restore" => TransformationToolName::NativeSql,
            "Porting Assistant For .NET" => TransformationToolName::PortingAssistant,
            "Schema Conversion Tool" => TransformationToolName::Sct,
            "Strategy Recommendation Support" => {
                TransformationToolName::StrategyRecommendationSupport
            }
            "Windows Web Application Migration Assistant" => TransformationToolName::Wwama,
            other => TransformationToolName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TransformationToolName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TransformationToolName::from(s))
    }
}
impl TransformationToolName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TransformationToolName::App2Container => "App2Container",
            TransformationToolName::Mgn => "Application Migration Service",
            TransformationToolName::Dms => "Database Migration Service",
            TransformationToolName::Emp => "End of Support Migration",
            TransformationToolName::InPlaceOsUpgrade => "In Place Operating System Upgrade",
            TransformationToolName::NativeSql => "Native SQL Server Backup/Restore",
            TransformationToolName::PortingAssistant => "Porting Assistant For .NET",
            TransformationToolName::Sct => "Schema Conversion Tool",
            TransformationToolName::StrategyRecommendationSupport => {
                "Strategy Recommendation Support"
            }
            TransformationToolName::Wwama => "Windows Web Application Migration Assistant",
            TransformationToolName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "App2Container",
            "Application Migration Service",
            "Database Migration Service",
            "End of Support Migration",
            "In Place Operating System Upgrade",
            "Native SQL Server Backup/Restore",
            "Porting Assistant For .NET",
            "Schema Conversion Tool",
            "Strategy Recommendation Support",
            "Windows Web Application Migration Assistant",
        ]
    }
}
impl AsRef<str> for TransformationToolName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Strategy {
    #[allow(missing_docs)] // documentation missing in model
    Refactor,
    #[allow(missing_docs)] // documentation missing in model
    Rehost,
    #[allow(missing_docs)] // documentation missing in model
    Relocate,
    #[allow(missing_docs)] // documentation missing in model
    Replatform,
    #[allow(missing_docs)] // documentation missing in model
    Repurchase,
    #[allow(missing_docs)] // documentation missing in model
    Retain,
    #[allow(missing_docs)] // documentation missing in model
    Retirement,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Strategy {
    fn from(s: &str) -> Self {
        match s {
            "Refactor" => Strategy::Refactor,
            "Rehost" => Strategy::Rehost,
            "Relocate" => Strategy::Relocate,
            "Replatform" => Strategy::Replatform,
            "Repurchase" => Strategy::Repurchase,
            "Retain" => Strategy::Retain,
            "Retirement" => Strategy::Retirement,
            other => Strategy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Strategy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Strategy::from(s))
    }
}
impl Strategy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Strategy::Refactor => "Refactor",
            Strategy::Rehost => "Rehost",
            Strategy::Relocate => "Relocate",
            Strategy::Replatform => "Replatform",
            Strategy::Repurchase => "Repurchase",
            Strategy::Retain => "Retain",
            Strategy::Retirement => "Retirement",
            Strategy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Refactor",
            "Rehost",
            "Relocate",
            "Replatform",
            "Repurchase",
            "Retain",
            "Retirement",
        ]
    }
}
impl AsRef<str> for Strategy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>
/// Object containing source code information that is linked to an application component.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SourceCode {
    /// <p>
    /// The type of repository to use for the source code.
    /// </p>
    pub version_control: std::option::Option<crate::model::VersionControl>,
    /// <p>
    /// The branch of the source code.
    /// </p>
    pub source_version: std::option::Option<std::string::String>,
    /// <p>
    /// The repository name for the source code.
    /// </p>
    pub location: std::option::Option<std::string::String>,
}
impl SourceCode {
    /// <p>
    /// The type of repository to use for the source code.
    /// </p>
    pub fn version_control(&self) -> std::option::Option<&crate::model::VersionControl> {
        self.version_control.as_ref()
    }
    /// <p>
    /// The branch of the source code.
    /// </p>
    pub fn source_version(&self) -> std::option::Option<&str> {
        self.source_version.as_deref()
    }
    /// <p>
    /// The repository name for the source code.
    /// </p>
    pub fn location(&self) -> std::option::Option<&str> {
        self.location.as_deref()
    }
}
impl std::fmt::Debug for SourceCode {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SourceCode");
        formatter.field("version_control", &self.version_control);
        formatter.field("source_version", &self.source_version);
        formatter.field("location", &self.location);
        formatter.finish()
    }
}
/// See [`SourceCode`](crate::model::SourceCode)
pub mod source_code {
    /// A builder for [`SourceCode`](crate::model::SourceCode)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) version_control: std::option::Option<crate::model::VersionControl>,
        pub(crate) source_version: std::option::Option<std::string::String>,
        pub(crate) location: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The type of repository to use for the source code.
        /// </p>
        pub fn version_control(mut self, input: crate::model::VersionControl) -> Self {
            self.version_control = Some(input);
            self
        }
        /// <p>
        /// The type of repository to use for the source code.
        /// </p>
        pub fn set_version_control(
            mut self,
            input: std::option::Option<crate::model::VersionControl>,
        ) -> Self {
            self.version_control = input;
            self
        }
        /// <p>
        /// The branch of the source code.
        /// </p>
        pub fn source_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_version = Some(input.into());
            self
        }
        /// <p>
        /// The branch of the source code.
        /// </p>
        pub fn set_source_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_version = input;
            self
        }
        /// <p>
        /// The repository name for the source code.
        /// </p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>
        /// The repository name for the source code.
        /// </p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// Consumes the builder and constructs a [`SourceCode`](crate::model::SourceCode)
        pub fn build(self) -> crate::model::SourceCode {
            crate::model::SourceCode {
                version_control: self.version_control,
                source_version: self.source_version,
                location: self.location,
            }
        }
    }
}
impl SourceCode {
    /// Creates a new builder-style object to manufacture [`SourceCode`](crate::model::SourceCode)
    pub fn builder() -> crate::model::source_code::Builder {
        crate::model::source_code::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum VersionControl {
    #[allow(missing_docs)] // documentation missing in model
    Github,
    #[allow(missing_docs)] // documentation missing in model
    GithubEnterprise,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for VersionControl {
    fn from(s: &str) -> Self {
        match s {
            "GITHUB" => VersionControl::Github,
            "GITHUB_ENTERPRISE" => VersionControl::GithubEnterprise,
            other => VersionControl::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for VersionControl {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(VersionControl::from(s))
    }
}
impl VersionControl {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            VersionControl::Github => "GITHUB",
            VersionControl::GithubEnterprise => "GITHUB_ENTERPRISE",
            VersionControl::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["GITHUB", "GITHUB_ENTERPRISE"]
    }
}
impl AsRef<str> for VersionControl {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InclusionStatus {
    #[allow(missing_docs)] // documentation missing in model
    ExcludeFromRecommendation,
    #[allow(missing_docs)] // documentation missing in model
    IncludeInRecommendation,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InclusionStatus {
    fn from(s: &str) -> Self {
        match s {
            "excludeFromAssessment" => InclusionStatus::ExcludeFromRecommendation,
            "includeInAssessment" => InclusionStatus::IncludeInRecommendation,
            other => InclusionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InclusionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InclusionStatus::from(s))
    }
}
impl InclusionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InclusionStatus::ExcludeFromRecommendation => "excludeFromAssessment",
            InclusionStatus::IncludeInRecommendation => "includeInAssessment",
            InclusionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["excludeFromAssessment", "includeInAssessment"]
    }
}
impl AsRef<str> for InclusionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>
/// The object containing information about distinct imports or groups for Strategy Recommendations.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Group {
    /// <p>
    /// The key of the specific import group.
    /// </p>
    pub name: std::option::Option<crate::model::GroupName>,
    /// <p>
    /// The value of the specific import group.
    /// </p>
    pub value: std::option::Option<std::string::String>,
}
impl Group {
    /// <p>
    /// The key of the specific import group.
    /// </p>
    pub fn name(&self) -> std::option::Option<&crate::model::GroupName> {
        self.name.as_ref()
    }
    /// <p>
    /// The value of the specific import group.
    /// </p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Group {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Group");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Group`](crate::model::Group)
pub mod group {
    /// A builder for [`Group`](crate::model::Group)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::GroupName>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The key of the specific import group.
        /// </p>
        pub fn name(mut self, input: crate::model::GroupName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>
        /// The key of the specific import group.
        /// </p>
        pub fn set_name(mut self, input: std::option::Option<crate::model::GroupName>) -> Self {
            self.name = input;
            self
        }
        /// <p>
        /// The value of the specific import group.
        /// </p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>
        /// The value of the specific import group.
        /// </p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Group`](crate::model::Group)
        pub fn build(self) -> crate::model::Group {
            crate::model::Group {
                name: self.name,
                value: self.value,
            }
        }
    }
}
impl Group {
    /// Creates a new builder-style object to manufacture [`Group`](crate::model::Group)
    pub fn builder() -> crate::model::group::Builder {
        crate::model::group::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum GroupName {
    #[allow(missing_docs)] // documentation missing in model
    ExternalId,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for GroupName {
    fn from(s: &str) -> Self {
        match s {
            "ExternalId" => GroupName::ExternalId,
            other => GroupName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for GroupName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(GroupName::from(s))
    }
}
impl GroupName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            GroupName::ExternalId => "ExternalId",
            GroupName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ExternalId"]
    }
}
impl AsRef<str> for GroupName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OutputFormat {
    #[allow(missing_docs)] // documentation missing in model
    Excel,
    #[allow(missing_docs)] // documentation missing in model
    Json,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OutputFormat {
    fn from(s: &str) -> Self {
        match s {
            "Excel" => OutputFormat::Excel,
            "Json" => OutputFormat::Json,
            other => OutputFormat::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OutputFormat {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OutputFormat::from(s))
    }
}
impl OutputFormat {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OutputFormat::Excel => "Excel",
            OutputFormat::Json => "Json",
            OutputFormat::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Excel", "Json"]
    }
}
impl AsRef<str> for OutputFormat {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DataSourceType {
    #[allow(missing_docs)] // documentation missing in model
    Ads,
    #[allow(missing_docs)] // documentation missing in model
    Mpa,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DataSourceType {
    fn from(s: &str) -> Self {
        match s {
            "ApplicationDiscoveryService" => DataSourceType::Ads,
            "MPA" => DataSourceType::Mpa,
            other => DataSourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DataSourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DataSourceType::from(s))
    }
}
impl DataSourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DataSourceType::Ads => "ApplicationDiscoveryService",
            DataSourceType::Mpa => "MPA",
            DataSourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ApplicationDiscoveryService", "MPA"]
    }
}
impl AsRef<str> for DataSourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>
/// Preferences on managing your databases on AWS.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DatabasePreferences {
    /// <p> Specifies whether you're interested in self-managed databases or databases managed by
    /// AWS. </p>
    pub database_management_preference:
        std::option::Option<crate::model::DatabaseManagementPreference>,
    /// <p>
    /// Specifies your preferred migration path.
    /// </p>
    pub database_migration_preference:
        std::option::Option<crate::model::DatabaseMigrationPreference>,
}
impl DatabasePreferences {
    /// <p> Specifies whether you're interested in self-managed databases or databases managed by
    /// AWS. </p>
    pub fn database_management_preference(
        &self,
    ) -> std::option::Option<&crate::model::DatabaseManagementPreference> {
        self.database_management_preference.as_ref()
    }
    /// <p>
    /// Specifies your preferred migration path.
    /// </p>
    pub fn database_migration_preference(
        &self,
    ) -> std::option::Option<&crate::model::DatabaseMigrationPreference> {
        self.database_migration_preference.as_ref()
    }
}
impl std::fmt::Debug for DatabasePreferences {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DatabasePreferences");
        formatter.field(
            "database_management_preference",
            &self.database_management_preference,
        );
        formatter.field(
            "database_migration_preference",
            &self.database_migration_preference,
        );
        formatter.finish()
    }
}
/// See [`DatabasePreferences`](crate::model::DatabasePreferences)
pub mod database_preferences {
    /// A builder for [`DatabasePreferences`](crate::model::DatabasePreferences)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) database_management_preference:
            std::option::Option<crate::model::DatabaseManagementPreference>,
        pub(crate) database_migration_preference:
            std::option::Option<crate::model::DatabaseMigrationPreference>,
    }
    impl Builder {
        /// <p> Specifies whether you're interested in self-managed databases or databases managed by
        /// AWS. </p>
        pub fn database_management_preference(
            mut self,
            input: crate::model::DatabaseManagementPreference,
        ) -> Self {
            self.database_management_preference = Some(input);
            self
        }
        /// <p> Specifies whether you're interested in self-managed databases or databases managed by
        /// AWS. </p>
        pub fn set_database_management_preference(
            mut self,
            input: std::option::Option<crate::model::DatabaseManagementPreference>,
        ) -> Self {
            self.database_management_preference = input;
            self
        }
        /// <p>
        /// Specifies your preferred migration path.
        /// </p>
        pub fn database_migration_preference(
            mut self,
            input: crate::model::DatabaseMigrationPreference,
        ) -> Self {
            self.database_migration_preference = Some(input);
            self
        }
        /// <p>
        /// Specifies your preferred migration path.
        /// </p>
        pub fn set_database_migration_preference(
            mut self,
            input: std::option::Option<crate::model::DatabaseMigrationPreference>,
        ) -> Self {
            self.database_migration_preference = input;
            self
        }
        /// Consumes the builder and constructs a [`DatabasePreferences`](crate::model::DatabasePreferences)
        pub fn build(self) -> crate::model::DatabasePreferences {
            crate::model::DatabasePreferences {
                database_management_preference: self.database_management_preference,
                database_migration_preference: self.database_migration_preference,
            }
        }
    }
}
impl DatabasePreferences {
    /// Creates a new builder-style object to manufacture [`DatabasePreferences`](crate::model::DatabasePreferences)
    pub fn builder() -> crate::model::database_preferences::Builder {
        crate::model::database_preferences::Builder::default()
    }
}

/// <p>
/// Preferences for migrating a database to AWS.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum DatabaseMigrationPreference {
    /// <p> Indicates whether you are interested in moving from one type of database to another. For
    /// example, from SQL Server to Amazon Aurora MySQL-Compatible Edition. </p>
    Heterogeneous(crate::model::Heterogeneous),
    /// <p> Indicates whether you are interested in moving to the same type of database into AWS.
    /// For example, from SQL Server in your environment to SQL Server on AWS. </p>
    Homogeneous(crate::model::Homogeneous),
    /// <p>
    /// Indicated that you do not prefer heterogeneous or homogeneous.
    /// </p>
    NoPreference(crate::model::NoDatabaseMigrationPreference),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl DatabaseMigrationPreference {
    /// Tries to convert the enum instance into [`Heterogeneous`](crate::model::DatabaseMigrationPreference::Heterogeneous), extracting the inner [`Heterogeneous`](crate::model::Heterogeneous).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_heterogeneous(&self) -> std::result::Result<&crate::model::Heterogeneous, &Self> {
        if let DatabaseMigrationPreference::Heterogeneous(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Heterogeneous`](crate::model::DatabaseMigrationPreference::Heterogeneous).
    pub fn is_heterogeneous(&self) -> bool {
        self.as_heterogeneous().is_ok()
    }
    /// Tries to convert the enum instance into [`Homogeneous`](crate::model::DatabaseMigrationPreference::Homogeneous), extracting the inner [`Homogeneous`](crate::model::Homogeneous).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_homogeneous(&self) -> std::result::Result<&crate::model::Homogeneous, &Self> {
        if let DatabaseMigrationPreference::Homogeneous(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Homogeneous`](crate::model::DatabaseMigrationPreference::Homogeneous).
    pub fn is_homogeneous(&self) -> bool {
        self.as_homogeneous().is_ok()
    }
    /// Tries to convert the enum instance into [`NoPreference`](crate::model::DatabaseMigrationPreference::NoPreference), extracting the inner [`NoDatabaseMigrationPreference`](crate::model::NoDatabaseMigrationPreference).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_no_preference(
        &self,
    ) -> std::result::Result<&crate::model::NoDatabaseMigrationPreference, &Self> {
        if let DatabaseMigrationPreference::NoPreference(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`NoPreference`](crate::model::DatabaseMigrationPreference::NoPreference).
    pub fn is_no_preference(&self) -> bool {
        self.as_no_preference().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

/// <p> The object containing details about database migration preferences, when you have no
/// particular preference. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NoDatabaseMigrationPreference {
    /// <p>
    /// The target database engine for database migration preference that you specify.
    /// </p>
    pub target_database_engine:
        std::option::Option<std::vec::Vec<crate::model::TargetDatabaseEngine>>,
}
impl NoDatabaseMigrationPreference {
    /// <p>
    /// The target database engine for database migration preference that you specify.
    /// </p>
    pub fn target_database_engine(
        &self,
    ) -> std::option::Option<&[crate::model::TargetDatabaseEngine]> {
        self.target_database_engine.as_deref()
    }
}
impl std::fmt::Debug for NoDatabaseMigrationPreference {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NoDatabaseMigrationPreference");
        formatter.field("target_database_engine", &self.target_database_engine);
        formatter.finish()
    }
}
/// See [`NoDatabaseMigrationPreference`](crate::model::NoDatabaseMigrationPreference)
pub mod no_database_migration_preference {
    /// A builder for [`NoDatabaseMigrationPreference`](crate::model::NoDatabaseMigrationPreference)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_database_engine:
            std::option::Option<std::vec::Vec<crate::model::TargetDatabaseEngine>>,
    }
    impl Builder {
        /// Appends an item to `target_database_engine`.
        ///
        /// To override the contents of this collection use [`set_target_database_engine`](Self::set_target_database_engine).
        ///
        /// <p>
        /// The target database engine for database migration preference that you specify.
        /// </p>
        pub fn target_database_engine(
            mut self,
            input: impl Into<crate::model::TargetDatabaseEngine>,
        ) -> Self {
            let mut v = self.target_database_engine.unwrap_or_default();
            v.push(input.into());
            self.target_database_engine = Some(v);
            self
        }
        /// <p>
        /// The target database engine for database migration preference that you specify.
        /// </p>
        pub fn set_target_database_engine(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TargetDatabaseEngine>>,
        ) -> Self {
            self.target_database_engine = input;
            self
        }
        /// Consumes the builder and constructs a [`NoDatabaseMigrationPreference`](crate::model::NoDatabaseMigrationPreference)
        pub fn build(self) -> crate::model::NoDatabaseMigrationPreference {
            crate::model::NoDatabaseMigrationPreference {
                target_database_engine: self.target_database_engine,
            }
        }
    }
}
impl NoDatabaseMigrationPreference {
    /// Creates a new builder-style object to manufacture [`NoDatabaseMigrationPreference`](crate::model::NoDatabaseMigrationPreference)
    pub fn builder() -> crate::model::no_database_migration_preference::Builder {
        crate::model::no_database_migration_preference::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TargetDatabaseEngine {
    #[allow(missing_docs)] // documentation missing in model
    AwsPostgresql,
    #[allow(missing_docs)] // documentation missing in model
    AmazonAurora,
    #[allow(missing_docs)] // documentation missing in model
    Db2Luw,
    #[allow(missing_docs)] // documentation missing in model
    MariaDb,
    #[allow(missing_docs)] // documentation missing in model
    MicrosoftSqlServer,
    #[allow(missing_docs)] // documentation missing in model
    MongoDb,
    #[allow(missing_docs)] // documentation missing in model
    Mysql,
    #[allow(missing_docs)] // documentation missing in model
    NoneSpecified,
    #[allow(missing_docs)] // documentation missing in model
    OracleDatabase,
    #[allow(missing_docs)] // documentation missing in model
    Sap,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TargetDatabaseEngine {
    fn from(s: &str) -> Self {
        match s {
            "AWS PostgreSQL" => TargetDatabaseEngine::AwsPostgresql,
            "Amazon Aurora" => TargetDatabaseEngine::AmazonAurora,
            "Db2 LUW" => TargetDatabaseEngine::Db2Luw,
            "MariaDB" => TargetDatabaseEngine::MariaDb,
            "Microsoft SQL Server" => TargetDatabaseEngine::MicrosoftSqlServer,
            "MongoDB" => TargetDatabaseEngine::MongoDb,
            "MySQL" => TargetDatabaseEngine::Mysql,
            "None specified" => TargetDatabaseEngine::NoneSpecified,
            "Oracle Database" => TargetDatabaseEngine::OracleDatabase,
            "SAP" => TargetDatabaseEngine::Sap,
            other => TargetDatabaseEngine::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TargetDatabaseEngine {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TargetDatabaseEngine::from(s))
    }
}
impl TargetDatabaseEngine {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TargetDatabaseEngine::AwsPostgresql => "AWS PostgreSQL",
            TargetDatabaseEngine::AmazonAurora => "Amazon Aurora",
            TargetDatabaseEngine::Db2Luw => "Db2 LUW",
            TargetDatabaseEngine::MariaDb => "MariaDB",
            TargetDatabaseEngine::MicrosoftSqlServer => "Microsoft SQL Server",
            TargetDatabaseEngine::MongoDb => "MongoDB",
            TargetDatabaseEngine::Mysql => "MySQL",
            TargetDatabaseEngine::NoneSpecified => "None specified",
            TargetDatabaseEngine::OracleDatabase => "Oracle Database",
            TargetDatabaseEngine::Sap => "SAP",
            TargetDatabaseEngine::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AWS PostgreSQL",
            "Amazon Aurora",
            "Db2 LUW",
            "MariaDB",
            "Microsoft SQL Server",
            "MongoDB",
            "MySQL",
            "None specified",
            "Oracle Database",
            "SAP",
        ]
    }
}
impl AsRef<str> for TargetDatabaseEngine {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>
/// The object containing details about homogeneous database preferences.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Homogeneous {
    /// <p>
    /// The target database engine for homogeneous database migration preferences.
    /// </p>
    pub target_database_engine:
        std::option::Option<std::vec::Vec<crate::model::HomogeneousTargetDatabaseEngine>>,
}
impl Homogeneous {
    /// <p>
    /// The target database engine for homogeneous database migration preferences.
    /// </p>
    pub fn target_database_engine(
        &self,
    ) -> std::option::Option<&[crate::model::HomogeneousTargetDatabaseEngine]> {
        self.target_database_engine.as_deref()
    }
}
impl std::fmt::Debug for Homogeneous {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Homogeneous");
        formatter.field("target_database_engine", &self.target_database_engine);
        formatter.finish()
    }
}
/// See [`Homogeneous`](crate::model::Homogeneous)
pub mod homogeneous {
    /// A builder for [`Homogeneous`](crate::model::Homogeneous)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_database_engine:
            std::option::Option<std::vec::Vec<crate::model::HomogeneousTargetDatabaseEngine>>,
    }
    impl Builder {
        /// Appends an item to `target_database_engine`.
        ///
        /// To override the contents of this collection use [`set_target_database_engine`](Self::set_target_database_engine).
        ///
        /// <p>
        /// The target database engine for homogeneous database migration preferences.
        /// </p>
        pub fn target_database_engine(
            mut self,
            input: impl Into<crate::model::HomogeneousTargetDatabaseEngine>,
        ) -> Self {
            let mut v = self.target_database_engine.unwrap_or_default();
            v.push(input.into());
            self.target_database_engine = Some(v);
            self
        }
        /// <p>
        /// The target database engine for homogeneous database migration preferences.
        /// </p>
        pub fn set_target_database_engine(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::HomogeneousTargetDatabaseEngine>,
            >,
        ) -> Self {
            self.target_database_engine = input;
            self
        }
        /// Consumes the builder and constructs a [`Homogeneous`](crate::model::Homogeneous)
        pub fn build(self) -> crate::model::Homogeneous {
            crate::model::Homogeneous {
                target_database_engine: self.target_database_engine,
            }
        }
    }
}
impl Homogeneous {
    /// Creates a new builder-style object to manufacture [`Homogeneous`](crate::model::Homogeneous)
    pub fn builder() -> crate::model::homogeneous::Builder {
        crate::model::homogeneous::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum HomogeneousTargetDatabaseEngine {
    #[allow(missing_docs)] // documentation missing in model
    NoneSpecified,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for HomogeneousTargetDatabaseEngine {
    fn from(s: &str) -> Self {
        match s {
            "None specified" => HomogeneousTargetDatabaseEngine::NoneSpecified,
            other => HomogeneousTargetDatabaseEngine::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for HomogeneousTargetDatabaseEngine {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(HomogeneousTargetDatabaseEngine::from(s))
    }
}
impl HomogeneousTargetDatabaseEngine {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            HomogeneousTargetDatabaseEngine::NoneSpecified => "None specified",
            HomogeneousTargetDatabaseEngine::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["None specified"]
    }
}
impl AsRef<str> for HomogeneousTargetDatabaseEngine {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>
/// The object containing details about heterogeneous database preferences.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Heterogeneous {
    /// <p>
    /// The target database engine for heterogeneous database migration preference.
    /// </p>
    pub target_database_engine:
        std::option::Option<std::vec::Vec<crate::model::HeterogeneousTargetDatabaseEngine>>,
}
impl Heterogeneous {
    /// <p>
    /// The target database engine for heterogeneous database migration preference.
    /// </p>
    pub fn target_database_engine(
        &self,
    ) -> std::option::Option<&[crate::model::HeterogeneousTargetDatabaseEngine]> {
        self.target_database_engine.as_deref()
    }
}
impl std::fmt::Debug for Heterogeneous {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Heterogeneous");
        formatter.field("target_database_engine", &self.target_database_engine);
        formatter.finish()
    }
}
/// See [`Heterogeneous`](crate::model::Heterogeneous)
pub mod heterogeneous {
    /// A builder for [`Heterogeneous`](crate::model::Heterogeneous)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_database_engine:
            std::option::Option<std::vec::Vec<crate::model::HeterogeneousTargetDatabaseEngine>>,
    }
    impl Builder {
        /// Appends an item to `target_database_engine`.
        ///
        /// To override the contents of this collection use [`set_target_database_engine`](Self::set_target_database_engine).
        ///
        /// <p>
        /// The target database engine for heterogeneous database migration preference.
        /// </p>
        pub fn target_database_engine(
            mut self,
            input: impl Into<crate::model::HeterogeneousTargetDatabaseEngine>,
        ) -> Self {
            let mut v = self.target_database_engine.unwrap_or_default();
            v.push(input.into());
            self.target_database_engine = Some(v);
            self
        }
        /// <p>
        /// The target database engine for heterogeneous database migration preference.
        /// </p>
        pub fn set_target_database_engine(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::HeterogeneousTargetDatabaseEngine>,
            >,
        ) -> Self {
            self.target_database_engine = input;
            self
        }
        /// Consumes the builder and constructs a [`Heterogeneous`](crate::model::Heterogeneous)
        pub fn build(self) -> crate::model::Heterogeneous {
            crate::model::Heterogeneous {
                target_database_engine: self.target_database_engine,
            }
        }
    }
}
impl Heterogeneous {
    /// Creates a new builder-style object to manufacture [`Heterogeneous`](crate::model::Heterogeneous)
    pub fn builder() -> crate::model::heterogeneous::Builder {
        crate::model::heterogeneous::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum HeterogeneousTargetDatabaseEngine {
    #[allow(missing_docs)] // documentation missing in model
    AwsPostgresql,
    #[allow(missing_docs)] // documentation missing in model
    AmazonAurora,
    #[allow(missing_docs)] // documentation missing in model
    Db2Luw,
    #[allow(missing_docs)] // documentation missing in model
    MariaDb,
    #[allow(missing_docs)] // documentation missing in model
    MicrosoftSqlServer,
    #[allow(missing_docs)] // documentation missing in model
    MongoDb,
    #[allow(missing_docs)] // documentation missing in model
    Mysql,
    #[allow(missing_docs)] // documentation missing in model
    NoneSpecified,
    #[allow(missing_docs)] // documentation missing in model
    OracleDatabase,
    #[allow(missing_docs)] // documentation missing in model
    Sap,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for HeterogeneousTargetDatabaseEngine {
    fn from(s: &str) -> Self {
        match s {
            "AWS PostgreSQL" => HeterogeneousTargetDatabaseEngine::AwsPostgresql,
            "Amazon Aurora" => HeterogeneousTargetDatabaseEngine::AmazonAurora,
            "Db2 LUW" => HeterogeneousTargetDatabaseEngine::Db2Luw,
            "MariaDB" => HeterogeneousTargetDatabaseEngine::MariaDb,
            "Microsoft SQL Server" => HeterogeneousTargetDatabaseEngine::MicrosoftSqlServer,
            "MongoDB" => HeterogeneousTargetDatabaseEngine::MongoDb,
            "MySQL" => HeterogeneousTargetDatabaseEngine::Mysql,
            "None specified" => HeterogeneousTargetDatabaseEngine::NoneSpecified,
            "Oracle Database" => HeterogeneousTargetDatabaseEngine::OracleDatabase,
            "SAP" => HeterogeneousTargetDatabaseEngine::Sap,
            other => HeterogeneousTargetDatabaseEngine::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for HeterogeneousTargetDatabaseEngine {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(HeterogeneousTargetDatabaseEngine::from(s))
    }
}
impl HeterogeneousTargetDatabaseEngine {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            HeterogeneousTargetDatabaseEngine::AwsPostgresql => "AWS PostgreSQL",
            HeterogeneousTargetDatabaseEngine::AmazonAurora => "Amazon Aurora",
            HeterogeneousTargetDatabaseEngine::Db2Luw => "Db2 LUW",
            HeterogeneousTargetDatabaseEngine::MariaDb => "MariaDB",
            HeterogeneousTargetDatabaseEngine::MicrosoftSqlServer => "Microsoft SQL Server",
            HeterogeneousTargetDatabaseEngine::MongoDb => "MongoDB",
            HeterogeneousTargetDatabaseEngine::Mysql => "MySQL",
            HeterogeneousTargetDatabaseEngine::NoneSpecified => "None specified",
            HeterogeneousTargetDatabaseEngine::OracleDatabase => "Oracle Database",
            HeterogeneousTargetDatabaseEngine::Sap => "SAP",
            HeterogeneousTargetDatabaseEngine::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AWS PostgreSQL",
            "Amazon Aurora",
            "Db2 LUW",
            "MariaDB",
            "Microsoft SQL Server",
            "MongoDB",
            "MySQL",
            "None specified",
            "Oracle Database",
            "SAP",
        ]
    }
}
impl AsRef<str> for HeterogeneousTargetDatabaseEngine {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DatabaseManagementPreference {
    #[allow(missing_docs)] // documentation missing in model
    AwsManaged,
    #[allow(missing_docs)] // documentation missing in model
    NoPreference,
    #[allow(missing_docs)] // documentation missing in model
    SelfManage,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DatabaseManagementPreference {
    fn from(s: &str) -> Self {
        match s {
            "AWS-managed" => DatabaseManagementPreference::AwsManaged,
            "No preference" => DatabaseManagementPreference::NoPreference,
            "Self-manage" => DatabaseManagementPreference::SelfManage,
            other => DatabaseManagementPreference::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DatabaseManagementPreference {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DatabaseManagementPreference::from(s))
    }
}
impl DatabaseManagementPreference {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DatabaseManagementPreference::AwsManaged => "AWS-managed",
            DatabaseManagementPreference::NoPreference => "No preference",
            DatabaseManagementPreference::SelfManage => "Self-manage",
            DatabaseManagementPreference::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AWS-managed", "No preference", "Self-manage"]
    }
}
impl AsRef<str> for DatabaseManagementPreference {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>
/// Application preferences that you specify.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApplicationPreferences {
    /// <p>
    /// Application preferences that you specify to prefer managed environment.
    /// </p>
    pub management_preference: std::option::Option<crate::model::ManagementPreference>,
}
impl ApplicationPreferences {
    /// <p>
    /// Application preferences that you specify to prefer managed environment.
    /// </p>
    pub fn management_preference(
        &self,
    ) -> std::option::Option<&crate::model::ManagementPreference> {
        self.management_preference.as_ref()
    }
}
impl std::fmt::Debug for ApplicationPreferences {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApplicationPreferences");
        formatter.field("management_preference", &self.management_preference);
        formatter.finish()
    }
}
/// See [`ApplicationPreferences`](crate::model::ApplicationPreferences)
pub mod application_preferences {
    /// A builder for [`ApplicationPreferences`](crate::model::ApplicationPreferences)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) management_preference: std::option::Option<crate::model::ManagementPreference>,
    }
    impl Builder {
        /// <p>
        /// Application preferences that you specify to prefer managed environment.
        /// </p>
        pub fn management_preference(mut self, input: crate::model::ManagementPreference) -> Self {
            self.management_preference = Some(input);
            self
        }
        /// <p>
        /// Application preferences that you specify to prefer managed environment.
        /// </p>
        pub fn set_management_preference(
            mut self,
            input: std::option::Option<crate::model::ManagementPreference>,
        ) -> Self {
            self.management_preference = input;
            self
        }
        /// Consumes the builder and constructs a [`ApplicationPreferences`](crate::model::ApplicationPreferences)
        pub fn build(self) -> crate::model::ApplicationPreferences {
            crate::model::ApplicationPreferences {
                management_preference: self.management_preference,
            }
        }
    }
}
impl ApplicationPreferences {
    /// Creates a new builder-style object to manufacture [`ApplicationPreferences`](crate::model::ApplicationPreferences)
    pub fn builder() -> crate::model::application_preferences::Builder {
        crate::model::application_preferences::Builder::default()
    }
}

/// <p>
/// Preferences for migrating an application to AWS.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum ManagementPreference {
    /// <p>
    /// Indicates interest in solutions that are managed by AWS.
    /// </p>
    AwsManagedResources(crate::model::AwsManagedResources),
    /// <p>
    /// No specific preference.
    /// </p>
    NoPreference(crate::model::NoManagementPreference),
    /// <p>
    /// Indicates interest in managing your own resources on AWS.
    /// </p>
    SelfManageResources(crate::model::SelfManageResources),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl ManagementPreference {
    /// Tries to convert the enum instance into [`AwsManagedResources`](crate::model::ManagementPreference::AwsManagedResources), extracting the inner [`AwsManagedResources`](crate::model::AwsManagedResources).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_aws_managed_resources(
        &self,
    ) -> std::result::Result<&crate::model::AwsManagedResources, &Self> {
        if let ManagementPreference::AwsManagedResources(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`AwsManagedResources`](crate::model::ManagementPreference::AwsManagedResources).
    pub fn is_aws_managed_resources(&self) -> bool {
        self.as_aws_managed_resources().is_ok()
    }
    /// Tries to convert the enum instance into [`NoPreference`](crate::model::ManagementPreference::NoPreference), extracting the inner [`NoManagementPreference`](crate::model::NoManagementPreference).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_no_preference(
        &self,
    ) -> std::result::Result<&crate::model::NoManagementPreference, &Self> {
        if let ManagementPreference::NoPreference(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`NoPreference`](crate::model::ManagementPreference::NoPreference).
    pub fn is_no_preference(&self) -> bool {
        self.as_no_preference().is_ok()
    }
    /// Tries to convert the enum instance into [`SelfManageResources`](crate::model::ManagementPreference::SelfManageResources), extracting the inner [`SelfManageResources`](crate::model::SelfManageResources).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_self_manage_resources(
        &self,
    ) -> std::result::Result<&crate::model::SelfManageResources, &Self> {
        if let ManagementPreference::SelfManageResources(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`SelfManageResources`](crate::model::ManagementPreference::SelfManageResources).
    pub fn is_self_manage_resources(&self) -> bool {
        self.as_self_manage_resources().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

/// <p>
/// Object containing the choice of application destination that you specify.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NoManagementPreference {
    /// <p>
    /// The choice of application destination that you specify.
    /// </p>
    pub target_destination:
        std::option::Option<std::vec::Vec<crate::model::NoPreferenceTargetDestination>>,
}
impl NoManagementPreference {
    /// <p>
    /// The choice of application destination that you specify.
    /// </p>
    pub fn target_destination(
        &self,
    ) -> std::option::Option<&[crate::model::NoPreferenceTargetDestination]> {
        self.target_destination.as_deref()
    }
}
impl std::fmt::Debug for NoManagementPreference {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NoManagementPreference");
        formatter.field("target_destination", &self.target_destination);
        formatter.finish()
    }
}
/// See [`NoManagementPreference`](crate::model::NoManagementPreference)
pub mod no_management_preference {
    /// A builder for [`NoManagementPreference`](crate::model::NoManagementPreference)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_destination:
            std::option::Option<std::vec::Vec<crate::model::NoPreferenceTargetDestination>>,
    }
    impl Builder {
        /// Appends an item to `target_destination`.
        ///
        /// To override the contents of this collection use [`set_target_destination`](Self::set_target_destination).
        ///
        /// <p>
        /// The choice of application destination that you specify.
        /// </p>
        pub fn target_destination(
            mut self,
            input: impl Into<crate::model::NoPreferenceTargetDestination>,
        ) -> Self {
            let mut v = self.target_destination.unwrap_or_default();
            v.push(input.into());
            self.target_destination = Some(v);
            self
        }
        /// <p>
        /// The choice of application destination that you specify.
        /// </p>
        pub fn set_target_destination(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NoPreferenceTargetDestination>>,
        ) -> Self {
            self.target_destination = input;
            self
        }
        /// Consumes the builder and constructs a [`NoManagementPreference`](crate::model::NoManagementPreference)
        pub fn build(self) -> crate::model::NoManagementPreference {
            crate::model::NoManagementPreference {
                target_destination: self.target_destination,
            }
        }
    }
}
impl NoManagementPreference {
    /// Creates a new builder-style object to manufacture [`NoManagementPreference`](crate::model::NoManagementPreference)
    pub fn builder() -> crate::model::no_management_preference::Builder {
        crate::model::no_management_preference::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum NoPreferenceTargetDestination {
    #[allow(missing_docs)] // documentation missing in model
    AwsElasticBeanstalk,
    #[allow(missing_docs)] // documentation missing in model
    AwsFargate,
    #[allow(missing_docs)] // documentation missing in model
    AmazonElasticCloudCompute,
    #[allow(missing_docs)] // documentation missing in model
    AmazonElasticContainerService,
    #[allow(missing_docs)] // documentation missing in model
    AmazonElasticKubernetesService,
    #[allow(missing_docs)] // documentation missing in model
    NoneSpecified,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for NoPreferenceTargetDestination {
    fn from(s: &str) -> Self {
        match s {
            "AWS Elastic BeanStalk" => NoPreferenceTargetDestination::AwsElasticBeanstalk,
            "AWS Fargate" => NoPreferenceTargetDestination::AwsFargate,
            "Amazon Elastic Cloud Compute (EC2)" => {
                NoPreferenceTargetDestination::AmazonElasticCloudCompute
            }
            "Amazon Elastic Container Service (ECS)" => {
                NoPreferenceTargetDestination::AmazonElasticContainerService
            }
            "Amazon Elastic Kubernetes Service (EKS)" => {
                NoPreferenceTargetDestination::AmazonElasticKubernetesService
            }
            "None specified" => NoPreferenceTargetDestination::NoneSpecified,
            other => NoPreferenceTargetDestination::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for NoPreferenceTargetDestination {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(NoPreferenceTargetDestination::from(s))
    }
}
impl NoPreferenceTargetDestination {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            NoPreferenceTargetDestination::AwsElasticBeanstalk => "AWS Elastic BeanStalk",
            NoPreferenceTargetDestination::AwsFargate => "AWS Fargate",
            NoPreferenceTargetDestination::AmazonElasticCloudCompute => {
                "Amazon Elastic Cloud Compute (EC2)"
            }
            NoPreferenceTargetDestination::AmazonElasticContainerService => {
                "Amazon Elastic Container Service (ECS)"
            }
            NoPreferenceTargetDestination::AmazonElasticKubernetesService => {
                "Amazon Elastic Kubernetes Service (EKS)"
            }
            NoPreferenceTargetDestination::NoneSpecified => "None specified",
            NoPreferenceTargetDestination::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AWS Elastic BeanStalk",
            "AWS Fargate",
            "Amazon Elastic Cloud Compute (EC2)",
            "Amazon Elastic Container Service (ECS)",
            "Amazon Elastic Kubernetes Service (EKS)",
            "None specified",
        ]
    }
}
impl AsRef<str> for NoPreferenceTargetDestination {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> Self-managed resources. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SelfManageResources {
    /// <p> Self-managed resources target destination. </p>
    pub target_destination:
        std::option::Option<std::vec::Vec<crate::model::SelfManageTargetDestination>>,
}
impl SelfManageResources {
    /// <p> Self-managed resources target destination. </p>
    pub fn target_destination(
        &self,
    ) -> std::option::Option<&[crate::model::SelfManageTargetDestination]> {
        self.target_destination.as_deref()
    }
}
impl std::fmt::Debug for SelfManageResources {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SelfManageResources");
        formatter.field("target_destination", &self.target_destination);
        formatter.finish()
    }
}
/// See [`SelfManageResources`](crate::model::SelfManageResources)
pub mod self_manage_resources {
    /// A builder for [`SelfManageResources`](crate::model::SelfManageResources)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_destination:
            std::option::Option<std::vec::Vec<crate::model::SelfManageTargetDestination>>,
    }
    impl Builder {
        /// Appends an item to `target_destination`.
        ///
        /// To override the contents of this collection use [`set_target_destination`](Self::set_target_destination).
        ///
        /// <p> Self-managed resources target destination. </p>
        pub fn target_destination(
            mut self,
            input: impl Into<crate::model::SelfManageTargetDestination>,
        ) -> Self {
            let mut v = self.target_destination.unwrap_or_default();
            v.push(input.into());
            self.target_destination = Some(v);
            self
        }
        /// <p> Self-managed resources target destination. </p>
        pub fn set_target_destination(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SelfManageTargetDestination>>,
        ) -> Self {
            self.target_destination = input;
            self
        }
        /// Consumes the builder and constructs a [`SelfManageResources`](crate::model::SelfManageResources)
        pub fn build(self) -> crate::model::SelfManageResources {
            crate::model::SelfManageResources {
                target_destination: self.target_destination,
            }
        }
    }
}
impl SelfManageResources {
    /// Creates a new builder-style object to manufacture [`SelfManageResources`](crate::model::SelfManageResources)
    pub fn builder() -> crate::model::self_manage_resources::Builder {
        crate::model::self_manage_resources::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SelfManageTargetDestination {
    #[allow(missing_docs)] // documentation missing in model
    AmazonElasticCloudCompute,
    #[allow(missing_docs)] // documentation missing in model
    AmazonElasticContainerService,
    #[allow(missing_docs)] // documentation missing in model
    AmazonElasticKubernetesService,
    #[allow(missing_docs)] // documentation missing in model
    NoneSpecified,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SelfManageTargetDestination {
    fn from(s: &str) -> Self {
        match s {
            "Amazon Elastic Cloud Compute (EC2)" => {
                SelfManageTargetDestination::AmazonElasticCloudCompute
            }
            "Amazon Elastic Container Service (ECS)" => {
                SelfManageTargetDestination::AmazonElasticContainerService
            }
            "Amazon Elastic Kubernetes Service (EKS)" => {
                SelfManageTargetDestination::AmazonElasticKubernetesService
            }
            "None specified" => SelfManageTargetDestination::NoneSpecified,
            other => SelfManageTargetDestination::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SelfManageTargetDestination {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SelfManageTargetDestination::from(s))
    }
}
impl SelfManageTargetDestination {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SelfManageTargetDestination::AmazonElasticCloudCompute => {
                "Amazon Elastic Cloud Compute (EC2)"
            }
            SelfManageTargetDestination::AmazonElasticContainerService => {
                "Amazon Elastic Container Service (ECS)"
            }
            SelfManageTargetDestination::AmazonElasticKubernetesService => {
                "Amazon Elastic Kubernetes Service (EKS)"
            }
            SelfManageTargetDestination::NoneSpecified => "None specified",
            SelfManageTargetDestination::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Amazon Elastic Cloud Compute (EC2)",
            "Amazon Elastic Container Service (ECS)",
            "Amazon Elastic Kubernetes Service (EKS)",
            "None specified",
        ]
    }
}
impl AsRef<str> for SelfManageTargetDestination {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>
/// Object containing the choice of application destination that you specify.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsManagedResources {
    /// <p>
    /// The choice of application destination that you specify.
    /// </p>
    pub target_destination:
        std::option::Option<std::vec::Vec<crate::model::AwsManagedTargetDestination>>,
}
impl AwsManagedResources {
    /// <p>
    /// The choice of application destination that you specify.
    /// </p>
    pub fn target_destination(
        &self,
    ) -> std::option::Option<&[crate::model::AwsManagedTargetDestination]> {
        self.target_destination.as_deref()
    }
}
impl std::fmt::Debug for AwsManagedResources {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsManagedResources");
        formatter.field("target_destination", &self.target_destination);
        formatter.finish()
    }
}
/// See [`AwsManagedResources`](crate::model::AwsManagedResources)
pub mod aws_managed_resources {
    /// A builder for [`AwsManagedResources`](crate::model::AwsManagedResources)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_destination:
            std::option::Option<std::vec::Vec<crate::model::AwsManagedTargetDestination>>,
    }
    impl Builder {
        /// Appends an item to `target_destination`.
        ///
        /// To override the contents of this collection use [`set_target_destination`](Self::set_target_destination).
        ///
        /// <p>
        /// The choice of application destination that you specify.
        /// </p>
        pub fn target_destination(
            mut self,
            input: impl Into<crate::model::AwsManagedTargetDestination>,
        ) -> Self {
            let mut v = self.target_destination.unwrap_or_default();
            v.push(input.into());
            self.target_destination = Some(v);
            self
        }
        /// <p>
        /// The choice of application destination that you specify.
        /// </p>
        pub fn set_target_destination(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AwsManagedTargetDestination>>,
        ) -> Self {
            self.target_destination = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsManagedResources`](crate::model::AwsManagedResources)
        pub fn build(self) -> crate::model::AwsManagedResources {
            crate::model::AwsManagedResources {
                target_destination: self.target_destination,
            }
        }
    }
}
impl AwsManagedResources {
    /// Creates a new builder-style object to manufacture [`AwsManagedResources`](crate::model::AwsManagedResources)
    pub fn builder() -> crate::model::aws_managed_resources::Builder {
        crate::model::aws_managed_resources::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AwsManagedTargetDestination {
    #[allow(missing_docs)] // documentation missing in model
    AwsElasticBeanstalk,
    #[allow(missing_docs)] // documentation missing in model
    AwsFargate,
    #[allow(missing_docs)] // documentation missing in model
    NoneSpecified,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AwsManagedTargetDestination {
    fn from(s: &str) -> Self {
        match s {
            "AWS Elastic BeanStalk" => AwsManagedTargetDestination::AwsElasticBeanstalk,
            "AWS Fargate" => AwsManagedTargetDestination::AwsFargate,
            "None specified" => AwsManagedTargetDestination::NoneSpecified,
            other => AwsManagedTargetDestination::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AwsManagedTargetDestination {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AwsManagedTargetDestination::from(s))
    }
}
impl AwsManagedTargetDestination {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AwsManagedTargetDestination::AwsElasticBeanstalk => "AWS Elastic BeanStalk",
            AwsManagedTargetDestination::AwsFargate => "AWS Fargate",
            AwsManagedTargetDestination::NoneSpecified => "None specified",
            AwsManagedTargetDestination::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AWS Elastic BeanStalk", "AWS Fargate", "None specified"]
    }
}
impl AsRef<str> for AwsManagedTargetDestination {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>
/// Rank of business goals based on priority.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PrioritizeBusinessGoals {
    /// <p>
    /// Rank of business goals based on priority.
    /// </p>
    pub business_goals: std::option::Option<crate::model::BusinessGoals>,
}
impl PrioritizeBusinessGoals {
    /// <p>
    /// Rank of business goals based on priority.
    /// </p>
    pub fn business_goals(&self) -> std::option::Option<&crate::model::BusinessGoals> {
        self.business_goals.as_ref()
    }
}
impl std::fmt::Debug for PrioritizeBusinessGoals {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PrioritizeBusinessGoals");
        formatter.field("business_goals", &self.business_goals);
        formatter.finish()
    }
}
/// See [`PrioritizeBusinessGoals`](crate::model::PrioritizeBusinessGoals)
pub mod prioritize_business_goals {
    /// A builder for [`PrioritizeBusinessGoals`](crate::model::PrioritizeBusinessGoals)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) business_goals: std::option::Option<crate::model::BusinessGoals>,
    }
    impl Builder {
        /// <p>
        /// Rank of business goals based on priority.
        /// </p>
        pub fn business_goals(mut self, input: crate::model::BusinessGoals) -> Self {
            self.business_goals = Some(input);
            self
        }
        /// <p>
        /// Rank of business goals based on priority.
        /// </p>
        pub fn set_business_goals(
            mut self,
            input: std::option::Option<crate::model::BusinessGoals>,
        ) -> Self {
            self.business_goals = input;
            self
        }
        /// Consumes the builder and constructs a [`PrioritizeBusinessGoals`](crate::model::PrioritizeBusinessGoals)
        pub fn build(self) -> crate::model::PrioritizeBusinessGoals {
            crate::model::PrioritizeBusinessGoals {
                business_goals: self.business_goals,
            }
        }
    }
}
impl PrioritizeBusinessGoals {
    /// Creates a new builder-style object to manufacture [`PrioritizeBusinessGoals`](crate::model::PrioritizeBusinessGoals)
    pub fn builder() -> crate::model::prioritize_business_goals::Builder {
        crate::model::prioritize_business_goals::Builder::default()
    }
}

/// <p>
/// Business goals that you specify.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BusinessGoals {
    /// <p>
    /// Business goal to achieve migration at a fast pace.
    /// </p>
    pub speed_of_migration: std::option::Option<i32>,
    /// <p>
    /// Business goal to reduce the operational overhead on the team by moving into managed services.
    /// </p>
    pub reduce_operational_overhead_with_managed_services: std::option::Option<i32>,
    /// <p>
    /// Business goal to modernize infrastructure by moving to cloud native technologies.
    /// </p>
    pub modernize_infrastructure_with_cloud_native_technologies: std::option::Option<i32>,
    /// <p>
    /// Business goal to reduce license costs.
    /// </p>
    pub license_cost_reduction: std::option::Option<i32>,
}
impl BusinessGoals {
    /// <p>
    /// Business goal to achieve migration at a fast pace.
    /// </p>
    pub fn speed_of_migration(&self) -> std::option::Option<i32> {
        self.speed_of_migration
    }
    /// <p>
    /// Business goal to reduce the operational overhead on the team by moving into managed services.
    /// </p>
    pub fn reduce_operational_overhead_with_managed_services(&self) -> std::option::Option<i32> {
        self.reduce_operational_overhead_with_managed_services
    }
    /// <p>
    /// Business goal to modernize infrastructure by moving to cloud native technologies.
    /// </p>
    pub fn modernize_infrastructure_with_cloud_native_technologies(
        &self,
    ) -> std::option::Option<i32> {
        self.modernize_infrastructure_with_cloud_native_technologies
    }
    /// <p>
    /// Business goal to reduce license costs.
    /// </p>
    pub fn license_cost_reduction(&self) -> std::option::Option<i32> {
        self.license_cost_reduction
    }
}
impl std::fmt::Debug for BusinessGoals {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BusinessGoals");
        formatter.field("speed_of_migration", &self.speed_of_migration);
        formatter.field(
            "reduce_operational_overhead_with_managed_services",
            &self.reduce_operational_overhead_with_managed_services,
        );
        formatter.field(
            "modernize_infrastructure_with_cloud_native_technologies",
            &self.modernize_infrastructure_with_cloud_native_technologies,
        );
        formatter.field("license_cost_reduction", &self.license_cost_reduction);
        formatter.finish()
    }
}
/// See [`BusinessGoals`](crate::model::BusinessGoals)
pub mod business_goals {
    /// A builder for [`BusinessGoals`](crate::model::BusinessGoals)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) speed_of_migration: std::option::Option<i32>,
        pub(crate) reduce_operational_overhead_with_managed_services: std::option::Option<i32>,
        pub(crate) modernize_infrastructure_with_cloud_native_technologies:
            std::option::Option<i32>,
        pub(crate) license_cost_reduction: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>
        /// Business goal to achieve migration at a fast pace.
        /// </p>
        pub fn speed_of_migration(mut self, input: i32) -> Self {
            self.speed_of_migration = Some(input);
            self
        }
        /// <p>
        /// Business goal to achieve migration at a fast pace.
        /// </p>
        pub fn set_speed_of_migration(mut self, input: std::option::Option<i32>) -> Self {
            self.speed_of_migration = input;
            self
        }
        /// <p>
        /// Business goal to reduce the operational overhead on the team by moving into managed services.
        /// </p>
        pub fn reduce_operational_overhead_with_managed_services(mut self, input: i32) -> Self {
            self.reduce_operational_overhead_with_managed_services = Some(input);
            self
        }
        /// <p>
        /// Business goal to reduce the operational overhead on the team by moving into managed services.
        /// </p>
        pub fn set_reduce_operational_overhead_with_managed_services(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.reduce_operational_overhead_with_managed_services = input;
            self
        }
        /// <p>
        /// Business goal to modernize infrastructure by moving to cloud native technologies.
        /// </p>
        pub fn modernize_infrastructure_with_cloud_native_technologies(
            mut self,
            input: i32,
        ) -> Self {
            self.modernize_infrastructure_with_cloud_native_technologies = Some(input);
            self
        }
        /// <p>
        /// Business goal to modernize infrastructure by moving to cloud native technologies.
        /// </p>
        pub fn set_modernize_infrastructure_with_cloud_native_technologies(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.modernize_infrastructure_with_cloud_native_technologies = input;
            self
        }
        /// <p>
        /// Business goal to reduce license costs.
        /// </p>
        pub fn license_cost_reduction(mut self, input: i32) -> Self {
            self.license_cost_reduction = Some(input);
            self
        }
        /// <p>
        /// Business goal to reduce license costs.
        /// </p>
        pub fn set_license_cost_reduction(mut self, input: std::option::Option<i32>) -> Self {
            self.license_cost_reduction = input;
            self
        }
        /// Consumes the builder and constructs a [`BusinessGoals`](crate::model::BusinessGoals)
        pub fn build(self) -> crate::model::BusinessGoals {
            crate::model::BusinessGoals {
                speed_of_migration: self.speed_of_migration,
                reduce_operational_overhead_with_managed_services: self
                    .reduce_operational_overhead_with_managed_services,
                modernize_infrastructure_with_cloud_native_technologies: self
                    .modernize_infrastructure_with_cloud_native_technologies,
                license_cost_reduction: self.license_cost_reduction,
            }
        }
    }
}
impl BusinessGoals {
    /// Creates a new builder-style object to manufacture [`BusinessGoals`](crate::model::BusinessGoals)
    pub fn builder() -> crate::model::business_goals::Builder {
        crate::model::business_goals::Builder::default()
    }
}

/// <p> Detailed information about a server. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServerDetail {
    /// <p> The server ID. </p>
    pub id: std::option::Option<std::string::String>,
    /// <p> The name of the server. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p> A set of recommendations. </p>
    pub recommendation_set: std::option::Option<crate::model::RecommendationSet>,
    /// <p> The status of assessment for the server. </p>
    pub data_collection_status: std::option::Option<crate::model::RunTimeAssessmentStatus>,
    /// <p> A message about the status of data collection, which contains detailed descriptions of
    /// any error messages. </p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p> A list of anti-pattern severity summaries. </p>
    pub list_antipattern_severity_summary:
        std::option::Option<std::vec::Vec<crate::model::AntipatternSeveritySummary>>,
    /// <p> System information about the server. </p>
    pub system_info: std::option::Option<crate::model::SystemInfo>,
    /// <p> A list of strategy summaries. </p>
    pub application_component_strategy_summary:
        std::option::Option<std::vec::Vec<crate::model::StrategySummary>>,
    /// <p> The S3 bucket name and Amazon S3 key name for anti-pattern report. </p>
    pub antipattern_report_s3_object: std::option::Option<crate::model::S3Object>,
    /// <p> The status of the anti-pattern report generation. </p>
    pub antipattern_report_status: std::option::Option<crate::model::AntipatternReportStatus>,
    /// <p> A message about the status of the anti-pattern report generation. </p>
    pub antipattern_report_status_message: std::option::Option<std::string::String>,
    /// <p> The type of server. </p>
    pub server_type: std::option::Option<std::string::String>,
    /// <p> The timestamp of when the server was assessed. </p>
    pub last_analyzed_timestamp: std::option::Option<aws_smithy_types::DateTime>,
}
impl ServerDetail {
    /// <p> The server ID. </p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p> The name of the server. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p> A set of recommendations. </p>
    pub fn recommendation_set(&self) -> std::option::Option<&crate::model::RecommendationSet> {
        self.recommendation_set.as_ref()
    }
    /// <p> The status of assessment for the server. </p>
    pub fn data_collection_status(
        &self,
    ) -> std::option::Option<&crate::model::RunTimeAssessmentStatus> {
        self.data_collection_status.as_ref()
    }
    /// <p> A message about the status of data collection, which contains detailed descriptions of
    /// any error messages. </p>
    pub fn status_message(&self) -> std::option::Option<&str> {
        self.status_message.as_deref()
    }
    /// <p> A list of anti-pattern severity summaries. </p>
    pub fn list_antipattern_severity_summary(
        &self,
    ) -> std::option::Option<&[crate::model::AntipatternSeveritySummary]> {
        self.list_antipattern_severity_summary.as_deref()
    }
    /// <p> System information about the server. </p>
    pub fn system_info(&self) -> std::option::Option<&crate::model::SystemInfo> {
        self.system_info.as_ref()
    }
    /// <p> A list of strategy summaries. </p>
    pub fn application_component_strategy_summary(
        &self,
    ) -> std::option::Option<&[crate::model::StrategySummary]> {
        self.application_component_strategy_summary.as_deref()
    }
    /// <p> The S3 bucket name and Amazon S3 key name for anti-pattern report. </p>
    pub fn antipattern_report_s3_object(&self) -> std::option::Option<&crate::model::S3Object> {
        self.antipattern_report_s3_object.as_ref()
    }
    /// <p> The status of the anti-pattern report generation. </p>
    pub fn antipattern_report_status(
        &self,
    ) -> std::option::Option<&crate::model::AntipatternReportStatus> {
        self.antipattern_report_status.as_ref()
    }
    /// <p> A message about the status of the anti-pattern report generation. </p>
    pub fn antipattern_report_status_message(&self) -> std::option::Option<&str> {
        self.antipattern_report_status_message.as_deref()
    }
    /// <p> The type of server. </p>
    pub fn server_type(&self) -> std::option::Option<&str> {
        self.server_type.as_deref()
    }
    /// <p> The timestamp of when the server was assessed. </p>
    pub fn last_analyzed_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_analyzed_timestamp.as_ref()
    }
}
impl std::fmt::Debug for ServerDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServerDetail");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("recommendation_set", &self.recommendation_set);
        formatter.field("data_collection_status", &self.data_collection_status);
        formatter.field("status_message", &self.status_message);
        formatter.field(
            "list_antipattern_severity_summary",
            &self.list_antipattern_severity_summary,
        );
        formatter.field("system_info", &self.system_info);
        formatter.field(
            "application_component_strategy_summary",
            &self.application_component_strategy_summary,
        );
        formatter.field(
            "antipattern_report_s3_object",
            &self.antipattern_report_s3_object,
        );
        formatter.field("antipattern_report_status", &self.antipattern_report_status);
        formatter.field(
            "antipattern_report_status_message",
            &self.antipattern_report_status_message,
        );
        formatter.field("server_type", &self.server_type);
        formatter.field("last_analyzed_timestamp", &self.last_analyzed_timestamp);
        formatter.finish()
    }
}
/// See [`ServerDetail`](crate::model::ServerDetail)
pub mod server_detail {
    /// A builder for [`ServerDetail`](crate::model::ServerDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) recommendation_set: std::option::Option<crate::model::RecommendationSet>,
        pub(crate) data_collection_status:
            std::option::Option<crate::model::RunTimeAssessmentStatus>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) list_antipattern_severity_summary:
            std::option::Option<std::vec::Vec<crate::model::AntipatternSeveritySummary>>,
        pub(crate) system_info: std::option::Option<crate::model::SystemInfo>,
        pub(crate) application_component_strategy_summary:
            std::option::Option<std::vec::Vec<crate::model::StrategySummary>>,
        pub(crate) antipattern_report_s3_object: std::option::Option<crate::model::S3Object>,
        pub(crate) antipattern_report_status:
            std::option::Option<crate::model::AntipatternReportStatus>,
        pub(crate) antipattern_report_status_message: std::option::Option<std::string::String>,
        pub(crate) server_type: std::option::Option<std::string::String>,
        pub(crate) last_analyzed_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p> The server ID. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p> The server ID. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p> The name of the server. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> The name of the server. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p> A set of recommendations. </p>
        pub fn recommendation_set(mut self, input: crate::model::RecommendationSet) -> Self {
            self.recommendation_set = Some(input);
            self
        }
        /// <p> A set of recommendations. </p>
        pub fn set_recommendation_set(
            mut self,
            input: std::option::Option<crate::model::RecommendationSet>,
        ) -> Self {
            self.recommendation_set = input;
            self
        }
        /// <p> The status of assessment for the server. </p>
        pub fn data_collection_status(
            mut self,
            input: crate::model::RunTimeAssessmentStatus,
        ) -> Self {
            self.data_collection_status = Some(input);
            self
        }
        /// <p> The status of assessment for the server. </p>
        pub fn set_data_collection_status(
            mut self,
            input: std::option::Option<crate::model::RunTimeAssessmentStatus>,
        ) -> Self {
            self.data_collection_status = input;
            self
        }
        /// <p> A message about the status of data collection, which contains detailed descriptions of
        /// any error messages. </p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p> A message about the status of data collection, which contains detailed descriptions of
        /// any error messages. </p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// Appends an item to `list_antipattern_severity_summary`.
        ///
        /// To override the contents of this collection use [`set_list_antipattern_severity_summary`](Self::set_list_antipattern_severity_summary).
        ///
        /// <p> A list of anti-pattern severity summaries. </p>
        pub fn list_antipattern_severity_summary(
            mut self,
            input: impl Into<crate::model::AntipatternSeveritySummary>,
        ) -> Self {
            let mut v = self.list_antipattern_severity_summary.unwrap_or_default();
            v.push(input.into());
            self.list_antipattern_severity_summary = Some(v);
            self
        }
        /// <p> A list of anti-pattern severity summaries. </p>
        pub fn set_list_antipattern_severity_summary(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AntipatternSeveritySummary>>,
        ) -> Self {
            self.list_antipattern_severity_summary = input;
            self
        }
        /// <p> System information about the server. </p>
        pub fn system_info(mut self, input: crate::model::SystemInfo) -> Self {
            self.system_info = Some(input);
            self
        }
        /// <p> System information about the server. </p>
        pub fn set_system_info(
            mut self,
            input: std::option::Option<crate::model::SystemInfo>,
        ) -> Self {
            self.system_info = input;
            self
        }
        /// Appends an item to `application_component_strategy_summary`.
        ///
        /// To override the contents of this collection use [`set_application_component_strategy_summary`](Self::set_application_component_strategy_summary).
        ///
        /// <p> A list of strategy summaries. </p>
        pub fn application_component_strategy_summary(
            mut self,
            input: impl Into<crate::model::StrategySummary>,
        ) -> Self {
            let mut v = self
                .application_component_strategy_summary
                .unwrap_or_default();
            v.push(input.into());
            self.application_component_strategy_summary = Some(v);
            self
        }
        /// <p> A list of strategy summaries. </p>
        pub fn set_application_component_strategy_summary(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StrategySummary>>,
        ) -> Self {
            self.application_component_strategy_summary = input;
            self
        }
        /// <p> The S3 bucket name and Amazon S3 key name for anti-pattern report. </p>
        pub fn antipattern_report_s3_object(mut self, input: crate::model::S3Object) -> Self {
            self.antipattern_report_s3_object = Some(input);
            self
        }
        /// <p> The S3 bucket name and Amazon S3 key name for anti-pattern report. </p>
        pub fn set_antipattern_report_s3_object(
            mut self,
            input: std::option::Option<crate::model::S3Object>,
        ) -> Self {
            self.antipattern_report_s3_object = input;
            self
        }
        /// <p> The status of the anti-pattern report generation. </p>
        pub fn antipattern_report_status(
            mut self,
            input: crate::model::AntipatternReportStatus,
        ) -> Self {
            self.antipattern_report_status = Some(input);
            self
        }
        /// <p> The status of the anti-pattern report generation. </p>
        pub fn set_antipattern_report_status(
            mut self,
            input: std::option::Option<crate::model::AntipatternReportStatus>,
        ) -> Self {
            self.antipattern_report_status = input;
            self
        }
        /// <p> A message about the status of the anti-pattern report generation. </p>
        pub fn antipattern_report_status_message(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.antipattern_report_status_message = Some(input.into());
            self
        }
        /// <p> A message about the status of the anti-pattern report generation. </p>
        pub fn set_antipattern_report_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.antipattern_report_status_message = input;
            self
        }
        /// <p> The type of server. </p>
        pub fn server_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_type = Some(input.into());
            self
        }
        /// <p> The type of server. </p>
        pub fn set_server_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.server_type = input;
            self
        }
        /// <p> The timestamp of when the server was assessed. </p>
        pub fn last_analyzed_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_analyzed_timestamp = Some(input);
            self
        }
        /// <p> The timestamp of when the server was assessed. </p>
        pub fn set_last_analyzed_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_analyzed_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`ServerDetail`](crate::model::ServerDetail)
        pub fn build(self) -> crate::model::ServerDetail {
            crate::model::ServerDetail {
                id: self.id,
                name: self.name,
                recommendation_set: self.recommendation_set,
                data_collection_status: self.data_collection_status,
                status_message: self.status_message,
                list_antipattern_severity_summary: self.list_antipattern_severity_summary,
                system_info: self.system_info,
                application_component_strategy_summary: self.application_component_strategy_summary,
                antipattern_report_s3_object: self.antipattern_report_s3_object,
                antipattern_report_status: self.antipattern_report_status,
                antipattern_report_status_message: self.antipattern_report_status_message,
                server_type: self.server_type,
                last_analyzed_timestamp: self.last_analyzed_timestamp,
            }
        }
    }
}
impl ServerDetail {
    /// Creates a new builder-style object to manufacture [`ServerDetail`](crate::model::ServerDetail)
    pub fn builder() -> crate::model::server_detail::Builder {
        crate::model::server_detail::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AntipatternReportStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Success,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AntipatternReportStatus {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => AntipatternReportStatus::Failed,
            "IN_PROGRESS" => AntipatternReportStatus::InProgress,
            "SUCCESS" => AntipatternReportStatus::Success,
            other => AntipatternReportStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AntipatternReportStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AntipatternReportStatus::from(s))
    }
}
impl AntipatternReportStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AntipatternReportStatus::Failed => "FAILED",
            AntipatternReportStatus::InProgress => "IN_PROGRESS",
            AntipatternReportStatus::Success => "SUCCESS",
            AntipatternReportStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAILED", "IN_PROGRESS", "SUCCESS"]
    }
}
impl AsRef<str> for AntipatternReportStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> Contains the S3 bucket name and the Amazon S3 key name. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3Object {
    /// <p> The S3 bucket name. </p>
    pub s3_bucket: std::option::Option<std::string::String>,
    /// <p> The Amazon S3 key name. </p>
    pub s3key: std::option::Option<std::string::String>,
}
impl S3Object {
    /// <p> The S3 bucket name. </p>
    pub fn s3_bucket(&self) -> std::option::Option<&str> {
        self.s3_bucket.as_deref()
    }
    /// <p> The Amazon S3 key name. </p>
    pub fn s3key(&self) -> std::option::Option<&str> {
        self.s3key.as_deref()
    }
}
impl std::fmt::Debug for S3Object {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3Object");
        formatter.field("s3_bucket", &self.s3_bucket);
        formatter.field("s3key", &self.s3key);
        formatter.finish()
    }
}
/// See [`S3Object`](crate::model::S3Object)
pub mod s3_object {
    /// A builder for [`S3Object`](crate::model::S3Object)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_bucket: std::option::Option<std::string::String>,
        pub(crate) s3key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The S3 bucket name. </p>
        pub fn s3_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket = Some(input.into());
            self
        }
        /// <p> The S3 bucket name. </p>
        pub fn set_s3_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_bucket = input;
            self
        }
        /// <p> The Amazon S3 key name. </p>
        pub fn s3key(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3key = Some(input.into());
            self
        }
        /// <p> The Amazon S3 key name. </p>
        pub fn set_s3key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3key = input;
            self
        }
        /// Consumes the builder and constructs a [`S3Object`](crate::model::S3Object)
        pub fn build(self) -> crate::model::S3Object {
            crate::model::S3Object {
                s3_bucket: self.s3_bucket,
                s3key: self.s3key,
            }
        }
    }
}
impl S3Object {
    /// Creates a new builder-style object to manufacture [`S3Object`](crate::model::S3Object)
    pub fn builder() -> crate::model::s3_object::Builder {
        crate::model::s3_object::Builder::default()
    }
}

/// <p>
/// Object containing the summary of the strategy recommendations.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StrategySummary {
    /// <p>
    /// The name of recommended strategy.
    /// </p>
    pub strategy: std::option::Option<crate::model::Strategy>,
    /// <p>
    /// The count of recommendations per strategy.
    /// </p>
    pub count: std::option::Option<i32>,
}
impl StrategySummary {
    /// <p>
    /// The name of recommended strategy.
    /// </p>
    pub fn strategy(&self) -> std::option::Option<&crate::model::Strategy> {
        self.strategy.as_ref()
    }
    /// <p>
    /// The count of recommendations per strategy.
    /// </p>
    pub fn count(&self) -> std::option::Option<i32> {
        self.count
    }
}
impl std::fmt::Debug for StrategySummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StrategySummary");
        formatter.field("strategy", &self.strategy);
        formatter.field("count", &self.count);
        formatter.finish()
    }
}
/// See [`StrategySummary`](crate::model::StrategySummary)
pub mod strategy_summary {
    /// A builder for [`StrategySummary`](crate::model::StrategySummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) strategy: std::option::Option<crate::model::Strategy>,
        pub(crate) count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>
        /// The name of recommended strategy.
        /// </p>
        pub fn strategy(mut self, input: crate::model::Strategy) -> Self {
            self.strategy = Some(input);
            self
        }
        /// <p>
        /// The name of recommended strategy.
        /// </p>
        pub fn set_strategy(mut self, input: std::option::Option<crate::model::Strategy>) -> Self {
            self.strategy = input;
            self
        }
        /// <p>
        /// The count of recommendations per strategy.
        /// </p>
        pub fn count(mut self, input: i32) -> Self {
            self.count = Some(input);
            self
        }
        /// <p>
        /// The count of recommendations per strategy.
        /// </p>
        pub fn set_count(mut self, input: std::option::Option<i32>) -> Self {
            self.count = input;
            self
        }
        /// Consumes the builder and constructs a [`StrategySummary`](crate::model::StrategySummary)
        pub fn build(self) -> crate::model::StrategySummary {
            crate::model::StrategySummary {
                strategy: self.strategy,
                count: self.count,
            }
        }
    }
}
impl StrategySummary {
    /// Creates a new builder-style object to manufacture [`StrategySummary`](crate::model::StrategySummary)
    pub fn builder() -> crate::model::strategy_summary::Builder {
        crate::model::strategy_summary::Builder::default()
    }
}

/// <p>
/// Information about the server that hosts application components.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SystemInfo {
    /// <p>
    /// Operating system corresponding to a server.
    /// </p>
    pub os_info: std::option::Option<crate::model::OsInfo>,
    /// <p>
    /// File system type for the server.
    /// </p>
    pub file_system_type: std::option::Option<std::string::String>,
    /// <p>
    /// Networking information related to a server.
    /// </p>
    pub network_info_list: std::option::Option<std::vec::Vec<crate::model::NetworkInfo>>,
    /// <p>
    /// CPU architecture type for the server.
    /// </p>
    pub cpu_architecture: std::option::Option<std::string::String>,
}
impl SystemInfo {
    /// <p>
    /// Operating system corresponding to a server.
    /// </p>
    pub fn os_info(&self) -> std::option::Option<&crate::model::OsInfo> {
        self.os_info.as_ref()
    }
    /// <p>
    /// File system type for the server.
    /// </p>
    pub fn file_system_type(&self) -> std::option::Option<&str> {
        self.file_system_type.as_deref()
    }
    /// <p>
    /// Networking information related to a server.
    /// </p>
    pub fn network_info_list(&self) -> std::option::Option<&[crate::model::NetworkInfo]> {
        self.network_info_list.as_deref()
    }
    /// <p>
    /// CPU architecture type for the server.
    /// </p>
    pub fn cpu_architecture(&self) -> std::option::Option<&str> {
        self.cpu_architecture.as_deref()
    }
}
impl std::fmt::Debug for SystemInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SystemInfo");
        formatter.field("os_info", &self.os_info);
        formatter.field("file_system_type", &self.file_system_type);
        formatter.field("network_info_list", &self.network_info_list);
        formatter.field("cpu_architecture", &self.cpu_architecture);
        formatter.finish()
    }
}
/// See [`SystemInfo`](crate::model::SystemInfo)
pub mod system_info {
    /// A builder for [`SystemInfo`](crate::model::SystemInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) os_info: std::option::Option<crate::model::OsInfo>,
        pub(crate) file_system_type: std::option::Option<std::string::String>,
        pub(crate) network_info_list: std::option::Option<std::vec::Vec<crate::model::NetworkInfo>>,
        pub(crate) cpu_architecture: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// Operating system corresponding to a server.
        /// </p>
        pub fn os_info(mut self, input: crate::model::OsInfo) -> Self {
            self.os_info = Some(input);
            self
        }
        /// <p>
        /// Operating system corresponding to a server.
        /// </p>
        pub fn set_os_info(mut self, input: std::option::Option<crate::model::OsInfo>) -> Self {
            self.os_info = input;
            self
        }
        /// <p>
        /// File system type for the server.
        /// </p>
        pub fn file_system_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_system_type = Some(input.into());
            self
        }
        /// <p>
        /// File system type for the server.
        /// </p>
        pub fn set_file_system_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_type = input;
            self
        }
        /// Appends an item to `network_info_list`.
        ///
        /// To override the contents of this collection use [`set_network_info_list`](Self::set_network_info_list).
        ///
        /// <p>
        /// Networking information related to a server.
        /// </p>
        pub fn network_info_list(mut self, input: impl Into<crate::model::NetworkInfo>) -> Self {
            let mut v = self.network_info_list.unwrap_or_default();
            v.push(input.into());
            self.network_info_list = Some(v);
            self
        }
        /// <p>
        /// Networking information related to a server.
        /// </p>
        pub fn set_network_info_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NetworkInfo>>,
        ) -> Self {
            self.network_info_list = input;
            self
        }
        /// <p>
        /// CPU architecture type for the server.
        /// </p>
        pub fn cpu_architecture(mut self, input: impl Into<std::string::String>) -> Self {
            self.cpu_architecture = Some(input.into());
            self
        }
        /// <p>
        /// CPU architecture type for the server.
        /// </p>
        pub fn set_cpu_architecture(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cpu_architecture = input;
            self
        }
        /// Consumes the builder and constructs a [`SystemInfo`](crate::model::SystemInfo)
        pub fn build(self) -> crate::model::SystemInfo {
            crate::model::SystemInfo {
                os_info: self.os_info,
                file_system_type: self.file_system_type,
                network_info_list: self.network_info_list,
                cpu_architecture: self.cpu_architecture,
            }
        }
    }
}
impl SystemInfo {
    /// Creates a new builder-style object to manufacture [`SystemInfo`](crate::model::SystemInfo)
    pub fn builder() -> crate::model::system_info::Builder {
        crate::model::system_info::Builder::default()
    }
}

/// <p>
/// Information about the server's network for which the assessment was run.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NetworkInfo {
    /// <p>
    /// Information about the name of the interface of the server for which the assessment was run.
    /// </p>
    pub interface_name: std::option::Option<std::string::String>,
    /// <p>
    /// Information about the IP address of the server for which the assessment was run.
    /// </p>
    pub ip_address: std::option::Option<std::string::String>,
    /// <p>
    /// Information about the MAC address of the server for which the assessment was run.
    /// </p>
    pub mac_address: std::option::Option<std::string::String>,
    /// <p>
    /// Information about the subnet mask of the server for which the assessment was run.
    /// </p>
    pub net_mask: std::option::Option<std::string::String>,
}
impl NetworkInfo {
    /// <p>
    /// Information about the name of the interface of the server for which the assessment was run.
    /// </p>
    pub fn interface_name(&self) -> std::option::Option<&str> {
        self.interface_name.as_deref()
    }
    /// <p>
    /// Information about the IP address of the server for which the assessment was run.
    /// </p>
    pub fn ip_address(&self) -> std::option::Option<&str> {
        self.ip_address.as_deref()
    }
    /// <p>
    /// Information about the MAC address of the server for which the assessment was run.
    /// </p>
    pub fn mac_address(&self) -> std::option::Option<&str> {
        self.mac_address.as_deref()
    }
    /// <p>
    /// Information about the subnet mask of the server for which the assessment was run.
    /// </p>
    pub fn net_mask(&self) -> std::option::Option<&str> {
        self.net_mask.as_deref()
    }
}
impl std::fmt::Debug for NetworkInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NetworkInfo");
        formatter.field("interface_name", &self.interface_name);
        formatter.field("ip_address", &self.ip_address);
        formatter.field("mac_address", &self.mac_address);
        formatter.field("net_mask", &self.net_mask);
        formatter.finish()
    }
}
/// See [`NetworkInfo`](crate::model::NetworkInfo)
pub mod network_info {
    /// A builder for [`NetworkInfo`](crate::model::NetworkInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) interface_name: std::option::Option<std::string::String>,
        pub(crate) ip_address: std::option::Option<std::string::String>,
        pub(crate) mac_address: std::option::Option<std::string::String>,
        pub(crate) net_mask: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// Information about the name of the interface of the server for which the assessment was run.
        /// </p>
        pub fn interface_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.interface_name = Some(input.into());
            self
        }
        /// <p>
        /// Information about the name of the interface of the server for which the assessment was run.
        /// </p>
        pub fn set_interface_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.interface_name = input;
            self
        }
        /// <p>
        /// Information about the IP address of the server for which the assessment was run.
        /// </p>
        pub fn ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip_address = Some(input.into());
            self
        }
        /// <p>
        /// Information about the IP address of the server for which the assessment was run.
        /// </p>
        pub fn set_ip_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ip_address = input;
            self
        }
        /// <p>
        /// Information about the MAC address of the server for which the assessment was run.
        /// </p>
        pub fn mac_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.mac_address = Some(input.into());
            self
        }
        /// <p>
        /// Information about the MAC address of the server for which the assessment was run.
        /// </p>
        pub fn set_mac_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mac_address = input;
            self
        }
        /// <p>
        /// Information about the subnet mask of the server for which the assessment was run.
        /// </p>
        pub fn net_mask(mut self, input: impl Into<std::string::String>) -> Self {
            self.net_mask = Some(input.into());
            self
        }
        /// <p>
        /// Information about the subnet mask of the server for which the assessment was run.
        /// </p>
        pub fn set_net_mask(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.net_mask = input;
            self
        }
        /// Consumes the builder and constructs a [`NetworkInfo`](crate::model::NetworkInfo)
        pub fn build(self) -> crate::model::NetworkInfo {
            crate::model::NetworkInfo {
                interface_name: self.interface_name,
                ip_address: self.ip_address,
                mac_address: self.mac_address,
                net_mask: self.net_mask,
            }
        }
    }
}
impl NetworkInfo {
    /// Creates a new builder-style object to manufacture [`NetworkInfo`](crate::model::NetworkInfo)
    pub fn builder() -> crate::model::network_info::Builder {
        crate::model::network_info::Builder::default()
    }
}

/// <p>
/// Information about the operating system.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OsInfo {
    /// <p>
    /// Information about the type of operating system.
    /// </p>
    pub r#type: std::option::Option<crate::model::OsType>,
    /// <p>
    /// Information about the version of operating system.
    /// </p>
    pub version: std::option::Option<std::string::String>,
}
impl OsInfo {
    /// <p>
    /// Information about the type of operating system.
    /// </p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::OsType> {
        self.r#type.as_ref()
    }
    /// <p>
    /// Information about the version of operating system.
    /// </p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
}
impl std::fmt::Debug for OsInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OsInfo");
        formatter.field("r#type", &self.r#type);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}
/// See [`OsInfo`](crate::model::OsInfo)
pub mod os_info {
    /// A builder for [`OsInfo`](crate::model::OsInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::OsType>,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// Information about the type of operating system.
        /// </p>
        pub fn r#type(mut self, input: crate::model::OsType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>
        /// Information about the type of operating system.
        /// </p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::OsType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>
        /// Information about the version of operating system.
        /// </p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>
        /// Information about the version of operating system.
        /// </p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`OsInfo`](crate::model::OsInfo)
        pub fn build(self) -> crate::model::OsInfo {
            crate::model::OsInfo {
                r#type: self.r#type,
                version: self.version,
            }
        }
    }
}
impl OsInfo {
    /// Creates a new builder-style object to manufacture [`OsInfo`](crate::model::OsInfo)
    pub fn builder() -> crate::model::os_info::Builder {
        crate::model::os_info::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OsType {
    #[allow(missing_docs)] // documentation missing in model
    Linux,
    #[allow(missing_docs)] // documentation missing in model
    Windows,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OsType {
    fn from(s: &str) -> Self {
        match s {
            "LINUX" => OsType::Linux,
            "WINDOWS" => OsType::Windows,
            other => OsType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OsType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OsType::from(s))
    }
}
impl OsType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OsType::Linux => "LINUX",
            OsType::Windows => "WINDOWS",
            OsType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["LINUX", "WINDOWS"]
    }
}
impl AsRef<str> for OsType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>
/// Contains the summary of anti-patterns and their severity.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AntipatternSeveritySummary {
    /// <p>
    /// Contains the severity of anti-patterns.
    /// </p>
    pub severity: std::option::Option<crate::model::Severity>,
    /// <p>
    /// Contains the count of anti-patterns.
    /// </p>
    pub count: std::option::Option<i32>,
}
impl AntipatternSeveritySummary {
    /// <p>
    /// Contains the severity of anti-patterns.
    /// </p>
    pub fn severity(&self) -> std::option::Option<&crate::model::Severity> {
        self.severity.as_ref()
    }
    /// <p>
    /// Contains the count of anti-patterns.
    /// </p>
    pub fn count(&self) -> std::option::Option<i32> {
        self.count
    }
}
impl std::fmt::Debug for AntipatternSeveritySummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AntipatternSeveritySummary");
        formatter.field("severity", &self.severity);
        formatter.field("count", &self.count);
        formatter.finish()
    }
}
/// See [`AntipatternSeveritySummary`](crate::model::AntipatternSeveritySummary)
pub mod antipattern_severity_summary {
    /// A builder for [`AntipatternSeveritySummary`](crate::model::AntipatternSeveritySummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) severity: std::option::Option<crate::model::Severity>,
        pub(crate) count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>
        /// Contains the severity of anti-patterns.
        /// </p>
        pub fn severity(mut self, input: crate::model::Severity) -> Self {
            self.severity = Some(input);
            self
        }
        /// <p>
        /// Contains the severity of anti-patterns.
        /// </p>
        pub fn set_severity(mut self, input: std::option::Option<crate::model::Severity>) -> Self {
            self.severity = input;
            self
        }
        /// <p>
        /// Contains the count of anti-patterns.
        /// </p>
        pub fn count(mut self, input: i32) -> Self {
            self.count = Some(input);
            self
        }
        /// <p>
        /// Contains the count of anti-patterns.
        /// </p>
        pub fn set_count(mut self, input: std::option::Option<i32>) -> Self {
            self.count = input;
            self
        }
        /// Consumes the builder and constructs a [`AntipatternSeveritySummary`](crate::model::AntipatternSeveritySummary)
        pub fn build(self) -> crate::model::AntipatternSeveritySummary {
            crate::model::AntipatternSeveritySummary {
                severity: self.severity,
                count: self.count,
            }
        }
    }
}
impl AntipatternSeveritySummary {
    /// Creates a new builder-style object to manufacture [`AntipatternSeveritySummary`](crate::model::AntipatternSeveritySummary)
    pub fn builder() -> crate::model::antipattern_severity_summary::Builder {
        crate::model::antipattern_severity_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Severity {
    #[allow(missing_docs)] // documentation missing in model
    High,
    #[allow(missing_docs)] // documentation missing in model
    Low,
    #[allow(missing_docs)] // documentation missing in model
    Medium,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Severity {
    fn from(s: &str) -> Self {
        match s {
            "HIGH" => Severity::High,
            "LOW" => Severity::Low,
            "MEDIUM" => Severity::Medium,
            other => Severity::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Severity {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Severity::from(s))
    }
}
impl Severity {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Severity::High => "HIGH",
            Severity::Low => "LOW",
            Severity::Medium => "MEDIUM",
            Severity::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HIGH", "LOW", "MEDIUM"]
    }
}
impl AsRef<str> for Severity {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RunTimeAssessmentStatus {
    #[allow(missing_docs)] // documentation missing in model
    DcFailed,
    #[allow(missing_docs)] // documentation missing in model
    DcPartialSuccess,
    #[allow(missing_docs)] // documentation missing in model
    DcReqSent,
    #[allow(missing_docs)] // documentation missing in model
    DcStarted,
    #[allow(missing_docs)] // documentation missing in model
    DcStopped,
    #[allow(missing_docs)] // documentation missing in model
    DcSuccess,
    #[allow(missing_docs)] // documentation missing in model
    DcToBeScheduled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RunTimeAssessmentStatus {
    fn from(s: &str) -> Self {
        match s {
            "dataCollectionTaskFailed" => RunTimeAssessmentStatus::DcFailed,
            "dataCollectionTaskPartialSuccess" => RunTimeAssessmentStatus::DcPartialSuccess,
            "dataCollectionTaskScheduled" => RunTimeAssessmentStatus::DcReqSent,
            "dataCollectionTaskStarted" => RunTimeAssessmentStatus::DcStarted,
            "dataCollectionTaskStopped" => RunTimeAssessmentStatus::DcStopped,
            "dataCollectionTaskSuccess" => RunTimeAssessmentStatus::DcSuccess,
            "dataCollectionTaskToBeScheduled" => RunTimeAssessmentStatus::DcToBeScheduled,
            other => RunTimeAssessmentStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RunTimeAssessmentStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RunTimeAssessmentStatus::from(s))
    }
}
impl RunTimeAssessmentStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RunTimeAssessmentStatus::DcFailed => "dataCollectionTaskFailed",
            RunTimeAssessmentStatus::DcPartialSuccess => "dataCollectionTaskPartialSuccess",
            RunTimeAssessmentStatus::DcReqSent => "dataCollectionTaskScheduled",
            RunTimeAssessmentStatus::DcStarted => "dataCollectionTaskStarted",
            RunTimeAssessmentStatus::DcStopped => "dataCollectionTaskStopped",
            RunTimeAssessmentStatus::DcSuccess => "dataCollectionTaskSuccess",
            RunTimeAssessmentStatus::DcToBeScheduled => "dataCollectionTaskToBeScheduled",
            RunTimeAssessmentStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "dataCollectionTaskFailed",
            "dataCollectionTaskPartialSuccess",
            "dataCollectionTaskScheduled",
            "dataCollectionTaskStarted",
            "dataCollectionTaskStopped",
            "dataCollectionTaskSuccess",
            "dataCollectionTaskToBeScheduled",
        ]
    }
}
impl AsRef<str> for RunTimeAssessmentStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>
/// Contains a recommendation set.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecommendationSet {
    /// <p>
    /// The target destination for the recommendation set.
    /// </p>
    pub transformation_tool: std::option::Option<crate::model::TransformationTool>,
    /// <p>
    /// The recommended target destination.
    /// </p>
    pub target_destination: std::option::Option<crate::model::TargetDestination>,
    /// <p>
    /// The recommended strategy.
    /// </p>
    pub strategy: std::option::Option<crate::model::Strategy>,
}
impl RecommendationSet {
    /// <p>
    /// The target destination for the recommendation set.
    /// </p>
    pub fn transformation_tool(&self) -> std::option::Option<&crate::model::TransformationTool> {
        self.transformation_tool.as_ref()
    }
    /// <p>
    /// The recommended target destination.
    /// </p>
    pub fn target_destination(&self) -> std::option::Option<&crate::model::TargetDestination> {
        self.target_destination.as_ref()
    }
    /// <p>
    /// The recommended strategy.
    /// </p>
    pub fn strategy(&self) -> std::option::Option<&crate::model::Strategy> {
        self.strategy.as_ref()
    }
}
impl std::fmt::Debug for RecommendationSet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecommendationSet");
        formatter.field("transformation_tool", &self.transformation_tool);
        formatter.field("target_destination", &self.target_destination);
        formatter.field("strategy", &self.strategy);
        formatter.finish()
    }
}
/// See [`RecommendationSet`](crate::model::RecommendationSet)
pub mod recommendation_set {
    /// A builder for [`RecommendationSet`](crate::model::RecommendationSet)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) transformation_tool: std::option::Option<crate::model::TransformationTool>,
        pub(crate) target_destination: std::option::Option<crate::model::TargetDestination>,
        pub(crate) strategy: std::option::Option<crate::model::Strategy>,
    }
    impl Builder {
        /// <p>
        /// The target destination for the recommendation set.
        /// </p>
        pub fn transformation_tool(mut self, input: crate::model::TransformationTool) -> Self {
            self.transformation_tool = Some(input);
            self
        }
        /// <p>
        /// The target destination for the recommendation set.
        /// </p>
        pub fn set_transformation_tool(
            mut self,
            input: std::option::Option<crate::model::TransformationTool>,
        ) -> Self {
            self.transformation_tool = input;
            self
        }
        /// <p>
        /// The recommended target destination.
        /// </p>
        pub fn target_destination(mut self, input: crate::model::TargetDestination) -> Self {
            self.target_destination = Some(input);
            self
        }
        /// <p>
        /// The recommended target destination.
        /// </p>
        pub fn set_target_destination(
            mut self,
            input: std::option::Option<crate::model::TargetDestination>,
        ) -> Self {
            self.target_destination = input;
            self
        }
        /// <p>
        /// The recommended strategy.
        /// </p>
        pub fn strategy(mut self, input: crate::model::Strategy) -> Self {
            self.strategy = Some(input);
            self
        }
        /// <p>
        /// The recommended strategy.
        /// </p>
        pub fn set_strategy(mut self, input: std::option::Option<crate::model::Strategy>) -> Self {
            self.strategy = input;
            self
        }
        /// Consumes the builder and constructs a [`RecommendationSet`](crate::model::RecommendationSet)
        pub fn build(self) -> crate::model::RecommendationSet {
            crate::model::RecommendationSet {
                transformation_tool: self.transformation_tool,
                target_destination: self.target_destination,
                strategy: self.strategy,
            }
        }
    }
}
impl RecommendationSet {
    /// Creates a new builder-style object to manufacture [`RecommendationSet`](crate::model::RecommendationSet)
    pub fn builder() -> crate::model::recommendation_set::Builder {
        crate::model::recommendation_set::Builder::default()
    }
}

/// <p>
/// Information of the transformation tool that can be used to migrate and modernize the application.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TransformationTool {
    /// <p>
    /// Name of the tool.
    /// </p>
    pub name: std::option::Option<crate::model::TransformationToolName>,
    /// <p>
    /// Description of the tool.
    /// </p>
    pub description: std::option::Option<std::string::String>,
    /// <p>
    /// URL for installing the tool.
    /// </p>
    pub tranformation_tool_installation_link: std::option::Option<std::string::String>,
}
impl TransformationTool {
    /// <p>
    /// Name of the tool.
    /// </p>
    pub fn name(&self) -> std::option::Option<&crate::model::TransformationToolName> {
        self.name.as_ref()
    }
    /// <p>
    /// Description of the tool.
    /// </p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>
    /// URL for installing the tool.
    /// </p>
    pub fn tranformation_tool_installation_link(&self) -> std::option::Option<&str> {
        self.tranformation_tool_installation_link.as_deref()
    }
}
impl std::fmt::Debug for TransformationTool {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TransformationTool");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field(
            "tranformation_tool_installation_link",
            &self.tranformation_tool_installation_link,
        );
        formatter.finish()
    }
}
/// See [`TransformationTool`](crate::model::TransformationTool)
pub mod transformation_tool {
    /// A builder for [`TransformationTool`](crate::model::TransformationTool)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::TransformationToolName>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) tranformation_tool_installation_link: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// Name of the tool.
        /// </p>
        pub fn name(mut self, input: crate::model::TransformationToolName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>
        /// Name of the tool.
        /// </p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::TransformationToolName>,
        ) -> Self {
            self.name = input;
            self
        }
        /// <p>
        /// Description of the tool.
        /// </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>
        /// Description of the tool.
        /// </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>
        /// URL for installing the tool.
        /// </p>
        pub fn tranformation_tool_installation_link(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.tranformation_tool_installation_link = Some(input.into());
            self
        }
        /// <p>
        /// URL for installing the tool.
        /// </p>
        pub fn set_tranformation_tool_installation_link(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.tranformation_tool_installation_link = input;
            self
        }
        /// Consumes the builder and constructs a [`TransformationTool`](crate::model::TransformationTool)
        pub fn build(self) -> crate::model::TransformationTool {
            crate::model::TransformationTool {
                name: self.name,
                description: self.description,
                tranformation_tool_installation_link: self.tranformation_tool_installation_link,
            }
        }
    }
}
impl TransformationTool {
    /// Creates a new builder-style object to manufacture [`TransformationTool`](crate::model::TransformationTool)
    pub fn builder() -> crate::model::transformation_tool::Builder {
        crate::model::transformation_tool::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SortOrder {
    #[allow(missing_docs)] // documentation missing in model
    Asc,
    #[allow(missing_docs)] // documentation missing in model
    Desc,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SortOrder {
    fn from(s: &str) -> Self {
        match s {
            "ASC" => SortOrder::Asc,
            "DESC" => SortOrder::Desc,
            other => SortOrder::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SortOrder {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SortOrder::from(s))
    }
}
impl SortOrder {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SortOrder::Asc => "ASC",
            SortOrder::Desc => "DESC",
            SortOrder::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ASC", "DESC"]
    }
}
impl AsRef<str> for SortOrder {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ServerCriteria {
    #[allow(missing_docs)] // documentation missing in model
    Destination,
    #[allow(missing_docs)] // documentation missing in model
    NotDefined,
    #[allow(missing_docs)] // documentation missing in model
    OsName,
    #[allow(missing_docs)] // documentation missing in model
    ServerId,
    #[allow(missing_docs)] // documentation missing in model
    Strategy,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ServerCriteria {
    fn from(s: &str) -> Self {
        match s {
            "DESTINATION" => ServerCriteria::Destination,
            "NOT_DEFINED" => ServerCriteria::NotDefined,
            "OS_NAME" => ServerCriteria::OsName,
            "SERVER_ID" => ServerCriteria::ServerId,
            "STRATEGY" => ServerCriteria::Strategy,
            other => ServerCriteria::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ServerCriteria {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ServerCriteria::from(s))
    }
}
impl ServerCriteria {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ServerCriteria::Destination => "DESTINATION",
            ServerCriteria::NotDefined => "NOT_DEFINED",
            ServerCriteria::OsName => "OS_NAME",
            ServerCriteria::ServerId => "SERVER_ID",
            ServerCriteria::Strategy => "STRATEGY",
            ServerCriteria::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DESTINATION",
            "NOT_DEFINED",
            "OS_NAME",
            "SERVER_ID",
            "STRATEGY",
        ]
    }
}
impl AsRef<str> for ServerCriteria {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> Information about the import file tasks you request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImportFileTaskInformation {
    /// <p> The ID of the import file task. </p>
    pub id: std::option::Option<std::string::String>,
    /// <p> Status of import file task. </p>
    pub status: std::option::Option<crate::model::ImportFileTaskStatus>,
    /// <p> Start time of the import task. </p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> The S3 bucket where the import file is located. </p>
    pub input_s3_bucket: std::option::Option<std::string::String>,
    /// <p> The Amazon S3 key name of the import file. </p>
    pub input_s3_key: std::option::Option<std::string::String>,
    /// <p> The S3 bucket name for status report of import task. </p>
    pub status_report_s3_bucket: std::option::Option<std::string::String>,
    /// <p> The Amazon S3 key name for status report of import task. The report contains  details about
    /// whether each record imported successfully or why it did not. </p>
    pub status_report_s3_key: std::option::Option<std::string::String>,
    /// <p> The time that the import task completes. </p>
    pub completion_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> The number of records successfully imported. </p>
    pub number_of_records_success: std::option::Option<i32>,
    /// <p> The number of records that failed to be imported. </p>
    pub number_of_records_failed: std::option::Option<i32>,
    /// <p> The name of the import task given in <code>StartImportFileTask</code>. </p>
    pub import_name: std::option::Option<std::string::String>,
}
impl ImportFileTaskInformation {
    /// <p> The ID of the import file task. </p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p> Status of import file task. </p>
    pub fn status(&self) -> std::option::Option<&crate::model::ImportFileTaskStatus> {
        self.status.as_ref()
    }
    /// <p> Start time of the import task. </p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p> The S3 bucket where the import file is located. </p>
    pub fn input_s3_bucket(&self) -> std::option::Option<&str> {
        self.input_s3_bucket.as_deref()
    }
    /// <p> The Amazon S3 key name of the import file. </p>
    pub fn input_s3_key(&self) -> std::option::Option<&str> {
        self.input_s3_key.as_deref()
    }
    /// <p> The S3 bucket name for status report of import task. </p>
    pub fn status_report_s3_bucket(&self) -> std::option::Option<&str> {
        self.status_report_s3_bucket.as_deref()
    }
    /// <p> The Amazon S3 key name for status report of import task. The report contains  details about
    /// whether each record imported successfully or why it did not. </p>
    pub fn status_report_s3_key(&self) -> std::option::Option<&str> {
        self.status_report_s3_key.as_deref()
    }
    /// <p> The time that the import task completes. </p>
    pub fn completion_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.completion_time.as_ref()
    }
    /// <p> The number of records successfully imported. </p>
    pub fn number_of_records_success(&self) -> std::option::Option<i32> {
        self.number_of_records_success
    }
    /// <p> The number of records that failed to be imported. </p>
    pub fn number_of_records_failed(&self) -> std::option::Option<i32> {
        self.number_of_records_failed
    }
    /// <p> The name of the import task given in <code>StartImportFileTask</code>. </p>
    pub fn import_name(&self) -> std::option::Option<&str> {
        self.import_name.as_deref()
    }
}
impl std::fmt::Debug for ImportFileTaskInformation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImportFileTaskInformation");
        formatter.field("id", &self.id);
        formatter.field("status", &self.status);
        formatter.field("start_time", &self.start_time);
        formatter.field("input_s3_bucket", &self.input_s3_bucket);
        formatter.field("input_s3_key", &self.input_s3_key);
        formatter.field("status_report_s3_bucket", &self.status_report_s3_bucket);
        formatter.field("status_report_s3_key", &self.status_report_s3_key);
        formatter.field("completion_time", &self.completion_time);
        formatter.field("number_of_records_success", &self.number_of_records_success);
        formatter.field("number_of_records_failed", &self.number_of_records_failed);
        formatter.field("import_name", &self.import_name);
        formatter.finish()
    }
}
/// See [`ImportFileTaskInformation`](crate::model::ImportFileTaskInformation)
pub mod import_file_task_information {
    /// A builder for [`ImportFileTaskInformation`](crate::model::ImportFileTaskInformation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ImportFileTaskStatus>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) input_s3_bucket: std::option::Option<std::string::String>,
        pub(crate) input_s3_key: std::option::Option<std::string::String>,
        pub(crate) status_report_s3_bucket: std::option::Option<std::string::String>,
        pub(crate) status_report_s3_key: std::option::Option<std::string::String>,
        pub(crate) completion_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) number_of_records_success: std::option::Option<i32>,
        pub(crate) number_of_records_failed: std::option::Option<i32>,
        pub(crate) import_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The ID of the import file task. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p> The ID of the import file task. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p> Status of import file task. </p>
        pub fn status(mut self, input: crate::model::ImportFileTaskStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p> Status of import file task. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ImportFileTaskStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p> Start time of the import task. </p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p> Start time of the import task. </p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p> The S3 bucket where the import file is located. </p>
        pub fn input_s3_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_s3_bucket = Some(input.into());
            self
        }
        /// <p> The S3 bucket where the import file is located. </p>
        pub fn set_input_s3_bucket(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.input_s3_bucket = input;
            self
        }
        /// <p> The Amazon S3 key name of the import file. </p>
        pub fn input_s3_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_s3_key = Some(input.into());
            self
        }
        /// <p> The Amazon S3 key name of the import file. </p>
        pub fn set_input_s3_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.input_s3_key = input;
            self
        }
        /// <p> The S3 bucket name for status report of import task. </p>
        pub fn status_report_s3_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_report_s3_bucket = Some(input.into());
            self
        }
        /// <p> The S3 bucket name for status report of import task. </p>
        pub fn set_status_report_s3_bucket(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_report_s3_bucket = input;
            self
        }
        /// <p> The Amazon S3 key name for status report of import task. The report contains  details about
        /// whether each record imported successfully or why it did not. </p>
        pub fn status_report_s3_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_report_s3_key = Some(input.into());
            self
        }
        /// <p> The Amazon S3 key name for status report of import task. The report contains  details about
        /// whether each record imported successfully or why it did not. </p>
        pub fn set_status_report_s3_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_report_s3_key = input;
            self
        }
        /// <p> The time that the import task completes. </p>
        pub fn completion_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.completion_time = Some(input);
            self
        }
        /// <p> The time that the import task completes. </p>
        pub fn set_completion_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.completion_time = input;
            self
        }
        /// <p> The number of records successfully imported. </p>
        pub fn number_of_records_success(mut self, input: i32) -> Self {
            self.number_of_records_success = Some(input);
            self
        }
        /// <p> The number of records successfully imported. </p>
        pub fn set_number_of_records_success(mut self, input: std::option::Option<i32>) -> Self {
            self.number_of_records_success = input;
            self
        }
        /// <p> The number of records that failed to be imported. </p>
        pub fn number_of_records_failed(mut self, input: i32) -> Self {
            self.number_of_records_failed = Some(input);
            self
        }
        /// <p> The number of records that failed to be imported. </p>
        pub fn set_number_of_records_failed(mut self, input: std::option::Option<i32>) -> Self {
            self.number_of_records_failed = input;
            self
        }
        /// <p> The name of the import task given in <code>StartImportFileTask</code>. </p>
        pub fn import_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.import_name = Some(input.into());
            self
        }
        /// <p> The name of the import task given in <code>StartImportFileTask</code>. </p>
        pub fn set_import_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.import_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ImportFileTaskInformation`](crate::model::ImportFileTaskInformation)
        pub fn build(self) -> crate::model::ImportFileTaskInformation {
            crate::model::ImportFileTaskInformation {
                id: self.id,
                status: self.status,
                start_time: self.start_time,
                input_s3_bucket: self.input_s3_bucket,
                input_s3_key: self.input_s3_key,
                status_report_s3_bucket: self.status_report_s3_bucket,
                status_report_s3_key: self.status_report_s3_key,
                completion_time: self.completion_time,
                number_of_records_success: self.number_of_records_success,
                number_of_records_failed: self.number_of_records_failed,
                import_name: self.import_name,
            }
        }
    }
}
impl ImportFileTaskInformation {
    /// Creates a new builder-style object to manufacture [`ImportFileTaskInformation`](crate::model::ImportFileTaskInformation)
    pub fn builder() -> crate::model::import_file_task_information::Builder {
        crate::model::import_file_task_information::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ImportFileTaskStatus {
    #[allow(missing_docs)] // documentation missing in model
    DeleteFailed,
    #[allow(missing_docs)] // documentation missing in model
    DeleteInProgress,
    #[allow(missing_docs)] // documentation missing in model
    DeletePartialSuccess,
    #[allow(missing_docs)] // documentation missing in model
    DeleteSuccess,
    #[allow(missing_docs)] // documentation missing in model
    ImportFailed,
    #[allow(missing_docs)] // documentation missing in model
    ImportInProgress,
    #[allow(missing_docs)] // documentation missing in model
    ImportPartialSuccess,
    #[allow(missing_docs)] // documentation missing in model
    ImportSuccess,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ImportFileTaskStatus {
    fn from(s: &str) -> Self {
        match s {
            "DeleteFailed" => ImportFileTaskStatus::DeleteFailed,
            "DeleteInProgress" => ImportFileTaskStatus::DeleteInProgress,
            "DeletePartialSuccess" => ImportFileTaskStatus::DeletePartialSuccess,
            "DeleteSuccess" => ImportFileTaskStatus::DeleteSuccess,
            "ImportFailed" => ImportFileTaskStatus::ImportFailed,
            "ImportInProgress" => ImportFileTaskStatus::ImportInProgress,
            "ImportPartialSuccess" => ImportFileTaskStatus::ImportPartialSuccess,
            "ImportSuccess" => ImportFileTaskStatus::ImportSuccess,
            other => ImportFileTaskStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ImportFileTaskStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ImportFileTaskStatus::from(s))
    }
}
impl ImportFileTaskStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ImportFileTaskStatus::DeleteFailed => "DeleteFailed",
            ImportFileTaskStatus::DeleteInProgress => "DeleteInProgress",
            ImportFileTaskStatus::DeletePartialSuccess => "DeletePartialSuccess",
            ImportFileTaskStatus::DeleteSuccess => "DeleteSuccess",
            ImportFileTaskStatus::ImportFailed => "ImportFailed",
            ImportFileTaskStatus::ImportInProgress => "ImportInProgress",
            ImportFileTaskStatus::ImportPartialSuccess => "ImportPartialSuccess",
            ImportFileTaskStatus::ImportSuccess => "ImportSuccess",
            ImportFileTaskStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DeleteFailed",
            "DeleteInProgress",
            "DeletePartialSuccess",
            "DeleteSuccess",
            "ImportFailed",
            "ImportInProgress",
            "ImportPartialSuccess",
            "ImportSuccess",
        ]
    }
}
impl AsRef<str> for ImportFileTaskStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>
/// Process data collector that runs in the environment that you specify.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Collector {
    /// <p>
    /// The ID of the collector.
    /// </p>
    pub collector_id: std::option::Option<std::string::String>,
    /// <p>
    /// IP address of the server that is hosting the collector.
    /// </p>
    pub ip_address: std::option::Option<std::string::String>,
    /// <p>
    /// Hostname of the server that is hosting the collector.
    /// </p>
    pub host_name: std::option::Option<std::string::String>,
    /// <p>
    /// Indicates the health of a collector.
    /// </p>
    pub collector_health: std::option::Option<crate::model::CollectorHealth>,
    /// <p>
    /// Current version of the collector that is running in the environment that you specify.
    /// </p>
    pub collector_version: std::option::Option<std::string::String>,
    /// <p>
    /// Time when the collector registered with the service.
    /// </p>
    pub registered_time_stamp: std::option::Option<std::string::String>,
    /// <p>
    /// Time when the collector last pinged the service.
    /// </p>
    pub last_activity_time_stamp: std::option::Option<std::string::String>,
}
impl Collector {
    /// <p>
    /// The ID of the collector.
    /// </p>
    pub fn collector_id(&self) -> std::option::Option<&str> {
        self.collector_id.as_deref()
    }
    /// <p>
    /// IP address of the server that is hosting the collector.
    /// </p>
    pub fn ip_address(&self) -> std::option::Option<&str> {
        self.ip_address.as_deref()
    }
    /// <p>
    /// Hostname of the server that is hosting the collector.
    /// </p>
    pub fn host_name(&self) -> std::option::Option<&str> {
        self.host_name.as_deref()
    }
    /// <p>
    /// Indicates the health of a collector.
    /// </p>
    pub fn collector_health(&self) -> std::option::Option<&crate::model::CollectorHealth> {
        self.collector_health.as_ref()
    }
    /// <p>
    /// Current version of the collector that is running in the environment that you specify.
    /// </p>
    pub fn collector_version(&self) -> std::option::Option<&str> {
        self.collector_version.as_deref()
    }
    /// <p>
    /// Time when the collector registered with the service.
    /// </p>
    pub fn registered_time_stamp(&self) -> std::option::Option<&str> {
        self.registered_time_stamp.as_deref()
    }
    /// <p>
    /// Time when the collector last pinged the service.
    /// </p>
    pub fn last_activity_time_stamp(&self) -> std::option::Option<&str> {
        self.last_activity_time_stamp.as_deref()
    }
}
impl std::fmt::Debug for Collector {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Collector");
        formatter.field("collector_id", &self.collector_id);
        formatter.field("ip_address", &self.ip_address);
        formatter.field("host_name", &self.host_name);
        formatter.field("collector_health", &self.collector_health);
        formatter.field("collector_version", &self.collector_version);
        formatter.field("registered_time_stamp", &self.registered_time_stamp);
        formatter.field("last_activity_time_stamp", &self.last_activity_time_stamp);
        formatter.finish()
    }
}
/// See [`Collector`](crate::model::Collector)
pub mod collector {
    /// A builder for [`Collector`](crate::model::Collector)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) collector_id: std::option::Option<std::string::String>,
        pub(crate) ip_address: std::option::Option<std::string::String>,
        pub(crate) host_name: std::option::Option<std::string::String>,
        pub(crate) collector_health: std::option::Option<crate::model::CollectorHealth>,
        pub(crate) collector_version: std::option::Option<std::string::String>,
        pub(crate) registered_time_stamp: std::option::Option<std::string::String>,
        pub(crate) last_activity_time_stamp: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The ID of the collector.
        /// </p>
        pub fn collector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.collector_id = Some(input.into());
            self
        }
        /// <p>
        /// The ID of the collector.
        /// </p>
        pub fn set_collector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.collector_id = input;
            self
        }
        /// <p>
        /// IP address of the server that is hosting the collector.
        /// </p>
        pub fn ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip_address = Some(input.into());
            self
        }
        /// <p>
        /// IP address of the server that is hosting the collector.
        /// </p>
        pub fn set_ip_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ip_address = input;
            self
        }
        /// <p>
        /// Hostname of the server that is hosting the collector.
        /// </p>
        pub fn host_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.host_name = Some(input.into());
            self
        }
        /// <p>
        /// Hostname of the server that is hosting the collector.
        /// </p>
        pub fn set_host_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.host_name = input;
            self
        }
        /// <p>
        /// Indicates the health of a collector.
        /// </p>
        pub fn collector_health(mut self, input: crate::model::CollectorHealth) -> Self {
            self.collector_health = Some(input);
            self
        }
        /// <p>
        /// Indicates the health of a collector.
        /// </p>
        pub fn set_collector_health(
            mut self,
            input: std::option::Option<crate::model::CollectorHealth>,
        ) -> Self {
            self.collector_health = input;
            self
        }
        /// <p>
        /// Current version of the collector that is running in the environment that you specify.
        /// </p>
        pub fn collector_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.collector_version = Some(input.into());
            self
        }
        /// <p>
        /// Current version of the collector that is running in the environment that you specify.
        /// </p>
        pub fn set_collector_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.collector_version = input;
            self
        }
        /// <p>
        /// Time when the collector registered with the service.
        /// </p>
        pub fn registered_time_stamp(mut self, input: impl Into<std::string::String>) -> Self {
            self.registered_time_stamp = Some(input.into());
            self
        }
        /// <p>
        /// Time when the collector registered with the service.
        /// </p>
        pub fn set_registered_time_stamp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.registered_time_stamp = input;
            self
        }
        /// <p>
        /// Time when the collector last pinged the service.
        /// </p>
        pub fn last_activity_time_stamp(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_activity_time_stamp = Some(input.into());
            self
        }
        /// <p>
        /// Time when the collector last pinged the service.
        /// </p>
        pub fn set_last_activity_time_stamp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_activity_time_stamp = input;
            self
        }
        /// Consumes the builder and constructs a [`Collector`](crate::model::Collector)
        pub fn build(self) -> crate::model::Collector {
            crate::model::Collector {
                collector_id: self.collector_id,
                ip_address: self.ip_address,
                host_name: self.host_name,
                collector_health: self.collector_health,
                collector_version: self.collector_version,
                registered_time_stamp: self.registered_time_stamp,
                last_activity_time_stamp: self.last_activity_time_stamp,
            }
        }
    }
}
impl Collector {
    /// Creates a new builder-style object to manufacture [`Collector`](crate::model::Collector)
    pub fn builder() -> crate::model::collector::Builder {
        crate::model::collector::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CollectorHealth {
    #[allow(missing_docs)] // documentation missing in model
    CollectorHealthy,
    #[allow(missing_docs)] // documentation missing in model
    CollectorUnhealthy,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CollectorHealth {
    fn from(s: &str) -> Self {
        match s {
            "COLLECTOR_HEALTHY" => CollectorHealth::CollectorHealthy,
            "COLLECTOR_UNHEALTHY" => CollectorHealth::CollectorUnhealthy,
            other => CollectorHealth::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CollectorHealth {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CollectorHealth::from(s))
    }
}
impl CollectorHealth {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CollectorHealth::CollectorHealthy => "COLLECTOR_HEALTHY",
            CollectorHealth::CollectorUnhealthy => "COLLECTOR_UNHEALTHY",
            CollectorHealth::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COLLECTOR_HEALTHY", "COLLECTOR_UNHEALTHY"]
    }
}
impl AsRef<str> for CollectorHealth {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> Contains detailed information about an application component. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApplicationComponentDetail {
    /// <p> The ID of the application component. </p>
    pub id: std::option::Option<std::string::String>,
    /// <p> The name of application component. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p> The top recommendation set for the application component. </p>
    pub recommendation_set: std::option::Option<crate::model::RecommendationSet>,
    /// <p> The status of analysis, if the application component has source code or an associated
    /// database. </p>
    pub analysis_status: std::option::Option<crate::model::SrcCodeOrDbAnalysisStatus>,
    /// <p> A detailed description of the analysis status and any failure message. </p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p> A list of anti-pattern severity summaries. </p>
    pub list_antipattern_severity_summary:
        std::option::Option<std::vec::Vec<crate::model::AntipatternSeveritySummary>>,
    /// <p> Configuration details for the database associated with the application component. </p>
    pub database_config_detail: std::option::Option<crate::model::DatabaseConfigDetail>,
    /// <p> Details about the source code repository associated with the application component.
    /// </p>
    pub source_code_repositories:
        std::option::Option<std::vec::Vec<crate::model::SourceCodeRepository>>,
    /// <p> The type of application component. </p>
    pub app_type: std::option::Option<crate::model::AppType>,
    /// <p> The application component subtype.</p>
    pub resource_sub_type: std::option::Option<crate::model::ResourceSubType>,
    /// <p> Indicates whether the application component has been included for server recommendation
    /// or not. </p>
    pub inclusion_status: std::option::Option<crate::model::InclusionStatus>,
    /// <p> The S3 bucket name and the Amazon S3 key name for the anti-pattern report. </p>
    pub antipattern_report_s3_object: std::option::Option<crate::model::S3Object>,
    /// <p> The status of the anti-pattern report generation.</p>
    pub antipattern_report_status: std::option::Option<crate::model::AntipatternReportStatus>,
    /// <p> The status message for the anti-pattern. </p>
    pub antipattern_report_status_message: std::option::Option<std::string::String>,
    /// <p> OS version. </p>
    pub os_version: std::option::Option<std::string::String>,
    /// <p> OS driver. </p>
    pub os_driver: std::option::Option<std::string::String>,
    /// <p> The timestamp of when the application component was assessed. </p>
    pub last_analyzed_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> The ID of the server that the application component is running on. </p>
    pub associated_server_id: std::option::Option<std::string::String>,
    /// <p> Set to true if the application component is running on multiple servers.</p>
    pub more_server_association_exists: std::option::Option<bool>,
}
impl ApplicationComponentDetail {
    /// <p> The ID of the application component. </p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p> The name of application component. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p> The top recommendation set for the application component. </p>
    pub fn recommendation_set(&self) -> std::option::Option<&crate::model::RecommendationSet> {
        self.recommendation_set.as_ref()
    }
    /// <p> The status of analysis, if the application component has source code or an associated
    /// database. </p>
    pub fn analysis_status(&self) -> std::option::Option<&crate::model::SrcCodeOrDbAnalysisStatus> {
        self.analysis_status.as_ref()
    }
    /// <p> A detailed description of the analysis status and any failure message. </p>
    pub fn status_message(&self) -> std::option::Option<&str> {
        self.status_message.as_deref()
    }
    /// <p> A list of anti-pattern severity summaries. </p>
    pub fn list_antipattern_severity_summary(
        &self,
    ) -> std::option::Option<&[crate::model::AntipatternSeveritySummary]> {
        self.list_antipattern_severity_summary.as_deref()
    }
    /// <p> Configuration details for the database associated with the application component. </p>
    pub fn database_config_detail(
        &self,
    ) -> std::option::Option<&crate::model::DatabaseConfigDetail> {
        self.database_config_detail.as_ref()
    }
    /// <p> Details about the source code repository associated with the application component.
    /// </p>
    pub fn source_code_repositories(
        &self,
    ) -> std::option::Option<&[crate::model::SourceCodeRepository]> {
        self.source_code_repositories.as_deref()
    }
    /// <p> The type of application component. </p>
    pub fn app_type(&self) -> std::option::Option<&crate::model::AppType> {
        self.app_type.as_ref()
    }
    /// <p> The application component subtype.</p>
    pub fn resource_sub_type(&self) -> std::option::Option<&crate::model::ResourceSubType> {
        self.resource_sub_type.as_ref()
    }
    /// <p> Indicates whether the application component has been included for server recommendation
    /// or not. </p>
    pub fn inclusion_status(&self) -> std::option::Option<&crate::model::InclusionStatus> {
        self.inclusion_status.as_ref()
    }
    /// <p> The S3 bucket name and the Amazon S3 key name for the anti-pattern report. </p>
    pub fn antipattern_report_s3_object(&self) -> std::option::Option<&crate::model::S3Object> {
        self.antipattern_report_s3_object.as_ref()
    }
    /// <p> The status of the anti-pattern report generation.</p>
    pub fn antipattern_report_status(
        &self,
    ) -> std::option::Option<&crate::model::AntipatternReportStatus> {
        self.antipattern_report_status.as_ref()
    }
    /// <p> The status message for the anti-pattern. </p>
    pub fn antipattern_report_status_message(&self) -> std::option::Option<&str> {
        self.antipattern_report_status_message.as_deref()
    }
    /// <p> OS version. </p>
    pub fn os_version(&self) -> std::option::Option<&str> {
        self.os_version.as_deref()
    }
    /// <p> OS driver. </p>
    pub fn os_driver(&self) -> std::option::Option<&str> {
        self.os_driver.as_deref()
    }
    /// <p> The timestamp of when the application component was assessed. </p>
    pub fn last_analyzed_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_analyzed_timestamp.as_ref()
    }
    /// <p> The ID of the server that the application component is running on. </p>
    pub fn associated_server_id(&self) -> std::option::Option<&str> {
        self.associated_server_id.as_deref()
    }
    /// <p> Set to true if the application component is running on multiple servers.</p>
    pub fn more_server_association_exists(&self) -> std::option::Option<bool> {
        self.more_server_association_exists
    }
}
impl std::fmt::Debug for ApplicationComponentDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApplicationComponentDetail");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("recommendation_set", &self.recommendation_set);
        formatter.field("analysis_status", &self.analysis_status);
        formatter.field("status_message", &self.status_message);
        formatter.field(
            "list_antipattern_severity_summary",
            &self.list_antipattern_severity_summary,
        );
        formatter.field("database_config_detail", &self.database_config_detail);
        formatter.field("source_code_repositories", &self.source_code_repositories);
        formatter.field("app_type", &self.app_type);
        formatter.field("resource_sub_type", &self.resource_sub_type);
        formatter.field("inclusion_status", &self.inclusion_status);
        formatter.field(
            "antipattern_report_s3_object",
            &self.antipattern_report_s3_object,
        );
        formatter.field("antipattern_report_status", &self.antipattern_report_status);
        formatter.field(
            "antipattern_report_status_message",
            &self.antipattern_report_status_message,
        );
        formatter.field("os_version", &self.os_version);
        formatter.field("os_driver", &self.os_driver);
        formatter.field("last_analyzed_timestamp", &self.last_analyzed_timestamp);
        formatter.field("associated_server_id", &self.associated_server_id);
        formatter.field(
            "more_server_association_exists",
            &self.more_server_association_exists,
        );
        formatter.finish()
    }
}
/// See [`ApplicationComponentDetail`](crate::model::ApplicationComponentDetail)
pub mod application_component_detail {
    /// A builder for [`ApplicationComponentDetail`](crate::model::ApplicationComponentDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) recommendation_set: std::option::Option<crate::model::RecommendationSet>,
        pub(crate) analysis_status: std::option::Option<crate::model::SrcCodeOrDbAnalysisStatus>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) list_antipattern_severity_summary:
            std::option::Option<std::vec::Vec<crate::model::AntipatternSeveritySummary>>,
        pub(crate) database_config_detail: std::option::Option<crate::model::DatabaseConfigDetail>,
        pub(crate) source_code_repositories:
            std::option::Option<std::vec::Vec<crate::model::SourceCodeRepository>>,
        pub(crate) app_type: std::option::Option<crate::model::AppType>,
        pub(crate) resource_sub_type: std::option::Option<crate::model::ResourceSubType>,
        pub(crate) inclusion_status: std::option::Option<crate::model::InclusionStatus>,
        pub(crate) antipattern_report_s3_object: std::option::Option<crate::model::S3Object>,
        pub(crate) antipattern_report_status:
            std::option::Option<crate::model::AntipatternReportStatus>,
        pub(crate) antipattern_report_status_message: std::option::Option<std::string::String>,
        pub(crate) os_version: std::option::Option<std::string::String>,
        pub(crate) os_driver: std::option::Option<std::string::String>,
        pub(crate) last_analyzed_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) associated_server_id: std::option::Option<std::string::String>,
        pub(crate) more_server_association_exists: std::option::Option<bool>,
    }
    impl Builder {
        /// <p> The ID of the application component. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p> The ID of the application component. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p> The name of application component. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> The name of application component. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p> The top recommendation set for the application component. </p>
        pub fn recommendation_set(mut self, input: crate::model::RecommendationSet) -> Self {
            self.recommendation_set = Some(input);
            self
        }
        /// <p> The top recommendation set for the application component. </p>
        pub fn set_recommendation_set(
            mut self,
            input: std::option::Option<crate::model::RecommendationSet>,
        ) -> Self {
            self.recommendation_set = input;
            self
        }
        /// <p> The status of analysis, if the application component has source code or an associated
        /// database. </p>
        pub fn analysis_status(mut self, input: crate::model::SrcCodeOrDbAnalysisStatus) -> Self {
            self.analysis_status = Some(input);
            self
        }
        /// <p> The status of analysis, if the application component has source code or an associated
        /// database. </p>
        pub fn set_analysis_status(
            mut self,
            input: std::option::Option<crate::model::SrcCodeOrDbAnalysisStatus>,
        ) -> Self {
            self.analysis_status = input;
            self
        }
        /// <p> A detailed description of the analysis status and any failure message. </p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p> A detailed description of the analysis status and any failure message. </p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// Appends an item to `list_antipattern_severity_summary`.
        ///
        /// To override the contents of this collection use [`set_list_antipattern_severity_summary`](Self::set_list_antipattern_severity_summary).
        ///
        /// <p> A list of anti-pattern severity summaries. </p>
        pub fn list_antipattern_severity_summary(
            mut self,
            input: impl Into<crate::model::AntipatternSeveritySummary>,
        ) -> Self {
            let mut v = self.list_antipattern_severity_summary.unwrap_or_default();
            v.push(input.into());
            self.list_antipattern_severity_summary = Some(v);
            self
        }
        /// <p> A list of anti-pattern severity summaries. </p>
        pub fn set_list_antipattern_severity_summary(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AntipatternSeveritySummary>>,
        ) -> Self {
            self.list_antipattern_severity_summary = input;
            self
        }
        /// <p> Configuration details for the database associated with the application component. </p>
        pub fn database_config_detail(mut self, input: crate::model::DatabaseConfigDetail) -> Self {
            self.database_config_detail = Some(input);
            self
        }
        /// <p> Configuration details for the database associated with the application component. </p>
        pub fn set_database_config_detail(
            mut self,
            input: std::option::Option<crate::model::DatabaseConfigDetail>,
        ) -> Self {
            self.database_config_detail = input;
            self
        }
        /// Appends an item to `source_code_repositories`.
        ///
        /// To override the contents of this collection use [`set_source_code_repositories`](Self::set_source_code_repositories).
        ///
        /// <p> Details about the source code repository associated with the application component.
        /// </p>
        pub fn source_code_repositories(
            mut self,
            input: impl Into<crate::model::SourceCodeRepository>,
        ) -> Self {
            let mut v = self.source_code_repositories.unwrap_or_default();
            v.push(input.into());
            self.source_code_repositories = Some(v);
            self
        }
        /// <p> Details about the source code repository associated with the application component.
        /// </p>
        pub fn set_source_code_repositories(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SourceCodeRepository>>,
        ) -> Self {
            self.source_code_repositories = input;
            self
        }
        /// <p> The type of application component. </p>
        pub fn app_type(mut self, input: crate::model::AppType) -> Self {
            self.app_type = Some(input);
            self
        }
        /// <p> The type of application component. </p>
        pub fn set_app_type(mut self, input: std::option::Option<crate::model::AppType>) -> Self {
            self.app_type = input;
            self
        }
        /// <p> The application component subtype.</p>
        pub fn resource_sub_type(mut self, input: crate::model::ResourceSubType) -> Self {
            self.resource_sub_type = Some(input);
            self
        }
        /// <p> The application component subtype.</p>
        pub fn set_resource_sub_type(
            mut self,
            input: std::option::Option<crate::model::ResourceSubType>,
        ) -> Self {
            self.resource_sub_type = input;
            self
        }
        /// <p> Indicates whether the application component has been included for server recommendation
        /// or not. </p>
        pub fn inclusion_status(mut self, input: crate::model::InclusionStatus) -> Self {
            self.inclusion_status = Some(input);
            self
        }
        /// <p> Indicates whether the application component has been included for server recommendation
        /// or not. </p>
        pub fn set_inclusion_status(
            mut self,
            input: std::option::Option<crate::model::InclusionStatus>,
        ) -> Self {
            self.inclusion_status = input;
            self
        }
        /// <p> The S3 bucket name and the Amazon S3 key name for the anti-pattern report. </p>
        pub fn antipattern_report_s3_object(mut self, input: crate::model::S3Object) -> Self {
            self.antipattern_report_s3_object = Some(input);
            self
        }
        /// <p> The S3 bucket name and the Amazon S3 key name for the anti-pattern report. </p>
        pub fn set_antipattern_report_s3_object(
            mut self,
            input: std::option::Option<crate::model::S3Object>,
        ) -> Self {
            self.antipattern_report_s3_object = input;
            self
        }
        /// <p> The status of the anti-pattern report generation.</p>
        pub fn antipattern_report_status(
            mut self,
            input: crate::model::AntipatternReportStatus,
        ) -> Self {
            self.antipattern_report_status = Some(input);
            self
        }
        /// <p> The status of the anti-pattern report generation.</p>
        pub fn set_antipattern_report_status(
            mut self,
            input: std::option::Option<crate::model::AntipatternReportStatus>,
        ) -> Self {
            self.antipattern_report_status = input;
            self
        }
        /// <p> The status message for the anti-pattern. </p>
        pub fn antipattern_report_status_message(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.antipattern_report_status_message = Some(input.into());
            self
        }
        /// <p> The status message for the anti-pattern. </p>
        pub fn set_antipattern_report_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.antipattern_report_status_message = input;
            self
        }
        /// <p> OS version. </p>
        pub fn os_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.os_version = Some(input.into());
            self
        }
        /// <p> OS version. </p>
        pub fn set_os_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.os_version = input;
            self
        }
        /// <p> OS driver. </p>
        pub fn os_driver(mut self, input: impl Into<std::string::String>) -> Self {
            self.os_driver = Some(input.into());
            self
        }
        /// <p> OS driver. </p>
        pub fn set_os_driver(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.os_driver = input;
            self
        }
        /// <p> The timestamp of when the application component was assessed. </p>
        pub fn last_analyzed_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_analyzed_timestamp = Some(input);
            self
        }
        /// <p> The timestamp of when the application component was assessed. </p>
        pub fn set_last_analyzed_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_analyzed_timestamp = input;
            self
        }
        /// <p> The ID of the server that the application component is running on. </p>
        pub fn associated_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.associated_server_id = Some(input.into());
            self
        }
        /// <p> The ID of the server that the application component is running on. </p>
        pub fn set_associated_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.associated_server_id = input;
            self
        }
        /// <p> Set to true if the application component is running on multiple servers.</p>
        pub fn more_server_association_exists(mut self, input: bool) -> Self {
            self.more_server_association_exists = Some(input);
            self
        }
        /// <p> Set to true if the application component is running on multiple servers.</p>
        pub fn set_more_server_association_exists(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.more_server_association_exists = input;
            self
        }
        /// Consumes the builder and constructs a [`ApplicationComponentDetail`](crate::model::ApplicationComponentDetail)
        pub fn build(self) -> crate::model::ApplicationComponentDetail {
            crate::model::ApplicationComponentDetail {
                id: self.id,
                name: self.name,
                recommendation_set: self.recommendation_set,
                analysis_status: self.analysis_status,
                status_message: self.status_message,
                list_antipattern_severity_summary: self.list_antipattern_severity_summary,
                database_config_detail: self.database_config_detail,
                source_code_repositories: self.source_code_repositories,
                app_type: self.app_type,
                resource_sub_type: self.resource_sub_type,
                inclusion_status: self.inclusion_status,
                antipattern_report_s3_object: self.antipattern_report_s3_object,
                antipattern_report_status: self.antipattern_report_status,
                antipattern_report_status_message: self.antipattern_report_status_message,
                os_version: self.os_version,
                os_driver: self.os_driver,
                last_analyzed_timestamp: self.last_analyzed_timestamp,
                associated_server_id: self.associated_server_id,
                more_server_association_exists: self.more_server_association_exists,
            }
        }
    }
}
impl ApplicationComponentDetail {
    /// Creates a new builder-style object to manufacture [`ApplicationComponentDetail`](crate::model::ApplicationComponentDetail)
    pub fn builder() -> crate::model::application_component_detail::Builder {
        crate::model::application_component_detail::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceSubType {
    #[allow(missing_docs)] // documentation missing in model
    Database,
    #[allow(missing_docs)] // documentation missing in model
    DatabaseProcess,
    #[allow(missing_docs)] // documentation missing in model
    Process,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceSubType {
    fn from(s: &str) -> Self {
        match s {
            "Database" => ResourceSubType::Database,
            "DatabaseProcess" => ResourceSubType::DatabaseProcess,
            "Process" => ResourceSubType::Process,
            other => ResourceSubType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceSubType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceSubType::from(s))
    }
}
impl ResourceSubType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceSubType::Database => "Database",
            ResourceSubType::DatabaseProcess => "DatabaseProcess",
            ResourceSubType::Process => "Process",
            ResourceSubType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Database", "DatabaseProcess", "Process"]
    }
}
impl AsRef<str> for ResourceSubType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AppType {
    #[allow(missing_docs)] // documentation missing in model
    DotNetFramework,
    #[allow(missing_docs)] // documentation missing in model
    Iis,
    #[allow(missing_docs)] // documentation missing in model
    Java,
    #[allow(missing_docs)] // documentation missing in model
    Oracle,
    #[allow(missing_docs)] // documentation missing in model
    Other,
    #[allow(missing_docs)] // documentation missing in model
    SqlServer,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AppType {
    fn from(s: &str) -> Self {
        match s {
            "DotNetFramework" => AppType::DotNetFramework,
            "IIS" => AppType::Iis,
            "Java" => AppType::Java,
            "Oracle" => AppType::Oracle,
            "Other" => AppType::Other,
            "SQLServer" => AppType::SqlServer,
            other => AppType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AppType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AppType::from(s))
    }
}
impl AppType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AppType::DotNetFramework => "DotNetFramework",
            AppType::Iis => "IIS",
            AppType::Java => "Java",
            AppType::Oracle => "Oracle",
            AppType::Other => "Other",
            AppType::SqlServer => "SQLServer",
            AppType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DotNetFramework",
            "IIS",
            "Java",
            "Oracle",
            "Other",
            "SQLServer",
        ]
    }
}
impl AsRef<str> for AppType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>
/// Object containing source code information that is linked to an application component.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SourceCodeRepository {
    /// <p>
    /// The repository name for the source code.
    /// </p>
    pub repository: std::option::Option<std::string::String>,
    /// <p>
    /// The branch of the source code.
    /// </p>
    pub branch: std::option::Option<std::string::String>,
    /// <p>
    /// The type of repository to use for the source code.
    /// </p>
    pub version_control_type: std::option::Option<std::string::String>,
}
impl SourceCodeRepository {
    /// <p>
    /// The repository name for the source code.
    /// </p>
    pub fn repository(&self) -> std::option::Option<&str> {
        self.repository.as_deref()
    }
    /// <p>
    /// The branch of the source code.
    /// </p>
    pub fn branch(&self) -> std::option::Option<&str> {
        self.branch.as_deref()
    }
    /// <p>
    /// The type of repository to use for the source code.
    /// </p>
    pub fn version_control_type(&self) -> std::option::Option<&str> {
        self.version_control_type.as_deref()
    }
}
impl std::fmt::Debug for SourceCodeRepository {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SourceCodeRepository");
        formatter.field("repository", &self.repository);
        formatter.field("branch", &self.branch);
        formatter.field("version_control_type", &self.version_control_type);
        formatter.finish()
    }
}
/// See [`SourceCodeRepository`](crate::model::SourceCodeRepository)
pub mod source_code_repository {
    /// A builder for [`SourceCodeRepository`](crate::model::SourceCodeRepository)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository: std::option::Option<std::string::String>,
        pub(crate) branch: std::option::Option<std::string::String>,
        pub(crate) version_control_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The repository name for the source code.
        /// </p>
        pub fn repository(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository = Some(input.into());
            self
        }
        /// <p>
        /// The repository name for the source code.
        /// </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.repository = input;
            self
        }
        /// <p>
        /// The branch of the source code.
        /// </p>
        pub fn branch(mut self, input: impl Into<std::string::String>) -> Self {
            self.branch = Some(input.into());
            self
        }
        /// <p>
        /// The branch of the source code.
        /// </p>
        pub fn set_branch(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.branch = input;
            self
        }
        /// <p>
        /// The type of repository to use for the source code.
        /// </p>
        pub fn version_control_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_control_type = Some(input.into());
            self
        }
        /// <p>
        /// The type of repository to use for the source code.
        /// </p>
        pub fn set_version_control_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.version_control_type = input;
            self
        }
        /// Consumes the builder and constructs a [`SourceCodeRepository`](crate::model::SourceCodeRepository)
        pub fn build(self) -> crate::model::SourceCodeRepository {
            crate::model::SourceCodeRepository {
                repository: self.repository,
                branch: self.branch,
                version_control_type: self.version_control_type,
            }
        }
    }
}
impl SourceCodeRepository {
    /// Creates a new builder-style object to manufacture [`SourceCodeRepository`](crate::model::SourceCodeRepository)
    pub fn builder() -> crate::model::source_code_repository::Builder {
        crate::model::source_code_repository::Builder::default()
    }
}

/// <p>
/// Configuration information used for assessing databases.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DatabaseConfigDetail {
    /// <p>
    /// AWS Secrets Manager key that holds the credentials that you use to connect to a database.
    /// </p>
    pub secret_name: std::option::Option<std::string::String>,
}
impl DatabaseConfigDetail {
    /// <p>
    /// AWS Secrets Manager key that holds the credentials that you use to connect to a database.
    /// </p>
    pub fn secret_name(&self) -> std::option::Option<&str> {
        self.secret_name.as_deref()
    }
}
impl std::fmt::Debug for DatabaseConfigDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DatabaseConfigDetail");
        formatter.field("secret_name", &self.secret_name);
        formatter.finish()
    }
}
/// See [`DatabaseConfigDetail`](crate::model::DatabaseConfigDetail)
pub mod database_config_detail {
    /// A builder for [`DatabaseConfigDetail`](crate::model::DatabaseConfigDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) secret_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// AWS Secrets Manager key that holds the credentials that you use to connect to a database.
        /// </p>
        pub fn secret_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.secret_name = Some(input.into());
            self
        }
        /// <p>
        /// AWS Secrets Manager key that holds the credentials that you use to connect to a database.
        /// </p>
        pub fn set_secret_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.secret_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DatabaseConfigDetail`](crate::model::DatabaseConfigDetail)
        pub fn build(self) -> crate::model::DatabaseConfigDetail {
            crate::model::DatabaseConfigDetail {
                secret_name: self.secret_name,
            }
        }
    }
}
impl DatabaseConfigDetail {
    /// Creates a new builder-style object to manufacture [`DatabaseConfigDetail`](crate::model::DatabaseConfigDetail)
    pub fn builder() -> crate::model::database_config_detail::Builder {
        crate::model::database_config_detail::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SrcCodeOrDbAnalysisStatus {
    #[allow(missing_docs)] // documentation missing in model
    AnalysisFailed,
    #[allow(missing_docs)] // documentation missing in model
    AnalysisStarted,
    #[allow(missing_docs)] // documentation missing in model
    AnalysisSuccess,
    #[allow(missing_docs)] // documentation missing in model
    AnalysisToBeScheduled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SrcCodeOrDbAnalysisStatus {
    fn from(s: &str) -> Self {
        match s {
            "ANALYSIS_FAILED" => SrcCodeOrDbAnalysisStatus::AnalysisFailed,
            "ANALYSIS_STARTED" => SrcCodeOrDbAnalysisStatus::AnalysisStarted,
            "ANALYSIS_SUCCESS" => SrcCodeOrDbAnalysisStatus::AnalysisSuccess,
            "ANALYSIS_TO_BE_SCHEDULED" => SrcCodeOrDbAnalysisStatus::AnalysisToBeScheduled,
            other => SrcCodeOrDbAnalysisStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SrcCodeOrDbAnalysisStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SrcCodeOrDbAnalysisStatus::from(s))
    }
}
impl SrcCodeOrDbAnalysisStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SrcCodeOrDbAnalysisStatus::AnalysisFailed => "ANALYSIS_FAILED",
            SrcCodeOrDbAnalysisStatus::AnalysisStarted => "ANALYSIS_STARTED",
            SrcCodeOrDbAnalysisStatus::AnalysisSuccess => "ANALYSIS_SUCCESS",
            SrcCodeOrDbAnalysisStatus::AnalysisToBeScheduled => "ANALYSIS_TO_BE_SCHEDULED",
            SrcCodeOrDbAnalysisStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ANALYSIS_FAILED",
            "ANALYSIS_STARTED",
            "ANALYSIS_SUCCESS",
            "ANALYSIS_TO_BE_SCHEDULED",
        ]
    }
}
impl AsRef<str> for SrcCodeOrDbAnalysisStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ApplicationComponentCriteria {
    #[allow(missing_docs)] // documentation missing in model
    AppName,
    #[allow(missing_docs)] // documentation missing in model
    AppType,
    #[allow(missing_docs)] // documentation missing in model
    Destination,
    #[allow(missing_docs)] // documentation missing in model
    NotDefined,
    #[allow(missing_docs)] // documentation missing in model
    ServerId,
    #[allow(missing_docs)] // documentation missing in model
    Strategy,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ApplicationComponentCriteria {
    fn from(s: &str) -> Self {
        match s {
            "APP_NAME" => ApplicationComponentCriteria::AppName,
            "APP_TYPE" => ApplicationComponentCriteria::AppType,
            "DESTINATION" => ApplicationComponentCriteria::Destination,
            "NOT_DEFINED" => ApplicationComponentCriteria::NotDefined,
            "SERVER_ID" => ApplicationComponentCriteria::ServerId,
            "STRATEGY" => ApplicationComponentCriteria::Strategy,
            other => ApplicationComponentCriteria::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ApplicationComponentCriteria {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ApplicationComponentCriteria::from(s))
    }
}
impl ApplicationComponentCriteria {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ApplicationComponentCriteria::AppName => "APP_NAME",
            ApplicationComponentCriteria::AppType => "APP_TYPE",
            ApplicationComponentCriteria::Destination => "DESTINATION",
            ApplicationComponentCriteria::NotDefined => "NOT_DEFINED",
            ApplicationComponentCriteria::ServerId => "SERVER_ID",
            ApplicationComponentCriteria::Strategy => "STRATEGY",
            ApplicationComponentCriteria::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "APP_NAME",
            "APP_TYPE",
            "DESTINATION",
            "NOT_DEFINED",
            "SERVER_ID",
            "STRATEGY",
        ]
    }
}
impl AsRef<str> for ApplicationComponentCriteria {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> Contains information about a strategy recommendation for a server. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServerStrategy {
    /// <p> Strategy recommendation for the server. </p>
    pub recommendation: std::option::Option<crate::model::RecommendationSet>,
    /// <p> The recommendation status of the strategy for the server. </p>
    pub status: std::option::Option<crate::model::StrategyRecommendation>,
    /// <p> The number of application components with this strategy recommendation running on the
    /// server. </p>
    pub number_of_application_components: std::option::Option<i32>,
    /// <p> Set to true if the recommendation is set as preferred. </p>
    pub is_preferred: std::option::Option<bool>,
}
impl ServerStrategy {
    /// <p> Strategy recommendation for the server. </p>
    pub fn recommendation(&self) -> std::option::Option<&crate::model::RecommendationSet> {
        self.recommendation.as_ref()
    }
    /// <p> The recommendation status of the strategy for the server. </p>
    pub fn status(&self) -> std::option::Option<&crate::model::StrategyRecommendation> {
        self.status.as_ref()
    }
    /// <p> The number of application components with this strategy recommendation running on the
    /// server. </p>
    pub fn number_of_application_components(&self) -> std::option::Option<i32> {
        self.number_of_application_components
    }
    /// <p> Set to true if the recommendation is set as preferred. </p>
    pub fn is_preferred(&self) -> std::option::Option<bool> {
        self.is_preferred
    }
}
impl std::fmt::Debug for ServerStrategy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServerStrategy");
        formatter.field("recommendation", &self.recommendation);
        formatter.field("status", &self.status);
        formatter.field(
            "number_of_application_components",
            &self.number_of_application_components,
        );
        formatter.field("is_preferred", &self.is_preferred);
        formatter.finish()
    }
}
/// See [`ServerStrategy`](crate::model::ServerStrategy)
pub mod server_strategy {
    /// A builder for [`ServerStrategy`](crate::model::ServerStrategy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recommendation: std::option::Option<crate::model::RecommendationSet>,
        pub(crate) status: std::option::Option<crate::model::StrategyRecommendation>,
        pub(crate) number_of_application_components: std::option::Option<i32>,
        pub(crate) is_preferred: std::option::Option<bool>,
    }
    impl Builder {
        /// <p> Strategy recommendation for the server. </p>
        pub fn recommendation(mut self, input: crate::model::RecommendationSet) -> Self {
            self.recommendation = Some(input);
            self
        }
        /// <p> Strategy recommendation for the server. </p>
        pub fn set_recommendation(
            mut self,
            input: std::option::Option<crate::model::RecommendationSet>,
        ) -> Self {
            self.recommendation = input;
            self
        }
        /// <p> The recommendation status of the strategy for the server. </p>
        pub fn status(mut self, input: crate::model::StrategyRecommendation) -> Self {
            self.status = Some(input);
            self
        }
        /// <p> The recommendation status of the strategy for the server. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::StrategyRecommendation>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p> The number of application components with this strategy recommendation running on the
        /// server. </p>
        pub fn number_of_application_components(mut self, input: i32) -> Self {
            self.number_of_application_components = Some(input);
            self
        }
        /// <p> The number of application components with this strategy recommendation running on the
        /// server. </p>
        pub fn set_number_of_application_components(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.number_of_application_components = input;
            self
        }
        /// <p> Set to true if the recommendation is set as preferred. </p>
        pub fn is_preferred(mut self, input: bool) -> Self {
            self.is_preferred = Some(input);
            self
        }
        /// <p> Set to true if the recommendation is set as preferred. </p>
        pub fn set_is_preferred(mut self, input: std::option::Option<bool>) -> Self {
            self.is_preferred = input;
            self
        }
        /// Consumes the builder and constructs a [`ServerStrategy`](crate::model::ServerStrategy)
        pub fn build(self) -> crate::model::ServerStrategy {
            crate::model::ServerStrategy {
                recommendation: self.recommendation,
                status: self.status,
                number_of_application_components: self.number_of_application_components,
                is_preferred: self.is_preferred,
            }
        }
    }
}
impl ServerStrategy {
    /// Creates a new builder-style object to manufacture [`ServerStrategy`](crate::model::ServerStrategy)
    pub fn builder() -> crate::model::server_strategy::Builder {
        crate::model::server_strategy::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StrategyRecommendation {
    #[allow(missing_docs)] // documentation missing in model
    NotRecommended,
    #[allow(missing_docs)] // documentation missing in model
    Recommended,
    #[allow(missing_docs)] // documentation missing in model
    ViableOption,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StrategyRecommendation {
    fn from(s: &str) -> Self {
        match s {
            "notRecommended" => StrategyRecommendation::NotRecommended,
            "recommended" => StrategyRecommendation::Recommended,
            "viableOption" => StrategyRecommendation::ViableOption,
            other => StrategyRecommendation::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StrategyRecommendation {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StrategyRecommendation::from(s))
    }
}
impl StrategyRecommendation {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StrategyRecommendation::NotRecommended => "notRecommended",
            StrategyRecommendation::Recommended => "recommended",
            StrategyRecommendation::ViableOption => "viableOption",
            StrategyRecommendation::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["notRecommended", "recommended", "viableOption"]
    }
}
impl AsRef<str> for StrategyRecommendation {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>
/// Object containing details about applications as defined in Application Discovery Service.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociatedApplication {
    /// <p>
    /// Name of the application as defined in Application Discovery Service.
    /// </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>
    /// ID of the application as defined in Application Discovery Service.
    /// </p>
    pub id: std::option::Option<std::string::String>,
}
impl AssociatedApplication {
    /// <p>
    /// Name of the application as defined in Application Discovery Service.
    /// </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>
    /// ID of the application as defined in Application Discovery Service.
    /// </p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for AssociatedApplication {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociatedApplication");
        formatter.field("name", &self.name);
        formatter.field("id", &self.id);
        formatter.finish()
    }
}
/// See [`AssociatedApplication`](crate::model::AssociatedApplication)
pub mod associated_application {
    /// A builder for [`AssociatedApplication`](crate::model::AssociatedApplication)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// Name of the application as defined in Application Discovery Service.
        /// </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>
        /// Name of the application as defined in Application Discovery Service.
        /// </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>
        /// ID of the application as defined in Application Discovery Service.
        /// </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>
        /// ID of the application as defined in Application Discovery Service.
        /// </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociatedApplication`](crate::model::AssociatedApplication)
        pub fn build(self) -> crate::model::AssociatedApplication {
            crate::model::AssociatedApplication {
                name: self.name,
                id: self.id,
            }
        }
    }
}
impl AssociatedApplication {
    /// Creates a new builder-style object to manufacture [`AssociatedApplication`](crate::model::AssociatedApplication)
    pub fn builder() -> crate::model::associated_application::Builder {
        crate::model::associated_application::Builder::default()
    }
}

/// <p>
/// Contains detailed information about a recommendation report.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecommendationReportDetails {
    /// <p>
    /// The status of the recommendation report generation task.
    /// </p>
    pub status: std::option::Option<crate::model::RecommendationReportStatus>,
    /// <p>
    /// The status message for recommendation report generation.
    /// </p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p>
    /// The time that the recommendation report generation task starts.
    /// </p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>
    /// The time that the recommendation report generation task completes.
    /// </p>
    pub completion_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>
    /// The S3 bucket where the report file is located.
    /// </p>
    pub s3_bucket: std::option::Option<std::string::String>,
    /// <p>
    /// The Amazon S3 key name of the report file.
    /// </p>
    pub s3_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl RecommendationReportDetails {
    /// <p>
    /// The status of the recommendation report generation task.
    /// </p>
    pub fn status(&self) -> std::option::Option<&crate::model::RecommendationReportStatus> {
        self.status.as_ref()
    }
    /// <p>
    /// The status message for recommendation report generation.
    /// </p>
    pub fn status_message(&self) -> std::option::Option<&str> {
        self.status_message.as_deref()
    }
    /// <p>
    /// The time that the recommendation report generation task starts.
    /// </p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>
    /// The time that the recommendation report generation task completes.
    /// </p>
    pub fn completion_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.completion_time.as_ref()
    }
    /// <p>
    /// The S3 bucket where the report file is located.
    /// </p>
    pub fn s3_bucket(&self) -> std::option::Option<&str> {
        self.s3_bucket.as_deref()
    }
    /// <p>
    /// The Amazon S3 key name of the report file.
    /// </p>
    pub fn s3_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.s3_keys.as_deref()
    }
}
impl std::fmt::Debug for RecommendationReportDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecommendationReportDetails");
        formatter.field("status", &self.status);
        formatter.field("status_message", &self.status_message);
        formatter.field("start_time", &self.start_time);
        formatter.field("completion_time", &self.completion_time);
        formatter.field("s3_bucket", &self.s3_bucket);
        formatter.field("s3_keys", &self.s3_keys);
        formatter.finish()
    }
}
/// See [`RecommendationReportDetails`](crate::model::RecommendationReportDetails)
pub mod recommendation_report_details {
    /// A builder for [`RecommendationReportDetails`](crate::model::RecommendationReportDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::RecommendationReportStatus>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) completion_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) s3_bucket: std::option::Option<std::string::String>,
        pub(crate) s3_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>
        /// The status of the recommendation report generation task.
        /// </p>
        pub fn status(mut self, input: crate::model::RecommendationReportStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>
        /// The status of the recommendation report generation task.
        /// </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::RecommendationReportStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>
        /// The status message for recommendation report generation.
        /// </p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>
        /// The status message for recommendation report generation.
        /// </p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// <p>
        /// The time that the recommendation report generation task starts.
        /// </p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>
        /// The time that the recommendation report generation task starts.
        /// </p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>
        /// The time that the recommendation report generation task completes.
        /// </p>
        pub fn completion_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.completion_time = Some(input);
            self
        }
        /// <p>
        /// The time that the recommendation report generation task completes.
        /// </p>
        pub fn set_completion_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.completion_time = input;
            self
        }
        /// <p>
        /// The S3 bucket where the report file is located.
        /// </p>
        pub fn s3_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket = Some(input.into());
            self
        }
        /// <p>
        /// The S3 bucket where the report file is located.
        /// </p>
        pub fn set_s3_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_bucket = input;
            self
        }
        /// Appends an item to `s3_keys`.
        ///
        /// To override the contents of this collection use [`set_s3_keys`](Self::set_s3_keys).
        ///
        /// <p>
        /// The Amazon S3 key name of the report file.
        /// </p>
        pub fn s3_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.s3_keys.unwrap_or_default();
            v.push(input.into());
            self.s3_keys = Some(v);
            self
        }
        /// <p>
        /// The Amazon S3 key name of the report file.
        /// </p>
        pub fn set_s3_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.s3_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`RecommendationReportDetails`](crate::model::RecommendationReportDetails)
        pub fn build(self) -> crate::model::RecommendationReportDetails {
            crate::model::RecommendationReportDetails {
                status: self.status,
                status_message: self.status_message,
                start_time: self.start_time,
                completion_time: self.completion_time,
                s3_bucket: self.s3_bucket,
                s3_keys: self.s3_keys,
            }
        }
    }
}
impl RecommendationReportDetails {
    /// Creates a new builder-style object to manufacture [`RecommendationReportDetails`](crate::model::RecommendationReportDetails)
    pub fn builder() -> crate::model::recommendation_report_details::Builder {
        crate::model::recommendation_report_details::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RecommendationReportStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Success,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RecommendationReportStatus {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => RecommendationReportStatus::Failed,
            "IN_PROGRESS" => RecommendationReportStatus::InProgress,
            "SUCCESS" => RecommendationReportStatus::Success,
            other => RecommendationReportStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RecommendationReportStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RecommendationReportStatus::from(s))
    }
}
impl RecommendationReportStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RecommendationReportStatus::Failed => "FAILED",
            RecommendationReportStatus::InProgress => "IN_PROGRESS",
            RecommendationReportStatus::Success => "SUCCESS",
            RecommendationReportStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAILED", "IN_PROGRESS", "SUCCESS"]
    }
}
impl AsRef<str> for RecommendationReportStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>
/// Contains the summary of the assessment results.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssessmentSummary {
    /// <p>
    /// List of ServerStrategySummary.
    /// </p>
    pub list_server_strategy_summary:
        std::option::Option<std::vec::Vec<crate::model::StrategySummary>>,
    /// <p>
    /// List of ApplicationComponentStrategySummary.
    /// </p>
    pub list_application_component_strategy_summary:
        std::option::Option<std::vec::Vec<crate::model::StrategySummary>>,
    /// <p>
    /// List of AntipatternSeveritySummary.
    /// </p>
    pub list_antipattern_severity_summary:
        std::option::Option<std::vec::Vec<crate::model::AntipatternSeveritySummary>>,
    /// <p>
    /// List of ApplicationComponentSummary.
    /// </p>
    pub list_application_component_summary:
        std::option::Option<std::vec::Vec<crate::model::ApplicationComponentSummary>>,
    /// <p>
    /// List of ServerSummary.
    /// </p>
    pub list_server_summary: std::option::Option<std::vec::Vec<crate::model::ServerSummary>>,
    /// <p>
    /// The Amazon S3 object containing the anti-pattern report.
    /// </p>
    pub antipattern_report_s3_object: std::option::Option<crate::model::S3Object>,
    /// <p>
    /// The status of the anti-pattern report.
    /// </p>
    pub antipattern_report_status: std::option::Option<crate::model::AntipatternReportStatus>,
    /// <p>
    /// The status message of the anti-pattern report.
    /// </p>
    pub antipattern_report_status_message: std::option::Option<std::string::String>,
    /// <p>
    /// The time the assessment was performed.
    /// </p>
    pub last_analyzed_timestamp: std::option::Option<aws_smithy_types::DateTime>,
}
impl AssessmentSummary {
    /// <p>
    /// List of ServerStrategySummary.
    /// </p>
    pub fn list_server_strategy_summary(
        &self,
    ) -> std::option::Option<&[crate::model::StrategySummary]> {
        self.list_server_strategy_summary.as_deref()
    }
    /// <p>
    /// List of ApplicationComponentStrategySummary.
    /// </p>
    pub fn list_application_component_strategy_summary(
        &self,
    ) -> std::option::Option<&[crate::model::StrategySummary]> {
        self.list_application_component_strategy_summary.as_deref()
    }
    /// <p>
    /// List of AntipatternSeveritySummary.
    /// </p>
    pub fn list_antipattern_severity_summary(
        &self,
    ) -> std::option::Option<&[crate::model::AntipatternSeveritySummary]> {
        self.list_antipattern_severity_summary.as_deref()
    }
    /// <p>
    /// List of ApplicationComponentSummary.
    /// </p>
    pub fn list_application_component_summary(
        &self,
    ) -> std::option::Option<&[crate::model::ApplicationComponentSummary]> {
        self.list_application_component_summary.as_deref()
    }
    /// <p>
    /// List of ServerSummary.
    /// </p>
    pub fn list_server_summary(&self) -> std::option::Option<&[crate::model::ServerSummary]> {
        self.list_server_summary.as_deref()
    }
    /// <p>
    /// The Amazon S3 object containing the anti-pattern report.
    /// </p>
    pub fn antipattern_report_s3_object(&self) -> std::option::Option<&crate::model::S3Object> {
        self.antipattern_report_s3_object.as_ref()
    }
    /// <p>
    /// The status of the anti-pattern report.
    /// </p>
    pub fn antipattern_report_status(
        &self,
    ) -> std::option::Option<&crate::model::AntipatternReportStatus> {
        self.antipattern_report_status.as_ref()
    }
    /// <p>
    /// The status message of the anti-pattern report.
    /// </p>
    pub fn antipattern_report_status_message(&self) -> std::option::Option<&str> {
        self.antipattern_report_status_message.as_deref()
    }
    /// <p>
    /// The time the assessment was performed.
    /// </p>
    pub fn last_analyzed_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_analyzed_timestamp.as_ref()
    }
}
impl std::fmt::Debug for AssessmentSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssessmentSummary");
        formatter.field(
            "list_server_strategy_summary",
            &self.list_server_strategy_summary,
        );
        formatter.field(
            "list_application_component_strategy_summary",
            &self.list_application_component_strategy_summary,
        );
        formatter.field(
            "list_antipattern_severity_summary",
            &self.list_antipattern_severity_summary,
        );
        formatter.field(
            "list_application_component_summary",
            &self.list_application_component_summary,
        );
        formatter.field("list_server_summary", &self.list_server_summary);
        formatter.field(
            "antipattern_report_s3_object",
            &self.antipattern_report_s3_object,
        );
        formatter.field("antipattern_report_status", &self.antipattern_report_status);
        formatter.field(
            "antipattern_report_status_message",
            &self.antipattern_report_status_message,
        );
        formatter.field("last_analyzed_timestamp", &self.last_analyzed_timestamp);
        formatter.finish()
    }
}
/// See [`AssessmentSummary`](crate::model::AssessmentSummary)
pub mod assessment_summary {
    /// A builder for [`AssessmentSummary`](crate::model::AssessmentSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) list_server_strategy_summary:
            std::option::Option<std::vec::Vec<crate::model::StrategySummary>>,
        pub(crate) list_application_component_strategy_summary:
            std::option::Option<std::vec::Vec<crate::model::StrategySummary>>,
        pub(crate) list_antipattern_severity_summary:
            std::option::Option<std::vec::Vec<crate::model::AntipatternSeveritySummary>>,
        pub(crate) list_application_component_summary:
            std::option::Option<std::vec::Vec<crate::model::ApplicationComponentSummary>>,
        pub(crate) list_server_summary:
            std::option::Option<std::vec::Vec<crate::model::ServerSummary>>,
        pub(crate) antipattern_report_s3_object: std::option::Option<crate::model::S3Object>,
        pub(crate) antipattern_report_status:
            std::option::Option<crate::model::AntipatternReportStatus>,
        pub(crate) antipattern_report_status_message: std::option::Option<std::string::String>,
        pub(crate) last_analyzed_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// Appends an item to `list_server_strategy_summary`.
        ///
        /// To override the contents of this collection use [`set_list_server_strategy_summary`](Self::set_list_server_strategy_summary).
        ///
        /// <p>
        /// List of ServerStrategySummary.
        /// </p>
        pub fn list_server_strategy_summary(
            mut self,
            input: impl Into<crate::model::StrategySummary>,
        ) -> Self {
            let mut v = self.list_server_strategy_summary.unwrap_or_default();
            v.push(input.into());
            self.list_server_strategy_summary = Some(v);
            self
        }
        /// <p>
        /// List of ServerStrategySummary.
        /// </p>
        pub fn set_list_server_strategy_summary(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StrategySummary>>,
        ) -> Self {
            self.list_server_strategy_summary = input;
            self
        }
        /// Appends an item to `list_application_component_strategy_summary`.
        ///
        /// To override the contents of this collection use [`set_list_application_component_strategy_summary`](Self::set_list_application_component_strategy_summary).
        ///
        /// <p>
        /// List of ApplicationComponentStrategySummary.
        /// </p>
        pub fn list_application_component_strategy_summary(
            mut self,
            input: impl Into<crate::model::StrategySummary>,
        ) -> Self {
            let mut v = self
                .list_application_component_strategy_summary
                .unwrap_or_default();
            v.push(input.into());
            self.list_application_component_strategy_summary = Some(v);
            self
        }
        /// <p>
        /// List of ApplicationComponentStrategySummary.
        /// </p>
        pub fn set_list_application_component_strategy_summary(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StrategySummary>>,
        ) -> Self {
            self.list_application_component_strategy_summary = input;
            self
        }
        /// Appends an item to `list_antipattern_severity_summary`.
        ///
        /// To override the contents of this collection use [`set_list_antipattern_severity_summary`](Self::set_list_antipattern_severity_summary).
        ///
        /// <p>
        /// List of AntipatternSeveritySummary.
        /// </p>
        pub fn list_antipattern_severity_summary(
            mut self,
            input: impl Into<crate::model::AntipatternSeveritySummary>,
        ) -> Self {
            let mut v = self.list_antipattern_severity_summary.unwrap_or_default();
            v.push(input.into());
            self.list_antipattern_severity_summary = Some(v);
            self
        }
        /// <p>
        /// List of AntipatternSeveritySummary.
        /// </p>
        pub fn set_list_antipattern_severity_summary(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AntipatternSeveritySummary>>,
        ) -> Self {
            self.list_antipattern_severity_summary = input;
            self
        }
        /// Appends an item to `list_application_component_summary`.
        ///
        /// To override the contents of this collection use [`set_list_application_component_summary`](Self::set_list_application_component_summary).
        ///
        /// <p>
        /// List of ApplicationComponentSummary.
        /// </p>
        pub fn list_application_component_summary(
            mut self,
            input: impl Into<crate::model::ApplicationComponentSummary>,
        ) -> Self {
            let mut v = self.list_application_component_summary.unwrap_or_default();
            v.push(input.into());
            self.list_application_component_summary = Some(v);
            self
        }
        /// <p>
        /// List of ApplicationComponentSummary.
        /// </p>
        pub fn set_list_application_component_summary(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ApplicationComponentSummary>>,
        ) -> Self {
            self.list_application_component_summary = input;
            self
        }
        /// Appends an item to `list_server_summary`.
        ///
        /// To override the contents of this collection use [`set_list_server_summary`](Self::set_list_server_summary).
        ///
        /// <p>
        /// List of ServerSummary.
        /// </p>
        pub fn list_server_summary(
            mut self,
            input: impl Into<crate::model::ServerSummary>,
        ) -> Self {
            let mut v = self.list_server_summary.unwrap_or_default();
            v.push(input.into());
            self.list_server_summary = Some(v);
            self
        }
        /// <p>
        /// List of ServerSummary.
        /// </p>
        pub fn set_list_server_summary(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ServerSummary>>,
        ) -> Self {
            self.list_server_summary = input;
            self
        }
        /// <p>
        /// The Amazon S3 object containing the anti-pattern report.
        /// </p>
        pub fn antipattern_report_s3_object(mut self, input: crate::model::S3Object) -> Self {
            self.antipattern_report_s3_object = Some(input);
            self
        }
        /// <p>
        /// The Amazon S3 object containing the anti-pattern report.
        /// </p>
        pub fn set_antipattern_report_s3_object(
            mut self,
            input: std::option::Option<crate::model::S3Object>,
        ) -> Self {
            self.antipattern_report_s3_object = input;
            self
        }
        /// <p>
        /// The status of the anti-pattern report.
        /// </p>
        pub fn antipattern_report_status(
            mut self,
            input: crate::model::AntipatternReportStatus,
        ) -> Self {
            self.antipattern_report_status = Some(input);
            self
        }
        /// <p>
        /// The status of the anti-pattern report.
        /// </p>
        pub fn set_antipattern_report_status(
            mut self,
            input: std::option::Option<crate::model::AntipatternReportStatus>,
        ) -> Self {
            self.antipattern_report_status = input;
            self
        }
        /// <p>
        /// The status message of the anti-pattern report.
        /// </p>
        pub fn antipattern_report_status_message(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.antipattern_report_status_message = Some(input.into());
            self
        }
        /// <p>
        /// The status message of the anti-pattern report.
        /// </p>
        pub fn set_antipattern_report_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.antipattern_report_status_message = input;
            self
        }
        /// <p>
        /// The time the assessment was performed.
        /// </p>
        pub fn last_analyzed_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_analyzed_timestamp = Some(input);
            self
        }
        /// <p>
        /// The time the assessment was performed.
        /// </p>
        pub fn set_last_analyzed_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_analyzed_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`AssessmentSummary`](crate::model::AssessmentSummary)
        pub fn build(self) -> crate::model::AssessmentSummary {
            crate::model::AssessmentSummary {
                list_server_strategy_summary: self.list_server_strategy_summary,
                list_application_component_strategy_summary: self
                    .list_application_component_strategy_summary,
                list_antipattern_severity_summary: self.list_antipattern_severity_summary,
                list_application_component_summary: self.list_application_component_summary,
                list_server_summary: self.list_server_summary,
                antipattern_report_s3_object: self.antipattern_report_s3_object,
                antipattern_report_status: self.antipattern_report_status,
                antipattern_report_status_message: self.antipattern_report_status_message,
                last_analyzed_timestamp: self.last_analyzed_timestamp,
            }
        }
    }
}
impl AssessmentSummary {
    /// Creates a new builder-style object to manufacture [`AssessmentSummary`](crate::model::AssessmentSummary)
    pub fn builder() -> crate::model::assessment_summary::Builder {
        crate::model::assessment_summary::Builder::default()
    }
}

/// <p>
/// Object containing details about the servers imported by Application Discovery Service
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServerSummary {
    /// <p>
    /// Type of operating system for the servers.
    /// </p>
    pub server_os_type: std::option::Option<crate::model::ServerOsType>,
    /// <p>
    /// Number of servers.
    /// </p>
    pub count: std::option::Option<i32>,
}
impl ServerSummary {
    /// <p>
    /// Type of operating system for the servers.
    /// </p>
    pub fn server_os_type(&self) -> std::option::Option<&crate::model::ServerOsType> {
        self.server_os_type.as_ref()
    }
    /// <p>
    /// Number of servers.
    /// </p>
    pub fn count(&self) -> std::option::Option<i32> {
        self.count
    }
}
impl std::fmt::Debug for ServerSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServerSummary");
        formatter.field("server_os_type", &self.server_os_type);
        formatter.field("count", &self.count);
        formatter.finish()
    }
}
/// See [`ServerSummary`](crate::model::ServerSummary)
pub mod server_summary {
    /// A builder for [`ServerSummary`](crate::model::ServerSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) server_os_type: std::option::Option<crate::model::ServerOsType>,
        pub(crate) count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>
        /// Type of operating system for the servers.
        /// </p>
        pub fn server_os_type(mut self, input: crate::model::ServerOsType) -> Self {
            self.server_os_type = Some(input);
            self
        }
        /// <p>
        /// Type of operating system for the servers.
        /// </p>
        pub fn set_server_os_type(
            mut self,
            input: std::option::Option<crate::model::ServerOsType>,
        ) -> Self {
            self.server_os_type = input;
            self
        }
        /// <p>
        /// Number of servers.
        /// </p>
        pub fn count(mut self, input: i32) -> Self {
            self.count = Some(input);
            self
        }
        /// <p>
        /// Number of servers.
        /// </p>
        pub fn set_count(mut self, input: std::option::Option<i32>) -> Self {
            self.count = input;
            self
        }
        /// Consumes the builder and constructs a [`ServerSummary`](crate::model::ServerSummary)
        pub fn build(self) -> crate::model::ServerSummary {
            crate::model::ServerSummary {
                server_os_type: self.server_os_type,
                count: self.count,
            }
        }
    }
}
impl ServerSummary {
    /// Creates a new builder-style object to manufacture [`ServerSummary`](crate::model::ServerSummary)
    pub fn builder() -> crate::model::server_summary::Builder {
        crate::model::server_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ServerOsType {
    #[allow(missing_docs)] // documentation missing in model
    AmazonLinux,
    #[allow(missing_docs)] // documentation missing in model
    EndOfSupportWindowsServer,
    #[allow(missing_docs)] // documentation missing in model
    Other,
    #[allow(missing_docs)] // documentation missing in model
    Redhat,
    #[allow(missing_docs)] // documentation missing in model
    WindowsServer,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ServerOsType {
    fn from(s: &str) -> Self {
        match s {
            "AmazonLinux" => ServerOsType::AmazonLinux,
            "EndOfSupportWindowsServer" => ServerOsType::EndOfSupportWindowsServer,
            "Other" => ServerOsType::Other,
            "Redhat" => ServerOsType::Redhat,
            "WindowsServer" => ServerOsType::WindowsServer,
            other => ServerOsType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ServerOsType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ServerOsType::from(s))
    }
}
impl ServerOsType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ServerOsType::AmazonLinux => "AmazonLinux",
            ServerOsType::EndOfSupportWindowsServer => "EndOfSupportWindowsServer",
            ServerOsType::Other => "Other",
            ServerOsType::Redhat => "Redhat",
            ServerOsType::WindowsServer => "WindowsServer",
            ServerOsType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AmazonLinux",
            "EndOfSupportWindowsServer",
            "Other",
            "Redhat",
            "WindowsServer",
        ]
    }
}
impl AsRef<str> for ServerOsType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>
/// Contains the summary of application components.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApplicationComponentSummary {
    /// <p>
    /// Contains the name of application types.
    /// </p>
    pub app_type: std::option::Option<crate::model::AppType>,
    /// <p>
    /// Contains the count of application type.
    /// </p>
    pub count: std::option::Option<i32>,
}
impl ApplicationComponentSummary {
    /// <p>
    /// Contains the name of application types.
    /// </p>
    pub fn app_type(&self) -> std::option::Option<&crate::model::AppType> {
        self.app_type.as_ref()
    }
    /// <p>
    /// Contains the count of application type.
    /// </p>
    pub fn count(&self) -> std::option::Option<i32> {
        self.count
    }
}
impl std::fmt::Debug for ApplicationComponentSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApplicationComponentSummary");
        formatter.field("app_type", &self.app_type);
        formatter.field("count", &self.count);
        formatter.finish()
    }
}
/// See [`ApplicationComponentSummary`](crate::model::ApplicationComponentSummary)
pub mod application_component_summary {
    /// A builder for [`ApplicationComponentSummary`](crate::model::ApplicationComponentSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_type: std::option::Option<crate::model::AppType>,
        pub(crate) count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>
        /// Contains the name of application types.
        /// </p>
        pub fn app_type(mut self, input: crate::model::AppType) -> Self {
            self.app_type = Some(input);
            self
        }
        /// <p>
        /// Contains the name of application types.
        /// </p>
        pub fn set_app_type(mut self, input: std::option::Option<crate::model::AppType>) -> Self {
            self.app_type = input;
            self
        }
        /// <p>
        /// Contains the count of application type.
        /// </p>
        pub fn count(mut self, input: i32) -> Self {
            self.count = Some(input);
            self
        }
        /// <p>
        /// Contains the count of application type.
        /// </p>
        pub fn set_count(mut self, input: std::option::Option<i32>) -> Self {
            self.count = input;
            self
        }
        /// Consumes the builder and constructs a [`ApplicationComponentSummary`](crate::model::ApplicationComponentSummary)
        pub fn build(self) -> crate::model::ApplicationComponentSummary {
            crate::model::ApplicationComponentSummary {
                app_type: self.app_type,
                count: self.count,
            }
        }
    }
}
impl ApplicationComponentSummary {
    /// Creates a new builder-style object to manufacture [`ApplicationComponentSummary`](crate::model::ApplicationComponentSummary)
    pub fn builder() -> crate::model::application_component_summary::Builder {
        crate::model::application_component_summary::Builder::default()
    }
}

/// <p> Detailed information about an assessment. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataCollectionDetails {
    /// <p> The status of the assessment. </p>
    pub status: std::option::Option<crate::model::AssessmentStatus>,
    /// <p> The total number of servers in the assessment. </p>
    pub servers: std::option::Option<i32>,
    /// <p> The number of failed servers in the assessment. </p>
    pub failed: std::option::Option<i32>,
    /// <p> The number of successful servers in the assessment. </p>
    pub success: std::option::Option<i32>,
    /// <p> The number of servers with the assessment status <code>IN_PROGESS</code>. </p>
    pub in_progress: std::option::Option<i32>,
    /// <p> The start time of assessment. </p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> The time the assessment completes. </p>
    pub completion_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl DataCollectionDetails {
    /// <p> The status of the assessment. </p>
    pub fn status(&self) -> std::option::Option<&crate::model::AssessmentStatus> {
        self.status.as_ref()
    }
    /// <p> The total number of servers in the assessment. </p>
    pub fn servers(&self) -> std::option::Option<i32> {
        self.servers
    }
    /// <p> The number of failed servers in the assessment. </p>
    pub fn failed(&self) -> std::option::Option<i32> {
        self.failed
    }
    /// <p> The number of successful servers in the assessment. </p>
    pub fn success(&self) -> std::option::Option<i32> {
        self.success
    }
    /// <p> The number of servers with the assessment status <code>IN_PROGESS</code>. </p>
    pub fn in_progress(&self) -> std::option::Option<i32> {
        self.in_progress
    }
    /// <p> The start time of assessment. </p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p> The time the assessment completes. </p>
    pub fn completion_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.completion_time.as_ref()
    }
}
impl std::fmt::Debug for DataCollectionDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataCollectionDetails");
        formatter.field("status", &self.status);
        formatter.field("servers", &self.servers);
        formatter.field("failed", &self.failed);
        formatter.field("success", &self.success);
        formatter.field("in_progress", &self.in_progress);
        formatter.field("start_time", &self.start_time);
        formatter.field("completion_time", &self.completion_time);
        formatter.finish()
    }
}
/// See [`DataCollectionDetails`](crate::model::DataCollectionDetails)
pub mod data_collection_details {
    /// A builder for [`DataCollectionDetails`](crate::model::DataCollectionDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::AssessmentStatus>,
        pub(crate) servers: std::option::Option<i32>,
        pub(crate) failed: std::option::Option<i32>,
        pub(crate) success: std::option::Option<i32>,
        pub(crate) in_progress: std::option::Option<i32>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) completion_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p> The status of the assessment. </p>
        pub fn status(mut self, input: crate::model::AssessmentStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p> The status of the assessment. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AssessmentStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p> The total number of servers in the assessment. </p>
        pub fn servers(mut self, input: i32) -> Self {
            self.servers = Some(input);
            self
        }
        /// <p> The total number of servers in the assessment. </p>
        pub fn set_servers(mut self, input: std::option::Option<i32>) -> Self {
            self.servers = input;
            self
        }
        /// <p> The number of failed servers in the assessment. </p>
        pub fn failed(mut self, input: i32) -> Self {
            self.failed = Some(input);
            self
        }
        /// <p> The number of failed servers in the assessment. </p>
        pub fn set_failed(mut self, input: std::option::Option<i32>) -> Self {
            self.failed = input;
            self
        }
        /// <p> The number of successful servers in the assessment. </p>
        pub fn success(mut self, input: i32) -> Self {
            self.success = Some(input);
            self
        }
        /// <p> The number of successful servers in the assessment. </p>
        pub fn set_success(mut self, input: std::option::Option<i32>) -> Self {
            self.success = input;
            self
        }
        /// <p> The number of servers with the assessment status <code>IN_PROGESS</code>. </p>
        pub fn in_progress(mut self, input: i32) -> Self {
            self.in_progress = Some(input);
            self
        }
        /// <p> The number of servers with the assessment status <code>IN_PROGESS</code>. </p>
        pub fn set_in_progress(mut self, input: std::option::Option<i32>) -> Self {
            self.in_progress = input;
            self
        }
        /// <p> The start time of assessment. </p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p> The start time of assessment. </p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p> The time the assessment completes. </p>
        pub fn completion_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.completion_time = Some(input);
            self
        }
        /// <p> The time the assessment completes. </p>
        pub fn set_completion_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.completion_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DataCollectionDetails`](crate::model::DataCollectionDetails)
        pub fn build(self) -> crate::model::DataCollectionDetails {
            crate::model::DataCollectionDetails {
                status: self.status,
                servers: self.servers,
                failed: self.failed,
                success: self.success,
                in_progress: self.in_progress,
                start_time: self.start_time,
                completion_time: self.completion_time,
            }
        }
    }
}
impl DataCollectionDetails {
    /// Creates a new builder-style object to manufacture [`DataCollectionDetails`](crate::model::DataCollectionDetails)
    pub fn builder() -> crate::model::data_collection_details::Builder {
        crate::model::data_collection_details::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AssessmentStatus {
    #[allow(missing_docs)] // documentation missing in model
    Complete,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Stopped,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AssessmentStatus {
    fn from(s: &str) -> Self {
        match s {
            "COMPLETE" => AssessmentStatus::Complete,
            "FAILED" => AssessmentStatus::Failed,
            "IN_PROGRESS" => AssessmentStatus::InProgress,
            "STOPPED" => AssessmentStatus::Stopped,
            other => AssessmentStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AssessmentStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AssessmentStatus::from(s))
    }
}
impl AssessmentStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AssessmentStatus::Complete => "COMPLETE",
            AssessmentStatus::Failed => "FAILED",
            AssessmentStatus::InProgress => "IN_PROGRESS",
            AssessmentStatus::Stopped => "STOPPED",
            AssessmentStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COMPLETE", "FAILED", "IN_PROGRESS", "STOPPED"]
    }
}
impl AsRef<str> for AssessmentStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> Contains information about a strategy recommendation for an application component.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApplicationComponentStrategy {
    /// <p> Strategy recommendation for the application component. </p>
    pub recommendation: std::option::Option<crate::model::RecommendationSet>,
    /// <p> The recommendation status of a strategy for an application component. </p>
    pub status: std::option::Option<crate::model::StrategyRecommendation>,
    /// <p> Set to true if the recommendation is set as preferred. </p>
    pub is_preferred: std::option::Option<bool>,
}
impl ApplicationComponentStrategy {
    /// <p> Strategy recommendation for the application component. </p>
    pub fn recommendation(&self) -> std::option::Option<&crate::model::RecommendationSet> {
        self.recommendation.as_ref()
    }
    /// <p> The recommendation status of a strategy for an application component. </p>
    pub fn status(&self) -> std::option::Option<&crate::model::StrategyRecommendation> {
        self.status.as_ref()
    }
    /// <p> Set to true if the recommendation is set as preferred. </p>
    pub fn is_preferred(&self) -> std::option::Option<bool> {
        self.is_preferred
    }
}
impl std::fmt::Debug for ApplicationComponentStrategy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApplicationComponentStrategy");
        formatter.field("recommendation", &self.recommendation);
        formatter.field("status", &self.status);
        formatter.field("is_preferred", &self.is_preferred);
        formatter.finish()
    }
}
/// See [`ApplicationComponentStrategy`](crate::model::ApplicationComponentStrategy)
pub mod application_component_strategy {
    /// A builder for [`ApplicationComponentStrategy`](crate::model::ApplicationComponentStrategy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recommendation: std::option::Option<crate::model::RecommendationSet>,
        pub(crate) status: std::option::Option<crate::model::StrategyRecommendation>,
        pub(crate) is_preferred: std::option::Option<bool>,
    }
    impl Builder {
        /// <p> Strategy recommendation for the application component. </p>
        pub fn recommendation(mut self, input: crate::model::RecommendationSet) -> Self {
            self.recommendation = Some(input);
            self
        }
        /// <p> Strategy recommendation for the application component. </p>
        pub fn set_recommendation(
            mut self,
            input: std::option::Option<crate::model::RecommendationSet>,
        ) -> Self {
            self.recommendation = input;
            self
        }
        /// <p> The recommendation status of a strategy for an application component. </p>
        pub fn status(mut self, input: crate::model::StrategyRecommendation) -> Self {
            self.status = Some(input);
            self
        }
        /// <p> The recommendation status of a strategy for an application component. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::StrategyRecommendation>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p> Set to true if the recommendation is set as preferred. </p>
        pub fn is_preferred(mut self, input: bool) -> Self {
            self.is_preferred = Some(input);
            self
        }
        /// <p> Set to true if the recommendation is set as preferred. </p>
        pub fn set_is_preferred(mut self, input: std::option::Option<bool>) -> Self {
            self.is_preferred = input;
            self
        }
        /// Consumes the builder and constructs a [`ApplicationComponentStrategy`](crate::model::ApplicationComponentStrategy)
        pub fn build(self) -> crate::model::ApplicationComponentStrategy {
            crate::model::ApplicationComponentStrategy {
                recommendation: self.recommendation,
                status: self.status,
                is_preferred: self.is_preferred,
            }
        }
    }
}
impl ApplicationComponentStrategy {
    /// Creates a new builder-style object to manufacture [`ApplicationComponentStrategy`](crate::model::ApplicationComponentStrategy)
    pub fn builder() -> crate::model::application_component_strategy::Builder {
        crate::model::application_component_strategy::Builder::default()
    }
}
