// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `GetApplicationComponentDetails` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetApplicationComponentDetailsError {
    /// Kind of error that occurred.
    pub kind: GetApplicationComponentDetailsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetApplicationComponentDetails` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetApplicationComponentDetailsErrorKind {
    /// <p> The server experienced an internal error. Try again. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The specified ID in the request is not found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request was denied due to request throttling. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetApplicationComponentDetailsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetApplicationComponentDetailsErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            GetApplicationComponentDetailsErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetApplicationComponentDetailsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetApplicationComponentDetailsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetApplicationComponentDetailsError {
    fn code(&self) -> Option<&str> {
        GetApplicationComponentDetailsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetApplicationComponentDetailsError {
    /// Creates a new `GetApplicationComponentDetailsError`.
    pub fn new(
        kind: GetApplicationComponentDetailsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetApplicationComponentDetailsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetApplicationComponentDetailsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetApplicationComponentDetailsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetApplicationComponentDetailsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetApplicationComponentDetailsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApplicationComponentDetailsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetApplicationComponentDetailsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApplicationComponentDetailsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetApplicationComponentDetailsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApplicationComponentDetailsErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for GetApplicationComponentDetailsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetApplicationComponentDetailsErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            GetApplicationComponentDetailsErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            GetApplicationComponentDetailsErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetApplicationComponentDetailsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetApplicationComponentStrategies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetApplicationComponentStrategiesError {
    /// Kind of error that occurred.
    pub kind: GetApplicationComponentStrategiesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetApplicationComponentStrategies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetApplicationComponentStrategiesErrorKind {
    /// <p> The server experienced an internal error. Try again. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The specified ID in the request is not found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request was denied due to request throttling. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetApplicationComponentStrategiesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetApplicationComponentStrategiesErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            GetApplicationComponentStrategiesErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetApplicationComponentStrategiesErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            GetApplicationComponentStrategiesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetApplicationComponentStrategiesError {
    fn code(&self) -> Option<&str> {
        GetApplicationComponentStrategiesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetApplicationComponentStrategiesError {
    /// Creates a new `GetApplicationComponentStrategiesError`.
    pub fn new(
        kind: GetApplicationComponentStrategiesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetApplicationComponentStrategiesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetApplicationComponentStrategiesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetApplicationComponentStrategiesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetApplicationComponentStrategiesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetApplicationComponentStrategiesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApplicationComponentStrategiesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetApplicationComponentStrategiesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApplicationComponentStrategiesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetApplicationComponentStrategiesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApplicationComponentStrategiesErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for GetApplicationComponentStrategiesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetApplicationComponentStrategiesErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            GetApplicationComponentStrategiesErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            GetApplicationComponentStrategiesErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetApplicationComponentStrategiesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetAssessment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAssessmentError {
    /// Kind of error that occurred.
    pub kind: GetAssessmentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAssessment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAssessmentErrorKind {
    /// <p> The AWS user account does not have permission to perform the action. Check the
    /// AWS Identity and Access Management (IAM) policy associated with this account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> The server experienced an internal error. Try again. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The specified ID in the request is not found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request was denied due to request throttling. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAssessmentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAssessmentErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetAssessmentErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetAssessmentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetAssessmentErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetAssessmentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAssessmentError {
    fn code(&self) -> Option<&str> {
        GetAssessmentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAssessmentError {
    /// Creates a new `GetAssessmentError`.
    pub fn new(kind: GetAssessmentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAssessmentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAssessmentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAssessmentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAssessmentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetAssessmentErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetAssessmentErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetAssessmentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAssessmentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAssessmentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAssessmentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAssessmentErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetAssessmentErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for GetAssessmentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAssessmentErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetAssessmentErrorKind::InternalServerException(_inner) => Some(_inner),
            GetAssessmentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetAssessmentErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetAssessmentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetImportFileTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetImportFileTaskError {
    /// Kind of error that occurred.
    pub kind: GetImportFileTaskErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetImportFileTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetImportFileTaskErrorKind {
    /// <p> The AWS user account does not have permission to perform the action. Check the
    /// AWS Identity and Access Management (IAM) policy associated with this account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> The server experienced an internal error. Try again. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The specified ID in the request is not found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request was denied due to request throttling. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p> The request body isn't valid. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetImportFileTaskError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetImportFileTaskErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetImportFileTaskErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetImportFileTaskErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetImportFileTaskErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetImportFileTaskErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetImportFileTaskErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetImportFileTaskError {
    fn code(&self) -> Option<&str> {
        GetImportFileTaskError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetImportFileTaskError {
    /// Creates a new `GetImportFileTaskError`.
    pub fn new(kind: GetImportFileTaskErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetImportFileTaskError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetImportFileTaskErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetImportFileTaskError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetImportFileTaskErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetImportFileTaskErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetImportFileTaskErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetImportFileTaskErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetImportFileTaskErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetImportFileTaskErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetImportFileTaskErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetImportFileTaskErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetImportFileTaskErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetImportFileTaskErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetImportFileTaskErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetImportFileTaskError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetImportFileTaskErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetImportFileTaskErrorKind::InternalServerException(_inner) => Some(_inner),
            GetImportFileTaskErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetImportFileTaskErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetImportFileTaskErrorKind::ValidationException(_inner) => Some(_inner),
            GetImportFileTaskErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetPortfolioPreferences` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetPortfolioPreferencesError {
    /// Kind of error that occurred.
    pub kind: GetPortfolioPreferencesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetPortfolioPreferences` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetPortfolioPreferencesErrorKind {
    /// <p> The AWS user account does not have permission to perform the action. Check the
    /// AWS Identity and Access Management (IAM) policy associated with this account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> The server experienced an internal error. Try again. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The specified ID in the request is not found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request was denied due to request throttling. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetPortfolioPreferencesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetPortfolioPreferencesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetPortfolioPreferencesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetPortfolioPreferencesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetPortfolioPreferencesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetPortfolioPreferencesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetPortfolioPreferencesError {
    fn code(&self) -> Option<&str> {
        GetPortfolioPreferencesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetPortfolioPreferencesError {
    /// Creates a new `GetPortfolioPreferencesError`.
    pub fn new(kind: GetPortfolioPreferencesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetPortfolioPreferencesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetPortfolioPreferencesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetPortfolioPreferencesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetPortfolioPreferencesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetPortfolioPreferencesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPortfolioPreferencesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPortfolioPreferencesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPortfolioPreferencesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPortfolioPreferencesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPortfolioPreferencesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPortfolioPreferencesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPortfolioPreferencesErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for GetPortfolioPreferencesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetPortfolioPreferencesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetPortfolioPreferencesErrorKind::InternalServerException(_inner) => Some(_inner),
            GetPortfolioPreferencesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetPortfolioPreferencesErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetPortfolioPreferencesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetPortfolioSummary` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetPortfolioSummaryError {
    /// Kind of error that occurred.
    pub kind: GetPortfolioSummaryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetPortfolioSummary` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetPortfolioSummaryErrorKind {
    /// <p> The AWS user account does not have permission to perform the action. Check the
    /// AWS Identity and Access Management (IAM) policy associated with this account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> The server experienced an internal error. Try again. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The request was denied due to request throttling. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetPortfolioSummaryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetPortfolioSummaryErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetPortfolioSummaryErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetPortfolioSummaryErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetPortfolioSummaryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetPortfolioSummaryError {
    fn code(&self) -> Option<&str> {
        GetPortfolioSummaryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetPortfolioSummaryError {
    /// Creates a new `GetPortfolioSummaryError`.
    pub fn new(kind: GetPortfolioSummaryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetPortfolioSummaryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetPortfolioSummaryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetPortfolioSummaryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetPortfolioSummaryErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetPortfolioSummaryErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPortfolioSummaryErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPortfolioSummaryErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPortfolioSummaryErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPortfolioSummaryErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPortfolioSummaryErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for GetPortfolioSummaryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetPortfolioSummaryErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetPortfolioSummaryErrorKind::InternalServerException(_inner) => Some(_inner),
            GetPortfolioSummaryErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetPortfolioSummaryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRecommendationReportDetails` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRecommendationReportDetailsError {
    /// Kind of error that occurred.
    pub kind: GetRecommendationReportDetailsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRecommendationReportDetails` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRecommendationReportDetailsErrorKind {
    /// <p> The AWS user account does not have permission to perform the action. Check the
    /// AWS Identity and Access Management (IAM) policy associated with this account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> The server experienced an internal error. Try again. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The specified ID in the request is not found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request was denied due to request throttling. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p> The request body isn't valid. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRecommendationReportDetailsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRecommendationReportDetailsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetRecommendationReportDetailsErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            GetRecommendationReportDetailsErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetRecommendationReportDetailsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetRecommendationReportDetailsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetRecommendationReportDetailsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRecommendationReportDetailsError {
    fn code(&self) -> Option<&str> {
        GetRecommendationReportDetailsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRecommendationReportDetailsError {
    /// Creates a new `GetRecommendationReportDetailsError`.
    pub fn new(
        kind: GetRecommendationReportDetailsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRecommendationReportDetailsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRecommendationReportDetailsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRecommendationReportDetailsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRecommendationReportDetailsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetRecommendationReportDetailsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRecommendationReportDetailsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRecommendationReportDetailsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRecommendationReportDetailsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRecommendationReportDetailsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRecommendationReportDetailsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRecommendationReportDetailsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRecommendationReportDetailsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRecommendationReportDetailsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRecommendationReportDetailsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetRecommendationReportDetailsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRecommendationReportDetailsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetRecommendationReportDetailsErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            GetRecommendationReportDetailsErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            GetRecommendationReportDetailsErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetRecommendationReportDetailsErrorKind::ValidationException(_inner) => Some(_inner),
            GetRecommendationReportDetailsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetServerDetails` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetServerDetailsError {
    /// Kind of error that occurred.
    pub kind: GetServerDetailsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetServerDetails` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetServerDetailsErrorKind {
    /// <p> The AWS user account does not have permission to perform the action. Check the
    /// AWS Identity and Access Management (IAM) policy associated with this account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> The server experienced an internal error. Try again. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The specified ID in the request is not found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request was denied due to request throttling. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p> The request body isn't valid. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetServerDetailsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetServerDetailsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetServerDetailsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetServerDetailsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetServerDetailsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetServerDetailsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetServerDetailsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetServerDetailsError {
    fn code(&self) -> Option<&str> {
        GetServerDetailsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetServerDetailsError {
    /// Creates a new `GetServerDetailsError`.
    pub fn new(kind: GetServerDetailsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetServerDetailsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetServerDetailsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetServerDetailsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetServerDetailsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetServerDetailsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServerDetailsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetServerDetailsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServerDetailsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetServerDetailsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServerDetailsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetServerDetailsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServerDetailsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetServerDetailsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServerDetailsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetServerDetailsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetServerDetailsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetServerDetailsErrorKind::InternalServerException(_inner) => Some(_inner),
            GetServerDetailsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetServerDetailsErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetServerDetailsErrorKind::ValidationException(_inner) => Some(_inner),
            GetServerDetailsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetServerStrategies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetServerStrategiesError {
    /// Kind of error that occurred.
    pub kind: GetServerStrategiesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetServerStrategies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetServerStrategiesErrorKind {
    /// <p> The AWS user account does not have permission to perform the action. Check the
    /// AWS Identity and Access Management (IAM) policy associated with this account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> The server experienced an internal error. Try again. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The specified ID in the request is not found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request was denied due to request throttling. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p> The request body isn't valid. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetServerStrategiesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetServerStrategiesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetServerStrategiesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetServerStrategiesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetServerStrategiesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetServerStrategiesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetServerStrategiesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetServerStrategiesError {
    fn code(&self) -> Option<&str> {
        GetServerStrategiesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetServerStrategiesError {
    /// Creates a new `GetServerStrategiesError`.
    pub fn new(kind: GetServerStrategiesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetServerStrategiesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetServerStrategiesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetServerStrategiesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetServerStrategiesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetServerStrategiesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServerStrategiesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetServerStrategiesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServerStrategiesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetServerStrategiesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServerStrategiesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetServerStrategiesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServerStrategiesErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetServerStrategiesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServerStrategiesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetServerStrategiesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetServerStrategiesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetServerStrategiesErrorKind::InternalServerException(_inner) => Some(_inner),
            GetServerStrategiesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetServerStrategiesErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetServerStrategiesErrorKind::ValidationException(_inner) => Some(_inner),
            GetServerStrategiesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListApplicationComponents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListApplicationComponentsError {
    /// Kind of error that occurred.
    pub kind: ListApplicationComponentsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListApplicationComponents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListApplicationComponentsErrorKind {
    /// <p> The AWS user account does not have permission to perform the action. Check the
    /// AWS Identity and Access Management (IAM) policy associated with this account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> The server experienced an internal error. Try again. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>
    /// Exception to indicate that the service-linked role (SLR) is locked.
    /// </p>
    ServiceLinkedRoleLockClientException(crate::error::ServiceLinkedRoleLockClientException),
    /// <p> The request body isn't valid. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListApplicationComponentsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListApplicationComponentsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListApplicationComponentsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListApplicationComponentsErrorKind::ServiceLinkedRoleLockClientException(_inner) => {
                _inner.fmt(f)
            }
            ListApplicationComponentsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListApplicationComponentsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListApplicationComponentsError {
    fn code(&self) -> Option<&str> {
        ListApplicationComponentsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListApplicationComponentsError {
    /// Creates a new `ListApplicationComponentsError`.
    pub fn new(kind: ListApplicationComponentsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListApplicationComponentsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListApplicationComponentsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListApplicationComponentsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListApplicationComponentsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListApplicationComponentsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListApplicationComponentsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListApplicationComponentsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListApplicationComponentsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListApplicationComponentsErrorKind::ServiceLinkedRoleLockClientException`.
    pub fn is_service_linked_role_lock_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListApplicationComponentsErrorKind::ServiceLinkedRoleLockClientException(_)
        )
    }
    /// Returns `true` if the error kind is `ListApplicationComponentsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListApplicationComponentsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListApplicationComponentsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListApplicationComponentsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListApplicationComponentsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListApplicationComponentsErrorKind::ServiceLinkedRoleLockClientException(_inner) => {
                Some(_inner)
            }
            ListApplicationComponentsErrorKind::ValidationException(_inner) => Some(_inner),
            ListApplicationComponentsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListCollectors` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListCollectorsError {
    /// Kind of error that occurred.
    pub kind: ListCollectorsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListCollectors` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListCollectorsErrorKind {
    /// <p> The AWS user account does not have permission to perform the action. Check the
    /// AWS Identity and Access Management (IAM) policy associated with this account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> The server experienced an internal error. Try again. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The request was denied due to request throttling. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p> The request body isn't valid. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListCollectorsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListCollectorsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListCollectorsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListCollectorsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListCollectorsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListCollectorsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListCollectorsError {
    fn code(&self) -> Option<&str> {
        ListCollectorsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListCollectorsError {
    /// Creates a new `ListCollectorsError`.
    pub fn new(kind: ListCollectorsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListCollectorsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListCollectorsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListCollectorsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListCollectorsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListCollectorsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCollectorsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListCollectorsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCollectorsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListCollectorsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListCollectorsErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListCollectorsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListCollectorsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListCollectorsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListCollectorsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListCollectorsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListCollectorsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListCollectorsErrorKind::ValidationException(_inner) => Some(_inner),
            ListCollectorsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListImportFileTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListImportFileTaskError {
    /// Kind of error that occurred.
    pub kind: ListImportFileTaskErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListImportFileTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListImportFileTaskErrorKind {
    /// <p> The AWS user account does not have permission to perform the action. Check the
    /// AWS Identity and Access Management (IAM) policy associated with this account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> The server experienced an internal error. Try again. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The request was denied due to request throttling. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p> The request body isn't valid. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListImportFileTaskError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListImportFileTaskErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListImportFileTaskErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListImportFileTaskErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListImportFileTaskErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListImportFileTaskErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListImportFileTaskError {
    fn code(&self) -> Option<&str> {
        ListImportFileTaskError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListImportFileTaskError {
    /// Creates a new `ListImportFileTaskError`.
    pub fn new(kind: ListImportFileTaskErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListImportFileTaskError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListImportFileTaskErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListImportFileTaskError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListImportFileTaskErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListImportFileTaskErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListImportFileTaskErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListImportFileTaskErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListImportFileTaskErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListImportFileTaskErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListImportFileTaskErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListImportFileTaskErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListImportFileTaskErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListImportFileTaskError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListImportFileTaskErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListImportFileTaskErrorKind::InternalServerException(_inner) => Some(_inner),
            ListImportFileTaskErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListImportFileTaskErrorKind::ValidationException(_inner) => Some(_inner),
            ListImportFileTaskErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListServers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListServersError {
    /// Kind of error that occurred.
    pub kind: ListServersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListServers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListServersErrorKind {
    /// <p> The AWS user account does not have permission to perform the action. Check the
    /// AWS Identity and Access Management (IAM) policy associated with this account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> The server experienced an internal error. Try again. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The request was denied due to request throttling. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p> The request body isn't valid. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListServersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListServersErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListServersErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListServersErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListServersErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListServersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListServersError {
    fn code(&self) -> Option<&str> {
        ListServersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListServersError {
    /// Creates a new `ListServersError`.
    pub fn new(kind: ListServersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListServersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListServersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListServersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListServersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListServersErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListServersErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `ListServersErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, ListServersErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `ListServersErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListServersErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListServersErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListServersErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListServersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListServersErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListServersErrorKind::InternalServerException(_inner) => Some(_inner),
            ListServersErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListServersErrorKind::ValidationException(_inner) => Some(_inner),
            ListServersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutPortfolioPreferences` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutPortfolioPreferencesError {
    /// Kind of error that occurred.
    pub kind: PutPortfolioPreferencesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutPortfolioPreferences` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutPortfolioPreferencesErrorKind {
    /// <p> The AWS user account does not have permission to perform the action. Check the
    /// AWS Identity and Access Management (IAM) policy associated with this account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>
    /// Exception to indicate that there is an ongoing task when a new task is created.
    /// Return when once the existing tasks are complete.
    /// </p>
    ConflictException(crate::error::ConflictException),
    /// <p> The server experienced an internal error. Try again. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The request was denied due to request throttling. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p> The request body isn't valid. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutPortfolioPreferencesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutPortfolioPreferencesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            PutPortfolioPreferencesErrorKind::ConflictException(_inner) => _inner.fmt(f),
            PutPortfolioPreferencesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            PutPortfolioPreferencesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            PutPortfolioPreferencesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            PutPortfolioPreferencesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutPortfolioPreferencesError {
    fn code(&self) -> Option<&str> {
        PutPortfolioPreferencesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutPortfolioPreferencesError {
    /// Creates a new `PutPortfolioPreferencesError`.
    pub fn new(kind: PutPortfolioPreferencesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutPortfolioPreferencesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutPortfolioPreferencesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutPortfolioPreferencesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutPortfolioPreferencesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutPortfolioPreferencesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutPortfolioPreferencesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `PutPortfolioPreferencesErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutPortfolioPreferencesErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `PutPortfolioPreferencesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutPortfolioPreferencesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `PutPortfolioPreferencesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutPortfolioPreferencesErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `PutPortfolioPreferencesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutPortfolioPreferencesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for PutPortfolioPreferencesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutPortfolioPreferencesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            PutPortfolioPreferencesErrorKind::ConflictException(_inner) => Some(_inner),
            PutPortfolioPreferencesErrorKind::InternalServerException(_inner) => Some(_inner),
            PutPortfolioPreferencesErrorKind::ThrottlingException(_inner) => Some(_inner),
            PutPortfolioPreferencesErrorKind::ValidationException(_inner) => Some(_inner),
            PutPortfolioPreferencesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartAssessment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartAssessmentError {
    /// Kind of error that occurred.
    pub kind: StartAssessmentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartAssessment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartAssessmentErrorKind {
    /// <p> The AWS user account does not have permission to perform the action. Check the
    /// AWS Identity and Access Management (IAM) policy associated with this account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> The server experienced an internal error. Try again. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The AWS account has reached its quota of imports. Contact AWS Support to increase the
    /// quota for this account. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p> The request was denied due to request throttling. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartAssessmentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartAssessmentErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            StartAssessmentErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            StartAssessmentErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            StartAssessmentErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            StartAssessmentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartAssessmentError {
    fn code(&self) -> Option<&str> {
        StartAssessmentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartAssessmentError {
    /// Creates a new `StartAssessmentError`.
    pub fn new(kind: StartAssessmentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartAssessmentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartAssessmentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartAssessmentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartAssessmentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartAssessmentErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartAssessmentErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `StartAssessmentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartAssessmentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `StartAssessmentErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartAssessmentErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `StartAssessmentErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, StartAssessmentErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for StartAssessmentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartAssessmentErrorKind::AccessDeniedException(_inner) => Some(_inner),
            StartAssessmentErrorKind::InternalServerException(_inner) => Some(_inner),
            StartAssessmentErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            StartAssessmentErrorKind::ThrottlingException(_inner) => Some(_inner),
            StartAssessmentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartImportFileTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartImportFileTaskError {
    /// Kind of error that occurred.
    pub kind: StartImportFileTaskErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartImportFileTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartImportFileTaskErrorKind {
    /// <p> The AWS user account does not have permission to perform the action. Check the
    /// AWS Identity and Access Management (IAM) policy associated with this account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> The server experienced an internal error. Try again. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The AWS account has reached its quota of imports. Contact AWS Support to increase the
    /// quota for this account. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p> The request was denied due to request throttling. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p> The request body isn't valid. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartImportFileTaskError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartImportFileTaskErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            StartImportFileTaskErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            StartImportFileTaskErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            StartImportFileTaskErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            StartImportFileTaskErrorKind::ValidationException(_inner) => _inner.fmt(f),
            StartImportFileTaskErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartImportFileTaskError {
    fn code(&self) -> Option<&str> {
        StartImportFileTaskError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartImportFileTaskError {
    /// Creates a new `StartImportFileTaskError`.
    pub fn new(kind: StartImportFileTaskErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartImportFileTaskError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartImportFileTaskErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartImportFileTaskError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartImportFileTaskErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartImportFileTaskErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartImportFileTaskErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `StartImportFileTaskErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartImportFileTaskErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `StartImportFileTaskErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartImportFileTaskErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `StartImportFileTaskErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartImportFileTaskErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `StartImportFileTaskErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartImportFileTaskErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for StartImportFileTaskError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartImportFileTaskErrorKind::AccessDeniedException(_inner) => Some(_inner),
            StartImportFileTaskErrorKind::InternalServerException(_inner) => Some(_inner),
            StartImportFileTaskErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            StartImportFileTaskErrorKind::ThrottlingException(_inner) => Some(_inner),
            StartImportFileTaskErrorKind::ValidationException(_inner) => Some(_inner),
            StartImportFileTaskErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartRecommendationReportGeneration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartRecommendationReportGenerationError {
    /// Kind of error that occurred.
    pub kind: StartRecommendationReportGenerationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartRecommendationReportGeneration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartRecommendationReportGenerationErrorKind {
    /// <p> The AWS user account does not have permission to perform the action. Check the
    /// AWS Identity and Access Management (IAM) policy associated with this account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>
    /// Exception to indicate that there is an ongoing task when a new task is created.
    /// Return when once the existing tasks are complete.
    /// </p>
    ConflictException(crate::error::ConflictException),
    /// <p> The server experienced an internal error. Try again. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The request was denied due to request throttling. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p> The request body isn't valid. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartRecommendationReportGenerationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartRecommendationReportGenerationErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            StartRecommendationReportGenerationErrorKind::ConflictException(_inner) => {
                _inner.fmt(f)
            }
            StartRecommendationReportGenerationErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            StartRecommendationReportGenerationErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            StartRecommendationReportGenerationErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            StartRecommendationReportGenerationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartRecommendationReportGenerationError {
    fn code(&self) -> Option<&str> {
        StartRecommendationReportGenerationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartRecommendationReportGenerationError {
    /// Creates a new `StartRecommendationReportGenerationError`.
    pub fn new(
        kind: StartRecommendationReportGenerationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartRecommendationReportGenerationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartRecommendationReportGenerationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartRecommendationReportGenerationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartRecommendationReportGenerationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartRecommendationReportGenerationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartRecommendationReportGenerationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `StartRecommendationReportGenerationErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartRecommendationReportGenerationErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `StartRecommendationReportGenerationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartRecommendationReportGenerationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `StartRecommendationReportGenerationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartRecommendationReportGenerationErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `StartRecommendationReportGenerationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartRecommendationReportGenerationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for StartRecommendationReportGenerationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartRecommendationReportGenerationErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            StartRecommendationReportGenerationErrorKind::ConflictException(_inner) => Some(_inner),
            StartRecommendationReportGenerationErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            StartRecommendationReportGenerationErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            StartRecommendationReportGenerationErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            StartRecommendationReportGenerationErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `StopAssessment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopAssessmentError {
    /// Kind of error that occurred.
    pub kind: StopAssessmentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopAssessment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopAssessmentErrorKind {
    /// <p> The AWS user account does not have permission to perform the action. Check the
    /// AWS Identity and Access Management (IAM) policy associated with this account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> The server experienced an internal error. Try again. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The request was denied due to request throttling. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p> The request body isn't valid. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopAssessmentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopAssessmentErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            StopAssessmentErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            StopAssessmentErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            StopAssessmentErrorKind::ValidationException(_inner) => _inner.fmt(f),
            StopAssessmentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopAssessmentError {
    fn code(&self) -> Option<&str> {
        StopAssessmentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopAssessmentError {
    /// Creates a new `StopAssessmentError`.
    pub fn new(kind: StopAssessmentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopAssessmentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopAssessmentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopAssessmentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopAssessmentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StopAssessmentErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopAssessmentErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `StopAssessmentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopAssessmentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `StopAssessmentErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, StopAssessmentErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `StopAssessmentErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, StopAssessmentErrorKind::ValidationException(_))
    }
}
impl std::error::Error for StopAssessmentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopAssessmentErrorKind::AccessDeniedException(_inner) => Some(_inner),
            StopAssessmentErrorKind::InternalServerException(_inner) => Some(_inner),
            StopAssessmentErrorKind::ThrottlingException(_inner) => Some(_inner),
            StopAssessmentErrorKind::ValidationException(_inner) => Some(_inner),
            StopAssessmentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateApplicationComponentConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateApplicationComponentConfigError {
    /// Kind of error that occurred.
    pub kind: UpdateApplicationComponentConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateApplicationComponentConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateApplicationComponentConfigErrorKind {
    /// <p> The server experienced an internal error. Try again. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The specified ID in the request is not found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request was denied due to request throttling. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p> The request body isn't valid. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateApplicationComponentConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateApplicationComponentConfigErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            UpdateApplicationComponentConfigErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateApplicationComponentConfigErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateApplicationComponentConfigErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateApplicationComponentConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateApplicationComponentConfigError {
    fn code(&self) -> Option<&str> {
        UpdateApplicationComponentConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateApplicationComponentConfigError {
    /// Creates a new `UpdateApplicationComponentConfigError`.
    pub fn new(
        kind: UpdateApplicationComponentConfigErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateApplicationComponentConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateApplicationComponentConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateApplicationComponentConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateApplicationComponentConfigErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateApplicationComponentConfigErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApplicationComponentConfigErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateApplicationComponentConfigErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApplicationComponentConfigErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateApplicationComponentConfigErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApplicationComponentConfigErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateApplicationComponentConfigErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApplicationComponentConfigErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateApplicationComponentConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateApplicationComponentConfigErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            UpdateApplicationComponentConfigErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            UpdateApplicationComponentConfigErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateApplicationComponentConfigErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateApplicationComponentConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateServerConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateServerConfigError {
    /// Kind of error that occurred.
    pub kind: UpdateServerConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateServerConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateServerConfigErrorKind {
    /// <p> The server experienced an internal error. Try again. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The specified ID in the request is not found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request was denied due to request throttling. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p> The request body isn't valid. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateServerConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateServerConfigErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateServerConfigErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateServerConfigErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateServerConfigErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateServerConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateServerConfigError {
    fn code(&self) -> Option<&str> {
        UpdateServerConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateServerConfigError {
    /// Creates a new `UpdateServerConfigError`.
    pub fn new(kind: UpdateServerConfigErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateServerConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateServerConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateServerConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateServerConfigErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateServerConfigErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServerConfigErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateServerConfigErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServerConfigErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateServerConfigErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServerConfigErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateServerConfigErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServerConfigErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateServerConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateServerConfigErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateServerConfigErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateServerConfigErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateServerConfigErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateServerConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p> The request body isn't valid. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ValidationException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ValidationException {}
/// See [`ValidationException`](crate::error::ValidationException)
pub mod validation_exception {
    /// A builder for [`ValidationException`](crate::error::ValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationException`](crate::error::ValidationException)
        pub fn build(self) -> crate::error::ValidationException {
            crate::error::ValidationException {
                message: self.message,
            }
        }
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::error::ValidationException)
    pub fn builder() -> crate::error::validation_exception::Builder {
        crate::error::validation_exception::Builder::default()
    }
}

/// <p> The request was denied due to request throttling. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThrottlingException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThrottlingException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ThrottlingException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ThrottlingException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ThrottlingException {}
/// See [`ThrottlingException`](crate::error::ThrottlingException)
pub mod throttling_exception {
    /// A builder for [`ThrottlingException`](crate::error::ThrottlingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ThrottlingException`](crate::error::ThrottlingException)
        pub fn build(self) -> crate::error::ThrottlingException {
            crate::error::ThrottlingException {
                message: self.message,
            }
        }
    }
}
impl ThrottlingException {
    /// Creates a new builder-style object to manufacture [`ThrottlingException`](crate::error::ThrottlingException)
    pub fn builder() -> crate::error::throttling_exception::Builder {
        crate::error::throttling_exception::Builder::default()
    }
}

/// <p> The specified ID in the request is not found. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p> The server experienced an internal error. Try again. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServerException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerException {}
/// See [`InternalServerException`](crate::error::InternalServerException)
pub mod internal_server_exception {
    /// A builder for [`InternalServerException`](crate::error::InternalServerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerException`](crate::error::InternalServerException)
        pub fn build(self) -> crate::error::InternalServerException {
            crate::error::InternalServerException {
                message: self.message,
            }
        }
    }
}
impl InternalServerException {
    /// Creates a new builder-style object to manufacture [`InternalServerException`](crate::error::InternalServerException)
    pub fn builder() -> crate::error::internal_server_exception::Builder {
        crate::error::internal_server_exception::Builder::default()
    }
}

/// <p> The AWS user account does not have permission to perform the action. Check the
/// AWS Identity and Access Management (IAM) policy associated with this account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}

/// <p>
/// Exception to indicate that there is an ongoing task when a new task is created.
/// Return when once the existing tasks are complete.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

/// <p> The AWS account has reached its quota of imports. Contact AWS Support to increase the
/// quota for this account. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceQuotaExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceQuotaExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceQuotaExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceQuotaExceededException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceQuotaExceededException {}
/// See [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
pub mod service_quota_exceeded_exception {
    /// A builder for [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
        pub fn build(self) -> crate::error::ServiceQuotaExceededException {
            crate::error::ServiceQuotaExceededException {
                message: self.message,
            }
        }
    }
}
impl ServiceQuotaExceededException {
    /// Creates a new builder-style object to manufacture [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    pub fn builder() -> crate::error::service_quota_exceeded_exception::Builder {
        crate::error::service_quota_exceeded_exception::Builder::default()
    }
}

/// <p>
/// Exception to indicate that the service-linked role (SLR) is locked.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceLinkedRoleLockClientException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceLinkedRoleLockClientException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceLinkedRoleLockClientException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceLinkedRoleLockClientException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceLinkedRoleLockClientException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceLinkedRoleLockClientException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceLinkedRoleLockClientException {}
/// See [`ServiceLinkedRoleLockClientException`](crate::error::ServiceLinkedRoleLockClientException)
pub mod service_linked_role_lock_client_exception {
    /// A builder for [`ServiceLinkedRoleLockClientException`](crate::error::ServiceLinkedRoleLockClientException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceLinkedRoleLockClientException`](crate::error::ServiceLinkedRoleLockClientException)
        pub fn build(self) -> crate::error::ServiceLinkedRoleLockClientException {
            crate::error::ServiceLinkedRoleLockClientException {
                message: self.message,
            }
        }
    }
}
impl ServiceLinkedRoleLockClientException {
    /// Creates a new builder-style object to manufacture [`ServiceLinkedRoleLockClientException`](crate::error::ServiceLinkedRoleLockClientException)
    pub fn builder() -> crate::error::service_linked_role_lock_client_exception::Builder {
        crate::error::service_linked_role_lock_client_exception::Builder::default()
    }
}
