// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// Client for Migration Hub Strategy Recommendations
///
/// Client for invoking operations on Migration Hub Strategy Recommendations. Each operation on Migration Hub Strategy Recommendations is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_migrationhubstrategy::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_migrationhubstrategy::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_migrationhubstrategy::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `GetApplicationComponentDetails` operation.
    ///
    /// See [`GetApplicationComponentDetails`](crate::client::fluent_builders::GetApplicationComponentDetails) for more information about the
    /// operation and its arguments.
    pub fn get_application_component_details(
        &self,
    ) -> fluent_builders::GetApplicationComponentDetails<C, M, R> {
        fluent_builders::GetApplicationComponentDetails::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetApplicationComponentStrategies` operation.
    ///
    /// See [`GetApplicationComponentStrategies`](crate::client::fluent_builders::GetApplicationComponentStrategies) for more information about the
    /// operation and its arguments.
    pub fn get_application_component_strategies(
        &self,
    ) -> fluent_builders::GetApplicationComponentStrategies<C, M, R> {
        fluent_builders::GetApplicationComponentStrategies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAssessment` operation.
    ///
    /// See [`GetAssessment`](crate::client::fluent_builders::GetAssessment) for more information about the
    /// operation and its arguments.
    pub fn get_assessment(&self) -> fluent_builders::GetAssessment<C, M, R> {
        fluent_builders::GetAssessment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetImportFileTask` operation.
    ///
    /// See [`GetImportFileTask`](crate::client::fluent_builders::GetImportFileTask) for more information about the
    /// operation and its arguments.
    pub fn get_import_file_task(&self) -> fluent_builders::GetImportFileTask<C, M, R> {
        fluent_builders::GetImportFileTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetPortfolioPreferences` operation.
    ///
    /// See [`GetPortfolioPreferences`](crate::client::fluent_builders::GetPortfolioPreferences) for more information about the
    /// operation and its arguments.
    pub fn get_portfolio_preferences(&self) -> fluent_builders::GetPortfolioPreferences<C, M, R> {
        fluent_builders::GetPortfolioPreferences::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetPortfolioSummary` operation.
    ///
    /// See [`GetPortfolioSummary`](crate::client::fluent_builders::GetPortfolioSummary) for more information about the
    /// operation and its arguments.
    pub fn get_portfolio_summary(&self) -> fluent_builders::GetPortfolioSummary<C, M, R> {
        fluent_builders::GetPortfolioSummary::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRecommendationReportDetails` operation.
    ///
    /// See [`GetRecommendationReportDetails`](crate::client::fluent_builders::GetRecommendationReportDetails) for more information about the
    /// operation and its arguments.
    pub fn get_recommendation_report_details(
        &self,
    ) -> fluent_builders::GetRecommendationReportDetails<C, M, R> {
        fluent_builders::GetRecommendationReportDetails::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetServerDetails` operation.
    ///
    /// See [`GetServerDetails`](crate::client::fluent_builders::GetServerDetails) for more information about the
    /// operation and its arguments.
    pub fn get_server_details(&self) -> fluent_builders::GetServerDetails<C, M, R> {
        fluent_builders::GetServerDetails::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetServerStrategies` operation.
    ///
    /// See [`GetServerStrategies`](crate::client::fluent_builders::GetServerStrategies) for more information about the
    /// operation and its arguments.
    pub fn get_server_strategies(&self) -> fluent_builders::GetServerStrategies<C, M, R> {
        fluent_builders::GetServerStrategies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListApplicationComponents` operation.
    ///
    /// See [`ListApplicationComponents`](crate::client::fluent_builders::ListApplicationComponents) for more information about the
    /// operation and its arguments.
    pub fn list_application_components(
        &self,
    ) -> fluent_builders::ListApplicationComponents<C, M, R> {
        fluent_builders::ListApplicationComponents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListCollectors` operation.
    ///
    /// See [`ListCollectors`](crate::client::fluent_builders::ListCollectors) for more information about the
    /// operation and its arguments.
    pub fn list_collectors(&self) -> fluent_builders::ListCollectors<C, M, R> {
        fluent_builders::ListCollectors::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListImportFileTask` operation.
    ///
    /// See [`ListImportFileTask`](crate::client::fluent_builders::ListImportFileTask) for more information about the
    /// operation and its arguments.
    pub fn list_import_file_task(&self) -> fluent_builders::ListImportFileTask<C, M, R> {
        fluent_builders::ListImportFileTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListServers` operation.
    ///
    /// See [`ListServers`](crate::client::fluent_builders::ListServers) for more information about the
    /// operation and its arguments.
    pub fn list_servers(&self) -> fluent_builders::ListServers<C, M, R> {
        fluent_builders::ListServers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutPortfolioPreferences` operation.
    ///
    /// See [`PutPortfolioPreferences`](crate::client::fluent_builders::PutPortfolioPreferences) for more information about the
    /// operation and its arguments.
    pub fn put_portfolio_preferences(&self) -> fluent_builders::PutPortfolioPreferences<C, M, R> {
        fluent_builders::PutPortfolioPreferences::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartAssessment` operation.
    ///
    /// See [`StartAssessment`](crate::client::fluent_builders::StartAssessment) for more information about the
    /// operation and its arguments.
    pub fn start_assessment(&self) -> fluent_builders::StartAssessment<C, M, R> {
        fluent_builders::StartAssessment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartImportFileTask` operation.
    ///
    /// See [`StartImportFileTask`](crate::client::fluent_builders::StartImportFileTask) for more information about the
    /// operation and its arguments.
    pub fn start_import_file_task(&self) -> fluent_builders::StartImportFileTask<C, M, R> {
        fluent_builders::StartImportFileTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartRecommendationReportGeneration` operation.
    ///
    /// See [`StartRecommendationReportGeneration`](crate::client::fluent_builders::StartRecommendationReportGeneration) for more information about the
    /// operation and its arguments.
    pub fn start_recommendation_report_generation(
        &self,
    ) -> fluent_builders::StartRecommendationReportGeneration<C, M, R> {
        fluent_builders::StartRecommendationReportGeneration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopAssessment` operation.
    ///
    /// See [`StopAssessment`](crate::client::fluent_builders::StopAssessment) for more information about the
    /// operation and its arguments.
    pub fn stop_assessment(&self) -> fluent_builders::StopAssessment<C, M, R> {
        fluent_builders::StopAssessment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateApplicationComponentConfig` operation.
    ///
    /// See [`UpdateApplicationComponentConfig`](crate::client::fluent_builders::UpdateApplicationComponentConfig) for more information about the
    /// operation and its arguments.
    pub fn update_application_component_config(
        &self,
    ) -> fluent_builders::UpdateApplicationComponentConfig<C, M, R> {
        fluent_builders::UpdateApplicationComponentConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateServerConfig` operation.
    ///
    /// See [`UpdateServerConfig`](crate::client::fluent_builders::UpdateServerConfig) for more information about the
    /// operation and its arguments.
    pub fn update_server_config(&self) -> fluent_builders::UpdateServerConfig<C, M, R> {
        fluent_builders::UpdateServerConfig::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `GetApplicationComponentDetails`.
    ///
    /// <p> Retrieves details about an application component. </p>
    #[derive(std::fmt::Debug)]
    pub struct GetApplicationComponentDetails<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_application_component_details_input::Builder,
    }
    impl<C, M, R> GetApplicationComponentDetails<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetApplicationComponentDetails`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetApplicationComponentDetailsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetApplicationComponentDetailsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetApplicationComponentDetailsInputOperationOutputAlias,
                crate::output::GetApplicationComponentDetailsOutput,
                crate::error::GetApplicationComponentDetailsError,
                crate::input::GetApplicationComponentDetailsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The ID of the application component. The ID is unique within an AWS account.</p>
        pub fn application_component_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_component_id(inp);
            self
        }
        /// <p> The ID of the application component. The ID is unique within an AWS account.</p>
        pub fn set_application_component_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_component_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetApplicationComponentStrategies`.
    ///
    /// <p> Retrieves a list of all the recommended strategies and tools for an application component
    /// running on a server. </p>
    #[derive(std::fmt::Debug)]
    pub struct GetApplicationComponentStrategies<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_application_component_strategies_input::Builder,
    }
    impl<C, M, R> GetApplicationComponentStrategies<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetApplicationComponentStrategies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetApplicationComponentStrategiesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetApplicationComponentStrategiesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetApplicationComponentStrategiesInputOperationOutputAlias,
                crate::output::GetApplicationComponentStrategiesOutput,
                crate::error::GetApplicationComponentStrategiesError,
                crate::input::GetApplicationComponentStrategiesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The ID of the application component. The ID is unique within an AWS account.</p>
        pub fn application_component_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_component_id(inp);
            self
        }
        /// <p> The ID of the application component. The ID is unique within an AWS account.</p>
        pub fn set_application_component_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_component_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAssessment`.
    ///
    /// <p> Retrieves the status of an on-going assessment. </p>
    #[derive(std::fmt::Debug)]
    pub struct GetAssessment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_assessment_input::Builder,
    }
    impl<C, M, R> GetAssessment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAssessment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAssessmentOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAssessmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAssessmentInputOperationOutputAlias,
                crate::output::GetAssessmentOutput,
                crate::error::GetAssessmentError,
                crate::input::GetAssessmentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The <code>assessmentid</code> returned by <a>StartAssessment</a>.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p> The <code>assessmentid</code> returned by <a>StartAssessment</a>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetImportFileTask`.
    ///
    /// <p> Retrieves the details about a specific import task. </p>
    #[derive(std::fmt::Debug)]
    pub struct GetImportFileTask<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_import_file_task_input::Builder,
    }
    impl<C, M, R> GetImportFileTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetImportFileTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetImportFileTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::GetImportFileTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetImportFileTaskInputOperationOutputAlias,
                crate::output::GetImportFileTaskOutput,
                crate::error::GetImportFileTaskError,
                crate::input::GetImportFileTaskInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The ID of the import file task. This ID is returned in the response of
        /// <a>StartImportFileTask</a>. </p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p> The ID of the import file task. This ID is returned in the response of
        /// <a>StartImportFileTask</a>. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPortfolioPreferences`.
    ///
    /// <p> Retrieves your migration and modernization preferences. </p>
    #[derive(std::fmt::Debug)]
    pub struct GetPortfolioPreferences<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_portfolio_preferences_input::Builder,
    }
    impl<C, M, R> GetPortfolioPreferences<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetPortfolioPreferences`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPortfolioPreferencesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPortfolioPreferencesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetPortfolioPreferencesInputOperationOutputAlias,
                crate::output::GetPortfolioPreferencesOutput,
                crate::error::GetPortfolioPreferencesError,
                crate::input::GetPortfolioPreferencesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetPortfolioSummary`.
    ///
    /// <p> Retrieves overall summary including the number of servers to rehost and the overall
    /// number of anti-patterns. </p>
    #[derive(std::fmt::Debug)]
    pub struct GetPortfolioSummary<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_portfolio_summary_input::Builder,
    }
    impl<C, M, R> GetPortfolioSummary<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetPortfolioSummary`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPortfolioSummaryOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPortfolioSummaryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetPortfolioSummaryInputOperationOutputAlias,
                crate::output::GetPortfolioSummaryOutput,
                crate::error::GetPortfolioSummaryError,
                crate::input::GetPortfolioSummaryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetRecommendationReportDetails`.
    ///
    /// <p> Retrieves detailed information about the specified recommendation report. </p>
    #[derive(std::fmt::Debug)]
    pub struct GetRecommendationReportDetails<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_recommendation_report_details_input::Builder,
    }
    impl<C, M, R> GetRecommendationReportDetails<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRecommendationReportDetails`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRecommendationReportDetailsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRecommendationReportDetailsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRecommendationReportDetailsInputOperationOutputAlias,
                crate::output::GetRecommendationReportDetailsOutput,
                crate::error::GetRecommendationReportDetailsError,
                crate::input::GetRecommendationReportDetailsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The recommendation report generation task <code>id</code> returned by
        /// <a>StartRecommendationReportGeneration</a>. </p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p> The recommendation report generation task <code>id</code> returned by
        /// <a>StartRecommendationReportGeneration</a>. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetServerDetails`.
    ///
    /// <p> Retrieves detailed information about a specified server. </p>
    #[derive(std::fmt::Debug)]
    pub struct GetServerDetails<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_server_details_input::Builder,
    }
    impl<C, M, R> GetServerDetails<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetServerDetails`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetServerDetailsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetServerDetailsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetServerDetailsInputOperationOutputAlias,
                crate::output::GetServerDetailsOutput,
                crate::error::GetServerDetailsError,
                crate::input::GetServerDetailsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The ID of the server. </p>
        pub fn server_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.server_id(inp);
            self
        }
        /// <p> The ID of the server. </p>
        pub fn set_server_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_server_id(input);
            self
        }
        /// <p> The token from a previous call that you use to retrieve the next set of results. For example,
        /// if a previous call to this action returned 100 items, but you set <code>maxResults</code> to 10. You'll receive a set of 10 results along
        /// with a token. You then use the returned token to retrieve the next set of 10. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p> The token from a previous call that you use to retrieve the next set of results. For example,
        /// if a previous call to this action returned 100 items, but you set <code>maxResults</code> to 10. You'll receive a set of 10 results along
        /// with a token. You then use the returned token to retrieve the next set of 10. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> The maximum number of items to include in the response. The maximum value is 100. </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p> The maximum number of items to include in the response. The maximum value is 100. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetServerStrategies`.
    ///
    /// <p> Retrieves recommended strategies and tools for the specified server. </p>
    #[derive(std::fmt::Debug)]
    pub struct GetServerStrategies<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_server_strategies_input::Builder,
    }
    impl<C, M, R> GetServerStrategies<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetServerStrategies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetServerStrategiesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetServerStrategiesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetServerStrategiesInputOperationOutputAlias,
                crate::output::GetServerStrategiesOutput,
                crate::error::GetServerStrategiesError,
                crate::input::GetServerStrategiesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The ID of the server. </p>
        pub fn server_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.server_id(inp);
            self
        }
        /// <p> The ID of the server. </p>
        pub fn set_server_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_server_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListApplicationComponents`.
    ///
    /// <p> Retrieves a list of all the application components (processes). </p>
    #[derive(std::fmt::Debug)]
    pub struct ListApplicationComponents<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_application_components_input::Builder,
    }
    impl<C, M, R> ListApplicationComponents<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListApplicationComponents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListApplicationComponentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListApplicationComponentsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListApplicationComponentsInputOperationOutputAlias,
                crate::output::ListApplicationComponentsOutput,
                crate::error::ListApplicationComponentsError,
                crate::input::ListApplicationComponentsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> Criteria for filtering the list of application components. </p>
        pub fn application_component_criteria(
            mut self,
            inp: crate::model::ApplicationComponentCriteria,
        ) -> Self {
            self.inner = self.inner.application_component_criteria(inp);
            self
        }
        /// <p> Criteria for filtering the list of application components. </p>
        pub fn set_application_component_criteria(
            mut self,
            input: std::option::Option<crate::model::ApplicationComponentCriteria>,
        ) -> Self {
            self.inner = self.inner.set_application_component_criteria(input);
            self
        }
        /// <p> Specify the value based on the application component criteria type. For example, if
        /// <code>applicationComponentCriteria</code> is set to <code>SERVER_ID</code> and
        /// <code>filterValue</code> is set to <code>server1</code>, then <a>ListApplicationComponents</a> returns all the application components running on
        /// server1. </p>
        pub fn filter_value(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.filter_value(inp);
            self
        }
        /// <p> Specify the value based on the application component criteria type. For example, if
        /// <code>applicationComponentCriteria</code> is set to <code>SERVER_ID</code> and
        /// <code>filterValue</code> is set to <code>server1</code>, then <a>ListApplicationComponents</a> returns all the application components running on
        /// server1. </p>
        pub fn set_filter_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_filter_value(input);
            self
        }
        /// <p> Specifies whether to sort by ascending (<code>ASC</code>) or descending
        /// (<code>DESC</code>) order. </p>
        pub fn sort(mut self, inp: crate::model::SortOrder) -> Self {
            self.inner = self.inner.sort(inp);
            self
        }
        /// <p> Specifies whether to sort by ascending (<code>ASC</code>) or descending
        /// (<code>DESC</code>) order. </p>
        pub fn set_sort(mut self, input: std::option::Option<crate::model::SortOrder>) -> Self {
            self.inner = self.inner.set_sort(input);
            self
        }
        /// Appends an item to `groupIdFilter`.
        ///
        /// To override the contents of this collection use [`set_group_id_filter`](Self::set_group_id_filter).
        ///
        /// <p> The group ID specified in to filter on. </p>
        pub fn group_id_filter(mut self, inp: impl Into<crate::model::Group>) -> Self {
            self.inner = self.inner.group_id_filter(inp);
            self
        }
        /// <p> The group ID specified in to filter on. </p>
        pub fn set_group_id_filter(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Group>>,
        ) -> Self {
            self.inner = self.inner.set_group_id_filter(input);
            self
        }
        /// <p> The token from a previous call that you use to retrieve the next set of results. For example,
        /// if a previous call to this action returned 100 items, but you set <code>maxResults</code> to 10. You'll receive a set of 10 results along
        /// with a token. You then use the returned token to retrieve the next set of 10. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p> The token from a previous call that you use to retrieve the next set of results. For example,
        /// if a previous call to this action returned 100 items, but you set <code>maxResults</code> to 10. You'll receive a set of 10 results along
        /// with a token. You then use the returned token to retrieve the next set of 10. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> The maximum number of items to include in the response. The maximum value is 100. </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p> The maximum number of items to include in the response. The maximum value is 100. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCollectors`.
    ///
    /// <p> Retrieves a list of all the installed collectors. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListCollectors<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_collectors_input::Builder,
    }
    impl<C, M, R> ListCollectors<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListCollectors`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCollectorsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListCollectorsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListCollectorsInputOperationOutputAlias,
                crate::output::ListCollectorsOutput,
                crate::error::ListCollectorsError,
                crate::input::ListCollectorsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The token from a previous call that you use to retrieve the next set of results. For example,
        /// if a previous call to this action returned 100 items, but you set <code>maxResults</code> to 10. You'll receive a set of 10 results along
        /// with a token. You then use the returned token to retrieve the next set of 10. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p> The token from a previous call that you use to retrieve the next set of results. For example,
        /// if a previous call to this action returned 100 items, but you set <code>maxResults</code> to 10. You'll receive a set of 10 results along
        /// with a token. You then use the returned token to retrieve the next set of 10. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> The maximum number of items to include in the response. The maximum value is 100. </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p> The maximum number of items to include in the response. The maximum value is 100. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListImportFileTask`.
    ///
    /// <p> Retrieves a list of all the imports performed. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListImportFileTask<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_import_file_task_input::Builder,
    }
    impl<C, M, R> ListImportFileTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListImportFileTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListImportFileTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::ListImportFileTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListImportFileTaskInputOperationOutputAlias,
                crate::output::ListImportFileTaskOutput,
                crate::error::ListImportFileTaskError,
                crate::input::ListImportFileTaskInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The token from a previous call that you use to retrieve the next set of results. For example,
        /// if a previous call to this action returned 100 items, but you set <code>maxResults</code> to 10. You'll receive a set of 10 results along
        /// with a token. You then use the returned token to retrieve the next set of 10. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p> The token from a previous call that you use to retrieve the next set of results. For example,
        /// if a previous call to this action returned 100 items, but you set <code>maxResults</code> to 10. You'll receive a set of 10 results along
        /// with a token. You then use the returned token to retrieve the next set of 10. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> The total number of items to return. The maximum value is 100. </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p> The total number of items to return. The maximum value is 100. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListServers`.
    ///
    /// <p> Returns a list of all the servers. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListServers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_servers_input::Builder,
    }
    impl<C, M, R> ListServers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListServers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListServersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListServersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListServersInputOperationOutputAlias,
                crate::output::ListServersOutput,
                crate::error::ListServersError,
                crate::input::ListServersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> Criteria for filtering servers. </p>
        pub fn server_criteria(mut self, inp: crate::model::ServerCriteria) -> Self {
            self.inner = self.inner.server_criteria(inp);
            self
        }
        /// <p> Criteria for filtering servers. </p>
        pub fn set_server_criteria(
            mut self,
            input: std::option::Option<crate::model::ServerCriteria>,
        ) -> Self {
            self.inner = self.inner.set_server_criteria(input);
            self
        }
        /// <p> Specifies the filter value, which is based on the type of server criteria. For example,
        /// if <code>serverCriteria</code> is <code>OS_NAME</code>, and the <code>filterValue</code> is
        /// equal to <code>WindowsServer</code>, then <code>ListServers</code> returns all of the servers
        /// matching the OS name <code>WindowsServer</code>. </p>
        pub fn filter_value(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.filter_value(inp);
            self
        }
        /// <p> Specifies the filter value, which is based on the type of server criteria. For example,
        /// if <code>serverCriteria</code> is <code>OS_NAME</code>, and the <code>filterValue</code> is
        /// equal to <code>WindowsServer</code>, then <code>ListServers</code> returns all of the servers
        /// matching the OS name <code>WindowsServer</code>. </p>
        pub fn set_filter_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_filter_value(input);
            self
        }
        /// <p> Specifies whether to sort by ascending (<code>ASC</code>) or descending
        /// (<code>DESC</code>) order. </p>
        pub fn sort(mut self, inp: crate::model::SortOrder) -> Self {
            self.inner = self.inner.sort(inp);
            self
        }
        /// <p> Specifies whether to sort by ascending (<code>ASC</code>) or descending
        /// (<code>DESC</code>) order. </p>
        pub fn set_sort(mut self, input: std::option::Option<crate::model::SortOrder>) -> Self {
            self.inner = self.inner.set_sort(input);
            self
        }
        /// Appends an item to `groupIdFilter`.
        ///
        /// To override the contents of this collection use [`set_group_id_filter`](Self::set_group_id_filter).
        ///
        /// <p> Specifies the group ID to filter on. </p>
        pub fn group_id_filter(mut self, inp: impl Into<crate::model::Group>) -> Self {
            self.inner = self.inner.group_id_filter(inp);
            self
        }
        /// <p> Specifies the group ID to filter on. </p>
        pub fn set_group_id_filter(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Group>>,
        ) -> Self {
            self.inner = self.inner.set_group_id_filter(input);
            self
        }
        /// <p> The token from a previous call that you use to retrieve the next set of results. For example,
        /// if a previous call to this action returned 100 items, but you set <code>maxResults</code> to 10. You'll receive a set of 10 results along
        /// with a token. You then use the returned token to retrieve the next set of 10. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p> The token from a previous call that you use to retrieve the next set of results. For example,
        /// if a previous call to this action returned 100 items, but you set <code>maxResults</code> to 10. You'll receive a set of 10 results along
        /// with a token. You then use the returned token to retrieve the next set of 10. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> The maximum number of items to include in the response. The maximum value is 100. </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p> The maximum number of items to include in the response. The maximum value is 100. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutPortfolioPreferences`.
    ///
    /// <p> Saves the specified migration and modernization preferences. </p>
    #[derive(std::fmt::Debug)]
    pub struct PutPortfolioPreferences<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_portfolio_preferences_input::Builder,
    }
    impl<C, M, R> PutPortfolioPreferences<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutPortfolioPreferences`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutPortfolioPreferencesOutput,
            aws_smithy_http::result::SdkError<crate::error::PutPortfolioPreferencesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutPortfolioPreferencesInputOperationOutputAlias,
                crate::output::PutPortfolioPreferencesOutput,
                crate::error::PutPortfolioPreferencesError,
                crate::input::PutPortfolioPreferencesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The rank of the business goals based on priority. </p>
        pub fn prioritize_business_goals(
            mut self,
            inp: crate::model::PrioritizeBusinessGoals,
        ) -> Self {
            self.inner = self.inner.prioritize_business_goals(inp);
            self
        }
        /// <p> The rank of the business goals based on priority. </p>
        pub fn set_prioritize_business_goals(
            mut self,
            input: std::option::Option<crate::model::PrioritizeBusinessGoals>,
        ) -> Self {
            self.inner = self.inner.set_prioritize_business_goals(input);
            self
        }
        /// <p> The transformation preferences for non-database applications. </p>
        pub fn application_preferences(
            mut self,
            inp: crate::model::ApplicationPreferences,
        ) -> Self {
            self.inner = self.inner.application_preferences(inp);
            self
        }
        /// <p> The transformation preferences for non-database applications. </p>
        pub fn set_application_preferences(
            mut self,
            input: std::option::Option<crate::model::ApplicationPreferences>,
        ) -> Self {
            self.inner = self.inner.set_application_preferences(input);
            self
        }
        /// <p> The transformation preferences for database applications. </p>
        pub fn database_preferences(mut self, inp: crate::model::DatabasePreferences) -> Self {
            self.inner = self.inner.database_preferences(inp);
            self
        }
        /// <p> The transformation preferences for database applications. </p>
        pub fn set_database_preferences(
            mut self,
            input: std::option::Option<crate::model::DatabasePreferences>,
        ) -> Self {
            self.inner = self.inner.set_database_preferences(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartAssessment`.
    ///
    /// <p> Starts the assessment of an on-premises environment. </p>
    #[derive(std::fmt::Debug)]
    pub struct StartAssessment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_assessment_input::Builder,
    }
    impl<C, M, R> StartAssessment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartAssessment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartAssessmentOutput,
            aws_smithy_http::result::SdkError<crate::error::StartAssessmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartAssessmentInputOperationOutputAlias,
                crate::output::StartAssessmentOutput,
                crate::error::StartAssessmentError,
                crate::input::StartAssessmentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The S3 bucket used by the collectors to send analysis data to the service.
        /// The bucket name must begin with <code>migrationhub-strategy-</code>.
        /// </p>
        pub fn s3bucket_for_analysis_data(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.s3bucket_for_analysis_data(inp);
            self
        }
        /// <p>
        /// The S3 bucket used by the collectors to send analysis data to the service.
        /// The bucket name must begin with <code>migrationhub-strategy-</code>.
        /// </p>
        pub fn set_s3bucket_for_analysis_data(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_s3bucket_for_analysis_data(input);
            self
        }
        /// <p>
        /// The S3 bucket where all the reports generated by the service are stored.
        /// The bucket name must begin with <code>migrationhub-strategy-</code>.
        /// </p>
        pub fn s3bucket_for_report_data(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.s3bucket_for_report_data(inp);
            self
        }
        /// <p>
        /// The S3 bucket where all the reports generated by the service are stored.
        /// The bucket name must begin with <code>migrationhub-strategy-</code>.
        /// </p>
        pub fn set_s3bucket_for_report_data(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_s3bucket_for_report_data(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartImportFileTask`.
    ///
    /// <p> Starts a file import. </p>
    #[derive(std::fmt::Debug)]
    pub struct StartImportFileTask<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_import_file_task_input::Builder,
    }
    impl<C, M, R> StartImportFileTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartImportFileTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartImportFileTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::StartImportFileTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartImportFileTaskInputOperationOutputAlias,
                crate::output::StartImportFileTaskOutput,
                crate::error::StartImportFileTaskError,
                crate::input::StartImportFileTaskInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> A descriptive name for the request. </p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p> A descriptive name for the request. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p> The S3 bucket where the import file is located. The bucket name is required to begin with
        /// <code>migrationhub-strategy-</code>.</p>
        pub fn s3_bucket(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.s3_bucket(inp);
            self
        }
        /// <p> The S3 bucket where the import file is located. The bucket name is required to begin with
        /// <code>migrationhub-strategy-</code>.</p>
        pub fn set_s3_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_s3_bucket(input);
            self
        }
        /// <p> The Amazon S3 key name of the import file. </p>
        pub fn s3key(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.s3key(inp);
            self
        }
        /// <p> The Amazon S3 key name of the import file. </p>
        pub fn set_s3key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_s3key(input);
            self
        }
        /// <p>Specifies the source that the servers are coming from. By default, Strategy Recommendations assumes that
        /// the servers specified in the import file are available in AWS Application Discovery Service. </p>
        pub fn data_source_type(mut self, inp: crate::model::DataSourceType) -> Self {
            self.inner = self.inner.data_source_type(inp);
            self
        }
        /// <p>Specifies the source that the servers are coming from. By default, Strategy Recommendations assumes that
        /// the servers specified in the import file are available in AWS Application Discovery Service. </p>
        pub fn set_data_source_type(
            mut self,
            input: std::option::Option<crate::model::DataSourceType>,
        ) -> Self {
            self.inner = self.inner.set_data_source_type(input);
            self
        }
        /// Appends an item to `groupId`.
        ///
        /// To override the contents of this collection use [`set_group_id`](Self::set_group_id).
        ///
        /// <p>Groups the resources in the import file together with a unique name. This ID can be as
        /// filter in <code>ListApplicationComponents</code> and <code>ListServers</code>. </p>
        pub fn group_id(mut self, inp: impl Into<crate::model::Group>) -> Self {
            self.inner = self.inner.group_id(inp);
            self
        }
        /// <p>Groups the resources in the import file together with a unique name. This ID can be as
        /// filter in <code>ListApplicationComponents</code> and <code>ListServers</code>. </p>
        pub fn set_group_id(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Group>>,
        ) -> Self {
            self.inner = self.inner.set_group_id(input);
            self
        }
        /// <p> The S3 bucket where Strategy Recommendations uploads import results. The bucket name is required to
        /// begin with migrationhub-strategy-. </p>
        pub fn s3bucket_for_report_data(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.s3bucket_for_report_data(inp);
            self
        }
        /// <p> The S3 bucket where Strategy Recommendations uploads import results. The bucket name is required to
        /// begin with migrationhub-strategy-. </p>
        pub fn set_s3bucket_for_report_data(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_s3bucket_for_report_data(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartRecommendationReportGeneration`.
    ///
    /// <p> Starts generating a recommendation report. </p>
    #[derive(std::fmt::Debug)]
    pub struct StartRecommendationReportGeneration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_recommendation_report_generation_input::Builder,
    }
    impl<C, M, R> StartRecommendationReportGeneration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartRecommendationReportGeneration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartRecommendationReportGenerationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::StartRecommendationReportGenerationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartRecommendationReportGenerationInputOperationOutputAlias,
                crate::output::StartRecommendationReportGenerationOutput,
                crate::error::StartRecommendationReportGenerationError,
                crate::input::StartRecommendationReportGenerationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The output format for the recommendation report file. The default format is Microsoft Excel. </p>
        pub fn output_format(mut self, inp: crate::model::OutputFormat) -> Self {
            self.inner = self.inner.output_format(inp);
            self
        }
        /// <p> The output format for the recommendation report file. The default format is Microsoft Excel. </p>
        pub fn set_output_format(
            mut self,
            input: std::option::Option<crate::model::OutputFormat>,
        ) -> Self {
            self.inner = self.inner.set_output_format(input);
            self
        }
        /// Appends an item to `groupIdFilter`.
        ///
        /// To override the contents of this collection use [`set_group_id_filter`](Self::set_group_id_filter).
        ///
        /// <p> Groups the resources in the recommendation report with a unique name. </p>
        pub fn group_id_filter(mut self, inp: impl Into<crate::model::Group>) -> Self {
            self.inner = self.inner.group_id_filter(inp);
            self
        }
        /// <p> Groups the resources in the recommendation report with a unique name. </p>
        pub fn set_group_id_filter(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Group>>,
        ) -> Self {
            self.inner = self.inner.set_group_id_filter(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopAssessment`.
    ///
    /// <p> Stops the assessment of an on-premises environment. </p>
    #[derive(std::fmt::Debug)]
    pub struct StopAssessment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_assessment_input::Builder,
    }
    impl<C, M, R> StopAssessment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopAssessment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopAssessmentOutput,
            aws_smithy_http::result::SdkError<crate::error::StopAssessmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopAssessmentInputOperationOutputAlias,
                crate::output::StopAssessmentOutput,
                crate::error::StopAssessmentError,
                crate::input::StopAssessmentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The <code>assessmentId</code> returned by <a>StartAssessment</a>. </p>
        pub fn assessment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_id(inp);
            self
        }
        /// <p> The <code>assessmentId</code> returned by <a>StartAssessment</a>. </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateApplicationComponentConfig`.
    ///
    /// <p> Updates the configuration of an application component. </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateApplicationComponentConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_application_component_config_input::Builder,
    }
    impl<C, M, R> UpdateApplicationComponentConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateApplicationComponentConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateApplicationComponentConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateApplicationComponentConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateApplicationComponentConfigInputOperationOutputAlias,
                crate::output::UpdateApplicationComponentConfigOutput,
                crate::error::UpdateApplicationComponentConfigError,
                crate::input::UpdateApplicationComponentConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The ID of the application component. The ID is unique within an AWS account. </p>
        pub fn application_component_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_component_id(inp);
            self
        }
        /// <p> The ID of the application component. The ID is unique within an AWS account. </p>
        pub fn set_application_component_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_component_id(input);
            self
        }
        /// <p> Indicates whether the application component has been included for server recommendation
        /// or not. </p>
        pub fn inclusion_status(mut self, inp: crate::model::InclusionStatus) -> Self {
            self.inner = self.inner.inclusion_status(inp);
            self
        }
        /// <p> Indicates whether the application component has been included for server recommendation
        /// or not. </p>
        pub fn set_inclusion_status(
            mut self,
            input: std::option::Option<crate::model::InclusionStatus>,
        ) -> Self {
            self.inner = self.inner.set_inclusion_status(input);
            self
        }
        /// <p> The preferred strategy options for the application component. Use values from the <a>GetApplicationComponentStrategies</a> response. </p>
        pub fn strategy_option(mut self, inp: crate::model::StrategyOption) -> Self {
            self.inner = self.inner.strategy_option(inp);
            self
        }
        /// <p> The preferred strategy options for the application component. Use values from the <a>GetApplicationComponentStrategies</a> response. </p>
        pub fn set_strategy_option(
            mut self,
            input: std::option::Option<crate::model::StrategyOption>,
        ) -> Self {
            self.inner = self.inner.set_strategy_option(input);
            self
        }
        /// Appends an item to `sourceCodeList`.
        ///
        /// To override the contents of this collection use [`set_source_code_list`](Self::set_source_code_list).
        ///
        /// <p> The list of source code configurations to update for the application component. </p>
        pub fn source_code_list(mut self, inp: impl Into<crate::model::SourceCode>) -> Self {
            self.inner = self.inner.source_code_list(inp);
            self
        }
        /// <p> The list of source code configurations to update for the application component. </p>
        pub fn set_source_code_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SourceCode>>,
        ) -> Self {
            self.inner = self.inner.set_source_code_list(input);
            self
        }
        /// <p> Database credentials. </p>
        pub fn secrets_manager_key(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secrets_manager_key(inp);
            self
        }
        /// <p> Database credentials. </p>
        pub fn set_secrets_manager_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_secrets_manager_key(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateServerConfig`.
    ///
    /// <p> Updates the configuration of the specified server. </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateServerConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_server_config_input::Builder,
    }
    impl<C, M, R> UpdateServerConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateServerConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateServerConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateServerConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateServerConfigInputOperationOutputAlias,
                crate::output::UpdateServerConfigOutput,
                crate::error::UpdateServerConfigError,
                crate::input::UpdateServerConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The ID of the server. </p>
        pub fn server_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.server_id(inp);
            self
        }
        /// <p> The ID of the server. </p>
        pub fn set_server_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_server_id(input);
            self
        }
        /// <p> The preferred strategy options for the application component. See the response from <a>GetServerStrategies</a>.</p>
        pub fn strategy_option(mut self, inp: crate::model::StrategyOption) -> Self {
            self.inner = self.inner.strategy_option(inp);
            self
        }
        /// <p> The preferred strategy options for the application component. See the response from <a>GetServerStrategies</a>.</p>
        pub fn set_strategy_option(
            mut self,
            input: std::option::Option<crate::model::StrategyOption>,
        ) -> Self {
            self.inner = self.inner.set_strategy_option(input);
            self
        }
    }
}
impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
