// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CreateApplicationInput`](crate::input::CreateApplicationInput)
pub mod create_application_input {
    /// A builder for [`CreateApplicationInput`](crate::input::CreateApplicationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) environment_identifier: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) proxy_type: std::option::Option<crate::model::ProxyType>,
        pub(crate) api_gateway_proxy: std::option::Option<crate::model::ApiGatewayProxyInput>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name to use for the application. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name to use for the application. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The unique identifier of the environment.</p>
        pub fn environment_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_identifier = Some(input.into());
            self
        }
        /// <p>The unique identifier of the environment.</p>
        pub fn set_environment_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_identifier = input;
            self
        }
        /// <p>The ID of the virtual private cloud (VPC).</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The ID of the virtual private cloud (VPC).</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// <p>The proxy type of the proxy created within the application. </p>
        pub fn proxy_type(mut self, input: crate::model::ProxyType) -> Self {
            self.proxy_type = Some(input);
            self
        }
        /// <p>The proxy type of the proxy created within the application. </p>
        pub fn set_proxy_type(
            mut self,
            input: std::option::Option<crate::model::ProxyType>,
        ) -> Self {
            self.proxy_type = input;
            self
        }
        /// <p>A wrapper object holding the API Gateway endpoint type and stage name for the proxy. </p>
        pub fn api_gateway_proxy(mut self, input: crate::model::ApiGatewayProxyInput) -> Self {
            self.api_gateway_proxy = Some(input);
            self
        }
        /// <p>A wrapper object holding the API Gateway endpoint type and stage name for the proxy. </p>
        pub fn set_api_gateway_proxy(
            mut self,
            input: std::option::Option<crate::model::ApiGatewayProxyInput>,
        ) -> Self {
            self.api_gateway_proxy = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to assign to the application. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags to assign to the application. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateApplicationInput`](crate::input::CreateApplicationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateApplicationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateApplicationInput {
                name: self.name,
                environment_identifier: self.environment_identifier,
                vpc_id: self.vpc_id,
                proxy_type: self.proxy_type,
                api_gateway_proxy: self.api_gateway_proxy,
                tags: self.tags,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateApplicationInputOperationOutputAlias = crate::operation::CreateApplication;
#[doc(hidden)]
pub type CreateApplicationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateApplicationInput {
    /// Consumes the builder and constructs an Operation<[`CreateApplication`](crate::operation::CreateApplication)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateApplication,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateApplicationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.environment_identifier;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "environment_identifier",
                        details: "cannot be empty or unset",
                    })?;
            let environment_identifier = aws_smithy_http::label::fmt_string(input_1, false);
            if environment_identifier.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "environment_identifier",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/environments/{EnvironmentIdentifier}/applications",
                EnvironmentIdentifier = environment_identifier
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateApplicationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateApplicationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_application(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateApplication::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateApplication",
            "migrationhubrefactorspaces",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateApplicationInput`](crate::input::CreateApplicationInput)
    pub fn builder() -> crate::input::create_application_input::Builder {
        crate::input::create_application_input::Builder::default()
    }
}

/// See [`CreateEnvironmentInput`](crate::input::CreateEnvironmentInput)
pub mod create_environment_input {
    /// A builder for [`CreateEnvironmentInput`](crate::input::CreateEnvironmentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) network_fabric_type: std::option::Option<crate::model::NetworkFabricType>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the environment.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the environment.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the environment.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the environment.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The network fabric type of the environment.</p>
        pub fn network_fabric_type(mut self, input: crate::model::NetworkFabricType) -> Self {
            self.network_fabric_type = Some(input);
            self
        }
        /// <p>The network fabric type of the environment.</p>
        pub fn set_network_fabric_type(
            mut self,
            input: std::option::Option<crate::model::NetworkFabricType>,
        ) -> Self {
            self.network_fabric_type = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to assign to the environment. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags to assign to the environment. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateEnvironmentInput`](crate::input::CreateEnvironmentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateEnvironmentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateEnvironmentInput {
                name: self.name,
                description: self.description,
                network_fabric_type: self.network_fabric_type,
                tags: self.tags,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateEnvironmentInputOperationOutputAlias = crate::operation::CreateEnvironment;
#[doc(hidden)]
pub type CreateEnvironmentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateEnvironmentInput {
    /// Consumes the builder and constructs an Operation<[`CreateEnvironment`](crate::operation::CreateEnvironment)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateEnvironment,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateEnvironmentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/environments").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateEnvironmentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateEnvironmentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_environment(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateEnvironment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateEnvironment",
            "migrationhubrefactorspaces",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateEnvironmentInput`](crate::input::CreateEnvironmentInput)
    pub fn builder() -> crate::input::create_environment_input::Builder {
        crate::input::create_environment_input::Builder::default()
    }
}

/// See [`CreateRouteInput`](crate::input::CreateRouteInput)
pub mod create_route_input {
    /// A builder for [`CreateRouteInput`](crate::input::CreateRouteInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environment_identifier: std::option::Option<std::string::String>,
        pub(crate) application_identifier: std::option::Option<std::string::String>,
        pub(crate) service_identifier: std::option::Option<std::string::String>,
        pub(crate) route_type: std::option::Option<crate::model::RouteType>,
        pub(crate) uri_path_route: std::option::Option<crate::model::UriPathRouteInput>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the environment in which the route is created.</p>
        pub fn environment_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_identifier = Some(input.into());
            self
        }
        /// <p>The ID of the environment in which the route is created.</p>
        pub fn set_environment_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_identifier = input;
            self
        }
        /// <p>The ID of the application within which the route is being created.</p>
        pub fn application_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_identifier = Some(input.into());
            self
        }
        /// <p>The ID of the application within which the route is being created.</p>
        pub fn set_application_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_identifier = input;
            self
        }
        /// <p>The ID of the service in which the route is created. Traffic that matches this route is forwarded to this service.</p>
        pub fn service_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_identifier = Some(input.into());
            self
        }
        /// <p>The ID of the service in which the route is created. Traffic that matches this route is forwarded to this service.</p>
        pub fn set_service_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_identifier = input;
            self
        }
        /// <p>The route type of the route. <code>DEFAULT</code> indicates that all traffic that does not match another route is forwarded to the default route. Applications must have a default route before any other routes can be created. <code>URI_PATH</code> indicates a route that is based on a URI path.</p>
        pub fn route_type(mut self, input: crate::model::RouteType) -> Self {
            self.route_type = Some(input);
            self
        }
        /// <p>The route type of the route. <code>DEFAULT</code> indicates that all traffic that does not match another route is forwarded to the default route. Applications must have a default route before any other routes can be created. <code>URI_PATH</code> indicates a route that is based on a URI path.</p>
        pub fn set_route_type(
            mut self,
            input: std::option::Option<crate::model::RouteType>,
        ) -> Self {
            self.route_type = input;
            self
        }
        /// <p>The configuration for the URI path route type. </p>
        pub fn uri_path_route(mut self, input: crate::model::UriPathRouteInput) -> Self {
            self.uri_path_route = Some(input);
            self
        }
        /// <p>The configuration for the URI path route type. </p>
        pub fn set_uri_path_route(
            mut self,
            input: std::option::Option<crate::model::UriPathRouteInput>,
        ) -> Self {
            self.uri_path_route = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to assign to the route. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair.. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags to assign to the route. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair.. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRouteInput`](crate::input::CreateRouteInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateRouteInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateRouteInput {
                environment_identifier: self.environment_identifier,
                application_identifier: self.application_identifier,
                service_identifier: self.service_identifier,
                route_type: self.route_type,
                uri_path_route: self.uri_path_route,
                tags: self.tags,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateRouteInputOperationOutputAlias = crate::operation::CreateRoute;
#[doc(hidden)]
pub type CreateRouteInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateRouteInput {
    /// Consumes the builder and constructs an Operation<[`CreateRoute`](crate::operation::CreateRoute)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateRoute,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateRouteInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_2 = &_input.environment_identifier;
            let input_2 =
                input_2
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "environment_identifier",
                        details: "cannot be empty or unset",
                    })?;
            let environment_identifier = aws_smithy_http::label::fmt_string(input_2, false);
            if environment_identifier.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "environment_identifier",
                    details: "cannot be empty or unset",
                });
            }
            let input_3 = &_input.application_identifier;
            let input_3 =
                input_3
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_identifier",
                        details: "cannot be empty or unset",
                    })?;
            let application_identifier = aws_smithy_http::label::fmt_string(input_3, false);
            if application_identifier.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "application_identifier",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/environments/{EnvironmentIdentifier}/applications/{ApplicationIdentifier}/routes",
                EnvironmentIdentifier = environment_identifier,
                ApplicationIdentifier = application_identifier
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateRouteInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateRouteInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_route(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateRoute::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateRoute",
            "migrationhubrefactorspaces",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateRouteInput`](crate::input::CreateRouteInput)
    pub fn builder() -> crate::input::create_route_input::Builder {
        crate::input::create_route_input::Builder::default()
    }
}

/// See [`CreateServiceInput`](crate::input::CreateServiceInput)
pub mod create_service_input {
    /// A builder for [`CreateServiceInput`](crate::input::CreateServiceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) environment_identifier: std::option::Option<std::string::String>,
        pub(crate) application_identifier: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) endpoint_type: std::option::Option<crate::model::ServiceEndpointType>,
        pub(crate) url_endpoint: std::option::Option<crate::model::UrlEndpointInput>,
        pub(crate) lambda_endpoint: std::option::Option<crate::model::LambdaEndpointInput>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the service.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the service.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the service.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the service.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The ID of the environment in which the service is created.</p>
        pub fn environment_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_identifier = Some(input.into());
            self
        }
        /// <p>The ID of the environment in which the service is created.</p>
        pub fn set_environment_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_identifier = input;
            self
        }
        /// <p>The ID of the application which the service is created.</p>
        pub fn application_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_identifier = Some(input.into());
            self
        }
        /// <p>The ID of the application which the service is created.</p>
        pub fn set_application_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_identifier = input;
            self
        }
        /// <p>The ID of the VPC.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The ID of the VPC.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// <p>The type of endpoint to use for the service. The type can be a URL in a VPC or an Lambda function.</p>
        pub fn endpoint_type(mut self, input: crate::model::ServiceEndpointType) -> Self {
            self.endpoint_type = Some(input);
            self
        }
        /// <p>The type of endpoint to use for the service. The type can be a URL in a VPC or an Lambda function.</p>
        pub fn set_endpoint_type(
            mut self,
            input: std::option::Option<crate::model::ServiceEndpointType>,
        ) -> Self {
            self.endpoint_type = input;
            self
        }
        /// <p>The configuration for the URL endpoint type.</p>
        pub fn url_endpoint(mut self, input: crate::model::UrlEndpointInput) -> Self {
            self.url_endpoint = Some(input);
            self
        }
        /// <p>The configuration for the URL endpoint type.</p>
        pub fn set_url_endpoint(
            mut self,
            input: std::option::Option<crate::model::UrlEndpointInput>,
        ) -> Self {
            self.url_endpoint = input;
            self
        }
        /// <p>The configuration for the Lambda endpoint type.</p>
        pub fn lambda_endpoint(mut self, input: crate::model::LambdaEndpointInput) -> Self {
            self.lambda_endpoint = Some(input);
            self
        }
        /// <p>The configuration for the Lambda endpoint type.</p>
        pub fn set_lambda_endpoint(
            mut self,
            input: std::option::Option<crate::model::LambdaEndpointInput>,
        ) -> Self {
            self.lambda_endpoint = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to assign to the service. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair.. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags to assign to the service. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair.. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateServiceInput`](crate::input::CreateServiceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateServiceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateServiceInput {
                name: self.name,
                description: self.description,
                environment_identifier: self.environment_identifier,
                application_identifier: self.application_identifier,
                vpc_id: self.vpc_id,
                endpoint_type: self.endpoint_type,
                url_endpoint: self.url_endpoint,
                lambda_endpoint: self.lambda_endpoint,
                tags: self.tags,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateServiceInputOperationOutputAlias = crate::operation::CreateService;
#[doc(hidden)]
pub type CreateServiceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateServiceInput {
    /// Consumes the builder and constructs an Operation<[`CreateService`](crate::operation::CreateService)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateService,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateServiceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_4 = &_input.environment_identifier;
            let input_4 =
                input_4
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "environment_identifier",
                        details: "cannot be empty or unset",
                    })?;
            let environment_identifier = aws_smithy_http::label::fmt_string(input_4, false);
            if environment_identifier.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "environment_identifier",
                    details: "cannot be empty or unset",
                });
            }
            let input_5 = &_input.application_identifier;
            let input_5 =
                input_5
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_identifier",
                        details: "cannot be empty or unset",
                    })?;
            let application_identifier = aws_smithy_http::label::fmt_string(input_5, false);
            if application_identifier.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "application_identifier",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/environments/{EnvironmentIdentifier}/applications/{ApplicationIdentifier}/services", EnvironmentIdentifier = environment_identifier, ApplicationIdentifier = application_identifier).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateServiceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateServiceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_service(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateService::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateService",
            "migrationhubrefactorspaces",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateServiceInput`](crate::input::CreateServiceInput)
    pub fn builder() -> crate::input::create_service_input::Builder {
        crate::input::create_service_input::Builder::default()
    }
}

/// See [`DeleteApplicationInput`](crate::input::DeleteApplicationInput)
pub mod delete_application_input {
    /// A builder for [`DeleteApplicationInput`](crate::input::DeleteApplicationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environment_identifier: std::option::Option<std::string::String>,
        pub(crate) application_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the environment. </p>
        pub fn environment_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_identifier = Some(input.into());
            self
        }
        /// <p>The ID of the environment. </p>
        pub fn set_environment_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_identifier = input;
            self
        }
        /// <p>The ID of the application.</p>
        pub fn application_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_identifier = Some(input.into());
            self
        }
        /// <p>The ID of the application.</p>
        pub fn set_application_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteApplicationInput`](crate::input::DeleteApplicationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteApplicationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteApplicationInput {
                environment_identifier: self.environment_identifier,
                application_identifier: self.application_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteApplicationInputOperationOutputAlias = crate::operation::DeleteApplication;
#[doc(hidden)]
pub type DeleteApplicationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteApplicationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteApplication`](crate::operation::DeleteApplication)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteApplication,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteApplicationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_6 = &_input.environment_identifier;
            let input_6 =
                input_6
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "environment_identifier",
                        details: "cannot be empty or unset",
                    })?;
            let environment_identifier = aws_smithy_http::label::fmt_string(input_6, false);
            if environment_identifier.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "environment_identifier",
                    details: "cannot be empty or unset",
                });
            }
            let input_7 = &_input.application_identifier;
            let input_7 =
                input_7
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_identifier",
                        details: "cannot be empty or unset",
                    })?;
            let application_identifier = aws_smithy_http::label::fmt_string(input_7, false);
            if application_identifier.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "application_identifier",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/environments/{EnvironmentIdentifier}/applications/{ApplicationIdentifier}",
                EnvironmentIdentifier = environment_identifier,
                ApplicationIdentifier = application_identifier
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteApplicationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteApplicationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteApplication::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteApplication",
            "migrationhubrefactorspaces",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteApplicationInput`](crate::input::DeleteApplicationInput)
    pub fn builder() -> crate::input::delete_application_input::Builder {
        crate::input::delete_application_input::Builder::default()
    }
}

/// See [`DeleteEnvironmentInput`](crate::input::DeleteEnvironmentInput)
pub mod delete_environment_input {
    /// A builder for [`DeleteEnvironmentInput`](crate::input::DeleteEnvironmentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environment_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the environment. </p>
        pub fn environment_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_identifier = Some(input.into());
            self
        }
        /// <p>The ID of the environment. </p>
        pub fn set_environment_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteEnvironmentInput`](crate::input::DeleteEnvironmentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteEnvironmentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteEnvironmentInput {
                environment_identifier: self.environment_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteEnvironmentInputOperationOutputAlias = crate::operation::DeleteEnvironment;
#[doc(hidden)]
pub type DeleteEnvironmentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteEnvironmentInput {
    /// Consumes the builder and constructs an Operation<[`DeleteEnvironment`](crate::operation::DeleteEnvironment)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteEnvironment,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteEnvironmentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_8 = &_input.environment_identifier;
            let input_8 =
                input_8
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "environment_identifier",
                        details: "cannot be empty or unset",
                    })?;
            let environment_identifier = aws_smithy_http::label::fmt_string(input_8, false);
            if environment_identifier.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "environment_identifier",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/environments/{EnvironmentIdentifier}",
                EnvironmentIdentifier = environment_identifier
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteEnvironmentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteEnvironmentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteEnvironment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteEnvironment",
            "migrationhubrefactorspaces",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteEnvironmentInput`](crate::input::DeleteEnvironmentInput)
    pub fn builder() -> crate::input::delete_environment_input::Builder {
        crate::input::delete_environment_input::Builder::default()
    }
}

/// See [`DeleteResourcePolicyInput`](crate::input::DeleteResourcePolicyInput)
pub mod delete_resource_policy_input {
    /// A builder for [`DeleteResourcePolicyInput`](crate::input::DeleteResourcePolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon Resource Name (ARN) of the resource associated with the policy. </p>
        pub fn identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.identifier = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the resource associated with the policy. </p>
        pub fn set_identifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteResourcePolicyInput`](crate::input::DeleteResourcePolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteResourcePolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteResourcePolicyInput {
                identifier: self.identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteResourcePolicyInputOperationOutputAlias = crate::operation::DeleteResourcePolicy;
#[doc(hidden)]
pub type DeleteResourcePolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteResourcePolicyInput {
    /// Consumes the builder and constructs an Operation<[`DeleteResourcePolicy`](crate::operation::DeleteResourcePolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteResourcePolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteResourcePolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_9 = &_input.identifier;
            let input_9 =
                input_9
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "identifier",
                        details: "cannot be empty or unset",
                    })?;
            let identifier = aws_smithy_http::label::fmt_string(input_9, false);
            if identifier.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "identifier",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/resourcepolicy/{Identifier}",
                Identifier = identifier
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteResourcePolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteResourcePolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteResourcePolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteResourcePolicy",
            "migrationhubrefactorspaces",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteResourcePolicyInput`](crate::input::DeleteResourcePolicyInput)
    pub fn builder() -> crate::input::delete_resource_policy_input::Builder {
        crate::input::delete_resource_policy_input::Builder::default()
    }
}

/// See [`DeleteRouteInput`](crate::input::DeleteRouteInput)
pub mod delete_route_input {
    /// A builder for [`DeleteRouteInput`](crate::input::DeleteRouteInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environment_identifier: std::option::Option<std::string::String>,
        pub(crate) application_identifier: std::option::Option<std::string::String>,
        pub(crate) route_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the environment to delete the route from.</p>
        pub fn environment_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_identifier = Some(input.into());
            self
        }
        /// <p>The ID of the environment to delete the route from.</p>
        pub fn set_environment_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_identifier = input;
            self
        }
        /// <p>The ID of the application to delete the route from.</p>
        pub fn application_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_identifier = Some(input.into());
            self
        }
        /// <p>The ID of the application to delete the route from.</p>
        pub fn set_application_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_identifier = input;
            self
        }
        /// <p>The ID of the route to delete.</p>
        pub fn route_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_identifier = Some(input.into());
            self
        }
        /// <p>The ID of the route to delete.</p>
        pub fn set_route_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.route_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRouteInput`](crate::input::DeleteRouteInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteRouteInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteRouteInput {
                environment_identifier: self.environment_identifier,
                application_identifier: self.application_identifier,
                route_identifier: self.route_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteRouteInputOperationOutputAlias = crate::operation::DeleteRoute;
#[doc(hidden)]
pub type DeleteRouteInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteRouteInput {
    /// Consumes the builder and constructs an Operation<[`DeleteRoute`](crate::operation::DeleteRoute)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteRoute,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteRouteInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_10 = &_input.environment_identifier;
            let input_10 =
                input_10
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "environment_identifier",
                        details: "cannot be empty or unset",
                    })?;
            let environment_identifier = aws_smithy_http::label::fmt_string(input_10, false);
            if environment_identifier.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "environment_identifier",
                    details: "cannot be empty or unset",
                });
            }
            let input_11 = &_input.application_identifier;
            let input_11 =
                input_11
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_identifier",
                        details: "cannot be empty or unset",
                    })?;
            let application_identifier = aws_smithy_http::label::fmt_string(input_11, false);
            if application_identifier.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "application_identifier",
                    details: "cannot be empty or unset",
                });
            }
            let input_12 = &_input.route_identifier;
            let input_12 =
                input_12
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "route_identifier",
                        details: "cannot be empty or unset",
                    })?;
            let route_identifier = aws_smithy_http::label::fmt_string(input_12, false);
            if route_identifier.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "route_identifier",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/environments/{EnvironmentIdentifier}/applications/{ApplicationIdentifier}/routes/{RouteIdentifier}", EnvironmentIdentifier = environment_identifier, ApplicationIdentifier = application_identifier, RouteIdentifier = route_identifier).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteRouteInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteRouteInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteRoute::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteRoute",
            "migrationhubrefactorspaces",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteRouteInput`](crate::input::DeleteRouteInput)
    pub fn builder() -> crate::input::delete_route_input::Builder {
        crate::input::delete_route_input::Builder::default()
    }
}

/// See [`DeleteServiceInput`](crate::input::DeleteServiceInput)
pub mod delete_service_input {
    /// A builder for [`DeleteServiceInput`](crate::input::DeleteServiceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environment_identifier: std::option::Option<std::string::String>,
        pub(crate) application_identifier: std::option::Option<std::string::String>,
        pub(crate) service_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the environment that the service is in.</p>
        pub fn environment_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_identifier = Some(input.into());
            self
        }
        /// <p>The ID of the environment that the service is in.</p>
        pub fn set_environment_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_identifier = input;
            self
        }
        /// <p>Deletes a Refactor Spaces service.</p> <note>
        /// <p>The <code>RefactorSpacesSecurityGroup</code> security group must be removed from all Amazon Web Services resources in the virtual private cloud (VPC) prior to deleting a service with a URL endpoint in a VPC.</p>
        /// </note>
        pub fn application_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_identifier = Some(input.into());
            self
        }
        /// <p>Deletes a Refactor Spaces service.</p> <note>
        /// <p>The <code>RefactorSpacesSecurityGroup</code> security group must be removed from all Amazon Web Services resources in the virtual private cloud (VPC) prior to deleting a service with a URL endpoint in a VPC.</p>
        /// </note>
        pub fn set_application_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_identifier = input;
            self
        }
        /// <p>The ID of the service to delete.</p>
        pub fn service_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_identifier = Some(input.into());
            self
        }
        /// <p>The ID of the service to delete.</p>
        pub fn set_service_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteServiceInput`](crate::input::DeleteServiceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteServiceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteServiceInput {
                environment_identifier: self.environment_identifier,
                application_identifier: self.application_identifier,
                service_identifier: self.service_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteServiceInputOperationOutputAlias = crate::operation::DeleteService;
#[doc(hidden)]
pub type DeleteServiceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteServiceInput {
    /// Consumes the builder and constructs an Operation<[`DeleteService`](crate::operation::DeleteService)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteService,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteServiceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_13 = &_input.environment_identifier;
            let input_13 =
                input_13
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "environment_identifier",
                        details: "cannot be empty or unset",
                    })?;
            let environment_identifier = aws_smithy_http::label::fmt_string(input_13, false);
            if environment_identifier.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "environment_identifier",
                    details: "cannot be empty or unset",
                });
            }
            let input_14 = &_input.application_identifier;
            let input_14 =
                input_14
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_identifier",
                        details: "cannot be empty or unset",
                    })?;
            let application_identifier = aws_smithy_http::label::fmt_string(input_14, false);
            if application_identifier.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "application_identifier",
                    details: "cannot be empty or unset",
                });
            }
            let input_15 = &_input.service_identifier;
            let input_15 =
                input_15
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "service_identifier",
                        details: "cannot be empty or unset",
                    })?;
            let service_identifier = aws_smithy_http::label::fmt_string(input_15, false);
            if service_identifier.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "service_identifier",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/environments/{EnvironmentIdentifier}/applications/{ApplicationIdentifier}/services/{ServiceIdentifier}", EnvironmentIdentifier = environment_identifier, ApplicationIdentifier = application_identifier, ServiceIdentifier = service_identifier).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteServiceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteServiceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteService::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteService",
            "migrationhubrefactorspaces",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteServiceInput`](crate::input::DeleteServiceInput)
    pub fn builder() -> crate::input::delete_service_input::Builder {
        crate::input::delete_service_input::Builder::default()
    }
}

/// See [`GetApplicationInput`](crate::input::GetApplicationInput)
pub mod get_application_input {
    /// A builder for [`GetApplicationInput`](crate::input::GetApplicationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environment_identifier: std::option::Option<std::string::String>,
        pub(crate) application_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the environment. </p>
        pub fn environment_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_identifier = Some(input.into());
            self
        }
        /// <p>The ID of the environment. </p>
        pub fn set_environment_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_identifier = input;
            self
        }
        /// <p>The ID of the application.</p>
        pub fn application_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_identifier = Some(input.into());
            self
        }
        /// <p>The ID of the application.</p>
        pub fn set_application_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`GetApplicationInput`](crate::input::GetApplicationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetApplicationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetApplicationInput {
                environment_identifier: self.environment_identifier,
                application_identifier: self.application_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type GetApplicationInputOperationOutputAlias = crate::operation::GetApplication;
#[doc(hidden)]
pub type GetApplicationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetApplicationInput {
    /// Consumes the builder and constructs an Operation<[`GetApplication`](crate::operation::GetApplication)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetApplication,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetApplicationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_16 = &_input.environment_identifier;
            let input_16 =
                input_16
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "environment_identifier",
                        details: "cannot be empty or unset",
                    })?;
            let environment_identifier = aws_smithy_http::label::fmt_string(input_16, false);
            if environment_identifier.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "environment_identifier",
                    details: "cannot be empty or unset",
                });
            }
            let input_17 = &_input.application_identifier;
            let input_17 =
                input_17
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_identifier",
                        details: "cannot be empty or unset",
                    })?;
            let application_identifier = aws_smithy_http::label::fmt_string(input_17, false);
            if application_identifier.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "application_identifier",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/environments/{EnvironmentIdentifier}/applications/{ApplicationIdentifier}",
                EnvironmentIdentifier = environment_identifier,
                ApplicationIdentifier = application_identifier
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetApplicationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetApplicationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetApplication::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetApplication",
            "migrationhubrefactorspaces",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetApplicationInput`](crate::input::GetApplicationInput)
    pub fn builder() -> crate::input::get_application_input::Builder {
        crate::input::get_application_input::Builder::default()
    }
}

/// See [`GetEnvironmentInput`](crate::input::GetEnvironmentInput)
pub mod get_environment_input {
    /// A builder for [`GetEnvironmentInput`](crate::input::GetEnvironmentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environment_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the environment.</p>
        pub fn environment_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_identifier = Some(input.into());
            self
        }
        /// <p>The ID of the environment.</p>
        pub fn set_environment_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEnvironmentInput`](crate::input::GetEnvironmentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetEnvironmentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetEnvironmentInput {
                environment_identifier: self.environment_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type GetEnvironmentInputOperationOutputAlias = crate::operation::GetEnvironment;
#[doc(hidden)]
pub type GetEnvironmentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetEnvironmentInput {
    /// Consumes the builder and constructs an Operation<[`GetEnvironment`](crate::operation::GetEnvironment)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetEnvironment,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetEnvironmentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_18 = &_input.environment_identifier;
            let input_18 =
                input_18
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "environment_identifier",
                        details: "cannot be empty or unset",
                    })?;
            let environment_identifier = aws_smithy_http::label::fmt_string(input_18, false);
            if environment_identifier.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "environment_identifier",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/environments/{EnvironmentIdentifier}",
                EnvironmentIdentifier = environment_identifier
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetEnvironmentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetEnvironmentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetEnvironment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetEnvironment",
            "migrationhubrefactorspaces",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetEnvironmentInput`](crate::input::GetEnvironmentInput)
    pub fn builder() -> crate::input::get_environment_input::Builder {
        crate::input::get_environment_input::Builder::default()
    }
}

/// See [`GetResourcePolicyInput`](crate::input::GetResourcePolicyInput)
pub mod get_resource_policy_input {
    /// A builder for [`GetResourcePolicyInput`](crate::input::GetResourcePolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource associated with the policy. </p>
        pub fn identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.identifier = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource associated with the policy. </p>
        pub fn set_identifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`GetResourcePolicyInput`](crate::input::GetResourcePolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetResourcePolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetResourcePolicyInput {
                identifier: self.identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type GetResourcePolicyInputOperationOutputAlias = crate::operation::GetResourcePolicy;
#[doc(hidden)]
pub type GetResourcePolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetResourcePolicyInput {
    /// Consumes the builder and constructs an Operation<[`GetResourcePolicy`](crate::operation::GetResourcePolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetResourcePolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetResourcePolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_19 = &_input.identifier;
            let input_19 =
                input_19
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "identifier",
                        details: "cannot be empty or unset",
                    })?;
            let identifier = aws_smithy_http::label::fmt_string(input_19, false);
            if identifier.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "identifier",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/resourcepolicy/{Identifier}",
                Identifier = identifier
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetResourcePolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetResourcePolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetResourcePolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetResourcePolicy",
            "migrationhubrefactorspaces",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetResourcePolicyInput`](crate::input::GetResourcePolicyInput)
    pub fn builder() -> crate::input::get_resource_policy_input::Builder {
        crate::input::get_resource_policy_input::Builder::default()
    }
}

/// See [`GetRouteInput`](crate::input::GetRouteInput)
pub mod get_route_input {
    /// A builder for [`GetRouteInput`](crate::input::GetRouteInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environment_identifier: std::option::Option<std::string::String>,
        pub(crate) application_identifier: std::option::Option<std::string::String>,
        pub(crate) route_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the environment.</p>
        pub fn environment_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_identifier = Some(input.into());
            self
        }
        /// <p>The ID of the environment.</p>
        pub fn set_environment_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_identifier = input;
            self
        }
        /// <p>The ID of the application. </p>
        pub fn application_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_identifier = Some(input.into());
            self
        }
        /// <p>The ID of the application. </p>
        pub fn set_application_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_identifier = input;
            self
        }
        /// <p>The ID of the route.</p>
        pub fn route_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_identifier = Some(input.into());
            self
        }
        /// <p>The ID of the route.</p>
        pub fn set_route_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.route_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRouteInput`](crate::input::GetRouteInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetRouteInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetRouteInput {
                environment_identifier: self.environment_identifier,
                application_identifier: self.application_identifier,
                route_identifier: self.route_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type GetRouteInputOperationOutputAlias = crate::operation::GetRoute;
#[doc(hidden)]
pub type GetRouteInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetRouteInput {
    /// Consumes the builder and constructs an Operation<[`GetRoute`](crate::operation::GetRoute)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetRoute,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetRouteInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_20 = &_input.environment_identifier;
            let input_20 =
                input_20
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "environment_identifier",
                        details: "cannot be empty or unset",
                    })?;
            let environment_identifier = aws_smithy_http::label::fmt_string(input_20, false);
            if environment_identifier.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "environment_identifier",
                    details: "cannot be empty or unset",
                });
            }
            let input_21 = &_input.application_identifier;
            let input_21 =
                input_21
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_identifier",
                        details: "cannot be empty or unset",
                    })?;
            let application_identifier = aws_smithy_http::label::fmt_string(input_21, false);
            if application_identifier.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "application_identifier",
                    details: "cannot be empty or unset",
                });
            }
            let input_22 = &_input.route_identifier;
            let input_22 =
                input_22
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "route_identifier",
                        details: "cannot be empty or unset",
                    })?;
            let route_identifier = aws_smithy_http::label::fmt_string(input_22, false);
            if route_identifier.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "route_identifier",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/environments/{EnvironmentIdentifier}/applications/{ApplicationIdentifier}/routes/{RouteIdentifier}", EnvironmentIdentifier = environment_identifier, ApplicationIdentifier = application_identifier, RouteIdentifier = route_identifier).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetRouteInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetRouteInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetRoute::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetRoute",
                    "migrationhubrefactorspaces",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetRouteInput`](crate::input::GetRouteInput)
    pub fn builder() -> crate::input::get_route_input::Builder {
        crate::input::get_route_input::Builder::default()
    }
}

/// See [`GetServiceInput`](crate::input::GetServiceInput)
pub mod get_service_input {
    /// A builder for [`GetServiceInput`](crate::input::GetServiceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environment_identifier: std::option::Option<std::string::String>,
        pub(crate) application_identifier: std::option::Option<std::string::String>,
        pub(crate) service_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the environment.</p>
        pub fn environment_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_identifier = Some(input.into());
            self
        }
        /// <p>The ID of the environment.</p>
        pub fn set_environment_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_identifier = input;
            self
        }
        /// <p>The ID of the application.</p>
        pub fn application_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_identifier = Some(input.into());
            self
        }
        /// <p>The ID of the application.</p>
        pub fn set_application_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_identifier = input;
            self
        }
        /// <p>The ID of the service.</p>
        pub fn service_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_identifier = Some(input.into());
            self
        }
        /// <p>The ID of the service.</p>
        pub fn set_service_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`GetServiceInput`](crate::input::GetServiceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetServiceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetServiceInput {
                environment_identifier: self.environment_identifier,
                application_identifier: self.application_identifier,
                service_identifier: self.service_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type GetServiceInputOperationOutputAlias = crate::operation::GetService;
#[doc(hidden)]
pub type GetServiceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetServiceInput {
    /// Consumes the builder and constructs an Operation<[`GetService`](crate::operation::GetService)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetService,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetServiceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_23 = &_input.environment_identifier;
            let input_23 =
                input_23
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "environment_identifier",
                        details: "cannot be empty or unset",
                    })?;
            let environment_identifier = aws_smithy_http::label::fmt_string(input_23, false);
            if environment_identifier.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "environment_identifier",
                    details: "cannot be empty or unset",
                });
            }
            let input_24 = &_input.application_identifier;
            let input_24 =
                input_24
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_identifier",
                        details: "cannot be empty or unset",
                    })?;
            let application_identifier = aws_smithy_http::label::fmt_string(input_24, false);
            if application_identifier.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "application_identifier",
                    details: "cannot be empty or unset",
                });
            }
            let input_25 = &_input.service_identifier;
            let input_25 =
                input_25
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "service_identifier",
                        details: "cannot be empty or unset",
                    })?;
            let service_identifier = aws_smithy_http::label::fmt_string(input_25, false);
            if service_identifier.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "service_identifier",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/environments/{EnvironmentIdentifier}/applications/{ApplicationIdentifier}/services/{ServiceIdentifier}", EnvironmentIdentifier = environment_identifier, ApplicationIdentifier = application_identifier, ServiceIdentifier = service_identifier).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetServiceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetServiceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetService::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetService",
            "migrationhubrefactorspaces",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetServiceInput`](crate::input::GetServiceInput)
    pub fn builder() -> crate::input::get_service_input::Builder {
        crate::input::get_service_input::Builder::default()
    }
}

/// See [`ListApplicationsInput`](crate::input::ListApplicationsInput)
pub mod list_applications_input {
    /// A builder for [`ListApplicationsInput`](crate::input::ListApplicationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environment_identifier: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of the environment. </p>
        pub fn environment_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_identifier = Some(input.into());
            self
        }
        /// <p>The ID of the environment. </p>
        pub fn set_environment_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_identifier = input;
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListApplicationsInput`](crate::input::ListApplicationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListApplicationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListApplicationsInput {
                environment_identifier: self.environment_identifier,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListApplicationsInputOperationOutputAlias = crate::operation::ListApplications;
#[doc(hidden)]
pub type ListApplicationsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListApplicationsInput {
    /// Consumes the builder and constructs an Operation<[`ListApplications`](crate::operation::ListApplications)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListApplications,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListApplicationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_26 = &_input.environment_identifier;
            let input_26 =
                input_26
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "environment_identifier",
                        details: "cannot be empty or unset",
                    })?;
            let environment_identifier = aws_smithy_http::label::fmt_string(input_26, false);
            if environment_identifier.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "environment_identifier",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/environments/{EnvironmentIdentifier}/applications",
                EnvironmentIdentifier = environment_identifier
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListApplicationsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_27) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_27));
            }
            if let Some(inner_28) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_28).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListApplicationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListApplicationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListApplications::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListApplications",
            "migrationhubrefactorspaces",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListApplicationsInput`](crate::input::ListApplicationsInput)
    pub fn builder() -> crate::input::list_applications_input::Builder {
        crate::input::list_applications_input::Builder::default()
    }
}

/// See [`ListEnvironmentsInput`](crate::input::ListEnvironmentsInput)
pub mod list_environments_input {
    /// A builder for [`ListEnvironmentsInput`](crate::input::ListEnvironmentsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListEnvironmentsInput`](crate::input::ListEnvironmentsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListEnvironmentsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListEnvironmentsInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListEnvironmentsInputOperationOutputAlias = crate::operation::ListEnvironments;
#[doc(hidden)]
pub type ListEnvironmentsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListEnvironmentsInput {
    /// Consumes the builder and constructs an Operation<[`ListEnvironments`](crate::operation::ListEnvironments)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListEnvironments,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListEnvironmentsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/environments").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListEnvironmentsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_29) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_29));
            }
            if let Some(inner_30) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_30).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListEnvironmentsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListEnvironmentsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListEnvironments::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListEnvironments",
            "migrationhubrefactorspaces",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListEnvironmentsInput`](crate::input::ListEnvironmentsInput)
    pub fn builder() -> crate::input::list_environments_input::Builder {
        crate::input::list_environments_input::Builder::default()
    }
}

/// See [`ListEnvironmentVpcsInput`](crate::input::ListEnvironmentVpcsInput)
pub mod list_environment_vpcs_input {
    /// A builder for [`ListEnvironmentVpcsInput`](crate::input::ListEnvironmentVpcsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environment_identifier: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of the environment. </p>
        pub fn environment_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_identifier = Some(input.into());
            self
        }
        /// <p>The ID of the environment. </p>
        pub fn set_environment_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_identifier = input;
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListEnvironmentVpcsInput`](crate::input::ListEnvironmentVpcsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListEnvironmentVpcsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListEnvironmentVpcsInput {
                environment_identifier: self.environment_identifier,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListEnvironmentVpcsInputOperationOutputAlias = crate::operation::ListEnvironmentVpcs;
#[doc(hidden)]
pub type ListEnvironmentVpcsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListEnvironmentVpcsInput {
    /// Consumes the builder and constructs an Operation<[`ListEnvironmentVpcs`](crate::operation::ListEnvironmentVpcs)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListEnvironmentVpcs,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListEnvironmentVpcsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_31 = &_input.environment_identifier;
            let input_31 =
                input_31
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "environment_identifier",
                        details: "cannot be empty or unset",
                    })?;
            let environment_identifier = aws_smithy_http::label::fmt_string(input_31, false);
            if environment_identifier.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "environment_identifier",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/environments/{EnvironmentIdentifier}/vpcs",
                EnvironmentIdentifier = environment_identifier
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListEnvironmentVpcsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_32) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_32));
            }
            if let Some(inner_33) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_33).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListEnvironmentVpcsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListEnvironmentVpcsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListEnvironmentVpcs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListEnvironmentVpcs",
            "migrationhubrefactorspaces",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListEnvironmentVpcsInput`](crate::input::ListEnvironmentVpcsInput)
    pub fn builder() -> crate::input::list_environment_vpcs_input::Builder {
        crate::input::list_environment_vpcs_input::Builder::default()
    }
}

/// See [`ListRoutesInput`](crate::input::ListRoutesInput)
pub mod list_routes_input {
    /// A builder for [`ListRoutesInput`](crate::input::ListRoutesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environment_identifier: std::option::Option<std::string::String>,
        pub(crate) application_identifier: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of the environment. </p>
        pub fn environment_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_identifier = Some(input.into());
            self
        }
        /// <p>The ID of the environment. </p>
        pub fn set_environment_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_identifier = input;
            self
        }
        /// <p>The ID of the application. </p>
        pub fn application_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_identifier = Some(input.into());
            self
        }
        /// <p>The ID of the application. </p>
        pub fn set_application_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_identifier = input;
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRoutesInput`](crate::input::ListRoutesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListRoutesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListRoutesInput {
                environment_identifier: self.environment_identifier,
                application_identifier: self.application_identifier,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListRoutesInputOperationOutputAlias = crate::operation::ListRoutes;
#[doc(hidden)]
pub type ListRoutesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListRoutesInput {
    /// Consumes the builder and constructs an Operation<[`ListRoutes`](crate::operation::ListRoutes)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListRoutes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListRoutesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_34 = &_input.environment_identifier;
            let input_34 =
                input_34
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "environment_identifier",
                        details: "cannot be empty or unset",
                    })?;
            let environment_identifier = aws_smithy_http::label::fmt_string(input_34, false);
            if environment_identifier.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "environment_identifier",
                    details: "cannot be empty or unset",
                });
            }
            let input_35 = &_input.application_identifier;
            let input_35 =
                input_35
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_identifier",
                        details: "cannot be empty or unset",
                    })?;
            let application_identifier = aws_smithy_http::label::fmt_string(input_35, false);
            if application_identifier.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "application_identifier",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/environments/{EnvironmentIdentifier}/applications/{ApplicationIdentifier}/routes",
                EnvironmentIdentifier = environment_identifier,
                ApplicationIdentifier = application_identifier
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListRoutesInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_36) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_36));
            }
            if let Some(inner_37) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_37).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListRoutesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListRoutesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListRoutes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListRoutes",
            "migrationhubrefactorspaces",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListRoutesInput`](crate::input::ListRoutesInput)
    pub fn builder() -> crate::input::list_routes_input::Builder {
        crate::input::list_routes_input::Builder::default()
    }
}

/// See [`ListServicesInput`](crate::input::ListServicesInput)
pub mod list_services_input {
    /// A builder for [`ListServicesInput`](crate::input::ListServicesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environment_identifier: std::option::Option<std::string::String>,
        pub(crate) application_identifier: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of the environment. </p>
        pub fn environment_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_identifier = Some(input.into());
            self
        }
        /// <p>The ID of the environment. </p>
        pub fn set_environment_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_identifier = input;
            self
        }
        /// <p>The ID of the application. </p>
        pub fn application_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_identifier = Some(input.into());
            self
        }
        /// <p>The ID of the application. </p>
        pub fn set_application_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_identifier = input;
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListServicesInput`](crate::input::ListServicesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListServicesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListServicesInput {
                environment_identifier: self.environment_identifier,
                application_identifier: self.application_identifier,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListServicesInputOperationOutputAlias = crate::operation::ListServices;
#[doc(hidden)]
pub type ListServicesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListServicesInput {
    /// Consumes the builder and constructs an Operation<[`ListServices`](crate::operation::ListServices)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListServices,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListServicesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_38 = &_input.environment_identifier;
            let input_38 =
                input_38
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "environment_identifier",
                        details: "cannot be empty or unset",
                    })?;
            let environment_identifier = aws_smithy_http::label::fmt_string(input_38, false);
            if environment_identifier.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "environment_identifier",
                    details: "cannot be empty or unset",
                });
            }
            let input_39 = &_input.application_identifier;
            let input_39 =
                input_39
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "application_identifier",
                        details: "cannot be empty or unset",
                    })?;
            let application_identifier = aws_smithy_http::label::fmt_string(input_39, false);
            if application_identifier.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "application_identifier",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/environments/{EnvironmentIdentifier}/applications/{ApplicationIdentifier}/services", EnvironmentIdentifier = environment_identifier, ApplicationIdentifier = application_identifier).expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListServicesInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_40) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_40));
            }
            if let Some(inner_41) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_41).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListServicesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListServicesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListServices::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListServices",
            "migrationhubrefactorspaces",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListServicesInput`](crate::input::ListServicesInput)
    pub fn builder() -> crate::input::list_services_input::Builder {
        crate::input::list_services_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_42 = &_input.resource_arn;
            let input_42 =
                input_42
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_42, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "migrationhubrefactorspaces",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`PutResourcePolicyInput`](crate::input::PutResourcePolicyInput)
pub mod put_resource_policy_input {
    /// A builder for [`PutResourcePolicyInput`](crate::input::PutResourcePolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) policy: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource to which the policy is being attached. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to which the policy is being attached. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>A JSON-formatted string for an Amazon Web Services resource-based policy. </p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>A JSON-formatted string for an Amazon Web Services resource-based policy. </p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`PutResourcePolicyInput`](crate::input::PutResourcePolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutResourcePolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutResourcePolicyInput {
                resource_arn: self.resource_arn,
                policy: self.policy,
            })
        }
    }
}
#[doc(hidden)]
pub type PutResourcePolicyInputOperationOutputAlias = crate::operation::PutResourcePolicy;
#[doc(hidden)]
pub type PutResourcePolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutResourcePolicyInput {
    /// Consumes the builder and constructs an Operation<[`PutResourcePolicy`](crate::operation::PutResourcePolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutResourcePolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutResourcePolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/resourcepolicy").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutResourcePolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutResourcePolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_resource_policy(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutResourcePolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutResourcePolicy",
            "migrationhubrefactorspaces",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutResourcePolicyInput`](crate::input::PutResourcePolicyInput)
    pub fn builder() -> crate::input::put_resource_policy_input::Builder {
        crate::input::put_resource_policy_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The new or modified tags for the resource. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The new or modified tags for the resource. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_43 = &_input.resource_arn;
            let input_43 =
                input_43
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_43, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "migrationhubrefactorspaces",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The list of keys of the tags to be removed from the resource. </p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The list of keys of the tags to be removed from the resource. </p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_44 = &_input.resource_arn;
            let input_44 =
                input_44
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_44, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::UntagResourceInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_45) = &_input.tag_keys {
                for inner_46 in inner_45 {
                    query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_46));
                }
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "migrationhubrefactorspaces",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource. </p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The list of keys of the tags to be removed from the resource. </p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource. </p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The list of keys of the tags to be removed from the resource. </p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The new or modified tags for the resource. </p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The new or modified tags for the resource. </p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutResourcePolicyInput {
    /// <p>The Amazon Resource Name (ARN) of the resource to which the policy is being attached. </p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A JSON-formatted string for an Amazon Web Services resource-based policy. </p>
    pub policy: std::option::Option<std::string::String>,
}
impl PutResourcePolicyInput {
    /// <p>The Amazon Resource Name (ARN) of the resource to which the policy is being attached. </p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>A JSON-formatted string for an Amazon Web Services resource-based policy. </p>
    pub fn policy(&self) -> std::option::Option<&str> {
        self.policy.as_deref()
    }
}
impl std::fmt::Debug for PutResourcePolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutResourcePolicyInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource. </p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource. </p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListServicesInput {
    /// <p>The ID of the environment. </p>
    pub environment_identifier: std::option::Option<std::string::String>,
    /// <p>The ID of the application. </p>
    pub application_identifier: std::option::Option<std::string::String>,
    /// <p>The token for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListServicesInput {
    /// <p>The ID of the environment. </p>
    pub fn environment_identifier(&self) -> std::option::Option<&str> {
        self.environment_identifier.as_deref()
    }
    /// <p>The ID of the application. </p>
    pub fn application_identifier(&self) -> std::option::Option<&str> {
        self.application_identifier.as_deref()
    }
    /// <p>The token for the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListServicesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListServicesInput");
        formatter.field("environment_identifier", &self.environment_identifier);
        formatter.field("application_identifier", &self.application_identifier);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRoutesInput {
    /// <p>The ID of the environment. </p>
    pub environment_identifier: std::option::Option<std::string::String>,
    /// <p>The ID of the application. </p>
    pub application_identifier: std::option::Option<std::string::String>,
    /// <p>The token for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListRoutesInput {
    /// <p>The ID of the environment. </p>
    pub fn environment_identifier(&self) -> std::option::Option<&str> {
        self.environment_identifier.as_deref()
    }
    /// <p>The ID of the application. </p>
    pub fn application_identifier(&self) -> std::option::Option<&str> {
        self.application_identifier.as_deref()
    }
    /// <p>The token for the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListRoutesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRoutesInput");
        formatter.field("environment_identifier", &self.environment_identifier);
        formatter.field("application_identifier", &self.application_identifier);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListEnvironmentVpcsInput {
    /// <p>The ID of the environment. </p>
    pub environment_identifier: std::option::Option<std::string::String>,
    /// <p>The token for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListEnvironmentVpcsInput {
    /// <p>The ID of the environment. </p>
    pub fn environment_identifier(&self) -> std::option::Option<&str> {
        self.environment_identifier.as_deref()
    }
    /// <p>The token for the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListEnvironmentVpcsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListEnvironmentVpcsInput");
        formatter.field("environment_identifier", &self.environment_identifier);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListEnvironmentsInput {
    /// <p>The token for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListEnvironmentsInput {
    /// <p>The token for the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListEnvironmentsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListEnvironmentsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListApplicationsInput {
    /// <p>The ID of the environment. </p>
    pub environment_identifier: std::option::Option<std::string::String>,
    /// <p>The token for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListApplicationsInput {
    /// <p>The ID of the environment. </p>
    pub fn environment_identifier(&self) -> std::option::Option<&str> {
        self.environment_identifier.as_deref()
    }
    /// <p>The token for the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListApplicationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListApplicationsInput");
        formatter.field("environment_identifier", &self.environment_identifier);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetServiceInput {
    /// <p>The ID of the environment.</p>
    pub environment_identifier: std::option::Option<std::string::String>,
    /// <p>The ID of the application.</p>
    pub application_identifier: std::option::Option<std::string::String>,
    /// <p>The ID of the service.</p>
    pub service_identifier: std::option::Option<std::string::String>,
}
impl GetServiceInput {
    /// <p>The ID of the environment.</p>
    pub fn environment_identifier(&self) -> std::option::Option<&str> {
        self.environment_identifier.as_deref()
    }
    /// <p>The ID of the application.</p>
    pub fn application_identifier(&self) -> std::option::Option<&str> {
        self.application_identifier.as_deref()
    }
    /// <p>The ID of the service.</p>
    pub fn service_identifier(&self) -> std::option::Option<&str> {
        self.service_identifier.as_deref()
    }
}
impl std::fmt::Debug for GetServiceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetServiceInput");
        formatter.field("environment_identifier", &self.environment_identifier);
        formatter.field("application_identifier", &self.application_identifier);
        formatter.field("service_identifier", &self.service_identifier);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRouteInput {
    /// <p>The ID of the environment.</p>
    pub environment_identifier: std::option::Option<std::string::String>,
    /// <p>The ID of the application. </p>
    pub application_identifier: std::option::Option<std::string::String>,
    /// <p>The ID of the route.</p>
    pub route_identifier: std::option::Option<std::string::String>,
}
impl GetRouteInput {
    /// <p>The ID of the environment.</p>
    pub fn environment_identifier(&self) -> std::option::Option<&str> {
        self.environment_identifier.as_deref()
    }
    /// <p>The ID of the application. </p>
    pub fn application_identifier(&self) -> std::option::Option<&str> {
        self.application_identifier.as_deref()
    }
    /// <p>The ID of the route.</p>
    pub fn route_identifier(&self) -> std::option::Option<&str> {
        self.route_identifier.as_deref()
    }
}
impl std::fmt::Debug for GetRouteInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRouteInput");
        formatter.field("environment_identifier", &self.environment_identifier);
        formatter.field("application_identifier", &self.application_identifier);
        formatter.field("route_identifier", &self.route_identifier);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetResourcePolicyInput {
    /// <p>The Amazon Resource Name (ARN) of the resource associated with the policy. </p>
    pub identifier: std::option::Option<std::string::String>,
}
impl GetResourcePolicyInput {
    /// <p>The Amazon Resource Name (ARN) of the resource associated with the policy. </p>
    pub fn identifier(&self) -> std::option::Option<&str> {
        self.identifier.as_deref()
    }
}
impl std::fmt::Debug for GetResourcePolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetResourcePolicyInput");
        formatter.field("identifier", &self.identifier);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEnvironmentInput {
    /// <p>The ID of the environment.</p>
    pub environment_identifier: std::option::Option<std::string::String>,
}
impl GetEnvironmentInput {
    /// <p>The ID of the environment.</p>
    pub fn environment_identifier(&self) -> std::option::Option<&str> {
        self.environment_identifier.as_deref()
    }
}
impl std::fmt::Debug for GetEnvironmentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEnvironmentInput");
        formatter.field("environment_identifier", &self.environment_identifier);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetApplicationInput {
    /// <p>The ID of the environment. </p>
    pub environment_identifier: std::option::Option<std::string::String>,
    /// <p>The ID of the application.</p>
    pub application_identifier: std::option::Option<std::string::String>,
}
impl GetApplicationInput {
    /// <p>The ID of the environment. </p>
    pub fn environment_identifier(&self) -> std::option::Option<&str> {
        self.environment_identifier.as_deref()
    }
    /// <p>The ID of the application.</p>
    pub fn application_identifier(&self) -> std::option::Option<&str> {
        self.application_identifier.as_deref()
    }
}
impl std::fmt::Debug for GetApplicationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetApplicationInput");
        formatter.field("environment_identifier", &self.environment_identifier);
        formatter.field("application_identifier", &self.application_identifier);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteServiceInput {
    /// <p>The ID of the environment that the service is in.</p>
    pub environment_identifier: std::option::Option<std::string::String>,
    /// <p>Deletes a Refactor Spaces service.</p> <note>
    /// <p>The <code>RefactorSpacesSecurityGroup</code> security group must be removed from all Amazon Web Services resources in the virtual private cloud (VPC) prior to deleting a service with a URL endpoint in a VPC.</p>
    /// </note>
    pub application_identifier: std::option::Option<std::string::String>,
    /// <p>The ID of the service to delete.</p>
    pub service_identifier: std::option::Option<std::string::String>,
}
impl DeleteServiceInput {
    /// <p>The ID of the environment that the service is in.</p>
    pub fn environment_identifier(&self) -> std::option::Option<&str> {
        self.environment_identifier.as_deref()
    }
    /// <p>Deletes a Refactor Spaces service.</p> <note>
    /// <p>The <code>RefactorSpacesSecurityGroup</code> security group must be removed from all Amazon Web Services resources in the virtual private cloud (VPC) prior to deleting a service with a URL endpoint in a VPC.</p>
    /// </note>
    pub fn application_identifier(&self) -> std::option::Option<&str> {
        self.application_identifier.as_deref()
    }
    /// <p>The ID of the service to delete.</p>
    pub fn service_identifier(&self) -> std::option::Option<&str> {
        self.service_identifier.as_deref()
    }
}
impl std::fmt::Debug for DeleteServiceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteServiceInput");
        formatter.field("environment_identifier", &self.environment_identifier);
        formatter.field("application_identifier", &self.application_identifier);
        formatter.field("service_identifier", &self.service_identifier);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRouteInput {
    /// <p>The ID of the environment to delete the route from.</p>
    pub environment_identifier: std::option::Option<std::string::String>,
    /// <p>The ID of the application to delete the route from.</p>
    pub application_identifier: std::option::Option<std::string::String>,
    /// <p>The ID of the route to delete.</p>
    pub route_identifier: std::option::Option<std::string::String>,
}
impl DeleteRouteInput {
    /// <p>The ID of the environment to delete the route from.</p>
    pub fn environment_identifier(&self) -> std::option::Option<&str> {
        self.environment_identifier.as_deref()
    }
    /// <p>The ID of the application to delete the route from.</p>
    pub fn application_identifier(&self) -> std::option::Option<&str> {
        self.application_identifier.as_deref()
    }
    /// <p>The ID of the route to delete.</p>
    pub fn route_identifier(&self) -> std::option::Option<&str> {
        self.route_identifier.as_deref()
    }
}
impl std::fmt::Debug for DeleteRouteInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRouteInput");
        formatter.field("environment_identifier", &self.environment_identifier);
        formatter.field("application_identifier", &self.application_identifier);
        formatter.field("route_identifier", &self.route_identifier);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteResourcePolicyInput {
    /// <p>Amazon Resource Name (ARN) of the resource associated with the policy. </p>
    pub identifier: std::option::Option<std::string::String>,
}
impl DeleteResourcePolicyInput {
    /// <p>Amazon Resource Name (ARN) of the resource associated with the policy. </p>
    pub fn identifier(&self) -> std::option::Option<&str> {
        self.identifier.as_deref()
    }
}
impl std::fmt::Debug for DeleteResourcePolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteResourcePolicyInput");
        formatter.field("identifier", &self.identifier);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteEnvironmentInput {
    /// <p>The ID of the environment. </p>
    pub environment_identifier: std::option::Option<std::string::String>,
}
impl DeleteEnvironmentInput {
    /// <p>The ID of the environment. </p>
    pub fn environment_identifier(&self) -> std::option::Option<&str> {
        self.environment_identifier.as_deref()
    }
}
impl std::fmt::Debug for DeleteEnvironmentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteEnvironmentInput");
        formatter.field("environment_identifier", &self.environment_identifier);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteApplicationInput {
    /// <p>The ID of the environment. </p>
    pub environment_identifier: std::option::Option<std::string::String>,
    /// <p>The ID of the application.</p>
    pub application_identifier: std::option::Option<std::string::String>,
}
impl DeleteApplicationInput {
    /// <p>The ID of the environment. </p>
    pub fn environment_identifier(&self) -> std::option::Option<&str> {
        self.environment_identifier.as_deref()
    }
    /// <p>The ID of the application.</p>
    pub fn application_identifier(&self) -> std::option::Option<&str> {
        self.application_identifier.as_deref()
    }
}
impl std::fmt::Debug for DeleteApplicationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteApplicationInput");
        formatter.field("environment_identifier", &self.environment_identifier);
        formatter.field("application_identifier", &self.application_identifier);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateServiceInput {
    /// <p>The name of the service.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the service.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The ID of the environment in which the service is created.</p>
    pub environment_identifier: std::option::Option<std::string::String>,
    /// <p>The ID of the application which the service is created.</p>
    pub application_identifier: std::option::Option<std::string::String>,
    /// <p>The ID of the VPC.</p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>The type of endpoint to use for the service. The type can be a URL in a VPC or an Lambda function.</p>
    pub endpoint_type: std::option::Option<crate::model::ServiceEndpointType>,
    /// <p>The configuration for the URL endpoint type.</p>
    pub url_endpoint: std::option::Option<crate::model::UrlEndpointInput>,
    /// <p>The configuration for the Lambda endpoint type.</p>
    pub lambda_endpoint: std::option::Option<crate::model::LambdaEndpointInput>,
    /// <p>The tags to assign to the service. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair.. </p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl CreateServiceInput {
    /// <p>The name of the service.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of the service.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The ID of the environment in which the service is created.</p>
    pub fn environment_identifier(&self) -> std::option::Option<&str> {
        self.environment_identifier.as_deref()
    }
    /// <p>The ID of the application which the service is created.</p>
    pub fn application_identifier(&self) -> std::option::Option<&str> {
        self.application_identifier.as_deref()
    }
    /// <p>The ID of the VPC.</p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
    /// <p>The type of endpoint to use for the service. The type can be a URL in a VPC or an Lambda function.</p>
    pub fn endpoint_type(&self) -> std::option::Option<&crate::model::ServiceEndpointType> {
        self.endpoint_type.as_ref()
    }
    /// <p>The configuration for the URL endpoint type.</p>
    pub fn url_endpoint(&self) -> std::option::Option<&crate::model::UrlEndpointInput> {
        self.url_endpoint.as_ref()
    }
    /// <p>The configuration for the Lambda endpoint type.</p>
    pub fn lambda_endpoint(&self) -> std::option::Option<&crate::model::LambdaEndpointInput> {
        self.lambda_endpoint.as_ref()
    }
    /// <p>The tags to assign to the service. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair.. </p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for CreateServiceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateServiceInput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("environment_identifier", &self.environment_identifier);
        formatter.field("application_identifier", &self.application_identifier);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("endpoint_type", &self.endpoint_type);
        formatter.field("url_endpoint", &self.url_endpoint);
        formatter.field("lambda_endpoint", &self.lambda_endpoint);
        formatter.field("tags", &"*** Sensitive Data Redacted ***");
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRouteInput {
    /// <p>The ID of the environment in which the route is created.</p>
    pub environment_identifier: std::option::Option<std::string::String>,
    /// <p>The ID of the application within which the route is being created.</p>
    pub application_identifier: std::option::Option<std::string::String>,
    /// <p>The ID of the service in which the route is created. Traffic that matches this route is forwarded to this service.</p>
    pub service_identifier: std::option::Option<std::string::String>,
    /// <p>The route type of the route. <code>DEFAULT</code> indicates that all traffic that does not match another route is forwarded to the default route. Applications must have a default route before any other routes can be created. <code>URI_PATH</code> indicates a route that is based on a URI path.</p>
    pub route_type: std::option::Option<crate::model::RouteType>,
    /// <p>The configuration for the URI path route type. </p>
    pub uri_path_route: std::option::Option<crate::model::UriPathRouteInput>,
    /// <p>The tags to assign to the route. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair.. </p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl CreateRouteInput {
    /// <p>The ID of the environment in which the route is created.</p>
    pub fn environment_identifier(&self) -> std::option::Option<&str> {
        self.environment_identifier.as_deref()
    }
    /// <p>The ID of the application within which the route is being created.</p>
    pub fn application_identifier(&self) -> std::option::Option<&str> {
        self.application_identifier.as_deref()
    }
    /// <p>The ID of the service in which the route is created. Traffic that matches this route is forwarded to this service.</p>
    pub fn service_identifier(&self) -> std::option::Option<&str> {
        self.service_identifier.as_deref()
    }
    /// <p>The route type of the route. <code>DEFAULT</code> indicates that all traffic that does not match another route is forwarded to the default route. Applications must have a default route before any other routes can be created. <code>URI_PATH</code> indicates a route that is based on a URI path.</p>
    pub fn route_type(&self) -> std::option::Option<&crate::model::RouteType> {
        self.route_type.as_ref()
    }
    /// <p>The configuration for the URI path route type. </p>
    pub fn uri_path_route(&self) -> std::option::Option<&crate::model::UriPathRouteInput> {
        self.uri_path_route.as_ref()
    }
    /// <p>The tags to assign to the route. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair.. </p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for CreateRouteInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRouteInput");
        formatter.field("environment_identifier", &self.environment_identifier);
        formatter.field("application_identifier", &self.application_identifier);
        formatter.field("service_identifier", &self.service_identifier);
        formatter.field("route_type", &self.route_type);
        formatter.field("uri_path_route", &self.uri_path_route);
        formatter.field("tags", &"*** Sensitive Data Redacted ***");
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateEnvironmentInput {
    /// <p>The name of the environment.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the environment.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The network fabric type of the environment.</p>
    pub network_fabric_type: std::option::Option<crate::model::NetworkFabricType>,
    /// <p>The tags to assign to the environment. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl CreateEnvironmentInput {
    /// <p>The name of the environment.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of the environment.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The network fabric type of the environment.</p>
    pub fn network_fabric_type(&self) -> std::option::Option<&crate::model::NetworkFabricType> {
        self.network_fabric_type.as_ref()
    }
    /// <p>The tags to assign to the environment. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for CreateEnvironmentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateEnvironmentInput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("network_fabric_type", &self.network_fabric_type);
        formatter.field("tags", &"*** Sensitive Data Redacted ***");
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateApplicationInput {
    /// <p>The name to use for the application. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the environment.</p>
    pub environment_identifier: std::option::Option<std::string::String>,
    /// <p>The ID of the virtual private cloud (VPC).</p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>The proxy type of the proxy created within the application. </p>
    pub proxy_type: std::option::Option<crate::model::ProxyType>,
    /// <p>A wrapper object holding the API Gateway endpoint type and stage name for the proxy. </p>
    pub api_gateway_proxy: std::option::Option<crate::model::ApiGatewayProxyInput>,
    /// <p>The tags to assign to the application. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl CreateApplicationInput {
    /// <p>The name to use for the application. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The unique identifier of the environment.</p>
    pub fn environment_identifier(&self) -> std::option::Option<&str> {
        self.environment_identifier.as_deref()
    }
    /// <p>The ID of the virtual private cloud (VPC).</p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
    /// <p>The proxy type of the proxy created within the application. </p>
    pub fn proxy_type(&self) -> std::option::Option<&crate::model::ProxyType> {
        self.proxy_type.as_ref()
    }
    /// <p>A wrapper object holding the API Gateway endpoint type and stage name for the proxy. </p>
    pub fn api_gateway_proxy(&self) -> std::option::Option<&crate::model::ApiGatewayProxyInput> {
        self.api_gateway_proxy.as_ref()
    }
    /// <p>The tags to assign to the application. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for CreateApplicationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateApplicationInput");
        formatter.field("name", &self.name);
        formatter.field("environment_identifier", &self.environment_identifier);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("proxy_type", &self.proxy_type);
        formatter.field("api_gateway_proxy", &self.api_gateway_proxy);
        formatter.field("tags", &"*** Sensitive Data Redacted ***");
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}
