// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CreateApplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateApplicationError {
    /// Kind of error that occurred.
    pub kind: CreateApplicationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateApplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateApplicationErrorKind {
    /// <p>The user does not have sufficient access to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Updating or deleting a resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request references a resource that does not exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request would cause a service quota to be exceeded. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Request was denied because the request was throttled. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input does not satisfy the constraints specified by an Amazon Web Service. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateApplicationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateApplicationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateApplicationErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateApplicationErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateApplicationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateApplicationErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateApplicationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateApplicationErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateApplicationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateApplicationError {
    fn code(&self) -> Option<&str> {
        CreateApplicationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateApplicationError {
    /// Creates a new `CreateApplicationError`.
    pub fn new(kind: CreateApplicationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateApplicationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateApplicationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateApplicationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateApplicationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateApplicationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateApplicationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateApplicationErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateApplicationErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateApplicationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateApplicationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateApplicationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateApplicationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateApplicationErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateApplicationErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateApplicationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateApplicationErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateApplicationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateApplicationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateApplicationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateApplicationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateApplicationErrorKind::ConflictException(_inner) => Some(_inner),
            CreateApplicationErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateApplicationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateApplicationErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateApplicationErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateApplicationErrorKind::ValidationException(_inner) => Some(_inner),
            CreateApplicationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateEnvironment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateEnvironmentError {
    /// Kind of error that occurred.
    pub kind: CreateEnvironmentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateEnvironment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateEnvironmentErrorKind {
    /// <p>The user does not have sufficient access to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Updating or deleting a resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request references a resource that does not exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request would cause a service quota to be exceeded. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Request was denied because the request was throttled. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input does not satisfy the constraints specified by an Amazon Web Service. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateEnvironmentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateEnvironmentErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateEnvironmentErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateEnvironmentErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateEnvironmentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateEnvironmentErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateEnvironmentErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateEnvironmentErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateEnvironmentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateEnvironmentError {
    fn code(&self) -> Option<&str> {
        CreateEnvironmentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateEnvironmentError {
    /// Creates a new `CreateEnvironmentError`.
    pub fn new(kind: CreateEnvironmentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateEnvironmentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateEnvironmentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateEnvironmentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateEnvironmentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateEnvironmentErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEnvironmentErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEnvironmentErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateEnvironmentErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateEnvironmentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEnvironmentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEnvironmentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEnvironmentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEnvironmentErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEnvironmentErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEnvironmentErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEnvironmentErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEnvironmentErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEnvironmentErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateEnvironmentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateEnvironmentErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateEnvironmentErrorKind::ConflictException(_inner) => Some(_inner),
            CreateEnvironmentErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateEnvironmentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateEnvironmentErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateEnvironmentErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateEnvironmentErrorKind::ValidationException(_inner) => Some(_inner),
            CreateEnvironmentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateRoute` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateRouteError {
    /// Kind of error that occurred.
    pub kind: CreateRouteErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateRoute` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateRouteErrorKind {
    /// <p>The user does not have sufficient access to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Updating or deleting a resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request references a resource that does not exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request would cause a service quota to be exceeded. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Request was denied because the request was throttled. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input does not satisfy the constraints specified by an Amazon Web Service. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateRouteError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateRouteErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateRouteErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateRouteErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateRouteErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateRouteErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateRouteErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateRouteErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateRouteErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateRouteError {
    fn code(&self) -> Option<&str> {
        CreateRouteError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateRouteError {
    /// Creates a new `CreateRouteError`.
    pub fn new(kind: CreateRouteErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateRouteError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateRouteErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateRouteError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateRouteErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateRouteErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateRouteErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `CreateRouteErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateRouteErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateRouteErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, CreateRouteErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `CreateRouteErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRouteErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRouteErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRouteErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRouteErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateRouteErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `CreateRouteErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateRouteErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateRouteError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateRouteErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateRouteErrorKind::ConflictException(_inner) => Some(_inner),
            CreateRouteErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateRouteErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateRouteErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateRouteErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateRouteErrorKind::ValidationException(_inner) => Some(_inner),
            CreateRouteErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateService` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateServiceError {
    /// Kind of error that occurred.
    pub kind: CreateServiceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateService` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateServiceErrorKind {
    /// <p>The user does not have sufficient access to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Updating or deleting a resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request references a resource that does not exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request would cause a service quota to be exceeded. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Request was denied because the request was throttled. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input does not satisfy the constraints specified by an Amazon Web Service. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateServiceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateServiceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateServiceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateServiceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateServiceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateServiceErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateServiceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateServiceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateServiceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateServiceError {
    fn code(&self) -> Option<&str> {
        CreateServiceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateServiceError {
    /// Creates a new `CreateServiceError`.
    pub fn new(kind: CreateServiceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateServiceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateServiceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateServiceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateServiceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateServiceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateServiceErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `CreateServiceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateServiceErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateServiceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateServiceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateServiceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateServiceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateServiceErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateServiceErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateServiceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateServiceErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `CreateServiceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateServiceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateServiceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateServiceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateServiceErrorKind::ConflictException(_inner) => Some(_inner),
            CreateServiceErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateServiceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateServiceErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateServiceErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateServiceErrorKind::ValidationException(_inner) => Some(_inner),
            CreateServiceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteApplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteApplicationError {
    /// Kind of error that occurred.
    pub kind: DeleteApplicationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteApplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteApplicationErrorKind {
    /// <p>The user does not have sufficient access to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Updating or deleting a resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request references a resource that does not exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Request was denied because the request was throttled. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input does not satisfy the constraints specified by an Amazon Web Service. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteApplicationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteApplicationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteApplicationErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteApplicationErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteApplicationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteApplicationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteApplicationErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteApplicationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteApplicationError {
    fn code(&self) -> Option<&str> {
        DeleteApplicationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteApplicationError {
    /// Creates a new `DeleteApplicationError`.
    pub fn new(kind: DeleteApplicationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteApplicationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteApplicationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteApplicationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteApplicationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteApplicationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApplicationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteApplicationErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteApplicationErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteApplicationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApplicationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteApplicationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApplicationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteApplicationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApplicationErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteApplicationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApplicationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteApplicationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteApplicationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteApplicationErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteApplicationErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteApplicationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteApplicationErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteApplicationErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteApplicationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteEnvironment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteEnvironmentError {
    /// Kind of error that occurred.
    pub kind: DeleteEnvironmentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteEnvironment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteEnvironmentErrorKind {
    /// <p>The user does not have sufficient access to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Updating or deleting a resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request references a resource that does not exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Request was denied because the request was throttled. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input does not satisfy the constraints specified by an Amazon Web Service. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteEnvironmentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteEnvironmentErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteEnvironmentErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteEnvironmentErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteEnvironmentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteEnvironmentErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteEnvironmentErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteEnvironmentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteEnvironmentError {
    fn code(&self) -> Option<&str> {
        DeleteEnvironmentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteEnvironmentError {
    /// Creates a new `DeleteEnvironmentError`.
    pub fn new(kind: DeleteEnvironmentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteEnvironmentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteEnvironmentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteEnvironmentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteEnvironmentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteEnvironmentErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEnvironmentErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEnvironmentErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteEnvironmentErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteEnvironmentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEnvironmentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEnvironmentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEnvironmentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEnvironmentErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEnvironmentErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEnvironmentErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEnvironmentErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteEnvironmentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteEnvironmentErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteEnvironmentErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteEnvironmentErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteEnvironmentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteEnvironmentErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteEnvironmentErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteEnvironmentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteResourcePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteResourcePolicyError {
    /// Kind of error that occurred.
    pub kind: DeleteResourcePolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteResourcePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteResourcePolicyErrorKind {
    /// <p>The user does not have sufficient access to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request references a resource that does not exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Request was denied because the request was throttled. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input does not satisfy the constraints specified by an Amazon Web Service. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteResourcePolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteResourcePolicyErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteResourcePolicyErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteResourcePolicyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteResourcePolicyErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteResourcePolicyErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteResourcePolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteResourcePolicyError {
    fn code(&self) -> Option<&str> {
        DeleteResourcePolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteResourcePolicyError {
    /// Creates a new `DeleteResourcePolicyError`.
    pub fn new(kind: DeleteResourcePolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteResourcePolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteResourcePolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteResourcePolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteResourcePolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteResourcePolicyErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourcePolicyErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourcePolicyErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourcePolicyErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourcePolicyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourcePolicyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourcePolicyErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourcePolicyErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourcePolicyErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourcePolicyErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteResourcePolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteResourcePolicyErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteResourcePolicyErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteResourcePolicyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteResourcePolicyErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteResourcePolicyErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteResourcePolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteRoute` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteRouteError {
    /// Kind of error that occurred.
    pub kind: DeleteRouteErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteRoute` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteRouteErrorKind {
    /// <p>The user does not have sufficient access to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Updating or deleting a resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request references a resource that does not exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Request was denied because the request was throttled. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input does not satisfy the constraints specified by an Amazon Web Service. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteRouteError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteRouteErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteRouteErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteRouteErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteRouteErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteRouteErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteRouteErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteRouteErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteRouteError {
    fn code(&self) -> Option<&str> {
        DeleteRouteError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteRouteError {
    /// Creates a new `DeleteRouteError`.
    pub fn new(kind: DeleteRouteErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteRouteError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteRouteErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteRouteError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteRouteErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteRouteErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteRouteErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DeleteRouteErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteRouteErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteRouteErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, DeleteRouteErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `DeleteRouteErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRouteErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRouteErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteRouteErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DeleteRouteErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteRouteErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteRouteError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteRouteErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteRouteErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteRouteErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteRouteErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteRouteErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteRouteErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteRouteErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteService` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteServiceError {
    /// Kind of error that occurred.
    pub kind: DeleteServiceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteService` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteServiceErrorKind {
    /// <p>The user does not have sufficient access to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Updating or deleting a resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request references a resource that does not exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Request was denied because the request was throttled. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input does not satisfy the constraints specified by an Amazon Web Service. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteServiceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteServiceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteServiceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteServiceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteServiceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteServiceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteServiceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteServiceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteServiceError {
    fn code(&self) -> Option<&str> {
        DeleteServiceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteServiceError {
    /// Creates a new `DeleteServiceError`.
    pub fn new(kind: DeleteServiceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteServiceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteServiceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteServiceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteServiceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteServiceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteServiceErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DeleteServiceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteServiceErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteServiceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteServiceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteServiceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteServiceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteServiceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteServiceErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DeleteServiceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteServiceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteServiceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteServiceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteServiceErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteServiceErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteServiceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteServiceErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteServiceErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteServiceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetApplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetApplicationError {
    /// Kind of error that occurred.
    pub kind: GetApplicationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetApplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetApplicationErrorKind {
    /// <p>The user does not have sufficient access to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request references a resource that does not exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Request was denied because the request was throttled. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input does not satisfy the constraints specified by an Amazon Web Service. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetApplicationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetApplicationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetApplicationErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetApplicationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetApplicationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetApplicationErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetApplicationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetApplicationError {
    fn code(&self) -> Option<&str> {
        GetApplicationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetApplicationError {
    /// Creates a new `GetApplicationError`.
    pub fn new(kind: GetApplicationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetApplicationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetApplicationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetApplicationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetApplicationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetApplicationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApplicationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetApplicationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApplicationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetApplicationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApplicationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetApplicationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetApplicationErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `GetApplicationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetApplicationErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetApplicationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetApplicationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetApplicationErrorKind::InternalServerException(_inner) => Some(_inner),
            GetApplicationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetApplicationErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetApplicationErrorKind::ValidationException(_inner) => Some(_inner),
            GetApplicationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetEnvironment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetEnvironmentError {
    /// Kind of error that occurred.
    pub kind: GetEnvironmentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetEnvironment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetEnvironmentErrorKind {
    /// <p>The user does not have sufficient access to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request references a resource that does not exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Request was denied because the request was throttled. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input does not satisfy the constraints specified by an Amazon Web Service. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetEnvironmentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetEnvironmentErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetEnvironmentErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetEnvironmentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetEnvironmentErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetEnvironmentErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetEnvironmentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetEnvironmentError {
    fn code(&self) -> Option<&str> {
        GetEnvironmentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetEnvironmentError {
    /// Creates a new `GetEnvironmentError`.
    pub fn new(kind: GetEnvironmentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetEnvironmentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetEnvironmentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetEnvironmentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetEnvironmentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetEnvironmentErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEnvironmentErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEnvironmentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEnvironmentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEnvironmentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEnvironmentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEnvironmentErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetEnvironmentErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `GetEnvironmentErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetEnvironmentErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetEnvironmentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetEnvironmentErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetEnvironmentErrorKind::InternalServerException(_inner) => Some(_inner),
            GetEnvironmentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetEnvironmentErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetEnvironmentErrorKind::ValidationException(_inner) => Some(_inner),
            GetEnvironmentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetResourcePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetResourcePolicyError {
    /// Kind of error that occurred.
    pub kind: GetResourcePolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetResourcePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetResourcePolicyErrorKind {
    /// <p>The user does not have sufficient access to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request references a resource that does not exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Request was denied because the request was throttled. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input does not satisfy the constraints specified by an Amazon Web Service. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetResourcePolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetResourcePolicyErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetResourcePolicyErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetResourcePolicyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetResourcePolicyErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetResourcePolicyErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetResourcePolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetResourcePolicyError {
    fn code(&self) -> Option<&str> {
        GetResourcePolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetResourcePolicyError {
    /// Creates a new `GetResourcePolicyError`.
    pub fn new(kind: GetResourcePolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetResourcePolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetResourcePolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetResourcePolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetResourcePolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetResourcePolicyErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourcePolicyErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourcePolicyErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourcePolicyErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourcePolicyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourcePolicyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourcePolicyErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourcePolicyErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourcePolicyErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourcePolicyErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetResourcePolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetResourcePolicyErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetResourcePolicyErrorKind::InternalServerException(_inner) => Some(_inner),
            GetResourcePolicyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetResourcePolicyErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetResourcePolicyErrorKind::ValidationException(_inner) => Some(_inner),
            GetResourcePolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRoute` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRouteError {
    /// Kind of error that occurred.
    pub kind: GetRouteErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRoute` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRouteErrorKind {
    /// <p>The user does not have sufficient access to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request references a resource that does not exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Request was denied because the request was throttled. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input does not satisfy the constraints specified by an Amazon Web Service. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRouteError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRouteErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetRouteErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetRouteErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetRouteErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetRouteErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetRouteErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRouteError {
    fn code(&self) -> Option<&str> {
        GetRouteError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRouteError {
    /// Creates a new `GetRouteError`.
    pub fn new(kind: GetRouteErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRouteError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRouteErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRouteError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRouteErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetRouteErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetRouteErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetRouteErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, GetRouteErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `GetRouteErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetRouteErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetRouteErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetRouteErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `GetRouteErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetRouteErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetRouteError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRouteErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetRouteErrorKind::InternalServerException(_inner) => Some(_inner),
            GetRouteErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetRouteErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetRouteErrorKind::ValidationException(_inner) => Some(_inner),
            GetRouteErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetService` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetServiceError {
    /// Kind of error that occurred.
    pub kind: GetServiceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetService` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetServiceErrorKind {
    /// <p>The user does not have sufficient access to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request references a resource that does not exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Request was denied because the request was throttled. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input does not satisfy the constraints specified by an Amazon Web Service. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetServiceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetServiceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetServiceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetServiceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetServiceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetServiceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetServiceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetServiceError {
    fn code(&self) -> Option<&str> {
        GetServiceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetServiceError {
    /// Creates a new `GetServiceError`.
    pub fn new(kind: GetServiceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetServiceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetServiceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetServiceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetServiceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetServiceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetServiceErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetServiceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, GetServiceErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `GetServiceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServiceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetServiceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetServiceErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `GetServiceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetServiceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetServiceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetServiceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetServiceErrorKind::InternalServerException(_inner) => Some(_inner),
            GetServiceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetServiceErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetServiceErrorKind::ValidationException(_inner) => Some(_inner),
            GetServiceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListApplications` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListApplicationsError {
    /// Kind of error that occurred.
    pub kind: ListApplicationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListApplications` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListApplicationsErrorKind {
    /// <p>The user does not have sufficient access to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Updating or deleting a resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request references a resource that does not exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request would cause a service quota to be exceeded. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Request was denied because the request was throttled. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input does not satisfy the constraints specified by an Amazon Web Service. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListApplicationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListApplicationsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListApplicationsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            ListApplicationsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListApplicationsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListApplicationsErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            ListApplicationsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListApplicationsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListApplicationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListApplicationsError {
    fn code(&self) -> Option<&str> {
        ListApplicationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListApplicationsError {
    /// Creates a new `ListApplicationsError`.
    pub fn new(kind: ListApplicationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListApplicationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListApplicationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListApplicationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListApplicationsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListApplicationsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListApplicationsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListApplicationsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, ListApplicationsErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `ListApplicationsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListApplicationsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListApplicationsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListApplicationsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListApplicationsErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListApplicationsErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ListApplicationsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListApplicationsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListApplicationsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListApplicationsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListApplicationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListApplicationsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListApplicationsErrorKind::ConflictException(_inner) => Some(_inner),
            ListApplicationsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListApplicationsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListApplicationsErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            ListApplicationsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListApplicationsErrorKind::ValidationException(_inner) => Some(_inner),
            ListApplicationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListEnvironments` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListEnvironmentsError {
    /// Kind of error that occurred.
    pub kind: ListEnvironmentsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListEnvironments` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListEnvironmentsErrorKind {
    /// <p>The user does not have sufficient access to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request references a resource that does not exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Request was denied because the request was throttled. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input does not satisfy the constraints specified by an Amazon Web Service. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListEnvironmentsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListEnvironmentsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListEnvironmentsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListEnvironmentsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListEnvironmentsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListEnvironmentsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListEnvironmentsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListEnvironmentsError {
    fn code(&self) -> Option<&str> {
        ListEnvironmentsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListEnvironmentsError {
    /// Creates a new `ListEnvironmentsError`.
    pub fn new(kind: ListEnvironmentsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListEnvironmentsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListEnvironmentsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListEnvironmentsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListEnvironmentsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListEnvironmentsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEnvironmentsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEnvironmentsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEnvironmentsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEnvironmentsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEnvironmentsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEnvironmentsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEnvironmentsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEnvironmentsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEnvironmentsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListEnvironmentsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListEnvironmentsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListEnvironmentsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListEnvironmentsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListEnvironmentsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListEnvironmentsErrorKind::ValidationException(_inner) => Some(_inner),
            ListEnvironmentsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListEnvironmentVpcs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListEnvironmentVpcsError {
    /// Kind of error that occurred.
    pub kind: ListEnvironmentVpcsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListEnvironmentVpcs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListEnvironmentVpcsErrorKind {
    /// <p>The user does not have sufficient access to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request references a resource that does not exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Request was denied because the request was throttled. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input does not satisfy the constraints specified by an Amazon Web Service. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListEnvironmentVpcsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListEnvironmentVpcsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListEnvironmentVpcsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListEnvironmentVpcsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListEnvironmentVpcsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListEnvironmentVpcsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListEnvironmentVpcsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListEnvironmentVpcsError {
    fn code(&self) -> Option<&str> {
        ListEnvironmentVpcsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListEnvironmentVpcsError {
    /// Creates a new `ListEnvironmentVpcsError`.
    pub fn new(kind: ListEnvironmentVpcsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListEnvironmentVpcsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListEnvironmentVpcsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListEnvironmentVpcsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListEnvironmentVpcsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListEnvironmentVpcsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEnvironmentVpcsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEnvironmentVpcsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEnvironmentVpcsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEnvironmentVpcsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEnvironmentVpcsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEnvironmentVpcsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEnvironmentVpcsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEnvironmentVpcsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEnvironmentVpcsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListEnvironmentVpcsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListEnvironmentVpcsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListEnvironmentVpcsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListEnvironmentVpcsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListEnvironmentVpcsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListEnvironmentVpcsErrorKind::ValidationException(_inner) => Some(_inner),
            ListEnvironmentVpcsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListRoutes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListRoutesError {
    /// Kind of error that occurred.
    pub kind: ListRoutesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListRoutes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListRoutesErrorKind {
    /// <p>The user does not have sufficient access to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Updating or deleting a resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request references a resource that does not exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request would cause a service quota to be exceeded. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Request was denied because the request was throttled. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input does not satisfy the constraints specified by an Amazon Web Service. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListRoutesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListRoutesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListRoutesErrorKind::ConflictException(_inner) => _inner.fmt(f),
            ListRoutesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListRoutesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListRoutesErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            ListRoutesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListRoutesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListRoutesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListRoutesError {
    fn code(&self) -> Option<&str> {
        ListRoutesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListRoutesError {
    /// Creates a new `ListRoutesError`.
    pub fn new(kind: ListRoutesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListRoutesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListRoutesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListRoutesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListRoutesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListRoutesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListRoutesErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `ListRoutesErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, ListRoutesErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `ListRoutesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, ListRoutesErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `ListRoutesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRoutesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRoutesErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRoutesErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRoutesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListRoutesErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListRoutesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListRoutesErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListRoutesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListRoutesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListRoutesErrorKind::ConflictException(_inner) => Some(_inner),
            ListRoutesErrorKind::InternalServerException(_inner) => Some(_inner),
            ListRoutesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListRoutesErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            ListRoutesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListRoutesErrorKind::ValidationException(_inner) => Some(_inner),
            ListRoutesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListServices` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListServicesError {
    /// Kind of error that occurred.
    pub kind: ListServicesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListServices` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListServicesErrorKind {
    /// <p>The user does not have sufficient access to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Updating or deleting a resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request references a resource that does not exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request would cause a service quota to be exceeded. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Request was denied because the request was throttled. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input does not satisfy the constraints specified by an Amazon Web Service. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListServicesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListServicesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListServicesErrorKind::ConflictException(_inner) => _inner.fmt(f),
            ListServicesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListServicesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListServicesErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            ListServicesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListServicesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListServicesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListServicesError {
    fn code(&self) -> Option<&str> {
        ListServicesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListServicesError {
    /// Creates a new `ListServicesError`.
    pub fn new(kind: ListServicesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListServicesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListServicesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListServicesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListServicesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListServicesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListServicesErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `ListServicesErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, ListServicesErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `ListServicesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServicesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListServicesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServicesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListServicesErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServicesErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ListServicesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListServicesErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListServicesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListServicesErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListServicesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListServicesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListServicesErrorKind::ConflictException(_inner) => Some(_inner),
            ListServicesErrorKind::InternalServerException(_inner) => Some(_inner),
            ListServicesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListServicesErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            ListServicesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListServicesErrorKind::ValidationException(_inner) => Some(_inner),
            ListServicesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>An unexpected error occurred while processing the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request references a resource that does not exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The input does not satisfy the constraints specified by an Amazon Web Service. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ValidationException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutResourcePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutResourcePolicyError {
    /// Kind of error that occurred.
    pub kind: PutResourcePolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutResourcePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutResourcePolicyErrorKind {
    /// <p>The user does not have sufficient access to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource policy is not valid.</p>
    InvalidResourcePolicyException(crate::error::InvalidResourcePolicyException),
    /// <p>The request references a resource that does not exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Request was denied because the request was throttled. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input does not satisfy the constraints specified by an Amazon Web Service. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutResourcePolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutResourcePolicyErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            PutResourcePolicyErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            PutResourcePolicyErrorKind::InvalidResourcePolicyException(_inner) => _inner.fmt(f),
            PutResourcePolicyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            PutResourcePolicyErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            PutResourcePolicyErrorKind::ValidationException(_inner) => _inner.fmt(f),
            PutResourcePolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutResourcePolicyError {
    fn code(&self) -> Option<&str> {
        PutResourcePolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutResourcePolicyError {
    /// Creates a new `PutResourcePolicyError`.
    pub fn new(kind: PutResourcePolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutResourcePolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutResourcePolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutResourcePolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutResourcePolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutResourcePolicyErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutResourcePolicyErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `PutResourcePolicyErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutResourcePolicyErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `PutResourcePolicyErrorKind::InvalidResourcePolicyException`.
    pub fn is_invalid_resource_policy_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutResourcePolicyErrorKind::InvalidResourcePolicyException(_)
        )
    }
    /// Returns `true` if the error kind is `PutResourcePolicyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutResourcePolicyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutResourcePolicyErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutResourcePolicyErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `PutResourcePolicyErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutResourcePolicyErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for PutResourcePolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutResourcePolicyErrorKind::AccessDeniedException(_inner) => Some(_inner),
            PutResourcePolicyErrorKind::InternalServerException(_inner) => Some(_inner),
            PutResourcePolicyErrorKind::InvalidResourcePolicyException(_inner) => Some(_inner),
            PutResourcePolicyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            PutResourcePolicyErrorKind::ThrottlingException(_inner) => Some(_inner),
            PutResourcePolicyErrorKind::ValidationException(_inner) => Some(_inner),
            PutResourcePolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>An unexpected error occurred while processing the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request references a resource that does not exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The input does not satisfy the constraints specified by an Amazon Web Service. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>An unexpected error occurred while processing the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request references a resource that does not exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The input does not satisfy the constraints specified by an Amazon Web Service. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The input does not satisfy the constraints specified by an Amazon Web Service. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ValidationException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ValidationException {}
/// See [`ValidationException`](crate::error::ValidationException)
pub mod validation_exception {
    /// A builder for [`ValidationException`](crate::error::ValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationException`](crate::error::ValidationException)
        pub fn build(self) -> crate::error::ValidationException {
            crate::error::ValidationException {
                message: self.message,
            }
        }
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::error::ValidationException)
    pub fn builder() -> crate::error::validation_exception::Builder {
        crate::error::validation_exception::Builder::default()
    }
}

/// <p>The request references a resource that does not exist. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The ID of the resource. </p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The type of resource. </p>
    pub resource_type: std::option::Option<std::string::String>,
}
impl ResourceNotFoundException {
    /// <p>The ID of the resource. </p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The type of resource. </p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The ID of the resource. </p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource. </p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The type of resource. </p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The type of resource. </p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>An unexpected error occurred while processing the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServerException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerException {}
/// See [`InternalServerException`](crate::error::InternalServerException)
pub mod internal_server_exception {
    /// A builder for [`InternalServerException`](crate::error::InternalServerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerException`](crate::error::InternalServerException)
        pub fn build(self) -> crate::error::InternalServerException {
            crate::error::InternalServerException {
                message: self.message,
            }
        }
    }
}
impl InternalServerException {
    /// Creates a new builder-style object to manufacture [`InternalServerException`](crate::error::InternalServerException)
    pub fn builder() -> crate::error::internal_server_exception::Builder {
        crate::error::internal_server_exception::Builder::default()
    }
}

/// <p>Request was denied because the request was throttled. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThrottlingException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>Service quota requirement to identify originating quota. Reached throttling quota exception. </p>
    pub quota_code: std::option::Option<std::string::String>,
    /// <p>Service quota requirement to identify originating service. Reached throttling quota exception service code. </p>
    pub service_code: std::option::Option<std::string::String>,
    /// <p>The number of seconds to wait before retrying. </p>
    pub retry_after_seconds: i32,
}
impl ThrottlingException {
    /// <p>Service quota requirement to identify originating quota. Reached throttling quota exception. </p>
    pub fn quota_code(&self) -> std::option::Option<&str> {
        self.quota_code.as_deref()
    }
    /// <p>Service quota requirement to identify originating service. Reached throttling quota exception service code. </p>
    pub fn service_code(&self) -> std::option::Option<&str> {
        self.service_code.as_deref()
    }
    /// <p>The number of seconds to wait before retrying. </p>
    pub fn retry_after_seconds(&self) -> i32 {
        self.retry_after_seconds
    }
}
impl std::fmt::Debug for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThrottlingException");
        formatter.field("message", &self.message);
        formatter.field("quota_code", &self.quota_code);
        formatter.field("service_code", &self.service_code);
        formatter.field("retry_after_seconds", &self.retry_after_seconds);
        formatter.finish()
    }
}
impl ThrottlingException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ThrottlingException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for ThrottlingException {}
/// See [`ThrottlingException`](crate::error::ThrottlingException)
pub mod throttling_exception {
    /// A builder for [`ThrottlingException`](crate::error::ThrottlingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) quota_code: std::option::Option<std::string::String>,
        pub(crate) service_code: std::option::Option<std::string::String>,
        pub(crate) retry_after_seconds: std::option::Option<i32>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>Service quota requirement to identify originating quota. Reached throttling quota exception. </p>
        pub fn quota_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.quota_code = Some(input.into());
            self
        }
        /// <p>Service quota requirement to identify originating quota. Reached throttling quota exception. </p>
        pub fn set_quota_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.quota_code = input;
            self
        }
        /// <p>Service quota requirement to identify originating service. Reached throttling quota exception service code. </p>
        pub fn service_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_code = Some(input.into());
            self
        }
        /// <p>Service quota requirement to identify originating service. Reached throttling quota exception service code. </p>
        pub fn set_service_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_code = input;
            self
        }
        /// <p>The number of seconds to wait before retrying. </p>
        pub fn retry_after_seconds(mut self, input: i32) -> Self {
            self.retry_after_seconds = Some(input);
            self
        }
        /// <p>The number of seconds to wait before retrying. </p>
        pub fn set_retry_after_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.retry_after_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`ThrottlingException`](crate::error::ThrottlingException)
        pub fn build(self) -> crate::error::ThrottlingException {
            crate::error::ThrottlingException {
                message: self.message,
                quota_code: self.quota_code,
                service_code: self.service_code,
                retry_after_seconds: self.retry_after_seconds.unwrap_or_default(),
            }
        }
    }
}
impl ThrottlingException {
    /// Creates a new builder-style object to manufacture [`ThrottlingException`](crate::error::ThrottlingException)
    pub fn builder() -> crate::error::throttling_exception::Builder {
        crate::error::throttling_exception::Builder::default()
    }
}

/// <p>The resource policy is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidResourcePolicyException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidResourcePolicyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidResourcePolicyException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidResourcePolicyException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidResourcePolicyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidResourcePolicyException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidResourcePolicyException {}
/// See [`InvalidResourcePolicyException`](crate::error::InvalidResourcePolicyException)
pub mod invalid_resource_policy_exception {
    /// A builder for [`InvalidResourcePolicyException`](crate::error::InvalidResourcePolicyException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidResourcePolicyException`](crate::error::InvalidResourcePolicyException)
        pub fn build(self) -> crate::error::InvalidResourcePolicyException {
            crate::error::InvalidResourcePolicyException {
                message: self.message,
            }
        }
    }
}
impl InvalidResourcePolicyException {
    /// Creates a new builder-style object to manufacture [`InvalidResourcePolicyException`](crate::error::InvalidResourcePolicyException)
    pub fn builder() -> crate::error::invalid_resource_policy_exception::Builder {
        crate::error::invalid_resource_policy_exception::Builder::default()
    }
}

/// <p>The user does not have sufficient access to perform this action. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}

/// <p>The request would cause a service quota to be exceeded. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceQuotaExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The ID of the resource. </p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The type of resource. </p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>Service quota requirement to identify originating quota. Reached throttling quota exception. </p>
    pub quota_code: std::option::Option<std::string::String>,
    /// <p>Service quota requirement to identify originating service. Reached throttling quota exception service code. </p>
    pub service_code: std::option::Option<std::string::String>,
}
impl ServiceQuotaExceededException {
    /// <p>The ID of the resource. </p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The type of resource. </p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>Service quota requirement to identify originating quota. Reached throttling quota exception. </p>
    pub fn quota_code(&self) -> std::option::Option<&str> {
        self.quota_code.as_deref()
    }
    /// <p>Service quota requirement to identify originating service. Reached throttling quota exception service code. </p>
    pub fn service_code(&self) -> std::option::Option<&str> {
        self.service_code.as_deref()
    }
}
impl std::fmt::Debug for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceQuotaExceededException");
        formatter.field("message", &self.message);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("quota_code", &self.quota_code);
        formatter.field("service_code", &self.service_code);
        formatter.finish()
    }
}
impl ServiceQuotaExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceQuotaExceededException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceQuotaExceededException {}
/// See [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
pub mod service_quota_exceeded_exception {
    /// A builder for [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) quota_code: std::option::Option<std::string::String>,
        pub(crate) service_code: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The ID of the resource. </p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource. </p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The type of resource. </p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The type of resource. </p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>Service quota requirement to identify originating quota. Reached throttling quota exception. </p>
        pub fn quota_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.quota_code = Some(input.into());
            self
        }
        /// <p>Service quota requirement to identify originating quota. Reached throttling quota exception. </p>
        pub fn set_quota_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.quota_code = input;
            self
        }
        /// <p>Service quota requirement to identify originating service. Reached throttling quota exception service code. </p>
        pub fn service_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_code = Some(input.into());
            self
        }
        /// <p>Service quota requirement to identify originating service. Reached throttling quota exception service code. </p>
        pub fn set_service_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_code = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
        pub fn build(self) -> crate::error::ServiceQuotaExceededException {
            crate::error::ServiceQuotaExceededException {
                message: self.message,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
                quota_code: self.quota_code,
                service_code: self.service_code,
            }
        }
    }
}
impl ServiceQuotaExceededException {
    /// Creates a new builder-style object to manufacture [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    pub fn builder() -> crate::error::service_quota_exceeded_exception::Builder {
        crate::error::service_quota_exceeded_exception::Builder::default()
    }
}

/// <p>Updating or deleting a resource can cause an inconsistent state.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The ID of the resource. </p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The type of resource. </p>
    pub resource_type: std::option::Option<std::string::String>,
}
impl ConflictException {
    /// <p>The ID of the resource. </p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The type of resource. </p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The ID of the resource. </p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource. </p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The type of resource. </p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The type of resource. </p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}
