// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for AWS Migration Hub Refactor Spaces
///
/// Client for invoking operations on AWS Migration Hub Refactor Spaces. Each operation on AWS Migration Hub Refactor Spaces is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_migrationhubrefactorspaces::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_migrationhubrefactorspaces::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_migrationhubrefactorspaces::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the [`CreateApplication`](crate::client::fluent_builders::CreateApplication) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateApplication::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateApplication::set_name): <p>The name to use for the application. </p>
    ///   - [`environment_identifier(impl Into<String>)`](crate::client::fluent_builders::CreateApplication::environment_identifier) / [`set_environment_identifier(Option<String>)`](crate::client::fluent_builders::CreateApplication::set_environment_identifier): <p>The unique identifier of the environment.</p>
    ///   - [`vpc_id(impl Into<String>)`](crate::client::fluent_builders::CreateApplication::vpc_id) / [`set_vpc_id(Option<String>)`](crate::client::fluent_builders::CreateApplication::set_vpc_id): <p>The ID of the virtual private cloud (VPC).</p>
    ///   - [`proxy_type(ProxyType)`](crate::client::fluent_builders::CreateApplication::proxy_type) / [`set_proxy_type(Option<ProxyType>)`](crate::client::fluent_builders::CreateApplication::set_proxy_type): <p>The proxy type of the proxy created within the application. </p>
    ///   - [`api_gateway_proxy(ApiGatewayProxyInput)`](crate::client::fluent_builders::CreateApplication::api_gateway_proxy) / [`set_api_gateway_proxy(Option<ApiGatewayProxyInput>)`](crate::client::fluent_builders::CreateApplication::set_api_gateway_proxy): <p>A wrapper object holding the API Gateway endpoint type and stage name for the proxy. </p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateApplication::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateApplication::set_tags): <p>The tags to assign to the application. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateApplication::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateApplication::set_client_token): <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    /// - On success, responds with [`CreateApplicationOutput`](crate::output::CreateApplicationOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::CreateApplicationOutput::name): <p>The name of the application.</p>
    ///   - [`arn(Option<String>)`](crate::output::CreateApplicationOutput::arn): <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is <code>arn:aws:refactor-spaces:<i>region</i>:<i>account-id</i>:<i>resource-type/resource-id</i> </code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
    ///   - [`owner_account_id(Option<String>)`](crate::output::CreateApplicationOutput::owner_account_id): <p>The Amazon Web Services account ID of the application owner.</p>
    ///   - [`created_by_account_id(Option<String>)`](crate::output::CreateApplicationOutput::created_by_account_id): <p>The Amazon Web Services account ID of application creator.</p>
    ///   - [`application_id(Option<String>)`](crate::output::CreateApplicationOutput::application_id): <p>The unique identifier of the application.</p>
    ///   - [`environment_id(Option<String>)`](crate::output::CreateApplicationOutput::environment_id): <p>The ID of the environment in which the application is created.</p>
    ///   - [`vpc_id(Option<String>)`](crate::output::CreateApplicationOutput::vpc_id): <p>The ID of the Amazon VPC. </p>
    ///   - [`proxy_type(Option<ProxyType>)`](crate::output::CreateApplicationOutput::proxy_type): <p>The proxy type of the proxy created within the application. </p>
    ///   - [`api_gateway_proxy(Option<ApiGatewayProxyInput>)`](crate::output::CreateApplicationOutput::api_gateway_proxy): <p>A wrapper object holding the API Gateway endpoint type and stage name for the proxy. </p>
    ///   - [`state(Option<ApplicationState>)`](crate::output::CreateApplicationOutput::state): <p>The current state of the application. </p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::CreateApplicationOutput::tags): <p>The tags assigned to the application. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair. </p>
    ///   - [`last_updated_time(Option<DateTime>)`](crate::output::CreateApplicationOutput::last_updated_time): <p>A timestamp that indicates when the application was last updated. </p>
    ///   - [`created_time(Option<DateTime>)`](crate::output::CreateApplicationOutput::created_time): <p>A timestamp that indicates when the application is created.</p>
    /// - On failure, responds with [`SdkError<CreateApplicationError>`](crate::error::CreateApplicationError)
    pub fn create_application(&self) -> fluent_builders::CreateApplication<C, M, R> {
        fluent_builders::CreateApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateEnvironment`](crate::client::fluent_builders::CreateEnvironment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateEnvironment::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateEnvironment::set_name): <p>The name of the environment.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateEnvironment::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateEnvironment::set_description): <p>The description of the environment.</p>
    ///   - [`network_fabric_type(NetworkFabricType)`](crate::client::fluent_builders::CreateEnvironment::network_fabric_type) / [`set_network_fabric_type(Option<NetworkFabricType>)`](crate::client::fluent_builders::CreateEnvironment::set_network_fabric_type): <p>The network fabric type of the environment.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateEnvironment::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateEnvironment::set_tags): <p>The tags to assign to the environment. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateEnvironment::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateEnvironment::set_client_token): <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    /// - On success, responds with [`CreateEnvironmentOutput`](crate::output::CreateEnvironmentOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::CreateEnvironmentOutput::name): <p>The name of the environment.</p>
    ///   - [`arn(Option<String>)`](crate::output::CreateEnvironmentOutput::arn): <p>The Amazon Resource Name (ARN) of the environment.</p>
    ///   - [`description(Option<String>)`](crate::output::CreateEnvironmentOutput::description): <p>A description of the environment.</p>
    ///   - [`environment_id(Option<String>)`](crate::output::CreateEnvironmentOutput::environment_id): <p>The unique identifier of the environment.</p>
    ///   - [`network_fabric_type(Option<NetworkFabricType>)`](crate::output::CreateEnvironmentOutput::network_fabric_type): <p>The network fabric type of the environment.</p>
    ///   - [`owner_account_id(Option<String>)`](crate::output::CreateEnvironmentOutput::owner_account_id): <p>The Amazon Web Services account ID of environment owner.</p>
    ///   - [`state(Option<EnvironmentState>)`](crate::output::CreateEnvironmentOutput::state): <p>The current state of the environment. </p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::CreateEnvironmentOutput::tags): <p>The tags assigned to the created environment. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair..</p>
    ///   - [`last_updated_time(Option<DateTime>)`](crate::output::CreateEnvironmentOutput::last_updated_time): <p>A timestamp that indicates when the environment was last updated. </p>
    ///   - [`created_time(Option<DateTime>)`](crate::output::CreateEnvironmentOutput::created_time): <p>A timestamp that indicates when the environment is created.</p>
    /// - On failure, responds with [`SdkError<CreateEnvironmentError>`](crate::error::CreateEnvironmentError)
    pub fn create_environment(&self) -> fluent_builders::CreateEnvironment<C, M, R> {
        fluent_builders::CreateEnvironment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateRoute`](crate::client::fluent_builders::CreateRoute) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`environment_identifier(impl Into<String>)`](crate::client::fluent_builders::CreateRoute::environment_identifier) / [`set_environment_identifier(Option<String>)`](crate::client::fluent_builders::CreateRoute::set_environment_identifier): <p>The ID of the environment in which the route is created.</p>
    ///   - [`application_identifier(impl Into<String>)`](crate::client::fluent_builders::CreateRoute::application_identifier) / [`set_application_identifier(Option<String>)`](crate::client::fluent_builders::CreateRoute::set_application_identifier): <p>The ID of the application within which the route is being created.</p>
    ///   - [`service_identifier(impl Into<String>)`](crate::client::fluent_builders::CreateRoute::service_identifier) / [`set_service_identifier(Option<String>)`](crate::client::fluent_builders::CreateRoute::set_service_identifier): <p>The ID of the service in which the route is created. Traffic that matches this route is forwarded to this service.</p>
    ///   - [`route_type(RouteType)`](crate::client::fluent_builders::CreateRoute::route_type) / [`set_route_type(Option<RouteType>)`](crate::client::fluent_builders::CreateRoute::set_route_type): <p>The route type of the route. <code>DEFAULT</code> indicates that all traffic that does not match another route is forwarded to the default route. Applications must have a default route before any other routes can be created. <code>URI_PATH</code> indicates a route that is based on a URI path.</p>
    ///   - [`uri_path_route(UriPathRouteInput)`](crate::client::fluent_builders::CreateRoute::uri_path_route) / [`set_uri_path_route(Option<UriPathRouteInput>)`](crate::client::fluent_builders::CreateRoute::set_uri_path_route): <p>The configuration for the URI path route type. </p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateRoute::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateRoute::set_tags): <p>The tags to assign to the route. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair.. </p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateRoute::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateRoute::set_client_token): <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    /// - On success, responds with [`CreateRouteOutput`](crate::output::CreateRouteOutput) with field(s):
    ///   - [`route_id(Option<String>)`](crate::output::CreateRouteOutput::route_id): <p>The unique identifier of the route.</p>
    ///   - [`arn(Option<String>)`](crate::output::CreateRouteOutput::arn): <p>The Amazon Resource Name (ARN) of the route. The format for this ARN is <code>arn:aws:refactor-spaces:<i>region</i>:<i>account-id</i>:<i>resource-type/resource-id</i> </code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
    ///   - [`owner_account_id(Option<String>)`](crate::output::CreateRouteOutput::owner_account_id): <p>The Amazon Web Services account ID of the route owner.</p>
    ///   - [`created_by_account_id(Option<String>)`](crate::output::CreateRouteOutput::created_by_account_id): <p>The Amazon Web Services account ID of the route creator.</p>
    ///   - [`route_type(Option<RouteType>)`](crate::output::CreateRouteOutput::route_type): <p>The route type of the route.</p>
    ///   - [`service_id(Option<String>)`](crate::output::CreateRouteOutput::service_id): <p>The ID of service in which the rute iscreated. Traffic that matches this route is forwarded to this service.</p>
    ///   - [`application_id(Option<String>)`](crate::output::CreateRouteOutput::application_id): <p>The ID of the application in which the route is created.</p>
    ///   - [`uri_path_route(Option<UriPathRouteInput>)`](crate::output::CreateRouteOutput::uri_path_route): <p>onfiguration for the URI path route type. </p>
    ///   - [`state(Option<RouteState>)`](crate::output::CreateRouteOutput::state): <p>he current state of the route. </p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::CreateRouteOutput::tags): <p>The tags assigned to the created route. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair. </p>
    ///   - [`last_updated_time(Option<DateTime>)`](crate::output::CreateRouteOutput::last_updated_time): <p>A timestamp that indicates when the route was last updated. </p>
    ///   - [`created_time(Option<DateTime>)`](crate::output::CreateRouteOutput::created_time): <p>A timestamp that indicates when the route is created.</p>
    /// - On failure, responds with [`SdkError<CreateRouteError>`](crate::error::CreateRouteError)
    pub fn create_route(&self) -> fluent_builders::CreateRoute<C, M, R> {
        fluent_builders::CreateRoute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateService`](crate::client::fluent_builders::CreateService) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateService::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateService::set_name): <p>The name of the service.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateService::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateService::set_description): <p>The description of the service.</p>
    ///   - [`environment_identifier(impl Into<String>)`](crate::client::fluent_builders::CreateService::environment_identifier) / [`set_environment_identifier(Option<String>)`](crate::client::fluent_builders::CreateService::set_environment_identifier): <p>The ID of the environment in which the service is created.</p>
    ///   - [`application_identifier(impl Into<String>)`](crate::client::fluent_builders::CreateService::application_identifier) / [`set_application_identifier(Option<String>)`](crate::client::fluent_builders::CreateService::set_application_identifier): <p>The ID of the application which the service is created.</p>
    ///   - [`vpc_id(impl Into<String>)`](crate::client::fluent_builders::CreateService::vpc_id) / [`set_vpc_id(Option<String>)`](crate::client::fluent_builders::CreateService::set_vpc_id): <p>The ID of the VPC.</p>
    ///   - [`endpoint_type(ServiceEndpointType)`](crate::client::fluent_builders::CreateService::endpoint_type) / [`set_endpoint_type(Option<ServiceEndpointType>)`](crate::client::fluent_builders::CreateService::set_endpoint_type): <p>The type of endpoint to use for the service. The type can be a URL in a VPC or an Lambda function.</p>
    ///   - [`url_endpoint(UrlEndpointInput)`](crate::client::fluent_builders::CreateService::url_endpoint) / [`set_url_endpoint(Option<UrlEndpointInput>)`](crate::client::fluent_builders::CreateService::set_url_endpoint): <p>The configuration for the URL endpoint type.</p>
    ///   - [`lambda_endpoint(LambdaEndpointInput)`](crate::client::fluent_builders::CreateService::lambda_endpoint) / [`set_lambda_endpoint(Option<LambdaEndpointInput>)`](crate::client::fluent_builders::CreateService::set_lambda_endpoint): <p>The configuration for the Lambda endpoint type.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateService::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateService::set_tags): <p>The tags to assign to the service. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair.. </p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateService::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateService::set_client_token): <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    /// - On success, responds with [`CreateServiceOutput`](crate::output::CreateServiceOutput) with field(s):
    ///   - [`service_id(Option<String>)`](crate::output::CreateServiceOutput::service_id): <p>The unique identifier of the service.</p>
    ///   - [`name(Option<String>)`](crate::output::CreateServiceOutput::name): <p>The name of the service.</p>
    ///   - [`arn(Option<String>)`](crate::output::CreateServiceOutput::arn): <p>The Amazon Resource Name (ARN) of the service.</p>
    ///   - [`owner_account_id(Option<String>)`](crate::output::CreateServiceOutput::owner_account_id): <p>The Amazon Web Services account ID of the service owner.</p>
    ///   - [`created_by_account_id(Option<String>)`](crate::output::CreateServiceOutput::created_by_account_id): <p>The Amazon Web Services account ID of the service creator.</p>
    ///   - [`description(Option<String>)`](crate::output::CreateServiceOutput::description): <p>The description of the created service.</p>
    ///   - [`environment_id(Option<String>)`](crate::output::CreateServiceOutput::environment_id): <p>The unique identifier of the environment.</p>
    ///   - [`application_id(Option<String>)`](crate::output::CreateServiceOutput::application_id): <p>The ID of the application that the created service belongs to. </p>
    ///   - [`vpc_id(Option<String>)`](crate::output::CreateServiceOutput::vpc_id): <p>The ID of the VPC. </p>
    ///   - [`endpoint_type(Option<ServiceEndpointType>)`](crate::output::CreateServiceOutput::endpoint_type): <p>The endpoint type of the service.</p>
    ///   - [`url_endpoint(Option<UrlEndpointInput>)`](crate::output::CreateServiceOutput::url_endpoint): <p>The configuration for the URL endpoint type. </p>
    ///   - [`lambda_endpoint(Option<LambdaEndpointInput>)`](crate::output::CreateServiceOutput::lambda_endpoint): <p>The configuration for the Lambda endpoint type.</p>
    ///   - [`state(Option<ServiceState>)`](crate::output::CreateServiceOutput::state): <p>The current state of the service. </p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::CreateServiceOutput::tags): <p>The tags assigned to the created service. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair.. </p>
    ///   - [`last_updated_time(Option<DateTime>)`](crate::output::CreateServiceOutput::last_updated_time): <p>A timestamp that indicates when the service was last updated. </p>
    ///   - [`created_time(Option<DateTime>)`](crate::output::CreateServiceOutput::created_time): <p>A timestamp that indicates when the service is created.</p>
    /// - On failure, responds with [`SdkError<CreateServiceError>`](crate::error::CreateServiceError)
    pub fn create_service(&self) -> fluent_builders::CreateService<C, M, R> {
        fluent_builders::CreateService::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteApplication`](crate::client::fluent_builders::DeleteApplication) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`environment_identifier(impl Into<String>)`](crate::client::fluent_builders::DeleteApplication::environment_identifier) / [`set_environment_identifier(Option<String>)`](crate::client::fluent_builders::DeleteApplication::set_environment_identifier): <p>The ID of the environment. </p>
    ///   - [`application_identifier(impl Into<String>)`](crate::client::fluent_builders::DeleteApplication::application_identifier) / [`set_application_identifier(Option<String>)`](crate::client::fluent_builders::DeleteApplication::set_application_identifier): <p>The ID of the application.</p>
    /// - On success, responds with [`DeleteApplicationOutput`](crate::output::DeleteApplicationOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::DeleteApplicationOutput::name): <p>The name of the application.</p>
    ///   - [`arn(Option<String>)`](crate::output::DeleteApplicationOutput::arn): <p>The Amazon Resource Name (ARN) of the application.</p>
    ///   - [`application_id(Option<String>)`](crate::output::DeleteApplicationOutput::application_id): <p>The ID of the application.</p>
    ///   - [`environment_id(Option<String>)`](crate::output::DeleteApplicationOutput::environment_id): <p>The unique identifier of the application’s environment.</p>
    ///   - [`state(Option<ApplicationState>)`](crate::output::DeleteApplicationOutput::state): <p>The current state of the application. </p>
    ///   - [`last_updated_time(Option<DateTime>)`](crate::output::DeleteApplicationOutput::last_updated_time): <p>A timestamp that indicates when the environment was last updated. </p>
    /// - On failure, responds with [`SdkError<DeleteApplicationError>`](crate::error::DeleteApplicationError)
    pub fn delete_application(&self) -> fluent_builders::DeleteApplication<C, M, R> {
        fluent_builders::DeleteApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteEnvironment`](crate::client::fluent_builders::DeleteEnvironment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`environment_identifier(impl Into<String>)`](crate::client::fluent_builders::DeleteEnvironment::environment_identifier) / [`set_environment_identifier(Option<String>)`](crate::client::fluent_builders::DeleteEnvironment::set_environment_identifier): <p>The ID of the environment. </p>
    /// - On success, responds with [`DeleteEnvironmentOutput`](crate::output::DeleteEnvironmentOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::DeleteEnvironmentOutput::name): <p>The name of the environment.</p>
    ///   - [`arn(Option<String>)`](crate::output::DeleteEnvironmentOutput::arn): <p>The Amazon Resource Name (ARN) of the environment.</p>
    ///   - [`environment_id(Option<String>)`](crate::output::DeleteEnvironmentOutput::environment_id): <p>The unique identifier of the environment.</p>
    ///   - [`state(Option<EnvironmentState>)`](crate::output::DeleteEnvironmentOutput::state): <p>The current state of the environment. </p>
    ///   - [`last_updated_time(Option<DateTime>)`](crate::output::DeleteEnvironmentOutput::last_updated_time): <p>A timestamp that indicates when the environment was last updated. </p>
    /// - On failure, responds with [`SdkError<DeleteEnvironmentError>`](crate::error::DeleteEnvironmentError)
    pub fn delete_environment(&self) -> fluent_builders::DeleteEnvironment<C, M, R> {
        fluent_builders::DeleteEnvironment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteResourcePolicy`](crate::client::fluent_builders::DeleteResourcePolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identifier(impl Into<String>)`](crate::client::fluent_builders::DeleteResourcePolicy::identifier) / [`set_identifier(Option<String>)`](crate::client::fluent_builders::DeleteResourcePolicy::set_identifier): <p>Amazon Resource Name (ARN) of the resource associated with the policy. </p>
    /// - On success, responds with [`DeleteResourcePolicyOutput`](crate::output::DeleteResourcePolicyOutput)

    /// - On failure, responds with [`SdkError<DeleteResourcePolicyError>`](crate::error::DeleteResourcePolicyError)
    pub fn delete_resource_policy(&self) -> fluent_builders::DeleteResourcePolicy<C, M, R> {
        fluent_builders::DeleteResourcePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteRoute`](crate::client::fluent_builders::DeleteRoute) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`environment_identifier(impl Into<String>)`](crate::client::fluent_builders::DeleteRoute::environment_identifier) / [`set_environment_identifier(Option<String>)`](crate::client::fluent_builders::DeleteRoute::set_environment_identifier): <p>The ID of the environment to delete the route from.</p>
    ///   - [`application_identifier(impl Into<String>)`](crate::client::fluent_builders::DeleteRoute::application_identifier) / [`set_application_identifier(Option<String>)`](crate::client::fluent_builders::DeleteRoute::set_application_identifier): <p>The ID of the application to delete the route from.</p>
    ///   - [`route_identifier(impl Into<String>)`](crate::client::fluent_builders::DeleteRoute::route_identifier) / [`set_route_identifier(Option<String>)`](crate::client::fluent_builders::DeleteRoute::set_route_identifier): <p>The ID of the route to delete.</p>
    /// - On success, responds with [`DeleteRouteOutput`](crate::output::DeleteRouteOutput) with field(s):
    ///   - [`route_id(Option<String>)`](crate::output::DeleteRouteOutput::route_id): <p>The ID of the route to delete.</p>
    ///   - [`arn(Option<String>)`](crate::output::DeleteRouteOutput::arn): <p>The Amazon Resource Name (ARN) of the route.</p>
    ///   - [`service_id(Option<String>)`](crate::output::DeleteRouteOutput::service_id): <p>The ID of the service that the route belongs to.</p>
    ///   - [`application_id(Option<String>)`](crate::output::DeleteRouteOutput::application_id): <p>he ID of the application that the route belongs to.</p>
    ///   - [`state(Option<RouteState>)`](crate::output::DeleteRouteOutput::state): <p>The current state of the route. </p>
    ///   - [`last_updated_time(Option<DateTime>)`](crate::output::DeleteRouteOutput::last_updated_time): <p>A timestamp that indicates when the route was last updated. </p>
    /// - On failure, responds with [`SdkError<DeleteRouteError>`](crate::error::DeleteRouteError)
    pub fn delete_route(&self) -> fluent_builders::DeleteRoute<C, M, R> {
        fluent_builders::DeleteRoute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteService`](crate::client::fluent_builders::DeleteService) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`environment_identifier(impl Into<String>)`](crate::client::fluent_builders::DeleteService::environment_identifier) / [`set_environment_identifier(Option<String>)`](crate::client::fluent_builders::DeleteService::set_environment_identifier): <p>The ID of the environment that the service is in.</p>
    ///   - [`application_identifier(impl Into<String>)`](crate::client::fluent_builders::DeleteService::application_identifier) / [`set_application_identifier(Option<String>)`](crate::client::fluent_builders::DeleteService::set_application_identifier): <p>Deletes a Refactor Spaces service.</p> <note>   <p>The <code>RefactorSpacesSecurityGroup</code> security group must be removed from all Amazon Web Services resources in the virtual private cloud (VPC) prior to deleting a service with a URL endpoint in a VPC.</p>  </note>
    ///   - [`service_identifier(impl Into<String>)`](crate::client::fluent_builders::DeleteService::service_identifier) / [`set_service_identifier(Option<String>)`](crate::client::fluent_builders::DeleteService::set_service_identifier): <p>The ID of the service to delete.</p>
    /// - On success, responds with [`DeleteServiceOutput`](crate::output::DeleteServiceOutput) with field(s):
    ///   - [`service_id(Option<String>)`](crate::output::DeleteServiceOutput::service_id): <p>The unique identifier of the service.</p>
    ///   - [`name(Option<String>)`](crate::output::DeleteServiceOutput::name): <p>The name of the service.</p>
    ///   - [`arn(Option<String>)`](crate::output::DeleteServiceOutput::arn): <p>The Amazon Resource Name (ARN) of the service.</p>
    ///   - [`environment_id(Option<String>)`](crate::output::DeleteServiceOutput::environment_id): <p>The unique identifier of the environment.</p>
    ///   - [`application_id(Option<String>)`](crate::output::DeleteServiceOutput::application_id): <p>The ID of the application that the service is in.</p>
    ///   - [`state(Option<ServiceState>)`](crate::output::DeleteServiceOutput::state): <p>The current state of the service. </p>
    ///   - [`last_updated_time(Option<DateTime>)`](crate::output::DeleteServiceOutput::last_updated_time): <p>A timestamp that indicates when the service was last updated. </p>
    /// - On failure, responds with [`SdkError<DeleteServiceError>`](crate::error::DeleteServiceError)
    pub fn delete_service(&self) -> fluent_builders::DeleteService<C, M, R> {
        fluent_builders::DeleteService::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetApplication`](crate::client::fluent_builders::GetApplication) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`environment_identifier(impl Into<String>)`](crate::client::fluent_builders::GetApplication::environment_identifier) / [`set_environment_identifier(Option<String>)`](crate::client::fluent_builders::GetApplication::set_environment_identifier): <p>The ID of the environment. </p>
    ///   - [`application_identifier(impl Into<String>)`](crate::client::fluent_builders::GetApplication::application_identifier) / [`set_application_identifier(Option<String>)`](crate::client::fluent_builders::GetApplication::set_application_identifier): <p>The ID of the application.</p>
    /// - On success, responds with [`GetApplicationOutput`](crate::output::GetApplicationOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::GetApplicationOutput::name): <p>The name of the application.</p>
    ///   - [`arn(Option<String>)`](crate::output::GetApplicationOutput::arn): <p>The Amazon Resource Name (ARN) of the application.</p>
    ///   - [`owner_account_id(Option<String>)`](crate::output::GetApplicationOutput::owner_account_id): <p>The Amazon Web Services account ID of the application owner.</p>
    ///   - [`created_by_account_id(Option<String>)`](crate::output::GetApplicationOutput::created_by_account_id): <p>The Amazon Web Services account ID of the application creator. </p>
    ///   - [`application_id(Option<String>)`](crate::output::GetApplicationOutput::application_id): <p>The unique identifier of the application.</p>
    ///   - [`environment_id(Option<String>)`](crate::output::GetApplicationOutput::environment_id): <p>The unique identifier of the environment.</p>
    ///   - [`vpc_id(Option<String>)`](crate::output::GetApplicationOutput::vpc_id): <p>The ID of the virtual private cloud (VPC). </p>
    ///   - [`proxy_type(Option<ProxyType>)`](crate::output::GetApplicationOutput::proxy_type): <p>The proxy type of the proxy created within the application. </p>
    ///   - [`api_gateway_proxy(Option<ApiGatewayProxyConfig>)`](crate::output::GetApplicationOutput::api_gateway_proxy): <p>The endpoint URL of the API Gateway proxy. </p>
    ///   - [`state(Option<ApplicationState>)`](crate::output::GetApplicationOutput::state): <p>The current state of the application. </p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::GetApplicationOutput::tags): <p>The tags assigned to the application. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair. </p>
    ///   - [`error(Option<ErrorResponse>)`](crate::output::GetApplicationOutput::error): <p>Any error associated with the application resource. </p>
    ///   - [`last_updated_time(Option<DateTime>)`](crate::output::GetApplicationOutput::last_updated_time): <p>A timestamp that indicates when the application was last updated. </p>
    ///   - [`created_time(Option<DateTime>)`](crate::output::GetApplicationOutput::created_time): <p>A timestamp that indicates when the application is created. </p>
    /// - On failure, responds with [`SdkError<GetApplicationError>`](crate::error::GetApplicationError)
    pub fn get_application(&self) -> fluent_builders::GetApplication<C, M, R> {
        fluent_builders::GetApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetEnvironment`](crate::client::fluent_builders::GetEnvironment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`environment_identifier(impl Into<String>)`](crate::client::fluent_builders::GetEnvironment::environment_identifier) / [`set_environment_identifier(Option<String>)`](crate::client::fluent_builders::GetEnvironment::set_environment_identifier): <p>The ID of the environment.</p>
    /// - On success, responds with [`GetEnvironmentOutput`](crate::output::GetEnvironmentOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::GetEnvironmentOutput::name): <p>The name of the environment.</p>
    ///   - [`arn(Option<String>)`](crate::output::GetEnvironmentOutput::arn): <p>The Amazon Resource Name (ARN) of the environment.</p>
    ///   - [`description(Option<String>)`](crate::output::GetEnvironmentOutput::description): <p>The description of the environment. </p>
    ///   - [`environment_id(Option<String>)`](crate::output::GetEnvironmentOutput::environment_id): <p>The unique identifier of the environment. </p>
    ///   - [`network_fabric_type(Option<NetworkFabricType>)`](crate::output::GetEnvironmentOutput::network_fabric_type): <p>The network fabric type of the environment. </p>
    ///   - [`owner_account_id(Option<String>)`](crate::output::GetEnvironmentOutput::owner_account_id): <p>The Amazon Web Services account ID of the environment owner.</p>
    ///   - [`transit_gateway_id(Option<String>)`](crate::output::GetEnvironmentOutput::transit_gateway_id): <p>The ID of the transit gateway set up by the environment. </p>
    ///   - [`state(Option<EnvironmentState>)`](crate::output::GetEnvironmentOutput::state): <p>The current state of the environment. </p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::GetEnvironmentOutput::tags): <p>The tags to assign to the environment. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair. </p>
    ///   - [`error(Option<ErrorResponse>)`](crate::output::GetEnvironmentOutput::error): <p>Any error associated with the environment resource. </p>
    ///   - [`last_updated_time(Option<DateTime>)`](crate::output::GetEnvironmentOutput::last_updated_time): <p>A timestamp that indicates when the environment was last updated. </p>
    ///   - [`created_time(Option<DateTime>)`](crate::output::GetEnvironmentOutput::created_time): <p>A timestamp that indicates when the environment is created. </p>
    /// - On failure, responds with [`SdkError<GetEnvironmentError>`](crate::error::GetEnvironmentError)
    pub fn get_environment(&self) -> fluent_builders::GetEnvironment<C, M, R> {
        fluent_builders::GetEnvironment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetResourcePolicy`](crate::client::fluent_builders::GetResourcePolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identifier(impl Into<String>)`](crate::client::fluent_builders::GetResourcePolicy::identifier) / [`set_identifier(Option<String>)`](crate::client::fluent_builders::GetResourcePolicy::set_identifier): <p>The Amazon Resource Name (ARN) of the resource associated with the policy. </p>
    /// - On success, responds with [`GetResourcePolicyOutput`](crate::output::GetResourcePolicyOutput) with field(s):
    ///   - [`policy(Option<String>)`](crate::output::GetResourcePolicyOutput::policy): <p>A JSON-formatted string for an Amazon Web Services resource-based policy. </p>
    /// - On failure, responds with [`SdkError<GetResourcePolicyError>`](crate::error::GetResourcePolicyError)
    pub fn get_resource_policy(&self) -> fluent_builders::GetResourcePolicy<C, M, R> {
        fluent_builders::GetResourcePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetRoute`](crate::client::fluent_builders::GetRoute) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`environment_identifier(impl Into<String>)`](crate::client::fluent_builders::GetRoute::environment_identifier) / [`set_environment_identifier(Option<String>)`](crate::client::fluent_builders::GetRoute::set_environment_identifier): <p>The ID of the environment.</p>
    ///   - [`application_identifier(impl Into<String>)`](crate::client::fluent_builders::GetRoute::application_identifier) / [`set_application_identifier(Option<String>)`](crate::client::fluent_builders::GetRoute::set_application_identifier): <p>The ID of the application. </p>
    ///   - [`route_identifier(impl Into<String>)`](crate::client::fluent_builders::GetRoute::route_identifier) / [`set_route_identifier(Option<String>)`](crate::client::fluent_builders::GetRoute::set_route_identifier): <p>The ID of the route.</p>
    /// - On success, responds with [`GetRouteOutput`](crate::output::GetRouteOutput) with field(s):
    ///   - [`route_id(Option<String>)`](crate::output::GetRouteOutput::route_id): <p>The unique identifier of the route.</p>  <p> <b>DEFAULT</b>: All traffic that does not match another route is forwarded to the default route. Applications must have a default route before any other routes can be created.</p>  <p> <b>URI_PATH</b>: A route that is based on a URI path.</p>
    ///   - [`arn(Option<String>)`](crate::output::GetRouteOutput::arn): <p>The Amazon Resource Name (ARN) of the route.</p>
    ///   - [`owner_account_id(Option<String>)`](crate::output::GetRouteOutput::owner_account_id): <p>The Amazon Web Services account ID of the route owner.</p>
    ///   - [`created_by_account_id(Option<String>)`](crate::output::GetRouteOutput::created_by_account_id): <p>The Amazon Web Services account ID of the route creator.</p>
    ///   - [`route_type(Option<RouteType>)`](crate::output::GetRouteOutput::route_type): <p>The type of route.</p>
    ///   - [`service_id(Option<String>)`](crate::output::GetRouteOutput::service_id): <p>The unique identifier of the service.</p>
    ///   - [`application_id(Option<String>)`](crate::output::GetRouteOutput::application_id): <p>The ID of the application that the route belongs to. </p>
    ///   - [`environment_id(Option<String>)`](crate::output::GetRouteOutput::environment_id): <p>Unique identifier of the environment.</p>
    ///   - [`source_path(Option<String>)`](crate::output::GetRouteOutput::source_path): <p>The path to use to match traffic. Paths must start with <code>/</code> and are relative to the base of the application. </p>
    ///   - [`methods(Option<Vec<HttpMethod>>)`](crate::output::GetRouteOutput::methods): <p>A list of HTTP methods to match. An empty list matches all values. If a method is present, only HTTP requests using that method are forwarded to this route’s service. </p>
    ///   - [`include_child_paths(Option<bool>)`](crate::output::GetRouteOutput::include_child_paths): <p>Indicates whether to match all subpaths of the given source path. If this value is <code>false</code>, requests must match the source path exactly before they are forwarded to this route's service. </p>
    ///   - [`path_resource_to_id(Option<HashMap<String, String>>)`](crate::output::GetRouteOutput::path_resource_to_id): <p>A mapping of Amazon API Gateway path resources to resource IDs. </p>
    ///   - [`state(Option<RouteState>)`](crate::output::GetRouteOutput::state): <p>The current state of the route. </p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::GetRouteOutput::tags): <p>The tags assigned to the route. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair. </p>
    ///   - [`error(Option<ErrorResponse>)`](crate::output::GetRouteOutput::error): <p>Any error associated with the route resource. </p>
    ///   - [`last_updated_time(Option<DateTime>)`](crate::output::GetRouteOutput::last_updated_time): <p>A timestamp that indicates when the route was last updated. </p>
    ///   - [`created_time(Option<DateTime>)`](crate::output::GetRouteOutput::created_time): <p>The timestamp of when the route is created. </p>
    /// - On failure, responds with [`SdkError<GetRouteError>`](crate::error::GetRouteError)
    pub fn get_route(&self) -> fluent_builders::GetRoute<C, M, R> {
        fluent_builders::GetRoute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetService`](crate::client::fluent_builders::GetService) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`environment_identifier(impl Into<String>)`](crate::client::fluent_builders::GetService::environment_identifier) / [`set_environment_identifier(Option<String>)`](crate::client::fluent_builders::GetService::set_environment_identifier): <p>The ID of the environment.</p>
    ///   - [`application_identifier(impl Into<String>)`](crate::client::fluent_builders::GetService::application_identifier) / [`set_application_identifier(Option<String>)`](crate::client::fluent_builders::GetService::set_application_identifier): <p>The ID of the application.</p>
    ///   - [`service_identifier(impl Into<String>)`](crate::client::fluent_builders::GetService::service_identifier) / [`set_service_identifier(Option<String>)`](crate::client::fluent_builders::GetService::set_service_identifier): <p>The ID of the service.</p>
    /// - On success, responds with [`GetServiceOutput`](crate::output::GetServiceOutput) with field(s):
    ///   - [`service_id(Option<String>)`](crate::output::GetServiceOutput::service_id): <p>The unique identifier of the service.</p>
    ///   - [`name(Option<String>)`](crate::output::GetServiceOutput::name): <p>The name of the service.</p>
    ///   - [`arn(Option<String>)`](crate::output::GetServiceOutput::arn): <p>The Amazon Resource Name (ARN) of the service.</p>
    ///   - [`owner_account_id(Option<String>)`](crate::output::GetServiceOutput::owner_account_id): <p>The Amazon Web Services account ID of the service owner.</p>
    ///   - [`created_by_account_id(Option<String>)`](crate::output::GetServiceOutput::created_by_account_id): <p>The Amazon Web Services account ID of the service creator.</p>
    ///   - [`description(Option<String>)`](crate::output::GetServiceOutput::description): <p>The description of the service. </p>
    ///   - [`environment_id(Option<String>)`](crate::output::GetServiceOutput::environment_id): <p>The unique identifier of the environment.</p>
    ///   - [`application_id(Option<String>)`](crate::output::GetServiceOutput::application_id): <p>The ID of the application.</p>
    ///   - [`vpc_id(Option<String>)`](crate::output::GetServiceOutput::vpc_id): <p>The ID of the virtual private cloud (VPC). </p>
    ///   - [`endpoint_type(Option<ServiceEndpointType>)`](crate::output::GetServiceOutput::endpoint_type): <p>The endpoint type of the service.</p>
    ///   - [`url_endpoint(Option<UrlEndpointConfig>)`](crate::output::GetServiceOutput::url_endpoint): <p>The configuration for the URL endpoint type.</p>  <p>The <b>Url</b> isthe URL of the endpoint type.</p>  <p>The <b>HealthUrl</b> is the health check URL of the endpoint type. </p>
    ///   - [`lambda_endpoint(Option<LambdaEndpointConfig>)`](crate::output::GetServiceOutput::lambda_endpoint): <p>The configuration for the Lambda endpoint type.</p>  <p>The <b>Arn</b> is the Amazon Resource Name (ARN) of the Lambda function associated with this service. </p>
    ///   - [`state(Option<ServiceState>)`](crate::output::GetServiceOutput::state): <p>The current state of the service. </p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::GetServiceOutput::tags): <p>The tags assigned to the service. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair. </p>
    ///   - [`error(Option<ErrorResponse>)`](crate::output::GetServiceOutput::error): <p>Any error associated with the service resource. </p>
    ///   - [`last_updated_time(Option<DateTime>)`](crate::output::GetServiceOutput::last_updated_time): <p>A timestamp that indicates when the service was last updated. </p>
    ///   - [`created_time(Option<DateTime>)`](crate::output::GetServiceOutput::created_time): <p>The timestamp of when the service is created.</p>
    /// - On failure, responds with [`SdkError<GetServiceError>`](crate::error::GetServiceError)
    pub fn get_service(&self) -> fluent_builders::GetService<C, M, R> {
        fluent_builders::GetService::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListApplications`](crate::client::fluent_builders::ListApplications) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListApplications::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`environment_identifier(impl Into<String>)`](crate::client::fluent_builders::ListApplications::environment_identifier) / [`set_environment_identifier(Option<String>)`](crate::client::fluent_builders::ListApplications::set_environment_identifier): <p>The ID of the environment. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListApplications::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListApplications::set_next_token): <p>The token for the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListApplications::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListApplications::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    /// - On success, responds with [`ListApplicationsOutput`](crate::output::ListApplicationsOutput) with field(s):
    ///   - [`application_summary_list(Option<Vec<ApplicationSummary>>)`](crate::output::ListApplicationsOutput::application_summary_list): <p>The list of <code>ApplicationSummary</code> objects. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListApplicationsOutput::next_token): <p>The token for the next page of results.</p>
    /// - On failure, responds with [`SdkError<ListApplicationsError>`](crate::error::ListApplicationsError)
    pub fn list_applications(&self) -> fluent_builders::ListApplications<C, M, R> {
        fluent_builders::ListApplications::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListEnvironments`](crate::client::fluent_builders::ListEnvironments) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListEnvironments::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListEnvironments::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListEnvironments::set_next_token): <p>The token for the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListEnvironments::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListEnvironments::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    /// - On success, responds with [`ListEnvironmentsOutput`](crate::output::ListEnvironmentsOutput) with field(s):
    ///   - [`environment_summary_list(Option<Vec<EnvironmentSummary>>)`](crate::output::ListEnvironmentsOutput::environment_summary_list): <p>The list of <code>EnvironmentSummary</code> objects. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListEnvironmentsOutput::next_token): <p>The token for the next page of results.</p>
    /// - On failure, responds with [`SdkError<ListEnvironmentsError>`](crate::error::ListEnvironmentsError)
    pub fn list_environments(&self) -> fluent_builders::ListEnvironments<C, M, R> {
        fluent_builders::ListEnvironments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListEnvironmentVpcs`](crate::client::fluent_builders::ListEnvironmentVpcs) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListEnvironmentVpcs::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`environment_identifier(impl Into<String>)`](crate::client::fluent_builders::ListEnvironmentVpcs::environment_identifier) / [`set_environment_identifier(Option<String>)`](crate::client::fluent_builders::ListEnvironmentVpcs::set_environment_identifier): <p>The ID of the environment. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListEnvironmentVpcs::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListEnvironmentVpcs::set_next_token): <p>The token for the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListEnvironmentVpcs::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListEnvironmentVpcs::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    /// - On success, responds with [`ListEnvironmentVpcsOutput`](crate::output::ListEnvironmentVpcsOutput) with field(s):
    ///   - [`environment_vpc_list(Option<Vec<EnvironmentVpc>>)`](crate::output::ListEnvironmentVpcsOutput::environment_vpc_list): <p>The list of <code>EnvironmentVpc</code> objects. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListEnvironmentVpcsOutput::next_token): <p>The token for the next page of results.</p>
    /// - On failure, responds with [`SdkError<ListEnvironmentVpcsError>`](crate::error::ListEnvironmentVpcsError)
    pub fn list_environment_vpcs(&self) -> fluent_builders::ListEnvironmentVpcs<C, M, R> {
        fluent_builders::ListEnvironmentVpcs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListRoutes`](crate::client::fluent_builders::ListRoutes) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListRoutes::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`environment_identifier(impl Into<String>)`](crate::client::fluent_builders::ListRoutes::environment_identifier) / [`set_environment_identifier(Option<String>)`](crate::client::fluent_builders::ListRoutes::set_environment_identifier): <p>The ID of the environment. </p>
    ///   - [`application_identifier(impl Into<String>)`](crate::client::fluent_builders::ListRoutes::application_identifier) / [`set_application_identifier(Option<String>)`](crate::client::fluent_builders::ListRoutes::set_application_identifier): <p>The ID of the application. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListRoutes::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListRoutes::set_next_token): <p>The token for the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListRoutes::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListRoutes::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    /// - On success, responds with [`ListRoutesOutput`](crate::output::ListRoutesOutput) with field(s):
    ///   - [`route_summary_list(Option<Vec<RouteSummary>>)`](crate::output::ListRoutesOutput::route_summary_list): <p>The list of <code>RouteSummary</code> objects. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListRoutesOutput::next_token): <p>The token for the next page of results.</p>
    /// - On failure, responds with [`SdkError<ListRoutesError>`](crate::error::ListRoutesError)
    pub fn list_routes(&self) -> fluent_builders::ListRoutes<C, M, R> {
        fluent_builders::ListRoutes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListServices`](crate::client::fluent_builders::ListServices) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListServices::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`environment_identifier(impl Into<String>)`](crate::client::fluent_builders::ListServices::environment_identifier) / [`set_environment_identifier(Option<String>)`](crate::client::fluent_builders::ListServices::set_environment_identifier): <p>The ID of the environment. </p>
    ///   - [`application_identifier(impl Into<String>)`](crate::client::fluent_builders::ListServices::application_identifier) / [`set_application_identifier(Option<String>)`](crate::client::fluent_builders::ListServices::set_application_identifier): <p>The ID of the application. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListServices::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListServices::set_next_token): <p>The token for the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListServices::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListServices::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    /// - On success, responds with [`ListServicesOutput`](crate::output::ListServicesOutput) with field(s):
    ///   - [`service_summary_list(Option<Vec<ServiceSummary>>)`](crate::output::ListServicesOutput::service_summary_list): <p> The list of <code>ServiceSummary</code> objects. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListServicesOutput::next_token): <p>The token for the next page of results.</p>
    /// - On failure, responds with [`SdkError<ListServicesError>`](crate::error::ListServicesError)
    pub fn list_services(&self) -> fluent_builders::ListServices<C, M, R> {
        fluent_builders::ListServices::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource. </p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsForResourceOutput::tags): <p>The list of tags assigned to the resource. </p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutResourcePolicy`](crate::client::fluent_builders::PutResourcePolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::PutResourcePolicy::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::PutResourcePolicy::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource to which the policy is being attached. </p>
    ///   - [`policy(impl Into<String>)`](crate::client::fluent_builders::PutResourcePolicy::policy) / [`set_policy(Option<String>)`](crate::client::fluent_builders::PutResourcePolicy::set_policy): <p>A JSON-formatted string for an Amazon Web Services resource-based policy. </p>
    /// - On success, responds with [`PutResourcePolicyOutput`](crate::output::PutResourcePolicyOutput)

    /// - On failure, responds with [`SdkError<PutResourcePolicyError>`](crate::error::PutResourcePolicyError)
    pub fn put_resource_policy(&self) -> fluent_builders::PutResourcePolicy<C, M, R> {
        fluent_builders::PutResourcePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>The new or modified tags for the resource. </p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource. </p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The list of keys of the tags to be removed from the resource. </p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateApplication`.
    ///
    /// <p>Creates an Amazon Web Services Migration Hub Refactor Spaces application. The account that owns the environment also owns the applications created inside the environment, regardless of the account that creates the application. Refactor Spaces provisions the Amazon API Gateway and Network Load Balancer for the application proxy inside your account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateApplication<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_application_input::Builder,
    }
    impl<C, M, R> CreateApplication<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateApplicationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateApplicationInputOperationOutputAlias,
                crate::output::CreateApplicationOutput,
                crate::error::CreateApplicationError,
                crate::input::CreateApplicationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name to use for the application. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name to use for the application. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The unique identifier of the environment.</p>
        pub fn environment_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_identifier(input.into());
            self
        }
        /// <p>The unique identifier of the environment.</p>
        pub fn set_environment_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_identifier(input);
            self
        }
        /// <p>The ID of the virtual private cloud (VPC).</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_id(input.into());
            self
        }
        /// <p>The ID of the virtual private cloud (VPC).</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_vpc_id(input);
            self
        }
        /// <p>The proxy type of the proxy created within the application. </p>
        pub fn proxy_type(mut self, input: crate::model::ProxyType) -> Self {
            self.inner = self.inner.proxy_type(input);
            self
        }
        /// <p>The proxy type of the proxy created within the application. </p>
        pub fn set_proxy_type(
            mut self,
            input: std::option::Option<crate::model::ProxyType>,
        ) -> Self {
            self.inner = self.inner.set_proxy_type(input);
            self
        }
        /// <p>A wrapper object holding the API Gateway endpoint type and stage name for the proxy. </p>
        pub fn api_gateway_proxy(mut self, input: crate::model::ApiGatewayProxyInput) -> Self {
            self.inner = self.inner.api_gateway_proxy(input);
            self
        }
        /// <p>A wrapper object holding the API Gateway endpoint type and stage name for the proxy. </p>
        pub fn set_api_gateway_proxy(
            mut self,
            input: std::option::Option<crate::model::ApiGatewayProxyInput>,
        ) -> Self {
            self.inner = self.inner.set_api_gateway_proxy(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to assign to the application. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags to assign to the application. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateEnvironment`.
    ///
    /// <p>Creates an Amazon Web Services Migration Hub Refactor Spaces environment. The caller owns the environment resource, and they are referred to as the <i>environment owner</i>. The environment owner has cross-account visibility and control of Refactor Spaces resources that are added to the environment by other accounts that the environment is shared with. When creating an environment, Refactor Spaces provisions a transit gateway in your account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateEnvironment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_environment_input::Builder,
    }
    impl<C, M, R> CreateEnvironment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateEnvironment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateEnvironmentOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateEnvironmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateEnvironmentInputOperationOutputAlias,
                crate::output::CreateEnvironmentOutput,
                crate::error::CreateEnvironmentError,
                crate::input::CreateEnvironmentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the environment.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the environment.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the environment.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the environment.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The network fabric type of the environment.</p>
        pub fn network_fabric_type(mut self, input: crate::model::NetworkFabricType) -> Self {
            self.inner = self.inner.network_fabric_type(input);
            self
        }
        /// <p>The network fabric type of the environment.</p>
        pub fn set_network_fabric_type(
            mut self,
            input: std::option::Option<crate::model::NetworkFabricType>,
        ) -> Self {
            self.inner = self.inner.set_network_fabric_type(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to assign to the environment. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags to assign to the environment. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRoute`.
    ///
    /// <p>Creates an Amazon Web Services Migration Hub Refactor Spaces route. The account owner of the service resource is always the environment owner, regardless of which account creates the route. Routes target a service in the application. If an application does not have any routes, then the first route must be created as a <code>DEFAULT</code> <code>RouteType</code>.</p>
    /// <p>When you create a route, Refactor Spaces configures the Amazon API Gateway to send traffic to the target service as follows:</p>
    /// <ul>
    /// <li> <p>If the service has a URL endpoint, and the endpoint resolves to a private IP address, Refactor Spaces routes traffic using the API Gateway VPC link. </p> </li>
    /// <li> <p>If the service has a URL endpoint, and the endpoint resolves to a public IP address, Refactor Spaces routes traffic over the public internet.</p> </li>
    /// <li> <p>If the service has an Lambda function endpoint, then Refactor Spaces uses the API Gateway Lambda integration.</p> </li>
    /// </ul>
    /// <p>A health check is performed on the service when the route is created. If the health check fails, the route transitions to <code>FAILED</code>, and no traffic is sent to the service.</p>
    /// <p>For Lambda functions, the Lambda function state is checked. If the function is not active, the function configuration is updated so that Lambda resources are provisioned. If the Lambda state is <code>Failed</code>, then the route creation fails. For more information, see the <a href="https://docs.aws.amazon.com/lambda/latest/dg/API_GetFunctionConfiguration.html#SSS-GetFunctionConfiguration-response-State">GetFunctionConfiguration's State response parameter</a> in the <i>Lambda Developer Guide</i>.</p>
    /// <p>For public URLs, a connection is opened to the public endpoint. If the URL is not reachable, the health check fails. For private URLs, a target group is created and the target group health check is run.</p>
    /// <p>The <code>HealthCheckProtocol</code>, <code>HealthCheckPort</code>, and <code>HealthCheckPath</code> are the same protocol, port, and path specified in the URL or health URL, if used. All other settings use the default values, as described in <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/target-group-health-checks.html">Health checks for your target groups</a>. The health check is considered successful if at least one target within the target group transitions to a healthy state.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateRoute<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_route_input::Builder,
    }
    impl<C, M, R> CreateRoute<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateRoute`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRouteOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRouteError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateRouteInputOperationOutputAlias,
                crate::output::CreateRouteOutput,
                crate::error::CreateRouteError,
                crate::input::CreateRouteInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the environment in which the route is created.</p>
        pub fn environment_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_identifier(input.into());
            self
        }
        /// <p>The ID of the environment in which the route is created.</p>
        pub fn set_environment_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_identifier(input);
            self
        }
        /// <p>The ID of the application within which the route is being created.</p>
        pub fn application_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_identifier(input.into());
            self
        }
        /// <p>The ID of the application within which the route is being created.</p>
        pub fn set_application_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_identifier(input);
            self
        }
        /// <p>The ID of the service in which the route is created. Traffic that matches this route is forwarded to this service.</p>
        pub fn service_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_identifier(input.into());
            self
        }
        /// <p>The ID of the service in which the route is created. Traffic that matches this route is forwarded to this service.</p>
        pub fn set_service_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_service_identifier(input);
            self
        }
        /// <p>The route type of the route. <code>DEFAULT</code> indicates that all traffic that does not match another route is forwarded to the default route. Applications must have a default route before any other routes can be created. <code>URI_PATH</code> indicates a route that is based on a URI path.</p>
        pub fn route_type(mut self, input: crate::model::RouteType) -> Self {
            self.inner = self.inner.route_type(input);
            self
        }
        /// <p>The route type of the route. <code>DEFAULT</code> indicates that all traffic that does not match another route is forwarded to the default route. Applications must have a default route before any other routes can be created. <code>URI_PATH</code> indicates a route that is based on a URI path.</p>
        pub fn set_route_type(
            mut self,
            input: std::option::Option<crate::model::RouteType>,
        ) -> Self {
            self.inner = self.inner.set_route_type(input);
            self
        }
        /// <p>The configuration for the URI path route type. </p>
        pub fn uri_path_route(mut self, input: crate::model::UriPathRouteInput) -> Self {
            self.inner = self.inner.uri_path_route(input);
            self
        }
        /// <p>The configuration for the URI path route type. </p>
        pub fn set_uri_path_route(
            mut self,
            input: std::option::Option<crate::model::UriPathRouteInput>,
        ) -> Self {
            self.inner = self.inner.set_uri_path_route(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to assign to the route. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair.. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags to assign to the route. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair.. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateService`.
    ///
    /// <p>Creates an Amazon Web Services Migration Hub Refactor Spaces service. The account owner of the service is always the environment owner, regardless of which account in the environment creates the service. Services have either a URL endpoint in a virtual private cloud (VPC), or a Lambda function endpoint.</p> <important>
    /// <p>If an Amazon Web Services resourceis launched in a service VPC, and you want it to be accessible to all of an environment’s services with VPCs and routes, apply the <code>RefactorSpacesSecurityGroup</code> to the resource. Alternatively, to add more cross-account constraints, apply your own security group.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateService<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_service_input::Builder,
    }
    impl<C, M, R> CreateService<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateService`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateServiceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateServiceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateServiceInputOperationOutputAlias,
                crate::output::CreateServiceOutput,
                crate::error::CreateServiceError,
                crate::input::CreateServiceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the service.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the service.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the service.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the service.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The ID of the environment in which the service is created.</p>
        pub fn environment_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_identifier(input.into());
            self
        }
        /// <p>The ID of the environment in which the service is created.</p>
        pub fn set_environment_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_identifier(input);
            self
        }
        /// <p>The ID of the application which the service is created.</p>
        pub fn application_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_identifier(input.into());
            self
        }
        /// <p>The ID of the application which the service is created.</p>
        pub fn set_application_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_identifier(input);
            self
        }
        /// <p>The ID of the VPC.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_id(input.into());
            self
        }
        /// <p>The ID of the VPC.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_vpc_id(input);
            self
        }
        /// <p>The type of endpoint to use for the service. The type can be a URL in a VPC or an Lambda function.</p>
        pub fn endpoint_type(mut self, input: crate::model::ServiceEndpointType) -> Self {
            self.inner = self.inner.endpoint_type(input);
            self
        }
        /// <p>The type of endpoint to use for the service. The type can be a URL in a VPC or an Lambda function.</p>
        pub fn set_endpoint_type(
            mut self,
            input: std::option::Option<crate::model::ServiceEndpointType>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_type(input);
            self
        }
        /// <p>The configuration for the URL endpoint type.</p>
        pub fn url_endpoint(mut self, input: crate::model::UrlEndpointInput) -> Self {
            self.inner = self.inner.url_endpoint(input);
            self
        }
        /// <p>The configuration for the URL endpoint type.</p>
        pub fn set_url_endpoint(
            mut self,
            input: std::option::Option<crate::model::UrlEndpointInput>,
        ) -> Self {
            self.inner = self.inner.set_url_endpoint(input);
            self
        }
        /// <p>The configuration for the Lambda endpoint type.</p>
        pub fn lambda_endpoint(mut self, input: crate::model::LambdaEndpointInput) -> Self {
            self.inner = self.inner.lambda_endpoint(input);
            self
        }
        /// <p>The configuration for the Lambda endpoint type.</p>
        pub fn set_lambda_endpoint(
            mut self,
            input: std::option::Option<crate::model::LambdaEndpointInput>,
        ) -> Self {
            self.inner = self.inner.set_lambda_endpoint(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to assign to the service. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair.. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags to assign to the service. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair.. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteApplication`.
    ///
    /// <p>Deletes an Amazon Web Services Migration Hub Refactor Spaces application. Before you can delete an application, you must first delete any services or routes within the application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteApplication<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_application_input::Builder,
    }
    impl<C, M, R> DeleteApplication<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteApplicationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteApplicationInputOperationOutputAlias,
                crate::output::DeleteApplicationOutput,
                crate::error::DeleteApplicationError,
                crate::input::DeleteApplicationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the environment. </p>
        pub fn environment_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_identifier(input.into());
            self
        }
        /// <p>The ID of the environment. </p>
        pub fn set_environment_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_identifier(input);
            self
        }
        /// <p>The ID of the application.</p>
        pub fn application_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_identifier(input.into());
            self
        }
        /// <p>The ID of the application.</p>
        pub fn set_application_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEnvironment`.
    ///
    /// <p>Deletes an Amazon Web Services Migration Hub Refactor Spaces environment. Before you can delete an environment, you must first delete any applications and services within the environment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteEnvironment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_environment_input::Builder,
    }
    impl<C, M, R> DeleteEnvironment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteEnvironment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEnvironmentOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEnvironmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteEnvironmentInputOperationOutputAlias,
                crate::output::DeleteEnvironmentOutput,
                crate::error::DeleteEnvironmentError,
                crate::input::DeleteEnvironmentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the environment. </p>
        pub fn environment_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_identifier(input.into());
            self
        }
        /// <p>The ID of the environment. </p>
        pub fn set_environment_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteResourcePolicy`.
    ///
    /// <p>Deletes the resource policy set for the environment. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteResourcePolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_resource_policy_input::Builder,
    }
    impl<C, M, R> DeleteResourcePolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteResourcePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteResourcePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteResourcePolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteResourcePolicyInputOperationOutputAlias,
                crate::output::DeleteResourcePolicyOutput,
                crate::error::DeleteResourcePolicyError,
                crate::input::DeleteResourcePolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name (ARN) of the resource associated with the policy. </p>
        pub fn identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identifier(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the resource associated with the policy. </p>
        pub fn set_identifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRoute`.
    ///
    /// <p>Deletes an Amazon Web Services Migration Hub Refactor Spaces route.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteRoute<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_route_input::Builder,
    }
    impl<C, M, R> DeleteRoute<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRoute`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRouteOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRouteError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRouteInputOperationOutputAlias,
                crate::output::DeleteRouteOutput,
                crate::error::DeleteRouteError,
                crate::input::DeleteRouteInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the environment to delete the route from.</p>
        pub fn environment_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_identifier(input.into());
            self
        }
        /// <p>The ID of the environment to delete the route from.</p>
        pub fn set_environment_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_identifier(input);
            self
        }
        /// <p>The ID of the application to delete the route from.</p>
        pub fn application_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_identifier(input.into());
            self
        }
        /// <p>The ID of the application to delete the route from.</p>
        pub fn set_application_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_identifier(input);
            self
        }
        /// <p>The ID of the route to delete.</p>
        pub fn route_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.route_identifier(input.into());
            self
        }
        /// <p>The ID of the route to delete.</p>
        pub fn set_route_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_route_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteService`.
    ///
    /// <p>Deletes an Amazon Web Services Migration Hub Refactor Spaces service. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteService<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_service_input::Builder,
    }
    impl<C, M, R> DeleteService<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteService`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteServiceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteServiceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteServiceInputOperationOutputAlias,
                crate::output::DeleteServiceOutput,
                crate::error::DeleteServiceError,
                crate::input::DeleteServiceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the environment that the service is in.</p>
        pub fn environment_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_identifier(input.into());
            self
        }
        /// <p>The ID of the environment that the service is in.</p>
        pub fn set_environment_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_identifier(input);
            self
        }
        /// <p>Deletes a Refactor Spaces service.</p> <note>
        /// <p>The <code>RefactorSpacesSecurityGroup</code> security group must be removed from all Amazon Web Services resources in the virtual private cloud (VPC) prior to deleting a service with a URL endpoint in a VPC.</p>
        /// </note>
        pub fn application_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_identifier(input.into());
            self
        }
        /// <p>Deletes a Refactor Spaces service.</p> <note>
        /// <p>The <code>RefactorSpacesSecurityGroup</code> security group must be removed from all Amazon Web Services resources in the virtual private cloud (VPC) prior to deleting a service with a URL endpoint in a VPC.</p>
        /// </note>
        pub fn set_application_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_identifier(input);
            self
        }
        /// <p>The ID of the service to delete.</p>
        pub fn service_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_identifier(input.into());
            self
        }
        /// <p>The ID of the service to delete.</p>
        pub fn set_service_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_service_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetApplication`.
    ///
    /// <p>Gets an Amazon Web Services Migration Hub Refactor Spaces application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetApplication<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_application_input::Builder,
    }
    impl<C, M, R> GetApplication<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetApplicationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetApplicationInputOperationOutputAlias,
                crate::output::GetApplicationOutput,
                crate::error::GetApplicationError,
                crate::input::GetApplicationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the environment. </p>
        pub fn environment_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_identifier(input.into());
            self
        }
        /// <p>The ID of the environment. </p>
        pub fn set_environment_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_identifier(input);
            self
        }
        /// <p>The ID of the application.</p>
        pub fn application_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_identifier(input.into());
            self
        }
        /// <p>The ID of the application.</p>
        pub fn set_application_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetEnvironment`.
    ///
    /// <p>Gets an Amazon Web Services Migration Hub Refactor Spaces environment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetEnvironment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_environment_input::Builder,
    }
    impl<C, M, R> GetEnvironment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetEnvironment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEnvironmentOutput,
            aws_smithy_http::result::SdkError<crate::error::GetEnvironmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetEnvironmentInputOperationOutputAlias,
                crate::output::GetEnvironmentOutput,
                crate::error::GetEnvironmentError,
                crate::input::GetEnvironmentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the environment.</p>
        pub fn environment_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_identifier(input.into());
            self
        }
        /// <p>The ID of the environment.</p>
        pub fn set_environment_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetResourcePolicy`.
    ///
    /// <p>Gets the resource-based permission policy that is set for the given environment. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetResourcePolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_resource_policy_input::Builder,
    }
    impl<C, M, R> GetResourcePolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetResourcePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetResourcePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetResourcePolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetResourcePolicyInputOperationOutputAlias,
                crate::output::GetResourcePolicyOutput,
                crate::error::GetResourcePolicyError,
                crate::input::GetResourcePolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource associated with the policy. </p>
        pub fn identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identifier(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource associated with the policy. </p>
        pub fn set_identifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRoute`.
    ///
    /// <p>Gets an Amazon Web Services Migration Hub Refactor Spaces route.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetRoute<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_route_input::Builder,
    }
    impl<C, M, R> GetRoute<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRoute`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRouteOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRouteError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRouteInputOperationOutputAlias,
                crate::output::GetRouteOutput,
                crate::error::GetRouteError,
                crate::input::GetRouteInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the environment.</p>
        pub fn environment_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_identifier(input.into());
            self
        }
        /// <p>The ID of the environment.</p>
        pub fn set_environment_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_identifier(input);
            self
        }
        /// <p>The ID of the application. </p>
        pub fn application_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_identifier(input.into());
            self
        }
        /// <p>The ID of the application. </p>
        pub fn set_application_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_identifier(input);
            self
        }
        /// <p>The ID of the route.</p>
        pub fn route_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.route_identifier(input.into());
            self
        }
        /// <p>The ID of the route.</p>
        pub fn set_route_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_route_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetService`.
    ///
    /// <p>Gets an Amazon Web Services Migration Hub Refactor Spaces service. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetService<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_service_input::Builder,
    }
    impl<C, M, R> GetService<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetService`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetServiceOutput,
            aws_smithy_http::result::SdkError<crate::error::GetServiceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetServiceInputOperationOutputAlias,
                crate::output::GetServiceOutput,
                crate::error::GetServiceError,
                crate::input::GetServiceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the environment.</p>
        pub fn environment_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_identifier(input.into());
            self
        }
        /// <p>The ID of the environment.</p>
        pub fn set_environment_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_identifier(input);
            self
        }
        /// <p>The ID of the application.</p>
        pub fn application_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_identifier(input.into());
            self
        }
        /// <p>The ID of the application.</p>
        pub fn set_application_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_identifier(input);
            self
        }
        /// <p>The ID of the service.</p>
        pub fn service_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_identifier(input.into());
            self
        }
        /// <p>The ID of the service.</p>
        pub fn set_service_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_service_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListApplications`.
    ///
    /// <p>Lists all the Amazon Web Services Migration Hub Refactor Spaces applications within an environment. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListApplications<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_applications_input::Builder,
    }
    impl<C, M, R> ListApplications<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListApplications`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListApplicationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListApplicationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListApplicationsInputOperationOutputAlias,
                crate::output::ListApplicationsOutput,
                crate::error::ListApplicationsError,
                crate::input::ListApplicationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListApplicationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListApplicationsPaginator<C, M, R> {
            crate::paginator::ListApplicationsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the environment. </p>
        pub fn environment_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_identifier(input.into());
            self
        }
        /// <p>The ID of the environment. </p>
        pub fn set_environment_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_identifier(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListEnvironments`.
    ///
    /// <p>Lists Amazon Web Services Migration Hub Refactor Spaces environments owned by a caller account or shared with the caller account. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListEnvironments<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_environments_input::Builder,
    }
    impl<C, M, R> ListEnvironments<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListEnvironments`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListEnvironmentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListEnvironmentsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListEnvironmentsInputOperationOutputAlias,
                crate::output::ListEnvironmentsOutput,
                crate::error::ListEnvironmentsError,
                crate::input::ListEnvironmentsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListEnvironmentsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListEnvironmentsPaginator<C, M, R> {
            crate::paginator::ListEnvironmentsPaginator::new(self.handle, self.inner)
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListEnvironmentVpcs`.
    ///
    /// <p>Lists all the virtual private clouds (VPCs) that are part of an Amazon Web Services Migration Hub Refactor Spaces environment. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListEnvironmentVpcs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_environment_vpcs_input::Builder,
    }
    impl<C, M, R> ListEnvironmentVpcs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListEnvironmentVpcs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListEnvironmentVpcsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListEnvironmentVpcsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListEnvironmentVpcsInputOperationOutputAlias,
                crate::output::ListEnvironmentVpcsOutput,
                crate::error::ListEnvironmentVpcsError,
                crate::input::ListEnvironmentVpcsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListEnvironmentVpcsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListEnvironmentVpcsPaginator<C, M, R> {
            crate::paginator::ListEnvironmentVpcsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the environment. </p>
        pub fn environment_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_identifier(input.into());
            self
        }
        /// <p>The ID of the environment. </p>
        pub fn set_environment_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_identifier(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRoutes`.
    ///
    /// <p>Lists all the Amazon Web Services Migration Hub Refactor Spaces routes within an application. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListRoutes<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_routes_input::Builder,
    }
    impl<C, M, R> ListRoutes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRoutes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRoutesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRoutesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRoutesInputOperationOutputAlias,
                crate::output::ListRoutesOutput,
                crate::error::ListRoutesError,
                crate::input::ListRoutesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListRoutesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListRoutesPaginator<C, M, R> {
            crate::paginator::ListRoutesPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the environment. </p>
        pub fn environment_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_identifier(input.into());
            self
        }
        /// <p>The ID of the environment. </p>
        pub fn set_environment_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_identifier(input);
            self
        }
        /// <p>The ID of the application. </p>
        pub fn application_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_identifier(input.into());
            self
        }
        /// <p>The ID of the application. </p>
        pub fn set_application_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_identifier(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListServices`.
    ///
    /// <p>Lists all the Amazon Web Services Migration Hub Refactor Spaces services within an application. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListServices<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_services_input::Builder,
    }
    impl<C, M, R> ListServices<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListServices`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListServicesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListServicesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListServicesInputOperationOutputAlias,
                crate::output::ListServicesOutput,
                crate::error::ListServicesError,
                crate::input::ListServicesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListServicesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListServicesPaginator<C, M, R> {
            crate::paginator::ListServicesPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the environment. </p>
        pub fn environment_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_identifier(input.into());
            self
        }
        /// <p>The ID of the environment. </p>
        pub fn set_environment_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_identifier(input);
            self
        }
        /// <p>The ID of the application. </p>
        pub fn application_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_identifier(input.into());
            self
        }
        /// <p>The ID of the application. </p>
        pub fn set_application_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_identifier(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists the tags of a resource. The caller account must be the same as the resource’s <code>OwnerAccountId</code>. Listing tags in other accounts is not supported. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutResourcePolicy`.
    ///
    /// <p>Attaches a resource-based permission policy to the Amazon Web Services Migration Hub Refactor Spaces environment. The policy must contain the same actions and condition statements as the <code>arn:aws:ram::aws:permission/AWSRAMDefaultPermissionRefactorSpacesEnvironment</code> permission in Resource Access Manager. The policy must not contain new lines or blank lines. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutResourcePolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_resource_policy_input::Builder,
    }
    impl<C, M, R> PutResourcePolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutResourcePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutResourcePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutResourcePolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutResourcePolicyInputOperationOutputAlias,
                crate::output::PutResourcePolicyOutput,
                crate::error::PutResourcePolicyError,
                crate::input::PutResourcePolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to which the policy is being attached. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to which the policy is being attached. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>A JSON-formatted string for an Amazon Web Services resource-based policy. </p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy(input.into());
            self
        }
        /// <p>A JSON-formatted string for an Amazon Web Services resource-based policy. </p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Removes the tags of a given resource. Tags are metadata which can be used to manage a resource. To tag a resource, the caller account must be the same as the resource’s <code>OwnerAccountId</code>. Tagging resources in other accounts is not supported.</p> <note>
    /// <p>Amazon Web Services Migration Hub Refactor Spaces does not propagate tags to orchestrated resources, such as an environment’s transit gateway.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The new or modified tags for the resource. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The new or modified tags for the resource. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Adds to or modifies the tags of the given resource. Tags are metadata which can be used to manage a resource. To untag a resource, the caller account must be the same as the resource’s <code>OwnerAccountId</code>. Untagging resources across accounts is not supported. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The list of keys of the tags to be removed from the resource. </p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The list of keys of the tags to be removed from the resource. </p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
