// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutResourcePolicyOutput {}
impl std::fmt::Debug for PutResourcePolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutResourcePolicyOutput");
        formatter.finish()
    }
}
/// See [`PutResourcePolicyOutput`](crate::output::PutResourcePolicyOutput)
pub mod put_resource_policy_output {
    /// A builder for [`PutResourcePolicyOutput`](crate::output::PutResourcePolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutResourcePolicyOutput`](crate::output::PutResourcePolicyOutput)
        pub fn build(self) -> crate::output::PutResourcePolicyOutput {
            crate::output::PutResourcePolicyOutput {}
        }
    }
}
impl PutResourcePolicyOutput {
    /// Creates a new builder-style object to manufacture [`PutResourcePolicyOutput`](crate::output::PutResourcePolicyOutput)
    pub fn builder() -> crate::output::put_resource_policy_output::Builder {
        crate::output::put_resource_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>The list of tags assigned to the resource. </p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ListTagsForResourceOutput {
    /// <p>The list of tags assigned to the resource. </p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tags assigned to the resource. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The list of tags assigned to the resource. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListServicesOutput {
    /// <p> The list of <code>ServiceSummary</code> objects. </p>
    pub service_summary_list: std::option::Option<std::vec::Vec<crate::model::ServiceSummary>>,
    /// <p>The token for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListServicesOutput {
    /// <p> The list of <code>ServiceSummary</code> objects. </p>
    pub fn service_summary_list(&self) -> std::option::Option<&[crate::model::ServiceSummary]> {
        self.service_summary_list.as_deref()
    }
    /// <p>The token for the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListServicesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListServicesOutput");
        formatter.field("service_summary_list", &self.service_summary_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListServicesOutput`](crate::output::ListServicesOutput)
pub mod list_services_output {
    /// A builder for [`ListServicesOutput`](crate::output::ListServicesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_summary_list:
            std::option::Option<std::vec::Vec<crate::model::ServiceSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `service_summary_list`.
        ///
        /// To override the contents of this collection use [`set_service_summary_list`](Self::set_service_summary_list).
        ///
        /// <p> The list of <code>ServiceSummary</code> objects. </p>
        pub fn service_summary_list(mut self, input: crate::model::ServiceSummary) -> Self {
            let mut v = self.service_summary_list.unwrap_or_default();
            v.push(input);
            self.service_summary_list = Some(v);
            self
        }
        /// <p> The list of <code>ServiceSummary</code> objects. </p>
        pub fn set_service_summary_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ServiceSummary>>,
        ) -> Self {
            self.service_summary_list = input;
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListServicesOutput`](crate::output::ListServicesOutput)
        pub fn build(self) -> crate::output::ListServicesOutput {
            crate::output::ListServicesOutput {
                service_summary_list: self.service_summary_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListServicesOutput {
    /// Creates a new builder-style object to manufacture [`ListServicesOutput`](crate::output::ListServicesOutput)
    pub fn builder() -> crate::output::list_services_output::Builder {
        crate::output::list_services_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRoutesOutput {
    /// <p>The list of <code>RouteSummary</code> objects. </p>
    pub route_summary_list: std::option::Option<std::vec::Vec<crate::model::RouteSummary>>,
    /// <p>The token for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListRoutesOutput {
    /// <p>The list of <code>RouteSummary</code> objects. </p>
    pub fn route_summary_list(&self) -> std::option::Option<&[crate::model::RouteSummary]> {
        self.route_summary_list.as_deref()
    }
    /// <p>The token for the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListRoutesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRoutesOutput");
        formatter.field("route_summary_list", &self.route_summary_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListRoutesOutput`](crate::output::ListRoutesOutput)
pub mod list_routes_output {
    /// A builder for [`ListRoutesOutput`](crate::output::ListRoutesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) route_summary_list:
            std::option::Option<std::vec::Vec<crate::model::RouteSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `route_summary_list`.
        ///
        /// To override the contents of this collection use [`set_route_summary_list`](Self::set_route_summary_list).
        ///
        /// <p>The list of <code>RouteSummary</code> objects. </p>
        pub fn route_summary_list(mut self, input: crate::model::RouteSummary) -> Self {
            let mut v = self.route_summary_list.unwrap_or_default();
            v.push(input);
            self.route_summary_list = Some(v);
            self
        }
        /// <p>The list of <code>RouteSummary</code> objects. </p>
        pub fn set_route_summary_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RouteSummary>>,
        ) -> Self {
            self.route_summary_list = input;
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRoutesOutput`](crate::output::ListRoutesOutput)
        pub fn build(self) -> crate::output::ListRoutesOutput {
            crate::output::ListRoutesOutput {
                route_summary_list: self.route_summary_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListRoutesOutput {
    /// Creates a new builder-style object to manufacture [`ListRoutesOutput`](crate::output::ListRoutesOutput)
    pub fn builder() -> crate::output::list_routes_output::Builder {
        crate::output::list_routes_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListEnvironmentVpcsOutput {
    /// <p>The list of <code>EnvironmentVpc</code> objects. </p>
    pub environment_vpc_list: std::option::Option<std::vec::Vec<crate::model::EnvironmentVpc>>,
    /// <p>The token for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListEnvironmentVpcsOutput {
    /// <p>The list of <code>EnvironmentVpc</code> objects. </p>
    pub fn environment_vpc_list(&self) -> std::option::Option<&[crate::model::EnvironmentVpc]> {
        self.environment_vpc_list.as_deref()
    }
    /// <p>The token for the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListEnvironmentVpcsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListEnvironmentVpcsOutput");
        formatter.field("environment_vpc_list", &self.environment_vpc_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListEnvironmentVpcsOutput`](crate::output::ListEnvironmentVpcsOutput)
pub mod list_environment_vpcs_output {
    /// A builder for [`ListEnvironmentVpcsOutput`](crate::output::ListEnvironmentVpcsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environment_vpc_list:
            std::option::Option<std::vec::Vec<crate::model::EnvironmentVpc>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `environment_vpc_list`.
        ///
        /// To override the contents of this collection use [`set_environment_vpc_list`](Self::set_environment_vpc_list).
        ///
        /// <p>The list of <code>EnvironmentVpc</code> objects. </p>
        pub fn environment_vpc_list(mut self, input: crate::model::EnvironmentVpc) -> Self {
            let mut v = self.environment_vpc_list.unwrap_or_default();
            v.push(input);
            self.environment_vpc_list = Some(v);
            self
        }
        /// <p>The list of <code>EnvironmentVpc</code> objects. </p>
        pub fn set_environment_vpc_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EnvironmentVpc>>,
        ) -> Self {
            self.environment_vpc_list = input;
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListEnvironmentVpcsOutput`](crate::output::ListEnvironmentVpcsOutput)
        pub fn build(self) -> crate::output::ListEnvironmentVpcsOutput {
            crate::output::ListEnvironmentVpcsOutput {
                environment_vpc_list: self.environment_vpc_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListEnvironmentVpcsOutput {
    /// Creates a new builder-style object to manufacture [`ListEnvironmentVpcsOutput`](crate::output::ListEnvironmentVpcsOutput)
    pub fn builder() -> crate::output::list_environment_vpcs_output::Builder {
        crate::output::list_environment_vpcs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListEnvironmentsOutput {
    /// <p>The list of <code>EnvironmentSummary</code> objects. </p>
    pub environment_summary_list:
        std::option::Option<std::vec::Vec<crate::model::EnvironmentSummary>>,
    /// <p>The token for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListEnvironmentsOutput {
    /// <p>The list of <code>EnvironmentSummary</code> objects. </p>
    pub fn environment_summary_list(
        &self,
    ) -> std::option::Option<&[crate::model::EnvironmentSummary]> {
        self.environment_summary_list.as_deref()
    }
    /// <p>The token for the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListEnvironmentsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListEnvironmentsOutput");
        formatter.field("environment_summary_list", &self.environment_summary_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListEnvironmentsOutput`](crate::output::ListEnvironmentsOutput)
pub mod list_environments_output {
    /// A builder for [`ListEnvironmentsOutput`](crate::output::ListEnvironmentsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environment_summary_list:
            std::option::Option<std::vec::Vec<crate::model::EnvironmentSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `environment_summary_list`.
        ///
        /// To override the contents of this collection use [`set_environment_summary_list`](Self::set_environment_summary_list).
        ///
        /// <p>The list of <code>EnvironmentSummary</code> objects. </p>
        pub fn environment_summary_list(mut self, input: crate::model::EnvironmentSummary) -> Self {
            let mut v = self.environment_summary_list.unwrap_or_default();
            v.push(input);
            self.environment_summary_list = Some(v);
            self
        }
        /// <p>The list of <code>EnvironmentSummary</code> objects. </p>
        pub fn set_environment_summary_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EnvironmentSummary>>,
        ) -> Self {
            self.environment_summary_list = input;
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListEnvironmentsOutput`](crate::output::ListEnvironmentsOutput)
        pub fn build(self) -> crate::output::ListEnvironmentsOutput {
            crate::output::ListEnvironmentsOutput {
                environment_summary_list: self.environment_summary_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListEnvironmentsOutput {
    /// Creates a new builder-style object to manufacture [`ListEnvironmentsOutput`](crate::output::ListEnvironmentsOutput)
    pub fn builder() -> crate::output::list_environments_output::Builder {
        crate::output::list_environments_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListApplicationsOutput {
    /// <p>The list of <code>ApplicationSummary</code> objects. </p>
    pub application_summary_list:
        std::option::Option<std::vec::Vec<crate::model::ApplicationSummary>>,
    /// <p>The token for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListApplicationsOutput {
    /// <p>The list of <code>ApplicationSummary</code> objects. </p>
    pub fn application_summary_list(
        &self,
    ) -> std::option::Option<&[crate::model::ApplicationSummary]> {
        self.application_summary_list.as_deref()
    }
    /// <p>The token for the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListApplicationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListApplicationsOutput");
        formatter.field("application_summary_list", &self.application_summary_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListApplicationsOutput`](crate::output::ListApplicationsOutput)
pub mod list_applications_output {
    /// A builder for [`ListApplicationsOutput`](crate::output::ListApplicationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_summary_list:
            std::option::Option<std::vec::Vec<crate::model::ApplicationSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `application_summary_list`.
        ///
        /// To override the contents of this collection use [`set_application_summary_list`](Self::set_application_summary_list).
        ///
        /// <p>The list of <code>ApplicationSummary</code> objects. </p>
        pub fn application_summary_list(mut self, input: crate::model::ApplicationSummary) -> Self {
            let mut v = self.application_summary_list.unwrap_or_default();
            v.push(input);
            self.application_summary_list = Some(v);
            self
        }
        /// <p>The list of <code>ApplicationSummary</code> objects. </p>
        pub fn set_application_summary_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ApplicationSummary>>,
        ) -> Self {
            self.application_summary_list = input;
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListApplicationsOutput`](crate::output::ListApplicationsOutput)
        pub fn build(self) -> crate::output::ListApplicationsOutput {
            crate::output::ListApplicationsOutput {
                application_summary_list: self.application_summary_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListApplicationsOutput {
    /// Creates a new builder-style object to manufacture [`ListApplicationsOutput`](crate::output::ListApplicationsOutput)
    pub fn builder() -> crate::output::list_applications_output::Builder {
        crate::output::list_applications_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetServiceOutput {
    /// <p>The unique identifier of the service.</p>
    pub service_id: std::option::Option<std::string::String>,
    /// <p>The name of the service.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the service.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services account ID of the service owner.</p>
    pub owner_account_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services account ID of the service creator.</p>
    pub created_by_account_id: std::option::Option<std::string::String>,
    /// <p>The description of the service. </p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the environment.</p>
    pub environment_id: std::option::Option<std::string::String>,
    /// <p>The ID of the application.</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The ID of the virtual private cloud (VPC). </p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>The endpoint type of the service.</p>
    pub endpoint_type: std::option::Option<crate::model::ServiceEndpointType>,
    /// <p>The configuration for the URL endpoint type.</p>
    /// <p>The <b>Url</b> isthe URL of the endpoint type.</p>
    /// <p>The <b>HealthUrl</b> is the health check URL of the endpoint type. </p>
    pub url_endpoint: std::option::Option<crate::model::UrlEndpointConfig>,
    /// <p>The configuration for the Lambda endpoint type.</p>
    /// <p>The <b>Arn</b> is the Amazon Resource Name (ARN) of the Lambda function associated with this service. </p>
    pub lambda_endpoint: std::option::Option<crate::model::LambdaEndpointConfig>,
    /// <p>The current state of the service. </p>
    pub state: std::option::Option<crate::model::ServiceState>,
    /// <p>The tags assigned to the service. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair. </p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Any error associated with the service resource. </p>
    pub error: std::option::Option<crate::model::ErrorResponse>,
    /// <p>A timestamp that indicates when the service was last updated. </p>
    pub last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The timestamp of when the service is created.</p>
    pub created_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl GetServiceOutput {
    /// <p>The unique identifier of the service.</p>
    pub fn service_id(&self) -> std::option::Option<&str> {
        self.service_id.as_deref()
    }
    /// <p>The name of the service.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the service.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The Amazon Web Services account ID of the service owner.</p>
    pub fn owner_account_id(&self) -> std::option::Option<&str> {
        self.owner_account_id.as_deref()
    }
    /// <p>The Amazon Web Services account ID of the service creator.</p>
    pub fn created_by_account_id(&self) -> std::option::Option<&str> {
        self.created_by_account_id.as_deref()
    }
    /// <p>The description of the service. </p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The unique identifier of the environment.</p>
    pub fn environment_id(&self) -> std::option::Option<&str> {
        self.environment_id.as_deref()
    }
    /// <p>The ID of the application.</p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
    /// <p>The ID of the virtual private cloud (VPC). </p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
    /// <p>The endpoint type of the service.</p>
    pub fn endpoint_type(&self) -> std::option::Option<&crate::model::ServiceEndpointType> {
        self.endpoint_type.as_ref()
    }
    /// <p>The configuration for the URL endpoint type.</p>
    /// <p>The <b>Url</b> isthe URL of the endpoint type.</p>
    /// <p>The <b>HealthUrl</b> is the health check URL of the endpoint type. </p>
    pub fn url_endpoint(&self) -> std::option::Option<&crate::model::UrlEndpointConfig> {
        self.url_endpoint.as_ref()
    }
    /// <p>The configuration for the Lambda endpoint type.</p>
    /// <p>The <b>Arn</b> is the Amazon Resource Name (ARN) of the Lambda function associated with this service. </p>
    pub fn lambda_endpoint(&self) -> std::option::Option<&crate::model::LambdaEndpointConfig> {
        self.lambda_endpoint.as_ref()
    }
    /// <p>The current state of the service. </p>
    pub fn state(&self) -> std::option::Option<&crate::model::ServiceState> {
        self.state.as_ref()
    }
    /// <p>The tags assigned to the service. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair. </p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>Any error associated with the service resource. </p>
    pub fn error(&self) -> std::option::Option<&crate::model::ErrorResponse> {
        self.error.as_ref()
    }
    /// <p>A timestamp that indicates when the service was last updated. </p>
    pub fn last_updated_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_time.as_ref()
    }
    /// <p>The timestamp of when the service is created.</p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_time.as_ref()
    }
}
impl std::fmt::Debug for GetServiceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetServiceOutput");
        formatter.field("service_id", &self.service_id);
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("owner_account_id", &self.owner_account_id);
        formatter.field("created_by_account_id", &self.created_by_account_id);
        formatter.field("description", &self.description);
        formatter.field("environment_id", &self.environment_id);
        formatter.field("application_id", &self.application_id);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("endpoint_type", &self.endpoint_type);
        formatter.field("url_endpoint", &self.url_endpoint);
        formatter.field("lambda_endpoint", &self.lambda_endpoint);
        formatter.field("state", &self.state);
        formatter.field("tags", &"*** Sensitive Data Redacted ***");
        formatter.field("error", &self.error);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.field("created_time", &self.created_time);
        formatter.finish()
    }
}
/// See [`GetServiceOutput`](crate::output::GetServiceOutput)
pub mod get_service_output {
    /// A builder for [`GetServiceOutput`](crate::output::GetServiceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) owner_account_id: std::option::Option<std::string::String>,
        pub(crate) created_by_account_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) environment_id: std::option::Option<std::string::String>,
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) endpoint_type: std::option::Option<crate::model::ServiceEndpointType>,
        pub(crate) url_endpoint: std::option::Option<crate::model::UrlEndpointConfig>,
        pub(crate) lambda_endpoint: std::option::Option<crate::model::LambdaEndpointConfig>,
        pub(crate) state: std::option::Option<crate::model::ServiceState>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) error: std::option::Option<crate::model::ErrorResponse>,
        pub(crate) last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The unique identifier of the service.</p>
        pub fn service_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the service.</p>
        pub fn set_service_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_id = input;
            self
        }
        /// <p>The name of the service.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the service.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the service.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the service.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The Amazon Web Services account ID of the service owner.</p>
        pub fn owner_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the service owner.</p>
        pub fn set_owner_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owner_account_id = input;
            self
        }
        /// <p>The Amazon Web Services account ID of the service creator.</p>
        pub fn created_by_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_by_account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the service creator.</p>
        pub fn set_created_by_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.created_by_account_id = input;
            self
        }
        /// <p>The description of the service. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the service. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The unique identifier of the environment.</p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the environment.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_id = input;
            self
        }
        /// <p>The ID of the application.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The ID of the application.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The ID of the virtual private cloud (VPC). </p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The ID of the virtual private cloud (VPC). </p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// <p>The endpoint type of the service.</p>
        pub fn endpoint_type(mut self, input: crate::model::ServiceEndpointType) -> Self {
            self.endpoint_type = Some(input);
            self
        }
        /// <p>The endpoint type of the service.</p>
        pub fn set_endpoint_type(
            mut self,
            input: std::option::Option<crate::model::ServiceEndpointType>,
        ) -> Self {
            self.endpoint_type = input;
            self
        }
        /// <p>The configuration for the URL endpoint type.</p>
        /// <p>The <b>Url</b> isthe URL of the endpoint type.</p>
        /// <p>The <b>HealthUrl</b> is the health check URL of the endpoint type. </p>
        pub fn url_endpoint(mut self, input: crate::model::UrlEndpointConfig) -> Self {
            self.url_endpoint = Some(input);
            self
        }
        /// <p>The configuration for the URL endpoint type.</p>
        /// <p>The <b>Url</b> isthe URL of the endpoint type.</p>
        /// <p>The <b>HealthUrl</b> is the health check URL of the endpoint type. </p>
        pub fn set_url_endpoint(
            mut self,
            input: std::option::Option<crate::model::UrlEndpointConfig>,
        ) -> Self {
            self.url_endpoint = input;
            self
        }
        /// <p>The configuration for the Lambda endpoint type.</p>
        /// <p>The <b>Arn</b> is the Amazon Resource Name (ARN) of the Lambda function associated with this service. </p>
        pub fn lambda_endpoint(mut self, input: crate::model::LambdaEndpointConfig) -> Self {
            self.lambda_endpoint = Some(input);
            self
        }
        /// <p>The configuration for the Lambda endpoint type.</p>
        /// <p>The <b>Arn</b> is the Amazon Resource Name (ARN) of the Lambda function associated with this service. </p>
        pub fn set_lambda_endpoint(
            mut self,
            input: std::option::Option<crate::model::LambdaEndpointConfig>,
        ) -> Self {
            self.lambda_endpoint = input;
            self
        }
        /// <p>The current state of the service. </p>
        pub fn state(mut self, input: crate::model::ServiceState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of the service. </p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::ServiceState>) -> Self {
            self.state = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags assigned to the service. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags assigned to the service. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Any error associated with the service resource. </p>
        pub fn error(mut self, input: crate::model::ErrorResponse) -> Self {
            self.error = Some(input);
            self
        }
        /// <p>Any error associated with the service resource. </p>
        pub fn set_error(
            mut self,
            input: std::option::Option<crate::model::ErrorResponse>,
        ) -> Self {
            self.error = input;
            self
        }
        /// <p>A timestamp that indicates when the service was last updated. </p>
        pub fn last_updated_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>A timestamp that indicates when the service was last updated. </p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// <p>The timestamp of when the service is created.</p>
        pub fn created_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>The timestamp of when the service is created.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// Consumes the builder and constructs a [`GetServiceOutput`](crate::output::GetServiceOutput)
        pub fn build(self) -> crate::output::GetServiceOutput {
            crate::output::GetServiceOutput {
                service_id: self.service_id,
                name: self.name,
                arn: self.arn,
                owner_account_id: self.owner_account_id,
                created_by_account_id: self.created_by_account_id,
                description: self.description,
                environment_id: self.environment_id,
                application_id: self.application_id,
                vpc_id: self.vpc_id,
                endpoint_type: self.endpoint_type,
                url_endpoint: self.url_endpoint,
                lambda_endpoint: self.lambda_endpoint,
                state: self.state,
                tags: self.tags,
                error: self.error,
                last_updated_time: self.last_updated_time,
                created_time: self.created_time,
            }
        }
    }
}
impl GetServiceOutput {
    /// Creates a new builder-style object to manufacture [`GetServiceOutput`](crate::output::GetServiceOutput)
    pub fn builder() -> crate::output::get_service_output::Builder {
        crate::output::get_service_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRouteOutput {
    /// <p>The unique identifier of the route.</p>
    /// <p> <b>DEFAULT</b>: All traffic that does not match another route is forwarded to the default route. Applications must have a default route before any other routes can be created.</p>
    /// <p> <b>URI_PATH</b>: A route that is based on a URI path.</p>
    pub route_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the route.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services account ID of the route owner.</p>
    pub owner_account_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services account ID of the route creator.</p>
    pub created_by_account_id: std::option::Option<std::string::String>,
    /// <p>The type of route.</p>
    pub route_type: std::option::Option<crate::model::RouteType>,
    /// <p>The unique identifier of the service.</p>
    pub service_id: std::option::Option<std::string::String>,
    /// <p>The ID of the application that the route belongs to. </p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>Unique identifier of the environment.</p>
    pub environment_id: std::option::Option<std::string::String>,
    /// <p>The path to use to match traffic. Paths must start with <code>/</code> and are relative to the base of the application. </p>
    pub source_path: std::option::Option<std::string::String>,
    /// <p>A list of HTTP methods to match. An empty list matches all values. If a method is present, only HTTP requests using that method are forwarded to this route’s service. </p>
    pub methods: std::option::Option<std::vec::Vec<crate::model::HttpMethod>>,
    /// <p>Indicates whether to match all subpaths of the given source path. If this value is <code>false</code>, requests must match the source path exactly before they are forwarded to this route's service. </p>
    pub include_child_paths: std::option::Option<bool>,
    /// <p>A mapping of Amazon API Gateway path resources to resource IDs. </p>
    pub path_resource_to_id:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The current state of the route. </p>
    pub state: std::option::Option<crate::model::RouteState>,
    /// <p>The tags assigned to the route. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair. </p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Any error associated with the route resource. </p>
    pub error: std::option::Option<crate::model::ErrorResponse>,
    /// <p>A timestamp that indicates when the route was last updated. </p>
    pub last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The timestamp of when the route is created. </p>
    pub created_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl GetRouteOutput {
    /// <p>The unique identifier of the route.</p>
    /// <p> <b>DEFAULT</b>: All traffic that does not match another route is forwarded to the default route. Applications must have a default route before any other routes can be created.</p>
    /// <p> <b>URI_PATH</b>: A route that is based on a URI path.</p>
    pub fn route_id(&self) -> std::option::Option<&str> {
        self.route_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the route.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The Amazon Web Services account ID of the route owner.</p>
    pub fn owner_account_id(&self) -> std::option::Option<&str> {
        self.owner_account_id.as_deref()
    }
    /// <p>The Amazon Web Services account ID of the route creator.</p>
    pub fn created_by_account_id(&self) -> std::option::Option<&str> {
        self.created_by_account_id.as_deref()
    }
    /// <p>The type of route.</p>
    pub fn route_type(&self) -> std::option::Option<&crate::model::RouteType> {
        self.route_type.as_ref()
    }
    /// <p>The unique identifier of the service.</p>
    pub fn service_id(&self) -> std::option::Option<&str> {
        self.service_id.as_deref()
    }
    /// <p>The ID of the application that the route belongs to. </p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
    /// <p>Unique identifier of the environment.</p>
    pub fn environment_id(&self) -> std::option::Option<&str> {
        self.environment_id.as_deref()
    }
    /// <p>The path to use to match traffic. Paths must start with <code>/</code> and are relative to the base of the application. </p>
    pub fn source_path(&self) -> std::option::Option<&str> {
        self.source_path.as_deref()
    }
    /// <p>A list of HTTP methods to match. An empty list matches all values. If a method is present, only HTTP requests using that method are forwarded to this route’s service. </p>
    pub fn methods(&self) -> std::option::Option<&[crate::model::HttpMethod]> {
        self.methods.as_deref()
    }
    /// <p>Indicates whether to match all subpaths of the given source path. If this value is <code>false</code>, requests must match the source path exactly before they are forwarded to this route's service. </p>
    pub fn include_child_paths(&self) -> std::option::Option<bool> {
        self.include_child_paths
    }
    /// <p>A mapping of Amazon API Gateway path resources to resource IDs. </p>
    pub fn path_resource_to_id(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.path_resource_to_id.as_ref()
    }
    /// <p>The current state of the route. </p>
    pub fn state(&self) -> std::option::Option<&crate::model::RouteState> {
        self.state.as_ref()
    }
    /// <p>The tags assigned to the route. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair. </p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>Any error associated with the route resource. </p>
    pub fn error(&self) -> std::option::Option<&crate::model::ErrorResponse> {
        self.error.as_ref()
    }
    /// <p>A timestamp that indicates when the route was last updated. </p>
    pub fn last_updated_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_time.as_ref()
    }
    /// <p>The timestamp of when the route is created. </p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_time.as_ref()
    }
}
impl std::fmt::Debug for GetRouteOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRouteOutput");
        formatter.field("route_id", &self.route_id);
        formatter.field("arn", &self.arn);
        formatter.field("owner_account_id", &self.owner_account_id);
        formatter.field("created_by_account_id", &self.created_by_account_id);
        formatter.field("route_type", &self.route_type);
        formatter.field("service_id", &self.service_id);
        formatter.field("application_id", &self.application_id);
        formatter.field("environment_id", &self.environment_id);
        formatter.field("source_path", &self.source_path);
        formatter.field("methods", &self.methods);
        formatter.field("include_child_paths", &self.include_child_paths);
        formatter.field("path_resource_to_id", &self.path_resource_to_id);
        formatter.field("state", &self.state);
        formatter.field("tags", &"*** Sensitive Data Redacted ***");
        formatter.field("error", &self.error);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.field("created_time", &self.created_time);
        formatter.finish()
    }
}
/// See [`GetRouteOutput`](crate::output::GetRouteOutput)
pub mod get_route_output {
    /// A builder for [`GetRouteOutput`](crate::output::GetRouteOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) route_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) owner_account_id: std::option::Option<std::string::String>,
        pub(crate) created_by_account_id: std::option::Option<std::string::String>,
        pub(crate) route_type: std::option::Option<crate::model::RouteType>,
        pub(crate) service_id: std::option::Option<std::string::String>,
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) environment_id: std::option::Option<std::string::String>,
        pub(crate) source_path: std::option::Option<std::string::String>,
        pub(crate) methods: std::option::Option<std::vec::Vec<crate::model::HttpMethod>>,
        pub(crate) include_child_paths: std::option::Option<bool>,
        pub(crate) path_resource_to_id: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) state: std::option::Option<crate::model::RouteState>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) error: std::option::Option<crate::model::ErrorResponse>,
        pub(crate) last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The unique identifier of the route.</p>
        /// <p> <b>DEFAULT</b>: All traffic that does not match another route is forwarded to the default route. Applications must have a default route before any other routes can be created.</p>
        /// <p> <b>URI_PATH</b>: A route that is based on a URI path.</p>
        pub fn route_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the route.</p>
        /// <p> <b>DEFAULT</b>: All traffic that does not match another route is forwarded to the default route. Applications must have a default route before any other routes can be created.</p>
        /// <p> <b>URI_PATH</b>: A route that is based on a URI path.</p>
        pub fn set_route_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.route_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the route.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the route.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The Amazon Web Services account ID of the route owner.</p>
        pub fn owner_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the route owner.</p>
        pub fn set_owner_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owner_account_id = input;
            self
        }
        /// <p>The Amazon Web Services account ID of the route creator.</p>
        pub fn created_by_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_by_account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the route creator.</p>
        pub fn set_created_by_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.created_by_account_id = input;
            self
        }
        /// <p>The type of route.</p>
        pub fn route_type(mut self, input: crate::model::RouteType) -> Self {
            self.route_type = Some(input);
            self
        }
        /// <p>The type of route.</p>
        pub fn set_route_type(
            mut self,
            input: std::option::Option<crate::model::RouteType>,
        ) -> Self {
            self.route_type = input;
            self
        }
        /// <p>The unique identifier of the service.</p>
        pub fn service_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the service.</p>
        pub fn set_service_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_id = input;
            self
        }
        /// <p>The ID of the application that the route belongs to. </p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The ID of the application that the route belongs to. </p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>Unique identifier of the environment.</p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_id = Some(input.into());
            self
        }
        /// <p>Unique identifier of the environment.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_id = input;
            self
        }
        /// <p>The path to use to match traffic. Paths must start with <code>/</code> and are relative to the base of the application. </p>
        pub fn source_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_path = Some(input.into());
            self
        }
        /// <p>The path to use to match traffic. Paths must start with <code>/</code> and are relative to the base of the application. </p>
        pub fn set_source_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_path = input;
            self
        }
        /// Appends an item to `methods`.
        ///
        /// To override the contents of this collection use [`set_methods`](Self::set_methods).
        ///
        /// <p>A list of HTTP methods to match. An empty list matches all values. If a method is present, only HTTP requests using that method are forwarded to this route’s service. </p>
        pub fn methods(mut self, input: crate::model::HttpMethod) -> Self {
            let mut v = self.methods.unwrap_or_default();
            v.push(input);
            self.methods = Some(v);
            self
        }
        /// <p>A list of HTTP methods to match. An empty list matches all values. If a method is present, only HTTP requests using that method are forwarded to this route’s service. </p>
        pub fn set_methods(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HttpMethod>>,
        ) -> Self {
            self.methods = input;
            self
        }
        /// <p>Indicates whether to match all subpaths of the given source path. If this value is <code>false</code>, requests must match the source path exactly before they are forwarded to this route's service. </p>
        pub fn include_child_paths(mut self, input: bool) -> Self {
            self.include_child_paths = Some(input);
            self
        }
        /// <p>Indicates whether to match all subpaths of the given source path. If this value is <code>false</code>, requests must match the source path exactly before they are forwarded to this route's service. </p>
        pub fn set_include_child_paths(mut self, input: std::option::Option<bool>) -> Self {
            self.include_child_paths = input;
            self
        }
        /// Adds a key-value pair to `path_resource_to_id`.
        ///
        /// To override the contents of this collection use [`set_path_resource_to_id`](Self::set_path_resource_to_id).
        ///
        /// <p>A mapping of Amazon API Gateway path resources to resource IDs. </p>
        pub fn path_resource_to_id(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.path_resource_to_id.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.path_resource_to_id = Some(hash_map);
            self
        }
        /// <p>A mapping of Amazon API Gateway path resources to resource IDs. </p>
        pub fn set_path_resource_to_id(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.path_resource_to_id = input;
            self
        }
        /// <p>The current state of the route. </p>
        pub fn state(mut self, input: crate::model::RouteState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of the route. </p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::RouteState>) -> Self {
            self.state = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags assigned to the route. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags assigned to the route. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Any error associated with the route resource. </p>
        pub fn error(mut self, input: crate::model::ErrorResponse) -> Self {
            self.error = Some(input);
            self
        }
        /// <p>Any error associated with the route resource. </p>
        pub fn set_error(
            mut self,
            input: std::option::Option<crate::model::ErrorResponse>,
        ) -> Self {
            self.error = input;
            self
        }
        /// <p>A timestamp that indicates when the route was last updated. </p>
        pub fn last_updated_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>A timestamp that indicates when the route was last updated. </p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// <p>The timestamp of when the route is created. </p>
        pub fn created_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>The timestamp of when the route is created. </p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRouteOutput`](crate::output::GetRouteOutput)
        pub fn build(self) -> crate::output::GetRouteOutput {
            crate::output::GetRouteOutput {
                route_id: self.route_id,
                arn: self.arn,
                owner_account_id: self.owner_account_id,
                created_by_account_id: self.created_by_account_id,
                route_type: self.route_type,
                service_id: self.service_id,
                application_id: self.application_id,
                environment_id: self.environment_id,
                source_path: self.source_path,
                methods: self.methods,
                include_child_paths: self.include_child_paths,
                path_resource_to_id: self.path_resource_to_id,
                state: self.state,
                tags: self.tags,
                error: self.error,
                last_updated_time: self.last_updated_time,
                created_time: self.created_time,
            }
        }
    }
}
impl GetRouteOutput {
    /// Creates a new builder-style object to manufacture [`GetRouteOutput`](crate::output::GetRouteOutput)
    pub fn builder() -> crate::output::get_route_output::Builder {
        crate::output::get_route_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetResourcePolicyOutput {
    /// <p>A JSON-formatted string for an Amazon Web Services resource-based policy. </p>
    pub policy: std::option::Option<std::string::String>,
}
impl GetResourcePolicyOutput {
    /// <p>A JSON-formatted string for an Amazon Web Services resource-based policy. </p>
    pub fn policy(&self) -> std::option::Option<&str> {
        self.policy.as_deref()
    }
}
impl std::fmt::Debug for GetResourcePolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetResourcePolicyOutput");
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}
/// See [`GetResourcePolicyOutput`](crate::output::GetResourcePolicyOutput)
pub mod get_resource_policy_output {
    /// A builder for [`GetResourcePolicyOutput`](crate::output::GetResourcePolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A JSON-formatted string for an Amazon Web Services resource-based policy. </p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>A JSON-formatted string for an Amazon Web Services resource-based policy. </p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`GetResourcePolicyOutput`](crate::output::GetResourcePolicyOutput)
        pub fn build(self) -> crate::output::GetResourcePolicyOutput {
            crate::output::GetResourcePolicyOutput {
                policy: self.policy,
            }
        }
    }
}
impl GetResourcePolicyOutput {
    /// Creates a new builder-style object to manufacture [`GetResourcePolicyOutput`](crate::output::GetResourcePolicyOutput)
    pub fn builder() -> crate::output::get_resource_policy_output::Builder {
        crate::output::get_resource_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEnvironmentOutput {
    /// <p>The name of the environment.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the environment.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The description of the environment. </p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the environment. </p>
    pub environment_id: std::option::Option<std::string::String>,
    /// <p>The network fabric type of the environment. </p>
    pub network_fabric_type: std::option::Option<crate::model::NetworkFabricType>,
    /// <p>The Amazon Web Services account ID of the environment owner.</p>
    pub owner_account_id: std::option::Option<std::string::String>,
    /// <p>The ID of the transit gateway set up by the environment. </p>
    pub transit_gateway_id: std::option::Option<std::string::String>,
    /// <p>The current state of the environment. </p>
    pub state: std::option::Option<crate::model::EnvironmentState>,
    /// <p>The tags to assign to the environment. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair. </p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Any error associated with the environment resource. </p>
    pub error: std::option::Option<crate::model::ErrorResponse>,
    /// <p>A timestamp that indicates when the environment was last updated. </p>
    pub last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A timestamp that indicates when the environment is created. </p>
    pub created_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl GetEnvironmentOutput {
    /// <p>The name of the environment.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the environment.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The description of the environment. </p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The unique identifier of the environment. </p>
    pub fn environment_id(&self) -> std::option::Option<&str> {
        self.environment_id.as_deref()
    }
    /// <p>The network fabric type of the environment. </p>
    pub fn network_fabric_type(&self) -> std::option::Option<&crate::model::NetworkFabricType> {
        self.network_fabric_type.as_ref()
    }
    /// <p>The Amazon Web Services account ID of the environment owner.</p>
    pub fn owner_account_id(&self) -> std::option::Option<&str> {
        self.owner_account_id.as_deref()
    }
    /// <p>The ID of the transit gateway set up by the environment. </p>
    pub fn transit_gateway_id(&self) -> std::option::Option<&str> {
        self.transit_gateway_id.as_deref()
    }
    /// <p>The current state of the environment. </p>
    pub fn state(&self) -> std::option::Option<&crate::model::EnvironmentState> {
        self.state.as_ref()
    }
    /// <p>The tags to assign to the environment. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair. </p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>Any error associated with the environment resource. </p>
    pub fn error(&self) -> std::option::Option<&crate::model::ErrorResponse> {
        self.error.as_ref()
    }
    /// <p>A timestamp that indicates when the environment was last updated. </p>
    pub fn last_updated_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_time.as_ref()
    }
    /// <p>A timestamp that indicates when the environment is created. </p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_time.as_ref()
    }
}
impl std::fmt::Debug for GetEnvironmentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEnvironmentOutput");
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("description", &self.description);
        formatter.field("environment_id", &self.environment_id);
        formatter.field("network_fabric_type", &self.network_fabric_type);
        formatter.field("owner_account_id", &self.owner_account_id);
        formatter.field("transit_gateway_id", &self.transit_gateway_id);
        formatter.field("state", &self.state);
        formatter.field("tags", &"*** Sensitive Data Redacted ***");
        formatter.field("error", &self.error);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.field("created_time", &self.created_time);
        formatter.finish()
    }
}
/// See [`GetEnvironmentOutput`](crate::output::GetEnvironmentOutput)
pub mod get_environment_output {
    /// A builder for [`GetEnvironmentOutput`](crate::output::GetEnvironmentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) environment_id: std::option::Option<std::string::String>,
        pub(crate) network_fabric_type: std::option::Option<crate::model::NetworkFabricType>,
        pub(crate) owner_account_id: std::option::Option<std::string::String>,
        pub(crate) transit_gateway_id: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::EnvironmentState>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) error: std::option::Option<crate::model::ErrorResponse>,
        pub(crate) last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the environment.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the environment.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the environment.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the environment.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The description of the environment. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the environment. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The unique identifier of the environment. </p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the environment. </p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_id = input;
            self
        }
        /// <p>The network fabric type of the environment. </p>
        pub fn network_fabric_type(mut self, input: crate::model::NetworkFabricType) -> Self {
            self.network_fabric_type = Some(input);
            self
        }
        /// <p>The network fabric type of the environment. </p>
        pub fn set_network_fabric_type(
            mut self,
            input: std::option::Option<crate::model::NetworkFabricType>,
        ) -> Self {
            self.network_fabric_type = input;
            self
        }
        /// <p>The Amazon Web Services account ID of the environment owner.</p>
        pub fn owner_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the environment owner.</p>
        pub fn set_owner_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owner_account_id = input;
            self
        }
        /// <p>The ID of the transit gateway set up by the environment. </p>
        pub fn transit_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.transit_gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of the transit gateway set up by the environment. </p>
        pub fn set_transit_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.transit_gateway_id = input;
            self
        }
        /// <p>The current state of the environment. </p>
        pub fn state(mut self, input: crate::model::EnvironmentState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of the environment. </p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::EnvironmentState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to assign to the environment. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags to assign to the environment. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Any error associated with the environment resource. </p>
        pub fn error(mut self, input: crate::model::ErrorResponse) -> Self {
            self.error = Some(input);
            self
        }
        /// <p>Any error associated with the environment resource. </p>
        pub fn set_error(
            mut self,
            input: std::option::Option<crate::model::ErrorResponse>,
        ) -> Self {
            self.error = input;
            self
        }
        /// <p>A timestamp that indicates when the environment was last updated. </p>
        pub fn last_updated_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>A timestamp that indicates when the environment was last updated. </p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// <p>A timestamp that indicates when the environment is created. </p>
        pub fn created_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>A timestamp that indicates when the environment is created. </p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEnvironmentOutput`](crate::output::GetEnvironmentOutput)
        pub fn build(self) -> crate::output::GetEnvironmentOutput {
            crate::output::GetEnvironmentOutput {
                name: self.name,
                arn: self.arn,
                description: self.description,
                environment_id: self.environment_id,
                network_fabric_type: self.network_fabric_type,
                owner_account_id: self.owner_account_id,
                transit_gateway_id: self.transit_gateway_id,
                state: self.state,
                tags: self.tags,
                error: self.error,
                last_updated_time: self.last_updated_time,
                created_time: self.created_time,
            }
        }
    }
}
impl GetEnvironmentOutput {
    /// Creates a new builder-style object to manufacture [`GetEnvironmentOutput`](crate::output::GetEnvironmentOutput)
    pub fn builder() -> crate::output::get_environment_output::Builder {
        crate::output::get_environment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetApplicationOutput {
    /// <p>The name of the application.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the application.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services account ID of the application owner (which is always the same as the environment owner account ID).</p>
    pub owner_account_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services account ID of the application creator. </p>
    pub created_by_account_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the application.</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the environment.</p>
    pub environment_id: std::option::Option<std::string::String>,
    /// <p>The ID of the virtual private cloud (VPC). </p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>The proxy type of the proxy created within the application. </p>
    pub proxy_type: std::option::Option<crate::model::ProxyType>,
    /// <p>The endpoint URL of the API Gateway proxy. </p>
    pub api_gateway_proxy: std::option::Option<crate::model::ApiGatewayProxyConfig>,
    /// <p>The current state of the application. </p>
    pub state: std::option::Option<crate::model::ApplicationState>,
    /// <p>The tags assigned to the application. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair. </p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Any error associated with the application resource. </p>
    pub error: std::option::Option<crate::model::ErrorResponse>,
    /// <p>A timestamp that indicates when the application was last updated. </p>
    pub last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A timestamp that indicates when the application is created. </p>
    pub created_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl GetApplicationOutput {
    /// <p>The name of the application.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the application.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The Amazon Web Services account ID of the application owner (which is always the same as the environment owner account ID).</p>
    pub fn owner_account_id(&self) -> std::option::Option<&str> {
        self.owner_account_id.as_deref()
    }
    /// <p>The Amazon Web Services account ID of the application creator. </p>
    pub fn created_by_account_id(&self) -> std::option::Option<&str> {
        self.created_by_account_id.as_deref()
    }
    /// <p>The unique identifier of the application.</p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
    /// <p>The unique identifier of the environment.</p>
    pub fn environment_id(&self) -> std::option::Option<&str> {
        self.environment_id.as_deref()
    }
    /// <p>The ID of the virtual private cloud (VPC). </p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
    /// <p>The proxy type of the proxy created within the application. </p>
    pub fn proxy_type(&self) -> std::option::Option<&crate::model::ProxyType> {
        self.proxy_type.as_ref()
    }
    /// <p>The endpoint URL of the API Gateway proxy. </p>
    pub fn api_gateway_proxy(&self) -> std::option::Option<&crate::model::ApiGatewayProxyConfig> {
        self.api_gateway_proxy.as_ref()
    }
    /// <p>The current state of the application. </p>
    pub fn state(&self) -> std::option::Option<&crate::model::ApplicationState> {
        self.state.as_ref()
    }
    /// <p>The tags assigned to the application. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair. </p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>Any error associated with the application resource. </p>
    pub fn error(&self) -> std::option::Option<&crate::model::ErrorResponse> {
        self.error.as_ref()
    }
    /// <p>A timestamp that indicates when the application was last updated. </p>
    pub fn last_updated_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_time.as_ref()
    }
    /// <p>A timestamp that indicates when the application is created. </p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_time.as_ref()
    }
}
impl std::fmt::Debug for GetApplicationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetApplicationOutput");
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("owner_account_id", &self.owner_account_id);
        formatter.field("created_by_account_id", &self.created_by_account_id);
        formatter.field("application_id", &self.application_id);
        formatter.field("environment_id", &self.environment_id);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("proxy_type", &self.proxy_type);
        formatter.field("api_gateway_proxy", &self.api_gateway_proxy);
        formatter.field("state", &self.state);
        formatter.field("tags", &"*** Sensitive Data Redacted ***");
        formatter.field("error", &self.error);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.field("created_time", &self.created_time);
        formatter.finish()
    }
}
/// See [`GetApplicationOutput`](crate::output::GetApplicationOutput)
pub mod get_application_output {
    /// A builder for [`GetApplicationOutput`](crate::output::GetApplicationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) owner_account_id: std::option::Option<std::string::String>,
        pub(crate) created_by_account_id: std::option::Option<std::string::String>,
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) environment_id: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) proxy_type: std::option::Option<crate::model::ProxyType>,
        pub(crate) api_gateway_proxy: std::option::Option<crate::model::ApiGatewayProxyConfig>,
        pub(crate) state: std::option::Option<crate::model::ApplicationState>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) error: std::option::Option<crate::model::ErrorResponse>,
        pub(crate) last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the application.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the application.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The Amazon Web Services account ID of the application owner (which is always the same as the environment owner account ID).</p>
        pub fn owner_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the application owner (which is always the same as the environment owner account ID).</p>
        pub fn set_owner_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owner_account_id = input;
            self
        }
        /// <p>The Amazon Web Services account ID of the application creator. </p>
        pub fn created_by_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_by_account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the application creator. </p>
        pub fn set_created_by_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.created_by_account_id = input;
            self
        }
        /// <p>The unique identifier of the application.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the application.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The unique identifier of the environment.</p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the environment.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_id = input;
            self
        }
        /// <p>The ID of the virtual private cloud (VPC). </p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The ID of the virtual private cloud (VPC). </p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// <p>The proxy type of the proxy created within the application. </p>
        pub fn proxy_type(mut self, input: crate::model::ProxyType) -> Self {
            self.proxy_type = Some(input);
            self
        }
        /// <p>The proxy type of the proxy created within the application. </p>
        pub fn set_proxy_type(
            mut self,
            input: std::option::Option<crate::model::ProxyType>,
        ) -> Self {
            self.proxy_type = input;
            self
        }
        /// <p>The endpoint URL of the API Gateway proxy. </p>
        pub fn api_gateway_proxy(mut self, input: crate::model::ApiGatewayProxyConfig) -> Self {
            self.api_gateway_proxy = Some(input);
            self
        }
        /// <p>The endpoint URL of the API Gateway proxy. </p>
        pub fn set_api_gateway_proxy(
            mut self,
            input: std::option::Option<crate::model::ApiGatewayProxyConfig>,
        ) -> Self {
            self.api_gateway_proxy = input;
            self
        }
        /// <p>The current state of the application. </p>
        pub fn state(mut self, input: crate::model::ApplicationState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of the application. </p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::ApplicationState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags assigned to the application. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags assigned to the application. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Any error associated with the application resource. </p>
        pub fn error(mut self, input: crate::model::ErrorResponse) -> Self {
            self.error = Some(input);
            self
        }
        /// <p>Any error associated with the application resource. </p>
        pub fn set_error(
            mut self,
            input: std::option::Option<crate::model::ErrorResponse>,
        ) -> Self {
            self.error = input;
            self
        }
        /// <p>A timestamp that indicates when the application was last updated. </p>
        pub fn last_updated_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>A timestamp that indicates when the application was last updated. </p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// <p>A timestamp that indicates when the application is created. </p>
        pub fn created_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>A timestamp that indicates when the application is created. </p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// Consumes the builder and constructs a [`GetApplicationOutput`](crate::output::GetApplicationOutput)
        pub fn build(self) -> crate::output::GetApplicationOutput {
            crate::output::GetApplicationOutput {
                name: self.name,
                arn: self.arn,
                owner_account_id: self.owner_account_id,
                created_by_account_id: self.created_by_account_id,
                application_id: self.application_id,
                environment_id: self.environment_id,
                vpc_id: self.vpc_id,
                proxy_type: self.proxy_type,
                api_gateway_proxy: self.api_gateway_proxy,
                state: self.state,
                tags: self.tags,
                error: self.error,
                last_updated_time: self.last_updated_time,
                created_time: self.created_time,
            }
        }
    }
}
impl GetApplicationOutput {
    /// Creates a new builder-style object to manufacture [`GetApplicationOutput`](crate::output::GetApplicationOutput)
    pub fn builder() -> crate::output::get_application_output::Builder {
        crate::output::get_application_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteServiceOutput {
    /// <p>The unique identifier of the service.</p>
    pub service_id: std::option::Option<std::string::String>,
    /// <p>The name of the service.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the service.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the environment.</p>
    pub environment_id: std::option::Option<std::string::String>,
    /// <p>The ID of the application that the service is in.</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The current state of the service. </p>
    pub state: std::option::Option<crate::model::ServiceState>,
    /// <p>A timestamp that indicates when the service was last updated. </p>
    pub last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl DeleteServiceOutput {
    /// <p>The unique identifier of the service.</p>
    pub fn service_id(&self) -> std::option::Option<&str> {
        self.service_id.as_deref()
    }
    /// <p>The name of the service.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the service.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The unique identifier of the environment.</p>
    pub fn environment_id(&self) -> std::option::Option<&str> {
        self.environment_id.as_deref()
    }
    /// <p>The ID of the application that the service is in.</p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
    /// <p>The current state of the service. </p>
    pub fn state(&self) -> std::option::Option<&crate::model::ServiceState> {
        self.state.as_ref()
    }
    /// <p>A timestamp that indicates when the service was last updated. </p>
    pub fn last_updated_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_time.as_ref()
    }
}
impl std::fmt::Debug for DeleteServiceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteServiceOutput");
        formatter.field("service_id", &self.service_id);
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("environment_id", &self.environment_id);
        formatter.field("application_id", &self.application_id);
        formatter.field("state", &self.state);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.finish()
    }
}
/// See [`DeleteServiceOutput`](crate::output::DeleteServiceOutput)
pub mod delete_service_output {
    /// A builder for [`DeleteServiceOutput`](crate::output::DeleteServiceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) environment_id: std::option::Option<std::string::String>,
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::ServiceState>,
        pub(crate) last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The unique identifier of the service.</p>
        pub fn service_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the service.</p>
        pub fn set_service_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_id = input;
            self
        }
        /// <p>The name of the service.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the service.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the service.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the service.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The unique identifier of the environment.</p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the environment.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_id = input;
            self
        }
        /// <p>The ID of the application that the service is in.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The ID of the application that the service is in.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The current state of the service. </p>
        pub fn state(mut self, input: crate::model::ServiceState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of the service. </p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::ServiceState>) -> Self {
            self.state = input;
            self
        }
        /// <p>A timestamp that indicates when the service was last updated. </p>
        pub fn last_updated_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>A timestamp that indicates when the service was last updated. </p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteServiceOutput`](crate::output::DeleteServiceOutput)
        pub fn build(self) -> crate::output::DeleteServiceOutput {
            crate::output::DeleteServiceOutput {
                service_id: self.service_id,
                name: self.name,
                arn: self.arn,
                environment_id: self.environment_id,
                application_id: self.application_id,
                state: self.state,
                last_updated_time: self.last_updated_time,
            }
        }
    }
}
impl DeleteServiceOutput {
    /// Creates a new builder-style object to manufacture [`DeleteServiceOutput`](crate::output::DeleteServiceOutput)
    pub fn builder() -> crate::output::delete_service_output::Builder {
        crate::output::delete_service_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRouteOutput {
    /// <p>The ID of the route to delete.</p>
    pub route_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the route.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The ID of the service that the route belongs to.</p>
    pub service_id: std::option::Option<std::string::String>,
    /// <p>The ID of the application that the route belongs to.</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The current state of the route. </p>
    pub state: std::option::Option<crate::model::RouteState>,
    /// <p>A timestamp that indicates when the route was last updated. </p>
    pub last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl DeleteRouteOutput {
    /// <p>The ID of the route to delete.</p>
    pub fn route_id(&self) -> std::option::Option<&str> {
        self.route_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the route.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The ID of the service that the route belongs to.</p>
    pub fn service_id(&self) -> std::option::Option<&str> {
        self.service_id.as_deref()
    }
    /// <p>The ID of the application that the route belongs to.</p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
    /// <p>The current state of the route. </p>
    pub fn state(&self) -> std::option::Option<&crate::model::RouteState> {
        self.state.as_ref()
    }
    /// <p>A timestamp that indicates when the route was last updated. </p>
    pub fn last_updated_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_time.as_ref()
    }
}
impl std::fmt::Debug for DeleteRouteOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRouteOutput");
        formatter.field("route_id", &self.route_id);
        formatter.field("arn", &self.arn);
        formatter.field("service_id", &self.service_id);
        formatter.field("application_id", &self.application_id);
        formatter.field("state", &self.state);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.finish()
    }
}
/// See [`DeleteRouteOutput`](crate::output::DeleteRouteOutput)
pub mod delete_route_output {
    /// A builder for [`DeleteRouteOutput`](crate::output::DeleteRouteOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) route_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) service_id: std::option::Option<std::string::String>,
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::RouteState>,
        pub(crate) last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The ID of the route to delete.</p>
        pub fn route_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_id = Some(input.into());
            self
        }
        /// <p>The ID of the route to delete.</p>
        pub fn set_route_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.route_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the route.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the route.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The ID of the service that the route belongs to.</p>
        pub fn service_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_id = Some(input.into());
            self
        }
        /// <p>The ID of the service that the route belongs to.</p>
        pub fn set_service_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_id = input;
            self
        }
        /// <p>The ID of the application that the route belongs to.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The ID of the application that the route belongs to.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The current state of the route. </p>
        pub fn state(mut self, input: crate::model::RouteState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of the route. </p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::RouteState>) -> Self {
            self.state = input;
            self
        }
        /// <p>A timestamp that indicates when the route was last updated. </p>
        pub fn last_updated_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>A timestamp that indicates when the route was last updated. </p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRouteOutput`](crate::output::DeleteRouteOutput)
        pub fn build(self) -> crate::output::DeleteRouteOutput {
            crate::output::DeleteRouteOutput {
                route_id: self.route_id,
                arn: self.arn,
                service_id: self.service_id,
                application_id: self.application_id,
                state: self.state,
                last_updated_time: self.last_updated_time,
            }
        }
    }
}
impl DeleteRouteOutput {
    /// Creates a new builder-style object to manufacture [`DeleteRouteOutput`](crate::output::DeleteRouteOutput)
    pub fn builder() -> crate::output::delete_route_output::Builder {
        crate::output::delete_route_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteResourcePolicyOutput {}
impl std::fmt::Debug for DeleteResourcePolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteResourcePolicyOutput");
        formatter.finish()
    }
}
/// See [`DeleteResourcePolicyOutput`](crate::output::DeleteResourcePolicyOutput)
pub mod delete_resource_policy_output {
    /// A builder for [`DeleteResourcePolicyOutput`](crate::output::DeleteResourcePolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteResourcePolicyOutput`](crate::output::DeleteResourcePolicyOutput)
        pub fn build(self) -> crate::output::DeleteResourcePolicyOutput {
            crate::output::DeleteResourcePolicyOutput {}
        }
    }
}
impl DeleteResourcePolicyOutput {
    /// Creates a new builder-style object to manufacture [`DeleteResourcePolicyOutput`](crate::output::DeleteResourcePolicyOutput)
    pub fn builder() -> crate::output::delete_resource_policy_output::Builder {
        crate::output::delete_resource_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteEnvironmentOutput {
    /// <p>The name of the environment.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the environment.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the environment.</p>
    pub environment_id: std::option::Option<std::string::String>,
    /// <p>The current state of the environment. </p>
    pub state: std::option::Option<crate::model::EnvironmentState>,
    /// <p>A timestamp that indicates when the environment was last updated. </p>
    pub last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl DeleteEnvironmentOutput {
    /// <p>The name of the environment.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the environment.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The unique identifier of the environment.</p>
    pub fn environment_id(&self) -> std::option::Option<&str> {
        self.environment_id.as_deref()
    }
    /// <p>The current state of the environment. </p>
    pub fn state(&self) -> std::option::Option<&crate::model::EnvironmentState> {
        self.state.as_ref()
    }
    /// <p>A timestamp that indicates when the environment was last updated. </p>
    pub fn last_updated_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_time.as_ref()
    }
}
impl std::fmt::Debug for DeleteEnvironmentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteEnvironmentOutput");
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("environment_id", &self.environment_id);
        formatter.field("state", &self.state);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.finish()
    }
}
/// See [`DeleteEnvironmentOutput`](crate::output::DeleteEnvironmentOutput)
pub mod delete_environment_output {
    /// A builder for [`DeleteEnvironmentOutput`](crate::output::DeleteEnvironmentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) environment_id: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::EnvironmentState>,
        pub(crate) last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the environment.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the environment.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the environment.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the environment.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The unique identifier of the environment.</p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the environment.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_id = input;
            self
        }
        /// <p>The current state of the environment. </p>
        pub fn state(mut self, input: crate::model::EnvironmentState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of the environment. </p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::EnvironmentState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>A timestamp that indicates when the environment was last updated. </p>
        pub fn last_updated_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>A timestamp that indicates when the environment was last updated. </p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteEnvironmentOutput`](crate::output::DeleteEnvironmentOutput)
        pub fn build(self) -> crate::output::DeleteEnvironmentOutput {
            crate::output::DeleteEnvironmentOutput {
                name: self.name,
                arn: self.arn,
                environment_id: self.environment_id,
                state: self.state,
                last_updated_time: self.last_updated_time,
            }
        }
    }
}
impl DeleteEnvironmentOutput {
    /// Creates a new builder-style object to manufacture [`DeleteEnvironmentOutput`](crate::output::DeleteEnvironmentOutput)
    pub fn builder() -> crate::output::delete_environment_output::Builder {
        crate::output::delete_environment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteApplicationOutput {
    /// <p>The name of the application.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the application.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The ID of the application.</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the application’s environment.</p>
    pub environment_id: std::option::Option<std::string::String>,
    /// <p>The current state of the application. </p>
    pub state: std::option::Option<crate::model::ApplicationState>,
    /// <p>A timestamp that indicates when the environment was last updated. </p>
    pub last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl DeleteApplicationOutput {
    /// <p>The name of the application.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the application.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The ID of the application.</p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
    /// <p>The unique identifier of the application’s environment.</p>
    pub fn environment_id(&self) -> std::option::Option<&str> {
        self.environment_id.as_deref()
    }
    /// <p>The current state of the application. </p>
    pub fn state(&self) -> std::option::Option<&crate::model::ApplicationState> {
        self.state.as_ref()
    }
    /// <p>A timestamp that indicates when the environment was last updated. </p>
    pub fn last_updated_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_time.as_ref()
    }
}
impl std::fmt::Debug for DeleteApplicationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteApplicationOutput");
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("application_id", &self.application_id);
        formatter.field("environment_id", &self.environment_id);
        formatter.field("state", &self.state);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.finish()
    }
}
/// See [`DeleteApplicationOutput`](crate::output::DeleteApplicationOutput)
pub mod delete_application_output {
    /// A builder for [`DeleteApplicationOutput`](crate::output::DeleteApplicationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) environment_id: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::ApplicationState>,
        pub(crate) last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the application.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the application.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The ID of the application.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The ID of the application.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The unique identifier of the application’s environment.</p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the application’s environment.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_id = input;
            self
        }
        /// <p>The current state of the application. </p>
        pub fn state(mut self, input: crate::model::ApplicationState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of the application. </p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::ApplicationState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>A timestamp that indicates when the environment was last updated. </p>
        pub fn last_updated_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>A timestamp that indicates when the environment was last updated. </p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteApplicationOutput`](crate::output::DeleteApplicationOutput)
        pub fn build(self) -> crate::output::DeleteApplicationOutput {
            crate::output::DeleteApplicationOutput {
                name: self.name,
                arn: self.arn,
                application_id: self.application_id,
                environment_id: self.environment_id,
                state: self.state,
                last_updated_time: self.last_updated_time,
            }
        }
    }
}
impl DeleteApplicationOutput {
    /// Creates a new builder-style object to manufacture [`DeleteApplicationOutput`](crate::output::DeleteApplicationOutput)
    pub fn builder() -> crate::output::delete_application_output::Builder {
        crate::output::delete_application_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateServiceOutput {
    /// <p>The unique identifier of the service.</p>
    pub service_id: std::option::Option<std::string::String>,
    /// <p>The name of the service.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the service.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services account ID of the service owner.</p>
    pub owner_account_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services account ID of the service creator.</p>
    pub created_by_account_id: std::option::Option<std::string::String>,
    /// <p>The description of the created service.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the environment.</p>
    pub environment_id: std::option::Option<std::string::String>,
    /// <p>The ID of the application that the created service belongs to. </p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The ID of the VPC. </p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>The endpoint type of the service.</p>
    pub endpoint_type: std::option::Option<crate::model::ServiceEndpointType>,
    /// <p>The configuration for the URL endpoint type. </p>
    pub url_endpoint: std::option::Option<crate::model::UrlEndpointInput>,
    /// <p>The configuration for the Lambda endpoint type.</p>
    pub lambda_endpoint: std::option::Option<crate::model::LambdaEndpointInput>,
    /// <p>The current state of the service. </p>
    pub state: std::option::Option<crate::model::ServiceState>,
    /// <p>The tags assigned to the created service. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair.. </p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A timestamp that indicates when the service was last updated. </p>
    pub last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A timestamp that indicates when the service is created.</p>
    pub created_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl CreateServiceOutput {
    /// <p>The unique identifier of the service.</p>
    pub fn service_id(&self) -> std::option::Option<&str> {
        self.service_id.as_deref()
    }
    /// <p>The name of the service.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the service.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The Amazon Web Services account ID of the service owner.</p>
    pub fn owner_account_id(&self) -> std::option::Option<&str> {
        self.owner_account_id.as_deref()
    }
    /// <p>The Amazon Web Services account ID of the service creator.</p>
    pub fn created_by_account_id(&self) -> std::option::Option<&str> {
        self.created_by_account_id.as_deref()
    }
    /// <p>The description of the created service.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The unique identifier of the environment.</p>
    pub fn environment_id(&self) -> std::option::Option<&str> {
        self.environment_id.as_deref()
    }
    /// <p>The ID of the application that the created service belongs to. </p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
    /// <p>The ID of the VPC. </p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
    /// <p>The endpoint type of the service.</p>
    pub fn endpoint_type(&self) -> std::option::Option<&crate::model::ServiceEndpointType> {
        self.endpoint_type.as_ref()
    }
    /// <p>The configuration for the URL endpoint type. </p>
    pub fn url_endpoint(&self) -> std::option::Option<&crate::model::UrlEndpointInput> {
        self.url_endpoint.as_ref()
    }
    /// <p>The configuration for the Lambda endpoint type.</p>
    pub fn lambda_endpoint(&self) -> std::option::Option<&crate::model::LambdaEndpointInput> {
        self.lambda_endpoint.as_ref()
    }
    /// <p>The current state of the service. </p>
    pub fn state(&self) -> std::option::Option<&crate::model::ServiceState> {
        self.state.as_ref()
    }
    /// <p>The tags assigned to the created service. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair.. </p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>A timestamp that indicates when the service was last updated. </p>
    pub fn last_updated_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_time.as_ref()
    }
    /// <p>A timestamp that indicates when the service is created.</p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_time.as_ref()
    }
}
impl std::fmt::Debug for CreateServiceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateServiceOutput");
        formatter.field("service_id", &self.service_id);
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("owner_account_id", &self.owner_account_id);
        formatter.field("created_by_account_id", &self.created_by_account_id);
        formatter.field("description", &self.description);
        formatter.field("environment_id", &self.environment_id);
        formatter.field("application_id", &self.application_id);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("endpoint_type", &self.endpoint_type);
        formatter.field("url_endpoint", &self.url_endpoint);
        formatter.field("lambda_endpoint", &self.lambda_endpoint);
        formatter.field("state", &self.state);
        formatter.field("tags", &"*** Sensitive Data Redacted ***");
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.field("created_time", &self.created_time);
        formatter.finish()
    }
}
/// See [`CreateServiceOutput`](crate::output::CreateServiceOutput)
pub mod create_service_output {
    /// A builder for [`CreateServiceOutput`](crate::output::CreateServiceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) owner_account_id: std::option::Option<std::string::String>,
        pub(crate) created_by_account_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) environment_id: std::option::Option<std::string::String>,
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) endpoint_type: std::option::Option<crate::model::ServiceEndpointType>,
        pub(crate) url_endpoint: std::option::Option<crate::model::UrlEndpointInput>,
        pub(crate) lambda_endpoint: std::option::Option<crate::model::LambdaEndpointInput>,
        pub(crate) state: std::option::Option<crate::model::ServiceState>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The unique identifier of the service.</p>
        pub fn service_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the service.</p>
        pub fn set_service_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_id = input;
            self
        }
        /// <p>The name of the service.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the service.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the service.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the service.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The Amazon Web Services account ID of the service owner.</p>
        pub fn owner_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the service owner.</p>
        pub fn set_owner_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owner_account_id = input;
            self
        }
        /// <p>The Amazon Web Services account ID of the service creator.</p>
        pub fn created_by_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_by_account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the service creator.</p>
        pub fn set_created_by_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.created_by_account_id = input;
            self
        }
        /// <p>The description of the created service.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the created service.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The unique identifier of the environment.</p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the environment.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_id = input;
            self
        }
        /// <p>The ID of the application that the created service belongs to. </p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The ID of the application that the created service belongs to. </p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The ID of the VPC. </p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The ID of the VPC. </p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// <p>The endpoint type of the service.</p>
        pub fn endpoint_type(mut self, input: crate::model::ServiceEndpointType) -> Self {
            self.endpoint_type = Some(input);
            self
        }
        /// <p>The endpoint type of the service.</p>
        pub fn set_endpoint_type(
            mut self,
            input: std::option::Option<crate::model::ServiceEndpointType>,
        ) -> Self {
            self.endpoint_type = input;
            self
        }
        /// <p>The configuration for the URL endpoint type. </p>
        pub fn url_endpoint(mut self, input: crate::model::UrlEndpointInput) -> Self {
            self.url_endpoint = Some(input);
            self
        }
        /// <p>The configuration for the URL endpoint type. </p>
        pub fn set_url_endpoint(
            mut self,
            input: std::option::Option<crate::model::UrlEndpointInput>,
        ) -> Self {
            self.url_endpoint = input;
            self
        }
        /// <p>The configuration for the Lambda endpoint type.</p>
        pub fn lambda_endpoint(mut self, input: crate::model::LambdaEndpointInput) -> Self {
            self.lambda_endpoint = Some(input);
            self
        }
        /// <p>The configuration for the Lambda endpoint type.</p>
        pub fn set_lambda_endpoint(
            mut self,
            input: std::option::Option<crate::model::LambdaEndpointInput>,
        ) -> Self {
            self.lambda_endpoint = input;
            self
        }
        /// <p>The current state of the service. </p>
        pub fn state(mut self, input: crate::model::ServiceState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of the service. </p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::ServiceState>) -> Self {
            self.state = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags assigned to the created service. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair.. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags assigned to the created service. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair.. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>A timestamp that indicates when the service was last updated. </p>
        pub fn last_updated_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>A timestamp that indicates when the service was last updated. </p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// <p>A timestamp that indicates when the service is created.</p>
        pub fn created_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>A timestamp that indicates when the service is created.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateServiceOutput`](crate::output::CreateServiceOutput)
        pub fn build(self) -> crate::output::CreateServiceOutput {
            crate::output::CreateServiceOutput {
                service_id: self.service_id,
                name: self.name,
                arn: self.arn,
                owner_account_id: self.owner_account_id,
                created_by_account_id: self.created_by_account_id,
                description: self.description,
                environment_id: self.environment_id,
                application_id: self.application_id,
                vpc_id: self.vpc_id,
                endpoint_type: self.endpoint_type,
                url_endpoint: self.url_endpoint,
                lambda_endpoint: self.lambda_endpoint,
                state: self.state,
                tags: self.tags,
                last_updated_time: self.last_updated_time,
                created_time: self.created_time,
            }
        }
    }
}
impl CreateServiceOutput {
    /// Creates a new builder-style object to manufacture [`CreateServiceOutput`](crate::output::CreateServiceOutput)
    pub fn builder() -> crate::output::create_service_output::Builder {
        crate::output::create_service_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRouteOutput {
    /// <p>The unique identifier of the route.</p>
    pub route_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the route. The format for this ARN is <code>arn:aws:refactor-spaces:<i>region</i>:<i>account-id</i>:<i>resource-type/resource-id</i> </code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services account ID of the route owner.</p>
    pub owner_account_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services account ID of the route creator.</p>
    pub created_by_account_id: std::option::Option<std::string::String>,
    /// <p>The route type of the route.</p>
    pub route_type: std::option::Option<crate::model::RouteType>,
    /// <p>The ID of service in which the route is created. Traffic that matches this route is forwarded to this service.</p>
    pub service_id: std::option::Option<std::string::String>,
    /// <p>The ID of the application in which the route is created.</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>onfiguration for the URI path route type. </p>
    pub uri_path_route: std::option::Option<crate::model::UriPathRouteInput>,
    /// <p>The current state of the route. </p>
    pub state: std::option::Option<crate::model::RouteState>,
    /// <p>The tags assigned to the created route. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair. </p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A timestamp that indicates when the route was last updated. </p>
    pub last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A timestamp that indicates when the route is created.</p>
    pub created_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl CreateRouteOutput {
    /// <p>The unique identifier of the route.</p>
    pub fn route_id(&self) -> std::option::Option<&str> {
        self.route_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the route. The format for this ARN is <code>arn:aws:refactor-spaces:<i>region</i>:<i>account-id</i>:<i>resource-type/resource-id</i> </code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The Amazon Web Services account ID of the route owner.</p>
    pub fn owner_account_id(&self) -> std::option::Option<&str> {
        self.owner_account_id.as_deref()
    }
    /// <p>The Amazon Web Services account ID of the route creator.</p>
    pub fn created_by_account_id(&self) -> std::option::Option<&str> {
        self.created_by_account_id.as_deref()
    }
    /// <p>The route type of the route.</p>
    pub fn route_type(&self) -> std::option::Option<&crate::model::RouteType> {
        self.route_type.as_ref()
    }
    /// <p>The ID of service in which the route is created. Traffic that matches this route is forwarded to this service.</p>
    pub fn service_id(&self) -> std::option::Option<&str> {
        self.service_id.as_deref()
    }
    /// <p>The ID of the application in which the route is created.</p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
    /// <p>onfiguration for the URI path route type. </p>
    pub fn uri_path_route(&self) -> std::option::Option<&crate::model::UriPathRouteInput> {
        self.uri_path_route.as_ref()
    }
    /// <p>The current state of the route. </p>
    pub fn state(&self) -> std::option::Option<&crate::model::RouteState> {
        self.state.as_ref()
    }
    /// <p>The tags assigned to the created route. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair. </p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>A timestamp that indicates when the route was last updated. </p>
    pub fn last_updated_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_time.as_ref()
    }
    /// <p>A timestamp that indicates when the route is created.</p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_time.as_ref()
    }
}
impl std::fmt::Debug for CreateRouteOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRouteOutput");
        formatter.field("route_id", &self.route_id);
        formatter.field("arn", &self.arn);
        formatter.field("owner_account_id", &self.owner_account_id);
        formatter.field("created_by_account_id", &self.created_by_account_id);
        formatter.field("route_type", &self.route_type);
        formatter.field("service_id", &self.service_id);
        formatter.field("application_id", &self.application_id);
        formatter.field("uri_path_route", &self.uri_path_route);
        formatter.field("state", &self.state);
        formatter.field("tags", &"*** Sensitive Data Redacted ***");
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.field("created_time", &self.created_time);
        formatter.finish()
    }
}
/// See [`CreateRouteOutput`](crate::output::CreateRouteOutput)
pub mod create_route_output {
    /// A builder for [`CreateRouteOutput`](crate::output::CreateRouteOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) route_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) owner_account_id: std::option::Option<std::string::String>,
        pub(crate) created_by_account_id: std::option::Option<std::string::String>,
        pub(crate) route_type: std::option::Option<crate::model::RouteType>,
        pub(crate) service_id: std::option::Option<std::string::String>,
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) uri_path_route: std::option::Option<crate::model::UriPathRouteInput>,
        pub(crate) state: std::option::Option<crate::model::RouteState>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The unique identifier of the route.</p>
        pub fn route_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the route.</p>
        pub fn set_route_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.route_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the route. The format for this ARN is <code>arn:aws:refactor-spaces:<i>region</i>:<i>account-id</i>:<i>resource-type/resource-id</i> </code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the route. The format for this ARN is <code>arn:aws:refactor-spaces:<i>region</i>:<i>account-id</i>:<i>resource-type/resource-id</i> </code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The Amazon Web Services account ID of the route owner.</p>
        pub fn owner_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the route owner.</p>
        pub fn set_owner_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owner_account_id = input;
            self
        }
        /// <p>The Amazon Web Services account ID of the route creator.</p>
        pub fn created_by_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_by_account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the route creator.</p>
        pub fn set_created_by_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.created_by_account_id = input;
            self
        }
        /// <p>The route type of the route.</p>
        pub fn route_type(mut self, input: crate::model::RouteType) -> Self {
            self.route_type = Some(input);
            self
        }
        /// <p>The route type of the route.</p>
        pub fn set_route_type(
            mut self,
            input: std::option::Option<crate::model::RouteType>,
        ) -> Self {
            self.route_type = input;
            self
        }
        /// <p>The ID of service in which the route is created. Traffic that matches this route is forwarded to this service.</p>
        pub fn service_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_id = Some(input.into());
            self
        }
        /// <p>The ID of service in which the route is created. Traffic that matches this route is forwarded to this service.</p>
        pub fn set_service_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_id = input;
            self
        }
        /// <p>The ID of the application in which the route is created.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The ID of the application in which the route is created.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>onfiguration for the URI path route type. </p>
        pub fn uri_path_route(mut self, input: crate::model::UriPathRouteInput) -> Self {
            self.uri_path_route = Some(input);
            self
        }
        /// <p>onfiguration for the URI path route type. </p>
        pub fn set_uri_path_route(
            mut self,
            input: std::option::Option<crate::model::UriPathRouteInput>,
        ) -> Self {
            self.uri_path_route = input;
            self
        }
        /// <p>The current state of the route. </p>
        pub fn state(mut self, input: crate::model::RouteState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of the route. </p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::RouteState>) -> Self {
            self.state = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags assigned to the created route. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags assigned to the created route. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>A timestamp that indicates when the route was last updated. </p>
        pub fn last_updated_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>A timestamp that indicates when the route was last updated. </p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// <p>A timestamp that indicates when the route is created.</p>
        pub fn created_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>A timestamp that indicates when the route is created.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRouteOutput`](crate::output::CreateRouteOutput)
        pub fn build(self) -> crate::output::CreateRouteOutput {
            crate::output::CreateRouteOutput {
                route_id: self.route_id,
                arn: self.arn,
                owner_account_id: self.owner_account_id,
                created_by_account_id: self.created_by_account_id,
                route_type: self.route_type,
                service_id: self.service_id,
                application_id: self.application_id,
                uri_path_route: self.uri_path_route,
                state: self.state,
                tags: self.tags,
                last_updated_time: self.last_updated_time,
                created_time: self.created_time,
            }
        }
    }
}
impl CreateRouteOutput {
    /// Creates a new builder-style object to manufacture [`CreateRouteOutput`](crate::output::CreateRouteOutput)
    pub fn builder() -> crate::output::create_route_output::Builder {
        crate::output::create_route_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateEnvironmentOutput {
    /// <p>The name of the environment.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the environment.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>A description of the environment.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the environment.</p>
    pub environment_id: std::option::Option<std::string::String>,
    /// <p>The network fabric type of the environment.</p>
    pub network_fabric_type: std::option::Option<crate::model::NetworkFabricType>,
    /// <p>The Amazon Web Services account ID of environment owner.</p>
    pub owner_account_id: std::option::Option<std::string::String>,
    /// <p>The current state of the environment. </p>
    pub state: std::option::Option<crate::model::EnvironmentState>,
    /// <p>The tags assigned to the created environment. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair..</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A timestamp that indicates when the environment was last updated. </p>
    pub last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A timestamp that indicates when the environment is created.</p>
    pub created_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl CreateEnvironmentOutput {
    /// <p>The name of the environment.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the environment.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>A description of the environment.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The unique identifier of the environment.</p>
    pub fn environment_id(&self) -> std::option::Option<&str> {
        self.environment_id.as_deref()
    }
    /// <p>The network fabric type of the environment.</p>
    pub fn network_fabric_type(&self) -> std::option::Option<&crate::model::NetworkFabricType> {
        self.network_fabric_type.as_ref()
    }
    /// <p>The Amazon Web Services account ID of environment owner.</p>
    pub fn owner_account_id(&self) -> std::option::Option<&str> {
        self.owner_account_id.as_deref()
    }
    /// <p>The current state of the environment. </p>
    pub fn state(&self) -> std::option::Option<&crate::model::EnvironmentState> {
        self.state.as_ref()
    }
    /// <p>The tags assigned to the created environment. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair..</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>A timestamp that indicates when the environment was last updated. </p>
    pub fn last_updated_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_time.as_ref()
    }
    /// <p>A timestamp that indicates when the environment is created.</p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_time.as_ref()
    }
}
impl std::fmt::Debug for CreateEnvironmentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateEnvironmentOutput");
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("description", &self.description);
        formatter.field("environment_id", &self.environment_id);
        formatter.field("network_fabric_type", &self.network_fabric_type);
        formatter.field("owner_account_id", &self.owner_account_id);
        formatter.field("state", &self.state);
        formatter.field("tags", &"*** Sensitive Data Redacted ***");
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.field("created_time", &self.created_time);
        formatter.finish()
    }
}
/// See [`CreateEnvironmentOutput`](crate::output::CreateEnvironmentOutput)
pub mod create_environment_output {
    /// A builder for [`CreateEnvironmentOutput`](crate::output::CreateEnvironmentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) environment_id: std::option::Option<std::string::String>,
        pub(crate) network_fabric_type: std::option::Option<crate::model::NetworkFabricType>,
        pub(crate) owner_account_id: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::EnvironmentState>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the environment.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the environment.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the environment.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the environment.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>A description of the environment.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the environment.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The unique identifier of the environment.</p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the environment.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_id = input;
            self
        }
        /// <p>The network fabric type of the environment.</p>
        pub fn network_fabric_type(mut self, input: crate::model::NetworkFabricType) -> Self {
            self.network_fabric_type = Some(input);
            self
        }
        /// <p>The network fabric type of the environment.</p>
        pub fn set_network_fabric_type(
            mut self,
            input: std::option::Option<crate::model::NetworkFabricType>,
        ) -> Self {
            self.network_fabric_type = input;
            self
        }
        /// <p>The Amazon Web Services account ID of environment owner.</p>
        pub fn owner_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of environment owner.</p>
        pub fn set_owner_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owner_account_id = input;
            self
        }
        /// <p>The current state of the environment. </p>
        pub fn state(mut self, input: crate::model::EnvironmentState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of the environment. </p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::EnvironmentState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags assigned to the created environment. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair..</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags assigned to the created environment. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair..</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>A timestamp that indicates when the environment was last updated. </p>
        pub fn last_updated_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>A timestamp that indicates when the environment was last updated. </p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// <p>A timestamp that indicates when the environment is created.</p>
        pub fn created_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>A timestamp that indicates when the environment is created.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateEnvironmentOutput`](crate::output::CreateEnvironmentOutput)
        pub fn build(self) -> crate::output::CreateEnvironmentOutput {
            crate::output::CreateEnvironmentOutput {
                name: self.name,
                arn: self.arn,
                description: self.description,
                environment_id: self.environment_id,
                network_fabric_type: self.network_fabric_type,
                owner_account_id: self.owner_account_id,
                state: self.state,
                tags: self.tags,
                last_updated_time: self.last_updated_time,
                created_time: self.created_time,
            }
        }
    }
}
impl CreateEnvironmentOutput {
    /// Creates a new builder-style object to manufacture [`CreateEnvironmentOutput`](crate::output::CreateEnvironmentOutput)
    pub fn builder() -> crate::output::create_environment_output::Builder {
        crate::output::create_environment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateApplicationOutput {
    /// <p>The name of the application.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is <code>arn:aws:refactor-spaces:<i>region</i>:<i>account-id</i>:<i>resource-type/resource-id</i> </code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services account ID of the application owner (which is always the same as the environment owner account ID).</p>
    pub owner_account_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services account ID of application creator.</p>
    pub created_by_account_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the application.</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The ID of the environment in which the application is created.</p>
    pub environment_id: std::option::Option<std::string::String>,
    /// <p>The ID of the Amazon VPC. </p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>The proxy type of the proxy created within the application. </p>
    pub proxy_type: std::option::Option<crate::model::ProxyType>,
    /// <p>A wrapper object holding the API Gateway endpoint type and stage name for the proxy. </p>
    pub api_gateway_proxy: std::option::Option<crate::model::ApiGatewayProxyInput>,
    /// <p>The current state of the application. </p>
    pub state: std::option::Option<crate::model::ApplicationState>,
    /// <p>The tags assigned to the application. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair. </p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A timestamp that indicates when the application was last updated. </p>
    pub last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A timestamp that indicates when the application is created.</p>
    pub created_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl CreateApplicationOutput {
    /// <p>The name of the application.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is <code>arn:aws:refactor-spaces:<i>region</i>:<i>account-id</i>:<i>resource-type/resource-id</i> </code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The Amazon Web Services account ID of the application owner (which is always the same as the environment owner account ID).</p>
    pub fn owner_account_id(&self) -> std::option::Option<&str> {
        self.owner_account_id.as_deref()
    }
    /// <p>The Amazon Web Services account ID of application creator.</p>
    pub fn created_by_account_id(&self) -> std::option::Option<&str> {
        self.created_by_account_id.as_deref()
    }
    /// <p>The unique identifier of the application.</p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
    /// <p>The ID of the environment in which the application is created.</p>
    pub fn environment_id(&self) -> std::option::Option<&str> {
        self.environment_id.as_deref()
    }
    /// <p>The ID of the Amazon VPC. </p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
    /// <p>The proxy type of the proxy created within the application. </p>
    pub fn proxy_type(&self) -> std::option::Option<&crate::model::ProxyType> {
        self.proxy_type.as_ref()
    }
    /// <p>A wrapper object holding the API Gateway endpoint type and stage name for the proxy. </p>
    pub fn api_gateway_proxy(&self) -> std::option::Option<&crate::model::ApiGatewayProxyInput> {
        self.api_gateway_proxy.as_ref()
    }
    /// <p>The current state of the application. </p>
    pub fn state(&self) -> std::option::Option<&crate::model::ApplicationState> {
        self.state.as_ref()
    }
    /// <p>The tags assigned to the application. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair. </p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>A timestamp that indicates when the application was last updated. </p>
    pub fn last_updated_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_time.as_ref()
    }
    /// <p>A timestamp that indicates when the application is created.</p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_time.as_ref()
    }
}
impl std::fmt::Debug for CreateApplicationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateApplicationOutput");
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("owner_account_id", &self.owner_account_id);
        formatter.field("created_by_account_id", &self.created_by_account_id);
        formatter.field("application_id", &self.application_id);
        formatter.field("environment_id", &self.environment_id);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("proxy_type", &self.proxy_type);
        formatter.field("api_gateway_proxy", &self.api_gateway_proxy);
        formatter.field("state", &self.state);
        formatter.field("tags", &"*** Sensitive Data Redacted ***");
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.field("created_time", &self.created_time);
        formatter.finish()
    }
}
/// See [`CreateApplicationOutput`](crate::output::CreateApplicationOutput)
pub mod create_application_output {
    /// A builder for [`CreateApplicationOutput`](crate::output::CreateApplicationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) owner_account_id: std::option::Option<std::string::String>,
        pub(crate) created_by_account_id: std::option::Option<std::string::String>,
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) environment_id: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) proxy_type: std::option::Option<crate::model::ProxyType>,
        pub(crate) api_gateway_proxy: std::option::Option<crate::model::ApiGatewayProxyInput>,
        pub(crate) state: std::option::Option<crate::model::ApplicationState>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the application.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the application.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is <code>arn:aws:refactor-spaces:<i>region</i>:<i>account-id</i>:<i>resource-type/resource-id</i> </code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is <code>arn:aws:refactor-spaces:<i>region</i>:<i>account-id</i>:<i>resource-type/resource-id</i> </code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The Amazon Web Services account ID of the application owner (which is always the same as the environment owner account ID).</p>
        pub fn owner_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the application owner (which is always the same as the environment owner account ID).</p>
        pub fn set_owner_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owner_account_id = input;
            self
        }
        /// <p>The Amazon Web Services account ID of application creator.</p>
        pub fn created_by_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_by_account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of application creator.</p>
        pub fn set_created_by_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.created_by_account_id = input;
            self
        }
        /// <p>The unique identifier of the application.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the application.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The ID of the environment in which the application is created.</p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_id = Some(input.into());
            self
        }
        /// <p>The ID of the environment in which the application is created.</p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_id = input;
            self
        }
        /// <p>The ID of the Amazon VPC. </p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon VPC. </p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// <p>The proxy type of the proxy created within the application. </p>
        pub fn proxy_type(mut self, input: crate::model::ProxyType) -> Self {
            self.proxy_type = Some(input);
            self
        }
        /// <p>The proxy type of the proxy created within the application. </p>
        pub fn set_proxy_type(
            mut self,
            input: std::option::Option<crate::model::ProxyType>,
        ) -> Self {
            self.proxy_type = input;
            self
        }
        /// <p>A wrapper object holding the API Gateway endpoint type and stage name for the proxy. </p>
        pub fn api_gateway_proxy(mut self, input: crate::model::ApiGatewayProxyInput) -> Self {
            self.api_gateway_proxy = Some(input);
            self
        }
        /// <p>A wrapper object holding the API Gateway endpoint type and stage name for the proxy. </p>
        pub fn set_api_gateway_proxy(
            mut self,
            input: std::option::Option<crate::model::ApiGatewayProxyInput>,
        ) -> Self {
            self.api_gateway_proxy = input;
            self
        }
        /// <p>The current state of the application. </p>
        pub fn state(mut self, input: crate::model::ApplicationState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of the application. </p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::ApplicationState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags assigned to the application. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags assigned to the application. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>A timestamp that indicates when the application was last updated. </p>
        pub fn last_updated_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>A timestamp that indicates when the application was last updated. </p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// <p>A timestamp that indicates when the application is created.</p>
        pub fn created_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>A timestamp that indicates when the application is created.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateApplicationOutput`](crate::output::CreateApplicationOutput)
        pub fn build(self) -> crate::output::CreateApplicationOutput {
            crate::output::CreateApplicationOutput {
                name: self.name,
                arn: self.arn,
                owner_account_id: self.owner_account_id,
                created_by_account_id: self.created_by_account_id,
                application_id: self.application_id,
                environment_id: self.environment_id,
                vpc_id: self.vpc_id,
                proxy_type: self.proxy_type,
                api_gateway_proxy: self.api_gateway_proxy,
                state: self.state,
                tags: self.tags,
                last_updated_time: self.last_updated_time,
                created_time: self.created_time,
            }
        }
    }
}
impl CreateApplicationOutput {
    /// Creates a new builder-style object to manufacture [`CreateApplicationOutput`](crate::output::CreateApplicationOutput)
    pub fn builder() -> crate::output::create_application_output::Builder {
        crate::output::create_application_output::Builder::default()
    }
}
