// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>A summary for the service as a response to <code>ListServices</code>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceSummary {
    /// <p>The unique identifier of the service. </p>
    pub service_id: std::option::Option<std::string::String>,
    /// <p>The name of the service. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the service. </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services account ID of the service owner.</p>
    pub owner_account_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services account ID of the service creator. </p>
    pub created_by_account_id: std::option::Option<std::string::String>,
    /// <p>A description of the service. </p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the environment. </p>
    pub environment_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the application. </p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The ID of the virtual private cloud (VPC). </p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>The endpoint type of the service. </p>
    pub endpoint_type: std::option::Option<crate::model::ServiceEndpointType>,
    /// <p>The summary of the configuration for the URL endpoint type. </p>
    pub url_endpoint: std::option::Option<crate::model::UrlEndpointSummary>,
    /// <p>A summary of the configuration for the Lambda endpoint type. </p>
    pub lambda_endpoint: std::option::Option<crate::model::LambdaEndpointSummary>,
    /// <p>The current state of the service. </p>
    pub state: std::option::Option<crate::model::ServiceState>,
    /// <p>The tags assigned to the service. </p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Any error associated with the service resource. </p>
    pub error: std::option::Option<crate::model::ErrorResponse>,
    /// <p>A timestamp that indicates when the service was last updated. </p>
    pub last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A timestamp that indicates when the service is created. </p>
    pub created_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl ServiceSummary {
    /// <p>The unique identifier of the service. </p>
    pub fn service_id(&self) -> std::option::Option<&str> {
        self.service_id.as_deref()
    }
    /// <p>The name of the service. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the service. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The Amazon Web Services account ID of the service owner.</p>
    pub fn owner_account_id(&self) -> std::option::Option<&str> {
        self.owner_account_id.as_deref()
    }
    /// <p>The Amazon Web Services account ID of the service creator. </p>
    pub fn created_by_account_id(&self) -> std::option::Option<&str> {
        self.created_by_account_id.as_deref()
    }
    /// <p>A description of the service. </p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The unique identifier of the environment. </p>
    pub fn environment_id(&self) -> std::option::Option<&str> {
        self.environment_id.as_deref()
    }
    /// <p>The unique identifier of the application. </p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
    /// <p>The ID of the virtual private cloud (VPC). </p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
    /// <p>The endpoint type of the service. </p>
    pub fn endpoint_type(&self) -> std::option::Option<&crate::model::ServiceEndpointType> {
        self.endpoint_type.as_ref()
    }
    /// <p>The summary of the configuration for the URL endpoint type. </p>
    pub fn url_endpoint(&self) -> std::option::Option<&crate::model::UrlEndpointSummary> {
        self.url_endpoint.as_ref()
    }
    /// <p>A summary of the configuration for the Lambda endpoint type. </p>
    pub fn lambda_endpoint(&self) -> std::option::Option<&crate::model::LambdaEndpointSummary> {
        self.lambda_endpoint.as_ref()
    }
    /// <p>The current state of the service. </p>
    pub fn state(&self) -> std::option::Option<&crate::model::ServiceState> {
        self.state.as_ref()
    }
    /// <p>The tags assigned to the service. </p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>Any error associated with the service resource. </p>
    pub fn error(&self) -> std::option::Option<&crate::model::ErrorResponse> {
        self.error.as_ref()
    }
    /// <p>A timestamp that indicates when the service was last updated. </p>
    pub fn last_updated_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_time.as_ref()
    }
    /// <p>A timestamp that indicates when the service is created. </p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_time.as_ref()
    }
}
impl std::fmt::Debug for ServiceSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceSummary");
        formatter.field("service_id", &self.service_id);
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("owner_account_id", &self.owner_account_id);
        formatter.field("created_by_account_id", &self.created_by_account_id);
        formatter.field("description", &self.description);
        formatter.field("environment_id", &self.environment_id);
        formatter.field("application_id", &self.application_id);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("endpoint_type", &self.endpoint_type);
        formatter.field("url_endpoint", &self.url_endpoint);
        formatter.field("lambda_endpoint", &self.lambda_endpoint);
        formatter.field("state", &self.state);
        formatter.field("tags", &"*** Sensitive Data Redacted ***");
        formatter.field("error", &self.error);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.field("created_time", &self.created_time);
        formatter.finish()
    }
}
/// See [`ServiceSummary`](crate::model::ServiceSummary)
pub mod service_summary {
    /// A builder for [`ServiceSummary`](crate::model::ServiceSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) owner_account_id: std::option::Option<std::string::String>,
        pub(crate) created_by_account_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) environment_id: std::option::Option<std::string::String>,
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) endpoint_type: std::option::Option<crate::model::ServiceEndpointType>,
        pub(crate) url_endpoint: std::option::Option<crate::model::UrlEndpointSummary>,
        pub(crate) lambda_endpoint: std::option::Option<crate::model::LambdaEndpointSummary>,
        pub(crate) state: std::option::Option<crate::model::ServiceState>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) error: std::option::Option<crate::model::ErrorResponse>,
        pub(crate) last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The unique identifier of the service. </p>
        pub fn service_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the service. </p>
        pub fn set_service_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_id = input;
            self
        }
        /// <p>The name of the service. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the service. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the service. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the service. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The Amazon Web Services account ID of the service owner.</p>
        pub fn owner_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the service owner.</p>
        pub fn set_owner_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owner_account_id = input;
            self
        }
        /// <p>The Amazon Web Services account ID of the service creator. </p>
        pub fn created_by_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_by_account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the service creator. </p>
        pub fn set_created_by_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.created_by_account_id = input;
            self
        }
        /// <p>A description of the service. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the service. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The unique identifier of the environment. </p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the environment. </p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_id = input;
            self
        }
        /// <p>The unique identifier of the application. </p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the application. </p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The ID of the virtual private cloud (VPC). </p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The ID of the virtual private cloud (VPC). </p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// <p>The endpoint type of the service. </p>
        pub fn endpoint_type(mut self, input: crate::model::ServiceEndpointType) -> Self {
            self.endpoint_type = Some(input);
            self
        }
        /// <p>The endpoint type of the service. </p>
        pub fn set_endpoint_type(
            mut self,
            input: std::option::Option<crate::model::ServiceEndpointType>,
        ) -> Self {
            self.endpoint_type = input;
            self
        }
        /// <p>The summary of the configuration for the URL endpoint type. </p>
        pub fn url_endpoint(mut self, input: crate::model::UrlEndpointSummary) -> Self {
            self.url_endpoint = Some(input);
            self
        }
        /// <p>The summary of the configuration for the URL endpoint type. </p>
        pub fn set_url_endpoint(
            mut self,
            input: std::option::Option<crate::model::UrlEndpointSummary>,
        ) -> Self {
            self.url_endpoint = input;
            self
        }
        /// <p>A summary of the configuration for the Lambda endpoint type. </p>
        pub fn lambda_endpoint(mut self, input: crate::model::LambdaEndpointSummary) -> Self {
            self.lambda_endpoint = Some(input);
            self
        }
        /// <p>A summary of the configuration for the Lambda endpoint type. </p>
        pub fn set_lambda_endpoint(
            mut self,
            input: std::option::Option<crate::model::LambdaEndpointSummary>,
        ) -> Self {
            self.lambda_endpoint = input;
            self
        }
        /// <p>The current state of the service. </p>
        pub fn state(mut self, input: crate::model::ServiceState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of the service. </p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::ServiceState>) -> Self {
            self.state = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags assigned to the service. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags assigned to the service. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Any error associated with the service resource. </p>
        pub fn error(mut self, input: crate::model::ErrorResponse) -> Self {
            self.error = Some(input);
            self
        }
        /// <p>Any error associated with the service resource. </p>
        pub fn set_error(
            mut self,
            input: std::option::Option<crate::model::ErrorResponse>,
        ) -> Self {
            self.error = input;
            self
        }
        /// <p>A timestamp that indicates when the service was last updated. </p>
        pub fn last_updated_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>A timestamp that indicates when the service was last updated. </p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// <p>A timestamp that indicates when the service is created. </p>
        pub fn created_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>A timestamp that indicates when the service is created. </p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceSummary`](crate::model::ServiceSummary)
        pub fn build(self) -> crate::model::ServiceSummary {
            crate::model::ServiceSummary {
                service_id: self.service_id,
                name: self.name,
                arn: self.arn,
                owner_account_id: self.owner_account_id,
                created_by_account_id: self.created_by_account_id,
                description: self.description,
                environment_id: self.environment_id,
                application_id: self.application_id,
                vpc_id: self.vpc_id,
                endpoint_type: self.endpoint_type,
                url_endpoint: self.url_endpoint,
                lambda_endpoint: self.lambda_endpoint,
                state: self.state,
                tags: self.tags,
                error: self.error,
                last_updated_time: self.last_updated_time,
                created_time: self.created_time,
            }
        }
    }
}
impl ServiceSummary {
    /// Creates a new builder-style object to manufacture [`ServiceSummary`](crate::model::ServiceSummary)
    pub fn builder() -> crate::model::service_summary::Builder {
        crate::model::service_summary::Builder::default()
    }
}

/// <p>Error associated with a resource returned for a Get or List resource response. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ErrorResponse {
    /// <p>The error code associated with the error. </p>
    pub code: std::option::Option<crate::model::ErrorCode>,
    /// <p>The message associated with the error. </p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services account ID of the resource owner. </p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The ID of the resource. </p>
    pub resource_identifier: std::option::Option<std::string::String>,
    /// <p>The type of resource. </p>
    pub resource_type: std::option::Option<crate::model::ErrorResourceType>,
    /// <p>Additional details about the error. </p>
    pub additional_details:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ErrorResponse {
    /// <p>The error code associated with the error. </p>
    pub fn code(&self) -> std::option::Option<&crate::model::ErrorCode> {
        self.code.as_ref()
    }
    /// <p>The message associated with the error. </p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>The Amazon Web Services account ID of the resource owner. </p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The ID of the resource. </p>
    pub fn resource_identifier(&self) -> std::option::Option<&str> {
        self.resource_identifier.as_deref()
    }
    /// <p>The type of resource. </p>
    pub fn resource_type(&self) -> std::option::Option<&crate::model::ErrorResourceType> {
        self.resource_type.as_ref()
    }
    /// <p>Additional details about the error. </p>
    pub fn additional_details(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.additional_details.as_ref()
    }
}
impl std::fmt::Debug for ErrorResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ErrorResponse");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.field("account_id", &self.account_id);
        formatter.field("resource_identifier", &self.resource_identifier);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("additional_details", &self.additional_details);
        formatter.finish()
    }
}
/// See [`ErrorResponse`](crate::model::ErrorResponse)
pub mod error_response {
    /// A builder for [`ErrorResponse`](crate::model::ErrorResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<crate::model::ErrorCode>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) resource_identifier: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<crate::model::ErrorResourceType>,
        pub(crate) additional_details: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The error code associated with the error. </p>
        pub fn code(mut self, input: crate::model::ErrorCode) -> Self {
            self.code = Some(input);
            self
        }
        /// <p>The error code associated with the error. </p>
        pub fn set_code(mut self, input: std::option::Option<crate::model::ErrorCode>) -> Self {
            self.code = input;
            self
        }
        /// <p>The message associated with the error. </p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message associated with the error. </p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The Amazon Web Services account ID of the resource owner. </p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the resource owner. </p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The ID of the resource. </p>
        pub fn resource_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_identifier = Some(input.into());
            self
        }
        /// <p>The ID of the resource. </p>
        pub fn set_resource_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_identifier = input;
            self
        }
        /// <p>The type of resource. </p>
        pub fn resource_type(mut self, input: crate::model::ErrorResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The type of resource. </p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ErrorResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Adds a key-value pair to `additional_details`.
        ///
        /// To override the contents of this collection use [`set_additional_details`](Self::set_additional_details).
        ///
        /// <p>Additional details about the error. </p>
        pub fn additional_details(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.additional_details.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.additional_details = Some(hash_map);
            self
        }
        /// <p>Additional details about the error. </p>
        pub fn set_additional_details(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.additional_details = input;
            self
        }
        /// Consumes the builder and constructs a [`ErrorResponse`](crate::model::ErrorResponse)
        pub fn build(self) -> crate::model::ErrorResponse {
            crate::model::ErrorResponse {
                code: self.code,
                message: self.message,
                account_id: self.account_id,
                resource_identifier: self.resource_identifier,
                resource_type: self.resource_type,
                additional_details: self.additional_details,
            }
        }
    }
}
impl ErrorResponse {
    /// Creates a new builder-style object to manufacture [`ErrorResponse`](crate::model::ErrorResponse)
    pub fn builder() -> crate::model::error_response::Builder {
        crate::model::error_response::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ErrorResourceType {
    #[allow(missing_docs)] // documentation missing in model
    ApiGateway,
    #[allow(missing_docs)] // documentation missing in model
    Application,
    #[allow(missing_docs)] // documentation missing in model
    Environment,
    #[allow(missing_docs)] // documentation missing in model
    IamRole,
    #[allow(missing_docs)] // documentation missing in model
    Lambda,
    #[allow(missing_docs)] // documentation missing in model
    LoadBalancerListener,
    #[allow(missing_docs)] // documentation missing in model
    Nlb,
    #[allow(missing_docs)] // documentation missing in model
    ResourceShare,
    #[allow(missing_docs)] // documentation missing in model
    Route,
    #[allow(missing_docs)] // documentation missing in model
    RouteTable,
    #[allow(missing_docs)] // documentation missing in model
    SecurityGroup,
    #[allow(missing_docs)] // documentation missing in model
    Service,
    #[allow(missing_docs)] // documentation missing in model
    Subnet,
    #[allow(missing_docs)] // documentation missing in model
    TargetGroup,
    #[allow(missing_docs)] // documentation missing in model
    TransitGateway,
    #[allow(missing_docs)] // documentation missing in model
    TransitGatewayAttachment,
    #[allow(missing_docs)] // documentation missing in model
    Vpc,
    #[allow(missing_docs)] // documentation missing in model
    VpcEndpointServiceConfiguration,
    #[allow(missing_docs)] // documentation missing in model
    VpcLink,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ErrorResourceType {
    fn from(s: &str) -> Self {
        match s {
            "API_GATEWAY" => ErrorResourceType::ApiGateway,
            "APPLICATION" => ErrorResourceType::Application,
            "ENVIRONMENT" => ErrorResourceType::Environment,
            "IAM_ROLE" => ErrorResourceType::IamRole,
            "LAMBDA" => ErrorResourceType::Lambda,
            "LOAD_BALANCER_LISTENER" => ErrorResourceType::LoadBalancerListener,
            "NLB" => ErrorResourceType::Nlb,
            "RESOURCE_SHARE" => ErrorResourceType::ResourceShare,
            "ROUTE" => ErrorResourceType::Route,
            "ROUTE_TABLE" => ErrorResourceType::RouteTable,
            "SECURITY_GROUP" => ErrorResourceType::SecurityGroup,
            "SERVICE" => ErrorResourceType::Service,
            "SUBNET" => ErrorResourceType::Subnet,
            "TARGET_GROUP" => ErrorResourceType::TargetGroup,
            "TRANSIT_GATEWAY" => ErrorResourceType::TransitGateway,
            "TRANSIT_GATEWAY_ATTACHMENT" => ErrorResourceType::TransitGatewayAttachment,
            "VPC" => ErrorResourceType::Vpc,
            "VPC_ENDPOINT_SERVICE_CONFIGURATION" => {
                ErrorResourceType::VpcEndpointServiceConfiguration
            }
            "VPC_LINK" => ErrorResourceType::VpcLink,
            other => ErrorResourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ErrorResourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ErrorResourceType::from(s))
    }
}
impl ErrorResourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ErrorResourceType::ApiGateway => "API_GATEWAY",
            ErrorResourceType::Application => "APPLICATION",
            ErrorResourceType::Environment => "ENVIRONMENT",
            ErrorResourceType::IamRole => "IAM_ROLE",
            ErrorResourceType::Lambda => "LAMBDA",
            ErrorResourceType::LoadBalancerListener => "LOAD_BALANCER_LISTENER",
            ErrorResourceType::Nlb => "NLB",
            ErrorResourceType::ResourceShare => "RESOURCE_SHARE",
            ErrorResourceType::Route => "ROUTE",
            ErrorResourceType::RouteTable => "ROUTE_TABLE",
            ErrorResourceType::SecurityGroup => "SECURITY_GROUP",
            ErrorResourceType::Service => "SERVICE",
            ErrorResourceType::Subnet => "SUBNET",
            ErrorResourceType::TargetGroup => "TARGET_GROUP",
            ErrorResourceType::TransitGateway => "TRANSIT_GATEWAY",
            ErrorResourceType::TransitGatewayAttachment => "TRANSIT_GATEWAY_ATTACHMENT",
            ErrorResourceType::Vpc => "VPC",
            ErrorResourceType::VpcEndpointServiceConfiguration => {
                "VPC_ENDPOINT_SERVICE_CONFIGURATION"
            }
            ErrorResourceType::VpcLink => "VPC_LINK",
            ErrorResourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "API_GATEWAY",
            "APPLICATION",
            "ENVIRONMENT",
            "IAM_ROLE",
            "LAMBDA",
            "LOAD_BALANCER_LISTENER",
            "NLB",
            "RESOURCE_SHARE",
            "ROUTE",
            "ROUTE_TABLE",
            "SECURITY_GROUP",
            "SERVICE",
            "SUBNET",
            "TARGET_GROUP",
            "TRANSIT_GATEWAY",
            "TRANSIT_GATEWAY_ATTACHMENT",
            "VPC",
            "VPC_ENDPOINT_SERVICE_CONFIGURATION",
            "VPC_LINK",
        ]
    }
}
impl AsRef<str> for ErrorResourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ErrorCode {
    #[allow(missing_docs)] // documentation missing in model
    InvalidResourceState,
    #[allow(missing_docs)] // documentation missing in model
    NotAuthorized,
    #[allow(missing_docs)] // documentation missing in model
    RequestLimitExceeded,
    #[allow(missing_docs)] // documentation missing in model
    ResourceCreationFailure,
    #[allow(missing_docs)] // documentation missing in model
    ResourceDeletionFailure,
    #[allow(missing_docs)] // documentation missing in model
    ResourceInUse,
    #[allow(missing_docs)] // documentation missing in model
    ResourceLimitExceeded,
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFound,
    #[allow(missing_docs)] // documentation missing in model
    ResourceRetrievalFailure,
    #[allow(missing_docs)] // documentation missing in model
    ResourceUpdateFailure,
    #[allow(missing_docs)] // documentation missing in model
    ServiceEndpointHealthCheckFailure,
    #[allow(missing_docs)] // documentation missing in model
    StateTransitionFailure,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ErrorCode {
    fn from(s: &str) -> Self {
        match s {
            "INVALID_RESOURCE_STATE" => ErrorCode::InvalidResourceState,
            "NOT_AUTHORIZED" => ErrorCode::NotAuthorized,
            "REQUEST_LIMIT_EXCEEDED" => ErrorCode::RequestLimitExceeded,
            "RESOURCE_CREATION_FAILURE" => ErrorCode::ResourceCreationFailure,
            "RESOURCE_DELETION_FAILURE" => ErrorCode::ResourceDeletionFailure,
            "RESOURCE_IN_USE" => ErrorCode::ResourceInUse,
            "RESOURCE_LIMIT_EXCEEDED" => ErrorCode::ResourceLimitExceeded,
            "RESOURCE_NOT_FOUND" => ErrorCode::ResourceNotFound,
            "RESOURCE_RETRIEVAL_FAILURE" => ErrorCode::ResourceRetrievalFailure,
            "RESOURCE_UPDATE_FAILURE" => ErrorCode::ResourceUpdateFailure,
            "SERVICE_ENDPOINT_HEALTH_CHECK_FAILURE" => ErrorCode::ServiceEndpointHealthCheckFailure,
            "STATE_TRANSITION_FAILURE" => ErrorCode::StateTransitionFailure,
            other => ErrorCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ErrorCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ErrorCode::from(s))
    }
}
impl ErrorCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ErrorCode::InvalidResourceState => "INVALID_RESOURCE_STATE",
            ErrorCode::NotAuthorized => "NOT_AUTHORIZED",
            ErrorCode::RequestLimitExceeded => "REQUEST_LIMIT_EXCEEDED",
            ErrorCode::ResourceCreationFailure => "RESOURCE_CREATION_FAILURE",
            ErrorCode::ResourceDeletionFailure => "RESOURCE_DELETION_FAILURE",
            ErrorCode::ResourceInUse => "RESOURCE_IN_USE",
            ErrorCode::ResourceLimitExceeded => "RESOURCE_LIMIT_EXCEEDED",
            ErrorCode::ResourceNotFound => "RESOURCE_NOT_FOUND",
            ErrorCode::ResourceRetrievalFailure => "RESOURCE_RETRIEVAL_FAILURE",
            ErrorCode::ResourceUpdateFailure => "RESOURCE_UPDATE_FAILURE",
            ErrorCode::ServiceEndpointHealthCheckFailure => "SERVICE_ENDPOINT_HEALTH_CHECK_FAILURE",
            ErrorCode::StateTransitionFailure => "STATE_TRANSITION_FAILURE",
            ErrorCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "INVALID_RESOURCE_STATE",
            "NOT_AUTHORIZED",
            "REQUEST_LIMIT_EXCEEDED",
            "RESOURCE_CREATION_FAILURE",
            "RESOURCE_DELETION_FAILURE",
            "RESOURCE_IN_USE",
            "RESOURCE_LIMIT_EXCEEDED",
            "RESOURCE_NOT_FOUND",
            "RESOURCE_RETRIEVAL_FAILURE",
            "RESOURCE_UPDATE_FAILURE",
            "SERVICE_ENDPOINT_HEALTH_CHECK_FAILURE",
            "STATE_TRANSITION_FAILURE",
        ]
    }
}
impl AsRef<str> for ErrorCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ServiceState {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ServiceState {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => ServiceState::Active,
            "CREATING" => ServiceState::Creating,
            "DELETING" => ServiceState::Deleting,
            "FAILED" => ServiceState::Failed,
            other => ServiceState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ServiceState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ServiceState::from(s))
    }
}
impl ServiceState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ServiceState::Active => "ACTIVE",
            ServiceState::Creating => "CREATING",
            ServiceState::Deleting => "DELETING",
            ServiceState::Failed => "FAILED",
            ServiceState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "CREATING", "DELETING", "FAILED"]
    }
}
impl AsRef<str> for ServiceState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The summary for the Lambda endpoint type. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LambdaEndpointSummary {
    /// <p>The Amazon Resource Name (ARN) of the Lambda endpoint. </p>
    pub arn: std::option::Option<std::string::String>,
}
impl LambdaEndpointSummary {
    /// <p>The Amazon Resource Name (ARN) of the Lambda endpoint. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for LambdaEndpointSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LambdaEndpointSummary");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`LambdaEndpointSummary`](crate::model::LambdaEndpointSummary)
pub mod lambda_endpoint_summary {
    /// A builder for [`LambdaEndpointSummary`](crate::model::LambdaEndpointSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the Lambda endpoint. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Lambda endpoint. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`LambdaEndpointSummary`](crate::model::LambdaEndpointSummary)
        pub fn build(self) -> crate::model::LambdaEndpointSummary {
            crate::model::LambdaEndpointSummary { arn: self.arn }
        }
    }
}
impl LambdaEndpointSummary {
    /// Creates a new builder-style object to manufacture [`LambdaEndpointSummary`](crate::model::LambdaEndpointSummary)
    pub fn builder() -> crate::model::lambda_endpoint_summary::Builder {
        crate::model::lambda_endpoint_summary::Builder::default()
    }
}

/// <p>The summary of the configuration for the URL endpoint type. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UrlEndpointSummary {
    /// <p> The URL to route traffic to. The URL must be an <a href="https://datatracker.ietf.org/doc/html/rfc3986">rfc3986-formatted URL</a>. If the host is a domain name, the name must be resolvable over the public internet. If the scheme is <code>https</code>, the top level domain of the host must be listed in the <a href="https://www.iana.org/domains/root/db">IANA root zone database</a>. </p>
    pub url: std::option::Option<std::string::String>,
    /// <p>The health check URL of the URL endpoint type. If the URL is a public endpoint, the <code>HealthUrl</code> must also be a public endpoint. If the URL is a private endpoint inside a virtual private cloud (VPC), the health URL must also be a private endpoint, and the host must be the same as the URL.</p>
    pub health_url: std::option::Option<std::string::String>,
}
impl UrlEndpointSummary {
    /// <p> The URL to route traffic to. The URL must be an <a href="https://datatracker.ietf.org/doc/html/rfc3986">rfc3986-formatted URL</a>. If the host is a domain name, the name must be resolvable over the public internet. If the scheme is <code>https</code>, the top level domain of the host must be listed in the <a href="https://www.iana.org/domains/root/db">IANA root zone database</a>. </p>
    pub fn url(&self) -> std::option::Option<&str> {
        self.url.as_deref()
    }
    /// <p>The health check URL of the URL endpoint type. If the URL is a public endpoint, the <code>HealthUrl</code> must also be a public endpoint. If the URL is a private endpoint inside a virtual private cloud (VPC), the health URL must also be a private endpoint, and the host must be the same as the URL.</p>
    pub fn health_url(&self) -> std::option::Option<&str> {
        self.health_url.as_deref()
    }
}
impl std::fmt::Debug for UrlEndpointSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UrlEndpointSummary");
        formatter.field("url", &self.url);
        formatter.field("health_url", &self.health_url);
        formatter.finish()
    }
}
/// See [`UrlEndpointSummary`](crate::model::UrlEndpointSummary)
pub mod url_endpoint_summary {
    /// A builder for [`UrlEndpointSummary`](crate::model::UrlEndpointSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) url: std::option::Option<std::string::String>,
        pub(crate) health_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The URL to route traffic to. The URL must be an <a href="https://datatracker.ietf.org/doc/html/rfc3986">rfc3986-formatted URL</a>. If the host is a domain name, the name must be resolvable over the public internet. If the scheme is <code>https</code>, the top level domain of the host must be listed in the <a href="https://www.iana.org/domains/root/db">IANA root zone database</a>. </p>
        pub fn url(mut self, input: impl Into<std::string::String>) -> Self {
            self.url = Some(input.into());
            self
        }
        /// <p> The URL to route traffic to. The URL must be an <a href="https://datatracker.ietf.org/doc/html/rfc3986">rfc3986-formatted URL</a>. If the host is a domain name, the name must be resolvable over the public internet. If the scheme is <code>https</code>, the top level domain of the host must be listed in the <a href="https://www.iana.org/domains/root/db">IANA root zone database</a>. </p>
        pub fn set_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.url = input;
            self
        }
        /// <p>The health check URL of the URL endpoint type. If the URL is a public endpoint, the <code>HealthUrl</code> must also be a public endpoint. If the URL is a private endpoint inside a virtual private cloud (VPC), the health URL must also be a private endpoint, and the host must be the same as the URL.</p>
        pub fn health_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.health_url = Some(input.into());
            self
        }
        /// <p>The health check URL of the URL endpoint type. If the URL is a public endpoint, the <code>HealthUrl</code> must also be a public endpoint. If the URL is a private endpoint inside a virtual private cloud (VPC), the health URL must also be a private endpoint, and the host must be the same as the URL.</p>
        pub fn set_health_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.health_url = input;
            self
        }
        /// Consumes the builder and constructs a [`UrlEndpointSummary`](crate::model::UrlEndpointSummary)
        pub fn build(self) -> crate::model::UrlEndpointSummary {
            crate::model::UrlEndpointSummary {
                url: self.url,
                health_url: self.health_url,
            }
        }
    }
}
impl UrlEndpointSummary {
    /// Creates a new builder-style object to manufacture [`UrlEndpointSummary`](crate::model::UrlEndpointSummary)
    pub fn builder() -> crate::model::url_endpoint_summary::Builder {
        crate::model::url_endpoint_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ServiceEndpointType {
    #[allow(missing_docs)] // documentation missing in model
    Lambda,
    #[allow(missing_docs)] // documentation missing in model
    Url,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ServiceEndpointType {
    fn from(s: &str) -> Self {
        match s {
            "LAMBDA" => ServiceEndpointType::Lambda,
            "URL" => ServiceEndpointType::Url,
            other => ServiceEndpointType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ServiceEndpointType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ServiceEndpointType::from(s))
    }
}
impl ServiceEndpointType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ServiceEndpointType::Lambda => "LAMBDA",
            ServiceEndpointType::Url => "URL",
            ServiceEndpointType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["LAMBDA", "URL"]
    }
}
impl AsRef<str> for ServiceEndpointType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The summary information for the routes as a response to <code>ListRoutes</code>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RouteSummary {
    /// <p>The unique identifier of the route. </p>
    pub route_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the route. </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services account ID of the route owner.</p>
    pub owner_account_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services account ID of the route creator. </p>
    pub created_by_account_id: std::option::Option<std::string::String>,
    /// <p>The route type of the route. </p>
    pub route_type: std::option::Option<crate::model::RouteType>,
    /// <p>The unique identifier of the service. </p>
    pub service_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the application. </p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the environment. </p>
    pub environment_id: std::option::Option<std::string::String>,
    /// <p>The path to use to match traffic. Paths must start with <code>/</code> and are relative to the base of the application.</p>
    pub source_path: std::option::Option<std::string::String>,
    /// <p>A list of HTTP methods to match. An empty list matches all values. If a method is present, only HTTP requests using that method are forwarded to this route’s service. </p>
    pub methods: std::option::Option<std::vec::Vec<crate::model::HttpMethod>>,
    /// <p>Indicates whether to match all subpaths of the given source path. If this value is <code>false</code>, requests must match the source path exactly before they are forwarded to this route's service.</p>
    pub include_child_paths: std::option::Option<bool>,
    /// <p>A mapping of Amazon API Gateway path resources to resource IDs. </p>
    pub path_resource_to_id:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The current state of the route. </p>
    pub state: std::option::Option<crate::model::RouteState>,
    /// <p>The tags assigned to the route. </p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Any error associated with the route resource. </p>
    pub error: std::option::Option<crate::model::ErrorResponse>,
    /// <p>A timestamp that indicates when the route was last updated. </p>
    pub last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A timestamp that indicates when the route is created. </p>
    pub created_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl RouteSummary {
    /// <p>The unique identifier of the route. </p>
    pub fn route_id(&self) -> std::option::Option<&str> {
        self.route_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the route. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The Amazon Web Services account ID of the route owner.</p>
    pub fn owner_account_id(&self) -> std::option::Option<&str> {
        self.owner_account_id.as_deref()
    }
    /// <p>The Amazon Web Services account ID of the route creator. </p>
    pub fn created_by_account_id(&self) -> std::option::Option<&str> {
        self.created_by_account_id.as_deref()
    }
    /// <p>The route type of the route. </p>
    pub fn route_type(&self) -> std::option::Option<&crate::model::RouteType> {
        self.route_type.as_ref()
    }
    /// <p>The unique identifier of the service. </p>
    pub fn service_id(&self) -> std::option::Option<&str> {
        self.service_id.as_deref()
    }
    /// <p>The unique identifier of the application. </p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
    /// <p>The unique identifier of the environment. </p>
    pub fn environment_id(&self) -> std::option::Option<&str> {
        self.environment_id.as_deref()
    }
    /// <p>The path to use to match traffic. Paths must start with <code>/</code> and are relative to the base of the application.</p>
    pub fn source_path(&self) -> std::option::Option<&str> {
        self.source_path.as_deref()
    }
    /// <p>A list of HTTP methods to match. An empty list matches all values. If a method is present, only HTTP requests using that method are forwarded to this route’s service. </p>
    pub fn methods(&self) -> std::option::Option<&[crate::model::HttpMethod]> {
        self.methods.as_deref()
    }
    /// <p>Indicates whether to match all subpaths of the given source path. If this value is <code>false</code>, requests must match the source path exactly before they are forwarded to this route's service.</p>
    pub fn include_child_paths(&self) -> std::option::Option<bool> {
        self.include_child_paths
    }
    /// <p>A mapping of Amazon API Gateway path resources to resource IDs. </p>
    pub fn path_resource_to_id(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.path_resource_to_id.as_ref()
    }
    /// <p>The current state of the route. </p>
    pub fn state(&self) -> std::option::Option<&crate::model::RouteState> {
        self.state.as_ref()
    }
    /// <p>The tags assigned to the route. </p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>Any error associated with the route resource. </p>
    pub fn error(&self) -> std::option::Option<&crate::model::ErrorResponse> {
        self.error.as_ref()
    }
    /// <p>A timestamp that indicates when the route was last updated. </p>
    pub fn last_updated_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_time.as_ref()
    }
    /// <p>A timestamp that indicates when the route is created. </p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_time.as_ref()
    }
}
impl std::fmt::Debug for RouteSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RouteSummary");
        formatter.field("route_id", &self.route_id);
        formatter.field("arn", &self.arn);
        formatter.field("owner_account_id", &self.owner_account_id);
        formatter.field("created_by_account_id", &self.created_by_account_id);
        formatter.field("route_type", &self.route_type);
        formatter.field("service_id", &self.service_id);
        formatter.field("application_id", &self.application_id);
        formatter.field("environment_id", &self.environment_id);
        formatter.field("source_path", &self.source_path);
        formatter.field("methods", &self.methods);
        formatter.field("include_child_paths", &self.include_child_paths);
        formatter.field("path_resource_to_id", &self.path_resource_to_id);
        formatter.field("state", &self.state);
        formatter.field("tags", &"*** Sensitive Data Redacted ***");
        formatter.field("error", &self.error);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.field("created_time", &self.created_time);
        formatter.finish()
    }
}
/// See [`RouteSummary`](crate::model::RouteSummary)
pub mod route_summary {
    /// A builder for [`RouteSummary`](crate::model::RouteSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) route_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) owner_account_id: std::option::Option<std::string::String>,
        pub(crate) created_by_account_id: std::option::Option<std::string::String>,
        pub(crate) route_type: std::option::Option<crate::model::RouteType>,
        pub(crate) service_id: std::option::Option<std::string::String>,
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) environment_id: std::option::Option<std::string::String>,
        pub(crate) source_path: std::option::Option<std::string::String>,
        pub(crate) methods: std::option::Option<std::vec::Vec<crate::model::HttpMethod>>,
        pub(crate) include_child_paths: std::option::Option<bool>,
        pub(crate) path_resource_to_id: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) state: std::option::Option<crate::model::RouteState>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) error: std::option::Option<crate::model::ErrorResponse>,
        pub(crate) last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The unique identifier of the route. </p>
        pub fn route_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the route. </p>
        pub fn set_route_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.route_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the route. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the route. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The Amazon Web Services account ID of the route owner.</p>
        pub fn owner_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the route owner.</p>
        pub fn set_owner_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owner_account_id = input;
            self
        }
        /// <p>The Amazon Web Services account ID of the route creator. </p>
        pub fn created_by_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_by_account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the route creator. </p>
        pub fn set_created_by_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.created_by_account_id = input;
            self
        }
        /// <p>The route type of the route. </p>
        pub fn route_type(mut self, input: crate::model::RouteType) -> Self {
            self.route_type = Some(input);
            self
        }
        /// <p>The route type of the route. </p>
        pub fn set_route_type(
            mut self,
            input: std::option::Option<crate::model::RouteType>,
        ) -> Self {
            self.route_type = input;
            self
        }
        /// <p>The unique identifier of the service. </p>
        pub fn service_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the service. </p>
        pub fn set_service_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_id = input;
            self
        }
        /// <p>The unique identifier of the application. </p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the application. </p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The unique identifier of the environment. </p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the environment. </p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_id = input;
            self
        }
        /// <p>The path to use to match traffic. Paths must start with <code>/</code> and are relative to the base of the application.</p>
        pub fn source_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_path = Some(input.into());
            self
        }
        /// <p>The path to use to match traffic. Paths must start with <code>/</code> and are relative to the base of the application.</p>
        pub fn set_source_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_path = input;
            self
        }
        /// Appends an item to `methods`.
        ///
        /// To override the contents of this collection use [`set_methods`](Self::set_methods).
        ///
        /// <p>A list of HTTP methods to match. An empty list matches all values. If a method is present, only HTTP requests using that method are forwarded to this route’s service. </p>
        pub fn methods(mut self, input: crate::model::HttpMethod) -> Self {
            let mut v = self.methods.unwrap_or_default();
            v.push(input);
            self.methods = Some(v);
            self
        }
        /// <p>A list of HTTP methods to match. An empty list matches all values. If a method is present, only HTTP requests using that method are forwarded to this route’s service. </p>
        pub fn set_methods(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HttpMethod>>,
        ) -> Self {
            self.methods = input;
            self
        }
        /// <p>Indicates whether to match all subpaths of the given source path. If this value is <code>false</code>, requests must match the source path exactly before they are forwarded to this route's service.</p>
        pub fn include_child_paths(mut self, input: bool) -> Self {
            self.include_child_paths = Some(input);
            self
        }
        /// <p>Indicates whether to match all subpaths of the given source path. If this value is <code>false</code>, requests must match the source path exactly before they are forwarded to this route's service.</p>
        pub fn set_include_child_paths(mut self, input: std::option::Option<bool>) -> Self {
            self.include_child_paths = input;
            self
        }
        /// Adds a key-value pair to `path_resource_to_id`.
        ///
        /// To override the contents of this collection use [`set_path_resource_to_id`](Self::set_path_resource_to_id).
        ///
        /// <p>A mapping of Amazon API Gateway path resources to resource IDs. </p>
        pub fn path_resource_to_id(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.path_resource_to_id.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.path_resource_to_id = Some(hash_map);
            self
        }
        /// <p>A mapping of Amazon API Gateway path resources to resource IDs. </p>
        pub fn set_path_resource_to_id(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.path_resource_to_id = input;
            self
        }
        /// <p>The current state of the route. </p>
        pub fn state(mut self, input: crate::model::RouteState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of the route. </p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::RouteState>) -> Self {
            self.state = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags assigned to the route. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags assigned to the route. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Any error associated with the route resource. </p>
        pub fn error(mut self, input: crate::model::ErrorResponse) -> Self {
            self.error = Some(input);
            self
        }
        /// <p>Any error associated with the route resource. </p>
        pub fn set_error(
            mut self,
            input: std::option::Option<crate::model::ErrorResponse>,
        ) -> Self {
            self.error = input;
            self
        }
        /// <p>A timestamp that indicates when the route was last updated. </p>
        pub fn last_updated_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>A timestamp that indicates when the route was last updated. </p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// <p>A timestamp that indicates when the route is created. </p>
        pub fn created_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>A timestamp that indicates when the route is created. </p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// Consumes the builder and constructs a [`RouteSummary`](crate::model::RouteSummary)
        pub fn build(self) -> crate::model::RouteSummary {
            crate::model::RouteSummary {
                route_id: self.route_id,
                arn: self.arn,
                owner_account_id: self.owner_account_id,
                created_by_account_id: self.created_by_account_id,
                route_type: self.route_type,
                service_id: self.service_id,
                application_id: self.application_id,
                environment_id: self.environment_id,
                source_path: self.source_path,
                methods: self.methods,
                include_child_paths: self.include_child_paths,
                path_resource_to_id: self.path_resource_to_id,
                state: self.state,
                tags: self.tags,
                error: self.error,
                last_updated_time: self.last_updated_time,
                created_time: self.created_time,
            }
        }
    }
}
impl RouteSummary {
    /// Creates a new builder-style object to manufacture [`RouteSummary`](crate::model::RouteSummary)
    pub fn builder() -> crate::model::route_summary::Builder {
        crate::model::route_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RouteState {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Inactive,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RouteState {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => RouteState::Active,
            "CREATING" => RouteState::Creating,
            "DELETING" => RouteState::Deleting,
            "FAILED" => RouteState::Failed,
            "INACTIVE" => RouteState::Inactive,
            "UPDATING" => RouteState::Updating,
            other => RouteState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RouteState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RouteState::from(s))
    }
}
impl RouteState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RouteState::Active => "ACTIVE",
            RouteState::Creating => "CREATING",
            RouteState::Deleting => "DELETING",
            RouteState::Failed => "FAILED",
            RouteState::Inactive => "INACTIVE",
            RouteState::Updating => "UPDATING",
            RouteState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTIVE", "CREATING", "DELETING", "FAILED", "INACTIVE", "UPDATING",
        ]
    }
}
impl AsRef<str> for RouteState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum HttpMethod {
    #[allow(missing_docs)] // documentation missing in model
    Delete,
    #[allow(missing_docs)] // documentation missing in model
    Get,
    #[allow(missing_docs)] // documentation missing in model
    Head,
    #[allow(missing_docs)] // documentation missing in model
    Options,
    #[allow(missing_docs)] // documentation missing in model
    Patch,
    #[allow(missing_docs)] // documentation missing in model
    Post,
    #[allow(missing_docs)] // documentation missing in model
    Put,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for HttpMethod {
    fn from(s: &str) -> Self {
        match s {
            "DELETE" => HttpMethod::Delete,
            "GET" => HttpMethod::Get,
            "HEAD" => HttpMethod::Head,
            "OPTIONS" => HttpMethod::Options,
            "PATCH" => HttpMethod::Patch,
            "POST" => HttpMethod::Post,
            "PUT" => HttpMethod::Put,
            other => HttpMethod::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for HttpMethod {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(HttpMethod::from(s))
    }
}
impl HttpMethod {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            HttpMethod::Delete => "DELETE",
            HttpMethod::Get => "GET",
            HttpMethod::Head => "HEAD",
            HttpMethod::Options => "OPTIONS",
            HttpMethod::Patch => "PATCH",
            HttpMethod::Post => "POST",
            HttpMethod::Put => "PUT",
            HttpMethod::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DELETE", "GET", "HEAD", "OPTIONS", "PATCH", "POST", "PUT"]
    }
}
impl AsRef<str> for HttpMethod {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RouteType {
    #[allow(missing_docs)] // documentation missing in model
    Default,
    #[allow(missing_docs)] // documentation missing in model
    UriPath,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RouteType {
    fn from(s: &str) -> Self {
        match s {
            "DEFAULT" => RouteType::Default,
            "URI_PATH" => RouteType::UriPath,
            other => RouteType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RouteType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RouteType::from(s))
    }
}
impl RouteType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RouteType::Default => "DEFAULT",
            RouteType::UriPath => "URI_PATH",
            RouteType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DEFAULT", "URI_PATH"]
    }
}
impl AsRef<str> for RouteType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides summary information for the <code>EnvironmentVpc</code> resource as a response to <code>ListEnvironmentVpc</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnvironmentVpc {
    /// <p>The unique identifier of the environment. </p>
    pub environment_id: std::option::Option<std::string::String>,
    /// <p>The ID of the VPC. </p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services account ID of the virtual private cloud (VPC) owner. </p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The list of Amazon Virtual Private Cloud (Amazon VPC) CIDR blocks. </p>
    pub cidr_blocks: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The name of the VPC at the time it is added to the environment. </p>
    pub vpc_name: std::option::Option<std::string::String>,
    /// <p>A timestamp that indicates when the VPC was last updated by the environment. </p>
    pub last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A timestamp that indicates when the VPC is first added to the environment. </p>
    pub created_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl EnvironmentVpc {
    /// <p>The unique identifier of the environment. </p>
    pub fn environment_id(&self) -> std::option::Option<&str> {
        self.environment_id.as_deref()
    }
    /// <p>The ID of the VPC. </p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
    /// <p>The Amazon Web Services account ID of the virtual private cloud (VPC) owner. </p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The list of Amazon Virtual Private Cloud (Amazon VPC) CIDR blocks. </p>
    pub fn cidr_blocks(&self) -> std::option::Option<&[std::string::String]> {
        self.cidr_blocks.as_deref()
    }
    /// <p>The name of the VPC at the time it is added to the environment. </p>
    pub fn vpc_name(&self) -> std::option::Option<&str> {
        self.vpc_name.as_deref()
    }
    /// <p>A timestamp that indicates when the VPC was last updated by the environment. </p>
    pub fn last_updated_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_time.as_ref()
    }
    /// <p>A timestamp that indicates when the VPC is first added to the environment. </p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_time.as_ref()
    }
}
impl std::fmt::Debug for EnvironmentVpc {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnvironmentVpc");
        formatter.field("environment_id", &self.environment_id);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("account_id", &self.account_id);
        formatter.field("cidr_blocks", &self.cidr_blocks);
        formatter.field("vpc_name", &self.vpc_name);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.field("created_time", &self.created_time);
        formatter.finish()
    }
}
/// See [`EnvironmentVpc`](crate::model::EnvironmentVpc)
pub mod environment_vpc {
    /// A builder for [`EnvironmentVpc`](crate::model::EnvironmentVpc)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environment_id: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) cidr_blocks: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) vpc_name: std::option::Option<std::string::String>,
        pub(crate) last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The unique identifier of the environment. </p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the environment. </p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_id = input;
            self
        }
        /// <p>The ID of the VPC. </p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The ID of the VPC. </p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// <p>The Amazon Web Services account ID of the virtual private cloud (VPC) owner. </p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the virtual private cloud (VPC) owner. </p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// Appends an item to `cidr_blocks`.
        ///
        /// To override the contents of this collection use [`set_cidr_blocks`](Self::set_cidr_blocks).
        ///
        /// <p>The list of Amazon Virtual Private Cloud (Amazon VPC) CIDR blocks. </p>
        pub fn cidr_blocks(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.cidr_blocks.unwrap_or_default();
            v.push(input.into());
            self.cidr_blocks = Some(v);
            self
        }
        /// <p>The list of Amazon Virtual Private Cloud (Amazon VPC) CIDR blocks. </p>
        pub fn set_cidr_blocks(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.cidr_blocks = input;
            self
        }
        /// <p>The name of the VPC at the time it is added to the environment. </p>
        pub fn vpc_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_name = Some(input.into());
            self
        }
        /// <p>The name of the VPC at the time it is added to the environment. </p>
        pub fn set_vpc_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_name = input;
            self
        }
        /// <p>A timestamp that indicates when the VPC was last updated by the environment. </p>
        pub fn last_updated_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>A timestamp that indicates when the VPC was last updated by the environment. </p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// <p>A timestamp that indicates when the VPC is first added to the environment. </p>
        pub fn created_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>A timestamp that indicates when the VPC is first added to the environment. </p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// Consumes the builder and constructs a [`EnvironmentVpc`](crate::model::EnvironmentVpc)
        pub fn build(self) -> crate::model::EnvironmentVpc {
            crate::model::EnvironmentVpc {
                environment_id: self.environment_id,
                vpc_id: self.vpc_id,
                account_id: self.account_id,
                cidr_blocks: self.cidr_blocks,
                vpc_name: self.vpc_name,
                last_updated_time: self.last_updated_time,
                created_time: self.created_time,
            }
        }
    }
}
impl EnvironmentVpc {
    /// Creates a new builder-style object to manufacture [`EnvironmentVpc`](crate::model::EnvironmentVpc)
    pub fn builder() -> crate::model::environment_vpc::Builder {
        crate::model::environment_vpc::Builder::default()
    }
}

/// <p>The summary information for environments as a response to <code>ListEnvironments</code>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnvironmentSummary {
    /// <p>The name of the environment. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the environment. </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>A description of the environment. </p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the environment. </p>
    pub environment_id: std::option::Option<std::string::String>,
    /// <p>The network fabric type of the environment. </p>
    pub network_fabric_type: std::option::Option<crate::model::NetworkFabricType>,
    /// <p>The Amazon Web Services account ID of the environment owner.</p>
    pub owner_account_id: std::option::Option<std::string::String>,
    /// <p>The ID of the transit gateway set up by the environment. </p>
    pub transit_gateway_id: std::option::Option<std::string::String>,
    /// <p>The current state of the environment. </p>
    pub state: std::option::Option<crate::model::EnvironmentState>,
    /// <p>The tags assigned to the environment. </p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Any error associated with the environment resource. </p>
    pub error: std::option::Option<crate::model::ErrorResponse>,
    /// <p>A timestamp that indicates when the environment was last updated. </p>
    pub last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A timestamp that indicates when the environment is created. </p>
    pub created_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl EnvironmentSummary {
    /// <p>The name of the environment. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the environment. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>A description of the environment. </p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The unique identifier of the environment. </p>
    pub fn environment_id(&self) -> std::option::Option<&str> {
        self.environment_id.as_deref()
    }
    /// <p>The network fabric type of the environment. </p>
    pub fn network_fabric_type(&self) -> std::option::Option<&crate::model::NetworkFabricType> {
        self.network_fabric_type.as_ref()
    }
    /// <p>The Amazon Web Services account ID of the environment owner.</p>
    pub fn owner_account_id(&self) -> std::option::Option<&str> {
        self.owner_account_id.as_deref()
    }
    /// <p>The ID of the transit gateway set up by the environment. </p>
    pub fn transit_gateway_id(&self) -> std::option::Option<&str> {
        self.transit_gateway_id.as_deref()
    }
    /// <p>The current state of the environment. </p>
    pub fn state(&self) -> std::option::Option<&crate::model::EnvironmentState> {
        self.state.as_ref()
    }
    /// <p>The tags assigned to the environment. </p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>Any error associated with the environment resource. </p>
    pub fn error(&self) -> std::option::Option<&crate::model::ErrorResponse> {
        self.error.as_ref()
    }
    /// <p>A timestamp that indicates when the environment was last updated. </p>
    pub fn last_updated_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_time.as_ref()
    }
    /// <p>A timestamp that indicates when the environment is created. </p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_time.as_ref()
    }
}
impl std::fmt::Debug for EnvironmentSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnvironmentSummary");
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("description", &self.description);
        formatter.field("environment_id", &self.environment_id);
        formatter.field("network_fabric_type", &self.network_fabric_type);
        formatter.field("owner_account_id", &self.owner_account_id);
        formatter.field("transit_gateway_id", &self.transit_gateway_id);
        formatter.field("state", &self.state);
        formatter.field("tags", &"*** Sensitive Data Redacted ***");
        formatter.field("error", &self.error);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.field("created_time", &self.created_time);
        formatter.finish()
    }
}
/// See [`EnvironmentSummary`](crate::model::EnvironmentSummary)
pub mod environment_summary {
    /// A builder for [`EnvironmentSummary`](crate::model::EnvironmentSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) environment_id: std::option::Option<std::string::String>,
        pub(crate) network_fabric_type: std::option::Option<crate::model::NetworkFabricType>,
        pub(crate) owner_account_id: std::option::Option<std::string::String>,
        pub(crate) transit_gateway_id: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::EnvironmentState>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) error: std::option::Option<crate::model::ErrorResponse>,
        pub(crate) last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the environment. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the environment. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the environment. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the environment. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>A description of the environment. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the environment. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The unique identifier of the environment. </p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the environment. </p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_id = input;
            self
        }
        /// <p>The network fabric type of the environment. </p>
        pub fn network_fabric_type(mut self, input: crate::model::NetworkFabricType) -> Self {
            self.network_fabric_type = Some(input);
            self
        }
        /// <p>The network fabric type of the environment. </p>
        pub fn set_network_fabric_type(
            mut self,
            input: std::option::Option<crate::model::NetworkFabricType>,
        ) -> Self {
            self.network_fabric_type = input;
            self
        }
        /// <p>The Amazon Web Services account ID of the environment owner.</p>
        pub fn owner_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the environment owner.</p>
        pub fn set_owner_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owner_account_id = input;
            self
        }
        /// <p>The ID of the transit gateway set up by the environment. </p>
        pub fn transit_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.transit_gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of the transit gateway set up by the environment. </p>
        pub fn set_transit_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.transit_gateway_id = input;
            self
        }
        /// <p>The current state of the environment. </p>
        pub fn state(mut self, input: crate::model::EnvironmentState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of the environment. </p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::EnvironmentState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags assigned to the environment. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags assigned to the environment. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Any error associated with the environment resource. </p>
        pub fn error(mut self, input: crate::model::ErrorResponse) -> Self {
            self.error = Some(input);
            self
        }
        /// <p>Any error associated with the environment resource. </p>
        pub fn set_error(
            mut self,
            input: std::option::Option<crate::model::ErrorResponse>,
        ) -> Self {
            self.error = input;
            self
        }
        /// <p>A timestamp that indicates when the environment was last updated. </p>
        pub fn last_updated_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>A timestamp that indicates when the environment was last updated. </p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// <p>A timestamp that indicates when the environment is created. </p>
        pub fn created_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>A timestamp that indicates when the environment is created. </p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// Consumes the builder and constructs a [`EnvironmentSummary`](crate::model::EnvironmentSummary)
        pub fn build(self) -> crate::model::EnvironmentSummary {
            crate::model::EnvironmentSummary {
                name: self.name,
                arn: self.arn,
                description: self.description,
                environment_id: self.environment_id,
                network_fabric_type: self.network_fabric_type,
                owner_account_id: self.owner_account_id,
                transit_gateway_id: self.transit_gateway_id,
                state: self.state,
                tags: self.tags,
                error: self.error,
                last_updated_time: self.last_updated_time,
                created_time: self.created_time,
            }
        }
    }
}
impl EnvironmentSummary {
    /// Creates a new builder-style object to manufacture [`EnvironmentSummary`](crate::model::EnvironmentSummary)
    pub fn builder() -> crate::model::environment_summary::Builder {
        crate::model::environment_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EnvironmentState {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EnvironmentState {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => EnvironmentState::Active,
            "CREATING" => EnvironmentState::Creating,
            "DELETING" => EnvironmentState::Deleting,
            "FAILED" => EnvironmentState::Failed,
            other => EnvironmentState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EnvironmentState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EnvironmentState::from(s))
    }
}
impl EnvironmentState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EnvironmentState::Active => "ACTIVE",
            EnvironmentState::Creating => "CREATING",
            EnvironmentState::Deleting => "DELETING",
            EnvironmentState::Failed => "FAILED",
            EnvironmentState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "CREATING", "DELETING", "FAILED"]
    }
}
impl AsRef<str> for EnvironmentState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum NetworkFabricType {
    #[allow(missing_docs)] // documentation missing in model
    TransitGateway,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for NetworkFabricType {
    fn from(s: &str) -> Self {
        match s {
            "TRANSIT_GATEWAY" => NetworkFabricType::TransitGateway,
            other => NetworkFabricType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for NetworkFabricType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(NetworkFabricType::from(s))
    }
}
impl NetworkFabricType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            NetworkFabricType::TransitGateway => "TRANSIT_GATEWAY",
            NetworkFabricType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["TRANSIT_GATEWAY"]
    }
}
impl AsRef<str> for NetworkFabricType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The list of <code>ApplicationSummary</code> objects. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApplicationSummary {
    /// <p>The name of the application. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the application. </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services account ID of the application owner (which is always the same as the environment owner account ID).</p>
    pub owner_account_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services account ID of the application creator. </p>
    pub created_by_account_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the application. </p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the environment. </p>
    pub environment_id: std::option::Option<std::string::String>,
    /// <p>The ID of the virtual private cloud (VPC). </p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>The proxy type of the proxy created within the application. </p>
    pub proxy_type: std::option::Option<crate::model::ProxyType>,
    /// <p>The endpoint URL of the Amazon API Gateway proxy. </p>
    pub api_gateway_proxy: std::option::Option<crate::model::ApiGatewayProxySummary>,
    /// <p>The current state of the application. </p>
    pub state: std::option::Option<crate::model::ApplicationState>,
    /// <p>The tags assigned to the application. </p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Any error associated with the application resource. </p>
    pub error: std::option::Option<crate::model::ErrorResponse>,
    /// <p>A timestamp that indicates when the application was last updated. </p>
    pub last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A timestamp that indicates when the application is created. </p>
    pub created_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl ApplicationSummary {
    /// <p>The name of the application. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the application. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The Amazon Web Services account ID of the application owner (which is always the same as the environment owner account ID).</p>
    pub fn owner_account_id(&self) -> std::option::Option<&str> {
        self.owner_account_id.as_deref()
    }
    /// <p>The Amazon Web Services account ID of the application creator. </p>
    pub fn created_by_account_id(&self) -> std::option::Option<&str> {
        self.created_by_account_id.as_deref()
    }
    /// <p>The unique identifier of the application. </p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
    /// <p>The unique identifier of the environment. </p>
    pub fn environment_id(&self) -> std::option::Option<&str> {
        self.environment_id.as_deref()
    }
    /// <p>The ID of the virtual private cloud (VPC). </p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
    /// <p>The proxy type of the proxy created within the application. </p>
    pub fn proxy_type(&self) -> std::option::Option<&crate::model::ProxyType> {
        self.proxy_type.as_ref()
    }
    /// <p>The endpoint URL of the Amazon API Gateway proxy. </p>
    pub fn api_gateway_proxy(&self) -> std::option::Option<&crate::model::ApiGatewayProxySummary> {
        self.api_gateway_proxy.as_ref()
    }
    /// <p>The current state of the application. </p>
    pub fn state(&self) -> std::option::Option<&crate::model::ApplicationState> {
        self.state.as_ref()
    }
    /// <p>The tags assigned to the application. </p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>Any error associated with the application resource. </p>
    pub fn error(&self) -> std::option::Option<&crate::model::ErrorResponse> {
        self.error.as_ref()
    }
    /// <p>A timestamp that indicates when the application was last updated. </p>
    pub fn last_updated_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_time.as_ref()
    }
    /// <p>A timestamp that indicates when the application is created. </p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_time.as_ref()
    }
}
impl std::fmt::Debug for ApplicationSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApplicationSummary");
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("owner_account_id", &self.owner_account_id);
        formatter.field("created_by_account_id", &self.created_by_account_id);
        formatter.field("application_id", &self.application_id);
        formatter.field("environment_id", &self.environment_id);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("proxy_type", &self.proxy_type);
        formatter.field("api_gateway_proxy", &self.api_gateway_proxy);
        formatter.field("state", &self.state);
        formatter.field("tags", &"*** Sensitive Data Redacted ***");
        formatter.field("error", &self.error);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.field("created_time", &self.created_time);
        formatter.finish()
    }
}
/// See [`ApplicationSummary`](crate::model::ApplicationSummary)
pub mod application_summary {
    /// A builder for [`ApplicationSummary`](crate::model::ApplicationSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) owner_account_id: std::option::Option<std::string::String>,
        pub(crate) created_by_account_id: std::option::Option<std::string::String>,
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) environment_id: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) proxy_type: std::option::Option<crate::model::ProxyType>,
        pub(crate) api_gateway_proxy: std::option::Option<crate::model::ApiGatewayProxySummary>,
        pub(crate) state: std::option::Option<crate::model::ApplicationState>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) error: std::option::Option<crate::model::ErrorResponse>,
        pub(crate) last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the application. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the application. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The Amazon Web Services account ID of the application owner (which is always the same as the environment owner account ID).</p>
        pub fn owner_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the application owner (which is always the same as the environment owner account ID).</p>
        pub fn set_owner_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owner_account_id = input;
            self
        }
        /// <p>The Amazon Web Services account ID of the application creator. </p>
        pub fn created_by_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_by_account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the application creator. </p>
        pub fn set_created_by_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.created_by_account_id = input;
            self
        }
        /// <p>The unique identifier of the application. </p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the application. </p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The unique identifier of the environment. </p>
        pub fn environment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the environment. </p>
        pub fn set_environment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_id = input;
            self
        }
        /// <p>The ID of the virtual private cloud (VPC). </p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The ID of the virtual private cloud (VPC). </p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// <p>The proxy type of the proxy created within the application. </p>
        pub fn proxy_type(mut self, input: crate::model::ProxyType) -> Self {
            self.proxy_type = Some(input);
            self
        }
        /// <p>The proxy type of the proxy created within the application. </p>
        pub fn set_proxy_type(
            mut self,
            input: std::option::Option<crate::model::ProxyType>,
        ) -> Self {
            self.proxy_type = input;
            self
        }
        /// <p>The endpoint URL of the Amazon API Gateway proxy. </p>
        pub fn api_gateway_proxy(mut self, input: crate::model::ApiGatewayProxySummary) -> Self {
            self.api_gateway_proxy = Some(input);
            self
        }
        /// <p>The endpoint URL of the Amazon API Gateway proxy. </p>
        pub fn set_api_gateway_proxy(
            mut self,
            input: std::option::Option<crate::model::ApiGatewayProxySummary>,
        ) -> Self {
            self.api_gateway_proxy = input;
            self
        }
        /// <p>The current state of the application. </p>
        pub fn state(mut self, input: crate::model::ApplicationState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of the application. </p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::ApplicationState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags assigned to the application. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags assigned to the application. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Any error associated with the application resource. </p>
        pub fn error(mut self, input: crate::model::ErrorResponse) -> Self {
            self.error = Some(input);
            self
        }
        /// <p>Any error associated with the application resource. </p>
        pub fn set_error(
            mut self,
            input: std::option::Option<crate::model::ErrorResponse>,
        ) -> Self {
            self.error = input;
            self
        }
        /// <p>A timestamp that indicates when the application was last updated. </p>
        pub fn last_updated_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>A timestamp that indicates when the application was last updated. </p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// <p>A timestamp that indicates when the application is created. </p>
        pub fn created_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>A timestamp that indicates when the application is created. </p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// Consumes the builder and constructs a [`ApplicationSummary`](crate::model::ApplicationSummary)
        pub fn build(self) -> crate::model::ApplicationSummary {
            crate::model::ApplicationSummary {
                name: self.name,
                arn: self.arn,
                owner_account_id: self.owner_account_id,
                created_by_account_id: self.created_by_account_id,
                application_id: self.application_id,
                environment_id: self.environment_id,
                vpc_id: self.vpc_id,
                proxy_type: self.proxy_type,
                api_gateway_proxy: self.api_gateway_proxy,
                state: self.state,
                tags: self.tags,
                error: self.error,
                last_updated_time: self.last_updated_time,
                created_time: self.created_time,
            }
        }
    }
}
impl ApplicationSummary {
    /// Creates a new builder-style object to manufacture [`ApplicationSummary`](crate::model::ApplicationSummary)
    pub fn builder() -> crate::model::application_summary::Builder {
        crate::model::application_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ApplicationState {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ApplicationState {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => ApplicationState::Active,
            "CREATING" => ApplicationState::Creating,
            "DELETING" => ApplicationState::Deleting,
            "FAILED" => ApplicationState::Failed,
            "UPDATING" => ApplicationState::Updating,
            other => ApplicationState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ApplicationState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ApplicationState::from(s))
    }
}
impl ApplicationState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ApplicationState::Active => "ACTIVE",
            ApplicationState::Creating => "CREATING",
            ApplicationState::Deleting => "DELETING",
            ApplicationState::Failed => "FAILED",
            ApplicationState::Updating => "UPDATING",
            ApplicationState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "CREATING", "DELETING", "FAILED", "UPDATING"]
    }
}
impl AsRef<str> for ApplicationState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A wrapper object holding the Amazon API Gateway proxy summary. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApiGatewayProxySummary {
    /// <p>The endpoint URL of the API Gateway proxy. </p>
    pub proxy_url: std::option::Option<std::string::String>,
    /// <p>The resource ID of the API Gateway for the proxy. </p>
    pub api_gateway_id: std::option::Option<std::string::String>,
    /// <p>The <code>VpcLink</code> ID of the API Gateway proxy. </p>
    pub vpc_link_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the Network Load Balancer configured by the API Gateway proxy. </p>
    pub nlb_arn: std::option::Option<std::string::String>,
    /// <p>The name of the Network Load Balancer that is configured by the API Gateway proxy. </p>
    pub nlb_name: std::option::Option<std::string::String>,
    /// <p>The type of API Gateway endpoint created. </p>
    pub endpoint_type: std::option::Option<crate::model::ApiGatewayEndpointType>,
    /// <p>The name of the API Gateway stage. The name defaults to <code>prod</code>. </p>
    pub stage_name: std::option::Option<std::string::String>,
}
impl ApiGatewayProxySummary {
    /// <p>The endpoint URL of the API Gateway proxy. </p>
    pub fn proxy_url(&self) -> std::option::Option<&str> {
        self.proxy_url.as_deref()
    }
    /// <p>The resource ID of the API Gateway for the proxy. </p>
    pub fn api_gateway_id(&self) -> std::option::Option<&str> {
        self.api_gateway_id.as_deref()
    }
    /// <p>The <code>VpcLink</code> ID of the API Gateway proxy. </p>
    pub fn vpc_link_id(&self) -> std::option::Option<&str> {
        self.vpc_link_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Network Load Balancer configured by the API Gateway proxy. </p>
    pub fn nlb_arn(&self) -> std::option::Option<&str> {
        self.nlb_arn.as_deref()
    }
    /// <p>The name of the Network Load Balancer that is configured by the API Gateway proxy. </p>
    pub fn nlb_name(&self) -> std::option::Option<&str> {
        self.nlb_name.as_deref()
    }
    /// <p>The type of API Gateway endpoint created. </p>
    pub fn endpoint_type(&self) -> std::option::Option<&crate::model::ApiGatewayEndpointType> {
        self.endpoint_type.as_ref()
    }
    /// <p>The name of the API Gateway stage. The name defaults to <code>prod</code>. </p>
    pub fn stage_name(&self) -> std::option::Option<&str> {
        self.stage_name.as_deref()
    }
}
impl std::fmt::Debug for ApiGatewayProxySummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApiGatewayProxySummary");
        formatter.field("proxy_url", &self.proxy_url);
        formatter.field("api_gateway_id", &self.api_gateway_id);
        formatter.field("vpc_link_id", &self.vpc_link_id);
        formatter.field("nlb_arn", &self.nlb_arn);
        formatter.field("nlb_name", &self.nlb_name);
        formatter.field("endpoint_type", &self.endpoint_type);
        formatter.field("stage_name", &self.stage_name);
        formatter.finish()
    }
}
/// See [`ApiGatewayProxySummary`](crate::model::ApiGatewayProxySummary)
pub mod api_gateway_proxy_summary {
    /// A builder for [`ApiGatewayProxySummary`](crate::model::ApiGatewayProxySummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) proxy_url: std::option::Option<std::string::String>,
        pub(crate) api_gateway_id: std::option::Option<std::string::String>,
        pub(crate) vpc_link_id: std::option::Option<std::string::String>,
        pub(crate) nlb_arn: std::option::Option<std::string::String>,
        pub(crate) nlb_name: std::option::Option<std::string::String>,
        pub(crate) endpoint_type: std::option::Option<crate::model::ApiGatewayEndpointType>,
        pub(crate) stage_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The endpoint URL of the API Gateway proxy. </p>
        pub fn proxy_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.proxy_url = Some(input.into());
            self
        }
        /// <p>The endpoint URL of the API Gateway proxy. </p>
        pub fn set_proxy_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.proxy_url = input;
            self
        }
        /// <p>The resource ID of the API Gateway for the proxy. </p>
        pub fn api_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_gateway_id = Some(input.into());
            self
        }
        /// <p>The resource ID of the API Gateway for the proxy. </p>
        pub fn set_api_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.api_gateway_id = input;
            self
        }
        /// <p>The <code>VpcLink</code> ID of the API Gateway proxy. </p>
        pub fn vpc_link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_link_id = Some(input.into());
            self
        }
        /// <p>The <code>VpcLink</code> ID of the API Gateway proxy. </p>
        pub fn set_vpc_link_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_link_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Network Load Balancer configured by the API Gateway proxy. </p>
        pub fn nlb_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.nlb_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Network Load Balancer configured by the API Gateway proxy. </p>
        pub fn set_nlb_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.nlb_arn = input;
            self
        }
        /// <p>The name of the Network Load Balancer that is configured by the API Gateway proxy. </p>
        pub fn nlb_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.nlb_name = Some(input.into());
            self
        }
        /// <p>The name of the Network Load Balancer that is configured by the API Gateway proxy. </p>
        pub fn set_nlb_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.nlb_name = input;
            self
        }
        /// <p>The type of API Gateway endpoint created. </p>
        pub fn endpoint_type(mut self, input: crate::model::ApiGatewayEndpointType) -> Self {
            self.endpoint_type = Some(input);
            self
        }
        /// <p>The type of API Gateway endpoint created. </p>
        pub fn set_endpoint_type(
            mut self,
            input: std::option::Option<crate::model::ApiGatewayEndpointType>,
        ) -> Self {
            self.endpoint_type = input;
            self
        }
        /// <p>The name of the API Gateway stage. The name defaults to <code>prod</code>. </p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stage_name = Some(input.into());
            self
        }
        /// <p>The name of the API Gateway stage. The name defaults to <code>prod</code>. </p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stage_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ApiGatewayProxySummary`](crate::model::ApiGatewayProxySummary)
        pub fn build(self) -> crate::model::ApiGatewayProxySummary {
            crate::model::ApiGatewayProxySummary {
                proxy_url: self.proxy_url,
                api_gateway_id: self.api_gateway_id,
                vpc_link_id: self.vpc_link_id,
                nlb_arn: self.nlb_arn,
                nlb_name: self.nlb_name,
                endpoint_type: self.endpoint_type,
                stage_name: self.stage_name,
            }
        }
    }
}
impl ApiGatewayProxySummary {
    /// Creates a new builder-style object to manufacture [`ApiGatewayProxySummary`](crate::model::ApiGatewayProxySummary)
    pub fn builder() -> crate::model::api_gateway_proxy_summary::Builder {
        crate::model::api_gateway_proxy_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ApiGatewayEndpointType {
    #[allow(missing_docs)] // documentation missing in model
    Private,
    #[allow(missing_docs)] // documentation missing in model
    Regional,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ApiGatewayEndpointType {
    fn from(s: &str) -> Self {
        match s {
            "PRIVATE" => ApiGatewayEndpointType::Private,
            "REGIONAL" => ApiGatewayEndpointType::Regional,
            other => ApiGatewayEndpointType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ApiGatewayEndpointType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ApiGatewayEndpointType::from(s))
    }
}
impl ApiGatewayEndpointType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ApiGatewayEndpointType::Private => "PRIVATE",
            ApiGatewayEndpointType::Regional => "REGIONAL",
            ApiGatewayEndpointType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PRIVATE", "REGIONAL"]
    }
}
impl AsRef<str> for ApiGatewayEndpointType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ProxyType {
    #[allow(missing_docs)] // documentation missing in model
    ApiGateway,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ProxyType {
    fn from(s: &str) -> Self {
        match s {
            "API_GATEWAY" => ProxyType::ApiGateway,
            other => ProxyType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ProxyType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ProxyType::from(s))
    }
}
impl ProxyType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ProxyType::ApiGateway => "API_GATEWAY",
            ProxyType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["API_GATEWAY"]
    }
}
impl AsRef<str> for ProxyType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The configuration for the Lambda endpoint type. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LambdaEndpointConfig {
    /// <p>The Amazon Resource Name (ARN) of the Lambda endpoint. </p>
    pub arn: std::option::Option<std::string::String>,
}
impl LambdaEndpointConfig {
    /// <p>The Amazon Resource Name (ARN) of the Lambda endpoint. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for LambdaEndpointConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LambdaEndpointConfig");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`LambdaEndpointConfig`](crate::model::LambdaEndpointConfig)
pub mod lambda_endpoint_config {
    /// A builder for [`LambdaEndpointConfig`](crate::model::LambdaEndpointConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the Lambda endpoint. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Lambda endpoint. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`LambdaEndpointConfig`](crate::model::LambdaEndpointConfig)
        pub fn build(self) -> crate::model::LambdaEndpointConfig {
            crate::model::LambdaEndpointConfig { arn: self.arn }
        }
    }
}
impl LambdaEndpointConfig {
    /// Creates a new builder-style object to manufacture [`LambdaEndpointConfig`](crate::model::LambdaEndpointConfig)
    pub fn builder() -> crate::model::lambda_endpoint_config::Builder {
        crate::model::lambda_endpoint_config::Builder::default()
    }
}

/// <p>The configuration for the URL endpoint type. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UrlEndpointConfig {
    /// <p>The HTTP URL endpoint. </p>
    pub url: std::option::Option<std::string::String>,
    /// <p>The health check URL of the URL endpoint type. </p>
    pub health_url: std::option::Option<std::string::String>,
}
impl UrlEndpointConfig {
    /// <p>The HTTP URL endpoint. </p>
    pub fn url(&self) -> std::option::Option<&str> {
        self.url.as_deref()
    }
    /// <p>The health check URL of the URL endpoint type. </p>
    pub fn health_url(&self) -> std::option::Option<&str> {
        self.health_url.as_deref()
    }
}
impl std::fmt::Debug for UrlEndpointConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UrlEndpointConfig");
        formatter.field("url", &self.url);
        formatter.field("health_url", &self.health_url);
        formatter.finish()
    }
}
/// See [`UrlEndpointConfig`](crate::model::UrlEndpointConfig)
pub mod url_endpoint_config {
    /// A builder for [`UrlEndpointConfig`](crate::model::UrlEndpointConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) url: std::option::Option<std::string::String>,
        pub(crate) health_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The HTTP URL endpoint. </p>
        pub fn url(mut self, input: impl Into<std::string::String>) -> Self {
            self.url = Some(input.into());
            self
        }
        /// <p>The HTTP URL endpoint. </p>
        pub fn set_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.url = input;
            self
        }
        /// <p>The health check URL of the URL endpoint type. </p>
        pub fn health_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.health_url = Some(input.into());
            self
        }
        /// <p>The health check URL of the URL endpoint type. </p>
        pub fn set_health_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.health_url = input;
            self
        }
        /// Consumes the builder and constructs a [`UrlEndpointConfig`](crate::model::UrlEndpointConfig)
        pub fn build(self) -> crate::model::UrlEndpointConfig {
            crate::model::UrlEndpointConfig {
                url: self.url,
                health_url: self.health_url,
            }
        }
    }
}
impl UrlEndpointConfig {
    /// Creates a new builder-style object to manufacture [`UrlEndpointConfig`](crate::model::UrlEndpointConfig)
    pub fn builder() -> crate::model::url_endpoint_config::Builder {
        crate::model::url_endpoint_config::Builder::default()
    }
}

/// <p>A wrapper object holding the Amazon API Gateway proxy configuration. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApiGatewayProxyConfig {
    /// <p>The endpoint URL of the API Gateway proxy. </p>
    pub proxy_url: std::option::Option<std::string::String>,
    /// <p>The resource ID of the API Gateway for the proxy. </p>
    pub api_gateway_id: std::option::Option<std::string::String>,
    /// <p>The <code>VpcLink</code> ID of the API Gateway proxy. </p>
    pub vpc_link_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the Network Load Balancer configured by the API Gateway proxy. </p>
    pub nlb_arn: std::option::Option<std::string::String>,
    /// <p>The name of the Network Load Balancer that is configured by the API Gateway proxy. </p>
    pub nlb_name: std::option::Option<std::string::String>,
    /// <p>The type of API Gateway endpoint created. </p>
    pub endpoint_type: std::option::Option<crate::model::ApiGatewayEndpointType>,
    /// <p>The name of the API Gateway stage. The name defaults to <code>prod</code>. </p>
    pub stage_name: std::option::Option<std::string::String>,
}
impl ApiGatewayProxyConfig {
    /// <p>The endpoint URL of the API Gateway proxy. </p>
    pub fn proxy_url(&self) -> std::option::Option<&str> {
        self.proxy_url.as_deref()
    }
    /// <p>The resource ID of the API Gateway for the proxy. </p>
    pub fn api_gateway_id(&self) -> std::option::Option<&str> {
        self.api_gateway_id.as_deref()
    }
    /// <p>The <code>VpcLink</code> ID of the API Gateway proxy. </p>
    pub fn vpc_link_id(&self) -> std::option::Option<&str> {
        self.vpc_link_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Network Load Balancer configured by the API Gateway proxy. </p>
    pub fn nlb_arn(&self) -> std::option::Option<&str> {
        self.nlb_arn.as_deref()
    }
    /// <p>The name of the Network Load Balancer that is configured by the API Gateway proxy. </p>
    pub fn nlb_name(&self) -> std::option::Option<&str> {
        self.nlb_name.as_deref()
    }
    /// <p>The type of API Gateway endpoint created. </p>
    pub fn endpoint_type(&self) -> std::option::Option<&crate::model::ApiGatewayEndpointType> {
        self.endpoint_type.as_ref()
    }
    /// <p>The name of the API Gateway stage. The name defaults to <code>prod</code>. </p>
    pub fn stage_name(&self) -> std::option::Option<&str> {
        self.stage_name.as_deref()
    }
}
impl std::fmt::Debug for ApiGatewayProxyConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApiGatewayProxyConfig");
        formatter.field("proxy_url", &self.proxy_url);
        formatter.field("api_gateway_id", &self.api_gateway_id);
        formatter.field("vpc_link_id", &self.vpc_link_id);
        formatter.field("nlb_arn", &self.nlb_arn);
        formatter.field("nlb_name", &self.nlb_name);
        formatter.field("endpoint_type", &self.endpoint_type);
        formatter.field("stage_name", &self.stage_name);
        formatter.finish()
    }
}
/// See [`ApiGatewayProxyConfig`](crate::model::ApiGatewayProxyConfig)
pub mod api_gateway_proxy_config {
    /// A builder for [`ApiGatewayProxyConfig`](crate::model::ApiGatewayProxyConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) proxy_url: std::option::Option<std::string::String>,
        pub(crate) api_gateway_id: std::option::Option<std::string::String>,
        pub(crate) vpc_link_id: std::option::Option<std::string::String>,
        pub(crate) nlb_arn: std::option::Option<std::string::String>,
        pub(crate) nlb_name: std::option::Option<std::string::String>,
        pub(crate) endpoint_type: std::option::Option<crate::model::ApiGatewayEndpointType>,
        pub(crate) stage_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The endpoint URL of the API Gateway proxy. </p>
        pub fn proxy_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.proxy_url = Some(input.into());
            self
        }
        /// <p>The endpoint URL of the API Gateway proxy. </p>
        pub fn set_proxy_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.proxy_url = input;
            self
        }
        /// <p>The resource ID of the API Gateway for the proxy. </p>
        pub fn api_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_gateway_id = Some(input.into());
            self
        }
        /// <p>The resource ID of the API Gateway for the proxy. </p>
        pub fn set_api_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.api_gateway_id = input;
            self
        }
        /// <p>The <code>VpcLink</code> ID of the API Gateway proxy. </p>
        pub fn vpc_link_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_link_id = Some(input.into());
            self
        }
        /// <p>The <code>VpcLink</code> ID of the API Gateway proxy. </p>
        pub fn set_vpc_link_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_link_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Network Load Balancer configured by the API Gateway proxy. </p>
        pub fn nlb_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.nlb_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Network Load Balancer configured by the API Gateway proxy. </p>
        pub fn set_nlb_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.nlb_arn = input;
            self
        }
        /// <p>The name of the Network Load Balancer that is configured by the API Gateway proxy. </p>
        pub fn nlb_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.nlb_name = Some(input.into());
            self
        }
        /// <p>The name of the Network Load Balancer that is configured by the API Gateway proxy. </p>
        pub fn set_nlb_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.nlb_name = input;
            self
        }
        /// <p>The type of API Gateway endpoint created. </p>
        pub fn endpoint_type(mut self, input: crate::model::ApiGatewayEndpointType) -> Self {
            self.endpoint_type = Some(input);
            self
        }
        /// <p>The type of API Gateway endpoint created. </p>
        pub fn set_endpoint_type(
            mut self,
            input: std::option::Option<crate::model::ApiGatewayEndpointType>,
        ) -> Self {
            self.endpoint_type = input;
            self
        }
        /// <p>The name of the API Gateway stage. The name defaults to <code>prod</code>. </p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stage_name = Some(input.into());
            self
        }
        /// <p>The name of the API Gateway stage. The name defaults to <code>prod</code>. </p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stage_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ApiGatewayProxyConfig`](crate::model::ApiGatewayProxyConfig)
        pub fn build(self) -> crate::model::ApiGatewayProxyConfig {
            crate::model::ApiGatewayProxyConfig {
                proxy_url: self.proxy_url,
                api_gateway_id: self.api_gateway_id,
                vpc_link_id: self.vpc_link_id,
                nlb_arn: self.nlb_arn,
                nlb_name: self.nlb_name,
                endpoint_type: self.endpoint_type,
                stage_name: self.stage_name,
            }
        }
    }
}
impl ApiGatewayProxyConfig {
    /// Creates a new builder-style object to manufacture [`ApiGatewayProxyConfig`](crate::model::ApiGatewayProxyConfig)
    pub fn builder() -> crate::model::api_gateway_proxy_config::Builder {
        crate::model::api_gateway_proxy_config::Builder::default()
    }
}

/// <p>The input for the Lambda endpoint type. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LambdaEndpointInput {
    /// <p>The Amazon Resource Name (ARN) of the Lambda endpoint. </p>
    pub arn: std::option::Option<std::string::String>,
}
impl LambdaEndpointInput {
    /// <p>The Amazon Resource Name (ARN) of the Lambda endpoint. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for LambdaEndpointInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LambdaEndpointInput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`LambdaEndpointInput`](crate::model::LambdaEndpointInput)
pub mod lambda_endpoint_input {
    /// A builder for [`LambdaEndpointInput`](crate::model::LambdaEndpointInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the Lambda endpoint. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Lambda endpoint. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`LambdaEndpointInput`](crate::model::LambdaEndpointInput)
        pub fn build(self) -> crate::model::LambdaEndpointInput {
            crate::model::LambdaEndpointInput { arn: self.arn }
        }
    }
}
impl LambdaEndpointInput {
    /// Creates a new builder-style object to manufacture [`LambdaEndpointInput`](crate::model::LambdaEndpointInput)
    pub fn builder() -> crate::model::lambda_endpoint_input::Builder {
        crate::model::lambda_endpoint_input::Builder::default()
    }
}

/// <p>The configuration for the URL endpoint type. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UrlEndpointInput {
    /// <p>The URL to route traffic to. The URL must be an <a href="https://datatracker.ietf.org/doc/html/rfc3986">rfc3986-formatted URL</a>. If the host is a domain name, the name must be resolvable over the public internet. If the scheme is <code>https</code>, the top level domain of the host must be listed in the <a href="https://www.iana.org/domains/root/db">IANA root zone database</a>. </p>
    pub url: std::option::Option<std::string::String>,
    /// <p>The health check URL of the URL endpoint type. If the URL is a public endpoint, the <code>HealthUrl</code> must also be a public endpoint. If the URL is a private endpoint inside a virtual private cloud (VPC), the health URL must also be a private endpoint, and the host must be the same as the URL. </p>
    pub health_url: std::option::Option<std::string::String>,
}
impl UrlEndpointInput {
    /// <p>The URL to route traffic to. The URL must be an <a href="https://datatracker.ietf.org/doc/html/rfc3986">rfc3986-formatted URL</a>. If the host is a domain name, the name must be resolvable over the public internet. If the scheme is <code>https</code>, the top level domain of the host must be listed in the <a href="https://www.iana.org/domains/root/db">IANA root zone database</a>. </p>
    pub fn url(&self) -> std::option::Option<&str> {
        self.url.as_deref()
    }
    /// <p>The health check URL of the URL endpoint type. If the URL is a public endpoint, the <code>HealthUrl</code> must also be a public endpoint. If the URL is a private endpoint inside a virtual private cloud (VPC), the health URL must also be a private endpoint, and the host must be the same as the URL. </p>
    pub fn health_url(&self) -> std::option::Option<&str> {
        self.health_url.as_deref()
    }
}
impl std::fmt::Debug for UrlEndpointInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UrlEndpointInput");
        formatter.field("url", &self.url);
        formatter.field("health_url", &self.health_url);
        formatter.finish()
    }
}
/// See [`UrlEndpointInput`](crate::model::UrlEndpointInput)
pub mod url_endpoint_input {
    /// A builder for [`UrlEndpointInput`](crate::model::UrlEndpointInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) url: std::option::Option<std::string::String>,
        pub(crate) health_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The URL to route traffic to. The URL must be an <a href="https://datatracker.ietf.org/doc/html/rfc3986">rfc3986-formatted URL</a>. If the host is a domain name, the name must be resolvable over the public internet. If the scheme is <code>https</code>, the top level domain of the host must be listed in the <a href="https://www.iana.org/domains/root/db">IANA root zone database</a>. </p>
        pub fn url(mut self, input: impl Into<std::string::String>) -> Self {
            self.url = Some(input.into());
            self
        }
        /// <p>The URL to route traffic to. The URL must be an <a href="https://datatracker.ietf.org/doc/html/rfc3986">rfc3986-formatted URL</a>. If the host is a domain name, the name must be resolvable over the public internet. If the scheme is <code>https</code>, the top level domain of the host must be listed in the <a href="https://www.iana.org/domains/root/db">IANA root zone database</a>. </p>
        pub fn set_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.url = input;
            self
        }
        /// <p>The health check URL of the URL endpoint type. If the URL is a public endpoint, the <code>HealthUrl</code> must also be a public endpoint. If the URL is a private endpoint inside a virtual private cloud (VPC), the health URL must also be a private endpoint, and the host must be the same as the URL. </p>
        pub fn health_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.health_url = Some(input.into());
            self
        }
        /// <p>The health check URL of the URL endpoint type. If the URL is a public endpoint, the <code>HealthUrl</code> must also be a public endpoint. If the URL is a private endpoint inside a virtual private cloud (VPC), the health URL must also be a private endpoint, and the host must be the same as the URL. </p>
        pub fn set_health_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.health_url = input;
            self
        }
        /// Consumes the builder and constructs a [`UrlEndpointInput`](crate::model::UrlEndpointInput)
        pub fn build(self) -> crate::model::UrlEndpointInput {
            crate::model::UrlEndpointInput {
                url: self.url,
                health_url: self.health_url,
            }
        }
    }
}
impl UrlEndpointInput {
    /// Creates a new builder-style object to manufacture [`UrlEndpointInput`](crate::model::UrlEndpointInput)
    pub fn builder() -> crate::model::url_endpoint_input::Builder {
        crate::model::url_endpoint_input::Builder::default()
    }
}

/// <p>The configuration for the URI path route type. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UriPathRouteInput {
    /// <p>The path to use to match traffic. Paths must start with <code>/</code> and are relative to the base of the application.</p>
    pub source_path: std::option::Option<std::string::String>,
    /// <p>Indicates whether traffic is forwarded to this route’s service after the route is created. </p>
    pub activation_state: std::option::Option<crate::model::RouteActivationState>,
    /// <p>A list of HTTP methods to match. An empty list matches all values. If a method is present, only HTTP requests using that method are forwarded to this route’s service. </p>
    pub methods: std::option::Option<std::vec::Vec<crate::model::HttpMethod>>,
    /// <p>Indicates whether to match all subpaths of the given source path. If this value is <code>false</code>, requests must match the source path exactly before they are forwarded to this route's service. </p>
    pub include_child_paths: std::option::Option<bool>,
}
impl UriPathRouteInput {
    /// <p>The path to use to match traffic. Paths must start with <code>/</code> and are relative to the base of the application.</p>
    pub fn source_path(&self) -> std::option::Option<&str> {
        self.source_path.as_deref()
    }
    /// <p>Indicates whether traffic is forwarded to this route’s service after the route is created. </p>
    pub fn activation_state(&self) -> std::option::Option<&crate::model::RouteActivationState> {
        self.activation_state.as_ref()
    }
    /// <p>A list of HTTP methods to match. An empty list matches all values. If a method is present, only HTTP requests using that method are forwarded to this route’s service. </p>
    pub fn methods(&self) -> std::option::Option<&[crate::model::HttpMethod]> {
        self.methods.as_deref()
    }
    /// <p>Indicates whether to match all subpaths of the given source path. If this value is <code>false</code>, requests must match the source path exactly before they are forwarded to this route's service. </p>
    pub fn include_child_paths(&self) -> std::option::Option<bool> {
        self.include_child_paths
    }
}
impl std::fmt::Debug for UriPathRouteInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UriPathRouteInput");
        formatter.field("source_path", &self.source_path);
        formatter.field("activation_state", &self.activation_state);
        formatter.field("methods", &self.methods);
        formatter.field("include_child_paths", &self.include_child_paths);
        formatter.finish()
    }
}
/// See [`UriPathRouteInput`](crate::model::UriPathRouteInput)
pub mod uri_path_route_input {
    /// A builder for [`UriPathRouteInput`](crate::model::UriPathRouteInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_path: std::option::Option<std::string::String>,
        pub(crate) activation_state: std::option::Option<crate::model::RouteActivationState>,
        pub(crate) methods: std::option::Option<std::vec::Vec<crate::model::HttpMethod>>,
        pub(crate) include_child_paths: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The path to use to match traffic. Paths must start with <code>/</code> and are relative to the base of the application.</p>
        pub fn source_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_path = Some(input.into());
            self
        }
        /// <p>The path to use to match traffic. Paths must start with <code>/</code> and are relative to the base of the application.</p>
        pub fn set_source_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_path = input;
            self
        }
        /// <p>Indicates whether traffic is forwarded to this route’s service after the route is created. </p>
        pub fn activation_state(mut self, input: crate::model::RouteActivationState) -> Self {
            self.activation_state = Some(input);
            self
        }
        /// <p>Indicates whether traffic is forwarded to this route’s service after the route is created. </p>
        pub fn set_activation_state(
            mut self,
            input: std::option::Option<crate::model::RouteActivationState>,
        ) -> Self {
            self.activation_state = input;
            self
        }
        /// Appends an item to `methods`.
        ///
        /// To override the contents of this collection use [`set_methods`](Self::set_methods).
        ///
        /// <p>A list of HTTP methods to match. An empty list matches all values. If a method is present, only HTTP requests using that method are forwarded to this route’s service. </p>
        pub fn methods(mut self, input: crate::model::HttpMethod) -> Self {
            let mut v = self.methods.unwrap_or_default();
            v.push(input);
            self.methods = Some(v);
            self
        }
        /// <p>A list of HTTP methods to match. An empty list matches all values. If a method is present, only HTTP requests using that method are forwarded to this route’s service. </p>
        pub fn set_methods(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HttpMethod>>,
        ) -> Self {
            self.methods = input;
            self
        }
        /// <p>Indicates whether to match all subpaths of the given source path. If this value is <code>false</code>, requests must match the source path exactly before they are forwarded to this route's service. </p>
        pub fn include_child_paths(mut self, input: bool) -> Self {
            self.include_child_paths = Some(input);
            self
        }
        /// <p>Indicates whether to match all subpaths of the given source path. If this value is <code>false</code>, requests must match the source path exactly before they are forwarded to this route's service. </p>
        pub fn set_include_child_paths(mut self, input: std::option::Option<bool>) -> Self {
            self.include_child_paths = input;
            self
        }
        /// Consumes the builder and constructs a [`UriPathRouteInput`](crate::model::UriPathRouteInput)
        pub fn build(self) -> crate::model::UriPathRouteInput {
            crate::model::UriPathRouteInput {
                source_path: self.source_path,
                activation_state: self.activation_state,
                methods: self.methods,
                include_child_paths: self.include_child_paths,
            }
        }
    }
}
impl UriPathRouteInput {
    /// Creates a new builder-style object to manufacture [`UriPathRouteInput`](crate::model::UriPathRouteInput)
    pub fn builder() -> crate::model::uri_path_route_input::Builder {
        crate::model::uri_path_route_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RouteActivationState {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RouteActivationState {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => RouteActivationState::Active,
            other => RouteActivationState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RouteActivationState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RouteActivationState::from(s))
    }
}
impl RouteActivationState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RouteActivationState::Active => "ACTIVE",
            RouteActivationState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE"]
    }
}
impl AsRef<str> for RouteActivationState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A wrapper object holding the Amazon API Gateway endpoint input. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApiGatewayProxyInput {
    /// <p>The type of endpoint to use for the API Gateway proxy. If no value is specified in the request, the value is set to <code>REGIONAL</code> by default.</p>
    /// <p>If the value is set to <code>PRIVATE</code> in the request, this creates a private API endpoint that is isolated from the public internet. The private endpoint can only be accessed by using Amazon Virtual Private Cloud (Amazon VPC) endpoints for Amazon API Gateway that have been granted access. </p>
    pub endpoint_type: std::option::Option<crate::model::ApiGatewayEndpointType>,
    /// <p>The name of the API Gateway stage. The name defaults to <code>prod</code>. </p>
    pub stage_name: std::option::Option<std::string::String>,
}
impl ApiGatewayProxyInput {
    /// <p>The type of endpoint to use for the API Gateway proxy. If no value is specified in the request, the value is set to <code>REGIONAL</code> by default.</p>
    /// <p>If the value is set to <code>PRIVATE</code> in the request, this creates a private API endpoint that is isolated from the public internet. The private endpoint can only be accessed by using Amazon Virtual Private Cloud (Amazon VPC) endpoints for Amazon API Gateway that have been granted access. </p>
    pub fn endpoint_type(&self) -> std::option::Option<&crate::model::ApiGatewayEndpointType> {
        self.endpoint_type.as_ref()
    }
    /// <p>The name of the API Gateway stage. The name defaults to <code>prod</code>. </p>
    pub fn stage_name(&self) -> std::option::Option<&str> {
        self.stage_name.as_deref()
    }
}
impl std::fmt::Debug for ApiGatewayProxyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApiGatewayProxyInput");
        formatter.field("endpoint_type", &self.endpoint_type);
        formatter.field("stage_name", &self.stage_name);
        formatter.finish()
    }
}
/// See [`ApiGatewayProxyInput`](crate::model::ApiGatewayProxyInput)
pub mod api_gateway_proxy_input {
    /// A builder for [`ApiGatewayProxyInput`](crate::model::ApiGatewayProxyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_type: std::option::Option<crate::model::ApiGatewayEndpointType>,
        pub(crate) stage_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of endpoint to use for the API Gateway proxy. If no value is specified in the request, the value is set to <code>REGIONAL</code> by default.</p>
        /// <p>If the value is set to <code>PRIVATE</code> in the request, this creates a private API endpoint that is isolated from the public internet. The private endpoint can only be accessed by using Amazon Virtual Private Cloud (Amazon VPC) endpoints for Amazon API Gateway that have been granted access. </p>
        pub fn endpoint_type(mut self, input: crate::model::ApiGatewayEndpointType) -> Self {
            self.endpoint_type = Some(input);
            self
        }
        /// <p>The type of endpoint to use for the API Gateway proxy. If no value is specified in the request, the value is set to <code>REGIONAL</code> by default.</p>
        /// <p>If the value is set to <code>PRIVATE</code> in the request, this creates a private API endpoint that is isolated from the public internet. The private endpoint can only be accessed by using Amazon Virtual Private Cloud (Amazon VPC) endpoints for Amazon API Gateway that have been granted access. </p>
        pub fn set_endpoint_type(
            mut self,
            input: std::option::Option<crate::model::ApiGatewayEndpointType>,
        ) -> Self {
            self.endpoint_type = input;
            self
        }
        /// <p>The name of the API Gateway stage. The name defaults to <code>prod</code>. </p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stage_name = Some(input.into());
            self
        }
        /// <p>The name of the API Gateway stage. The name defaults to <code>prod</code>. </p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stage_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ApiGatewayProxyInput`](crate::model::ApiGatewayProxyInput)
        pub fn build(self) -> crate::model::ApiGatewayProxyInput {
            crate::model::ApiGatewayProxyInput {
                endpoint_type: self.endpoint_type,
                stage_name: self.stage_name,
            }
        }
    }
}
impl ApiGatewayProxyInput {
    /// Creates a new builder-style object to manufacture [`ApiGatewayProxyInput`](crate::model::ApiGatewayProxyInput)
    pub fn builder() -> crate::model::api_gateway_proxy_input::Builder {
        crate::model::api_gateway_proxy_input::Builder::default()
    }
}
