// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `AWSMigrationHubMultiAccountService`.
///
/// This client allows ergonomic access to a `AWSMigrationHubMultiAccountService`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `CreateHomeRegionControl` operation.
    ///
    /// See [`CreateHomeRegionControl`](crate::client::fluent_builders::CreateHomeRegionControl) for more information about the
    /// operation and its arguments.
    pub fn create_home_region_control(&self) -> fluent_builders::CreateHomeRegionControl<C, M, R> {
        fluent_builders::CreateHomeRegionControl::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeHomeRegionControls` operation.
    ///
    /// See [`DescribeHomeRegionControls`](crate::client::fluent_builders::DescribeHomeRegionControls) for more information about the
    /// operation and its arguments.
    pub fn describe_home_region_controls(
        &self,
    ) -> fluent_builders::DescribeHomeRegionControls<C, M, R> {
        fluent_builders::DescribeHomeRegionControls::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetHomeRegion` operation.
    ///
    /// See [`GetHomeRegion`](crate::client::fluent_builders::GetHomeRegion) for more information about the
    /// operation and its arguments.
    pub fn get_home_region(&self) -> fluent_builders::GetHomeRegion<C, M, R> {
        fluent_builders::GetHomeRegion::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateHomeRegionControl`.
    ///
    /// <p>This API sets up the home region for the calling account only.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateHomeRegionControl<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_home_region_control_input::Builder,
    }
    impl<C, M, R> CreateHomeRegionControl<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateHomeRegionControl`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateHomeRegionControlOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateHomeRegionControlError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateHomeRegionControlInputOperationOutputAlias,
                crate::output::CreateHomeRegionControlOutput,
                crate::error::CreateHomeRegionControlError,
                crate::input::CreateHomeRegionControlInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the home region of the calling account.</p>
        pub fn home_region(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.home_region(inp);
            self
        }
        /// <p>The name of the home region of the calling account.</p>
        pub fn set_home_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_home_region(input);
            self
        }
        /// <p>The account for which this command sets up a home region control. The <code>Target</code>
        /// is always of type <code>ACCOUNT</code>.</p>
        pub fn target(mut self, inp: crate::model::Target) -> Self {
            self.inner = self.inner.target(inp);
            self
        }
        /// <p>The account for which this command sets up a home region control. The <code>Target</code>
        /// is always of type <code>ACCOUNT</code>.</p>
        pub fn set_target(mut self, input: std::option::Option<crate::model::Target>) -> Self {
            self.inner = self.inner.set_target(input);
            self
        }
        /// <p>Optional Boolean flag to indicate whether any effect should take place. It tests whether
        /// the caller has permission to make the call.</p>
        pub fn dry_run(mut self, inp: bool) -> Self {
            self.inner = self.inner.dry_run(inp);
            self
        }
        /// <p>Optional Boolean flag to indicate whether any effect should take place. It tests whether
        /// the caller has permission to make the call.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeHomeRegionControls`.
    ///
    /// <p>This API permits filtering on the <code>ControlId</code> and <code>HomeRegion</code>
    /// fields.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeHomeRegionControls<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_home_region_controls_input::Builder,
    }
    impl<C, M, R> DescribeHomeRegionControls<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeHomeRegionControls`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeHomeRegionControlsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeHomeRegionControlsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeHomeRegionControlsInputOperationOutputAlias,
                crate::output::DescribeHomeRegionControlsOutput,
                crate::error::DescribeHomeRegionControlsError,
                crate::input::DescribeHomeRegionControlsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>ControlID</code> is a unique identifier string of your
        /// <code>HomeRegionControl</code> object.</p>
        pub fn control_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.control_id(inp);
            self
        }
        /// <p>The <code>ControlID</code> is a unique identifier string of your
        /// <code>HomeRegionControl</code> object.</p>
        pub fn set_control_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_control_id(input);
            self
        }
        /// <p>The name of the home region you'd like to view.</p>
        pub fn home_region(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.home_region(inp);
            self
        }
        /// <p>The name of the home region you'd like to view.</p>
        pub fn set_home_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_home_region(input);
            self
        }
        /// <p>The target parameter specifies the identifier to which the home region is applied, which
        /// is always of type <code>ACCOUNT</code>. It applies the home region to the current
        /// <code>ACCOUNT</code>.</p>
        pub fn target(mut self, inp: crate::model::Target) -> Self {
            self.inner = self.inner.target(inp);
            self
        }
        /// <p>The target parameter specifies the identifier to which the home region is applied, which
        /// is always of type <code>ACCOUNT</code>. It applies the home region to the current
        /// <code>ACCOUNT</code>.</p>
        pub fn set_target(mut self, input: std::option::Option<crate::model::Target>) -> Self {
            self.inner = self.inner.set_target(input);
            self
        }
        /// <p>The maximum number of filtering results to display per page. </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of filtering results to display per page. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If a <code>NextToken</code> was returned by a previous call, more results are available.
        /// To retrieve the next page of results, make the call again using the returned token in
        /// <code>NextToken</code>.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If a <code>NextToken</code> was returned by a previous call, more results are available.
        /// To retrieve the next page of results, make the call again using the returned token in
        /// <code>NextToken</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetHomeRegion`.
    ///
    /// <p>Returns the calling account’s home region, if configured. This API is used by other AWS
    /// services to determine the regional endpoint for calling AWS Application Discovery Service and
    /// Migration Hub. You must call <code>GetHomeRegion</code> at least once before you call any
    /// other AWS Application Discovery Service and AWS Migration Hub APIs, to obtain the account's
    /// Migration Hub home region.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetHomeRegion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_home_region_input::Builder,
    }
    impl<C, M, R> GetHomeRegion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetHomeRegion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetHomeRegionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetHomeRegionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetHomeRegionInputOperationOutputAlias,
                crate::output::GetHomeRegionOutput,
                crate::error::GetHomeRegionError,
                crate::input::GetHomeRegionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
