// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for AWS Migration Hub
///
/// Client for invoking operations on AWS Migration Hub. Each operation on AWS Migration Hub is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_migrationhub::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_migrationhub::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_migrationhub::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AssociateCreatedArtifact` operation.
    ///
    /// See [`AssociateCreatedArtifact`](crate::client::fluent_builders::AssociateCreatedArtifact) for more information about the
    /// operation and its arguments.
    pub fn associate_created_artifact(&self) -> fluent_builders::AssociateCreatedArtifact<C, M, R> {
        fluent_builders::AssociateCreatedArtifact::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateDiscoveredResource` operation.
    ///
    /// See [`AssociateDiscoveredResource`](crate::client::fluent_builders::AssociateDiscoveredResource) for more information about the
    /// operation and its arguments.
    pub fn associate_discovered_resource(
        &self,
    ) -> fluent_builders::AssociateDiscoveredResource<C, M, R> {
        fluent_builders::AssociateDiscoveredResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateProgressUpdateStream` operation.
    ///
    /// See [`CreateProgressUpdateStream`](crate::client::fluent_builders::CreateProgressUpdateStream) for more information about the
    /// operation and its arguments.
    pub fn create_progress_update_stream(
        &self,
    ) -> fluent_builders::CreateProgressUpdateStream<C, M, R> {
        fluent_builders::CreateProgressUpdateStream::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteProgressUpdateStream` operation.
    ///
    /// See [`DeleteProgressUpdateStream`](crate::client::fluent_builders::DeleteProgressUpdateStream) for more information about the
    /// operation and its arguments.
    pub fn delete_progress_update_stream(
        &self,
    ) -> fluent_builders::DeleteProgressUpdateStream<C, M, R> {
        fluent_builders::DeleteProgressUpdateStream::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeApplicationState` operation.
    ///
    /// See [`DescribeApplicationState`](crate::client::fluent_builders::DescribeApplicationState) for more information about the
    /// operation and its arguments.
    pub fn describe_application_state(&self) -> fluent_builders::DescribeApplicationState<C, M, R> {
        fluent_builders::DescribeApplicationState::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeMigrationTask` operation.
    ///
    /// See [`DescribeMigrationTask`](crate::client::fluent_builders::DescribeMigrationTask) for more information about the
    /// operation and its arguments.
    pub fn describe_migration_task(&self) -> fluent_builders::DescribeMigrationTask<C, M, R> {
        fluent_builders::DescribeMigrationTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateCreatedArtifact` operation.
    ///
    /// See [`DisassociateCreatedArtifact`](crate::client::fluent_builders::DisassociateCreatedArtifact) for more information about the
    /// operation and its arguments.
    pub fn disassociate_created_artifact(
        &self,
    ) -> fluent_builders::DisassociateCreatedArtifact<C, M, R> {
        fluent_builders::DisassociateCreatedArtifact::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateDiscoveredResource` operation.
    ///
    /// See [`DisassociateDiscoveredResource`](crate::client::fluent_builders::DisassociateDiscoveredResource) for more information about the
    /// operation and its arguments.
    pub fn disassociate_discovered_resource(
        &self,
    ) -> fluent_builders::DisassociateDiscoveredResource<C, M, R> {
        fluent_builders::DisassociateDiscoveredResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ImportMigrationTask` operation.
    ///
    /// See [`ImportMigrationTask`](crate::client::fluent_builders::ImportMigrationTask) for more information about the
    /// operation and its arguments.
    pub fn import_migration_task(&self) -> fluent_builders::ImportMigrationTask<C, M, R> {
        fluent_builders::ImportMigrationTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListApplicationStates` operation.
    ///
    /// See [`ListApplicationStates`](crate::client::fluent_builders::ListApplicationStates) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListApplicationStates::into_paginator).
    pub fn list_application_states(&self) -> fluent_builders::ListApplicationStates<C, M, R> {
        fluent_builders::ListApplicationStates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListCreatedArtifacts` operation.
    ///
    /// See [`ListCreatedArtifacts`](crate::client::fluent_builders::ListCreatedArtifacts) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListCreatedArtifacts::into_paginator).
    pub fn list_created_artifacts(&self) -> fluent_builders::ListCreatedArtifacts<C, M, R> {
        fluent_builders::ListCreatedArtifacts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDiscoveredResources` operation.
    ///
    /// See [`ListDiscoveredResources`](crate::client::fluent_builders::ListDiscoveredResources) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListDiscoveredResources::into_paginator).
    pub fn list_discovered_resources(&self) -> fluent_builders::ListDiscoveredResources<C, M, R> {
        fluent_builders::ListDiscoveredResources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListMigrationTasks` operation.
    ///
    /// See [`ListMigrationTasks`](crate::client::fluent_builders::ListMigrationTasks) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListMigrationTasks::into_paginator).
    pub fn list_migration_tasks(&self) -> fluent_builders::ListMigrationTasks<C, M, R> {
        fluent_builders::ListMigrationTasks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListProgressUpdateStreams` operation.
    ///
    /// See [`ListProgressUpdateStreams`](crate::client::fluent_builders::ListProgressUpdateStreams) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListProgressUpdateStreams::into_paginator).
    pub fn list_progress_update_streams(
        &self,
    ) -> fluent_builders::ListProgressUpdateStreams<C, M, R> {
        fluent_builders::ListProgressUpdateStreams::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `NotifyApplicationState` operation.
    ///
    /// See [`NotifyApplicationState`](crate::client::fluent_builders::NotifyApplicationState) for more information about the
    /// operation and its arguments.
    pub fn notify_application_state(&self) -> fluent_builders::NotifyApplicationState<C, M, R> {
        fluent_builders::NotifyApplicationState::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `NotifyMigrationTaskState` operation.
    ///
    /// See [`NotifyMigrationTaskState`](crate::client::fluent_builders::NotifyMigrationTaskState) for more information about the
    /// operation and its arguments.
    pub fn notify_migration_task_state(
        &self,
    ) -> fluent_builders::NotifyMigrationTaskState<C, M, R> {
        fluent_builders::NotifyMigrationTaskState::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutResourceAttributes` operation.
    ///
    /// See [`PutResourceAttributes`](crate::client::fluent_builders::PutResourceAttributes) for more information about the
    /// operation and its arguments.
    pub fn put_resource_attributes(&self) -> fluent_builders::PutResourceAttributes<C, M, R> {
        fluent_builders::PutResourceAttributes::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateCreatedArtifact`.
    ///
    /// <p>Associates a created artifact of an AWS cloud resource, the target receiving the migration, with the migration task performed by a migration tool. This API has the following traits:</p>
    /// <ul>
    /// <li> <p>Migration tools can call the <code>AssociateCreatedArtifact</code> operation to indicate which AWS artifact is associated with a migration task.</p> </li>
    /// <li> <p>The created artifact name must be provided in ARN (Amazon Resource Name) format which will contain information about type and region; for example: <code>arn:aws:ec2:us-east-1:488216288981:image/ami-6d0ba87b</code>.</p> </li>
    /// <li> <p>Examples of the AWS resource behind the created artifact are, AMI's, EC2 instance, or DMS endpoint, etc.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateCreatedArtifact<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_created_artifact_input::Builder,
    }
    impl<C, M, R> AssociateCreatedArtifact<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateCreatedArtifact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateCreatedArtifactOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateCreatedArtifactError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateCreatedArtifactInputOperationOutputAlias,
                crate::output::AssociateCreatedArtifactOutput,
                crate::error::AssociateCreatedArtifactError,
                crate::input::AssociateCreatedArtifactInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the ProgressUpdateStream. </p>
        pub fn progress_update_stream(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.progress_update_stream(input.into());
            self
        }
        /// <p>The name of the ProgressUpdateStream. </p>
        pub fn set_progress_update_stream(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_progress_update_stream(input);
            self
        }
        /// <p>Unique identifier that references the migration task. <i>Do not store personal data in this field.</i> </p>
        pub fn migration_task_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.migration_task_name(input.into());
            self
        }
        /// <p>Unique identifier that references the migration task. <i>Do not store personal data in this field.</i> </p>
        pub fn set_migration_task_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_migration_task_name(input);
            self
        }
        /// <p>An ARN of the AWS resource related to the migration (e.g., AMI, EC2 instance, RDS instance, etc.) </p>
        pub fn created_artifact(mut self, input: crate::model::CreatedArtifact) -> Self {
            self.inner = self.inner.created_artifact(input);
            self
        }
        /// <p>An ARN of the AWS resource related to the migration (e.g., AMI, EC2 instance, RDS instance, etc.) </p>
        pub fn set_created_artifact(
            mut self,
            input: std::option::Option<crate::model::CreatedArtifact>,
        ) -> Self {
            self.inner = self.inner.set_created_artifact(input);
            self
        }
        /// <p>Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has permission to make the call.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has permission to make the call.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateDiscoveredResource`.
    ///
    /// <p>Associates a discovered resource ID from Application Discovery Service with a migration task.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateDiscoveredResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_discovered_resource_input::Builder,
    }
    impl<C, M, R> AssociateDiscoveredResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateDiscoveredResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateDiscoveredResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateDiscoveredResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateDiscoveredResourceInputOperationOutputAlias,
                crate::output::AssociateDiscoveredResourceOutput,
                crate::error::AssociateDiscoveredResourceError,
                crate::input::AssociateDiscoveredResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the ProgressUpdateStream.</p>
        pub fn progress_update_stream(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.progress_update_stream(input.into());
            self
        }
        /// <p>The name of the ProgressUpdateStream.</p>
        pub fn set_progress_update_stream(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_progress_update_stream(input);
            self
        }
        /// <p>The identifier given to the MigrationTask. <i>Do not store personal data in this field.</i> </p>
        pub fn migration_task_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.migration_task_name(input.into());
            self
        }
        /// <p>The identifier given to the MigrationTask. <i>Do not store personal data in this field.</i> </p>
        pub fn set_migration_task_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_migration_task_name(input);
            self
        }
        /// <p>Object representing a Resource.</p>
        pub fn discovered_resource(mut self, input: crate::model::DiscoveredResource) -> Self {
            self.inner = self.inner.discovered_resource(input);
            self
        }
        /// <p>Object representing a Resource.</p>
        pub fn set_discovered_resource(
            mut self,
            input: std::option::Option<crate::model::DiscoveredResource>,
        ) -> Self {
            self.inner = self.inner.set_discovered_resource(input);
            self
        }
        /// <p>Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has permission to make the call.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has permission to make the call.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateProgressUpdateStream`.
    ///
    /// <p>Creates a progress update stream which is an AWS resource used for access control as well as a namespace for migration task names that is implicitly linked to your AWS account. It must uniquely identify the migration tool as it is used for all updates made by the tool; however, it does not need to be unique for each AWS account because it is scoped to the AWS account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateProgressUpdateStream<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_progress_update_stream_input::Builder,
    }
    impl<C, M, R> CreateProgressUpdateStream<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateProgressUpdateStream`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateProgressUpdateStreamOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateProgressUpdateStreamError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateProgressUpdateStreamInputOperationOutputAlias,
                crate::output::CreateProgressUpdateStreamOutput,
                crate::error::CreateProgressUpdateStreamError,
                crate::input::CreateProgressUpdateStreamInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the ProgressUpdateStream. <i>Do not store personal data in this field.</i> </p>
        pub fn progress_update_stream_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.progress_update_stream_name(input.into());
            self
        }
        /// <p>The name of the ProgressUpdateStream. <i>Do not store personal data in this field.</i> </p>
        pub fn set_progress_update_stream_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_progress_update_stream_name(input);
            self
        }
        /// <p>Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has permission to make the call.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has permission to make the call.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteProgressUpdateStream`.
    ///
    /// <p>Deletes a progress update stream, including all of its tasks, which was previously created as an AWS resource used for access control. This API has the following traits:</p>
    /// <ul>
    /// <li> <p>The only parameter needed for <code>DeleteProgressUpdateStream</code> is the stream name (same as a <code>CreateProgressUpdateStream</code> call).</p> </li>
    /// <li> <p>The call will return, and a background process will asynchronously delete the stream and all of its resources (tasks, associated resources, resource attributes, created artifacts).</p> </li>
    /// <li> <p>If the stream takes time to be deleted, it might still show up on a <code>ListProgressUpdateStreams</code> call.</p> </li>
    /// <li> <p> <code>CreateProgressUpdateStream</code>, <code>ImportMigrationTask</code>, <code>NotifyMigrationTaskState</code>, and all Associate[*] APIs related to the tasks belonging to the stream will throw "InvalidInputException" if the stream of the same name is in the process of being deleted.</p> </li>
    /// <li> <p>Once the stream and all of its resources are deleted, <code>CreateProgressUpdateStream</code> for a stream of the same name will succeed, and that stream will be an entirely new logical resource (without any resources associated with the old stream).</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteProgressUpdateStream<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_progress_update_stream_input::Builder,
    }
    impl<C, M, R> DeleteProgressUpdateStream<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteProgressUpdateStream`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteProgressUpdateStreamOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteProgressUpdateStreamError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteProgressUpdateStreamInputOperationOutputAlias,
                crate::output::DeleteProgressUpdateStreamOutput,
                crate::error::DeleteProgressUpdateStreamError,
                crate::input::DeleteProgressUpdateStreamInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the ProgressUpdateStream. <i>Do not store personal data in this field.</i> </p>
        pub fn progress_update_stream_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.progress_update_stream_name(input.into());
            self
        }
        /// <p>The name of the ProgressUpdateStream. <i>Do not store personal data in this field.</i> </p>
        pub fn set_progress_update_stream_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_progress_update_stream_name(input);
            self
        }
        /// <p>Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has permission to make the call.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has permission to make the call.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeApplicationState`.
    ///
    /// <p>Gets the migration status of an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeApplicationState<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_application_state_input::Builder,
    }
    impl<C, M, R> DescribeApplicationState<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeApplicationState`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeApplicationStateOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeApplicationStateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeApplicationStateInputOperationOutputAlias,
                crate::output::DescribeApplicationStateOutput,
                crate::error::DescribeApplicationStateError,
                crate::input::DescribeApplicationStateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The configurationId in Application Discovery Service that uniquely identifies the grouped application.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The configurationId in Application Discovery Service that uniquely identifies the grouped application.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeMigrationTask`.
    ///
    /// <p>Retrieves a list of all attributes associated with a specific migration task.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeMigrationTask<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_migration_task_input::Builder,
    }
    impl<C, M, R> DescribeMigrationTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeMigrationTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeMigrationTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeMigrationTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeMigrationTaskInputOperationOutputAlias,
                crate::output::DescribeMigrationTaskOutput,
                crate::error::DescribeMigrationTaskError,
                crate::input::DescribeMigrationTaskInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the ProgressUpdateStream. </p>
        pub fn progress_update_stream(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.progress_update_stream(input.into());
            self
        }
        /// <p>The name of the ProgressUpdateStream. </p>
        pub fn set_progress_update_stream(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_progress_update_stream(input);
            self
        }
        /// <p>The identifier given to the MigrationTask. <i>Do not store personal data in this field.</i> </p>
        pub fn migration_task_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.migration_task_name(input.into());
            self
        }
        /// <p>The identifier given to the MigrationTask. <i>Do not store personal data in this field.</i> </p>
        pub fn set_migration_task_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_migration_task_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateCreatedArtifact`.
    ///
    /// <p>Disassociates a created artifact of an AWS resource with a migration task performed by a migration tool that was previously associated. This API has the following traits:</p>
    /// <ul>
    /// <li> <p>A migration user can call the <code>DisassociateCreatedArtifacts</code> operation to disassociate a created AWS Artifact from a migration task.</p> </li>
    /// <li> <p>The created artifact name must be provided in ARN (Amazon Resource Name) format which will contain information about type and region; for example: <code>arn:aws:ec2:us-east-1:488216288981:image/ami-6d0ba87b</code>.</p> </li>
    /// <li> <p>Examples of the AWS resource behind the created artifact are, AMI's, EC2 instance, or RDS instance, etc.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateCreatedArtifact<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_created_artifact_input::Builder,
    }
    impl<C, M, R> DisassociateCreatedArtifact<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateCreatedArtifact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateCreatedArtifactOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateCreatedArtifactError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateCreatedArtifactInputOperationOutputAlias,
                crate::output::DisassociateCreatedArtifactOutput,
                crate::error::DisassociateCreatedArtifactError,
                crate::input::DisassociateCreatedArtifactInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the ProgressUpdateStream. </p>
        pub fn progress_update_stream(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.progress_update_stream(input.into());
            self
        }
        /// <p>The name of the ProgressUpdateStream. </p>
        pub fn set_progress_update_stream(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_progress_update_stream(input);
            self
        }
        /// <p>Unique identifier that references the migration task to be disassociated with the artifact. <i>Do not store personal data in this field.</i> </p>
        pub fn migration_task_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.migration_task_name(input.into());
            self
        }
        /// <p>Unique identifier that references the migration task to be disassociated with the artifact. <i>Do not store personal data in this field.</i> </p>
        pub fn set_migration_task_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_migration_task_name(input);
            self
        }
        /// <p>An ARN of the AWS resource related to the migration (e.g., AMI, EC2 instance, RDS instance, etc.)</p>
        pub fn created_artifact_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.created_artifact_name(input.into());
            self
        }
        /// <p>An ARN of the AWS resource related to the migration (e.g., AMI, EC2 instance, RDS instance, etc.)</p>
        pub fn set_created_artifact_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_created_artifact_name(input);
            self
        }
        /// <p>Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has permission to make the call.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has permission to make the call.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateDiscoveredResource`.
    ///
    /// <p>Disassociate an Application Discovery Service discovered resource from a migration task.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateDiscoveredResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_discovered_resource_input::Builder,
    }
    impl<C, M, R> DisassociateDiscoveredResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateDiscoveredResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateDiscoveredResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateDiscoveredResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateDiscoveredResourceInputOperationOutputAlias,
                crate::output::DisassociateDiscoveredResourceOutput,
                crate::error::DisassociateDiscoveredResourceError,
                crate::input::DisassociateDiscoveredResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the ProgressUpdateStream.</p>
        pub fn progress_update_stream(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.progress_update_stream(input.into());
            self
        }
        /// <p>The name of the ProgressUpdateStream.</p>
        pub fn set_progress_update_stream(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_progress_update_stream(input);
            self
        }
        /// <p>The identifier given to the MigrationTask. <i>Do not store personal data in this field.</i> </p>
        pub fn migration_task_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.migration_task_name(input.into());
            self
        }
        /// <p>The identifier given to the MigrationTask. <i>Do not store personal data in this field.</i> </p>
        pub fn set_migration_task_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_migration_task_name(input);
            self
        }
        /// <p>ConfigurationId of the Application Discovery Service resource to be disassociated.</p>
        pub fn configuration_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_id(input.into());
            self
        }
        /// <p>ConfigurationId of the Application Discovery Service resource to be disassociated.</p>
        pub fn set_configuration_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_id(input);
            self
        }
        /// <p>Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has permission to make the call.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has permission to make the call.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ImportMigrationTask`.
    ///
    /// <p>Registers a new migration task which represents a server, database, etc., being migrated to AWS by a migration tool.</p>
    /// <p>This API is a prerequisite to calling the <code>NotifyMigrationTaskState</code> API as the migration tool must first register the migration task with Migration Hub.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ImportMigrationTask<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::import_migration_task_input::Builder,
    }
    impl<C, M, R> ImportMigrationTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ImportMigrationTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ImportMigrationTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::ImportMigrationTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ImportMigrationTaskInputOperationOutputAlias,
                crate::output::ImportMigrationTaskOutput,
                crate::error::ImportMigrationTaskError,
                crate::input::ImportMigrationTaskInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the ProgressUpdateStream. &gt;</p>
        pub fn progress_update_stream(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.progress_update_stream(input.into());
            self
        }
        /// <p>The name of the ProgressUpdateStream. &gt;</p>
        pub fn set_progress_update_stream(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_progress_update_stream(input);
            self
        }
        /// <p>Unique identifier that references the migration task. <i>Do not store personal data in this field.</i> </p>
        pub fn migration_task_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.migration_task_name(input.into());
            self
        }
        /// <p>Unique identifier that references the migration task. <i>Do not store personal data in this field.</i> </p>
        pub fn set_migration_task_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_migration_task_name(input);
            self
        }
        /// <p>Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has permission to make the call.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has permission to make the call.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListApplicationStates`.
    ///
    /// <p>Lists all the migration statuses for your applications. If you use the optional <code>ApplicationIds</code> parameter, only the migration statuses for those applications will be returned.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListApplicationStates<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_application_states_input::Builder,
    }
    impl<C, M, R> ListApplicationStates<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListApplicationStates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListApplicationStatesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListApplicationStatesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListApplicationStatesInputOperationOutputAlias,
                crate::output::ListApplicationStatesOutput,
                crate::error::ListApplicationStatesError,
                crate::input::ListApplicationStatesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListApplicationStatesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListApplicationStatesPaginator<C, M, R> {
            crate::paginator::ListApplicationStatesPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `ApplicationIds`.
        ///
        /// To override the contents of this collection use [`set_application_ids`](Self::set_application_ids).
        ///
        /// <p>The configurationIds from the Application Discovery Service that uniquely identifies your applications.</p>
        pub fn application_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_ids(input.into());
            self
        }
        /// <p>The configurationIds from the Application Discovery Service that uniquely identifies your applications.</p>
        pub fn set_application_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_application_ids(input);
            self
        }
        /// <p>If a <code>NextToken</code> was returned by a previous call, there are more results available. To retrieve the next page of results, make the call again using the returned token in <code>NextToken</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If a <code>NextToken</code> was returned by a previous call, there are more results available. To retrieve the next page of results, make the call again using the returned token in <code>NextToken</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Maximum number of results to be returned per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Maximum number of results to be returned per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCreatedArtifacts`.
    ///
    /// <p>Lists the created artifacts attached to a given migration task in an update stream. This API has the following traits:</p>
    /// <ul>
    /// <li> <p>Gets the list of the created artifacts while migration is taking place.</p> </li>
    /// <li> <p>Shows the artifacts created by the migration tool that was associated by the <code>AssociateCreatedArtifact</code> API. </p> </li>
    /// <li> <p>Lists created artifacts in a paginated interface. </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListCreatedArtifacts<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_created_artifacts_input::Builder,
    }
    impl<C, M, R> ListCreatedArtifacts<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListCreatedArtifacts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCreatedArtifactsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListCreatedArtifactsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListCreatedArtifactsInputOperationOutputAlias,
                crate::output::ListCreatedArtifactsOutput,
                crate::error::ListCreatedArtifactsError,
                crate::input::ListCreatedArtifactsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListCreatedArtifactsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListCreatedArtifactsPaginator<C, M, R> {
            crate::paginator::ListCreatedArtifactsPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the ProgressUpdateStream. </p>
        pub fn progress_update_stream(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.progress_update_stream(input.into());
            self
        }
        /// <p>The name of the ProgressUpdateStream. </p>
        pub fn set_progress_update_stream(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_progress_update_stream(input);
            self
        }
        /// <p>Unique identifier that references the migration task. <i>Do not store personal data in this field.</i> </p>
        pub fn migration_task_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.migration_task_name(input.into());
            self
        }
        /// <p>Unique identifier that references the migration task. <i>Do not store personal data in this field.</i> </p>
        pub fn set_migration_task_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_migration_task_name(input);
            self
        }
        /// <p>If a <code>NextToken</code> was returned by a previous call, there are more results available. To retrieve the next page of results, make the call again using the returned token in <code>NextToken</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If a <code>NextToken</code> was returned by a previous call, there are more results available. To retrieve the next page of results, make the call again using the returned token in <code>NextToken</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Maximum number of results to be returned per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Maximum number of results to be returned per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDiscoveredResources`.
    ///
    /// <p>Lists discovered resources associated with the given <code>MigrationTask</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDiscoveredResources<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_discovered_resources_input::Builder,
    }
    impl<C, M, R> ListDiscoveredResources<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDiscoveredResources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDiscoveredResourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDiscoveredResourcesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDiscoveredResourcesInputOperationOutputAlias,
                crate::output::ListDiscoveredResourcesOutput,
                crate::error::ListDiscoveredResourcesError,
                crate::input::ListDiscoveredResourcesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDiscoveredResourcesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDiscoveredResourcesPaginator<C, M, R> {
            crate::paginator::ListDiscoveredResourcesPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the ProgressUpdateStream.</p>
        pub fn progress_update_stream(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.progress_update_stream(input.into());
            self
        }
        /// <p>The name of the ProgressUpdateStream.</p>
        pub fn set_progress_update_stream(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_progress_update_stream(input);
            self
        }
        /// <p>The name of the MigrationTask. <i>Do not store personal data in this field.</i> </p>
        pub fn migration_task_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.migration_task_name(input.into());
            self
        }
        /// <p>The name of the MigrationTask. <i>Do not store personal data in this field.</i> </p>
        pub fn set_migration_task_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_migration_task_name(input);
            self
        }
        /// <p>If a <code>NextToken</code> was returned by a previous call, there are more results available. To retrieve the next page of results, make the call again using the returned token in <code>NextToken</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If a <code>NextToken</code> was returned by a previous call, there are more results available. To retrieve the next page of results, make the call again using the returned token in <code>NextToken</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results returned per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results returned per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListMigrationTasks`.
    ///
    /// <p>Lists all, or filtered by resource name, migration tasks associated with the user account making this call. This API has the following traits:</p>
    /// <ul>
    /// <li> <p>Can show a summary list of the most recent migration tasks.</p> </li>
    /// <li> <p>Can show a summary list of migration tasks associated with a given discovered resource.</p> </li>
    /// <li> <p>Lists migration tasks in a paginated interface.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListMigrationTasks<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_migration_tasks_input::Builder,
    }
    impl<C, M, R> ListMigrationTasks<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListMigrationTasks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListMigrationTasksOutput,
            aws_smithy_http::result::SdkError<crate::error::ListMigrationTasksError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListMigrationTasksInputOperationOutputAlias,
                crate::output::ListMigrationTasksOutput,
                crate::error::ListMigrationTasksError,
                crate::input::ListMigrationTasksInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListMigrationTasksPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListMigrationTasksPaginator<C, M, R> {
            crate::paginator::ListMigrationTasksPaginator::new(self.handle, self.inner)
        }
        /// <p>If a <code>NextToken</code> was returned by a previous call, there are more results available. To retrieve the next page of results, make the call again using the returned token in <code>NextToken</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If a <code>NextToken</code> was returned by a previous call, there are more results available. To retrieve the next page of results, make the call again using the returned token in <code>NextToken</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Value to specify how many results are returned per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Value to specify how many results are returned per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Filter migration tasks by discovered resource name.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_name(input.into());
            self
        }
        /// <p>Filter migration tasks by discovered resource name.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListProgressUpdateStreams`.
    ///
    /// <p>Lists progress update streams associated with the user account making this call.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListProgressUpdateStreams<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_progress_update_streams_input::Builder,
    }
    impl<C, M, R> ListProgressUpdateStreams<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListProgressUpdateStreams`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListProgressUpdateStreamsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListProgressUpdateStreamsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListProgressUpdateStreamsInputOperationOutputAlias,
                crate::output::ListProgressUpdateStreamsOutput,
                crate::error::ListProgressUpdateStreamsError,
                crate::input::ListProgressUpdateStreamsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListProgressUpdateStreamsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListProgressUpdateStreamsPaginator<C, M, R> {
            crate::paginator::ListProgressUpdateStreamsPaginator::new(self.handle, self.inner)
        }
        /// <p>If a <code>NextToken</code> was returned by a previous call, there are more results available. To retrieve the next page of results, make the call again using the returned token in <code>NextToken</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If a <code>NextToken</code> was returned by a previous call, there are more results available. To retrieve the next page of results, make the call again using the returned token in <code>NextToken</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Filter to limit the maximum number of results to list per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Filter to limit the maximum number of results to list per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `NotifyApplicationState`.
    ///
    /// <p>Sets the migration state of an application. For a given application identified by the value passed to <code>ApplicationId</code>, its status is set or updated by passing one of three values to <code>Status</code>: <code>NOT_STARTED | IN_PROGRESS | COMPLETED</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct NotifyApplicationState<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::notify_application_state_input::Builder,
    }
    impl<C, M, R> NotifyApplicationState<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `NotifyApplicationState`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::NotifyApplicationStateOutput,
            aws_smithy_http::result::SdkError<crate::error::NotifyApplicationStateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::NotifyApplicationStateInputOperationOutputAlias,
                crate::output::NotifyApplicationStateOutput,
                crate::error::NotifyApplicationStateError,
                crate::input::NotifyApplicationStateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The configurationId in Application Discovery Service that uniquely identifies the grouped application.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The configurationId in Application Discovery Service that uniquely identifies the grouped application.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>Status of the application - Not Started, In-Progress, Complete.</p>
        pub fn status(mut self, input: crate::model::ApplicationStatus) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p>Status of the application - Not Started, In-Progress, Complete.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ApplicationStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p>The timestamp when the application state changed.</p>
        pub fn update_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.update_date_time(input);
            self
        }
        /// <p>The timestamp when the application state changed.</p>
        pub fn set_update_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_update_date_time(input);
            self
        }
        /// <p>Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has permission to make the call.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has permission to make the call.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `NotifyMigrationTaskState`.
    ///
    /// <p>Notifies Migration Hub of the current status, progress, or other detail regarding a migration task. This API has the following traits:</p>
    /// <ul>
    /// <li> <p>Migration tools will call the <code>NotifyMigrationTaskState</code> API to share the latest progress and status.</p> </li>
    /// <li> <p> <code>MigrationTaskName</code> is used for addressing updates to the correct target.</p> </li>
    /// <li> <p> <code>ProgressUpdateStream</code> is used for access control and to provide a namespace for each migration tool.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct NotifyMigrationTaskState<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::notify_migration_task_state_input::Builder,
    }
    impl<C, M, R> NotifyMigrationTaskState<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `NotifyMigrationTaskState`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::NotifyMigrationTaskStateOutput,
            aws_smithy_http::result::SdkError<crate::error::NotifyMigrationTaskStateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::NotifyMigrationTaskStateInputOperationOutputAlias,
                crate::output::NotifyMigrationTaskStateOutput,
                crate::error::NotifyMigrationTaskStateError,
                crate::input::NotifyMigrationTaskStateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the ProgressUpdateStream. </p>
        pub fn progress_update_stream(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.progress_update_stream(input.into());
            self
        }
        /// <p>The name of the ProgressUpdateStream. </p>
        pub fn set_progress_update_stream(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_progress_update_stream(input);
            self
        }
        /// <p>Unique identifier that references the migration task. <i>Do not store personal data in this field.</i> </p>
        pub fn migration_task_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.migration_task_name(input.into());
            self
        }
        /// <p>Unique identifier that references the migration task. <i>Do not store personal data in this field.</i> </p>
        pub fn set_migration_task_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_migration_task_name(input);
            self
        }
        /// <p>Information about the task's progress and status.</p>
        pub fn task(mut self, input: crate::model::Task) -> Self {
            self.inner = self.inner.task(input);
            self
        }
        /// <p>Information about the task's progress and status.</p>
        pub fn set_task(mut self, input: std::option::Option<crate::model::Task>) -> Self {
            self.inner = self.inner.set_task(input);
            self
        }
        /// <p>The timestamp when the task was gathered.</p>
        pub fn update_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.update_date_time(input);
            self
        }
        /// <p>The timestamp when the task was gathered.</p>
        pub fn set_update_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_update_date_time(input);
            self
        }
        /// <p>Number of seconds after the UpdateDateTime within which the Migration Hub can expect an update. If Migration Hub does not receive an update within the specified interval, then the migration task will be considered stale.</p>
        pub fn next_update_seconds(mut self, input: i32) -> Self {
            self.inner = self.inner.next_update_seconds(input);
            self
        }
        /// <p>Number of seconds after the UpdateDateTime within which the Migration Hub can expect an update. If Migration Hub does not receive an update within the specified interval, then the migration task will be considered stale.</p>
        pub fn set_next_update_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_next_update_seconds(input);
            self
        }
        /// <p>Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has permission to make the call.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has permission to make the call.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutResourceAttributes`.
    ///
    /// <p>Provides identifying details of the resource being migrated so that it can be associated in the Application Discovery Service repository. This association occurs asynchronously after <code>PutResourceAttributes</code> returns.</p> <important>
    /// <ul>
    /// <li> <p>Keep in mind that subsequent calls to PutResourceAttributes will override previously stored attributes. For example, if it is first called with a MAC address, but later, it is desired to <i>add</i> an IP address, it will then be required to call it with <i>both</i> the IP and MAC addresses to prevent overriding the MAC address.</p> </li>
    /// <li> <p>Note the instructions regarding the special use case of the <a href="https://docs.aws.amazon.com/migrationhub/latest/ug/API_PutResourceAttributes.html#migrationhub-PutResourceAttributes-request-ResourceAttributeList"> <code>ResourceAttributeList</code> </a> parameter when specifying any "VM" related value.</p> </li>
    /// </ul>
    /// </important> <note>
    /// <p>Because this is an asynchronous call, it will always return 200, whether an association occurs or not. To confirm if an association was found based on the provided details, call <code>ListDiscoveredResources</code>.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutResourceAttributes<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_resource_attributes_input::Builder,
    }
    impl<C, M, R> PutResourceAttributes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutResourceAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutResourceAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::PutResourceAttributesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutResourceAttributesInputOperationOutputAlias,
                crate::output::PutResourceAttributesOutput,
                crate::error::PutResourceAttributesError,
                crate::input::PutResourceAttributesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the ProgressUpdateStream. </p>
        pub fn progress_update_stream(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.progress_update_stream(input.into());
            self
        }
        /// <p>The name of the ProgressUpdateStream. </p>
        pub fn set_progress_update_stream(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_progress_update_stream(input);
            self
        }
        /// <p>Unique identifier that references the migration task. <i>Do not store personal data in this field.</i> </p>
        pub fn migration_task_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.migration_task_name(input.into());
            self
        }
        /// <p>Unique identifier that references the migration task. <i>Do not store personal data in this field.</i> </p>
        pub fn set_migration_task_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_migration_task_name(input);
            self
        }
        /// Appends an item to `ResourceAttributeList`.
        ///
        /// To override the contents of this collection use [`set_resource_attribute_list`](Self::set_resource_attribute_list).
        ///
        /// <p>Information about the resource that is being migrated. This data will be used to map the task to a resource in the Application Discovery Service repository.</p> <note>
        /// <p>Takes the object array of <code>ResourceAttribute</code> where the <code>Type</code> field is reserved for the following values: <code>IPV4_ADDRESS | IPV6_ADDRESS | MAC_ADDRESS | FQDN | VM_MANAGER_ID | VM_MANAGED_OBJECT_REFERENCE | VM_NAME | VM_PATH | BIOS_ID | MOTHERBOARD_SERIAL_NUMBER</code> where the identifying value can be a string up to 256 characters.</p>
        /// </note> <important>
        /// <ul>
        /// <li> <p>If any "VM" related value is set for a <code>ResourceAttribute</code> object, it is required that <code>VM_MANAGER_ID</code>, as a minimum, is always set. If <code>VM_MANAGER_ID</code> is not set, then all "VM" fields will be discarded and "VM" fields will not be used for matching the migration task to a server in Application Discovery Service repository. See the <a href="https://docs.aws.amazon.com/migrationhub/latest/ug/API_PutResourceAttributes.html#API_PutResourceAttributes_Examples">Example</a> section below for a use case of specifying "VM" related values.</p> </li>
        /// <li> <p> If a server you are trying to match has multiple IP or MAC addresses, you should provide as many as you know in separate type/value pairs passed to the <code>ResourceAttributeList</code> parameter to maximize the chances of matching.</p> </li>
        /// </ul>
        /// </important>
        pub fn resource_attribute_list(mut self, input: crate::model::ResourceAttribute) -> Self {
            self.inner = self.inner.resource_attribute_list(input);
            self
        }
        /// <p>Information about the resource that is being migrated. This data will be used to map the task to a resource in the Application Discovery Service repository.</p> <note>
        /// <p>Takes the object array of <code>ResourceAttribute</code> where the <code>Type</code> field is reserved for the following values: <code>IPV4_ADDRESS | IPV6_ADDRESS | MAC_ADDRESS | FQDN | VM_MANAGER_ID | VM_MANAGED_OBJECT_REFERENCE | VM_NAME | VM_PATH | BIOS_ID | MOTHERBOARD_SERIAL_NUMBER</code> where the identifying value can be a string up to 256 characters.</p>
        /// </note> <important>
        /// <ul>
        /// <li> <p>If any "VM" related value is set for a <code>ResourceAttribute</code> object, it is required that <code>VM_MANAGER_ID</code>, as a minimum, is always set. If <code>VM_MANAGER_ID</code> is not set, then all "VM" fields will be discarded and "VM" fields will not be used for matching the migration task to a server in Application Discovery Service repository. See the <a href="https://docs.aws.amazon.com/migrationhub/latest/ug/API_PutResourceAttributes.html#API_PutResourceAttributes_Examples">Example</a> section below for a use case of specifying "VM" related values.</p> </li>
        /// <li> <p> If a server you are trying to match has multiple IP or MAC addresses, you should provide as many as you know in separate type/value pairs passed to the <code>ResourceAttributeList</code> parameter to maximize the chances of matching.</p> </li>
        /// </ul>
        /// </important>
        pub fn set_resource_attribute_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceAttribute>>,
        ) -> Self {
            self.inner = self.inner.set_resource_attribute_list(input);
            self
        }
        /// <p>Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has permission to make the call.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has permission to make the call.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
