// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AssociateCreatedArtifactInput`](crate::input::AssociateCreatedArtifactInput)
pub mod associate_created_artifact_input {
    /// A builder for [`AssociateCreatedArtifactInput`](crate::input::AssociateCreatedArtifactInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) progress_update_stream: std::option::Option<std::string::String>,
        pub(crate) migration_task_name: std::option::Option<std::string::String>,
        pub(crate) created_artifact: std::option::Option<crate::model::CreatedArtifact>,
        pub(crate) dry_run: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the ProgressUpdateStream. </p>
        pub fn progress_update_stream(mut self, input: impl Into<std::string::String>) -> Self {
            self.progress_update_stream = Some(input.into());
            self
        }
        /// <p>The name of the ProgressUpdateStream. </p>
        pub fn set_progress_update_stream(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.progress_update_stream = input;
            self
        }
        /// <p>Unique identifier that references the migration task. <i>Do not store personal
        /// data in this field.</i>
        /// </p>
        pub fn migration_task_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.migration_task_name = Some(input.into());
            self
        }
        /// <p>Unique identifier that references the migration task. <i>Do not store personal
        /// data in this field.</i>
        /// </p>
        pub fn set_migration_task_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.migration_task_name = input;
            self
        }
        /// <p>An ARN of the AWS resource related to the migration (e.g., AMI, EC2 instance, RDS
        /// instance, etc.) </p>
        pub fn created_artifact(mut self, input: crate::model::CreatedArtifact) -> Self {
            self.created_artifact = Some(input);
            self
        }
        /// <p>An ARN of the AWS resource related to the migration (e.g., AMI, EC2 instance, RDS
        /// instance, etc.) </p>
        pub fn set_created_artifact(
            mut self,
            input: std::option::Option<crate::model::CreatedArtifact>,
        ) -> Self {
            self.created_artifact = input;
            self
        }
        /// <p>Optional boolean flag to indicate whether any effect should take place. Used to test if
        /// the caller has permission to make the call.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Optional boolean flag to indicate whether any effect should take place. Used to test if
        /// the caller has permission to make the call.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateCreatedArtifactInput`](crate::input::AssociateCreatedArtifactInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateCreatedArtifactInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateCreatedArtifactInput {
                progress_update_stream: self.progress_update_stream,
                migration_task_name: self.migration_task_name,
                created_artifact: self.created_artifact,
                dry_run: self.dry_run.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateCreatedArtifactInputOperationOutputAlias =
    crate::operation::AssociateCreatedArtifact;
#[doc(hidden)]
pub type AssociateCreatedArtifactInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AssociateCreatedArtifactInput {
    /// Consumes the builder and constructs an Operation<[`AssociateCreatedArtifact`](crate::operation::AssociateCreatedArtifact)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateCreatedArtifact,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateCreatedArtifactInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateCreatedArtifactInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateCreatedArtifactInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSMigrationHub.AssociateCreatedArtifact",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_associate_created_artifact(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateCreatedArtifact::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateCreatedArtifact",
            "migrationhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateCreatedArtifactInput`](crate::input::AssociateCreatedArtifactInput)
    pub fn builder() -> crate::input::associate_created_artifact_input::Builder {
        crate::input::associate_created_artifact_input::Builder::default()
    }
}

/// See [`AssociateDiscoveredResourceInput`](crate::input::AssociateDiscoveredResourceInput)
pub mod associate_discovered_resource_input {
    /// A builder for [`AssociateDiscoveredResourceInput`](crate::input::AssociateDiscoveredResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) progress_update_stream: std::option::Option<std::string::String>,
        pub(crate) migration_task_name: std::option::Option<std::string::String>,
        pub(crate) discovered_resource: std::option::Option<crate::model::DiscoveredResource>,
        pub(crate) dry_run: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the ProgressUpdateStream.</p>
        pub fn progress_update_stream(mut self, input: impl Into<std::string::String>) -> Self {
            self.progress_update_stream = Some(input.into());
            self
        }
        /// <p>The name of the ProgressUpdateStream.</p>
        pub fn set_progress_update_stream(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.progress_update_stream = input;
            self
        }
        /// <p>The identifier given to the MigrationTask. <i>Do not store personal data in this
        /// field.</i>
        /// </p>
        pub fn migration_task_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.migration_task_name = Some(input.into());
            self
        }
        /// <p>The identifier given to the MigrationTask. <i>Do not store personal data in this
        /// field.</i>
        /// </p>
        pub fn set_migration_task_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.migration_task_name = input;
            self
        }
        /// <p>Object representing a Resource.</p>
        pub fn discovered_resource(mut self, input: crate::model::DiscoveredResource) -> Self {
            self.discovered_resource = Some(input);
            self
        }
        /// <p>Object representing a Resource.</p>
        pub fn set_discovered_resource(
            mut self,
            input: std::option::Option<crate::model::DiscoveredResource>,
        ) -> Self {
            self.discovered_resource = input;
            self
        }
        /// <p>Optional boolean flag to indicate whether any effect should take place. Used to test if
        /// the caller has permission to make the call.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Optional boolean flag to indicate whether any effect should take place. Used to test if
        /// the caller has permission to make the call.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateDiscoveredResourceInput`](crate::input::AssociateDiscoveredResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateDiscoveredResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateDiscoveredResourceInput {
                progress_update_stream: self.progress_update_stream,
                migration_task_name: self.migration_task_name,
                discovered_resource: self.discovered_resource,
                dry_run: self.dry_run.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateDiscoveredResourceInputOperationOutputAlias =
    crate::operation::AssociateDiscoveredResource;
#[doc(hidden)]
pub type AssociateDiscoveredResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AssociateDiscoveredResourceInput {
    /// Consumes the builder and constructs an Operation<[`AssociateDiscoveredResource`](crate::operation::AssociateDiscoveredResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateDiscoveredResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateDiscoveredResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateDiscoveredResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateDiscoveredResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSMigrationHub.AssociateDiscoveredResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_associate_discovered_resource(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateDiscoveredResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateDiscoveredResource",
            "migrationhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateDiscoveredResourceInput`](crate::input::AssociateDiscoveredResourceInput)
    pub fn builder() -> crate::input::associate_discovered_resource_input::Builder {
        crate::input::associate_discovered_resource_input::Builder::default()
    }
}

/// See [`CreateProgressUpdateStreamInput`](crate::input::CreateProgressUpdateStreamInput)
pub mod create_progress_update_stream_input {
    /// A builder for [`CreateProgressUpdateStreamInput`](crate::input::CreateProgressUpdateStreamInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) progress_update_stream_name: std::option::Option<std::string::String>,
        pub(crate) dry_run: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the ProgressUpdateStream. <i>Do not store personal data in this
        /// field.</i>
        /// </p>
        pub fn progress_update_stream_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.progress_update_stream_name = Some(input.into());
            self
        }
        /// <p>The name of the ProgressUpdateStream. <i>Do not store personal data in this
        /// field.</i>
        /// </p>
        pub fn set_progress_update_stream_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.progress_update_stream_name = input;
            self
        }
        /// <p>Optional boolean flag to indicate whether any effect should take place. Used to test if
        /// the caller has permission to make the call.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Optional boolean flag to indicate whether any effect should take place. Used to test if
        /// the caller has permission to make the call.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateProgressUpdateStreamInput`](crate::input::CreateProgressUpdateStreamInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateProgressUpdateStreamInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateProgressUpdateStreamInput {
                progress_update_stream_name: self.progress_update_stream_name,
                dry_run: self.dry_run.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type CreateProgressUpdateStreamInputOperationOutputAlias =
    crate::operation::CreateProgressUpdateStream;
#[doc(hidden)]
pub type CreateProgressUpdateStreamInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateProgressUpdateStreamInput {
    /// Consumes the builder and constructs an Operation<[`CreateProgressUpdateStream`](crate::operation::CreateProgressUpdateStream)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateProgressUpdateStream,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateProgressUpdateStreamInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateProgressUpdateStreamInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateProgressUpdateStreamInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSMigrationHub.CreateProgressUpdateStream",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_progress_update_stream(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateProgressUpdateStream::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateProgressUpdateStream",
            "migrationhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateProgressUpdateStreamInput`](crate::input::CreateProgressUpdateStreamInput)
    pub fn builder() -> crate::input::create_progress_update_stream_input::Builder {
        crate::input::create_progress_update_stream_input::Builder::default()
    }
}

/// See [`DeleteProgressUpdateStreamInput`](crate::input::DeleteProgressUpdateStreamInput)
pub mod delete_progress_update_stream_input {
    /// A builder for [`DeleteProgressUpdateStreamInput`](crate::input::DeleteProgressUpdateStreamInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) progress_update_stream_name: std::option::Option<std::string::String>,
        pub(crate) dry_run: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the ProgressUpdateStream. <i>Do not store personal data in this
        /// field.</i>
        /// </p>
        pub fn progress_update_stream_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.progress_update_stream_name = Some(input.into());
            self
        }
        /// <p>The name of the ProgressUpdateStream. <i>Do not store personal data in this
        /// field.</i>
        /// </p>
        pub fn set_progress_update_stream_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.progress_update_stream_name = input;
            self
        }
        /// <p>Optional boolean flag to indicate whether any effect should take place. Used to test if
        /// the caller has permission to make the call.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Optional boolean flag to indicate whether any effect should take place. Used to test if
        /// the caller has permission to make the call.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteProgressUpdateStreamInput`](crate::input::DeleteProgressUpdateStreamInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteProgressUpdateStreamInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteProgressUpdateStreamInput {
                progress_update_stream_name: self.progress_update_stream_name,
                dry_run: self.dry_run.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteProgressUpdateStreamInputOperationOutputAlias =
    crate::operation::DeleteProgressUpdateStream;
#[doc(hidden)]
pub type DeleteProgressUpdateStreamInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteProgressUpdateStreamInput {
    /// Consumes the builder and constructs an Operation<[`DeleteProgressUpdateStream`](crate::operation::DeleteProgressUpdateStream)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteProgressUpdateStream,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteProgressUpdateStreamInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteProgressUpdateStreamInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteProgressUpdateStreamInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSMigrationHub.DeleteProgressUpdateStream",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_progress_update_stream(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteProgressUpdateStream::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteProgressUpdateStream",
            "migrationhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteProgressUpdateStreamInput`](crate::input::DeleteProgressUpdateStreamInput)
    pub fn builder() -> crate::input::delete_progress_update_stream_input::Builder {
        crate::input::delete_progress_update_stream_input::Builder::default()
    }
}

/// See [`DescribeApplicationStateInput`](crate::input::DescribeApplicationStateInput)
pub mod describe_application_state_input {
    /// A builder for [`DescribeApplicationStateInput`](crate::input::DescribeApplicationStateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The configurationId in Application Discovery Service that uniquely identifies the
        /// grouped application.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The configurationId in Application Discovery Service that uniquely identifies the
        /// grouped application.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeApplicationStateInput`](crate::input::DescribeApplicationStateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeApplicationStateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeApplicationStateInput {
                application_id: self.application_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeApplicationStateInputOperationOutputAlias =
    crate::operation::DescribeApplicationState;
#[doc(hidden)]
pub type DescribeApplicationStateInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeApplicationStateInput {
    /// Consumes the builder and constructs an Operation<[`DescribeApplicationState`](crate::operation::DescribeApplicationState)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeApplicationState,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeApplicationStateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeApplicationStateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeApplicationStateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSMigrationHub.DescribeApplicationState",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_application_state(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeApplicationState::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeApplicationState",
            "migrationhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeApplicationStateInput`](crate::input::DescribeApplicationStateInput)
    pub fn builder() -> crate::input::describe_application_state_input::Builder {
        crate::input::describe_application_state_input::Builder::default()
    }
}

/// See [`DescribeMigrationTaskInput`](crate::input::DescribeMigrationTaskInput)
pub mod describe_migration_task_input {
    /// A builder for [`DescribeMigrationTaskInput`](crate::input::DescribeMigrationTaskInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) progress_update_stream: std::option::Option<std::string::String>,
        pub(crate) migration_task_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the ProgressUpdateStream. </p>
        pub fn progress_update_stream(mut self, input: impl Into<std::string::String>) -> Self {
            self.progress_update_stream = Some(input.into());
            self
        }
        /// <p>The name of the ProgressUpdateStream. </p>
        pub fn set_progress_update_stream(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.progress_update_stream = input;
            self
        }
        /// <p>The identifier given to the MigrationTask. <i>Do not store personal data in this
        /// field.</i>
        /// </p>
        pub fn migration_task_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.migration_task_name = Some(input.into());
            self
        }
        /// <p>The identifier given to the MigrationTask. <i>Do not store personal data in this
        /// field.</i>
        /// </p>
        pub fn set_migration_task_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.migration_task_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeMigrationTaskInput`](crate::input::DescribeMigrationTaskInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeMigrationTaskInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeMigrationTaskInput {
                progress_update_stream: self.progress_update_stream,
                migration_task_name: self.migration_task_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeMigrationTaskInputOperationOutputAlias = crate::operation::DescribeMigrationTask;
#[doc(hidden)]
pub type DescribeMigrationTaskInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeMigrationTaskInput {
    /// Consumes the builder and constructs an Operation<[`DescribeMigrationTask`](crate::operation::DescribeMigrationTask)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeMigrationTask,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeMigrationTaskInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeMigrationTaskInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeMigrationTaskInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSMigrationHub.DescribeMigrationTask",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_migration_task(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeMigrationTask::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeMigrationTask",
            "migrationhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeMigrationTaskInput`](crate::input::DescribeMigrationTaskInput)
    pub fn builder() -> crate::input::describe_migration_task_input::Builder {
        crate::input::describe_migration_task_input::Builder::default()
    }
}

/// See [`DisassociateCreatedArtifactInput`](crate::input::DisassociateCreatedArtifactInput)
pub mod disassociate_created_artifact_input {
    /// A builder for [`DisassociateCreatedArtifactInput`](crate::input::DisassociateCreatedArtifactInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) progress_update_stream: std::option::Option<std::string::String>,
        pub(crate) migration_task_name: std::option::Option<std::string::String>,
        pub(crate) created_artifact_name: std::option::Option<std::string::String>,
        pub(crate) dry_run: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the ProgressUpdateStream. </p>
        pub fn progress_update_stream(mut self, input: impl Into<std::string::String>) -> Self {
            self.progress_update_stream = Some(input.into());
            self
        }
        /// <p>The name of the ProgressUpdateStream. </p>
        pub fn set_progress_update_stream(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.progress_update_stream = input;
            self
        }
        /// <p>Unique identifier that references the migration task to be disassociated with the
        /// artifact. <i>Do not store personal data in this field.</i>
        /// </p>
        pub fn migration_task_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.migration_task_name = Some(input.into());
            self
        }
        /// <p>Unique identifier that references the migration task to be disassociated with the
        /// artifact. <i>Do not store personal data in this field.</i>
        /// </p>
        pub fn set_migration_task_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.migration_task_name = input;
            self
        }
        /// <p>An ARN of the AWS resource related to the migration (e.g., AMI, EC2 instance, RDS
        /// instance, etc.)</p>
        pub fn created_artifact_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_artifact_name = Some(input.into());
            self
        }
        /// <p>An ARN of the AWS resource related to the migration (e.g., AMI, EC2 instance, RDS
        /// instance, etc.)</p>
        pub fn set_created_artifact_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.created_artifact_name = input;
            self
        }
        /// <p>Optional boolean flag to indicate whether any effect should take place. Used to test if
        /// the caller has permission to make the call.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Optional boolean flag to indicate whether any effect should take place. Used to test if
        /// the caller has permission to make the call.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateCreatedArtifactInput`](crate::input::DisassociateCreatedArtifactInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateCreatedArtifactInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateCreatedArtifactInput {
                progress_update_stream: self.progress_update_stream,
                migration_task_name: self.migration_task_name,
                created_artifact_name: self.created_artifact_name,
                dry_run: self.dry_run.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateCreatedArtifactInputOperationOutputAlias =
    crate::operation::DisassociateCreatedArtifact;
#[doc(hidden)]
pub type DisassociateCreatedArtifactInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DisassociateCreatedArtifactInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateCreatedArtifact`](crate::operation::DisassociateCreatedArtifact)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateCreatedArtifact,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateCreatedArtifactInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateCreatedArtifactInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateCreatedArtifactInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSMigrationHub.DisassociateCreatedArtifact",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_disassociate_created_artifact(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateCreatedArtifact::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateCreatedArtifact",
            "migrationhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateCreatedArtifactInput`](crate::input::DisassociateCreatedArtifactInput)
    pub fn builder() -> crate::input::disassociate_created_artifact_input::Builder {
        crate::input::disassociate_created_artifact_input::Builder::default()
    }
}

/// See [`DisassociateDiscoveredResourceInput`](crate::input::DisassociateDiscoveredResourceInput)
pub mod disassociate_discovered_resource_input {
    /// A builder for [`DisassociateDiscoveredResourceInput`](crate::input::DisassociateDiscoveredResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) progress_update_stream: std::option::Option<std::string::String>,
        pub(crate) migration_task_name: std::option::Option<std::string::String>,
        pub(crate) configuration_id: std::option::Option<std::string::String>,
        pub(crate) dry_run: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the ProgressUpdateStream.</p>
        pub fn progress_update_stream(mut self, input: impl Into<std::string::String>) -> Self {
            self.progress_update_stream = Some(input.into());
            self
        }
        /// <p>The name of the ProgressUpdateStream.</p>
        pub fn set_progress_update_stream(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.progress_update_stream = input;
            self
        }
        /// <p>The identifier given to the MigrationTask. <i>Do not store personal data in this
        /// field.</i>
        /// </p>
        pub fn migration_task_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.migration_task_name = Some(input.into());
            self
        }
        /// <p>The identifier given to the MigrationTask. <i>Do not store personal data in this
        /// field.</i>
        /// </p>
        pub fn set_migration_task_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.migration_task_name = input;
            self
        }
        /// <p>ConfigurationId of the Application Discovery Service resource to be
        /// disassociated.</p>
        pub fn configuration_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_id = Some(input.into());
            self
        }
        /// <p>ConfigurationId of the Application Discovery Service resource to be
        /// disassociated.</p>
        pub fn set_configuration_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_id = input;
            self
        }
        /// <p>Optional boolean flag to indicate whether any effect should take place. Used to test if
        /// the caller has permission to make the call.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Optional boolean flag to indicate whether any effect should take place. Used to test if
        /// the caller has permission to make the call.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateDiscoveredResourceInput`](crate::input::DisassociateDiscoveredResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateDiscoveredResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateDiscoveredResourceInput {
                progress_update_stream: self.progress_update_stream,
                migration_task_name: self.migration_task_name,
                configuration_id: self.configuration_id,
                dry_run: self.dry_run.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateDiscoveredResourceInputOperationOutputAlias =
    crate::operation::DisassociateDiscoveredResource;
#[doc(hidden)]
pub type DisassociateDiscoveredResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DisassociateDiscoveredResourceInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateDiscoveredResource`](crate::operation::DisassociateDiscoveredResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateDiscoveredResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateDiscoveredResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateDiscoveredResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateDiscoveredResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSMigrationHub.DisassociateDiscoveredResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_disassociate_discovered_resource(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateDiscoveredResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateDiscoveredResource",
            "migrationhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateDiscoveredResourceInput`](crate::input::DisassociateDiscoveredResourceInput)
    pub fn builder() -> crate::input::disassociate_discovered_resource_input::Builder {
        crate::input::disassociate_discovered_resource_input::Builder::default()
    }
}

/// See [`ImportMigrationTaskInput`](crate::input::ImportMigrationTaskInput)
pub mod import_migration_task_input {
    /// A builder for [`ImportMigrationTaskInput`](crate::input::ImportMigrationTaskInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) progress_update_stream: std::option::Option<std::string::String>,
        pub(crate) migration_task_name: std::option::Option<std::string::String>,
        pub(crate) dry_run: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the ProgressUpdateStream. ></p>
        pub fn progress_update_stream(mut self, input: impl Into<std::string::String>) -> Self {
            self.progress_update_stream = Some(input.into());
            self
        }
        /// <p>The name of the ProgressUpdateStream. ></p>
        pub fn set_progress_update_stream(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.progress_update_stream = input;
            self
        }
        /// <p>Unique identifier that references the migration task. <i>Do not store personal
        /// data in this field.</i>
        /// </p>
        pub fn migration_task_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.migration_task_name = Some(input.into());
            self
        }
        /// <p>Unique identifier that references the migration task. <i>Do not store personal
        /// data in this field.</i>
        /// </p>
        pub fn set_migration_task_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.migration_task_name = input;
            self
        }
        /// <p>Optional boolean flag to indicate whether any effect should take place. Used to test if
        /// the caller has permission to make the call.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Optional boolean flag to indicate whether any effect should take place. Used to test if
        /// the caller has permission to make the call.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// Consumes the builder and constructs a [`ImportMigrationTaskInput`](crate::input::ImportMigrationTaskInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ImportMigrationTaskInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ImportMigrationTaskInput {
                progress_update_stream: self.progress_update_stream,
                migration_task_name: self.migration_task_name,
                dry_run: self.dry_run.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ImportMigrationTaskInputOperationOutputAlias = crate::operation::ImportMigrationTask;
#[doc(hidden)]
pub type ImportMigrationTaskInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ImportMigrationTaskInput {
    /// Consumes the builder and constructs an Operation<[`ImportMigrationTask`](crate::operation::ImportMigrationTask)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ImportMigrationTask,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ImportMigrationTaskInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ImportMigrationTaskInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ImportMigrationTaskInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSMigrationHub.ImportMigrationTask",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_import_migration_task(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ImportMigrationTask::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ImportMigrationTask",
            "migrationhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ImportMigrationTaskInput`](crate::input::ImportMigrationTaskInput)
    pub fn builder() -> crate::input::import_migration_task_input::Builder {
        crate::input::import_migration_task_input::Builder::default()
    }
}

/// See [`ListApplicationStatesInput`](crate::input::ListApplicationStatesInput)
pub mod list_application_states_input {
    /// A builder for [`ListApplicationStatesInput`](crate::input::ListApplicationStatesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `application_ids`.
        ///
        /// To override the contents of this collection use [`set_application_ids`](Self::set_application_ids).
        ///
        /// <p>The configurationIds from the Application Discovery Service that uniquely identifies
        /// your applications.</p>
        pub fn application_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.application_ids.unwrap_or_default();
            v.push(input.into());
            self.application_ids = Some(v);
            self
        }
        /// <p>The configurationIds from the Application Discovery Service that uniquely identifies
        /// your applications.</p>
        pub fn set_application_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.application_ids = input;
            self
        }
        /// <p>If a <code>NextToken</code> was returned by a previous call, there are more results
        /// available. To retrieve the next page of results, make the call again using the returned
        /// token in <code>NextToken</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If a <code>NextToken</code> was returned by a previous call, there are more results
        /// available. To retrieve the next page of results, make the call again using the returned
        /// token in <code>NextToken</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>Maximum number of results to be returned per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Maximum number of results to be returned per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListApplicationStatesInput`](crate::input::ListApplicationStatesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListApplicationStatesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListApplicationStatesInput {
                application_ids: self.application_ids,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListApplicationStatesInputOperationOutputAlias = crate::operation::ListApplicationStates;
#[doc(hidden)]
pub type ListApplicationStatesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListApplicationStatesInput {
    /// Consumes the builder and constructs an Operation<[`ListApplicationStates`](crate::operation::ListApplicationStates)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListApplicationStates,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListApplicationStatesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListApplicationStatesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListApplicationStatesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSMigrationHub.ListApplicationStates",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_application_states(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListApplicationStates::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListApplicationStates",
            "migrationhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListApplicationStatesInput`](crate::input::ListApplicationStatesInput)
    pub fn builder() -> crate::input::list_application_states_input::Builder {
        crate::input::list_application_states_input::Builder::default()
    }
}

/// See [`ListCreatedArtifactsInput`](crate::input::ListCreatedArtifactsInput)
pub mod list_created_artifacts_input {
    /// A builder for [`ListCreatedArtifactsInput`](crate::input::ListCreatedArtifactsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) progress_update_stream: std::option::Option<std::string::String>,
        pub(crate) migration_task_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the ProgressUpdateStream. </p>
        pub fn progress_update_stream(mut self, input: impl Into<std::string::String>) -> Self {
            self.progress_update_stream = Some(input.into());
            self
        }
        /// <p>The name of the ProgressUpdateStream. </p>
        pub fn set_progress_update_stream(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.progress_update_stream = input;
            self
        }
        /// <p>Unique identifier that references the migration task. <i>Do not store personal
        /// data in this field.</i>
        /// </p>
        pub fn migration_task_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.migration_task_name = Some(input.into());
            self
        }
        /// <p>Unique identifier that references the migration task. <i>Do not store personal
        /// data in this field.</i>
        /// </p>
        pub fn set_migration_task_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.migration_task_name = input;
            self
        }
        /// <p>If a <code>NextToken</code> was returned by a previous call, there are more results
        /// available. To retrieve the next page of results, make the call again using the returned
        /// token in <code>NextToken</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If a <code>NextToken</code> was returned by a previous call, there are more results
        /// available. To retrieve the next page of results, make the call again using the returned
        /// token in <code>NextToken</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>Maximum number of results to be returned per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Maximum number of results to be returned per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListCreatedArtifactsInput`](crate::input::ListCreatedArtifactsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListCreatedArtifactsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListCreatedArtifactsInput {
                progress_update_stream: self.progress_update_stream,
                migration_task_name: self.migration_task_name,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListCreatedArtifactsInputOperationOutputAlias = crate::operation::ListCreatedArtifacts;
#[doc(hidden)]
pub type ListCreatedArtifactsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListCreatedArtifactsInput {
    /// Consumes the builder and constructs an Operation<[`ListCreatedArtifacts`](crate::operation::ListCreatedArtifacts)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListCreatedArtifacts,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListCreatedArtifactsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListCreatedArtifactsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListCreatedArtifactsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSMigrationHub.ListCreatedArtifacts",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_created_artifacts(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListCreatedArtifacts::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListCreatedArtifacts",
            "migrationhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListCreatedArtifactsInput`](crate::input::ListCreatedArtifactsInput)
    pub fn builder() -> crate::input::list_created_artifacts_input::Builder {
        crate::input::list_created_artifacts_input::Builder::default()
    }
}

/// See [`ListDiscoveredResourcesInput`](crate::input::ListDiscoveredResourcesInput)
pub mod list_discovered_resources_input {
    /// A builder for [`ListDiscoveredResourcesInput`](crate::input::ListDiscoveredResourcesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) progress_update_stream: std::option::Option<std::string::String>,
        pub(crate) migration_task_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the ProgressUpdateStream.</p>
        pub fn progress_update_stream(mut self, input: impl Into<std::string::String>) -> Self {
            self.progress_update_stream = Some(input.into());
            self
        }
        /// <p>The name of the ProgressUpdateStream.</p>
        pub fn set_progress_update_stream(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.progress_update_stream = input;
            self
        }
        /// <p>The name of the MigrationTask. <i>Do not store personal data in this
        /// field.</i>
        /// </p>
        pub fn migration_task_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.migration_task_name = Some(input.into());
            self
        }
        /// <p>The name of the MigrationTask. <i>Do not store personal data in this
        /// field.</i>
        /// </p>
        pub fn set_migration_task_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.migration_task_name = input;
            self
        }
        /// <p>If a <code>NextToken</code> was returned by a previous call, there are more results
        /// available. To retrieve the next page of results, make the call again using the returned
        /// token in <code>NextToken</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If a <code>NextToken</code> was returned by a previous call, there are more results
        /// available. To retrieve the next page of results, make the call again using the returned
        /// token in <code>NextToken</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results returned per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results returned per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDiscoveredResourcesInput`](crate::input::ListDiscoveredResourcesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDiscoveredResourcesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDiscoveredResourcesInput {
                progress_update_stream: self.progress_update_stream,
                migration_task_name: self.migration_task_name,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDiscoveredResourcesInputOperationOutputAlias =
    crate::operation::ListDiscoveredResources;
#[doc(hidden)]
pub type ListDiscoveredResourcesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListDiscoveredResourcesInput {
    /// Consumes the builder and constructs an Operation<[`ListDiscoveredResources`](crate::operation::ListDiscoveredResources)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDiscoveredResources,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDiscoveredResourcesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDiscoveredResourcesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDiscoveredResourcesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSMigrationHub.ListDiscoveredResources",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_discovered_resources(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDiscoveredResources::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDiscoveredResources",
            "migrationhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDiscoveredResourcesInput`](crate::input::ListDiscoveredResourcesInput)
    pub fn builder() -> crate::input::list_discovered_resources_input::Builder {
        crate::input::list_discovered_resources_input::Builder::default()
    }
}

/// See [`ListMigrationTasksInput`](crate::input::ListMigrationTasksInput)
pub mod list_migration_tasks_input {
    /// A builder for [`ListMigrationTasksInput`](crate::input::ListMigrationTasksInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) resource_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>If a <code>NextToken</code> was returned by a previous call, there are more results
        /// available. To retrieve the next page of results, make the call again using the returned
        /// token in <code>NextToken</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If a <code>NextToken</code> was returned by a previous call, there are more results
        /// available. To retrieve the next page of results, make the call again using the returned
        /// token in <code>NextToken</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>Value to specify how many results are returned per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Value to specify how many results are returned per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Filter migration tasks by discovered resource name.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        /// <p>Filter migration tasks by discovered resource name.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ListMigrationTasksInput`](crate::input::ListMigrationTasksInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListMigrationTasksInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListMigrationTasksInput {
                next_token: self.next_token,
                max_results: self.max_results,
                resource_name: self.resource_name,
            })
        }
    }
}
#[doc(hidden)]
pub type ListMigrationTasksInputOperationOutputAlias = crate::operation::ListMigrationTasks;
#[doc(hidden)]
pub type ListMigrationTasksInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListMigrationTasksInput {
    /// Consumes the builder and constructs an Operation<[`ListMigrationTasks`](crate::operation::ListMigrationTasks)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListMigrationTasks,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListMigrationTasksInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListMigrationTasksInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListMigrationTasksInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSMigrationHub.ListMigrationTasks",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_migration_tasks(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListMigrationTasks::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListMigrationTasks",
            "migrationhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListMigrationTasksInput`](crate::input::ListMigrationTasksInput)
    pub fn builder() -> crate::input::list_migration_tasks_input::Builder {
        crate::input::list_migration_tasks_input::Builder::default()
    }
}

/// See [`ListProgressUpdateStreamsInput`](crate::input::ListProgressUpdateStreamsInput)
pub mod list_progress_update_streams_input {
    /// A builder for [`ListProgressUpdateStreamsInput`](crate::input::ListProgressUpdateStreamsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>If a <code>NextToken</code> was returned by a previous call, there are more results
        /// available. To retrieve the next page of results, make the call again using the returned
        /// token in <code>NextToken</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If a <code>NextToken</code> was returned by a previous call, there are more results
        /// available. To retrieve the next page of results, make the call again using the returned
        /// token in <code>NextToken</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>Filter to limit the maximum number of results to list per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Filter to limit the maximum number of results to list per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListProgressUpdateStreamsInput`](crate::input::ListProgressUpdateStreamsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListProgressUpdateStreamsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListProgressUpdateStreamsInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListProgressUpdateStreamsInputOperationOutputAlias =
    crate::operation::ListProgressUpdateStreams;
#[doc(hidden)]
pub type ListProgressUpdateStreamsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListProgressUpdateStreamsInput {
    /// Consumes the builder and constructs an Operation<[`ListProgressUpdateStreams`](crate::operation::ListProgressUpdateStreams)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListProgressUpdateStreams,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListProgressUpdateStreamsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListProgressUpdateStreamsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListProgressUpdateStreamsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSMigrationHub.ListProgressUpdateStreams",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_progress_update_streams(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListProgressUpdateStreams::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListProgressUpdateStreams",
            "migrationhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListProgressUpdateStreamsInput`](crate::input::ListProgressUpdateStreamsInput)
    pub fn builder() -> crate::input::list_progress_update_streams_input::Builder {
        crate::input::list_progress_update_streams_input::Builder::default()
    }
}

/// See [`NotifyApplicationStateInput`](crate::input::NotifyApplicationStateInput)
pub mod notify_application_state_input {
    /// A builder for [`NotifyApplicationStateInput`](crate::input::NotifyApplicationStateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ApplicationStatus>,
        pub(crate) update_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) dry_run: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The configurationId in Application Discovery Service that uniquely identifies the
        /// grouped application.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The configurationId in Application Discovery Service that uniquely identifies the
        /// grouped application.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>Status of the application - Not Started, In-Progress, Complete.</p>
        pub fn status(mut self, input: crate::model::ApplicationStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Status of the application - Not Started, In-Progress, Complete.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ApplicationStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The timestamp when the application state changed.</p>
        pub fn update_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.update_date_time = Some(input);
            self
        }
        /// <p>The timestamp when the application state changed.</p>
        pub fn set_update_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.update_date_time = input;
            self
        }
        /// <p>Optional boolean flag to indicate whether any effect should take place. Used to test if
        /// the caller has permission to make the call.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Optional boolean flag to indicate whether any effect should take place. Used to test if
        /// the caller has permission to make the call.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// Consumes the builder and constructs a [`NotifyApplicationStateInput`](crate::input::NotifyApplicationStateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::NotifyApplicationStateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::NotifyApplicationStateInput {
                application_id: self.application_id,
                status: self.status,
                update_date_time: self.update_date_time,
                dry_run: self.dry_run.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type NotifyApplicationStateInputOperationOutputAlias = crate::operation::NotifyApplicationState;
#[doc(hidden)]
pub type NotifyApplicationStateInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl NotifyApplicationStateInput {
    /// Consumes the builder and constructs an Operation<[`NotifyApplicationState`](crate::operation::NotifyApplicationState)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::NotifyApplicationState,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::NotifyApplicationStateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::NotifyApplicationStateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::NotifyApplicationStateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSMigrationHub.NotifyApplicationState",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_notify_application_state(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::NotifyApplicationState::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "NotifyApplicationState",
            "migrationhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`NotifyApplicationStateInput`](crate::input::NotifyApplicationStateInput)
    pub fn builder() -> crate::input::notify_application_state_input::Builder {
        crate::input::notify_application_state_input::Builder::default()
    }
}

/// See [`NotifyMigrationTaskStateInput`](crate::input::NotifyMigrationTaskStateInput)
pub mod notify_migration_task_state_input {
    /// A builder for [`NotifyMigrationTaskStateInput`](crate::input::NotifyMigrationTaskStateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) progress_update_stream: std::option::Option<std::string::String>,
        pub(crate) migration_task_name: std::option::Option<std::string::String>,
        pub(crate) task: std::option::Option<crate::model::Task>,
        pub(crate) update_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) next_update_seconds: std::option::Option<i32>,
        pub(crate) dry_run: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the ProgressUpdateStream. </p>
        pub fn progress_update_stream(mut self, input: impl Into<std::string::String>) -> Self {
            self.progress_update_stream = Some(input.into());
            self
        }
        /// <p>The name of the ProgressUpdateStream. </p>
        pub fn set_progress_update_stream(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.progress_update_stream = input;
            self
        }
        /// <p>Unique identifier that references the migration task. <i>Do not store personal
        /// data in this field.</i>
        /// </p>
        pub fn migration_task_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.migration_task_name = Some(input.into());
            self
        }
        /// <p>Unique identifier that references the migration task. <i>Do not store personal
        /// data in this field.</i>
        /// </p>
        pub fn set_migration_task_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.migration_task_name = input;
            self
        }
        /// <p>Information about the task's progress and status.</p>
        pub fn task(mut self, input: crate::model::Task) -> Self {
            self.task = Some(input);
            self
        }
        /// <p>Information about the task's progress and status.</p>
        pub fn set_task(mut self, input: std::option::Option<crate::model::Task>) -> Self {
            self.task = input;
            self
        }
        /// <p>The timestamp when the task was gathered.</p>
        pub fn update_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.update_date_time = Some(input);
            self
        }
        /// <p>The timestamp when the task was gathered.</p>
        pub fn set_update_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.update_date_time = input;
            self
        }
        /// <p>Number of seconds after the UpdateDateTime within which the Migration Hub can expect an
        /// update. If Migration Hub does not receive an update within the specified interval, then the
        /// migration task will be considered stale.</p>
        pub fn next_update_seconds(mut self, input: i32) -> Self {
            self.next_update_seconds = Some(input);
            self
        }
        /// <p>Number of seconds after the UpdateDateTime within which the Migration Hub can expect an
        /// update. If Migration Hub does not receive an update within the specified interval, then the
        /// migration task will be considered stale.</p>
        pub fn set_next_update_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.next_update_seconds = input;
            self
        }
        /// <p>Optional boolean flag to indicate whether any effect should take place. Used to test if
        /// the caller has permission to make the call.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Optional boolean flag to indicate whether any effect should take place. Used to test if
        /// the caller has permission to make the call.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// Consumes the builder and constructs a [`NotifyMigrationTaskStateInput`](crate::input::NotifyMigrationTaskStateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::NotifyMigrationTaskStateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::NotifyMigrationTaskStateInput {
                progress_update_stream: self.progress_update_stream,
                migration_task_name: self.migration_task_name,
                task: self.task,
                update_date_time: self.update_date_time,
                next_update_seconds: self.next_update_seconds.unwrap_or_default(),
                dry_run: self.dry_run.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type NotifyMigrationTaskStateInputOperationOutputAlias =
    crate::operation::NotifyMigrationTaskState;
#[doc(hidden)]
pub type NotifyMigrationTaskStateInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl NotifyMigrationTaskStateInput {
    /// Consumes the builder and constructs an Operation<[`NotifyMigrationTaskState`](crate::operation::NotifyMigrationTaskState)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::NotifyMigrationTaskState,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::NotifyMigrationTaskStateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::NotifyMigrationTaskStateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::NotifyMigrationTaskStateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSMigrationHub.NotifyMigrationTaskState",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_notify_migration_task_state(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::NotifyMigrationTaskState::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "NotifyMigrationTaskState",
            "migrationhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`NotifyMigrationTaskStateInput`](crate::input::NotifyMigrationTaskStateInput)
    pub fn builder() -> crate::input::notify_migration_task_state_input::Builder {
        crate::input::notify_migration_task_state_input::Builder::default()
    }
}

/// See [`PutResourceAttributesInput`](crate::input::PutResourceAttributesInput)
pub mod put_resource_attributes_input {
    /// A builder for [`PutResourceAttributesInput`](crate::input::PutResourceAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) progress_update_stream: std::option::Option<std::string::String>,
        pub(crate) migration_task_name: std::option::Option<std::string::String>,
        pub(crate) resource_attribute_list:
            std::option::Option<std::vec::Vec<crate::model::ResourceAttribute>>,
        pub(crate) dry_run: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the ProgressUpdateStream. </p>
        pub fn progress_update_stream(mut self, input: impl Into<std::string::String>) -> Self {
            self.progress_update_stream = Some(input.into());
            self
        }
        /// <p>The name of the ProgressUpdateStream. </p>
        pub fn set_progress_update_stream(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.progress_update_stream = input;
            self
        }
        /// <p>Unique identifier that references the migration task. <i>Do not store personal
        /// data in this field.</i>
        /// </p>
        pub fn migration_task_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.migration_task_name = Some(input.into());
            self
        }
        /// <p>Unique identifier that references the migration task. <i>Do not store personal
        /// data in this field.</i>
        /// </p>
        pub fn set_migration_task_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.migration_task_name = input;
            self
        }
        /// Appends an item to `resource_attribute_list`.
        ///
        /// To override the contents of this collection use [`set_resource_attribute_list`](Self::set_resource_attribute_list).
        ///
        /// <p>Information about the resource that is being migrated. This data will be used to map the
        /// task to a resource in the Application Discovery Service repository.</p>
        /// <note>
        /// <p>Takes the object array of <code>ResourceAttribute</code> where the <code>Type</code>
        /// field is reserved for the following values: <code>IPV4_ADDRESS | IPV6_ADDRESS |
        /// MAC_ADDRESS | FQDN | VM_MANAGER_ID | VM_MANAGED_OBJECT_REFERENCE | VM_NAME | VM_PATH
        /// | BIOS_ID | MOTHERBOARD_SERIAL_NUMBER</code> where the identifying value can be a
        /// string up to 256 characters.</p>
        /// </note>
        /// <important>
        /// <ul>
        /// <li>
        ///
        /// <p>If any "VM" related value is set for a <code>ResourceAttribute</code> object,
        /// it is required that <code>VM_MANAGER_ID</code>, as a minimum, is always set. If
        /// <code>VM_MANAGER_ID</code> is not set, then all "VM" fields will be discarded
        /// and "VM" fields will not be used for matching the migration task to a server in
        /// Application Discovery Service repository. See the <a href="https://docs.aws.amazon.com/migrationhub/latest/ug/API_PutResourceAttributes.html#API_PutResourceAttributes_Examples">Example</a> section below for a use case of specifying "VM" related
        /// values.</p>
        /// </li>
        /// <li>
        /// <p> If a server you are trying to match has multiple IP or MAC addresses, you
        /// should provide as many as you know in separate type/value pairs passed to the
        /// <code>ResourceAttributeList</code> parameter to maximize the chances of
        /// matching.</p>
        /// </li>
        /// </ul>
        /// </important>
        pub fn resource_attribute_list(
            mut self,
            input: impl Into<crate::model::ResourceAttribute>,
        ) -> Self {
            let mut v = self.resource_attribute_list.unwrap_or_default();
            v.push(input.into());
            self.resource_attribute_list = Some(v);
            self
        }
        /// <p>Information about the resource that is being migrated. This data will be used to map the
        /// task to a resource in the Application Discovery Service repository.</p>
        /// <note>
        /// <p>Takes the object array of <code>ResourceAttribute</code> where the <code>Type</code>
        /// field is reserved for the following values: <code>IPV4_ADDRESS | IPV6_ADDRESS |
        /// MAC_ADDRESS | FQDN | VM_MANAGER_ID | VM_MANAGED_OBJECT_REFERENCE | VM_NAME | VM_PATH
        /// | BIOS_ID | MOTHERBOARD_SERIAL_NUMBER</code> where the identifying value can be a
        /// string up to 256 characters.</p>
        /// </note>
        /// <important>
        /// <ul>
        /// <li>
        ///
        /// <p>If any "VM" related value is set for a <code>ResourceAttribute</code> object,
        /// it is required that <code>VM_MANAGER_ID</code>, as a minimum, is always set. If
        /// <code>VM_MANAGER_ID</code> is not set, then all "VM" fields will be discarded
        /// and "VM" fields will not be used for matching the migration task to a server in
        /// Application Discovery Service repository. See the <a href="https://docs.aws.amazon.com/migrationhub/latest/ug/API_PutResourceAttributes.html#API_PutResourceAttributes_Examples">Example</a> section below for a use case of specifying "VM" related
        /// values.</p>
        /// </li>
        /// <li>
        /// <p> If a server you are trying to match has multiple IP or MAC addresses, you
        /// should provide as many as you know in separate type/value pairs passed to the
        /// <code>ResourceAttributeList</code> parameter to maximize the chances of
        /// matching.</p>
        /// </li>
        /// </ul>
        /// </important>
        pub fn set_resource_attribute_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceAttribute>>,
        ) -> Self {
            self.resource_attribute_list = input;
            self
        }
        /// <p>Optional boolean flag to indicate whether any effect should take place. Used to test if
        /// the caller has permission to make the call.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Optional boolean flag to indicate whether any effect should take place. Used to test if
        /// the caller has permission to make the call.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// Consumes the builder and constructs a [`PutResourceAttributesInput`](crate::input::PutResourceAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutResourceAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutResourceAttributesInput {
                progress_update_stream: self.progress_update_stream,
                migration_task_name: self.migration_task_name,
                resource_attribute_list: self.resource_attribute_list,
                dry_run: self.dry_run.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type PutResourceAttributesInputOperationOutputAlias = crate::operation::PutResourceAttributes;
#[doc(hidden)]
pub type PutResourceAttributesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutResourceAttributesInput {
    /// Consumes the builder and constructs an Operation<[`PutResourceAttributes`](crate::operation::PutResourceAttributes)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutResourceAttributes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutResourceAttributesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutResourceAttributesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutResourceAttributesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSMigrationHub.PutResourceAttributes",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_resource_attributes(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutResourceAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutResourceAttributes",
            "migrationhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutResourceAttributesInput`](crate::input::PutResourceAttributesInput)
    pub fn builder() -> crate::input::put_resource_attributes_input::Builder {
        crate::input::put_resource_attributes_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutResourceAttributesInput {
    /// <p>The name of the ProgressUpdateStream. </p>
    pub progress_update_stream: std::option::Option<std::string::String>,
    /// <p>Unique identifier that references the migration task. <i>Do not store personal
    /// data in this field.</i>
    /// </p>
    pub migration_task_name: std::option::Option<std::string::String>,
    /// <p>Information about the resource that is being migrated. This data will be used to map the
    /// task to a resource in the Application Discovery Service repository.</p>
    /// <note>
    /// <p>Takes the object array of <code>ResourceAttribute</code> where the <code>Type</code>
    /// field is reserved for the following values: <code>IPV4_ADDRESS | IPV6_ADDRESS |
    /// MAC_ADDRESS | FQDN | VM_MANAGER_ID | VM_MANAGED_OBJECT_REFERENCE | VM_NAME | VM_PATH
    /// | BIOS_ID | MOTHERBOARD_SERIAL_NUMBER</code> where the identifying value can be a
    /// string up to 256 characters.</p>
    /// </note>
    /// <important>
    /// <ul>
    /// <li>
    ///
    /// <p>If any "VM" related value is set for a <code>ResourceAttribute</code> object,
    /// it is required that <code>VM_MANAGER_ID</code>, as a minimum, is always set. If
    /// <code>VM_MANAGER_ID</code> is not set, then all "VM" fields will be discarded
    /// and "VM" fields will not be used for matching the migration task to a server in
    /// Application Discovery Service repository. See the <a href="https://docs.aws.amazon.com/migrationhub/latest/ug/API_PutResourceAttributes.html#API_PutResourceAttributes_Examples">Example</a> section below for a use case of specifying "VM" related
    /// values.</p>
    /// </li>
    /// <li>
    /// <p> If a server you are trying to match has multiple IP or MAC addresses, you
    /// should provide as many as you know in separate type/value pairs passed to the
    /// <code>ResourceAttributeList</code> parameter to maximize the chances of
    /// matching.</p>
    /// </li>
    /// </ul>
    /// </important>
    pub resource_attribute_list:
        std::option::Option<std::vec::Vec<crate::model::ResourceAttribute>>,
    /// <p>Optional boolean flag to indicate whether any effect should take place. Used to test if
    /// the caller has permission to make the call.</p>
    pub dry_run: bool,
}
impl PutResourceAttributesInput {
    /// <p>The name of the ProgressUpdateStream. </p>
    pub fn progress_update_stream(&self) -> std::option::Option<&str> {
        self.progress_update_stream.as_deref()
    }
    /// <p>Unique identifier that references the migration task. <i>Do not store personal
    /// data in this field.</i>
    /// </p>
    pub fn migration_task_name(&self) -> std::option::Option<&str> {
        self.migration_task_name.as_deref()
    }
    /// <p>Information about the resource that is being migrated. This data will be used to map the
    /// task to a resource in the Application Discovery Service repository.</p>
    /// <note>
    /// <p>Takes the object array of <code>ResourceAttribute</code> where the <code>Type</code>
    /// field is reserved for the following values: <code>IPV4_ADDRESS | IPV6_ADDRESS |
    /// MAC_ADDRESS | FQDN | VM_MANAGER_ID | VM_MANAGED_OBJECT_REFERENCE | VM_NAME | VM_PATH
    /// | BIOS_ID | MOTHERBOARD_SERIAL_NUMBER</code> where the identifying value can be a
    /// string up to 256 characters.</p>
    /// </note>
    /// <important>
    /// <ul>
    /// <li>
    ///
    /// <p>If any "VM" related value is set for a <code>ResourceAttribute</code> object,
    /// it is required that <code>VM_MANAGER_ID</code>, as a minimum, is always set. If
    /// <code>VM_MANAGER_ID</code> is not set, then all "VM" fields will be discarded
    /// and "VM" fields will not be used for matching the migration task to a server in
    /// Application Discovery Service repository. See the <a href="https://docs.aws.amazon.com/migrationhub/latest/ug/API_PutResourceAttributes.html#API_PutResourceAttributes_Examples">Example</a> section below for a use case of specifying "VM" related
    /// values.</p>
    /// </li>
    /// <li>
    /// <p> If a server you are trying to match has multiple IP or MAC addresses, you
    /// should provide as many as you know in separate type/value pairs passed to the
    /// <code>ResourceAttributeList</code> parameter to maximize the chances of
    /// matching.</p>
    /// </li>
    /// </ul>
    /// </important>
    pub fn resource_attribute_list(
        &self,
    ) -> std::option::Option<&[crate::model::ResourceAttribute]> {
        self.resource_attribute_list.as_deref()
    }
    /// <p>Optional boolean flag to indicate whether any effect should take place. Used to test if
    /// the caller has permission to make the call.</p>
    pub fn dry_run(&self) -> bool {
        self.dry_run
    }
}
impl std::fmt::Debug for PutResourceAttributesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutResourceAttributesInput");
        formatter.field("progress_update_stream", &self.progress_update_stream);
        formatter.field("migration_task_name", &self.migration_task_name);
        formatter.field("resource_attribute_list", &self.resource_attribute_list);
        formatter.field("dry_run", &self.dry_run);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotifyMigrationTaskStateInput {
    /// <p>The name of the ProgressUpdateStream. </p>
    pub progress_update_stream: std::option::Option<std::string::String>,
    /// <p>Unique identifier that references the migration task. <i>Do not store personal
    /// data in this field.</i>
    /// </p>
    pub migration_task_name: std::option::Option<std::string::String>,
    /// <p>Information about the task's progress and status.</p>
    pub task: std::option::Option<crate::model::Task>,
    /// <p>The timestamp when the task was gathered.</p>
    pub update_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Number of seconds after the UpdateDateTime within which the Migration Hub can expect an
    /// update. If Migration Hub does not receive an update within the specified interval, then the
    /// migration task will be considered stale.</p>
    pub next_update_seconds: i32,
    /// <p>Optional boolean flag to indicate whether any effect should take place. Used to test if
    /// the caller has permission to make the call.</p>
    pub dry_run: bool,
}
impl NotifyMigrationTaskStateInput {
    /// <p>The name of the ProgressUpdateStream. </p>
    pub fn progress_update_stream(&self) -> std::option::Option<&str> {
        self.progress_update_stream.as_deref()
    }
    /// <p>Unique identifier that references the migration task. <i>Do not store personal
    /// data in this field.</i>
    /// </p>
    pub fn migration_task_name(&self) -> std::option::Option<&str> {
        self.migration_task_name.as_deref()
    }
    /// <p>Information about the task's progress and status.</p>
    pub fn task(&self) -> std::option::Option<&crate::model::Task> {
        self.task.as_ref()
    }
    /// <p>The timestamp when the task was gathered.</p>
    pub fn update_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.update_date_time.as_ref()
    }
    /// <p>Number of seconds after the UpdateDateTime within which the Migration Hub can expect an
    /// update. If Migration Hub does not receive an update within the specified interval, then the
    /// migration task will be considered stale.</p>
    pub fn next_update_seconds(&self) -> i32 {
        self.next_update_seconds
    }
    /// <p>Optional boolean flag to indicate whether any effect should take place. Used to test if
    /// the caller has permission to make the call.</p>
    pub fn dry_run(&self) -> bool {
        self.dry_run
    }
}
impl std::fmt::Debug for NotifyMigrationTaskStateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotifyMigrationTaskStateInput");
        formatter.field("progress_update_stream", &self.progress_update_stream);
        formatter.field("migration_task_name", &self.migration_task_name);
        formatter.field("task", &self.task);
        formatter.field("update_date_time", &self.update_date_time);
        formatter.field("next_update_seconds", &self.next_update_seconds);
        formatter.field("dry_run", &self.dry_run);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotifyApplicationStateInput {
    /// <p>The configurationId in Application Discovery Service that uniquely identifies the
    /// grouped application.</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>Status of the application - Not Started, In-Progress, Complete.</p>
    pub status: std::option::Option<crate::model::ApplicationStatus>,
    /// <p>The timestamp when the application state changed.</p>
    pub update_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Optional boolean flag to indicate whether any effect should take place. Used to test if
    /// the caller has permission to make the call.</p>
    pub dry_run: bool,
}
impl NotifyApplicationStateInput {
    /// <p>The configurationId in Application Discovery Service that uniquely identifies the
    /// grouped application.</p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
    /// <p>Status of the application - Not Started, In-Progress, Complete.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ApplicationStatus> {
        self.status.as_ref()
    }
    /// <p>The timestamp when the application state changed.</p>
    pub fn update_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.update_date_time.as_ref()
    }
    /// <p>Optional boolean flag to indicate whether any effect should take place. Used to test if
    /// the caller has permission to make the call.</p>
    pub fn dry_run(&self) -> bool {
        self.dry_run
    }
}
impl std::fmt::Debug for NotifyApplicationStateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotifyApplicationStateInput");
        formatter.field("application_id", &self.application_id);
        formatter.field("status", &self.status);
        formatter.field("update_date_time", &self.update_date_time);
        formatter.field("dry_run", &self.dry_run);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListProgressUpdateStreamsInput {
    /// <p>If a <code>NextToken</code> was returned by a previous call, there are more results
    /// available. To retrieve the next page of results, make the call again using the returned
    /// token in <code>NextToken</code>.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Filter to limit the maximum number of results to list per page.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListProgressUpdateStreamsInput {
    /// <p>If a <code>NextToken</code> was returned by a previous call, there are more results
    /// available. To retrieve the next page of results, make the call again using the returned
    /// token in <code>NextToken</code>.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Filter to limit the maximum number of results to list per page.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListProgressUpdateStreamsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListProgressUpdateStreamsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListMigrationTasksInput {
    /// <p>If a <code>NextToken</code> was returned by a previous call, there are more results
    /// available. To retrieve the next page of results, make the call again using the returned
    /// token in <code>NextToken</code>.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Value to specify how many results are returned per page.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>Filter migration tasks by discovered resource name.</p>
    pub resource_name: std::option::Option<std::string::String>,
}
impl ListMigrationTasksInput {
    /// <p>If a <code>NextToken</code> was returned by a previous call, there are more results
    /// available. To retrieve the next page of results, make the call again using the returned
    /// token in <code>NextToken</code>.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Value to specify how many results are returned per page.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>Filter migration tasks by discovered resource name.</p>
    pub fn resource_name(&self) -> std::option::Option<&str> {
        self.resource_name.as_deref()
    }
}
impl std::fmt::Debug for ListMigrationTasksInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListMigrationTasksInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("resource_name", &self.resource_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDiscoveredResourcesInput {
    /// <p>The name of the ProgressUpdateStream.</p>
    pub progress_update_stream: std::option::Option<std::string::String>,
    /// <p>The name of the MigrationTask. <i>Do not store personal data in this
    /// field.</i>
    /// </p>
    pub migration_task_name: std::option::Option<std::string::String>,
    /// <p>If a <code>NextToken</code> was returned by a previous call, there are more results
    /// available. To retrieve the next page of results, make the call again using the returned
    /// token in <code>NextToken</code>.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results returned per page.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListDiscoveredResourcesInput {
    /// <p>The name of the ProgressUpdateStream.</p>
    pub fn progress_update_stream(&self) -> std::option::Option<&str> {
        self.progress_update_stream.as_deref()
    }
    /// <p>The name of the MigrationTask. <i>Do not store personal data in this
    /// field.</i>
    /// </p>
    pub fn migration_task_name(&self) -> std::option::Option<&str> {
        self.migration_task_name.as_deref()
    }
    /// <p>If a <code>NextToken</code> was returned by a previous call, there are more results
    /// available. To retrieve the next page of results, make the call again using the returned
    /// token in <code>NextToken</code>.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results returned per page.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListDiscoveredResourcesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDiscoveredResourcesInput");
        formatter.field("progress_update_stream", &self.progress_update_stream);
        formatter.field("migration_task_name", &self.migration_task_name);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListCreatedArtifactsInput {
    /// <p>The name of the ProgressUpdateStream. </p>
    pub progress_update_stream: std::option::Option<std::string::String>,
    /// <p>Unique identifier that references the migration task. <i>Do not store personal
    /// data in this field.</i>
    /// </p>
    pub migration_task_name: std::option::Option<std::string::String>,
    /// <p>If a <code>NextToken</code> was returned by a previous call, there are more results
    /// available. To retrieve the next page of results, make the call again using the returned
    /// token in <code>NextToken</code>.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Maximum number of results to be returned per page.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListCreatedArtifactsInput {
    /// <p>The name of the ProgressUpdateStream. </p>
    pub fn progress_update_stream(&self) -> std::option::Option<&str> {
        self.progress_update_stream.as_deref()
    }
    /// <p>Unique identifier that references the migration task. <i>Do not store personal
    /// data in this field.</i>
    /// </p>
    pub fn migration_task_name(&self) -> std::option::Option<&str> {
        self.migration_task_name.as_deref()
    }
    /// <p>If a <code>NextToken</code> was returned by a previous call, there are more results
    /// available. To retrieve the next page of results, make the call again using the returned
    /// token in <code>NextToken</code>.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Maximum number of results to be returned per page.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListCreatedArtifactsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListCreatedArtifactsInput");
        formatter.field("progress_update_stream", &self.progress_update_stream);
        formatter.field("migration_task_name", &self.migration_task_name);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListApplicationStatesInput {
    /// <p>The configurationIds from the Application Discovery Service that uniquely identifies
    /// your applications.</p>
    pub application_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>If a <code>NextToken</code> was returned by a previous call, there are more results
    /// available. To retrieve the next page of results, make the call again using the returned
    /// token in <code>NextToken</code>.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Maximum number of results to be returned per page.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListApplicationStatesInput {
    /// <p>The configurationIds from the Application Discovery Service that uniquely identifies
    /// your applications.</p>
    pub fn application_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.application_ids.as_deref()
    }
    /// <p>If a <code>NextToken</code> was returned by a previous call, there are more results
    /// available. To retrieve the next page of results, make the call again using the returned
    /// token in <code>NextToken</code>.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Maximum number of results to be returned per page.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListApplicationStatesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListApplicationStatesInput");
        formatter.field("application_ids", &self.application_ids);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImportMigrationTaskInput {
    /// <p>The name of the ProgressUpdateStream. ></p>
    pub progress_update_stream: std::option::Option<std::string::String>,
    /// <p>Unique identifier that references the migration task. <i>Do not store personal
    /// data in this field.</i>
    /// </p>
    pub migration_task_name: std::option::Option<std::string::String>,
    /// <p>Optional boolean flag to indicate whether any effect should take place. Used to test if
    /// the caller has permission to make the call.</p>
    pub dry_run: bool,
}
impl ImportMigrationTaskInput {
    /// <p>The name of the ProgressUpdateStream. ></p>
    pub fn progress_update_stream(&self) -> std::option::Option<&str> {
        self.progress_update_stream.as_deref()
    }
    /// <p>Unique identifier that references the migration task. <i>Do not store personal
    /// data in this field.</i>
    /// </p>
    pub fn migration_task_name(&self) -> std::option::Option<&str> {
        self.migration_task_name.as_deref()
    }
    /// <p>Optional boolean flag to indicate whether any effect should take place. Used to test if
    /// the caller has permission to make the call.</p>
    pub fn dry_run(&self) -> bool {
        self.dry_run
    }
}
impl std::fmt::Debug for ImportMigrationTaskInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImportMigrationTaskInput");
        formatter.field("progress_update_stream", &self.progress_update_stream);
        formatter.field("migration_task_name", &self.migration_task_name);
        formatter.field("dry_run", &self.dry_run);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateDiscoveredResourceInput {
    /// <p>The name of the ProgressUpdateStream.</p>
    pub progress_update_stream: std::option::Option<std::string::String>,
    /// <p>The identifier given to the MigrationTask. <i>Do not store personal data in this
    /// field.</i>
    /// </p>
    pub migration_task_name: std::option::Option<std::string::String>,
    /// <p>ConfigurationId of the Application Discovery Service resource to be
    /// disassociated.</p>
    pub configuration_id: std::option::Option<std::string::String>,
    /// <p>Optional boolean flag to indicate whether any effect should take place. Used to test if
    /// the caller has permission to make the call.</p>
    pub dry_run: bool,
}
impl DisassociateDiscoveredResourceInput {
    /// <p>The name of the ProgressUpdateStream.</p>
    pub fn progress_update_stream(&self) -> std::option::Option<&str> {
        self.progress_update_stream.as_deref()
    }
    /// <p>The identifier given to the MigrationTask. <i>Do not store personal data in this
    /// field.</i>
    /// </p>
    pub fn migration_task_name(&self) -> std::option::Option<&str> {
        self.migration_task_name.as_deref()
    }
    /// <p>ConfigurationId of the Application Discovery Service resource to be
    /// disassociated.</p>
    pub fn configuration_id(&self) -> std::option::Option<&str> {
        self.configuration_id.as_deref()
    }
    /// <p>Optional boolean flag to indicate whether any effect should take place. Used to test if
    /// the caller has permission to make the call.</p>
    pub fn dry_run(&self) -> bool {
        self.dry_run
    }
}
impl std::fmt::Debug for DisassociateDiscoveredResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateDiscoveredResourceInput");
        formatter.field("progress_update_stream", &self.progress_update_stream);
        formatter.field("migration_task_name", &self.migration_task_name);
        formatter.field("configuration_id", &self.configuration_id);
        formatter.field("dry_run", &self.dry_run);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateCreatedArtifactInput {
    /// <p>The name of the ProgressUpdateStream. </p>
    pub progress_update_stream: std::option::Option<std::string::String>,
    /// <p>Unique identifier that references the migration task to be disassociated with the
    /// artifact. <i>Do not store personal data in this field.</i>
    /// </p>
    pub migration_task_name: std::option::Option<std::string::String>,
    /// <p>An ARN of the AWS resource related to the migration (e.g., AMI, EC2 instance, RDS
    /// instance, etc.)</p>
    pub created_artifact_name: std::option::Option<std::string::String>,
    /// <p>Optional boolean flag to indicate whether any effect should take place. Used to test if
    /// the caller has permission to make the call.</p>
    pub dry_run: bool,
}
impl DisassociateCreatedArtifactInput {
    /// <p>The name of the ProgressUpdateStream. </p>
    pub fn progress_update_stream(&self) -> std::option::Option<&str> {
        self.progress_update_stream.as_deref()
    }
    /// <p>Unique identifier that references the migration task to be disassociated with the
    /// artifact. <i>Do not store personal data in this field.</i>
    /// </p>
    pub fn migration_task_name(&self) -> std::option::Option<&str> {
        self.migration_task_name.as_deref()
    }
    /// <p>An ARN of the AWS resource related to the migration (e.g., AMI, EC2 instance, RDS
    /// instance, etc.)</p>
    pub fn created_artifact_name(&self) -> std::option::Option<&str> {
        self.created_artifact_name.as_deref()
    }
    /// <p>Optional boolean flag to indicate whether any effect should take place. Used to test if
    /// the caller has permission to make the call.</p>
    pub fn dry_run(&self) -> bool {
        self.dry_run
    }
}
impl std::fmt::Debug for DisassociateCreatedArtifactInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateCreatedArtifactInput");
        formatter.field("progress_update_stream", &self.progress_update_stream);
        formatter.field("migration_task_name", &self.migration_task_name);
        formatter.field("created_artifact_name", &self.created_artifact_name);
        formatter.field("dry_run", &self.dry_run);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeMigrationTaskInput {
    /// <p>The name of the ProgressUpdateStream. </p>
    pub progress_update_stream: std::option::Option<std::string::String>,
    /// <p>The identifier given to the MigrationTask. <i>Do not store personal data in this
    /// field.</i>
    /// </p>
    pub migration_task_name: std::option::Option<std::string::String>,
}
impl DescribeMigrationTaskInput {
    /// <p>The name of the ProgressUpdateStream. </p>
    pub fn progress_update_stream(&self) -> std::option::Option<&str> {
        self.progress_update_stream.as_deref()
    }
    /// <p>The identifier given to the MigrationTask. <i>Do not store personal data in this
    /// field.</i>
    /// </p>
    pub fn migration_task_name(&self) -> std::option::Option<&str> {
        self.migration_task_name.as_deref()
    }
}
impl std::fmt::Debug for DescribeMigrationTaskInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeMigrationTaskInput");
        formatter.field("progress_update_stream", &self.progress_update_stream);
        formatter.field("migration_task_name", &self.migration_task_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeApplicationStateInput {
    /// <p>The configurationId in Application Discovery Service that uniquely identifies the
    /// grouped application.</p>
    pub application_id: std::option::Option<std::string::String>,
}
impl DescribeApplicationStateInput {
    /// <p>The configurationId in Application Discovery Service that uniquely identifies the
    /// grouped application.</p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeApplicationStateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeApplicationStateInput");
        formatter.field("application_id", &self.application_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteProgressUpdateStreamInput {
    /// <p>The name of the ProgressUpdateStream. <i>Do not store personal data in this
    /// field.</i>
    /// </p>
    pub progress_update_stream_name: std::option::Option<std::string::String>,
    /// <p>Optional boolean flag to indicate whether any effect should take place. Used to test if
    /// the caller has permission to make the call.</p>
    pub dry_run: bool,
}
impl DeleteProgressUpdateStreamInput {
    /// <p>The name of the ProgressUpdateStream. <i>Do not store personal data in this
    /// field.</i>
    /// </p>
    pub fn progress_update_stream_name(&self) -> std::option::Option<&str> {
        self.progress_update_stream_name.as_deref()
    }
    /// <p>Optional boolean flag to indicate whether any effect should take place. Used to test if
    /// the caller has permission to make the call.</p>
    pub fn dry_run(&self) -> bool {
        self.dry_run
    }
}
impl std::fmt::Debug for DeleteProgressUpdateStreamInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteProgressUpdateStreamInput");
        formatter.field(
            "progress_update_stream_name",
            &self.progress_update_stream_name,
        );
        formatter.field("dry_run", &self.dry_run);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateProgressUpdateStreamInput {
    /// <p>The name of the ProgressUpdateStream. <i>Do not store personal data in this
    /// field.</i>
    /// </p>
    pub progress_update_stream_name: std::option::Option<std::string::String>,
    /// <p>Optional boolean flag to indicate whether any effect should take place. Used to test if
    /// the caller has permission to make the call.</p>
    pub dry_run: bool,
}
impl CreateProgressUpdateStreamInput {
    /// <p>The name of the ProgressUpdateStream. <i>Do not store personal data in this
    /// field.</i>
    /// </p>
    pub fn progress_update_stream_name(&self) -> std::option::Option<&str> {
        self.progress_update_stream_name.as_deref()
    }
    /// <p>Optional boolean flag to indicate whether any effect should take place. Used to test if
    /// the caller has permission to make the call.</p>
    pub fn dry_run(&self) -> bool {
        self.dry_run
    }
}
impl std::fmt::Debug for CreateProgressUpdateStreamInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateProgressUpdateStreamInput");
        formatter.field(
            "progress_update_stream_name",
            &self.progress_update_stream_name,
        );
        formatter.field("dry_run", &self.dry_run);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateDiscoveredResourceInput {
    /// <p>The name of the ProgressUpdateStream.</p>
    pub progress_update_stream: std::option::Option<std::string::String>,
    /// <p>The identifier given to the MigrationTask. <i>Do not store personal data in this
    /// field.</i>
    /// </p>
    pub migration_task_name: std::option::Option<std::string::String>,
    /// <p>Object representing a Resource.</p>
    pub discovered_resource: std::option::Option<crate::model::DiscoveredResource>,
    /// <p>Optional boolean flag to indicate whether any effect should take place. Used to test if
    /// the caller has permission to make the call.</p>
    pub dry_run: bool,
}
impl AssociateDiscoveredResourceInput {
    /// <p>The name of the ProgressUpdateStream.</p>
    pub fn progress_update_stream(&self) -> std::option::Option<&str> {
        self.progress_update_stream.as_deref()
    }
    /// <p>The identifier given to the MigrationTask. <i>Do not store personal data in this
    /// field.</i>
    /// </p>
    pub fn migration_task_name(&self) -> std::option::Option<&str> {
        self.migration_task_name.as_deref()
    }
    /// <p>Object representing a Resource.</p>
    pub fn discovered_resource(&self) -> std::option::Option<&crate::model::DiscoveredResource> {
        self.discovered_resource.as_ref()
    }
    /// <p>Optional boolean flag to indicate whether any effect should take place. Used to test if
    /// the caller has permission to make the call.</p>
    pub fn dry_run(&self) -> bool {
        self.dry_run
    }
}
impl std::fmt::Debug for AssociateDiscoveredResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateDiscoveredResourceInput");
        formatter.field("progress_update_stream", &self.progress_update_stream);
        formatter.field("migration_task_name", &self.migration_task_name);
        formatter.field("discovered_resource", &self.discovered_resource);
        formatter.field("dry_run", &self.dry_run);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateCreatedArtifactInput {
    /// <p>The name of the ProgressUpdateStream. </p>
    pub progress_update_stream: std::option::Option<std::string::String>,
    /// <p>Unique identifier that references the migration task. <i>Do not store personal
    /// data in this field.</i>
    /// </p>
    pub migration_task_name: std::option::Option<std::string::String>,
    /// <p>An ARN of the AWS resource related to the migration (e.g., AMI, EC2 instance, RDS
    /// instance, etc.) </p>
    pub created_artifact: std::option::Option<crate::model::CreatedArtifact>,
    /// <p>Optional boolean flag to indicate whether any effect should take place. Used to test if
    /// the caller has permission to make the call.</p>
    pub dry_run: bool,
}
impl AssociateCreatedArtifactInput {
    /// <p>The name of the ProgressUpdateStream. </p>
    pub fn progress_update_stream(&self) -> std::option::Option<&str> {
        self.progress_update_stream.as_deref()
    }
    /// <p>Unique identifier that references the migration task. <i>Do not store personal
    /// data in this field.</i>
    /// </p>
    pub fn migration_task_name(&self) -> std::option::Option<&str> {
        self.migration_task_name.as_deref()
    }
    /// <p>An ARN of the AWS resource related to the migration (e.g., AMI, EC2 instance, RDS
    /// instance, etc.) </p>
    pub fn created_artifact(&self) -> std::option::Option<&crate::model::CreatedArtifact> {
        self.created_artifact.as_ref()
    }
    /// <p>Optional boolean flag to indicate whether any effect should take place. Used to test if
    /// the caller has permission to make the call.</p>
    pub fn dry_run(&self) -> bool {
        self.dry_run
    }
}
impl std::fmt::Debug for AssociateCreatedArtifactInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateCreatedArtifactInput");
        formatter.field("progress_update_stream", &self.progress_update_stream);
        formatter.field("migration_task_name", &self.migration_task_name);
        formatter.field("created_artifact", &self.created_artifact);
        formatter.field("dry_run", &self.dry_run);
        formatter.finish()
    }
}
