// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// All possible error types for this service.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum Error {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Exception raised to indicate a successfully authorized action when the
    /// <code>DryRun</code> flag is set to "true".</p>
    DryRunOperation(crate::error::DryRunOperation),
    /// <p>The home region is not set. Set the home region to continue.</p>
    HomeRegionNotSetException(crate::error::HomeRegionNotSetException),
    /// <p>Exception raised when an internal, configuration, or dependency error is
    /// encountered.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>Exception raised when the provided input violates a policy constraint or is entered in
    /// the wrong format or data type.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Exception raised when there are problems accessing Application Discovery Service
    /// (Application Discovery Service); most likely due to a misconfigured policy or the
    /// <code>migrationhub-discovery</code> role is missing or not configured correctly.</p>
    PolicyErrorException(crate::error::PolicyErrorException),
    /// <p>Exception raised when the request references a resource (Application Discovery Service
    /// configuration, update stream, migration task, etc.) that does not exist in Application
    /// Discovery Service (Application Discovery Service) or in Migration Hub's repository.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Exception raised when there is an internal, configuration, or dependency error
    /// encountered.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Exception raised to indicate a request was not authorized when the <code>DryRun</code>
    /// flag is set to "true".</p>
    UnauthorizedOperation(crate::error::UnauthorizedOperation),
    /// An unhandled error occurred.
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Error::AccessDeniedException(inner) => inner.fmt(f),
            Error::DryRunOperation(inner) => inner.fmt(f),
            Error::HomeRegionNotSetException(inner) => inner.fmt(f),
            Error::InternalServerError(inner) => inner.fmt(f),
            Error::InvalidInputException(inner) => inner.fmt(f),
            Error::PolicyErrorException(inner) => inner.fmt(f),
            Error::ResourceNotFoundException(inner) => inner.fmt(f),
            Error::ServiceUnavailableException(inner) => inner.fmt(f),
            Error::ThrottlingException(inner) => inner.fmt(f),
            Error::UnauthorizedOperation(inner) => inner.fmt(f),
            Error::Unhandled(inner) => inner.fmt(f),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AssociateCreatedArtifactError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::AssociateCreatedArtifactError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::AssociateCreatedArtifactErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::AssociateCreatedArtifactErrorKind::DryRunOperation(inner) => {
                    Error::DryRunOperation(inner)
                }
                crate::error::AssociateCreatedArtifactErrorKind::HomeRegionNotSetException(
                    inner,
                ) => Error::HomeRegionNotSetException(inner),
                crate::error::AssociateCreatedArtifactErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::AssociateCreatedArtifactErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::AssociateCreatedArtifactErrorKind::ResourceNotFoundException(
                    inner,
                ) => Error::ResourceNotFoundException(inner),
                crate::error::AssociateCreatedArtifactErrorKind::ServiceUnavailableException(
                    inner,
                ) => Error::ServiceUnavailableException(inner),
                crate::error::AssociateCreatedArtifactErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::AssociateCreatedArtifactErrorKind::UnauthorizedOperation(inner) => {
                    Error::UnauthorizedOperation(inner)
                }
                crate::error::AssociateCreatedArtifactErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AssociateDiscoveredResourceError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::AssociateDiscoveredResourceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::AssociateDiscoveredResourceErrorKind::AccessDeniedException(
                    inner,
                ) => Error::AccessDeniedException(inner),
                crate::error::AssociateDiscoveredResourceErrorKind::DryRunOperation(inner) => {
                    Error::DryRunOperation(inner)
                }
                crate::error::AssociateDiscoveredResourceErrorKind::HomeRegionNotSetException(
                    inner,
                ) => Error::HomeRegionNotSetException(inner),
                crate::error::AssociateDiscoveredResourceErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::AssociateDiscoveredResourceErrorKind::InvalidInputException(
                    inner,
                ) => Error::InvalidInputException(inner),
                crate::error::AssociateDiscoveredResourceErrorKind::PolicyErrorException(inner) => {
                    Error::PolicyErrorException(inner)
                }
                crate::error::AssociateDiscoveredResourceErrorKind::ResourceNotFoundException(
                    inner,
                ) => Error::ResourceNotFoundException(inner),
                crate::error::AssociateDiscoveredResourceErrorKind::ServiceUnavailableException(
                    inner,
                ) => Error::ServiceUnavailableException(inner),
                crate::error::AssociateDiscoveredResourceErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::AssociateDiscoveredResourceErrorKind::UnauthorizedOperation(
                    inner,
                ) => Error::UnauthorizedOperation(inner),
                crate::error::AssociateDiscoveredResourceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateProgressUpdateStreamError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateProgressUpdateStreamError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateProgressUpdateStreamErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::CreateProgressUpdateStreamErrorKind::DryRunOperation(inner) => {
                    Error::DryRunOperation(inner)
                }
                crate::error::CreateProgressUpdateStreamErrorKind::HomeRegionNotSetException(
                    inner,
                ) => Error::HomeRegionNotSetException(inner),
                crate::error::CreateProgressUpdateStreamErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::CreateProgressUpdateStreamErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::CreateProgressUpdateStreamErrorKind::ServiceUnavailableException(
                    inner,
                ) => Error::ServiceUnavailableException(inner),
                crate::error::CreateProgressUpdateStreamErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::CreateProgressUpdateStreamErrorKind::UnauthorizedOperation(inner) => {
                    Error::UnauthorizedOperation(inner)
                }
                crate::error::CreateProgressUpdateStreamErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteProgressUpdateStreamError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteProgressUpdateStreamError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteProgressUpdateStreamErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DeleteProgressUpdateStreamErrorKind::DryRunOperation(inner) => {
                    Error::DryRunOperation(inner)
                }
                crate::error::DeleteProgressUpdateStreamErrorKind::HomeRegionNotSetException(
                    inner,
                ) => Error::HomeRegionNotSetException(inner),
                crate::error::DeleteProgressUpdateStreamErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DeleteProgressUpdateStreamErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::DeleteProgressUpdateStreamErrorKind::ResourceNotFoundException(
                    inner,
                ) => Error::ResourceNotFoundException(inner),
                crate::error::DeleteProgressUpdateStreamErrorKind::ServiceUnavailableException(
                    inner,
                ) => Error::ServiceUnavailableException(inner),
                crate::error::DeleteProgressUpdateStreamErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::DeleteProgressUpdateStreamErrorKind::UnauthorizedOperation(inner) => {
                    Error::UnauthorizedOperation(inner)
                }
                crate::error::DeleteProgressUpdateStreamErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeApplicationStateError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeApplicationStateError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeApplicationStateErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DescribeApplicationStateErrorKind::HomeRegionNotSetException(
                    inner,
                ) => Error::HomeRegionNotSetException(inner),
                crate::error::DescribeApplicationStateErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DescribeApplicationStateErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::DescribeApplicationStateErrorKind::PolicyErrorException(inner) => {
                    Error::PolicyErrorException(inner)
                }
                crate::error::DescribeApplicationStateErrorKind::ResourceNotFoundException(
                    inner,
                ) => Error::ResourceNotFoundException(inner),
                crate::error::DescribeApplicationStateErrorKind::ServiceUnavailableException(
                    inner,
                ) => Error::ServiceUnavailableException(inner),
                crate::error::DescribeApplicationStateErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::DescribeApplicationStateErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeMigrationTaskError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeMigrationTaskError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeMigrationTaskErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DescribeMigrationTaskErrorKind::HomeRegionNotSetException(inner) => {
                    Error::HomeRegionNotSetException(inner)
                }
                crate::error::DescribeMigrationTaskErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DescribeMigrationTaskErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::DescribeMigrationTaskErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::DescribeMigrationTaskErrorKind::ServiceUnavailableException(
                    inner,
                ) => Error::ServiceUnavailableException(inner),
                crate::error::DescribeMigrationTaskErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::DescribeMigrationTaskErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DisassociateCreatedArtifactError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DisassociateCreatedArtifactError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DisassociateCreatedArtifactErrorKind::AccessDeniedException(
                    inner,
                ) => Error::AccessDeniedException(inner),
                crate::error::DisassociateCreatedArtifactErrorKind::DryRunOperation(inner) => {
                    Error::DryRunOperation(inner)
                }
                crate::error::DisassociateCreatedArtifactErrorKind::HomeRegionNotSetException(
                    inner,
                ) => Error::HomeRegionNotSetException(inner),
                crate::error::DisassociateCreatedArtifactErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DisassociateCreatedArtifactErrorKind::InvalidInputException(
                    inner,
                ) => Error::InvalidInputException(inner),
                crate::error::DisassociateCreatedArtifactErrorKind::ResourceNotFoundException(
                    inner,
                ) => Error::ResourceNotFoundException(inner),
                crate::error::DisassociateCreatedArtifactErrorKind::ServiceUnavailableException(
                    inner,
                ) => Error::ServiceUnavailableException(inner),
                crate::error::DisassociateCreatedArtifactErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::DisassociateCreatedArtifactErrorKind::UnauthorizedOperation(
                    inner,
                ) => Error::UnauthorizedOperation(inner),
                crate::error::DisassociateCreatedArtifactErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DisassociateDiscoveredResourceError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DisassociateDiscoveredResourceError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DisassociateDiscoveredResourceErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::DisassociateDiscoveredResourceErrorKind::DryRunOperation(inner) => Error::DryRunOperation(inner),
                crate::error::DisassociateDiscoveredResourceErrorKind::HomeRegionNotSetException(inner) => Error::HomeRegionNotSetException(inner),
                crate::error::DisassociateDiscoveredResourceErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::DisassociateDiscoveredResourceErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::DisassociateDiscoveredResourceErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::DisassociateDiscoveredResourceErrorKind::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
                crate::error::DisassociateDiscoveredResourceErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::DisassociateDiscoveredResourceErrorKind::UnauthorizedOperation(inner) => Error::UnauthorizedOperation(inner),
                crate::error::DisassociateDiscoveredResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ImportMigrationTaskError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ImportMigrationTaskError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ImportMigrationTaskErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ImportMigrationTaskErrorKind::DryRunOperation(inner) => {
                    Error::DryRunOperation(inner)
                }
                crate::error::ImportMigrationTaskErrorKind::HomeRegionNotSetException(inner) => {
                    Error::HomeRegionNotSetException(inner)
                }
                crate::error::ImportMigrationTaskErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::ImportMigrationTaskErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::ImportMigrationTaskErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::ImportMigrationTaskErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::ImportMigrationTaskErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::ImportMigrationTaskErrorKind::UnauthorizedOperation(inner) => {
                    Error::UnauthorizedOperation(inner)
                }
                crate::error::ImportMigrationTaskErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListApplicationStatesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListApplicationStatesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListApplicationStatesErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ListApplicationStatesErrorKind::HomeRegionNotSetException(inner) => {
                    Error::HomeRegionNotSetException(inner)
                }
                crate::error::ListApplicationStatesErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::ListApplicationStatesErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::ListApplicationStatesErrorKind::ServiceUnavailableException(
                    inner,
                ) => Error::ServiceUnavailableException(inner),
                crate::error::ListApplicationStatesErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::ListApplicationStatesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListCreatedArtifactsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListCreatedArtifactsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListCreatedArtifactsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ListCreatedArtifactsErrorKind::HomeRegionNotSetException(inner) => {
                    Error::HomeRegionNotSetException(inner)
                }
                crate::error::ListCreatedArtifactsErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::ListCreatedArtifactsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::ListCreatedArtifactsErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::ListCreatedArtifactsErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::ListCreatedArtifactsErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::ListCreatedArtifactsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListDiscoveredResourcesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListDiscoveredResourcesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListDiscoveredResourcesErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ListDiscoveredResourcesErrorKind::HomeRegionNotSetException(
                    inner,
                ) => Error::HomeRegionNotSetException(inner),
                crate::error::ListDiscoveredResourcesErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::ListDiscoveredResourcesErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::ListDiscoveredResourcesErrorKind::ResourceNotFoundException(
                    inner,
                ) => Error::ResourceNotFoundException(inner),
                crate::error::ListDiscoveredResourcesErrorKind::ServiceUnavailableException(
                    inner,
                ) => Error::ServiceUnavailableException(inner),
                crate::error::ListDiscoveredResourcesErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::ListDiscoveredResourcesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListMigrationTasksError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListMigrationTasksError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListMigrationTasksErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ListMigrationTasksErrorKind::HomeRegionNotSetException(inner) => {
                    Error::HomeRegionNotSetException(inner)
                }
                crate::error::ListMigrationTasksErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::ListMigrationTasksErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::ListMigrationTasksErrorKind::PolicyErrorException(inner) => {
                    Error::PolicyErrorException(inner)
                }
                crate::error::ListMigrationTasksErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::ListMigrationTasksErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::ListMigrationTasksErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::ListMigrationTasksErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListProgressUpdateStreamsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListProgressUpdateStreamsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListProgressUpdateStreamsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ListProgressUpdateStreamsErrorKind::HomeRegionNotSetException(
                    inner,
                ) => Error::HomeRegionNotSetException(inner),
                crate::error::ListProgressUpdateStreamsErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::ListProgressUpdateStreamsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::ListProgressUpdateStreamsErrorKind::ServiceUnavailableException(
                    inner,
                ) => Error::ServiceUnavailableException(inner),
                crate::error::ListProgressUpdateStreamsErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::ListProgressUpdateStreamsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::NotifyApplicationStateError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::NotifyApplicationStateError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::NotifyApplicationStateErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::NotifyApplicationStateErrorKind::DryRunOperation(inner) => {
                    Error::DryRunOperation(inner)
                }
                crate::error::NotifyApplicationStateErrorKind::HomeRegionNotSetException(inner) => {
                    Error::HomeRegionNotSetException(inner)
                }
                crate::error::NotifyApplicationStateErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::NotifyApplicationStateErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::NotifyApplicationStateErrorKind::PolicyErrorException(inner) => {
                    Error::PolicyErrorException(inner)
                }
                crate::error::NotifyApplicationStateErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::NotifyApplicationStateErrorKind::ServiceUnavailableException(
                    inner,
                ) => Error::ServiceUnavailableException(inner),
                crate::error::NotifyApplicationStateErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::NotifyApplicationStateErrorKind::UnauthorizedOperation(inner) => {
                    Error::UnauthorizedOperation(inner)
                }
                crate::error::NotifyApplicationStateErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::NotifyMigrationTaskStateError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::NotifyMigrationTaskStateError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::NotifyMigrationTaskStateErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::NotifyMigrationTaskStateErrorKind::DryRunOperation(inner) => {
                    Error::DryRunOperation(inner)
                }
                crate::error::NotifyMigrationTaskStateErrorKind::HomeRegionNotSetException(
                    inner,
                ) => Error::HomeRegionNotSetException(inner),
                crate::error::NotifyMigrationTaskStateErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::NotifyMigrationTaskStateErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::NotifyMigrationTaskStateErrorKind::ResourceNotFoundException(
                    inner,
                ) => Error::ResourceNotFoundException(inner),
                crate::error::NotifyMigrationTaskStateErrorKind::ServiceUnavailableException(
                    inner,
                ) => Error::ServiceUnavailableException(inner),
                crate::error::NotifyMigrationTaskStateErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::NotifyMigrationTaskStateErrorKind::UnauthorizedOperation(inner) => {
                    Error::UnauthorizedOperation(inner)
                }
                crate::error::NotifyMigrationTaskStateErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutResourceAttributesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::PutResourceAttributesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::PutResourceAttributesErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::PutResourceAttributesErrorKind::DryRunOperation(inner) => {
                    Error::DryRunOperation(inner)
                }
                crate::error::PutResourceAttributesErrorKind::HomeRegionNotSetException(inner) => {
                    Error::HomeRegionNotSetException(inner)
                }
                crate::error::PutResourceAttributesErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::PutResourceAttributesErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::PutResourceAttributesErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::PutResourceAttributesErrorKind::ServiceUnavailableException(
                    inner,
                ) => Error::ServiceUnavailableException(inner),
                crate::error::PutResourceAttributesErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::PutResourceAttributesErrorKind::UnauthorizedOperation(inner) => {
                    Error::UnauthorizedOperation(inner)
                }
                crate::error::PutResourceAttributesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl std::error::Error for Error {}
