// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AssociateCreatedArtifact` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateCreatedArtifactError {
    /// Kind of error that occurred.
    pub kind: AssociateCreatedArtifactErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateCreatedArtifact` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateCreatedArtifactErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Exception raised to indicate a successfully authorized action when the
    /// <code>DryRun</code> flag is set to "true".</p>
    DryRunOperation(crate::error::DryRunOperation),
    /// <p>The home region is not set. Set the home region to continue.</p>
    HomeRegionNotSetException(crate::error::HomeRegionNotSetException),
    /// <p>Exception raised when an internal, configuration, or dependency error is
    /// encountered.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>Exception raised when the provided input violates a policy constraint or is entered in
    /// the wrong format or data type.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Exception raised when the request references a resource (Application Discovery Service
    /// configuration, update stream, migration task, etc.) that does not exist in Application
    /// Discovery Service (Application Discovery Service) or in Migration Hub's repository.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Exception raised when there is an internal, configuration, or dependency error
    /// encountered.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Exception raised to indicate a request was not authorized when the <code>DryRun</code>
    /// flag is set to "true".</p>
    UnauthorizedOperation(crate::error::UnauthorizedOperation),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateCreatedArtifactError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateCreatedArtifactErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            AssociateCreatedArtifactErrorKind::DryRunOperation(_inner) => _inner.fmt(f),
            AssociateCreatedArtifactErrorKind::HomeRegionNotSetException(_inner) => _inner.fmt(f),
            AssociateCreatedArtifactErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            AssociateCreatedArtifactErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            AssociateCreatedArtifactErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AssociateCreatedArtifactErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            AssociateCreatedArtifactErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            AssociateCreatedArtifactErrorKind::UnauthorizedOperation(_inner) => _inner.fmt(f),
            AssociateCreatedArtifactErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateCreatedArtifactError {
    fn code(&self) -> Option<&str> {
        AssociateCreatedArtifactError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateCreatedArtifactError {
    /// Creates a new `AssociateCreatedArtifactError`.
    pub fn new(kind: AssociateCreatedArtifactErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateCreatedArtifactError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateCreatedArtifactErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateCreatedArtifactError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateCreatedArtifactErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateCreatedArtifactErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateCreatedArtifactErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateCreatedArtifactErrorKind::DryRunOperation`.
    pub fn is_dry_run_operation(&self) -> bool {
        matches!(
            &self.kind,
            AssociateCreatedArtifactErrorKind::DryRunOperation(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateCreatedArtifactErrorKind::HomeRegionNotSetException`.
    pub fn is_home_region_not_set_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateCreatedArtifactErrorKind::HomeRegionNotSetException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateCreatedArtifactErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            AssociateCreatedArtifactErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateCreatedArtifactErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateCreatedArtifactErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateCreatedArtifactErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateCreatedArtifactErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateCreatedArtifactErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateCreatedArtifactErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateCreatedArtifactErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateCreatedArtifactErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateCreatedArtifactErrorKind::UnauthorizedOperation`.
    pub fn is_unauthorized_operation(&self) -> bool {
        matches!(
            &self.kind,
            AssociateCreatedArtifactErrorKind::UnauthorizedOperation(_)
        )
    }
}
impl std::error::Error for AssociateCreatedArtifactError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateCreatedArtifactErrorKind::AccessDeniedException(_inner) => Some(_inner),
            AssociateCreatedArtifactErrorKind::DryRunOperation(_inner) => Some(_inner),
            AssociateCreatedArtifactErrorKind::HomeRegionNotSetException(_inner) => Some(_inner),
            AssociateCreatedArtifactErrorKind::InternalServerError(_inner) => Some(_inner),
            AssociateCreatedArtifactErrorKind::InvalidInputException(_inner) => Some(_inner),
            AssociateCreatedArtifactErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AssociateCreatedArtifactErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            AssociateCreatedArtifactErrorKind::ThrottlingException(_inner) => Some(_inner),
            AssociateCreatedArtifactErrorKind::UnauthorizedOperation(_inner) => Some(_inner),
            AssociateCreatedArtifactErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AssociateDiscoveredResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateDiscoveredResourceError {
    /// Kind of error that occurred.
    pub kind: AssociateDiscoveredResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateDiscoveredResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateDiscoveredResourceErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Exception raised to indicate a successfully authorized action when the
    /// <code>DryRun</code> flag is set to "true".</p>
    DryRunOperation(crate::error::DryRunOperation),
    /// <p>The home region is not set. Set the home region to continue.</p>
    HomeRegionNotSetException(crate::error::HomeRegionNotSetException),
    /// <p>Exception raised when an internal, configuration, or dependency error is
    /// encountered.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>Exception raised when the provided input violates a policy constraint or is entered in
    /// the wrong format or data type.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Exception raised when there are problems accessing Application Discovery Service
    /// (Application Discovery Service); most likely due to a misconfigured policy or the
    /// <code>migrationhub-discovery</code> role is missing or not configured correctly.</p>
    PolicyErrorException(crate::error::PolicyErrorException),
    /// <p>Exception raised when the request references a resource (Application Discovery Service
    /// configuration, update stream, migration task, etc.) that does not exist in Application
    /// Discovery Service (Application Discovery Service) or in Migration Hub's repository.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Exception raised when there is an internal, configuration, or dependency error
    /// encountered.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Exception raised to indicate a request was not authorized when the <code>DryRun</code>
    /// flag is set to "true".</p>
    UnauthorizedOperation(crate::error::UnauthorizedOperation),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateDiscoveredResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateDiscoveredResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            AssociateDiscoveredResourceErrorKind::DryRunOperation(_inner) => _inner.fmt(f),
            AssociateDiscoveredResourceErrorKind::HomeRegionNotSetException(_inner) => {
                _inner.fmt(f)
            }
            AssociateDiscoveredResourceErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            AssociateDiscoveredResourceErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            AssociateDiscoveredResourceErrorKind::PolicyErrorException(_inner) => _inner.fmt(f),
            AssociateDiscoveredResourceErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            AssociateDiscoveredResourceErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            AssociateDiscoveredResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            AssociateDiscoveredResourceErrorKind::UnauthorizedOperation(_inner) => _inner.fmt(f),
            AssociateDiscoveredResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateDiscoveredResourceError {
    fn code(&self) -> Option<&str> {
        AssociateDiscoveredResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateDiscoveredResourceError {
    /// Creates a new `AssociateDiscoveredResourceError`.
    pub fn new(kind: AssociateDiscoveredResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateDiscoveredResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateDiscoveredResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateDiscoveredResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateDiscoveredResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateDiscoveredResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateDiscoveredResourceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateDiscoveredResourceErrorKind::DryRunOperation`.
    pub fn is_dry_run_operation(&self) -> bool {
        matches!(
            &self.kind,
            AssociateDiscoveredResourceErrorKind::DryRunOperation(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateDiscoveredResourceErrorKind::HomeRegionNotSetException`.
    pub fn is_home_region_not_set_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateDiscoveredResourceErrorKind::HomeRegionNotSetException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateDiscoveredResourceErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            AssociateDiscoveredResourceErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateDiscoveredResourceErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateDiscoveredResourceErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateDiscoveredResourceErrorKind::PolicyErrorException`.
    pub fn is_policy_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateDiscoveredResourceErrorKind::PolicyErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateDiscoveredResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateDiscoveredResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateDiscoveredResourceErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateDiscoveredResourceErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateDiscoveredResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateDiscoveredResourceErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateDiscoveredResourceErrorKind::UnauthorizedOperation`.
    pub fn is_unauthorized_operation(&self) -> bool {
        matches!(
            &self.kind,
            AssociateDiscoveredResourceErrorKind::UnauthorizedOperation(_)
        )
    }
}
impl std::error::Error for AssociateDiscoveredResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateDiscoveredResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            AssociateDiscoveredResourceErrorKind::DryRunOperation(_inner) => Some(_inner),
            AssociateDiscoveredResourceErrorKind::HomeRegionNotSetException(_inner) => Some(_inner),
            AssociateDiscoveredResourceErrorKind::InternalServerError(_inner) => Some(_inner),
            AssociateDiscoveredResourceErrorKind::InvalidInputException(_inner) => Some(_inner),
            AssociateDiscoveredResourceErrorKind::PolicyErrorException(_inner) => Some(_inner),
            AssociateDiscoveredResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AssociateDiscoveredResourceErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            AssociateDiscoveredResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            AssociateDiscoveredResourceErrorKind::UnauthorizedOperation(_inner) => Some(_inner),
            AssociateDiscoveredResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateProgressUpdateStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateProgressUpdateStreamError {
    /// Kind of error that occurred.
    pub kind: CreateProgressUpdateStreamErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateProgressUpdateStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateProgressUpdateStreamErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Exception raised to indicate a successfully authorized action when the
    /// <code>DryRun</code> flag is set to "true".</p>
    DryRunOperation(crate::error::DryRunOperation),
    /// <p>The home region is not set. Set the home region to continue.</p>
    HomeRegionNotSetException(crate::error::HomeRegionNotSetException),
    /// <p>Exception raised when an internal, configuration, or dependency error is
    /// encountered.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>Exception raised when the provided input violates a policy constraint or is entered in
    /// the wrong format or data type.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Exception raised when there is an internal, configuration, or dependency error
    /// encountered.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Exception raised to indicate a request was not authorized when the <code>DryRun</code>
    /// flag is set to "true".</p>
    UnauthorizedOperation(crate::error::UnauthorizedOperation),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateProgressUpdateStreamError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateProgressUpdateStreamErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateProgressUpdateStreamErrorKind::DryRunOperation(_inner) => _inner.fmt(f),
            CreateProgressUpdateStreamErrorKind::HomeRegionNotSetException(_inner) => _inner.fmt(f),
            CreateProgressUpdateStreamErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            CreateProgressUpdateStreamErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateProgressUpdateStreamErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            CreateProgressUpdateStreamErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateProgressUpdateStreamErrorKind::UnauthorizedOperation(_inner) => _inner.fmt(f),
            CreateProgressUpdateStreamErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateProgressUpdateStreamError {
    fn code(&self) -> Option<&str> {
        CreateProgressUpdateStreamError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateProgressUpdateStreamError {
    /// Creates a new `CreateProgressUpdateStreamError`.
    pub fn new(kind: CreateProgressUpdateStreamErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateProgressUpdateStreamError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateProgressUpdateStreamErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateProgressUpdateStreamError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateProgressUpdateStreamErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateProgressUpdateStreamErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProgressUpdateStreamErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateProgressUpdateStreamErrorKind::DryRunOperation`.
    pub fn is_dry_run_operation(&self) -> bool {
        matches!(
            &self.kind,
            CreateProgressUpdateStreamErrorKind::DryRunOperation(_)
        )
    }
    /// Returns `true` if the error kind is `CreateProgressUpdateStreamErrorKind::HomeRegionNotSetException`.
    pub fn is_home_region_not_set_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProgressUpdateStreamErrorKind::HomeRegionNotSetException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateProgressUpdateStreamErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            CreateProgressUpdateStreamErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `CreateProgressUpdateStreamErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProgressUpdateStreamErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateProgressUpdateStreamErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProgressUpdateStreamErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateProgressUpdateStreamErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProgressUpdateStreamErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateProgressUpdateStreamErrorKind::UnauthorizedOperation`.
    pub fn is_unauthorized_operation(&self) -> bool {
        matches!(
            &self.kind,
            CreateProgressUpdateStreamErrorKind::UnauthorizedOperation(_)
        )
    }
}
impl std::error::Error for CreateProgressUpdateStreamError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateProgressUpdateStreamErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateProgressUpdateStreamErrorKind::DryRunOperation(_inner) => Some(_inner),
            CreateProgressUpdateStreamErrorKind::HomeRegionNotSetException(_inner) => Some(_inner),
            CreateProgressUpdateStreamErrorKind::InternalServerError(_inner) => Some(_inner),
            CreateProgressUpdateStreamErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateProgressUpdateStreamErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            CreateProgressUpdateStreamErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateProgressUpdateStreamErrorKind::UnauthorizedOperation(_inner) => Some(_inner),
            CreateProgressUpdateStreamErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteProgressUpdateStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteProgressUpdateStreamError {
    /// Kind of error that occurred.
    pub kind: DeleteProgressUpdateStreamErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteProgressUpdateStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteProgressUpdateStreamErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Exception raised to indicate a successfully authorized action when the
    /// <code>DryRun</code> flag is set to "true".</p>
    DryRunOperation(crate::error::DryRunOperation),
    /// <p>The home region is not set. Set the home region to continue.</p>
    HomeRegionNotSetException(crate::error::HomeRegionNotSetException),
    /// <p>Exception raised when an internal, configuration, or dependency error is
    /// encountered.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>Exception raised when the provided input violates a policy constraint or is entered in
    /// the wrong format or data type.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Exception raised when the request references a resource (Application Discovery Service
    /// configuration, update stream, migration task, etc.) that does not exist in Application
    /// Discovery Service (Application Discovery Service) or in Migration Hub's repository.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Exception raised when there is an internal, configuration, or dependency error
    /// encountered.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Exception raised to indicate a request was not authorized when the <code>DryRun</code>
    /// flag is set to "true".</p>
    UnauthorizedOperation(crate::error::UnauthorizedOperation),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteProgressUpdateStreamError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteProgressUpdateStreamErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteProgressUpdateStreamErrorKind::DryRunOperation(_inner) => _inner.fmt(f),
            DeleteProgressUpdateStreamErrorKind::HomeRegionNotSetException(_inner) => _inner.fmt(f),
            DeleteProgressUpdateStreamErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DeleteProgressUpdateStreamErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteProgressUpdateStreamErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteProgressUpdateStreamErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            DeleteProgressUpdateStreamErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteProgressUpdateStreamErrorKind::UnauthorizedOperation(_inner) => _inner.fmt(f),
            DeleteProgressUpdateStreamErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteProgressUpdateStreamError {
    fn code(&self) -> Option<&str> {
        DeleteProgressUpdateStreamError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteProgressUpdateStreamError {
    /// Creates a new `DeleteProgressUpdateStreamError`.
    pub fn new(kind: DeleteProgressUpdateStreamErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteProgressUpdateStreamError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteProgressUpdateStreamErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteProgressUpdateStreamError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteProgressUpdateStreamErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteProgressUpdateStreamErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProgressUpdateStreamErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteProgressUpdateStreamErrorKind::DryRunOperation`.
    pub fn is_dry_run_operation(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProgressUpdateStreamErrorKind::DryRunOperation(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteProgressUpdateStreamErrorKind::HomeRegionNotSetException`.
    pub fn is_home_region_not_set_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProgressUpdateStreamErrorKind::HomeRegionNotSetException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteProgressUpdateStreamErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProgressUpdateStreamErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteProgressUpdateStreamErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProgressUpdateStreamErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteProgressUpdateStreamErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProgressUpdateStreamErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteProgressUpdateStreamErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProgressUpdateStreamErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteProgressUpdateStreamErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProgressUpdateStreamErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteProgressUpdateStreamErrorKind::UnauthorizedOperation`.
    pub fn is_unauthorized_operation(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProgressUpdateStreamErrorKind::UnauthorizedOperation(_)
        )
    }
}
impl std::error::Error for DeleteProgressUpdateStreamError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteProgressUpdateStreamErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteProgressUpdateStreamErrorKind::DryRunOperation(_inner) => Some(_inner),
            DeleteProgressUpdateStreamErrorKind::HomeRegionNotSetException(_inner) => Some(_inner),
            DeleteProgressUpdateStreamErrorKind::InternalServerError(_inner) => Some(_inner),
            DeleteProgressUpdateStreamErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteProgressUpdateStreamErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteProgressUpdateStreamErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            DeleteProgressUpdateStreamErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteProgressUpdateStreamErrorKind::UnauthorizedOperation(_inner) => Some(_inner),
            DeleteProgressUpdateStreamErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeApplicationState` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeApplicationStateError {
    /// Kind of error that occurred.
    pub kind: DescribeApplicationStateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeApplicationState` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeApplicationStateErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The home region is not set. Set the home region to continue.</p>
    HomeRegionNotSetException(crate::error::HomeRegionNotSetException),
    /// <p>Exception raised when an internal, configuration, or dependency error is
    /// encountered.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>Exception raised when the provided input violates a policy constraint or is entered in
    /// the wrong format or data type.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Exception raised when there are problems accessing Application Discovery Service
    /// (Application Discovery Service); most likely due to a misconfigured policy or the
    /// <code>migrationhub-discovery</code> role is missing or not configured correctly.</p>
    PolicyErrorException(crate::error::PolicyErrorException),
    /// <p>Exception raised when the request references a resource (Application Discovery Service
    /// configuration, update stream, migration task, etc.) that does not exist in Application
    /// Discovery Service (Application Discovery Service) or in Migration Hub's repository.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Exception raised when there is an internal, configuration, or dependency error
    /// encountered.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeApplicationStateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeApplicationStateErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeApplicationStateErrorKind::HomeRegionNotSetException(_inner) => _inner.fmt(f),
            DescribeApplicationStateErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeApplicationStateErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DescribeApplicationStateErrorKind::PolicyErrorException(_inner) => _inner.fmt(f),
            DescribeApplicationStateErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeApplicationStateErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeApplicationStateErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeApplicationStateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeApplicationStateError {
    fn code(&self) -> Option<&str> {
        DescribeApplicationStateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeApplicationStateError {
    /// Creates a new `DescribeApplicationStateError`.
    pub fn new(kind: DescribeApplicationStateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeApplicationStateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeApplicationStateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeApplicationStateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeApplicationStateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeApplicationStateErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeApplicationStateErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeApplicationStateErrorKind::HomeRegionNotSetException`.
    pub fn is_home_region_not_set_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeApplicationStateErrorKind::HomeRegionNotSetException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeApplicationStateErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeApplicationStateErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeApplicationStateErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeApplicationStateErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeApplicationStateErrorKind::PolicyErrorException`.
    pub fn is_policy_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeApplicationStateErrorKind::PolicyErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeApplicationStateErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeApplicationStateErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeApplicationStateErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeApplicationStateErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeApplicationStateErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeApplicationStateErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DescribeApplicationStateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeApplicationStateErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeApplicationStateErrorKind::HomeRegionNotSetException(_inner) => Some(_inner),
            DescribeApplicationStateErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeApplicationStateErrorKind::InvalidInputException(_inner) => Some(_inner),
            DescribeApplicationStateErrorKind::PolicyErrorException(_inner) => Some(_inner),
            DescribeApplicationStateErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeApplicationStateErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeApplicationStateErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeApplicationStateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeMigrationTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeMigrationTaskError {
    /// Kind of error that occurred.
    pub kind: DescribeMigrationTaskErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeMigrationTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeMigrationTaskErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The home region is not set. Set the home region to continue.</p>
    HomeRegionNotSetException(crate::error::HomeRegionNotSetException),
    /// <p>Exception raised when an internal, configuration, or dependency error is
    /// encountered.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>Exception raised when the provided input violates a policy constraint or is entered in
    /// the wrong format or data type.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Exception raised when the request references a resource (Application Discovery Service
    /// configuration, update stream, migration task, etc.) that does not exist in Application
    /// Discovery Service (Application Discovery Service) or in Migration Hub's repository.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Exception raised when there is an internal, configuration, or dependency error
    /// encountered.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeMigrationTaskError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeMigrationTaskErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeMigrationTaskErrorKind::HomeRegionNotSetException(_inner) => _inner.fmt(f),
            DescribeMigrationTaskErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeMigrationTaskErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DescribeMigrationTaskErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeMigrationTaskErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeMigrationTaskErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeMigrationTaskErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeMigrationTaskError {
    fn code(&self) -> Option<&str> {
        DescribeMigrationTaskError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeMigrationTaskError {
    /// Creates a new `DescribeMigrationTaskError`.
    pub fn new(kind: DescribeMigrationTaskErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeMigrationTaskError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeMigrationTaskErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeMigrationTaskError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeMigrationTaskErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeMigrationTaskErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMigrationTaskErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMigrationTaskErrorKind::HomeRegionNotSetException`.
    pub fn is_home_region_not_set_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMigrationTaskErrorKind::HomeRegionNotSetException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMigrationTaskErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMigrationTaskErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMigrationTaskErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMigrationTaskErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMigrationTaskErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMigrationTaskErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMigrationTaskErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMigrationTaskErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMigrationTaskErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMigrationTaskErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DescribeMigrationTaskError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeMigrationTaskErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeMigrationTaskErrorKind::HomeRegionNotSetException(_inner) => Some(_inner),
            DescribeMigrationTaskErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeMigrationTaskErrorKind::InvalidInputException(_inner) => Some(_inner),
            DescribeMigrationTaskErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeMigrationTaskErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeMigrationTaskErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeMigrationTaskErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateCreatedArtifact` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateCreatedArtifactError {
    /// Kind of error that occurred.
    pub kind: DisassociateCreatedArtifactErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateCreatedArtifact` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateCreatedArtifactErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Exception raised to indicate a successfully authorized action when the
    /// <code>DryRun</code> flag is set to "true".</p>
    DryRunOperation(crate::error::DryRunOperation),
    /// <p>The home region is not set. Set the home region to continue.</p>
    HomeRegionNotSetException(crate::error::HomeRegionNotSetException),
    /// <p>Exception raised when an internal, configuration, or dependency error is
    /// encountered.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>Exception raised when the provided input violates a policy constraint or is entered in
    /// the wrong format or data type.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Exception raised when the request references a resource (Application Discovery Service
    /// configuration, update stream, migration task, etc.) that does not exist in Application
    /// Discovery Service (Application Discovery Service) or in Migration Hub's repository.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Exception raised when there is an internal, configuration, or dependency error
    /// encountered.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Exception raised to indicate a request was not authorized when the <code>DryRun</code>
    /// flag is set to "true".</p>
    UnauthorizedOperation(crate::error::UnauthorizedOperation),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateCreatedArtifactError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateCreatedArtifactErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DisassociateCreatedArtifactErrorKind::DryRunOperation(_inner) => _inner.fmt(f),
            DisassociateCreatedArtifactErrorKind::HomeRegionNotSetException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateCreatedArtifactErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DisassociateCreatedArtifactErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DisassociateCreatedArtifactErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateCreatedArtifactErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateCreatedArtifactErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DisassociateCreatedArtifactErrorKind::UnauthorizedOperation(_inner) => _inner.fmt(f),
            DisassociateCreatedArtifactErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateCreatedArtifactError {
    fn code(&self) -> Option<&str> {
        DisassociateCreatedArtifactError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateCreatedArtifactError {
    /// Creates a new `DisassociateCreatedArtifactError`.
    pub fn new(kind: DisassociateCreatedArtifactErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateCreatedArtifactError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateCreatedArtifactErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateCreatedArtifactError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateCreatedArtifactErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateCreatedArtifactErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateCreatedArtifactErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateCreatedArtifactErrorKind::DryRunOperation`.
    pub fn is_dry_run_operation(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateCreatedArtifactErrorKind::DryRunOperation(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateCreatedArtifactErrorKind::HomeRegionNotSetException`.
    pub fn is_home_region_not_set_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateCreatedArtifactErrorKind::HomeRegionNotSetException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateCreatedArtifactErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateCreatedArtifactErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateCreatedArtifactErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateCreatedArtifactErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateCreatedArtifactErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateCreatedArtifactErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateCreatedArtifactErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateCreatedArtifactErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateCreatedArtifactErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateCreatedArtifactErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateCreatedArtifactErrorKind::UnauthorizedOperation`.
    pub fn is_unauthorized_operation(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateCreatedArtifactErrorKind::UnauthorizedOperation(_)
        )
    }
}
impl std::error::Error for DisassociateCreatedArtifactError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateCreatedArtifactErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DisassociateCreatedArtifactErrorKind::DryRunOperation(_inner) => Some(_inner),
            DisassociateCreatedArtifactErrorKind::HomeRegionNotSetException(_inner) => Some(_inner),
            DisassociateCreatedArtifactErrorKind::InternalServerError(_inner) => Some(_inner),
            DisassociateCreatedArtifactErrorKind::InvalidInputException(_inner) => Some(_inner),
            DisassociateCreatedArtifactErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DisassociateCreatedArtifactErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            DisassociateCreatedArtifactErrorKind::ThrottlingException(_inner) => Some(_inner),
            DisassociateCreatedArtifactErrorKind::UnauthorizedOperation(_inner) => Some(_inner),
            DisassociateCreatedArtifactErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateDiscoveredResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateDiscoveredResourceError {
    /// Kind of error that occurred.
    pub kind: DisassociateDiscoveredResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateDiscoveredResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateDiscoveredResourceErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Exception raised to indicate a successfully authorized action when the
    /// <code>DryRun</code> flag is set to "true".</p>
    DryRunOperation(crate::error::DryRunOperation),
    /// <p>The home region is not set. Set the home region to continue.</p>
    HomeRegionNotSetException(crate::error::HomeRegionNotSetException),
    /// <p>Exception raised when an internal, configuration, or dependency error is
    /// encountered.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>Exception raised when the provided input violates a policy constraint or is entered in
    /// the wrong format or data type.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Exception raised when the request references a resource (Application Discovery Service
    /// configuration, update stream, migration task, etc.) that does not exist in Application
    /// Discovery Service (Application Discovery Service) or in Migration Hub's repository.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Exception raised when there is an internal, configuration, or dependency error
    /// encountered.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Exception raised to indicate a request was not authorized when the <code>DryRun</code>
    /// flag is set to "true".</p>
    UnauthorizedOperation(crate::error::UnauthorizedOperation),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateDiscoveredResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateDiscoveredResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DisassociateDiscoveredResourceErrorKind::DryRunOperation(_inner) => _inner.fmt(f),
            DisassociateDiscoveredResourceErrorKind::HomeRegionNotSetException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateDiscoveredResourceErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DisassociateDiscoveredResourceErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DisassociateDiscoveredResourceErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateDiscoveredResourceErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateDiscoveredResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DisassociateDiscoveredResourceErrorKind::UnauthorizedOperation(_inner) => _inner.fmt(f),
            DisassociateDiscoveredResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateDiscoveredResourceError {
    fn code(&self) -> Option<&str> {
        DisassociateDiscoveredResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateDiscoveredResourceError {
    /// Creates a new `DisassociateDiscoveredResourceError`.
    pub fn new(
        kind: DisassociateDiscoveredResourceErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateDiscoveredResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateDiscoveredResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateDiscoveredResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateDiscoveredResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateDiscoveredResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateDiscoveredResourceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateDiscoveredResourceErrorKind::DryRunOperation`.
    pub fn is_dry_run_operation(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateDiscoveredResourceErrorKind::DryRunOperation(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateDiscoveredResourceErrorKind::HomeRegionNotSetException`.
    pub fn is_home_region_not_set_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateDiscoveredResourceErrorKind::HomeRegionNotSetException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateDiscoveredResourceErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateDiscoveredResourceErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateDiscoveredResourceErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateDiscoveredResourceErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateDiscoveredResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateDiscoveredResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateDiscoveredResourceErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateDiscoveredResourceErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateDiscoveredResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateDiscoveredResourceErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateDiscoveredResourceErrorKind::UnauthorizedOperation`.
    pub fn is_unauthorized_operation(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateDiscoveredResourceErrorKind::UnauthorizedOperation(_)
        )
    }
}
impl std::error::Error for DisassociateDiscoveredResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateDiscoveredResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DisassociateDiscoveredResourceErrorKind::DryRunOperation(_inner) => Some(_inner),
            DisassociateDiscoveredResourceErrorKind::HomeRegionNotSetException(_inner) => {
                Some(_inner)
            }
            DisassociateDiscoveredResourceErrorKind::InternalServerError(_inner) => Some(_inner),
            DisassociateDiscoveredResourceErrorKind::InvalidInputException(_inner) => Some(_inner),
            DisassociateDiscoveredResourceErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DisassociateDiscoveredResourceErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            DisassociateDiscoveredResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            DisassociateDiscoveredResourceErrorKind::UnauthorizedOperation(_inner) => Some(_inner),
            DisassociateDiscoveredResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ImportMigrationTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ImportMigrationTaskError {
    /// Kind of error that occurred.
    pub kind: ImportMigrationTaskErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ImportMigrationTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ImportMigrationTaskErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Exception raised to indicate a successfully authorized action when the
    /// <code>DryRun</code> flag is set to "true".</p>
    DryRunOperation(crate::error::DryRunOperation),
    /// <p>The home region is not set. Set the home region to continue.</p>
    HomeRegionNotSetException(crate::error::HomeRegionNotSetException),
    /// <p>Exception raised when an internal, configuration, or dependency error is
    /// encountered.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>Exception raised when the provided input violates a policy constraint or is entered in
    /// the wrong format or data type.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Exception raised when the request references a resource (Application Discovery Service
    /// configuration, update stream, migration task, etc.) that does not exist in Application
    /// Discovery Service (Application Discovery Service) or in Migration Hub's repository.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Exception raised when there is an internal, configuration, or dependency error
    /// encountered.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Exception raised to indicate a request was not authorized when the <code>DryRun</code>
    /// flag is set to "true".</p>
    UnauthorizedOperation(crate::error::UnauthorizedOperation),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ImportMigrationTaskError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ImportMigrationTaskErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ImportMigrationTaskErrorKind::DryRunOperation(_inner) => _inner.fmt(f),
            ImportMigrationTaskErrorKind::HomeRegionNotSetException(_inner) => _inner.fmt(f),
            ImportMigrationTaskErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            ImportMigrationTaskErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ImportMigrationTaskErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ImportMigrationTaskErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ImportMigrationTaskErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ImportMigrationTaskErrorKind::UnauthorizedOperation(_inner) => _inner.fmt(f),
            ImportMigrationTaskErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ImportMigrationTaskError {
    fn code(&self) -> Option<&str> {
        ImportMigrationTaskError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ImportMigrationTaskError {
    /// Creates a new `ImportMigrationTaskError`.
    pub fn new(kind: ImportMigrationTaskErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ImportMigrationTaskError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ImportMigrationTaskErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ImportMigrationTaskError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ImportMigrationTaskErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ImportMigrationTaskErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportMigrationTaskErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ImportMigrationTaskErrorKind::DryRunOperation`.
    pub fn is_dry_run_operation(&self) -> bool {
        matches!(&self.kind, ImportMigrationTaskErrorKind::DryRunOperation(_))
    }
    /// Returns `true` if the error kind is `ImportMigrationTaskErrorKind::HomeRegionNotSetException`.
    pub fn is_home_region_not_set_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportMigrationTaskErrorKind::HomeRegionNotSetException(_)
        )
    }
    /// Returns `true` if the error kind is `ImportMigrationTaskErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            ImportMigrationTaskErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `ImportMigrationTaskErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportMigrationTaskErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `ImportMigrationTaskErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportMigrationTaskErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ImportMigrationTaskErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportMigrationTaskErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ImportMigrationTaskErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportMigrationTaskErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ImportMigrationTaskErrorKind::UnauthorizedOperation`.
    pub fn is_unauthorized_operation(&self) -> bool {
        matches!(
            &self.kind,
            ImportMigrationTaskErrorKind::UnauthorizedOperation(_)
        )
    }
}
impl std::error::Error for ImportMigrationTaskError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ImportMigrationTaskErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ImportMigrationTaskErrorKind::DryRunOperation(_inner) => Some(_inner),
            ImportMigrationTaskErrorKind::HomeRegionNotSetException(_inner) => Some(_inner),
            ImportMigrationTaskErrorKind::InternalServerError(_inner) => Some(_inner),
            ImportMigrationTaskErrorKind::InvalidInputException(_inner) => Some(_inner),
            ImportMigrationTaskErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ImportMigrationTaskErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ImportMigrationTaskErrorKind::ThrottlingException(_inner) => Some(_inner),
            ImportMigrationTaskErrorKind::UnauthorizedOperation(_inner) => Some(_inner),
            ImportMigrationTaskErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListApplicationStates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListApplicationStatesError {
    /// Kind of error that occurred.
    pub kind: ListApplicationStatesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListApplicationStates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListApplicationStatesErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The home region is not set. Set the home region to continue.</p>
    HomeRegionNotSetException(crate::error::HomeRegionNotSetException),
    /// <p>Exception raised when an internal, configuration, or dependency error is
    /// encountered.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>Exception raised when the provided input violates a policy constraint or is entered in
    /// the wrong format or data type.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Exception raised when there is an internal, configuration, or dependency error
    /// encountered.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListApplicationStatesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListApplicationStatesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListApplicationStatesErrorKind::HomeRegionNotSetException(_inner) => _inner.fmt(f),
            ListApplicationStatesErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            ListApplicationStatesErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListApplicationStatesErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListApplicationStatesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListApplicationStatesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListApplicationStatesError {
    fn code(&self) -> Option<&str> {
        ListApplicationStatesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListApplicationStatesError {
    /// Creates a new `ListApplicationStatesError`.
    pub fn new(kind: ListApplicationStatesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListApplicationStatesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListApplicationStatesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListApplicationStatesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListApplicationStatesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListApplicationStatesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListApplicationStatesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListApplicationStatesErrorKind::HomeRegionNotSetException`.
    pub fn is_home_region_not_set_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListApplicationStatesErrorKind::HomeRegionNotSetException(_)
        )
    }
    /// Returns `true` if the error kind is `ListApplicationStatesErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            ListApplicationStatesErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `ListApplicationStatesErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListApplicationStatesErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `ListApplicationStatesErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListApplicationStatesErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListApplicationStatesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListApplicationStatesErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListApplicationStatesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListApplicationStatesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListApplicationStatesErrorKind::HomeRegionNotSetException(_inner) => Some(_inner),
            ListApplicationStatesErrorKind::InternalServerError(_inner) => Some(_inner),
            ListApplicationStatesErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListApplicationStatesErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListApplicationStatesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListApplicationStatesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListCreatedArtifacts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListCreatedArtifactsError {
    /// Kind of error that occurred.
    pub kind: ListCreatedArtifactsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListCreatedArtifacts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListCreatedArtifactsErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The home region is not set. Set the home region to continue.</p>
    HomeRegionNotSetException(crate::error::HomeRegionNotSetException),
    /// <p>Exception raised when an internal, configuration, or dependency error is
    /// encountered.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>Exception raised when the provided input violates a policy constraint or is entered in
    /// the wrong format or data type.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Exception raised when the request references a resource (Application Discovery Service
    /// configuration, update stream, migration task, etc.) that does not exist in Application
    /// Discovery Service (Application Discovery Service) or in Migration Hub's repository.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Exception raised when there is an internal, configuration, or dependency error
    /// encountered.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListCreatedArtifactsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListCreatedArtifactsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListCreatedArtifactsErrorKind::HomeRegionNotSetException(_inner) => _inner.fmt(f),
            ListCreatedArtifactsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            ListCreatedArtifactsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListCreatedArtifactsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListCreatedArtifactsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListCreatedArtifactsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListCreatedArtifactsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListCreatedArtifactsError {
    fn code(&self) -> Option<&str> {
        ListCreatedArtifactsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListCreatedArtifactsError {
    /// Creates a new `ListCreatedArtifactsError`.
    pub fn new(kind: ListCreatedArtifactsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListCreatedArtifactsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListCreatedArtifactsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListCreatedArtifactsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListCreatedArtifactsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListCreatedArtifactsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCreatedArtifactsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListCreatedArtifactsErrorKind::HomeRegionNotSetException`.
    pub fn is_home_region_not_set_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCreatedArtifactsErrorKind::HomeRegionNotSetException(_)
        )
    }
    /// Returns `true` if the error kind is `ListCreatedArtifactsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            ListCreatedArtifactsErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `ListCreatedArtifactsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCreatedArtifactsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `ListCreatedArtifactsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCreatedArtifactsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListCreatedArtifactsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCreatedArtifactsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListCreatedArtifactsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCreatedArtifactsErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListCreatedArtifactsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListCreatedArtifactsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListCreatedArtifactsErrorKind::HomeRegionNotSetException(_inner) => Some(_inner),
            ListCreatedArtifactsErrorKind::InternalServerError(_inner) => Some(_inner),
            ListCreatedArtifactsErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListCreatedArtifactsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListCreatedArtifactsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListCreatedArtifactsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListCreatedArtifactsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDiscoveredResources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDiscoveredResourcesError {
    /// Kind of error that occurred.
    pub kind: ListDiscoveredResourcesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDiscoveredResources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDiscoveredResourcesErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The home region is not set. Set the home region to continue.</p>
    HomeRegionNotSetException(crate::error::HomeRegionNotSetException),
    /// <p>Exception raised when an internal, configuration, or dependency error is
    /// encountered.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>Exception raised when the provided input violates a policy constraint or is entered in
    /// the wrong format or data type.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Exception raised when the request references a resource (Application Discovery Service
    /// configuration, update stream, migration task, etc.) that does not exist in Application
    /// Discovery Service (Application Discovery Service) or in Migration Hub's repository.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Exception raised when there is an internal, configuration, or dependency error
    /// encountered.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDiscoveredResourcesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDiscoveredResourcesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListDiscoveredResourcesErrorKind::HomeRegionNotSetException(_inner) => _inner.fmt(f),
            ListDiscoveredResourcesErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            ListDiscoveredResourcesErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListDiscoveredResourcesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListDiscoveredResourcesErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListDiscoveredResourcesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListDiscoveredResourcesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDiscoveredResourcesError {
    fn code(&self) -> Option<&str> {
        ListDiscoveredResourcesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDiscoveredResourcesError {
    /// Creates a new `ListDiscoveredResourcesError`.
    pub fn new(kind: ListDiscoveredResourcesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDiscoveredResourcesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDiscoveredResourcesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDiscoveredResourcesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDiscoveredResourcesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDiscoveredResourcesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDiscoveredResourcesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDiscoveredResourcesErrorKind::HomeRegionNotSetException`.
    pub fn is_home_region_not_set_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDiscoveredResourcesErrorKind::HomeRegionNotSetException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDiscoveredResourcesErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            ListDiscoveredResourcesErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `ListDiscoveredResourcesErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDiscoveredResourcesErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDiscoveredResourcesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDiscoveredResourcesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDiscoveredResourcesErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDiscoveredResourcesErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDiscoveredResourcesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDiscoveredResourcesErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListDiscoveredResourcesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDiscoveredResourcesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListDiscoveredResourcesErrorKind::HomeRegionNotSetException(_inner) => Some(_inner),
            ListDiscoveredResourcesErrorKind::InternalServerError(_inner) => Some(_inner),
            ListDiscoveredResourcesErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListDiscoveredResourcesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListDiscoveredResourcesErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListDiscoveredResourcesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListDiscoveredResourcesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListMigrationTasks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListMigrationTasksError {
    /// Kind of error that occurred.
    pub kind: ListMigrationTasksErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListMigrationTasks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListMigrationTasksErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The home region is not set. Set the home region to continue.</p>
    HomeRegionNotSetException(crate::error::HomeRegionNotSetException),
    /// <p>Exception raised when an internal, configuration, or dependency error is
    /// encountered.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>Exception raised when the provided input violates a policy constraint or is entered in
    /// the wrong format or data type.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Exception raised when there are problems accessing Application Discovery Service
    /// (Application Discovery Service); most likely due to a misconfigured policy or the
    /// <code>migrationhub-discovery</code> role is missing or not configured correctly.</p>
    PolicyErrorException(crate::error::PolicyErrorException),
    /// <p>Exception raised when the request references a resource (Application Discovery Service
    /// configuration, update stream, migration task, etc.) that does not exist in Application
    /// Discovery Service (Application Discovery Service) or in Migration Hub's repository.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Exception raised when there is an internal, configuration, or dependency error
    /// encountered.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListMigrationTasksError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListMigrationTasksErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListMigrationTasksErrorKind::HomeRegionNotSetException(_inner) => _inner.fmt(f),
            ListMigrationTasksErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            ListMigrationTasksErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListMigrationTasksErrorKind::PolicyErrorException(_inner) => _inner.fmt(f),
            ListMigrationTasksErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListMigrationTasksErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListMigrationTasksErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListMigrationTasksErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListMigrationTasksError {
    fn code(&self) -> Option<&str> {
        ListMigrationTasksError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListMigrationTasksError {
    /// Creates a new `ListMigrationTasksError`.
    pub fn new(kind: ListMigrationTasksErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListMigrationTasksError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListMigrationTasksErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListMigrationTasksError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListMigrationTasksErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListMigrationTasksErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMigrationTasksErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMigrationTasksErrorKind::HomeRegionNotSetException`.
    pub fn is_home_region_not_set_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMigrationTasksErrorKind::HomeRegionNotSetException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMigrationTasksErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            ListMigrationTasksErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `ListMigrationTasksErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMigrationTasksErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMigrationTasksErrorKind::PolicyErrorException`.
    pub fn is_policy_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMigrationTasksErrorKind::PolicyErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMigrationTasksErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMigrationTasksErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMigrationTasksErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMigrationTasksErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMigrationTasksErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMigrationTasksErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListMigrationTasksError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListMigrationTasksErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListMigrationTasksErrorKind::HomeRegionNotSetException(_inner) => Some(_inner),
            ListMigrationTasksErrorKind::InternalServerError(_inner) => Some(_inner),
            ListMigrationTasksErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListMigrationTasksErrorKind::PolicyErrorException(_inner) => Some(_inner),
            ListMigrationTasksErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListMigrationTasksErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListMigrationTasksErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListMigrationTasksErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListProgressUpdateStreams` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListProgressUpdateStreamsError {
    /// Kind of error that occurred.
    pub kind: ListProgressUpdateStreamsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListProgressUpdateStreams` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListProgressUpdateStreamsErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The home region is not set. Set the home region to continue.</p>
    HomeRegionNotSetException(crate::error::HomeRegionNotSetException),
    /// <p>Exception raised when an internal, configuration, or dependency error is
    /// encountered.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>Exception raised when the provided input violates a policy constraint or is entered in
    /// the wrong format or data type.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Exception raised when there is an internal, configuration, or dependency error
    /// encountered.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListProgressUpdateStreamsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListProgressUpdateStreamsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListProgressUpdateStreamsErrorKind::HomeRegionNotSetException(_inner) => _inner.fmt(f),
            ListProgressUpdateStreamsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            ListProgressUpdateStreamsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListProgressUpdateStreamsErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            ListProgressUpdateStreamsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListProgressUpdateStreamsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListProgressUpdateStreamsError {
    fn code(&self) -> Option<&str> {
        ListProgressUpdateStreamsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListProgressUpdateStreamsError {
    /// Creates a new `ListProgressUpdateStreamsError`.
    pub fn new(kind: ListProgressUpdateStreamsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListProgressUpdateStreamsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListProgressUpdateStreamsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListProgressUpdateStreamsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListProgressUpdateStreamsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListProgressUpdateStreamsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProgressUpdateStreamsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListProgressUpdateStreamsErrorKind::HomeRegionNotSetException`.
    pub fn is_home_region_not_set_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProgressUpdateStreamsErrorKind::HomeRegionNotSetException(_)
        )
    }
    /// Returns `true` if the error kind is `ListProgressUpdateStreamsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            ListProgressUpdateStreamsErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `ListProgressUpdateStreamsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProgressUpdateStreamsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `ListProgressUpdateStreamsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProgressUpdateStreamsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListProgressUpdateStreamsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProgressUpdateStreamsErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListProgressUpdateStreamsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListProgressUpdateStreamsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListProgressUpdateStreamsErrorKind::HomeRegionNotSetException(_inner) => Some(_inner),
            ListProgressUpdateStreamsErrorKind::InternalServerError(_inner) => Some(_inner),
            ListProgressUpdateStreamsErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListProgressUpdateStreamsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListProgressUpdateStreamsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListProgressUpdateStreamsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `NotifyApplicationState` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct NotifyApplicationStateError {
    /// Kind of error that occurred.
    pub kind: NotifyApplicationStateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `NotifyApplicationState` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum NotifyApplicationStateErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Exception raised to indicate a successfully authorized action when the
    /// <code>DryRun</code> flag is set to "true".</p>
    DryRunOperation(crate::error::DryRunOperation),
    /// <p>The home region is not set. Set the home region to continue.</p>
    HomeRegionNotSetException(crate::error::HomeRegionNotSetException),
    /// <p>Exception raised when an internal, configuration, or dependency error is
    /// encountered.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>Exception raised when the provided input violates a policy constraint or is entered in
    /// the wrong format or data type.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Exception raised when there are problems accessing Application Discovery Service
    /// (Application Discovery Service); most likely due to a misconfigured policy or the
    /// <code>migrationhub-discovery</code> role is missing or not configured correctly.</p>
    PolicyErrorException(crate::error::PolicyErrorException),
    /// <p>Exception raised when the request references a resource (Application Discovery Service
    /// configuration, update stream, migration task, etc.) that does not exist in Application
    /// Discovery Service (Application Discovery Service) or in Migration Hub's repository.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Exception raised when there is an internal, configuration, or dependency error
    /// encountered.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Exception raised to indicate a request was not authorized when the <code>DryRun</code>
    /// flag is set to "true".</p>
    UnauthorizedOperation(crate::error::UnauthorizedOperation),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for NotifyApplicationStateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            NotifyApplicationStateErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            NotifyApplicationStateErrorKind::DryRunOperation(_inner) => _inner.fmt(f),
            NotifyApplicationStateErrorKind::HomeRegionNotSetException(_inner) => _inner.fmt(f),
            NotifyApplicationStateErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            NotifyApplicationStateErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            NotifyApplicationStateErrorKind::PolicyErrorException(_inner) => _inner.fmt(f),
            NotifyApplicationStateErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            NotifyApplicationStateErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            NotifyApplicationStateErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            NotifyApplicationStateErrorKind::UnauthorizedOperation(_inner) => _inner.fmt(f),
            NotifyApplicationStateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for NotifyApplicationStateError {
    fn code(&self) -> Option<&str> {
        NotifyApplicationStateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl NotifyApplicationStateError {
    /// Creates a new `NotifyApplicationStateError`.
    pub fn new(kind: NotifyApplicationStateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `NotifyApplicationStateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: NotifyApplicationStateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `NotifyApplicationStateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: NotifyApplicationStateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `NotifyApplicationStateErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            NotifyApplicationStateErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `NotifyApplicationStateErrorKind::DryRunOperation`.
    pub fn is_dry_run_operation(&self) -> bool {
        matches!(
            &self.kind,
            NotifyApplicationStateErrorKind::DryRunOperation(_)
        )
    }
    /// Returns `true` if the error kind is `NotifyApplicationStateErrorKind::HomeRegionNotSetException`.
    pub fn is_home_region_not_set_exception(&self) -> bool {
        matches!(
            &self.kind,
            NotifyApplicationStateErrorKind::HomeRegionNotSetException(_)
        )
    }
    /// Returns `true` if the error kind is `NotifyApplicationStateErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            NotifyApplicationStateErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `NotifyApplicationStateErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            NotifyApplicationStateErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `NotifyApplicationStateErrorKind::PolicyErrorException`.
    pub fn is_policy_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            NotifyApplicationStateErrorKind::PolicyErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `NotifyApplicationStateErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            NotifyApplicationStateErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `NotifyApplicationStateErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            NotifyApplicationStateErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `NotifyApplicationStateErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            NotifyApplicationStateErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `NotifyApplicationStateErrorKind::UnauthorizedOperation`.
    pub fn is_unauthorized_operation(&self) -> bool {
        matches!(
            &self.kind,
            NotifyApplicationStateErrorKind::UnauthorizedOperation(_)
        )
    }
}
impl std::error::Error for NotifyApplicationStateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            NotifyApplicationStateErrorKind::AccessDeniedException(_inner) => Some(_inner),
            NotifyApplicationStateErrorKind::DryRunOperation(_inner) => Some(_inner),
            NotifyApplicationStateErrorKind::HomeRegionNotSetException(_inner) => Some(_inner),
            NotifyApplicationStateErrorKind::InternalServerError(_inner) => Some(_inner),
            NotifyApplicationStateErrorKind::InvalidInputException(_inner) => Some(_inner),
            NotifyApplicationStateErrorKind::PolicyErrorException(_inner) => Some(_inner),
            NotifyApplicationStateErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            NotifyApplicationStateErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            NotifyApplicationStateErrorKind::ThrottlingException(_inner) => Some(_inner),
            NotifyApplicationStateErrorKind::UnauthorizedOperation(_inner) => Some(_inner),
            NotifyApplicationStateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `NotifyMigrationTaskState` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct NotifyMigrationTaskStateError {
    /// Kind of error that occurred.
    pub kind: NotifyMigrationTaskStateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `NotifyMigrationTaskState` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum NotifyMigrationTaskStateErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Exception raised to indicate a successfully authorized action when the
    /// <code>DryRun</code> flag is set to "true".</p>
    DryRunOperation(crate::error::DryRunOperation),
    /// <p>The home region is not set. Set the home region to continue.</p>
    HomeRegionNotSetException(crate::error::HomeRegionNotSetException),
    /// <p>Exception raised when an internal, configuration, or dependency error is
    /// encountered.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>Exception raised when the provided input violates a policy constraint or is entered in
    /// the wrong format or data type.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Exception raised when the request references a resource (Application Discovery Service
    /// configuration, update stream, migration task, etc.) that does not exist in Application
    /// Discovery Service (Application Discovery Service) or in Migration Hub's repository.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Exception raised when there is an internal, configuration, or dependency error
    /// encountered.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Exception raised to indicate a request was not authorized when the <code>DryRun</code>
    /// flag is set to "true".</p>
    UnauthorizedOperation(crate::error::UnauthorizedOperation),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for NotifyMigrationTaskStateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            NotifyMigrationTaskStateErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            NotifyMigrationTaskStateErrorKind::DryRunOperation(_inner) => _inner.fmt(f),
            NotifyMigrationTaskStateErrorKind::HomeRegionNotSetException(_inner) => _inner.fmt(f),
            NotifyMigrationTaskStateErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            NotifyMigrationTaskStateErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            NotifyMigrationTaskStateErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            NotifyMigrationTaskStateErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            NotifyMigrationTaskStateErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            NotifyMigrationTaskStateErrorKind::UnauthorizedOperation(_inner) => _inner.fmt(f),
            NotifyMigrationTaskStateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for NotifyMigrationTaskStateError {
    fn code(&self) -> Option<&str> {
        NotifyMigrationTaskStateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl NotifyMigrationTaskStateError {
    /// Creates a new `NotifyMigrationTaskStateError`.
    pub fn new(kind: NotifyMigrationTaskStateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `NotifyMigrationTaskStateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: NotifyMigrationTaskStateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `NotifyMigrationTaskStateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: NotifyMigrationTaskStateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `NotifyMigrationTaskStateErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            NotifyMigrationTaskStateErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `NotifyMigrationTaskStateErrorKind::DryRunOperation`.
    pub fn is_dry_run_operation(&self) -> bool {
        matches!(
            &self.kind,
            NotifyMigrationTaskStateErrorKind::DryRunOperation(_)
        )
    }
    /// Returns `true` if the error kind is `NotifyMigrationTaskStateErrorKind::HomeRegionNotSetException`.
    pub fn is_home_region_not_set_exception(&self) -> bool {
        matches!(
            &self.kind,
            NotifyMigrationTaskStateErrorKind::HomeRegionNotSetException(_)
        )
    }
    /// Returns `true` if the error kind is `NotifyMigrationTaskStateErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            NotifyMigrationTaskStateErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `NotifyMigrationTaskStateErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            NotifyMigrationTaskStateErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `NotifyMigrationTaskStateErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            NotifyMigrationTaskStateErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `NotifyMigrationTaskStateErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            NotifyMigrationTaskStateErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `NotifyMigrationTaskStateErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            NotifyMigrationTaskStateErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `NotifyMigrationTaskStateErrorKind::UnauthorizedOperation`.
    pub fn is_unauthorized_operation(&self) -> bool {
        matches!(
            &self.kind,
            NotifyMigrationTaskStateErrorKind::UnauthorizedOperation(_)
        )
    }
}
impl std::error::Error for NotifyMigrationTaskStateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            NotifyMigrationTaskStateErrorKind::AccessDeniedException(_inner) => Some(_inner),
            NotifyMigrationTaskStateErrorKind::DryRunOperation(_inner) => Some(_inner),
            NotifyMigrationTaskStateErrorKind::HomeRegionNotSetException(_inner) => Some(_inner),
            NotifyMigrationTaskStateErrorKind::InternalServerError(_inner) => Some(_inner),
            NotifyMigrationTaskStateErrorKind::InvalidInputException(_inner) => Some(_inner),
            NotifyMigrationTaskStateErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            NotifyMigrationTaskStateErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            NotifyMigrationTaskStateErrorKind::ThrottlingException(_inner) => Some(_inner),
            NotifyMigrationTaskStateErrorKind::UnauthorizedOperation(_inner) => Some(_inner),
            NotifyMigrationTaskStateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutResourceAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutResourceAttributesError {
    /// Kind of error that occurred.
    pub kind: PutResourceAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutResourceAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutResourceAttributesErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Exception raised to indicate a successfully authorized action when the
    /// <code>DryRun</code> flag is set to "true".</p>
    DryRunOperation(crate::error::DryRunOperation),
    /// <p>The home region is not set. Set the home region to continue.</p>
    HomeRegionNotSetException(crate::error::HomeRegionNotSetException),
    /// <p>Exception raised when an internal, configuration, or dependency error is
    /// encountered.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>Exception raised when the provided input violates a policy constraint or is entered in
    /// the wrong format or data type.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Exception raised when the request references a resource (Application Discovery Service
    /// configuration, update stream, migration task, etc.) that does not exist in Application
    /// Discovery Service (Application Discovery Service) or in Migration Hub's repository.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Exception raised when there is an internal, configuration, or dependency error
    /// encountered.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Exception raised to indicate a request was not authorized when the <code>DryRun</code>
    /// flag is set to "true".</p>
    UnauthorizedOperation(crate::error::UnauthorizedOperation),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutResourceAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutResourceAttributesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            PutResourceAttributesErrorKind::DryRunOperation(_inner) => _inner.fmt(f),
            PutResourceAttributesErrorKind::HomeRegionNotSetException(_inner) => _inner.fmt(f),
            PutResourceAttributesErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            PutResourceAttributesErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            PutResourceAttributesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            PutResourceAttributesErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            PutResourceAttributesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            PutResourceAttributesErrorKind::UnauthorizedOperation(_inner) => _inner.fmt(f),
            PutResourceAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutResourceAttributesError {
    fn code(&self) -> Option<&str> {
        PutResourceAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutResourceAttributesError {
    /// Creates a new `PutResourceAttributesError`.
    pub fn new(kind: PutResourceAttributesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutResourceAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutResourceAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutResourceAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutResourceAttributesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutResourceAttributesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutResourceAttributesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `PutResourceAttributesErrorKind::DryRunOperation`.
    pub fn is_dry_run_operation(&self) -> bool {
        matches!(
            &self.kind,
            PutResourceAttributesErrorKind::DryRunOperation(_)
        )
    }
    /// Returns `true` if the error kind is `PutResourceAttributesErrorKind::HomeRegionNotSetException`.
    pub fn is_home_region_not_set_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutResourceAttributesErrorKind::HomeRegionNotSetException(_)
        )
    }
    /// Returns `true` if the error kind is `PutResourceAttributesErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            PutResourceAttributesErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `PutResourceAttributesErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutResourceAttributesErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `PutResourceAttributesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutResourceAttributesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutResourceAttributesErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutResourceAttributesErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `PutResourceAttributesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutResourceAttributesErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `PutResourceAttributesErrorKind::UnauthorizedOperation`.
    pub fn is_unauthorized_operation(&self) -> bool {
        matches!(
            &self.kind,
            PutResourceAttributesErrorKind::UnauthorizedOperation(_)
        )
    }
}
impl std::error::Error for PutResourceAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutResourceAttributesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            PutResourceAttributesErrorKind::DryRunOperation(_inner) => Some(_inner),
            PutResourceAttributesErrorKind::HomeRegionNotSetException(_inner) => Some(_inner),
            PutResourceAttributesErrorKind::InternalServerError(_inner) => Some(_inner),
            PutResourceAttributesErrorKind::InvalidInputException(_inner) => Some(_inner),
            PutResourceAttributesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            PutResourceAttributesErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            PutResourceAttributesErrorKind::ThrottlingException(_inner) => Some(_inner),
            PutResourceAttributesErrorKind::UnauthorizedOperation(_inner) => Some(_inner),
            PutResourceAttributesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>Exception raised to indicate a request was not authorized when the <code>DryRun</code>
/// flag is set to "true".</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnauthorizedOperation {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnauthorizedOperation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnauthorizedOperation");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnauthorizedOperation {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnauthorizedOperation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnauthorizedOperation")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnauthorizedOperation {}
/// See [`UnauthorizedOperation`](crate::error::UnauthorizedOperation)
pub mod unauthorized_operation {
    /// A builder for [`UnauthorizedOperation`](crate::error::UnauthorizedOperation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnauthorizedOperation`](crate::error::UnauthorizedOperation)
        pub fn build(self) -> crate::error::UnauthorizedOperation {
            crate::error::UnauthorizedOperation {
                message: self.message,
            }
        }
    }
}
impl UnauthorizedOperation {
    /// Creates a new builder-style object to manufacture [`UnauthorizedOperation`](crate::error::UnauthorizedOperation)
    pub fn builder() -> crate::error::unauthorized_operation::Builder {
        crate::error::unauthorized_operation::Builder::default()
    }
}

/// <p>The request was denied due to request throttling.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThrottlingException {
    /// <p>A message that provides information about the exception.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The number of seconds the caller should wait before retrying.</p>
    pub retry_after_seconds: i32,
}
impl std::fmt::Debug for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThrottlingException");
        formatter.field("message", &self.message);
        formatter.field("retry_after_seconds", &self.retry_after_seconds);
        formatter.finish()
    }
}
impl ThrottlingException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ThrottlingException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ThrottlingException {}
/// See [`ThrottlingException`](crate::error::ThrottlingException)
pub mod throttling_exception {
    /// A builder for [`ThrottlingException`](crate::error::ThrottlingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) retry_after_seconds: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>A message that provides information about the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message that provides information about the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The number of seconds the caller should wait before retrying.</p>
        pub fn retry_after_seconds(mut self, input: i32) -> Self {
            self.retry_after_seconds = Some(input);
            self
        }
        /// <p>The number of seconds the caller should wait before retrying.</p>
        pub fn set_retry_after_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.retry_after_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`ThrottlingException`](crate::error::ThrottlingException)
        pub fn build(self) -> crate::error::ThrottlingException {
            crate::error::ThrottlingException {
                message: self.message,
                retry_after_seconds: self.retry_after_seconds.unwrap_or_default(),
            }
        }
    }
}
impl ThrottlingException {
    /// Creates a new builder-style object to manufacture [`ThrottlingException`](crate::error::ThrottlingException)
    pub fn builder() -> crate::error::throttling_exception::Builder {
        crate::error::throttling_exception::Builder::default()
    }
}

/// <p>Exception raised when there is an internal, configuration, or dependency error
/// encountered.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceUnavailableException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceUnavailableException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceUnavailableException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceUnavailableException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceUnavailableException {}
/// See [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
pub mod service_unavailable_exception {
    /// A builder for [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
        pub fn build(self) -> crate::error::ServiceUnavailableException {
            crate::error::ServiceUnavailableException {
                message: self.message,
            }
        }
    }
}
impl ServiceUnavailableException {
    /// Creates a new builder-style object to manufacture [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
    pub fn builder() -> crate::error::service_unavailable_exception::Builder {
        crate::error::service_unavailable_exception::Builder::default()
    }
}

/// <p>Exception raised when the request references a resource (Application Discovery Service
/// configuration, update stream, migration task, etc.) that does not exist in Application
/// Discovery Service (Application Discovery Service) or in Migration Hub's repository.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>Exception raised when the provided input violates a policy constraint or is entered in
/// the wrong format or data type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidInputException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidInputException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidInputException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidInputException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidInputException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidInputException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidInputException {}
/// See [`InvalidInputException`](crate::error::InvalidInputException)
pub mod invalid_input_exception {
    /// A builder for [`InvalidInputException`](crate::error::InvalidInputException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidInputException`](crate::error::InvalidInputException)
        pub fn build(self) -> crate::error::InvalidInputException {
            crate::error::InvalidInputException {
                message: self.message,
            }
        }
    }
}
impl InvalidInputException {
    /// Creates a new builder-style object to manufacture [`InvalidInputException`](crate::error::InvalidInputException)
    pub fn builder() -> crate::error::invalid_input_exception::Builder {
        crate::error::invalid_input_exception::Builder::default()
    }
}

/// <p>Exception raised when an internal, configuration, or dependency error is
/// encountered.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerError {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerError");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServerError {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerError")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerError {}
/// See [`InternalServerError`](crate::error::InternalServerError)
pub mod internal_server_error {
    /// A builder for [`InternalServerError`](crate::error::InternalServerError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerError`](crate::error::InternalServerError)
        pub fn build(self) -> crate::error::InternalServerError {
            crate::error::InternalServerError {
                message: self.message,
            }
        }
    }
}
impl InternalServerError {
    /// Creates a new builder-style object to manufacture [`InternalServerError`](crate::error::InternalServerError)
    pub fn builder() -> crate::error::internal_server_error::Builder {
        crate::error::internal_server_error::Builder::default()
    }
}

/// <p>The home region is not set. Set the home region to continue.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HomeRegionNotSetException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for HomeRegionNotSetException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HomeRegionNotSetException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl HomeRegionNotSetException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for HomeRegionNotSetException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "HomeRegionNotSetException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for HomeRegionNotSetException {}
/// See [`HomeRegionNotSetException`](crate::error::HomeRegionNotSetException)
pub mod home_region_not_set_exception {
    /// A builder for [`HomeRegionNotSetException`](crate::error::HomeRegionNotSetException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`HomeRegionNotSetException`](crate::error::HomeRegionNotSetException)
        pub fn build(self) -> crate::error::HomeRegionNotSetException {
            crate::error::HomeRegionNotSetException {
                message: self.message,
            }
        }
    }
}
impl HomeRegionNotSetException {
    /// Creates a new builder-style object to manufacture [`HomeRegionNotSetException`](crate::error::HomeRegionNotSetException)
    pub fn builder() -> crate::error::home_region_not_set_exception::Builder {
        crate::error::home_region_not_set_exception::Builder::default()
    }
}

/// <p>Exception raised to indicate a successfully authorized action when the
/// <code>DryRun</code> flag is set to "true".</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DryRunOperation {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DryRunOperation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DryRunOperation");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DryRunOperation {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DryRunOperation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DryRunOperation")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for DryRunOperation {}
/// See [`DryRunOperation`](crate::error::DryRunOperation)
pub mod dry_run_operation {
    /// A builder for [`DryRunOperation`](crate::error::DryRunOperation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DryRunOperation`](crate::error::DryRunOperation)
        pub fn build(self) -> crate::error::DryRunOperation {
            crate::error::DryRunOperation {
                message: self.message,
            }
        }
    }
}
impl DryRunOperation {
    /// Creates a new builder-style object to manufacture [`DryRunOperation`](crate::error::DryRunOperation)
    pub fn builder() -> crate::error::dry_run_operation::Builder {
        crate::error::dry_run_operation::Builder::default()
    }
}

/// <p>You do not have sufficient access to perform this action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}

/// <p>Exception raised when there are problems accessing Application Discovery Service
/// (Application Discovery Service); most likely due to a misconfigured policy or the
/// <code>migrationhub-discovery</code> role is missing or not configured correctly.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PolicyErrorException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PolicyErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PolicyErrorException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl PolicyErrorException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for PolicyErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "PolicyErrorException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for PolicyErrorException {}
/// See [`PolicyErrorException`](crate::error::PolicyErrorException)
pub mod policy_error_exception {
    /// A builder for [`PolicyErrorException`](crate::error::PolicyErrorException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`PolicyErrorException`](crate::error::PolicyErrorException)
        pub fn build(self) -> crate::error::PolicyErrorException {
            crate::error::PolicyErrorException {
                message: self.message,
            }
        }
    }
}
impl PolicyErrorException {
    /// Creates a new builder-style object to manufacture [`PolicyErrorException`](crate::error::PolicyErrorException)
    pub fn builder() -> crate::error::policy_error_exception::Builder {
        crate::error::policy_error_exception::Builder::default()
    }
}
