// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Validate exception field.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationExceptionField {
    /// <p>Validate exception field name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Validate exception field message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl ValidationExceptionField {
    /// <p>Validate exception field name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Validate exception field message.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for ValidationExceptionField {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationExceptionField");
        formatter.field("name", &self.name);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`ValidationExceptionField`](crate::model::ValidationExceptionField)
pub mod validation_exception_field {
    /// A builder for [`ValidationExceptionField`](crate::model::ValidationExceptionField)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Validate exception field name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Validate exception field name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Validate exception field message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Validate exception field message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationExceptionField`](crate::model::ValidationExceptionField)
        pub fn build(self) -> crate::model::ValidationExceptionField {
            crate::model::ValidationExceptionField {
                name: self.name,
                message: self.message,
            }
        }
    }
}
impl ValidationExceptionField {
    /// Creates a new builder-style object to manufacture [`ValidationExceptionField`](crate::model::ValidationExceptionField)
    pub fn builder() -> crate::model::validation_exception_field::Builder {
        crate::model::validation_exception_field::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ValidationExceptionReason {
    #[allow(missing_docs)] // documentation missing in model
    CannotParse,
    #[allow(missing_docs)] // documentation missing in model
    FieldValidationFailed,
    #[allow(missing_docs)] // documentation missing in model
    Other,
    #[allow(missing_docs)] // documentation missing in model
    UnknownOperation,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ValidationExceptionReason {
    fn from(s: &str) -> Self {
        match s {
            "cannotParse" => ValidationExceptionReason::CannotParse,
            "fieldValidationFailed" => ValidationExceptionReason::FieldValidationFailed,
            "other" => ValidationExceptionReason::Other,
            "unknownOperation" => ValidationExceptionReason::UnknownOperation,
            other => ValidationExceptionReason::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ValidationExceptionReason {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ValidationExceptionReason::from(s))
    }
}
impl ValidationExceptionReason {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ValidationExceptionReason::CannotParse => "cannotParse",
            ValidationExceptionReason::FieldValidationFailed => "fieldValidationFailed",
            ValidationExceptionReason::Other => "other",
            ValidationExceptionReason::UnknownOperation => "unknownOperation",
            ValidationExceptionReason::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "cannotParse",
            "fieldValidationFailed",
            "other",
            "unknownOperation",
        ]
    }
}
impl AsRef<str> for ValidationExceptionReason {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>vCenter client.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VcenterClient {
    /// <p>ID of vCenter client.</p>
    pub vcenter_client_id: std::option::Option<std::string::String>,
    /// <p>Arn of vCenter client.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>Hostname of vCenter client .</p>
    pub hostname: std::option::Option<std::string::String>,
    /// <p>Vcenter UUID of vCenter client.</p>
    pub vcenter_uuid: std::option::Option<std::string::String>,
    /// <p>Datacenter name of vCenter client.</p>
    pub datacenter_name: std::option::Option<std::string::String>,
    /// <p>Last seen time of vCenter client.</p>
    pub last_seen_datetime: std::option::Option<std::string::String>,
    /// <p>Tags for Source Server of vCenter client.</p>
    pub source_server_tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Tags for vCenter client.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl VcenterClient {
    /// <p>ID of vCenter client.</p>
    pub fn vcenter_client_id(&self) -> std::option::Option<&str> {
        self.vcenter_client_id.as_deref()
    }
    /// <p>Arn of vCenter client.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>Hostname of vCenter client .</p>
    pub fn hostname(&self) -> std::option::Option<&str> {
        self.hostname.as_deref()
    }
    /// <p>Vcenter UUID of vCenter client.</p>
    pub fn vcenter_uuid(&self) -> std::option::Option<&str> {
        self.vcenter_uuid.as_deref()
    }
    /// <p>Datacenter name of vCenter client.</p>
    pub fn datacenter_name(&self) -> std::option::Option<&str> {
        self.datacenter_name.as_deref()
    }
    /// <p>Last seen time of vCenter client.</p>
    pub fn last_seen_datetime(&self) -> std::option::Option<&str> {
        self.last_seen_datetime.as_deref()
    }
    /// <p>Tags for Source Server of vCenter client.</p>
    pub fn source_server_tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.source_server_tags.as_ref()
    }
    /// <p>Tags for vCenter client.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for VcenterClient {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VcenterClient");
        formatter.field("vcenter_client_id", &self.vcenter_client_id);
        formatter.field("arn", &self.arn);
        formatter.field("hostname", &self.hostname);
        formatter.field("vcenter_uuid", &self.vcenter_uuid);
        formatter.field("datacenter_name", &self.datacenter_name);
        formatter.field("last_seen_datetime", &self.last_seen_datetime);
        formatter.field("source_server_tags", &"*** Sensitive Data Redacted ***");
        formatter.field("tags", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`VcenterClient`](crate::model::VcenterClient)
pub mod vcenter_client {
    /// A builder for [`VcenterClient`](crate::model::VcenterClient)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) vcenter_client_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) hostname: std::option::Option<std::string::String>,
        pub(crate) vcenter_uuid: std::option::Option<std::string::String>,
        pub(crate) datacenter_name: std::option::Option<std::string::String>,
        pub(crate) last_seen_datetime: std::option::Option<std::string::String>,
        pub(crate) source_server_tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>ID of vCenter client.</p>
        pub fn vcenter_client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vcenter_client_id = Some(input.into());
            self
        }
        /// <p>ID of vCenter client.</p>
        pub fn set_vcenter_client_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vcenter_client_id = input;
            self
        }
        /// <p>Arn of vCenter client.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>Arn of vCenter client.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>Hostname of vCenter client .</p>
        pub fn hostname(mut self, input: impl Into<std::string::String>) -> Self {
            self.hostname = Some(input.into());
            self
        }
        /// <p>Hostname of vCenter client .</p>
        pub fn set_hostname(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hostname = input;
            self
        }
        /// <p>Vcenter UUID of vCenter client.</p>
        pub fn vcenter_uuid(mut self, input: impl Into<std::string::String>) -> Self {
            self.vcenter_uuid = Some(input.into());
            self
        }
        /// <p>Vcenter UUID of vCenter client.</p>
        pub fn set_vcenter_uuid(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vcenter_uuid = input;
            self
        }
        /// <p>Datacenter name of vCenter client.</p>
        pub fn datacenter_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.datacenter_name = Some(input.into());
            self
        }
        /// <p>Datacenter name of vCenter client.</p>
        pub fn set_datacenter_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.datacenter_name = input;
            self
        }
        /// <p>Last seen time of vCenter client.</p>
        pub fn last_seen_datetime(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_seen_datetime = Some(input.into());
            self
        }
        /// <p>Last seen time of vCenter client.</p>
        pub fn set_last_seen_datetime(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_seen_datetime = input;
            self
        }
        /// Adds a key-value pair to `source_server_tags`.
        ///
        /// To override the contents of this collection use [`set_source_server_tags`](Self::set_source_server_tags).
        ///
        /// <p>Tags for Source Server of vCenter client.</p>
        pub fn source_server_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.source_server_tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.source_server_tags = Some(hash_map);
            self
        }
        /// <p>Tags for Source Server of vCenter client.</p>
        pub fn set_source_server_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.source_server_tags = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags for vCenter client.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Tags for vCenter client.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`VcenterClient`](crate::model::VcenterClient)
        pub fn build(self) -> crate::model::VcenterClient {
            crate::model::VcenterClient {
                vcenter_client_id: self.vcenter_client_id,
                arn: self.arn,
                hostname: self.hostname,
                vcenter_uuid: self.vcenter_uuid,
                datacenter_name: self.datacenter_name,
                last_seen_datetime: self.last_seen_datetime,
                source_server_tags: self.source_server_tags,
                tags: self.tags,
            }
        }
    }
}
impl VcenterClient {
    /// Creates a new builder-style object to manufacture [`VcenterClient`](crate::model::VcenterClient)
    pub fn builder() -> crate::model::vcenter_client::Builder {
        crate::model::vcenter_client::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReplicationType {
    #[allow(missing_docs)] // documentation missing in model
    AgentBased,
    #[allow(missing_docs)] // documentation missing in model
    SnapshotShipping,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReplicationType {
    fn from(s: &str) -> Self {
        match s {
            "AGENT_BASED" => ReplicationType::AgentBased,
            "SNAPSHOT_SHIPPING" => ReplicationType::SnapshotShipping,
            other => ReplicationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReplicationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReplicationType::from(s))
    }
}
impl ReplicationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReplicationType::AgentBased => "AGENT_BASED",
            ReplicationType::SnapshotShipping => "SNAPSHOT_SHIPPING",
            ReplicationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AGENT_BASED", "SNAPSHOT_SHIPPING"]
    }
}
impl AsRef<str> for ReplicationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Source server properties.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SourceProperties {
    /// <p>Source server last update date and time.</p>
    pub last_updated_date_time: std::option::Option<std::string::String>,
    /// <p>Source server recommended instance type.</p>
    pub recommended_instance_type: std::option::Option<std::string::String>,
    /// <p>Source server identification hints.</p>
    pub identification_hints: std::option::Option<crate::model::IdentificationHints>,
    /// <p>Source server network interfaces.</p>
    pub network_interfaces: std::option::Option<std::vec::Vec<crate::model::NetworkInterface>>,
    /// <p>Source Server disks.</p>
    pub disks: std::option::Option<std::vec::Vec<crate::model::Disk>>,
    /// <p>Source Server CPUs.</p>
    pub cpus: std::option::Option<std::vec::Vec<crate::model::Cpu>>,
    /// <p>Source server RAM in bytes.</p>
    pub ram_bytes: i64,
    /// <p>Source server OS.</p>
    pub os: std::option::Option<crate::model::Os>,
}
impl SourceProperties {
    /// <p>Source server last update date and time.</p>
    pub fn last_updated_date_time(&self) -> std::option::Option<&str> {
        self.last_updated_date_time.as_deref()
    }
    /// <p>Source server recommended instance type.</p>
    pub fn recommended_instance_type(&self) -> std::option::Option<&str> {
        self.recommended_instance_type.as_deref()
    }
    /// <p>Source server identification hints.</p>
    pub fn identification_hints(&self) -> std::option::Option<&crate::model::IdentificationHints> {
        self.identification_hints.as_ref()
    }
    /// <p>Source server network interfaces.</p>
    pub fn network_interfaces(&self) -> std::option::Option<&[crate::model::NetworkInterface]> {
        self.network_interfaces.as_deref()
    }
    /// <p>Source Server disks.</p>
    pub fn disks(&self) -> std::option::Option<&[crate::model::Disk]> {
        self.disks.as_deref()
    }
    /// <p>Source Server CPUs.</p>
    pub fn cpus(&self) -> std::option::Option<&[crate::model::Cpu]> {
        self.cpus.as_deref()
    }
    /// <p>Source server RAM in bytes.</p>
    pub fn ram_bytes(&self) -> i64 {
        self.ram_bytes
    }
    /// <p>Source server OS.</p>
    pub fn os(&self) -> std::option::Option<&crate::model::Os> {
        self.os.as_ref()
    }
}
impl std::fmt::Debug for SourceProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SourceProperties");
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.field("recommended_instance_type", &self.recommended_instance_type);
        formatter.field("identification_hints", &self.identification_hints);
        formatter.field("network_interfaces", &self.network_interfaces);
        formatter.field("disks", &self.disks);
        formatter.field("cpus", &self.cpus);
        formatter.field("ram_bytes", &self.ram_bytes);
        formatter.field("os", &self.os);
        formatter.finish()
    }
}
/// See [`SourceProperties`](crate::model::SourceProperties)
pub mod source_properties {
    /// A builder for [`SourceProperties`](crate::model::SourceProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) last_updated_date_time: std::option::Option<std::string::String>,
        pub(crate) recommended_instance_type: std::option::Option<std::string::String>,
        pub(crate) identification_hints: std::option::Option<crate::model::IdentificationHints>,
        pub(crate) network_interfaces:
            std::option::Option<std::vec::Vec<crate::model::NetworkInterface>>,
        pub(crate) disks: std::option::Option<std::vec::Vec<crate::model::Disk>>,
        pub(crate) cpus: std::option::Option<std::vec::Vec<crate::model::Cpu>>,
        pub(crate) ram_bytes: std::option::Option<i64>,
        pub(crate) os: std::option::Option<crate::model::Os>,
    }
    impl Builder {
        /// <p>Source server last update date and time.</p>
        pub fn last_updated_date_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_updated_date_time = Some(input.into());
            self
        }
        /// <p>Source server last update date and time.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// <p>Source server recommended instance type.</p>
        pub fn recommended_instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.recommended_instance_type = Some(input.into());
            self
        }
        /// <p>Source server recommended instance type.</p>
        pub fn set_recommended_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recommended_instance_type = input;
            self
        }
        /// <p>Source server identification hints.</p>
        pub fn identification_hints(mut self, input: crate::model::IdentificationHints) -> Self {
            self.identification_hints = Some(input);
            self
        }
        /// <p>Source server identification hints.</p>
        pub fn set_identification_hints(
            mut self,
            input: std::option::Option<crate::model::IdentificationHints>,
        ) -> Self {
            self.identification_hints = input;
            self
        }
        /// Appends an item to `network_interfaces`.
        ///
        /// To override the contents of this collection use [`set_network_interfaces`](Self::set_network_interfaces).
        ///
        /// <p>Source server network interfaces.</p>
        pub fn network_interfaces(mut self, input: crate::model::NetworkInterface) -> Self {
            let mut v = self.network_interfaces.unwrap_or_default();
            v.push(input);
            self.network_interfaces = Some(v);
            self
        }
        /// <p>Source server network interfaces.</p>
        pub fn set_network_interfaces(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NetworkInterface>>,
        ) -> Self {
            self.network_interfaces = input;
            self
        }
        /// Appends an item to `disks`.
        ///
        /// To override the contents of this collection use [`set_disks`](Self::set_disks).
        ///
        /// <p>Source Server disks.</p>
        pub fn disks(mut self, input: crate::model::Disk) -> Self {
            let mut v = self.disks.unwrap_or_default();
            v.push(input);
            self.disks = Some(v);
            self
        }
        /// <p>Source Server disks.</p>
        pub fn set_disks(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Disk>>,
        ) -> Self {
            self.disks = input;
            self
        }
        /// Appends an item to `cpus`.
        ///
        /// To override the contents of this collection use [`set_cpus`](Self::set_cpus).
        ///
        /// <p>Source Server CPUs.</p>
        pub fn cpus(mut self, input: crate::model::Cpu) -> Self {
            let mut v = self.cpus.unwrap_or_default();
            v.push(input);
            self.cpus = Some(v);
            self
        }
        /// <p>Source Server CPUs.</p>
        pub fn set_cpus(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Cpu>>,
        ) -> Self {
            self.cpus = input;
            self
        }
        /// <p>Source server RAM in bytes.</p>
        pub fn ram_bytes(mut self, input: i64) -> Self {
            self.ram_bytes = Some(input);
            self
        }
        /// <p>Source server RAM in bytes.</p>
        pub fn set_ram_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.ram_bytes = input;
            self
        }
        /// <p>Source server OS.</p>
        pub fn os(mut self, input: crate::model::Os) -> Self {
            self.os = Some(input);
            self
        }
        /// <p>Source server OS.</p>
        pub fn set_os(mut self, input: std::option::Option<crate::model::Os>) -> Self {
            self.os = input;
            self
        }
        /// Consumes the builder and constructs a [`SourceProperties`](crate::model::SourceProperties)
        pub fn build(self) -> crate::model::SourceProperties {
            crate::model::SourceProperties {
                last_updated_date_time: self.last_updated_date_time,
                recommended_instance_type: self.recommended_instance_type,
                identification_hints: self.identification_hints,
                network_interfaces: self.network_interfaces,
                disks: self.disks,
                cpus: self.cpus,
                ram_bytes: self.ram_bytes.unwrap_or_default(),
                os: self.os,
            }
        }
    }
}
impl SourceProperties {
    /// Creates a new builder-style object to manufacture [`SourceProperties`](crate::model::SourceProperties)
    pub fn builder() -> crate::model::source_properties::Builder {
        crate::model::source_properties::Builder::default()
    }
}

/// <p>Operating System.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Os {
    /// <p>OS full string.</p>
    pub full_string: std::option::Option<std::string::String>,
}
impl Os {
    /// <p>OS full string.</p>
    pub fn full_string(&self) -> std::option::Option<&str> {
        self.full_string.as_deref()
    }
}
impl std::fmt::Debug for Os {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Os");
        formatter.field("full_string", &self.full_string);
        formatter.finish()
    }
}
/// See [`Os`](crate::model::Os)
pub mod os {
    /// A builder for [`Os`](crate::model::Os)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) full_string: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>OS full string.</p>
        pub fn full_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.full_string = Some(input.into());
            self
        }
        /// <p>OS full string.</p>
        pub fn set_full_string(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.full_string = input;
            self
        }
        /// Consumes the builder and constructs a [`Os`](crate::model::Os)
        pub fn build(self) -> crate::model::Os {
            crate::model::Os {
                full_string: self.full_string,
            }
        }
    }
}
impl Os {
    /// Creates a new builder-style object to manufacture [`Os`](crate::model::Os)
    pub fn builder() -> crate::model::os::Builder {
        crate::model::os::Builder::default()
    }
}

/// <p>Source server CPU information.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Cpu {
    /// <p>The number of CPU cores on the source server.</p>
    pub cores: i64,
    /// <p>The source server's CPU model name.</p>
    pub model_name: std::option::Option<std::string::String>,
}
impl Cpu {
    /// <p>The number of CPU cores on the source server.</p>
    pub fn cores(&self) -> i64 {
        self.cores
    }
    /// <p>The source server's CPU model name.</p>
    pub fn model_name(&self) -> std::option::Option<&str> {
        self.model_name.as_deref()
    }
}
impl std::fmt::Debug for Cpu {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Cpu");
        formatter.field("cores", &self.cores);
        formatter.field("model_name", &self.model_name);
        formatter.finish()
    }
}
/// See [`Cpu`](crate::model::Cpu)
pub mod cpu {
    /// A builder for [`Cpu`](crate::model::Cpu)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cores: std::option::Option<i64>,
        pub(crate) model_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The number of CPU cores on the source server.</p>
        pub fn cores(mut self, input: i64) -> Self {
            self.cores = Some(input);
            self
        }
        /// <p>The number of CPU cores on the source server.</p>
        pub fn set_cores(mut self, input: std::option::Option<i64>) -> Self {
            self.cores = input;
            self
        }
        /// <p>The source server's CPU model name.</p>
        pub fn model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_name = Some(input.into());
            self
        }
        /// <p>The source server's CPU model name.</p>
        pub fn set_model_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.model_name = input;
            self
        }
        /// Consumes the builder and constructs a [`Cpu`](crate::model::Cpu)
        pub fn build(self) -> crate::model::Cpu {
            crate::model::Cpu {
                cores: self.cores.unwrap_or_default(),
                model_name: self.model_name,
            }
        }
    }
}
impl Cpu {
    /// Creates a new builder-style object to manufacture [`Cpu`](crate::model::Cpu)
    pub fn builder() -> crate::model::cpu::Builder {
        crate::model::cpu::Builder::default()
    }
}

/// <p>The disk identifier.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Disk {
    /// <p>The disk or device name.</p>
    pub device_name: std::option::Option<std::string::String>,
    /// <p>The amount of storage on the disk in bytes.</p>
    pub bytes: i64,
}
impl Disk {
    /// <p>The disk or device name.</p>
    pub fn device_name(&self) -> std::option::Option<&str> {
        self.device_name.as_deref()
    }
    /// <p>The amount of storage on the disk in bytes.</p>
    pub fn bytes(&self) -> i64 {
        self.bytes
    }
}
impl std::fmt::Debug for Disk {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Disk");
        formatter.field("device_name", &self.device_name);
        formatter.field("bytes", &self.bytes);
        formatter.finish()
    }
}
/// See [`Disk`](crate::model::Disk)
pub mod disk {
    /// A builder for [`Disk`](crate::model::Disk)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_name: std::option::Option<std::string::String>,
        pub(crate) bytes: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The disk or device name.</p>
        pub fn device_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_name = Some(input.into());
            self
        }
        /// <p>The disk or device name.</p>
        pub fn set_device_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_name = input;
            self
        }
        /// <p>The amount of storage on the disk in bytes.</p>
        pub fn bytes(mut self, input: i64) -> Self {
            self.bytes = Some(input);
            self
        }
        /// <p>The amount of storage on the disk in bytes.</p>
        pub fn set_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.bytes = input;
            self
        }
        /// Consumes the builder and constructs a [`Disk`](crate::model::Disk)
        pub fn build(self) -> crate::model::Disk {
            crate::model::Disk {
                device_name: self.device_name,
                bytes: self.bytes.unwrap_or_default(),
            }
        }
    }
}
impl Disk {
    /// Creates a new builder-style object to manufacture [`Disk`](crate::model::Disk)
    pub fn builder() -> crate::model::disk::Builder {
        crate::model::disk::Builder::default()
    }
}

/// <p>Network interface.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NetworkInterface {
    /// <p>Network interface Mac address.</p>
    pub mac_address: std::option::Option<std::string::String>,
    /// <p>Network interface IPs.</p>
    pub ips: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Network interface primary IP.</p>
    pub is_primary: std::option::Option<bool>,
}
impl NetworkInterface {
    /// <p>Network interface Mac address.</p>
    pub fn mac_address(&self) -> std::option::Option<&str> {
        self.mac_address.as_deref()
    }
    /// <p>Network interface IPs.</p>
    pub fn ips(&self) -> std::option::Option<&[std::string::String]> {
        self.ips.as_deref()
    }
    /// <p>Network interface primary IP.</p>
    pub fn is_primary(&self) -> std::option::Option<bool> {
        self.is_primary
    }
}
impl std::fmt::Debug for NetworkInterface {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NetworkInterface");
        formatter.field("mac_address", &self.mac_address);
        formatter.field("ips", &self.ips);
        formatter.field("is_primary", &self.is_primary);
        formatter.finish()
    }
}
/// See [`NetworkInterface`](crate::model::NetworkInterface)
pub mod network_interface {
    /// A builder for [`NetworkInterface`](crate::model::NetworkInterface)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mac_address: std::option::Option<std::string::String>,
        pub(crate) ips: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) is_primary: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Network interface Mac address.</p>
        pub fn mac_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.mac_address = Some(input.into());
            self
        }
        /// <p>Network interface Mac address.</p>
        pub fn set_mac_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mac_address = input;
            self
        }
        /// Appends an item to `ips`.
        ///
        /// To override the contents of this collection use [`set_ips`](Self::set_ips).
        ///
        /// <p>Network interface IPs.</p>
        pub fn ips(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.ips.unwrap_or_default();
            v.push(input.into());
            self.ips = Some(v);
            self
        }
        /// <p>Network interface IPs.</p>
        pub fn set_ips(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.ips = input;
            self
        }
        /// <p>Network interface primary IP.</p>
        pub fn is_primary(mut self, input: bool) -> Self {
            self.is_primary = Some(input);
            self
        }
        /// <p>Network interface primary IP.</p>
        pub fn set_is_primary(mut self, input: std::option::Option<bool>) -> Self {
            self.is_primary = input;
            self
        }
        /// Consumes the builder and constructs a [`NetworkInterface`](crate::model::NetworkInterface)
        pub fn build(self) -> crate::model::NetworkInterface {
            crate::model::NetworkInterface {
                mac_address: self.mac_address,
                ips: self.ips,
                is_primary: self.is_primary,
            }
        }
    }
}
impl NetworkInterface {
    /// Creates a new builder-style object to manufacture [`NetworkInterface`](crate::model::NetworkInterface)
    pub fn builder() -> crate::model::network_interface::Builder {
        crate::model::network_interface::Builder::default()
    }
}

/// <p>Identification hints.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IdentificationHints {
    /// <p>FQDN address identification hint.</p>
    pub fqdn: std::option::Option<std::string::String>,
    /// <p>Hostname identification hint.</p>
    pub hostname: std::option::Option<std::string::String>,
    /// <p>vmWare UUID identification hint.</p>
    pub vm_ware_uuid: std::option::Option<std::string::String>,
    /// <p>AWS Instance ID identification hint.</p>
    pub aws_instance_id: std::option::Option<std::string::String>,
    /// <p>vCenter VM path identification hint.</p>
    pub vm_path: std::option::Option<std::string::String>,
}
impl IdentificationHints {
    /// <p>FQDN address identification hint.</p>
    pub fn fqdn(&self) -> std::option::Option<&str> {
        self.fqdn.as_deref()
    }
    /// <p>Hostname identification hint.</p>
    pub fn hostname(&self) -> std::option::Option<&str> {
        self.hostname.as_deref()
    }
    /// <p>vmWare UUID identification hint.</p>
    pub fn vm_ware_uuid(&self) -> std::option::Option<&str> {
        self.vm_ware_uuid.as_deref()
    }
    /// <p>AWS Instance ID identification hint.</p>
    pub fn aws_instance_id(&self) -> std::option::Option<&str> {
        self.aws_instance_id.as_deref()
    }
    /// <p>vCenter VM path identification hint.</p>
    pub fn vm_path(&self) -> std::option::Option<&str> {
        self.vm_path.as_deref()
    }
}
impl std::fmt::Debug for IdentificationHints {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IdentificationHints");
        formatter.field("fqdn", &self.fqdn);
        formatter.field("hostname", &self.hostname);
        formatter.field("vm_ware_uuid", &self.vm_ware_uuid);
        formatter.field("aws_instance_id", &self.aws_instance_id);
        formatter.field("vm_path", &self.vm_path);
        formatter.finish()
    }
}
/// See [`IdentificationHints`](crate::model::IdentificationHints)
pub mod identification_hints {
    /// A builder for [`IdentificationHints`](crate::model::IdentificationHints)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fqdn: std::option::Option<std::string::String>,
        pub(crate) hostname: std::option::Option<std::string::String>,
        pub(crate) vm_ware_uuid: std::option::Option<std::string::String>,
        pub(crate) aws_instance_id: std::option::Option<std::string::String>,
        pub(crate) vm_path: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>FQDN address identification hint.</p>
        pub fn fqdn(mut self, input: impl Into<std::string::String>) -> Self {
            self.fqdn = Some(input.into());
            self
        }
        /// <p>FQDN address identification hint.</p>
        pub fn set_fqdn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fqdn = input;
            self
        }
        /// <p>Hostname identification hint.</p>
        pub fn hostname(mut self, input: impl Into<std::string::String>) -> Self {
            self.hostname = Some(input.into());
            self
        }
        /// <p>Hostname identification hint.</p>
        pub fn set_hostname(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hostname = input;
            self
        }
        /// <p>vmWare UUID identification hint.</p>
        pub fn vm_ware_uuid(mut self, input: impl Into<std::string::String>) -> Self {
            self.vm_ware_uuid = Some(input.into());
            self
        }
        /// <p>vmWare UUID identification hint.</p>
        pub fn set_vm_ware_uuid(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vm_ware_uuid = input;
            self
        }
        /// <p>AWS Instance ID identification hint.</p>
        pub fn aws_instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_instance_id = Some(input.into());
            self
        }
        /// <p>AWS Instance ID identification hint.</p>
        pub fn set_aws_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_instance_id = input;
            self
        }
        /// <p>vCenter VM path identification hint.</p>
        pub fn vm_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.vm_path = Some(input.into());
            self
        }
        /// <p>vCenter VM path identification hint.</p>
        pub fn set_vm_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vm_path = input;
            self
        }
        /// Consumes the builder and constructs a [`IdentificationHints`](crate::model::IdentificationHints)
        pub fn build(self) -> crate::model::IdentificationHints {
            crate::model::IdentificationHints {
                fqdn: self.fqdn,
                hostname: self.hostname,
                vm_ware_uuid: self.vm_ware_uuid,
                aws_instance_id: self.aws_instance_id,
                vm_path: self.vm_path,
            }
        }
    }
}
impl IdentificationHints {
    /// Creates a new builder-style object to manufacture [`IdentificationHints`](crate::model::IdentificationHints)
    pub fn builder() -> crate::model::identification_hints::Builder {
        crate::model::identification_hints::Builder::default()
    }
}

/// <p>Lifecycle.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LifeCycle {
    /// <p>Lifecycle added to service data and time.</p>
    pub added_to_service_date_time: std::option::Option<std::string::String>,
    /// <p>Lifecycle replication initiation date and time.</p>
    pub first_byte_date_time: std::option::Option<std::string::String>,
    /// <p>Lifecycle elapsed time and duration.</p>
    pub elapsed_replication_duration: std::option::Option<std::string::String>,
    /// <p>Lifecycle last seen date and time.</p>
    pub last_seen_by_service_date_time: std::option::Option<std::string::String>,
    /// <p>Lifecycle last Test.</p>
    pub last_test: std::option::Option<crate::model::LifeCycleLastTest>,
    /// <p>Lifecycle last Cutover.</p>
    pub last_cutover: std::option::Option<crate::model::LifeCycleLastCutover>,
    /// <p>Lifecycle state.</p>
    pub state: std::option::Option<crate::model::LifeCycleState>,
}
impl LifeCycle {
    /// <p>Lifecycle added to service data and time.</p>
    pub fn added_to_service_date_time(&self) -> std::option::Option<&str> {
        self.added_to_service_date_time.as_deref()
    }
    /// <p>Lifecycle replication initiation date and time.</p>
    pub fn first_byte_date_time(&self) -> std::option::Option<&str> {
        self.first_byte_date_time.as_deref()
    }
    /// <p>Lifecycle elapsed time and duration.</p>
    pub fn elapsed_replication_duration(&self) -> std::option::Option<&str> {
        self.elapsed_replication_duration.as_deref()
    }
    /// <p>Lifecycle last seen date and time.</p>
    pub fn last_seen_by_service_date_time(&self) -> std::option::Option<&str> {
        self.last_seen_by_service_date_time.as_deref()
    }
    /// <p>Lifecycle last Test.</p>
    pub fn last_test(&self) -> std::option::Option<&crate::model::LifeCycleLastTest> {
        self.last_test.as_ref()
    }
    /// <p>Lifecycle last Cutover.</p>
    pub fn last_cutover(&self) -> std::option::Option<&crate::model::LifeCycleLastCutover> {
        self.last_cutover.as_ref()
    }
    /// <p>Lifecycle state.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::LifeCycleState> {
        self.state.as_ref()
    }
}
impl std::fmt::Debug for LifeCycle {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LifeCycle");
        formatter.field(
            "added_to_service_date_time",
            &self.added_to_service_date_time,
        );
        formatter.field("first_byte_date_time", &self.first_byte_date_time);
        formatter.field(
            "elapsed_replication_duration",
            &self.elapsed_replication_duration,
        );
        formatter.field(
            "last_seen_by_service_date_time",
            &self.last_seen_by_service_date_time,
        );
        formatter.field("last_test", &self.last_test);
        formatter.field("last_cutover", &self.last_cutover);
        formatter.field("state", &self.state);
        formatter.finish()
    }
}
/// See [`LifeCycle`](crate::model::LifeCycle)
pub mod life_cycle {
    /// A builder for [`LifeCycle`](crate::model::LifeCycle)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) added_to_service_date_time: std::option::Option<std::string::String>,
        pub(crate) first_byte_date_time: std::option::Option<std::string::String>,
        pub(crate) elapsed_replication_duration: std::option::Option<std::string::String>,
        pub(crate) last_seen_by_service_date_time: std::option::Option<std::string::String>,
        pub(crate) last_test: std::option::Option<crate::model::LifeCycleLastTest>,
        pub(crate) last_cutover: std::option::Option<crate::model::LifeCycleLastCutover>,
        pub(crate) state: std::option::Option<crate::model::LifeCycleState>,
    }
    impl Builder {
        /// <p>Lifecycle added to service data and time.</p>
        pub fn added_to_service_date_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.added_to_service_date_time = Some(input.into());
            self
        }
        /// <p>Lifecycle added to service data and time.</p>
        pub fn set_added_to_service_date_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.added_to_service_date_time = input;
            self
        }
        /// <p>Lifecycle replication initiation date and time.</p>
        pub fn first_byte_date_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.first_byte_date_time = Some(input.into());
            self
        }
        /// <p>Lifecycle replication initiation date and time.</p>
        pub fn set_first_byte_date_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.first_byte_date_time = input;
            self
        }
        /// <p>Lifecycle elapsed time and duration.</p>
        pub fn elapsed_replication_duration(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.elapsed_replication_duration = Some(input.into());
            self
        }
        /// <p>Lifecycle elapsed time and duration.</p>
        pub fn set_elapsed_replication_duration(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.elapsed_replication_duration = input;
            self
        }
        /// <p>Lifecycle last seen date and time.</p>
        pub fn last_seen_by_service_date_time(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.last_seen_by_service_date_time = Some(input.into());
            self
        }
        /// <p>Lifecycle last seen date and time.</p>
        pub fn set_last_seen_by_service_date_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_seen_by_service_date_time = input;
            self
        }
        /// <p>Lifecycle last Test.</p>
        pub fn last_test(mut self, input: crate::model::LifeCycleLastTest) -> Self {
            self.last_test = Some(input);
            self
        }
        /// <p>Lifecycle last Test.</p>
        pub fn set_last_test(
            mut self,
            input: std::option::Option<crate::model::LifeCycleLastTest>,
        ) -> Self {
            self.last_test = input;
            self
        }
        /// <p>Lifecycle last Cutover.</p>
        pub fn last_cutover(mut self, input: crate::model::LifeCycleLastCutover) -> Self {
            self.last_cutover = Some(input);
            self
        }
        /// <p>Lifecycle last Cutover.</p>
        pub fn set_last_cutover(
            mut self,
            input: std::option::Option<crate::model::LifeCycleLastCutover>,
        ) -> Self {
            self.last_cutover = input;
            self
        }
        /// <p>Lifecycle state.</p>
        pub fn state(mut self, input: crate::model::LifeCycleState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>Lifecycle state.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::LifeCycleState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Consumes the builder and constructs a [`LifeCycle`](crate::model::LifeCycle)
        pub fn build(self) -> crate::model::LifeCycle {
            crate::model::LifeCycle {
                added_to_service_date_time: self.added_to_service_date_time,
                first_byte_date_time: self.first_byte_date_time,
                elapsed_replication_duration: self.elapsed_replication_duration,
                last_seen_by_service_date_time: self.last_seen_by_service_date_time,
                last_test: self.last_test,
                last_cutover: self.last_cutover,
                state: self.state,
            }
        }
    }
}
impl LifeCycle {
    /// Creates a new builder-style object to manufacture [`LifeCycle`](crate::model::LifeCycle)
    pub fn builder() -> crate::model::life_cycle::Builder {
        crate::model::life_cycle::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LifeCycleState {
    #[allow(missing_docs)] // documentation missing in model
    Cutover,
    #[allow(missing_docs)] // documentation missing in model
    CuttingOver,
    #[allow(missing_docs)] // documentation missing in model
    Disconnected,
    #[allow(missing_docs)] // documentation missing in model
    Discovered,
    #[allow(missing_docs)] // documentation missing in model
    NotReady,
    #[allow(missing_docs)] // documentation missing in model
    ReadyForCutover,
    #[allow(missing_docs)] // documentation missing in model
    ReadyForTest,
    #[allow(missing_docs)] // documentation missing in model
    Stopped,
    #[allow(missing_docs)] // documentation missing in model
    Testing,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LifeCycleState {
    fn from(s: &str) -> Self {
        match s {
            "CUTOVER" => LifeCycleState::Cutover,
            "CUTTING_OVER" => LifeCycleState::CuttingOver,
            "DISCONNECTED" => LifeCycleState::Disconnected,
            "DISCOVERED" => LifeCycleState::Discovered,
            "NOT_READY" => LifeCycleState::NotReady,
            "READY_FOR_CUTOVER" => LifeCycleState::ReadyForCutover,
            "READY_FOR_TEST" => LifeCycleState::ReadyForTest,
            "STOPPED" => LifeCycleState::Stopped,
            "TESTING" => LifeCycleState::Testing,
            other => LifeCycleState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LifeCycleState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LifeCycleState::from(s))
    }
}
impl LifeCycleState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LifeCycleState::Cutover => "CUTOVER",
            LifeCycleState::CuttingOver => "CUTTING_OVER",
            LifeCycleState::Disconnected => "DISCONNECTED",
            LifeCycleState::Discovered => "DISCOVERED",
            LifeCycleState::NotReady => "NOT_READY",
            LifeCycleState::ReadyForCutover => "READY_FOR_CUTOVER",
            LifeCycleState::ReadyForTest => "READY_FOR_TEST",
            LifeCycleState::Stopped => "STOPPED",
            LifeCycleState::Testing => "TESTING",
            LifeCycleState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CUTOVER",
            "CUTTING_OVER",
            "DISCONNECTED",
            "DISCOVERED",
            "NOT_READY",
            "READY_FOR_CUTOVER",
            "READY_FOR_TEST",
            "STOPPED",
            "TESTING",
        ]
    }
}
impl AsRef<str> for LifeCycleState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Lifecycle last Cutover .</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LifeCycleLastCutover {
    /// <p>Lifecycle last Cutover initiated.</p>
    pub initiated: std::option::Option<crate::model::LifeCycleLastCutoverInitiated>,
    /// <p>Lifecycle last Cutover reverted.</p>
    pub reverted: std::option::Option<crate::model::LifeCycleLastCutoverReverted>,
    /// <p>Lifecycle Cutover finalized date and time.</p>
    pub finalized: std::option::Option<crate::model::LifeCycleLastCutoverFinalized>,
}
impl LifeCycleLastCutover {
    /// <p>Lifecycle last Cutover initiated.</p>
    pub fn initiated(&self) -> std::option::Option<&crate::model::LifeCycleLastCutoverInitiated> {
        self.initiated.as_ref()
    }
    /// <p>Lifecycle last Cutover reverted.</p>
    pub fn reverted(&self) -> std::option::Option<&crate::model::LifeCycleLastCutoverReverted> {
        self.reverted.as_ref()
    }
    /// <p>Lifecycle Cutover finalized date and time.</p>
    pub fn finalized(&self) -> std::option::Option<&crate::model::LifeCycleLastCutoverFinalized> {
        self.finalized.as_ref()
    }
}
impl std::fmt::Debug for LifeCycleLastCutover {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LifeCycleLastCutover");
        formatter.field("initiated", &self.initiated);
        formatter.field("reverted", &self.reverted);
        formatter.field("finalized", &self.finalized);
        formatter.finish()
    }
}
/// See [`LifeCycleLastCutover`](crate::model::LifeCycleLastCutover)
pub mod life_cycle_last_cutover {
    /// A builder for [`LifeCycleLastCutover`](crate::model::LifeCycleLastCutover)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) initiated: std::option::Option<crate::model::LifeCycleLastCutoverInitiated>,
        pub(crate) reverted: std::option::Option<crate::model::LifeCycleLastCutoverReverted>,
        pub(crate) finalized: std::option::Option<crate::model::LifeCycleLastCutoverFinalized>,
    }
    impl Builder {
        /// <p>Lifecycle last Cutover initiated.</p>
        pub fn initiated(mut self, input: crate::model::LifeCycleLastCutoverInitiated) -> Self {
            self.initiated = Some(input);
            self
        }
        /// <p>Lifecycle last Cutover initiated.</p>
        pub fn set_initiated(
            mut self,
            input: std::option::Option<crate::model::LifeCycleLastCutoverInitiated>,
        ) -> Self {
            self.initiated = input;
            self
        }
        /// <p>Lifecycle last Cutover reverted.</p>
        pub fn reverted(mut self, input: crate::model::LifeCycleLastCutoverReverted) -> Self {
            self.reverted = Some(input);
            self
        }
        /// <p>Lifecycle last Cutover reverted.</p>
        pub fn set_reverted(
            mut self,
            input: std::option::Option<crate::model::LifeCycleLastCutoverReverted>,
        ) -> Self {
            self.reverted = input;
            self
        }
        /// <p>Lifecycle Cutover finalized date and time.</p>
        pub fn finalized(mut self, input: crate::model::LifeCycleLastCutoverFinalized) -> Self {
            self.finalized = Some(input);
            self
        }
        /// <p>Lifecycle Cutover finalized date and time.</p>
        pub fn set_finalized(
            mut self,
            input: std::option::Option<crate::model::LifeCycleLastCutoverFinalized>,
        ) -> Self {
            self.finalized = input;
            self
        }
        /// Consumes the builder and constructs a [`LifeCycleLastCutover`](crate::model::LifeCycleLastCutover)
        pub fn build(self) -> crate::model::LifeCycleLastCutover {
            crate::model::LifeCycleLastCutover {
                initiated: self.initiated,
                reverted: self.reverted,
                finalized: self.finalized,
            }
        }
    }
}
impl LifeCycleLastCutover {
    /// Creates a new builder-style object to manufacture [`LifeCycleLastCutover`](crate::model::LifeCycleLastCutover)
    pub fn builder() -> crate::model::life_cycle_last_cutover::Builder {
        crate::model::life_cycle_last_cutover::Builder::default()
    }
}

/// <p>Lifecycle Cutover finalized</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LifeCycleLastCutoverFinalized {
    /// <p>Lifecycle Cutover finalized date and time.</p>
    pub api_call_date_time: std::option::Option<std::string::String>,
}
impl LifeCycleLastCutoverFinalized {
    /// <p>Lifecycle Cutover finalized date and time.</p>
    pub fn api_call_date_time(&self) -> std::option::Option<&str> {
        self.api_call_date_time.as_deref()
    }
}
impl std::fmt::Debug for LifeCycleLastCutoverFinalized {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LifeCycleLastCutoverFinalized");
        formatter.field("api_call_date_time", &self.api_call_date_time);
        formatter.finish()
    }
}
/// See [`LifeCycleLastCutoverFinalized`](crate::model::LifeCycleLastCutoverFinalized)
pub mod life_cycle_last_cutover_finalized {
    /// A builder for [`LifeCycleLastCutoverFinalized`](crate::model::LifeCycleLastCutoverFinalized)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_call_date_time: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Lifecycle Cutover finalized date and time.</p>
        pub fn api_call_date_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_call_date_time = Some(input.into());
            self
        }
        /// <p>Lifecycle Cutover finalized date and time.</p>
        pub fn set_api_call_date_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.api_call_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`LifeCycleLastCutoverFinalized`](crate::model::LifeCycleLastCutoverFinalized)
        pub fn build(self) -> crate::model::LifeCycleLastCutoverFinalized {
            crate::model::LifeCycleLastCutoverFinalized {
                api_call_date_time: self.api_call_date_time,
            }
        }
    }
}
impl LifeCycleLastCutoverFinalized {
    /// Creates a new builder-style object to manufacture [`LifeCycleLastCutoverFinalized`](crate::model::LifeCycleLastCutoverFinalized)
    pub fn builder() -> crate::model::life_cycle_last_cutover_finalized::Builder {
        crate::model::life_cycle_last_cutover_finalized::Builder::default()
    }
}

/// <p>Lifecycle last Cutover reverted.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LifeCycleLastCutoverReverted {
    /// <p>Lifecycle last Cutover reverted API call date time.</p>
    pub api_call_date_time: std::option::Option<std::string::String>,
}
impl LifeCycleLastCutoverReverted {
    /// <p>Lifecycle last Cutover reverted API call date time.</p>
    pub fn api_call_date_time(&self) -> std::option::Option<&str> {
        self.api_call_date_time.as_deref()
    }
}
impl std::fmt::Debug for LifeCycleLastCutoverReverted {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LifeCycleLastCutoverReverted");
        formatter.field("api_call_date_time", &self.api_call_date_time);
        formatter.finish()
    }
}
/// See [`LifeCycleLastCutoverReverted`](crate::model::LifeCycleLastCutoverReverted)
pub mod life_cycle_last_cutover_reverted {
    /// A builder for [`LifeCycleLastCutoverReverted`](crate::model::LifeCycleLastCutoverReverted)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_call_date_time: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Lifecycle last Cutover reverted API call date time.</p>
        pub fn api_call_date_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_call_date_time = Some(input.into());
            self
        }
        /// <p>Lifecycle last Cutover reverted API call date time.</p>
        pub fn set_api_call_date_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.api_call_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`LifeCycleLastCutoverReverted`](crate::model::LifeCycleLastCutoverReverted)
        pub fn build(self) -> crate::model::LifeCycleLastCutoverReverted {
            crate::model::LifeCycleLastCutoverReverted {
                api_call_date_time: self.api_call_date_time,
            }
        }
    }
}
impl LifeCycleLastCutoverReverted {
    /// Creates a new builder-style object to manufacture [`LifeCycleLastCutoverReverted`](crate::model::LifeCycleLastCutoverReverted)
    pub fn builder() -> crate::model::life_cycle_last_cutover_reverted::Builder {
        crate::model::life_cycle_last_cutover_reverted::Builder::default()
    }
}

/// <p>Lifecycle last Cutover initiated.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LifeCycleLastCutoverInitiated {
    /// <p></p>
    pub api_call_date_time: std::option::Option<std::string::String>,
    /// <p>Lifecycle last Cutover initiated by Job ID.</p>
    pub job_id: std::option::Option<std::string::String>,
}
impl LifeCycleLastCutoverInitiated {
    /// <p></p>
    pub fn api_call_date_time(&self) -> std::option::Option<&str> {
        self.api_call_date_time.as_deref()
    }
    /// <p>Lifecycle last Cutover initiated by Job ID.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
}
impl std::fmt::Debug for LifeCycleLastCutoverInitiated {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LifeCycleLastCutoverInitiated");
        formatter.field("api_call_date_time", &self.api_call_date_time);
        formatter.field("job_id", &self.job_id);
        formatter.finish()
    }
}
/// See [`LifeCycleLastCutoverInitiated`](crate::model::LifeCycleLastCutoverInitiated)
pub mod life_cycle_last_cutover_initiated {
    /// A builder for [`LifeCycleLastCutoverInitiated`](crate::model::LifeCycleLastCutoverInitiated)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_call_date_time: std::option::Option<std::string::String>,
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn api_call_date_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_call_date_time = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_api_call_date_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.api_call_date_time = input;
            self
        }
        /// <p>Lifecycle last Cutover initiated by Job ID.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>Lifecycle last Cutover initiated by Job ID.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`LifeCycleLastCutoverInitiated`](crate::model::LifeCycleLastCutoverInitiated)
        pub fn build(self) -> crate::model::LifeCycleLastCutoverInitiated {
            crate::model::LifeCycleLastCutoverInitiated {
                api_call_date_time: self.api_call_date_time,
                job_id: self.job_id,
            }
        }
    }
}
impl LifeCycleLastCutoverInitiated {
    /// Creates a new builder-style object to manufacture [`LifeCycleLastCutoverInitiated`](crate::model::LifeCycleLastCutoverInitiated)
    pub fn builder() -> crate::model::life_cycle_last_cutover_initiated::Builder {
        crate::model::life_cycle_last_cutover_initiated::Builder::default()
    }
}

/// <p>Lifecycle last Test.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LifeCycleLastTest {
    /// <p>Lifecycle last Test initiated.</p>
    pub initiated: std::option::Option<crate::model::LifeCycleLastTestInitiated>,
    /// <p>Lifecycle last Test reverted.</p>
    pub reverted: std::option::Option<crate::model::LifeCycleLastTestReverted>,
    /// <p>Lifecycle last Test finalized.</p>
    pub finalized: std::option::Option<crate::model::LifeCycleLastTestFinalized>,
}
impl LifeCycleLastTest {
    /// <p>Lifecycle last Test initiated.</p>
    pub fn initiated(&self) -> std::option::Option<&crate::model::LifeCycleLastTestInitiated> {
        self.initiated.as_ref()
    }
    /// <p>Lifecycle last Test reverted.</p>
    pub fn reverted(&self) -> std::option::Option<&crate::model::LifeCycleLastTestReverted> {
        self.reverted.as_ref()
    }
    /// <p>Lifecycle last Test finalized.</p>
    pub fn finalized(&self) -> std::option::Option<&crate::model::LifeCycleLastTestFinalized> {
        self.finalized.as_ref()
    }
}
impl std::fmt::Debug for LifeCycleLastTest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LifeCycleLastTest");
        formatter.field("initiated", &self.initiated);
        formatter.field("reverted", &self.reverted);
        formatter.field("finalized", &self.finalized);
        formatter.finish()
    }
}
/// See [`LifeCycleLastTest`](crate::model::LifeCycleLastTest)
pub mod life_cycle_last_test {
    /// A builder for [`LifeCycleLastTest`](crate::model::LifeCycleLastTest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) initiated: std::option::Option<crate::model::LifeCycleLastTestInitiated>,
        pub(crate) reverted: std::option::Option<crate::model::LifeCycleLastTestReverted>,
        pub(crate) finalized: std::option::Option<crate::model::LifeCycleLastTestFinalized>,
    }
    impl Builder {
        /// <p>Lifecycle last Test initiated.</p>
        pub fn initiated(mut self, input: crate::model::LifeCycleLastTestInitiated) -> Self {
            self.initiated = Some(input);
            self
        }
        /// <p>Lifecycle last Test initiated.</p>
        pub fn set_initiated(
            mut self,
            input: std::option::Option<crate::model::LifeCycleLastTestInitiated>,
        ) -> Self {
            self.initiated = input;
            self
        }
        /// <p>Lifecycle last Test reverted.</p>
        pub fn reverted(mut self, input: crate::model::LifeCycleLastTestReverted) -> Self {
            self.reverted = Some(input);
            self
        }
        /// <p>Lifecycle last Test reverted.</p>
        pub fn set_reverted(
            mut self,
            input: std::option::Option<crate::model::LifeCycleLastTestReverted>,
        ) -> Self {
            self.reverted = input;
            self
        }
        /// <p>Lifecycle last Test finalized.</p>
        pub fn finalized(mut self, input: crate::model::LifeCycleLastTestFinalized) -> Self {
            self.finalized = Some(input);
            self
        }
        /// <p>Lifecycle last Test finalized.</p>
        pub fn set_finalized(
            mut self,
            input: std::option::Option<crate::model::LifeCycleLastTestFinalized>,
        ) -> Self {
            self.finalized = input;
            self
        }
        /// Consumes the builder and constructs a [`LifeCycleLastTest`](crate::model::LifeCycleLastTest)
        pub fn build(self) -> crate::model::LifeCycleLastTest {
            crate::model::LifeCycleLastTest {
                initiated: self.initiated,
                reverted: self.reverted,
                finalized: self.finalized,
            }
        }
    }
}
impl LifeCycleLastTest {
    /// Creates a new builder-style object to manufacture [`LifeCycleLastTest`](crate::model::LifeCycleLastTest)
    pub fn builder() -> crate::model::life_cycle_last_test::Builder {
        crate::model::life_cycle_last_test::Builder::default()
    }
}

/// <p>Lifecycle last Test finalized.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LifeCycleLastTestFinalized {
    /// <p>Lifecycle Test failed API call date and time.</p>
    pub api_call_date_time: std::option::Option<std::string::String>,
}
impl LifeCycleLastTestFinalized {
    /// <p>Lifecycle Test failed API call date and time.</p>
    pub fn api_call_date_time(&self) -> std::option::Option<&str> {
        self.api_call_date_time.as_deref()
    }
}
impl std::fmt::Debug for LifeCycleLastTestFinalized {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LifeCycleLastTestFinalized");
        formatter.field("api_call_date_time", &self.api_call_date_time);
        formatter.finish()
    }
}
/// See [`LifeCycleLastTestFinalized`](crate::model::LifeCycleLastTestFinalized)
pub mod life_cycle_last_test_finalized {
    /// A builder for [`LifeCycleLastTestFinalized`](crate::model::LifeCycleLastTestFinalized)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_call_date_time: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Lifecycle Test failed API call date and time.</p>
        pub fn api_call_date_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_call_date_time = Some(input.into());
            self
        }
        /// <p>Lifecycle Test failed API call date and time.</p>
        pub fn set_api_call_date_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.api_call_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`LifeCycleLastTestFinalized`](crate::model::LifeCycleLastTestFinalized)
        pub fn build(self) -> crate::model::LifeCycleLastTestFinalized {
            crate::model::LifeCycleLastTestFinalized {
                api_call_date_time: self.api_call_date_time,
            }
        }
    }
}
impl LifeCycleLastTestFinalized {
    /// Creates a new builder-style object to manufacture [`LifeCycleLastTestFinalized`](crate::model::LifeCycleLastTestFinalized)
    pub fn builder() -> crate::model::life_cycle_last_test_finalized::Builder {
        crate::model::life_cycle_last_test_finalized::Builder::default()
    }
}

/// <p>Lifecycle last Test reverted.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LifeCycleLastTestReverted {
    /// <p>Lifecycle last Test reverted API call date and time.</p>
    pub api_call_date_time: std::option::Option<std::string::String>,
}
impl LifeCycleLastTestReverted {
    /// <p>Lifecycle last Test reverted API call date and time.</p>
    pub fn api_call_date_time(&self) -> std::option::Option<&str> {
        self.api_call_date_time.as_deref()
    }
}
impl std::fmt::Debug for LifeCycleLastTestReverted {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LifeCycleLastTestReverted");
        formatter.field("api_call_date_time", &self.api_call_date_time);
        formatter.finish()
    }
}
/// See [`LifeCycleLastTestReverted`](crate::model::LifeCycleLastTestReverted)
pub mod life_cycle_last_test_reverted {
    /// A builder for [`LifeCycleLastTestReverted`](crate::model::LifeCycleLastTestReverted)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_call_date_time: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Lifecycle last Test reverted API call date and time.</p>
        pub fn api_call_date_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_call_date_time = Some(input.into());
            self
        }
        /// <p>Lifecycle last Test reverted API call date and time.</p>
        pub fn set_api_call_date_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.api_call_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`LifeCycleLastTestReverted`](crate::model::LifeCycleLastTestReverted)
        pub fn build(self) -> crate::model::LifeCycleLastTestReverted {
            crate::model::LifeCycleLastTestReverted {
                api_call_date_time: self.api_call_date_time,
            }
        }
    }
}
impl LifeCycleLastTestReverted {
    /// Creates a new builder-style object to manufacture [`LifeCycleLastTestReverted`](crate::model::LifeCycleLastTestReverted)
    pub fn builder() -> crate::model::life_cycle_last_test_reverted::Builder {
        crate::model::life_cycle_last_test_reverted::Builder::default()
    }
}

/// <p>Lifecycle last Test initiated.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LifeCycleLastTestInitiated {
    /// <p>Lifecycle last Test initiated API call date and time.</p>
    pub api_call_date_time: std::option::Option<std::string::String>,
    /// <p>Lifecycle last Test initiated Job ID.</p>
    pub job_id: std::option::Option<std::string::String>,
}
impl LifeCycleLastTestInitiated {
    /// <p>Lifecycle last Test initiated API call date and time.</p>
    pub fn api_call_date_time(&self) -> std::option::Option<&str> {
        self.api_call_date_time.as_deref()
    }
    /// <p>Lifecycle last Test initiated Job ID.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
}
impl std::fmt::Debug for LifeCycleLastTestInitiated {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LifeCycleLastTestInitiated");
        formatter.field("api_call_date_time", &self.api_call_date_time);
        formatter.field("job_id", &self.job_id);
        formatter.finish()
    }
}
/// See [`LifeCycleLastTestInitiated`](crate::model::LifeCycleLastTestInitiated)
pub mod life_cycle_last_test_initiated {
    /// A builder for [`LifeCycleLastTestInitiated`](crate::model::LifeCycleLastTestInitiated)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_call_date_time: std::option::Option<std::string::String>,
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Lifecycle last Test initiated API call date and time.</p>
        pub fn api_call_date_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_call_date_time = Some(input.into());
            self
        }
        /// <p>Lifecycle last Test initiated API call date and time.</p>
        pub fn set_api_call_date_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.api_call_date_time = input;
            self
        }
        /// <p>Lifecycle last Test initiated Job ID.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>Lifecycle last Test initiated Job ID.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`LifeCycleLastTestInitiated`](crate::model::LifeCycleLastTestInitiated)
        pub fn build(self) -> crate::model::LifeCycleLastTestInitiated {
            crate::model::LifeCycleLastTestInitiated {
                api_call_date_time: self.api_call_date_time,
                job_id: self.job_id,
            }
        }
    }
}
impl LifeCycleLastTestInitiated {
    /// Creates a new builder-style object to manufacture [`LifeCycleLastTestInitiated`](crate::model::LifeCycleLastTestInitiated)
    pub fn builder() -> crate::model::life_cycle_last_test_initiated::Builder {
        crate::model::life_cycle_last_test_initiated::Builder::default()
    }
}

/// <p>Request data replication info.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataReplicationInfo {
    /// <p>Request to query data replication lag duration.</p>
    pub lag_duration: std::option::Option<std::string::String>,
    /// <p>Request to query the time when data replication will be complete.</p>
    pub eta_date_time: std::option::Option<std::string::String>,
    /// <p>Request to query disks replicated.</p>
    pub replicated_disks:
        std::option::Option<std::vec::Vec<crate::model::DataReplicationInfoReplicatedDisk>>,
    /// <p>Request to query the data replication state.</p>
    pub data_replication_state: std::option::Option<crate::model::DataReplicationState>,
    /// <p>Request to query whether data replication has been initiated.</p>
    pub data_replication_initiation: std::option::Option<crate::model::DataReplicationInitiation>,
    /// <p>Error in obtaining data replication info.</p>
    pub data_replication_error: std::option::Option<crate::model::DataReplicationError>,
    /// <p>Request to query data replication last snapshot time.</p>
    pub last_snapshot_date_time: std::option::Option<std::string::String>,
}
impl DataReplicationInfo {
    /// <p>Request to query data replication lag duration.</p>
    pub fn lag_duration(&self) -> std::option::Option<&str> {
        self.lag_duration.as_deref()
    }
    /// <p>Request to query the time when data replication will be complete.</p>
    pub fn eta_date_time(&self) -> std::option::Option<&str> {
        self.eta_date_time.as_deref()
    }
    /// <p>Request to query disks replicated.</p>
    pub fn replicated_disks(
        &self,
    ) -> std::option::Option<&[crate::model::DataReplicationInfoReplicatedDisk]> {
        self.replicated_disks.as_deref()
    }
    /// <p>Request to query the data replication state.</p>
    pub fn data_replication_state(
        &self,
    ) -> std::option::Option<&crate::model::DataReplicationState> {
        self.data_replication_state.as_ref()
    }
    /// <p>Request to query whether data replication has been initiated.</p>
    pub fn data_replication_initiation(
        &self,
    ) -> std::option::Option<&crate::model::DataReplicationInitiation> {
        self.data_replication_initiation.as_ref()
    }
    /// <p>Error in obtaining data replication info.</p>
    pub fn data_replication_error(
        &self,
    ) -> std::option::Option<&crate::model::DataReplicationError> {
        self.data_replication_error.as_ref()
    }
    /// <p>Request to query data replication last snapshot time.</p>
    pub fn last_snapshot_date_time(&self) -> std::option::Option<&str> {
        self.last_snapshot_date_time.as_deref()
    }
}
impl std::fmt::Debug for DataReplicationInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataReplicationInfo");
        formatter.field("lag_duration", &self.lag_duration);
        formatter.field("eta_date_time", &self.eta_date_time);
        formatter.field("replicated_disks", &self.replicated_disks);
        formatter.field("data_replication_state", &self.data_replication_state);
        formatter.field(
            "data_replication_initiation",
            &self.data_replication_initiation,
        );
        formatter.field("data_replication_error", &self.data_replication_error);
        formatter.field("last_snapshot_date_time", &self.last_snapshot_date_time);
        formatter.finish()
    }
}
/// See [`DataReplicationInfo`](crate::model::DataReplicationInfo)
pub mod data_replication_info {
    /// A builder for [`DataReplicationInfo`](crate::model::DataReplicationInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) lag_duration: std::option::Option<std::string::String>,
        pub(crate) eta_date_time: std::option::Option<std::string::String>,
        pub(crate) replicated_disks:
            std::option::Option<std::vec::Vec<crate::model::DataReplicationInfoReplicatedDisk>>,
        pub(crate) data_replication_state: std::option::Option<crate::model::DataReplicationState>,
        pub(crate) data_replication_initiation:
            std::option::Option<crate::model::DataReplicationInitiation>,
        pub(crate) data_replication_error: std::option::Option<crate::model::DataReplicationError>,
        pub(crate) last_snapshot_date_time: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Request to query data replication lag duration.</p>
        pub fn lag_duration(mut self, input: impl Into<std::string::String>) -> Self {
            self.lag_duration = Some(input.into());
            self
        }
        /// <p>Request to query data replication lag duration.</p>
        pub fn set_lag_duration(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lag_duration = input;
            self
        }
        /// <p>Request to query the time when data replication will be complete.</p>
        pub fn eta_date_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.eta_date_time = Some(input.into());
            self
        }
        /// <p>Request to query the time when data replication will be complete.</p>
        pub fn set_eta_date_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.eta_date_time = input;
            self
        }
        /// Appends an item to `replicated_disks`.
        ///
        /// To override the contents of this collection use [`set_replicated_disks`](Self::set_replicated_disks).
        ///
        /// <p>Request to query disks replicated.</p>
        pub fn replicated_disks(
            mut self,
            input: crate::model::DataReplicationInfoReplicatedDisk,
        ) -> Self {
            let mut v = self.replicated_disks.unwrap_or_default();
            v.push(input);
            self.replicated_disks = Some(v);
            self
        }
        /// <p>Request to query disks replicated.</p>
        pub fn set_replicated_disks(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::DataReplicationInfoReplicatedDisk>,
            >,
        ) -> Self {
            self.replicated_disks = input;
            self
        }
        /// <p>Request to query the data replication state.</p>
        pub fn data_replication_state(mut self, input: crate::model::DataReplicationState) -> Self {
            self.data_replication_state = Some(input);
            self
        }
        /// <p>Request to query the data replication state.</p>
        pub fn set_data_replication_state(
            mut self,
            input: std::option::Option<crate::model::DataReplicationState>,
        ) -> Self {
            self.data_replication_state = input;
            self
        }
        /// <p>Request to query whether data replication has been initiated.</p>
        pub fn data_replication_initiation(
            mut self,
            input: crate::model::DataReplicationInitiation,
        ) -> Self {
            self.data_replication_initiation = Some(input);
            self
        }
        /// <p>Request to query whether data replication has been initiated.</p>
        pub fn set_data_replication_initiation(
            mut self,
            input: std::option::Option<crate::model::DataReplicationInitiation>,
        ) -> Self {
            self.data_replication_initiation = input;
            self
        }
        /// <p>Error in obtaining data replication info.</p>
        pub fn data_replication_error(mut self, input: crate::model::DataReplicationError) -> Self {
            self.data_replication_error = Some(input);
            self
        }
        /// <p>Error in obtaining data replication info.</p>
        pub fn set_data_replication_error(
            mut self,
            input: std::option::Option<crate::model::DataReplicationError>,
        ) -> Self {
            self.data_replication_error = input;
            self
        }
        /// <p>Request to query data replication last snapshot time.</p>
        pub fn last_snapshot_date_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_snapshot_date_time = Some(input.into());
            self
        }
        /// <p>Request to query data replication last snapshot time.</p>
        pub fn set_last_snapshot_date_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_snapshot_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DataReplicationInfo`](crate::model::DataReplicationInfo)
        pub fn build(self) -> crate::model::DataReplicationInfo {
            crate::model::DataReplicationInfo {
                lag_duration: self.lag_duration,
                eta_date_time: self.eta_date_time,
                replicated_disks: self.replicated_disks,
                data_replication_state: self.data_replication_state,
                data_replication_initiation: self.data_replication_initiation,
                data_replication_error: self.data_replication_error,
                last_snapshot_date_time: self.last_snapshot_date_time,
            }
        }
    }
}
impl DataReplicationInfo {
    /// Creates a new builder-style object to manufacture [`DataReplicationInfo`](crate::model::DataReplicationInfo)
    pub fn builder() -> crate::model::data_replication_info::Builder {
        crate::model::data_replication_info::Builder::default()
    }
}

/// <p>Error in data replication.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataReplicationError {
    /// <p>Error in data replication.</p>
    pub error: std::option::Option<crate::model::DataReplicationErrorString>,
    /// <p>Error in data replication.</p>
    pub raw_error: std::option::Option<std::string::String>,
}
impl DataReplicationError {
    /// <p>Error in data replication.</p>
    pub fn error(&self) -> std::option::Option<&crate::model::DataReplicationErrorString> {
        self.error.as_ref()
    }
    /// <p>Error in data replication.</p>
    pub fn raw_error(&self) -> std::option::Option<&str> {
        self.raw_error.as_deref()
    }
}
impl std::fmt::Debug for DataReplicationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataReplicationError");
        formatter.field("error", &self.error);
        formatter.field("raw_error", &self.raw_error);
        formatter.finish()
    }
}
/// See [`DataReplicationError`](crate::model::DataReplicationError)
pub mod data_replication_error {
    /// A builder for [`DataReplicationError`](crate::model::DataReplicationError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error: std::option::Option<crate::model::DataReplicationErrorString>,
        pub(crate) raw_error: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error in data replication.</p>
        pub fn error(mut self, input: crate::model::DataReplicationErrorString) -> Self {
            self.error = Some(input);
            self
        }
        /// <p>Error in data replication.</p>
        pub fn set_error(
            mut self,
            input: std::option::Option<crate::model::DataReplicationErrorString>,
        ) -> Self {
            self.error = input;
            self
        }
        /// <p>Error in data replication.</p>
        pub fn raw_error(mut self, input: impl Into<std::string::String>) -> Self {
            self.raw_error = Some(input.into());
            self
        }
        /// <p>Error in data replication.</p>
        pub fn set_raw_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.raw_error = input;
            self
        }
        /// Consumes the builder and constructs a [`DataReplicationError`](crate::model::DataReplicationError)
        pub fn build(self) -> crate::model::DataReplicationError {
            crate::model::DataReplicationError {
                error: self.error,
                raw_error: self.raw_error,
            }
        }
    }
}
impl DataReplicationError {
    /// Creates a new builder-style object to manufacture [`DataReplicationError`](crate::model::DataReplicationError)
    pub fn builder() -> crate::model::data_replication_error::Builder {
        crate::model::data_replication_error::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DataReplicationErrorString {
    #[allow(missing_docs)] // documentation missing in model
    AgentNotSeen,
    #[allow(missing_docs)] // documentation missing in model
    FailedToAttachStagingDisks,
    #[allow(missing_docs)] // documentation missing in model
    FailedToAuthenticateWithService,
    #[allow(missing_docs)] // documentation missing in model
    FailedToBootReplicationServer,
    #[allow(missing_docs)] // documentation missing in model
    FailedToConnectAgentToReplicationServer,
    #[allow(missing_docs)] // documentation missing in model
    FailedToCreateSecurityGroup,
    #[allow(missing_docs)] // documentation missing in model
    FailedToCreateStagingDisks,
    #[allow(missing_docs)] // documentation missing in model
    FailedToDownloadReplicationSoftware,
    #[allow(missing_docs)] // documentation missing in model
    FailedToLaunchReplicationServer,
    #[allow(missing_docs)] // documentation missing in model
    FailedToPairReplicationServerWithAgent,
    #[allow(missing_docs)] // documentation missing in model
    FailedToStartDataTransfer,
    #[allow(missing_docs)] // documentation missing in model
    LastSnapshotJobFailed,
    #[allow(missing_docs)] // documentation missing in model
    NotConverging,
    #[allow(missing_docs)] // documentation missing in model
    SnapshotsFailure,
    #[allow(missing_docs)] // documentation missing in model
    UnstableNetwork,
    #[allow(missing_docs)] // documentation missing in model
    UnsupportedVmConfiguration,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DataReplicationErrorString {
    fn from(s: &str) -> Self {
        match s {
            "AGENT_NOT_SEEN" => DataReplicationErrorString::AgentNotSeen,
            "FAILED_TO_ATTACH_STAGING_DISKS" => {
                DataReplicationErrorString::FailedToAttachStagingDisks
            }
            "FAILED_TO_AUTHENTICATE_WITH_SERVICE" => {
                DataReplicationErrorString::FailedToAuthenticateWithService
            }
            "FAILED_TO_BOOT_REPLICATION_SERVER" => {
                DataReplicationErrorString::FailedToBootReplicationServer
            }
            "FAILED_TO_CONNECT_AGENT_TO_REPLICATION_SERVER" => {
                DataReplicationErrorString::FailedToConnectAgentToReplicationServer
            }
            "FAILED_TO_CREATE_SECURITY_GROUP" => {
                DataReplicationErrorString::FailedToCreateSecurityGroup
            }
            "FAILED_TO_CREATE_STAGING_DISKS" => {
                DataReplicationErrorString::FailedToCreateStagingDisks
            }
            "FAILED_TO_DOWNLOAD_REPLICATION_SOFTWARE" => {
                DataReplicationErrorString::FailedToDownloadReplicationSoftware
            }
            "FAILED_TO_LAUNCH_REPLICATION_SERVER" => {
                DataReplicationErrorString::FailedToLaunchReplicationServer
            }
            "FAILED_TO_PAIR_REPLICATION_SERVER_WITH_AGENT" => {
                DataReplicationErrorString::FailedToPairReplicationServerWithAgent
            }
            "FAILED_TO_START_DATA_TRANSFER" => {
                DataReplicationErrorString::FailedToStartDataTransfer
            }
            "LAST_SNAPSHOT_JOB_FAILED" => DataReplicationErrorString::LastSnapshotJobFailed,
            "NOT_CONVERGING" => DataReplicationErrorString::NotConverging,
            "SNAPSHOTS_FAILURE" => DataReplicationErrorString::SnapshotsFailure,
            "UNSTABLE_NETWORK" => DataReplicationErrorString::UnstableNetwork,
            "UNSUPPORTED_VM_CONFIGURATION" => {
                DataReplicationErrorString::UnsupportedVmConfiguration
            }
            other => DataReplicationErrorString::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DataReplicationErrorString {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DataReplicationErrorString::from(s))
    }
}
impl DataReplicationErrorString {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DataReplicationErrorString::AgentNotSeen => "AGENT_NOT_SEEN",
            DataReplicationErrorString::FailedToAttachStagingDisks => {
                "FAILED_TO_ATTACH_STAGING_DISKS"
            }
            DataReplicationErrorString::FailedToAuthenticateWithService => {
                "FAILED_TO_AUTHENTICATE_WITH_SERVICE"
            }
            DataReplicationErrorString::FailedToBootReplicationServer => {
                "FAILED_TO_BOOT_REPLICATION_SERVER"
            }
            DataReplicationErrorString::FailedToConnectAgentToReplicationServer => {
                "FAILED_TO_CONNECT_AGENT_TO_REPLICATION_SERVER"
            }
            DataReplicationErrorString::FailedToCreateSecurityGroup => {
                "FAILED_TO_CREATE_SECURITY_GROUP"
            }
            DataReplicationErrorString::FailedToCreateStagingDisks => {
                "FAILED_TO_CREATE_STAGING_DISKS"
            }
            DataReplicationErrorString::FailedToDownloadReplicationSoftware => {
                "FAILED_TO_DOWNLOAD_REPLICATION_SOFTWARE"
            }
            DataReplicationErrorString::FailedToLaunchReplicationServer => {
                "FAILED_TO_LAUNCH_REPLICATION_SERVER"
            }
            DataReplicationErrorString::FailedToPairReplicationServerWithAgent => {
                "FAILED_TO_PAIR_REPLICATION_SERVER_WITH_AGENT"
            }
            DataReplicationErrorString::FailedToStartDataTransfer => {
                "FAILED_TO_START_DATA_TRANSFER"
            }
            DataReplicationErrorString::LastSnapshotJobFailed => "LAST_SNAPSHOT_JOB_FAILED",
            DataReplicationErrorString::NotConverging => "NOT_CONVERGING",
            DataReplicationErrorString::SnapshotsFailure => "SNAPSHOTS_FAILURE",
            DataReplicationErrorString::UnstableNetwork => "UNSTABLE_NETWORK",
            DataReplicationErrorString::UnsupportedVmConfiguration => {
                "UNSUPPORTED_VM_CONFIGURATION"
            }
            DataReplicationErrorString::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AGENT_NOT_SEEN",
            "FAILED_TO_ATTACH_STAGING_DISKS",
            "FAILED_TO_AUTHENTICATE_WITH_SERVICE",
            "FAILED_TO_BOOT_REPLICATION_SERVER",
            "FAILED_TO_CONNECT_AGENT_TO_REPLICATION_SERVER",
            "FAILED_TO_CREATE_SECURITY_GROUP",
            "FAILED_TO_CREATE_STAGING_DISKS",
            "FAILED_TO_DOWNLOAD_REPLICATION_SOFTWARE",
            "FAILED_TO_LAUNCH_REPLICATION_SERVER",
            "FAILED_TO_PAIR_REPLICATION_SERVER_WITH_AGENT",
            "FAILED_TO_START_DATA_TRANSFER",
            "LAST_SNAPSHOT_JOB_FAILED",
            "NOT_CONVERGING",
            "SNAPSHOTS_FAILURE",
            "UNSTABLE_NETWORK",
            "UNSUPPORTED_VM_CONFIGURATION",
        ]
    }
}
impl AsRef<str> for DataReplicationErrorString {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Data replication initiation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataReplicationInitiation {
    /// <p>Request to query data initiation start date and time.</p>
    pub start_date_time: std::option::Option<std::string::String>,
    /// <p>Request to query next data initiation date and time.</p>
    pub next_attempt_date_time: std::option::Option<std::string::String>,
    /// <p>Request to query data initiation steps.</p>
    pub steps: std::option::Option<std::vec::Vec<crate::model::DataReplicationInitiationStep>>,
}
impl DataReplicationInitiation {
    /// <p>Request to query data initiation start date and time.</p>
    pub fn start_date_time(&self) -> std::option::Option<&str> {
        self.start_date_time.as_deref()
    }
    /// <p>Request to query next data initiation date and time.</p>
    pub fn next_attempt_date_time(&self) -> std::option::Option<&str> {
        self.next_attempt_date_time.as_deref()
    }
    /// <p>Request to query data initiation steps.</p>
    pub fn steps(&self) -> std::option::Option<&[crate::model::DataReplicationInitiationStep]> {
        self.steps.as_deref()
    }
}
impl std::fmt::Debug for DataReplicationInitiation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataReplicationInitiation");
        formatter.field("start_date_time", &self.start_date_time);
        formatter.field("next_attempt_date_time", &self.next_attempt_date_time);
        formatter.field("steps", &self.steps);
        formatter.finish()
    }
}
/// See [`DataReplicationInitiation`](crate::model::DataReplicationInitiation)
pub mod data_replication_initiation {
    /// A builder for [`DataReplicationInitiation`](crate::model::DataReplicationInitiation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start_date_time: std::option::Option<std::string::String>,
        pub(crate) next_attempt_date_time: std::option::Option<std::string::String>,
        pub(crate) steps:
            std::option::Option<std::vec::Vec<crate::model::DataReplicationInitiationStep>>,
    }
    impl Builder {
        /// <p>Request to query data initiation start date and time.</p>
        pub fn start_date_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.start_date_time = Some(input.into());
            self
        }
        /// <p>Request to query data initiation start date and time.</p>
        pub fn set_start_date_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.start_date_time = input;
            self
        }
        /// <p>Request to query next data initiation date and time.</p>
        pub fn next_attempt_date_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_attempt_date_time = Some(input.into());
            self
        }
        /// <p>Request to query next data initiation date and time.</p>
        pub fn set_next_attempt_date_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_attempt_date_time = input;
            self
        }
        /// Appends an item to `steps`.
        ///
        /// To override the contents of this collection use [`set_steps`](Self::set_steps).
        ///
        /// <p>Request to query data initiation steps.</p>
        pub fn steps(mut self, input: crate::model::DataReplicationInitiationStep) -> Self {
            let mut v = self.steps.unwrap_or_default();
            v.push(input);
            self.steps = Some(v);
            self
        }
        /// <p>Request to query data initiation steps.</p>
        pub fn set_steps(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataReplicationInitiationStep>>,
        ) -> Self {
            self.steps = input;
            self
        }
        /// Consumes the builder and constructs a [`DataReplicationInitiation`](crate::model::DataReplicationInitiation)
        pub fn build(self) -> crate::model::DataReplicationInitiation {
            crate::model::DataReplicationInitiation {
                start_date_time: self.start_date_time,
                next_attempt_date_time: self.next_attempt_date_time,
                steps: self.steps,
            }
        }
    }
}
impl DataReplicationInitiation {
    /// Creates a new builder-style object to manufacture [`DataReplicationInitiation`](crate::model::DataReplicationInitiation)
    pub fn builder() -> crate::model::data_replication_initiation::Builder {
        crate::model::data_replication_initiation::Builder::default()
    }
}

/// <p>Data replication initiation step.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataReplicationInitiationStep {
    /// <p>Request to query data initiation step name.</p>
    pub name: std::option::Option<crate::model::DataReplicationInitiationStepName>,
    /// <p>Request to query data initiation status.</p>
    pub status: std::option::Option<crate::model::DataReplicationInitiationStepStatus>,
}
impl DataReplicationInitiationStep {
    /// <p>Request to query data initiation step name.</p>
    pub fn name(&self) -> std::option::Option<&crate::model::DataReplicationInitiationStepName> {
        self.name.as_ref()
    }
    /// <p>Request to query data initiation status.</p>
    pub fn status(
        &self,
    ) -> std::option::Option<&crate::model::DataReplicationInitiationStepStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for DataReplicationInitiationStep {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataReplicationInitiationStep");
        formatter.field("name", &self.name);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`DataReplicationInitiationStep`](crate::model::DataReplicationInitiationStep)
pub mod data_replication_initiation_step {
    /// A builder for [`DataReplicationInitiationStep`](crate::model::DataReplicationInitiationStep)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::DataReplicationInitiationStepName>,
        pub(crate) status: std::option::Option<crate::model::DataReplicationInitiationStepStatus>,
    }
    impl Builder {
        /// <p>Request to query data initiation step name.</p>
        pub fn name(mut self, input: crate::model::DataReplicationInitiationStepName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>Request to query data initiation step name.</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::DataReplicationInitiationStepName>,
        ) -> Self {
            self.name = input;
            self
        }
        /// <p>Request to query data initiation status.</p>
        pub fn status(mut self, input: crate::model::DataReplicationInitiationStepStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Request to query data initiation status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DataReplicationInitiationStepStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`DataReplicationInitiationStep`](crate::model::DataReplicationInitiationStep)
        pub fn build(self) -> crate::model::DataReplicationInitiationStep {
            crate::model::DataReplicationInitiationStep {
                name: self.name,
                status: self.status,
            }
        }
    }
}
impl DataReplicationInitiationStep {
    /// Creates a new builder-style object to manufacture [`DataReplicationInitiationStep`](crate::model::DataReplicationInitiationStep)
    pub fn builder() -> crate::model::data_replication_initiation_step::Builder {
        crate::model::data_replication_initiation_step::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DataReplicationInitiationStepStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    NotStarted,
    #[allow(missing_docs)] // documentation missing in model
    Skipped,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DataReplicationInitiationStepStatus {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => DataReplicationInitiationStepStatus::Failed,
            "IN_PROGRESS" => DataReplicationInitiationStepStatus::InProgress,
            "NOT_STARTED" => DataReplicationInitiationStepStatus::NotStarted,
            "SKIPPED" => DataReplicationInitiationStepStatus::Skipped,
            "SUCCEEDED" => DataReplicationInitiationStepStatus::Succeeded,
            other => DataReplicationInitiationStepStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DataReplicationInitiationStepStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DataReplicationInitiationStepStatus::from(s))
    }
}
impl DataReplicationInitiationStepStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DataReplicationInitiationStepStatus::Failed => "FAILED",
            DataReplicationInitiationStepStatus::InProgress => "IN_PROGRESS",
            DataReplicationInitiationStepStatus::NotStarted => "NOT_STARTED",
            DataReplicationInitiationStepStatus::Skipped => "SKIPPED",
            DataReplicationInitiationStepStatus::Succeeded => "SUCCEEDED",
            DataReplicationInitiationStepStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "FAILED",
            "IN_PROGRESS",
            "NOT_STARTED",
            "SKIPPED",
            "SUCCEEDED",
        ]
    }
}
impl AsRef<str> for DataReplicationInitiationStepStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DataReplicationInitiationStepName {
    #[allow(missing_docs)] // documentation missing in model
    AttachStagingDisks,
    #[allow(missing_docs)] // documentation missing in model
    AuthenticateWithService,
    #[allow(missing_docs)] // documentation missing in model
    BootReplicationServer,
    #[allow(missing_docs)] // documentation missing in model
    ConnectAgentToReplicationServer,
    #[allow(missing_docs)] // documentation missing in model
    CreateSecurityGroup,
    #[allow(missing_docs)] // documentation missing in model
    CreateStagingDisks,
    #[allow(missing_docs)] // documentation missing in model
    DownloadReplicationSoftware,
    #[allow(missing_docs)] // documentation missing in model
    LaunchReplicationServer,
    #[allow(missing_docs)] // documentation missing in model
    PairReplicationServerWithAgent,
    #[allow(missing_docs)] // documentation missing in model
    StartDataTransfer,
    #[allow(missing_docs)] // documentation missing in model
    Wait,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DataReplicationInitiationStepName {
    fn from(s: &str) -> Self {
        match s {
            "ATTACH_STAGING_DISKS" => DataReplicationInitiationStepName::AttachStagingDisks,
            "AUTHENTICATE_WITH_SERVICE" => {
                DataReplicationInitiationStepName::AuthenticateWithService
            }
            "BOOT_REPLICATION_SERVER" => DataReplicationInitiationStepName::BootReplicationServer,
            "CONNECT_AGENT_TO_REPLICATION_SERVER" => {
                DataReplicationInitiationStepName::ConnectAgentToReplicationServer
            }
            "CREATE_SECURITY_GROUP" => DataReplicationInitiationStepName::CreateSecurityGroup,
            "CREATE_STAGING_DISKS" => DataReplicationInitiationStepName::CreateStagingDisks,
            "DOWNLOAD_REPLICATION_SOFTWARE" => {
                DataReplicationInitiationStepName::DownloadReplicationSoftware
            }
            "LAUNCH_REPLICATION_SERVER" => {
                DataReplicationInitiationStepName::LaunchReplicationServer
            }
            "PAIR_REPLICATION_SERVER_WITH_AGENT" => {
                DataReplicationInitiationStepName::PairReplicationServerWithAgent
            }
            "START_DATA_TRANSFER" => DataReplicationInitiationStepName::StartDataTransfer,
            "WAIT" => DataReplicationInitiationStepName::Wait,
            other => DataReplicationInitiationStepName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DataReplicationInitiationStepName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DataReplicationInitiationStepName::from(s))
    }
}
impl DataReplicationInitiationStepName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DataReplicationInitiationStepName::AttachStagingDisks => "ATTACH_STAGING_DISKS",
            DataReplicationInitiationStepName::AuthenticateWithService => {
                "AUTHENTICATE_WITH_SERVICE"
            }
            DataReplicationInitiationStepName::BootReplicationServer => "BOOT_REPLICATION_SERVER",
            DataReplicationInitiationStepName::ConnectAgentToReplicationServer => {
                "CONNECT_AGENT_TO_REPLICATION_SERVER"
            }
            DataReplicationInitiationStepName::CreateSecurityGroup => "CREATE_SECURITY_GROUP",
            DataReplicationInitiationStepName::CreateStagingDisks => "CREATE_STAGING_DISKS",
            DataReplicationInitiationStepName::DownloadReplicationSoftware => {
                "DOWNLOAD_REPLICATION_SOFTWARE"
            }
            DataReplicationInitiationStepName::LaunchReplicationServer => {
                "LAUNCH_REPLICATION_SERVER"
            }
            DataReplicationInitiationStepName::PairReplicationServerWithAgent => {
                "PAIR_REPLICATION_SERVER_WITH_AGENT"
            }
            DataReplicationInitiationStepName::StartDataTransfer => "START_DATA_TRANSFER",
            DataReplicationInitiationStepName::Wait => "WAIT",
            DataReplicationInitiationStepName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ATTACH_STAGING_DISKS",
            "AUTHENTICATE_WITH_SERVICE",
            "BOOT_REPLICATION_SERVER",
            "CONNECT_AGENT_TO_REPLICATION_SERVER",
            "CREATE_SECURITY_GROUP",
            "CREATE_STAGING_DISKS",
            "DOWNLOAD_REPLICATION_SOFTWARE",
            "LAUNCH_REPLICATION_SERVER",
            "PAIR_REPLICATION_SERVER_WITH_AGENT",
            "START_DATA_TRANSFER",
            "WAIT",
        ]
    }
}
impl AsRef<str> for DataReplicationInitiationStepName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DataReplicationState {
    #[allow(missing_docs)] // documentation missing in model
    Backlog,
    #[allow(missing_docs)] // documentation missing in model
    Continuous,
    #[allow(missing_docs)] // documentation missing in model
    CreatingSnapshot,
    #[allow(missing_docs)] // documentation missing in model
    Disconnected,
    #[allow(missing_docs)] // documentation missing in model
    InitialSync,
    #[allow(missing_docs)] // documentation missing in model
    Initiating,
    #[allow(missing_docs)] // documentation missing in model
    Paused,
    #[allow(missing_docs)] // documentation missing in model
    PendingSnapshotShipping,
    #[allow(missing_docs)] // documentation missing in model
    Rescan,
    #[allow(missing_docs)] // documentation missing in model
    ShippingSnapshot,
    #[allow(missing_docs)] // documentation missing in model
    Stalled,
    #[allow(missing_docs)] // documentation missing in model
    Stopped,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DataReplicationState {
    fn from(s: &str) -> Self {
        match s {
            "BACKLOG" => DataReplicationState::Backlog,
            "CONTINUOUS" => DataReplicationState::Continuous,
            "CREATING_SNAPSHOT" => DataReplicationState::CreatingSnapshot,
            "DISCONNECTED" => DataReplicationState::Disconnected,
            "INITIAL_SYNC" => DataReplicationState::InitialSync,
            "INITIATING" => DataReplicationState::Initiating,
            "PAUSED" => DataReplicationState::Paused,
            "PENDING_SNAPSHOT_SHIPPING" => DataReplicationState::PendingSnapshotShipping,
            "RESCAN" => DataReplicationState::Rescan,
            "SHIPPING_SNAPSHOT" => DataReplicationState::ShippingSnapshot,
            "STALLED" => DataReplicationState::Stalled,
            "STOPPED" => DataReplicationState::Stopped,
            other => DataReplicationState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DataReplicationState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DataReplicationState::from(s))
    }
}
impl DataReplicationState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DataReplicationState::Backlog => "BACKLOG",
            DataReplicationState::Continuous => "CONTINUOUS",
            DataReplicationState::CreatingSnapshot => "CREATING_SNAPSHOT",
            DataReplicationState::Disconnected => "DISCONNECTED",
            DataReplicationState::InitialSync => "INITIAL_SYNC",
            DataReplicationState::Initiating => "INITIATING",
            DataReplicationState::Paused => "PAUSED",
            DataReplicationState::PendingSnapshotShipping => "PENDING_SNAPSHOT_SHIPPING",
            DataReplicationState::Rescan => "RESCAN",
            DataReplicationState::ShippingSnapshot => "SHIPPING_SNAPSHOT",
            DataReplicationState::Stalled => "STALLED",
            DataReplicationState::Stopped => "STOPPED",
            DataReplicationState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BACKLOG",
            "CONTINUOUS",
            "CREATING_SNAPSHOT",
            "DISCONNECTED",
            "INITIAL_SYNC",
            "INITIATING",
            "PAUSED",
            "PENDING_SNAPSHOT_SHIPPING",
            "RESCAN",
            "SHIPPING_SNAPSHOT",
            "STALLED",
            "STOPPED",
        ]
    }
}
impl AsRef<str> for DataReplicationState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Request to query disks replicated.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataReplicationInfoReplicatedDisk {
    /// <p>Request to query device name.</p>
    pub device_name: std::option::Option<std::string::String>,
    /// <p>Request to query total amount of data replicated in bytes.</p>
    pub total_storage_bytes: i64,
    /// <p>Request to query amount of data replicated in bytes.</p>
    pub replicated_storage_bytes: i64,
    /// <p>Request to query amount of data rescanned in bytes.</p>
    pub rescanned_storage_bytes: i64,
    /// <p>Request to query data replication backlog size in bytes.</p>
    pub backlogged_storage_bytes: i64,
}
impl DataReplicationInfoReplicatedDisk {
    /// <p>Request to query device name.</p>
    pub fn device_name(&self) -> std::option::Option<&str> {
        self.device_name.as_deref()
    }
    /// <p>Request to query total amount of data replicated in bytes.</p>
    pub fn total_storage_bytes(&self) -> i64 {
        self.total_storage_bytes
    }
    /// <p>Request to query amount of data replicated in bytes.</p>
    pub fn replicated_storage_bytes(&self) -> i64 {
        self.replicated_storage_bytes
    }
    /// <p>Request to query amount of data rescanned in bytes.</p>
    pub fn rescanned_storage_bytes(&self) -> i64 {
        self.rescanned_storage_bytes
    }
    /// <p>Request to query data replication backlog size in bytes.</p>
    pub fn backlogged_storage_bytes(&self) -> i64 {
        self.backlogged_storage_bytes
    }
}
impl std::fmt::Debug for DataReplicationInfoReplicatedDisk {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataReplicationInfoReplicatedDisk");
        formatter.field("device_name", &self.device_name);
        formatter.field("total_storage_bytes", &self.total_storage_bytes);
        formatter.field("replicated_storage_bytes", &self.replicated_storage_bytes);
        formatter.field("rescanned_storage_bytes", &self.rescanned_storage_bytes);
        formatter.field("backlogged_storage_bytes", &self.backlogged_storage_bytes);
        formatter.finish()
    }
}
/// See [`DataReplicationInfoReplicatedDisk`](crate::model::DataReplicationInfoReplicatedDisk)
pub mod data_replication_info_replicated_disk {
    /// A builder for [`DataReplicationInfoReplicatedDisk`](crate::model::DataReplicationInfoReplicatedDisk)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_name: std::option::Option<std::string::String>,
        pub(crate) total_storage_bytes: std::option::Option<i64>,
        pub(crate) replicated_storage_bytes: std::option::Option<i64>,
        pub(crate) rescanned_storage_bytes: std::option::Option<i64>,
        pub(crate) backlogged_storage_bytes: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>Request to query device name.</p>
        pub fn device_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_name = Some(input.into());
            self
        }
        /// <p>Request to query device name.</p>
        pub fn set_device_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_name = input;
            self
        }
        /// <p>Request to query total amount of data replicated in bytes.</p>
        pub fn total_storage_bytes(mut self, input: i64) -> Self {
            self.total_storage_bytes = Some(input);
            self
        }
        /// <p>Request to query total amount of data replicated in bytes.</p>
        pub fn set_total_storage_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.total_storage_bytes = input;
            self
        }
        /// <p>Request to query amount of data replicated in bytes.</p>
        pub fn replicated_storage_bytes(mut self, input: i64) -> Self {
            self.replicated_storage_bytes = Some(input);
            self
        }
        /// <p>Request to query amount of data replicated in bytes.</p>
        pub fn set_replicated_storage_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.replicated_storage_bytes = input;
            self
        }
        /// <p>Request to query amount of data rescanned in bytes.</p>
        pub fn rescanned_storage_bytes(mut self, input: i64) -> Self {
            self.rescanned_storage_bytes = Some(input);
            self
        }
        /// <p>Request to query amount of data rescanned in bytes.</p>
        pub fn set_rescanned_storage_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.rescanned_storage_bytes = input;
            self
        }
        /// <p>Request to query data replication backlog size in bytes.</p>
        pub fn backlogged_storage_bytes(mut self, input: i64) -> Self {
            self.backlogged_storage_bytes = Some(input);
            self
        }
        /// <p>Request to query data replication backlog size in bytes.</p>
        pub fn set_backlogged_storage_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.backlogged_storage_bytes = input;
            self
        }
        /// Consumes the builder and constructs a [`DataReplicationInfoReplicatedDisk`](crate::model::DataReplicationInfoReplicatedDisk)
        pub fn build(self) -> crate::model::DataReplicationInfoReplicatedDisk {
            crate::model::DataReplicationInfoReplicatedDisk {
                device_name: self.device_name,
                total_storage_bytes: self.total_storage_bytes.unwrap_or_default(),
                replicated_storage_bytes: self.replicated_storage_bytes.unwrap_or_default(),
                rescanned_storage_bytes: self.rescanned_storage_bytes.unwrap_or_default(),
                backlogged_storage_bytes: self.backlogged_storage_bytes.unwrap_or_default(),
            }
        }
    }
}
impl DataReplicationInfoReplicatedDisk {
    /// Creates a new builder-style object to manufacture [`DataReplicationInfoReplicatedDisk`](crate::model::DataReplicationInfoReplicatedDisk)
    pub fn builder() -> crate::model::data_replication_info_replicated_disk::Builder {
        crate::model::data_replication_info_replicated_disk::Builder::default()
    }
}

/// <p>Launched instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LaunchedInstance {
    /// <p>Launched instance EC2 ID.</p>
    pub ec2_instance_id: std::option::Option<std::string::String>,
    /// <p>Launched instance Job ID.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>Launched instance first boot.</p>
    pub first_boot: std::option::Option<crate::model::FirstBoot>,
}
impl LaunchedInstance {
    /// <p>Launched instance EC2 ID.</p>
    pub fn ec2_instance_id(&self) -> std::option::Option<&str> {
        self.ec2_instance_id.as_deref()
    }
    /// <p>Launched instance Job ID.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>Launched instance first boot.</p>
    pub fn first_boot(&self) -> std::option::Option<&crate::model::FirstBoot> {
        self.first_boot.as_ref()
    }
}
impl std::fmt::Debug for LaunchedInstance {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LaunchedInstance");
        formatter.field("ec2_instance_id", &self.ec2_instance_id);
        formatter.field("job_id", &self.job_id);
        formatter.field("first_boot", &self.first_boot);
        formatter.finish()
    }
}
/// See [`LaunchedInstance`](crate::model::LaunchedInstance)
pub mod launched_instance {
    /// A builder for [`LaunchedInstance`](crate::model::LaunchedInstance)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ec2_instance_id: std::option::Option<std::string::String>,
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) first_boot: std::option::Option<crate::model::FirstBoot>,
    }
    impl Builder {
        /// <p>Launched instance EC2 ID.</p>
        pub fn ec2_instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ec2_instance_id = Some(input.into());
            self
        }
        /// <p>Launched instance EC2 ID.</p>
        pub fn set_ec2_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ec2_instance_id = input;
            self
        }
        /// <p>Launched instance Job ID.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>Launched instance Job ID.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>Launched instance first boot.</p>
        pub fn first_boot(mut self, input: crate::model::FirstBoot) -> Self {
            self.first_boot = Some(input);
            self
        }
        /// <p>Launched instance first boot.</p>
        pub fn set_first_boot(
            mut self,
            input: std::option::Option<crate::model::FirstBoot>,
        ) -> Self {
            self.first_boot = input;
            self
        }
        /// Consumes the builder and constructs a [`LaunchedInstance`](crate::model::LaunchedInstance)
        pub fn build(self) -> crate::model::LaunchedInstance {
            crate::model::LaunchedInstance {
                ec2_instance_id: self.ec2_instance_id,
                job_id: self.job_id,
                first_boot: self.first_boot,
            }
        }
    }
}
impl LaunchedInstance {
    /// Creates a new builder-style object to manufacture [`LaunchedInstance`](crate::model::LaunchedInstance)
    pub fn builder() -> crate::model::launched_instance::Builder {
        crate::model::launched_instance::Builder::default()
    }
}

/// _Note: `FirstBoot::Unknown` has been renamed to `::UnknownValue`._
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FirstBoot {
    #[allow(missing_docs)] // documentation missing in model
    Stopped,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// _Note: `::Unknown` has been renamed to `::UnknownValue`._
    UnknownValue,
    #[allow(missing_docs)] // documentation missing in model
    Waiting,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FirstBoot {
    fn from(s: &str) -> Self {
        match s {
            "STOPPED" => FirstBoot::Stopped,
            "SUCCEEDED" => FirstBoot::Succeeded,
            "UNKNOWN" => FirstBoot::UnknownValue,
            "WAITING" => FirstBoot::Waiting,
            other => FirstBoot::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FirstBoot {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FirstBoot::from(s))
    }
}
impl FirstBoot {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FirstBoot::Stopped => "STOPPED",
            FirstBoot::Succeeded => "SUCCEEDED",
            FirstBoot::UnknownValue => "UNKNOWN",
            FirstBoot::Waiting => "WAITING",
            FirstBoot::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["STOPPED", "SUCCEEDED", "UNKNOWN", "WAITING"]
    }
}
impl AsRef<str> for FirstBoot {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReplicationConfigurationDataPlaneRouting {
    #[allow(missing_docs)] // documentation missing in model
    PrivateIp,
    #[allow(missing_docs)] // documentation missing in model
    PublicIp,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReplicationConfigurationDataPlaneRouting {
    fn from(s: &str) -> Self {
        match s {
            "PRIVATE_IP" => ReplicationConfigurationDataPlaneRouting::PrivateIp,
            "PUBLIC_IP" => ReplicationConfigurationDataPlaneRouting::PublicIp,
            other => ReplicationConfigurationDataPlaneRouting::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReplicationConfigurationDataPlaneRouting {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReplicationConfigurationDataPlaneRouting::from(s))
    }
}
impl ReplicationConfigurationDataPlaneRouting {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReplicationConfigurationDataPlaneRouting::PrivateIp => "PRIVATE_IP",
            ReplicationConfigurationDataPlaneRouting::PublicIp => "PUBLIC_IP",
            ReplicationConfigurationDataPlaneRouting::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PRIVATE_IP", "PUBLIC_IP"]
    }
}
impl AsRef<str> for ReplicationConfigurationDataPlaneRouting {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReplicationConfigurationEbsEncryption {
    #[allow(missing_docs)] // documentation missing in model
    Custom,
    #[allow(missing_docs)] // documentation missing in model
    Default,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReplicationConfigurationEbsEncryption {
    fn from(s: &str) -> Self {
        match s {
            "CUSTOM" => ReplicationConfigurationEbsEncryption::Custom,
            "DEFAULT" => ReplicationConfigurationEbsEncryption::Default,
            other => ReplicationConfigurationEbsEncryption::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReplicationConfigurationEbsEncryption {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReplicationConfigurationEbsEncryption::from(s))
    }
}
impl ReplicationConfigurationEbsEncryption {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReplicationConfigurationEbsEncryption::Custom => "CUSTOM",
            ReplicationConfigurationEbsEncryption::Default => "DEFAULT",
            ReplicationConfigurationEbsEncryption::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CUSTOM", "DEFAULT"]
    }
}
impl AsRef<str> for ReplicationConfigurationEbsEncryption {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Replication Configuration replicated disk.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReplicationConfigurationReplicatedDisk {
    /// <p>Replication Configuration replicated disk device name.</p>
    pub device_name: std::option::Option<std::string::String>,
    /// <p>Replication Configuration replicated disk boot disk.</p>
    pub is_boot_disk: std::option::Option<bool>,
    /// <p>Replication Configuration replicated disk staging disk type.</p>
    pub staging_disk_type:
        std::option::Option<crate::model::ReplicationConfigurationReplicatedDiskStagingDiskType>,
    /// <p>Replication Configuration replicated disk IOPs.</p>
    pub iops: i64,
    /// <p>Replication Configuration replicated disk throughput.</p>
    pub throughput: i64,
}
impl ReplicationConfigurationReplicatedDisk {
    /// <p>Replication Configuration replicated disk device name.</p>
    pub fn device_name(&self) -> std::option::Option<&str> {
        self.device_name.as_deref()
    }
    /// <p>Replication Configuration replicated disk boot disk.</p>
    pub fn is_boot_disk(&self) -> std::option::Option<bool> {
        self.is_boot_disk
    }
    /// <p>Replication Configuration replicated disk staging disk type.</p>
    pub fn staging_disk_type(
        &self,
    ) -> std::option::Option<&crate::model::ReplicationConfigurationReplicatedDiskStagingDiskType>
    {
        self.staging_disk_type.as_ref()
    }
    /// <p>Replication Configuration replicated disk IOPs.</p>
    pub fn iops(&self) -> i64 {
        self.iops
    }
    /// <p>Replication Configuration replicated disk throughput.</p>
    pub fn throughput(&self) -> i64 {
        self.throughput
    }
}
impl std::fmt::Debug for ReplicationConfigurationReplicatedDisk {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReplicationConfigurationReplicatedDisk");
        formatter.field("device_name", &self.device_name);
        formatter.field("is_boot_disk", &self.is_boot_disk);
        formatter.field("staging_disk_type", &self.staging_disk_type);
        formatter.field("iops", &self.iops);
        formatter.field("throughput", &self.throughput);
        formatter.finish()
    }
}
/// See [`ReplicationConfigurationReplicatedDisk`](crate::model::ReplicationConfigurationReplicatedDisk)
pub mod replication_configuration_replicated_disk {
    /// A builder for [`ReplicationConfigurationReplicatedDisk`](crate::model::ReplicationConfigurationReplicatedDisk)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_name: std::option::Option<std::string::String>,
        pub(crate) is_boot_disk: std::option::Option<bool>,
        pub(crate) staging_disk_type: std::option::Option<
            crate::model::ReplicationConfigurationReplicatedDiskStagingDiskType,
        >,
        pub(crate) iops: std::option::Option<i64>,
        pub(crate) throughput: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>Replication Configuration replicated disk device name.</p>
        pub fn device_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_name = Some(input.into());
            self
        }
        /// <p>Replication Configuration replicated disk device name.</p>
        pub fn set_device_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_name = input;
            self
        }
        /// <p>Replication Configuration replicated disk boot disk.</p>
        pub fn is_boot_disk(mut self, input: bool) -> Self {
            self.is_boot_disk = Some(input);
            self
        }
        /// <p>Replication Configuration replicated disk boot disk.</p>
        pub fn set_is_boot_disk(mut self, input: std::option::Option<bool>) -> Self {
            self.is_boot_disk = input;
            self
        }
        /// <p>Replication Configuration replicated disk staging disk type.</p>
        pub fn staging_disk_type(
            mut self,
            input: crate::model::ReplicationConfigurationReplicatedDiskStagingDiskType,
        ) -> Self {
            self.staging_disk_type = Some(input);
            self
        }
        /// <p>Replication Configuration replicated disk staging disk type.</p>
        pub fn set_staging_disk_type(
            mut self,
            input: std::option::Option<
                crate::model::ReplicationConfigurationReplicatedDiskStagingDiskType,
            >,
        ) -> Self {
            self.staging_disk_type = input;
            self
        }
        /// <p>Replication Configuration replicated disk IOPs.</p>
        pub fn iops(mut self, input: i64) -> Self {
            self.iops = Some(input);
            self
        }
        /// <p>Replication Configuration replicated disk IOPs.</p>
        pub fn set_iops(mut self, input: std::option::Option<i64>) -> Self {
            self.iops = input;
            self
        }
        /// <p>Replication Configuration replicated disk throughput.</p>
        pub fn throughput(mut self, input: i64) -> Self {
            self.throughput = Some(input);
            self
        }
        /// <p>Replication Configuration replicated disk throughput.</p>
        pub fn set_throughput(mut self, input: std::option::Option<i64>) -> Self {
            self.throughput = input;
            self
        }
        /// Consumes the builder and constructs a [`ReplicationConfigurationReplicatedDisk`](crate::model::ReplicationConfigurationReplicatedDisk)
        pub fn build(self) -> crate::model::ReplicationConfigurationReplicatedDisk {
            crate::model::ReplicationConfigurationReplicatedDisk {
                device_name: self.device_name,
                is_boot_disk: self.is_boot_disk,
                staging_disk_type: self.staging_disk_type,
                iops: self.iops.unwrap_or_default(),
                throughput: self.throughput.unwrap_or_default(),
            }
        }
    }
}
impl ReplicationConfigurationReplicatedDisk {
    /// Creates a new builder-style object to manufacture [`ReplicationConfigurationReplicatedDisk`](crate::model::ReplicationConfigurationReplicatedDisk)
    pub fn builder() -> crate::model::replication_configuration_replicated_disk::Builder {
        crate::model::replication_configuration_replicated_disk::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReplicationConfigurationReplicatedDiskStagingDiskType {
    #[allow(missing_docs)] // documentation missing in model
    Auto,
    #[allow(missing_docs)] // documentation missing in model
    Gp2,
    #[allow(missing_docs)] // documentation missing in model
    Gp3,
    #[allow(missing_docs)] // documentation missing in model
    Io1,
    #[allow(missing_docs)] // documentation missing in model
    Io2,
    #[allow(missing_docs)] // documentation missing in model
    Sc1,
    #[allow(missing_docs)] // documentation missing in model
    St1,
    #[allow(missing_docs)] // documentation missing in model
    Standard,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReplicationConfigurationReplicatedDiskStagingDiskType {
    fn from(s: &str) -> Self {
        match s {
            "AUTO" => ReplicationConfigurationReplicatedDiskStagingDiskType::Auto,
            "GP2" => ReplicationConfigurationReplicatedDiskStagingDiskType::Gp2,
            "GP3" => ReplicationConfigurationReplicatedDiskStagingDiskType::Gp3,
            "IO1" => ReplicationConfigurationReplicatedDiskStagingDiskType::Io1,
            "IO2" => ReplicationConfigurationReplicatedDiskStagingDiskType::Io2,
            "SC1" => ReplicationConfigurationReplicatedDiskStagingDiskType::Sc1,
            "ST1" => ReplicationConfigurationReplicatedDiskStagingDiskType::St1,
            "STANDARD" => ReplicationConfigurationReplicatedDiskStagingDiskType::Standard,
            other => {
                ReplicationConfigurationReplicatedDiskStagingDiskType::Unknown(other.to_owned())
            }
        }
    }
}
impl std::str::FromStr for ReplicationConfigurationReplicatedDiskStagingDiskType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReplicationConfigurationReplicatedDiskStagingDiskType::from(
            s,
        ))
    }
}
impl ReplicationConfigurationReplicatedDiskStagingDiskType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReplicationConfigurationReplicatedDiskStagingDiskType::Auto => "AUTO",
            ReplicationConfigurationReplicatedDiskStagingDiskType::Gp2 => "GP2",
            ReplicationConfigurationReplicatedDiskStagingDiskType::Gp3 => "GP3",
            ReplicationConfigurationReplicatedDiskStagingDiskType::Io1 => "IO1",
            ReplicationConfigurationReplicatedDiskStagingDiskType::Io2 => "IO2",
            ReplicationConfigurationReplicatedDiskStagingDiskType::Sc1 => "SC1",
            ReplicationConfigurationReplicatedDiskStagingDiskType::St1 => "ST1",
            ReplicationConfigurationReplicatedDiskStagingDiskType::Standard => "STANDARD",
            ReplicationConfigurationReplicatedDiskStagingDiskType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AUTO", "GP2", "GP3", "IO1", "IO2", "SC1", "ST1", "STANDARD"]
    }
}
impl AsRef<str> for ReplicationConfigurationReplicatedDiskStagingDiskType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReplicationConfigurationDefaultLargeStagingDiskType {
    #[allow(missing_docs)] // documentation missing in model
    Gp2,
    #[allow(missing_docs)] // documentation missing in model
    Gp3,
    #[allow(missing_docs)] // documentation missing in model
    St1,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReplicationConfigurationDefaultLargeStagingDiskType {
    fn from(s: &str) -> Self {
        match s {
            "GP2" => ReplicationConfigurationDefaultLargeStagingDiskType::Gp2,
            "GP3" => ReplicationConfigurationDefaultLargeStagingDiskType::Gp3,
            "ST1" => ReplicationConfigurationDefaultLargeStagingDiskType::St1,
            other => ReplicationConfigurationDefaultLargeStagingDiskType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReplicationConfigurationDefaultLargeStagingDiskType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReplicationConfigurationDefaultLargeStagingDiskType::from(s))
    }
}
impl ReplicationConfigurationDefaultLargeStagingDiskType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReplicationConfigurationDefaultLargeStagingDiskType::Gp2 => "GP2",
            ReplicationConfigurationDefaultLargeStagingDiskType::Gp3 => "GP3",
            ReplicationConfigurationDefaultLargeStagingDiskType::St1 => "ST1",
            ReplicationConfigurationDefaultLargeStagingDiskType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["GP2", "GP3", "ST1"]
    }
}
impl AsRef<str> for ReplicationConfigurationDefaultLargeStagingDiskType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BootMode {
    #[allow(missing_docs)] // documentation missing in model
    LegacyBios,
    #[allow(missing_docs)] // documentation missing in model
    Uefi,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BootMode {
    fn from(s: &str) -> Self {
        match s {
            "LEGACY_BIOS" => BootMode::LegacyBios,
            "UEFI" => BootMode::Uefi,
            other => BootMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BootMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BootMode::from(s))
    }
}
impl BootMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BootMode::LegacyBios => "LEGACY_BIOS",
            BootMode::Uefi => "UEFI",
            BootMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["LEGACY_BIOS", "UEFI"]
    }
}
impl AsRef<str> for BootMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Configure Licensing.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Licensing {
    /// <p>Configure BYOL OS licensing.</p>
    pub os_byol: std::option::Option<bool>,
}
impl Licensing {
    /// <p>Configure BYOL OS licensing.</p>
    pub fn os_byol(&self) -> std::option::Option<bool> {
        self.os_byol
    }
}
impl std::fmt::Debug for Licensing {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Licensing");
        formatter.field("os_byol", &self.os_byol);
        formatter.finish()
    }
}
/// See [`Licensing`](crate::model::Licensing)
pub mod licensing {
    /// A builder for [`Licensing`](crate::model::Licensing)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) os_byol: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Configure BYOL OS licensing.</p>
        pub fn os_byol(mut self, input: bool) -> Self {
            self.os_byol = Some(input);
            self
        }
        /// <p>Configure BYOL OS licensing.</p>
        pub fn set_os_byol(mut self, input: std::option::Option<bool>) -> Self {
            self.os_byol = input;
            self
        }
        /// Consumes the builder and constructs a [`Licensing`](crate::model::Licensing)
        pub fn build(self) -> crate::model::Licensing {
            crate::model::Licensing {
                os_byol: self.os_byol,
            }
        }
    }
}
impl Licensing {
    /// Creates a new builder-style object to manufacture [`Licensing`](crate::model::Licensing)
    pub fn builder() -> crate::model::licensing::Builder {
        crate::model::licensing::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TargetInstanceTypeRightSizingMethod {
    #[allow(missing_docs)] // documentation missing in model
    Basic,
    #[allow(missing_docs)] // documentation missing in model
    None,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TargetInstanceTypeRightSizingMethod {
    fn from(s: &str) -> Self {
        match s {
            "BASIC" => TargetInstanceTypeRightSizingMethod::Basic,
            "NONE" => TargetInstanceTypeRightSizingMethod::None,
            other => TargetInstanceTypeRightSizingMethod::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TargetInstanceTypeRightSizingMethod {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TargetInstanceTypeRightSizingMethod::from(s))
    }
}
impl TargetInstanceTypeRightSizingMethod {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TargetInstanceTypeRightSizingMethod::Basic => "BASIC",
            TargetInstanceTypeRightSizingMethod::None => "NONE",
            TargetInstanceTypeRightSizingMethod::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["BASIC", "NONE"]
    }
}
impl AsRef<str> for TargetInstanceTypeRightSizingMethod {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LaunchDisposition {
    #[allow(missing_docs)] // documentation missing in model
    Started,
    #[allow(missing_docs)] // documentation missing in model
    Stopped,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LaunchDisposition {
    fn from(s: &str) -> Self {
        match s {
            "STARTED" => LaunchDisposition::Started,
            "STOPPED" => LaunchDisposition::Stopped,
            other => LaunchDisposition::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LaunchDisposition {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LaunchDisposition::from(s))
    }
}
impl LaunchDisposition {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LaunchDisposition::Started => "STARTED",
            LaunchDisposition::Stopped => "STOPPED",
            LaunchDisposition::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["STARTED", "STOPPED"]
    }
}
impl AsRef<str> for LaunchDisposition {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The request to change the source server migration lifecycle state.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChangeServerLifeCycleStateSourceServerLifecycle {
    /// <p>The request to change the source server migration lifecycle state.</p>
    pub state:
        std::option::Option<crate::model::ChangeServerLifeCycleStateSourceServerLifecycleState>,
}
impl ChangeServerLifeCycleStateSourceServerLifecycle {
    /// <p>The request to change the source server migration lifecycle state.</p>
    pub fn state(
        &self,
    ) -> std::option::Option<&crate::model::ChangeServerLifeCycleStateSourceServerLifecycleState>
    {
        self.state.as_ref()
    }
}
impl std::fmt::Debug for ChangeServerLifeCycleStateSourceServerLifecycle {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChangeServerLifeCycleStateSourceServerLifecycle");
        formatter.field("state", &self.state);
        formatter.finish()
    }
}
/// See [`ChangeServerLifeCycleStateSourceServerLifecycle`](crate::model::ChangeServerLifeCycleStateSourceServerLifecycle)
pub mod change_server_life_cycle_state_source_server_lifecycle {
    /// A builder for [`ChangeServerLifeCycleStateSourceServerLifecycle`](crate::model::ChangeServerLifeCycleStateSourceServerLifecycle)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) state:
            std::option::Option<crate::model::ChangeServerLifeCycleStateSourceServerLifecycleState>,
    }
    impl Builder {
        /// <p>The request to change the source server migration lifecycle state.</p>
        pub fn state(
            mut self,
            input: crate::model::ChangeServerLifeCycleStateSourceServerLifecycleState,
        ) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The request to change the source server migration lifecycle state.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<
                crate::model::ChangeServerLifeCycleStateSourceServerLifecycleState,
            >,
        ) -> Self {
            self.state = input;
            self
        }
        /// Consumes the builder and constructs a [`ChangeServerLifeCycleStateSourceServerLifecycle`](crate::model::ChangeServerLifeCycleStateSourceServerLifecycle)
        pub fn build(self) -> crate::model::ChangeServerLifeCycleStateSourceServerLifecycle {
            crate::model::ChangeServerLifeCycleStateSourceServerLifecycle { state: self.state }
        }
    }
}
impl ChangeServerLifeCycleStateSourceServerLifecycle {
    /// Creates a new builder-style object to manufacture [`ChangeServerLifeCycleStateSourceServerLifecycle`](crate::model::ChangeServerLifeCycleStateSourceServerLifecycle)
    pub fn builder() -> crate::model::change_server_life_cycle_state_source_server_lifecycle::Builder
    {
        crate::model::change_server_life_cycle_state_source_server_lifecycle::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ChangeServerLifeCycleStateSourceServerLifecycleState {
    #[allow(missing_docs)] // documentation missing in model
    Cutover,
    #[allow(missing_docs)] // documentation missing in model
    ReadyForCutover,
    #[allow(missing_docs)] // documentation missing in model
    ReadyForTest,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ChangeServerLifeCycleStateSourceServerLifecycleState {
    fn from(s: &str) -> Self {
        match s {
            "CUTOVER" => ChangeServerLifeCycleStateSourceServerLifecycleState::Cutover,
            "READY_FOR_CUTOVER" => {
                ChangeServerLifeCycleStateSourceServerLifecycleState::ReadyForCutover
            }
            "READY_FOR_TEST" => ChangeServerLifeCycleStateSourceServerLifecycleState::ReadyForTest,
            other => {
                ChangeServerLifeCycleStateSourceServerLifecycleState::Unknown(other.to_owned())
            }
        }
    }
}
impl std::str::FromStr for ChangeServerLifeCycleStateSourceServerLifecycleState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ChangeServerLifeCycleStateSourceServerLifecycleState::from(
            s,
        ))
    }
}
impl ChangeServerLifeCycleStateSourceServerLifecycleState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ChangeServerLifeCycleStateSourceServerLifecycleState::Cutover => "CUTOVER",
            ChangeServerLifeCycleStateSourceServerLifecycleState::ReadyForCutover => {
                "READY_FOR_CUTOVER"
            }
            ChangeServerLifeCycleStateSourceServerLifecycleState::ReadyForTest => "READY_FOR_TEST",
            ChangeServerLifeCycleStateSourceServerLifecycleState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CUTOVER", "READY_FOR_CUTOVER", "READY_FOR_TEST"]
    }
}
impl AsRef<str> for ChangeServerLifeCycleStateSourceServerLifecycleState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Job {
    /// <p>Job ID.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>the ARN of the specific Job.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>Job type.</p>
    pub r#type: std::option::Option<crate::model::JobType>,
    /// <p>Job initiated by field.</p>
    pub initiated_by: std::option::Option<crate::model::InitiatedBy>,
    /// <p>Job creation time.</p>
    pub creation_date_time: std::option::Option<std::string::String>,
    /// <p>Job end time.</p>
    pub end_date_time: std::option::Option<std::string::String>,
    /// <p>Job status.</p>
    pub status: std::option::Option<crate::model::JobStatus>,
    /// <p>Servers participating in a specific Job.</p>
    pub participating_servers:
        std::option::Option<std::vec::Vec<crate::model::ParticipatingServer>>,
    /// <p>Tags associated with specific Job.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl Job {
    /// <p>Job ID.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>the ARN of the specific Job.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>Job type.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::JobType> {
        self.r#type.as_ref()
    }
    /// <p>Job initiated by field.</p>
    pub fn initiated_by(&self) -> std::option::Option<&crate::model::InitiatedBy> {
        self.initiated_by.as_ref()
    }
    /// <p>Job creation time.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&str> {
        self.creation_date_time.as_deref()
    }
    /// <p>Job end time.</p>
    pub fn end_date_time(&self) -> std::option::Option<&str> {
        self.end_date_time.as_deref()
    }
    /// <p>Job status.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::JobStatus> {
        self.status.as_ref()
    }
    /// <p>Servers participating in a specific Job.</p>
    pub fn participating_servers(
        &self,
    ) -> std::option::Option<&[crate::model::ParticipatingServer]> {
        self.participating_servers.as_deref()
    }
    /// <p>Tags associated with specific Job.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for Job {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Job");
        formatter.field("job_id", &self.job_id);
        formatter.field("arn", &self.arn);
        formatter.field("r#type", &self.r#type);
        formatter.field("initiated_by", &self.initiated_by);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("end_date_time", &self.end_date_time);
        formatter.field("status", &self.status);
        formatter.field("participating_servers", &self.participating_servers);
        formatter.field("tags", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`Job`](crate::model::Job)
pub mod job {
    /// A builder for [`Job`](crate::model::Job)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::JobType>,
        pub(crate) initiated_by: std::option::Option<crate::model::InitiatedBy>,
        pub(crate) creation_date_time: std::option::Option<std::string::String>,
        pub(crate) end_date_time: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::JobStatus>,
        pub(crate) participating_servers:
            std::option::Option<std::vec::Vec<crate::model::ParticipatingServer>>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>Job ID.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>Job ID.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>the ARN of the specific Job.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>the ARN of the specific Job.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>Job type.</p>
        pub fn r#type(mut self, input: crate::model::JobType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>Job type.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::JobType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>Job initiated by field.</p>
        pub fn initiated_by(mut self, input: crate::model::InitiatedBy) -> Self {
            self.initiated_by = Some(input);
            self
        }
        /// <p>Job initiated by field.</p>
        pub fn set_initiated_by(
            mut self,
            input: std::option::Option<crate::model::InitiatedBy>,
        ) -> Self {
            self.initiated_by = input;
            self
        }
        /// <p>Job creation time.</p>
        pub fn creation_date_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.creation_date_time = Some(input.into());
            self
        }
        /// <p>Job creation time.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>Job end time.</p>
        pub fn end_date_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.end_date_time = Some(input.into());
            self
        }
        /// <p>Job end time.</p>
        pub fn set_end_date_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.end_date_time = input;
            self
        }
        /// <p>Job status.</p>
        pub fn status(mut self, input: crate::model::JobStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Job status.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::JobStatus>) -> Self {
            self.status = input;
            self
        }
        /// Appends an item to `participating_servers`.
        ///
        /// To override the contents of this collection use [`set_participating_servers`](Self::set_participating_servers).
        ///
        /// <p>Servers participating in a specific Job.</p>
        pub fn participating_servers(mut self, input: crate::model::ParticipatingServer) -> Self {
            let mut v = self.participating_servers.unwrap_or_default();
            v.push(input);
            self.participating_servers = Some(v);
            self
        }
        /// <p>Servers participating in a specific Job.</p>
        pub fn set_participating_servers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ParticipatingServer>>,
        ) -> Self {
            self.participating_servers = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags associated with specific Job.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Tags associated with specific Job.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`Job`](crate::model::Job)
        pub fn build(self) -> crate::model::Job {
            crate::model::Job {
                job_id: self.job_id,
                arn: self.arn,
                r#type: self.r#type,
                initiated_by: self.initiated_by,
                creation_date_time: self.creation_date_time,
                end_date_time: self.end_date_time,
                status: self.status,
                participating_servers: self.participating_servers,
                tags: self.tags,
            }
        }
    }
}
impl Job {
    /// Creates a new builder-style object to manufacture [`Job`](crate::model::Job)
    pub fn builder() -> crate::model::job::Builder {
        crate::model::job::Builder::default()
    }
}

/// <p>Server participating in Job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ParticipatingServer {
    /// <p>Participating server Source Server ID.</p>
    pub source_server_id: std::option::Option<std::string::String>,
    /// <p>Participating server launch status.</p>
    pub launch_status: std::option::Option<crate::model::LaunchStatus>,
}
impl ParticipatingServer {
    /// <p>Participating server Source Server ID.</p>
    pub fn source_server_id(&self) -> std::option::Option<&str> {
        self.source_server_id.as_deref()
    }
    /// <p>Participating server launch status.</p>
    pub fn launch_status(&self) -> std::option::Option<&crate::model::LaunchStatus> {
        self.launch_status.as_ref()
    }
}
impl std::fmt::Debug for ParticipatingServer {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ParticipatingServer");
        formatter.field("source_server_id", &self.source_server_id);
        formatter.field("launch_status", &self.launch_status);
        formatter.finish()
    }
}
/// See [`ParticipatingServer`](crate::model::ParticipatingServer)
pub mod participating_server {
    /// A builder for [`ParticipatingServer`](crate::model::ParticipatingServer)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_server_id: std::option::Option<std::string::String>,
        pub(crate) launch_status: std::option::Option<crate::model::LaunchStatus>,
    }
    impl Builder {
        /// <p>Participating server Source Server ID.</p>
        pub fn source_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_server_id = Some(input.into());
            self
        }
        /// <p>Participating server Source Server ID.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_server_id = input;
            self
        }
        /// <p>Participating server launch status.</p>
        pub fn launch_status(mut self, input: crate::model::LaunchStatus) -> Self {
            self.launch_status = Some(input);
            self
        }
        /// <p>Participating server launch status.</p>
        pub fn set_launch_status(
            mut self,
            input: std::option::Option<crate::model::LaunchStatus>,
        ) -> Self {
            self.launch_status = input;
            self
        }
        /// Consumes the builder and constructs a [`ParticipatingServer`](crate::model::ParticipatingServer)
        pub fn build(self) -> crate::model::ParticipatingServer {
            crate::model::ParticipatingServer {
                source_server_id: self.source_server_id,
                launch_status: self.launch_status,
            }
        }
    }
}
impl ParticipatingServer {
    /// Creates a new builder-style object to manufacture [`ParticipatingServer`](crate::model::ParticipatingServer)
    pub fn builder() -> crate::model::participating_server::Builder {
        crate::model::participating_server::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LaunchStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Launched,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Terminated,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LaunchStatus {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => LaunchStatus::Failed,
            "IN_PROGRESS" => LaunchStatus::InProgress,
            "LAUNCHED" => LaunchStatus::Launched,
            "PENDING" => LaunchStatus::Pending,
            "TERMINATED" => LaunchStatus::Terminated,
            other => LaunchStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LaunchStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LaunchStatus::from(s))
    }
}
impl LaunchStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LaunchStatus::Failed => "FAILED",
            LaunchStatus::InProgress => "IN_PROGRESS",
            LaunchStatus::Launched => "LAUNCHED",
            LaunchStatus::Pending => "PENDING",
            LaunchStatus::Terminated => "TERMINATED",
            LaunchStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAILED", "IN_PROGRESS", "LAUNCHED", "PENDING", "TERMINATED"]
    }
}
impl AsRef<str> for LaunchStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum JobStatus {
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Started,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for JobStatus {
    fn from(s: &str) -> Self {
        match s {
            "COMPLETED" => JobStatus::Completed,
            "PENDING" => JobStatus::Pending,
            "STARTED" => JobStatus::Started,
            other => JobStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for JobStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(JobStatus::from(s))
    }
}
impl JobStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            JobStatus::Completed => "COMPLETED",
            JobStatus::Pending => "PENDING",
            JobStatus::Started => "STARTED",
            JobStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COMPLETED", "PENDING", "STARTED"]
    }
}
impl AsRef<str> for JobStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InitiatedBy {
    #[allow(missing_docs)] // documentation missing in model
    Diagnostic,
    #[allow(missing_docs)] // documentation missing in model
    StartCutover,
    #[allow(missing_docs)] // documentation missing in model
    StartTest,
    #[allow(missing_docs)] // documentation missing in model
    Terminate,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InitiatedBy {
    fn from(s: &str) -> Self {
        match s {
            "DIAGNOSTIC" => InitiatedBy::Diagnostic,
            "START_CUTOVER" => InitiatedBy::StartCutover,
            "START_TEST" => InitiatedBy::StartTest,
            "TERMINATE" => InitiatedBy::Terminate,
            other => InitiatedBy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InitiatedBy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InitiatedBy::from(s))
    }
}
impl InitiatedBy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InitiatedBy::Diagnostic => "DIAGNOSTIC",
            InitiatedBy::StartCutover => "START_CUTOVER",
            InitiatedBy::StartTest => "START_TEST",
            InitiatedBy::Terminate => "TERMINATE",
            InitiatedBy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DIAGNOSTIC", "START_CUTOVER", "START_TEST", "TERMINATE"]
    }
}
impl AsRef<str> for InitiatedBy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum JobType {
    #[allow(missing_docs)] // documentation missing in model
    Launch,
    #[allow(missing_docs)] // documentation missing in model
    Terminate,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for JobType {
    fn from(s: &str) -> Self {
        match s {
            "LAUNCH" => JobType::Launch,
            "TERMINATE" => JobType::Terminate,
            other => JobType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for JobType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(JobType::from(s))
    }
}
impl JobType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            JobType::Launch => "LAUNCH",
            JobType::Terminate => "TERMINATE",
            JobType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["LAUNCH", "TERMINATE"]
    }
}
impl AsRef<str> for JobType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SourceServer {
    /// <p>Source server ID.</p>
    pub source_server_id: std::option::Option<std::string::String>,
    /// <p>Source server ARN.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>Source server archived status.</p>
    pub is_archived: std::option::Option<bool>,
    /// <p>Source server Tags.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Source server launched instance.</p>
    pub launched_instance: std::option::Option<crate::model::LaunchedInstance>,
    /// <p>Source server data replication info.</p>
    pub data_replication_info: std::option::Option<crate::model::DataReplicationInfo>,
    /// <p>Source server lifecycle state.</p>
    pub life_cycle: std::option::Option<crate::model::LifeCycle>,
    /// <p>Source server properties.</p>
    pub source_properties: std::option::Option<crate::model::SourceProperties>,
    /// <p>Source server replication type.</p>
    pub replication_type: std::option::Option<crate::model::ReplicationType>,
    /// <p>Source server vCenter client id.</p>
    pub vcenter_client_id: std::option::Option<std::string::String>,
}
impl SourceServer {
    /// <p>Source server ID.</p>
    pub fn source_server_id(&self) -> std::option::Option<&str> {
        self.source_server_id.as_deref()
    }
    /// <p>Source server ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>Source server archived status.</p>
    pub fn is_archived(&self) -> std::option::Option<bool> {
        self.is_archived
    }
    /// <p>Source server Tags.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>Source server launched instance.</p>
    pub fn launched_instance(&self) -> std::option::Option<&crate::model::LaunchedInstance> {
        self.launched_instance.as_ref()
    }
    /// <p>Source server data replication info.</p>
    pub fn data_replication_info(&self) -> std::option::Option<&crate::model::DataReplicationInfo> {
        self.data_replication_info.as_ref()
    }
    /// <p>Source server lifecycle state.</p>
    pub fn life_cycle(&self) -> std::option::Option<&crate::model::LifeCycle> {
        self.life_cycle.as_ref()
    }
    /// <p>Source server properties.</p>
    pub fn source_properties(&self) -> std::option::Option<&crate::model::SourceProperties> {
        self.source_properties.as_ref()
    }
    /// <p>Source server replication type.</p>
    pub fn replication_type(&self) -> std::option::Option<&crate::model::ReplicationType> {
        self.replication_type.as_ref()
    }
    /// <p>Source server vCenter client id.</p>
    pub fn vcenter_client_id(&self) -> std::option::Option<&str> {
        self.vcenter_client_id.as_deref()
    }
}
impl std::fmt::Debug for SourceServer {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SourceServer");
        formatter.field("source_server_id", &self.source_server_id);
        formatter.field("arn", &self.arn);
        formatter.field("is_archived", &self.is_archived);
        formatter.field("tags", &"*** Sensitive Data Redacted ***");
        formatter.field("launched_instance", &self.launched_instance);
        formatter.field("data_replication_info", &self.data_replication_info);
        formatter.field("life_cycle", &self.life_cycle);
        formatter.field("source_properties", &self.source_properties);
        formatter.field("replication_type", &self.replication_type);
        formatter.field("vcenter_client_id", &self.vcenter_client_id);
        formatter.finish()
    }
}
/// See [`SourceServer`](crate::model::SourceServer)
pub mod source_server {
    /// A builder for [`SourceServer`](crate::model::SourceServer)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_server_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) is_archived: std::option::Option<bool>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) launched_instance: std::option::Option<crate::model::LaunchedInstance>,
        pub(crate) data_replication_info: std::option::Option<crate::model::DataReplicationInfo>,
        pub(crate) life_cycle: std::option::Option<crate::model::LifeCycle>,
        pub(crate) source_properties: std::option::Option<crate::model::SourceProperties>,
        pub(crate) replication_type: std::option::Option<crate::model::ReplicationType>,
        pub(crate) vcenter_client_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Source server ID.</p>
        pub fn source_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_server_id = Some(input.into());
            self
        }
        /// <p>Source server ID.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_server_id = input;
            self
        }
        /// <p>Source server ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>Source server ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>Source server archived status.</p>
        pub fn is_archived(mut self, input: bool) -> Self {
            self.is_archived = Some(input);
            self
        }
        /// <p>Source server archived status.</p>
        pub fn set_is_archived(mut self, input: std::option::Option<bool>) -> Self {
            self.is_archived = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Source server Tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Source server Tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Source server launched instance.</p>
        pub fn launched_instance(mut self, input: crate::model::LaunchedInstance) -> Self {
            self.launched_instance = Some(input);
            self
        }
        /// <p>Source server launched instance.</p>
        pub fn set_launched_instance(
            mut self,
            input: std::option::Option<crate::model::LaunchedInstance>,
        ) -> Self {
            self.launched_instance = input;
            self
        }
        /// <p>Source server data replication info.</p>
        pub fn data_replication_info(mut self, input: crate::model::DataReplicationInfo) -> Self {
            self.data_replication_info = Some(input);
            self
        }
        /// <p>Source server data replication info.</p>
        pub fn set_data_replication_info(
            mut self,
            input: std::option::Option<crate::model::DataReplicationInfo>,
        ) -> Self {
            self.data_replication_info = input;
            self
        }
        /// <p>Source server lifecycle state.</p>
        pub fn life_cycle(mut self, input: crate::model::LifeCycle) -> Self {
            self.life_cycle = Some(input);
            self
        }
        /// <p>Source server lifecycle state.</p>
        pub fn set_life_cycle(
            mut self,
            input: std::option::Option<crate::model::LifeCycle>,
        ) -> Self {
            self.life_cycle = input;
            self
        }
        /// <p>Source server properties.</p>
        pub fn source_properties(mut self, input: crate::model::SourceProperties) -> Self {
            self.source_properties = Some(input);
            self
        }
        /// <p>Source server properties.</p>
        pub fn set_source_properties(
            mut self,
            input: std::option::Option<crate::model::SourceProperties>,
        ) -> Self {
            self.source_properties = input;
            self
        }
        /// <p>Source server replication type.</p>
        pub fn replication_type(mut self, input: crate::model::ReplicationType) -> Self {
            self.replication_type = Some(input);
            self
        }
        /// <p>Source server replication type.</p>
        pub fn set_replication_type(
            mut self,
            input: std::option::Option<crate::model::ReplicationType>,
        ) -> Self {
            self.replication_type = input;
            self
        }
        /// <p>Source server vCenter client id.</p>
        pub fn vcenter_client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vcenter_client_id = Some(input.into());
            self
        }
        /// <p>Source server vCenter client id.</p>
        pub fn set_vcenter_client_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vcenter_client_id = input;
            self
        }
        /// Consumes the builder and constructs a [`SourceServer`](crate::model::SourceServer)
        pub fn build(self) -> crate::model::SourceServer {
            crate::model::SourceServer {
                source_server_id: self.source_server_id,
                arn: self.arn,
                is_archived: self.is_archived,
                tags: self.tags,
                launched_instance: self.launched_instance,
                data_replication_info: self.data_replication_info,
                life_cycle: self.life_cycle,
                source_properties: self.source_properties,
                replication_type: self.replication_type,
                vcenter_client_id: self.vcenter_client_id,
            }
        }
    }
}
impl SourceServer {
    /// Creates a new builder-style object to manufacture [`SourceServer`](crate::model::SourceServer)
    pub fn builder() -> crate::model::source_server::Builder {
        crate::model::source_server::Builder::default()
    }
}

/// <p>Request to filter Source Servers list.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSourceServersRequestFilters {
    /// <p>Request to filter Source Servers list by Source Server ID.</p>
    pub source_server_i_ds: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Request to filter Source Servers list by archived.</p>
    pub is_archived: std::option::Option<bool>,
    /// <p>Request to filter Source Servers list by replication type.</p>
    pub replication_types: std::option::Option<std::vec::Vec<crate::model::ReplicationType>>,
    /// <p>Request to filter Source Servers list by life cycle states.</p>
    pub life_cycle_states: std::option::Option<std::vec::Vec<crate::model::LifeCycleState>>,
}
impl DescribeSourceServersRequestFilters {
    /// <p>Request to filter Source Servers list by Source Server ID.</p>
    pub fn source_server_i_ds(&self) -> std::option::Option<&[std::string::String]> {
        self.source_server_i_ds.as_deref()
    }
    /// <p>Request to filter Source Servers list by archived.</p>
    pub fn is_archived(&self) -> std::option::Option<bool> {
        self.is_archived
    }
    /// <p>Request to filter Source Servers list by replication type.</p>
    pub fn replication_types(&self) -> std::option::Option<&[crate::model::ReplicationType]> {
        self.replication_types.as_deref()
    }
    /// <p>Request to filter Source Servers list by life cycle states.</p>
    pub fn life_cycle_states(&self) -> std::option::Option<&[crate::model::LifeCycleState]> {
        self.life_cycle_states.as_deref()
    }
}
impl std::fmt::Debug for DescribeSourceServersRequestFilters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSourceServersRequestFilters");
        formatter.field("source_server_i_ds", &self.source_server_i_ds);
        formatter.field("is_archived", &self.is_archived);
        formatter.field("replication_types", &self.replication_types);
        formatter.field("life_cycle_states", &self.life_cycle_states);
        formatter.finish()
    }
}
/// See [`DescribeSourceServersRequestFilters`](crate::model::DescribeSourceServersRequestFilters)
pub mod describe_source_servers_request_filters {
    /// A builder for [`DescribeSourceServersRequestFilters`](crate::model::DescribeSourceServersRequestFilters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_server_i_ds: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) is_archived: std::option::Option<bool>,
        pub(crate) replication_types:
            std::option::Option<std::vec::Vec<crate::model::ReplicationType>>,
        pub(crate) life_cycle_states:
            std::option::Option<std::vec::Vec<crate::model::LifeCycleState>>,
    }
    impl Builder {
        /// Appends an item to `source_server_i_ds`.
        ///
        /// To override the contents of this collection use [`set_source_server_i_ds`](Self::set_source_server_i_ds).
        ///
        /// <p>Request to filter Source Servers list by Source Server ID.</p>
        pub fn source_server_i_ds(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.source_server_i_ds.unwrap_or_default();
            v.push(input.into());
            self.source_server_i_ds = Some(v);
            self
        }
        /// <p>Request to filter Source Servers list by Source Server ID.</p>
        pub fn set_source_server_i_ds(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.source_server_i_ds = input;
            self
        }
        /// <p>Request to filter Source Servers list by archived.</p>
        pub fn is_archived(mut self, input: bool) -> Self {
            self.is_archived = Some(input);
            self
        }
        /// <p>Request to filter Source Servers list by archived.</p>
        pub fn set_is_archived(mut self, input: std::option::Option<bool>) -> Self {
            self.is_archived = input;
            self
        }
        /// Appends an item to `replication_types`.
        ///
        /// To override the contents of this collection use [`set_replication_types`](Self::set_replication_types).
        ///
        /// <p>Request to filter Source Servers list by replication type.</p>
        pub fn replication_types(mut self, input: crate::model::ReplicationType) -> Self {
            let mut v = self.replication_types.unwrap_or_default();
            v.push(input);
            self.replication_types = Some(v);
            self
        }
        /// <p>Request to filter Source Servers list by replication type.</p>
        pub fn set_replication_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReplicationType>>,
        ) -> Self {
            self.replication_types = input;
            self
        }
        /// Appends an item to `life_cycle_states`.
        ///
        /// To override the contents of this collection use [`set_life_cycle_states`](Self::set_life_cycle_states).
        ///
        /// <p>Request to filter Source Servers list by life cycle states.</p>
        pub fn life_cycle_states(mut self, input: crate::model::LifeCycleState) -> Self {
            let mut v = self.life_cycle_states.unwrap_or_default();
            v.push(input);
            self.life_cycle_states = Some(v);
            self
        }
        /// <p>Request to filter Source Servers list by life cycle states.</p>
        pub fn set_life_cycle_states(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LifeCycleState>>,
        ) -> Self {
            self.life_cycle_states = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSourceServersRequestFilters`](crate::model::DescribeSourceServersRequestFilters)
        pub fn build(self) -> crate::model::DescribeSourceServersRequestFilters {
            crate::model::DescribeSourceServersRequestFilters {
                source_server_i_ds: self.source_server_i_ds,
                is_archived: self.is_archived,
                replication_types: self.replication_types,
                life_cycle_states: self.life_cycle_states,
            }
        }
    }
}
impl DescribeSourceServersRequestFilters {
    /// Creates a new builder-style object to manufacture [`DescribeSourceServersRequestFilters`](crate::model::DescribeSourceServersRequestFilters)
    pub fn builder() -> crate::model::describe_source_servers_request_filters::Builder {
        crate::model::describe_source_servers_request_filters::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReplicationConfigurationTemplate {
    /// <p>Replication Configuration template ID.</p>
    pub replication_configuration_template_id: std::option::Option<std::string::String>,
    /// <p>Replication Configuration template ARN.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>Replication Configuration template Staging Area subnet ID.</p>
    pub staging_area_subnet_id: std::option::Option<std::string::String>,
    /// <p>Replication Configuration template associate default Application Migration Service Security group.</p>
    pub associate_default_security_group: std::option::Option<bool>,
    /// <p>Replication Configuration template server Security Groups IDs.</p>
    pub replication_servers_security_groups_i_ds:
        std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Replication Configuration template server instance type.</p>
    pub replication_server_instance_type: std::option::Option<std::string::String>,
    /// <p>Replication Configuration template use Dedicated Replication Server.</p>
    pub use_dedicated_replication_server: std::option::Option<bool>,
    /// <p>Replication Configuration template use default large Staging Disk type.</p>
    pub default_large_staging_disk_type:
        std::option::Option<crate::model::ReplicationConfigurationDefaultLargeStagingDiskType>,
    /// <p>Replication Configuration template EBS encryption.</p>
    pub ebs_encryption: std::option::Option<crate::model::ReplicationConfigurationEbsEncryption>,
    /// <p>Replication Configuration template EBS encryption key ARN.</p>
    pub ebs_encryption_key_arn: std::option::Option<std::string::String>,
    /// <p>Replication Configuration template bandwidth throttling.</p>
    pub bandwidth_throttling: i64,
    /// <p>Replication Configuration template data plane routing.</p>
    pub data_plane_routing:
        std::option::Option<crate::model::ReplicationConfigurationDataPlaneRouting>,
    /// <p>Replication Configuration template create Public IP.</p>
    pub create_public_ip: std::option::Option<bool>,
    /// <p>Replication Configuration template Staging Area Tags.</p>
    pub staging_area_tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Replication Configuration template Tags.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ReplicationConfigurationTemplate {
    /// <p>Replication Configuration template ID.</p>
    pub fn replication_configuration_template_id(&self) -> std::option::Option<&str> {
        self.replication_configuration_template_id.as_deref()
    }
    /// <p>Replication Configuration template ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>Replication Configuration template Staging Area subnet ID.</p>
    pub fn staging_area_subnet_id(&self) -> std::option::Option<&str> {
        self.staging_area_subnet_id.as_deref()
    }
    /// <p>Replication Configuration template associate default Application Migration Service Security group.</p>
    pub fn associate_default_security_group(&self) -> std::option::Option<bool> {
        self.associate_default_security_group
    }
    /// <p>Replication Configuration template server Security Groups IDs.</p>
    pub fn replication_servers_security_groups_i_ds(
        &self,
    ) -> std::option::Option<&[std::string::String]> {
        self.replication_servers_security_groups_i_ds.as_deref()
    }
    /// <p>Replication Configuration template server instance type.</p>
    pub fn replication_server_instance_type(&self) -> std::option::Option<&str> {
        self.replication_server_instance_type.as_deref()
    }
    /// <p>Replication Configuration template use Dedicated Replication Server.</p>
    pub fn use_dedicated_replication_server(&self) -> std::option::Option<bool> {
        self.use_dedicated_replication_server
    }
    /// <p>Replication Configuration template use default large Staging Disk type.</p>
    pub fn default_large_staging_disk_type(
        &self,
    ) -> std::option::Option<&crate::model::ReplicationConfigurationDefaultLargeStagingDiskType>
    {
        self.default_large_staging_disk_type.as_ref()
    }
    /// <p>Replication Configuration template EBS encryption.</p>
    pub fn ebs_encryption(
        &self,
    ) -> std::option::Option<&crate::model::ReplicationConfigurationEbsEncryption> {
        self.ebs_encryption.as_ref()
    }
    /// <p>Replication Configuration template EBS encryption key ARN.</p>
    pub fn ebs_encryption_key_arn(&self) -> std::option::Option<&str> {
        self.ebs_encryption_key_arn.as_deref()
    }
    /// <p>Replication Configuration template bandwidth throttling.</p>
    pub fn bandwidth_throttling(&self) -> i64 {
        self.bandwidth_throttling
    }
    /// <p>Replication Configuration template data plane routing.</p>
    pub fn data_plane_routing(
        &self,
    ) -> std::option::Option<&crate::model::ReplicationConfigurationDataPlaneRouting> {
        self.data_plane_routing.as_ref()
    }
    /// <p>Replication Configuration template create Public IP.</p>
    pub fn create_public_ip(&self) -> std::option::Option<bool> {
        self.create_public_ip
    }
    /// <p>Replication Configuration template Staging Area Tags.</p>
    pub fn staging_area_tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.staging_area_tags.as_ref()
    }
    /// <p>Replication Configuration template Tags.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for ReplicationConfigurationTemplate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReplicationConfigurationTemplate");
        formatter.field(
            "replication_configuration_template_id",
            &self.replication_configuration_template_id,
        );
        formatter.field("arn", &self.arn);
        formatter.field("staging_area_subnet_id", &self.staging_area_subnet_id);
        formatter.field(
            "associate_default_security_group",
            &self.associate_default_security_group,
        );
        formatter.field(
            "replication_servers_security_groups_i_ds",
            &self.replication_servers_security_groups_i_ds,
        );
        formatter.field(
            "replication_server_instance_type",
            &self.replication_server_instance_type,
        );
        formatter.field(
            "use_dedicated_replication_server",
            &self.use_dedicated_replication_server,
        );
        formatter.field(
            "default_large_staging_disk_type",
            &self.default_large_staging_disk_type,
        );
        formatter.field("ebs_encryption", &self.ebs_encryption);
        formatter.field("ebs_encryption_key_arn", &self.ebs_encryption_key_arn);
        formatter.field("bandwidth_throttling", &self.bandwidth_throttling);
        formatter.field("data_plane_routing", &self.data_plane_routing);
        formatter.field("create_public_ip", &self.create_public_ip);
        formatter.field("staging_area_tags", &"*** Sensitive Data Redacted ***");
        formatter.field("tags", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`ReplicationConfigurationTemplate`](crate::model::ReplicationConfigurationTemplate)
pub mod replication_configuration_template {
    /// A builder for [`ReplicationConfigurationTemplate`](crate::model::ReplicationConfigurationTemplate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_configuration_template_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) staging_area_subnet_id: std::option::Option<std::string::String>,
        pub(crate) associate_default_security_group: std::option::Option<bool>,
        pub(crate) replication_servers_security_groups_i_ds:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) replication_server_instance_type: std::option::Option<std::string::String>,
        pub(crate) use_dedicated_replication_server: std::option::Option<bool>,
        pub(crate) default_large_staging_disk_type:
            std::option::Option<crate::model::ReplicationConfigurationDefaultLargeStagingDiskType>,
        pub(crate) ebs_encryption:
            std::option::Option<crate::model::ReplicationConfigurationEbsEncryption>,
        pub(crate) ebs_encryption_key_arn: std::option::Option<std::string::String>,
        pub(crate) bandwidth_throttling: std::option::Option<i64>,
        pub(crate) data_plane_routing:
            std::option::Option<crate::model::ReplicationConfigurationDataPlaneRouting>,
        pub(crate) create_public_ip: std::option::Option<bool>,
        pub(crate) staging_area_tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>Replication Configuration template ID.</p>
        pub fn replication_configuration_template_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.replication_configuration_template_id = Some(input.into());
            self
        }
        /// <p>Replication Configuration template ID.</p>
        pub fn set_replication_configuration_template_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_configuration_template_id = input;
            self
        }
        /// <p>Replication Configuration template ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>Replication Configuration template ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>Replication Configuration template Staging Area subnet ID.</p>
        pub fn staging_area_subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.staging_area_subnet_id = Some(input.into());
            self
        }
        /// <p>Replication Configuration template Staging Area subnet ID.</p>
        pub fn set_staging_area_subnet_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.staging_area_subnet_id = input;
            self
        }
        /// <p>Replication Configuration template associate default Application Migration Service Security group.</p>
        pub fn associate_default_security_group(mut self, input: bool) -> Self {
            self.associate_default_security_group = Some(input);
            self
        }
        /// <p>Replication Configuration template associate default Application Migration Service Security group.</p>
        pub fn set_associate_default_security_group(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.associate_default_security_group = input;
            self
        }
        /// Appends an item to `replication_servers_security_groups_i_ds`.
        ///
        /// To override the contents of this collection use [`set_replication_servers_security_groups_i_ds`](Self::set_replication_servers_security_groups_i_ds).
        ///
        /// <p>Replication Configuration template server Security Groups IDs.</p>
        pub fn replication_servers_security_groups_i_ds(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self
                .replication_servers_security_groups_i_ds
                .unwrap_or_default();
            v.push(input.into());
            self.replication_servers_security_groups_i_ds = Some(v);
            self
        }
        /// <p>Replication Configuration template server Security Groups IDs.</p>
        pub fn set_replication_servers_security_groups_i_ds(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.replication_servers_security_groups_i_ds = input;
            self
        }
        /// <p>Replication Configuration template server instance type.</p>
        pub fn replication_server_instance_type(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.replication_server_instance_type = Some(input.into());
            self
        }
        /// <p>Replication Configuration template server instance type.</p>
        pub fn set_replication_server_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_server_instance_type = input;
            self
        }
        /// <p>Replication Configuration template use Dedicated Replication Server.</p>
        pub fn use_dedicated_replication_server(mut self, input: bool) -> Self {
            self.use_dedicated_replication_server = Some(input);
            self
        }
        /// <p>Replication Configuration template use Dedicated Replication Server.</p>
        pub fn set_use_dedicated_replication_server(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.use_dedicated_replication_server = input;
            self
        }
        /// <p>Replication Configuration template use default large Staging Disk type.</p>
        pub fn default_large_staging_disk_type(
            mut self,
            input: crate::model::ReplicationConfigurationDefaultLargeStagingDiskType,
        ) -> Self {
            self.default_large_staging_disk_type = Some(input);
            self
        }
        /// <p>Replication Configuration template use default large Staging Disk type.</p>
        pub fn set_default_large_staging_disk_type(
            mut self,
            input: std::option::Option<
                crate::model::ReplicationConfigurationDefaultLargeStagingDiskType,
            >,
        ) -> Self {
            self.default_large_staging_disk_type = input;
            self
        }
        /// <p>Replication Configuration template EBS encryption.</p>
        pub fn ebs_encryption(
            mut self,
            input: crate::model::ReplicationConfigurationEbsEncryption,
        ) -> Self {
            self.ebs_encryption = Some(input);
            self
        }
        /// <p>Replication Configuration template EBS encryption.</p>
        pub fn set_ebs_encryption(
            mut self,
            input: std::option::Option<crate::model::ReplicationConfigurationEbsEncryption>,
        ) -> Self {
            self.ebs_encryption = input;
            self
        }
        /// <p>Replication Configuration template EBS encryption key ARN.</p>
        pub fn ebs_encryption_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.ebs_encryption_key_arn = Some(input.into());
            self
        }
        /// <p>Replication Configuration template EBS encryption key ARN.</p>
        pub fn set_ebs_encryption_key_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ebs_encryption_key_arn = input;
            self
        }
        /// <p>Replication Configuration template bandwidth throttling.</p>
        pub fn bandwidth_throttling(mut self, input: i64) -> Self {
            self.bandwidth_throttling = Some(input);
            self
        }
        /// <p>Replication Configuration template bandwidth throttling.</p>
        pub fn set_bandwidth_throttling(mut self, input: std::option::Option<i64>) -> Self {
            self.bandwidth_throttling = input;
            self
        }
        /// <p>Replication Configuration template data plane routing.</p>
        pub fn data_plane_routing(
            mut self,
            input: crate::model::ReplicationConfigurationDataPlaneRouting,
        ) -> Self {
            self.data_plane_routing = Some(input);
            self
        }
        /// <p>Replication Configuration template data plane routing.</p>
        pub fn set_data_plane_routing(
            mut self,
            input: std::option::Option<crate::model::ReplicationConfigurationDataPlaneRouting>,
        ) -> Self {
            self.data_plane_routing = input;
            self
        }
        /// <p>Replication Configuration template create Public IP.</p>
        pub fn create_public_ip(mut self, input: bool) -> Self {
            self.create_public_ip = Some(input);
            self
        }
        /// <p>Replication Configuration template create Public IP.</p>
        pub fn set_create_public_ip(mut self, input: std::option::Option<bool>) -> Self {
            self.create_public_ip = input;
            self
        }
        /// Adds a key-value pair to `staging_area_tags`.
        ///
        /// To override the contents of this collection use [`set_staging_area_tags`](Self::set_staging_area_tags).
        ///
        /// <p>Replication Configuration template Staging Area Tags.</p>
        pub fn staging_area_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.staging_area_tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.staging_area_tags = Some(hash_map);
            self
        }
        /// <p>Replication Configuration template Staging Area Tags.</p>
        pub fn set_staging_area_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.staging_area_tags = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Replication Configuration template Tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Replication Configuration template Tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ReplicationConfigurationTemplate`](crate::model::ReplicationConfigurationTemplate)
        pub fn build(self) -> crate::model::ReplicationConfigurationTemplate {
            crate::model::ReplicationConfigurationTemplate {
                replication_configuration_template_id: self.replication_configuration_template_id,
                arn: self.arn,
                staging_area_subnet_id: self.staging_area_subnet_id,
                associate_default_security_group: self.associate_default_security_group,
                replication_servers_security_groups_i_ds: self
                    .replication_servers_security_groups_i_ds,
                replication_server_instance_type: self.replication_server_instance_type,
                use_dedicated_replication_server: self.use_dedicated_replication_server,
                default_large_staging_disk_type: self.default_large_staging_disk_type,
                ebs_encryption: self.ebs_encryption,
                ebs_encryption_key_arn: self.ebs_encryption_key_arn,
                bandwidth_throttling: self.bandwidth_throttling.unwrap_or_default(),
                data_plane_routing: self.data_plane_routing,
                create_public_ip: self.create_public_ip,
                staging_area_tags: self.staging_area_tags,
                tags: self.tags,
            }
        }
    }
}
impl ReplicationConfigurationTemplate {
    /// Creates a new builder-style object to manufacture [`ReplicationConfigurationTemplate`](crate::model::ReplicationConfigurationTemplate)
    pub fn builder() -> crate::model::replication_configuration_template::Builder {
        crate::model::replication_configuration_template::Builder::default()
    }
}

/// <p>Job log.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JobLog {
    /// <p>Job log event date and time.</p>
    pub log_date_time: std::option::Option<std::string::String>,
    /// <p>Job log event.</p>
    pub event: std::option::Option<crate::model::JobLogEvent>,
    /// <p>Job event data</p>
    pub event_data: std::option::Option<crate::model::JobLogEventData>,
}
impl JobLog {
    /// <p>Job log event date and time.</p>
    pub fn log_date_time(&self) -> std::option::Option<&str> {
        self.log_date_time.as_deref()
    }
    /// <p>Job log event.</p>
    pub fn event(&self) -> std::option::Option<&crate::model::JobLogEvent> {
        self.event.as_ref()
    }
    /// <p>Job event data</p>
    pub fn event_data(&self) -> std::option::Option<&crate::model::JobLogEventData> {
        self.event_data.as_ref()
    }
}
impl std::fmt::Debug for JobLog {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JobLog");
        formatter.field("log_date_time", &self.log_date_time);
        formatter.field("event", &self.event);
        formatter.field("event_data", &self.event_data);
        formatter.finish()
    }
}
/// See [`JobLog`](crate::model::JobLog)
pub mod job_log {
    /// A builder for [`JobLog`](crate::model::JobLog)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) log_date_time: std::option::Option<std::string::String>,
        pub(crate) event: std::option::Option<crate::model::JobLogEvent>,
        pub(crate) event_data: std::option::Option<crate::model::JobLogEventData>,
    }
    impl Builder {
        /// <p>Job log event date and time.</p>
        pub fn log_date_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_date_time = Some(input.into());
            self
        }
        /// <p>Job log event date and time.</p>
        pub fn set_log_date_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.log_date_time = input;
            self
        }
        /// <p>Job log event.</p>
        pub fn event(mut self, input: crate::model::JobLogEvent) -> Self {
            self.event = Some(input);
            self
        }
        /// <p>Job log event.</p>
        pub fn set_event(mut self, input: std::option::Option<crate::model::JobLogEvent>) -> Self {
            self.event = input;
            self
        }
        /// <p>Job event data</p>
        pub fn event_data(mut self, input: crate::model::JobLogEventData) -> Self {
            self.event_data = Some(input);
            self
        }
        /// <p>Job event data</p>
        pub fn set_event_data(
            mut self,
            input: std::option::Option<crate::model::JobLogEventData>,
        ) -> Self {
            self.event_data = input;
            self
        }
        /// Consumes the builder and constructs a [`JobLog`](crate::model::JobLog)
        pub fn build(self) -> crate::model::JobLog {
            crate::model::JobLog {
                log_date_time: self.log_date_time,
                event: self.event,
                event_data: self.event_data,
            }
        }
    }
}
impl JobLog {
    /// Creates a new builder-style object to manufacture [`JobLog`](crate::model::JobLog)
    pub fn builder() -> crate::model::job_log::Builder {
        crate::model::job_log::Builder::default()
    }
}

/// <p>Job log data</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JobLogEventData {
    /// <p>Job Event Source Server ID.</p>
    pub source_server_id: std::option::Option<std::string::String>,
    /// <p>Job Event conversion Server ID.</p>
    pub conversion_server_id: std::option::Option<std::string::String>,
    /// <p>Job Event Target instance ID.</p>
    pub target_instance_id: std::option::Option<std::string::String>,
    /// <p>Job error.</p>
    pub raw_error: std::option::Option<std::string::String>,
}
impl JobLogEventData {
    /// <p>Job Event Source Server ID.</p>
    pub fn source_server_id(&self) -> std::option::Option<&str> {
        self.source_server_id.as_deref()
    }
    /// <p>Job Event conversion Server ID.</p>
    pub fn conversion_server_id(&self) -> std::option::Option<&str> {
        self.conversion_server_id.as_deref()
    }
    /// <p>Job Event Target instance ID.</p>
    pub fn target_instance_id(&self) -> std::option::Option<&str> {
        self.target_instance_id.as_deref()
    }
    /// <p>Job error.</p>
    pub fn raw_error(&self) -> std::option::Option<&str> {
        self.raw_error.as_deref()
    }
}
impl std::fmt::Debug for JobLogEventData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JobLogEventData");
        formatter.field("source_server_id", &self.source_server_id);
        formatter.field("conversion_server_id", &self.conversion_server_id);
        formatter.field("target_instance_id", &self.target_instance_id);
        formatter.field("raw_error", &self.raw_error);
        formatter.finish()
    }
}
/// See [`JobLogEventData`](crate::model::JobLogEventData)
pub mod job_log_event_data {
    /// A builder for [`JobLogEventData`](crate::model::JobLogEventData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_server_id: std::option::Option<std::string::String>,
        pub(crate) conversion_server_id: std::option::Option<std::string::String>,
        pub(crate) target_instance_id: std::option::Option<std::string::String>,
        pub(crate) raw_error: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Job Event Source Server ID.</p>
        pub fn source_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_server_id = Some(input.into());
            self
        }
        /// <p>Job Event Source Server ID.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_server_id = input;
            self
        }
        /// <p>Job Event conversion Server ID.</p>
        pub fn conversion_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.conversion_server_id = Some(input.into());
            self
        }
        /// <p>Job Event conversion Server ID.</p>
        pub fn set_conversion_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.conversion_server_id = input;
            self
        }
        /// <p>Job Event Target instance ID.</p>
        pub fn target_instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_instance_id = Some(input.into());
            self
        }
        /// <p>Job Event Target instance ID.</p>
        pub fn set_target_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_instance_id = input;
            self
        }
        /// <p>Job error.</p>
        pub fn raw_error(mut self, input: impl Into<std::string::String>) -> Self {
            self.raw_error = Some(input.into());
            self
        }
        /// <p>Job error.</p>
        pub fn set_raw_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.raw_error = input;
            self
        }
        /// Consumes the builder and constructs a [`JobLogEventData`](crate::model::JobLogEventData)
        pub fn build(self) -> crate::model::JobLogEventData {
            crate::model::JobLogEventData {
                source_server_id: self.source_server_id,
                conversion_server_id: self.conversion_server_id,
                target_instance_id: self.target_instance_id,
                raw_error: self.raw_error,
            }
        }
    }
}
impl JobLogEventData {
    /// Creates a new builder-style object to manufacture [`JobLogEventData`](crate::model::JobLogEventData)
    pub fn builder() -> crate::model::job_log_event_data::Builder {
        crate::model::job_log_event_data::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum JobLogEvent {
    #[allow(missing_docs)] // documentation missing in model
    CleanupEnd,
    #[allow(missing_docs)] // documentation missing in model
    CleanupFail,
    #[allow(missing_docs)] // documentation missing in model
    CleanupStart,
    #[allow(missing_docs)] // documentation missing in model
    ConversionEnd,
    #[allow(missing_docs)] // documentation missing in model
    ConversionFail,
    #[allow(missing_docs)] // documentation missing in model
    ConversionStart,
    #[allow(missing_docs)] // documentation missing in model
    JobCancel,
    #[allow(missing_docs)] // documentation missing in model
    JobEnd,
    #[allow(missing_docs)] // documentation missing in model
    JobStart,
    #[allow(missing_docs)] // documentation missing in model
    LaunchFailed,
    #[allow(missing_docs)] // documentation missing in model
    LaunchStart,
    #[allow(missing_docs)] // documentation missing in model
    ServerSkipped,
    #[allow(missing_docs)] // documentation missing in model
    SnapshotEnd,
    #[allow(missing_docs)] // documentation missing in model
    SnapshotFail,
    #[allow(missing_docs)] // documentation missing in model
    SnapshotStart,
    #[allow(missing_docs)] // documentation missing in model
    UsingPreviousSnapshot,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for JobLogEvent {
    fn from(s: &str) -> Self {
        match s {
            "CLEANUP_END" => JobLogEvent::CleanupEnd,
            "CLEANUP_FAIL" => JobLogEvent::CleanupFail,
            "CLEANUP_START" => JobLogEvent::CleanupStart,
            "CONVERSION_END" => JobLogEvent::ConversionEnd,
            "CONVERSION_FAIL" => JobLogEvent::ConversionFail,
            "CONVERSION_START" => JobLogEvent::ConversionStart,
            "JOB_CANCEL" => JobLogEvent::JobCancel,
            "JOB_END" => JobLogEvent::JobEnd,
            "JOB_START" => JobLogEvent::JobStart,
            "LAUNCH_FAILED" => JobLogEvent::LaunchFailed,
            "LAUNCH_START" => JobLogEvent::LaunchStart,
            "SERVER_SKIPPED" => JobLogEvent::ServerSkipped,
            "SNAPSHOT_END" => JobLogEvent::SnapshotEnd,
            "SNAPSHOT_FAIL" => JobLogEvent::SnapshotFail,
            "SNAPSHOT_START" => JobLogEvent::SnapshotStart,
            "USING_PREVIOUS_SNAPSHOT" => JobLogEvent::UsingPreviousSnapshot,
            other => JobLogEvent::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for JobLogEvent {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(JobLogEvent::from(s))
    }
}
impl JobLogEvent {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            JobLogEvent::CleanupEnd => "CLEANUP_END",
            JobLogEvent::CleanupFail => "CLEANUP_FAIL",
            JobLogEvent::CleanupStart => "CLEANUP_START",
            JobLogEvent::ConversionEnd => "CONVERSION_END",
            JobLogEvent::ConversionFail => "CONVERSION_FAIL",
            JobLogEvent::ConversionStart => "CONVERSION_START",
            JobLogEvent::JobCancel => "JOB_CANCEL",
            JobLogEvent::JobEnd => "JOB_END",
            JobLogEvent::JobStart => "JOB_START",
            JobLogEvent::LaunchFailed => "LAUNCH_FAILED",
            JobLogEvent::LaunchStart => "LAUNCH_START",
            JobLogEvent::ServerSkipped => "SERVER_SKIPPED",
            JobLogEvent::SnapshotEnd => "SNAPSHOT_END",
            JobLogEvent::SnapshotFail => "SNAPSHOT_FAIL",
            JobLogEvent::SnapshotStart => "SNAPSHOT_START",
            JobLogEvent::UsingPreviousSnapshot => "USING_PREVIOUS_SNAPSHOT",
            JobLogEvent::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CLEANUP_END",
            "CLEANUP_FAIL",
            "CLEANUP_START",
            "CONVERSION_END",
            "CONVERSION_FAIL",
            "CONVERSION_START",
            "JOB_CANCEL",
            "JOB_END",
            "JOB_START",
            "LAUNCH_FAILED",
            "LAUNCH_START",
            "SERVER_SKIPPED",
            "SNAPSHOT_END",
            "SNAPSHOT_FAIL",
            "SNAPSHOT_START",
            "USING_PREVIOUS_SNAPSHOT",
        ]
    }
}
impl AsRef<str> for JobLogEvent {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Request to describe Job log filters.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeJobsRequestFilters {
    /// <p>Request to describe Job log filters by job ID.</p>
    pub job_i_ds: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Request to describe Job log filters by date.</p>
    pub from_date: std::option::Option<std::string::String>,
    /// <p>Request to describe job log items by last date.</p>
    pub to_date: std::option::Option<std::string::String>,
}
impl DescribeJobsRequestFilters {
    /// <p>Request to describe Job log filters by job ID.</p>
    pub fn job_i_ds(&self) -> std::option::Option<&[std::string::String]> {
        self.job_i_ds.as_deref()
    }
    /// <p>Request to describe Job log filters by date.</p>
    pub fn from_date(&self) -> std::option::Option<&str> {
        self.from_date.as_deref()
    }
    /// <p>Request to describe job log items by last date.</p>
    pub fn to_date(&self) -> std::option::Option<&str> {
        self.to_date.as_deref()
    }
}
impl std::fmt::Debug for DescribeJobsRequestFilters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeJobsRequestFilters");
        formatter.field("job_i_ds", &self.job_i_ds);
        formatter.field("from_date", &self.from_date);
        formatter.field("to_date", &self.to_date);
        formatter.finish()
    }
}
/// See [`DescribeJobsRequestFilters`](crate::model::DescribeJobsRequestFilters)
pub mod describe_jobs_request_filters {
    /// A builder for [`DescribeJobsRequestFilters`](crate::model::DescribeJobsRequestFilters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_i_ds: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) from_date: std::option::Option<std::string::String>,
        pub(crate) to_date: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `job_i_ds`.
        ///
        /// To override the contents of this collection use [`set_job_i_ds`](Self::set_job_i_ds).
        ///
        /// <p>Request to describe Job log filters by job ID.</p>
        pub fn job_i_ds(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.job_i_ds.unwrap_or_default();
            v.push(input.into());
            self.job_i_ds = Some(v);
            self
        }
        /// <p>Request to describe Job log filters by job ID.</p>
        pub fn set_job_i_ds(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.job_i_ds = input;
            self
        }
        /// <p>Request to describe Job log filters by date.</p>
        pub fn from_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.from_date = Some(input.into());
            self
        }
        /// <p>Request to describe Job log filters by date.</p>
        pub fn set_from_date(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.from_date = input;
            self
        }
        /// <p>Request to describe job log items by last date.</p>
        pub fn to_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.to_date = Some(input.into());
            self
        }
        /// <p>Request to describe job log items by last date.</p>
        pub fn set_to_date(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.to_date = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeJobsRequestFilters`](crate::model::DescribeJobsRequestFilters)
        pub fn build(self) -> crate::model::DescribeJobsRequestFilters {
            crate::model::DescribeJobsRequestFilters {
                job_i_ds: self.job_i_ds,
                from_date: self.from_date,
                to_date: self.to_date,
            }
        }
    }
}
impl DescribeJobsRequestFilters {
    /// Creates a new builder-style object to manufacture [`DescribeJobsRequestFilters`](crate::model::DescribeJobsRequestFilters)
    pub fn builder() -> crate::model::describe_jobs_request_filters::Builder {
        crate::model::describe_jobs_request_filters::Builder::default()
    }
}
