// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Application Migration Service
///
/// Client for invoking operations on Application Migration Service. Each operation on Application Migration Service is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_mgn::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_mgn::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_mgn::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`ChangeServerLifeCycleState`](crate::client::fluent_builders::ChangeServerLifeCycleState) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`source_server_id(impl Into<String>)`](crate::client::fluent_builders::ChangeServerLifeCycleState::source_server_id) / [`set_source_server_id(Option<String>)`](crate::client::fluent_builders::ChangeServerLifeCycleState::set_source_server_id): <p>The request to change the source server migration lifecycle state by source server ID.</p>
    ///   - [`life_cycle(ChangeServerLifeCycleStateSourceServerLifecycle)`](crate::client::fluent_builders::ChangeServerLifeCycleState::life_cycle) / [`set_life_cycle(Option<ChangeServerLifeCycleStateSourceServerLifecycle>)`](crate::client::fluent_builders::ChangeServerLifeCycleState::set_life_cycle): <p>The request to change the source server migration lifecycle state.</p>
    /// - On success, responds with [`ChangeServerLifeCycleStateOutput`](crate::output::ChangeServerLifeCycleStateOutput) with field(s):
    ///   - [`source_server_id(Option<String>)`](crate::output::ChangeServerLifeCycleStateOutput::source_server_id): <p>Source server ID.</p>
    ///   - [`arn(Option<String>)`](crate::output::ChangeServerLifeCycleStateOutput::arn): <p>Source server ARN.</p>
    ///   - [`is_archived(Option<bool>)`](crate::output::ChangeServerLifeCycleStateOutput::is_archived): <p>Source server archived status.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ChangeServerLifeCycleStateOutput::tags): <p>Source server Tags.</p>
    ///   - [`launched_instance(Option<LaunchedInstance>)`](crate::output::ChangeServerLifeCycleStateOutput::launched_instance): <p>Source server launched instance.</p>
    ///   - [`data_replication_info(Option<DataReplicationInfo>)`](crate::output::ChangeServerLifeCycleStateOutput::data_replication_info): <p>Source server data replication info.</p>
    ///   - [`life_cycle(Option<LifeCycle>)`](crate::output::ChangeServerLifeCycleStateOutput::life_cycle): <p>Source server lifecycle state.</p>
    ///   - [`source_properties(Option<SourceProperties>)`](crate::output::ChangeServerLifeCycleStateOutput::source_properties): <p>Source server properties.</p>
    ///   - [`replication_type(Option<ReplicationType>)`](crate::output::ChangeServerLifeCycleStateOutput::replication_type): <p>Source server replication type.</p>
    ///   - [`vcenter_client_id(Option<String>)`](crate::output::ChangeServerLifeCycleStateOutput::vcenter_client_id): <p>Source server vCenter client id.</p>
    /// - On failure, responds with [`SdkError<ChangeServerLifeCycleStateError>`](crate::error::ChangeServerLifeCycleStateError)
    pub fn change_server_life_cycle_state(&self) -> fluent_builders::ChangeServerLifeCycleState {
        fluent_builders::ChangeServerLifeCycleState::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateReplicationConfigurationTemplate`](crate::client::fluent_builders::CreateReplicationConfigurationTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`staging_area_subnet_id(impl Into<String>)`](crate::client::fluent_builders::CreateReplicationConfigurationTemplate::staging_area_subnet_id) / [`set_staging_area_subnet_id(Option<String>)`](crate::client::fluent_builders::CreateReplicationConfigurationTemplate::set_staging_area_subnet_id): <p>Request to configure the Staging Area subnet ID during Replication Settings template creation.</p>
    ///   - [`associate_default_security_group(bool)`](crate::client::fluent_builders::CreateReplicationConfigurationTemplate::associate_default_security_group) / [`set_associate_default_security_group(Option<bool>)`](crate::client::fluent_builders::CreateReplicationConfigurationTemplate::set_associate_default_security_group): <p>Request to associate the default Application Migration Service Security group with the Replication Settings template.</p>
    ///   - [`replication_servers_security_groups_i_ds(Vec<String>)`](crate::client::fluent_builders::CreateReplicationConfigurationTemplate::replication_servers_security_groups_i_ds) / [`set_replication_servers_security_groups_i_ds(Option<Vec<String>>)`](crate::client::fluent_builders::CreateReplicationConfigurationTemplate::set_replication_servers_security_groups_i_ds): <p>Request to configure the Replication Server Security group ID during Replication Settings template creation.</p>
    ///   - [`replication_server_instance_type(impl Into<String>)`](crate::client::fluent_builders::CreateReplicationConfigurationTemplate::replication_server_instance_type) / [`set_replication_server_instance_type(Option<String>)`](crate::client::fluent_builders::CreateReplicationConfigurationTemplate::set_replication_server_instance_type): <p>Request to configure the Replication Server instance type during Replication Settings template creation.</p>
    ///   - [`use_dedicated_replication_server(bool)`](crate::client::fluent_builders::CreateReplicationConfigurationTemplate::use_dedicated_replication_server) / [`set_use_dedicated_replication_server(Option<bool>)`](crate::client::fluent_builders::CreateReplicationConfigurationTemplate::set_use_dedicated_replication_server): <p>Request to use Dedicated Replication Servers during Replication Settings template creation.</p>
    ///   - [`default_large_staging_disk_type(ReplicationConfigurationDefaultLargeStagingDiskType)`](crate::client::fluent_builders::CreateReplicationConfigurationTemplate::default_large_staging_disk_type) / [`set_default_large_staging_disk_type(Option<ReplicationConfigurationDefaultLargeStagingDiskType>)`](crate::client::fluent_builders::CreateReplicationConfigurationTemplate::set_default_large_staging_disk_type): <p>Request to configure the default large staging disk EBS volume type during Replication Settings template creation.</p>
    ///   - [`ebs_encryption(ReplicationConfigurationEbsEncryption)`](crate::client::fluent_builders::CreateReplicationConfigurationTemplate::ebs_encryption) / [`set_ebs_encryption(Option<ReplicationConfigurationEbsEncryption>)`](crate::client::fluent_builders::CreateReplicationConfigurationTemplate::set_ebs_encryption): <p>Request to configure EBS encryption during Replication Settings template creation.</p>
    ///   - [`ebs_encryption_key_arn(impl Into<String>)`](crate::client::fluent_builders::CreateReplicationConfigurationTemplate::ebs_encryption_key_arn) / [`set_ebs_encryption_key_arn(Option<String>)`](crate::client::fluent_builders::CreateReplicationConfigurationTemplate::set_ebs_encryption_key_arn): <p>Request to configure an EBS encryption key during Replication Settings template creation.</p>
    ///   - [`bandwidth_throttling(i64)`](crate::client::fluent_builders::CreateReplicationConfigurationTemplate::bandwidth_throttling) / [`set_bandwidth_throttling(i64)`](crate::client::fluent_builders::CreateReplicationConfigurationTemplate::set_bandwidth_throttling): <p>Request to configure bandwidth throttling during Replication Settings template creation.</p>
    ///   - [`data_plane_routing(ReplicationConfigurationDataPlaneRouting)`](crate::client::fluent_builders::CreateReplicationConfigurationTemplate::data_plane_routing) / [`set_data_plane_routing(Option<ReplicationConfigurationDataPlaneRouting>)`](crate::client::fluent_builders::CreateReplicationConfigurationTemplate::set_data_plane_routing): <p>Request to configure data plane routing during Replication Settings template creation.</p>
    ///   - [`create_public_ip(bool)`](crate::client::fluent_builders::CreateReplicationConfigurationTemplate::create_public_ip) / [`set_create_public_ip(Option<bool>)`](crate::client::fluent_builders::CreateReplicationConfigurationTemplate::set_create_public_ip): <p>Request to create Public IP during Replication Settings template creation.</p>
    ///   - [`staging_area_tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateReplicationConfigurationTemplate::staging_area_tags) / [`set_staging_area_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateReplicationConfigurationTemplate::set_staging_area_tags): <p>Request to configure Staging Area tags during Replication Settings template creation.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateReplicationConfigurationTemplate::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateReplicationConfigurationTemplate::set_tags): <p>Request to configure tags during Replication Settings template creation.</p>
    /// - On success, responds with [`CreateReplicationConfigurationTemplateOutput`](crate::output::CreateReplicationConfigurationTemplateOutput) with field(s):
    ///   - [`replication_configuration_template_id(Option<String>)`](crate::output::CreateReplicationConfigurationTemplateOutput::replication_configuration_template_id): <p>Replication Configuration template ID.</p>
    ///   - [`arn(Option<String>)`](crate::output::CreateReplicationConfigurationTemplateOutput::arn): <p>Replication Configuration template ARN.</p>
    ///   - [`staging_area_subnet_id(Option<String>)`](crate::output::CreateReplicationConfigurationTemplateOutput::staging_area_subnet_id): <p>Replication Configuration template Staging Area subnet ID.</p>
    ///   - [`associate_default_security_group(Option<bool>)`](crate::output::CreateReplicationConfigurationTemplateOutput::associate_default_security_group): <p>Replication Configuration template associate default Application Migration Service Security group.</p>
    ///   - [`replication_servers_security_groups_i_ds(Option<Vec<String>>)`](crate::output::CreateReplicationConfigurationTemplateOutput::replication_servers_security_groups_i_ds): <p>Replication Configuration template server Security Groups IDs.</p>
    ///   - [`replication_server_instance_type(Option<String>)`](crate::output::CreateReplicationConfigurationTemplateOutput::replication_server_instance_type): <p>Replication Configuration template server instance type.</p>
    ///   - [`use_dedicated_replication_server(Option<bool>)`](crate::output::CreateReplicationConfigurationTemplateOutput::use_dedicated_replication_server): <p>Replication Configuration template use Dedicated Replication Server.</p>
    ///   - [`default_large_staging_disk_type(Option<ReplicationConfigurationDefaultLargeStagingDiskType>)`](crate::output::CreateReplicationConfigurationTemplateOutput::default_large_staging_disk_type): <p>Replication Configuration template use default large Staging Disk type.</p>
    ///   - [`ebs_encryption(Option<ReplicationConfigurationEbsEncryption>)`](crate::output::CreateReplicationConfigurationTemplateOutput::ebs_encryption): <p>Replication Configuration template EBS encryption.</p>
    ///   - [`ebs_encryption_key_arn(Option<String>)`](crate::output::CreateReplicationConfigurationTemplateOutput::ebs_encryption_key_arn): <p>Replication Configuration template EBS encryption key ARN.</p>
    ///   - [`bandwidth_throttling(i64)`](crate::output::CreateReplicationConfigurationTemplateOutput::bandwidth_throttling): <p>Replication Configuration template bandwidth throttling.</p>
    ///   - [`data_plane_routing(Option<ReplicationConfigurationDataPlaneRouting>)`](crate::output::CreateReplicationConfigurationTemplateOutput::data_plane_routing): <p>Replication Configuration template data plane routing.</p>
    ///   - [`create_public_ip(Option<bool>)`](crate::output::CreateReplicationConfigurationTemplateOutput::create_public_ip): <p>Replication Configuration template create Public IP.</p>
    ///   - [`staging_area_tags(Option<HashMap<String, String>>)`](crate::output::CreateReplicationConfigurationTemplateOutput::staging_area_tags): <p>Replication Configuration template Staging Area Tags.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::CreateReplicationConfigurationTemplateOutput::tags): <p>Replication Configuration template Tags.</p>
    /// - On failure, responds with [`SdkError<CreateReplicationConfigurationTemplateError>`](crate::error::CreateReplicationConfigurationTemplateError)
    pub fn create_replication_configuration_template(
        &self,
    ) -> fluent_builders::CreateReplicationConfigurationTemplate {
        fluent_builders::CreateReplicationConfigurationTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteJob`](crate::client::fluent_builders::DeleteJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::DeleteJob::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::DeleteJob::set_job_id): <p>Request to delete Job from service by Job ID.</p>
    /// - On success, responds with [`DeleteJobOutput`](crate::output::DeleteJobOutput)

    /// - On failure, responds with [`SdkError<DeleteJobError>`](crate::error::DeleteJobError)
    pub fn delete_job(&self) -> fluent_builders::DeleteJob {
        fluent_builders::DeleteJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteReplicationConfigurationTemplate`](crate::client::fluent_builders::DeleteReplicationConfigurationTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`replication_configuration_template_id(impl Into<String>)`](crate::client::fluent_builders::DeleteReplicationConfigurationTemplate::replication_configuration_template_id) / [`set_replication_configuration_template_id(Option<String>)`](crate::client::fluent_builders::DeleteReplicationConfigurationTemplate::set_replication_configuration_template_id): <p>Request to delete Replication Configuration Template from service by Replication Configuration Template ID.</p>
    /// - On success, responds with [`DeleteReplicationConfigurationTemplateOutput`](crate::output::DeleteReplicationConfigurationTemplateOutput)

    /// - On failure, responds with [`SdkError<DeleteReplicationConfigurationTemplateError>`](crate::error::DeleteReplicationConfigurationTemplateError)
    pub fn delete_replication_configuration_template(
        &self,
    ) -> fluent_builders::DeleteReplicationConfigurationTemplate {
        fluent_builders::DeleteReplicationConfigurationTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteSourceServer`](crate::client::fluent_builders::DeleteSourceServer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`source_server_id(impl Into<String>)`](crate::client::fluent_builders::DeleteSourceServer::source_server_id) / [`set_source_server_id(Option<String>)`](crate::client::fluent_builders::DeleteSourceServer::set_source_server_id): <p>Request to delete Source Server from service by Server ID.</p>
    /// - On success, responds with [`DeleteSourceServerOutput`](crate::output::DeleteSourceServerOutput)

    /// - On failure, responds with [`SdkError<DeleteSourceServerError>`](crate::error::DeleteSourceServerError)
    pub fn delete_source_server(&self) -> fluent_builders::DeleteSourceServer {
        fluent_builders::DeleteSourceServer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteVcenterClient`](crate::client::fluent_builders::DeleteVcenterClient) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`vcenter_client_id(impl Into<String>)`](crate::client::fluent_builders::DeleteVcenterClient::vcenter_client_id) / [`set_vcenter_client_id(Option<String>)`](crate::client::fluent_builders::DeleteVcenterClient::set_vcenter_client_id): <p>ID of resource to be deleted.</p>
    /// - On success, responds with [`DeleteVcenterClientOutput`](crate::output::DeleteVcenterClientOutput)

    /// - On failure, responds with [`SdkError<DeleteVcenterClientError>`](crate::error::DeleteVcenterClientError)
    pub fn delete_vcenter_client(&self) -> fluent_builders::DeleteVcenterClient {
        fluent_builders::DeleteVcenterClient::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeJobLogItems`](crate::client::fluent_builders::DescribeJobLogItems) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeJobLogItems::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::DescribeJobLogItems::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::DescribeJobLogItems::set_job_id): <p>Request to describe Job log job ID.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeJobLogItems::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::DescribeJobLogItems::set_max_results): <p>Request to describe Job log item maximum results.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeJobLogItems::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeJobLogItems::set_next_token): <p>Request to describe Job log next token.</p>
    /// - On success, responds with [`DescribeJobLogItemsOutput`](crate::output::DescribeJobLogItemsOutput) with field(s):
    ///   - [`items(Option<Vec<JobLog>>)`](crate::output::DescribeJobLogItemsOutput::items): <p>Request to describe Job log response items.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeJobLogItemsOutput::next_token): <p>Request to describe Job log response next token.</p>
    /// - On failure, responds with [`SdkError<DescribeJobLogItemsError>`](crate::error::DescribeJobLogItemsError)
    pub fn describe_job_log_items(&self) -> fluent_builders::DescribeJobLogItems {
        fluent_builders::DescribeJobLogItems::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeJobs`](crate::client::fluent_builders::DescribeJobs) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeJobs::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(DescribeJobsRequestFilters)`](crate::client::fluent_builders::DescribeJobs::filters) / [`set_filters(Option<DescribeJobsRequestFilters>)`](crate::client::fluent_builders::DescribeJobs::set_filters): <p>Request to describe Job log filters.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeJobs::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::DescribeJobs::set_max_results): <p>Request to describe job log items by max results.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeJobs::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeJobs::set_next_token): <p>Request to describe job log items by next token.</p>
    /// - On success, responds with [`DescribeJobsOutput`](crate::output::DescribeJobsOutput) with field(s):
    ///   - [`items(Option<Vec<Job>>)`](crate::output::DescribeJobsOutput::items): <p>Request to describe Job log items.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeJobsOutput::next_token): <p>Request to describe Job response by next token.</p>
    /// - On failure, responds with [`SdkError<DescribeJobsError>`](crate::error::DescribeJobsError)
    pub fn describe_jobs(&self) -> fluent_builders::DescribeJobs {
        fluent_builders::DescribeJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeReplicationConfigurationTemplates`](crate::client::fluent_builders::DescribeReplicationConfigurationTemplates) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeReplicationConfigurationTemplates::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`replication_configuration_template_i_ds(Vec<String>)`](crate::client::fluent_builders::DescribeReplicationConfigurationTemplates::replication_configuration_template_i_ds) / [`set_replication_configuration_template_i_ds(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeReplicationConfigurationTemplates::set_replication_configuration_template_i_ds): <p>Request to describe Replication Configuration template by template IDs.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeReplicationConfigurationTemplates::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::DescribeReplicationConfigurationTemplates::set_max_results): <p>Request to describe Replication Configuration template by max results.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeReplicationConfigurationTemplates::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeReplicationConfigurationTemplates::set_next_token): <p>Request to describe Replication Configuration template by next token.</p>
    /// - On success, responds with [`DescribeReplicationConfigurationTemplatesOutput`](crate::output::DescribeReplicationConfigurationTemplatesOutput) with field(s):
    ///   - [`items(Option<Vec<ReplicationConfigurationTemplate>>)`](crate::output::DescribeReplicationConfigurationTemplatesOutput::items): <p>Request to describe Replication Configuration template by items.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeReplicationConfigurationTemplatesOutput::next_token): <p>Request to describe Replication Configuration template by next token.</p>
    /// - On failure, responds with [`SdkError<DescribeReplicationConfigurationTemplatesError>`](crate::error::DescribeReplicationConfigurationTemplatesError)
    pub fn describe_replication_configuration_templates(
        &self,
    ) -> fluent_builders::DescribeReplicationConfigurationTemplates {
        fluent_builders::DescribeReplicationConfigurationTemplates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeSourceServers`](crate::client::fluent_builders::DescribeSourceServers) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeSourceServers::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(DescribeSourceServersRequestFilters)`](crate::client::fluent_builders::DescribeSourceServers::filters) / [`set_filters(Option<DescribeSourceServersRequestFilters>)`](crate::client::fluent_builders::DescribeSourceServers::set_filters): <p>Request to filter Source Servers list.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeSourceServers::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::DescribeSourceServers::set_max_results): <p>Request to filter Source Servers list by maximum results.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeSourceServers::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeSourceServers::set_next_token): <p>Request to filter Source Servers list by next token.</p>
    /// - On success, responds with [`DescribeSourceServersOutput`](crate::output::DescribeSourceServersOutput) with field(s):
    ///   - [`items(Option<Vec<SourceServer>>)`](crate::output::DescribeSourceServersOutput::items): <p>Request to filter Source Servers list by item.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeSourceServersOutput::next_token): <p>Request to filter Source Servers next token.</p>
    /// - On failure, responds with [`SdkError<DescribeSourceServersError>`](crate::error::DescribeSourceServersError)
    pub fn describe_source_servers(&self) -> fluent_builders::DescribeSourceServers {
        fluent_builders::DescribeSourceServers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeVcenterClients`](crate::client::fluent_builders::DescribeVcenterClients) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeVcenterClients::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeVcenterClients::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::DescribeVcenterClients::set_max_results): <p>Maximum results to be returned in DescribeVcenterClients.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeVcenterClients::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeVcenterClients::set_next_token): <p>Next pagination token to be provided for DescribeVcenterClients.</p>
    /// - On success, responds with [`DescribeVcenterClientsOutput`](crate::output::DescribeVcenterClientsOutput) with field(s):
    ///   - [`items(Option<Vec<VcenterClient>>)`](crate::output::DescribeVcenterClientsOutput::items): <p>List of items returned by DescribeVcenterClients.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeVcenterClientsOutput::next_token): <p>Next pagination token returned from DescribeVcenterClients.</p>
    /// - On failure, responds with [`SdkError<DescribeVcenterClientsError>`](crate::error::DescribeVcenterClientsError)
    pub fn describe_vcenter_clients(&self) -> fluent_builders::DescribeVcenterClients {
        fluent_builders::DescribeVcenterClients::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisconnectFromService`](crate::client::fluent_builders::DisconnectFromService) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`source_server_id(impl Into<String>)`](crate::client::fluent_builders::DisconnectFromService::source_server_id) / [`set_source_server_id(Option<String>)`](crate::client::fluent_builders::DisconnectFromService::set_source_server_id): <p>Request to disconnect Source Server from service by Server ID.</p>
    /// - On success, responds with [`DisconnectFromServiceOutput`](crate::output::DisconnectFromServiceOutput) with field(s):
    ///   - [`source_server_id(Option<String>)`](crate::output::DisconnectFromServiceOutput::source_server_id): <p>Source server ID.</p>
    ///   - [`arn(Option<String>)`](crate::output::DisconnectFromServiceOutput::arn): <p>Source server ARN.</p>
    ///   - [`is_archived(Option<bool>)`](crate::output::DisconnectFromServiceOutput::is_archived): <p>Source server archived status.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::DisconnectFromServiceOutput::tags): <p>Source server Tags.</p>
    ///   - [`launched_instance(Option<LaunchedInstance>)`](crate::output::DisconnectFromServiceOutput::launched_instance): <p>Source server launched instance.</p>
    ///   - [`data_replication_info(Option<DataReplicationInfo>)`](crate::output::DisconnectFromServiceOutput::data_replication_info): <p>Source server data replication info.</p>
    ///   - [`life_cycle(Option<LifeCycle>)`](crate::output::DisconnectFromServiceOutput::life_cycle): <p>Source server lifecycle state.</p>
    ///   - [`source_properties(Option<SourceProperties>)`](crate::output::DisconnectFromServiceOutput::source_properties): <p>Source server properties.</p>
    ///   - [`replication_type(Option<ReplicationType>)`](crate::output::DisconnectFromServiceOutput::replication_type): <p>Source server replication type.</p>
    ///   - [`vcenter_client_id(Option<String>)`](crate::output::DisconnectFromServiceOutput::vcenter_client_id): <p>Source server vCenter client id.</p>
    /// - On failure, responds with [`SdkError<DisconnectFromServiceError>`](crate::error::DisconnectFromServiceError)
    pub fn disconnect_from_service(&self) -> fluent_builders::DisconnectFromService {
        fluent_builders::DisconnectFromService::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`FinalizeCutover`](crate::client::fluent_builders::FinalizeCutover) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`source_server_id(impl Into<String>)`](crate::client::fluent_builders::FinalizeCutover::source_server_id) / [`set_source_server_id(Option<String>)`](crate::client::fluent_builders::FinalizeCutover::set_source_server_id): <p>Request to finalize Cutover by Source Server ID.</p>
    /// - On success, responds with [`FinalizeCutoverOutput`](crate::output::FinalizeCutoverOutput) with field(s):
    ///   - [`source_server_id(Option<String>)`](crate::output::FinalizeCutoverOutput::source_server_id): <p>Source server ID.</p>
    ///   - [`arn(Option<String>)`](crate::output::FinalizeCutoverOutput::arn): <p>Source server ARN.</p>
    ///   - [`is_archived(Option<bool>)`](crate::output::FinalizeCutoverOutput::is_archived): <p>Source server archived status.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::FinalizeCutoverOutput::tags): <p>Source server Tags.</p>
    ///   - [`launched_instance(Option<LaunchedInstance>)`](crate::output::FinalizeCutoverOutput::launched_instance): <p>Source server launched instance.</p>
    ///   - [`data_replication_info(Option<DataReplicationInfo>)`](crate::output::FinalizeCutoverOutput::data_replication_info): <p>Source server data replication info.</p>
    ///   - [`life_cycle(Option<LifeCycle>)`](crate::output::FinalizeCutoverOutput::life_cycle): <p>Source server lifecycle state.</p>
    ///   - [`source_properties(Option<SourceProperties>)`](crate::output::FinalizeCutoverOutput::source_properties): <p>Source server properties.</p>
    ///   - [`replication_type(Option<ReplicationType>)`](crate::output::FinalizeCutoverOutput::replication_type): <p>Source server replication type.</p>
    ///   - [`vcenter_client_id(Option<String>)`](crate::output::FinalizeCutoverOutput::vcenter_client_id): <p>Source server vCenter client id.</p>
    /// - On failure, responds with [`SdkError<FinalizeCutoverError>`](crate::error::FinalizeCutoverError)
    pub fn finalize_cutover(&self) -> fluent_builders::FinalizeCutover {
        fluent_builders::FinalizeCutover::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetLaunchConfiguration`](crate::client::fluent_builders::GetLaunchConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`source_server_id(impl Into<String>)`](crate::client::fluent_builders::GetLaunchConfiguration::source_server_id) / [`set_source_server_id(Option<String>)`](crate::client::fluent_builders::GetLaunchConfiguration::set_source_server_id): <p>Request to get Launch Configuration information by Source Server ID.</p>
    /// - On success, responds with [`GetLaunchConfigurationOutput`](crate::output::GetLaunchConfigurationOutput) with field(s):
    ///   - [`source_server_id(Option<String>)`](crate::output::GetLaunchConfigurationOutput::source_server_id): <p>Launch configuration Source Server ID.</p>
    ///   - [`name(Option<String>)`](crate::output::GetLaunchConfigurationOutput::name): <p>Launch configuration name.</p>
    ///   - [`ec2_launch_template_id(Option<String>)`](crate::output::GetLaunchConfigurationOutput::ec2_launch_template_id): <p>Launch configuration EC2 Launch template ID.</p>
    ///   - [`launch_disposition(Option<LaunchDisposition>)`](crate::output::GetLaunchConfigurationOutput::launch_disposition): <p>Launch disposition for launch configuration.</p>
    ///   - [`target_instance_type_right_sizing_method(Option<TargetInstanceTypeRightSizingMethod>)`](crate::output::GetLaunchConfigurationOutput::target_instance_type_right_sizing_method): <p>Launch configuration Target instance type right sizing method.</p>
    ///   - [`copy_private_ip(Option<bool>)`](crate::output::GetLaunchConfigurationOutput::copy_private_ip): <p>Copy Private IP during Launch Configuration.</p>
    ///   - [`copy_tags(Option<bool>)`](crate::output::GetLaunchConfigurationOutput::copy_tags): <p>Copy Tags during Launch Configuration.</p>
    ///   - [`licensing(Option<Licensing>)`](crate::output::GetLaunchConfigurationOutput::licensing): <p>Launch configuration OS licensing.</p>
    ///   - [`boot_mode(Option<BootMode>)`](crate::output::GetLaunchConfigurationOutput::boot_mode): <p>Launch configuration boot mode.</p>
    /// - On failure, responds with [`SdkError<GetLaunchConfigurationError>`](crate::error::GetLaunchConfigurationError)
    pub fn get_launch_configuration(&self) -> fluent_builders::GetLaunchConfiguration {
        fluent_builders::GetLaunchConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetReplicationConfiguration`](crate::client::fluent_builders::GetReplicationConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`source_server_id(impl Into<String>)`](crate::client::fluent_builders::GetReplicationConfiguration::source_server_id) / [`set_source_server_id(Option<String>)`](crate::client::fluent_builders::GetReplicationConfiguration::set_source_server_id): <p>Request to get Replication Configuration by Source Server ID.</p>
    /// - On success, responds with [`GetReplicationConfigurationOutput`](crate::output::GetReplicationConfigurationOutput) with field(s):
    ///   - [`source_server_id(Option<String>)`](crate::output::GetReplicationConfigurationOutput::source_server_id): <p>Replication Configuration Source Server ID.</p>
    ///   - [`name(Option<String>)`](crate::output::GetReplicationConfigurationOutput::name): <p>Replication Configuration name.</p>
    ///   - [`staging_area_subnet_id(Option<String>)`](crate::output::GetReplicationConfigurationOutput::staging_area_subnet_id): <p>Replication Configuration Staging Area subnet ID.</p>
    ///   - [`associate_default_security_group(Option<bool>)`](crate::output::GetReplicationConfigurationOutput::associate_default_security_group): <p>Replication Configuration associate default Application Migration Service Security Group.</p>
    ///   - [`replication_servers_security_groups_i_ds(Option<Vec<String>>)`](crate::output::GetReplicationConfigurationOutput::replication_servers_security_groups_i_ds): <p>Replication Configuration Replication Server Security Group IDs.</p>
    ///   - [`replication_server_instance_type(Option<String>)`](crate::output::GetReplicationConfigurationOutput::replication_server_instance_type): <p>Replication Configuration Replication Server instance type.</p>
    ///   - [`use_dedicated_replication_server(Option<bool>)`](crate::output::GetReplicationConfigurationOutput::use_dedicated_replication_server): <p>Replication Configuration use Dedicated Replication Server.</p>
    ///   - [`default_large_staging_disk_type(Option<ReplicationConfigurationDefaultLargeStagingDiskType>)`](crate::output::GetReplicationConfigurationOutput::default_large_staging_disk_type): <p>Replication Configuration use default large Staging Disks.</p>
    ///   - [`replicated_disks(Option<Vec<ReplicationConfigurationReplicatedDisk>>)`](crate::output::GetReplicationConfigurationOutput::replicated_disks): <p>Replication Configuration replicated disks.</p>
    ///   - [`ebs_encryption(Option<ReplicationConfigurationEbsEncryption>)`](crate::output::GetReplicationConfigurationOutput::ebs_encryption): <p>Replication Configuration EBS encryption.</p>
    ///   - [`ebs_encryption_key_arn(Option<String>)`](crate::output::GetReplicationConfigurationOutput::ebs_encryption_key_arn): <p>Replication Configuration EBS encryption key ARN.</p>
    ///   - [`bandwidth_throttling(i64)`](crate::output::GetReplicationConfigurationOutput::bandwidth_throttling): <p>Replication Configuration set bandwidth throttling.</p>
    ///   - [`data_plane_routing(Option<ReplicationConfigurationDataPlaneRouting>)`](crate::output::GetReplicationConfigurationOutput::data_plane_routing): <p>Replication Configuration data plane routing.</p>
    ///   - [`create_public_ip(Option<bool>)`](crate::output::GetReplicationConfigurationOutput::create_public_ip): <p>Replication Configuration create Public IP.</p>
    ///   - [`staging_area_tags(Option<HashMap<String, String>>)`](crate::output::GetReplicationConfigurationOutput::staging_area_tags): <p>Replication Configuration Staging Area tags.</p>
    /// - On failure, responds with [`SdkError<GetReplicationConfigurationError>`](crate::error::GetReplicationConfigurationError)
    pub fn get_replication_configuration(&self) -> fluent_builders::GetReplicationConfiguration {
        fluent_builders::GetReplicationConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`InitializeService`](crate::client::fluent_builders::InitializeService) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::InitializeService::send) it.

    /// - On success, responds with [`InitializeServiceOutput`](crate::output::InitializeServiceOutput)

    /// - On failure, responds with [`SdkError<InitializeServiceError>`](crate::error::InitializeServiceError)
    pub fn initialize_service(&self) -> fluent_builders::InitializeService {
        fluent_builders::InitializeService::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>List tags for resource request by ARN.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsForResourceOutput::tags): <p>List tags for resource response.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`MarkAsArchived`](crate::client::fluent_builders::MarkAsArchived) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`source_server_id(impl Into<String>)`](crate::client::fluent_builders::MarkAsArchived::source_server_id) / [`set_source_server_id(Option<String>)`](crate::client::fluent_builders::MarkAsArchived::set_source_server_id): <p>Mark as archived by Source Server ID.</p>
    /// - On success, responds with [`MarkAsArchivedOutput`](crate::output::MarkAsArchivedOutput) with field(s):
    ///   - [`source_server_id(Option<String>)`](crate::output::MarkAsArchivedOutput::source_server_id): <p>Source server ID.</p>
    ///   - [`arn(Option<String>)`](crate::output::MarkAsArchivedOutput::arn): <p>Source server ARN.</p>
    ///   - [`is_archived(Option<bool>)`](crate::output::MarkAsArchivedOutput::is_archived): <p>Source server archived status.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::MarkAsArchivedOutput::tags): <p>Source server Tags.</p>
    ///   - [`launched_instance(Option<LaunchedInstance>)`](crate::output::MarkAsArchivedOutput::launched_instance): <p>Source server launched instance.</p>
    ///   - [`data_replication_info(Option<DataReplicationInfo>)`](crate::output::MarkAsArchivedOutput::data_replication_info): <p>Source server data replication info.</p>
    ///   - [`life_cycle(Option<LifeCycle>)`](crate::output::MarkAsArchivedOutput::life_cycle): <p>Source server lifecycle state.</p>
    ///   - [`source_properties(Option<SourceProperties>)`](crate::output::MarkAsArchivedOutput::source_properties): <p>Source server properties.</p>
    ///   - [`replication_type(Option<ReplicationType>)`](crate::output::MarkAsArchivedOutput::replication_type): <p>Source server replication type.</p>
    ///   - [`vcenter_client_id(Option<String>)`](crate::output::MarkAsArchivedOutput::vcenter_client_id): <p>Source server vCenter client id.</p>
    /// - On failure, responds with [`SdkError<MarkAsArchivedError>`](crate::error::MarkAsArchivedError)
    pub fn mark_as_archived(&self) -> fluent_builders::MarkAsArchived {
        fluent_builders::MarkAsArchived::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RetryDataReplication`](crate::client::fluent_builders::RetryDataReplication) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`source_server_id(impl Into<String>)`](crate::client::fluent_builders::RetryDataReplication::source_server_id) / [`set_source_server_id(Option<String>)`](crate::client::fluent_builders::RetryDataReplication::set_source_server_id): <p>Retry data replication for Source Server ID.</p>
    /// - On success, responds with [`RetryDataReplicationOutput`](crate::output::RetryDataReplicationOutput) with field(s):
    ///   - [`source_server_id(Option<String>)`](crate::output::RetryDataReplicationOutput::source_server_id): <p>Source server ID.</p>
    ///   - [`arn(Option<String>)`](crate::output::RetryDataReplicationOutput::arn): <p>Source server ARN.</p>
    ///   - [`is_archived(Option<bool>)`](crate::output::RetryDataReplicationOutput::is_archived): <p>Source server archived status.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::RetryDataReplicationOutput::tags): <p>Source server Tags.</p>
    ///   - [`launched_instance(Option<LaunchedInstance>)`](crate::output::RetryDataReplicationOutput::launched_instance): <p>Source server launched instance.</p>
    ///   - [`data_replication_info(Option<DataReplicationInfo>)`](crate::output::RetryDataReplicationOutput::data_replication_info): <p>Source server data replication info.</p>
    ///   - [`life_cycle(Option<LifeCycle>)`](crate::output::RetryDataReplicationOutput::life_cycle): <p>Source server lifecycle state.</p>
    ///   - [`source_properties(Option<SourceProperties>)`](crate::output::RetryDataReplicationOutput::source_properties): <p>Source server properties.</p>
    ///   - [`replication_type(Option<ReplicationType>)`](crate::output::RetryDataReplicationOutput::replication_type): <p>Source server replication type.</p>
    ///   - [`vcenter_client_id(Option<String>)`](crate::output::RetryDataReplicationOutput::vcenter_client_id): <p>Source server vCenter client id.</p>
    /// - On failure, responds with [`SdkError<RetryDataReplicationError>`](crate::error::RetryDataReplicationError)
    pub fn retry_data_replication(&self) -> fluent_builders::RetryDataReplication {
        fluent_builders::RetryDataReplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartCutover`](crate::client::fluent_builders::StartCutover) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`source_server_i_ds(Vec<String>)`](crate::client::fluent_builders::StartCutover::source_server_i_ds) / [`set_source_server_i_ds(Option<Vec<String>>)`](crate::client::fluent_builders::StartCutover::set_source_server_i_ds): <p>Start Cutover by Source Server IDs.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::StartCutover::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::StartCutover::set_tags): <p>Start Cutover by Tags.</p>
    /// - On success, responds with [`StartCutoverOutput`](crate::output::StartCutoverOutput) with field(s):
    ///   - [`job(Option<Job>)`](crate::output::StartCutoverOutput::job): <p>Start Cutover Job response.</p>
    /// - On failure, responds with [`SdkError<StartCutoverError>`](crate::error::StartCutoverError)
    pub fn start_cutover(&self) -> fluent_builders::StartCutover {
        fluent_builders::StartCutover::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartReplication`](crate::client::fluent_builders::StartReplication) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`source_server_id(impl Into<String>)`](crate::client::fluent_builders::StartReplication::source_server_id) / [`set_source_server_id(Option<String>)`](crate::client::fluent_builders::StartReplication::set_source_server_id): <p>ID of source server on which to start replication.</p>
    /// - On success, responds with [`StartReplicationOutput`](crate::output::StartReplicationOutput) with field(s):
    ///   - [`source_server_id(Option<String>)`](crate::output::StartReplicationOutput::source_server_id): <p>Source server ID.</p>
    ///   - [`arn(Option<String>)`](crate::output::StartReplicationOutput::arn): <p>Source server ARN.</p>
    ///   - [`is_archived(Option<bool>)`](crate::output::StartReplicationOutput::is_archived): <p>Source server archived status.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::StartReplicationOutput::tags): <p>Source server Tags.</p>
    ///   - [`launched_instance(Option<LaunchedInstance>)`](crate::output::StartReplicationOutput::launched_instance): <p>Source server launched instance.</p>
    ///   - [`data_replication_info(Option<DataReplicationInfo>)`](crate::output::StartReplicationOutput::data_replication_info): <p>Source server data replication info.</p>
    ///   - [`life_cycle(Option<LifeCycle>)`](crate::output::StartReplicationOutput::life_cycle): <p>Source server lifecycle state.</p>
    ///   - [`source_properties(Option<SourceProperties>)`](crate::output::StartReplicationOutput::source_properties): <p>Source server properties.</p>
    ///   - [`replication_type(Option<ReplicationType>)`](crate::output::StartReplicationOutput::replication_type): <p>Source server replication type.</p>
    ///   - [`vcenter_client_id(Option<String>)`](crate::output::StartReplicationOutput::vcenter_client_id): <p>Source server vCenter client id.</p>
    /// - On failure, responds with [`SdkError<StartReplicationError>`](crate::error::StartReplicationError)
    pub fn start_replication(&self) -> fluent_builders::StartReplication {
        fluent_builders::StartReplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartTest`](crate::client::fluent_builders::StartTest) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`source_server_i_ds(Vec<String>)`](crate::client::fluent_builders::StartTest::source_server_i_ds) / [`set_source_server_i_ds(Option<Vec<String>>)`](crate::client::fluent_builders::StartTest::set_source_server_i_ds): <p>Start Test for Source Server IDs.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::StartTest::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::StartTest::set_tags): <p>Start Test by Tags.</p>
    /// - On success, responds with [`StartTestOutput`](crate::output::StartTestOutput) with field(s):
    ///   - [`job(Option<Job>)`](crate::output::StartTestOutput::job): <p>Start Test Job response.</p>
    /// - On failure, responds with [`SdkError<StartTestError>`](crate::error::StartTestError)
    pub fn start_test(&self) -> fluent_builders::StartTest {
        fluent_builders::StartTest::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>Tag resource by ARN.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>Tag resource by Tags.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TerminateTargetInstances`](crate::client::fluent_builders::TerminateTargetInstances) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`source_server_i_ds(Vec<String>)`](crate::client::fluent_builders::TerminateTargetInstances::source_server_i_ds) / [`set_source_server_i_ds(Option<Vec<String>>)`](crate::client::fluent_builders::TerminateTargetInstances::set_source_server_i_ds): <p>Terminate Target instance by Source Server IDs.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TerminateTargetInstances::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TerminateTargetInstances::set_tags): <p>Terminate Target instance by Tags.</p>
    /// - On success, responds with [`TerminateTargetInstancesOutput`](crate::output::TerminateTargetInstancesOutput) with field(s):
    ///   - [`job(Option<Job>)`](crate::output::TerminateTargetInstancesOutput::job): <p>Terminate Target instance Job response.</p>
    /// - On failure, responds with [`SdkError<TerminateTargetInstancesError>`](crate::error::TerminateTargetInstancesError)
    pub fn terminate_target_instances(&self) -> fluent_builders::TerminateTargetInstances {
        fluent_builders::TerminateTargetInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>Untag resource by ARN.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>Untag resource by Keys.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateLaunchConfiguration`](crate::client::fluent_builders::UpdateLaunchConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`source_server_id(impl Into<String>)`](crate::client::fluent_builders::UpdateLaunchConfiguration::source_server_id) / [`set_source_server_id(Option<String>)`](crate::client::fluent_builders::UpdateLaunchConfiguration::set_source_server_id): <p>Update Launch configuration by Source Server ID request.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateLaunchConfiguration::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateLaunchConfiguration::set_name): <p>Update Launch configuration name request.</p>
    ///   - [`launch_disposition(LaunchDisposition)`](crate::client::fluent_builders::UpdateLaunchConfiguration::launch_disposition) / [`set_launch_disposition(Option<LaunchDisposition>)`](crate::client::fluent_builders::UpdateLaunchConfiguration::set_launch_disposition): <p>Update Launch configuration launch disposition request.</p>
    ///   - [`target_instance_type_right_sizing_method(TargetInstanceTypeRightSizingMethod)`](crate::client::fluent_builders::UpdateLaunchConfiguration::target_instance_type_right_sizing_method) / [`set_target_instance_type_right_sizing_method(Option<TargetInstanceTypeRightSizingMethod>)`](crate::client::fluent_builders::UpdateLaunchConfiguration::set_target_instance_type_right_sizing_method): <p>Update Launch configuration Target instance right sizing request.</p>
    ///   - [`copy_private_ip(bool)`](crate::client::fluent_builders::UpdateLaunchConfiguration::copy_private_ip) / [`set_copy_private_ip(Option<bool>)`](crate::client::fluent_builders::UpdateLaunchConfiguration::set_copy_private_ip): <p>Update Launch configuration copy Private IP request.</p>
    ///   - [`copy_tags(bool)`](crate::client::fluent_builders::UpdateLaunchConfiguration::copy_tags) / [`set_copy_tags(Option<bool>)`](crate::client::fluent_builders::UpdateLaunchConfiguration::set_copy_tags): <p>Update Launch configuration copy Tags request.</p>
    ///   - [`licensing(Licensing)`](crate::client::fluent_builders::UpdateLaunchConfiguration::licensing) / [`set_licensing(Option<Licensing>)`](crate::client::fluent_builders::UpdateLaunchConfiguration::set_licensing): <p>Update Launch configuration licensing request.</p>
    ///   - [`boot_mode(BootMode)`](crate::client::fluent_builders::UpdateLaunchConfiguration::boot_mode) / [`set_boot_mode(Option<BootMode>)`](crate::client::fluent_builders::UpdateLaunchConfiguration::set_boot_mode): <p>Update Launch configuration boot mode request.</p>
    /// - On success, responds with [`UpdateLaunchConfigurationOutput`](crate::output::UpdateLaunchConfigurationOutput) with field(s):
    ///   - [`source_server_id(Option<String>)`](crate::output::UpdateLaunchConfigurationOutput::source_server_id): <p>Launch configuration Source Server ID.</p>
    ///   - [`name(Option<String>)`](crate::output::UpdateLaunchConfigurationOutput::name): <p>Launch configuration name.</p>
    ///   - [`ec2_launch_template_id(Option<String>)`](crate::output::UpdateLaunchConfigurationOutput::ec2_launch_template_id): <p>Launch configuration EC2 Launch template ID.</p>
    ///   - [`launch_disposition(Option<LaunchDisposition>)`](crate::output::UpdateLaunchConfigurationOutput::launch_disposition): <p>Launch disposition for launch configuration.</p>
    ///   - [`target_instance_type_right_sizing_method(Option<TargetInstanceTypeRightSizingMethod>)`](crate::output::UpdateLaunchConfigurationOutput::target_instance_type_right_sizing_method): <p>Launch configuration Target instance type right sizing method.</p>
    ///   - [`copy_private_ip(Option<bool>)`](crate::output::UpdateLaunchConfigurationOutput::copy_private_ip): <p>Copy Private IP during Launch Configuration.</p>
    ///   - [`copy_tags(Option<bool>)`](crate::output::UpdateLaunchConfigurationOutput::copy_tags): <p>Copy Tags during Launch Configuration.</p>
    ///   - [`licensing(Option<Licensing>)`](crate::output::UpdateLaunchConfigurationOutput::licensing): <p>Launch configuration OS licensing.</p>
    ///   - [`boot_mode(Option<BootMode>)`](crate::output::UpdateLaunchConfigurationOutput::boot_mode): <p>Launch configuration boot mode.</p>
    /// - On failure, responds with [`SdkError<UpdateLaunchConfigurationError>`](crate::error::UpdateLaunchConfigurationError)
    pub fn update_launch_configuration(&self) -> fluent_builders::UpdateLaunchConfiguration {
        fluent_builders::UpdateLaunchConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateReplicationConfiguration`](crate::client::fluent_builders::UpdateReplicationConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`source_server_id(impl Into<String>)`](crate::client::fluent_builders::UpdateReplicationConfiguration::source_server_id) / [`set_source_server_id(Option<String>)`](crate::client::fluent_builders::UpdateReplicationConfiguration::set_source_server_id): <p>Update replication configuration Source Server ID request.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateReplicationConfiguration::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateReplicationConfiguration::set_name): <p>Update replication configuration name request.</p>
    ///   - [`staging_area_subnet_id(impl Into<String>)`](crate::client::fluent_builders::UpdateReplicationConfiguration::staging_area_subnet_id) / [`set_staging_area_subnet_id(Option<String>)`](crate::client::fluent_builders::UpdateReplicationConfiguration::set_staging_area_subnet_id): <p>Update replication configuration Staging Area subnet request.</p>
    ///   - [`associate_default_security_group(bool)`](crate::client::fluent_builders::UpdateReplicationConfiguration::associate_default_security_group) / [`set_associate_default_security_group(Option<bool>)`](crate::client::fluent_builders::UpdateReplicationConfiguration::set_associate_default_security_group): <p>Update replication configuration associate default Application Migration Service Security group request.</p>
    ///   - [`replication_servers_security_groups_i_ds(Vec<String>)`](crate::client::fluent_builders::UpdateReplicationConfiguration::replication_servers_security_groups_i_ds) / [`set_replication_servers_security_groups_i_ds(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateReplicationConfiguration::set_replication_servers_security_groups_i_ds): <p>Update replication configuration Replication Server Security Groups IDs request.</p>
    ///   - [`replication_server_instance_type(impl Into<String>)`](crate::client::fluent_builders::UpdateReplicationConfiguration::replication_server_instance_type) / [`set_replication_server_instance_type(Option<String>)`](crate::client::fluent_builders::UpdateReplicationConfiguration::set_replication_server_instance_type): <p>Update replication configuration Replication Server instance type request.</p>
    ///   - [`use_dedicated_replication_server(bool)`](crate::client::fluent_builders::UpdateReplicationConfiguration::use_dedicated_replication_server) / [`set_use_dedicated_replication_server(Option<bool>)`](crate::client::fluent_builders::UpdateReplicationConfiguration::set_use_dedicated_replication_server): <p>Update replication configuration use dedicated Replication Server request.</p>
    ///   - [`default_large_staging_disk_type(ReplicationConfigurationDefaultLargeStagingDiskType)`](crate::client::fluent_builders::UpdateReplicationConfiguration::default_large_staging_disk_type) / [`set_default_large_staging_disk_type(Option<ReplicationConfigurationDefaultLargeStagingDiskType>)`](crate::client::fluent_builders::UpdateReplicationConfiguration::set_default_large_staging_disk_type): <p>Update replication configuration use default large Staging Disk type request.</p>
    ///   - [`replicated_disks(Vec<ReplicationConfigurationReplicatedDisk>)`](crate::client::fluent_builders::UpdateReplicationConfiguration::replicated_disks) / [`set_replicated_disks(Option<Vec<ReplicationConfigurationReplicatedDisk>>)`](crate::client::fluent_builders::UpdateReplicationConfiguration::set_replicated_disks): <p>Update replication configuration replicated disks request.</p>
    ///   - [`ebs_encryption(ReplicationConfigurationEbsEncryption)`](crate::client::fluent_builders::UpdateReplicationConfiguration::ebs_encryption) / [`set_ebs_encryption(Option<ReplicationConfigurationEbsEncryption>)`](crate::client::fluent_builders::UpdateReplicationConfiguration::set_ebs_encryption): <p>Update replication configuration EBS encryption request.</p>
    ///   - [`ebs_encryption_key_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateReplicationConfiguration::ebs_encryption_key_arn) / [`set_ebs_encryption_key_arn(Option<String>)`](crate::client::fluent_builders::UpdateReplicationConfiguration::set_ebs_encryption_key_arn): <p>Update replication configuration EBS encryption key ARN request.</p>
    ///   - [`bandwidth_throttling(i64)`](crate::client::fluent_builders::UpdateReplicationConfiguration::bandwidth_throttling) / [`set_bandwidth_throttling(i64)`](crate::client::fluent_builders::UpdateReplicationConfiguration::set_bandwidth_throttling): <p>Update replication configuration bandwidth throttling request.</p>
    ///   - [`data_plane_routing(ReplicationConfigurationDataPlaneRouting)`](crate::client::fluent_builders::UpdateReplicationConfiguration::data_plane_routing) / [`set_data_plane_routing(Option<ReplicationConfigurationDataPlaneRouting>)`](crate::client::fluent_builders::UpdateReplicationConfiguration::set_data_plane_routing): <p>Update replication configuration data plane routing request.</p>
    ///   - [`create_public_ip(bool)`](crate::client::fluent_builders::UpdateReplicationConfiguration::create_public_ip) / [`set_create_public_ip(Option<bool>)`](crate::client::fluent_builders::UpdateReplicationConfiguration::set_create_public_ip): <p>Update replication configuration create Public IP request.</p>
    ///   - [`staging_area_tags(HashMap<String, String>)`](crate::client::fluent_builders::UpdateReplicationConfiguration::staging_area_tags) / [`set_staging_area_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::UpdateReplicationConfiguration::set_staging_area_tags): <p>Update replication configuration Staging Area Tags request.</p>
    /// - On success, responds with [`UpdateReplicationConfigurationOutput`](crate::output::UpdateReplicationConfigurationOutput) with field(s):
    ///   - [`source_server_id(Option<String>)`](crate::output::UpdateReplicationConfigurationOutput::source_server_id): <p>Replication Configuration Source Server ID.</p>
    ///   - [`name(Option<String>)`](crate::output::UpdateReplicationConfigurationOutput::name): <p>Replication Configuration name.</p>
    ///   - [`staging_area_subnet_id(Option<String>)`](crate::output::UpdateReplicationConfigurationOutput::staging_area_subnet_id): <p>Replication Configuration Staging Area subnet ID.</p>
    ///   - [`associate_default_security_group(Option<bool>)`](crate::output::UpdateReplicationConfigurationOutput::associate_default_security_group): <p>Replication Configuration associate default Application Migration Service Security Group.</p>
    ///   - [`replication_servers_security_groups_i_ds(Option<Vec<String>>)`](crate::output::UpdateReplicationConfigurationOutput::replication_servers_security_groups_i_ds): <p>Replication Configuration Replication Server Security Group IDs.</p>
    ///   - [`replication_server_instance_type(Option<String>)`](crate::output::UpdateReplicationConfigurationOutput::replication_server_instance_type): <p>Replication Configuration Replication Server instance type.</p>
    ///   - [`use_dedicated_replication_server(Option<bool>)`](crate::output::UpdateReplicationConfigurationOutput::use_dedicated_replication_server): <p>Replication Configuration use Dedicated Replication Server.</p>
    ///   - [`default_large_staging_disk_type(Option<ReplicationConfigurationDefaultLargeStagingDiskType>)`](crate::output::UpdateReplicationConfigurationOutput::default_large_staging_disk_type): <p>Replication Configuration use default large Staging Disks.</p>
    ///   - [`replicated_disks(Option<Vec<ReplicationConfigurationReplicatedDisk>>)`](crate::output::UpdateReplicationConfigurationOutput::replicated_disks): <p>Replication Configuration replicated disks.</p>
    ///   - [`ebs_encryption(Option<ReplicationConfigurationEbsEncryption>)`](crate::output::UpdateReplicationConfigurationOutput::ebs_encryption): <p>Replication Configuration EBS encryption.</p>
    ///   - [`ebs_encryption_key_arn(Option<String>)`](crate::output::UpdateReplicationConfigurationOutput::ebs_encryption_key_arn): <p>Replication Configuration EBS encryption key ARN.</p>
    ///   - [`bandwidth_throttling(i64)`](crate::output::UpdateReplicationConfigurationOutput::bandwidth_throttling): <p>Replication Configuration set bandwidth throttling.</p>
    ///   - [`data_plane_routing(Option<ReplicationConfigurationDataPlaneRouting>)`](crate::output::UpdateReplicationConfigurationOutput::data_plane_routing): <p>Replication Configuration data plane routing.</p>
    ///   - [`create_public_ip(Option<bool>)`](crate::output::UpdateReplicationConfigurationOutput::create_public_ip): <p>Replication Configuration create Public IP.</p>
    ///   - [`staging_area_tags(Option<HashMap<String, String>>)`](crate::output::UpdateReplicationConfigurationOutput::staging_area_tags): <p>Replication Configuration Staging Area tags.</p>
    /// - On failure, responds with [`SdkError<UpdateReplicationConfigurationError>`](crate::error::UpdateReplicationConfigurationError)
    pub fn update_replication_configuration(
        &self,
    ) -> fluent_builders::UpdateReplicationConfiguration {
        fluent_builders::UpdateReplicationConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateReplicationConfigurationTemplate`](crate::client::fluent_builders::UpdateReplicationConfigurationTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`replication_configuration_template_id(impl Into<String>)`](crate::client::fluent_builders::UpdateReplicationConfigurationTemplate::replication_configuration_template_id) / [`set_replication_configuration_template_id(Option<String>)`](crate::client::fluent_builders::UpdateReplicationConfigurationTemplate::set_replication_configuration_template_id): <p>Update replication configuration template template ID request.</p>
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::UpdateReplicationConfigurationTemplate::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::UpdateReplicationConfigurationTemplate::set_arn): <p>Update replication configuration template ARN request.</p>
    ///   - [`staging_area_subnet_id(impl Into<String>)`](crate::client::fluent_builders::UpdateReplicationConfigurationTemplate::staging_area_subnet_id) / [`set_staging_area_subnet_id(Option<String>)`](crate::client::fluent_builders::UpdateReplicationConfigurationTemplate::set_staging_area_subnet_id): <p>Update replication configuration template Staging Area subnet ID request.</p>
    ///   - [`associate_default_security_group(bool)`](crate::client::fluent_builders::UpdateReplicationConfigurationTemplate::associate_default_security_group) / [`set_associate_default_security_group(Option<bool>)`](crate::client::fluent_builders::UpdateReplicationConfigurationTemplate::set_associate_default_security_group): <p>Update replication configuration template associate default Application Migration Service Security group request.</p>
    ///   - [`replication_servers_security_groups_i_ds(Vec<String>)`](crate::client::fluent_builders::UpdateReplicationConfigurationTemplate::replication_servers_security_groups_i_ds) / [`set_replication_servers_security_groups_i_ds(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateReplicationConfigurationTemplate::set_replication_servers_security_groups_i_ds): <p>Update replication configuration template Replication Server Security groups IDs request.</p>
    ///   - [`replication_server_instance_type(impl Into<String>)`](crate::client::fluent_builders::UpdateReplicationConfigurationTemplate::replication_server_instance_type) / [`set_replication_server_instance_type(Option<String>)`](crate::client::fluent_builders::UpdateReplicationConfigurationTemplate::set_replication_server_instance_type): <p>Update replication configuration template Replication Server instance type request.</p>
    ///   - [`use_dedicated_replication_server(bool)`](crate::client::fluent_builders::UpdateReplicationConfigurationTemplate::use_dedicated_replication_server) / [`set_use_dedicated_replication_server(Option<bool>)`](crate::client::fluent_builders::UpdateReplicationConfigurationTemplate::set_use_dedicated_replication_server): <p>Update replication configuration template use dedicated Replication Server request.</p>
    ///   - [`default_large_staging_disk_type(ReplicationConfigurationDefaultLargeStagingDiskType)`](crate::client::fluent_builders::UpdateReplicationConfigurationTemplate::default_large_staging_disk_type) / [`set_default_large_staging_disk_type(Option<ReplicationConfigurationDefaultLargeStagingDiskType>)`](crate::client::fluent_builders::UpdateReplicationConfigurationTemplate::set_default_large_staging_disk_type): <p>Update replication configuration template use default large Staging Disk type request.</p>
    ///   - [`ebs_encryption(ReplicationConfigurationEbsEncryption)`](crate::client::fluent_builders::UpdateReplicationConfigurationTemplate::ebs_encryption) / [`set_ebs_encryption(Option<ReplicationConfigurationEbsEncryption>)`](crate::client::fluent_builders::UpdateReplicationConfigurationTemplate::set_ebs_encryption): <p>Update replication configuration template EBS encryption request.</p>
    ///   - [`ebs_encryption_key_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateReplicationConfigurationTemplate::ebs_encryption_key_arn) / [`set_ebs_encryption_key_arn(Option<String>)`](crate::client::fluent_builders::UpdateReplicationConfigurationTemplate::set_ebs_encryption_key_arn): <p>Update replication configuration template EBS encryption key ARN request.</p>
    ///   - [`bandwidth_throttling(i64)`](crate::client::fluent_builders::UpdateReplicationConfigurationTemplate::bandwidth_throttling) / [`set_bandwidth_throttling(i64)`](crate::client::fluent_builders::UpdateReplicationConfigurationTemplate::set_bandwidth_throttling): <p>Update replication configuration template bandwidth throttling request.</p>
    ///   - [`data_plane_routing(ReplicationConfigurationDataPlaneRouting)`](crate::client::fluent_builders::UpdateReplicationConfigurationTemplate::data_plane_routing) / [`set_data_plane_routing(Option<ReplicationConfigurationDataPlaneRouting>)`](crate::client::fluent_builders::UpdateReplicationConfigurationTemplate::set_data_plane_routing): <p>Update replication configuration template data plane routing request.</p>
    ///   - [`create_public_ip(bool)`](crate::client::fluent_builders::UpdateReplicationConfigurationTemplate::create_public_ip) / [`set_create_public_ip(Option<bool>)`](crate::client::fluent_builders::UpdateReplicationConfigurationTemplate::set_create_public_ip): <p>Update replication configuration template create Public IP request.</p>
    ///   - [`staging_area_tags(HashMap<String, String>)`](crate::client::fluent_builders::UpdateReplicationConfigurationTemplate::staging_area_tags) / [`set_staging_area_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::UpdateReplicationConfigurationTemplate::set_staging_area_tags): <p>Update replication configuration template Staging Area Tags request.</p>
    /// - On success, responds with [`UpdateReplicationConfigurationTemplateOutput`](crate::output::UpdateReplicationConfigurationTemplateOutput) with field(s):
    ///   - [`replication_configuration_template_id(Option<String>)`](crate::output::UpdateReplicationConfigurationTemplateOutput::replication_configuration_template_id): <p>Replication Configuration template ID.</p>
    ///   - [`arn(Option<String>)`](crate::output::UpdateReplicationConfigurationTemplateOutput::arn): <p>Replication Configuration template ARN.</p>
    ///   - [`staging_area_subnet_id(Option<String>)`](crate::output::UpdateReplicationConfigurationTemplateOutput::staging_area_subnet_id): <p>Replication Configuration template Staging Area subnet ID.</p>
    ///   - [`associate_default_security_group(Option<bool>)`](crate::output::UpdateReplicationConfigurationTemplateOutput::associate_default_security_group): <p>Replication Configuration template associate default Application Migration Service Security group.</p>
    ///   - [`replication_servers_security_groups_i_ds(Option<Vec<String>>)`](crate::output::UpdateReplicationConfigurationTemplateOutput::replication_servers_security_groups_i_ds): <p>Replication Configuration template server Security Groups IDs.</p>
    ///   - [`replication_server_instance_type(Option<String>)`](crate::output::UpdateReplicationConfigurationTemplateOutput::replication_server_instance_type): <p>Replication Configuration template server instance type.</p>
    ///   - [`use_dedicated_replication_server(Option<bool>)`](crate::output::UpdateReplicationConfigurationTemplateOutput::use_dedicated_replication_server): <p>Replication Configuration template use Dedicated Replication Server.</p>
    ///   - [`default_large_staging_disk_type(Option<ReplicationConfigurationDefaultLargeStagingDiskType>)`](crate::output::UpdateReplicationConfigurationTemplateOutput::default_large_staging_disk_type): <p>Replication Configuration template use default large Staging Disk type.</p>
    ///   - [`ebs_encryption(Option<ReplicationConfigurationEbsEncryption>)`](crate::output::UpdateReplicationConfigurationTemplateOutput::ebs_encryption): <p>Replication Configuration template EBS encryption.</p>
    ///   - [`ebs_encryption_key_arn(Option<String>)`](crate::output::UpdateReplicationConfigurationTemplateOutput::ebs_encryption_key_arn): <p>Replication Configuration template EBS encryption key ARN.</p>
    ///   - [`bandwidth_throttling(i64)`](crate::output::UpdateReplicationConfigurationTemplateOutput::bandwidth_throttling): <p>Replication Configuration template bandwidth throttling.</p>
    ///   - [`data_plane_routing(Option<ReplicationConfigurationDataPlaneRouting>)`](crate::output::UpdateReplicationConfigurationTemplateOutput::data_plane_routing): <p>Replication Configuration template data plane routing.</p>
    ///   - [`create_public_ip(Option<bool>)`](crate::output::UpdateReplicationConfigurationTemplateOutput::create_public_ip): <p>Replication Configuration template create Public IP.</p>
    ///   - [`staging_area_tags(Option<HashMap<String, String>>)`](crate::output::UpdateReplicationConfigurationTemplateOutput::staging_area_tags): <p>Replication Configuration template Staging Area Tags.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::UpdateReplicationConfigurationTemplateOutput::tags): <p>Replication Configuration template Tags.</p>
    /// - On failure, responds with [`SdkError<UpdateReplicationConfigurationTemplateError>`](crate::error::UpdateReplicationConfigurationTemplateError)
    pub fn update_replication_configuration_template(
        &self,
    ) -> fluent_builders::UpdateReplicationConfigurationTemplate {
        fluent_builders::UpdateReplicationConfigurationTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateSourceServerReplicationType`](crate::client::fluent_builders::UpdateSourceServerReplicationType) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`source_server_id(impl Into<String>)`](crate::client::fluent_builders::UpdateSourceServerReplicationType::source_server_id) / [`set_source_server_id(Option<String>)`](crate::client::fluent_builders::UpdateSourceServerReplicationType::set_source_server_id): <p>ID of source server on which to update replication type.</p>
    ///   - [`replication_type(ReplicationType)`](crate::client::fluent_builders::UpdateSourceServerReplicationType::replication_type) / [`set_replication_type(Option<ReplicationType>)`](crate::client::fluent_builders::UpdateSourceServerReplicationType::set_replication_type): <p>Replication type to which to update source server.</p>
    /// - On success, responds with [`UpdateSourceServerReplicationTypeOutput`](crate::output::UpdateSourceServerReplicationTypeOutput) with field(s):
    ///   - [`source_server_id(Option<String>)`](crate::output::UpdateSourceServerReplicationTypeOutput::source_server_id): <p>Source server ID.</p>
    ///   - [`arn(Option<String>)`](crate::output::UpdateSourceServerReplicationTypeOutput::arn): <p>Source server ARN.</p>
    ///   - [`is_archived(Option<bool>)`](crate::output::UpdateSourceServerReplicationTypeOutput::is_archived): <p>Source server archived status.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::UpdateSourceServerReplicationTypeOutput::tags): <p>Source server Tags.</p>
    ///   - [`launched_instance(Option<LaunchedInstance>)`](crate::output::UpdateSourceServerReplicationTypeOutput::launched_instance): <p>Source server launched instance.</p>
    ///   - [`data_replication_info(Option<DataReplicationInfo>)`](crate::output::UpdateSourceServerReplicationTypeOutput::data_replication_info): <p>Source server data replication info.</p>
    ///   - [`life_cycle(Option<LifeCycle>)`](crate::output::UpdateSourceServerReplicationTypeOutput::life_cycle): <p>Source server lifecycle state.</p>
    ///   - [`source_properties(Option<SourceProperties>)`](crate::output::UpdateSourceServerReplicationTypeOutput::source_properties): <p>Source server properties.</p>
    ///   - [`replication_type(Option<ReplicationType>)`](crate::output::UpdateSourceServerReplicationTypeOutput::replication_type): <p>Source server replication type.</p>
    ///   - [`vcenter_client_id(Option<String>)`](crate::output::UpdateSourceServerReplicationTypeOutput::vcenter_client_id): <p>Source server vCenter client id.</p>
    /// - On failure, responds with [`SdkError<UpdateSourceServerReplicationTypeError>`](crate::error::UpdateSourceServerReplicationTypeError)
    pub fn update_source_server_replication_type(
        &self,
    ) -> fluent_builders::UpdateSourceServerReplicationType {
        fluent_builders::UpdateSourceServerReplicationType::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `ChangeServerLifeCycleState`.
    ///
    /// <p>Allows the user to set the SourceServer.LifeCycle.state property for specific Source Server IDs to one of the following: READY_FOR_TEST or READY_FOR_CUTOVER. This command only works if the Source Server is already launchable (dataReplicationInfo.lagDuration is not null.)</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ChangeServerLifeCycleState {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::change_server_life_cycle_state_input::Builder,
    }
    impl ChangeServerLifeCycleState {
        /// Creates a new `ChangeServerLifeCycleState`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ChangeServerLifeCycleStateOutput,
            aws_smithy_http::result::SdkError<crate::error::ChangeServerLifeCycleStateError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The request to change the source server migration lifecycle state by source server ID.</p>
        pub fn source_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_server_id(input.into());
            self
        }
        /// <p>The request to change the source server migration lifecycle state by source server ID.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_server_id(input);
            self
        }
        /// <p>The request to change the source server migration lifecycle state.</p>
        pub fn life_cycle(
            mut self,
            input: crate::model::ChangeServerLifeCycleStateSourceServerLifecycle,
        ) -> Self {
            self.inner = self.inner.life_cycle(input);
            self
        }
        /// <p>The request to change the source server migration lifecycle state.</p>
        pub fn set_life_cycle(
            mut self,
            input: std::option::Option<
                crate::model::ChangeServerLifeCycleStateSourceServerLifecycle,
            >,
        ) -> Self {
            self.inner = self.inner.set_life_cycle(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateReplicationConfigurationTemplate`.
    ///
    /// <p>Creates a new ReplicationConfigurationTemplate.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateReplicationConfigurationTemplate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_replication_configuration_template_input::Builder,
    }
    impl CreateReplicationConfigurationTemplate {
        /// Creates a new `CreateReplicationConfigurationTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateReplicationConfigurationTemplateOutput,
            aws_smithy_http::result::SdkError<
                crate::error::CreateReplicationConfigurationTemplateError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Request to configure the Staging Area subnet ID during Replication Settings template creation.</p>
        pub fn staging_area_subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.staging_area_subnet_id(input.into());
            self
        }
        /// <p>Request to configure the Staging Area subnet ID during Replication Settings template creation.</p>
        pub fn set_staging_area_subnet_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_staging_area_subnet_id(input);
            self
        }
        /// <p>Request to associate the default Application Migration Service Security group with the Replication Settings template.</p>
        pub fn associate_default_security_group(mut self, input: bool) -> Self {
            self.inner = self.inner.associate_default_security_group(input);
            self
        }
        /// <p>Request to associate the default Application Migration Service Security group with the Replication Settings template.</p>
        pub fn set_associate_default_security_group(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_associate_default_security_group(input);
            self
        }
        /// Appends an item to `replicationServersSecurityGroupsIDs`.
        ///
        /// To override the contents of this collection use [`set_replication_servers_security_groups_i_ds`](Self::set_replication_servers_security_groups_i_ds).
        ///
        /// <p>Request to configure the Replication Server Security group ID during Replication Settings template creation.</p>
        pub fn replication_servers_security_groups_i_ds(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .replication_servers_security_groups_i_ds(input.into());
            self
        }
        /// <p>Request to configure the Replication Server Security group ID during Replication Settings template creation.</p>
        pub fn set_replication_servers_security_groups_i_ds(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self
                .inner
                .set_replication_servers_security_groups_i_ds(input);
            self
        }
        /// <p>Request to configure the Replication Server instance type during Replication Settings template creation.</p>
        pub fn replication_server_instance_type(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.replication_server_instance_type(input.into());
            self
        }
        /// <p>Request to configure the Replication Server instance type during Replication Settings template creation.</p>
        pub fn set_replication_server_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_server_instance_type(input);
            self
        }
        /// <p>Request to use Dedicated Replication Servers during Replication Settings template creation.</p>
        pub fn use_dedicated_replication_server(mut self, input: bool) -> Self {
            self.inner = self.inner.use_dedicated_replication_server(input);
            self
        }
        /// <p>Request to use Dedicated Replication Servers during Replication Settings template creation.</p>
        pub fn set_use_dedicated_replication_server(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_use_dedicated_replication_server(input);
            self
        }
        /// <p>Request to configure the default large staging disk EBS volume type during Replication Settings template creation.</p>
        pub fn default_large_staging_disk_type(
            mut self,
            input: crate::model::ReplicationConfigurationDefaultLargeStagingDiskType,
        ) -> Self {
            self.inner = self.inner.default_large_staging_disk_type(input);
            self
        }
        /// <p>Request to configure the default large staging disk EBS volume type during Replication Settings template creation.</p>
        pub fn set_default_large_staging_disk_type(
            mut self,
            input: std::option::Option<
                crate::model::ReplicationConfigurationDefaultLargeStagingDiskType,
            >,
        ) -> Self {
            self.inner = self.inner.set_default_large_staging_disk_type(input);
            self
        }
        /// <p>Request to configure EBS encryption during Replication Settings template creation.</p>
        pub fn ebs_encryption(
            mut self,
            input: crate::model::ReplicationConfigurationEbsEncryption,
        ) -> Self {
            self.inner = self.inner.ebs_encryption(input);
            self
        }
        /// <p>Request to configure EBS encryption during Replication Settings template creation.</p>
        pub fn set_ebs_encryption(
            mut self,
            input: std::option::Option<crate::model::ReplicationConfigurationEbsEncryption>,
        ) -> Self {
            self.inner = self.inner.set_ebs_encryption(input);
            self
        }
        /// <p>Request to configure an EBS encryption key during Replication Settings template creation.</p>
        pub fn ebs_encryption_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ebs_encryption_key_arn(input.into());
            self
        }
        /// <p>Request to configure an EBS encryption key during Replication Settings template creation.</p>
        pub fn set_ebs_encryption_key_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ebs_encryption_key_arn(input);
            self
        }
        /// <p>Request to configure bandwidth throttling during Replication Settings template creation.</p>
        pub fn bandwidth_throttling(mut self, input: i64) -> Self {
            self.inner = self.inner.bandwidth_throttling(input);
            self
        }
        /// <p>Request to configure bandwidth throttling during Replication Settings template creation.</p>
        pub fn set_bandwidth_throttling(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_bandwidth_throttling(input);
            self
        }
        /// <p>Request to configure data plane routing during Replication Settings template creation.</p>
        pub fn data_plane_routing(
            mut self,
            input: crate::model::ReplicationConfigurationDataPlaneRouting,
        ) -> Self {
            self.inner = self.inner.data_plane_routing(input);
            self
        }
        /// <p>Request to configure data plane routing during Replication Settings template creation.</p>
        pub fn set_data_plane_routing(
            mut self,
            input: std::option::Option<crate::model::ReplicationConfigurationDataPlaneRouting>,
        ) -> Self {
            self.inner = self.inner.set_data_plane_routing(input);
            self
        }
        /// <p>Request to create Public IP during Replication Settings template creation.</p>
        pub fn create_public_ip(mut self, input: bool) -> Self {
            self.inner = self.inner.create_public_ip(input);
            self
        }
        /// <p>Request to create Public IP during Replication Settings template creation.</p>
        pub fn set_create_public_ip(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_create_public_ip(input);
            self
        }
        /// Adds a key-value pair to `stagingAreaTags`.
        ///
        /// To override the contents of this collection use [`set_staging_area_tags`](Self::set_staging_area_tags).
        ///
        /// <p>Request to configure Staging Area tags during Replication Settings template creation.</p>
        pub fn staging_area_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.staging_area_tags(k.into(), v.into());
            self
        }
        /// <p>Request to configure Staging Area tags during Replication Settings template creation.</p>
        pub fn set_staging_area_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_staging_area_tags(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Request to configure tags during Replication Settings template creation.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Request to configure tags during Replication Settings template creation.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteJob`.
    ///
    /// <p>Deletes a single Job by ID.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_job_input::Builder,
    }
    impl DeleteJob {
        /// Creates a new `DeleteJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Request to delete Job from service by Job ID.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>Request to delete Job from service by Job ID.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteReplicationConfigurationTemplate`.
    ///
    /// <p>Deletes a single Replication Configuration Template by ID</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteReplicationConfigurationTemplate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_replication_configuration_template_input::Builder,
    }
    impl DeleteReplicationConfigurationTemplate {
        /// Creates a new `DeleteReplicationConfigurationTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteReplicationConfigurationTemplateOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeleteReplicationConfigurationTemplateError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Request to delete Replication Configuration Template from service by Replication Configuration Template ID.</p>
        pub fn replication_configuration_template_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .replication_configuration_template_id(input.into());
            self
        }
        /// <p>Request to delete Replication Configuration Template from service by Replication Configuration Template ID.</p>
        pub fn set_replication_configuration_template_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_configuration_template_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSourceServer`.
    ///
    /// <p>Deletes a single source server by ID.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteSourceServer {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_source_server_input::Builder,
    }
    impl DeleteSourceServer {
        /// Creates a new `DeleteSourceServer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSourceServerOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSourceServerError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Request to delete Source Server from service by Server ID.</p>
        pub fn source_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_server_id(input.into());
            self
        }
        /// <p>Request to delete Source Server from service by Server ID.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_server_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteVcenterClient`.
    ///
    /// <p>Deletes a given vCenter client by ID.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteVcenterClient {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_vcenter_client_input::Builder,
    }
    impl DeleteVcenterClient {
        /// Creates a new `DeleteVcenterClient`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteVcenterClientOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteVcenterClientError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>ID of resource to be deleted.</p>
        pub fn vcenter_client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vcenter_client_id(input.into());
            self
        }
        /// <p>ID of resource to be deleted.</p>
        pub fn set_vcenter_client_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_vcenter_client_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeJobLogItems`.
    ///
    /// <p>Retrieves detailed job log items with paging.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeJobLogItems {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_job_log_items_input::Builder,
    }
    impl DescribeJobLogItems {
        /// Creates a new `DescribeJobLogItems`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeJobLogItemsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeJobLogItemsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeJobLogItemsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeJobLogItemsPaginator {
            crate::paginator::DescribeJobLogItemsPaginator::new(self.handle, self.inner)
        }
        /// <p>Request to describe Job log job ID.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>Request to describe Job log job ID.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>Request to describe Job log item maximum results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Request to describe Job log item maximum results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Request to describe Job log next token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Request to describe Job log next token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeJobs`.
    ///
    /// <p>Returns a list of Jobs. Use the JobsID and fromDate and toData filters to limit which jobs are returned. The response is sorted by creationDataTime - latest date first. Jobs are normally created by the StartTest, StartCutover, and TerminateTargetInstances APIs. Jobs are also created by DiagnosticLaunch and TerminateDiagnosticInstances, which are APIs available only to *Support* and only used in response to relevant support tickets.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeJobs {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_jobs_input::Builder,
    }
    impl DescribeJobs {
        /// Creates a new `DescribeJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeJobsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeJobsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeJobsPaginator {
            crate::paginator::DescribeJobsPaginator::new(self.handle, self.inner)
        }
        /// <p>Request to describe Job log filters.</p>
        pub fn filters(mut self, input: crate::model::DescribeJobsRequestFilters) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Request to describe Job log filters.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::DescribeJobsRequestFilters>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>Request to describe job log items by max results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Request to describe job log items by max results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Request to describe job log items by next token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Request to describe job log items by next token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeReplicationConfigurationTemplates`.
    ///
    /// <p>Lists all ReplicationConfigurationTemplates, filtered by Source Server IDs.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeReplicationConfigurationTemplates {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_replication_configuration_templates_input::Builder,
    }
    impl DescribeReplicationConfigurationTemplates {
        /// Creates a new `DescribeReplicationConfigurationTemplates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeReplicationConfigurationTemplatesOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeReplicationConfigurationTemplatesError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeReplicationConfigurationTemplatesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeReplicationConfigurationTemplatesPaginator {
            crate::paginator::DescribeReplicationConfigurationTemplatesPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// Appends an item to `replicationConfigurationTemplateIDs`.
        ///
        /// To override the contents of this collection use [`set_replication_configuration_template_i_ds`](Self::set_replication_configuration_template_i_ds).
        ///
        /// <p>Request to describe Replication Configuration template by template IDs.</p>
        pub fn replication_configuration_template_i_ds(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .replication_configuration_template_i_ds(input.into());
            self
        }
        /// <p>Request to describe Replication Configuration template by template IDs.</p>
        pub fn set_replication_configuration_template_i_ds(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self
                .inner
                .set_replication_configuration_template_i_ds(input);
            self
        }
        /// <p>Request to describe Replication Configuration template by max results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Request to describe Replication Configuration template by max results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Request to describe Replication Configuration template by next token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Request to describe Replication Configuration template by next token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSourceServers`.
    ///
    /// <p>Retrieves all SourceServers or multiple SourceServers by ID.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeSourceServers {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_source_servers_input::Builder,
    }
    impl DescribeSourceServers {
        /// Creates a new `DescribeSourceServers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSourceServersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSourceServersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeSourceServersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeSourceServersPaginator {
            crate::paginator::DescribeSourceServersPaginator::new(self.handle, self.inner)
        }
        /// <p>Request to filter Source Servers list.</p>
        pub fn filters(mut self, input: crate::model::DescribeSourceServersRequestFilters) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Request to filter Source Servers list.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::DescribeSourceServersRequestFilters>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>Request to filter Source Servers list by maximum results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Request to filter Source Servers list by maximum results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Request to filter Source Servers list by next token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Request to filter Source Servers list by next token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeVcenterClients`.
    ///
    /// <p>Returns a list of the installed vCenter clients.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeVcenterClients {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_vcenter_clients_input::Builder,
    }
    impl DescribeVcenterClients {
        /// Creates a new `DescribeVcenterClients`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeVcenterClientsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeVcenterClientsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeVcenterClientsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeVcenterClientsPaginator {
            crate::paginator::DescribeVcenterClientsPaginator::new(self.handle, self.inner)
        }
        /// <p>Maximum results to be returned in DescribeVcenterClients.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Maximum results to be returned in DescribeVcenterClients.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Next pagination token to be provided for DescribeVcenterClients.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Next pagination token to be provided for DescribeVcenterClients.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisconnectFromService`.
    ///
    /// <p>Disconnects specific Source Servers from Application Migration Service. Data replication is stopped immediately. All AWS resources created by Application Migration Service for enabling the replication of these source servers will be terminated / deleted within 90 minutes. Launched Test or Cutover instances will NOT be terminated. If the agent on the source server has not been prevented from communicating with the Application Migration Service service, then it will receive a command to uninstall itself (within approximately 10 minutes). The following properties of the SourceServer will be changed immediately: dataReplicationInfo.dataReplicationState will be set to DISCONNECTED; The totalStorageBytes property for each of dataReplicationInfo.replicatedDisks will be set to zero; dataReplicationInfo.lagDuration and dataReplicationInfo.lagDuration will be nullified.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisconnectFromService {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disconnect_from_service_input::Builder,
    }
    impl DisconnectFromService {
        /// Creates a new `DisconnectFromService`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisconnectFromServiceOutput,
            aws_smithy_http::result::SdkError<crate::error::DisconnectFromServiceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Request to disconnect Source Server from service by Server ID.</p>
        pub fn source_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_server_id(input.into());
            self
        }
        /// <p>Request to disconnect Source Server from service by Server ID.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_server_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `FinalizeCutover`.
    ///
    /// <p>Finalizes the cutover immediately for specific Source Servers. All AWS resources created by Application Migration Service for enabling the replication of these source servers will be terminated / deleted within 90 minutes. Launched Test or Cutover instances will NOT be terminated. The AWS Replication Agent will receive a command to uninstall itself (within 10 minutes). The following properties of the SourceServer will be changed immediately: dataReplicationInfo.dataReplicationState will be changed to DISCONNECTED; The SourceServer.lifeCycle.state will be changed to CUTOVER; The totalStorageBytes property fo each of dataReplicationInfo.replicatedDisks will be set to zero; dataReplicationInfo.lagDuration and dataReplicationInfo.lagDuration will be nullified.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct FinalizeCutover {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::finalize_cutover_input::Builder,
    }
    impl FinalizeCutover {
        /// Creates a new `FinalizeCutover`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::FinalizeCutoverOutput,
            aws_smithy_http::result::SdkError<crate::error::FinalizeCutoverError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Request to finalize Cutover by Source Server ID.</p>
        pub fn source_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_server_id(input.into());
            self
        }
        /// <p>Request to finalize Cutover by Source Server ID.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_server_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLaunchConfiguration`.
    ///
    /// <p>Lists all LaunchConfigurations available, filtered by Source Server IDs.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetLaunchConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_launch_configuration_input::Builder,
    }
    impl GetLaunchConfiguration {
        /// Creates a new `GetLaunchConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLaunchConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLaunchConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Request to get Launch Configuration information by Source Server ID.</p>
        pub fn source_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_server_id(input.into());
            self
        }
        /// <p>Request to get Launch Configuration information by Source Server ID.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_server_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetReplicationConfiguration`.
    ///
    /// <p>Lists all ReplicationConfigurations, filtered by Source Server ID.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetReplicationConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_replication_configuration_input::Builder,
    }
    impl GetReplicationConfiguration {
        /// Creates a new `GetReplicationConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetReplicationConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetReplicationConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Request to get Replication Configuration by Source Server ID.</p>
        pub fn source_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_server_id(input.into());
            self
        }
        /// <p>Request to get Replication Configuration by Source Server ID.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_server_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `InitializeService`.
    ///
    /// <p>Initialize Application Migration Service.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct InitializeService {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::initialize_service_input::Builder,
    }
    impl InitializeService {
        /// Creates a new `InitializeService`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::InitializeServiceOutput,
            aws_smithy_http::result::SdkError<crate::error::InitializeServiceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>List all tags for your Application Migration Service resources.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>List tags for resource request by ARN.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>List tags for resource request by ARN.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `MarkAsArchived`.
    ///
    /// <p>Archives specific Source Servers by setting the SourceServer.isArchived property to true for specified SourceServers by ID. This command only works for SourceServers with a lifecycle. state which equals DISCONNECTED or CUTOVER.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct MarkAsArchived {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::mark_as_archived_input::Builder,
    }
    impl MarkAsArchived {
        /// Creates a new `MarkAsArchived`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::MarkAsArchivedOutput,
            aws_smithy_http::result::SdkError<crate::error::MarkAsArchivedError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Mark as archived by Source Server ID.</p>
        pub fn source_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_server_id(input.into());
            self
        }
        /// <p>Mark as archived by Source Server ID.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_server_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RetryDataReplication`.
    ///
    /// <p>Causes the data replication initiation sequence to begin immediately upon next Handshake for specified SourceServer IDs, regardless of when the previous initiation started. This command will not work if the SourceServer is not stalled or is in a DISCONNECTED or STOPPED state.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RetryDataReplication {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::retry_data_replication_input::Builder,
    }
    impl RetryDataReplication {
        /// Creates a new `RetryDataReplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RetryDataReplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::RetryDataReplicationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Retry data replication for Source Server ID.</p>
        pub fn source_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_server_id(input.into());
            self
        }
        /// <p>Retry data replication for Source Server ID.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_server_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartCutover`.
    ///
    /// <p>Launches a Cutover Instance for specific Source Servers. This command starts a LAUNCH job whose initiatedBy property is StartCutover and changes the SourceServer.lifeCycle.state property to CUTTING_OVER.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartCutover {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_cutover_input::Builder,
    }
    impl StartCutover {
        /// Creates a new `StartCutover`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartCutoverOutput,
            aws_smithy_http::result::SdkError<crate::error::StartCutoverError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `sourceServerIDs`.
        ///
        /// To override the contents of this collection use [`set_source_server_i_ds`](Self::set_source_server_i_ds).
        ///
        /// <p>Start Cutover by Source Server IDs.</p>
        pub fn source_server_i_ds(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_server_i_ds(input.into());
            self
        }
        /// <p>Start Cutover by Source Server IDs.</p>
        pub fn set_source_server_i_ds(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_source_server_i_ds(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Start Cutover by Tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Start Cutover by Tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartReplication`.
    ///
    /// <p>Starts replication for SNAPSHOT_SHIPPING agents.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartReplication {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_replication_input::Builder,
    }
    impl StartReplication {
        /// Creates a new `StartReplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartReplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::StartReplicationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>ID of source server on which to start replication.</p>
        pub fn source_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_server_id(input.into());
            self
        }
        /// <p>ID of source server on which to start replication.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_server_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartTest`.
    ///
    /// <p>Launches a Test Instance for specific Source Servers. This command starts a LAUNCH job whose initiatedBy property is StartTest and changes the SourceServer.lifeCycle.state property to TESTING.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartTest {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_test_input::Builder,
    }
    impl StartTest {
        /// Creates a new `StartTest`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartTestOutput,
            aws_smithy_http::result::SdkError<crate::error::StartTestError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `sourceServerIDs`.
        ///
        /// To override the contents of this collection use [`set_source_server_i_ds`](Self::set_source_server_i_ds).
        ///
        /// <p>Start Test for Source Server IDs.</p>
        pub fn source_server_i_ds(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_server_i_ds(input.into());
            self
        }
        /// <p>Start Test for Source Server IDs.</p>
        pub fn set_source_server_i_ds(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_source_server_i_ds(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Start Test by Tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Start Test by Tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds or overwrites only the specified tags for the specified Application Migration Service resource or resources. When you specify an existing tag key, the value is overwritten with the new value. Each resource can have a maximum of 50 tags. Each tag consists of a key and optional value.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Tag resource by ARN.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>Tag resource by ARN.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tag resource by Tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Tag resource by Tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TerminateTargetInstances`.
    ///
    /// <p>Starts a job that terminates specific launched EC2 Test and Cutover instances. This command will not work for any Source Server with a lifecycle.state of TESTING, CUTTING_OVER, or CUTOVER.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TerminateTargetInstances {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::terminate_target_instances_input::Builder,
    }
    impl TerminateTargetInstances {
        /// Creates a new `TerminateTargetInstances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TerminateTargetInstancesOutput,
            aws_smithy_http::result::SdkError<crate::error::TerminateTargetInstancesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `sourceServerIDs`.
        ///
        /// To override the contents of this collection use [`set_source_server_i_ds`](Self::set_source_server_i_ds).
        ///
        /// <p>Terminate Target instance by Source Server IDs.</p>
        pub fn source_server_i_ds(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_server_i_ds(input.into());
            self
        }
        /// <p>Terminate Target instance by Source Server IDs.</p>
        pub fn set_source_server_i_ds(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_source_server_i_ds(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Terminate Target instance by Tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Terminate Target instance by Tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Deletes the specified set of tags from the specified set of Application Migration Service resources.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Untag resource by ARN.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>Untag resource by ARN.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>Untag resource by Keys.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>Untag resource by Keys.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateLaunchConfiguration`.
    ///
    /// <p>Updates multiple LaunchConfigurations by Source Server ID.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateLaunchConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_launch_configuration_input::Builder,
    }
    impl UpdateLaunchConfiguration {
        /// Creates a new `UpdateLaunchConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateLaunchConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateLaunchConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Update Launch configuration by Source Server ID request.</p>
        pub fn source_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_server_id(input.into());
            self
        }
        /// <p>Update Launch configuration by Source Server ID request.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_server_id(input);
            self
        }
        /// <p>Update Launch configuration name request.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>Update Launch configuration name request.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Update Launch configuration launch disposition request.</p>
        pub fn launch_disposition(mut self, input: crate::model::LaunchDisposition) -> Self {
            self.inner = self.inner.launch_disposition(input);
            self
        }
        /// <p>Update Launch configuration launch disposition request.</p>
        pub fn set_launch_disposition(
            mut self,
            input: std::option::Option<crate::model::LaunchDisposition>,
        ) -> Self {
            self.inner = self.inner.set_launch_disposition(input);
            self
        }
        /// <p>Update Launch configuration Target instance right sizing request.</p>
        pub fn target_instance_type_right_sizing_method(
            mut self,
            input: crate::model::TargetInstanceTypeRightSizingMethod,
        ) -> Self {
            self.inner = self.inner.target_instance_type_right_sizing_method(input);
            self
        }
        /// <p>Update Launch configuration Target instance right sizing request.</p>
        pub fn set_target_instance_type_right_sizing_method(
            mut self,
            input: std::option::Option<crate::model::TargetInstanceTypeRightSizingMethod>,
        ) -> Self {
            self.inner = self
                .inner
                .set_target_instance_type_right_sizing_method(input);
            self
        }
        /// <p>Update Launch configuration copy Private IP request.</p>
        pub fn copy_private_ip(mut self, input: bool) -> Self {
            self.inner = self.inner.copy_private_ip(input);
            self
        }
        /// <p>Update Launch configuration copy Private IP request.</p>
        pub fn set_copy_private_ip(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_copy_private_ip(input);
            self
        }
        /// <p>Update Launch configuration copy Tags request.</p>
        pub fn copy_tags(mut self, input: bool) -> Self {
            self.inner = self.inner.copy_tags(input);
            self
        }
        /// <p>Update Launch configuration copy Tags request.</p>
        pub fn set_copy_tags(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_copy_tags(input);
            self
        }
        /// <p>Update Launch configuration licensing request.</p>
        pub fn licensing(mut self, input: crate::model::Licensing) -> Self {
            self.inner = self.inner.licensing(input);
            self
        }
        /// <p>Update Launch configuration licensing request.</p>
        pub fn set_licensing(
            mut self,
            input: std::option::Option<crate::model::Licensing>,
        ) -> Self {
            self.inner = self.inner.set_licensing(input);
            self
        }
        /// <p>Update Launch configuration boot mode request.</p>
        pub fn boot_mode(mut self, input: crate::model::BootMode) -> Self {
            self.inner = self.inner.boot_mode(input);
            self
        }
        /// <p>Update Launch configuration boot mode request.</p>
        pub fn set_boot_mode(mut self, input: std::option::Option<crate::model::BootMode>) -> Self {
            self.inner = self.inner.set_boot_mode(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateReplicationConfiguration`.
    ///
    /// <p>Allows you to update multiple ReplicationConfigurations by Source Server ID.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateReplicationConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_replication_configuration_input::Builder,
    }
    impl UpdateReplicationConfiguration {
        /// Creates a new `UpdateReplicationConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateReplicationConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateReplicationConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Update replication configuration Source Server ID request.</p>
        pub fn source_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_server_id(input.into());
            self
        }
        /// <p>Update replication configuration Source Server ID request.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_server_id(input);
            self
        }
        /// <p>Update replication configuration name request.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>Update replication configuration name request.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Update replication configuration Staging Area subnet request.</p>
        pub fn staging_area_subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.staging_area_subnet_id(input.into());
            self
        }
        /// <p>Update replication configuration Staging Area subnet request.</p>
        pub fn set_staging_area_subnet_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_staging_area_subnet_id(input);
            self
        }
        /// <p>Update replication configuration associate default Application Migration Service Security group request.</p>
        pub fn associate_default_security_group(mut self, input: bool) -> Self {
            self.inner = self.inner.associate_default_security_group(input);
            self
        }
        /// <p>Update replication configuration associate default Application Migration Service Security group request.</p>
        pub fn set_associate_default_security_group(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_associate_default_security_group(input);
            self
        }
        /// Appends an item to `replicationServersSecurityGroupsIDs`.
        ///
        /// To override the contents of this collection use [`set_replication_servers_security_groups_i_ds`](Self::set_replication_servers_security_groups_i_ds).
        ///
        /// <p>Update replication configuration Replication Server Security Groups IDs request.</p>
        pub fn replication_servers_security_groups_i_ds(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .replication_servers_security_groups_i_ds(input.into());
            self
        }
        /// <p>Update replication configuration Replication Server Security Groups IDs request.</p>
        pub fn set_replication_servers_security_groups_i_ds(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self
                .inner
                .set_replication_servers_security_groups_i_ds(input);
            self
        }
        /// <p>Update replication configuration Replication Server instance type request.</p>
        pub fn replication_server_instance_type(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.replication_server_instance_type(input.into());
            self
        }
        /// <p>Update replication configuration Replication Server instance type request.</p>
        pub fn set_replication_server_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_server_instance_type(input);
            self
        }
        /// <p>Update replication configuration use dedicated Replication Server request.</p>
        pub fn use_dedicated_replication_server(mut self, input: bool) -> Self {
            self.inner = self.inner.use_dedicated_replication_server(input);
            self
        }
        /// <p>Update replication configuration use dedicated Replication Server request.</p>
        pub fn set_use_dedicated_replication_server(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_use_dedicated_replication_server(input);
            self
        }
        /// <p>Update replication configuration use default large Staging Disk type request.</p>
        pub fn default_large_staging_disk_type(
            mut self,
            input: crate::model::ReplicationConfigurationDefaultLargeStagingDiskType,
        ) -> Self {
            self.inner = self.inner.default_large_staging_disk_type(input);
            self
        }
        /// <p>Update replication configuration use default large Staging Disk type request.</p>
        pub fn set_default_large_staging_disk_type(
            mut self,
            input: std::option::Option<
                crate::model::ReplicationConfigurationDefaultLargeStagingDiskType,
            >,
        ) -> Self {
            self.inner = self.inner.set_default_large_staging_disk_type(input);
            self
        }
        /// Appends an item to `replicatedDisks`.
        ///
        /// To override the contents of this collection use [`set_replicated_disks`](Self::set_replicated_disks).
        ///
        /// <p>Update replication configuration replicated disks request.</p>
        pub fn replicated_disks(
            mut self,
            input: crate::model::ReplicationConfigurationReplicatedDisk,
        ) -> Self {
            self.inner = self.inner.replicated_disks(input);
            self
        }
        /// <p>Update replication configuration replicated disks request.</p>
        pub fn set_replicated_disks(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ReplicationConfigurationReplicatedDisk>,
            >,
        ) -> Self {
            self.inner = self.inner.set_replicated_disks(input);
            self
        }
        /// <p>Update replication configuration EBS encryption request.</p>
        pub fn ebs_encryption(
            mut self,
            input: crate::model::ReplicationConfigurationEbsEncryption,
        ) -> Self {
            self.inner = self.inner.ebs_encryption(input);
            self
        }
        /// <p>Update replication configuration EBS encryption request.</p>
        pub fn set_ebs_encryption(
            mut self,
            input: std::option::Option<crate::model::ReplicationConfigurationEbsEncryption>,
        ) -> Self {
            self.inner = self.inner.set_ebs_encryption(input);
            self
        }
        /// <p>Update replication configuration EBS encryption key ARN request.</p>
        pub fn ebs_encryption_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ebs_encryption_key_arn(input.into());
            self
        }
        /// <p>Update replication configuration EBS encryption key ARN request.</p>
        pub fn set_ebs_encryption_key_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ebs_encryption_key_arn(input);
            self
        }
        /// <p>Update replication configuration bandwidth throttling request.</p>
        pub fn bandwidth_throttling(mut self, input: i64) -> Self {
            self.inner = self.inner.bandwidth_throttling(input);
            self
        }
        /// <p>Update replication configuration bandwidth throttling request.</p>
        pub fn set_bandwidth_throttling(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_bandwidth_throttling(input);
            self
        }
        /// <p>Update replication configuration data plane routing request.</p>
        pub fn data_plane_routing(
            mut self,
            input: crate::model::ReplicationConfigurationDataPlaneRouting,
        ) -> Self {
            self.inner = self.inner.data_plane_routing(input);
            self
        }
        /// <p>Update replication configuration data plane routing request.</p>
        pub fn set_data_plane_routing(
            mut self,
            input: std::option::Option<crate::model::ReplicationConfigurationDataPlaneRouting>,
        ) -> Self {
            self.inner = self.inner.set_data_plane_routing(input);
            self
        }
        /// <p>Update replication configuration create Public IP request.</p>
        pub fn create_public_ip(mut self, input: bool) -> Self {
            self.inner = self.inner.create_public_ip(input);
            self
        }
        /// <p>Update replication configuration create Public IP request.</p>
        pub fn set_create_public_ip(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_create_public_ip(input);
            self
        }
        /// Adds a key-value pair to `stagingAreaTags`.
        ///
        /// To override the contents of this collection use [`set_staging_area_tags`](Self::set_staging_area_tags).
        ///
        /// <p>Update replication configuration Staging Area Tags request.</p>
        pub fn staging_area_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.staging_area_tags(k.into(), v.into());
            self
        }
        /// <p>Update replication configuration Staging Area Tags request.</p>
        pub fn set_staging_area_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_staging_area_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateReplicationConfigurationTemplate`.
    ///
    /// <p>Updates multiple ReplicationConfigurationTemplates by ID.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateReplicationConfigurationTemplate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_replication_configuration_template_input::Builder,
    }
    impl UpdateReplicationConfigurationTemplate {
        /// Creates a new `UpdateReplicationConfigurationTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateReplicationConfigurationTemplateOutput,
            aws_smithy_http::result::SdkError<
                crate::error::UpdateReplicationConfigurationTemplateError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Update replication configuration template template ID request.</p>
        pub fn replication_configuration_template_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .replication_configuration_template_id(input.into());
            self
        }
        /// <p>Update replication configuration template template ID request.</p>
        pub fn set_replication_configuration_template_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_configuration_template_id(input);
            self
        }
        /// <p>Update replication configuration template ARN request.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p>Update replication configuration template ARN request.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p>Update replication configuration template Staging Area subnet ID request.</p>
        pub fn staging_area_subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.staging_area_subnet_id(input.into());
            self
        }
        /// <p>Update replication configuration template Staging Area subnet ID request.</p>
        pub fn set_staging_area_subnet_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_staging_area_subnet_id(input);
            self
        }
        /// <p>Update replication configuration template associate default Application Migration Service Security group request.</p>
        pub fn associate_default_security_group(mut self, input: bool) -> Self {
            self.inner = self.inner.associate_default_security_group(input);
            self
        }
        /// <p>Update replication configuration template associate default Application Migration Service Security group request.</p>
        pub fn set_associate_default_security_group(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_associate_default_security_group(input);
            self
        }
        /// Appends an item to `replicationServersSecurityGroupsIDs`.
        ///
        /// To override the contents of this collection use [`set_replication_servers_security_groups_i_ds`](Self::set_replication_servers_security_groups_i_ds).
        ///
        /// <p>Update replication configuration template Replication Server Security groups IDs request.</p>
        pub fn replication_servers_security_groups_i_ds(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .replication_servers_security_groups_i_ds(input.into());
            self
        }
        /// <p>Update replication configuration template Replication Server Security groups IDs request.</p>
        pub fn set_replication_servers_security_groups_i_ds(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self
                .inner
                .set_replication_servers_security_groups_i_ds(input);
            self
        }
        /// <p>Update replication configuration template Replication Server instance type request.</p>
        pub fn replication_server_instance_type(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.replication_server_instance_type(input.into());
            self
        }
        /// <p>Update replication configuration template Replication Server instance type request.</p>
        pub fn set_replication_server_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_server_instance_type(input);
            self
        }
        /// <p>Update replication configuration template use dedicated Replication Server request.</p>
        pub fn use_dedicated_replication_server(mut self, input: bool) -> Self {
            self.inner = self.inner.use_dedicated_replication_server(input);
            self
        }
        /// <p>Update replication configuration template use dedicated Replication Server request.</p>
        pub fn set_use_dedicated_replication_server(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_use_dedicated_replication_server(input);
            self
        }
        /// <p>Update replication configuration template use default large Staging Disk type request.</p>
        pub fn default_large_staging_disk_type(
            mut self,
            input: crate::model::ReplicationConfigurationDefaultLargeStagingDiskType,
        ) -> Self {
            self.inner = self.inner.default_large_staging_disk_type(input);
            self
        }
        /// <p>Update replication configuration template use default large Staging Disk type request.</p>
        pub fn set_default_large_staging_disk_type(
            mut self,
            input: std::option::Option<
                crate::model::ReplicationConfigurationDefaultLargeStagingDiskType,
            >,
        ) -> Self {
            self.inner = self.inner.set_default_large_staging_disk_type(input);
            self
        }
        /// <p>Update replication configuration template EBS encryption request.</p>
        pub fn ebs_encryption(
            mut self,
            input: crate::model::ReplicationConfigurationEbsEncryption,
        ) -> Self {
            self.inner = self.inner.ebs_encryption(input);
            self
        }
        /// <p>Update replication configuration template EBS encryption request.</p>
        pub fn set_ebs_encryption(
            mut self,
            input: std::option::Option<crate::model::ReplicationConfigurationEbsEncryption>,
        ) -> Self {
            self.inner = self.inner.set_ebs_encryption(input);
            self
        }
        /// <p>Update replication configuration template EBS encryption key ARN request.</p>
        pub fn ebs_encryption_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ebs_encryption_key_arn(input.into());
            self
        }
        /// <p>Update replication configuration template EBS encryption key ARN request.</p>
        pub fn set_ebs_encryption_key_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ebs_encryption_key_arn(input);
            self
        }
        /// <p>Update replication configuration template bandwidth throttling request.</p>
        pub fn bandwidth_throttling(mut self, input: i64) -> Self {
            self.inner = self.inner.bandwidth_throttling(input);
            self
        }
        /// <p>Update replication configuration template bandwidth throttling request.</p>
        pub fn set_bandwidth_throttling(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_bandwidth_throttling(input);
            self
        }
        /// <p>Update replication configuration template data plane routing request.</p>
        pub fn data_plane_routing(
            mut self,
            input: crate::model::ReplicationConfigurationDataPlaneRouting,
        ) -> Self {
            self.inner = self.inner.data_plane_routing(input);
            self
        }
        /// <p>Update replication configuration template data plane routing request.</p>
        pub fn set_data_plane_routing(
            mut self,
            input: std::option::Option<crate::model::ReplicationConfigurationDataPlaneRouting>,
        ) -> Self {
            self.inner = self.inner.set_data_plane_routing(input);
            self
        }
        /// <p>Update replication configuration template create Public IP request.</p>
        pub fn create_public_ip(mut self, input: bool) -> Self {
            self.inner = self.inner.create_public_ip(input);
            self
        }
        /// <p>Update replication configuration template create Public IP request.</p>
        pub fn set_create_public_ip(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_create_public_ip(input);
            self
        }
        /// Adds a key-value pair to `stagingAreaTags`.
        ///
        /// To override the contents of this collection use [`set_staging_area_tags`](Self::set_staging_area_tags).
        ///
        /// <p>Update replication configuration template Staging Area Tags request.</p>
        pub fn staging_area_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.staging_area_tags(k.into(), v.into());
            self
        }
        /// <p>Update replication configuration template Staging Area Tags request.</p>
        pub fn set_staging_area_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_staging_area_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSourceServerReplicationType`.
    ///
    /// <p>Allows you to change between the AGENT_BASED replication type and the SNAPSHOT_SHIPPING replication type.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateSourceServerReplicationType {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_source_server_replication_type_input::Builder,
    }
    impl UpdateSourceServerReplicationType {
        /// Creates a new `UpdateSourceServerReplicationType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSourceServerReplicationTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSourceServerReplicationTypeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>ID of source server on which to update replication type.</p>
        pub fn source_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_server_id(input.into());
            self
        }
        /// <p>ID of source server on which to update replication type.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_server_id(input);
            self
        }
        /// <p>Replication type to which to update source server.</p>
        pub fn replication_type(mut self, input: crate::model::ReplicationType) -> Self {
            self.inner = self.inner.replication_type(input);
            self
        }
        /// <p>Replication type to which to update source server.</p>
        pub fn set_replication_type(
            mut self,
            input: std::option::Option<crate::model::ReplicationType>,
        ) -> Self {
            self.inner = self.inner.set_replication_type(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
