// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `ChangeServerLifeCycleState` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ChangeServerLifeCycleStateError {
    /// Kind of error that occurred.
    pub kind: ChangeServerLifeCycleStateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ChangeServerLifeCycleState` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ChangeServerLifeCycleStateErrorKind {
    /// <p>The request could not be completed due to a conflict with the current state of the target resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Resource not found exception.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Unitialized account exception.</p>
    UninitializedAccountException(crate::error::UninitializedAccountException),
    /// <p>Validate exception.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ChangeServerLifeCycleStateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ChangeServerLifeCycleStateErrorKind::ConflictException(_inner) => _inner.fmt(f),
            ChangeServerLifeCycleStateErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ChangeServerLifeCycleStateErrorKind::UninitializedAccountException(_inner) => {
                _inner.fmt(f)
            }
            ChangeServerLifeCycleStateErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ChangeServerLifeCycleStateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ChangeServerLifeCycleStateError {
    fn code(&self) -> Option<&str> {
        ChangeServerLifeCycleStateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ChangeServerLifeCycleStateError {
    /// Creates a new `ChangeServerLifeCycleStateError`.
    pub fn new(kind: ChangeServerLifeCycleStateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ChangeServerLifeCycleStateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ChangeServerLifeCycleStateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ChangeServerLifeCycleStateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ChangeServerLifeCycleStateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ChangeServerLifeCycleStateErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            ChangeServerLifeCycleStateErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `ChangeServerLifeCycleStateErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ChangeServerLifeCycleStateErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ChangeServerLifeCycleStateErrorKind::UninitializedAccountException`.
    pub fn is_uninitialized_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            ChangeServerLifeCycleStateErrorKind::UninitializedAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `ChangeServerLifeCycleStateErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ChangeServerLifeCycleStateErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ChangeServerLifeCycleStateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ChangeServerLifeCycleStateErrorKind::ConflictException(_inner) => Some(_inner),
            ChangeServerLifeCycleStateErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ChangeServerLifeCycleStateErrorKind::UninitializedAccountException(_inner) => {
                Some(_inner)
            }
            ChangeServerLifeCycleStateErrorKind::ValidationException(_inner) => Some(_inner),
            ChangeServerLifeCycleStateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateReplicationConfigurationTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateReplicationConfigurationTemplateError {
    /// Kind of error that occurred.
    pub kind: CreateReplicationConfigurationTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateReplicationConfigurationTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateReplicationConfigurationTemplateErrorKind {
    /// <p>Operating denied due to a file permission or access check error.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Unitialized account exception.</p>
    UninitializedAccountException(crate::error::UninitializedAccountException),
    /// <p>Validate exception.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateReplicationConfigurationTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateReplicationConfigurationTemplateErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            CreateReplicationConfigurationTemplateErrorKind::UninitializedAccountException(
                _inner,
            ) => _inner.fmt(f),
            CreateReplicationConfigurationTemplateErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            CreateReplicationConfigurationTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateReplicationConfigurationTemplateError {
    fn code(&self) -> Option<&str> {
        CreateReplicationConfigurationTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateReplicationConfigurationTemplateError {
    /// Creates a new `CreateReplicationConfigurationTemplateError`.
    pub fn new(
        kind: CreateReplicationConfigurationTemplateErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateReplicationConfigurationTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateReplicationConfigurationTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateReplicationConfigurationTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateReplicationConfigurationTemplateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateReplicationConfigurationTemplateErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateReplicationConfigurationTemplateErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateReplicationConfigurationTemplateErrorKind::UninitializedAccountException`.
    pub fn is_uninitialized_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateReplicationConfigurationTemplateErrorKind::UninitializedAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateReplicationConfigurationTemplateErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateReplicationConfigurationTemplateErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateReplicationConfigurationTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateReplicationConfigurationTemplateErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            CreateReplicationConfigurationTemplateErrorKind::UninitializedAccountException(
                _inner,
            ) => Some(_inner),
            CreateReplicationConfigurationTemplateErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            CreateReplicationConfigurationTemplateErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DeleteJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteJobError {
    /// Kind of error that occurred.
    pub kind: DeleteJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteJobErrorKind {
    /// <p>The request could not be completed due to a conflict with the current state of the target resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Resource not found exception.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Unitialized account exception.</p>
    UninitializedAccountException(crate::error::UninitializedAccountException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteJobErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteJobErrorKind::UninitializedAccountException(_inner) => _inner.fmt(f),
            DeleteJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteJobError {
    fn code(&self) -> Option<&str> {
        DeleteJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteJobError {
    /// Creates a new `DeleteJobError`.
    pub fn new(kind: DeleteJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteJobErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteJobErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteJobErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeleteJobErrorKind::UninitializedAccountException`.
    pub fn is_uninitialized_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteJobErrorKind::UninitializedAccountException(_)
        )
    }
}
impl std::error::Error for DeleteJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteJobErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteJobErrorKind::UninitializedAccountException(_inner) => Some(_inner),
            DeleteJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteReplicationConfigurationTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteReplicationConfigurationTemplateError {
    /// Kind of error that occurred.
    pub kind: DeleteReplicationConfigurationTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteReplicationConfigurationTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteReplicationConfigurationTemplateErrorKind {
    /// <p>The request could not be completed due to a conflict with the current state of the target resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Resource not found exception.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Unitialized account exception.</p>
    UninitializedAccountException(crate::error::UninitializedAccountException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteReplicationConfigurationTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteReplicationConfigurationTemplateErrorKind::ConflictException(_inner) => {
                _inner.fmt(f)
            }
            DeleteReplicationConfigurationTemplateErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeleteReplicationConfigurationTemplateErrorKind::UninitializedAccountException(
                _inner,
            ) => _inner.fmt(f),
            DeleteReplicationConfigurationTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteReplicationConfigurationTemplateError {
    fn code(&self) -> Option<&str> {
        DeleteReplicationConfigurationTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteReplicationConfigurationTemplateError {
    /// Creates a new `DeleteReplicationConfigurationTemplateError`.
    pub fn new(
        kind: DeleteReplicationConfigurationTemplateErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteReplicationConfigurationTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteReplicationConfigurationTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteReplicationConfigurationTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteReplicationConfigurationTemplateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteReplicationConfigurationTemplateErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteReplicationConfigurationTemplateErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteReplicationConfigurationTemplateErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteReplicationConfigurationTemplateErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteReplicationConfigurationTemplateErrorKind::UninitializedAccountException`.
    pub fn is_uninitialized_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteReplicationConfigurationTemplateErrorKind::UninitializedAccountException(_)
        )
    }
}
impl std::error::Error for DeleteReplicationConfigurationTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteReplicationConfigurationTemplateErrorKind::ConflictException(_inner) => {
                Some(_inner)
            }
            DeleteReplicationConfigurationTemplateErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DeleteReplicationConfigurationTemplateErrorKind::UninitializedAccountException(
                _inner,
            ) => Some(_inner),
            DeleteReplicationConfigurationTemplateErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DeleteSourceServer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteSourceServerError {
    /// Kind of error that occurred.
    pub kind: DeleteSourceServerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteSourceServer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteSourceServerErrorKind {
    /// <p>The request could not be completed due to a conflict with the current state of the target resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Resource not found exception.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Unitialized account exception.</p>
    UninitializedAccountException(crate::error::UninitializedAccountException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteSourceServerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteSourceServerErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteSourceServerErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteSourceServerErrorKind::UninitializedAccountException(_inner) => _inner.fmt(f),
            DeleteSourceServerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteSourceServerError {
    fn code(&self) -> Option<&str> {
        DeleteSourceServerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteSourceServerError {
    /// Creates a new `DeleteSourceServerError`.
    pub fn new(kind: DeleteSourceServerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteSourceServerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteSourceServerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteSourceServerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteSourceServerErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteSourceServerErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSourceServerErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSourceServerErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSourceServerErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSourceServerErrorKind::UninitializedAccountException`.
    pub fn is_uninitialized_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSourceServerErrorKind::UninitializedAccountException(_)
        )
    }
}
impl std::error::Error for DeleteSourceServerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteSourceServerErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteSourceServerErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteSourceServerErrorKind::UninitializedAccountException(_inner) => Some(_inner),
            DeleteSourceServerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteVcenterClient` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteVcenterClientError {
    /// Kind of error that occurred.
    pub kind: DeleteVcenterClientErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteVcenterClient` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteVcenterClientErrorKind {
    /// <p>Resource not found exception.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Unitialized account exception.</p>
    UninitializedAccountException(crate::error::UninitializedAccountException),
    /// <p>Validate exception.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteVcenterClientError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteVcenterClientErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteVcenterClientErrorKind::UninitializedAccountException(_inner) => _inner.fmt(f),
            DeleteVcenterClientErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteVcenterClientErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteVcenterClientError {
    fn code(&self) -> Option<&str> {
        DeleteVcenterClientError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteVcenterClientError {
    /// Creates a new `DeleteVcenterClientError`.
    pub fn new(kind: DeleteVcenterClientErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteVcenterClientError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteVcenterClientErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteVcenterClientError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteVcenterClientErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteVcenterClientErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVcenterClientErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVcenterClientErrorKind::UninitializedAccountException`.
    pub fn is_uninitialized_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVcenterClientErrorKind::UninitializedAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVcenterClientErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVcenterClientErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteVcenterClientError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteVcenterClientErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteVcenterClientErrorKind::UninitializedAccountException(_inner) => Some(_inner),
            DeleteVcenterClientErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteVcenterClientErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeJobLogItems` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeJobLogItemsError {
    /// Kind of error that occurred.
    pub kind: DescribeJobLogItemsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeJobLogItems` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeJobLogItemsErrorKind {
    /// <p>Unitialized account exception.</p>
    UninitializedAccountException(crate::error::UninitializedAccountException),
    /// <p>Validate exception.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeJobLogItemsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeJobLogItemsErrorKind::UninitializedAccountException(_inner) => _inner.fmt(f),
            DescribeJobLogItemsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeJobLogItemsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeJobLogItemsError {
    fn code(&self) -> Option<&str> {
        DescribeJobLogItemsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeJobLogItemsError {
    /// Creates a new `DescribeJobLogItemsError`.
    pub fn new(kind: DescribeJobLogItemsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeJobLogItemsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeJobLogItemsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeJobLogItemsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeJobLogItemsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeJobLogItemsErrorKind::UninitializedAccountException`.
    pub fn is_uninitialized_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeJobLogItemsErrorKind::UninitializedAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeJobLogItemsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeJobLogItemsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeJobLogItemsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeJobLogItemsErrorKind::UninitializedAccountException(_inner) => Some(_inner),
            DescribeJobLogItemsErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeJobLogItemsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeJobsError {
    /// Kind of error that occurred.
    pub kind: DescribeJobsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeJobsErrorKind {
    /// <p>Unitialized account exception.</p>
    UninitializedAccountException(crate::error::UninitializedAccountException),
    /// <p>Validate exception.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeJobsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeJobsErrorKind::UninitializedAccountException(_inner) => _inner.fmt(f),
            DescribeJobsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeJobsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeJobsError {
    fn code(&self) -> Option<&str> {
        DescribeJobsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeJobsError {
    /// Creates a new `DescribeJobsError`.
    pub fn new(kind: DescribeJobsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeJobsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeJobsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeJobsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeJobsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeJobsErrorKind::UninitializedAccountException`.
    pub fn is_uninitialized_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeJobsErrorKind::UninitializedAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeJobsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DescribeJobsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DescribeJobsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeJobsErrorKind::UninitializedAccountException(_inner) => Some(_inner),
            DescribeJobsErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeJobsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeReplicationConfigurationTemplates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeReplicationConfigurationTemplatesError {
    /// Kind of error that occurred.
    pub kind: DescribeReplicationConfigurationTemplatesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeReplicationConfigurationTemplates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeReplicationConfigurationTemplatesErrorKind {
    /// <p>Resource not found exception.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Unitialized account exception.</p>
    UninitializedAccountException(crate::error::UninitializedAccountException),
    /// <p>Validate exception.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeReplicationConfigurationTemplatesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeReplicationConfigurationTemplatesErrorKind::ResourceNotFoundException(
                _inner,
            ) => _inner.fmt(f),
            DescribeReplicationConfigurationTemplatesErrorKind::UninitializedAccountException(
                _inner,
            ) => _inner.fmt(f),
            DescribeReplicationConfigurationTemplatesErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            DescribeReplicationConfigurationTemplatesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeReplicationConfigurationTemplatesError {
    fn code(&self) -> Option<&str> {
        DescribeReplicationConfigurationTemplatesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeReplicationConfigurationTemplatesError {
    /// Creates a new `DescribeReplicationConfigurationTemplatesError`.
    pub fn new(
        kind: DescribeReplicationConfigurationTemplatesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeReplicationConfigurationTemplatesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeReplicationConfigurationTemplatesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeReplicationConfigurationTemplatesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeReplicationConfigurationTemplatesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeReplicationConfigurationTemplatesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReplicationConfigurationTemplatesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeReplicationConfigurationTemplatesErrorKind::UninitializedAccountException`.
    pub fn is_uninitialized_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReplicationConfigurationTemplatesErrorKind::UninitializedAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeReplicationConfigurationTemplatesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReplicationConfigurationTemplatesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeReplicationConfigurationTemplatesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeReplicationConfigurationTemplatesErrorKind::ResourceNotFoundException(
                _inner,
            ) => Some(_inner),
            DescribeReplicationConfigurationTemplatesErrorKind::UninitializedAccountException(
                _inner,
            ) => Some(_inner),
            DescribeReplicationConfigurationTemplatesErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            DescribeReplicationConfigurationTemplatesErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeSourceServers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeSourceServersError {
    /// Kind of error that occurred.
    pub kind: DescribeSourceServersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeSourceServers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeSourceServersErrorKind {
    /// <p>Unitialized account exception.</p>
    UninitializedAccountException(crate::error::UninitializedAccountException),
    /// <p>Validate exception.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeSourceServersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeSourceServersErrorKind::UninitializedAccountException(_inner) => _inner.fmt(f),
            DescribeSourceServersErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeSourceServersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeSourceServersError {
    fn code(&self) -> Option<&str> {
        DescribeSourceServersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeSourceServersError {
    /// Creates a new `DescribeSourceServersError`.
    pub fn new(kind: DescribeSourceServersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeSourceServersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeSourceServersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeSourceServersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeSourceServersErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeSourceServersErrorKind::UninitializedAccountException`.
    pub fn is_uninitialized_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSourceServersErrorKind::UninitializedAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSourceServersErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSourceServersErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeSourceServersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeSourceServersErrorKind::UninitializedAccountException(_inner) => Some(_inner),
            DescribeSourceServersErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeSourceServersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeVcenterClients` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeVcenterClientsError {
    /// Kind of error that occurred.
    pub kind: DescribeVcenterClientsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeVcenterClients` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeVcenterClientsErrorKind {
    /// <p>Resource not found exception.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Unitialized account exception.</p>
    UninitializedAccountException(crate::error::UninitializedAccountException),
    /// <p>Validate exception.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeVcenterClientsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeVcenterClientsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeVcenterClientsErrorKind::UninitializedAccountException(_inner) => _inner.fmt(f),
            DescribeVcenterClientsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeVcenterClientsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeVcenterClientsError {
    fn code(&self) -> Option<&str> {
        DescribeVcenterClientsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeVcenterClientsError {
    /// Creates a new `DescribeVcenterClientsError`.
    pub fn new(kind: DescribeVcenterClientsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeVcenterClientsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeVcenterClientsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeVcenterClientsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeVcenterClientsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeVcenterClientsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeVcenterClientsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeVcenterClientsErrorKind::UninitializedAccountException`.
    pub fn is_uninitialized_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeVcenterClientsErrorKind::UninitializedAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeVcenterClientsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeVcenterClientsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeVcenterClientsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeVcenterClientsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeVcenterClientsErrorKind::UninitializedAccountException(_inner) => Some(_inner),
            DescribeVcenterClientsErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeVcenterClientsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisconnectFromService` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisconnectFromServiceError {
    /// Kind of error that occurred.
    pub kind: DisconnectFromServiceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisconnectFromService` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisconnectFromServiceErrorKind {
    /// <p>The request could not be completed due to a conflict with the current state of the target resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Resource not found exception.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Unitialized account exception.</p>
    UninitializedAccountException(crate::error::UninitializedAccountException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisconnectFromServiceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisconnectFromServiceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DisconnectFromServiceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DisconnectFromServiceErrorKind::UninitializedAccountException(_inner) => _inner.fmt(f),
            DisconnectFromServiceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisconnectFromServiceError {
    fn code(&self) -> Option<&str> {
        DisconnectFromServiceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisconnectFromServiceError {
    /// Creates a new `DisconnectFromServiceError`.
    pub fn new(kind: DisconnectFromServiceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisconnectFromServiceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisconnectFromServiceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisconnectFromServiceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisconnectFromServiceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisconnectFromServiceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisconnectFromServiceErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DisconnectFromServiceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisconnectFromServiceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisconnectFromServiceErrorKind::UninitializedAccountException`.
    pub fn is_uninitialized_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisconnectFromServiceErrorKind::UninitializedAccountException(_)
        )
    }
}
impl std::error::Error for DisconnectFromServiceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisconnectFromServiceErrorKind::ConflictException(_inner) => Some(_inner),
            DisconnectFromServiceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DisconnectFromServiceErrorKind::UninitializedAccountException(_inner) => Some(_inner),
            DisconnectFromServiceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `FinalizeCutover` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct FinalizeCutoverError {
    /// Kind of error that occurred.
    pub kind: FinalizeCutoverErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `FinalizeCutover` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum FinalizeCutoverErrorKind {
    /// <p>The request could not be completed due to a conflict with the current state of the target resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Resource not found exception.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Unitialized account exception.</p>
    UninitializedAccountException(crate::error::UninitializedAccountException),
    /// <p>Validate exception.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for FinalizeCutoverError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            FinalizeCutoverErrorKind::ConflictException(_inner) => _inner.fmt(f),
            FinalizeCutoverErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            FinalizeCutoverErrorKind::UninitializedAccountException(_inner) => _inner.fmt(f),
            FinalizeCutoverErrorKind::ValidationException(_inner) => _inner.fmt(f),
            FinalizeCutoverErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for FinalizeCutoverError {
    fn code(&self) -> Option<&str> {
        FinalizeCutoverError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl FinalizeCutoverError {
    /// Creates a new `FinalizeCutoverError`.
    pub fn new(kind: FinalizeCutoverErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `FinalizeCutoverError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: FinalizeCutoverErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `FinalizeCutoverError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: FinalizeCutoverErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `FinalizeCutoverErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, FinalizeCutoverErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `FinalizeCutoverErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            FinalizeCutoverErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `FinalizeCutoverErrorKind::UninitializedAccountException`.
    pub fn is_uninitialized_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            FinalizeCutoverErrorKind::UninitializedAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `FinalizeCutoverErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, FinalizeCutoverErrorKind::ValidationException(_))
    }
}
impl std::error::Error for FinalizeCutoverError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            FinalizeCutoverErrorKind::ConflictException(_inner) => Some(_inner),
            FinalizeCutoverErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            FinalizeCutoverErrorKind::UninitializedAccountException(_inner) => Some(_inner),
            FinalizeCutoverErrorKind::ValidationException(_inner) => Some(_inner),
            FinalizeCutoverErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetLaunchConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetLaunchConfigurationError {
    /// Kind of error that occurred.
    pub kind: GetLaunchConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetLaunchConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetLaunchConfigurationErrorKind {
    /// <p>Resource not found exception.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Unitialized account exception.</p>
    UninitializedAccountException(crate::error::UninitializedAccountException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetLaunchConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetLaunchConfigurationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetLaunchConfigurationErrorKind::UninitializedAccountException(_inner) => _inner.fmt(f),
            GetLaunchConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetLaunchConfigurationError {
    fn code(&self) -> Option<&str> {
        GetLaunchConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetLaunchConfigurationError {
    /// Creates a new `GetLaunchConfigurationError`.
    pub fn new(kind: GetLaunchConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetLaunchConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetLaunchConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetLaunchConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetLaunchConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetLaunchConfigurationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLaunchConfigurationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLaunchConfigurationErrorKind::UninitializedAccountException`.
    pub fn is_uninitialized_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLaunchConfigurationErrorKind::UninitializedAccountException(_)
        )
    }
}
impl std::error::Error for GetLaunchConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetLaunchConfigurationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetLaunchConfigurationErrorKind::UninitializedAccountException(_inner) => Some(_inner),
            GetLaunchConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetReplicationConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetReplicationConfigurationError {
    /// Kind of error that occurred.
    pub kind: GetReplicationConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetReplicationConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetReplicationConfigurationErrorKind {
    /// <p>Resource not found exception.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Unitialized account exception.</p>
    UninitializedAccountException(crate::error::UninitializedAccountException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetReplicationConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetReplicationConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetReplicationConfigurationErrorKind::UninitializedAccountException(_inner) => {
                _inner.fmt(f)
            }
            GetReplicationConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetReplicationConfigurationError {
    fn code(&self) -> Option<&str> {
        GetReplicationConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetReplicationConfigurationError {
    /// Creates a new `GetReplicationConfigurationError`.
    pub fn new(kind: GetReplicationConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetReplicationConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetReplicationConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetReplicationConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetReplicationConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetReplicationConfigurationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetReplicationConfigurationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetReplicationConfigurationErrorKind::UninitializedAccountException`.
    pub fn is_uninitialized_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetReplicationConfigurationErrorKind::UninitializedAccountException(_)
        )
    }
}
impl std::error::Error for GetReplicationConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetReplicationConfigurationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetReplicationConfigurationErrorKind::UninitializedAccountException(_inner) => {
                Some(_inner)
            }
            GetReplicationConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `InitializeService` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct InitializeServiceError {
    /// Kind of error that occurred.
    pub kind: InitializeServiceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `InitializeService` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum InitializeServiceErrorKind {
    /// <p>Operating denied due to a file permission or access check error.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Validate exception.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for InitializeServiceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            InitializeServiceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            InitializeServiceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            InitializeServiceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for InitializeServiceError {
    fn code(&self) -> Option<&str> {
        InitializeServiceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl InitializeServiceError {
    /// Creates a new `InitializeServiceError`.
    pub fn new(kind: InitializeServiceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `InitializeServiceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: InitializeServiceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `InitializeServiceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: InitializeServiceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `InitializeServiceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            InitializeServiceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `InitializeServiceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            InitializeServiceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for InitializeServiceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            InitializeServiceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            InitializeServiceErrorKind::ValidationException(_inner) => Some(_inner),
            InitializeServiceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>Operating denied due to a file permission or access check error.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The server encountered an unexpected condition that prevented it from fulfilling the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource not found exception.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Reached throttling quota exception.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Validate exception.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ValidationException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `MarkAsArchived` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct MarkAsArchivedError {
    /// Kind of error that occurred.
    pub kind: MarkAsArchivedErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `MarkAsArchived` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum MarkAsArchivedErrorKind {
    /// <p>The request could not be completed due to a conflict with the current state of the target resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Resource not found exception.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Unitialized account exception.</p>
    UninitializedAccountException(crate::error::UninitializedAccountException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for MarkAsArchivedError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            MarkAsArchivedErrorKind::ConflictException(_inner) => _inner.fmt(f),
            MarkAsArchivedErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            MarkAsArchivedErrorKind::UninitializedAccountException(_inner) => _inner.fmt(f),
            MarkAsArchivedErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for MarkAsArchivedError {
    fn code(&self) -> Option<&str> {
        MarkAsArchivedError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl MarkAsArchivedError {
    /// Creates a new `MarkAsArchivedError`.
    pub fn new(kind: MarkAsArchivedErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `MarkAsArchivedError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: MarkAsArchivedErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `MarkAsArchivedError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: MarkAsArchivedErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `MarkAsArchivedErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, MarkAsArchivedErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `MarkAsArchivedErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            MarkAsArchivedErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `MarkAsArchivedErrorKind::UninitializedAccountException`.
    pub fn is_uninitialized_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            MarkAsArchivedErrorKind::UninitializedAccountException(_)
        )
    }
}
impl std::error::Error for MarkAsArchivedError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            MarkAsArchivedErrorKind::ConflictException(_inner) => Some(_inner),
            MarkAsArchivedErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            MarkAsArchivedErrorKind::UninitializedAccountException(_inner) => Some(_inner),
            MarkAsArchivedErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RetryDataReplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RetryDataReplicationError {
    /// Kind of error that occurred.
    pub kind: RetryDataReplicationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RetryDataReplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RetryDataReplicationErrorKind {
    /// <p>Resource not found exception.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Unitialized account exception.</p>
    UninitializedAccountException(crate::error::UninitializedAccountException),
    /// <p>Validate exception.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RetryDataReplicationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RetryDataReplicationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            RetryDataReplicationErrorKind::UninitializedAccountException(_inner) => _inner.fmt(f),
            RetryDataReplicationErrorKind::ValidationException(_inner) => _inner.fmt(f),
            RetryDataReplicationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RetryDataReplicationError {
    fn code(&self) -> Option<&str> {
        RetryDataReplicationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RetryDataReplicationError {
    /// Creates a new `RetryDataReplicationError`.
    pub fn new(kind: RetryDataReplicationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RetryDataReplicationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RetryDataReplicationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RetryDataReplicationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RetryDataReplicationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RetryDataReplicationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RetryDataReplicationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `RetryDataReplicationErrorKind::UninitializedAccountException`.
    pub fn is_uninitialized_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            RetryDataReplicationErrorKind::UninitializedAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `RetryDataReplicationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            RetryDataReplicationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for RetryDataReplicationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RetryDataReplicationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            RetryDataReplicationErrorKind::UninitializedAccountException(_inner) => Some(_inner),
            RetryDataReplicationErrorKind::ValidationException(_inner) => Some(_inner),
            RetryDataReplicationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartCutover` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartCutoverError {
    /// Kind of error that occurred.
    pub kind: StartCutoverErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartCutover` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartCutoverErrorKind {
    /// <p>The request could not be completed due to a conflict with the current state of the target resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Unitialized account exception.</p>
    UninitializedAccountException(crate::error::UninitializedAccountException),
    /// <p>Validate exception.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartCutoverError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartCutoverErrorKind::ConflictException(_inner) => _inner.fmt(f),
            StartCutoverErrorKind::UninitializedAccountException(_inner) => _inner.fmt(f),
            StartCutoverErrorKind::ValidationException(_inner) => _inner.fmt(f),
            StartCutoverErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartCutoverError {
    fn code(&self) -> Option<&str> {
        StartCutoverError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartCutoverError {
    /// Creates a new `StartCutoverError`.
    pub fn new(kind: StartCutoverErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartCutoverError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartCutoverErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartCutoverError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartCutoverErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartCutoverErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, StartCutoverErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `StartCutoverErrorKind::UninitializedAccountException`.
    pub fn is_uninitialized_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartCutoverErrorKind::UninitializedAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `StartCutoverErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, StartCutoverErrorKind::ValidationException(_))
    }
}
impl std::error::Error for StartCutoverError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartCutoverErrorKind::ConflictException(_inner) => Some(_inner),
            StartCutoverErrorKind::UninitializedAccountException(_inner) => Some(_inner),
            StartCutoverErrorKind::ValidationException(_inner) => Some(_inner),
            StartCutoverErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartReplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartReplicationError {
    /// Kind of error that occurred.
    pub kind: StartReplicationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartReplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartReplicationErrorKind {
    /// <p>The request could not be completed due to a conflict with the current state of the target resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Resource not found exception.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request could not be completed because its exceeded the service quota.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Unitialized account exception.</p>
    UninitializedAccountException(crate::error::UninitializedAccountException),
    /// <p>Validate exception.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartReplicationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartReplicationErrorKind::ConflictException(_inner) => _inner.fmt(f),
            StartReplicationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StartReplicationErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            StartReplicationErrorKind::UninitializedAccountException(_inner) => _inner.fmt(f),
            StartReplicationErrorKind::ValidationException(_inner) => _inner.fmt(f),
            StartReplicationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartReplicationError {
    fn code(&self) -> Option<&str> {
        StartReplicationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartReplicationError {
    /// Creates a new `StartReplicationError`.
    pub fn new(kind: StartReplicationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartReplicationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartReplicationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartReplicationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartReplicationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartReplicationErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, StartReplicationErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `StartReplicationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartReplicationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StartReplicationErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartReplicationErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `StartReplicationErrorKind::UninitializedAccountException`.
    pub fn is_uninitialized_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartReplicationErrorKind::UninitializedAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `StartReplicationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartReplicationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for StartReplicationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartReplicationErrorKind::ConflictException(_inner) => Some(_inner),
            StartReplicationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StartReplicationErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            StartReplicationErrorKind::UninitializedAccountException(_inner) => Some(_inner),
            StartReplicationErrorKind::ValidationException(_inner) => Some(_inner),
            StartReplicationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartTest` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartTestError {
    /// Kind of error that occurred.
    pub kind: StartTestErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartTest` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartTestErrorKind {
    /// <p>The request could not be completed due to a conflict with the current state of the target resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Unitialized account exception.</p>
    UninitializedAccountException(crate::error::UninitializedAccountException),
    /// <p>Validate exception.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartTestError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartTestErrorKind::ConflictException(_inner) => _inner.fmt(f),
            StartTestErrorKind::UninitializedAccountException(_inner) => _inner.fmt(f),
            StartTestErrorKind::ValidationException(_inner) => _inner.fmt(f),
            StartTestErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartTestError {
    fn code(&self) -> Option<&str> {
        StartTestError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartTestError {
    /// Creates a new `StartTestError`.
    pub fn new(kind: StartTestErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartTestError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartTestErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartTestError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartTestErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartTestErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, StartTestErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `StartTestErrorKind::UninitializedAccountException`.
    pub fn is_uninitialized_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartTestErrorKind::UninitializedAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `StartTestErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, StartTestErrorKind::ValidationException(_))
    }
}
impl std::error::Error for StartTestError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartTestErrorKind::ConflictException(_inner) => Some(_inner),
            StartTestErrorKind::UninitializedAccountException(_inner) => Some(_inner),
            StartTestErrorKind::ValidationException(_inner) => Some(_inner),
            StartTestErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>Operating denied due to a file permission or access check error.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The server encountered an unexpected condition that prevented it from fulfilling the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource not found exception.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Reached throttling quota exception.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Validate exception.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            TagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            TagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TerminateTargetInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TerminateTargetInstancesError {
    /// Kind of error that occurred.
    pub kind: TerminateTargetInstancesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TerminateTargetInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TerminateTargetInstancesErrorKind {
    /// <p>The request could not be completed due to a conflict with the current state of the target resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Unitialized account exception.</p>
    UninitializedAccountException(crate::error::UninitializedAccountException),
    /// <p>Validate exception.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TerminateTargetInstancesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TerminateTargetInstancesErrorKind::ConflictException(_inner) => _inner.fmt(f),
            TerminateTargetInstancesErrorKind::UninitializedAccountException(_inner) => {
                _inner.fmt(f)
            }
            TerminateTargetInstancesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            TerminateTargetInstancesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TerminateTargetInstancesError {
    fn code(&self) -> Option<&str> {
        TerminateTargetInstancesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TerminateTargetInstancesError {
    /// Creates a new `TerminateTargetInstancesError`.
    pub fn new(kind: TerminateTargetInstancesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TerminateTargetInstancesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TerminateTargetInstancesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TerminateTargetInstancesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TerminateTargetInstancesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TerminateTargetInstancesErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            TerminateTargetInstancesErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `TerminateTargetInstancesErrorKind::UninitializedAccountException`.
    pub fn is_uninitialized_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            TerminateTargetInstancesErrorKind::UninitializedAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `TerminateTargetInstancesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            TerminateTargetInstancesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for TerminateTargetInstancesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TerminateTargetInstancesErrorKind::ConflictException(_inner) => Some(_inner),
            TerminateTargetInstancesErrorKind::UninitializedAccountException(_inner) => {
                Some(_inner)
            }
            TerminateTargetInstancesErrorKind::ValidationException(_inner) => Some(_inner),
            TerminateTargetInstancesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>Operating denied due to a file permission or access check error.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The server encountered an unexpected condition that prevented it from fulfilling the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource not found exception.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Reached throttling quota exception.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Validate exception.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UntagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            UntagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateLaunchConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateLaunchConfigurationError {
    /// Kind of error that occurred.
    pub kind: UpdateLaunchConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateLaunchConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateLaunchConfigurationErrorKind {
    /// <p>The request could not be completed due to a conflict with the current state of the target resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Resource not found exception.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Unitialized account exception.</p>
    UninitializedAccountException(crate::error::UninitializedAccountException),
    /// <p>Validate exception.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateLaunchConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateLaunchConfigurationErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateLaunchConfigurationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateLaunchConfigurationErrorKind::UninitializedAccountException(_inner) => {
                _inner.fmt(f)
            }
            UpdateLaunchConfigurationErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateLaunchConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateLaunchConfigurationError {
    fn code(&self) -> Option<&str> {
        UpdateLaunchConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateLaunchConfigurationError {
    /// Creates a new `UpdateLaunchConfigurationError`.
    pub fn new(kind: UpdateLaunchConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateLaunchConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateLaunchConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateLaunchConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateLaunchConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateLaunchConfigurationErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLaunchConfigurationErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateLaunchConfigurationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLaunchConfigurationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateLaunchConfigurationErrorKind::UninitializedAccountException`.
    pub fn is_uninitialized_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLaunchConfigurationErrorKind::UninitializedAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateLaunchConfigurationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLaunchConfigurationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateLaunchConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateLaunchConfigurationErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateLaunchConfigurationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateLaunchConfigurationErrorKind::UninitializedAccountException(_inner) => {
                Some(_inner)
            }
            UpdateLaunchConfigurationErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateLaunchConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateReplicationConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateReplicationConfigurationError {
    /// Kind of error that occurred.
    pub kind: UpdateReplicationConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateReplicationConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateReplicationConfigurationErrorKind {
    /// <p>Operating denied due to a file permission or access check error.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request could not be completed due to a conflict with the current state of the target resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Resource not found exception.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Unitialized account exception.</p>
    UninitializedAccountException(crate::error::UninitializedAccountException),
    /// <p>Validate exception.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateReplicationConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateReplicationConfigurationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateReplicationConfigurationErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateReplicationConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateReplicationConfigurationErrorKind::UninitializedAccountException(_inner) => {
                _inner.fmt(f)
            }
            UpdateReplicationConfigurationErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateReplicationConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateReplicationConfigurationError {
    fn code(&self) -> Option<&str> {
        UpdateReplicationConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateReplicationConfigurationError {
    /// Creates a new `UpdateReplicationConfigurationError`.
    pub fn new(
        kind: UpdateReplicationConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateReplicationConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateReplicationConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateReplicationConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateReplicationConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateReplicationConfigurationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateReplicationConfigurationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateReplicationConfigurationErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateReplicationConfigurationErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateReplicationConfigurationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateReplicationConfigurationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateReplicationConfigurationErrorKind::UninitializedAccountException`.
    pub fn is_uninitialized_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateReplicationConfigurationErrorKind::UninitializedAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateReplicationConfigurationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateReplicationConfigurationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateReplicationConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateReplicationConfigurationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateReplicationConfigurationErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateReplicationConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            UpdateReplicationConfigurationErrorKind::UninitializedAccountException(_inner) => {
                Some(_inner)
            }
            UpdateReplicationConfigurationErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateReplicationConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateReplicationConfigurationTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateReplicationConfigurationTemplateError {
    /// Kind of error that occurred.
    pub kind: UpdateReplicationConfigurationTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateReplicationConfigurationTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateReplicationConfigurationTemplateErrorKind {
    /// <p>Operating denied due to a file permission or access check error.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Resource not found exception.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Unitialized account exception.</p>
    UninitializedAccountException(crate::error::UninitializedAccountException),
    /// <p>Validate exception.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateReplicationConfigurationTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateReplicationConfigurationTemplateErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            UpdateReplicationConfigurationTemplateErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateReplicationConfigurationTemplateErrorKind::UninitializedAccountException(
                _inner,
            ) => _inner.fmt(f),
            UpdateReplicationConfigurationTemplateErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            UpdateReplicationConfigurationTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateReplicationConfigurationTemplateError {
    fn code(&self) -> Option<&str> {
        UpdateReplicationConfigurationTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateReplicationConfigurationTemplateError {
    /// Creates a new `UpdateReplicationConfigurationTemplateError`.
    pub fn new(
        kind: UpdateReplicationConfigurationTemplateErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateReplicationConfigurationTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateReplicationConfigurationTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateReplicationConfigurationTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateReplicationConfigurationTemplateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateReplicationConfigurationTemplateErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateReplicationConfigurationTemplateErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateReplicationConfigurationTemplateErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateReplicationConfigurationTemplateErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateReplicationConfigurationTemplateErrorKind::UninitializedAccountException`.
    pub fn is_uninitialized_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateReplicationConfigurationTemplateErrorKind::UninitializedAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateReplicationConfigurationTemplateErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateReplicationConfigurationTemplateErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateReplicationConfigurationTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateReplicationConfigurationTemplateErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            UpdateReplicationConfigurationTemplateErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            UpdateReplicationConfigurationTemplateErrorKind::UninitializedAccountException(
                _inner,
            ) => Some(_inner),
            UpdateReplicationConfigurationTemplateErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            UpdateReplicationConfigurationTemplateErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `UpdateSourceServerReplicationType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateSourceServerReplicationTypeError {
    /// Kind of error that occurred.
    pub kind: UpdateSourceServerReplicationTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateSourceServerReplicationType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateSourceServerReplicationTypeErrorKind {
    /// <p>The request could not be completed due to a conflict with the current state of the target resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Resource not found exception.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Unitialized account exception.</p>
    UninitializedAccountException(crate::error::UninitializedAccountException),
    /// <p>Validate exception.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateSourceServerReplicationTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateSourceServerReplicationTypeErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateSourceServerReplicationTypeErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateSourceServerReplicationTypeErrorKind::UninitializedAccountException(_inner) => {
                _inner.fmt(f)
            }
            UpdateSourceServerReplicationTypeErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            UpdateSourceServerReplicationTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateSourceServerReplicationTypeError {
    fn code(&self) -> Option<&str> {
        UpdateSourceServerReplicationTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateSourceServerReplicationTypeError {
    /// Creates a new `UpdateSourceServerReplicationTypeError`.
    pub fn new(
        kind: UpdateSourceServerReplicationTypeErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateSourceServerReplicationTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateSourceServerReplicationTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateSourceServerReplicationTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateSourceServerReplicationTypeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateSourceServerReplicationTypeErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSourceServerReplicationTypeErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSourceServerReplicationTypeErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSourceServerReplicationTypeErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSourceServerReplicationTypeErrorKind::UninitializedAccountException`.
    pub fn is_uninitialized_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSourceServerReplicationTypeErrorKind::UninitializedAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSourceServerReplicationTypeErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSourceServerReplicationTypeErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateSourceServerReplicationTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateSourceServerReplicationTypeErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateSourceServerReplicationTypeErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            UpdateSourceServerReplicationTypeErrorKind::UninitializedAccountException(_inner) => {
                Some(_inner)
            }
            UpdateSourceServerReplicationTypeErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateSourceServerReplicationTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>Validate exception.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub code: std::option::Option<std::string::String>,
    /// <p>Validate exception reason.</p>
    pub reason: std::option::Option<crate::model::ValidationExceptionReason>,
    /// <p>Validate exception field list.</p>
    pub field_list: std::option::Option<std::vec::Vec<crate::model::ValidationExceptionField>>,
}
impl ValidationException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
    /// <p>Validate exception reason.</p>
    pub fn reason(&self) -> std::option::Option<&crate::model::ValidationExceptionReason> {
        self.reason.as_ref()
    }
    /// <p>Validate exception field list.</p>
    pub fn field_list(&self) -> std::option::Option<&[crate::model::ValidationExceptionField]> {
        self.field_list.as_deref()
    }
}
impl std::fmt::Debug for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationException");
        formatter.field("message", &self.message);
        formatter.field("code", &self.code);
        formatter.field("reason", &self.reason);
        formatter.field("field_list", &self.field_list);
        formatter.finish()
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ValidationException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ValidationException {}
/// See [`ValidationException`](crate::error::ValidationException)
pub mod validation_exception {
    /// A builder for [`ValidationException`](crate::error::ValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<crate::model::ValidationExceptionReason>,
        pub(crate) field_list:
            std::option::Option<std::vec::Vec<crate::model::ValidationExceptionField>>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>Validate exception reason.</p>
        pub fn reason(mut self, input: crate::model::ValidationExceptionReason) -> Self {
            self.reason = Some(input);
            self
        }
        /// <p>Validate exception reason.</p>
        pub fn set_reason(
            mut self,
            input: std::option::Option<crate::model::ValidationExceptionReason>,
        ) -> Self {
            self.reason = input;
            self
        }
        /// Appends an item to `field_list`.
        ///
        /// To override the contents of this collection use [`set_field_list`](Self::set_field_list).
        ///
        /// <p>Validate exception field list.</p>
        pub fn field_list(mut self, input: crate::model::ValidationExceptionField) -> Self {
            let mut v = self.field_list.unwrap_or_default();
            v.push(input);
            self.field_list = Some(v);
            self
        }
        /// <p>Validate exception field list.</p>
        pub fn set_field_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ValidationExceptionField>>,
        ) -> Self {
            self.field_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationException`](crate::error::ValidationException)
        pub fn build(self) -> crate::error::ValidationException {
            crate::error::ValidationException {
                message: self.message,
                code: self.code,
                reason: self.reason,
                field_list: self.field_list,
            }
        }
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::error::ValidationException)
    pub fn builder() -> crate::error::validation_exception::Builder {
        crate::error::validation_exception::Builder::default()
    }
}

/// <p>Unitialized account exception.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UninitializedAccountException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub code: std::option::Option<std::string::String>,
}
impl UninitializedAccountException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
}
impl std::fmt::Debug for UninitializedAccountException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UninitializedAccountException");
        formatter.field("message", &self.message);
        formatter.field("code", &self.code);
        formatter.finish()
    }
}
impl UninitializedAccountException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UninitializedAccountException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UninitializedAccountException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for UninitializedAccountException {}
/// See [`UninitializedAccountException`](crate::error::UninitializedAccountException)
pub mod uninitialized_account_exception {
    /// A builder for [`UninitializedAccountException`](crate::error::UninitializedAccountException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) code: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// Consumes the builder and constructs a [`UninitializedAccountException`](crate::error::UninitializedAccountException)
        pub fn build(self) -> crate::error::UninitializedAccountException {
            crate::error::UninitializedAccountException {
                message: self.message,
                code: self.code,
            }
        }
    }
}
impl UninitializedAccountException {
    /// Creates a new builder-style object to manufacture [`UninitializedAccountException`](crate::error::UninitializedAccountException)
    pub fn builder() -> crate::error::uninitialized_account_exception::Builder {
        crate::error::uninitialized_account_exception::Builder::default()
    }
}

/// <p>Resource not found exception.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub code: std::option::Option<std::string::String>,
    /// <p>Resource ID not found error.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>Resource type not found error.</p>
    pub resource_type: std::option::Option<std::string::String>,
}
impl ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
    /// <p>Resource ID not found error.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>Resource type not found error.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.field("code", &self.code);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>Resource ID not found error.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>Resource ID not found error.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>Resource type not found error.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>Resource type not found error.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
                code: self.code,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>The request could not be completed due to a conflict with the current state of the target resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub code: std::option::Option<std::string::String>,
    /// <p>A conflict occured when prompting for the Resource ID.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>A conflict occured when prompting for resource type.</p>
    pub resource_type: std::option::Option<std::string::String>,
}
impl ConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
    /// <p>A conflict occured when prompting for the Resource ID.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>A conflict occured when prompting for resource type.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.field("code", &self.code);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>A conflict occured when prompting for the Resource ID.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>A conflict occured when prompting for the Resource ID.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>A conflict occured when prompting for resource type.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>A conflict occured when prompting for resource type.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
                code: self.code,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

/// <p>Operating denied due to a file permission or access check error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub code: std::option::Option<std::string::String>,
}
impl AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.field("code", &self.code);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) code: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
                code: self.code,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}

/// <p>The request could not be completed because its exceeded the service quota.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceQuotaExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub code: std::option::Option<std::string::String>,
    /// <p>Exceeded the service quota resource Id.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>Exceeded the service quota resource type.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>Exceeded the service quota service code.</p>
    pub service_code: std::option::Option<std::string::String>,
    /// <p>Exceeded the service quota code.</p>
    pub quota_code: std::option::Option<std::string::String>,
}
impl ServiceQuotaExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
    /// <p>Exceeded the service quota resource Id.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>Exceeded the service quota resource type.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>Exceeded the service quota service code.</p>
    pub fn service_code(&self) -> std::option::Option<&str> {
        self.service_code.as_deref()
    }
    /// <p>Exceeded the service quota code.</p>
    pub fn quota_code(&self) -> std::option::Option<&str> {
        self.quota_code.as_deref()
    }
}
impl std::fmt::Debug for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceQuotaExceededException");
        formatter.field("message", &self.message);
        formatter.field("code", &self.code);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("service_code", &self.service_code);
        formatter.field("quota_code", &self.quota_code);
        formatter.finish()
    }
}
impl ServiceQuotaExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceQuotaExceededException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceQuotaExceededException {}
/// See [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
pub mod service_quota_exceeded_exception {
    /// A builder for [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) service_code: std::option::Option<std::string::String>,
        pub(crate) quota_code: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>Exceeded the service quota resource Id.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>Exceeded the service quota resource Id.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>Exceeded the service quota resource type.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>Exceeded the service quota resource type.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>Exceeded the service quota service code.</p>
        pub fn service_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_code = Some(input.into());
            self
        }
        /// <p>Exceeded the service quota service code.</p>
        pub fn set_service_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_code = input;
            self
        }
        /// <p>Exceeded the service quota code.</p>
        pub fn quota_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.quota_code = Some(input.into());
            self
        }
        /// <p>Exceeded the service quota code.</p>
        pub fn set_quota_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.quota_code = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
        pub fn build(self) -> crate::error::ServiceQuotaExceededException {
            crate::error::ServiceQuotaExceededException {
                message: self.message,
                code: self.code,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
                service_code: self.service_code,
                quota_code: self.quota_code,
            }
        }
    }
}
impl ServiceQuotaExceededException {
    /// Creates a new builder-style object to manufacture [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    pub fn builder() -> crate::error::service_quota_exceeded_exception::Builder {
        crate::error::service_quota_exceeded_exception::Builder::default()
    }
}

/// <p>Reached throttling quota exception.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThrottlingException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>Reached throttling quota exception service code.</p>
    pub service_code: std::option::Option<std::string::String>,
    /// <p>Reached throttling quota exception.</p>
    pub quota_code: std::option::Option<std::string::String>,
    /// <p>Reached throttling quota exception will retry after x seconds.</p>
    pub retry_after_seconds: std::option::Option<std::string::String>,
}
impl ThrottlingException {
    /// <p>Reached throttling quota exception service code.</p>
    pub fn service_code(&self) -> std::option::Option<&str> {
        self.service_code.as_deref()
    }
    /// <p>Reached throttling quota exception.</p>
    pub fn quota_code(&self) -> std::option::Option<&str> {
        self.quota_code.as_deref()
    }
    /// <p>Reached throttling quota exception will retry after x seconds.</p>
    pub fn retry_after_seconds(&self) -> std::option::Option<&str> {
        self.retry_after_seconds.as_deref()
    }
}
impl std::fmt::Debug for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThrottlingException");
        formatter.field("message", &self.message);
        formatter.field("service_code", &self.service_code);
        formatter.field("quota_code", &self.quota_code);
        formatter.field("retry_after_seconds", &self.retry_after_seconds);
        formatter.finish()
    }
}
impl ThrottlingException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ThrottlingException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for ThrottlingException {}
/// See [`ThrottlingException`](crate::error::ThrottlingException)
pub mod throttling_exception {
    /// A builder for [`ThrottlingException`](crate::error::ThrottlingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) service_code: std::option::Option<std::string::String>,
        pub(crate) quota_code: std::option::Option<std::string::String>,
        pub(crate) retry_after_seconds: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>Reached throttling quota exception service code.</p>
        pub fn service_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_code = Some(input.into());
            self
        }
        /// <p>Reached throttling quota exception service code.</p>
        pub fn set_service_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_code = input;
            self
        }
        /// <p>Reached throttling quota exception.</p>
        pub fn quota_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.quota_code = Some(input.into());
            self
        }
        /// <p>Reached throttling quota exception.</p>
        pub fn set_quota_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.quota_code = input;
            self
        }
        /// <p>Reached throttling quota exception will retry after x seconds.</p>
        pub fn retry_after_seconds(mut self, input: impl Into<std::string::String>) -> Self {
            self.retry_after_seconds = Some(input.into());
            self
        }
        /// <p>Reached throttling quota exception will retry after x seconds.</p>
        pub fn set_retry_after_seconds(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.retry_after_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`ThrottlingException`](crate::error::ThrottlingException)
        pub fn build(self) -> crate::error::ThrottlingException {
            crate::error::ThrottlingException {
                message: self.message,
                service_code: self.service_code,
                quota_code: self.quota_code,
                retry_after_seconds: self.retry_after_seconds,
            }
        }
    }
}
impl ThrottlingException {
    /// Creates a new builder-style object to manufacture [`ThrottlingException`](crate::error::ThrottlingException)
    pub fn builder() -> crate::error::throttling_exception::Builder {
        crate::error::throttling_exception::Builder::default()
    }
}

/// <p>The server encountered an unexpected condition that prevented it from fulfilling the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The server encountered an unexpected condition that prevented it from fulfilling the request. The request will be retried again after x seconds.</p>
    pub retry_after_seconds: i64,
}
impl InternalServerException {
    /// <p>The server encountered an unexpected condition that prevented it from fulfilling the request. The request will be retried again after x seconds.</p>
    pub fn retry_after_seconds(&self) -> i64 {
        self.retry_after_seconds
    }
}
impl std::fmt::Debug for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerException");
        formatter.field("message", &self.message);
        formatter.field("retry_after_seconds", &self.retry_after_seconds);
        formatter.finish()
    }
}
impl InternalServerException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerException {}
/// See [`InternalServerException`](crate::error::InternalServerException)
pub mod internal_server_exception {
    /// A builder for [`InternalServerException`](crate::error::InternalServerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) retry_after_seconds: std::option::Option<i64>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The server encountered an unexpected condition that prevented it from fulfilling the request. The request will be retried again after x seconds.</p>
        pub fn retry_after_seconds(mut self, input: i64) -> Self {
            self.retry_after_seconds = Some(input);
            self
        }
        /// <p>The server encountered an unexpected condition that prevented it from fulfilling the request. The request will be retried again after x seconds.</p>
        pub fn set_retry_after_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.retry_after_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerException`](crate::error::InternalServerException)
        pub fn build(self) -> crate::error::InternalServerException {
            crate::error::InternalServerException {
                message: self.message,
                retry_after_seconds: self.retry_after_seconds.unwrap_or_default(),
            }
        }
    }
}
impl InternalServerException {
    /// Creates a new builder-style object to manufacture [`InternalServerException`](crate::error::InternalServerException)
    pub fn builder() -> crate::error::internal_server_exception::Builder {
        crate::error::internal_server_exception::Builder::default()
    }
}
