// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// Client for Application Migration Service
///
/// Client for invoking operations on Application Migration Service. Each operation on Application Migration Service is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_mgn::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operationname>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_mgn::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_mgn::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `ChangeServerLifeCycleState` operation.
    ///
    /// See [`ChangeServerLifeCycleState`](crate::client::fluent_builders::ChangeServerLifeCycleState) for more information about the
    /// operation and its arguments.
    pub fn change_server_life_cycle_state(
        &self,
    ) -> fluent_builders::ChangeServerLifeCycleState<C, M, R> {
        fluent_builders::ChangeServerLifeCycleState::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateReplicationConfigurationTemplate` operation.
    ///
    /// See [`CreateReplicationConfigurationTemplate`](crate::client::fluent_builders::CreateReplicationConfigurationTemplate) for more information about the
    /// operation and its arguments.
    pub fn create_replication_configuration_template(
        &self,
    ) -> fluent_builders::CreateReplicationConfigurationTemplate<C, M, R> {
        fluent_builders::CreateReplicationConfigurationTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteJob` operation.
    ///
    /// See [`DeleteJob`](crate::client::fluent_builders::DeleteJob) for more information about the
    /// operation and its arguments.
    pub fn delete_job(&self) -> fluent_builders::DeleteJob<C, M, R> {
        fluent_builders::DeleteJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteReplicationConfigurationTemplate` operation.
    ///
    /// See [`DeleteReplicationConfigurationTemplate`](crate::client::fluent_builders::DeleteReplicationConfigurationTemplate) for more information about the
    /// operation and its arguments.
    pub fn delete_replication_configuration_template(
        &self,
    ) -> fluent_builders::DeleteReplicationConfigurationTemplate<C, M, R> {
        fluent_builders::DeleteReplicationConfigurationTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteSourceServer` operation.
    ///
    /// See [`DeleteSourceServer`](crate::client::fluent_builders::DeleteSourceServer) for more information about the
    /// operation and its arguments.
    pub fn delete_source_server(&self) -> fluent_builders::DeleteSourceServer<C, M, R> {
        fluent_builders::DeleteSourceServer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeJobLogItems` operation.
    ///
    /// See [`DescribeJobLogItems`](crate::client::fluent_builders::DescribeJobLogItems) for more information about the
    /// operation and its arguments.
    pub fn describe_job_log_items(&self) -> fluent_builders::DescribeJobLogItems<C, M, R> {
        fluent_builders::DescribeJobLogItems::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeJobs` operation.
    ///
    /// See [`DescribeJobs`](crate::client::fluent_builders::DescribeJobs) for more information about the
    /// operation and its arguments.
    pub fn describe_jobs(&self) -> fluent_builders::DescribeJobs<C, M, R> {
        fluent_builders::DescribeJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeReplicationConfigurationTemplates` operation.
    ///
    /// See [`DescribeReplicationConfigurationTemplates`](crate::client::fluent_builders::DescribeReplicationConfigurationTemplates) for more information about the
    /// operation and its arguments.
    pub fn describe_replication_configuration_templates(
        &self,
    ) -> fluent_builders::DescribeReplicationConfigurationTemplates<C, M, R> {
        fluent_builders::DescribeReplicationConfigurationTemplates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeSourceServers` operation.
    ///
    /// See [`DescribeSourceServers`](crate::client::fluent_builders::DescribeSourceServers) for more information about the
    /// operation and its arguments.
    pub fn describe_source_servers(&self) -> fluent_builders::DescribeSourceServers<C, M, R> {
        fluent_builders::DescribeSourceServers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisconnectFromService` operation.
    ///
    /// See [`DisconnectFromService`](crate::client::fluent_builders::DisconnectFromService) for more information about the
    /// operation and its arguments.
    pub fn disconnect_from_service(&self) -> fluent_builders::DisconnectFromService<C, M, R> {
        fluent_builders::DisconnectFromService::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `FinalizeCutover` operation.
    ///
    /// See [`FinalizeCutover`](crate::client::fluent_builders::FinalizeCutover) for more information about the
    /// operation and its arguments.
    pub fn finalize_cutover(&self) -> fluent_builders::FinalizeCutover<C, M, R> {
        fluent_builders::FinalizeCutover::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetLaunchConfiguration` operation.
    ///
    /// See [`GetLaunchConfiguration`](crate::client::fluent_builders::GetLaunchConfiguration) for more information about the
    /// operation and its arguments.
    pub fn get_launch_configuration(&self) -> fluent_builders::GetLaunchConfiguration<C, M, R> {
        fluent_builders::GetLaunchConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetReplicationConfiguration` operation.
    ///
    /// See [`GetReplicationConfiguration`](crate::client::fluent_builders::GetReplicationConfiguration) for more information about the
    /// operation and its arguments.
    pub fn get_replication_configuration(
        &self,
    ) -> fluent_builders::GetReplicationConfiguration<C, M, R> {
        fluent_builders::GetReplicationConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `InitializeService` operation.
    ///
    /// See [`InitializeService`](crate::client::fluent_builders::InitializeService) for more information about the
    /// operation and its arguments.
    pub fn initialize_service(&self) -> fluent_builders::InitializeService<C, M, R> {
        fluent_builders::InitializeService::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `MarkAsArchived` operation.
    ///
    /// See [`MarkAsArchived`](crate::client::fluent_builders::MarkAsArchived) for more information about the
    /// operation and its arguments.
    pub fn mark_as_archived(&self) -> fluent_builders::MarkAsArchived<C, M, R> {
        fluent_builders::MarkAsArchived::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RetryDataReplication` operation.
    ///
    /// See [`RetryDataReplication`](crate::client::fluent_builders::RetryDataReplication) for more information about the
    /// operation and its arguments.
    pub fn retry_data_replication(&self) -> fluent_builders::RetryDataReplication<C, M, R> {
        fluent_builders::RetryDataReplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartCutover` operation.
    ///
    /// See [`StartCutover`](crate::client::fluent_builders::StartCutover) for more information about the
    /// operation and its arguments.
    pub fn start_cutover(&self) -> fluent_builders::StartCutover<C, M, R> {
        fluent_builders::StartCutover::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartTest` operation.
    ///
    /// See [`StartTest`](crate::client::fluent_builders::StartTest) for more information about the
    /// operation and its arguments.
    pub fn start_test(&self) -> fluent_builders::StartTest<C, M, R> {
        fluent_builders::StartTest::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TerminateTargetInstances` operation.
    ///
    /// See [`TerminateTargetInstances`](crate::client::fluent_builders::TerminateTargetInstances) for more information about the
    /// operation and its arguments.
    pub fn terminate_target_instances(&self) -> fluent_builders::TerminateTargetInstances<C, M, R> {
        fluent_builders::TerminateTargetInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateLaunchConfiguration` operation.
    ///
    /// See [`UpdateLaunchConfiguration`](crate::client::fluent_builders::UpdateLaunchConfiguration) for more information about the
    /// operation and its arguments.
    pub fn update_launch_configuration(
        &self,
    ) -> fluent_builders::UpdateLaunchConfiguration<C, M, R> {
        fluent_builders::UpdateLaunchConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateReplicationConfiguration` operation.
    ///
    /// See [`UpdateReplicationConfiguration`](crate::client::fluent_builders::UpdateReplicationConfiguration) for more information about the
    /// operation and its arguments.
    pub fn update_replication_configuration(
        &self,
    ) -> fluent_builders::UpdateReplicationConfiguration<C, M, R> {
        fluent_builders::UpdateReplicationConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateReplicationConfigurationTemplate` operation.
    ///
    /// See [`UpdateReplicationConfigurationTemplate`](crate::client::fluent_builders::UpdateReplicationConfigurationTemplate) for more information about the
    /// operation and its arguments.
    pub fn update_replication_configuration_template(
        &self,
    ) -> fluent_builders::UpdateReplicationConfigurationTemplate<C, M, R> {
        fluent_builders::UpdateReplicationConfigurationTemplate::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `ChangeServerLifeCycleState`.
    ///
    /// <p>Allows the user to set the SourceServer.LifeCycle.state property for specific Source Server IDs to one of the following: READY_FOR_TEST or READY_FOR_CUTOVER. This command only works if the Source Server is already launchable (dataReplicationInfo.lagDuration is not null.)</p>
    #[derive(std::fmt::Debug)]
    pub struct ChangeServerLifeCycleState<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::change_server_life_cycle_state_input::Builder,
    }
    impl<C, M, R> ChangeServerLifeCycleState<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ChangeServerLifeCycleState`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ChangeServerLifeCycleStateOutput,
            aws_smithy_http::result::SdkError<crate::error::ChangeServerLifeCycleStateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ChangeServerLifeCycleStateInputOperationOutputAlias,
                crate::output::ChangeServerLifeCycleStateOutput,
                crate::error::ChangeServerLifeCycleStateError,
                crate::input::ChangeServerLifeCycleStateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The request to change the source server migration lifecycle state by source server ID.</p>
        pub fn source_server_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_server_id(inp);
            self
        }
        /// <p>The request to change the source server migration lifecycle state by source server ID.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_server_id(input);
            self
        }
        /// <p>The request to change the source server migration lifecycle state.</p>
        pub fn life_cycle(
            mut self,
            inp: crate::model::ChangeServerLifeCycleStateSourceServerLifecycle,
        ) -> Self {
            self.inner = self.inner.life_cycle(inp);
            self
        }
        /// <p>The request to change the source server migration lifecycle state.</p>
        pub fn set_life_cycle(
            mut self,
            input: std::option::Option<
                crate::model::ChangeServerLifeCycleStateSourceServerLifecycle,
            >,
        ) -> Self {
            self.inner = self.inner.set_life_cycle(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateReplicationConfigurationTemplate`.
    ///
    /// <p>Creates a new ReplicationConfigurationTemplate.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateReplicationConfigurationTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_replication_configuration_template_input::Builder,
    }
    impl<C, M, R> CreateReplicationConfigurationTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateReplicationConfigurationTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateReplicationConfigurationTemplateOutput,
            aws_smithy_http::result::SdkError<
                crate::error::CreateReplicationConfigurationTemplateError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateReplicationConfigurationTemplateInputOperationOutputAlias,
                crate::output::CreateReplicationConfigurationTemplateOutput,
                crate::error::CreateReplicationConfigurationTemplateError,
                crate::input::CreateReplicationConfigurationTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Request to configure the Staging Area subnet ID during Replication Settings template creation.</p>
        pub fn staging_area_subnet_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.staging_area_subnet_id(inp);
            self
        }
        /// <p>Request to configure the Staging Area subnet ID during Replication Settings template creation.</p>
        pub fn set_staging_area_subnet_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_staging_area_subnet_id(input);
            self
        }
        /// <p>Request to associate the default Application Migration Service Security group with the Replication Settings template.</p>
        pub fn associate_default_security_group(mut self, inp: bool) -> Self {
            self.inner = self.inner.associate_default_security_group(inp);
            self
        }
        /// <p>Request to associate the default Application Migration Service Security group with the Replication Settings template.</p>
        pub fn set_associate_default_security_group(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_associate_default_security_group(input);
            self
        }
        /// Appends an item to `replicationServersSecurityGroupsIDs`.
        ///
        /// To override the contents of this collection use [`set_replication_servers_security_groups_i_ds`](Self::set_replication_servers_security_groups_i_ds).
        ///
        /// <p>Request to configure the Replication Server Secuirity group ID during Replication Settings template creation.</p>
        pub fn replication_servers_security_groups_i_ds(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.replication_servers_security_groups_i_ds(inp);
            self
        }
        /// <p>Request to configure the Replication Server Secuirity group ID during Replication Settings template creation.</p>
        pub fn set_replication_servers_security_groups_i_ds(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self
                .inner
                .set_replication_servers_security_groups_i_ds(input);
            self
        }
        /// <p>Request to configure the Replication Server instance type during Replication Settings template creation.</p>
        pub fn replication_server_instance_type(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.replication_server_instance_type(inp);
            self
        }
        /// <p>Request to configure the Replication Server instance type during Replication Settings template creation.</p>
        pub fn set_replication_server_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_server_instance_type(input);
            self
        }
        /// <p>Request to use Dedicated Replication Servers during Replication Settings template creation.</p>
        pub fn use_dedicated_replication_server(mut self, inp: bool) -> Self {
            self.inner = self.inner.use_dedicated_replication_server(inp);
            self
        }
        /// <p>Request to use Dedicated Replication Servers during Replication Settings template creation.</p>
        pub fn set_use_dedicated_replication_server(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_use_dedicated_replication_server(input);
            self
        }
        /// <p>Request to configure the Staging Disk EBS volume type to "gp2" during Replication Settings template creation.</p>
        pub fn default_large_staging_disk_type(
            mut self,
            inp: crate::model::ReplicationConfigurationDefaultLargeStagingDiskType,
        ) -> Self {
            self.inner = self.inner.default_large_staging_disk_type(inp);
            self
        }
        /// <p>Request to configure the Staging Disk EBS volume type to "gp2" during Replication Settings template creation.</p>
        pub fn set_default_large_staging_disk_type(
            mut self,
            input: std::option::Option<
                crate::model::ReplicationConfigurationDefaultLargeStagingDiskType,
            >,
        ) -> Self {
            self.inner = self.inner.set_default_large_staging_disk_type(input);
            self
        }
        /// <p>Request to configure EBS enryption during Replication Settings template creation.</p>
        pub fn ebs_encryption(
            mut self,
            inp: crate::model::ReplicationConfigurationEbsEncryption,
        ) -> Self {
            self.inner = self.inner.ebs_encryption(inp);
            self
        }
        /// <p>Request to configure EBS enryption during Replication Settings template creation.</p>
        pub fn set_ebs_encryption(
            mut self,
            input: std::option::Option<crate::model::ReplicationConfigurationEbsEncryption>,
        ) -> Self {
            self.inner = self.inner.set_ebs_encryption(input);
            self
        }
        /// <p>Request to configure an EBS enryption key during Replication Settings template creation.</p>
        pub fn ebs_encryption_key_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ebs_encryption_key_arn(inp);
            self
        }
        /// <p>Request to configure an EBS enryption key during Replication Settings template creation.</p>
        pub fn set_ebs_encryption_key_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ebs_encryption_key_arn(input);
            self
        }
        /// <p>Request to configure bandwidth throttling during Replication Settings template creation.</p>
        pub fn bandwidth_throttling(mut self, inp: i64) -> Self {
            self.inner = self.inner.bandwidth_throttling(inp);
            self
        }
        /// <p>Request to configure bandwidth throttling during Replication Settings template creation.</p>
        pub fn set_bandwidth_throttling(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_bandwidth_throttling(input);
            self
        }
        /// <p>Request to configure  data plane routing during Replication Settings template creation.</p>
        pub fn data_plane_routing(
            mut self,
            inp: crate::model::ReplicationConfigurationDataPlaneRouting,
        ) -> Self {
            self.inner = self.inner.data_plane_routing(inp);
            self
        }
        /// <p>Request to configure  data plane routing during Replication Settings template creation.</p>
        pub fn set_data_plane_routing(
            mut self,
            input: std::option::Option<crate::model::ReplicationConfigurationDataPlaneRouting>,
        ) -> Self {
            self.inner = self.inner.set_data_plane_routing(input);
            self
        }
        /// <p>Request to create Public IP during Replication Settings template creation.</p>
        pub fn create_public_ip(mut self, inp: bool) -> Self {
            self.inner = self.inner.create_public_ip(inp);
            self
        }
        /// <p>Request to create Public IP during Replication Settings template creation.</p>
        pub fn set_create_public_ip(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_create_public_ip(input);
            self
        }
        /// Adds a key-value pair to `stagingAreaTags`.
        ///
        /// To override the contents of this collection use [`set_staging_area_tags`](Self::set_staging_area_tags).
        ///
        /// <p>Request to configure Staiging Area tags during Replication Settings template creation.</p>
        pub fn staging_area_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.staging_area_tags(k, v);
            self
        }
        /// <p>Request to configure Staiging Area tags during Replication Settings template creation.</p>
        pub fn set_staging_area_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_staging_area_tags(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Request to configure tags during Replication Settings template creation.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>Request to configure tags during Replication Settings template creation.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteJob`.
    ///
    /// <p>Deletes a single Job by ID.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_job_input::Builder,
    }
    impl<C, M, R> DeleteJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteJobInputOperationOutputAlias,
                crate::output::DeleteJobOutput,
                crate::error::DeleteJobError,
                crate::input::DeleteJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Request to delete Job from service by Job ID.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>Request to delete Job from service by Job ID.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteReplicationConfigurationTemplate`.
    ///
    /// <p>Deletes a single Replication Configuration Template by ID</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteReplicationConfigurationTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_replication_configuration_template_input::Builder,
    }
    impl<C, M, R> DeleteReplicationConfigurationTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteReplicationConfigurationTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteReplicationConfigurationTemplateOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeleteReplicationConfigurationTemplateError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteReplicationConfigurationTemplateInputOperationOutputAlias,
                crate::output::DeleteReplicationConfigurationTemplateOutput,
                crate::error::DeleteReplicationConfigurationTemplateError,
                crate::input::DeleteReplicationConfigurationTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Request to delete Replication Configuration Template from service by Replication Configuration Template ID.</p>
        pub fn replication_configuration_template_id(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.replication_configuration_template_id(inp);
            self
        }
        /// <p>Request to delete Replication Configuration Template from service by Replication Configuration Template ID.</p>
        pub fn set_replication_configuration_template_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_configuration_template_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSourceServer`.
    ///
    /// <p>Deletes a single source server by ID.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteSourceServer<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_source_server_input::Builder,
    }
    impl<C, M, R> DeleteSourceServer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteSourceServer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSourceServerOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSourceServerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteSourceServerInputOperationOutputAlias,
                crate::output::DeleteSourceServerOutput,
                crate::error::DeleteSourceServerError,
                crate::input::DeleteSourceServerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Request to delete Source Server from service by Server ID.</p>
        pub fn source_server_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_server_id(inp);
            self
        }
        /// <p>Request to delete Source Server from service by Server ID.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_server_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeJobLogItems`.
    ///
    /// <p>Retrieves detailed Job log with paging.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeJobLogItems<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_job_log_items_input::Builder,
    }
    impl<C, M, R> DescribeJobLogItems<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeJobLogItems`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeJobLogItemsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeJobLogItemsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeJobLogItemsInputOperationOutputAlias,
                crate::output::DescribeJobLogItemsOutput,
                crate::error::DescribeJobLogItemsError,
                crate::input::DescribeJobLogItemsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Request to describe Job log job ID.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>Request to describe Job log job ID.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>Request to describe Job log item maximum results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Request to describe Job log item maximum results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Request to describe Job log next token.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Request to describe Job log next token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeJobs`.
    ///
    /// <p>Returns a list of Jobs. Use the JobsID and fromDate and toData filters to limit which jobs are returned. The response is sorted by creationDataTime - latest date first. Jobs are normaly created by the StartTest, StartCutover, and TerminateTargetInstances APIs. Jobs are also created by DiagnosticLaunch and TerminateDiagnosticInstances, which are APIs available only to *Support* and only used in response to relevant support tickets.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_jobs_input::Builder,
    }
    impl<C, M, R> DescribeJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeJobsInputOperationOutputAlias,
                crate::output::DescribeJobsOutput,
                crate::error::DescribeJobsError,
                crate::input::DescribeJobsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Request to describe Job log filters.</p>
        pub fn filters(mut self, inp: crate::model::DescribeJobsRequestFilters) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Request to describe Job log filters.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::DescribeJobsRequestFilters>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>Request to describe Job log by max results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Request to describe Job log by max results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Request to describe Job logby next token.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Request to describe Job logby next token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeReplicationConfigurationTemplates`.
    ///
    /// <p>Lists all ReplicationConfigurationTemplates, filtered by Source Server IDs.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeReplicationConfigurationTemplates<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_replication_configuration_templates_input::Builder,
    }
    impl<C, M, R> DescribeReplicationConfigurationTemplates<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeReplicationConfigurationTemplates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeReplicationConfigurationTemplatesOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeReplicationConfigurationTemplatesError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeReplicationConfigurationTemplatesInputOperationOutputAlias,
                crate::output::DescribeReplicationConfigurationTemplatesOutput,
                crate::error::DescribeReplicationConfigurationTemplatesError,
                crate::input::DescribeReplicationConfigurationTemplatesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `replicationConfigurationTemplateIDs`.
        ///
        /// To override the contents of this collection use [`set_replication_configuration_template_i_ds`](Self::set_replication_configuration_template_i_ds).
        ///
        /// <p>Request to describe Replication Configuration template by template IDs.</p>
        pub fn replication_configuration_template_i_ds(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.replication_configuration_template_i_ds(inp);
            self
        }
        /// <p>Request to describe Replication Configuration template by template IDs.</p>
        pub fn set_replication_configuration_template_i_ds(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self
                .inner
                .set_replication_configuration_template_i_ds(input);
            self
        }
        /// <p>Request to describe Replication Configuration template by max results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Request to describe Replication Configuration template by max results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Request to describe Replication Configuration template by next token.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Request to describe Replication Configuration template by next token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSourceServers`.
    ///
    /// <p>Retrieves all SourceServers or multiple SourceServers by ID.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeSourceServers<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_source_servers_input::Builder,
    }
    impl<C, M, R> DescribeSourceServers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeSourceServers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSourceServersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSourceServersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeSourceServersInputOperationOutputAlias,
                crate::output::DescribeSourceServersOutput,
                crate::error::DescribeSourceServersError,
                crate::input::DescribeSourceServersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Request to filter Source Servers list.</p>
        pub fn filters(mut self, inp: crate::model::DescribeSourceServersRequestFilters) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Request to filter Source Servers list.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::DescribeSourceServersRequestFilters>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>Request to filter Source Servers list by maximum results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Request to filter Source Servers list by maximum results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Request to filter Source Servers list by next token.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Request to filter Source Servers list by next token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisconnectFromService`.
    ///
    /// <p>Disconnects specific Source Servers from Application Migration Service. Data replication is stopped immediately. All AWS resources created by Application Migration Service for enabling the replication of these source servers will be terminated / deleted within 90 minutes. Launched Test or Cutover instances will NOT be terminated. If the agent on the source server has not been prevented from communciating with the Application Migration Service service, then it will receive a command to uninstall itself (within approximately 10 minutes). The following properties of the SourceServer will be changed immediately: dataReplicationInfo.dataReplicationState will be set to DISCONNECTED; The totalStorageBytes property for each of dataReplicationInfo.replicatedDisks will be set to zero; dataReplicationInfo.lagDuration and dataReplicationInfo.lagDurationwill be nullified.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisconnectFromService<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disconnect_from_service_input::Builder,
    }
    impl<C, M, R> DisconnectFromService<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisconnectFromService`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisconnectFromServiceOutput,
            aws_smithy_http::result::SdkError<crate::error::DisconnectFromServiceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisconnectFromServiceInputOperationOutputAlias,
                crate::output::DisconnectFromServiceOutput,
                crate::error::DisconnectFromServiceError,
                crate::input::DisconnectFromServiceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Request to disconnect Source Server from service by Server ID.</p>
        pub fn source_server_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_server_id(inp);
            self
        }
        /// <p>Request to disconnect Source Server from service by Server ID.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_server_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `FinalizeCutover`.
    ///
    /// <p>Finalizes the cutover immediately for specific Source Servers. All AWS resources created by Application Migration Service for enabling the replication of these source servers will be terminated / deleted within 90 minutes. Launched Test or Cutover instances will NOT be terminated. The AWS Replication Agent will receive a command to uninstall itself (within 10 minutes). The following properties of the SourceServer will be changed immediately: dataReplicationInfo.dataReplicationState will be to DISCONNECTED; The SourceServer.lifeCycle.state will be changed to CUTOVER; The totalStorageBytes property fo each of dataReplicationInfo.replicatedDisks will be set to zero; dataReplicationInfo.lagDuration and dataReplicationInfo.lagDurationwill be nullified.</p>
    #[derive(std::fmt::Debug)]
    pub struct FinalizeCutover<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::finalize_cutover_input::Builder,
    }
    impl<C, M, R> FinalizeCutover<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `FinalizeCutover`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::FinalizeCutoverOutput,
            aws_smithy_http::result::SdkError<crate::error::FinalizeCutoverError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::FinalizeCutoverInputOperationOutputAlias,
                crate::output::FinalizeCutoverOutput,
                crate::error::FinalizeCutoverError,
                crate::input::FinalizeCutoverInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Request to finalize Cutover by Soure Server ID.</p>
        pub fn source_server_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_server_id(inp);
            self
        }
        /// <p>Request to finalize Cutover by Soure Server ID.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_server_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLaunchConfiguration`.
    ///
    /// <p>Lists all LaunchConfigurations available, filtered by Source Server IDs.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetLaunchConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_launch_configuration_input::Builder,
    }
    impl<C, M, R> GetLaunchConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetLaunchConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLaunchConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLaunchConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetLaunchConfigurationInputOperationOutputAlias,
                crate::output::GetLaunchConfigurationOutput,
                crate::error::GetLaunchConfigurationError,
                crate::input::GetLaunchConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Request to get Launch Configuration information by Source Server ID.</p>
        pub fn source_server_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_server_id(inp);
            self
        }
        /// <p>Request to get Launch Configuration information by Source Server ID.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_server_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetReplicationConfiguration`.
    ///
    /// <p>Lists all ReplicationConfigurations, filtered by Source Server ID.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetReplicationConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_replication_configuration_input::Builder,
    }
    impl<C, M, R> GetReplicationConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetReplicationConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetReplicationConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetReplicationConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetReplicationConfigurationInputOperationOutputAlias,
                crate::output::GetReplicationConfigurationOutput,
                crate::error::GetReplicationConfigurationError,
                crate::input::GetReplicationConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Request to get Replication Configuaration by Source Server ID.</p>
        pub fn source_server_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_server_id(inp);
            self
        }
        /// <p>Request to get Replication Configuaration by Source Server ID.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_server_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `InitializeService`.
    ///
    /// <p>Initialize Application Migration Service.</p>
    #[derive(std::fmt::Debug)]
    pub struct InitializeService<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::initialize_service_input::Builder,
    }
    impl<C, M, R> InitializeService<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `InitializeService`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::InitializeServiceOutput,
            aws_smithy_http::result::SdkError<crate::error::InitializeServiceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::InitializeServiceInputOperationOutputAlias,
                crate::output::InitializeServiceOutput,
                crate::error::InitializeServiceError,
                crate::input::InitializeServiceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>List all tags for your Application Migration Service resources.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>List tags for resource request by ARN.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>List tags for resource request by ARN.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `MarkAsArchived`.
    ///
    /// <p>Archives specific Source Servers by setting the SourceServer.isArchived property to true for specified SourceServers by ID. This command only works for SourceServers with a lifecycle.state which equals DISCONNECTED or CUTOVER.</p>
    #[derive(std::fmt::Debug)]
    pub struct MarkAsArchived<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::mark_as_archived_input::Builder,
    }
    impl<C, M, R> MarkAsArchived<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `MarkAsArchived`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::MarkAsArchivedOutput,
            aws_smithy_http::result::SdkError<crate::error::MarkAsArchivedError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::MarkAsArchivedInputOperationOutputAlias,
                crate::output::MarkAsArchivedOutput,
                crate::error::MarkAsArchivedError,
                crate::input::MarkAsArchivedInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Mark as archived by Source Server ID.</p>
        pub fn source_server_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_server_id(inp);
            self
        }
        /// <p>Mark as archived by Source Server ID.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_server_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RetryDataReplication`.
    ///
    /// <p>Causes the data replication initiation sequence to begin immediately upon next Handshake for specified SourceServer IDs, regardless of when the previous initiation started. This command will not work if the SourceServer is not stalled or is in a DISCONNECTED or STOPPED state.</p>
    #[derive(std::fmt::Debug)]
    pub struct RetryDataReplication<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::retry_data_replication_input::Builder,
    }
    impl<C, M, R> RetryDataReplication<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RetryDataReplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RetryDataReplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::RetryDataReplicationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RetryDataReplicationInputOperationOutputAlias,
                crate::output::RetryDataReplicationOutput,
                crate::error::RetryDataReplicationError,
                crate::input::RetryDataReplicationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Retry data replication for Source Server ID.</p>
        pub fn source_server_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_server_id(inp);
            self
        }
        /// <p>Retry data replication for Source Server ID.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_server_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartCutover`.
    ///
    /// <p>Launches a Cutover Instance for specific Source Servers. This command starts a LAUNCH job whose initiatedBy property is StartCutover and changes the SourceServer.lifeCycle.state property to CUTTING_OVER.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartCutover<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_cutover_input::Builder,
    }
    impl<C, M, R> StartCutover<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartCutover`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartCutoverOutput,
            aws_smithy_http::result::SdkError<crate::error::StartCutoverError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartCutoverInputOperationOutputAlias,
                crate::output::StartCutoverOutput,
                crate::error::StartCutoverError,
                crate::input::StartCutoverInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `sourceServerIDs`.
        ///
        /// To override the contents of this collection use [`set_source_server_i_ds`](Self::set_source_server_i_ds).
        ///
        /// <p>Start Cutover by Source Server IDs.</p>
        pub fn source_server_i_ds(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_server_i_ds(inp);
            self
        }
        /// <p>Start Cutover by Source Server IDs.</p>
        pub fn set_source_server_i_ds(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_source_server_i_ds(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Start Cutover by Tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>Start Cutover by Tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartTest`.
    ///
    /// <p>Lauches a Test Instance for specific Source Servers. This command starts a LAUNCH job whose initiatedBy property is StartTest and changes the SourceServer.lifeCycle.state property to TESTING.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartTest<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_test_input::Builder,
    }
    impl<C, M, R> StartTest<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartTest`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartTestOutput,
            aws_smithy_http::result::SdkError<crate::error::StartTestError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartTestInputOperationOutputAlias,
                crate::output::StartTestOutput,
                crate::error::StartTestError,
                crate::input::StartTestInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `sourceServerIDs`.
        ///
        /// To override the contents of this collection use [`set_source_server_i_ds`](Self::set_source_server_i_ds).
        ///
        /// <p>Start Test for Source Server IDs.</p>
        pub fn source_server_i_ds(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_server_i_ds(inp);
            self
        }
        /// <p>Start Test for Source Server IDs.</p>
        pub fn set_source_server_i_ds(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_source_server_i_ds(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Start Test by Tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>Start Test by Tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds or overwrites only the specified tags for the specified Application Migration Service resource or resources. When you specify an existing tag key, the value is overwritten with the new value. Each resource can have a maximum of 50 tags. Each tag consists of a key and optional value.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Tag resource by ARN.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>Tag resource by ARN.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tag resource by Tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>Tag resource by Tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TerminateTargetInstances`.
    ///
    /// <p>Starts a job that terminates specific launched EC2 Test and Cutover instances. This command will not work for any Source Server with a lifecycle.state of TESTING, CUTTING_OVER, or CUTOVER.</p>
    #[derive(std::fmt::Debug)]
    pub struct TerminateTargetInstances<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::terminate_target_instances_input::Builder,
    }
    impl<C, M, R> TerminateTargetInstances<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TerminateTargetInstances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TerminateTargetInstancesOutput,
            aws_smithy_http::result::SdkError<crate::error::TerminateTargetInstancesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TerminateTargetInstancesInputOperationOutputAlias,
                crate::output::TerminateTargetInstancesOutput,
                crate::error::TerminateTargetInstancesError,
                crate::input::TerminateTargetInstancesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `sourceServerIDs`.
        ///
        /// To override the contents of this collection use [`set_source_server_i_ds`](Self::set_source_server_i_ds).
        ///
        /// <p>Terminate Target instance by Source Server IDs.</p>
        pub fn source_server_i_ds(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_server_i_ds(inp);
            self
        }
        /// <p>Terminate Target instance by Source Server IDs.</p>
        pub fn set_source_server_i_ds(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_source_server_i_ds(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Terminate Target instance by Tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>Terminate Target instance by Tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Deletes the specified set of tags from the specified set of Application Migration Service resources.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Untag resource by ARN.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>Untag resource by ARN.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>Untag resource by Keys.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>Untag resource by Keys.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateLaunchConfiguration`.
    ///
    /// <p>Updates multiple LaunchConfigurations by Source Server ID.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateLaunchConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_launch_configuration_input::Builder,
    }
    impl<C, M, R> UpdateLaunchConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateLaunchConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateLaunchConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateLaunchConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateLaunchConfigurationInputOperationOutputAlias,
                crate::output::UpdateLaunchConfigurationOutput,
                crate::error::UpdateLaunchConfigurationError,
                crate::input::UpdateLaunchConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Update Launch configuration by Source Server ID request.</p>
        pub fn source_server_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_server_id(inp);
            self
        }
        /// <p>Update Launch configuration by Source Server ID request.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_server_id(input);
            self
        }
        /// <p>Update Launch configuration name request.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>Update Launch configuration name request.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Update Launch configuration launch disposition request.</p>
        pub fn launch_disposition(mut self, inp: crate::model::LaunchDisposition) -> Self {
            self.inner = self.inner.launch_disposition(inp);
            self
        }
        /// <p>Update Launch configuration launch disposition request.</p>
        pub fn set_launch_disposition(
            mut self,
            input: std::option::Option<crate::model::LaunchDisposition>,
        ) -> Self {
            self.inner = self.inner.set_launch_disposition(input);
            self
        }
        /// <p>Update Launch configuration Target instance right sizing request.</p>
        pub fn target_instance_type_right_sizing_method(
            mut self,
            inp: crate::model::TargetInstanceTypeRightSizingMethod,
        ) -> Self {
            self.inner = self.inner.target_instance_type_right_sizing_method(inp);
            self
        }
        /// <p>Update Launch configuration Target instance right sizing request.</p>
        pub fn set_target_instance_type_right_sizing_method(
            mut self,
            input: std::option::Option<crate::model::TargetInstanceTypeRightSizingMethod>,
        ) -> Self {
            self.inner = self
                .inner
                .set_target_instance_type_right_sizing_method(input);
            self
        }
        /// <p>Update Launch configuration copy Private IP request.</p>
        pub fn copy_private_ip(mut self, inp: bool) -> Self {
            self.inner = self.inner.copy_private_ip(inp);
            self
        }
        /// <p>Update Launch configuration copy Private IP request.</p>
        pub fn set_copy_private_ip(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_copy_private_ip(input);
            self
        }
        /// <p>Update Launch configuration copy Tags request.</p>
        pub fn copy_tags(mut self, inp: bool) -> Self {
            self.inner = self.inner.copy_tags(inp);
            self
        }
        /// <p>Update Launch configuration copy Tags request.</p>
        pub fn set_copy_tags(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_copy_tags(input);
            self
        }
        /// <p>Update Launch configuration licensing request.</p>
        pub fn licensing(mut self, inp: crate::model::Licensing) -> Self {
            self.inner = self.inner.licensing(inp);
            self
        }
        /// <p>Update Launch configuration licensing request.</p>
        pub fn set_licensing(
            mut self,
            input: std::option::Option<crate::model::Licensing>,
        ) -> Self {
            self.inner = self.inner.set_licensing(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateReplicationConfiguration`.
    ///
    /// <p>Allows you to update multiple ReplicationConfigurations by Source Server ID.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateReplicationConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_replication_configuration_input::Builder,
    }
    impl<C, M, R> UpdateReplicationConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateReplicationConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateReplicationConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateReplicationConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateReplicationConfigurationInputOperationOutputAlias,
                crate::output::UpdateReplicationConfigurationOutput,
                crate::error::UpdateReplicationConfigurationError,
                crate::input::UpdateReplicationConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Update replication configuration Source Server ID request.</p>
        pub fn source_server_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_server_id(inp);
            self
        }
        /// <p>Update replication configuration Source Server ID request.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_server_id(input);
            self
        }
        /// <p>Update replication configuration name request.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>Update replication configuration name request.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Update replication configuration Staging Area subnet request.</p>
        pub fn staging_area_subnet_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.staging_area_subnet_id(inp);
            self
        }
        /// <p>Update replication configuration Staging Area subnet request.</p>
        pub fn set_staging_area_subnet_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_staging_area_subnet_id(input);
            self
        }
        /// <p>Update replication configuration associate default Application Migration Service Security group request.</p>
        pub fn associate_default_security_group(mut self, inp: bool) -> Self {
            self.inner = self.inner.associate_default_security_group(inp);
            self
        }
        /// <p>Update replication configuration associate default Application Migration Service Security group request.</p>
        pub fn set_associate_default_security_group(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_associate_default_security_group(input);
            self
        }
        /// Appends an item to `replicationServersSecurityGroupsIDs`.
        ///
        /// To override the contents of this collection use [`set_replication_servers_security_groups_i_ds`](Self::set_replication_servers_security_groups_i_ds).
        ///
        /// <p>Update replication configuration Replication Server Security Groups IDs request.</p>
        pub fn replication_servers_security_groups_i_ds(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.replication_servers_security_groups_i_ds(inp);
            self
        }
        /// <p>Update replication configuration Replication Server Security Groups IDs request.</p>
        pub fn set_replication_servers_security_groups_i_ds(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self
                .inner
                .set_replication_servers_security_groups_i_ds(input);
            self
        }
        /// <p>Update replication configuration Replication Server instance type request.</p>
        pub fn replication_server_instance_type(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.replication_server_instance_type(inp);
            self
        }
        /// <p>Update replication configuration Replication Server instance type request.</p>
        pub fn set_replication_server_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_server_instance_type(input);
            self
        }
        /// <p>Update replication configuration use dedicated Replication Server request.</p>
        pub fn use_dedicated_replication_server(mut self, inp: bool) -> Self {
            self.inner = self.inner.use_dedicated_replication_server(inp);
            self
        }
        /// <p>Update replication configuration use dedicated Replication Server request.</p>
        pub fn set_use_dedicated_replication_server(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_use_dedicated_replication_server(input);
            self
        }
        /// <p>Update replication configuration use default large Staging Disk type request.</p>
        pub fn default_large_staging_disk_type(
            mut self,
            inp: crate::model::ReplicationConfigurationDefaultLargeStagingDiskType,
        ) -> Self {
            self.inner = self.inner.default_large_staging_disk_type(inp);
            self
        }
        /// <p>Update replication configuration use default large Staging Disk type request.</p>
        pub fn set_default_large_staging_disk_type(
            mut self,
            input: std::option::Option<
                crate::model::ReplicationConfigurationDefaultLargeStagingDiskType,
            >,
        ) -> Self {
            self.inner = self.inner.set_default_large_staging_disk_type(input);
            self
        }
        /// Appends an item to `replicatedDisks`.
        ///
        /// To override the contents of this collection use [`set_replicated_disks`](Self::set_replicated_disks).
        ///
        /// <p>Update replication configuration replicated disks request.</p>
        pub fn replicated_disks(
            mut self,
            inp: impl Into<crate::model::ReplicationConfigurationReplicatedDisk>,
        ) -> Self {
            self.inner = self.inner.replicated_disks(inp);
            self
        }
        /// <p>Update replication configuration replicated disks request.</p>
        pub fn set_replicated_disks(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ReplicationConfigurationReplicatedDisk>,
            >,
        ) -> Self {
            self.inner = self.inner.set_replicated_disks(input);
            self
        }
        /// <p>Update replication configuration EBS encryption request.</p>
        pub fn ebs_encryption(
            mut self,
            inp: crate::model::ReplicationConfigurationEbsEncryption,
        ) -> Self {
            self.inner = self.inner.ebs_encryption(inp);
            self
        }
        /// <p>Update replication configuration EBS encryption request.</p>
        pub fn set_ebs_encryption(
            mut self,
            input: std::option::Option<crate::model::ReplicationConfigurationEbsEncryption>,
        ) -> Self {
            self.inner = self.inner.set_ebs_encryption(input);
            self
        }
        /// <p>Update replication configuration EBS encryption key ARN request.</p>
        pub fn ebs_encryption_key_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ebs_encryption_key_arn(inp);
            self
        }
        /// <p>Update replication configuration EBS encryption key ARN request.</p>
        pub fn set_ebs_encryption_key_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ebs_encryption_key_arn(input);
            self
        }
        /// <p>Update replication configuration bandwidth throttling request.</p>
        pub fn bandwidth_throttling(mut self, inp: i64) -> Self {
            self.inner = self.inner.bandwidth_throttling(inp);
            self
        }
        /// <p>Update replication configuration bandwidth throttling request.</p>
        pub fn set_bandwidth_throttling(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_bandwidth_throttling(input);
            self
        }
        /// <p>Update replication configuration data plane routing request.</p>
        pub fn data_plane_routing(
            mut self,
            inp: crate::model::ReplicationConfigurationDataPlaneRouting,
        ) -> Self {
            self.inner = self.inner.data_plane_routing(inp);
            self
        }
        /// <p>Update replication configuration data plane routing request.</p>
        pub fn set_data_plane_routing(
            mut self,
            input: std::option::Option<crate::model::ReplicationConfigurationDataPlaneRouting>,
        ) -> Self {
            self.inner = self.inner.set_data_plane_routing(input);
            self
        }
        /// <p>Update replication configuration create Public IP request.</p>
        pub fn create_public_ip(mut self, inp: bool) -> Self {
            self.inner = self.inner.create_public_ip(inp);
            self
        }
        /// <p>Update replication configuration create Public IP request.</p>
        pub fn set_create_public_ip(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_create_public_ip(input);
            self
        }
        /// Adds a key-value pair to `stagingAreaTags`.
        ///
        /// To override the contents of this collection use [`set_staging_area_tags`](Self::set_staging_area_tags).
        ///
        /// <p>Update replication configuration Staging Area Tags request.</p>
        pub fn staging_area_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.staging_area_tags(k, v);
            self
        }
        /// <p>Update replication configuration Staging Area Tags request.</p>
        pub fn set_staging_area_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_staging_area_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateReplicationConfigurationTemplate`.
    ///
    /// <p>Updates multiple ReplicationConfigurationTemplates by ID.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateReplicationConfigurationTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_replication_configuration_template_input::Builder,
    }
    impl<C, M, R> UpdateReplicationConfigurationTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateReplicationConfigurationTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateReplicationConfigurationTemplateOutput,
            aws_smithy_http::result::SdkError<
                crate::error::UpdateReplicationConfigurationTemplateError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateReplicationConfigurationTemplateInputOperationOutputAlias,
                crate::output::UpdateReplicationConfigurationTemplateOutput,
                crate::error::UpdateReplicationConfigurationTemplateError,
                crate::input::UpdateReplicationConfigurationTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Update replication configuration template template ID request.</p>
        pub fn replication_configuration_template_id(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.replication_configuration_template_id(inp);
            self
        }
        /// <p>Update replication configuration template template ID request.</p>
        pub fn set_replication_configuration_template_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_configuration_template_id(input);
            self
        }
        /// <p>Update replication configuration template ARN request.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>Update replication configuration template ARN request.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p>Update replication configuration template Staging Area subnet ID request.</p>
        pub fn staging_area_subnet_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.staging_area_subnet_id(inp);
            self
        }
        /// <p>Update replication configuration template Staging Area subnet ID request.</p>
        pub fn set_staging_area_subnet_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_staging_area_subnet_id(input);
            self
        }
        /// <p>Update replication configuration template associate default Application Migration Service Security group request.</p>
        pub fn associate_default_security_group(mut self, inp: bool) -> Self {
            self.inner = self.inner.associate_default_security_group(inp);
            self
        }
        /// <p>Update replication configuration template associate default Application Migration Service Security group request.</p>
        pub fn set_associate_default_security_group(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_associate_default_security_group(input);
            self
        }
        /// Appends an item to `replicationServersSecurityGroupsIDs`.
        ///
        /// To override the contents of this collection use [`set_replication_servers_security_groups_i_ds`](Self::set_replication_servers_security_groups_i_ds).
        ///
        /// <p>Update replication configuration template Replication Server Security groups IDs request.</p>
        pub fn replication_servers_security_groups_i_ds(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.replication_servers_security_groups_i_ds(inp);
            self
        }
        /// <p>Update replication configuration template Replication Server Security groups IDs request.</p>
        pub fn set_replication_servers_security_groups_i_ds(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self
                .inner
                .set_replication_servers_security_groups_i_ds(input);
            self
        }
        /// <p>Update replication configuration template Replication Server instance type request.</p>
        pub fn replication_server_instance_type(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.replication_server_instance_type(inp);
            self
        }
        /// <p>Update replication configuration template Replication Server instance type request.</p>
        pub fn set_replication_server_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_server_instance_type(input);
            self
        }
        /// <p>Update replication configuration template use dedicated Replication Server request.</p>
        pub fn use_dedicated_replication_server(mut self, inp: bool) -> Self {
            self.inner = self.inner.use_dedicated_replication_server(inp);
            self
        }
        /// <p>Update replication configuration template use dedicated Replication Server request.</p>
        pub fn set_use_dedicated_replication_server(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_use_dedicated_replication_server(input);
            self
        }
        /// <p>Update replication configuration template use default large Staging Disk type request.</p>
        pub fn default_large_staging_disk_type(
            mut self,
            inp: crate::model::ReplicationConfigurationDefaultLargeStagingDiskType,
        ) -> Self {
            self.inner = self.inner.default_large_staging_disk_type(inp);
            self
        }
        /// <p>Update replication configuration template use default large Staging Disk type request.</p>
        pub fn set_default_large_staging_disk_type(
            mut self,
            input: std::option::Option<
                crate::model::ReplicationConfigurationDefaultLargeStagingDiskType,
            >,
        ) -> Self {
            self.inner = self.inner.set_default_large_staging_disk_type(input);
            self
        }
        /// <p>Update replication configuration template EBS encryption request.</p>
        pub fn ebs_encryption(
            mut self,
            inp: crate::model::ReplicationConfigurationEbsEncryption,
        ) -> Self {
            self.inner = self.inner.ebs_encryption(inp);
            self
        }
        /// <p>Update replication configuration template EBS encryption request.</p>
        pub fn set_ebs_encryption(
            mut self,
            input: std::option::Option<crate::model::ReplicationConfigurationEbsEncryption>,
        ) -> Self {
            self.inner = self.inner.set_ebs_encryption(input);
            self
        }
        /// <p>Update replication configuration template EBS encryption key ARN request.</p>
        pub fn ebs_encryption_key_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ebs_encryption_key_arn(inp);
            self
        }
        /// <p>Update replication configuration template EBS encryption key ARN request.</p>
        pub fn set_ebs_encryption_key_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ebs_encryption_key_arn(input);
            self
        }
        /// <p>Update replication configuration template bandwidth throttling request.</p>
        pub fn bandwidth_throttling(mut self, inp: i64) -> Self {
            self.inner = self.inner.bandwidth_throttling(inp);
            self
        }
        /// <p>Update replication configuration template bandwidth throttling request.</p>
        pub fn set_bandwidth_throttling(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_bandwidth_throttling(input);
            self
        }
        /// <p>Update replication configuration template data plane routing request.</p>
        pub fn data_plane_routing(
            mut self,
            inp: crate::model::ReplicationConfigurationDataPlaneRouting,
        ) -> Self {
            self.inner = self.inner.data_plane_routing(inp);
            self
        }
        /// <p>Update replication configuration template data plane routing request.</p>
        pub fn set_data_plane_routing(
            mut self,
            input: std::option::Option<crate::model::ReplicationConfigurationDataPlaneRouting>,
        ) -> Self {
            self.inner = self.inner.set_data_plane_routing(input);
            self
        }
        /// <p>Update replication configuration template create Public IP request.</p>
        pub fn create_public_ip(mut self, inp: bool) -> Self {
            self.inner = self.inner.create_public_ip(inp);
            self
        }
        /// <p>Update replication configuration template create Public IP request.</p>
        pub fn set_create_public_ip(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_create_public_ip(input);
            self
        }
        /// Adds a key-value pair to `stagingAreaTags`.
        ///
        /// To override the contents of this collection use [`set_staging_area_tags`](Self::set_staging_area_tags).
        ///
        /// <p>Update replication configuration template Staging Area Tags request.</p>
        pub fn staging_area_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.staging_area_tags(k, v);
            self
        }
        /// <p>Update replication configuration template Staging Area Tags request.</p>
        pub fn set_staging_area_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_staging_area_tags(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::new(conn)
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::https()
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
