// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeVcenterClientsOutput {
    /// <p>List of items returned by DescribeVcenterClients.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::VcenterClient>>,
    /// <p>Next pagination token returned from DescribeVcenterClients.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeVcenterClientsOutput {
    /// <p>List of items returned by DescribeVcenterClients.</p>
    pub fn items(&self) -> std::option::Option<&[crate::model::VcenterClient]> {
        self.items.as_deref()
    }
    /// <p>Next pagination token returned from DescribeVcenterClients.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeVcenterClientsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeVcenterClientsOutput");
        formatter.field("items", &self.items);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeVcenterClientsOutput`](crate::output::DescribeVcenterClientsOutput)
pub mod describe_vcenter_clients_output {
    /// A builder for [`DescribeVcenterClientsOutput`](crate::output::DescribeVcenterClientsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) items: std::option::Option<std::vec::Vec<crate::model::VcenterClient>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>List of items returned by DescribeVcenterClients.</p>
        pub fn items(mut self, input: crate::model::VcenterClient) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input);
            self.items = Some(v);
            self
        }
        /// <p>List of items returned by DescribeVcenterClients.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VcenterClient>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// <p>Next pagination token returned from DescribeVcenterClients.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Next pagination token returned from DescribeVcenterClients.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeVcenterClientsOutput`](crate::output::DescribeVcenterClientsOutput)
        pub fn build(self) -> crate::output::DescribeVcenterClientsOutput {
            crate::output::DescribeVcenterClientsOutput {
                items: self.items,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeVcenterClientsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeVcenterClientsOutput`](crate::output::DescribeVcenterClientsOutput)
    pub fn builder() -> crate::output::describe_vcenter_clients_output::Builder {
        crate::output::describe_vcenter_clients_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteVcenterClientOutput {}
impl std::fmt::Debug for DeleteVcenterClientOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteVcenterClientOutput");
        formatter.finish()
    }
}
/// See [`DeleteVcenterClientOutput`](crate::output::DeleteVcenterClientOutput)
pub mod delete_vcenter_client_output {
    /// A builder for [`DeleteVcenterClientOutput`](crate::output::DeleteVcenterClientOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteVcenterClientOutput`](crate::output::DeleteVcenterClientOutput)
        pub fn build(self) -> crate::output::DeleteVcenterClientOutput {
            crate::output::DeleteVcenterClientOutput {}
        }
    }
}
impl DeleteVcenterClientOutput {
    /// Creates a new builder-style object to manufacture [`DeleteVcenterClientOutput`](crate::output::DeleteVcenterClientOutput)
    pub fn builder() -> crate::output::delete_vcenter_client_output::Builder {
        crate::output::delete_vcenter_client_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateSourceServerReplicationTypeOutput {
    /// <p>Source server ID.</p>
    pub source_server_id: std::option::Option<std::string::String>,
    /// <p>Source server ARN.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>Source server archived status.</p>
    pub is_archived: std::option::Option<bool>,
    /// <p>Source server Tags.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Source server launched instance.</p>
    pub launched_instance: std::option::Option<crate::model::LaunchedInstance>,
    /// <p>Source server data replication info.</p>
    pub data_replication_info: std::option::Option<crate::model::DataReplicationInfo>,
    /// <p>Source server lifecycle state.</p>
    pub life_cycle: std::option::Option<crate::model::LifeCycle>,
    /// <p>Source server properties.</p>
    pub source_properties: std::option::Option<crate::model::SourceProperties>,
    /// <p>Source server replication type.</p>
    pub replication_type: std::option::Option<crate::model::ReplicationType>,
    /// <p>Source server vCenter client id.</p>
    pub vcenter_client_id: std::option::Option<std::string::String>,
}
impl UpdateSourceServerReplicationTypeOutput {
    /// <p>Source server ID.</p>
    pub fn source_server_id(&self) -> std::option::Option<&str> {
        self.source_server_id.as_deref()
    }
    /// <p>Source server ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>Source server archived status.</p>
    pub fn is_archived(&self) -> std::option::Option<bool> {
        self.is_archived
    }
    /// <p>Source server Tags.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>Source server launched instance.</p>
    pub fn launched_instance(&self) -> std::option::Option<&crate::model::LaunchedInstance> {
        self.launched_instance.as_ref()
    }
    /// <p>Source server data replication info.</p>
    pub fn data_replication_info(&self) -> std::option::Option<&crate::model::DataReplicationInfo> {
        self.data_replication_info.as_ref()
    }
    /// <p>Source server lifecycle state.</p>
    pub fn life_cycle(&self) -> std::option::Option<&crate::model::LifeCycle> {
        self.life_cycle.as_ref()
    }
    /// <p>Source server properties.</p>
    pub fn source_properties(&self) -> std::option::Option<&crate::model::SourceProperties> {
        self.source_properties.as_ref()
    }
    /// <p>Source server replication type.</p>
    pub fn replication_type(&self) -> std::option::Option<&crate::model::ReplicationType> {
        self.replication_type.as_ref()
    }
    /// <p>Source server vCenter client id.</p>
    pub fn vcenter_client_id(&self) -> std::option::Option<&str> {
        self.vcenter_client_id.as_deref()
    }
}
impl std::fmt::Debug for UpdateSourceServerReplicationTypeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateSourceServerReplicationTypeOutput");
        formatter.field("source_server_id", &self.source_server_id);
        formatter.field("arn", &self.arn);
        formatter.field("is_archived", &self.is_archived);
        formatter.field("tags", &"*** Sensitive Data Redacted ***");
        formatter.field("launched_instance", &self.launched_instance);
        formatter.field("data_replication_info", &self.data_replication_info);
        formatter.field("life_cycle", &self.life_cycle);
        formatter.field("source_properties", &self.source_properties);
        formatter.field("replication_type", &self.replication_type);
        formatter.field("vcenter_client_id", &self.vcenter_client_id);
        formatter.finish()
    }
}
/// See [`UpdateSourceServerReplicationTypeOutput`](crate::output::UpdateSourceServerReplicationTypeOutput)
pub mod update_source_server_replication_type_output {
    /// A builder for [`UpdateSourceServerReplicationTypeOutput`](crate::output::UpdateSourceServerReplicationTypeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_server_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) is_archived: std::option::Option<bool>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) launched_instance: std::option::Option<crate::model::LaunchedInstance>,
        pub(crate) data_replication_info: std::option::Option<crate::model::DataReplicationInfo>,
        pub(crate) life_cycle: std::option::Option<crate::model::LifeCycle>,
        pub(crate) source_properties: std::option::Option<crate::model::SourceProperties>,
        pub(crate) replication_type: std::option::Option<crate::model::ReplicationType>,
        pub(crate) vcenter_client_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Source server ID.</p>
        pub fn source_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_server_id = Some(input.into());
            self
        }
        /// <p>Source server ID.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_server_id = input;
            self
        }
        /// <p>Source server ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>Source server ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>Source server archived status.</p>
        pub fn is_archived(mut self, input: bool) -> Self {
            self.is_archived = Some(input);
            self
        }
        /// <p>Source server archived status.</p>
        pub fn set_is_archived(mut self, input: std::option::Option<bool>) -> Self {
            self.is_archived = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Source server Tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Source server Tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Source server launched instance.</p>
        pub fn launched_instance(mut self, input: crate::model::LaunchedInstance) -> Self {
            self.launched_instance = Some(input);
            self
        }
        /// <p>Source server launched instance.</p>
        pub fn set_launched_instance(
            mut self,
            input: std::option::Option<crate::model::LaunchedInstance>,
        ) -> Self {
            self.launched_instance = input;
            self
        }
        /// <p>Source server data replication info.</p>
        pub fn data_replication_info(mut self, input: crate::model::DataReplicationInfo) -> Self {
            self.data_replication_info = Some(input);
            self
        }
        /// <p>Source server data replication info.</p>
        pub fn set_data_replication_info(
            mut self,
            input: std::option::Option<crate::model::DataReplicationInfo>,
        ) -> Self {
            self.data_replication_info = input;
            self
        }
        /// <p>Source server lifecycle state.</p>
        pub fn life_cycle(mut self, input: crate::model::LifeCycle) -> Self {
            self.life_cycle = Some(input);
            self
        }
        /// <p>Source server lifecycle state.</p>
        pub fn set_life_cycle(
            mut self,
            input: std::option::Option<crate::model::LifeCycle>,
        ) -> Self {
            self.life_cycle = input;
            self
        }
        /// <p>Source server properties.</p>
        pub fn source_properties(mut self, input: crate::model::SourceProperties) -> Self {
            self.source_properties = Some(input);
            self
        }
        /// <p>Source server properties.</p>
        pub fn set_source_properties(
            mut self,
            input: std::option::Option<crate::model::SourceProperties>,
        ) -> Self {
            self.source_properties = input;
            self
        }
        /// <p>Source server replication type.</p>
        pub fn replication_type(mut self, input: crate::model::ReplicationType) -> Self {
            self.replication_type = Some(input);
            self
        }
        /// <p>Source server replication type.</p>
        pub fn set_replication_type(
            mut self,
            input: std::option::Option<crate::model::ReplicationType>,
        ) -> Self {
            self.replication_type = input;
            self
        }
        /// <p>Source server vCenter client id.</p>
        pub fn vcenter_client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vcenter_client_id = Some(input.into());
            self
        }
        /// <p>Source server vCenter client id.</p>
        pub fn set_vcenter_client_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vcenter_client_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateSourceServerReplicationTypeOutput`](crate::output::UpdateSourceServerReplicationTypeOutput)
        pub fn build(self) -> crate::output::UpdateSourceServerReplicationTypeOutput {
            crate::output::UpdateSourceServerReplicationTypeOutput {
                source_server_id: self.source_server_id,
                arn: self.arn,
                is_archived: self.is_archived,
                tags: self.tags,
                launched_instance: self.launched_instance,
                data_replication_info: self.data_replication_info,
                life_cycle: self.life_cycle,
                source_properties: self.source_properties,
                replication_type: self.replication_type,
                vcenter_client_id: self.vcenter_client_id,
            }
        }
    }
}
impl UpdateSourceServerReplicationTypeOutput {
    /// Creates a new builder-style object to manufacture [`UpdateSourceServerReplicationTypeOutput`](crate::output::UpdateSourceServerReplicationTypeOutput)
    pub fn builder() -> crate::output::update_source_server_replication_type_output::Builder {
        crate::output::update_source_server_replication_type_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateReplicationConfigurationOutput {
    /// <p>Replication Configuration Source Server ID.</p>
    pub source_server_id: std::option::Option<std::string::String>,
    /// <p>Replication Configuration name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Replication Configuration Staging Area subnet ID.</p>
    pub staging_area_subnet_id: std::option::Option<std::string::String>,
    /// <p>Replication Configuration associate default Application Migration Service Security Group.</p>
    pub associate_default_security_group: std::option::Option<bool>,
    /// <p>Replication Configuration Replication Server Security Group IDs.</p>
    pub replication_servers_security_groups_i_ds:
        std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Replication Configuration Replication Server instance type.</p>
    pub replication_server_instance_type: std::option::Option<std::string::String>,
    /// <p>Replication Configuration use Dedicated Replication Server.</p>
    pub use_dedicated_replication_server: std::option::Option<bool>,
    /// <p>Replication Configuration use default large Staging Disks.</p>
    pub default_large_staging_disk_type:
        std::option::Option<crate::model::ReplicationConfigurationDefaultLargeStagingDiskType>,
    /// <p>Replication Configuration replicated disks.</p>
    pub replicated_disks:
        std::option::Option<std::vec::Vec<crate::model::ReplicationConfigurationReplicatedDisk>>,
    /// <p>Replication Configuration EBS encryption.</p>
    pub ebs_encryption: std::option::Option<crate::model::ReplicationConfigurationEbsEncryption>,
    /// <p>Replication Configuration EBS encryption key ARN.</p>
    pub ebs_encryption_key_arn: std::option::Option<std::string::String>,
    /// <p>Replication Configuration set bandwidth throttling.</p>
    pub bandwidth_throttling: i64,
    /// <p>Replication Configuration data plane routing.</p>
    pub data_plane_routing:
        std::option::Option<crate::model::ReplicationConfigurationDataPlaneRouting>,
    /// <p>Replication Configuration create Public IP.</p>
    pub create_public_ip: std::option::Option<bool>,
    /// <p>Replication Configuration Staging Area tags.</p>
    pub staging_area_tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl UpdateReplicationConfigurationOutput {
    /// <p>Replication Configuration Source Server ID.</p>
    pub fn source_server_id(&self) -> std::option::Option<&str> {
        self.source_server_id.as_deref()
    }
    /// <p>Replication Configuration name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Replication Configuration Staging Area subnet ID.</p>
    pub fn staging_area_subnet_id(&self) -> std::option::Option<&str> {
        self.staging_area_subnet_id.as_deref()
    }
    /// <p>Replication Configuration associate default Application Migration Service Security Group.</p>
    pub fn associate_default_security_group(&self) -> std::option::Option<bool> {
        self.associate_default_security_group
    }
    /// <p>Replication Configuration Replication Server Security Group IDs.</p>
    pub fn replication_servers_security_groups_i_ds(
        &self,
    ) -> std::option::Option<&[std::string::String]> {
        self.replication_servers_security_groups_i_ds.as_deref()
    }
    /// <p>Replication Configuration Replication Server instance type.</p>
    pub fn replication_server_instance_type(&self) -> std::option::Option<&str> {
        self.replication_server_instance_type.as_deref()
    }
    /// <p>Replication Configuration use Dedicated Replication Server.</p>
    pub fn use_dedicated_replication_server(&self) -> std::option::Option<bool> {
        self.use_dedicated_replication_server
    }
    /// <p>Replication Configuration use default large Staging Disks.</p>
    pub fn default_large_staging_disk_type(
        &self,
    ) -> std::option::Option<&crate::model::ReplicationConfigurationDefaultLargeStagingDiskType>
    {
        self.default_large_staging_disk_type.as_ref()
    }
    /// <p>Replication Configuration replicated disks.</p>
    pub fn replicated_disks(
        &self,
    ) -> std::option::Option<&[crate::model::ReplicationConfigurationReplicatedDisk]> {
        self.replicated_disks.as_deref()
    }
    /// <p>Replication Configuration EBS encryption.</p>
    pub fn ebs_encryption(
        &self,
    ) -> std::option::Option<&crate::model::ReplicationConfigurationEbsEncryption> {
        self.ebs_encryption.as_ref()
    }
    /// <p>Replication Configuration EBS encryption key ARN.</p>
    pub fn ebs_encryption_key_arn(&self) -> std::option::Option<&str> {
        self.ebs_encryption_key_arn.as_deref()
    }
    /// <p>Replication Configuration set bandwidth throttling.</p>
    pub fn bandwidth_throttling(&self) -> i64 {
        self.bandwidth_throttling
    }
    /// <p>Replication Configuration data plane routing.</p>
    pub fn data_plane_routing(
        &self,
    ) -> std::option::Option<&crate::model::ReplicationConfigurationDataPlaneRouting> {
        self.data_plane_routing.as_ref()
    }
    /// <p>Replication Configuration create Public IP.</p>
    pub fn create_public_ip(&self) -> std::option::Option<bool> {
        self.create_public_ip
    }
    /// <p>Replication Configuration Staging Area tags.</p>
    pub fn staging_area_tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.staging_area_tags.as_ref()
    }
}
impl std::fmt::Debug for UpdateReplicationConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateReplicationConfigurationOutput");
        formatter.field("source_server_id", &self.source_server_id);
        formatter.field("name", &self.name);
        formatter.field("staging_area_subnet_id", &self.staging_area_subnet_id);
        formatter.field(
            "associate_default_security_group",
            &self.associate_default_security_group,
        );
        formatter.field(
            "replication_servers_security_groups_i_ds",
            &self.replication_servers_security_groups_i_ds,
        );
        formatter.field(
            "replication_server_instance_type",
            &self.replication_server_instance_type,
        );
        formatter.field(
            "use_dedicated_replication_server",
            &self.use_dedicated_replication_server,
        );
        formatter.field(
            "default_large_staging_disk_type",
            &self.default_large_staging_disk_type,
        );
        formatter.field("replicated_disks", &self.replicated_disks);
        formatter.field("ebs_encryption", &self.ebs_encryption);
        formatter.field("ebs_encryption_key_arn", &self.ebs_encryption_key_arn);
        formatter.field("bandwidth_throttling", &self.bandwidth_throttling);
        formatter.field("data_plane_routing", &self.data_plane_routing);
        formatter.field("create_public_ip", &self.create_public_ip);
        formatter.field("staging_area_tags", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`UpdateReplicationConfigurationOutput`](crate::output::UpdateReplicationConfigurationOutput)
pub mod update_replication_configuration_output {
    /// A builder for [`UpdateReplicationConfigurationOutput`](crate::output::UpdateReplicationConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_server_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) staging_area_subnet_id: std::option::Option<std::string::String>,
        pub(crate) associate_default_security_group: std::option::Option<bool>,
        pub(crate) replication_servers_security_groups_i_ds:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) replication_server_instance_type: std::option::Option<std::string::String>,
        pub(crate) use_dedicated_replication_server: std::option::Option<bool>,
        pub(crate) default_large_staging_disk_type:
            std::option::Option<crate::model::ReplicationConfigurationDefaultLargeStagingDiskType>,
        pub(crate) replicated_disks: std::option::Option<
            std::vec::Vec<crate::model::ReplicationConfigurationReplicatedDisk>,
        >,
        pub(crate) ebs_encryption:
            std::option::Option<crate::model::ReplicationConfigurationEbsEncryption>,
        pub(crate) ebs_encryption_key_arn: std::option::Option<std::string::String>,
        pub(crate) bandwidth_throttling: std::option::Option<i64>,
        pub(crate) data_plane_routing:
            std::option::Option<crate::model::ReplicationConfigurationDataPlaneRouting>,
        pub(crate) create_public_ip: std::option::Option<bool>,
        pub(crate) staging_area_tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>Replication Configuration Source Server ID.</p>
        pub fn source_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_server_id = Some(input.into());
            self
        }
        /// <p>Replication Configuration Source Server ID.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_server_id = input;
            self
        }
        /// <p>Replication Configuration name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Replication Configuration name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Replication Configuration Staging Area subnet ID.</p>
        pub fn staging_area_subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.staging_area_subnet_id = Some(input.into());
            self
        }
        /// <p>Replication Configuration Staging Area subnet ID.</p>
        pub fn set_staging_area_subnet_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.staging_area_subnet_id = input;
            self
        }
        /// <p>Replication Configuration associate default Application Migration Service Security Group.</p>
        pub fn associate_default_security_group(mut self, input: bool) -> Self {
            self.associate_default_security_group = Some(input);
            self
        }
        /// <p>Replication Configuration associate default Application Migration Service Security Group.</p>
        pub fn set_associate_default_security_group(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.associate_default_security_group = input;
            self
        }
        /// Appends an item to `replication_servers_security_groups_i_ds`.
        ///
        /// To override the contents of this collection use [`set_replication_servers_security_groups_i_ds`](Self::set_replication_servers_security_groups_i_ds).
        ///
        /// <p>Replication Configuration Replication Server Security Group IDs.</p>
        pub fn replication_servers_security_groups_i_ds(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self
                .replication_servers_security_groups_i_ds
                .unwrap_or_default();
            v.push(input.into());
            self.replication_servers_security_groups_i_ds = Some(v);
            self
        }
        /// <p>Replication Configuration Replication Server Security Group IDs.</p>
        pub fn set_replication_servers_security_groups_i_ds(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.replication_servers_security_groups_i_ds = input;
            self
        }
        /// <p>Replication Configuration Replication Server instance type.</p>
        pub fn replication_server_instance_type(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.replication_server_instance_type = Some(input.into());
            self
        }
        /// <p>Replication Configuration Replication Server instance type.</p>
        pub fn set_replication_server_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_server_instance_type = input;
            self
        }
        /// <p>Replication Configuration use Dedicated Replication Server.</p>
        pub fn use_dedicated_replication_server(mut self, input: bool) -> Self {
            self.use_dedicated_replication_server = Some(input);
            self
        }
        /// <p>Replication Configuration use Dedicated Replication Server.</p>
        pub fn set_use_dedicated_replication_server(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.use_dedicated_replication_server = input;
            self
        }
        /// <p>Replication Configuration use default large Staging Disks.</p>
        pub fn default_large_staging_disk_type(
            mut self,
            input: crate::model::ReplicationConfigurationDefaultLargeStagingDiskType,
        ) -> Self {
            self.default_large_staging_disk_type = Some(input);
            self
        }
        /// <p>Replication Configuration use default large Staging Disks.</p>
        pub fn set_default_large_staging_disk_type(
            mut self,
            input: std::option::Option<
                crate::model::ReplicationConfigurationDefaultLargeStagingDiskType,
            >,
        ) -> Self {
            self.default_large_staging_disk_type = input;
            self
        }
        /// Appends an item to `replicated_disks`.
        ///
        /// To override the contents of this collection use [`set_replicated_disks`](Self::set_replicated_disks).
        ///
        /// <p>Replication Configuration replicated disks.</p>
        pub fn replicated_disks(
            mut self,
            input: crate::model::ReplicationConfigurationReplicatedDisk,
        ) -> Self {
            let mut v = self.replicated_disks.unwrap_or_default();
            v.push(input);
            self.replicated_disks = Some(v);
            self
        }
        /// <p>Replication Configuration replicated disks.</p>
        pub fn set_replicated_disks(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ReplicationConfigurationReplicatedDisk>,
            >,
        ) -> Self {
            self.replicated_disks = input;
            self
        }
        /// <p>Replication Configuration EBS encryption.</p>
        pub fn ebs_encryption(
            mut self,
            input: crate::model::ReplicationConfigurationEbsEncryption,
        ) -> Self {
            self.ebs_encryption = Some(input);
            self
        }
        /// <p>Replication Configuration EBS encryption.</p>
        pub fn set_ebs_encryption(
            mut self,
            input: std::option::Option<crate::model::ReplicationConfigurationEbsEncryption>,
        ) -> Self {
            self.ebs_encryption = input;
            self
        }
        /// <p>Replication Configuration EBS encryption key ARN.</p>
        pub fn ebs_encryption_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.ebs_encryption_key_arn = Some(input.into());
            self
        }
        /// <p>Replication Configuration EBS encryption key ARN.</p>
        pub fn set_ebs_encryption_key_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ebs_encryption_key_arn = input;
            self
        }
        /// <p>Replication Configuration set bandwidth throttling.</p>
        pub fn bandwidth_throttling(mut self, input: i64) -> Self {
            self.bandwidth_throttling = Some(input);
            self
        }
        /// <p>Replication Configuration set bandwidth throttling.</p>
        pub fn set_bandwidth_throttling(mut self, input: std::option::Option<i64>) -> Self {
            self.bandwidth_throttling = input;
            self
        }
        /// <p>Replication Configuration data plane routing.</p>
        pub fn data_plane_routing(
            mut self,
            input: crate::model::ReplicationConfigurationDataPlaneRouting,
        ) -> Self {
            self.data_plane_routing = Some(input);
            self
        }
        /// <p>Replication Configuration data plane routing.</p>
        pub fn set_data_plane_routing(
            mut self,
            input: std::option::Option<crate::model::ReplicationConfigurationDataPlaneRouting>,
        ) -> Self {
            self.data_plane_routing = input;
            self
        }
        /// <p>Replication Configuration create Public IP.</p>
        pub fn create_public_ip(mut self, input: bool) -> Self {
            self.create_public_ip = Some(input);
            self
        }
        /// <p>Replication Configuration create Public IP.</p>
        pub fn set_create_public_ip(mut self, input: std::option::Option<bool>) -> Self {
            self.create_public_ip = input;
            self
        }
        /// Adds a key-value pair to `staging_area_tags`.
        ///
        /// To override the contents of this collection use [`set_staging_area_tags`](Self::set_staging_area_tags).
        ///
        /// <p>Replication Configuration Staging Area tags.</p>
        pub fn staging_area_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.staging_area_tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.staging_area_tags = Some(hash_map);
            self
        }
        /// <p>Replication Configuration Staging Area tags.</p>
        pub fn set_staging_area_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.staging_area_tags = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateReplicationConfigurationOutput`](crate::output::UpdateReplicationConfigurationOutput)
        pub fn build(self) -> crate::output::UpdateReplicationConfigurationOutput {
            crate::output::UpdateReplicationConfigurationOutput {
                source_server_id: self.source_server_id,
                name: self.name,
                staging_area_subnet_id: self.staging_area_subnet_id,
                associate_default_security_group: self.associate_default_security_group,
                replication_servers_security_groups_i_ds: self
                    .replication_servers_security_groups_i_ds,
                replication_server_instance_type: self.replication_server_instance_type,
                use_dedicated_replication_server: self.use_dedicated_replication_server,
                default_large_staging_disk_type: self.default_large_staging_disk_type,
                replicated_disks: self.replicated_disks,
                ebs_encryption: self.ebs_encryption,
                ebs_encryption_key_arn: self.ebs_encryption_key_arn,
                bandwidth_throttling: self.bandwidth_throttling.unwrap_or_default(),
                data_plane_routing: self.data_plane_routing,
                create_public_ip: self.create_public_ip,
                staging_area_tags: self.staging_area_tags,
            }
        }
    }
}
impl UpdateReplicationConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`UpdateReplicationConfigurationOutput`](crate::output::UpdateReplicationConfigurationOutput)
    pub fn builder() -> crate::output::update_replication_configuration_output::Builder {
        crate::output::update_replication_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateLaunchConfigurationOutput {
    /// <p>Launch configuration Source Server ID.</p>
    pub source_server_id: std::option::Option<std::string::String>,
    /// <p>Launch configuration name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Launch configuration EC2 Launch template ID.</p>
    pub ec2_launch_template_id: std::option::Option<std::string::String>,
    /// <p>Launch disposition for launch configuration.</p>
    pub launch_disposition: std::option::Option<crate::model::LaunchDisposition>,
    /// <p>Launch configuration Target instance type right sizing method.</p>
    pub target_instance_type_right_sizing_method:
        std::option::Option<crate::model::TargetInstanceTypeRightSizingMethod>,
    /// <p>Copy Private IP during Launch Configuration.</p>
    pub copy_private_ip: std::option::Option<bool>,
    /// <p>Copy Tags during Launch Configuration.</p>
    pub copy_tags: std::option::Option<bool>,
    /// <p>Launch configuration OS licensing.</p>
    pub licensing: std::option::Option<crate::model::Licensing>,
    /// <p>Launch configuration boot mode.</p>
    pub boot_mode: std::option::Option<crate::model::BootMode>,
}
impl UpdateLaunchConfigurationOutput {
    /// <p>Launch configuration Source Server ID.</p>
    pub fn source_server_id(&self) -> std::option::Option<&str> {
        self.source_server_id.as_deref()
    }
    /// <p>Launch configuration name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Launch configuration EC2 Launch template ID.</p>
    pub fn ec2_launch_template_id(&self) -> std::option::Option<&str> {
        self.ec2_launch_template_id.as_deref()
    }
    /// <p>Launch disposition for launch configuration.</p>
    pub fn launch_disposition(&self) -> std::option::Option<&crate::model::LaunchDisposition> {
        self.launch_disposition.as_ref()
    }
    /// <p>Launch configuration Target instance type right sizing method.</p>
    pub fn target_instance_type_right_sizing_method(
        &self,
    ) -> std::option::Option<&crate::model::TargetInstanceTypeRightSizingMethod> {
        self.target_instance_type_right_sizing_method.as_ref()
    }
    /// <p>Copy Private IP during Launch Configuration.</p>
    pub fn copy_private_ip(&self) -> std::option::Option<bool> {
        self.copy_private_ip
    }
    /// <p>Copy Tags during Launch Configuration.</p>
    pub fn copy_tags(&self) -> std::option::Option<bool> {
        self.copy_tags
    }
    /// <p>Launch configuration OS licensing.</p>
    pub fn licensing(&self) -> std::option::Option<&crate::model::Licensing> {
        self.licensing.as_ref()
    }
    /// <p>Launch configuration boot mode.</p>
    pub fn boot_mode(&self) -> std::option::Option<&crate::model::BootMode> {
        self.boot_mode.as_ref()
    }
}
impl std::fmt::Debug for UpdateLaunchConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateLaunchConfigurationOutput");
        formatter.field("source_server_id", &self.source_server_id);
        formatter.field("name", &self.name);
        formatter.field("ec2_launch_template_id", &self.ec2_launch_template_id);
        formatter.field("launch_disposition", &self.launch_disposition);
        formatter.field(
            "target_instance_type_right_sizing_method",
            &self.target_instance_type_right_sizing_method,
        );
        formatter.field("copy_private_ip", &self.copy_private_ip);
        formatter.field("copy_tags", &self.copy_tags);
        formatter.field("licensing", &self.licensing);
        formatter.field("boot_mode", &self.boot_mode);
        formatter.finish()
    }
}
/// See [`UpdateLaunchConfigurationOutput`](crate::output::UpdateLaunchConfigurationOutput)
pub mod update_launch_configuration_output {
    /// A builder for [`UpdateLaunchConfigurationOutput`](crate::output::UpdateLaunchConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_server_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) ec2_launch_template_id: std::option::Option<std::string::String>,
        pub(crate) launch_disposition: std::option::Option<crate::model::LaunchDisposition>,
        pub(crate) target_instance_type_right_sizing_method:
            std::option::Option<crate::model::TargetInstanceTypeRightSizingMethod>,
        pub(crate) copy_private_ip: std::option::Option<bool>,
        pub(crate) copy_tags: std::option::Option<bool>,
        pub(crate) licensing: std::option::Option<crate::model::Licensing>,
        pub(crate) boot_mode: std::option::Option<crate::model::BootMode>,
    }
    impl Builder {
        /// <p>Launch configuration Source Server ID.</p>
        pub fn source_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_server_id = Some(input.into());
            self
        }
        /// <p>Launch configuration Source Server ID.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_server_id = input;
            self
        }
        /// <p>Launch configuration name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Launch configuration name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Launch configuration EC2 Launch template ID.</p>
        pub fn ec2_launch_template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ec2_launch_template_id = Some(input.into());
            self
        }
        /// <p>Launch configuration EC2 Launch template ID.</p>
        pub fn set_ec2_launch_template_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ec2_launch_template_id = input;
            self
        }
        /// <p>Launch disposition for launch configuration.</p>
        pub fn launch_disposition(mut self, input: crate::model::LaunchDisposition) -> Self {
            self.launch_disposition = Some(input);
            self
        }
        /// <p>Launch disposition for launch configuration.</p>
        pub fn set_launch_disposition(
            mut self,
            input: std::option::Option<crate::model::LaunchDisposition>,
        ) -> Self {
            self.launch_disposition = input;
            self
        }
        /// <p>Launch configuration Target instance type right sizing method.</p>
        pub fn target_instance_type_right_sizing_method(
            mut self,
            input: crate::model::TargetInstanceTypeRightSizingMethod,
        ) -> Self {
            self.target_instance_type_right_sizing_method = Some(input);
            self
        }
        /// <p>Launch configuration Target instance type right sizing method.</p>
        pub fn set_target_instance_type_right_sizing_method(
            mut self,
            input: std::option::Option<crate::model::TargetInstanceTypeRightSizingMethod>,
        ) -> Self {
            self.target_instance_type_right_sizing_method = input;
            self
        }
        /// <p>Copy Private IP during Launch Configuration.</p>
        pub fn copy_private_ip(mut self, input: bool) -> Self {
            self.copy_private_ip = Some(input);
            self
        }
        /// <p>Copy Private IP during Launch Configuration.</p>
        pub fn set_copy_private_ip(mut self, input: std::option::Option<bool>) -> Self {
            self.copy_private_ip = input;
            self
        }
        /// <p>Copy Tags during Launch Configuration.</p>
        pub fn copy_tags(mut self, input: bool) -> Self {
            self.copy_tags = Some(input);
            self
        }
        /// <p>Copy Tags during Launch Configuration.</p>
        pub fn set_copy_tags(mut self, input: std::option::Option<bool>) -> Self {
            self.copy_tags = input;
            self
        }
        /// <p>Launch configuration OS licensing.</p>
        pub fn licensing(mut self, input: crate::model::Licensing) -> Self {
            self.licensing = Some(input);
            self
        }
        /// <p>Launch configuration OS licensing.</p>
        pub fn set_licensing(
            mut self,
            input: std::option::Option<crate::model::Licensing>,
        ) -> Self {
            self.licensing = input;
            self
        }
        /// <p>Launch configuration boot mode.</p>
        pub fn boot_mode(mut self, input: crate::model::BootMode) -> Self {
            self.boot_mode = Some(input);
            self
        }
        /// <p>Launch configuration boot mode.</p>
        pub fn set_boot_mode(mut self, input: std::option::Option<crate::model::BootMode>) -> Self {
            self.boot_mode = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateLaunchConfigurationOutput`](crate::output::UpdateLaunchConfigurationOutput)
        pub fn build(self) -> crate::output::UpdateLaunchConfigurationOutput {
            crate::output::UpdateLaunchConfigurationOutput {
                source_server_id: self.source_server_id,
                name: self.name,
                ec2_launch_template_id: self.ec2_launch_template_id,
                launch_disposition: self.launch_disposition,
                target_instance_type_right_sizing_method: self
                    .target_instance_type_right_sizing_method,
                copy_private_ip: self.copy_private_ip,
                copy_tags: self.copy_tags,
                licensing: self.licensing,
                boot_mode: self.boot_mode,
            }
        }
    }
}
impl UpdateLaunchConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`UpdateLaunchConfigurationOutput`](crate::output::UpdateLaunchConfigurationOutput)
    pub fn builder() -> crate::output::update_launch_configuration_output::Builder {
        crate::output::update_launch_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartReplicationOutput {
    /// <p>Source server ID.</p>
    pub source_server_id: std::option::Option<std::string::String>,
    /// <p>Source server ARN.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>Source server archived status.</p>
    pub is_archived: std::option::Option<bool>,
    /// <p>Source server Tags.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Source server launched instance.</p>
    pub launched_instance: std::option::Option<crate::model::LaunchedInstance>,
    /// <p>Source server data replication info.</p>
    pub data_replication_info: std::option::Option<crate::model::DataReplicationInfo>,
    /// <p>Source server lifecycle state.</p>
    pub life_cycle: std::option::Option<crate::model::LifeCycle>,
    /// <p>Source server properties.</p>
    pub source_properties: std::option::Option<crate::model::SourceProperties>,
    /// <p>Source server replication type.</p>
    pub replication_type: std::option::Option<crate::model::ReplicationType>,
    /// <p>Source server vCenter client id.</p>
    pub vcenter_client_id: std::option::Option<std::string::String>,
}
impl StartReplicationOutput {
    /// <p>Source server ID.</p>
    pub fn source_server_id(&self) -> std::option::Option<&str> {
        self.source_server_id.as_deref()
    }
    /// <p>Source server ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>Source server archived status.</p>
    pub fn is_archived(&self) -> std::option::Option<bool> {
        self.is_archived
    }
    /// <p>Source server Tags.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>Source server launched instance.</p>
    pub fn launched_instance(&self) -> std::option::Option<&crate::model::LaunchedInstance> {
        self.launched_instance.as_ref()
    }
    /// <p>Source server data replication info.</p>
    pub fn data_replication_info(&self) -> std::option::Option<&crate::model::DataReplicationInfo> {
        self.data_replication_info.as_ref()
    }
    /// <p>Source server lifecycle state.</p>
    pub fn life_cycle(&self) -> std::option::Option<&crate::model::LifeCycle> {
        self.life_cycle.as_ref()
    }
    /// <p>Source server properties.</p>
    pub fn source_properties(&self) -> std::option::Option<&crate::model::SourceProperties> {
        self.source_properties.as_ref()
    }
    /// <p>Source server replication type.</p>
    pub fn replication_type(&self) -> std::option::Option<&crate::model::ReplicationType> {
        self.replication_type.as_ref()
    }
    /// <p>Source server vCenter client id.</p>
    pub fn vcenter_client_id(&self) -> std::option::Option<&str> {
        self.vcenter_client_id.as_deref()
    }
}
impl std::fmt::Debug for StartReplicationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartReplicationOutput");
        formatter.field("source_server_id", &self.source_server_id);
        formatter.field("arn", &self.arn);
        formatter.field("is_archived", &self.is_archived);
        formatter.field("tags", &"*** Sensitive Data Redacted ***");
        formatter.field("launched_instance", &self.launched_instance);
        formatter.field("data_replication_info", &self.data_replication_info);
        formatter.field("life_cycle", &self.life_cycle);
        formatter.field("source_properties", &self.source_properties);
        formatter.field("replication_type", &self.replication_type);
        formatter.field("vcenter_client_id", &self.vcenter_client_id);
        formatter.finish()
    }
}
/// See [`StartReplicationOutput`](crate::output::StartReplicationOutput)
pub mod start_replication_output {
    /// A builder for [`StartReplicationOutput`](crate::output::StartReplicationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_server_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) is_archived: std::option::Option<bool>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) launched_instance: std::option::Option<crate::model::LaunchedInstance>,
        pub(crate) data_replication_info: std::option::Option<crate::model::DataReplicationInfo>,
        pub(crate) life_cycle: std::option::Option<crate::model::LifeCycle>,
        pub(crate) source_properties: std::option::Option<crate::model::SourceProperties>,
        pub(crate) replication_type: std::option::Option<crate::model::ReplicationType>,
        pub(crate) vcenter_client_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Source server ID.</p>
        pub fn source_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_server_id = Some(input.into());
            self
        }
        /// <p>Source server ID.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_server_id = input;
            self
        }
        /// <p>Source server ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>Source server ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>Source server archived status.</p>
        pub fn is_archived(mut self, input: bool) -> Self {
            self.is_archived = Some(input);
            self
        }
        /// <p>Source server archived status.</p>
        pub fn set_is_archived(mut self, input: std::option::Option<bool>) -> Self {
            self.is_archived = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Source server Tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Source server Tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Source server launched instance.</p>
        pub fn launched_instance(mut self, input: crate::model::LaunchedInstance) -> Self {
            self.launched_instance = Some(input);
            self
        }
        /// <p>Source server launched instance.</p>
        pub fn set_launched_instance(
            mut self,
            input: std::option::Option<crate::model::LaunchedInstance>,
        ) -> Self {
            self.launched_instance = input;
            self
        }
        /// <p>Source server data replication info.</p>
        pub fn data_replication_info(mut self, input: crate::model::DataReplicationInfo) -> Self {
            self.data_replication_info = Some(input);
            self
        }
        /// <p>Source server data replication info.</p>
        pub fn set_data_replication_info(
            mut self,
            input: std::option::Option<crate::model::DataReplicationInfo>,
        ) -> Self {
            self.data_replication_info = input;
            self
        }
        /// <p>Source server lifecycle state.</p>
        pub fn life_cycle(mut self, input: crate::model::LifeCycle) -> Self {
            self.life_cycle = Some(input);
            self
        }
        /// <p>Source server lifecycle state.</p>
        pub fn set_life_cycle(
            mut self,
            input: std::option::Option<crate::model::LifeCycle>,
        ) -> Self {
            self.life_cycle = input;
            self
        }
        /// <p>Source server properties.</p>
        pub fn source_properties(mut self, input: crate::model::SourceProperties) -> Self {
            self.source_properties = Some(input);
            self
        }
        /// <p>Source server properties.</p>
        pub fn set_source_properties(
            mut self,
            input: std::option::Option<crate::model::SourceProperties>,
        ) -> Self {
            self.source_properties = input;
            self
        }
        /// <p>Source server replication type.</p>
        pub fn replication_type(mut self, input: crate::model::ReplicationType) -> Self {
            self.replication_type = Some(input);
            self
        }
        /// <p>Source server replication type.</p>
        pub fn set_replication_type(
            mut self,
            input: std::option::Option<crate::model::ReplicationType>,
        ) -> Self {
            self.replication_type = input;
            self
        }
        /// <p>Source server vCenter client id.</p>
        pub fn vcenter_client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vcenter_client_id = Some(input.into());
            self
        }
        /// <p>Source server vCenter client id.</p>
        pub fn set_vcenter_client_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vcenter_client_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StartReplicationOutput`](crate::output::StartReplicationOutput)
        pub fn build(self) -> crate::output::StartReplicationOutput {
            crate::output::StartReplicationOutput {
                source_server_id: self.source_server_id,
                arn: self.arn,
                is_archived: self.is_archived,
                tags: self.tags,
                launched_instance: self.launched_instance,
                data_replication_info: self.data_replication_info,
                life_cycle: self.life_cycle,
                source_properties: self.source_properties,
                replication_type: self.replication_type,
                vcenter_client_id: self.vcenter_client_id,
            }
        }
    }
}
impl StartReplicationOutput {
    /// Creates a new builder-style object to manufacture [`StartReplicationOutput`](crate::output::StartReplicationOutput)
    pub fn builder() -> crate::output::start_replication_output::Builder {
        crate::output::start_replication_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RetryDataReplicationOutput {
    /// <p>Source server ID.</p>
    pub source_server_id: std::option::Option<std::string::String>,
    /// <p>Source server ARN.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>Source server archived status.</p>
    pub is_archived: std::option::Option<bool>,
    /// <p>Source server Tags.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Source server launched instance.</p>
    pub launched_instance: std::option::Option<crate::model::LaunchedInstance>,
    /// <p>Source server data replication info.</p>
    pub data_replication_info: std::option::Option<crate::model::DataReplicationInfo>,
    /// <p>Source server lifecycle state.</p>
    pub life_cycle: std::option::Option<crate::model::LifeCycle>,
    /// <p>Source server properties.</p>
    pub source_properties: std::option::Option<crate::model::SourceProperties>,
    /// <p>Source server replication type.</p>
    pub replication_type: std::option::Option<crate::model::ReplicationType>,
    /// <p>Source server vCenter client id.</p>
    pub vcenter_client_id: std::option::Option<std::string::String>,
}
impl RetryDataReplicationOutput {
    /// <p>Source server ID.</p>
    pub fn source_server_id(&self) -> std::option::Option<&str> {
        self.source_server_id.as_deref()
    }
    /// <p>Source server ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>Source server archived status.</p>
    pub fn is_archived(&self) -> std::option::Option<bool> {
        self.is_archived
    }
    /// <p>Source server Tags.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>Source server launched instance.</p>
    pub fn launched_instance(&self) -> std::option::Option<&crate::model::LaunchedInstance> {
        self.launched_instance.as_ref()
    }
    /// <p>Source server data replication info.</p>
    pub fn data_replication_info(&self) -> std::option::Option<&crate::model::DataReplicationInfo> {
        self.data_replication_info.as_ref()
    }
    /// <p>Source server lifecycle state.</p>
    pub fn life_cycle(&self) -> std::option::Option<&crate::model::LifeCycle> {
        self.life_cycle.as_ref()
    }
    /// <p>Source server properties.</p>
    pub fn source_properties(&self) -> std::option::Option<&crate::model::SourceProperties> {
        self.source_properties.as_ref()
    }
    /// <p>Source server replication type.</p>
    pub fn replication_type(&self) -> std::option::Option<&crate::model::ReplicationType> {
        self.replication_type.as_ref()
    }
    /// <p>Source server vCenter client id.</p>
    pub fn vcenter_client_id(&self) -> std::option::Option<&str> {
        self.vcenter_client_id.as_deref()
    }
}
impl std::fmt::Debug for RetryDataReplicationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RetryDataReplicationOutput");
        formatter.field("source_server_id", &self.source_server_id);
        formatter.field("arn", &self.arn);
        formatter.field("is_archived", &self.is_archived);
        formatter.field("tags", &"*** Sensitive Data Redacted ***");
        formatter.field("launched_instance", &self.launched_instance);
        formatter.field("data_replication_info", &self.data_replication_info);
        formatter.field("life_cycle", &self.life_cycle);
        formatter.field("source_properties", &self.source_properties);
        formatter.field("replication_type", &self.replication_type);
        formatter.field("vcenter_client_id", &self.vcenter_client_id);
        formatter.finish()
    }
}
/// See [`RetryDataReplicationOutput`](crate::output::RetryDataReplicationOutput)
pub mod retry_data_replication_output {
    /// A builder for [`RetryDataReplicationOutput`](crate::output::RetryDataReplicationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_server_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) is_archived: std::option::Option<bool>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) launched_instance: std::option::Option<crate::model::LaunchedInstance>,
        pub(crate) data_replication_info: std::option::Option<crate::model::DataReplicationInfo>,
        pub(crate) life_cycle: std::option::Option<crate::model::LifeCycle>,
        pub(crate) source_properties: std::option::Option<crate::model::SourceProperties>,
        pub(crate) replication_type: std::option::Option<crate::model::ReplicationType>,
        pub(crate) vcenter_client_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Source server ID.</p>
        pub fn source_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_server_id = Some(input.into());
            self
        }
        /// <p>Source server ID.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_server_id = input;
            self
        }
        /// <p>Source server ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>Source server ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>Source server archived status.</p>
        pub fn is_archived(mut self, input: bool) -> Self {
            self.is_archived = Some(input);
            self
        }
        /// <p>Source server archived status.</p>
        pub fn set_is_archived(mut self, input: std::option::Option<bool>) -> Self {
            self.is_archived = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Source server Tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Source server Tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Source server launched instance.</p>
        pub fn launched_instance(mut self, input: crate::model::LaunchedInstance) -> Self {
            self.launched_instance = Some(input);
            self
        }
        /// <p>Source server launched instance.</p>
        pub fn set_launched_instance(
            mut self,
            input: std::option::Option<crate::model::LaunchedInstance>,
        ) -> Self {
            self.launched_instance = input;
            self
        }
        /// <p>Source server data replication info.</p>
        pub fn data_replication_info(mut self, input: crate::model::DataReplicationInfo) -> Self {
            self.data_replication_info = Some(input);
            self
        }
        /// <p>Source server data replication info.</p>
        pub fn set_data_replication_info(
            mut self,
            input: std::option::Option<crate::model::DataReplicationInfo>,
        ) -> Self {
            self.data_replication_info = input;
            self
        }
        /// <p>Source server lifecycle state.</p>
        pub fn life_cycle(mut self, input: crate::model::LifeCycle) -> Self {
            self.life_cycle = Some(input);
            self
        }
        /// <p>Source server lifecycle state.</p>
        pub fn set_life_cycle(
            mut self,
            input: std::option::Option<crate::model::LifeCycle>,
        ) -> Self {
            self.life_cycle = input;
            self
        }
        /// <p>Source server properties.</p>
        pub fn source_properties(mut self, input: crate::model::SourceProperties) -> Self {
            self.source_properties = Some(input);
            self
        }
        /// <p>Source server properties.</p>
        pub fn set_source_properties(
            mut self,
            input: std::option::Option<crate::model::SourceProperties>,
        ) -> Self {
            self.source_properties = input;
            self
        }
        /// <p>Source server replication type.</p>
        pub fn replication_type(mut self, input: crate::model::ReplicationType) -> Self {
            self.replication_type = Some(input);
            self
        }
        /// <p>Source server replication type.</p>
        pub fn set_replication_type(
            mut self,
            input: std::option::Option<crate::model::ReplicationType>,
        ) -> Self {
            self.replication_type = input;
            self
        }
        /// <p>Source server vCenter client id.</p>
        pub fn vcenter_client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vcenter_client_id = Some(input.into());
            self
        }
        /// <p>Source server vCenter client id.</p>
        pub fn set_vcenter_client_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vcenter_client_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RetryDataReplicationOutput`](crate::output::RetryDataReplicationOutput)
        pub fn build(self) -> crate::output::RetryDataReplicationOutput {
            crate::output::RetryDataReplicationOutput {
                source_server_id: self.source_server_id,
                arn: self.arn,
                is_archived: self.is_archived,
                tags: self.tags,
                launched_instance: self.launched_instance,
                data_replication_info: self.data_replication_info,
                life_cycle: self.life_cycle,
                source_properties: self.source_properties,
                replication_type: self.replication_type,
                vcenter_client_id: self.vcenter_client_id,
            }
        }
    }
}
impl RetryDataReplicationOutput {
    /// Creates a new builder-style object to manufacture [`RetryDataReplicationOutput`](crate::output::RetryDataReplicationOutput)
    pub fn builder() -> crate::output::retry_data_replication_output::Builder {
        crate::output::retry_data_replication_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MarkAsArchivedOutput {
    /// <p>Source server ID.</p>
    pub source_server_id: std::option::Option<std::string::String>,
    /// <p>Source server ARN.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>Source server archived status.</p>
    pub is_archived: std::option::Option<bool>,
    /// <p>Source server Tags.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Source server launched instance.</p>
    pub launched_instance: std::option::Option<crate::model::LaunchedInstance>,
    /// <p>Source server data replication info.</p>
    pub data_replication_info: std::option::Option<crate::model::DataReplicationInfo>,
    /// <p>Source server lifecycle state.</p>
    pub life_cycle: std::option::Option<crate::model::LifeCycle>,
    /// <p>Source server properties.</p>
    pub source_properties: std::option::Option<crate::model::SourceProperties>,
    /// <p>Source server replication type.</p>
    pub replication_type: std::option::Option<crate::model::ReplicationType>,
    /// <p>Source server vCenter client id.</p>
    pub vcenter_client_id: std::option::Option<std::string::String>,
}
impl MarkAsArchivedOutput {
    /// <p>Source server ID.</p>
    pub fn source_server_id(&self) -> std::option::Option<&str> {
        self.source_server_id.as_deref()
    }
    /// <p>Source server ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>Source server archived status.</p>
    pub fn is_archived(&self) -> std::option::Option<bool> {
        self.is_archived
    }
    /// <p>Source server Tags.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>Source server launched instance.</p>
    pub fn launched_instance(&self) -> std::option::Option<&crate::model::LaunchedInstance> {
        self.launched_instance.as_ref()
    }
    /// <p>Source server data replication info.</p>
    pub fn data_replication_info(&self) -> std::option::Option<&crate::model::DataReplicationInfo> {
        self.data_replication_info.as_ref()
    }
    /// <p>Source server lifecycle state.</p>
    pub fn life_cycle(&self) -> std::option::Option<&crate::model::LifeCycle> {
        self.life_cycle.as_ref()
    }
    /// <p>Source server properties.</p>
    pub fn source_properties(&self) -> std::option::Option<&crate::model::SourceProperties> {
        self.source_properties.as_ref()
    }
    /// <p>Source server replication type.</p>
    pub fn replication_type(&self) -> std::option::Option<&crate::model::ReplicationType> {
        self.replication_type.as_ref()
    }
    /// <p>Source server vCenter client id.</p>
    pub fn vcenter_client_id(&self) -> std::option::Option<&str> {
        self.vcenter_client_id.as_deref()
    }
}
impl std::fmt::Debug for MarkAsArchivedOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MarkAsArchivedOutput");
        formatter.field("source_server_id", &self.source_server_id);
        formatter.field("arn", &self.arn);
        formatter.field("is_archived", &self.is_archived);
        formatter.field("tags", &"*** Sensitive Data Redacted ***");
        formatter.field("launched_instance", &self.launched_instance);
        formatter.field("data_replication_info", &self.data_replication_info);
        formatter.field("life_cycle", &self.life_cycle);
        formatter.field("source_properties", &self.source_properties);
        formatter.field("replication_type", &self.replication_type);
        formatter.field("vcenter_client_id", &self.vcenter_client_id);
        formatter.finish()
    }
}
/// See [`MarkAsArchivedOutput`](crate::output::MarkAsArchivedOutput)
pub mod mark_as_archived_output {
    /// A builder for [`MarkAsArchivedOutput`](crate::output::MarkAsArchivedOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_server_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) is_archived: std::option::Option<bool>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) launched_instance: std::option::Option<crate::model::LaunchedInstance>,
        pub(crate) data_replication_info: std::option::Option<crate::model::DataReplicationInfo>,
        pub(crate) life_cycle: std::option::Option<crate::model::LifeCycle>,
        pub(crate) source_properties: std::option::Option<crate::model::SourceProperties>,
        pub(crate) replication_type: std::option::Option<crate::model::ReplicationType>,
        pub(crate) vcenter_client_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Source server ID.</p>
        pub fn source_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_server_id = Some(input.into());
            self
        }
        /// <p>Source server ID.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_server_id = input;
            self
        }
        /// <p>Source server ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>Source server ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>Source server archived status.</p>
        pub fn is_archived(mut self, input: bool) -> Self {
            self.is_archived = Some(input);
            self
        }
        /// <p>Source server archived status.</p>
        pub fn set_is_archived(mut self, input: std::option::Option<bool>) -> Self {
            self.is_archived = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Source server Tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Source server Tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Source server launched instance.</p>
        pub fn launched_instance(mut self, input: crate::model::LaunchedInstance) -> Self {
            self.launched_instance = Some(input);
            self
        }
        /// <p>Source server launched instance.</p>
        pub fn set_launched_instance(
            mut self,
            input: std::option::Option<crate::model::LaunchedInstance>,
        ) -> Self {
            self.launched_instance = input;
            self
        }
        /// <p>Source server data replication info.</p>
        pub fn data_replication_info(mut self, input: crate::model::DataReplicationInfo) -> Self {
            self.data_replication_info = Some(input);
            self
        }
        /// <p>Source server data replication info.</p>
        pub fn set_data_replication_info(
            mut self,
            input: std::option::Option<crate::model::DataReplicationInfo>,
        ) -> Self {
            self.data_replication_info = input;
            self
        }
        /// <p>Source server lifecycle state.</p>
        pub fn life_cycle(mut self, input: crate::model::LifeCycle) -> Self {
            self.life_cycle = Some(input);
            self
        }
        /// <p>Source server lifecycle state.</p>
        pub fn set_life_cycle(
            mut self,
            input: std::option::Option<crate::model::LifeCycle>,
        ) -> Self {
            self.life_cycle = input;
            self
        }
        /// <p>Source server properties.</p>
        pub fn source_properties(mut self, input: crate::model::SourceProperties) -> Self {
            self.source_properties = Some(input);
            self
        }
        /// <p>Source server properties.</p>
        pub fn set_source_properties(
            mut self,
            input: std::option::Option<crate::model::SourceProperties>,
        ) -> Self {
            self.source_properties = input;
            self
        }
        /// <p>Source server replication type.</p>
        pub fn replication_type(mut self, input: crate::model::ReplicationType) -> Self {
            self.replication_type = Some(input);
            self
        }
        /// <p>Source server replication type.</p>
        pub fn set_replication_type(
            mut self,
            input: std::option::Option<crate::model::ReplicationType>,
        ) -> Self {
            self.replication_type = input;
            self
        }
        /// <p>Source server vCenter client id.</p>
        pub fn vcenter_client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vcenter_client_id = Some(input.into());
            self
        }
        /// <p>Source server vCenter client id.</p>
        pub fn set_vcenter_client_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vcenter_client_id = input;
            self
        }
        /// Consumes the builder and constructs a [`MarkAsArchivedOutput`](crate::output::MarkAsArchivedOutput)
        pub fn build(self) -> crate::output::MarkAsArchivedOutput {
            crate::output::MarkAsArchivedOutput {
                source_server_id: self.source_server_id,
                arn: self.arn,
                is_archived: self.is_archived,
                tags: self.tags,
                launched_instance: self.launched_instance,
                data_replication_info: self.data_replication_info,
                life_cycle: self.life_cycle,
                source_properties: self.source_properties,
                replication_type: self.replication_type,
                vcenter_client_id: self.vcenter_client_id,
            }
        }
    }
}
impl MarkAsArchivedOutput {
    /// Creates a new builder-style object to manufacture [`MarkAsArchivedOutput`](crate::output::MarkAsArchivedOutput)
    pub fn builder() -> crate::output::mark_as_archived_output::Builder {
        crate::output::mark_as_archived_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetReplicationConfigurationOutput {
    /// <p>Replication Configuration Source Server ID.</p>
    pub source_server_id: std::option::Option<std::string::String>,
    /// <p>Replication Configuration name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Replication Configuration Staging Area subnet ID.</p>
    pub staging_area_subnet_id: std::option::Option<std::string::String>,
    /// <p>Replication Configuration associate default Application Migration Service Security Group.</p>
    pub associate_default_security_group: std::option::Option<bool>,
    /// <p>Replication Configuration Replication Server Security Group IDs.</p>
    pub replication_servers_security_groups_i_ds:
        std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Replication Configuration Replication Server instance type.</p>
    pub replication_server_instance_type: std::option::Option<std::string::String>,
    /// <p>Replication Configuration use Dedicated Replication Server.</p>
    pub use_dedicated_replication_server: std::option::Option<bool>,
    /// <p>Replication Configuration use default large Staging Disks.</p>
    pub default_large_staging_disk_type:
        std::option::Option<crate::model::ReplicationConfigurationDefaultLargeStagingDiskType>,
    /// <p>Replication Configuration replicated disks.</p>
    pub replicated_disks:
        std::option::Option<std::vec::Vec<crate::model::ReplicationConfigurationReplicatedDisk>>,
    /// <p>Replication Configuration EBS encryption.</p>
    pub ebs_encryption: std::option::Option<crate::model::ReplicationConfigurationEbsEncryption>,
    /// <p>Replication Configuration EBS encryption key ARN.</p>
    pub ebs_encryption_key_arn: std::option::Option<std::string::String>,
    /// <p>Replication Configuration set bandwidth throttling.</p>
    pub bandwidth_throttling: i64,
    /// <p>Replication Configuration data plane routing.</p>
    pub data_plane_routing:
        std::option::Option<crate::model::ReplicationConfigurationDataPlaneRouting>,
    /// <p>Replication Configuration create Public IP.</p>
    pub create_public_ip: std::option::Option<bool>,
    /// <p>Replication Configuration Staging Area tags.</p>
    pub staging_area_tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl GetReplicationConfigurationOutput {
    /// <p>Replication Configuration Source Server ID.</p>
    pub fn source_server_id(&self) -> std::option::Option<&str> {
        self.source_server_id.as_deref()
    }
    /// <p>Replication Configuration name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Replication Configuration Staging Area subnet ID.</p>
    pub fn staging_area_subnet_id(&self) -> std::option::Option<&str> {
        self.staging_area_subnet_id.as_deref()
    }
    /// <p>Replication Configuration associate default Application Migration Service Security Group.</p>
    pub fn associate_default_security_group(&self) -> std::option::Option<bool> {
        self.associate_default_security_group
    }
    /// <p>Replication Configuration Replication Server Security Group IDs.</p>
    pub fn replication_servers_security_groups_i_ds(
        &self,
    ) -> std::option::Option<&[std::string::String]> {
        self.replication_servers_security_groups_i_ds.as_deref()
    }
    /// <p>Replication Configuration Replication Server instance type.</p>
    pub fn replication_server_instance_type(&self) -> std::option::Option<&str> {
        self.replication_server_instance_type.as_deref()
    }
    /// <p>Replication Configuration use Dedicated Replication Server.</p>
    pub fn use_dedicated_replication_server(&self) -> std::option::Option<bool> {
        self.use_dedicated_replication_server
    }
    /// <p>Replication Configuration use default large Staging Disks.</p>
    pub fn default_large_staging_disk_type(
        &self,
    ) -> std::option::Option<&crate::model::ReplicationConfigurationDefaultLargeStagingDiskType>
    {
        self.default_large_staging_disk_type.as_ref()
    }
    /// <p>Replication Configuration replicated disks.</p>
    pub fn replicated_disks(
        &self,
    ) -> std::option::Option<&[crate::model::ReplicationConfigurationReplicatedDisk]> {
        self.replicated_disks.as_deref()
    }
    /// <p>Replication Configuration EBS encryption.</p>
    pub fn ebs_encryption(
        &self,
    ) -> std::option::Option<&crate::model::ReplicationConfigurationEbsEncryption> {
        self.ebs_encryption.as_ref()
    }
    /// <p>Replication Configuration EBS encryption key ARN.</p>
    pub fn ebs_encryption_key_arn(&self) -> std::option::Option<&str> {
        self.ebs_encryption_key_arn.as_deref()
    }
    /// <p>Replication Configuration set bandwidth throttling.</p>
    pub fn bandwidth_throttling(&self) -> i64 {
        self.bandwidth_throttling
    }
    /// <p>Replication Configuration data plane routing.</p>
    pub fn data_plane_routing(
        &self,
    ) -> std::option::Option<&crate::model::ReplicationConfigurationDataPlaneRouting> {
        self.data_plane_routing.as_ref()
    }
    /// <p>Replication Configuration create Public IP.</p>
    pub fn create_public_ip(&self) -> std::option::Option<bool> {
        self.create_public_ip
    }
    /// <p>Replication Configuration Staging Area tags.</p>
    pub fn staging_area_tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.staging_area_tags.as_ref()
    }
}
impl std::fmt::Debug for GetReplicationConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetReplicationConfigurationOutput");
        formatter.field("source_server_id", &self.source_server_id);
        formatter.field("name", &self.name);
        formatter.field("staging_area_subnet_id", &self.staging_area_subnet_id);
        formatter.field(
            "associate_default_security_group",
            &self.associate_default_security_group,
        );
        formatter.field(
            "replication_servers_security_groups_i_ds",
            &self.replication_servers_security_groups_i_ds,
        );
        formatter.field(
            "replication_server_instance_type",
            &self.replication_server_instance_type,
        );
        formatter.field(
            "use_dedicated_replication_server",
            &self.use_dedicated_replication_server,
        );
        formatter.field(
            "default_large_staging_disk_type",
            &self.default_large_staging_disk_type,
        );
        formatter.field("replicated_disks", &self.replicated_disks);
        formatter.field("ebs_encryption", &self.ebs_encryption);
        formatter.field("ebs_encryption_key_arn", &self.ebs_encryption_key_arn);
        formatter.field("bandwidth_throttling", &self.bandwidth_throttling);
        formatter.field("data_plane_routing", &self.data_plane_routing);
        formatter.field("create_public_ip", &self.create_public_ip);
        formatter.field("staging_area_tags", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`GetReplicationConfigurationOutput`](crate::output::GetReplicationConfigurationOutput)
pub mod get_replication_configuration_output {
    /// A builder for [`GetReplicationConfigurationOutput`](crate::output::GetReplicationConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_server_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) staging_area_subnet_id: std::option::Option<std::string::String>,
        pub(crate) associate_default_security_group: std::option::Option<bool>,
        pub(crate) replication_servers_security_groups_i_ds:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) replication_server_instance_type: std::option::Option<std::string::String>,
        pub(crate) use_dedicated_replication_server: std::option::Option<bool>,
        pub(crate) default_large_staging_disk_type:
            std::option::Option<crate::model::ReplicationConfigurationDefaultLargeStagingDiskType>,
        pub(crate) replicated_disks: std::option::Option<
            std::vec::Vec<crate::model::ReplicationConfigurationReplicatedDisk>,
        >,
        pub(crate) ebs_encryption:
            std::option::Option<crate::model::ReplicationConfigurationEbsEncryption>,
        pub(crate) ebs_encryption_key_arn: std::option::Option<std::string::String>,
        pub(crate) bandwidth_throttling: std::option::Option<i64>,
        pub(crate) data_plane_routing:
            std::option::Option<crate::model::ReplicationConfigurationDataPlaneRouting>,
        pub(crate) create_public_ip: std::option::Option<bool>,
        pub(crate) staging_area_tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>Replication Configuration Source Server ID.</p>
        pub fn source_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_server_id = Some(input.into());
            self
        }
        /// <p>Replication Configuration Source Server ID.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_server_id = input;
            self
        }
        /// <p>Replication Configuration name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Replication Configuration name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Replication Configuration Staging Area subnet ID.</p>
        pub fn staging_area_subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.staging_area_subnet_id = Some(input.into());
            self
        }
        /// <p>Replication Configuration Staging Area subnet ID.</p>
        pub fn set_staging_area_subnet_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.staging_area_subnet_id = input;
            self
        }
        /// <p>Replication Configuration associate default Application Migration Service Security Group.</p>
        pub fn associate_default_security_group(mut self, input: bool) -> Self {
            self.associate_default_security_group = Some(input);
            self
        }
        /// <p>Replication Configuration associate default Application Migration Service Security Group.</p>
        pub fn set_associate_default_security_group(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.associate_default_security_group = input;
            self
        }
        /// Appends an item to `replication_servers_security_groups_i_ds`.
        ///
        /// To override the contents of this collection use [`set_replication_servers_security_groups_i_ds`](Self::set_replication_servers_security_groups_i_ds).
        ///
        /// <p>Replication Configuration Replication Server Security Group IDs.</p>
        pub fn replication_servers_security_groups_i_ds(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self
                .replication_servers_security_groups_i_ds
                .unwrap_or_default();
            v.push(input.into());
            self.replication_servers_security_groups_i_ds = Some(v);
            self
        }
        /// <p>Replication Configuration Replication Server Security Group IDs.</p>
        pub fn set_replication_servers_security_groups_i_ds(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.replication_servers_security_groups_i_ds = input;
            self
        }
        /// <p>Replication Configuration Replication Server instance type.</p>
        pub fn replication_server_instance_type(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.replication_server_instance_type = Some(input.into());
            self
        }
        /// <p>Replication Configuration Replication Server instance type.</p>
        pub fn set_replication_server_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_server_instance_type = input;
            self
        }
        /// <p>Replication Configuration use Dedicated Replication Server.</p>
        pub fn use_dedicated_replication_server(mut self, input: bool) -> Self {
            self.use_dedicated_replication_server = Some(input);
            self
        }
        /// <p>Replication Configuration use Dedicated Replication Server.</p>
        pub fn set_use_dedicated_replication_server(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.use_dedicated_replication_server = input;
            self
        }
        /// <p>Replication Configuration use default large Staging Disks.</p>
        pub fn default_large_staging_disk_type(
            mut self,
            input: crate::model::ReplicationConfigurationDefaultLargeStagingDiskType,
        ) -> Self {
            self.default_large_staging_disk_type = Some(input);
            self
        }
        /// <p>Replication Configuration use default large Staging Disks.</p>
        pub fn set_default_large_staging_disk_type(
            mut self,
            input: std::option::Option<
                crate::model::ReplicationConfigurationDefaultLargeStagingDiskType,
            >,
        ) -> Self {
            self.default_large_staging_disk_type = input;
            self
        }
        /// Appends an item to `replicated_disks`.
        ///
        /// To override the contents of this collection use [`set_replicated_disks`](Self::set_replicated_disks).
        ///
        /// <p>Replication Configuration replicated disks.</p>
        pub fn replicated_disks(
            mut self,
            input: crate::model::ReplicationConfigurationReplicatedDisk,
        ) -> Self {
            let mut v = self.replicated_disks.unwrap_or_default();
            v.push(input);
            self.replicated_disks = Some(v);
            self
        }
        /// <p>Replication Configuration replicated disks.</p>
        pub fn set_replicated_disks(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ReplicationConfigurationReplicatedDisk>,
            >,
        ) -> Self {
            self.replicated_disks = input;
            self
        }
        /// <p>Replication Configuration EBS encryption.</p>
        pub fn ebs_encryption(
            mut self,
            input: crate::model::ReplicationConfigurationEbsEncryption,
        ) -> Self {
            self.ebs_encryption = Some(input);
            self
        }
        /// <p>Replication Configuration EBS encryption.</p>
        pub fn set_ebs_encryption(
            mut self,
            input: std::option::Option<crate::model::ReplicationConfigurationEbsEncryption>,
        ) -> Self {
            self.ebs_encryption = input;
            self
        }
        /// <p>Replication Configuration EBS encryption key ARN.</p>
        pub fn ebs_encryption_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.ebs_encryption_key_arn = Some(input.into());
            self
        }
        /// <p>Replication Configuration EBS encryption key ARN.</p>
        pub fn set_ebs_encryption_key_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ebs_encryption_key_arn = input;
            self
        }
        /// <p>Replication Configuration set bandwidth throttling.</p>
        pub fn bandwidth_throttling(mut self, input: i64) -> Self {
            self.bandwidth_throttling = Some(input);
            self
        }
        /// <p>Replication Configuration set bandwidth throttling.</p>
        pub fn set_bandwidth_throttling(mut self, input: std::option::Option<i64>) -> Self {
            self.bandwidth_throttling = input;
            self
        }
        /// <p>Replication Configuration data plane routing.</p>
        pub fn data_plane_routing(
            mut self,
            input: crate::model::ReplicationConfigurationDataPlaneRouting,
        ) -> Self {
            self.data_plane_routing = Some(input);
            self
        }
        /// <p>Replication Configuration data plane routing.</p>
        pub fn set_data_plane_routing(
            mut self,
            input: std::option::Option<crate::model::ReplicationConfigurationDataPlaneRouting>,
        ) -> Self {
            self.data_plane_routing = input;
            self
        }
        /// <p>Replication Configuration create Public IP.</p>
        pub fn create_public_ip(mut self, input: bool) -> Self {
            self.create_public_ip = Some(input);
            self
        }
        /// <p>Replication Configuration create Public IP.</p>
        pub fn set_create_public_ip(mut self, input: std::option::Option<bool>) -> Self {
            self.create_public_ip = input;
            self
        }
        /// Adds a key-value pair to `staging_area_tags`.
        ///
        /// To override the contents of this collection use [`set_staging_area_tags`](Self::set_staging_area_tags).
        ///
        /// <p>Replication Configuration Staging Area tags.</p>
        pub fn staging_area_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.staging_area_tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.staging_area_tags = Some(hash_map);
            self
        }
        /// <p>Replication Configuration Staging Area tags.</p>
        pub fn set_staging_area_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.staging_area_tags = input;
            self
        }
        /// Consumes the builder and constructs a [`GetReplicationConfigurationOutput`](crate::output::GetReplicationConfigurationOutput)
        pub fn build(self) -> crate::output::GetReplicationConfigurationOutput {
            crate::output::GetReplicationConfigurationOutput {
                source_server_id: self.source_server_id,
                name: self.name,
                staging_area_subnet_id: self.staging_area_subnet_id,
                associate_default_security_group: self.associate_default_security_group,
                replication_servers_security_groups_i_ds: self
                    .replication_servers_security_groups_i_ds,
                replication_server_instance_type: self.replication_server_instance_type,
                use_dedicated_replication_server: self.use_dedicated_replication_server,
                default_large_staging_disk_type: self.default_large_staging_disk_type,
                replicated_disks: self.replicated_disks,
                ebs_encryption: self.ebs_encryption,
                ebs_encryption_key_arn: self.ebs_encryption_key_arn,
                bandwidth_throttling: self.bandwidth_throttling.unwrap_or_default(),
                data_plane_routing: self.data_plane_routing,
                create_public_ip: self.create_public_ip,
                staging_area_tags: self.staging_area_tags,
            }
        }
    }
}
impl GetReplicationConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`GetReplicationConfigurationOutput`](crate::output::GetReplicationConfigurationOutput)
    pub fn builder() -> crate::output::get_replication_configuration_output::Builder {
        crate::output::get_replication_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetLaunchConfigurationOutput {
    /// <p>Launch configuration Source Server ID.</p>
    pub source_server_id: std::option::Option<std::string::String>,
    /// <p>Launch configuration name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Launch configuration EC2 Launch template ID.</p>
    pub ec2_launch_template_id: std::option::Option<std::string::String>,
    /// <p>Launch disposition for launch configuration.</p>
    pub launch_disposition: std::option::Option<crate::model::LaunchDisposition>,
    /// <p>Launch configuration Target instance type right sizing method.</p>
    pub target_instance_type_right_sizing_method:
        std::option::Option<crate::model::TargetInstanceTypeRightSizingMethod>,
    /// <p>Copy Private IP during Launch Configuration.</p>
    pub copy_private_ip: std::option::Option<bool>,
    /// <p>Copy Tags during Launch Configuration.</p>
    pub copy_tags: std::option::Option<bool>,
    /// <p>Launch configuration OS licensing.</p>
    pub licensing: std::option::Option<crate::model::Licensing>,
    /// <p>Launch configuration boot mode.</p>
    pub boot_mode: std::option::Option<crate::model::BootMode>,
}
impl GetLaunchConfigurationOutput {
    /// <p>Launch configuration Source Server ID.</p>
    pub fn source_server_id(&self) -> std::option::Option<&str> {
        self.source_server_id.as_deref()
    }
    /// <p>Launch configuration name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Launch configuration EC2 Launch template ID.</p>
    pub fn ec2_launch_template_id(&self) -> std::option::Option<&str> {
        self.ec2_launch_template_id.as_deref()
    }
    /// <p>Launch disposition for launch configuration.</p>
    pub fn launch_disposition(&self) -> std::option::Option<&crate::model::LaunchDisposition> {
        self.launch_disposition.as_ref()
    }
    /// <p>Launch configuration Target instance type right sizing method.</p>
    pub fn target_instance_type_right_sizing_method(
        &self,
    ) -> std::option::Option<&crate::model::TargetInstanceTypeRightSizingMethod> {
        self.target_instance_type_right_sizing_method.as_ref()
    }
    /// <p>Copy Private IP during Launch Configuration.</p>
    pub fn copy_private_ip(&self) -> std::option::Option<bool> {
        self.copy_private_ip
    }
    /// <p>Copy Tags during Launch Configuration.</p>
    pub fn copy_tags(&self) -> std::option::Option<bool> {
        self.copy_tags
    }
    /// <p>Launch configuration OS licensing.</p>
    pub fn licensing(&self) -> std::option::Option<&crate::model::Licensing> {
        self.licensing.as_ref()
    }
    /// <p>Launch configuration boot mode.</p>
    pub fn boot_mode(&self) -> std::option::Option<&crate::model::BootMode> {
        self.boot_mode.as_ref()
    }
}
impl std::fmt::Debug for GetLaunchConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetLaunchConfigurationOutput");
        formatter.field("source_server_id", &self.source_server_id);
        formatter.field("name", &self.name);
        formatter.field("ec2_launch_template_id", &self.ec2_launch_template_id);
        formatter.field("launch_disposition", &self.launch_disposition);
        formatter.field(
            "target_instance_type_right_sizing_method",
            &self.target_instance_type_right_sizing_method,
        );
        formatter.field("copy_private_ip", &self.copy_private_ip);
        formatter.field("copy_tags", &self.copy_tags);
        formatter.field("licensing", &self.licensing);
        formatter.field("boot_mode", &self.boot_mode);
        formatter.finish()
    }
}
/// See [`GetLaunchConfigurationOutput`](crate::output::GetLaunchConfigurationOutput)
pub mod get_launch_configuration_output {
    /// A builder for [`GetLaunchConfigurationOutput`](crate::output::GetLaunchConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_server_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) ec2_launch_template_id: std::option::Option<std::string::String>,
        pub(crate) launch_disposition: std::option::Option<crate::model::LaunchDisposition>,
        pub(crate) target_instance_type_right_sizing_method:
            std::option::Option<crate::model::TargetInstanceTypeRightSizingMethod>,
        pub(crate) copy_private_ip: std::option::Option<bool>,
        pub(crate) copy_tags: std::option::Option<bool>,
        pub(crate) licensing: std::option::Option<crate::model::Licensing>,
        pub(crate) boot_mode: std::option::Option<crate::model::BootMode>,
    }
    impl Builder {
        /// <p>Launch configuration Source Server ID.</p>
        pub fn source_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_server_id = Some(input.into());
            self
        }
        /// <p>Launch configuration Source Server ID.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_server_id = input;
            self
        }
        /// <p>Launch configuration name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Launch configuration name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Launch configuration EC2 Launch template ID.</p>
        pub fn ec2_launch_template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ec2_launch_template_id = Some(input.into());
            self
        }
        /// <p>Launch configuration EC2 Launch template ID.</p>
        pub fn set_ec2_launch_template_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ec2_launch_template_id = input;
            self
        }
        /// <p>Launch disposition for launch configuration.</p>
        pub fn launch_disposition(mut self, input: crate::model::LaunchDisposition) -> Self {
            self.launch_disposition = Some(input);
            self
        }
        /// <p>Launch disposition for launch configuration.</p>
        pub fn set_launch_disposition(
            mut self,
            input: std::option::Option<crate::model::LaunchDisposition>,
        ) -> Self {
            self.launch_disposition = input;
            self
        }
        /// <p>Launch configuration Target instance type right sizing method.</p>
        pub fn target_instance_type_right_sizing_method(
            mut self,
            input: crate::model::TargetInstanceTypeRightSizingMethod,
        ) -> Self {
            self.target_instance_type_right_sizing_method = Some(input);
            self
        }
        /// <p>Launch configuration Target instance type right sizing method.</p>
        pub fn set_target_instance_type_right_sizing_method(
            mut self,
            input: std::option::Option<crate::model::TargetInstanceTypeRightSizingMethod>,
        ) -> Self {
            self.target_instance_type_right_sizing_method = input;
            self
        }
        /// <p>Copy Private IP during Launch Configuration.</p>
        pub fn copy_private_ip(mut self, input: bool) -> Self {
            self.copy_private_ip = Some(input);
            self
        }
        /// <p>Copy Private IP during Launch Configuration.</p>
        pub fn set_copy_private_ip(mut self, input: std::option::Option<bool>) -> Self {
            self.copy_private_ip = input;
            self
        }
        /// <p>Copy Tags during Launch Configuration.</p>
        pub fn copy_tags(mut self, input: bool) -> Self {
            self.copy_tags = Some(input);
            self
        }
        /// <p>Copy Tags during Launch Configuration.</p>
        pub fn set_copy_tags(mut self, input: std::option::Option<bool>) -> Self {
            self.copy_tags = input;
            self
        }
        /// <p>Launch configuration OS licensing.</p>
        pub fn licensing(mut self, input: crate::model::Licensing) -> Self {
            self.licensing = Some(input);
            self
        }
        /// <p>Launch configuration OS licensing.</p>
        pub fn set_licensing(
            mut self,
            input: std::option::Option<crate::model::Licensing>,
        ) -> Self {
            self.licensing = input;
            self
        }
        /// <p>Launch configuration boot mode.</p>
        pub fn boot_mode(mut self, input: crate::model::BootMode) -> Self {
            self.boot_mode = Some(input);
            self
        }
        /// <p>Launch configuration boot mode.</p>
        pub fn set_boot_mode(mut self, input: std::option::Option<crate::model::BootMode>) -> Self {
            self.boot_mode = input;
            self
        }
        /// Consumes the builder and constructs a [`GetLaunchConfigurationOutput`](crate::output::GetLaunchConfigurationOutput)
        pub fn build(self) -> crate::output::GetLaunchConfigurationOutput {
            crate::output::GetLaunchConfigurationOutput {
                source_server_id: self.source_server_id,
                name: self.name,
                ec2_launch_template_id: self.ec2_launch_template_id,
                launch_disposition: self.launch_disposition,
                target_instance_type_right_sizing_method: self
                    .target_instance_type_right_sizing_method,
                copy_private_ip: self.copy_private_ip,
                copy_tags: self.copy_tags,
                licensing: self.licensing,
                boot_mode: self.boot_mode,
            }
        }
    }
}
impl GetLaunchConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`GetLaunchConfigurationOutput`](crate::output::GetLaunchConfigurationOutput)
    pub fn builder() -> crate::output::get_launch_configuration_output::Builder {
        crate::output::get_launch_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FinalizeCutoverOutput {
    /// <p>Source server ID.</p>
    pub source_server_id: std::option::Option<std::string::String>,
    /// <p>Source server ARN.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>Source server archived status.</p>
    pub is_archived: std::option::Option<bool>,
    /// <p>Source server Tags.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Source server launched instance.</p>
    pub launched_instance: std::option::Option<crate::model::LaunchedInstance>,
    /// <p>Source server data replication info.</p>
    pub data_replication_info: std::option::Option<crate::model::DataReplicationInfo>,
    /// <p>Source server lifecycle state.</p>
    pub life_cycle: std::option::Option<crate::model::LifeCycle>,
    /// <p>Source server properties.</p>
    pub source_properties: std::option::Option<crate::model::SourceProperties>,
    /// <p>Source server replication type.</p>
    pub replication_type: std::option::Option<crate::model::ReplicationType>,
    /// <p>Source server vCenter client id.</p>
    pub vcenter_client_id: std::option::Option<std::string::String>,
}
impl FinalizeCutoverOutput {
    /// <p>Source server ID.</p>
    pub fn source_server_id(&self) -> std::option::Option<&str> {
        self.source_server_id.as_deref()
    }
    /// <p>Source server ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>Source server archived status.</p>
    pub fn is_archived(&self) -> std::option::Option<bool> {
        self.is_archived
    }
    /// <p>Source server Tags.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>Source server launched instance.</p>
    pub fn launched_instance(&self) -> std::option::Option<&crate::model::LaunchedInstance> {
        self.launched_instance.as_ref()
    }
    /// <p>Source server data replication info.</p>
    pub fn data_replication_info(&self) -> std::option::Option<&crate::model::DataReplicationInfo> {
        self.data_replication_info.as_ref()
    }
    /// <p>Source server lifecycle state.</p>
    pub fn life_cycle(&self) -> std::option::Option<&crate::model::LifeCycle> {
        self.life_cycle.as_ref()
    }
    /// <p>Source server properties.</p>
    pub fn source_properties(&self) -> std::option::Option<&crate::model::SourceProperties> {
        self.source_properties.as_ref()
    }
    /// <p>Source server replication type.</p>
    pub fn replication_type(&self) -> std::option::Option<&crate::model::ReplicationType> {
        self.replication_type.as_ref()
    }
    /// <p>Source server vCenter client id.</p>
    pub fn vcenter_client_id(&self) -> std::option::Option<&str> {
        self.vcenter_client_id.as_deref()
    }
}
impl std::fmt::Debug for FinalizeCutoverOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FinalizeCutoverOutput");
        formatter.field("source_server_id", &self.source_server_id);
        formatter.field("arn", &self.arn);
        formatter.field("is_archived", &self.is_archived);
        formatter.field("tags", &"*** Sensitive Data Redacted ***");
        formatter.field("launched_instance", &self.launched_instance);
        formatter.field("data_replication_info", &self.data_replication_info);
        formatter.field("life_cycle", &self.life_cycle);
        formatter.field("source_properties", &self.source_properties);
        formatter.field("replication_type", &self.replication_type);
        formatter.field("vcenter_client_id", &self.vcenter_client_id);
        formatter.finish()
    }
}
/// See [`FinalizeCutoverOutput`](crate::output::FinalizeCutoverOutput)
pub mod finalize_cutover_output {
    /// A builder for [`FinalizeCutoverOutput`](crate::output::FinalizeCutoverOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_server_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) is_archived: std::option::Option<bool>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) launched_instance: std::option::Option<crate::model::LaunchedInstance>,
        pub(crate) data_replication_info: std::option::Option<crate::model::DataReplicationInfo>,
        pub(crate) life_cycle: std::option::Option<crate::model::LifeCycle>,
        pub(crate) source_properties: std::option::Option<crate::model::SourceProperties>,
        pub(crate) replication_type: std::option::Option<crate::model::ReplicationType>,
        pub(crate) vcenter_client_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Source server ID.</p>
        pub fn source_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_server_id = Some(input.into());
            self
        }
        /// <p>Source server ID.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_server_id = input;
            self
        }
        /// <p>Source server ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>Source server ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>Source server archived status.</p>
        pub fn is_archived(mut self, input: bool) -> Self {
            self.is_archived = Some(input);
            self
        }
        /// <p>Source server archived status.</p>
        pub fn set_is_archived(mut self, input: std::option::Option<bool>) -> Self {
            self.is_archived = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Source server Tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Source server Tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Source server launched instance.</p>
        pub fn launched_instance(mut self, input: crate::model::LaunchedInstance) -> Self {
            self.launched_instance = Some(input);
            self
        }
        /// <p>Source server launched instance.</p>
        pub fn set_launched_instance(
            mut self,
            input: std::option::Option<crate::model::LaunchedInstance>,
        ) -> Self {
            self.launched_instance = input;
            self
        }
        /// <p>Source server data replication info.</p>
        pub fn data_replication_info(mut self, input: crate::model::DataReplicationInfo) -> Self {
            self.data_replication_info = Some(input);
            self
        }
        /// <p>Source server data replication info.</p>
        pub fn set_data_replication_info(
            mut self,
            input: std::option::Option<crate::model::DataReplicationInfo>,
        ) -> Self {
            self.data_replication_info = input;
            self
        }
        /// <p>Source server lifecycle state.</p>
        pub fn life_cycle(mut self, input: crate::model::LifeCycle) -> Self {
            self.life_cycle = Some(input);
            self
        }
        /// <p>Source server lifecycle state.</p>
        pub fn set_life_cycle(
            mut self,
            input: std::option::Option<crate::model::LifeCycle>,
        ) -> Self {
            self.life_cycle = input;
            self
        }
        /// <p>Source server properties.</p>
        pub fn source_properties(mut self, input: crate::model::SourceProperties) -> Self {
            self.source_properties = Some(input);
            self
        }
        /// <p>Source server properties.</p>
        pub fn set_source_properties(
            mut self,
            input: std::option::Option<crate::model::SourceProperties>,
        ) -> Self {
            self.source_properties = input;
            self
        }
        /// <p>Source server replication type.</p>
        pub fn replication_type(mut self, input: crate::model::ReplicationType) -> Self {
            self.replication_type = Some(input);
            self
        }
        /// <p>Source server replication type.</p>
        pub fn set_replication_type(
            mut self,
            input: std::option::Option<crate::model::ReplicationType>,
        ) -> Self {
            self.replication_type = input;
            self
        }
        /// <p>Source server vCenter client id.</p>
        pub fn vcenter_client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vcenter_client_id = Some(input.into());
            self
        }
        /// <p>Source server vCenter client id.</p>
        pub fn set_vcenter_client_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vcenter_client_id = input;
            self
        }
        /// Consumes the builder and constructs a [`FinalizeCutoverOutput`](crate::output::FinalizeCutoverOutput)
        pub fn build(self) -> crate::output::FinalizeCutoverOutput {
            crate::output::FinalizeCutoverOutput {
                source_server_id: self.source_server_id,
                arn: self.arn,
                is_archived: self.is_archived,
                tags: self.tags,
                launched_instance: self.launched_instance,
                data_replication_info: self.data_replication_info,
                life_cycle: self.life_cycle,
                source_properties: self.source_properties,
                replication_type: self.replication_type,
                vcenter_client_id: self.vcenter_client_id,
            }
        }
    }
}
impl FinalizeCutoverOutput {
    /// Creates a new builder-style object to manufacture [`FinalizeCutoverOutput`](crate::output::FinalizeCutoverOutput)
    pub fn builder() -> crate::output::finalize_cutover_output::Builder {
        crate::output::finalize_cutover_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisconnectFromServiceOutput {
    /// <p>Source server ID.</p>
    pub source_server_id: std::option::Option<std::string::String>,
    /// <p>Source server ARN.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>Source server archived status.</p>
    pub is_archived: std::option::Option<bool>,
    /// <p>Source server Tags.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Source server launched instance.</p>
    pub launched_instance: std::option::Option<crate::model::LaunchedInstance>,
    /// <p>Source server data replication info.</p>
    pub data_replication_info: std::option::Option<crate::model::DataReplicationInfo>,
    /// <p>Source server lifecycle state.</p>
    pub life_cycle: std::option::Option<crate::model::LifeCycle>,
    /// <p>Source server properties.</p>
    pub source_properties: std::option::Option<crate::model::SourceProperties>,
    /// <p>Source server replication type.</p>
    pub replication_type: std::option::Option<crate::model::ReplicationType>,
    /// <p>Source server vCenter client id.</p>
    pub vcenter_client_id: std::option::Option<std::string::String>,
}
impl DisconnectFromServiceOutput {
    /// <p>Source server ID.</p>
    pub fn source_server_id(&self) -> std::option::Option<&str> {
        self.source_server_id.as_deref()
    }
    /// <p>Source server ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>Source server archived status.</p>
    pub fn is_archived(&self) -> std::option::Option<bool> {
        self.is_archived
    }
    /// <p>Source server Tags.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>Source server launched instance.</p>
    pub fn launched_instance(&self) -> std::option::Option<&crate::model::LaunchedInstance> {
        self.launched_instance.as_ref()
    }
    /// <p>Source server data replication info.</p>
    pub fn data_replication_info(&self) -> std::option::Option<&crate::model::DataReplicationInfo> {
        self.data_replication_info.as_ref()
    }
    /// <p>Source server lifecycle state.</p>
    pub fn life_cycle(&self) -> std::option::Option<&crate::model::LifeCycle> {
        self.life_cycle.as_ref()
    }
    /// <p>Source server properties.</p>
    pub fn source_properties(&self) -> std::option::Option<&crate::model::SourceProperties> {
        self.source_properties.as_ref()
    }
    /// <p>Source server replication type.</p>
    pub fn replication_type(&self) -> std::option::Option<&crate::model::ReplicationType> {
        self.replication_type.as_ref()
    }
    /// <p>Source server vCenter client id.</p>
    pub fn vcenter_client_id(&self) -> std::option::Option<&str> {
        self.vcenter_client_id.as_deref()
    }
}
impl std::fmt::Debug for DisconnectFromServiceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisconnectFromServiceOutput");
        formatter.field("source_server_id", &self.source_server_id);
        formatter.field("arn", &self.arn);
        formatter.field("is_archived", &self.is_archived);
        formatter.field("tags", &"*** Sensitive Data Redacted ***");
        formatter.field("launched_instance", &self.launched_instance);
        formatter.field("data_replication_info", &self.data_replication_info);
        formatter.field("life_cycle", &self.life_cycle);
        formatter.field("source_properties", &self.source_properties);
        formatter.field("replication_type", &self.replication_type);
        formatter.field("vcenter_client_id", &self.vcenter_client_id);
        formatter.finish()
    }
}
/// See [`DisconnectFromServiceOutput`](crate::output::DisconnectFromServiceOutput)
pub mod disconnect_from_service_output {
    /// A builder for [`DisconnectFromServiceOutput`](crate::output::DisconnectFromServiceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_server_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) is_archived: std::option::Option<bool>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) launched_instance: std::option::Option<crate::model::LaunchedInstance>,
        pub(crate) data_replication_info: std::option::Option<crate::model::DataReplicationInfo>,
        pub(crate) life_cycle: std::option::Option<crate::model::LifeCycle>,
        pub(crate) source_properties: std::option::Option<crate::model::SourceProperties>,
        pub(crate) replication_type: std::option::Option<crate::model::ReplicationType>,
        pub(crate) vcenter_client_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Source server ID.</p>
        pub fn source_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_server_id = Some(input.into());
            self
        }
        /// <p>Source server ID.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_server_id = input;
            self
        }
        /// <p>Source server ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>Source server ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>Source server archived status.</p>
        pub fn is_archived(mut self, input: bool) -> Self {
            self.is_archived = Some(input);
            self
        }
        /// <p>Source server archived status.</p>
        pub fn set_is_archived(mut self, input: std::option::Option<bool>) -> Self {
            self.is_archived = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Source server Tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Source server Tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Source server launched instance.</p>
        pub fn launched_instance(mut self, input: crate::model::LaunchedInstance) -> Self {
            self.launched_instance = Some(input);
            self
        }
        /// <p>Source server launched instance.</p>
        pub fn set_launched_instance(
            mut self,
            input: std::option::Option<crate::model::LaunchedInstance>,
        ) -> Self {
            self.launched_instance = input;
            self
        }
        /// <p>Source server data replication info.</p>
        pub fn data_replication_info(mut self, input: crate::model::DataReplicationInfo) -> Self {
            self.data_replication_info = Some(input);
            self
        }
        /// <p>Source server data replication info.</p>
        pub fn set_data_replication_info(
            mut self,
            input: std::option::Option<crate::model::DataReplicationInfo>,
        ) -> Self {
            self.data_replication_info = input;
            self
        }
        /// <p>Source server lifecycle state.</p>
        pub fn life_cycle(mut self, input: crate::model::LifeCycle) -> Self {
            self.life_cycle = Some(input);
            self
        }
        /// <p>Source server lifecycle state.</p>
        pub fn set_life_cycle(
            mut self,
            input: std::option::Option<crate::model::LifeCycle>,
        ) -> Self {
            self.life_cycle = input;
            self
        }
        /// <p>Source server properties.</p>
        pub fn source_properties(mut self, input: crate::model::SourceProperties) -> Self {
            self.source_properties = Some(input);
            self
        }
        /// <p>Source server properties.</p>
        pub fn set_source_properties(
            mut self,
            input: std::option::Option<crate::model::SourceProperties>,
        ) -> Self {
            self.source_properties = input;
            self
        }
        /// <p>Source server replication type.</p>
        pub fn replication_type(mut self, input: crate::model::ReplicationType) -> Self {
            self.replication_type = Some(input);
            self
        }
        /// <p>Source server replication type.</p>
        pub fn set_replication_type(
            mut self,
            input: std::option::Option<crate::model::ReplicationType>,
        ) -> Self {
            self.replication_type = input;
            self
        }
        /// <p>Source server vCenter client id.</p>
        pub fn vcenter_client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vcenter_client_id = Some(input.into());
            self
        }
        /// <p>Source server vCenter client id.</p>
        pub fn set_vcenter_client_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vcenter_client_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DisconnectFromServiceOutput`](crate::output::DisconnectFromServiceOutput)
        pub fn build(self) -> crate::output::DisconnectFromServiceOutput {
            crate::output::DisconnectFromServiceOutput {
                source_server_id: self.source_server_id,
                arn: self.arn,
                is_archived: self.is_archived,
                tags: self.tags,
                launched_instance: self.launched_instance,
                data_replication_info: self.data_replication_info,
                life_cycle: self.life_cycle,
                source_properties: self.source_properties,
                replication_type: self.replication_type,
                vcenter_client_id: self.vcenter_client_id,
            }
        }
    }
}
impl DisconnectFromServiceOutput {
    /// Creates a new builder-style object to manufacture [`DisconnectFromServiceOutput`](crate::output::DisconnectFromServiceOutput)
    pub fn builder() -> crate::output::disconnect_from_service_output::Builder {
        crate::output::disconnect_from_service_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChangeServerLifeCycleStateOutput {
    /// <p>Source server ID.</p>
    pub source_server_id: std::option::Option<std::string::String>,
    /// <p>Source server ARN.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>Source server archived status.</p>
    pub is_archived: std::option::Option<bool>,
    /// <p>Source server Tags.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Source server launched instance.</p>
    pub launched_instance: std::option::Option<crate::model::LaunchedInstance>,
    /// <p>Source server data replication info.</p>
    pub data_replication_info: std::option::Option<crate::model::DataReplicationInfo>,
    /// <p>Source server lifecycle state.</p>
    pub life_cycle: std::option::Option<crate::model::LifeCycle>,
    /// <p>Source server properties.</p>
    pub source_properties: std::option::Option<crate::model::SourceProperties>,
    /// <p>Source server replication type.</p>
    pub replication_type: std::option::Option<crate::model::ReplicationType>,
    /// <p>Source server vCenter client id.</p>
    pub vcenter_client_id: std::option::Option<std::string::String>,
}
impl ChangeServerLifeCycleStateOutput {
    /// <p>Source server ID.</p>
    pub fn source_server_id(&self) -> std::option::Option<&str> {
        self.source_server_id.as_deref()
    }
    /// <p>Source server ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>Source server archived status.</p>
    pub fn is_archived(&self) -> std::option::Option<bool> {
        self.is_archived
    }
    /// <p>Source server Tags.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>Source server launched instance.</p>
    pub fn launched_instance(&self) -> std::option::Option<&crate::model::LaunchedInstance> {
        self.launched_instance.as_ref()
    }
    /// <p>Source server data replication info.</p>
    pub fn data_replication_info(&self) -> std::option::Option<&crate::model::DataReplicationInfo> {
        self.data_replication_info.as_ref()
    }
    /// <p>Source server lifecycle state.</p>
    pub fn life_cycle(&self) -> std::option::Option<&crate::model::LifeCycle> {
        self.life_cycle.as_ref()
    }
    /// <p>Source server properties.</p>
    pub fn source_properties(&self) -> std::option::Option<&crate::model::SourceProperties> {
        self.source_properties.as_ref()
    }
    /// <p>Source server replication type.</p>
    pub fn replication_type(&self) -> std::option::Option<&crate::model::ReplicationType> {
        self.replication_type.as_ref()
    }
    /// <p>Source server vCenter client id.</p>
    pub fn vcenter_client_id(&self) -> std::option::Option<&str> {
        self.vcenter_client_id.as_deref()
    }
}
impl std::fmt::Debug for ChangeServerLifeCycleStateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChangeServerLifeCycleStateOutput");
        formatter.field("source_server_id", &self.source_server_id);
        formatter.field("arn", &self.arn);
        formatter.field("is_archived", &self.is_archived);
        formatter.field("tags", &"*** Sensitive Data Redacted ***");
        formatter.field("launched_instance", &self.launched_instance);
        formatter.field("data_replication_info", &self.data_replication_info);
        formatter.field("life_cycle", &self.life_cycle);
        formatter.field("source_properties", &self.source_properties);
        formatter.field("replication_type", &self.replication_type);
        formatter.field("vcenter_client_id", &self.vcenter_client_id);
        formatter.finish()
    }
}
/// See [`ChangeServerLifeCycleStateOutput`](crate::output::ChangeServerLifeCycleStateOutput)
pub mod change_server_life_cycle_state_output {
    /// A builder for [`ChangeServerLifeCycleStateOutput`](crate::output::ChangeServerLifeCycleStateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_server_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) is_archived: std::option::Option<bool>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) launched_instance: std::option::Option<crate::model::LaunchedInstance>,
        pub(crate) data_replication_info: std::option::Option<crate::model::DataReplicationInfo>,
        pub(crate) life_cycle: std::option::Option<crate::model::LifeCycle>,
        pub(crate) source_properties: std::option::Option<crate::model::SourceProperties>,
        pub(crate) replication_type: std::option::Option<crate::model::ReplicationType>,
        pub(crate) vcenter_client_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Source server ID.</p>
        pub fn source_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_server_id = Some(input.into());
            self
        }
        /// <p>Source server ID.</p>
        pub fn set_source_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_server_id = input;
            self
        }
        /// <p>Source server ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>Source server ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>Source server archived status.</p>
        pub fn is_archived(mut self, input: bool) -> Self {
            self.is_archived = Some(input);
            self
        }
        /// <p>Source server archived status.</p>
        pub fn set_is_archived(mut self, input: std::option::Option<bool>) -> Self {
            self.is_archived = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Source server Tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Source server Tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Source server launched instance.</p>
        pub fn launched_instance(mut self, input: crate::model::LaunchedInstance) -> Self {
            self.launched_instance = Some(input);
            self
        }
        /// <p>Source server launched instance.</p>
        pub fn set_launched_instance(
            mut self,
            input: std::option::Option<crate::model::LaunchedInstance>,
        ) -> Self {
            self.launched_instance = input;
            self
        }
        /// <p>Source server data replication info.</p>
        pub fn data_replication_info(mut self, input: crate::model::DataReplicationInfo) -> Self {
            self.data_replication_info = Some(input);
            self
        }
        /// <p>Source server data replication info.</p>
        pub fn set_data_replication_info(
            mut self,
            input: std::option::Option<crate::model::DataReplicationInfo>,
        ) -> Self {
            self.data_replication_info = input;
            self
        }
        /// <p>Source server lifecycle state.</p>
        pub fn life_cycle(mut self, input: crate::model::LifeCycle) -> Self {
            self.life_cycle = Some(input);
            self
        }
        /// <p>Source server lifecycle state.</p>
        pub fn set_life_cycle(
            mut self,
            input: std::option::Option<crate::model::LifeCycle>,
        ) -> Self {
            self.life_cycle = input;
            self
        }
        /// <p>Source server properties.</p>
        pub fn source_properties(mut self, input: crate::model::SourceProperties) -> Self {
            self.source_properties = Some(input);
            self
        }
        /// <p>Source server properties.</p>
        pub fn set_source_properties(
            mut self,
            input: std::option::Option<crate::model::SourceProperties>,
        ) -> Self {
            self.source_properties = input;
            self
        }
        /// <p>Source server replication type.</p>
        pub fn replication_type(mut self, input: crate::model::ReplicationType) -> Self {
            self.replication_type = Some(input);
            self
        }
        /// <p>Source server replication type.</p>
        pub fn set_replication_type(
            mut self,
            input: std::option::Option<crate::model::ReplicationType>,
        ) -> Self {
            self.replication_type = input;
            self
        }
        /// <p>Source server vCenter client id.</p>
        pub fn vcenter_client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vcenter_client_id = Some(input.into());
            self
        }
        /// <p>Source server vCenter client id.</p>
        pub fn set_vcenter_client_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vcenter_client_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ChangeServerLifeCycleStateOutput`](crate::output::ChangeServerLifeCycleStateOutput)
        pub fn build(self) -> crate::output::ChangeServerLifeCycleStateOutput {
            crate::output::ChangeServerLifeCycleStateOutput {
                source_server_id: self.source_server_id,
                arn: self.arn,
                is_archived: self.is_archived,
                tags: self.tags,
                launched_instance: self.launched_instance,
                data_replication_info: self.data_replication_info,
                life_cycle: self.life_cycle,
                source_properties: self.source_properties,
                replication_type: self.replication_type,
                vcenter_client_id: self.vcenter_client_id,
            }
        }
    }
}
impl ChangeServerLifeCycleStateOutput {
    /// Creates a new builder-style object to manufacture [`ChangeServerLifeCycleStateOutput`](crate::output::ChangeServerLifeCycleStateOutput)
    pub fn builder() -> crate::output::change_server_life_cycle_state_output::Builder {
        crate::output::change_server_life_cycle_state_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TerminateTargetInstancesOutput {
    /// <p>Terminate Target instance Job response.</p>
    pub job: std::option::Option<crate::model::Job>,
}
impl TerminateTargetInstancesOutput {
    /// <p>Terminate Target instance Job response.</p>
    pub fn job(&self) -> std::option::Option<&crate::model::Job> {
        self.job.as_ref()
    }
}
impl std::fmt::Debug for TerminateTargetInstancesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TerminateTargetInstancesOutput");
        formatter.field("job", &self.job);
        formatter.finish()
    }
}
/// See [`TerminateTargetInstancesOutput`](crate::output::TerminateTargetInstancesOutput)
pub mod terminate_target_instances_output {
    /// A builder for [`TerminateTargetInstancesOutput`](crate::output::TerminateTargetInstancesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job: std::option::Option<crate::model::Job>,
    }
    impl Builder {
        /// <p>Terminate Target instance Job response.</p>
        pub fn job(mut self, input: crate::model::Job) -> Self {
            self.job = Some(input);
            self
        }
        /// <p>Terminate Target instance Job response.</p>
        pub fn set_job(mut self, input: std::option::Option<crate::model::Job>) -> Self {
            self.job = input;
            self
        }
        /// Consumes the builder and constructs a [`TerminateTargetInstancesOutput`](crate::output::TerminateTargetInstancesOutput)
        pub fn build(self) -> crate::output::TerminateTargetInstancesOutput {
            crate::output::TerminateTargetInstancesOutput { job: self.job }
        }
    }
}
impl TerminateTargetInstancesOutput {
    /// Creates a new builder-style object to manufacture [`TerminateTargetInstancesOutput`](crate::output::TerminateTargetInstancesOutput)
    pub fn builder() -> crate::output::terminate_target_instances_output::Builder {
        crate::output::terminate_target_instances_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartTestOutput {
    /// <p>Start Test Job response.</p>
    pub job: std::option::Option<crate::model::Job>,
}
impl StartTestOutput {
    /// <p>Start Test Job response.</p>
    pub fn job(&self) -> std::option::Option<&crate::model::Job> {
        self.job.as_ref()
    }
}
impl std::fmt::Debug for StartTestOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartTestOutput");
        formatter.field("job", &self.job);
        formatter.finish()
    }
}
/// See [`StartTestOutput`](crate::output::StartTestOutput)
pub mod start_test_output {
    /// A builder for [`StartTestOutput`](crate::output::StartTestOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job: std::option::Option<crate::model::Job>,
    }
    impl Builder {
        /// <p>Start Test Job response.</p>
        pub fn job(mut self, input: crate::model::Job) -> Self {
            self.job = Some(input);
            self
        }
        /// <p>Start Test Job response.</p>
        pub fn set_job(mut self, input: std::option::Option<crate::model::Job>) -> Self {
            self.job = input;
            self
        }
        /// Consumes the builder and constructs a [`StartTestOutput`](crate::output::StartTestOutput)
        pub fn build(self) -> crate::output::StartTestOutput {
            crate::output::StartTestOutput { job: self.job }
        }
    }
}
impl StartTestOutput {
    /// Creates a new builder-style object to manufacture [`StartTestOutput`](crate::output::StartTestOutput)
    pub fn builder() -> crate::output::start_test_output::Builder {
        crate::output::start_test_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartCutoverOutput {
    /// <p>Start Cutover Job response.</p>
    pub job: std::option::Option<crate::model::Job>,
}
impl StartCutoverOutput {
    /// <p>Start Cutover Job response.</p>
    pub fn job(&self) -> std::option::Option<&crate::model::Job> {
        self.job.as_ref()
    }
}
impl std::fmt::Debug for StartCutoverOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartCutoverOutput");
        formatter.field("job", &self.job);
        formatter.finish()
    }
}
/// See [`StartCutoverOutput`](crate::output::StartCutoverOutput)
pub mod start_cutover_output {
    /// A builder for [`StartCutoverOutput`](crate::output::StartCutoverOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job: std::option::Option<crate::model::Job>,
    }
    impl Builder {
        /// <p>Start Cutover Job response.</p>
        pub fn job(mut self, input: crate::model::Job) -> Self {
            self.job = Some(input);
            self
        }
        /// <p>Start Cutover Job response.</p>
        pub fn set_job(mut self, input: std::option::Option<crate::model::Job>) -> Self {
            self.job = input;
            self
        }
        /// Consumes the builder and constructs a [`StartCutoverOutput`](crate::output::StartCutoverOutput)
        pub fn build(self) -> crate::output::StartCutoverOutput {
            crate::output::StartCutoverOutput { job: self.job }
        }
    }
}
impl StartCutoverOutput {
    /// Creates a new builder-style object to manufacture [`StartCutoverOutput`](crate::output::StartCutoverOutput)
    pub fn builder() -> crate::output::start_cutover_output::Builder {
        crate::output::start_cutover_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSourceServersOutput {
    /// <p>Request to filter Source Servers list by item.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::SourceServer>>,
    /// <p>Request to filter Source Servers next token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeSourceServersOutput {
    /// <p>Request to filter Source Servers list by item.</p>
    pub fn items(&self) -> std::option::Option<&[crate::model::SourceServer]> {
        self.items.as_deref()
    }
    /// <p>Request to filter Source Servers next token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeSourceServersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSourceServersOutput");
        formatter.field("items", &self.items);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeSourceServersOutput`](crate::output::DescribeSourceServersOutput)
pub mod describe_source_servers_output {
    /// A builder for [`DescribeSourceServersOutput`](crate::output::DescribeSourceServersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) items: std::option::Option<std::vec::Vec<crate::model::SourceServer>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>Request to filter Source Servers list by item.</p>
        pub fn items(mut self, input: crate::model::SourceServer) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input);
            self.items = Some(v);
            self
        }
        /// <p>Request to filter Source Servers list by item.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SourceServer>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// <p>Request to filter Source Servers next token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Request to filter Source Servers next token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSourceServersOutput`](crate::output::DescribeSourceServersOutput)
        pub fn build(self) -> crate::output::DescribeSourceServersOutput {
            crate::output::DescribeSourceServersOutput {
                items: self.items,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeSourceServersOutput {
    /// Creates a new builder-style object to manufacture [`DescribeSourceServersOutput`](crate::output::DescribeSourceServersOutput)
    pub fn builder() -> crate::output::describe_source_servers_output::Builder {
        crate::output::describe_source_servers_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSourceServerOutput {}
impl std::fmt::Debug for DeleteSourceServerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSourceServerOutput");
        formatter.finish()
    }
}
/// See [`DeleteSourceServerOutput`](crate::output::DeleteSourceServerOutput)
pub mod delete_source_server_output {
    /// A builder for [`DeleteSourceServerOutput`](crate::output::DeleteSourceServerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteSourceServerOutput`](crate::output::DeleteSourceServerOutput)
        pub fn build(self) -> crate::output::DeleteSourceServerOutput {
            crate::output::DeleteSourceServerOutput {}
        }
    }
}
impl DeleteSourceServerOutput {
    /// Creates a new builder-style object to manufacture [`DeleteSourceServerOutput`](crate::output::DeleteSourceServerOutput)
    pub fn builder() -> crate::output::delete_source_server_output::Builder {
        crate::output::delete_source_server_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeReplicationConfigurationTemplatesOutput {
    /// <p>Request to describe Replication Configuration template by items.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::ReplicationConfigurationTemplate>>,
    /// <p>Request to describe Replication Configuration template by next token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeReplicationConfigurationTemplatesOutput {
    /// <p>Request to describe Replication Configuration template by items.</p>
    pub fn items(&self) -> std::option::Option<&[crate::model::ReplicationConfigurationTemplate]> {
        self.items.as_deref()
    }
    /// <p>Request to describe Replication Configuration template by next token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeReplicationConfigurationTemplatesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeReplicationConfigurationTemplatesOutput");
        formatter.field("items", &self.items);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeReplicationConfigurationTemplatesOutput`](crate::output::DescribeReplicationConfigurationTemplatesOutput)
pub mod describe_replication_configuration_templates_output {
    /// A builder for [`DescribeReplicationConfigurationTemplatesOutput`](crate::output::DescribeReplicationConfigurationTemplatesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) items:
            std::option::Option<std::vec::Vec<crate::model::ReplicationConfigurationTemplate>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>Request to describe Replication Configuration template by items.</p>
        pub fn items(mut self, input: crate::model::ReplicationConfigurationTemplate) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input);
            self.items = Some(v);
            self
        }
        /// <p>Request to describe Replication Configuration template by items.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ReplicationConfigurationTemplate>,
            >,
        ) -> Self {
            self.items = input;
            self
        }
        /// <p>Request to describe Replication Configuration template by next token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Request to describe Replication Configuration template by next token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeReplicationConfigurationTemplatesOutput`](crate::output::DescribeReplicationConfigurationTemplatesOutput)
        pub fn build(self) -> crate::output::DescribeReplicationConfigurationTemplatesOutput {
            crate::output::DescribeReplicationConfigurationTemplatesOutput {
                items: self.items,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeReplicationConfigurationTemplatesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeReplicationConfigurationTemplatesOutput`](crate::output::DescribeReplicationConfigurationTemplatesOutput)
    pub fn builder() -> crate::output::describe_replication_configuration_templates_output::Builder
    {
        crate::output::describe_replication_configuration_templates_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateReplicationConfigurationTemplateOutput {
    /// <p>Replication Configuration template ID.</p>
    pub replication_configuration_template_id: std::option::Option<std::string::String>,
    /// <p>Replication Configuration template ARN.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>Replication Configuration template Staging Area subnet ID.</p>
    pub staging_area_subnet_id: std::option::Option<std::string::String>,
    /// <p>Replication Configuration template associate default Application Migration Service Security group.</p>
    pub associate_default_security_group: std::option::Option<bool>,
    /// <p>Replication Configuration template server Security Groups IDs.</p>
    pub replication_servers_security_groups_i_ds:
        std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Replication Configuration template server instance type.</p>
    pub replication_server_instance_type: std::option::Option<std::string::String>,
    /// <p>Replication Configuration template use Dedicated Replication Server.</p>
    pub use_dedicated_replication_server: std::option::Option<bool>,
    /// <p>Replication Configuration template use default large Staging Disk type.</p>
    pub default_large_staging_disk_type:
        std::option::Option<crate::model::ReplicationConfigurationDefaultLargeStagingDiskType>,
    /// <p>Replication Configuration template EBS encryption.</p>
    pub ebs_encryption: std::option::Option<crate::model::ReplicationConfigurationEbsEncryption>,
    /// <p>Replication Configuration template EBS encryption key ARN.</p>
    pub ebs_encryption_key_arn: std::option::Option<std::string::String>,
    /// <p>Replication Configuration template bandwidth throttling.</p>
    pub bandwidth_throttling: i64,
    /// <p>Replication Configuration template data plane routing.</p>
    pub data_plane_routing:
        std::option::Option<crate::model::ReplicationConfigurationDataPlaneRouting>,
    /// <p>Replication Configuration template create Public IP.</p>
    pub create_public_ip: std::option::Option<bool>,
    /// <p>Replication Configuration template Staging Area Tags.</p>
    pub staging_area_tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Replication Configuration template Tags.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateReplicationConfigurationTemplateOutput {
    /// <p>Replication Configuration template ID.</p>
    pub fn replication_configuration_template_id(&self) -> std::option::Option<&str> {
        self.replication_configuration_template_id.as_deref()
    }
    /// <p>Replication Configuration template ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>Replication Configuration template Staging Area subnet ID.</p>
    pub fn staging_area_subnet_id(&self) -> std::option::Option<&str> {
        self.staging_area_subnet_id.as_deref()
    }
    /// <p>Replication Configuration template associate default Application Migration Service Security group.</p>
    pub fn associate_default_security_group(&self) -> std::option::Option<bool> {
        self.associate_default_security_group
    }
    /// <p>Replication Configuration template server Security Groups IDs.</p>
    pub fn replication_servers_security_groups_i_ds(
        &self,
    ) -> std::option::Option<&[std::string::String]> {
        self.replication_servers_security_groups_i_ds.as_deref()
    }
    /// <p>Replication Configuration template server instance type.</p>
    pub fn replication_server_instance_type(&self) -> std::option::Option<&str> {
        self.replication_server_instance_type.as_deref()
    }
    /// <p>Replication Configuration template use Dedicated Replication Server.</p>
    pub fn use_dedicated_replication_server(&self) -> std::option::Option<bool> {
        self.use_dedicated_replication_server
    }
    /// <p>Replication Configuration template use default large Staging Disk type.</p>
    pub fn default_large_staging_disk_type(
        &self,
    ) -> std::option::Option<&crate::model::ReplicationConfigurationDefaultLargeStagingDiskType>
    {
        self.default_large_staging_disk_type.as_ref()
    }
    /// <p>Replication Configuration template EBS encryption.</p>
    pub fn ebs_encryption(
        &self,
    ) -> std::option::Option<&crate::model::ReplicationConfigurationEbsEncryption> {
        self.ebs_encryption.as_ref()
    }
    /// <p>Replication Configuration template EBS encryption key ARN.</p>
    pub fn ebs_encryption_key_arn(&self) -> std::option::Option<&str> {
        self.ebs_encryption_key_arn.as_deref()
    }
    /// <p>Replication Configuration template bandwidth throttling.</p>
    pub fn bandwidth_throttling(&self) -> i64 {
        self.bandwidth_throttling
    }
    /// <p>Replication Configuration template data plane routing.</p>
    pub fn data_plane_routing(
        &self,
    ) -> std::option::Option<&crate::model::ReplicationConfigurationDataPlaneRouting> {
        self.data_plane_routing.as_ref()
    }
    /// <p>Replication Configuration template create Public IP.</p>
    pub fn create_public_ip(&self) -> std::option::Option<bool> {
        self.create_public_ip
    }
    /// <p>Replication Configuration template Staging Area Tags.</p>
    pub fn staging_area_tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.staging_area_tags.as_ref()
    }
    /// <p>Replication Configuration template Tags.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateReplicationConfigurationTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateReplicationConfigurationTemplateOutput");
        formatter.field(
            "replication_configuration_template_id",
            &self.replication_configuration_template_id,
        );
        formatter.field("arn", &self.arn);
        formatter.field("staging_area_subnet_id", &self.staging_area_subnet_id);
        formatter.field(
            "associate_default_security_group",
            &self.associate_default_security_group,
        );
        formatter.field(
            "replication_servers_security_groups_i_ds",
            &self.replication_servers_security_groups_i_ds,
        );
        formatter.field(
            "replication_server_instance_type",
            &self.replication_server_instance_type,
        );
        formatter.field(
            "use_dedicated_replication_server",
            &self.use_dedicated_replication_server,
        );
        formatter.field(
            "default_large_staging_disk_type",
            &self.default_large_staging_disk_type,
        );
        formatter.field("ebs_encryption", &self.ebs_encryption);
        formatter.field("ebs_encryption_key_arn", &self.ebs_encryption_key_arn);
        formatter.field("bandwidth_throttling", &self.bandwidth_throttling);
        formatter.field("data_plane_routing", &self.data_plane_routing);
        formatter.field("create_public_ip", &self.create_public_ip);
        formatter.field("staging_area_tags", &"*** Sensitive Data Redacted ***");
        formatter.field("tags", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`CreateReplicationConfigurationTemplateOutput`](crate::output::CreateReplicationConfigurationTemplateOutput)
pub mod create_replication_configuration_template_output {
    /// A builder for [`CreateReplicationConfigurationTemplateOutput`](crate::output::CreateReplicationConfigurationTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_configuration_template_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) staging_area_subnet_id: std::option::Option<std::string::String>,
        pub(crate) associate_default_security_group: std::option::Option<bool>,
        pub(crate) replication_servers_security_groups_i_ds:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) replication_server_instance_type: std::option::Option<std::string::String>,
        pub(crate) use_dedicated_replication_server: std::option::Option<bool>,
        pub(crate) default_large_staging_disk_type:
            std::option::Option<crate::model::ReplicationConfigurationDefaultLargeStagingDiskType>,
        pub(crate) ebs_encryption:
            std::option::Option<crate::model::ReplicationConfigurationEbsEncryption>,
        pub(crate) ebs_encryption_key_arn: std::option::Option<std::string::String>,
        pub(crate) bandwidth_throttling: std::option::Option<i64>,
        pub(crate) data_plane_routing:
            std::option::Option<crate::model::ReplicationConfigurationDataPlaneRouting>,
        pub(crate) create_public_ip: std::option::Option<bool>,
        pub(crate) staging_area_tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>Replication Configuration template ID.</p>
        pub fn replication_configuration_template_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.replication_configuration_template_id = Some(input.into());
            self
        }
        /// <p>Replication Configuration template ID.</p>
        pub fn set_replication_configuration_template_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_configuration_template_id = input;
            self
        }
        /// <p>Replication Configuration template ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>Replication Configuration template ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>Replication Configuration template Staging Area subnet ID.</p>
        pub fn staging_area_subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.staging_area_subnet_id = Some(input.into());
            self
        }
        /// <p>Replication Configuration template Staging Area subnet ID.</p>
        pub fn set_staging_area_subnet_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.staging_area_subnet_id = input;
            self
        }
        /// <p>Replication Configuration template associate default Application Migration Service Security group.</p>
        pub fn associate_default_security_group(mut self, input: bool) -> Self {
            self.associate_default_security_group = Some(input);
            self
        }
        /// <p>Replication Configuration template associate default Application Migration Service Security group.</p>
        pub fn set_associate_default_security_group(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.associate_default_security_group = input;
            self
        }
        /// Appends an item to `replication_servers_security_groups_i_ds`.
        ///
        /// To override the contents of this collection use [`set_replication_servers_security_groups_i_ds`](Self::set_replication_servers_security_groups_i_ds).
        ///
        /// <p>Replication Configuration template server Security Groups IDs.</p>
        pub fn replication_servers_security_groups_i_ds(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self
                .replication_servers_security_groups_i_ds
                .unwrap_or_default();
            v.push(input.into());
            self.replication_servers_security_groups_i_ds = Some(v);
            self
        }
        /// <p>Replication Configuration template server Security Groups IDs.</p>
        pub fn set_replication_servers_security_groups_i_ds(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.replication_servers_security_groups_i_ds = input;
            self
        }
        /// <p>Replication Configuration template server instance type.</p>
        pub fn replication_server_instance_type(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.replication_server_instance_type = Some(input.into());
            self
        }
        /// <p>Replication Configuration template server instance type.</p>
        pub fn set_replication_server_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_server_instance_type = input;
            self
        }
        /// <p>Replication Configuration template use Dedicated Replication Server.</p>
        pub fn use_dedicated_replication_server(mut self, input: bool) -> Self {
            self.use_dedicated_replication_server = Some(input);
            self
        }
        /// <p>Replication Configuration template use Dedicated Replication Server.</p>
        pub fn set_use_dedicated_replication_server(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.use_dedicated_replication_server = input;
            self
        }
        /// <p>Replication Configuration template use default large Staging Disk type.</p>
        pub fn default_large_staging_disk_type(
            mut self,
            input: crate::model::ReplicationConfigurationDefaultLargeStagingDiskType,
        ) -> Self {
            self.default_large_staging_disk_type = Some(input);
            self
        }
        /// <p>Replication Configuration template use default large Staging Disk type.</p>
        pub fn set_default_large_staging_disk_type(
            mut self,
            input: std::option::Option<
                crate::model::ReplicationConfigurationDefaultLargeStagingDiskType,
            >,
        ) -> Self {
            self.default_large_staging_disk_type = input;
            self
        }
        /// <p>Replication Configuration template EBS encryption.</p>
        pub fn ebs_encryption(
            mut self,
            input: crate::model::ReplicationConfigurationEbsEncryption,
        ) -> Self {
            self.ebs_encryption = Some(input);
            self
        }
        /// <p>Replication Configuration template EBS encryption.</p>
        pub fn set_ebs_encryption(
            mut self,
            input: std::option::Option<crate::model::ReplicationConfigurationEbsEncryption>,
        ) -> Self {
            self.ebs_encryption = input;
            self
        }
        /// <p>Replication Configuration template EBS encryption key ARN.</p>
        pub fn ebs_encryption_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.ebs_encryption_key_arn = Some(input.into());
            self
        }
        /// <p>Replication Configuration template EBS encryption key ARN.</p>
        pub fn set_ebs_encryption_key_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ebs_encryption_key_arn = input;
            self
        }
        /// <p>Replication Configuration template bandwidth throttling.</p>
        pub fn bandwidth_throttling(mut self, input: i64) -> Self {
            self.bandwidth_throttling = Some(input);
            self
        }
        /// <p>Replication Configuration template bandwidth throttling.</p>
        pub fn set_bandwidth_throttling(mut self, input: std::option::Option<i64>) -> Self {
            self.bandwidth_throttling = input;
            self
        }
        /// <p>Replication Configuration template data plane routing.</p>
        pub fn data_plane_routing(
            mut self,
            input: crate::model::ReplicationConfigurationDataPlaneRouting,
        ) -> Self {
            self.data_plane_routing = Some(input);
            self
        }
        /// <p>Replication Configuration template data plane routing.</p>
        pub fn set_data_plane_routing(
            mut self,
            input: std::option::Option<crate::model::ReplicationConfigurationDataPlaneRouting>,
        ) -> Self {
            self.data_plane_routing = input;
            self
        }
        /// <p>Replication Configuration template create Public IP.</p>
        pub fn create_public_ip(mut self, input: bool) -> Self {
            self.create_public_ip = Some(input);
            self
        }
        /// <p>Replication Configuration template create Public IP.</p>
        pub fn set_create_public_ip(mut self, input: std::option::Option<bool>) -> Self {
            self.create_public_ip = input;
            self
        }
        /// Adds a key-value pair to `staging_area_tags`.
        ///
        /// To override the contents of this collection use [`set_staging_area_tags`](Self::set_staging_area_tags).
        ///
        /// <p>Replication Configuration template Staging Area Tags.</p>
        pub fn staging_area_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.staging_area_tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.staging_area_tags = Some(hash_map);
            self
        }
        /// <p>Replication Configuration template Staging Area Tags.</p>
        pub fn set_staging_area_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.staging_area_tags = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Replication Configuration template Tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Replication Configuration template Tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateReplicationConfigurationTemplateOutput`](crate::output::CreateReplicationConfigurationTemplateOutput)
        pub fn build(self) -> crate::output::CreateReplicationConfigurationTemplateOutput {
            crate::output::CreateReplicationConfigurationTemplateOutput {
                replication_configuration_template_id: self.replication_configuration_template_id,
                arn: self.arn,
                staging_area_subnet_id: self.staging_area_subnet_id,
                associate_default_security_group: self.associate_default_security_group,
                replication_servers_security_groups_i_ds: self
                    .replication_servers_security_groups_i_ds,
                replication_server_instance_type: self.replication_server_instance_type,
                use_dedicated_replication_server: self.use_dedicated_replication_server,
                default_large_staging_disk_type: self.default_large_staging_disk_type,
                ebs_encryption: self.ebs_encryption,
                ebs_encryption_key_arn: self.ebs_encryption_key_arn,
                bandwidth_throttling: self.bandwidth_throttling.unwrap_or_default(),
                data_plane_routing: self.data_plane_routing,
                create_public_ip: self.create_public_ip,
                staging_area_tags: self.staging_area_tags,
                tags: self.tags,
            }
        }
    }
}
impl CreateReplicationConfigurationTemplateOutput {
    /// Creates a new builder-style object to manufacture [`CreateReplicationConfigurationTemplateOutput`](crate::output::CreateReplicationConfigurationTemplateOutput)
    pub fn builder() -> crate::output::create_replication_configuration_template_output::Builder {
        crate::output::create_replication_configuration_template_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteReplicationConfigurationTemplateOutput {}
impl std::fmt::Debug for DeleteReplicationConfigurationTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteReplicationConfigurationTemplateOutput");
        formatter.finish()
    }
}
/// See [`DeleteReplicationConfigurationTemplateOutput`](crate::output::DeleteReplicationConfigurationTemplateOutput)
pub mod delete_replication_configuration_template_output {
    /// A builder for [`DeleteReplicationConfigurationTemplateOutput`](crate::output::DeleteReplicationConfigurationTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteReplicationConfigurationTemplateOutput`](crate::output::DeleteReplicationConfigurationTemplateOutput)
        pub fn build(self) -> crate::output::DeleteReplicationConfigurationTemplateOutput {
            crate::output::DeleteReplicationConfigurationTemplateOutput {}
        }
    }
}
impl DeleteReplicationConfigurationTemplateOutput {
    /// Creates a new builder-style object to manufacture [`DeleteReplicationConfigurationTemplateOutput`](crate::output::DeleteReplicationConfigurationTemplateOutput)
    pub fn builder() -> crate::output::delete_replication_configuration_template_output::Builder {
        crate::output::delete_replication_configuration_template_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateReplicationConfigurationTemplateOutput {
    /// <p>Replication Configuration template ID.</p>
    pub replication_configuration_template_id: std::option::Option<std::string::String>,
    /// <p>Replication Configuration template ARN.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>Replication Configuration template Staging Area subnet ID.</p>
    pub staging_area_subnet_id: std::option::Option<std::string::String>,
    /// <p>Replication Configuration template associate default Application Migration Service Security group.</p>
    pub associate_default_security_group: std::option::Option<bool>,
    /// <p>Replication Configuration template server Security Groups IDs.</p>
    pub replication_servers_security_groups_i_ds:
        std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Replication Configuration template server instance type.</p>
    pub replication_server_instance_type: std::option::Option<std::string::String>,
    /// <p>Replication Configuration template use Dedicated Replication Server.</p>
    pub use_dedicated_replication_server: std::option::Option<bool>,
    /// <p>Replication Configuration template use default large Staging Disk type.</p>
    pub default_large_staging_disk_type:
        std::option::Option<crate::model::ReplicationConfigurationDefaultLargeStagingDiskType>,
    /// <p>Replication Configuration template EBS encryption.</p>
    pub ebs_encryption: std::option::Option<crate::model::ReplicationConfigurationEbsEncryption>,
    /// <p>Replication Configuration template EBS encryption key ARN.</p>
    pub ebs_encryption_key_arn: std::option::Option<std::string::String>,
    /// <p>Replication Configuration template bandwidth throttling.</p>
    pub bandwidth_throttling: i64,
    /// <p>Replication Configuration template data plane routing.</p>
    pub data_plane_routing:
        std::option::Option<crate::model::ReplicationConfigurationDataPlaneRouting>,
    /// <p>Replication Configuration template create Public IP.</p>
    pub create_public_ip: std::option::Option<bool>,
    /// <p>Replication Configuration template Staging Area Tags.</p>
    pub staging_area_tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Replication Configuration template Tags.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl UpdateReplicationConfigurationTemplateOutput {
    /// <p>Replication Configuration template ID.</p>
    pub fn replication_configuration_template_id(&self) -> std::option::Option<&str> {
        self.replication_configuration_template_id.as_deref()
    }
    /// <p>Replication Configuration template ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>Replication Configuration template Staging Area subnet ID.</p>
    pub fn staging_area_subnet_id(&self) -> std::option::Option<&str> {
        self.staging_area_subnet_id.as_deref()
    }
    /// <p>Replication Configuration template associate default Application Migration Service Security group.</p>
    pub fn associate_default_security_group(&self) -> std::option::Option<bool> {
        self.associate_default_security_group
    }
    /// <p>Replication Configuration template server Security Groups IDs.</p>
    pub fn replication_servers_security_groups_i_ds(
        &self,
    ) -> std::option::Option<&[std::string::String]> {
        self.replication_servers_security_groups_i_ds.as_deref()
    }
    /// <p>Replication Configuration template server instance type.</p>
    pub fn replication_server_instance_type(&self) -> std::option::Option<&str> {
        self.replication_server_instance_type.as_deref()
    }
    /// <p>Replication Configuration template use Dedicated Replication Server.</p>
    pub fn use_dedicated_replication_server(&self) -> std::option::Option<bool> {
        self.use_dedicated_replication_server
    }
    /// <p>Replication Configuration template use default large Staging Disk type.</p>
    pub fn default_large_staging_disk_type(
        &self,
    ) -> std::option::Option<&crate::model::ReplicationConfigurationDefaultLargeStagingDiskType>
    {
        self.default_large_staging_disk_type.as_ref()
    }
    /// <p>Replication Configuration template EBS encryption.</p>
    pub fn ebs_encryption(
        &self,
    ) -> std::option::Option<&crate::model::ReplicationConfigurationEbsEncryption> {
        self.ebs_encryption.as_ref()
    }
    /// <p>Replication Configuration template EBS encryption key ARN.</p>
    pub fn ebs_encryption_key_arn(&self) -> std::option::Option<&str> {
        self.ebs_encryption_key_arn.as_deref()
    }
    /// <p>Replication Configuration template bandwidth throttling.</p>
    pub fn bandwidth_throttling(&self) -> i64 {
        self.bandwidth_throttling
    }
    /// <p>Replication Configuration template data plane routing.</p>
    pub fn data_plane_routing(
        &self,
    ) -> std::option::Option<&crate::model::ReplicationConfigurationDataPlaneRouting> {
        self.data_plane_routing.as_ref()
    }
    /// <p>Replication Configuration template create Public IP.</p>
    pub fn create_public_ip(&self) -> std::option::Option<bool> {
        self.create_public_ip
    }
    /// <p>Replication Configuration template Staging Area Tags.</p>
    pub fn staging_area_tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.staging_area_tags.as_ref()
    }
    /// <p>Replication Configuration template Tags.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for UpdateReplicationConfigurationTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateReplicationConfigurationTemplateOutput");
        formatter.field(
            "replication_configuration_template_id",
            &self.replication_configuration_template_id,
        );
        formatter.field("arn", &self.arn);
        formatter.field("staging_area_subnet_id", &self.staging_area_subnet_id);
        formatter.field(
            "associate_default_security_group",
            &self.associate_default_security_group,
        );
        formatter.field(
            "replication_servers_security_groups_i_ds",
            &self.replication_servers_security_groups_i_ds,
        );
        formatter.field(
            "replication_server_instance_type",
            &self.replication_server_instance_type,
        );
        formatter.field(
            "use_dedicated_replication_server",
            &self.use_dedicated_replication_server,
        );
        formatter.field(
            "default_large_staging_disk_type",
            &self.default_large_staging_disk_type,
        );
        formatter.field("ebs_encryption", &self.ebs_encryption);
        formatter.field("ebs_encryption_key_arn", &self.ebs_encryption_key_arn);
        formatter.field("bandwidth_throttling", &self.bandwidth_throttling);
        formatter.field("data_plane_routing", &self.data_plane_routing);
        formatter.field("create_public_ip", &self.create_public_ip);
        formatter.field("staging_area_tags", &"*** Sensitive Data Redacted ***");
        formatter.field("tags", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`UpdateReplicationConfigurationTemplateOutput`](crate::output::UpdateReplicationConfigurationTemplateOutput)
pub mod update_replication_configuration_template_output {
    /// A builder for [`UpdateReplicationConfigurationTemplateOutput`](crate::output::UpdateReplicationConfigurationTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_configuration_template_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) staging_area_subnet_id: std::option::Option<std::string::String>,
        pub(crate) associate_default_security_group: std::option::Option<bool>,
        pub(crate) replication_servers_security_groups_i_ds:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) replication_server_instance_type: std::option::Option<std::string::String>,
        pub(crate) use_dedicated_replication_server: std::option::Option<bool>,
        pub(crate) default_large_staging_disk_type:
            std::option::Option<crate::model::ReplicationConfigurationDefaultLargeStagingDiskType>,
        pub(crate) ebs_encryption:
            std::option::Option<crate::model::ReplicationConfigurationEbsEncryption>,
        pub(crate) ebs_encryption_key_arn: std::option::Option<std::string::String>,
        pub(crate) bandwidth_throttling: std::option::Option<i64>,
        pub(crate) data_plane_routing:
            std::option::Option<crate::model::ReplicationConfigurationDataPlaneRouting>,
        pub(crate) create_public_ip: std::option::Option<bool>,
        pub(crate) staging_area_tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>Replication Configuration template ID.</p>
        pub fn replication_configuration_template_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.replication_configuration_template_id = Some(input.into());
            self
        }
        /// <p>Replication Configuration template ID.</p>
        pub fn set_replication_configuration_template_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_configuration_template_id = input;
            self
        }
        /// <p>Replication Configuration template ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>Replication Configuration template ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>Replication Configuration template Staging Area subnet ID.</p>
        pub fn staging_area_subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.staging_area_subnet_id = Some(input.into());
            self
        }
        /// <p>Replication Configuration template Staging Area subnet ID.</p>
        pub fn set_staging_area_subnet_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.staging_area_subnet_id = input;
            self
        }
        /// <p>Replication Configuration template associate default Application Migration Service Security group.</p>
        pub fn associate_default_security_group(mut self, input: bool) -> Self {
            self.associate_default_security_group = Some(input);
            self
        }
        /// <p>Replication Configuration template associate default Application Migration Service Security group.</p>
        pub fn set_associate_default_security_group(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.associate_default_security_group = input;
            self
        }
        /// Appends an item to `replication_servers_security_groups_i_ds`.
        ///
        /// To override the contents of this collection use [`set_replication_servers_security_groups_i_ds`](Self::set_replication_servers_security_groups_i_ds).
        ///
        /// <p>Replication Configuration template server Security Groups IDs.</p>
        pub fn replication_servers_security_groups_i_ds(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self
                .replication_servers_security_groups_i_ds
                .unwrap_or_default();
            v.push(input.into());
            self.replication_servers_security_groups_i_ds = Some(v);
            self
        }
        /// <p>Replication Configuration template server Security Groups IDs.</p>
        pub fn set_replication_servers_security_groups_i_ds(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.replication_servers_security_groups_i_ds = input;
            self
        }
        /// <p>Replication Configuration template server instance type.</p>
        pub fn replication_server_instance_type(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.replication_server_instance_type = Some(input.into());
            self
        }
        /// <p>Replication Configuration template server instance type.</p>
        pub fn set_replication_server_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_server_instance_type = input;
            self
        }
        /// <p>Replication Configuration template use Dedicated Replication Server.</p>
        pub fn use_dedicated_replication_server(mut self, input: bool) -> Self {
            self.use_dedicated_replication_server = Some(input);
            self
        }
        /// <p>Replication Configuration template use Dedicated Replication Server.</p>
        pub fn set_use_dedicated_replication_server(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.use_dedicated_replication_server = input;
            self
        }
        /// <p>Replication Configuration template use default large Staging Disk type.</p>
        pub fn default_large_staging_disk_type(
            mut self,
            input: crate::model::ReplicationConfigurationDefaultLargeStagingDiskType,
        ) -> Self {
            self.default_large_staging_disk_type = Some(input);
            self
        }
        /// <p>Replication Configuration template use default large Staging Disk type.</p>
        pub fn set_default_large_staging_disk_type(
            mut self,
            input: std::option::Option<
                crate::model::ReplicationConfigurationDefaultLargeStagingDiskType,
            >,
        ) -> Self {
            self.default_large_staging_disk_type = input;
            self
        }
        /// <p>Replication Configuration template EBS encryption.</p>
        pub fn ebs_encryption(
            mut self,
            input: crate::model::ReplicationConfigurationEbsEncryption,
        ) -> Self {
            self.ebs_encryption = Some(input);
            self
        }
        /// <p>Replication Configuration template EBS encryption.</p>
        pub fn set_ebs_encryption(
            mut self,
            input: std::option::Option<crate::model::ReplicationConfigurationEbsEncryption>,
        ) -> Self {
            self.ebs_encryption = input;
            self
        }
        /// <p>Replication Configuration template EBS encryption key ARN.</p>
        pub fn ebs_encryption_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.ebs_encryption_key_arn = Some(input.into());
            self
        }
        /// <p>Replication Configuration template EBS encryption key ARN.</p>
        pub fn set_ebs_encryption_key_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ebs_encryption_key_arn = input;
            self
        }
        /// <p>Replication Configuration template bandwidth throttling.</p>
        pub fn bandwidth_throttling(mut self, input: i64) -> Self {
            self.bandwidth_throttling = Some(input);
            self
        }
        /// <p>Replication Configuration template bandwidth throttling.</p>
        pub fn set_bandwidth_throttling(mut self, input: std::option::Option<i64>) -> Self {
            self.bandwidth_throttling = input;
            self
        }
        /// <p>Replication Configuration template data plane routing.</p>
        pub fn data_plane_routing(
            mut self,
            input: crate::model::ReplicationConfigurationDataPlaneRouting,
        ) -> Self {
            self.data_plane_routing = Some(input);
            self
        }
        /// <p>Replication Configuration template data plane routing.</p>
        pub fn set_data_plane_routing(
            mut self,
            input: std::option::Option<crate::model::ReplicationConfigurationDataPlaneRouting>,
        ) -> Self {
            self.data_plane_routing = input;
            self
        }
        /// <p>Replication Configuration template create Public IP.</p>
        pub fn create_public_ip(mut self, input: bool) -> Self {
            self.create_public_ip = Some(input);
            self
        }
        /// <p>Replication Configuration template create Public IP.</p>
        pub fn set_create_public_ip(mut self, input: std::option::Option<bool>) -> Self {
            self.create_public_ip = input;
            self
        }
        /// Adds a key-value pair to `staging_area_tags`.
        ///
        /// To override the contents of this collection use [`set_staging_area_tags`](Self::set_staging_area_tags).
        ///
        /// <p>Replication Configuration template Staging Area Tags.</p>
        pub fn staging_area_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.staging_area_tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.staging_area_tags = Some(hash_map);
            self
        }
        /// <p>Replication Configuration template Staging Area Tags.</p>
        pub fn set_staging_area_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.staging_area_tags = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Replication Configuration template Tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Replication Configuration template Tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateReplicationConfigurationTemplateOutput`](crate::output::UpdateReplicationConfigurationTemplateOutput)
        pub fn build(self) -> crate::output::UpdateReplicationConfigurationTemplateOutput {
            crate::output::UpdateReplicationConfigurationTemplateOutput {
                replication_configuration_template_id: self.replication_configuration_template_id,
                arn: self.arn,
                staging_area_subnet_id: self.staging_area_subnet_id,
                associate_default_security_group: self.associate_default_security_group,
                replication_servers_security_groups_i_ds: self
                    .replication_servers_security_groups_i_ds,
                replication_server_instance_type: self.replication_server_instance_type,
                use_dedicated_replication_server: self.use_dedicated_replication_server,
                default_large_staging_disk_type: self.default_large_staging_disk_type,
                ebs_encryption: self.ebs_encryption,
                ebs_encryption_key_arn: self.ebs_encryption_key_arn,
                bandwidth_throttling: self.bandwidth_throttling.unwrap_or_default(),
                data_plane_routing: self.data_plane_routing,
                create_public_ip: self.create_public_ip,
                staging_area_tags: self.staging_area_tags,
                tags: self.tags,
            }
        }
    }
}
impl UpdateReplicationConfigurationTemplateOutput {
    /// Creates a new builder-style object to manufacture [`UpdateReplicationConfigurationTemplateOutput`](crate::output::UpdateReplicationConfigurationTemplateOutput)
    pub fn builder() -> crate::output::update_replication_configuration_template_output::Builder {
        crate::output::update_replication_configuration_template_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeJobLogItemsOutput {
    /// <p>Request to describe Job log response items.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::JobLog>>,
    /// <p>Request to describe Job log response next token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeJobLogItemsOutput {
    /// <p>Request to describe Job log response items.</p>
    pub fn items(&self) -> std::option::Option<&[crate::model::JobLog]> {
        self.items.as_deref()
    }
    /// <p>Request to describe Job log response next token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeJobLogItemsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeJobLogItemsOutput");
        formatter.field("items", &self.items);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeJobLogItemsOutput`](crate::output::DescribeJobLogItemsOutput)
pub mod describe_job_log_items_output {
    /// A builder for [`DescribeJobLogItemsOutput`](crate::output::DescribeJobLogItemsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) items: std::option::Option<std::vec::Vec<crate::model::JobLog>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>Request to describe Job log response items.</p>
        pub fn items(mut self, input: crate::model::JobLog) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input);
            self.items = Some(v);
            self
        }
        /// <p>Request to describe Job log response items.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::JobLog>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// <p>Request to describe Job log response next token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Request to describe Job log response next token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeJobLogItemsOutput`](crate::output::DescribeJobLogItemsOutput)
        pub fn build(self) -> crate::output::DescribeJobLogItemsOutput {
            crate::output::DescribeJobLogItemsOutput {
                items: self.items,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeJobLogItemsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeJobLogItemsOutput`](crate::output::DescribeJobLogItemsOutput)
    pub fn builder() -> crate::output::describe_job_log_items_output::Builder {
        crate::output::describe_job_log_items_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeJobsOutput {
    /// <p>Request to describe Job log items.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::Job>>,
    /// <p>Request to describe Job response by next token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeJobsOutput {
    /// <p>Request to describe Job log items.</p>
    pub fn items(&self) -> std::option::Option<&[crate::model::Job]> {
        self.items.as_deref()
    }
    /// <p>Request to describe Job response by next token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeJobsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeJobsOutput");
        formatter.field("items", &self.items);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeJobsOutput`](crate::output::DescribeJobsOutput)
pub mod describe_jobs_output {
    /// A builder for [`DescribeJobsOutput`](crate::output::DescribeJobsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) items: std::option::Option<std::vec::Vec<crate::model::Job>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>Request to describe Job log items.</p>
        pub fn items(mut self, input: crate::model::Job) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input);
            self.items = Some(v);
            self
        }
        /// <p>Request to describe Job log items.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Job>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// <p>Request to describe Job response by next token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Request to describe Job response by next token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeJobsOutput`](crate::output::DescribeJobsOutput)
        pub fn build(self) -> crate::output::DescribeJobsOutput {
            crate::output::DescribeJobsOutput {
                items: self.items,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeJobsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeJobsOutput`](crate::output::DescribeJobsOutput)
    pub fn builder() -> crate::output::describe_jobs_output::Builder {
        crate::output::describe_jobs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteJobOutput {}
impl std::fmt::Debug for DeleteJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteJobOutput");
        formatter.finish()
    }
}
/// See [`DeleteJobOutput`](crate::output::DeleteJobOutput)
pub mod delete_job_output {
    /// A builder for [`DeleteJobOutput`](crate::output::DeleteJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteJobOutput`](crate::output::DeleteJobOutput)
        pub fn build(self) -> crate::output::DeleteJobOutput {
            crate::output::DeleteJobOutput {}
        }
    }
}
impl DeleteJobOutput {
    /// Creates a new builder-style object to manufacture [`DeleteJobOutput`](crate::output::DeleteJobOutput)
    pub fn builder() -> crate::output::delete_job_output::Builder {
        crate::output::delete_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>List tags for resource response.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ListTagsForResourceOutput {
    /// <p>List tags for resource response.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>List tags for resource response.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>List tags for resource response.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InitializeServiceOutput {}
impl std::fmt::Debug for InitializeServiceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InitializeServiceOutput");
        formatter.finish()
    }
}
/// See [`InitializeServiceOutput`](crate::output::InitializeServiceOutput)
pub mod initialize_service_output {
    /// A builder for [`InitializeServiceOutput`](crate::output::InitializeServiceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`InitializeServiceOutput`](crate::output::InitializeServiceOutput)
        pub fn build(self) -> crate::output::InitializeServiceOutput {
            crate::output::InitializeServiceOutput {}
        }
    }
}
impl InitializeServiceOutput {
    /// Creates a new builder-style object to manufacture [`InitializeServiceOutput`](crate::output::InitializeServiceOutput)
    pub fn builder() -> crate::output::initialize_service_output::Builder {
        crate::output::initialize_service_output::Builder::default()
    }
}
