// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon MemoryDB
///
/// Client for invoking operations on Amazon MemoryDB. Each operation on Amazon MemoryDB is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_memorydb::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_memorydb::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_memorydb::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`BatchUpdateCluster`](crate::client::fluent_builders::BatchUpdateCluster) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_names(Vec<String>)`](crate::client::fluent_builders::BatchUpdateCluster::cluster_names) / [`set_cluster_names(Option<Vec<String>>)`](crate::client::fluent_builders::BatchUpdateCluster::set_cluster_names): <p>The cluster names to apply the updates.</p>
    ///   - [`service_update(ServiceUpdateRequest)`](crate::client::fluent_builders::BatchUpdateCluster::service_update) / [`set_service_update(Option<ServiceUpdateRequest>)`](crate::client::fluent_builders::BatchUpdateCluster::set_service_update): <p>The unique ID of the service update</p>
    /// - On success, responds with [`BatchUpdateClusterOutput`](crate::output::BatchUpdateClusterOutput) with field(s):
    ///   - [`processed_clusters(Option<Vec<Cluster>>)`](crate::output::BatchUpdateClusterOutput::processed_clusters): <p>The list of clusters that have been updated.</p>
    ///   - [`unprocessed_clusters(Option<Vec<UnprocessedCluster>>)`](crate::output::BatchUpdateClusterOutput::unprocessed_clusters): <p>The list of clusters where updates have not been applied.</p>
    /// - On failure, responds with [`SdkError<BatchUpdateClusterError>`](crate::error::BatchUpdateClusterError)
    pub fn batch_update_cluster(&self) -> fluent_builders::BatchUpdateCluster {
        fluent_builders::BatchUpdateCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CopySnapshot`](crate::client::fluent_builders::CopySnapshot) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`source_snapshot_name(impl Into<String>)`](crate::client::fluent_builders::CopySnapshot::source_snapshot_name) / [`set_source_snapshot_name(Option<String>)`](crate::client::fluent_builders::CopySnapshot::set_source_snapshot_name): <p>The name of an existing snapshot from which to make a copy.</p>
    ///   - [`target_snapshot_name(impl Into<String>)`](crate::client::fluent_builders::CopySnapshot::target_snapshot_name) / [`set_target_snapshot_name(Option<String>)`](crate::client::fluent_builders::CopySnapshot::set_target_snapshot_name): <p>A name for the snapshot copy. MemoryDB does not permit overwriting a snapshot, therefore this name must be unique within its context - MemoryDB or an Amazon S3 bucket if exporting.</p>
    ///   - [`target_bucket(impl Into<String>)`](crate::client::fluent_builders::CopySnapshot::target_bucket) / [`set_target_bucket(Option<String>)`](crate::client::fluent_builders::CopySnapshot::set_target_bucket): <p>The Amazon S3 bucket to which the snapshot is exported. This parameter is used only when exporting a snapshot for external access. When using this parameter to export a snapshot, be sure MemoryDB has the needed permissions to this S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/snapshots-exporting.html">Step 2: Grant MemoryDB Access to Your Amazon S3 Bucket</a>. </p>
    ///   - [`kms_key_id(impl Into<String>)`](crate::client::fluent_builders::CopySnapshot::kms_key_id) / [`set_kms_key_id(Option<String>)`](crate::client::fluent_builders::CopySnapshot::set_kms_key_id): <p>The ID of the KMS key used to encrypt the target snapshot.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CopySnapshot::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CopySnapshot::set_tags): <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
    /// - On success, responds with [`CopySnapshotOutput`](crate::output::CopySnapshotOutput) with field(s):
    ///   - [`snapshot(Option<Snapshot>)`](crate::output::CopySnapshotOutput::snapshot): <p>Represents a copy of an entire cluster as of the time when the snapshot was taken.</p>
    /// - On failure, responds with [`SdkError<CopySnapshotError>`](crate::error::CopySnapshotError)
    pub fn copy_snapshot(&self) -> fluent_builders::CopySnapshot {
        fluent_builders::CopySnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateACL`](crate::client::fluent_builders::CreateACL) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`acl_name(impl Into<String>)`](crate::client::fluent_builders::CreateACL::acl_name) / [`set_acl_name(Option<String>)`](crate::client::fluent_builders::CreateACL::set_acl_name): <p>The name of the Access Control List.</p>
    ///   - [`user_names(Vec<String>)`](crate::client::fluent_builders::CreateACL::user_names) / [`set_user_names(Option<Vec<String>>)`](crate::client::fluent_builders::CreateACL::set_user_names): <p>The list of users that belong to the Access Control List.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateACL::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateACL::set_tags): <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
    /// - On success, responds with [`CreateAclOutput`](crate::output::CreateAclOutput) with field(s):
    ///   - [`acl(Option<Acl>)`](crate::output::CreateAclOutput::acl): <p>The newly-created Access Control List.</p>
    /// - On failure, responds with [`SdkError<CreateACLError>`](crate::error::CreateACLError)
    pub fn create_acl(&self) -> fluent_builders::CreateACL {
        fluent_builders::CreateACL::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateCluster`](crate::client::fluent_builders::CreateCluster) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_name(impl Into<String>)`](crate::client::fluent_builders::CreateCluster::cluster_name) / [`set_cluster_name(Option<String>)`](crate::client::fluent_builders::CreateCluster::set_cluster_name): <p>The name of the cluster. This value must be unique as it also serves as the cluster identifier.</p>
    ///   - [`node_type(impl Into<String>)`](crate::client::fluent_builders::CreateCluster::node_type) / [`set_node_type(Option<String>)`](crate::client::fluent_builders::CreateCluster::set_node_type): <p>The compute and memory capacity of the nodes in the cluster.</p>
    ///   - [`parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::CreateCluster::parameter_group_name) / [`set_parameter_group_name(Option<String>)`](crate::client::fluent_builders::CreateCluster::set_parameter_group_name): <p>The name of the parameter group associated with the cluster.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateCluster::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateCluster::set_description): <p>An optional description of the cluster.</p>
    ///   - [`num_shards(i32)`](crate::client::fluent_builders::CreateCluster::num_shards) / [`set_num_shards(Option<i32>)`](crate::client::fluent_builders::CreateCluster::set_num_shards): <p>The number of shards the cluster will contain. The default value is 1. </p>
    ///   - [`num_replicas_per_shard(i32)`](crate::client::fluent_builders::CreateCluster::num_replicas_per_shard) / [`set_num_replicas_per_shard(Option<i32>)`](crate::client::fluent_builders::CreateCluster::set_num_replicas_per_shard): <p>The number of replicas to apply to each shard. The default value is 1. The maximum is 5. </p>
    ///   - [`subnet_group_name(impl Into<String>)`](crate::client::fluent_builders::CreateCluster::subnet_group_name) / [`set_subnet_group_name(Option<String>)`](crate::client::fluent_builders::CreateCluster::set_subnet_group_name): <p>The name of the subnet group to be used for the cluster.</p>
    ///   - [`security_group_ids(Vec<String>)`](crate::client::fluent_builders::CreateCluster::security_group_ids) / [`set_security_group_ids(Option<Vec<String>>)`](crate::client::fluent_builders::CreateCluster::set_security_group_ids): <p>A list of security group names to associate with this cluster.</p>
    ///   - [`maintenance_window(impl Into<String>)`](crate::client::fluent_builders::CreateCluster::maintenance_window) / [`set_maintenance_window(Option<String>)`](crate::client::fluent_builders::CreateCluster::set_maintenance_window): <p>Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format <code>ddd:hh24:mi-ddd:hh24:mi</code> (24H Clock UTC). The minimum maintenance window is a 60 minute period.</p>
    ///   - [`port(i32)`](crate::client::fluent_builders::CreateCluster::port) / [`set_port(Option<i32>)`](crate::client::fluent_builders::CreateCluster::set_port): <p>The port number on which each of the nodes accepts connections.</p>
    ///   - [`sns_topic_arn(impl Into<String>)`](crate::client::fluent_builders::CreateCluster::sns_topic_arn) / [`set_sns_topic_arn(Option<String>)`](crate::client::fluent_builders::CreateCluster::set_sns_topic_arn): <p>The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which notifications are sent.</p>
    ///   - [`tls_enabled(bool)`](crate::client::fluent_builders::CreateCluster::tls_enabled) / [`set_tls_enabled(Option<bool>)`](crate::client::fluent_builders::CreateCluster::set_tls_enabled): <p>A flag to enable in-transit encryption on the cluster.</p>
    ///   - [`kms_key_id(impl Into<String>)`](crate::client::fluent_builders::CreateCluster::kms_key_id) / [`set_kms_key_id(Option<String>)`](crate::client::fluent_builders::CreateCluster::set_kms_key_id): <p>The ID of the KMS key used to encrypt the cluster.</p>
    ///   - [`snapshot_arns(Vec<String>)`](crate::client::fluent_builders::CreateCluster::snapshot_arns) / [`set_snapshot_arns(Option<Vec<String>>)`](crate::client::fluent_builders::CreateCluster::set_snapshot_arns): <p>A list of Amazon Resource Names (ARN) that uniquely identify the RDB snapshot files stored in Amazon S3. The snapshot files are used to populate the new cluster. The Amazon S3 object name in the ARN cannot contain any commas.</p>
    ///   - [`snapshot_name(impl Into<String>)`](crate::client::fluent_builders::CreateCluster::snapshot_name) / [`set_snapshot_name(Option<String>)`](crate::client::fluent_builders::CreateCluster::set_snapshot_name): <p>The name of a snapshot from which to restore data into the new cluster. The snapshot status changes to restoring while the new cluster is being created.</p>
    ///   - [`snapshot_retention_limit(i32)`](crate::client::fluent_builders::CreateCluster::snapshot_retention_limit) / [`set_snapshot_retention_limit(Option<i32>)`](crate::client::fluent_builders::CreateCluster::set_snapshot_retention_limit): <p>The number of days for which MemoryDB retains automatic snapshots before deleting them. For example, if you set SnapshotRetentionLimit to 5, a snapshot that was taken today is retained for 5 days before being deleted.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateCluster::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateCluster::set_tags): <p>A list of tags to be added to this resource. Tags are comma-separated key,value pairs (e.g. Key=myKey, Value=myKeyValue. You can include multiple tags as shown following: Key=myKey, Value=myKeyValue Key=mySecondKey, Value=mySecondKeyValue.</p>
    ///   - [`snapshot_window(impl Into<String>)`](crate::client::fluent_builders::CreateCluster::snapshot_window) / [`set_snapshot_window(Option<String>)`](crate::client::fluent_builders::CreateCluster::set_snapshot_window): <p>The daily time range (in UTC) during which MemoryDB begins taking a daily snapshot of your shard.</p>  <p> Example: 05:00-09:00</p>  <p> If you do not specify this parameter, MemoryDB automatically chooses an appropriate time range.</p>
    ///   - [`acl_name(impl Into<String>)`](crate::client::fluent_builders::CreateCluster::acl_name) / [`set_acl_name(Option<String>)`](crate::client::fluent_builders::CreateCluster::set_acl_name): <p>The name of the Access Control List to associate with the cluster.</p>
    ///   - [`engine_version(impl Into<String>)`](crate::client::fluent_builders::CreateCluster::engine_version) / [`set_engine_version(Option<String>)`](crate::client::fluent_builders::CreateCluster::set_engine_version): <p>The version number of the Redis engine to be used for the cluster.</p>
    ///   - [`auto_minor_version_upgrade(bool)`](crate::client::fluent_builders::CreateCluster::auto_minor_version_upgrade) / [`set_auto_minor_version_upgrade(Option<bool>)`](crate::client::fluent_builders::CreateCluster::set_auto_minor_version_upgrade): <p>When set to true, the cluster will automatically receive minor engine version upgrades after launch.</p>
    /// - On success, responds with [`CreateClusterOutput`](crate::output::CreateClusterOutput) with field(s):
    ///   - [`cluster(Option<Cluster>)`](crate::output::CreateClusterOutput::cluster): <p>The newly-created cluster.</p>
    /// - On failure, responds with [`SdkError<CreateClusterError>`](crate::error::CreateClusterError)
    pub fn create_cluster(&self) -> fluent_builders::CreateCluster {
        fluent_builders::CreateCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateParameterGroup`](crate::client::fluent_builders::CreateParameterGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::CreateParameterGroup::parameter_group_name) / [`set_parameter_group_name(Option<String>)`](crate::client::fluent_builders::CreateParameterGroup::set_parameter_group_name): <p>The name of the parameter group.</p>
    ///   - [`family(impl Into<String>)`](crate::client::fluent_builders::CreateParameterGroup::family) / [`set_family(Option<String>)`](crate::client::fluent_builders::CreateParameterGroup::set_family): <p>The name of the parameter group family that the parameter group can be used with.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateParameterGroup::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateParameterGroup::set_description): <p>An optional description of the parameter group.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateParameterGroup::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateParameterGroup::set_tags): <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
    /// - On success, responds with [`CreateParameterGroupOutput`](crate::output::CreateParameterGroupOutput) with field(s):
    ///   - [`parameter_group(Option<ParameterGroup>)`](crate::output::CreateParameterGroupOutput::parameter_group): <p>The newly-created parameter group.</p>
    /// - On failure, responds with [`SdkError<CreateParameterGroupError>`](crate::error::CreateParameterGroupError)
    pub fn create_parameter_group(&self) -> fluent_builders::CreateParameterGroup {
        fluent_builders::CreateParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateSnapshot`](crate::client::fluent_builders::CreateSnapshot) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_name(impl Into<String>)`](crate::client::fluent_builders::CreateSnapshot::cluster_name) / [`set_cluster_name(Option<String>)`](crate::client::fluent_builders::CreateSnapshot::set_cluster_name): <p>The snapshot is created from this cluster.</p>
    ///   - [`snapshot_name(impl Into<String>)`](crate::client::fluent_builders::CreateSnapshot::snapshot_name) / [`set_snapshot_name(Option<String>)`](crate::client::fluent_builders::CreateSnapshot::set_snapshot_name): <p>A name for the snapshot being created.</p>
    ///   - [`kms_key_id(impl Into<String>)`](crate::client::fluent_builders::CreateSnapshot::kms_key_id) / [`set_kms_key_id(Option<String>)`](crate::client::fluent_builders::CreateSnapshot::set_kms_key_id): <p>The ID of the KMS key used to encrypt the snapshot.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateSnapshot::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateSnapshot::set_tags): <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
    /// - On success, responds with [`CreateSnapshotOutput`](crate::output::CreateSnapshotOutput) with field(s):
    ///   - [`snapshot(Option<Snapshot>)`](crate::output::CreateSnapshotOutput::snapshot): <p>The newly-created snapshot.</p>
    /// - On failure, responds with [`SdkError<CreateSnapshotError>`](crate::error::CreateSnapshotError)
    pub fn create_snapshot(&self) -> fluent_builders::CreateSnapshot {
        fluent_builders::CreateSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateSubnetGroup`](crate::client::fluent_builders::CreateSubnetGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`subnet_group_name(impl Into<String>)`](crate::client::fluent_builders::CreateSubnetGroup::subnet_group_name) / [`set_subnet_group_name(Option<String>)`](crate::client::fluent_builders::CreateSubnetGroup::set_subnet_group_name): <p>The name of the subnet group.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateSubnetGroup::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateSubnetGroup::set_description): <p>A description for the subnet group.</p>
    ///   - [`subnet_ids(Vec<String>)`](crate::client::fluent_builders::CreateSubnetGroup::subnet_ids) / [`set_subnet_ids(Option<Vec<String>>)`](crate::client::fluent_builders::CreateSubnetGroup::set_subnet_ids): <p>A list of VPC subnet IDs for the subnet group.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateSubnetGroup::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateSubnetGroup::set_tags): <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
    /// - On success, responds with [`CreateSubnetGroupOutput`](crate::output::CreateSubnetGroupOutput) with field(s):
    ///   - [`subnet_group(Option<SubnetGroup>)`](crate::output::CreateSubnetGroupOutput::subnet_group): <p>The newly-created subnet group</p>
    /// - On failure, responds with [`SdkError<CreateSubnetGroupError>`](crate::error::CreateSubnetGroupError)
    pub fn create_subnet_group(&self) -> fluent_builders::CreateSubnetGroup {
        fluent_builders::CreateSubnetGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateUser`](crate::client::fluent_builders::CreateUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_name(impl Into<String>)`](crate::client::fluent_builders::CreateUser::user_name) / [`set_user_name(Option<String>)`](crate::client::fluent_builders::CreateUser::set_user_name): <p>The name of the user. This value must be unique as it also serves as the user identifier.</p>
    ///   - [`authentication_mode(AuthenticationMode)`](crate::client::fluent_builders::CreateUser::authentication_mode) / [`set_authentication_mode(Option<AuthenticationMode>)`](crate::client::fluent_builders::CreateUser::set_authentication_mode): <p>Denotes the user's authentication properties, such as whether it requires a password to authenticate.</p>
    ///   - [`access_string(impl Into<String>)`](crate::client::fluent_builders::CreateUser::access_string) / [`set_access_string(Option<String>)`](crate::client::fluent_builders::CreateUser::set_access_string): <p>Access permissions string used for this user.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateUser::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateUser::set_tags): <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
    /// - On success, responds with [`CreateUserOutput`](crate::output::CreateUserOutput) with field(s):
    ///   - [`user(Option<User>)`](crate::output::CreateUserOutput::user): <p>The newly-created user.</p>
    /// - On failure, responds with [`SdkError<CreateUserError>`](crate::error::CreateUserError)
    pub fn create_user(&self) -> fluent_builders::CreateUser {
        fluent_builders::CreateUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteACL`](crate::client::fluent_builders::DeleteACL) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`acl_name(impl Into<String>)`](crate::client::fluent_builders::DeleteACL::acl_name) / [`set_acl_name(Option<String>)`](crate::client::fluent_builders::DeleteACL::set_acl_name): <p>The name of the Access Control List to delete</p>
    /// - On success, responds with [`DeleteAclOutput`](crate::output::DeleteAclOutput) with field(s):
    ///   - [`acl(Option<Acl>)`](crate::output::DeleteAclOutput::acl): <p>The Access Control List object that has been deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteACLError>`](crate::error::DeleteACLError)
    pub fn delete_acl(&self) -> fluent_builders::DeleteACL {
        fluent_builders::DeleteACL::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteCluster`](crate::client::fluent_builders::DeleteCluster) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_name(impl Into<String>)`](crate::client::fluent_builders::DeleteCluster::cluster_name) / [`set_cluster_name(Option<String>)`](crate::client::fluent_builders::DeleteCluster::set_cluster_name): <p>The name of the cluster to be deleted</p>
    ///   - [`final_snapshot_name(impl Into<String>)`](crate::client::fluent_builders::DeleteCluster::final_snapshot_name) / [`set_final_snapshot_name(Option<String>)`](crate::client::fluent_builders::DeleteCluster::set_final_snapshot_name): <p>The user-supplied name of a final cluster snapshot. This is the unique name that identifies the snapshot. MemoryDB creates the snapshot, and then deletes the cluster immediately afterward.</p>
    /// - On success, responds with [`DeleteClusterOutput`](crate::output::DeleteClusterOutput) with field(s):
    ///   - [`cluster(Option<Cluster>)`](crate::output::DeleteClusterOutput::cluster): <p>The cluster object that has been deleted</p>
    /// - On failure, responds with [`SdkError<DeleteClusterError>`](crate::error::DeleteClusterError)
    pub fn delete_cluster(&self) -> fluent_builders::DeleteCluster {
        fluent_builders::DeleteCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteParameterGroup`](crate::client::fluent_builders::DeleteParameterGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::DeleteParameterGroup::parameter_group_name) / [`set_parameter_group_name(Option<String>)`](crate::client::fluent_builders::DeleteParameterGroup::set_parameter_group_name): <p>The name of the parameter group to delete.</p>
    /// - On success, responds with [`DeleteParameterGroupOutput`](crate::output::DeleteParameterGroupOutput) with field(s):
    ///   - [`parameter_group(Option<ParameterGroup>)`](crate::output::DeleteParameterGroupOutput::parameter_group): <p>The parameter group that has been deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteParameterGroupError>`](crate::error::DeleteParameterGroupError)
    pub fn delete_parameter_group(&self) -> fluent_builders::DeleteParameterGroup {
        fluent_builders::DeleteParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteSnapshot`](crate::client::fluent_builders::DeleteSnapshot) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`snapshot_name(impl Into<String>)`](crate::client::fluent_builders::DeleteSnapshot::snapshot_name) / [`set_snapshot_name(Option<String>)`](crate::client::fluent_builders::DeleteSnapshot::set_snapshot_name): <p>The name of the snapshot to delete</p>
    /// - On success, responds with [`DeleteSnapshotOutput`](crate::output::DeleteSnapshotOutput) with field(s):
    ///   - [`snapshot(Option<Snapshot>)`](crate::output::DeleteSnapshotOutput::snapshot): <p>The snapshot object that has been deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteSnapshotError>`](crate::error::DeleteSnapshotError)
    pub fn delete_snapshot(&self) -> fluent_builders::DeleteSnapshot {
        fluent_builders::DeleteSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteSubnetGroup`](crate::client::fluent_builders::DeleteSubnetGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`subnet_group_name(impl Into<String>)`](crate::client::fluent_builders::DeleteSubnetGroup::subnet_group_name) / [`set_subnet_group_name(Option<String>)`](crate::client::fluent_builders::DeleteSubnetGroup::set_subnet_group_name): <p>The name of the subnet group to delete</p>
    /// - On success, responds with [`DeleteSubnetGroupOutput`](crate::output::DeleteSubnetGroupOutput) with field(s):
    ///   - [`subnet_group(Option<SubnetGroup>)`](crate::output::DeleteSubnetGroupOutput::subnet_group): <p>The subnet group object that has been deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteSubnetGroupError>`](crate::error::DeleteSubnetGroupError)
    pub fn delete_subnet_group(&self) -> fluent_builders::DeleteSubnetGroup {
        fluent_builders::DeleteSubnetGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteUser`](crate::client::fluent_builders::DeleteUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_name(impl Into<String>)`](crate::client::fluent_builders::DeleteUser::user_name) / [`set_user_name(Option<String>)`](crate::client::fluent_builders::DeleteUser::set_user_name): <p>The name of the user to delete</p>
    /// - On success, responds with [`DeleteUserOutput`](crate::output::DeleteUserOutput) with field(s):
    ///   - [`user(Option<User>)`](crate::output::DeleteUserOutput::user): <p>The user object that has been deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteUserError>`](crate::error::DeleteUserError)
    pub fn delete_user(&self) -> fluent_builders::DeleteUser {
        fluent_builders::DeleteUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeACLs`](crate::client::fluent_builders::DescribeACLs) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`acl_name(impl Into<String>)`](crate::client::fluent_builders::DescribeACLs::acl_name) / [`set_acl_name(Option<String>)`](crate::client::fluent_builders::DescribeACLs::set_acl_name): <p>The name of the ACL</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeACLs::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeACLs::set_max_results): <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeACLs::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeACLs::set_next_token): <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
    /// - On success, responds with [`DescribeAcLsOutput`](crate::output::DescribeAcLsOutput) with field(s):
    ///   - [`ac_ls(Option<Vec<Acl>>)`](crate::output::DescribeAcLsOutput::ac_ls): <p>The list of ACLs</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeAcLsOutput::next_token): <p>If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
    /// - On failure, responds with [`SdkError<DescribeACLsError>`](crate::error::DescribeACLsError)
    pub fn describe_ac_ls(&self) -> fluent_builders::DescribeACLs {
        fluent_builders::DescribeACLs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeClusters`](crate::client::fluent_builders::DescribeClusters) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_name(impl Into<String>)`](crate::client::fluent_builders::DescribeClusters::cluster_name) / [`set_cluster_name(Option<String>)`](crate::client::fluent_builders::DescribeClusters::set_cluster_name): <p>The name of the cluster</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeClusters::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeClusters::set_max_results): <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeClusters::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeClusters::set_next_token): <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
    ///   - [`show_shard_details(bool)`](crate::client::fluent_builders::DescribeClusters::show_shard_details) / [`set_show_shard_details(Option<bool>)`](crate::client::fluent_builders::DescribeClusters::set_show_shard_details): <p>An optional flag that can be included in the request to retrieve information about the individual shard(s).</p>
    /// - On success, responds with [`DescribeClustersOutput`](crate::output::DescribeClustersOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::DescribeClustersOutput::next_token): <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
    ///   - [`clusters(Option<Vec<Cluster>>)`](crate::output::DescribeClustersOutput::clusters): <p>A list of clusters</p>
    /// - On failure, responds with [`SdkError<DescribeClustersError>`](crate::error::DescribeClustersError)
    pub fn describe_clusters(&self) -> fluent_builders::DescribeClusters {
        fluent_builders::DescribeClusters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeEngineVersions`](crate::client::fluent_builders::DescribeEngineVersions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`engine_version(impl Into<String>)`](crate::client::fluent_builders::DescribeEngineVersions::engine_version) / [`set_engine_version(Option<String>)`](crate::client::fluent_builders::DescribeEngineVersions::set_engine_version): <p>The Redis engine version</p>
    ///   - [`parameter_group_family(impl Into<String>)`](crate::client::fluent_builders::DescribeEngineVersions::parameter_group_family) / [`set_parameter_group_family(Option<String>)`](crate::client::fluent_builders::DescribeEngineVersions::set_parameter_group_family): <p>The name of a specific parameter group family to return details for.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeEngineVersions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeEngineVersions::set_max_results): <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeEngineVersions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeEngineVersions::set_next_token): <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
    ///   - [`default_only(bool)`](crate::client::fluent_builders::DescribeEngineVersions::default_only) / [`set_default_only(bool)`](crate::client::fluent_builders::DescribeEngineVersions::set_default_only): <p>If true, specifies that only the default version of the specified engine or engine and major version combination is to be returned.</p>
    /// - On success, responds with [`DescribeEngineVersionsOutput`](crate::output::DescribeEngineVersionsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::DescribeEngineVersionsOutput::next_token): <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
    ///   - [`engine_versions(Option<Vec<EngineVersionInfo>>)`](crate::output::DescribeEngineVersionsOutput::engine_versions): <p>A list of engine version details. Each element in the list contains detailed information about one engine version.</p>
    /// - On failure, responds with [`SdkError<DescribeEngineVersionsError>`](crate::error::DescribeEngineVersionsError)
    pub fn describe_engine_versions(&self) -> fluent_builders::DescribeEngineVersions {
        fluent_builders::DescribeEngineVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeEvents`](crate::client::fluent_builders::DescribeEvents) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`source_name(impl Into<String>)`](crate::client::fluent_builders::DescribeEvents::source_name) / [`set_source_name(Option<String>)`](crate::client::fluent_builders::DescribeEvents::set_source_name): <p>The identifier of the event source for which events are returned. If not specified, all sources are included in the response.</p>
    ///   - [`source_type(SourceType)`](crate::client::fluent_builders::DescribeEvents::source_type) / [`set_source_type(Option<SourceType>)`](crate::client::fluent_builders::DescribeEvents::set_source_type): <p>The event source to retrieve events for. If no value is specified, all events are returned.</p>
    ///   - [`start_time(DateTime)`](crate::client::fluent_builders::DescribeEvents::start_time) / [`set_start_time(Option<DateTime>)`](crate::client::fluent_builders::DescribeEvents::set_start_time): <p>The beginning of the time interval to retrieve events for, specified in ISO 8601 format. Example: 2017-03-30T07:03:49.555Z</p>
    ///   - [`end_time(DateTime)`](crate::client::fluent_builders::DescribeEvents::end_time) / [`set_end_time(Option<DateTime>)`](crate::client::fluent_builders::DescribeEvents::set_end_time): <p>The end of the time interval for which to retrieve events, specified in ISO 8601 format. Example: 2017-03-30T07:03:49.555Z</p>
    ///   - [`duration(i32)`](crate::client::fluent_builders::DescribeEvents::duration) / [`set_duration(Option<i32>)`](crate::client::fluent_builders::DescribeEvents::set_duration): <p>The number of minutes worth of events to retrieve.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeEvents::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeEvents::set_max_results): <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeEvents::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeEvents::set_next_token): <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
    /// - On success, responds with [`DescribeEventsOutput`](crate::output::DescribeEventsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::DescribeEventsOutput::next_token): <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
    ///   - [`events(Option<Vec<Event>>)`](crate::output::DescribeEventsOutput::events): <p>A list of events. Each element in the list contains detailed information about one event.</p>
    /// - On failure, responds with [`SdkError<DescribeEventsError>`](crate::error::DescribeEventsError)
    pub fn describe_events(&self) -> fluent_builders::DescribeEvents {
        fluent_builders::DescribeEvents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeParameterGroups`](crate::client::fluent_builders::DescribeParameterGroups) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::DescribeParameterGroups::parameter_group_name) / [`set_parameter_group_name(Option<String>)`](crate::client::fluent_builders::DescribeParameterGroups::set_parameter_group_name): <p>The name of a specific parameter group to return details for.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeParameterGroups::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeParameterGroups::set_max_results): <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeParameterGroups::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeParameterGroups::set_next_token): <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
    /// - On success, responds with [`DescribeParameterGroupsOutput`](crate::output::DescribeParameterGroupsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::DescribeParameterGroupsOutput::next_token): <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
    ///   - [`parameter_groups(Option<Vec<ParameterGroup>>)`](crate::output::DescribeParameterGroupsOutput::parameter_groups): <p>A list of parameter groups. Each element in the list contains detailed information about one parameter group.</p>
    /// - On failure, responds with [`SdkError<DescribeParameterGroupsError>`](crate::error::DescribeParameterGroupsError)
    pub fn describe_parameter_groups(&self) -> fluent_builders::DescribeParameterGroups {
        fluent_builders::DescribeParameterGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeParameters`](crate::client::fluent_builders::DescribeParameters) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::DescribeParameters::parameter_group_name) / [`set_parameter_group_name(Option<String>)`](crate::client::fluent_builders::DescribeParameters::set_parameter_group_name): <p>he name of a specific parameter group to return details for.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeParameters::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeParameters::set_max_results): <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeParameters::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeParameters::set_next_token): <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
    /// - On success, responds with [`DescribeParametersOutput`](crate::output::DescribeParametersOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::DescribeParametersOutput::next_token): <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
    ///   - [`parameters(Option<Vec<Parameter>>)`](crate::output::DescribeParametersOutput::parameters): <p>A list of parameters specific to a particular parameter group. Each element in the list contains detailed information about one parameter.</p>
    /// - On failure, responds with [`SdkError<DescribeParametersError>`](crate::error::DescribeParametersError)
    pub fn describe_parameters(&self) -> fluent_builders::DescribeParameters {
        fluent_builders::DescribeParameters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeServiceUpdates`](crate::client::fluent_builders::DescribeServiceUpdates) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`service_update_name(impl Into<String>)`](crate::client::fluent_builders::DescribeServiceUpdates::service_update_name) / [`set_service_update_name(Option<String>)`](crate::client::fluent_builders::DescribeServiceUpdates::set_service_update_name): <p>The unique ID of the service update to describe.</p>
    ///   - [`cluster_names(Vec<String>)`](crate::client::fluent_builders::DescribeServiceUpdates::cluster_names) / [`set_cluster_names(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeServiceUpdates::set_cluster_names): <p>The list of cluster names to identify service updates to apply</p>
    ///   - [`status(Vec<ServiceUpdateStatus>)`](crate::client::fluent_builders::DescribeServiceUpdates::status) / [`set_status(Option<Vec<ServiceUpdateStatus>>)`](crate::client::fluent_builders::DescribeServiceUpdates::set_status): <p>The status(es) of the service updates to filter on</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeServiceUpdates::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeServiceUpdates::set_max_results): <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeServiceUpdates::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeServiceUpdates::set_next_token): <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
    /// - On success, responds with [`DescribeServiceUpdatesOutput`](crate::output::DescribeServiceUpdatesOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::DescribeServiceUpdatesOutput::next_token): <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
    ///   - [`service_updates(Option<Vec<ServiceUpdate>>)`](crate::output::DescribeServiceUpdatesOutput::service_updates): <p>A list of service updates</p>
    /// - On failure, responds with [`SdkError<DescribeServiceUpdatesError>`](crate::error::DescribeServiceUpdatesError)
    pub fn describe_service_updates(&self) -> fluent_builders::DescribeServiceUpdates {
        fluent_builders::DescribeServiceUpdates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeSnapshots`](crate::client::fluent_builders::DescribeSnapshots) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_name(impl Into<String>)`](crate::client::fluent_builders::DescribeSnapshots::cluster_name) / [`set_cluster_name(Option<String>)`](crate::client::fluent_builders::DescribeSnapshots::set_cluster_name): <p>A user-supplied cluster identifier. If this parameter is specified, only snapshots associated with that specific cluster are described.</p>
    ///   - [`snapshot_name(impl Into<String>)`](crate::client::fluent_builders::DescribeSnapshots::snapshot_name) / [`set_snapshot_name(Option<String>)`](crate::client::fluent_builders::DescribeSnapshots::set_snapshot_name): <p>A user-supplied name of the snapshot. If this parameter is specified, only this named snapshot is described.</p>
    ///   - [`source(impl Into<String>)`](crate::client::fluent_builders::DescribeSnapshots::source) / [`set_source(Option<String>)`](crate::client::fluent_builders::DescribeSnapshots::set_source): <p>If set to system, the output shows snapshots that were automatically created by MemoryDB. If set to user the output shows snapshots that were manually created. If omitted, the output shows both automatically and manually created snapshots.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeSnapshots::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeSnapshots::set_next_token): <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeSnapshots::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeSnapshots::set_max_results): <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
    ///   - [`show_detail(bool)`](crate::client::fluent_builders::DescribeSnapshots::show_detail) / [`set_show_detail(Option<bool>)`](crate::client::fluent_builders::DescribeSnapshots::set_show_detail): <p>A Boolean value which if true, the shard configuration is included in the snapshot description.</p>
    /// - On success, responds with [`DescribeSnapshotsOutput`](crate::output::DescribeSnapshotsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::DescribeSnapshotsOutput::next_token): <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
    ///   - [`snapshots(Option<Vec<Snapshot>>)`](crate::output::DescribeSnapshotsOutput::snapshots): <p>A list of snapshots. Each item in the list contains detailed information about one snapshot.</p>
    /// - On failure, responds with [`SdkError<DescribeSnapshotsError>`](crate::error::DescribeSnapshotsError)
    pub fn describe_snapshots(&self) -> fluent_builders::DescribeSnapshots {
        fluent_builders::DescribeSnapshots::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeSubnetGroups`](crate::client::fluent_builders::DescribeSubnetGroups) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`subnet_group_name(impl Into<String>)`](crate::client::fluent_builders::DescribeSubnetGroups::subnet_group_name) / [`set_subnet_group_name(Option<String>)`](crate::client::fluent_builders::DescribeSubnetGroups::set_subnet_group_name): <p>The name of the subnet group to return details for.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeSubnetGroups::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeSubnetGroups::set_max_results): <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeSubnetGroups::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeSubnetGroups::set_next_token): <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
    /// - On success, responds with [`DescribeSubnetGroupsOutput`](crate::output::DescribeSubnetGroupsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::DescribeSubnetGroupsOutput::next_token): <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
    ///   - [`subnet_groups(Option<Vec<SubnetGroup>>)`](crate::output::DescribeSubnetGroupsOutput::subnet_groups): <p>A list of subnet groups. Each element in the list contains detailed information about one group.</p>
    /// - On failure, responds with [`SdkError<DescribeSubnetGroupsError>`](crate::error::DescribeSubnetGroupsError)
    pub fn describe_subnet_groups(&self) -> fluent_builders::DescribeSubnetGroups {
        fluent_builders::DescribeSubnetGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeUsers`](crate::client::fluent_builders::DescribeUsers) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_name(impl Into<String>)`](crate::client::fluent_builders::DescribeUsers::user_name) / [`set_user_name(Option<String>)`](crate::client::fluent_builders::DescribeUsers::set_user_name): <p>The name of the user</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeUsers::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeUsers::set_filters): <p>Filter to determine the list of users to return.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeUsers::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeUsers::set_max_results): <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeUsers::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeUsers::set_next_token): <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
    /// - On success, responds with [`DescribeUsersOutput`](crate::output::DescribeUsersOutput) with field(s):
    ///   - [`users(Option<Vec<User>>)`](crate::output::DescribeUsersOutput::users): <p>A list of users.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeUsersOutput::next_token): <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
    /// - On failure, responds with [`SdkError<DescribeUsersError>`](crate::error::DescribeUsersError)
    pub fn describe_users(&self) -> fluent_builders::DescribeUsers {
        fluent_builders::DescribeUsers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`FailoverShard`](crate::client::fluent_builders::FailoverShard) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_name(impl Into<String>)`](crate::client::fluent_builders::FailoverShard::cluster_name) / [`set_cluster_name(Option<String>)`](crate::client::fluent_builders::FailoverShard::set_cluster_name): <p>The cluster being failed over</p>
    ///   - [`shard_name(impl Into<String>)`](crate::client::fluent_builders::FailoverShard::shard_name) / [`set_shard_name(Option<String>)`](crate::client::fluent_builders::FailoverShard::set_shard_name): <p>The name of the shard</p>
    /// - On success, responds with [`FailoverShardOutput`](crate::output::FailoverShardOutput) with field(s):
    ///   - [`cluster(Option<Cluster>)`](crate::output::FailoverShardOutput::cluster): <p>The cluster being failed over</p>
    /// - On failure, responds with [`SdkError<FailoverShardError>`](crate::error::FailoverShardError)
    pub fn failover_shard(&self) -> fluent_builders::FailoverShard {
        fluent_builders::FailoverShard::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAllowedNodeTypeUpdates`](crate::client::fluent_builders::ListAllowedNodeTypeUpdates) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_name(impl Into<String>)`](crate::client::fluent_builders::ListAllowedNodeTypeUpdates::cluster_name) / [`set_cluster_name(Option<String>)`](crate::client::fluent_builders::ListAllowedNodeTypeUpdates::set_cluster_name): <p>The name of the cluster you want to scale. MemoryDB uses the cluster name to identify the current node type being used by this cluster, and from that to create a list of node types you can scale up to.</p>
    /// - On success, responds with [`ListAllowedNodeTypeUpdatesOutput`](crate::output::ListAllowedNodeTypeUpdatesOutput) with field(s):
    ///   - [`scale_up_node_types(Option<Vec<String>>)`](crate::output::ListAllowedNodeTypeUpdatesOutput::scale_up_node_types): <p>A list node types which you can use to scale up your cluster.</p>
    ///   - [`scale_down_node_types(Option<Vec<String>>)`](crate::output::ListAllowedNodeTypeUpdatesOutput::scale_down_node_types): <p>A list node types which you can use to scale down your cluster.</p>
    /// - On failure, responds with [`SdkError<ListAllowedNodeTypeUpdatesError>`](crate::error::ListAllowedNodeTypeUpdatesError)
    pub fn list_allowed_node_type_updates(&self) -> fluent_builders::ListAllowedNodeTypeUpdates {
        fluent_builders::ListAllowedNodeTypeUpdates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTags`](crate::client::fluent_builders::ListTags) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTags::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTags::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource for which you want the list of tags</p>
    /// - On success, responds with [`ListTagsOutput`](crate::output::ListTagsOutput) with field(s):
    ///   - [`tag_list(Option<Vec<Tag>>)`](crate::output::ListTagsOutput::tag_list): <p>A list of tags as key-value pairs.</p>
    /// - On failure, responds with [`SdkError<ListTagsError>`](crate::error::ListTagsError)
    pub fn list_tags(&self) -> fluent_builders::ListTags {
        fluent_builders::ListTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ResetParameterGroup`](crate::client::fluent_builders::ResetParameterGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::ResetParameterGroup::parameter_group_name) / [`set_parameter_group_name(Option<String>)`](crate::client::fluent_builders::ResetParameterGroup::set_parameter_group_name): <p>The name of the parameter group to reset.</p>
    ///   - [`all_parameters(bool)`](crate::client::fluent_builders::ResetParameterGroup::all_parameters) / [`set_all_parameters(bool)`](crate::client::fluent_builders::ResetParameterGroup::set_all_parameters): <p>If true, all parameters in the parameter group are reset to their default values. If false, only the parameters listed by ParameterNames are reset to their default values.</p>
    ///   - [`parameter_names(Vec<String>)`](crate::client::fluent_builders::ResetParameterGroup::parameter_names) / [`set_parameter_names(Option<Vec<String>>)`](crate::client::fluent_builders::ResetParameterGroup::set_parameter_names): <p>An array of parameter names to reset to their default values. If AllParameters is true, do not use ParameterNames. If AllParameters is false, you must specify the name of at least one parameter to reset.</p>
    /// - On success, responds with [`ResetParameterGroupOutput`](crate::output::ResetParameterGroupOutput) with field(s):
    ///   - [`parameter_group(Option<ParameterGroup>)`](crate::output::ResetParameterGroupOutput::parameter_group): <p>The parameter group being reset.</p>
    /// - On failure, responds with [`SdkError<ResetParameterGroupError>`](crate::error::ResetParameterGroupError)
    pub fn reset_parameter_group(&self) -> fluent_builders::ResetParameterGroup {
        fluent_builders::ResetParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource to which the tags are to be added</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput) with field(s):
    ///   - [`tag_list(Option<Vec<Tag>>)`](crate::output::TagResourceOutput::tag_list): <p>A list of tags as key-value pairs.</p>
    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource to which the tags are to be removed</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The list of keys of the tags that are to be removed</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput) with field(s):
    ///   - [`tag_list(Option<Vec<Tag>>)`](crate::output::UntagResourceOutput::tag_list): <p>The list of tags removed</p>
    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateACL`](crate::client::fluent_builders::UpdateACL) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`acl_name(impl Into<String>)`](crate::client::fluent_builders::UpdateACL::acl_name) / [`set_acl_name(Option<String>)`](crate::client::fluent_builders::UpdateACL::set_acl_name): <p>The name of the Access Control List</p>
    ///   - [`user_names_to_add(Vec<String>)`](crate::client::fluent_builders::UpdateACL::user_names_to_add) / [`set_user_names_to_add(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateACL::set_user_names_to_add): <p>The list of users to add to the Access Control List</p>
    ///   - [`user_names_to_remove(Vec<String>)`](crate::client::fluent_builders::UpdateACL::user_names_to_remove) / [`set_user_names_to_remove(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateACL::set_user_names_to_remove): <p>The list of users to remove from the Access Control List</p>
    /// - On success, responds with [`UpdateAclOutput`](crate::output::UpdateAclOutput) with field(s):
    ///   - [`acl(Option<Acl>)`](crate::output::UpdateAclOutput::acl): <p>The updated Access Control List</p>
    /// - On failure, responds with [`SdkError<UpdateACLError>`](crate::error::UpdateACLError)
    pub fn update_acl(&self) -> fluent_builders::UpdateACL {
        fluent_builders::UpdateACL::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateCluster`](crate::client::fluent_builders::UpdateCluster) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_name(impl Into<String>)`](crate::client::fluent_builders::UpdateCluster::cluster_name) / [`set_cluster_name(Option<String>)`](crate::client::fluent_builders::UpdateCluster::set_cluster_name): <p>The name of the cluster to update</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateCluster::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateCluster::set_description): <p>The description of the cluster to update</p>
    ///   - [`security_group_ids(Vec<String>)`](crate::client::fluent_builders::UpdateCluster::security_group_ids) / [`set_security_group_ids(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateCluster::set_security_group_ids): <p>The SecurityGroupIds to update</p>
    ///   - [`maintenance_window(impl Into<String>)`](crate::client::fluent_builders::UpdateCluster::maintenance_window) / [`set_maintenance_window(Option<String>)`](crate::client::fluent_builders::UpdateCluster::set_maintenance_window): <p>The maintenance window to update</p>
    ///   - [`sns_topic_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateCluster::sns_topic_arn) / [`set_sns_topic_arn(Option<String>)`](crate::client::fluent_builders::UpdateCluster::set_sns_topic_arn): <p>The SNS topic ARN to update</p>
    ///   - [`sns_topic_status(impl Into<String>)`](crate::client::fluent_builders::UpdateCluster::sns_topic_status) / [`set_sns_topic_status(Option<String>)`](crate::client::fluent_builders::UpdateCluster::set_sns_topic_status): <p>The status of the Amazon SNS notification topic. Notifications are sent only if the status is active.</p>
    ///   - [`parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::UpdateCluster::parameter_group_name) / [`set_parameter_group_name(Option<String>)`](crate::client::fluent_builders::UpdateCluster::set_parameter_group_name): <p>The name of the parameter group to update</p>
    ///   - [`snapshot_window(impl Into<String>)`](crate::client::fluent_builders::UpdateCluster::snapshot_window) / [`set_snapshot_window(Option<String>)`](crate::client::fluent_builders::UpdateCluster::set_snapshot_window): <p>The daily time range (in UTC) during which MemoryDB begins taking a daily snapshot of your cluster.</p>
    ///   - [`snapshot_retention_limit(i32)`](crate::client::fluent_builders::UpdateCluster::snapshot_retention_limit) / [`set_snapshot_retention_limit(Option<i32>)`](crate::client::fluent_builders::UpdateCluster::set_snapshot_retention_limit): <p>The number of days for which MemoryDB retains automatic cluster snapshots before deleting them. For example, if you set SnapshotRetentionLimit to 5, a snapshot that was taken today is retained for 5 days before being deleted.</p>
    ///   - [`node_type(impl Into<String>)`](crate::client::fluent_builders::UpdateCluster::node_type) / [`set_node_type(Option<String>)`](crate::client::fluent_builders::UpdateCluster::set_node_type): <p>A valid node type that you want to scale this cluster up or down to.</p>
    ///   - [`engine_version(impl Into<String>)`](crate::client::fluent_builders::UpdateCluster::engine_version) / [`set_engine_version(Option<String>)`](crate::client::fluent_builders::UpdateCluster::set_engine_version): <p>The upgraded version of the engine to be run on the nodes. You can upgrade to a newer engine version, but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing cluster and create it anew with the earlier engine version.</p>
    ///   - [`replica_configuration(ReplicaConfigurationRequest)`](crate::client::fluent_builders::UpdateCluster::replica_configuration) / [`set_replica_configuration(Option<ReplicaConfigurationRequest>)`](crate::client::fluent_builders::UpdateCluster::set_replica_configuration): <p>The number of replicas that will reside in each shard</p>
    ///   - [`shard_configuration(ShardConfigurationRequest)`](crate::client::fluent_builders::UpdateCluster::shard_configuration) / [`set_shard_configuration(Option<ShardConfigurationRequest>)`](crate::client::fluent_builders::UpdateCluster::set_shard_configuration): <p>The number of shards in the cluster</p>
    ///   - [`acl_name(impl Into<String>)`](crate::client::fluent_builders::UpdateCluster::acl_name) / [`set_acl_name(Option<String>)`](crate::client::fluent_builders::UpdateCluster::set_acl_name): <p>The Access Control List that is associated with the cluster</p>
    /// - On success, responds with [`UpdateClusterOutput`](crate::output::UpdateClusterOutput) with field(s):
    ///   - [`cluster(Option<Cluster>)`](crate::output::UpdateClusterOutput::cluster): <p>The updated cluster</p>
    /// - On failure, responds with [`SdkError<UpdateClusterError>`](crate::error::UpdateClusterError)
    pub fn update_cluster(&self) -> fluent_builders::UpdateCluster {
        fluent_builders::UpdateCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateParameterGroup`](crate::client::fluent_builders::UpdateParameterGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::UpdateParameterGroup::parameter_group_name) / [`set_parameter_group_name(Option<String>)`](crate::client::fluent_builders::UpdateParameterGroup::set_parameter_group_name): <p>The name of the parameter group to update.</p>
    ///   - [`parameter_name_values(Vec<ParameterNameValue>)`](crate::client::fluent_builders::UpdateParameterGroup::parameter_name_values) / [`set_parameter_name_values(Option<Vec<ParameterNameValue>>)`](crate::client::fluent_builders::UpdateParameterGroup::set_parameter_name_values): <p>An array of parameter names and values for the parameter update. You must supply at least one parameter name and value; subsequent arguments are optional. A maximum of 20 parameters may be updated per request.</p>
    /// - On success, responds with [`UpdateParameterGroupOutput`](crate::output::UpdateParameterGroupOutput) with field(s):
    ///   - [`parameter_group(Option<ParameterGroup>)`](crate::output::UpdateParameterGroupOutput::parameter_group): <p>The updated parameter group</p>
    /// - On failure, responds with [`SdkError<UpdateParameterGroupError>`](crate::error::UpdateParameterGroupError)
    pub fn update_parameter_group(&self) -> fluent_builders::UpdateParameterGroup {
        fluent_builders::UpdateParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateSubnetGroup`](crate::client::fluent_builders::UpdateSubnetGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`subnet_group_name(impl Into<String>)`](crate::client::fluent_builders::UpdateSubnetGroup::subnet_group_name) / [`set_subnet_group_name(Option<String>)`](crate::client::fluent_builders::UpdateSubnetGroup::set_subnet_group_name): <p>The name of the subnet group</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateSubnetGroup::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateSubnetGroup::set_description): <p>A description of the subnet group</p>
    ///   - [`subnet_ids(Vec<String>)`](crate::client::fluent_builders::UpdateSubnetGroup::subnet_ids) / [`set_subnet_ids(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateSubnetGroup::set_subnet_ids): <p>The EC2 subnet IDs for the subnet group.</p>
    /// - On success, responds with [`UpdateSubnetGroupOutput`](crate::output::UpdateSubnetGroupOutput) with field(s):
    ///   - [`subnet_group(Option<SubnetGroup>)`](crate::output::UpdateSubnetGroupOutput::subnet_group): <p>The updated subnet group</p>
    /// - On failure, responds with [`SdkError<UpdateSubnetGroupError>`](crate::error::UpdateSubnetGroupError)
    pub fn update_subnet_group(&self) -> fluent_builders::UpdateSubnetGroup {
        fluent_builders::UpdateSubnetGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateUser`](crate::client::fluent_builders::UpdateUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_name(impl Into<String>)`](crate::client::fluent_builders::UpdateUser::user_name) / [`set_user_name(Option<String>)`](crate::client::fluent_builders::UpdateUser::set_user_name): <p>The name of the user</p>
    ///   - [`authentication_mode(AuthenticationMode)`](crate::client::fluent_builders::UpdateUser::authentication_mode) / [`set_authentication_mode(Option<AuthenticationMode>)`](crate::client::fluent_builders::UpdateUser::set_authentication_mode): <p>Denotes the user's authentication properties, such as whether it requires a password to authenticate.</p>
    ///   - [`access_string(impl Into<String>)`](crate::client::fluent_builders::UpdateUser::access_string) / [`set_access_string(Option<String>)`](crate::client::fluent_builders::UpdateUser::set_access_string): <p>Access permissions string used for this user.</p>
    /// - On success, responds with [`UpdateUserOutput`](crate::output::UpdateUserOutput) with field(s):
    ///   - [`user(Option<User>)`](crate::output::UpdateUserOutput::user): <p>The updated user</p>
    /// - On failure, responds with [`SdkError<UpdateUserError>`](crate::error::UpdateUserError)
    pub fn update_user(&self) -> fluent_builders::UpdateUser {
        fluent_builders::UpdateUser::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `BatchUpdateCluster`.
    ///
    /// <p>Apply the service update to a list of clusters supplied. For more information on service updates and applying them, see <a href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/managing-updates.html#applying-updates">Applying the service updates</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchUpdateCluster {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_update_cluster_input::Builder,
    }
    impl BatchUpdateCluster {
        /// Creates a new `BatchUpdateCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchUpdateClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchUpdateClusterError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `ClusterNames`.
        ///
        /// To override the contents of this collection use [`set_cluster_names`](Self::set_cluster_names).
        ///
        /// <p>The cluster names to apply the updates.</p>
        pub fn cluster_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_names(input.into());
            self
        }
        /// <p>The cluster names to apply the updates.</p>
        pub fn set_cluster_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_cluster_names(input);
            self
        }
        /// <p>The unique ID of the service update</p>
        pub fn service_update(mut self, input: crate::model::ServiceUpdateRequest) -> Self {
            self.inner = self.inner.service_update(input);
            self
        }
        /// <p>The unique ID of the service update</p>
        pub fn set_service_update(
            mut self,
            input: std::option::Option<crate::model::ServiceUpdateRequest>,
        ) -> Self {
            self.inner = self.inner.set_service_update(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CopySnapshot`.
    ///
    /// <p>Makes a copy of an existing snapshot.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CopySnapshot {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::copy_snapshot_input::Builder,
    }
    impl CopySnapshot {
        /// Creates a new `CopySnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CopySnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::CopySnapshotError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of an existing snapshot from which to make a copy.</p>
        pub fn source_snapshot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_snapshot_name(input.into());
            self
        }
        /// <p>The name of an existing snapshot from which to make a copy.</p>
        pub fn set_source_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_snapshot_name(input);
            self
        }
        /// <p>A name for the snapshot copy. MemoryDB does not permit overwriting a snapshot, therefore this name must be unique within its context - MemoryDB or an Amazon S3 bucket if exporting.</p>
        pub fn target_snapshot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_snapshot_name(input.into());
            self
        }
        /// <p>A name for the snapshot copy. MemoryDB does not permit overwriting a snapshot, therefore this name must be unique within its context - MemoryDB or an Amazon S3 bucket if exporting.</p>
        pub fn set_target_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_snapshot_name(input);
            self
        }
        /// <p>The Amazon S3 bucket to which the snapshot is exported. This parameter is used only when exporting a snapshot for external access. When using this parameter to export a snapshot, be sure MemoryDB has the needed permissions to this S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/snapshots-exporting.html">Step 2: Grant MemoryDB Access to Your Amazon S3 Bucket</a>. </p>
        pub fn target_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_bucket(input.into());
            self
        }
        /// <p>The Amazon S3 bucket to which the snapshot is exported. This parameter is used only when exporting a snapshot for external access. When using this parameter to export a snapshot, be sure MemoryDB has the needed permissions to this S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/snapshots-exporting.html">Step 2: Grant MemoryDB Access to Your Amazon S3 Bucket</a>. </p>
        pub fn set_target_bucket(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_bucket(input);
            self
        }
        /// <p>The ID of the KMS key used to encrypt the target snapshot.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(input.into());
            self
        }
        /// <p>The ID of the KMS key used to encrypt the target snapshot.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateACL`.
    ///
    /// <p>Creates an Access Control List. For more information, see <a href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/clusters.acls.html">Authenticating users with Access Contol Lists (ACLs)</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateACL {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_acl_input::Builder,
    }
    impl CreateACL {
        /// Creates a new `CreateACL`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAclOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateACLError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Access Control List.</p>
        pub fn acl_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.acl_name(input.into());
            self
        }
        /// <p>The name of the Access Control List.</p>
        pub fn set_acl_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_acl_name(input);
            self
        }
        /// Appends an item to `UserNames`.
        ///
        /// To override the contents of this collection use [`set_user_names`](Self::set_user_names).
        ///
        /// <p>The list of users that belong to the Access Control List.</p>
        pub fn user_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_names(input.into());
            self
        }
        /// <p>The list of users that belong to the Access Control List.</p>
        pub fn set_user_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_user_names(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCluster`.
    ///
    /// <p>Creates a cluster. All nodes in the cluster run the same protocol-compliant engine software.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateCluster {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_cluster_input::Builder,
    }
    impl CreateCluster {
        /// Creates a new `CreateCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateClusterError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the cluster. This value must be unique as it also serves as the cluster identifier.</p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_name(input.into());
            self
        }
        /// <p>The name of the cluster. This value must be unique as it also serves as the cluster identifier.</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_name(input);
            self
        }
        /// <p>The compute and memory capacity of the nodes in the cluster.</p>
        pub fn node_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.node_type(input.into());
            self
        }
        /// <p>The compute and memory capacity of the nodes in the cluster.</p>
        pub fn set_node_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_node_type(input);
            self
        }
        /// <p>The name of the parameter group associated with the cluster.</p>
        pub fn parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parameter_group_name(input.into());
            self
        }
        /// <p>The name of the parameter group associated with the cluster.</p>
        pub fn set_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parameter_group_name(input);
            self
        }
        /// <p>An optional description of the cluster.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>An optional description of the cluster.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The number of shards the cluster will contain. The default value is 1. </p>
        pub fn num_shards(mut self, input: i32) -> Self {
            self.inner = self.inner.num_shards(input);
            self
        }
        /// <p>The number of shards the cluster will contain. The default value is 1. </p>
        pub fn set_num_shards(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_num_shards(input);
            self
        }
        /// <p>The number of replicas to apply to each shard. The default value is 1. The maximum is 5. </p>
        pub fn num_replicas_per_shard(mut self, input: i32) -> Self {
            self.inner = self.inner.num_replicas_per_shard(input);
            self
        }
        /// <p>The number of replicas to apply to each shard. The default value is 1. The maximum is 5. </p>
        pub fn set_num_replicas_per_shard(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_num_replicas_per_shard(input);
            self
        }
        /// <p>The name of the subnet group to be used for the cluster.</p>
        pub fn subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_group_name(input.into());
            self
        }
        /// <p>The name of the subnet group to be used for the cluster.</p>
        pub fn set_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subnet_group_name(input);
            self
        }
        /// Appends an item to `SecurityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>A list of security group names to associate with this cluster.</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_group_ids(input.into());
            self
        }
        /// <p>A list of security group names to associate with this cluster.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_security_group_ids(input);
            self
        }
        /// <p>Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format <code>ddd:hh24:mi-ddd:hh24:mi</code> (24H Clock UTC). The minimum maintenance window is a 60 minute period.</p>
        pub fn maintenance_window(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.maintenance_window(input.into());
            self
        }
        /// <p>Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format <code>ddd:hh24:mi-ddd:hh24:mi</code> (24H Clock UTC). The minimum maintenance window is a 60 minute period.</p>
        pub fn set_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_maintenance_window(input);
            self
        }
        /// <p>The port number on which each of the nodes accepts connections.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.inner = self.inner.port(input);
            self
        }
        /// <p>The port number on which each of the nodes accepts connections.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_port(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which notifications are sent.</p>
        pub fn sns_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sns_topic_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which notifications are sent.</p>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sns_topic_arn(input);
            self
        }
        /// <p>A flag to enable in-transit encryption on the cluster.</p>
        pub fn tls_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.tls_enabled(input);
            self
        }
        /// <p>A flag to enable in-transit encryption on the cluster.</p>
        pub fn set_tls_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_tls_enabled(input);
            self
        }
        /// <p>The ID of the KMS key used to encrypt the cluster.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(input.into());
            self
        }
        /// <p>The ID of the KMS key used to encrypt the cluster.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// Appends an item to `SnapshotArns`.
        ///
        /// To override the contents of this collection use [`set_snapshot_arns`](Self::set_snapshot_arns).
        ///
        /// <p>A list of Amazon Resource Names (ARN) that uniquely identify the RDB snapshot files stored in Amazon S3. The snapshot files are used to populate the new cluster. The Amazon S3 object name in the ARN cannot contain any commas.</p>
        pub fn snapshot_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_arns(input.into());
            self
        }
        /// <p>A list of Amazon Resource Names (ARN) that uniquely identify the RDB snapshot files stored in Amazon S3. The snapshot files are used to populate the new cluster. The Amazon S3 object name in the ARN cannot contain any commas.</p>
        pub fn set_snapshot_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_arns(input);
            self
        }
        /// <p>The name of a snapshot from which to restore data into the new cluster. The snapshot status changes to restoring while the new cluster is being created.</p>
        pub fn snapshot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_name(input.into());
            self
        }
        /// <p>The name of a snapshot from which to restore data into the new cluster. The snapshot status changes to restoring while the new cluster is being created.</p>
        pub fn set_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_name(input);
            self
        }
        /// <p>The number of days for which MemoryDB retains automatic snapshots before deleting them. For example, if you set SnapshotRetentionLimit to 5, a snapshot that was taken today is retained for 5 days before being deleted.</p>
        pub fn snapshot_retention_limit(mut self, input: i32) -> Self {
            self.inner = self.inner.snapshot_retention_limit(input);
            self
        }
        /// <p>The number of days for which MemoryDB retains automatic snapshots before deleting them. For example, if you set SnapshotRetentionLimit to 5, a snapshot that was taken today is retained for 5 days before being deleted.</p>
        pub fn set_snapshot_retention_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_snapshot_retention_limit(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to be added to this resource. Tags are comma-separated key,value pairs (e.g. Key=myKey, Value=myKeyValue. You can include multiple tags as shown following: Key=myKey, Value=myKeyValue Key=mySecondKey, Value=mySecondKeyValue.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tags to be added to this resource. Tags are comma-separated key,value pairs (e.g. Key=myKey, Value=myKeyValue. You can include multiple tags as shown following: Key=myKey, Value=myKeyValue Key=mySecondKey, Value=mySecondKeyValue.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The daily time range (in UTC) during which MemoryDB begins taking a daily snapshot of your shard.</p>
        /// <p> Example: 05:00-09:00</p>
        /// <p> If you do not specify this parameter, MemoryDB automatically chooses an appropriate time range.</p>
        pub fn snapshot_window(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_window(input.into());
            self
        }
        /// <p>The daily time range (in UTC) during which MemoryDB begins taking a daily snapshot of your shard.</p>
        /// <p> Example: 05:00-09:00</p>
        /// <p> If you do not specify this parameter, MemoryDB automatically chooses an appropriate time range.</p>
        pub fn set_snapshot_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_window(input);
            self
        }
        /// <p>The name of the Access Control List to associate with the cluster.</p>
        pub fn acl_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.acl_name(input.into());
            self
        }
        /// <p>The name of the Access Control List to associate with the cluster.</p>
        pub fn set_acl_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_acl_name(input);
            self
        }
        /// <p>The version number of the Redis engine to be used for the cluster.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_version(input.into());
            self
        }
        /// <p>The version number of the Redis engine to be used for the cluster.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engine_version(input);
            self
        }
        /// <p>When set to true, the cluster will automatically receive minor engine version upgrades after launch.</p>
        pub fn auto_minor_version_upgrade(mut self, input: bool) -> Self {
            self.inner = self.inner.auto_minor_version_upgrade(input);
            self
        }
        /// <p>When set to true, the cluster will automatically receive minor engine version upgrades after launch.</p>
        pub fn set_auto_minor_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_minor_version_upgrade(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateParameterGroup`.
    ///
    /// <p>Creates a new MemoryDB parameter group. A parameter group is a collection of parameters and their values that are applied to all of the nodes in any cluster. For more information, see <a href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/parametergroups.html">Configuring engine parameters using parameter groups</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateParameterGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_parameter_group_input::Builder,
    }
    impl CreateParameterGroup {
        /// Creates a new `CreateParameterGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateParameterGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateParameterGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the parameter group.</p>
        pub fn parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parameter_group_name(input.into());
            self
        }
        /// <p>The name of the parameter group.</p>
        pub fn set_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parameter_group_name(input);
            self
        }
        /// <p>The name of the parameter group family that the parameter group can be used with.</p>
        pub fn family(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.family(input.into());
            self
        }
        /// <p>The name of the parameter group family that the parameter group can be used with.</p>
        pub fn set_family(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_family(input);
            self
        }
        /// <p>An optional description of the parameter group.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>An optional description of the parameter group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSnapshot`.
    ///
    /// <p>Creates a copy of an entire cluster at a specific moment in time.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateSnapshot {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_snapshot_input::Builder,
    }
    impl CreateSnapshot {
        /// Creates a new `CreateSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSnapshotError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The snapshot is created from this cluster.</p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_name(input.into());
            self
        }
        /// <p>The snapshot is created from this cluster.</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_name(input);
            self
        }
        /// <p>A name for the snapshot being created.</p>
        pub fn snapshot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_name(input.into());
            self
        }
        /// <p>A name for the snapshot being created.</p>
        pub fn set_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_name(input);
            self
        }
        /// <p>The ID of the KMS key used to encrypt the snapshot.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(input.into());
            self
        }
        /// <p>The ID of the KMS key used to encrypt the snapshot.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSubnetGroup`.
    ///
    /// <p>Creates a subnet group. A subnet group is a collection of subnets (typically private) that you can designate for your clusters running in an Amazon Virtual Private Cloud (VPC) environment. When you create a cluster in an Amazon VPC, you must specify a subnet group. MemoryDB uses that subnet group to choose a subnet and IP addresses within that subnet to associate with your nodes. For more information, see <a href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/subnetgroups.html">Subnets and subnet groups</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateSubnetGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_subnet_group_input::Builder,
    }
    impl CreateSubnetGroup {
        /// Creates a new `CreateSubnetGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSubnetGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSubnetGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the subnet group.</p>
        pub fn subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_group_name(input.into());
            self
        }
        /// <p>The name of the subnet group.</p>
        pub fn set_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subnet_group_name(input);
            self
        }
        /// <p>A description for the subnet group.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description for the subnet group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `SubnetIds`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>A list of VPC subnet IDs for the subnet group.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_ids(input.into());
            self
        }
        /// <p>A list of VPC subnet IDs for the subnet group.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subnet_ids(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateUser`.
    ///
    /// <p>Creates a MemoryDB user. For more information, see <a href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/clusters.acls.html">Authenticating users with Access Contol Lists (ACLs)</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateUser {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_user_input::Builder,
    }
    impl CreateUser {
        /// Creates a new `CreateUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateUserOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateUserError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the user. This value must be unique as it also serves as the user identifier.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(input.into());
            self
        }
        /// <p>The name of the user. This value must be unique as it also serves as the user identifier.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>Denotes the user's authentication properties, such as whether it requires a password to authenticate.</p>
        pub fn authentication_mode(mut self, input: crate::model::AuthenticationMode) -> Self {
            self.inner = self.inner.authentication_mode(input);
            self
        }
        /// <p>Denotes the user's authentication properties, such as whether it requires a password to authenticate.</p>
        pub fn set_authentication_mode(
            mut self,
            input: std::option::Option<crate::model::AuthenticationMode>,
        ) -> Self {
            self.inner = self.inner.set_authentication_mode(input);
            self
        }
        /// <p>Access permissions string used for this user.</p>
        pub fn access_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.access_string(input.into());
            self
        }
        /// <p>Access permissions string used for this user.</p>
        pub fn set_access_string(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_access_string(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteACL`.
    ///
    /// <p>Deletes an Access Control List. The ACL must first be disassociated from the cluster before it can be deleted. For more information, see <a href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/clusters.acls.html">Authenticating users with Access Contol Lists (ACLs)</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteACL {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_acl_input::Builder,
    }
    impl DeleteACL {
        /// Creates a new `DeleteACL`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAclOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteACLError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Access Control List to delete</p>
        pub fn acl_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.acl_name(input.into());
            self
        }
        /// <p>The name of the Access Control List to delete</p>
        pub fn set_acl_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_acl_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCluster`.
    ///
    /// <p>Deletes a cluster. It also deletes all associated nodes and node endpoints</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteCluster {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_cluster_input::Builder,
    }
    impl DeleteCluster {
        /// Creates a new `DeleteCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteClusterError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the cluster to be deleted</p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_name(input.into());
            self
        }
        /// <p>The name of the cluster to be deleted</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_name(input);
            self
        }
        /// <p>The user-supplied name of a final cluster snapshot. This is the unique name that identifies the snapshot. MemoryDB creates the snapshot, and then deletes the cluster immediately afterward.</p>
        pub fn final_snapshot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.final_snapshot_name(input.into());
            self
        }
        /// <p>The user-supplied name of a final cluster snapshot. This is the unique name that identifies the snapshot. MemoryDB creates the snapshot, and then deletes the cluster immediately afterward.</p>
        pub fn set_final_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_final_snapshot_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteParameterGroup`.
    ///
    /// <p>Deletes the specified parameter group. You cannot delete a parameter group if it is associated with any clusters. You cannot delete the default parameter groups in your account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteParameterGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_parameter_group_input::Builder,
    }
    impl DeleteParameterGroup {
        /// Creates a new `DeleteParameterGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteParameterGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteParameterGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the parameter group to delete.</p>
        pub fn parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parameter_group_name(input.into());
            self
        }
        /// <p>The name of the parameter group to delete.</p>
        pub fn set_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parameter_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSnapshot`.
    ///
    /// <p>Deletes an existing snapshot. When you receive a successful response from this operation, MemoryDB immediately begins deleting the snapshot; you cannot cancel or revert this operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteSnapshot {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_snapshot_input::Builder,
    }
    impl DeleteSnapshot {
        /// Creates a new `DeleteSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSnapshotError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the snapshot to delete</p>
        pub fn snapshot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_name(input.into());
            self
        }
        /// <p>The name of the snapshot to delete</p>
        pub fn set_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSubnetGroup`.
    ///
    /// <p>Deletes a subnet group. You cannot delete a default subnet group or one that is associated with any clusters.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteSubnetGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_subnet_group_input::Builder,
    }
    impl DeleteSubnetGroup {
        /// Creates a new `DeleteSubnetGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSubnetGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSubnetGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the subnet group to delete</p>
        pub fn subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_group_name(input.into());
            self
        }
        /// <p>The name of the subnet group to delete</p>
        pub fn set_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subnet_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteUser`.
    ///
    /// <p>Deletes a user. The user will be removed from all ACLs and in turn removed from all clusters.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteUser {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_user_input::Builder,
    }
    impl DeleteUser {
        /// Creates a new `DeleteUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteUserOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteUserError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the user to delete</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(input.into());
            self
        }
        /// <p>The name of the user to delete</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeACLs`.
    ///
    /// <p>Returns a list of ACLs</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeACLs {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_ac_ls_input::Builder,
    }
    impl DescribeACLs {
        /// Creates a new `DescribeACLs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAcLsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeACLsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the ACL</p>
        pub fn acl_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.acl_name(input.into());
            self
        }
        /// <p>The name of the ACL</p>
        pub fn set_acl_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_acl_name(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeClusters`.
    ///
    /// <p>Returns information about all provisioned clusters if no cluster identifier is specified, or about a specific cluster if a cluster name is supplied.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeClusters {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_clusters_input::Builder,
    }
    impl DescribeClusters {
        /// Creates a new `DescribeClusters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeClustersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeClustersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the cluster</p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_name(input.into());
            self
        }
        /// <p>The name of the cluster</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_name(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>An optional flag that can be included in the request to retrieve information about the individual shard(s).</p>
        pub fn show_shard_details(mut self, input: bool) -> Self {
            self.inner = self.inner.show_shard_details(input);
            self
        }
        /// <p>An optional flag that can be included in the request to retrieve information about the individual shard(s).</p>
        pub fn set_show_shard_details(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_show_shard_details(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEngineVersions`.
    ///
    /// <p>Returns a list of the available Redis engine versions.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEngineVersions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_engine_versions_input::Builder,
    }
    impl DescribeEngineVersions {
        /// Creates a new `DescribeEngineVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEngineVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEngineVersionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Redis engine version</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_version(input.into());
            self
        }
        /// <p>The Redis engine version</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engine_version(input);
            self
        }
        /// <p>The name of a specific parameter group family to return details for.</p>
        pub fn parameter_group_family(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parameter_group_family(input.into());
            self
        }
        /// <p>The name of a specific parameter group family to return details for.</p>
        pub fn set_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parameter_group_family(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>If true, specifies that only the default version of the specified engine or engine and major version combination is to be returned.</p>
        pub fn default_only(mut self, input: bool) -> Self {
            self.inner = self.inner.default_only(input);
            self
        }
        /// <p>If true, specifies that only the default version of the specified engine or engine and major version combination is to be returned.</p>
        pub fn set_default_only(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_default_only(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEvents`.
    ///
    /// <p>Returns events related to clusters, security groups, and parameter groups. You can obtain events specific to a particular cluster, security group, or parameter group by providing the name as a parameter. By default, only the events occurring within the last hour are returned; however, you can retrieve up to 14 days' worth of events if necessary.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEvents {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_events_input::Builder,
    }
    impl DescribeEvents {
        /// Creates a new `DescribeEvents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEventsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEventsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the event source for which events are returned. If not specified, all sources are included in the response.</p>
        pub fn source_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_name(input.into());
            self
        }
        /// <p>The identifier of the event source for which events are returned. If not specified, all sources are included in the response.</p>
        pub fn set_source_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source_name(input);
            self
        }
        /// <p>The event source to retrieve events for. If no value is specified, all events are returned.</p>
        pub fn source_type(mut self, input: crate::model::SourceType) -> Self {
            self.inner = self.inner.source_type(input);
            self
        }
        /// <p>The event source to retrieve events for. If no value is specified, all events are returned.</p>
        pub fn set_source_type(
            mut self,
            input: std::option::Option<crate::model::SourceType>,
        ) -> Self {
            self.inner = self.inner.set_source_type(input);
            self
        }
        /// <p>The beginning of the time interval to retrieve events for, specified in ISO 8601 format. Example: 2017-03-30T07:03:49.555Z</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(input);
            self
        }
        /// <p>The beginning of the time interval to retrieve events for, specified in ISO 8601 format. Example: 2017-03-30T07:03:49.555Z</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>The end of the time interval for which to retrieve events, specified in ISO 8601 format. Example: 2017-03-30T07:03:49.555Z</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(input);
            self
        }
        /// <p>The end of the time interval for which to retrieve events, specified in ISO 8601 format. Example: 2017-03-30T07:03:49.555Z</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>The number of minutes worth of events to retrieve.</p>
        pub fn duration(mut self, input: i32) -> Self {
            self.inner = self.inner.duration(input);
            self
        }
        /// <p>The number of minutes worth of events to retrieve.</p>
        pub fn set_duration(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_duration(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeParameterGroups`.
    ///
    /// <p>Returns a list of parameter group descriptions. If a parameter group name is specified, the list contains only the descriptions for that group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeParameterGroups {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_parameter_groups_input::Builder,
    }
    impl DescribeParameterGroups {
        /// Creates a new `DescribeParameterGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeParameterGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeParameterGroupsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of a specific parameter group to return details for.</p>
        pub fn parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parameter_group_name(input.into());
            self
        }
        /// <p>The name of a specific parameter group to return details for.</p>
        pub fn set_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parameter_group_name(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeParameters`.
    ///
    /// <p>Returns the detailed parameter list for a particular parameter group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeParameters {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_parameters_input::Builder,
    }
    impl DescribeParameters {
        /// Creates a new `DescribeParameters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeParametersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeParametersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>he name of a specific parameter group to return details for.</p>
        pub fn parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parameter_group_name(input.into());
            self
        }
        /// <p>he name of a specific parameter group to return details for.</p>
        pub fn set_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parameter_group_name(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeServiceUpdates`.
    ///
    /// <p>Returns details of the service updates</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeServiceUpdates {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_service_updates_input::Builder,
    }
    impl DescribeServiceUpdates {
        /// Creates a new `DescribeServiceUpdates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeServiceUpdatesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeServiceUpdatesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of the service update to describe.</p>
        pub fn service_update_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_update_name(input.into());
            self
        }
        /// <p>The unique ID of the service update to describe.</p>
        pub fn set_service_update_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_service_update_name(input);
            self
        }
        /// Appends an item to `ClusterNames`.
        ///
        /// To override the contents of this collection use [`set_cluster_names`](Self::set_cluster_names).
        ///
        /// <p>The list of cluster names to identify service updates to apply</p>
        pub fn cluster_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_names(input.into());
            self
        }
        /// <p>The list of cluster names to identify service updates to apply</p>
        pub fn set_cluster_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_cluster_names(input);
            self
        }
        /// Appends an item to `Status`.
        ///
        /// To override the contents of this collection use [`set_status`](Self::set_status).
        ///
        /// <p>The status(es) of the service updates to filter on</p>
        pub fn status(mut self, input: crate::model::ServiceUpdateStatus) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p>The status(es) of the service updates to filter on</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ServiceUpdateStatus>>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSnapshots`.
    ///
    /// <p>Returns information about cluster snapshots. By default, DescribeSnapshots lists all of your snapshots; it can optionally describe a single snapshot, or just the snapshots associated with a particular cluster.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeSnapshots {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_snapshots_input::Builder,
    }
    impl DescribeSnapshots {
        /// Creates a new `DescribeSnapshots`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSnapshotsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSnapshotsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A user-supplied cluster identifier. If this parameter is specified, only snapshots associated with that specific cluster are described.</p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_name(input.into());
            self
        }
        /// <p>A user-supplied cluster identifier. If this parameter is specified, only snapshots associated with that specific cluster are described.</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_name(input);
            self
        }
        /// <p>A user-supplied name of the snapshot. If this parameter is specified, only this named snapshot is described.</p>
        pub fn snapshot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_name(input.into());
            self
        }
        /// <p>A user-supplied name of the snapshot. If this parameter is specified, only this named snapshot is described.</p>
        pub fn set_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_name(input);
            self
        }
        /// <p>If set to system, the output shows snapshots that were automatically created by MemoryDB. If set to user the output shows snapshots that were manually created. If omitted, the output shows both automatically and manually created snapshots.</p>
        pub fn source(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source(input.into());
            self
        }
        /// <p>If set to system, the output shows snapshots that were automatically created by MemoryDB. If set to user the output shows snapshots that were manually created. If omitted, the output shows both automatically and manually created snapshots.</p>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source(input);
            self
        }
        /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A Boolean value which if true, the shard configuration is included in the snapshot description.</p>
        pub fn show_detail(mut self, input: bool) -> Self {
            self.inner = self.inner.show_detail(input);
            self
        }
        /// <p>A Boolean value which if true, the shard configuration is included in the snapshot description.</p>
        pub fn set_show_detail(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_show_detail(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSubnetGroups`.
    ///
    /// <p>Returns a list of subnet group descriptions. If a subnet group name is specified, the list contains only the description of that group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeSubnetGroups {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_subnet_groups_input::Builder,
    }
    impl DescribeSubnetGroups {
        /// Creates a new `DescribeSubnetGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSubnetGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSubnetGroupsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the subnet group to return details for.</p>
        pub fn subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_group_name(input.into());
            self
        }
        /// <p>The name of the subnet group to return details for.</p>
        pub fn set_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subnet_group_name(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeUsers`.
    ///
    /// <p>Returns a list of users.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeUsers {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_users_input::Builder,
    }
    impl DescribeUsers {
        /// Creates a new `DescribeUsers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeUsersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeUsersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the user</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(input.into());
            self
        }
        /// <p>The name of the user</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filter to determine the list of users to return.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Filter to determine the list of users to return.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `FailoverShard`.
    ///
    /// <p>Used to failover a shard</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct FailoverShard {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::failover_shard_input::Builder,
    }
    impl FailoverShard {
        /// Creates a new `FailoverShard`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::FailoverShardOutput,
            aws_smithy_http::result::SdkError<crate::error::FailoverShardError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The cluster being failed over</p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_name(input.into());
            self
        }
        /// <p>The cluster being failed over</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_name(input);
            self
        }
        /// <p>The name of the shard</p>
        pub fn shard_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.shard_name(input.into());
            self
        }
        /// <p>The name of the shard</p>
        pub fn set_shard_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_shard_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAllowedNodeTypeUpdates`.
    ///
    /// <p>Lists all available node types that you can scale to from your cluster's current node type. When you use the UpdateCluster operation to scale your cluster, the value of the NodeType parameter must be one of the node types returned by this operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAllowedNodeTypeUpdates {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_allowed_node_type_updates_input::Builder,
    }
    impl ListAllowedNodeTypeUpdates {
        /// Creates a new `ListAllowedNodeTypeUpdates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAllowedNodeTypeUpdatesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAllowedNodeTypeUpdatesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the cluster you want to scale. MemoryDB uses the cluster name to identify the current node type being used by this cluster, and from that to create a list of node types you can scale up to.</p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_name(input.into());
            self
        }
        /// <p>The name of the cluster you want to scale. MemoryDB uses the cluster name to identify the current node type being used by this cluster, and from that to create a list of node types you can scale up to.</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTags`.
    ///
    /// <p>Lists all tags currently on a named resource. A tag is a key-value pair where the key and value are case-sensitive. You can use tags to categorize and track your MemoryDB resources. For more information, see <a href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/Tagging-Resources.html">Tagging your MemoryDB resources</a> </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTags {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_input::Builder,
    }
    impl ListTags {
        /// Creates a new `ListTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource for which you want the list of tags</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource for which you want the list of tags</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ResetParameterGroup`.
    ///
    /// <p>Modifies the parameters of a parameter group to the engine or system default value. You can reset specific parameters by submitting a list of parameter names. To reset the entire parameter group, specify the AllParameters and ParameterGroupName parameters.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ResetParameterGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::reset_parameter_group_input::Builder,
    }
    impl ResetParameterGroup {
        /// Creates a new `ResetParameterGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ResetParameterGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::ResetParameterGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the parameter group to reset.</p>
        pub fn parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parameter_group_name(input.into());
            self
        }
        /// <p>The name of the parameter group to reset.</p>
        pub fn set_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parameter_group_name(input);
            self
        }
        /// <p>If true, all parameters in the parameter group are reset to their default values. If false, only the parameters listed by ParameterNames are reset to their default values.</p>
        pub fn all_parameters(mut self, input: bool) -> Self {
            self.inner = self.inner.all_parameters(input);
            self
        }
        /// <p>If true, all parameters in the parameter group are reset to their default values. If false, only the parameters listed by ParameterNames are reset to their default values.</p>
        pub fn set_all_parameters(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_all_parameters(input);
            self
        }
        /// Appends an item to `ParameterNames`.
        ///
        /// To override the contents of this collection use [`set_parameter_names`](Self::set_parameter_names).
        ///
        /// <p>An array of parameter names to reset to their default values. If AllParameters is true, do not use ParameterNames. If AllParameters is false, you must specify the name of at least one parameter to reset.</p>
        pub fn parameter_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parameter_names(input.into());
            self
        }
        /// <p>An array of parameter names to reset to their default values. If AllParameters is true, do not use ParameterNames. If AllParameters is false, you must specify the name of at least one parameter to reset.</p>
        pub fn set_parameter_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_parameter_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>A tag is a key-value pair where the key and value are case-sensitive. You can use tags to categorize and track all your MemoryDB resources. When you add or remove tags on clusters, those actions will be replicated to all nodes in the cluster. For more information, see <a href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/iam.resourcelevelpermissions.html">Resource-level permissions</a>.</p>
    /// <p>For example, you can use cost-allocation tags to your MemoryDB resources, Amazon generates a cost allocation report as a comma-separated value (CSV) file with your usage and costs aggregated by your tags. You can apply tags that represent business categories (such as cost centers, application names, or owners) to organize your costs across multiple services. For more information, see <a href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/tagging.html">Using Cost Allocation Tags</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to which the tags are to be added</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to which the tags are to be added</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Use this operation to remove tags on a resource</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to which the tags are to be removed</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to which the tags are to be removed</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The list of keys of the tags that are to be removed</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The list of keys of the tags that are to be removed</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateACL`.
    ///
    /// <p>Changes the list of users that belong to the Access Control List.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateACL {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_acl_input::Builder,
    }
    impl UpdateACL {
        /// Creates a new `UpdateACL`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAclOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateACLError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Access Control List</p>
        pub fn acl_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.acl_name(input.into());
            self
        }
        /// <p>The name of the Access Control List</p>
        pub fn set_acl_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_acl_name(input);
            self
        }
        /// Appends an item to `UserNamesToAdd`.
        ///
        /// To override the contents of this collection use [`set_user_names_to_add`](Self::set_user_names_to_add).
        ///
        /// <p>The list of users to add to the Access Control List</p>
        pub fn user_names_to_add(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_names_to_add(input.into());
            self
        }
        /// <p>The list of users to add to the Access Control List</p>
        pub fn set_user_names_to_add(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_user_names_to_add(input);
            self
        }
        /// Appends an item to `UserNamesToRemove`.
        ///
        /// To override the contents of this collection use [`set_user_names_to_remove`](Self::set_user_names_to_remove).
        ///
        /// <p>The list of users to remove from the Access Control List</p>
        pub fn user_names_to_remove(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_names_to_remove(input.into());
            self
        }
        /// <p>The list of users to remove from the Access Control List</p>
        pub fn set_user_names_to_remove(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_user_names_to_remove(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateCluster`.
    ///
    /// <p>Modifies the settings for a cluster. You can use this operation to change one or more cluster configuration settings by specifying the settings and the new values.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateCluster {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_cluster_input::Builder,
    }
    impl UpdateCluster {
        /// Creates a new `UpdateCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateClusterError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the cluster to update</p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_name(input.into());
            self
        }
        /// <p>The name of the cluster to update</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_name(input);
            self
        }
        /// <p>The description of the cluster to update</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the cluster to update</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `SecurityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>The SecurityGroupIds to update</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_group_ids(input.into());
            self
        }
        /// <p>The SecurityGroupIds to update</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_security_group_ids(input);
            self
        }
        /// <p>The maintenance window to update</p>
        pub fn maintenance_window(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.maintenance_window(input.into());
            self
        }
        /// <p>The maintenance window to update</p>
        pub fn set_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_maintenance_window(input);
            self
        }
        /// <p>The SNS topic ARN to update</p>
        pub fn sns_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sns_topic_arn(input.into());
            self
        }
        /// <p>The SNS topic ARN to update</p>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sns_topic_arn(input);
            self
        }
        /// <p>The status of the Amazon SNS notification topic. Notifications are sent only if the status is active.</p>
        pub fn sns_topic_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sns_topic_status(input.into());
            self
        }
        /// <p>The status of the Amazon SNS notification topic. Notifications are sent only if the status is active.</p>
        pub fn set_sns_topic_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sns_topic_status(input);
            self
        }
        /// <p>The name of the parameter group to update</p>
        pub fn parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parameter_group_name(input.into());
            self
        }
        /// <p>The name of the parameter group to update</p>
        pub fn set_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parameter_group_name(input);
            self
        }
        /// <p>The daily time range (in UTC) during which MemoryDB begins taking a daily snapshot of your cluster.</p>
        pub fn snapshot_window(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_window(input.into());
            self
        }
        /// <p>The daily time range (in UTC) during which MemoryDB begins taking a daily snapshot of your cluster.</p>
        pub fn set_snapshot_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_window(input);
            self
        }
        /// <p>The number of days for which MemoryDB retains automatic cluster snapshots before deleting them. For example, if you set SnapshotRetentionLimit to 5, a snapshot that was taken today is retained for 5 days before being deleted.</p>
        pub fn snapshot_retention_limit(mut self, input: i32) -> Self {
            self.inner = self.inner.snapshot_retention_limit(input);
            self
        }
        /// <p>The number of days for which MemoryDB retains automatic cluster snapshots before deleting them. For example, if you set SnapshotRetentionLimit to 5, a snapshot that was taken today is retained for 5 days before being deleted.</p>
        pub fn set_snapshot_retention_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_snapshot_retention_limit(input);
            self
        }
        /// <p>A valid node type that you want to scale this cluster up or down to.</p>
        pub fn node_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.node_type(input.into());
            self
        }
        /// <p>A valid node type that you want to scale this cluster up or down to.</p>
        pub fn set_node_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_node_type(input);
            self
        }
        /// <p>The upgraded version of the engine to be run on the nodes. You can upgrade to a newer engine version, but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing cluster and create it anew with the earlier engine version.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_version(input.into());
            self
        }
        /// <p>The upgraded version of the engine to be run on the nodes. You can upgrade to a newer engine version, but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing cluster and create it anew with the earlier engine version.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engine_version(input);
            self
        }
        /// <p>The number of replicas that will reside in each shard</p>
        pub fn replica_configuration(
            mut self,
            input: crate::model::ReplicaConfigurationRequest,
        ) -> Self {
            self.inner = self.inner.replica_configuration(input);
            self
        }
        /// <p>The number of replicas that will reside in each shard</p>
        pub fn set_replica_configuration(
            mut self,
            input: std::option::Option<crate::model::ReplicaConfigurationRequest>,
        ) -> Self {
            self.inner = self.inner.set_replica_configuration(input);
            self
        }
        /// <p>The number of shards in the cluster</p>
        pub fn shard_configuration(
            mut self,
            input: crate::model::ShardConfigurationRequest,
        ) -> Self {
            self.inner = self.inner.shard_configuration(input);
            self
        }
        /// <p>The number of shards in the cluster</p>
        pub fn set_shard_configuration(
            mut self,
            input: std::option::Option<crate::model::ShardConfigurationRequest>,
        ) -> Self {
            self.inner = self.inner.set_shard_configuration(input);
            self
        }
        /// <p>The Access Control List that is associated with the cluster</p>
        pub fn acl_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.acl_name(input.into());
            self
        }
        /// <p>The Access Control List that is associated with the cluster</p>
        pub fn set_acl_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_acl_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateParameterGroup`.
    ///
    /// <p>Updates the parameters of a parameter group. You can modify up to 20 parameters in a single request by submitting a list parameter name and value pairs.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateParameterGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_parameter_group_input::Builder,
    }
    impl UpdateParameterGroup {
        /// Creates a new `UpdateParameterGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateParameterGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateParameterGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the parameter group to update.</p>
        pub fn parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parameter_group_name(input.into());
            self
        }
        /// <p>The name of the parameter group to update.</p>
        pub fn set_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parameter_group_name(input);
            self
        }
        /// Appends an item to `ParameterNameValues`.
        ///
        /// To override the contents of this collection use [`set_parameter_name_values`](Self::set_parameter_name_values).
        ///
        /// <p>An array of parameter names and values for the parameter update. You must supply at least one parameter name and value; subsequent arguments are optional. A maximum of 20 parameters may be updated per request.</p>
        pub fn parameter_name_values(mut self, input: crate::model::ParameterNameValue) -> Self {
            self.inner = self.inner.parameter_name_values(input);
            self
        }
        /// <p>An array of parameter names and values for the parameter update. You must supply at least one parameter name and value; subsequent arguments are optional. A maximum of 20 parameters may be updated per request.</p>
        pub fn set_parameter_name_values(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ParameterNameValue>>,
        ) -> Self {
            self.inner = self.inner.set_parameter_name_values(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSubnetGroup`.
    ///
    /// <p>Updates a subnet group. For more information, see <a href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/ubnetGroups.Modifying.html">Updating a subnet group</a> </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateSubnetGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_subnet_group_input::Builder,
    }
    impl UpdateSubnetGroup {
        /// Creates a new `UpdateSubnetGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSubnetGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSubnetGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the subnet group</p>
        pub fn subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_group_name(input.into());
            self
        }
        /// <p>The name of the subnet group</p>
        pub fn set_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subnet_group_name(input);
            self
        }
        /// <p>A description of the subnet group</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the subnet group</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `SubnetIds`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>The EC2 subnet IDs for the subnet group.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_ids(input.into());
            self
        }
        /// <p>The EC2 subnet IDs for the subnet group.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subnet_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateUser`.
    ///
    /// <p>Changes user password(s) and/or access string.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateUser {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_user_input::Builder,
    }
    impl UpdateUser {
        /// Creates a new `UpdateUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateUserOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateUserError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the user</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(input.into());
            self
        }
        /// <p>The name of the user</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>Denotes the user's authentication properties, such as whether it requires a password to authenticate.</p>
        pub fn authentication_mode(mut self, input: crate::model::AuthenticationMode) -> Self {
            self.inner = self.inner.authentication_mode(input);
            self
        }
        /// <p>Denotes the user's authentication properties, such as whether it requires a password to authenticate.</p>
        pub fn set_authentication_mode(
            mut self,
            input: std::option::Option<crate::model::AuthenticationMode>,
        ) -> Self {
            self.inner = self.inner.set_authentication_mode(input);
            self
        }
        /// <p>Access permissions string used for this user.</p>
        pub fn access_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.access_string(input.into());
            self
        }
        /// <p>Access permissions string used for this user.</p>
        pub fn set_access_string(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_access_string(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
