// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `AmazonMemoryDB`.
///
/// This client allows ergonomic access to a `AmazonMemoryDB`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `BatchUpdateCluster` operation.
    ///
    /// See [`BatchUpdateCluster`](crate::client::fluent_builders::BatchUpdateCluster) for more information about the
    /// operation and its arguments.
    pub fn batch_update_cluster(&self) -> fluent_builders::BatchUpdateCluster<C, M, R> {
        fluent_builders::BatchUpdateCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CopySnapshot` operation.
    ///
    /// See [`CopySnapshot`](crate::client::fluent_builders::CopySnapshot) for more information about the
    /// operation and its arguments.
    pub fn copy_snapshot(&self) -> fluent_builders::CopySnapshot<C, M, R> {
        fluent_builders::CopySnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateACL` operation.
    ///
    /// See [`CreateACL`](crate::client::fluent_builders::CreateACL) for more information about the
    /// operation and its arguments.
    pub fn create_acl(&self) -> fluent_builders::CreateACL<C, M, R> {
        fluent_builders::CreateACL::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateCluster` operation.
    ///
    /// See [`CreateCluster`](crate::client::fluent_builders::CreateCluster) for more information about the
    /// operation and its arguments.
    pub fn create_cluster(&self) -> fluent_builders::CreateCluster<C, M, R> {
        fluent_builders::CreateCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateParameterGroup` operation.
    ///
    /// See [`CreateParameterGroup`](crate::client::fluent_builders::CreateParameterGroup) for more information about the
    /// operation and its arguments.
    pub fn create_parameter_group(&self) -> fluent_builders::CreateParameterGroup<C, M, R> {
        fluent_builders::CreateParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateSnapshot` operation.
    ///
    /// See [`CreateSnapshot`](crate::client::fluent_builders::CreateSnapshot) for more information about the
    /// operation and its arguments.
    pub fn create_snapshot(&self) -> fluent_builders::CreateSnapshot<C, M, R> {
        fluent_builders::CreateSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateSubnetGroup` operation.
    ///
    /// See [`CreateSubnetGroup`](crate::client::fluent_builders::CreateSubnetGroup) for more information about the
    /// operation and its arguments.
    pub fn create_subnet_group(&self) -> fluent_builders::CreateSubnetGroup<C, M, R> {
        fluent_builders::CreateSubnetGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateUser` operation.
    ///
    /// See [`CreateUser`](crate::client::fluent_builders::CreateUser) for more information about the
    /// operation and its arguments.
    pub fn create_user(&self) -> fluent_builders::CreateUser<C, M, R> {
        fluent_builders::CreateUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteACL` operation.
    ///
    /// See [`DeleteACL`](crate::client::fluent_builders::DeleteACL) for more information about the
    /// operation and its arguments.
    pub fn delete_acl(&self) -> fluent_builders::DeleteACL<C, M, R> {
        fluent_builders::DeleteACL::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteCluster` operation.
    ///
    /// See [`DeleteCluster`](crate::client::fluent_builders::DeleteCluster) for more information about the
    /// operation and its arguments.
    pub fn delete_cluster(&self) -> fluent_builders::DeleteCluster<C, M, R> {
        fluent_builders::DeleteCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteParameterGroup` operation.
    ///
    /// See [`DeleteParameterGroup`](crate::client::fluent_builders::DeleteParameterGroup) for more information about the
    /// operation and its arguments.
    pub fn delete_parameter_group(&self) -> fluent_builders::DeleteParameterGroup<C, M, R> {
        fluent_builders::DeleteParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteSnapshot` operation.
    ///
    /// See [`DeleteSnapshot`](crate::client::fluent_builders::DeleteSnapshot) for more information about the
    /// operation and its arguments.
    pub fn delete_snapshot(&self) -> fluent_builders::DeleteSnapshot<C, M, R> {
        fluent_builders::DeleteSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteSubnetGroup` operation.
    ///
    /// See [`DeleteSubnetGroup`](crate::client::fluent_builders::DeleteSubnetGroup) for more information about the
    /// operation and its arguments.
    pub fn delete_subnet_group(&self) -> fluent_builders::DeleteSubnetGroup<C, M, R> {
        fluent_builders::DeleteSubnetGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteUser` operation.
    ///
    /// See [`DeleteUser`](crate::client::fluent_builders::DeleteUser) for more information about the
    /// operation and its arguments.
    pub fn delete_user(&self) -> fluent_builders::DeleteUser<C, M, R> {
        fluent_builders::DeleteUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeACLs` operation.
    ///
    /// See [`DescribeACLs`](crate::client::fluent_builders::DescribeACLs) for more information about the
    /// operation and its arguments.
    pub fn describe_ac_ls(&self) -> fluent_builders::DescribeACLs<C, M, R> {
        fluent_builders::DescribeACLs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeClusters` operation.
    ///
    /// See [`DescribeClusters`](crate::client::fluent_builders::DescribeClusters) for more information about the
    /// operation and its arguments.
    pub fn describe_clusters(&self) -> fluent_builders::DescribeClusters<C, M, R> {
        fluent_builders::DescribeClusters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeEngineVersions` operation.
    ///
    /// See [`DescribeEngineVersions`](crate::client::fluent_builders::DescribeEngineVersions) for more information about the
    /// operation and its arguments.
    pub fn describe_engine_versions(&self) -> fluent_builders::DescribeEngineVersions<C, M, R> {
        fluent_builders::DescribeEngineVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeEvents` operation.
    ///
    /// See [`DescribeEvents`](crate::client::fluent_builders::DescribeEvents) for more information about the
    /// operation and its arguments.
    pub fn describe_events(&self) -> fluent_builders::DescribeEvents<C, M, R> {
        fluent_builders::DescribeEvents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeParameterGroups` operation.
    ///
    /// See [`DescribeParameterGroups`](crate::client::fluent_builders::DescribeParameterGroups) for more information about the
    /// operation and its arguments.
    pub fn describe_parameter_groups(&self) -> fluent_builders::DescribeParameterGroups<C, M, R> {
        fluent_builders::DescribeParameterGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeParameters` operation.
    ///
    /// See [`DescribeParameters`](crate::client::fluent_builders::DescribeParameters) for more information about the
    /// operation and its arguments.
    pub fn describe_parameters(&self) -> fluent_builders::DescribeParameters<C, M, R> {
        fluent_builders::DescribeParameters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeServiceUpdates` operation.
    ///
    /// See [`DescribeServiceUpdates`](crate::client::fluent_builders::DescribeServiceUpdates) for more information about the
    /// operation and its arguments.
    pub fn describe_service_updates(&self) -> fluent_builders::DescribeServiceUpdates<C, M, R> {
        fluent_builders::DescribeServiceUpdates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeSnapshots` operation.
    ///
    /// See [`DescribeSnapshots`](crate::client::fluent_builders::DescribeSnapshots) for more information about the
    /// operation and its arguments.
    pub fn describe_snapshots(&self) -> fluent_builders::DescribeSnapshots<C, M, R> {
        fluent_builders::DescribeSnapshots::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeSubnetGroups` operation.
    ///
    /// See [`DescribeSubnetGroups`](crate::client::fluent_builders::DescribeSubnetGroups) for more information about the
    /// operation and its arguments.
    pub fn describe_subnet_groups(&self) -> fluent_builders::DescribeSubnetGroups<C, M, R> {
        fluent_builders::DescribeSubnetGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeUsers` operation.
    ///
    /// See [`DescribeUsers`](crate::client::fluent_builders::DescribeUsers) for more information about the
    /// operation and its arguments.
    pub fn describe_users(&self) -> fluent_builders::DescribeUsers<C, M, R> {
        fluent_builders::DescribeUsers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `FailoverShard` operation.
    ///
    /// See [`FailoverShard`](crate::client::fluent_builders::FailoverShard) for more information about the
    /// operation and its arguments.
    pub fn failover_shard(&self) -> fluent_builders::FailoverShard<C, M, R> {
        fluent_builders::FailoverShard::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAllowedNodeTypeUpdates` operation.
    ///
    /// See [`ListAllowedNodeTypeUpdates`](crate::client::fluent_builders::ListAllowedNodeTypeUpdates) for more information about the
    /// operation and its arguments.
    pub fn list_allowed_node_type_updates(
        &self,
    ) -> fluent_builders::ListAllowedNodeTypeUpdates<C, M, R> {
        fluent_builders::ListAllowedNodeTypeUpdates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTags` operation.
    ///
    /// See [`ListTags`](crate::client::fluent_builders::ListTags) for more information about the
    /// operation and its arguments.
    pub fn list_tags(&self) -> fluent_builders::ListTags<C, M, R> {
        fluent_builders::ListTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ResetParameterGroup` operation.
    ///
    /// See [`ResetParameterGroup`](crate::client::fluent_builders::ResetParameterGroup) for more information about the
    /// operation and its arguments.
    pub fn reset_parameter_group(&self) -> fluent_builders::ResetParameterGroup<C, M, R> {
        fluent_builders::ResetParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateACL` operation.
    ///
    /// See [`UpdateACL`](crate::client::fluent_builders::UpdateACL) for more information about the
    /// operation and its arguments.
    pub fn update_acl(&self) -> fluent_builders::UpdateACL<C, M, R> {
        fluent_builders::UpdateACL::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateCluster` operation.
    ///
    /// See [`UpdateCluster`](crate::client::fluent_builders::UpdateCluster) for more information about the
    /// operation and its arguments.
    pub fn update_cluster(&self) -> fluent_builders::UpdateCluster<C, M, R> {
        fluent_builders::UpdateCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateParameterGroup` operation.
    ///
    /// See [`UpdateParameterGroup`](crate::client::fluent_builders::UpdateParameterGroup) for more information about the
    /// operation and its arguments.
    pub fn update_parameter_group(&self) -> fluent_builders::UpdateParameterGroup<C, M, R> {
        fluent_builders::UpdateParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateSubnetGroup` operation.
    ///
    /// See [`UpdateSubnetGroup`](crate::client::fluent_builders::UpdateSubnetGroup) for more information about the
    /// operation and its arguments.
    pub fn update_subnet_group(&self) -> fluent_builders::UpdateSubnetGroup<C, M, R> {
        fluent_builders::UpdateSubnetGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateUser` operation.
    ///
    /// See [`UpdateUser`](crate::client::fluent_builders::UpdateUser) for more information about the
    /// operation and its arguments.
    pub fn update_user(&self) -> fluent_builders::UpdateUser<C, M, R> {
        fluent_builders::UpdateUser::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `BatchUpdateCluster`.
    ///
    /// <p>Apply the service update to a list of clusters supplied. For more information on service updates and applying them, see <a href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/managing-updates.html#applying-updates">Applying the service updates</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchUpdateCluster<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_update_cluster_input::Builder,
    }
    impl<C, M, R> BatchUpdateCluster<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchUpdateCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchUpdateClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchUpdateClusterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchUpdateClusterInputOperationOutputAlias,
                crate::output::BatchUpdateClusterOutput,
                crate::error::BatchUpdateClusterError,
                crate::input::BatchUpdateClusterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `ClusterNames`.
        ///
        /// To override the contents of this collection use [`set_cluster_names`](Self::set_cluster_names).
        ///
        /// <p>The cluster names to apply the updates.</p>
        pub fn cluster_names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_names(inp);
            self
        }
        /// <p>The cluster names to apply the updates.</p>
        pub fn set_cluster_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_cluster_names(input);
            self
        }
        /// <p>The unique ID of the service update</p>
        pub fn service_update(mut self, inp: crate::model::ServiceUpdateRequest) -> Self {
            self.inner = self.inner.service_update(inp);
            self
        }
        /// <p>The unique ID of the service update</p>
        pub fn set_service_update(
            mut self,
            input: std::option::Option<crate::model::ServiceUpdateRequest>,
        ) -> Self {
            self.inner = self.inner.set_service_update(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CopySnapshot`.
    ///
    /// <p>Makes a copy of an existing snapshot.</p>
    #[derive(std::fmt::Debug)]
    pub struct CopySnapshot<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::copy_snapshot_input::Builder,
    }
    impl<C, M, R> CopySnapshot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CopySnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CopySnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::CopySnapshotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CopySnapshotInputOperationOutputAlias,
                crate::output::CopySnapshotOutput,
                crate::error::CopySnapshotError,
                crate::input::CopySnapshotInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of an existing snapshot from which to make a copy.</p>
        pub fn source_snapshot_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_snapshot_name(inp);
            self
        }
        /// <p>The name of an existing snapshot from which to make a copy.</p>
        pub fn set_source_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_snapshot_name(input);
            self
        }
        /// <p>A name for the snapshot copy. MemoryDB does not permit overwriting a snapshot, therefore this name must be unique within its context - MemoryDB or an Amazon S3 bucket if exporting.</p>
        pub fn target_snapshot_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_snapshot_name(inp);
            self
        }
        /// <p>A name for the snapshot copy. MemoryDB does not permit overwriting a snapshot, therefore this name must be unique within its context - MemoryDB or an Amazon S3 bucket if exporting.</p>
        pub fn set_target_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_snapshot_name(input);
            self
        }
        /// <p>The Amazon S3 bucket to which the snapshot is exported. This parameter is used only when exporting a snapshot for external access.
        ///
        /// When using this parameter to export a snapshot, be sure MemoryDB has the needed permissions to this S3 bucket. For more information, see
        ///
        /// <a href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/snapshots-exporting.html">Step 2: Grant MemoryDB Access to Your Amazon S3 Bucket</a>.
        ///
        /// </p>
        pub fn target_bucket(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_bucket(inp);
            self
        }
        /// <p>The Amazon S3 bucket to which the snapshot is exported. This parameter is used only when exporting a snapshot for external access.
        ///
        /// When using this parameter to export a snapshot, be sure MemoryDB has the needed permissions to this S3 bucket. For more information, see
        ///
        /// <a href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/snapshots-exporting.html">Step 2: Grant MemoryDB Access to Your Amazon S3 Bucket</a>.
        ///
        /// </p>
        pub fn set_target_bucket(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_bucket(input);
            self
        }
        /// <p>The ID of the KMS key used to encrypt the target snapshot.</p>
        pub fn kms_key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(inp);
            self
        }
        /// <p>The ID of the KMS key used to encrypt the target snapshot.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateACL`.
    ///
    /// <p>Creates an Access Control List. For more information, see <a href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/clusters.acls.html">Authenticating users with Access Contol Lists (ACLs)</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateACL<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_acl_input::Builder,
    }
    impl<C, M, R> CreateACL<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateACL`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAclOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateACLError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAclInputOperationOutputAlias,
                crate::output::CreateAclOutput,
                crate::error::CreateACLError,
                crate::input::CreateAclInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Access Control List.</p>
        pub fn acl_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.acl_name(inp);
            self
        }
        /// <p>The name of the Access Control List.</p>
        pub fn set_acl_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_acl_name(input);
            self
        }
        /// Appends an item to `UserNames`.
        ///
        /// To override the contents of this collection use [`set_user_names`](Self::set_user_names).
        ///
        /// <p>The list of users that belong to the Access Control List.</p>
        pub fn user_names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_names(inp);
            self
        }
        /// <p>The list of users that belong to the Access Control List.</p>
        pub fn set_user_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_user_names(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCluster`.
    ///
    /// <p>Creates a cluster. All nodes in the cluster run the same protocol-compliant engine software.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateCluster<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_cluster_input::Builder,
    }
    impl<C, M, R> CreateCluster<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateClusterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateClusterInputOperationOutputAlias,
                crate::output::CreateClusterOutput,
                crate::error::CreateClusterError,
                crate::input::CreateClusterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the cluster. This value must be unique as it also serves as the cluster identifier.</p>
        pub fn cluster_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_name(inp);
            self
        }
        /// <p>The name of the cluster. This value must be unique as it also serves as the cluster identifier.</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_name(input);
            self
        }
        /// <p>The compute and memory capacity of the nodes in the cluster.</p>
        pub fn node_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.node_type(inp);
            self
        }
        /// <p>The compute and memory capacity of the nodes in the cluster.</p>
        pub fn set_node_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_node_type(input);
            self
        }
        /// <p>The name of the parameter group associated with the cluster.</p>
        pub fn parameter_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parameter_group_name(inp);
            self
        }
        /// <p>The name of the parameter group associated with the cluster.</p>
        pub fn set_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parameter_group_name(input);
            self
        }
        /// <p>An optional description of the cluster.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>An optional description of the cluster.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The number of shards the cluster will contain. The default value is 1. </p>
        pub fn num_shards(mut self, inp: i32) -> Self {
            self.inner = self.inner.num_shards(inp);
            self
        }
        /// <p>The number of shards the cluster will contain. The default value is 1. </p>
        pub fn set_num_shards(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_num_shards(input);
            self
        }
        /// <p>The number of replicas to apply to each shard. The default value is 1. The maximum is 5. </p>
        pub fn num_replicas_per_shard(mut self, inp: i32) -> Self {
            self.inner = self.inner.num_replicas_per_shard(inp);
            self
        }
        /// <p>The number of replicas to apply to each shard. The default value is 1. The maximum is 5. </p>
        pub fn set_num_replicas_per_shard(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_num_replicas_per_shard(input);
            self
        }
        /// <p>The name of the subnet group to be used for the cluster.</p>
        pub fn subnet_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_group_name(inp);
            self
        }
        /// <p>The name of the subnet group to be used for the cluster.</p>
        pub fn set_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subnet_group_name(input);
            self
        }
        /// Appends an item to `SecurityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>A list of security group names to associate with this cluster.</p>
        pub fn security_group_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_group_ids(inp);
            self
        }
        /// <p>A list of security group names to associate with this cluster.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_security_group_ids(input);
            self
        }
        /// <p>Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format <code>ddd:hh24:mi-ddd:hh24:mi</code> (24H Clock UTC). The minimum maintenance window is a 60 minute period.</p>
        pub fn maintenance_window(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.maintenance_window(inp);
            self
        }
        /// <p>Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format <code>ddd:hh24:mi-ddd:hh24:mi</code> (24H Clock UTC). The minimum maintenance window is a 60 minute period.</p>
        pub fn set_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_maintenance_window(input);
            self
        }
        /// <p>The port number on which each of the nodes accepts connections.</p>
        pub fn port(mut self, inp: i32) -> Self {
            self.inner = self.inner.port(inp);
            self
        }
        /// <p>The port number on which each of the nodes accepts connections.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_port(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which notifications are sent.</p>
        pub fn sns_topic_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sns_topic_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which notifications are sent.</p>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sns_topic_arn(input);
            self
        }
        /// <p>A flag to enable in-transit encryption on the cluster.</p>
        pub fn tls_enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.tls_enabled(inp);
            self
        }
        /// <p>A flag to enable in-transit encryption on the cluster.</p>
        pub fn set_tls_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_tls_enabled(input);
            self
        }
        /// <p>The ID of the KMS key used to encrypt the cluster.</p>
        pub fn kms_key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(inp);
            self
        }
        /// <p>The ID of the KMS key used to encrypt the cluster.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// Appends an item to `SnapshotArns`.
        ///
        /// To override the contents of this collection use [`set_snapshot_arns`](Self::set_snapshot_arns).
        ///
        /// <p>A list of Amazon Resource Names (ARN) that uniquely identify the RDB snapshot files stored in Amazon S3. The snapshot files are used to populate the new cluster. The Amazon S3 object name in the ARN cannot contain any commas.</p>
        pub fn snapshot_arns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_arns(inp);
            self
        }
        /// <p>A list of Amazon Resource Names (ARN) that uniquely identify the RDB snapshot files stored in Amazon S3. The snapshot files are used to populate the new cluster. The Amazon S3 object name in the ARN cannot contain any commas.</p>
        pub fn set_snapshot_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_arns(input);
            self
        }
        /// <p>The name of a snapshot from which to restore data into the new cluster. The snapshot status changes to restoring while the new cluster is being created.</p>
        pub fn snapshot_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_name(inp);
            self
        }
        /// <p>The name of a snapshot from which to restore data into the new cluster. The snapshot status changes to restoring while the new cluster is being created.</p>
        pub fn set_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_name(input);
            self
        }
        /// <p>The number of days for which MemoryDB retains automatic snapshots before deleting them. For example, if you set SnapshotRetentionLimit to 5, a snapshot that was taken today is retained for 5 days before being deleted.</p>
        pub fn snapshot_retention_limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.snapshot_retention_limit(inp);
            self
        }
        /// <p>The number of days for which MemoryDB retains automatic snapshots before deleting them. For example, if you set SnapshotRetentionLimit to 5, a snapshot that was taken today is retained for 5 days before being deleted.</p>
        pub fn set_snapshot_retention_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_snapshot_retention_limit(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to be added to this resource. Tags are comma-separated key,value pairs (e.g. Key=myKey, Value=myKeyValue. You can include multiple tags as shown following: Key=myKey, Value=myKeyValue Key=mySecondKey, Value=mySecondKeyValue.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of tags to be added to this resource. Tags are comma-separated key,value pairs (e.g. Key=myKey, Value=myKeyValue. You can include multiple tags as shown following: Key=myKey, Value=myKeyValue Key=mySecondKey, Value=mySecondKeyValue.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The daily time range (in UTC) during which MemoryDB begins taking a daily snapshot of your shard.</p>
        ///
        /// <p>    Example: 05:00-09:00</p>
        ///
        /// <p>    If you do not specify this parameter, MemoryDB automatically chooses an appropriate time range.</p>
        pub fn snapshot_window(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_window(inp);
            self
        }
        /// <p>The daily time range (in UTC) during which MemoryDB begins taking a daily snapshot of your shard.</p>
        ///
        /// <p>    Example: 05:00-09:00</p>
        ///
        /// <p>    If you do not specify this parameter, MemoryDB automatically chooses an appropriate time range.</p>
        pub fn set_snapshot_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_window(input);
            self
        }
        /// <p>The name of the Access Control List to associate with the cluster.</p>
        pub fn acl_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.acl_name(inp);
            self
        }
        /// <p>The name of the Access Control List to associate with the cluster.</p>
        pub fn set_acl_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_acl_name(input);
            self
        }
        /// <p>The version number of the Redis engine to be used for the cluster.</p>
        pub fn engine_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_version(inp);
            self
        }
        /// <p>The version number of the Redis engine to be used for the cluster.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engine_version(input);
            self
        }
        /// <p>When set to true, the cluster will automatically receive minor engine version upgrades after launch.</p>
        pub fn auto_minor_version_upgrade(mut self, inp: bool) -> Self {
            self.inner = self.inner.auto_minor_version_upgrade(inp);
            self
        }
        /// <p>When set to true, the cluster will automatically receive minor engine version upgrades after launch.</p>
        pub fn set_auto_minor_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_minor_version_upgrade(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateParameterGroup`.
    ///
    /// <p>Creates a new MemoryDB parameter group. A parameter group is a collection of parameters and their values that are applied to all of the nodes in any cluster. For
    /// more information, see <a href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/parametergroups.html">Configuring engine parameters using parameter groups</a>.
    ///
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateParameterGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_parameter_group_input::Builder,
    }
    impl<C, M, R> CreateParameterGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateParameterGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateParameterGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateParameterGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateParameterGroupInputOperationOutputAlias,
                crate::output::CreateParameterGroupOutput,
                crate::error::CreateParameterGroupError,
                crate::input::CreateParameterGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the parameter group.</p>
        pub fn parameter_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parameter_group_name(inp);
            self
        }
        /// <p>The name of the parameter group.</p>
        pub fn set_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parameter_group_name(input);
            self
        }
        /// <p>The name of the parameter group family that the parameter group can be used with.</p>
        pub fn family(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.family(inp);
            self
        }
        /// <p>The name of the parameter group family that the parameter group can be used with.</p>
        pub fn set_family(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_family(input);
            self
        }
        /// <p>An optional description of the parameter group.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>An optional description of the parameter group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSnapshot`.
    ///
    /// <p>Creates a copy of an entire cluster at a specific moment in time.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateSnapshot<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_snapshot_input::Builder,
    }
    impl<C, M, R> CreateSnapshot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSnapshotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSnapshotInputOperationOutputAlias,
                crate::output::CreateSnapshotOutput,
                crate::error::CreateSnapshotError,
                crate::input::CreateSnapshotInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The snapshot is created from this cluster.</p>
        pub fn cluster_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_name(inp);
            self
        }
        /// <p>The snapshot is created from this cluster.</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_name(input);
            self
        }
        /// <p>A name for the snapshot being created.</p>
        pub fn snapshot_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_name(inp);
            self
        }
        /// <p>A name for the snapshot being created.</p>
        pub fn set_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_name(input);
            self
        }
        /// <p>The ID of the KMS key used to encrypt the snapshot.</p>
        pub fn kms_key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(inp);
            self
        }
        /// <p>The ID of the KMS key used to encrypt the snapshot.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSubnetGroup`.
    ///
    /// <p>Creates a subnet group. A subnet group is a collection of subnets (typically private) that you can designate for your clusters running in an Amazon Virtual Private Cloud (VPC) environment.
    ///
    /// When you create a cluster in an Amazon VPC, you must specify a subnet group. MemoryDB uses that subnet group to choose a subnet and IP addresses within that subnet to associate with your nodes.
    /// For more information, see <a href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/subnetgroups.html">Subnets and subnet groups</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateSubnetGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_subnet_group_input::Builder,
    }
    impl<C, M, R> CreateSubnetGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSubnetGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSubnetGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSubnetGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSubnetGroupInputOperationOutputAlias,
                crate::output::CreateSubnetGroupOutput,
                crate::error::CreateSubnetGroupError,
                crate::input::CreateSubnetGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the subnet group.</p>
        pub fn subnet_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_group_name(inp);
            self
        }
        /// <p>The name of the subnet group.</p>
        pub fn set_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subnet_group_name(input);
            self
        }
        /// <p>A description for the subnet group.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description for the subnet group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `SubnetIds`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>A list of VPC subnet IDs for the subnet group.</p>
        pub fn subnet_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_ids(inp);
            self
        }
        /// <p>A list of VPC subnet IDs for the subnet group.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subnet_ids(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateUser`.
    ///
    /// <p>Creates a MemoryDB user. For more information, see <a href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/clusters.acls.html">Authenticating users with Access Contol Lists (ACLs)</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateUser<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_user_input::Builder,
    }
    impl<C, M, R> CreateUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateUserOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateUserInputOperationOutputAlias,
                crate::output::CreateUserOutput,
                crate::error::CreateUserError,
                crate::input::CreateUserInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the user. This value must be unique as it also serves as the user identifier.</p>
        pub fn user_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(inp);
            self
        }
        /// <p>The name of the user. This value must be unique as it also serves as the user identifier.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>Denotes the user's authentication properties, such as whether it requires a password to authenticate.</p>
        pub fn authentication_mode(mut self, inp: crate::model::AuthenticationMode) -> Self {
            self.inner = self.inner.authentication_mode(inp);
            self
        }
        /// <p>Denotes the user's authentication properties, such as whether it requires a password to authenticate.</p>
        pub fn set_authentication_mode(
            mut self,
            input: std::option::Option<crate::model::AuthenticationMode>,
        ) -> Self {
            self.inner = self.inner.set_authentication_mode(input);
            self
        }
        /// <p>Access permissions string used for this user.</p>
        pub fn access_string(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.access_string(inp);
            self
        }
        /// <p>Access permissions string used for this user.</p>
        pub fn set_access_string(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_access_string(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteACL`.
    ///
    /// <p>Deletes an Access Control List. The ACL must first be disassociated from the cluster before it can be deleted. For more information, see <a href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/clusters.acls.html">Authenticating users with Access Contol Lists (ACLs)</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteACL<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_acl_input::Builder,
    }
    impl<C, M, R> DeleteACL<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteACL`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAclOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteACLError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAclInputOperationOutputAlias,
                crate::output::DeleteAclOutput,
                crate::error::DeleteACLError,
                crate::input::DeleteAclInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Access Control List to delete</p>
        pub fn acl_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.acl_name(inp);
            self
        }
        /// <p>The name of the Access Control List to delete</p>
        pub fn set_acl_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_acl_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCluster`.
    ///
    /// <p>Deletes a cluster. It also deletes all associated nodes and node endpoints</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteCluster<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_cluster_input::Builder,
    }
    impl<C, M, R> DeleteCluster<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteClusterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteClusterInputOperationOutputAlias,
                crate::output::DeleteClusterOutput,
                crate::error::DeleteClusterError,
                crate::input::DeleteClusterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the cluster to be deleted</p>
        pub fn cluster_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_name(inp);
            self
        }
        /// <p>The name of the cluster to be deleted</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_name(input);
            self
        }
        /// <p>The user-supplied name of a final cluster snapshot. This is the unique name that identifies the snapshot. MemoryDB creates the snapshot, and then deletes the cluster immediately afterward.</p>
        pub fn final_snapshot_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.final_snapshot_name(inp);
            self
        }
        /// <p>The user-supplied name of a final cluster snapshot. This is the unique name that identifies the snapshot. MemoryDB creates the snapshot, and then deletes the cluster immediately afterward.</p>
        pub fn set_final_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_final_snapshot_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteParameterGroup`.
    ///
    /// <p>Deletes the specified parameter group. You cannot delete a parameter group if it is associated with any clusters.
    /// You cannot delete the default parameter groups in your account.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteParameterGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_parameter_group_input::Builder,
    }
    impl<C, M, R> DeleteParameterGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteParameterGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteParameterGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteParameterGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteParameterGroupInputOperationOutputAlias,
                crate::output::DeleteParameterGroupOutput,
                crate::error::DeleteParameterGroupError,
                crate::input::DeleteParameterGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the parameter group to delete.</p>
        pub fn parameter_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parameter_group_name(inp);
            self
        }
        /// <p>The name of the parameter group to delete.</p>
        pub fn set_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parameter_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSnapshot`.
    ///
    /// <p>Deletes an existing snapshot. When you receive a successful response from this operation, MemoryDB immediately begins deleting the snapshot; you cannot cancel or revert this operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteSnapshot<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_snapshot_input::Builder,
    }
    impl<C, M, R> DeleteSnapshot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSnapshotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteSnapshotInputOperationOutputAlias,
                crate::output::DeleteSnapshotOutput,
                crate::error::DeleteSnapshotError,
                crate::input::DeleteSnapshotInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the snapshot to delete</p>
        pub fn snapshot_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_name(inp);
            self
        }
        /// <p>The name of the snapshot to delete</p>
        pub fn set_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSubnetGroup`.
    ///
    /// <p>Deletes a subnet group. You cannot delete a default subnet group or one that is associated with any clusters.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteSubnetGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_subnet_group_input::Builder,
    }
    impl<C, M, R> DeleteSubnetGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteSubnetGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSubnetGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSubnetGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteSubnetGroupInputOperationOutputAlias,
                crate::output::DeleteSubnetGroupOutput,
                crate::error::DeleteSubnetGroupError,
                crate::input::DeleteSubnetGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the subnet group to delete</p>
        pub fn subnet_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_group_name(inp);
            self
        }
        /// <p>The name of the subnet group to delete</p>
        pub fn set_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subnet_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteUser`.
    ///
    /// <p>Deletes a user. The user will be removed from all ACLs and in turn removed from all clusters.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteUser<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_user_input::Builder,
    }
    impl<C, M, R> DeleteUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteUserOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteUserInputOperationOutputAlias,
                crate::output::DeleteUserOutput,
                crate::error::DeleteUserError,
                crate::input::DeleteUserInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the user to delete</p>
        pub fn user_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(inp);
            self
        }
        /// <p>The name of the user to delete</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeACLs`.
    ///
    /// <p>Returns a list of ACLs</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeACLs<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_ac_ls_input::Builder,
    }
    impl<C, M, R> DescribeACLs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeACLs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAcLsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeACLsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAcLsInputOperationOutputAlias,
                crate::output::DescribeAcLsOutput,
                crate::error::DescribeACLsError,
                crate::input::DescribeAcLsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the ACL</p>
        pub fn acl_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.acl_name(inp);
            self
        }
        /// <p>The name of the ACL</p>
        pub fn set_acl_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_acl_name(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeClusters`.
    ///
    /// <p>Returns information about all provisioned clusters if no cluster identifier is specified, or about a specific cluster if a cluster name is supplied.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeClusters<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_clusters_input::Builder,
    }
    impl<C, M, R> DescribeClusters<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeClusters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeClustersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeClustersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeClustersInputOperationOutputAlias,
                crate::output::DescribeClustersOutput,
                crate::error::DescribeClustersError,
                crate::input::DescribeClustersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the cluster</p>
        pub fn cluster_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_name(inp);
            self
        }
        /// <p>The name of the cluster</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_name(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>An optional flag that can be included in the request to retrieve information about the individual shard(s).</p>
        pub fn show_shard_details(mut self, inp: bool) -> Self {
            self.inner = self.inner.show_shard_details(inp);
            self
        }
        /// <p>An optional flag that can be included in the request to retrieve information about the individual shard(s).</p>
        pub fn set_show_shard_details(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_show_shard_details(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEngineVersions`.
    ///
    /// <p>Returns a list of the available Redis engine versions.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeEngineVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_engine_versions_input::Builder,
    }
    impl<C, M, R> DescribeEngineVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEngineVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEngineVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEngineVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEngineVersionsInputOperationOutputAlias,
                crate::output::DescribeEngineVersionsOutput,
                crate::error::DescribeEngineVersionsError,
                crate::input::DescribeEngineVersionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Redis engine version</p>
        pub fn engine_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_version(inp);
            self
        }
        /// <p>The Redis engine version</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engine_version(input);
            self
        }
        /// <p>The name of a specific parameter group family to return details for.</p>
        pub fn parameter_group_family(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parameter_group_family(inp);
            self
        }
        /// <p>The name of a specific parameter group family to return details for.</p>
        pub fn set_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parameter_group_family(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>If true, specifies that only the default version of the specified engine or engine and major version combination is to be returned.</p>
        pub fn default_only(mut self, inp: bool) -> Self {
            self.inner = self.inner.default_only(inp);
            self
        }
        /// <p>If true, specifies that only the default version of the specified engine or engine and major version combination is to be returned.</p>
        pub fn set_default_only(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_default_only(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEvents`.
    ///
    /// <p>Returns events related to clusters, security groups, and parameter groups. You can obtain events specific to a particular cluster, security group, or parameter group by providing the name as a parameter.
    ///
    /// By default, only the events occurring within the last hour are returned; however, you can retrieve up to 14 days' worth of events if necessary.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeEvents<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_events_input::Builder,
    }
    impl<C, M, R> DescribeEvents<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEvents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEventsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEventsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEventsInputOperationOutputAlias,
                crate::output::DescribeEventsOutput,
                crate::error::DescribeEventsError,
                crate::input::DescribeEventsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the event source for which events are returned. If not specified, all sources are included in the response.</p>
        pub fn source_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_name(inp);
            self
        }
        /// <p>The identifier of the event source for which events are returned. If not specified, all sources are included in the response.</p>
        pub fn set_source_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source_name(input);
            self
        }
        /// <p>The event source to retrieve events for. If no value is specified, all events are returned.</p>
        pub fn source_type(mut self, inp: crate::model::SourceType) -> Self {
            self.inner = self.inner.source_type(inp);
            self
        }
        /// <p>The event source to retrieve events for. If no value is specified, all events are returned.</p>
        pub fn set_source_type(
            mut self,
            input: std::option::Option<crate::model::SourceType>,
        ) -> Self {
            self.inner = self.inner.set_source_type(input);
            self
        }
        /// <p>The beginning of the time interval to retrieve events for, specified in ISO 8601 format.
        ///
        /// Example: 2017-03-30T07:03:49.555Z</p>
        pub fn start_time(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(inp);
            self
        }
        /// <p>The beginning of the time interval to retrieve events for, specified in ISO 8601 format.
        ///
        /// Example: 2017-03-30T07:03:49.555Z</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>The end of the time interval for which to retrieve events, specified in ISO 8601 format.
        ///
        /// Example: 2017-03-30T07:03:49.555Z</p>
        pub fn end_time(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(inp);
            self
        }
        /// <p>The end of the time interval for which to retrieve events, specified in ISO 8601 format.
        ///
        /// Example: 2017-03-30T07:03:49.555Z</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>The number of minutes worth of events to retrieve.</p>
        pub fn duration(mut self, inp: i32) -> Self {
            self.inner = self.inner.duration(inp);
            self
        }
        /// <p>The number of minutes worth of events to retrieve.</p>
        pub fn set_duration(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_duration(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeParameterGroups`.
    ///
    /// <p>Returns a list of parameter group descriptions. If a parameter group name is specified, the list contains only the descriptions for that group.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeParameterGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_parameter_groups_input::Builder,
    }
    impl<C, M, R> DescribeParameterGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeParameterGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeParameterGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeParameterGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeParameterGroupsInputOperationOutputAlias,
                crate::output::DescribeParameterGroupsOutput,
                crate::error::DescribeParameterGroupsError,
                crate::input::DescribeParameterGroupsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of a specific  parameter group to return details for.</p>
        pub fn parameter_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parameter_group_name(inp);
            self
        }
        /// <p>The name of a specific  parameter group to return details for.</p>
        pub fn set_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parameter_group_name(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeParameters`.
    ///
    /// <p>Returns the detailed parameter list for a particular parameter group.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeParameters<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_parameters_input::Builder,
    }
    impl<C, M, R> DescribeParameters<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeParameters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeParametersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeParametersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeParametersInputOperationOutputAlias,
                crate::output::DescribeParametersOutput,
                crate::error::DescribeParametersError,
                crate::input::DescribeParametersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>he name of a specific  parameter group to return details for.</p>
        pub fn parameter_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parameter_group_name(inp);
            self
        }
        /// <p>he name of a specific  parameter group to return details for.</p>
        pub fn set_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parameter_group_name(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeServiceUpdates`.
    ///
    /// <p>Returns details of the service updates</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeServiceUpdates<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_service_updates_input::Builder,
    }
    impl<C, M, R> DescribeServiceUpdates<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeServiceUpdates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeServiceUpdatesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeServiceUpdatesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeServiceUpdatesInputOperationOutputAlias,
                crate::output::DescribeServiceUpdatesOutput,
                crate::error::DescribeServiceUpdatesError,
                crate::input::DescribeServiceUpdatesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of the service update to describe.</p>
        pub fn service_update_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_update_name(inp);
            self
        }
        /// <p>The unique ID of the service update to describe.</p>
        pub fn set_service_update_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_service_update_name(input);
            self
        }
        /// Appends an item to `ClusterNames`.
        ///
        /// To override the contents of this collection use [`set_cluster_names`](Self::set_cluster_names).
        ///
        /// <p>The list of cluster names to identify service updates to apply</p>
        pub fn cluster_names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_names(inp);
            self
        }
        /// <p>The list of cluster names to identify service updates to apply</p>
        pub fn set_cluster_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_cluster_names(input);
            self
        }
        /// Appends an item to `Status`.
        ///
        /// To override the contents of this collection use [`set_status`](Self::set_status).
        ///
        /// <p>The status(es) of the service updates to filter on</p>
        pub fn status(mut self, inp: impl Into<crate::model::ServiceUpdateStatus>) -> Self {
            self.inner = self.inner.status(inp);
            self
        }
        /// <p>The status(es) of the service updates to filter on</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ServiceUpdateStatus>>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSnapshots`.
    ///
    /// <p>Returns information about cluster snapshots. By default, DescribeSnapshots lists all of your snapshots; it can optionally describe a single snapshot,
    /// or just the snapshots associated with a particular cluster.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeSnapshots<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_snapshots_input::Builder,
    }
    impl<C, M, R> DescribeSnapshots<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeSnapshots`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSnapshotsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSnapshotsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeSnapshotsInputOperationOutputAlias,
                crate::output::DescribeSnapshotsOutput,
                crate::error::DescribeSnapshotsError,
                crate::input::DescribeSnapshotsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A user-supplied cluster identifier. If this parameter is specified, only snapshots associated with that specific cluster are described.</p>
        pub fn cluster_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_name(inp);
            self
        }
        /// <p>A user-supplied cluster identifier. If this parameter is specified, only snapshots associated with that specific cluster are described.</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_name(input);
            self
        }
        /// <p>A user-supplied name of the snapshot. If this parameter is specified, only this named snapshot is described.</p>
        pub fn snapshot_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_name(inp);
            self
        }
        /// <p>A user-supplied name of the snapshot. If this parameter is specified, only this named snapshot is described.</p>
        pub fn set_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_name(input);
            self
        }
        /// <p>If set to system, the output shows snapshots that were automatically created by MemoryDB. If set to user the output shows snapshots that were manually created. If omitted, the output shows both automatically and manually created snapshots.</p>
        pub fn source(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source(inp);
            self
        }
        /// <p>If set to system, the output shows snapshots that were automatically created by MemoryDB. If set to user the output shows snapshots that were manually created. If omitted, the output shows both automatically and manually created snapshots.</p>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source(input);
            self
        }
        /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A Boolean value which if true, the shard configuration is included in the snapshot description.</p>
        pub fn show_detail(mut self, inp: bool) -> Self {
            self.inner = self.inner.show_detail(inp);
            self
        }
        /// <p>A Boolean value which if true, the shard configuration is included in the snapshot description.</p>
        pub fn set_show_detail(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_show_detail(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSubnetGroups`.
    ///
    /// <p>Returns a list of subnet group descriptions. If a subnet group name is specified, the list contains only the description of that group.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeSubnetGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_subnet_groups_input::Builder,
    }
    impl<C, M, R> DescribeSubnetGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeSubnetGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSubnetGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSubnetGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeSubnetGroupsInputOperationOutputAlias,
                crate::output::DescribeSubnetGroupsOutput,
                crate::error::DescribeSubnetGroupsError,
                crate::input::DescribeSubnetGroupsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the subnet group to return details for.</p>
        pub fn subnet_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_group_name(inp);
            self
        }
        /// <p>The name of the subnet group to return details for.</p>
        pub fn set_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subnet_group_name(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeUsers`.
    ///
    /// <p>Returns a list of users.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeUsers<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_users_input::Builder,
    }
    impl<C, M, R> DescribeUsers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeUsers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeUsersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeUsersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeUsersInputOperationOutputAlias,
                crate::output::DescribeUsersOutput,
                crate::error::DescribeUsersError,
                crate::input::DescribeUsersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the user</p>
        pub fn user_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(inp);
            self
        }
        /// <p>The name of the user</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filter to determine the list of users to return.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Filter to determine the list of users to return.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `FailoverShard`.
    ///
    /// <p>Used to failover a shard</p>
    #[derive(std::fmt::Debug)]
    pub struct FailoverShard<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::failover_shard_input::Builder,
    }
    impl<C, M, R> FailoverShard<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `FailoverShard`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::FailoverShardOutput,
            aws_smithy_http::result::SdkError<crate::error::FailoverShardError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::FailoverShardInputOperationOutputAlias,
                crate::output::FailoverShardOutput,
                crate::error::FailoverShardError,
                crate::input::FailoverShardInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The cluster being failed over</p>
        pub fn cluster_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_name(inp);
            self
        }
        /// <p>The cluster being failed over</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_name(input);
            self
        }
        /// <p>The name of the shard</p>
        pub fn shard_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.shard_name(inp);
            self
        }
        /// <p>The name of the shard</p>
        pub fn set_shard_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_shard_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAllowedNodeTypeUpdates`.
    ///
    /// <p>Lists all available node types that you can scale to from your cluster's current node type.
    ///
    /// When you use the UpdateCluster operation to scale your cluster, the value of the NodeType parameter must be one of the node types returned by this operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListAllowedNodeTypeUpdates<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_allowed_node_type_updates_input::Builder,
    }
    impl<C, M, R> ListAllowedNodeTypeUpdates<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAllowedNodeTypeUpdates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAllowedNodeTypeUpdatesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAllowedNodeTypeUpdatesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAllowedNodeTypeUpdatesInputOperationOutputAlias,
                crate::output::ListAllowedNodeTypeUpdatesOutput,
                crate::error::ListAllowedNodeTypeUpdatesError,
                crate::input::ListAllowedNodeTypeUpdatesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the cluster you want to scale. MemoryDB uses the cluster name to identify the current node type being used by this cluster, and from that to create a list of node types
        /// you can scale up to.</p>
        pub fn cluster_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_name(inp);
            self
        }
        /// <p>The name of the cluster you want to scale. MemoryDB uses the cluster name to identify the current node type being used by this cluster, and from that to create a list of node types
        /// you can scale up to.</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTags`.
    ///
    /// <p>Lists all tags currently on a named resource.
    ///
    /// A tag is a key-value pair where the key and value are case-sensitive. You can use tags to categorize and track your MemoryDB resources.
    /// For more information, see <a href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/Tagging-Resources.html">Tagging your MemoryDB resources</a>
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct ListTags<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_input::Builder,
    }
    impl<C, M, R> ListTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsInputOperationOutputAlias,
                crate::output::ListTagsOutput,
                crate::error::ListTagsError,
                crate::input::ListTagsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource for which you want the list of tags</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource for which you want the list of tags</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ResetParameterGroup`.
    ///
    /// <p>Modifies the parameters of a parameter group to the engine or system default value. You can reset specific parameters by submitting a list of parameter names. To reset the entire parameter group, specify the AllParameters and ParameterGroupName parameters.</p>
    #[derive(std::fmt::Debug)]
    pub struct ResetParameterGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::reset_parameter_group_input::Builder,
    }
    impl<C, M, R> ResetParameterGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ResetParameterGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ResetParameterGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::ResetParameterGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ResetParameterGroupInputOperationOutputAlias,
                crate::output::ResetParameterGroupOutput,
                crate::error::ResetParameterGroupError,
                crate::input::ResetParameterGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the parameter group to reset.</p>
        pub fn parameter_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parameter_group_name(inp);
            self
        }
        /// <p>The name of the parameter group to reset.</p>
        pub fn set_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parameter_group_name(input);
            self
        }
        /// <p>If true, all parameters in the parameter group are reset to their default values. If false, only the parameters listed by ParameterNames are reset to their default values.</p>
        pub fn all_parameters(mut self, inp: bool) -> Self {
            self.inner = self.inner.all_parameters(inp);
            self
        }
        /// <p>If true, all parameters in the parameter group are reset to their default values. If false, only the parameters listed by ParameterNames are reset to their default values.</p>
        pub fn set_all_parameters(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_all_parameters(input);
            self
        }
        /// Appends an item to `ParameterNames`.
        ///
        /// To override the contents of this collection use [`set_parameter_names`](Self::set_parameter_names).
        ///
        /// <p>An array of parameter names to reset to their default values. If AllParameters is true, do not use ParameterNames. If AllParameters is false, you must specify the name of at least one parameter to reset.</p>
        pub fn parameter_names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parameter_names(inp);
            self
        }
        /// <p>An array of parameter names to reset to their default values. If AllParameters is true, do not use ParameterNames. If AllParameters is false, you must specify the name of at least one parameter to reset.</p>
        pub fn set_parameter_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_parameter_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>A tag is a key-value pair where the key and value are case-sensitive. You can use tags to categorize and track all your MemoryDB resources.
    ///
    /// When you add or remove tags on clusters, those actions will be replicated to all nodes in the cluster. For more information, see
    ///
    /// <a href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/iam.resourcelevelpermissions.html">Resource-level permissions</a>.</p>
    ///
    /// <p>For example, you can use cost-allocation tags to your MemoryDB resources, Amazon generates a cost allocation report as a comma-separated value
    /// (CSV) file with your usage and costs aggregated by your tags. You can apply tags that represent business categories
    /// (such as cost centers, application names, or owners) to organize your costs across multiple services.
    ///
    /// For more information, see <a href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/tagging.html">Using Cost Allocation Tags</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to which the tags are to be added</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to which the tags are to be added</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Use this operation to remove tags on a resource</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to which the tags are to be removed</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to which the tags are to be removed</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The list of keys of the tags that are to be removed</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The list of keys of the tags that are to be removed</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateACL`.
    ///
    /// <p>Changes the list of users that belong to the Access Control List.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateACL<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_acl_input::Builder,
    }
    impl<C, M, R> UpdateACL<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateACL`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAclOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateACLError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateAclInputOperationOutputAlias,
                crate::output::UpdateAclOutput,
                crate::error::UpdateACLError,
                crate::input::UpdateAclInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Access Control List</p>
        pub fn acl_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.acl_name(inp);
            self
        }
        /// <p>The name of the Access Control List</p>
        pub fn set_acl_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_acl_name(input);
            self
        }
        /// Appends an item to `UserNamesToAdd`.
        ///
        /// To override the contents of this collection use [`set_user_names_to_add`](Self::set_user_names_to_add).
        ///
        /// <p>The list of users to add to the Access Control List</p>
        pub fn user_names_to_add(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_names_to_add(inp);
            self
        }
        /// <p>The list of users to add to the Access Control List</p>
        pub fn set_user_names_to_add(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_user_names_to_add(input);
            self
        }
        /// Appends an item to `UserNamesToRemove`.
        ///
        /// To override the contents of this collection use [`set_user_names_to_remove`](Self::set_user_names_to_remove).
        ///
        /// <p>The list of users to remove from the Access Control List</p>
        pub fn user_names_to_remove(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_names_to_remove(inp);
            self
        }
        /// <p>The list of users to remove from the Access Control List</p>
        pub fn set_user_names_to_remove(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_user_names_to_remove(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateCluster`.
    ///
    /// <p>Modifies the settings for a cluster. You can use this operation to change one or more cluster configuration settings by specifying the settings and the new values.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateCluster<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_cluster_input::Builder,
    }
    impl<C, M, R> UpdateCluster<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateClusterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateClusterInputOperationOutputAlias,
                crate::output::UpdateClusterOutput,
                crate::error::UpdateClusterError,
                crate::input::UpdateClusterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the cluster to update</p>
        pub fn cluster_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_name(inp);
            self
        }
        /// <p>The name of the cluster to update</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_name(input);
            self
        }
        /// <p>The description of the cluster to update</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the cluster to update</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `SecurityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>The SecurityGroupIds to update</p>
        pub fn security_group_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_group_ids(inp);
            self
        }
        /// <p>The SecurityGroupIds to update</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_security_group_ids(input);
            self
        }
        /// <p>The maintenance window to update</p>
        pub fn maintenance_window(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.maintenance_window(inp);
            self
        }
        /// <p>The maintenance window to update</p>
        pub fn set_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_maintenance_window(input);
            self
        }
        /// <p>The SNS topic ARN to update</p>
        pub fn sns_topic_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sns_topic_arn(inp);
            self
        }
        /// <p>The SNS topic ARN to update</p>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sns_topic_arn(input);
            self
        }
        /// <p>The status of the Amazon SNS notification topic. Notifications are sent only if the status is active.</p>
        pub fn sns_topic_status(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sns_topic_status(inp);
            self
        }
        /// <p>The status of the Amazon SNS notification topic. Notifications are sent only if the status is active.</p>
        pub fn set_sns_topic_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sns_topic_status(input);
            self
        }
        /// <p>The name of the parameter group to update</p>
        pub fn parameter_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parameter_group_name(inp);
            self
        }
        /// <p>The name of the parameter group to update</p>
        pub fn set_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parameter_group_name(input);
            self
        }
        /// <p>The daily time range (in UTC) during which MemoryDB begins taking a daily snapshot of your cluster.</p>
        pub fn snapshot_window(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_window(inp);
            self
        }
        /// <p>The daily time range (in UTC) during which MemoryDB begins taking a daily snapshot of your cluster.</p>
        pub fn set_snapshot_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_window(input);
            self
        }
        /// <p>The number of days for which MemoryDB retains automatic cluster snapshots before deleting them. For example, if you set SnapshotRetentionLimit to 5, a snapshot that was taken today is retained for 5 days before being deleted.</p>
        pub fn snapshot_retention_limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.snapshot_retention_limit(inp);
            self
        }
        /// <p>The number of days for which MemoryDB retains automatic cluster snapshots before deleting them. For example, if you set SnapshotRetentionLimit to 5, a snapshot that was taken today is retained for 5 days before being deleted.</p>
        pub fn set_snapshot_retention_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_snapshot_retention_limit(input);
            self
        }
        /// <p>A valid node type that you want to scale this cluster up or down to.</p>
        pub fn node_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.node_type(inp);
            self
        }
        /// <p>A valid node type that you want to scale this cluster up or down to.</p>
        pub fn set_node_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_node_type(input);
            self
        }
        /// <p>The upgraded version of the engine to be run on the nodes. You can upgrade to a newer engine version, but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing cluster and create it anew with the earlier engine version.</p>
        pub fn engine_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_version(inp);
            self
        }
        /// <p>The upgraded version of the engine to be run on the nodes. You can upgrade to a newer engine version, but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing cluster and create it anew with the earlier engine version.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engine_version(input);
            self
        }
        /// <p>The number of replicas that will reside in each shard</p>
        pub fn replica_configuration(
            mut self,
            inp: crate::model::ReplicaConfigurationRequest,
        ) -> Self {
            self.inner = self.inner.replica_configuration(inp);
            self
        }
        /// <p>The number of replicas that will reside in each shard</p>
        pub fn set_replica_configuration(
            mut self,
            input: std::option::Option<crate::model::ReplicaConfigurationRequest>,
        ) -> Self {
            self.inner = self.inner.set_replica_configuration(input);
            self
        }
        /// <p>The number of shards in the cluster</p>
        pub fn shard_configuration(mut self, inp: crate::model::ShardConfigurationRequest) -> Self {
            self.inner = self.inner.shard_configuration(inp);
            self
        }
        /// <p>The number of shards in the cluster</p>
        pub fn set_shard_configuration(
            mut self,
            input: std::option::Option<crate::model::ShardConfigurationRequest>,
        ) -> Self {
            self.inner = self.inner.set_shard_configuration(input);
            self
        }
        /// <p>The Access Control List that is associated with the cluster</p>
        pub fn acl_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.acl_name(inp);
            self
        }
        /// <p>The Access Control List that is associated with the cluster</p>
        pub fn set_acl_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_acl_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateParameterGroup`.
    ///
    /// <p>Updates the parameters of a parameter group. You can modify up to 20 parameters in a single request by submitting a list parameter name and value pairs.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateParameterGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_parameter_group_input::Builder,
    }
    impl<C, M, R> UpdateParameterGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateParameterGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateParameterGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateParameterGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateParameterGroupInputOperationOutputAlias,
                crate::output::UpdateParameterGroupOutput,
                crate::error::UpdateParameterGroupError,
                crate::input::UpdateParameterGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the parameter group to update.</p>
        pub fn parameter_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parameter_group_name(inp);
            self
        }
        /// <p>The name of the parameter group to update.</p>
        pub fn set_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parameter_group_name(input);
            self
        }
        /// Appends an item to `ParameterNameValues`.
        ///
        /// To override the contents of this collection use [`set_parameter_name_values`](Self::set_parameter_name_values).
        ///
        /// <p>An array of parameter names and values for the parameter update. You must supply at least one parameter name and value; subsequent arguments are optional. A maximum of 20 parameters may be updated per request.</p>
        pub fn parameter_name_values(
            mut self,
            inp: impl Into<crate::model::ParameterNameValue>,
        ) -> Self {
            self.inner = self.inner.parameter_name_values(inp);
            self
        }
        /// <p>An array of parameter names and values for the parameter update. You must supply at least one parameter name and value; subsequent arguments are optional. A maximum of 20 parameters may be updated per request.</p>
        pub fn set_parameter_name_values(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ParameterNameValue>>,
        ) -> Self {
            self.inner = self.inner.set_parameter_name_values(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSubnetGroup`.
    ///
    /// <p>Updates a subnet group. For more information, see <a href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/ubnetGroups.Modifying.html">Updating a subnet group</a>
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateSubnetGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_subnet_group_input::Builder,
    }
    impl<C, M, R> UpdateSubnetGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateSubnetGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSubnetGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSubnetGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateSubnetGroupInputOperationOutputAlias,
                crate::output::UpdateSubnetGroupOutput,
                crate::error::UpdateSubnetGroupError,
                crate::input::UpdateSubnetGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the subnet group</p>
        pub fn subnet_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_group_name(inp);
            self
        }
        /// <p>The name of the subnet group</p>
        pub fn set_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subnet_group_name(input);
            self
        }
        /// <p>A description of the subnet group</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description of the subnet group</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `SubnetIds`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>The EC2 subnet IDs for the subnet group.</p>
        pub fn subnet_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_ids(inp);
            self
        }
        /// <p>The EC2 subnet IDs for the subnet group.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subnet_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateUser`.
    ///
    /// <p>Changes user password(s) and/or access string.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateUser<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_user_input::Builder,
    }
    impl<C, M, R> UpdateUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateUserOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateUserInputOperationOutputAlias,
                crate::output::UpdateUserOutput,
                crate::error::UpdateUserError,
                crate::input::UpdateUserInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the user</p>
        pub fn user_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(inp);
            self
        }
        /// <p>The name of the user</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>Denotes the user's authentication properties, such as whether it requires a password to authenticate.</p>
        pub fn authentication_mode(mut self, inp: crate::model::AuthenticationMode) -> Self {
            self.inner = self.inner.authentication_mode(inp);
            self
        }
        /// <p>Denotes the user's authentication properties, such as whether it requires a password to authenticate.</p>
        pub fn set_authentication_mode(
            mut self,
            input: std::option::Option<crate::model::AuthenticationMode>,
        ) -> Self {
            self.inner = self.inner.set_authentication_mode(input);
            self
        }
        /// <p>Access permissions string used for this user.</p>
        pub fn access_string(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.access_string(inp);
            self
        }
        /// <p>Access permissions string used for this user.</p>
        pub fn set_access_string(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_access_string(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::new(conn)
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::https()
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
