// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `BatchUpdateCluster`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_update_cluster`](crate::client::Client::batch_update_cluster).
///
/// See [`crate::client::fluent_builders::BatchUpdateCluster`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchUpdateCluster {
    _private: (),
}
impl BatchUpdateCluster {
    /// Creates a new builder-style object to manufacture [`BatchUpdateClusterInput`](crate::input::BatchUpdateClusterInput)
    pub fn builder() -> crate::input::batch_update_cluster_input::Builder {
        crate::input::batch_update_cluster_input::Builder::default()
    }
    /// Creates a new `BatchUpdateCluster` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchUpdateCluster {
    type Output = std::result::Result<
        crate::output::BatchUpdateClusterOutput,
        crate::error::BatchUpdateClusterError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_update_cluster_error(response)
        } else {
            crate::operation_deser::parse_batch_update_cluster_response(response)
        }
    }
}

/// Operation shape for `CopySnapshot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`copy_snapshot`](crate::client::Client::copy_snapshot).
///
/// See [`crate::client::fluent_builders::CopySnapshot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CopySnapshot {
    _private: (),
}
impl CopySnapshot {
    /// Creates a new builder-style object to manufacture [`CopySnapshotInput`](crate::input::CopySnapshotInput)
    pub fn builder() -> crate::input::copy_snapshot_input::Builder {
        crate::input::copy_snapshot_input::Builder::default()
    }
    /// Creates a new `CopySnapshot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CopySnapshot {
    type Output =
        std::result::Result<crate::output::CopySnapshotOutput, crate::error::CopySnapshotError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_copy_snapshot_error(response)
        } else {
            crate::operation_deser::parse_copy_snapshot_response(response)
        }
    }
}

/// Operation shape for `CreateACL`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_acl`](crate::client::Client::create_acl).
///
/// See [`crate::client::fluent_builders::CreateACL`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateACL {
    _private: (),
}
impl CreateACL {
    /// Creates a new builder-style object to manufacture [`CreateAclInput`](crate::input::CreateAclInput)
    pub fn builder() -> crate::input::create_acl_input::Builder {
        crate::input::create_acl_input::Builder::default()
    }
    /// Creates a new `CreateACL` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateACL {
    type Output = std::result::Result<crate::output::CreateAclOutput, crate::error::CreateACLError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_acl_error(response)
        } else {
            crate::operation_deser::parse_create_acl_response(response)
        }
    }
}

/// Operation shape for `CreateCluster`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_cluster`](crate::client::Client::create_cluster).
///
/// See [`crate::client::fluent_builders::CreateCluster`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateCluster {
    _private: (),
}
impl CreateCluster {
    /// Creates a new builder-style object to manufacture [`CreateClusterInput`](crate::input::CreateClusterInput)
    pub fn builder() -> crate::input::create_cluster_input::Builder {
        crate::input::create_cluster_input::Builder::default()
    }
    /// Creates a new `CreateCluster` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateCluster {
    type Output =
        std::result::Result<crate::output::CreateClusterOutput, crate::error::CreateClusterError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_cluster_error(response)
        } else {
            crate::operation_deser::parse_create_cluster_response(response)
        }
    }
}

/// Operation shape for `CreateParameterGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_parameter_group`](crate::client::Client::create_parameter_group).
///
/// See [`crate::client::fluent_builders::CreateParameterGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateParameterGroup {
    _private: (),
}
impl CreateParameterGroup {
    /// Creates a new builder-style object to manufacture [`CreateParameterGroupInput`](crate::input::CreateParameterGroupInput)
    pub fn builder() -> crate::input::create_parameter_group_input::Builder {
        crate::input::create_parameter_group_input::Builder::default()
    }
    /// Creates a new `CreateParameterGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateParameterGroup {
    type Output = std::result::Result<
        crate::output::CreateParameterGroupOutput,
        crate::error::CreateParameterGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_parameter_group_error(response)
        } else {
            crate::operation_deser::parse_create_parameter_group_response(response)
        }
    }
}

/// Operation shape for `CreateSnapshot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_snapshot`](crate::client::Client::create_snapshot).
///
/// See [`crate::client::fluent_builders::CreateSnapshot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateSnapshot {
    _private: (),
}
impl CreateSnapshot {
    /// Creates a new builder-style object to manufacture [`CreateSnapshotInput`](crate::input::CreateSnapshotInput)
    pub fn builder() -> crate::input::create_snapshot_input::Builder {
        crate::input::create_snapshot_input::Builder::default()
    }
    /// Creates a new `CreateSnapshot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateSnapshot {
    type Output =
        std::result::Result<crate::output::CreateSnapshotOutput, crate::error::CreateSnapshotError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_snapshot_error(response)
        } else {
            crate::operation_deser::parse_create_snapshot_response(response)
        }
    }
}

/// Operation shape for `CreateSubnetGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_subnet_group`](crate::client::Client::create_subnet_group).
///
/// See [`crate::client::fluent_builders::CreateSubnetGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateSubnetGroup {
    _private: (),
}
impl CreateSubnetGroup {
    /// Creates a new builder-style object to manufacture [`CreateSubnetGroupInput`](crate::input::CreateSubnetGroupInput)
    pub fn builder() -> crate::input::create_subnet_group_input::Builder {
        crate::input::create_subnet_group_input::Builder::default()
    }
    /// Creates a new `CreateSubnetGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateSubnetGroup {
    type Output = std::result::Result<
        crate::output::CreateSubnetGroupOutput,
        crate::error::CreateSubnetGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_subnet_group_error(response)
        } else {
            crate::operation_deser::parse_create_subnet_group_response(response)
        }
    }
}

/// Operation shape for `CreateUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_user`](crate::client::Client::create_user).
///
/// See [`crate::client::fluent_builders::CreateUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateUser {
    _private: (),
}
impl CreateUser {
    /// Creates a new builder-style object to manufacture [`CreateUserInput`](crate::input::CreateUserInput)
    pub fn builder() -> crate::input::create_user_input::Builder {
        crate::input::create_user_input::Builder::default()
    }
    /// Creates a new `CreateUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateUser {
    type Output =
        std::result::Result<crate::output::CreateUserOutput, crate::error::CreateUserError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_user_error(response)
        } else {
            crate::operation_deser::parse_create_user_response(response)
        }
    }
}

/// Operation shape for `DeleteACL`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_acl`](crate::client::Client::delete_acl).
///
/// See [`crate::client::fluent_builders::DeleteACL`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteACL {
    _private: (),
}
impl DeleteACL {
    /// Creates a new builder-style object to manufacture [`DeleteAclInput`](crate::input::DeleteAclInput)
    pub fn builder() -> crate::input::delete_acl_input::Builder {
        crate::input::delete_acl_input::Builder::default()
    }
    /// Creates a new `DeleteACL` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteACL {
    type Output = std::result::Result<crate::output::DeleteAclOutput, crate::error::DeleteACLError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_acl_error(response)
        } else {
            crate::operation_deser::parse_delete_acl_response(response)
        }
    }
}

/// Operation shape for `DeleteCluster`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_cluster`](crate::client::Client::delete_cluster).
///
/// See [`crate::client::fluent_builders::DeleteCluster`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteCluster {
    _private: (),
}
impl DeleteCluster {
    /// Creates a new builder-style object to manufacture [`DeleteClusterInput`](crate::input::DeleteClusterInput)
    pub fn builder() -> crate::input::delete_cluster_input::Builder {
        crate::input::delete_cluster_input::Builder::default()
    }
    /// Creates a new `DeleteCluster` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteCluster {
    type Output =
        std::result::Result<crate::output::DeleteClusterOutput, crate::error::DeleteClusterError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_cluster_error(response)
        } else {
            crate::operation_deser::parse_delete_cluster_response(response)
        }
    }
}

/// Operation shape for `DeleteParameterGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_parameter_group`](crate::client::Client::delete_parameter_group).
///
/// See [`crate::client::fluent_builders::DeleteParameterGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteParameterGroup {
    _private: (),
}
impl DeleteParameterGroup {
    /// Creates a new builder-style object to manufacture [`DeleteParameterGroupInput`](crate::input::DeleteParameterGroupInput)
    pub fn builder() -> crate::input::delete_parameter_group_input::Builder {
        crate::input::delete_parameter_group_input::Builder::default()
    }
    /// Creates a new `DeleteParameterGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteParameterGroup {
    type Output = std::result::Result<
        crate::output::DeleteParameterGroupOutput,
        crate::error::DeleteParameterGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_parameter_group_error(response)
        } else {
            crate::operation_deser::parse_delete_parameter_group_response(response)
        }
    }
}

/// Operation shape for `DeleteSnapshot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_snapshot`](crate::client::Client::delete_snapshot).
///
/// See [`crate::client::fluent_builders::DeleteSnapshot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteSnapshot {
    _private: (),
}
impl DeleteSnapshot {
    /// Creates a new builder-style object to manufacture [`DeleteSnapshotInput`](crate::input::DeleteSnapshotInput)
    pub fn builder() -> crate::input::delete_snapshot_input::Builder {
        crate::input::delete_snapshot_input::Builder::default()
    }
    /// Creates a new `DeleteSnapshot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteSnapshot {
    type Output =
        std::result::Result<crate::output::DeleteSnapshotOutput, crate::error::DeleteSnapshotError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_snapshot_error(response)
        } else {
            crate::operation_deser::parse_delete_snapshot_response(response)
        }
    }
}

/// Operation shape for `DeleteSubnetGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_subnet_group`](crate::client::Client::delete_subnet_group).
///
/// See [`crate::client::fluent_builders::DeleteSubnetGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteSubnetGroup {
    _private: (),
}
impl DeleteSubnetGroup {
    /// Creates a new builder-style object to manufacture [`DeleteSubnetGroupInput`](crate::input::DeleteSubnetGroupInput)
    pub fn builder() -> crate::input::delete_subnet_group_input::Builder {
        crate::input::delete_subnet_group_input::Builder::default()
    }
    /// Creates a new `DeleteSubnetGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteSubnetGroup {
    type Output = std::result::Result<
        crate::output::DeleteSubnetGroupOutput,
        crate::error::DeleteSubnetGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_subnet_group_error(response)
        } else {
            crate::operation_deser::parse_delete_subnet_group_response(response)
        }
    }
}

/// Operation shape for `DeleteUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_user`](crate::client::Client::delete_user).
///
/// See [`crate::client::fluent_builders::DeleteUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteUser {
    _private: (),
}
impl DeleteUser {
    /// Creates a new builder-style object to manufacture [`DeleteUserInput`](crate::input::DeleteUserInput)
    pub fn builder() -> crate::input::delete_user_input::Builder {
        crate::input::delete_user_input::Builder::default()
    }
    /// Creates a new `DeleteUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteUser {
    type Output =
        std::result::Result<crate::output::DeleteUserOutput, crate::error::DeleteUserError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_user_error(response)
        } else {
            crate::operation_deser::parse_delete_user_response(response)
        }
    }
}

/// Operation shape for `DescribeACLs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_ac_ls`](crate::client::Client::describe_ac_ls).
///
/// See [`crate::client::fluent_builders::DescribeACLs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeACLs {
    _private: (),
}
impl DescribeACLs {
    /// Creates a new builder-style object to manufacture [`DescribeAcLsInput`](crate::input::DescribeAcLsInput)
    pub fn builder() -> crate::input::describe_ac_ls_input::Builder {
        crate::input::describe_ac_ls_input::Builder::default()
    }
    /// Creates a new `DescribeACLs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeACLs {
    type Output =
        std::result::Result<crate::output::DescribeAcLsOutput, crate::error::DescribeACLsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_ac_ls_error(response)
        } else {
            crate::operation_deser::parse_describe_ac_ls_response(response)
        }
    }
}

/// Operation shape for `DescribeClusters`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_clusters`](crate::client::Client::describe_clusters).
///
/// See [`crate::client::fluent_builders::DescribeClusters`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeClusters {
    _private: (),
}
impl DescribeClusters {
    /// Creates a new builder-style object to manufacture [`DescribeClustersInput`](crate::input::DescribeClustersInput)
    pub fn builder() -> crate::input::describe_clusters_input::Builder {
        crate::input::describe_clusters_input::Builder::default()
    }
    /// Creates a new `DescribeClusters` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeClusters {
    type Output = std::result::Result<
        crate::output::DescribeClustersOutput,
        crate::error::DescribeClustersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_clusters_error(response)
        } else {
            crate::operation_deser::parse_describe_clusters_response(response)
        }
    }
}

/// Operation shape for `DescribeEngineVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_engine_versions`](crate::client::Client::describe_engine_versions).
///
/// See [`crate::client::fluent_builders::DescribeEngineVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeEngineVersions {
    _private: (),
}
impl DescribeEngineVersions {
    /// Creates a new builder-style object to manufacture [`DescribeEngineVersionsInput`](crate::input::DescribeEngineVersionsInput)
    pub fn builder() -> crate::input::describe_engine_versions_input::Builder {
        crate::input::describe_engine_versions_input::Builder::default()
    }
    /// Creates a new `DescribeEngineVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeEngineVersions {
    type Output = std::result::Result<
        crate::output::DescribeEngineVersionsOutput,
        crate::error::DescribeEngineVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_engine_versions_error(response)
        } else {
            crate::operation_deser::parse_describe_engine_versions_response(response)
        }
    }
}

/// Operation shape for `DescribeEvents`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_events`](crate::client::Client::describe_events).
///
/// See [`crate::client::fluent_builders::DescribeEvents`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeEvents {
    _private: (),
}
impl DescribeEvents {
    /// Creates a new builder-style object to manufacture [`DescribeEventsInput`](crate::input::DescribeEventsInput)
    pub fn builder() -> crate::input::describe_events_input::Builder {
        crate::input::describe_events_input::Builder::default()
    }
    /// Creates a new `DescribeEvents` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeEvents {
    type Output =
        std::result::Result<crate::output::DescribeEventsOutput, crate::error::DescribeEventsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_events_error(response)
        } else {
            crate::operation_deser::parse_describe_events_response(response)
        }
    }
}

/// Operation shape for `DescribeParameterGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_parameter_groups`](crate::client::Client::describe_parameter_groups).
///
/// See [`crate::client::fluent_builders::DescribeParameterGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeParameterGroups {
    _private: (),
}
impl DescribeParameterGroups {
    /// Creates a new builder-style object to manufacture [`DescribeParameterGroupsInput`](crate::input::DescribeParameterGroupsInput)
    pub fn builder() -> crate::input::describe_parameter_groups_input::Builder {
        crate::input::describe_parameter_groups_input::Builder::default()
    }
    /// Creates a new `DescribeParameterGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeParameterGroups {
    type Output = std::result::Result<
        crate::output::DescribeParameterGroupsOutput,
        crate::error::DescribeParameterGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_parameter_groups_error(response)
        } else {
            crate::operation_deser::parse_describe_parameter_groups_response(response)
        }
    }
}

/// Operation shape for `DescribeParameters`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_parameters`](crate::client::Client::describe_parameters).
///
/// See [`crate::client::fluent_builders::DescribeParameters`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeParameters {
    _private: (),
}
impl DescribeParameters {
    /// Creates a new builder-style object to manufacture [`DescribeParametersInput`](crate::input::DescribeParametersInput)
    pub fn builder() -> crate::input::describe_parameters_input::Builder {
        crate::input::describe_parameters_input::Builder::default()
    }
    /// Creates a new `DescribeParameters` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeParameters {
    type Output = std::result::Result<
        crate::output::DescribeParametersOutput,
        crate::error::DescribeParametersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_parameters_error(response)
        } else {
            crate::operation_deser::parse_describe_parameters_response(response)
        }
    }
}

/// Operation shape for `DescribeServiceUpdates`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_service_updates`](crate::client::Client::describe_service_updates).
///
/// See [`crate::client::fluent_builders::DescribeServiceUpdates`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeServiceUpdates {
    _private: (),
}
impl DescribeServiceUpdates {
    /// Creates a new builder-style object to manufacture [`DescribeServiceUpdatesInput`](crate::input::DescribeServiceUpdatesInput)
    pub fn builder() -> crate::input::describe_service_updates_input::Builder {
        crate::input::describe_service_updates_input::Builder::default()
    }
    /// Creates a new `DescribeServiceUpdates` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeServiceUpdates {
    type Output = std::result::Result<
        crate::output::DescribeServiceUpdatesOutput,
        crate::error::DescribeServiceUpdatesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_service_updates_error(response)
        } else {
            crate::operation_deser::parse_describe_service_updates_response(response)
        }
    }
}

/// Operation shape for `DescribeSnapshots`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_snapshots`](crate::client::Client::describe_snapshots).
///
/// See [`crate::client::fluent_builders::DescribeSnapshots`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeSnapshots {
    _private: (),
}
impl DescribeSnapshots {
    /// Creates a new builder-style object to manufacture [`DescribeSnapshotsInput`](crate::input::DescribeSnapshotsInput)
    pub fn builder() -> crate::input::describe_snapshots_input::Builder {
        crate::input::describe_snapshots_input::Builder::default()
    }
    /// Creates a new `DescribeSnapshots` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeSnapshots {
    type Output = std::result::Result<
        crate::output::DescribeSnapshotsOutput,
        crate::error::DescribeSnapshotsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_snapshots_error(response)
        } else {
            crate::operation_deser::parse_describe_snapshots_response(response)
        }
    }
}

/// Operation shape for `DescribeSubnetGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_subnet_groups`](crate::client::Client::describe_subnet_groups).
///
/// See [`crate::client::fluent_builders::DescribeSubnetGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeSubnetGroups {
    _private: (),
}
impl DescribeSubnetGroups {
    /// Creates a new builder-style object to manufacture [`DescribeSubnetGroupsInput`](crate::input::DescribeSubnetGroupsInput)
    pub fn builder() -> crate::input::describe_subnet_groups_input::Builder {
        crate::input::describe_subnet_groups_input::Builder::default()
    }
    /// Creates a new `DescribeSubnetGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeSubnetGroups {
    type Output = std::result::Result<
        crate::output::DescribeSubnetGroupsOutput,
        crate::error::DescribeSubnetGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_subnet_groups_error(response)
        } else {
            crate::operation_deser::parse_describe_subnet_groups_response(response)
        }
    }
}

/// Operation shape for `DescribeUsers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_users`](crate::client::Client::describe_users).
///
/// See [`crate::client::fluent_builders::DescribeUsers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeUsers {
    _private: (),
}
impl DescribeUsers {
    /// Creates a new builder-style object to manufacture [`DescribeUsersInput`](crate::input::DescribeUsersInput)
    pub fn builder() -> crate::input::describe_users_input::Builder {
        crate::input::describe_users_input::Builder::default()
    }
    /// Creates a new `DescribeUsers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeUsers {
    type Output =
        std::result::Result<crate::output::DescribeUsersOutput, crate::error::DescribeUsersError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_users_error(response)
        } else {
            crate::operation_deser::parse_describe_users_response(response)
        }
    }
}

/// Operation shape for `FailoverShard`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`failover_shard`](crate::client::Client::failover_shard).
///
/// See [`crate::client::fluent_builders::FailoverShard`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct FailoverShard {
    _private: (),
}
impl FailoverShard {
    /// Creates a new builder-style object to manufacture [`FailoverShardInput`](crate::input::FailoverShardInput)
    pub fn builder() -> crate::input::failover_shard_input::Builder {
        crate::input::failover_shard_input::Builder::default()
    }
    /// Creates a new `FailoverShard` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for FailoverShard {
    type Output =
        std::result::Result<crate::output::FailoverShardOutput, crate::error::FailoverShardError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_failover_shard_error(response)
        } else {
            crate::operation_deser::parse_failover_shard_response(response)
        }
    }
}

/// Operation shape for `ListAllowedNodeTypeUpdates`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_allowed_node_type_updates`](crate::client::Client::list_allowed_node_type_updates).
///
/// See [`crate::client::fluent_builders::ListAllowedNodeTypeUpdates`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAllowedNodeTypeUpdates {
    _private: (),
}
impl ListAllowedNodeTypeUpdates {
    /// Creates a new builder-style object to manufacture [`ListAllowedNodeTypeUpdatesInput`](crate::input::ListAllowedNodeTypeUpdatesInput)
    pub fn builder() -> crate::input::list_allowed_node_type_updates_input::Builder {
        crate::input::list_allowed_node_type_updates_input::Builder::default()
    }
    /// Creates a new `ListAllowedNodeTypeUpdates` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAllowedNodeTypeUpdates {
    type Output = std::result::Result<
        crate::output::ListAllowedNodeTypeUpdatesOutput,
        crate::error::ListAllowedNodeTypeUpdatesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_allowed_node_type_updates_error(response)
        } else {
            crate::operation_deser::parse_list_allowed_node_type_updates_response(response)
        }
    }
}

/// Operation shape for `ListTags`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags`](crate::client::Client::list_tags).
///
/// See [`crate::client::fluent_builders::ListTags`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTags {
    _private: (),
}
impl ListTags {
    /// Creates a new builder-style object to manufacture [`ListTagsInput`](crate::input::ListTagsInput)
    pub fn builder() -> crate::input::list_tags_input::Builder {
        crate::input::list_tags_input::Builder::default()
    }
    /// Creates a new `ListTags` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTags {
    type Output = std::result::Result<crate::output::ListTagsOutput, crate::error::ListTagsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_error(response)
        } else {
            crate::operation_deser::parse_list_tags_response(response)
        }
    }
}

/// Operation shape for `ResetParameterGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`reset_parameter_group`](crate::client::Client::reset_parameter_group).
///
/// See [`crate::client::fluent_builders::ResetParameterGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ResetParameterGroup {
    _private: (),
}
impl ResetParameterGroup {
    /// Creates a new builder-style object to manufacture [`ResetParameterGroupInput`](crate::input::ResetParameterGroupInput)
    pub fn builder() -> crate::input::reset_parameter_group_input::Builder {
        crate::input::reset_parameter_group_input::Builder::default()
    }
    /// Creates a new `ResetParameterGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ResetParameterGroup {
    type Output = std::result::Result<
        crate::output::ResetParameterGroupOutput,
        crate::error::ResetParameterGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_reset_parameter_group_error(response)
        } else {
            crate::operation_deser::parse_reset_parameter_group_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateACL`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_acl`](crate::client::Client::update_acl).
///
/// See [`crate::client::fluent_builders::UpdateACL`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateACL {
    _private: (),
}
impl UpdateACL {
    /// Creates a new builder-style object to manufacture [`UpdateAclInput`](crate::input::UpdateAclInput)
    pub fn builder() -> crate::input::update_acl_input::Builder {
        crate::input::update_acl_input::Builder::default()
    }
    /// Creates a new `UpdateACL` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateACL {
    type Output = std::result::Result<crate::output::UpdateAclOutput, crate::error::UpdateACLError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_acl_error(response)
        } else {
            crate::operation_deser::parse_update_acl_response(response)
        }
    }
}

/// Operation shape for `UpdateCluster`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_cluster`](crate::client::Client::update_cluster).
///
/// See [`crate::client::fluent_builders::UpdateCluster`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateCluster {
    _private: (),
}
impl UpdateCluster {
    /// Creates a new builder-style object to manufacture [`UpdateClusterInput`](crate::input::UpdateClusterInput)
    pub fn builder() -> crate::input::update_cluster_input::Builder {
        crate::input::update_cluster_input::Builder::default()
    }
    /// Creates a new `UpdateCluster` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateCluster {
    type Output =
        std::result::Result<crate::output::UpdateClusterOutput, crate::error::UpdateClusterError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_cluster_error(response)
        } else {
            crate::operation_deser::parse_update_cluster_response(response)
        }
    }
}

/// Operation shape for `UpdateParameterGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_parameter_group`](crate::client::Client::update_parameter_group).
///
/// See [`crate::client::fluent_builders::UpdateParameterGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateParameterGroup {
    _private: (),
}
impl UpdateParameterGroup {
    /// Creates a new builder-style object to manufacture [`UpdateParameterGroupInput`](crate::input::UpdateParameterGroupInput)
    pub fn builder() -> crate::input::update_parameter_group_input::Builder {
        crate::input::update_parameter_group_input::Builder::default()
    }
    /// Creates a new `UpdateParameterGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateParameterGroup {
    type Output = std::result::Result<
        crate::output::UpdateParameterGroupOutput,
        crate::error::UpdateParameterGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_parameter_group_error(response)
        } else {
            crate::operation_deser::parse_update_parameter_group_response(response)
        }
    }
}

/// Operation shape for `UpdateSubnetGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_subnet_group`](crate::client::Client::update_subnet_group).
///
/// See [`crate::client::fluent_builders::UpdateSubnetGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateSubnetGroup {
    _private: (),
}
impl UpdateSubnetGroup {
    /// Creates a new builder-style object to manufacture [`UpdateSubnetGroupInput`](crate::input::UpdateSubnetGroupInput)
    pub fn builder() -> crate::input::update_subnet_group_input::Builder {
        crate::input::update_subnet_group_input::Builder::default()
    }
    /// Creates a new `UpdateSubnetGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateSubnetGroup {
    type Output = std::result::Result<
        crate::output::UpdateSubnetGroupOutput,
        crate::error::UpdateSubnetGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_subnet_group_error(response)
        } else {
            crate::operation_deser::parse_update_subnet_group_response(response)
        }
    }
}

/// Operation shape for `UpdateUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_user`](crate::client::Client::update_user).
///
/// See [`crate::client::fluent_builders::UpdateUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateUser {
    _private: (),
}
impl UpdateUser {
    /// Creates a new builder-style object to manufacture [`UpdateUserInput`](crate::input::UpdateUserInput)
    pub fn builder() -> crate::input::update_user_input::Builder {
        crate::input::update_user_input::Builder::default()
    }
    /// Creates a new `UpdateUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateUser {
    type Output =
        std::result::Result<crate::output::UpdateUserOutput, crate::error::UpdateUserError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_user_error(response)
        } else {
            crate::operation_deser::parse_update_user_response(response)
        }
    }
}
