// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>You create users and assign them specific permissions by using an access string. You assign the users to Access Control Lists aligned with a specific role (administrators, human resources) that are then deployed to one or more MemoryDB clusters.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct User {
    /// <p>The name of the user</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Indicates the user status. Can be "active", "modifying" or "deleting".</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>Access permissions string used for this user.</p>
    pub access_string: std::option::Option<std::string::String>,
    /// <p>The names of the Access Control Lists to which the user belongs</p>
    pub acl_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The minimum engine version supported for the user</p>
    pub minimum_engine_version: std::option::Option<std::string::String>,
    /// <p>Denotes whether the user requires a password to authenticate.</p>
    pub authentication: std::option::Option<crate::model::Authentication>,
    /// <p>The Amazon Resource Name (ARN) of the user.
    ///
    /// </p>
    pub arn: std::option::Option<std::string::String>,
}
impl User {
    /// <p>The name of the user</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Indicates the user status. Can be "active", "modifying" or "deleting".</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>Access permissions string used for this user.</p>
    pub fn access_string(&self) -> std::option::Option<&str> {
        self.access_string.as_deref()
    }
    /// <p>The names of the Access Control Lists to which the user belongs</p>
    pub fn acl_names(&self) -> std::option::Option<&[std::string::String]> {
        self.acl_names.as_deref()
    }
    /// <p>The minimum engine version supported for the user</p>
    pub fn minimum_engine_version(&self) -> std::option::Option<&str> {
        self.minimum_engine_version.as_deref()
    }
    /// <p>Denotes whether the user requires a password to authenticate.</p>
    pub fn authentication(&self) -> std::option::Option<&crate::model::Authentication> {
        self.authentication.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the user.
    ///
    /// </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for User {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("User");
        formatter.field("name", &self.name);
        formatter.field("status", &self.status);
        formatter.field("access_string", &self.access_string);
        formatter.field("acl_names", &self.acl_names);
        formatter.field("minimum_engine_version", &self.minimum_engine_version);
        formatter.field("authentication", &self.authentication);
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`User`](crate::model::User)
pub mod user {
    /// A builder for [`User`](crate::model::User)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) access_string: std::option::Option<std::string::String>,
        pub(crate) acl_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) minimum_engine_version: std::option::Option<std::string::String>,
        pub(crate) authentication: std::option::Option<crate::model::Authentication>,
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the user</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the user</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Indicates the user status. Can be "active", "modifying" or "deleting".</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>Indicates the user status. Can be "active", "modifying" or "deleting".</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>Access permissions string used for this user.</p>
        pub fn access_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_string = Some(input.into());
            self
        }
        /// <p>Access permissions string used for this user.</p>
        pub fn set_access_string(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.access_string = input;
            self
        }
        /// Appends an item to `acl_names`.
        ///
        /// To override the contents of this collection use [`set_acl_names`](Self::set_acl_names).
        ///
        /// <p>The names of the Access Control Lists to which the user belongs</p>
        pub fn acl_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.acl_names.unwrap_or_default();
            v.push(input.into());
            self.acl_names = Some(v);
            self
        }
        /// <p>The names of the Access Control Lists to which the user belongs</p>
        pub fn set_acl_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.acl_names = input;
            self
        }
        /// <p>The minimum engine version supported for the user</p>
        pub fn minimum_engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.minimum_engine_version = Some(input.into());
            self
        }
        /// <p>The minimum engine version supported for the user</p>
        pub fn set_minimum_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.minimum_engine_version = input;
            self
        }
        /// <p>Denotes whether the user requires a password to authenticate.</p>
        pub fn authentication(mut self, input: crate::model::Authentication) -> Self {
            self.authentication = Some(input);
            self
        }
        /// <p>Denotes whether the user requires a password to authenticate.</p>
        pub fn set_authentication(
            mut self,
            input: std::option::Option<crate::model::Authentication>,
        ) -> Self {
            self.authentication = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user.
        ///
        /// </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user.
        ///
        /// </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`User`](crate::model::User)
        pub fn build(self) -> crate::model::User {
            crate::model::User {
                name: self.name,
                status: self.status,
                access_string: self.access_string,
                acl_names: self.acl_names,
                minimum_engine_version: self.minimum_engine_version,
                authentication: self.authentication,
                arn: self.arn,
            }
        }
    }
}
impl User {
    /// Creates a new builder-style object to manufacture [`User`](crate::model::User)
    pub fn builder() -> crate::model::user::Builder {
        crate::model::user::Builder::default()
    }
}

/// <p>Denotes the user's authentication properties, such as whether it requires a password to authenticate. Used in output responses.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Authentication {
    /// <p>Indicates whether the user requires a password to authenticate.</p>
    pub r#type: std::option::Option<crate::model::AuthenticationType>,
    /// <p>The number of passwords belonging to the user. The maximum is two.</p>
    pub password_count: std::option::Option<i32>,
}
impl Authentication {
    /// <p>Indicates whether the user requires a password to authenticate.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::AuthenticationType> {
        self.r#type.as_ref()
    }
    /// <p>The number of passwords belonging to the user. The maximum is two.</p>
    pub fn password_count(&self) -> std::option::Option<i32> {
        self.password_count
    }
}
impl std::fmt::Debug for Authentication {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Authentication");
        formatter.field("r#type", &self.r#type);
        formatter.field("password_count", &self.password_count);
        formatter.finish()
    }
}
/// See [`Authentication`](crate::model::Authentication)
pub mod authentication {
    /// A builder for [`Authentication`](crate::model::Authentication)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::AuthenticationType>,
        pub(crate) password_count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Indicates whether the user requires a password to authenticate.</p>
        pub fn r#type(mut self, input: crate::model::AuthenticationType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>Indicates whether the user requires a password to authenticate.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::AuthenticationType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The number of passwords belonging to the user. The maximum is two.</p>
        pub fn password_count(mut self, input: i32) -> Self {
            self.password_count = Some(input);
            self
        }
        /// <p>The number of passwords belonging to the user. The maximum is two.</p>
        pub fn set_password_count(mut self, input: std::option::Option<i32>) -> Self {
            self.password_count = input;
            self
        }
        /// Consumes the builder and constructs a [`Authentication`](crate::model::Authentication)
        pub fn build(self) -> crate::model::Authentication {
            crate::model::Authentication {
                r#type: self.r#type,
                password_count: self.password_count,
            }
        }
    }
}
impl Authentication {
    /// Creates a new builder-style object to manufacture [`Authentication`](crate::model::Authentication)
    pub fn builder() -> crate::model::authentication::Builder {
        crate::model::authentication::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AuthenticationType {
    #[allow(missing_docs)] // documentation missing in model
    NoPassword,
    #[allow(missing_docs)] // documentation missing in model
    Password,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AuthenticationType {
    fn from(s: &str) -> Self {
        match s {
            "no-password" => AuthenticationType::NoPassword,
            "password" => AuthenticationType::Password,
            other => AuthenticationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AuthenticationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AuthenticationType::from(s))
    }
}
impl AuthenticationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AuthenticationType::NoPassword => "no-password",
            AuthenticationType::Password => "password",
            AuthenticationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["no-password", "password"]
    }
}
impl AsRef<str> for AuthenticationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Denotes the user's authentication properties, such as whether it requires a password to authenticate. Used in output responses.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AuthenticationMode {
    /// <p>Indicates whether the user requires a password to authenticate. All newly-created users require a password.</p>
    pub r#type: std::option::Option<crate::model::InputAuthenticationType>,
    /// <p>The password(s) used for authentication</p>
    pub passwords: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl AuthenticationMode {
    /// <p>Indicates whether the user requires a password to authenticate. All newly-created users require a password.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::InputAuthenticationType> {
        self.r#type.as_ref()
    }
    /// <p>The password(s) used for authentication</p>
    pub fn passwords(&self) -> std::option::Option<&[std::string::String]> {
        self.passwords.as_deref()
    }
}
impl std::fmt::Debug for AuthenticationMode {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AuthenticationMode");
        formatter.field("r#type", &self.r#type);
        formatter.field("passwords", &self.passwords);
        formatter.finish()
    }
}
/// See [`AuthenticationMode`](crate::model::AuthenticationMode)
pub mod authentication_mode {
    /// A builder for [`AuthenticationMode`](crate::model::AuthenticationMode)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::InputAuthenticationType>,
        pub(crate) passwords: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>Indicates whether the user requires a password to authenticate. All newly-created users require a password.</p>
        pub fn r#type(mut self, input: crate::model::InputAuthenticationType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>Indicates whether the user requires a password to authenticate. All newly-created users require a password.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::InputAuthenticationType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// Appends an item to `passwords`.
        ///
        /// To override the contents of this collection use [`set_passwords`](Self::set_passwords).
        ///
        /// <p>The password(s) used for authentication</p>
        pub fn passwords(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.passwords.unwrap_or_default();
            v.push(input.into());
            self.passwords = Some(v);
            self
        }
        /// <p>The password(s) used for authentication</p>
        pub fn set_passwords(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.passwords = input;
            self
        }
        /// Consumes the builder and constructs a [`AuthenticationMode`](crate::model::AuthenticationMode)
        pub fn build(self) -> crate::model::AuthenticationMode {
            crate::model::AuthenticationMode {
                r#type: self.r#type,
                passwords: self.passwords,
            }
        }
    }
}
impl AuthenticationMode {
    /// Creates a new builder-style object to manufacture [`AuthenticationMode`](crate::model::AuthenticationMode)
    pub fn builder() -> crate::model::authentication_mode::Builder {
        crate::model::authentication_mode::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InputAuthenticationType {
    #[allow(missing_docs)] // documentation missing in model
    Password,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InputAuthenticationType {
    fn from(s: &str) -> Self {
        match s {
            "password" => InputAuthenticationType::Password,
            other => InputAuthenticationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InputAuthenticationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InputAuthenticationType::from(s))
    }
}
impl InputAuthenticationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InputAuthenticationType::Password => "password",
            InputAuthenticationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["password"]
    }
}
impl AsRef<str> for InputAuthenticationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents the output of one of the following operations:</p>
/// <ul>
/// <li>
/// <p>CreateSubnetGroup</p>
/// </li>
/// <li>
/// <p>UpdateSubnetGroup</p>
/// </li>
/// </ul>  
/// <p>A subnet group is a collection of subnets (typically private) that you can designate for your clusters running in an Amazon Virtual Private Cloud (VPC) environment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SubnetGroup {
    /// <p>The name of the subnet group</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A description of the subnet group</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The Amazon Virtual Private Cloud identifier (VPC ID) of the subnet group.</p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>A list of subnets associated with the subnet group.</p>
    pub subnets: std::option::Option<std::vec::Vec<crate::model::Subnet>>,
    /// <p>The ARN (Amazon Resource Name) of the subnet group.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl SubnetGroup {
    /// <p>The name of the subnet group</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A description of the subnet group</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The Amazon Virtual Private Cloud identifier (VPC ID) of the subnet group.</p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
    /// <p>A list of subnets associated with the subnet group.</p>
    pub fn subnets(&self) -> std::option::Option<&[crate::model::Subnet]> {
        self.subnets.as_deref()
    }
    /// <p>The ARN (Amazon Resource Name) of the subnet group.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for SubnetGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SubnetGroup");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("subnets", &self.subnets);
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`SubnetGroup`](crate::model::SubnetGroup)
pub mod subnet_group {
    /// A builder for [`SubnetGroup`](crate::model::SubnetGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) subnets: std::option::Option<std::vec::Vec<crate::model::Subnet>>,
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the subnet group</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the subnet group</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A description of the subnet group</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the subnet group</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The Amazon Virtual Private Cloud identifier (VPC ID) of the subnet group.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The Amazon Virtual Private Cloud identifier (VPC ID) of the subnet group.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// Appends an item to `subnets`.
        ///
        /// To override the contents of this collection use [`set_subnets`](Self::set_subnets).
        ///
        /// <p>A list of subnets associated with the subnet group.</p>
        pub fn subnets(mut self, input: impl Into<crate::model::Subnet>) -> Self {
            let mut v = self.subnets.unwrap_or_default();
            v.push(input.into());
            self.subnets = Some(v);
            self
        }
        /// <p>A list of subnets associated with the subnet group.</p>
        pub fn set_subnets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Subnet>>,
        ) -> Self {
            self.subnets = input;
            self
        }
        /// <p>The ARN (Amazon Resource Name) of the subnet group.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN (Amazon Resource Name) of the subnet group.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`SubnetGroup`](crate::model::SubnetGroup)
        pub fn build(self) -> crate::model::SubnetGroup {
            crate::model::SubnetGroup {
                name: self.name,
                description: self.description,
                vpc_id: self.vpc_id,
                subnets: self.subnets,
                arn: self.arn,
            }
        }
    }
}
impl SubnetGroup {
    /// Creates a new builder-style object to manufacture [`SubnetGroup`](crate::model::SubnetGroup)
    pub fn builder() -> crate::model::subnet_group::Builder {
        crate::model::subnet_group::Builder::default()
    }
}

/// <p>Represents the subnet associated with a cluster. This parameter refers to subnets defined in Amazon Virtual Private Cloud (Amazon VPC) and used with MemoryDB.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Subnet {
    /// <p>The unique identifier for the subnet.</p>
    pub identifier: std::option::Option<std::string::String>,
    /// <p>The Availability Zone where the subnet resides</p>
    pub availability_zone: std::option::Option<crate::model::AvailabilityZone>,
}
impl Subnet {
    /// <p>The unique identifier for the subnet.</p>
    pub fn identifier(&self) -> std::option::Option<&str> {
        self.identifier.as_deref()
    }
    /// <p>The Availability Zone where the subnet resides</p>
    pub fn availability_zone(&self) -> std::option::Option<&crate::model::AvailabilityZone> {
        self.availability_zone.as_ref()
    }
}
impl std::fmt::Debug for Subnet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Subnet");
        formatter.field("identifier", &self.identifier);
        formatter.field("availability_zone", &self.availability_zone);
        formatter.finish()
    }
}
/// See [`Subnet`](crate::model::Subnet)
pub mod subnet {
    /// A builder for [`Subnet`](crate::model::Subnet)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identifier: std::option::Option<std::string::String>,
        pub(crate) availability_zone: std::option::Option<crate::model::AvailabilityZone>,
    }
    impl Builder {
        /// <p>The unique identifier for the subnet.</p>
        pub fn identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.identifier = Some(input.into());
            self
        }
        /// <p>The unique identifier for the subnet.</p>
        pub fn set_identifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identifier = input;
            self
        }
        /// <p>The Availability Zone where the subnet resides</p>
        pub fn availability_zone(mut self, input: crate::model::AvailabilityZone) -> Self {
            self.availability_zone = Some(input);
            self
        }
        /// <p>The Availability Zone where the subnet resides</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<crate::model::AvailabilityZone>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// Consumes the builder and constructs a [`Subnet`](crate::model::Subnet)
        pub fn build(self) -> crate::model::Subnet {
            crate::model::Subnet {
                identifier: self.identifier,
                availability_zone: self.availability_zone,
            }
        }
    }
}
impl Subnet {
    /// Creates a new builder-style object to manufacture [`Subnet`](crate::model::Subnet)
    pub fn builder() -> crate::model::subnet::Builder {
        crate::model::subnet::Builder::default()
    }
}

/// <p>Indicates if the cluster has a Multi-AZ configuration (multiaz) or not (singleaz).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AvailabilityZone {
    /// <p>The name of the Availability Zone.</p>
    pub name: std::option::Option<std::string::String>,
}
impl AvailabilityZone {
    /// <p>The name of the Availability Zone.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for AvailabilityZone {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AvailabilityZone");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`AvailabilityZone`](crate::model::AvailabilityZone)
pub mod availability_zone {
    /// A builder for [`AvailabilityZone`](crate::model::AvailabilityZone)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Availability Zone.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the Availability Zone.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`AvailabilityZone`](crate::model::AvailabilityZone)
        pub fn build(self) -> crate::model::AvailabilityZone {
            crate::model::AvailabilityZone { name: self.name }
        }
    }
}
impl AvailabilityZone {
    /// Creates a new builder-style object to manufacture [`AvailabilityZone`](crate::model::AvailabilityZone)
    pub fn builder() -> crate::model::availability_zone::Builder {
        crate::model::availability_zone::Builder::default()
    }
}

/// <p>Represents the output of a CreateParameterGroup operation. A parameter group represents a combination of specific values for the parameters that are passed to the engine software during startup.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ParameterGroup {
    /// <p>The name of the parameter group</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The name of the parameter group family that this  parameter group is compatible with.</p>
    pub family: std::option::Option<std::string::String>,
    /// <p>A description of the parameter group</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the parameter group</p>
    pub arn: std::option::Option<std::string::String>,
}
impl ParameterGroup {
    /// <p>The name of the parameter group</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The name of the parameter group family that this  parameter group is compatible with.</p>
    pub fn family(&self) -> std::option::Option<&str> {
        self.family.as_deref()
    }
    /// <p>A description of the parameter group</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the parameter group</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for ParameterGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ParameterGroup");
        formatter.field("name", &self.name);
        formatter.field("family", &self.family);
        formatter.field("description", &self.description);
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`ParameterGroup`](crate::model::ParameterGroup)
pub mod parameter_group {
    /// A builder for [`ParameterGroup`](crate::model::ParameterGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) family: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the parameter group</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the parameter group</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The name of the parameter group family that this  parameter group is compatible with.</p>
        pub fn family(mut self, input: impl Into<std::string::String>) -> Self {
            self.family = Some(input.into());
            self
        }
        /// <p>The name of the parameter group family that this  parameter group is compatible with.</p>
        pub fn set_family(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.family = input;
            self
        }
        /// <p>A description of the parameter group</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the parameter group</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the parameter group</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the parameter group</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ParameterGroup`](crate::model::ParameterGroup)
        pub fn build(self) -> crate::model::ParameterGroup {
            crate::model::ParameterGroup {
                name: self.name,
                family: self.family,
                description: self.description,
                arn: self.arn,
            }
        }
    }
}
impl ParameterGroup {
    /// Creates a new builder-style object to manufacture [`ParameterGroup`](crate::model::ParameterGroup)
    pub fn builder() -> crate::model::parameter_group::Builder {
        crate::model::parameter_group::Builder::default()
    }
}

/// <p>Describes a name-value pair that is used to update the value of a parameter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ParameterNameValue {
    /// <p>The name of the parameter</p>
    pub parameter_name: std::option::Option<std::string::String>,
    /// <p>The value of the parameter</p>
    pub parameter_value: std::option::Option<std::string::String>,
}
impl ParameterNameValue {
    /// <p>The name of the parameter</p>
    pub fn parameter_name(&self) -> std::option::Option<&str> {
        self.parameter_name.as_deref()
    }
    /// <p>The value of the parameter</p>
    pub fn parameter_value(&self) -> std::option::Option<&str> {
        self.parameter_value.as_deref()
    }
}
impl std::fmt::Debug for ParameterNameValue {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ParameterNameValue");
        formatter.field("parameter_name", &self.parameter_name);
        formatter.field("parameter_value", &self.parameter_value);
        formatter.finish()
    }
}
/// See [`ParameterNameValue`](crate::model::ParameterNameValue)
pub mod parameter_name_value {
    /// A builder for [`ParameterNameValue`](crate::model::ParameterNameValue)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parameter_name: std::option::Option<std::string::String>,
        pub(crate) parameter_value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the parameter</p>
        pub fn parameter_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_name = Some(input.into());
            self
        }
        /// <p>The name of the parameter</p>
        pub fn set_parameter_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_name = input;
            self
        }
        /// <p>The value of the parameter</p>
        pub fn parameter_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_value = Some(input.into());
            self
        }
        /// <p>The value of the parameter</p>
        pub fn set_parameter_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_value = input;
            self
        }
        /// Consumes the builder and constructs a [`ParameterNameValue`](crate::model::ParameterNameValue)
        pub fn build(self) -> crate::model::ParameterNameValue {
            crate::model::ParameterNameValue {
                parameter_name: self.parameter_name,
                parameter_value: self.parameter_value,
            }
        }
    }
}
impl ParameterNameValue {
    /// Creates a new builder-style object to manufacture [`ParameterNameValue`](crate::model::ParameterNameValue)
    pub fn builder() -> crate::model::parameter_name_value::Builder {
        crate::model::parameter_name_value::Builder::default()
    }
}

/// <p>Contains all of the attributes of a specific cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Cluster {
    /// <p>The user-supplied name of the cluster. This identifier is a unique key that identifies a cluster.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A description of the cluster</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The status of the cluster. For example, Available, Updating, Creating.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>A group of settings that are currently being applied.</p>
    pub pending_updates: std::option::Option<crate::model::ClusterPendingUpdates>,
    /// <p>The number of shards in the cluster</p>
    pub number_of_shards: std::option::Option<i32>,
    /// <p>A list of shards that are members of the cluster.</p>
    pub shards: std::option::Option<std::vec::Vec<crate::model::Shard>>,
    /// <p>Indicates if the cluster has a Multi-AZ configuration (multiaz) or not (singleaz).</p>
    pub availability_mode: std::option::Option<crate::model::AzStatus>,
    /// <p>The cluster's configuration endpoint</p>
    pub cluster_endpoint: std::option::Option<crate::model::Endpoint>,
    /// <p>The cluster's node type</p>
    pub node_type: std::option::Option<std::string::String>,
    /// <p>The Redis engine version used by the cluster</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>The Redis engine patch version used by the cluster</p>
    pub engine_patch_version: std::option::Option<std::string::String>,
    /// <p>The name of the parameter group used by the cluster</p>
    pub parameter_group_name: std::option::Option<std::string::String>,
    /// <p>The status of the parameter group used by the cluster, for example 'active' or 'applying'.</p>
    pub parameter_group_status: std::option::Option<std::string::String>,
    /// <p>A list of security groups used by the cluster</p>
    pub security_groups: std::option::Option<std::vec::Vec<crate::model::SecurityGroupMembership>>,
    /// <p>The name of the subnet group used by the cluster</p>
    pub subnet_group_name: std::option::Option<std::string::String>,
    /// <p>A flag to indicate if In-transit encryption is enabled</p>
    pub tls_enabled: std::option::Option<bool>,
    /// <p>The ID of the KMS key used to encrypt the cluster</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the cluster.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the SNS notification topic</p>
    pub sns_topic_arn: std::option::Option<std::string::String>,
    /// <p>The SNS topic must be in Active status to receive notifications</p>
    pub sns_topic_status: std::option::Option<std::string::String>,
    /// <p>The number of days for which MemoryDB retains automatic snapshots before deleting them. For example, if you set SnapshotRetentionLimit to 5, a snapshot that was taken today is retained for 5 days before being deleted.</p>
    pub snapshot_retention_limit: std::option::Option<i32>,
    /// <p>Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period. </p>
    pub maintenance_window: std::option::Option<std::string::String>,
    /// <p>The daily time range (in UTC) during which MemoryDB begins taking a daily snapshot of your shard.
    ///
    /// Example: 05:00-09:00
    ///
    /// If you do not specify this parameter, MemoryDB automatically chooses an appropriate time range.</p>
    pub snapshot_window: std::option::Option<std::string::String>,
    /// <p>The name of the Access Control List associated with this cluster.</p>
    pub acl_name: std::option::Option<std::string::String>,
    /// <p>When set to true, the cluster will automatically receive minor engine version upgrades after launch.</p>
    pub auto_minor_version_upgrade: std::option::Option<bool>,
}
impl Cluster {
    /// <p>The user-supplied name of the cluster. This identifier is a unique key that identifies a cluster.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A description of the cluster</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The status of the cluster. For example, Available, Updating, Creating.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>A group of settings that are currently being applied.</p>
    pub fn pending_updates(&self) -> std::option::Option<&crate::model::ClusterPendingUpdates> {
        self.pending_updates.as_ref()
    }
    /// <p>The number of shards in the cluster</p>
    pub fn number_of_shards(&self) -> std::option::Option<i32> {
        self.number_of_shards
    }
    /// <p>A list of shards that are members of the cluster.</p>
    pub fn shards(&self) -> std::option::Option<&[crate::model::Shard]> {
        self.shards.as_deref()
    }
    /// <p>Indicates if the cluster has a Multi-AZ configuration (multiaz) or not (singleaz).</p>
    pub fn availability_mode(&self) -> std::option::Option<&crate::model::AzStatus> {
        self.availability_mode.as_ref()
    }
    /// <p>The cluster's configuration endpoint</p>
    pub fn cluster_endpoint(&self) -> std::option::Option<&crate::model::Endpoint> {
        self.cluster_endpoint.as_ref()
    }
    /// <p>The cluster's node type</p>
    pub fn node_type(&self) -> std::option::Option<&str> {
        self.node_type.as_deref()
    }
    /// <p>The Redis engine version used by the cluster</p>
    pub fn engine_version(&self) -> std::option::Option<&str> {
        self.engine_version.as_deref()
    }
    /// <p>The Redis engine patch version used by the cluster</p>
    pub fn engine_patch_version(&self) -> std::option::Option<&str> {
        self.engine_patch_version.as_deref()
    }
    /// <p>The name of the parameter group used by the cluster</p>
    pub fn parameter_group_name(&self) -> std::option::Option<&str> {
        self.parameter_group_name.as_deref()
    }
    /// <p>The status of the parameter group used by the cluster, for example 'active' or 'applying'.</p>
    pub fn parameter_group_status(&self) -> std::option::Option<&str> {
        self.parameter_group_status.as_deref()
    }
    /// <p>A list of security groups used by the cluster</p>
    pub fn security_groups(&self) -> std::option::Option<&[crate::model::SecurityGroupMembership]> {
        self.security_groups.as_deref()
    }
    /// <p>The name of the subnet group used by the cluster</p>
    pub fn subnet_group_name(&self) -> std::option::Option<&str> {
        self.subnet_group_name.as_deref()
    }
    /// <p>A flag to indicate if In-transit encryption is enabled</p>
    pub fn tls_enabled(&self) -> std::option::Option<bool> {
        self.tls_enabled
    }
    /// <p>The ID of the KMS key used to encrypt the cluster</p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the cluster.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the SNS notification topic</p>
    pub fn sns_topic_arn(&self) -> std::option::Option<&str> {
        self.sns_topic_arn.as_deref()
    }
    /// <p>The SNS topic must be in Active status to receive notifications</p>
    pub fn sns_topic_status(&self) -> std::option::Option<&str> {
        self.sns_topic_status.as_deref()
    }
    /// <p>The number of days for which MemoryDB retains automatic snapshots before deleting them. For example, if you set SnapshotRetentionLimit to 5, a snapshot that was taken today is retained for 5 days before being deleted.</p>
    pub fn snapshot_retention_limit(&self) -> std::option::Option<i32> {
        self.snapshot_retention_limit
    }
    /// <p>Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period. </p>
    pub fn maintenance_window(&self) -> std::option::Option<&str> {
        self.maintenance_window.as_deref()
    }
    /// <p>The daily time range (in UTC) during which MemoryDB begins taking a daily snapshot of your shard.
    ///
    /// Example: 05:00-09:00
    ///
    /// If you do not specify this parameter, MemoryDB automatically chooses an appropriate time range.</p>
    pub fn snapshot_window(&self) -> std::option::Option<&str> {
        self.snapshot_window.as_deref()
    }
    /// <p>The name of the Access Control List associated with this cluster.</p>
    pub fn acl_name(&self) -> std::option::Option<&str> {
        self.acl_name.as_deref()
    }
    /// <p>When set to true, the cluster will automatically receive minor engine version upgrades after launch.</p>
    pub fn auto_minor_version_upgrade(&self) -> std::option::Option<bool> {
        self.auto_minor_version_upgrade
    }
}
impl std::fmt::Debug for Cluster {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Cluster");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("status", &self.status);
        formatter.field("pending_updates", &self.pending_updates);
        formatter.field("number_of_shards", &self.number_of_shards);
        formatter.field("shards", &self.shards);
        formatter.field("availability_mode", &self.availability_mode);
        formatter.field("cluster_endpoint", &self.cluster_endpoint);
        formatter.field("node_type", &self.node_type);
        formatter.field("engine_version", &self.engine_version);
        formatter.field("engine_patch_version", &self.engine_patch_version);
        formatter.field("parameter_group_name", &self.parameter_group_name);
        formatter.field("parameter_group_status", &self.parameter_group_status);
        formatter.field("security_groups", &self.security_groups);
        formatter.field("subnet_group_name", &self.subnet_group_name);
        formatter.field("tls_enabled", &self.tls_enabled);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("arn", &self.arn);
        formatter.field("sns_topic_arn", &self.sns_topic_arn);
        formatter.field("sns_topic_status", &self.sns_topic_status);
        formatter.field("snapshot_retention_limit", &self.snapshot_retention_limit);
        formatter.field("maintenance_window", &self.maintenance_window);
        formatter.field("snapshot_window", &self.snapshot_window);
        formatter.field("acl_name", &self.acl_name);
        formatter.field(
            "auto_minor_version_upgrade",
            &self.auto_minor_version_upgrade,
        );
        formatter.finish()
    }
}
/// See [`Cluster`](crate::model::Cluster)
pub mod cluster {
    /// A builder for [`Cluster`](crate::model::Cluster)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) pending_updates: std::option::Option<crate::model::ClusterPendingUpdates>,
        pub(crate) number_of_shards: std::option::Option<i32>,
        pub(crate) shards: std::option::Option<std::vec::Vec<crate::model::Shard>>,
        pub(crate) availability_mode: std::option::Option<crate::model::AzStatus>,
        pub(crate) cluster_endpoint: std::option::Option<crate::model::Endpoint>,
        pub(crate) node_type: std::option::Option<std::string::String>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) engine_patch_version: std::option::Option<std::string::String>,
        pub(crate) parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) parameter_group_status: std::option::Option<std::string::String>,
        pub(crate) security_groups:
            std::option::Option<std::vec::Vec<crate::model::SecurityGroupMembership>>,
        pub(crate) subnet_group_name: std::option::Option<std::string::String>,
        pub(crate) tls_enabled: std::option::Option<bool>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) sns_topic_arn: std::option::Option<std::string::String>,
        pub(crate) sns_topic_status: std::option::Option<std::string::String>,
        pub(crate) snapshot_retention_limit: std::option::Option<i32>,
        pub(crate) maintenance_window: std::option::Option<std::string::String>,
        pub(crate) snapshot_window: std::option::Option<std::string::String>,
        pub(crate) acl_name: std::option::Option<std::string::String>,
        pub(crate) auto_minor_version_upgrade: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The user-supplied name of the cluster. This identifier is a unique key that identifies a cluster.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The user-supplied name of the cluster. This identifier is a unique key that identifies a cluster.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A description of the cluster</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the cluster</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The status of the cluster. For example, Available, Updating, Creating.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the cluster. For example, Available, Updating, Creating.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>A group of settings that are currently being applied.</p>
        pub fn pending_updates(mut self, input: crate::model::ClusterPendingUpdates) -> Self {
            self.pending_updates = Some(input);
            self
        }
        /// <p>A group of settings that are currently being applied.</p>
        pub fn set_pending_updates(
            mut self,
            input: std::option::Option<crate::model::ClusterPendingUpdates>,
        ) -> Self {
            self.pending_updates = input;
            self
        }
        /// <p>The number of shards in the cluster</p>
        pub fn number_of_shards(mut self, input: i32) -> Self {
            self.number_of_shards = Some(input);
            self
        }
        /// <p>The number of shards in the cluster</p>
        pub fn set_number_of_shards(mut self, input: std::option::Option<i32>) -> Self {
            self.number_of_shards = input;
            self
        }
        /// Appends an item to `shards`.
        ///
        /// To override the contents of this collection use [`set_shards`](Self::set_shards).
        ///
        /// <p>A list of shards that are members of the cluster.</p>
        pub fn shards(mut self, input: impl Into<crate::model::Shard>) -> Self {
            let mut v = self.shards.unwrap_or_default();
            v.push(input.into());
            self.shards = Some(v);
            self
        }
        /// <p>A list of shards that are members of the cluster.</p>
        pub fn set_shards(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Shard>>,
        ) -> Self {
            self.shards = input;
            self
        }
        /// <p>Indicates if the cluster has a Multi-AZ configuration (multiaz) or not (singleaz).</p>
        pub fn availability_mode(mut self, input: crate::model::AzStatus) -> Self {
            self.availability_mode = Some(input);
            self
        }
        /// <p>Indicates if the cluster has a Multi-AZ configuration (multiaz) or not (singleaz).</p>
        pub fn set_availability_mode(
            mut self,
            input: std::option::Option<crate::model::AzStatus>,
        ) -> Self {
            self.availability_mode = input;
            self
        }
        /// <p>The cluster's configuration endpoint</p>
        pub fn cluster_endpoint(mut self, input: crate::model::Endpoint) -> Self {
            self.cluster_endpoint = Some(input);
            self
        }
        /// <p>The cluster's configuration endpoint</p>
        pub fn set_cluster_endpoint(
            mut self,
            input: std::option::Option<crate::model::Endpoint>,
        ) -> Self {
            self.cluster_endpoint = input;
            self
        }
        /// <p>The cluster's node type</p>
        pub fn node_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.node_type = Some(input.into());
            self
        }
        /// <p>The cluster's node type</p>
        pub fn set_node_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.node_type = input;
            self
        }
        /// <p>The Redis engine version used by the cluster</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The Redis engine version used by the cluster</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>The Redis engine patch version used by the cluster</p>
        pub fn engine_patch_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_patch_version = Some(input.into());
            self
        }
        /// <p>The Redis engine patch version used by the cluster</p>
        pub fn set_engine_patch_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_patch_version = input;
            self
        }
        /// <p>The name of the parameter group used by the cluster</p>
        pub fn parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the parameter group used by the cluster</p>
        pub fn set_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_group_name = input;
            self
        }
        /// <p>The status of the parameter group used by the cluster, for example 'active' or 'applying'.</p>
        pub fn parameter_group_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_group_status = Some(input.into());
            self
        }
        /// <p>The status of the parameter group used by the cluster, for example 'active' or 'applying'.</p>
        pub fn set_parameter_group_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_group_status = input;
            self
        }
        /// Appends an item to `security_groups`.
        ///
        /// To override the contents of this collection use [`set_security_groups`](Self::set_security_groups).
        ///
        /// <p>A list of security groups used by the cluster</p>
        pub fn security_groups(
            mut self,
            input: impl Into<crate::model::SecurityGroupMembership>,
        ) -> Self {
            let mut v = self.security_groups.unwrap_or_default();
            v.push(input.into());
            self.security_groups = Some(v);
            self
        }
        /// <p>A list of security groups used by the cluster</p>
        pub fn set_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SecurityGroupMembership>>,
        ) -> Self {
            self.security_groups = input;
            self
        }
        /// <p>The name of the subnet group used by the cluster</p>
        pub fn subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_group_name = Some(input.into());
            self
        }
        /// <p>The name of the subnet group used by the cluster</p>
        pub fn set_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subnet_group_name = input;
            self
        }
        /// <p>A flag to indicate if In-transit encryption is enabled</p>
        pub fn tls_enabled(mut self, input: bool) -> Self {
            self.tls_enabled = Some(input);
            self
        }
        /// <p>A flag to indicate if In-transit encryption is enabled</p>
        pub fn set_tls_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.tls_enabled = input;
            self
        }
        /// <p>The ID of the KMS key used to encrypt the cluster</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The ID of the KMS key used to encrypt the cluster</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the cluster.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the cluster.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the SNS notification topic</p>
        pub fn sns_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.sns_topic_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the SNS notification topic</p>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sns_topic_arn = input;
            self
        }
        /// <p>The SNS topic must be in Active status to receive notifications</p>
        pub fn sns_topic_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.sns_topic_status = Some(input.into());
            self
        }
        /// <p>The SNS topic must be in Active status to receive notifications</p>
        pub fn set_sns_topic_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sns_topic_status = input;
            self
        }
        /// <p>The number of days for which MemoryDB retains automatic snapshots before deleting them. For example, if you set SnapshotRetentionLimit to 5, a snapshot that was taken today is retained for 5 days before being deleted.</p>
        pub fn snapshot_retention_limit(mut self, input: i32) -> Self {
            self.snapshot_retention_limit = Some(input);
            self
        }
        /// <p>The number of days for which MemoryDB retains automatic snapshots before deleting them. For example, if you set SnapshotRetentionLimit to 5, a snapshot that was taken today is retained for 5 days before being deleted.</p>
        pub fn set_snapshot_retention_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.snapshot_retention_limit = input;
            self
        }
        /// <p>Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period. </p>
        pub fn maintenance_window(mut self, input: impl Into<std::string::String>) -> Self {
            self.maintenance_window = Some(input.into());
            self
        }
        /// <p>Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period. </p>
        pub fn set_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.maintenance_window = input;
            self
        }
        /// <p>The daily time range (in UTC) during which MemoryDB begins taking a daily snapshot of your shard.
        ///
        /// Example: 05:00-09:00
        ///
        /// If you do not specify this parameter, MemoryDB automatically chooses an appropriate time range.</p>
        pub fn snapshot_window(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_window = Some(input.into());
            self
        }
        /// <p>The daily time range (in UTC) during which MemoryDB begins taking a daily snapshot of your shard.
        ///
        /// Example: 05:00-09:00
        ///
        /// If you do not specify this parameter, MemoryDB automatically chooses an appropriate time range.</p>
        pub fn set_snapshot_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshot_window = input;
            self
        }
        /// <p>The name of the Access Control List associated with this cluster.</p>
        pub fn acl_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.acl_name = Some(input.into());
            self
        }
        /// <p>The name of the Access Control List associated with this cluster.</p>
        pub fn set_acl_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.acl_name = input;
            self
        }
        /// <p>When set to true, the cluster will automatically receive minor engine version upgrades after launch.</p>
        pub fn auto_minor_version_upgrade(mut self, input: bool) -> Self {
            self.auto_minor_version_upgrade = Some(input);
            self
        }
        /// <p>When set to true, the cluster will automatically receive minor engine version upgrades after launch.</p>
        pub fn set_auto_minor_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_minor_version_upgrade = input;
            self
        }
        /// Consumes the builder and constructs a [`Cluster`](crate::model::Cluster)
        pub fn build(self) -> crate::model::Cluster {
            crate::model::Cluster {
                name: self.name,
                description: self.description,
                status: self.status,
                pending_updates: self.pending_updates,
                number_of_shards: self.number_of_shards,
                shards: self.shards,
                availability_mode: self.availability_mode,
                cluster_endpoint: self.cluster_endpoint,
                node_type: self.node_type,
                engine_version: self.engine_version,
                engine_patch_version: self.engine_patch_version,
                parameter_group_name: self.parameter_group_name,
                parameter_group_status: self.parameter_group_status,
                security_groups: self.security_groups,
                subnet_group_name: self.subnet_group_name,
                tls_enabled: self.tls_enabled,
                kms_key_id: self.kms_key_id,
                arn: self.arn,
                sns_topic_arn: self.sns_topic_arn,
                sns_topic_status: self.sns_topic_status,
                snapshot_retention_limit: self.snapshot_retention_limit,
                maintenance_window: self.maintenance_window,
                snapshot_window: self.snapshot_window,
                acl_name: self.acl_name,
                auto_minor_version_upgrade: self.auto_minor_version_upgrade,
            }
        }
    }
}
impl Cluster {
    /// Creates a new builder-style object to manufacture [`Cluster`](crate::model::Cluster)
    pub fn builder() -> crate::model::cluster::Builder {
        crate::model::cluster::Builder::default()
    }
}

/// <p>Represents a single security group and its status.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SecurityGroupMembership {
    /// <p>The identifier of the security group.</p>
    pub security_group_id: std::option::Option<std::string::String>,
    /// <p>The status of the security group membership. The status changes whenever a security group is modified, or when the security groups assigned to a cluster are modified.</p>
    pub status: std::option::Option<std::string::String>,
}
impl SecurityGroupMembership {
    /// <p>The identifier of the security group.</p>
    pub fn security_group_id(&self) -> std::option::Option<&str> {
        self.security_group_id.as_deref()
    }
    /// <p>The status of the security group membership. The status changes whenever a security group is modified, or when the security groups assigned to a cluster are modified.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
}
impl std::fmt::Debug for SecurityGroupMembership {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SecurityGroupMembership");
        formatter.field("security_group_id", &self.security_group_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`SecurityGroupMembership`](crate::model::SecurityGroupMembership)
pub mod security_group_membership {
    /// A builder for [`SecurityGroupMembership`](crate::model::SecurityGroupMembership)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) security_group_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the security group.</p>
        pub fn security_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.security_group_id = Some(input.into());
            self
        }
        /// <p>The identifier of the security group.</p>
        pub fn set_security_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.security_group_id = input;
            self
        }
        /// <p>The status of the security group membership. The status changes whenever a security group is modified, or when the security groups assigned to a cluster are modified.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the security group membership. The status changes whenever a security group is modified, or when the security groups assigned to a cluster are modified.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`SecurityGroupMembership`](crate::model::SecurityGroupMembership)
        pub fn build(self) -> crate::model::SecurityGroupMembership {
            crate::model::SecurityGroupMembership {
                security_group_id: self.security_group_id,
                status: self.status,
            }
        }
    }
}
impl SecurityGroupMembership {
    /// Creates a new builder-style object to manufacture [`SecurityGroupMembership`](crate::model::SecurityGroupMembership)
    pub fn builder() -> crate::model::security_group_membership::Builder {
        crate::model::security_group_membership::Builder::default()
    }
}

/// <p>Represents the information required for client programs to connect to the cluster and its nodes.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Endpoint {
    /// <p>The DNS hostname of the node.</p>
    pub address: std::option::Option<std::string::String>,
    /// <p>The port number that the engine is listening on.</p>
    pub port: i32,
}
impl Endpoint {
    /// <p>The DNS hostname of the node.</p>
    pub fn address(&self) -> std::option::Option<&str> {
        self.address.as_deref()
    }
    /// <p>The port number that the engine is listening on.</p>
    pub fn port(&self) -> i32 {
        self.port
    }
}
impl std::fmt::Debug for Endpoint {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Endpoint");
        formatter.field("address", &self.address);
        formatter.field("port", &self.port);
        formatter.finish()
    }
}
/// See [`Endpoint`](crate::model::Endpoint)
pub mod endpoint {
    /// A builder for [`Endpoint`](crate::model::Endpoint)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) address: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The DNS hostname of the node.</p>
        pub fn address(mut self, input: impl Into<std::string::String>) -> Self {
            self.address = Some(input.into());
            self
        }
        /// <p>The DNS hostname of the node.</p>
        pub fn set_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.address = input;
            self
        }
        /// <p>The port number that the engine is listening on.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The port number that the engine is listening on.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// Consumes the builder and constructs a [`Endpoint`](crate::model::Endpoint)
        pub fn build(self) -> crate::model::Endpoint {
            crate::model::Endpoint {
                address: self.address,
                port: self.port.unwrap_or_default(),
            }
        }
    }
}
impl Endpoint {
    /// Creates a new builder-style object to manufacture [`Endpoint`](crate::model::Endpoint)
    pub fn builder() -> crate::model::endpoint::Builder {
        crate::model::endpoint::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AzStatus {
    #[allow(missing_docs)] // documentation missing in model
    MultiAz,
    #[allow(missing_docs)] // documentation missing in model
    SingleAz,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AzStatus {
    fn from(s: &str) -> Self {
        match s {
            "multiaz" => AzStatus::MultiAz,
            "singleaz" => AzStatus::SingleAz,
            other => AzStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AzStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AzStatus::from(s))
    }
}
impl AzStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AzStatus::MultiAz => "multiaz",
            AzStatus::SingleAz => "singleaz",
            AzStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["multiaz", "singleaz"]
    }
}
impl AsRef<str> for AzStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents a collection of nodes in a cluster. One node in the node group is the read/write primary node. All the other nodes are read-only Replica nodes.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Shard {
    /// <p>The name of the shard</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The current state of this replication group - creating, available, modifying, deleting.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The keyspace for this shard.</p>
    pub slots: std::option::Option<std::string::String>,
    /// <p>A list containing information about individual nodes within the shard</p>
    pub nodes: std::option::Option<std::vec::Vec<crate::model::Node>>,
    /// <p>The number of nodes in the shard</p>
    pub number_of_nodes: std::option::Option<i32>,
}
impl Shard {
    /// <p>The name of the shard</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The current state of this replication group - creating, available, modifying, deleting.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The keyspace for this shard.</p>
    pub fn slots(&self) -> std::option::Option<&str> {
        self.slots.as_deref()
    }
    /// <p>A list containing information about individual nodes within the shard</p>
    pub fn nodes(&self) -> std::option::Option<&[crate::model::Node]> {
        self.nodes.as_deref()
    }
    /// <p>The number of nodes in the shard</p>
    pub fn number_of_nodes(&self) -> std::option::Option<i32> {
        self.number_of_nodes
    }
}
impl std::fmt::Debug for Shard {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Shard");
        formatter.field("name", &self.name);
        formatter.field("status", &self.status);
        formatter.field("slots", &self.slots);
        formatter.field("nodes", &self.nodes);
        formatter.field("number_of_nodes", &self.number_of_nodes);
        formatter.finish()
    }
}
/// See [`Shard`](crate::model::Shard)
pub mod shard {
    /// A builder for [`Shard`](crate::model::Shard)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) slots: std::option::Option<std::string::String>,
        pub(crate) nodes: std::option::Option<std::vec::Vec<crate::model::Node>>,
        pub(crate) number_of_nodes: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the shard</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the shard</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The current state of this replication group - creating, available, modifying, deleting.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The current state of this replication group - creating, available, modifying, deleting.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The keyspace for this shard.</p>
        pub fn slots(mut self, input: impl Into<std::string::String>) -> Self {
            self.slots = Some(input.into());
            self
        }
        /// <p>The keyspace for this shard.</p>
        pub fn set_slots(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.slots = input;
            self
        }
        /// Appends an item to `nodes`.
        ///
        /// To override the contents of this collection use [`set_nodes`](Self::set_nodes).
        ///
        /// <p>A list containing information about individual nodes within the shard</p>
        pub fn nodes(mut self, input: impl Into<crate::model::Node>) -> Self {
            let mut v = self.nodes.unwrap_or_default();
            v.push(input.into());
            self.nodes = Some(v);
            self
        }
        /// <p>A list containing information about individual nodes within the shard</p>
        pub fn set_nodes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Node>>,
        ) -> Self {
            self.nodes = input;
            self
        }
        /// <p>The number of nodes in the shard</p>
        pub fn number_of_nodes(mut self, input: i32) -> Self {
            self.number_of_nodes = Some(input);
            self
        }
        /// <p>The number of nodes in the shard</p>
        pub fn set_number_of_nodes(mut self, input: std::option::Option<i32>) -> Self {
            self.number_of_nodes = input;
            self
        }
        /// Consumes the builder and constructs a [`Shard`](crate::model::Shard)
        pub fn build(self) -> crate::model::Shard {
            crate::model::Shard {
                name: self.name,
                status: self.status,
                slots: self.slots,
                nodes: self.nodes,
                number_of_nodes: self.number_of_nodes,
            }
        }
    }
}
impl Shard {
    /// Creates a new builder-style object to manufacture [`Shard`](crate::model::Shard)
    pub fn builder() -> crate::model::shard::Builder {
        crate::model::shard::Builder::default()
    }
}

/// <p>Represents an individual node within a cluster. Each node runs its own instance of the cluster's protocol-compliant caching software.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Node {
    /// <p>The  node identifier. A node name is a numeric identifier (0001, 0002, etc.). The combination of cluster name, shard name and node name uniquely identifies every node used in a customer's Amazon account.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The status of the service update on the node</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The Availability Zone in which the node resides</p>
    pub availability_zone: std::option::Option<std::string::String>,
    /// <p>The date and time when the node was created.</p>
    pub create_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The hostname for connecting to this node.</p>
    pub endpoint: std::option::Option<crate::model::Endpoint>,
}
impl Node {
    /// <p>The  node identifier. A node name is a numeric identifier (0001, 0002, etc.). The combination of cluster name, shard name and node name uniquely identifies every node used in a customer's Amazon account.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The status of the service update on the node</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The Availability Zone in which the node resides</p>
    pub fn availability_zone(&self) -> std::option::Option<&str> {
        self.availability_zone.as_deref()
    }
    /// <p>The date and time when the node was created.</p>
    pub fn create_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.create_time.as_ref()
    }
    /// <p>The hostname for connecting to this node.</p>
    pub fn endpoint(&self) -> std::option::Option<&crate::model::Endpoint> {
        self.endpoint.as_ref()
    }
}
impl std::fmt::Debug for Node {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Node");
        formatter.field("name", &self.name);
        formatter.field("status", &self.status);
        formatter.field("availability_zone", &self.availability_zone);
        formatter.field("create_time", &self.create_time);
        formatter.field("endpoint", &self.endpoint);
        formatter.finish()
    }
}
/// See [`Node`](crate::model::Node)
pub mod node {
    /// A builder for [`Node`](crate::model::Node)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) create_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) endpoint: std::option::Option<crate::model::Endpoint>,
    }
    impl Builder {
        /// <p>The  node identifier. A node name is a numeric identifier (0001, 0002, etc.). The combination of cluster name, shard name and node name uniquely identifies every node used in a customer's Amazon account.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The  node identifier. A node name is a numeric identifier (0001, 0002, etc.). The combination of cluster name, shard name and node name uniquely identifies every node used in a customer's Amazon account.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The status of the service update on the node</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the service update on the node</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The Availability Zone in which the node resides</p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// <p>The Availability Zone in which the node resides</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// <p>The date and time when the node was created.</p>
        pub fn create_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.create_time = Some(input);
            self
        }
        /// <p>The date and time when the node was created.</p>
        pub fn set_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.create_time = input;
            self
        }
        /// <p>The hostname for connecting to this node.</p>
        pub fn endpoint(mut self, input: crate::model::Endpoint) -> Self {
            self.endpoint = Some(input);
            self
        }
        /// <p>The hostname for connecting to this node.</p>
        pub fn set_endpoint(mut self, input: std::option::Option<crate::model::Endpoint>) -> Self {
            self.endpoint = input;
            self
        }
        /// Consumes the builder and constructs a [`Node`](crate::model::Node)
        pub fn build(self) -> crate::model::Node {
            crate::model::Node {
                name: self.name,
                status: self.status,
                availability_zone: self.availability_zone,
                create_time: self.create_time,
                endpoint: self.endpoint,
            }
        }
    }
}
impl Node {
    /// Creates a new builder-style object to manufacture [`Node`](crate::model::Node)
    pub fn builder() -> crate::model::node::Builder {
        crate::model::node::Builder::default()
    }
}

/// <p>A list of updates being applied to the cluster</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClusterPendingUpdates {
    /// <p>The status of an online resharding operation.</p>
    pub resharding: std::option::Option<crate::model::ReshardingStatus>,
    /// <p>A list of ACLs associated with the cluster that are being updated</p>
    pub ac_ls: std::option::Option<crate::model::AcLsUpdateStatus>,
    /// <p>A list of service updates being applied to the cluster</p>
    pub service_updates:
        std::option::Option<std::vec::Vec<crate::model::PendingModifiedServiceUpdate>>,
}
impl ClusterPendingUpdates {
    /// <p>The status of an online resharding operation.</p>
    pub fn resharding(&self) -> std::option::Option<&crate::model::ReshardingStatus> {
        self.resharding.as_ref()
    }
    /// <p>A list of ACLs associated with the cluster that are being updated</p>
    pub fn ac_ls(&self) -> std::option::Option<&crate::model::AcLsUpdateStatus> {
        self.ac_ls.as_ref()
    }
    /// <p>A list of service updates being applied to the cluster</p>
    pub fn service_updates(
        &self,
    ) -> std::option::Option<&[crate::model::PendingModifiedServiceUpdate]> {
        self.service_updates.as_deref()
    }
}
impl std::fmt::Debug for ClusterPendingUpdates {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClusterPendingUpdates");
        formatter.field("resharding", &self.resharding);
        formatter.field("ac_ls", &self.ac_ls);
        formatter.field("service_updates", &self.service_updates);
        formatter.finish()
    }
}
/// See [`ClusterPendingUpdates`](crate::model::ClusterPendingUpdates)
pub mod cluster_pending_updates {
    /// A builder for [`ClusterPendingUpdates`](crate::model::ClusterPendingUpdates)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resharding: std::option::Option<crate::model::ReshardingStatus>,
        pub(crate) ac_ls: std::option::Option<crate::model::AcLsUpdateStatus>,
        pub(crate) service_updates:
            std::option::Option<std::vec::Vec<crate::model::PendingModifiedServiceUpdate>>,
    }
    impl Builder {
        /// <p>The status of an online resharding operation.</p>
        pub fn resharding(mut self, input: crate::model::ReshardingStatus) -> Self {
            self.resharding = Some(input);
            self
        }
        /// <p>The status of an online resharding operation.</p>
        pub fn set_resharding(
            mut self,
            input: std::option::Option<crate::model::ReshardingStatus>,
        ) -> Self {
            self.resharding = input;
            self
        }
        /// <p>A list of ACLs associated with the cluster that are being updated</p>
        pub fn ac_ls(mut self, input: crate::model::AcLsUpdateStatus) -> Self {
            self.ac_ls = Some(input);
            self
        }
        /// <p>A list of ACLs associated with the cluster that are being updated</p>
        pub fn set_ac_ls(
            mut self,
            input: std::option::Option<crate::model::AcLsUpdateStatus>,
        ) -> Self {
            self.ac_ls = input;
            self
        }
        /// Appends an item to `service_updates`.
        ///
        /// To override the contents of this collection use [`set_service_updates`](Self::set_service_updates).
        ///
        /// <p>A list of service updates being applied to the cluster</p>
        pub fn service_updates(
            mut self,
            input: impl Into<crate::model::PendingModifiedServiceUpdate>,
        ) -> Self {
            let mut v = self.service_updates.unwrap_or_default();
            v.push(input.into());
            self.service_updates = Some(v);
            self
        }
        /// <p>A list of service updates being applied to the cluster</p>
        pub fn set_service_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PendingModifiedServiceUpdate>>,
        ) -> Self {
            self.service_updates = input;
            self
        }
        /// Consumes the builder and constructs a [`ClusterPendingUpdates`](crate::model::ClusterPendingUpdates)
        pub fn build(self) -> crate::model::ClusterPendingUpdates {
            crate::model::ClusterPendingUpdates {
                resharding: self.resharding,
                ac_ls: self.ac_ls,
                service_updates: self.service_updates,
            }
        }
    }
}
impl ClusterPendingUpdates {
    /// Creates a new builder-style object to manufacture [`ClusterPendingUpdates`](crate::model::ClusterPendingUpdates)
    pub fn builder() -> crate::model::cluster_pending_updates::Builder {
        crate::model::cluster_pending_updates::Builder::default()
    }
}

/// <p>Update action that has yet to be processed for the corresponding apply/stop request</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PendingModifiedServiceUpdate {
    /// <p>The unique ID of the service update</p>
    pub service_update_name: std::option::Option<std::string::String>,
    /// <p>The status of the service update</p>
    pub status: std::option::Option<crate::model::ServiceUpdateStatus>,
}
impl PendingModifiedServiceUpdate {
    /// <p>The unique ID of the service update</p>
    pub fn service_update_name(&self) -> std::option::Option<&str> {
        self.service_update_name.as_deref()
    }
    /// <p>The status of the service update</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ServiceUpdateStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for PendingModifiedServiceUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PendingModifiedServiceUpdate");
        formatter.field("service_update_name", &self.service_update_name);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`PendingModifiedServiceUpdate`](crate::model::PendingModifiedServiceUpdate)
pub mod pending_modified_service_update {
    /// A builder for [`PendingModifiedServiceUpdate`](crate::model::PendingModifiedServiceUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_update_name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ServiceUpdateStatus>,
    }
    impl Builder {
        /// <p>The unique ID of the service update</p>
        pub fn service_update_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_update_name = Some(input.into());
            self
        }
        /// <p>The unique ID of the service update</p>
        pub fn set_service_update_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_update_name = input;
            self
        }
        /// <p>The status of the service update</p>
        pub fn status(mut self, input: crate::model::ServiceUpdateStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the service update</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ServiceUpdateStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`PendingModifiedServiceUpdate`](crate::model::PendingModifiedServiceUpdate)
        pub fn build(self) -> crate::model::PendingModifiedServiceUpdate {
            crate::model::PendingModifiedServiceUpdate {
                service_update_name: self.service_update_name,
                status: self.status,
            }
        }
    }
}
impl PendingModifiedServiceUpdate {
    /// Creates a new builder-style object to manufacture [`PendingModifiedServiceUpdate`](crate::model::PendingModifiedServiceUpdate)
    pub fn builder() -> crate::model::pending_modified_service_update::Builder {
        crate::model::pending_modified_service_update::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ServiceUpdateStatus {
    #[allow(missing_docs)] // documentation missing in model
    NotApplied,
    #[allow(missing_docs)] // documentation missing in model
    Complete,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Scheduled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ServiceUpdateStatus {
    fn from(s: &str) -> Self {
        match s {
            "available" => ServiceUpdateStatus::NotApplied,
            "complete" => ServiceUpdateStatus::Complete,
            "in-progress" => ServiceUpdateStatus::InProgress,
            "scheduled" => ServiceUpdateStatus::Scheduled,
            other => ServiceUpdateStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ServiceUpdateStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ServiceUpdateStatus::from(s))
    }
}
impl ServiceUpdateStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ServiceUpdateStatus::NotApplied => "available",
            ServiceUpdateStatus::Complete => "complete",
            ServiceUpdateStatus::InProgress => "in-progress",
            ServiceUpdateStatus::Scheduled => "scheduled",
            ServiceUpdateStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["available", "complete", "in-progress", "scheduled"]
    }
}
impl AsRef<str> for ServiceUpdateStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The status of the ACL update</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AcLsUpdateStatus {
    /// <p>A list of ACLs pending to be applied.</p>
    pub acl_to_apply: std::option::Option<std::string::String>,
}
impl AcLsUpdateStatus {
    /// <p>A list of ACLs pending to be applied.</p>
    pub fn acl_to_apply(&self) -> std::option::Option<&str> {
        self.acl_to_apply.as_deref()
    }
}
impl std::fmt::Debug for AcLsUpdateStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AcLsUpdateStatus");
        formatter.field("acl_to_apply", &self.acl_to_apply);
        formatter.finish()
    }
}
/// See [`AcLsUpdateStatus`](crate::model::AcLsUpdateStatus)
pub mod ac_ls_update_status {
    /// A builder for [`AcLsUpdateStatus`](crate::model::AcLsUpdateStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) acl_to_apply: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A list of ACLs pending to be applied.</p>
        pub fn acl_to_apply(mut self, input: impl Into<std::string::String>) -> Self {
            self.acl_to_apply = Some(input.into());
            self
        }
        /// <p>A list of ACLs pending to be applied.</p>
        pub fn set_acl_to_apply(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.acl_to_apply = input;
            self
        }
        /// Consumes the builder and constructs a [`AcLsUpdateStatus`](crate::model::AcLsUpdateStatus)
        pub fn build(self) -> crate::model::AcLsUpdateStatus {
            crate::model::AcLsUpdateStatus {
                acl_to_apply: self.acl_to_apply,
            }
        }
    }
}
impl AcLsUpdateStatus {
    /// Creates a new builder-style object to manufacture [`AcLsUpdateStatus`](crate::model::AcLsUpdateStatus)
    pub fn builder() -> crate::model::ac_ls_update_status::Builder {
        crate::model::ac_ls_update_status::Builder::default()
    }
}

/// <p>The status of the online resharding</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReshardingStatus {
    /// <p>The status of the online resharding slot migration</p>
    pub slot_migration: std::option::Option<crate::model::SlotMigration>,
}
impl ReshardingStatus {
    /// <p>The status of the online resharding slot migration</p>
    pub fn slot_migration(&self) -> std::option::Option<&crate::model::SlotMigration> {
        self.slot_migration.as_ref()
    }
}
impl std::fmt::Debug for ReshardingStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReshardingStatus");
        formatter.field("slot_migration", &self.slot_migration);
        formatter.finish()
    }
}
/// See [`ReshardingStatus`](crate::model::ReshardingStatus)
pub mod resharding_status {
    /// A builder for [`ReshardingStatus`](crate::model::ReshardingStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) slot_migration: std::option::Option<crate::model::SlotMigration>,
    }
    impl Builder {
        /// <p>The status of the online resharding slot migration</p>
        pub fn slot_migration(mut self, input: crate::model::SlotMigration) -> Self {
            self.slot_migration = Some(input);
            self
        }
        /// <p>The status of the online resharding slot migration</p>
        pub fn set_slot_migration(
            mut self,
            input: std::option::Option<crate::model::SlotMigration>,
        ) -> Self {
            self.slot_migration = input;
            self
        }
        /// Consumes the builder and constructs a [`ReshardingStatus`](crate::model::ReshardingStatus)
        pub fn build(self) -> crate::model::ReshardingStatus {
            crate::model::ReshardingStatus {
                slot_migration: self.slot_migration,
            }
        }
    }
}
impl ReshardingStatus {
    /// Creates a new builder-style object to manufacture [`ReshardingStatus`](crate::model::ReshardingStatus)
    pub fn builder() -> crate::model::resharding_status::Builder {
        crate::model::resharding_status::Builder::default()
    }
}

/// <p>Represents the progress of an online resharding operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SlotMigration {
    /// <p>The percentage of the slot migration that is complete.</p>
    pub progress_percentage: f64,
}
impl SlotMigration {
    /// <p>The percentage of the slot migration that is complete.</p>
    pub fn progress_percentage(&self) -> f64 {
        self.progress_percentage
    }
}
impl std::fmt::Debug for SlotMigration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SlotMigration");
        formatter.field("progress_percentage", &self.progress_percentage);
        formatter.finish()
    }
}
/// See [`SlotMigration`](crate::model::SlotMigration)
pub mod slot_migration {
    /// A builder for [`SlotMigration`](crate::model::SlotMigration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) progress_percentage: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The percentage of the slot migration that is complete.</p>
        pub fn progress_percentage(mut self, input: f64) -> Self {
            self.progress_percentage = Some(input);
            self
        }
        /// <p>The percentage of the slot migration that is complete.</p>
        pub fn set_progress_percentage(mut self, input: std::option::Option<f64>) -> Self {
            self.progress_percentage = input;
            self
        }
        /// Consumes the builder and constructs a [`SlotMigration`](crate::model::SlotMigration)
        pub fn build(self) -> crate::model::SlotMigration {
            crate::model::SlotMigration {
                progress_percentage: self.progress_percentage.unwrap_or_default(),
            }
        }
    }
}
impl SlotMigration {
    /// Creates a new builder-style object to manufacture [`SlotMigration`](crate::model::SlotMigration)
    pub fn builder() -> crate::model::slot_migration::Builder {
        crate::model::slot_migration::Builder::default()
    }
}

/// <p>A request to configure the sharding properties of a cluster</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ShardConfigurationRequest {
    /// <p>The number of shards in the cluster</p>
    pub shard_count: i32,
}
impl ShardConfigurationRequest {
    /// <p>The number of shards in the cluster</p>
    pub fn shard_count(&self) -> i32 {
        self.shard_count
    }
}
impl std::fmt::Debug for ShardConfigurationRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ShardConfigurationRequest");
        formatter.field("shard_count", &self.shard_count);
        formatter.finish()
    }
}
/// See [`ShardConfigurationRequest`](crate::model::ShardConfigurationRequest)
pub mod shard_configuration_request {
    /// A builder for [`ShardConfigurationRequest`](crate::model::ShardConfigurationRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) shard_count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The number of shards in the cluster</p>
        pub fn shard_count(mut self, input: i32) -> Self {
            self.shard_count = Some(input);
            self
        }
        /// <p>The number of shards in the cluster</p>
        pub fn set_shard_count(mut self, input: std::option::Option<i32>) -> Self {
            self.shard_count = input;
            self
        }
        /// Consumes the builder and constructs a [`ShardConfigurationRequest`](crate::model::ShardConfigurationRequest)
        pub fn build(self) -> crate::model::ShardConfigurationRequest {
            crate::model::ShardConfigurationRequest {
                shard_count: self.shard_count.unwrap_or_default(),
            }
        }
    }
}
impl ShardConfigurationRequest {
    /// Creates a new builder-style object to manufacture [`ShardConfigurationRequest`](crate::model::ShardConfigurationRequest)
    pub fn builder() -> crate::model::shard_configuration_request::Builder {
        crate::model::shard_configuration_request::Builder::default()
    }
}

/// <p>A request to configure the number of replicas in a shard</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReplicaConfigurationRequest {
    /// <p>The number of replicas to scale up or down to</p>
    pub replica_count: i32,
}
impl ReplicaConfigurationRequest {
    /// <p>The number of replicas to scale up or down to</p>
    pub fn replica_count(&self) -> i32 {
        self.replica_count
    }
}
impl std::fmt::Debug for ReplicaConfigurationRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReplicaConfigurationRequest");
        formatter.field("replica_count", &self.replica_count);
        formatter.finish()
    }
}
/// See [`ReplicaConfigurationRequest`](crate::model::ReplicaConfigurationRequest)
pub mod replica_configuration_request {
    /// A builder for [`ReplicaConfigurationRequest`](crate::model::ReplicaConfigurationRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replica_count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The number of replicas to scale up or down to</p>
        pub fn replica_count(mut self, input: i32) -> Self {
            self.replica_count = Some(input);
            self
        }
        /// <p>The number of replicas to scale up or down to</p>
        pub fn set_replica_count(mut self, input: std::option::Option<i32>) -> Self {
            self.replica_count = input;
            self
        }
        /// Consumes the builder and constructs a [`ReplicaConfigurationRequest`](crate::model::ReplicaConfigurationRequest)
        pub fn build(self) -> crate::model::ReplicaConfigurationRequest {
            crate::model::ReplicaConfigurationRequest {
                replica_count: self.replica_count.unwrap_or_default(),
            }
        }
    }
}
impl ReplicaConfigurationRequest {
    /// Creates a new builder-style object to manufacture [`ReplicaConfigurationRequest`](crate::model::ReplicaConfigurationRequest)
    pub fn builder() -> crate::model::replica_configuration_request::Builder {
        crate::model::replica_configuration_request::Builder::default()
    }
}

/// <p>An Access Control List. You can authenticate users with Access Contol Lists.
///
/// ACLs enable you to control cluster access by grouping users. These Access control lists are designed as a way to organize access to clusters.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Acl {
    /// <p>The name of the Access Control List</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Indicates ACL status. Can be "creating", "active", "modifying", "deleting".</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The list of user names that belong to the ACL.</p>
    pub user_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The minimum engine version supported for the ACL</p>
    pub minimum_engine_version: std::option::Option<std::string::String>,
    /// <p>A list of updates being applied to the ACL.</p>
    pub pending_changes: std::option::Option<crate::model::AclPendingChanges>,
    /// <p>A list of clusters associated with the ACL.</p>
    pub clusters: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The Amazon Resource Name (ARN) of the ACL</p>
    pub arn: std::option::Option<std::string::String>,
}
impl Acl {
    /// <p>The name of the Access Control List</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Indicates ACL status. Can be "creating", "active", "modifying", "deleting".</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The list of user names that belong to the ACL.</p>
    pub fn user_names(&self) -> std::option::Option<&[std::string::String]> {
        self.user_names.as_deref()
    }
    /// <p>The minimum engine version supported for the ACL</p>
    pub fn minimum_engine_version(&self) -> std::option::Option<&str> {
        self.minimum_engine_version.as_deref()
    }
    /// <p>A list of updates being applied to the ACL.</p>
    pub fn pending_changes(&self) -> std::option::Option<&crate::model::AclPendingChanges> {
        self.pending_changes.as_ref()
    }
    /// <p>A list of clusters associated with the ACL.</p>
    pub fn clusters(&self) -> std::option::Option<&[std::string::String]> {
        self.clusters.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the ACL</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for Acl {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Acl");
        formatter.field("name", &self.name);
        formatter.field("status", &self.status);
        formatter.field("user_names", &self.user_names);
        formatter.field("minimum_engine_version", &self.minimum_engine_version);
        formatter.field("pending_changes", &self.pending_changes);
        formatter.field("clusters", &self.clusters);
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`Acl`](crate::model::Acl)
pub mod acl {
    /// A builder for [`Acl`](crate::model::Acl)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) user_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) minimum_engine_version: std::option::Option<std::string::String>,
        pub(crate) pending_changes: std::option::Option<crate::model::AclPendingChanges>,
        pub(crate) clusters: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Access Control List</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the Access Control List</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Indicates ACL status. Can be "creating", "active", "modifying", "deleting".</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>Indicates ACL status. Can be "creating", "active", "modifying", "deleting".</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Appends an item to `user_names`.
        ///
        /// To override the contents of this collection use [`set_user_names`](Self::set_user_names).
        ///
        /// <p>The list of user names that belong to the ACL.</p>
        pub fn user_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.user_names.unwrap_or_default();
            v.push(input.into());
            self.user_names = Some(v);
            self
        }
        /// <p>The list of user names that belong to the ACL.</p>
        pub fn set_user_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.user_names = input;
            self
        }
        /// <p>The minimum engine version supported for the ACL</p>
        pub fn minimum_engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.minimum_engine_version = Some(input.into());
            self
        }
        /// <p>The minimum engine version supported for the ACL</p>
        pub fn set_minimum_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.minimum_engine_version = input;
            self
        }
        /// <p>A list of updates being applied to the ACL.</p>
        pub fn pending_changes(mut self, input: crate::model::AclPendingChanges) -> Self {
            self.pending_changes = Some(input);
            self
        }
        /// <p>A list of updates being applied to the ACL.</p>
        pub fn set_pending_changes(
            mut self,
            input: std::option::Option<crate::model::AclPendingChanges>,
        ) -> Self {
            self.pending_changes = input;
            self
        }
        /// Appends an item to `clusters`.
        ///
        /// To override the contents of this collection use [`set_clusters`](Self::set_clusters).
        ///
        /// <p>A list of clusters associated with the ACL.</p>
        pub fn clusters(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.clusters.unwrap_or_default();
            v.push(input.into());
            self.clusters = Some(v);
            self
        }
        /// <p>A list of clusters associated with the ACL.</p>
        pub fn set_clusters(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.clusters = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the ACL</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the ACL</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`Acl`](crate::model::Acl)
        pub fn build(self) -> crate::model::Acl {
            crate::model::Acl {
                name: self.name,
                status: self.status,
                user_names: self.user_names,
                minimum_engine_version: self.minimum_engine_version,
                pending_changes: self.pending_changes,
                clusters: self.clusters,
                arn: self.arn,
            }
        }
    }
}
impl Acl {
    /// Creates a new builder-style object to manufacture [`Acl`](crate::model::Acl)
    pub fn builder() -> crate::model::acl::Builder {
        crate::model::acl::Builder::default()
    }
}

/// <p>Returns the updates being applied to the ACL.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AclPendingChanges {
    /// <p>A list of user names being removed from the ACL</p>
    pub user_names_to_remove: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of users being added to the ACL</p>
    pub user_names_to_add: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl AclPendingChanges {
    /// <p>A list of user names being removed from the ACL</p>
    pub fn user_names_to_remove(&self) -> std::option::Option<&[std::string::String]> {
        self.user_names_to_remove.as_deref()
    }
    /// <p>A list of users being added to the ACL</p>
    pub fn user_names_to_add(&self) -> std::option::Option<&[std::string::String]> {
        self.user_names_to_add.as_deref()
    }
}
impl std::fmt::Debug for AclPendingChanges {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AclPendingChanges");
        formatter.field("user_names_to_remove", &self.user_names_to_remove);
        formatter.field("user_names_to_add", &self.user_names_to_add);
        formatter.finish()
    }
}
/// See [`AclPendingChanges`](crate::model::AclPendingChanges)
pub mod acl_pending_changes {
    /// A builder for [`AclPendingChanges`](crate::model::AclPendingChanges)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_names_to_remove: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) user_names_to_add: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `user_names_to_remove`.
        ///
        /// To override the contents of this collection use [`set_user_names_to_remove`](Self::set_user_names_to_remove).
        ///
        /// <p>A list of user names being removed from the ACL</p>
        pub fn user_names_to_remove(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.user_names_to_remove.unwrap_or_default();
            v.push(input.into());
            self.user_names_to_remove = Some(v);
            self
        }
        /// <p>A list of user names being removed from the ACL</p>
        pub fn set_user_names_to_remove(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.user_names_to_remove = input;
            self
        }
        /// Appends an item to `user_names_to_add`.
        ///
        /// To override the contents of this collection use [`set_user_names_to_add`](Self::set_user_names_to_add).
        ///
        /// <p>A list of users being added to the ACL</p>
        pub fn user_names_to_add(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.user_names_to_add.unwrap_or_default();
            v.push(input.into());
            self.user_names_to_add = Some(v);
            self
        }
        /// <p>A list of users being added to the ACL</p>
        pub fn set_user_names_to_add(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.user_names_to_add = input;
            self
        }
        /// Consumes the builder and constructs a [`AclPendingChanges`](crate::model::AclPendingChanges)
        pub fn build(self) -> crate::model::AclPendingChanges {
            crate::model::AclPendingChanges {
                user_names_to_remove: self.user_names_to_remove,
                user_names_to_add: self.user_names_to_add,
            }
        }
    }
}
impl AclPendingChanges {
    /// Creates a new builder-style object to manufacture [`AclPendingChanges`](crate::model::AclPendingChanges)
    pub fn builder() -> crate::model::acl_pending_changes::Builder {
        crate::model::acl_pending_changes::Builder::default()
    }
}

/// <p>A tag that can be added to an MemoryDB resource. Tags are composed of a Key/Value pair. You can use tags to categorize and track all your MemoryDB resources.
/// When you add or remove tags on clusters, those actions will be replicated to all nodes in the cluster. A tag with a null Value is permitted. For more information, see
/// <a href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/tagging-resources.html">Tagging your MemoryDB resources</a>
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The key for the tag. May not be null.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The tag's value. May be null.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>The key for the tag. May not be null.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The tag's value. May be null.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The key for the tag. May not be null.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key for the tag. May not be null.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The tag's value. May be null.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The tag's value. May be null.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>Used to streamline results of a search based on the property being filtered.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Filter {
    /// <p>The property being filtered. For example, UserName.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The property values to filter on. For example, "user-123".</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl Filter {
    /// <p>The property being filtered. For example, UserName.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The property values to filter on. For example, "user-123".</p>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for Filter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Filter");
        formatter.field("name", &self.name);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`Filter`](crate::model::Filter)
pub mod filter {
    /// A builder for [`Filter`](crate::model::Filter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The property being filtered. For example, UserName.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The property being filtered. For example, UserName.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The property values to filter on. For example, "user-123".</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The property values to filter on. For example, "user-123".</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`Filter`](crate::model::Filter)
        pub fn build(self) -> crate::model::Filter {
            crate::model::Filter {
                name: self.name,
                values: self.values,
            }
        }
    }
}
impl Filter {
    /// Creates a new builder-style object to manufacture [`Filter`](crate::model::Filter)
    pub fn builder() -> crate::model::filter::Builder {
        crate::model::filter::Builder::default()
    }
}

/// <p>Represents a copy of an entire cluster as of the time when the snapshot was taken.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Snapshot {
    /// <p>The name of the snapshot</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The status of the snapshot. Valid values: creating | available | restoring | copying | deleting.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>Indicates whether the snapshot is from an automatic backup (automated) or was created manually (manual).</p>
    pub source: std::option::Option<std::string::String>,
    /// <p>The ID of the KMS key used to encrypt the snapshot.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>The ARN (Amazon Resource Name) of the snapshot.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The configuration of the cluster from which the snapshot was taken</p>
    pub cluster_configuration: std::option::Option<crate::model::ClusterConfiguration>,
}
impl Snapshot {
    /// <p>The name of the snapshot</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The status of the snapshot. Valid values: creating | available | restoring | copying | deleting.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>Indicates whether the snapshot is from an automatic backup (automated) or was created manually (manual).</p>
    pub fn source(&self) -> std::option::Option<&str> {
        self.source.as_deref()
    }
    /// <p>The ID of the KMS key used to encrypt the snapshot.</p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>The ARN (Amazon Resource Name) of the snapshot.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The configuration of the cluster from which the snapshot was taken</p>
    pub fn cluster_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ClusterConfiguration> {
        self.cluster_configuration.as_ref()
    }
}
impl std::fmt::Debug for Snapshot {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Snapshot");
        formatter.field("name", &self.name);
        formatter.field("status", &self.status);
        formatter.field("source", &self.source);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("arn", &self.arn);
        formatter.field("cluster_configuration", &self.cluster_configuration);
        formatter.finish()
    }
}
/// See [`Snapshot`](crate::model::Snapshot)
pub mod snapshot {
    /// A builder for [`Snapshot`](crate::model::Snapshot)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) source: std::option::Option<std::string::String>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) cluster_configuration: std::option::Option<crate::model::ClusterConfiguration>,
    }
    impl Builder {
        /// <p>The name of the snapshot</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the snapshot</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The status of the snapshot. Valid values: creating | available | restoring | copying | deleting.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the snapshot. Valid values: creating | available | restoring | copying | deleting.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>Indicates whether the snapshot is from an automatic backup (automated) or was created manually (manual).</p>
        pub fn source(mut self, input: impl Into<std::string::String>) -> Self {
            self.source = Some(input.into());
            self
        }
        /// <p>Indicates whether the snapshot is from an automatic backup (automated) or was created manually (manual).</p>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source = input;
            self
        }
        /// <p>The ID of the KMS key used to encrypt the snapshot.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The ID of the KMS key used to encrypt the snapshot.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>The ARN (Amazon Resource Name) of the snapshot.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN (Amazon Resource Name) of the snapshot.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The configuration of the cluster from which the snapshot was taken</p>
        pub fn cluster_configuration(mut self, input: crate::model::ClusterConfiguration) -> Self {
            self.cluster_configuration = Some(input);
            self
        }
        /// <p>The configuration of the cluster from which the snapshot was taken</p>
        pub fn set_cluster_configuration(
            mut self,
            input: std::option::Option<crate::model::ClusterConfiguration>,
        ) -> Self {
            self.cluster_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`Snapshot`](crate::model::Snapshot)
        pub fn build(self) -> crate::model::Snapshot {
            crate::model::Snapshot {
                name: self.name,
                status: self.status,
                source: self.source,
                kms_key_id: self.kms_key_id,
                arn: self.arn,
                cluster_configuration: self.cluster_configuration,
            }
        }
    }
}
impl Snapshot {
    /// Creates a new builder-style object to manufacture [`Snapshot`](crate::model::Snapshot)
    pub fn builder() -> crate::model::snapshot::Builder {
        crate::model::snapshot::Builder::default()
    }
}

/// <p>A list of cluster configuration options. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClusterConfiguration {
    /// <p>The name of the cluster</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the cluster configuration</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The node type used for the cluster</p>
    pub node_type: std::option::Option<std::string::String>,
    /// <p>The Redis engine version used by the cluster</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>The specified maintenance window for the cluster</p>
    pub maintenance_window: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the SNS notification topic for the cluster</p>
    pub topic_arn: std::option::Option<std::string::String>,
    /// <p>The port used by the cluster</p>
    pub port: std::option::Option<i32>,
    /// <p>The name of parameter group used by the cluster</p>
    pub parameter_group_name: std::option::Option<std::string::String>,
    /// <p>The name of the subnet group used by the cluster</p>
    pub subnet_group_name: std::option::Option<std::string::String>,
    /// <p>The ID of the VPC the cluster belongs to</p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>The snapshot retention limit set by the cluster</p>
    pub snapshot_retention_limit: std::option::Option<i32>,
    /// <p>The snapshot window set by the cluster</p>
    pub snapshot_window: std::option::Option<std::string::String>,
    /// <p>The number of shards in the cluster</p>
    pub num_shards: std::option::Option<i32>,
    /// <p>The list of shards in the cluster</p>
    pub shards: std::option::Option<std::vec::Vec<crate::model::ShardDetail>>,
}
impl ClusterConfiguration {
    /// <p>The name of the cluster</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of the cluster configuration</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The node type used for the cluster</p>
    pub fn node_type(&self) -> std::option::Option<&str> {
        self.node_type.as_deref()
    }
    /// <p>The Redis engine version used by the cluster</p>
    pub fn engine_version(&self) -> std::option::Option<&str> {
        self.engine_version.as_deref()
    }
    /// <p>The specified maintenance window for the cluster</p>
    pub fn maintenance_window(&self) -> std::option::Option<&str> {
        self.maintenance_window.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the SNS notification topic for the cluster</p>
    pub fn topic_arn(&self) -> std::option::Option<&str> {
        self.topic_arn.as_deref()
    }
    /// <p>The port used by the cluster</p>
    pub fn port(&self) -> std::option::Option<i32> {
        self.port
    }
    /// <p>The name of parameter group used by the cluster</p>
    pub fn parameter_group_name(&self) -> std::option::Option<&str> {
        self.parameter_group_name.as_deref()
    }
    /// <p>The name of the subnet group used by the cluster</p>
    pub fn subnet_group_name(&self) -> std::option::Option<&str> {
        self.subnet_group_name.as_deref()
    }
    /// <p>The ID of the VPC the cluster belongs to</p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
    /// <p>The snapshot retention limit set by the cluster</p>
    pub fn snapshot_retention_limit(&self) -> std::option::Option<i32> {
        self.snapshot_retention_limit
    }
    /// <p>The snapshot window set by the cluster</p>
    pub fn snapshot_window(&self) -> std::option::Option<&str> {
        self.snapshot_window.as_deref()
    }
    /// <p>The number of shards in the cluster</p>
    pub fn num_shards(&self) -> std::option::Option<i32> {
        self.num_shards
    }
    /// <p>The list of shards in the cluster</p>
    pub fn shards(&self) -> std::option::Option<&[crate::model::ShardDetail]> {
        self.shards.as_deref()
    }
}
impl std::fmt::Debug for ClusterConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClusterConfiguration");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("node_type", &self.node_type);
        formatter.field("engine_version", &self.engine_version);
        formatter.field("maintenance_window", &self.maintenance_window);
        formatter.field("topic_arn", &self.topic_arn);
        formatter.field("port", &self.port);
        formatter.field("parameter_group_name", &self.parameter_group_name);
        formatter.field("subnet_group_name", &self.subnet_group_name);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("snapshot_retention_limit", &self.snapshot_retention_limit);
        formatter.field("snapshot_window", &self.snapshot_window);
        formatter.field("num_shards", &self.num_shards);
        formatter.field("shards", &self.shards);
        formatter.finish()
    }
}
/// See [`ClusterConfiguration`](crate::model::ClusterConfiguration)
pub mod cluster_configuration {
    /// A builder for [`ClusterConfiguration`](crate::model::ClusterConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) node_type: std::option::Option<std::string::String>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) maintenance_window: std::option::Option<std::string::String>,
        pub(crate) topic_arn: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) subnet_group_name: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) snapshot_retention_limit: std::option::Option<i32>,
        pub(crate) snapshot_window: std::option::Option<std::string::String>,
        pub(crate) num_shards: std::option::Option<i32>,
        pub(crate) shards: std::option::Option<std::vec::Vec<crate::model::ShardDetail>>,
    }
    impl Builder {
        /// <p>The name of the cluster</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the cluster</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the cluster configuration</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the cluster configuration</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The node type used for the cluster</p>
        pub fn node_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.node_type = Some(input.into());
            self
        }
        /// <p>The node type used for the cluster</p>
        pub fn set_node_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.node_type = input;
            self
        }
        /// <p>The Redis engine version used by the cluster</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The Redis engine version used by the cluster</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>The specified maintenance window for the cluster</p>
        pub fn maintenance_window(mut self, input: impl Into<std::string::String>) -> Self {
            self.maintenance_window = Some(input.into());
            self
        }
        /// <p>The specified maintenance window for the cluster</p>
        pub fn set_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.maintenance_window = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the SNS notification topic for the cluster</p>
        pub fn topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.topic_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the SNS notification topic for the cluster</p>
        pub fn set_topic_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.topic_arn = input;
            self
        }
        /// <p>The port used by the cluster</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The port used by the cluster</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>The name of parameter group used by the cluster</p>
        pub fn parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of parameter group used by the cluster</p>
        pub fn set_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_group_name = input;
            self
        }
        /// <p>The name of the subnet group used by the cluster</p>
        pub fn subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_group_name = Some(input.into());
            self
        }
        /// <p>The name of the subnet group used by the cluster</p>
        pub fn set_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subnet_group_name = input;
            self
        }
        /// <p>The ID of the VPC the cluster belongs to</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The ID of the VPC the cluster belongs to</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// <p>The snapshot retention limit set by the cluster</p>
        pub fn snapshot_retention_limit(mut self, input: i32) -> Self {
            self.snapshot_retention_limit = Some(input);
            self
        }
        /// <p>The snapshot retention limit set by the cluster</p>
        pub fn set_snapshot_retention_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.snapshot_retention_limit = input;
            self
        }
        /// <p>The snapshot window set by the cluster</p>
        pub fn snapshot_window(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_window = Some(input.into());
            self
        }
        /// <p>The snapshot window set by the cluster</p>
        pub fn set_snapshot_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshot_window = input;
            self
        }
        /// <p>The number of shards in the cluster</p>
        pub fn num_shards(mut self, input: i32) -> Self {
            self.num_shards = Some(input);
            self
        }
        /// <p>The number of shards in the cluster</p>
        pub fn set_num_shards(mut self, input: std::option::Option<i32>) -> Self {
            self.num_shards = input;
            self
        }
        /// Appends an item to `shards`.
        ///
        /// To override the contents of this collection use [`set_shards`](Self::set_shards).
        ///
        /// <p>The list of shards in the cluster</p>
        pub fn shards(mut self, input: impl Into<crate::model::ShardDetail>) -> Self {
            let mut v = self.shards.unwrap_or_default();
            v.push(input.into());
            self.shards = Some(v);
            self
        }
        /// <p>The list of shards in the cluster</p>
        pub fn set_shards(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ShardDetail>>,
        ) -> Self {
            self.shards = input;
            self
        }
        /// Consumes the builder and constructs a [`ClusterConfiguration`](crate::model::ClusterConfiguration)
        pub fn build(self) -> crate::model::ClusterConfiguration {
            crate::model::ClusterConfiguration {
                name: self.name,
                description: self.description,
                node_type: self.node_type,
                engine_version: self.engine_version,
                maintenance_window: self.maintenance_window,
                topic_arn: self.topic_arn,
                port: self.port,
                parameter_group_name: self.parameter_group_name,
                subnet_group_name: self.subnet_group_name,
                vpc_id: self.vpc_id,
                snapshot_retention_limit: self.snapshot_retention_limit,
                snapshot_window: self.snapshot_window,
                num_shards: self.num_shards,
                shards: self.shards,
            }
        }
    }
}
impl ClusterConfiguration {
    /// Creates a new builder-style object to manufacture [`ClusterConfiguration`](crate::model::ClusterConfiguration)
    pub fn builder() -> crate::model::cluster_configuration::Builder {
        crate::model::cluster_configuration::Builder::default()
    }
}

/// <p>Provides details of a shard in a snapshot</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ShardDetail {
    /// <p>The name of the shard</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The configuration details of the shard</p>
    pub configuration: std::option::Option<crate::model::ShardConfiguration>,
    /// <p>The size of the shard's snapshot</p>
    pub size: std::option::Option<std::string::String>,
    /// <p>The date and time that the shard's snapshot was created</p>
    pub snapshot_creation_time: std::option::Option<aws_smithy_types::Instant>,
}
impl ShardDetail {
    /// <p>The name of the shard</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The configuration details of the shard</p>
    pub fn configuration(&self) -> std::option::Option<&crate::model::ShardConfiguration> {
        self.configuration.as_ref()
    }
    /// <p>The size of the shard's snapshot</p>
    pub fn size(&self) -> std::option::Option<&str> {
        self.size.as_deref()
    }
    /// <p>The date and time that the shard's snapshot was created</p>
    pub fn snapshot_creation_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.snapshot_creation_time.as_ref()
    }
}
impl std::fmt::Debug for ShardDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ShardDetail");
        formatter.field("name", &self.name);
        formatter.field("configuration", &self.configuration);
        formatter.field("size", &self.size);
        formatter.field("snapshot_creation_time", &self.snapshot_creation_time);
        formatter.finish()
    }
}
/// See [`ShardDetail`](crate::model::ShardDetail)
pub mod shard_detail {
    /// A builder for [`ShardDetail`](crate::model::ShardDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) configuration: std::option::Option<crate::model::ShardConfiguration>,
        pub(crate) size: std::option::Option<std::string::String>,
        pub(crate) snapshot_creation_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The name of the shard</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the shard</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The configuration details of the shard</p>
        pub fn configuration(mut self, input: crate::model::ShardConfiguration) -> Self {
            self.configuration = Some(input);
            self
        }
        /// <p>The configuration details of the shard</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::ShardConfiguration>,
        ) -> Self {
            self.configuration = input;
            self
        }
        /// <p>The size of the shard's snapshot</p>
        pub fn size(mut self, input: impl Into<std::string::String>) -> Self {
            self.size = Some(input.into());
            self
        }
        /// <p>The size of the shard's snapshot</p>
        pub fn set_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.size = input;
            self
        }
        /// <p>The date and time that the shard's snapshot was created</p>
        pub fn snapshot_creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.snapshot_creation_time = Some(input);
            self
        }
        /// <p>The date and time that the shard's snapshot was created</p>
        pub fn set_snapshot_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.snapshot_creation_time = input;
            self
        }
        /// Consumes the builder and constructs a [`ShardDetail`](crate::model::ShardDetail)
        pub fn build(self) -> crate::model::ShardDetail {
            crate::model::ShardDetail {
                name: self.name,
                configuration: self.configuration,
                size: self.size,
                snapshot_creation_time: self.snapshot_creation_time,
            }
        }
    }
}
impl ShardDetail {
    /// Creates a new builder-style object to manufacture [`ShardDetail`](crate::model::ShardDetail)
    pub fn builder() -> crate::model::shard_detail::Builder {
        crate::model::shard_detail::Builder::default()
    }
}

/// <p>Shard configuration options. Each shard configuration has the following: Slots and ReplicaCount.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ShardConfiguration {
    /// <p>A string that specifies the keyspace for a particular node group. Keyspaces range from 0 to 16,383. The string is in the format startkey-endkey.</p>
    pub slots: std::option::Option<std::string::String>,
    /// <p>The number of read replica nodes in this shard.</p>
    pub replica_count: std::option::Option<i32>,
}
impl ShardConfiguration {
    /// <p>A string that specifies the keyspace for a particular node group. Keyspaces range from 0 to 16,383. The string is in the format startkey-endkey.</p>
    pub fn slots(&self) -> std::option::Option<&str> {
        self.slots.as_deref()
    }
    /// <p>The number of read replica nodes in this shard.</p>
    pub fn replica_count(&self) -> std::option::Option<i32> {
        self.replica_count
    }
}
impl std::fmt::Debug for ShardConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ShardConfiguration");
        formatter.field("slots", &self.slots);
        formatter.field("replica_count", &self.replica_count);
        formatter.finish()
    }
}
/// See [`ShardConfiguration`](crate::model::ShardConfiguration)
pub mod shard_configuration {
    /// A builder for [`ShardConfiguration`](crate::model::ShardConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) slots: std::option::Option<std::string::String>,
        pub(crate) replica_count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>A string that specifies the keyspace for a particular node group. Keyspaces range from 0 to 16,383. The string is in the format startkey-endkey.</p>
        pub fn slots(mut self, input: impl Into<std::string::String>) -> Self {
            self.slots = Some(input.into());
            self
        }
        /// <p>A string that specifies the keyspace for a particular node group. Keyspaces range from 0 to 16,383. The string is in the format startkey-endkey.</p>
        pub fn set_slots(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.slots = input;
            self
        }
        /// <p>The number of read replica nodes in this shard.</p>
        pub fn replica_count(mut self, input: i32) -> Self {
            self.replica_count = Some(input);
            self
        }
        /// <p>The number of read replica nodes in this shard.</p>
        pub fn set_replica_count(mut self, input: std::option::Option<i32>) -> Self {
            self.replica_count = input;
            self
        }
        /// Consumes the builder and constructs a [`ShardConfiguration`](crate::model::ShardConfiguration)
        pub fn build(self) -> crate::model::ShardConfiguration {
            crate::model::ShardConfiguration {
                slots: self.slots,
                replica_count: self.replica_count,
            }
        }
    }
}
impl ShardConfiguration {
    /// Creates a new builder-style object to manufacture [`ShardConfiguration`](crate::model::ShardConfiguration)
    pub fn builder() -> crate::model::shard_configuration::Builder {
        crate::model::shard_configuration::Builder::default()
    }
}

/// <p>An update that you can apply to your MemoryDB clusters.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceUpdate {
    /// <p>The name of the cluster to which the service update applies</p>
    pub cluster_name: std::option::Option<std::string::String>,
    /// <p>The unique ID of the service update</p>
    pub service_update_name: std::option::Option<std::string::String>,
    /// <p>The date when the service update is initially available</p>
    pub release_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Provides details of the service update</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The status of the service update</p>
    pub status: std::option::Option<crate::model::ServiceUpdateStatus>,
    /// <p>Reflects the nature of the service update</p>
    pub r#type: std::option::Option<crate::model::ServiceUpdateType>,
    /// <p>A list of nodes updated by the service update</p>
    pub nodes_updated: std::option::Option<std::string::String>,
    /// <p>The date at which the service update will be automatically applied</p>
    pub auto_update_start_date: std::option::Option<aws_smithy_types::Instant>,
}
impl ServiceUpdate {
    /// <p>The name of the cluster to which the service update applies</p>
    pub fn cluster_name(&self) -> std::option::Option<&str> {
        self.cluster_name.as_deref()
    }
    /// <p>The unique ID of the service update</p>
    pub fn service_update_name(&self) -> std::option::Option<&str> {
        self.service_update_name.as_deref()
    }
    /// <p>The date when the service update is initially available</p>
    pub fn release_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.release_date.as_ref()
    }
    /// <p>Provides details of the service update</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The status of the service update</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ServiceUpdateStatus> {
        self.status.as_ref()
    }
    /// <p>Reflects the nature of the service update</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ServiceUpdateType> {
        self.r#type.as_ref()
    }
    /// <p>A list of nodes updated by the service update</p>
    pub fn nodes_updated(&self) -> std::option::Option<&str> {
        self.nodes_updated.as_deref()
    }
    /// <p>The date at which the service update will be automatically applied</p>
    pub fn auto_update_start_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.auto_update_start_date.as_ref()
    }
}
impl std::fmt::Debug for ServiceUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceUpdate");
        formatter.field("cluster_name", &self.cluster_name);
        formatter.field("service_update_name", &self.service_update_name);
        formatter.field("release_date", &self.release_date);
        formatter.field("description", &self.description);
        formatter.field("status", &self.status);
        formatter.field("r#type", &self.r#type);
        formatter.field("nodes_updated", &self.nodes_updated);
        formatter.field("auto_update_start_date", &self.auto_update_start_date);
        formatter.finish()
    }
}
/// See [`ServiceUpdate`](crate::model::ServiceUpdate)
pub mod service_update {
    /// A builder for [`ServiceUpdate`](crate::model::ServiceUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_name: std::option::Option<std::string::String>,
        pub(crate) service_update_name: std::option::Option<std::string::String>,
        pub(crate) release_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ServiceUpdateStatus>,
        pub(crate) r#type: std::option::Option<crate::model::ServiceUpdateType>,
        pub(crate) nodes_updated: std::option::Option<std::string::String>,
        pub(crate) auto_update_start_date: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The name of the cluster to which the service update applies</p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_name = Some(input.into());
            self
        }
        /// <p>The name of the cluster to which the service update applies</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_name = input;
            self
        }
        /// <p>The unique ID of the service update</p>
        pub fn service_update_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_update_name = Some(input.into());
            self
        }
        /// <p>The unique ID of the service update</p>
        pub fn set_service_update_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_update_name = input;
            self
        }
        /// <p>The date when the service update is initially available</p>
        pub fn release_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.release_date = Some(input);
            self
        }
        /// <p>The date when the service update is initially available</p>
        pub fn set_release_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.release_date = input;
            self
        }
        /// <p>Provides details of the service update</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Provides details of the service update</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The status of the service update</p>
        pub fn status(mut self, input: crate::model::ServiceUpdateStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the service update</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ServiceUpdateStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Reflects the nature of the service update</p>
        pub fn r#type(mut self, input: crate::model::ServiceUpdateType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>Reflects the nature of the service update</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ServiceUpdateType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>A list of nodes updated by the service update</p>
        pub fn nodes_updated(mut self, input: impl Into<std::string::String>) -> Self {
            self.nodes_updated = Some(input.into());
            self
        }
        /// <p>A list of nodes updated by the service update</p>
        pub fn set_nodes_updated(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.nodes_updated = input;
            self
        }
        /// <p>The date at which the service update will be automatically applied</p>
        pub fn auto_update_start_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.auto_update_start_date = Some(input);
            self
        }
        /// <p>The date at which the service update will be automatically applied</p>
        pub fn set_auto_update_start_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.auto_update_start_date = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceUpdate`](crate::model::ServiceUpdate)
        pub fn build(self) -> crate::model::ServiceUpdate {
            crate::model::ServiceUpdate {
                cluster_name: self.cluster_name,
                service_update_name: self.service_update_name,
                release_date: self.release_date,
                description: self.description,
                status: self.status,
                r#type: self.r#type,
                nodes_updated: self.nodes_updated,
                auto_update_start_date: self.auto_update_start_date,
            }
        }
    }
}
impl ServiceUpdate {
    /// Creates a new builder-style object to manufacture [`ServiceUpdate`](crate::model::ServiceUpdate)
    pub fn builder() -> crate::model::service_update::Builder {
        crate::model::service_update::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ServiceUpdateType {
    #[allow(missing_docs)] // documentation missing in model
    SecurityUpdate,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ServiceUpdateType {
    fn from(s: &str) -> Self {
        match s {
            "security-update" => ServiceUpdateType::SecurityUpdate,
            other => ServiceUpdateType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ServiceUpdateType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ServiceUpdateType::from(s))
    }
}
impl ServiceUpdateType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ServiceUpdateType::SecurityUpdate => "security-update",
            ServiceUpdateType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["security-update"]
    }
}
impl AsRef<str> for ServiceUpdateType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes an individual setting that controls some aspect of MemoryDB behavior.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Parameter {
    /// <p>The name of the parameter</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The value of the parameter</p>
    pub value: std::option::Option<std::string::String>,
    /// <p>A description of the parameter</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The parameter's data type</p>
    pub data_type: std::option::Option<std::string::String>,
    /// <p>The valid range of values for the parameter.</p>
    pub allowed_values: std::option::Option<std::string::String>,
    /// <p>The earliest engine version to which the parameter can apply.</p>
    pub minimum_engine_version: std::option::Option<std::string::String>,
}
impl Parameter {
    /// <p>The name of the parameter</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The value of the parameter</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
    /// <p>A description of the parameter</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The parameter's data type</p>
    pub fn data_type(&self) -> std::option::Option<&str> {
        self.data_type.as_deref()
    }
    /// <p>The valid range of values for the parameter.</p>
    pub fn allowed_values(&self) -> std::option::Option<&str> {
        self.allowed_values.as_deref()
    }
    /// <p>The earliest engine version to which the parameter can apply.</p>
    pub fn minimum_engine_version(&self) -> std::option::Option<&str> {
        self.minimum_engine_version.as_deref()
    }
}
impl std::fmt::Debug for Parameter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Parameter");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.field("description", &self.description);
        formatter.field("data_type", &self.data_type);
        formatter.field("allowed_values", &self.allowed_values);
        formatter.field("minimum_engine_version", &self.minimum_engine_version);
        formatter.finish()
    }
}
/// See [`Parameter`](crate::model::Parameter)
pub mod parameter {
    /// A builder for [`Parameter`](crate::model::Parameter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) data_type: std::option::Option<std::string::String>,
        pub(crate) allowed_values: std::option::Option<std::string::String>,
        pub(crate) minimum_engine_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the parameter</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the parameter</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The value of the parameter</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the parameter</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// <p>A description of the parameter</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the parameter</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The parameter's data type</p>
        pub fn data_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_type = Some(input.into());
            self
        }
        /// <p>The parameter's data type</p>
        pub fn set_data_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_type = input;
            self
        }
        /// <p>The valid range of values for the parameter.</p>
        pub fn allowed_values(mut self, input: impl Into<std::string::String>) -> Self {
            self.allowed_values = Some(input.into());
            self
        }
        /// <p>The valid range of values for the parameter.</p>
        pub fn set_allowed_values(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.allowed_values = input;
            self
        }
        /// <p>The earliest engine version to which the parameter can apply.</p>
        pub fn minimum_engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.minimum_engine_version = Some(input.into());
            self
        }
        /// <p>The earliest engine version to which the parameter can apply.</p>
        pub fn set_minimum_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.minimum_engine_version = input;
            self
        }
        /// Consumes the builder and constructs a [`Parameter`](crate::model::Parameter)
        pub fn build(self) -> crate::model::Parameter {
            crate::model::Parameter {
                name: self.name,
                value: self.value,
                description: self.description,
                data_type: self.data_type,
                allowed_values: self.allowed_values,
                minimum_engine_version: self.minimum_engine_version,
            }
        }
    }
}
impl Parameter {
    /// Creates a new builder-style object to manufacture [`Parameter`](crate::model::Parameter)
    pub fn builder() -> crate::model::parameter::Builder {
        crate::model::parameter::Builder::default()
    }
}

/// <p>Represents a single occurrence of something interesting within the system. Some examples of events are creating a cluster or adding or removing a
/// node.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Event {
    /// <p>The name for the source of the event. For example, if the event occurred at the cluster level, the identifier would be the name of the cluster.</p>
    pub source_name: std::option::Option<std::string::String>,
    /// <p>Specifies the origin of this event - a cluster, a parameter group, a security group, etc.</p>
    pub source_type: std::option::Option<crate::model::SourceType>,
    /// <p>The text of the event.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The date and time when the event occurred.</p>
    pub date: std::option::Option<aws_smithy_types::Instant>,
}
impl Event {
    /// <p>The name for the source of the event. For example, if the event occurred at the cluster level, the identifier would be the name of the cluster.</p>
    pub fn source_name(&self) -> std::option::Option<&str> {
        self.source_name.as_deref()
    }
    /// <p>Specifies the origin of this event - a cluster, a parameter group, a security group, etc.</p>
    pub fn source_type(&self) -> std::option::Option<&crate::model::SourceType> {
        self.source_type.as_ref()
    }
    /// <p>The text of the event.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>The date and time when the event occurred.</p>
    pub fn date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.date.as_ref()
    }
}
impl std::fmt::Debug for Event {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Event");
        formatter.field("source_name", &self.source_name);
        formatter.field("source_type", &self.source_type);
        formatter.field("message", &self.message);
        formatter.field("date", &self.date);
        formatter.finish()
    }
}
/// See [`Event`](crate::model::Event)
pub mod event {
    /// A builder for [`Event`](crate::model::Event)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_name: std::option::Option<std::string::String>,
        pub(crate) source_type: std::option::Option<crate::model::SourceType>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) date: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The name for the source of the event. For example, if the event occurred at the cluster level, the identifier would be the name of the cluster.</p>
        pub fn source_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_name = Some(input.into());
            self
        }
        /// <p>The name for the source of the event. For example, if the event occurred at the cluster level, the identifier would be the name of the cluster.</p>
        pub fn set_source_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_name = input;
            self
        }
        /// <p>Specifies the origin of this event - a cluster, a parameter group, a security group, etc.</p>
        pub fn source_type(mut self, input: crate::model::SourceType) -> Self {
            self.source_type = Some(input);
            self
        }
        /// <p>Specifies the origin of this event - a cluster, a parameter group, a security group, etc.</p>
        pub fn set_source_type(
            mut self,
            input: std::option::Option<crate::model::SourceType>,
        ) -> Self {
            self.source_type = input;
            self
        }
        /// <p>The text of the event.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The text of the event.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The date and time when the event occurred.</p>
        pub fn date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.date = Some(input);
            self
        }
        /// <p>The date and time when the event occurred.</p>
        pub fn set_date(mut self, input: std::option::Option<aws_smithy_types::Instant>) -> Self {
            self.date = input;
            self
        }
        /// Consumes the builder and constructs a [`Event`](crate::model::Event)
        pub fn build(self) -> crate::model::Event {
            crate::model::Event {
                source_name: self.source_name,
                source_type: self.source_type,
                message: self.message,
                date: self.date,
            }
        }
    }
}
impl Event {
    /// Creates a new builder-style object to manufacture [`Event`](crate::model::Event)
    pub fn builder() -> crate::model::event::Builder {
        crate::model::event::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SourceType {
    #[allow(missing_docs)] // documentation missing in model
    Acl,
    #[allow(missing_docs)] // documentation missing in model
    Cluster,
    #[allow(missing_docs)] // documentation missing in model
    Node,
    #[allow(missing_docs)] // documentation missing in model
    ParameterGroup,
    #[allow(missing_docs)] // documentation missing in model
    SubnetGroup,
    #[allow(missing_docs)] // documentation missing in model
    User,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SourceType {
    fn from(s: &str) -> Self {
        match s {
            "acl" => SourceType::Acl,
            "cluster" => SourceType::Cluster,
            "node" => SourceType::Node,
            "parameter-group" => SourceType::ParameterGroup,
            "subnet-group" => SourceType::SubnetGroup,
            "user" => SourceType::User,
            other => SourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SourceType::from(s))
    }
}
impl SourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SourceType::Acl => "acl",
            SourceType::Cluster => "cluster",
            SourceType::Node => "node",
            SourceType::ParameterGroup => "parameter-group",
            SourceType::SubnetGroup => "subnet-group",
            SourceType::User => "user",
            SourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "acl",
            "cluster",
            "node",
            "parameter-group",
            "subnet-group",
            "user",
        ]
    }
}
impl AsRef<str> for SourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides details of the Redis engine version</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EngineVersionInfo {
    /// <p>The engine version</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>The patched engine version</p>
    pub engine_patch_version: std::option::Option<std::string::String>,
    /// <p>Specifies the name of the parameter group family to which the engine default parameters apply.</p>
    pub parameter_group_family: std::option::Option<std::string::String>,
}
impl EngineVersionInfo {
    /// <p>The engine version</p>
    pub fn engine_version(&self) -> std::option::Option<&str> {
        self.engine_version.as_deref()
    }
    /// <p>The patched engine version</p>
    pub fn engine_patch_version(&self) -> std::option::Option<&str> {
        self.engine_patch_version.as_deref()
    }
    /// <p>Specifies the name of the parameter group family to which the engine default parameters apply.</p>
    pub fn parameter_group_family(&self) -> std::option::Option<&str> {
        self.parameter_group_family.as_deref()
    }
}
impl std::fmt::Debug for EngineVersionInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EngineVersionInfo");
        formatter.field("engine_version", &self.engine_version);
        formatter.field("engine_patch_version", &self.engine_patch_version);
        formatter.field("parameter_group_family", &self.parameter_group_family);
        formatter.finish()
    }
}
/// See [`EngineVersionInfo`](crate::model::EngineVersionInfo)
pub mod engine_version_info {
    /// A builder for [`EngineVersionInfo`](crate::model::EngineVersionInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) engine_patch_version: std::option::Option<std::string::String>,
        pub(crate) parameter_group_family: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The engine version</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The engine version</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>The patched engine version</p>
        pub fn engine_patch_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_patch_version = Some(input.into());
            self
        }
        /// <p>The patched engine version</p>
        pub fn set_engine_patch_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_patch_version = input;
            self
        }
        /// <p>Specifies the name of the parameter group family to which the engine default parameters apply.</p>
        pub fn parameter_group_family(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_group_family = Some(input.into());
            self
        }
        /// <p>Specifies the name of the parameter group family to which the engine default parameters apply.</p>
        pub fn set_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_group_family = input;
            self
        }
        /// Consumes the builder and constructs a [`EngineVersionInfo`](crate::model::EngineVersionInfo)
        pub fn build(self) -> crate::model::EngineVersionInfo {
            crate::model::EngineVersionInfo {
                engine_version: self.engine_version,
                engine_patch_version: self.engine_patch_version,
                parameter_group_family: self.parameter_group_family,
            }
        }
    }
}
impl EngineVersionInfo {
    /// Creates a new builder-style object to manufacture [`EngineVersionInfo`](crate::model::EngineVersionInfo)
    pub fn builder() -> crate::model::engine_version_info::Builder {
        crate::model::engine_version_info::Builder::default()
    }
}

/// <p>A cluster whose updates have failed</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnprocessedCluster {
    /// <p>The name of the cluster</p>
    pub cluster_name: std::option::Option<std::string::String>,
    /// <p>The error type associated with the update failure</p>
    pub error_type: std::option::Option<std::string::String>,
    /// <p>The error message associated with the update failure</p>
    pub error_message: std::option::Option<std::string::String>,
}
impl UnprocessedCluster {
    /// <p>The name of the cluster</p>
    pub fn cluster_name(&self) -> std::option::Option<&str> {
        self.cluster_name.as_deref()
    }
    /// <p>The error type associated with the update failure</p>
    pub fn error_type(&self) -> std::option::Option<&str> {
        self.error_type.as_deref()
    }
    /// <p>The error message associated with the update failure</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
}
impl std::fmt::Debug for UnprocessedCluster {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnprocessedCluster");
        formatter.field("cluster_name", &self.cluster_name);
        formatter.field("error_type", &self.error_type);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`UnprocessedCluster`](crate::model::UnprocessedCluster)
pub mod unprocessed_cluster {
    /// A builder for [`UnprocessedCluster`](crate::model::UnprocessedCluster)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_name: std::option::Option<std::string::String>,
        pub(crate) error_type: std::option::Option<std::string::String>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the cluster</p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_name = Some(input.into());
            self
        }
        /// <p>The name of the cluster</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_name = input;
            self
        }
        /// <p>The error type associated with the update failure</p>
        pub fn error_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_type = Some(input.into());
            self
        }
        /// <p>The error type associated with the update failure</p>
        pub fn set_error_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_type = input;
            self
        }
        /// <p>The error message associated with the update failure</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>The error message associated with the update failure</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnprocessedCluster`](crate::model::UnprocessedCluster)
        pub fn build(self) -> crate::model::UnprocessedCluster {
            crate::model::UnprocessedCluster {
                cluster_name: self.cluster_name,
                error_type: self.error_type,
                error_message: self.error_message,
            }
        }
    }
}
impl UnprocessedCluster {
    /// Creates a new builder-style object to manufacture [`UnprocessedCluster`](crate::model::UnprocessedCluster)
    pub fn builder() -> crate::model::unprocessed_cluster::Builder {
        crate::model::unprocessed_cluster::Builder::default()
    }
}

/// <p>A request to apply a service update</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceUpdateRequest {
    /// <p>The unique ID of the service update</p>
    pub service_update_name_to_apply: std::option::Option<std::string::String>,
}
impl ServiceUpdateRequest {
    /// <p>The unique ID of the service update</p>
    pub fn service_update_name_to_apply(&self) -> std::option::Option<&str> {
        self.service_update_name_to_apply.as_deref()
    }
}
impl std::fmt::Debug for ServiceUpdateRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceUpdateRequest");
        formatter.field(
            "service_update_name_to_apply",
            &self.service_update_name_to_apply,
        );
        formatter.finish()
    }
}
/// See [`ServiceUpdateRequest`](crate::model::ServiceUpdateRequest)
pub mod service_update_request {
    /// A builder for [`ServiceUpdateRequest`](crate::model::ServiceUpdateRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_update_name_to_apply: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID of the service update</p>
        pub fn service_update_name_to_apply(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.service_update_name_to_apply = Some(input.into());
            self
        }
        /// <p>The unique ID of the service update</p>
        pub fn set_service_update_name_to_apply(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_update_name_to_apply = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceUpdateRequest`](crate::model::ServiceUpdateRequest)
        pub fn build(self) -> crate::model::ServiceUpdateRequest {
            crate::model::ServiceUpdateRequest {
                service_update_name_to_apply: self.service_update_name_to_apply,
            }
        }
    }
}
impl ServiceUpdateRequest {
    /// Creates a new builder-style object to manufacture [`ServiceUpdateRequest`](crate::model::ServiceUpdateRequest)
    pub fn builder() -> crate::model::service_update_request::Builder {
        crate::model::service_update_request::Builder::default()
    }
}
