// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`BatchUpdateClusterInput`](crate::input::BatchUpdateClusterInput)
pub mod batch_update_cluster_input {
    /// A builder for [`BatchUpdateClusterInput`](crate::input::BatchUpdateClusterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) service_update: std::option::Option<crate::model::ServiceUpdateRequest>,
    }
    impl Builder {
        /// Appends an item to `cluster_names`.
        ///
        /// To override the contents of this collection use [`set_cluster_names`](Self::set_cluster_names).
        ///
        /// <p>The cluster names to apply the updates.</p>
        pub fn cluster_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.cluster_names.unwrap_or_default();
            v.push(input.into());
            self.cluster_names = Some(v);
            self
        }
        /// <p>The cluster names to apply the updates.</p>
        pub fn set_cluster_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.cluster_names = input;
            self
        }
        /// <p>The unique ID of the service update</p>
        pub fn service_update(mut self, input: crate::model::ServiceUpdateRequest) -> Self {
            self.service_update = Some(input);
            self
        }
        /// <p>The unique ID of the service update</p>
        pub fn set_service_update(
            mut self,
            input: std::option::Option<crate::model::ServiceUpdateRequest>,
        ) -> Self {
            self.service_update = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchUpdateClusterInput`](crate::input::BatchUpdateClusterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchUpdateClusterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchUpdateClusterInput {
                cluster_names: self.cluster_names,
                service_update: self.service_update,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchUpdateClusterInputOperationOutputAlias = crate::operation::BatchUpdateCluster;
#[doc(hidden)]
pub type BatchUpdateClusterInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl BatchUpdateClusterInput {
    /// Consumes the builder and constructs an Operation<[`BatchUpdateCluster`](crate::operation::BatchUpdateCluster)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchUpdateCluster,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchUpdateClusterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchUpdateClusterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchUpdateClusterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonMemoryDB.BatchUpdateCluster",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_update_cluster(&self)
                .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchUpdateCluster::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchUpdateCluster",
            "memorydb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchUpdateClusterInput`](crate::input::BatchUpdateClusterInput)
    pub fn builder() -> crate::input::batch_update_cluster_input::Builder {
        crate::input::batch_update_cluster_input::Builder::default()
    }
}

/// See [`CopySnapshotInput`](crate::input::CopySnapshotInput)
pub mod copy_snapshot_input {
    /// A builder for [`CopySnapshotInput`](crate::input::CopySnapshotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_snapshot_name: std::option::Option<std::string::String>,
        pub(crate) target_snapshot_name: std::option::Option<std::string::String>,
        pub(crate) target_bucket: std::option::Option<std::string::String>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of an existing snapshot from which to make a copy.</p>
        pub fn source_snapshot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_snapshot_name = Some(input.into());
            self
        }
        /// <p>The name of an existing snapshot from which to make a copy.</p>
        pub fn set_source_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_snapshot_name = input;
            self
        }
        /// <p>A name for the snapshot copy. MemoryDB does not permit overwriting a snapshot, therefore this name must be unique within its context - MemoryDB or an Amazon S3 bucket if exporting.</p>
        pub fn target_snapshot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_snapshot_name = Some(input.into());
            self
        }
        /// <p>A name for the snapshot copy. MemoryDB does not permit overwriting a snapshot, therefore this name must be unique within its context - MemoryDB or an Amazon S3 bucket if exporting.</p>
        pub fn set_target_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_snapshot_name = input;
            self
        }
        /// <p>The Amazon S3 bucket to which the snapshot is exported. This parameter is used only when exporting a snapshot for external access.
        ///
        /// When using this parameter to export a snapshot, be sure MemoryDB has the needed permissions to this S3 bucket. For more information, see
        ///
        /// <a href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/snapshots-exporting.html">Step 2: Grant MemoryDB Access to Your Amazon S3 Bucket</a>.
        ///
        /// </p>
        pub fn target_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_bucket = Some(input.into());
            self
        }
        /// <p>The Amazon S3 bucket to which the snapshot is exported. This parameter is used only when exporting a snapshot for external access.
        ///
        /// When using this parameter to export a snapshot, be sure MemoryDB has the needed permissions to this S3 bucket. For more information, see
        ///
        /// <a href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/snapshots-exporting.html">Step 2: Grant MemoryDB Access to Your Amazon S3 Bucket</a>.
        ///
        /// </p>
        pub fn set_target_bucket(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_bucket = input;
            self
        }
        /// <p>The ID of the KMS key used to encrypt the target snapshot.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The ID of the KMS key used to encrypt the target snapshot.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CopySnapshotInput`](crate::input::CopySnapshotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CopySnapshotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CopySnapshotInput {
                source_snapshot_name: self.source_snapshot_name,
                target_snapshot_name: self.target_snapshot_name,
                target_bucket: self.target_bucket,
                kms_key_id: self.kms_key_id,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CopySnapshotInputOperationOutputAlias = crate::operation::CopySnapshot;
#[doc(hidden)]
pub type CopySnapshotInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CopySnapshotInput {
    /// Consumes the builder and constructs an Operation<[`CopySnapshot`](crate::operation::CopySnapshot)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CopySnapshot,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CopySnapshotInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CopySnapshotInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CopySnapshotInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonMemoryDB.CopySnapshot",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_copy_snapshot(&self)
            .map_err(|err| {
            aws_smithy_http::operation::BuildError::SerializationError(err.into())
        })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CopySnapshot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CopySnapshot",
            "memorydb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CopySnapshotInput`](crate::input::CopySnapshotInput)
    pub fn builder() -> crate::input::copy_snapshot_input::Builder {
        crate::input::copy_snapshot_input::Builder::default()
    }
}

/// See [`CreateAclInput`](crate::input::CreateAclInput)
pub mod create_acl_input {
    /// A builder for [`CreateAclInput`](crate::input::CreateAclInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) acl_name: std::option::Option<std::string::String>,
        pub(crate) user_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the Access Control List.</p>
        pub fn acl_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.acl_name = Some(input.into());
            self
        }
        /// <p>The name of the Access Control List.</p>
        pub fn set_acl_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.acl_name = input;
            self
        }
        /// Appends an item to `user_names`.
        ///
        /// To override the contents of this collection use [`set_user_names`](Self::set_user_names).
        ///
        /// <p>The list of users that belong to the Access Control List.</p>
        pub fn user_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.user_names.unwrap_or_default();
            v.push(input.into());
            self.user_names = Some(v);
            self
        }
        /// <p>The list of users that belong to the Access Control List.</p>
        pub fn set_user_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.user_names = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAclInput`](crate::input::CreateAclInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::CreateAclInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::CreateAclInput {
                acl_name: self.acl_name,
                user_names: self.user_names,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateAclInputOperationOutputAlias = crate::operation::CreateACL;
#[doc(hidden)]
pub type CreateAclInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateAclInput {
    /// Consumes the builder and constructs an Operation<[`CreateACL`](crate::operation::CreateACL)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateACL,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateAclInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateAclInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateAclInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonMemoryDB.CreateACL",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_acl(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::CreateACL::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "CreateACL",
                    "memorydb",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateAclInput`](crate::input::CreateAclInput)
    pub fn builder() -> crate::input::create_acl_input::Builder {
        crate::input::create_acl_input::Builder::default()
    }
}

/// See [`CreateClusterInput`](crate::input::CreateClusterInput)
pub mod create_cluster_input {
    /// A builder for [`CreateClusterInput`](crate::input::CreateClusterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_name: std::option::Option<std::string::String>,
        pub(crate) node_type: std::option::Option<std::string::String>,
        pub(crate) parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) num_shards: std::option::Option<i32>,
        pub(crate) num_replicas_per_shard: std::option::Option<i32>,
        pub(crate) subnet_group_name: std::option::Option<std::string::String>,
        pub(crate) security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) maintenance_window: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) sns_topic_arn: std::option::Option<std::string::String>,
        pub(crate) tls_enabled: std::option::Option<bool>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) snapshot_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) snapshot_name: std::option::Option<std::string::String>,
        pub(crate) snapshot_retention_limit: std::option::Option<i32>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) snapshot_window: std::option::Option<std::string::String>,
        pub(crate) acl_name: std::option::Option<std::string::String>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) auto_minor_version_upgrade: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the cluster. This value must be unique as it also serves as the cluster identifier.</p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_name = Some(input.into());
            self
        }
        /// <p>The name of the cluster. This value must be unique as it also serves as the cluster identifier.</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_name = input;
            self
        }
        /// <p>The compute and memory capacity of the nodes in the cluster.</p>
        pub fn node_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.node_type = Some(input.into());
            self
        }
        /// <p>The compute and memory capacity of the nodes in the cluster.</p>
        pub fn set_node_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.node_type = input;
            self
        }
        /// <p>The name of the parameter group associated with the cluster.</p>
        pub fn parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the parameter group associated with the cluster.</p>
        pub fn set_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_group_name = input;
            self
        }
        /// <p>An optional description of the cluster.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>An optional description of the cluster.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The number of shards the cluster will contain. The default value is 1. </p>
        pub fn num_shards(mut self, input: i32) -> Self {
            self.num_shards = Some(input);
            self
        }
        /// <p>The number of shards the cluster will contain. The default value is 1. </p>
        pub fn set_num_shards(mut self, input: std::option::Option<i32>) -> Self {
            self.num_shards = input;
            self
        }
        /// <p>The number of replicas to apply to each shard. The default value is 1. The maximum is 5. </p>
        pub fn num_replicas_per_shard(mut self, input: i32) -> Self {
            self.num_replicas_per_shard = Some(input);
            self
        }
        /// <p>The number of replicas to apply to each shard. The default value is 1. The maximum is 5. </p>
        pub fn set_num_replicas_per_shard(mut self, input: std::option::Option<i32>) -> Self {
            self.num_replicas_per_shard = input;
            self
        }
        /// <p>The name of the subnet group to be used for the cluster.</p>
        pub fn subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_group_name = Some(input.into());
            self
        }
        /// <p>The name of the subnet group to be used for the cluster.</p>
        pub fn set_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subnet_group_name = input;
            self
        }
        /// Appends an item to `security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>A list of security group names to associate with this cluster.</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.security_group_ids = Some(v);
            self
        }
        /// <p>A list of security group names to associate with this cluster.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_ids = input;
            self
        }
        /// <p>Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format <code>ddd:hh24:mi-ddd:hh24:mi</code> (24H Clock UTC). The minimum maintenance window is a 60 minute period.</p>
        pub fn maintenance_window(mut self, input: impl Into<std::string::String>) -> Self {
            self.maintenance_window = Some(input.into());
            self
        }
        /// <p>Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format <code>ddd:hh24:mi-ddd:hh24:mi</code> (24H Clock UTC). The minimum maintenance window is a 60 minute period.</p>
        pub fn set_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.maintenance_window = input;
            self
        }
        /// <p>The port number on which each of the nodes accepts connections.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The port number on which each of the nodes accepts connections.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which notifications are sent.</p>
        pub fn sns_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.sns_topic_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which notifications are sent.</p>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sns_topic_arn = input;
            self
        }
        /// <p>A flag to enable in-transit encryption on the cluster.</p>
        pub fn tls_enabled(mut self, input: bool) -> Self {
            self.tls_enabled = Some(input);
            self
        }
        /// <p>A flag to enable in-transit encryption on the cluster.</p>
        pub fn set_tls_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.tls_enabled = input;
            self
        }
        /// <p>The ID of the KMS key used to encrypt the cluster.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The ID of the KMS key used to encrypt the cluster.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// Appends an item to `snapshot_arns`.
        ///
        /// To override the contents of this collection use [`set_snapshot_arns`](Self::set_snapshot_arns).
        ///
        /// <p>A list of Amazon Resource Names (ARN) that uniquely identify the RDB snapshot files stored in Amazon S3. The snapshot files are used to populate the new cluster. The Amazon S3 object name in the ARN cannot contain any commas.</p>
        pub fn snapshot_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.snapshot_arns.unwrap_or_default();
            v.push(input.into());
            self.snapshot_arns = Some(v);
            self
        }
        /// <p>A list of Amazon Resource Names (ARN) that uniquely identify the RDB snapshot files stored in Amazon S3. The snapshot files are used to populate the new cluster. The Amazon S3 object name in the ARN cannot contain any commas.</p>
        pub fn set_snapshot_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.snapshot_arns = input;
            self
        }
        /// <p>The name of a snapshot from which to restore data into the new cluster. The snapshot status changes to restoring while the new cluster is being created.</p>
        pub fn snapshot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_name = Some(input.into());
            self
        }
        /// <p>The name of a snapshot from which to restore data into the new cluster. The snapshot status changes to restoring while the new cluster is being created.</p>
        pub fn set_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshot_name = input;
            self
        }
        /// <p>The number of days for which MemoryDB retains automatic snapshots before deleting them. For example, if you set SnapshotRetentionLimit to 5, a snapshot that was taken today is retained for 5 days before being deleted.</p>
        pub fn snapshot_retention_limit(mut self, input: i32) -> Self {
            self.snapshot_retention_limit = Some(input);
            self
        }
        /// <p>The number of days for which MemoryDB retains automatic snapshots before deleting them. For example, if you set SnapshotRetentionLimit to 5, a snapshot that was taken today is retained for 5 days before being deleted.</p>
        pub fn set_snapshot_retention_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.snapshot_retention_limit = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to be added to this resource. Tags are comma-separated key,value pairs (e.g. Key=myKey, Value=myKeyValue. You can include multiple tags as shown following: Key=myKey, Value=myKeyValue Key=mySecondKey, Value=mySecondKeyValue.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags to be added to this resource. Tags are comma-separated key,value pairs (e.g. Key=myKey, Value=myKeyValue. You can include multiple tags as shown following: Key=myKey, Value=myKeyValue Key=mySecondKey, Value=mySecondKeyValue.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The daily time range (in UTC) during which MemoryDB begins taking a daily snapshot of your shard.</p>
        ///
        /// <p>    Example: 05:00-09:00</p>
        ///
        /// <p>    If you do not specify this parameter, MemoryDB automatically chooses an appropriate time range.</p>
        pub fn snapshot_window(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_window = Some(input.into());
            self
        }
        /// <p>The daily time range (in UTC) during which MemoryDB begins taking a daily snapshot of your shard.</p>
        ///
        /// <p>    Example: 05:00-09:00</p>
        ///
        /// <p>    If you do not specify this parameter, MemoryDB automatically chooses an appropriate time range.</p>
        pub fn set_snapshot_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshot_window = input;
            self
        }
        /// <p>The name of the Access Control List to associate with the cluster.</p>
        pub fn acl_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.acl_name = Some(input.into());
            self
        }
        /// <p>The name of the Access Control List to associate with the cluster.</p>
        pub fn set_acl_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.acl_name = input;
            self
        }
        /// <p>The version number of the Redis engine to be used for the cluster.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The version number of the Redis engine to be used for the cluster.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>When set to true, the cluster will automatically receive minor engine version upgrades after launch.</p>
        pub fn auto_minor_version_upgrade(mut self, input: bool) -> Self {
            self.auto_minor_version_upgrade = Some(input);
            self
        }
        /// <p>When set to true, the cluster will automatically receive minor engine version upgrades after launch.</p>
        pub fn set_auto_minor_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_minor_version_upgrade = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateClusterInput`](crate::input::CreateClusterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateClusterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateClusterInput {
                cluster_name: self.cluster_name,
                node_type: self.node_type,
                parameter_group_name: self.parameter_group_name,
                description: self.description,
                num_shards: self.num_shards,
                num_replicas_per_shard: self.num_replicas_per_shard,
                subnet_group_name: self.subnet_group_name,
                security_group_ids: self.security_group_ids,
                maintenance_window: self.maintenance_window,
                port: self.port,
                sns_topic_arn: self.sns_topic_arn,
                tls_enabled: self.tls_enabled,
                kms_key_id: self.kms_key_id,
                snapshot_arns: self.snapshot_arns,
                snapshot_name: self.snapshot_name,
                snapshot_retention_limit: self.snapshot_retention_limit,
                tags: self.tags,
                snapshot_window: self.snapshot_window,
                acl_name: self.acl_name,
                engine_version: self.engine_version,
                auto_minor_version_upgrade: self.auto_minor_version_upgrade,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateClusterInputOperationOutputAlias = crate::operation::CreateCluster;
#[doc(hidden)]
pub type CreateClusterInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateClusterInput {
    /// Consumes the builder and constructs an Operation<[`CreateCluster`](crate::operation::CreateCluster)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateCluster,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateClusterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateClusterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateClusterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonMemoryDB.CreateCluster",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_cluster(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateCluster::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateCluster",
            "memorydb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateClusterInput`](crate::input::CreateClusterInput)
    pub fn builder() -> crate::input::create_cluster_input::Builder {
        crate::input::create_cluster_input::Builder::default()
    }
}

/// See [`CreateParameterGroupInput`](crate::input::CreateParameterGroupInput)
pub mod create_parameter_group_input {
    /// A builder for [`CreateParameterGroupInput`](crate::input::CreateParameterGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) family: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the parameter group.</p>
        pub fn parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the parameter group.</p>
        pub fn set_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_group_name = input;
            self
        }
        /// <p>The name of the parameter group family that the parameter group can be used with.</p>
        pub fn family(mut self, input: impl Into<std::string::String>) -> Self {
            self.family = Some(input.into());
            self
        }
        /// <p>The name of the parameter group family that the parameter group can be used with.</p>
        pub fn set_family(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.family = input;
            self
        }
        /// <p>An optional description of the parameter group.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>An optional description of the parameter group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateParameterGroupInput`](crate::input::CreateParameterGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateParameterGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateParameterGroupInput {
                parameter_group_name: self.parameter_group_name,
                family: self.family,
                description: self.description,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateParameterGroupInputOperationOutputAlias = crate::operation::CreateParameterGroup;
#[doc(hidden)]
pub type CreateParameterGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateParameterGroupInput {
    /// Consumes the builder and constructs an Operation<[`CreateParameterGroup`](crate::operation::CreateParameterGroup)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateParameterGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateParameterGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateParameterGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateParameterGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonMemoryDB.CreateParameterGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_parameter_group(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateParameterGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateParameterGroup",
            "memorydb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateParameterGroupInput`](crate::input::CreateParameterGroupInput)
    pub fn builder() -> crate::input::create_parameter_group_input::Builder {
        crate::input::create_parameter_group_input::Builder::default()
    }
}

/// See [`CreateSnapshotInput`](crate::input::CreateSnapshotInput)
pub mod create_snapshot_input {
    /// A builder for [`CreateSnapshotInput`](crate::input::CreateSnapshotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_name: std::option::Option<std::string::String>,
        pub(crate) snapshot_name: std::option::Option<std::string::String>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The snapshot is created from this cluster.</p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_name = Some(input.into());
            self
        }
        /// <p>The snapshot is created from this cluster.</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_name = input;
            self
        }
        /// <p>A name for the snapshot being created.</p>
        pub fn snapshot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_name = Some(input.into());
            self
        }
        /// <p>A name for the snapshot being created.</p>
        pub fn set_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshot_name = input;
            self
        }
        /// <p>The ID of the KMS key used to encrypt the snapshot.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The ID of the KMS key used to encrypt the snapshot.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSnapshotInput`](crate::input::CreateSnapshotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateSnapshotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateSnapshotInput {
                cluster_name: self.cluster_name,
                snapshot_name: self.snapshot_name,
                kms_key_id: self.kms_key_id,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateSnapshotInputOperationOutputAlias = crate::operation::CreateSnapshot;
#[doc(hidden)]
pub type CreateSnapshotInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateSnapshotInput {
    /// Consumes the builder and constructs an Operation<[`CreateSnapshot`](crate::operation::CreateSnapshot)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateSnapshot,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateSnapshotInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateSnapshotInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateSnapshotInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonMemoryDB.CreateSnapshot",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_snapshot(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateSnapshot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateSnapshot",
            "memorydb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateSnapshotInput`](crate::input::CreateSnapshotInput)
    pub fn builder() -> crate::input::create_snapshot_input::Builder {
        crate::input::create_snapshot_input::Builder::default()
    }
}

/// See [`CreateSubnetGroupInput`](crate::input::CreateSubnetGroupInput)
pub mod create_subnet_group_input {
    /// A builder for [`CreateSubnetGroupInput`](crate::input::CreateSubnetGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subnet_group_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the subnet group.</p>
        pub fn subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_group_name = Some(input.into());
            self
        }
        /// <p>The name of the subnet group.</p>
        pub fn set_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subnet_group_name = input;
            self
        }
        /// <p>A description for the subnet group.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description for the subnet group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>A list of VPC subnet IDs for the subnet group.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>A list of VPC subnet IDs for the subnet group.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSubnetGroupInput`](crate::input::CreateSubnetGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateSubnetGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateSubnetGroupInput {
                subnet_group_name: self.subnet_group_name,
                description: self.description,
                subnet_ids: self.subnet_ids,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateSubnetGroupInputOperationOutputAlias = crate::operation::CreateSubnetGroup;
#[doc(hidden)]
pub type CreateSubnetGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateSubnetGroupInput {
    /// Consumes the builder and constructs an Operation<[`CreateSubnetGroup`](crate::operation::CreateSubnetGroup)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateSubnetGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateSubnetGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateSubnetGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateSubnetGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonMemoryDB.CreateSubnetGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_subnet_group(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateSubnetGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateSubnetGroup",
            "memorydb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateSubnetGroupInput`](crate::input::CreateSubnetGroupInput)
    pub fn builder() -> crate::input::create_subnet_group_input::Builder {
        crate::input::create_subnet_group_input::Builder::default()
    }
}

/// See [`CreateUserInput`](crate::input::CreateUserInput)
pub mod create_user_input {
    /// A builder for [`CreateUserInput`](crate::input::CreateUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) authentication_mode: std::option::Option<crate::model::AuthenticationMode>,
        pub(crate) access_string: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the user. This value must be unique as it also serves as the user identifier.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The name of the user. This value must be unique as it also serves as the user identifier.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>Denotes the user's authentication properties, such as whether it requires a password to authenticate.</p>
        pub fn authentication_mode(mut self, input: crate::model::AuthenticationMode) -> Self {
            self.authentication_mode = Some(input);
            self
        }
        /// <p>Denotes the user's authentication properties, such as whether it requires a password to authenticate.</p>
        pub fn set_authentication_mode(
            mut self,
            input: std::option::Option<crate::model::AuthenticationMode>,
        ) -> Self {
            self.authentication_mode = input;
            self
        }
        /// <p>Access permissions string used for this user.</p>
        pub fn access_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_string = Some(input.into());
            self
        }
        /// <p>Access permissions string used for this user.</p>
        pub fn set_access_string(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.access_string = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateUserInput`](crate::input::CreateUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateUserInput {
                user_name: self.user_name,
                authentication_mode: self.authentication_mode,
                access_string: self.access_string,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateUserInputOperationOutputAlias = crate::operation::CreateUser;
#[doc(hidden)]
pub type CreateUserInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateUserInput {
    /// Consumes the builder and constructs an Operation<[`CreateUser`](crate::operation::CreateUser)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateUser,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateUserInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateUserInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateUserInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonMemoryDB.CreateUser",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_user(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateUser",
            "memorydb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateUserInput`](crate::input::CreateUserInput)
    pub fn builder() -> crate::input::create_user_input::Builder {
        crate::input::create_user_input::Builder::default()
    }
}

/// See [`DeleteAclInput`](crate::input::DeleteAclInput)
pub mod delete_acl_input {
    /// A builder for [`DeleteAclInput`](crate::input::DeleteAclInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) acl_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Access Control List to delete</p>
        pub fn acl_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.acl_name = Some(input.into());
            self
        }
        /// <p>The name of the Access Control List to delete</p>
        pub fn set_acl_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.acl_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAclInput`](crate::input::DeleteAclInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::DeleteAclInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::DeleteAclInput {
                acl_name: self.acl_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAclInputOperationOutputAlias = crate::operation::DeleteACL;
#[doc(hidden)]
pub type DeleteAclInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteAclInput {
    /// Consumes the builder and constructs an Operation<[`DeleteACL`](crate::operation::DeleteACL)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteACL,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteAclInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteAclInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteAclInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonMemoryDB.DeleteACL",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_acl(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::DeleteACL::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "DeleteACL",
                    "memorydb",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteAclInput`](crate::input::DeleteAclInput)
    pub fn builder() -> crate::input::delete_acl_input::Builder {
        crate::input::delete_acl_input::Builder::default()
    }
}

/// See [`DeleteClusterInput`](crate::input::DeleteClusterInput)
pub mod delete_cluster_input {
    /// A builder for [`DeleteClusterInput`](crate::input::DeleteClusterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_name: std::option::Option<std::string::String>,
        pub(crate) final_snapshot_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the cluster to be deleted</p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_name = Some(input.into());
            self
        }
        /// <p>The name of the cluster to be deleted</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_name = input;
            self
        }
        /// <p>The user-supplied name of a final cluster snapshot. This is the unique name that identifies the snapshot. MemoryDB creates the snapshot, and then deletes the cluster immediately afterward.</p>
        pub fn final_snapshot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.final_snapshot_name = Some(input.into());
            self
        }
        /// <p>The user-supplied name of a final cluster snapshot. This is the unique name that identifies the snapshot. MemoryDB creates the snapshot, and then deletes the cluster immediately afterward.</p>
        pub fn set_final_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.final_snapshot_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteClusterInput`](crate::input::DeleteClusterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteClusterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteClusterInput {
                cluster_name: self.cluster_name,
                final_snapshot_name: self.final_snapshot_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteClusterInputOperationOutputAlias = crate::operation::DeleteCluster;
#[doc(hidden)]
pub type DeleteClusterInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteClusterInput {
    /// Consumes the builder and constructs an Operation<[`DeleteCluster`](crate::operation::DeleteCluster)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteCluster,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteClusterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteClusterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteClusterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonMemoryDB.DeleteCluster",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_cluster(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteCluster::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteCluster",
            "memorydb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteClusterInput`](crate::input::DeleteClusterInput)
    pub fn builder() -> crate::input::delete_cluster_input::Builder {
        crate::input::delete_cluster_input::Builder::default()
    }
}

/// See [`DeleteParameterGroupInput`](crate::input::DeleteParameterGroupInput)
pub mod delete_parameter_group_input {
    /// A builder for [`DeleteParameterGroupInput`](crate::input::DeleteParameterGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parameter_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the parameter group to delete.</p>
        pub fn parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the parameter group to delete.</p>
        pub fn set_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteParameterGroupInput`](crate::input::DeleteParameterGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteParameterGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteParameterGroupInput {
                parameter_group_name: self.parameter_group_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteParameterGroupInputOperationOutputAlias = crate::operation::DeleteParameterGroup;
#[doc(hidden)]
pub type DeleteParameterGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteParameterGroupInput {
    /// Consumes the builder and constructs an Operation<[`DeleteParameterGroup`](crate::operation::DeleteParameterGroup)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteParameterGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteParameterGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteParameterGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteParameterGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonMemoryDB.DeleteParameterGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_parameter_group(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteParameterGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteParameterGroup",
            "memorydb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteParameterGroupInput`](crate::input::DeleteParameterGroupInput)
    pub fn builder() -> crate::input::delete_parameter_group_input::Builder {
        crate::input::delete_parameter_group_input::Builder::default()
    }
}

/// See [`DeleteSnapshotInput`](crate::input::DeleteSnapshotInput)
pub mod delete_snapshot_input {
    /// A builder for [`DeleteSnapshotInput`](crate::input::DeleteSnapshotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) snapshot_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the snapshot to delete</p>
        pub fn snapshot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_name = Some(input.into());
            self
        }
        /// <p>The name of the snapshot to delete</p>
        pub fn set_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshot_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSnapshotInput`](crate::input::DeleteSnapshotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteSnapshotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteSnapshotInput {
                snapshot_name: self.snapshot_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteSnapshotInputOperationOutputAlias = crate::operation::DeleteSnapshot;
#[doc(hidden)]
pub type DeleteSnapshotInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteSnapshotInput {
    /// Consumes the builder and constructs an Operation<[`DeleteSnapshot`](crate::operation::DeleteSnapshot)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteSnapshot,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteSnapshotInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteSnapshotInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteSnapshotInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonMemoryDB.DeleteSnapshot",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_snapshot(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteSnapshot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteSnapshot",
            "memorydb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteSnapshotInput`](crate::input::DeleteSnapshotInput)
    pub fn builder() -> crate::input::delete_snapshot_input::Builder {
        crate::input::delete_snapshot_input::Builder::default()
    }
}

/// See [`DeleteSubnetGroupInput`](crate::input::DeleteSubnetGroupInput)
pub mod delete_subnet_group_input {
    /// A builder for [`DeleteSubnetGroupInput`](crate::input::DeleteSubnetGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subnet_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the subnet group to delete</p>
        pub fn subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_group_name = Some(input.into());
            self
        }
        /// <p>The name of the subnet group to delete</p>
        pub fn set_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subnet_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSubnetGroupInput`](crate::input::DeleteSubnetGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteSubnetGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteSubnetGroupInput {
                subnet_group_name: self.subnet_group_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteSubnetGroupInputOperationOutputAlias = crate::operation::DeleteSubnetGroup;
#[doc(hidden)]
pub type DeleteSubnetGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteSubnetGroupInput {
    /// Consumes the builder and constructs an Operation<[`DeleteSubnetGroup`](crate::operation::DeleteSubnetGroup)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteSubnetGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteSubnetGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteSubnetGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteSubnetGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonMemoryDB.DeleteSubnetGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_subnet_group(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteSubnetGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteSubnetGroup",
            "memorydb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteSubnetGroupInput`](crate::input::DeleteSubnetGroupInput)
    pub fn builder() -> crate::input::delete_subnet_group_input::Builder {
        crate::input::delete_subnet_group_input::Builder::default()
    }
}

/// See [`DeleteUserInput`](crate::input::DeleteUserInput)
pub mod delete_user_input {
    /// A builder for [`DeleteUserInput`](crate::input::DeleteUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the user to delete</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The name of the user to delete</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteUserInput`](crate::input::DeleteUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteUserInput {
                user_name: self.user_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteUserInputOperationOutputAlias = crate::operation::DeleteUser;
#[doc(hidden)]
pub type DeleteUserInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteUserInput {
    /// Consumes the builder and constructs an Operation<[`DeleteUser`](crate::operation::DeleteUser)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteUser,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteUserInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteUserInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteUserInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonMemoryDB.DeleteUser",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_user(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteUser",
            "memorydb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteUserInput`](crate::input::DeleteUserInput)
    pub fn builder() -> crate::input::delete_user_input::Builder {
        crate::input::delete_user_input::Builder::default()
    }
}

/// See [`DescribeAcLsInput`](crate::input::DescribeAcLsInput)
pub mod describe_ac_ls_input {
    /// A builder for [`DescribeAcLsInput`](crate::input::DescribeAcLsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) acl_name: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the ACL</p>
        pub fn acl_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.acl_name = Some(input.into());
            self
        }
        /// <p>The name of the ACL</p>
        pub fn set_acl_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.acl_name = input;
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAcLsInput`](crate::input::DescribeAcLsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAcLsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAcLsInput {
                acl_name: self.acl_name,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAcLsInputOperationOutputAlias = crate::operation::DescribeACLs;
#[doc(hidden)]
pub type DescribeAcLsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeAcLsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeACLs`](crate::operation::DescribeACLs)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeACLs,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeAcLsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeAcLsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeAcLsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonMemoryDB.DescribeACLs",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_describe_ac_ls(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeACLs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeACLs",
            "memorydb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeAcLsInput`](crate::input::DescribeAcLsInput)
    pub fn builder() -> crate::input::describe_ac_ls_input::Builder {
        crate::input::describe_ac_ls_input::Builder::default()
    }
}

/// See [`DescribeClustersInput`](crate::input::DescribeClustersInput)
pub mod describe_clusters_input {
    /// A builder for [`DescribeClustersInput`](crate::input::DescribeClustersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_name: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) show_shard_details: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the cluster</p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_name = Some(input.into());
            self
        }
        /// <p>The name of the cluster</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_name = input;
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>An optional flag that can be included in the request to retrieve information about the individual shard(s).</p>
        pub fn show_shard_details(mut self, input: bool) -> Self {
            self.show_shard_details = Some(input);
            self
        }
        /// <p>An optional flag that can be included in the request to retrieve information about the individual shard(s).</p>
        pub fn set_show_shard_details(mut self, input: std::option::Option<bool>) -> Self {
            self.show_shard_details = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeClustersInput`](crate::input::DescribeClustersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeClustersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeClustersInput {
                cluster_name: self.cluster_name,
                max_results: self.max_results,
                next_token: self.next_token,
                show_shard_details: self.show_shard_details,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeClustersInputOperationOutputAlias = crate::operation::DescribeClusters;
#[doc(hidden)]
pub type DescribeClustersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeClustersInput {
    /// Consumes the builder and constructs an Operation<[`DescribeClusters`](crate::operation::DescribeClusters)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeClusters,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeClustersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeClustersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeClustersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonMemoryDB.DescribeClusters",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_clusters(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeClusters::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeClusters",
            "memorydb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeClustersInput`](crate::input::DescribeClustersInput)
    pub fn builder() -> crate::input::describe_clusters_input::Builder {
        crate::input::describe_clusters_input::Builder::default()
    }
}

/// See [`DescribeEngineVersionsInput`](crate::input::DescribeEngineVersionsInput)
pub mod describe_engine_versions_input {
    /// A builder for [`DescribeEngineVersionsInput`](crate::input::DescribeEngineVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) parameter_group_family: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) default_only: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The Redis engine version</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The Redis engine version</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>The name of a specific parameter group family to return details for.</p>
        pub fn parameter_group_family(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_group_family = Some(input.into());
            self
        }
        /// <p>The name of a specific parameter group family to return details for.</p>
        pub fn set_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_group_family = input;
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>If true, specifies that only the default version of the specified engine or engine and major version combination is to be returned.</p>
        pub fn default_only(mut self, input: bool) -> Self {
            self.default_only = Some(input);
            self
        }
        /// <p>If true, specifies that only the default version of the specified engine or engine and major version combination is to be returned.</p>
        pub fn set_default_only(mut self, input: std::option::Option<bool>) -> Self {
            self.default_only = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEngineVersionsInput`](crate::input::DescribeEngineVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEngineVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEngineVersionsInput {
                engine_version: self.engine_version,
                parameter_group_family: self.parameter_group_family,
                max_results: self.max_results,
                next_token: self.next_token,
                default_only: self.default_only.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeEngineVersionsInputOperationOutputAlias = crate::operation::DescribeEngineVersions;
#[doc(hidden)]
pub type DescribeEngineVersionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeEngineVersionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEngineVersions`](crate::operation::DescribeEngineVersions)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEngineVersions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeEngineVersionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeEngineVersionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeEngineVersionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonMemoryDB.DescribeEngineVersions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_engine_versions(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEngineVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEngineVersions",
            "memorydb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeEngineVersionsInput`](crate::input::DescribeEngineVersionsInput)
    pub fn builder() -> crate::input::describe_engine_versions_input::Builder {
        crate::input::describe_engine_versions_input::Builder::default()
    }
}

/// See [`DescribeEventsInput`](crate::input::DescribeEventsInput)
pub mod describe_events_input {
    /// A builder for [`DescribeEventsInput`](crate::input::DescribeEventsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_name: std::option::Option<std::string::String>,
        pub(crate) source_type: std::option::Option<crate::model::SourceType>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) duration: std::option::Option<i32>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the event source for which events are returned. If not specified, all sources are included in the response.</p>
        pub fn source_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_name = Some(input.into());
            self
        }
        /// <p>The identifier of the event source for which events are returned. If not specified, all sources are included in the response.</p>
        pub fn set_source_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_name = input;
            self
        }
        /// <p>The event source to retrieve events for. If no value is specified, all events are returned.</p>
        pub fn source_type(mut self, input: crate::model::SourceType) -> Self {
            self.source_type = Some(input);
            self
        }
        /// <p>The event source to retrieve events for. If no value is specified, all events are returned.</p>
        pub fn set_source_type(
            mut self,
            input: std::option::Option<crate::model::SourceType>,
        ) -> Self {
            self.source_type = input;
            self
        }
        /// <p>The beginning of the time interval to retrieve events for, specified in ISO 8601 format.
        ///
        /// Example: 2017-03-30T07:03:49.555Z</p>
        pub fn start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The beginning of the time interval to retrieve events for, specified in ISO 8601 format.
        ///
        /// Example: 2017-03-30T07:03:49.555Z</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The end of the time interval for which to retrieve events, specified in ISO 8601 format.
        ///
        /// Example: 2017-03-30T07:03:49.555Z</p>
        pub fn end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The end of the time interval for which to retrieve events, specified in ISO 8601 format.
        ///
        /// Example: 2017-03-30T07:03:49.555Z</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The number of minutes worth of events to retrieve.</p>
        pub fn duration(mut self, input: i32) -> Self {
            self.duration = Some(input);
            self
        }
        /// <p>The number of minutes worth of events to retrieve.</p>
        pub fn set_duration(mut self, input: std::option::Option<i32>) -> Self {
            self.duration = input;
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEventsInput`](crate::input::DescribeEventsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEventsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEventsInput {
                source_name: self.source_name,
                source_type: self.source_type,
                start_time: self.start_time,
                end_time: self.end_time,
                duration: self.duration,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeEventsInputOperationOutputAlias = crate::operation::DescribeEvents;
#[doc(hidden)]
pub type DescribeEventsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeEventsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEvents`](crate::operation::DescribeEvents)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEvents,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeEventsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeEventsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeEventsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonMemoryDB.DescribeEvents",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_describe_events(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEvents::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEvents",
            "memorydb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeEventsInput`](crate::input::DescribeEventsInput)
    pub fn builder() -> crate::input::describe_events_input::Builder {
        crate::input::describe_events_input::Builder::default()
    }
}

/// See [`DescribeParameterGroupsInput`](crate::input::DescribeParameterGroupsInput)
pub mod describe_parameter_groups_input {
    /// A builder for [`DescribeParameterGroupsInput`](crate::input::DescribeParameterGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of a specific  parameter group to return details for.</p>
        pub fn parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of a specific  parameter group to return details for.</p>
        pub fn set_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_group_name = input;
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeParameterGroupsInput`](crate::input::DescribeParameterGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeParameterGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeParameterGroupsInput {
                parameter_group_name: self.parameter_group_name,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeParameterGroupsInputOperationOutputAlias =
    crate::operation::DescribeParameterGroups;
#[doc(hidden)]
pub type DescribeParameterGroupsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeParameterGroupsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeParameterGroups`](crate::operation::DescribeParameterGroups)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeParameterGroups,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeParameterGroupsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeParameterGroupsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeParameterGroupsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonMemoryDB.DescribeParameterGroups",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_parameter_groups(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeParameterGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeParameterGroups",
            "memorydb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeParameterGroupsInput`](crate::input::DescribeParameterGroupsInput)
    pub fn builder() -> crate::input::describe_parameter_groups_input::Builder {
        crate::input::describe_parameter_groups_input::Builder::default()
    }
}

/// See [`DescribeParametersInput`](crate::input::DescribeParametersInput)
pub mod describe_parameters_input {
    /// A builder for [`DescribeParametersInput`](crate::input::DescribeParametersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>he name of a specific  parameter group to return details for.</p>
        pub fn parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_group_name = Some(input.into());
            self
        }
        /// <p>he name of a specific  parameter group to return details for.</p>
        pub fn set_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_group_name = input;
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeParametersInput`](crate::input::DescribeParametersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeParametersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeParametersInput {
                parameter_group_name: self.parameter_group_name,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeParametersInputOperationOutputAlias = crate::operation::DescribeParameters;
#[doc(hidden)]
pub type DescribeParametersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeParametersInput {
    /// Consumes the builder and constructs an Operation<[`DescribeParameters`](crate::operation::DescribeParameters)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeParameters,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeParametersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeParametersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeParametersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonMemoryDB.DescribeParameters",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_parameters(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeParameters::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeParameters",
            "memorydb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeParametersInput`](crate::input::DescribeParametersInput)
    pub fn builder() -> crate::input::describe_parameters_input::Builder {
        crate::input::describe_parameters_input::Builder::default()
    }
}

/// See [`DescribeServiceUpdatesInput`](crate::input::DescribeServiceUpdatesInput)
pub mod describe_service_updates_input {
    /// A builder for [`DescribeServiceUpdatesInput`](crate::input::DescribeServiceUpdatesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_update_name: std::option::Option<std::string::String>,
        pub(crate) cluster_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) status: std::option::Option<std::vec::Vec<crate::model::ServiceUpdateStatus>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID of the service update to describe.</p>
        pub fn service_update_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_update_name = Some(input.into());
            self
        }
        /// <p>The unique ID of the service update to describe.</p>
        pub fn set_service_update_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_update_name = input;
            self
        }
        /// Appends an item to `cluster_names`.
        ///
        /// To override the contents of this collection use [`set_cluster_names`](Self::set_cluster_names).
        ///
        /// <p>The list of cluster names to identify service updates to apply</p>
        pub fn cluster_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.cluster_names.unwrap_or_default();
            v.push(input.into());
            self.cluster_names = Some(v);
            self
        }
        /// <p>The list of cluster names to identify service updates to apply</p>
        pub fn set_cluster_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.cluster_names = input;
            self
        }
        /// Appends an item to `status`.
        ///
        /// To override the contents of this collection use [`set_status`](Self::set_status).
        ///
        /// <p>The status(es) of the service updates to filter on</p>
        pub fn status(mut self, input: impl Into<crate::model::ServiceUpdateStatus>) -> Self {
            let mut v = self.status.unwrap_or_default();
            v.push(input.into());
            self.status = Some(v);
            self
        }
        /// <p>The status(es) of the service updates to filter on</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ServiceUpdateStatus>>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeServiceUpdatesInput`](crate::input::DescribeServiceUpdatesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeServiceUpdatesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeServiceUpdatesInput {
                service_update_name: self.service_update_name,
                cluster_names: self.cluster_names,
                status: self.status,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeServiceUpdatesInputOperationOutputAlias = crate::operation::DescribeServiceUpdates;
#[doc(hidden)]
pub type DescribeServiceUpdatesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeServiceUpdatesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeServiceUpdates`](crate::operation::DescribeServiceUpdates)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeServiceUpdates,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeServiceUpdatesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeServiceUpdatesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeServiceUpdatesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonMemoryDB.DescribeServiceUpdates",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_service_updates(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeServiceUpdates::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeServiceUpdates",
            "memorydb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeServiceUpdatesInput`](crate::input::DescribeServiceUpdatesInput)
    pub fn builder() -> crate::input::describe_service_updates_input::Builder {
        crate::input::describe_service_updates_input::Builder::default()
    }
}

/// See [`DescribeSnapshotsInput`](crate::input::DescribeSnapshotsInput)
pub mod describe_snapshots_input {
    /// A builder for [`DescribeSnapshotsInput`](crate::input::DescribeSnapshotsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_name: std::option::Option<std::string::String>,
        pub(crate) snapshot_name: std::option::Option<std::string::String>,
        pub(crate) source: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) show_detail: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>A user-supplied cluster identifier. If this parameter is specified, only snapshots associated with that specific cluster are described.</p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_name = Some(input.into());
            self
        }
        /// <p>A user-supplied cluster identifier. If this parameter is specified, only snapshots associated with that specific cluster are described.</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_name = input;
            self
        }
        /// <p>A user-supplied name of the snapshot. If this parameter is specified, only this named snapshot is described.</p>
        pub fn snapshot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_name = Some(input.into());
            self
        }
        /// <p>A user-supplied name of the snapshot. If this parameter is specified, only this named snapshot is described.</p>
        pub fn set_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshot_name = input;
            self
        }
        /// <p>If set to system, the output shows snapshots that were automatically created by MemoryDB. If set to user the output shows snapshots that were manually created. If omitted, the output shows both automatically and manually created snapshots.</p>
        pub fn source(mut self, input: impl Into<std::string::String>) -> Self {
            self.source = Some(input.into());
            self
        }
        /// <p>If set to system, the output shows snapshots that were automatically created by MemoryDB. If set to user the output shows snapshots that were manually created. If omitted, the output shows both automatically and manually created snapshots.</p>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source = input;
            self
        }
        /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>A Boolean value which if true, the shard configuration is included in the snapshot description.</p>
        pub fn show_detail(mut self, input: bool) -> Self {
            self.show_detail = Some(input);
            self
        }
        /// <p>A Boolean value which if true, the shard configuration is included in the snapshot description.</p>
        pub fn set_show_detail(mut self, input: std::option::Option<bool>) -> Self {
            self.show_detail = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSnapshotsInput`](crate::input::DescribeSnapshotsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeSnapshotsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeSnapshotsInput {
                cluster_name: self.cluster_name,
                snapshot_name: self.snapshot_name,
                source: self.source,
                next_token: self.next_token,
                max_results: self.max_results,
                show_detail: self.show_detail,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeSnapshotsInputOperationOutputAlias = crate::operation::DescribeSnapshots;
#[doc(hidden)]
pub type DescribeSnapshotsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeSnapshotsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeSnapshots`](crate::operation::DescribeSnapshots)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeSnapshots,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeSnapshotsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeSnapshotsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeSnapshotsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonMemoryDB.DescribeSnapshots",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_snapshots(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeSnapshots::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeSnapshots",
            "memorydb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeSnapshotsInput`](crate::input::DescribeSnapshotsInput)
    pub fn builder() -> crate::input::describe_snapshots_input::Builder {
        crate::input::describe_snapshots_input::Builder::default()
    }
}

/// See [`DescribeSubnetGroupsInput`](crate::input::DescribeSubnetGroupsInput)
pub mod describe_subnet_groups_input {
    /// A builder for [`DescribeSubnetGroupsInput`](crate::input::DescribeSubnetGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subnet_group_name: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the subnet group to return details for.</p>
        pub fn subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_group_name = Some(input.into());
            self
        }
        /// <p>The name of the subnet group to return details for.</p>
        pub fn set_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subnet_group_name = input;
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSubnetGroupsInput`](crate::input::DescribeSubnetGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeSubnetGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeSubnetGroupsInput {
                subnet_group_name: self.subnet_group_name,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeSubnetGroupsInputOperationOutputAlias = crate::operation::DescribeSubnetGroups;
#[doc(hidden)]
pub type DescribeSubnetGroupsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeSubnetGroupsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeSubnetGroups`](crate::operation::DescribeSubnetGroups)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeSubnetGroups,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeSubnetGroupsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeSubnetGroupsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeSubnetGroupsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonMemoryDB.DescribeSubnetGroups",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_subnet_groups(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeSubnetGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeSubnetGroups",
            "memorydb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeSubnetGroupsInput`](crate::input::DescribeSubnetGroupsInput)
    pub fn builder() -> crate::input::describe_subnet_groups_input::Builder {
        crate::input::describe_subnet_groups_input::Builder::default()
    }
}

/// See [`DescribeUsersInput`](crate::input::DescribeUsersInput)
pub mod describe_users_input {
    /// A builder for [`DescribeUsersInput`](crate::input::DescribeUsersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the user</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The name of the user</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filter to determine the list of users to return.</p>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>Filter to determine the list of users to return.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeUsersInput`](crate::input::DescribeUsersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeUsersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeUsersInput {
                user_name: self.user_name,
                filters: self.filters,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeUsersInputOperationOutputAlias = crate::operation::DescribeUsers;
#[doc(hidden)]
pub type DescribeUsersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeUsersInput {
    /// Consumes the builder and constructs an Operation<[`DescribeUsers`](crate::operation::DescribeUsers)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeUsers,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeUsersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeUsersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeUsersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonMemoryDB.DescribeUsers",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_describe_users(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeUsers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeUsers",
            "memorydb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeUsersInput`](crate::input::DescribeUsersInput)
    pub fn builder() -> crate::input::describe_users_input::Builder {
        crate::input::describe_users_input::Builder::default()
    }
}

/// See [`FailoverShardInput`](crate::input::FailoverShardInput)
pub mod failover_shard_input {
    /// A builder for [`FailoverShardInput`](crate::input::FailoverShardInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_name: std::option::Option<std::string::String>,
        pub(crate) shard_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The cluster being failed over</p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_name = Some(input.into());
            self
        }
        /// <p>The cluster being failed over</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_name = input;
            self
        }
        /// <p>The name of the shard</p>
        pub fn shard_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.shard_name = Some(input.into());
            self
        }
        /// <p>The name of the shard</p>
        pub fn set_shard_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.shard_name = input;
            self
        }
        /// Consumes the builder and constructs a [`FailoverShardInput`](crate::input::FailoverShardInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::FailoverShardInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::FailoverShardInput {
                cluster_name: self.cluster_name,
                shard_name: self.shard_name,
            })
        }
    }
}
#[doc(hidden)]
pub type FailoverShardInputOperationOutputAlias = crate::operation::FailoverShard;
#[doc(hidden)]
pub type FailoverShardInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl FailoverShardInput {
    /// Consumes the builder and constructs an Operation<[`FailoverShard`](crate::operation::FailoverShard)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::FailoverShard,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::FailoverShardInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::FailoverShardInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::FailoverShardInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonMemoryDB.FailoverShard",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_failover_shard(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::FailoverShard::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "FailoverShard",
            "memorydb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`FailoverShardInput`](crate::input::FailoverShardInput)
    pub fn builder() -> crate::input::failover_shard_input::Builder {
        crate::input::failover_shard_input::Builder::default()
    }
}

/// See [`ListAllowedNodeTypeUpdatesInput`](crate::input::ListAllowedNodeTypeUpdatesInput)
pub mod list_allowed_node_type_updates_input {
    /// A builder for [`ListAllowedNodeTypeUpdatesInput`](crate::input::ListAllowedNodeTypeUpdatesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the cluster you want to scale. MemoryDB uses the cluster name to identify the current node type being used by this cluster, and from that to create a list of node types
        /// you can scale up to.</p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_name = Some(input.into());
            self
        }
        /// <p>The name of the cluster you want to scale. MemoryDB uses the cluster name to identify the current node type being used by this cluster, and from that to create a list of node types
        /// you can scale up to.</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAllowedNodeTypeUpdatesInput`](crate::input::ListAllowedNodeTypeUpdatesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAllowedNodeTypeUpdatesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAllowedNodeTypeUpdatesInput {
                cluster_name: self.cluster_name,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAllowedNodeTypeUpdatesInputOperationOutputAlias =
    crate::operation::ListAllowedNodeTypeUpdates;
#[doc(hidden)]
pub type ListAllowedNodeTypeUpdatesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListAllowedNodeTypeUpdatesInput {
    /// Consumes the builder and constructs an Operation<[`ListAllowedNodeTypeUpdates`](crate::operation::ListAllowedNodeTypeUpdates)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAllowedNodeTypeUpdates,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAllowedNodeTypeUpdatesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAllowedNodeTypeUpdatesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAllowedNodeTypeUpdatesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonMemoryDB.ListAllowedNodeTypeUpdates",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_allowed_node_type_updates(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAllowedNodeTypeUpdates::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAllowedNodeTypeUpdates",
            "memorydb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAllowedNodeTypeUpdatesInput`](crate::input::ListAllowedNodeTypeUpdatesInput)
    pub fn builder() -> crate::input::list_allowed_node_type_updates_input::Builder {
        crate::input::list_allowed_node_type_updates_input::Builder::default()
    }
}

/// See [`ListTagsInput`](crate::input::ListTagsInput)
pub mod list_tags_input {
    /// A builder for [`ListTagsInput`](crate::input::ListTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource for which you want the list of tags</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource for which you want the list of tags</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsInput`](crate::input::ListTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListTagsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListTagsInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsInputOperationOutputAlias = crate::operation::ListTags;
#[doc(hidden)]
pub type ListTagsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsInput {
    /// Consumes the builder and constructs an Operation<[`ListTags`](crate::operation::ListTags)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTags,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonMemoryDB.ListTags",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_tags(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListTags::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "ListTags", "memorydb",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsInput`](crate::input::ListTagsInput)
    pub fn builder() -> crate::input::list_tags_input::Builder {
        crate::input::list_tags_input::Builder::default()
    }
}

/// See [`ResetParameterGroupInput`](crate::input::ResetParameterGroupInput)
pub mod reset_parameter_group_input {
    /// A builder for [`ResetParameterGroupInput`](crate::input::ResetParameterGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) all_parameters: std::option::Option<bool>,
        pub(crate) parameter_names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the parameter group to reset.</p>
        pub fn parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the parameter group to reset.</p>
        pub fn set_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_group_name = input;
            self
        }
        /// <p>If true, all parameters in the parameter group are reset to their default values. If false, only the parameters listed by ParameterNames are reset to their default values.</p>
        pub fn all_parameters(mut self, input: bool) -> Self {
            self.all_parameters = Some(input);
            self
        }
        /// <p>If true, all parameters in the parameter group are reset to their default values. If false, only the parameters listed by ParameterNames are reset to their default values.</p>
        pub fn set_all_parameters(mut self, input: std::option::Option<bool>) -> Self {
            self.all_parameters = input;
            self
        }
        /// Appends an item to `parameter_names`.
        ///
        /// To override the contents of this collection use [`set_parameter_names`](Self::set_parameter_names).
        ///
        /// <p>An array of parameter names to reset to their default values. If AllParameters is true, do not use ParameterNames. If AllParameters is false, you must specify the name of at least one parameter to reset.</p>
        pub fn parameter_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.parameter_names.unwrap_or_default();
            v.push(input.into());
            self.parameter_names = Some(v);
            self
        }
        /// <p>An array of parameter names to reset to their default values. If AllParameters is true, do not use ParameterNames. If AllParameters is false, you must specify the name of at least one parameter to reset.</p>
        pub fn set_parameter_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.parameter_names = input;
            self
        }
        /// Consumes the builder and constructs a [`ResetParameterGroupInput`](crate::input::ResetParameterGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ResetParameterGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ResetParameterGroupInput {
                parameter_group_name: self.parameter_group_name,
                all_parameters: self.all_parameters.unwrap_or_default(),
                parameter_names: self.parameter_names,
            })
        }
    }
}
#[doc(hidden)]
pub type ResetParameterGroupInputOperationOutputAlias = crate::operation::ResetParameterGroup;
#[doc(hidden)]
pub type ResetParameterGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ResetParameterGroupInput {
    /// Consumes the builder and constructs an Operation<[`ResetParameterGroup`](crate::operation::ResetParameterGroup)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ResetParameterGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ResetParameterGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ResetParameterGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ResetParameterGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonMemoryDB.ResetParameterGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_reset_parameter_group(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ResetParameterGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ResetParameterGroup",
            "memorydb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ResetParameterGroupInput`](crate::input::ResetParameterGroupInput)
    pub fn builder() -> crate::input::reset_parameter_group_input::Builder {
        crate::input::reset_parameter_group_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource to which the tags are to be added</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to which the tags are to be added</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonMemoryDB.TagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "memorydb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource to which the tags are to be removed</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to which the tags are to be removed</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The list of keys of the tags that are to be removed</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The list of keys of the tags that are to be removed</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonMemoryDB.UntagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_untag_resource(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "memorydb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateAclInput`](crate::input::UpdateAclInput)
pub mod update_acl_input {
    /// A builder for [`UpdateAclInput`](crate::input::UpdateAclInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) acl_name: std::option::Option<std::string::String>,
        pub(crate) user_names_to_add: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) user_names_to_remove: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the Access Control List</p>
        pub fn acl_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.acl_name = Some(input.into());
            self
        }
        /// <p>The name of the Access Control List</p>
        pub fn set_acl_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.acl_name = input;
            self
        }
        /// Appends an item to `user_names_to_add`.
        ///
        /// To override the contents of this collection use [`set_user_names_to_add`](Self::set_user_names_to_add).
        ///
        /// <p>The list of users to add to the Access Control List</p>
        pub fn user_names_to_add(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.user_names_to_add.unwrap_or_default();
            v.push(input.into());
            self.user_names_to_add = Some(v);
            self
        }
        /// <p>The list of users to add to the Access Control List</p>
        pub fn set_user_names_to_add(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.user_names_to_add = input;
            self
        }
        /// Appends an item to `user_names_to_remove`.
        ///
        /// To override the contents of this collection use [`set_user_names_to_remove`](Self::set_user_names_to_remove).
        ///
        /// <p>The list of users to remove from the Access Control List</p>
        pub fn user_names_to_remove(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.user_names_to_remove.unwrap_or_default();
            v.push(input.into());
            self.user_names_to_remove = Some(v);
            self
        }
        /// <p>The list of users to remove from the Access Control List</p>
        pub fn set_user_names_to_remove(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.user_names_to_remove = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAclInput`](crate::input::UpdateAclInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::UpdateAclInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::UpdateAclInput {
                acl_name: self.acl_name,
                user_names_to_add: self.user_names_to_add,
                user_names_to_remove: self.user_names_to_remove,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateAclInputOperationOutputAlias = crate::operation::UpdateACL;
#[doc(hidden)]
pub type UpdateAclInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateAclInput {
    /// Consumes the builder and constructs an Operation<[`UpdateACL`](crate::operation::UpdateACL)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateACL,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateAclInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateAclInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateAclInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonMemoryDB.UpdateACL",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_acl(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::UpdateACL::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "UpdateACL",
                    "memorydb",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateAclInput`](crate::input::UpdateAclInput)
    pub fn builder() -> crate::input::update_acl_input::Builder {
        crate::input::update_acl_input::Builder::default()
    }
}

/// See [`UpdateClusterInput`](crate::input::UpdateClusterInput)
pub mod update_cluster_input {
    /// A builder for [`UpdateClusterInput`](crate::input::UpdateClusterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) maintenance_window: std::option::Option<std::string::String>,
        pub(crate) sns_topic_arn: std::option::Option<std::string::String>,
        pub(crate) sns_topic_status: std::option::Option<std::string::String>,
        pub(crate) parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) snapshot_window: std::option::Option<std::string::String>,
        pub(crate) snapshot_retention_limit: std::option::Option<i32>,
        pub(crate) node_type: std::option::Option<std::string::String>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) replica_configuration:
            std::option::Option<crate::model::ReplicaConfigurationRequest>,
        pub(crate) shard_configuration:
            std::option::Option<crate::model::ShardConfigurationRequest>,
        pub(crate) acl_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the cluster to update</p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_name = Some(input.into());
            self
        }
        /// <p>The name of the cluster to update</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_name = input;
            self
        }
        /// <p>The description of the cluster to update</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the cluster to update</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>The SecurityGroupIds to update</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.security_group_ids = Some(v);
            self
        }
        /// <p>The SecurityGroupIds to update</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_ids = input;
            self
        }
        /// <p>The maintenance window to update</p>
        pub fn maintenance_window(mut self, input: impl Into<std::string::String>) -> Self {
            self.maintenance_window = Some(input.into());
            self
        }
        /// <p>The maintenance window to update</p>
        pub fn set_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.maintenance_window = input;
            self
        }
        /// <p>The SNS topic ARN to update</p>
        pub fn sns_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.sns_topic_arn = Some(input.into());
            self
        }
        /// <p>The SNS topic ARN to update</p>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sns_topic_arn = input;
            self
        }
        /// <p>The status of the Amazon SNS notification topic. Notifications are sent only if the status is active.</p>
        pub fn sns_topic_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.sns_topic_status = Some(input.into());
            self
        }
        /// <p>The status of the Amazon SNS notification topic. Notifications are sent only if the status is active.</p>
        pub fn set_sns_topic_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sns_topic_status = input;
            self
        }
        /// <p>The name of the parameter group to update</p>
        pub fn parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the parameter group to update</p>
        pub fn set_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_group_name = input;
            self
        }
        /// <p>The daily time range (in UTC) during which MemoryDB begins taking a daily snapshot of your cluster.</p>
        pub fn snapshot_window(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_window = Some(input.into());
            self
        }
        /// <p>The daily time range (in UTC) during which MemoryDB begins taking a daily snapshot of your cluster.</p>
        pub fn set_snapshot_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshot_window = input;
            self
        }
        /// <p>The number of days for which MemoryDB retains automatic cluster snapshots before deleting them. For example, if you set SnapshotRetentionLimit to 5, a snapshot that was taken today is retained for 5 days before being deleted.</p>
        pub fn snapshot_retention_limit(mut self, input: i32) -> Self {
            self.snapshot_retention_limit = Some(input);
            self
        }
        /// <p>The number of days for which MemoryDB retains automatic cluster snapshots before deleting them. For example, if you set SnapshotRetentionLimit to 5, a snapshot that was taken today is retained for 5 days before being deleted.</p>
        pub fn set_snapshot_retention_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.snapshot_retention_limit = input;
            self
        }
        /// <p>A valid node type that you want to scale this cluster up or down to.</p>
        pub fn node_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.node_type = Some(input.into());
            self
        }
        /// <p>A valid node type that you want to scale this cluster up or down to.</p>
        pub fn set_node_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.node_type = input;
            self
        }
        /// <p>The upgraded version of the engine to be run on the nodes. You can upgrade to a newer engine version, but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing cluster and create it anew with the earlier engine version.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The upgraded version of the engine to be run on the nodes. You can upgrade to a newer engine version, but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing cluster and create it anew with the earlier engine version.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>The number of replicas that will reside in each shard</p>
        pub fn replica_configuration(
            mut self,
            input: crate::model::ReplicaConfigurationRequest,
        ) -> Self {
            self.replica_configuration = Some(input);
            self
        }
        /// <p>The number of replicas that will reside in each shard</p>
        pub fn set_replica_configuration(
            mut self,
            input: std::option::Option<crate::model::ReplicaConfigurationRequest>,
        ) -> Self {
            self.replica_configuration = input;
            self
        }
        /// <p>The number of shards in the cluster</p>
        pub fn shard_configuration(
            mut self,
            input: crate::model::ShardConfigurationRequest,
        ) -> Self {
            self.shard_configuration = Some(input);
            self
        }
        /// <p>The number of shards in the cluster</p>
        pub fn set_shard_configuration(
            mut self,
            input: std::option::Option<crate::model::ShardConfigurationRequest>,
        ) -> Self {
            self.shard_configuration = input;
            self
        }
        /// <p>The Access Control List that is associated with the cluster</p>
        pub fn acl_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.acl_name = Some(input.into());
            self
        }
        /// <p>The Access Control List that is associated with the cluster</p>
        pub fn set_acl_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.acl_name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateClusterInput`](crate::input::UpdateClusterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateClusterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateClusterInput {
                cluster_name: self.cluster_name,
                description: self.description,
                security_group_ids: self.security_group_ids,
                maintenance_window: self.maintenance_window,
                sns_topic_arn: self.sns_topic_arn,
                sns_topic_status: self.sns_topic_status,
                parameter_group_name: self.parameter_group_name,
                snapshot_window: self.snapshot_window,
                snapshot_retention_limit: self.snapshot_retention_limit,
                node_type: self.node_type,
                engine_version: self.engine_version,
                replica_configuration: self.replica_configuration,
                shard_configuration: self.shard_configuration,
                acl_name: self.acl_name,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateClusterInputOperationOutputAlias = crate::operation::UpdateCluster;
#[doc(hidden)]
pub type UpdateClusterInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateClusterInput {
    /// Consumes the builder and constructs an Operation<[`UpdateCluster`](crate::operation::UpdateCluster)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateCluster,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateClusterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateClusterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateClusterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonMemoryDB.UpdateCluster",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_cluster(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateCluster::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateCluster",
            "memorydb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateClusterInput`](crate::input::UpdateClusterInput)
    pub fn builder() -> crate::input::update_cluster_input::Builder {
        crate::input::update_cluster_input::Builder::default()
    }
}

/// See [`UpdateParameterGroupInput`](crate::input::UpdateParameterGroupInput)
pub mod update_parameter_group_input {
    /// A builder for [`UpdateParameterGroupInput`](crate::input::UpdateParameterGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) parameter_name_values:
            std::option::Option<std::vec::Vec<crate::model::ParameterNameValue>>,
    }
    impl Builder {
        /// <p>The name of the parameter group to update.</p>
        pub fn parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the parameter group to update.</p>
        pub fn set_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_group_name = input;
            self
        }
        /// Appends an item to `parameter_name_values`.
        ///
        /// To override the contents of this collection use [`set_parameter_name_values`](Self::set_parameter_name_values).
        ///
        /// <p>An array of parameter names and values for the parameter update. You must supply at least one parameter name and value; subsequent arguments are optional. A maximum of 20 parameters may be updated per request.</p>
        pub fn parameter_name_values(
            mut self,
            input: impl Into<crate::model::ParameterNameValue>,
        ) -> Self {
            let mut v = self.parameter_name_values.unwrap_or_default();
            v.push(input.into());
            self.parameter_name_values = Some(v);
            self
        }
        /// <p>An array of parameter names and values for the parameter update. You must supply at least one parameter name and value; subsequent arguments are optional. A maximum of 20 parameters may be updated per request.</p>
        pub fn set_parameter_name_values(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ParameterNameValue>>,
        ) -> Self {
            self.parameter_name_values = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateParameterGroupInput`](crate::input::UpdateParameterGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateParameterGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateParameterGroupInput {
                parameter_group_name: self.parameter_group_name,
                parameter_name_values: self.parameter_name_values,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateParameterGroupInputOperationOutputAlias = crate::operation::UpdateParameterGroup;
#[doc(hidden)]
pub type UpdateParameterGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateParameterGroupInput {
    /// Consumes the builder and constructs an Operation<[`UpdateParameterGroup`](crate::operation::UpdateParameterGroup)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateParameterGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateParameterGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateParameterGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateParameterGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonMemoryDB.UpdateParameterGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_parameter_group(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateParameterGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateParameterGroup",
            "memorydb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateParameterGroupInput`](crate::input::UpdateParameterGroupInput)
    pub fn builder() -> crate::input::update_parameter_group_input::Builder {
        crate::input::update_parameter_group_input::Builder::default()
    }
}

/// See [`UpdateSubnetGroupInput`](crate::input::UpdateSubnetGroupInput)
pub mod update_subnet_group_input {
    /// A builder for [`UpdateSubnetGroupInput`](crate::input::UpdateSubnetGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subnet_group_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the subnet group</p>
        pub fn subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_group_name = Some(input.into());
            self
        }
        /// <p>The name of the subnet group</p>
        pub fn set_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subnet_group_name = input;
            self
        }
        /// <p>A description of the subnet group</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the subnet group</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>The EC2 subnet IDs for the subnet group.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>The EC2 subnet IDs for the subnet group.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateSubnetGroupInput`](crate::input::UpdateSubnetGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateSubnetGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateSubnetGroupInput {
                subnet_group_name: self.subnet_group_name,
                description: self.description,
                subnet_ids: self.subnet_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateSubnetGroupInputOperationOutputAlias = crate::operation::UpdateSubnetGroup;
#[doc(hidden)]
pub type UpdateSubnetGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateSubnetGroupInput {
    /// Consumes the builder and constructs an Operation<[`UpdateSubnetGroup`](crate::operation::UpdateSubnetGroup)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateSubnetGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateSubnetGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateSubnetGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateSubnetGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonMemoryDB.UpdateSubnetGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_subnet_group(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateSubnetGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateSubnetGroup",
            "memorydb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateSubnetGroupInput`](crate::input::UpdateSubnetGroupInput)
    pub fn builder() -> crate::input::update_subnet_group_input::Builder {
        crate::input::update_subnet_group_input::Builder::default()
    }
}

/// See [`UpdateUserInput`](crate::input::UpdateUserInput)
pub mod update_user_input {
    /// A builder for [`UpdateUserInput`](crate::input::UpdateUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) authentication_mode: std::option::Option<crate::model::AuthenticationMode>,
        pub(crate) access_string: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the user</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The name of the user</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>Denotes the user's authentication properties, such as whether it requires a password to authenticate.</p>
        pub fn authentication_mode(mut self, input: crate::model::AuthenticationMode) -> Self {
            self.authentication_mode = Some(input);
            self
        }
        /// <p>Denotes the user's authentication properties, such as whether it requires a password to authenticate.</p>
        pub fn set_authentication_mode(
            mut self,
            input: std::option::Option<crate::model::AuthenticationMode>,
        ) -> Self {
            self.authentication_mode = input;
            self
        }
        /// <p>Access permissions string used for this user.</p>
        pub fn access_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_string = Some(input.into());
            self
        }
        /// <p>Access permissions string used for this user.</p>
        pub fn set_access_string(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.access_string = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateUserInput`](crate::input::UpdateUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateUserInput {
                user_name: self.user_name,
                authentication_mode: self.authentication_mode,
                access_string: self.access_string,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateUserInputOperationOutputAlias = crate::operation::UpdateUser;
#[doc(hidden)]
pub type UpdateUserInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateUserInput {
    /// Consumes the builder and constructs an Operation<[`UpdateUser`](crate::operation::UpdateUser)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateUser,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateUserInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateUserInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateUserInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonMemoryDB.UpdateUser",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_user(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateUser",
            "memorydb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateUserInput`](crate::input::UpdateUserInput)
    pub fn builder() -> crate::input::update_user_input::Builder {
        crate::input::update_user_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateUserInput {
    /// <p>The name of the user</p>
    pub user_name: std::option::Option<std::string::String>,
    /// <p>Denotes the user's authentication properties, such as whether it requires a password to authenticate.</p>
    pub authentication_mode: std::option::Option<crate::model::AuthenticationMode>,
    /// <p>Access permissions string used for this user.</p>
    pub access_string: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateUserInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateUserInput");
        formatter.field("user_name", &self.user_name);
        formatter.field("authentication_mode", &self.authentication_mode);
        formatter.field("access_string", &self.access_string);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateSubnetGroupInput {
    /// <p>The name of the subnet group</p>
    pub subnet_group_name: std::option::Option<std::string::String>,
    /// <p>A description of the subnet group</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The EC2 subnet IDs for the subnet group.</p>
    pub subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for UpdateSubnetGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateSubnetGroupInput");
        formatter.field("subnet_group_name", &self.subnet_group_name);
        formatter.field("description", &self.description);
        formatter.field("subnet_ids", &self.subnet_ids);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateParameterGroupInput {
    /// <p>The name of the parameter group to update.</p>
    pub parameter_group_name: std::option::Option<std::string::String>,
    /// <p>An array of parameter names and values for the parameter update. You must supply at least one parameter name and value; subsequent arguments are optional. A maximum of 20 parameters may be updated per request.</p>
    pub parameter_name_values: std::option::Option<std::vec::Vec<crate::model::ParameterNameValue>>,
}
impl std::fmt::Debug for UpdateParameterGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateParameterGroupInput");
        formatter.field("parameter_group_name", &self.parameter_group_name);
        formatter.field("parameter_name_values", &self.parameter_name_values);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateClusterInput {
    /// <p>The name of the cluster to update</p>
    pub cluster_name: std::option::Option<std::string::String>,
    /// <p>The description of the cluster to update</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The SecurityGroupIds to update</p>
    pub security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The maintenance window to update</p>
    pub maintenance_window: std::option::Option<std::string::String>,
    /// <p>The SNS topic ARN to update</p>
    pub sns_topic_arn: std::option::Option<std::string::String>,
    /// <p>The status of the Amazon SNS notification topic. Notifications are sent only if the status is active.</p>
    pub sns_topic_status: std::option::Option<std::string::String>,
    /// <p>The name of the parameter group to update</p>
    pub parameter_group_name: std::option::Option<std::string::String>,
    /// <p>The daily time range (in UTC) during which MemoryDB begins taking a daily snapshot of your cluster.</p>
    pub snapshot_window: std::option::Option<std::string::String>,
    /// <p>The number of days for which MemoryDB retains automatic cluster snapshots before deleting them. For example, if you set SnapshotRetentionLimit to 5, a snapshot that was taken today is retained for 5 days before being deleted.</p>
    pub snapshot_retention_limit: std::option::Option<i32>,
    /// <p>A valid node type that you want to scale this cluster up or down to.</p>
    pub node_type: std::option::Option<std::string::String>,
    /// <p>The upgraded version of the engine to be run on the nodes. You can upgrade to a newer engine version, but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing cluster and create it anew with the earlier engine version.</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>The number of replicas that will reside in each shard</p>
    pub replica_configuration: std::option::Option<crate::model::ReplicaConfigurationRequest>,
    /// <p>The number of shards in the cluster</p>
    pub shard_configuration: std::option::Option<crate::model::ShardConfigurationRequest>,
    /// <p>The Access Control List that is associated with the cluster</p>
    pub acl_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateClusterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateClusterInput");
        formatter.field("cluster_name", &self.cluster_name);
        formatter.field("description", &self.description);
        formatter.field("security_group_ids", &self.security_group_ids);
        formatter.field("maintenance_window", &self.maintenance_window);
        formatter.field("sns_topic_arn", &self.sns_topic_arn);
        formatter.field("sns_topic_status", &self.sns_topic_status);
        formatter.field("parameter_group_name", &self.parameter_group_name);
        formatter.field("snapshot_window", &self.snapshot_window);
        formatter.field("snapshot_retention_limit", &self.snapshot_retention_limit);
        formatter.field("node_type", &self.node_type);
        formatter.field("engine_version", &self.engine_version);
        formatter.field("replica_configuration", &self.replica_configuration);
        formatter.field("shard_configuration", &self.shard_configuration);
        formatter.field("acl_name", &self.acl_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAclInput {
    /// <p>The name of the Access Control List</p>
    pub acl_name: std::option::Option<std::string::String>,
    /// <p>The list of users to add to the Access Control List</p>
    pub user_names_to_add: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The list of users to remove from the Access Control List</p>
    pub user_names_to_remove: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for UpdateAclInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAclInput");
        formatter.field("acl_name", &self.acl_name);
        formatter.field("user_names_to_add", &self.user_names_to_add);
        formatter.field("user_names_to_remove", &self.user_names_to_remove);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource to which the tags are to be removed</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The list of keys of the tags that are to be removed</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource to which the tags are to be added</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResetParameterGroupInput {
    /// <p>The name of the parameter group to reset.</p>
    pub parameter_group_name: std::option::Option<std::string::String>,
    /// <p>If true, all parameters in the parameter group are reset to their default values. If false, only the parameters listed by ParameterNames are reset to their default values.</p>
    pub all_parameters: bool,
    /// <p>An array of parameter names to reset to their default values. If AllParameters is true, do not use ParameterNames. If AllParameters is false, you must specify the name of at least one parameter to reset.</p>
    pub parameter_names: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for ResetParameterGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResetParameterGroupInput");
        formatter.field("parameter_group_name", &self.parameter_group_name);
        formatter.field("all_parameters", &self.all_parameters);
        formatter.field("parameter_names", &self.parameter_names);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsInput {
    /// <p>The Amazon Resource Name (ARN) of the resource for which you want the list of tags</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListTagsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAllowedNodeTypeUpdatesInput {
    /// <p>The name of the cluster you want to scale. MemoryDB uses the cluster name to identify the current node type being used by this cluster, and from that to create a list of node types
    /// you can scale up to.</p>
    pub cluster_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListAllowedNodeTypeUpdatesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAllowedNodeTypeUpdatesInput");
        formatter.field("cluster_name", &self.cluster_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FailoverShardInput {
    /// <p>The cluster being failed over</p>
    pub cluster_name: std::option::Option<std::string::String>,
    /// <p>The name of the shard</p>
    pub shard_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for FailoverShardInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FailoverShardInput");
        formatter.field("cluster_name", &self.cluster_name);
        formatter.field("shard_name", &self.shard_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeUsersInput {
    /// <p>The name of the user</p>
    pub user_name: std::option::Option<std::string::String>,
    /// <p>Filter to determine the list of users to return.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeUsersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeUsersInput");
        formatter.field("user_name", &self.user_name);
        formatter.field("filters", &self.filters);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSubnetGroupsInput {
    /// <p>The name of the subnet group to return details for.</p>
    pub subnet_group_name: std::option::Option<std::string::String>,
    /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeSubnetGroupsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSubnetGroupsInput");
        formatter.field("subnet_group_name", &self.subnet_group_name);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSnapshotsInput {
    /// <p>A user-supplied cluster identifier. If this parameter is specified, only snapshots associated with that specific cluster are described.</p>
    pub cluster_name: std::option::Option<std::string::String>,
    /// <p>A user-supplied name of the snapshot. If this parameter is specified, only this named snapshot is described.</p>
    pub snapshot_name: std::option::Option<std::string::String>,
    /// <p>If set to system, the output shows snapshots that were automatically created by MemoryDB. If set to user the output shows snapshots that were manually created. If omitted, the output shows both automatically and manually created snapshots.</p>
    pub source: std::option::Option<std::string::String>,
    /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>A Boolean value which if true, the shard configuration is included in the snapshot description.</p>
    pub show_detail: std::option::Option<bool>,
}
impl std::fmt::Debug for DescribeSnapshotsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSnapshotsInput");
        formatter.field("cluster_name", &self.cluster_name);
        formatter.field("snapshot_name", &self.snapshot_name);
        formatter.field("source", &self.source);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("show_detail", &self.show_detail);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeServiceUpdatesInput {
    /// <p>The unique ID of the service update to describe.</p>
    pub service_update_name: std::option::Option<std::string::String>,
    /// <p>The list of cluster names to identify service updates to apply</p>
    pub cluster_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The status(es) of the service updates to filter on</p>
    pub status: std::option::Option<std::vec::Vec<crate::model::ServiceUpdateStatus>>,
    /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeServiceUpdatesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeServiceUpdatesInput");
        formatter.field("service_update_name", &self.service_update_name);
        formatter.field("cluster_names", &self.cluster_names);
        formatter.field("status", &self.status);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeParametersInput {
    /// <p>he name of a specific  parameter group to return details for.</p>
    pub parameter_group_name: std::option::Option<std::string::String>,
    /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeParametersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeParametersInput");
        formatter.field("parameter_group_name", &self.parameter_group_name);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeParameterGroupsInput {
    /// <p>The name of a specific  parameter group to return details for.</p>
    pub parameter_group_name: std::option::Option<std::string::String>,
    /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeParameterGroupsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeParameterGroupsInput");
        formatter.field("parameter_group_name", &self.parameter_group_name);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEventsInput {
    /// <p>The identifier of the event source for which events are returned. If not specified, all sources are included in the response.</p>
    pub source_name: std::option::Option<std::string::String>,
    /// <p>The event source to retrieve events for. If no value is specified, all events are returned.</p>
    pub source_type: std::option::Option<crate::model::SourceType>,
    /// <p>The beginning of the time interval to retrieve events for, specified in ISO 8601 format.
    ///
    /// Example: 2017-03-30T07:03:49.555Z</p>
    pub start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The end of the time interval for which to retrieve events, specified in ISO 8601 format.
    ///
    /// Example: 2017-03-30T07:03:49.555Z</p>
    pub end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The number of minutes worth of events to retrieve.</p>
    pub duration: std::option::Option<i32>,
    /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeEventsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEventsInput");
        formatter.field("source_name", &self.source_name);
        formatter.field("source_type", &self.source_type);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("duration", &self.duration);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEngineVersionsInput {
    /// <p>The Redis engine version</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>The name of a specific parameter group family to return details for.</p>
    pub parameter_group_family: std::option::Option<std::string::String>,
    /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>If true, specifies that only the default version of the specified engine or engine and major version combination is to be returned.</p>
    pub default_only: bool,
}
impl std::fmt::Debug for DescribeEngineVersionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEngineVersionsInput");
        formatter.field("engine_version", &self.engine_version);
        formatter.field("parameter_group_family", &self.parameter_group_family);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("default_only", &self.default_only);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeClustersInput {
    /// <p>The name of the cluster</p>
    pub cluster_name: std::option::Option<std::string::String>,
    /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>An optional flag that can be included in the request to retrieve information about the individual shard(s).</p>
    pub show_shard_details: std::option::Option<bool>,
}
impl std::fmt::Debug for DescribeClustersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeClustersInput");
        formatter.field("cluster_name", &self.cluster_name);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("show_shard_details", &self.show_shard_details);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAcLsInput {
    /// <p>The name of the ACL</p>
    pub acl_name: std::option::Option<std::string::String>,
    /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeAcLsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAcLsInput");
        formatter.field("acl_name", &self.acl_name);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteUserInput {
    /// <p>The name of the user to delete</p>
    pub user_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteUserInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteUserInput");
        formatter.field("user_name", &self.user_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSubnetGroupInput {
    /// <p>The name of the subnet group to delete</p>
    pub subnet_group_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteSubnetGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSubnetGroupInput");
        formatter.field("subnet_group_name", &self.subnet_group_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSnapshotInput {
    /// <p>The name of the snapshot to delete</p>
    pub snapshot_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteSnapshotInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSnapshotInput");
        formatter.field("snapshot_name", &self.snapshot_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteParameterGroupInput {
    /// <p>The name of the parameter group to delete.</p>
    pub parameter_group_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteParameterGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteParameterGroupInput");
        formatter.field("parameter_group_name", &self.parameter_group_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteClusterInput {
    /// <p>The name of the cluster to be deleted</p>
    pub cluster_name: std::option::Option<std::string::String>,
    /// <p>The user-supplied name of a final cluster snapshot. This is the unique name that identifies the snapshot. MemoryDB creates the snapshot, and then deletes the cluster immediately afterward.</p>
    pub final_snapshot_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteClusterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteClusterInput");
        formatter.field("cluster_name", &self.cluster_name);
        formatter.field("final_snapshot_name", &self.final_snapshot_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAclInput {
    /// <p>The name of the Access Control List to delete</p>
    pub acl_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteAclInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAclInput");
        formatter.field("acl_name", &self.acl_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateUserInput {
    /// <p>The name of the user. This value must be unique as it also serves as the user identifier.</p>
    pub user_name: std::option::Option<std::string::String>,
    /// <p>Denotes the user's authentication properties, such as whether it requires a password to authenticate.</p>
    pub authentication_mode: std::option::Option<crate::model::AuthenticationMode>,
    /// <p>Access permissions string used for this user.</p>
    pub access_string: std::option::Option<std::string::String>,
    /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for CreateUserInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateUserInput");
        formatter.field("user_name", &self.user_name);
        formatter.field("authentication_mode", &self.authentication_mode);
        formatter.field("access_string", &self.access_string);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSubnetGroupInput {
    /// <p>The name of the subnet group.</p>
    pub subnet_group_name: std::option::Option<std::string::String>,
    /// <p>A description for the subnet group.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A list of VPC subnet IDs for the subnet group.</p>
    pub subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for CreateSubnetGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSubnetGroupInput");
        formatter.field("subnet_group_name", &self.subnet_group_name);
        formatter.field("description", &self.description);
        formatter.field("subnet_ids", &self.subnet_ids);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSnapshotInput {
    /// <p>The snapshot is created from this cluster.</p>
    pub cluster_name: std::option::Option<std::string::String>,
    /// <p>A name for the snapshot being created.</p>
    pub snapshot_name: std::option::Option<std::string::String>,
    /// <p>The ID of the KMS key used to encrypt the snapshot.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for CreateSnapshotInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSnapshotInput");
        formatter.field("cluster_name", &self.cluster_name);
        formatter.field("snapshot_name", &self.snapshot_name);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateParameterGroupInput {
    /// <p>The name of the parameter group.</p>
    pub parameter_group_name: std::option::Option<std::string::String>,
    /// <p>The name of the parameter group family that the parameter group can be used with.</p>
    pub family: std::option::Option<std::string::String>,
    /// <p>An optional description of the parameter group.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for CreateParameterGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateParameterGroupInput");
        formatter.field("parameter_group_name", &self.parameter_group_name);
        formatter.field("family", &self.family);
        formatter.field("description", &self.description);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateClusterInput {
    /// <p>The name of the cluster. This value must be unique as it also serves as the cluster identifier.</p>
    pub cluster_name: std::option::Option<std::string::String>,
    /// <p>The compute and memory capacity of the nodes in the cluster.</p>
    pub node_type: std::option::Option<std::string::String>,
    /// <p>The name of the parameter group associated with the cluster.</p>
    pub parameter_group_name: std::option::Option<std::string::String>,
    /// <p>An optional description of the cluster.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The number of shards the cluster will contain. The default value is 1. </p>
    pub num_shards: std::option::Option<i32>,
    /// <p>The number of replicas to apply to each shard. The default value is 1. The maximum is 5. </p>
    pub num_replicas_per_shard: std::option::Option<i32>,
    /// <p>The name of the subnet group to be used for the cluster.</p>
    pub subnet_group_name: std::option::Option<std::string::String>,
    /// <p>A list of security group names to associate with this cluster.</p>
    pub security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format <code>ddd:hh24:mi-ddd:hh24:mi</code> (24H Clock UTC). The minimum maintenance window is a 60 minute period.</p>
    pub maintenance_window: std::option::Option<std::string::String>,
    /// <p>The port number on which each of the nodes accepts connections.</p>
    pub port: std::option::Option<i32>,
    /// <p>The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which notifications are sent.</p>
    pub sns_topic_arn: std::option::Option<std::string::String>,
    /// <p>A flag to enable in-transit encryption on the cluster.</p>
    pub tls_enabled: std::option::Option<bool>,
    /// <p>The ID of the KMS key used to encrypt the cluster.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>A list of Amazon Resource Names (ARN) that uniquely identify the RDB snapshot files stored in Amazon S3. The snapshot files are used to populate the new cluster. The Amazon S3 object name in the ARN cannot contain any commas.</p>
    pub snapshot_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The name of a snapshot from which to restore data into the new cluster. The snapshot status changes to restoring while the new cluster is being created.</p>
    pub snapshot_name: std::option::Option<std::string::String>,
    /// <p>The number of days for which MemoryDB retains automatic snapshots before deleting them. For example, if you set SnapshotRetentionLimit to 5, a snapshot that was taken today is retained for 5 days before being deleted.</p>
    pub snapshot_retention_limit: std::option::Option<i32>,
    /// <p>A list of tags to be added to this resource. Tags are comma-separated key,value pairs (e.g. Key=myKey, Value=myKeyValue. You can include multiple tags as shown following: Key=myKey, Value=myKeyValue Key=mySecondKey, Value=mySecondKeyValue.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The daily time range (in UTC) during which MemoryDB begins taking a daily snapshot of your shard.</p>
    ///
    /// <p>    Example: 05:00-09:00</p>
    ///
    /// <p>    If you do not specify this parameter, MemoryDB automatically chooses an appropriate time range.</p>
    pub snapshot_window: std::option::Option<std::string::String>,
    /// <p>The name of the Access Control List to associate with the cluster.</p>
    pub acl_name: std::option::Option<std::string::String>,
    /// <p>The version number of the Redis engine to be used for the cluster.</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>When set to true, the cluster will automatically receive minor engine version upgrades after launch.</p>
    pub auto_minor_version_upgrade: std::option::Option<bool>,
}
impl std::fmt::Debug for CreateClusterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateClusterInput");
        formatter.field("cluster_name", &self.cluster_name);
        formatter.field("node_type", &self.node_type);
        formatter.field("parameter_group_name", &self.parameter_group_name);
        formatter.field("description", &self.description);
        formatter.field("num_shards", &self.num_shards);
        formatter.field("num_replicas_per_shard", &self.num_replicas_per_shard);
        formatter.field("subnet_group_name", &self.subnet_group_name);
        formatter.field("security_group_ids", &self.security_group_ids);
        formatter.field("maintenance_window", &self.maintenance_window);
        formatter.field("port", &self.port);
        formatter.field("sns_topic_arn", &self.sns_topic_arn);
        formatter.field("tls_enabled", &self.tls_enabled);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("snapshot_arns", &self.snapshot_arns);
        formatter.field("snapshot_name", &self.snapshot_name);
        formatter.field("snapshot_retention_limit", &self.snapshot_retention_limit);
        formatter.field("tags", &self.tags);
        formatter.field("snapshot_window", &self.snapshot_window);
        formatter.field("acl_name", &self.acl_name);
        formatter.field("engine_version", &self.engine_version);
        formatter.field(
            "auto_minor_version_upgrade",
            &self.auto_minor_version_upgrade,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAclInput {
    /// <p>The name of the Access Control List.</p>
    pub acl_name: std::option::Option<std::string::String>,
    /// <p>The list of users that belong to the Access Control List.</p>
    pub user_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for CreateAclInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAclInput");
        formatter.field("acl_name", &self.acl_name);
        formatter.field("user_names", &self.user_names);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CopySnapshotInput {
    /// <p>The name of an existing snapshot from which to make a copy.</p>
    pub source_snapshot_name: std::option::Option<std::string::String>,
    /// <p>A name for the snapshot copy. MemoryDB does not permit overwriting a snapshot, therefore this name must be unique within its context - MemoryDB or an Amazon S3 bucket if exporting.</p>
    pub target_snapshot_name: std::option::Option<std::string::String>,
    /// <p>The Amazon S3 bucket to which the snapshot is exported. This parameter is used only when exporting a snapshot for external access.
    ///
    /// When using this parameter to export a snapshot, be sure MemoryDB has the needed permissions to this S3 bucket. For more information, see
    ///
    /// <a href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/snapshots-exporting.html">Step 2: Grant MemoryDB Access to Your Amazon S3 Bucket</a>.
    ///
    /// </p>
    pub target_bucket: std::option::Option<std::string::String>,
    /// <p>The ID of the KMS key used to encrypt the target snapshot.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for CopySnapshotInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CopySnapshotInput");
        formatter.field("source_snapshot_name", &self.source_snapshot_name);
        formatter.field("target_snapshot_name", &self.target_snapshot_name);
        formatter.field("target_bucket", &self.target_bucket);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchUpdateClusterInput {
    /// <p>The cluster names to apply the updates.</p>
    pub cluster_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The unique ID of the service update</p>
    pub service_update: std::option::Option<crate::model::ServiceUpdateRequest>,
}
impl std::fmt::Debug for BatchUpdateClusterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchUpdateClusterInput");
        formatter.field("cluster_names", &self.cluster_names);
        formatter.field("service_update", &self.service_update);
        formatter.finish()
    }
}
