// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `BatchUpdateCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchUpdateClusterError {
    /// Kind of error that occurred.
    pub kind: BatchUpdateClusterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchUpdateCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchUpdateClusterErrorKind {
    /// <p></p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p></p>
    ServiceUpdateNotFoundFault(crate::error::ServiceUpdateNotFoundFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchUpdateClusterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchUpdateClusterErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            BatchUpdateClusterErrorKind::ServiceUpdateNotFoundFault(_inner) => _inner.fmt(f),
            BatchUpdateClusterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchUpdateClusterError {
    fn code(&self) -> Option<&str> {
        BatchUpdateClusterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchUpdateClusterError {
    /// Creates a new `BatchUpdateClusterError`.
    pub fn new(kind: BatchUpdateClusterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchUpdateClusterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchUpdateClusterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchUpdateClusterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchUpdateClusterErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `BatchUpdateClusterErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchUpdateClusterErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns true if the error kind is `BatchUpdateClusterErrorKind::ServiceUpdateNotFoundFault`.
    pub fn is_service_update_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            BatchUpdateClusterErrorKind::ServiceUpdateNotFoundFault(_)
        )
    }
}
impl std::error::Error for BatchUpdateClusterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchUpdateClusterErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            BatchUpdateClusterErrorKind::ServiceUpdateNotFoundFault(_inner) => Some(_inner),
            BatchUpdateClusterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CopySnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CopySnapshotError {
    /// Kind of error that occurred.
    pub kind: CopySnapshotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CopySnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CopySnapshotErrorKind {
    /// <p></p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p></p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p></p>
    InvalidSnapshotStateFault(crate::error::InvalidSnapshotStateFault),
    /// <p></p>
    ServiceLinkedRoleNotFoundFault(crate::error::ServiceLinkedRoleNotFoundFault),
    /// <p></p>
    SnapshotAlreadyExistsFault(crate::error::SnapshotAlreadyExistsFault),
    /// <p></p>
    SnapshotNotFoundFault(crate::error::SnapshotNotFoundFault),
    /// <p></p>
    SnapshotQuotaExceededFault(crate::error::SnapshotQuotaExceededFault),
    /// <p></p>
    TagQuotaPerResourceExceeded(crate::error::TagQuotaPerResourceExceeded),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CopySnapshotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CopySnapshotErrorKind::InvalidParameterCombinationException(_inner) => _inner.fmt(f),
            CopySnapshotErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            CopySnapshotErrorKind::InvalidSnapshotStateFault(_inner) => _inner.fmt(f),
            CopySnapshotErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => _inner.fmt(f),
            CopySnapshotErrorKind::SnapshotAlreadyExistsFault(_inner) => _inner.fmt(f),
            CopySnapshotErrorKind::SnapshotNotFoundFault(_inner) => _inner.fmt(f),
            CopySnapshotErrorKind::SnapshotQuotaExceededFault(_inner) => _inner.fmt(f),
            CopySnapshotErrorKind::TagQuotaPerResourceExceeded(_inner) => _inner.fmt(f),
            CopySnapshotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CopySnapshotError {
    fn code(&self) -> Option<&str> {
        CopySnapshotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CopySnapshotError {
    /// Creates a new `CopySnapshotError`.
    pub fn new(kind: CopySnapshotErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CopySnapshotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CopySnapshotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CopySnapshotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CopySnapshotErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CopySnapshotErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            CopySnapshotErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns true if the error kind is `CopySnapshotErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            CopySnapshotErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns true if the error kind is `CopySnapshotErrorKind::InvalidSnapshotStateFault`.
    pub fn is_invalid_snapshot_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            CopySnapshotErrorKind::InvalidSnapshotStateFault(_)
        )
    }
    /// Returns true if the error kind is `CopySnapshotErrorKind::ServiceLinkedRoleNotFoundFault`.
    pub fn is_service_linked_role_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CopySnapshotErrorKind::ServiceLinkedRoleNotFoundFault(_)
        )
    }
    /// Returns true if the error kind is `CopySnapshotErrorKind::SnapshotAlreadyExistsFault`.
    pub fn is_snapshot_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            CopySnapshotErrorKind::SnapshotAlreadyExistsFault(_)
        )
    }
    /// Returns true if the error kind is `CopySnapshotErrorKind::SnapshotNotFoundFault`.
    pub fn is_snapshot_not_found_fault(&self) -> bool {
        matches!(&self.kind, CopySnapshotErrorKind::SnapshotNotFoundFault(_))
    }
    /// Returns true if the error kind is `CopySnapshotErrorKind::SnapshotQuotaExceededFault`.
    pub fn is_snapshot_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CopySnapshotErrorKind::SnapshotQuotaExceededFault(_)
        )
    }
    /// Returns true if the error kind is `CopySnapshotErrorKind::TagQuotaPerResourceExceeded`.
    pub fn is_tag_quota_per_resource_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            CopySnapshotErrorKind::TagQuotaPerResourceExceeded(_)
        )
    }
}
impl std::error::Error for CopySnapshotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CopySnapshotErrorKind::InvalidParameterCombinationException(_inner) => Some(_inner),
            CopySnapshotErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            CopySnapshotErrorKind::InvalidSnapshotStateFault(_inner) => Some(_inner),
            CopySnapshotErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => Some(_inner),
            CopySnapshotErrorKind::SnapshotAlreadyExistsFault(_inner) => Some(_inner),
            CopySnapshotErrorKind::SnapshotNotFoundFault(_inner) => Some(_inner),
            CopySnapshotErrorKind::SnapshotQuotaExceededFault(_inner) => Some(_inner),
            CopySnapshotErrorKind::TagQuotaPerResourceExceeded(_inner) => Some(_inner),
            CopySnapshotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateACL` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateACLError {
    /// Kind of error that occurred.
    pub kind: CreateACLErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateACL` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateACLErrorKind {
    /// <p></p>
    AclAlreadyExistsFault(crate::error::AclAlreadyExistsFault),
    /// <p></p>
    AclQuotaExceededFault(crate::error::AclQuotaExceededFault),
    /// <p></p>
    DefaultUserRequired(crate::error::DefaultUserRequired),
    /// <p></p>
    DuplicateUserNameFault(crate::error::DuplicateUserNameFault),
    /// <p></p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p></p>
    TagQuotaPerResourceExceeded(crate::error::TagQuotaPerResourceExceeded),
    /// <p></p>
    UserNotFoundFault(crate::error::UserNotFoundFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateACLError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateACLErrorKind::AclAlreadyExistsFault(_inner) => _inner.fmt(f),
            CreateACLErrorKind::AclQuotaExceededFault(_inner) => _inner.fmt(f),
            CreateACLErrorKind::DefaultUserRequired(_inner) => _inner.fmt(f),
            CreateACLErrorKind::DuplicateUserNameFault(_inner) => _inner.fmt(f),
            CreateACLErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            CreateACLErrorKind::TagQuotaPerResourceExceeded(_inner) => _inner.fmt(f),
            CreateACLErrorKind::UserNotFoundFault(_inner) => _inner.fmt(f),
            CreateACLErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateACLError {
    fn code(&self) -> Option<&str> {
        CreateACLError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateACLError {
    /// Creates a new `CreateACLError`.
    pub fn new(kind: CreateACLErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateACLError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateACLErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateACLError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateACLErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateACLErrorKind::AclAlreadyExistsFault`.
    pub fn is_acl_already_exists_fault(&self) -> bool {
        matches!(&self.kind, CreateACLErrorKind::AclAlreadyExistsFault(_))
    }
    /// Returns true if the error kind is `CreateACLErrorKind::AclQuotaExceededFault`.
    pub fn is_acl_quota_exceeded_fault(&self) -> bool {
        matches!(&self.kind, CreateACLErrorKind::AclQuotaExceededFault(_))
    }
    /// Returns true if the error kind is `CreateACLErrorKind::DefaultUserRequired`.
    pub fn is_default_user_required(&self) -> bool {
        matches!(&self.kind, CreateACLErrorKind::DefaultUserRequired(_))
    }
    /// Returns true if the error kind is `CreateACLErrorKind::DuplicateUserNameFault`.
    pub fn is_duplicate_user_name_fault(&self) -> bool {
        matches!(&self.kind, CreateACLErrorKind::DuplicateUserNameFault(_))
    }
    /// Returns true if the error kind is `CreateACLErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateACLErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns true if the error kind is `CreateACLErrorKind::TagQuotaPerResourceExceeded`.
    pub fn is_tag_quota_per_resource_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            CreateACLErrorKind::TagQuotaPerResourceExceeded(_)
        )
    }
    /// Returns true if the error kind is `CreateACLErrorKind::UserNotFoundFault`.
    pub fn is_user_not_found_fault(&self) -> bool {
        matches!(&self.kind, CreateACLErrorKind::UserNotFoundFault(_))
    }
}
impl std::error::Error for CreateACLError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateACLErrorKind::AclAlreadyExistsFault(_inner) => Some(_inner),
            CreateACLErrorKind::AclQuotaExceededFault(_inner) => Some(_inner),
            CreateACLErrorKind::DefaultUserRequired(_inner) => Some(_inner),
            CreateACLErrorKind::DuplicateUserNameFault(_inner) => Some(_inner),
            CreateACLErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            CreateACLErrorKind::TagQuotaPerResourceExceeded(_inner) => Some(_inner),
            CreateACLErrorKind::UserNotFoundFault(_inner) => Some(_inner),
            CreateACLErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateClusterError {
    /// Kind of error that occurred.
    pub kind: CreateClusterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateClusterErrorKind {
    /// <p></p>
    AclNotFoundFault(crate::error::AclNotFoundFault),
    /// <p></p>
    ClusterAlreadyExistsFault(crate::error::ClusterAlreadyExistsFault),
    /// <p></p>
    ClusterQuotaForCustomerExceededFault(crate::error::ClusterQuotaForCustomerExceededFault),
    /// <p></p>
    InsufficientClusterCapacityFault(crate::error::InsufficientClusterCapacityFault),
    /// <p></p>
    InvalidAclStateFault(crate::error::InvalidAclStateFault),
    /// <p></p>
    InvalidCredentialsException(crate::error::InvalidCredentialsException),
    /// <p></p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p></p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p></p>
    InvalidVpcNetworkStateFault(crate::error::InvalidVpcNetworkStateFault),
    /// <p></p>
    NodeQuotaForClusterExceededFault(crate::error::NodeQuotaForClusterExceededFault),
    /// <p></p>
    NodeQuotaForCustomerExceededFault(crate::error::NodeQuotaForCustomerExceededFault),
    /// <p></p>
    ParameterGroupNotFoundFault(crate::error::ParameterGroupNotFoundFault),
    /// <p></p>
    ServiceLinkedRoleNotFoundFault(crate::error::ServiceLinkedRoleNotFoundFault),
    /// <p></p>
    ShardsPerClusterQuotaExceededFault(crate::error::ShardsPerClusterQuotaExceededFault),
    /// <p></p>
    SubnetGroupNotFoundFault(crate::error::SubnetGroupNotFoundFault),
    /// <p></p>
    TagQuotaPerResourceExceeded(crate::error::TagQuotaPerResourceExceeded),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateClusterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateClusterErrorKind::AclNotFoundFault(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::ClusterAlreadyExistsFault(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::ClusterQuotaForCustomerExceededFault(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::InsufficientClusterCapacityFault(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::InvalidAclStateFault(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::InvalidCredentialsException(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::InvalidParameterCombinationException(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::InvalidVpcNetworkStateFault(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::NodeQuotaForClusterExceededFault(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::NodeQuotaForCustomerExceededFault(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::ParameterGroupNotFoundFault(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::ShardsPerClusterQuotaExceededFault(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::SubnetGroupNotFoundFault(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::TagQuotaPerResourceExceeded(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateClusterError {
    fn code(&self) -> Option<&str> {
        CreateClusterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateClusterError {
    /// Creates a new `CreateClusterError`.
    pub fn new(kind: CreateClusterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateClusterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateClusterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateClusterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateClusterErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateClusterErrorKind::AclNotFoundFault`.
    pub fn is_acl_not_found_fault(&self) -> bool {
        matches!(&self.kind, CreateClusterErrorKind::AclNotFoundFault(_))
    }
    /// Returns true if the error kind is `CreateClusterErrorKind::ClusterAlreadyExistsFault`.
    pub fn is_cluster_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterErrorKind::ClusterAlreadyExistsFault(_)
        )
    }
    /// Returns true if the error kind is `CreateClusterErrorKind::ClusterQuotaForCustomerExceededFault`.
    pub fn is_cluster_quota_for_customer_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterErrorKind::ClusterQuotaForCustomerExceededFault(_)
        )
    }
    /// Returns true if the error kind is `CreateClusterErrorKind::InsufficientClusterCapacityFault`.
    pub fn is_insufficient_cluster_capacity_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterErrorKind::InsufficientClusterCapacityFault(_)
        )
    }
    /// Returns true if the error kind is `CreateClusterErrorKind::InvalidAclStateFault`.
    pub fn is_invalid_acl_state_fault(&self) -> bool {
        matches!(&self.kind, CreateClusterErrorKind::InvalidAclStateFault(_))
    }
    /// Returns true if the error kind is `CreateClusterErrorKind::InvalidCredentialsException`.
    pub fn is_invalid_credentials_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterErrorKind::InvalidCredentialsException(_)
        )
    }
    /// Returns true if the error kind is `CreateClusterErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns true if the error kind is `CreateClusterErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns true if the error kind is `CreateClusterErrorKind::InvalidVpcNetworkStateFault`.
    pub fn is_invalid_vpc_network_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterErrorKind::InvalidVpcNetworkStateFault(_)
        )
    }
    /// Returns true if the error kind is `CreateClusterErrorKind::NodeQuotaForClusterExceededFault`.
    pub fn is_node_quota_for_cluster_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterErrorKind::NodeQuotaForClusterExceededFault(_)
        )
    }
    /// Returns true if the error kind is `CreateClusterErrorKind::NodeQuotaForCustomerExceededFault`.
    pub fn is_node_quota_for_customer_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterErrorKind::NodeQuotaForCustomerExceededFault(_)
        )
    }
    /// Returns true if the error kind is `CreateClusterErrorKind::ParameterGroupNotFoundFault`.
    pub fn is_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterErrorKind::ParameterGroupNotFoundFault(_)
        )
    }
    /// Returns true if the error kind is `CreateClusterErrorKind::ServiceLinkedRoleNotFoundFault`.
    pub fn is_service_linked_role_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterErrorKind::ServiceLinkedRoleNotFoundFault(_)
        )
    }
    /// Returns true if the error kind is `CreateClusterErrorKind::ShardsPerClusterQuotaExceededFault`.
    pub fn is_shards_per_cluster_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterErrorKind::ShardsPerClusterQuotaExceededFault(_)
        )
    }
    /// Returns true if the error kind is `CreateClusterErrorKind::SubnetGroupNotFoundFault`.
    pub fn is_subnet_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterErrorKind::SubnetGroupNotFoundFault(_)
        )
    }
    /// Returns true if the error kind is `CreateClusterErrorKind::TagQuotaPerResourceExceeded`.
    pub fn is_tag_quota_per_resource_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterErrorKind::TagQuotaPerResourceExceeded(_)
        )
    }
}
impl std::error::Error for CreateClusterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateClusterErrorKind::AclNotFoundFault(_inner) => Some(_inner),
            CreateClusterErrorKind::ClusterAlreadyExistsFault(_inner) => Some(_inner),
            CreateClusterErrorKind::ClusterQuotaForCustomerExceededFault(_inner) => Some(_inner),
            CreateClusterErrorKind::InsufficientClusterCapacityFault(_inner) => Some(_inner),
            CreateClusterErrorKind::InvalidAclStateFault(_inner) => Some(_inner),
            CreateClusterErrorKind::InvalidCredentialsException(_inner) => Some(_inner),
            CreateClusterErrorKind::InvalidParameterCombinationException(_inner) => Some(_inner),
            CreateClusterErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            CreateClusterErrorKind::InvalidVpcNetworkStateFault(_inner) => Some(_inner),
            CreateClusterErrorKind::NodeQuotaForClusterExceededFault(_inner) => Some(_inner),
            CreateClusterErrorKind::NodeQuotaForCustomerExceededFault(_inner) => Some(_inner),
            CreateClusterErrorKind::ParameterGroupNotFoundFault(_inner) => Some(_inner),
            CreateClusterErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => Some(_inner),
            CreateClusterErrorKind::ShardsPerClusterQuotaExceededFault(_inner) => Some(_inner),
            CreateClusterErrorKind::SubnetGroupNotFoundFault(_inner) => Some(_inner),
            CreateClusterErrorKind::TagQuotaPerResourceExceeded(_inner) => Some(_inner),
            CreateClusterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateParameterGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateParameterGroupError {
    /// Kind of error that occurred.
    pub kind: CreateParameterGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateParameterGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateParameterGroupErrorKind {
    /// <p></p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p></p>
    InvalidParameterGroupStateFault(crate::error::InvalidParameterGroupStateFault),
    /// <p></p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p></p>
    ParameterGroupAlreadyExistsFault(crate::error::ParameterGroupAlreadyExistsFault),
    /// <p></p>
    ParameterGroupQuotaExceededFault(crate::error::ParameterGroupQuotaExceededFault),
    /// <p></p>
    ServiceLinkedRoleNotFoundFault(crate::error::ServiceLinkedRoleNotFoundFault),
    /// <p></p>
    TagQuotaPerResourceExceeded(crate::error::TagQuotaPerResourceExceeded),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateParameterGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateParameterGroupErrorKind::InvalidParameterCombinationException(_inner) => {
                _inner.fmt(f)
            }
            CreateParameterGroupErrorKind::InvalidParameterGroupStateFault(_inner) => _inner.fmt(f),
            CreateParameterGroupErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            CreateParameterGroupErrorKind::ParameterGroupAlreadyExistsFault(_inner) => {
                _inner.fmt(f)
            }
            CreateParameterGroupErrorKind::ParameterGroupQuotaExceededFault(_inner) => {
                _inner.fmt(f)
            }
            CreateParameterGroupErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => _inner.fmt(f),
            CreateParameterGroupErrorKind::TagQuotaPerResourceExceeded(_inner) => _inner.fmt(f),
            CreateParameterGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateParameterGroupError {
    fn code(&self) -> Option<&str> {
        CreateParameterGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateParameterGroupError {
    /// Creates a new `CreateParameterGroupError`.
    pub fn new(kind: CreateParameterGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateParameterGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateParameterGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateParameterGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateParameterGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateParameterGroupErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateParameterGroupErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns true if the error kind is `CreateParameterGroupErrorKind::InvalidParameterGroupStateFault`.
    pub fn is_invalid_parameter_group_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateParameterGroupErrorKind::InvalidParameterGroupStateFault(_)
        )
    }
    /// Returns true if the error kind is `CreateParameterGroupErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateParameterGroupErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns true if the error kind is `CreateParameterGroupErrorKind::ParameterGroupAlreadyExistsFault`.
    pub fn is_parameter_group_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateParameterGroupErrorKind::ParameterGroupAlreadyExistsFault(_)
        )
    }
    /// Returns true if the error kind is `CreateParameterGroupErrorKind::ParameterGroupQuotaExceededFault`.
    pub fn is_parameter_group_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateParameterGroupErrorKind::ParameterGroupQuotaExceededFault(_)
        )
    }
    /// Returns true if the error kind is `CreateParameterGroupErrorKind::ServiceLinkedRoleNotFoundFault`.
    pub fn is_service_linked_role_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateParameterGroupErrorKind::ServiceLinkedRoleNotFoundFault(_)
        )
    }
    /// Returns true if the error kind is `CreateParameterGroupErrorKind::TagQuotaPerResourceExceeded`.
    pub fn is_tag_quota_per_resource_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            CreateParameterGroupErrorKind::TagQuotaPerResourceExceeded(_)
        )
    }
}
impl std::error::Error for CreateParameterGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateParameterGroupErrorKind::InvalidParameterCombinationException(_inner) => {
                Some(_inner)
            }
            CreateParameterGroupErrorKind::InvalidParameterGroupStateFault(_inner) => Some(_inner),
            CreateParameterGroupErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            CreateParameterGroupErrorKind::ParameterGroupAlreadyExistsFault(_inner) => Some(_inner),
            CreateParameterGroupErrorKind::ParameterGroupQuotaExceededFault(_inner) => Some(_inner),
            CreateParameterGroupErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => Some(_inner),
            CreateParameterGroupErrorKind::TagQuotaPerResourceExceeded(_inner) => Some(_inner),
            CreateParameterGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateSnapshotError {
    /// Kind of error that occurred.
    pub kind: CreateSnapshotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateSnapshotErrorKind {
    /// <p></p>
    ClusterNotFoundFault(crate::error::ClusterNotFoundFault),
    /// <p></p>
    InvalidClusterStateFault(crate::error::InvalidClusterStateFault),
    /// <p></p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p></p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p></p>
    ServiceLinkedRoleNotFoundFault(crate::error::ServiceLinkedRoleNotFoundFault),
    /// <p></p>
    SnapshotAlreadyExistsFault(crate::error::SnapshotAlreadyExistsFault),
    /// <p></p>
    SnapshotQuotaExceededFault(crate::error::SnapshotQuotaExceededFault),
    /// <p></p>
    TagQuotaPerResourceExceeded(crate::error::TagQuotaPerResourceExceeded),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateSnapshotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateSnapshotErrorKind::ClusterNotFoundFault(_inner) => _inner.fmt(f),
            CreateSnapshotErrorKind::InvalidClusterStateFault(_inner) => _inner.fmt(f),
            CreateSnapshotErrorKind::InvalidParameterCombinationException(_inner) => _inner.fmt(f),
            CreateSnapshotErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            CreateSnapshotErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => _inner.fmt(f),
            CreateSnapshotErrorKind::SnapshotAlreadyExistsFault(_inner) => _inner.fmt(f),
            CreateSnapshotErrorKind::SnapshotQuotaExceededFault(_inner) => _inner.fmt(f),
            CreateSnapshotErrorKind::TagQuotaPerResourceExceeded(_inner) => _inner.fmt(f),
            CreateSnapshotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateSnapshotError {
    fn code(&self) -> Option<&str> {
        CreateSnapshotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateSnapshotError {
    /// Creates a new `CreateSnapshotError`.
    pub fn new(kind: CreateSnapshotErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateSnapshotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateSnapshotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateSnapshotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateSnapshotErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateSnapshotErrorKind::ClusterNotFoundFault`.
    pub fn is_cluster_not_found_fault(&self) -> bool {
        matches!(&self.kind, CreateSnapshotErrorKind::ClusterNotFoundFault(_))
    }
    /// Returns true if the error kind is `CreateSnapshotErrorKind::InvalidClusterStateFault`.
    pub fn is_invalid_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateSnapshotErrorKind::InvalidClusterStateFault(_)
        )
    }
    /// Returns true if the error kind is `CreateSnapshotErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSnapshotErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns true if the error kind is `CreateSnapshotErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSnapshotErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns true if the error kind is `CreateSnapshotErrorKind::ServiceLinkedRoleNotFoundFault`.
    pub fn is_service_linked_role_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateSnapshotErrorKind::ServiceLinkedRoleNotFoundFault(_)
        )
    }
    /// Returns true if the error kind is `CreateSnapshotErrorKind::SnapshotAlreadyExistsFault`.
    pub fn is_snapshot_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateSnapshotErrorKind::SnapshotAlreadyExistsFault(_)
        )
    }
    /// Returns true if the error kind is `CreateSnapshotErrorKind::SnapshotQuotaExceededFault`.
    pub fn is_snapshot_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateSnapshotErrorKind::SnapshotQuotaExceededFault(_)
        )
    }
    /// Returns true if the error kind is `CreateSnapshotErrorKind::TagQuotaPerResourceExceeded`.
    pub fn is_tag_quota_per_resource_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            CreateSnapshotErrorKind::TagQuotaPerResourceExceeded(_)
        )
    }
}
impl std::error::Error for CreateSnapshotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateSnapshotErrorKind::ClusterNotFoundFault(_inner) => Some(_inner),
            CreateSnapshotErrorKind::InvalidClusterStateFault(_inner) => Some(_inner),
            CreateSnapshotErrorKind::InvalidParameterCombinationException(_inner) => Some(_inner),
            CreateSnapshotErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            CreateSnapshotErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => Some(_inner),
            CreateSnapshotErrorKind::SnapshotAlreadyExistsFault(_inner) => Some(_inner),
            CreateSnapshotErrorKind::SnapshotQuotaExceededFault(_inner) => Some(_inner),
            CreateSnapshotErrorKind::TagQuotaPerResourceExceeded(_inner) => Some(_inner),
            CreateSnapshotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateSubnetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateSubnetGroupError {
    /// Kind of error that occurred.
    pub kind: CreateSubnetGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateSubnetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateSubnetGroupErrorKind {
    /// <p></p>
    InvalidSubnet(crate::error::InvalidSubnet),
    /// <p></p>
    ServiceLinkedRoleNotFoundFault(crate::error::ServiceLinkedRoleNotFoundFault),
    /// <p></p>
    SubnetGroupAlreadyExistsFault(crate::error::SubnetGroupAlreadyExistsFault),
    /// <p></p>
    SubnetGroupQuotaExceededFault(crate::error::SubnetGroupQuotaExceededFault),
    /// <p></p>
    SubnetNotAllowedFault(crate::error::SubnetNotAllowedFault),
    /// <p></p>
    SubnetQuotaExceededFault(crate::error::SubnetQuotaExceededFault),
    /// <p></p>
    TagQuotaPerResourceExceeded(crate::error::TagQuotaPerResourceExceeded),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateSubnetGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateSubnetGroupErrorKind::InvalidSubnet(_inner) => _inner.fmt(f),
            CreateSubnetGroupErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => _inner.fmt(f),
            CreateSubnetGroupErrorKind::SubnetGroupAlreadyExistsFault(_inner) => _inner.fmt(f),
            CreateSubnetGroupErrorKind::SubnetGroupQuotaExceededFault(_inner) => _inner.fmt(f),
            CreateSubnetGroupErrorKind::SubnetNotAllowedFault(_inner) => _inner.fmt(f),
            CreateSubnetGroupErrorKind::SubnetQuotaExceededFault(_inner) => _inner.fmt(f),
            CreateSubnetGroupErrorKind::TagQuotaPerResourceExceeded(_inner) => _inner.fmt(f),
            CreateSubnetGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateSubnetGroupError {
    fn code(&self) -> Option<&str> {
        CreateSubnetGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateSubnetGroupError {
    /// Creates a new `CreateSubnetGroupError`.
    pub fn new(kind: CreateSubnetGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateSubnetGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateSubnetGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateSubnetGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateSubnetGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateSubnetGroupErrorKind::InvalidSubnet`.
    pub fn is_invalid_subnet(&self) -> bool {
        matches!(&self.kind, CreateSubnetGroupErrorKind::InvalidSubnet(_))
    }
    /// Returns true if the error kind is `CreateSubnetGroupErrorKind::ServiceLinkedRoleNotFoundFault`.
    pub fn is_service_linked_role_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateSubnetGroupErrorKind::ServiceLinkedRoleNotFoundFault(_)
        )
    }
    /// Returns true if the error kind is `CreateSubnetGroupErrorKind::SubnetGroupAlreadyExistsFault`.
    pub fn is_subnet_group_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateSubnetGroupErrorKind::SubnetGroupAlreadyExistsFault(_)
        )
    }
    /// Returns true if the error kind is `CreateSubnetGroupErrorKind::SubnetGroupQuotaExceededFault`.
    pub fn is_subnet_group_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateSubnetGroupErrorKind::SubnetGroupQuotaExceededFault(_)
        )
    }
    /// Returns true if the error kind is `CreateSubnetGroupErrorKind::SubnetNotAllowedFault`.
    pub fn is_subnet_not_allowed_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateSubnetGroupErrorKind::SubnetNotAllowedFault(_)
        )
    }
    /// Returns true if the error kind is `CreateSubnetGroupErrorKind::SubnetQuotaExceededFault`.
    pub fn is_subnet_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateSubnetGroupErrorKind::SubnetQuotaExceededFault(_)
        )
    }
    /// Returns true if the error kind is `CreateSubnetGroupErrorKind::TagQuotaPerResourceExceeded`.
    pub fn is_tag_quota_per_resource_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            CreateSubnetGroupErrorKind::TagQuotaPerResourceExceeded(_)
        )
    }
}
impl std::error::Error for CreateSubnetGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateSubnetGroupErrorKind::InvalidSubnet(_inner) => Some(_inner),
            CreateSubnetGroupErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => Some(_inner),
            CreateSubnetGroupErrorKind::SubnetGroupAlreadyExistsFault(_inner) => Some(_inner),
            CreateSubnetGroupErrorKind::SubnetGroupQuotaExceededFault(_inner) => Some(_inner),
            CreateSubnetGroupErrorKind::SubnetNotAllowedFault(_inner) => Some(_inner),
            CreateSubnetGroupErrorKind::SubnetQuotaExceededFault(_inner) => Some(_inner),
            CreateSubnetGroupErrorKind::TagQuotaPerResourceExceeded(_inner) => Some(_inner),
            CreateSubnetGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateUserError {
    /// Kind of error that occurred.
    pub kind: CreateUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateUserErrorKind {
    /// <p></p>
    DuplicateUserNameFault(crate::error::DuplicateUserNameFault),
    /// <p></p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p></p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p></p>
    TagQuotaPerResourceExceeded(crate::error::TagQuotaPerResourceExceeded),
    /// <p></p>
    UserAlreadyExistsFault(crate::error::UserAlreadyExistsFault),
    /// <p></p>
    UserQuotaExceededFault(crate::error::UserQuotaExceededFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateUserErrorKind::DuplicateUserNameFault(_inner) => _inner.fmt(f),
            CreateUserErrorKind::InvalidParameterCombinationException(_inner) => _inner.fmt(f),
            CreateUserErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            CreateUserErrorKind::TagQuotaPerResourceExceeded(_inner) => _inner.fmt(f),
            CreateUserErrorKind::UserAlreadyExistsFault(_inner) => _inner.fmt(f),
            CreateUserErrorKind::UserQuotaExceededFault(_inner) => _inner.fmt(f),
            CreateUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateUserError {
    fn code(&self) -> Option<&str> {
        CreateUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateUserError {
    /// Creates a new `CreateUserError`.
    pub fn new(kind: CreateUserErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateUserErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateUserErrorKind::DuplicateUserNameFault`.
    pub fn is_duplicate_user_name_fault(&self) -> bool {
        matches!(&self.kind, CreateUserErrorKind::DuplicateUserNameFault(_))
    }
    /// Returns true if the error kind is `CreateUserErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns true if the error kind is `CreateUserErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns true if the error kind is `CreateUserErrorKind::TagQuotaPerResourceExceeded`.
    pub fn is_tag_quota_per_resource_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserErrorKind::TagQuotaPerResourceExceeded(_)
        )
    }
    /// Returns true if the error kind is `CreateUserErrorKind::UserAlreadyExistsFault`.
    pub fn is_user_already_exists_fault(&self) -> bool {
        matches!(&self.kind, CreateUserErrorKind::UserAlreadyExistsFault(_))
    }
    /// Returns true if the error kind is `CreateUserErrorKind::UserQuotaExceededFault`.
    pub fn is_user_quota_exceeded_fault(&self) -> bool {
        matches!(&self.kind, CreateUserErrorKind::UserQuotaExceededFault(_))
    }
}
impl std::error::Error for CreateUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateUserErrorKind::DuplicateUserNameFault(_inner) => Some(_inner),
            CreateUserErrorKind::InvalidParameterCombinationException(_inner) => Some(_inner),
            CreateUserErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            CreateUserErrorKind::TagQuotaPerResourceExceeded(_inner) => Some(_inner),
            CreateUserErrorKind::UserAlreadyExistsFault(_inner) => Some(_inner),
            CreateUserErrorKind::UserQuotaExceededFault(_inner) => Some(_inner),
            CreateUserErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteACL` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteACLError {
    /// Kind of error that occurred.
    pub kind: DeleteACLErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteACL` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteACLErrorKind {
    /// <p></p>
    AclNotFoundFault(crate::error::AclNotFoundFault),
    /// <p></p>
    InvalidAclStateFault(crate::error::InvalidAclStateFault),
    /// <p></p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteACLError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteACLErrorKind::AclNotFoundFault(_inner) => _inner.fmt(f),
            DeleteACLErrorKind::InvalidAclStateFault(_inner) => _inner.fmt(f),
            DeleteACLErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DeleteACLErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteACLError {
    fn code(&self) -> Option<&str> {
        DeleteACLError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteACLError {
    /// Creates a new `DeleteACLError`.
    pub fn new(kind: DeleteACLErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteACLError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteACLErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteACLError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteACLErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteACLErrorKind::AclNotFoundFault`.
    pub fn is_acl_not_found_fault(&self) -> bool {
        matches!(&self.kind, DeleteACLErrorKind::AclNotFoundFault(_))
    }
    /// Returns true if the error kind is `DeleteACLErrorKind::InvalidAclStateFault`.
    pub fn is_invalid_acl_state_fault(&self) -> bool {
        matches!(&self.kind, DeleteACLErrorKind::InvalidAclStateFault(_))
    }
    /// Returns true if the error kind is `DeleteACLErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteACLErrorKind::InvalidParameterValueException(_)
        )
    }
}
impl std::error::Error for DeleteACLError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteACLErrorKind::AclNotFoundFault(_inner) => Some(_inner),
            DeleteACLErrorKind::InvalidAclStateFault(_inner) => Some(_inner),
            DeleteACLErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DeleteACLErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteClusterError {
    /// Kind of error that occurred.
    pub kind: DeleteClusterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteClusterErrorKind {
    /// <p></p>
    ClusterNotFoundFault(crate::error::ClusterNotFoundFault),
    /// <p></p>
    InvalidClusterStateFault(crate::error::InvalidClusterStateFault),
    /// <p></p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p></p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p></p>
    ServiceLinkedRoleNotFoundFault(crate::error::ServiceLinkedRoleNotFoundFault),
    /// <p></p>
    SnapshotAlreadyExistsFault(crate::error::SnapshotAlreadyExistsFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteClusterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteClusterErrorKind::ClusterNotFoundFault(_inner) => _inner.fmt(f),
            DeleteClusterErrorKind::InvalidClusterStateFault(_inner) => _inner.fmt(f),
            DeleteClusterErrorKind::InvalidParameterCombinationException(_inner) => _inner.fmt(f),
            DeleteClusterErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DeleteClusterErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => _inner.fmt(f),
            DeleteClusterErrorKind::SnapshotAlreadyExistsFault(_inner) => _inner.fmt(f),
            DeleteClusterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteClusterError {
    fn code(&self) -> Option<&str> {
        DeleteClusterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteClusterError {
    /// Creates a new `DeleteClusterError`.
    pub fn new(kind: DeleteClusterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteClusterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteClusterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteClusterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteClusterErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteClusterErrorKind::ClusterNotFoundFault`.
    pub fn is_cluster_not_found_fault(&self) -> bool {
        matches!(&self.kind, DeleteClusterErrorKind::ClusterNotFoundFault(_))
    }
    /// Returns true if the error kind is `DeleteClusterErrorKind::InvalidClusterStateFault`.
    pub fn is_invalid_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteClusterErrorKind::InvalidClusterStateFault(_)
        )
    }
    /// Returns true if the error kind is `DeleteClusterErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteClusterErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns true if the error kind is `DeleteClusterErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteClusterErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns true if the error kind is `DeleteClusterErrorKind::ServiceLinkedRoleNotFoundFault`.
    pub fn is_service_linked_role_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteClusterErrorKind::ServiceLinkedRoleNotFoundFault(_)
        )
    }
    /// Returns true if the error kind is `DeleteClusterErrorKind::SnapshotAlreadyExistsFault`.
    pub fn is_snapshot_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteClusterErrorKind::SnapshotAlreadyExistsFault(_)
        )
    }
}
impl std::error::Error for DeleteClusterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteClusterErrorKind::ClusterNotFoundFault(_inner) => Some(_inner),
            DeleteClusterErrorKind::InvalidClusterStateFault(_inner) => Some(_inner),
            DeleteClusterErrorKind::InvalidParameterCombinationException(_inner) => Some(_inner),
            DeleteClusterErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DeleteClusterErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => Some(_inner),
            DeleteClusterErrorKind::SnapshotAlreadyExistsFault(_inner) => Some(_inner),
            DeleteClusterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteParameterGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteParameterGroupError {
    /// Kind of error that occurred.
    pub kind: DeleteParameterGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteParameterGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteParameterGroupErrorKind {
    /// <p></p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p></p>
    InvalidParameterGroupStateFault(crate::error::InvalidParameterGroupStateFault),
    /// <p></p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p></p>
    ParameterGroupNotFoundFault(crate::error::ParameterGroupNotFoundFault),
    /// <p></p>
    ServiceLinkedRoleNotFoundFault(crate::error::ServiceLinkedRoleNotFoundFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteParameterGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteParameterGroupErrorKind::InvalidParameterCombinationException(_inner) => {
                _inner.fmt(f)
            }
            DeleteParameterGroupErrorKind::InvalidParameterGroupStateFault(_inner) => _inner.fmt(f),
            DeleteParameterGroupErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DeleteParameterGroupErrorKind::ParameterGroupNotFoundFault(_inner) => _inner.fmt(f),
            DeleteParameterGroupErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => _inner.fmt(f),
            DeleteParameterGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteParameterGroupError {
    fn code(&self) -> Option<&str> {
        DeleteParameterGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteParameterGroupError {
    /// Creates a new `DeleteParameterGroupError`.
    pub fn new(kind: DeleteParameterGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteParameterGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteParameterGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteParameterGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteParameterGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteParameterGroupErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteParameterGroupErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns true if the error kind is `DeleteParameterGroupErrorKind::InvalidParameterGroupStateFault`.
    pub fn is_invalid_parameter_group_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteParameterGroupErrorKind::InvalidParameterGroupStateFault(_)
        )
    }
    /// Returns true if the error kind is `DeleteParameterGroupErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteParameterGroupErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns true if the error kind is `DeleteParameterGroupErrorKind::ParameterGroupNotFoundFault`.
    pub fn is_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteParameterGroupErrorKind::ParameterGroupNotFoundFault(_)
        )
    }
    /// Returns true if the error kind is `DeleteParameterGroupErrorKind::ServiceLinkedRoleNotFoundFault`.
    pub fn is_service_linked_role_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteParameterGroupErrorKind::ServiceLinkedRoleNotFoundFault(_)
        )
    }
}
impl std::error::Error for DeleteParameterGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteParameterGroupErrorKind::InvalidParameterCombinationException(_inner) => {
                Some(_inner)
            }
            DeleteParameterGroupErrorKind::InvalidParameterGroupStateFault(_inner) => Some(_inner),
            DeleteParameterGroupErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DeleteParameterGroupErrorKind::ParameterGroupNotFoundFault(_inner) => Some(_inner),
            DeleteParameterGroupErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => Some(_inner),
            DeleteParameterGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteSnapshotError {
    /// Kind of error that occurred.
    pub kind: DeleteSnapshotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteSnapshotErrorKind {
    /// <p></p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p></p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p></p>
    InvalidSnapshotStateFault(crate::error::InvalidSnapshotStateFault),
    /// <p></p>
    ServiceLinkedRoleNotFoundFault(crate::error::ServiceLinkedRoleNotFoundFault),
    /// <p></p>
    SnapshotNotFoundFault(crate::error::SnapshotNotFoundFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteSnapshotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteSnapshotErrorKind::InvalidParameterCombinationException(_inner) => _inner.fmt(f),
            DeleteSnapshotErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DeleteSnapshotErrorKind::InvalidSnapshotStateFault(_inner) => _inner.fmt(f),
            DeleteSnapshotErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => _inner.fmt(f),
            DeleteSnapshotErrorKind::SnapshotNotFoundFault(_inner) => _inner.fmt(f),
            DeleteSnapshotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteSnapshotError {
    fn code(&self) -> Option<&str> {
        DeleteSnapshotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteSnapshotError {
    /// Creates a new `DeleteSnapshotError`.
    pub fn new(kind: DeleteSnapshotErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteSnapshotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteSnapshotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteSnapshotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteSnapshotErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteSnapshotErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSnapshotErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns true if the error kind is `DeleteSnapshotErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSnapshotErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns true if the error kind is `DeleteSnapshotErrorKind::InvalidSnapshotStateFault`.
    pub fn is_invalid_snapshot_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSnapshotErrorKind::InvalidSnapshotStateFault(_)
        )
    }
    /// Returns true if the error kind is `DeleteSnapshotErrorKind::ServiceLinkedRoleNotFoundFault`.
    pub fn is_service_linked_role_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSnapshotErrorKind::ServiceLinkedRoleNotFoundFault(_)
        )
    }
    /// Returns true if the error kind is `DeleteSnapshotErrorKind::SnapshotNotFoundFault`.
    pub fn is_snapshot_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSnapshotErrorKind::SnapshotNotFoundFault(_)
        )
    }
}
impl std::error::Error for DeleteSnapshotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteSnapshotErrorKind::InvalidParameterCombinationException(_inner) => Some(_inner),
            DeleteSnapshotErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DeleteSnapshotErrorKind::InvalidSnapshotStateFault(_inner) => Some(_inner),
            DeleteSnapshotErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => Some(_inner),
            DeleteSnapshotErrorKind::SnapshotNotFoundFault(_inner) => Some(_inner),
            DeleteSnapshotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteSubnetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteSubnetGroupError {
    /// Kind of error that occurred.
    pub kind: DeleteSubnetGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteSubnetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteSubnetGroupErrorKind {
    /// <p></p>
    ServiceLinkedRoleNotFoundFault(crate::error::ServiceLinkedRoleNotFoundFault),
    /// <p></p>
    SubnetGroupInUseFault(crate::error::SubnetGroupInUseFault),
    /// <p></p>
    SubnetGroupNotFoundFault(crate::error::SubnetGroupNotFoundFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteSubnetGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteSubnetGroupErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => _inner.fmt(f),
            DeleteSubnetGroupErrorKind::SubnetGroupInUseFault(_inner) => _inner.fmt(f),
            DeleteSubnetGroupErrorKind::SubnetGroupNotFoundFault(_inner) => _inner.fmt(f),
            DeleteSubnetGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteSubnetGroupError {
    fn code(&self) -> Option<&str> {
        DeleteSubnetGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteSubnetGroupError {
    /// Creates a new `DeleteSubnetGroupError`.
    pub fn new(kind: DeleteSubnetGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteSubnetGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteSubnetGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteSubnetGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteSubnetGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteSubnetGroupErrorKind::ServiceLinkedRoleNotFoundFault`.
    pub fn is_service_linked_role_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSubnetGroupErrorKind::ServiceLinkedRoleNotFoundFault(_)
        )
    }
    /// Returns true if the error kind is `DeleteSubnetGroupErrorKind::SubnetGroupInUseFault`.
    pub fn is_subnet_group_in_use_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSubnetGroupErrorKind::SubnetGroupInUseFault(_)
        )
    }
    /// Returns true if the error kind is `DeleteSubnetGroupErrorKind::SubnetGroupNotFoundFault`.
    pub fn is_subnet_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSubnetGroupErrorKind::SubnetGroupNotFoundFault(_)
        )
    }
}
impl std::error::Error for DeleteSubnetGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteSubnetGroupErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => Some(_inner),
            DeleteSubnetGroupErrorKind::SubnetGroupInUseFault(_inner) => Some(_inner),
            DeleteSubnetGroupErrorKind::SubnetGroupNotFoundFault(_inner) => Some(_inner),
            DeleteSubnetGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteUserError {
    /// Kind of error that occurred.
    pub kind: DeleteUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteUserErrorKind {
    /// <p></p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p></p>
    InvalidUserStateFault(crate::error::InvalidUserStateFault),
    /// <p></p>
    UserNotFoundFault(crate::error::UserNotFoundFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteUserErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DeleteUserErrorKind::InvalidUserStateFault(_inner) => _inner.fmt(f),
            DeleteUserErrorKind::UserNotFoundFault(_inner) => _inner.fmt(f),
            DeleteUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteUserError {
    fn code(&self) -> Option<&str> {
        DeleteUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteUserError {
    /// Creates a new `DeleteUserError`.
    pub fn new(kind: DeleteUserErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteUserErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteUserErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns true if the error kind is `DeleteUserErrorKind::InvalidUserStateFault`.
    pub fn is_invalid_user_state_fault(&self) -> bool {
        matches!(&self.kind, DeleteUserErrorKind::InvalidUserStateFault(_))
    }
    /// Returns true if the error kind is `DeleteUserErrorKind::UserNotFoundFault`.
    pub fn is_user_not_found_fault(&self) -> bool {
        matches!(&self.kind, DeleteUserErrorKind::UserNotFoundFault(_))
    }
}
impl std::error::Error for DeleteUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteUserErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DeleteUserErrorKind::InvalidUserStateFault(_inner) => Some(_inner),
            DeleteUserErrorKind::UserNotFoundFault(_inner) => Some(_inner),
            DeleteUserErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeACLs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeACLsError {
    /// Kind of error that occurred.
    pub kind: DescribeACLsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeACLs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeACLsErrorKind {
    /// <p></p>
    AclNotFoundFault(crate::error::AclNotFoundFault),
    /// <p></p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeACLsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeACLsErrorKind::AclNotFoundFault(_inner) => _inner.fmt(f),
            DescribeACLsErrorKind::InvalidParameterCombinationException(_inner) => _inner.fmt(f),
            DescribeACLsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeACLsError {
    fn code(&self) -> Option<&str> {
        DescribeACLsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeACLsError {
    /// Creates a new `DescribeACLsError`.
    pub fn new(kind: DescribeACLsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeACLsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeACLsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeACLsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeACLsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeACLsErrorKind::AclNotFoundFault`.
    pub fn is_acl_not_found_fault(&self) -> bool {
        matches!(&self.kind, DescribeACLsErrorKind::AclNotFoundFault(_))
    }
    /// Returns true if the error kind is `DescribeACLsErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeACLsErrorKind::InvalidParameterCombinationException(_)
        )
    }
}
impl std::error::Error for DescribeACLsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeACLsErrorKind::AclNotFoundFault(_inner) => Some(_inner),
            DescribeACLsErrorKind::InvalidParameterCombinationException(_inner) => Some(_inner),
            DescribeACLsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeClusters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeClustersError {
    /// Kind of error that occurred.
    pub kind: DescribeClustersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeClusters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeClustersErrorKind {
    /// <p></p>
    ClusterNotFoundFault(crate::error::ClusterNotFoundFault),
    /// <p></p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p></p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p></p>
    ServiceLinkedRoleNotFoundFault(crate::error::ServiceLinkedRoleNotFoundFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeClustersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeClustersErrorKind::ClusterNotFoundFault(_inner) => _inner.fmt(f),
            DescribeClustersErrorKind::InvalidParameterCombinationException(_inner) => {
                _inner.fmt(f)
            }
            DescribeClustersErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DescribeClustersErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => _inner.fmt(f),
            DescribeClustersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeClustersError {
    fn code(&self) -> Option<&str> {
        DescribeClustersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeClustersError {
    /// Creates a new `DescribeClustersError`.
    pub fn new(kind: DescribeClustersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeClustersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeClustersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeClustersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeClustersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeClustersErrorKind::ClusterNotFoundFault`.
    pub fn is_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeClustersErrorKind::ClusterNotFoundFault(_)
        )
    }
    /// Returns true if the error kind is `DescribeClustersErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeClustersErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns true if the error kind is `DescribeClustersErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeClustersErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns true if the error kind is `DescribeClustersErrorKind::ServiceLinkedRoleNotFoundFault`.
    pub fn is_service_linked_role_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeClustersErrorKind::ServiceLinkedRoleNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeClustersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeClustersErrorKind::ClusterNotFoundFault(_inner) => Some(_inner),
            DescribeClustersErrorKind::InvalidParameterCombinationException(_inner) => Some(_inner),
            DescribeClustersErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DescribeClustersErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => Some(_inner),
            DescribeClustersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeEngineVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeEngineVersionsError {
    /// Kind of error that occurred.
    pub kind: DescribeEngineVersionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeEngineVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeEngineVersionsErrorKind {
    /// <p></p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p></p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p></p>
    ServiceLinkedRoleNotFoundFault(crate::error::ServiceLinkedRoleNotFoundFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeEngineVersionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeEngineVersionsErrorKind::InvalidParameterCombinationException(_inner) => {
                _inner.fmt(f)
            }
            DescribeEngineVersionsErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            DescribeEngineVersionsErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            DescribeEngineVersionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeEngineVersionsError {
    fn code(&self) -> Option<&str> {
        DescribeEngineVersionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeEngineVersionsError {
    /// Creates a new `DescribeEngineVersionsError`.
    pub fn new(kind: DescribeEngineVersionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeEngineVersionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeEngineVersionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeEngineVersionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeEngineVersionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeEngineVersionsErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEngineVersionsErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns true if the error kind is `DescribeEngineVersionsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEngineVersionsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns true if the error kind is `DescribeEngineVersionsErrorKind::ServiceLinkedRoleNotFoundFault`.
    pub fn is_service_linked_role_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEngineVersionsErrorKind::ServiceLinkedRoleNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeEngineVersionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeEngineVersionsErrorKind::InvalidParameterCombinationException(_inner) => {
                Some(_inner)
            }
            DescribeEngineVersionsErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DescribeEngineVersionsErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => Some(_inner),
            DescribeEngineVersionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeEvents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeEventsError {
    /// Kind of error that occurred.
    pub kind: DescribeEventsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeEvents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeEventsErrorKind {
    /// <p></p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p></p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p></p>
    ServiceLinkedRoleNotFoundFault(crate::error::ServiceLinkedRoleNotFoundFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeEventsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeEventsErrorKind::InvalidParameterCombinationException(_inner) => _inner.fmt(f),
            DescribeEventsErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DescribeEventsErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => _inner.fmt(f),
            DescribeEventsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeEventsError {
    fn code(&self) -> Option<&str> {
        DescribeEventsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeEventsError {
    /// Creates a new `DescribeEventsError`.
    pub fn new(kind: DescribeEventsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeEventsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeEventsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeEventsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeEventsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeEventsErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEventsErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns true if the error kind is `DescribeEventsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEventsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns true if the error kind is `DescribeEventsErrorKind::ServiceLinkedRoleNotFoundFault`.
    pub fn is_service_linked_role_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEventsErrorKind::ServiceLinkedRoleNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeEventsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeEventsErrorKind::InvalidParameterCombinationException(_inner) => Some(_inner),
            DescribeEventsErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DescribeEventsErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => Some(_inner),
            DescribeEventsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeParameterGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeParameterGroupsError {
    /// Kind of error that occurred.
    pub kind: DescribeParameterGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeParameterGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeParameterGroupsErrorKind {
    /// <p></p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p></p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p></p>
    ParameterGroupNotFoundFault(crate::error::ParameterGroupNotFoundFault),
    /// <p></p>
    ServiceLinkedRoleNotFoundFault(crate::error::ServiceLinkedRoleNotFoundFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeParameterGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeParameterGroupsErrorKind::InvalidParameterCombinationException(_inner) => {
                _inner.fmt(f)
            }
            DescribeParameterGroupsErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            DescribeParameterGroupsErrorKind::ParameterGroupNotFoundFault(_inner) => _inner.fmt(f),
            DescribeParameterGroupsErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            DescribeParameterGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeParameterGroupsError {
    fn code(&self) -> Option<&str> {
        DescribeParameterGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeParameterGroupsError {
    /// Creates a new `DescribeParameterGroupsError`.
    pub fn new(kind: DescribeParameterGroupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeParameterGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeParameterGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeParameterGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeParameterGroupsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeParameterGroupsErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeParameterGroupsErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns true if the error kind is `DescribeParameterGroupsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeParameterGroupsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns true if the error kind is `DescribeParameterGroupsErrorKind::ParameterGroupNotFoundFault`.
    pub fn is_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeParameterGroupsErrorKind::ParameterGroupNotFoundFault(_)
        )
    }
    /// Returns true if the error kind is `DescribeParameterGroupsErrorKind::ServiceLinkedRoleNotFoundFault`.
    pub fn is_service_linked_role_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeParameterGroupsErrorKind::ServiceLinkedRoleNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeParameterGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeParameterGroupsErrorKind::InvalidParameterCombinationException(_inner) => {
                Some(_inner)
            }
            DescribeParameterGroupsErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            DescribeParameterGroupsErrorKind::ParameterGroupNotFoundFault(_inner) => Some(_inner),
            DescribeParameterGroupsErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => {
                Some(_inner)
            }
            DescribeParameterGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeParameters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeParametersError {
    /// Kind of error that occurred.
    pub kind: DescribeParametersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeParameters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeParametersErrorKind {
    /// <p></p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p></p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p></p>
    ParameterGroupNotFoundFault(crate::error::ParameterGroupNotFoundFault),
    /// <p></p>
    ServiceLinkedRoleNotFoundFault(crate::error::ServiceLinkedRoleNotFoundFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeParametersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeParametersErrorKind::InvalidParameterCombinationException(_inner) => {
                _inner.fmt(f)
            }
            DescribeParametersErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DescribeParametersErrorKind::ParameterGroupNotFoundFault(_inner) => _inner.fmt(f),
            DescribeParametersErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => _inner.fmt(f),
            DescribeParametersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeParametersError {
    fn code(&self) -> Option<&str> {
        DescribeParametersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeParametersError {
    /// Creates a new `DescribeParametersError`.
    pub fn new(kind: DescribeParametersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeParametersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeParametersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeParametersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeParametersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeParametersErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeParametersErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns true if the error kind is `DescribeParametersErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeParametersErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns true if the error kind is `DescribeParametersErrorKind::ParameterGroupNotFoundFault`.
    pub fn is_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeParametersErrorKind::ParameterGroupNotFoundFault(_)
        )
    }
    /// Returns true if the error kind is `DescribeParametersErrorKind::ServiceLinkedRoleNotFoundFault`.
    pub fn is_service_linked_role_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeParametersErrorKind::ServiceLinkedRoleNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeParametersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeParametersErrorKind::InvalidParameterCombinationException(_inner) => {
                Some(_inner)
            }
            DescribeParametersErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DescribeParametersErrorKind::ParameterGroupNotFoundFault(_inner) => Some(_inner),
            DescribeParametersErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => Some(_inner),
            DescribeParametersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeServiceUpdates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeServiceUpdatesError {
    /// Kind of error that occurred.
    pub kind: DescribeServiceUpdatesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeServiceUpdates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeServiceUpdatesErrorKind {
    /// <p></p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p></p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeServiceUpdatesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeServiceUpdatesErrorKind::InvalidParameterCombinationException(_inner) => {
                _inner.fmt(f)
            }
            DescribeServiceUpdatesErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            DescribeServiceUpdatesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeServiceUpdatesError {
    fn code(&self) -> Option<&str> {
        DescribeServiceUpdatesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeServiceUpdatesError {
    /// Creates a new `DescribeServiceUpdatesError`.
    pub fn new(kind: DescribeServiceUpdatesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeServiceUpdatesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeServiceUpdatesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeServiceUpdatesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeServiceUpdatesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeServiceUpdatesErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeServiceUpdatesErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns true if the error kind is `DescribeServiceUpdatesErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeServiceUpdatesErrorKind::InvalidParameterValueException(_)
        )
    }
}
impl std::error::Error for DescribeServiceUpdatesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeServiceUpdatesErrorKind::InvalidParameterCombinationException(_inner) => {
                Some(_inner)
            }
            DescribeServiceUpdatesErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DescribeServiceUpdatesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeSnapshots` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeSnapshotsError {
    /// Kind of error that occurred.
    pub kind: DescribeSnapshotsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeSnapshots` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeSnapshotsErrorKind {
    /// <p></p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p></p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p></p>
    ServiceLinkedRoleNotFoundFault(crate::error::ServiceLinkedRoleNotFoundFault),
    /// <p></p>
    SnapshotNotFoundFault(crate::error::SnapshotNotFoundFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeSnapshotsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeSnapshotsErrorKind::InvalidParameterCombinationException(_inner) => {
                _inner.fmt(f)
            }
            DescribeSnapshotsErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DescribeSnapshotsErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => _inner.fmt(f),
            DescribeSnapshotsErrorKind::SnapshotNotFoundFault(_inner) => _inner.fmt(f),
            DescribeSnapshotsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeSnapshotsError {
    fn code(&self) -> Option<&str> {
        DescribeSnapshotsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeSnapshotsError {
    /// Creates a new `DescribeSnapshotsError`.
    pub fn new(kind: DescribeSnapshotsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeSnapshotsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeSnapshotsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeSnapshotsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeSnapshotsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeSnapshotsErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSnapshotsErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns true if the error kind is `DescribeSnapshotsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSnapshotsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns true if the error kind is `DescribeSnapshotsErrorKind::ServiceLinkedRoleNotFoundFault`.
    pub fn is_service_linked_role_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSnapshotsErrorKind::ServiceLinkedRoleNotFoundFault(_)
        )
    }
    /// Returns true if the error kind is `DescribeSnapshotsErrorKind::SnapshotNotFoundFault`.
    pub fn is_snapshot_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSnapshotsErrorKind::SnapshotNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeSnapshotsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeSnapshotsErrorKind::InvalidParameterCombinationException(_inner) => {
                Some(_inner)
            }
            DescribeSnapshotsErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DescribeSnapshotsErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => Some(_inner),
            DescribeSnapshotsErrorKind::SnapshotNotFoundFault(_inner) => Some(_inner),
            DescribeSnapshotsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeSubnetGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeSubnetGroupsError {
    /// Kind of error that occurred.
    pub kind: DescribeSubnetGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeSubnetGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeSubnetGroupsErrorKind {
    /// <p></p>
    ServiceLinkedRoleNotFoundFault(crate::error::ServiceLinkedRoleNotFoundFault),
    /// <p></p>
    SubnetGroupNotFoundFault(crate::error::SubnetGroupNotFoundFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeSubnetGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeSubnetGroupsErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => _inner.fmt(f),
            DescribeSubnetGroupsErrorKind::SubnetGroupNotFoundFault(_inner) => _inner.fmt(f),
            DescribeSubnetGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeSubnetGroupsError {
    fn code(&self) -> Option<&str> {
        DescribeSubnetGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeSubnetGroupsError {
    /// Creates a new `DescribeSubnetGroupsError`.
    pub fn new(kind: DescribeSubnetGroupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeSubnetGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeSubnetGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeSubnetGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeSubnetGroupsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeSubnetGroupsErrorKind::ServiceLinkedRoleNotFoundFault`.
    pub fn is_service_linked_role_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSubnetGroupsErrorKind::ServiceLinkedRoleNotFoundFault(_)
        )
    }
    /// Returns true if the error kind is `DescribeSubnetGroupsErrorKind::SubnetGroupNotFoundFault`.
    pub fn is_subnet_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSubnetGroupsErrorKind::SubnetGroupNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeSubnetGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeSubnetGroupsErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => Some(_inner),
            DescribeSubnetGroupsErrorKind::SubnetGroupNotFoundFault(_inner) => Some(_inner),
            DescribeSubnetGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeUsers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeUsersError {
    /// Kind of error that occurred.
    pub kind: DescribeUsersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeUsers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeUsersErrorKind {
    /// <p></p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p></p>
    UserNotFoundFault(crate::error::UserNotFoundFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeUsersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeUsersErrorKind::InvalidParameterCombinationException(_inner) => _inner.fmt(f),
            DescribeUsersErrorKind::UserNotFoundFault(_inner) => _inner.fmt(f),
            DescribeUsersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeUsersError {
    fn code(&self) -> Option<&str> {
        DescribeUsersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeUsersError {
    /// Creates a new `DescribeUsersError`.
    pub fn new(kind: DescribeUsersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeUsersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeUsersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeUsersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeUsersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeUsersErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeUsersErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns true if the error kind is `DescribeUsersErrorKind::UserNotFoundFault`.
    pub fn is_user_not_found_fault(&self) -> bool {
        matches!(&self.kind, DescribeUsersErrorKind::UserNotFoundFault(_))
    }
}
impl std::error::Error for DescribeUsersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeUsersErrorKind::InvalidParameterCombinationException(_inner) => Some(_inner),
            DescribeUsersErrorKind::UserNotFoundFault(_inner) => Some(_inner),
            DescribeUsersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `FailoverShard` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct FailoverShardError {
    /// Kind of error that occurred.
    pub kind: FailoverShardErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `FailoverShard` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum FailoverShardErrorKind {
    /// <p></p>
    ApiCallRateForCustomerExceededFault(crate::error::ApiCallRateForCustomerExceededFault),
    /// <p></p>
    ClusterNotFoundFault(crate::error::ClusterNotFoundFault),
    /// <p></p>
    InvalidClusterStateFault(crate::error::InvalidClusterStateFault),
    /// <p></p>
    InvalidKmsKeyFault(crate::error::InvalidKmsKeyFault),
    /// <p></p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p></p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p></p>
    ShardNotFoundFault(crate::error::ShardNotFoundFault),
    /// <p></p>
    TestFailoverNotAvailableFault(crate::error::TestFailoverNotAvailableFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for FailoverShardError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            FailoverShardErrorKind::ApiCallRateForCustomerExceededFault(_inner) => _inner.fmt(f),
            FailoverShardErrorKind::ClusterNotFoundFault(_inner) => _inner.fmt(f),
            FailoverShardErrorKind::InvalidClusterStateFault(_inner) => _inner.fmt(f),
            FailoverShardErrorKind::InvalidKmsKeyFault(_inner) => _inner.fmt(f),
            FailoverShardErrorKind::InvalidParameterCombinationException(_inner) => _inner.fmt(f),
            FailoverShardErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            FailoverShardErrorKind::ShardNotFoundFault(_inner) => _inner.fmt(f),
            FailoverShardErrorKind::TestFailoverNotAvailableFault(_inner) => _inner.fmt(f),
            FailoverShardErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for FailoverShardError {
    fn code(&self) -> Option<&str> {
        FailoverShardError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl FailoverShardError {
    /// Creates a new `FailoverShardError`.
    pub fn new(kind: FailoverShardErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `FailoverShardError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: FailoverShardErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `FailoverShardError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: FailoverShardErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `FailoverShardErrorKind::ApiCallRateForCustomerExceededFault`.
    pub fn is_api_call_rate_for_customer_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            FailoverShardErrorKind::ApiCallRateForCustomerExceededFault(_)
        )
    }
    /// Returns true if the error kind is `FailoverShardErrorKind::ClusterNotFoundFault`.
    pub fn is_cluster_not_found_fault(&self) -> bool {
        matches!(&self.kind, FailoverShardErrorKind::ClusterNotFoundFault(_))
    }
    /// Returns true if the error kind is `FailoverShardErrorKind::InvalidClusterStateFault`.
    pub fn is_invalid_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            FailoverShardErrorKind::InvalidClusterStateFault(_)
        )
    }
    /// Returns true if the error kind is `FailoverShardErrorKind::InvalidKmsKeyFault`.
    pub fn is_invalid_kms_key_fault(&self) -> bool {
        matches!(&self.kind, FailoverShardErrorKind::InvalidKmsKeyFault(_))
    }
    /// Returns true if the error kind is `FailoverShardErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            FailoverShardErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns true if the error kind is `FailoverShardErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            FailoverShardErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns true if the error kind is `FailoverShardErrorKind::ShardNotFoundFault`.
    pub fn is_shard_not_found_fault(&self) -> bool {
        matches!(&self.kind, FailoverShardErrorKind::ShardNotFoundFault(_))
    }
    /// Returns true if the error kind is `FailoverShardErrorKind::TestFailoverNotAvailableFault`.
    pub fn is_test_failover_not_available_fault(&self) -> bool {
        matches!(
            &self.kind,
            FailoverShardErrorKind::TestFailoverNotAvailableFault(_)
        )
    }
}
impl std::error::Error for FailoverShardError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            FailoverShardErrorKind::ApiCallRateForCustomerExceededFault(_inner) => Some(_inner),
            FailoverShardErrorKind::ClusterNotFoundFault(_inner) => Some(_inner),
            FailoverShardErrorKind::InvalidClusterStateFault(_inner) => Some(_inner),
            FailoverShardErrorKind::InvalidKmsKeyFault(_inner) => Some(_inner),
            FailoverShardErrorKind::InvalidParameterCombinationException(_inner) => Some(_inner),
            FailoverShardErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            FailoverShardErrorKind::ShardNotFoundFault(_inner) => Some(_inner),
            FailoverShardErrorKind::TestFailoverNotAvailableFault(_inner) => Some(_inner),
            FailoverShardErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAllowedNodeTypeUpdates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAllowedNodeTypeUpdatesError {
    /// Kind of error that occurred.
    pub kind: ListAllowedNodeTypeUpdatesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAllowedNodeTypeUpdates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAllowedNodeTypeUpdatesErrorKind {
    /// <p></p>
    ClusterNotFoundFault(crate::error::ClusterNotFoundFault),
    /// <p></p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p></p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p></p>
    ServiceLinkedRoleNotFoundFault(crate::error::ServiceLinkedRoleNotFoundFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAllowedNodeTypeUpdatesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAllowedNodeTypeUpdatesErrorKind::ClusterNotFoundFault(_inner) => _inner.fmt(f),
            ListAllowedNodeTypeUpdatesErrorKind::InvalidParameterCombinationException(_inner) => {
                _inner.fmt(f)
            }
            ListAllowedNodeTypeUpdatesErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            ListAllowedNodeTypeUpdatesErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            ListAllowedNodeTypeUpdatesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAllowedNodeTypeUpdatesError {
    fn code(&self) -> Option<&str> {
        ListAllowedNodeTypeUpdatesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAllowedNodeTypeUpdatesError {
    /// Creates a new `ListAllowedNodeTypeUpdatesError`.
    pub fn new(kind: ListAllowedNodeTypeUpdatesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAllowedNodeTypeUpdatesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAllowedNodeTypeUpdatesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAllowedNodeTypeUpdatesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAllowedNodeTypeUpdatesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListAllowedNodeTypeUpdatesErrorKind::ClusterNotFoundFault`.
    pub fn is_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ListAllowedNodeTypeUpdatesErrorKind::ClusterNotFoundFault(_)
        )
    }
    /// Returns true if the error kind is `ListAllowedNodeTypeUpdatesErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAllowedNodeTypeUpdatesErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns true if the error kind is `ListAllowedNodeTypeUpdatesErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAllowedNodeTypeUpdatesErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns true if the error kind is `ListAllowedNodeTypeUpdatesErrorKind::ServiceLinkedRoleNotFoundFault`.
    pub fn is_service_linked_role_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ListAllowedNodeTypeUpdatesErrorKind::ServiceLinkedRoleNotFoundFault(_)
        )
    }
}
impl std::error::Error for ListAllowedNodeTypeUpdatesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAllowedNodeTypeUpdatesErrorKind::ClusterNotFoundFault(_inner) => Some(_inner),
            ListAllowedNodeTypeUpdatesErrorKind::InvalidParameterCombinationException(_inner) => {
                Some(_inner)
            }
            ListAllowedNodeTypeUpdatesErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            ListAllowedNodeTypeUpdatesErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => {
                Some(_inner)
            }
            ListAllowedNodeTypeUpdatesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsError {
    /// Kind of error that occurred.
    pub kind: ListTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsErrorKind {
    /// <p></p>
    AclNotFoundFault(crate::error::AclNotFoundFault),
    /// <p></p>
    ClusterNotFoundFault(crate::error::ClusterNotFoundFault),
    /// <p></p>
    InvalidArnFault(crate::error::InvalidArnFault),
    /// <p></p>
    InvalidClusterStateFault(crate::error::InvalidClusterStateFault),
    /// <p></p>
    ParameterGroupNotFoundFault(crate::error::ParameterGroupNotFoundFault),
    /// <p></p>
    ServiceLinkedRoleNotFoundFault(crate::error::ServiceLinkedRoleNotFoundFault),
    /// <p></p>
    SnapshotNotFoundFault(crate::error::SnapshotNotFoundFault),
    /// <p></p>
    SubnetGroupNotFoundFault(crate::error::SubnetGroupNotFoundFault),
    /// <p></p>
    UserNotFoundFault(crate::error::UserNotFoundFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsErrorKind::AclNotFoundFault(_inner) => _inner.fmt(f),
            ListTagsErrorKind::ClusterNotFoundFault(_inner) => _inner.fmt(f),
            ListTagsErrorKind::InvalidArnFault(_inner) => _inner.fmt(f),
            ListTagsErrorKind::InvalidClusterStateFault(_inner) => _inner.fmt(f),
            ListTagsErrorKind::ParameterGroupNotFoundFault(_inner) => _inner.fmt(f),
            ListTagsErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => _inner.fmt(f),
            ListTagsErrorKind::SnapshotNotFoundFault(_inner) => _inner.fmt(f),
            ListTagsErrorKind::SubnetGroupNotFoundFault(_inner) => _inner.fmt(f),
            ListTagsErrorKind::UserNotFoundFault(_inner) => _inner.fmt(f),
            ListTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsError {
    fn code(&self) -> Option<&str> {
        ListTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsError {
    /// Creates a new `ListTagsError`.
    pub fn new(kind: ListTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListTagsErrorKind::AclNotFoundFault`.
    pub fn is_acl_not_found_fault(&self) -> bool {
        matches!(&self.kind, ListTagsErrorKind::AclNotFoundFault(_))
    }
    /// Returns true if the error kind is `ListTagsErrorKind::ClusterNotFoundFault`.
    pub fn is_cluster_not_found_fault(&self) -> bool {
        matches!(&self.kind, ListTagsErrorKind::ClusterNotFoundFault(_))
    }
    /// Returns true if the error kind is `ListTagsErrorKind::InvalidArnFault`.
    pub fn is_invalid_arn_fault(&self) -> bool {
        matches!(&self.kind, ListTagsErrorKind::InvalidArnFault(_))
    }
    /// Returns true if the error kind is `ListTagsErrorKind::InvalidClusterStateFault`.
    pub fn is_invalid_cluster_state_fault(&self) -> bool {
        matches!(&self.kind, ListTagsErrorKind::InvalidClusterStateFault(_))
    }
    /// Returns true if the error kind is `ListTagsErrorKind::ParameterGroupNotFoundFault`.
    pub fn is_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsErrorKind::ParameterGroupNotFoundFault(_)
        )
    }
    /// Returns true if the error kind is `ListTagsErrorKind::ServiceLinkedRoleNotFoundFault`.
    pub fn is_service_linked_role_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsErrorKind::ServiceLinkedRoleNotFoundFault(_)
        )
    }
    /// Returns true if the error kind is `ListTagsErrorKind::SnapshotNotFoundFault`.
    pub fn is_snapshot_not_found_fault(&self) -> bool {
        matches!(&self.kind, ListTagsErrorKind::SnapshotNotFoundFault(_))
    }
    /// Returns true if the error kind is `ListTagsErrorKind::SubnetGroupNotFoundFault`.
    pub fn is_subnet_group_not_found_fault(&self) -> bool {
        matches!(&self.kind, ListTagsErrorKind::SubnetGroupNotFoundFault(_))
    }
    /// Returns true if the error kind is `ListTagsErrorKind::UserNotFoundFault`.
    pub fn is_user_not_found_fault(&self) -> bool {
        matches!(&self.kind, ListTagsErrorKind::UserNotFoundFault(_))
    }
}
impl std::error::Error for ListTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsErrorKind::AclNotFoundFault(_inner) => Some(_inner),
            ListTagsErrorKind::ClusterNotFoundFault(_inner) => Some(_inner),
            ListTagsErrorKind::InvalidArnFault(_inner) => Some(_inner),
            ListTagsErrorKind::InvalidClusterStateFault(_inner) => Some(_inner),
            ListTagsErrorKind::ParameterGroupNotFoundFault(_inner) => Some(_inner),
            ListTagsErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => Some(_inner),
            ListTagsErrorKind::SnapshotNotFoundFault(_inner) => Some(_inner),
            ListTagsErrorKind::SubnetGroupNotFoundFault(_inner) => Some(_inner),
            ListTagsErrorKind::UserNotFoundFault(_inner) => Some(_inner),
            ListTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ResetParameterGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ResetParameterGroupError {
    /// Kind of error that occurred.
    pub kind: ResetParameterGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ResetParameterGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ResetParameterGroupErrorKind {
    /// <p></p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p></p>
    InvalidParameterGroupStateFault(crate::error::InvalidParameterGroupStateFault),
    /// <p></p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p></p>
    ParameterGroupNotFoundFault(crate::error::ParameterGroupNotFoundFault),
    /// <p></p>
    ServiceLinkedRoleNotFoundFault(crate::error::ServiceLinkedRoleNotFoundFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ResetParameterGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ResetParameterGroupErrorKind::InvalidParameterCombinationException(_inner) => {
                _inner.fmt(f)
            }
            ResetParameterGroupErrorKind::InvalidParameterGroupStateFault(_inner) => _inner.fmt(f),
            ResetParameterGroupErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            ResetParameterGroupErrorKind::ParameterGroupNotFoundFault(_inner) => _inner.fmt(f),
            ResetParameterGroupErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => _inner.fmt(f),
            ResetParameterGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ResetParameterGroupError {
    fn code(&self) -> Option<&str> {
        ResetParameterGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ResetParameterGroupError {
    /// Creates a new `ResetParameterGroupError`.
    pub fn new(kind: ResetParameterGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ResetParameterGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ResetParameterGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ResetParameterGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ResetParameterGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ResetParameterGroupErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResetParameterGroupErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns true if the error kind is `ResetParameterGroupErrorKind::InvalidParameterGroupStateFault`.
    pub fn is_invalid_parameter_group_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ResetParameterGroupErrorKind::InvalidParameterGroupStateFault(_)
        )
    }
    /// Returns true if the error kind is `ResetParameterGroupErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResetParameterGroupErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns true if the error kind is `ResetParameterGroupErrorKind::ParameterGroupNotFoundFault`.
    pub fn is_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ResetParameterGroupErrorKind::ParameterGroupNotFoundFault(_)
        )
    }
    /// Returns true if the error kind is `ResetParameterGroupErrorKind::ServiceLinkedRoleNotFoundFault`.
    pub fn is_service_linked_role_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ResetParameterGroupErrorKind::ServiceLinkedRoleNotFoundFault(_)
        )
    }
}
impl std::error::Error for ResetParameterGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ResetParameterGroupErrorKind::InvalidParameterCombinationException(_inner) => {
                Some(_inner)
            }
            ResetParameterGroupErrorKind::InvalidParameterGroupStateFault(_inner) => Some(_inner),
            ResetParameterGroupErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            ResetParameterGroupErrorKind::ParameterGroupNotFoundFault(_inner) => Some(_inner),
            ResetParameterGroupErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => Some(_inner),
            ResetParameterGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p></p>
    AclNotFoundFault(crate::error::AclNotFoundFault),
    /// <p></p>
    ClusterNotFoundFault(crate::error::ClusterNotFoundFault),
    /// <p></p>
    InvalidArnFault(crate::error::InvalidArnFault),
    /// <p></p>
    InvalidClusterStateFault(crate::error::InvalidClusterStateFault),
    /// <p></p>
    ParameterGroupNotFoundFault(crate::error::ParameterGroupNotFoundFault),
    /// <p></p>
    ServiceLinkedRoleNotFoundFault(crate::error::ServiceLinkedRoleNotFoundFault),
    /// <p></p>
    SnapshotNotFoundFault(crate::error::SnapshotNotFoundFault),
    /// <p></p>
    SubnetGroupNotFoundFault(crate::error::SubnetGroupNotFoundFault),
    /// <p></p>
    TagQuotaPerResourceExceeded(crate::error::TagQuotaPerResourceExceeded),
    /// <p></p>
    UserNotFoundFault(crate::error::UserNotFoundFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::AclNotFoundFault(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ClusterNotFoundFault(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InvalidArnFault(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InvalidClusterStateFault(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ParameterGroupNotFoundFault(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => _inner.fmt(f),
            TagResourceErrorKind::SnapshotNotFoundFault(_inner) => _inner.fmt(f),
            TagResourceErrorKind::SubnetGroupNotFoundFault(_inner) => _inner.fmt(f),
            TagResourceErrorKind::TagQuotaPerResourceExceeded(_inner) => _inner.fmt(f),
            TagResourceErrorKind::UserNotFoundFault(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `TagResourceErrorKind::AclNotFoundFault`.
    pub fn is_acl_not_found_fault(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::AclNotFoundFault(_))
    }
    /// Returns true if the error kind is `TagResourceErrorKind::ClusterNotFoundFault`.
    pub fn is_cluster_not_found_fault(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ClusterNotFoundFault(_))
    }
    /// Returns true if the error kind is `TagResourceErrorKind::InvalidArnFault`.
    pub fn is_invalid_arn_fault(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InvalidArnFault(_))
    }
    /// Returns true if the error kind is `TagResourceErrorKind::InvalidClusterStateFault`.
    pub fn is_invalid_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::InvalidClusterStateFault(_)
        )
    }
    /// Returns true if the error kind is `TagResourceErrorKind::ParameterGroupNotFoundFault`.
    pub fn is_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ParameterGroupNotFoundFault(_)
        )
    }
    /// Returns true if the error kind is `TagResourceErrorKind::ServiceLinkedRoleNotFoundFault`.
    pub fn is_service_linked_role_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ServiceLinkedRoleNotFoundFault(_)
        )
    }
    /// Returns true if the error kind is `TagResourceErrorKind::SnapshotNotFoundFault`.
    pub fn is_snapshot_not_found_fault(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::SnapshotNotFoundFault(_))
    }
    /// Returns true if the error kind is `TagResourceErrorKind::SubnetGroupNotFoundFault`.
    pub fn is_subnet_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::SubnetGroupNotFoundFault(_)
        )
    }
    /// Returns true if the error kind is `TagResourceErrorKind::TagQuotaPerResourceExceeded`.
    pub fn is_tag_quota_per_resource_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::TagQuotaPerResourceExceeded(_)
        )
    }
    /// Returns true if the error kind is `TagResourceErrorKind::UserNotFoundFault`.
    pub fn is_user_not_found_fault(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::UserNotFoundFault(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::AclNotFoundFault(_inner) => Some(_inner),
            TagResourceErrorKind::ClusterNotFoundFault(_inner) => Some(_inner),
            TagResourceErrorKind::InvalidArnFault(_inner) => Some(_inner),
            TagResourceErrorKind::InvalidClusterStateFault(_inner) => Some(_inner),
            TagResourceErrorKind::ParameterGroupNotFoundFault(_inner) => Some(_inner),
            TagResourceErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => Some(_inner),
            TagResourceErrorKind::SnapshotNotFoundFault(_inner) => Some(_inner),
            TagResourceErrorKind::SubnetGroupNotFoundFault(_inner) => Some(_inner),
            TagResourceErrorKind::TagQuotaPerResourceExceeded(_inner) => Some(_inner),
            TagResourceErrorKind::UserNotFoundFault(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p></p>
    AclNotFoundFault(crate::error::AclNotFoundFault),
    /// <p></p>
    ClusterNotFoundFault(crate::error::ClusterNotFoundFault),
    /// <p></p>
    InvalidArnFault(crate::error::InvalidArnFault),
    /// <p></p>
    InvalidClusterStateFault(crate::error::InvalidClusterStateFault),
    /// <p></p>
    ParameterGroupNotFoundFault(crate::error::ParameterGroupNotFoundFault),
    /// <p></p>
    ServiceLinkedRoleNotFoundFault(crate::error::ServiceLinkedRoleNotFoundFault),
    /// <p></p>
    SnapshotNotFoundFault(crate::error::SnapshotNotFoundFault),
    /// <p></p>
    SubnetGroupNotFoundFault(crate::error::SubnetGroupNotFoundFault),
    /// <p></p>
    TagNotFoundFault(crate::error::TagNotFoundFault),
    /// <p></p>
    UserNotFoundFault(crate::error::UserNotFoundFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::AclNotFoundFault(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ClusterNotFoundFault(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InvalidArnFault(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InvalidClusterStateFault(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ParameterGroupNotFoundFault(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::SnapshotNotFoundFault(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::SubnetGroupNotFoundFault(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::TagNotFoundFault(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::UserNotFoundFault(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::AclNotFoundFault`.
    pub fn is_acl_not_found_fault(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::AclNotFoundFault(_))
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::ClusterNotFoundFault`.
    pub fn is_cluster_not_found_fault(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ClusterNotFoundFault(_))
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::InvalidArnFault`.
    pub fn is_invalid_arn_fault(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::InvalidArnFault(_))
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::InvalidClusterStateFault`.
    pub fn is_invalid_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InvalidClusterStateFault(_)
        )
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::ParameterGroupNotFoundFault`.
    pub fn is_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ParameterGroupNotFoundFault(_)
        )
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::ServiceLinkedRoleNotFoundFault`.
    pub fn is_service_linked_role_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ServiceLinkedRoleNotFoundFault(_)
        )
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::SnapshotNotFoundFault`.
    pub fn is_snapshot_not_found_fault(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::SnapshotNotFoundFault(_))
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::SubnetGroupNotFoundFault`.
    pub fn is_subnet_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::SubnetGroupNotFoundFault(_)
        )
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::TagNotFoundFault`.
    pub fn is_tag_not_found_fault(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::TagNotFoundFault(_))
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::UserNotFoundFault`.
    pub fn is_user_not_found_fault(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::UserNotFoundFault(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::AclNotFoundFault(_inner) => Some(_inner),
            UntagResourceErrorKind::ClusterNotFoundFault(_inner) => Some(_inner),
            UntagResourceErrorKind::InvalidArnFault(_inner) => Some(_inner),
            UntagResourceErrorKind::InvalidClusterStateFault(_inner) => Some(_inner),
            UntagResourceErrorKind::ParameterGroupNotFoundFault(_inner) => Some(_inner),
            UntagResourceErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => Some(_inner),
            UntagResourceErrorKind::SnapshotNotFoundFault(_inner) => Some(_inner),
            UntagResourceErrorKind::SubnetGroupNotFoundFault(_inner) => Some(_inner),
            UntagResourceErrorKind::TagNotFoundFault(_inner) => Some(_inner),
            UntagResourceErrorKind::UserNotFoundFault(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateACL` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateACLError {
    /// Kind of error that occurred.
    pub kind: UpdateACLErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateACL` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateACLErrorKind {
    /// <p></p>
    AclNotFoundFault(crate::error::AclNotFoundFault),
    /// <p></p>
    DefaultUserRequired(crate::error::DefaultUserRequired),
    /// <p></p>
    DuplicateUserNameFault(crate::error::DuplicateUserNameFault),
    /// <p></p>
    InvalidAclStateFault(crate::error::InvalidAclStateFault),
    /// <p></p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p></p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p></p>
    UserNotFoundFault(crate::error::UserNotFoundFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateACLError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateACLErrorKind::AclNotFoundFault(_inner) => _inner.fmt(f),
            UpdateACLErrorKind::DefaultUserRequired(_inner) => _inner.fmt(f),
            UpdateACLErrorKind::DuplicateUserNameFault(_inner) => _inner.fmt(f),
            UpdateACLErrorKind::InvalidAclStateFault(_inner) => _inner.fmt(f),
            UpdateACLErrorKind::InvalidParameterCombinationException(_inner) => _inner.fmt(f),
            UpdateACLErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            UpdateACLErrorKind::UserNotFoundFault(_inner) => _inner.fmt(f),
            UpdateACLErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateACLError {
    fn code(&self) -> Option<&str> {
        UpdateACLError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateACLError {
    /// Creates a new `UpdateACLError`.
    pub fn new(kind: UpdateACLErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateACLError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateACLErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateACLError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateACLErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateACLErrorKind::AclNotFoundFault`.
    pub fn is_acl_not_found_fault(&self) -> bool {
        matches!(&self.kind, UpdateACLErrorKind::AclNotFoundFault(_))
    }
    /// Returns true if the error kind is `UpdateACLErrorKind::DefaultUserRequired`.
    pub fn is_default_user_required(&self) -> bool {
        matches!(&self.kind, UpdateACLErrorKind::DefaultUserRequired(_))
    }
    /// Returns true if the error kind is `UpdateACLErrorKind::DuplicateUserNameFault`.
    pub fn is_duplicate_user_name_fault(&self) -> bool {
        matches!(&self.kind, UpdateACLErrorKind::DuplicateUserNameFault(_))
    }
    /// Returns true if the error kind is `UpdateACLErrorKind::InvalidAclStateFault`.
    pub fn is_invalid_acl_state_fault(&self) -> bool {
        matches!(&self.kind, UpdateACLErrorKind::InvalidAclStateFault(_))
    }
    /// Returns true if the error kind is `UpdateACLErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateACLErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns true if the error kind is `UpdateACLErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateACLErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns true if the error kind is `UpdateACLErrorKind::UserNotFoundFault`.
    pub fn is_user_not_found_fault(&self) -> bool {
        matches!(&self.kind, UpdateACLErrorKind::UserNotFoundFault(_))
    }
}
impl std::error::Error for UpdateACLError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateACLErrorKind::AclNotFoundFault(_inner) => Some(_inner),
            UpdateACLErrorKind::DefaultUserRequired(_inner) => Some(_inner),
            UpdateACLErrorKind::DuplicateUserNameFault(_inner) => Some(_inner),
            UpdateACLErrorKind::InvalidAclStateFault(_inner) => Some(_inner),
            UpdateACLErrorKind::InvalidParameterCombinationException(_inner) => Some(_inner),
            UpdateACLErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            UpdateACLErrorKind::UserNotFoundFault(_inner) => Some(_inner),
            UpdateACLErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateClusterError {
    /// Kind of error that occurred.
    pub kind: UpdateClusterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateClusterErrorKind {
    /// <p></p>
    AclNotFoundFault(crate::error::AclNotFoundFault),
    /// <p></p>
    ClusterNotFoundFault(crate::error::ClusterNotFoundFault),
    /// <p></p>
    ClusterQuotaForCustomerExceededFault(crate::error::ClusterQuotaForCustomerExceededFault),
    /// <p></p>
    InvalidAclStateFault(crate::error::InvalidAclStateFault),
    /// <p></p>
    InvalidClusterStateFault(crate::error::InvalidClusterStateFault),
    /// <p></p>
    InvalidKmsKeyFault(crate::error::InvalidKmsKeyFault),
    /// <p></p>
    InvalidNodeStateFault(crate::error::InvalidNodeStateFault),
    /// <p></p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p></p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p></p>
    InvalidVpcNetworkStateFault(crate::error::InvalidVpcNetworkStateFault),
    /// <p></p>
    NodeQuotaForClusterExceededFault(crate::error::NodeQuotaForClusterExceededFault),
    /// <p></p>
    NodeQuotaForCustomerExceededFault(crate::error::NodeQuotaForCustomerExceededFault),
    /// <p></p>
    NoOperationFault(crate::error::NoOperationFault),
    /// <p></p>
    ParameterGroupNotFoundFault(crate::error::ParameterGroupNotFoundFault),
    /// <p></p>
    ServiceLinkedRoleNotFoundFault(crate::error::ServiceLinkedRoleNotFoundFault),
    /// <p></p>
    ShardsPerClusterQuotaExceededFault(crate::error::ShardsPerClusterQuotaExceededFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateClusterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateClusterErrorKind::AclNotFoundFault(_inner) => _inner.fmt(f),
            UpdateClusterErrorKind::ClusterNotFoundFault(_inner) => _inner.fmt(f),
            UpdateClusterErrorKind::ClusterQuotaForCustomerExceededFault(_inner) => _inner.fmt(f),
            UpdateClusterErrorKind::InvalidAclStateFault(_inner) => _inner.fmt(f),
            UpdateClusterErrorKind::InvalidClusterStateFault(_inner) => _inner.fmt(f),
            UpdateClusterErrorKind::InvalidKmsKeyFault(_inner) => _inner.fmt(f),
            UpdateClusterErrorKind::InvalidNodeStateFault(_inner) => _inner.fmt(f),
            UpdateClusterErrorKind::InvalidParameterCombinationException(_inner) => _inner.fmt(f),
            UpdateClusterErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            UpdateClusterErrorKind::InvalidVpcNetworkStateFault(_inner) => _inner.fmt(f),
            UpdateClusterErrorKind::NodeQuotaForClusterExceededFault(_inner) => _inner.fmt(f),
            UpdateClusterErrorKind::NodeQuotaForCustomerExceededFault(_inner) => _inner.fmt(f),
            UpdateClusterErrorKind::NoOperationFault(_inner) => _inner.fmt(f),
            UpdateClusterErrorKind::ParameterGroupNotFoundFault(_inner) => _inner.fmt(f),
            UpdateClusterErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => _inner.fmt(f),
            UpdateClusterErrorKind::ShardsPerClusterQuotaExceededFault(_inner) => _inner.fmt(f),
            UpdateClusterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateClusterError {
    fn code(&self) -> Option<&str> {
        UpdateClusterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateClusterError {
    /// Creates a new `UpdateClusterError`.
    pub fn new(kind: UpdateClusterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateClusterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateClusterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateClusterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateClusterErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateClusterErrorKind::AclNotFoundFault`.
    pub fn is_acl_not_found_fault(&self) -> bool {
        matches!(&self.kind, UpdateClusterErrorKind::AclNotFoundFault(_))
    }
    /// Returns true if the error kind is `UpdateClusterErrorKind::ClusterNotFoundFault`.
    pub fn is_cluster_not_found_fault(&self) -> bool {
        matches!(&self.kind, UpdateClusterErrorKind::ClusterNotFoundFault(_))
    }
    /// Returns true if the error kind is `UpdateClusterErrorKind::ClusterQuotaForCustomerExceededFault`.
    pub fn is_cluster_quota_for_customer_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            UpdateClusterErrorKind::ClusterQuotaForCustomerExceededFault(_)
        )
    }
    /// Returns true if the error kind is `UpdateClusterErrorKind::InvalidAclStateFault`.
    pub fn is_invalid_acl_state_fault(&self) -> bool {
        matches!(&self.kind, UpdateClusterErrorKind::InvalidAclStateFault(_))
    }
    /// Returns true if the error kind is `UpdateClusterErrorKind::InvalidClusterStateFault`.
    pub fn is_invalid_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            UpdateClusterErrorKind::InvalidClusterStateFault(_)
        )
    }
    /// Returns true if the error kind is `UpdateClusterErrorKind::InvalidKmsKeyFault`.
    pub fn is_invalid_kms_key_fault(&self) -> bool {
        matches!(&self.kind, UpdateClusterErrorKind::InvalidKmsKeyFault(_))
    }
    /// Returns true if the error kind is `UpdateClusterErrorKind::InvalidNodeStateFault`.
    pub fn is_invalid_node_state_fault(&self) -> bool {
        matches!(&self.kind, UpdateClusterErrorKind::InvalidNodeStateFault(_))
    }
    /// Returns true if the error kind is `UpdateClusterErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateClusterErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns true if the error kind is `UpdateClusterErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateClusterErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns true if the error kind is `UpdateClusterErrorKind::InvalidVpcNetworkStateFault`.
    pub fn is_invalid_vpc_network_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            UpdateClusterErrorKind::InvalidVpcNetworkStateFault(_)
        )
    }
    /// Returns true if the error kind is `UpdateClusterErrorKind::NodeQuotaForClusterExceededFault`.
    pub fn is_node_quota_for_cluster_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            UpdateClusterErrorKind::NodeQuotaForClusterExceededFault(_)
        )
    }
    /// Returns true if the error kind is `UpdateClusterErrorKind::NodeQuotaForCustomerExceededFault`.
    pub fn is_node_quota_for_customer_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            UpdateClusterErrorKind::NodeQuotaForCustomerExceededFault(_)
        )
    }
    /// Returns true if the error kind is `UpdateClusterErrorKind::NoOperationFault`.
    pub fn is_no_operation_fault(&self) -> bool {
        matches!(&self.kind, UpdateClusterErrorKind::NoOperationFault(_))
    }
    /// Returns true if the error kind is `UpdateClusterErrorKind::ParameterGroupNotFoundFault`.
    pub fn is_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            UpdateClusterErrorKind::ParameterGroupNotFoundFault(_)
        )
    }
    /// Returns true if the error kind is `UpdateClusterErrorKind::ServiceLinkedRoleNotFoundFault`.
    pub fn is_service_linked_role_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            UpdateClusterErrorKind::ServiceLinkedRoleNotFoundFault(_)
        )
    }
    /// Returns true if the error kind is `UpdateClusterErrorKind::ShardsPerClusterQuotaExceededFault`.
    pub fn is_shards_per_cluster_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            UpdateClusterErrorKind::ShardsPerClusterQuotaExceededFault(_)
        )
    }
}
impl std::error::Error for UpdateClusterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateClusterErrorKind::AclNotFoundFault(_inner) => Some(_inner),
            UpdateClusterErrorKind::ClusterNotFoundFault(_inner) => Some(_inner),
            UpdateClusterErrorKind::ClusterQuotaForCustomerExceededFault(_inner) => Some(_inner),
            UpdateClusterErrorKind::InvalidAclStateFault(_inner) => Some(_inner),
            UpdateClusterErrorKind::InvalidClusterStateFault(_inner) => Some(_inner),
            UpdateClusterErrorKind::InvalidKmsKeyFault(_inner) => Some(_inner),
            UpdateClusterErrorKind::InvalidNodeStateFault(_inner) => Some(_inner),
            UpdateClusterErrorKind::InvalidParameterCombinationException(_inner) => Some(_inner),
            UpdateClusterErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            UpdateClusterErrorKind::InvalidVpcNetworkStateFault(_inner) => Some(_inner),
            UpdateClusterErrorKind::NodeQuotaForClusterExceededFault(_inner) => Some(_inner),
            UpdateClusterErrorKind::NodeQuotaForCustomerExceededFault(_inner) => Some(_inner),
            UpdateClusterErrorKind::NoOperationFault(_inner) => Some(_inner),
            UpdateClusterErrorKind::ParameterGroupNotFoundFault(_inner) => Some(_inner),
            UpdateClusterErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => Some(_inner),
            UpdateClusterErrorKind::ShardsPerClusterQuotaExceededFault(_inner) => Some(_inner),
            UpdateClusterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateParameterGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateParameterGroupError {
    /// Kind of error that occurred.
    pub kind: UpdateParameterGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateParameterGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateParameterGroupErrorKind {
    /// <p></p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p></p>
    InvalidParameterGroupStateFault(crate::error::InvalidParameterGroupStateFault),
    /// <p></p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p></p>
    ParameterGroupNotFoundFault(crate::error::ParameterGroupNotFoundFault),
    /// <p></p>
    ServiceLinkedRoleNotFoundFault(crate::error::ServiceLinkedRoleNotFoundFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateParameterGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateParameterGroupErrorKind::InvalidParameterCombinationException(_inner) => {
                _inner.fmt(f)
            }
            UpdateParameterGroupErrorKind::InvalidParameterGroupStateFault(_inner) => _inner.fmt(f),
            UpdateParameterGroupErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            UpdateParameterGroupErrorKind::ParameterGroupNotFoundFault(_inner) => _inner.fmt(f),
            UpdateParameterGroupErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => _inner.fmt(f),
            UpdateParameterGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateParameterGroupError {
    fn code(&self) -> Option<&str> {
        UpdateParameterGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateParameterGroupError {
    /// Creates a new `UpdateParameterGroupError`.
    pub fn new(kind: UpdateParameterGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateParameterGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateParameterGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateParameterGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateParameterGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateParameterGroupErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateParameterGroupErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns true if the error kind is `UpdateParameterGroupErrorKind::InvalidParameterGroupStateFault`.
    pub fn is_invalid_parameter_group_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            UpdateParameterGroupErrorKind::InvalidParameterGroupStateFault(_)
        )
    }
    /// Returns true if the error kind is `UpdateParameterGroupErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateParameterGroupErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns true if the error kind is `UpdateParameterGroupErrorKind::ParameterGroupNotFoundFault`.
    pub fn is_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            UpdateParameterGroupErrorKind::ParameterGroupNotFoundFault(_)
        )
    }
    /// Returns true if the error kind is `UpdateParameterGroupErrorKind::ServiceLinkedRoleNotFoundFault`.
    pub fn is_service_linked_role_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            UpdateParameterGroupErrorKind::ServiceLinkedRoleNotFoundFault(_)
        )
    }
}
impl std::error::Error for UpdateParameterGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateParameterGroupErrorKind::InvalidParameterCombinationException(_inner) => {
                Some(_inner)
            }
            UpdateParameterGroupErrorKind::InvalidParameterGroupStateFault(_inner) => Some(_inner),
            UpdateParameterGroupErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            UpdateParameterGroupErrorKind::ParameterGroupNotFoundFault(_inner) => Some(_inner),
            UpdateParameterGroupErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => Some(_inner),
            UpdateParameterGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateSubnetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateSubnetGroupError {
    /// Kind of error that occurred.
    pub kind: UpdateSubnetGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateSubnetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateSubnetGroupErrorKind {
    /// <p></p>
    InvalidSubnet(crate::error::InvalidSubnet),
    /// <p></p>
    ServiceLinkedRoleNotFoundFault(crate::error::ServiceLinkedRoleNotFoundFault),
    /// <p></p>
    SubnetGroupNotFoundFault(crate::error::SubnetGroupNotFoundFault),
    /// <p></p>
    SubnetInUse(crate::error::SubnetInUse),
    /// <p></p>
    SubnetNotAllowedFault(crate::error::SubnetNotAllowedFault),
    /// <p></p>
    SubnetQuotaExceededFault(crate::error::SubnetQuotaExceededFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateSubnetGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateSubnetGroupErrorKind::InvalidSubnet(_inner) => _inner.fmt(f),
            UpdateSubnetGroupErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => _inner.fmt(f),
            UpdateSubnetGroupErrorKind::SubnetGroupNotFoundFault(_inner) => _inner.fmt(f),
            UpdateSubnetGroupErrorKind::SubnetInUse(_inner) => _inner.fmt(f),
            UpdateSubnetGroupErrorKind::SubnetNotAllowedFault(_inner) => _inner.fmt(f),
            UpdateSubnetGroupErrorKind::SubnetQuotaExceededFault(_inner) => _inner.fmt(f),
            UpdateSubnetGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateSubnetGroupError {
    fn code(&self) -> Option<&str> {
        UpdateSubnetGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateSubnetGroupError {
    /// Creates a new `UpdateSubnetGroupError`.
    pub fn new(kind: UpdateSubnetGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateSubnetGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateSubnetGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateSubnetGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateSubnetGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateSubnetGroupErrorKind::InvalidSubnet`.
    pub fn is_invalid_subnet(&self) -> bool {
        matches!(&self.kind, UpdateSubnetGroupErrorKind::InvalidSubnet(_))
    }
    /// Returns true if the error kind is `UpdateSubnetGroupErrorKind::ServiceLinkedRoleNotFoundFault`.
    pub fn is_service_linked_role_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSubnetGroupErrorKind::ServiceLinkedRoleNotFoundFault(_)
        )
    }
    /// Returns true if the error kind is `UpdateSubnetGroupErrorKind::SubnetGroupNotFoundFault`.
    pub fn is_subnet_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSubnetGroupErrorKind::SubnetGroupNotFoundFault(_)
        )
    }
    /// Returns true if the error kind is `UpdateSubnetGroupErrorKind::SubnetInUse`.
    pub fn is_subnet_in_use(&self) -> bool {
        matches!(&self.kind, UpdateSubnetGroupErrorKind::SubnetInUse(_))
    }
    /// Returns true if the error kind is `UpdateSubnetGroupErrorKind::SubnetNotAllowedFault`.
    pub fn is_subnet_not_allowed_fault(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSubnetGroupErrorKind::SubnetNotAllowedFault(_)
        )
    }
    /// Returns true if the error kind is `UpdateSubnetGroupErrorKind::SubnetQuotaExceededFault`.
    pub fn is_subnet_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSubnetGroupErrorKind::SubnetQuotaExceededFault(_)
        )
    }
}
impl std::error::Error for UpdateSubnetGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateSubnetGroupErrorKind::InvalidSubnet(_inner) => Some(_inner),
            UpdateSubnetGroupErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => Some(_inner),
            UpdateSubnetGroupErrorKind::SubnetGroupNotFoundFault(_inner) => Some(_inner),
            UpdateSubnetGroupErrorKind::SubnetInUse(_inner) => Some(_inner),
            UpdateSubnetGroupErrorKind::SubnetNotAllowedFault(_inner) => Some(_inner),
            UpdateSubnetGroupErrorKind::SubnetQuotaExceededFault(_inner) => Some(_inner),
            UpdateSubnetGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateUserError {
    /// Kind of error that occurred.
    pub kind: UpdateUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateUserErrorKind {
    /// <p></p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p></p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p></p>
    InvalidUserStateFault(crate::error::InvalidUserStateFault),
    /// <p></p>
    UserNotFoundFault(crate::error::UserNotFoundFault),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateUserErrorKind::InvalidParameterCombinationException(_inner) => _inner.fmt(f),
            UpdateUserErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            UpdateUserErrorKind::InvalidUserStateFault(_inner) => _inner.fmt(f),
            UpdateUserErrorKind::UserNotFoundFault(_inner) => _inner.fmt(f),
            UpdateUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateUserError {
    fn code(&self) -> Option<&str> {
        UpdateUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateUserError {
    /// Creates a new `UpdateUserError`.
    pub fn new(kind: UpdateUserErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateUserErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateUserErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns true if the error kind is `UpdateUserErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns true if the error kind is `UpdateUserErrorKind::InvalidUserStateFault`.
    pub fn is_invalid_user_state_fault(&self) -> bool {
        matches!(&self.kind, UpdateUserErrorKind::InvalidUserStateFault(_))
    }
    /// Returns true if the error kind is `UpdateUserErrorKind::UserNotFoundFault`.
    pub fn is_user_not_found_fault(&self) -> bool {
        matches!(&self.kind, UpdateUserErrorKind::UserNotFoundFault(_))
    }
}
impl std::error::Error for UpdateUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateUserErrorKind::InvalidParameterCombinationException(_inner) => Some(_inner),
            UpdateUserErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            UpdateUserErrorKind::InvalidUserStateFault(_inner) => Some(_inner),
            UpdateUserErrorKind::UserNotFoundFault(_inner) => Some(_inner),
            UpdateUserErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UserNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UserNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UserNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UserNotFoundFault")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for UserNotFoundFault {}
/// See [`UserNotFoundFault`](crate::error::UserNotFoundFault)
pub mod user_not_found_fault {
    /// A builder for [`UserNotFoundFault`](crate::error::UserNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UserNotFoundFault`](crate::error::UserNotFoundFault)
        pub fn build(self) -> crate::error::UserNotFoundFault {
            crate::error::UserNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl UserNotFoundFault {
    /// Creates a new builder-style object to manufacture [`UserNotFoundFault`](crate::error::UserNotFoundFault)
    pub fn builder() -> crate::error::user_not_found_fault::Builder {
        crate::error::user_not_found_fault::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidUserStateFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidUserStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidUserStateFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidUserStateFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidUserStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidUserStateFault")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidUserStateFault {}
/// See [`InvalidUserStateFault`](crate::error::InvalidUserStateFault)
pub mod invalid_user_state_fault {
    /// A builder for [`InvalidUserStateFault`](crate::error::InvalidUserStateFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidUserStateFault`](crate::error::InvalidUserStateFault)
        pub fn build(self) -> crate::error::InvalidUserStateFault {
            crate::error::InvalidUserStateFault {
                message: self.message,
            }
        }
    }
}
impl InvalidUserStateFault {
    /// Creates a new builder-style object to manufacture [`InvalidUserStateFault`](crate::error::InvalidUserStateFault)
    pub fn builder() -> crate::error::invalid_user_state_fault::Builder {
        crate::error::invalid_user_state_fault::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidParameterValueException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidParameterValueException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidParameterValueException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidParameterValueException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidParameterValueException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidParameterValueException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidParameterValueException {}
/// See [`InvalidParameterValueException`](crate::error::InvalidParameterValueException)
pub mod invalid_parameter_value_exception {
    /// A builder for [`InvalidParameterValueException`](crate::error::InvalidParameterValueException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidParameterValueException`](crate::error::InvalidParameterValueException)
        pub fn build(self) -> crate::error::InvalidParameterValueException {
            crate::error::InvalidParameterValueException {
                message: self.message,
            }
        }
    }
}
impl InvalidParameterValueException {
    /// Creates a new builder-style object to manufacture [`InvalidParameterValueException`](crate::error::InvalidParameterValueException)
    pub fn builder() -> crate::error::invalid_parameter_value_exception::Builder {
        crate::error::invalid_parameter_value_exception::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidParameterCombinationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidParameterCombinationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidParameterCombinationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidParameterCombinationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidParameterCombinationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidParameterCombinationException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidParameterCombinationException {}
/// See [`InvalidParameterCombinationException`](crate::error::InvalidParameterCombinationException)
pub mod invalid_parameter_combination_exception {
    /// A builder for [`InvalidParameterCombinationException`](crate::error::InvalidParameterCombinationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidParameterCombinationException`](crate::error::InvalidParameterCombinationException)
        pub fn build(self) -> crate::error::InvalidParameterCombinationException {
            crate::error::InvalidParameterCombinationException {
                message: self.message,
            }
        }
    }
}
impl InvalidParameterCombinationException {
    /// Creates a new builder-style object to manufacture [`InvalidParameterCombinationException`](crate::error::InvalidParameterCombinationException)
    pub fn builder() -> crate::error::invalid_parameter_combination_exception::Builder {
        crate::error::invalid_parameter_combination_exception::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SubnetQuotaExceededFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SubnetQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SubnetQuotaExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SubnetQuotaExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SubnetQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SubnetQuotaExceededFault")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for SubnetQuotaExceededFault {}
/// See [`SubnetQuotaExceededFault`](crate::error::SubnetQuotaExceededFault)
pub mod subnet_quota_exceeded_fault {
    /// A builder for [`SubnetQuotaExceededFault`](crate::error::SubnetQuotaExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SubnetQuotaExceededFault`](crate::error::SubnetQuotaExceededFault)
        pub fn build(self) -> crate::error::SubnetQuotaExceededFault {
            crate::error::SubnetQuotaExceededFault {
                message: self.message,
            }
        }
    }
}
impl SubnetQuotaExceededFault {
    /// Creates a new builder-style object to manufacture [`SubnetQuotaExceededFault`](crate::error::SubnetQuotaExceededFault)
    pub fn builder() -> crate::error::subnet_quota_exceeded_fault::Builder {
        crate::error::subnet_quota_exceeded_fault::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SubnetNotAllowedFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SubnetNotAllowedFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SubnetNotAllowedFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SubnetNotAllowedFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SubnetNotAllowedFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SubnetNotAllowedFault")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for SubnetNotAllowedFault {}
/// See [`SubnetNotAllowedFault`](crate::error::SubnetNotAllowedFault)
pub mod subnet_not_allowed_fault {
    /// A builder for [`SubnetNotAllowedFault`](crate::error::SubnetNotAllowedFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SubnetNotAllowedFault`](crate::error::SubnetNotAllowedFault)
        pub fn build(self) -> crate::error::SubnetNotAllowedFault {
            crate::error::SubnetNotAllowedFault {
                message: self.message,
            }
        }
    }
}
impl SubnetNotAllowedFault {
    /// Creates a new builder-style object to manufacture [`SubnetNotAllowedFault`](crate::error::SubnetNotAllowedFault)
    pub fn builder() -> crate::error::subnet_not_allowed_fault::Builder {
        crate::error::subnet_not_allowed_fault::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SubnetInUse {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SubnetInUse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SubnetInUse");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SubnetInUse {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SubnetInUse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SubnetInUse")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for SubnetInUse {}
/// See [`SubnetInUse`](crate::error::SubnetInUse)
pub mod subnet_in_use {
    /// A builder for [`SubnetInUse`](crate::error::SubnetInUse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SubnetInUse`](crate::error::SubnetInUse)
        pub fn build(self) -> crate::error::SubnetInUse {
            crate::error::SubnetInUse {
                message: self.message,
            }
        }
    }
}
impl SubnetInUse {
    /// Creates a new builder-style object to manufacture [`SubnetInUse`](crate::error::SubnetInUse)
    pub fn builder() -> crate::error::subnet_in_use::Builder {
        crate::error::subnet_in_use::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SubnetGroupNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SubnetGroupNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SubnetGroupNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SubnetGroupNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SubnetGroupNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SubnetGroupNotFoundFault")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for SubnetGroupNotFoundFault {}
/// See [`SubnetGroupNotFoundFault`](crate::error::SubnetGroupNotFoundFault)
pub mod subnet_group_not_found_fault {
    /// A builder for [`SubnetGroupNotFoundFault`](crate::error::SubnetGroupNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SubnetGroupNotFoundFault`](crate::error::SubnetGroupNotFoundFault)
        pub fn build(self) -> crate::error::SubnetGroupNotFoundFault {
            crate::error::SubnetGroupNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl SubnetGroupNotFoundFault {
    /// Creates a new builder-style object to manufacture [`SubnetGroupNotFoundFault`](crate::error::SubnetGroupNotFoundFault)
    pub fn builder() -> crate::error::subnet_group_not_found_fault::Builder {
        crate::error::subnet_group_not_found_fault::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceLinkedRoleNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceLinkedRoleNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceLinkedRoleNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceLinkedRoleNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceLinkedRoleNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceLinkedRoleNotFoundFault")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceLinkedRoleNotFoundFault {}
/// See [`ServiceLinkedRoleNotFoundFault`](crate::error::ServiceLinkedRoleNotFoundFault)
pub mod service_linked_role_not_found_fault {
    /// A builder for [`ServiceLinkedRoleNotFoundFault`](crate::error::ServiceLinkedRoleNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceLinkedRoleNotFoundFault`](crate::error::ServiceLinkedRoleNotFoundFault)
        pub fn build(self) -> crate::error::ServiceLinkedRoleNotFoundFault {
            crate::error::ServiceLinkedRoleNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl ServiceLinkedRoleNotFoundFault {
    /// Creates a new builder-style object to manufacture [`ServiceLinkedRoleNotFoundFault`](crate::error::ServiceLinkedRoleNotFoundFault)
    pub fn builder() -> crate::error::service_linked_role_not_found_fault::Builder {
        crate::error::service_linked_role_not_found_fault::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidSubnet {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidSubnet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidSubnet");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidSubnet {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidSubnet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidSubnet")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidSubnet {}
/// See [`InvalidSubnet`](crate::error::InvalidSubnet)
pub mod invalid_subnet {
    /// A builder for [`InvalidSubnet`](crate::error::InvalidSubnet)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidSubnet`](crate::error::InvalidSubnet)
        pub fn build(self) -> crate::error::InvalidSubnet {
            crate::error::InvalidSubnet {
                message: self.message,
            }
        }
    }
}
impl InvalidSubnet {
    /// Creates a new builder-style object to manufacture [`InvalidSubnet`](crate::error::InvalidSubnet)
    pub fn builder() -> crate::error::invalid_subnet::Builder {
        crate::error::invalid_subnet::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ParameterGroupNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ParameterGroupNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ParameterGroupNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ParameterGroupNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ParameterGroupNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ParameterGroupNotFoundFault")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for ParameterGroupNotFoundFault {}
/// See [`ParameterGroupNotFoundFault`](crate::error::ParameterGroupNotFoundFault)
pub mod parameter_group_not_found_fault {
    /// A builder for [`ParameterGroupNotFoundFault`](crate::error::ParameterGroupNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ParameterGroupNotFoundFault`](crate::error::ParameterGroupNotFoundFault)
        pub fn build(self) -> crate::error::ParameterGroupNotFoundFault {
            crate::error::ParameterGroupNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl ParameterGroupNotFoundFault {
    /// Creates a new builder-style object to manufacture [`ParameterGroupNotFoundFault`](crate::error::ParameterGroupNotFoundFault)
    pub fn builder() -> crate::error::parameter_group_not_found_fault::Builder {
        crate::error::parameter_group_not_found_fault::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidParameterGroupStateFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidParameterGroupStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidParameterGroupStateFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidParameterGroupStateFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidParameterGroupStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidParameterGroupStateFault")?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidParameterGroupStateFault {}
/// See [`InvalidParameterGroupStateFault`](crate::error::InvalidParameterGroupStateFault)
pub mod invalid_parameter_group_state_fault {
    /// A builder for [`InvalidParameterGroupStateFault`](crate::error::InvalidParameterGroupStateFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidParameterGroupStateFault`](crate::error::InvalidParameterGroupStateFault)
        pub fn build(self) -> crate::error::InvalidParameterGroupStateFault {
            crate::error::InvalidParameterGroupStateFault {
                message: self.message,
            }
        }
    }
}
impl InvalidParameterGroupStateFault {
    /// Creates a new builder-style object to manufacture [`InvalidParameterGroupStateFault`](crate::error::InvalidParameterGroupStateFault)
    pub fn builder() -> crate::error::invalid_parameter_group_state_fault::Builder {
        crate::error::invalid_parameter_group_state_fault::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ShardsPerClusterQuotaExceededFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ShardsPerClusterQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ShardsPerClusterQuotaExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ShardsPerClusterQuotaExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ShardsPerClusterQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ShardsPerClusterQuotaExceededFault")?;
        if let Some(inner_13) = &self.message {
            write!(f, ": {}", inner_13)?;
        }
        Ok(())
    }
}
impl std::error::Error for ShardsPerClusterQuotaExceededFault {}
/// See [`ShardsPerClusterQuotaExceededFault`](crate::error::ShardsPerClusterQuotaExceededFault)
pub mod shards_per_cluster_quota_exceeded_fault {
    /// A builder for [`ShardsPerClusterQuotaExceededFault`](crate::error::ShardsPerClusterQuotaExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ShardsPerClusterQuotaExceededFault`](crate::error::ShardsPerClusterQuotaExceededFault)
        pub fn build(self) -> crate::error::ShardsPerClusterQuotaExceededFault {
            crate::error::ShardsPerClusterQuotaExceededFault {
                message: self.message,
            }
        }
    }
}
impl ShardsPerClusterQuotaExceededFault {
    /// Creates a new builder-style object to manufacture [`ShardsPerClusterQuotaExceededFault`](crate::error::ShardsPerClusterQuotaExceededFault)
    pub fn builder() -> crate::error::shards_per_cluster_quota_exceeded_fault::Builder {
        crate::error::shards_per_cluster_quota_exceeded_fault::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NoOperationFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NoOperationFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NoOperationFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NoOperationFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NoOperationFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NoOperationFault")?;
        if let Some(inner_14) = &self.message {
            write!(f, ": {}", inner_14)?;
        }
        Ok(())
    }
}
impl std::error::Error for NoOperationFault {}
/// See [`NoOperationFault`](crate::error::NoOperationFault)
pub mod no_operation_fault {
    /// A builder for [`NoOperationFault`](crate::error::NoOperationFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NoOperationFault`](crate::error::NoOperationFault)
        pub fn build(self) -> crate::error::NoOperationFault {
            crate::error::NoOperationFault {
                message: self.message,
            }
        }
    }
}
impl NoOperationFault {
    /// Creates a new builder-style object to manufacture [`NoOperationFault`](crate::error::NoOperationFault)
    pub fn builder() -> crate::error::no_operation_fault::Builder {
        crate::error::no_operation_fault::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NodeQuotaForCustomerExceededFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NodeQuotaForCustomerExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NodeQuotaForCustomerExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NodeQuotaForCustomerExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NodeQuotaForCustomerExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NodeQuotaForCustomerExceededFault")?;
        if let Some(inner_15) = &self.message {
            write!(f, ": {}", inner_15)?;
        }
        Ok(())
    }
}
impl std::error::Error for NodeQuotaForCustomerExceededFault {}
/// See [`NodeQuotaForCustomerExceededFault`](crate::error::NodeQuotaForCustomerExceededFault)
pub mod node_quota_for_customer_exceeded_fault {
    /// A builder for [`NodeQuotaForCustomerExceededFault`](crate::error::NodeQuotaForCustomerExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NodeQuotaForCustomerExceededFault`](crate::error::NodeQuotaForCustomerExceededFault)
        pub fn build(self) -> crate::error::NodeQuotaForCustomerExceededFault {
            crate::error::NodeQuotaForCustomerExceededFault {
                message: self.message,
            }
        }
    }
}
impl NodeQuotaForCustomerExceededFault {
    /// Creates a new builder-style object to manufacture [`NodeQuotaForCustomerExceededFault`](crate::error::NodeQuotaForCustomerExceededFault)
    pub fn builder() -> crate::error::node_quota_for_customer_exceeded_fault::Builder {
        crate::error::node_quota_for_customer_exceeded_fault::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NodeQuotaForClusterExceededFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NodeQuotaForClusterExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NodeQuotaForClusterExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NodeQuotaForClusterExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NodeQuotaForClusterExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NodeQuotaForClusterExceededFault")?;
        if let Some(inner_16) = &self.message {
            write!(f, ": {}", inner_16)?;
        }
        Ok(())
    }
}
impl std::error::Error for NodeQuotaForClusterExceededFault {}
/// See [`NodeQuotaForClusterExceededFault`](crate::error::NodeQuotaForClusterExceededFault)
pub mod node_quota_for_cluster_exceeded_fault {
    /// A builder for [`NodeQuotaForClusterExceededFault`](crate::error::NodeQuotaForClusterExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NodeQuotaForClusterExceededFault`](crate::error::NodeQuotaForClusterExceededFault)
        pub fn build(self) -> crate::error::NodeQuotaForClusterExceededFault {
            crate::error::NodeQuotaForClusterExceededFault {
                message: self.message,
            }
        }
    }
}
impl NodeQuotaForClusterExceededFault {
    /// Creates a new builder-style object to manufacture [`NodeQuotaForClusterExceededFault`](crate::error::NodeQuotaForClusterExceededFault)
    pub fn builder() -> crate::error::node_quota_for_cluster_exceeded_fault::Builder {
        crate::error::node_quota_for_cluster_exceeded_fault::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidVpcNetworkStateFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidVpcNetworkStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidVpcNetworkStateFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidVpcNetworkStateFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidVpcNetworkStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "InvalidVpcNetworkStateFault [InvalidVPCNetworkStateFault]"
        )?;
        if let Some(inner_17) = &self.message {
            write!(f, ": {}", inner_17)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidVpcNetworkStateFault {}
/// See [`InvalidVpcNetworkStateFault`](crate::error::InvalidVpcNetworkStateFault)
pub mod invalid_vpc_network_state_fault {
    /// A builder for [`InvalidVpcNetworkStateFault`](crate::error::InvalidVpcNetworkStateFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidVpcNetworkStateFault`](crate::error::InvalidVpcNetworkStateFault)
        pub fn build(self) -> crate::error::InvalidVpcNetworkStateFault {
            crate::error::InvalidVpcNetworkStateFault {
                message: self.message,
            }
        }
    }
}
impl InvalidVpcNetworkStateFault {
    /// Creates a new builder-style object to manufacture [`InvalidVpcNetworkStateFault`](crate::error::InvalidVpcNetworkStateFault)
    pub fn builder() -> crate::error::invalid_vpc_network_state_fault::Builder {
        crate::error::invalid_vpc_network_state_fault::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidNodeStateFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidNodeStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidNodeStateFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidNodeStateFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidNodeStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidNodeStateFault")?;
        if let Some(inner_18) = &self.message {
            write!(f, ": {}", inner_18)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidNodeStateFault {}
/// See [`InvalidNodeStateFault`](crate::error::InvalidNodeStateFault)
pub mod invalid_node_state_fault {
    /// A builder for [`InvalidNodeStateFault`](crate::error::InvalidNodeStateFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidNodeStateFault`](crate::error::InvalidNodeStateFault)
        pub fn build(self) -> crate::error::InvalidNodeStateFault {
            crate::error::InvalidNodeStateFault {
                message: self.message,
            }
        }
    }
}
impl InvalidNodeStateFault {
    /// Creates a new builder-style object to manufacture [`InvalidNodeStateFault`](crate::error::InvalidNodeStateFault)
    pub fn builder() -> crate::error::invalid_node_state_fault::Builder {
        crate::error::invalid_node_state_fault::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidKmsKeyFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidKmsKeyFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidKmsKeyFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidKmsKeyFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidKmsKeyFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidKmsKeyFault [InvalidKMSKeyFault]")?;
        if let Some(inner_19) = &self.message {
            write!(f, ": {}", inner_19)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidKmsKeyFault {}
/// See [`InvalidKmsKeyFault`](crate::error::InvalidKmsKeyFault)
pub mod invalid_kms_key_fault {
    /// A builder for [`InvalidKmsKeyFault`](crate::error::InvalidKmsKeyFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidKmsKeyFault`](crate::error::InvalidKmsKeyFault)
        pub fn build(self) -> crate::error::InvalidKmsKeyFault {
            crate::error::InvalidKmsKeyFault {
                message: self.message,
            }
        }
    }
}
impl InvalidKmsKeyFault {
    /// Creates a new builder-style object to manufacture [`InvalidKmsKeyFault`](crate::error::InvalidKmsKeyFault)
    pub fn builder() -> crate::error::invalid_kms_key_fault::Builder {
        crate::error::invalid_kms_key_fault::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidClusterStateFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidClusterStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidClusterStateFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidClusterStateFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidClusterStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidClusterStateFault")?;
        if let Some(inner_20) = &self.message {
            write!(f, ": {}", inner_20)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidClusterStateFault {}
/// See [`InvalidClusterStateFault`](crate::error::InvalidClusterStateFault)
pub mod invalid_cluster_state_fault {
    /// A builder for [`InvalidClusterStateFault`](crate::error::InvalidClusterStateFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidClusterStateFault`](crate::error::InvalidClusterStateFault)
        pub fn build(self) -> crate::error::InvalidClusterStateFault {
            crate::error::InvalidClusterStateFault {
                message: self.message,
            }
        }
    }
}
impl InvalidClusterStateFault {
    /// Creates a new builder-style object to manufacture [`InvalidClusterStateFault`](crate::error::InvalidClusterStateFault)
    pub fn builder() -> crate::error::invalid_cluster_state_fault::Builder {
        crate::error::invalid_cluster_state_fault::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidAclStateFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidAclStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidAclStateFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidAclStateFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidAclStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidAclStateFault [InvalidACLStateFault]")?;
        if let Some(inner_21) = &self.message {
            write!(f, ": {}", inner_21)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidAclStateFault {}
/// See [`InvalidAclStateFault`](crate::error::InvalidAclStateFault)
pub mod invalid_acl_state_fault {
    /// A builder for [`InvalidAclStateFault`](crate::error::InvalidAclStateFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidAclStateFault`](crate::error::InvalidAclStateFault)
        pub fn build(self) -> crate::error::InvalidAclStateFault {
            crate::error::InvalidAclStateFault {
                message: self.message,
            }
        }
    }
}
impl InvalidAclStateFault {
    /// Creates a new builder-style object to manufacture [`InvalidAclStateFault`](crate::error::InvalidAclStateFault)
    pub fn builder() -> crate::error::invalid_acl_state_fault::Builder {
        crate::error::invalid_acl_state_fault::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClusterQuotaForCustomerExceededFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ClusterQuotaForCustomerExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClusterQuotaForCustomerExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ClusterQuotaForCustomerExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ClusterQuotaForCustomerExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ClusterQuotaForCustomerExceededFault")?;
        if let Some(inner_22) = &self.message {
            write!(f, ": {}", inner_22)?;
        }
        Ok(())
    }
}
impl std::error::Error for ClusterQuotaForCustomerExceededFault {}
/// See [`ClusterQuotaForCustomerExceededFault`](crate::error::ClusterQuotaForCustomerExceededFault)
pub mod cluster_quota_for_customer_exceeded_fault {
    /// A builder for [`ClusterQuotaForCustomerExceededFault`](crate::error::ClusterQuotaForCustomerExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ClusterQuotaForCustomerExceededFault`](crate::error::ClusterQuotaForCustomerExceededFault)
        pub fn build(self) -> crate::error::ClusterQuotaForCustomerExceededFault {
            crate::error::ClusterQuotaForCustomerExceededFault {
                message: self.message,
            }
        }
    }
}
impl ClusterQuotaForCustomerExceededFault {
    /// Creates a new builder-style object to manufacture [`ClusterQuotaForCustomerExceededFault`](crate::error::ClusterQuotaForCustomerExceededFault)
    pub fn builder() -> crate::error::cluster_quota_for_customer_exceeded_fault::Builder {
        crate::error::cluster_quota_for_customer_exceeded_fault::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClusterNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ClusterNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClusterNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ClusterNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ClusterNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ClusterNotFoundFault")?;
        if let Some(inner_23) = &self.message {
            write!(f, ": {}", inner_23)?;
        }
        Ok(())
    }
}
impl std::error::Error for ClusterNotFoundFault {}
/// See [`ClusterNotFoundFault`](crate::error::ClusterNotFoundFault)
pub mod cluster_not_found_fault {
    /// A builder for [`ClusterNotFoundFault`](crate::error::ClusterNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ClusterNotFoundFault`](crate::error::ClusterNotFoundFault)
        pub fn build(self) -> crate::error::ClusterNotFoundFault {
            crate::error::ClusterNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl ClusterNotFoundFault {
    /// Creates a new builder-style object to manufacture [`ClusterNotFoundFault`](crate::error::ClusterNotFoundFault)
    pub fn builder() -> crate::error::cluster_not_found_fault::Builder {
        crate::error::cluster_not_found_fault::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AclNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AclNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AclNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AclNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AclNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AclNotFoundFault [ACLNotFoundFault]")?;
        if let Some(inner_24) = &self.message {
            write!(f, ": {}", inner_24)?;
        }
        Ok(())
    }
}
impl std::error::Error for AclNotFoundFault {}
/// See [`AclNotFoundFault`](crate::error::AclNotFoundFault)
pub mod acl_not_found_fault {
    /// A builder for [`AclNotFoundFault`](crate::error::AclNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AclNotFoundFault`](crate::error::AclNotFoundFault)
        pub fn build(self) -> crate::error::AclNotFoundFault {
            crate::error::AclNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl AclNotFoundFault {
    /// Creates a new builder-style object to manufacture [`AclNotFoundFault`](crate::error::AclNotFoundFault)
    pub fn builder() -> crate::error::acl_not_found_fault::Builder {
        crate::error::acl_not_found_fault::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DuplicateUserNameFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DuplicateUserNameFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DuplicateUserNameFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DuplicateUserNameFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DuplicateUserNameFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DuplicateUserNameFault")?;
        if let Some(inner_25) = &self.message {
            write!(f, ": {}", inner_25)?;
        }
        Ok(())
    }
}
impl std::error::Error for DuplicateUserNameFault {}
/// See [`DuplicateUserNameFault`](crate::error::DuplicateUserNameFault)
pub mod duplicate_user_name_fault {
    /// A builder for [`DuplicateUserNameFault`](crate::error::DuplicateUserNameFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DuplicateUserNameFault`](crate::error::DuplicateUserNameFault)
        pub fn build(self) -> crate::error::DuplicateUserNameFault {
            crate::error::DuplicateUserNameFault {
                message: self.message,
            }
        }
    }
}
impl DuplicateUserNameFault {
    /// Creates a new builder-style object to manufacture [`DuplicateUserNameFault`](crate::error::DuplicateUserNameFault)
    pub fn builder() -> crate::error::duplicate_user_name_fault::Builder {
        crate::error::duplicate_user_name_fault::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DefaultUserRequired {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DefaultUserRequired {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DefaultUserRequired");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DefaultUserRequired {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DefaultUserRequired {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DefaultUserRequired")?;
        if let Some(inner_26) = &self.message {
            write!(f, ": {}", inner_26)?;
        }
        Ok(())
    }
}
impl std::error::Error for DefaultUserRequired {}
/// See [`DefaultUserRequired`](crate::error::DefaultUserRequired)
pub mod default_user_required {
    /// A builder for [`DefaultUserRequired`](crate::error::DefaultUserRequired)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DefaultUserRequired`](crate::error::DefaultUserRequired)
        pub fn build(self) -> crate::error::DefaultUserRequired {
            crate::error::DefaultUserRequired {
                message: self.message,
            }
        }
    }
}
impl DefaultUserRequired {
    /// Creates a new builder-style object to manufacture [`DefaultUserRequired`](crate::error::DefaultUserRequired)
    pub fn builder() -> crate::error::default_user_required::Builder {
        crate::error::default_user_required::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TagNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TagNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TagNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TagNotFoundFault")?;
        if let Some(inner_27) = &self.message {
            write!(f, ": {}", inner_27)?;
        }
        Ok(())
    }
}
impl std::error::Error for TagNotFoundFault {}
/// See [`TagNotFoundFault`](crate::error::TagNotFoundFault)
pub mod tag_not_found_fault {
    /// A builder for [`TagNotFoundFault`](crate::error::TagNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TagNotFoundFault`](crate::error::TagNotFoundFault)
        pub fn build(self) -> crate::error::TagNotFoundFault {
            crate::error::TagNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl TagNotFoundFault {
    /// Creates a new builder-style object to manufacture [`TagNotFoundFault`](crate::error::TagNotFoundFault)
    pub fn builder() -> crate::error::tag_not_found_fault::Builder {
        crate::error::tag_not_found_fault::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SnapshotNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SnapshotNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SnapshotNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SnapshotNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SnapshotNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SnapshotNotFoundFault")?;
        if let Some(inner_28) = &self.message {
            write!(f, ": {}", inner_28)?;
        }
        Ok(())
    }
}
impl std::error::Error for SnapshotNotFoundFault {}
/// See [`SnapshotNotFoundFault`](crate::error::SnapshotNotFoundFault)
pub mod snapshot_not_found_fault {
    /// A builder for [`SnapshotNotFoundFault`](crate::error::SnapshotNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SnapshotNotFoundFault`](crate::error::SnapshotNotFoundFault)
        pub fn build(self) -> crate::error::SnapshotNotFoundFault {
            crate::error::SnapshotNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl SnapshotNotFoundFault {
    /// Creates a new builder-style object to manufacture [`SnapshotNotFoundFault`](crate::error::SnapshotNotFoundFault)
    pub fn builder() -> crate::error::snapshot_not_found_fault::Builder {
        crate::error::snapshot_not_found_fault::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidArnFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidArnFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidArnFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidArnFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidArnFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidArnFault [InvalidARNFault]")?;
        if let Some(inner_29) = &self.message {
            write!(f, ": {}", inner_29)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidArnFault {}
/// See [`InvalidArnFault`](crate::error::InvalidArnFault)
pub mod invalid_arn_fault {
    /// A builder for [`InvalidArnFault`](crate::error::InvalidArnFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidArnFault`](crate::error::InvalidArnFault)
        pub fn build(self) -> crate::error::InvalidArnFault {
            crate::error::InvalidArnFault {
                message: self.message,
            }
        }
    }
}
impl InvalidArnFault {
    /// Creates a new builder-style object to manufacture [`InvalidArnFault`](crate::error::InvalidArnFault)
    pub fn builder() -> crate::error::invalid_arn_fault::Builder {
        crate::error::invalid_arn_fault::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagQuotaPerResourceExceeded {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TagQuotaPerResourceExceeded {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagQuotaPerResourceExceeded");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TagQuotaPerResourceExceeded {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TagQuotaPerResourceExceeded {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TagQuotaPerResourceExceeded")?;
        if let Some(inner_30) = &self.message {
            write!(f, ": {}", inner_30)?;
        }
        Ok(())
    }
}
impl std::error::Error for TagQuotaPerResourceExceeded {}
/// See [`TagQuotaPerResourceExceeded`](crate::error::TagQuotaPerResourceExceeded)
pub mod tag_quota_per_resource_exceeded {
    /// A builder for [`TagQuotaPerResourceExceeded`](crate::error::TagQuotaPerResourceExceeded)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TagQuotaPerResourceExceeded`](crate::error::TagQuotaPerResourceExceeded)
        pub fn build(self) -> crate::error::TagQuotaPerResourceExceeded {
            crate::error::TagQuotaPerResourceExceeded {
                message: self.message,
            }
        }
    }
}
impl TagQuotaPerResourceExceeded {
    /// Creates a new builder-style object to manufacture [`TagQuotaPerResourceExceeded`](crate::error::TagQuotaPerResourceExceeded)
    pub fn builder() -> crate::error::tag_quota_per_resource_exceeded::Builder {
        crate::error::tag_quota_per_resource_exceeded::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TestFailoverNotAvailableFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TestFailoverNotAvailableFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TestFailoverNotAvailableFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TestFailoverNotAvailableFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TestFailoverNotAvailableFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TestFailoverNotAvailableFault")?;
        if let Some(inner_31) = &self.message {
            write!(f, ": {}", inner_31)?;
        }
        Ok(())
    }
}
impl std::error::Error for TestFailoverNotAvailableFault {}
/// See [`TestFailoverNotAvailableFault`](crate::error::TestFailoverNotAvailableFault)
pub mod test_failover_not_available_fault {
    /// A builder for [`TestFailoverNotAvailableFault`](crate::error::TestFailoverNotAvailableFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TestFailoverNotAvailableFault`](crate::error::TestFailoverNotAvailableFault)
        pub fn build(self) -> crate::error::TestFailoverNotAvailableFault {
            crate::error::TestFailoverNotAvailableFault {
                message: self.message,
            }
        }
    }
}
impl TestFailoverNotAvailableFault {
    /// Creates a new builder-style object to manufacture [`TestFailoverNotAvailableFault`](crate::error::TestFailoverNotAvailableFault)
    pub fn builder() -> crate::error::test_failover_not_available_fault::Builder {
        crate::error::test_failover_not_available_fault::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ShardNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ShardNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ShardNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ShardNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ShardNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ShardNotFoundFault")?;
        if let Some(inner_32) = &self.message {
            write!(f, ": {}", inner_32)?;
        }
        Ok(())
    }
}
impl std::error::Error for ShardNotFoundFault {}
/// See [`ShardNotFoundFault`](crate::error::ShardNotFoundFault)
pub mod shard_not_found_fault {
    /// A builder for [`ShardNotFoundFault`](crate::error::ShardNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ShardNotFoundFault`](crate::error::ShardNotFoundFault)
        pub fn build(self) -> crate::error::ShardNotFoundFault {
            crate::error::ShardNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl ShardNotFoundFault {
    /// Creates a new builder-style object to manufacture [`ShardNotFoundFault`](crate::error::ShardNotFoundFault)
    pub fn builder() -> crate::error::shard_not_found_fault::Builder {
        crate::error::shard_not_found_fault::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApiCallRateForCustomerExceededFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ApiCallRateForCustomerExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApiCallRateForCustomerExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ApiCallRateForCustomerExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ApiCallRateForCustomerExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "ApiCallRateForCustomerExceededFault [APICallRateForCustomerExceededFault]"
        )?;
        if let Some(inner_33) = &self.message {
            write!(f, ": {}", inner_33)?;
        }
        Ok(())
    }
}
impl std::error::Error for ApiCallRateForCustomerExceededFault {}
/// See [`ApiCallRateForCustomerExceededFault`](crate::error::ApiCallRateForCustomerExceededFault)
pub mod api_call_rate_for_customer_exceeded_fault {
    /// A builder for [`ApiCallRateForCustomerExceededFault`](crate::error::ApiCallRateForCustomerExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ApiCallRateForCustomerExceededFault`](crate::error::ApiCallRateForCustomerExceededFault)
        pub fn build(self) -> crate::error::ApiCallRateForCustomerExceededFault {
            crate::error::ApiCallRateForCustomerExceededFault {
                message: self.message,
            }
        }
    }
}
impl ApiCallRateForCustomerExceededFault {
    /// Creates a new builder-style object to manufacture [`ApiCallRateForCustomerExceededFault`](crate::error::ApiCallRateForCustomerExceededFault)
    pub fn builder() -> crate::error::api_call_rate_for_customer_exceeded_fault::Builder {
        crate::error::api_call_rate_for_customer_exceeded_fault::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SubnetGroupInUseFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SubnetGroupInUseFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SubnetGroupInUseFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SubnetGroupInUseFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SubnetGroupInUseFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SubnetGroupInUseFault")?;
        if let Some(inner_34) = &self.message {
            write!(f, ": {}", inner_34)?;
        }
        Ok(())
    }
}
impl std::error::Error for SubnetGroupInUseFault {}
/// See [`SubnetGroupInUseFault`](crate::error::SubnetGroupInUseFault)
pub mod subnet_group_in_use_fault {
    /// A builder for [`SubnetGroupInUseFault`](crate::error::SubnetGroupInUseFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SubnetGroupInUseFault`](crate::error::SubnetGroupInUseFault)
        pub fn build(self) -> crate::error::SubnetGroupInUseFault {
            crate::error::SubnetGroupInUseFault {
                message: self.message,
            }
        }
    }
}
impl SubnetGroupInUseFault {
    /// Creates a new builder-style object to manufacture [`SubnetGroupInUseFault`](crate::error::SubnetGroupInUseFault)
    pub fn builder() -> crate::error::subnet_group_in_use_fault::Builder {
        crate::error::subnet_group_in_use_fault::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidSnapshotStateFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidSnapshotStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidSnapshotStateFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidSnapshotStateFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidSnapshotStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidSnapshotStateFault")?;
        if let Some(inner_35) = &self.message {
            write!(f, ": {}", inner_35)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidSnapshotStateFault {}
/// See [`InvalidSnapshotStateFault`](crate::error::InvalidSnapshotStateFault)
pub mod invalid_snapshot_state_fault {
    /// A builder for [`InvalidSnapshotStateFault`](crate::error::InvalidSnapshotStateFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidSnapshotStateFault`](crate::error::InvalidSnapshotStateFault)
        pub fn build(self) -> crate::error::InvalidSnapshotStateFault {
            crate::error::InvalidSnapshotStateFault {
                message: self.message,
            }
        }
    }
}
impl InvalidSnapshotStateFault {
    /// Creates a new builder-style object to manufacture [`InvalidSnapshotStateFault`](crate::error::InvalidSnapshotStateFault)
    pub fn builder() -> crate::error::invalid_snapshot_state_fault::Builder {
        crate::error::invalid_snapshot_state_fault::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SnapshotAlreadyExistsFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SnapshotAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SnapshotAlreadyExistsFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SnapshotAlreadyExistsFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SnapshotAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SnapshotAlreadyExistsFault")?;
        if let Some(inner_36) = &self.message {
            write!(f, ": {}", inner_36)?;
        }
        Ok(())
    }
}
impl std::error::Error for SnapshotAlreadyExistsFault {}
/// See [`SnapshotAlreadyExistsFault`](crate::error::SnapshotAlreadyExistsFault)
pub mod snapshot_already_exists_fault {
    /// A builder for [`SnapshotAlreadyExistsFault`](crate::error::SnapshotAlreadyExistsFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SnapshotAlreadyExistsFault`](crate::error::SnapshotAlreadyExistsFault)
        pub fn build(self) -> crate::error::SnapshotAlreadyExistsFault {
            crate::error::SnapshotAlreadyExistsFault {
                message: self.message,
            }
        }
    }
}
impl SnapshotAlreadyExistsFault {
    /// Creates a new builder-style object to manufacture [`SnapshotAlreadyExistsFault`](crate::error::SnapshotAlreadyExistsFault)
    pub fn builder() -> crate::error::snapshot_already_exists_fault::Builder {
        crate::error::snapshot_already_exists_fault::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserQuotaExceededFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UserQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserQuotaExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UserQuotaExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UserQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UserQuotaExceededFault")?;
        if let Some(inner_37) = &self.message {
            write!(f, ": {}", inner_37)?;
        }
        Ok(())
    }
}
impl std::error::Error for UserQuotaExceededFault {}
/// See [`UserQuotaExceededFault`](crate::error::UserQuotaExceededFault)
pub mod user_quota_exceeded_fault {
    /// A builder for [`UserQuotaExceededFault`](crate::error::UserQuotaExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UserQuotaExceededFault`](crate::error::UserQuotaExceededFault)
        pub fn build(self) -> crate::error::UserQuotaExceededFault {
            crate::error::UserQuotaExceededFault {
                message: self.message,
            }
        }
    }
}
impl UserQuotaExceededFault {
    /// Creates a new builder-style object to manufacture [`UserQuotaExceededFault`](crate::error::UserQuotaExceededFault)
    pub fn builder() -> crate::error::user_quota_exceeded_fault::Builder {
        crate::error::user_quota_exceeded_fault::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserAlreadyExistsFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UserAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserAlreadyExistsFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UserAlreadyExistsFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UserAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UserAlreadyExistsFault")?;
        if let Some(inner_38) = &self.message {
            write!(f, ": {}", inner_38)?;
        }
        Ok(())
    }
}
impl std::error::Error for UserAlreadyExistsFault {}
/// See [`UserAlreadyExistsFault`](crate::error::UserAlreadyExistsFault)
pub mod user_already_exists_fault {
    /// A builder for [`UserAlreadyExistsFault`](crate::error::UserAlreadyExistsFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UserAlreadyExistsFault`](crate::error::UserAlreadyExistsFault)
        pub fn build(self) -> crate::error::UserAlreadyExistsFault {
            crate::error::UserAlreadyExistsFault {
                message: self.message,
            }
        }
    }
}
impl UserAlreadyExistsFault {
    /// Creates a new builder-style object to manufacture [`UserAlreadyExistsFault`](crate::error::UserAlreadyExistsFault)
    pub fn builder() -> crate::error::user_already_exists_fault::Builder {
        crate::error::user_already_exists_fault::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SubnetGroupQuotaExceededFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SubnetGroupQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SubnetGroupQuotaExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SubnetGroupQuotaExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SubnetGroupQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SubnetGroupQuotaExceededFault")?;
        if let Some(inner_39) = &self.message {
            write!(f, ": {}", inner_39)?;
        }
        Ok(())
    }
}
impl std::error::Error for SubnetGroupQuotaExceededFault {}
/// See [`SubnetGroupQuotaExceededFault`](crate::error::SubnetGroupQuotaExceededFault)
pub mod subnet_group_quota_exceeded_fault {
    /// A builder for [`SubnetGroupQuotaExceededFault`](crate::error::SubnetGroupQuotaExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SubnetGroupQuotaExceededFault`](crate::error::SubnetGroupQuotaExceededFault)
        pub fn build(self) -> crate::error::SubnetGroupQuotaExceededFault {
            crate::error::SubnetGroupQuotaExceededFault {
                message: self.message,
            }
        }
    }
}
impl SubnetGroupQuotaExceededFault {
    /// Creates a new builder-style object to manufacture [`SubnetGroupQuotaExceededFault`](crate::error::SubnetGroupQuotaExceededFault)
    pub fn builder() -> crate::error::subnet_group_quota_exceeded_fault::Builder {
        crate::error::subnet_group_quota_exceeded_fault::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SubnetGroupAlreadyExistsFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SubnetGroupAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SubnetGroupAlreadyExistsFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SubnetGroupAlreadyExistsFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SubnetGroupAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SubnetGroupAlreadyExistsFault")?;
        if let Some(inner_40) = &self.message {
            write!(f, ": {}", inner_40)?;
        }
        Ok(())
    }
}
impl std::error::Error for SubnetGroupAlreadyExistsFault {}
/// See [`SubnetGroupAlreadyExistsFault`](crate::error::SubnetGroupAlreadyExistsFault)
pub mod subnet_group_already_exists_fault {
    /// A builder for [`SubnetGroupAlreadyExistsFault`](crate::error::SubnetGroupAlreadyExistsFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SubnetGroupAlreadyExistsFault`](crate::error::SubnetGroupAlreadyExistsFault)
        pub fn build(self) -> crate::error::SubnetGroupAlreadyExistsFault {
            crate::error::SubnetGroupAlreadyExistsFault {
                message: self.message,
            }
        }
    }
}
impl SubnetGroupAlreadyExistsFault {
    /// Creates a new builder-style object to manufacture [`SubnetGroupAlreadyExistsFault`](crate::error::SubnetGroupAlreadyExistsFault)
    pub fn builder() -> crate::error::subnet_group_already_exists_fault::Builder {
        crate::error::subnet_group_already_exists_fault::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SnapshotQuotaExceededFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SnapshotQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SnapshotQuotaExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SnapshotQuotaExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SnapshotQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SnapshotQuotaExceededFault")?;
        if let Some(inner_41) = &self.message {
            write!(f, ": {}", inner_41)?;
        }
        Ok(())
    }
}
impl std::error::Error for SnapshotQuotaExceededFault {}
/// See [`SnapshotQuotaExceededFault`](crate::error::SnapshotQuotaExceededFault)
pub mod snapshot_quota_exceeded_fault {
    /// A builder for [`SnapshotQuotaExceededFault`](crate::error::SnapshotQuotaExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SnapshotQuotaExceededFault`](crate::error::SnapshotQuotaExceededFault)
        pub fn build(self) -> crate::error::SnapshotQuotaExceededFault {
            crate::error::SnapshotQuotaExceededFault {
                message: self.message,
            }
        }
    }
}
impl SnapshotQuotaExceededFault {
    /// Creates a new builder-style object to manufacture [`SnapshotQuotaExceededFault`](crate::error::SnapshotQuotaExceededFault)
    pub fn builder() -> crate::error::snapshot_quota_exceeded_fault::Builder {
        crate::error::snapshot_quota_exceeded_fault::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ParameterGroupQuotaExceededFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ParameterGroupQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ParameterGroupQuotaExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ParameterGroupQuotaExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ParameterGroupQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ParameterGroupQuotaExceededFault")?;
        if let Some(inner_42) = &self.message {
            write!(f, ": {}", inner_42)?;
        }
        Ok(())
    }
}
impl std::error::Error for ParameterGroupQuotaExceededFault {}
/// See [`ParameterGroupQuotaExceededFault`](crate::error::ParameterGroupQuotaExceededFault)
pub mod parameter_group_quota_exceeded_fault {
    /// A builder for [`ParameterGroupQuotaExceededFault`](crate::error::ParameterGroupQuotaExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ParameterGroupQuotaExceededFault`](crate::error::ParameterGroupQuotaExceededFault)
        pub fn build(self) -> crate::error::ParameterGroupQuotaExceededFault {
            crate::error::ParameterGroupQuotaExceededFault {
                message: self.message,
            }
        }
    }
}
impl ParameterGroupQuotaExceededFault {
    /// Creates a new builder-style object to manufacture [`ParameterGroupQuotaExceededFault`](crate::error::ParameterGroupQuotaExceededFault)
    pub fn builder() -> crate::error::parameter_group_quota_exceeded_fault::Builder {
        crate::error::parameter_group_quota_exceeded_fault::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ParameterGroupAlreadyExistsFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ParameterGroupAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ParameterGroupAlreadyExistsFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ParameterGroupAlreadyExistsFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ParameterGroupAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ParameterGroupAlreadyExistsFault")?;
        if let Some(inner_43) = &self.message {
            write!(f, ": {}", inner_43)?;
        }
        Ok(())
    }
}
impl std::error::Error for ParameterGroupAlreadyExistsFault {}
/// See [`ParameterGroupAlreadyExistsFault`](crate::error::ParameterGroupAlreadyExistsFault)
pub mod parameter_group_already_exists_fault {
    /// A builder for [`ParameterGroupAlreadyExistsFault`](crate::error::ParameterGroupAlreadyExistsFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ParameterGroupAlreadyExistsFault`](crate::error::ParameterGroupAlreadyExistsFault)
        pub fn build(self) -> crate::error::ParameterGroupAlreadyExistsFault {
            crate::error::ParameterGroupAlreadyExistsFault {
                message: self.message,
            }
        }
    }
}
impl ParameterGroupAlreadyExistsFault {
    /// Creates a new builder-style object to manufacture [`ParameterGroupAlreadyExistsFault`](crate::error::ParameterGroupAlreadyExistsFault)
    pub fn builder() -> crate::error::parameter_group_already_exists_fault::Builder {
        crate::error::parameter_group_already_exists_fault::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidCredentialsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidCredentialsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidCredentialsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidCredentialsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidCredentialsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidCredentialsException")?;
        if let Some(inner_44) = &self.message {
            write!(f, ": {}", inner_44)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidCredentialsException {}
/// See [`InvalidCredentialsException`](crate::error::InvalidCredentialsException)
pub mod invalid_credentials_exception {
    /// A builder for [`InvalidCredentialsException`](crate::error::InvalidCredentialsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidCredentialsException`](crate::error::InvalidCredentialsException)
        pub fn build(self) -> crate::error::InvalidCredentialsException {
            crate::error::InvalidCredentialsException {
                message: self.message,
            }
        }
    }
}
impl InvalidCredentialsException {
    /// Creates a new builder-style object to manufacture [`InvalidCredentialsException`](crate::error::InvalidCredentialsException)
    pub fn builder() -> crate::error::invalid_credentials_exception::Builder {
        crate::error::invalid_credentials_exception::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InsufficientClusterCapacityFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InsufficientClusterCapacityFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InsufficientClusterCapacityFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InsufficientClusterCapacityFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InsufficientClusterCapacityFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InsufficientClusterCapacityFault")?;
        if let Some(inner_45) = &self.message {
            write!(f, ": {}", inner_45)?;
        }
        Ok(())
    }
}
impl std::error::Error for InsufficientClusterCapacityFault {}
/// See [`InsufficientClusterCapacityFault`](crate::error::InsufficientClusterCapacityFault)
pub mod insufficient_cluster_capacity_fault {
    /// A builder for [`InsufficientClusterCapacityFault`](crate::error::InsufficientClusterCapacityFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InsufficientClusterCapacityFault`](crate::error::InsufficientClusterCapacityFault)
        pub fn build(self) -> crate::error::InsufficientClusterCapacityFault {
            crate::error::InsufficientClusterCapacityFault {
                message: self.message,
            }
        }
    }
}
impl InsufficientClusterCapacityFault {
    /// Creates a new builder-style object to manufacture [`InsufficientClusterCapacityFault`](crate::error::InsufficientClusterCapacityFault)
    pub fn builder() -> crate::error::insufficient_cluster_capacity_fault::Builder {
        crate::error::insufficient_cluster_capacity_fault::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClusterAlreadyExistsFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ClusterAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClusterAlreadyExistsFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ClusterAlreadyExistsFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ClusterAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ClusterAlreadyExistsFault")?;
        if let Some(inner_46) = &self.message {
            write!(f, ": {}", inner_46)?;
        }
        Ok(())
    }
}
impl std::error::Error for ClusterAlreadyExistsFault {}
/// See [`ClusterAlreadyExistsFault`](crate::error::ClusterAlreadyExistsFault)
pub mod cluster_already_exists_fault {
    /// A builder for [`ClusterAlreadyExistsFault`](crate::error::ClusterAlreadyExistsFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ClusterAlreadyExistsFault`](crate::error::ClusterAlreadyExistsFault)
        pub fn build(self) -> crate::error::ClusterAlreadyExistsFault {
            crate::error::ClusterAlreadyExistsFault {
                message: self.message,
            }
        }
    }
}
impl ClusterAlreadyExistsFault {
    /// Creates a new builder-style object to manufacture [`ClusterAlreadyExistsFault`](crate::error::ClusterAlreadyExistsFault)
    pub fn builder() -> crate::error::cluster_already_exists_fault::Builder {
        crate::error::cluster_already_exists_fault::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AclQuotaExceededFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AclQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AclQuotaExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AclQuotaExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AclQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AclQuotaExceededFault [ACLQuotaExceededFault]")?;
        if let Some(inner_47) = &self.message {
            write!(f, ": {}", inner_47)?;
        }
        Ok(())
    }
}
impl std::error::Error for AclQuotaExceededFault {}
/// See [`AclQuotaExceededFault`](crate::error::AclQuotaExceededFault)
pub mod acl_quota_exceeded_fault {
    /// A builder for [`AclQuotaExceededFault`](crate::error::AclQuotaExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AclQuotaExceededFault`](crate::error::AclQuotaExceededFault)
        pub fn build(self) -> crate::error::AclQuotaExceededFault {
            crate::error::AclQuotaExceededFault {
                message: self.message,
            }
        }
    }
}
impl AclQuotaExceededFault {
    /// Creates a new builder-style object to manufacture [`AclQuotaExceededFault`](crate::error::AclQuotaExceededFault)
    pub fn builder() -> crate::error::acl_quota_exceeded_fault::Builder {
        crate::error::acl_quota_exceeded_fault::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AclAlreadyExistsFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AclAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AclAlreadyExistsFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AclAlreadyExistsFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AclAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AclAlreadyExistsFault [ACLAlreadyExistsFault]")?;
        if let Some(inner_48) = &self.message {
            write!(f, ": {}", inner_48)?;
        }
        Ok(())
    }
}
impl std::error::Error for AclAlreadyExistsFault {}
/// See [`AclAlreadyExistsFault`](crate::error::AclAlreadyExistsFault)
pub mod acl_already_exists_fault {
    /// A builder for [`AclAlreadyExistsFault`](crate::error::AclAlreadyExistsFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AclAlreadyExistsFault`](crate::error::AclAlreadyExistsFault)
        pub fn build(self) -> crate::error::AclAlreadyExistsFault {
            crate::error::AclAlreadyExistsFault {
                message: self.message,
            }
        }
    }
}
impl AclAlreadyExistsFault {
    /// Creates a new builder-style object to manufacture [`AclAlreadyExistsFault`](crate::error::AclAlreadyExistsFault)
    pub fn builder() -> crate::error::acl_already_exists_fault::Builder {
        crate::error::acl_already_exists_fault::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceUpdateNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceUpdateNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceUpdateNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceUpdateNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceUpdateNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceUpdateNotFoundFault")?;
        if let Some(inner_49) = &self.message {
            write!(f, ": {}", inner_49)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceUpdateNotFoundFault {}
/// See [`ServiceUpdateNotFoundFault`](crate::error::ServiceUpdateNotFoundFault)
pub mod service_update_not_found_fault {
    /// A builder for [`ServiceUpdateNotFoundFault`](crate::error::ServiceUpdateNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceUpdateNotFoundFault`](crate::error::ServiceUpdateNotFoundFault)
        pub fn build(self) -> crate::error::ServiceUpdateNotFoundFault {
            crate::error::ServiceUpdateNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl ServiceUpdateNotFoundFault {
    /// Creates a new builder-style object to manufacture [`ServiceUpdateNotFoundFault`](crate::error::ServiceUpdateNotFoundFault)
    pub fn builder() -> crate::error::service_update_not_found_fault::Builder {
        crate::error::service_update_not_found_fault::Builder::default()
    }
}
