// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// Client for AWS Elemental MediaStore Data Plane
///
/// Client for invoking operations on AWS Elemental MediaStore Data Plane. Each operation on AWS Elemental MediaStore Data Plane is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_mediastoredata::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operationname>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_mediastoredata::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_mediastoredata::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `DeleteObject` operation.
    ///
    /// See [`DeleteObject`](crate::client::fluent_builders::DeleteObject) for more information about the
    /// operation and its arguments.
    pub fn delete_object(&self) -> fluent_builders::DeleteObject<C, M, R> {
        fluent_builders::DeleteObject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeObject` operation.
    ///
    /// See [`DescribeObject`](crate::client::fluent_builders::DescribeObject) for more information about the
    /// operation and its arguments.
    pub fn describe_object(&self) -> fluent_builders::DescribeObject<C, M, R> {
        fluent_builders::DescribeObject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetObject` operation.
    ///
    /// See [`GetObject`](crate::client::fluent_builders::GetObject) for more information about the
    /// operation and its arguments.
    pub fn get_object(&self) -> fluent_builders::GetObject<C, M, R> {
        fluent_builders::GetObject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListItems` operation.
    ///
    /// See [`ListItems`](crate::client::fluent_builders::ListItems) for more information about the
    /// operation and its arguments.
    pub fn list_items(&self) -> fluent_builders::ListItems<C, M, R> {
        fluent_builders::ListItems::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutObject` operation.
    ///
    /// See [`PutObject`](crate::client::fluent_builders::PutObject) for more information about the
    /// operation and its arguments.
    pub fn put_object(&self) -> fluent_builders::PutObject<C, M, R> {
        fluent_builders::PutObject::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `DeleteObject`.
    ///
    /// <p>Deletes an object at the specified path.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteObject<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_object_input::Builder,
    }
    impl<C, M, R> DeleteObject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteObject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteObjectOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteObjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteObjectInputOperationOutputAlias,
                crate::output::DeleteObjectOutput,
                crate::error::DeleteObjectError,
                crate::input::DeleteObjectInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The path (including the file name) where the object is stored in the container.
        /// Format: <folder name>/<folder name>/<file name></p>
        pub fn path(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.path(inp);
            self
        }
        /// <p>The path (including the file name) where the object is stored in the container.
        /// Format: <folder name>/<folder name>/<file name></p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_path(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeObject`.
    ///
    /// <p>Gets the headers for an object at the specified path.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeObject<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_object_input::Builder,
    }
    impl<C, M, R> DescribeObject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeObject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeObjectOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeObjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeObjectInputOperationOutputAlias,
                crate::output::DescribeObjectOutput,
                crate::error::DescribeObjectError,
                crate::input::DescribeObjectInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The path (including the file name) where the object is stored in the container.
        /// Format: <folder name>/<folder name>/<file name></p>
        pub fn path(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.path(inp);
            self
        }
        /// <p>The path (including the file name) where the object is stored in the container.
        /// Format: <folder name>/<folder name>/<file name></p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_path(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetObject`.
    ///
    /// <p>Downloads the object at the specified path. If the object’s upload availability is set to <code>streaming</code>, AWS Elemental MediaStore downloads the object even if it’s still uploading the object.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetObject<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_object_input::Builder,
    }
    impl<C, M, R> GetObject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetObject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetObjectOutput,
            aws_smithy_http::result::SdkError<crate::error::GetObjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetObjectInputOperationOutputAlias,
                crate::output::GetObjectOutput,
                crate::error::GetObjectError,
                crate::input::GetObjectInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The path (including the file name) where the object is stored in the container.
        /// Format: <folder name>/<folder name>/<file name></p>
        /// <p>For example, to upload the file <code>mlaw.avi</code> to the folder path
        /// <code>premium\canada</code> in the container <code>movies</code>, enter the path
        /// <code>premium/canada/mlaw.avi</code>.</p>
        /// <p>Do not include the container name in this path.</p>
        /// <p>If the path includes any folders that don't exist yet, the service creates them. For
        /// example, suppose you have an existing <code>premium/usa</code> subfolder. If you specify
        /// <code>premium/canada</code>, the service creates a <code>canada</code> subfolder in the
        /// <code>premium</code> folder. You then have two subfolders, <code>usa</code> and
        /// <code>canada</code>, in the <code>premium</code> folder. </p>
        /// <p>There is no correlation between the path to the source and the path (folders) in the
        /// container in AWS Elemental MediaStore.</p>
        /// <p>For more information about folders and how they exist in a container, see the <a href="http://docs.aws.amazon.com/mediastore/latest/ug/">AWS Elemental MediaStore User
        /// Guide</a>.</p>
        /// <p>The file name is the name that is assigned to the file that you upload. The file can
        /// have the same name inside and outside of AWS Elemental MediaStore, or it can have the same
        /// name. The file name can include or omit an extension. </p>
        pub fn path(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.path(inp);
            self
        }
        /// <p>The path (including the file name) where the object is stored in the container.
        /// Format: <folder name>/<folder name>/<file name></p>
        /// <p>For example, to upload the file <code>mlaw.avi</code> to the folder path
        /// <code>premium\canada</code> in the container <code>movies</code>, enter the path
        /// <code>premium/canada/mlaw.avi</code>.</p>
        /// <p>Do not include the container name in this path.</p>
        /// <p>If the path includes any folders that don't exist yet, the service creates them. For
        /// example, suppose you have an existing <code>premium/usa</code> subfolder. If you specify
        /// <code>premium/canada</code>, the service creates a <code>canada</code> subfolder in the
        /// <code>premium</code> folder. You then have two subfolders, <code>usa</code> and
        /// <code>canada</code>, in the <code>premium</code> folder. </p>
        /// <p>There is no correlation between the path to the source and the path (folders) in the
        /// container in AWS Elemental MediaStore.</p>
        /// <p>For more information about folders and how they exist in a container, see the <a href="http://docs.aws.amazon.com/mediastore/latest/ug/">AWS Elemental MediaStore User
        /// Guide</a>.</p>
        /// <p>The file name is the name that is assigned to the file that you upload. The file can
        /// have the same name inside and outside of AWS Elemental MediaStore, or it can have the same
        /// name. The file name can include or omit an extension. </p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_path(input);
            self
        }
        /// <p>The range bytes of an object to retrieve. For more information about the
        /// <code>Range</code> header, see <a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35">http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35</a>. AWS Elemental MediaStore ignores this header for partially uploaded objects that have streaming upload availability.</p>
        pub fn range(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.range(inp);
            self
        }
        /// <p>The range bytes of an object to retrieve. For more information about the
        /// <code>Range</code> header, see <a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35">http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35</a>. AWS Elemental MediaStore ignores this header for partially uploaded objects that have streaming upload availability.</p>
        pub fn set_range(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_range(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListItems`.
    ///
    /// <p>Provides a list of metadata entries about folders and objects in the specified
    /// folder.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListItems<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_items_input::Builder,
    }
    impl<C, M, R> ListItems<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListItems`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListItemsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListItemsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListItemsInputOperationOutputAlias,
                crate::output::ListItemsOutput,
                crate::error::ListItemsError,
                crate::input::ListItemsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The path in the container from which to retrieve items. Format: <folder
        /// name>/<folder name>/<file name></p>
        pub fn path(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.path(inp);
            self
        }
        /// <p>The path in the container from which to retrieve items. Format: <folder
        /// name>/<folder name>/<file name></p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_path(input);
            self
        }
        /// <p>The maximum number of results to return per API request. For example, you submit a
        /// <code>ListItems</code> request with <code>MaxResults</code> set at 500. Although 2,000
        /// items match your request, the service returns no more than the first 500 items. (The
        /// service also returns a <code>NextToken</code> value that you can use to fetch the next
        /// batch of results.) The service might return fewer results than the <code>MaxResults</code>
        /// value.</p>
        /// <p>If <code>MaxResults</code> is not included in the request, the service defaults to
        /// pagination with a maximum of 1,000 results per page.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return per API request. For example, you submit a
        /// <code>ListItems</code> request with <code>MaxResults</code> set at 500. Although 2,000
        /// items match your request, the service returns no more than the first 500 items. (The
        /// service also returns a <code>NextToken</code> value that you can use to fetch the next
        /// batch of results.) The service might return fewer results than the <code>MaxResults</code>
        /// value.</p>
        /// <p>If <code>MaxResults</code> is not included in the request, the service defaults to
        /// pagination with a maximum of 1,000 results per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token that identifies which batch of results that you want to see. For example,
        /// you submit a <code>ListItems</code> request with <code>MaxResults</code> set at 500. The
        /// service returns the first batch of results (up to 500) and a <code>NextToken</code> value.
        /// To see the next batch of results, you can submit the <code>ListItems</code> request a
        /// second time and specify the <code>NextToken</code> value.</p>
        /// <p>Tokens expire after 15 minutes.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token that identifies which batch of results that you want to see. For example,
        /// you submit a <code>ListItems</code> request with <code>MaxResults</code> set at 500. The
        /// service returns the first batch of results (up to 500) and a <code>NextToken</code> value.
        /// To see the next batch of results, you can submit the <code>ListItems</code> request a
        /// second time and specify the <code>NextToken</code> value.</p>
        /// <p>Tokens expire after 15 minutes.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutObject`.
    ///
    /// <p>Uploads an object to the specified path. Object sizes are limited to 25 MB for standard upload availability and 10 MB for streaming upload availability.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutObject<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_object_input::Builder,
    }
    impl<C, M, R> PutObject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutObject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutObjectOutput,
            aws_smithy_http::result::SdkError<crate::error::PutObjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutObjectInputOperationOutputAlias,
                crate::output::PutObjectOutput,
                crate::error::PutObjectError,
                crate::input::PutObjectInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The bytes to be stored. </p>
        pub fn body(mut self, inp: aws_smithy_http::byte_stream::ByteStream) -> Self {
            self.inner = self.inner.body(inp);
            self
        }
        /// <p>The bytes to be stored. </p>
        pub fn set_body(
            mut self,
            input: std::option::Option<aws_smithy_http::byte_stream::ByteStream>,
        ) -> Self {
            self.inner = self.inner.set_body(input);
            self
        }
        /// <p>The path (including the file name) where the object is stored in the container.
        /// Format: <folder name>/<folder name>/<file name></p>
        /// <p>For example, to upload the file <code>mlaw.avi</code> to the folder path
        /// <code>premium\canada</code> in the container <code>movies</code>, enter the path
        /// <code>premium/canada/mlaw.avi</code>.</p>
        /// <p>Do not include the container name in this path.</p>
        /// <p>If the path includes any folders that don't exist yet, the service creates them. For
        /// example, suppose you have an existing <code>premium/usa</code> subfolder. If you specify
        /// <code>premium/canada</code>, the service creates a <code>canada</code> subfolder in the
        /// <code>premium</code> folder. You then have two subfolders, <code>usa</code> and
        /// <code>canada</code>, in the <code>premium</code> folder. </p>
        /// <p>There is no correlation between the path to the source and the path (folders) in the
        /// container in AWS Elemental MediaStore.</p>
        /// <p>For more information about folders and how they exist in a container, see the <a href="http://docs.aws.amazon.com/mediastore/latest/ug/">AWS Elemental MediaStore User
        /// Guide</a>.</p>
        /// <p>The file name is the name that is assigned to the file that you upload. The file can
        /// have the same name inside and outside of AWS Elemental MediaStore, or it can have the same
        /// name. The file name can include or omit an extension. </p>
        pub fn path(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.path(inp);
            self
        }
        /// <p>The path (including the file name) where the object is stored in the container.
        /// Format: <folder name>/<folder name>/<file name></p>
        /// <p>For example, to upload the file <code>mlaw.avi</code> to the folder path
        /// <code>premium\canada</code> in the container <code>movies</code>, enter the path
        /// <code>premium/canada/mlaw.avi</code>.</p>
        /// <p>Do not include the container name in this path.</p>
        /// <p>If the path includes any folders that don't exist yet, the service creates them. For
        /// example, suppose you have an existing <code>premium/usa</code> subfolder. If you specify
        /// <code>premium/canada</code>, the service creates a <code>canada</code> subfolder in the
        /// <code>premium</code> folder. You then have two subfolders, <code>usa</code> and
        /// <code>canada</code>, in the <code>premium</code> folder. </p>
        /// <p>There is no correlation between the path to the source and the path (folders) in the
        /// container in AWS Elemental MediaStore.</p>
        /// <p>For more information about folders and how they exist in a container, see the <a href="http://docs.aws.amazon.com/mediastore/latest/ug/">AWS Elemental MediaStore User
        /// Guide</a>.</p>
        /// <p>The file name is the name that is assigned to the file that you upload. The file can
        /// have the same name inside and outside of AWS Elemental MediaStore, or it can have the same
        /// name. The file name can include or omit an extension. </p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_path(input);
            self
        }
        /// <p>The content type of the object.</p>
        pub fn content_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content_type(inp);
            self
        }
        /// <p>The content type of the object.</p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content_type(input);
            self
        }
        /// <p>An optional <code>CacheControl</code> header that allows the caller to control the
        /// object's cache behavior. Headers can be passed in as specified in the HTTP at <a href="https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9">https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9</a>.</p>
        /// <p>Headers with a custom user-defined value are also accepted.</p>
        pub fn cache_control(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cache_control(inp);
            self
        }
        /// <p>An optional <code>CacheControl</code> header that allows the caller to control the
        /// object's cache behavior. Headers can be passed in as specified in the HTTP at <a href="https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9">https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9</a>.</p>
        /// <p>Headers with a custom user-defined value are also accepted.</p>
        pub fn set_cache_control(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cache_control(input);
            self
        }
        /// <p>Indicates the storage class of a <code>Put</code> request. Defaults to
        /// high-performance temporal storage class, and objects are persisted into durable storage
        /// shortly after being received.</p>
        pub fn storage_class(mut self, inp: crate::model::StorageClass) -> Self {
            self.inner = self.inner.storage_class(inp);
            self
        }
        /// <p>Indicates the storage class of a <code>Put</code> request. Defaults to
        /// high-performance temporal storage class, and objects are persisted into durable storage
        /// shortly after being received.</p>
        pub fn set_storage_class(
            mut self,
            input: std::option::Option<crate::model::StorageClass>,
        ) -> Self {
            self.inner = self.inner.set_storage_class(input);
            self
        }
        /// <p>Indicates the availability of an object while it is still uploading. If the value is set to <code>streaming</code>, the object is available for
        /// downloading after some initial buffering but before the object is uploaded completely. If the value is set to <code>standard</code>, the object is
        /// available for downloading only when it is uploaded completely. The default value for this header is <code>standard</code>.</p>
        /// <p>To use this header, you must also set the HTTP <code>Transfer-Encoding</code> header to <code>chunked</code>.</p>
        pub fn upload_availability(mut self, inp: crate::model::UploadAvailability) -> Self {
            self.inner = self.inner.upload_availability(inp);
            self
        }
        /// <p>Indicates the availability of an object while it is still uploading. If the value is set to <code>streaming</code>, the object is available for
        /// downloading after some initial buffering but before the object is uploaded completely. If the value is set to <code>standard</code>, the object is
        /// available for downloading only when it is uploaded completely. The default value for this header is <code>standard</code>.</p>
        /// <p>To use this header, you must also set the HTTP <code>Transfer-Encoding</code> header to <code>chunked</code>.</p>
        pub fn set_upload_availability(
            mut self,
            input: std::option::Option<crate::model::UploadAvailability>,
        ) -> Self {
            self.inner = self.inner.set_upload_availability(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::new(conn)
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::https()
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
