// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`DeleteObjectInput`](crate::input::DeleteObjectInput)
pub mod delete_object_input {
    /// A builder for [`DeleteObjectInput`](crate::input::DeleteObjectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) path: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The path (including the file name) where the object is stored in the container.
        /// Format: <folder name>/<folder name>/<file name></p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p>The path (including the file name) where the object is stored in the container.
        /// Format: <folder name>/<folder name>/<file name></p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteObjectInput`](crate::input::DeleteObjectInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteObjectInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteObjectInput { path: self.path })
        }
    }
}
#[doc(hidden)]
pub type DeleteObjectInputOperationOutputAlias = crate::operation::DeleteObject;
#[doc(hidden)]
pub type DeleteObjectInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteObjectInput {
    /// Consumes the builder and constructs an Operation<[`DeleteObject`](crate::operation::DeleteObject)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteObject,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteObjectInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.path;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "path",
                        details: "cannot be empty or unset",
                    })?;
            let path = aws_smithy_http::label::fmt_string(input_1, true);
            if path.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "path",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Path}", Path = path).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteObjectInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteObjectInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteObject::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteObject",
            "mediastoredata",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteObjectInput`](crate::input::DeleteObjectInput)
    pub fn builder() -> crate::input::delete_object_input::Builder {
        crate::input::delete_object_input::Builder::default()
    }
}

/// See [`DescribeObjectInput`](crate::input::DescribeObjectInput)
pub mod describe_object_input {
    /// A builder for [`DescribeObjectInput`](crate::input::DescribeObjectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) path: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The path (including the file name) where the object is stored in the container.
        /// Format: <folder name>/<folder name>/<file name></p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p>The path (including the file name) where the object is stored in the container.
        /// Format: <folder name>/<folder name>/<file name></p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeObjectInput`](crate::input::DescribeObjectInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeObjectInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeObjectInput { path: self.path })
        }
    }
}
#[doc(hidden)]
pub type DescribeObjectInputOperationOutputAlias = crate::operation::DescribeObject;
#[doc(hidden)]
pub type DescribeObjectInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeObjectInput {
    /// Consumes the builder and constructs an Operation<[`DescribeObject`](crate::operation::DescribeObject)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeObject,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeObjectInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_2 = &_input.path;
            let input_2 =
                input_2
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "path",
                        details: "cannot be empty or unset",
                    })?;
            let path = aws_smithy_http::label::fmt_string(input_2, true);
            if path.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "path",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Path}", Path = path).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeObjectInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("HEAD").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeObjectInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeObject::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeObject",
            "mediastoredata",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeObjectInput`](crate::input::DescribeObjectInput)
    pub fn builder() -> crate::input::describe_object_input::Builder {
        crate::input::describe_object_input::Builder::default()
    }
}

/// See [`GetObjectInput`](crate::input::GetObjectInput)
pub mod get_object_input {
    /// A builder for [`GetObjectInput`](crate::input::GetObjectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) path: std::option::Option<std::string::String>,
        pub(crate) range: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The path (including the file name) where the object is stored in the container.
        /// Format: <folder name>/<folder name>/<file name></p>
        /// <p>For example, to upload the file <code>mlaw.avi</code> to the folder path
        /// <code>premium\canada</code> in the container <code>movies</code>, enter the path
        /// <code>premium/canada/mlaw.avi</code>.</p>
        /// <p>Do not include the container name in this path.</p>
        /// <p>If the path includes any folders that don't exist yet, the service creates them. For
        /// example, suppose you have an existing <code>premium/usa</code> subfolder. If you specify
        /// <code>premium/canada</code>, the service creates a <code>canada</code> subfolder in the
        /// <code>premium</code> folder. You then have two subfolders, <code>usa</code> and
        /// <code>canada</code>, in the <code>premium</code> folder. </p>
        /// <p>There is no correlation between the path to the source and the path (folders) in the
        /// container in AWS Elemental MediaStore.</p>
        /// <p>For more information about folders and how they exist in a container, see the <a href="http://docs.aws.amazon.com/mediastore/latest/ug/">AWS Elemental MediaStore User
        /// Guide</a>.</p>
        /// <p>The file name is the name that is assigned to the file that you upload. The file can
        /// have the same name inside and outside of AWS Elemental MediaStore, or it can have the same
        /// name. The file name can include or omit an extension. </p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p>The path (including the file name) where the object is stored in the container.
        /// Format: <folder name>/<folder name>/<file name></p>
        /// <p>For example, to upload the file <code>mlaw.avi</code> to the folder path
        /// <code>premium\canada</code> in the container <code>movies</code>, enter the path
        /// <code>premium/canada/mlaw.avi</code>.</p>
        /// <p>Do not include the container name in this path.</p>
        /// <p>If the path includes any folders that don't exist yet, the service creates them. For
        /// example, suppose you have an existing <code>premium/usa</code> subfolder. If you specify
        /// <code>premium/canada</code>, the service creates a <code>canada</code> subfolder in the
        /// <code>premium</code> folder. You then have two subfolders, <code>usa</code> and
        /// <code>canada</code>, in the <code>premium</code> folder. </p>
        /// <p>There is no correlation between the path to the source and the path (folders) in the
        /// container in AWS Elemental MediaStore.</p>
        /// <p>For more information about folders and how they exist in a container, see the <a href="http://docs.aws.amazon.com/mediastore/latest/ug/">AWS Elemental MediaStore User
        /// Guide</a>.</p>
        /// <p>The file name is the name that is assigned to the file that you upload. The file can
        /// have the same name inside and outside of AWS Elemental MediaStore, or it can have the same
        /// name. The file name can include or omit an extension. </p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// <p>The range bytes of an object to retrieve. For more information about the
        /// <code>Range</code> header, see <a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35">http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35</a>. AWS Elemental MediaStore ignores this header for partially uploaded objects that have streaming upload availability.</p>
        pub fn range(mut self, input: impl Into<std::string::String>) -> Self {
            self.range = Some(input.into());
            self
        }
        /// <p>The range bytes of an object to retrieve. For more information about the
        /// <code>Range</code> header, see <a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35">http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35</a>. AWS Elemental MediaStore ignores this header for partially uploaded objects that have streaming upload availability.</p>
        pub fn set_range(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.range = input;
            self
        }
        /// Consumes the builder and constructs a [`GetObjectInput`](crate::input::GetObjectInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetObjectInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetObjectInput {
                path: self.path,
                range: self.range,
            })
        }
    }
}
#[doc(hidden)]
pub type GetObjectInputOperationOutputAlias = crate::operation::GetObject;
#[doc(hidden)]
pub type GetObjectInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetObjectInput {
    /// Consumes the builder and constructs an Operation<[`GetObject`](crate::operation::GetObject)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetObject,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetObjectInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_3 = &_input.path;
            let input_3 =
                input_3
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "path",
                        details: "cannot be empty or unset",
                    })?;
            let path = aws_smithy_http::label::fmt_string(input_3, true);
            if path.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "path",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Path}", Path = path).expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::GetObjectInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_4) = &_input.range {
                let formatted_5 = AsRef::<str>::as_ref(inner_4);
                if !formatted_5.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_5;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "range",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("Range", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetObjectInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetObjectInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetObject::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetObject",
                    "mediastoredata",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetObjectInput`](crate::input::GetObjectInput)
    pub fn builder() -> crate::input::get_object_input::Builder {
        crate::input::get_object_input::Builder::default()
    }
}

/// See [`ListItemsInput`](crate::input::ListItemsInput)
pub mod list_items_input {
    /// A builder for [`ListItemsInput`](crate::input::ListItemsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) path: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The path in the container from which to retrieve items. Format: <folder
        /// name>/<folder name>/<file name></p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p>The path in the container from which to retrieve items. Format: <folder
        /// name>/<folder name>/<file name></p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// <p>The maximum number of results to return per API request. For example, you submit a
        /// <code>ListItems</code> request with <code>MaxResults</code> set at 500. Although 2,000
        /// items match your request, the service returns no more than the first 500 items. (The
        /// service also returns a <code>NextToken</code> value that you can use to fetch the next
        /// batch of results.) The service might return fewer results than the <code>MaxResults</code>
        /// value.</p>
        /// <p>If <code>MaxResults</code> is not included in the request, the service defaults to
        /// pagination with a maximum of 1,000 results per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per API request. For example, you submit a
        /// <code>ListItems</code> request with <code>MaxResults</code> set at 500. Although 2,000
        /// items match your request, the service returns no more than the first 500 items. (The
        /// service also returns a <code>NextToken</code> value that you can use to fetch the next
        /// batch of results.) The service might return fewer results than the <code>MaxResults</code>
        /// value.</p>
        /// <p>If <code>MaxResults</code> is not included in the request, the service defaults to
        /// pagination with a maximum of 1,000 results per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token that identifies which batch of results that you want to see. For example,
        /// you submit a <code>ListItems</code> request with <code>MaxResults</code> set at 500. The
        /// service returns the first batch of results (up to 500) and a <code>NextToken</code> value.
        /// To see the next batch of results, you can submit the <code>ListItems</code> request a
        /// second time and specify the <code>NextToken</code> value.</p>
        /// <p>Tokens expire after 15 minutes.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that identifies which batch of results that you want to see. For example,
        /// you submit a <code>ListItems</code> request with <code>MaxResults</code> set at 500. The
        /// service returns the first batch of results (up to 500) and a <code>NextToken</code> value.
        /// To see the next batch of results, you can submit the <code>ListItems</code> request a
        /// second time and specify the <code>NextToken</code> value.</p>
        /// <p>Tokens expire after 15 minutes.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListItemsInput`](crate::input::ListItemsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListItemsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListItemsInput {
                path: self.path,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListItemsInputOperationOutputAlias = crate::operation::ListItems;
#[doc(hidden)]
pub type ListItemsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListItemsInput {
    /// Consumes the builder and constructs an Operation<[`ListItems`](crate::operation::ListItems)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListItems,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListItemsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListItemsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_6) = &_input.path {
                query.push_kv("Path", &aws_smithy_http::query::fmt_string(&inner_6));
            }
            if let Some(inner_7) = &_input.max_results {
                query.push_kv(
                    "MaxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_7).encode(),
                );
            }
            if let Some(inner_8) = &_input.next_token {
                query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_8));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListItemsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListItemsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListItems::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "ListItems",
                    "mediastoredata",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListItemsInput`](crate::input::ListItemsInput)
    pub fn builder() -> crate::input::list_items_input::Builder {
        crate::input::list_items_input::Builder::default()
    }
}

/// See [`PutObjectInput`](crate::input::PutObjectInput)
pub mod put_object_input {
    /// A builder for [`PutObjectInput`](crate::input::PutObjectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) body: std::option::Option<aws_smithy_http::byte_stream::ByteStream>,
        pub(crate) path: std::option::Option<std::string::String>,
        pub(crate) content_type: std::option::Option<std::string::String>,
        pub(crate) cache_control: std::option::Option<std::string::String>,
        pub(crate) storage_class: std::option::Option<crate::model::StorageClass>,
        pub(crate) upload_availability: std::option::Option<crate::model::UploadAvailability>,
    }
    impl Builder {
        /// <p>The bytes to be stored. </p>
        pub fn body(mut self, input: aws_smithy_http::byte_stream::ByteStream) -> Self {
            self.body = Some(input);
            self
        }
        /// <p>The bytes to be stored. </p>
        pub fn set_body(
            mut self,
            input: std::option::Option<aws_smithy_http::byte_stream::ByteStream>,
        ) -> Self {
            self.body = input;
            self
        }
        /// <p>The path (including the file name) where the object is stored in the container.
        /// Format: <folder name>/<folder name>/<file name></p>
        /// <p>For example, to upload the file <code>mlaw.avi</code> to the folder path
        /// <code>premium\canada</code> in the container <code>movies</code>, enter the path
        /// <code>premium/canada/mlaw.avi</code>.</p>
        /// <p>Do not include the container name in this path.</p>
        /// <p>If the path includes any folders that don't exist yet, the service creates them. For
        /// example, suppose you have an existing <code>premium/usa</code> subfolder. If you specify
        /// <code>premium/canada</code>, the service creates a <code>canada</code> subfolder in the
        /// <code>premium</code> folder. You then have two subfolders, <code>usa</code> and
        /// <code>canada</code>, in the <code>premium</code> folder. </p>
        /// <p>There is no correlation between the path to the source and the path (folders) in the
        /// container in AWS Elemental MediaStore.</p>
        /// <p>For more information about folders and how they exist in a container, see the <a href="http://docs.aws.amazon.com/mediastore/latest/ug/">AWS Elemental MediaStore User
        /// Guide</a>.</p>
        /// <p>The file name is the name that is assigned to the file that you upload. The file can
        /// have the same name inside and outside of AWS Elemental MediaStore, or it can have the same
        /// name. The file name can include or omit an extension. </p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p>The path (including the file name) where the object is stored in the container.
        /// Format: <folder name>/<folder name>/<file name></p>
        /// <p>For example, to upload the file <code>mlaw.avi</code> to the folder path
        /// <code>premium\canada</code> in the container <code>movies</code>, enter the path
        /// <code>premium/canada/mlaw.avi</code>.</p>
        /// <p>Do not include the container name in this path.</p>
        /// <p>If the path includes any folders that don't exist yet, the service creates them. For
        /// example, suppose you have an existing <code>premium/usa</code> subfolder. If you specify
        /// <code>premium/canada</code>, the service creates a <code>canada</code> subfolder in the
        /// <code>premium</code> folder. You then have two subfolders, <code>usa</code> and
        /// <code>canada</code>, in the <code>premium</code> folder. </p>
        /// <p>There is no correlation between the path to the source and the path (folders) in the
        /// container in AWS Elemental MediaStore.</p>
        /// <p>For more information about folders and how they exist in a container, see the <a href="http://docs.aws.amazon.com/mediastore/latest/ug/">AWS Elemental MediaStore User
        /// Guide</a>.</p>
        /// <p>The file name is the name that is assigned to the file that you upload. The file can
        /// have the same name inside and outside of AWS Elemental MediaStore, or it can have the same
        /// name. The file name can include or omit an extension. </p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// <p>The content type of the object.</p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_type = Some(input.into());
            self
        }
        /// <p>The content type of the object.</p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_type = input;
            self
        }
        /// <p>An optional <code>CacheControl</code> header that allows the caller to control the
        /// object's cache behavior. Headers can be passed in as specified in the HTTP at <a href="https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9">https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9</a>.</p>
        /// <p>Headers with a custom user-defined value are also accepted.</p>
        pub fn cache_control(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_control = Some(input.into());
            self
        }
        /// <p>An optional <code>CacheControl</code> header that allows the caller to control the
        /// object's cache behavior. Headers can be passed in as specified in the HTTP at <a href="https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9">https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9</a>.</p>
        /// <p>Headers with a custom user-defined value are also accepted.</p>
        pub fn set_cache_control(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_control = input;
            self
        }
        /// <p>Indicates the storage class of a <code>Put</code> request. Defaults to
        /// high-performance temporal storage class, and objects are persisted into durable storage
        /// shortly after being received.</p>
        pub fn storage_class(mut self, input: crate::model::StorageClass) -> Self {
            self.storage_class = Some(input);
            self
        }
        /// <p>Indicates the storage class of a <code>Put</code> request. Defaults to
        /// high-performance temporal storage class, and objects are persisted into durable storage
        /// shortly after being received.</p>
        pub fn set_storage_class(
            mut self,
            input: std::option::Option<crate::model::StorageClass>,
        ) -> Self {
            self.storage_class = input;
            self
        }
        /// <p>Indicates the availability of an object while it is still uploading. If the value is set to <code>streaming</code>, the object is available for
        /// downloading after some initial buffering but before the object is uploaded completely. If the value is set to <code>standard</code>, the object is
        /// available for downloading only when it is uploaded completely. The default value for this header is <code>standard</code>.</p>
        /// <p>To use this header, you must also set the HTTP <code>Transfer-Encoding</code> header to <code>chunked</code>.</p>
        pub fn upload_availability(mut self, input: crate::model::UploadAvailability) -> Self {
            self.upload_availability = Some(input);
            self
        }
        /// <p>Indicates the availability of an object while it is still uploading. If the value is set to <code>streaming</code>, the object is available for
        /// downloading after some initial buffering but before the object is uploaded completely. If the value is set to <code>standard</code>, the object is
        /// available for downloading only when it is uploaded completely. The default value for this header is <code>standard</code>.</p>
        /// <p>To use this header, you must also set the HTTP <code>Transfer-Encoding</code> header to <code>chunked</code>.</p>
        pub fn set_upload_availability(
            mut self,
            input: std::option::Option<crate::model::UploadAvailability>,
        ) -> Self {
            self.upload_availability = input;
            self
        }
        /// Consumes the builder and constructs a [`PutObjectInput`](crate::input::PutObjectInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::PutObjectInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::PutObjectInput {
                body: self.body.unwrap_or_default(),
                path: self.path,
                content_type: self.content_type,
                cache_control: self.cache_control,
                storage_class: self.storage_class,
                upload_availability: self.upload_availability,
            })
        }
    }
}
#[doc(hidden)]
pub type PutObjectInputOperationOutputAlias = crate::operation::PutObject;
#[doc(hidden)]
pub type PutObjectInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutObjectInput {
    /// Consumes the builder and constructs an Operation<[`PutObject`](crate::operation::PutObject)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutObject,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutObjectInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_9 = &_input.path;
            let input_9 =
                input_9
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "path",
                        details: "cannot be empty or unset",
                    })?;
            let path = aws_smithy_http::label::fmt_string(input_9, true);
            if path.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "path",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Path}", Path = path).expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::PutObjectInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_10) = &_input.content_type {
                let formatted_11 = AsRef::<str>::as_ref(inner_10);
                if !formatted_11.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_11;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "content_type",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("Content-Type", header_value);
                }
            }
            if let Some(inner_12) = &_input.cache_control {
                let formatted_13 = AsRef::<str>::as_ref(inner_12);
                if !formatted_13.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_13;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "cache_control",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("Cache-Control", header_value);
                }
            }
            if let Some(inner_14) = &_input.storage_class {
                let formatted_15 = AsRef::<str>::as_ref(inner_14);
                if !formatted_15.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_15;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "storage_class",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-storage-class", header_value);
                }
            }
            if let Some(inner_16) = &_input.upload_availability {
                let formatted_17 = AsRef::<str>::as_ref(inner_16);
                if !formatted_17.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_17;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "upload_availability",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-upload-availability", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutObjectInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutObjectInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/octet-stream",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::ser_payload_put_object_input(self.body)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        request
            .properties_mut()
            .insert(aws_sig_auth::signer::SignableBody::UnsignedPayload);
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::PutObject::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "PutObject",
                    "mediastoredata",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutObjectInput`](crate::input::PutObjectInput)
    pub fn builder() -> crate::input::put_object_input::Builder {
        crate::input::put_object_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
pub struct PutObjectInput {
    /// <p>The bytes to be stored. </p>
    pub body: aws_smithy_http::byte_stream::ByteStream,
    /// <p>The path (including the file name) where the object is stored in the container.
    /// Format: <folder name>/<folder name>/<file name></p>
    /// <p>For example, to upload the file <code>mlaw.avi</code> to the folder path
    /// <code>premium\canada</code> in the container <code>movies</code>, enter the path
    /// <code>premium/canada/mlaw.avi</code>.</p>
    /// <p>Do not include the container name in this path.</p>
    /// <p>If the path includes any folders that don't exist yet, the service creates them. For
    /// example, suppose you have an existing <code>premium/usa</code> subfolder. If you specify
    /// <code>premium/canada</code>, the service creates a <code>canada</code> subfolder in the
    /// <code>premium</code> folder. You then have two subfolders, <code>usa</code> and
    /// <code>canada</code>, in the <code>premium</code> folder. </p>
    /// <p>There is no correlation between the path to the source and the path (folders) in the
    /// container in AWS Elemental MediaStore.</p>
    /// <p>For more information about folders and how they exist in a container, see the <a href="http://docs.aws.amazon.com/mediastore/latest/ug/">AWS Elemental MediaStore User
    /// Guide</a>.</p>
    /// <p>The file name is the name that is assigned to the file that you upload. The file can
    /// have the same name inside and outside of AWS Elemental MediaStore, or it can have the same
    /// name. The file name can include or omit an extension. </p>
    pub path: std::option::Option<std::string::String>,
    /// <p>The content type of the object.</p>
    pub content_type: std::option::Option<std::string::String>,
    /// <p>An optional <code>CacheControl</code> header that allows the caller to control the
    /// object's cache behavior. Headers can be passed in as specified in the HTTP at <a href="https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9">https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9</a>.</p>
    /// <p>Headers with a custom user-defined value are also accepted.</p>
    pub cache_control: std::option::Option<std::string::String>,
    /// <p>Indicates the storage class of a <code>Put</code> request. Defaults to
    /// high-performance temporal storage class, and objects are persisted into durable storage
    /// shortly after being received.</p>
    pub storage_class: std::option::Option<crate::model::StorageClass>,
    /// <p>Indicates the availability of an object while it is still uploading. If the value is set to <code>streaming</code>, the object is available for
    /// downloading after some initial buffering but before the object is uploaded completely. If the value is set to <code>standard</code>, the object is
    /// available for downloading only when it is uploaded completely. The default value for this header is <code>standard</code>.</p>
    /// <p>To use this header, you must also set the HTTP <code>Transfer-Encoding</code> header to <code>chunked</code>.</p>
    pub upload_availability: std::option::Option<crate::model::UploadAvailability>,
}
impl std::fmt::Debug for PutObjectInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutObjectInput");
        formatter.field("body", &self.body);
        formatter.field("path", &self.path);
        formatter.field("content_type", &self.content_type);
        formatter.field("cache_control", &self.cache_control);
        formatter.field("storage_class", &self.storage_class);
        formatter.field("upload_availability", &self.upload_availability);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListItemsInput {
    /// <p>The path in the container from which to retrieve items. Format: <folder
    /// name>/<folder name>/<file name></p>
    pub path: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return per API request. For example, you submit a
    /// <code>ListItems</code> request with <code>MaxResults</code> set at 500. Although 2,000
    /// items match your request, the service returns no more than the first 500 items. (The
    /// service also returns a <code>NextToken</code> value that you can use to fetch the next
    /// batch of results.) The service might return fewer results than the <code>MaxResults</code>
    /// value.</p>
    /// <p>If <code>MaxResults</code> is not included in the request, the service defaults to
    /// pagination with a maximum of 1,000 results per page.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token that identifies which batch of results that you want to see. For example,
    /// you submit a <code>ListItems</code> request with <code>MaxResults</code> set at 500. The
    /// service returns the first batch of results (up to 500) and a <code>NextToken</code> value.
    /// To see the next batch of results, you can submit the <code>ListItems</code> request a
    /// second time and specify the <code>NextToken</code> value.</p>
    /// <p>Tokens expire after 15 minutes.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListItemsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListItemsInput");
        formatter.field("path", &self.path);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetObjectInput {
    /// <p>The path (including the file name) where the object is stored in the container.
    /// Format: <folder name>/<folder name>/<file name></p>
    /// <p>For example, to upload the file <code>mlaw.avi</code> to the folder path
    /// <code>premium\canada</code> in the container <code>movies</code>, enter the path
    /// <code>premium/canada/mlaw.avi</code>.</p>
    /// <p>Do not include the container name in this path.</p>
    /// <p>If the path includes any folders that don't exist yet, the service creates them. For
    /// example, suppose you have an existing <code>premium/usa</code> subfolder. If you specify
    /// <code>premium/canada</code>, the service creates a <code>canada</code> subfolder in the
    /// <code>premium</code> folder. You then have two subfolders, <code>usa</code> and
    /// <code>canada</code>, in the <code>premium</code> folder. </p>
    /// <p>There is no correlation between the path to the source and the path (folders) in the
    /// container in AWS Elemental MediaStore.</p>
    /// <p>For more information about folders and how they exist in a container, see the <a href="http://docs.aws.amazon.com/mediastore/latest/ug/">AWS Elemental MediaStore User
    /// Guide</a>.</p>
    /// <p>The file name is the name that is assigned to the file that you upload. The file can
    /// have the same name inside and outside of AWS Elemental MediaStore, or it can have the same
    /// name. The file name can include or omit an extension. </p>
    pub path: std::option::Option<std::string::String>,
    /// <p>The range bytes of an object to retrieve. For more information about the
    /// <code>Range</code> header, see <a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35">http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35</a>. AWS Elemental MediaStore ignores this header for partially uploaded objects that have streaming upload availability.</p>
    pub range: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetObjectInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetObjectInput");
        formatter.field("path", &self.path);
        formatter.field("range", &self.range);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeObjectInput {
    /// <p>The path (including the file name) where the object is stored in the container.
    /// Format: <folder name>/<folder name>/<file name></p>
    pub path: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeObjectInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeObjectInput");
        formatter.field("path", &self.path);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteObjectInput {
    /// <p>The path (including the file name) where the object is stored in the container.
    /// Format: <folder name>/<folder name>/<file name></p>
    pub path: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteObjectInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteObjectInput");
        formatter.field("path", &self.path);
        formatter.finish()
    }
}
