// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for AWS Elemental MediaStore
///
/// Client for invoking operations on AWS Elemental MediaStore. Each operation on AWS Elemental MediaStore is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_mediastore::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_mediastore::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_mediastore::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the [`CreateContainer`](crate::client::fluent_builders::CreateContainer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`container_name(impl Into<String>)`](crate::client::fluent_builders::CreateContainer::container_name) / [`set_container_name(Option<String>)`](crate::client::fluent_builders::CreateContainer::set_container_name): <p>The name for the container. The name must be from 1 to 255 characters. Container names must be unique to your AWS account within a specific region. As an example, you could create a container named <code>movies</code> in every region, as long as you don’t have an existing container with that name.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateContainer::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateContainer::set_tags): <p>An array of key:value pairs that you define. These values can be anything that you want. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each container. For more information about tagging, including naming and usage conventions, see <a href="https://docs.aws.amazon.com/mediastore/latest/ug/tagging.html">Tagging Resources in MediaStore</a>.</p>
    /// - On success, responds with [`CreateContainerOutput`](crate::output::CreateContainerOutput) with field(s):
    ///   - [`container(Option<Container>)`](crate::output::CreateContainerOutput::container): <p>ContainerARN: The Amazon Resource Name (ARN) of the newly created container. The ARN has the following format: arn:aws:<region>   :   <account that owns this container>    :container/    <name of container>     . For example: arn:aws:mediastore:us-west-2:111122223333:container/movies     </name>   </account>  </region></p>  <p>ContainerName: The container name as specified in the request.</p>  <p>CreationTime: Unix time stamp.</p>  <p>Status: The status of container creation or deletion. The status is one of the following: <code>CREATING</code>, <code>ACTIVE</code>, or <code>DELETING</code>. While the service is creating the container, the status is <code>CREATING</code>. When an endpoint is available, the status changes to <code>ACTIVE</code>.</p>  <p>The return value does not include the container's endpoint. To make downstream requests, you must obtain this value by using <code>DescribeContainer</code> or <code>ListContainers</code>.</p>
    /// - On failure, responds with [`SdkError<CreateContainerError>`](crate::error::CreateContainerError)
    pub fn create_container(&self) -> fluent_builders::CreateContainer<C, M, R> {
        fluent_builders::CreateContainer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteContainer`](crate::client::fluent_builders::DeleteContainer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`container_name(impl Into<String>)`](crate::client::fluent_builders::DeleteContainer::container_name) / [`set_container_name(Option<String>)`](crate::client::fluent_builders::DeleteContainer::set_container_name): <p>The name of the container to delete. </p>
    /// - On success, responds with [`DeleteContainerOutput`](crate::output::DeleteContainerOutput)

    /// - On failure, responds with [`SdkError<DeleteContainerError>`](crate::error::DeleteContainerError)
    pub fn delete_container(&self) -> fluent_builders::DeleteContainer<C, M, R> {
        fluent_builders::DeleteContainer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteContainerPolicy`](crate::client::fluent_builders::DeleteContainerPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`container_name(impl Into<String>)`](crate::client::fluent_builders::DeleteContainerPolicy::container_name) / [`set_container_name(Option<String>)`](crate::client::fluent_builders::DeleteContainerPolicy::set_container_name): <p>The name of the container that holds the policy.</p>
    /// - On success, responds with [`DeleteContainerPolicyOutput`](crate::output::DeleteContainerPolicyOutput)

    /// - On failure, responds with [`SdkError<DeleteContainerPolicyError>`](crate::error::DeleteContainerPolicyError)
    pub fn delete_container_policy(&self) -> fluent_builders::DeleteContainerPolicy<C, M, R> {
        fluent_builders::DeleteContainerPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteCorsPolicy`](crate::client::fluent_builders::DeleteCorsPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`container_name(impl Into<String>)`](crate::client::fluent_builders::DeleteCorsPolicy::container_name) / [`set_container_name(Option<String>)`](crate::client::fluent_builders::DeleteCorsPolicy::set_container_name): <p>The name of the container to remove the policy from.</p>
    /// - On success, responds with [`DeleteCorsPolicyOutput`](crate::output::DeleteCorsPolicyOutput)

    /// - On failure, responds with [`SdkError<DeleteCorsPolicyError>`](crate::error::DeleteCorsPolicyError)
    pub fn delete_cors_policy(&self) -> fluent_builders::DeleteCorsPolicy<C, M, R> {
        fluent_builders::DeleteCorsPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteLifecyclePolicy`](crate::client::fluent_builders::DeleteLifecyclePolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`container_name(impl Into<String>)`](crate::client::fluent_builders::DeleteLifecyclePolicy::container_name) / [`set_container_name(Option<String>)`](crate::client::fluent_builders::DeleteLifecyclePolicy::set_container_name): <p>The name of the container that holds the object lifecycle policy.</p>
    /// - On success, responds with [`DeleteLifecyclePolicyOutput`](crate::output::DeleteLifecyclePolicyOutput)

    /// - On failure, responds with [`SdkError<DeleteLifecyclePolicyError>`](crate::error::DeleteLifecyclePolicyError)
    pub fn delete_lifecycle_policy(&self) -> fluent_builders::DeleteLifecyclePolicy<C, M, R> {
        fluent_builders::DeleteLifecyclePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteMetricPolicy`](crate::client::fluent_builders::DeleteMetricPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`container_name(impl Into<String>)`](crate::client::fluent_builders::DeleteMetricPolicy::container_name) / [`set_container_name(Option<String>)`](crate::client::fluent_builders::DeleteMetricPolicy::set_container_name): <p>The name of the container that is associated with the metric policy that you want to delete.</p>
    /// - On success, responds with [`DeleteMetricPolicyOutput`](crate::output::DeleteMetricPolicyOutput)

    /// - On failure, responds with [`SdkError<DeleteMetricPolicyError>`](crate::error::DeleteMetricPolicyError)
    pub fn delete_metric_policy(&self) -> fluent_builders::DeleteMetricPolicy<C, M, R> {
        fluent_builders::DeleteMetricPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeContainer`](crate::client::fluent_builders::DescribeContainer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`container_name(impl Into<String>)`](crate::client::fluent_builders::DescribeContainer::container_name) / [`set_container_name(Option<String>)`](crate::client::fluent_builders::DescribeContainer::set_container_name): <p>The name of the container to query.</p>
    /// - On success, responds with [`DescribeContainerOutput`](crate::output::DescribeContainerOutput) with field(s):
    ///   - [`container(Option<Container>)`](crate::output::DescribeContainerOutput::container): <p>The name of the queried container.</p>
    /// - On failure, responds with [`SdkError<DescribeContainerError>`](crate::error::DescribeContainerError)
    pub fn describe_container(&self) -> fluent_builders::DescribeContainer<C, M, R> {
        fluent_builders::DescribeContainer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetContainerPolicy`](crate::client::fluent_builders::GetContainerPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`container_name(impl Into<String>)`](crate::client::fluent_builders::GetContainerPolicy::container_name) / [`set_container_name(Option<String>)`](crate::client::fluent_builders::GetContainerPolicy::set_container_name): <p>The name of the container. </p>
    /// - On success, responds with [`GetContainerPolicyOutput`](crate::output::GetContainerPolicyOutput) with field(s):
    ///   - [`policy(Option<String>)`](crate::output::GetContainerPolicyOutput::policy): <p>The contents of the access policy.</p>
    /// - On failure, responds with [`SdkError<GetContainerPolicyError>`](crate::error::GetContainerPolicyError)
    pub fn get_container_policy(&self) -> fluent_builders::GetContainerPolicy<C, M, R> {
        fluent_builders::GetContainerPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetCorsPolicy`](crate::client::fluent_builders::GetCorsPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`container_name(impl Into<String>)`](crate::client::fluent_builders::GetCorsPolicy::container_name) / [`set_container_name(Option<String>)`](crate::client::fluent_builders::GetCorsPolicy::set_container_name): <p>The name of the container that the policy is assigned to.</p>
    /// - On success, responds with [`GetCorsPolicyOutput`](crate::output::GetCorsPolicyOutput) with field(s):
    ///   - [`cors_policy(Option<Vec<CorsRule>>)`](crate::output::GetCorsPolicyOutput::cors_policy): <p>The CORS policy assigned to the container.</p>
    /// - On failure, responds with [`SdkError<GetCorsPolicyError>`](crate::error::GetCorsPolicyError)
    pub fn get_cors_policy(&self) -> fluent_builders::GetCorsPolicy<C, M, R> {
        fluent_builders::GetCorsPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetLifecyclePolicy`](crate::client::fluent_builders::GetLifecyclePolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`container_name(impl Into<String>)`](crate::client::fluent_builders::GetLifecyclePolicy::container_name) / [`set_container_name(Option<String>)`](crate::client::fluent_builders::GetLifecyclePolicy::set_container_name): <p>The name of the container that the object lifecycle policy is assigned to.</p>
    /// - On success, responds with [`GetLifecyclePolicyOutput`](crate::output::GetLifecyclePolicyOutput) with field(s):
    ///   - [`lifecycle_policy(Option<String>)`](crate::output::GetLifecyclePolicyOutput::lifecycle_policy): <p>The object lifecycle policy that is assigned to the container.</p>
    /// - On failure, responds with [`SdkError<GetLifecyclePolicyError>`](crate::error::GetLifecyclePolicyError)
    pub fn get_lifecycle_policy(&self) -> fluent_builders::GetLifecyclePolicy<C, M, R> {
        fluent_builders::GetLifecyclePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetMetricPolicy`](crate::client::fluent_builders::GetMetricPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`container_name(impl Into<String>)`](crate::client::fluent_builders::GetMetricPolicy::container_name) / [`set_container_name(Option<String>)`](crate::client::fluent_builders::GetMetricPolicy::set_container_name): <p>The name of the container that is associated with the metric policy.</p>
    /// - On success, responds with [`GetMetricPolicyOutput`](crate::output::GetMetricPolicyOutput) with field(s):
    ///   - [`metric_policy(Option<MetricPolicy>)`](crate::output::GetMetricPolicyOutput::metric_policy): <p>The metric policy that is associated with the specific container.</p>
    /// - On failure, responds with [`SdkError<GetMetricPolicyError>`](crate::error::GetMetricPolicyError)
    pub fn get_metric_policy(&self) -> fluent_builders::GetMetricPolicy<C, M, R> {
        fluent_builders::GetMetricPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListContainers`](crate::client::fluent_builders::ListContainers) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListContainers::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListContainers::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListContainers::set_next_token): <p>Only if you used <code>MaxResults</code> in the first command, enter the token (which was included in the previous response) to obtain the next set of containers. This token is included in a response only if there actually are more containers to list.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListContainers::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListContainers::set_max_results): <p>Enter the maximum number of containers in the response. Use from 1 to 255 characters. </p>
    /// - On success, responds with [`ListContainersOutput`](crate::output::ListContainersOutput) with field(s):
    ///   - [`containers(Option<Vec<Container>>)`](crate::output::ListContainersOutput::containers): <p>The names of the containers.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListContainersOutput::next_token): <p> <code>NextToken</code> is the token to use in the next call to <code>ListContainers</code>. This token is returned only if you included the <code>MaxResults</code> tag in the original command, and only if there are still containers to return. </p>
    /// - On failure, responds with [`SdkError<ListContainersError>`](crate::error::ListContainersError)
    pub fn list_containers(&self) -> fluent_builders::ListContainers<C, M, R> {
        fluent_builders::ListContainers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource) / [`set_resource(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource): <p>The Amazon Resource Name (ARN) for the container.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::ListTagsForResourceOutput::tags): <p>An array of key:value pairs that are assigned to the container.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutContainerPolicy`](crate::client::fluent_builders::PutContainerPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`container_name(impl Into<String>)`](crate::client::fluent_builders::PutContainerPolicy::container_name) / [`set_container_name(Option<String>)`](crate::client::fluent_builders::PutContainerPolicy::set_container_name): <p>The name of the container.</p>
    ///   - [`policy(impl Into<String>)`](crate::client::fluent_builders::PutContainerPolicy::policy) / [`set_policy(Option<String>)`](crate::client::fluent_builders::PutContainerPolicy::set_policy): <p>The contents of the policy, which includes the following: </p>  <ul>   <li> <p>One <code>Version</code> tag</p> </li>   <li> <p>One <code>Statement</code> tag that contains the standard tags for the policy.</p> </li>  </ul>
    /// - On success, responds with [`PutContainerPolicyOutput`](crate::output::PutContainerPolicyOutput)

    /// - On failure, responds with [`SdkError<PutContainerPolicyError>`](crate::error::PutContainerPolicyError)
    pub fn put_container_policy(&self) -> fluent_builders::PutContainerPolicy<C, M, R> {
        fluent_builders::PutContainerPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutCorsPolicy`](crate::client::fluent_builders::PutCorsPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`container_name(impl Into<String>)`](crate::client::fluent_builders::PutCorsPolicy::container_name) / [`set_container_name(Option<String>)`](crate::client::fluent_builders::PutCorsPolicy::set_container_name): <p>The name of the container that you want to assign the CORS policy to.</p>
    ///   - [`cors_policy(Vec<CorsRule>)`](crate::client::fluent_builders::PutCorsPolicy::cors_policy) / [`set_cors_policy(Option<Vec<CorsRule>>)`](crate::client::fluent_builders::PutCorsPolicy::set_cors_policy): <p>The CORS policy to apply to the container. </p>
    /// - On success, responds with [`PutCorsPolicyOutput`](crate::output::PutCorsPolicyOutput)

    /// - On failure, responds with [`SdkError<PutCorsPolicyError>`](crate::error::PutCorsPolicyError)
    pub fn put_cors_policy(&self) -> fluent_builders::PutCorsPolicy<C, M, R> {
        fluent_builders::PutCorsPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutLifecyclePolicy`](crate::client::fluent_builders::PutLifecyclePolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`container_name(impl Into<String>)`](crate::client::fluent_builders::PutLifecyclePolicy::container_name) / [`set_container_name(Option<String>)`](crate::client::fluent_builders::PutLifecyclePolicy::set_container_name): <p>The name of the container that you want to assign the object lifecycle policy to.</p>
    ///   - [`lifecycle_policy(impl Into<String>)`](crate::client::fluent_builders::PutLifecyclePolicy::lifecycle_policy) / [`set_lifecycle_policy(Option<String>)`](crate::client::fluent_builders::PutLifecyclePolicy::set_lifecycle_policy): <p>The object lifecycle policy to apply to the container.</p>
    /// - On success, responds with [`PutLifecyclePolicyOutput`](crate::output::PutLifecyclePolicyOutput)

    /// - On failure, responds with [`SdkError<PutLifecyclePolicyError>`](crate::error::PutLifecyclePolicyError)
    pub fn put_lifecycle_policy(&self) -> fluent_builders::PutLifecyclePolicy<C, M, R> {
        fluent_builders::PutLifecyclePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutMetricPolicy`](crate::client::fluent_builders::PutMetricPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`container_name(impl Into<String>)`](crate::client::fluent_builders::PutMetricPolicy::container_name) / [`set_container_name(Option<String>)`](crate::client::fluent_builders::PutMetricPolicy::set_container_name): <p>The name of the container that you want to add the metric policy to.</p>
    ///   - [`metric_policy(MetricPolicy)`](crate::client::fluent_builders::PutMetricPolicy::metric_policy) / [`set_metric_policy(Option<MetricPolicy>)`](crate::client::fluent_builders::PutMetricPolicy::set_metric_policy): <p>The metric policy that you want to associate with the container. In the policy, you must indicate whether you want MediaStore to send container-level metrics. You can also include up to five rules to define groups of objects that you want MediaStore to send object-level metrics for. If you include rules in the policy, construct each rule with both of the following:</p>  <ul>   <li> <p>An object group that defines which objects to include in the group. The definition can be a path or a file name, but it can't have more than 900 characters. Valid characters are: a-z, A-Z, 0-9, _ (underscore), = (equal), : (colon), . (period), - (hyphen), ~ (tilde), / (forward slash), and * (asterisk). Wildcards (*) are acceptable.</p> </li>   <li> <p>An object group name that allows you to refer to the object group. The name can't have more than 30 characters. Valid characters are: a-z, A-Z, 0-9, and _ (underscore).</p> </li>  </ul>
    /// - On success, responds with [`PutMetricPolicyOutput`](crate::output::PutMetricPolicyOutput)

    /// - On failure, responds with [`SdkError<PutMetricPolicyError>`](crate::error::PutMetricPolicyError)
    pub fn put_metric_policy(&self) -> fluent_builders::PutMetricPolicy<C, M, R> {
        fluent_builders::PutMetricPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartAccessLogging`](crate::client::fluent_builders::StartAccessLogging) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`container_name(impl Into<String>)`](crate::client::fluent_builders::StartAccessLogging::container_name) / [`set_container_name(Option<String>)`](crate::client::fluent_builders::StartAccessLogging::set_container_name): <p>The name of the container that you want to start access logging on.</p>
    /// - On success, responds with [`StartAccessLoggingOutput`](crate::output::StartAccessLoggingOutput)

    /// - On failure, responds with [`SdkError<StartAccessLoggingError>`](crate::error::StartAccessLoggingError)
    pub fn start_access_logging(&self) -> fluent_builders::StartAccessLogging<C, M, R> {
        fluent_builders::StartAccessLogging::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StopAccessLogging`](crate::client::fluent_builders::StopAccessLogging) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`container_name(impl Into<String>)`](crate::client::fluent_builders::StopAccessLogging::container_name) / [`set_container_name(Option<String>)`](crate::client::fluent_builders::StopAccessLogging::set_container_name): <p>The name of the container that you want to stop access logging on.</p>
    /// - On success, responds with [`StopAccessLoggingOutput`](crate::output::StopAccessLoggingOutput)

    /// - On failure, responds with [`SdkError<StopAccessLoggingError>`](crate::error::StopAccessLoggingError)
    pub fn stop_access_logging(&self) -> fluent_builders::StopAccessLogging<C, M, R> {
        fluent_builders::StopAccessLogging::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource) / [`set_resource(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource): <p>The Amazon Resource Name (ARN) for the container. </p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>An array of key:value pairs that you want to add to the container. You need to specify only the tags that you want to add or update. For example, suppose a container already has two tags (customer:CompanyA and priority:High). You want to change the priority tag and also add a third tag (type:Contract). For TagResource, you specify the following tags: priority:Medium, type:Contract. The result is that your container has three tags: customer:CompanyA, priority:Medium, and type:Contract.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource) / [`set_resource(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource): <p>The Amazon Resource Name (ARN) for the container.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>A comma-separated list of keys for tags that you want to remove from the container. For example, if your container has two tags (customer:CompanyA and priority:High) and you want to remove one of the tags (priority:High), you specify the key for the tag that you want to remove (priority).</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateContainer`.
    ///
    /// <p>Creates a storage container to hold objects. A container is similar to a bucket in the Amazon S3 service.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateContainer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_container_input::Builder,
    }
    impl<C, M, R> CreateContainer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateContainer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateContainerOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateContainerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateContainerInputOperationOutputAlias,
                crate::output::CreateContainerOutput,
                crate::error::CreateContainerError,
                crate::input::CreateContainerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name for the container. The name must be from 1 to 255 characters. Container names must be unique to your AWS account within a specific region. As an example, you could create a container named <code>movies</code> in every region, as long as you don’t have an existing container with that name.</p>
        pub fn container_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.container_name(input.into());
            self
        }
        /// <p>The name for the container. The name must be from 1 to 255 characters. Container names must be unique to your AWS account within a specific region. As an example, you could create a container named <code>movies</code> in every region, as long as you don’t have an existing container with that name.</p>
        pub fn set_container_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_container_name(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of key:value pairs that you define. These values can be anything that you want. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each container. For more information about tagging, including naming and usage conventions, see <a href="https://docs.aws.amazon.com/mediastore/latest/ug/tagging.html">Tagging Resources in MediaStore</a>.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>An array of key:value pairs that you define. These values can be anything that you want. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each container. For more information about tagging, including naming and usage conventions, see <a href="https://docs.aws.amazon.com/mediastore/latest/ug/tagging.html">Tagging Resources in MediaStore</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteContainer`.
    ///
    /// <p>Deletes the specified container. Before you make a <code>DeleteContainer</code> request, delete any objects in the container or in any folders in the container. You can delete only empty containers. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteContainer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_container_input::Builder,
    }
    impl<C, M, R> DeleteContainer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteContainer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteContainerOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteContainerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteContainerInputOperationOutputAlias,
                crate::output::DeleteContainerOutput,
                crate::error::DeleteContainerError,
                crate::input::DeleteContainerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the container to delete. </p>
        pub fn container_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.container_name(input.into());
            self
        }
        /// <p>The name of the container to delete. </p>
        pub fn set_container_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_container_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteContainerPolicy`.
    ///
    /// <p>Deletes the access policy that is associated with the specified container.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteContainerPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_container_policy_input::Builder,
    }
    impl<C, M, R> DeleteContainerPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteContainerPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteContainerPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteContainerPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteContainerPolicyInputOperationOutputAlias,
                crate::output::DeleteContainerPolicyOutput,
                crate::error::DeleteContainerPolicyError,
                crate::input::DeleteContainerPolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the container that holds the policy.</p>
        pub fn container_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.container_name(input.into());
            self
        }
        /// <p>The name of the container that holds the policy.</p>
        pub fn set_container_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_container_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCorsPolicy`.
    ///
    /// <p>Deletes the cross-origin resource sharing (CORS) configuration information that is set for the container.</p>
    /// <p>To use this operation, you must have permission to perform the <code>MediaStore:DeleteCorsPolicy</code> action. The container owner has this permission by default and can grant this permission to others.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteCorsPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_cors_policy_input::Builder,
    }
    impl<C, M, R> DeleteCorsPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteCorsPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCorsPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteCorsPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteCorsPolicyInputOperationOutputAlias,
                crate::output::DeleteCorsPolicyOutput,
                crate::error::DeleteCorsPolicyError,
                crate::input::DeleteCorsPolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the container to remove the policy from.</p>
        pub fn container_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.container_name(input.into());
            self
        }
        /// <p>The name of the container to remove the policy from.</p>
        pub fn set_container_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_container_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteLifecyclePolicy`.
    ///
    /// <p>Removes an object lifecycle policy from a container. It takes up to 20 minutes for the change to take effect.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteLifecyclePolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_lifecycle_policy_input::Builder,
    }
    impl<C, M, R> DeleteLifecyclePolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteLifecyclePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteLifecyclePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteLifecyclePolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteLifecyclePolicyInputOperationOutputAlias,
                crate::output::DeleteLifecyclePolicyOutput,
                crate::error::DeleteLifecyclePolicyError,
                crate::input::DeleteLifecyclePolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the container that holds the object lifecycle policy.</p>
        pub fn container_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.container_name(input.into());
            self
        }
        /// <p>The name of the container that holds the object lifecycle policy.</p>
        pub fn set_container_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_container_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteMetricPolicy`.
    ///
    /// <p>Deletes the metric policy that is associated with the specified container. If there is no metric policy associated with the container, MediaStore doesn't send metrics to CloudWatch.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteMetricPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_metric_policy_input::Builder,
    }
    impl<C, M, R> DeleteMetricPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteMetricPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteMetricPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteMetricPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteMetricPolicyInputOperationOutputAlias,
                crate::output::DeleteMetricPolicyOutput,
                crate::error::DeleteMetricPolicyError,
                crate::input::DeleteMetricPolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the container that is associated with the metric policy that you want to delete.</p>
        pub fn container_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.container_name(input.into());
            self
        }
        /// <p>The name of the container that is associated with the metric policy that you want to delete.</p>
        pub fn set_container_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_container_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeContainer`.
    ///
    /// <p>Retrieves the properties of the requested container. This request is commonly used to retrieve the endpoint of a container. An endpoint is a value assigned by the service when a new container is created. A container's endpoint does not change after it has been assigned. The <code>DescribeContainer</code> request returns a single <code>Container</code> object based on <code>ContainerName</code>. To return all <code>Container</code> objects that are associated with a specified AWS account, use <code>ListContainers</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeContainer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_container_input::Builder,
    }
    impl<C, M, R> DescribeContainer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeContainer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeContainerOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeContainerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeContainerInputOperationOutputAlias,
                crate::output::DescribeContainerOutput,
                crate::error::DescribeContainerError,
                crate::input::DescribeContainerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the container to query.</p>
        pub fn container_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.container_name(input.into());
            self
        }
        /// <p>The name of the container to query.</p>
        pub fn set_container_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_container_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetContainerPolicy`.
    ///
    /// <p>Retrieves the access policy for the specified container. For information about the data that is included in an access policy, see the <a href="https://aws.amazon.com/documentation/iam/">AWS Identity and Access Management User Guide</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetContainerPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_container_policy_input::Builder,
    }
    impl<C, M, R> GetContainerPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetContainerPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetContainerPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetContainerPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetContainerPolicyInputOperationOutputAlias,
                crate::output::GetContainerPolicyOutput,
                crate::error::GetContainerPolicyError,
                crate::input::GetContainerPolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the container. </p>
        pub fn container_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.container_name(input.into());
            self
        }
        /// <p>The name of the container. </p>
        pub fn set_container_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_container_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCorsPolicy`.
    ///
    /// <p>Returns the cross-origin resource sharing (CORS) configuration information that is set for the container.</p>
    /// <p>To use this operation, you must have permission to perform the <code>MediaStore:GetCorsPolicy</code> action. By default, the container owner has this permission and can grant it to others.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetCorsPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_cors_policy_input::Builder,
    }
    impl<C, M, R> GetCorsPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCorsPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCorsPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCorsPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCorsPolicyInputOperationOutputAlias,
                crate::output::GetCorsPolicyOutput,
                crate::error::GetCorsPolicyError,
                crate::input::GetCorsPolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the container that the policy is assigned to.</p>
        pub fn container_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.container_name(input.into());
            self
        }
        /// <p>The name of the container that the policy is assigned to.</p>
        pub fn set_container_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_container_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLifecyclePolicy`.
    ///
    /// <p>Retrieves the object lifecycle policy that is assigned to a container.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetLifecyclePolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_lifecycle_policy_input::Builder,
    }
    impl<C, M, R> GetLifecyclePolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetLifecyclePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLifecyclePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLifecyclePolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetLifecyclePolicyInputOperationOutputAlias,
                crate::output::GetLifecyclePolicyOutput,
                crate::error::GetLifecyclePolicyError,
                crate::input::GetLifecyclePolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the container that the object lifecycle policy is assigned to.</p>
        pub fn container_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.container_name(input.into());
            self
        }
        /// <p>The name of the container that the object lifecycle policy is assigned to.</p>
        pub fn set_container_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_container_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMetricPolicy`.
    ///
    /// <p>Returns the metric policy for the specified container. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetMetricPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_metric_policy_input::Builder,
    }
    impl<C, M, R> GetMetricPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMetricPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMetricPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMetricPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMetricPolicyInputOperationOutputAlias,
                crate::output::GetMetricPolicyOutput,
                crate::error::GetMetricPolicyError,
                crate::input::GetMetricPolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the container that is associated with the metric policy.</p>
        pub fn container_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.container_name(input.into());
            self
        }
        /// <p>The name of the container that is associated with the metric policy.</p>
        pub fn set_container_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_container_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListContainers`.
    ///
    /// <p>Lists the properties of all containers in AWS Elemental MediaStore. </p>
    /// <p>You can query to receive all the containers in one response. Or you can include the <code>MaxResults</code> parameter to receive a limited number of containers in each response. In this case, the response includes a token. To get the next set of containers, send the command again, this time with the <code>NextToken</code> parameter (with the returned token as its value). The next set of responses appears, with a token if there are still more containers to receive. </p>
    /// <p>See also <code>DescribeContainer</code>, which gets the properties of one container. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListContainers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_containers_input::Builder,
    }
    impl<C, M, R> ListContainers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListContainers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListContainersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListContainersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListContainersInputOperationOutputAlias,
                crate::output::ListContainersOutput,
                crate::error::ListContainersError,
                crate::input::ListContainersInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListContainersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListContainersPaginator<C, M, R> {
            crate::paginator::ListContainersPaginator::new(self.handle, self.inner)
        }
        /// <p>Only if you used <code>MaxResults</code> in the first command, enter the token (which was included in the previous response) to obtain the next set of containers. This token is included in a response only if there actually are more containers to list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Only if you used <code>MaxResults</code> in the first command, enter the token (which was included in the previous response) to obtain the next set of containers. This token is included in a response only if there actually are more containers to list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Enter the maximum number of containers in the response. Use from 1 to 255 characters. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Enter the maximum number of containers in the response. Use from 1 to 255 characters. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Returns a list of the tags assigned to the specified container. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) for the container.</p>
        pub fn resource(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the container.</p>
        pub fn set_resource(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutContainerPolicy`.
    ///
    /// <p>Creates an access policy for the specified container to restrict the users and clients that can access it. For information about the data that is included in an access policy, see the <a href="https://aws.amazon.com/documentation/iam/">AWS Identity and Access Management User Guide</a>.</p>
    /// <p>For this release of the REST API, you can create only one policy for a container. If you enter <code>PutContainerPolicy</code> twice, the second command modifies the existing policy. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutContainerPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_container_policy_input::Builder,
    }
    impl<C, M, R> PutContainerPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutContainerPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutContainerPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutContainerPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutContainerPolicyInputOperationOutputAlias,
                crate::output::PutContainerPolicyOutput,
                crate::error::PutContainerPolicyError,
                crate::input::PutContainerPolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the container.</p>
        pub fn container_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.container_name(input.into());
            self
        }
        /// <p>The name of the container.</p>
        pub fn set_container_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_container_name(input);
            self
        }
        /// <p>The contents of the policy, which includes the following: </p>
        /// <ul>
        /// <li> <p>One <code>Version</code> tag</p> </li>
        /// <li> <p>One <code>Statement</code> tag that contains the standard tags for the policy.</p> </li>
        /// </ul>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy(input.into());
            self
        }
        /// <p>The contents of the policy, which includes the following: </p>
        /// <ul>
        /// <li> <p>One <code>Version</code> tag</p> </li>
        /// <li> <p>One <code>Statement</code> tag that contains the standard tags for the policy.</p> </li>
        /// </ul>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutCorsPolicy`.
    ///
    /// <p>Sets the cross-origin resource sharing (CORS) configuration on a container so that the container can service cross-origin requests. For example, you might want to enable a request whose origin is http://www.example.com to access your AWS Elemental MediaStore container at my.example.container.com by using the browser's XMLHttpRequest capability.</p>
    /// <p>To enable CORS on a container, you attach a CORS policy to the container. In the CORS policy, you configure rules that identify origins and the HTTP methods that can be executed on your container. The policy can contain up to 398,000 characters. You can add up to 100 rules to a CORS policy. If more than one rule applies, the service uses the first applicable rule listed.</p>
    /// <p>To learn more about CORS, see <a href="https://docs.aws.amazon.com/mediastore/latest/ug/cors-policy.html">Cross-Origin Resource Sharing (CORS) in AWS Elemental MediaStore</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutCorsPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_cors_policy_input::Builder,
    }
    impl<C, M, R> PutCorsPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutCorsPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutCorsPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutCorsPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutCorsPolicyInputOperationOutputAlias,
                crate::output::PutCorsPolicyOutput,
                crate::error::PutCorsPolicyError,
                crate::input::PutCorsPolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the container that you want to assign the CORS policy to.</p>
        pub fn container_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.container_name(input.into());
            self
        }
        /// <p>The name of the container that you want to assign the CORS policy to.</p>
        pub fn set_container_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_container_name(input);
            self
        }
        /// Appends an item to `CorsPolicy`.
        ///
        /// To override the contents of this collection use [`set_cors_policy`](Self::set_cors_policy).
        ///
        /// <p>The CORS policy to apply to the container. </p>
        pub fn cors_policy(mut self, input: crate::model::CorsRule) -> Self {
            self.inner = self.inner.cors_policy(input);
            self
        }
        /// <p>The CORS policy to apply to the container. </p>
        pub fn set_cors_policy(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CorsRule>>,
        ) -> Self {
            self.inner = self.inner.set_cors_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutLifecyclePolicy`.
    ///
    /// <p>Writes an object lifecycle policy to a container. If the container already has an object lifecycle policy, the service replaces the existing policy with the new policy. It takes up to 20 minutes for the change to take effect.</p>
    /// <p>For information about how to construct an object lifecycle policy, see <a href="https://docs.aws.amazon.com/mediastore/latest/ug/policies-object-lifecycle-components.html">Components of an Object Lifecycle Policy</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutLifecyclePolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_lifecycle_policy_input::Builder,
    }
    impl<C, M, R> PutLifecyclePolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutLifecyclePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutLifecyclePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutLifecyclePolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutLifecyclePolicyInputOperationOutputAlias,
                crate::output::PutLifecyclePolicyOutput,
                crate::error::PutLifecyclePolicyError,
                crate::input::PutLifecyclePolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the container that you want to assign the object lifecycle policy to.</p>
        pub fn container_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.container_name(input.into());
            self
        }
        /// <p>The name of the container that you want to assign the object lifecycle policy to.</p>
        pub fn set_container_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_container_name(input);
            self
        }
        /// <p>The object lifecycle policy to apply to the container.</p>
        pub fn lifecycle_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lifecycle_policy(input.into());
            self
        }
        /// <p>The object lifecycle policy to apply to the container.</p>
        pub fn set_lifecycle_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_lifecycle_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutMetricPolicy`.
    ///
    /// <p>The metric policy that you want to add to the container. A metric policy allows AWS Elemental MediaStore to send metrics to Amazon CloudWatch. It takes up to 20 minutes for the new policy to take effect.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutMetricPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_metric_policy_input::Builder,
    }
    impl<C, M, R> PutMetricPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutMetricPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutMetricPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutMetricPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutMetricPolicyInputOperationOutputAlias,
                crate::output::PutMetricPolicyOutput,
                crate::error::PutMetricPolicyError,
                crate::input::PutMetricPolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the container that you want to add the metric policy to.</p>
        pub fn container_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.container_name(input.into());
            self
        }
        /// <p>The name of the container that you want to add the metric policy to.</p>
        pub fn set_container_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_container_name(input);
            self
        }
        /// <p>The metric policy that you want to associate with the container. In the policy, you must indicate whether you want MediaStore to send container-level metrics. You can also include up to five rules to define groups of objects that you want MediaStore to send object-level metrics for. If you include rules in the policy, construct each rule with both of the following:</p>
        /// <ul>
        /// <li> <p>An object group that defines which objects to include in the group. The definition can be a path or a file name, but it can't have more than 900 characters. Valid characters are: a-z, A-Z, 0-9, _ (underscore), = (equal), : (colon), . (period), - (hyphen), ~ (tilde), / (forward slash), and * (asterisk). Wildcards (*) are acceptable.</p> </li>
        /// <li> <p>An object group name that allows you to refer to the object group. The name can't have more than 30 characters. Valid characters are: a-z, A-Z, 0-9, and _ (underscore).</p> </li>
        /// </ul>
        pub fn metric_policy(mut self, input: crate::model::MetricPolicy) -> Self {
            self.inner = self.inner.metric_policy(input);
            self
        }
        /// <p>The metric policy that you want to associate with the container. In the policy, you must indicate whether you want MediaStore to send container-level metrics. You can also include up to five rules to define groups of objects that you want MediaStore to send object-level metrics for. If you include rules in the policy, construct each rule with both of the following:</p>
        /// <ul>
        /// <li> <p>An object group that defines which objects to include in the group. The definition can be a path or a file name, but it can't have more than 900 characters. Valid characters are: a-z, A-Z, 0-9, _ (underscore), = (equal), : (colon), . (period), - (hyphen), ~ (tilde), / (forward slash), and * (asterisk). Wildcards (*) are acceptable.</p> </li>
        /// <li> <p>An object group name that allows you to refer to the object group. The name can't have more than 30 characters. Valid characters are: a-z, A-Z, 0-9, and _ (underscore).</p> </li>
        /// </ul>
        pub fn set_metric_policy(
            mut self,
            input: std::option::Option<crate::model::MetricPolicy>,
        ) -> Self {
            self.inner = self.inner.set_metric_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartAccessLogging`.
    ///
    /// <p>Starts access logging on the specified container. When you enable access logging on a container, MediaStore delivers access logs for objects stored in that container to Amazon CloudWatch Logs.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartAccessLogging<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_access_logging_input::Builder,
    }
    impl<C, M, R> StartAccessLogging<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartAccessLogging`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartAccessLoggingOutput,
            aws_smithy_http::result::SdkError<crate::error::StartAccessLoggingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartAccessLoggingInputOperationOutputAlias,
                crate::output::StartAccessLoggingOutput,
                crate::error::StartAccessLoggingError,
                crate::input::StartAccessLoggingInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the container that you want to start access logging on.</p>
        pub fn container_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.container_name(input.into());
            self
        }
        /// <p>The name of the container that you want to start access logging on.</p>
        pub fn set_container_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_container_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopAccessLogging`.
    ///
    /// <p>Stops access logging on the specified container. When you stop access logging on a container, MediaStore stops sending access logs to Amazon CloudWatch Logs. These access logs are not saved and are not retrievable.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StopAccessLogging<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_access_logging_input::Builder,
    }
    impl<C, M, R> StopAccessLogging<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopAccessLogging`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopAccessLoggingOutput,
            aws_smithy_http::result::SdkError<crate::error::StopAccessLoggingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopAccessLoggingInputOperationOutputAlias,
                crate::output::StopAccessLoggingOutput,
                crate::error::StopAccessLoggingError,
                crate::input::StopAccessLoggingInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the container that you want to stop access logging on.</p>
        pub fn container_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.container_name(input.into());
            self
        }
        /// <p>The name of the container that you want to stop access logging on.</p>
        pub fn set_container_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_container_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds tags to the specified AWS Elemental MediaStore container. Tags are key:value pairs that you can associate with AWS resources. For example, the tag key might be "customer" and the tag value might be "companyA." You can specify one or more tags to add to each container. You can add up to 50 tags to each container. For more information about tagging, including naming and usage conventions, see <a href="https://docs.aws.amazon.com/mediastore/latest/ug/tagging.html">Tagging Resources in MediaStore</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) for the container. </p>
        pub fn resource(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the container. </p>
        pub fn set_resource(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of key:value pairs that you want to add to the container. You need to specify only the tags that you want to add or update. For example, suppose a container already has two tags (customer:CompanyA and priority:High). You want to change the priority tag and also add a third tag (type:Contract). For TagResource, you specify the following tags: priority:Medium, type:Contract. The result is that your container has three tags: customer:CompanyA, priority:Medium, and type:Contract.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>An array of key:value pairs that you want to add to the container. You need to specify only the tags that you want to add or update. For example, suppose a container already has two tags (customer:CompanyA and priority:High). You want to change the priority tag and also add a third tag (type:Contract). For TagResource, you specify the following tags: priority:Medium, type:Contract. The result is that your container has three tags: customer:CompanyA, priority:Medium, and type:Contract.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes tags from the specified container. You can specify one or more tags to remove. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) for the container.</p>
        pub fn resource(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the container.</p>
        pub fn set_resource(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A comma-separated list of keys for tags that you want to remove from the container. For example, if your container has two tags (customer:CompanyA and priority:High) and you want to remove one of the tags (priority:High), you specify the key for the tag that you want to remove (priority).</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>A comma-separated list of keys for tags that you want to remove from the container. For example, if your container has two tags (customer:CompanyA and priority:High) and you want to remove one of the tags (priority:High), you specify the key for the tag that you want to remove (priority).</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
