// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// All possible error types for this service.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum Error {
    /// <p>The container that you specified in the request already exists or is being
    /// updated.</p>
    ContainerInUseException(crate::error::ContainerInUseException),
    /// <p>The container that you specified in the request does not exist.</p>
    ContainerNotFoundException(crate::error::ContainerNotFoundException),
    /// <p>The CORS policy that you specified in the request does not exist.</p>
    CorsPolicyNotFoundException(crate::error::CorsPolicyNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>A service limit has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The policy that you specified in the request does not exist.</p>
    PolicyNotFoundException(crate::error::PolicyNotFoundException),
    /// An unhandled error occurred.
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Error::ContainerInUseException(inner) => inner.fmt(f),
            Error::ContainerNotFoundException(inner) => inner.fmt(f),
            Error::CorsPolicyNotFoundException(inner) => inner.fmt(f),
            Error::InternalServerError(inner) => inner.fmt(f),
            Error::LimitExceededException(inner) => inner.fmt(f),
            Error::PolicyNotFoundException(inner) => inner.fmt(f),
            Error::Unhandled(inner) => inner.fmt(f),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateContainerError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateContainerError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateContainerErrorKind::ContainerInUseException(inner) => {
                    Error::ContainerInUseException(inner)
                }
                crate::error::CreateContainerErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::CreateContainerErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::CreateContainerErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteContainerError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteContainerError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteContainerErrorKind::ContainerInUseException(inner) => {
                    Error::ContainerInUseException(inner)
                }
                crate::error::DeleteContainerErrorKind::ContainerNotFoundException(inner) => {
                    Error::ContainerNotFoundException(inner)
                }
                crate::error::DeleteContainerErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DeleteContainerErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteContainerPolicyError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteContainerPolicyError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteContainerPolicyErrorKind::ContainerInUseException(inner) => {
                    Error::ContainerInUseException(inner)
                }
                crate::error::DeleteContainerPolicyErrorKind::ContainerNotFoundException(inner) => {
                    Error::ContainerNotFoundException(inner)
                }
                crate::error::DeleteContainerPolicyErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DeleteContainerPolicyErrorKind::PolicyNotFoundException(inner) => {
                    Error::PolicyNotFoundException(inner)
                }
                crate::error::DeleteContainerPolicyErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteCorsPolicyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteCorsPolicyError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteCorsPolicyErrorKind::ContainerInUseException(inner) => {
                    Error::ContainerInUseException(inner)
                }
                crate::error::DeleteCorsPolicyErrorKind::ContainerNotFoundException(inner) => {
                    Error::ContainerNotFoundException(inner)
                }
                crate::error::DeleteCorsPolicyErrorKind::CorsPolicyNotFoundException(inner) => {
                    Error::CorsPolicyNotFoundException(inner)
                }
                crate::error::DeleteCorsPolicyErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DeleteCorsPolicyErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteLifecyclePolicyError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteLifecyclePolicyError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteLifecyclePolicyErrorKind::ContainerInUseException(inner) => {
                    Error::ContainerInUseException(inner)
                }
                crate::error::DeleteLifecyclePolicyErrorKind::ContainerNotFoundException(inner) => {
                    Error::ContainerNotFoundException(inner)
                }
                crate::error::DeleteLifecyclePolicyErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DeleteLifecyclePolicyErrorKind::PolicyNotFoundException(inner) => {
                    Error::PolicyNotFoundException(inner)
                }
                crate::error::DeleteLifecyclePolicyErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteMetricPolicyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteMetricPolicyError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteMetricPolicyErrorKind::ContainerInUseException(inner) => {
                    Error::ContainerInUseException(inner)
                }
                crate::error::DeleteMetricPolicyErrorKind::ContainerNotFoundException(inner) => {
                    Error::ContainerNotFoundException(inner)
                }
                crate::error::DeleteMetricPolicyErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DeleteMetricPolicyErrorKind::PolicyNotFoundException(inner) => {
                    Error::PolicyNotFoundException(inner)
                }
                crate::error::DeleteMetricPolicyErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeContainerError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeContainerError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeContainerErrorKind::ContainerNotFoundException(inner) => {
                    Error::ContainerNotFoundException(inner)
                }
                crate::error::DescribeContainerErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DescribeContainerErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetContainerPolicyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetContainerPolicyError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetContainerPolicyErrorKind::ContainerInUseException(inner) => {
                    Error::ContainerInUseException(inner)
                }
                crate::error::GetContainerPolicyErrorKind::ContainerNotFoundException(inner) => {
                    Error::ContainerNotFoundException(inner)
                }
                crate::error::GetContainerPolicyErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::GetContainerPolicyErrorKind::PolicyNotFoundException(inner) => {
                    Error::PolicyNotFoundException(inner)
                }
                crate::error::GetContainerPolicyErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetCorsPolicyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetCorsPolicyError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetCorsPolicyErrorKind::ContainerInUseException(inner) => {
                    Error::ContainerInUseException(inner)
                }
                crate::error::GetCorsPolicyErrorKind::ContainerNotFoundException(inner) => {
                    Error::ContainerNotFoundException(inner)
                }
                crate::error::GetCorsPolicyErrorKind::CorsPolicyNotFoundException(inner) => {
                    Error::CorsPolicyNotFoundException(inner)
                }
                crate::error::GetCorsPolicyErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::GetCorsPolicyErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetLifecyclePolicyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetLifecyclePolicyError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetLifecyclePolicyErrorKind::ContainerInUseException(inner) => {
                    Error::ContainerInUseException(inner)
                }
                crate::error::GetLifecyclePolicyErrorKind::ContainerNotFoundException(inner) => {
                    Error::ContainerNotFoundException(inner)
                }
                crate::error::GetLifecyclePolicyErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::GetLifecyclePolicyErrorKind::PolicyNotFoundException(inner) => {
                    Error::PolicyNotFoundException(inner)
                }
                crate::error::GetLifecyclePolicyErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetMetricPolicyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetMetricPolicyError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetMetricPolicyErrorKind::ContainerInUseException(inner) => {
                    Error::ContainerInUseException(inner)
                }
                crate::error::GetMetricPolicyErrorKind::ContainerNotFoundException(inner) => {
                    Error::ContainerNotFoundException(inner)
                }
                crate::error::GetMetricPolicyErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::GetMetricPolicyErrorKind::PolicyNotFoundException(inner) => {
                    Error::PolicyNotFoundException(inner)
                }
                crate::error::GetMetricPolicyErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListContainersError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListContainersError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListContainersErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::ListContainersErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListTagsForResourceErrorKind::ContainerInUseException(inner) => {
                    Error::ContainerInUseException(inner)
                }
                crate::error::ListTagsForResourceErrorKind::ContainerNotFoundException(inner) => {
                    Error::ContainerNotFoundException(inner)
                }
                crate::error::ListTagsForResourceErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::ListTagsForResourceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutContainerPolicyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::PutContainerPolicyError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::PutContainerPolicyErrorKind::ContainerInUseException(inner) => {
                    Error::ContainerInUseException(inner)
                }
                crate::error::PutContainerPolicyErrorKind::ContainerNotFoundException(inner) => {
                    Error::ContainerNotFoundException(inner)
                }
                crate::error::PutContainerPolicyErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::PutContainerPolicyErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutCorsPolicyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::PutCorsPolicyError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::PutCorsPolicyErrorKind::ContainerInUseException(inner) => {
                    Error::ContainerInUseException(inner)
                }
                crate::error::PutCorsPolicyErrorKind::ContainerNotFoundException(inner) => {
                    Error::ContainerNotFoundException(inner)
                }
                crate::error::PutCorsPolicyErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::PutCorsPolicyErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutLifecyclePolicyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::PutLifecyclePolicyError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::PutLifecyclePolicyErrorKind::ContainerInUseException(inner) => {
                    Error::ContainerInUseException(inner)
                }
                crate::error::PutLifecyclePolicyErrorKind::ContainerNotFoundException(inner) => {
                    Error::ContainerNotFoundException(inner)
                }
                crate::error::PutLifecyclePolicyErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::PutLifecyclePolicyErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutMetricPolicyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::PutMetricPolicyError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::PutMetricPolicyErrorKind::ContainerInUseException(inner) => {
                    Error::ContainerInUseException(inner)
                }
                crate::error::PutMetricPolicyErrorKind::ContainerNotFoundException(inner) => {
                    Error::ContainerNotFoundException(inner)
                }
                crate::error::PutMetricPolicyErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::PutMetricPolicyErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartAccessLoggingError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StartAccessLoggingError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StartAccessLoggingErrorKind::ContainerInUseException(inner) => {
                    Error::ContainerInUseException(inner)
                }
                crate::error::StartAccessLoggingErrorKind::ContainerNotFoundException(inner) => {
                    Error::ContainerNotFoundException(inner)
                }
                crate::error::StartAccessLoggingErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::StartAccessLoggingErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StopAccessLoggingError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StopAccessLoggingError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StopAccessLoggingErrorKind::ContainerInUseException(inner) => {
                    Error::ContainerInUseException(inner)
                }
                crate::error::StopAccessLoggingErrorKind::ContainerNotFoundException(inner) => {
                    Error::ContainerNotFoundException(inner)
                }
                crate::error::StopAccessLoggingErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::StopAccessLoggingErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::TagResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::TagResourceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::TagResourceErrorKind::ContainerInUseException(inner) => {
                    Error::ContainerInUseException(inner)
                }
                crate::error::TagResourceErrorKind::ContainerNotFoundException(inner) => {
                    Error::ContainerNotFoundException(inner)
                }
                crate::error::TagResourceErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::TagResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UntagResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UntagResourceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UntagResourceErrorKind::ContainerInUseException(inner) => {
                    Error::ContainerInUseException(inner)
                }
                crate::error::UntagResourceErrorKind::ContainerNotFoundException(inner) => {
                    Error::ContainerNotFoundException(inner)
                }
                crate::error::UntagResourceErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::UntagResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl std::error::Error for Error {}
