// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>A collection of tags associated with a container. Each tag consists of a key:value pair, which can be anything you define. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each container. For more information about tagging, including naming and usage conventions, see <a href="https://docs.aws.amazon.com/mediastore/latest/ug/tagging.html">Tagging Resources in MediaStore</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>Part of the key:value pair that defines a tag. You can use a tag key to describe a category of information, such as "customer." Tag keys are case-sensitive.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>Part of the key:value pair that defines a tag. You can use a tag value to describe a specific value within a category, such as "companyA" or "companyB." Tag values are case-sensitive.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>Part of the key:value pair that defines a tag. You can use a tag key to describe a category of information, such as "customer." Tag keys are case-sensitive.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>Part of the key:value pair that defines a tag. You can use a tag value to describe a specific value within a category, such as "companyA" or "companyB." Tag values are case-sensitive.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Part of the key:value pair that defines a tag. You can use a tag key to describe a category of information, such as "customer." Tag keys are case-sensitive.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>Part of the key:value pair that defines a tag. You can use a tag key to describe a category of information, such as "customer." Tag keys are case-sensitive.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>Part of the key:value pair that defines a tag. You can use a tag value to describe a specific value within a category, such as "companyA" or "companyB." Tag values are case-sensitive.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>Part of the key:value pair that defines a tag. You can use a tag value to describe a specific value within a category, such as "companyA" or "companyB." Tag values are case-sensitive.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>The metric policy that is associated with the container. A metric policy allows AWS Elemental MediaStore to send metrics to Amazon CloudWatch. In the policy, you must indicate whether you want MediaStore to send container-level metrics. You can also include rules to define groups of objects that you want MediaStore to send object-level metrics for.</p>
/// <p>To view examples of how to construct a metric policy for your use case, see <a href="https://docs.aws.amazon.com/mediastore/latest/ug/policies-metric-examples.html">Example Metric Policies</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MetricPolicy {
    /// <p>A setting to enable or disable metrics at the container level.</p>
    pub container_level_metrics: std::option::Option<crate::model::ContainerLevelMetrics>,
    /// <p>A parameter that holds an array of rules that enable metrics at the object level. This parameter is optional, but if you choose to include it, you must also include at least one rule. By default, you can include up to five rules. You can also <a href="https://console.aws.amazon.com/servicequotas/home?region=us-east-1#!/services/mediastore/quotas">request a quota increase</a> to allow up to 300 rules per policy.</p>
    pub metric_policy_rules: std::option::Option<std::vec::Vec<crate::model::MetricPolicyRule>>,
}
impl MetricPolicy {
    /// <p>A setting to enable or disable metrics at the container level.</p>
    pub fn container_level_metrics(
        &self,
    ) -> std::option::Option<&crate::model::ContainerLevelMetrics> {
        self.container_level_metrics.as_ref()
    }
    /// <p>A parameter that holds an array of rules that enable metrics at the object level. This parameter is optional, but if you choose to include it, you must also include at least one rule. By default, you can include up to five rules. You can also <a href="https://console.aws.amazon.com/servicequotas/home?region=us-east-1#!/services/mediastore/quotas">request a quota increase</a> to allow up to 300 rules per policy.</p>
    pub fn metric_policy_rules(&self) -> std::option::Option<&[crate::model::MetricPolicyRule]> {
        self.metric_policy_rules.as_deref()
    }
}
impl std::fmt::Debug for MetricPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MetricPolicy");
        formatter.field("container_level_metrics", &self.container_level_metrics);
        formatter.field("metric_policy_rules", &self.metric_policy_rules);
        formatter.finish()
    }
}
/// See [`MetricPolicy`](crate::model::MetricPolicy)
pub mod metric_policy {
    /// A builder for [`MetricPolicy`](crate::model::MetricPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) container_level_metrics:
            std::option::Option<crate::model::ContainerLevelMetrics>,
        pub(crate) metric_policy_rules:
            std::option::Option<std::vec::Vec<crate::model::MetricPolicyRule>>,
    }
    impl Builder {
        /// <p>A setting to enable or disable metrics at the container level.</p>
        pub fn container_level_metrics(
            mut self,
            input: crate::model::ContainerLevelMetrics,
        ) -> Self {
            self.container_level_metrics = Some(input);
            self
        }
        /// <p>A setting to enable or disable metrics at the container level.</p>
        pub fn set_container_level_metrics(
            mut self,
            input: std::option::Option<crate::model::ContainerLevelMetrics>,
        ) -> Self {
            self.container_level_metrics = input;
            self
        }
        /// Appends an item to `metric_policy_rules`.
        ///
        /// To override the contents of this collection use [`set_metric_policy_rules`](Self::set_metric_policy_rules).
        ///
        /// <p>A parameter that holds an array of rules that enable metrics at the object level. This parameter is optional, but if you choose to include it, you must also include at least one rule. By default, you can include up to five rules. You can also <a href="https://console.aws.amazon.com/servicequotas/home?region=us-east-1#!/services/mediastore/quotas">request a quota increase</a> to allow up to 300 rules per policy.</p>
        pub fn metric_policy_rules(mut self, input: crate::model::MetricPolicyRule) -> Self {
            let mut v = self.metric_policy_rules.unwrap_or_default();
            v.push(input);
            self.metric_policy_rules = Some(v);
            self
        }
        /// <p>A parameter that holds an array of rules that enable metrics at the object level. This parameter is optional, but if you choose to include it, you must also include at least one rule. By default, you can include up to five rules. You can also <a href="https://console.aws.amazon.com/servicequotas/home?region=us-east-1#!/services/mediastore/quotas">request a quota increase</a> to allow up to 300 rules per policy.</p>
        pub fn set_metric_policy_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MetricPolicyRule>>,
        ) -> Self {
            self.metric_policy_rules = input;
            self
        }
        /// Consumes the builder and constructs a [`MetricPolicy`](crate::model::MetricPolicy)
        pub fn build(self) -> crate::model::MetricPolicy {
            crate::model::MetricPolicy {
                container_level_metrics: self.container_level_metrics,
                metric_policy_rules: self.metric_policy_rules,
            }
        }
    }
}
impl MetricPolicy {
    /// Creates a new builder-style object to manufacture [`MetricPolicy`](crate::model::MetricPolicy)
    pub fn builder() -> crate::model::metric_policy::Builder {
        crate::model::metric_policy::Builder::default()
    }
}

/// <p>A setting that enables metrics at the object level. Each rule contains an object group and an object group name. If the policy includes the MetricPolicyRules parameter, you must include at least one rule. Each metric policy can include up to five rules by default. You can also <a href="https://console.aws.amazon.com/servicequotas/home?region=us-east-1#!/services/mediastore/quotas">request a quota increase</a> to allow up to 300 rules per policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MetricPolicyRule {
    /// <p>A path or file name that defines which objects to include in the group. Wildcards (*) are acceptable.</p>
    pub object_group: std::option::Option<std::string::String>,
    /// <p>A name that allows you to refer to the object group.</p>
    pub object_group_name: std::option::Option<std::string::String>,
}
impl MetricPolicyRule {
    /// <p>A path or file name that defines which objects to include in the group. Wildcards (*) are acceptable.</p>
    pub fn object_group(&self) -> std::option::Option<&str> {
        self.object_group.as_deref()
    }
    /// <p>A name that allows you to refer to the object group.</p>
    pub fn object_group_name(&self) -> std::option::Option<&str> {
        self.object_group_name.as_deref()
    }
}
impl std::fmt::Debug for MetricPolicyRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MetricPolicyRule");
        formatter.field("object_group", &self.object_group);
        formatter.field("object_group_name", &self.object_group_name);
        formatter.finish()
    }
}
/// See [`MetricPolicyRule`](crate::model::MetricPolicyRule)
pub mod metric_policy_rule {
    /// A builder for [`MetricPolicyRule`](crate::model::MetricPolicyRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) object_group: std::option::Option<std::string::String>,
        pub(crate) object_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A path or file name that defines which objects to include in the group. Wildcards (*) are acceptable.</p>
        pub fn object_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.object_group = Some(input.into());
            self
        }
        /// <p>A path or file name that defines which objects to include in the group. Wildcards (*) are acceptable.</p>
        pub fn set_object_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.object_group = input;
            self
        }
        /// <p>A name that allows you to refer to the object group.</p>
        pub fn object_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.object_group_name = Some(input.into());
            self
        }
        /// <p>A name that allows you to refer to the object group.</p>
        pub fn set_object_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.object_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`MetricPolicyRule`](crate::model::MetricPolicyRule)
        pub fn build(self) -> crate::model::MetricPolicyRule {
            crate::model::MetricPolicyRule {
                object_group: self.object_group,
                object_group_name: self.object_group_name,
            }
        }
    }
}
impl MetricPolicyRule {
    /// Creates a new builder-style object to manufacture [`MetricPolicyRule`](crate::model::MetricPolicyRule)
    pub fn builder() -> crate::model::metric_policy_rule::Builder {
        crate::model::metric_policy_rule::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ContainerLevelMetrics {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ContainerLevelMetrics {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => ContainerLevelMetrics::Disabled,
            "ENABLED" => ContainerLevelMetrics::Enabled,
            other => ContainerLevelMetrics::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ContainerLevelMetrics {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ContainerLevelMetrics::from(s))
    }
}
impl ContainerLevelMetrics {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ContainerLevelMetrics::Disabled => "DISABLED",
            ContainerLevelMetrics::Enabled => "ENABLED",
            ContainerLevelMetrics::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for ContainerLevelMetrics {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A rule for a CORS policy. You can add up to 100 rules to a CORS policy. If more than one rule applies, the service uses the first applicable rule listed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CorsRule {
    /// <p>One or more response headers that you want users to be able to access from their applications (for example, from a JavaScript <code>XMLHttpRequest</code> object).</p>
    /// <p>Each CORS rule must have at least one <code>AllowedOrigins</code> element. The string value can include only one wildcard character (*), for example, http://*.example.com. Additionally, you can specify only one wildcard character to allow cross-origin access for all origins.</p>
    pub allowed_origins: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Identifies an HTTP method that the origin that is specified in the rule is allowed to execute.</p>
    /// <p>Each CORS rule must contain at least one <code>AllowedMethods</code> and one <code>AllowedOrigins</code> element.</p>
    pub allowed_methods: std::option::Option<std::vec::Vec<crate::model::MethodName>>,
    /// <p>Specifies which headers are allowed in a preflight <code>OPTIONS</code> request through the <code>Access-Control-Request-Headers</code> header. Each header name that is specified in <code>Access-Control-Request-Headers</code> must have a corresponding entry in the rule. Only the headers that were requested are sent back. </p>
    /// <p>This element can contain only one wildcard character (*).</p>
    pub allowed_headers: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The time in seconds that your browser caches the preflight response for the specified resource.</p>
    /// <p>A CORS rule can have only one <code>MaxAgeSeconds</code> element.</p>
    pub max_age_seconds: i32,
    /// <p>One or more headers in the response that you want users to be able to access from their applications (for example, from a JavaScript <code>XMLHttpRequest</code> object).</p>
    /// <p>This element is optional for each rule.</p>
    pub expose_headers: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl CorsRule {
    /// <p>One or more response headers that you want users to be able to access from their applications (for example, from a JavaScript <code>XMLHttpRequest</code> object).</p>
    /// <p>Each CORS rule must have at least one <code>AllowedOrigins</code> element. The string value can include only one wildcard character (*), for example, http://*.example.com. Additionally, you can specify only one wildcard character to allow cross-origin access for all origins.</p>
    pub fn allowed_origins(&self) -> std::option::Option<&[std::string::String]> {
        self.allowed_origins.as_deref()
    }
    /// <p>Identifies an HTTP method that the origin that is specified in the rule is allowed to execute.</p>
    /// <p>Each CORS rule must contain at least one <code>AllowedMethods</code> and one <code>AllowedOrigins</code> element.</p>
    pub fn allowed_methods(&self) -> std::option::Option<&[crate::model::MethodName]> {
        self.allowed_methods.as_deref()
    }
    /// <p>Specifies which headers are allowed in a preflight <code>OPTIONS</code> request through the <code>Access-Control-Request-Headers</code> header. Each header name that is specified in <code>Access-Control-Request-Headers</code> must have a corresponding entry in the rule. Only the headers that were requested are sent back. </p>
    /// <p>This element can contain only one wildcard character (*).</p>
    pub fn allowed_headers(&self) -> std::option::Option<&[std::string::String]> {
        self.allowed_headers.as_deref()
    }
    /// <p>The time in seconds that your browser caches the preflight response for the specified resource.</p>
    /// <p>A CORS rule can have only one <code>MaxAgeSeconds</code> element.</p>
    pub fn max_age_seconds(&self) -> i32 {
        self.max_age_seconds
    }
    /// <p>One or more headers in the response that you want users to be able to access from their applications (for example, from a JavaScript <code>XMLHttpRequest</code> object).</p>
    /// <p>This element is optional for each rule.</p>
    pub fn expose_headers(&self) -> std::option::Option<&[std::string::String]> {
        self.expose_headers.as_deref()
    }
}
impl std::fmt::Debug for CorsRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CorsRule");
        formatter.field("allowed_origins", &self.allowed_origins);
        formatter.field("allowed_methods", &self.allowed_methods);
        formatter.field("allowed_headers", &self.allowed_headers);
        formatter.field("max_age_seconds", &self.max_age_seconds);
        formatter.field("expose_headers", &self.expose_headers);
        formatter.finish()
    }
}
/// See [`CorsRule`](crate::model::CorsRule)
pub mod cors_rule {
    /// A builder for [`CorsRule`](crate::model::CorsRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) allowed_origins: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) allowed_methods: std::option::Option<std::vec::Vec<crate::model::MethodName>>,
        pub(crate) allowed_headers: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) max_age_seconds: std::option::Option<i32>,
        pub(crate) expose_headers: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `allowed_origins`.
        ///
        /// To override the contents of this collection use [`set_allowed_origins`](Self::set_allowed_origins).
        ///
        /// <p>One or more response headers that you want users to be able to access from their applications (for example, from a JavaScript <code>XMLHttpRequest</code> object).</p>
        /// <p>Each CORS rule must have at least one <code>AllowedOrigins</code> element. The string value can include only one wildcard character (*), for example, http://*.example.com. Additionally, you can specify only one wildcard character to allow cross-origin access for all origins.</p>
        pub fn allowed_origins(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.allowed_origins.unwrap_or_default();
            v.push(input.into());
            self.allowed_origins = Some(v);
            self
        }
        /// <p>One or more response headers that you want users to be able to access from their applications (for example, from a JavaScript <code>XMLHttpRequest</code> object).</p>
        /// <p>Each CORS rule must have at least one <code>AllowedOrigins</code> element. The string value can include only one wildcard character (*), for example, http://*.example.com. Additionally, you can specify only one wildcard character to allow cross-origin access for all origins.</p>
        pub fn set_allowed_origins(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.allowed_origins = input;
            self
        }
        /// Appends an item to `allowed_methods`.
        ///
        /// To override the contents of this collection use [`set_allowed_methods`](Self::set_allowed_methods).
        ///
        /// <p>Identifies an HTTP method that the origin that is specified in the rule is allowed to execute.</p>
        /// <p>Each CORS rule must contain at least one <code>AllowedMethods</code> and one <code>AllowedOrigins</code> element.</p>
        pub fn allowed_methods(mut self, input: crate::model::MethodName) -> Self {
            let mut v = self.allowed_methods.unwrap_or_default();
            v.push(input);
            self.allowed_methods = Some(v);
            self
        }
        /// <p>Identifies an HTTP method that the origin that is specified in the rule is allowed to execute.</p>
        /// <p>Each CORS rule must contain at least one <code>AllowedMethods</code> and one <code>AllowedOrigins</code> element.</p>
        pub fn set_allowed_methods(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MethodName>>,
        ) -> Self {
            self.allowed_methods = input;
            self
        }
        /// Appends an item to `allowed_headers`.
        ///
        /// To override the contents of this collection use [`set_allowed_headers`](Self::set_allowed_headers).
        ///
        /// <p>Specifies which headers are allowed in a preflight <code>OPTIONS</code> request through the <code>Access-Control-Request-Headers</code> header. Each header name that is specified in <code>Access-Control-Request-Headers</code> must have a corresponding entry in the rule. Only the headers that were requested are sent back. </p>
        /// <p>This element can contain only one wildcard character (*).</p>
        pub fn allowed_headers(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.allowed_headers.unwrap_or_default();
            v.push(input.into());
            self.allowed_headers = Some(v);
            self
        }
        /// <p>Specifies which headers are allowed in a preflight <code>OPTIONS</code> request through the <code>Access-Control-Request-Headers</code> header. Each header name that is specified in <code>Access-Control-Request-Headers</code> must have a corresponding entry in the rule. Only the headers that were requested are sent back. </p>
        /// <p>This element can contain only one wildcard character (*).</p>
        pub fn set_allowed_headers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.allowed_headers = input;
            self
        }
        /// <p>The time in seconds that your browser caches the preflight response for the specified resource.</p>
        /// <p>A CORS rule can have only one <code>MaxAgeSeconds</code> element.</p>
        pub fn max_age_seconds(mut self, input: i32) -> Self {
            self.max_age_seconds = Some(input);
            self
        }
        /// <p>The time in seconds that your browser caches the preflight response for the specified resource.</p>
        /// <p>A CORS rule can have only one <code>MaxAgeSeconds</code> element.</p>
        pub fn set_max_age_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.max_age_seconds = input;
            self
        }
        /// Appends an item to `expose_headers`.
        ///
        /// To override the contents of this collection use [`set_expose_headers`](Self::set_expose_headers).
        ///
        /// <p>One or more headers in the response that you want users to be able to access from their applications (for example, from a JavaScript <code>XMLHttpRequest</code> object).</p>
        /// <p>This element is optional for each rule.</p>
        pub fn expose_headers(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.expose_headers.unwrap_or_default();
            v.push(input.into());
            self.expose_headers = Some(v);
            self
        }
        /// <p>One or more headers in the response that you want users to be able to access from their applications (for example, from a JavaScript <code>XMLHttpRequest</code> object).</p>
        /// <p>This element is optional for each rule.</p>
        pub fn set_expose_headers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.expose_headers = input;
            self
        }
        /// Consumes the builder and constructs a [`CorsRule`](crate::model::CorsRule)
        pub fn build(self) -> crate::model::CorsRule {
            crate::model::CorsRule {
                allowed_origins: self.allowed_origins,
                allowed_methods: self.allowed_methods,
                allowed_headers: self.allowed_headers,
                max_age_seconds: self.max_age_seconds.unwrap_or_default(),
                expose_headers: self.expose_headers,
            }
        }
    }
}
impl CorsRule {
    /// Creates a new builder-style object to manufacture [`CorsRule`](crate::model::CorsRule)
    pub fn builder() -> crate::model::cors_rule::Builder {
        crate::model::cors_rule::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MethodName {
    #[allow(missing_docs)] // documentation missing in model
    Delete,
    #[allow(missing_docs)] // documentation missing in model
    Get,
    #[allow(missing_docs)] // documentation missing in model
    Head,
    #[allow(missing_docs)] // documentation missing in model
    Put,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MethodName {
    fn from(s: &str) -> Self {
        match s {
            "DELETE" => MethodName::Delete,
            "GET" => MethodName::Get,
            "HEAD" => MethodName::Head,
            "PUT" => MethodName::Put,
            other => MethodName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MethodName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MethodName::from(s))
    }
}
impl MethodName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MethodName::Delete => "DELETE",
            MethodName::Get => "GET",
            MethodName::Head => "HEAD",
            MethodName::Put => "PUT",
            MethodName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DELETE", "GET", "HEAD", "PUT"]
    }
}
impl AsRef<str> for MethodName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>This section describes operations that you can perform on an AWS Elemental MediaStore container.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Container {
    /// <p>The DNS endpoint of the container. Use the endpoint to identify the specific container when sending requests to the data plane. The service assigns this value when the container is created. Once the value has been assigned, it does not change.</p>
    pub endpoint: std::option::Option<std::string::String>,
    /// <p>Unix timestamp.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The Amazon Resource Name (ARN) of the container. The ARN has the following format:</p>
    /// <p>arn:aws:<region>
    /// :
    /// <account that owns this container>
    /// :container/
    /// <name of container>
    /// </name>
    /// </account>
    /// </region></p>
    /// <p>For example: arn:aws:mediastore:us-west-2:111122223333:container/movies </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the container.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The status of container creation or deletion. The status is one of the following: <code>CREATING</code>, <code>ACTIVE</code>, or <code>DELETING</code>. While the service is creating the container, the status is <code>CREATING</code>. When the endpoint is available, the status changes to <code>ACTIVE</code>.</p>
    pub status: std::option::Option<crate::model::ContainerStatus>,
    /// <p>The state of access logging on the container. This value is <code>false</code> by default, indicating that AWS Elemental MediaStore does not send access logs to Amazon CloudWatch Logs. When you enable access logging on the container, MediaStore changes this value to <code>true</code>, indicating that the service delivers access logs for objects stored in that container to CloudWatch Logs.</p>
    pub access_logging_enabled: std::option::Option<bool>,
}
impl Container {
    /// <p>The DNS endpoint of the container. Use the endpoint to identify the specific container when sending requests to the data plane. The service assigns this value when the container is created. Once the value has been assigned, it does not change.</p>
    pub fn endpoint(&self) -> std::option::Option<&str> {
        self.endpoint.as_deref()
    }
    /// <p>Unix timestamp.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the container. The ARN has the following format:</p>
    /// <p>arn:aws:<region>
    /// :
    /// <account that owns this container>
    /// :container/
    /// <name of container>
    /// </name>
    /// </account>
    /// </region></p>
    /// <p>For example: arn:aws:mediastore:us-west-2:111122223333:container/movies </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the container.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The status of container creation or deletion. The status is one of the following: <code>CREATING</code>, <code>ACTIVE</code>, or <code>DELETING</code>. While the service is creating the container, the status is <code>CREATING</code>. When the endpoint is available, the status changes to <code>ACTIVE</code>.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ContainerStatus> {
        self.status.as_ref()
    }
    /// <p>The state of access logging on the container. This value is <code>false</code> by default, indicating that AWS Elemental MediaStore does not send access logs to Amazon CloudWatch Logs. When you enable access logging on the container, MediaStore changes this value to <code>true</code>, indicating that the service delivers access logs for objects stored in that container to CloudWatch Logs.</p>
    pub fn access_logging_enabled(&self) -> std::option::Option<bool> {
        self.access_logging_enabled
    }
}
impl std::fmt::Debug for Container {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Container");
        formatter.field("endpoint", &self.endpoint);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("status", &self.status);
        formatter.field("access_logging_enabled", &self.access_logging_enabled);
        formatter.finish()
    }
}
/// See [`Container`](crate::model::Container)
pub mod container {
    /// A builder for [`Container`](crate::model::Container)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ContainerStatus>,
        pub(crate) access_logging_enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The DNS endpoint of the container. Use the endpoint to identify the specific container when sending requests to the data plane. The service assigns this value when the container is created. Once the value has been assigned, it does not change.</p>
        pub fn endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint = Some(input.into());
            self
        }
        /// <p>The DNS endpoint of the container. Use the endpoint to identify the specific container when sending requests to the data plane. The service assigns this value when the container is created. Once the value has been assigned, it does not change.</p>
        pub fn set_endpoint(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint = input;
            self
        }
        /// <p>Unix timestamp.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>Unix timestamp.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the container. The ARN has the following format:</p>
        /// <p>arn:aws:<region>
        /// :
        /// <account that owns this container>
        /// :container/
        /// <name of container>
        /// </name>
        /// </account>
        /// </region></p>
        /// <p>For example: arn:aws:mediastore:us-west-2:111122223333:container/movies </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the container. The ARN has the following format:</p>
        /// <p>arn:aws:<region>
        /// :
        /// <account that owns this container>
        /// :container/
        /// <name of container>
        /// </name>
        /// </account>
        /// </region></p>
        /// <p>For example: arn:aws:mediastore:us-west-2:111122223333:container/movies </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the container.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the container.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The status of container creation or deletion. The status is one of the following: <code>CREATING</code>, <code>ACTIVE</code>, or <code>DELETING</code>. While the service is creating the container, the status is <code>CREATING</code>. When the endpoint is available, the status changes to <code>ACTIVE</code>.</p>
        pub fn status(mut self, input: crate::model::ContainerStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of container creation or deletion. The status is one of the following: <code>CREATING</code>, <code>ACTIVE</code>, or <code>DELETING</code>. While the service is creating the container, the status is <code>CREATING</code>. When the endpoint is available, the status changes to <code>ACTIVE</code>.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ContainerStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The state of access logging on the container. This value is <code>false</code> by default, indicating that AWS Elemental MediaStore does not send access logs to Amazon CloudWatch Logs. When you enable access logging on the container, MediaStore changes this value to <code>true</code>, indicating that the service delivers access logs for objects stored in that container to CloudWatch Logs.</p>
        pub fn access_logging_enabled(mut self, input: bool) -> Self {
            self.access_logging_enabled = Some(input);
            self
        }
        /// <p>The state of access logging on the container. This value is <code>false</code> by default, indicating that AWS Elemental MediaStore does not send access logs to Amazon CloudWatch Logs. When you enable access logging on the container, MediaStore changes this value to <code>true</code>, indicating that the service delivers access logs for objects stored in that container to CloudWatch Logs.</p>
        pub fn set_access_logging_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.access_logging_enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`Container`](crate::model::Container)
        pub fn build(self) -> crate::model::Container {
            crate::model::Container {
                endpoint: self.endpoint,
                creation_time: self.creation_time,
                arn: self.arn,
                name: self.name,
                status: self.status,
                access_logging_enabled: self.access_logging_enabled,
            }
        }
    }
}
impl Container {
    /// Creates a new builder-style object to manufacture [`Container`](crate::model::Container)
    pub fn builder() -> crate::model::container::Builder {
        crate::model::container::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ContainerStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ContainerStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => ContainerStatus::Active,
            "CREATING" => ContainerStatus::Creating,
            "DELETING" => ContainerStatus::Deleting,
            other => ContainerStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ContainerStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ContainerStatus::from(s))
    }
}
impl ContainerStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ContainerStatus::Active => "ACTIVE",
            ContainerStatus::Creating => "CREATING",
            ContainerStatus::Deleting => "DELETING",
            ContainerStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "CREATING", "DELETING"]
    }
}
impl AsRef<str> for ContainerStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
