// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CreateContainer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateContainerError {
    /// Kind of error that occurred.
    pub kind: CreateContainerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateContainer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateContainerErrorKind {
    /// <p>The container that you specified in the request already exists or is being
    /// updated.</p>
    ContainerInUseException(crate::error::ContainerInUseException),
    /// <p>The service is temporarily unavailable.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>A service limit has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateContainerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateContainerErrorKind::ContainerInUseException(_inner) => _inner.fmt(f),
            CreateContainerErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            CreateContainerErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateContainerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateContainerError {
    fn code(&self) -> Option<&str> {
        CreateContainerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateContainerError {
    /// Creates a new `CreateContainerError`.
    pub fn new(kind: CreateContainerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateContainerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateContainerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateContainerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateContainerErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateContainerErrorKind::ContainerInUseException`.
    pub fn is_container_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateContainerErrorKind::ContainerInUseException(_)
        )
    }
    /// Returns true if the error kind is `CreateContainerErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, CreateContainerErrorKind::InternalServerError(_))
    }
    /// Returns true if the error kind is `CreateContainerErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateContainerErrorKind::LimitExceededException(_)
        )
    }
}
impl std::error::Error for CreateContainerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateContainerErrorKind::ContainerInUseException(_inner) => Some(_inner),
            CreateContainerErrorKind::InternalServerError(_inner) => Some(_inner),
            CreateContainerErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateContainerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteContainer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteContainerError {
    /// Kind of error that occurred.
    pub kind: DeleteContainerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteContainer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteContainerErrorKind {
    /// <p>The container that you specified in the request already exists or is being
    /// updated.</p>
    ContainerInUseException(crate::error::ContainerInUseException),
    /// <p>The container that you specified in the request does not exist.</p>
    ContainerNotFoundException(crate::error::ContainerNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteContainerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteContainerErrorKind::ContainerInUseException(_inner) => _inner.fmt(f),
            DeleteContainerErrorKind::ContainerNotFoundException(_inner) => _inner.fmt(f),
            DeleteContainerErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DeleteContainerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteContainerError {
    fn code(&self) -> Option<&str> {
        DeleteContainerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteContainerError {
    /// Creates a new `DeleteContainerError`.
    pub fn new(kind: DeleteContainerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteContainerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteContainerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteContainerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteContainerErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteContainerErrorKind::ContainerInUseException`.
    pub fn is_container_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteContainerErrorKind::ContainerInUseException(_)
        )
    }
    /// Returns true if the error kind is `DeleteContainerErrorKind::ContainerNotFoundException`.
    pub fn is_container_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteContainerErrorKind::ContainerNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteContainerErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, DeleteContainerErrorKind::InternalServerError(_))
    }
}
impl std::error::Error for DeleteContainerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteContainerErrorKind::ContainerInUseException(_inner) => Some(_inner),
            DeleteContainerErrorKind::ContainerNotFoundException(_inner) => Some(_inner),
            DeleteContainerErrorKind::InternalServerError(_inner) => Some(_inner),
            DeleteContainerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteContainerPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteContainerPolicyError {
    /// Kind of error that occurred.
    pub kind: DeleteContainerPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteContainerPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteContainerPolicyErrorKind {
    /// <p>The container that you specified in the request already exists or is being
    /// updated.</p>
    ContainerInUseException(crate::error::ContainerInUseException),
    /// <p>The container that you specified in the request does not exist.</p>
    ContainerNotFoundException(crate::error::ContainerNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The policy that you specified in the request does not exist.</p>
    PolicyNotFoundException(crate::error::PolicyNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteContainerPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteContainerPolicyErrorKind::ContainerInUseException(_inner) => _inner.fmt(f),
            DeleteContainerPolicyErrorKind::ContainerNotFoundException(_inner) => _inner.fmt(f),
            DeleteContainerPolicyErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DeleteContainerPolicyErrorKind::PolicyNotFoundException(_inner) => _inner.fmt(f),
            DeleteContainerPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteContainerPolicyError {
    fn code(&self) -> Option<&str> {
        DeleteContainerPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteContainerPolicyError {
    /// Creates a new `DeleteContainerPolicyError`.
    pub fn new(kind: DeleteContainerPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteContainerPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteContainerPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteContainerPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteContainerPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteContainerPolicyErrorKind::ContainerInUseException`.
    pub fn is_container_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteContainerPolicyErrorKind::ContainerInUseException(_)
        )
    }
    /// Returns true if the error kind is `DeleteContainerPolicyErrorKind::ContainerNotFoundException`.
    pub fn is_container_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteContainerPolicyErrorKind::ContainerNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteContainerPolicyErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DeleteContainerPolicyErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `DeleteContainerPolicyErrorKind::PolicyNotFoundException`.
    pub fn is_policy_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteContainerPolicyErrorKind::PolicyNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteContainerPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteContainerPolicyErrorKind::ContainerInUseException(_inner) => Some(_inner),
            DeleteContainerPolicyErrorKind::ContainerNotFoundException(_inner) => Some(_inner),
            DeleteContainerPolicyErrorKind::InternalServerError(_inner) => Some(_inner),
            DeleteContainerPolicyErrorKind::PolicyNotFoundException(_inner) => Some(_inner),
            DeleteContainerPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteCorsPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteCorsPolicyError {
    /// Kind of error that occurred.
    pub kind: DeleteCorsPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteCorsPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteCorsPolicyErrorKind {
    /// <p>The container that you specified in the request already exists or is being
    /// updated.</p>
    ContainerInUseException(crate::error::ContainerInUseException),
    /// <p>The container that you specified in the request does not exist.</p>
    ContainerNotFoundException(crate::error::ContainerNotFoundException),
    /// <p>The CORS policy that you specified in the request does not exist.</p>
    CorsPolicyNotFoundException(crate::error::CorsPolicyNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteCorsPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteCorsPolicyErrorKind::ContainerInUseException(_inner) => _inner.fmt(f),
            DeleteCorsPolicyErrorKind::ContainerNotFoundException(_inner) => _inner.fmt(f),
            DeleteCorsPolicyErrorKind::CorsPolicyNotFoundException(_inner) => _inner.fmt(f),
            DeleteCorsPolicyErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DeleteCorsPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteCorsPolicyError {
    fn code(&self) -> Option<&str> {
        DeleteCorsPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteCorsPolicyError {
    /// Creates a new `DeleteCorsPolicyError`.
    pub fn new(kind: DeleteCorsPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteCorsPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteCorsPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteCorsPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteCorsPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteCorsPolicyErrorKind::ContainerInUseException`.
    pub fn is_container_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCorsPolicyErrorKind::ContainerInUseException(_)
        )
    }
    /// Returns true if the error kind is `DeleteCorsPolicyErrorKind::ContainerNotFoundException`.
    pub fn is_container_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCorsPolicyErrorKind::ContainerNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteCorsPolicyErrorKind::CorsPolicyNotFoundException`.
    pub fn is_cors_policy_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCorsPolicyErrorKind::CorsPolicyNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteCorsPolicyErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCorsPolicyErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for DeleteCorsPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteCorsPolicyErrorKind::ContainerInUseException(_inner) => Some(_inner),
            DeleteCorsPolicyErrorKind::ContainerNotFoundException(_inner) => Some(_inner),
            DeleteCorsPolicyErrorKind::CorsPolicyNotFoundException(_inner) => Some(_inner),
            DeleteCorsPolicyErrorKind::InternalServerError(_inner) => Some(_inner),
            DeleteCorsPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteLifecyclePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteLifecyclePolicyError {
    /// Kind of error that occurred.
    pub kind: DeleteLifecyclePolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteLifecyclePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteLifecyclePolicyErrorKind {
    /// <p>The container that you specified in the request already exists or is being
    /// updated.</p>
    ContainerInUseException(crate::error::ContainerInUseException),
    /// <p>The container that you specified in the request does not exist.</p>
    ContainerNotFoundException(crate::error::ContainerNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The policy that you specified in the request does not exist.</p>
    PolicyNotFoundException(crate::error::PolicyNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteLifecyclePolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteLifecyclePolicyErrorKind::ContainerInUseException(_inner) => _inner.fmt(f),
            DeleteLifecyclePolicyErrorKind::ContainerNotFoundException(_inner) => _inner.fmt(f),
            DeleteLifecyclePolicyErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DeleteLifecyclePolicyErrorKind::PolicyNotFoundException(_inner) => _inner.fmt(f),
            DeleteLifecyclePolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteLifecyclePolicyError {
    fn code(&self) -> Option<&str> {
        DeleteLifecyclePolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteLifecyclePolicyError {
    /// Creates a new `DeleteLifecyclePolicyError`.
    pub fn new(kind: DeleteLifecyclePolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteLifecyclePolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteLifecyclePolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteLifecyclePolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteLifecyclePolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteLifecyclePolicyErrorKind::ContainerInUseException`.
    pub fn is_container_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLifecyclePolicyErrorKind::ContainerInUseException(_)
        )
    }
    /// Returns true if the error kind is `DeleteLifecyclePolicyErrorKind::ContainerNotFoundException`.
    pub fn is_container_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLifecyclePolicyErrorKind::ContainerNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteLifecyclePolicyErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLifecyclePolicyErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `DeleteLifecyclePolicyErrorKind::PolicyNotFoundException`.
    pub fn is_policy_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLifecyclePolicyErrorKind::PolicyNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteLifecyclePolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteLifecyclePolicyErrorKind::ContainerInUseException(_inner) => Some(_inner),
            DeleteLifecyclePolicyErrorKind::ContainerNotFoundException(_inner) => Some(_inner),
            DeleteLifecyclePolicyErrorKind::InternalServerError(_inner) => Some(_inner),
            DeleteLifecyclePolicyErrorKind::PolicyNotFoundException(_inner) => Some(_inner),
            DeleteLifecyclePolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteMetricPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteMetricPolicyError {
    /// Kind of error that occurred.
    pub kind: DeleteMetricPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteMetricPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteMetricPolicyErrorKind {
    /// <p>The container that you specified in the request already exists or is being
    /// updated.</p>
    ContainerInUseException(crate::error::ContainerInUseException),
    /// <p>The container that you specified in the request does not exist.</p>
    ContainerNotFoundException(crate::error::ContainerNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The policy that you specified in the request does not exist.</p>
    PolicyNotFoundException(crate::error::PolicyNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteMetricPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteMetricPolicyErrorKind::ContainerInUseException(_inner) => _inner.fmt(f),
            DeleteMetricPolicyErrorKind::ContainerNotFoundException(_inner) => _inner.fmt(f),
            DeleteMetricPolicyErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DeleteMetricPolicyErrorKind::PolicyNotFoundException(_inner) => _inner.fmt(f),
            DeleteMetricPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteMetricPolicyError {
    fn code(&self) -> Option<&str> {
        DeleteMetricPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteMetricPolicyError {
    /// Creates a new `DeleteMetricPolicyError`.
    pub fn new(kind: DeleteMetricPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteMetricPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteMetricPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteMetricPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteMetricPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteMetricPolicyErrorKind::ContainerInUseException`.
    pub fn is_container_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMetricPolicyErrorKind::ContainerInUseException(_)
        )
    }
    /// Returns true if the error kind is `DeleteMetricPolicyErrorKind::ContainerNotFoundException`.
    pub fn is_container_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMetricPolicyErrorKind::ContainerNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteMetricPolicyErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMetricPolicyErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `DeleteMetricPolicyErrorKind::PolicyNotFoundException`.
    pub fn is_policy_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMetricPolicyErrorKind::PolicyNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteMetricPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteMetricPolicyErrorKind::ContainerInUseException(_inner) => Some(_inner),
            DeleteMetricPolicyErrorKind::ContainerNotFoundException(_inner) => Some(_inner),
            DeleteMetricPolicyErrorKind::InternalServerError(_inner) => Some(_inner),
            DeleteMetricPolicyErrorKind::PolicyNotFoundException(_inner) => Some(_inner),
            DeleteMetricPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeContainer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeContainerError {
    /// Kind of error that occurred.
    pub kind: DescribeContainerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeContainer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeContainerErrorKind {
    /// <p>The container that you specified in the request does not exist.</p>
    ContainerNotFoundException(crate::error::ContainerNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeContainerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeContainerErrorKind::ContainerNotFoundException(_inner) => _inner.fmt(f),
            DescribeContainerErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeContainerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeContainerError {
    fn code(&self) -> Option<&str> {
        DescribeContainerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeContainerError {
    /// Creates a new `DescribeContainerError`.
    pub fn new(kind: DescribeContainerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeContainerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeContainerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeContainerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeContainerErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeContainerErrorKind::ContainerNotFoundException`.
    pub fn is_container_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeContainerErrorKind::ContainerNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DescribeContainerErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeContainerErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for DescribeContainerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeContainerErrorKind::ContainerNotFoundException(_inner) => Some(_inner),
            DescribeContainerErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeContainerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetContainerPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetContainerPolicyError {
    /// Kind of error that occurred.
    pub kind: GetContainerPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetContainerPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetContainerPolicyErrorKind {
    /// <p>The container that you specified in the request already exists or is being
    /// updated.</p>
    ContainerInUseException(crate::error::ContainerInUseException),
    /// <p>The container that you specified in the request does not exist.</p>
    ContainerNotFoundException(crate::error::ContainerNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The policy that you specified in the request does not exist.</p>
    PolicyNotFoundException(crate::error::PolicyNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetContainerPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetContainerPolicyErrorKind::ContainerInUseException(_inner) => _inner.fmt(f),
            GetContainerPolicyErrorKind::ContainerNotFoundException(_inner) => _inner.fmt(f),
            GetContainerPolicyErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            GetContainerPolicyErrorKind::PolicyNotFoundException(_inner) => _inner.fmt(f),
            GetContainerPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetContainerPolicyError {
    fn code(&self) -> Option<&str> {
        GetContainerPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetContainerPolicyError {
    /// Creates a new `GetContainerPolicyError`.
    pub fn new(kind: GetContainerPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetContainerPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetContainerPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetContainerPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetContainerPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetContainerPolicyErrorKind::ContainerInUseException`.
    pub fn is_container_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetContainerPolicyErrorKind::ContainerInUseException(_)
        )
    }
    /// Returns true if the error kind is `GetContainerPolicyErrorKind::ContainerNotFoundException`.
    pub fn is_container_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetContainerPolicyErrorKind::ContainerNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetContainerPolicyErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            GetContainerPolicyErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `GetContainerPolicyErrorKind::PolicyNotFoundException`.
    pub fn is_policy_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetContainerPolicyErrorKind::PolicyNotFoundException(_)
        )
    }
}
impl std::error::Error for GetContainerPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetContainerPolicyErrorKind::ContainerInUseException(_inner) => Some(_inner),
            GetContainerPolicyErrorKind::ContainerNotFoundException(_inner) => Some(_inner),
            GetContainerPolicyErrorKind::InternalServerError(_inner) => Some(_inner),
            GetContainerPolicyErrorKind::PolicyNotFoundException(_inner) => Some(_inner),
            GetContainerPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetCorsPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetCorsPolicyError {
    /// Kind of error that occurred.
    pub kind: GetCorsPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetCorsPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetCorsPolicyErrorKind {
    /// <p>The container that you specified in the request already exists or is being
    /// updated.</p>
    ContainerInUseException(crate::error::ContainerInUseException),
    /// <p>The container that you specified in the request does not exist.</p>
    ContainerNotFoundException(crate::error::ContainerNotFoundException),
    /// <p>The CORS policy that you specified in the request does not exist.</p>
    CorsPolicyNotFoundException(crate::error::CorsPolicyNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetCorsPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetCorsPolicyErrorKind::ContainerInUseException(_inner) => _inner.fmt(f),
            GetCorsPolicyErrorKind::ContainerNotFoundException(_inner) => _inner.fmt(f),
            GetCorsPolicyErrorKind::CorsPolicyNotFoundException(_inner) => _inner.fmt(f),
            GetCorsPolicyErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            GetCorsPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetCorsPolicyError {
    fn code(&self) -> Option<&str> {
        GetCorsPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetCorsPolicyError {
    /// Creates a new `GetCorsPolicyError`.
    pub fn new(kind: GetCorsPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetCorsPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetCorsPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetCorsPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetCorsPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetCorsPolicyErrorKind::ContainerInUseException`.
    pub fn is_container_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCorsPolicyErrorKind::ContainerInUseException(_)
        )
    }
    /// Returns true if the error kind is `GetCorsPolicyErrorKind::ContainerNotFoundException`.
    pub fn is_container_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCorsPolicyErrorKind::ContainerNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetCorsPolicyErrorKind::CorsPolicyNotFoundException`.
    pub fn is_cors_policy_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCorsPolicyErrorKind::CorsPolicyNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetCorsPolicyErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, GetCorsPolicyErrorKind::InternalServerError(_))
    }
}
impl std::error::Error for GetCorsPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetCorsPolicyErrorKind::ContainerInUseException(_inner) => Some(_inner),
            GetCorsPolicyErrorKind::ContainerNotFoundException(_inner) => Some(_inner),
            GetCorsPolicyErrorKind::CorsPolicyNotFoundException(_inner) => Some(_inner),
            GetCorsPolicyErrorKind::InternalServerError(_inner) => Some(_inner),
            GetCorsPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetLifecyclePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetLifecyclePolicyError {
    /// Kind of error that occurred.
    pub kind: GetLifecyclePolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetLifecyclePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetLifecyclePolicyErrorKind {
    /// <p>The container that you specified in the request already exists or is being
    /// updated.</p>
    ContainerInUseException(crate::error::ContainerInUseException),
    /// <p>The container that you specified in the request does not exist.</p>
    ContainerNotFoundException(crate::error::ContainerNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The policy that you specified in the request does not exist.</p>
    PolicyNotFoundException(crate::error::PolicyNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetLifecyclePolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetLifecyclePolicyErrorKind::ContainerInUseException(_inner) => _inner.fmt(f),
            GetLifecyclePolicyErrorKind::ContainerNotFoundException(_inner) => _inner.fmt(f),
            GetLifecyclePolicyErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            GetLifecyclePolicyErrorKind::PolicyNotFoundException(_inner) => _inner.fmt(f),
            GetLifecyclePolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetLifecyclePolicyError {
    fn code(&self) -> Option<&str> {
        GetLifecyclePolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetLifecyclePolicyError {
    /// Creates a new `GetLifecyclePolicyError`.
    pub fn new(kind: GetLifecyclePolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetLifecyclePolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetLifecyclePolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetLifecyclePolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetLifecyclePolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetLifecyclePolicyErrorKind::ContainerInUseException`.
    pub fn is_container_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLifecyclePolicyErrorKind::ContainerInUseException(_)
        )
    }
    /// Returns true if the error kind is `GetLifecyclePolicyErrorKind::ContainerNotFoundException`.
    pub fn is_container_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLifecyclePolicyErrorKind::ContainerNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetLifecyclePolicyErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            GetLifecyclePolicyErrorKind::InternalServerError(_)
        )
    }
    /// Returns true if the error kind is `GetLifecyclePolicyErrorKind::PolicyNotFoundException`.
    pub fn is_policy_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLifecyclePolicyErrorKind::PolicyNotFoundException(_)
        )
    }
}
impl std::error::Error for GetLifecyclePolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetLifecyclePolicyErrorKind::ContainerInUseException(_inner) => Some(_inner),
            GetLifecyclePolicyErrorKind::ContainerNotFoundException(_inner) => Some(_inner),
            GetLifecyclePolicyErrorKind::InternalServerError(_inner) => Some(_inner),
            GetLifecyclePolicyErrorKind::PolicyNotFoundException(_inner) => Some(_inner),
            GetLifecyclePolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetMetricPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetMetricPolicyError {
    /// Kind of error that occurred.
    pub kind: GetMetricPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetMetricPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetMetricPolicyErrorKind {
    /// <p>The container that you specified in the request already exists or is being
    /// updated.</p>
    ContainerInUseException(crate::error::ContainerInUseException),
    /// <p>The container that you specified in the request does not exist.</p>
    ContainerNotFoundException(crate::error::ContainerNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The policy that you specified in the request does not exist.</p>
    PolicyNotFoundException(crate::error::PolicyNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetMetricPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetMetricPolicyErrorKind::ContainerInUseException(_inner) => _inner.fmt(f),
            GetMetricPolicyErrorKind::ContainerNotFoundException(_inner) => _inner.fmt(f),
            GetMetricPolicyErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            GetMetricPolicyErrorKind::PolicyNotFoundException(_inner) => _inner.fmt(f),
            GetMetricPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetMetricPolicyError {
    fn code(&self) -> Option<&str> {
        GetMetricPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetMetricPolicyError {
    /// Creates a new `GetMetricPolicyError`.
    pub fn new(kind: GetMetricPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetMetricPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetMetricPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetMetricPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetMetricPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetMetricPolicyErrorKind::ContainerInUseException`.
    pub fn is_container_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMetricPolicyErrorKind::ContainerInUseException(_)
        )
    }
    /// Returns true if the error kind is `GetMetricPolicyErrorKind::ContainerNotFoundException`.
    pub fn is_container_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMetricPolicyErrorKind::ContainerNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetMetricPolicyErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, GetMetricPolicyErrorKind::InternalServerError(_))
    }
    /// Returns true if the error kind is `GetMetricPolicyErrorKind::PolicyNotFoundException`.
    pub fn is_policy_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMetricPolicyErrorKind::PolicyNotFoundException(_)
        )
    }
}
impl std::error::Error for GetMetricPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetMetricPolicyErrorKind::ContainerInUseException(_inner) => Some(_inner),
            GetMetricPolicyErrorKind::ContainerNotFoundException(_inner) => Some(_inner),
            GetMetricPolicyErrorKind::InternalServerError(_inner) => Some(_inner),
            GetMetricPolicyErrorKind::PolicyNotFoundException(_inner) => Some(_inner),
            GetMetricPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListContainers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListContainersError {
    /// Kind of error that occurred.
    pub kind: ListContainersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListContainers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListContainersErrorKind {
    /// <p>The service is temporarily unavailable.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListContainersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListContainersErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            ListContainersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListContainersError {
    fn code(&self) -> Option<&str> {
        ListContainersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListContainersError {
    /// Creates a new `ListContainersError`.
    pub fn new(kind: ListContainersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListContainersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListContainersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListContainersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListContainersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListContainersErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, ListContainersErrorKind::InternalServerError(_))
    }
}
impl std::error::Error for ListContainersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListContainersErrorKind::InternalServerError(_inner) => Some(_inner),
            ListContainersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>The container that you specified in the request already exists or is being
    /// updated.</p>
    ContainerInUseException(crate::error::ContainerInUseException),
    /// <p>The container that you specified in the request does not exist.</p>
    ContainerNotFoundException(crate::error::ContainerNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::ContainerInUseException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ContainerNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::ContainerInUseException`.
    pub fn is_container_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ContainerInUseException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::ContainerNotFoundException`.
    pub fn is_container_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ContainerNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::ContainerInUseException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ContainerNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InternalServerError(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutContainerPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutContainerPolicyError {
    /// Kind of error that occurred.
    pub kind: PutContainerPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutContainerPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutContainerPolicyErrorKind {
    /// <p>The container that you specified in the request already exists or is being
    /// updated.</p>
    ContainerInUseException(crate::error::ContainerInUseException),
    /// <p>The container that you specified in the request does not exist.</p>
    ContainerNotFoundException(crate::error::ContainerNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutContainerPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutContainerPolicyErrorKind::ContainerInUseException(_inner) => _inner.fmt(f),
            PutContainerPolicyErrorKind::ContainerNotFoundException(_inner) => _inner.fmt(f),
            PutContainerPolicyErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            PutContainerPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutContainerPolicyError {
    fn code(&self) -> Option<&str> {
        PutContainerPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutContainerPolicyError {
    /// Creates a new `PutContainerPolicyError`.
    pub fn new(kind: PutContainerPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutContainerPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutContainerPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutContainerPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutContainerPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `PutContainerPolicyErrorKind::ContainerInUseException`.
    pub fn is_container_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutContainerPolicyErrorKind::ContainerInUseException(_)
        )
    }
    /// Returns true if the error kind is `PutContainerPolicyErrorKind::ContainerNotFoundException`.
    pub fn is_container_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutContainerPolicyErrorKind::ContainerNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `PutContainerPolicyErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            PutContainerPolicyErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for PutContainerPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutContainerPolicyErrorKind::ContainerInUseException(_inner) => Some(_inner),
            PutContainerPolicyErrorKind::ContainerNotFoundException(_inner) => Some(_inner),
            PutContainerPolicyErrorKind::InternalServerError(_inner) => Some(_inner),
            PutContainerPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutCorsPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutCorsPolicyError {
    /// Kind of error that occurred.
    pub kind: PutCorsPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutCorsPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutCorsPolicyErrorKind {
    /// <p>The container that you specified in the request already exists or is being
    /// updated.</p>
    ContainerInUseException(crate::error::ContainerInUseException),
    /// <p>The container that you specified in the request does not exist.</p>
    ContainerNotFoundException(crate::error::ContainerNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutCorsPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutCorsPolicyErrorKind::ContainerInUseException(_inner) => _inner.fmt(f),
            PutCorsPolicyErrorKind::ContainerNotFoundException(_inner) => _inner.fmt(f),
            PutCorsPolicyErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            PutCorsPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutCorsPolicyError {
    fn code(&self) -> Option<&str> {
        PutCorsPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutCorsPolicyError {
    /// Creates a new `PutCorsPolicyError`.
    pub fn new(kind: PutCorsPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutCorsPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutCorsPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutCorsPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutCorsPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `PutCorsPolicyErrorKind::ContainerInUseException`.
    pub fn is_container_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutCorsPolicyErrorKind::ContainerInUseException(_)
        )
    }
    /// Returns true if the error kind is `PutCorsPolicyErrorKind::ContainerNotFoundException`.
    pub fn is_container_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutCorsPolicyErrorKind::ContainerNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `PutCorsPolicyErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, PutCorsPolicyErrorKind::InternalServerError(_))
    }
}
impl std::error::Error for PutCorsPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutCorsPolicyErrorKind::ContainerInUseException(_inner) => Some(_inner),
            PutCorsPolicyErrorKind::ContainerNotFoundException(_inner) => Some(_inner),
            PutCorsPolicyErrorKind::InternalServerError(_inner) => Some(_inner),
            PutCorsPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutLifecyclePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutLifecyclePolicyError {
    /// Kind of error that occurred.
    pub kind: PutLifecyclePolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutLifecyclePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutLifecyclePolicyErrorKind {
    /// <p>The container that you specified in the request already exists or is being
    /// updated.</p>
    ContainerInUseException(crate::error::ContainerInUseException),
    /// <p>The container that you specified in the request does not exist.</p>
    ContainerNotFoundException(crate::error::ContainerNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutLifecyclePolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutLifecyclePolicyErrorKind::ContainerInUseException(_inner) => _inner.fmt(f),
            PutLifecyclePolicyErrorKind::ContainerNotFoundException(_inner) => _inner.fmt(f),
            PutLifecyclePolicyErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            PutLifecyclePolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutLifecyclePolicyError {
    fn code(&self) -> Option<&str> {
        PutLifecyclePolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutLifecyclePolicyError {
    /// Creates a new `PutLifecyclePolicyError`.
    pub fn new(kind: PutLifecyclePolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutLifecyclePolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutLifecyclePolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutLifecyclePolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutLifecyclePolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `PutLifecyclePolicyErrorKind::ContainerInUseException`.
    pub fn is_container_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutLifecyclePolicyErrorKind::ContainerInUseException(_)
        )
    }
    /// Returns true if the error kind is `PutLifecyclePolicyErrorKind::ContainerNotFoundException`.
    pub fn is_container_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutLifecyclePolicyErrorKind::ContainerNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `PutLifecyclePolicyErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            PutLifecyclePolicyErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for PutLifecyclePolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutLifecyclePolicyErrorKind::ContainerInUseException(_inner) => Some(_inner),
            PutLifecyclePolicyErrorKind::ContainerNotFoundException(_inner) => Some(_inner),
            PutLifecyclePolicyErrorKind::InternalServerError(_inner) => Some(_inner),
            PutLifecyclePolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutMetricPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutMetricPolicyError {
    /// Kind of error that occurred.
    pub kind: PutMetricPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutMetricPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutMetricPolicyErrorKind {
    /// <p>The container that you specified in the request already exists or is being
    /// updated.</p>
    ContainerInUseException(crate::error::ContainerInUseException),
    /// <p>The container that you specified in the request does not exist.</p>
    ContainerNotFoundException(crate::error::ContainerNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutMetricPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutMetricPolicyErrorKind::ContainerInUseException(_inner) => _inner.fmt(f),
            PutMetricPolicyErrorKind::ContainerNotFoundException(_inner) => _inner.fmt(f),
            PutMetricPolicyErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            PutMetricPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutMetricPolicyError {
    fn code(&self) -> Option<&str> {
        PutMetricPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutMetricPolicyError {
    /// Creates a new `PutMetricPolicyError`.
    pub fn new(kind: PutMetricPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutMetricPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutMetricPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutMetricPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutMetricPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `PutMetricPolicyErrorKind::ContainerInUseException`.
    pub fn is_container_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutMetricPolicyErrorKind::ContainerInUseException(_)
        )
    }
    /// Returns true if the error kind is `PutMetricPolicyErrorKind::ContainerNotFoundException`.
    pub fn is_container_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutMetricPolicyErrorKind::ContainerNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `PutMetricPolicyErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, PutMetricPolicyErrorKind::InternalServerError(_))
    }
}
impl std::error::Error for PutMetricPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutMetricPolicyErrorKind::ContainerInUseException(_inner) => Some(_inner),
            PutMetricPolicyErrorKind::ContainerNotFoundException(_inner) => Some(_inner),
            PutMetricPolicyErrorKind::InternalServerError(_inner) => Some(_inner),
            PutMetricPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartAccessLogging` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartAccessLoggingError {
    /// Kind of error that occurred.
    pub kind: StartAccessLoggingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartAccessLogging` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartAccessLoggingErrorKind {
    /// <p>The container that you specified in the request already exists or is being
    /// updated.</p>
    ContainerInUseException(crate::error::ContainerInUseException),
    /// <p>The container that you specified in the request does not exist.</p>
    ContainerNotFoundException(crate::error::ContainerNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartAccessLoggingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartAccessLoggingErrorKind::ContainerInUseException(_inner) => _inner.fmt(f),
            StartAccessLoggingErrorKind::ContainerNotFoundException(_inner) => _inner.fmt(f),
            StartAccessLoggingErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            StartAccessLoggingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartAccessLoggingError {
    fn code(&self) -> Option<&str> {
        StartAccessLoggingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartAccessLoggingError {
    /// Creates a new `StartAccessLoggingError`.
    pub fn new(kind: StartAccessLoggingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartAccessLoggingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartAccessLoggingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartAccessLoggingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartAccessLoggingErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `StartAccessLoggingErrorKind::ContainerInUseException`.
    pub fn is_container_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartAccessLoggingErrorKind::ContainerInUseException(_)
        )
    }
    /// Returns true if the error kind is `StartAccessLoggingErrorKind::ContainerNotFoundException`.
    pub fn is_container_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartAccessLoggingErrorKind::ContainerNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `StartAccessLoggingErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            StartAccessLoggingErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for StartAccessLoggingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartAccessLoggingErrorKind::ContainerInUseException(_inner) => Some(_inner),
            StartAccessLoggingErrorKind::ContainerNotFoundException(_inner) => Some(_inner),
            StartAccessLoggingErrorKind::InternalServerError(_inner) => Some(_inner),
            StartAccessLoggingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopAccessLogging` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopAccessLoggingError {
    /// Kind of error that occurred.
    pub kind: StopAccessLoggingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopAccessLogging` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopAccessLoggingErrorKind {
    /// <p>The container that you specified in the request already exists or is being
    /// updated.</p>
    ContainerInUseException(crate::error::ContainerInUseException),
    /// <p>The container that you specified in the request does not exist.</p>
    ContainerNotFoundException(crate::error::ContainerNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopAccessLoggingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopAccessLoggingErrorKind::ContainerInUseException(_inner) => _inner.fmt(f),
            StopAccessLoggingErrorKind::ContainerNotFoundException(_inner) => _inner.fmt(f),
            StopAccessLoggingErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            StopAccessLoggingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopAccessLoggingError {
    fn code(&self) -> Option<&str> {
        StopAccessLoggingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopAccessLoggingError {
    /// Creates a new `StopAccessLoggingError`.
    pub fn new(kind: StopAccessLoggingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopAccessLoggingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopAccessLoggingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopAccessLoggingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopAccessLoggingErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `StopAccessLoggingErrorKind::ContainerInUseException`.
    pub fn is_container_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopAccessLoggingErrorKind::ContainerInUseException(_)
        )
    }
    /// Returns true if the error kind is `StopAccessLoggingErrorKind::ContainerNotFoundException`.
    pub fn is_container_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopAccessLoggingErrorKind::ContainerNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `StopAccessLoggingErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            StopAccessLoggingErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for StopAccessLoggingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopAccessLoggingErrorKind::ContainerInUseException(_inner) => Some(_inner),
            StopAccessLoggingErrorKind::ContainerNotFoundException(_inner) => Some(_inner),
            StopAccessLoggingErrorKind::InternalServerError(_inner) => Some(_inner),
            StopAccessLoggingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>The container that you specified in the request already exists or is being
    /// updated.</p>
    ContainerInUseException(crate::error::ContainerInUseException),
    /// <p>The container that you specified in the request does not exist.</p>
    ContainerNotFoundException(crate::error::ContainerNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::ContainerInUseException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ContainerNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `TagResourceErrorKind::ContainerInUseException`.
    pub fn is_container_in_use_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ContainerInUseException(_))
    }
    /// Returns true if the error kind is `TagResourceErrorKind::ContainerNotFoundException`.
    pub fn is_container_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ContainerNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `TagResourceErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InternalServerError(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::ContainerInUseException(_inner) => Some(_inner),
            TagResourceErrorKind::ContainerNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::InternalServerError(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>The container that you specified in the request already exists or is being
    /// updated.</p>
    ContainerInUseException(crate::error::ContainerInUseException),
    /// <p>The container that you specified in the request does not exist.</p>
    ContainerNotFoundException(crate::error::ContainerNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::ContainerInUseException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ContainerNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::ContainerInUseException`.
    pub fn is_container_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ContainerInUseException(_)
        )
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::ContainerNotFoundException`.
    pub fn is_container_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ContainerNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::InternalServerError(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::ContainerInUseException(_inner) => Some(_inner),
            UntagResourceErrorKind::ContainerNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::InternalServerError(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The service is temporarily unavailable.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerError {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerError");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServerError {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerError")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerError {}
/// See [`InternalServerError`](crate::error::InternalServerError)
pub mod internal_server_error {
    /// A builder for [`InternalServerError`](crate::error::InternalServerError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerError`](crate::error::InternalServerError)
        pub fn build(self) -> crate::error::InternalServerError {
            crate::error::InternalServerError {
                message: self.message,
            }
        }
    }
}
impl InternalServerError {
    /// Creates a new builder-style object to manufacture [`InternalServerError`](crate::error::InternalServerError)
    pub fn builder() -> crate::error::internal_server_error::Builder {
        crate::error::internal_server_error::Builder::default()
    }
}

/// <p>The container that you specified in the request does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ContainerNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ContainerNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ContainerNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ContainerNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ContainerNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ContainerNotFoundException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ContainerNotFoundException {}
/// See [`ContainerNotFoundException`](crate::error::ContainerNotFoundException)
pub mod container_not_found_exception {
    /// A builder for [`ContainerNotFoundException`](crate::error::ContainerNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ContainerNotFoundException`](crate::error::ContainerNotFoundException)
        pub fn build(self) -> crate::error::ContainerNotFoundException {
            crate::error::ContainerNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ContainerNotFoundException {
    /// Creates a new builder-style object to manufacture [`ContainerNotFoundException`](crate::error::ContainerNotFoundException)
    pub fn builder() -> crate::error::container_not_found_exception::Builder {
        crate::error::container_not_found_exception::Builder::default()
    }
}

/// <p>The container that you specified in the request already exists or is being
/// updated.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ContainerInUseException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ContainerInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ContainerInUseException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ContainerInUseException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ContainerInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ContainerInUseException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ContainerInUseException {}
/// See [`ContainerInUseException`](crate::error::ContainerInUseException)
pub mod container_in_use_exception {
    /// A builder for [`ContainerInUseException`](crate::error::ContainerInUseException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ContainerInUseException`](crate::error::ContainerInUseException)
        pub fn build(self) -> crate::error::ContainerInUseException {
            crate::error::ContainerInUseException {
                message: self.message,
            }
        }
    }
}
impl ContainerInUseException {
    /// Creates a new builder-style object to manufacture [`ContainerInUseException`](crate::error::ContainerInUseException)
    pub fn builder() -> crate::error::container_in_use_exception::Builder {
        crate::error::container_in_use_exception::Builder::default()
    }
}

/// <p>The policy that you specified in the request does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PolicyNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PolicyNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PolicyNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl PolicyNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for PolicyNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "PolicyNotFoundException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for PolicyNotFoundException {}
/// See [`PolicyNotFoundException`](crate::error::PolicyNotFoundException)
pub mod policy_not_found_exception {
    /// A builder for [`PolicyNotFoundException`](crate::error::PolicyNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`PolicyNotFoundException`](crate::error::PolicyNotFoundException)
        pub fn build(self) -> crate::error::PolicyNotFoundException {
            crate::error::PolicyNotFoundException {
                message: self.message,
            }
        }
    }
}
impl PolicyNotFoundException {
    /// Creates a new builder-style object to manufacture [`PolicyNotFoundException`](crate::error::PolicyNotFoundException)
    pub fn builder() -> crate::error::policy_not_found_exception::Builder {
        crate::error::policy_not_found_exception::Builder::default()
    }
}

/// <p>The CORS policy that you specified in the request does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CorsPolicyNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CorsPolicyNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CorsPolicyNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl CorsPolicyNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for CorsPolicyNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "CorsPolicyNotFoundException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for CorsPolicyNotFoundException {}
/// See [`CorsPolicyNotFoundException`](crate::error::CorsPolicyNotFoundException)
pub mod cors_policy_not_found_exception {
    /// A builder for [`CorsPolicyNotFoundException`](crate::error::CorsPolicyNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`CorsPolicyNotFoundException`](crate::error::CorsPolicyNotFoundException)
        pub fn build(self) -> crate::error::CorsPolicyNotFoundException {
            crate::error::CorsPolicyNotFoundException {
                message: self.message,
            }
        }
    }
}
impl CorsPolicyNotFoundException {
    /// Creates a new builder-style object to manufacture [`CorsPolicyNotFoundException`](crate::error::CorsPolicyNotFoundException)
    pub fn builder() -> crate::error::cors_policy_not_found_exception::Builder {
        crate::error::cors_policy_not_found_exception::Builder::default()
    }
}

/// <p>A service limit has been exceeded.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededException {}
/// See [`LimitExceededException`](crate::error::LimitExceededException)
pub mod limit_exceeded_exception {
    /// A builder for [`LimitExceededException`](crate::error::LimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededException`](crate::error::LimitExceededException)
        pub fn build(self) -> crate::error::LimitExceededException {
            crate::error::LimitExceededException {
                message: self.message,
            }
        }
    }
}
impl LimitExceededException {
    /// Creates a new builder-style object to manufacture [`LimitExceededException`](crate::error::LimitExceededException)
    pub fn builder() -> crate::error::limit_exceeded_exception::Builder {
        crate::error::limit_exceeded_exception::Builder::default()
    }
}
