// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for AWS Elemental MediaPackage VOD
///
/// Client for invoking operations on AWS Elemental MediaPackage VOD. Each operation on AWS Elemental MediaPackage VOD is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_mediapackagevod::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
/// let shared_config = aws_config::load_from_env().await;
/// let config = aws_sdk_mediapackagevod::config::Builder::from(&shared_config)
///   .retry_config(RetryConfig::disabled())
///   .build();
/// let client = aws_sdk_mediapackagevod::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`ConfigureLogs`](crate::client::fluent_builders::ConfigureLogs) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`egress_access_logs(EgressAccessLogs)`](crate::client::fluent_builders::ConfigureLogs::egress_access_logs) / [`set_egress_access_logs(Option<EgressAccessLogs>)`](crate::client::fluent_builders::ConfigureLogs::set_egress_access_logs): Configure egress access logging.
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::ConfigureLogs::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::ConfigureLogs::set_id): The ID of a MediaPackage VOD PackagingGroup resource.
    /// - On success, responds with [`ConfigureLogsOutput`](crate::output::ConfigureLogsOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::ConfigureLogsOutput::arn): The ARN of the PackagingGroup.
    ///   - [`authorization(Option<Authorization>)`](crate::output::ConfigureLogsOutput::authorization): CDN Authorization credentials
    ///   - [`domain_name(Option<String>)`](crate::output::ConfigureLogsOutput::domain_name): The fully qualified domain name for Assets in the PackagingGroup.
    ///   - [`egress_access_logs(Option<EgressAccessLogs>)`](crate::output::ConfigureLogsOutput::egress_access_logs): Configure egress access logging.
    ///   - [`id(Option<String>)`](crate::output::ConfigureLogsOutput::id): The ID of the PackagingGroup.
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ConfigureLogsOutput::tags): A collection of tags associated with a resource
    /// - On failure, responds with [`SdkError<ConfigureLogsError>`](crate::error::ConfigureLogsError)
    pub fn configure_logs(&self) -> fluent_builders::ConfigureLogs {
        fluent_builders::ConfigureLogs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateAsset`](crate::client::fluent_builders::CreateAsset) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::CreateAsset::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::CreateAsset::set_id): The unique identifier for the Asset.
    ///   - [`packaging_group_id(impl Into<String>)`](crate::client::fluent_builders::CreateAsset::packaging_group_id) / [`set_packaging_group_id(Option<String>)`](crate::client::fluent_builders::CreateAsset::set_packaging_group_id): The ID of the PackagingGroup for the Asset.
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::CreateAsset::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::CreateAsset::set_resource_id): The resource ID to include in SPEKE key requests.
    ///   - [`source_arn(impl Into<String>)`](crate::client::fluent_builders::CreateAsset::source_arn) / [`set_source_arn(Option<String>)`](crate::client::fluent_builders::CreateAsset::set_source_arn): ARN of the source object in S3.
    ///   - [`source_role_arn(impl Into<String>)`](crate::client::fluent_builders::CreateAsset::source_role_arn) / [`set_source_role_arn(Option<String>)`](crate::client::fluent_builders::CreateAsset::set_source_role_arn): The IAM role ARN used to access the source S3 bucket.
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateAsset::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateAsset::set_tags): A collection of tags associated with a resource
    /// - On success, responds with [`CreateAssetOutput`](crate::output::CreateAssetOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::CreateAssetOutput::arn): The ARN of the Asset.
    ///   - [`created_at(Option<String>)`](crate::output::CreateAssetOutput::created_at): The time the Asset was initially submitted for Ingest.
    ///   - [`egress_endpoints(Option<Vec<EgressEndpoint>>)`](crate::output::CreateAssetOutput::egress_endpoints): The list of egress endpoints available for the Asset.
    ///   - [`id(Option<String>)`](crate::output::CreateAssetOutput::id): The unique identifier for the Asset.
    ///   - [`packaging_group_id(Option<String>)`](crate::output::CreateAssetOutput::packaging_group_id): The ID of the PackagingGroup for the Asset.
    ///   - [`resource_id(Option<String>)`](crate::output::CreateAssetOutput::resource_id): The resource ID to include in SPEKE key requests.
    ///   - [`source_arn(Option<String>)`](crate::output::CreateAssetOutput::source_arn): ARN of the source object in S3.
    ///   - [`source_role_arn(Option<String>)`](crate::output::CreateAssetOutput::source_role_arn): The IAM role_arn used to access the source S3 bucket.
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::CreateAssetOutput::tags): A collection of tags associated with a resource
    /// - On failure, responds with [`SdkError<CreateAssetError>`](crate::error::CreateAssetError)
    pub fn create_asset(&self) -> fluent_builders::CreateAsset {
        fluent_builders::CreateAsset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreatePackagingConfiguration`](crate::client::fluent_builders::CreatePackagingConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cmaf_package(CmafPackage)`](crate::client::fluent_builders::CreatePackagingConfiguration::cmaf_package) / [`set_cmaf_package(Option<CmafPackage>)`](crate::client::fluent_builders::CreatePackagingConfiguration::set_cmaf_package): A CMAF packaging configuration.
    ///   - [`dash_package(DashPackage)`](crate::client::fluent_builders::CreatePackagingConfiguration::dash_package) / [`set_dash_package(Option<DashPackage>)`](crate::client::fluent_builders::CreatePackagingConfiguration::set_dash_package): A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
    ///   - [`hls_package(HlsPackage)`](crate::client::fluent_builders::CreatePackagingConfiguration::hls_package) / [`set_hls_package(Option<HlsPackage>)`](crate::client::fluent_builders::CreatePackagingConfiguration::set_hls_package): An HTTP Live Streaming (HLS) packaging configuration.
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::CreatePackagingConfiguration::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::CreatePackagingConfiguration::set_id): The ID of the PackagingConfiguration.
    ///   - [`mss_package(MssPackage)`](crate::client::fluent_builders::CreatePackagingConfiguration::mss_package) / [`set_mss_package(Option<MssPackage>)`](crate::client::fluent_builders::CreatePackagingConfiguration::set_mss_package): A Microsoft Smooth Streaming (MSS) PackagingConfiguration.
    ///   - [`packaging_group_id(impl Into<String>)`](crate::client::fluent_builders::CreatePackagingConfiguration::packaging_group_id) / [`set_packaging_group_id(Option<String>)`](crate::client::fluent_builders::CreatePackagingConfiguration::set_packaging_group_id): The ID of a PackagingGroup.
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreatePackagingConfiguration::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreatePackagingConfiguration::set_tags): A collection of tags associated with a resource
    /// - On success, responds with [`CreatePackagingConfigurationOutput`](crate::output::CreatePackagingConfigurationOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::CreatePackagingConfigurationOutput::arn): The ARN of the PackagingConfiguration.
    ///   - [`cmaf_package(Option<CmafPackage>)`](crate::output::CreatePackagingConfigurationOutput::cmaf_package): A CMAF packaging configuration.
    ///   - [`dash_package(Option<DashPackage>)`](crate::output::CreatePackagingConfigurationOutput::dash_package): A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
    ///   - [`hls_package(Option<HlsPackage>)`](crate::output::CreatePackagingConfigurationOutput::hls_package): An HTTP Live Streaming (HLS) packaging configuration.
    ///   - [`id(Option<String>)`](crate::output::CreatePackagingConfigurationOutput::id): The ID of the PackagingConfiguration.
    ///   - [`mss_package(Option<MssPackage>)`](crate::output::CreatePackagingConfigurationOutput::mss_package): A Microsoft Smooth Streaming (MSS) PackagingConfiguration.
    ///   - [`packaging_group_id(Option<String>)`](crate::output::CreatePackagingConfigurationOutput::packaging_group_id): The ID of a PackagingGroup.
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::CreatePackagingConfigurationOutput::tags): A collection of tags associated with a resource
    /// - On failure, responds with [`SdkError<CreatePackagingConfigurationError>`](crate::error::CreatePackagingConfigurationError)
    pub fn create_packaging_configuration(&self) -> fluent_builders::CreatePackagingConfiguration {
        fluent_builders::CreatePackagingConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreatePackagingGroup`](crate::client::fluent_builders::CreatePackagingGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`authorization(Authorization)`](crate::client::fluent_builders::CreatePackagingGroup::authorization) / [`set_authorization(Option<Authorization>)`](crate::client::fluent_builders::CreatePackagingGroup::set_authorization): CDN Authorization credentials
    ///   - [`egress_access_logs(EgressAccessLogs)`](crate::client::fluent_builders::CreatePackagingGroup::egress_access_logs) / [`set_egress_access_logs(Option<EgressAccessLogs>)`](crate::client::fluent_builders::CreatePackagingGroup::set_egress_access_logs): Configure egress access logging.
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::CreatePackagingGroup::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::CreatePackagingGroup::set_id): The ID of the PackagingGroup.
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreatePackagingGroup::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreatePackagingGroup::set_tags): A collection of tags associated with a resource
    /// - On success, responds with [`CreatePackagingGroupOutput`](crate::output::CreatePackagingGroupOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::CreatePackagingGroupOutput::arn): The ARN of the PackagingGroup.
    ///   - [`authorization(Option<Authorization>)`](crate::output::CreatePackagingGroupOutput::authorization): CDN Authorization credentials
    ///   - [`domain_name(Option<String>)`](crate::output::CreatePackagingGroupOutput::domain_name): The fully qualified domain name for Assets in the PackagingGroup.
    ///   - [`egress_access_logs(Option<EgressAccessLogs>)`](crate::output::CreatePackagingGroupOutput::egress_access_logs): Configure egress access logging.
    ///   - [`id(Option<String>)`](crate::output::CreatePackagingGroupOutput::id): The ID of the PackagingGroup.
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::CreatePackagingGroupOutput::tags): A collection of tags associated with a resource
    /// - On failure, responds with [`SdkError<CreatePackagingGroupError>`](crate::error::CreatePackagingGroupError)
    pub fn create_packaging_group(&self) -> fluent_builders::CreatePackagingGroup {
        fluent_builders::CreatePackagingGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteAsset`](crate::client::fluent_builders::DeleteAsset) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeleteAsset::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeleteAsset::set_id): The ID of the MediaPackage VOD Asset resource to delete.
    /// - On success, responds with [`DeleteAssetOutput`](crate::output::DeleteAssetOutput)

    /// - On failure, responds with [`SdkError<DeleteAssetError>`](crate::error::DeleteAssetError)
    pub fn delete_asset(&self) -> fluent_builders::DeleteAsset {
        fluent_builders::DeleteAsset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeletePackagingConfiguration`](crate::client::fluent_builders::DeletePackagingConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeletePackagingConfiguration::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeletePackagingConfiguration::set_id): The ID of the MediaPackage VOD PackagingConfiguration resource to delete.
    /// - On success, responds with [`DeletePackagingConfigurationOutput`](crate::output::DeletePackagingConfigurationOutput)

    /// - On failure, responds with [`SdkError<DeletePackagingConfigurationError>`](crate::error::DeletePackagingConfigurationError)
    pub fn delete_packaging_configuration(&self) -> fluent_builders::DeletePackagingConfiguration {
        fluent_builders::DeletePackagingConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeletePackagingGroup`](crate::client::fluent_builders::DeletePackagingGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeletePackagingGroup::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeletePackagingGroup::set_id): The ID of the MediaPackage VOD PackagingGroup resource to delete.
    /// - On success, responds with [`DeletePackagingGroupOutput`](crate::output::DeletePackagingGroupOutput)

    /// - On failure, responds with [`SdkError<DeletePackagingGroupError>`](crate::error::DeletePackagingGroupError)
    pub fn delete_packaging_group(&self) -> fluent_builders::DeletePackagingGroup {
        fluent_builders::DeletePackagingGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAsset`](crate::client::fluent_builders::DescribeAsset) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DescribeAsset::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DescribeAsset::set_id): The ID of an MediaPackage VOD Asset resource.
    /// - On success, responds with [`DescribeAssetOutput`](crate::output::DescribeAssetOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::DescribeAssetOutput::arn): The ARN of the Asset.
    ///   - [`created_at(Option<String>)`](crate::output::DescribeAssetOutput::created_at): The time the Asset was initially submitted for Ingest.
    ///   - [`egress_endpoints(Option<Vec<EgressEndpoint>>)`](crate::output::DescribeAssetOutput::egress_endpoints): The list of egress endpoints available for the Asset.
    ///   - [`id(Option<String>)`](crate::output::DescribeAssetOutput::id): The unique identifier for the Asset.
    ///   - [`packaging_group_id(Option<String>)`](crate::output::DescribeAssetOutput::packaging_group_id): The ID of the PackagingGroup for the Asset.
    ///   - [`resource_id(Option<String>)`](crate::output::DescribeAssetOutput::resource_id): The resource ID to include in SPEKE key requests.
    ///   - [`source_arn(Option<String>)`](crate::output::DescribeAssetOutput::source_arn): ARN of the source object in S3.
    ///   - [`source_role_arn(Option<String>)`](crate::output::DescribeAssetOutput::source_role_arn): The IAM role_arn used to access the source S3 bucket.
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::DescribeAssetOutput::tags): A collection of tags associated with a resource
    /// - On failure, responds with [`SdkError<DescribeAssetError>`](crate::error::DescribeAssetError)
    pub fn describe_asset(&self) -> fluent_builders::DescribeAsset {
        fluent_builders::DescribeAsset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribePackagingConfiguration`](crate::client::fluent_builders::DescribePackagingConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DescribePackagingConfiguration::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DescribePackagingConfiguration::set_id): The ID of a MediaPackage VOD PackagingConfiguration resource.
    /// - On success, responds with [`DescribePackagingConfigurationOutput`](crate::output::DescribePackagingConfigurationOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::DescribePackagingConfigurationOutput::arn): The ARN of the PackagingConfiguration.
    ///   - [`cmaf_package(Option<CmafPackage>)`](crate::output::DescribePackagingConfigurationOutput::cmaf_package): A CMAF packaging configuration.
    ///   - [`dash_package(Option<DashPackage>)`](crate::output::DescribePackagingConfigurationOutput::dash_package): A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
    ///   - [`hls_package(Option<HlsPackage>)`](crate::output::DescribePackagingConfigurationOutput::hls_package): An HTTP Live Streaming (HLS) packaging configuration.
    ///   - [`id(Option<String>)`](crate::output::DescribePackagingConfigurationOutput::id): The ID of the PackagingConfiguration.
    ///   - [`mss_package(Option<MssPackage>)`](crate::output::DescribePackagingConfigurationOutput::mss_package): A Microsoft Smooth Streaming (MSS) PackagingConfiguration.
    ///   - [`packaging_group_id(Option<String>)`](crate::output::DescribePackagingConfigurationOutput::packaging_group_id): The ID of a PackagingGroup.
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::DescribePackagingConfigurationOutput::tags): A collection of tags associated with a resource
    /// - On failure, responds with [`SdkError<DescribePackagingConfigurationError>`](crate::error::DescribePackagingConfigurationError)
    pub fn describe_packaging_configuration(
        &self,
    ) -> fluent_builders::DescribePackagingConfiguration {
        fluent_builders::DescribePackagingConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribePackagingGroup`](crate::client::fluent_builders::DescribePackagingGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DescribePackagingGroup::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DescribePackagingGroup::set_id): The ID of a MediaPackage VOD PackagingGroup resource.
    /// - On success, responds with [`DescribePackagingGroupOutput`](crate::output::DescribePackagingGroupOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::DescribePackagingGroupOutput::arn): The ARN of the PackagingGroup.
    ///   - [`authorization(Option<Authorization>)`](crate::output::DescribePackagingGroupOutput::authorization): CDN Authorization credentials
    ///   - [`domain_name(Option<String>)`](crate::output::DescribePackagingGroupOutput::domain_name): The fully qualified domain name for Assets in the PackagingGroup.
    ///   - [`egress_access_logs(Option<EgressAccessLogs>)`](crate::output::DescribePackagingGroupOutput::egress_access_logs): Configure egress access logging.
    ///   - [`id(Option<String>)`](crate::output::DescribePackagingGroupOutput::id): The ID of the PackagingGroup.
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::DescribePackagingGroupOutput::tags): A collection of tags associated with a resource
    /// - On failure, responds with [`SdkError<DescribePackagingGroupError>`](crate::error::DescribePackagingGroupError)
    pub fn describe_packaging_group(&self) -> fluent_builders::DescribePackagingGroup {
        fluent_builders::DescribePackagingGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAssets`](crate::client::fluent_builders::ListAssets) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAssets::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAssets::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListAssets::set_max_results): Upper bound on number of records to return.
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAssets::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAssets::set_next_token): A token used to resume pagination from the end of a previous request.
    ///   - [`packaging_group_id(impl Into<String>)`](crate::client::fluent_builders::ListAssets::packaging_group_id) / [`set_packaging_group_id(Option<String>)`](crate::client::fluent_builders::ListAssets::set_packaging_group_id): Returns Assets associated with the specified PackagingGroup.
    /// - On success, responds with [`ListAssetsOutput`](crate::output::ListAssetsOutput) with field(s):
    ///   - [`assets(Option<Vec<AssetShallow>>)`](crate::output::ListAssetsOutput::assets): A list of MediaPackage VOD Asset resources.
    ///   - [`next_token(Option<String>)`](crate::output::ListAssetsOutput::next_token): A token that can be used to resume pagination from the end of the collection.
    /// - On failure, responds with [`SdkError<ListAssetsError>`](crate::error::ListAssetsError)
    pub fn list_assets(&self) -> fluent_builders::ListAssets {
        fluent_builders::ListAssets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListPackagingConfigurations`](crate::client::fluent_builders::ListPackagingConfigurations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListPackagingConfigurations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListPackagingConfigurations::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListPackagingConfigurations::set_max_results): Upper bound on number of records to return.
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListPackagingConfigurations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListPackagingConfigurations::set_next_token): A token used to resume pagination from the end of a previous request.
    ///   - [`packaging_group_id(impl Into<String>)`](crate::client::fluent_builders::ListPackagingConfigurations::packaging_group_id) / [`set_packaging_group_id(Option<String>)`](crate::client::fluent_builders::ListPackagingConfigurations::set_packaging_group_id): Returns MediaPackage VOD PackagingConfigurations associated with the specified PackagingGroup.
    /// - On success, responds with [`ListPackagingConfigurationsOutput`](crate::output::ListPackagingConfigurationsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListPackagingConfigurationsOutput::next_token): A token that can be used to resume pagination from the end of the collection.
    ///   - [`packaging_configurations(Option<Vec<PackagingConfiguration>>)`](crate::output::ListPackagingConfigurationsOutput::packaging_configurations): A list of MediaPackage VOD PackagingConfiguration resources.
    /// - On failure, responds with [`SdkError<ListPackagingConfigurationsError>`](crate::error::ListPackagingConfigurationsError)
    pub fn list_packaging_configurations(&self) -> fluent_builders::ListPackagingConfigurations {
        fluent_builders::ListPackagingConfigurations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListPackagingGroups`](crate::client::fluent_builders::ListPackagingGroups) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListPackagingGroups::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListPackagingGroups::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListPackagingGroups::set_max_results): Upper bound on number of records to return.
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListPackagingGroups::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListPackagingGroups::set_next_token): A token used to resume pagination from the end of a previous request.
    /// - On success, responds with [`ListPackagingGroupsOutput`](crate::output::ListPackagingGroupsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListPackagingGroupsOutput::next_token): A token that can be used to resume pagination from the end of the collection.
    ///   - [`packaging_groups(Option<Vec<PackagingGroup>>)`](crate::output::ListPackagingGroupsOutput::packaging_groups): A list of MediaPackage VOD PackagingGroup resources.
    /// - On failure, responds with [`SdkError<ListPackagingGroupsError>`](crate::error::ListPackagingGroupsError)
    pub fn list_packaging_groups(&self) -> fluent_builders::ListPackagingGroups {
        fluent_builders::ListPackagingGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): The Amazon Resource Name (ARN) for the resource. You can get this from the response to any request to the resource.
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsForResourceOutput::tags): A collection of tags associated with a resource
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): The Amazon Resource Name (ARN) for the resource. You can get this from the response to any request to the resource.
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagResource::set_tags): A collection of tags associated with a resource
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): The Amazon Resource Name (ARN) for the resource. You can get this from the response to any request to the resource.
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): A comma-separated list of the tag keys to remove from the resource.
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdatePackagingGroup`](crate::client::fluent_builders::UpdatePackagingGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`authorization(Authorization)`](crate::client::fluent_builders::UpdatePackagingGroup::authorization) / [`set_authorization(Option<Authorization>)`](crate::client::fluent_builders::UpdatePackagingGroup::set_authorization): CDN Authorization credentials
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::UpdatePackagingGroup::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::UpdatePackagingGroup::set_id): The ID of a MediaPackage VOD PackagingGroup resource.
    /// - On success, responds with [`UpdatePackagingGroupOutput`](crate::output::UpdatePackagingGroupOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::UpdatePackagingGroupOutput::arn): The ARN of the PackagingGroup.
    ///   - [`authorization(Option<Authorization>)`](crate::output::UpdatePackagingGroupOutput::authorization): CDN Authorization credentials
    ///   - [`domain_name(Option<String>)`](crate::output::UpdatePackagingGroupOutput::domain_name): The fully qualified domain name for Assets in the PackagingGroup.
    ///   - [`egress_access_logs(Option<EgressAccessLogs>)`](crate::output::UpdatePackagingGroupOutput::egress_access_logs): Configure egress access logging.
    ///   - [`id(Option<String>)`](crate::output::UpdatePackagingGroupOutput::id): The ID of the PackagingGroup.
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::UpdatePackagingGroupOutput::tags): A collection of tags associated with a resource
    /// - On failure, responds with [`SdkError<UpdatePackagingGroupError>`](crate::error::UpdatePackagingGroupError)
    pub fn update_packaging_group(&self) -> fluent_builders::UpdatePackagingGroup {
        fluent_builders::UpdatePackagingGroup::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `ConfigureLogs`.
    ///
    /// Changes the packaging group's properities to configure log subscription
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ConfigureLogs {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::configure_logs_input::Builder,
    }
    impl ConfigureLogs {
        /// Creates a new `ConfigureLogs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ConfigureLogsOutput,
            aws_smithy_http::result::SdkError<crate::error::ConfigureLogsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Configure egress access logging.
        pub fn egress_access_logs(mut self, input: crate::model::EgressAccessLogs) -> Self {
            self.inner = self.inner.egress_access_logs(input);
            self
        }
        /// Configure egress access logging.
        pub fn set_egress_access_logs(
            mut self,
            input: std::option::Option<crate::model::EgressAccessLogs>,
        ) -> Self {
            self.inner = self.inner.set_egress_access_logs(input);
            self
        }
        /// The ID of a MediaPackage VOD PackagingGroup resource.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// The ID of a MediaPackage VOD PackagingGroup resource.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAsset`.
    ///
    /// Creates a new MediaPackage VOD Asset resource.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateAsset {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_asset_input::Builder,
    }
    impl CreateAsset {
        /// Creates a new `CreateAsset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAssetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAssetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The unique identifier for the Asset.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// The unique identifier for the Asset.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// The ID of the PackagingGroup for the Asset.
        pub fn packaging_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.packaging_group_id(input.into());
            self
        }
        /// The ID of the PackagingGroup for the Asset.
        pub fn set_packaging_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_packaging_group_id(input);
            self
        }
        /// The resource ID to include in SPEKE key requests.
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// The resource ID to include in SPEKE key requests.
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// ARN of the source object in S3.
        pub fn source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_arn(input.into());
            self
        }
        /// ARN of the source object in S3.
        pub fn set_source_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source_arn(input);
            self
        }
        /// The IAM role ARN used to access the source S3 bucket.
        pub fn source_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_role_arn(input.into());
            self
        }
        /// The IAM role ARN used to access the source S3 bucket.
        pub fn set_source_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_role_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of tags associated with a resource
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// A collection of tags associated with a resource
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePackagingConfiguration`.
    ///
    /// Creates a new MediaPackage VOD PackagingConfiguration resource.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreatePackagingConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_packaging_configuration_input::Builder,
    }
    impl CreatePackagingConfiguration {
        /// Creates a new `CreatePackagingConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePackagingConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePackagingConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// A CMAF packaging configuration.
        pub fn cmaf_package(mut self, input: crate::model::CmafPackage) -> Self {
            self.inner = self.inner.cmaf_package(input);
            self
        }
        /// A CMAF packaging configuration.
        pub fn set_cmaf_package(
            mut self,
            input: std::option::Option<crate::model::CmafPackage>,
        ) -> Self {
            self.inner = self.inner.set_cmaf_package(input);
            self
        }
        /// A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
        pub fn dash_package(mut self, input: crate::model::DashPackage) -> Self {
            self.inner = self.inner.dash_package(input);
            self
        }
        /// A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
        pub fn set_dash_package(
            mut self,
            input: std::option::Option<crate::model::DashPackage>,
        ) -> Self {
            self.inner = self.inner.set_dash_package(input);
            self
        }
        /// An HTTP Live Streaming (HLS) packaging configuration.
        pub fn hls_package(mut self, input: crate::model::HlsPackage) -> Self {
            self.inner = self.inner.hls_package(input);
            self
        }
        /// An HTTP Live Streaming (HLS) packaging configuration.
        pub fn set_hls_package(
            mut self,
            input: std::option::Option<crate::model::HlsPackage>,
        ) -> Self {
            self.inner = self.inner.set_hls_package(input);
            self
        }
        /// The ID of the PackagingConfiguration.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// The ID of the PackagingConfiguration.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// A Microsoft Smooth Streaming (MSS) PackagingConfiguration.
        pub fn mss_package(mut self, input: crate::model::MssPackage) -> Self {
            self.inner = self.inner.mss_package(input);
            self
        }
        /// A Microsoft Smooth Streaming (MSS) PackagingConfiguration.
        pub fn set_mss_package(
            mut self,
            input: std::option::Option<crate::model::MssPackage>,
        ) -> Self {
            self.inner = self.inner.set_mss_package(input);
            self
        }
        /// The ID of a PackagingGroup.
        pub fn packaging_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.packaging_group_id(input.into());
            self
        }
        /// The ID of a PackagingGroup.
        pub fn set_packaging_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_packaging_group_id(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of tags associated with a resource
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// A collection of tags associated with a resource
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePackagingGroup`.
    ///
    /// Creates a new MediaPackage VOD PackagingGroup resource.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreatePackagingGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_packaging_group_input::Builder,
    }
    impl CreatePackagingGroup {
        /// Creates a new `CreatePackagingGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePackagingGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePackagingGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// CDN Authorization credentials
        pub fn authorization(mut self, input: crate::model::Authorization) -> Self {
            self.inner = self.inner.authorization(input);
            self
        }
        /// CDN Authorization credentials
        pub fn set_authorization(
            mut self,
            input: std::option::Option<crate::model::Authorization>,
        ) -> Self {
            self.inner = self.inner.set_authorization(input);
            self
        }
        /// Configure egress access logging.
        pub fn egress_access_logs(mut self, input: crate::model::EgressAccessLogs) -> Self {
            self.inner = self.inner.egress_access_logs(input);
            self
        }
        /// Configure egress access logging.
        pub fn set_egress_access_logs(
            mut self,
            input: std::option::Option<crate::model::EgressAccessLogs>,
        ) -> Self {
            self.inner = self.inner.set_egress_access_logs(input);
            self
        }
        /// The ID of the PackagingGroup.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// The ID of the PackagingGroup.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of tags associated with a resource
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// A collection of tags associated with a resource
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAsset`.
    ///
    /// Deletes an existing MediaPackage VOD Asset resource.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAsset {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_asset_input::Builder,
    }
    impl DeleteAsset {
        /// Creates a new `DeleteAsset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAssetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAssetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the MediaPackage VOD Asset resource to delete.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// The ID of the MediaPackage VOD Asset resource to delete.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePackagingConfiguration`.
    ///
    /// Deletes a MediaPackage VOD PackagingConfiguration resource.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeletePackagingConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_packaging_configuration_input::Builder,
    }
    impl DeletePackagingConfiguration {
        /// Creates a new `DeletePackagingConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePackagingConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePackagingConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the MediaPackage VOD PackagingConfiguration resource to delete.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// The ID of the MediaPackage VOD PackagingConfiguration resource to delete.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePackagingGroup`.
    ///
    /// Deletes a MediaPackage VOD PackagingGroup resource.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeletePackagingGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_packaging_group_input::Builder,
    }
    impl DeletePackagingGroup {
        /// Creates a new `DeletePackagingGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePackagingGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePackagingGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the MediaPackage VOD PackagingGroup resource to delete.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// The ID of the MediaPackage VOD PackagingGroup resource to delete.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAsset`.
    ///
    /// Returns a description of a MediaPackage VOD Asset resource.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAsset {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_asset_input::Builder,
    }
    impl DescribeAsset {
        /// Creates a new `DescribeAsset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAssetOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAssetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of an MediaPackage VOD Asset resource.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// The ID of an MediaPackage VOD Asset resource.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePackagingConfiguration`.
    ///
    /// Returns a description of a MediaPackage VOD PackagingConfiguration resource.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribePackagingConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_packaging_configuration_input::Builder,
    }
    impl DescribePackagingConfiguration {
        /// Creates a new `DescribePackagingConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePackagingConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePackagingConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of a MediaPackage VOD PackagingConfiguration resource.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// The ID of a MediaPackage VOD PackagingConfiguration resource.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePackagingGroup`.
    ///
    /// Returns a description of a MediaPackage VOD PackagingGroup resource.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribePackagingGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_packaging_group_input::Builder,
    }
    impl DescribePackagingGroup {
        /// Creates a new `DescribePackagingGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePackagingGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePackagingGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of a MediaPackage VOD PackagingGroup resource.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// The ID of a MediaPackage VOD PackagingGroup resource.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAssets`.
    ///
    /// Returns a collection of MediaPackage VOD Asset resources.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAssets {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_assets_input::Builder,
    }
    impl ListAssets {
        /// Creates a new `ListAssets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAssetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAssetsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAssetsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAssetsPaginator {
            crate::paginator::ListAssetsPaginator::new(self.handle, self.inner)
        }
        /// Upper bound on number of records to return.
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// Upper bound on number of records to return.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Returns Assets associated with the specified PackagingGroup.
        pub fn packaging_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.packaging_group_id(input.into());
            self
        }
        /// Returns Assets associated with the specified PackagingGroup.
        pub fn set_packaging_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_packaging_group_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPackagingConfigurations`.
    ///
    /// Returns a collection of MediaPackage VOD PackagingConfiguration resources.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPackagingConfigurations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_packaging_configurations_input::Builder,
    }
    impl ListPackagingConfigurations {
        /// Creates a new `ListPackagingConfigurations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPackagingConfigurationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPackagingConfigurationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListPackagingConfigurationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListPackagingConfigurationsPaginator {
            crate::paginator::ListPackagingConfigurationsPaginator::new(self.handle, self.inner)
        }
        /// Upper bound on number of records to return.
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// Upper bound on number of records to return.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Returns MediaPackage VOD PackagingConfigurations associated with the specified PackagingGroup.
        pub fn packaging_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.packaging_group_id(input.into());
            self
        }
        /// Returns MediaPackage VOD PackagingConfigurations associated with the specified PackagingGroup.
        pub fn set_packaging_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_packaging_group_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPackagingGroups`.
    ///
    /// Returns a collection of MediaPackage VOD PackagingGroup resources.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPackagingGroups {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_packaging_groups_input::Builder,
    }
    impl ListPackagingGroups {
        /// Creates a new `ListPackagingGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPackagingGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPackagingGroupsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListPackagingGroupsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListPackagingGroupsPaginator {
            crate::paginator::ListPackagingGroupsPaginator::new(self.handle, self.inner)
        }
        /// Upper bound on number of records to return.
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// Upper bound on number of records to return.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// Returns a list of the tags assigned to the specified resource.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The Amazon Resource Name (ARN) for the resource. You can get this from the response to any request to the resource.
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) for the resource. You can get this from the response to any request to the resource.
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// Adds tags to the specified resource. You can specify one or more tags to add.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The Amazon Resource Name (ARN) for the resource. You can get this from the response to any request to the resource.
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) for the resource. You can get this from the response to any request to the resource.
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of tags associated with a resource
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// A collection of tags associated with a resource
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// Removes tags from the specified resource. You can specify one or more tags to remove.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The Amazon Resource Name (ARN) for the resource. You can get this from the response to any request to the resource.
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) for the resource. You can get this from the response to any request to the resource.
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// A comma-separated list of the tag keys to remove from the resource.
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// A comma-separated list of the tag keys to remove from the resource.
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdatePackagingGroup`.
    ///
    /// Updates a specific packaging group. You can't change the id attribute or any other system-generated attributes.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdatePackagingGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_packaging_group_input::Builder,
    }
    impl UpdatePackagingGroup {
        /// Creates a new `UpdatePackagingGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdatePackagingGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdatePackagingGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// CDN Authorization credentials
        pub fn authorization(mut self, input: crate::model::Authorization) -> Self {
            self.inner = self.inner.authorization(input);
            self
        }
        /// CDN Authorization credentials
        pub fn set_authorization(
            mut self,
            input: std::option::Option<crate::model::Authorization>,
        ) -> Self {
            self.inner = self.inner.set_authorization(input);
            self
        }
        /// The ID of a MediaPackage VOD PackagingGroup resource.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// The ID of a MediaPackage VOD PackagingGroup resource.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
