// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`ConfigureLogsInput`](crate::input::ConfigureLogsInput)
pub mod configure_logs_input {
    /// A builder for [`ConfigureLogsInput`](crate::input::ConfigureLogsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) egress_access_logs: std::option::Option<crate::model::EgressAccessLogs>,
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Configure egress access logging.
        pub fn egress_access_logs(mut self, input: crate::model::EgressAccessLogs) -> Self {
            self.egress_access_logs = Some(input);
            self
        }
        /// Configure egress access logging.
        pub fn set_egress_access_logs(
            mut self,
            input: std::option::Option<crate::model::EgressAccessLogs>,
        ) -> Self {
            self.egress_access_logs = input;
            self
        }
        /// The ID of a MediaPackage VOD PackagingGroup resource.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// The ID of a MediaPackage VOD PackagingGroup resource.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`ConfigureLogsInput`](crate::input::ConfigureLogsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ConfigureLogsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ConfigureLogsInput {
                egress_access_logs: self.egress_access_logs,
                id: self.id,
            })
        }
    }
}
#[doc(hidden)]
pub type ConfigureLogsInputOperationOutputAlias = crate::operation::ConfigureLogs;
#[doc(hidden)]
pub type ConfigureLogsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ConfigureLogsInput {
    /// Consumes the builder and constructs an Operation<[`ConfigureLogs`](crate::operation::ConfigureLogs)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ConfigureLogs,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ConfigureLogsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_1 = &_input.id;
                let input_1 = input_1.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let id = aws_smithy_http::label::fmt_string(input_1, false);
                if id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/packaging_groups/{Id}/configure_logs", Id = id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ConfigureLogsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_configure_logs(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ConfigureLogs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ConfigureLogs",
            "mediapackagevod",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ConfigureLogsInput`](crate::input::ConfigureLogsInput)
    pub fn builder() -> crate::input::configure_logs_input::Builder {
        crate::input::configure_logs_input::Builder::default()
    }
}

/// See [`CreateAssetInput`](crate::input::CreateAssetInput)
pub mod create_asset_input {
    /// A builder for [`CreateAssetInput`](crate::input::CreateAssetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) packaging_group_id: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) source_arn: std::option::Option<std::string::String>,
        pub(crate) source_role_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// The unique identifier for the Asset.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// The unique identifier for the Asset.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// The ID of the PackagingGroup for the Asset.
        pub fn packaging_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.packaging_group_id = Some(input.into());
            self
        }
        /// The ID of the PackagingGroup for the Asset.
        pub fn set_packaging_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.packaging_group_id = input;
            self
        }
        /// The resource ID to include in SPEKE key requests.
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// The resource ID to include in SPEKE key requests.
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// ARN of the source object in S3.
        pub fn source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_arn = Some(input.into());
            self
        }
        /// ARN of the source object in S3.
        pub fn set_source_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_arn = input;
            self
        }
        /// The IAM role ARN used to access the source S3 bucket.
        pub fn source_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_role_arn = Some(input.into());
            self
        }
        /// The IAM role ARN used to access the source S3 bucket.
        pub fn set_source_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_role_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of tags associated with a resource
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// A collection of tags associated with a resource
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAssetInput`](crate::input::CreateAssetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateAssetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateAssetInput {
                id: self.id,
                packaging_group_id: self.packaging_group_id,
                resource_id: self.resource_id,
                source_arn: self.source_arn,
                source_role_arn: self.source_role_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateAssetInputOperationOutputAlias = crate::operation::CreateAsset;
#[doc(hidden)]
pub type CreateAssetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateAssetInput {
    /// Consumes the builder and constructs an Operation<[`CreateAsset`](crate::operation::CreateAsset)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateAsset,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateAssetInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/assets").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateAssetInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_asset(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateAsset::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateAsset",
            "mediapackagevod",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateAssetInput`](crate::input::CreateAssetInput)
    pub fn builder() -> crate::input::create_asset_input::Builder {
        crate::input::create_asset_input::Builder::default()
    }
}

/// See [`CreatePackagingConfigurationInput`](crate::input::CreatePackagingConfigurationInput)
pub mod create_packaging_configuration_input {
    /// A builder for [`CreatePackagingConfigurationInput`](crate::input::CreatePackagingConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cmaf_package: std::option::Option<crate::model::CmafPackage>,
        pub(crate) dash_package: std::option::Option<crate::model::DashPackage>,
        pub(crate) hls_package: std::option::Option<crate::model::HlsPackage>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) mss_package: std::option::Option<crate::model::MssPackage>,
        pub(crate) packaging_group_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// A CMAF packaging configuration.
        pub fn cmaf_package(mut self, input: crate::model::CmafPackage) -> Self {
            self.cmaf_package = Some(input);
            self
        }
        /// A CMAF packaging configuration.
        pub fn set_cmaf_package(
            mut self,
            input: std::option::Option<crate::model::CmafPackage>,
        ) -> Self {
            self.cmaf_package = input;
            self
        }
        /// A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
        pub fn dash_package(mut self, input: crate::model::DashPackage) -> Self {
            self.dash_package = Some(input);
            self
        }
        /// A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
        pub fn set_dash_package(
            mut self,
            input: std::option::Option<crate::model::DashPackage>,
        ) -> Self {
            self.dash_package = input;
            self
        }
        /// An HTTP Live Streaming (HLS) packaging configuration.
        pub fn hls_package(mut self, input: crate::model::HlsPackage) -> Self {
            self.hls_package = Some(input);
            self
        }
        /// An HTTP Live Streaming (HLS) packaging configuration.
        pub fn set_hls_package(
            mut self,
            input: std::option::Option<crate::model::HlsPackage>,
        ) -> Self {
            self.hls_package = input;
            self
        }
        /// The ID of the PackagingConfiguration.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// The ID of the PackagingConfiguration.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// A Microsoft Smooth Streaming (MSS) PackagingConfiguration.
        pub fn mss_package(mut self, input: crate::model::MssPackage) -> Self {
            self.mss_package = Some(input);
            self
        }
        /// A Microsoft Smooth Streaming (MSS) PackagingConfiguration.
        pub fn set_mss_package(
            mut self,
            input: std::option::Option<crate::model::MssPackage>,
        ) -> Self {
            self.mss_package = input;
            self
        }
        /// The ID of a PackagingGroup.
        pub fn packaging_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.packaging_group_id = Some(input.into());
            self
        }
        /// The ID of a PackagingGroup.
        pub fn set_packaging_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.packaging_group_id = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of tags associated with a resource
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// A collection of tags associated with a resource
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePackagingConfigurationInput`](crate::input::CreatePackagingConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreatePackagingConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreatePackagingConfigurationInput {
                cmaf_package: self.cmaf_package,
                dash_package: self.dash_package,
                hls_package: self.hls_package,
                id: self.id,
                mss_package: self.mss_package,
                packaging_group_id: self.packaging_group_id,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreatePackagingConfigurationInputOperationOutputAlias =
    crate::operation::CreatePackagingConfiguration;
#[doc(hidden)]
pub type CreatePackagingConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl CreatePackagingConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`CreatePackagingConfiguration`](crate::operation::CreatePackagingConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreatePackagingConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreatePackagingConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/packaging_configurations").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreatePackagingConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_packaging_configuration(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreatePackagingConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreatePackagingConfiguration",
            "mediapackagevod",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreatePackagingConfigurationInput`](crate::input::CreatePackagingConfigurationInput)
    pub fn builder() -> crate::input::create_packaging_configuration_input::Builder {
        crate::input::create_packaging_configuration_input::Builder::default()
    }
}

/// See [`CreatePackagingGroupInput`](crate::input::CreatePackagingGroupInput)
pub mod create_packaging_group_input {
    /// A builder for [`CreatePackagingGroupInput`](crate::input::CreatePackagingGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authorization: std::option::Option<crate::model::Authorization>,
        pub(crate) egress_access_logs: std::option::Option<crate::model::EgressAccessLogs>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// CDN Authorization credentials
        pub fn authorization(mut self, input: crate::model::Authorization) -> Self {
            self.authorization = Some(input);
            self
        }
        /// CDN Authorization credentials
        pub fn set_authorization(
            mut self,
            input: std::option::Option<crate::model::Authorization>,
        ) -> Self {
            self.authorization = input;
            self
        }
        /// Configure egress access logging.
        pub fn egress_access_logs(mut self, input: crate::model::EgressAccessLogs) -> Self {
            self.egress_access_logs = Some(input);
            self
        }
        /// Configure egress access logging.
        pub fn set_egress_access_logs(
            mut self,
            input: std::option::Option<crate::model::EgressAccessLogs>,
        ) -> Self {
            self.egress_access_logs = input;
            self
        }
        /// The ID of the PackagingGroup.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// The ID of the PackagingGroup.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of tags associated with a resource
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// A collection of tags associated with a resource
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePackagingGroupInput`](crate::input::CreatePackagingGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreatePackagingGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreatePackagingGroupInput {
                authorization: self.authorization,
                egress_access_logs: self.egress_access_logs,
                id: self.id,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreatePackagingGroupInputOperationOutputAlias = crate::operation::CreatePackagingGroup;
#[doc(hidden)]
pub type CreatePackagingGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreatePackagingGroupInput {
    /// Consumes the builder and constructs an Operation<[`CreatePackagingGroup`](crate::operation::CreatePackagingGroup)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreatePackagingGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreatePackagingGroupInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/packaging_groups").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreatePackagingGroupInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_packaging_group(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreatePackagingGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreatePackagingGroup",
            "mediapackagevod",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreatePackagingGroupInput`](crate::input::CreatePackagingGroupInput)
    pub fn builder() -> crate::input::create_packaging_group_input::Builder {
        crate::input::create_packaging_group_input::Builder::default()
    }
}

/// See [`DeleteAssetInput`](crate::input::DeleteAssetInput)
pub mod delete_asset_input {
    /// A builder for [`DeleteAssetInput`](crate::input::DeleteAssetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ID of the MediaPackage VOD Asset resource to delete.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// The ID of the MediaPackage VOD Asset resource to delete.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAssetInput`](crate::input::DeleteAssetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAssetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAssetInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type DeleteAssetInputOperationOutputAlias = crate::operation::DeleteAsset;
#[doc(hidden)]
pub type DeleteAssetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteAssetInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAsset`](crate::operation::DeleteAsset)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAsset,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteAssetInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_2 = &_input.id;
                let input_2 = input_2.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let id = aws_smithy_http::label::fmt_string(input_2, false);
                if id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/assets/{Id}", Id = id).expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteAssetInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAsset::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAsset",
            "mediapackagevod",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteAssetInput`](crate::input::DeleteAssetInput)
    pub fn builder() -> crate::input::delete_asset_input::Builder {
        crate::input::delete_asset_input::Builder::default()
    }
}

/// See [`DeletePackagingConfigurationInput`](crate::input::DeletePackagingConfigurationInput)
pub mod delete_packaging_configuration_input {
    /// A builder for [`DeletePackagingConfigurationInput`](crate::input::DeletePackagingConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ID of the MediaPackage VOD PackagingConfiguration resource to delete.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// The ID of the MediaPackage VOD PackagingConfiguration resource to delete.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeletePackagingConfigurationInput`](crate::input::DeletePackagingConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeletePackagingConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeletePackagingConfigurationInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type DeletePackagingConfigurationInputOperationOutputAlias =
    crate::operation::DeletePackagingConfiguration;
#[doc(hidden)]
pub type DeletePackagingConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeletePackagingConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`DeletePackagingConfiguration`](crate::operation::DeletePackagingConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeletePackagingConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeletePackagingConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_3 = &_input.id;
                let input_3 = input_3.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let id = aws_smithy_http::label::fmt_string(input_3, false);
                if id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/packaging_configurations/{Id}", Id = id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeletePackagingConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeletePackagingConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeletePackagingConfiguration",
            "mediapackagevod",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeletePackagingConfigurationInput`](crate::input::DeletePackagingConfigurationInput)
    pub fn builder() -> crate::input::delete_packaging_configuration_input::Builder {
        crate::input::delete_packaging_configuration_input::Builder::default()
    }
}

/// See [`DeletePackagingGroupInput`](crate::input::DeletePackagingGroupInput)
pub mod delete_packaging_group_input {
    /// A builder for [`DeletePackagingGroupInput`](crate::input::DeletePackagingGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ID of the MediaPackage VOD PackagingGroup resource to delete.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// The ID of the MediaPackage VOD PackagingGroup resource to delete.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeletePackagingGroupInput`](crate::input::DeletePackagingGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeletePackagingGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeletePackagingGroupInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type DeletePackagingGroupInputOperationOutputAlias = crate::operation::DeletePackagingGroup;
#[doc(hidden)]
pub type DeletePackagingGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeletePackagingGroupInput {
    /// Consumes the builder and constructs an Operation<[`DeletePackagingGroup`](crate::operation::DeletePackagingGroup)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeletePackagingGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeletePackagingGroupInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_4 = &_input.id;
                let input_4 = input_4.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let id = aws_smithy_http::label::fmt_string(input_4, false);
                if id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/packaging_groups/{Id}", Id = id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeletePackagingGroupInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeletePackagingGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeletePackagingGroup",
            "mediapackagevod",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeletePackagingGroupInput`](crate::input::DeletePackagingGroupInput)
    pub fn builder() -> crate::input::delete_packaging_group_input::Builder {
        crate::input::delete_packaging_group_input::Builder::default()
    }
}

/// See [`DescribeAssetInput`](crate::input::DescribeAssetInput)
pub mod describe_asset_input {
    /// A builder for [`DescribeAssetInput`](crate::input::DescribeAssetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ID of an MediaPackage VOD Asset resource.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// The ID of an MediaPackage VOD Asset resource.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAssetInput`](crate::input::DescribeAssetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAssetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAssetInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type DescribeAssetInputOperationOutputAlias = crate::operation::DescribeAsset;
#[doc(hidden)]
pub type DescribeAssetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeAssetInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAsset`](crate::operation::DescribeAsset)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAsset,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeAssetInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_5 = &_input.id;
                let input_5 = input_5.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let id = aws_smithy_http::label::fmt_string(input_5, false);
                if id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/assets/{Id}", Id = id).expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeAssetInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAsset::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAsset",
            "mediapackagevod",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeAssetInput`](crate::input::DescribeAssetInput)
    pub fn builder() -> crate::input::describe_asset_input::Builder {
        crate::input::describe_asset_input::Builder::default()
    }
}

/// See [`DescribePackagingConfigurationInput`](crate::input::DescribePackagingConfigurationInput)
pub mod describe_packaging_configuration_input {
    /// A builder for [`DescribePackagingConfigurationInput`](crate::input::DescribePackagingConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ID of a MediaPackage VOD PackagingConfiguration resource.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// The ID of a MediaPackage VOD PackagingConfiguration resource.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePackagingConfigurationInput`](crate::input::DescribePackagingConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribePackagingConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribePackagingConfigurationInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type DescribePackagingConfigurationInputOperationOutputAlias =
    crate::operation::DescribePackagingConfiguration;
#[doc(hidden)]
pub type DescribePackagingConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribePackagingConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`DescribePackagingConfiguration`](crate::operation::DescribePackagingConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribePackagingConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribePackagingConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_6 = &_input.id;
                let input_6 = input_6.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let id = aws_smithy_http::label::fmt_string(input_6, false);
                if id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/packaging_configurations/{Id}", Id = id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribePackagingConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribePackagingConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribePackagingConfiguration",
            "mediapackagevod",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribePackagingConfigurationInput`](crate::input::DescribePackagingConfigurationInput)
    pub fn builder() -> crate::input::describe_packaging_configuration_input::Builder {
        crate::input::describe_packaging_configuration_input::Builder::default()
    }
}

/// See [`DescribePackagingGroupInput`](crate::input::DescribePackagingGroupInput)
pub mod describe_packaging_group_input {
    /// A builder for [`DescribePackagingGroupInput`](crate::input::DescribePackagingGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ID of a MediaPackage VOD PackagingGroup resource.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// The ID of a MediaPackage VOD PackagingGroup resource.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePackagingGroupInput`](crate::input::DescribePackagingGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribePackagingGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribePackagingGroupInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type DescribePackagingGroupInputOperationOutputAlias = crate::operation::DescribePackagingGroup;
#[doc(hidden)]
pub type DescribePackagingGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribePackagingGroupInput {
    /// Consumes the builder and constructs an Operation<[`DescribePackagingGroup`](crate::operation::DescribePackagingGroup)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribePackagingGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribePackagingGroupInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_7 = &_input.id;
                let input_7 = input_7.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let id = aws_smithy_http::label::fmt_string(input_7, false);
                if id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/packaging_groups/{Id}", Id = id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribePackagingGroupInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribePackagingGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribePackagingGroup",
            "mediapackagevod",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribePackagingGroupInput`](crate::input::DescribePackagingGroupInput)
    pub fn builder() -> crate::input::describe_packaging_group_input::Builder {
        crate::input::describe_packaging_group_input::Builder::default()
    }
}

/// See [`ListAssetsInput`](crate::input::ListAssetsInput)
pub mod list_assets_input {
    /// A builder for [`ListAssetsInput`](crate::input::ListAssetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) packaging_group_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Upper bound on number of records to return.
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// Upper bound on number of records to return.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Returns Assets associated with the specified PackagingGroup.
        pub fn packaging_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.packaging_group_id = Some(input.into());
            self
        }
        /// Returns Assets associated with the specified PackagingGroup.
        pub fn set_packaging_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.packaging_group_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAssetsInput`](crate::input::ListAssetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAssetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAssetsInput {
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
                packaging_group_id: self.packaging_group_id,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAssetsInputOperationOutputAlias = crate::operation::ListAssets;
#[doc(hidden)]
pub type ListAssetsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListAssetsInput {
    /// Consumes the builder and constructs an Operation<[`ListAssets`](crate::operation::ListAssets)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAssets,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListAssetsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/assets").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListAssetsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if _input.max_results != 0 {
                    query.push_kv(
                        "maxResults",
                        aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                    );
                }
                if let Some(inner_8) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_8));
                }
                if let Some(inner_9) = &_input.packaging_group_id {
                    query.push_kv(
                        "packagingGroupId",
                        &aws_smithy_http::query::fmt_string(&inner_9),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListAssetsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAssets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAssets",
            "mediapackagevod",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListAssetsInput`](crate::input::ListAssetsInput)
    pub fn builder() -> crate::input::list_assets_input::Builder {
        crate::input::list_assets_input::Builder::default()
    }
}

/// See [`ListPackagingConfigurationsInput`](crate::input::ListPackagingConfigurationsInput)
pub mod list_packaging_configurations_input {
    /// A builder for [`ListPackagingConfigurationsInput`](crate::input::ListPackagingConfigurationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) packaging_group_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Upper bound on number of records to return.
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// Upper bound on number of records to return.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Returns MediaPackage VOD PackagingConfigurations associated with the specified PackagingGroup.
        pub fn packaging_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.packaging_group_id = Some(input.into());
            self
        }
        /// Returns MediaPackage VOD PackagingConfigurations associated with the specified PackagingGroup.
        pub fn set_packaging_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.packaging_group_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPackagingConfigurationsInput`](crate::input::ListPackagingConfigurationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPackagingConfigurationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListPackagingConfigurationsInput {
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
                packaging_group_id: self.packaging_group_id,
            })
        }
    }
}
#[doc(hidden)]
pub type ListPackagingConfigurationsInputOperationOutputAlias =
    crate::operation::ListPackagingConfigurations;
#[doc(hidden)]
pub type ListPackagingConfigurationsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListPackagingConfigurationsInput {
    /// Consumes the builder and constructs an Operation<[`ListPackagingConfigurations`](crate::operation::ListPackagingConfigurations)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPackagingConfigurations,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListPackagingConfigurationsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/packaging_configurations").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListPackagingConfigurationsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if _input.max_results != 0 {
                    query.push_kv(
                        "maxResults",
                        aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                    );
                }
                if let Some(inner_10) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_10));
                }
                if let Some(inner_11) = &_input.packaging_group_id {
                    query.push_kv(
                        "packagingGroupId",
                        &aws_smithy_http::query::fmt_string(&inner_11),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListPackagingConfigurationsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPackagingConfigurations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPackagingConfigurations",
            "mediapackagevod",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListPackagingConfigurationsInput`](crate::input::ListPackagingConfigurationsInput)
    pub fn builder() -> crate::input::list_packaging_configurations_input::Builder {
        crate::input::list_packaging_configurations_input::Builder::default()
    }
}

/// See [`ListPackagingGroupsInput`](crate::input::ListPackagingGroupsInput)
pub mod list_packaging_groups_input {
    /// A builder for [`ListPackagingGroupsInput`](crate::input::ListPackagingGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Upper bound on number of records to return.
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// Upper bound on number of records to return.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPackagingGroupsInput`](crate::input::ListPackagingGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPackagingGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListPackagingGroupsInput {
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListPackagingGroupsInputOperationOutputAlias = crate::operation::ListPackagingGroups;
#[doc(hidden)]
pub type ListPackagingGroupsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListPackagingGroupsInput {
    /// Consumes the builder and constructs an Operation<[`ListPackagingGroups`](crate::operation::ListPackagingGroups)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPackagingGroups,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListPackagingGroupsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/packaging_groups").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListPackagingGroupsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if _input.max_results != 0 {
                    query.push_kv(
                        "maxResults",
                        aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                    );
                }
                if let Some(inner_12) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_12));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListPackagingGroupsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPackagingGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPackagingGroups",
            "mediapackagevod",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListPackagingGroupsInput`](crate::input::ListPackagingGroupsInput)
    pub fn builder() -> crate::input::list_packaging_groups_input::Builder {
        crate::input::list_packaging_groups_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The Amazon Resource Name (ARN) for the resource. You can get this from the response to any request to the resource.
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) for the resource. You can get this from the response to any request to the resource.
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListTagsForResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_13 = &_input.resource_arn;
                let input_13 = input_13.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_arn = aws_smithy_http::label::fmt_string(input_13, false);
                if resource_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListTagsForResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "mediapackagevod",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// The Amazon Resource Name (ARN) for the resource. You can get this from the response to any request to the resource.
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) for the resource. You can get this from the response to any request to the resource.
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of tags associated with a resource
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// A collection of tags associated with a resource
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::TagResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_14 = &_input.resource_arn;
                let input_14 = input_14.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_arn = aws_smithy_http::label::fmt_string(input_14, false);
                if resource_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::TagResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "mediapackagevod",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// The Amazon Resource Name (ARN) for the resource. You can get this from the response to any request to the resource.
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) for the resource. You can get this from the response to any request to the resource.
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// A comma-separated list of the tag keys to remove from the resource.
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// A comma-separated list of the tag keys to remove from the resource.
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UntagResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_15 = &_input.resource_arn;
                let input_15 = input_15.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_arn = aws_smithy_http::label::fmt_string(input_15, false);
                if resource_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::UntagResourceInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_16) = &_input.tag_keys {
                    for inner_17 in inner_16 {
                        query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_17));
                    }
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UntagResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "mediapackagevod",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdatePackagingGroupInput`](crate::input::UpdatePackagingGroupInput)
pub mod update_packaging_group_input {
    /// A builder for [`UpdatePackagingGroupInput`](crate::input::UpdatePackagingGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authorization: std::option::Option<crate::model::Authorization>,
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// CDN Authorization credentials
        pub fn authorization(mut self, input: crate::model::Authorization) -> Self {
            self.authorization = Some(input);
            self
        }
        /// CDN Authorization credentials
        pub fn set_authorization(
            mut self,
            input: std::option::Option<crate::model::Authorization>,
        ) -> Self {
            self.authorization = input;
            self
        }
        /// The ID of a MediaPackage VOD PackagingGroup resource.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// The ID of a MediaPackage VOD PackagingGroup resource.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdatePackagingGroupInput`](crate::input::UpdatePackagingGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdatePackagingGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdatePackagingGroupInput {
                authorization: self.authorization,
                id: self.id,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdatePackagingGroupInputOperationOutputAlias = crate::operation::UpdatePackagingGroup;
#[doc(hidden)]
pub type UpdatePackagingGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdatePackagingGroupInput {
    /// Consumes the builder and constructs an Operation<[`UpdatePackagingGroup`](crate::operation::UpdatePackagingGroup)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdatePackagingGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdatePackagingGroupInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_18 = &_input.id;
                let input_18 = input_18.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let id = aws_smithy_http::label::fmt_string(input_18, false);
                if id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/packaging_groups/{Id}", Id = id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdatePackagingGroupInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_packaging_group(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdatePackagingGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdatePackagingGroup",
            "mediapackagevod",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdatePackagingGroupInput`](crate::input::UpdatePackagingGroupInput)
    pub fn builder() -> crate::input::update_packaging_group_input::Builder {
        crate::input::update_packaging_group_input::Builder::default()
    }
}

/// A MediaPackage VOD PackagingGroup resource configuration.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePackagingGroupInput {
    /// CDN Authorization credentials
    pub authorization: std::option::Option<crate::model::Authorization>,
    /// The ID of a MediaPackage VOD PackagingGroup resource.
    pub id: std::option::Option<std::string::String>,
}
impl UpdatePackagingGroupInput {
    /// CDN Authorization credentials
    pub fn authorization(&self) -> std::option::Option<&crate::model::Authorization> {
        self.authorization.as_ref()
    }
    /// The ID of a MediaPackage VOD PackagingGroup resource.
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for UpdatePackagingGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePackagingGroupInput");
        formatter.field("authorization", &self.authorization);
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// The Amazon Resource Name (ARN) for the resource. You can get this from the response to any request to the resource.
    pub resource_arn: std::option::Option<std::string::String>,
    /// A comma-separated list of the tag keys to remove from the resource.
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// The Amazon Resource Name (ARN) for the resource. You can get this from the response to any request to the resource.
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// A comma-separated list of the tag keys to remove from the resource.
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// The Amazon Resource Name (ARN) for the resource. You can get this from the response to any request to the resource.
    pub resource_arn: std::option::Option<std::string::String>,
    /// A collection of tags associated with a resource
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl TagResourceInput {
    /// The Amazon Resource Name (ARN) for the resource. You can get this from the response to any request to the resource.
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// A collection of tags associated with a resource
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// The Amazon Resource Name (ARN) for the resource. You can get this from the response to any request to the resource.
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// The Amazon Resource Name (ARN) for the resource. You can get this from the response to any request to the resource.
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPackagingGroupsInput {
    /// Upper bound on number of records to return.
    pub max_results: i32,
    /// A token used to resume pagination from the end of a previous request.
    pub next_token: std::option::Option<std::string::String>,
}
impl ListPackagingGroupsInput {
    /// Upper bound on number of records to return.
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// A token used to resume pagination from the end of a previous request.
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListPackagingGroupsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPackagingGroupsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPackagingConfigurationsInput {
    /// Upper bound on number of records to return.
    pub max_results: i32,
    /// A token used to resume pagination from the end of a previous request.
    pub next_token: std::option::Option<std::string::String>,
    /// Returns MediaPackage VOD PackagingConfigurations associated with the specified PackagingGroup.
    pub packaging_group_id: std::option::Option<std::string::String>,
}
impl ListPackagingConfigurationsInput {
    /// Upper bound on number of records to return.
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// A token used to resume pagination from the end of a previous request.
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// Returns MediaPackage VOD PackagingConfigurations associated with the specified PackagingGroup.
    pub fn packaging_group_id(&self) -> std::option::Option<&str> {
        self.packaging_group_id.as_deref()
    }
}
impl std::fmt::Debug for ListPackagingConfigurationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPackagingConfigurationsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("packaging_group_id", &self.packaging_group_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAssetsInput {
    /// Upper bound on number of records to return.
    pub max_results: i32,
    /// A token used to resume pagination from the end of a previous request.
    pub next_token: std::option::Option<std::string::String>,
    /// Returns Assets associated with the specified PackagingGroup.
    pub packaging_group_id: std::option::Option<std::string::String>,
}
impl ListAssetsInput {
    /// Upper bound on number of records to return.
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// A token used to resume pagination from the end of a previous request.
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// Returns Assets associated with the specified PackagingGroup.
    pub fn packaging_group_id(&self) -> std::option::Option<&str> {
        self.packaging_group_id.as_deref()
    }
}
impl std::fmt::Debug for ListAssetsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAssetsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("packaging_group_id", &self.packaging_group_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePackagingGroupInput {
    /// The ID of a MediaPackage VOD PackagingGroup resource.
    pub id: std::option::Option<std::string::String>,
}
impl DescribePackagingGroupInput {
    /// The ID of a MediaPackage VOD PackagingGroup resource.
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for DescribePackagingGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePackagingGroupInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePackagingConfigurationInput {
    /// The ID of a MediaPackage VOD PackagingConfiguration resource.
    pub id: std::option::Option<std::string::String>,
}
impl DescribePackagingConfigurationInput {
    /// The ID of a MediaPackage VOD PackagingConfiguration resource.
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for DescribePackagingConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePackagingConfigurationInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAssetInput {
    /// The ID of an MediaPackage VOD Asset resource.
    pub id: std::option::Option<std::string::String>,
}
impl DescribeAssetInput {
    /// The ID of an MediaPackage VOD Asset resource.
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for DescribeAssetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAssetInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePackagingGroupInput {
    /// The ID of the MediaPackage VOD PackagingGroup resource to delete.
    pub id: std::option::Option<std::string::String>,
}
impl DeletePackagingGroupInput {
    /// The ID of the MediaPackage VOD PackagingGroup resource to delete.
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for DeletePackagingGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePackagingGroupInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePackagingConfigurationInput {
    /// The ID of the MediaPackage VOD PackagingConfiguration resource to delete.
    pub id: std::option::Option<std::string::String>,
}
impl DeletePackagingConfigurationInput {
    /// The ID of the MediaPackage VOD PackagingConfiguration resource to delete.
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for DeletePackagingConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePackagingConfigurationInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAssetInput {
    /// The ID of the MediaPackage VOD Asset resource to delete.
    pub id: std::option::Option<std::string::String>,
}
impl DeleteAssetInput {
    /// The ID of the MediaPackage VOD Asset resource to delete.
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for DeleteAssetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAssetInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

/// A new MediaPackage VOD PackagingGroup resource configuration.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePackagingGroupInput {
    /// CDN Authorization credentials
    pub authorization: std::option::Option<crate::model::Authorization>,
    /// Configure egress access logging.
    pub egress_access_logs: std::option::Option<crate::model::EgressAccessLogs>,
    /// The ID of the PackagingGroup.
    pub id: std::option::Option<std::string::String>,
    /// A collection of tags associated with a resource
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreatePackagingGroupInput {
    /// CDN Authorization credentials
    pub fn authorization(&self) -> std::option::Option<&crate::model::Authorization> {
        self.authorization.as_ref()
    }
    /// Configure egress access logging.
    pub fn egress_access_logs(&self) -> std::option::Option<&crate::model::EgressAccessLogs> {
        self.egress_access_logs.as_ref()
    }
    /// The ID of the PackagingGroup.
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// A collection of tags associated with a resource
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreatePackagingGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePackagingGroupInput");
        formatter.field("authorization", &self.authorization);
        formatter.field("egress_access_logs", &self.egress_access_logs);
        formatter.field("id", &self.id);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// A new MediaPackage VOD PackagingConfiguration resource configuration.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePackagingConfigurationInput {
    /// A CMAF packaging configuration.
    pub cmaf_package: std::option::Option<crate::model::CmafPackage>,
    /// A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
    pub dash_package: std::option::Option<crate::model::DashPackage>,
    /// An HTTP Live Streaming (HLS) packaging configuration.
    pub hls_package: std::option::Option<crate::model::HlsPackage>,
    /// The ID of the PackagingConfiguration.
    pub id: std::option::Option<std::string::String>,
    /// A Microsoft Smooth Streaming (MSS) PackagingConfiguration.
    pub mss_package: std::option::Option<crate::model::MssPackage>,
    /// The ID of a PackagingGroup.
    pub packaging_group_id: std::option::Option<std::string::String>,
    /// A collection of tags associated with a resource
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreatePackagingConfigurationInput {
    /// A CMAF packaging configuration.
    pub fn cmaf_package(&self) -> std::option::Option<&crate::model::CmafPackage> {
        self.cmaf_package.as_ref()
    }
    /// A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
    pub fn dash_package(&self) -> std::option::Option<&crate::model::DashPackage> {
        self.dash_package.as_ref()
    }
    /// An HTTP Live Streaming (HLS) packaging configuration.
    pub fn hls_package(&self) -> std::option::Option<&crate::model::HlsPackage> {
        self.hls_package.as_ref()
    }
    /// The ID of the PackagingConfiguration.
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// A Microsoft Smooth Streaming (MSS) PackagingConfiguration.
    pub fn mss_package(&self) -> std::option::Option<&crate::model::MssPackage> {
        self.mss_package.as_ref()
    }
    /// The ID of a PackagingGroup.
    pub fn packaging_group_id(&self) -> std::option::Option<&str> {
        self.packaging_group_id.as_deref()
    }
    /// A collection of tags associated with a resource
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreatePackagingConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePackagingConfigurationInput");
        formatter.field("cmaf_package", &self.cmaf_package);
        formatter.field("dash_package", &self.dash_package);
        formatter.field("hls_package", &self.hls_package);
        formatter.field("id", &self.id);
        formatter.field("mss_package", &self.mss_package);
        formatter.field("packaging_group_id", &self.packaging_group_id);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// A new MediaPackage VOD Asset configuration.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAssetInput {
    /// The unique identifier for the Asset.
    pub id: std::option::Option<std::string::String>,
    /// The ID of the PackagingGroup for the Asset.
    pub packaging_group_id: std::option::Option<std::string::String>,
    /// The resource ID to include in SPEKE key requests.
    pub resource_id: std::option::Option<std::string::String>,
    /// ARN of the source object in S3.
    pub source_arn: std::option::Option<std::string::String>,
    /// The IAM role ARN used to access the source S3 bucket.
    pub source_role_arn: std::option::Option<std::string::String>,
    /// A collection of tags associated with a resource
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateAssetInput {
    /// The unique identifier for the Asset.
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// The ID of the PackagingGroup for the Asset.
    pub fn packaging_group_id(&self) -> std::option::Option<&str> {
        self.packaging_group_id.as_deref()
    }
    /// The resource ID to include in SPEKE key requests.
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// ARN of the source object in S3.
    pub fn source_arn(&self) -> std::option::Option<&str> {
        self.source_arn.as_deref()
    }
    /// The IAM role ARN used to access the source S3 bucket.
    pub fn source_role_arn(&self) -> std::option::Option<&str> {
        self.source_role_arn.as_deref()
    }
    /// A collection of tags associated with a resource
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateAssetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAssetInput");
        formatter.field("id", &self.id);
        formatter.field("packaging_group_id", &self.packaging_group_id);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("source_arn", &self.source_arn);
        formatter.field("source_role_arn", &self.source_role_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// The option to configure log subscription.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConfigureLogsInput {
    /// Configure egress access logging.
    pub egress_access_logs: std::option::Option<crate::model::EgressAccessLogs>,
    /// The ID of a MediaPackage VOD PackagingGroup resource.
    pub id: std::option::Option<std::string::String>,
}
impl ConfigureLogsInput {
    /// Configure egress access logging.
    pub fn egress_access_logs(&self) -> std::option::Option<&crate::model::EgressAccessLogs> {
        self.egress_access_logs.as_ref()
    }
    /// The ID of a MediaPackage VOD PackagingGroup resource.
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for ConfigureLogsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConfigureLogsInput");
        formatter.field("egress_access_logs", &self.egress_access_logs);
        formatter.field("id", &self.id);
        formatter.finish()
    }
}
