// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `ConfigureLogs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ConfigureLogsError {
    /// Kind of error that occurred.
    pub kind: ConfigureLogsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ConfigureLogs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ConfigureLogsErrorKind {
    /// The client is not authorized to access the requested resource.
    ForbiddenException(crate::error::ForbiddenException),
    /// An unexpected error occurred.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// The requested resource does not exist.
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error occurred.
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// The client has exceeded their resource or throttling limits.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// The parameters sent in the request are not valid.
    UnprocessableEntityException(crate::error::UnprocessableEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ConfigureLogsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ConfigureLogsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ConfigureLogsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ConfigureLogsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ConfigureLogsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ConfigureLogsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ConfigureLogsErrorKind::UnprocessableEntityException(_inner) => _inner.fmt(f),
            ConfigureLogsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ConfigureLogsError {
    fn code(&self) -> Option<&str> {
        ConfigureLogsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ConfigureLogsError {
    /// Creates a new `ConfigureLogsError`.
    pub fn new(kind: ConfigureLogsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ConfigureLogsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ConfigureLogsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ConfigureLogsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ConfigureLogsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ConfigureLogsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, ConfigureLogsErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `ConfigureLogsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConfigureLogsErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ConfigureLogsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ConfigureLogsErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `ConfigureLogsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConfigureLogsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ConfigureLogsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConfigureLogsErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `ConfigureLogsErrorKind::UnprocessableEntityException`.
    pub fn is_unprocessable_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConfigureLogsErrorKind::UnprocessableEntityException(_)
        )
    }
}
impl std::error::Error for ConfigureLogsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ConfigureLogsErrorKind::ForbiddenException(_inner) => Some(_inner),
            ConfigureLogsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ConfigureLogsErrorKind::NotFoundException(_inner) => Some(_inner),
            ConfigureLogsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ConfigureLogsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ConfigureLogsErrorKind::UnprocessableEntityException(_inner) => Some(_inner),
            ConfigureLogsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateAsset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateAssetError {
    /// Kind of error that occurred.
    pub kind: CreateAssetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateAsset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateAssetErrorKind {
    /// The client is not authorized to access the requested resource.
    ForbiddenException(crate::error::ForbiddenException),
    /// An unexpected error occurred.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// The requested resource does not exist.
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error occurred.
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// The client has exceeded their resource or throttling limits.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// The parameters sent in the request are not valid.
    UnprocessableEntityException(crate::error::UnprocessableEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateAssetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateAssetErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateAssetErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            CreateAssetErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateAssetErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateAssetErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateAssetErrorKind::UnprocessableEntityException(_inner) => _inner.fmt(f),
            CreateAssetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateAssetError {
    fn code(&self) -> Option<&str> {
        CreateAssetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateAssetError {
    /// Creates a new `CreateAssetError`.
    pub fn new(kind: CreateAssetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateAssetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateAssetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateAssetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateAssetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateAssetErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, CreateAssetErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `CreateAssetErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAssetErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAssetErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateAssetErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `CreateAssetErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAssetErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAssetErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAssetErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAssetErrorKind::UnprocessableEntityException`.
    pub fn is_unprocessable_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAssetErrorKind::UnprocessableEntityException(_)
        )
    }
}
impl std::error::Error for CreateAssetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateAssetErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateAssetErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            CreateAssetErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateAssetErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateAssetErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateAssetErrorKind::UnprocessableEntityException(_inner) => Some(_inner),
            CreateAssetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreatePackagingConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreatePackagingConfigurationError {
    /// Kind of error that occurred.
    pub kind: CreatePackagingConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreatePackagingConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreatePackagingConfigurationErrorKind {
    /// The client is not authorized to access the requested resource.
    ForbiddenException(crate::error::ForbiddenException),
    /// An unexpected error occurred.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// The requested resource does not exist.
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error occurred.
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// The client has exceeded their resource or throttling limits.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// The parameters sent in the request are not valid.
    UnprocessableEntityException(crate::error::UnprocessableEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreatePackagingConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreatePackagingConfigurationErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreatePackagingConfigurationErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            CreatePackagingConfigurationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreatePackagingConfigurationErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            CreatePackagingConfigurationErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            CreatePackagingConfigurationErrorKind::UnprocessableEntityException(_inner) => {
                _inner.fmt(f)
            }
            CreatePackagingConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreatePackagingConfigurationError {
    fn code(&self) -> Option<&str> {
        CreatePackagingConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreatePackagingConfigurationError {
    /// Creates a new `CreatePackagingConfigurationError`.
    pub fn new(kind: CreatePackagingConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreatePackagingConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreatePackagingConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreatePackagingConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreatePackagingConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreatePackagingConfigurationErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePackagingConfigurationErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePackagingConfigurationErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePackagingConfigurationErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePackagingConfigurationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePackagingConfigurationErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePackagingConfigurationErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePackagingConfigurationErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePackagingConfigurationErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePackagingConfigurationErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePackagingConfigurationErrorKind::UnprocessableEntityException`.
    pub fn is_unprocessable_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePackagingConfigurationErrorKind::UnprocessableEntityException(_)
        )
    }
}
impl std::error::Error for CreatePackagingConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreatePackagingConfigurationErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreatePackagingConfigurationErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            CreatePackagingConfigurationErrorKind::NotFoundException(_inner) => Some(_inner),
            CreatePackagingConfigurationErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            CreatePackagingConfigurationErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreatePackagingConfigurationErrorKind::UnprocessableEntityException(_inner) => {
                Some(_inner)
            }
            CreatePackagingConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreatePackagingGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreatePackagingGroupError {
    /// Kind of error that occurred.
    pub kind: CreatePackagingGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreatePackagingGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreatePackagingGroupErrorKind {
    /// The client is not authorized to access the requested resource.
    ForbiddenException(crate::error::ForbiddenException),
    /// An unexpected error occurred.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// The requested resource does not exist.
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error occurred.
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// The client has exceeded their resource or throttling limits.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// The parameters sent in the request are not valid.
    UnprocessableEntityException(crate::error::UnprocessableEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreatePackagingGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreatePackagingGroupErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreatePackagingGroupErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            CreatePackagingGroupErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreatePackagingGroupErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreatePackagingGroupErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreatePackagingGroupErrorKind::UnprocessableEntityException(_inner) => _inner.fmt(f),
            CreatePackagingGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreatePackagingGroupError {
    fn code(&self) -> Option<&str> {
        CreatePackagingGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreatePackagingGroupError {
    /// Creates a new `CreatePackagingGroupError`.
    pub fn new(kind: CreatePackagingGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreatePackagingGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreatePackagingGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreatePackagingGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreatePackagingGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreatePackagingGroupErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePackagingGroupErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePackagingGroupErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePackagingGroupErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePackagingGroupErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePackagingGroupErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePackagingGroupErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePackagingGroupErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePackagingGroupErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePackagingGroupErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePackagingGroupErrorKind::UnprocessableEntityException`.
    pub fn is_unprocessable_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePackagingGroupErrorKind::UnprocessableEntityException(_)
        )
    }
}
impl std::error::Error for CreatePackagingGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreatePackagingGroupErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreatePackagingGroupErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            CreatePackagingGroupErrorKind::NotFoundException(_inner) => Some(_inner),
            CreatePackagingGroupErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreatePackagingGroupErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreatePackagingGroupErrorKind::UnprocessableEntityException(_inner) => Some(_inner),
            CreatePackagingGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAsset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAssetError {
    /// Kind of error that occurred.
    pub kind: DeleteAssetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAsset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAssetErrorKind {
    /// The client is not authorized to access the requested resource.
    ForbiddenException(crate::error::ForbiddenException),
    /// An unexpected error occurred.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// The requested resource does not exist.
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error occurred.
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// The client has exceeded their resource or throttling limits.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// The parameters sent in the request are not valid.
    UnprocessableEntityException(crate::error::UnprocessableEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAssetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAssetErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteAssetErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeleteAssetErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteAssetErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteAssetErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteAssetErrorKind::UnprocessableEntityException(_inner) => _inner.fmt(f),
            DeleteAssetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAssetError {
    fn code(&self) -> Option<&str> {
        DeleteAssetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAssetError {
    /// Creates a new `DeleteAssetError`.
    pub fn new(kind: DeleteAssetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAssetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAssetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAssetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAssetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteAssetErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, DeleteAssetErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `DeleteAssetErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAssetErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAssetErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteAssetErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeleteAssetErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAssetErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAssetErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAssetErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAssetErrorKind::UnprocessableEntityException`.
    pub fn is_unprocessable_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAssetErrorKind::UnprocessableEntityException(_)
        )
    }
}
impl std::error::Error for DeleteAssetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAssetErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteAssetErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteAssetErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteAssetErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteAssetErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteAssetErrorKind::UnprocessableEntityException(_inner) => Some(_inner),
            DeleteAssetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeletePackagingConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeletePackagingConfigurationError {
    /// Kind of error that occurred.
    pub kind: DeletePackagingConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeletePackagingConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeletePackagingConfigurationErrorKind {
    /// The client is not authorized to access the requested resource.
    ForbiddenException(crate::error::ForbiddenException),
    /// An unexpected error occurred.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// The requested resource does not exist.
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error occurred.
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// The client has exceeded their resource or throttling limits.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// The parameters sent in the request are not valid.
    UnprocessableEntityException(crate::error::UnprocessableEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeletePackagingConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeletePackagingConfigurationErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeletePackagingConfigurationErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            DeletePackagingConfigurationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeletePackagingConfigurationErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            DeletePackagingConfigurationErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            DeletePackagingConfigurationErrorKind::UnprocessableEntityException(_inner) => {
                _inner.fmt(f)
            }
            DeletePackagingConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeletePackagingConfigurationError {
    fn code(&self) -> Option<&str> {
        DeletePackagingConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeletePackagingConfigurationError {
    /// Creates a new `DeletePackagingConfigurationError`.
    pub fn new(kind: DeletePackagingConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeletePackagingConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeletePackagingConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeletePackagingConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeletePackagingConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeletePackagingConfigurationErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePackagingConfigurationErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePackagingConfigurationErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePackagingConfigurationErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePackagingConfigurationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePackagingConfigurationErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePackagingConfigurationErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePackagingConfigurationErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePackagingConfigurationErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePackagingConfigurationErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePackagingConfigurationErrorKind::UnprocessableEntityException`.
    pub fn is_unprocessable_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePackagingConfigurationErrorKind::UnprocessableEntityException(_)
        )
    }
}
impl std::error::Error for DeletePackagingConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeletePackagingConfigurationErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeletePackagingConfigurationErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            DeletePackagingConfigurationErrorKind::NotFoundException(_inner) => Some(_inner),
            DeletePackagingConfigurationErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            DeletePackagingConfigurationErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeletePackagingConfigurationErrorKind::UnprocessableEntityException(_inner) => {
                Some(_inner)
            }
            DeletePackagingConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeletePackagingGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeletePackagingGroupError {
    /// Kind of error that occurred.
    pub kind: DeletePackagingGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeletePackagingGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeletePackagingGroupErrorKind {
    /// The client is not authorized to access the requested resource.
    ForbiddenException(crate::error::ForbiddenException),
    /// An unexpected error occurred.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// The requested resource does not exist.
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error occurred.
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// The client has exceeded their resource or throttling limits.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// The parameters sent in the request are not valid.
    UnprocessableEntityException(crate::error::UnprocessableEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeletePackagingGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeletePackagingGroupErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeletePackagingGroupErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeletePackagingGroupErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeletePackagingGroupErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeletePackagingGroupErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeletePackagingGroupErrorKind::UnprocessableEntityException(_inner) => _inner.fmt(f),
            DeletePackagingGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeletePackagingGroupError {
    fn code(&self) -> Option<&str> {
        DeletePackagingGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeletePackagingGroupError {
    /// Creates a new `DeletePackagingGroupError`.
    pub fn new(kind: DeletePackagingGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeletePackagingGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeletePackagingGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeletePackagingGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeletePackagingGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeletePackagingGroupErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePackagingGroupErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePackagingGroupErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePackagingGroupErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePackagingGroupErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePackagingGroupErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePackagingGroupErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePackagingGroupErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePackagingGroupErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePackagingGroupErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePackagingGroupErrorKind::UnprocessableEntityException`.
    pub fn is_unprocessable_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePackagingGroupErrorKind::UnprocessableEntityException(_)
        )
    }
}
impl std::error::Error for DeletePackagingGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeletePackagingGroupErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeletePackagingGroupErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeletePackagingGroupErrorKind::NotFoundException(_inner) => Some(_inner),
            DeletePackagingGroupErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeletePackagingGroupErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeletePackagingGroupErrorKind::UnprocessableEntityException(_inner) => Some(_inner),
            DeletePackagingGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAsset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAssetError {
    /// Kind of error that occurred.
    pub kind: DescribeAssetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAsset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAssetErrorKind {
    /// The client is not authorized to access the requested resource.
    ForbiddenException(crate::error::ForbiddenException),
    /// An unexpected error occurred.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// The requested resource does not exist.
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error occurred.
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// The client has exceeded their resource or throttling limits.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// The parameters sent in the request are not valid.
    UnprocessableEntityException(crate::error::UnprocessableEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAssetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAssetErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DescribeAssetErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DescribeAssetErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeAssetErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeAssetErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DescribeAssetErrorKind::UnprocessableEntityException(_inner) => _inner.fmt(f),
            DescribeAssetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAssetError {
    fn code(&self) -> Option<&str> {
        DescribeAssetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAssetError {
    /// Creates a new `DescribeAssetError`.
    pub fn new(kind: DescribeAssetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAssetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAssetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAssetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAssetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAssetErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, DescribeAssetErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `DescribeAssetErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAssetErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAssetErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DescribeAssetErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DescribeAssetErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAssetErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAssetErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAssetErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAssetErrorKind::UnprocessableEntityException`.
    pub fn is_unprocessable_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAssetErrorKind::UnprocessableEntityException(_)
        )
    }
}
impl std::error::Error for DescribeAssetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAssetErrorKind::ForbiddenException(_inner) => Some(_inner),
            DescribeAssetErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DescribeAssetErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeAssetErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeAssetErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DescribeAssetErrorKind::UnprocessableEntityException(_inner) => Some(_inner),
            DescribeAssetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribePackagingConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribePackagingConfigurationError {
    /// Kind of error that occurred.
    pub kind: DescribePackagingConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribePackagingConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribePackagingConfigurationErrorKind {
    /// The client is not authorized to access the requested resource.
    ForbiddenException(crate::error::ForbiddenException),
    /// An unexpected error occurred.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// The requested resource does not exist.
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error occurred.
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// The client has exceeded their resource or throttling limits.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// The parameters sent in the request are not valid.
    UnprocessableEntityException(crate::error::UnprocessableEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribePackagingConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribePackagingConfigurationErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DescribePackagingConfigurationErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            DescribePackagingConfigurationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribePackagingConfigurationErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            DescribePackagingConfigurationErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            DescribePackagingConfigurationErrorKind::UnprocessableEntityException(_inner) => {
                _inner.fmt(f)
            }
            DescribePackagingConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribePackagingConfigurationError {
    fn code(&self) -> Option<&str> {
        DescribePackagingConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribePackagingConfigurationError {
    /// Creates a new `DescribePackagingConfigurationError`.
    pub fn new(
        kind: DescribePackagingConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribePackagingConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribePackagingConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribePackagingConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribePackagingConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribePackagingConfigurationErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePackagingConfigurationErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePackagingConfigurationErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePackagingConfigurationErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePackagingConfigurationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePackagingConfigurationErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePackagingConfigurationErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePackagingConfigurationErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePackagingConfigurationErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePackagingConfigurationErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePackagingConfigurationErrorKind::UnprocessableEntityException`.
    pub fn is_unprocessable_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePackagingConfigurationErrorKind::UnprocessableEntityException(_)
        )
    }
}
impl std::error::Error for DescribePackagingConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribePackagingConfigurationErrorKind::ForbiddenException(_inner) => Some(_inner),
            DescribePackagingConfigurationErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            DescribePackagingConfigurationErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribePackagingConfigurationErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            DescribePackagingConfigurationErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            DescribePackagingConfigurationErrorKind::UnprocessableEntityException(_inner) => {
                Some(_inner)
            }
            DescribePackagingConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribePackagingGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribePackagingGroupError {
    /// Kind of error that occurred.
    pub kind: DescribePackagingGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribePackagingGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribePackagingGroupErrorKind {
    /// The client is not authorized to access the requested resource.
    ForbiddenException(crate::error::ForbiddenException),
    /// An unexpected error occurred.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// The requested resource does not exist.
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error occurred.
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// The client has exceeded their resource or throttling limits.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// The parameters sent in the request are not valid.
    UnprocessableEntityException(crate::error::UnprocessableEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribePackagingGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribePackagingGroupErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DescribePackagingGroupErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DescribePackagingGroupErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribePackagingGroupErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribePackagingGroupErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DescribePackagingGroupErrorKind::UnprocessableEntityException(_inner) => _inner.fmt(f),
            DescribePackagingGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribePackagingGroupError {
    fn code(&self) -> Option<&str> {
        DescribePackagingGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribePackagingGroupError {
    /// Creates a new `DescribePackagingGroupError`.
    pub fn new(kind: DescribePackagingGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribePackagingGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribePackagingGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribePackagingGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribePackagingGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribePackagingGroupErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePackagingGroupErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePackagingGroupErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePackagingGroupErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePackagingGroupErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePackagingGroupErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePackagingGroupErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePackagingGroupErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePackagingGroupErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePackagingGroupErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePackagingGroupErrorKind::UnprocessableEntityException`.
    pub fn is_unprocessable_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePackagingGroupErrorKind::UnprocessableEntityException(_)
        )
    }
}
impl std::error::Error for DescribePackagingGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribePackagingGroupErrorKind::ForbiddenException(_inner) => Some(_inner),
            DescribePackagingGroupErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DescribePackagingGroupErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribePackagingGroupErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribePackagingGroupErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DescribePackagingGroupErrorKind::UnprocessableEntityException(_inner) => Some(_inner),
            DescribePackagingGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAssets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAssetsError {
    /// Kind of error that occurred.
    pub kind: ListAssetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAssets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAssetsErrorKind {
    /// The client is not authorized to access the requested resource.
    ForbiddenException(crate::error::ForbiddenException),
    /// An unexpected error occurred.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// The requested resource does not exist.
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error occurred.
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// The client has exceeded their resource or throttling limits.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// The parameters sent in the request are not valid.
    UnprocessableEntityException(crate::error::UnprocessableEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAssetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAssetsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListAssetsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListAssetsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListAssetsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListAssetsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListAssetsErrorKind::UnprocessableEntityException(_inner) => _inner.fmt(f),
            ListAssetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAssetsError {
    fn code(&self) -> Option<&str> {
        ListAssetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAssetsError {
    /// Creates a new `ListAssetsError`.
    pub fn new(kind: ListAssetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAssetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAssetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAssetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAssetsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAssetsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, ListAssetsErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `ListAssetsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAssetsErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAssetsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListAssetsErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `ListAssetsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAssetsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAssetsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, ListAssetsErrorKind::TooManyRequestsException(_))
    }
    /// Returns `true` if the error kind is `ListAssetsErrorKind::UnprocessableEntityException`.
    pub fn is_unprocessable_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAssetsErrorKind::UnprocessableEntityException(_)
        )
    }
}
impl std::error::Error for ListAssetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAssetsErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListAssetsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListAssetsErrorKind::NotFoundException(_inner) => Some(_inner),
            ListAssetsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListAssetsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListAssetsErrorKind::UnprocessableEntityException(_inner) => Some(_inner),
            ListAssetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPackagingConfigurations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPackagingConfigurationsError {
    /// Kind of error that occurred.
    pub kind: ListPackagingConfigurationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPackagingConfigurations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPackagingConfigurationsErrorKind {
    /// The client is not authorized to access the requested resource.
    ForbiddenException(crate::error::ForbiddenException),
    /// An unexpected error occurred.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// The requested resource does not exist.
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error occurred.
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// The client has exceeded their resource or throttling limits.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// The parameters sent in the request are not valid.
    UnprocessableEntityException(crate::error::UnprocessableEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPackagingConfigurationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPackagingConfigurationsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListPackagingConfigurationsErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            ListPackagingConfigurationsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListPackagingConfigurationsErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            ListPackagingConfigurationsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListPackagingConfigurationsErrorKind::UnprocessableEntityException(_inner) => {
                _inner.fmt(f)
            }
            ListPackagingConfigurationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPackagingConfigurationsError {
    fn code(&self) -> Option<&str> {
        ListPackagingConfigurationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPackagingConfigurationsError {
    /// Creates a new `ListPackagingConfigurationsError`.
    pub fn new(kind: ListPackagingConfigurationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPackagingConfigurationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPackagingConfigurationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPackagingConfigurationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPackagingConfigurationsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListPackagingConfigurationsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPackagingConfigurationsErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPackagingConfigurationsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPackagingConfigurationsErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPackagingConfigurationsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPackagingConfigurationsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPackagingConfigurationsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPackagingConfigurationsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPackagingConfigurationsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPackagingConfigurationsErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPackagingConfigurationsErrorKind::UnprocessableEntityException`.
    pub fn is_unprocessable_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPackagingConfigurationsErrorKind::UnprocessableEntityException(_)
        )
    }
}
impl std::error::Error for ListPackagingConfigurationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPackagingConfigurationsErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListPackagingConfigurationsErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            ListPackagingConfigurationsErrorKind::NotFoundException(_inner) => Some(_inner),
            ListPackagingConfigurationsErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            ListPackagingConfigurationsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListPackagingConfigurationsErrorKind::UnprocessableEntityException(_inner) => {
                Some(_inner)
            }
            ListPackagingConfigurationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPackagingGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPackagingGroupsError {
    /// Kind of error that occurred.
    pub kind: ListPackagingGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPackagingGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPackagingGroupsErrorKind {
    /// The client is not authorized to access the requested resource.
    ForbiddenException(crate::error::ForbiddenException),
    /// An unexpected error occurred.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// The requested resource does not exist.
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error occurred.
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// The client has exceeded their resource or throttling limits.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// The parameters sent in the request are not valid.
    UnprocessableEntityException(crate::error::UnprocessableEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPackagingGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPackagingGroupsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListPackagingGroupsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListPackagingGroupsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListPackagingGroupsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListPackagingGroupsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListPackagingGroupsErrorKind::UnprocessableEntityException(_inner) => _inner.fmt(f),
            ListPackagingGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPackagingGroupsError {
    fn code(&self) -> Option<&str> {
        ListPackagingGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPackagingGroupsError {
    /// Creates a new `ListPackagingGroupsError`.
    pub fn new(kind: ListPackagingGroupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPackagingGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPackagingGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPackagingGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPackagingGroupsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListPackagingGroupsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPackagingGroupsErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPackagingGroupsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPackagingGroupsErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPackagingGroupsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPackagingGroupsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPackagingGroupsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPackagingGroupsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPackagingGroupsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPackagingGroupsErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPackagingGroupsErrorKind::UnprocessableEntityException`.
    pub fn is_unprocessable_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPackagingGroupsErrorKind::UnprocessableEntityException(_)
        )
    }
}
impl std::error::Error for ListPackagingGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPackagingGroupsErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListPackagingGroupsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListPackagingGroupsErrorKind::NotFoundException(_inner) => Some(_inner),
            ListPackagingGroupsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListPackagingGroupsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListPackagingGroupsErrorKind::UnprocessableEntityException(_inner) => Some(_inner),
            ListPackagingGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdatePackagingGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdatePackagingGroupError {
    /// Kind of error that occurred.
    pub kind: UpdatePackagingGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdatePackagingGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdatePackagingGroupErrorKind {
    /// The client is not authorized to access the requested resource.
    ForbiddenException(crate::error::ForbiddenException),
    /// An unexpected error occurred.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// The requested resource does not exist.
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error occurred.
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// The client has exceeded their resource or throttling limits.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// The parameters sent in the request are not valid.
    UnprocessableEntityException(crate::error::UnprocessableEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdatePackagingGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdatePackagingGroupErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdatePackagingGroupErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdatePackagingGroupErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdatePackagingGroupErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            UpdatePackagingGroupErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdatePackagingGroupErrorKind::UnprocessableEntityException(_inner) => _inner.fmt(f),
            UpdatePackagingGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdatePackagingGroupError {
    fn code(&self) -> Option<&str> {
        UpdatePackagingGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdatePackagingGroupError {
    /// Creates a new `UpdatePackagingGroupError`.
    pub fn new(kind: UpdatePackagingGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdatePackagingGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdatePackagingGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdatePackagingGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdatePackagingGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdatePackagingGroupErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePackagingGroupErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePackagingGroupErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePackagingGroupErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePackagingGroupErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePackagingGroupErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePackagingGroupErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePackagingGroupErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePackagingGroupErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePackagingGroupErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePackagingGroupErrorKind::UnprocessableEntityException`.
    pub fn is_unprocessable_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePackagingGroupErrorKind::UnprocessableEntityException(_)
        )
    }
}
impl std::error::Error for UpdatePackagingGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdatePackagingGroupErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdatePackagingGroupErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdatePackagingGroupErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdatePackagingGroupErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            UpdatePackagingGroupErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdatePackagingGroupErrorKind::UnprocessableEntityException(_inner) => Some(_inner),
            UpdatePackagingGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// The parameters sent in the request are not valid.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnprocessableEntityException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnprocessableEntityException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnprocessableEntityException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnprocessableEntityException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnprocessableEntityException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnprocessableEntityException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnprocessableEntityException {}
/// See [`UnprocessableEntityException`](crate::error::UnprocessableEntityException)
pub mod unprocessable_entity_exception {
    /// A builder for [`UnprocessableEntityException`](crate::error::UnprocessableEntityException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnprocessableEntityException`](crate::error::UnprocessableEntityException)
        pub fn build(self) -> crate::error::UnprocessableEntityException {
            crate::error::UnprocessableEntityException {
                message: self.message,
            }
        }
    }
}
impl UnprocessableEntityException {
    /// Creates a new builder-style object to manufacture [`UnprocessableEntityException`](crate::error::UnprocessableEntityException)
    pub fn builder() -> crate::error::unprocessable_entity_exception::Builder {
        crate::error::unprocessable_entity_exception::Builder::default()
    }
}

/// The client has exceeded their resource or throttling limits.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyRequestsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyRequestsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyRequestsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyRequestsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyRequestsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyRequestsException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyRequestsException {}
/// See [`TooManyRequestsException`](crate::error::TooManyRequestsException)
pub mod too_many_requests_exception {
    /// A builder for [`TooManyRequestsException`](crate::error::TooManyRequestsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyRequestsException`](crate::error::TooManyRequestsException)
        pub fn build(self) -> crate::error::TooManyRequestsException {
            crate::error::TooManyRequestsException {
                message: self.message,
            }
        }
    }
}
impl TooManyRequestsException {
    /// Creates a new builder-style object to manufacture [`TooManyRequestsException`](crate::error::TooManyRequestsException)
    pub fn builder() -> crate::error::too_many_requests_exception::Builder {
        crate::error::too_many_requests_exception::Builder::default()
    }
}

/// An unexpected error occurred.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceUnavailableException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceUnavailableException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceUnavailableException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceUnavailableException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceUnavailableException {}
/// See [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
pub mod service_unavailable_exception {
    /// A builder for [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
        pub fn build(self) -> crate::error::ServiceUnavailableException {
            crate::error::ServiceUnavailableException {
                message: self.message,
            }
        }
    }
}
impl ServiceUnavailableException {
    /// Creates a new builder-style object to manufacture [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
    pub fn builder() -> crate::error::service_unavailable_exception::Builder {
        crate::error::service_unavailable_exception::Builder::default()
    }
}

/// The requested resource does not exist.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NotFoundException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for NotFoundException {}
/// See [`NotFoundException`](crate::error::NotFoundException)
pub mod not_found_exception {
    /// A builder for [`NotFoundException`](crate::error::NotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NotFoundException`](crate::error::NotFoundException)
        pub fn build(self) -> crate::error::NotFoundException {
            crate::error::NotFoundException {
                message: self.message,
            }
        }
    }
}
impl NotFoundException {
    /// Creates a new builder-style object to manufacture [`NotFoundException`](crate::error::NotFoundException)
    pub fn builder() -> crate::error::not_found_exception::Builder {
        crate::error::not_found_exception::Builder::default()
    }
}

/// An unexpected error occurred.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerErrorException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServerErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerErrorException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServerErrorException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerErrorException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerErrorException {}
/// See [`InternalServerErrorException`](crate::error::InternalServerErrorException)
pub mod internal_server_error_exception {
    /// A builder for [`InternalServerErrorException`](crate::error::InternalServerErrorException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerErrorException`](crate::error::InternalServerErrorException)
        pub fn build(self) -> crate::error::InternalServerErrorException {
            crate::error::InternalServerErrorException {
                message: self.message,
            }
        }
    }
}
impl InternalServerErrorException {
    /// Creates a new builder-style object to manufacture [`InternalServerErrorException`](crate::error::InternalServerErrorException)
    pub fn builder() -> crate::error::internal_server_error_exception::Builder {
        crate::error::internal_server_error_exception::Builder::default()
    }
}

/// The client is not authorized to access the requested resource.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ForbiddenException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ForbiddenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ForbiddenException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ForbiddenException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ForbiddenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ForbiddenException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for ForbiddenException {}
/// See [`ForbiddenException`](crate::error::ForbiddenException)
pub mod forbidden_exception {
    /// A builder for [`ForbiddenException`](crate::error::ForbiddenException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ForbiddenException`](crate::error::ForbiddenException)
        pub fn build(self) -> crate::error::ForbiddenException {
            crate::error::ForbiddenException {
                message: self.message,
            }
        }
    }
}
impl ForbiddenException {
    /// Creates a new builder-style object to manufacture [`ForbiddenException`](crate::error::ForbiddenException)
    pub fn builder() -> crate::error::forbidden_exception::Builder {
        crate::error::forbidden_exception::Builder::default()
    }
}
