// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePackagingGroupOutput {
    /// The ARN of the PackagingGroup.
    pub arn: std::option::Option<std::string::String>,
    /// CDN Authorization credentials
    pub authorization: std::option::Option<crate::model::Authorization>,
    /// The fully qualified domain name for Assets in the PackagingGroup.
    pub domain_name: std::option::Option<std::string::String>,
    /// Configure egress access logging.
    pub egress_access_logs: std::option::Option<crate::model::EgressAccessLogs>,
    /// The ID of the PackagingGroup.
    pub id: std::option::Option<std::string::String>,
    /// A collection of tags associated with a resource
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for UpdatePackagingGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePackagingGroupOutput");
        formatter.field("arn", &self.arn);
        formatter.field("authorization", &self.authorization);
        formatter.field("domain_name", &self.domain_name);
        formatter.field("egress_access_logs", &self.egress_access_logs);
        formatter.field("id", &self.id);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`UpdatePackagingGroupOutput`](crate::output::UpdatePackagingGroupOutput)
pub mod update_packaging_group_output {
    /// A builder for [`UpdatePackagingGroupOutput`](crate::output::UpdatePackagingGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) authorization: std::option::Option<crate::model::Authorization>,
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) egress_access_logs: std::option::Option<crate::model::EgressAccessLogs>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// The ARN of the PackagingGroup.
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// The ARN of the PackagingGroup.
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// CDN Authorization credentials
        pub fn authorization(mut self, input: crate::model::Authorization) -> Self {
            self.authorization = Some(input);
            self
        }
        /// CDN Authorization credentials
        pub fn set_authorization(
            mut self,
            input: std::option::Option<crate::model::Authorization>,
        ) -> Self {
            self.authorization = input;
            self
        }
        /// The fully qualified domain name for Assets in the PackagingGroup.
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// The fully qualified domain name for Assets in the PackagingGroup.
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Configure egress access logging.
        pub fn egress_access_logs(mut self, input: crate::model::EgressAccessLogs) -> Self {
            self.egress_access_logs = Some(input);
            self
        }
        /// Configure egress access logging.
        pub fn set_egress_access_logs(
            mut self,
            input: std::option::Option<crate::model::EgressAccessLogs>,
        ) -> Self {
            self.egress_access_logs = input;
            self
        }
        /// The ID of the PackagingGroup.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// The ID of the PackagingGroup.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of tags associated with a resource
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// A collection of tags associated with a resource
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdatePackagingGroupOutput`](crate::output::UpdatePackagingGroupOutput)
        pub fn build(self) -> crate::output::UpdatePackagingGroupOutput {
            crate::output::UpdatePackagingGroupOutput {
                arn: self.arn,
                authorization: self.authorization,
                domain_name: self.domain_name,
                egress_access_logs: self.egress_access_logs,
                id: self.id,
                tags: self.tags,
            }
        }
    }
}
impl UpdatePackagingGroupOutput {
    /// Creates a new builder-style object to manufacture [`UpdatePackagingGroupOutput`](crate::output::UpdatePackagingGroupOutput)
    pub fn builder() -> crate::output::update_packaging_group_output::Builder {
        crate::output::update_packaging_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// A collection of tags associated with a resource
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of tags associated with a resource
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// A collection of tags associated with a resource
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPackagingGroupsOutput {
    /// A token that can be used to resume pagination from the end of the collection.
    pub next_token: std::option::Option<std::string::String>,
    /// A list of MediaPackage VOD PackagingGroup resources.
    pub packaging_groups: std::option::Option<std::vec::Vec<crate::model::PackagingGroup>>,
}
impl std::fmt::Debug for ListPackagingGroupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPackagingGroupsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("packaging_groups", &self.packaging_groups);
        formatter.finish()
    }
}
/// See [`ListPackagingGroupsOutput`](crate::output::ListPackagingGroupsOutput)
pub mod list_packaging_groups_output {
    /// A builder for [`ListPackagingGroupsOutput`](crate::output::ListPackagingGroupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) packaging_groups:
            std::option::Option<std::vec::Vec<crate::model::PackagingGroup>>,
    }
    impl Builder {
        /// A token that can be used to resume pagination from the end of the collection.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// A token that can be used to resume pagination from the end of the collection.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `packaging_groups`.
        ///
        /// To override the contents of this collection use [`set_packaging_groups`](Self::set_packaging_groups).
        ///
        /// A list of MediaPackage VOD PackagingGroup resources.
        pub fn packaging_groups(mut self, input: impl Into<crate::model::PackagingGroup>) -> Self {
            let mut v = self.packaging_groups.unwrap_or_default();
            v.push(input.into());
            self.packaging_groups = Some(v);
            self
        }
        /// A list of MediaPackage VOD PackagingGroup resources.
        pub fn set_packaging_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PackagingGroup>>,
        ) -> Self {
            self.packaging_groups = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPackagingGroupsOutput`](crate::output::ListPackagingGroupsOutput)
        pub fn build(self) -> crate::output::ListPackagingGroupsOutput {
            crate::output::ListPackagingGroupsOutput {
                next_token: self.next_token,
                packaging_groups: self.packaging_groups,
            }
        }
    }
}
impl ListPackagingGroupsOutput {
    /// Creates a new builder-style object to manufacture [`ListPackagingGroupsOutput`](crate::output::ListPackagingGroupsOutput)
    pub fn builder() -> crate::output::list_packaging_groups_output::Builder {
        crate::output::list_packaging_groups_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPackagingConfigurationsOutput {
    /// A token that can be used to resume pagination from the end of the collection.
    pub next_token: std::option::Option<std::string::String>,
    /// A list of MediaPackage VOD PackagingConfiguration resources.
    pub packaging_configurations:
        std::option::Option<std::vec::Vec<crate::model::PackagingConfiguration>>,
}
impl std::fmt::Debug for ListPackagingConfigurationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPackagingConfigurationsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("packaging_configurations", &self.packaging_configurations);
        formatter.finish()
    }
}
/// See [`ListPackagingConfigurationsOutput`](crate::output::ListPackagingConfigurationsOutput)
pub mod list_packaging_configurations_output {
    /// A builder for [`ListPackagingConfigurationsOutput`](crate::output::ListPackagingConfigurationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) packaging_configurations:
            std::option::Option<std::vec::Vec<crate::model::PackagingConfiguration>>,
    }
    impl Builder {
        /// A token that can be used to resume pagination from the end of the collection.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// A token that can be used to resume pagination from the end of the collection.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `packaging_configurations`.
        ///
        /// To override the contents of this collection use [`set_packaging_configurations`](Self::set_packaging_configurations).
        ///
        /// A list of MediaPackage VOD PackagingConfiguration resources.
        pub fn packaging_configurations(
            mut self,
            input: impl Into<crate::model::PackagingConfiguration>,
        ) -> Self {
            let mut v = self.packaging_configurations.unwrap_or_default();
            v.push(input.into());
            self.packaging_configurations = Some(v);
            self
        }
        /// A list of MediaPackage VOD PackagingConfiguration resources.
        pub fn set_packaging_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PackagingConfiguration>>,
        ) -> Self {
            self.packaging_configurations = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPackagingConfigurationsOutput`](crate::output::ListPackagingConfigurationsOutput)
        pub fn build(self) -> crate::output::ListPackagingConfigurationsOutput {
            crate::output::ListPackagingConfigurationsOutput {
                next_token: self.next_token,
                packaging_configurations: self.packaging_configurations,
            }
        }
    }
}
impl ListPackagingConfigurationsOutput {
    /// Creates a new builder-style object to manufacture [`ListPackagingConfigurationsOutput`](crate::output::ListPackagingConfigurationsOutput)
    pub fn builder() -> crate::output::list_packaging_configurations_output::Builder {
        crate::output::list_packaging_configurations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAssetsOutput {
    /// A list of MediaPackage VOD Asset resources.
    pub assets: std::option::Option<std::vec::Vec<crate::model::AssetShallow>>,
    /// A token that can be used to resume pagination from the end of the collection.
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListAssetsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAssetsOutput");
        formatter.field("assets", &self.assets);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAssetsOutput`](crate::output::ListAssetsOutput)
pub mod list_assets_output {
    /// A builder for [`ListAssetsOutput`](crate::output::ListAssetsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assets: std::option::Option<std::vec::Vec<crate::model::AssetShallow>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `assets`.
        ///
        /// To override the contents of this collection use [`set_assets`](Self::set_assets).
        ///
        /// A list of MediaPackage VOD Asset resources.
        pub fn assets(mut self, input: impl Into<crate::model::AssetShallow>) -> Self {
            let mut v = self.assets.unwrap_or_default();
            v.push(input.into());
            self.assets = Some(v);
            self
        }
        /// A list of MediaPackage VOD Asset resources.
        pub fn set_assets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssetShallow>>,
        ) -> Self {
            self.assets = input;
            self
        }
        /// A token that can be used to resume pagination from the end of the collection.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// A token that can be used to resume pagination from the end of the collection.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAssetsOutput`](crate::output::ListAssetsOutput)
        pub fn build(self) -> crate::output::ListAssetsOutput {
            crate::output::ListAssetsOutput {
                assets: self.assets,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAssetsOutput {
    /// Creates a new builder-style object to manufacture [`ListAssetsOutput`](crate::output::ListAssetsOutput)
    pub fn builder() -> crate::output::list_assets_output::Builder {
        crate::output::list_assets_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePackagingGroupOutput {
    /// The ARN of the PackagingGroup.
    pub arn: std::option::Option<std::string::String>,
    /// CDN Authorization credentials
    pub authorization: std::option::Option<crate::model::Authorization>,
    /// The fully qualified domain name for Assets in the PackagingGroup.
    pub domain_name: std::option::Option<std::string::String>,
    /// Configure egress access logging.
    pub egress_access_logs: std::option::Option<crate::model::EgressAccessLogs>,
    /// The ID of the PackagingGroup.
    pub id: std::option::Option<std::string::String>,
    /// A collection of tags associated with a resource
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for DescribePackagingGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePackagingGroupOutput");
        formatter.field("arn", &self.arn);
        formatter.field("authorization", &self.authorization);
        formatter.field("domain_name", &self.domain_name);
        formatter.field("egress_access_logs", &self.egress_access_logs);
        formatter.field("id", &self.id);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`DescribePackagingGroupOutput`](crate::output::DescribePackagingGroupOutput)
pub mod describe_packaging_group_output {
    /// A builder for [`DescribePackagingGroupOutput`](crate::output::DescribePackagingGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) authorization: std::option::Option<crate::model::Authorization>,
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) egress_access_logs: std::option::Option<crate::model::EgressAccessLogs>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// The ARN of the PackagingGroup.
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// The ARN of the PackagingGroup.
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// CDN Authorization credentials
        pub fn authorization(mut self, input: crate::model::Authorization) -> Self {
            self.authorization = Some(input);
            self
        }
        /// CDN Authorization credentials
        pub fn set_authorization(
            mut self,
            input: std::option::Option<crate::model::Authorization>,
        ) -> Self {
            self.authorization = input;
            self
        }
        /// The fully qualified domain name for Assets in the PackagingGroup.
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// The fully qualified domain name for Assets in the PackagingGroup.
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Configure egress access logging.
        pub fn egress_access_logs(mut self, input: crate::model::EgressAccessLogs) -> Self {
            self.egress_access_logs = Some(input);
            self
        }
        /// Configure egress access logging.
        pub fn set_egress_access_logs(
            mut self,
            input: std::option::Option<crate::model::EgressAccessLogs>,
        ) -> Self {
            self.egress_access_logs = input;
            self
        }
        /// The ID of the PackagingGroup.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// The ID of the PackagingGroup.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of tags associated with a resource
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// A collection of tags associated with a resource
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePackagingGroupOutput`](crate::output::DescribePackagingGroupOutput)
        pub fn build(self) -> crate::output::DescribePackagingGroupOutput {
            crate::output::DescribePackagingGroupOutput {
                arn: self.arn,
                authorization: self.authorization,
                domain_name: self.domain_name,
                egress_access_logs: self.egress_access_logs,
                id: self.id,
                tags: self.tags,
            }
        }
    }
}
impl DescribePackagingGroupOutput {
    /// Creates a new builder-style object to manufacture [`DescribePackagingGroupOutput`](crate::output::DescribePackagingGroupOutput)
    pub fn builder() -> crate::output::describe_packaging_group_output::Builder {
        crate::output::describe_packaging_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePackagingConfigurationOutput {
    /// The ARN of the PackagingConfiguration.
    pub arn: std::option::Option<std::string::String>,
    /// A CMAF packaging configuration.
    pub cmaf_package: std::option::Option<crate::model::CmafPackage>,
    /// A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
    pub dash_package: std::option::Option<crate::model::DashPackage>,
    /// An HTTP Live Streaming (HLS) packaging configuration.
    pub hls_package: std::option::Option<crate::model::HlsPackage>,
    /// The ID of the PackagingConfiguration.
    pub id: std::option::Option<std::string::String>,
    /// A Microsoft Smooth Streaming (MSS) PackagingConfiguration.
    pub mss_package: std::option::Option<crate::model::MssPackage>,
    /// The ID of a PackagingGroup.
    pub packaging_group_id: std::option::Option<std::string::String>,
    /// A collection of tags associated with a resource
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for DescribePackagingConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePackagingConfigurationOutput");
        formatter.field("arn", &self.arn);
        formatter.field("cmaf_package", &self.cmaf_package);
        formatter.field("dash_package", &self.dash_package);
        formatter.field("hls_package", &self.hls_package);
        formatter.field("id", &self.id);
        formatter.field("mss_package", &self.mss_package);
        formatter.field("packaging_group_id", &self.packaging_group_id);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`DescribePackagingConfigurationOutput`](crate::output::DescribePackagingConfigurationOutput)
pub mod describe_packaging_configuration_output {
    /// A builder for [`DescribePackagingConfigurationOutput`](crate::output::DescribePackagingConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) cmaf_package: std::option::Option<crate::model::CmafPackage>,
        pub(crate) dash_package: std::option::Option<crate::model::DashPackage>,
        pub(crate) hls_package: std::option::Option<crate::model::HlsPackage>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) mss_package: std::option::Option<crate::model::MssPackage>,
        pub(crate) packaging_group_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// The ARN of the PackagingConfiguration.
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// The ARN of the PackagingConfiguration.
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// A CMAF packaging configuration.
        pub fn cmaf_package(mut self, input: crate::model::CmafPackage) -> Self {
            self.cmaf_package = Some(input);
            self
        }
        /// A CMAF packaging configuration.
        pub fn set_cmaf_package(
            mut self,
            input: std::option::Option<crate::model::CmafPackage>,
        ) -> Self {
            self.cmaf_package = input;
            self
        }
        /// A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
        pub fn dash_package(mut self, input: crate::model::DashPackage) -> Self {
            self.dash_package = Some(input);
            self
        }
        /// A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
        pub fn set_dash_package(
            mut self,
            input: std::option::Option<crate::model::DashPackage>,
        ) -> Self {
            self.dash_package = input;
            self
        }
        /// An HTTP Live Streaming (HLS) packaging configuration.
        pub fn hls_package(mut self, input: crate::model::HlsPackage) -> Self {
            self.hls_package = Some(input);
            self
        }
        /// An HTTP Live Streaming (HLS) packaging configuration.
        pub fn set_hls_package(
            mut self,
            input: std::option::Option<crate::model::HlsPackage>,
        ) -> Self {
            self.hls_package = input;
            self
        }
        /// The ID of the PackagingConfiguration.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// The ID of the PackagingConfiguration.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// A Microsoft Smooth Streaming (MSS) PackagingConfiguration.
        pub fn mss_package(mut self, input: crate::model::MssPackage) -> Self {
            self.mss_package = Some(input);
            self
        }
        /// A Microsoft Smooth Streaming (MSS) PackagingConfiguration.
        pub fn set_mss_package(
            mut self,
            input: std::option::Option<crate::model::MssPackage>,
        ) -> Self {
            self.mss_package = input;
            self
        }
        /// The ID of a PackagingGroup.
        pub fn packaging_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.packaging_group_id = Some(input.into());
            self
        }
        /// The ID of a PackagingGroup.
        pub fn set_packaging_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.packaging_group_id = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of tags associated with a resource
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// A collection of tags associated with a resource
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePackagingConfigurationOutput`](crate::output::DescribePackagingConfigurationOutput)
        pub fn build(self) -> crate::output::DescribePackagingConfigurationOutput {
            crate::output::DescribePackagingConfigurationOutput {
                arn: self.arn,
                cmaf_package: self.cmaf_package,
                dash_package: self.dash_package,
                hls_package: self.hls_package,
                id: self.id,
                mss_package: self.mss_package,
                packaging_group_id: self.packaging_group_id,
                tags: self.tags,
            }
        }
    }
}
impl DescribePackagingConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`DescribePackagingConfigurationOutput`](crate::output::DescribePackagingConfigurationOutput)
    pub fn builder() -> crate::output::describe_packaging_configuration_output::Builder {
        crate::output::describe_packaging_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAssetOutput {
    /// The ARN of the Asset.
    pub arn: std::option::Option<std::string::String>,
    /// The time the Asset was initially submitted for Ingest.
    pub created_at: std::option::Option<std::string::String>,
    /// The list of egress endpoints available for the Asset.
    pub egress_endpoints: std::option::Option<std::vec::Vec<crate::model::EgressEndpoint>>,
    /// The unique identifier for the Asset.
    pub id: std::option::Option<std::string::String>,
    /// The ID of the PackagingGroup for the Asset.
    pub packaging_group_id: std::option::Option<std::string::String>,
    /// The resource ID to include in SPEKE key requests.
    pub resource_id: std::option::Option<std::string::String>,
    /// ARN of the source object in S3.
    pub source_arn: std::option::Option<std::string::String>,
    /// The IAM role_arn used to access the source S3 bucket.
    pub source_role_arn: std::option::Option<std::string::String>,
    /// A collection of tags associated with a resource
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for DescribeAssetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAssetOutput");
        formatter.field("arn", &self.arn);
        formatter.field("created_at", &self.created_at);
        formatter.field("egress_endpoints", &self.egress_endpoints);
        formatter.field("id", &self.id);
        formatter.field("packaging_group_id", &self.packaging_group_id);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("source_arn", &self.source_arn);
        formatter.field("source_role_arn", &self.source_role_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`DescribeAssetOutput`](crate::output::DescribeAssetOutput)
pub mod describe_asset_output {
    /// A builder for [`DescribeAssetOutput`](crate::output::DescribeAssetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<std::string::String>,
        pub(crate) egress_endpoints:
            std::option::Option<std::vec::Vec<crate::model::EgressEndpoint>>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) packaging_group_id: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) source_arn: std::option::Option<std::string::String>,
        pub(crate) source_role_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// The ARN of the Asset.
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// The ARN of the Asset.
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// The time the Asset was initially submitted for Ingest.
        pub fn created_at(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_at = Some(input.into());
            self
        }
        /// The time the Asset was initially submitted for Ingest.
        pub fn set_created_at(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_at = input;
            self
        }
        /// Appends an item to `egress_endpoints`.
        ///
        /// To override the contents of this collection use [`set_egress_endpoints`](Self::set_egress_endpoints).
        ///
        /// The list of egress endpoints available for the Asset.
        pub fn egress_endpoints(mut self, input: impl Into<crate::model::EgressEndpoint>) -> Self {
            let mut v = self.egress_endpoints.unwrap_or_default();
            v.push(input.into());
            self.egress_endpoints = Some(v);
            self
        }
        /// The list of egress endpoints available for the Asset.
        pub fn set_egress_endpoints(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EgressEndpoint>>,
        ) -> Self {
            self.egress_endpoints = input;
            self
        }
        /// The unique identifier for the Asset.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// The unique identifier for the Asset.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// The ID of the PackagingGroup for the Asset.
        pub fn packaging_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.packaging_group_id = Some(input.into());
            self
        }
        /// The ID of the PackagingGroup for the Asset.
        pub fn set_packaging_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.packaging_group_id = input;
            self
        }
        /// The resource ID to include in SPEKE key requests.
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// The resource ID to include in SPEKE key requests.
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// ARN of the source object in S3.
        pub fn source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_arn = Some(input.into());
            self
        }
        /// ARN of the source object in S3.
        pub fn set_source_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_arn = input;
            self
        }
        /// The IAM role_arn used to access the source S3 bucket.
        pub fn source_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_role_arn = Some(input.into());
            self
        }
        /// The IAM role_arn used to access the source S3 bucket.
        pub fn set_source_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_role_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of tags associated with a resource
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// A collection of tags associated with a resource
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAssetOutput`](crate::output::DescribeAssetOutput)
        pub fn build(self) -> crate::output::DescribeAssetOutput {
            crate::output::DescribeAssetOutput {
                arn: self.arn,
                created_at: self.created_at,
                egress_endpoints: self.egress_endpoints,
                id: self.id,
                packaging_group_id: self.packaging_group_id,
                resource_id: self.resource_id,
                source_arn: self.source_arn,
                source_role_arn: self.source_role_arn,
                tags: self.tags,
            }
        }
    }
}
impl DescribeAssetOutput {
    /// Creates a new builder-style object to manufacture [`DescribeAssetOutput`](crate::output::DescribeAssetOutput)
    pub fn builder() -> crate::output::describe_asset_output::Builder {
        crate::output::describe_asset_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePackagingGroupOutput {}
impl std::fmt::Debug for DeletePackagingGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePackagingGroupOutput");
        formatter.finish()
    }
}
/// See [`DeletePackagingGroupOutput`](crate::output::DeletePackagingGroupOutput)
pub mod delete_packaging_group_output {
    /// A builder for [`DeletePackagingGroupOutput`](crate::output::DeletePackagingGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeletePackagingGroupOutput`](crate::output::DeletePackagingGroupOutput)
        pub fn build(self) -> crate::output::DeletePackagingGroupOutput {
            crate::output::DeletePackagingGroupOutput {}
        }
    }
}
impl DeletePackagingGroupOutput {
    /// Creates a new builder-style object to manufacture [`DeletePackagingGroupOutput`](crate::output::DeletePackagingGroupOutput)
    pub fn builder() -> crate::output::delete_packaging_group_output::Builder {
        crate::output::delete_packaging_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePackagingConfigurationOutput {}
impl std::fmt::Debug for DeletePackagingConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePackagingConfigurationOutput");
        formatter.finish()
    }
}
/// See [`DeletePackagingConfigurationOutput`](crate::output::DeletePackagingConfigurationOutput)
pub mod delete_packaging_configuration_output {
    /// A builder for [`DeletePackagingConfigurationOutput`](crate::output::DeletePackagingConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeletePackagingConfigurationOutput`](crate::output::DeletePackagingConfigurationOutput)
        pub fn build(self) -> crate::output::DeletePackagingConfigurationOutput {
            crate::output::DeletePackagingConfigurationOutput {}
        }
    }
}
impl DeletePackagingConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`DeletePackagingConfigurationOutput`](crate::output::DeletePackagingConfigurationOutput)
    pub fn builder() -> crate::output::delete_packaging_configuration_output::Builder {
        crate::output::delete_packaging_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAssetOutput {}
impl std::fmt::Debug for DeleteAssetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAssetOutput");
        formatter.finish()
    }
}
/// See [`DeleteAssetOutput`](crate::output::DeleteAssetOutput)
pub mod delete_asset_output {
    /// A builder for [`DeleteAssetOutput`](crate::output::DeleteAssetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteAssetOutput`](crate::output::DeleteAssetOutput)
        pub fn build(self) -> crate::output::DeleteAssetOutput {
            crate::output::DeleteAssetOutput {}
        }
    }
}
impl DeleteAssetOutput {
    /// Creates a new builder-style object to manufacture [`DeleteAssetOutput`](crate::output::DeleteAssetOutput)
    pub fn builder() -> crate::output::delete_asset_output::Builder {
        crate::output::delete_asset_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePackagingGroupOutput {
    /// The ARN of the PackagingGroup.
    pub arn: std::option::Option<std::string::String>,
    /// CDN Authorization credentials
    pub authorization: std::option::Option<crate::model::Authorization>,
    /// The fully qualified domain name for Assets in the PackagingGroup.
    pub domain_name: std::option::Option<std::string::String>,
    /// Configure egress access logging.
    pub egress_access_logs: std::option::Option<crate::model::EgressAccessLogs>,
    /// The ID of the PackagingGroup.
    pub id: std::option::Option<std::string::String>,
    /// A collection of tags associated with a resource
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for CreatePackagingGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePackagingGroupOutput");
        formatter.field("arn", &self.arn);
        formatter.field("authorization", &self.authorization);
        formatter.field("domain_name", &self.domain_name);
        formatter.field("egress_access_logs", &self.egress_access_logs);
        formatter.field("id", &self.id);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`CreatePackagingGroupOutput`](crate::output::CreatePackagingGroupOutput)
pub mod create_packaging_group_output {
    /// A builder for [`CreatePackagingGroupOutput`](crate::output::CreatePackagingGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) authorization: std::option::Option<crate::model::Authorization>,
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) egress_access_logs: std::option::Option<crate::model::EgressAccessLogs>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// The ARN of the PackagingGroup.
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// The ARN of the PackagingGroup.
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// CDN Authorization credentials
        pub fn authorization(mut self, input: crate::model::Authorization) -> Self {
            self.authorization = Some(input);
            self
        }
        /// CDN Authorization credentials
        pub fn set_authorization(
            mut self,
            input: std::option::Option<crate::model::Authorization>,
        ) -> Self {
            self.authorization = input;
            self
        }
        /// The fully qualified domain name for Assets in the PackagingGroup.
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// The fully qualified domain name for Assets in the PackagingGroup.
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Configure egress access logging.
        pub fn egress_access_logs(mut self, input: crate::model::EgressAccessLogs) -> Self {
            self.egress_access_logs = Some(input);
            self
        }
        /// Configure egress access logging.
        pub fn set_egress_access_logs(
            mut self,
            input: std::option::Option<crate::model::EgressAccessLogs>,
        ) -> Self {
            self.egress_access_logs = input;
            self
        }
        /// The ID of the PackagingGroup.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// The ID of the PackagingGroup.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of tags associated with a resource
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// A collection of tags associated with a resource
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePackagingGroupOutput`](crate::output::CreatePackagingGroupOutput)
        pub fn build(self) -> crate::output::CreatePackagingGroupOutput {
            crate::output::CreatePackagingGroupOutput {
                arn: self.arn,
                authorization: self.authorization,
                domain_name: self.domain_name,
                egress_access_logs: self.egress_access_logs,
                id: self.id,
                tags: self.tags,
            }
        }
    }
}
impl CreatePackagingGroupOutput {
    /// Creates a new builder-style object to manufacture [`CreatePackagingGroupOutput`](crate::output::CreatePackagingGroupOutput)
    pub fn builder() -> crate::output::create_packaging_group_output::Builder {
        crate::output::create_packaging_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePackagingConfigurationOutput {
    /// The ARN of the PackagingConfiguration.
    pub arn: std::option::Option<std::string::String>,
    /// A CMAF packaging configuration.
    pub cmaf_package: std::option::Option<crate::model::CmafPackage>,
    /// A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
    pub dash_package: std::option::Option<crate::model::DashPackage>,
    /// An HTTP Live Streaming (HLS) packaging configuration.
    pub hls_package: std::option::Option<crate::model::HlsPackage>,
    /// The ID of the PackagingConfiguration.
    pub id: std::option::Option<std::string::String>,
    /// A Microsoft Smooth Streaming (MSS) PackagingConfiguration.
    pub mss_package: std::option::Option<crate::model::MssPackage>,
    /// The ID of a PackagingGroup.
    pub packaging_group_id: std::option::Option<std::string::String>,
    /// A collection of tags associated with a resource
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for CreatePackagingConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePackagingConfigurationOutput");
        formatter.field("arn", &self.arn);
        formatter.field("cmaf_package", &self.cmaf_package);
        formatter.field("dash_package", &self.dash_package);
        formatter.field("hls_package", &self.hls_package);
        formatter.field("id", &self.id);
        formatter.field("mss_package", &self.mss_package);
        formatter.field("packaging_group_id", &self.packaging_group_id);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`CreatePackagingConfigurationOutput`](crate::output::CreatePackagingConfigurationOutput)
pub mod create_packaging_configuration_output {
    /// A builder for [`CreatePackagingConfigurationOutput`](crate::output::CreatePackagingConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) cmaf_package: std::option::Option<crate::model::CmafPackage>,
        pub(crate) dash_package: std::option::Option<crate::model::DashPackage>,
        pub(crate) hls_package: std::option::Option<crate::model::HlsPackage>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) mss_package: std::option::Option<crate::model::MssPackage>,
        pub(crate) packaging_group_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// The ARN of the PackagingConfiguration.
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// The ARN of the PackagingConfiguration.
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// A CMAF packaging configuration.
        pub fn cmaf_package(mut self, input: crate::model::CmafPackage) -> Self {
            self.cmaf_package = Some(input);
            self
        }
        /// A CMAF packaging configuration.
        pub fn set_cmaf_package(
            mut self,
            input: std::option::Option<crate::model::CmafPackage>,
        ) -> Self {
            self.cmaf_package = input;
            self
        }
        /// A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
        pub fn dash_package(mut self, input: crate::model::DashPackage) -> Self {
            self.dash_package = Some(input);
            self
        }
        /// A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
        pub fn set_dash_package(
            mut self,
            input: std::option::Option<crate::model::DashPackage>,
        ) -> Self {
            self.dash_package = input;
            self
        }
        /// An HTTP Live Streaming (HLS) packaging configuration.
        pub fn hls_package(mut self, input: crate::model::HlsPackage) -> Self {
            self.hls_package = Some(input);
            self
        }
        /// An HTTP Live Streaming (HLS) packaging configuration.
        pub fn set_hls_package(
            mut self,
            input: std::option::Option<crate::model::HlsPackage>,
        ) -> Self {
            self.hls_package = input;
            self
        }
        /// The ID of the PackagingConfiguration.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// The ID of the PackagingConfiguration.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// A Microsoft Smooth Streaming (MSS) PackagingConfiguration.
        pub fn mss_package(mut self, input: crate::model::MssPackage) -> Self {
            self.mss_package = Some(input);
            self
        }
        /// A Microsoft Smooth Streaming (MSS) PackagingConfiguration.
        pub fn set_mss_package(
            mut self,
            input: std::option::Option<crate::model::MssPackage>,
        ) -> Self {
            self.mss_package = input;
            self
        }
        /// The ID of a PackagingGroup.
        pub fn packaging_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.packaging_group_id = Some(input.into());
            self
        }
        /// The ID of a PackagingGroup.
        pub fn set_packaging_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.packaging_group_id = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of tags associated with a resource
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// A collection of tags associated with a resource
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePackagingConfigurationOutput`](crate::output::CreatePackagingConfigurationOutput)
        pub fn build(self) -> crate::output::CreatePackagingConfigurationOutput {
            crate::output::CreatePackagingConfigurationOutput {
                arn: self.arn,
                cmaf_package: self.cmaf_package,
                dash_package: self.dash_package,
                hls_package: self.hls_package,
                id: self.id,
                mss_package: self.mss_package,
                packaging_group_id: self.packaging_group_id,
                tags: self.tags,
            }
        }
    }
}
impl CreatePackagingConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`CreatePackagingConfigurationOutput`](crate::output::CreatePackagingConfigurationOutput)
    pub fn builder() -> crate::output::create_packaging_configuration_output::Builder {
        crate::output::create_packaging_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAssetOutput {
    /// The ARN of the Asset.
    pub arn: std::option::Option<std::string::String>,
    /// The time the Asset was initially submitted for Ingest.
    pub created_at: std::option::Option<std::string::String>,
    /// The list of egress endpoints available for the Asset.
    pub egress_endpoints: std::option::Option<std::vec::Vec<crate::model::EgressEndpoint>>,
    /// The unique identifier for the Asset.
    pub id: std::option::Option<std::string::String>,
    /// The ID of the PackagingGroup for the Asset.
    pub packaging_group_id: std::option::Option<std::string::String>,
    /// The resource ID to include in SPEKE key requests.
    pub resource_id: std::option::Option<std::string::String>,
    /// ARN of the source object in S3.
    pub source_arn: std::option::Option<std::string::String>,
    /// The IAM role_arn used to access the source S3 bucket.
    pub source_role_arn: std::option::Option<std::string::String>,
    /// A collection of tags associated with a resource
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for CreateAssetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAssetOutput");
        formatter.field("arn", &self.arn);
        formatter.field("created_at", &self.created_at);
        formatter.field("egress_endpoints", &self.egress_endpoints);
        formatter.field("id", &self.id);
        formatter.field("packaging_group_id", &self.packaging_group_id);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("source_arn", &self.source_arn);
        formatter.field("source_role_arn", &self.source_role_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`CreateAssetOutput`](crate::output::CreateAssetOutput)
pub mod create_asset_output {
    /// A builder for [`CreateAssetOutput`](crate::output::CreateAssetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<std::string::String>,
        pub(crate) egress_endpoints:
            std::option::Option<std::vec::Vec<crate::model::EgressEndpoint>>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) packaging_group_id: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) source_arn: std::option::Option<std::string::String>,
        pub(crate) source_role_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// The ARN of the Asset.
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// The ARN of the Asset.
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// The time the Asset was initially submitted for Ingest.
        pub fn created_at(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_at = Some(input.into());
            self
        }
        /// The time the Asset was initially submitted for Ingest.
        pub fn set_created_at(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_at = input;
            self
        }
        /// Appends an item to `egress_endpoints`.
        ///
        /// To override the contents of this collection use [`set_egress_endpoints`](Self::set_egress_endpoints).
        ///
        /// The list of egress endpoints available for the Asset.
        pub fn egress_endpoints(mut self, input: impl Into<crate::model::EgressEndpoint>) -> Self {
            let mut v = self.egress_endpoints.unwrap_or_default();
            v.push(input.into());
            self.egress_endpoints = Some(v);
            self
        }
        /// The list of egress endpoints available for the Asset.
        pub fn set_egress_endpoints(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EgressEndpoint>>,
        ) -> Self {
            self.egress_endpoints = input;
            self
        }
        /// The unique identifier for the Asset.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// The unique identifier for the Asset.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// The ID of the PackagingGroup for the Asset.
        pub fn packaging_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.packaging_group_id = Some(input.into());
            self
        }
        /// The ID of the PackagingGroup for the Asset.
        pub fn set_packaging_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.packaging_group_id = input;
            self
        }
        /// The resource ID to include in SPEKE key requests.
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// The resource ID to include in SPEKE key requests.
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// ARN of the source object in S3.
        pub fn source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_arn = Some(input.into());
            self
        }
        /// ARN of the source object in S3.
        pub fn set_source_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_arn = input;
            self
        }
        /// The IAM role_arn used to access the source S3 bucket.
        pub fn source_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_role_arn = Some(input.into());
            self
        }
        /// The IAM role_arn used to access the source S3 bucket.
        pub fn set_source_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_role_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of tags associated with a resource
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// A collection of tags associated with a resource
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAssetOutput`](crate::output::CreateAssetOutput)
        pub fn build(self) -> crate::output::CreateAssetOutput {
            crate::output::CreateAssetOutput {
                arn: self.arn,
                created_at: self.created_at,
                egress_endpoints: self.egress_endpoints,
                id: self.id,
                packaging_group_id: self.packaging_group_id,
                resource_id: self.resource_id,
                source_arn: self.source_arn,
                source_role_arn: self.source_role_arn,
                tags: self.tags,
            }
        }
    }
}
impl CreateAssetOutput {
    /// Creates a new builder-style object to manufacture [`CreateAssetOutput`](crate::output::CreateAssetOutput)
    pub fn builder() -> crate::output::create_asset_output::Builder {
        crate::output::create_asset_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConfigureLogsOutput {
    /// The ARN of the PackagingGroup.
    pub arn: std::option::Option<std::string::String>,
    /// CDN Authorization credentials
    pub authorization: std::option::Option<crate::model::Authorization>,
    /// The fully qualified domain name for Assets in the PackagingGroup.
    pub domain_name: std::option::Option<std::string::String>,
    /// Configure egress access logging.
    pub egress_access_logs: std::option::Option<crate::model::EgressAccessLogs>,
    /// The ID of the PackagingGroup.
    pub id: std::option::Option<std::string::String>,
    /// A collection of tags associated with a resource
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for ConfigureLogsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConfigureLogsOutput");
        formatter.field("arn", &self.arn);
        formatter.field("authorization", &self.authorization);
        formatter.field("domain_name", &self.domain_name);
        formatter.field("egress_access_logs", &self.egress_access_logs);
        formatter.field("id", &self.id);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ConfigureLogsOutput`](crate::output::ConfigureLogsOutput)
pub mod configure_logs_output {
    /// A builder for [`ConfigureLogsOutput`](crate::output::ConfigureLogsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) authorization: std::option::Option<crate::model::Authorization>,
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) egress_access_logs: std::option::Option<crate::model::EgressAccessLogs>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// The ARN of the PackagingGroup.
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// The ARN of the PackagingGroup.
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// CDN Authorization credentials
        pub fn authorization(mut self, input: crate::model::Authorization) -> Self {
            self.authorization = Some(input);
            self
        }
        /// CDN Authorization credentials
        pub fn set_authorization(
            mut self,
            input: std::option::Option<crate::model::Authorization>,
        ) -> Self {
            self.authorization = input;
            self
        }
        /// The fully qualified domain name for Assets in the PackagingGroup.
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// The fully qualified domain name for Assets in the PackagingGroup.
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Configure egress access logging.
        pub fn egress_access_logs(mut self, input: crate::model::EgressAccessLogs) -> Self {
            self.egress_access_logs = Some(input);
            self
        }
        /// Configure egress access logging.
        pub fn set_egress_access_logs(
            mut self,
            input: std::option::Option<crate::model::EgressAccessLogs>,
        ) -> Self {
            self.egress_access_logs = input;
            self
        }
        /// The ID of the PackagingGroup.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// The ID of the PackagingGroup.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of tags associated with a resource
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// A collection of tags associated with a resource
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ConfigureLogsOutput`](crate::output::ConfigureLogsOutput)
        pub fn build(self) -> crate::output::ConfigureLogsOutput {
            crate::output::ConfigureLogsOutput {
                arn: self.arn,
                authorization: self.authorization,
                domain_name: self.domain_name,
                egress_access_logs: self.egress_access_logs,
                id: self.id,
                tags: self.tags,
            }
        }
    }
}
impl ConfigureLogsOutput {
    /// Creates a new builder-style object to manufacture [`ConfigureLogsOutput`](crate::output::ConfigureLogsOutput)
    pub fn builder() -> crate::output::configure_logs_output::Builder {
        crate::output::configure_logs_output::Builder::default()
    }
}
