// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Configure egress access logging.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EgressAccessLogs {
    /// Customize the log group name.
    pub log_group_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for EgressAccessLogs {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EgressAccessLogs");
        formatter.field("log_group_name", &self.log_group_name);
        formatter.finish()
    }
}
/// See [`EgressAccessLogs`](crate::model::EgressAccessLogs)
pub mod egress_access_logs {
    /// A builder for [`EgressAccessLogs`](crate::model::EgressAccessLogs)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) log_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Customize the log group name.
        pub fn log_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_group_name = Some(input.into());
            self
        }
        /// Customize the log group name.
        pub fn set_log_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.log_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`EgressAccessLogs`](crate::model::EgressAccessLogs)
        pub fn build(self) -> crate::model::EgressAccessLogs {
            crate::model::EgressAccessLogs {
                log_group_name: self.log_group_name,
            }
        }
    }
}
impl EgressAccessLogs {
    /// Creates a new builder-style object to manufacture [`EgressAccessLogs`](crate::model::EgressAccessLogs)
    pub fn builder() -> crate::model::egress_access_logs::Builder {
        crate::model::egress_access_logs::Builder::default()
    }
}

/// CDN Authorization credentials
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Authorization {
    /// The Amazon Resource Name (ARN) for the secret in AWS Secrets Manager that is used for CDN authorization.
    pub cdn_identifier_secret: std::option::Option<std::string::String>,
    /// The Amazon Resource Name (ARN) for the IAM role that allows MediaPackage to communicate with AWS Secrets Manager.
    pub secrets_role_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Authorization {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Authorization");
        formatter.field("cdn_identifier_secret", &self.cdn_identifier_secret);
        formatter.field("secrets_role_arn", &self.secrets_role_arn);
        formatter.finish()
    }
}
/// See [`Authorization`](crate::model::Authorization)
pub mod authorization {
    /// A builder for [`Authorization`](crate::model::Authorization)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cdn_identifier_secret: std::option::Option<std::string::String>,
        pub(crate) secrets_role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The Amazon Resource Name (ARN) for the secret in AWS Secrets Manager that is used for CDN authorization.
        pub fn cdn_identifier_secret(mut self, input: impl Into<std::string::String>) -> Self {
            self.cdn_identifier_secret = Some(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) for the secret in AWS Secrets Manager that is used for CDN authorization.
        pub fn set_cdn_identifier_secret(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cdn_identifier_secret = input;
            self
        }
        /// The Amazon Resource Name (ARN) for the IAM role that allows MediaPackage to communicate with AWS Secrets Manager.
        pub fn secrets_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.secrets_role_arn = Some(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) for the IAM role that allows MediaPackage to communicate with AWS Secrets Manager.
        pub fn set_secrets_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.secrets_role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`Authorization`](crate::model::Authorization)
        pub fn build(self) -> crate::model::Authorization {
            crate::model::Authorization {
                cdn_identifier_secret: self.cdn_identifier_secret,
                secrets_role_arn: self.secrets_role_arn,
            }
        }
    }
}
impl Authorization {
    /// Creates a new builder-style object to manufacture [`Authorization`](crate::model::Authorization)
    pub fn builder() -> crate::model::authorization::Builder {
        crate::model::authorization::Builder::default()
    }
}

/// A MediaPackage VOD PackagingGroup resource.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PackagingGroup {
    /// The ARN of the PackagingGroup.
    pub arn: std::option::Option<std::string::String>,
    /// CDN Authorization credentials
    pub authorization: std::option::Option<crate::model::Authorization>,
    /// The fully qualified domain name for Assets in the PackagingGroup.
    pub domain_name: std::option::Option<std::string::String>,
    /// Configure egress access logging.
    pub egress_access_logs: std::option::Option<crate::model::EgressAccessLogs>,
    /// The ID of the PackagingGroup.
    pub id: std::option::Option<std::string::String>,
    /// A collection of tags associated with a resource
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for PackagingGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PackagingGroup");
        formatter.field("arn", &self.arn);
        formatter.field("authorization", &self.authorization);
        formatter.field("domain_name", &self.domain_name);
        formatter.field("egress_access_logs", &self.egress_access_logs);
        formatter.field("id", &self.id);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`PackagingGroup`](crate::model::PackagingGroup)
pub mod packaging_group {
    /// A builder for [`PackagingGroup`](crate::model::PackagingGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) authorization: std::option::Option<crate::model::Authorization>,
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) egress_access_logs: std::option::Option<crate::model::EgressAccessLogs>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// The ARN of the PackagingGroup.
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// The ARN of the PackagingGroup.
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// CDN Authorization credentials
        pub fn authorization(mut self, input: crate::model::Authorization) -> Self {
            self.authorization = Some(input);
            self
        }
        /// CDN Authorization credentials
        pub fn set_authorization(
            mut self,
            input: std::option::Option<crate::model::Authorization>,
        ) -> Self {
            self.authorization = input;
            self
        }
        /// The fully qualified domain name for Assets in the PackagingGroup.
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// The fully qualified domain name for Assets in the PackagingGroup.
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Configure egress access logging.
        pub fn egress_access_logs(mut self, input: crate::model::EgressAccessLogs) -> Self {
            self.egress_access_logs = Some(input);
            self
        }
        /// Configure egress access logging.
        pub fn set_egress_access_logs(
            mut self,
            input: std::option::Option<crate::model::EgressAccessLogs>,
        ) -> Self {
            self.egress_access_logs = input;
            self
        }
        /// The ID of the PackagingGroup.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// The ID of the PackagingGroup.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of tags associated with a resource
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// A collection of tags associated with a resource
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`PackagingGroup`](crate::model::PackagingGroup)
        pub fn build(self) -> crate::model::PackagingGroup {
            crate::model::PackagingGroup {
                arn: self.arn,
                authorization: self.authorization,
                domain_name: self.domain_name,
                egress_access_logs: self.egress_access_logs,
                id: self.id,
                tags: self.tags,
            }
        }
    }
}
impl PackagingGroup {
    /// Creates a new builder-style object to manufacture [`PackagingGroup`](crate::model::PackagingGroup)
    pub fn builder() -> crate::model::packaging_group::Builder {
        crate::model::packaging_group::Builder::default()
    }
}

/// A MediaPackage VOD PackagingConfiguration resource.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PackagingConfiguration {
    /// The ARN of the PackagingConfiguration.
    pub arn: std::option::Option<std::string::String>,
    /// A CMAF packaging configuration.
    pub cmaf_package: std::option::Option<crate::model::CmafPackage>,
    /// A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
    pub dash_package: std::option::Option<crate::model::DashPackage>,
    /// An HTTP Live Streaming (HLS) packaging configuration.
    pub hls_package: std::option::Option<crate::model::HlsPackage>,
    /// The ID of the PackagingConfiguration.
    pub id: std::option::Option<std::string::String>,
    /// A Microsoft Smooth Streaming (MSS) PackagingConfiguration.
    pub mss_package: std::option::Option<crate::model::MssPackage>,
    /// The ID of a PackagingGroup.
    pub packaging_group_id: std::option::Option<std::string::String>,
    /// A collection of tags associated with a resource
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for PackagingConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PackagingConfiguration");
        formatter.field("arn", &self.arn);
        formatter.field("cmaf_package", &self.cmaf_package);
        formatter.field("dash_package", &self.dash_package);
        formatter.field("hls_package", &self.hls_package);
        formatter.field("id", &self.id);
        formatter.field("mss_package", &self.mss_package);
        formatter.field("packaging_group_id", &self.packaging_group_id);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`PackagingConfiguration`](crate::model::PackagingConfiguration)
pub mod packaging_configuration {
    /// A builder for [`PackagingConfiguration`](crate::model::PackagingConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) cmaf_package: std::option::Option<crate::model::CmafPackage>,
        pub(crate) dash_package: std::option::Option<crate::model::DashPackage>,
        pub(crate) hls_package: std::option::Option<crate::model::HlsPackage>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) mss_package: std::option::Option<crate::model::MssPackage>,
        pub(crate) packaging_group_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// The ARN of the PackagingConfiguration.
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// The ARN of the PackagingConfiguration.
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// A CMAF packaging configuration.
        pub fn cmaf_package(mut self, input: crate::model::CmafPackage) -> Self {
            self.cmaf_package = Some(input);
            self
        }
        /// A CMAF packaging configuration.
        pub fn set_cmaf_package(
            mut self,
            input: std::option::Option<crate::model::CmafPackage>,
        ) -> Self {
            self.cmaf_package = input;
            self
        }
        /// A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
        pub fn dash_package(mut self, input: crate::model::DashPackage) -> Self {
            self.dash_package = Some(input);
            self
        }
        /// A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
        pub fn set_dash_package(
            mut self,
            input: std::option::Option<crate::model::DashPackage>,
        ) -> Self {
            self.dash_package = input;
            self
        }
        /// An HTTP Live Streaming (HLS) packaging configuration.
        pub fn hls_package(mut self, input: crate::model::HlsPackage) -> Self {
            self.hls_package = Some(input);
            self
        }
        /// An HTTP Live Streaming (HLS) packaging configuration.
        pub fn set_hls_package(
            mut self,
            input: std::option::Option<crate::model::HlsPackage>,
        ) -> Self {
            self.hls_package = input;
            self
        }
        /// The ID of the PackagingConfiguration.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// The ID of the PackagingConfiguration.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// A Microsoft Smooth Streaming (MSS) PackagingConfiguration.
        pub fn mss_package(mut self, input: crate::model::MssPackage) -> Self {
            self.mss_package = Some(input);
            self
        }
        /// A Microsoft Smooth Streaming (MSS) PackagingConfiguration.
        pub fn set_mss_package(
            mut self,
            input: std::option::Option<crate::model::MssPackage>,
        ) -> Self {
            self.mss_package = input;
            self
        }
        /// The ID of a PackagingGroup.
        pub fn packaging_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.packaging_group_id = Some(input.into());
            self
        }
        /// The ID of a PackagingGroup.
        pub fn set_packaging_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.packaging_group_id = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of tags associated with a resource
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// A collection of tags associated with a resource
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`PackagingConfiguration`](crate::model::PackagingConfiguration)
        pub fn build(self) -> crate::model::PackagingConfiguration {
            crate::model::PackagingConfiguration {
                arn: self.arn,
                cmaf_package: self.cmaf_package,
                dash_package: self.dash_package,
                hls_package: self.hls_package,
                id: self.id,
                mss_package: self.mss_package,
                packaging_group_id: self.packaging_group_id,
                tags: self.tags,
            }
        }
    }
}
impl PackagingConfiguration {
    /// Creates a new builder-style object to manufacture [`PackagingConfiguration`](crate::model::PackagingConfiguration)
    pub fn builder() -> crate::model::packaging_configuration::Builder {
        crate::model::packaging_configuration::Builder::default()
    }
}

/// A Microsoft Smooth Streaming (MSS) PackagingConfiguration.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MssPackage {
    /// A Microsoft Smooth Streaming (MSS) encryption configuration.
    pub encryption: std::option::Option<crate::model::MssEncryption>,
    /// A list of MSS manifest configurations.
    pub mss_manifests: std::option::Option<std::vec::Vec<crate::model::MssManifest>>,
    /// The duration (in seconds) of each segment.
    pub segment_duration_seconds: i32,
}
impl std::fmt::Debug for MssPackage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MssPackage");
        formatter.field("encryption", &self.encryption);
        formatter.field("mss_manifests", &self.mss_manifests);
        formatter.field("segment_duration_seconds", &self.segment_duration_seconds);
        formatter.finish()
    }
}
/// See [`MssPackage`](crate::model::MssPackage)
pub mod mss_package {
    /// A builder for [`MssPackage`](crate::model::MssPackage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) encryption: std::option::Option<crate::model::MssEncryption>,
        pub(crate) mss_manifests: std::option::Option<std::vec::Vec<crate::model::MssManifest>>,
        pub(crate) segment_duration_seconds: std::option::Option<i32>,
    }
    impl Builder {
        /// A Microsoft Smooth Streaming (MSS) encryption configuration.
        pub fn encryption(mut self, input: crate::model::MssEncryption) -> Self {
            self.encryption = Some(input);
            self
        }
        /// A Microsoft Smooth Streaming (MSS) encryption configuration.
        pub fn set_encryption(
            mut self,
            input: std::option::Option<crate::model::MssEncryption>,
        ) -> Self {
            self.encryption = input;
            self
        }
        /// Appends an item to `mss_manifests`.
        ///
        /// To override the contents of this collection use [`set_mss_manifests`](Self::set_mss_manifests).
        ///
        /// A list of MSS manifest configurations.
        pub fn mss_manifests(mut self, input: impl Into<crate::model::MssManifest>) -> Self {
            let mut v = self.mss_manifests.unwrap_or_default();
            v.push(input.into());
            self.mss_manifests = Some(v);
            self
        }
        /// A list of MSS manifest configurations.
        pub fn set_mss_manifests(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MssManifest>>,
        ) -> Self {
            self.mss_manifests = input;
            self
        }
        /// The duration (in seconds) of each segment.
        pub fn segment_duration_seconds(mut self, input: i32) -> Self {
            self.segment_duration_seconds = Some(input);
            self
        }
        /// The duration (in seconds) of each segment.
        pub fn set_segment_duration_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.segment_duration_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`MssPackage`](crate::model::MssPackage)
        pub fn build(self) -> crate::model::MssPackage {
            crate::model::MssPackage {
                encryption: self.encryption,
                mss_manifests: self.mss_manifests,
                segment_duration_seconds: self.segment_duration_seconds.unwrap_or_default(),
            }
        }
    }
}
impl MssPackage {
    /// Creates a new builder-style object to manufacture [`MssPackage`](crate::model::MssPackage)
    pub fn builder() -> crate::model::mss_package::Builder {
        crate::model::mss_package::Builder::default()
    }
}

/// A Microsoft Smooth Streaming (MSS) manifest configuration.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MssManifest {
    /// An optional string to include in the name of the manifest.
    pub manifest_name: std::option::Option<std::string::String>,
    /// A StreamSelection configuration.
    pub stream_selection: std::option::Option<crate::model::StreamSelection>,
}
impl std::fmt::Debug for MssManifest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MssManifest");
        formatter.field("manifest_name", &self.manifest_name);
        formatter.field("stream_selection", &self.stream_selection);
        formatter.finish()
    }
}
/// See [`MssManifest`](crate::model::MssManifest)
pub mod mss_manifest {
    /// A builder for [`MssManifest`](crate::model::MssManifest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) manifest_name: std::option::Option<std::string::String>,
        pub(crate) stream_selection: std::option::Option<crate::model::StreamSelection>,
    }
    impl Builder {
        /// An optional string to include in the name of the manifest.
        pub fn manifest_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.manifest_name = Some(input.into());
            self
        }
        /// An optional string to include in the name of the manifest.
        pub fn set_manifest_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.manifest_name = input;
            self
        }
        /// A StreamSelection configuration.
        pub fn stream_selection(mut self, input: crate::model::StreamSelection) -> Self {
            self.stream_selection = Some(input);
            self
        }
        /// A StreamSelection configuration.
        pub fn set_stream_selection(
            mut self,
            input: std::option::Option<crate::model::StreamSelection>,
        ) -> Self {
            self.stream_selection = input;
            self
        }
        /// Consumes the builder and constructs a [`MssManifest`](crate::model::MssManifest)
        pub fn build(self) -> crate::model::MssManifest {
            crate::model::MssManifest {
                manifest_name: self.manifest_name,
                stream_selection: self.stream_selection,
            }
        }
    }
}
impl MssManifest {
    /// Creates a new builder-style object to manufacture [`MssManifest`](crate::model::MssManifest)
    pub fn builder() -> crate::model::mss_manifest::Builder {
        crate::model::mss_manifest::Builder::default()
    }
}

/// A StreamSelection configuration.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StreamSelection {
    /// The maximum video bitrate (bps) to include in output.
    pub max_video_bits_per_second: i32,
    /// The minimum video bitrate (bps) to include in output.
    pub min_video_bits_per_second: i32,
    /// A directive that determines the order of streams in the output.
    pub stream_order: std::option::Option<crate::model::StreamOrder>,
}
impl std::fmt::Debug for StreamSelection {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StreamSelection");
        formatter.field("max_video_bits_per_second", &self.max_video_bits_per_second);
        formatter.field("min_video_bits_per_second", &self.min_video_bits_per_second);
        formatter.field("stream_order", &self.stream_order);
        formatter.finish()
    }
}
/// See [`StreamSelection`](crate::model::StreamSelection)
pub mod stream_selection {
    /// A builder for [`StreamSelection`](crate::model::StreamSelection)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_video_bits_per_second: std::option::Option<i32>,
        pub(crate) min_video_bits_per_second: std::option::Option<i32>,
        pub(crate) stream_order: std::option::Option<crate::model::StreamOrder>,
    }
    impl Builder {
        /// The maximum video bitrate (bps) to include in output.
        pub fn max_video_bits_per_second(mut self, input: i32) -> Self {
            self.max_video_bits_per_second = Some(input);
            self
        }
        /// The maximum video bitrate (bps) to include in output.
        pub fn set_max_video_bits_per_second(mut self, input: std::option::Option<i32>) -> Self {
            self.max_video_bits_per_second = input;
            self
        }
        /// The minimum video bitrate (bps) to include in output.
        pub fn min_video_bits_per_second(mut self, input: i32) -> Self {
            self.min_video_bits_per_second = Some(input);
            self
        }
        /// The minimum video bitrate (bps) to include in output.
        pub fn set_min_video_bits_per_second(mut self, input: std::option::Option<i32>) -> Self {
            self.min_video_bits_per_second = input;
            self
        }
        /// A directive that determines the order of streams in the output.
        pub fn stream_order(mut self, input: crate::model::StreamOrder) -> Self {
            self.stream_order = Some(input);
            self
        }
        /// A directive that determines the order of streams in the output.
        pub fn set_stream_order(
            mut self,
            input: std::option::Option<crate::model::StreamOrder>,
        ) -> Self {
            self.stream_order = input;
            self
        }
        /// Consumes the builder and constructs a [`StreamSelection`](crate::model::StreamSelection)
        pub fn build(self) -> crate::model::StreamSelection {
            crate::model::StreamSelection {
                max_video_bits_per_second: self.max_video_bits_per_second.unwrap_or_default(),
                min_video_bits_per_second: self.min_video_bits_per_second.unwrap_or_default(),
                stream_order: self.stream_order,
            }
        }
    }
}
impl StreamSelection {
    /// Creates a new builder-style object to manufacture [`StreamSelection`](crate::model::StreamSelection)
    pub fn builder() -> crate::model::stream_selection::Builder {
        crate::model::stream_selection::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StreamOrder {
    #[allow(missing_docs)] // documentation missing in model
    Original,
    #[allow(missing_docs)] // documentation missing in model
    VideoBitrateAscending,
    #[allow(missing_docs)] // documentation missing in model
    VideoBitrateDescending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StreamOrder {
    fn from(s: &str) -> Self {
        match s {
            "ORIGINAL" => StreamOrder::Original,
            "VIDEO_BITRATE_ASCENDING" => StreamOrder::VideoBitrateAscending,
            "VIDEO_BITRATE_DESCENDING" => StreamOrder::VideoBitrateDescending,
            other => StreamOrder::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StreamOrder {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StreamOrder::from(s))
    }
}
impl StreamOrder {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StreamOrder::Original => "ORIGINAL",
            StreamOrder::VideoBitrateAscending => "VIDEO_BITRATE_ASCENDING",
            StreamOrder::VideoBitrateDescending => "VIDEO_BITRATE_DESCENDING",
            StreamOrder::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ORIGINAL",
            "VIDEO_BITRATE_ASCENDING",
            "VIDEO_BITRATE_DESCENDING",
        ]
    }
}
impl AsRef<str> for StreamOrder {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// A Microsoft Smooth Streaming (MSS) encryption configuration.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MssEncryption {
    /// A configuration for accessing an external Secure Packager and Encoder Key Exchange (SPEKE) service that will provide encryption keys.
    pub speke_key_provider: std::option::Option<crate::model::SpekeKeyProvider>,
}
impl std::fmt::Debug for MssEncryption {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MssEncryption");
        formatter.field("speke_key_provider", &self.speke_key_provider);
        formatter.finish()
    }
}
/// See [`MssEncryption`](crate::model::MssEncryption)
pub mod mss_encryption {
    /// A builder for [`MssEncryption`](crate::model::MssEncryption)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) speke_key_provider: std::option::Option<crate::model::SpekeKeyProvider>,
    }
    impl Builder {
        /// A configuration for accessing an external Secure Packager and Encoder Key Exchange (SPEKE) service that will provide encryption keys.
        pub fn speke_key_provider(mut self, input: crate::model::SpekeKeyProvider) -> Self {
            self.speke_key_provider = Some(input);
            self
        }
        /// A configuration for accessing an external Secure Packager and Encoder Key Exchange (SPEKE) service that will provide encryption keys.
        pub fn set_speke_key_provider(
            mut self,
            input: std::option::Option<crate::model::SpekeKeyProvider>,
        ) -> Self {
            self.speke_key_provider = input;
            self
        }
        /// Consumes the builder and constructs a [`MssEncryption`](crate::model::MssEncryption)
        pub fn build(self) -> crate::model::MssEncryption {
            crate::model::MssEncryption {
                speke_key_provider: self.speke_key_provider,
            }
        }
    }
}
impl MssEncryption {
    /// Creates a new builder-style object to manufacture [`MssEncryption`](crate::model::MssEncryption)
    pub fn builder() -> crate::model::mss_encryption::Builder {
        crate::model::mss_encryption::Builder::default()
    }
}

/// A configuration for accessing an external Secure Packager and Encoder Key Exchange (SPEKE) service that will provide encryption keys.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SpekeKeyProvider {
    /// An Amazon Resource Name (ARN) of an IAM role that AWS Elemental
    /// MediaPackage will assume when accessing the key provider service.
    pub role_arn: std::option::Option<std::string::String>,
    /// The system IDs to include in key requests.
    pub system_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// The URL of the external key provider service.
    pub url: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SpekeKeyProvider {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SpekeKeyProvider");
        formatter.field("role_arn", &self.role_arn);
        formatter.field("system_ids", &self.system_ids);
        formatter.field("url", &self.url);
        formatter.finish()
    }
}
/// See [`SpekeKeyProvider`](crate::model::SpekeKeyProvider)
pub mod speke_key_provider {
    /// A builder for [`SpekeKeyProvider`](crate::model::SpekeKeyProvider)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) system_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// An Amazon Resource Name (ARN) of an IAM role that AWS Elemental
        /// MediaPackage will assume when accessing the key provider service.
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// An Amazon Resource Name (ARN) of an IAM role that AWS Elemental
        /// MediaPackage will assume when accessing the key provider service.
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Appends an item to `system_ids`.
        ///
        /// To override the contents of this collection use [`set_system_ids`](Self::set_system_ids).
        ///
        /// The system IDs to include in key requests.
        pub fn system_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.system_ids.unwrap_or_default();
            v.push(input.into());
            self.system_ids = Some(v);
            self
        }
        /// The system IDs to include in key requests.
        pub fn set_system_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.system_ids = input;
            self
        }
        /// The URL of the external key provider service.
        pub fn url(mut self, input: impl Into<std::string::String>) -> Self {
            self.url = Some(input.into());
            self
        }
        /// The URL of the external key provider service.
        pub fn set_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.url = input;
            self
        }
        /// Consumes the builder and constructs a [`SpekeKeyProvider`](crate::model::SpekeKeyProvider)
        pub fn build(self) -> crate::model::SpekeKeyProvider {
            crate::model::SpekeKeyProvider {
                role_arn: self.role_arn,
                system_ids: self.system_ids,
                url: self.url,
            }
        }
    }
}
impl SpekeKeyProvider {
    /// Creates a new builder-style object to manufacture [`SpekeKeyProvider`](crate::model::SpekeKeyProvider)
    pub fn builder() -> crate::model::speke_key_provider::Builder {
        crate::model::speke_key_provider::Builder::default()
    }
}

/// An HTTP Live Streaming (HLS) packaging configuration.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HlsPackage {
    /// An HTTP Live Streaming (HLS) encryption configuration.
    pub encryption: std::option::Option<crate::model::HlsEncryption>,
    /// A list of HLS manifest configurations.
    pub hls_manifests: std::option::Option<std::vec::Vec<crate::model::HlsManifest>>,
    /// Duration (in seconds) of each fragment. Actual fragments will be
    /// rounded to the nearest multiple of the source fragment duration.
    pub segment_duration_seconds: i32,
    /// When enabled, audio streams will be placed in rendition groups in the output.
    pub use_audio_rendition_group: bool,
}
impl std::fmt::Debug for HlsPackage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HlsPackage");
        formatter.field("encryption", &self.encryption);
        formatter.field("hls_manifests", &self.hls_manifests);
        formatter.field("segment_duration_seconds", &self.segment_duration_seconds);
        formatter.field("use_audio_rendition_group", &self.use_audio_rendition_group);
        formatter.finish()
    }
}
/// See [`HlsPackage`](crate::model::HlsPackage)
pub mod hls_package {
    /// A builder for [`HlsPackage`](crate::model::HlsPackage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) encryption: std::option::Option<crate::model::HlsEncryption>,
        pub(crate) hls_manifests: std::option::Option<std::vec::Vec<crate::model::HlsManifest>>,
        pub(crate) segment_duration_seconds: std::option::Option<i32>,
        pub(crate) use_audio_rendition_group: std::option::Option<bool>,
    }
    impl Builder {
        /// An HTTP Live Streaming (HLS) encryption configuration.
        pub fn encryption(mut self, input: crate::model::HlsEncryption) -> Self {
            self.encryption = Some(input);
            self
        }
        /// An HTTP Live Streaming (HLS) encryption configuration.
        pub fn set_encryption(
            mut self,
            input: std::option::Option<crate::model::HlsEncryption>,
        ) -> Self {
            self.encryption = input;
            self
        }
        /// Appends an item to `hls_manifests`.
        ///
        /// To override the contents of this collection use [`set_hls_manifests`](Self::set_hls_manifests).
        ///
        /// A list of HLS manifest configurations.
        pub fn hls_manifests(mut self, input: impl Into<crate::model::HlsManifest>) -> Self {
            let mut v = self.hls_manifests.unwrap_or_default();
            v.push(input.into());
            self.hls_manifests = Some(v);
            self
        }
        /// A list of HLS manifest configurations.
        pub fn set_hls_manifests(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HlsManifest>>,
        ) -> Self {
            self.hls_manifests = input;
            self
        }
        /// Duration (in seconds) of each fragment. Actual fragments will be
        /// rounded to the nearest multiple of the source fragment duration.
        pub fn segment_duration_seconds(mut self, input: i32) -> Self {
            self.segment_duration_seconds = Some(input);
            self
        }
        /// Duration (in seconds) of each fragment. Actual fragments will be
        /// rounded to the nearest multiple of the source fragment duration.
        pub fn set_segment_duration_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.segment_duration_seconds = input;
            self
        }
        /// When enabled, audio streams will be placed in rendition groups in the output.
        pub fn use_audio_rendition_group(mut self, input: bool) -> Self {
            self.use_audio_rendition_group = Some(input);
            self
        }
        /// When enabled, audio streams will be placed in rendition groups in the output.
        pub fn set_use_audio_rendition_group(mut self, input: std::option::Option<bool>) -> Self {
            self.use_audio_rendition_group = input;
            self
        }
        /// Consumes the builder and constructs a [`HlsPackage`](crate::model::HlsPackage)
        pub fn build(self) -> crate::model::HlsPackage {
            crate::model::HlsPackage {
                encryption: self.encryption,
                hls_manifests: self.hls_manifests,
                segment_duration_seconds: self.segment_duration_seconds.unwrap_or_default(),
                use_audio_rendition_group: self.use_audio_rendition_group.unwrap_or_default(),
            }
        }
    }
}
impl HlsPackage {
    /// Creates a new builder-style object to manufacture [`HlsPackage`](crate::model::HlsPackage)
    pub fn builder() -> crate::model::hls_package::Builder {
        crate::model::hls_package::Builder::default()
    }
}

/// An HTTP Live Streaming (HLS) manifest configuration.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HlsManifest {
    /// This setting controls how ad markers are included in the packaged OriginEndpoint.
    /// "NONE" will omit all SCTE-35 ad markers from the output.
    /// "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35 ad
    /// markers (comments) taken directly from the input HTTP Live Streaming (HLS) manifest.
    /// "SCTE35_ENHANCED" generates ad markers and blackout tags based on SCTE-35
    /// messages in the input source.
    pub ad_markers: std::option::Option<crate::model::AdMarkers>,
    /// When enabled, an I-Frame only stream will be included in the output.
    pub include_iframe_only_stream: bool,
    /// An optional string to include in the name of the manifest.
    pub manifest_name: std::option::Option<std::string::String>,
    /// The interval (in seconds) between each EXT-X-PROGRAM-DATE-TIME tag
    /// inserted into manifests. Additionally, when an interval is specified
    /// ID3Timed Metadata messages will be generated every 5 seconds using the
    /// ingest time of the content.
    /// If the interval is not specified, or set to 0, then
    /// no EXT-X-PROGRAM-DATE-TIME tags will be inserted into manifests and no
    /// ID3Timed Metadata messages will be generated. Note that irrespective
    /// of this parameter, if any ID3 Timed Metadata is found in HTTP Live Streaming (HLS) input,
    /// it will be passed through to HLS output.
    pub program_date_time_interval_seconds: i32,
    /// When enabled, the EXT-X-KEY tag will be repeated in output manifests.
    pub repeat_ext_x_key: bool,
    /// A StreamSelection configuration.
    pub stream_selection: std::option::Option<crate::model::StreamSelection>,
}
impl std::fmt::Debug for HlsManifest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HlsManifest");
        formatter.field("ad_markers", &self.ad_markers);
        formatter.field(
            "include_iframe_only_stream",
            &self.include_iframe_only_stream,
        );
        formatter.field("manifest_name", &self.manifest_name);
        formatter.field(
            "program_date_time_interval_seconds",
            &self.program_date_time_interval_seconds,
        );
        formatter.field("repeat_ext_x_key", &self.repeat_ext_x_key);
        formatter.field("stream_selection", &self.stream_selection);
        formatter.finish()
    }
}
/// See [`HlsManifest`](crate::model::HlsManifest)
pub mod hls_manifest {
    /// A builder for [`HlsManifest`](crate::model::HlsManifest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ad_markers: std::option::Option<crate::model::AdMarkers>,
        pub(crate) include_iframe_only_stream: std::option::Option<bool>,
        pub(crate) manifest_name: std::option::Option<std::string::String>,
        pub(crate) program_date_time_interval_seconds: std::option::Option<i32>,
        pub(crate) repeat_ext_x_key: std::option::Option<bool>,
        pub(crate) stream_selection: std::option::Option<crate::model::StreamSelection>,
    }
    impl Builder {
        /// This setting controls how ad markers are included in the packaged OriginEndpoint.
        /// "NONE" will omit all SCTE-35 ad markers from the output.
        /// "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35 ad
        /// markers (comments) taken directly from the input HTTP Live Streaming (HLS) manifest.
        /// "SCTE35_ENHANCED" generates ad markers and blackout tags based on SCTE-35
        /// messages in the input source.
        pub fn ad_markers(mut self, input: crate::model::AdMarkers) -> Self {
            self.ad_markers = Some(input);
            self
        }
        /// This setting controls how ad markers are included in the packaged OriginEndpoint.
        /// "NONE" will omit all SCTE-35 ad markers from the output.
        /// "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35 ad
        /// markers (comments) taken directly from the input HTTP Live Streaming (HLS) manifest.
        /// "SCTE35_ENHANCED" generates ad markers and blackout tags based on SCTE-35
        /// messages in the input source.
        pub fn set_ad_markers(
            mut self,
            input: std::option::Option<crate::model::AdMarkers>,
        ) -> Self {
            self.ad_markers = input;
            self
        }
        /// When enabled, an I-Frame only stream will be included in the output.
        pub fn include_iframe_only_stream(mut self, input: bool) -> Self {
            self.include_iframe_only_stream = Some(input);
            self
        }
        /// When enabled, an I-Frame only stream will be included in the output.
        pub fn set_include_iframe_only_stream(mut self, input: std::option::Option<bool>) -> Self {
            self.include_iframe_only_stream = input;
            self
        }
        /// An optional string to include in the name of the manifest.
        pub fn manifest_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.manifest_name = Some(input.into());
            self
        }
        /// An optional string to include in the name of the manifest.
        pub fn set_manifest_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.manifest_name = input;
            self
        }
        /// The interval (in seconds) between each EXT-X-PROGRAM-DATE-TIME tag
        /// inserted into manifests. Additionally, when an interval is specified
        /// ID3Timed Metadata messages will be generated every 5 seconds using the
        /// ingest time of the content.
        /// If the interval is not specified, or set to 0, then
        /// no EXT-X-PROGRAM-DATE-TIME tags will be inserted into manifests and no
        /// ID3Timed Metadata messages will be generated. Note that irrespective
        /// of this parameter, if any ID3 Timed Metadata is found in HTTP Live Streaming (HLS) input,
        /// it will be passed through to HLS output.
        pub fn program_date_time_interval_seconds(mut self, input: i32) -> Self {
            self.program_date_time_interval_seconds = Some(input);
            self
        }
        /// The interval (in seconds) between each EXT-X-PROGRAM-DATE-TIME tag
        /// inserted into manifests. Additionally, when an interval is specified
        /// ID3Timed Metadata messages will be generated every 5 seconds using the
        /// ingest time of the content.
        /// If the interval is not specified, or set to 0, then
        /// no EXT-X-PROGRAM-DATE-TIME tags will be inserted into manifests and no
        /// ID3Timed Metadata messages will be generated. Note that irrespective
        /// of this parameter, if any ID3 Timed Metadata is found in HTTP Live Streaming (HLS) input,
        /// it will be passed through to HLS output.
        pub fn set_program_date_time_interval_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.program_date_time_interval_seconds = input;
            self
        }
        /// When enabled, the EXT-X-KEY tag will be repeated in output manifests.
        pub fn repeat_ext_x_key(mut self, input: bool) -> Self {
            self.repeat_ext_x_key = Some(input);
            self
        }
        /// When enabled, the EXT-X-KEY tag will be repeated in output manifests.
        pub fn set_repeat_ext_x_key(mut self, input: std::option::Option<bool>) -> Self {
            self.repeat_ext_x_key = input;
            self
        }
        /// A StreamSelection configuration.
        pub fn stream_selection(mut self, input: crate::model::StreamSelection) -> Self {
            self.stream_selection = Some(input);
            self
        }
        /// A StreamSelection configuration.
        pub fn set_stream_selection(
            mut self,
            input: std::option::Option<crate::model::StreamSelection>,
        ) -> Self {
            self.stream_selection = input;
            self
        }
        /// Consumes the builder and constructs a [`HlsManifest`](crate::model::HlsManifest)
        pub fn build(self) -> crate::model::HlsManifest {
            crate::model::HlsManifest {
                ad_markers: self.ad_markers,
                include_iframe_only_stream: self.include_iframe_only_stream.unwrap_or_default(),
                manifest_name: self.manifest_name,
                program_date_time_interval_seconds: self
                    .program_date_time_interval_seconds
                    .unwrap_or_default(),
                repeat_ext_x_key: self.repeat_ext_x_key.unwrap_or_default(),
                stream_selection: self.stream_selection,
            }
        }
    }
}
impl HlsManifest {
    /// Creates a new builder-style object to manufacture [`HlsManifest`](crate::model::HlsManifest)
    pub fn builder() -> crate::model::hls_manifest::Builder {
        crate::model::hls_manifest::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AdMarkers {
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    Passthrough,
    #[allow(missing_docs)] // documentation missing in model
    Scte35Enhanced,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AdMarkers {
    fn from(s: &str) -> Self {
        match s {
            "NONE" => AdMarkers::None,
            "PASSTHROUGH" => AdMarkers::Passthrough,
            "SCTE35_ENHANCED" => AdMarkers::Scte35Enhanced,
            other => AdMarkers::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AdMarkers {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AdMarkers::from(s))
    }
}
impl AdMarkers {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AdMarkers::None => "NONE",
            AdMarkers::Passthrough => "PASSTHROUGH",
            AdMarkers::Scte35Enhanced => "SCTE35_ENHANCED",
            AdMarkers::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NONE", "PASSTHROUGH", "SCTE35_ENHANCED"]
    }
}
impl AsRef<str> for AdMarkers {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// An HTTP Live Streaming (HLS) encryption configuration.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HlsEncryption {
    /// A constant initialization vector for encryption (optional).
    /// When not specified the initialization vector will be periodically rotated.
    pub constant_initialization_vector: std::option::Option<std::string::String>,
    /// The encryption method to use.
    pub encryption_method: std::option::Option<crate::model::EncryptionMethod>,
    /// A configuration for accessing an external Secure Packager and Encoder Key Exchange (SPEKE) service that will provide encryption keys.
    pub speke_key_provider: std::option::Option<crate::model::SpekeKeyProvider>,
}
impl std::fmt::Debug for HlsEncryption {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HlsEncryption");
        formatter.field(
            "constant_initialization_vector",
            &self.constant_initialization_vector,
        );
        formatter.field("encryption_method", &self.encryption_method);
        formatter.field("speke_key_provider", &self.speke_key_provider);
        formatter.finish()
    }
}
/// See [`HlsEncryption`](crate::model::HlsEncryption)
pub mod hls_encryption {
    /// A builder for [`HlsEncryption`](crate::model::HlsEncryption)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) constant_initialization_vector: std::option::Option<std::string::String>,
        pub(crate) encryption_method: std::option::Option<crate::model::EncryptionMethod>,
        pub(crate) speke_key_provider: std::option::Option<crate::model::SpekeKeyProvider>,
    }
    impl Builder {
        /// A constant initialization vector for encryption (optional).
        /// When not specified the initialization vector will be periodically rotated.
        pub fn constant_initialization_vector(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.constant_initialization_vector = Some(input.into());
            self
        }
        /// A constant initialization vector for encryption (optional).
        /// When not specified the initialization vector will be periodically rotated.
        pub fn set_constant_initialization_vector(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.constant_initialization_vector = input;
            self
        }
        /// The encryption method to use.
        pub fn encryption_method(mut self, input: crate::model::EncryptionMethod) -> Self {
            self.encryption_method = Some(input);
            self
        }
        /// The encryption method to use.
        pub fn set_encryption_method(
            mut self,
            input: std::option::Option<crate::model::EncryptionMethod>,
        ) -> Self {
            self.encryption_method = input;
            self
        }
        /// A configuration for accessing an external Secure Packager and Encoder Key Exchange (SPEKE) service that will provide encryption keys.
        pub fn speke_key_provider(mut self, input: crate::model::SpekeKeyProvider) -> Self {
            self.speke_key_provider = Some(input);
            self
        }
        /// A configuration for accessing an external Secure Packager and Encoder Key Exchange (SPEKE) service that will provide encryption keys.
        pub fn set_speke_key_provider(
            mut self,
            input: std::option::Option<crate::model::SpekeKeyProvider>,
        ) -> Self {
            self.speke_key_provider = input;
            self
        }
        /// Consumes the builder and constructs a [`HlsEncryption`](crate::model::HlsEncryption)
        pub fn build(self) -> crate::model::HlsEncryption {
            crate::model::HlsEncryption {
                constant_initialization_vector: self.constant_initialization_vector,
                encryption_method: self.encryption_method,
                speke_key_provider: self.speke_key_provider,
            }
        }
    }
}
impl HlsEncryption {
    /// Creates a new builder-style object to manufacture [`HlsEncryption`](crate::model::HlsEncryption)
    pub fn builder() -> crate::model::hls_encryption::Builder {
        crate::model::hls_encryption::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EncryptionMethod {
    #[allow(missing_docs)] // documentation missing in model
    Aes128,
    #[allow(missing_docs)] // documentation missing in model
    SampleAes,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EncryptionMethod {
    fn from(s: &str) -> Self {
        match s {
            "AES_128" => EncryptionMethod::Aes128,
            "SAMPLE_AES" => EncryptionMethod::SampleAes,
            other => EncryptionMethod::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EncryptionMethod {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EncryptionMethod::from(s))
    }
}
impl EncryptionMethod {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EncryptionMethod::Aes128 => "AES_128",
            EncryptionMethod::SampleAes => "SAMPLE_AES",
            EncryptionMethod::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AES_128", "SAMPLE_AES"]
    }
}
impl AsRef<str> for EncryptionMethod {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DashPackage {
    /// A list of DASH manifest configurations.
    pub dash_manifests: std::option::Option<std::vec::Vec<crate::model::DashManifest>>,
    /// A Dynamic Adaptive Streaming over HTTP (DASH) encryption configuration.
    pub encryption: std::option::Option<crate::model::DashEncryption>,
    /// When includeEncoderConfigurationInSegments is set to true, MediaPackage places your encoder's Sequence Parameter Set (SPS), Picture Parameter Set (PPS), and Video Parameter Set (VPS) metadata in every video segment instead of in the init fragment. This lets you use different SPS/PPS/VPS settings for your assets during content playback.
    pub include_encoder_configuration_in_segments: bool,
    /// A list of triggers that controls when the outgoing Dynamic Adaptive Streaming over HTTP (DASH)
    /// Media Presentation Description (MPD) will be partitioned into multiple periods. If empty, the content will not
    /// be partitioned into more than one period. If the list contains "ADS", new periods will be created where
    /// the Asset contains SCTE-35 ad markers.
    pub period_triggers: std::option::Option<std::vec::Vec<crate::model::PeriodTriggersElement>>,
    /// Duration (in seconds) of each segment. Actual segments will be
    /// rounded to the nearest multiple of the source segment duration.
    pub segment_duration_seconds: i32,
    /// Determines the type of SegmentTemplate included in the Media Presentation Description (MPD).  When set to NUMBER_WITH_TIMELINE, a full timeline is presented in each SegmentTemplate, with $Number$ media URLs.  When set to TIME_WITH_TIMELINE, a full timeline is presented in each SegmentTemplate, with $Time$ media URLs. When set to NUMBER_WITH_DURATION, only a duration is included in each SegmentTemplate, with $Number$ media URLs.
    pub segment_template_format: std::option::Option<crate::model::SegmentTemplateFormat>,
}
impl std::fmt::Debug for DashPackage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DashPackage");
        formatter.field("dash_manifests", &self.dash_manifests);
        formatter.field("encryption", &self.encryption);
        formatter.field(
            "include_encoder_configuration_in_segments",
            &self.include_encoder_configuration_in_segments,
        );
        formatter.field("period_triggers", &self.period_triggers);
        formatter.field("segment_duration_seconds", &self.segment_duration_seconds);
        formatter.field("segment_template_format", &self.segment_template_format);
        formatter.finish()
    }
}
/// See [`DashPackage`](crate::model::DashPackage)
pub mod dash_package {
    /// A builder for [`DashPackage`](crate::model::DashPackage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dash_manifests: std::option::Option<std::vec::Vec<crate::model::DashManifest>>,
        pub(crate) encryption: std::option::Option<crate::model::DashEncryption>,
        pub(crate) include_encoder_configuration_in_segments: std::option::Option<bool>,
        pub(crate) period_triggers:
            std::option::Option<std::vec::Vec<crate::model::PeriodTriggersElement>>,
        pub(crate) segment_duration_seconds: std::option::Option<i32>,
        pub(crate) segment_template_format:
            std::option::Option<crate::model::SegmentTemplateFormat>,
    }
    impl Builder {
        /// Appends an item to `dash_manifests`.
        ///
        /// To override the contents of this collection use [`set_dash_manifests`](Self::set_dash_manifests).
        ///
        /// A list of DASH manifest configurations.
        pub fn dash_manifests(mut self, input: impl Into<crate::model::DashManifest>) -> Self {
            let mut v = self.dash_manifests.unwrap_or_default();
            v.push(input.into());
            self.dash_manifests = Some(v);
            self
        }
        /// A list of DASH manifest configurations.
        pub fn set_dash_manifests(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DashManifest>>,
        ) -> Self {
            self.dash_manifests = input;
            self
        }
        /// A Dynamic Adaptive Streaming over HTTP (DASH) encryption configuration.
        pub fn encryption(mut self, input: crate::model::DashEncryption) -> Self {
            self.encryption = Some(input);
            self
        }
        /// A Dynamic Adaptive Streaming over HTTP (DASH) encryption configuration.
        pub fn set_encryption(
            mut self,
            input: std::option::Option<crate::model::DashEncryption>,
        ) -> Self {
            self.encryption = input;
            self
        }
        /// When includeEncoderConfigurationInSegments is set to true, MediaPackage places your encoder's Sequence Parameter Set (SPS), Picture Parameter Set (PPS), and Video Parameter Set (VPS) metadata in every video segment instead of in the init fragment. This lets you use different SPS/PPS/VPS settings for your assets during content playback.
        pub fn include_encoder_configuration_in_segments(mut self, input: bool) -> Self {
            self.include_encoder_configuration_in_segments = Some(input);
            self
        }
        /// When includeEncoderConfigurationInSegments is set to true, MediaPackage places your encoder's Sequence Parameter Set (SPS), Picture Parameter Set (PPS), and Video Parameter Set (VPS) metadata in every video segment instead of in the init fragment. This lets you use different SPS/PPS/VPS settings for your assets during content playback.
        pub fn set_include_encoder_configuration_in_segments(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.include_encoder_configuration_in_segments = input;
            self
        }
        /// Appends an item to `period_triggers`.
        ///
        /// To override the contents of this collection use [`set_period_triggers`](Self::set_period_triggers).
        ///
        /// A list of triggers that controls when the outgoing Dynamic Adaptive Streaming over HTTP (DASH)
        /// Media Presentation Description (MPD) will be partitioned into multiple periods. If empty, the content will not
        /// be partitioned into more than one period. If the list contains "ADS", new periods will be created where
        /// the Asset contains SCTE-35 ad markers.
        pub fn period_triggers(
            mut self,
            input: impl Into<crate::model::PeriodTriggersElement>,
        ) -> Self {
            let mut v = self.period_triggers.unwrap_or_default();
            v.push(input.into());
            self.period_triggers = Some(v);
            self
        }
        /// A list of triggers that controls when the outgoing Dynamic Adaptive Streaming over HTTP (DASH)
        /// Media Presentation Description (MPD) will be partitioned into multiple periods. If empty, the content will not
        /// be partitioned into more than one period. If the list contains "ADS", new periods will be created where
        /// the Asset contains SCTE-35 ad markers.
        pub fn set_period_triggers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PeriodTriggersElement>>,
        ) -> Self {
            self.period_triggers = input;
            self
        }
        /// Duration (in seconds) of each segment. Actual segments will be
        /// rounded to the nearest multiple of the source segment duration.
        pub fn segment_duration_seconds(mut self, input: i32) -> Self {
            self.segment_duration_seconds = Some(input);
            self
        }
        /// Duration (in seconds) of each segment. Actual segments will be
        /// rounded to the nearest multiple of the source segment duration.
        pub fn set_segment_duration_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.segment_duration_seconds = input;
            self
        }
        /// Determines the type of SegmentTemplate included in the Media Presentation Description (MPD).  When set to NUMBER_WITH_TIMELINE, a full timeline is presented in each SegmentTemplate, with $Number$ media URLs.  When set to TIME_WITH_TIMELINE, a full timeline is presented in each SegmentTemplate, with $Time$ media URLs. When set to NUMBER_WITH_DURATION, only a duration is included in each SegmentTemplate, with $Number$ media URLs.
        pub fn segment_template_format(
            mut self,
            input: crate::model::SegmentTemplateFormat,
        ) -> Self {
            self.segment_template_format = Some(input);
            self
        }
        /// Determines the type of SegmentTemplate included in the Media Presentation Description (MPD).  When set to NUMBER_WITH_TIMELINE, a full timeline is presented in each SegmentTemplate, with $Number$ media URLs.  When set to TIME_WITH_TIMELINE, a full timeline is presented in each SegmentTemplate, with $Time$ media URLs. When set to NUMBER_WITH_DURATION, only a duration is included in each SegmentTemplate, with $Number$ media URLs.
        pub fn set_segment_template_format(
            mut self,
            input: std::option::Option<crate::model::SegmentTemplateFormat>,
        ) -> Self {
            self.segment_template_format = input;
            self
        }
        /// Consumes the builder and constructs a [`DashPackage`](crate::model::DashPackage)
        pub fn build(self) -> crate::model::DashPackage {
            crate::model::DashPackage {
                dash_manifests: self.dash_manifests,
                encryption: self.encryption,
                include_encoder_configuration_in_segments: self
                    .include_encoder_configuration_in_segments
                    .unwrap_or_default(),
                period_triggers: self.period_triggers,
                segment_duration_seconds: self.segment_duration_seconds.unwrap_or_default(),
                segment_template_format: self.segment_template_format,
            }
        }
    }
}
impl DashPackage {
    /// Creates a new builder-style object to manufacture [`DashPackage`](crate::model::DashPackage)
    pub fn builder() -> crate::model::dash_package::Builder {
        crate::model::dash_package::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SegmentTemplateFormat {
    #[allow(missing_docs)] // documentation missing in model
    NumberWithDuration,
    #[allow(missing_docs)] // documentation missing in model
    NumberWithTimeline,
    #[allow(missing_docs)] // documentation missing in model
    TimeWithTimeline,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SegmentTemplateFormat {
    fn from(s: &str) -> Self {
        match s {
            "NUMBER_WITH_DURATION" => SegmentTemplateFormat::NumberWithDuration,
            "NUMBER_WITH_TIMELINE" => SegmentTemplateFormat::NumberWithTimeline,
            "TIME_WITH_TIMELINE" => SegmentTemplateFormat::TimeWithTimeline,
            other => SegmentTemplateFormat::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SegmentTemplateFormat {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SegmentTemplateFormat::from(s))
    }
}
impl SegmentTemplateFormat {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SegmentTemplateFormat::NumberWithDuration => "NUMBER_WITH_DURATION",
            SegmentTemplateFormat::NumberWithTimeline => "NUMBER_WITH_TIMELINE",
            SegmentTemplateFormat::TimeWithTimeline => "TIME_WITH_TIMELINE",
            SegmentTemplateFormat::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "NUMBER_WITH_DURATION",
            "NUMBER_WITH_TIMELINE",
            "TIME_WITH_TIMELINE",
        ]
    }
}
impl AsRef<str> for SegmentTemplateFormat {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PeriodTriggersElement {
    #[allow(missing_docs)] // documentation missing in model
    Ads,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PeriodTriggersElement {
    fn from(s: &str) -> Self {
        match s {
            "ADS" => PeriodTriggersElement::Ads,
            other => PeriodTriggersElement::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PeriodTriggersElement {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PeriodTriggersElement::from(s))
    }
}
impl PeriodTriggersElement {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PeriodTriggersElement::Ads => "ADS",
            PeriodTriggersElement::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ADS"]
    }
}
impl AsRef<str> for PeriodTriggersElement {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// A Dynamic Adaptive Streaming over HTTP (DASH) encryption configuration.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DashEncryption {
    /// A configuration for accessing an external Secure Packager and Encoder Key Exchange (SPEKE) service that will provide encryption keys.
    pub speke_key_provider: std::option::Option<crate::model::SpekeKeyProvider>,
}
impl std::fmt::Debug for DashEncryption {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DashEncryption");
        formatter.field("speke_key_provider", &self.speke_key_provider);
        formatter.finish()
    }
}
/// See [`DashEncryption`](crate::model::DashEncryption)
pub mod dash_encryption {
    /// A builder for [`DashEncryption`](crate::model::DashEncryption)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) speke_key_provider: std::option::Option<crate::model::SpekeKeyProvider>,
    }
    impl Builder {
        /// A configuration for accessing an external Secure Packager and Encoder Key Exchange (SPEKE) service that will provide encryption keys.
        pub fn speke_key_provider(mut self, input: crate::model::SpekeKeyProvider) -> Self {
            self.speke_key_provider = Some(input);
            self
        }
        /// A configuration for accessing an external Secure Packager and Encoder Key Exchange (SPEKE) service that will provide encryption keys.
        pub fn set_speke_key_provider(
            mut self,
            input: std::option::Option<crate::model::SpekeKeyProvider>,
        ) -> Self {
            self.speke_key_provider = input;
            self
        }
        /// Consumes the builder and constructs a [`DashEncryption`](crate::model::DashEncryption)
        pub fn build(self) -> crate::model::DashEncryption {
            crate::model::DashEncryption {
                speke_key_provider: self.speke_key_provider,
            }
        }
    }
}
impl DashEncryption {
    /// Creates a new builder-style object to manufacture [`DashEncryption`](crate::model::DashEncryption)
    pub fn builder() -> crate::model::dash_encryption::Builder {
        crate::model::dash_encryption::Builder::default()
    }
}

/// A DASH manifest configuration.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DashManifest {
    /// Determines the position of some tags in the Media Presentation Description (MPD).  When set to FULL, elements like SegmentTemplate and ContentProtection are included in each Representation.  When set to COMPACT, duplicate elements are combined and presented at the AdaptationSet level.
    pub manifest_layout: std::option::Option<crate::model::ManifestLayout>,
    /// An optional string to include in the name of the manifest.
    pub manifest_name: std::option::Option<std::string::String>,
    /// Minimum duration (in seconds) that a player will buffer media before starting the presentation.
    pub min_buffer_time_seconds: i32,
    /// The Dynamic Adaptive Streaming over HTTP (DASH) profile type.  When set to "HBBTV_1_5", HbbTV 1.5 compliant output is enabled.
    pub profile: std::option::Option<crate::model::Profile>,
    /// A StreamSelection configuration.
    pub stream_selection: std::option::Option<crate::model::StreamSelection>,
}
impl std::fmt::Debug for DashManifest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DashManifest");
        formatter.field("manifest_layout", &self.manifest_layout);
        formatter.field("manifest_name", &self.manifest_name);
        formatter.field("min_buffer_time_seconds", &self.min_buffer_time_seconds);
        formatter.field("profile", &self.profile);
        formatter.field("stream_selection", &self.stream_selection);
        formatter.finish()
    }
}
/// See [`DashManifest`](crate::model::DashManifest)
pub mod dash_manifest {
    /// A builder for [`DashManifest`](crate::model::DashManifest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) manifest_layout: std::option::Option<crate::model::ManifestLayout>,
        pub(crate) manifest_name: std::option::Option<std::string::String>,
        pub(crate) min_buffer_time_seconds: std::option::Option<i32>,
        pub(crate) profile: std::option::Option<crate::model::Profile>,
        pub(crate) stream_selection: std::option::Option<crate::model::StreamSelection>,
    }
    impl Builder {
        /// Determines the position of some tags in the Media Presentation Description (MPD).  When set to FULL, elements like SegmentTemplate and ContentProtection are included in each Representation.  When set to COMPACT, duplicate elements are combined and presented at the AdaptationSet level.
        pub fn manifest_layout(mut self, input: crate::model::ManifestLayout) -> Self {
            self.manifest_layout = Some(input);
            self
        }
        /// Determines the position of some tags in the Media Presentation Description (MPD).  When set to FULL, elements like SegmentTemplate and ContentProtection are included in each Representation.  When set to COMPACT, duplicate elements are combined and presented at the AdaptationSet level.
        pub fn set_manifest_layout(
            mut self,
            input: std::option::Option<crate::model::ManifestLayout>,
        ) -> Self {
            self.manifest_layout = input;
            self
        }
        /// An optional string to include in the name of the manifest.
        pub fn manifest_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.manifest_name = Some(input.into());
            self
        }
        /// An optional string to include in the name of the manifest.
        pub fn set_manifest_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.manifest_name = input;
            self
        }
        /// Minimum duration (in seconds) that a player will buffer media before starting the presentation.
        pub fn min_buffer_time_seconds(mut self, input: i32) -> Self {
            self.min_buffer_time_seconds = Some(input);
            self
        }
        /// Minimum duration (in seconds) that a player will buffer media before starting the presentation.
        pub fn set_min_buffer_time_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.min_buffer_time_seconds = input;
            self
        }
        /// The Dynamic Adaptive Streaming over HTTP (DASH) profile type.  When set to "HBBTV_1_5", HbbTV 1.5 compliant output is enabled.
        pub fn profile(mut self, input: crate::model::Profile) -> Self {
            self.profile = Some(input);
            self
        }
        /// The Dynamic Adaptive Streaming over HTTP (DASH) profile type.  When set to "HBBTV_1_5", HbbTV 1.5 compliant output is enabled.
        pub fn set_profile(mut self, input: std::option::Option<crate::model::Profile>) -> Self {
            self.profile = input;
            self
        }
        /// A StreamSelection configuration.
        pub fn stream_selection(mut self, input: crate::model::StreamSelection) -> Self {
            self.stream_selection = Some(input);
            self
        }
        /// A StreamSelection configuration.
        pub fn set_stream_selection(
            mut self,
            input: std::option::Option<crate::model::StreamSelection>,
        ) -> Self {
            self.stream_selection = input;
            self
        }
        /// Consumes the builder and constructs a [`DashManifest`](crate::model::DashManifest)
        pub fn build(self) -> crate::model::DashManifest {
            crate::model::DashManifest {
                manifest_layout: self.manifest_layout,
                manifest_name: self.manifest_name,
                min_buffer_time_seconds: self.min_buffer_time_seconds.unwrap_or_default(),
                profile: self.profile,
                stream_selection: self.stream_selection,
            }
        }
    }
}
impl DashManifest {
    /// Creates a new builder-style object to manufacture [`DashManifest`](crate::model::DashManifest)
    pub fn builder() -> crate::model::dash_manifest::Builder {
        crate::model::dash_manifest::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Profile {
    #[allow(missing_docs)] // documentation missing in model
    Hbbtv15,
    #[allow(missing_docs)] // documentation missing in model
    None,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Profile {
    fn from(s: &str) -> Self {
        match s {
            "HBBTV_1_5" => Profile::Hbbtv15,
            "NONE" => Profile::None,
            other => Profile::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Profile {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Profile::from(s))
    }
}
impl Profile {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Profile::Hbbtv15 => "HBBTV_1_5",
            Profile::None => "NONE",
            Profile::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HBBTV_1_5", "NONE"]
    }
}
impl AsRef<str> for Profile {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ManifestLayout {
    #[allow(missing_docs)] // documentation missing in model
    Compact,
    #[allow(missing_docs)] // documentation missing in model
    Full,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ManifestLayout {
    fn from(s: &str) -> Self {
        match s {
            "COMPACT" => ManifestLayout::Compact,
            "FULL" => ManifestLayout::Full,
            other => ManifestLayout::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ManifestLayout {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ManifestLayout::from(s))
    }
}
impl ManifestLayout {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ManifestLayout::Compact => "COMPACT",
            ManifestLayout::Full => "FULL",
            ManifestLayout::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COMPACT", "FULL"]
    }
}
impl AsRef<str> for ManifestLayout {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// A CMAF packaging configuration.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CmafPackage {
    /// A CMAF encryption configuration.
    pub encryption: std::option::Option<crate::model::CmafEncryption>,
    /// A list of HLS manifest configurations.
    pub hls_manifests: std::option::Option<std::vec::Vec<crate::model::HlsManifest>>,
    /// When includeEncoderConfigurationInSegments is set to true, MediaPackage places your encoder's Sequence Parameter Set (SPS), Picture Parameter Set (PPS), and Video Parameter Set (VPS) metadata in every video segment instead of in the init fragment. This lets you use different SPS/PPS/VPS settings for your assets during content playback.
    pub include_encoder_configuration_in_segments: bool,
    /// Duration (in seconds) of each fragment. Actual fragments will be
    /// rounded to the nearest multiple of the source fragment duration.
    pub segment_duration_seconds: i32,
}
impl std::fmt::Debug for CmafPackage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CmafPackage");
        formatter.field("encryption", &self.encryption);
        formatter.field("hls_manifests", &self.hls_manifests);
        formatter.field(
            "include_encoder_configuration_in_segments",
            &self.include_encoder_configuration_in_segments,
        );
        formatter.field("segment_duration_seconds", &self.segment_duration_seconds);
        formatter.finish()
    }
}
/// See [`CmafPackage`](crate::model::CmafPackage)
pub mod cmaf_package {
    /// A builder for [`CmafPackage`](crate::model::CmafPackage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) encryption: std::option::Option<crate::model::CmafEncryption>,
        pub(crate) hls_manifests: std::option::Option<std::vec::Vec<crate::model::HlsManifest>>,
        pub(crate) include_encoder_configuration_in_segments: std::option::Option<bool>,
        pub(crate) segment_duration_seconds: std::option::Option<i32>,
    }
    impl Builder {
        /// A CMAF encryption configuration.
        pub fn encryption(mut self, input: crate::model::CmafEncryption) -> Self {
            self.encryption = Some(input);
            self
        }
        /// A CMAF encryption configuration.
        pub fn set_encryption(
            mut self,
            input: std::option::Option<crate::model::CmafEncryption>,
        ) -> Self {
            self.encryption = input;
            self
        }
        /// Appends an item to `hls_manifests`.
        ///
        /// To override the contents of this collection use [`set_hls_manifests`](Self::set_hls_manifests).
        ///
        /// A list of HLS manifest configurations.
        pub fn hls_manifests(mut self, input: impl Into<crate::model::HlsManifest>) -> Self {
            let mut v = self.hls_manifests.unwrap_or_default();
            v.push(input.into());
            self.hls_manifests = Some(v);
            self
        }
        /// A list of HLS manifest configurations.
        pub fn set_hls_manifests(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HlsManifest>>,
        ) -> Self {
            self.hls_manifests = input;
            self
        }
        /// When includeEncoderConfigurationInSegments is set to true, MediaPackage places your encoder's Sequence Parameter Set (SPS), Picture Parameter Set (PPS), and Video Parameter Set (VPS) metadata in every video segment instead of in the init fragment. This lets you use different SPS/PPS/VPS settings for your assets during content playback.
        pub fn include_encoder_configuration_in_segments(mut self, input: bool) -> Self {
            self.include_encoder_configuration_in_segments = Some(input);
            self
        }
        /// When includeEncoderConfigurationInSegments is set to true, MediaPackage places your encoder's Sequence Parameter Set (SPS), Picture Parameter Set (PPS), and Video Parameter Set (VPS) metadata in every video segment instead of in the init fragment. This lets you use different SPS/PPS/VPS settings for your assets during content playback.
        pub fn set_include_encoder_configuration_in_segments(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.include_encoder_configuration_in_segments = input;
            self
        }
        /// Duration (in seconds) of each fragment. Actual fragments will be
        /// rounded to the nearest multiple of the source fragment duration.
        pub fn segment_duration_seconds(mut self, input: i32) -> Self {
            self.segment_duration_seconds = Some(input);
            self
        }
        /// Duration (in seconds) of each fragment. Actual fragments will be
        /// rounded to the nearest multiple of the source fragment duration.
        pub fn set_segment_duration_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.segment_duration_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`CmafPackage`](crate::model::CmafPackage)
        pub fn build(self) -> crate::model::CmafPackage {
            crate::model::CmafPackage {
                encryption: self.encryption,
                hls_manifests: self.hls_manifests,
                include_encoder_configuration_in_segments: self
                    .include_encoder_configuration_in_segments
                    .unwrap_or_default(),
                segment_duration_seconds: self.segment_duration_seconds.unwrap_or_default(),
            }
        }
    }
}
impl CmafPackage {
    /// Creates a new builder-style object to manufacture [`CmafPackage`](crate::model::CmafPackage)
    pub fn builder() -> crate::model::cmaf_package::Builder {
        crate::model::cmaf_package::Builder::default()
    }
}

/// A CMAF encryption configuration.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CmafEncryption {
    /// An optional 128-bit, 16-byte hex value represented by a 32-character string, used in conjunction with the key for encrypting blocks. If you don't specify a value, then MediaPackage creates the constant initialization vector (IV).
    pub constant_initialization_vector: std::option::Option<std::string::String>,
    /// A configuration for accessing an external Secure Packager and Encoder Key Exchange (SPEKE) service that will provide encryption keys.
    pub speke_key_provider: std::option::Option<crate::model::SpekeKeyProvider>,
}
impl std::fmt::Debug for CmafEncryption {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CmafEncryption");
        formatter.field(
            "constant_initialization_vector",
            &self.constant_initialization_vector,
        );
        formatter.field("speke_key_provider", &self.speke_key_provider);
        formatter.finish()
    }
}
/// See [`CmafEncryption`](crate::model::CmafEncryption)
pub mod cmaf_encryption {
    /// A builder for [`CmafEncryption`](crate::model::CmafEncryption)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) constant_initialization_vector: std::option::Option<std::string::String>,
        pub(crate) speke_key_provider: std::option::Option<crate::model::SpekeKeyProvider>,
    }
    impl Builder {
        /// An optional 128-bit, 16-byte hex value represented by a 32-character string, used in conjunction with the key for encrypting blocks. If you don't specify a value, then MediaPackage creates the constant initialization vector (IV).
        pub fn constant_initialization_vector(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.constant_initialization_vector = Some(input.into());
            self
        }
        /// An optional 128-bit, 16-byte hex value represented by a 32-character string, used in conjunction with the key for encrypting blocks. If you don't specify a value, then MediaPackage creates the constant initialization vector (IV).
        pub fn set_constant_initialization_vector(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.constant_initialization_vector = input;
            self
        }
        /// A configuration for accessing an external Secure Packager and Encoder Key Exchange (SPEKE) service that will provide encryption keys.
        pub fn speke_key_provider(mut self, input: crate::model::SpekeKeyProvider) -> Self {
            self.speke_key_provider = Some(input);
            self
        }
        /// A configuration for accessing an external Secure Packager and Encoder Key Exchange (SPEKE) service that will provide encryption keys.
        pub fn set_speke_key_provider(
            mut self,
            input: std::option::Option<crate::model::SpekeKeyProvider>,
        ) -> Self {
            self.speke_key_provider = input;
            self
        }
        /// Consumes the builder and constructs a [`CmafEncryption`](crate::model::CmafEncryption)
        pub fn build(self) -> crate::model::CmafEncryption {
            crate::model::CmafEncryption {
                constant_initialization_vector: self.constant_initialization_vector,
                speke_key_provider: self.speke_key_provider,
            }
        }
    }
}
impl CmafEncryption {
    /// Creates a new builder-style object to manufacture [`CmafEncryption`](crate::model::CmafEncryption)
    pub fn builder() -> crate::model::cmaf_encryption::Builder {
        crate::model::cmaf_encryption::Builder::default()
    }
}

/// A MediaPackage VOD Asset resource.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssetShallow {
    /// The ARN of the Asset.
    pub arn: std::option::Option<std::string::String>,
    /// The time the Asset was initially submitted for Ingest.
    pub created_at: std::option::Option<std::string::String>,
    /// The unique identifier for the Asset.
    pub id: std::option::Option<std::string::String>,
    /// The ID of the PackagingGroup for the Asset.
    pub packaging_group_id: std::option::Option<std::string::String>,
    /// The resource ID to include in SPEKE key requests.
    pub resource_id: std::option::Option<std::string::String>,
    /// ARN of the source object in S3.
    pub source_arn: std::option::Option<std::string::String>,
    /// The IAM role ARN used to access the source S3 bucket.
    pub source_role_arn: std::option::Option<std::string::String>,
    /// A collection of tags associated with a resource
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for AssetShallow {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssetShallow");
        formatter.field("arn", &self.arn);
        formatter.field("created_at", &self.created_at);
        formatter.field("id", &self.id);
        formatter.field("packaging_group_id", &self.packaging_group_id);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("source_arn", &self.source_arn);
        formatter.field("source_role_arn", &self.source_role_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`AssetShallow`](crate::model::AssetShallow)
pub mod asset_shallow {
    /// A builder for [`AssetShallow`](crate::model::AssetShallow)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) packaging_group_id: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) source_arn: std::option::Option<std::string::String>,
        pub(crate) source_role_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// The ARN of the Asset.
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// The ARN of the Asset.
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// The time the Asset was initially submitted for Ingest.
        pub fn created_at(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_at = Some(input.into());
            self
        }
        /// The time the Asset was initially submitted for Ingest.
        pub fn set_created_at(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_at = input;
            self
        }
        /// The unique identifier for the Asset.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// The unique identifier for the Asset.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// The ID of the PackagingGroup for the Asset.
        pub fn packaging_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.packaging_group_id = Some(input.into());
            self
        }
        /// The ID of the PackagingGroup for the Asset.
        pub fn set_packaging_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.packaging_group_id = input;
            self
        }
        /// The resource ID to include in SPEKE key requests.
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// The resource ID to include in SPEKE key requests.
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// ARN of the source object in S3.
        pub fn source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_arn = Some(input.into());
            self
        }
        /// ARN of the source object in S3.
        pub fn set_source_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_arn = input;
            self
        }
        /// The IAM role ARN used to access the source S3 bucket.
        pub fn source_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_role_arn = Some(input.into());
            self
        }
        /// The IAM role ARN used to access the source S3 bucket.
        pub fn set_source_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_role_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of tags associated with a resource
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// A collection of tags associated with a resource
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`AssetShallow`](crate::model::AssetShallow)
        pub fn build(self) -> crate::model::AssetShallow {
            crate::model::AssetShallow {
                arn: self.arn,
                created_at: self.created_at,
                id: self.id,
                packaging_group_id: self.packaging_group_id,
                resource_id: self.resource_id,
                source_arn: self.source_arn,
                source_role_arn: self.source_role_arn,
                tags: self.tags,
            }
        }
    }
}
impl AssetShallow {
    /// Creates a new builder-style object to manufacture [`AssetShallow`](crate::model::AssetShallow)
    pub fn builder() -> crate::model::asset_shallow::Builder {
        crate::model::asset_shallow::Builder::default()
    }
}

/// The endpoint URL used to access an Asset using one PackagingConfiguration.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EgressEndpoint {
    /// The ID of the PackagingConfiguration being applied to the Asset.
    pub packaging_configuration_id: std::option::Option<std::string::String>,
    /// The current processing status of the asset used for the packaging configuration. The status can be either QUEUED, PROCESSING, PLAYABLE, or FAILED. Status information won't be available for most assets ingested before 2021-09-30.
    pub status: std::option::Option<std::string::String>,
    /// The URL of the parent manifest for the repackaged Asset.
    pub url: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for EgressEndpoint {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EgressEndpoint");
        formatter.field(
            "packaging_configuration_id",
            &self.packaging_configuration_id,
        );
        formatter.field("status", &self.status);
        formatter.field("url", &self.url);
        formatter.finish()
    }
}
/// See [`EgressEndpoint`](crate::model::EgressEndpoint)
pub mod egress_endpoint {
    /// A builder for [`EgressEndpoint`](crate::model::EgressEndpoint)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) packaging_configuration_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ID of the PackagingConfiguration being applied to the Asset.
        pub fn packaging_configuration_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.packaging_configuration_id = Some(input.into());
            self
        }
        /// The ID of the PackagingConfiguration being applied to the Asset.
        pub fn set_packaging_configuration_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.packaging_configuration_id = input;
            self
        }
        /// The current processing status of the asset used for the packaging configuration. The status can be either QUEUED, PROCESSING, PLAYABLE, or FAILED. Status information won't be available for most assets ingested before 2021-09-30.
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// The current processing status of the asset used for the packaging configuration. The status can be either QUEUED, PROCESSING, PLAYABLE, or FAILED. Status information won't be available for most assets ingested before 2021-09-30.
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// The URL of the parent manifest for the repackaged Asset.
        pub fn url(mut self, input: impl Into<std::string::String>) -> Self {
            self.url = Some(input.into());
            self
        }
        /// The URL of the parent manifest for the repackaged Asset.
        pub fn set_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.url = input;
            self
        }
        /// Consumes the builder and constructs a [`EgressEndpoint`](crate::model::EgressEndpoint)
        pub fn build(self) -> crate::model::EgressEndpoint {
            crate::model::EgressEndpoint {
                packaging_configuration_id: self.packaging_configuration_id,
                status: self.status,
                url: self.url,
            }
        }
    }
}
impl EgressEndpoint {
    /// Creates a new builder-style object to manufacture [`EgressEndpoint`](crate::model::EgressEndpoint)
    pub fn builder() -> crate::model::egress_endpoint::Builder {
        crate::model::egress_endpoint::Builder::default()
    }
}
