// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for AWS Elemental MediaPackage
///
/// Client for invoking operations on AWS Elemental MediaPackage. Each operation on AWS Elemental MediaPackage is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_mediapackage::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_mediapackage::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_mediapackage::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`ConfigureLogs`](crate::client::fluent_builders::ConfigureLogs) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`egress_access_logs(EgressAccessLogs)`](crate::client::fluent_builders::ConfigureLogs::egress_access_logs) / [`set_egress_access_logs(Option<EgressAccessLogs>)`](crate::client::fluent_builders::ConfigureLogs::set_egress_access_logs): Configure egress access logging.
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::ConfigureLogs::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::ConfigureLogs::set_id): The ID of the channel to log subscription.
    ///   - [`ingress_access_logs(IngressAccessLogs)`](crate::client::fluent_builders::ConfigureLogs::ingress_access_logs) / [`set_ingress_access_logs(Option<IngressAccessLogs>)`](crate::client::fluent_builders::ConfigureLogs::set_ingress_access_logs): Configure ingress access logging.
    /// - On success, responds with [`ConfigureLogsOutput`](crate::output::ConfigureLogsOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::ConfigureLogsOutput::arn): The Amazon Resource Name (ARN) assigned to the Channel.
    ///   - [`description(Option<String>)`](crate::output::ConfigureLogsOutput::description): A short text description of the Channel.
    ///   - [`egress_access_logs(Option<EgressAccessLogs>)`](crate::output::ConfigureLogsOutput::egress_access_logs): Configure egress access logging.
    ///   - [`hls_ingest(Option<HlsIngest>)`](crate::output::ConfigureLogsOutput::hls_ingest): An HTTP Live Streaming (HLS) ingest resource configuration.
    ///   - [`id(Option<String>)`](crate::output::ConfigureLogsOutput::id): The ID of the Channel.
    ///   - [`ingress_access_logs(Option<IngressAccessLogs>)`](crate::output::ConfigureLogsOutput::ingress_access_logs): Configure ingress access logging.
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ConfigureLogsOutput::tags): A collection of tags associated with a resource
    /// - On failure, responds with [`SdkError<ConfigureLogsError>`](crate::error::ConfigureLogsError)
    pub fn configure_logs(&self) -> fluent_builders::ConfigureLogs {
        fluent_builders::ConfigureLogs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateChannel`](crate::client::fluent_builders::CreateChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateChannel::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateChannel::set_description): A short text description of the Channel.
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::CreateChannel::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::CreateChannel::set_id): The ID of the Channel. The ID must be unique within the region and it cannot be changed after a Channel is created.
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateChannel::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateChannel::set_tags): A collection of tags associated with a resource
    /// - On success, responds with [`CreateChannelOutput`](crate::output::CreateChannelOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::CreateChannelOutput::arn): The Amazon Resource Name (ARN) assigned to the Channel.
    ///   - [`description(Option<String>)`](crate::output::CreateChannelOutput::description): A short text description of the Channel.
    ///   - [`egress_access_logs(Option<EgressAccessLogs>)`](crate::output::CreateChannelOutput::egress_access_logs): Configure egress access logging.
    ///   - [`hls_ingest(Option<HlsIngest>)`](crate::output::CreateChannelOutput::hls_ingest): An HTTP Live Streaming (HLS) ingest resource configuration.
    ///   - [`id(Option<String>)`](crate::output::CreateChannelOutput::id): The ID of the Channel.
    ///   - [`ingress_access_logs(Option<IngressAccessLogs>)`](crate::output::CreateChannelOutput::ingress_access_logs): Configure ingress access logging.
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::CreateChannelOutput::tags): A collection of tags associated with a resource
    /// - On failure, responds with [`SdkError<CreateChannelError>`](crate::error::CreateChannelError)
    pub fn create_channel(&self) -> fluent_builders::CreateChannel {
        fluent_builders::CreateChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateHarvestJob`](crate::client::fluent_builders::CreateHarvestJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`end_time(impl Into<String>)`](crate::client::fluent_builders::CreateHarvestJob::end_time) / [`set_end_time(Option<String>)`](crate::client::fluent_builders::CreateHarvestJob::set_end_time): The end of the time-window which will be harvested
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::CreateHarvestJob::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::CreateHarvestJob::set_id): The ID of the HarvestJob. The ID must be unique within the region and it cannot be changed after the HarvestJob is submitted
    ///   - [`origin_endpoint_id(impl Into<String>)`](crate::client::fluent_builders::CreateHarvestJob::origin_endpoint_id) / [`set_origin_endpoint_id(Option<String>)`](crate::client::fluent_builders::CreateHarvestJob::set_origin_endpoint_id): The ID of the OriginEndpoint that the HarvestJob will harvest from. This cannot be changed after the HarvestJob is submitted.
    ///   - [`s3_destination(S3Destination)`](crate::client::fluent_builders::CreateHarvestJob::s3_destination) / [`set_s3_destination(Option<S3Destination>)`](crate::client::fluent_builders::CreateHarvestJob::set_s3_destination): Configuration parameters for where in an S3 bucket to place the harvested content
    ///   - [`start_time(impl Into<String>)`](crate::client::fluent_builders::CreateHarvestJob::start_time) / [`set_start_time(Option<String>)`](crate::client::fluent_builders::CreateHarvestJob::set_start_time): The start of the time-window which will be harvested
    /// - On success, responds with [`CreateHarvestJobOutput`](crate::output::CreateHarvestJobOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::CreateHarvestJobOutput::arn): The Amazon Resource Name (ARN) assigned to the HarvestJob.
    ///   - [`channel_id(Option<String>)`](crate::output::CreateHarvestJobOutput::channel_id): The ID of the Channel that the HarvestJob will harvest from.
    ///   - [`created_at(Option<String>)`](crate::output::CreateHarvestJobOutput::created_at): The time the HarvestJob was submitted
    ///   - [`end_time(Option<String>)`](crate::output::CreateHarvestJobOutput::end_time): The end of the time-window which will be harvested.
    ///   - [`id(Option<String>)`](crate::output::CreateHarvestJobOutput::id): The ID of the HarvestJob. The ID must be unique within the region and it cannot be changed after the HarvestJob is submitted.
    ///   - [`origin_endpoint_id(Option<String>)`](crate::output::CreateHarvestJobOutput::origin_endpoint_id): The ID of the OriginEndpoint that the HarvestJob will harvest from. This cannot be changed after the HarvestJob is submitted.
    ///   - [`s3_destination(Option<S3Destination>)`](crate::output::CreateHarvestJobOutput::s3_destination): Configuration parameters for where in an S3 bucket to place the harvested content
    ///   - [`start_time(Option<String>)`](crate::output::CreateHarvestJobOutput::start_time): The start of the time-window which will be harvested.
    ///   - [`status(Option<Status>)`](crate::output::CreateHarvestJobOutput::status): The current status of the HarvestJob. Consider setting up a CloudWatch Event to listen for HarvestJobs as they succeed or fail. In the event of failure, the CloudWatch Event will include an explanation of why the HarvestJob failed.
    /// - On failure, responds with [`SdkError<CreateHarvestJobError>`](crate::error::CreateHarvestJobError)
    pub fn create_harvest_job(&self) -> fluent_builders::CreateHarvestJob {
        fluent_builders::CreateHarvestJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateOriginEndpoint`](crate::client::fluent_builders::CreateOriginEndpoint) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`authorization(Authorization)`](crate::client::fluent_builders::CreateOriginEndpoint::authorization) / [`set_authorization(Option<Authorization>)`](crate::client::fluent_builders::CreateOriginEndpoint::set_authorization): CDN Authorization credentials
    ///   - [`channel_id(impl Into<String>)`](crate::client::fluent_builders::CreateOriginEndpoint::channel_id) / [`set_channel_id(Option<String>)`](crate::client::fluent_builders::CreateOriginEndpoint::set_channel_id): The ID of the Channel that the OriginEndpoint will be associated with. This cannot be changed after the OriginEndpoint is created.
    ///   - [`cmaf_package(CmafPackageCreateOrUpdateParameters)`](crate::client::fluent_builders::CreateOriginEndpoint::cmaf_package) / [`set_cmaf_package(Option<CmafPackageCreateOrUpdateParameters>)`](crate::client::fluent_builders::CreateOriginEndpoint::set_cmaf_package): A Common Media Application Format (CMAF) packaging configuration.
    ///   - [`dash_package(DashPackage)`](crate::client::fluent_builders::CreateOriginEndpoint::dash_package) / [`set_dash_package(Option<DashPackage>)`](crate::client::fluent_builders::CreateOriginEndpoint::set_dash_package): A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateOriginEndpoint::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateOriginEndpoint::set_description): A short text description of the OriginEndpoint.
    ///   - [`hls_package(HlsPackage)`](crate::client::fluent_builders::CreateOriginEndpoint::hls_package) / [`set_hls_package(Option<HlsPackage>)`](crate::client::fluent_builders::CreateOriginEndpoint::set_hls_package): An HTTP Live Streaming (HLS) packaging configuration.
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::CreateOriginEndpoint::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::CreateOriginEndpoint::set_id): The ID of the OriginEndpoint. The ID must be unique within the region and it cannot be changed after the OriginEndpoint is created.
    ///   - [`manifest_name(impl Into<String>)`](crate::client::fluent_builders::CreateOriginEndpoint::manifest_name) / [`set_manifest_name(Option<String>)`](crate::client::fluent_builders::CreateOriginEndpoint::set_manifest_name): A short string that will be used as the filename of the OriginEndpoint URL (defaults to "index").
    ///   - [`mss_package(MssPackage)`](crate::client::fluent_builders::CreateOriginEndpoint::mss_package) / [`set_mss_package(Option<MssPackage>)`](crate::client::fluent_builders::CreateOriginEndpoint::set_mss_package): A Microsoft Smooth Streaming (MSS) packaging configuration.
    ///   - [`origination(Origination)`](crate::client::fluent_builders::CreateOriginEndpoint::origination) / [`set_origination(Option<Origination>)`](crate::client::fluent_builders::CreateOriginEndpoint::set_origination): Control whether origination of video is allowed for this OriginEndpoint. If set to ALLOW, the OriginEndpoint may by requested, pursuant to any other form of access control. If set to DENY, the OriginEndpoint may not be requested. This can be helpful for Live to VOD harvesting, or for temporarily disabling origination
    ///   - [`startover_window_seconds(i32)`](crate::client::fluent_builders::CreateOriginEndpoint::startover_window_seconds) / [`set_startover_window_seconds(i32)`](crate::client::fluent_builders::CreateOriginEndpoint::set_startover_window_seconds): Maximum duration (seconds) of content to retain for startover playback. If not specified, startover playback will be disabled for the OriginEndpoint.
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateOriginEndpoint::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateOriginEndpoint::set_tags): A collection of tags associated with a resource
    ///   - [`time_delay_seconds(i32)`](crate::client::fluent_builders::CreateOriginEndpoint::time_delay_seconds) / [`set_time_delay_seconds(i32)`](crate::client::fluent_builders::CreateOriginEndpoint::set_time_delay_seconds): Amount of delay (seconds) to enforce on the playback of live content. If not specified, there will be no time delay in effect for the OriginEndpoint.
    ///   - [`whitelist(Vec<String>)`](crate::client::fluent_builders::CreateOriginEndpoint::whitelist) / [`set_whitelist(Option<Vec<String>>)`](crate::client::fluent_builders::CreateOriginEndpoint::set_whitelist): A list of source IP CIDR blocks that will be allowed to access the OriginEndpoint.
    /// - On success, responds with [`CreateOriginEndpointOutput`](crate::output::CreateOriginEndpointOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::CreateOriginEndpointOutput::arn): The Amazon Resource Name (ARN) assigned to the OriginEndpoint.
    ///   - [`authorization(Option<Authorization>)`](crate::output::CreateOriginEndpointOutput::authorization): CDN Authorization credentials
    ///   - [`channel_id(Option<String>)`](crate::output::CreateOriginEndpointOutput::channel_id): The ID of the Channel the OriginEndpoint is associated with.
    ///   - [`cmaf_package(Option<CmafPackage>)`](crate::output::CreateOriginEndpointOutput::cmaf_package): A Common Media Application Format (CMAF) packaging configuration.
    ///   - [`dash_package(Option<DashPackage>)`](crate::output::CreateOriginEndpointOutput::dash_package): A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
    ///   - [`description(Option<String>)`](crate::output::CreateOriginEndpointOutput::description): A short text description of the OriginEndpoint.
    ///   - [`hls_package(Option<HlsPackage>)`](crate::output::CreateOriginEndpointOutput::hls_package): An HTTP Live Streaming (HLS) packaging configuration.
    ///   - [`id(Option<String>)`](crate::output::CreateOriginEndpointOutput::id): The ID of the OriginEndpoint.
    ///   - [`manifest_name(Option<String>)`](crate::output::CreateOriginEndpointOutput::manifest_name): A short string appended to the end of the OriginEndpoint URL.
    ///   - [`mss_package(Option<MssPackage>)`](crate::output::CreateOriginEndpointOutput::mss_package): A Microsoft Smooth Streaming (MSS) packaging configuration.
    ///   - [`origination(Option<Origination>)`](crate::output::CreateOriginEndpointOutput::origination): Control whether origination of video is allowed for this OriginEndpoint. If set to ALLOW, the OriginEndpoint may by requested, pursuant to any other form of access control. If set to DENY, the OriginEndpoint may not be requested. This can be helpful for Live to VOD harvesting, or for temporarily disabling origination
    ///   - [`startover_window_seconds(i32)`](crate::output::CreateOriginEndpointOutput::startover_window_seconds): Maximum duration (seconds) of content to retain for startover playback. If not specified, startover playback will be disabled for the OriginEndpoint.
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::CreateOriginEndpointOutput::tags): A collection of tags associated with a resource
    ///   - [`time_delay_seconds(i32)`](crate::output::CreateOriginEndpointOutput::time_delay_seconds): Amount of delay (seconds) to enforce on the playback of live content. If not specified, there will be no time delay in effect for the OriginEndpoint.
    ///   - [`url(Option<String>)`](crate::output::CreateOriginEndpointOutput::url): The URL of the packaged OriginEndpoint for consumption.
    ///   - [`whitelist(Option<Vec<String>>)`](crate::output::CreateOriginEndpointOutput::whitelist): A list of source IP CIDR blocks that will be allowed to access the OriginEndpoint.
    /// - On failure, responds with [`SdkError<CreateOriginEndpointError>`](crate::error::CreateOriginEndpointError)
    pub fn create_origin_endpoint(&self) -> fluent_builders::CreateOriginEndpoint {
        fluent_builders::CreateOriginEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteChannel`](crate::client::fluent_builders::DeleteChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeleteChannel::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeleteChannel::set_id): The ID of the Channel to delete.
    /// - On success, responds with [`DeleteChannelOutput`](crate::output::DeleteChannelOutput)

    /// - On failure, responds with [`SdkError<DeleteChannelError>`](crate::error::DeleteChannelError)
    pub fn delete_channel(&self) -> fluent_builders::DeleteChannel {
        fluent_builders::DeleteChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteOriginEndpoint`](crate::client::fluent_builders::DeleteOriginEndpoint) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeleteOriginEndpoint::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeleteOriginEndpoint::set_id): The ID of the OriginEndpoint to delete.
    /// - On success, responds with [`DeleteOriginEndpointOutput`](crate::output::DeleteOriginEndpointOutput)

    /// - On failure, responds with [`SdkError<DeleteOriginEndpointError>`](crate::error::DeleteOriginEndpointError)
    pub fn delete_origin_endpoint(&self) -> fluent_builders::DeleteOriginEndpoint {
        fluent_builders::DeleteOriginEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeChannel`](crate::client::fluent_builders::DescribeChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DescribeChannel::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DescribeChannel::set_id): The ID of a Channel.
    /// - On success, responds with [`DescribeChannelOutput`](crate::output::DescribeChannelOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::DescribeChannelOutput::arn): The Amazon Resource Name (ARN) assigned to the Channel.
    ///   - [`description(Option<String>)`](crate::output::DescribeChannelOutput::description): A short text description of the Channel.
    ///   - [`egress_access_logs(Option<EgressAccessLogs>)`](crate::output::DescribeChannelOutput::egress_access_logs): Configure egress access logging.
    ///   - [`hls_ingest(Option<HlsIngest>)`](crate::output::DescribeChannelOutput::hls_ingest): An HTTP Live Streaming (HLS) ingest resource configuration.
    ///   - [`id(Option<String>)`](crate::output::DescribeChannelOutput::id): The ID of the Channel.
    ///   - [`ingress_access_logs(Option<IngressAccessLogs>)`](crate::output::DescribeChannelOutput::ingress_access_logs): Configure ingress access logging.
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::DescribeChannelOutput::tags): A collection of tags associated with a resource
    /// - On failure, responds with [`SdkError<DescribeChannelError>`](crate::error::DescribeChannelError)
    pub fn describe_channel(&self) -> fluent_builders::DescribeChannel {
        fluent_builders::DescribeChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeHarvestJob`](crate::client::fluent_builders::DescribeHarvestJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DescribeHarvestJob::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DescribeHarvestJob::set_id): The ID of the HarvestJob.
    /// - On success, responds with [`DescribeHarvestJobOutput`](crate::output::DescribeHarvestJobOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::DescribeHarvestJobOutput::arn): The Amazon Resource Name (ARN) assigned to the HarvestJob.
    ///   - [`channel_id(Option<String>)`](crate::output::DescribeHarvestJobOutput::channel_id): The ID of the Channel that the HarvestJob will harvest from.
    ///   - [`created_at(Option<String>)`](crate::output::DescribeHarvestJobOutput::created_at): The time the HarvestJob was submitted
    ///   - [`end_time(Option<String>)`](crate::output::DescribeHarvestJobOutput::end_time): The end of the time-window which will be harvested.
    ///   - [`id(Option<String>)`](crate::output::DescribeHarvestJobOutput::id): The ID of the HarvestJob. The ID must be unique within the region and it cannot be changed after the HarvestJob is submitted.
    ///   - [`origin_endpoint_id(Option<String>)`](crate::output::DescribeHarvestJobOutput::origin_endpoint_id): The ID of the OriginEndpoint that the HarvestJob will harvest from. This cannot be changed after the HarvestJob is submitted.
    ///   - [`s3_destination(Option<S3Destination>)`](crate::output::DescribeHarvestJobOutput::s3_destination): Configuration parameters for where in an S3 bucket to place the harvested content
    ///   - [`start_time(Option<String>)`](crate::output::DescribeHarvestJobOutput::start_time): The start of the time-window which will be harvested.
    ///   - [`status(Option<Status>)`](crate::output::DescribeHarvestJobOutput::status): The current status of the HarvestJob. Consider setting up a CloudWatch Event to listen for HarvestJobs as they succeed or fail. In the event of failure, the CloudWatch Event will include an explanation of why the HarvestJob failed.
    /// - On failure, responds with [`SdkError<DescribeHarvestJobError>`](crate::error::DescribeHarvestJobError)
    pub fn describe_harvest_job(&self) -> fluent_builders::DescribeHarvestJob {
        fluent_builders::DescribeHarvestJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeOriginEndpoint`](crate::client::fluent_builders::DescribeOriginEndpoint) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DescribeOriginEndpoint::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DescribeOriginEndpoint::set_id): The ID of the OriginEndpoint.
    /// - On success, responds with [`DescribeOriginEndpointOutput`](crate::output::DescribeOriginEndpointOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::DescribeOriginEndpointOutput::arn): The Amazon Resource Name (ARN) assigned to the OriginEndpoint.
    ///   - [`authorization(Option<Authorization>)`](crate::output::DescribeOriginEndpointOutput::authorization): CDN Authorization credentials
    ///   - [`channel_id(Option<String>)`](crate::output::DescribeOriginEndpointOutput::channel_id): The ID of the Channel the OriginEndpoint is associated with.
    ///   - [`cmaf_package(Option<CmafPackage>)`](crate::output::DescribeOriginEndpointOutput::cmaf_package): A Common Media Application Format (CMAF) packaging configuration.
    ///   - [`dash_package(Option<DashPackage>)`](crate::output::DescribeOriginEndpointOutput::dash_package): A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
    ///   - [`description(Option<String>)`](crate::output::DescribeOriginEndpointOutput::description): A short text description of the OriginEndpoint.
    ///   - [`hls_package(Option<HlsPackage>)`](crate::output::DescribeOriginEndpointOutput::hls_package): An HTTP Live Streaming (HLS) packaging configuration.
    ///   - [`id(Option<String>)`](crate::output::DescribeOriginEndpointOutput::id): The ID of the OriginEndpoint.
    ///   - [`manifest_name(Option<String>)`](crate::output::DescribeOriginEndpointOutput::manifest_name): A short string appended to the end of the OriginEndpoint URL.
    ///   - [`mss_package(Option<MssPackage>)`](crate::output::DescribeOriginEndpointOutput::mss_package): A Microsoft Smooth Streaming (MSS) packaging configuration.
    ///   - [`origination(Option<Origination>)`](crate::output::DescribeOriginEndpointOutput::origination): Control whether origination of video is allowed for this OriginEndpoint. If set to ALLOW, the OriginEndpoint may by requested, pursuant to any other form of access control. If set to DENY, the OriginEndpoint may not be requested. This can be helpful for Live to VOD harvesting, or for temporarily disabling origination
    ///   - [`startover_window_seconds(i32)`](crate::output::DescribeOriginEndpointOutput::startover_window_seconds): Maximum duration (seconds) of content to retain for startover playback. If not specified, startover playback will be disabled for the OriginEndpoint.
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::DescribeOriginEndpointOutput::tags): A collection of tags associated with a resource
    ///   - [`time_delay_seconds(i32)`](crate::output::DescribeOriginEndpointOutput::time_delay_seconds): Amount of delay (seconds) to enforce on the playback of live content. If not specified, there will be no time delay in effect for the OriginEndpoint.
    ///   - [`url(Option<String>)`](crate::output::DescribeOriginEndpointOutput::url): The URL of the packaged OriginEndpoint for consumption.
    ///   - [`whitelist(Option<Vec<String>>)`](crate::output::DescribeOriginEndpointOutput::whitelist): A list of source IP CIDR blocks that will be allowed to access the OriginEndpoint.
    /// - On failure, responds with [`SdkError<DescribeOriginEndpointError>`](crate::error::DescribeOriginEndpointError)
    pub fn describe_origin_endpoint(&self) -> fluent_builders::DescribeOriginEndpoint {
        fluent_builders::DescribeOriginEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListChannels`](crate::client::fluent_builders::ListChannels) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListChannels::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListChannels::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListChannels::set_max_results): Upper bound on number of records to return.
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListChannels::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListChannels::set_next_token): A token used to resume pagination from the end of a previous request.
    /// - On success, responds with [`ListChannelsOutput`](crate::output::ListChannelsOutput) with field(s):
    ///   - [`channels(Option<Vec<Channel>>)`](crate::output::ListChannelsOutput::channels): A list of Channel records.
    ///   - [`next_token(Option<String>)`](crate::output::ListChannelsOutput::next_token): A token that can be used to resume pagination from the end of the collection.
    /// - On failure, responds with [`SdkError<ListChannelsError>`](crate::error::ListChannelsError)
    pub fn list_channels(&self) -> fluent_builders::ListChannels {
        fluent_builders::ListChannels::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListHarvestJobs`](crate::client::fluent_builders::ListHarvestJobs) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListHarvestJobs::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`include_channel_id(impl Into<String>)`](crate::client::fluent_builders::ListHarvestJobs::include_channel_id) / [`set_include_channel_id(Option<String>)`](crate::client::fluent_builders::ListHarvestJobs::set_include_channel_id): When specified, the request will return only HarvestJobs associated with the given Channel ID.
    ///   - [`include_status(impl Into<String>)`](crate::client::fluent_builders::ListHarvestJobs::include_status) / [`set_include_status(Option<String>)`](crate::client::fluent_builders::ListHarvestJobs::set_include_status): When specified, the request will return only HarvestJobs in the given status.
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListHarvestJobs::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListHarvestJobs::set_max_results): The upper bound on the number of records to return.
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListHarvestJobs::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListHarvestJobs::set_next_token): A token used to resume pagination from the end of a previous request.
    /// - On success, responds with [`ListHarvestJobsOutput`](crate::output::ListHarvestJobsOutput) with field(s):
    ///   - [`harvest_jobs(Option<Vec<HarvestJob>>)`](crate::output::ListHarvestJobsOutput::harvest_jobs): A list of HarvestJob records.
    ///   - [`next_token(Option<String>)`](crate::output::ListHarvestJobsOutput::next_token): A token that can be used to resume pagination from the end of the collection.
    /// - On failure, responds with [`SdkError<ListHarvestJobsError>`](crate::error::ListHarvestJobsError)
    pub fn list_harvest_jobs(&self) -> fluent_builders::ListHarvestJobs {
        fluent_builders::ListHarvestJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListOriginEndpoints`](crate::client::fluent_builders::ListOriginEndpoints) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListOriginEndpoints::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_id(impl Into<String>)`](crate::client::fluent_builders::ListOriginEndpoints::channel_id) / [`set_channel_id(Option<String>)`](crate::client::fluent_builders::ListOriginEndpoints::set_channel_id): When specified, the request will return only OriginEndpoints associated with the given Channel ID.
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListOriginEndpoints::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListOriginEndpoints::set_max_results): The upper bound on the number of records to return.
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListOriginEndpoints::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListOriginEndpoints::set_next_token): A token used to resume pagination from the end of a previous request.
    /// - On success, responds with [`ListOriginEndpointsOutput`](crate::output::ListOriginEndpointsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListOriginEndpointsOutput::next_token): A token that can be used to resume pagination from the end of the collection.
    ///   - [`origin_endpoints(Option<Vec<OriginEndpoint>>)`](crate::output::ListOriginEndpointsOutput::origin_endpoints): A list of OriginEndpoint records.
    /// - On failure, responds with [`SdkError<ListOriginEndpointsError>`](crate::error::ListOriginEndpointsError)
    pub fn list_origin_endpoints(&self) -> fluent_builders::ListOriginEndpoints {
        fluent_builders::ListOriginEndpoints::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): (undocumented)
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsForResourceOutput::tags): (undocumented)
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RotateChannelCredentials`](crate::client::fluent_builders::RotateChannelCredentials) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::RotateChannelCredentials::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::RotateChannelCredentials::set_id): The ID of the channel to update.
    /// - On success, responds with [`RotateChannelCredentialsOutput`](crate::output::RotateChannelCredentialsOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::RotateChannelCredentialsOutput::arn): The Amazon Resource Name (ARN) assigned to the Channel.
    ///   - [`description(Option<String>)`](crate::output::RotateChannelCredentialsOutput::description): A short text description of the Channel.
    ///   - [`egress_access_logs(Option<EgressAccessLogs>)`](crate::output::RotateChannelCredentialsOutput::egress_access_logs): Configure egress access logging.
    ///   - [`hls_ingest(Option<HlsIngest>)`](crate::output::RotateChannelCredentialsOutput::hls_ingest): An HTTP Live Streaming (HLS) ingest resource configuration.
    ///   - [`id(Option<String>)`](crate::output::RotateChannelCredentialsOutput::id): The ID of the Channel.
    ///   - [`ingress_access_logs(Option<IngressAccessLogs>)`](crate::output::RotateChannelCredentialsOutput::ingress_access_logs): Configure ingress access logging.
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::RotateChannelCredentialsOutput::tags): A collection of tags associated with a resource
    /// - On failure, responds with [`SdkError<RotateChannelCredentialsError>`](crate::error::RotateChannelCredentialsError)
    pub fn rotate_channel_credentials(&self) -> fluent_builders::RotateChannelCredentials {
        fluent_builders::RotateChannelCredentials::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RotateIngestEndpointCredentials`](crate::client::fluent_builders::RotateIngestEndpointCredentials) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::RotateIngestEndpointCredentials::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::RotateIngestEndpointCredentials::set_id): The ID of the channel the IngestEndpoint is on.
    ///   - [`ingest_endpoint_id(impl Into<String>)`](crate::client::fluent_builders::RotateIngestEndpointCredentials::ingest_endpoint_id) / [`set_ingest_endpoint_id(Option<String>)`](crate::client::fluent_builders::RotateIngestEndpointCredentials::set_ingest_endpoint_id): The id of the IngestEndpoint whose credentials should be rotated
    /// - On success, responds with [`RotateIngestEndpointCredentialsOutput`](crate::output::RotateIngestEndpointCredentialsOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::RotateIngestEndpointCredentialsOutput::arn): The Amazon Resource Name (ARN) assigned to the Channel.
    ///   - [`description(Option<String>)`](crate::output::RotateIngestEndpointCredentialsOutput::description): A short text description of the Channel.
    ///   - [`egress_access_logs(Option<EgressAccessLogs>)`](crate::output::RotateIngestEndpointCredentialsOutput::egress_access_logs): Configure egress access logging.
    ///   - [`hls_ingest(Option<HlsIngest>)`](crate::output::RotateIngestEndpointCredentialsOutput::hls_ingest): An HTTP Live Streaming (HLS) ingest resource configuration.
    ///   - [`id(Option<String>)`](crate::output::RotateIngestEndpointCredentialsOutput::id): The ID of the Channel.
    ///   - [`ingress_access_logs(Option<IngressAccessLogs>)`](crate::output::RotateIngestEndpointCredentialsOutput::ingress_access_logs): Configure ingress access logging.
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::RotateIngestEndpointCredentialsOutput::tags): A collection of tags associated with a resource
    /// - On failure, responds with [`SdkError<RotateIngestEndpointCredentialsError>`](crate::error::RotateIngestEndpointCredentialsError)
    pub fn rotate_ingest_endpoint_credentials(
        &self,
    ) -> fluent_builders::RotateIngestEndpointCredentials {
        fluent_builders::RotateIngestEndpointCredentials::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): (undocumented)
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagResource::set_tags): (undocumented)
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): (undocumented)
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): The key(s) of tag to be deleted
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateChannel`](crate::client::fluent_builders::UpdateChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateChannel::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateChannel::set_description): A short text description of the Channel.
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::UpdateChannel::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::UpdateChannel::set_id): The ID of the Channel to update.
    /// - On success, responds with [`UpdateChannelOutput`](crate::output::UpdateChannelOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::UpdateChannelOutput::arn): The Amazon Resource Name (ARN) assigned to the Channel.
    ///   - [`description(Option<String>)`](crate::output::UpdateChannelOutput::description): A short text description of the Channel.
    ///   - [`egress_access_logs(Option<EgressAccessLogs>)`](crate::output::UpdateChannelOutput::egress_access_logs): Configure egress access logging.
    ///   - [`hls_ingest(Option<HlsIngest>)`](crate::output::UpdateChannelOutput::hls_ingest): An HTTP Live Streaming (HLS) ingest resource configuration.
    ///   - [`id(Option<String>)`](crate::output::UpdateChannelOutput::id): The ID of the Channel.
    ///   - [`ingress_access_logs(Option<IngressAccessLogs>)`](crate::output::UpdateChannelOutput::ingress_access_logs): Configure ingress access logging.
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::UpdateChannelOutput::tags): A collection of tags associated with a resource
    /// - On failure, responds with [`SdkError<UpdateChannelError>`](crate::error::UpdateChannelError)
    pub fn update_channel(&self) -> fluent_builders::UpdateChannel {
        fluent_builders::UpdateChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateOriginEndpoint`](crate::client::fluent_builders::UpdateOriginEndpoint) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`authorization(Authorization)`](crate::client::fluent_builders::UpdateOriginEndpoint::authorization) / [`set_authorization(Option<Authorization>)`](crate::client::fluent_builders::UpdateOriginEndpoint::set_authorization): CDN Authorization credentials
    ///   - [`cmaf_package(CmafPackageCreateOrUpdateParameters)`](crate::client::fluent_builders::UpdateOriginEndpoint::cmaf_package) / [`set_cmaf_package(Option<CmafPackageCreateOrUpdateParameters>)`](crate::client::fluent_builders::UpdateOriginEndpoint::set_cmaf_package): A Common Media Application Format (CMAF) packaging configuration.
    ///   - [`dash_package(DashPackage)`](crate::client::fluent_builders::UpdateOriginEndpoint::dash_package) / [`set_dash_package(Option<DashPackage>)`](crate::client::fluent_builders::UpdateOriginEndpoint::set_dash_package): A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateOriginEndpoint::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateOriginEndpoint::set_description): A short text description of the OriginEndpoint.
    ///   - [`hls_package(HlsPackage)`](crate::client::fluent_builders::UpdateOriginEndpoint::hls_package) / [`set_hls_package(Option<HlsPackage>)`](crate::client::fluent_builders::UpdateOriginEndpoint::set_hls_package): An HTTP Live Streaming (HLS) packaging configuration.
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::UpdateOriginEndpoint::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::UpdateOriginEndpoint::set_id): The ID of the OriginEndpoint to update.
    ///   - [`manifest_name(impl Into<String>)`](crate::client::fluent_builders::UpdateOriginEndpoint::manifest_name) / [`set_manifest_name(Option<String>)`](crate::client::fluent_builders::UpdateOriginEndpoint::set_manifest_name): A short string that will be appended to the end of the Endpoint URL.
    ///   - [`mss_package(MssPackage)`](crate::client::fluent_builders::UpdateOriginEndpoint::mss_package) / [`set_mss_package(Option<MssPackage>)`](crate::client::fluent_builders::UpdateOriginEndpoint::set_mss_package): A Microsoft Smooth Streaming (MSS) packaging configuration.
    ///   - [`origination(Origination)`](crate::client::fluent_builders::UpdateOriginEndpoint::origination) / [`set_origination(Option<Origination>)`](crate::client::fluent_builders::UpdateOriginEndpoint::set_origination): Control whether origination of video is allowed for this OriginEndpoint. If set to ALLOW, the OriginEndpoint may by requested, pursuant to any other form of access control. If set to DENY, the OriginEndpoint may not be requested. This can be helpful for Live to VOD harvesting, or for temporarily disabling origination
    ///   - [`startover_window_seconds(i32)`](crate::client::fluent_builders::UpdateOriginEndpoint::startover_window_seconds) / [`set_startover_window_seconds(i32)`](crate::client::fluent_builders::UpdateOriginEndpoint::set_startover_window_seconds): Maximum duration (in seconds) of content to retain for startover playback. If not specified, startover playback will be disabled for the OriginEndpoint.
    ///   - [`time_delay_seconds(i32)`](crate::client::fluent_builders::UpdateOriginEndpoint::time_delay_seconds) / [`set_time_delay_seconds(i32)`](crate::client::fluent_builders::UpdateOriginEndpoint::set_time_delay_seconds): Amount of delay (in seconds) to enforce on the playback of live content. If not specified, there will be no time delay in effect for the OriginEndpoint.
    ///   - [`whitelist(Vec<String>)`](crate::client::fluent_builders::UpdateOriginEndpoint::whitelist) / [`set_whitelist(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateOriginEndpoint::set_whitelist): A list of source IP CIDR blocks that will be allowed to access the OriginEndpoint.
    /// - On success, responds with [`UpdateOriginEndpointOutput`](crate::output::UpdateOriginEndpointOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::UpdateOriginEndpointOutput::arn): The Amazon Resource Name (ARN) assigned to the OriginEndpoint.
    ///   - [`authorization(Option<Authorization>)`](crate::output::UpdateOriginEndpointOutput::authorization): CDN Authorization credentials
    ///   - [`channel_id(Option<String>)`](crate::output::UpdateOriginEndpointOutput::channel_id): The ID of the Channel the OriginEndpoint is associated with.
    ///   - [`cmaf_package(Option<CmafPackage>)`](crate::output::UpdateOriginEndpointOutput::cmaf_package): A Common Media Application Format (CMAF) packaging configuration.
    ///   - [`dash_package(Option<DashPackage>)`](crate::output::UpdateOriginEndpointOutput::dash_package): A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
    ///   - [`description(Option<String>)`](crate::output::UpdateOriginEndpointOutput::description): A short text description of the OriginEndpoint.
    ///   - [`hls_package(Option<HlsPackage>)`](crate::output::UpdateOriginEndpointOutput::hls_package): An HTTP Live Streaming (HLS) packaging configuration.
    ///   - [`id(Option<String>)`](crate::output::UpdateOriginEndpointOutput::id): The ID of the OriginEndpoint.
    ///   - [`manifest_name(Option<String>)`](crate::output::UpdateOriginEndpointOutput::manifest_name): A short string appended to the end of the OriginEndpoint URL.
    ///   - [`mss_package(Option<MssPackage>)`](crate::output::UpdateOriginEndpointOutput::mss_package): A Microsoft Smooth Streaming (MSS) packaging configuration.
    ///   - [`origination(Option<Origination>)`](crate::output::UpdateOriginEndpointOutput::origination): Control whether origination of video is allowed for this OriginEndpoint. If set to ALLOW, the OriginEndpoint may by requested, pursuant to any other form of access control. If set to DENY, the OriginEndpoint may not be requested. This can be helpful for Live to VOD harvesting, or for temporarily disabling origination
    ///   - [`startover_window_seconds(i32)`](crate::output::UpdateOriginEndpointOutput::startover_window_seconds): Maximum duration (seconds) of content to retain for startover playback. If not specified, startover playback will be disabled for the OriginEndpoint.
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::UpdateOriginEndpointOutput::tags): A collection of tags associated with a resource
    ///   - [`time_delay_seconds(i32)`](crate::output::UpdateOriginEndpointOutput::time_delay_seconds): Amount of delay (seconds) to enforce on the playback of live content. If not specified, there will be no time delay in effect for the OriginEndpoint.
    ///   - [`url(Option<String>)`](crate::output::UpdateOriginEndpointOutput::url): The URL of the packaged OriginEndpoint for consumption.
    ///   - [`whitelist(Option<Vec<String>>)`](crate::output::UpdateOriginEndpointOutput::whitelist): A list of source IP CIDR blocks that will be allowed to access the OriginEndpoint.
    /// - On failure, responds with [`SdkError<UpdateOriginEndpointError>`](crate::error::UpdateOriginEndpointError)
    pub fn update_origin_endpoint(&self) -> fluent_builders::UpdateOriginEndpoint {
        fluent_builders::UpdateOriginEndpoint::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `ConfigureLogs`.
    ///
    /// Changes the Channel's properities to configure log subscription
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ConfigureLogs {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::configure_logs_input::Builder,
    }
    impl ConfigureLogs {
        /// Creates a new `ConfigureLogs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ConfigureLogsOutput,
            aws_smithy_http::result::SdkError<crate::error::ConfigureLogsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Configure egress access logging.
        pub fn egress_access_logs(mut self, input: crate::model::EgressAccessLogs) -> Self {
            self.inner = self.inner.egress_access_logs(input);
            self
        }
        /// Configure egress access logging.
        pub fn set_egress_access_logs(
            mut self,
            input: std::option::Option<crate::model::EgressAccessLogs>,
        ) -> Self {
            self.inner = self.inner.set_egress_access_logs(input);
            self
        }
        /// The ID of the channel to log subscription.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// The ID of the channel to log subscription.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// Configure ingress access logging.
        pub fn ingress_access_logs(mut self, input: crate::model::IngressAccessLogs) -> Self {
            self.inner = self.inner.ingress_access_logs(input);
            self
        }
        /// Configure ingress access logging.
        pub fn set_ingress_access_logs(
            mut self,
            input: std::option::Option<crate::model::IngressAccessLogs>,
        ) -> Self {
            self.inner = self.inner.set_ingress_access_logs(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateChannel`.
    ///
    /// Creates a new Channel.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateChannel {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_channel_input::Builder,
    }
    impl CreateChannel {
        /// Creates a new `CreateChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateChannelError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// A short text description of the Channel.
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// A short text description of the Channel.
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// The ID of the Channel. The ID must be unique within the region and it cannot be changed after a Channel is created.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// The ID of the Channel. The ID must be unique within the region and it cannot be changed after a Channel is created.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of tags associated with a resource
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// A collection of tags associated with a resource
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateHarvestJob`.
    ///
    /// Creates a new HarvestJob record.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateHarvestJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_harvest_job_input::Builder,
    }
    impl CreateHarvestJob {
        /// Creates a new `CreateHarvestJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateHarvestJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateHarvestJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The end of the time-window which will be harvested
        pub fn end_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.end_time(input.into());
            self
        }
        /// The end of the time-window which will be harvested
        pub fn set_end_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// The ID of the HarvestJob. The ID must be unique within the region and it cannot be changed after the HarvestJob is submitted
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// The ID of the HarvestJob. The ID must be unique within the region and it cannot be changed after the HarvestJob is submitted
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// The ID of the OriginEndpoint that the HarvestJob will harvest from. This cannot be changed after the HarvestJob is submitted.
        pub fn origin_endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.origin_endpoint_id(input.into());
            self
        }
        /// The ID of the OriginEndpoint that the HarvestJob will harvest from. This cannot be changed after the HarvestJob is submitted.
        pub fn set_origin_endpoint_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_origin_endpoint_id(input);
            self
        }
        /// Configuration parameters for where in an S3 bucket to place the harvested content
        pub fn s3_destination(mut self, input: crate::model::S3Destination) -> Self {
            self.inner = self.inner.s3_destination(input);
            self
        }
        /// Configuration parameters for where in an S3 bucket to place the harvested content
        pub fn set_s3_destination(
            mut self,
            input: std::option::Option<crate::model::S3Destination>,
        ) -> Self {
            self.inner = self.inner.set_s3_destination(input);
            self
        }
        /// The start of the time-window which will be harvested
        pub fn start_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.start_time(input.into());
            self
        }
        /// The start of the time-window which will be harvested
        pub fn set_start_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateOriginEndpoint`.
    ///
    /// Creates a new OriginEndpoint record.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateOriginEndpoint {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_origin_endpoint_input::Builder,
    }
    impl CreateOriginEndpoint {
        /// Creates a new `CreateOriginEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateOriginEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateOriginEndpointError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// CDN Authorization credentials
        pub fn authorization(mut self, input: crate::model::Authorization) -> Self {
            self.inner = self.inner.authorization(input);
            self
        }
        /// CDN Authorization credentials
        pub fn set_authorization(
            mut self,
            input: std::option::Option<crate::model::Authorization>,
        ) -> Self {
            self.inner = self.inner.set_authorization(input);
            self
        }
        /// The ID of the Channel that the OriginEndpoint will be associated with. This cannot be changed after the OriginEndpoint is created.
        pub fn channel_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_id(input.into());
            self
        }
        /// The ID of the Channel that the OriginEndpoint will be associated with. This cannot be changed after the OriginEndpoint is created.
        pub fn set_channel_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_id(input);
            self
        }
        /// A Common Media Application Format (CMAF) packaging configuration.
        pub fn cmaf_package(
            mut self,
            input: crate::model::CmafPackageCreateOrUpdateParameters,
        ) -> Self {
            self.inner = self.inner.cmaf_package(input);
            self
        }
        /// A Common Media Application Format (CMAF) packaging configuration.
        pub fn set_cmaf_package(
            mut self,
            input: std::option::Option<crate::model::CmafPackageCreateOrUpdateParameters>,
        ) -> Self {
            self.inner = self.inner.set_cmaf_package(input);
            self
        }
        /// A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
        pub fn dash_package(mut self, input: crate::model::DashPackage) -> Self {
            self.inner = self.inner.dash_package(input);
            self
        }
        /// A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
        pub fn set_dash_package(
            mut self,
            input: std::option::Option<crate::model::DashPackage>,
        ) -> Self {
            self.inner = self.inner.set_dash_package(input);
            self
        }
        /// A short text description of the OriginEndpoint.
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// A short text description of the OriginEndpoint.
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// An HTTP Live Streaming (HLS) packaging configuration.
        pub fn hls_package(mut self, input: crate::model::HlsPackage) -> Self {
            self.inner = self.inner.hls_package(input);
            self
        }
        /// An HTTP Live Streaming (HLS) packaging configuration.
        pub fn set_hls_package(
            mut self,
            input: std::option::Option<crate::model::HlsPackage>,
        ) -> Self {
            self.inner = self.inner.set_hls_package(input);
            self
        }
        /// The ID of the OriginEndpoint. The ID must be unique within the region and it cannot be changed after the OriginEndpoint is created.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// The ID of the OriginEndpoint. The ID must be unique within the region and it cannot be changed after the OriginEndpoint is created.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// A short string that will be used as the filename of the OriginEndpoint URL (defaults to "index").
        pub fn manifest_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.manifest_name(input.into());
            self
        }
        /// A short string that will be used as the filename of the OriginEndpoint URL (defaults to "index").
        pub fn set_manifest_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_manifest_name(input);
            self
        }
        /// A Microsoft Smooth Streaming (MSS) packaging configuration.
        pub fn mss_package(mut self, input: crate::model::MssPackage) -> Self {
            self.inner = self.inner.mss_package(input);
            self
        }
        /// A Microsoft Smooth Streaming (MSS) packaging configuration.
        pub fn set_mss_package(
            mut self,
            input: std::option::Option<crate::model::MssPackage>,
        ) -> Self {
            self.inner = self.inner.set_mss_package(input);
            self
        }
        /// Control whether origination of video is allowed for this OriginEndpoint. If set to ALLOW, the OriginEndpoint may by requested, pursuant to any other form of access control. If set to DENY, the OriginEndpoint may not be requested. This can be helpful for Live to VOD harvesting, or for temporarily disabling origination
        pub fn origination(mut self, input: crate::model::Origination) -> Self {
            self.inner = self.inner.origination(input);
            self
        }
        /// Control whether origination of video is allowed for this OriginEndpoint. If set to ALLOW, the OriginEndpoint may by requested, pursuant to any other form of access control. If set to DENY, the OriginEndpoint may not be requested. This can be helpful for Live to VOD harvesting, or for temporarily disabling origination
        pub fn set_origination(
            mut self,
            input: std::option::Option<crate::model::Origination>,
        ) -> Self {
            self.inner = self.inner.set_origination(input);
            self
        }
        /// Maximum duration (seconds) of content to retain for startover playback. If not specified, startover playback will be disabled for the OriginEndpoint.
        pub fn startover_window_seconds(mut self, input: i32) -> Self {
            self.inner = self.inner.startover_window_seconds(input);
            self
        }
        /// Maximum duration (seconds) of content to retain for startover playback. If not specified, startover playback will be disabled for the OriginEndpoint.
        pub fn set_startover_window_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_startover_window_seconds(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of tags associated with a resource
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// A collection of tags associated with a resource
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// Amount of delay (seconds) to enforce on the playback of live content. If not specified, there will be no time delay in effect for the OriginEndpoint.
        pub fn time_delay_seconds(mut self, input: i32) -> Self {
            self.inner = self.inner.time_delay_seconds(input);
            self
        }
        /// Amount of delay (seconds) to enforce on the playback of live content. If not specified, there will be no time delay in effect for the OriginEndpoint.
        pub fn set_time_delay_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_time_delay_seconds(input);
            self
        }
        /// Appends an item to `Whitelist`.
        ///
        /// To override the contents of this collection use [`set_whitelist`](Self::set_whitelist).
        ///
        /// A list of source IP CIDR blocks that will be allowed to access the OriginEndpoint.
        pub fn whitelist(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.whitelist(input.into());
            self
        }
        /// A list of source IP CIDR blocks that will be allowed to access the OriginEndpoint.
        pub fn set_whitelist(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_whitelist(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteChannel`.
    ///
    /// Deletes an existing Channel.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteChannel {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_channel_input::Builder,
    }
    impl DeleteChannel {
        /// Creates a new `DeleteChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteChannelError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the Channel to delete.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// The ID of the Channel to delete.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteOriginEndpoint`.
    ///
    /// Deletes an existing OriginEndpoint.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteOriginEndpoint {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_origin_endpoint_input::Builder,
    }
    impl DeleteOriginEndpoint {
        /// Creates a new `DeleteOriginEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteOriginEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteOriginEndpointError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the OriginEndpoint to delete.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// The ID of the OriginEndpoint to delete.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeChannel`.
    ///
    /// Gets details about a Channel.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeChannel {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_channel_input::Builder,
    }
    impl DescribeChannel {
        /// Creates a new `DescribeChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeChannelError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of a Channel.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// The ID of a Channel.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeHarvestJob`.
    ///
    /// Gets details about an existing HarvestJob.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeHarvestJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_harvest_job_input::Builder,
    }
    impl DescribeHarvestJob {
        /// Creates a new `DescribeHarvestJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeHarvestJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeHarvestJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the HarvestJob.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// The ID of the HarvestJob.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeOriginEndpoint`.
    ///
    /// Gets details about an existing OriginEndpoint.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeOriginEndpoint {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_origin_endpoint_input::Builder,
    }
    impl DescribeOriginEndpoint {
        /// Creates a new `DescribeOriginEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeOriginEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeOriginEndpointError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the OriginEndpoint.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// The ID of the OriginEndpoint.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListChannels`.
    ///
    /// Returns a collection of Channels.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListChannels {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_channels_input::Builder,
    }
    impl ListChannels {
        /// Creates a new `ListChannels`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListChannelsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListChannelsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListChannelsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListChannelsPaginator {
            crate::paginator::ListChannelsPaginator::new(self.handle, self.inner)
        }
        /// Upper bound on number of records to return.
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// Upper bound on number of records to return.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListHarvestJobs`.
    ///
    /// Returns a collection of HarvestJob records.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListHarvestJobs {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_harvest_jobs_input::Builder,
    }
    impl ListHarvestJobs {
        /// Creates a new `ListHarvestJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListHarvestJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListHarvestJobsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListHarvestJobsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListHarvestJobsPaginator {
            crate::paginator::ListHarvestJobsPaginator::new(self.handle, self.inner)
        }
        /// When specified, the request will return only HarvestJobs associated with the given Channel ID.
        pub fn include_channel_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.include_channel_id(input.into());
            self
        }
        /// When specified, the request will return only HarvestJobs associated with the given Channel ID.
        pub fn set_include_channel_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_include_channel_id(input);
            self
        }
        /// When specified, the request will return only HarvestJobs in the given status.
        pub fn include_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.include_status(input.into());
            self
        }
        /// When specified, the request will return only HarvestJobs in the given status.
        pub fn set_include_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_include_status(input);
            self
        }
        /// The upper bound on the number of records to return.
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// The upper bound on the number of records to return.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListOriginEndpoints`.
    ///
    /// Returns a collection of OriginEndpoint records.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListOriginEndpoints {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_origin_endpoints_input::Builder,
    }
    impl ListOriginEndpoints {
        /// Creates a new `ListOriginEndpoints`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListOriginEndpointsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListOriginEndpointsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListOriginEndpointsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListOriginEndpointsPaginator {
            crate::paginator::ListOriginEndpointsPaginator::new(self.handle, self.inner)
        }
        /// When specified, the request will return only OriginEndpoints associated with the given Channel ID.
        pub fn channel_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_id(input.into());
            self
        }
        /// When specified, the request will return only OriginEndpoints associated with the given Channel ID.
        pub fn set_channel_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_id(input);
            self
        }
        /// The upper bound on the number of records to return.
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// The upper bound on the number of records to return.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RotateChannelCredentials`.
    ///
    /// Changes the Channel's first IngestEndpoint's username and password. WARNING - This API is deprecated. Please use RotateIngestEndpointCredentials instead
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RotateChannelCredentials {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::rotate_channel_credentials_input::Builder,
    }
    impl RotateChannelCredentials {
        /// Creates a new `RotateChannelCredentials`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RotateChannelCredentialsOutput,
            aws_smithy_http::result::SdkError<crate::error::RotateChannelCredentialsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the channel to update.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// The ID of the channel to update.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RotateIngestEndpointCredentials`.
    ///
    /// Rotate the IngestEndpoint's username and password, as specified by the IngestEndpoint's id.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RotateIngestEndpointCredentials {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::rotate_ingest_endpoint_credentials_input::Builder,
    }
    impl RotateIngestEndpointCredentials {
        /// Creates a new `RotateIngestEndpointCredentials`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RotateIngestEndpointCredentialsOutput,
            aws_smithy_http::result::SdkError<crate::error::RotateIngestEndpointCredentialsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the channel the IngestEndpoint is on.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// The ID of the channel the IngestEndpoint is on.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// The id of the IngestEndpoint whose credentials should be rotated
        pub fn ingest_endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ingest_endpoint_id(input.into());
            self
        }
        /// The id of the IngestEndpoint whose credentials should be rotated
        pub fn set_ingest_endpoint_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ingest_endpoint_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        #[allow(missing_docs)] // documentation missing in model
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// The key(s) of tag to be deleted
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// The key(s) of tag to be deleted
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateChannel`.
    ///
    /// Updates an existing Channel.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateChannel {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_channel_input::Builder,
    }
    impl UpdateChannel {
        /// Creates a new `UpdateChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateChannelError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// A short text description of the Channel.
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// A short text description of the Channel.
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// The ID of the Channel to update.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// The ID of the Channel to update.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateOriginEndpoint`.
    ///
    /// Updates an existing OriginEndpoint.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateOriginEndpoint {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_origin_endpoint_input::Builder,
    }
    impl UpdateOriginEndpoint {
        /// Creates a new `UpdateOriginEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateOriginEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateOriginEndpointError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// CDN Authorization credentials
        pub fn authorization(mut self, input: crate::model::Authorization) -> Self {
            self.inner = self.inner.authorization(input);
            self
        }
        /// CDN Authorization credentials
        pub fn set_authorization(
            mut self,
            input: std::option::Option<crate::model::Authorization>,
        ) -> Self {
            self.inner = self.inner.set_authorization(input);
            self
        }
        /// A Common Media Application Format (CMAF) packaging configuration.
        pub fn cmaf_package(
            mut self,
            input: crate::model::CmafPackageCreateOrUpdateParameters,
        ) -> Self {
            self.inner = self.inner.cmaf_package(input);
            self
        }
        /// A Common Media Application Format (CMAF) packaging configuration.
        pub fn set_cmaf_package(
            mut self,
            input: std::option::Option<crate::model::CmafPackageCreateOrUpdateParameters>,
        ) -> Self {
            self.inner = self.inner.set_cmaf_package(input);
            self
        }
        /// A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
        pub fn dash_package(mut self, input: crate::model::DashPackage) -> Self {
            self.inner = self.inner.dash_package(input);
            self
        }
        /// A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
        pub fn set_dash_package(
            mut self,
            input: std::option::Option<crate::model::DashPackage>,
        ) -> Self {
            self.inner = self.inner.set_dash_package(input);
            self
        }
        /// A short text description of the OriginEndpoint.
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// A short text description of the OriginEndpoint.
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// An HTTP Live Streaming (HLS) packaging configuration.
        pub fn hls_package(mut self, input: crate::model::HlsPackage) -> Self {
            self.inner = self.inner.hls_package(input);
            self
        }
        /// An HTTP Live Streaming (HLS) packaging configuration.
        pub fn set_hls_package(
            mut self,
            input: std::option::Option<crate::model::HlsPackage>,
        ) -> Self {
            self.inner = self.inner.set_hls_package(input);
            self
        }
        /// The ID of the OriginEndpoint to update.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// The ID of the OriginEndpoint to update.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// A short string that will be appended to the end of the Endpoint URL.
        pub fn manifest_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.manifest_name(input.into());
            self
        }
        /// A short string that will be appended to the end of the Endpoint URL.
        pub fn set_manifest_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_manifest_name(input);
            self
        }
        /// A Microsoft Smooth Streaming (MSS) packaging configuration.
        pub fn mss_package(mut self, input: crate::model::MssPackage) -> Self {
            self.inner = self.inner.mss_package(input);
            self
        }
        /// A Microsoft Smooth Streaming (MSS) packaging configuration.
        pub fn set_mss_package(
            mut self,
            input: std::option::Option<crate::model::MssPackage>,
        ) -> Self {
            self.inner = self.inner.set_mss_package(input);
            self
        }
        /// Control whether origination of video is allowed for this OriginEndpoint. If set to ALLOW, the OriginEndpoint may by requested, pursuant to any other form of access control. If set to DENY, the OriginEndpoint may not be requested. This can be helpful for Live to VOD harvesting, or for temporarily disabling origination
        pub fn origination(mut self, input: crate::model::Origination) -> Self {
            self.inner = self.inner.origination(input);
            self
        }
        /// Control whether origination of video is allowed for this OriginEndpoint. If set to ALLOW, the OriginEndpoint may by requested, pursuant to any other form of access control. If set to DENY, the OriginEndpoint may not be requested. This can be helpful for Live to VOD harvesting, or for temporarily disabling origination
        pub fn set_origination(
            mut self,
            input: std::option::Option<crate::model::Origination>,
        ) -> Self {
            self.inner = self.inner.set_origination(input);
            self
        }
        /// Maximum duration (in seconds) of content to retain for startover playback. If not specified, startover playback will be disabled for the OriginEndpoint.
        pub fn startover_window_seconds(mut self, input: i32) -> Self {
            self.inner = self.inner.startover_window_seconds(input);
            self
        }
        /// Maximum duration (in seconds) of content to retain for startover playback. If not specified, startover playback will be disabled for the OriginEndpoint.
        pub fn set_startover_window_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_startover_window_seconds(input);
            self
        }
        /// Amount of delay (in seconds) to enforce on the playback of live content. If not specified, there will be no time delay in effect for the OriginEndpoint.
        pub fn time_delay_seconds(mut self, input: i32) -> Self {
            self.inner = self.inner.time_delay_seconds(input);
            self
        }
        /// Amount of delay (in seconds) to enforce on the playback of live content. If not specified, there will be no time delay in effect for the OriginEndpoint.
        pub fn set_time_delay_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_time_delay_seconds(input);
            self
        }
        /// Appends an item to `Whitelist`.
        ///
        /// To override the contents of this collection use [`set_whitelist`](Self::set_whitelist).
        ///
        /// A list of source IP CIDR blocks that will be allowed to access the OriginEndpoint.
        pub fn whitelist(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.whitelist(input.into());
            self
        }
        /// A list of source IP CIDR blocks that will be allowed to access the OriginEndpoint.
        pub fn set_whitelist(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_whitelist(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
