// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `MediaPackage`.
///
/// This client allows ergonomic access to a `MediaPackage`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `ConfigureLogs` operation.
    ///
    /// See [`ConfigureLogs`](crate::client::fluent_builders::ConfigureLogs) for more information about the
    /// operation and its arguments.
    pub fn configure_logs(&self) -> fluent_builders::ConfigureLogs<C, M, R> {
        fluent_builders::ConfigureLogs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateChannel` operation.
    ///
    /// See [`CreateChannel`](crate::client::fluent_builders::CreateChannel) for more information about the
    /// operation and its arguments.
    pub fn create_channel(&self) -> fluent_builders::CreateChannel<C, M, R> {
        fluent_builders::CreateChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateHarvestJob` operation.
    ///
    /// See [`CreateHarvestJob`](crate::client::fluent_builders::CreateHarvestJob) for more information about the
    /// operation and its arguments.
    pub fn create_harvest_job(&self) -> fluent_builders::CreateHarvestJob<C, M, R> {
        fluent_builders::CreateHarvestJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateOriginEndpoint` operation.
    ///
    /// See [`CreateOriginEndpoint`](crate::client::fluent_builders::CreateOriginEndpoint) for more information about the
    /// operation and its arguments.
    pub fn create_origin_endpoint(&self) -> fluent_builders::CreateOriginEndpoint<C, M, R> {
        fluent_builders::CreateOriginEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteChannel` operation.
    ///
    /// See [`DeleteChannel`](crate::client::fluent_builders::DeleteChannel) for more information about the
    /// operation and its arguments.
    pub fn delete_channel(&self) -> fluent_builders::DeleteChannel<C, M, R> {
        fluent_builders::DeleteChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteOriginEndpoint` operation.
    ///
    /// See [`DeleteOriginEndpoint`](crate::client::fluent_builders::DeleteOriginEndpoint) for more information about the
    /// operation and its arguments.
    pub fn delete_origin_endpoint(&self) -> fluent_builders::DeleteOriginEndpoint<C, M, R> {
        fluent_builders::DeleteOriginEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeChannel` operation.
    ///
    /// See [`DescribeChannel`](crate::client::fluent_builders::DescribeChannel) for more information about the
    /// operation and its arguments.
    pub fn describe_channel(&self) -> fluent_builders::DescribeChannel<C, M, R> {
        fluent_builders::DescribeChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeHarvestJob` operation.
    ///
    /// See [`DescribeHarvestJob`](crate::client::fluent_builders::DescribeHarvestJob) for more information about the
    /// operation and its arguments.
    pub fn describe_harvest_job(&self) -> fluent_builders::DescribeHarvestJob<C, M, R> {
        fluent_builders::DescribeHarvestJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeOriginEndpoint` operation.
    ///
    /// See [`DescribeOriginEndpoint`](crate::client::fluent_builders::DescribeOriginEndpoint) for more information about the
    /// operation and its arguments.
    pub fn describe_origin_endpoint(&self) -> fluent_builders::DescribeOriginEndpoint<C, M, R> {
        fluent_builders::DescribeOriginEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListChannels` operation.
    ///
    /// See [`ListChannels`](crate::client::fluent_builders::ListChannels) for more information about the
    /// operation and its arguments.
    pub fn list_channels(&self) -> fluent_builders::ListChannels<C, M, R> {
        fluent_builders::ListChannels::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListHarvestJobs` operation.
    ///
    /// See [`ListHarvestJobs`](crate::client::fluent_builders::ListHarvestJobs) for more information about the
    /// operation and its arguments.
    pub fn list_harvest_jobs(&self) -> fluent_builders::ListHarvestJobs<C, M, R> {
        fluent_builders::ListHarvestJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListOriginEndpoints` operation.
    ///
    /// See [`ListOriginEndpoints`](crate::client::fluent_builders::ListOriginEndpoints) for more information about the
    /// operation and its arguments.
    pub fn list_origin_endpoints(&self) -> fluent_builders::ListOriginEndpoints<C, M, R> {
        fluent_builders::ListOriginEndpoints::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RotateChannelCredentials` operation.
    ///
    /// See [`RotateChannelCredentials`](crate::client::fluent_builders::RotateChannelCredentials) for more information about the
    /// operation and its arguments.
    pub fn rotate_channel_credentials(&self) -> fluent_builders::RotateChannelCredentials<C, M, R> {
        fluent_builders::RotateChannelCredentials::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RotateIngestEndpointCredentials` operation.
    ///
    /// See [`RotateIngestEndpointCredentials`](crate::client::fluent_builders::RotateIngestEndpointCredentials) for more information about the
    /// operation and its arguments.
    pub fn rotate_ingest_endpoint_credentials(
        &self,
    ) -> fluent_builders::RotateIngestEndpointCredentials<C, M, R> {
        fluent_builders::RotateIngestEndpointCredentials::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateChannel` operation.
    ///
    /// See [`UpdateChannel`](crate::client::fluent_builders::UpdateChannel) for more information about the
    /// operation and its arguments.
    pub fn update_channel(&self) -> fluent_builders::UpdateChannel<C, M, R> {
        fluent_builders::UpdateChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateOriginEndpoint` operation.
    ///
    /// See [`UpdateOriginEndpoint`](crate::client::fluent_builders::UpdateOriginEndpoint) for more information about the
    /// operation and its arguments.
    pub fn update_origin_endpoint(&self) -> fluent_builders::UpdateOriginEndpoint<C, M, R> {
        fluent_builders::UpdateOriginEndpoint::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `ConfigureLogs`.
    ///
    /// Changes the Channel's properities to configure log subscription
    #[derive(std::fmt::Debug)]
    pub struct ConfigureLogs<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::configure_logs_input::Builder,
    }
    impl<C, M, R> ConfigureLogs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ConfigureLogs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ConfigureLogsOutput,
            aws_smithy_http::result::SdkError<crate::error::ConfigureLogsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ConfigureLogsInputOperationOutputAlias,
                crate::output::ConfigureLogsOutput,
                crate::error::ConfigureLogsError,
                crate::input::ConfigureLogsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Configure egress access logging.
        pub fn egress_access_logs(mut self, inp: crate::model::EgressAccessLogs) -> Self {
            self.inner = self.inner.egress_access_logs(inp);
            self
        }
        /// Configure egress access logging.
        pub fn set_egress_access_logs(
            mut self,
            input: std::option::Option<crate::model::EgressAccessLogs>,
        ) -> Self {
            self.inner = self.inner.set_egress_access_logs(input);
            self
        }
        /// The ID of the channel to log subscription.
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// The ID of the channel to log subscription.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// Configure ingress access logging.
        pub fn ingress_access_logs(mut self, inp: crate::model::IngressAccessLogs) -> Self {
            self.inner = self.inner.ingress_access_logs(inp);
            self
        }
        /// Configure ingress access logging.
        pub fn set_ingress_access_logs(
            mut self,
            input: std::option::Option<crate::model::IngressAccessLogs>,
        ) -> Self {
            self.inner = self.inner.set_ingress_access_logs(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateChannel`.
    ///
    /// Creates a new Channel.
    #[derive(std::fmt::Debug)]
    pub struct CreateChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_channel_input::Builder,
    }
    impl<C, M, R> CreateChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateChannelInputOperationOutputAlias,
                crate::output::CreateChannelOutput,
                crate::error::CreateChannelError,
                crate::input::CreateChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// A short text description of the Channel.
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// A short text description of the Channel.
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// The ID of the Channel. The ID must be unique within the region and it
        /// cannot be changed after a Channel is created.
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// The ID of the Channel. The ID must be unique within the region and it
        /// cannot be changed after a Channel is created.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of tags associated with a resource
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// A collection of tags associated with a resource
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateHarvestJob`.
    ///
    /// Creates a new HarvestJob record.
    #[derive(std::fmt::Debug)]
    pub struct CreateHarvestJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_harvest_job_input::Builder,
    }
    impl<C, M, R> CreateHarvestJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateHarvestJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateHarvestJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateHarvestJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateHarvestJobInputOperationOutputAlias,
                crate::output::CreateHarvestJobOutput,
                crate::error::CreateHarvestJobError,
                crate::input::CreateHarvestJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The end of the time-window which will be harvested
        pub fn end_time(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.end_time(inp);
            self
        }
        /// The end of the time-window which will be harvested
        pub fn set_end_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// The ID of the HarvestJob. The ID must be unique within the region
        /// and it cannot be changed after the HarvestJob is submitted
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// The ID of the HarvestJob. The ID must be unique within the region
        /// and it cannot be changed after the HarvestJob is submitted
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// The ID of the OriginEndpoint that the HarvestJob will harvest from.
        /// This cannot be changed after the HarvestJob is submitted.
        pub fn origin_endpoint_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.origin_endpoint_id(inp);
            self
        }
        /// The ID of the OriginEndpoint that the HarvestJob will harvest from.
        /// This cannot be changed after the HarvestJob is submitted.
        pub fn set_origin_endpoint_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_origin_endpoint_id(input);
            self
        }
        /// Configuration parameters for where in an S3 bucket to place the harvested content
        pub fn s3_destination(mut self, inp: crate::model::S3Destination) -> Self {
            self.inner = self.inner.s3_destination(inp);
            self
        }
        /// Configuration parameters for where in an S3 bucket to place the harvested content
        pub fn set_s3_destination(
            mut self,
            input: std::option::Option<crate::model::S3Destination>,
        ) -> Self {
            self.inner = self.inner.set_s3_destination(input);
            self
        }
        /// The start of the time-window which will be harvested
        pub fn start_time(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.start_time(inp);
            self
        }
        /// The start of the time-window which will be harvested
        pub fn set_start_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateOriginEndpoint`.
    ///
    /// Creates a new OriginEndpoint record.
    #[derive(std::fmt::Debug)]
    pub struct CreateOriginEndpoint<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_origin_endpoint_input::Builder,
    }
    impl<C, M, R> CreateOriginEndpoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateOriginEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateOriginEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateOriginEndpointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateOriginEndpointInputOperationOutputAlias,
                crate::output::CreateOriginEndpointOutput,
                crate::error::CreateOriginEndpointError,
                crate::input::CreateOriginEndpointInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// CDN Authorization credentials
        pub fn authorization(mut self, inp: crate::model::Authorization) -> Self {
            self.inner = self.inner.authorization(inp);
            self
        }
        /// CDN Authorization credentials
        pub fn set_authorization(
            mut self,
            input: std::option::Option<crate::model::Authorization>,
        ) -> Self {
            self.inner = self.inner.set_authorization(input);
            self
        }
        /// The ID of the Channel that the OriginEndpoint will be associated with.
        /// This cannot be changed after the OriginEndpoint is created.
        pub fn channel_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_id(inp);
            self
        }
        /// The ID of the Channel that the OriginEndpoint will be associated with.
        /// This cannot be changed after the OriginEndpoint is created.
        pub fn set_channel_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_id(input);
            self
        }
        /// A Common Media Application Format (CMAF) packaging configuration.
        pub fn cmaf_package(
            mut self,
            inp: crate::model::CmafPackageCreateOrUpdateParameters,
        ) -> Self {
            self.inner = self.inner.cmaf_package(inp);
            self
        }
        /// A Common Media Application Format (CMAF) packaging configuration.
        pub fn set_cmaf_package(
            mut self,
            input: std::option::Option<crate::model::CmafPackageCreateOrUpdateParameters>,
        ) -> Self {
            self.inner = self.inner.set_cmaf_package(input);
            self
        }
        /// A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
        pub fn dash_package(mut self, inp: crate::model::DashPackage) -> Self {
            self.inner = self.inner.dash_package(inp);
            self
        }
        /// A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
        pub fn set_dash_package(
            mut self,
            input: std::option::Option<crate::model::DashPackage>,
        ) -> Self {
            self.inner = self.inner.set_dash_package(input);
            self
        }
        /// A short text description of the OriginEndpoint.
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// A short text description of the OriginEndpoint.
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// An HTTP Live Streaming (HLS) packaging configuration.
        pub fn hls_package(mut self, inp: crate::model::HlsPackage) -> Self {
            self.inner = self.inner.hls_package(inp);
            self
        }
        /// An HTTP Live Streaming (HLS) packaging configuration.
        pub fn set_hls_package(
            mut self,
            input: std::option::Option<crate::model::HlsPackage>,
        ) -> Self {
            self.inner = self.inner.set_hls_package(input);
            self
        }
        /// The ID of the OriginEndpoint.  The ID must be unique within the region
        /// and it cannot be changed after the OriginEndpoint is created.
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// The ID of the OriginEndpoint.  The ID must be unique within the region
        /// and it cannot be changed after the OriginEndpoint is created.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// A short string that will be used as the filename of the OriginEndpoint URL (defaults to "index").
        pub fn manifest_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.manifest_name(inp);
            self
        }
        /// A short string that will be used as the filename of the OriginEndpoint URL (defaults to "index").
        pub fn set_manifest_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_manifest_name(input);
            self
        }
        /// A Microsoft Smooth Streaming (MSS) packaging configuration.
        pub fn mss_package(mut self, inp: crate::model::MssPackage) -> Self {
            self.inner = self.inner.mss_package(inp);
            self
        }
        /// A Microsoft Smooth Streaming (MSS) packaging configuration.
        pub fn set_mss_package(
            mut self,
            input: std::option::Option<crate::model::MssPackage>,
        ) -> Self {
            self.inner = self.inner.set_mss_package(input);
            self
        }
        /// Control whether origination of video is allowed for this OriginEndpoint. If set to ALLOW, the OriginEndpoint
        /// may by requested, pursuant to any other form of access control. If set to DENY, the OriginEndpoint may not be
        /// requested. This can be helpful for Live to VOD harvesting, or for temporarily disabling origination
        pub fn origination(mut self, inp: crate::model::Origination) -> Self {
            self.inner = self.inner.origination(inp);
            self
        }
        /// Control whether origination of video is allowed for this OriginEndpoint. If set to ALLOW, the OriginEndpoint
        /// may by requested, pursuant to any other form of access control. If set to DENY, the OriginEndpoint may not be
        /// requested. This can be helpful for Live to VOD harvesting, or for temporarily disabling origination
        pub fn set_origination(
            mut self,
            input: std::option::Option<crate::model::Origination>,
        ) -> Self {
            self.inner = self.inner.set_origination(input);
            self
        }
        /// Maximum duration (seconds) of content to retain for startover playback.
        /// If not specified, startover playback will be disabled for the OriginEndpoint.
        pub fn startover_window_seconds(mut self, inp: i32) -> Self {
            self.inner = self.inner.startover_window_seconds(inp);
            self
        }
        /// Maximum duration (seconds) of content to retain for startover playback.
        /// If not specified, startover playback will be disabled for the OriginEndpoint.
        pub fn set_startover_window_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_startover_window_seconds(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of tags associated with a resource
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// A collection of tags associated with a resource
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// Amount of delay (seconds) to enforce on the playback of live content.
        /// If not specified, there will be no time delay in effect for the OriginEndpoint.
        pub fn time_delay_seconds(mut self, inp: i32) -> Self {
            self.inner = self.inner.time_delay_seconds(inp);
            self
        }
        /// Amount of delay (seconds) to enforce on the playback of live content.
        /// If not specified, there will be no time delay in effect for the OriginEndpoint.
        pub fn set_time_delay_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_time_delay_seconds(input);
            self
        }
        /// Appends an item to `Whitelist`.
        ///
        /// To override the contents of this collection use [`set_whitelist`](Self::set_whitelist).
        ///
        /// A list of source IP CIDR blocks that will be allowed to access the OriginEndpoint.
        pub fn whitelist(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.whitelist(inp);
            self
        }
        /// A list of source IP CIDR blocks that will be allowed to access the OriginEndpoint.
        pub fn set_whitelist(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_whitelist(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteChannel`.
    ///
    /// Deletes an existing Channel.
    #[derive(std::fmt::Debug)]
    pub struct DeleteChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_channel_input::Builder,
    }
    impl<C, M, R> DeleteChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteChannelInputOperationOutputAlias,
                crate::output::DeleteChannelOutput,
                crate::error::DeleteChannelError,
                crate::input::DeleteChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the Channel to delete.
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// The ID of the Channel to delete.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteOriginEndpoint`.
    ///
    /// Deletes an existing OriginEndpoint.
    #[derive(std::fmt::Debug)]
    pub struct DeleteOriginEndpoint<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_origin_endpoint_input::Builder,
    }
    impl<C, M, R> DeleteOriginEndpoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteOriginEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteOriginEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteOriginEndpointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteOriginEndpointInputOperationOutputAlias,
                crate::output::DeleteOriginEndpointOutput,
                crate::error::DeleteOriginEndpointError,
                crate::input::DeleteOriginEndpointInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the OriginEndpoint to delete.
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// The ID of the OriginEndpoint to delete.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeChannel`.
    ///
    /// Gets details about a Channel.
    #[derive(std::fmt::Debug)]
    pub struct DescribeChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_channel_input::Builder,
    }
    impl<C, M, R> DescribeChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeChannelInputOperationOutputAlias,
                crate::output::DescribeChannelOutput,
                crate::error::DescribeChannelError,
                crate::input::DescribeChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of a Channel.
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// The ID of a Channel.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeHarvestJob`.
    ///
    /// Gets details about an existing HarvestJob.
    #[derive(std::fmt::Debug)]
    pub struct DescribeHarvestJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_harvest_job_input::Builder,
    }
    impl<C, M, R> DescribeHarvestJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeHarvestJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeHarvestJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeHarvestJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeHarvestJobInputOperationOutputAlias,
                crate::output::DescribeHarvestJobOutput,
                crate::error::DescribeHarvestJobError,
                crate::input::DescribeHarvestJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the HarvestJob.
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// The ID of the HarvestJob.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeOriginEndpoint`.
    ///
    /// Gets details about an existing OriginEndpoint.
    #[derive(std::fmt::Debug)]
    pub struct DescribeOriginEndpoint<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_origin_endpoint_input::Builder,
    }
    impl<C, M, R> DescribeOriginEndpoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeOriginEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeOriginEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeOriginEndpointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeOriginEndpointInputOperationOutputAlias,
                crate::output::DescribeOriginEndpointOutput,
                crate::error::DescribeOriginEndpointError,
                crate::input::DescribeOriginEndpointInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the OriginEndpoint.
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// The ID of the OriginEndpoint.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListChannels`.
    ///
    /// Returns a collection of Channels.
    #[derive(std::fmt::Debug)]
    pub struct ListChannels<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_channels_input::Builder,
    }
    impl<C, M, R> ListChannels<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListChannels`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListChannelsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListChannelsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListChannelsInputOperationOutputAlias,
                crate::output::ListChannelsOutput,
                crate::error::ListChannelsError,
                crate::input::ListChannelsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Upper bound on number of records to return.
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// Upper bound on number of records to return.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListHarvestJobs`.
    ///
    /// Returns a collection of HarvestJob records.
    #[derive(std::fmt::Debug)]
    pub struct ListHarvestJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_harvest_jobs_input::Builder,
    }
    impl<C, M, R> ListHarvestJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListHarvestJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListHarvestJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListHarvestJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListHarvestJobsInputOperationOutputAlias,
                crate::output::ListHarvestJobsOutput,
                crate::error::ListHarvestJobsError,
                crate::input::ListHarvestJobsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// When specified, the request will return only HarvestJobs associated with the given Channel ID.
        pub fn include_channel_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.include_channel_id(inp);
            self
        }
        /// When specified, the request will return only HarvestJobs associated with the given Channel ID.
        pub fn set_include_channel_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_include_channel_id(input);
            self
        }
        /// When specified, the request will return only HarvestJobs in the given status.
        pub fn include_status(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.include_status(inp);
            self
        }
        /// When specified, the request will return only HarvestJobs in the given status.
        pub fn set_include_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_include_status(input);
            self
        }
        /// The upper bound on the number of records to return.
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// The upper bound on the number of records to return.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListOriginEndpoints`.
    ///
    /// Returns a collection of OriginEndpoint records.
    #[derive(std::fmt::Debug)]
    pub struct ListOriginEndpoints<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_origin_endpoints_input::Builder,
    }
    impl<C, M, R> ListOriginEndpoints<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListOriginEndpoints`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListOriginEndpointsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListOriginEndpointsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListOriginEndpointsInputOperationOutputAlias,
                crate::output::ListOriginEndpointsOutput,
                crate::error::ListOriginEndpointsError,
                crate::input::ListOriginEndpointsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// When specified, the request will return only OriginEndpoints associated with the given Channel ID.
        pub fn channel_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_id(inp);
            self
        }
        /// When specified, the request will return only OriginEndpoints associated with the given Channel ID.
        pub fn set_channel_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_id(input);
            self
        }
        /// The upper bound on the number of records to return.
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// The upper bound on the number of records to return.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RotateChannelCredentials`.
    ///
    /// Changes the Channel's first IngestEndpoint's username and password. WARNING - This API is deprecated. Please use RotateIngestEndpointCredentials instead
    #[derive(std::fmt::Debug)]
    pub struct RotateChannelCredentials<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::rotate_channel_credentials_input::Builder,
    }
    impl<C, M, R> RotateChannelCredentials<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RotateChannelCredentials`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RotateChannelCredentialsOutput,
            aws_smithy_http::result::SdkError<crate::error::RotateChannelCredentialsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RotateChannelCredentialsInputOperationOutputAlias,
                crate::output::RotateChannelCredentialsOutput,
                crate::error::RotateChannelCredentialsError,
                crate::input::RotateChannelCredentialsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the channel to update.
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// The ID of the channel to update.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RotateIngestEndpointCredentials`.
    ///
    /// Rotate the IngestEndpoint's username and password, as specified by the IngestEndpoint's id.
    #[derive(std::fmt::Debug)]
    pub struct RotateIngestEndpointCredentials<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::rotate_ingest_endpoint_credentials_input::Builder,
    }
    impl<C, M, R> RotateIngestEndpointCredentials<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RotateIngestEndpointCredentials`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RotateIngestEndpointCredentialsOutput,
            aws_smithy_http::result::SdkError<crate::error::RotateIngestEndpointCredentialsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RotateIngestEndpointCredentialsInputOperationOutputAlias,
                crate::output::RotateIngestEndpointCredentialsOutput,
                crate::error::RotateIngestEndpointCredentialsError,
                crate::input::RotateIngestEndpointCredentialsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the channel the IngestEndpoint is on.
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// The ID of the channel the IngestEndpoint is on.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// The id of the IngestEndpoint whose credentials should be rotated
        pub fn ingest_endpoint_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ingest_endpoint_id(inp);
            self
        }
        /// The id of the IngestEndpoint whose credentials should be rotated
        pub fn set_ingest_endpoint_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ingest_endpoint_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        #[allow(missing_docs)] // documentation missing in model
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// The key(s) of tag to be deleted
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// The key(s) of tag to be deleted
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateChannel`.
    ///
    /// Updates an existing Channel.
    #[derive(std::fmt::Debug)]
    pub struct UpdateChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_channel_input::Builder,
    }
    impl<C, M, R> UpdateChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateChannelInputOperationOutputAlias,
                crate::output::UpdateChannelOutput,
                crate::error::UpdateChannelError,
                crate::input::UpdateChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// A short text description of the Channel.
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// A short text description of the Channel.
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// The ID of the Channel to update.
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// The ID of the Channel to update.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateOriginEndpoint`.
    ///
    /// Updates an existing OriginEndpoint.
    #[derive(std::fmt::Debug)]
    pub struct UpdateOriginEndpoint<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_origin_endpoint_input::Builder,
    }
    impl<C, M, R> UpdateOriginEndpoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateOriginEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateOriginEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateOriginEndpointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateOriginEndpointInputOperationOutputAlias,
                crate::output::UpdateOriginEndpointOutput,
                crate::error::UpdateOriginEndpointError,
                crate::input::UpdateOriginEndpointInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// CDN Authorization credentials
        pub fn authorization(mut self, inp: crate::model::Authorization) -> Self {
            self.inner = self.inner.authorization(inp);
            self
        }
        /// CDN Authorization credentials
        pub fn set_authorization(
            mut self,
            input: std::option::Option<crate::model::Authorization>,
        ) -> Self {
            self.inner = self.inner.set_authorization(input);
            self
        }
        /// A Common Media Application Format (CMAF) packaging configuration.
        pub fn cmaf_package(
            mut self,
            inp: crate::model::CmafPackageCreateOrUpdateParameters,
        ) -> Self {
            self.inner = self.inner.cmaf_package(inp);
            self
        }
        /// A Common Media Application Format (CMAF) packaging configuration.
        pub fn set_cmaf_package(
            mut self,
            input: std::option::Option<crate::model::CmafPackageCreateOrUpdateParameters>,
        ) -> Self {
            self.inner = self.inner.set_cmaf_package(input);
            self
        }
        /// A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
        pub fn dash_package(mut self, inp: crate::model::DashPackage) -> Self {
            self.inner = self.inner.dash_package(inp);
            self
        }
        /// A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
        pub fn set_dash_package(
            mut self,
            input: std::option::Option<crate::model::DashPackage>,
        ) -> Self {
            self.inner = self.inner.set_dash_package(input);
            self
        }
        /// A short text description of the OriginEndpoint.
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// A short text description of the OriginEndpoint.
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// An HTTP Live Streaming (HLS) packaging configuration.
        pub fn hls_package(mut self, inp: crate::model::HlsPackage) -> Self {
            self.inner = self.inner.hls_package(inp);
            self
        }
        /// An HTTP Live Streaming (HLS) packaging configuration.
        pub fn set_hls_package(
            mut self,
            input: std::option::Option<crate::model::HlsPackage>,
        ) -> Self {
            self.inner = self.inner.set_hls_package(input);
            self
        }
        /// The ID of the OriginEndpoint to update.
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// The ID of the OriginEndpoint to update.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// A short string that will be appended to the end of the Endpoint URL.
        pub fn manifest_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.manifest_name(inp);
            self
        }
        /// A short string that will be appended to the end of the Endpoint URL.
        pub fn set_manifest_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_manifest_name(input);
            self
        }
        /// A Microsoft Smooth Streaming (MSS) packaging configuration.
        pub fn mss_package(mut self, inp: crate::model::MssPackage) -> Self {
            self.inner = self.inner.mss_package(inp);
            self
        }
        /// A Microsoft Smooth Streaming (MSS) packaging configuration.
        pub fn set_mss_package(
            mut self,
            input: std::option::Option<crate::model::MssPackage>,
        ) -> Self {
            self.inner = self.inner.set_mss_package(input);
            self
        }
        /// Control whether origination of video is allowed for this OriginEndpoint. If set to ALLOW, the OriginEndpoint
        /// may by requested, pursuant to any other form of access control. If set to DENY, the OriginEndpoint may not be
        /// requested. This can be helpful for Live to VOD harvesting, or for temporarily disabling origination
        pub fn origination(mut self, inp: crate::model::Origination) -> Self {
            self.inner = self.inner.origination(inp);
            self
        }
        /// Control whether origination of video is allowed for this OriginEndpoint. If set to ALLOW, the OriginEndpoint
        /// may by requested, pursuant to any other form of access control. If set to DENY, the OriginEndpoint may not be
        /// requested. This can be helpful for Live to VOD harvesting, or for temporarily disabling origination
        pub fn set_origination(
            mut self,
            input: std::option::Option<crate::model::Origination>,
        ) -> Self {
            self.inner = self.inner.set_origination(input);
            self
        }
        /// Maximum duration (in seconds) of content to retain for startover playback.
        /// If not specified, startover playback will be disabled for the OriginEndpoint.
        pub fn startover_window_seconds(mut self, inp: i32) -> Self {
            self.inner = self.inner.startover_window_seconds(inp);
            self
        }
        /// Maximum duration (in seconds) of content to retain for startover playback.
        /// If not specified, startover playback will be disabled for the OriginEndpoint.
        pub fn set_startover_window_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_startover_window_seconds(input);
            self
        }
        /// Amount of delay (in seconds) to enforce on the playback of live content.
        /// If not specified, there will be no time delay in effect for the OriginEndpoint.
        pub fn time_delay_seconds(mut self, inp: i32) -> Self {
            self.inner = self.inner.time_delay_seconds(inp);
            self
        }
        /// Amount of delay (in seconds) to enforce on the playback of live content.
        /// If not specified, there will be no time delay in effect for the OriginEndpoint.
        pub fn set_time_delay_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_time_delay_seconds(input);
            self
        }
        /// Appends an item to `Whitelist`.
        ///
        /// To override the contents of this collection use [`set_whitelist`](Self::set_whitelist).
        ///
        /// A list of source IP CIDR blocks that will be allowed to access the OriginEndpoint.
        pub fn whitelist(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.whitelist(inp);
            self
        }
        /// A list of source IP CIDR blocks that will be allowed to access the OriginEndpoint.
        pub fn set_whitelist(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_whitelist(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
