// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateOriginEndpointOutput {
    /// The Amazon Resource Name (ARN) assigned to the OriginEndpoint.
    pub arn: std::option::Option<std::string::String>,
    /// CDN Authorization credentials
    pub authorization: std::option::Option<crate::model::Authorization>,
    /// The ID of the Channel the OriginEndpoint is associated with.
    pub channel_id: std::option::Option<std::string::String>,
    /// A Common Media Application Format (CMAF) packaging configuration.
    pub cmaf_package: std::option::Option<crate::model::CmafPackage>,
    /// A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
    pub dash_package: std::option::Option<crate::model::DashPackage>,
    /// A short text description of the OriginEndpoint.
    pub description: std::option::Option<std::string::String>,
    /// An HTTP Live Streaming (HLS) packaging configuration.
    pub hls_package: std::option::Option<crate::model::HlsPackage>,
    /// The ID of the OriginEndpoint.
    pub id: std::option::Option<std::string::String>,
    /// A short string appended to the end of the OriginEndpoint URL.
    pub manifest_name: std::option::Option<std::string::String>,
    /// A Microsoft Smooth Streaming (MSS) packaging configuration.
    pub mss_package: std::option::Option<crate::model::MssPackage>,
    /// Control whether origination of video is allowed for this OriginEndpoint. If set to ALLOW, the OriginEndpoint
    /// may by requested, pursuant to any other form of access control. If set to DENY, the OriginEndpoint may not be
    /// requested. This can be helpful for Live to VOD harvesting, or for temporarily disabling origination
    pub origination: std::option::Option<crate::model::Origination>,
    /// Maximum duration (seconds) of content to retain for startover playback.
    /// If not specified, startover playback will be disabled for the OriginEndpoint.
    pub startover_window_seconds: i32,
    /// A collection of tags associated with a resource
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// Amount of delay (seconds) to enforce on the playback of live content.
    /// If not specified, there will be no time delay in effect for the OriginEndpoint.
    pub time_delay_seconds: i32,
    /// The URL of the packaged OriginEndpoint for consumption.
    pub url: std::option::Option<std::string::String>,
    /// A list of source IP CIDR blocks that will be allowed to access the OriginEndpoint.
    pub whitelist: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for UpdateOriginEndpointOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateOriginEndpointOutput");
        formatter.field("arn", &self.arn);
        formatter.field("authorization", &self.authorization);
        formatter.field("channel_id", &self.channel_id);
        formatter.field("cmaf_package", &self.cmaf_package);
        formatter.field("dash_package", &self.dash_package);
        formatter.field("description", &self.description);
        formatter.field("hls_package", &self.hls_package);
        formatter.field("id", &self.id);
        formatter.field("manifest_name", &self.manifest_name);
        formatter.field("mss_package", &self.mss_package);
        formatter.field("origination", &self.origination);
        formatter.field("startover_window_seconds", &self.startover_window_seconds);
        formatter.field("tags", &self.tags);
        formatter.field("time_delay_seconds", &self.time_delay_seconds);
        formatter.field("url", &self.url);
        formatter.field("whitelist", &self.whitelist);
        formatter.finish()
    }
}
/// See [`UpdateOriginEndpointOutput`](crate::output::UpdateOriginEndpointOutput)
pub mod update_origin_endpoint_output {
    /// A builder for [`UpdateOriginEndpointOutput`](crate::output::UpdateOriginEndpointOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) authorization: std::option::Option<crate::model::Authorization>,
        pub(crate) channel_id: std::option::Option<std::string::String>,
        pub(crate) cmaf_package: std::option::Option<crate::model::CmafPackage>,
        pub(crate) dash_package: std::option::Option<crate::model::DashPackage>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) hls_package: std::option::Option<crate::model::HlsPackage>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) manifest_name: std::option::Option<std::string::String>,
        pub(crate) mss_package: std::option::Option<crate::model::MssPackage>,
        pub(crate) origination: std::option::Option<crate::model::Origination>,
        pub(crate) startover_window_seconds: std::option::Option<i32>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) time_delay_seconds: std::option::Option<i32>,
        pub(crate) url: std::option::Option<std::string::String>,
        pub(crate) whitelist: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// The Amazon Resource Name (ARN) assigned to the OriginEndpoint.
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) assigned to the OriginEndpoint.
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// CDN Authorization credentials
        pub fn authorization(mut self, input: crate::model::Authorization) -> Self {
            self.authorization = Some(input);
            self
        }
        /// CDN Authorization credentials
        pub fn set_authorization(
            mut self,
            input: std::option::Option<crate::model::Authorization>,
        ) -> Self {
            self.authorization = input;
            self
        }
        /// The ID of the Channel the OriginEndpoint is associated with.
        pub fn channel_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_id = Some(input.into());
            self
        }
        /// The ID of the Channel the OriginEndpoint is associated with.
        pub fn set_channel_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_id = input;
            self
        }
        /// A Common Media Application Format (CMAF) packaging configuration.
        pub fn cmaf_package(mut self, input: crate::model::CmafPackage) -> Self {
            self.cmaf_package = Some(input);
            self
        }
        /// A Common Media Application Format (CMAF) packaging configuration.
        pub fn set_cmaf_package(
            mut self,
            input: std::option::Option<crate::model::CmafPackage>,
        ) -> Self {
            self.cmaf_package = input;
            self
        }
        /// A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
        pub fn dash_package(mut self, input: crate::model::DashPackage) -> Self {
            self.dash_package = Some(input);
            self
        }
        /// A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
        pub fn set_dash_package(
            mut self,
            input: std::option::Option<crate::model::DashPackage>,
        ) -> Self {
            self.dash_package = input;
            self
        }
        /// A short text description of the OriginEndpoint.
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// A short text description of the OriginEndpoint.
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// An HTTP Live Streaming (HLS) packaging configuration.
        pub fn hls_package(mut self, input: crate::model::HlsPackage) -> Self {
            self.hls_package = Some(input);
            self
        }
        /// An HTTP Live Streaming (HLS) packaging configuration.
        pub fn set_hls_package(
            mut self,
            input: std::option::Option<crate::model::HlsPackage>,
        ) -> Self {
            self.hls_package = input;
            self
        }
        /// The ID of the OriginEndpoint.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// The ID of the OriginEndpoint.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// A short string appended to the end of the OriginEndpoint URL.
        pub fn manifest_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.manifest_name = Some(input.into());
            self
        }
        /// A short string appended to the end of the OriginEndpoint URL.
        pub fn set_manifest_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.manifest_name = input;
            self
        }
        /// A Microsoft Smooth Streaming (MSS) packaging configuration.
        pub fn mss_package(mut self, input: crate::model::MssPackage) -> Self {
            self.mss_package = Some(input);
            self
        }
        /// A Microsoft Smooth Streaming (MSS) packaging configuration.
        pub fn set_mss_package(
            mut self,
            input: std::option::Option<crate::model::MssPackage>,
        ) -> Self {
            self.mss_package = input;
            self
        }
        /// Control whether origination of video is allowed for this OriginEndpoint. If set to ALLOW, the OriginEndpoint
        /// may by requested, pursuant to any other form of access control. If set to DENY, the OriginEndpoint may not be
        /// requested. This can be helpful for Live to VOD harvesting, or for temporarily disabling origination
        pub fn origination(mut self, input: crate::model::Origination) -> Self {
            self.origination = Some(input);
            self
        }
        /// Control whether origination of video is allowed for this OriginEndpoint. If set to ALLOW, the OriginEndpoint
        /// may by requested, pursuant to any other form of access control. If set to DENY, the OriginEndpoint may not be
        /// requested. This can be helpful for Live to VOD harvesting, or for temporarily disabling origination
        pub fn set_origination(
            mut self,
            input: std::option::Option<crate::model::Origination>,
        ) -> Self {
            self.origination = input;
            self
        }
        /// Maximum duration (seconds) of content to retain for startover playback.
        /// If not specified, startover playback will be disabled for the OriginEndpoint.
        pub fn startover_window_seconds(mut self, input: i32) -> Self {
            self.startover_window_seconds = Some(input);
            self
        }
        /// Maximum duration (seconds) of content to retain for startover playback.
        /// If not specified, startover playback will be disabled for the OriginEndpoint.
        pub fn set_startover_window_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.startover_window_seconds = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of tags associated with a resource
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// A collection of tags associated with a resource
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Amount of delay (seconds) to enforce on the playback of live content.
        /// If not specified, there will be no time delay in effect for the OriginEndpoint.
        pub fn time_delay_seconds(mut self, input: i32) -> Self {
            self.time_delay_seconds = Some(input);
            self
        }
        /// Amount of delay (seconds) to enforce on the playback of live content.
        /// If not specified, there will be no time delay in effect for the OriginEndpoint.
        pub fn set_time_delay_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.time_delay_seconds = input;
            self
        }
        /// The URL of the packaged OriginEndpoint for consumption.
        pub fn url(mut self, input: impl Into<std::string::String>) -> Self {
            self.url = Some(input.into());
            self
        }
        /// The URL of the packaged OriginEndpoint for consumption.
        pub fn set_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.url = input;
            self
        }
        /// Appends an item to `whitelist`.
        ///
        /// To override the contents of this collection use [`set_whitelist`](Self::set_whitelist).
        ///
        /// A list of source IP CIDR blocks that will be allowed to access the OriginEndpoint.
        pub fn whitelist(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.whitelist.unwrap_or_default();
            v.push(input.into());
            self.whitelist = Some(v);
            self
        }
        /// A list of source IP CIDR blocks that will be allowed to access the OriginEndpoint.
        pub fn set_whitelist(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.whitelist = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateOriginEndpointOutput`](crate::output::UpdateOriginEndpointOutput)
        pub fn build(self) -> crate::output::UpdateOriginEndpointOutput {
            crate::output::UpdateOriginEndpointOutput {
                arn: self.arn,
                authorization: self.authorization,
                channel_id: self.channel_id,
                cmaf_package: self.cmaf_package,
                dash_package: self.dash_package,
                description: self.description,
                hls_package: self.hls_package,
                id: self.id,
                manifest_name: self.manifest_name,
                mss_package: self.mss_package,
                origination: self.origination,
                startover_window_seconds: self.startover_window_seconds.unwrap_or_default(),
                tags: self.tags,
                time_delay_seconds: self.time_delay_seconds.unwrap_or_default(),
                url: self.url,
                whitelist: self.whitelist,
            }
        }
    }
}
impl UpdateOriginEndpointOutput {
    /// Creates a new builder-style object to manufacture [`UpdateOriginEndpointOutput`](crate::output::UpdateOriginEndpointOutput)
    pub fn builder() -> crate::output::update_origin_endpoint_output::Builder {
        crate::output::update_origin_endpoint_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateChannelOutput {
    /// The Amazon Resource Name (ARN) assigned to the Channel.
    pub arn: std::option::Option<std::string::String>,
    /// A short text description of the Channel.
    pub description: std::option::Option<std::string::String>,
    /// Configure egress access logging.
    pub egress_access_logs: std::option::Option<crate::model::EgressAccessLogs>,
    /// An HTTP Live Streaming (HLS) ingest resource configuration.
    pub hls_ingest: std::option::Option<crate::model::HlsIngest>,
    /// The ID of the Channel.
    pub id: std::option::Option<std::string::String>,
    /// Configure ingress access logging.
    pub ingress_access_logs: std::option::Option<crate::model::IngressAccessLogs>,
    /// A collection of tags associated with a resource
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for UpdateChannelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateChannelOutput");
        formatter.field("arn", &self.arn);
        formatter.field("description", &self.description);
        formatter.field("egress_access_logs", &self.egress_access_logs);
        formatter.field("hls_ingest", &self.hls_ingest);
        formatter.field("id", &self.id);
        formatter.field("ingress_access_logs", &self.ingress_access_logs);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`UpdateChannelOutput`](crate::output::UpdateChannelOutput)
pub mod update_channel_output {
    /// A builder for [`UpdateChannelOutput`](crate::output::UpdateChannelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) egress_access_logs: std::option::Option<crate::model::EgressAccessLogs>,
        pub(crate) hls_ingest: std::option::Option<crate::model::HlsIngest>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) ingress_access_logs: std::option::Option<crate::model::IngressAccessLogs>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// The Amazon Resource Name (ARN) assigned to the Channel.
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) assigned to the Channel.
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// A short text description of the Channel.
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// A short text description of the Channel.
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Configure egress access logging.
        pub fn egress_access_logs(mut self, input: crate::model::EgressAccessLogs) -> Self {
            self.egress_access_logs = Some(input);
            self
        }
        /// Configure egress access logging.
        pub fn set_egress_access_logs(
            mut self,
            input: std::option::Option<crate::model::EgressAccessLogs>,
        ) -> Self {
            self.egress_access_logs = input;
            self
        }
        /// An HTTP Live Streaming (HLS) ingest resource configuration.
        pub fn hls_ingest(mut self, input: crate::model::HlsIngest) -> Self {
            self.hls_ingest = Some(input);
            self
        }
        /// An HTTP Live Streaming (HLS) ingest resource configuration.
        pub fn set_hls_ingest(
            mut self,
            input: std::option::Option<crate::model::HlsIngest>,
        ) -> Self {
            self.hls_ingest = input;
            self
        }
        /// The ID of the Channel.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// The ID of the Channel.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Configure ingress access logging.
        pub fn ingress_access_logs(mut self, input: crate::model::IngressAccessLogs) -> Self {
            self.ingress_access_logs = Some(input);
            self
        }
        /// Configure ingress access logging.
        pub fn set_ingress_access_logs(
            mut self,
            input: std::option::Option<crate::model::IngressAccessLogs>,
        ) -> Self {
            self.ingress_access_logs = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of tags associated with a resource
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// A collection of tags associated with a resource
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateChannelOutput`](crate::output::UpdateChannelOutput)
        pub fn build(self) -> crate::output::UpdateChannelOutput {
            crate::output::UpdateChannelOutput {
                arn: self.arn,
                description: self.description,
                egress_access_logs: self.egress_access_logs,
                hls_ingest: self.hls_ingest,
                id: self.id,
                ingress_access_logs: self.ingress_access_logs,
                tags: self.tags,
            }
        }
    }
}
impl UpdateChannelOutput {
    /// Creates a new builder-style object to manufacture [`UpdateChannelOutput`](crate::output::UpdateChannelOutput)
    pub fn builder() -> crate::output::update_channel_output::Builder {
        crate::output::update_channel_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RotateIngestEndpointCredentialsOutput {
    /// The Amazon Resource Name (ARN) assigned to the Channel.
    pub arn: std::option::Option<std::string::String>,
    /// A short text description of the Channel.
    pub description: std::option::Option<std::string::String>,
    /// Configure egress access logging.
    pub egress_access_logs: std::option::Option<crate::model::EgressAccessLogs>,
    /// An HTTP Live Streaming (HLS) ingest resource configuration.
    pub hls_ingest: std::option::Option<crate::model::HlsIngest>,
    /// The ID of the Channel.
    pub id: std::option::Option<std::string::String>,
    /// Configure ingress access logging.
    pub ingress_access_logs: std::option::Option<crate::model::IngressAccessLogs>,
    /// A collection of tags associated with a resource
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for RotateIngestEndpointCredentialsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RotateIngestEndpointCredentialsOutput");
        formatter.field("arn", &self.arn);
        formatter.field("description", &self.description);
        formatter.field("egress_access_logs", &self.egress_access_logs);
        formatter.field("hls_ingest", &self.hls_ingest);
        formatter.field("id", &self.id);
        formatter.field("ingress_access_logs", &self.ingress_access_logs);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`RotateIngestEndpointCredentialsOutput`](crate::output::RotateIngestEndpointCredentialsOutput)
pub mod rotate_ingest_endpoint_credentials_output {
    /// A builder for [`RotateIngestEndpointCredentialsOutput`](crate::output::RotateIngestEndpointCredentialsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) egress_access_logs: std::option::Option<crate::model::EgressAccessLogs>,
        pub(crate) hls_ingest: std::option::Option<crate::model::HlsIngest>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) ingress_access_logs: std::option::Option<crate::model::IngressAccessLogs>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// The Amazon Resource Name (ARN) assigned to the Channel.
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) assigned to the Channel.
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// A short text description of the Channel.
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// A short text description of the Channel.
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Configure egress access logging.
        pub fn egress_access_logs(mut self, input: crate::model::EgressAccessLogs) -> Self {
            self.egress_access_logs = Some(input);
            self
        }
        /// Configure egress access logging.
        pub fn set_egress_access_logs(
            mut self,
            input: std::option::Option<crate::model::EgressAccessLogs>,
        ) -> Self {
            self.egress_access_logs = input;
            self
        }
        /// An HTTP Live Streaming (HLS) ingest resource configuration.
        pub fn hls_ingest(mut self, input: crate::model::HlsIngest) -> Self {
            self.hls_ingest = Some(input);
            self
        }
        /// An HTTP Live Streaming (HLS) ingest resource configuration.
        pub fn set_hls_ingest(
            mut self,
            input: std::option::Option<crate::model::HlsIngest>,
        ) -> Self {
            self.hls_ingest = input;
            self
        }
        /// The ID of the Channel.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// The ID of the Channel.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Configure ingress access logging.
        pub fn ingress_access_logs(mut self, input: crate::model::IngressAccessLogs) -> Self {
            self.ingress_access_logs = Some(input);
            self
        }
        /// Configure ingress access logging.
        pub fn set_ingress_access_logs(
            mut self,
            input: std::option::Option<crate::model::IngressAccessLogs>,
        ) -> Self {
            self.ingress_access_logs = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of tags associated with a resource
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// A collection of tags associated with a resource
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`RotateIngestEndpointCredentialsOutput`](crate::output::RotateIngestEndpointCredentialsOutput)
        pub fn build(self) -> crate::output::RotateIngestEndpointCredentialsOutput {
            crate::output::RotateIngestEndpointCredentialsOutput {
                arn: self.arn,
                description: self.description,
                egress_access_logs: self.egress_access_logs,
                hls_ingest: self.hls_ingest,
                id: self.id,
                ingress_access_logs: self.ingress_access_logs,
                tags: self.tags,
            }
        }
    }
}
impl RotateIngestEndpointCredentialsOutput {
    /// Creates a new builder-style object to manufacture [`RotateIngestEndpointCredentialsOutput`](crate::output::RotateIngestEndpointCredentialsOutput)
    pub fn builder() -> crate::output::rotate_ingest_endpoint_credentials_output::Builder {
        crate::output::rotate_ingest_endpoint_credentials_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RotateChannelCredentialsOutput {
    /// The Amazon Resource Name (ARN) assigned to the Channel.
    pub arn: std::option::Option<std::string::String>,
    /// A short text description of the Channel.
    pub description: std::option::Option<std::string::String>,
    /// Configure egress access logging.
    pub egress_access_logs: std::option::Option<crate::model::EgressAccessLogs>,
    /// An HTTP Live Streaming (HLS) ingest resource configuration.
    pub hls_ingest: std::option::Option<crate::model::HlsIngest>,
    /// The ID of the Channel.
    pub id: std::option::Option<std::string::String>,
    /// Configure ingress access logging.
    pub ingress_access_logs: std::option::Option<crate::model::IngressAccessLogs>,
    /// A collection of tags associated with a resource
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for RotateChannelCredentialsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RotateChannelCredentialsOutput");
        formatter.field("arn", &self.arn);
        formatter.field("description", &self.description);
        formatter.field("egress_access_logs", &self.egress_access_logs);
        formatter.field("hls_ingest", &self.hls_ingest);
        formatter.field("id", &self.id);
        formatter.field("ingress_access_logs", &self.ingress_access_logs);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`RotateChannelCredentialsOutput`](crate::output::RotateChannelCredentialsOutput)
pub mod rotate_channel_credentials_output {
    /// A builder for [`RotateChannelCredentialsOutput`](crate::output::RotateChannelCredentialsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) egress_access_logs: std::option::Option<crate::model::EgressAccessLogs>,
        pub(crate) hls_ingest: std::option::Option<crate::model::HlsIngest>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) ingress_access_logs: std::option::Option<crate::model::IngressAccessLogs>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// The Amazon Resource Name (ARN) assigned to the Channel.
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) assigned to the Channel.
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// A short text description of the Channel.
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// A short text description of the Channel.
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Configure egress access logging.
        pub fn egress_access_logs(mut self, input: crate::model::EgressAccessLogs) -> Self {
            self.egress_access_logs = Some(input);
            self
        }
        /// Configure egress access logging.
        pub fn set_egress_access_logs(
            mut self,
            input: std::option::Option<crate::model::EgressAccessLogs>,
        ) -> Self {
            self.egress_access_logs = input;
            self
        }
        /// An HTTP Live Streaming (HLS) ingest resource configuration.
        pub fn hls_ingest(mut self, input: crate::model::HlsIngest) -> Self {
            self.hls_ingest = Some(input);
            self
        }
        /// An HTTP Live Streaming (HLS) ingest resource configuration.
        pub fn set_hls_ingest(
            mut self,
            input: std::option::Option<crate::model::HlsIngest>,
        ) -> Self {
            self.hls_ingest = input;
            self
        }
        /// The ID of the Channel.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// The ID of the Channel.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Configure ingress access logging.
        pub fn ingress_access_logs(mut self, input: crate::model::IngressAccessLogs) -> Self {
            self.ingress_access_logs = Some(input);
            self
        }
        /// Configure ingress access logging.
        pub fn set_ingress_access_logs(
            mut self,
            input: std::option::Option<crate::model::IngressAccessLogs>,
        ) -> Self {
            self.ingress_access_logs = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of tags associated with a resource
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// A collection of tags associated with a resource
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`RotateChannelCredentialsOutput`](crate::output::RotateChannelCredentialsOutput)
        pub fn build(self) -> crate::output::RotateChannelCredentialsOutput {
            crate::output::RotateChannelCredentialsOutput {
                arn: self.arn,
                description: self.description,
                egress_access_logs: self.egress_access_logs,
                hls_ingest: self.hls_ingest,
                id: self.id,
                ingress_access_logs: self.ingress_access_logs,
                tags: self.tags,
            }
        }
    }
}
impl RotateChannelCredentialsOutput {
    /// Creates a new builder-style object to manufacture [`RotateChannelCredentialsOutput`](crate::output::RotateChannelCredentialsOutput)
    pub fn builder() -> crate::output::rotate_channel_credentials_output::Builder {
        crate::output::rotate_channel_credentials_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    #[allow(missing_docs)] // documentation missing in model
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListOriginEndpointsOutput {
    /// A token that can be used to resume pagination from the end of the collection.
    pub next_token: std::option::Option<std::string::String>,
    /// A list of OriginEndpoint records.
    pub origin_endpoints: std::option::Option<std::vec::Vec<crate::model::OriginEndpoint>>,
}
impl std::fmt::Debug for ListOriginEndpointsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListOriginEndpointsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("origin_endpoints", &self.origin_endpoints);
        formatter.finish()
    }
}
/// See [`ListOriginEndpointsOutput`](crate::output::ListOriginEndpointsOutput)
pub mod list_origin_endpoints_output {
    /// A builder for [`ListOriginEndpointsOutput`](crate::output::ListOriginEndpointsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) origin_endpoints:
            std::option::Option<std::vec::Vec<crate::model::OriginEndpoint>>,
    }
    impl Builder {
        /// A token that can be used to resume pagination from the end of the collection.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// A token that can be used to resume pagination from the end of the collection.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `origin_endpoints`.
        ///
        /// To override the contents of this collection use [`set_origin_endpoints`](Self::set_origin_endpoints).
        ///
        /// A list of OriginEndpoint records.
        pub fn origin_endpoints(mut self, input: impl Into<crate::model::OriginEndpoint>) -> Self {
            let mut v = self.origin_endpoints.unwrap_or_default();
            v.push(input.into());
            self.origin_endpoints = Some(v);
            self
        }
        /// A list of OriginEndpoint records.
        pub fn set_origin_endpoints(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OriginEndpoint>>,
        ) -> Self {
            self.origin_endpoints = input;
            self
        }
        /// Consumes the builder and constructs a [`ListOriginEndpointsOutput`](crate::output::ListOriginEndpointsOutput)
        pub fn build(self) -> crate::output::ListOriginEndpointsOutput {
            crate::output::ListOriginEndpointsOutput {
                next_token: self.next_token,
                origin_endpoints: self.origin_endpoints,
            }
        }
    }
}
impl ListOriginEndpointsOutput {
    /// Creates a new builder-style object to manufacture [`ListOriginEndpointsOutput`](crate::output::ListOriginEndpointsOutput)
    pub fn builder() -> crate::output::list_origin_endpoints_output::Builder {
        crate::output::list_origin_endpoints_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListHarvestJobsOutput {
    /// A list of HarvestJob records.
    pub harvest_jobs: std::option::Option<std::vec::Vec<crate::model::HarvestJob>>,
    /// A token that can be used to resume pagination from the end of the collection.
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListHarvestJobsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListHarvestJobsOutput");
        formatter.field("harvest_jobs", &self.harvest_jobs);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListHarvestJobsOutput`](crate::output::ListHarvestJobsOutput)
pub mod list_harvest_jobs_output {
    /// A builder for [`ListHarvestJobsOutput`](crate::output::ListHarvestJobsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) harvest_jobs: std::option::Option<std::vec::Vec<crate::model::HarvestJob>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `harvest_jobs`.
        ///
        /// To override the contents of this collection use [`set_harvest_jobs`](Self::set_harvest_jobs).
        ///
        /// A list of HarvestJob records.
        pub fn harvest_jobs(mut self, input: impl Into<crate::model::HarvestJob>) -> Self {
            let mut v = self.harvest_jobs.unwrap_or_default();
            v.push(input.into());
            self.harvest_jobs = Some(v);
            self
        }
        /// A list of HarvestJob records.
        pub fn set_harvest_jobs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HarvestJob>>,
        ) -> Self {
            self.harvest_jobs = input;
            self
        }
        /// A token that can be used to resume pagination from the end of the collection.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// A token that can be used to resume pagination from the end of the collection.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListHarvestJobsOutput`](crate::output::ListHarvestJobsOutput)
        pub fn build(self) -> crate::output::ListHarvestJobsOutput {
            crate::output::ListHarvestJobsOutput {
                harvest_jobs: self.harvest_jobs,
                next_token: self.next_token,
            }
        }
    }
}
impl ListHarvestJobsOutput {
    /// Creates a new builder-style object to manufacture [`ListHarvestJobsOutput`](crate::output::ListHarvestJobsOutput)
    pub fn builder() -> crate::output::list_harvest_jobs_output::Builder {
        crate::output::list_harvest_jobs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListChannelsOutput {
    /// A list of Channel records.
    pub channels: std::option::Option<std::vec::Vec<crate::model::Channel>>,
    /// A token that can be used to resume pagination from the end of the collection.
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListChannelsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListChannelsOutput");
        formatter.field("channels", &self.channels);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListChannelsOutput`](crate::output::ListChannelsOutput)
pub mod list_channels_output {
    /// A builder for [`ListChannelsOutput`](crate::output::ListChannelsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channels: std::option::Option<std::vec::Vec<crate::model::Channel>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `channels`.
        ///
        /// To override the contents of this collection use [`set_channels`](Self::set_channels).
        ///
        /// A list of Channel records.
        pub fn channels(mut self, input: impl Into<crate::model::Channel>) -> Self {
            let mut v = self.channels.unwrap_or_default();
            v.push(input.into());
            self.channels = Some(v);
            self
        }
        /// A list of Channel records.
        pub fn set_channels(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Channel>>,
        ) -> Self {
            self.channels = input;
            self
        }
        /// A token that can be used to resume pagination from the end of the collection.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// A token that can be used to resume pagination from the end of the collection.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListChannelsOutput`](crate::output::ListChannelsOutput)
        pub fn build(self) -> crate::output::ListChannelsOutput {
            crate::output::ListChannelsOutput {
                channels: self.channels,
                next_token: self.next_token,
            }
        }
    }
}
impl ListChannelsOutput {
    /// Creates a new builder-style object to manufacture [`ListChannelsOutput`](crate::output::ListChannelsOutput)
    pub fn builder() -> crate::output::list_channels_output::Builder {
        crate::output::list_channels_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeOriginEndpointOutput {
    /// The Amazon Resource Name (ARN) assigned to the OriginEndpoint.
    pub arn: std::option::Option<std::string::String>,
    /// CDN Authorization credentials
    pub authorization: std::option::Option<crate::model::Authorization>,
    /// The ID of the Channel the OriginEndpoint is associated with.
    pub channel_id: std::option::Option<std::string::String>,
    /// A Common Media Application Format (CMAF) packaging configuration.
    pub cmaf_package: std::option::Option<crate::model::CmafPackage>,
    /// A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
    pub dash_package: std::option::Option<crate::model::DashPackage>,
    /// A short text description of the OriginEndpoint.
    pub description: std::option::Option<std::string::String>,
    /// An HTTP Live Streaming (HLS) packaging configuration.
    pub hls_package: std::option::Option<crate::model::HlsPackage>,
    /// The ID of the OriginEndpoint.
    pub id: std::option::Option<std::string::String>,
    /// A short string appended to the end of the OriginEndpoint URL.
    pub manifest_name: std::option::Option<std::string::String>,
    /// A Microsoft Smooth Streaming (MSS) packaging configuration.
    pub mss_package: std::option::Option<crate::model::MssPackage>,
    /// Control whether origination of video is allowed for this OriginEndpoint. If set to ALLOW, the OriginEndpoint
    /// may by requested, pursuant to any other form of access control. If set to DENY, the OriginEndpoint may not be
    /// requested. This can be helpful for Live to VOD harvesting, or for temporarily disabling origination
    pub origination: std::option::Option<crate::model::Origination>,
    /// Maximum duration (seconds) of content to retain for startover playback.
    /// If not specified, startover playback will be disabled for the OriginEndpoint.
    pub startover_window_seconds: i32,
    /// A collection of tags associated with a resource
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// Amount of delay (seconds) to enforce on the playback of live content.
    /// If not specified, there will be no time delay in effect for the OriginEndpoint.
    pub time_delay_seconds: i32,
    /// The URL of the packaged OriginEndpoint for consumption.
    pub url: std::option::Option<std::string::String>,
    /// A list of source IP CIDR blocks that will be allowed to access the OriginEndpoint.
    pub whitelist: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for DescribeOriginEndpointOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeOriginEndpointOutput");
        formatter.field("arn", &self.arn);
        formatter.field("authorization", &self.authorization);
        formatter.field("channel_id", &self.channel_id);
        formatter.field("cmaf_package", &self.cmaf_package);
        formatter.field("dash_package", &self.dash_package);
        formatter.field("description", &self.description);
        formatter.field("hls_package", &self.hls_package);
        formatter.field("id", &self.id);
        formatter.field("manifest_name", &self.manifest_name);
        formatter.field("mss_package", &self.mss_package);
        formatter.field("origination", &self.origination);
        formatter.field("startover_window_seconds", &self.startover_window_seconds);
        formatter.field("tags", &self.tags);
        formatter.field("time_delay_seconds", &self.time_delay_seconds);
        formatter.field("url", &self.url);
        formatter.field("whitelist", &self.whitelist);
        formatter.finish()
    }
}
/// See [`DescribeOriginEndpointOutput`](crate::output::DescribeOriginEndpointOutput)
pub mod describe_origin_endpoint_output {
    /// A builder for [`DescribeOriginEndpointOutput`](crate::output::DescribeOriginEndpointOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) authorization: std::option::Option<crate::model::Authorization>,
        pub(crate) channel_id: std::option::Option<std::string::String>,
        pub(crate) cmaf_package: std::option::Option<crate::model::CmafPackage>,
        pub(crate) dash_package: std::option::Option<crate::model::DashPackage>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) hls_package: std::option::Option<crate::model::HlsPackage>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) manifest_name: std::option::Option<std::string::String>,
        pub(crate) mss_package: std::option::Option<crate::model::MssPackage>,
        pub(crate) origination: std::option::Option<crate::model::Origination>,
        pub(crate) startover_window_seconds: std::option::Option<i32>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) time_delay_seconds: std::option::Option<i32>,
        pub(crate) url: std::option::Option<std::string::String>,
        pub(crate) whitelist: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// The Amazon Resource Name (ARN) assigned to the OriginEndpoint.
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) assigned to the OriginEndpoint.
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// CDN Authorization credentials
        pub fn authorization(mut self, input: crate::model::Authorization) -> Self {
            self.authorization = Some(input);
            self
        }
        /// CDN Authorization credentials
        pub fn set_authorization(
            mut self,
            input: std::option::Option<crate::model::Authorization>,
        ) -> Self {
            self.authorization = input;
            self
        }
        /// The ID of the Channel the OriginEndpoint is associated with.
        pub fn channel_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_id = Some(input.into());
            self
        }
        /// The ID of the Channel the OriginEndpoint is associated with.
        pub fn set_channel_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_id = input;
            self
        }
        /// A Common Media Application Format (CMAF) packaging configuration.
        pub fn cmaf_package(mut self, input: crate::model::CmafPackage) -> Self {
            self.cmaf_package = Some(input);
            self
        }
        /// A Common Media Application Format (CMAF) packaging configuration.
        pub fn set_cmaf_package(
            mut self,
            input: std::option::Option<crate::model::CmafPackage>,
        ) -> Self {
            self.cmaf_package = input;
            self
        }
        /// A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
        pub fn dash_package(mut self, input: crate::model::DashPackage) -> Self {
            self.dash_package = Some(input);
            self
        }
        /// A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
        pub fn set_dash_package(
            mut self,
            input: std::option::Option<crate::model::DashPackage>,
        ) -> Self {
            self.dash_package = input;
            self
        }
        /// A short text description of the OriginEndpoint.
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// A short text description of the OriginEndpoint.
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// An HTTP Live Streaming (HLS) packaging configuration.
        pub fn hls_package(mut self, input: crate::model::HlsPackage) -> Self {
            self.hls_package = Some(input);
            self
        }
        /// An HTTP Live Streaming (HLS) packaging configuration.
        pub fn set_hls_package(
            mut self,
            input: std::option::Option<crate::model::HlsPackage>,
        ) -> Self {
            self.hls_package = input;
            self
        }
        /// The ID of the OriginEndpoint.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// The ID of the OriginEndpoint.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// A short string appended to the end of the OriginEndpoint URL.
        pub fn manifest_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.manifest_name = Some(input.into());
            self
        }
        /// A short string appended to the end of the OriginEndpoint URL.
        pub fn set_manifest_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.manifest_name = input;
            self
        }
        /// A Microsoft Smooth Streaming (MSS) packaging configuration.
        pub fn mss_package(mut self, input: crate::model::MssPackage) -> Self {
            self.mss_package = Some(input);
            self
        }
        /// A Microsoft Smooth Streaming (MSS) packaging configuration.
        pub fn set_mss_package(
            mut self,
            input: std::option::Option<crate::model::MssPackage>,
        ) -> Self {
            self.mss_package = input;
            self
        }
        /// Control whether origination of video is allowed for this OriginEndpoint. If set to ALLOW, the OriginEndpoint
        /// may by requested, pursuant to any other form of access control. If set to DENY, the OriginEndpoint may not be
        /// requested. This can be helpful for Live to VOD harvesting, or for temporarily disabling origination
        pub fn origination(mut self, input: crate::model::Origination) -> Self {
            self.origination = Some(input);
            self
        }
        /// Control whether origination of video is allowed for this OriginEndpoint. If set to ALLOW, the OriginEndpoint
        /// may by requested, pursuant to any other form of access control. If set to DENY, the OriginEndpoint may not be
        /// requested. This can be helpful for Live to VOD harvesting, or for temporarily disabling origination
        pub fn set_origination(
            mut self,
            input: std::option::Option<crate::model::Origination>,
        ) -> Self {
            self.origination = input;
            self
        }
        /// Maximum duration (seconds) of content to retain for startover playback.
        /// If not specified, startover playback will be disabled for the OriginEndpoint.
        pub fn startover_window_seconds(mut self, input: i32) -> Self {
            self.startover_window_seconds = Some(input);
            self
        }
        /// Maximum duration (seconds) of content to retain for startover playback.
        /// If not specified, startover playback will be disabled for the OriginEndpoint.
        pub fn set_startover_window_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.startover_window_seconds = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of tags associated with a resource
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// A collection of tags associated with a resource
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Amount of delay (seconds) to enforce on the playback of live content.
        /// If not specified, there will be no time delay in effect for the OriginEndpoint.
        pub fn time_delay_seconds(mut self, input: i32) -> Self {
            self.time_delay_seconds = Some(input);
            self
        }
        /// Amount of delay (seconds) to enforce on the playback of live content.
        /// If not specified, there will be no time delay in effect for the OriginEndpoint.
        pub fn set_time_delay_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.time_delay_seconds = input;
            self
        }
        /// The URL of the packaged OriginEndpoint for consumption.
        pub fn url(mut self, input: impl Into<std::string::String>) -> Self {
            self.url = Some(input.into());
            self
        }
        /// The URL of the packaged OriginEndpoint for consumption.
        pub fn set_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.url = input;
            self
        }
        /// Appends an item to `whitelist`.
        ///
        /// To override the contents of this collection use [`set_whitelist`](Self::set_whitelist).
        ///
        /// A list of source IP CIDR blocks that will be allowed to access the OriginEndpoint.
        pub fn whitelist(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.whitelist.unwrap_or_default();
            v.push(input.into());
            self.whitelist = Some(v);
            self
        }
        /// A list of source IP CIDR blocks that will be allowed to access the OriginEndpoint.
        pub fn set_whitelist(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.whitelist = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeOriginEndpointOutput`](crate::output::DescribeOriginEndpointOutput)
        pub fn build(self) -> crate::output::DescribeOriginEndpointOutput {
            crate::output::DescribeOriginEndpointOutput {
                arn: self.arn,
                authorization: self.authorization,
                channel_id: self.channel_id,
                cmaf_package: self.cmaf_package,
                dash_package: self.dash_package,
                description: self.description,
                hls_package: self.hls_package,
                id: self.id,
                manifest_name: self.manifest_name,
                mss_package: self.mss_package,
                origination: self.origination,
                startover_window_seconds: self.startover_window_seconds.unwrap_or_default(),
                tags: self.tags,
                time_delay_seconds: self.time_delay_seconds.unwrap_or_default(),
                url: self.url,
                whitelist: self.whitelist,
            }
        }
    }
}
impl DescribeOriginEndpointOutput {
    /// Creates a new builder-style object to manufacture [`DescribeOriginEndpointOutput`](crate::output::DescribeOriginEndpointOutput)
    pub fn builder() -> crate::output::describe_origin_endpoint_output::Builder {
        crate::output::describe_origin_endpoint_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeHarvestJobOutput {
    /// The Amazon Resource Name (ARN) assigned to the HarvestJob.
    pub arn: std::option::Option<std::string::String>,
    /// The ID of the Channel that the HarvestJob will harvest from.
    pub channel_id: std::option::Option<std::string::String>,
    /// The time the HarvestJob was submitted
    pub created_at: std::option::Option<std::string::String>,
    /// The end of the time-window which will be harvested.
    pub end_time: std::option::Option<std::string::String>,
    /// The ID of the HarvestJob. The ID must be unique within the region
    /// and it cannot be changed after the HarvestJob is submitted.
    pub id: std::option::Option<std::string::String>,
    /// The ID of the OriginEndpoint that the HarvestJob will harvest from.
    /// This cannot be changed after the HarvestJob is submitted.
    pub origin_endpoint_id: std::option::Option<std::string::String>,
    /// Configuration parameters for where in an S3 bucket to place the harvested content
    pub s3_destination: std::option::Option<crate::model::S3Destination>,
    /// The start of the time-window which will be harvested.
    pub start_time: std::option::Option<std::string::String>,
    /// The current status of the HarvestJob. Consider setting up a CloudWatch Event to listen for
    /// HarvestJobs as they succeed or fail. In the event of failure, the CloudWatch Event will
    /// include an explanation of why the HarvestJob failed.
    pub status: std::option::Option<crate::model::Status>,
}
impl std::fmt::Debug for DescribeHarvestJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeHarvestJobOutput");
        formatter.field("arn", &self.arn);
        formatter.field("channel_id", &self.channel_id);
        formatter.field("created_at", &self.created_at);
        formatter.field("end_time", &self.end_time);
        formatter.field("id", &self.id);
        formatter.field("origin_endpoint_id", &self.origin_endpoint_id);
        formatter.field("s3_destination", &self.s3_destination);
        formatter.field("start_time", &self.start_time);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`DescribeHarvestJobOutput`](crate::output::DescribeHarvestJobOutput)
pub mod describe_harvest_job_output {
    /// A builder for [`DescribeHarvestJobOutput`](crate::output::DescribeHarvestJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) channel_id: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<std::string::String>,
        pub(crate) end_time: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) origin_endpoint_id: std::option::Option<std::string::String>,
        pub(crate) s3_destination: std::option::Option<crate::model::S3Destination>,
        pub(crate) start_time: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::Status>,
    }
    impl Builder {
        /// The Amazon Resource Name (ARN) assigned to the HarvestJob.
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) assigned to the HarvestJob.
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// The ID of the Channel that the HarvestJob will harvest from.
        pub fn channel_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_id = Some(input.into());
            self
        }
        /// The ID of the Channel that the HarvestJob will harvest from.
        pub fn set_channel_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_id = input;
            self
        }
        /// The time the HarvestJob was submitted
        pub fn created_at(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_at = Some(input.into());
            self
        }
        /// The time the HarvestJob was submitted
        pub fn set_created_at(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_at = input;
            self
        }
        /// The end of the time-window which will be harvested.
        pub fn end_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.end_time = Some(input.into());
            self
        }
        /// The end of the time-window which will be harvested.
        pub fn set_end_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.end_time = input;
            self
        }
        /// The ID of the HarvestJob. The ID must be unique within the region
        /// and it cannot be changed after the HarvestJob is submitted.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// The ID of the HarvestJob. The ID must be unique within the region
        /// and it cannot be changed after the HarvestJob is submitted.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// The ID of the OriginEndpoint that the HarvestJob will harvest from.
        /// This cannot be changed after the HarvestJob is submitted.
        pub fn origin_endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.origin_endpoint_id = Some(input.into());
            self
        }
        /// The ID of the OriginEndpoint that the HarvestJob will harvest from.
        /// This cannot be changed after the HarvestJob is submitted.
        pub fn set_origin_endpoint_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.origin_endpoint_id = input;
            self
        }
        /// Configuration parameters for where in an S3 bucket to place the harvested content
        pub fn s3_destination(mut self, input: crate::model::S3Destination) -> Self {
            self.s3_destination = Some(input);
            self
        }
        /// Configuration parameters for where in an S3 bucket to place the harvested content
        pub fn set_s3_destination(
            mut self,
            input: std::option::Option<crate::model::S3Destination>,
        ) -> Self {
            self.s3_destination = input;
            self
        }
        /// The start of the time-window which will be harvested.
        pub fn start_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.start_time = Some(input.into());
            self
        }
        /// The start of the time-window which will be harvested.
        pub fn set_start_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.start_time = input;
            self
        }
        /// The current status of the HarvestJob. Consider setting up a CloudWatch Event to listen for
        /// HarvestJobs as they succeed or fail. In the event of failure, the CloudWatch Event will
        /// include an explanation of why the HarvestJob failed.
        pub fn status(mut self, input: crate::model::Status) -> Self {
            self.status = Some(input);
            self
        }
        /// The current status of the HarvestJob. Consider setting up a CloudWatch Event to listen for
        /// HarvestJobs as they succeed or fail. In the event of failure, the CloudWatch Event will
        /// include an explanation of why the HarvestJob failed.
        pub fn set_status(mut self, input: std::option::Option<crate::model::Status>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeHarvestJobOutput`](crate::output::DescribeHarvestJobOutput)
        pub fn build(self) -> crate::output::DescribeHarvestJobOutput {
            crate::output::DescribeHarvestJobOutput {
                arn: self.arn,
                channel_id: self.channel_id,
                created_at: self.created_at,
                end_time: self.end_time,
                id: self.id,
                origin_endpoint_id: self.origin_endpoint_id,
                s3_destination: self.s3_destination,
                start_time: self.start_time,
                status: self.status,
            }
        }
    }
}
impl DescribeHarvestJobOutput {
    /// Creates a new builder-style object to manufacture [`DescribeHarvestJobOutput`](crate::output::DescribeHarvestJobOutput)
    pub fn builder() -> crate::output::describe_harvest_job_output::Builder {
        crate::output::describe_harvest_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeChannelOutput {
    /// The Amazon Resource Name (ARN) assigned to the Channel.
    pub arn: std::option::Option<std::string::String>,
    /// A short text description of the Channel.
    pub description: std::option::Option<std::string::String>,
    /// Configure egress access logging.
    pub egress_access_logs: std::option::Option<crate::model::EgressAccessLogs>,
    /// An HTTP Live Streaming (HLS) ingest resource configuration.
    pub hls_ingest: std::option::Option<crate::model::HlsIngest>,
    /// The ID of the Channel.
    pub id: std::option::Option<std::string::String>,
    /// Configure ingress access logging.
    pub ingress_access_logs: std::option::Option<crate::model::IngressAccessLogs>,
    /// A collection of tags associated with a resource
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for DescribeChannelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeChannelOutput");
        formatter.field("arn", &self.arn);
        formatter.field("description", &self.description);
        formatter.field("egress_access_logs", &self.egress_access_logs);
        formatter.field("hls_ingest", &self.hls_ingest);
        formatter.field("id", &self.id);
        formatter.field("ingress_access_logs", &self.ingress_access_logs);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`DescribeChannelOutput`](crate::output::DescribeChannelOutput)
pub mod describe_channel_output {
    /// A builder for [`DescribeChannelOutput`](crate::output::DescribeChannelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) egress_access_logs: std::option::Option<crate::model::EgressAccessLogs>,
        pub(crate) hls_ingest: std::option::Option<crate::model::HlsIngest>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) ingress_access_logs: std::option::Option<crate::model::IngressAccessLogs>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// The Amazon Resource Name (ARN) assigned to the Channel.
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) assigned to the Channel.
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// A short text description of the Channel.
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// A short text description of the Channel.
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Configure egress access logging.
        pub fn egress_access_logs(mut self, input: crate::model::EgressAccessLogs) -> Self {
            self.egress_access_logs = Some(input);
            self
        }
        /// Configure egress access logging.
        pub fn set_egress_access_logs(
            mut self,
            input: std::option::Option<crate::model::EgressAccessLogs>,
        ) -> Self {
            self.egress_access_logs = input;
            self
        }
        /// An HTTP Live Streaming (HLS) ingest resource configuration.
        pub fn hls_ingest(mut self, input: crate::model::HlsIngest) -> Self {
            self.hls_ingest = Some(input);
            self
        }
        /// An HTTP Live Streaming (HLS) ingest resource configuration.
        pub fn set_hls_ingest(
            mut self,
            input: std::option::Option<crate::model::HlsIngest>,
        ) -> Self {
            self.hls_ingest = input;
            self
        }
        /// The ID of the Channel.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// The ID of the Channel.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Configure ingress access logging.
        pub fn ingress_access_logs(mut self, input: crate::model::IngressAccessLogs) -> Self {
            self.ingress_access_logs = Some(input);
            self
        }
        /// Configure ingress access logging.
        pub fn set_ingress_access_logs(
            mut self,
            input: std::option::Option<crate::model::IngressAccessLogs>,
        ) -> Self {
            self.ingress_access_logs = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of tags associated with a resource
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// A collection of tags associated with a resource
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeChannelOutput`](crate::output::DescribeChannelOutput)
        pub fn build(self) -> crate::output::DescribeChannelOutput {
            crate::output::DescribeChannelOutput {
                arn: self.arn,
                description: self.description,
                egress_access_logs: self.egress_access_logs,
                hls_ingest: self.hls_ingest,
                id: self.id,
                ingress_access_logs: self.ingress_access_logs,
                tags: self.tags,
            }
        }
    }
}
impl DescribeChannelOutput {
    /// Creates a new builder-style object to manufacture [`DescribeChannelOutput`](crate::output::DescribeChannelOutput)
    pub fn builder() -> crate::output::describe_channel_output::Builder {
        crate::output::describe_channel_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteOriginEndpointOutput {}
impl std::fmt::Debug for DeleteOriginEndpointOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteOriginEndpointOutput");
        formatter.finish()
    }
}
/// See [`DeleteOriginEndpointOutput`](crate::output::DeleteOriginEndpointOutput)
pub mod delete_origin_endpoint_output {
    /// A builder for [`DeleteOriginEndpointOutput`](crate::output::DeleteOriginEndpointOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteOriginEndpointOutput`](crate::output::DeleteOriginEndpointOutput)
        pub fn build(self) -> crate::output::DeleteOriginEndpointOutput {
            crate::output::DeleteOriginEndpointOutput {}
        }
    }
}
impl DeleteOriginEndpointOutput {
    /// Creates a new builder-style object to manufacture [`DeleteOriginEndpointOutput`](crate::output::DeleteOriginEndpointOutput)
    pub fn builder() -> crate::output::delete_origin_endpoint_output::Builder {
        crate::output::delete_origin_endpoint_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteChannelOutput {}
impl std::fmt::Debug for DeleteChannelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteChannelOutput");
        formatter.finish()
    }
}
/// See [`DeleteChannelOutput`](crate::output::DeleteChannelOutput)
pub mod delete_channel_output {
    /// A builder for [`DeleteChannelOutput`](crate::output::DeleteChannelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteChannelOutput`](crate::output::DeleteChannelOutput)
        pub fn build(self) -> crate::output::DeleteChannelOutput {
            crate::output::DeleteChannelOutput {}
        }
    }
}
impl DeleteChannelOutput {
    /// Creates a new builder-style object to manufacture [`DeleteChannelOutput`](crate::output::DeleteChannelOutput)
    pub fn builder() -> crate::output::delete_channel_output::Builder {
        crate::output::delete_channel_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateOriginEndpointOutput {
    /// The Amazon Resource Name (ARN) assigned to the OriginEndpoint.
    pub arn: std::option::Option<std::string::String>,
    /// CDN Authorization credentials
    pub authorization: std::option::Option<crate::model::Authorization>,
    /// The ID of the Channel the OriginEndpoint is associated with.
    pub channel_id: std::option::Option<std::string::String>,
    /// A Common Media Application Format (CMAF) packaging configuration.
    pub cmaf_package: std::option::Option<crate::model::CmafPackage>,
    /// A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
    pub dash_package: std::option::Option<crate::model::DashPackage>,
    /// A short text description of the OriginEndpoint.
    pub description: std::option::Option<std::string::String>,
    /// An HTTP Live Streaming (HLS) packaging configuration.
    pub hls_package: std::option::Option<crate::model::HlsPackage>,
    /// The ID of the OriginEndpoint.
    pub id: std::option::Option<std::string::String>,
    /// A short string appended to the end of the OriginEndpoint URL.
    pub manifest_name: std::option::Option<std::string::String>,
    /// A Microsoft Smooth Streaming (MSS) packaging configuration.
    pub mss_package: std::option::Option<crate::model::MssPackage>,
    /// Control whether origination of video is allowed for this OriginEndpoint. If set to ALLOW, the OriginEndpoint
    /// may by requested, pursuant to any other form of access control. If set to DENY, the OriginEndpoint may not be
    /// requested. This can be helpful for Live to VOD harvesting, or for temporarily disabling origination
    pub origination: std::option::Option<crate::model::Origination>,
    /// Maximum duration (seconds) of content to retain for startover playback.
    /// If not specified, startover playback will be disabled for the OriginEndpoint.
    pub startover_window_seconds: i32,
    /// A collection of tags associated with a resource
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// Amount of delay (seconds) to enforce on the playback of live content.
    /// If not specified, there will be no time delay in effect for the OriginEndpoint.
    pub time_delay_seconds: i32,
    /// The URL of the packaged OriginEndpoint for consumption.
    pub url: std::option::Option<std::string::String>,
    /// A list of source IP CIDR blocks that will be allowed to access the OriginEndpoint.
    pub whitelist: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for CreateOriginEndpointOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateOriginEndpointOutput");
        formatter.field("arn", &self.arn);
        formatter.field("authorization", &self.authorization);
        formatter.field("channel_id", &self.channel_id);
        formatter.field("cmaf_package", &self.cmaf_package);
        formatter.field("dash_package", &self.dash_package);
        formatter.field("description", &self.description);
        formatter.field("hls_package", &self.hls_package);
        formatter.field("id", &self.id);
        formatter.field("manifest_name", &self.manifest_name);
        formatter.field("mss_package", &self.mss_package);
        formatter.field("origination", &self.origination);
        formatter.field("startover_window_seconds", &self.startover_window_seconds);
        formatter.field("tags", &self.tags);
        formatter.field("time_delay_seconds", &self.time_delay_seconds);
        formatter.field("url", &self.url);
        formatter.field("whitelist", &self.whitelist);
        formatter.finish()
    }
}
/// See [`CreateOriginEndpointOutput`](crate::output::CreateOriginEndpointOutput)
pub mod create_origin_endpoint_output {
    /// A builder for [`CreateOriginEndpointOutput`](crate::output::CreateOriginEndpointOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) authorization: std::option::Option<crate::model::Authorization>,
        pub(crate) channel_id: std::option::Option<std::string::String>,
        pub(crate) cmaf_package: std::option::Option<crate::model::CmafPackage>,
        pub(crate) dash_package: std::option::Option<crate::model::DashPackage>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) hls_package: std::option::Option<crate::model::HlsPackage>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) manifest_name: std::option::Option<std::string::String>,
        pub(crate) mss_package: std::option::Option<crate::model::MssPackage>,
        pub(crate) origination: std::option::Option<crate::model::Origination>,
        pub(crate) startover_window_seconds: std::option::Option<i32>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) time_delay_seconds: std::option::Option<i32>,
        pub(crate) url: std::option::Option<std::string::String>,
        pub(crate) whitelist: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// The Amazon Resource Name (ARN) assigned to the OriginEndpoint.
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) assigned to the OriginEndpoint.
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// CDN Authorization credentials
        pub fn authorization(mut self, input: crate::model::Authorization) -> Self {
            self.authorization = Some(input);
            self
        }
        /// CDN Authorization credentials
        pub fn set_authorization(
            mut self,
            input: std::option::Option<crate::model::Authorization>,
        ) -> Self {
            self.authorization = input;
            self
        }
        /// The ID of the Channel the OriginEndpoint is associated with.
        pub fn channel_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_id = Some(input.into());
            self
        }
        /// The ID of the Channel the OriginEndpoint is associated with.
        pub fn set_channel_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_id = input;
            self
        }
        /// A Common Media Application Format (CMAF) packaging configuration.
        pub fn cmaf_package(mut self, input: crate::model::CmafPackage) -> Self {
            self.cmaf_package = Some(input);
            self
        }
        /// A Common Media Application Format (CMAF) packaging configuration.
        pub fn set_cmaf_package(
            mut self,
            input: std::option::Option<crate::model::CmafPackage>,
        ) -> Self {
            self.cmaf_package = input;
            self
        }
        /// A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
        pub fn dash_package(mut self, input: crate::model::DashPackage) -> Self {
            self.dash_package = Some(input);
            self
        }
        /// A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
        pub fn set_dash_package(
            mut self,
            input: std::option::Option<crate::model::DashPackage>,
        ) -> Self {
            self.dash_package = input;
            self
        }
        /// A short text description of the OriginEndpoint.
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// A short text description of the OriginEndpoint.
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// An HTTP Live Streaming (HLS) packaging configuration.
        pub fn hls_package(mut self, input: crate::model::HlsPackage) -> Self {
            self.hls_package = Some(input);
            self
        }
        /// An HTTP Live Streaming (HLS) packaging configuration.
        pub fn set_hls_package(
            mut self,
            input: std::option::Option<crate::model::HlsPackage>,
        ) -> Self {
            self.hls_package = input;
            self
        }
        /// The ID of the OriginEndpoint.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// The ID of the OriginEndpoint.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// A short string appended to the end of the OriginEndpoint URL.
        pub fn manifest_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.manifest_name = Some(input.into());
            self
        }
        /// A short string appended to the end of the OriginEndpoint URL.
        pub fn set_manifest_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.manifest_name = input;
            self
        }
        /// A Microsoft Smooth Streaming (MSS) packaging configuration.
        pub fn mss_package(mut self, input: crate::model::MssPackage) -> Self {
            self.mss_package = Some(input);
            self
        }
        /// A Microsoft Smooth Streaming (MSS) packaging configuration.
        pub fn set_mss_package(
            mut self,
            input: std::option::Option<crate::model::MssPackage>,
        ) -> Self {
            self.mss_package = input;
            self
        }
        /// Control whether origination of video is allowed for this OriginEndpoint. If set to ALLOW, the OriginEndpoint
        /// may by requested, pursuant to any other form of access control. If set to DENY, the OriginEndpoint may not be
        /// requested. This can be helpful for Live to VOD harvesting, or for temporarily disabling origination
        pub fn origination(mut self, input: crate::model::Origination) -> Self {
            self.origination = Some(input);
            self
        }
        /// Control whether origination of video is allowed for this OriginEndpoint. If set to ALLOW, the OriginEndpoint
        /// may by requested, pursuant to any other form of access control. If set to DENY, the OriginEndpoint may not be
        /// requested. This can be helpful for Live to VOD harvesting, or for temporarily disabling origination
        pub fn set_origination(
            mut self,
            input: std::option::Option<crate::model::Origination>,
        ) -> Self {
            self.origination = input;
            self
        }
        /// Maximum duration (seconds) of content to retain for startover playback.
        /// If not specified, startover playback will be disabled for the OriginEndpoint.
        pub fn startover_window_seconds(mut self, input: i32) -> Self {
            self.startover_window_seconds = Some(input);
            self
        }
        /// Maximum duration (seconds) of content to retain for startover playback.
        /// If not specified, startover playback will be disabled for the OriginEndpoint.
        pub fn set_startover_window_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.startover_window_seconds = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of tags associated with a resource
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// A collection of tags associated with a resource
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Amount of delay (seconds) to enforce on the playback of live content.
        /// If not specified, there will be no time delay in effect for the OriginEndpoint.
        pub fn time_delay_seconds(mut self, input: i32) -> Self {
            self.time_delay_seconds = Some(input);
            self
        }
        /// Amount of delay (seconds) to enforce on the playback of live content.
        /// If not specified, there will be no time delay in effect for the OriginEndpoint.
        pub fn set_time_delay_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.time_delay_seconds = input;
            self
        }
        /// The URL of the packaged OriginEndpoint for consumption.
        pub fn url(mut self, input: impl Into<std::string::String>) -> Self {
            self.url = Some(input.into());
            self
        }
        /// The URL of the packaged OriginEndpoint for consumption.
        pub fn set_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.url = input;
            self
        }
        /// Appends an item to `whitelist`.
        ///
        /// To override the contents of this collection use [`set_whitelist`](Self::set_whitelist).
        ///
        /// A list of source IP CIDR blocks that will be allowed to access the OriginEndpoint.
        pub fn whitelist(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.whitelist.unwrap_or_default();
            v.push(input.into());
            self.whitelist = Some(v);
            self
        }
        /// A list of source IP CIDR blocks that will be allowed to access the OriginEndpoint.
        pub fn set_whitelist(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.whitelist = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateOriginEndpointOutput`](crate::output::CreateOriginEndpointOutput)
        pub fn build(self) -> crate::output::CreateOriginEndpointOutput {
            crate::output::CreateOriginEndpointOutput {
                arn: self.arn,
                authorization: self.authorization,
                channel_id: self.channel_id,
                cmaf_package: self.cmaf_package,
                dash_package: self.dash_package,
                description: self.description,
                hls_package: self.hls_package,
                id: self.id,
                manifest_name: self.manifest_name,
                mss_package: self.mss_package,
                origination: self.origination,
                startover_window_seconds: self.startover_window_seconds.unwrap_or_default(),
                tags: self.tags,
                time_delay_seconds: self.time_delay_seconds.unwrap_or_default(),
                url: self.url,
                whitelist: self.whitelist,
            }
        }
    }
}
impl CreateOriginEndpointOutput {
    /// Creates a new builder-style object to manufacture [`CreateOriginEndpointOutput`](crate::output::CreateOriginEndpointOutput)
    pub fn builder() -> crate::output::create_origin_endpoint_output::Builder {
        crate::output::create_origin_endpoint_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateHarvestJobOutput {
    /// The Amazon Resource Name (ARN) assigned to the HarvestJob.
    pub arn: std::option::Option<std::string::String>,
    /// The ID of the Channel that the HarvestJob will harvest from.
    pub channel_id: std::option::Option<std::string::String>,
    /// The time the HarvestJob was submitted
    pub created_at: std::option::Option<std::string::String>,
    /// The end of the time-window which will be harvested.
    pub end_time: std::option::Option<std::string::String>,
    /// The ID of the HarvestJob. The ID must be unique within the region
    /// and it cannot be changed after the HarvestJob is submitted.
    pub id: std::option::Option<std::string::String>,
    /// The ID of the OriginEndpoint that the HarvestJob will harvest from.
    /// This cannot be changed after the HarvestJob is submitted.
    pub origin_endpoint_id: std::option::Option<std::string::String>,
    /// Configuration parameters for where in an S3 bucket to place the harvested content
    pub s3_destination: std::option::Option<crate::model::S3Destination>,
    /// The start of the time-window which will be harvested.
    pub start_time: std::option::Option<std::string::String>,
    /// The current status of the HarvestJob. Consider setting up a CloudWatch Event to listen for
    /// HarvestJobs as they succeed or fail. In the event of failure, the CloudWatch Event will
    /// include an explanation of why the HarvestJob failed.
    pub status: std::option::Option<crate::model::Status>,
}
impl std::fmt::Debug for CreateHarvestJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateHarvestJobOutput");
        formatter.field("arn", &self.arn);
        formatter.field("channel_id", &self.channel_id);
        formatter.field("created_at", &self.created_at);
        formatter.field("end_time", &self.end_time);
        formatter.field("id", &self.id);
        formatter.field("origin_endpoint_id", &self.origin_endpoint_id);
        formatter.field("s3_destination", &self.s3_destination);
        formatter.field("start_time", &self.start_time);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`CreateHarvestJobOutput`](crate::output::CreateHarvestJobOutput)
pub mod create_harvest_job_output {
    /// A builder for [`CreateHarvestJobOutput`](crate::output::CreateHarvestJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) channel_id: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<std::string::String>,
        pub(crate) end_time: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) origin_endpoint_id: std::option::Option<std::string::String>,
        pub(crate) s3_destination: std::option::Option<crate::model::S3Destination>,
        pub(crate) start_time: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::Status>,
    }
    impl Builder {
        /// The Amazon Resource Name (ARN) assigned to the HarvestJob.
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) assigned to the HarvestJob.
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// The ID of the Channel that the HarvestJob will harvest from.
        pub fn channel_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_id = Some(input.into());
            self
        }
        /// The ID of the Channel that the HarvestJob will harvest from.
        pub fn set_channel_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_id = input;
            self
        }
        /// The time the HarvestJob was submitted
        pub fn created_at(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_at = Some(input.into());
            self
        }
        /// The time the HarvestJob was submitted
        pub fn set_created_at(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_at = input;
            self
        }
        /// The end of the time-window which will be harvested.
        pub fn end_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.end_time = Some(input.into());
            self
        }
        /// The end of the time-window which will be harvested.
        pub fn set_end_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.end_time = input;
            self
        }
        /// The ID of the HarvestJob. The ID must be unique within the region
        /// and it cannot be changed after the HarvestJob is submitted.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// The ID of the HarvestJob. The ID must be unique within the region
        /// and it cannot be changed after the HarvestJob is submitted.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// The ID of the OriginEndpoint that the HarvestJob will harvest from.
        /// This cannot be changed after the HarvestJob is submitted.
        pub fn origin_endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.origin_endpoint_id = Some(input.into());
            self
        }
        /// The ID of the OriginEndpoint that the HarvestJob will harvest from.
        /// This cannot be changed after the HarvestJob is submitted.
        pub fn set_origin_endpoint_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.origin_endpoint_id = input;
            self
        }
        /// Configuration parameters for where in an S3 bucket to place the harvested content
        pub fn s3_destination(mut self, input: crate::model::S3Destination) -> Self {
            self.s3_destination = Some(input);
            self
        }
        /// Configuration parameters for where in an S3 bucket to place the harvested content
        pub fn set_s3_destination(
            mut self,
            input: std::option::Option<crate::model::S3Destination>,
        ) -> Self {
            self.s3_destination = input;
            self
        }
        /// The start of the time-window which will be harvested.
        pub fn start_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.start_time = Some(input.into());
            self
        }
        /// The start of the time-window which will be harvested.
        pub fn set_start_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.start_time = input;
            self
        }
        /// The current status of the HarvestJob. Consider setting up a CloudWatch Event to listen for
        /// HarvestJobs as they succeed or fail. In the event of failure, the CloudWatch Event will
        /// include an explanation of why the HarvestJob failed.
        pub fn status(mut self, input: crate::model::Status) -> Self {
            self.status = Some(input);
            self
        }
        /// The current status of the HarvestJob. Consider setting up a CloudWatch Event to listen for
        /// HarvestJobs as they succeed or fail. In the event of failure, the CloudWatch Event will
        /// include an explanation of why the HarvestJob failed.
        pub fn set_status(mut self, input: std::option::Option<crate::model::Status>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateHarvestJobOutput`](crate::output::CreateHarvestJobOutput)
        pub fn build(self) -> crate::output::CreateHarvestJobOutput {
            crate::output::CreateHarvestJobOutput {
                arn: self.arn,
                channel_id: self.channel_id,
                created_at: self.created_at,
                end_time: self.end_time,
                id: self.id,
                origin_endpoint_id: self.origin_endpoint_id,
                s3_destination: self.s3_destination,
                start_time: self.start_time,
                status: self.status,
            }
        }
    }
}
impl CreateHarvestJobOutput {
    /// Creates a new builder-style object to manufacture [`CreateHarvestJobOutput`](crate::output::CreateHarvestJobOutput)
    pub fn builder() -> crate::output::create_harvest_job_output::Builder {
        crate::output::create_harvest_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateChannelOutput {
    /// The Amazon Resource Name (ARN) assigned to the Channel.
    pub arn: std::option::Option<std::string::String>,
    /// A short text description of the Channel.
    pub description: std::option::Option<std::string::String>,
    /// Configure egress access logging.
    pub egress_access_logs: std::option::Option<crate::model::EgressAccessLogs>,
    /// An HTTP Live Streaming (HLS) ingest resource configuration.
    pub hls_ingest: std::option::Option<crate::model::HlsIngest>,
    /// The ID of the Channel.
    pub id: std::option::Option<std::string::String>,
    /// Configure ingress access logging.
    pub ingress_access_logs: std::option::Option<crate::model::IngressAccessLogs>,
    /// A collection of tags associated with a resource
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for CreateChannelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateChannelOutput");
        formatter.field("arn", &self.arn);
        formatter.field("description", &self.description);
        formatter.field("egress_access_logs", &self.egress_access_logs);
        formatter.field("hls_ingest", &self.hls_ingest);
        formatter.field("id", &self.id);
        formatter.field("ingress_access_logs", &self.ingress_access_logs);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`CreateChannelOutput`](crate::output::CreateChannelOutput)
pub mod create_channel_output {
    /// A builder for [`CreateChannelOutput`](crate::output::CreateChannelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) egress_access_logs: std::option::Option<crate::model::EgressAccessLogs>,
        pub(crate) hls_ingest: std::option::Option<crate::model::HlsIngest>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) ingress_access_logs: std::option::Option<crate::model::IngressAccessLogs>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// The Amazon Resource Name (ARN) assigned to the Channel.
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) assigned to the Channel.
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// A short text description of the Channel.
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// A short text description of the Channel.
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Configure egress access logging.
        pub fn egress_access_logs(mut self, input: crate::model::EgressAccessLogs) -> Self {
            self.egress_access_logs = Some(input);
            self
        }
        /// Configure egress access logging.
        pub fn set_egress_access_logs(
            mut self,
            input: std::option::Option<crate::model::EgressAccessLogs>,
        ) -> Self {
            self.egress_access_logs = input;
            self
        }
        /// An HTTP Live Streaming (HLS) ingest resource configuration.
        pub fn hls_ingest(mut self, input: crate::model::HlsIngest) -> Self {
            self.hls_ingest = Some(input);
            self
        }
        /// An HTTP Live Streaming (HLS) ingest resource configuration.
        pub fn set_hls_ingest(
            mut self,
            input: std::option::Option<crate::model::HlsIngest>,
        ) -> Self {
            self.hls_ingest = input;
            self
        }
        /// The ID of the Channel.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// The ID of the Channel.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Configure ingress access logging.
        pub fn ingress_access_logs(mut self, input: crate::model::IngressAccessLogs) -> Self {
            self.ingress_access_logs = Some(input);
            self
        }
        /// Configure ingress access logging.
        pub fn set_ingress_access_logs(
            mut self,
            input: std::option::Option<crate::model::IngressAccessLogs>,
        ) -> Self {
            self.ingress_access_logs = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of tags associated with a resource
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// A collection of tags associated with a resource
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateChannelOutput`](crate::output::CreateChannelOutput)
        pub fn build(self) -> crate::output::CreateChannelOutput {
            crate::output::CreateChannelOutput {
                arn: self.arn,
                description: self.description,
                egress_access_logs: self.egress_access_logs,
                hls_ingest: self.hls_ingest,
                id: self.id,
                ingress_access_logs: self.ingress_access_logs,
                tags: self.tags,
            }
        }
    }
}
impl CreateChannelOutput {
    /// Creates a new builder-style object to manufacture [`CreateChannelOutput`](crate::output::CreateChannelOutput)
    pub fn builder() -> crate::output::create_channel_output::Builder {
        crate::output::create_channel_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConfigureLogsOutput {
    /// The Amazon Resource Name (ARN) assigned to the Channel.
    pub arn: std::option::Option<std::string::String>,
    /// A short text description of the Channel.
    pub description: std::option::Option<std::string::String>,
    /// Configure egress access logging.
    pub egress_access_logs: std::option::Option<crate::model::EgressAccessLogs>,
    /// An HTTP Live Streaming (HLS) ingest resource configuration.
    pub hls_ingest: std::option::Option<crate::model::HlsIngest>,
    /// The ID of the Channel.
    pub id: std::option::Option<std::string::String>,
    /// Configure ingress access logging.
    pub ingress_access_logs: std::option::Option<crate::model::IngressAccessLogs>,
    /// A collection of tags associated with a resource
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for ConfigureLogsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConfigureLogsOutput");
        formatter.field("arn", &self.arn);
        formatter.field("description", &self.description);
        formatter.field("egress_access_logs", &self.egress_access_logs);
        formatter.field("hls_ingest", &self.hls_ingest);
        formatter.field("id", &self.id);
        formatter.field("ingress_access_logs", &self.ingress_access_logs);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ConfigureLogsOutput`](crate::output::ConfigureLogsOutput)
pub mod configure_logs_output {
    /// A builder for [`ConfigureLogsOutput`](crate::output::ConfigureLogsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) egress_access_logs: std::option::Option<crate::model::EgressAccessLogs>,
        pub(crate) hls_ingest: std::option::Option<crate::model::HlsIngest>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) ingress_access_logs: std::option::Option<crate::model::IngressAccessLogs>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// The Amazon Resource Name (ARN) assigned to the Channel.
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) assigned to the Channel.
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// A short text description of the Channel.
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// A short text description of the Channel.
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Configure egress access logging.
        pub fn egress_access_logs(mut self, input: crate::model::EgressAccessLogs) -> Self {
            self.egress_access_logs = Some(input);
            self
        }
        /// Configure egress access logging.
        pub fn set_egress_access_logs(
            mut self,
            input: std::option::Option<crate::model::EgressAccessLogs>,
        ) -> Self {
            self.egress_access_logs = input;
            self
        }
        /// An HTTP Live Streaming (HLS) ingest resource configuration.
        pub fn hls_ingest(mut self, input: crate::model::HlsIngest) -> Self {
            self.hls_ingest = Some(input);
            self
        }
        /// An HTTP Live Streaming (HLS) ingest resource configuration.
        pub fn set_hls_ingest(
            mut self,
            input: std::option::Option<crate::model::HlsIngest>,
        ) -> Self {
            self.hls_ingest = input;
            self
        }
        /// The ID of the Channel.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// The ID of the Channel.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Configure ingress access logging.
        pub fn ingress_access_logs(mut self, input: crate::model::IngressAccessLogs) -> Self {
            self.ingress_access_logs = Some(input);
            self
        }
        /// Configure ingress access logging.
        pub fn set_ingress_access_logs(
            mut self,
            input: std::option::Option<crate::model::IngressAccessLogs>,
        ) -> Self {
            self.ingress_access_logs = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of tags associated with a resource
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// A collection of tags associated with a resource
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ConfigureLogsOutput`](crate::output::ConfigureLogsOutput)
        pub fn build(self) -> crate::output::ConfigureLogsOutput {
            crate::output::ConfigureLogsOutput {
                arn: self.arn,
                description: self.description,
                egress_access_logs: self.egress_access_logs,
                hls_ingest: self.hls_ingest,
                id: self.id,
                ingress_access_logs: self.ingress_access_logs,
                tags: self.tags,
            }
        }
    }
}
impl ConfigureLogsOutput {
    /// Creates a new builder-style object to manufacture [`ConfigureLogsOutput`](crate::output::ConfigureLogsOutput)
    pub fn builder() -> crate::output::configure_logs_output::Builder {
        crate::output::configure_logs_output::Builder::default()
    }
}
