// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Origination {
    #[allow(missing_docs)] // documentation missing in model
    Allow,
    #[allow(missing_docs)] // documentation missing in model
    Deny,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Origination {
    fn from(s: &str) -> Self {
        match s {
            "ALLOW" => Origination::Allow,
            "DENY" => Origination::Deny,
            other => Origination::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Origination {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Origination::from(s))
    }
}
impl Origination {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Origination::Allow => "ALLOW",
            Origination::Deny => "DENY",
            Origination::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALLOW", "DENY"]
    }
}
impl AsRef<str> for Origination {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// A Microsoft Smooth Streaming (MSS) packaging configuration.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MssPackage {
    /// A Microsoft Smooth Streaming (MSS) encryption configuration.
    pub encryption: std::option::Option<crate::model::MssEncryption>,
    /// The time window (in seconds) contained in each manifest.
    pub manifest_window_seconds: i32,
    /// The duration (in seconds) of each segment.
    pub segment_duration_seconds: i32,
    /// A StreamSelection configuration.
    pub stream_selection: std::option::Option<crate::model::StreamSelection>,
}
impl std::fmt::Debug for MssPackage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MssPackage");
        formatter.field("encryption", &self.encryption);
        formatter.field("manifest_window_seconds", &self.manifest_window_seconds);
        formatter.field("segment_duration_seconds", &self.segment_duration_seconds);
        formatter.field("stream_selection", &self.stream_selection);
        formatter.finish()
    }
}
/// See [`MssPackage`](crate::model::MssPackage)
pub mod mss_package {
    /// A builder for [`MssPackage`](crate::model::MssPackage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) encryption: std::option::Option<crate::model::MssEncryption>,
        pub(crate) manifest_window_seconds: std::option::Option<i32>,
        pub(crate) segment_duration_seconds: std::option::Option<i32>,
        pub(crate) stream_selection: std::option::Option<crate::model::StreamSelection>,
    }
    impl Builder {
        /// A Microsoft Smooth Streaming (MSS) encryption configuration.
        pub fn encryption(mut self, input: crate::model::MssEncryption) -> Self {
            self.encryption = Some(input);
            self
        }
        /// A Microsoft Smooth Streaming (MSS) encryption configuration.
        pub fn set_encryption(
            mut self,
            input: std::option::Option<crate::model::MssEncryption>,
        ) -> Self {
            self.encryption = input;
            self
        }
        /// The time window (in seconds) contained in each manifest.
        pub fn manifest_window_seconds(mut self, input: i32) -> Self {
            self.manifest_window_seconds = Some(input);
            self
        }
        /// The time window (in seconds) contained in each manifest.
        pub fn set_manifest_window_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.manifest_window_seconds = input;
            self
        }
        /// The duration (in seconds) of each segment.
        pub fn segment_duration_seconds(mut self, input: i32) -> Self {
            self.segment_duration_seconds = Some(input);
            self
        }
        /// The duration (in seconds) of each segment.
        pub fn set_segment_duration_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.segment_duration_seconds = input;
            self
        }
        /// A StreamSelection configuration.
        pub fn stream_selection(mut self, input: crate::model::StreamSelection) -> Self {
            self.stream_selection = Some(input);
            self
        }
        /// A StreamSelection configuration.
        pub fn set_stream_selection(
            mut self,
            input: std::option::Option<crate::model::StreamSelection>,
        ) -> Self {
            self.stream_selection = input;
            self
        }
        /// Consumes the builder and constructs a [`MssPackage`](crate::model::MssPackage)
        pub fn build(self) -> crate::model::MssPackage {
            crate::model::MssPackage {
                encryption: self.encryption,
                manifest_window_seconds: self.manifest_window_seconds.unwrap_or_default(),
                segment_duration_seconds: self.segment_duration_seconds.unwrap_or_default(),
                stream_selection: self.stream_selection,
            }
        }
    }
}
impl MssPackage {
    /// Creates a new builder-style object to manufacture [`MssPackage`](crate::model::MssPackage)
    pub fn builder() -> crate::model::mss_package::Builder {
        crate::model::mss_package::Builder::default()
    }
}

/// A StreamSelection configuration.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StreamSelection {
    /// The maximum video bitrate (bps) to include in output.
    pub max_video_bits_per_second: i32,
    /// The minimum video bitrate (bps) to include in output.
    pub min_video_bits_per_second: i32,
    /// A directive that determines the order of streams in the output.
    pub stream_order: std::option::Option<crate::model::StreamOrder>,
}
impl std::fmt::Debug for StreamSelection {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StreamSelection");
        formatter.field("max_video_bits_per_second", &self.max_video_bits_per_second);
        formatter.field("min_video_bits_per_second", &self.min_video_bits_per_second);
        formatter.field("stream_order", &self.stream_order);
        formatter.finish()
    }
}
/// See [`StreamSelection`](crate::model::StreamSelection)
pub mod stream_selection {
    /// A builder for [`StreamSelection`](crate::model::StreamSelection)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_video_bits_per_second: std::option::Option<i32>,
        pub(crate) min_video_bits_per_second: std::option::Option<i32>,
        pub(crate) stream_order: std::option::Option<crate::model::StreamOrder>,
    }
    impl Builder {
        /// The maximum video bitrate (bps) to include in output.
        pub fn max_video_bits_per_second(mut self, input: i32) -> Self {
            self.max_video_bits_per_second = Some(input);
            self
        }
        /// The maximum video bitrate (bps) to include in output.
        pub fn set_max_video_bits_per_second(mut self, input: std::option::Option<i32>) -> Self {
            self.max_video_bits_per_second = input;
            self
        }
        /// The minimum video bitrate (bps) to include in output.
        pub fn min_video_bits_per_second(mut self, input: i32) -> Self {
            self.min_video_bits_per_second = Some(input);
            self
        }
        /// The minimum video bitrate (bps) to include in output.
        pub fn set_min_video_bits_per_second(mut self, input: std::option::Option<i32>) -> Self {
            self.min_video_bits_per_second = input;
            self
        }
        /// A directive that determines the order of streams in the output.
        pub fn stream_order(mut self, input: crate::model::StreamOrder) -> Self {
            self.stream_order = Some(input);
            self
        }
        /// A directive that determines the order of streams in the output.
        pub fn set_stream_order(
            mut self,
            input: std::option::Option<crate::model::StreamOrder>,
        ) -> Self {
            self.stream_order = input;
            self
        }
        /// Consumes the builder and constructs a [`StreamSelection`](crate::model::StreamSelection)
        pub fn build(self) -> crate::model::StreamSelection {
            crate::model::StreamSelection {
                max_video_bits_per_second: self.max_video_bits_per_second.unwrap_or_default(),
                min_video_bits_per_second: self.min_video_bits_per_second.unwrap_or_default(),
                stream_order: self.stream_order,
            }
        }
    }
}
impl StreamSelection {
    /// Creates a new builder-style object to manufacture [`StreamSelection`](crate::model::StreamSelection)
    pub fn builder() -> crate::model::stream_selection::Builder {
        crate::model::stream_selection::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StreamOrder {
    #[allow(missing_docs)] // documentation missing in model
    Original,
    #[allow(missing_docs)] // documentation missing in model
    VideoBitrateAscending,
    #[allow(missing_docs)] // documentation missing in model
    VideoBitrateDescending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StreamOrder {
    fn from(s: &str) -> Self {
        match s {
            "ORIGINAL" => StreamOrder::Original,
            "VIDEO_BITRATE_ASCENDING" => StreamOrder::VideoBitrateAscending,
            "VIDEO_BITRATE_DESCENDING" => StreamOrder::VideoBitrateDescending,
            other => StreamOrder::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StreamOrder {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StreamOrder::from(s))
    }
}
impl StreamOrder {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StreamOrder::Original => "ORIGINAL",
            StreamOrder::VideoBitrateAscending => "VIDEO_BITRATE_ASCENDING",
            StreamOrder::VideoBitrateDescending => "VIDEO_BITRATE_DESCENDING",
            StreamOrder::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ORIGINAL",
            "VIDEO_BITRATE_ASCENDING",
            "VIDEO_BITRATE_DESCENDING",
        ]
    }
}
impl AsRef<str> for StreamOrder {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// A Microsoft Smooth Streaming (MSS) encryption configuration.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MssEncryption {
    /// A configuration for accessing an external Secure Packager and Encoder Key Exchange (SPEKE) service that will provide encryption keys.
    pub speke_key_provider: std::option::Option<crate::model::SpekeKeyProvider>,
}
impl std::fmt::Debug for MssEncryption {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MssEncryption");
        formatter.field("speke_key_provider", &self.speke_key_provider);
        formatter.finish()
    }
}
/// See [`MssEncryption`](crate::model::MssEncryption)
pub mod mss_encryption {
    /// A builder for [`MssEncryption`](crate::model::MssEncryption)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) speke_key_provider: std::option::Option<crate::model::SpekeKeyProvider>,
    }
    impl Builder {
        /// A configuration for accessing an external Secure Packager and Encoder Key Exchange (SPEKE) service that will provide encryption keys.
        pub fn speke_key_provider(mut self, input: crate::model::SpekeKeyProvider) -> Self {
            self.speke_key_provider = Some(input);
            self
        }
        /// A configuration for accessing an external Secure Packager and Encoder Key Exchange (SPEKE) service that will provide encryption keys.
        pub fn set_speke_key_provider(
            mut self,
            input: std::option::Option<crate::model::SpekeKeyProvider>,
        ) -> Self {
            self.speke_key_provider = input;
            self
        }
        /// Consumes the builder and constructs a [`MssEncryption`](crate::model::MssEncryption)
        pub fn build(self) -> crate::model::MssEncryption {
            crate::model::MssEncryption {
                speke_key_provider: self.speke_key_provider,
            }
        }
    }
}
impl MssEncryption {
    /// Creates a new builder-style object to manufacture [`MssEncryption`](crate::model::MssEncryption)
    pub fn builder() -> crate::model::mss_encryption::Builder {
        crate::model::mss_encryption::Builder::default()
    }
}

/// A configuration for accessing an external Secure Packager and Encoder Key Exchange (SPEKE) service that will provide encryption keys.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SpekeKeyProvider {
    /// An Amazon Resource Name (ARN) of a Certificate Manager certificate
    /// that MediaPackage will use for enforcing secure end-to-end data
    /// transfer with the key provider service.
    pub certificate_arn: std::option::Option<std::string::String>,
    /// Use encryptionContractConfiguration to configure one or more content encryption keys for your endpoints that use SPEKE 2.0.
    /// The encryption contract defines which content keys are used to encrypt the audio and video tracks in your stream.
    /// To configure the encryption contract, specify which audio and video encryption presets to use.
    /// Note the following considerations when using encryptionContractConfiguration:
    /// encryptionContractConfiguration can be used for DASH or CMAF endpoints that use SPEKE 2.0. SPEKE 2.0 relies on the CPIX 2.3 specification.
    /// You must disable key rotation for this endpoint by setting keyRotationIntervalSeconds to 0.
    pub encryption_contract_configuration:
        std::option::Option<crate::model::EncryptionContractConfiguration>,
    /// The resource ID to include in key requests.
    pub resource_id: std::option::Option<std::string::String>,
    /// An Amazon Resource Name (ARN) of an IAM role that AWS Elemental
    /// MediaPackage will assume when accessing the key provider service.
    pub role_arn: std::option::Option<std::string::String>,
    /// The system IDs to include in key requests.
    pub system_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// The URL of the external key provider service.
    pub url: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SpekeKeyProvider {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SpekeKeyProvider");
        formatter.field("certificate_arn", &self.certificate_arn);
        formatter.field(
            "encryption_contract_configuration",
            &self.encryption_contract_configuration,
        );
        formatter.field("resource_id", &self.resource_id);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("system_ids", &self.system_ids);
        formatter.field("url", &self.url);
        formatter.finish()
    }
}
/// See [`SpekeKeyProvider`](crate::model::SpekeKeyProvider)
pub mod speke_key_provider {
    /// A builder for [`SpekeKeyProvider`](crate::model::SpekeKeyProvider)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_arn: std::option::Option<std::string::String>,
        pub(crate) encryption_contract_configuration:
            std::option::Option<crate::model::EncryptionContractConfiguration>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) system_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// An Amazon Resource Name (ARN) of a Certificate Manager certificate
        /// that MediaPackage will use for enforcing secure end-to-end data
        /// transfer with the key provider service.
        pub fn certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_arn = Some(input.into());
            self
        }
        /// An Amazon Resource Name (ARN) of a Certificate Manager certificate
        /// that MediaPackage will use for enforcing secure end-to-end data
        /// transfer with the key provider service.
        pub fn set_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_arn = input;
            self
        }
        /// Use encryptionContractConfiguration to configure one or more content encryption keys for your endpoints that use SPEKE 2.0.
        /// The encryption contract defines which content keys are used to encrypt the audio and video tracks in your stream.
        /// To configure the encryption contract, specify which audio and video encryption presets to use.
        /// Note the following considerations when using encryptionContractConfiguration:
        /// encryptionContractConfiguration can be used for DASH or CMAF endpoints that use SPEKE 2.0. SPEKE 2.0 relies on the CPIX 2.3 specification.
        /// You must disable key rotation for this endpoint by setting keyRotationIntervalSeconds to 0.
        pub fn encryption_contract_configuration(
            mut self,
            input: crate::model::EncryptionContractConfiguration,
        ) -> Self {
            self.encryption_contract_configuration = Some(input);
            self
        }
        /// Use encryptionContractConfiguration to configure one or more content encryption keys for your endpoints that use SPEKE 2.0.
        /// The encryption contract defines which content keys are used to encrypt the audio and video tracks in your stream.
        /// To configure the encryption contract, specify which audio and video encryption presets to use.
        /// Note the following considerations when using encryptionContractConfiguration:
        /// encryptionContractConfiguration can be used for DASH or CMAF endpoints that use SPEKE 2.0. SPEKE 2.0 relies on the CPIX 2.3 specification.
        /// You must disable key rotation for this endpoint by setting keyRotationIntervalSeconds to 0.
        pub fn set_encryption_contract_configuration(
            mut self,
            input: std::option::Option<crate::model::EncryptionContractConfiguration>,
        ) -> Self {
            self.encryption_contract_configuration = input;
            self
        }
        /// The resource ID to include in key requests.
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// The resource ID to include in key requests.
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// An Amazon Resource Name (ARN) of an IAM role that AWS Elemental
        /// MediaPackage will assume when accessing the key provider service.
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// An Amazon Resource Name (ARN) of an IAM role that AWS Elemental
        /// MediaPackage will assume when accessing the key provider service.
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Appends an item to `system_ids`.
        ///
        /// To override the contents of this collection use [`set_system_ids`](Self::set_system_ids).
        ///
        /// The system IDs to include in key requests.
        pub fn system_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.system_ids.unwrap_or_default();
            v.push(input.into());
            self.system_ids = Some(v);
            self
        }
        /// The system IDs to include in key requests.
        pub fn set_system_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.system_ids = input;
            self
        }
        /// The URL of the external key provider service.
        pub fn url(mut self, input: impl Into<std::string::String>) -> Self {
            self.url = Some(input.into());
            self
        }
        /// The URL of the external key provider service.
        pub fn set_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.url = input;
            self
        }
        /// Consumes the builder and constructs a [`SpekeKeyProvider`](crate::model::SpekeKeyProvider)
        pub fn build(self) -> crate::model::SpekeKeyProvider {
            crate::model::SpekeKeyProvider {
                certificate_arn: self.certificate_arn,
                encryption_contract_configuration: self.encryption_contract_configuration,
                resource_id: self.resource_id,
                role_arn: self.role_arn,
                system_ids: self.system_ids,
                url: self.url,
            }
        }
    }
}
impl SpekeKeyProvider {
    /// Creates a new builder-style object to manufacture [`SpekeKeyProvider`](crate::model::SpekeKeyProvider)
    pub fn builder() -> crate::model::speke_key_provider::Builder {
        crate::model::speke_key_provider::Builder::default()
    }
}

/// Use encryptionContractConfiguration to configure one or more content encryption keys for your endpoints that use SPEKE 2.0.
/// The encryption contract defines which content keys are used to encrypt the audio and video tracks in your stream.
/// To configure the encryption contract, specify which audio and video encryption presets to use.
/// Note the following considerations when using encryptionContractConfiguration:
/// encryptionContractConfiguration can be used for DASH or CMAF endpoints that use SPEKE 2.0. SPEKE 2.0 relies on the CPIX 2.3 specification.
/// You must disable key rotation for this endpoint by setting keyRotationIntervalSeconds to 0.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EncryptionContractConfiguration {
    /// A collection of audio encryption presets.
    pub preset_speke20_audio: std::option::Option<crate::model::PresetSpeke20Audio>,
    /// A collection of video encryption presets.
    pub preset_speke20_video: std::option::Option<crate::model::PresetSpeke20Video>,
}
impl std::fmt::Debug for EncryptionContractConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EncryptionContractConfiguration");
        formatter.field("preset_speke20_audio", &self.preset_speke20_audio);
        formatter.field("preset_speke20_video", &self.preset_speke20_video);
        formatter.finish()
    }
}
/// See [`EncryptionContractConfiguration`](crate::model::EncryptionContractConfiguration)
pub mod encryption_contract_configuration {
    /// A builder for [`EncryptionContractConfiguration`](crate::model::EncryptionContractConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) preset_speke20_audio: std::option::Option<crate::model::PresetSpeke20Audio>,
        pub(crate) preset_speke20_video: std::option::Option<crate::model::PresetSpeke20Video>,
    }
    impl Builder {
        /// A collection of audio encryption presets.
        pub fn preset_speke20_audio(mut self, input: crate::model::PresetSpeke20Audio) -> Self {
            self.preset_speke20_audio = Some(input);
            self
        }
        /// A collection of audio encryption presets.
        pub fn set_preset_speke20_audio(
            mut self,
            input: std::option::Option<crate::model::PresetSpeke20Audio>,
        ) -> Self {
            self.preset_speke20_audio = input;
            self
        }
        /// A collection of video encryption presets.
        pub fn preset_speke20_video(mut self, input: crate::model::PresetSpeke20Video) -> Self {
            self.preset_speke20_video = Some(input);
            self
        }
        /// A collection of video encryption presets.
        pub fn set_preset_speke20_video(
            mut self,
            input: std::option::Option<crate::model::PresetSpeke20Video>,
        ) -> Self {
            self.preset_speke20_video = input;
            self
        }
        /// Consumes the builder and constructs a [`EncryptionContractConfiguration`](crate::model::EncryptionContractConfiguration)
        pub fn build(self) -> crate::model::EncryptionContractConfiguration {
            crate::model::EncryptionContractConfiguration {
                preset_speke20_audio: self.preset_speke20_audio,
                preset_speke20_video: self.preset_speke20_video,
            }
        }
    }
}
impl EncryptionContractConfiguration {
    /// Creates a new builder-style object to manufacture [`EncryptionContractConfiguration`](crate::model::EncryptionContractConfiguration)
    pub fn builder() -> crate::model::encryption_contract_configuration::Builder {
        crate::model::encryption_contract_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PresetSpeke20Video {
    #[allow(missing_docs)] // documentation missing in model
    PresetVideo1,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PresetSpeke20Video {
    fn from(s: &str) -> Self {
        match s {
            "PRESET-VIDEO-1" => PresetSpeke20Video::PresetVideo1,
            other => PresetSpeke20Video::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PresetSpeke20Video {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PresetSpeke20Video::from(s))
    }
}
impl PresetSpeke20Video {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PresetSpeke20Video::PresetVideo1 => "PRESET-VIDEO-1",
            PresetSpeke20Video::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PRESET-VIDEO-1"]
    }
}
impl AsRef<str> for PresetSpeke20Video {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PresetSpeke20Audio {
    #[allow(missing_docs)] // documentation missing in model
    PresetAudio1,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PresetSpeke20Audio {
    fn from(s: &str) -> Self {
        match s {
            "PRESET-AUDIO-1" => PresetSpeke20Audio::PresetAudio1,
            other => PresetSpeke20Audio::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PresetSpeke20Audio {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PresetSpeke20Audio::from(s))
    }
}
impl PresetSpeke20Audio {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PresetSpeke20Audio::PresetAudio1 => "PRESET-AUDIO-1",
            PresetSpeke20Audio::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PRESET-AUDIO-1"]
    }
}
impl AsRef<str> for PresetSpeke20Audio {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// An HTTP Live Streaming (HLS) packaging configuration.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HlsPackage {
    /// This setting controls how ad markers are included in the packaged OriginEndpoint.
    /// "NONE" will omit all SCTE-35 ad markers from the output.
    /// "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35 ad
    /// markers (comments) taken directly from the input HTTP Live Streaming (HLS) manifest.
    /// "SCTE35_ENHANCED" generates ad markers and blackout tags based on SCTE-35
    /// messages in the input source.
    /// "DATERANGE" inserts EXT-X-DATERANGE tags to signal ad and program transition events
    /// in HLS and CMAF manifests. For this option, you must set a programDateTimeIntervalSeconds value
    /// that is greater than 0.
    pub ad_markers: std::option::Option<crate::model::AdMarkers>,
    /// A list of SCTE-35 message types that are treated as ad markers in the output.  If empty, no
    /// ad markers are output.  Specify multiple items to create ad markers for all of the included
    /// message types.
    pub ad_triggers: std::option::Option<std::vec::Vec<crate::model::AdTriggersElement>>,
    /// This setting allows the delivery restriction flags on SCTE-35 segmentation descriptors to
    /// determine whether a message signals an ad.  Choosing "NONE" means no SCTE-35 messages become
    /// ads.  Choosing "RESTRICTED" means SCTE-35 messages of the types specified in AdTriggers that
    /// contain delivery restrictions will be treated as ads.  Choosing "UNRESTRICTED" means SCTE-35
    /// messages of the types specified in AdTriggers that do not contain delivery restrictions will
    /// be treated as ads.  Choosing "BOTH" means all SCTE-35 messages of the types specified in
    /// AdTriggers will be treated as ads.  Note that Splice Insert messages do not have these flags
    /// and are always treated as ads if specified in AdTriggers.
    pub ads_on_delivery_restrictions: std::option::Option<crate::model::AdsOnDeliveryRestrictions>,
    /// An HTTP Live Streaming (HLS) encryption configuration.
    pub encryption: std::option::Option<crate::model::HlsEncryption>,
    /// When enabled, an I-Frame only stream will be included in the output.
    pub include_iframe_only_stream: bool,
    /// The HTTP Live Streaming (HLS) playlist type.
    /// When either "EVENT" or "VOD" is specified, a corresponding EXT-X-PLAYLIST-TYPE
    /// entry will be included in the media playlist.
    pub playlist_type: std::option::Option<crate::model::PlaylistType>,
    /// Time window (in seconds) contained in each parent manifest.
    pub playlist_window_seconds: i32,
    /// The interval (in seconds) between each EXT-X-PROGRAM-DATE-TIME tag
    /// inserted into manifests. Additionally, when an interval is specified
    /// ID3Timed Metadata messages will be generated every 5 seconds using the
    /// ingest time of the content.
    /// If the interval is not specified, or set to 0, then
    /// no EXT-X-PROGRAM-DATE-TIME tags will be inserted into manifests and no
    /// ID3Timed Metadata messages will be generated. Note that irrespective
    /// of this parameter, if any ID3 Timed Metadata is found in HTTP Live Streaming (HLS) input,
    /// it will be passed through to HLS output.
    pub program_date_time_interval_seconds: i32,
    /// Duration (in seconds) of each fragment. Actual fragments will be
    /// rounded to the nearest multiple of the source fragment duration.
    pub segment_duration_seconds: i32,
    /// A StreamSelection configuration.
    pub stream_selection: std::option::Option<crate::model::StreamSelection>,
    /// When enabled, audio streams will be placed in rendition groups in the output.
    pub use_audio_rendition_group: bool,
}
impl std::fmt::Debug for HlsPackage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HlsPackage");
        formatter.field("ad_markers", &self.ad_markers);
        formatter.field("ad_triggers", &self.ad_triggers);
        formatter.field(
            "ads_on_delivery_restrictions",
            &self.ads_on_delivery_restrictions,
        );
        formatter.field("encryption", &self.encryption);
        formatter.field(
            "include_iframe_only_stream",
            &self.include_iframe_only_stream,
        );
        formatter.field("playlist_type", &self.playlist_type);
        formatter.field("playlist_window_seconds", &self.playlist_window_seconds);
        formatter.field(
            "program_date_time_interval_seconds",
            &self.program_date_time_interval_seconds,
        );
        formatter.field("segment_duration_seconds", &self.segment_duration_seconds);
        formatter.field("stream_selection", &self.stream_selection);
        formatter.field("use_audio_rendition_group", &self.use_audio_rendition_group);
        formatter.finish()
    }
}
/// See [`HlsPackage`](crate::model::HlsPackage)
pub mod hls_package {
    /// A builder for [`HlsPackage`](crate::model::HlsPackage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ad_markers: std::option::Option<crate::model::AdMarkers>,
        pub(crate) ad_triggers: std::option::Option<std::vec::Vec<crate::model::AdTriggersElement>>,
        pub(crate) ads_on_delivery_restrictions:
            std::option::Option<crate::model::AdsOnDeliveryRestrictions>,
        pub(crate) encryption: std::option::Option<crate::model::HlsEncryption>,
        pub(crate) include_iframe_only_stream: std::option::Option<bool>,
        pub(crate) playlist_type: std::option::Option<crate::model::PlaylistType>,
        pub(crate) playlist_window_seconds: std::option::Option<i32>,
        pub(crate) program_date_time_interval_seconds: std::option::Option<i32>,
        pub(crate) segment_duration_seconds: std::option::Option<i32>,
        pub(crate) stream_selection: std::option::Option<crate::model::StreamSelection>,
        pub(crate) use_audio_rendition_group: std::option::Option<bool>,
    }
    impl Builder {
        /// This setting controls how ad markers are included in the packaged OriginEndpoint.
        /// "NONE" will omit all SCTE-35 ad markers from the output.
        /// "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35 ad
        /// markers (comments) taken directly from the input HTTP Live Streaming (HLS) manifest.
        /// "SCTE35_ENHANCED" generates ad markers and blackout tags based on SCTE-35
        /// messages in the input source.
        /// "DATERANGE" inserts EXT-X-DATERANGE tags to signal ad and program transition events
        /// in HLS and CMAF manifests. For this option, you must set a programDateTimeIntervalSeconds value
        /// that is greater than 0.
        pub fn ad_markers(mut self, input: crate::model::AdMarkers) -> Self {
            self.ad_markers = Some(input);
            self
        }
        /// This setting controls how ad markers are included in the packaged OriginEndpoint.
        /// "NONE" will omit all SCTE-35 ad markers from the output.
        /// "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35 ad
        /// markers (comments) taken directly from the input HTTP Live Streaming (HLS) manifest.
        /// "SCTE35_ENHANCED" generates ad markers and blackout tags based on SCTE-35
        /// messages in the input source.
        /// "DATERANGE" inserts EXT-X-DATERANGE tags to signal ad and program transition events
        /// in HLS and CMAF manifests. For this option, you must set a programDateTimeIntervalSeconds value
        /// that is greater than 0.
        pub fn set_ad_markers(
            mut self,
            input: std::option::Option<crate::model::AdMarkers>,
        ) -> Self {
            self.ad_markers = input;
            self
        }
        /// Appends an item to `ad_triggers`.
        ///
        /// To override the contents of this collection use [`set_ad_triggers`](Self::set_ad_triggers).
        ///
        /// A list of SCTE-35 message types that are treated as ad markers in the output.  If empty, no
        /// ad markers are output.  Specify multiple items to create ad markers for all of the included
        /// message types.
        pub fn ad_triggers(mut self, input: impl Into<crate::model::AdTriggersElement>) -> Self {
            let mut v = self.ad_triggers.unwrap_or_default();
            v.push(input.into());
            self.ad_triggers = Some(v);
            self
        }
        /// A list of SCTE-35 message types that are treated as ad markers in the output.  If empty, no
        /// ad markers are output.  Specify multiple items to create ad markers for all of the included
        /// message types.
        pub fn set_ad_triggers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AdTriggersElement>>,
        ) -> Self {
            self.ad_triggers = input;
            self
        }
        /// This setting allows the delivery restriction flags on SCTE-35 segmentation descriptors to
        /// determine whether a message signals an ad.  Choosing "NONE" means no SCTE-35 messages become
        /// ads.  Choosing "RESTRICTED" means SCTE-35 messages of the types specified in AdTriggers that
        /// contain delivery restrictions will be treated as ads.  Choosing "UNRESTRICTED" means SCTE-35
        /// messages of the types specified in AdTriggers that do not contain delivery restrictions will
        /// be treated as ads.  Choosing "BOTH" means all SCTE-35 messages of the types specified in
        /// AdTriggers will be treated as ads.  Note that Splice Insert messages do not have these flags
        /// and are always treated as ads if specified in AdTriggers.
        pub fn ads_on_delivery_restrictions(
            mut self,
            input: crate::model::AdsOnDeliveryRestrictions,
        ) -> Self {
            self.ads_on_delivery_restrictions = Some(input);
            self
        }
        /// This setting allows the delivery restriction flags on SCTE-35 segmentation descriptors to
        /// determine whether a message signals an ad.  Choosing "NONE" means no SCTE-35 messages become
        /// ads.  Choosing "RESTRICTED" means SCTE-35 messages of the types specified in AdTriggers that
        /// contain delivery restrictions will be treated as ads.  Choosing "UNRESTRICTED" means SCTE-35
        /// messages of the types specified in AdTriggers that do not contain delivery restrictions will
        /// be treated as ads.  Choosing "BOTH" means all SCTE-35 messages of the types specified in
        /// AdTriggers will be treated as ads.  Note that Splice Insert messages do not have these flags
        /// and are always treated as ads if specified in AdTriggers.
        pub fn set_ads_on_delivery_restrictions(
            mut self,
            input: std::option::Option<crate::model::AdsOnDeliveryRestrictions>,
        ) -> Self {
            self.ads_on_delivery_restrictions = input;
            self
        }
        /// An HTTP Live Streaming (HLS) encryption configuration.
        pub fn encryption(mut self, input: crate::model::HlsEncryption) -> Self {
            self.encryption = Some(input);
            self
        }
        /// An HTTP Live Streaming (HLS) encryption configuration.
        pub fn set_encryption(
            mut self,
            input: std::option::Option<crate::model::HlsEncryption>,
        ) -> Self {
            self.encryption = input;
            self
        }
        /// When enabled, an I-Frame only stream will be included in the output.
        pub fn include_iframe_only_stream(mut self, input: bool) -> Self {
            self.include_iframe_only_stream = Some(input);
            self
        }
        /// When enabled, an I-Frame only stream will be included in the output.
        pub fn set_include_iframe_only_stream(mut self, input: std::option::Option<bool>) -> Self {
            self.include_iframe_only_stream = input;
            self
        }
        /// The HTTP Live Streaming (HLS) playlist type.
        /// When either "EVENT" or "VOD" is specified, a corresponding EXT-X-PLAYLIST-TYPE
        /// entry will be included in the media playlist.
        pub fn playlist_type(mut self, input: crate::model::PlaylistType) -> Self {
            self.playlist_type = Some(input);
            self
        }
        /// The HTTP Live Streaming (HLS) playlist type.
        /// When either "EVENT" or "VOD" is specified, a corresponding EXT-X-PLAYLIST-TYPE
        /// entry will be included in the media playlist.
        pub fn set_playlist_type(
            mut self,
            input: std::option::Option<crate::model::PlaylistType>,
        ) -> Self {
            self.playlist_type = input;
            self
        }
        /// Time window (in seconds) contained in each parent manifest.
        pub fn playlist_window_seconds(mut self, input: i32) -> Self {
            self.playlist_window_seconds = Some(input);
            self
        }
        /// Time window (in seconds) contained in each parent manifest.
        pub fn set_playlist_window_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.playlist_window_seconds = input;
            self
        }
        /// The interval (in seconds) between each EXT-X-PROGRAM-DATE-TIME tag
        /// inserted into manifests. Additionally, when an interval is specified
        /// ID3Timed Metadata messages will be generated every 5 seconds using the
        /// ingest time of the content.
        /// If the interval is not specified, or set to 0, then
        /// no EXT-X-PROGRAM-DATE-TIME tags will be inserted into manifests and no
        /// ID3Timed Metadata messages will be generated. Note that irrespective
        /// of this parameter, if any ID3 Timed Metadata is found in HTTP Live Streaming (HLS) input,
        /// it will be passed through to HLS output.
        pub fn program_date_time_interval_seconds(mut self, input: i32) -> Self {
            self.program_date_time_interval_seconds = Some(input);
            self
        }
        /// The interval (in seconds) between each EXT-X-PROGRAM-DATE-TIME tag
        /// inserted into manifests. Additionally, when an interval is specified
        /// ID3Timed Metadata messages will be generated every 5 seconds using the
        /// ingest time of the content.
        /// If the interval is not specified, or set to 0, then
        /// no EXT-X-PROGRAM-DATE-TIME tags will be inserted into manifests and no
        /// ID3Timed Metadata messages will be generated. Note that irrespective
        /// of this parameter, if any ID3 Timed Metadata is found in HTTP Live Streaming (HLS) input,
        /// it will be passed through to HLS output.
        pub fn set_program_date_time_interval_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.program_date_time_interval_seconds = input;
            self
        }
        /// Duration (in seconds) of each fragment. Actual fragments will be
        /// rounded to the nearest multiple of the source fragment duration.
        pub fn segment_duration_seconds(mut self, input: i32) -> Self {
            self.segment_duration_seconds = Some(input);
            self
        }
        /// Duration (in seconds) of each fragment. Actual fragments will be
        /// rounded to the nearest multiple of the source fragment duration.
        pub fn set_segment_duration_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.segment_duration_seconds = input;
            self
        }
        /// A StreamSelection configuration.
        pub fn stream_selection(mut self, input: crate::model::StreamSelection) -> Self {
            self.stream_selection = Some(input);
            self
        }
        /// A StreamSelection configuration.
        pub fn set_stream_selection(
            mut self,
            input: std::option::Option<crate::model::StreamSelection>,
        ) -> Self {
            self.stream_selection = input;
            self
        }
        /// When enabled, audio streams will be placed in rendition groups in the output.
        pub fn use_audio_rendition_group(mut self, input: bool) -> Self {
            self.use_audio_rendition_group = Some(input);
            self
        }
        /// When enabled, audio streams will be placed in rendition groups in the output.
        pub fn set_use_audio_rendition_group(mut self, input: std::option::Option<bool>) -> Self {
            self.use_audio_rendition_group = input;
            self
        }
        /// Consumes the builder and constructs a [`HlsPackage`](crate::model::HlsPackage)
        pub fn build(self) -> crate::model::HlsPackage {
            crate::model::HlsPackage {
                ad_markers: self.ad_markers,
                ad_triggers: self.ad_triggers,
                ads_on_delivery_restrictions: self.ads_on_delivery_restrictions,
                encryption: self.encryption,
                include_iframe_only_stream: self.include_iframe_only_stream.unwrap_or_default(),
                playlist_type: self.playlist_type,
                playlist_window_seconds: self.playlist_window_seconds.unwrap_or_default(),
                program_date_time_interval_seconds: self
                    .program_date_time_interval_seconds
                    .unwrap_or_default(),
                segment_duration_seconds: self.segment_duration_seconds.unwrap_or_default(),
                stream_selection: self.stream_selection,
                use_audio_rendition_group: self.use_audio_rendition_group.unwrap_or_default(),
            }
        }
    }
}
impl HlsPackage {
    /// Creates a new builder-style object to manufacture [`HlsPackage`](crate::model::HlsPackage)
    pub fn builder() -> crate::model::hls_package::Builder {
        crate::model::hls_package::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PlaylistType {
    #[allow(missing_docs)] // documentation missing in model
    Event,
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    Vod,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PlaylistType {
    fn from(s: &str) -> Self {
        match s {
            "EVENT" => PlaylistType::Event,
            "NONE" => PlaylistType::None,
            "VOD" => PlaylistType::Vod,
            other => PlaylistType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PlaylistType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PlaylistType::from(s))
    }
}
impl PlaylistType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PlaylistType::Event => "EVENT",
            PlaylistType::None => "NONE",
            PlaylistType::Vod => "VOD",
            PlaylistType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["EVENT", "NONE", "VOD"]
    }
}
impl AsRef<str> for PlaylistType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// An HTTP Live Streaming (HLS) encryption configuration.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HlsEncryption {
    /// A constant initialization vector for encryption (optional).
    /// When not specified the initialization vector will be periodically rotated.
    pub constant_initialization_vector: std::option::Option<std::string::String>,
    /// The encryption method to use.
    pub encryption_method: std::option::Option<crate::model::EncryptionMethod>,
    /// Interval (in seconds) between each encryption key rotation.
    pub key_rotation_interval_seconds: i32,
    /// When enabled, the EXT-X-KEY tag will be repeated in output manifests.
    pub repeat_ext_x_key: bool,
    /// A configuration for accessing an external Secure Packager and Encoder Key Exchange (SPEKE) service that will provide encryption keys.
    pub speke_key_provider: std::option::Option<crate::model::SpekeKeyProvider>,
}
impl std::fmt::Debug for HlsEncryption {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HlsEncryption");
        formatter.field(
            "constant_initialization_vector",
            &self.constant_initialization_vector,
        );
        formatter.field("encryption_method", &self.encryption_method);
        formatter.field(
            "key_rotation_interval_seconds",
            &self.key_rotation_interval_seconds,
        );
        formatter.field("repeat_ext_x_key", &self.repeat_ext_x_key);
        formatter.field("speke_key_provider", &self.speke_key_provider);
        formatter.finish()
    }
}
/// See [`HlsEncryption`](crate::model::HlsEncryption)
pub mod hls_encryption {
    /// A builder for [`HlsEncryption`](crate::model::HlsEncryption)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) constant_initialization_vector: std::option::Option<std::string::String>,
        pub(crate) encryption_method: std::option::Option<crate::model::EncryptionMethod>,
        pub(crate) key_rotation_interval_seconds: std::option::Option<i32>,
        pub(crate) repeat_ext_x_key: std::option::Option<bool>,
        pub(crate) speke_key_provider: std::option::Option<crate::model::SpekeKeyProvider>,
    }
    impl Builder {
        /// A constant initialization vector for encryption (optional).
        /// When not specified the initialization vector will be periodically rotated.
        pub fn constant_initialization_vector(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.constant_initialization_vector = Some(input.into());
            self
        }
        /// A constant initialization vector for encryption (optional).
        /// When not specified the initialization vector will be periodically rotated.
        pub fn set_constant_initialization_vector(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.constant_initialization_vector = input;
            self
        }
        /// The encryption method to use.
        pub fn encryption_method(mut self, input: crate::model::EncryptionMethod) -> Self {
            self.encryption_method = Some(input);
            self
        }
        /// The encryption method to use.
        pub fn set_encryption_method(
            mut self,
            input: std::option::Option<crate::model::EncryptionMethod>,
        ) -> Self {
            self.encryption_method = input;
            self
        }
        /// Interval (in seconds) between each encryption key rotation.
        pub fn key_rotation_interval_seconds(mut self, input: i32) -> Self {
            self.key_rotation_interval_seconds = Some(input);
            self
        }
        /// Interval (in seconds) between each encryption key rotation.
        pub fn set_key_rotation_interval_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.key_rotation_interval_seconds = input;
            self
        }
        /// When enabled, the EXT-X-KEY tag will be repeated in output manifests.
        pub fn repeat_ext_x_key(mut self, input: bool) -> Self {
            self.repeat_ext_x_key = Some(input);
            self
        }
        /// When enabled, the EXT-X-KEY tag will be repeated in output manifests.
        pub fn set_repeat_ext_x_key(mut self, input: std::option::Option<bool>) -> Self {
            self.repeat_ext_x_key = input;
            self
        }
        /// A configuration for accessing an external Secure Packager and Encoder Key Exchange (SPEKE) service that will provide encryption keys.
        pub fn speke_key_provider(mut self, input: crate::model::SpekeKeyProvider) -> Self {
            self.speke_key_provider = Some(input);
            self
        }
        /// A configuration for accessing an external Secure Packager and Encoder Key Exchange (SPEKE) service that will provide encryption keys.
        pub fn set_speke_key_provider(
            mut self,
            input: std::option::Option<crate::model::SpekeKeyProvider>,
        ) -> Self {
            self.speke_key_provider = input;
            self
        }
        /// Consumes the builder and constructs a [`HlsEncryption`](crate::model::HlsEncryption)
        pub fn build(self) -> crate::model::HlsEncryption {
            crate::model::HlsEncryption {
                constant_initialization_vector: self.constant_initialization_vector,
                encryption_method: self.encryption_method,
                key_rotation_interval_seconds: self
                    .key_rotation_interval_seconds
                    .unwrap_or_default(),
                repeat_ext_x_key: self.repeat_ext_x_key.unwrap_or_default(),
                speke_key_provider: self.speke_key_provider,
            }
        }
    }
}
impl HlsEncryption {
    /// Creates a new builder-style object to manufacture [`HlsEncryption`](crate::model::HlsEncryption)
    pub fn builder() -> crate::model::hls_encryption::Builder {
        crate::model::hls_encryption::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EncryptionMethod {
    #[allow(missing_docs)] // documentation missing in model
    Aes128,
    #[allow(missing_docs)] // documentation missing in model
    SampleAes,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EncryptionMethod {
    fn from(s: &str) -> Self {
        match s {
            "AES_128" => EncryptionMethod::Aes128,
            "SAMPLE_AES" => EncryptionMethod::SampleAes,
            other => EncryptionMethod::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EncryptionMethod {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EncryptionMethod::from(s))
    }
}
impl EncryptionMethod {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EncryptionMethod::Aes128 => "AES_128",
            EncryptionMethod::SampleAes => "SAMPLE_AES",
            EncryptionMethod::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AES_128", "SAMPLE_AES"]
    }
}
impl AsRef<str> for EncryptionMethod {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// This setting allows the delivery restriction flags on SCTE-35 segmentation descriptors to
/// determine whether a message signals an ad.  Choosing "NONE" means no SCTE-35 messages become
/// ads.  Choosing "RESTRICTED" means SCTE-35 messages of the types specified in AdTriggers that
/// contain delivery restrictions will be treated as ads.  Choosing "UNRESTRICTED" means SCTE-35
/// messages of the types specified in AdTriggers that do not contain delivery restrictions will
/// be treated as ads.  Choosing "BOTH" means all SCTE-35 messages of the types specified in
/// AdTriggers will be treated as ads.  Note that Splice Insert messages do not have these flags
/// and are always treated as ads if specified in AdTriggers.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AdsOnDeliveryRestrictions {
    #[allow(missing_docs)] // documentation missing in model
    Both,
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    Restricted,
    #[allow(missing_docs)] // documentation missing in model
    Unrestricted,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AdsOnDeliveryRestrictions {
    fn from(s: &str) -> Self {
        match s {
            "BOTH" => AdsOnDeliveryRestrictions::Both,
            "NONE" => AdsOnDeliveryRestrictions::None,
            "RESTRICTED" => AdsOnDeliveryRestrictions::Restricted,
            "UNRESTRICTED" => AdsOnDeliveryRestrictions::Unrestricted,
            other => AdsOnDeliveryRestrictions::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AdsOnDeliveryRestrictions {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AdsOnDeliveryRestrictions::from(s))
    }
}
impl AdsOnDeliveryRestrictions {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AdsOnDeliveryRestrictions::Both => "BOTH",
            AdsOnDeliveryRestrictions::None => "NONE",
            AdsOnDeliveryRestrictions::Restricted => "RESTRICTED",
            AdsOnDeliveryRestrictions::Unrestricted => "UNRESTRICTED",
            AdsOnDeliveryRestrictions::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["BOTH", "NONE", "RESTRICTED", "UNRESTRICTED"]
    }
}
impl AsRef<str> for AdsOnDeliveryRestrictions {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AdTriggersElement {
    #[allow(missing_docs)] // documentation missing in model
    Break,
    #[allow(missing_docs)] // documentation missing in model
    DistributorAdvertisement,
    #[allow(missing_docs)] // documentation missing in model
    DistributorOverlayPlacementOpportunity,
    #[allow(missing_docs)] // documentation missing in model
    DistributorPlacementOpportunity,
    #[allow(missing_docs)] // documentation missing in model
    ProviderAdvertisement,
    #[allow(missing_docs)] // documentation missing in model
    ProviderOverlayPlacementOpportunity,
    #[allow(missing_docs)] // documentation missing in model
    ProviderPlacementOpportunity,
    #[allow(missing_docs)] // documentation missing in model
    SpliceInsert,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AdTriggersElement {
    fn from(s: &str) -> Self {
        match s {
            "BREAK" => AdTriggersElement::Break,
            "DISTRIBUTOR_ADVERTISEMENT" => AdTriggersElement::DistributorAdvertisement,
            "DISTRIBUTOR_OVERLAY_PLACEMENT_OPPORTUNITY" => {
                AdTriggersElement::DistributorOverlayPlacementOpportunity
            }
            "DISTRIBUTOR_PLACEMENT_OPPORTUNITY" => {
                AdTriggersElement::DistributorPlacementOpportunity
            }
            "PROVIDER_ADVERTISEMENT" => AdTriggersElement::ProviderAdvertisement,
            "PROVIDER_OVERLAY_PLACEMENT_OPPORTUNITY" => {
                AdTriggersElement::ProviderOverlayPlacementOpportunity
            }
            "PROVIDER_PLACEMENT_OPPORTUNITY" => AdTriggersElement::ProviderPlacementOpportunity,
            "SPLICE_INSERT" => AdTriggersElement::SpliceInsert,
            other => AdTriggersElement::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AdTriggersElement {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AdTriggersElement::from(s))
    }
}
impl AdTriggersElement {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AdTriggersElement::Break => "BREAK",
            AdTriggersElement::DistributorAdvertisement => "DISTRIBUTOR_ADVERTISEMENT",
            AdTriggersElement::DistributorOverlayPlacementOpportunity => {
                "DISTRIBUTOR_OVERLAY_PLACEMENT_OPPORTUNITY"
            }
            AdTriggersElement::DistributorPlacementOpportunity => {
                "DISTRIBUTOR_PLACEMENT_OPPORTUNITY"
            }
            AdTriggersElement::ProviderAdvertisement => "PROVIDER_ADVERTISEMENT",
            AdTriggersElement::ProviderOverlayPlacementOpportunity => {
                "PROVIDER_OVERLAY_PLACEMENT_OPPORTUNITY"
            }
            AdTriggersElement::ProviderPlacementOpportunity => "PROVIDER_PLACEMENT_OPPORTUNITY",
            AdTriggersElement::SpliceInsert => "SPLICE_INSERT",
            AdTriggersElement::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BREAK",
            "DISTRIBUTOR_ADVERTISEMENT",
            "DISTRIBUTOR_OVERLAY_PLACEMENT_OPPORTUNITY",
            "DISTRIBUTOR_PLACEMENT_OPPORTUNITY",
            "PROVIDER_ADVERTISEMENT",
            "PROVIDER_OVERLAY_PLACEMENT_OPPORTUNITY",
            "PROVIDER_PLACEMENT_OPPORTUNITY",
            "SPLICE_INSERT",
        ]
    }
}
impl AsRef<str> for AdTriggersElement {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AdMarkers {
    #[allow(missing_docs)] // documentation missing in model
    Daterange,
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    Passthrough,
    #[allow(missing_docs)] // documentation missing in model
    Scte35Enhanced,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AdMarkers {
    fn from(s: &str) -> Self {
        match s {
            "DATERANGE" => AdMarkers::Daterange,
            "NONE" => AdMarkers::None,
            "PASSTHROUGH" => AdMarkers::Passthrough,
            "SCTE35_ENHANCED" => AdMarkers::Scte35Enhanced,
            other => AdMarkers::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AdMarkers {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AdMarkers::from(s))
    }
}
impl AdMarkers {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AdMarkers::Daterange => "DATERANGE",
            AdMarkers::None => "NONE",
            AdMarkers::Passthrough => "PASSTHROUGH",
            AdMarkers::Scte35Enhanced => "SCTE35_ENHANCED",
            AdMarkers::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DATERANGE", "NONE", "PASSTHROUGH", "SCTE35_ENHANCED"]
    }
}
impl AsRef<str> for AdMarkers {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DashPackage {
    /// A list of SCTE-35 message types that are treated as ad markers in the output.  If empty, no
    /// ad markers are output.  Specify multiple items to create ad markers for all of the included
    /// message types.
    pub ad_triggers: std::option::Option<std::vec::Vec<crate::model::AdTriggersElement>>,
    /// This setting allows the delivery restriction flags on SCTE-35 segmentation descriptors to
    /// determine whether a message signals an ad.  Choosing "NONE" means no SCTE-35 messages become
    /// ads.  Choosing "RESTRICTED" means SCTE-35 messages of the types specified in AdTriggers that
    /// contain delivery restrictions will be treated as ads.  Choosing "UNRESTRICTED" means SCTE-35
    /// messages of the types specified in AdTriggers that do not contain delivery restrictions will
    /// be treated as ads.  Choosing "BOTH" means all SCTE-35 messages of the types specified in
    /// AdTriggers will be treated as ads.  Note that Splice Insert messages do not have these flags
    /// and are always treated as ads if specified in AdTriggers.
    pub ads_on_delivery_restrictions: std::option::Option<crate::model::AdsOnDeliveryRestrictions>,
    /// A Dynamic Adaptive Streaming over HTTP (DASH) encryption configuration.
    pub encryption: std::option::Option<crate::model::DashEncryption>,
    /// Determines the position of some tags in the Media Presentation Description (MPD).  When set to FULL, elements like SegmentTemplate and ContentProtection are included in each Representation.  When set to COMPACT, duplicate elements are combined and presented at the AdaptationSet level.
    pub manifest_layout: std::option::Option<crate::model::ManifestLayout>,
    /// Time window (in seconds) contained in each manifest.
    pub manifest_window_seconds: i32,
    /// Minimum duration (in seconds) that a player will buffer media before starting the presentation.
    pub min_buffer_time_seconds: i32,
    /// Minimum duration (in seconds) between potential changes to the Dynamic Adaptive Streaming over HTTP (DASH) Media Presentation Description (MPD).
    pub min_update_period_seconds: i32,
    /// A list of triggers that controls when the outgoing Dynamic Adaptive Streaming over HTTP (DASH)
    /// Media Presentation Description (MPD) will be partitioned into multiple periods. If empty, the content will not
    /// be partitioned into more than one period. If the list contains "ADS", new periods will be created where
    /// the Channel source contains SCTE-35 ad markers.
    pub period_triggers: std::option::Option<std::vec::Vec<crate::model::PeriodTriggersElement>>,
    /// The Dynamic Adaptive Streaming over HTTP (DASH) profile type.  When set to "HBBTV_1_5", HbbTV 1.5 compliant output is enabled.
    pub profile: std::option::Option<crate::model::Profile>,
    /// Duration (in seconds) of each segment. Actual segments will be
    /// rounded to the nearest multiple of the source segment duration.
    pub segment_duration_seconds: i32,
    /// Determines the type of SegmentTemplate included in the Media Presentation Description (MPD).  When set to NUMBER_WITH_TIMELINE, a full timeline is presented in each SegmentTemplate, with $Number$ media URLs.  When set to TIME_WITH_TIMELINE, a full timeline is presented in each SegmentTemplate, with $Time$ media URLs. When set to NUMBER_WITH_DURATION, only a duration is included in each SegmentTemplate, with $Number$ media URLs.
    pub segment_template_format: std::option::Option<crate::model::SegmentTemplateFormat>,
    /// A StreamSelection configuration.
    pub stream_selection: std::option::Option<crate::model::StreamSelection>,
    /// Duration (in seconds) to delay live content before presentation.
    pub suggested_presentation_delay_seconds: i32,
    /// Determines the type of UTCTiming included in the Media Presentation Description (MPD)
    pub utc_timing: std::option::Option<crate::model::UtcTiming>,
    /// Specifies the value attribute of the UTCTiming field when utcTiming is set to HTTP-ISO or HTTP-HEAD
    pub utc_timing_uri: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DashPackage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DashPackage");
        formatter.field("ad_triggers", &self.ad_triggers);
        formatter.field(
            "ads_on_delivery_restrictions",
            &self.ads_on_delivery_restrictions,
        );
        formatter.field("encryption", &self.encryption);
        formatter.field("manifest_layout", &self.manifest_layout);
        formatter.field("manifest_window_seconds", &self.manifest_window_seconds);
        formatter.field("min_buffer_time_seconds", &self.min_buffer_time_seconds);
        formatter.field("min_update_period_seconds", &self.min_update_period_seconds);
        formatter.field("period_triggers", &self.period_triggers);
        formatter.field("profile", &self.profile);
        formatter.field("segment_duration_seconds", &self.segment_duration_seconds);
        formatter.field("segment_template_format", &self.segment_template_format);
        formatter.field("stream_selection", &self.stream_selection);
        formatter.field(
            "suggested_presentation_delay_seconds",
            &self.suggested_presentation_delay_seconds,
        );
        formatter.field("utc_timing", &self.utc_timing);
        formatter.field("utc_timing_uri", &self.utc_timing_uri);
        formatter.finish()
    }
}
/// See [`DashPackage`](crate::model::DashPackage)
pub mod dash_package {
    /// A builder for [`DashPackage`](crate::model::DashPackage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ad_triggers: std::option::Option<std::vec::Vec<crate::model::AdTriggersElement>>,
        pub(crate) ads_on_delivery_restrictions:
            std::option::Option<crate::model::AdsOnDeliveryRestrictions>,
        pub(crate) encryption: std::option::Option<crate::model::DashEncryption>,
        pub(crate) manifest_layout: std::option::Option<crate::model::ManifestLayout>,
        pub(crate) manifest_window_seconds: std::option::Option<i32>,
        pub(crate) min_buffer_time_seconds: std::option::Option<i32>,
        pub(crate) min_update_period_seconds: std::option::Option<i32>,
        pub(crate) period_triggers:
            std::option::Option<std::vec::Vec<crate::model::PeriodTriggersElement>>,
        pub(crate) profile: std::option::Option<crate::model::Profile>,
        pub(crate) segment_duration_seconds: std::option::Option<i32>,
        pub(crate) segment_template_format:
            std::option::Option<crate::model::SegmentTemplateFormat>,
        pub(crate) stream_selection: std::option::Option<crate::model::StreamSelection>,
        pub(crate) suggested_presentation_delay_seconds: std::option::Option<i32>,
        pub(crate) utc_timing: std::option::Option<crate::model::UtcTiming>,
        pub(crate) utc_timing_uri: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `ad_triggers`.
        ///
        /// To override the contents of this collection use [`set_ad_triggers`](Self::set_ad_triggers).
        ///
        /// A list of SCTE-35 message types that are treated as ad markers in the output.  If empty, no
        /// ad markers are output.  Specify multiple items to create ad markers for all of the included
        /// message types.
        pub fn ad_triggers(mut self, input: impl Into<crate::model::AdTriggersElement>) -> Self {
            let mut v = self.ad_triggers.unwrap_or_default();
            v.push(input.into());
            self.ad_triggers = Some(v);
            self
        }
        /// A list of SCTE-35 message types that are treated as ad markers in the output.  If empty, no
        /// ad markers are output.  Specify multiple items to create ad markers for all of the included
        /// message types.
        pub fn set_ad_triggers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AdTriggersElement>>,
        ) -> Self {
            self.ad_triggers = input;
            self
        }
        /// This setting allows the delivery restriction flags on SCTE-35 segmentation descriptors to
        /// determine whether a message signals an ad.  Choosing "NONE" means no SCTE-35 messages become
        /// ads.  Choosing "RESTRICTED" means SCTE-35 messages of the types specified in AdTriggers that
        /// contain delivery restrictions will be treated as ads.  Choosing "UNRESTRICTED" means SCTE-35
        /// messages of the types specified in AdTriggers that do not contain delivery restrictions will
        /// be treated as ads.  Choosing "BOTH" means all SCTE-35 messages of the types specified in
        /// AdTriggers will be treated as ads.  Note that Splice Insert messages do not have these flags
        /// and are always treated as ads if specified in AdTriggers.
        pub fn ads_on_delivery_restrictions(
            mut self,
            input: crate::model::AdsOnDeliveryRestrictions,
        ) -> Self {
            self.ads_on_delivery_restrictions = Some(input);
            self
        }
        /// This setting allows the delivery restriction flags on SCTE-35 segmentation descriptors to
        /// determine whether a message signals an ad.  Choosing "NONE" means no SCTE-35 messages become
        /// ads.  Choosing "RESTRICTED" means SCTE-35 messages of the types specified in AdTriggers that
        /// contain delivery restrictions will be treated as ads.  Choosing "UNRESTRICTED" means SCTE-35
        /// messages of the types specified in AdTriggers that do not contain delivery restrictions will
        /// be treated as ads.  Choosing "BOTH" means all SCTE-35 messages of the types specified in
        /// AdTriggers will be treated as ads.  Note that Splice Insert messages do not have these flags
        /// and are always treated as ads if specified in AdTriggers.
        pub fn set_ads_on_delivery_restrictions(
            mut self,
            input: std::option::Option<crate::model::AdsOnDeliveryRestrictions>,
        ) -> Self {
            self.ads_on_delivery_restrictions = input;
            self
        }
        /// A Dynamic Adaptive Streaming over HTTP (DASH) encryption configuration.
        pub fn encryption(mut self, input: crate::model::DashEncryption) -> Self {
            self.encryption = Some(input);
            self
        }
        /// A Dynamic Adaptive Streaming over HTTP (DASH) encryption configuration.
        pub fn set_encryption(
            mut self,
            input: std::option::Option<crate::model::DashEncryption>,
        ) -> Self {
            self.encryption = input;
            self
        }
        /// Determines the position of some tags in the Media Presentation Description (MPD).  When set to FULL, elements like SegmentTemplate and ContentProtection are included in each Representation.  When set to COMPACT, duplicate elements are combined and presented at the AdaptationSet level.
        pub fn manifest_layout(mut self, input: crate::model::ManifestLayout) -> Self {
            self.manifest_layout = Some(input);
            self
        }
        /// Determines the position of some tags in the Media Presentation Description (MPD).  When set to FULL, elements like SegmentTemplate and ContentProtection are included in each Representation.  When set to COMPACT, duplicate elements are combined and presented at the AdaptationSet level.
        pub fn set_manifest_layout(
            mut self,
            input: std::option::Option<crate::model::ManifestLayout>,
        ) -> Self {
            self.manifest_layout = input;
            self
        }
        /// Time window (in seconds) contained in each manifest.
        pub fn manifest_window_seconds(mut self, input: i32) -> Self {
            self.manifest_window_seconds = Some(input);
            self
        }
        /// Time window (in seconds) contained in each manifest.
        pub fn set_manifest_window_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.manifest_window_seconds = input;
            self
        }
        /// Minimum duration (in seconds) that a player will buffer media before starting the presentation.
        pub fn min_buffer_time_seconds(mut self, input: i32) -> Self {
            self.min_buffer_time_seconds = Some(input);
            self
        }
        /// Minimum duration (in seconds) that a player will buffer media before starting the presentation.
        pub fn set_min_buffer_time_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.min_buffer_time_seconds = input;
            self
        }
        /// Minimum duration (in seconds) between potential changes to the Dynamic Adaptive Streaming over HTTP (DASH) Media Presentation Description (MPD).
        pub fn min_update_period_seconds(mut self, input: i32) -> Self {
            self.min_update_period_seconds = Some(input);
            self
        }
        /// Minimum duration (in seconds) between potential changes to the Dynamic Adaptive Streaming over HTTP (DASH) Media Presentation Description (MPD).
        pub fn set_min_update_period_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.min_update_period_seconds = input;
            self
        }
        /// Appends an item to `period_triggers`.
        ///
        /// To override the contents of this collection use [`set_period_triggers`](Self::set_period_triggers).
        ///
        /// A list of triggers that controls when the outgoing Dynamic Adaptive Streaming over HTTP (DASH)
        /// Media Presentation Description (MPD) will be partitioned into multiple periods. If empty, the content will not
        /// be partitioned into more than one period. If the list contains "ADS", new periods will be created where
        /// the Channel source contains SCTE-35 ad markers.
        pub fn period_triggers(
            mut self,
            input: impl Into<crate::model::PeriodTriggersElement>,
        ) -> Self {
            let mut v = self.period_triggers.unwrap_or_default();
            v.push(input.into());
            self.period_triggers = Some(v);
            self
        }
        /// A list of triggers that controls when the outgoing Dynamic Adaptive Streaming over HTTP (DASH)
        /// Media Presentation Description (MPD) will be partitioned into multiple periods. If empty, the content will not
        /// be partitioned into more than one period. If the list contains "ADS", new periods will be created where
        /// the Channel source contains SCTE-35 ad markers.
        pub fn set_period_triggers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PeriodTriggersElement>>,
        ) -> Self {
            self.period_triggers = input;
            self
        }
        /// The Dynamic Adaptive Streaming over HTTP (DASH) profile type.  When set to "HBBTV_1_5", HbbTV 1.5 compliant output is enabled.
        pub fn profile(mut self, input: crate::model::Profile) -> Self {
            self.profile = Some(input);
            self
        }
        /// The Dynamic Adaptive Streaming over HTTP (DASH) profile type.  When set to "HBBTV_1_5", HbbTV 1.5 compliant output is enabled.
        pub fn set_profile(mut self, input: std::option::Option<crate::model::Profile>) -> Self {
            self.profile = input;
            self
        }
        /// Duration (in seconds) of each segment. Actual segments will be
        /// rounded to the nearest multiple of the source segment duration.
        pub fn segment_duration_seconds(mut self, input: i32) -> Self {
            self.segment_duration_seconds = Some(input);
            self
        }
        /// Duration (in seconds) of each segment. Actual segments will be
        /// rounded to the nearest multiple of the source segment duration.
        pub fn set_segment_duration_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.segment_duration_seconds = input;
            self
        }
        /// Determines the type of SegmentTemplate included in the Media Presentation Description (MPD).  When set to NUMBER_WITH_TIMELINE, a full timeline is presented in each SegmentTemplate, with $Number$ media URLs.  When set to TIME_WITH_TIMELINE, a full timeline is presented in each SegmentTemplate, with $Time$ media URLs. When set to NUMBER_WITH_DURATION, only a duration is included in each SegmentTemplate, with $Number$ media URLs.
        pub fn segment_template_format(
            mut self,
            input: crate::model::SegmentTemplateFormat,
        ) -> Self {
            self.segment_template_format = Some(input);
            self
        }
        /// Determines the type of SegmentTemplate included in the Media Presentation Description (MPD).  When set to NUMBER_WITH_TIMELINE, a full timeline is presented in each SegmentTemplate, with $Number$ media URLs.  When set to TIME_WITH_TIMELINE, a full timeline is presented in each SegmentTemplate, with $Time$ media URLs. When set to NUMBER_WITH_DURATION, only a duration is included in each SegmentTemplate, with $Number$ media URLs.
        pub fn set_segment_template_format(
            mut self,
            input: std::option::Option<crate::model::SegmentTemplateFormat>,
        ) -> Self {
            self.segment_template_format = input;
            self
        }
        /// A StreamSelection configuration.
        pub fn stream_selection(mut self, input: crate::model::StreamSelection) -> Self {
            self.stream_selection = Some(input);
            self
        }
        /// A StreamSelection configuration.
        pub fn set_stream_selection(
            mut self,
            input: std::option::Option<crate::model::StreamSelection>,
        ) -> Self {
            self.stream_selection = input;
            self
        }
        /// Duration (in seconds) to delay live content before presentation.
        pub fn suggested_presentation_delay_seconds(mut self, input: i32) -> Self {
            self.suggested_presentation_delay_seconds = Some(input);
            self
        }
        /// Duration (in seconds) to delay live content before presentation.
        pub fn set_suggested_presentation_delay_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.suggested_presentation_delay_seconds = input;
            self
        }
        /// Determines the type of UTCTiming included in the Media Presentation Description (MPD)
        pub fn utc_timing(mut self, input: crate::model::UtcTiming) -> Self {
            self.utc_timing = Some(input);
            self
        }
        /// Determines the type of UTCTiming included in the Media Presentation Description (MPD)
        pub fn set_utc_timing(
            mut self,
            input: std::option::Option<crate::model::UtcTiming>,
        ) -> Self {
            self.utc_timing = input;
            self
        }
        /// Specifies the value attribute of the UTCTiming field when utcTiming is set to HTTP-ISO or HTTP-HEAD
        pub fn utc_timing_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.utc_timing_uri = Some(input.into());
            self
        }
        /// Specifies the value attribute of the UTCTiming field when utcTiming is set to HTTP-ISO or HTTP-HEAD
        pub fn set_utc_timing_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.utc_timing_uri = input;
            self
        }
        /// Consumes the builder and constructs a [`DashPackage`](crate::model::DashPackage)
        pub fn build(self) -> crate::model::DashPackage {
            crate::model::DashPackage {
                ad_triggers: self.ad_triggers,
                ads_on_delivery_restrictions: self.ads_on_delivery_restrictions,
                encryption: self.encryption,
                manifest_layout: self.manifest_layout,
                manifest_window_seconds: self.manifest_window_seconds.unwrap_or_default(),
                min_buffer_time_seconds: self.min_buffer_time_seconds.unwrap_or_default(),
                min_update_period_seconds: self.min_update_period_seconds.unwrap_or_default(),
                period_triggers: self.period_triggers,
                profile: self.profile,
                segment_duration_seconds: self.segment_duration_seconds.unwrap_or_default(),
                segment_template_format: self.segment_template_format,
                stream_selection: self.stream_selection,
                suggested_presentation_delay_seconds: self
                    .suggested_presentation_delay_seconds
                    .unwrap_or_default(),
                utc_timing: self.utc_timing,
                utc_timing_uri: self.utc_timing_uri,
            }
        }
    }
}
impl DashPackage {
    /// Creates a new builder-style object to manufacture [`DashPackage`](crate::model::DashPackage)
    pub fn builder() -> crate::model::dash_package::Builder {
        crate::model::dash_package::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum UtcTiming {
    #[allow(missing_docs)] // documentation missing in model
    HttpHead,
    #[allow(missing_docs)] // documentation missing in model
    HttpIso,
    #[allow(missing_docs)] // documentation missing in model
    None,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for UtcTiming {
    fn from(s: &str) -> Self {
        match s {
            "HTTP-HEAD" => UtcTiming::HttpHead,
            "HTTP-ISO" => UtcTiming::HttpIso,
            "NONE" => UtcTiming::None,
            other => UtcTiming::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for UtcTiming {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(UtcTiming::from(s))
    }
}
impl UtcTiming {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            UtcTiming::HttpHead => "HTTP-HEAD",
            UtcTiming::HttpIso => "HTTP-ISO",
            UtcTiming::None => "NONE",
            UtcTiming::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HTTP-HEAD", "HTTP-ISO", "NONE"]
    }
}
impl AsRef<str> for UtcTiming {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SegmentTemplateFormat {
    #[allow(missing_docs)] // documentation missing in model
    NumberWithDuration,
    #[allow(missing_docs)] // documentation missing in model
    NumberWithTimeline,
    #[allow(missing_docs)] // documentation missing in model
    TimeWithTimeline,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SegmentTemplateFormat {
    fn from(s: &str) -> Self {
        match s {
            "NUMBER_WITH_DURATION" => SegmentTemplateFormat::NumberWithDuration,
            "NUMBER_WITH_TIMELINE" => SegmentTemplateFormat::NumberWithTimeline,
            "TIME_WITH_TIMELINE" => SegmentTemplateFormat::TimeWithTimeline,
            other => SegmentTemplateFormat::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SegmentTemplateFormat {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SegmentTemplateFormat::from(s))
    }
}
impl SegmentTemplateFormat {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SegmentTemplateFormat::NumberWithDuration => "NUMBER_WITH_DURATION",
            SegmentTemplateFormat::NumberWithTimeline => "NUMBER_WITH_TIMELINE",
            SegmentTemplateFormat::TimeWithTimeline => "TIME_WITH_TIMELINE",
            SegmentTemplateFormat::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "NUMBER_WITH_DURATION",
            "NUMBER_WITH_TIMELINE",
            "TIME_WITH_TIMELINE",
        ]
    }
}
impl AsRef<str> for SegmentTemplateFormat {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Profile {
    #[allow(missing_docs)] // documentation missing in model
    Hbbtv15,
    #[allow(missing_docs)] // documentation missing in model
    None,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Profile {
    fn from(s: &str) -> Self {
        match s {
            "HBBTV_1_5" => Profile::Hbbtv15,
            "NONE" => Profile::None,
            other => Profile::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Profile {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Profile::from(s))
    }
}
impl Profile {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Profile::Hbbtv15 => "HBBTV_1_5",
            Profile::None => "NONE",
            Profile::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HBBTV_1_5", "NONE"]
    }
}
impl AsRef<str> for Profile {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PeriodTriggersElement {
    #[allow(missing_docs)] // documentation missing in model
    Ads,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PeriodTriggersElement {
    fn from(s: &str) -> Self {
        match s {
            "ADS" => PeriodTriggersElement::Ads,
            other => PeriodTriggersElement::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PeriodTriggersElement {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PeriodTriggersElement::from(s))
    }
}
impl PeriodTriggersElement {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PeriodTriggersElement::Ads => "ADS",
            PeriodTriggersElement::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ADS"]
    }
}
impl AsRef<str> for PeriodTriggersElement {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ManifestLayout {
    #[allow(missing_docs)] // documentation missing in model
    Compact,
    #[allow(missing_docs)] // documentation missing in model
    Full,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ManifestLayout {
    fn from(s: &str) -> Self {
        match s {
            "COMPACT" => ManifestLayout::Compact,
            "FULL" => ManifestLayout::Full,
            other => ManifestLayout::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ManifestLayout {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ManifestLayout::from(s))
    }
}
impl ManifestLayout {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ManifestLayout::Compact => "COMPACT",
            ManifestLayout::Full => "FULL",
            ManifestLayout::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COMPACT", "FULL"]
    }
}
impl AsRef<str> for ManifestLayout {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// A Dynamic Adaptive Streaming over HTTP (DASH) encryption configuration.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DashEncryption {
    /// Time (in seconds) between each encryption key rotation.
    pub key_rotation_interval_seconds: i32,
    /// A configuration for accessing an external Secure Packager and Encoder Key Exchange (SPEKE) service that will provide encryption keys.
    pub speke_key_provider: std::option::Option<crate::model::SpekeKeyProvider>,
}
impl std::fmt::Debug for DashEncryption {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DashEncryption");
        formatter.field(
            "key_rotation_interval_seconds",
            &self.key_rotation_interval_seconds,
        );
        formatter.field("speke_key_provider", &self.speke_key_provider);
        formatter.finish()
    }
}
/// See [`DashEncryption`](crate::model::DashEncryption)
pub mod dash_encryption {
    /// A builder for [`DashEncryption`](crate::model::DashEncryption)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key_rotation_interval_seconds: std::option::Option<i32>,
        pub(crate) speke_key_provider: std::option::Option<crate::model::SpekeKeyProvider>,
    }
    impl Builder {
        /// Time (in seconds) between each encryption key rotation.
        pub fn key_rotation_interval_seconds(mut self, input: i32) -> Self {
            self.key_rotation_interval_seconds = Some(input);
            self
        }
        /// Time (in seconds) between each encryption key rotation.
        pub fn set_key_rotation_interval_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.key_rotation_interval_seconds = input;
            self
        }
        /// A configuration for accessing an external Secure Packager and Encoder Key Exchange (SPEKE) service that will provide encryption keys.
        pub fn speke_key_provider(mut self, input: crate::model::SpekeKeyProvider) -> Self {
            self.speke_key_provider = Some(input);
            self
        }
        /// A configuration for accessing an external Secure Packager and Encoder Key Exchange (SPEKE) service that will provide encryption keys.
        pub fn set_speke_key_provider(
            mut self,
            input: std::option::Option<crate::model::SpekeKeyProvider>,
        ) -> Self {
            self.speke_key_provider = input;
            self
        }
        /// Consumes the builder and constructs a [`DashEncryption`](crate::model::DashEncryption)
        pub fn build(self) -> crate::model::DashEncryption {
            crate::model::DashEncryption {
                key_rotation_interval_seconds: self
                    .key_rotation_interval_seconds
                    .unwrap_or_default(),
                speke_key_provider: self.speke_key_provider,
            }
        }
    }
}
impl DashEncryption {
    /// Creates a new builder-style object to manufacture [`DashEncryption`](crate::model::DashEncryption)
    pub fn builder() -> crate::model::dash_encryption::Builder {
        crate::model::dash_encryption::Builder::default()
    }
}

/// A Common Media Application Format (CMAF) packaging configuration.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CmafPackage {
    /// A Common Media Application Format (CMAF) encryption configuration.
    pub encryption: std::option::Option<crate::model::CmafEncryption>,
    /// A list of HLS manifest configurations
    pub hls_manifests: std::option::Option<std::vec::Vec<crate::model::HlsManifest>>,
    /// Duration (in seconds) of each segment. Actual segments will be
    /// rounded to the nearest multiple of the source segment duration.
    pub segment_duration_seconds: i32,
    /// An optional custom string that is prepended to the name of each segment. If not specified, it defaults to the ChannelId.
    pub segment_prefix: std::option::Option<std::string::String>,
    /// A StreamSelection configuration.
    pub stream_selection: std::option::Option<crate::model::StreamSelection>,
}
impl std::fmt::Debug for CmafPackage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CmafPackage");
        formatter.field("encryption", &self.encryption);
        formatter.field("hls_manifests", &self.hls_manifests);
        formatter.field("segment_duration_seconds", &self.segment_duration_seconds);
        formatter.field("segment_prefix", &self.segment_prefix);
        formatter.field("stream_selection", &self.stream_selection);
        formatter.finish()
    }
}
/// See [`CmafPackage`](crate::model::CmafPackage)
pub mod cmaf_package {
    /// A builder for [`CmafPackage`](crate::model::CmafPackage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) encryption: std::option::Option<crate::model::CmafEncryption>,
        pub(crate) hls_manifests: std::option::Option<std::vec::Vec<crate::model::HlsManifest>>,
        pub(crate) segment_duration_seconds: std::option::Option<i32>,
        pub(crate) segment_prefix: std::option::Option<std::string::String>,
        pub(crate) stream_selection: std::option::Option<crate::model::StreamSelection>,
    }
    impl Builder {
        /// A Common Media Application Format (CMAF) encryption configuration.
        pub fn encryption(mut self, input: crate::model::CmafEncryption) -> Self {
            self.encryption = Some(input);
            self
        }
        /// A Common Media Application Format (CMAF) encryption configuration.
        pub fn set_encryption(
            mut self,
            input: std::option::Option<crate::model::CmafEncryption>,
        ) -> Self {
            self.encryption = input;
            self
        }
        /// Appends an item to `hls_manifests`.
        ///
        /// To override the contents of this collection use [`set_hls_manifests`](Self::set_hls_manifests).
        ///
        /// A list of HLS manifest configurations
        pub fn hls_manifests(mut self, input: impl Into<crate::model::HlsManifest>) -> Self {
            let mut v = self.hls_manifests.unwrap_or_default();
            v.push(input.into());
            self.hls_manifests = Some(v);
            self
        }
        /// A list of HLS manifest configurations
        pub fn set_hls_manifests(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HlsManifest>>,
        ) -> Self {
            self.hls_manifests = input;
            self
        }
        /// Duration (in seconds) of each segment. Actual segments will be
        /// rounded to the nearest multiple of the source segment duration.
        pub fn segment_duration_seconds(mut self, input: i32) -> Self {
            self.segment_duration_seconds = Some(input);
            self
        }
        /// Duration (in seconds) of each segment. Actual segments will be
        /// rounded to the nearest multiple of the source segment duration.
        pub fn set_segment_duration_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.segment_duration_seconds = input;
            self
        }
        /// An optional custom string that is prepended to the name of each segment. If not specified, it defaults to the ChannelId.
        pub fn segment_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.segment_prefix = Some(input.into());
            self
        }
        /// An optional custom string that is prepended to the name of each segment. If not specified, it defaults to the ChannelId.
        pub fn set_segment_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.segment_prefix = input;
            self
        }
        /// A StreamSelection configuration.
        pub fn stream_selection(mut self, input: crate::model::StreamSelection) -> Self {
            self.stream_selection = Some(input);
            self
        }
        /// A StreamSelection configuration.
        pub fn set_stream_selection(
            mut self,
            input: std::option::Option<crate::model::StreamSelection>,
        ) -> Self {
            self.stream_selection = input;
            self
        }
        /// Consumes the builder and constructs a [`CmafPackage`](crate::model::CmafPackage)
        pub fn build(self) -> crate::model::CmafPackage {
            crate::model::CmafPackage {
                encryption: self.encryption,
                hls_manifests: self.hls_manifests,
                segment_duration_seconds: self.segment_duration_seconds.unwrap_or_default(),
                segment_prefix: self.segment_prefix,
                stream_selection: self.stream_selection,
            }
        }
    }
}
impl CmafPackage {
    /// Creates a new builder-style object to manufacture [`CmafPackage`](crate::model::CmafPackage)
    pub fn builder() -> crate::model::cmaf_package::Builder {
        crate::model::cmaf_package::Builder::default()
    }
}

/// A HTTP Live Streaming (HLS) manifest configuration.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HlsManifest {
    /// This setting controls how ad markers are included in the packaged OriginEndpoint.
    /// "NONE" will omit all SCTE-35 ad markers from the output.
    /// "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35 ad
    /// markers (comments) taken directly from the input HTTP Live Streaming (HLS) manifest.
    /// "SCTE35_ENHANCED" generates ad markers and blackout tags based on SCTE-35
    /// messages in the input source.
    /// "DATERANGE" inserts EXT-X-DATERANGE tags to signal ad and program transition events
    /// in HLS and CMAF manifests. For this option, you must set a programDateTimeIntervalSeconds value
    /// that is greater than 0.
    pub ad_markers: std::option::Option<crate::model::AdMarkers>,
    /// The ID of the manifest. The ID must be unique within the OriginEndpoint and it cannot be changed after it is created.
    pub id: std::option::Option<std::string::String>,
    /// When enabled, an I-Frame only stream will be included in the output.
    pub include_iframe_only_stream: bool,
    /// An optional short string appended to the end of the OriginEndpoint URL. If not specified, defaults to the manifestName for the OriginEndpoint.
    pub manifest_name: std::option::Option<std::string::String>,
    /// The HTTP Live Streaming (HLS) playlist type.
    /// When either "EVENT" or "VOD" is specified, a corresponding EXT-X-PLAYLIST-TYPE
    /// entry will be included in the media playlist.
    pub playlist_type: std::option::Option<crate::model::PlaylistType>,
    /// Time window (in seconds) contained in each parent manifest.
    pub playlist_window_seconds: i32,
    /// The interval (in seconds) between each EXT-X-PROGRAM-DATE-TIME tag
    /// inserted into manifests. Additionally, when an interval is specified
    /// ID3Timed Metadata messages will be generated every 5 seconds using the
    /// ingest time of the content.
    /// If the interval is not specified, or set to 0, then
    /// no EXT-X-PROGRAM-DATE-TIME tags will be inserted into manifests and no
    /// ID3Timed Metadata messages will be generated. Note that irrespective
    /// of this parameter, if any ID3 Timed Metadata is found in HTTP Live Streaming (HLS) input,
    /// it will be passed through to HLS output.
    pub program_date_time_interval_seconds: i32,
    /// The URL of the packaged OriginEndpoint for consumption.
    pub url: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for HlsManifest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HlsManifest");
        formatter.field("ad_markers", &self.ad_markers);
        formatter.field("id", &self.id);
        formatter.field(
            "include_iframe_only_stream",
            &self.include_iframe_only_stream,
        );
        formatter.field("manifest_name", &self.manifest_name);
        formatter.field("playlist_type", &self.playlist_type);
        formatter.field("playlist_window_seconds", &self.playlist_window_seconds);
        formatter.field(
            "program_date_time_interval_seconds",
            &self.program_date_time_interval_seconds,
        );
        formatter.field("url", &self.url);
        formatter.finish()
    }
}
/// See [`HlsManifest`](crate::model::HlsManifest)
pub mod hls_manifest {
    /// A builder for [`HlsManifest`](crate::model::HlsManifest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ad_markers: std::option::Option<crate::model::AdMarkers>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) include_iframe_only_stream: std::option::Option<bool>,
        pub(crate) manifest_name: std::option::Option<std::string::String>,
        pub(crate) playlist_type: std::option::Option<crate::model::PlaylistType>,
        pub(crate) playlist_window_seconds: std::option::Option<i32>,
        pub(crate) program_date_time_interval_seconds: std::option::Option<i32>,
        pub(crate) url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// This setting controls how ad markers are included in the packaged OriginEndpoint.
        /// "NONE" will omit all SCTE-35 ad markers from the output.
        /// "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35 ad
        /// markers (comments) taken directly from the input HTTP Live Streaming (HLS) manifest.
        /// "SCTE35_ENHANCED" generates ad markers and blackout tags based on SCTE-35
        /// messages in the input source.
        /// "DATERANGE" inserts EXT-X-DATERANGE tags to signal ad and program transition events
        /// in HLS and CMAF manifests. For this option, you must set a programDateTimeIntervalSeconds value
        /// that is greater than 0.
        pub fn ad_markers(mut self, input: crate::model::AdMarkers) -> Self {
            self.ad_markers = Some(input);
            self
        }
        /// This setting controls how ad markers are included in the packaged OriginEndpoint.
        /// "NONE" will omit all SCTE-35 ad markers from the output.
        /// "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35 ad
        /// markers (comments) taken directly from the input HTTP Live Streaming (HLS) manifest.
        /// "SCTE35_ENHANCED" generates ad markers and blackout tags based on SCTE-35
        /// messages in the input source.
        /// "DATERANGE" inserts EXT-X-DATERANGE tags to signal ad and program transition events
        /// in HLS and CMAF manifests. For this option, you must set a programDateTimeIntervalSeconds value
        /// that is greater than 0.
        pub fn set_ad_markers(
            mut self,
            input: std::option::Option<crate::model::AdMarkers>,
        ) -> Self {
            self.ad_markers = input;
            self
        }
        /// The ID of the manifest. The ID must be unique within the OriginEndpoint and it cannot be changed after it is created.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// The ID of the manifest. The ID must be unique within the OriginEndpoint and it cannot be changed after it is created.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// When enabled, an I-Frame only stream will be included in the output.
        pub fn include_iframe_only_stream(mut self, input: bool) -> Self {
            self.include_iframe_only_stream = Some(input);
            self
        }
        /// When enabled, an I-Frame only stream will be included in the output.
        pub fn set_include_iframe_only_stream(mut self, input: std::option::Option<bool>) -> Self {
            self.include_iframe_only_stream = input;
            self
        }
        /// An optional short string appended to the end of the OriginEndpoint URL. If not specified, defaults to the manifestName for the OriginEndpoint.
        pub fn manifest_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.manifest_name = Some(input.into());
            self
        }
        /// An optional short string appended to the end of the OriginEndpoint URL. If not specified, defaults to the manifestName for the OriginEndpoint.
        pub fn set_manifest_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.manifest_name = input;
            self
        }
        /// The HTTP Live Streaming (HLS) playlist type.
        /// When either "EVENT" or "VOD" is specified, a corresponding EXT-X-PLAYLIST-TYPE
        /// entry will be included in the media playlist.
        pub fn playlist_type(mut self, input: crate::model::PlaylistType) -> Self {
            self.playlist_type = Some(input);
            self
        }
        /// The HTTP Live Streaming (HLS) playlist type.
        /// When either "EVENT" or "VOD" is specified, a corresponding EXT-X-PLAYLIST-TYPE
        /// entry will be included in the media playlist.
        pub fn set_playlist_type(
            mut self,
            input: std::option::Option<crate::model::PlaylistType>,
        ) -> Self {
            self.playlist_type = input;
            self
        }
        /// Time window (in seconds) contained in each parent manifest.
        pub fn playlist_window_seconds(mut self, input: i32) -> Self {
            self.playlist_window_seconds = Some(input);
            self
        }
        /// Time window (in seconds) contained in each parent manifest.
        pub fn set_playlist_window_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.playlist_window_seconds = input;
            self
        }
        /// The interval (in seconds) between each EXT-X-PROGRAM-DATE-TIME tag
        /// inserted into manifests. Additionally, when an interval is specified
        /// ID3Timed Metadata messages will be generated every 5 seconds using the
        /// ingest time of the content.
        /// If the interval is not specified, or set to 0, then
        /// no EXT-X-PROGRAM-DATE-TIME tags will be inserted into manifests and no
        /// ID3Timed Metadata messages will be generated. Note that irrespective
        /// of this parameter, if any ID3 Timed Metadata is found in HTTP Live Streaming (HLS) input,
        /// it will be passed through to HLS output.
        pub fn program_date_time_interval_seconds(mut self, input: i32) -> Self {
            self.program_date_time_interval_seconds = Some(input);
            self
        }
        /// The interval (in seconds) between each EXT-X-PROGRAM-DATE-TIME tag
        /// inserted into manifests. Additionally, when an interval is specified
        /// ID3Timed Metadata messages will be generated every 5 seconds using the
        /// ingest time of the content.
        /// If the interval is not specified, or set to 0, then
        /// no EXT-X-PROGRAM-DATE-TIME tags will be inserted into manifests and no
        /// ID3Timed Metadata messages will be generated. Note that irrespective
        /// of this parameter, if any ID3 Timed Metadata is found in HTTP Live Streaming (HLS) input,
        /// it will be passed through to HLS output.
        pub fn set_program_date_time_interval_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.program_date_time_interval_seconds = input;
            self
        }
        /// The URL of the packaged OriginEndpoint for consumption.
        pub fn url(mut self, input: impl Into<std::string::String>) -> Self {
            self.url = Some(input.into());
            self
        }
        /// The URL of the packaged OriginEndpoint for consumption.
        pub fn set_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.url = input;
            self
        }
        /// Consumes the builder and constructs a [`HlsManifest`](crate::model::HlsManifest)
        pub fn build(self) -> crate::model::HlsManifest {
            crate::model::HlsManifest {
                ad_markers: self.ad_markers,
                id: self.id,
                include_iframe_only_stream: self.include_iframe_only_stream.unwrap_or_default(),
                manifest_name: self.manifest_name,
                playlist_type: self.playlist_type,
                playlist_window_seconds: self.playlist_window_seconds.unwrap_or_default(),
                program_date_time_interval_seconds: self
                    .program_date_time_interval_seconds
                    .unwrap_or_default(),
                url: self.url,
            }
        }
    }
}
impl HlsManifest {
    /// Creates a new builder-style object to manufacture [`HlsManifest`](crate::model::HlsManifest)
    pub fn builder() -> crate::model::hls_manifest::Builder {
        crate::model::hls_manifest::Builder::default()
    }
}

/// A Common Media Application Format (CMAF) encryption configuration.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CmafEncryption {
    /// An optional 128-bit, 16-byte hex value represented by a 32-character string, used in conjunction with the key for encrypting blocks. If you don't specify a value, then MediaPackage creates the constant initialization vector (IV).
    pub constant_initialization_vector: std::option::Option<std::string::String>,
    /// Time (in seconds) between each encryption key rotation.
    pub key_rotation_interval_seconds: i32,
    /// A configuration for accessing an external Secure Packager and Encoder Key Exchange (SPEKE) service that will provide encryption keys.
    pub speke_key_provider: std::option::Option<crate::model::SpekeKeyProvider>,
}
impl std::fmt::Debug for CmafEncryption {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CmafEncryption");
        formatter.field(
            "constant_initialization_vector",
            &self.constant_initialization_vector,
        );
        formatter.field(
            "key_rotation_interval_seconds",
            &self.key_rotation_interval_seconds,
        );
        formatter.field("speke_key_provider", &self.speke_key_provider);
        formatter.finish()
    }
}
/// See [`CmafEncryption`](crate::model::CmafEncryption)
pub mod cmaf_encryption {
    /// A builder for [`CmafEncryption`](crate::model::CmafEncryption)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) constant_initialization_vector: std::option::Option<std::string::String>,
        pub(crate) key_rotation_interval_seconds: std::option::Option<i32>,
        pub(crate) speke_key_provider: std::option::Option<crate::model::SpekeKeyProvider>,
    }
    impl Builder {
        /// An optional 128-bit, 16-byte hex value represented by a 32-character string, used in conjunction with the key for encrypting blocks. If you don't specify a value, then MediaPackage creates the constant initialization vector (IV).
        pub fn constant_initialization_vector(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.constant_initialization_vector = Some(input.into());
            self
        }
        /// An optional 128-bit, 16-byte hex value represented by a 32-character string, used in conjunction with the key for encrypting blocks. If you don't specify a value, then MediaPackage creates the constant initialization vector (IV).
        pub fn set_constant_initialization_vector(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.constant_initialization_vector = input;
            self
        }
        /// Time (in seconds) between each encryption key rotation.
        pub fn key_rotation_interval_seconds(mut self, input: i32) -> Self {
            self.key_rotation_interval_seconds = Some(input);
            self
        }
        /// Time (in seconds) between each encryption key rotation.
        pub fn set_key_rotation_interval_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.key_rotation_interval_seconds = input;
            self
        }
        /// A configuration for accessing an external Secure Packager and Encoder Key Exchange (SPEKE) service that will provide encryption keys.
        pub fn speke_key_provider(mut self, input: crate::model::SpekeKeyProvider) -> Self {
            self.speke_key_provider = Some(input);
            self
        }
        /// A configuration for accessing an external Secure Packager and Encoder Key Exchange (SPEKE) service that will provide encryption keys.
        pub fn set_speke_key_provider(
            mut self,
            input: std::option::Option<crate::model::SpekeKeyProvider>,
        ) -> Self {
            self.speke_key_provider = input;
            self
        }
        /// Consumes the builder and constructs a [`CmafEncryption`](crate::model::CmafEncryption)
        pub fn build(self) -> crate::model::CmafEncryption {
            crate::model::CmafEncryption {
                constant_initialization_vector: self.constant_initialization_vector,
                key_rotation_interval_seconds: self
                    .key_rotation_interval_seconds
                    .unwrap_or_default(),
                speke_key_provider: self.speke_key_provider,
            }
        }
    }
}
impl CmafEncryption {
    /// Creates a new builder-style object to manufacture [`CmafEncryption`](crate::model::CmafEncryption)
    pub fn builder() -> crate::model::cmaf_encryption::Builder {
        crate::model::cmaf_encryption::Builder::default()
    }
}

/// CDN Authorization credentials
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Authorization {
    /// The Amazon Resource Name (ARN) for the secret in Secrets Manager that your Content Distribution Network (CDN) uses for authorization to access your endpoint.
    pub cdn_identifier_secret: std::option::Option<std::string::String>,
    /// The Amazon Resource Name (ARN) for the IAM role that allows MediaPackage to communicate with AWS Secrets Manager.
    pub secrets_role_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Authorization {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Authorization");
        formatter.field("cdn_identifier_secret", &self.cdn_identifier_secret);
        formatter.field("secrets_role_arn", &self.secrets_role_arn);
        formatter.finish()
    }
}
/// See [`Authorization`](crate::model::Authorization)
pub mod authorization {
    /// A builder for [`Authorization`](crate::model::Authorization)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cdn_identifier_secret: std::option::Option<std::string::String>,
        pub(crate) secrets_role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The Amazon Resource Name (ARN) for the secret in Secrets Manager that your Content Distribution Network (CDN) uses for authorization to access your endpoint.
        pub fn cdn_identifier_secret(mut self, input: impl Into<std::string::String>) -> Self {
            self.cdn_identifier_secret = Some(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) for the secret in Secrets Manager that your Content Distribution Network (CDN) uses for authorization to access your endpoint.
        pub fn set_cdn_identifier_secret(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cdn_identifier_secret = input;
            self
        }
        /// The Amazon Resource Name (ARN) for the IAM role that allows MediaPackage to communicate with AWS Secrets Manager.
        pub fn secrets_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.secrets_role_arn = Some(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) for the IAM role that allows MediaPackage to communicate with AWS Secrets Manager.
        pub fn set_secrets_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.secrets_role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`Authorization`](crate::model::Authorization)
        pub fn build(self) -> crate::model::Authorization {
            crate::model::Authorization {
                cdn_identifier_secret: self.cdn_identifier_secret,
                secrets_role_arn: self.secrets_role_arn,
            }
        }
    }
}
impl Authorization {
    /// Creates a new builder-style object to manufacture [`Authorization`](crate::model::Authorization)
    pub fn builder() -> crate::model::authorization::Builder {
        crate::model::authorization::Builder::default()
    }
}

/// A Common Media Application Format (CMAF) packaging configuration.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CmafPackageCreateOrUpdateParameters {
    /// A Common Media Application Format (CMAF) encryption configuration.
    pub encryption: std::option::Option<crate::model::CmafEncryption>,
    /// A list of HLS manifest configurations
    pub hls_manifests:
        std::option::Option<std::vec::Vec<crate::model::HlsManifestCreateOrUpdateParameters>>,
    /// Duration (in seconds) of each segment. Actual segments will be
    /// rounded to the nearest multiple of the source segment duration.
    pub segment_duration_seconds: i32,
    /// An optional custom string that is prepended to the name of each segment. If not specified, it defaults to the ChannelId.
    pub segment_prefix: std::option::Option<std::string::String>,
    /// A StreamSelection configuration.
    pub stream_selection: std::option::Option<crate::model::StreamSelection>,
}
impl std::fmt::Debug for CmafPackageCreateOrUpdateParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CmafPackageCreateOrUpdateParameters");
        formatter.field("encryption", &self.encryption);
        formatter.field("hls_manifests", &self.hls_manifests);
        formatter.field("segment_duration_seconds", &self.segment_duration_seconds);
        formatter.field("segment_prefix", &self.segment_prefix);
        formatter.field("stream_selection", &self.stream_selection);
        formatter.finish()
    }
}
/// See [`CmafPackageCreateOrUpdateParameters`](crate::model::CmafPackageCreateOrUpdateParameters)
pub mod cmaf_package_create_or_update_parameters {
    /// A builder for [`CmafPackageCreateOrUpdateParameters`](crate::model::CmafPackageCreateOrUpdateParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) encryption: std::option::Option<crate::model::CmafEncryption>,
        pub(crate) hls_manifests:
            std::option::Option<std::vec::Vec<crate::model::HlsManifestCreateOrUpdateParameters>>,
        pub(crate) segment_duration_seconds: std::option::Option<i32>,
        pub(crate) segment_prefix: std::option::Option<std::string::String>,
        pub(crate) stream_selection: std::option::Option<crate::model::StreamSelection>,
    }
    impl Builder {
        /// A Common Media Application Format (CMAF) encryption configuration.
        pub fn encryption(mut self, input: crate::model::CmafEncryption) -> Self {
            self.encryption = Some(input);
            self
        }
        /// A Common Media Application Format (CMAF) encryption configuration.
        pub fn set_encryption(
            mut self,
            input: std::option::Option<crate::model::CmafEncryption>,
        ) -> Self {
            self.encryption = input;
            self
        }
        /// Appends an item to `hls_manifests`.
        ///
        /// To override the contents of this collection use [`set_hls_manifests`](Self::set_hls_manifests).
        ///
        /// A list of HLS manifest configurations
        pub fn hls_manifests(
            mut self,
            input: impl Into<crate::model::HlsManifestCreateOrUpdateParameters>,
        ) -> Self {
            let mut v = self.hls_manifests.unwrap_or_default();
            v.push(input.into());
            self.hls_manifests = Some(v);
            self
        }
        /// A list of HLS manifest configurations
        pub fn set_hls_manifests(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::HlsManifestCreateOrUpdateParameters>,
            >,
        ) -> Self {
            self.hls_manifests = input;
            self
        }
        /// Duration (in seconds) of each segment. Actual segments will be
        /// rounded to the nearest multiple of the source segment duration.
        pub fn segment_duration_seconds(mut self, input: i32) -> Self {
            self.segment_duration_seconds = Some(input);
            self
        }
        /// Duration (in seconds) of each segment. Actual segments will be
        /// rounded to the nearest multiple of the source segment duration.
        pub fn set_segment_duration_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.segment_duration_seconds = input;
            self
        }
        /// An optional custom string that is prepended to the name of each segment. If not specified, it defaults to the ChannelId.
        pub fn segment_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.segment_prefix = Some(input.into());
            self
        }
        /// An optional custom string that is prepended to the name of each segment. If not specified, it defaults to the ChannelId.
        pub fn set_segment_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.segment_prefix = input;
            self
        }
        /// A StreamSelection configuration.
        pub fn stream_selection(mut self, input: crate::model::StreamSelection) -> Self {
            self.stream_selection = Some(input);
            self
        }
        /// A StreamSelection configuration.
        pub fn set_stream_selection(
            mut self,
            input: std::option::Option<crate::model::StreamSelection>,
        ) -> Self {
            self.stream_selection = input;
            self
        }
        /// Consumes the builder and constructs a [`CmafPackageCreateOrUpdateParameters`](crate::model::CmafPackageCreateOrUpdateParameters)
        pub fn build(self) -> crate::model::CmafPackageCreateOrUpdateParameters {
            crate::model::CmafPackageCreateOrUpdateParameters {
                encryption: self.encryption,
                hls_manifests: self.hls_manifests,
                segment_duration_seconds: self.segment_duration_seconds.unwrap_or_default(),
                segment_prefix: self.segment_prefix,
                stream_selection: self.stream_selection,
            }
        }
    }
}
impl CmafPackageCreateOrUpdateParameters {
    /// Creates a new builder-style object to manufacture [`CmafPackageCreateOrUpdateParameters`](crate::model::CmafPackageCreateOrUpdateParameters)
    pub fn builder() -> crate::model::cmaf_package_create_or_update_parameters::Builder {
        crate::model::cmaf_package_create_or_update_parameters::Builder::default()
    }
}

/// A HTTP Live Streaming (HLS) manifest configuration.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HlsManifestCreateOrUpdateParameters {
    /// This setting controls how ad markers are included in the packaged OriginEndpoint.
    /// "NONE" will omit all SCTE-35 ad markers from the output.
    /// "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35 ad
    /// markers (comments) taken directly from the input HTTP Live Streaming (HLS) manifest.
    /// "SCTE35_ENHANCED" generates ad markers and blackout tags based on SCTE-35
    /// messages in the input source.
    /// "DATERANGE" inserts EXT-X-DATERANGE tags to signal ad and program transition events
    /// in HLS and CMAF manifests. For this option, you must set a programDateTimeIntervalSeconds value
    /// that is greater than 0.
    pub ad_markers: std::option::Option<crate::model::AdMarkers>,
    /// A list of SCTE-35 message types that are treated as ad markers in the output.  If empty, no
    /// ad markers are output.  Specify multiple items to create ad markers for all of the included
    /// message types.
    pub ad_triggers: std::option::Option<std::vec::Vec<crate::model::AdTriggersElement>>,
    /// This setting allows the delivery restriction flags on SCTE-35 segmentation descriptors to
    /// determine whether a message signals an ad.  Choosing "NONE" means no SCTE-35 messages become
    /// ads.  Choosing "RESTRICTED" means SCTE-35 messages of the types specified in AdTriggers that
    /// contain delivery restrictions will be treated as ads.  Choosing "UNRESTRICTED" means SCTE-35
    /// messages of the types specified in AdTriggers that do not contain delivery restrictions will
    /// be treated as ads.  Choosing "BOTH" means all SCTE-35 messages of the types specified in
    /// AdTriggers will be treated as ads.  Note that Splice Insert messages do not have these flags
    /// and are always treated as ads if specified in AdTriggers.
    pub ads_on_delivery_restrictions: std::option::Option<crate::model::AdsOnDeliveryRestrictions>,
    /// The ID of the manifest. The ID must be unique within the OriginEndpoint and it cannot be changed after it is created.
    pub id: std::option::Option<std::string::String>,
    /// When enabled, an I-Frame only stream will be included in the output.
    pub include_iframe_only_stream: bool,
    /// An optional short string appended to the end of the OriginEndpoint URL. If not specified, defaults to the manifestName for the OriginEndpoint.
    pub manifest_name: std::option::Option<std::string::String>,
    /// The HTTP Live Streaming (HLS) playlist type.
    /// When either "EVENT" or "VOD" is specified, a corresponding EXT-X-PLAYLIST-TYPE
    /// entry will be included in the media playlist.
    pub playlist_type: std::option::Option<crate::model::PlaylistType>,
    /// Time window (in seconds) contained in each parent manifest.
    pub playlist_window_seconds: i32,
    /// The interval (in seconds) between each EXT-X-PROGRAM-DATE-TIME tag
    /// inserted into manifests. Additionally, when an interval is specified
    /// ID3Timed Metadata messages will be generated every 5 seconds using the
    /// ingest time of the content.
    /// If the interval is not specified, or set to 0, then
    /// no EXT-X-PROGRAM-DATE-TIME tags will be inserted into manifests and no
    /// ID3Timed Metadata messages will be generated. Note that irrespective
    /// of this parameter, if any ID3 Timed Metadata is found in HTTP Live Streaming (HLS) input,
    /// it will be passed through to HLS output.
    pub program_date_time_interval_seconds: i32,
}
impl std::fmt::Debug for HlsManifestCreateOrUpdateParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HlsManifestCreateOrUpdateParameters");
        formatter.field("ad_markers", &self.ad_markers);
        formatter.field("ad_triggers", &self.ad_triggers);
        formatter.field(
            "ads_on_delivery_restrictions",
            &self.ads_on_delivery_restrictions,
        );
        formatter.field("id", &self.id);
        formatter.field(
            "include_iframe_only_stream",
            &self.include_iframe_only_stream,
        );
        formatter.field("manifest_name", &self.manifest_name);
        formatter.field("playlist_type", &self.playlist_type);
        formatter.field("playlist_window_seconds", &self.playlist_window_seconds);
        formatter.field(
            "program_date_time_interval_seconds",
            &self.program_date_time_interval_seconds,
        );
        formatter.finish()
    }
}
/// See [`HlsManifestCreateOrUpdateParameters`](crate::model::HlsManifestCreateOrUpdateParameters)
pub mod hls_manifest_create_or_update_parameters {
    /// A builder for [`HlsManifestCreateOrUpdateParameters`](crate::model::HlsManifestCreateOrUpdateParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ad_markers: std::option::Option<crate::model::AdMarkers>,
        pub(crate) ad_triggers: std::option::Option<std::vec::Vec<crate::model::AdTriggersElement>>,
        pub(crate) ads_on_delivery_restrictions:
            std::option::Option<crate::model::AdsOnDeliveryRestrictions>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) include_iframe_only_stream: std::option::Option<bool>,
        pub(crate) manifest_name: std::option::Option<std::string::String>,
        pub(crate) playlist_type: std::option::Option<crate::model::PlaylistType>,
        pub(crate) playlist_window_seconds: std::option::Option<i32>,
        pub(crate) program_date_time_interval_seconds: std::option::Option<i32>,
    }
    impl Builder {
        /// This setting controls how ad markers are included in the packaged OriginEndpoint.
        /// "NONE" will omit all SCTE-35 ad markers from the output.
        /// "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35 ad
        /// markers (comments) taken directly from the input HTTP Live Streaming (HLS) manifest.
        /// "SCTE35_ENHANCED" generates ad markers and blackout tags based on SCTE-35
        /// messages in the input source.
        /// "DATERANGE" inserts EXT-X-DATERANGE tags to signal ad and program transition events
        /// in HLS and CMAF manifests. For this option, you must set a programDateTimeIntervalSeconds value
        /// that is greater than 0.
        pub fn ad_markers(mut self, input: crate::model::AdMarkers) -> Self {
            self.ad_markers = Some(input);
            self
        }
        /// This setting controls how ad markers are included in the packaged OriginEndpoint.
        /// "NONE" will omit all SCTE-35 ad markers from the output.
        /// "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35 ad
        /// markers (comments) taken directly from the input HTTP Live Streaming (HLS) manifest.
        /// "SCTE35_ENHANCED" generates ad markers and blackout tags based on SCTE-35
        /// messages in the input source.
        /// "DATERANGE" inserts EXT-X-DATERANGE tags to signal ad and program transition events
        /// in HLS and CMAF manifests. For this option, you must set a programDateTimeIntervalSeconds value
        /// that is greater than 0.
        pub fn set_ad_markers(
            mut self,
            input: std::option::Option<crate::model::AdMarkers>,
        ) -> Self {
            self.ad_markers = input;
            self
        }
        /// Appends an item to `ad_triggers`.
        ///
        /// To override the contents of this collection use [`set_ad_triggers`](Self::set_ad_triggers).
        ///
        /// A list of SCTE-35 message types that are treated as ad markers in the output.  If empty, no
        /// ad markers are output.  Specify multiple items to create ad markers for all of the included
        /// message types.
        pub fn ad_triggers(mut self, input: impl Into<crate::model::AdTriggersElement>) -> Self {
            let mut v = self.ad_triggers.unwrap_or_default();
            v.push(input.into());
            self.ad_triggers = Some(v);
            self
        }
        /// A list of SCTE-35 message types that are treated as ad markers in the output.  If empty, no
        /// ad markers are output.  Specify multiple items to create ad markers for all of the included
        /// message types.
        pub fn set_ad_triggers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AdTriggersElement>>,
        ) -> Self {
            self.ad_triggers = input;
            self
        }
        /// This setting allows the delivery restriction flags on SCTE-35 segmentation descriptors to
        /// determine whether a message signals an ad.  Choosing "NONE" means no SCTE-35 messages become
        /// ads.  Choosing "RESTRICTED" means SCTE-35 messages of the types specified in AdTriggers that
        /// contain delivery restrictions will be treated as ads.  Choosing "UNRESTRICTED" means SCTE-35
        /// messages of the types specified in AdTriggers that do not contain delivery restrictions will
        /// be treated as ads.  Choosing "BOTH" means all SCTE-35 messages of the types specified in
        /// AdTriggers will be treated as ads.  Note that Splice Insert messages do not have these flags
        /// and are always treated as ads if specified in AdTriggers.
        pub fn ads_on_delivery_restrictions(
            mut self,
            input: crate::model::AdsOnDeliveryRestrictions,
        ) -> Self {
            self.ads_on_delivery_restrictions = Some(input);
            self
        }
        /// This setting allows the delivery restriction flags on SCTE-35 segmentation descriptors to
        /// determine whether a message signals an ad.  Choosing "NONE" means no SCTE-35 messages become
        /// ads.  Choosing "RESTRICTED" means SCTE-35 messages of the types specified in AdTriggers that
        /// contain delivery restrictions will be treated as ads.  Choosing "UNRESTRICTED" means SCTE-35
        /// messages of the types specified in AdTriggers that do not contain delivery restrictions will
        /// be treated as ads.  Choosing "BOTH" means all SCTE-35 messages of the types specified in
        /// AdTriggers will be treated as ads.  Note that Splice Insert messages do not have these flags
        /// and are always treated as ads if specified in AdTriggers.
        pub fn set_ads_on_delivery_restrictions(
            mut self,
            input: std::option::Option<crate::model::AdsOnDeliveryRestrictions>,
        ) -> Self {
            self.ads_on_delivery_restrictions = input;
            self
        }
        /// The ID of the manifest. The ID must be unique within the OriginEndpoint and it cannot be changed after it is created.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// The ID of the manifest. The ID must be unique within the OriginEndpoint and it cannot be changed after it is created.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// When enabled, an I-Frame only stream will be included in the output.
        pub fn include_iframe_only_stream(mut self, input: bool) -> Self {
            self.include_iframe_only_stream = Some(input);
            self
        }
        /// When enabled, an I-Frame only stream will be included in the output.
        pub fn set_include_iframe_only_stream(mut self, input: std::option::Option<bool>) -> Self {
            self.include_iframe_only_stream = input;
            self
        }
        /// An optional short string appended to the end of the OriginEndpoint URL. If not specified, defaults to the manifestName for the OriginEndpoint.
        pub fn manifest_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.manifest_name = Some(input.into());
            self
        }
        /// An optional short string appended to the end of the OriginEndpoint URL. If not specified, defaults to the manifestName for the OriginEndpoint.
        pub fn set_manifest_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.manifest_name = input;
            self
        }
        /// The HTTP Live Streaming (HLS) playlist type.
        /// When either "EVENT" or "VOD" is specified, a corresponding EXT-X-PLAYLIST-TYPE
        /// entry will be included in the media playlist.
        pub fn playlist_type(mut self, input: crate::model::PlaylistType) -> Self {
            self.playlist_type = Some(input);
            self
        }
        /// The HTTP Live Streaming (HLS) playlist type.
        /// When either "EVENT" or "VOD" is specified, a corresponding EXT-X-PLAYLIST-TYPE
        /// entry will be included in the media playlist.
        pub fn set_playlist_type(
            mut self,
            input: std::option::Option<crate::model::PlaylistType>,
        ) -> Self {
            self.playlist_type = input;
            self
        }
        /// Time window (in seconds) contained in each parent manifest.
        pub fn playlist_window_seconds(mut self, input: i32) -> Self {
            self.playlist_window_seconds = Some(input);
            self
        }
        /// Time window (in seconds) contained in each parent manifest.
        pub fn set_playlist_window_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.playlist_window_seconds = input;
            self
        }
        /// The interval (in seconds) between each EXT-X-PROGRAM-DATE-TIME tag
        /// inserted into manifests. Additionally, when an interval is specified
        /// ID3Timed Metadata messages will be generated every 5 seconds using the
        /// ingest time of the content.
        /// If the interval is not specified, or set to 0, then
        /// no EXT-X-PROGRAM-DATE-TIME tags will be inserted into manifests and no
        /// ID3Timed Metadata messages will be generated. Note that irrespective
        /// of this parameter, if any ID3 Timed Metadata is found in HTTP Live Streaming (HLS) input,
        /// it will be passed through to HLS output.
        pub fn program_date_time_interval_seconds(mut self, input: i32) -> Self {
            self.program_date_time_interval_seconds = Some(input);
            self
        }
        /// The interval (in seconds) between each EXT-X-PROGRAM-DATE-TIME tag
        /// inserted into manifests. Additionally, when an interval is specified
        /// ID3Timed Metadata messages will be generated every 5 seconds using the
        /// ingest time of the content.
        /// If the interval is not specified, or set to 0, then
        /// no EXT-X-PROGRAM-DATE-TIME tags will be inserted into manifests and no
        /// ID3Timed Metadata messages will be generated. Note that irrespective
        /// of this parameter, if any ID3 Timed Metadata is found in HTTP Live Streaming (HLS) input,
        /// it will be passed through to HLS output.
        pub fn set_program_date_time_interval_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.program_date_time_interval_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`HlsManifestCreateOrUpdateParameters`](crate::model::HlsManifestCreateOrUpdateParameters)
        pub fn build(self) -> crate::model::HlsManifestCreateOrUpdateParameters {
            crate::model::HlsManifestCreateOrUpdateParameters {
                ad_markers: self.ad_markers,
                ad_triggers: self.ad_triggers,
                ads_on_delivery_restrictions: self.ads_on_delivery_restrictions,
                id: self.id,
                include_iframe_only_stream: self.include_iframe_only_stream.unwrap_or_default(),
                manifest_name: self.manifest_name,
                playlist_type: self.playlist_type,
                playlist_window_seconds: self.playlist_window_seconds.unwrap_or_default(),
                program_date_time_interval_seconds: self
                    .program_date_time_interval_seconds
                    .unwrap_or_default(),
            }
        }
    }
}
impl HlsManifestCreateOrUpdateParameters {
    /// Creates a new builder-style object to manufacture [`HlsManifestCreateOrUpdateParameters`](crate::model::HlsManifestCreateOrUpdateParameters)
    pub fn builder() -> crate::model::hls_manifest_create_or_update_parameters::Builder {
        crate::model::hls_manifest_create_or_update_parameters::Builder::default()
    }
}

/// Configure ingress access logging.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IngressAccessLogs {
    /// Customize the log group name.
    pub log_group_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for IngressAccessLogs {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IngressAccessLogs");
        formatter.field("log_group_name", &self.log_group_name);
        formatter.finish()
    }
}
/// See [`IngressAccessLogs`](crate::model::IngressAccessLogs)
pub mod ingress_access_logs {
    /// A builder for [`IngressAccessLogs`](crate::model::IngressAccessLogs)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) log_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Customize the log group name.
        pub fn log_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_group_name = Some(input.into());
            self
        }
        /// Customize the log group name.
        pub fn set_log_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.log_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`IngressAccessLogs`](crate::model::IngressAccessLogs)
        pub fn build(self) -> crate::model::IngressAccessLogs {
            crate::model::IngressAccessLogs {
                log_group_name: self.log_group_name,
            }
        }
    }
}
impl IngressAccessLogs {
    /// Creates a new builder-style object to manufacture [`IngressAccessLogs`](crate::model::IngressAccessLogs)
    pub fn builder() -> crate::model::ingress_access_logs::Builder {
        crate::model::ingress_access_logs::Builder::default()
    }
}

/// An HTTP Live Streaming (HLS) ingest resource configuration.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HlsIngest {
    /// A list of endpoints to which the source stream should be sent.
    pub ingest_endpoints: std::option::Option<std::vec::Vec<crate::model::IngestEndpoint>>,
}
impl std::fmt::Debug for HlsIngest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HlsIngest");
        formatter.field("ingest_endpoints", &self.ingest_endpoints);
        formatter.finish()
    }
}
/// See [`HlsIngest`](crate::model::HlsIngest)
pub mod hls_ingest {
    /// A builder for [`HlsIngest`](crate::model::HlsIngest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ingest_endpoints:
            std::option::Option<std::vec::Vec<crate::model::IngestEndpoint>>,
    }
    impl Builder {
        /// Appends an item to `ingest_endpoints`.
        ///
        /// To override the contents of this collection use [`set_ingest_endpoints`](Self::set_ingest_endpoints).
        ///
        /// A list of endpoints to which the source stream should be sent.
        pub fn ingest_endpoints(mut self, input: impl Into<crate::model::IngestEndpoint>) -> Self {
            let mut v = self.ingest_endpoints.unwrap_or_default();
            v.push(input.into());
            self.ingest_endpoints = Some(v);
            self
        }
        /// A list of endpoints to which the source stream should be sent.
        pub fn set_ingest_endpoints(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IngestEndpoint>>,
        ) -> Self {
            self.ingest_endpoints = input;
            self
        }
        /// Consumes the builder and constructs a [`HlsIngest`](crate::model::HlsIngest)
        pub fn build(self) -> crate::model::HlsIngest {
            crate::model::HlsIngest {
                ingest_endpoints: self.ingest_endpoints,
            }
        }
    }
}
impl HlsIngest {
    /// Creates a new builder-style object to manufacture [`HlsIngest`](crate::model::HlsIngest)
    pub fn builder() -> crate::model::hls_ingest::Builder {
        crate::model::hls_ingest::Builder::default()
    }
}

/// An endpoint for ingesting source content for a Channel.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IngestEndpoint {
    /// The system generated unique identifier for the IngestEndpoint
    pub id: std::option::Option<std::string::String>,
    /// The system generated password for ingest authentication.
    pub password: std::option::Option<std::string::String>,
    /// The ingest URL to which the source stream should be sent.
    pub url: std::option::Option<std::string::String>,
    /// The system generated username for ingest authentication.
    pub username: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for IngestEndpoint {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IngestEndpoint");
        formatter.field("id", &self.id);
        formatter.field("password", &self.password);
        formatter.field("url", &self.url);
        formatter.field("username", &self.username);
        formatter.finish()
    }
}
/// See [`IngestEndpoint`](crate::model::IngestEndpoint)
pub mod ingest_endpoint {
    /// A builder for [`IngestEndpoint`](crate::model::IngestEndpoint)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) password: std::option::Option<std::string::String>,
        pub(crate) url: std::option::Option<std::string::String>,
        pub(crate) username: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The system generated unique identifier for the IngestEndpoint
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// The system generated unique identifier for the IngestEndpoint
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// The system generated password for ingest authentication.
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.password = Some(input.into());
            self
        }
        /// The system generated password for ingest authentication.
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.password = input;
            self
        }
        /// The ingest URL to which the source stream should be sent.
        pub fn url(mut self, input: impl Into<std::string::String>) -> Self {
            self.url = Some(input.into());
            self
        }
        /// The ingest URL to which the source stream should be sent.
        pub fn set_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.url = input;
            self
        }
        /// The system generated username for ingest authentication.
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// The system generated username for ingest authentication.
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// Consumes the builder and constructs a [`IngestEndpoint`](crate::model::IngestEndpoint)
        pub fn build(self) -> crate::model::IngestEndpoint {
            crate::model::IngestEndpoint {
                id: self.id,
                password: self.password,
                url: self.url,
                username: self.username,
            }
        }
    }
}
impl IngestEndpoint {
    /// Creates a new builder-style object to manufacture [`IngestEndpoint`](crate::model::IngestEndpoint)
    pub fn builder() -> crate::model::ingest_endpoint::Builder {
        crate::model::ingest_endpoint::Builder::default()
    }
}

/// Configure egress access logging.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EgressAccessLogs {
    /// Customize the log group name.
    pub log_group_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for EgressAccessLogs {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EgressAccessLogs");
        formatter.field("log_group_name", &self.log_group_name);
        formatter.finish()
    }
}
/// See [`EgressAccessLogs`](crate::model::EgressAccessLogs)
pub mod egress_access_logs {
    /// A builder for [`EgressAccessLogs`](crate::model::EgressAccessLogs)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) log_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Customize the log group name.
        pub fn log_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_group_name = Some(input.into());
            self
        }
        /// Customize the log group name.
        pub fn set_log_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.log_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`EgressAccessLogs`](crate::model::EgressAccessLogs)
        pub fn build(self) -> crate::model::EgressAccessLogs {
            crate::model::EgressAccessLogs {
                log_group_name: self.log_group_name,
            }
        }
    }
}
impl EgressAccessLogs {
    /// Creates a new builder-style object to manufacture [`EgressAccessLogs`](crate::model::EgressAccessLogs)
    pub fn builder() -> crate::model::egress_access_logs::Builder {
        crate::model::egress_access_logs::Builder::default()
    }
}

/// An OriginEndpoint resource configuration.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OriginEndpoint {
    /// The Amazon Resource Name (ARN) assigned to the OriginEndpoint.
    pub arn: std::option::Option<std::string::String>,
    /// CDN Authorization credentials
    pub authorization: std::option::Option<crate::model::Authorization>,
    /// The ID of the Channel the OriginEndpoint is associated with.
    pub channel_id: std::option::Option<std::string::String>,
    /// A Common Media Application Format (CMAF) packaging configuration.
    pub cmaf_package: std::option::Option<crate::model::CmafPackage>,
    /// A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
    pub dash_package: std::option::Option<crate::model::DashPackage>,
    /// A short text description of the OriginEndpoint.
    pub description: std::option::Option<std::string::String>,
    /// An HTTP Live Streaming (HLS) packaging configuration.
    pub hls_package: std::option::Option<crate::model::HlsPackage>,
    /// The ID of the OriginEndpoint.
    pub id: std::option::Option<std::string::String>,
    /// A short string appended to the end of the OriginEndpoint URL.
    pub manifest_name: std::option::Option<std::string::String>,
    /// A Microsoft Smooth Streaming (MSS) packaging configuration.
    pub mss_package: std::option::Option<crate::model::MssPackage>,
    /// Control whether origination of video is allowed for this OriginEndpoint. If set to ALLOW, the OriginEndpoint
    /// may by requested, pursuant to any other form of access control. If set to DENY, the OriginEndpoint may not be
    /// requested. This can be helpful for Live to VOD harvesting, or for temporarily disabling origination
    pub origination: std::option::Option<crate::model::Origination>,
    /// Maximum duration (seconds) of content to retain for startover playback.
    /// If not specified, startover playback will be disabled for the OriginEndpoint.
    pub startover_window_seconds: i32,
    /// A collection of tags associated with a resource
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// Amount of delay (seconds) to enforce on the playback of live content.
    /// If not specified, there will be no time delay in effect for the OriginEndpoint.
    pub time_delay_seconds: i32,
    /// The URL of the packaged OriginEndpoint for consumption.
    pub url: std::option::Option<std::string::String>,
    /// A list of source IP CIDR blocks that will be allowed to access the OriginEndpoint.
    pub whitelist: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for OriginEndpoint {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OriginEndpoint");
        formatter.field("arn", &self.arn);
        formatter.field("authorization", &self.authorization);
        formatter.field("channel_id", &self.channel_id);
        formatter.field("cmaf_package", &self.cmaf_package);
        formatter.field("dash_package", &self.dash_package);
        formatter.field("description", &self.description);
        formatter.field("hls_package", &self.hls_package);
        formatter.field("id", &self.id);
        formatter.field("manifest_name", &self.manifest_name);
        formatter.field("mss_package", &self.mss_package);
        formatter.field("origination", &self.origination);
        formatter.field("startover_window_seconds", &self.startover_window_seconds);
        formatter.field("tags", &self.tags);
        formatter.field("time_delay_seconds", &self.time_delay_seconds);
        formatter.field("url", &self.url);
        formatter.field("whitelist", &self.whitelist);
        formatter.finish()
    }
}
/// See [`OriginEndpoint`](crate::model::OriginEndpoint)
pub mod origin_endpoint {
    /// A builder for [`OriginEndpoint`](crate::model::OriginEndpoint)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) authorization: std::option::Option<crate::model::Authorization>,
        pub(crate) channel_id: std::option::Option<std::string::String>,
        pub(crate) cmaf_package: std::option::Option<crate::model::CmafPackage>,
        pub(crate) dash_package: std::option::Option<crate::model::DashPackage>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) hls_package: std::option::Option<crate::model::HlsPackage>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) manifest_name: std::option::Option<std::string::String>,
        pub(crate) mss_package: std::option::Option<crate::model::MssPackage>,
        pub(crate) origination: std::option::Option<crate::model::Origination>,
        pub(crate) startover_window_seconds: std::option::Option<i32>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) time_delay_seconds: std::option::Option<i32>,
        pub(crate) url: std::option::Option<std::string::String>,
        pub(crate) whitelist: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// The Amazon Resource Name (ARN) assigned to the OriginEndpoint.
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) assigned to the OriginEndpoint.
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// CDN Authorization credentials
        pub fn authorization(mut self, input: crate::model::Authorization) -> Self {
            self.authorization = Some(input);
            self
        }
        /// CDN Authorization credentials
        pub fn set_authorization(
            mut self,
            input: std::option::Option<crate::model::Authorization>,
        ) -> Self {
            self.authorization = input;
            self
        }
        /// The ID of the Channel the OriginEndpoint is associated with.
        pub fn channel_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_id = Some(input.into());
            self
        }
        /// The ID of the Channel the OriginEndpoint is associated with.
        pub fn set_channel_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_id = input;
            self
        }
        /// A Common Media Application Format (CMAF) packaging configuration.
        pub fn cmaf_package(mut self, input: crate::model::CmafPackage) -> Self {
            self.cmaf_package = Some(input);
            self
        }
        /// A Common Media Application Format (CMAF) packaging configuration.
        pub fn set_cmaf_package(
            mut self,
            input: std::option::Option<crate::model::CmafPackage>,
        ) -> Self {
            self.cmaf_package = input;
            self
        }
        /// A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
        pub fn dash_package(mut self, input: crate::model::DashPackage) -> Self {
            self.dash_package = Some(input);
            self
        }
        /// A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
        pub fn set_dash_package(
            mut self,
            input: std::option::Option<crate::model::DashPackage>,
        ) -> Self {
            self.dash_package = input;
            self
        }
        /// A short text description of the OriginEndpoint.
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// A short text description of the OriginEndpoint.
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// An HTTP Live Streaming (HLS) packaging configuration.
        pub fn hls_package(mut self, input: crate::model::HlsPackage) -> Self {
            self.hls_package = Some(input);
            self
        }
        /// An HTTP Live Streaming (HLS) packaging configuration.
        pub fn set_hls_package(
            mut self,
            input: std::option::Option<crate::model::HlsPackage>,
        ) -> Self {
            self.hls_package = input;
            self
        }
        /// The ID of the OriginEndpoint.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// The ID of the OriginEndpoint.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// A short string appended to the end of the OriginEndpoint URL.
        pub fn manifest_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.manifest_name = Some(input.into());
            self
        }
        /// A short string appended to the end of the OriginEndpoint URL.
        pub fn set_manifest_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.manifest_name = input;
            self
        }
        /// A Microsoft Smooth Streaming (MSS) packaging configuration.
        pub fn mss_package(mut self, input: crate::model::MssPackage) -> Self {
            self.mss_package = Some(input);
            self
        }
        /// A Microsoft Smooth Streaming (MSS) packaging configuration.
        pub fn set_mss_package(
            mut self,
            input: std::option::Option<crate::model::MssPackage>,
        ) -> Self {
            self.mss_package = input;
            self
        }
        /// Control whether origination of video is allowed for this OriginEndpoint. If set to ALLOW, the OriginEndpoint
        /// may by requested, pursuant to any other form of access control. If set to DENY, the OriginEndpoint may not be
        /// requested. This can be helpful for Live to VOD harvesting, or for temporarily disabling origination
        pub fn origination(mut self, input: crate::model::Origination) -> Self {
            self.origination = Some(input);
            self
        }
        /// Control whether origination of video is allowed for this OriginEndpoint. If set to ALLOW, the OriginEndpoint
        /// may by requested, pursuant to any other form of access control. If set to DENY, the OriginEndpoint may not be
        /// requested. This can be helpful for Live to VOD harvesting, or for temporarily disabling origination
        pub fn set_origination(
            mut self,
            input: std::option::Option<crate::model::Origination>,
        ) -> Self {
            self.origination = input;
            self
        }
        /// Maximum duration (seconds) of content to retain for startover playback.
        /// If not specified, startover playback will be disabled for the OriginEndpoint.
        pub fn startover_window_seconds(mut self, input: i32) -> Self {
            self.startover_window_seconds = Some(input);
            self
        }
        /// Maximum duration (seconds) of content to retain for startover playback.
        /// If not specified, startover playback will be disabled for the OriginEndpoint.
        pub fn set_startover_window_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.startover_window_seconds = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of tags associated with a resource
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// A collection of tags associated with a resource
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Amount of delay (seconds) to enforce on the playback of live content.
        /// If not specified, there will be no time delay in effect for the OriginEndpoint.
        pub fn time_delay_seconds(mut self, input: i32) -> Self {
            self.time_delay_seconds = Some(input);
            self
        }
        /// Amount of delay (seconds) to enforce on the playback of live content.
        /// If not specified, there will be no time delay in effect for the OriginEndpoint.
        pub fn set_time_delay_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.time_delay_seconds = input;
            self
        }
        /// The URL of the packaged OriginEndpoint for consumption.
        pub fn url(mut self, input: impl Into<std::string::String>) -> Self {
            self.url = Some(input.into());
            self
        }
        /// The URL of the packaged OriginEndpoint for consumption.
        pub fn set_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.url = input;
            self
        }
        /// Appends an item to `whitelist`.
        ///
        /// To override the contents of this collection use [`set_whitelist`](Self::set_whitelist).
        ///
        /// A list of source IP CIDR blocks that will be allowed to access the OriginEndpoint.
        pub fn whitelist(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.whitelist.unwrap_or_default();
            v.push(input.into());
            self.whitelist = Some(v);
            self
        }
        /// A list of source IP CIDR blocks that will be allowed to access the OriginEndpoint.
        pub fn set_whitelist(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.whitelist = input;
            self
        }
        /// Consumes the builder and constructs a [`OriginEndpoint`](crate::model::OriginEndpoint)
        pub fn build(self) -> crate::model::OriginEndpoint {
            crate::model::OriginEndpoint {
                arn: self.arn,
                authorization: self.authorization,
                channel_id: self.channel_id,
                cmaf_package: self.cmaf_package,
                dash_package: self.dash_package,
                description: self.description,
                hls_package: self.hls_package,
                id: self.id,
                manifest_name: self.manifest_name,
                mss_package: self.mss_package,
                origination: self.origination,
                startover_window_seconds: self.startover_window_seconds.unwrap_or_default(),
                tags: self.tags,
                time_delay_seconds: self.time_delay_seconds.unwrap_or_default(),
                url: self.url,
                whitelist: self.whitelist,
            }
        }
    }
}
impl OriginEndpoint {
    /// Creates a new builder-style object to manufacture [`OriginEndpoint`](crate::model::OriginEndpoint)
    pub fn builder() -> crate::model::origin_endpoint::Builder {
        crate::model::origin_endpoint::Builder::default()
    }
}

/// A HarvestJob resource configuration
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HarvestJob {
    /// The Amazon Resource Name (ARN) assigned to the HarvestJob.
    pub arn: std::option::Option<std::string::String>,
    /// The ID of the Channel that the HarvestJob will harvest from.
    pub channel_id: std::option::Option<std::string::String>,
    /// The time the HarvestJob was submitted
    pub created_at: std::option::Option<std::string::String>,
    /// The end of the time-window which will be harvested.
    pub end_time: std::option::Option<std::string::String>,
    /// The ID of the HarvestJob. The ID must be unique within the region
    /// and it cannot be changed after the HarvestJob is submitted.
    pub id: std::option::Option<std::string::String>,
    /// The ID of the OriginEndpoint that the HarvestJob will harvest from.
    /// This cannot be changed after the HarvestJob is submitted.
    pub origin_endpoint_id: std::option::Option<std::string::String>,
    /// Configuration parameters for where in an S3 bucket to place the harvested content
    pub s3_destination: std::option::Option<crate::model::S3Destination>,
    /// The start of the time-window which will be harvested.
    pub start_time: std::option::Option<std::string::String>,
    /// The current status of the HarvestJob. Consider setting up a CloudWatch Event to listen for
    /// HarvestJobs as they succeed or fail. In the event of failure, the CloudWatch Event will
    /// include an explanation of why the HarvestJob failed.
    pub status: std::option::Option<crate::model::Status>,
}
impl std::fmt::Debug for HarvestJob {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HarvestJob");
        formatter.field("arn", &self.arn);
        formatter.field("channel_id", &self.channel_id);
        formatter.field("created_at", &self.created_at);
        formatter.field("end_time", &self.end_time);
        formatter.field("id", &self.id);
        formatter.field("origin_endpoint_id", &self.origin_endpoint_id);
        formatter.field("s3_destination", &self.s3_destination);
        formatter.field("start_time", &self.start_time);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`HarvestJob`](crate::model::HarvestJob)
pub mod harvest_job {
    /// A builder for [`HarvestJob`](crate::model::HarvestJob)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) channel_id: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<std::string::String>,
        pub(crate) end_time: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) origin_endpoint_id: std::option::Option<std::string::String>,
        pub(crate) s3_destination: std::option::Option<crate::model::S3Destination>,
        pub(crate) start_time: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::Status>,
    }
    impl Builder {
        /// The Amazon Resource Name (ARN) assigned to the HarvestJob.
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) assigned to the HarvestJob.
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// The ID of the Channel that the HarvestJob will harvest from.
        pub fn channel_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_id = Some(input.into());
            self
        }
        /// The ID of the Channel that the HarvestJob will harvest from.
        pub fn set_channel_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_id = input;
            self
        }
        /// The time the HarvestJob was submitted
        pub fn created_at(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_at = Some(input.into());
            self
        }
        /// The time the HarvestJob was submitted
        pub fn set_created_at(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_at = input;
            self
        }
        /// The end of the time-window which will be harvested.
        pub fn end_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.end_time = Some(input.into());
            self
        }
        /// The end of the time-window which will be harvested.
        pub fn set_end_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.end_time = input;
            self
        }
        /// The ID of the HarvestJob. The ID must be unique within the region
        /// and it cannot be changed after the HarvestJob is submitted.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// The ID of the HarvestJob. The ID must be unique within the region
        /// and it cannot be changed after the HarvestJob is submitted.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// The ID of the OriginEndpoint that the HarvestJob will harvest from.
        /// This cannot be changed after the HarvestJob is submitted.
        pub fn origin_endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.origin_endpoint_id = Some(input.into());
            self
        }
        /// The ID of the OriginEndpoint that the HarvestJob will harvest from.
        /// This cannot be changed after the HarvestJob is submitted.
        pub fn set_origin_endpoint_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.origin_endpoint_id = input;
            self
        }
        /// Configuration parameters for where in an S3 bucket to place the harvested content
        pub fn s3_destination(mut self, input: crate::model::S3Destination) -> Self {
            self.s3_destination = Some(input);
            self
        }
        /// Configuration parameters for where in an S3 bucket to place the harvested content
        pub fn set_s3_destination(
            mut self,
            input: std::option::Option<crate::model::S3Destination>,
        ) -> Self {
            self.s3_destination = input;
            self
        }
        /// The start of the time-window which will be harvested.
        pub fn start_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.start_time = Some(input.into());
            self
        }
        /// The start of the time-window which will be harvested.
        pub fn set_start_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.start_time = input;
            self
        }
        /// The current status of the HarvestJob. Consider setting up a CloudWatch Event to listen for
        /// HarvestJobs as they succeed or fail. In the event of failure, the CloudWatch Event will
        /// include an explanation of why the HarvestJob failed.
        pub fn status(mut self, input: crate::model::Status) -> Self {
            self.status = Some(input);
            self
        }
        /// The current status of the HarvestJob. Consider setting up a CloudWatch Event to listen for
        /// HarvestJobs as they succeed or fail. In the event of failure, the CloudWatch Event will
        /// include an explanation of why the HarvestJob failed.
        pub fn set_status(mut self, input: std::option::Option<crate::model::Status>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`HarvestJob`](crate::model::HarvestJob)
        pub fn build(self) -> crate::model::HarvestJob {
            crate::model::HarvestJob {
                arn: self.arn,
                channel_id: self.channel_id,
                created_at: self.created_at,
                end_time: self.end_time,
                id: self.id,
                origin_endpoint_id: self.origin_endpoint_id,
                s3_destination: self.s3_destination,
                start_time: self.start_time,
                status: self.status,
            }
        }
    }
}
impl HarvestJob {
    /// Creates a new builder-style object to manufacture [`HarvestJob`](crate::model::HarvestJob)
    pub fn builder() -> crate::model::harvest_job::Builder {
        crate::model::harvest_job::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Status {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Status {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => Status::Failed,
            "IN_PROGRESS" => Status::InProgress,
            "SUCCEEDED" => Status::Succeeded,
            other => Status::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Status {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Status::from(s))
    }
}
impl Status {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Status::Failed => "FAILED",
            Status::InProgress => "IN_PROGRESS",
            Status::Succeeded => "SUCCEEDED",
            Status::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAILED", "IN_PROGRESS", "SUCCEEDED"]
    }
}
impl AsRef<str> for Status {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Configuration parameters for where in an S3 bucket to place the harvested content
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3Destination {
    /// The name of an S3 bucket within which harvested content will be exported
    pub bucket_name: std::option::Option<std::string::String>,
    /// The key in the specified S3 bucket where the harvested top-level manifest will be placed.
    pub manifest_key: std::option::Option<std::string::String>,
    /// The IAM role used to write to the specified S3 bucket
    pub role_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for S3Destination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3Destination");
        formatter.field("bucket_name", &self.bucket_name);
        formatter.field("manifest_key", &self.manifest_key);
        formatter.field("role_arn", &self.role_arn);
        formatter.finish()
    }
}
/// See [`S3Destination`](crate::model::S3Destination)
pub mod s3_destination {
    /// A builder for [`S3Destination`](crate::model::S3Destination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket_name: std::option::Option<std::string::String>,
        pub(crate) manifest_key: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The name of an S3 bucket within which harvested content will be exported
        pub fn bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_name = Some(input.into());
            self
        }
        /// The name of an S3 bucket within which harvested content will be exported
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_name = input;
            self
        }
        /// The key in the specified S3 bucket where the harvested top-level manifest will be placed.
        pub fn manifest_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.manifest_key = Some(input.into());
            self
        }
        /// The key in the specified S3 bucket where the harvested top-level manifest will be placed.
        pub fn set_manifest_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.manifest_key = input;
            self
        }
        /// The IAM role used to write to the specified S3 bucket
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// The IAM role used to write to the specified S3 bucket
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`S3Destination`](crate::model::S3Destination)
        pub fn build(self) -> crate::model::S3Destination {
            crate::model::S3Destination {
                bucket_name: self.bucket_name,
                manifest_key: self.manifest_key,
                role_arn: self.role_arn,
            }
        }
    }
}
impl S3Destination {
    /// Creates a new builder-style object to manufacture [`S3Destination`](crate::model::S3Destination)
    pub fn builder() -> crate::model::s3_destination::Builder {
        crate::model::s3_destination::Builder::default()
    }
}

/// A Channel resource configuration.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Channel {
    /// The Amazon Resource Name (ARN) assigned to the Channel.
    pub arn: std::option::Option<std::string::String>,
    /// A short text description of the Channel.
    pub description: std::option::Option<std::string::String>,
    /// Configure egress access logging.
    pub egress_access_logs: std::option::Option<crate::model::EgressAccessLogs>,
    /// An HTTP Live Streaming (HLS) ingest resource configuration.
    pub hls_ingest: std::option::Option<crate::model::HlsIngest>,
    /// The ID of the Channel.
    pub id: std::option::Option<std::string::String>,
    /// Configure ingress access logging.
    pub ingress_access_logs: std::option::Option<crate::model::IngressAccessLogs>,
    /// A collection of tags associated with a resource
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for Channel {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Channel");
        formatter.field("arn", &self.arn);
        formatter.field("description", &self.description);
        formatter.field("egress_access_logs", &self.egress_access_logs);
        formatter.field("hls_ingest", &self.hls_ingest);
        formatter.field("id", &self.id);
        formatter.field("ingress_access_logs", &self.ingress_access_logs);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`Channel`](crate::model::Channel)
pub mod channel {
    /// A builder for [`Channel`](crate::model::Channel)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) egress_access_logs: std::option::Option<crate::model::EgressAccessLogs>,
        pub(crate) hls_ingest: std::option::Option<crate::model::HlsIngest>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) ingress_access_logs: std::option::Option<crate::model::IngressAccessLogs>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// The Amazon Resource Name (ARN) assigned to the Channel.
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) assigned to the Channel.
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// A short text description of the Channel.
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// A short text description of the Channel.
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Configure egress access logging.
        pub fn egress_access_logs(mut self, input: crate::model::EgressAccessLogs) -> Self {
            self.egress_access_logs = Some(input);
            self
        }
        /// Configure egress access logging.
        pub fn set_egress_access_logs(
            mut self,
            input: std::option::Option<crate::model::EgressAccessLogs>,
        ) -> Self {
            self.egress_access_logs = input;
            self
        }
        /// An HTTP Live Streaming (HLS) ingest resource configuration.
        pub fn hls_ingest(mut self, input: crate::model::HlsIngest) -> Self {
            self.hls_ingest = Some(input);
            self
        }
        /// An HTTP Live Streaming (HLS) ingest resource configuration.
        pub fn set_hls_ingest(
            mut self,
            input: std::option::Option<crate::model::HlsIngest>,
        ) -> Self {
            self.hls_ingest = input;
            self
        }
        /// The ID of the Channel.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// The ID of the Channel.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Configure ingress access logging.
        pub fn ingress_access_logs(mut self, input: crate::model::IngressAccessLogs) -> Self {
            self.ingress_access_logs = Some(input);
            self
        }
        /// Configure ingress access logging.
        pub fn set_ingress_access_logs(
            mut self,
            input: std::option::Option<crate::model::IngressAccessLogs>,
        ) -> Self {
            self.ingress_access_logs = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of tags associated with a resource
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// A collection of tags associated with a resource
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`Channel`](crate::model::Channel)
        pub fn build(self) -> crate::model::Channel {
            crate::model::Channel {
                arn: self.arn,
                description: self.description,
                egress_access_logs: self.egress_access_logs,
                hls_ingest: self.hls_ingest,
                id: self.id,
                ingress_access_logs: self.ingress_access_logs,
                tags: self.tags,
            }
        }
    }
}
impl Channel {
    /// Creates a new builder-style object to manufacture [`Channel`](crate::model::Channel)
    pub fn builder() -> crate::model::channel::Builder {
        crate::model::channel::Builder::default()
    }
}
