// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AcceptInputDeviceTransferInput`](crate::input::AcceptInputDeviceTransferInput)
pub mod accept_input_device_transfer_input {
    /// A builder for [`AcceptInputDeviceTransferInput`](crate::input::AcceptInputDeviceTransferInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input_device_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The unique ID of the input device to accept. For example, hd-123456789abcdef.
        pub fn input_device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_device_id = Some(input.into());
            self
        }
        /// The unique ID of the input device to accept. For example, hd-123456789abcdef.
        pub fn set_input_device_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.input_device_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AcceptInputDeviceTransferInput`](crate::input::AcceptInputDeviceTransferInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AcceptInputDeviceTransferInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AcceptInputDeviceTransferInput {
                input_device_id: self.input_device_id,
            })
        }
    }
}
#[doc(hidden)]
pub type AcceptInputDeviceTransferInputOperationOutputAlias =
    crate::operation::AcceptInputDeviceTransfer;
#[doc(hidden)]
pub type AcceptInputDeviceTransferInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AcceptInputDeviceTransferInput {
    /// Consumes the builder and constructs an Operation<[`AcceptInputDeviceTransfer`](crate::operation::AcceptInputDeviceTransfer)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AcceptInputDeviceTransfer,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AcceptInputDeviceTransferInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.input_device_id;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "input_device_id",
                        details: "cannot be empty or unset",
                    })?;
            let input_device_id = aws_smithy_http::label::fmt_string(input_1, false);
            if input_device_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "input_device_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/prod/inputDevices/{InputDeviceId}/accept",
                InputDeviceId = input_device_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AcceptInputDeviceTransferInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AcceptInputDeviceTransferInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AcceptInputDeviceTransfer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AcceptInputDeviceTransfer",
            "medialive",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AcceptInputDeviceTransferInput`](crate::input::AcceptInputDeviceTransferInput)
    pub fn builder() -> crate::input::accept_input_device_transfer_input::Builder {
        crate::input::accept_input_device_transfer_input::Builder::default()
    }
}

/// See [`BatchDeleteInput`](crate::input::BatchDeleteInput)
pub mod batch_delete_input {
    /// A builder for [`BatchDeleteInput`](crate::input::BatchDeleteInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) input_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) input_security_group_ids:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) multiplex_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `channel_ids`.
        ///
        /// To override the contents of this collection use [`set_channel_ids`](Self::set_channel_ids).
        ///
        /// List of channel IDs
        pub fn channel_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.channel_ids.unwrap_or_default();
            v.push(input.into());
            self.channel_ids = Some(v);
            self
        }
        /// List of channel IDs
        pub fn set_channel_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.channel_ids = input;
            self
        }
        /// Appends an item to `input_ids`.
        ///
        /// To override the contents of this collection use [`set_input_ids`](Self::set_input_ids).
        ///
        /// List of input IDs
        pub fn input_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.input_ids.unwrap_or_default();
            v.push(input.into());
            self.input_ids = Some(v);
            self
        }
        /// List of input IDs
        pub fn set_input_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.input_ids = input;
            self
        }
        /// Appends an item to `input_security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_input_security_group_ids`](Self::set_input_security_group_ids).
        ///
        /// List of input security group IDs
        pub fn input_security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.input_security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.input_security_group_ids = Some(v);
            self
        }
        /// List of input security group IDs
        pub fn set_input_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.input_security_group_ids = input;
            self
        }
        /// Appends an item to `multiplex_ids`.
        ///
        /// To override the contents of this collection use [`set_multiplex_ids`](Self::set_multiplex_ids).
        ///
        /// List of multiplex IDs
        pub fn multiplex_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.multiplex_ids.unwrap_or_default();
            v.push(input.into());
            self.multiplex_ids = Some(v);
            self
        }
        /// List of multiplex IDs
        pub fn set_multiplex_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.multiplex_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDeleteInput`](crate::input::BatchDeleteInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchDeleteInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchDeleteInput {
                channel_ids: self.channel_ids,
                input_ids: self.input_ids,
                input_security_group_ids: self.input_security_group_ids,
                multiplex_ids: self.multiplex_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchDeleteInputOperationOutputAlias = crate::operation::BatchDelete;
#[doc(hidden)]
pub type BatchDeleteInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl BatchDeleteInput {
    /// Consumes the builder and constructs an Operation<[`BatchDelete`](crate::operation::BatchDelete)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchDelete,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchDeleteInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/prod/batch/delete").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchDeleteInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchDeleteInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_batch_delete(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchDelete::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchDelete",
            "medialive",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchDeleteInput`](crate::input::BatchDeleteInput)
    pub fn builder() -> crate::input::batch_delete_input::Builder {
        crate::input::batch_delete_input::Builder::default()
    }
}

/// See [`BatchStartInput`](crate::input::BatchStartInput)
pub mod batch_start_input {
    /// A builder for [`BatchStartInput`](crate::input::BatchStartInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) multiplex_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `channel_ids`.
        ///
        /// To override the contents of this collection use [`set_channel_ids`](Self::set_channel_ids).
        ///
        /// List of channel IDs
        pub fn channel_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.channel_ids.unwrap_or_default();
            v.push(input.into());
            self.channel_ids = Some(v);
            self
        }
        /// List of channel IDs
        pub fn set_channel_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.channel_ids = input;
            self
        }
        /// Appends an item to `multiplex_ids`.
        ///
        /// To override the contents of this collection use [`set_multiplex_ids`](Self::set_multiplex_ids).
        ///
        /// List of multiplex IDs
        pub fn multiplex_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.multiplex_ids.unwrap_or_default();
            v.push(input.into());
            self.multiplex_ids = Some(v);
            self
        }
        /// List of multiplex IDs
        pub fn set_multiplex_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.multiplex_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchStartInput`](crate::input::BatchStartInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchStartInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchStartInput {
                channel_ids: self.channel_ids,
                multiplex_ids: self.multiplex_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchStartInputOperationOutputAlias = crate::operation::BatchStart;
#[doc(hidden)]
pub type BatchStartInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl BatchStartInput {
    /// Consumes the builder and constructs an Operation<[`BatchStart`](crate::operation::BatchStart)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchStart,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchStartInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/prod/batch/start").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchStartInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchStartInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_batch_start(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchStart::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchStart",
            "medialive",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchStartInput`](crate::input::BatchStartInput)
    pub fn builder() -> crate::input::batch_start_input::Builder {
        crate::input::batch_start_input::Builder::default()
    }
}

/// See [`BatchStopInput`](crate::input::BatchStopInput)
pub mod batch_stop_input {
    /// A builder for [`BatchStopInput`](crate::input::BatchStopInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) multiplex_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `channel_ids`.
        ///
        /// To override the contents of this collection use [`set_channel_ids`](Self::set_channel_ids).
        ///
        /// List of channel IDs
        pub fn channel_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.channel_ids.unwrap_or_default();
            v.push(input.into());
            self.channel_ids = Some(v);
            self
        }
        /// List of channel IDs
        pub fn set_channel_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.channel_ids = input;
            self
        }
        /// Appends an item to `multiplex_ids`.
        ///
        /// To override the contents of this collection use [`set_multiplex_ids`](Self::set_multiplex_ids).
        ///
        /// List of multiplex IDs
        pub fn multiplex_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.multiplex_ids.unwrap_or_default();
            v.push(input.into());
            self.multiplex_ids = Some(v);
            self
        }
        /// List of multiplex IDs
        pub fn set_multiplex_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.multiplex_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchStopInput`](crate::input::BatchStopInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::BatchStopInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::BatchStopInput {
                channel_ids: self.channel_ids,
                multiplex_ids: self.multiplex_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchStopInputOperationOutputAlias = crate::operation::BatchStop;
#[doc(hidden)]
pub type BatchStopInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl BatchStopInput {
    /// Consumes the builder and constructs an Operation<[`BatchStop`](crate::operation::BatchStop)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchStop,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchStopInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/prod/batch/stop").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchStopInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchStopInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_batch_stop(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::BatchStop::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "BatchStop",
                    "medialive",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchStopInput`](crate::input::BatchStopInput)
    pub fn builder() -> crate::input::batch_stop_input::Builder {
        crate::input::batch_stop_input::Builder::default()
    }
}

/// See [`BatchUpdateScheduleInput`](crate::input::BatchUpdateScheduleInput)
pub mod batch_update_schedule_input {
    /// A builder for [`BatchUpdateScheduleInput`](crate::input::BatchUpdateScheduleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_id: std::option::Option<std::string::String>,
        pub(crate) creates: std::option::Option<crate::model::BatchScheduleActionCreateRequest>,
        pub(crate) deletes: std::option::Option<crate::model::BatchScheduleActionDeleteRequest>,
    }
    impl Builder {
        /// Id of the channel whose schedule is being updated.
        pub fn channel_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_id = Some(input.into());
            self
        }
        /// Id of the channel whose schedule is being updated.
        pub fn set_channel_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_id = input;
            self
        }
        /// Schedule actions to create in the schedule.
        pub fn creates(mut self, input: crate::model::BatchScheduleActionCreateRequest) -> Self {
            self.creates = Some(input);
            self
        }
        /// Schedule actions to create in the schedule.
        pub fn set_creates(
            mut self,
            input: std::option::Option<crate::model::BatchScheduleActionCreateRequest>,
        ) -> Self {
            self.creates = input;
            self
        }
        /// Schedule actions to delete from the schedule.
        pub fn deletes(mut self, input: crate::model::BatchScheduleActionDeleteRequest) -> Self {
            self.deletes = Some(input);
            self
        }
        /// Schedule actions to delete from the schedule.
        pub fn set_deletes(
            mut self,
            input: std::option::Option<crate::model::BatchScheduleActionDeleteRequest>,
        ) -> Self {
            self.deletes = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchUpdateScheduleInput`](crate::input::BatchUpdateScheduleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchUpdateScheduleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchUpdateScheduleInput {
                channel_id: self.channel_id,
                creates: self.creates,
                deletes: self.deletes,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchUpdateScheduleInputOperationOutputAlias = crate::operation::BatchUpdateSchedule;
#[doc(hidden)]
pub type BatchUpdateScheduleInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl BatchUpdateScheduleInput {
    /// Consumes the builder and constructs an Operation<[`BatchUpdateSchedule`](crate::operation::BatchUpdateSchedule)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchUpdateSchedule,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchUpdateScheduleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_2 = &_input.channel_id;
            let input_2 =
                input_2
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_id",
                        details: "cannot be empty or unset",
                    })?;
            let channel_id = aws_smithy_http::label::fmt_string(input_2, false);
            if channel_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/prod/channels/{ChannelId}/schedule",
                ChannelId = channel_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchUpdateScheduleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchUpdateScheduleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_update_schedule(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchUpdateSchedule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchUpdateSchedule",
            "medialive",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchUpdateScheduleInput`](crate::input::BatchUpdateScheduleInput)
    pub fn builder() -> crate::input::batch_update_schedule_input::Builder {
        crate::input::batch_update_schedule_input::Builder::default()
    }
}

/// See [`CancelInputDeviceTransferInput`](crate::input::CancelInputDeviceTransferInput)
pub mod cancel_input_device_transfer_input {
    /// A builder for [`CancelInputDeviceTransferInput`](crate::input::CancelInputDeviceTransferInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input_device_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The unique ID of the input device to cancel. For example, hd-123456789abcdef.
        pub fn input_device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_device_id = Some(input.into());
            self
        }
        /// The unique ID of the input device to cancel. For example, hd-123456789abcdef.
        pub fn set_input_device_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.input_device_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelInputDeviceTransferInput`](crate::input::CancelInputDeviceTransferInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CancelInputDeviceTransferInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CancelInputDeviceTransferInput {
                input_device_id: self.input_device_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CancelInputDeviceTransferInputOperationOutputAlias =
    crate::operation::CancelInputDeviceTransfer;
#[doc(hidden)]
pub type CancelInputDeviceTransferInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CancelInputDeviceTransferInput {
    /// Consumes the builder and constructs an Operation<[`CancelInputDeviceTransfer`](crate::operation::CancelInputDeviceTransfer)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CancelInputDeviceTransfer,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CancelInputDeviceTransferInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_3 = &_input.input_device_id;
            let input_3 =
                input_3
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "input_device_id",
                        details: "cannot be empty or unset",
                    })?;
            let input_device_id = aws_smithy_http::label::fmt_string(input_3, false);
            if input_device_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "input_device_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/prod/inputDevices/{InputDeviceId}/cancel",
                InputDeviceId = input_device_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CancelInputDeviceTransferInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CancelInputDeviceTransferInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CancelInputDeviceTransfer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CancelInputDeviceTransfer",
            "medialive",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CancelInputDeviceTransferInput`](crate::input::CancelInputDeviceTransferInput)
    pub fn builder() -> crate::input::cancel_input_device_transfer_input::Builder {
        crate::input::cancel_input_device_transfer_input::Builder::default()
    }
}

/// See [`ClaimDeviceInput`](crate::input::ClaimDeviceInput)
pub mod claim_device_input {
    /// A builder for [`ClaimDeviceInput`](crate::input::ClaimDeviceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The id of the device you want to claim.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// The id of the device you want to claim.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`ClaimDeviceInput`](crate::input::ClaimDeviceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ClaimDeviceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ClaimDeviceInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type ClaimDeviceInputOperationOutputAlias = crate::operation::ClaimDevice;
#[doc(hidden)]
pub type ClaimDeviceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ClaimDeviceInput {
    /// Consumes the builder and constructs an Operation<[`ClaimDevice`](crate::operation::ClaimDevice)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ClaimDevice,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ClaimDeviceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/prod/claimDevice").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ClaimDeviceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ClaimDeviceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_claim_device(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ClaimDevice::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ClaimDevice",
            "medialive",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ClaimDeviceInput`](crate::input::ClaimDeviceInput)
    pub fn builder() -> crate::input::claim_device_input::Builder {
        crate::input::claim_device_input::Builder::default()
    }
}

/// See [`CreateChannelInput`](crate::input::CreateChannelInput)
pub mod create_channel_input {
    /// A builder for [`CreateChannelInput`](crate::input::CreateChannelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cdi_input_specification:
            std::option::Option<crate::model::CdiInputSpecification>,
        pub(crate) channel_class: std::option::Option<crate::model::ChannelClass>,
        pub(crate) destinations:
            std::option::Option<std::vec::Vec<crate::model::OutputDestination>>,
        pub(crate) encoder_settings: std::option::Option<crate::model::EncoderSettings>,
        pub(crate) input_attachments:
            std::option::Option<std::vec::Vec<crate::model::InputAttachment>>,
        pub(crate) input_specification: std::option::Option<crate::model::InputSpecification>,
        pub(crate) log_level: std::option::Option<crate::model::LogLevel>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) reserved: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) vpc: std::option::Option<crate::model::VpcOutputSettings>,
    }
    impl Builder {
        /// Specification of CDI inputs for this channel
        pub fn cdi_input_specification(
            mut self,
            input: crate::model::CdiInputSpecification,
        ) -> Self {
            self.cdi_input_specification = Some(input);
            self
        }
        /// Specification of CDI inputs for this channel
        pub fn set_cdi_input_specification(
            mut self,
            input: std::option::Option<crate::model::CdiInputSpecification>,
        ) -> Self {
            self.cdi_input_specification = input;
            self
        }
        /// The class for this channel. STANDARD for a channel with two pipelines or SINGLE_PIPELINE for a channel with one pipeline.
        pub fn channel_class(mut self, input: crate::model::ChannelClass) -> Self {
            self.channel_class = Some(input);
            self
        }
        /// The class for this channel. STANDARD for a channel with two pipelines or SINGLE_PIPELINE for a channel with one pipeline.
        pub fn set_channel_class(
            mut self,
            input: std::option::Option<crate::model::ChannelClass>,
        ) -> Self {
            self.channel_class = input;
            self
        }
        /// Appends an item to `destinations`.
        ///
        /// To override the contents of this collection use [`set_destinations`](Self::set_destinations).
        ///
        /// Placeholder documentation for __listOfOutputDestination
        pub fn destinations(mut self, input: crate::model::OutputDestination) -> Self {
            let mut v = self.destinations.unwrap_or_default();
            v.push(input);
            self.destinations = Some(v);
            self
        }
        /// Placeholder documentation for __listOfOutputDestination
        pub fn set_destinations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OutputDestination>>,
        ) -> Self {
            self.destinations = input;
            self
        }
        /// Encoder Settings
        pub fn encoder_settings(mut self, input: crate::model::EncoderSettings) -> Self {
            self.encoder_settings = Some(input);
            self
        }
        /// Encoder Settings
        pub fn set_encoder_settings(
            mut self,
            input: std::option::Option<crate::model::EncoderSettings>,
        ) -> Self {
            self.encoder_settings = input;
            self
        }
        /// Appends an item to `input_attachments`.
        ///
        /// To override the contents of this collection use [`set_input_attachments`](Self::set_input_attachments).
        ///
        /// List of input attachments for channel.
        pub fn input_attachments(mut self, input: crate::model::InputAttachment) -> Self {
            let mut v = self.input_attachments.unwrap_or_default();
            v.push(input);
            self.input_attachments = Some(v);
            self
        }
        /// List of input attachments for channel.
        pub fn set_input_attachments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InputAttachment>>,
        ) -> Self {
            self.input_attachments = input;
            self
        }
        /// Specification of network and file inputs for this channel
        pub fn input_specification(mut self, input: crate::model::InputSpecification) -> Self {
            self.input_specification = Some(input);
            self
        }
        /// Specification of network and file inputs for this channel
        pub fn set_input_specification(
            mut self,
            input: std::option::Option<crate::model::InputSpecification>,
        ) -> Self {
            self.input_specification = input;
            self
        }
        /// The log level to write to CloudWatch Logs.
        pub fn log_level(mut self, input: crate::model::LogLevel) -> Self {
            self.log_level = Some(input);
            self
        }
        /// The log level to write to CloudWatch Logs.
        pub fn set_log_level(mut self, input: std::option::Option<crate::model::LogLevel>) -> Self {
            self.log_level = input;
            self
        }
        /// Name of channel.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// Name of channel.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Unique request ID to be specified. This is needed to prevent retries from creating multiple resources.
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// Unique request ID to be specified. This is needed to prevent retries from creating multiple resources.
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Deprecated field that's only usable by whitelisted customers.
        pub fn reserved(mut self, input: impl Into<std::string::String>) -> Self {
            self.reserved = Some(input.into());
            self
        }
        /// Deprecated field that's only usable by whitelisted customers.
        pub fn set_reserved(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reserved = input;
            self
        }
        /// An optional Amazon Resource Name (ARN) of the role to assume when running the Channel.
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// An optional Amazon Resource Name (ARN) of the role to assume when running the Channel.
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of key-value pairs.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// A collection of key-value pairs.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Settings for the VPC outputs
        pub fn vpc(mut self, input: crate::model::VpcOutputSettings) -> Self {
            self.vpc = Some(input);
            self
        }
        /// Settings for the VPC outputs
        pub fn set_vpc(
            mut self,
            input: std::option::Option<crate::model::VpcOutputSettings>,
        ) -> Self {
            self.vpc = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateChannelInput`](crate::input::CreateChannelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateChannelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateChannelInput {
                cdi_input_specification: self.cdi_input_specification,
                channel_class: self.channel_class,
                destinations: self.destinations,
                encoder_settings: self.encoder_settings,
                input_attachments: self.input_attachments,
                input_specification: self.input_specification,
                log_level: self.log_level,
                name: self.name,
                request_id: self.request_id,
                reserved: self.reserved,
                role_arn: self.role_arn,
                tags: self.tags,
                vpc: self.vpc,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateChannelInputOperationOutputAlias = crate::operation::CreateChannel;
#[doc(hidden)]
pub type CreateChannelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateChannelInput {
    /// Consumes the builder and constructs an Operation<[`CreateChannel`](crate::operation::CreateChannel)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateChannel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateChannelInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/prod/channels").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateChannelInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateChannelInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.request_id.is_none() {
            self.request_id = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_channel(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateChannel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateChannel",
            "medialive",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateChannelInput`](crate::input::CreateChannelInput)
    pub fn builder() -> crate::input::create_channel_input::Builder {
        crate::input::create_channel_input::Builder::default()
    }
}

/// See [`CreateInputInput`](crate::input::CreateInputInput)
pub mod create_input_input {
    /// A builder for [`CreateInputInput`](crate::input::CreateInputInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) destinations:
            std::option::Option<std::vec::Vec<crate::model::InputDestinationRequest>>,
        pub(crate) input_devices:
            std::option::Option<std::vec::Vec<crate::model::InputDeviceSettings>>,
        pub(crate) input_security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) media_connect_flows:
            std::option::Option<std::vec::Vec<crate::model::MediaConnectFlowRequest>>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) sources: std::option::Option<std::vec::Vec<crate::model::InputSourceRequest>>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) r#type: std::option::Option<crate::model::InputType>,
        pub(crate) vpc: std::option::Option<crate::model::InputVpcRequest>,
    }
    impl Builder {
        /// Appends an item to `destinations`.
        ///
        /// To override the contents of this collection use [`set_destinations`](Self::set_destinations).
        ///
        /// Destination settings for PUSH type inputs.
        pub fn destinations(mut self, input: crate::model::InputDestinationRequest) -> Self {
            let mut v = self.destinations.unwrap_or_default();
            v.push(input);
            self.destinations = Some(v);
            self
        }
        /// Destination settings for PUSH type inputs.
        pub fn set_destinations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InputDestinationRequest>>,
        ) -> Self {
            self.destinations = input;
            self
        }
        /// Appends an item to `input_devices`.
        ///
        /// To override the contents of this collection use [`set_input_devices`](Self::set_input_devices).
        ///
        /// Settings for the devices.
        pub fn input_devices(mut self, input: crate::model::InputDeviceSettings) -> Self {
            let mut v = self.input_devices.unwrap_or_default();
            v.push(input);
            self.input_devices = Some(v);
            self
        }
        /// Settings for the devices.
        pub fn set_input_devices(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InputDeviceSettings>>,
        ) -> Self {
            self.input_devices = input;
            self
        }
        /// Appends an item to `input_security_groups`.
        ///
        /// To override the contents of this collection use [`set_input_security_groups`](Self::set_input_security_groups).
        ///
        /// A list of security groups referenced by IDs to attach to the input.
        pub fn input_security_groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.input_security_groups.unwrap_or_default();
            v.push(input.into());
            self.input_security_groups = Some(v);
            self
        }
        /// A list of security groups referenced by IDs to attach to the input.
        pub fn set_input_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.input_security_groups = input;
            self
        }
        /// Appends an item to `media_connect_flows`.
        ///
        /// To override the contents of this collection use [`set_media_connect_flows`](Self::set_media_connect_flows).
        ///
        /// A list of the MediaConnect Flows that you want to use in this input. You can specify as few as one Flow and presently, as many as two. The only requirement is when you have more than one is that each Flow is in a separate Availability Zone as this ensures your EML input is redundant to AZ issues.
        pub fn media_connect_flows(mut self, input: crate::model::MediaConnectFlowRequest) -> Self {
            let mut v = self.media_connect_flows.unwrap_or_default();
            v.push(input);
            self.media_connect_flows = Some(v);
            self
        }
        /// A list of the MediaConnect Flows that you want to use in this input. You can specify as few as one Flow and presently, as many as two. The only requirement is when you have more than one is that each Flow is in a separate Availability Zone as this ensures your EML input is redundant to AZ issues.
        pub fn set_media_connect_flows(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MediaConnectFlowRequest>>,
        ) -> Self {
            self.media_connect_flows = input;
            self
        }
        /// Name of the input.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// Name of the input.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Unique identifier of the request to ensure the request is handled exactly once in case of retries.
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// Unique identifier of the request to ensure the request is handled exactly once in case of retries.
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// The Amazon Resource Name (ARN) of the role this input assumes during and after creation.
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) of the role this input assumes during and after creation.
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Appends an item to `sources`.
        ///
        /// To override the contents of this collection use [`set_sources`](Self::set_sources).
        ///
        /// The source URLs for a PULL-type input. Every PULL type input needs exactly two source URLs for redundancy. Only specify sources for PULL type Inputs. Leave Destinations empty.
        pub fn sources(mut self, input: crate::model::InputSourceRequest) -> Self {
            let mut v = self.sources.unwrap_or_default();
            v.push(input);
            self.sources = Some(v);
            self
        }
        /// The source URLs for a PULL-type input. Every PULL type input needs exactly two source URLs for redundancy. Only specify sources for PULL type Inputs. Leave Destinations empty.
        pub fn set_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InputSourceRequest>>,
        ) -> Self {
            self.sources = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of key-value pairs.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// A collection of key-value pairs.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// The different types of inputs that AWS Elemental MediaLive supports.
        pub fn r#type(mut self, input: crate::model::InputType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// The different types of inputs that AWS Elemental MediaLive supports.
        pub fn set_type(mut self, input: std::option::Option<crate::model::InputType>) -> Self {
            self.r#type = input;
            self
        }
        /// Settings for a private VPC Input. When this property is specified, the input destination addresses will be created in a VPC rather than with public Internet addresses. This property requires setting the roleArn property on Input creation. Not compatible with the inputSecurityGroups property.
        pub fn vpc(mut self, input: crate::model::InputVpcRequest) -> Self {
            self.vpc = Some(input);
            self
        }
        /// Settings for a private VPC Input. When this property is specified, the input destination addresses will be created in a VPC rather than with public Internet addresses. This property requires setting the roleArn property on Input creation. Not compatible with the inputSecurityGroups property.
        pub fn set_vpc(
            mut self,
            input: std::option::Option<crate::model::InputVpcRequest>,
        ) -> Self {
            self.vpc = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateInputInput`](crate::input::CreateInputInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateInputInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateInputInput {
                destinations: self.destinations,
                input_devices: self.input_devices,
                input_security_groups: self.input_security_groups,
                media_connect_flows: self.media_connect_flows,
                name: self.name,
                request_id: self.request_id,
                role_arn: self.role_arn,
                sources: self.sources,
                tags: self.tags,
                r#type: self.r#type,
                vpc: self.vpc,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateInputInputOperationOutputAlias = crate::operation::CreateInput;
#[doc(hidden)]
pub type CreateInputInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateInputInput {
    /// Consumes the builder and constructs an Operation<[`CreateInput`](crate::operation::CreateInput)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateInput,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateInputInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/prod/inputs").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateInputInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateInputInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.request_id.is_none() {
            self.request_id = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_input(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateInput::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateInput",
            "medialive",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateInputInput`](crate::input::CreateInputInput)
    pub fn builder() -> crate::input::create_input_input::Builder {
        crate::input::create_input_input::Builder::default()
    }
}

/// See [`CreateInputSecurityGroupInput`](crate::input::CreateInputSecurityGroupInput)
pub mod create_input_security_group_input {
    /// A builder for [`CreateInputSecurityGroupInput`](crate::input::CreateInputSecurityGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) whitelist_rules:
            std::option::Option<std::vec::Vec<crate::model::InputWhitelistRuleCidr>>,
    }
    impl Builder {
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of key-value pairs.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// A collection of key-value pairs.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Appends an item to `whitelist_rules`.
        ///
        /// To override the contents of this collection use [`set_whitelist_rules`](Self::set_whitelist_rules).
        ///
        /// List of IPv4 CIDR addresses to whitelist
        pub fn whitelist_rules(mut self, input: crate::model::InputWhitelistRuleCidr) -> Self {
            let mut v = self.whitelist_rules.unwrap_or_default();
            v.push(input);
            self.whitelist_rules = Some(v);
            self
        }
        /// List of IPv4 CIDR addresses to whitelist
        pub fn set_whitelist_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InputWhitelistRuleCidr>>,
        ) -> Self {
            self.whitelist_rules = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateInputSecurityGroupInput`](crate::input::CreateInputSecurityGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateInputSecurityGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateInputSecurityGroupInput {
                tags: self.tags,
                whitelist_rules: self.whitelist_rules,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateInputSecurityGroupInputOperationOutputAlias =
    crate::operation::CreateInputSecurityGroup;
#[doc(hidden)]
pub type CreateInputSecurityGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateInputSecurityGroupInput {
    /// Consumes the builder and constructs an Operation<[`CreateInputSecurityGroup`](crate::operation::CreateInputSecurityGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateInputSecurityGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateInputSecurityGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/prod/inputSecurityGroups").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateInputSecurityGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateInputSecurityGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_input_security_group(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateInputSecurityGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateInputSecurityGroup",
            "medialive",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateInputSecurityGroupInput`](crate::input::CreateInputSecurityGroupInput)
    pub fn builder() -> crate::input::create_input_security_group_input::Builder {
        crate::input::create_input_security_group_input::Builder::default()
    }
}

/// See [`CreateMultiplexInput`](crate::input::CreateMultiplexInput)
pub mod create_multiplex_input {
    /// A builder for [`CreateMultiplexInput`](crate::input::CreateMultiplexInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) multiplex_settings: std::option::Option<crate::model::MultiplexSettings>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Appends an item to `availability_zones`.
        ///
        /// To override the contents of this collection use [`set_availability_zones`](Self::set_availability_zones).
        ///
        /// A list of availability zones for the multiplex. You must specify exactly two.
        pub fn availability_zones(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.availability_zones.unwrap_or_default();
            v.push(input.into());
            self.availability_zones = Some(v);
            self
        }
        /// A list of availability zones for the multiplex. You must specify exactly two.
        pub fn set_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.availability_zones = input;
            self
        }
        /// Configuration for a multiplex event.
        pub fn multiplex_settings(mut self, input: crate::model::MultiplexSettings) -> Self {
            self.multiplex_settings = Some(input);
            self
        }
        /// Configuration for a multiplex event.
        pub fn set_multiplex_settings(
            mut self,
            input: std::option::Option<crate::model::MultiplexSettings>,
        ) -> Self {
            self.multiplex_settings = input;
            self
        }
        /// Name of multiplex.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// Name of multiplex.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Unique request ID. This prevents retries from creating multiple resources.
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// Unique request ID. This prevents retries from creating multiple resources.
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of key-value pairs.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// A collection of key-value pairs.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateMultiplexInput`](crate::input::CreateMultiplexInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateMultiplexInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateMultiplexInput {
                availability_zones: self.availability_zones,
                multiplex_settings: self.multiplex_settings,
                name: self.name,
                request_id: self.request_id,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateMultiplexInputOperationOutputAlias = crate::operation::CreateMultiplex;
#[doc(hidden)]
pub type CreateMultiplexInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateMultiplexInput {
    /// Consumes the builder and constructs an Operation<[`CreateMultiplex`](crate::operation::CreateMultiplex)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateMultiplex,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateMultiplexInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/prod/multiplexes").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateMultiplexInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateMultiplexInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.request_id.is_none() {
            self.request_id = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_multiplex(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateMultiplex::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateMultiplex",
            "medialive",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateMultiplexInput`](crate::input::CreateMultiplexInput)
    pub fn builder() -> crate::input::create_multiplex_input::Builder {
        crate::input::create_multiplex_input::Builder::default()
    }
}

/// See [`CreateMultiplexProgramInput`](crate::input::CreateMultiplexProgramInput)
pub mod create_multiplex_program_input {
    /// A builder for [`CreateMultiplexProgramInput`](crate::input::CreateMultiplexProgramInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) multiplex_id: std::option::Option<std::string::String>,
        pub(crate) multiplex_program_settings:
            std::option::Option<crate::model::MultiplexProgramSettings>,
        pub(crate) program_name: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// ID of the multiplex where the program is to be created.
        pub fn multiplex_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.multiplex_id = Some(input.into());
            self
        }
        /// ID of the multiplex where the program is to be created.
        pub fn set_multiplex_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.multiplex_id = input;
            self
        }
        /// The settings for this multiplex program.
        pub fn multiplex_program_settings(
            mut self,
            input: crate::model::MultiplexProgramSettings,
        ) -> Self {
            self.multiplex_program_settings = Some(input);
            self
        }
        /// The settings for this multiplex program.
        pub fn set_multiplex_program_settings(
            mut self,
            input: std::option::Option<crate::model::MultiplexProgramSettings>,
        ) -> Self {
            self.multiplex_program_settings = input;
            self
        }
        /// Name of multiplex program.
        pub fn program_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.program_name = Some(input.into());
            self
        }
        /// Name of multiplex program.
        pub fn set_program_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.program_name = input;
            self
        }
        /// Unique request ID. This prevents retries from creating multiple resources.
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// Unique request ID. This prevents retries from creating multiple resources.
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateMultiplexProgramInput`](crate::input::CreateMultiplexProgramInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateMultiplexProgramInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateMultiplexProgramInput {
                multiplex_id: self.multiplex_id,
                multiplex_program_settings: self.multiplex_program_settings,
                program_name: self.program_name,
                request_id: self.request_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateMultiplexProgramInputOperationOutputAlias = crate::operation::CreateMultiplexProgram;
#[doc(hidden)]
pub type CreateMultiplexProgramInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateMultiplexProgramInput {
    /// Consumes the builder and constructs an Operation<[`CreateMultiplexProgram`](crate::operation::CreateMultiplexProgram)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateMultiplexProgram,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateMultiplexProgramInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_4 = &_input.multiplex_id;
            let input_4 =
                input_4
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "multiplex_id",
                        details: "cannot be empty or unset",
                    })?;
            let multiplex_id = aws_smithy_http::label::fmt_string(input_4, false);
            if multiplex_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "multiplex_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/prod/multiplexes/{MultiplexId}/programs",
                MultiplexId = multiplex_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateMultiplexProgramInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateMultiplexProgramInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.request_id.is_none() {
            self.request_id = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_multiplex_program(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateMultiplexProgram::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateMultiplexProgram",
            "medialive",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateMultiplexProgramInput`](crate::input::CreateMultiplexProgramInput)
    pub fn builder() -> crate::input::create_multiplex_program_input::Builder {
        crate::input::create_multiplex_program_input::Builder::default()
    }
}

/// See [`CreatePartnerInputInput`](crate::input::CreatePartnerInputInput)
pub mod create_partner_input_input {
    /// A builder for [`CreatePartnerInputInput`](crate::input::CreatePartnerInputInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input_id: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Unique ID of the input.
        pub fn input_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_id = Some(input.into());
            self
        }
        /// Unique ID of the input.
        pub fn set_input_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.input_id = input;
            self
        }
        /// Unique identifier of the request to ensure the request is handled exactly once in case of retries.
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// Unique identifier of the request to ensure the request is handled exactly once in case of retries.
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of key-value pairs.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// A collection of key-value pairs.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePartnerInputInput`](crate::input::CreatePartnerInputInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreatePartnerInputInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreatePartnerInputInput {
                input_id: self.input_id,
                request_id: self.request_id,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreatePartnerInputInputOperationOutputAlias = crate::operation::CreatePartnerInput;
#[doc(hidden)]
pub type CreatePartnerInputInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreatePartnerInputInput {
    /// Consumes the builder and constructs an Operation<[`CreatePartnerInput`](crate::operation::CreatePartnerInput)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreatePartnerInput,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreatePartnerInputInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_5 = &_input.input_id;
            let input_5 =
                input_5
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "input_id",
                        details: "cannot be empty or unset",
                    })?;
            let input_id = aws_smithy_http::label::fmt_string(input_5, false);
            if input_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "input_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/prod/inputs/{InputId}/partners",
                InputId = input_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreatePartnerInputInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreatePartnerInputInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.request_id.is_none() {
            self.request_id = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_partner_input(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreatePartnerInput::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreatePartnerInput",
            "medialive",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreatePartnerInputInput`](crate::input::CreatePartnerInputInput)
    pub fn builder() -> crate::input::create_partner_input_input::Builder {
        crate::input::create_partner_input_input::Builder::default()
    }
}

/// See [`CreateTagsInput`](crate::input::CreateTagsInput)
pub mod create_tags_input {
    /// A builder for [`CreateTagsInput`](crate::input::CreateTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Placeholder documentation for __string
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// Placeholder documentation for __string
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// Placeholder documentation for Tags
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// Placeholder documentation for Tags
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTagsInput`](crate::input::CreateTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateTagsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateTagsInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateTagsInputOperationOutputAlias = crate::operation::CreateTags;
#[doc(hidden)]
pub type CreateTagsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateTagsInput {
    /// Consumes the builder and constructs an Operation<[`CreateTags`](crate::operation::CreateTags)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateTags,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateTagsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_6 = &_input.resource_arn;
            let input_6 =
                input_6
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_6, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/prod/tags/{ResourceArn}",
                ResourceArn = resource_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateTagsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateTagsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_tags(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateTags::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateTags",
            "medialive",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateTagsInput`](crate::input::CreateTagsInput)
    pub fn builder() -> crate::input::create_tags_input::Builder {
        crate::input::create_tags_input::Builder::default()
    }
}

/// See [`DeleteChannelInput`](crate::input::DeleteChannelInput)
pub mod delete_channel_input {
    /// A builder for [`DeleteChannelInput`](crate::input::DeleteChannelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Unique ID of the channel.
        pub fn channel_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_id = Some(input.into());
            self
        }
        /// Unique ID of the channel.
        pub fn set_channel_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteChannelInput`](crate::input::DeleteChannelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteChannelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteChannelInput {
                channel_id: self.channel_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteChannelInputOperationOutputAlias = crate::operation::DeleteChannel;
#[doc(hidden)]
pub type DeleteChannelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteChannelInput {
    /// Consumes the builder and constructs an Operation<[`DeleteChannel`](crate::operation::DeleteChannel)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteChannel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteChannelInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_7 = &_input.channel_id;
            let input_7 =
                input_7
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_id",
                        details: "cannot be empty or unset",
                    })?;
            let channel_id = aws_smithy_http::label::fmt_string(input_7, false);
            if channel_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/prod/channels/{ChannelId}", ChannelId = channel_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteChannelInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteChannelInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteChannel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteChannel",
            "medialive",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteChannelInput`](crate::input::DeleteChannelInput)
    pub fn builder() -> crate::input::delete_channel_input::Builder {
        crate::input::delete_channel_input::Builder::default()
    }
}

/// See [`DeleteInputInput`](crate::input::DeleteInputInput)
pub mod delete_input_input {
    /// A builder for [`DeleteInputInput`](crate::input::DeleteInputInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Unique ID of the input
        pub fn input_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_id = Some(input.into());
            self
        }
        /// Unique ID of the input
        pub fn set_input_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.input_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteInputInput`](crate::input::DeleteInputInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteInputInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteInputInput {
                input_id: self.input_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteInputInputOperationOutputAlias = crate::operation::DeleteInput;
#[doc(hidden)]
pub type DeleteInputInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteInputInput {
    /// Consumes the builder and constructs an Operation<[`DeleteInput`](crate::operation::DeleteInput)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteInput,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteInputInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_8 = &_input.input_id;
            let input_8 =
                input_8
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "input_id",
                        details: "cannot be empty or unset",
                    })?;
            let input_id = aws_smithy_http::label::fmt_string(input_8, false);
            if input_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "input_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/prod/inputs/{InputId}", InputId = input_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteInputInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteInputInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteInput::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteInput",
            "medialive",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteInputInput`](crate::input::DeleteInputInput)
    pub fn builder() -> crate::input::delete_input_input::Builder {
        crate::input::delete_input_input::Builder::default()
    }
}

/// See [`DeleteInputSecurityGroupInput`](crate::input::DeleteInputSecurityGroupInput)
pub mod delete_input_security_group_input {
    /// A builder for [`DeleteInputSecurityGroupInput`](crate::input::DeleteInputSecurityGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input_security_group_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The Input Security Group to delete
        pub fn input_security_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_security_group_id = Some(input.into());
            self
        }
        /// The Input Security Group to delete
        pub fn set_input_security_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.input_security_group_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteInputSecurityGroupInput`](crate::input::DeleteInputSecurityGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteInputSecurityGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteInputSecurityGroupInput {
                input_security_group_id: self.input_security_group_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteInputSecurityGroupInputOperationOutputAlias =
    crate::operation::DeleteInputSecurityGroup;
#[doc(hidden)]
pub type DeleteInputSecurityGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteInputSecurityGroupInput {
    /// Consumes the builder and constructs an Operation<[`DeleteInputSecurityGroup`](crate::operation::DeleteInputSecurityGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteInputSecurityGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteInputSecurityGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_9 = &_input.input_security_group_id;
            let input_9 =
                input_9
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "input_security_group_id",
                        details: "cannot be empty or unset",
                    })?;
            let input_security_group_id = aws_smithy_http::label::fmt_string(input_9, false);
            if input_security_group_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "input_security_group_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/prod/inputSecurityGroups/{InputSecurityGroupId}",
                InputSecurityGroupId = input_security_group_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteInputSecurityGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteInputSecurityGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteInputSecurityGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteInputSecurityGroup",
            "medialive",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteInputSecurityGroupInput`](crate::input::DeleteInputSecurityGroupInput)
    pub fn builder() -> crate::input::delete_input_security_group_input::Builder {
        crate::input::delete_input_security_group_input::Builder::default()
    }
}

/// See [`DeleteMultiplexInput`](crate::input::DeleteMultiplexInput)
pub mod delete_multiplex_input {
    /// A builder for [`DeleteMultiplexInput`](crate::input::DeleteMultiplexInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) multiplex_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ID of the multiplex.
        pub fn multiplex_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.multiplex_id = Some(input.into());
            self
        }
        /// The ID of the multiplex.
        pub fn set_multiplex_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.multiplex_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteMultiplexInput`](crate::input::DeleteMultiplexInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteMultiplexInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteMultiplexInput {
                multiplex_id: self.multiplex_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteMultiplexInputOperationOutputAlias = crate::operation::DeleteMultiplex;
#[doc(hidden)]
pub type DeleteMultiplexInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteMultiplexInput {
    /// Consumes the builder and constructs an Operation<[`DeleteMultiplex`](crate::operation::DeleteMultiplex)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteMultiplex,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteMultiplexInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_10 = &_input.multiplex_id;
            let input_10 =
                input_10
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "multiplex_id",
                        details: "cannot be empty or unset",
                    })?;
            let multiplex_id = aws_smithy_http::label::fmt_string(input_10, false);
            if multiplex_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "multiplex_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/prod/multiplexes/{MultiplexId}",
                MultiplexId = multiplex_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteMultiplexInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteMultiplexInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteMultiplex::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteMultiplex",
            "medialive",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteMultiplexInput`](crate::input::DeleteMultiplexInput)
    pub fn builder() -> crate::input::delete_multiplex_input::Builder {
        crate::input::delete_multiplex_input::Builder::default()
    }
}

/// See [`DeleteMultiplexProgramInput`](crate::input::DeleteMultiplexProgramInput)
pub mod delete_multiplex_program_input {
    /// A builder for [`DeleteMultiplexProgramInput`](crate::input::DeleteMultiplexProgramInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) multiplex_id: std::option::Option<std::string::String>,
        pub(crate) program_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ID of the multiplex that the program belongs to.
        pub fn multiplex_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.multiplex_id = Some(input.into());
            self
        }
        /// The ID of the multiplex that the program belongs to.
        pub fn set_multiplex_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.multiplex_id = input;
            self
        }
        /// The multiplex program name.
        pub fn program_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.program_name = Some(input.into());
            self
        }
        /// The multiplex program name.
        pub fn set_program_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.program_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteMultiplexProgramInput`](crate::input::DeleteMultiplexProgramInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteMultiplexProgramInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteMultiplexProgramInput {
                multiplex_id: self.multiplex_id,
                program_name: self.program_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteMultiplexProgramInputOperationOutputAlias = crate::operation::DeleteMultiplexProgram;
#[doc(hidden)]
pub type DeleteMultiplexProgramInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteMultiplexProgramInput {
    /// Consumes the builder and constructs an Operation<[`DeleteMultiplexProgram`](crate::operation::DeleteMultiplexProgram)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteMultiplexProgram,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteMultiplexProgramInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_11 = &_input.multiplex_id;
            let input_11 =
                input_11
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "multiplex_id",
                        details: "cannot be empty or unset",
                    })?;
            let multiplex_id = aws_smithy_http::label::fmt_string(input_11, false);
            if multiplex_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "multiplex_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_12 = &_input.program_name;
            let input_12 =
                input_12
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "program_name",
                        details: "cannot be empty or unset",
                    })?;
            let program_name = aws_smithy_http::label::fmt_string(input_12, false);
            if program_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "program_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/prod/multiplexes/{MultiplexId}/programs/{ProgramName}",
                MultiplexId = multiplex_id,
                ProgramName = program_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteMultiplexProgramInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteMultiplexProgramInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteMultiplexProgram::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteMultiplexProgram",
            "medialive",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteMultiplexProgramInput`](crate::input::DeleteMultiplexProgramInput)
    pub fn builder() -> crate::input::delete_multiplex_program_input::Builder {
        crate::input::delete_multiplex_program_input::Builder::default()
    }
}

/// See [`DeleteReservationInput`](crate::input::DeleteReservationInput)
pub mod delete_reservation_input {
    /// A builder for [`DeleteReservationInput`](crate::input::DeleteReservationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reservation_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Unique reservation ID, e.g. '1234567'
        pub fn reservation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.reservation_id = Some(input.into());
            self
        }
        /// Unique reservation ID, e.g. '1234567'
        pub fn set_reservation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reservation_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteReservationInput`](crate::input::DeleteReservationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteReservationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteReservationInput {
                reservation_id: self.reservation_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteReservationInputOperationOutputAlias = crate::operation::DeleteReservation;
#[doc(hidden)]
pub type DeleteReservationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteReservationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteReservation`](crate::operation::DeleteReservation)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteReservation,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteReservationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_13 = &_input.reservation_id;
            let input_13 =
                input_13
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "reservation_id",
                        details: "cannot be empty or unset",
                    })?;
            let reservation_id = aws_smithy_http::label::fmt_string(input_13, false);
            if reservation_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "reservation_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/prod/reservations/{ReservationId}",
                ReservationId = reservation_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteReservationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteReservationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteReservation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteReservation",
            "medialive",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteReservationInput`](crate::input::DeleteReservationInput)
    pub fn builder() -> crate::input::delete_reservation_input::Builder {
        crate::input::delete_reservation_input::Builder::default()
    }
}

/// See [`DeleteScheduleInput`](crate::input::DeleteScheduleInput)
pub mod delete_schedule_input {
    /// A builder for [`DeleteScheduleInput`](crate::input::DeleteScheduleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Id of the channel whose schedule is being deleted.
        pub fn channel_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_id = Some(input.into());
            self
        }
        /// Id of the channel whose schedule is being deleted.
        pub fn set_channel_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteScheduleInput`](crate::input::DeleteScheduleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteScheduleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteScheduleInput {
                channel_id: self.channel_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteScheduleInputOperationOutputAlias = crate::operation::DeleteSchedule;
#[doc(hidden)]
pub type DeleteScheduleInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteScheduleInput {
    /// Consumes the builder and constructs an Operation<[`DeleteSchedule`](crate::operation::DeleteSchedule)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteSchedule,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteScheduleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_14 = &_input.channel_id;
            let input_14 =
                input_14
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_id",
                        details: "cannot be empty or unset",
                    })?;
            let channel_id = aws_smithy_http::label::fmt_string(input_14, false);
            if channel_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/prod/channels/{ChannelId}/schedule",
                ChannelId = channel_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteScheduleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteScheduleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteSchedule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteSchedule",
            "medialive",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteScheduleInput`](crate::input::DeleteScheduleInput)
    pub fn builder() -> crate::input::delete_schedule_input::Builder {
        crate::input::delete_schedule_input::Builder::default()
    }
}

/// See [`DeleteTagsInput`](crate::input::DeleteTagsInput)
pub mod delete_tags_input {
    /// A builder for [`DeleteTagsInput`](crate::input::DeleteTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Placeholder documentation for __string
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// Placeholder documentation for __string
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// An array of tag keys to delete
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// An array of tag keys to delete
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteTagsInput`](crate::input::DeleteTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteTagsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteTagsInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteTagsInputOperationOutputAlias = crate::operation::DeleteTags;
#[doc(hidden)]
pub type DeleteTagsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteTagsInput {
    /// Consumes the builder and constructs an Operation<[`DeleteTags`](crate::operation::DeleteTags)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteTags,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteTagsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_15 = &_input.resource_arn;
            let input_15 =
                input_15
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_15, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/prod/tags/{ResourceArn}",
                ResourceArn = resource_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::DeleteTagsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_16) = &_input.tag_keys {
                for inner_17 in inner_16 {
                    query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_17));
                }
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteTagsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteTagsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteTags::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteTags",
            "medialive",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteTagsInput`](crate::input::DeleteTagsInput)
    pub fn builder() -> crate::input::delete_tags_input::Builder {
        crate::input::delete_tags_input::Builder::default()
    }
}

/// See [`DescribeChannelInput`](crate::input::DescribeChannelInput)
pub mod describe_channel_input {
    /// A builder for [`DescribeChannelInput`](crate::input::DescribeChannelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// channel ID
        pub fn channel_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_id = Some(input.into());
            self
        }
        /// channel ID
        pub fn set_channel_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeChannelInput`](crate::input::DescribeChannelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeChannelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeChannelInput {
                channel_id: self.channel_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeChannelInputOperationOutputAlias = crate::operation::DescribeChannel;
#[doc(hidden)]
pub type DescribeChannelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeChannelInput {
    /// Consumes the builder and constructs an Operation<[`DescribeChannel`](crate::operation::DescribeChannel)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeChannel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeChannelInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_18 = &_input.channel_id;
            let input_18 =
                input_18
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_id",
                        details: "cannot be empty or unset",
                    })?;
            let channel_id = aws_smithy_http::label::fmt_string(input_18, false);
            if channel_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/prod/channels/{ChannelId}", ChannelId = channel_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeChannelInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeChannelInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeChannel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeChannel",
            "medialive",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeChannelInput`](crate::input::DescribeChannelInput)
    pub fn builder() -> crate::input::describe_channel_input::Builder {
        crate::input::describe_channel_input::Builder::default()
    }
}

/// See [`DescribeInputInput`](crate::input::DescribeInputInput)
pub mod describe_input_input {
    /// A builder for [`DescribeInputInput`](crate::input::DescribeInputInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Unique ID of the input
        pub fn input_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_id = Some(input.into());
            self
        }
        /// Unique ID of the input
        pub fn set_input_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.input_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeInputInput`](crate::input::DescribeInputInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeInputInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeInputInput {
                input_id: self.input_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeInputInputOperationOutputAlias = crate::operation::DescribeInput;
#[doc(hidden)]
pub type DescribeInputInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeInputInput {
    /// Consumes the builder and constructs an Operation<[`DescribeInput`](crate::operation::DescribeInput)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeInput,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeInputInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_19 = &_input.input_id;
            let input_19 =
                input_19
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "input_id",
                        details: "cannot be empty or unset",
                    })?;
            let input_id = aws_smithy_http::label::fmt_string(input_19, false);
            if input_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "input_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/prod/inputs/{InputId}", InputId = input_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeInputInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeInputInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeInput::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeInput",
            "medialive",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeInputInput`](crate::input::DescribeInputInput)
    pub fn builder() -> crate::input::describe_input_input::Builder {
        crate::input::describe_input_input::Builder::default()
    }
}

/// See [`DescribeInputDeviceInput`](crate::input::DescribeInputDeviceInput)
pub mod describe_input_device_input {
    /// A builder for [`DescribeInputDeviceInput`](crate::input::DescribeInputDeviceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input_device_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The unique ID of this input device. For example, hd-123456789abcdef.
        pub fn input_device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_device_id = Some(input.into());
            self
        }
        /// The unique ID of this input device. For example, hd-123456789abcdef.
        pub fn set_input_device_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.input_device_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeInputDeviceInput`](crate::input::DescribeInputDeviceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeInputDeviceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeInputDeviceInput {
                input_device_id: self.input_device_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeInputDeviceInputOperationOutputAlias = crate::operation::DescribeInputDevice;
#[doc(hidden)]
pub type DescribeInputDeviceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeInputDeviceInput {
    /// Consumes the builder and constructs an Operation<[`DescribeInputDevice`](crate::operation::DescribeInputDevice)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeInputDevice,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeInputDeviceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_20 = &_input.input_device_id;
            let input_20 =
                input_20
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "input_device_id",
                        details: "cannot be empty or unset",
                    })?;
            let input_device_id = aws_smithy_http::label::fmt_string(input_20, false);
            if input_device_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "input_device_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/prod/inputDevices/{InputDeviceId}",
                InputDeviceId = input_device_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeInputDeviceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeInputDeviceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeInputDevice::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeInputDevice",
            "medialive",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeInputDeviceInput`](crate::input::DescribeInputDeviceInput)
    pub fn builder() -> crate::input::describe_input_device_input::Builder {
        crate::input::describe_input_device_input::Builder::default()
    }
}

/// See [`DescribeInputDeviceThumbnailInput`](crate::input::DescribeInputDeviceThumbnailInput)
pub mod describe_input_device_thumbnail_input {
    /// A builder for [`DescribeInputDeviceThumbnailInput`](crate::input::DescribeInputDeviceThumbnailInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input_device_id: std::option::Option<std::string::String>,
        pub(crate) accept: std::option::Option<crate::model::AcceptHeader>,
    }
    impl Builder {
        /// The unique ID of this input device. For example, hd-123456789abcdef.
        pub fn input_device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_device_id = Some(input.into());
            self
        }
        /// The unique ID of this input device. For example, hd-123456789abcdef.
        pub fn set_input_device_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.input_device_id = input;
            self
        }
        /// The HTTP Accept header. Indicates the requested type for the thumbnail.
        pub fn accept(mut self, input: crate::model::AcceptHeader) -> Self {
            self.accept = Some(input);
            self
        }
        /// The HTTP Accept header. Indicates the requested type for the thumbnail.
        pub fn set_accept(
            mut self,
            input: std::option::Option<crate::model::AcceptHeader>,
        ) -> Self {
            self.accept = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeInputDeviceThumbnailInput`](crate::input::DescribeInputDeviceThumbnailInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeInputDeviceThumbnailInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeInputDeviceThumbnailInput {
                input_device_id: self.input_device_id,
                accept: self.accept,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeInputDeviceThumbnailInputOperationOutputAlias =
    crate::operation::DescribeInputDeviceThumbnail;
#[doc(hidden)]
pub type DescribeInputDeviceThumbnailInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeInputDeviceThumbnailInput {
    /// Consumes the builder and constructs an Operation<[`DescribeInputDeviceThumbnail`](crate::operation::DescribeInputDeviceThumbnail)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeInputDeviceThumbnail,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeInputDeviceThumbnailInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_21 = &_input.input_device_id;
            let input_21 =
                input_21
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "input_device_id",
                        details: "cannot be empty or unset",
                    })?;
            let input_device_id = aws_smithy_http::label::fmt_string(input_21, false);
            if input_device_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "input_device_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/prod/inputDevices/{InputDeviceId}/thumbnailData",
                InputDeviceId = input_device_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DescribeInputDeviceThumbnailInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_22) = &_input.accept {
                let formatted_23 = AsRef::<str>::as_ref(inner_22);
                if !formatted_23.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_23;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "accept",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("accept", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeInputDeviceThumbnailInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeInputDeviceThumbnailInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeInputDeviceThumbnail::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeInputDeviceThumbnail",
            "medialive",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeInputDeviceThumbnailInput`](crate::input::DescribeInputDeviceThumbnailInput)
    pub fn builder() -> crate::input::describe_input_device_thumbnail_input::Builder {
        crate::input::describe_input_device_thumbnail_input::Builder::default()
    }
}

/// See [`DescribeInputSecurityGroupInput`](crate::input::DescribeInputSecurityGroupInput)
pub mod describe_input_security_group_input {
    /// A builder for [`DescribeInputSecurityGroupInput`](crate::input::DescribeInputSecurityGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input_security_group_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The id of the Input Security Group to describe
        pub fn input_security_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_security_group_id = Some(input.into());
            self
        }
        /// The id of the Input Security Group to describe
        pub fn set_input_security_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.input_security_group_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeInputSecurityGroupInput`](crate::input::DescribeInputSecurityGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeInputSecurityGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeInputSecurityGroupInput {
                input_security_group_id: self.input_security_group_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeInputSecurityGroupInputOperationOutputAlias =
    crate::operation::DescribeInputSecurityGroup;
#[doc(hidden)]
pub type DescribeInputSecurityGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeInputSecurityGroupInput {
    /// Consumes the builder and constructs an Operation<[`DescribeInputSecurityGroup`](crate::operation::DescribeInputSecurityGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeInputSecurityGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeInputSecurityGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_24 = &_input.input_security_group_id;
            let input_24 =
                input_24
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "input_security_group_id",
                        details: "cannot be empty or unset",
                    })?;
            let input_security_group_id = aws_smithy_http::label::fmt_string(input_24, false);
            if input_security_group_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "input_security_group_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/prod/inputSecurityGroups/{InputSecurityGroupId}",
                InputSecurityGroupId = input_security_group_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeInputSecurityGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeInputSecurityGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeInputSecurityGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeInputSecurityGroup",
            "medialive",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeInputSecurityGroupInput`](crate::input::DescribeInputSecurityGroupInput)
    pub fn builder() -> crate::input::describe_input_security_group_input::Builder {
        crate::input::describe_input_security_group_input::Builder::default()
    }
}

/// See [`DescribeMultiplexInput`](crate::input::DescribeMultiplexInput)
pub mod describe_multiplex_input {
    /// A builder for [`DescribeMultiplexInput`](crate::input::DescribeMultiplexInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) multiplex_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ID of the multiplex.
        pub fn multiplex_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.multiplex_id = Some(input.into());
            self
        }
        /// The ID of the multiplex.
        pub fn set_multiplex_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.multiplex_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeMultiplexInput`](crate::input::DescribeMultiplexInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeMultiplexInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeMultiplexInput {
                multiplex_id: self.multiplex_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeMultiplexInputOperationOutputAlias = crate::operation::DescribeMultiplex;
#[doc(hidden)]
pub type DescribeMultiplexInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeMultiplexInput {
    /// Consumes the builder and constructs an Operation<[`DescribeMultiplex`](crate::operation::DescribeMultiplex)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeMultiplex,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeMultiplexInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_25 = &_input.multiplex_id;
            let input_25 =
                input_25
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "multiplex_id",
                        details: "cannot be empty or unset",
                    })?;
            let multiplex_id = aws_smithy_http::label::fmt_string(input_25, false);
            if multiplex_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "multiplex_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/prod/multiplexes/{MultiplexId}",
                MultiplexId = multiplex_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeMultiplexInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeMultiplexInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeMultiplex::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeMultiplex",
            "medialive",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeMultiplexInput`](crate::input::DescribeMultiplexInput)
    pub fn builder() -> crate::input::describe_multiplex_input::Builder {
        crate::input::describe_multiplex_input::Builder::default()
    }
}

/// See [`DescribeMultiplexProgramInput`](crate::input::DescribeMultiplexProgramInput)
pub mod describe_multiplex_program_input {
    /// A builder for [`DescribeMultiplexProgramInput`](crate::input::DescribeMultiplexProgramInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) multiplex_id: std::option::Option<std::string::String>,
        pub(crate) program_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ID of the multiplex that the program belongs to.
        pub fn multiplex_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.multiplex_id = Some(input.into());
            self
        }
        /// The ID of the multiplex that the program belongs to.
        pub fn set_multiplex_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.multiplex_id = input;
            self
        }
        /// The name of the program.
        pub fn program_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.program_name = Some(input.into());
            self
        }
        /// The name of the program.
        pub fn set_program_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.program_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeMultiplexProgramInput`](crate::input::DescribeMultiplexProgramInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeMultiplexProgramInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeMultiplexProgramInput {
                multiplex_id: self.multiplex_id,
                program_name: self.program_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeMultiplexProgramInputOperationOutputAlias =
    crate::operation::DescribeMultiplexProgram;
#[doc(hidden)]
pub type DescribeMultiplexProgramInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeMultiplexProgramInput {
    /// Consumes the builder and constructs an Operation<[`DescribeMultiplexProgram`](crate::operation::DescribeMultiplexProgram)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeMultiplexProgram,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeMultiplexProgramInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_26 = &_input.multiplex_id;
            let input_26 =
                input_26
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "multiplex_id",
                        details: "cannot be empty or unset",
                    })?;
            let multiplex_id = aws_smithy_http::label::fmt_string(input_26, false);
            if multiplex_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "multiplex_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_27 = &_input.program_name;
            let input_27 =
                input_27
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "program_name",
                        details: "cannot be empty or unset",
                    })?;
            let program_name = aws_smithy_http::label::fmt_string(input_27, false);
            if program_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "program_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/prod/multiplexes/{MultiplexId}/programs/{ProgramName}",
                MultiplexId = multiplex_id,
                ProgramName = program_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeMultiplexProgramInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeMultiplexProgramInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeMultiplexProgram::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeMultiplexProgram",
            "medialive",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeMultiplexProgramInput`](crate::input::DescribeMultiplexProgramInput)
    pub fn builder() -> crate::input::describe_multiplex_program_input::Builder {
        crate::input::describe_multiplex_program_input::Builder::default()
    }
}

/// See [`DescribeOfferingInput`](crate::input::DescribeOfferingInput)
pub mod describe_offering_input {
    /// A builder for [`DescribeOfferingInput`](crate::input::DescribeOfferingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) offering_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Unique offering ID, e.g. '87654321'
        pub fn offering_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.offering_id = Some(input.into());
            self
        }
        /// Unique offering ID, e.g. '87654321'
        pub fn set_offering_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.offering_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeOfferingInput`](crate::input::DescribeOfferingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeOfferingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeOfferingInput {
                offering_id: self.offering_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeOfferingInputOperationOutputAlias = crate::operation::DescribeOffering;
#[doc(hidden)]
pub type DescribeOfferingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeOfferingInput {
    /// Consumes the builder and constructs an Operation<[`DescribeOffering`](crate::operation::DescribeOffering)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeOffering,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeOfferingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_28 = &_input.offering_id;
            let input_28 =
                input_28
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "offering_id",
                        details: "cannot be empty or unset",
                    })?;
            let offering_id = aws_smithy_http::label::fmt_string(input_28, false);
            if offering_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "offering_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/prod/offerings/{OfferingId}",
                OfferingId = offering_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeOfferingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeOfferingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeOffering::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeOffering",
            "medialive",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeOfferingInput`](crate::input::DescribeOfferingInput)
    pub fn builder() -> crate::input::describe_offering_input::Builder {
        crate::input::describe_offering_input::Builder::default()
    }
}

/// See [`DescribeReservationInput`](crate::input::DescribeReservationInput)
pub mod describe_reservation_input {
    /// A builder for [`DescribeReservationInput`](crate::input::DescribeReservationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reservation_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Unique reservation ID, e.g. '1234567'
        pub fn reservation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.reservation_id = Some(input.into());
            self
        }
        /// Unique reservation ID, e.g. '1234567'
        pub fn set_reservation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reservation_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeReservationInput`](crate::input::DescribeReservationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeReservationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeReservationInput {
                reservation_id: self.reservation_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeReservationInputOperationOutputAlias = crate::operation::DescribeReservation;
#[doc(hidden)]
pub type DescribeReservationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeReservationInput {
    /// Consumes the builder and constructs an Operation<[`DescribeReservation`](crate::operation::DescribeReservation)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeReservation,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeReservationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_29 = &_input.reservation_id;
            let input_29 =
                input_29
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "reservation_id",
                        details: "cannot be empty or unset",
                    })?;
            let reservation_id = aws_smithy_http::label::fmt_string(input_29, false);
            if reservation_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "reservation_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/prod/reservations/{ReservationId}",
                ReservationId = reservation_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeReservationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeReservationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeReservation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeReservation",
            "medialive",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeReservationInput`](crate::input::DescribeReservationInput)
    pub fn builder() -> crate::input::describe_reservation_input::Builder {
        crate::input::describe_reservation_input::Builder::default()
    }
}

/// See [`DescribeScheduleInput`](crate::input::DescribeScheduleInput)
pub mod describe_schedule_input {
    /// A builder for [`DescribeScheduleInput`](crate::input::DescribeScheduleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Id of the channel whose schedule is being updated.
        pub fn channel_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_id = Some(input.into());
            self
        }
        /// Id of the channel whose schedule is being updated.
        pub fn set_channel_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_id = input;
            self
        }
        /// Placeholder documentation for MaxResults
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// Placeholder documentation for MaxResults
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Placeholder documentation for __string
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// Placeholder documentation for __string
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeScheduleInput`](crate::input::DescribeScheduleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeScheduleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeScheduleInput {
                channel_id: self.channel_id,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeScheduleInputOperationOutputAlias = crate::operation::DescribeSchedule;
#[doc(hidden)]
pub type DescribeScheduleInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeScheduleInput {
    /// Consumes the builder and constructs an Operation<[`DescribeSchedule`](crate::operation::DescribeSchedule)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeSchedule,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeScheduleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_30 = &_input.channel_id;
            let input_30 =
                input_30
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_id",
                        details: "cannot be empty or unset",
                    })?;
            let channel_id = aws_smithy_http::label::fmt_string(input_30, false);
            if channel_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/prod/channels/{ChannelId}/schedule",
                ChannelId = channel_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::DescribeScheduleInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_31) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_31));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeScheduleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeScheduleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeSchedule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeSchedule",
            "medialive",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeScheduleInput`](crate::input::DescribeScheduleInput)
    pub fn builder() -> crate::input::describe_schedule_input::Builder {
        crate::input::describe_schedule_input::Builder::default()
    }
}

/// See [`ListChannelsInput`](crate::input::ListChannelsInput)
pub mod list_channels_input {
    /// A builder for [`ListChannelsInput`](crate::input::ListChannelsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Placeholder documentation for MaxResults
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// Placeholder documentation for MaxResults
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Placeholder documentation for __string
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// Placeholder documentation for __string
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListChannelsInput`](crate::input::ListChannelsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListChannelsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListChannelsInput {
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListChannelsInputOperationOutputAlias = crate::operation::ListChannels;
#[doc(hidden)]
pub type ListChannelsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListChannelsInput {
    /// Consumes the builder and constructs an Operation<[`ListChannels`](crate::operation::ListChannels)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListChannels,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListChannelsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/prod/channels").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListChannelsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_32) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_32));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListChannelsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListChannelsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListChannels::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListChannels",
            "medialive",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListChannelsInput`](crate::input::ListChannelsInput)
    pub fn builder() -> crate::input::list_channels_input::Builder {
        crate::input::list_channels_input::Builder::default()
    }
}

/// See [`ListInputDevicesInput`](crate::input::ListInputDevicesInput)
pub mod list_input_devices_input {
    /// A builder for [`ListInputDevicesInput`](crate::input::ListInputDevicesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Placeholder documentation for MaxResults
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// Placeholder documentation for MaxResults
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Placeholder documentation for __string
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// Placeholder documentation for __string
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListInputDevicesInput`](crate::input::ListInputDevicesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListInputDevicesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListInputDevicesInput {
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListInputDevicesInputOperationOutputAlias = crate::operation::ListInputDevices;
#[doc(hidden)]
pub type ListInputDevicesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListInputDevicesInput {
    /// Consumes the builder and constructs an Operation<[`ListInputDevices`](crate::operation::ListInputDevices)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListInputDevices,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListInputDevicesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/prod/inputDevices").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListInputDevicesInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_33) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_33));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListInputDevicesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListInputDevicesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListInputDevices::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListInputDevices",
            "medialive",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListInputDevicesInput`](crate::input::ListInputDevicesInput)
    pub fn builder() -> crate::input::list_input_devices_input::Builder {
        crate::input::list_input_devices_input::Builder::default()
    }
}

/// See [`ListInputDeviceTransfersInput`](crate::input::ListInputDeviceTransfersInput)
pub mod list_input_device_transfers_input {
    /// A builder for [`ListInputDeviceTransfersInput`](crate::input::ListInputDeviceTransfersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) transfer_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Placeholder documentation for MaxResults
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// Placeholder documentation for MaxResults
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Placeholder documentation for __string
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// Placeholder documentation for __string
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Placeholder documentation for __string
        pub fn transfer_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.transfer_type = Some(input.into());
            self
        }
        /// Placeholder documentation for __string
        pub fn set_transfer_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.transfer_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ListInputDeviceTransfersInput`](crate::input::ListInputDeviceTransfersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListInputDeviceTransfersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListInputDeviceTransfersInput {
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
                transfer_type: self.transfer_type,
            })
        }
    }
}
#[doc(hidden)]
pub type ListInputDeviceTransfersInputOperationOutputAlias =
    crate::operation::ListInputDeviceTransfers;
#[doc(hidden)]
pub type ListInputDeviceTransfersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListInputDeviceTransfersInput {
    /// Consumes the builder and constructs an Operation<[`ListInputDeviceTransfers`](crate::operation::ListInputDeviceTransfers)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListInputDeviceTransfers,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListInputDeviceTransfersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/prod/inputDeviceTransfers").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListInputDeviceTransfersInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_34) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_34));
            }
            if let Some(inner_35) = &_input.transfer_type {
                query.push_kv(
                    "transferType",
                    &aws_smithy_http::query::fmt_string(&inner_35),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListInputDeviceTransfersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListInputDeviceTransfersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListInputDeviceTransfers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListInputDeviceTransfers",
            "medialive",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListInputDeviceTransfersInput`](crate::input::ListInputDeviceTransfersInput)
    pub fn builder() -> crate::input::list_input_device_transfers_input::Builder {
        crate::input::list_input_device_transfers_input::Builder::default()
    }
}

/// See [`ListInputsInput`](crate::input::ListInputsInput)
pub mod list_inputs_input {
    /// A builder for [`ListInputsInput`](crate::input::ListInputsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Placeholder documentation for MaxResults
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// Placeholder documentation for MaxResults
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Placeholder documentation for __string
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// Placeholder documentation for __string
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListInputsInput`](crate::input::ListInputsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListInputsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListInputsInput {
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListInputsInputOperationOutputAlias = crate::operation::ListInputs;
#[doc(hidden)]
pub type ListInputsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListInputsInput {
    /// Consumes the builder and constructs an Operation<[`ListInputs`](crate::operation::ListInputs)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListInputs,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListInputsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/prod/inputs").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListInputsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_36) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_36));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListInputsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListInputsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListInputs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListInputs",
            "medialive",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListInputsInput`](crate::input::ListInputsInput)
    pub fn builder() -> crate::input::list_inputs_input::Builder {
        crate::input::list_inputs_input::Builder::default()
    }
}

/// See [`ListInputSecurityGroupsInput`](crate::input::ListInputSecurityGroupsInput)
pub mod list_input_security_groups_input {
    /// A builder for [`ListInputSecurityGroupsInput`](crate::input::ListInputSecurityGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Placeholder documentation for MaxResults
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// Placeholder documentation for MaxResults
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Placeholder documentation for __string
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// Placeholder documentation for __string
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListInputSecurityGroupsInput`](crate::input::ListInputSecurityGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListInputSecurityGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListInputSecurityGroupsInput {
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListInputSecurityGroupsInputOperationOutputAlias =
    crate::operation::ListInputSecurityGroups;
#[doc(hidden)]
pub type ListInputSecurityGroupsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListInputSecurityGroupsInput {
    /// Consumes the builder and constructs an Operation<[`ListInputSecurityGroups`](crate::operation::ListInputSecurityGroups)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListInputSecurityGroups,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListInputSecurityGroupsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/prod/inputSecurityGroups").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListInputSecurityGroupsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_37) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_37));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListInputSecurityGroupsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListInputSecurityGroupsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListInputSecurityGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListInputSecurityGroups",
            "medialive",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListInputSecurityGroupsInput`](crate::input::ListInputSecurityGroupsInput)
    pub fn builder() -> crate::input::list_input_security_groups_input::Builder {
        crate::input::list_input_security_groups_input::Builder::default()
    }
}

/// See [`ListMultiplexesInput`](crate::input::ListMultiplexesInput)
pub mod list_multiplexes_input {
    /// A builder for [`ListMultiplexesInput`](crate::input::ListMultiplexesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The maximum number of items to return.
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// The maximum number of items to return.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// The token to retrieve the next page of results.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// The token to retrieve the next page of results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListMultiplexesInput`](crate::input::ListMultiplexesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListMultiplexesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListMultiplexesInput {
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListMultiplexesInputOperationOutputAlias = crate::operation::ListMultiplexes;
#[doc(hidden)]
pub type ListMultiplexesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListMultiplexesInput {
    /// Consumes the builder and constructs an Operation<[`ListMultiplexes`](crate::operation::ListMultiplexes)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListMultiplexes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListMultiplexesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/prod/multiplexes").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListMultiplexesInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_38) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_38));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListMultiplexesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListMultiplexesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListMultiplexes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListMultiplexes",
            "medialive",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListMultiplexesInput`](crate::input::ListMultiplexesInput)
    pub fn builder() -> crate::input::list_multiplexes_input::Builder {
        crate::input::list_multiplexes_input::Builder::default()
    }
}

/// See [`ListMultiplexProgramsInput`](crate::input::ListMultiplexProgramsInput)
pub mod list_multiplex_programs_input {
    /// A builder for [`ListMultiplexProgramsInput`](crate::input::ListMultiplexProgramsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) multiplex_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The maximum number of items to return.
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// The maximum number of items to return.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// The ID of the multiplex that the programs belong to.
        pub fn multiplex_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.multiplex_id = Some(input.into());
            self
        }
        /// The ID of the multiplex that the programs belong to.
        pub fn set_multiplex_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.multiplex_id = input;
            self
        }
        /// The token to retrieve the next page of results.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// The token to retrieve the next page of results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListMultiplexProgramsInput`](crate::input::ListMultiplexProgramsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListMultiplexProgramsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListMultiplexProgramsInput {
                max_results: self.max_results.unwrap_or_default(),
                multiplex_id: self.multiplex_id,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListMultiplexProgramsInputOperationOutputAlias = crate::operation::ListMultiplexPrograms;
#[doc(hidden)]
pub type ListMultiplexProgramsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListMultiplexProgramsInput {
    /// Consumes the builder and constructs an Operation<[`ListMultiplexPrograms`](crate::operation::ListMultiplexPrograms)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListMultiplexPrograms,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListMultiplexProgramsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_39 = &_input.multiplex_id;
            let input_39 =
                input_39
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "multiplex_id",
                        details: "cannot be empty or unset",
                    })?;
            let multiplex_id = aws_smithy_http::label::fmt_string(input_39, false);
            if multiplex_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "multiplex_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/prod/multiplexes/{MultiplexId}/programs",
                MultiplexId = multiplex_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListMultiplexProgramsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_40) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_40));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListMultiplexProgramsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListMultiplexProgramsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListMultiplexPrograms::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListMultiplexPrograms",
            "medialive",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListMultiplexProgramsInput`](crate::input::ListMultiplexProgramsInput)
    pub fn builder() -> crate::input::list_multiplex_programs_input::Builder {
        crate::input::list_multiplex_programs_input::Builder::default()
    }
}

/// See [`ListOfferingsInput`](crate::input::ListOfferingsInput)
pub mod list_offerings_input {
    /// A builder for [`ListOfferingsInput`](crate::input::ListOfferingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_class: std::option::Option<std::string::String>,
        pub(crate) channel_configuration: std::option::Option<std::string::String>,
        pub(crate) codec: std::option::Option<std::string::String>,
        pub(crate) duration: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) maximum_bitrate: std::option::Option<std::string::String>,
        pub(crate) maximum_framerate: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) resolution: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) special_feature: std::option::Option<std::string::String>,
        pub(crate) video_quality: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Filter by channel class, 'STANDARD' or 'SINGLE_PIPELINE'
        pub fn channel_class(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_class = Some(input.into());
            self
        }
        /// Filter by channel class, 'STANDARD' or 'SINGLE_PIPELINE'
        pub fn set_channel_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.channel_class = input;
            self
        }
        /// Filter to offerings that match the configuration of an existing channel, e.g. '2345678' (a channel ID)
        pub fn channel_configuration(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_configuration = Some(input.into());
            self
        }
        /// Filter to offerings that match the configuration of an existing channel, e.g. '2345678' (a channel ID)
        pub fn set_channel_configuration(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.channel_configuration = input;
            self
        }
        /// Filter by codec, 'AVC', 'HEVC', 'MPEG2', 'AUDIO', or 'LINK'
        pub fn codec(mut self, input: impl Into<std::string::String>) -> Self {
            self.codec = Some(input.into());
            self
        }
        /// Filter by codec, 'AVC', 'HEVC', 'MPEG2', 'AUDIO', or 'LINK'
        pub fn set_codec(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.codec = input;
            self
        }
        /// Filter by offering duration, e.g. '12'
        pub fn duration(mut self, input: impl Into<std::string::String>) -> Self {
            self.duration = Some(input.into());
            self
        }
        /// Filter by offering duration, e.g. '12'
        pub fn set_duration(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.duration = input;
            self
        }
        /// Placeholder documentation for MaxResults
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// Placeholder documentation for MaxResults
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Filter by bitrate, 'MAX_10_MBPS', 'MAX_20_MBPS', or 'MAX_50_MBPS'
        pub fn maximum_bitrate(mut self, input: impl Into<std::string::String>) -> Self {
            self.maximum_bitrate = Some(input.into());
            self
        }
        /// Filter by bitrate, 'MAX_10_MBPS', 'MAX_20_MBPS', or 'MAX_50_MBPS'
        pub fn set_maximum_bitrate(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.maximum_bitrate = input;
            self
        }
        /// Filter by framerate, 'MAX_30_FPS' or 'MAX_60_FPS'
        pub fn maximum_framerate(mut self, input: impl Into<std::string::String>) -> Self {
            self.maximum_framerate = Some(input.into());
            self
        }
        /// Filter by framerate, 'MAX_30_FPS' or 'MAX_60_FPS'
        pub fn set_maximum_framerate(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.maximum_framerate = input;
            self
        }
        /// Placeholder documentation for __string
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// Placeholder documentation for __string
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Filter by resolution, 'SD', 'HD', 'FHD', or 'UHD'
        pub fn resolution(mut self, input: impl Into<std::string::String>) -> Self {
            self.resolution = Some(input.into());
            self
        }
        /// Filter by resolution, 'SD', 'HD', 'FHD', or 'UHD'
        pub fn set_resolution(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resolution = input;
            self
        }
        /// Filter by resource type, 'INPUT', 'OUTPUT', 'MULTIPLEX', or 'CHANNEL'
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// Filter by resource type, 'INPUT', 'OUTPUT', 'MULTIPLEX', or 'CHANNEL'
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Filter by special feature, 'ADVANCED_AUDIO' or 'AUDIO_NORMALIZATION'
        pub fn special_feature(mut self, input: impl Into<std::string::String>) -> Self {
            self.special_feature = Some(input.into());
            self
        }
        /// Filter by special feature, 'ADVANCED_AUDIO' or 'AUDIO_NORMALIZATION'
        pub fn set_special_feature(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.special_feature = input;
            self
        }
        /// Filter by video quality, 'STANDARD', 'ENHANCED', or 'PREMIUM'
        pub fn video_quality(mut self, input: impl Into<std::string::String>) -> Self {
            self.video_quality = Some(input.into());
            self
        }
        /// Filter by video quality, 'STANDARD', 'ENHANCED', or 'PREMIUM'
        pub fn set_video_quality(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.video_quality = input;
            self
        }
        /// Consumes the builder and constructs a [`ListOfferingsInput`](crate::input::ListOfferingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListOfferingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListOfferingsInput {
                channel_class: self.channel_class,
                channel_configuration: self.channel_configuration,
                codec: self.codec,
                duration: self.duration,
                max_results: self.max_results.unwrap_or_default(),
                maximum_bitrate: self.maximum_bitrate,
                maximum_framerate: self.maximum_framerate,
                next_token: self.next_token,
                resolution: self.resolution,
                resource_type: self.resource_type,
                special_feature: self.special_feature,
                video_quality: self.video_quality,
            })
        }
    }
}
#[doc(hidden)]
pub type ListOfferingsInputOperationOutputAlias = crate::operation::ListOfferings;
#[doc(hidden)]
pub type ListOfferingsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListOfferingsInput {
    /// Consumes the builder and constructs an Operation<[`ListOfferings`](crate::operation::ListOfferings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListOfferings,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListOfferingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/prod/offerings").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListOfferingsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_41) = &_input.channel_class {
                query.push_kv(
                    "channelClass",
                    &aws_smithy_http::query::fmt_string(&inner_41),
                );
            }
            if let Some(inner_42) = &_input.channel_configuration {
                query.push_kv(
                    "channelConfiguration",
                    &aws_smithy_http::query::fmt_string(&inner_42),
                );
            }
            if let Some(inner_43) = &_input.codec {
                query.push_kv("codec", &aws_smithy_http::query::fmt_string(&inner_43));
            }
            if let Some(inner_44) = &_input.duration {
                query.push_kv("duration", &aws_smithy_http::query::fmt_string(&inner_44));
            }
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_45) = &_input.maximum_bitrate {
                query.push_kv(
                    "maximumBitrate",
                    &aws_smithy_http::query::fmt_string(&inner_45),
                );
            }
            if let Some(inner_46) = &_input.maximum_framerate {
                query.push_kv(
                    "maximumFramerate",
                    &aws_smithy_http::query::fmt_string(&inner_46),
                );
            }
            if let Some(inner_47) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_47));
            }
            if let Some(inner_48) = &_input.resolution {
                query.push_kv("resolution", &aws_smithy_http::query::fmt_string(&inner_48));
            }
            if let Some(inner_49) = &_input.resource_type {
                query.push_kv(
                    "resourceType",
                    &aws_smithy_http::query::fmt_string(&inner_49),
                );
            }
            if let Some(inner_50) = &_input.special_feature {
                query.push_kv(
                    "specialFeature",
                    &aws_smithy_http::query::fmt_string(&inner_50),
                );
            }
            if let Some(inner_51) = &_input.video_quality {
                query.push_kv(
                    "videoQuality",
                    &aws_smithy_http::query::fmt_string(&inner_51),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListOfferingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListOfferingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListOfferings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListOfferings",
            "medialive",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListOfferingsInput`](crate::input::ListOfferingsInput)
    pub fn builder() -> crate::input::list_offerings_input::Builder {
        crate::input::list_offerings_input::Builder::default()
    }
}

/// See [`ListReservationsInput`](crate::input::ListReservationsInput)
pub mod list_reservations_input {
    /// A builder for [`ListReservationsInput`](crate::input::ListReservationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_class: std::option::Option<std::string::String>,
        pub(crate) codec: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) maximum_bitrate: std::option::Option<std::string::String>,
        pub(crate) maximum_framerate: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) resolution: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) special_feature: std::option::Option<std::string::String>,
        pub(crate) video_quality: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Filter by channel class, 'STANDARD' or 'SINGLE_PIPELINE'
        pub fn channel_class(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_class = Some(input.into());
            self
        }
        /// Filter by channel class, 'STANDARD' or 'SINGLE_PIPELINE'
        pub fn set_channel_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.channel_class = input;
            self
        }
        /// Filter by codec, 'AVC', 'HEVC', 'MPEG2', 'AUDIO', or 'LINK'
        pub fn codec(mut self, input: impl Into<std::string::String>) -> Self {
            self.codec = Some(input.into());
            self
        }
        /// Filter by codec, 'AVC', 'HEVC', 'MPEG2', 'AUDIO', or 'LINK'
        pub fn set_codec(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.codec = input;
            self
        }
        /// Placeholder documentation for MaxResults
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// Placeholder documentation for MaxResults
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Filter by bitrate, 'MAX_10_MBPS', 'MAX_20_MBPS', or 'MAX_50_MBPS'
        pub fn maximum_bitrate(mut self, input: impl Into<std::string::String>) -> Self {
            self.maximum_bitrate = Some(input.into());
            self
        }
        /// Filter by bitrate, 'MAX_10_MBPS', 'MAX_20_MBPS', or 'MAX_50_MBPS'
        pub fn set_maximum_bitrate(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.maximum_bitrate = input;
            self
        }
        /// Filter by framerate, 'MAX_30_FPS' or 'MAX_60_FPS'
        pub fn maximum_framerate(mut self, input: impl Into<std::string::String>) -> Self {
            self.maximum_framerate = Some(input.into());
            self
        }
        /// Filter by framerate, 'MAX_30_FPS' or 'MAX_60_FPS'
        pub fn set_maximum_framerate(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.maximum_framerate = input;
            self
        }
        /// Placeholder documentation for __string
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// Placeholder documentation for __string
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Filter by resolution, 'SD', 'HD', 'FHD', or 'UHD'
        pub fn resolution(mut self, input: impl Into<std::string::String>) -> Self {
            self.resolution = Some(input.into());
            self
        }
        /// Filter by resolution, 'SD', 'HD', 'FHD', or 'UHD'
        pub fn set_resolution(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resolution = input;
            self
        }
        /// Filter by resource type, 'INPUT', 'OUTPUT', 'MULTIPLEX', or 'CHANNEL'
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// Filter by resource type, 'INPUT', 'OUTPUT', 'MULTIPLEX', or 'CHANNEL'
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Filter by special feature, 'ADVANCED_AUDIO' or 'AUDIO_NORMALIZATION'
        pub fn special_feature(mut self, input: impl Into<std::string::String>) -> Self {
            self.special_feature = Some(input.into());
            self
        }
        /// Filter by special feature, 'ADVANCED_AUDIO' or 'AUDIO_NORMALIZATION'
        pub fn set_special_feature(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.special_feature = input;
            self
        }
        /// Filter by video quality, 'STANDARD', 'ENHANCED', or 'PREMIUM'
        pub fn video_quality(mut self, input: impl Into<std::string::String>) -> Self {
            self.video_quality = Some(input.into());
            self
        }
        /// Filter by video quality, 'STANDARD', 'ENHANCED', or 'PREMIUM'
        pub fn set_video_quality(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.video_quality = input;
            self
        }
        /// Consumes the builder and constructs a [`ListReservationsInput`](crate::input::ListReservationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListReservationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListReservationsInput {
                channel_class: self.channel_class,
                codec: self.codec,
                max_results: self.max_results.unwrap_or_default(),
                maximum_bitrate: self.maximum_bitrate,
                maximum_framerate: self.maximum_framerate,
                next_token: self.next_token,
                resolution: self.resolution,
                resource_type: self.resource_type,
                special_feature: self.special_feature,
                video_quality: self.video_quality,
            })
        }
    }
}
#[doc(hidden)]
pub type ListReservationsInputOperationOutputAlias = crate::operation::ListReservations;
#[doc(hidden)]
pub type ListReservationsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListReservationsInput {
    /// Consumes the builder and constructs an Operation<[`ListReservations`](crate::operation::ListReservations)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListReservations,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListReservationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/prod/reservations").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListReservationsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_52) = &_input.channel_class {
                query.push_kv(
                    "channelClass",
                    &aws_smithy_http::query::fmt_string(&inner_52),
                );
            }
            if let Some(inner_53) = &_input.codec {
                query.push_kv("codec", &aws_smithy_http::query::fmt_string(&inner_53));
            }
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_54) = &_input.maximum_bitrate {
                query.push_kv(
                    "maximumBitrate",
                    &aws_smithy_http::query::fmt_string(&inner_54),
                );
            }
            if let Some(inner_55) = &_input.maximum_framerate {
                query.push_kv(
                    "maximumFramerate",
                    &aws_smithy_http::query::fmt_string(&inner_55),
                );
            }
            if let Some(inner_56) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_56));
            }
            if let Some(inner_57) = &_input.resolution {
                query.push_kv("resolution", &aws_smithy_http::query::fmt_string(&inner_57));
            }
            if let Some(inner_58) = &_input.resource_type {
                query.push_kv(
                    "resourceType",
                    &aws_smithy_http::query::fmt_string(&inner_58),
                );
            }
            if let Some(inner_59) = &_input.special_feature {
                query.push_kv(
                    "specialFeature",
                    &aws_smithy_http::query::fmt_string(&inner_59),
                );
            }
            if let Some(inner_60) = &_input.video_quality {
                query.push_kv(
                    "videoQuality",
                    &aws_smithy_http::query::fmt_string(&inner_60),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListReservationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListReservationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListReservations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListReservations",
            "medialive",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListReservationsInput`](crate::input::ListReservationsInput)
    pub fn builder() -> crate::input::list_reservations_input::Builder {
        crate::input::list_reservations_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Placeholder documentation for __string
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// Placeholder documentation for __string
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_61 = &_input.resource_arn;
            let input_61 =
                input_61
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_61, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/prod/tags/{ResourceArn}",
                ResourceArn = resource_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "medialive",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`PurchaseOfferingInput`](crate::input::PurchaseOfferingInput)
pub mod purchase_offering_input {
    /// A builder for [`PurchaseOfferingInput`](crate::input::PurchaseOfferingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) count: std::option::Option<i32>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) offering_id: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) start: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Number of resources
        pub fn count(mut self, input: i32) -> Self {
            self.count = Some(input);
            self
        }
        /// Number of resources
        pub fn set_count(mut self, input: std::option::Option<i32>) -> Self {
            self.count = input;
            self
        }
        /// Name for the new reservation
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// Name for the new reservation
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Offering to purchase, e.g. '87654321'
        pub fn offering_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.offering_id = Some(input.into());
            self
        }
        /// Offering to purchase, e.g. '87654321'
        pub fn set_offering_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.offering_id = input;
            self
        }
        /// Unique request ID to be specified. This is needed to prevent retries from creating multiple resources.
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// Unique request ID to be specified. This is needed to prevent retries from creating multiple resources.
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Requested reservation start time (UTC) in ISO-8601 format. The specified time must be between the first day of the current month and one year from now. If no value is given, the default is now.
        pub fn start(mut self, input: impl Into<std::string::String>) -> Self {
            self.start = Some(input.into());
            self
        }
        /// Requested reservation start time (UTC) in ISO-8601 format. The specified time must be between the first day of the current month and one year from now. If no value is given, the default is now.
        pub fn set_start(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.start = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of key-value pairs
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// A collection of key-value pairs
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`PurchaseOfferingInput`](crate::input::PurchaseOfferingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PurchaseOfferingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PurchaseOfferingInput {
                count: self.count.unwrap_or_default(),
                name: self.name,
                offering_id: self.offering_id,
                request_id: self.request_id,
                start: self.start,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type PurchaseOfferingInputOperationOutputAlias = crate::operation::PurchaseOffering;
#[doc(hidden)]
pub type PurchaseOfferingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PurchaseOfferingInput {
    /// Consumes the builder and constructs an Operation<[`PurchaseOffering`](crate::operation::PurchaseOffering)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PurchaseOffering,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PurchaseOfferingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_62 = &_input.offering_id;
            let input_62 =
                input_62
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "offering_id",
                        details: "cannot be empty or unset",
                    })?;
            let offering_id = aws_smithy_http::label::fmt_string(input_62, false);
            if offering_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "offering_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/prod/offerings/{OfferingId}/purchase",
                OfferingId = offering_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PurchaseOfferingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PurchaseOfferingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.request_id.is_none() {
            self.request_id = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_purchase_offering(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PurchaseOffering::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PurchaseOffering",
            "medialive",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PurchaseOfferingInput`](crate::input::PurchaseOfferingInput)
    pub fn builder() -> crate::input::purchase_offering_input::Builder {
        crate::input::purchase_offering_input::Builder::default()
    }
}

/// See [`RejectInputDeviceTransferInput`](crate::input::RejectInputDeviceTransferInput)
pub mod reject_input_device_transfer_input {
    /// A builder for [`RejectInputDeviceTransferInput`](crate::input::RejectInputDeviceTransferInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input_device_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The unique ID of the input device to reject. For example, hd-123456789abcdef.
        pub fn input_device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_device_id = Some(input.into());
            self
        }
        /// The unique ID of the input device to reject. For example, hd-123456789abcdef.
        pub fn set_input_device_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.input_device_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RejectInputDeviceTransferInput`](crate::input::RejectInputDeviceTransferInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RejectInputDeviceTransferInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RejectInputDeviceTransferInput {
                input_device_id: self.input_device_id,
            })
        }
    }
}
#[doc(hidden)]
pub type RejectInputDeviceTransferInputOperationOutputAlias =
    crate::operation::RejectInputDeviceTransfer;
#[doc(hidden)]
pub type RejectInputDeviceTransferInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl RejectInputDeviceTransferInput {
    /// Consumes the builder and constructs an Operation<[`RejectInputDeviceTransfer`](crate::operation::RejectInputDeviceTransfer)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RejectInputDeviceTransfer,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RejectInputDeviceTransferInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_63 = &_input.input_device_id;
            let input_63 =
                input_63
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "input_device_id",
                        details: "cannot be empty or unset",
                    })?;
            let input_device_id = aws_smithy_http::label::fmt_string(input_63, false);
            if input_device_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "input_device_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/prod/inputDevices/{InputDeviceId}/reject",
                InputDeviceId = input_device_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RejectInputDeviceTransferInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RejectInputDeviceTransferInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RejectInputDeviceTransfer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RejectInputDeviceTransfer",
            "medialive",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RejectInputDeviceTransferInput`](crate::input::RejectInputDeviceTransferInput)
    pub fn builder() -> crate::input::reject_input_device_transfer_input::Builder {
        crate::input::reject_input_device_transfer_input::Builder::default()
    }
}

/// See [`StartChannelInput`](crate::input::StartChannelInput)
pub mod start_channel_input {
    /// A builder for [`StartChannelInput`](crate::input::StartChannelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// A request to start a channel
        pub fn channel_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_id = Some(input.into());
            self
        }
        /// A request to start a channel
        pub fn set_channel_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StartChannelInput`](crate::input::StartChannelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartChannelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartChannelInput {
                channel_id: self.channel_id,
            })
        }
    }
}
#[doc(hidden)]
pub type StartChannelInputOperationOutputAlias = crate::operation::StartChannel;
#[doc(hidden)]
pub type StartChannelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartChannelInput {
    /// Consumes the builder and constructs an Operation<[`StartChannel`](crate::operation::StartChannel)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartChannel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartChannelInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_64 = &_input.channel_id;
            let input_64 =
                input_64
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_id",
                        details: "cannot be empty or unset",
                    })?;
            let channel_id = aws_smithy_http::label::fmt_string(input_64, false);
            if channel_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/prod/channels/{ChannelId}/start",
                ChannelId = channel_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartChannelInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartChannelInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartChannel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartChannel",
            "medialive",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartChannelInput`](crate::input::StartChannelInput)
    pub fn builder() -> crate::input::start_channel_input::Builder {
        crate::input::start_channel_input::Builder::default()
    }
}

/// See [`StartMultiplexInput`](crate::input::StartMultiplexInput)
pub mod start_multiplex_input {
    /// A builder for [`StartMultiplexInput`](crate::input::StartMultiplexInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) multiplex_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ID of the multiplex.
        pub fn multiplex_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.multiplex_id = Some(input.into());
            self
        }
        /// The ID of the multiplex.
        pub fn set_multiplex_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.multiplex_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StartMultiplexInput`](crate::input::StartMultiplexInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartMultiplexInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartMultiplexInput {
                multiplex_id: self.multiplex_id,
            })
        }
    }
}
#[doc(hidden)]
pub type StartMultiplexInputOperationOutputAlias = crate::operation::StartMultiplex;
#[doc(hidden)]
pub type StartMultiplexInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartMultiplexInput {
    /// Consumes the builder and constructs an Operation<[`StartMultiplex`](crate::operation::StartMultiplex)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartMultiplex,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartMultiplexInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_65 = &_input.multiplex_id;
            let input_65 =
                input_65
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "multiplex_id",
                        details: "cannot be empty or unset",
                    })?;
            let multiplex_id = aws_smithy_http::label::fmt_string(input_65, false);
            if multiplex_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "multiplex_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/prod/multiplexes/{MultiplexId}/start",
                MultiplexId = multiplex_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartMultiplexInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartMultiplexInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartMultiplex::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartMultiplex",
            "medialive",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartMultiplexInput`](crate::input::StartMultiplexInput)
    pub fn builder() -> crate::input::start_multiplex_input::Builder {
        crate::input::start_multiplex_input::Builder::default()
    }
}

/// See [`StopChannelInput`](crate::input::StopChannelInput)
pub mod stop_channel_input {
    /// A builder for [`StopChannelInput`](crate::input::StopChannelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// A request to stop a running channel
        pub fn channel_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_id = Some(input.into());
            self
        }
        /// A request to stop a running channel
        pub fn set_channel_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StopChannelInput`](crate::input::StopChannelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StopChannelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StopChannelInput {
                channel_id: self.channel_id,
            })
        }
    }
}
#[doc(hidden)]
pub type StopChannelInputOperationOutputAlias = crate::operation::StopChannel;
#[doc(hidden)]
pub type StopChannelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StopChannelInput {
    /// Consumes the builder and constructs an Operation<[`StopChannel`](crate::operation::StopChannel)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopChannel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StopChannelInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_66 = &_input.channel_id;
            let input_66 =
                input_66
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_id",
                        details: "cannot be empty or unset",
                    })?;
            let channel_id = aws_smithy_http::label::fmt_string(input_66, false);
            if channel_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/prod/channels/{ChannelId}/stop",
                ChannelId = channel_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StopChannelInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StopChannelInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StopChannel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StopChannel",
            "medialive",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StopChannelInput`](crate::input::StopChannelInput)
    pub fn builder() -> crate::input::stop_channel_input::Builder {
        crate::input::stop_channel_input::Builder::default()
    }
}

/// See [`StopMultiplexInput`](crate::input::StopMultiplexInput)
pub mod stop_multiplex_input {
    /// A builder for [`StopMultiplexInput`](crate::input::StopMultiplexInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) multiplex_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ID of the multiplex.
        pub fn multiplex_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.multiplex_id = Some(input.into());
            self
        }
        /// The ID of the multiplex.
        pub fn set_multiplex_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.multiplex_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StopMultiplexInput`](crate::input::StopMultiplexInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StopMultiplexInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StopMultiplexInput {
                multiplex_id: self.multiplex_id,
            })
        }
    }
}
#[doc(hidden)]
pub type StopMultiplexInputOperationOutputAlias = crate::operation::StopMultiplex;
#[doc(hidden)]
pub type StopMultiplexInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StopMultiplexInput {
    /// Consumes the builder and constructs an Operation<[`StopMultiplex`](crate::operation::StopMultiplex)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopMultiplex,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StopMultiplexInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_67 = &_input.multiplex_id;
            let input_67 =
                input_67
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "multiplex_id",
                        details: "cannot be empty or unset",
                    })?;
            let multiplex_id = aws_smithy_http::label::fmt_string(input_67, false);
            if multiplex_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "multiplex_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/prod/multiplexes/{MultiplexId}/stop",
                MultiplexId = multiplex_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StopMultiplexInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StopMultiplexInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StopMultiplex::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StopMultiplex",
            "medialive",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StopMultiplexInput`](crate::input::StopMultiplexInput)
    pub fn builder() -> crate::input::stop_multiplex_input::Builder {
        crate::input::stop_multiplex_input::Builder::default()
    }
}

/// See [`TransferInputDeviceInput`](crate::input::TransferInputDeviceInput)
pub mod transfer_input_device_input {
    /// A builder for [`TransferInputDeviceInput`](crate::input::TransferInputDeviceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input_device_id: std::option::Option<std::string::String>,
        pub(crate) target_customer_id: std::option::Option<std::string::String>,
        pub(crate) target_region: std::option::Option<std::string::String>,
        pub(crate) transfer_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The unique ID of this input device. For example, hd-123456789abcdef.
        pub fn input_device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_device_id = Some(input.into());
            self
        }
        /// The unique ID of this input device. For example, hd-123456789abcdef.
        pub fn set_input_device_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.input_device_id = input;
            self
        }
        /// The AWS account ID (12 digits) for the recipient of the device transfer.
        pub fn target_customer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_customer_id = Some(input.into());
            self
        }
        /// The AWS account ID (12 digits) for the recipient of the device transfer.
        pub fn set_target_customer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_customer_id = input;
            self
        }
        /// The target AWS region to transfer the device.
        pub fn target_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_region = Some(input.into());
            self
        }
        /// The target AWS region to transfer the device.
        pub fn set_target_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_region = input;
            self
        }
        /// An optional message for the recipient. Maximum 280 characters.
        pub fn transfer_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.transfer_message = Some(input.into());
            self
        }
        /// An optional message for the recipient. Maximum 280 characters.
        pub fn set_transfer_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.transfer_message = input;
            self
        }
        /// Consumes the builder and constructs a [`TransferInputDeviceInput`](crate::input::TransferInputDeviceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TransferInputDeviceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TransferInputDeviceInput {
                input_device_id: self.input_device_id,
                target_customer_id: self.target_customer_id,
                target_region: self.target_region,
                transfer_message: self.transfer_message,
            })
        }
    }
}
#[doc(hidden)]
pub type TransferInputDeviceInputOperationOutputAlias = crate::operation::TransferInputDevice;
#[doc(hidden)]
pub type TransferInputDeviceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TransferInputDeviceInput {
    /// Consumes the builder and constructs an Operation<[`TransferInputDevice`](crate::operation::TransferInputDevice)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TransferInputDevice,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TransferInputDeviceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_68 = &_input.input_device_id;
            let input_68 =
                input_68
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "input_device_id",
                        details: "cannot be empty or unset",
                    })?;
            let input_device_id = aws_smithy_http::label::fmt_string(input_68, false);
            if input_device_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "input_device_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/prod/inputDevices/{InputDeviceId}/transfer",
                InputDeviceId = input_device_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TransferInputDeviceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TransferInputDeviceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_transfer_input_device(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TransferInputDevice::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TransferInputDevice",
            "medialive",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TransferInputDeviceInput`](crate::input::TransferInputDeviceInput)
    pub fn builder() -> crate::input::transfer_input_device_input::Builder {
        crate::input::transfer_input_device_input::Builder::default()
    }
}

/// See [`UpdateChannelInput`](crate::input::UpdateChannelInput)
pub mod update_channel_input {
    /// A builder for [`UpdateChannelInput`](crate::input::UpdateChannelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cdi_input_specification:
            std::option::Option<crate::model::CdiInputSpecification>,
        pub(crate) channel_id: std::option::Option<std::string::String>,
        pub(crate) destinations:
            std::option::Option<std::vec::Vec<crate::model::OutputDestination>>,
        pub(crate) encoder_settings: std::option::Option<crate::model::EncoderSettings>,
        pub(crate) input_attachments:
            std::option::Option<std::vec::Vec<crate::model::InputAttachment>>,
        pub(crate) input_specification: std::option::Option<crate::model::InputSpecification>,
        pub(crate) log_level: std::option::Option<crate::model::LogLevel>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Specification of CDI inputs for this channel
        pub fn cdi_input_specification(
            mut self,
            input: crate::model::CdiInputSpecification,
        ) -> Self {
            self.cdi_input_specification = Some(input);
            self
        }
        /// Specification of CDI inputs for this channel
        pub fn set_cdi_input_specification(
            mut self,
            input: std::option::Option<crate::model::CdiInputSpecification>,
        ) -> Self {
            self.cdi_input_specification = input;
            self
        }
        /// channel ID
        pub fn channel_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_id = Some(input.into());
            self
        }
        /// channel ID
        pub fn set_channel_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_id = input;
            self
        }
        /// Appends an item to `destinations`.
        ///
        /// To override the contents of this collection use [`set_destinations`](Self::set_destinations).
        ///
        /// A list of output destinations for this channel.
        pub fn destinations(mut self, input: crate::model::OutputDestination) -> Self {
            let mut v = self.destinations.unwrap_or_default();
            v.push(input);
            self.destinations = Some(v);
            self
        }
        /// A list of output destinations for this channel.
        pub fn set_destinations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OutputDestination>>,
        ) -> Self {
            self.destinations = input;
            self
        }
        /// The encoder settings for this channel.
        pub fn encoder_settings(mut self, input: crate::model::EncoderSettings) -> Self {
            self.encoder_settings = Some(input);
            self
        }
        /// The encoder settings for this channel.
        pub fn set_encoder_settings(
            mut self,
            input: std::option::Option<crate::model::EncoderSettings>,
        ) -> Self {
            self.encoder_settings = input;
            self
        }
        /// Appends an item to `input_attachments`.
        ///
        /// To override the contents of this collection use [`set_input_attachments`](Self::set_input_attachments).
        ///
        /// Placeholder documentation for __listOfInputAttachment
        pub fn input_attachments(mut self, input: crate::model::InputAttachment) -> Self {
            let mut v = self.input_attachments.unwrap_or_default();
            v.push(input);
            self.input_attachments = Some(v);
            self
        }
        /// Placeholder documentation for __listOfInputAttachment
        pub fn set_input_attachments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InputAttachment>>,
        ) -> Self {
            self.input_attachments = input;
            self
        }
        /// Specification of network and file inputs for this channel
        pub fn input_specification(mut self, input: crate::model::InputSpecification) -> Self {
            self.input_specification = Some(input);
            self
        }
        /// Specification of network and file inputs for this channel
        pub fn set_input_specification(
            mut self,
            input: std::option::Option<crate::model::InputSpecification>,
        ) -> Self {
            self.input_specification = input;
            self
        }
        /// The log level to write to CloudWatch Logs.
        pub fn log_level(mut self, input: crate::model::LogLevel) -> Self {
            self.log_level = Some(input);
            self
        }
        /// The log level to write to CloudWatch Logs.
        pub fn set_log_level(mut self, input: std::option::Option<crate::model::LogLevel>) -> Self {
            self.log_level = input;
            self
        }
        /// The name of the channel.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// The name of the channel.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// An optional Amazon Resource Name (ARN) of the role to assume when running the Channel. If you do not specify this on an update call but the role was previously set that role will be removed.
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// An optional Amazon Resource Name (ARN) of the role to assume when running the Channel. If you do not specify this on an update call but the role was previously set that role will be removed.
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateChannelInput`](crate::input::UpdateChannelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateChannelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateChannelInput {
                cdi_input_specification: self.cdi_input_specification,
                channel_id: self.channel_id,
                destinations: self.destinations,
                encoder_settings: self.encoder_settings,
                input_attachments: self.input_attachments,
                input_specification: self.input_specification,
                log_level: self.log_level,
                name: self.name,
                role_arn: self.role_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateChannelInputOperationOutputAlias = crate::operation::UpdateChannel;
#[doc(hidden)]
pub type UpdateChannelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateChannelInput {
    /// Consumes the builder and constructs an Operation<[`UpdateChannel`](crate::operation::UpdateChannel)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateChannel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateChannelInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_69 = &_input.channel_id;
            let input_69 =
                input_69
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_id",
                        details: "cannot be empty or unset",
                    })?;
            let channel_id = aws_smithy_http::label::fmt_string(input_69, false);
            if channel_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/prod/channels/{ChannelId}", ChannelId = channel_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateChannelInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateChannelInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_channel(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateChannel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateChannel",
            "medialive",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateChannelInput`](crate::input::UpdateChannelInput)
    pub fn builder() -> crate::input::update_channel_input::Builder {
        crate::input::update_channel_input::Builder::default()
    }
}

/// See [`UpdateChannelClassInput`](crate::input::UpdateChannelClassInput)
pub mod update_channel_class_input {
    /// A builder for [`UpdateChannelClassInput`](crate::input::UpdateChannelClassInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_class: std::option::Option<crate::model::ChannelClass>,
        pub(crate) channel_id: std::option::Option<std::string::String>,
        pub(crate) destinations:
            std::option::Option<std::vec::Vec<crate::model::OutputDestination>>,
    }
    impl Builder {
        /// The channel class that you wish to update this channel to use.
        pub fn channel_class(mut self, input: crate::model::ChannelClass) -> Self {
            self.channel_class = Some(input);
            self
        }
        /// The channel class that you wish to update this channel to use.
        pub fn set_channel_class(
            mut self,
            input: std::option::Option<crate::model::ChannelClass>,
        ) -> Self {
            self.channel_class = input;
            self
        }
        /// Channel Id of the channel whose class should be updated.
        pub fn channel_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_id = Some(input.into());
            self
        }
        /// Channel Id of the channel whose class should be updated.
        pub fn set_channel_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_id = input;
            self
        }
        /// Appends an item to `destinations`.
        ///
        /// To override the contents of this collection use [`set_destinations`](Self::set_destinations).
        ///
        /// A list of output destinations for this channel.
        pub fn destinations(mut self, input: crate::model::OutputDestination) -> Self {
            let mut v = self.destinations.unwrap_or_default();
            v.push(input);
            self.destinations = Some(v);
            self
        }
        /// A list of output destinations for this channel.
        pub fn set_destinations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OutputDestination>>,
        ) -> Self {
            self.destinations = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateChannelClassInput`](crate::input::UpdateChannelClassInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateChannelClassInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateChannelClassInput {
                channel_class: self.channel_class,
                channel_id: self.channel_id,
                destinations: self.destinations,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateChannelClassInputOperationOutputAlias = crate::operation::UpdateChannelClass;
#[doc(hidden)]
pub type UpdateChannelClassInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateChannelClassInput {
    /// Consumes the builder and constructs an Operation<[`UpdateChannelClass`](crate::operation::UpdateChannelClass)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateChannelClass,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateChannelClassInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_70 = &_input.channel_id;
            let input_70 =
                input_70
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "channel_id",
                        details: "cannot be empty or unset",
                    })?;
            let channel_id = aws_smithy_http::label::fmt_string(input_70, false);
            if channel_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "channel_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/prod/channels/{ChannelId}/channelClass",
                ChannelId = channel_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateChannelClassInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateChannelClassInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_channel_class(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateChannelClass::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateChannelClass",
            "medialive",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateChannelClassInput`](crate::input::UpdateChannelClassInput)
    pub fn builder() -> crate::input::update_channel_class_input::Builder {
        crate::input::update_channel_class_input::Builder::default()
    }
}

/// See [`UpdateInputInput`](crate::input::UpdateInputInput)
pub mod update_input_input {
    /// A builder for [`UpdateInputInput`](crate::input::UpdateInputInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) destinations:
            std::option::Option<std::vec::Vec<crate::model::InputDestinationRequest>>,
        pub(crate) input_devices:
            std::option::Option<std::vec::Vec<crate::model::InputDeviceRequest>>,
        pub(crate) input_id: std::option::Option<std::string::String>,
        pub(crate) input_security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) media_connect_flows:
            std::option::Option<std::vec::Vec<crate::model::MediaConnectFlowRequest>>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) sources: std::option::Option<std::vec::Vec<crate::model::InputSourceRequest>>,
    }
    impl Builder {
        /// Appends an item to `destinations`.
        ///
        /// To override the contents of this collection use [`set_destinations`](Self::set_destinations).
        ///
        /// Destination settings for PUSH type inputs.
        pub fn destinations(mut self, input: crate::model::InputDestinationRequest) -> Self {
            let mut v = self.destinations.unwrap_or_default();
            v.push(input);
            self.destinations = Some(v);
            self
        }
        /// Destination settings for PUSH type inputs.
        pub fn set_destinations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InputDestinationRequest>>,
        ) -> Self {
            self.destinations = input;
            self
        }
        /// Appends an item to `input_devices`.
        ///
        /// To override the contents of this collection use [`set_input_devices`](Self::set_input_devices).
        ///
        /// Settings for the devices.
        pub fn input_devices(mut self, input: crate::model::InputDeviceRequest) -> Self {
            let mut v = self.input_devices.unwrap_or_default();
            v.push(input);
            self.input_devices = Some(v);
            self
        }
        /// Settings for the devices.
        pub fn set_input_devices(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InputDeviceRequest>>,
        ) -> Self {
            self.input_devices = input;
            self
        }
        /// Unique ID of the input.
        pub fn input_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_id = Some(input.into());
            self
        }
        /// Unique ID of the input.
        pub fn set_input_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.input_id = input;
            self
        }
        /// Appends an item to `input_security_groups`.
        ///
        /// To override the contents of this collection use [`set_input_security_groups`](Self::set_input_security_groups).
        ///
        /// A list of security groups referenced by IDs to attach to the input.
        pub fn input_security_groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.input_security_groups.unwrap_or_default();
            v.push(input.into());
            self.input_security_groups = Some(v);
            self
        }
        /// A list of security groups referenced by IDs to attach to the input.
        pub fn set_input_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.input_security_groups = input;
            self
        }
        /// Appends an item to `media_connect_flows`.
        ///
        /// To override the contents of this collection use [`set_media_connect_flows`](Self::set_media_connect_flows).
        ///
        /// A list of the MediaConnect Flow ARNs that you want to use as the source of the input. You can specify as few as one Flow and presently, as many as two. The only requirement is when you have more than one is that each Flow is in a separate Availability Zone as this ensures your EML input is redundant to AZ issues.
        pub fn media_connect_flows(mut self, input: crate::model::MediaConnectFlowRequest) -> Self {
            let mut v = self.media_connect_flows.unwrap_or_default();
            v.push(input);
            self.media_connect_flows = Some(v);
            self
        }
        /// A list of the MediaConnect Flow ARNs that you want to use as the source of the input. You can specify as few as one Flow and presently, as many as two. The only requirement is when you have more than one is that each Flow is in a separate Availability Zone as this ensures your EML input is redundant to AZ issues.
        pub fn set_media_connect_flows(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MediaConnectFlowRequest>>,
        ) -> Self {
            self.media_connect_flows = input;
            self
        }
        /// Name of the input.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// Name of the input.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// The Amazon Resource Name (ARN) of the role this input assumes during and after creation.
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) of the role this input assumes during and after creation.
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Appends an item to `sources`.
        ///
        /// To override the contents of this collection use [`set_sources`](Self::set_sources).
        ///
        /// The source URLs for a PULL-type input. Every PULL type input needs exactly two source URLs for redundancy. Only specify sources for PULL type Inputs. Leave Destinations empty.
        pub fn sources(mut self, input: crate::model::InputSourceRequest) -> Self {
            let mut v = self.sources.unwrap_or_default();
            v.push(input);
            self.sources = Some(v);
            self
        }
        /// The source URLs for a PULL-type input. Every PULL type input needs exactly two source URLs for redundancy. Only specify sources for PULL type Inputs. Leave Destinations empty.
        pub fn set_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InputSourceRequest>>,
        ) -> Self {
            self.sources = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateInputInput`](crate::input::UpdateInputInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateInputInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateInputInput {
                destinations: self.destinations,
                input_devices: self.input_devices,
                input_id: self.input_id,
                input_security_groups: self.input_security_groups,
                media_connect_flows: self.media_connect_flows,
                name: self.name,
                role_arn: self.role_arn,
                sources: self.sources,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateInputInputOperationOutputAlias = crate::operation::UpdateInput;
#[doc(hidden)]
pub type UpdateInputInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateInputInput {
    /// Consumes the builder and constructs an Operation<[`UpdateInput`](crate::operation::UpdateInput)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateInput,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateInputInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_71 = &_input.input_id;
            let input_71 =
                input_71
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "input_id",
                        details: "cannot be empty or unset",
                    })?;
            let input_id = aws_smithy_http::label::fmt_string(input_71, false);
            if input_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "input_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/prod/inputs/{InputId}", InputId = input_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateInputInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateInputInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_input(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateInput::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateInput",
            "medialive",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateInputInput`](crate::input::UpdateInputInput)
    pub fn builder() -> crate::input::update_input_input::Builder {
        crate::input::update_input_input::Builder::default()
    }
}

/// See [`UpdateInputDeviceInput`](crate::input::UpdateInputDeviceInput)
pub mod update_input_device_input {
    /// A builder for [`UpdateInputDeviceInput`](crate::input::UpdateInputDeviceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hd_device_settings:
            std::option::Option<crate::model::InputDeviceConfigurableSettings>,
        pub(crate) input_device_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) uhd_device_settings:
            std::option::Option<crate::model::InputDeviceConfigurableSettings>,
    }
    impl Builder {
        /// The settings that you want to apply to the HD input device.
        pub fn hd_device_settings(
            mut self,
            input: crate::model::InputDeviceConfigurableSettings,
        ) -> Self {
            self.hd_device_settings = Some(input);
            self
        }
        /// The settings that you want to apply to the HD input device.
        pub fn set_hd_device_settings(
            mut self,
            input: std::option::Option<crate::model::InputDeviceConfigurableSettings>,
        ) -> Self {
            self.hd_device_settings = input;
            self
        }
        /// The unique ID of the input device. For example, hd-123456789abcdef.
        pub fn input_device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_device_id = Some(input.into());
            self
        }
        /// The unique ID of the input device. For example, hd-123456789abcdef.
        pub fn set_input_device_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.input_device_id = input;
            self
        }
        /// The name that you assigned to this input device (not the unique ID).
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// The name that you assigned to this input device (not the unique ID).
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// The settings that you want to apply to the UHD input device.
        pub fn uhd_device_settings(
            mut self,
            input: crate::model::InputDeviceConfigurableSettings,
        ) -> Self {
            self.uhd_device_settings = Some(input);
            self
        }
        /// The settings that you want to apply to the UHD input device.
        pub fn set_uhd_device_settings(
            mut self,
            input: std::option::Option<crate::model::InputDeviceConfigurableSettings>,
        ) -> Self {
            self.uhd_device_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateInputDeviceInput`](crate::input::UpdateInputDeviceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateInputDeviceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateInputDeviceInput {
                hd_device_settings: self.hd_device_settings,
                input_device_id: self.input_device_id,
                name: self.name,
                uhd_device_settings: self.uhd_device_settings,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateInputDeviceInputOperationOutputAlias = crate::operation::UpdateInputDevice;
#[doc(hidden)]
pub type UpdateInputDeviceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateInputDeviceInput {
    /// Consumes the builder and constructs an Operation<[`UpdateInputDevice`](crate::operation::UpdateInputDevice)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateInputDevice,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateInputDeviceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_72 = &_input.input_device_id;
            let input_72 =
                input_72
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "input_device_id",
                        details: "cannot be empty or unset",
                    })?;
            let input_device_id = aws_smithy_http::label::fmt_string(input_72, false);
            if input_device_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "input_device_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/prod/inputDevices/{InputDeviceId}",
                InputDeviceId = input_device_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateInputDeviceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateInputDeviceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_input_device(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateInputDevice::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateInputDevice",
            "medialive",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateInputDeviceInput`](crate::input::UpdateInputDeviceInput)
    pub fn builder() -> crate::input::update_input_device_input::Builder {
        crate::input::update_input_device_input::Builder::default()
    }
}

/// See [`UpdateInputSecurityGroupInput`](crate::input::UpdateInputSecurityGroupInput)
pub mod update_input_security_group_input {
    /// A builder for [`UpdateInputSecurityGroupInput`](crate::input::UpdateInputSecurityGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input_security_group_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) whitelist_rules:
            std::option::Option<std::vec::Vec<crate::model::InputWhitelistRuleCidr>>,
    }
    impl Builder {
        /// The id of the Input Security Group to update.
        pub fn input_security_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_security_group_id = Some(input.into());
            self
        }
        /// The id of the Input Security Group to update.
        pub fn set_input_security_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.input_security_group_id = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of key-value pairs.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// A collection of key-value pairs.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Appends an item to `whitelist_rules`.
        ///
        /// To override the contents of this collection use [`set_whitelist_rules`](Self::set_whitelist_rules).
        ///
        /// List of IPv4 CIDR addresses to whitelist
        pub fn whitelist_rules(mut self, input: crate::model::InputWhitelistRuleCidr) -> Self {
            let mut v = self.whitelist_rules.unwrap_or_default();
            v.push(input);
            self.whitelist_rules = Some(v);
            self
        }
        /// List of IPv4 CIDR addresses to whitelist
        pub fn set_whitelist_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InputWhitelistRuleCidr>>,
        ) -> Self {
            self.whitelist_rules = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateInputSecurityGroupInput`](crate::input::UpdateInputSecurityGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateInputSecurityGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateInputSecurityGroupInput {
                input_security_group_id: self.input_security_group_id,
                tags: self.tags,
                whitelist_rules: self.whitelist_rules,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateInputSecurityGroupInputOperationOutputAlias =
    crate::operation::UpdateInputSecurityGroup;
#[doc(hidden)]
pub type UpdateInputSecurityGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateInputSecurityGroupInput {
    /// Consumes the builder and constructs an Operation<[`UpdateInputSecurityGroup`](crate::operation::UpdateInputSecurityGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateInputSecurityGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateInputSecurityGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_73 = &_input.input_security_group_id;
            let input_73 =
                input_73
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "input_security_group_id",
                        details: "cannot be empty or unset",
                    })?;
            let input_security_group_id = aws_smithy_http::label::fmt_string(input_73, false);
            if input_security_group_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "input_security_group_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/prod/inputSecurityGroups/{InputSecurityGroupId}",
                InputSecurityGroupId = input_security_group_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateInputSecurityGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateInputSecurityGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_input_security_group(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateInputSecurityGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateInputSecurityGroup",
            "medialive",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateInputSecurityGroupInput`](crate::input::UpdateInputSecurityGroupInput)
    pub fn builder() -> crate::input::update_input_security_group_input::Builder {
        crate::input::update_input_security_group_input::Builder::default()
    }
}

/// See [`UpdateMultiplexInput`](crate::input::UpdateMultiplexInput)
pub mod update_multiplex_input {
    /// A builder for [`UpdateMultiplexInput`](crate::input::UpdateMultiplexInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) multiplex_id: std::option::Option<std::string::String>,
        pub(crate) multiplex_settings: std::option::Option<crate::model::MultiplexSettings>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// ID of the multiplex to update.
        pub fn multiplex_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.multiplex_id = Some(input.into());
            self
        }
        /// ID of the multiplex to update.
        pub fn set_multiplex_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.multiplex_id = input;
            self
        }
        /// The new settings for a multiplex.
        pub fn multiplex_settings(mut self, input: crate::model::MultiplexSettings) -> Self {
            self.multiplex_settings = Some(input);
            self
        }
        /// The new settings for a multiplex.
        pub fn set_multiplex_settings(
            mut self,
            input: std::option::Option<crate::model::MultiplexSettings>,
        ) -> Self {
            self.multiplex_settings = input;
            self
        }
        /// Name of the multiplex.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// Name of the multiplex.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateMultiplexInput`](crate::input::UpdateMultiplexInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateMultiplexInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateMultiplexInput {
                multiplex_id: self.multiplex_id,
                multiplex_settings: self.multiplex_settings,
                name: self.name,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateMultiplexInputOperationOutputAlias = crate::operation::UpdateMultiplex;
#[doc(hidden)]
pub type UpdateMultiplexInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateMultiplexInput {
    /// Consumes the builder and constructs an Operation<[`UpdateMultiplex`](crate::operation::UpdateMultiplex)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateMultiplex,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateMultiplexInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_74 = &_input.multiplex_id;
            let input_74 =
                input_74
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "multiplex_id",
                        details: "cannot be empty or unset",
                    })?;
            let multiplex_id = aws_smithy_http::label::fmt_string(input_74, false);
            if multiplex_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "multiplex_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/prod/multiplexes/{MultiplexId}",
                MultiplexId = multiplex_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateMultiplexInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateMultiplexInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_multiplex(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateMultiplex::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateMultiplex",
            "medialive",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateMultiplexInput`](crate::input::UpdateMultiplexInput)
    pub fn builder() -> crate::input::update_multiplex_input::Builder {
        crate::input::update_multiplex_input::Builder::default()
    }
}

/// See [`UpdateMultiplexProgramInput`](crate::input::UpdateMultiplexProgramInput)
pub mod update_multiplex_program_input {
    /// A builder for [`UpdateMultiplexProgramInput`](crate::input::UpdateMultiplexProgramInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) multiplex_id: std::option::Option<std::string::String>,
        pub(crate) multiplex_program_settings:
            std::option::Option<crate::model::MultiplexProgramSettings>,
        pub(crate) program_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ID of the multiplex of the program to update.
        pub fn multiplex_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.multiplex_id = Some(input.into());
            self
        }
        /// The ID of the multiplex of the program to update.
        pub fn set_multiplex_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.multiplex_id = input;
            self
        }
        /// The new settings for a multiplex program.
        pub fn multiplex_program_settings(
            mut self,
            input: crate::model::MultiplexProgramSettings,
        ) -> Self {
            self.multiplex_program_settings = Some(input);
            self
        }
        /// The new settings for a multiplex program.
        pub fn set_multiplex_program_settings(
            mut self,
            input: std::option::Option<crate::model::MultiplexProgramSettings>,
        ) -> Self {
            self.multiplex_program_settings = input;
            self
        }
        /// The name of the program to update.
        pub fn program_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.program_name = Some(input.into());
            self
        }
        /// The name of the program to update.
        pub fn set_program_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.program_name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateMultiplexProgramInput`](crate::input::UpdateMultiplexProgramInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateMultiplexProgramInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateMultiplexProgramInput {
                multiplex_id: self.multiplex_id,
                multiplex_program_settings: self.multiplex_program_settings,
                program_name: self.program_name,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateMultiplexProgramInputOperationOutputAlias = crate::operation::UpdateMultiplexProgram;
#[doc(hidden)]
pub type UpdateMultiplexProgramInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateMultiplexProgramInput {
    /// Consumes the builder and constructs an Operation<[`UpdateMultiplexProgram`](crate::operation::UpdateMultiplexProgram)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateMultiplexProgram,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateMultiplexProgramInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_75 = &_input.multiplex_id;
            let input_75 =
                input_75
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "multiplex_id",
                        details: "cannot be empty or unset",
                    })?;
            let multiplex_id = aws_smithy_http::label::fmt_string(input_75, false);
            if multiplex_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "multiplex_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_76 = &_input.program_name;
            let input_76 =
                input_76
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "program_name",
                        details: "cannot be empty or unset",
                    })?;
            let program_name = aws_smithy_http::label::fmt_string(input_76, false);
            if program_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "program_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/prod/multiplexes/{MultiplexId}/programs/{ProgramName}",
                MultiplexId = multiplex_id,
                ProgramName = program_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateMultiplexProgramInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateMultiplexProgramInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_multiplex_program(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateMultiplexProgram::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateMultiplexProgram",
            "medialive",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateMultiplexProgramInput`](crate::input::UpdateMultiplexProgramInput)
    pub fn builder() -> crate::input::update_multiplex_program_input::Builder {
        crate::input::update_multiplex_program_input::Builder::default()
    }
}

/// See [`UpdateReservationInput`](crate::input::UpdateReservationInput)
pub mod update_reservation_input {
    /// A builder for [`UpdateReservationInput`](crate::input::UpdateReservationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) reservation_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Name of the reservation
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// Name of the reservation
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Unique reservation ID, e.g. '1234567'
        pub fn reservation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.reservation_id = Some(input.into());
            self
        }
        /// Unique reservation ID, e.g. '1234567'
        pub fn set_reservation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reservation_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateReservationInput`](crate::input::UpdateReservationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateReservationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateReservationInput {
                name: self.name,
                reservation_id: self.reservation_id,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateReservationInputOperationOutputAlias = crate::operation::UpdateReservation;
#[doc(hidden)]
pub type UpdateReservationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateReservationInput {
    /// Consumes the builder and constructs an Operation<[`UpdateReservation`](crate::operation::UpdateReservation)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateReservation,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateReservationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_77 = &_input.reservation_id;
            let input_77 =
                input_77
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "reservation_id",
                        details: "cannot be empty or unset",
                    })?;
            let reservation_id = aws_smithy_http::label::fmt_string(input_77, false);
            if reservation_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "reservation_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/prod/reservations/{ReservationId}",
                ReservationId = reservation_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateReservationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateReservationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_reservation(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateReservation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateReservation",
            "medialive",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateReservationInput`](crate::input::UpdateReservationInput)
    pub fn builder() -> crate::input::update_reservation_input::Builder {
        crate::input::update_reservation_input::Builder::default()
    }
}

/// Request to update a reservation
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateReservationInput {
    /// Name of the reservation
    pub name: std::option::Option<std::string::String>,
    /// Unique reservation ID, e.g. '1234567'
    pub reservation_id: std::option::Option<std::string::String>,
}
impl UpdateReservationInput {
    /// Name of the reservation
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// Unique reservation ID, e.g. '1234567'
    pub fn reservation_id(&self) -> std::option::Option<&str> {
        self.reservation_id.as_deref()
    }
}
impl std::fmt::Debug for UpdateReservationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateReservationInput");
        formatter.field("name", &self.name);
        formatter.field("reservation_id", &self.reservation_id);
        formatter.finish()
    }
}

/// A request to update a program in a multiplex.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateMultiplexProgramInput {
    /// The ID of the multiplex of the program to update.
    pub multiplex_id: std::option::Option<std::string::String>,
    /// The new settings for a multiplex program.
    pub multiplex_program_settings: std::option::Option<crate::model::MultiplexProgramSettings>,
    /// The name of the program to update.
    pub program_name: std::option::Option<std::string::String>,
}
impl UpdateMultiplexProgramInput {
    /// The ID of the multiplex of the program to update.
    pub fn multiplex_id(&self) -> std::option::Option<&str> {
        self.multiplex_id.as_deref()
    }
    /// The new settings for a multiplex program.
    pub fn multiplex_program_settings(
        &self,
    ) -> std::option::Option<&crate::model::MultiplexProgramSettings> {
        self.multiplex_program_settings.as_ref()
    }
    /// The name of the program to update.
    pub fn program_name(&self) -> std::option::Option<&str> {
        self.program_name.as_deref()
    }
}
impl std::fmt::Debug for UpdateMultiplexProgramInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateMultiplexProgramInput");
        formatter.field("multiplex_id", &self.multiplex_id);
        formatter.field(
            "multiplex_program_settings",
            &self.multiplex_program_settings,
        );
        formatter.field("program_name", &self.program_name);
        formatter.finish()
    }
}

/// A request to update a multiplex.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateMultiplexInput {
    /// ID of the multiplex to update.
    pub multiplex_id: std::option::Option<std::string::String>,
    /// The new settings for a multiplex.
    pub multiplex_settings: std::option::Option<crate::model::MultiplexSettings>,
    /// Name of the multiplex.
    pub name: std::option::Option<std::string::String>,
}
impl UpdateMultiplexInput {
    /// ID of the multiplex to update.
    pub fn multiplex_id(&self) -> std::option::Option<&str> {
        self.multiplex_id.as_deref()
    }
    /// The new settings for a multiplex.
    pub fn multiplex_settings(&self) -> std::option::Option<&crate::model::MultiplexSettings> {
        self.multiplex_settings.as_ref()
    }
    /// Name of the multiplex.
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for UpdateMultiplexInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateMultiplexInput");
        formatter.field("multiplex_id", &self.multiplex_id);
        formatter.field("multiplex_settings", &self.multiplex_settings);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

/// The request to update some combination of the Input Security Group name and the IPv4 CIDRs the Input Security Group should allow.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateInputSecurityGroupInput {
    /// The id of the Input Security Group to update.
    pub input_security_group_id: std::option::Option<std::string::String>,
    /// A collection of key-value pairs.
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// List of IPv4 CIDR addresses to whitelist
    pub whitelist_rules: std::option::Option<std::vec::Vec<crate::model::InputWhitelistRuleCidr>>,
}
impl UpdateInputSecurityGroupInput {
    /// The id of the Input Security Group to update.
    pub fn input_security_group_id(&self) -> std::option::Option<&str> {
        self.input_security_group_id.as_deref()
    }
    /// A collection of key-value pairs.
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// List of IPv4 CIDR addresses to whitelist
    pub fn whitelist_rules(&self) -> std::option::Option<&[crate::model::InputWhitelistRuleCidr]> {
        self.whitelist_rules.as_deref()
    }
}
impl std::fmt::Debug for UpdateInputSecurityGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateInputSecurityGroupInput");
        formatter.field("input_security_group_id", &self.input_security_group_id);
        formatter.field("tags", &self.tags);
        formatter.field("whitelist_rules", &self.whitelist_rules);
        formatter.finish()
    }
}

/// A request to update an input device.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateInputDeviceInput {
    /// The settings that you want to apply to the HD input device.
    pub hd_device_settings: std::option::Option<crate::model::InputDeviceConfigurableSettings>,
    /// The unique ID of the input device. For example, hd-123456789abcdef.
    pub input_device_id: std::option::Option<std::string::String>,
    /// The name that you assigned to this input device (not the unique ID).
    pub name: std::option::Option<std::string::String>,
    /// The settings that you want to apply to the UHD input device.
    pub uhd_device_settings: std::option::Option<crate::model::InputDeviceConfigurableSettings>,
}
impl UpdateInputDeviceInput {
    /// The settings that you want to apply to the HD input device.
    pub fn hd_device_settings(
        &self,
    ) -> std::option::Option<&crate::model::InputDeviceConfigurableSettings> {
        self.hd_device_settings.as_ref()
    }
    /// The unique ID of the input device. For example, hd-123456789abcdef.
    pub fn input_device_id(&self) -> std::option::Option<&str> {
        self.input_device_id.as_deref()
    }
    /// The name that you assigned to this input device (not the unique ID).
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// The settings that you want to apply to the UHD input device.
    pub fn uhd_device_settings(
        &self,
    ) -> std::option::Option<&crate::model::InputDeviceConfigurableSettings> {
        self.uhd_device_settings.as_ref()
    }
}
impl std::fmt::Debug for UpdateInputDeviceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateInputDeviceInput");
        formatter.field("hd_device_settings", &self.hd_device_settings);
        formatter.field("input_device_id", &self.input_device_id);
        formatter.field("name", &self.name);
        formatter.field("uhd_device_settings", &self.uhd_device_settings);
        formatter.finish()
    }
}

/// A request to update an input.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateInputInput {
    /// Destination settings for PUSH type inputs.
    pub destinations: std::option::Option<std::vec::Vec<crate::model::InputDestinationRequest>>,
    /// Settings for the devices.
    pub input_devices: std::option::Option<std::vec::Vec<crate::model::InputDeviceRequest>>,
    /// Unique ID of the input.
    pub input_id: std::option::Option<std::string::String>,
    /// A list of security groups referenced by IDs to attach to the input.
    pub input_security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
    /// A list of the MediaConnect Flow ARNs that you want to use as the source of the input. You can specify as few as one Flow and presently, as many as two. The only requirement is when you have more than one is that each Flow is in a separate Availability Zone as this ensures your EML input is redundant to AZ issues.
    pub media_connect_flows:
        std::option::Option<std::vec::Vec<crate::model::MediaConnectFlowRequest>>,
    /// Name of the input.
    pub name: std::option::Option<std::string::String>,
    /// The Amazon Resource Name (ARN) of the role this input assumes during and after creation.
    pub role_arn: std::option::Option<std::string::String>,
    /// The source URLs for a PULL-type input. Every PULL type input needs exactly two source URLs for redundancy. Only specify sources for PULL type Inputs. Leave Destinations empty.
    pub sources: std::option::Option<std::vec::Vec<crate::model::InputSourceRequest>>,
}
impl UpdateInputInput {
    /// Destination settings for PUSH type inputs.
    pub fn destinations(&self) -> std::option::Option<&[crate::model::InputDestinationRequest]> {
        self.destinations.as_deref()
    }
    /// Settings for the devices.
    pub fn input_devices(&self) -> std::option::Option<&[crate::model::InputDeviceRequest]> {
        self.input_devices.as_deref()
    }
    /// Unique ID of the input.
    pub fn input_id(&self) -> std::option::Option<&str> {
        self.input_id.as_deref()
    }
    /// A list of security groups referenced by IDs to attach to the input.
    pub fn input_security_groups(&self) -> std::option::Option<&[std::string::String]> {
        self.input_security_groups.as_deref()
    }
    /// A list of the MediaConnect Flow ARNs that you want to use as the source of the input. You can specify as few as one Flow and presently, as many as two. The only requirement is when you have more than one is that each Flow is in a separate Availability Zone as this ensures your EML input is redundant to AZ issues.
    pub fn media_connect_flows(
        &self,
    ) -> std::option::Option<&[crate::model::MediaConnectFlowRequest]> {
        self.media_connect_flows.as_deref()
    }
    /// Name of the input.
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// The Amazon Resource Name (ARN) of the role this input assumes during and after creation.
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// The source URLs for a PULL-type input. Every PULL type input needs exactly two source URLs for redundancy. Only specify sources for PULL type Inputs. Leave Destinations empty.
    pub fn sources(&self) -> std::option::Option<&[crate::model::InputSourceRequest]> {
        self.sources.as_deref()
    }
}
impl std::fmt::Debug for UpdateInputInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateInputInput");
        formatter.field("destinations", &self.destinations);
        formatter.field("input_devices", &self.input_devices);
        formatter.field("input_id", &self.input_id);
        formatter.field("input_security_groups", &self.input_security_groups);
        formatter.field("media_connect_flows", &self.media_connect_flows);
        formatter.field("name", &self.name);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("sources", &self.sources);
        formatter.finish()
    }
}

/// Channel class that the channel should be updated to.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateChannelClassInput {
    /// The channel class that you wish to update this channel to use.
    pub channel_class: std::option::Option<crate::model::ChannelClass>,
    /// Channel Id of the channel whose class should be updated.
    pub channel_id: std::option::Option<std::string::String>,
    /// A list of output destinations for this channel.
    pub destinations: std::option::Option<std::vec::Vec<crate::model::OutputDestination>>,
}
impl UpdateChannelClassInput {
    /// The channel class that you wish to update this channel to use.
    pub fn channel_class(&self) -> std::option::Option<&crate::model::ChannelClass> {
        self.channel_class.as_ref()
    }
    /// Channel Id of the channel whose class should be updated.
    pub fn channel_id(&self) -> std::option::Option<&str> {
        self.channel_id.as_deref()
    }
    /// A list of output destinations for this channel.
    pub fn destinations(&self) -> std::option::Option<&[crate::model::OutputDestination]> {
        self.destinations.as_deref()
    }
}
impl std::fmt::Debug for UpdateChannelClassInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateChannelClassInput");
        formatter.field("channel_class", &self.channel_class);
        formatter.field("channel_id", &self.channel_id);
        formatter.field("destinations", &self.destinations);
        formatter.finish()
    }
}

/// A request to update a channel.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateChannelInput {
    /// Specification of CDI inputs for this channel
    pub cdi_input_specification: std::option::Option<crate::model::CdiInputSpecification>,
    /// channel ID
    pub channel_id: std::option::Option<std::string::String>,
    /// A list of output destinations for this channel.
    pub destinations: std::option::Option<std::vec::Vec<crate::model::OutputDestination>>,
    /// The encoder settings for this channel.
    pub encoder_settings: std::option::Option<crate::model::EncoderSettings>,
    /// Placeholder documentation for __listOfInputAttachment
    pub input_attachments: std::option::Option<std::vec::Vec<crate::model::InputAttachment>>,
    /// Specification of network and file inputs for this channel
    pub input_specification: std::option::Option<crate::model::InputSpecification>,
    /// The log level to write to CloudWatch Logs.
    pub log_level: std::option::Option<crate::model::LogLevel>,
    /// The name of the channel.
    pub name: std::option::Option<std::string::String>,
    /// An optional Amazon Resource Name (ARN) of the role to assume when running the Channel. If you do not specify this on an update call but the role was previously set that role will be removed.
    pub role_arn: std::option::Option<std::string::String>,
}
impl UpdateChannelInput {
    /// Specification of CDI inputs for this channel
    pub fn cdi_input_specification(
        &self,
    ) -> std::option::Option<&crate::model::CdiInputSpecification> {
        self.cdi_input_specification.as_ref()
    }
    /// channel ID
    pub fn channel_id(&self) -> std::option::Option<&str> {
        self.channel_id.as_deref()
    }
    /// A list of output destinations for this channel.
    pub fn destinations(&self) -> std::option::Option<&[crate::model::OutputDestination]> {
        self.destinations.as_deref()
    }
    /// The encoder settings for this channel.
    pub fn encoder_settings(&self) -> std::option::Option<&crate::model::EncoderSettings> {
        self.encoder_settings.as_ref()
    }
    /// Placeholder documentation for __listOfInputAttachment
    pub fn input_attachments(&self) -> std::option::Option<&[crate::model::InputAttachment]> {
        self.input_attachments.as_deref()
    }
    /// Specification of network and file inputs for this channel
    pub fn input_specification(&self) -> std::option::Option<&crate::model::InputSpecification> {
        self.input_specification.as_ref()
    }
    /// The log level to write to CloudWatch Logs.
    pub fn log_level(&self) -> std::option::Option<&crate::model::LogLevel> {
        self.log_level.as_ref()
    }
    /// The name of the channel.
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// An optional Amazon Resource Name (ARN) of the role to assume when running the Channel. If you do not specify this on an update call but the role was previously set that role will be removed.
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
}
impl std::fmt::Debug for UpdateChannelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateChannelInput");
        formatter.field("cdi_input_specification", &self.cdi_input_specification);
        formatter.field("channel_id", &self.channel_id);
        formatter.field("destinations", &self.destinations);
        formatter.field("encoder_settings", &self.encoder_settings);
        formatter.field("input_attachments", &self.input_attachments);
        formatter.field("input_specification", &self.input_specification);
        formatter.field("log_level", &self.log_level);
        formatter.field("name", &self.name);
        formatter.field("role_arn", &self.role_arn);
        formatter.finish()
    }
}

/// A request to transfer an input device.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TransferInputDeviceInput {
    /// The unique ID of this input device. For example, hd-123456789abcdef.
    pub input_device_id: std::option::Option<std::string::String>,
    /// The AWS account ID (12 digits) for the recipient of the device transfer.
    pub target_customer_id: std::option::Option<std::string::String>,
    /// The target AWS region to transfer the device.
    pub target_region: std::option::Option<std::string::String>,
    /// An optional message for the recipient. Maximum 280 characters.
    pub transfer_message: std::option::Option<std::string::String>,
}
impl TransferInputDeviceInput {
    /// The unique ID of this input device. For example, hd-123456789abcdef.
    pub fn input_device_id(&self) -> std::option::Option<&str> {
        self.input_device_id.as_deref()
    }
    /// The AWS account ID (12 digits) for the recipient of the device transfer.
    pub fn target_customer_id(&self) -> std::option::Option<&str> {
        self.target_customer_id.as_deref()
    }
    /// The target AWS region to transfer the device.
    pub fn target_region(&self) -> std::option::Option<&str> {
        self.target_region.as_deref()
    }
    /// An optional message for the recipient. Maximum 280 characters.
    pub fn transfer_message(&self) -> std::option::Option<&str> {
        self.transfer_message.as_deref()
    }
}
impl std::fmt::Debug for TransferInputDeviceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TransferInputDeviceInput");
        formatter.field("input_device_id", &self.input_device_id);
        formatter.field("target_customer_id", &self.target_customer_id);
        formatter.field("target_region", &self.target_region);
        formatter.field("transfer_message", &self.transfer_message);
        formatter.finish()
    }
}

/// Placeholder documentation for StopMultiplexRequest
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopMultiplexInput {
    /// The ID of the multiplex.
    pub multiplex_id: std::option::Option<std::string::String>,
}
impl StopMultiplexInput {
    /// The ID of the multiplex.
    pub fn multiplex_id(&self) -> std::option::Option<&str> {
        self.multiplex_id.as_deref()
    }
}
impl std::fmt::Debug for StopMultiplexInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopMultiplexInput");
        formatter.field("multiplex_id", &self.multiplex_id);
        formatter.finish()
    }
}

/// Placeholder documentation for StopChannelRequest
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopChannelInput {
    /// A request to stop a running channel
    pub channel_id: std::option::Option<std::string::String>,
}
impl StopChannelInput {
    /// A request to stop a running channel
    pub fn channel_id(&self) -> std::option::Option<&str> {
        self.channel_id.as_deref()
    }
}
impl std::fmt::Debug for StopChannelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopChannelInput");
        formatter.field("channel_id", &self.channel_id);
        formatter.finish()
    }
}

/// Placeholder documentation for StartMultiplexRequest
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartMultiplexInput {
    /// The ID of the multiplex.
    pub multiplex_id: std::option::Option<std::string::String>,
}
impl StartMultiplexInput {
    /// The ID of the multiplex.
    pub fn multiplex_id(&self) -> std::option::Option<&str> {
        self.multiplex_id.as_deref()
    }
}
impl std::fmt::Debug for StartMultiplexInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartMultiplexInput");
        formatter.field("multiplex_id", &self.multiplex_id);
        formatter.finish()
    }
}

/// Placeholder documentation for StartChannelRequest
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartChannelInput {
    /// A request to start a channel
    pub channel_id: std::option::Option<std::string::String>,
}
impl StartChannelInput {
    /// A request to start a channel
    pub fn channel_id(&self) -> std::option::Option<&str> {
        self.channel_id.as_deref()
    }
}
impl std::fmt::Debug for StartChannelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartChannelInput");
        formatter.field("channel_id", &self.channel_id);
        formatter.finish()
    }
}

/// Placeholder documentation for RejectInputDeviceTransferRequest
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RejectInputDeviceTransferInput {
    /// The unique ID of the input device to reject. For example, hd-123456789abcdef.
    pub input_device_id: std::option::Option<std::string::String>,
}
impl RejectInputDeviceTransferInput {
    /// The unique ID of the input device to reject. For example, hd-123456789abcdef.
    pub fn input_device_id(&self) -> std::option::Option<&str> {
        self.input_device_id.as_deref()
    }
}
impl std::fmt::Debug for RejectInputDeviceTransferInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RejectInputDeviceTransferInput");
        formatter.field("input_device_id", &self.input_device_id);
        formatter.finish()
    }
}

/// Placeholder documentation for PurchaseOfferingRequest
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PurchaseOfferingInput {
    /// Number of resources
    pub count: i32,
    /// Name for the new reservation
    pub name: std::option::Option<std::string::String>,
    /// Offering to purchase, e.g. '87654321'
    pub offering_id: std::option::Option<std::string::String>,
    /// Unique request ID to be specified. This is needed to prevent retries from creating multiple resources.
    pub request_id: std::option::Option<std::string::String>,
    /// Requested reservation start time (UTC) in ISO-8601 format. The specified time must be between the first day of the current month and one year from now. If no value is given, the default is now.
    pub start: std::option::Option<std::string::String>,
    /// A collection of key-value pairs
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl PurchaseOfferingInput {
    /// Number of resources
    pub fn count(&self) -> i32 {
        self.count
    }
    /// Name for the new reservation
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// Offering to purchase, e.g. '87654321'
    pub fn offering_id(&self) -> std::option::Option<&str> {
        self.offering_id.as_deref()
    }
    /// Unique request ID to be specified. This is needed to prevent retries from creating multiple resources.
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// Requested reservation start time (UTC) in ISO-8601 format. The specified time must be between the first day of the current month and one year from now. If no value is given, the default is now.
    pub fn start(&self) -> std::option::Option<&str> {
        self.start.as_deref()
    }
    /// A collection of key-value pairs
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for PurchaseOfferingInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PurchaseOfferingInput");
        formatter.field("count", &self.count);
        formatter.field("name", &self.name);
        formatter.field("offering_id", &self.offering_id);
        formatter.field("request_id", &self.request_id);
        formatter.field("start", &self.start);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// Placeholder documentation for ListTagsForResourceRequest
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// Placeholder documentation for __string
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// Placeholder documentation for __string
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

/// Placeholder documentation for ListReservationsRequest
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListReservationsInput {
    /// Filter by channel class, 'STANDARD' or 'SINGLE_PIPELINE'
    pub channel_class: std::option::Option<std::string::String>,
    /// Filter by codec, 'AVC', 'HEVC', 'MPEG2', 'AUDIO', or 'LINK'
    pub codec: std::option::Option<std::string::String>,
    /// Placeholder documentation for MaxResults
    pub max_results: i32,
    /// Filter by bitrate, 'MAX_10_MBPS', 'MAX_20_MBPS', or 'MAX_50_MBPS'
    pub maximum_bitrate: std::option::Option<std::string::String>,
    /// Filter by framerate, 'MAX_30_FPS' or 'MAX_60_FPS'
    pub maximum_framerate: std::option::Option<std::string::String>,
    /// Placeholder documentation for __string
    pub next_token: std::option::Option<std::string::String>,
    /// Filter by resolution, 'SD', 'HD', 'FHD', or 'UHD'
    pub resolution: std::option::Option<std::string::String>,
    /// Filter by resource type, 'INPUT', 'OUTPUT', 'MULTIPLEX', or 'CHANNEL'
    pub resource_type: std::option::Option<std::string::String>,
    /// Filter by special feature, 'ADVANCED_AUDIO' or 'AUDIO_NORMALIZATION'
    pub special_feature: std::option::Option<std::string::String>,
    /// Filter by video quality, 'STANDARD', 'ENHANCED', or 'PREMIUM'
    pub video_quality: std::option::Option<std::string::String>,
}
impl ListReservationsInput {
    /// Filter by channel class, 'STANDARD' or 'SINGLE_PIPELINE'
    pub fn channel_class(&self) -> std::option::Option<&str> {
        self.channel_class.as_deref()
    }
    /// Filter by codec, 'AVC', 'HEVC', 'MPEG2', 'AUDIO', or 'LINK'
    pub fn codec(&self) -> std::option::Option<&str> {
        self.codec.as_deref()
    }
    /// Placeholder documentation for MaxResults
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// Filter by bitrate, 'MAX_10_MBPS', 'MAX_20_MBPS', or 'MAX_50_MBPS'
    pub fn maximum_bitrate(&self) -> std::option::Option<&str> {
        self.maximum_bitrate.as_deref()
    }
    /// Filter by framerate, 'MAX_30_FPS' or 'MAX_60_FPS'
    pub fn maximum_framerate(&self) -> std::option::Option<&str> {
        self.maximum_framerate.as_deref()
    }
    /// Placeholder documentation for __string
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// Filter by resolution, 'SD', 'HD', 'FHD', or 'UHD'
    pub fn resolution(&self) -> std::option::Option<&str> {
        self.resolution.as_deref()
    }
    /// Filter by resource type, 'INPUT', 'OUTPUT', 'MULTIPLEX', or 'CHANNEL'
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// Filter by special feature, 'ADVANCED_AUDIO' or 'AUDIO_NORMALIZATION'
    pub fn special_feature(&self) -> std::option::Option<&str> {
        self.special_feature.as_deref()
    }
    /// Filter by video quality, 'STANDARD', 'ENHANCED', or 'PREMIUM'
    pub fn video_quality(&self) -> std::option::Option<&str> {
        self.video_quality.as_deref()
    }
}
impl std::fmt::Debug for ListReservationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListReservationsInput");
        formatter.field("channel_class", &self.channel_class);
        formatter.field("codec", &self.codec);
        formatter.field("max_results", &self.max_results);
        formatter.field("maximum_bitrate", &self.maximum_bitrate);
        formatter.field("maximum_framerate", &self.maximum_framerate);
        formatter.field("next_token", &self.next_token);
        formatter.field("resolution", &self.resolution);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("special_feature", &self.special_feature);
        formatter.field("video_quality", &self.video_quality);
        formatter.finish()
    }
}

/// Placeholder documentation for ListOfferingsRequest
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListOfferingsInput {
    /// Filter by channel class, 'STANDARD' or 'SINGLE_PIPELINE'
    pub channel_class: std::option::Option<std::string::String>,
    /// Filter to offerings that match the configuration of an existing channel, e.g. '2345678' (a channel ID)
    pub channel_configuration: std::option::Option<std::string::String>,
    /// Filter by codec, 'AVC', 'HEVC', 'MPEG2', 'AUDIO', or 'LINK'
    pub codec: std::option::Option<std::string::String>,
    /// Filter by offering duration, e.g. '12'
    pub duration: std::option::Option<std::string::String>,
    /// Placeholder documentation for MaxResults
    pub max_results: i32,
    /// Filter by bitrate, 'MAX_10_MBPS', 'MAX_20_MBPS', or 'MAX_50_MBPS'
    pub maximum_bitrate: std::option::Option<std::string::String>,
    /// Filter by framerate, 'MAX_30_FPS' or 'MAX_60_FPS'
    pub maximum_framerate: std::option::Option<std::string::String>,
    /// Placeholder documentation for __string
    pub next_token: std::option::Option<std::string::String>,
    /// Filter by resolution, 'SD', 'HD', 'FHD', or 'UHD'
    pub resolution: std::option::Option<std::string::String>,
    /// Filter by resource type, 'INPUT', 'OUTPUT', 'MULTIPLEX', or 'CHANNEL'
    pub resource_type: std::option::Option<std::string::String>,
    /// Filter by special feature, 'ADVANCED_AUDIO' or 'AUDIO_NORMALIZATION'
    pub special_feature: std::option::Option<std::string::String>,
    /// Filter by video quality, 'STANDARD', 'ENHANCED', or 'PREMIUM'
    pub video_quality: std::option::Option<std::string::String>,
}
impl ListOfferingsInput {
    /// Filter by channel class, 'STANDARD' or 'SINGLE_PIPELINE'
    pub fn channel_class(&self) -> std::option::Option<&str> {
        self.channel_class.as_deref()
    }
    /// Filter to offerings that match the configuration of an existing channel, e.g. '2345678' (a channel ID)
    pub fn channel_configuration(&self) -> std::option::Option<&str> {
        self.channel_configuration.as_deref()
    }
    /// Filter by codec, 'AVC', 'HEVC', 'MPEG2', 'AUDIO', or 'LINK'
    pub fn codec(&self) -> std::option::Option<&str> {
        self.codec.as_deref()
    }
    /// Filter by offering duration, e.g. '12'
    pub fn duration(&self) -> std::option::Option<&str> {
        self.duration.as_deref()
    }
    /// Placeholder documentation for MaxResults
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// Filter by bitrate, 'MAX_10_MBPS', 'MAX_20_MBPS', or 'MAX_50_MBPS'
    pub fn maximum_bitrate(&self) -> std::option::Option<&str> {
        self.maximum_bitrate.as_deref()
    }
    /// Filter by framerate, 'MAX_30_FPS' or 'MAX_60_FPS'
    pub fn maximum_framerate(&self) -> std::option::Option<&str> {
        self.maximum_framerate.as_deref()
    }
    /// Placeholder documentation for __string
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// Filter by resolution, 'SD', 'HD', 'FHD', or 'UHD'
    pub fn resolution(&self) -> std::option::Option<&str> {
        self.resolution.as_deref()
    }
    /// Filter by resource type, 'INPUT', 'OUTPUT', 'MULTIPLEX', or 'CHANNEL'
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// Filter by special feature, 'ADVANCED_AUDIO' or 'AUDIO_NORMALIZATION'
    pub fn special_feature(&self) -> std::option::Option<&str> {
        self.special_feature.as_deref()
    }
    /// Filter by video quality, 'STANDARD', 'ENHANCED', or 'PREMIUM'
    pub fn video_quality(&self) -> std::option::Option<&str> {
        self.video_quality.as_deref()
    }
}
impl std::fmt::Debug for ListOfferingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListOfferingsInput");
        formatter.field("channel_class", &self.channel_class);
        formatter.field("channel_configuration", &self.channel_configuration);
        formatter.field("codec", &self.codec);
        formatter.field("duration", &self.duration);
        formatter.field("max_results", &self.max_results);
        formatter.field("maximum_bitrate", &self.maximum_bitrate);
        formatter.field("maximum_framerate", &self.maximum_framerate);
        formatter.field("next_token", &self.next_token);
        formatter.field("resolution", &self.resolution);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("special_feature", &self.special_feature);
        formatter.field("video_quality", &self.video_quality);
        formatter.finish()
    }
}

/// Placeholder documentation for ListMultiplexProgramsRequest
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListMultiplexProgramsInput {
    /// The maximum number of items to return.
    pub max_results: i32,
    /// The ID of the multiplex that the programs belong to.
    pub multiplex_id: std::option::Option<std::string::String>,
    /// The token to retrieve the next page of results.
    pub next_token: std::option::Option<std::string::String>,
}
impl ListMultiplexProgramsInput {
    /// The maximum number of items to return.
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// The ID of the multiplex that the programs belong to.
    pub fn multiplex_id(&self) -> std::option::Option<&str> {
        self.multiplex_id.as_deref()
    }
    /// The token to retrieve the next page of results.
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListMultiplexProgramsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListMultiplexProgramsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("multiplex_id", &self.multiplex_id);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// Placeholder documentation for ListMultiplexesRequest
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListMultiplexesInput {
    /// The maximum number of items to return.
    pub max_results: i32,
    /// The token to retrieve the next page of results.
    pub next_token: std::option::Option<std::string::String>,
}
impl ListMultiplexesInput {
    /// The maximum number of items to return.
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// The token to retrieve the next page of results.
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListMultiplexesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListMultiplexesInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// Placeholder documentation for ListInputSecurityGroupsRequest
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListInputSecurityGroupsInput {
    /// Placeholder documentation for MaxResults
    pub max_results: i32,
    /// Placeholder documentation for __string
    pub next_token: std::option::Option<std::string::String>,
}
impl ListInputSecurityGroupsInput {
    /// Placeholder documentation for MaxResults
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// Placeholder documentation for __string
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListInputSecurityGroupsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListInputSecurityGroupsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// Placeholder documentation for ListInputsRequest
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListInputsInput {
    /// Placeholder documentation for MaxResults
    pub max_results: i32,
    /// Placeholder documentation for __string
    pub next_token: std::option::Option<std::string::String>,
}
impl ListInputsInput {
    /// Placeholder documentation for MaxResults
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// Placeholder documentation for __string
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListInputsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListInputsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// Placeholder documentation for ListInputDeviceTransfersRequest
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListInputDeviceTransfersInput {
    /// Placeholder documentation for MaxResults
    pub max_results: i32,
    /// Placeholder documentation for __string
    pub next_token: std::option::Option<std::string::String>,
    /// Placeholder documentation for __string
    pub transfer_type: std::option::Option<std::string::String>,
}
impl ListInputDeviceTransfersInput {
    /// Placeholder documentation for MaxResults
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// Placeholder documentation for __string
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// Placeholder documentation for __string
    pub fn transfer_type(&self) -> std::option::Option<&str> {
        self.transfer_type.as_deref()
    }
}
impl std::fmt::Debug for ListInputDeviceTransfersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListInputDeviceTransfersInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("transfer_type", &self.transfer_type);
        formatter.finish()
    }
}

/// Placeholder documentation for ListInputDevicesRequest
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListInputDevicesInput {
    /// Placeholder documentation for MaxResults
    pub max_results: i32,
    /// Placeholder documentation for __string
    pub next_token: std::option::Option<std::string::String>,
}
impl ListInputDevicesInput {
    /// Placeholder documentation for MaxResults
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// Placeholder documentation for __string
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListInputDevicesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListInputDevicesInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// Placeholder documentation for ListChannelsRequest
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListChannelsInput {
    /// Placeholder documentation for MaxResults
    pub max_results: i32,
    /// Placeholder documentation for __string
    pub next_token: std::option::Option<std::string::String>,
}
impl ListChannelsInput {
    /// Placeholder documentation for MaxResults
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// Placeholder documentation for __string
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListChannelsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListChannelsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// Placeholder documentation for DescribeScheduleRequest
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeScheduleInput {
    /// Id of the channel whose schedule is being updated.
    pub channel_id: std::option::Option<std::string::String>,
    /// Placeholder documentation for MaxResults
    pub max_results: i32,
    /// Placeholder documentation for __string
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeScheduleInput {
    /// Id of the channel whose schedule is being updated.
    pub fn channel_id(&self) -> std::option::Option<&str> {
        self.channel_id.as_deref()
    }
    /// Placeholder documentation for MaxResults
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// Placeholder documentation for __string
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeScheduleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeScheduleInput");
        formatter.field("channel_id", &self.channel_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// Placeholder documentation for DescribeReservationRequest
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeReservationInput {
    /// Unique reservation ID, e.g. '1234567'
    pub reservation_id: std::option::Option<std::string::String>,
}
impl DescribeReservationInput {
    /// Unique reservation ID, e.g. '1234567'
    pub fn reservation_id(&self) -> std::option::Option<&str> {
        self.reservation_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeReservationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeReservationInput");
        formatter.field("reservation_id", &self.reservation_id);
        formatter.finish()
    }
}

/// Placeholder documentation for DescribeOfferingRequest
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeOfferingInput {
    /// Unique offering ID, e.g. '87654321'
    pub offering_id: std::option::Option<std::string::String>,
}
impl DescribeOfferingInput {
    /// Unique offering ID, e.g. '87654321'
    pub fn offering_id(&self) -> std::option::Option<&str> {
        self.offering_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeOfferingInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeOfferingInput");
        formatter.field("offering_id", &self.offering_id);
        formatter.finish()
    }
}

/// Placeholder documentation for DescribeMultiplexProgramRequest
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeMultiplexProgramInput {
    /// The ID of the multiplex that the program belongs to.
    pub multiplex_id: std::option::Option<std::string::String>,
    /// The name of the program.
    pub program_name: std::option::Option<std::string::String>,
}
impl DescribeMultiplexProgramInput {
    /// The ID of the multiplex that the program belongs to.
    pub fn multiplex_id(&self) -> std::option::Option<&str> {
        self.multiplex_id.as_deref()
    }
    /// The name of the program.
    pub fn program_name(&self) -> std::option::Option<&str> {
        self.program_name.as_deref()
    }
}
impl std::fmt::Debug for DescribeMultiplexProgramInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeMultiplexProgramInput");
        formatter.field("multiplex_id", &self.multiplex_id);
        formatter.field("program_name", &self.program_name);
        formatter.finish()
    }
}

/// Placeholder documentation for DescribeMultiplexRequest
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeMultiplexInput {
    /// The ID of the multiplex.
    pub multiplex_id: std::option::Option<std::string::String>,
}
impl DescribeMultiplexInput {
    /// The ID of the multiplex.
    pub fn multiplex_id(&self) -> std::option::Option<&str> {
        self.multiplex_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeMultiplexInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeMultiplexInput");
        formatter.field("multiplex_id", &self.multiplex_id);
        formatter.finish()
    }
}

/// Placeholder documentation for DescribeInputSecurityGroupRequest
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeInputSecurityGroupInput {
    /// The id of the Input Security Group to describe
    pub input_security_group_id: std::option::Option<std::string::String>,
}
impl DescribeInputSecurityGroupInput {
    /// The id of the Input Security Group to describe
    pub fn input_security_group_id(&self) -> std::option::Option<&str> {
        self.input_security_group_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeInputSecurityGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeInputSecurityGroupInput");
        formatter.field("input_security_group_id", &self.input_security_group_id);
        formatter.finish()
    }
}

/// Placeholder documentation for DescribeInputDeviceThumbnailRequest
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeInputDeviceThumbnailInput {
    /// The unique ID of this input device. For example, hd-123456789abcdef.
    pub input_device_id: std::option::Option<std::string::String>,
    /// The HTTP Accept header. Indicates the requested type for the thumbnail.
    pub accept: std::option::Option<crate::model::AcceptHeader>,
}
impl DescribeInputDeviceThumbnailInput {
    /// The unique ID of this input device. For example, hd-123456789abcdef.
    pub fn input_device_id(&self) -> std::option::Option<&str> {
        self.input_device_id.as_deref()
    }
    /// The HTTP Accept header. Indicates the requested type for the thumbnail.
    pub fn accept(&self) -> std::option::Option<&crate::model::AcceptHeader> {
        self.accept.as_ref()
    }
}
impl std::fmt::Debug for DescribeInputDeviceThumbnailInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeInputDeviceThumbnailInput");
        formatter.field("input_device_id", &self.input_device_id);
        formatter.field("accept", &self.accept);
        formatter.finish()
    }
}

/// Placeholder documentation for DescribeInputDeviceRequest
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeInputDeviceInput {
    /// The unique ID of this input device. For example, hd-123456789abcdef.
    pub input_device_id: std::option::Option<std::string::String>,
}
impl DescribeInputDeviceInput {
    /// The unique ID of this input device. For example, hd-123456789abcdef.
    pub fn input_device_id(&self) -> std::option::Option<&str> {
        self.input_device_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeInputDeviceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeInputDeviceInput");
        formatter.field("input_device_id", &self.input_device_id);
        formatter.finish()
    }
}

/// Placeholder documentation for DescribeInputRequest
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeInputInput {
    /// Unique ID of the input
    pub input_id: std::option::Option<std::string::String>,
}
impl DescribeInputInput {
    /// Unique ID of the input
    pub fn input_id(&self) -> std::option::Option<&str> {
        self.input_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeInputInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeInputInput");
        formatter.field("input_id", &self.input_id);
        formatter.finish()
    }
}

/// Placeholder documentation for DescribeChannelRequest
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeChannelInput {
    /// channel ID
    pub channel_id: std::option::Option<std::string::String>,
}
impl DescribeChannelInput {
    /// channel ID
    pub fn channel_id(&self) -> std::option::Option<&str> {
        self.channel_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeChannelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeChannelInput");
        formatter.field("channel_id", &self.channel_id);
        formatter.finish()
    }
}

/// Placeholder documentation for DeleteTagsRequest
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTagsInput {
    /// Placeholder documentation for __string
    pub resource_arn: std::option::Option<std::string::String>,
    /// An array of tag keys to delete
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DeleteTagsInput {
    /// Placeholder documentation for __string
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// An array of tag keys to delete
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for DeleteTagsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTagsInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

/// Placeholder documentation for DeleteScheduleRequest
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteScheduleInput {
    /// Id of the channel whose schedule is being deleted.
    pub channel_id: std::option::Option<std::string::String>,
}
impl DeleteScheduleInput {
    /// Id of the channel whose schedule is being deleted.
    pub fn channel_id(&self) -> std::option::Option<&str> {
        self.channel_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteScheduleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteScheduleInput");
        formatter.field("channel_id", &self.channel_id);
        formatter.finish()
    }
}

/// Placeholder documentation for DeleteReservationRequest
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteReservationInput {
    /// Unique reservation ID, e.g. '1234567'
    pub reservation_id: std::option::Option<std::string::String>,
}
impl DeleteReservationInput {
    /// Unique reservation ID, e.g. '1234567'
    pub fn reservation_id(&self) -> std::option::Option<&str> {
        self.reservation_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteReservationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteReservationInput");
        formatter.field("reservation_id", &self.reservation_id);
        formatter.finish()
    }
}

/// Placeholder documentation for DeleteMultiplexProgramRequest
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteMultiplexProgramInput {
    /// The ID of the multiplex that the program belongs to.
    pub multiplex_id: std::option::Option<std::string::String>,
    /// The multiplex program name.
    pub program_name: std::option::Option<std::string::String>,
}
impl DeleteMultiplexProgramInput {
    /// The ID of the multiplex that the program belongs to.
    pub fn multiplex_id(&self) -> std::option::Option<&str> {
        self.multiplex_id.as_deref()
    }
    /// The multiplex program name.
    pub fn program_name(&self) -> std::option::Option<&str> {
        self.program_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteMultiplexProgramInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteMultiplexProgramInput");
        formatter.field("multiplex_id", &self.multiplex_id);
        formatter.field("program_name", &self.program_name);
        formatter.finish()
    }
}

/// Placeholder documentation for DeleteMultiplexRequest
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteMultiplexInput {
    /// The ID of the multiplex.
    pub multiplex_id: std::option::Option<std::string::String>,
}
impl DeleteMultiplexInput {
    /// The ID of the multiplex.
    pub fn multiplex_id(&self) -> std::option::Option<&str> {
        self.multiplex_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteMultiplexInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteMultiplexInput");
        formatter.field("multiplex_id", &self.multiplex_id);
        formatter.finish()
    }
}

/// Placeholder documentation for DeleteInputSecurityGroupRequest
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteInputSecurityGroupInput {
    /// The Input Security Group to delete
    pub input_security_group_id: std::option::Option<std::string::String>,
}
impl DeleteInputSecurityGroupInput {
    /// The Input Security Group to delete
    pub fn input_security_group_id(&self) -> std::option::Option<&str> {
        self.input_security_group_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteInputSecurityGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteInputSecurityGroupInput");
        formatter.field("input_security_group_id", &self.input_security_group_id);
        formatter.finish()
    }
}

/// Placeholder documentation for DeleteInputRequest
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteInputInput {
    /// Unique ID of the input
    pub input_id: std::option::Option<std::string::String>,
}
impl DeleteInputInput {
    /// Unique ID of the input
    pub fn input_id(&self) -> std::option::Option<&str> {
        self.input_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteInputInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteInputInput");
        formatter.field("input_id", &self.input_id);
        formatter.finish()
    }
}

/// Placeholder documentation for DeleteChannelRequest
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteChannelInput {
    /// Unique ID of the channel.
    pub channel_id: std::option::Option<std::string::String>,
}
impl DeleteChannelInput {
    /// Unique ID of the channel.
    pub fn channel_id(&self) -> std::option::Option<&str> {
        self.channel_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteChannelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteChannelInput");
        formatter.field("channel_id", &self.channel_id);
        formatter.finish()
    }
}

/// Placeholder documentation for CreateTagsRequest
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateTagsInput {
    /// Placeholder documentation for __string
    pub resource_arn: std::option::Option<std::string::String>,
    /// Placeholder documentation for Tags
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateTagsInput {
    /// Placeholder documentation for __string
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// Placeholder documentation for Tags
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateTagsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateTagsInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// A request to create a partner input
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePartnerInputInput {
    /// Unique ID of the input.
    pub input_id: std::option::Option<std::string::String>,
    /// Unique identifier of the request to ensure the request is handled exactly once in case of retries.
    pub request_id: std::option::Option<std::string::String>,
    /// A collection of key-value pairs.
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreatePartnerInputInput {
    /// Unique ID of the input.
    pub fn input_id(&self) -> std::option::Option<&str> {
        self.input_id.as_deref()
    }
    /// Unique identifier of the request to ensure the request is handled exactly once in case of retries.
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// A collection of key-value pairs.
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreatePartnerInputInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePartnerInputInput");
        formatter.field("input_id", &self.input_id);
        formatter.field("request_id", &self.request_id);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// A request to create a program in a multiplex.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateMultiplexProgramInput {
    /// ID of the multiplex where the program is to be created.
    pub multiplex_id: std::option::Option<std::string::String>,
    /// The settings for this multiplex program.
    pub multiplex_program_settings: std::option::Option<crate::model::MultiplexProgramSettings>,
    /// Name of multiplex program.
    pub program_name: std::option::Option<std::string::String>,
    /// Unique request ID. This prevents retries from creating multiple resources.
    pub request_id: std::option::Option<std::string::String>,
}
impl CreateMultiplexProgramInput {
    /// ID of the multiplex where the program is to be created.
    pub fn multiplex_id(&self) -> std::option::Option<&str> {
        self.multiplex_id.as_deref()
    }
    /// The settings for this multiplex program.
    pub fn multiplex_program_settings(
        &self,
    ) -> std::option::Option<&crate::model::MultiplexProgramSettings> {
        self.multiplex_program_settings.as_ref()
    }
    /// Name of multiplex program.
    pub fn program_name(&self) -> std::option::Option<&str> {
        self.program_name.as_deref()
    }
    /// Unique request ID. This prevents retries from creating multiple resources.
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for CreateMultiplexProgramInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateMultiplexProgramInput");
        formatter.field("multiplex_id", &self.multiplex_id);
        formatter.field(
            "multiplex_program_settings",
            &self.multiplex_program_settings,
        );
        formatter.field("program_name", &self.program_name);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}

/// A request to create a multiplex.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateMultiplexInput {
    /// A list of availability zones for the multiplex. You must specify exactly two.
    pub availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
    /// Configuration for a multiplex event.
    pub multiplex_settings: std::option::Option<crate::model::MultiplexSettings>,
    /// Name of multiplex.
    pub name: std::option::Option<std::string::String>,
    /// Unique request ID. This prevents retries from creating multiple resources.
    pub request_id: std::option::Option<std::string::String>,
    /// A collection of key-value pairs.
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateMultiplexInput {
    /// A list of availability zones for the multiplex. You must specify exactly two.
    pub fn availability_zones(&self) -> std::option::Option<&[std::string::String]> {
        self.availability_zones.as_deref()
    }
    /// Configuration for a multiplex event.
    pub fn multiplex_settings(&self) -> std::option::Option<&crate::model::MultiplexSettings> {
        self.multiplex_settings.as_ref()
    }
    /// Name of multiplex.
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// Unique request ID. This prevents retries from creating multiple resources.
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// A collection of key-value pairs.
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateMultiplexInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateMultiplexInput");
        formatter.field("availability_zones", &self.availability_zones);
        formatter.field("multiplex_settings", &self.multiplex_settings);
        formatter.field("name", &self.name);
        formatter.field("request_id", &self.request_id);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// The IPv4 CIDRs to whitelist for this Input Security Group
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateInputSecurityGroupInput {
    /// A collection of key-value pairs.
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// List of IPv4 CIDR addresses to whitelist
    pub whitelist_rules: std::option::Option<std::vec::Vec<crate::model::InputWhitelistRuleCidr>>,
}
impl CreateInputSecurityGroupInput {
    /// A collection of key-value pairs.
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// List of IPv4 CIDR addresses to whitelist
    pub fn whitelist_rules(&self) -> std::option::Option<&[crate::model::InputWhitelistRuleCidr]> {
        self.whitelist_rules.as_deref()
    }
}
impl std::fmt::Debug for CreateInputSecurityGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateInputSecurityGroupInput");
        formatter.field("tags", &self.tags);
        formatter.field("whitelist_rules", &self.whitelist_rules);
        formatter.finish()
    }
}

/// The name of the input
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateInputInput {
    /// Destination settings for PUSH type inputs.
    pub destinations: std::option::Option<std::vec::Vec<crate::model::InputDestinationRequest>>,
    /// Settings for the devices.
    pub input_devices: std::option::Option<std::vec::Vec<crate::model::InputDeviceSettings>>,
    /// A list of security groups referenced by IDs to attach to the input.
    pub input_security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
    /// A list of the MediaConnect Flows that you want to use in this input. You can specify as few as one Flow and presently, as many as two. The only requirement is when you have more than one is that each Flow is in a separate Availability Zone as this ensures your EML input is redundant to AZ issues.
    pub media_connect_flows:
        std::option::Option<std::vec::Vec<crate::model::MediaConnectFlowRequest>>,
    /// Name of the input.
    pub name: std::option::Option<std::string::String>,
    /// Unique identifier of the request to ensure the request is handled exactly once in case of retries.
    pub request_id: std::option::Option<std::string::String>,
    /// The Amazon Resource Name (ARN) of the role this input assumes during and after creation.
    pub role_arn: std::option::Option<std::string::String>,
    /// The source URLs for a PULL-type input. Every PULL type input needs exactly two source URLs for redundancy. Only specify sources for PULL type Inputs. Leave Destinations empty.
    pub sources: std::option::Option<std::vec::Vec<crate::model::InputSourceRequest>>,
    /// A collection of key-value pairs.
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// The different types of inputs that AWS Elemental MediaLive supports.
    pub r#type: std::option::Option<crate::model::InputType>,
    /// Settings for a private VPC Input. When this property is specified, the input destination addresses will be created in a VPC rather than with public Internet addresses. This property requires setting the roleArn property on Input creation. Not compatible with the inputSecurityGroups property.
    pub vpc: std::option::Option<crate::model::InputVpcRequest>,
}
impl CreateInputInput {
    /// Destination settings for PUSH type inputs.
    pub fn destinations(&self) -> std::option::Option<&[crate::model::InputDestinationRequest]> {
        self.destinations.as_deref()
    }
    /// Settings for the devices.
    pub fn input_devices(&self) -> std::option::Option<&[crate::model::InputDeviceSettings]> {
        self.input_devices.as_deref()
    }
    /// A list of security groups referenced by IDs to attach to the input.
    pub fn input_security_groups(&self) -> std::option::Option<&[std::string::String]> {
        self.input_security_groups.as_deref()
    }
    /// A list of the MediaConnect Flows that you want to use in this input. You can specify as few as one Flow and presently, as many as two. The only requirement is when you have more than one is that each Flow is in a separate Availability Zone as this ensures your EML input is redundant to AZ issues.
    pub fn media_connect_flows(
        &self,
    ) -> std::option::Option<&[crate::model::MediaConnectFlowRequest]> {
        self.media_connect_flows.as_deref()
    }
    /// Name of the input.
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// Unique identifier of the request to ensure the request is handled exactly once in case of retries.
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// The Amazon Resource Name (ARN) of the role this input assumes during and after creation.
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// The source URLs for a PULL-type input. Every PULL type input needs exactly two source URLs for redundancy. Only specify sources for PULL type Inputs. Leave Destinations empty.
    pub fn sources(&self) -> std::option::Option<&[crate::model::InputSourceRequest]> {
        self.sources.as_deref()
    }
    /// A collection of key-value pairs.
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// The different types of inputs that AWS Elemental MediaLive supports.
    pub fn r#type(&self) -> std::option::Option<&crate::model::InputType> {
        self.r#type.as_ref()
    }
    /// Settings for a private VPC Input. When this property is specified, the input destination addresses will be created in a VPC rather than with public Internet addresses. This property requires setting the roleArn property on Input creation. Not compatible with the inputSecurityGroups property.
    pub fn vpc(&self) -> std::option::Option<&crate::model::InputVpcRequest> {
        self.vpc.as_ref()
    }
}
impl std::fmt::Debug for CreateInputInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateInputInput");
        formatter.field("destinations", &self.destinations);
        formatter.field("input_devices", &self.input_devices);
        formatter.field("input_security_groups", &self.input_security_groups);
        formatter.field("media_connect_flows", &self.media_connect_flows);
        formatter.field("name", &self.name);
        formatter.field("request_id", &self.request_id);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("sources", &self.sources);
        formatter.field("tags", &self.tags);
        formatter.field("r#type", &self.r#type);
        formatter.field("vpc", &self.vpc);
        formatter.finish()
    }
}

/// A request to create a channel
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateChannelInput {
    /// Specification of CDI inputs for this channel
    pub cdi_input_specification: std::option::Option<crate::model::CdiInputSpecification>,
    /// The class for this channel. STANDARD for a channel with two pipelines or SINGLE_PIPELINE for a channel with one pipeline.
    pub channel_class: std::option::Option<crate::model::ChannelClass>,
    /// Placeholder documentation for __listOfOutputDestination
    pub destinations: std::option::Option<std::vec::Vec<crate::model::OutputDestination>>,
    /// Encoder Settings
    pub encoder_settings: std::option::Option<crate::model::EncoderSettings>,
    /// List of input attachments for channel.
    pub input_attachments: std::option::Option<std::vec::Vec<crate::model::InputAttachment>>,
    /// Specification of network and file inputs for this channel
    pub input_specification: std::option::Option<crate::model::InputSpecification>,
    /// The log level to write to CloudWatch Logs.
    pub log_level: std::option::Option<crate::model::LogLevel>,
    /// Name of channel.
    pub name: std::option::Option<std::string::String>,
    /// Unique request ID to be specified. This is needed to prevent retries from creating multiple resources.
    pub request_id: std::option::Option<std::string::String>,
    /// Deprecated field that's only usable by whitelisted customers.
    pub reserved: std::option::Option<std::string::String>,
    /// An optional Amazon Resource Name (ARN) of the role to assume when running the Channel.
    pub role_arn: std::option::Option<std::string::String>,
    /// A collection of key-value pairs.
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// Settings for the VPC outputs
    pub vpc: std::option::Option<crate::model::VpcOutputSettings>,
}
impl CreateChannelInput {
    /// Specification of CDI inputs for this channel
    pub fn cdi_input_specification(
        &self,
    ) -> std::option::Option<&crate::model::CdiInputSpecification> {
        self.cdi_input_specification.as_ref()
    }
    /// The class for this channel. STANDARD for a channel with two pipelines or SINGLE_PIPELINE for a channel with one pipeline.
    pub fn channel_class(&self) -> std::option::Option<&crate::model::ChannelClass> {
        self.channel_class.as_ref()
    }
    /// Placeholder documentation for __listOfOutputDestination
    pub fn destinations(&self) -> std::option::Option<&[crate::model::OutputDestination]> {
        self.destinations.as_deref()
    }
    /// Encoder Settings
    pub fn encoder_settings(&self) -> std::option::Option<&crate::model::EncoderSettings> {
        self.encoder_settings.as_ref()
    }
    /// List of input attachments for channel.
    pub fn input_attachments(&self) -> std::option::Option<&[crate::model::InputAttachment]> {
        self.input_attachments.as_deref()
    }
    /// Specification of network and file inputs for this channel
    pub fn input_specification(&self) -> std::option::Option<&crate::model::InputSpecification> {
        self.input_specification.as_ref()
    }
    /// The log level to write to CloudWatch Logs.
    pub fn log_level(&self) -> std::option::Option<&crate::model::LogLevel> {
        self.log_level.as_ref()
    }
    /// Name of channel.
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// Unique request ID to be specified. This is needed to prevent retries from creating multiple resources.
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// Deprecated field that's only usable by whitelisted customers.
    pub fn reserved(&self) -> std::option::Option<&str> {
        self.reserved.as_deref()
    }
    /// An optional Amazon Resource Name (ARN) of the role to assume when running the Channel.
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// A collection of key-value pairs.
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// Settings for the VPC outputs
    pub fn vpc(&self) -> std::option::Option<&crate::model::VpcOutputSettings> {
        self.vpc.as_ref()
    }
}
impl std::fmt::Debug for CreateChannelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateChannelInput");
        formatter.field("cdi_input_specification", &self.cdi_input_specification);
        formatter.field("channel_class", &self.channel_class);
        formatter.field("destinations", &self.destinations);
        formatter.field("encoder_settings", &self.encoder_settings);
        formatter.field("input_attachments", &self.input_attachments);
        formatter.field("input_specification", &self.input_specification);
        formatter.field("log_level", &self.log_level);
        formatter.field("name", &self.name);
        formatter.field("request_id", &self.request_id);
        formatter.field("reserved", &self.reserved);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("tags", &self.tags);
        formatter.field("vpc", &self.vpc);
        formatter.finish()
    }
}

/// A request to claim an AWS Elemental device that you have purchased from a third-party vendor.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClaimDeviceInput {
    /// The id of the device you want to claim.
    pub id: std::option::Option<std::string::String>,
}
impl ClaimDeviceInput {
    /// The id of the device you want to claim.
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for ClaimDeviceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClaimDeviceInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

/// Placeholder documentation for CancelInputDeviceTransferRequest
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelInputDeviceTransferInput {
    /// The unique ID of the input device to cancel. For example, hd-123456789abcdef.
    pub input_device_id: std::option::Option<std::string::String>,
}
impl CancelInputDeviceTransferInput {
    /// The unique ID of the input device to cancel. For example, hd-123456789abcdef.
    pub fn input_device_id(&self) -> std::option::Option<&str> {
        self.input_device_id.as_deref()
    }
}
impl std::fmt::Debug for CancelInputDeviceTransferInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelInputDeviceTransferInput");
        formatter.field("input_device_id", &self.input_device_id);
        formatter.finish()
    }
}

/// List of actions to create and list of actions to delete.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchUpdateScheduleInput {
    /// Id of the channel whose schedule is being updated.
    pub channel_id: std::option::Option<std::string::String>,
    /// Schedule actions to create in the schedule.
    pub creates: std::option::Option<crate::model::BatchScheduleActionCreateRequest>,
    /// Schedule actions to delete from the schedule.
    pub deletes: std::option::Option<crate::model::BatchScheduleActionDeleteRequest>,
}
impl BatchUpdateScheduleInput {
    /// Id of the channel whose schedule is being updated.
    pub fn channel_id(&self) -> std::option::Option<&str> {
        self.channel_id.as_deref()
    }
    /// Schedule actions to create in the schedule.
    pub fn creates(&self) -> std::option::Option<&crate::model::BatchScheduleActionCreateRequest> {
        self.creates.as_ref()
    }
    /// Schedule actions to delete from the schedule.
    pub fn deletes(&self) -> std::option::Option<&crate::model::BatchScheduleActionDeleteRequest> {
        self.deletes.as_ref()
    }
}
impl std::fmt::Debug for BatchUpdateScheduleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchUpdateScheduleInput");
        formatter.field("channel_id", &self.channel_id);
        formatter.field("creates", &self.creates);
        formatter.field("deletes", &self.deletes);
        formatter.finish()
    }
}

/// A request to stop resources
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchStopInput {
    /// List of channel IDs
    pub channel_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// List of multiplex IDs
    pub multiplex_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl BatchStopInput {
    /// List of channel IDs
    pub fn channel_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.channel_ids.as_deref()
    }
    /// List of multiplex IDs
    pub fn multiplex_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.multiplex_ids.as_deref()
    }
}
impl std::fmt::Debug for BatchStopInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchStopInput");
        formatter.field("channel_ids", &self.channel_ids);
        formatter.field("multiplex_ids", &self.multiplex_ids);
        formatter.finish()
    }
}

/// A request to start resources
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchStartInput {
    /// List of channel IDs
    pub channel_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// List of multiplex IDs
    pub multiplex_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl BatchStartInput {
    /// List of channel IDs
    pub fn channel_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.channel_ids.as_deref()
    }
    /// List of multiplex IDs
    pub fn multiplex_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.multiplex_ids.as_deref()
    }
}
impl std::fmt::Debug for BatchStartInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchStartInput");
        formatter.field("channel_ids", &self.channel_ids);
        formatter.field("multiplex_ids", &self.multiplex_ids);
        formatter.finish()
    }
}

/// A request to delete resources
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDeleteInput {
    /// List of channel IDs
    pub channel_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// List of input IDs
    pub input_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// List of input security group IDs
    pub input_security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// List of multiplex IDs
    pub multiplex_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl BatchDeleteInput {
    /// List of channel IDs
    pub fn channel_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.channel_ids.as_deref()
    }
    /// List of input IDs
    pub fn input_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.input_ids.as_deref()
    }
    /// List of input security group IDs
    pub fn input_security_group_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.input_security_group_ids.as_deref()
    }
    /// List of multiplex IDs
    pub fn multiplex_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.multiplex_ids.as_deref()
    }
}
impl std::fmt::Debug for BatchDeleteInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDeleteInput");
        formatter.field("channel_ids", &self.channel_ids);
        formatter.field("input_ids", &self.input_ids);
        formatter.field("input_security_group_ids", &self.input_security_group_ids);
        formatter.field("multiplex_ids", &self.multiplex_ids);
        formatter.finish()
    }
}

/// Placeholder documentation for AcceptInputDeviceTransferRequest
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AcceptInputDeviceTransferInput {
    /// The unique ID of the input device to accept. For example, hd-123456789abcdef.
    pub input_device_id: std::option::Option<std::string::String>,
}
impl AcceptInputDeviceTransferInput {
    /// The unique ID of the input device to accept. For example, hd-123456789abcdef.
    pub fn input_device_id(&self) -> std::option::Option<&str> {
        self.input_device_id.as_deref()
    }
}
impl std::fmt::Debug for AcceptInputDeviceTransferInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AcceptInputDeviceTransferInput");
        formatter.field("input_device_id", &self.input_device_id);
        formatter.finish()
    }
}
