// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Placeholder documentation for UpdateReservationResponse
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateReservationOutput {
    /// Reserved resources available to use
    pub reservation: std::option::Option<crate::model::Reservation>,
}
impl UpdateReservationOutput {
    /// Reserved resources available to use
    pub fn reservation(&self) -> std::option::Option<&crate::model::Reservation> {
        self.reservation.as_ref()
    }
}
impl std::fmt::Debug for UpdateReservationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateReservationOutput");
        formatter.field("reservation", &self.reservation);
        formatter.finish()
    }
}
/// See [`UpdateReservationOutput`](crate::output::UpdateReservationOutput)
pub mod update_reservation_output {
    /// A builder for [`UpdateReservationOutput`](crate::output::UpdateReservationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reservation: std::option::Option<crate::model::Reservation>,
    }
    impl Builder {
        /// Reserved resources available to use
        pub fn reservation(mut self, input: crate::model::Reservation) -> Self {
            self.reservation = Some(input);
            self
        }
        /// Reserved resources available to use
        pub fn set_reservation(
            mut self,
            input: std::option::Option<crate::model::Reservation>,
        ) -> Self {
            self.reservation = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateReservationOutput`](crate::output::UpdateReservationOutput)
        pub fn build(self) -> crate::output::UpdateReservationOutput {
            crate::output::UpdateReservationOutput {
                reservation: self.reservation,
            }
        }
    }
}
impl UpdateReservationOutput {
    /// Creates a new builder-style object to manufacture [`UpdateReservationOutput`](crate::output::UpdateReservationOutput)
    pub fn builder() -> crate::output::update_reservation_output::Builder {
        crate::output::update_reservation_output::Builder::default()
    }
}

/// Placeholder documentation for UpdateMultiplexProgramResponse
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateMultiplexProgramOutput {
    /// The updated multiplex program.
    pub multiplex_program: std::option::Option<crate::model::MultiplexProgram>,
}
impl UpdateMultiplexProgramOutput {
    /// The updated multiplex program.
    pub fn multiplex_program(&self) -> std::option::Option<&crate::model::MultiplexProgram> {
        self.multiplex_program.as_ref()
    }
}
impl std::fmt::Debug for UpdateMultiplexProgramOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateMultiplexProgramOutput");
        formatter.field("multiplex_program", &self.multiplex_program);
        formatter.finish()
    }
}
/// See [`UpdateMultiplexProgramOutput`](crate::output::UpdateMultiplexProgramOutput)
pub mod update_multiplex_program_output {
    /// A builder for [`UpdateMultiplexProgramOutput`](crate::output::UpdateMultiplexProgramOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) multiplex_program: std::option::Option<crate::model::MultiplexProgram>,
    }
    impl Builder {
        /// The updated multiplex program.
        pub fn multiplex_program(mut self, input: crate::model::MultiplexProgram) -> Self {
            self.multiplex_program = Some(input);
            self
        }
        /// The updated multiplex program.
        pub fn set_multiplex_program(
            mut self,
            input: std::option::Option<crate::model::MultiplexProgram>,
        ) -> Self {
            self.multiplex_program = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateMultiplexProgramOutput`](crate::output::UpdateMultiplexProgramOutput)
        pub fn build(self) -> crate::output::UpdateMultiplexProgramOutput {
            crate::output::UpdateMultiplexProgramOutput {
                multiplex_program: self.multiplex_program,
            }
        }
    }
}
impl UpdateMultiplexProgramOutput {
    /// Creates a new builder-style object to manufacture [`UpdateMultiplexProgramOutput`](crate::output::UpdateMultiplexProgramOutput)
    pub fn builder() -> crate::output::update_multiplex_program_output::Builder {
        crate::output::update_multiplex_program_output::Builder::default()
    }
}

/// Placeholder documentation for UpdateMultiplexResponse
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateMultiplexOutput {
    /// The updated multiplex.
    pub multiplex: std::option::Option<crate::model::Multiplex>,
}
impl UpdateMultiplexOutput {
    /// The updated multiplex.
    pub fn multiplex(&self) -> std::option::Option<&crate::model::Multiplex> {
        self.multiplex.as_ref()
    }
}
impl std::fmt::Debug for UpdateMultiplexOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateMultiplexOutput");
        formatter.field("multiplex", &self.multiplex);
        formatter.finish()
    }
}
/// See [`UpdateMultiplexOutput`](crate::output::UpdateMultiplexOutput)
pub mod update_multiplex_output {
    /// A builder for [`UpdateMultiplexOutput`](crate::output::UpdateMultiplexOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) multiplex: std::option::Option<crate::model::Multiplex>,
    }
    impl Builder {
        /// The updated multiplex.
        pub fn multiplex(mut self, input: crate::model::Multiplex) -> Self {
            self.multiplex = Some(input);
            self
        }
        /// The updated multiplex.
        pub fn set_multiplex(
            mut self,
            input: std::option::Option<crate::model::Multiplex>,
        ) -> Self {
            self.multiplex = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateMultiplexOutput`](crate::output::UpdateMultiplexOutput)
        pub fn build(self) -> crate::output::UpdateMultiplexOutput {
            crate::output::UpdateMultiplexOutput {
                multiplex: self.multiplex,
            }
        }
    }
}
impl UpdateMultiplexOutput {
    /// Creates a new builder-style object to manufacture [`UpdateMultiplexOutput`](crate::output::UpdateMultiplexOutput)
    pub fn builder() -> crate::output::update_multiplex_output::Builder {
        crate::output::update_multiplex_output::Builder::default()
    }
}

/// Placeholder documentation for UpdateInputSecurityGroupResponse
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateInputSecurityGroupOutput {
    /// An Input Security Group
    pub security_group: std::option::Option<crate::model::InputSecurityGroup>,
}
impl UpdateInputSecurityGroupOutput {
    /// An Input Security Group
    pub fn security_group(&self) -> std::option::Option<&crate::model::InputSecurityGroup> {
        self.security_group.as_ref()
    }
}
impl std::fmt::Debug for UpdateInputSecurityGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateInputSecurityGroupOutput");
        formatter.field("security_group", &self.security_group);
        formatter.finish()
    }
}
/// See [`UpdateInputSecurityGroupOutput`](crate::output::UpdateInputSecurityGroupOutput)
pub mod update_input_security_group_output {
    /// A builder for [`UpdateInputSecurityGroupOutput`](crate::output::UpdateInputSecurityGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) security_group: std::option::Option<crate::model::InputSecurityGroup>,
    }
    impl Builder {
        /// An Input Security Group
        pub fn security_group(mut self, input: crate::model::InputSecurityGroup) -> Self {
            self.security_group = Some(input);
            self
        }
        /// An Input Security Group
        pub fn set_security_group(
            mut self,
            input: std::option::Option<crate::model::InputSecurityGroup>,
        ) -> Self {
            self.security_group = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateInputSecurityGroupOutput`](crate::output::UpdateInputSecurityGroupOutput)
        pub fn build(self) -> crate::output::UpdateInputSecurityGroupOutput {
            crate::output::UpdateInputSecurityGroupOutput {
                security_group: self.security_group,
            }
        }
    }
}
impl UpdateInputSecurityGroupOutput {
    /// Creates a new builder-style object to manufacture [`UpdateInputSecurityGroupOutput`](crate::output::UpdateInputSecurityGroupOutput)
    pub fn builder() -> crate::output::update_input_security_group_output::Builder {
        crate::output::update_input_security_group_output::Builder::default()
    }
}

/// Placeholder documentation for UpdateInputDeviceResponse
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateInputDeviceOutput {
    /// The unique ARN of the input device.
    pub arn: std::option::Option<std::string::String>,
    /// The state of the connection between the input device and AWS.
    pub connection_state: std::option::Option<crate::model::InputDeviceConnectionState>,
    /// The status of the action to synchronize the device configuration. If you change the configuration of the input device (for example, the maximum bitrate), MediaLive sends the new data to the device. The device might not update itself immediately. SYNCED means the device has updated its configuration. SYNCING means that it has not updated its configuration.
    pub device_settings_sync_state: std::option::Option<crate::model::DeviceSettingsSyncState>,
    /// The status of software on the input device.
    pub device_update_status: std::option::Option<crate::model::DeviceUpdateStatus>,
    /// Settings that describe an input device that is type HD.
    pub hd_device_settings: std::option::Option<crate::model::InputDeviceHdSettings>,
    /// The unique ID of the input device.
    pub id: std::option::Option<std::string::String>,
    /// The network MAC address of the input device.
    pub mac_address: std::option::Option<std::string::String>,
    /// A name that you specify for the input device.
    pub name: std::option::Option<std::string::String>,
    /// The network settings for the input device.
    pub network_settings: std::option::Option<crate::model::InputDeviceNetworkSettings>,
    /// The unique serial number of the input device.
    pub serial_number: std::option::Option<std::string::String>,
    /// The type of the input device.
    pub r#type: std::option::Option<crate::model::InputDeviceType>,
    /// Settings that describe an input device that is type UHD.
    pub uhd_device_settings: std::option::Option<crate::model::InputDeviceUhdSettings>,
}
impl UpdateInputDeviceOutput {
    /// The unique ARN of the input device.
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// The state of the connection between the input device and AWS.
    pub fn connection_state(
        &self,
    ) -> std::option::Option<&crate::model::InputDeviceConnectionState> {
        self.connection_state.as_ref()
    }
    /// The status of the action to synchronize the device configuration. If you change the configuration of the input device (for example, the maximum bitrate), MediaLive sends the new data to the device. The device might not update itself immediately. SYNCED means the device has updated its configuration. SYNCING means that it has not updated its configuration.
    pub fn device_settings_sync_state(
        &self,
    ) -> std::option::Option<&crate::model::DeviceSettingsSyncState> {
        self.device_settings_sync_state.as_ref()
    }
    /// The status of software on the input device.
    pub fn device_update_status(&self) -> std::option::Option<&crate::model::DeviceUpdateStatus> {
        self.device_update_status.as_ref()
    }
    /// Settings that describe an input device that is type HD.
    pub fn hd_device_settings(&self) -> std::option::Option<&crate::model::InputDeviceHdSettings> {
        self.hd_device_settings.as_ref()
    }
    /// The unique ID of the input device.
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// The network MAC address of the input device.
    pub fn mac_address(&self) -> std::option::Option<&str> {
        self.mac_address.as_deref()
    }
    /// A name that you specify for the input device.
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// The network settings for the input device.
    pub fn network_settings(
        &self,
    ) -> std::option::Option<&crate::model::InputDeviceNetworkSettings> {
        self.network_settings.as_ref()
    }
    /// The unique serial number of the input device.
    pub fn serial_number(&self) -> std::option::Option<&str> {
        self.serial_number.as_deref()
    }
    /// The type of the input device.
    pub fn r#type(&self) -> std::option::Option<&crate::model::InputDeviceType> {
        self.r#type.as_ref()
    }
    /// Settings that describe an input device that is type UHD.
    pub fn uhd_device_settings(
        &self,
    ) -> std::option::Option<&crate::model::InputDeviceUhdSettings> {
        self.uhd_device_settings.as_ref()
    }
}
impl std::fmt::Debug for UpdateInputDeviceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateInputDeviceOutput");
        formatter.field("arn", &self.arn);
        formatter.field("connection_state", &self.connection_state);
        formatter.field(
            "device_settings_sync_state",
            &self.device_settings_sync_state,
        );
        formatter.field("device_update_status", &self.device_update_status);
        formatter.field("hd_device_settings", &self.hd_device_settings);
        formatter.field("id", &self.id);
        formatter.field("mac_address", &self.mac_address);
        formatter.field("name", &self.name);
        formatter.field("network_settings", &self.network_settings);
        formatter.field("serial_number", &self.serial_number);
        formatter.field("r#type", &self.r#type);
        formatter.field("uhd_device_settings", &self.uhd_device_settings);
        formatter.finish()
    }
}
/// See [`UpdateInputDeviceOutput`](crate::output::UpdateInputDeviceOutput)
pub mod update_input_device_output {
    /// A builder for [`UpdateInputDeviceOutput`](crate::output::UpdateInputDeviceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) connection_state: std::option::Option<crate::model::InputDeviceConnectionState>,
        pub(crate) device_settings_sync_state:
            std::option::Option<crate::model::DeviceSettingsSyncState>,
        pub(crate) device_update_status: std::option::Option<crate::model::DeviceUpdateStatus>,
        pub(crate) hd_device_settings: std::option::Option<crate::model::InputDeviceHdSettings>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) mac_address: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) network_settings: std::option::Option<crate::model::InputDeviceNetworkSettings>,
        pub(crate) serial_number: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::InputDeviceType>,
        pub(crate) uhd_device_settings: std::option::Option<crate::model::InputDeviceUhdSettings>,
    }
    impl Builder {
        /// The unique ARN of the input device.
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// The unique ARN of the input device.
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// The state of the connection between the input device and AWS.
        pub fn connection_state(mut self, input: crate::model::InputDeviceConnectionState) -> Self {
            self.connection_state = Some(input);
            self
        }
        /// The state of the connection between the input device and AWS.
        pub fn set_connection_state(
            mut self,
            input: std::option::Option<crate::model::InputDeviceConnectionState>,
        ) -> Self {
            self.connection_state = input;
            self
        }
        /// The status of the action to synchronize the device configuration. If you change the configuration of the input device (for example, the maximum bitrate), MediaLive sends the new data to the device. The device might not update itself immediately. SYNCED means the device has updated its configuration. SYNCING means that it has not updated its configuration.
        pub fn device_settings_sync_state(
            mut self,
            input: crate::model::DeviceSettingsSyncState,
        ) -> Self {
            self.device_settings_sync_state = Some(input);
            self
        }
        /// The status of the action to synchronize the device configuration. If you change the configuration of the input device (for example, the maximum bitrate), MediaLive sends the new data to the device. The device might not update itself immediately. SYNCED means the device has updated its configuration. SYNCING means that it has not updated its configuration.
        pub fn set_device_settings_sync_state(
            mut self,
            input: std::option::Option<crate::model::DeviceSettingsSyncState>,
        ) -> Self {
            self.device_settings_sync_state = input;
            self
        }
        /// The status of software on the input device.
        pub fn device_update_status(mut self, input: crate::model::DeviceUpdateStatus) -> Self {
            self.device_update_status = Some(input);
            self
        }
        /// The status of software on the input device.
        pub fn set_device_update_status(
            mut self,
            input: std::option::Option<crate::model::DeviceUpdateStatus>,
        ) -> Self {
            self.device_update_status = input;
            self
        }
        /// Settings that describe an input device that is type HD.
        pub fn hd_device_settings(mut self, input: crate::model::InputDeviceHdSettings) -> Self {
            self.hd_device_settings = Some(input);
            self
        }
        /// Settings that describe an input device that is type HD.
        pub fn set_hd_device_settings(
            mut self,
            input: std::option::Option<crate::model::InputDeviceHdSettings>,
        ) -> Self {
            self.hd_device_settings = input;
            self
        }
        /// The unique ID of the input device.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// The unique ID of the input device.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// The network MAC address of the input device.
        pub fn mac_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.mac_address = Some(input.into());
            self
        }
        /// The network MAC address of the input device.
        pub fn set_mac_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mac_address = input;
            self
        }
        /// A name that you specify for the input device.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// A name that you specify for the input device.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// The network settings for the input device.
        pub fn network_settings(mut self, input: crate::model::InputDeviceNetworkSettings) -> Self {
            self.network_settings = Some(input);
            self
        }
        /// The network settings for the input device.
        pub fn set_network_settings(
            mut self,
            input: std::option::Option<crate::model::InputDeviceNetworkSettings>,
        ) -> Self {
            self.network_settings = input;
            self
        }
        /// The unique serial number of the input device.
        pub fn serial_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.serial_number = Some(input.into());
            self
        }
        /// The unique serial number of the input device.
        pub fn set_serial_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.serial_number = input;
            self
        }
        /// The type of the input device.
        pub fn r#type(mut self, input: crate::model::InputDeviceType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// The type of the input device.
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::InputDeviceType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// Settings that describe an input device that is type UHD.
        pub fn uhd_device_settings(mut self, input: crate::model::InputDeviceUhdSettings) -> Self {
            self.uhd_device_settings = Some(input);
            self
        }
        /// Settings that describe an input device that is type UHD.
        pub fn set_uhd_device_settings(
            mut self,
            input: std::option::Option<crate::model::InputDeviceUhdSettings>,
        ) -> Self {
            self.uhd_device_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateInputDeviceOutput`](crate::output::UpdateInputDeviceOutput)
        pub fn build(self) -> crate::output::UpdateInputDeviceOutput {
            crate::output::UpdateInputDeviceOutput {
                arn: self.arn,
                connection_state: self.connection_state,
                device_settings_sync_state: self.device_settings_sync_state,
                device_update_status: self.device_update_status,
                hd_device_settings: self.hd_device_settings,
                id: self.id,
                mac_address: self.mac_address,
                name: self.name,
                network_settings: self.network_settings,
                serial_number: self.serial_number,
                r#type: self.r#type,
                uhd_device_settings: self.uhd_device_settings,
            }
        }
    }
}
impl UpdateInputDeviceOutput {
    /// Creates a new builder-style object to manufacture [`UpdateInputDeviceOutput`](crate::output::UpdateInputDeviceOutput)
    pub fn builder() -> crate::output::update_input_device_output::Builder {
        crate::output::update_input_device_output::Builder::default()
    }
}

/// Placeholder documentation for UpdateInputResponse
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateInputOutput {
    /// Placeholder documentation for Input
    pub input: std::option::Option<crate::model::Input>,
}
impl UpdateInputOutput {
    /// Placeholder documentation for Input
    pub fn input(&self) -> std::option::Option<&crate::model::Input> {
        self.input.as_ref()
    }
}
impl std::fmt::Debug for UpdateInputOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateInputOutput");
        formatter.field("input", &self.input);
        formatter.finish()
    }
}
/// See [`UpdateInputOutput`](crate::output::UpdateInputOutput)
pub mod update_input_output {
    /// A builder for [`UpdateInputOutput`](crate::output::UpdateInputOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input: std::option::Option<crate::model::Input>,
    }
    impl Builder {
        /// Placeholder documentation for Input
        pub fn input(mut self, input: crate::model::Input) -> Self {
            self.input = Some(input);
            self
        }
        /// Placeholder documentation for Input
        pub fn set_input(mut self, input: std::option::Option<crate::model::Input>) -> Self {
            self.input = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateInputOutput`](crate::output::UpdateInputOutput)
        pub fn build(self) -> crate::output::UpdateInputOutput {
            crate::output::UpdateInputOutput { input: self.input }
        }
    }
}
impl UpdateInputOutput {
    /// Creates a new builder-style object to manufacture [`UpdateInputOutput`](crate::output::UpdateInputOutput)
    pub fn builder() -> crate::output::update_input_output::Builder {
        crate::output::update_input_output::Builder::default()
    }
}

/// Placeholder documentation for UpdateChannelClassResponse
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateChannelClassOutput {
    /// Placeholder documentation for Channel
    pub channel: std::option::Option<crate::model::Channel>,
}
impl UpdateChannelClassOutput {
    /// Placeholder documentation for Channel
    pub fn channel(&self) -> std::option::Option<&crate::model::Channel> {
        self.channel.as_ref()
    }
}
impl std::fmt::Debug for UpdateChannelClassOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateChannelClassOutput");
        formatter.field("channel", &self.channel);
        formatter.finish()
    }
}
/// See [`UpdateChannelClassOutput`](crate::output::UpdateChannelClassOutput)
pub mod update_channel_class_output {
    /// A builder for [`UpdateChannelClassOutput`](crate::output::UpdateChannelClassOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel: std::option::Option<crate::model::Channel>,
    }
    impl Builder {
        /// Placeholder documentation for Channel
        pub fn channel(mut self, input: crate::model::Channel) -> Self {
            self.channel = Some(input);
            self
        }
        /// Placeholder documentation for Channel
        pub fn set_channel(mut self, input: std::option::Option<crate::model::Channel>) -> Self {
            self.channel = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateChannelClassOutput`](crate::output::UpdateChannelClassOutput)
        pub fn build(self) -> crate::output::UpdateChannelClassOutput {
            crate::output::UpdateChannelClassOutput {
                channel: self.channel,
            }
        }
    }
}
impl UpdateChannelClassOutput {
    /// Creates a new builder-style object to manufacture [`UpdateChannelClassOutput`](crate::output::UpdateChannelClassOutput)
    pub fn builder() -> crate::output::update_channel_class_output::Builder {
        crate::output::update_channel_class_output::Builder::default()
    }
}

/// Placeholder documentation for UpdateChannelResponse
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateChannelOutput {
    /// Placeholder documentation for Channel
    pub channel: std::option::Option<crate::model::Channel>,
}
impl UpdateChannelOutput {
    /// Placeholder documentation for Channel
    pub fn channel(&self) -> std::option::Option<&crate::model::Channel> {
        self.channel.as_ref()
    }
}
impl std::fmt::Debug for UpdateChannelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateChannelOutput");
        formatter.field("channel", &self.channel);
        formatter.finish()
    }
}
/// See [`UpdateChannelOutput`](crate::output::UpdateChannelOutput)
pub mod update_channel_output {
    /// A builder for [`UpdateChannelOutput`](crate::output::UpdateChannelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel: std::option::Option<crate::model::Channel>,
    }
    impl Builder {
        /// Placeholder documentation for Channel
        pub fn channel(mut self, input: crate::model::Channel) -> Self {
            self.channel = Some(input);
            self
        }
        /// Placeholder documentation for Channel
        pub fn set_channel(mut self, input: std::option::Option<crate::model::Channel>) -> Self {
            self.channel = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateChannelOutput`](crate::output::UpdateChannelOutput)
        pub fn build(self) -> crate::output::UpdateChannelOutput {
            crate::output::UpdateChannelOutput {
                channel: self.channel,
            }
        }
    }
}
impl UpdateChannelOutput {
    /// Creates a new builder-style object to manufacture [`UpdateChannelOutput`](crate::output::UpdateChannelOutput)
    pub fn builder() -> crate::output::update_channel_output::Builder {
        crate::output::update_channel_output::Builder::default()
    }
}

/// Placeholder documentation for TransferInputDeviceResponse
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TransferInputDeviceOutput {}
impl std::fmt::Debug for TransferInputDeviceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TransferInputDeviceOutput");
        formatter.finish()
    }
}
/// See [`TransferInputDeviceOutput`](crate::output::TransferInputDeviceOutput)
pub mod transfer_input_device_output {
    /// A builder for [`TransferInputDeviceOutput`](crate::output::TransferInputDeviceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TransferInputDeviceOutput`](crate::output::TransferInputDeviceOutput)
        pub fn build(self) -> crate::output::TransferInputDeviceOutput {
            crate::output::TransferInputDeviceOutput {}
        }
    }
}
impl TransferInputDeviceOutput {
    /// Creates a new builder-style object to manufacture [`TransferInputDeviceOutput`](crate::output::TransferInputDeviceOutput)
    pub fn builder() -> crate::output::transfer_input_device_output::Builder {
        crate::output::transfer_input_device_output::Builder::default()
    }
}

/// Placeholder documentation for StopMultiplexResponse
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopMultiplexOutput {
    /// The unique arn of the multiplex.
    pub arn: std::option::Option<std::string::String>,
    /// A list of availability zones for the multiplex.
    pub availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
    /// A list of the multiplex output destinations.
    pub destinations: std::option::Option<std::vec::Vec<crate::model::MultiplexOutputDestination>>,
    /// The unique id of the multiplex.
    pub id: std::option::Option<std::string::String>,
    /// Configuration for a multiplex event.
    pub multiplex_settings: std::option::Option<crate::model::MultiplexSettings>,
    /// The name of the multiplex.
    pub name: std::option::Option<std::string::String>,
    /// The number of currently healthy pipelines.
    pub pipelines_running_count: i32,
    /// The number of programs in the multiplex.
    pub program_count: i32,
    /// The current state of the multiplex.
    pub state: std::option::Option<crate::model::MultiplexState>,
    /// A collection of key-value pairs.
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl StopMultiplexOutput {
    /// The unique arn of the multiplex.
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// A list of availability zones for the multiplex.
    pub fn availability_zones(&self) -> std::option::Option<&[std::string::String]> {
        self.availability_zones.as_deref()
    }
    /// A list of the multiplex output destinations.
    pub fn destinations(&self) -> std::option::Option<&[crate::model::MultiplexOutputDestination]> {
        self.destinations.as_deref()
    }
    /// The unique id of the multiplex.
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// Configuration for a multiplex event.
    pub fn multiplex_settings(&self) -> std::option::Option<&crate::model::MultiplexSettings> {
        self.multiplex_settings.as_ref()
    }
    /// The name of the multiplex.
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// The number of currently healthy pipelines.
    pub fn pipelines_running_count(&self) -> i32 {
        self.pipelines_running_count
    }
    /// The number of programs in the multiplex.
    pub fn program_count(&self) -> i32 {
        self.program_count
    }
    /// The current state of the multiplex.
    pub fn state(&self) -> std::option::Option<&crate::model::MultiplexState> {
        self.state.as_ref()
    }
    /// A collection of key-value pairs.
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for StopMultiplexOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopMultiplexOutput");
        formatter.field("arn", &self.arn);
        formatter.field("availability_zones", &self.availability_zones);
        formatter.field("destinations", &self.destinations);
        formatter.field("id", &self.id);
        formatter.field("multiplex_settings", &self.multiplex_settings);
        formatter.field("name", &self.name);
        formatter.field("pipelines_running_count", &self.pipelines_running_count);
        formatter.field("program_count", &self.program_count);
        formatter.field("state", &self.state);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`StopMultiplexOutput`](crate::output::StopMultiplexOutput)
pub mod stop_multiplex_output {
    /// A builder for [`StopMultiplexOutput`](crate::output::StopMultiplexOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) destinations:
            std::option::Option<std::vec::Vec<crate::model::MultiplexOutputDestination>>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) multiplex_settings: std::option::Option<crate::model::MultiplexSettings>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) pipelines_running_count: std::option::Option<i32>,
        pub(crate) program_count: std::option::Option<i32>,
        pub(crate) state: std::option::Option<crate::model::MultiplexState>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// The unique arn of the multiplex.
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// The unique arn of the multiplex.
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Appends an item to `availability_zones`.
        ///
        /// To override the contents of this collection use [`set_availability_zones`](Self::set_availability_zones).
        ///
        /// A list of availability zones for the multiplex.
        pub fn availability_zones(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.availability_zones.unwrap_or_default();
            v.push(input.into());
            self.availability_zones = Some(v);
            self
        }
        /// A list of availability zones for the multiplex.
        pub fn set_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.availability_zones = input;
            self
        }
        /// Appends an item to `destinations`.
        ///
        /// To override the contents of this collection use [`set_destinations`](Self::set_destinations).
        ///
        /// A list of the multiplex output destinations.
        pub fn destinations(
            mut self,
            input: impl Into<crate::model::MultiplexOutputDestination>,
        ) -> Self {
            let mut v = self.destinations.unwrap_or_default();
            v.push(input.into());
            self.destinations = Some(v);
            self
        }
        /// A list of the multiplex output destinations.
        pub fn set_destinations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MultiplexOutputDestination>>,
        ) -> Self {
            self.destinations = input;
            self
        }
        /// The unique id of the multiplex.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// The unique id of the multiplex.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Configuration for a multiplex event.
        pub fn multiplex_settings(mut self, input: crate::model::MultiplexSettings) -> Self {
            self.multiplex_settings = Some(input);
            self
        }
        /// Configuration for a multiplex event.
        pub fn set_multiplex_settings(
            mut self,
            input: std::option::Option<crate::model::MultiplexSettings>,
        ) -> Self {
            self.multiplex_settings = input;
            self
        }
        /// The name of the multiplex.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// The name of the multiplex.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// The number of currently healthy pipelines.
        pub fn pipelines_running_count(mut self, input: i32) -> Self {
            self.pipelines_running_count = Some(input);
            self
        }
        /// The number of currently healthy pipelines.
        pub fn set_pipelines_running_count(mut self, input: std::option::Option<i32>) -> Self {
            self.pipelines_running_count = input;
            self
        }
        /// The number of programs in the multiplex.
        pub fn program_count(mut self, input: i32) -> Self {
            self.program_count = Some(input);
            self
        }
        /// The number of programs in the multiplex.
        pub fn set_program_count(mut self, input: std::option::Option<i32>) -> Self {
            self.program_count = input;
            self
        }
        /// The current state of the multiplex.
        pub fn state(mut self, input: crate::model::MultiplexState) -> Self {
            self.state = Some(input);
            self
        }
        /// The current state of the multiplex.
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::MultiplexState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of key-value pairs.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// A collection of key-value pairs.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`StopMultiplexOutput`](crate::output::StopMultiplexOutput)
        pub fn build(self) -> crate::output::StopMultiplexOutput {
            crate::output::StopMultiplexOutput {
                arn: self.arn,
                availability_zones: self.availability_zones,
                destinations: self.destinations,
                id: self.id,
                multiplex_settings: self.multiplex_settings,
                name: self.name,
                pipelines_running_count: self.pipelines_running_count.unwrap_or_default(),
                program_count: self.program_count.unwrap_or_default(),
                state: self.state,
                tags: self.tags,
            }
        }
    }
}
impl StopMultiplexOutput {
    /// Creates a new builder-style object to manufacture [`StopMultiplexOutput`](crate::output::StopMultiplexOutput)
    pub fn builder() -> crate::output::stop_multiplex_output::Builder {
        crate::output::stop_multiplex_output::Builder::default()
    }
}

/// Placeholder documentation for StopChannelResponse
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopChannelOutput {
    /// The unique arn of the channel.
    pub arn: std::option::Option<std::string::String>,
    /// Specification of CDI inputs for this channel
    pub cdi_input_specification: std::option::Option<crate::model::CdiInputSpecification>,
    /// The class for this channel. STANDARD for a channel with two pipelines or SINGLE_PIPELINE for a channel with one pipeline.
    pub channel_class: std::option::Option<crate::model::ChannelClass>,
    /// A list of destinations of the channel. For UDP outputs, there is one
    /// destination per output. For other types (HLS, for example), there is
    /// one destination per packager.
    pub destinations: std::option::Option<std::vec::Vec<crate::model::OutputDestination>>,
    /// The endpoints where outgoing connections initiate from
    pub egress_endpoints: std::option::Option<std::vec::Vec<crate::model::ChannelEgressEndpoint>>,
    /// Encoder Settings
    pub encoder_settings: std::option::Option<crate::model::EncoderSettings>,
    /// The unique id of the channel.
    pub id: std::option::Option<std::string::String>,
    /// List of input attachments for channel.
    pub input_attachments: std::option::Option<std::vec::Vec<crate::model::InputAttachment>>,
    /// Specification of network and file inputs for this channel
    pub input_specification: std::option::Option<crate::model::InputSpecification>,
    /// The log level being written to CloudWatch Logs.
    pub log_level: std::option::Option<crate::model::LogLevel>,
    /// The name of the channel. (user-mutable)
    pub name: std::option::Option<std::string::String>,
    /// Runtime details for the pipelines of a running channel.
    pub pipeline_details: std::option::Option<std::vec::Vec<crate::model::PipelineDetail>>,
    /// The number of currently healthy pipelines.
    pub pipelines_running_count: i32,
    /// The Amazon Resource Name (ARN) of the role assumed when running the Channel.
    pub role_arn: std::option::Option<std::string::String>,
    /// Placeholder documentation for ChannelState
    pub state: std::option::Option<crate::model::ChannelState>,
    /// A collection of key-value pairs.
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// Settings for VPC output
    pub vpc: std::option::Option<crate::model::VpcOutputSettingsDescription>,
}
impl StopChannelOutput {
    /// The unique arn of the channel.
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// Specification of CDI inputs for this channel
    pub fn cdi_input_specification(
        &self,
    ) -> std::option::Option<&crate::model::CdiInputSpecification> {
        self.cdi_input_specification.as_ref()
    }
    /// The class for this channel. STANDARD for a channel with two pipelines or SINGLE_PIPELINE for a channel with one pipeline.
    pub fn channel_class(&self) -> std::option::Option<&crate::model::ChannelClass> {
        self.channel_class.as_ref()
    }
    /// A list of destinations of the channel. For UDP outputs, there is one
    /// destination per output. For other types (HLS, for example), there is
    /// one destination per packager.
    pub fn destinations(&self) -> std::option::Option<&[crate::model::OutputDestination]> {
        self.destinations.as_deref()
    }
    /// The endpoints where outgoing connections initiate from
    pub fn egress_endpoints(&self) -> std::option::Option<&[crate::model::ChannelEgressEndpoint]> {
        self.egress_endpoints.as_deref()
    }
    /// Encoder Settings
    pub fn encoder_settings(&self) -> std::option::Option<&crate::model::EncoderSettings> {
        self.encoder_settings.as_ref()
    }
    /// The unique id of the channel.
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// List of input attachments for channel.
    pub fn input_attachments(&self) -> std::option::Option<&[crate::model::InputAttachment]> {
        self.input_attachments.as_deref()
    }
    /// Specification of network and file inputs for this channel
    pub fn input_specification(&self) -> std::option::Option<&crate::model::InputSpecification> {
        self.input_specification.as_ref()
    }
    /// The log level being written to CloudWatch Logs.
    pub fn log_level(&self) -> std::option::Option<&crate::model::LogLevel> {
        self.log_level.as_ref()
    }
    /// The name of the channel. (user-mutable)
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// Runtime details for the pipelines of a running channel.
    pub fn pipeline_details(&self) -> std::option::Option<&[crate::model::PipelineDetail]> {
        self.pipeline_details.as_deref()
    }
    /// The number of currently healthy pipelines.
    pub fn pipelines_running_count(&self) -> i32 {
        self.pipelines_running_count
    }
    /// The Amazon Resource Name (ARN) of the role assumed when running the Channel.
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// Placeholder documentation for ChannelState
    pub fn state(&self) -> std::option::Option<&crate::model::ChannelState> {
        self.state.as_ref()
    }
    /// A collection of key-value pairs.
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// Settings for VPC output
    pub fn vpc(&self) -> std::option::Option<&crate::model::VpcOutputSettingsDescription> {
        self.vpc.as_ref()
    }
}
impl std::fmt::Debug for StopChannelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopChannelOutput");
        formatter.field("arn", &self.arn);
        formatter.field("cdi_input_specification", &self.cdi_input_specification);
        formatter.field("channel_class", &self.channel_class);
        formatter.field("destinations", &self.destinations);
        formatter.field("egress_endpoints", &self.egress_endpoints);
        formatter.field("encoder_settings", &self.encoder_settings);
        formatter.field("id", &self.id);
        formatter.field("input_attachments", &self.input_attachments);
        formatter.field("input_specification", &self.input_specification);
        formatter.field("log_level", &self.log_level);
        formatter.field("name", &self.name);
        formatter.field("pipeline_details", &self.pipeline_details);
        formatter.field("pipelines_running_count", &self.pipelines_running_count);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("state", &self.state);
        formatter.field("tags", &self.tags);
        formatter.field("vpc", &self.vpc);
        formatter.finish()
    }
}
/// See [`StopChannelOutput`](crate::output::StopChannelOutput)
pub mod stop_channel_output {
    /// A builder for [`StopChannelOutput`](crate::output::StopChannelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) cdi_input_specification:
            std::option::Option<crate::model::CdiInputSpecification>,
        pub(crate) channel_class: std::option::Option<crate::model::ChannelClass>,
        pub(crate) destinations:
            std::option::Option<std::vec::Vec<crate::model::OutputDestination>>,
        pub(crate) egress_endpoints:
            std::option::Option<std::vec::Vec<crate::model::ChannelEgressEndpoint>>,
        pub(crate) encoder_settings: std::option::Option<crate::model::EncoderSettings>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) input_attachments:
            std::option::Option<std::vec::Vec<crate::model::InputAttachment>>,
        pub(crate) input_specification: std::option::Option<crate::model::InputSpecification>,
        pub(crate) log_level: std::option::Option<crate::model::LogLevel>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) pipeline_details:
            std::option::Option<std::vec::Vec<crate::model::PipelineDetail>>,
        pub(crate) pipelines_running_count: std::option::Option<i32>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::ChannelState>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) vpc: std::option::Option<crate::model::VpcOutputSettingsDescription>,
    }
    impl Builder {
        /// The unique arn of the channel.
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// The unique arn of the channel.
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Specification of CDI inputs for this channel
        pub fn cdi_input_specification(
            mut self,
            input: crate::model::CdiInputSpecification,
        ) -> Self {
            self.cdi_input_specification = Some(input);
            self
        }
        /// Specification of CDI inputs for this channel
        pub fn set_cdi_input_specification(
            mut self,
            input: std::option::Option<crate::model::CdiInputSpecification>,
        ) -> Self {
            self.cdi_input_specification = input;
            self
        }
        /// The class for this channel. STANDARD for a channel with two pipelines or SINGLE_PIPELINE for a channel with one pipeline.
        pub fn channel_class(mut self, input: crate::model::ChannelClass) -> Self {
            self.channel_class = Some(input);
            self
        }
        /// The class for this channel. STANDARD for a channel with two pipelines or SINGLE_PIPELINE for a channel with one pipeline.
        pub fn set_channel_class(
            mut self,
            input: std::option::Option<crate::model::ChannelClass>,
        ) -> Self {
            self.channel_class = input;
            self
        }
        /// Appends an item to `destinations`.
        ///
        /// To override the contents of this collection use [`set_destinations`](Self::set_destinations).
        ///
        /// A list of destinations of the channel. For UDP outputs, there is one
        /// destination per output. For other types (HLS, for example), there is
        /// one destination per packager.
        pub fn destinations(mut self, input: impl Into<crate::model::OutputDestination>) -> Self {
            let mut v = self.destinations.unwrap_or_default();
            v.push(input.into());
            self.destinations = Some(v);
            self
        }
        /// A list of destinations of the channel. For UDP outputs, there is one
        /// destination per output. For other types (HLS, for example), there is
        /// one destination per packager.
        pub fn set_destinations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OutputDestination>>,
        ) -> Self {
            self.destinations = input;
            self
        }
        /// Appends an item to `egress_endpoints`.
        ///
        /// To override the contents of this collection use [`set_egress_endpoints`](Self::set_egress_endpoints).
        ///
        /// The endpoints where outgoing connections initiate from
        pub fn egress_endpoints(
            mut self,
            input: impl Into<crate::model::ChannelEgressEndpoint>,
        ) -> Self {
            let mut v = self.egress_endpoints.unwrap_or_default();
            v.push(input.into());
            self.egress_endpoints = Some(v);
            self
        }
        /// The endpoints where outgoing connections initiate from
        pub fn set_egress_endpoints(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ChannelEgressEndpoint>>,
        ) -> Self {
            self.egress_endpoints = input;
            self
        }
        /// Encoder Settings
        pub fn encoder_settings(mut self, input: crate::model::EncoderSettings) -> Self {
            self.encoder_settings = Some(input);
            self
        }
        /// Encoder Settings
        pub fn set_encoder_settings(
            mut self,
            input: std::option::Option<crate::model::EncoderSettings>,
        ) -> Self {
            self.encoder_settings = input;
            self
        }
        /// The unique id of the channel.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// The unique id of the channel.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Appends an item to `input_attachments`.
        ///
        /// To override the contents of this collection use [`set_input_attachments`](Self::set_input_attachments).
        ///
        /// List of input attachments for channel.
        pub fn input_attachments(
            mut self,
            input: impl Into<crate::model::InputAttachment>,
        ) -> Self {
            let mut v = self.input_attachments.unwrap_or_default();
            v.push(input.into());
            self.input_attachments = Some(v);
            self
        }
        /// List of input attachments for channel.
        pub fn set_input_attachments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InputAttachment>>,
        ) -> Self {
            self.input_attachments = input;
            self
        }
        /// Specification of network and file inputs for this channel
        pub fn input_specification(mut self, input: crate::model::InputSpecification) -> Self {
            self.input_specification = Some(input);
            self
        }
        /// Specification of network and file inputs for this channel
        pub fn set_input_specification(
            mut self,
            input: std::option::Option<crate::model::InputSpecification>,
        ) -> Self {
            self.input_specification = input;
            self
        }
        /// The log level being written to CloudWatch Logs.
        pub fn log_level(mut self, input: crate::model::LogLevel) -> Self {
            self.log_level = Some(input);
            self
        }
        /// The log level being written to CloudWatch Logs.
        pub fn set_log_level(mut self, input: std::option::Option<crate::model::LogLevel>) -> Self {
            self.log_level = input;
            self
        }
        /// The name of the channel. (user-mutable)
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// The name of the channel. (user-mutable)
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `pipeline_details`.
        ///
        /// To override the contents of this collection use [`set_pipeline_details`](Self::set_pipeline_details).
        ///
        /// Runtime details for the pipelines of a running channel.
        pub fn pipeline_details(mut self, input: impl Into<crate::model::PipelineDetail>) -> Self {
            let mut v = self.pipeline_details.unwrap_or_default();
            v.push(input.into());
            self.pipeline_details = Some(v);
            self
        }
        /// Runtime details for the pipelines of a running channel.
        pub fn set_pipeline_details(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PipelineDetail>>,
        ) -> Self {
            self.pipeline_details = input;
            self
        }
        /// The number of currently healthy pipelines.
        pub fn pipelines_running_count(mut self, input: i32) -> Self {
            self.pipelines_running_count = Some(input);
            self
        }
        /// The number of currently healthy pipelines.
        pub fn set_pipelines_running_count(mut self, input: std::option::Option<i32>) -> Self {
            self.pipelines_running_count = input;
            self
        }
        /// The Amazon Resource Name (ARN) of the role assumed when running the Channel.
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) of the role assumed when running the Channel.
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Placeholder documentation for ChannelState
        pub fn state(mut self, input: crate::model::ChannelState) -> Self {
            self.state = Some(input);
            self
        }
        /// Placeholder documentation for ChannelState
        pub fn set_state(mut self, input: std::option::Option<crate::model::ChannelState>) -> Self {
            self.state = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of key-value pairs.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// A collection of key-value pairs.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Settings for VPC output
        pub fn vpc(mut self, input: crate::model::VpcOutputSettingsDescription) -> Self {
            self.vpc = Some(input);
            self
        }
        /// Settings for VPC output
        pub fn set_vpc(
            mut self,
            input: std::option::Option<crate::model::VpcOutputSettingsDescription>,
        ) -> Self {
            self.vpc = input;
            self
        }
        /// Consumes the builder and constructs a [`StopChannelOutput`](crate::output::StopChannelOutput)
        pub fn build(self) -> crate::output::StopChannelOutput {
            crate::output::StopChannelOutput {
                arn: self.arn,
                cdi_input_specification: self.cdi_input_specification,
                channel_class: self.channel_class,
                destinations: self.destinations,
                egress_endpoints: self.egress_endpoints,
                encoder_settings: self.encoder_settings,
                id: self.id,
                input_attachments: self.input_attachments,
                input_specification: self.input_specification,
                log_level: self.log_level,
                name: self.name,
                pipeline_details: self.pipeline_details,
                pipelines_running_count: self.pipelines_running_count.unwrap_or_default(),
                role_arn: self.role_arn,
                state: self.state,
                tags: self.tags,
                vpc: self.vpc,
            }
        }
    }
}
impl StopChannelOutput {
    /// Creates a new builder-style object to manufacture [`StopChannelOutput`](crate::output::StopChannelOutput)
    pub fn builder() -> crate::output::stop_channel_output::Builder {
        crate::output::stop_channel_output::Builder::default()
    }
}

/// Placeholder documentation for StartMultiplexResponse
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartMultiplexOutput {
    /// The unique arn of the multiplex.
    pub arn: std::option::Option<std::string::String>,
    /// A list of availability zones for the multiplex.
    pub availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
    /// A list of the multiplex output destinations.
    pub destinations: std::option::Option<std::vec::Vec<crate::model::MultiplexOutputDestination>>,
    /// The unique id of the multiplex.
    pub id: std::option::Option<std::string::String>,
    /// Configuration for a multiplex event.
    pub multiplex_settings: std::option::Option<crate::model::MultiplexSettings>,
    /// The name of the multiplex.
    pub name: std::option::Option<std::string::String>,
    /// The number of currently healthy pipelines.
    pub pipelines_running_count: i32,
    /// The number of programs in the multiplex.
    pub program_count: i32,
    /// The current state of the multiplex.
    pub state: std::option::Option<crate::model::MultiplexState>,
    /// A collection of key-value pairs.
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl StartMultiplexOutput {
    /// The unique arn of the multiplex.
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// A list of availability zones for the multiplex.
    pub fn availability_zones(&self) -> std::option::Option<&[std::string::String]> {
        self.availability_zones.as_deref()
    }
    /// A list of the multiplex output destinations.
    pub fn destinations(&self) -> std::option::Option<&[crate::model::MultiplexOutputDestination]> {
        self.destinations.as_deref()
    }
    /// The unique id of the multiplex.
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// Configuration for a multiplex event.
    pub fn multiplex_settings(&self) -> std::option::Option<&crate::model::MultiplexSettings> {
        self.multiplex_settings.as_ref()
    }
    /// The name of the multiplex.
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// The number of currently healthy pipelines.
    pub fn pipelines_running_count(&self) -> i32 {
        self.pipelines_running_count
    }
    /// The number of programs in the multiplex.
    pub fn program_count(&self) -> i32 {
        self.program_count
    }
    /// The current state of the multiplex.
    pub fn state(&self) -> std::option::Option<&crate::model::MultiplexState> {
        self.state.as_ref()
    }
    /// A collection of key-value pairs.
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for StartMultiplexOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartMultiplexOutput");
        formatter.field("arn", &self.arn);
        formatter.field("availability_zones", &self.availability_zones);
        formatter.field("destinations", &self.destinations);
        formatter.field("id", &self.id);
        formatter.field("multiplex_settings", &self.multiplex_settings);
        formatter.field("name", &self.name);
        formatter.field("pipelines_running_count", &self.pipelines_running_count);
        formatter.field("program_count", &self.program_count);
        formatter.field("state", &self.state);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`StartMultiplexOutput`](crate::output::StartMultiplexOutput)
pub mod start_multiplex_output {
    /// A builder for [`StartMultiplexOutput`](crate::output::StartMultiplexOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) destinations:
            std::option::Option<std::vec::Vec<crate::model::MultiplexOutputDestination>>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) multiplex_settings: std::option::Option<crate::model::MultiplexSettings>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) pipelines_running_count: std::option::Option<i32>,
        pub(crate) program_count: std::option::Option<i32>,
        pub(crate) state: std::option::Option<crate::model::MultiplexState>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// The unique arn of the multiplex.
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// The unique arn of the multiplex.
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Appends an item to `availability_zones`.
        ///
        /// To override the contents of this collection use [`set_availability_zones`](Self::set_availability_zones).
        ///
        /// A list of availability zones for the multiplex.
        pub fn availability_zones(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.availability_zones.unwrap_or_default();
            v.push(input.into());
            self.availability_zones = Some(v);
            self
        }
        /// A list of availability zones for the multiplex.
        pub fn set_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.availability_zones = input;
            self
        }
        /// Appends an item to `destinations`.
        ///
        /// To override the contents of this collection use [`set_destinations`](Self::set_destinations).
        ///
        /// A list of the multiplex output destinations.
        pub fn destinations(
            mut self,
            input: impl Into<crate::model::MultiplexOutputDestination>,
        ) -> Self {
            let mut v = self.destinations.unwrap_or_default();
            v.push(input.into());
            self.destinations = Some(v);
            self
        }
        /// A list of the multiplex output destinations.
        pub fn set_destinations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MultiplexOutputDestination>>,
        ) -> Self {
            self.destinations = input;
            self
        }
        /// The unique id of the multiplex.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// The unique id of the multiplex.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Configuration for a multiplex event.
        pub fn multiplex_settings(mut self, input: crate::model::MultiplexSettings) -> Self {
            self.multiplex_settings = Some(input);
            self
        }
        /// Configuration for a multiplex event.
        pub fn set_multiplex_settings(
            mut self,
            input: std::option::Option<crate::model::MultiplexSettings>,
        ) -> Self {
            self.multiplex_settings = input;
            self
        }
        /// The name of the multiplex.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// The name of the multiplex.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// The number of currently healthy pipelines.
        pub fn pipelines_running_count(mut self, input: i32) -> Self {
            self.pipelines_running_count = Some(input);
            self
        }
        /// The number of currently healthy pipelines.
        pub fn set_pipelines_running_count(mut self, input: std::option::Option<i32>) -> Self {
            self.pipelines_running_count = input;
            self
        }
        /// The number of programs in the multiplex.
        pub fn program_count(mut self, input: i32) -> Self {
            self.program_count = Some(input);
            self
        }
        /// The number of programs in the multiplex.
        pub fn set_program_count(mut self, input: std::option::Option<i32>) -> Self {
            self.program_count = input;
            self
        }
        /// The current state of the multiplex.
        pub fn state(mut self, input: crate::model::MultiplexState) -> Self {
            self.state = Some(input);
            self
        }
        /// The current state of the multiplex.
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::MultiplexState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of key-value pairs.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// A collection of key-value pairs.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`StartMultiplexOutput`](crate::output::StartMultiplexOutput)
        pub fn build(self) -> crate::output::StartMultiplexOutput {
            crate::output::StartMultiplexOutput {
                arn: self.arn,
                availability_zones: self.availability_zones,
                destinations: self.destinations,
                id: self.id,
                multiplex_settings: self.multiplex_settings,
                name: self.name,
                pipelines_running_count: self.pipelines_running_count.unwrap_or_default(),
                program_count: self.program_count.unwrap_or_default(),
                state: self.state,
                tags: self.tags,
            }
        }
    }
}
impl StartMultiplexOutput {
    /// Creates a new builder-style object to manufacture [`StartMultiplexOutput`](crate::output::StartMultiplexOutput)
    pub fn builder() -> crate::output::start_multiplex_output::Builder {
        crate::output::start_multiplex_output::Builder::default()
    }
}

/// Placeholder documentation for StartChannelResponse
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartChannelOutput {
    /// The unique arn of the channel.
    pub arn: std::option::Option<std::string::String>,
    /// Specification of CDI inputs for this channel
    pub cdi_input_specification: std::option::Option<crate::model::CdiInputSpecification>,
    /// The class for this channel. STANDARD for a channel with two pipelines or SINGLE_PIPELINE for a channel with one pipeline.
    pub channel_class: std::option::Option<crate::model::ChannelClass>,
    /// A list of destinations of the channel. For UDP outputs, there is one
    /// destination per output. For other types (HLS, for example), there is
    /// one destination per packager.
    pub destinations: std::option::Option<std::vec::Vec<crate::model::OutputDestination>>,
    /// The endpoints where outgoing connections initiate from
    pub egress_endpoints: std::option::Option<std::vec::Vec<crate::model::ChannelEgressEndpoint>>,
    /// Encoder Settings
    pub encoder_settings: std::option::Option<crate::model::EncoderSettings>,
    /// The unique id of the channel.
    pub id: std::option::Option<std::string::String>,
    /// List of input attachments for channel.
    pub input_attachments: std::option::Option<std::vec::Vec<crate::model::InputAttachment>>,
    /// Specification of network and file inputs for this channel
    pub input_specification: std::option::Option<crate::model::InputSpecification>,
    /// The log level being written to CloudWatch Logs.
    pub log_level: std::option::Option<crate::model::LogLevel>,
    /// The name of the channel. (user-mutable)
    pub name: std::option::Option<std::string::String>,
    /// Runtime details for the pipelines of a running channel.
    pub pipeline_details: std::option::Option<std::vec::Vec<crate::model::PipelineDetail>>,
    /// The number of currently healthy pipelines.
    pub pipelines_running_count: i32,
    /// The Amazon Resource Name (ARN) of the role assumed when running the Channel.
    pub role_arn: std::option::Option<std::string::String>,
    /// Placeholder documentation for ChannelState
    pub state: std::option::Option<crate::model::ChannelState>,
    /// A collection of key-value pairs.
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// Settings for VPC output
    pub vpc: std::option::Option<crate::model::VpcOutputSettingsDescription>,
}
impl StartChannelOutput {
    /// The unique arn of the channel.
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// Specification of CDI inputs for this channel
    pub fn cdi_input_specification(
        &self,
    ) -> std::option::Option<&crate::model::CdiInputSpecification> {
        self.cdi_input_specification.as_ref()
    }
    /// The class for this channel. STANDARD for a channel with two pipelines or SINGLE_PIPELINE for a channel with one pipeline.
    pub fn channel_class(&self) -> std::option::Option<&crate::model::ChannelClass> {
        self.channel_class.as_ref()
    }
    /// A list of destinations of the channel. For UDP outputs, there is one
    /// destination per output. For other types (HLS, for example), there is
    /// one destination per packager.
    pub fn destinations(&self) -> std::option::Option<&[crate::model::OutputDestination]> {
        self.destinations.as_deref()
    }
    /// The endpoints where outgoing connections initiate from
    pub fn egress_endpoints(&self) -> std::option::Option<&[crate::model::ChannelEgressEndpoint]> {
        self.egress_endpoints.as_deref()
    }
    /// Encoder Settings
    pub fn encoder_settings(&self) -> std::option::Option<&crate::model::EncoderSettings> {
        self.encoder_settings.as_ref()
    }
    /// The unique id of the channel.
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// List of input attachments for channel.
    pub fn input_attachments(&self) -> std::option::Option<&[crate::model::InputAttachment]> {
        self.input_attachments.as_deref()
    }
    /// Specification of network and file inputs for this channel
    pub fn input_specification(&self) -> std::option::Option<&crate::model::InputSpecification> {
        self.input_specification.as_ref()
    }
    /// The log level being written to CloudWatch Logs.
    pub fn log_level(&self) -> std::option::Option<&crate::model::LogLevel> {
        self.log_level.as_ref()
    }
    /// The name of the channel. (user-mutable)
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// Runtime details for the pipelines of a running channel.
    pub fn pipeline_details(&self) -> std::option::Option<&[crate::model::PipelineDetail]> {
        self.pipeline_details.as_deref()
    }
    /// The number of currently healthy pipelines.
    pub fn pipelines_running_count(&self) -> i32 {
        self.pipelines_running_count
    }
    /// The Amazon Resource Name (ARN) of the role assumed when running the Channel.
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// Placeholder documentation for ChannelState
    pub fn state(&self) -> std::option::Option<&crate::model::ChannelState> {
        self.state.as_ref()
    }
    /// A collection of key-value pairs.
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// Settings for VPC output
    pub fn vpc(&self) -> std::option::Option<&crate::model::VpcOutputSettingsDescription> {
        self.vpc.as_ref()
    }
}
impl std::fmt::Debug for StartChannelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartChannelOutput");
        formatter.field("arn", &self.arn);
        formatter.field("cdi_input_specification", &self.cdi_input_specification);
        formatter.field("channel_class", &self.channel_class);
        formatter.field("destinations", &self.destinations);
        formatter.field("egress_endpoints", &self.egress_endpoints);
        formatter.field("encoder_settings", &self.encoder_settings);
        formatter.field("id", &self.id);
        formatter.field("input_attachments", &self.input_attachments);
        formatter.field("input_specification", &self.input_specification);
        formatter.field("log_level", &self.log_level);
        formatter.field("name", &self.name);
        formatter.field("pipeline_details", &self.pipeline_details);
        formatter.field("pipelines_running_count", &self.pipelines_running_count);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("state", &self.state);
        formatter.field("tags", &self.tags);
        formatter.field("vpc", &self.vpc);
        formatter.finish()
    }
}
/// See [`StartChannelOutput`](crate::output::StartChannelOutput)
pub mod start_channel_output {
    /// A builder for [`StartChannelOutput`](crate::output::StartChannelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) cdi_input_specification:
            std::option::Option<crate::model::CdiInputSpecification>,
        pub(crate) channel_class: std::option::Option<crate::model::ChannelClass>,
        pub(crate) destinations:
            std::option::Option<std::vec::Vec<crate::model::OutputDestination>>,
        pub(crate) egress_endpoints:
            std::option::Option<std::vec::Vec<crate::model::ChannelEgressEndpoint>>,
        pub(crate) encoder_settings: std::option::Option<crate::model::EncoderSettings>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) input_attachments:
            std::option::Option<std::vec::Vec<crate::model::InputAttachment>>,
        pub(crate) input_specification: std::option::Option<crate::model::InputSpecification>,
        pub(crate) log_level: std::option::Option<crate::model::LogLevel>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) pipeline_details:
            std::option::Option<std::vec::Vec<crate::model::PipelineDetail>>,
        pub(crate) pipelines_running_count: std::option::Option<i32>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::ChannelState>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) vpc: std::option::Option<crate::model::VpcOutputSettingsDescription>,
    }
    impl Builder {
        /// The unique arn of the channel.
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// The unique arn of the channel.
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Specification of CDI inputs for this channel
        pub fn cdi_input_specification(
            mut self,
            input: crate::model::CdiInputSpecification,
        ) -> Self {
            self.cdi_input_specification = Some(input);
            self
        }
        /// Specification of CDI inputs for this channel
        pub fn set_cdi_input_specification(
            mut self,
            input: std::option::Option<crate::model::CdiInputSpecification>,
        ) -> Self {
            self.cdi_input_specification = input;
            self
        }
        /// The class for this channel. STANDARD for a channel with two pipelines or SINGLE_PIPELINE for a channel with one pipeline.
        pub fn channel_class(mut self, input: crate::model::ChannelClass) -> Self {
            self.channel_class = Some(input);
            self
        }
        /// The class for this channel. STANDARD for a channel with two pipelines or SINGLE_PIPELINE for a channel with one pipeline.
        pub fn set_channel_class(
            mut self,
            input: std::option::Option<crate::model::ChannelClass>,
        ) -> Self {
            self.channel_class = input;
            self
        }
        /// Appends an item to `destinations`.
        ///
        /// To override the contents of this collection use [`set_destinations`](Self::set_destinations).
        ///
        /// A list of destinations of the channel. For UDP outputs, there is one
        /// destination per output. For other types (HLS, for example), there is
        /// one destination per packager.
        pub fn destinations(mut self, input: impl Into<crate::model::OutputDestination>) -> Self {
            let mut v = self.destinations.unwrap_or_default();
            v.push(input.into());
            self.destinations = Some(v);
            self
        }
        /// A list of destinations of the channel. For UDP outputs, there is one
        /// destination per output. For other types (HLS, for example), there is
        /// one destination per packager.
        pub fn set_destinations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OutputDestination>>,
        ) -> Self {
            self.destinations = input;
            self
        }
        /// Appends an item to `egress_endpoints`.
        ///
        /// To override the contents of this collection use [`set_egress_endpoints`](Self::set_egress_endpoints).
        ///
        /// The endpoints where outgoing connections initiate from
        pub fn egress_endpoints(
            mut self,
            input: impl Into<crate::model::ChannelEgressEndpoint>,
        ) -> Self {
            let mut v = self.egress_endpoints.unwrap_or_default();
            v.push(input.into());
            self.egress_endpoints = Some(v);
            self
        }
        /// The endpoints where outgoing connections initiate from
        pub fn set_egress_endpoints(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ChannelEgressEndpoint>>,
        ) -> Self {
            self.egress_endpoints = input;
            self
        }
        /// Encoder Settings
        pub fn encoder_settings(mut self, input: crate::model::EncoderSettings) -> Self {
            self.encoder_settings = Some(input);
            self
        }
        /// Encoder Settings
        pub fn set_encoder_settings(
            mut self,
            input: std::option::Option<crate::model::EncoderSettings>,
        ) -> Self {
            self.encoder_settings = input;
            self
        }
        /// The unique id of the channel.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// The unique id of the channel.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Appends an item to `input_attachments`.
        ///
        /// To override the contents of this collection use [`set_input_attachments`](Self::set_input_attachments).
        ///
        /// List of input attachments for channel.
        pub fn input_attachments(
            mut self,
            input: impl Into<crate::model::InputAttachment>,
        ) -> Self {
            let mut v = self.input_attachments.unwrap_or_default();
            v.push(input.into());
            self.input_attachments = Some(v);
            self
        }
        /// List of input attachments for channel.
        pub fn set_input_attachments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InputAttachment>>,
        ) -> Self {
            self.input_attachments = input;
            self
        }
        /// Specification of network and file inputs for this channel
        pub fn input_specification(mut self, input: crate::model::InputSpecification) -> Self {
            self.input_specification = Some(input);
            self
        }
        /// Specification of network and file inputs for this channel
        pub fn set_input_specification(
            mut self,
            input: std::option::Option<crate::model::InputSpecification>,
        ) -> Self {
            self.input_specification = input;
            self
        }
        /// The log level being written to CloudWatch Logs.
        pub fn log_level(mut self, input: crate::model::LogLevel) -> Self {
            self.log_level = Some(input);
            self
        }
        /// The log level being written to CloudWatch Logs.
        pub fn set_log_level(mut self, input: std::option::Option<crate::model::LogLevel>) -> Self {
            self.log_level = input;
            self
        }
        /// The name of the channel. (user-mutable)
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// The name of the channel. (user-mutable)
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `pipeline_details`.
        ///
        /// To override the contents of this collection use [`set_pipeline_details`](Self::set_pipeline_details).
        ///
        /// Runtime details for the pipelines of a running channel.
        pub fn pipeline_details(mut self, input: impl Into<crate::model::PipelineDetail>) -> Self {
            let mut v = self.pipeline_details.unwrap_or_default();
            v.push(input.into());
            self.pipeline_details = Some(v);
            self
        }
        /// Runtime details for the pipelines of a running channel.
        pub fn set_pipeline_details(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PipelineDetail>>,
        ) -> Self {
            self.pipeline_details = input;
            self
        }
        /// The number of currently healthy pipelines.
        pub fn pipelines_running_count(mut self, input: i32) -> Self {
            self.pipelines_running_count = Some(input);
            self
        }
        /// The number of currently healthy pipelines.
        pub fn set_pipelines_running_count(mut self, input: std::option::Option<i32>) -> Self {
            self.pipelines_running_count = input;
            self
        }
        /// The Amazon Resource Name (ARN) of the role assumed when running the Channel.
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) of the role assumed when running the Channel.
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Placeholder documentation for ChannelState
        pub fn state(mut self, input: crate::model::ChannelState) -> Self {
            self.state = Some(input);
            self
        }
        /// Placeholder documentation for ChannelState
        pub fn set_state(mut self, input: std::option::Option<crate::model::ChannelState>) -> Self {
            self.state = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of key-value pairs.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// A collection of key-value pairs.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Settings for VPC output
        pub fn vpc(mut self, input: crate::model::VpcOutputSettingsDescription) -> Self {
            self.vpc = Some(input);
            self
        }
        /// Settings for VPC output
        pub fn set_vpc(
            mut self,
            input: std::option::Option<crate::model::VpcOutputSettingsDescription>,
        ) -> Self {
            self.vpc = input;
            self
        }
        /// Consumes the builder and constructs a [`StartChannelOutput`](crate::output::StartChannelOutput)
        pub fn build(self) -> crate::output::StartChannelOutput {
            crate::output::StartChannelOutput {
                arn: self.arn,
                cdi_input_specification: self.cdi_input_specification,
                channel_class: self.channel_class,
                destinations: self.destinations,
                egress_endpoints: self.egress_endpoints,
                encoder_settings: self.encoder_settings,
                id: self.id,
                input_attachments: self.input_attachments,
                input_specification: self.input_specification,
                log_level: self.log_level,
                name: self.name,
                pipeline_details: self.pipeline_details,
                pipelines_running_count: self.pipelines_running_count.unwrap_or_default(),
                role_arn: self.role_arn,
                state: self.state,
                tags: self.tags,
                vpc: self.vpc,
            }
        }
    }
}
impl StartChannelOutput {
    /// Creates a new builder-style object to manufacture [`StartChannelOutput`](crate::output::StartChannelOutput)
    pub fn builder() -> crate::output::start_channel_output::Builder {
        crate::output::start_channel_output::Builder::default()
    }
}

/// Placeholder documentation for RejectInputDeviceTransferResponse
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RejectInputDeviceTransferOutput {}
impl std::fmt::Debug for RejectInputDeviceTransferOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RejectInputDeviceTransferOutput");
        formatter.finish()
    }
}
/// See [`RejectInputDeviceTransferOutput`](crate::output::RejectInputDeviceTransferOutput)
pub mod reject_input_device_transfer_output {
    /// A builder for [`RejectInputDeviceTransferOutput`](crate::output::RejectInputDeviceTransferOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`RejectInputDeviceTransferOutput`](crate::output::RejectInputDeviceTransferOutput)
        pub fn build(self) -> crate::output::RejectInputDeviceTransferOutput {
            crate::output::RejectInputDeviceTransferOutput {}
        }
    }
}
impl RejectInputDeviceTransferOutput {
    /// Creates a new builder-style object to manufacture [`RejectInputDeviceTransferOutput`](crate::output::RejectInputDeviceTransferOutput)
    pub fn builder() -> crate::output::reject_input_device_transfer_output::Builder {
        crate::output::reject_input_device_transfer_output::Builder::default()
    }
}

/// Placeholder documentation for PurchaseOfferingResponse
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PurchaseOfferingOutput {
    /// Reserved resources available to use
    pub reservation: std::option::Option<crate::model::Reservation>,
}
impl PurchaseOfferingOutput {
    /// Reserved resources available to use
    pub fn reservation(&self) -> std::option::Option<&crate::model::Reservation> {
        self.reservation.as_ref()
    }
}
impl std::fmt::Debug for PurchaseOfferingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PurchaseOfferingOutput");
        formatter.field("reservation", &self.reservation);
        formatter.finish()
    }
}
/// See [`PurchaseOfferingOutput`](crate::output::PurchaseOfferingOutput)
pub mod purchase_offering_output {
    /// A builder for [`PurchaseOfferingOutput`](crate::output::PurchaseOfferingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reservation: std::option::Option<crate::model::Reservation>,
    }
    impl Builder {
        /// Reserved resources available to use
        pub fn reservation(mut self, input: crate::model::Reservation) -> Self {
            self.reservation = Some(input);
            self
        }
        /// Reserved resources available to use
        pub fn set_reservation(
            mut self,
            input: std::option::Option<crate::model::Reservation>,
        ) -> Self {
            self.reservation = input;
            self
        }
        /// Consumes the builder and constructs a [`PurchaseOfferingOutput`](crate::output::PurchaseOfferingOutput)
        pub fn build(self) -> crate::output::PurchaseOfferingOutput {
            crate::output::PurchaseOfferingOutput {
                reservation: self.reservation,
            }
        }
    }
}
impl PurchaseOfferingOutput {
    /// Creates a new builder-style object to manufacture [`PurchaseOfferingOutput`](crate::output::PurchaseOfferingOutput)
    pub fn builder() -> crate::output::purchase_offering_output::Builder {
        crate::output::purchase_offering_output::Builder::default()
    }
}

/// Placeholder documentation for ListTagsForResourceResponse
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// Placeholder documentation for Tags
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ListTagsForResourceOutput {
    /// Placeholder documentation for Tags
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// Placeholder documentation for Tags
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// Placeholder documentation for Tags
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

/// Placeholder documentation for ListReservationsResponse
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListReservationsOutput {
    /// Token to retrieve the next page of results
    pub next_token: std::option::Option<std::string::String>,
    /// List of reservations
    pub reservations: std::option::Option<std::vec::Vec<crate::model::Reservation>>,
}
impl ListReservationsOutput {
    /// Token to retrieve the next page of results
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// List of reservations
    pub fn reservations(&self) -> std::option::Option<&[crate::model::Reservation]> {
        self.reservations.as_deref()
    }
}
impl std::fmt::Debug for ListReservationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListReservationsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("reservations", &self.reservations);
        formatter.finish()
    }
}
/// See [`ListReservationsOutput`](crate::output::ListReservationsOutput)
pub mod list_reservations_output {
    /// A builder for [`ListReservationsOutput`](crate::output::ListReservationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) reservations: std::option::Option<std::vec::Vec<crate::model::Reservation>>,
    }
    impl Builder {
        /// Token to retrieve the next page of results
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// Token to retrieve the next page of results
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `reservations`.
        ///
        /// To override the contents of this collection use [`set_reservations`](Self::set_reservations).
        ///
        /// List of reservations
        pub fn reservations(mut self, input: impl Into<crate::model::Reservation>) -> Self {
            let mut v = self.reservations.unwrap_or_default();
            v.push(input.into());
            self.reservations = Some(v);
            self
        }
        /// List of reservations
        pub fn set_reservations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Reservation>>,
        ) -> Self {
            self.reservations = input;
            self
        }
        /// Consumes the builder and constructs a [`ListReservationsOutput`](crate::output::ListReservationsOutput)
        pub fn build(self) -> crate::output::ListReservationsOutput {
            crate::output::ListReservationsOutput {
                next_token: self.next_token,
                reservations: self.reservations,
            }
        }
    }
}
impl ListReservationsOutput {
    /// Creates a new builder-style object to manufacture [`ListReservationsOutput`](crate::output::ListReservationsOutput)
    pub fn builder() -> crate::output::list_reservations_output::Builder {
        crate::output::list_reservations_output::Builder::default()
    }
}

/// Placeholder documentation for ListOfferingsResponse
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListOfferingsOutput {
    /// Token to retrieve the next page of results
    pub next_token: std::option::Option<std::string::String>,
    /// List of offerings
    pub offerings: std::option::Option<std::vec::Vec<crate::model::Offering>>,
}
impl ListOfferingsOutput {
    /// Token to retrieve the next page of results
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// List of offerings
    pub fn offerings(&self) -> std::option::Option<&[crate::model::Offering]> {
        self.offerings.as_deref()
    }
}
impl std::fmt::Debug for ListOfferingsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListOfferingsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("offerings", &self.offerings);
        formatter.finish()
    }
}
/// See [`ListOfferingsOutput`](crate::output::ListOfferingsOutput)
pub mod list_offerings_output {
    /// A builder for [`ListOfferingsOutput`](crate::output::ListOfferingsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) offerings: std::option::Option<std::vec::Vec<crate::model::Offering>>,
    }
    impl Builder {
        /// Token to retrieve the next page of results
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// Token to retrieve the next page of results
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `offerings`.
        ///
        /// To override the contents of this collection use [`set_offerings`](Self::set_offerings).
        ///
        /// List of offerings
        pub fn offerings(mut self, input: impl Into<crate::model::Offering>) -> Self {
            let mut v = self.offerings.unwrap_or_default();
            v.push(input.into());
            self.offerings = Some(v);
            self
        }
        /// List of offerings
        pub fn set_offerings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Offering>>,
        ) -> Self {
            self.offerings = input;
            self
        }
        /// Consumes the builder and constructs a [`ListOfferingsOutput`](crate::output::ListOfferingsOutput)
        pub fn build(self) -> crate::output::ListOfferingsOutput {
            crate::output::ListOfferingsOutput {
                next_token: self.next_token,
                offerings: self.offerings,
            }
        }
    }
}
impl ListOfferingsOutput {
    /// Creates a new builder-style object to manufacture [`ListOfferingsOutput`](crate::output::ListOfferingsOutput)
    pub fn builder() -> crate::output::list_offerings_output::Builder {
        crate::output::list_offerings_output::Builder::default()
    }
}

/// Placeholder documentation for ListMultiplexProgramsResponse
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListMultiplexProgramsOutput {
    /// List of multiplex programs.
    pub multiplex_programs:
        std::option::Option<std::vec::Vec<crate::model::MultiplexProgramSummary>>,
    /// Token for the next ListMultiplexProgram request.
    pub next_token: std::option::Option<std::string::String>,
}
impl ListMultiplexProgramsOutput {
    /// List of multiplex programs.
    pub fn multiplex_programs(
        &self,
    ) -> std::option::Option<&[crate::model::MultiplexProgramSummary]> {
        self.multiplex_programs.as_deref()
    }
    /// Token for the next ListMultiplexProgram request.
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListMultiplexProgramsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListMultiplexProgramsOutput");
        formatter.field("multiplex_programs", &self.multiplex_programs);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListMultiplexProgramsOutput`](crate::output::ListMultiplexProgramsOutput)
pub mod list_multiplex_programs_output {
    /// A builder for [`ListMultiplexProgramsOutput`](crate::output::ListMultiplexProgramsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) multiplex_programs:
            std::option::Option<std::vec::Vec<crate::model::MultiplexProgramSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `multiplex_programs`.
        ///
        /// To override the contents of this collection use [`set_multiplex_programs`](Self::set_multiplex_programs).
        ///
        /// List of multiplex programs.
        pub fn multiplex_programs(
            mut self,
            input: impl Into<crate::model::MultiplexProgramSummary>,
        ) -> Self {
            let mut v = self.multiplex_programs.unwrap_or_default();
            v.push(input.into());
            self.multiplex_programs = Some(v);
            self
        }
        /// List of multiplex programs.
        pub fn set_multiplex_programs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MultiplexProgramSummary>>,
        ) -> Self {
            self.multiplex_programs = input;
            self
        }
        /// Token for the next ListMultiplexProgram request.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// Token for the next ListMultiplexProgram request.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListMultiplexProgramsOutput`](crate::output::ListMultiplexProgramsOutput)
        pub fn build(self) -> crate::output::ListMultiplexProgramsOutput {
            crate::output::ListMultiplexProgramsOutput {
                multiplex_programs: self.multiplex_programs,
                next_token: self.next_token,
            }
        }
    }
}
impl ListMultiplexProgramsOutput {
    /// Creates a new builder-style object to manufacture [`ListMultiplexProgramsOutput`](crate::output::ListMultiplexProgramsOutput)
    pub fn builder() -> crate::output::list_multiplex_programs_output::Builder {
        crate::output::list_multiplex_programs_output::Builder::default()
    }
}

/// Placeholder documentation for ListMultiplexesResponse
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListMultiplexesOutput {
    /// List of multiplexes.
    pub multiplexes: std::option::Option<std::vec::Vec<crate::model::MultiplexSummary>>,
    /// Token for the next ListMultiplexes request.
    pub next_token: std::option::Option<std::string::String>,
}
impl ListMultiplexesOutput {
    /// List of multiplexes.
    pub fn multiplexes(&self) -> std::option::Option<&[crate::model::MultiplexSummary]> {
        self.multiplexes.as_deref()
    }
    /// Token for the next ListMultiplexes request.
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListMultiplexesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListMultiplexesOutput");
        formatter.field("multiplexes", &self.multiplexes);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListMultiplexesOutput`](crate::output::ListMultiplexesOutput)
pub mod list_multiplexes_output {
    /// A builder for [`ListMultiplexesOutput`](crate::output::ListMultiplexesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) multiplexes: std::option::Option<std::vec::Vec<crate::model::MultiplexSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `multiplexes`.
        ///
        /// To override the contents of this collection use [`set_multiplexes`](Self::set_multiplexes).
        ///
        /// List of multiplexes.
        pub fn multiplexes(mut self, input: impl Into<crate::model::MultiplexSummary>) -> Self {
            let mut v = self.multiplexes.unwrap_or_default();
            v.push(input.into());
            self.multiplexes = Some(v);
            self
        }
        /// List of multiplexes.
        pub fn set_multiplexes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MultiplexSummary>>,
        ) -> Self {
            self.multiplexes = input;
            self
        }
        /// Token for the next ListMultiplexes request.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// Token for the next ListMultiplexes request.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListMultiplexesOutput`](crate::output::ListMultiplexesOutput)
        pub fn build(self) -> crate::output::ListMultiplexesOutput {
            crate::output::ListMultiplexesOutput {
                multiplexes: self.multiplexes,
                next_token: self.next_token,
            }
        }
    }
}
impl ListMultiplexesOutput {
    /// Creates a new builder-style object to manufacture [`ListMultiplexesOutput`](crate::output::ListMultiplexesOutput)
    pub fn builder() -> crate::output::list_multiplexes_output::Builder {
        crate::output::list_multiplexes_output::Builder::default()
    }
}

/// Placeholder documentation for ListInputSecurityGroupsResponse
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListInputSecurityGroupsOutput {
    /// List of input security groups
    pub input_security_groups: std::option::Option<std::vec::Vec<crate::model::InputSecurityGroup>>,
    /// Placeholder documentation for __string
    pub next_token: std::option::Option<std::string::String>,
}
impl ListInputSecurityGroupsOutput {
    /// List of input security groups
    pub fn input_security_groups(
        &self,
    ) -> std::option::Option<&[crate::model::InputSecurityGroup]> {
        self.input_security_groups.as_deref()
    }
    /// Placeholder documentation for __string
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListInputSecurityGroupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListInputSecurityGroupsOutput");
        formatter.field("input_security_groups", &self.input_security_groups);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListInputSecurityGroupsOutput`](crate::output::ListInputSecurityGroupsOutput)
pub mod list_input_security_groups_output {
    /// A builder for [`ListInputSecurityGroupsOutput`](crate::output::ListInputSecurityGroupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input_security_groups:
            std::option::Option<std::vec::Vec<crate::model::InputSecurityGroup>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `input_security_groups`.
        ///
        /// To override the contents of this collection use [`set_input_security_groups`](Self::set_input_security_groups).
        ///
        /// List of input security groups
        pub fn input_security_groups(
            mut self,
            input: impl Into<crate::model::InputSecurityGroup>,
        ) -> Self {
            let mut v = self.input_security_groups.unwrap_or_default();
            v.push(input.into());
            self.input_security_groups = Some(v);
            self
        }
        /// List of input security groups
        pub fn set_input_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InputSecurityGroup>>,
        ) -> Self {
            self.input_security_groups = input;
            self
        }
        /// Placeholder documentation for __string
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// Placeholder documentation for __string
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListInputSecurityGroupsOutput`](crate::output::ListInputSecurityGroupsOutput)
        pub fn build(self) -> crate::output::ListInputSecurityGroupsOutput {
            crate::output::ListInputSecurityGroupsOutput {
                input_security_groups: self.input_security_groups,
                next_token: self.next_token,
            }
        }
    }
}
impl ListInputSecurityGroupsOutput {
    /// Creates a new builder-style object to manufacture [`ListInputSecurityGroupsOutput`](crate::output::ListInputSecurityGroupsOutput)
    pub fn builder() -> crate::output::list_input_security_groups_output::Builder {
        crate::output::list_input_security_groups_output::Builder::default()
    }
}

/// Placeholder documentation for ListInputsResponse
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListInputsOutput {
    /// Placeholder documentation for __listOfInput
    pub inputs: std::option::Option<std::vec::Vec<crate::model::Input>>,
    /// Placeholder documentation for __string
    pub next_token: std::option::Option<std::string::String>,
}
impl ListInputsOutput {
    /// Placeholder documentation for __listOfInput
    pub fn inputs(&self) -> std::option::Option<&[crate::model::Input]> {
        self.inputs.as_deref()
    }
    /// Placeholder documentation for __string
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListInputsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListInputsOutput");
        formatter.field("inputs", &self.inputs);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListInputsOutput`](crate::output::ListInputsOutput)
pub mod list_inputs_output {
    /// A builder for [`ListInputsOutput`](crate::output::ListInputsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) inputs: std::option::Option<std::vec::Vec<crate::model::Input>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `inputs`.
        ///
        /// To override the contents of this collection use [`set_inputs`](Self::set_inputs).
        ///
        /// Placeholder documentation for __listOfInput
        pub fn inputs(mut self, input: impl Into<crate::model::Input>) -> Self {
            let mut v = self.inputs.unwrap_or_default();
            v.push(input.into());
            self.inputs = Some(v);
            self
        }
        /// Placeholder documentation for __listOfInput
        pub fn set_inputs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Input>>,
        ) -> Self {
            self.inputs = input;
            self
        }
        /// Placeholder documentation for __string
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// Placeholder documentation for __string
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListInputsOutput`](crate::output::ListInputsOutput)
        pub fn build(self) -> crate::output::ListInputsOutput {
            crate::output::ListInputsOutput {
                inputs: self.inputs,
                next_token: self.next_token,
            }
        }
    }
}
impl ListInputsOutput {
    /// Creates a new builder-style object to manufacture [`ListInputsOutput`](crate::output::ListInputsOutput)
    pub fn builder() -> crate::output::list_inputs_output::Builder {
        crate::output::list_inputs_output::Builder::default()
    }
}

/// Placeholder documentation for ListInputDeviceTransfersResponse
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListInputDeviceTransfersOutput {
    /// The list of devices that you are transferring or are being transferred to you.
    pub input_device_transfers:
        std::option::Option<std::vec::Vec<crate::model::TransferringInputDeviceSummary>>,
    /// A token to get additional list results.
    pub next_token: std::option::Option<std::string::String>,
}
impl ListInputDeviceTransfersOutput {
    /// The list of devices that you are transferring or are being transferred to you.
    pub fn input_device_transfers(
        &self,
    ) -> std::option::Option<&[crate::model::TransferringInputDeviceSummary]> {
        self.input_device_transfers.as_deref()
    }
    /// A token to get additional list results.
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListInputDeviceTransfersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListInputDeviceTransfersOutput");
        formatter.field("input_device_transfers", &self.input_device_transfers);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListInputDeviceTransfersOutput`](crate::output::ListInputDeviceTransfersOutput)
pub mod list_input_device_transfers_output {
    /// A builder for [`ListInputDeviceTransfersOutput`](crate::output::ListInputDeviceTransfersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input_device_transfers:
            std::option::Option<std::vec::Vec<crate::model::TransferringInputDeviceSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `input_device_transfers`.
        ///
        /// To override the contents of this collection use [`set_input_device_transfers`](Self::set_input_device_transfers).
        ///
        /// The list of devices that you are transferring or are being transferred to you.
        pub fn input_device_transfers(
            mut self,
            input: impl Into<crate::model::TransferringInputDeviceSummary>,
        ) -> Self {
            let mut v = self.input_device_transfers.unwrap_or_default();
            v.push(input.into());
            self.input_device_transfers = Some(v);
            self
        }
        /// The list of devices that you are transferring or are being transferred to you.
        pub fn set_input_device_transfers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TransferringInputDeviceSummary>>,
        ) -> Self {
            self.input_device_transfers = input;
            self
        }
        /// A token to get additional list results.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// A token to get additional list results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListInputDeviceTransfersOutput`](crate::output::ListInputDeviceTransfersOutput)
        pub fn build(self) -> crate::output::ListInputDeviceTransfersOutput {
            crate::output::ListInputDeviceTransfersOutput {
                input_device_transfers: self.input_device_transfers,
                next_token: self.next_token,
            }
        }
    }
}
impl ListInputDeviceTransfersOutput {
    /// Creates a new builder-style object to manufacture [`ListInputDeviceTransfersOutput`](crate::output::ListInputDeviceTransfersOutput)
    pub fn builder() -> crate::output::list_input_device_transfers_output::Builder {
        crate::output::list_input_device_transfers_output::Builder::default()
    }
}

/// Placeholder documentation for ListInputDevicesResponse
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListInputDevicesOutput {
    /// The list of input devices.
    pub input_devices: std::option::Option<std::vec::Vec<crate::model::InputDeviceSummary>>,
    /// A token to get additional list results.
    pub next_token: std::option::Option<std::string::String>,
}
impl ListInputDevicesOutput {
    /// The list of input devices.
    pub fn input_devices(&self) -> std::option::Option<&[crate::model::InputDeviceSummary]> {
        self.input_devices.as_deref()
    }
    /// A token to get additional list results.
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListInputDevicesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListInputDevicesOutput");
        formatter.field("input_devices", &self.input_devices);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListInputDevicesOutput`](crate::output::ListInputDevicesOutput)
pub mod list_input_devices_output {
    /// A builder for [`ListInputDevicesOutput`](crate::output::ListInputDevicesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input_devices:
            std::option::Option<std::vec::Vec<crate::model::InputDeviceSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `input_devices`.
        ///
        /// To override the contents of this collection use [`set_input_devices`](Self::set_input_devices).
        ///
        /// The list of input devices.
        pub fn input_devices(mut self, input: impl Into<crate::model::InputDeviceSummary>) -> Self {
            let mut v = self.input_devices.unwrap_or_default();
            v.push(input.into());
            self.input_devices = Some(v);
            self
        }
        /// The list of input devices.
        pub fn set_input_devices(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InputDeviceSummary>>,
        ) -> Self {
            self.input_devices = input;
            self
        }
        /// A token to get additional list results.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// A token to get additional list results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListInputDevicesOutput`](crate::output::ListInputDevicesOutput)
        pub fn build(self) -> crate::output::ListInputDevicesOutput {
            crate::output::ListInputDevicesOutput {
                input_devices: self.input_devices,
                next_token: self.next_token,
            }
        }
    }
}
impl ListInputDevicesOutput {
    /// Creates a new builder-style object to manufacture [`ListInputDevicesOutput`](crate::output::ListInputDevicesOutput)
    pub fn builder() -> crate::output::list_input_devices_output::Builder {
        crate::output::list_input_devices_output::Builder::default()
    }
}

/// Placeholder documentation for ListChannelsResponse
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListChannelsOutput {
    /// Placeholder documentation for __listOfChannelSummary
    pub channels: std::option::Option<std::vec::Vec<crate::model::ChannelSummary>>,
    /// Placeholder documentation for __string
    pub next_token: std::option::Option<std::string::String>,
}
impl ListChannelsOutput {
    /// Placeholder documentation for __listOfChannelSummary
    pub fn channels(&self) -> std::option::Option<&[crate::model::ChannelSummary]> {
        self.channels.as_deref()
    }
    /// Placeholder documentation for __string
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListChannelsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListChannelsOutput");
        formatter.field("channels", &self.channels);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListChannelsOutput`](crate::output::ListChannelsOutput)
pub mod list_channels_output {
    /// A builder for [`ListChannelsOutput`](crate::output::ListChannelsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channels: std::option::Option<std::vec::Vec<crate::model::ChannelSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `channels`.
        ///
        /// To override the contents of this collection use [`set_channels`](Self::set_channels).
        ///
        /// Placeholder documentation for __listOfChannelSummary
        pub fn channels(mut self, input: impl Into<crate::model::ChannelSummary>) -> Self {
            let mut v = self.channels.unwrap_or_default();
            v.push(input.into());
            self.channels = Some(v);
            self
        }
        /// Placeholder documentation for __listOfChannelSummary
        pub fn set_channels(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ChannelSummary>>,
        ) -> Self {
            self.channels = input;
            self
        }
        /// Placeholder documentation for __string
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// Placeholder documentation for __string
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListChannelsOutput`](crate::output::ListChannelsOutput)
        pub fn build(self) -> crate::output::ListChannelsOutput {
            crate::output::ListChannelsOutput {
                channels: self.channels,
                next_token: self.next_token,
            }
        }
    }
}
impl ListChannelsOutput {
    /// Creates a new builder-style object to manufacture [`ListChannelsOutput`](crate::output::ListChannelsOutput)
    pub fn builder() -> crate::output::list_channels_output::Builder {
        crate::output::list_channels_output::Builder::default()
    }
}

/// Placeholder documentation for DescribeScheduleResponse
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeScheduleOutput {
    /// The next token; for use in pagination.
    pub next_token: std::option::Option<std::string::String>,
    /// The list of actions in the schedule.
    pub schedule_actions: std::option::Option<std::vec::Vec<crate::model::ScheduleAction>>,
}
impl DescribeScheduleOutput {
    /// The next token; for use in pagination.
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// The list of actions in the schedule.
    pub fn schedule_actions(&self) -> std::option::Option<&[crate::model::ScheduleAction]> {
        self.schedule_actions.as_deref()
    }
}
impl std::fmt::Debug for DescribeScheduleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeScheduleOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("schedule_actions", &self.schedule_actions);
        formatter.finish()
    }
}
/// See [`DescribeScheduleOutput`](crate::output::DescribeScheduleOutput)
pub mod describe_schedule_output {
    /// A builder for [`DescribeScheduleOutput`](crate::output::DescribeScheduleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) schedule_actions:
            std::option::Option<std::vec::Vec<crate::model::ScheduleAction>>,
    }
    impl Builder {
        /// The next token; for use in pagination.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// The next token; for use in pagination.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `schedule_actions`.
        ///
        /// To override the contents of this collection use [`set_schedule_actions`](Self::set_schedule_actions).
        ///
        /// The list of actions in the schedule.
        pub fn schedule_actions(mut self, input: impl Into<crate::model::ScheduleAction>) -> Self {
            let mut v = self.schedule_actions.unwrap_or_default();
            v.push(input.into());
            self.schedule_actions = Some(v);
            self
        }
        /// The list of actions in the schedule.
        pub fn set_schedule_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ScheduleAction>>,
        ) -> Self {
            self.schedule_actions = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeScheduleOutput`](crate::output::DescribeScheduleOutput)
        pub fn build(self) -> crate::output::DescribeScheduleOutput {
            crate::output::DescribeScheduleOutput {
                next_token: self.next_token,
                schedule_actions: self.schedule_actions,
            }
        }
    }
}
impl DescribeScheduleOutput {
    /// Creates a new builder-style object to manufacture [`DescribeScheduleOutput`](crate::output::DescribeScheduleOutput)
    pub fn builder() -> crate::output::describe_schedule_output::Builder {
        crate::output::describe_schedule_output::Builder::default()
    }
}

/// Placeholder documentation for DescribeReservationResponse
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeReservationOutput {
    /// Unique reservation ARN, e.g. 'arn:aws:medialive:us-west-2:123456789012:reservation:1234567'
    pub arn: std::option::Option<std::string::String>,
    /// Number of reserved resources
    pub count: i32,
    /// Currency code for usagePrice and fixedPrice in ISO-4217 format, e.g. 'USD'
    pub currency_code: std::option::Option<std::string::String>,
    /// Lease duration, e.g. '12'
    pub duration: i32,
    /// Units for duration, e.g. 'MONTHS'
    pub duration_units: std::option::Option<crate::model::OfferingDurationUnits>,
    /// Reservation UTC end date and time in ISO-8601 format, e.g. '2019-03-01T00:00:00'
    pub end: std::option::Option<std::string::String>,
    /// One-time charge for each reserved resource, e.g. '0.0' for a NO_UPFRONT offering
    pub fixed_price: f64,
    /// User specified reservation name
    pub name: std::option::Option<std::string::String>,
    /// Offering description, e.g. 'HD AVC output at 10-20 Mbps, 30 fps, and standard VQ in US West (Oregon)'
    pub offering_description: std::option::Option<std::string::String>,
    /// Unique offering ID, e.g. '87654321'
    pub offering_id: std::option::Option<std::string::String>,
    /// Offering type, e.g. 'NO_UPFRONT'
    pub offering_type: std::option::Option<crate::model::OfferingType>,
    /// AWS region, e.g. 'us-west-2'
    pub region: std::option::Option<std::string::String>,
    /// Unique reservation ID, e.g. '1234567'
    pub reservation_id: std::option::Option<std::string::String>,
    /// Resource configuration details
    pub resource_specification: std::option::Option<crate::model::ReservationResourceSpecification>,
    /// Reservation UTC start date and time in ISO-8601 format, e.g. '2018-03-01T00:00:00'
    pub start: std::option::Option<std::string::String>,
    /// Current state of reservation, e.g. 'ACTIVE'
    pub state: std::option::Option<crate::model::ReservationState>,
    /// A collection of key-value pairs
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// Recurring usage charge for each reserved resource, e.g. '157.0'
    pub usage_price: f64,
}
impl DescribeReservationOutput {
    /// Unique reservation ARN, e.g. 'arn:aws:medialive:us-west-2:123456789012:reservation:1234567'
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// Number of reserved resources
    pub fn count(&self) -> i32 {
        self.count
    }
    /// Currency code for usagePrice and fixedPrice in ISO-4217 format, e.g. 'USD'
    pub fn currency_code(&self) -> std::option::Option<&str> {
        self.currency_code.as_deref()
    }
    /// Lease duration, e.g. '12'
    pub fn duration(&self) -> i32 {
        self.duration
    }
    /// Units for duration, e.g. 'MONTHS'
    pub fn duration_units(&self) -> std::option::Option<&crate::model::OfferingDurationUnits> {
        self.duration_units.as_ref()
    }
    /// Reservation UTC end date and time in ISO-8601 format, e.g. '2019-03-01T00:00:00'
    pub fn end(&self) -> std::option::Option<&str> {
        self.end.as_deref()
    }
    /// One-time charge for each reserved resource, e.g. '0.0' for a NO_UPFRONT offering
    pub fn fixed_price(&self) -> f64 {
        self.fixed_price
    }
    /// User specified reservation name
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// Offering description, e.g. 'HD AVC output at 10-20 Mbps, 30 fps, and standard VQ in US West (Oregon)'
    pub fn offering_description(&self) -> std::option::Option<&str> {
        self.offering_description.as_deref()
    }
    /// Unique offering ID, e.g. '87654321'
    pub fn offering_id(&self) -> std::option::Option<&str> {
        self.offering_id.as_deref()
    }
    /// Offering type, e.g. 'NO_UPFRONT'
    pub fn offering_type(&self) -> std::option::Option<&crate::model::OfferingType> {
        self.offering_type.as_ref()
    }
    /// AWS region, e.g. 'us-west-2'
    pub fn region(&self) -> std::option::Option<&str> {
        self.region.as_deref()
    }
    /// Unique reservation ID, e.g. '1234567'
    pub fn reservation_id(&self) -> std::option::Option<&str> {
        self.reservation_id.as_deref()
    }
    /// Resource configuration details
    pub fn resource_specification(
        &self,
    ) -> std::option::Option<&crate::model::ReservationResourceSpecification> {
        self.resource_specification.as_ref()
    }
    /// Reservation UTC start date and time in ISO-8601 format, e.g. '2018-03-01T00:00:00'
    pub fn start(&self) -> std::option::Option<&str> {
        self.start.as_deref()
    }
    /// Current state of reservation, e.g. 'ACTIVE'
    pub fn state(&self) -> std::option::Option<&crate::model::ReservationState> {
        self.state.as_ref()
    }
    /// A collection of key-value pairs
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// Recurring usage charge for each reserved resource, e.g. '157.0'
    pub fn usage_price(&self) -> f64 {
        self.usage_price
    }
}
impl std::fmt::Debug for DescribeReservationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeReservationOutput");
        formatter.field("arn", &self.arn);
        formatter.field("count", &self.count);
        formatter.field("currency_code", &self.currency_code);
        formatter.field("duration", &self.duration);
        formatter.field("duration_units", &self.duration_units);
        formatter.field("end", &self.end);
        formatter.field("fixed_price", &self.fixed_price);
        formatter.field("name", &self.name);
        formatter.field("offering_description", &self.offering_description);
        formatter.field("offering_id", &self.offering_id);
        formatter.field("offering_type", &self.offering_type);
        formatter.field("region", &self.region);
        formatter.field("reservation_id", &self.reservation_id);
        formatter.field("resource_specification", &self.resource_specification);
        formatter.field("start", &self.start);
        formatter.field("state", &self.state);
        formatter.field("tags", &self.tags);
        formatter.field("usage_price", &self.usage_price);
        formatter.finish()
    }
}
/// See [`DescribeReservationOutput`](crate::output::DescribeReservationOutput)
pub mod describe_reservation_output {
    /// A builder for [`DescribeReservationOutput`](crate::output::DescribeReservationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) count: std::option::Option<i32>,
        pub(crate) currency_code: std::option::Option<std::string::String>,
        pub(crate) duration: std::option::Option<i32>,
        pub(crate) duration_units: std::option::Option<crate::model::OfferingDurationUnits>,
        pub(crate) end: std::option::Option<std::string::String>,
        pub(crate) fixed_price: std::option::Option<f64>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) offering_description: std::option::Option<std::string::String>,
        pub(crate) offering_id: std::option::Option<std::string::String>,
        pub(crate) offering_type: std::option::Option<crate::model::OfferingType>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) reservation_id: std::option::Option<std::string::String>,
        pub(crate) resource_specification:
            std::option::Option<crate::model::ReservationResourceSpecification>,
        pub(crate) start: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::ReservationState>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) usage_price: std::option::Option<f64>,
    }
    impl Builder {
        /// Unique reservation ARN, e.g. 'arn:aws:medialive:us-west-2:123456789012:reservation:1234567'
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// Unique reservation ARN, e.g. 'arn:aws:medialive:us-west-2:123456789012:reservation:1234567'
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Number of reserved resources
        pub fn count(mut self, input: i32) -> Self {
            self.count = Some(input);
            self
        }
        /// Number of reserved resources
        pub fn set_count(mut self, input: std::option::Option<i32>) -> Self {
            self.count = input;
            self
        }
        /// Currency code for usagePrice and fixedPrice in ISO-4217 format, e.g. 'USD'
        pub fn currency_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.currency_code = Some(input.into());
            self
        }
        /// Currency code for usagePrice and fixedPrice in ISO-4217 format, e.g. 'USD'
        pub fn set_currency_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.currency_code = input;
            self
        }
        /// Lease duration, e.g. '12'
        pub fn duration(mut self, input: i32) -> Self {
            self.duration = Some(input);
            self
        }
        /// Lease duration, e.g. '12'
        pub fn set_duration(mut self, input: std::option::Option<i32>) -> Self {
            self.duration = input;
            self
        }
        /// Units for duration, e.g. 'MONTHS'
        pub fn duration_units(mut self, input: crate::model::OfferingDurationUnits) -> Self {
            self.duration_units = Some(input);
            self
        }
        /// Units for duration, e.g. 'MONTHS'
        pub fn set_duration_units(
            mut self,
            input: std::option::Option<crate::model::OfferingDurationUnits>,
        ) -> Self {
            self.duration_units = input;
            self
        }
        /// Reservation UTC end date and time in ISO-8601 format, e.g. '2019-03-01T00:00:00'
        pub fn end(mut self, input: impl Into<std::string::String>) -> Self {
            self.end = Some(input.into());
            self
        }
        /// Reservation UTC end date and time in ISO-8601 format, e.g. '2019-03-01T00:00:00'
        pub fn set_end(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.end = input;
            self
        }
        /// One-time charge for each reserved resource, e.g. '0.0' for a NO_UPFRONT offering
        pub fn fixed_price(mut self, input: f64) -> Self {
            self.fixed_price = Some(input);
            self
        }
        /// One-time charge for each reserved resource, e.g. '0.0' for a NO_UPFRONT offering
        pub fn set_fixed_price(mut self, input: std::option::Option<f64>) -> Self {
            self.fixed_price = input;
            self
        }
        /// User specified reservation name
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// User specified reservation name
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Offering description, e.g. 'HD AVC output at 10-20 Mbps, 30 fps, and standard VQ in US West (Oregon)'
        pub fn offering_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.offering_description = Some(input.into());
            self
        }
        /// Offering description, e.g. 'HD AVC output at 10-20 Mbps, 30 fps, and standard VQ in US West (Oregon)'
        pub fn set_offering_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.offering_description = input;
            self
        }
        /// Unique offering ID, e.g. '87654321'
        pub fn offering_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.offering_id = Some(input.into());
            self
        }
        /// Unique offering ID, e.g. '87654321'
        pub fn set_offering_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.offering_id = input;
            self
        }
        /// Offering type, e.g. 'NO_UPFRONT'
        pub fn offering_type(mut self, input: crate::model::OfferingType) -> Self {
            self.offering_type = Some(input);
            self
        }
        /// Offering type, e.g. 'NO_UPFRONT'
        pub fn set_offering_type(
            mut self,
            input: std::option::Option<crate::model::OfferingType>,
        ) -> Self {
            self.offering_type = input;
            self
        }
        /// AWS region, e.g. 'us-west-2'
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// AWS region, e.g. 'us-west-2'
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// Unique reservation ID, e.g. '1234567'
        pub fn reservation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.reservation_id = Some(input.into());
            self
        }
        /// Unique reservation ID, e.g. '1234567'
        pub fn set_reservation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reservation_id = input;
            self
        }
        /// Resource configuration details
        pub fn resource_specification(
            mut self,
            input: crate::model::ReservationResourceSpecification,
        ) -> Self {
            self.resource_specification = Some(input);
            self
        }
        /// Resource configuration details
        pub fn set_resource_specification(
            mut self,
            input: std::option::Option<crate::model::ReservationResourceSpecification>,
        ) -> Self {
            self.resource_specification = input;
            self
        }
        /// Reservation UTC start date and time in ISO-8601 format, e.g. '2018-03-01T00:00:00'
        pub fn start(mut self, input: impl Into<std::string::String>) -> Self {
            self.start = Some(input.into());
            self
        }
        /// Reservation UTC start date and time in ISO-8601 format, e.g. '2018-03-01T00:00:00'
        pub fn set_start(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.start = input;
            self
        }
        /// Current state of reservation, e.g. 'ACTIVE'
        pub fn state(mut self, input: crate::model::ReservationState) -> Self {
            self.state = Some(input);
            self
        }
        /// Current state of reservation, e.g. 'ACTIVE'
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::ReservationState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of key-value pairs
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// A collection of key-value pairs
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Recurring usage charge for each reserved resource, e.g. '157.0'
        pub fn usage_price(mut self, input: f64) -> Self {
            self.usage_price = Some(input);
            self
        }
        /// Recurring usage charge for each reserved resource, e.g. '157.0'
        pub fn set_usage_price(mut self, input: std::option::Option<f64>) -> Self {
            self.usage_price = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeReservationOutput`](crate::output::DescribeReservationOutput)
        pub fn build(self) -> crate::output::DescribeReservationOutput {
            crate::output::DescribeReservationOutput {
                arn: self.arn,
                count: self.count.unwrap_or_default(),
                currency_code: self.currency_code,
                duration: self.duration.unwrap_or_default(),
                duration_units: self.duration_units,
                end: self.end,
                fixed_price: self.fixed_price.unwrap_or_default(),
                name: self.name,
                offering_description: self.offering_description,
                offering_id: self.offering_id,
                offering_type: self.offering_type,
                region: self.region,
                reservation_id: self.reservation_id,
                resource_specification: self.resource_specification,
                start: self.start,
                state: self.state,
                tags: self.tags,
                usage_price: self.usage_price.unwrap_or_default(),
            }
        }
    }
}
impl DescribeReservationOutput {
    /// Creates a new builder-style object to manufacture [`DescribeReservationOutput`](crate::output::DescribeReservationOutput)
    pub fn builder() -> crate::output::describe_reservation_output::Builder {
        crate::output::describe_reservation_output::Builder::default()
    }
}

/// Placeholder documentation for DescribeOfferingResponse
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeOfferingOutput {
    /// Unique offering ARN, e.g. 'arn:aws:medialive:us-west-2:123456789012:offering:87654321'
    pub arn: std::option::Option<std::string::String>,
    /// Currency code for usagePrice and fixedPrice in ISO-4217 format, e.g. 'USD'
    pub currency_code: std::option::Option<std::string::String>,
    /// Lease duration, e.g. '12'
    pub duration: i32,
    /// Units for duration, e.g. 'MONTHS'
    pub duration_units: std::option::Option<crate::model::OfferingDurationUnits>,
    /// One-time charge for each reserved resource, e.g. '0.0' for a NO_UPFRONT offering
    pub fixed_price: f64,
    /// Offering description, e.g. 'HD AVC output at 10-20 Mbps, 30 fps, and standard VQ in US West (Oregon)'
    pub offering_description: std::option::Option<std::string::String>,
    /// Unique offering ID, e.g. '87654321'
    pub offering_id: std::option::Option<std::string::String>,
    /// Offering type, e.g. 'NO_UPFRONT'
    pub offering_type: std::option::Option<crate::model::OfferingType>,
    /// AWS region, e.g. 'us-west-2'
    pub region: std::option::Option<std::string::String>,
    /// Resource configuration details
    pub resource_specification: std::option::Option<crate::model::ReservationResourceSpecification>,
    /// Recurring usage charge for each reserved resource, e.g. '157.0'
    pub usage_price: f64,
}
impl DescribeOfferingOutput {
    /// Unique offering ARN, e.g. 'arn:aws:medialive:us-west-2:123456789012:offering:87654321'
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// Currency code for usagePrice and fixedPrice in ISO-4217 format, e.g. 'USD'
    pub fn currency_code(&self) -> std::option::Option<&str> {
        self.currency_code.as_deref()
    }
    /// Lease duration, e.g. '12'
    pub fn duration(&self) -> i32 {
        self.duration
    }
    /// Units for duration, e.g. 'MONTHS'
    pub fn duration_units(&self) -> std::option::Option<&crate::model::OfferingDurationUnits> {
        self.duration_units.as_ref()
    }
    /// One-time charge for each reserved resource, e.g. '0.0' for a NO_UPFRONT offering
    pub fn fixed_price(&self) -> f64 {
        self.fixed_price
    }
    /// Offering description, e.g. 'HD AVC output at 10-20 Mbps, 30 fps, and standard VQ in US West (Oregon)'
    pub fn offering_description(&self) -> std::option::Option<&str> {
        self.offering_description.as_deref()
    }
    /// Unique offering ID, e.g. '87654321'
    pub fn offering_id(&self) -> std::option::Option<&str> {
        self.offering_id.as_deref()
    }
    /// Offering type, e.g. 'NO_UPFRONT'
    pub fn offering_type(&self) -> std::option::Option<&crate::model::OfferingType> {
        self.offering_type.as_ref()
    }
    /// AWS region, e.g. 'us-west-2'
    pub fn region(&self) -> std::option::Option<&str> {
        self.region.as_deref()
    }
    /// Resource configuration details
    pub fn resource_specification(
        &self,
    ) -> std::option::Option<&crate::model::ReservationResourceSpecification> {
        self.resource_specification.as_ref()
    }
    /// Recurring usage charge for each reserved resource, e.g. '157.0'
    pub fn usage_price(&self) -> f64 {
        self.usage_price
    }
}
impl std::fmt::Debug for DescribeOfferingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeOfferingOutput");
        formatter.field("arn", &self.arn);
        formatter.field("currency_code", &self.currency_code);
        formatter.field("duration", &self.duration);
        formatter.field("duration_units", &self.duration_units);
        formatter.field("fixed_price", &self.fixed_price);
        formatter.field("offering_description", &self.offering_description);
        formatter.field("offering_id", &self.offering_id);
        formatter.field("offering_type", &self.offering_type);
        formatter.field("region", &self.region);
        formatter.field("resource_specification", &self.resource_specification);
        formatter.field("usage_price", &self.usage_price);
        formatter.finish()
    }
}
/// See [`DescribeOfferingOutput`](crate::output::DescribeOfferingOutput)
pub mod describe_offering_output {
    /// A builder for [`DescribeOfferingOutput`](crate::output::DescribeOfferingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) currency_code: std::option::Option<std::string::String>,
        pub(crate) duration: std::option::Option<i32>,
        pub(crate) duration_units: std::option::Option<crate::model::OfferingDurationUnits>,
        pub(crate) fixed_price: std::option::Option<f64>,
        pub(crate) offering_description: std::option::Option<std::string::String>,
        pub(crate) offering_id: std::option::Option<std::string::String>,
        pub(crate) offering_type: std::option::Option<crate::model::OfferingType>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) resource_specification:
            std::option::Option<crate::model::ReservationResourceSpecification>,
        pub(crate) usage_price: std::option::Option<f64>,
    }
    impl Builder {
        /// Unique offering ARN, e.g. 'arn:aws:medialive:us-west-2:123456789012:offering:87654321'
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// Unique offering ARN, e.g. 'arn:aws:medialive:us-west-2:123456789012:offering:87654321'
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Currency code for usagePrice and fixedPrice in ISO-4217 format, e.g. 'USD'
        pub fn currency_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.currency_code = Some(input.into());
            self
        }
        /// Currency code for usagePrice and fixedPrice in ISO-4217 format, e.g. 'USD'
        pub fn set_currency_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.currency_code = input;
            self
        }
        /// Lease duration, e.g. '12'
        pub fn duration(mut self, input: i32) -> Self {
            self.duration = Some(input);
            self
        }
        /// Lease duration, e.g. '12'
        pub fn set_duration(mut self, input: std::option::Option<i32>) -> Self {
            self.duration = input;
            self
        }
        /// Units for duration, e.g. 'MONTHS'
        pub fn duration_units(mut self, input: crate::model::OfferingDurationUnits) -> Self {
            self.duration_units = Some(input);
            self
        }
        /// Units for duration, e.g. 'MONTHS'
        pub fn set_duration_units(
            mut self,
            input: std::option::Option<crate::model::OfferingDurationUnits>,
        ) -> Self {
            self.duration_units = input;
            self
        }
        /// One-time charge for each reserved resource, e.g. '0.0' for a NO_UPFRONT offering
        pub fn fixed_price(mut self, input: f64) -> Self {
            self.fixed_price = Some(input);
            self
        }
        /// One-time charge for each reserved resource, e.g. '0.0' for a NO_UPFRONT offering
        pub fn set_fixed_price(mut self, input: std::option::Option<f64>) -> Self {
            self.fixed_price = input;
            self
        }
        /// Offering description, e.g. 'HD AVC output at 10-20 Mbps, 30 fps, and standard VQ in US West (Oregon)'
        pub fn offering_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.offering_description = Some(input.into());
            self
        }
        /// Offering description, e.g. 'HD AVC output at 10-20 Mbps, 30 fps, and standard VQ in US West (Oregon)'
        pub fn set_offering_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.offering_description = input;
            self
        }
        /// Unique offering ID, e.g. '87654321'
        pub fn offering_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.offering_id = Some(input.into());
            self
        }
        /// Unique offering ID, e.g. '87654321'
        pub fn set_offering_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.offering_id = input;
            self
        }
        /// Offering type, e.g. 'NO_UPFRONT'
        pub fn offering_type(mut self, input: crate::model::OfferingType) -> Self {
            self.offering_type = Some(input);
            self
        }
        /// Offering type, e.g. 'NO_UPFRONT'
        pub fn set_offering_type(
            mut self,
            input: std::option::Option<crate::model::OfferingType>,
        ) -> Self {
            self.offering_type = input;
            self
        }
        /// AWS region, e.g. 'us-west-2'
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// AWS region, e.g. 'us-west-2'
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// Resource configuration details
        pub fn resource_specification(
            mut self,
            input: crate::model::ReservationResourceSpecification,
        ) -> Self {
            self.resource_specification = Some(input);
            self
        }
        /// Resource configuration details
        pub fn set_resource_specification(
            mut self,
            input: std::option::Option<crate::model::ReservationResourceSpecification>,
        ) -> Self {
            self.resource_specification = input;
            self
        }
        /// Recurring usage charge for each reserved resource, e.g. '157.0'
        pub fn usage_price(mut self, input: f64) -> Self {
            self.usage_price = Some(input);
            self
        }
        /// Recurring usage charge for each reserved resource, e.g. '157.0'
        pub fn set_usage_price(mut self, input: std::option::Option<f64>) -> Self {
            self.usage_price = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeOfferingOutput`](crate::output::DescribeOfferingOutput)
        pub fn build(self) -> crate::output::DescribeOfferingOutput {
            crate::output::DescribeOfferingOutput {
                arn: self.arn,
                currency_code: self.currency_code,
                duration: self.duration.unwrap_or_default(),
                duration_units: self.duration_units,
                fixed_price: self.fixed_price.unwrap_or_default(),
                offering_description: self.offering_description,
                offering_id: self.offering_id,
                offering_type: self.offering_type,
                region: self.region,
                resource_specification: self.resource_specification,
                usage_price: self.usage_price.unwrap_or_default(),
            }
        }
    }
}
impl DescribeOfferingOutput {
    /// Creates a new builder-style object to manufacture [`DescribeOfferingOutput`](crate::output::DescribeOfferingOutput)
    pub fn builder() -> crate::output::describe_offering_output::Builder {
        crate::output::describe_offering_output::Builder::default()
    }
}

/// Placeholder documentation for DescribeMultiplexProgramResponse
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeMultiplexProgramOutput {
    /// The MediaLive channel associated with the program.
    pub channel_id: std::option::Option<std::string::String>,
    /// The settings for this multiplex program.
    pub multiplex_program_settings: std::option::Option<crate::model::MultiplexProgramSettings>,
    /// The packet identifier map for this multiplex program.
    pub packet_identifiers_map:
        std::option::Option<crate::model::MultiplexProgramPacketIdentifiersMap>,
    /// Contains information about the current sources for the specified program in the specified multiplex. Keep in mind that each multiplex pipeline connects to both pipelines in a given source channel (the channel identified by the program). But only one of those channel pipelines is ever active at one time.
    pub pipeline_details:
        std::option::Option<std::vec::Vec<crate::model::MultiplexProgramPipelineDetail>>,
    /// The name of the multiplex program.
    pub program_name: std::option::Option<std::string::String>,
}
impl DescribeMultiplexProgramOutput {
    /// The MediaLive channel associated with the program.
    pub fn channel_id(&self) -> std::option::Option<&str> {
        self.channel_id.as_deref()
    }
    /// The settings for this multiplex program.
    pub fn multiplex_program_settings(
        &self,
    ) -> std::option::Option<&crate::model::MultiplexProgramSettings> {
        self.multiplex_program_settings.as_ref()
    }
    /// The packet identifier map for this multiplex program.
    pub fn packet_identifiers_map(
        &self,
    ) -> std::option::Option<&crate::model::MultiplexProgramPacketIdentifiersMap> {
        self.packet_identifiers_map.as_ref()
    }
    /// Contains information about the current sources for the specified program in the specified multiplex. Keep in mind that each multiplex pipeline connects to both pipelines in a given source channel (the channel identified by the program). But only one of those channel pipelines is ever active at one time.
    pub fn pipeline_details(
        &self,
    ) -> std::option::Option<&[crate::model::MultiplexProgramPipelineDetail]> {
        self.pipeline_details.as_deref()
    }
    /// The name of the multiplex program.
    pub fn program_name(&self) -> std::option::Option<&str> {
        self.program_name.as_deref()
    }
}
impl std::fmt::Debug for DescribeMultiplexProgramOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeMultiplexProgramOutput");
        formatter.field("channel_id", &self.channel_id);
        formatter.field(
            "multiplex_program_settings",
            &self.multiplex_program_settings,
        );
        formatter.field("packet_identifiers_map", &self.packet_identifiers_map);
        formatter.field("pipeline_details", &self.pipeline_details);
        formatter.field("program_name", &self.program_name);
        formatter.finish()
    }
}
/// See [`DescribeMultiplexProgramOutput`](crate::output::DescribeMultiplexProgramOutput)
pub mod describe_multiplex_program_output {
    /// A builder for [`DescribeMultiplexProgramOutput`](crate::output::DescribeMultiplexProgramOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_id: std::option::Option<std::string::String>,
        pub(crate) multiplex_program_settings:
            std::option::Option<crate::model::MultiplexProgramSettings>,
        pub(crate) packet_identifiers_map:
            std::option::Option<crate::model::MultiplexProgramPacketIdentifiersMap>,
        pub(crate) pipeline_details:
            std::option::Option<std::vec::Vec<crate::model::MultiplexProgramPipelineDetail>>,
        pub(crate) program_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The MediaLive channel associated with the program.
        pub fn channel_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_id = Some(input.into());
            self
        }
        /// The MediaLive channel associated with the program.
        pub fn set_channel_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_id = input;
            self
        }
        /// The settings for this multiplex program.
        pub fn multiplex_program_settings(
            mut self,
            input: crate::model::MultiplexProgramSettings,
        ) -> Self {
            self.multiplex_program_settings = Some(input);
            self
        }
        /// The settings for this multiplex program.
        pub fn set_multiplex_program_settings(
            mut self,
            input: std::option::Option<crate::model::MultiplexProgramSettings>,
        ) -> Self {
            self.multiplex_program_settings = input;
            self
        }
        /// The packet identifier map for this multiplex program.
        pub fn packet_identifiers_map(
            mut self,
            input: crate::model::MultiplexProgramPacketIdentifiersMap,
        ) -> Self {
            self.packet_identifiers_map = Some(input);
            self
        }
        /// The packet identifier map for this multiplex program.
        pub fn set_packet_identifiers_map(
            mut self,
            input: std::option::Option<crate::model::MultiplexProgramPacketIdentifiersMap>,
        ) -> Self {
            self.packet_identifiers_map = input;
            self
        }
        /// Appends an item to `pipeline_details`.
        ///
        /// To override the contents of this collection use [`set_pipeline_details`](Self::set_pipeline_details).
        ///
        /// Contains information about the current sources for the specified program in the specified multiplex. Keep in mind that each multiplex pipeline connects to both pipelines in a given source channel (the channel identified by the program). But only one of those channel pipelines is ever active at one time.
        pub fn pipeline_details(
            mut self,
            input: impl Into<crate::model::MultiplexProgramPipelineDetail>,
        ) -> Self {
            let mut v = self.pipeline_details.unwrap_or_default();
            v.push(input.into());
            self.pipeline_details = Some(v);
            self
        }
        /// Contains information about the current sources for the specified program in the specified multiplex. Keep in mind that each multiplex pipeline connects to both pipelines in a given source channel (the channel identified by the program). But only one of those channel pipelines is ever active at one time.
        pub fn set_pipeline_details(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MultiplexProgramPipelineDetail>>,
        ) -> Self {
            self.pipeline_details = input;
            self
        }
        /// The name of the multiplex program.
        pub fn program_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.program_name = Some(input.into());
            self
        }
        /// The name of the multiplex program.
        pub fn set_program_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.program_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeMultiplexProgramOutput`](crate::output::DescribeMultiplexProgramOutput)
        pub fn build(self) -> crate::output::DescribeMultiplexProgramOutput {
            crate::output::DescribeMultiplexProgramOutput {
                channel_id: self.channel_id,
                multiplex_program_settings: self.multiplex_program_settings,
                packet_identifiers_map: self.packet_identifiers_map,
                pipeline_details: self.pipeline_details,
                program_name: self.program_name,
            }
        }
    }
}
impl DescribeMultiplexProgramOutput {
    /// Creates a new builder-style object to manufacture [`DescribeMultiplexProgramOutput`](crate::output::DescribeMultiplexProgramOutput)
    pub fn builder() -> crate::output::describe_multiplex_program_output::Builder {
        crate::output::describe_multiplex_program_output::Builder::default()
    }
}

/// Placeholder documentation for DescribeMultiplexResponse
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeMultiplexOutput {
    /// The unique arn of the multiplex.
    pub arn: std::option::Option<std::string::String>,
    /// A list of availability zones for the multiplex.
    pub availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
    /// A list of the multiplex output destinations.
    pub destinations: std::option::Option<std::vec::Vec<crate::model::MultiplexOutputDestination>>,
    /// The unique id of the multiplex.
    pub id: std::option::Option<std::string::String>,
    /// Configuration for a multiplex event.
    pub multiplex_settings: std::option::Option<crate::model::MultiplexSettings>,
    /// The name of the multiplex.
    pub name: std::option::Option<std::string::String>,
    /// The number of currently healthy pipelines.
    pub pipelines_running_count: i32,
    /// The number of programs in the multiplex.
    pub program_count: i32,
    /// The current state of the multiplex.
    pub state: std::option::Option<crate::model::MultiplexState>,
    /// A collection of key-value pairs.
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl DescribeMultiplexOutput {
    /// The unique arn of the multiplex.
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// A list of availability zones for the multiplex.
    pub fn availability_zones(&self) -> std::option::Option<&[std::string::String]> {
        self.availability_zones.as_deref()
    }
    /// A list of the multiplex output destinations.
    pub fn destinations(&self) -> std::option::Option<&[crate::model::MultiplexOutputDestination]> {
        self.destinations.as_deref()
    }
    /// The unique id of the multiplex.
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// Configuration for a multiplex event.
    pub fn multiplex_settings(&self) -> std::option::Option<&crate::model::MultiplexSettings> {
        self.multiplex_settings.as_ref()
    }
    /// The name of the multiplex.
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// The number of currently healthy pipelines.
    pub fn pipelines_running_count(&self) -> i32 {
        self.pipelines_running_count
    }
    /// The number of programs in the multiplex.
    pub fn program_count(&self) -> i32 {
        self.program_count
    }
    /// The current state of the multiplex.
    pub fn state(&self) -> std::option::Option<&crate::model::MultiplexState> {
        self.state.as_ref()
    }
    /// A collection of key-value pairs.
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for DescribeMultiplexOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeMultiplexOutput");
        formatter.field("arn", &self.arn);
        formatter.field("availability_zones", &self.availability_zones);
        formatter.field("destinations", &self.destinations);
        formatter.field("id", &self.id);
        formatter.field("multiplex_settings", &self.multiplex_settings);
        formatter.field("name", &self.name);
        formatter.field("pipelines_running_count", &self.pipelines_running_count);
        formatter.field("program_count", &self.program_count);
        formatter.field("state", &self.state);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`DescribeMultiplexOutput`](crate::output::DescribeMultiplexOutput)
pub mod describe_multiplex_output {
    /// A builder for [`DescribeMultiplexOutput`](crate::output::DescribeMultiplexOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) destinations:
            std::option::Option<std::vec::Vec<crate::model::MultiplexOutputDestination>>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) multiplex_settings: std::option::Option<crate::model::MultiplexSettings>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) pipelines_running_count: std::option::Option<i32>,
        pub(crate) program_count: std::option::Option<i32>,
        pub(crate) state: std::option::Option<crate::model::MultiplexState>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// The unique arn of the multiplex.
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// The unique arn of the multiplex.
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Appends an item to `availability_zones`.
        ///
        /// To override the contents of this collection use [`set_availability_zones`](Self::set_availability_zones).
        ///
        /// A list of availability zones for the multiplex.
        pub fn availability_zones(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.availability_zones.unwrap_or_default();
            v.push(input.into());
            self.availability_zones = Some(v);
            self
        }
        /// A list of availability zones for the multiplex.
        pub fn set_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.availability_zones = input;
            self
        }
        /// Appends an item to `destinations`.
        ///
        /// To override the contents of this collection use [`set_destinations`](Self::set_destinations).
        ///
        /// A list of the multiplex output destinations.
        pub fn destinations(
            mut self,
            input: impl Into<crate::model::MultiplexOutputDestination>,
        ) -> Self {
            let mut v = self.destinations.unwrap_or_default();
            v.push(input.into());
            self.destinations = Some(v);
            self
        }
        /// A list of the multiplex output destinations.
        pub fn set_destinations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MultiplexOutputDestination>>,
        ) -> Self {
            self.destinations = input;
            self
        }
        /// The unique id of the multiplex.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// The unique id of the multiplex.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Configuration for a multiplex event.
        pub fn multiplex_settings(mut self, input: crate::model::MultiplexSettings) -> Self {
            self.multiplex_settings = Some(input);
            self
        }
        /// Configuration for a multiplex event.
        pub fn set_multiplex_settings(
            mut self,
            input: std::option::Option<crate::model::MultiplexSettings>,
        ) -> Self {
            self.multiplex_settings = input;
            self
        }
        /// The name of the multiplex.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// The name of the multiplex.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// The number of currently healthy pipelines.
        pub fn pipelines_running_count(mut self, input: i32) -> Self {
            self.pipelines_running_count = Some(input);
            self
        }
        /// The number of currently healthy pipelines.
        pub fn set_pipelines_running_count(mut self, input: std::option::Option<i32>) -> Self {
            self.pipelines_running_count = input;
            self
        }
        /// The number of programs in the multiplex.
        pub fn program_count(mut self, input: i32) -> Self {
            self.program_count = Some(input);
            self
        }
        /// The number of programs in the multiplex.
        pub fn set_program_count(mut self, input: std::option::Option<i32>) -> Self {
            self.program_count = input;
            self
        }
        /// The current state of the multiplex.
        pub fn state(mut self, input: crate::model::MultiplexState) -> Self {
            self.state = Some(input);
            self
        }
        /// The current state of the multiplex.
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::MultiplexState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of key-value pairs.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// A collection of key-value pairs.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeMultiplexOutput`](crate::output::DescribeMultiplexOutput)
        pub fn build(self) -> crate::output::DescribeMultiplexOutput {
            crate::output::DescribeMultiplexOutput {
                arn: self.arn,
                availability_zones: self.availability_zones,
                destinations: self.destinations,
                id: self.id,
                multiplex_settings: self.multiplex_settings,
                name: self.name,
                pipelines_running_count: self.pipelines_running_count.unwrap_or_default(),
                program_count: self.program_count.unwrap_or_default(),
                state: self.state,
                tags: self.tags,
            }
        }
    }
}
impl DescribeMultiplexOutput {
    /// Creates a new builder-style object to manufacture [`DescribeMultiplexOutput`](crate::output::DescribeMultiplexOutput)
    pub fn builder() -> crate::output::describe_multiplex_output::Builder {
        crate::output::describe_multiplex_output::Builder::default()
    }
}

/// Placeholder documentation for DescribeInputSecurityGroupResponse
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeInputSecurityGroupOutput {
    /// Unique ARN of Input Security Group
    pub arn: std::option::Option<std::string::String>,
    /// The Id of the Input Security Group
    pub id: std::option::Option<std::string::String>,
    /// The list of inputs currently using this Input Security Group.
    pub inputs: std::option::Option<std::vec::Vec<std::string::String>>,
    /// The current state of the Input Security Group.
    pub state: std::option::Option<crate::model::InputSecurityGroupState>,
    /// A collection of key-value pairs.
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// Whitelist rules and their sync status
    pub whitelist_rules: std::option::Option<std::vec::Vec<crate::model::InputWhitelistRule>>,
}
impl DescribeInputSecurityGroupOutput {
    /// Unique ARN of Input Security Group
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// The Id of the Input Security Group
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// The list of inputs currently using this Input Security Group.
    pub fn inputs(&self) -> std::option::Option<&[std::string::String]> {
        self.inputs.as_deref()
    }
    /// The current state of the Input Security Group.
    pub fn state(&self) -> std::option::Option<&crate::model::InputSecurityGroupState> {
        self.state.as_ref()
    }
    /// A collection of key-value pairs.
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// Whitelist rules and their sync status
    pub fn whitelist_rules(&self) -> std::option::Option<&[crate::model::InputWhitelistRule]> {
        self.whitelist_rules.as_deref()
    }
}
impl std::fmt::Debug for DescribeInputSecurityGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeInputSecurityGroupOutput");
        formatter.field("arn", &self.arn);
        formatter.field("id", &self.id);
        formatter.field("inputs", &self.inputs);
        formatter.field("state", &self.state);
        formatter.field("tags", &self.tags);
        formatter.field("whitelist_rules", &self.whitelist_rules);
        formatter.finish()
    }
}
/// See [`DescribeInputSecurityGroupOutput`](crate::output::DescribeInputSecurityGroupOutput)
pub mod describe_input_security_group_output {
    /// A builder for [`DescribeInputSecurityGroupOutput`](crate::output::DescribeInputSecurityGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) inputs: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) state: std::option::Option<crate::model::InputSecurityGroupState>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) whitelist_rules:
            std::option::Option<std::vec::Vec<crate::model::InputWhitelistRule>>,
    }
    impl Builder {
        /// Unique ARN of Input Security Group
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// Unique ARN of Input Security Group
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// The Id of the Input Security Group
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// The Id of the Input Security Group
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Appends an item to `inputs`.
        ///
        /// To override the contents of this collection use [`set_inputs`](Self::set_inputs).
        ///
        /// The list of inputs currently using this Input Security Group.
        pub fn inputs(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.inputs.unwrap_or_default();
            v.push(input.into());
            self.inputs = Some(v);
            self
        }
        /// The list of inputs currently using this Input Security Group.
        pub fn set_inputs(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inputs = input;
            self
        }
        /// The current state of the Input Security Group.
        pub fn state(mut self, input: crate::model::InputSecurityGroupState) -> Self {
            self.state = Some(input);
            self
        }
        /// The current state of the Input Security Group.
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::InputSecurityGroupState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of key-value pairs.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// A collection of key-value pairs.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Appends an item to `whitelist_rules`.
        ///
        /// To override the contents of this collection use [`set_whitelist_rules`](Self::set_whitelist_rules).
        ///
        /// Whitelist rules and their sync status
        pub fn whitelist_rules(
            mut self,
            input: impl Into<crate::model::InputWhitelistRule>,
        ) -> Self {
            let mut v = self.whitelist_rules.unwrap_or_default();
            v.push(input.into());
            self.whitelist_rules = Some(v);
            self
        }
        /// Whitelist rules and their sync status
        pub fn set_whitelist_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InputWhitelistRule>>,
        ) -> Self {
            self.whitelist_rules = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeInputSecurityGroupOutput`](crate::output::DescribeInputSecurityGroupOutput)
        pub fn build(self) -> crate::output::DescribeInputSecurityGroupOutput {
            crate::output::DescribeInputSecurityGroupOutput {
                arn: self.arn,
                id: self.id,
                inputs: self.inputs,
                state: self.state,
                tags: self.tags,
                whitelist_rules: self.whitelist_rules,
            }
        }
    }
}
impl DescribeInputSecurityGroupOutput {
    /// Creates a new builder-style object to manufacture [`DescribeInputSecurityGroupOutput`](crate::output::DescribeInputSecurityGroupOutput)
    pub fn builder() -> crate::output::describe_input_security_group_output::Builder {
        crate::output::describe_input_security_group_output::Builder::default()
    }
}

/// Placeholder documentation for DescribeInputDeviceThumbnailResponse
#[non_exhaustive]
pub struct DescribeInputDeviceThumbnailOutput {
    /// The binary data for the thumbnail that the Link device has most recently sent to MediaLive.
    pub body: aws_smithy_http::byte_stream::ByteStream,
    /// Specifies the media type of the thumbnail.
    pub content_type: std::option::Option<crate::model::ContentType>,
    /// The length of the content.
    pub content_length: i64,
    /// The unique, cacheable version of this thumbnail.
    pub e_tag: std::option::Option<std::string::String>,
    /// The date and time the thumbnail was last updated at the device.
    pub last_modified: std::option::Option<aws_smithy_types::DateTime>,
}
impl DescribeInputDeviceThumbnailOutput {
    /// The binary data for the thumbnail that the Link device has most recently sent to MediaLive.
    pub fn body(&self) -> &aws_smithy_http::byte_stream::ByteStream {
        &self.body
    }
    /// Specifies the media type of the thumbnail.
    pub fn content_type(&self) -> std::option::Option<&crate::model::ContentType> {
        self.content_type.as_ref()
    }
    /// The length of the content.
    pub fn content_length(&self) -> i64 {
        self.content_length
    }
    /// The unique, cacheable version of this thumbnail.
    pub fn e_tag(&self) -> std::option::Option<&str> {
        self.e_tag.as_deref()
    }
    /// The date and time the thumbnail was last updated at the device.
    pub fn last_modified(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified.as_ref()
    }
}
impl std::fmt::Debug for DescribeInputDeviceThumbnailOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeInputDeviceThumbnailOutput");
        formatter.field("body", &self.body);
        formatter.field("content_type", &self.content_type);
        formatter.field("content_length", &self.content_length);
        formatter.field("e_tag", &self.e_tag);
        formatter.field("last_modified", &self.last_modified);
        formatter.finish()
    }
}
/// See [`DescribeInputDeviceThumbnailOutput`](crate::output::DescribeInputDeviceThumbnailOutput)
pub mod describe_input_device_thumbnail_output {
    /// A builder for [`DescribeInputDeviceThumbnailOutput`](crate::output::DescribeInputDeviceThumbnailOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) body: std::option::Option<aws_smithy_http::byte_stream::ByteStream>,
        pub(crate) content_type: std::option::Option<crate::model::ContentType>,
        pub(crate) content_length: std::option::Option<i64>,
        pub(crate) e_tag: std::option::Option<std::string::String>,
        pub(crate) last_modified: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// The binary data for the thumbnail that the Link device has most recently sent to MediaLive.
        pub fn body(mut self, input: aws_smithy_http::byte_stream::ByteStream) -> Self {
            self.body = Some(input);
            self
        }
        /// The binary data for the thumbnail that the Link device has most recently sent to MediaLive.
        pub fn set_body(
            mut self,
            input: std::option::Option<aws_smithy_http::byte_stream::ByteStream>,
        ) -> Self {
            self.body = input;
            self
        }
        /// Specifies the media type of the thumbnail.
        pub fn content_type(mut self, input: crate::model::ContentType) -> Self {
            self.content_type = Some(input);
            self
        }
        /// Specifies the media type of the thumbnail.
        pub fn set_content_type(
            mut self,
            input: std::option::Option<crate::model::ContentType>,
        ) -> Self {
            self.content_type = input;
            self
        }
        /// The length of the content.
        pub fn content_length(mut self, input: i64) -> Self {
            self.content_length = Some(input);
            self
        }
        /// The length of the content.
        pub fn set_content_length(mut self, input: std::option::Option<i64>) -> Self {
            self.content_length = input;
            self
        }
        /// The unique, cacheable version of this thumbnail.
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// The unique, cacheable version of this thumbnail.
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// The date and time the thumbnail was last updated at the device.
        pub fn last_modified(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified = Some(input);
            self
        }
        /// The date and time the thumbnail was last updated at the device.
        pub fn set_last_modified(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeInputDeviceThumbnailOutput`](crate::output::DescribeInputDeviceThumbnailOutput)
        pub fn build(self) -> crate::output::DescribeInputDeviceThumbnailOutput {
            crate::output::DescribeInputDeviceThumbnailOutput {
                body: self.body.unwrap_or_default(),
                content_type: self.content_type,
                content_length: self.content_length.unwrap_or_default(),
                e_tag: self.e_tag,
                last_modified: self.last_modified,
            }
        }
    }
}
impl DescribeInputDeviceThumbnailOutput {
    /// Creates a new builder-style object to manufacture [`DescribeInputDeviceThumbnailOutput`](crate::output::DescribeInputDeviceThumbnailOutput)
    pub fn builder() -> crate::output::describe_input_device_thumbnail_output::Builder {
        crate::output::describe_input_device_thumbnail_output::Builder::default()
    }
}

/// Placeholder documentation for DescribeInputDeviceResponse
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeInputDeviceOutput {
    /// The unique ARN of the input device.
    pub arn: std::option::Option<std::string::String>,
    /// The state of the connection between the input device and AWS.
    pub connection_state: std::option::Option<crate::model::InputDeviceConnectionState>,
    /// The status of the action to synchronize the device configuration. If you change the configuration of the input device (for example, the maximum bitrate), MediaLive sends the new data to the device. The device might not update itself immediately. SYNCED means the device has updated its configuration. SYNCING means that it has not updated its configuration.
    pub device_settings_sync_state: std::option::Option<crate::model::DeviceSettingsSyncState>,
    /// The status of software on the input device.
    pub device_update_status: std::option::Option<crate::model::DeviceUpdateStatus>,
    /// Settings that describe an input device that is type HD.
    pub hd_device_settings: std::option::Option<crate::model::InputDeviceHdSettings>,
    /// The unique ID of the input device.
    pub id: std::option::Option<std::string::String>,
    /// The network MAC address of the input device.
    pub mac_address: std::option::Option<std::string::String>,
    /// A name that you specify for the input device.
    pub name: std::option::Option<std::string::String>,
    /// The network settings for the input device.
    pub network_settings: std::option::Option<crate::model::InputDeviceNetworkSettings>,
    /// The unique serial number of the input device.
    pub serial_number: std::option::Option<std::string::String>,
    /// The type of the input device.
    pub r#type: std::option::Option<crate::model::InputDeviceType>,
    /// Settings that describe an input device that is type UHD.
    pub uhd_device_settings: std::option::Option<crate::model::InputDeviceUhdSettings>,
}
impl DescribeInputDeviceOutput {
    /// The unique ARN of the input device.
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// The state of the connection between the input device and AWS.
    pub fn connection_state(
        &self,
    ) -> std::option::Option<&crate::model::InputDeviceConnectionState> {
        self.connection_state.as_ref()
    }
    /// The status of the action to synchronize the device configuration. If you change the configuration of the input device (for example, the maximum bitrate), MediaLive sends the new data to the device. The device might not update itself immediately. SYNCED means the device has updated its configuration. SYNCING means that it has not updated its configuration.
    pub fn device_settings_sync_state(
        &self,
    ) -> std::option::Option<&crate::model::DeviceSettingsSyncState> {
        self.device_settings_sync_state.as_ref()
    }
    /// The status of software on the input device.
    pub fn device_update_status(&self) -> std::option::Option<&crate::model::DeviceUpdateStatus> {
        self.device_update_status.as_ref()
    }
    /// Settings that describe an input device that is type HD.
    pub fn hd_device_settings(&self) -> std::option::Option<&crate::model::InputDeviceHdSettings> {
        self.hd_device_settings.as_ref()
    }
    /// The unique ID of the input device.
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// The network MAC address of the input device.
    pub fn mac_address(&self) -> std::option::Option<&str> {
        self.mac_address.as_deref()
    }
    /// A name that you specify for the input device.
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// The network settings for the input device.
    pub fn network_settings(
        &self,
    ) -> std::option::Option<&crate::model::InputDeviceNetworkSettings> {
        self.network_settings.as_ref()
    }
    /// The unique serial number of the input device.
    pub fn serial_number(&self) -> std::option::Option<&str> {
        self.serial_number.as_deref()
    }
    /// The type of the input device.
    pub fn r#type(&self) -> std::option::Option<&crate::model::InputDeviceType> {
        self.r#type.as_ref()
    }
    /// Settings that describe an input device that is type UHD.
    pub fn uhd_device_settings(
        &self,
    ) -> std::option::Option<&crate::model::InputDeviceUhdSettings> {
        self.uhd_device_settings.as_ref()
    }
}
impl std::fmt::Debug for DescribeInputDeviceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeInputDeviceOutput");
        formatter.field("arn", &self.arn);
        formatter.field("connection_state", &self.connection_state);
        formatter.field(
            "device_settings_sync_state",
            &self.device_settings_sync_state,
        );
        formatter.field("device_update_status", &self.device_update_status);
        formatter.field("hd_device_settings", &self.hd_device_settings);
        formatter.field("id", &self.id);
        formatter.field("mac_address", &self.mac_address);
        formatter.field("name", &self.name);
        formatter.field("network_settings", &self.network_settings);
        formatter.field("serial_number", &self.serial_number);
        formatter.field("r#type", &self.r#type);
        formatter.field("uhd_device_settings", &self.uhd_device_settings);
        formatter.finish()
    }
}
/// See [`DescribeInputDeviceOutput`](crate::output::DescribeInputDeviceOutput)
pub mod describe_input_device_output {
    /// A builder for [`DescribeInputDeviceOutput`](crate::output::DescribeInputDeviceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) connection_state: std::option::Option<crate::model::InputDeviceConnectionState>,
        pub(crate) device_settings_sync_state:
            std::option::Option<crate::model::DeviceSettingsSyncState>,
        pub(crate) device_update_status: std::option::Option<crate::model::DeviceUpdateStatus>,
        pub(crate) hd_device_settings: std::option::Option<crate::model::InputDeviceHdSettings>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) mac_address: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) network_settings: std::option::Option<crate::model::InputDeviceNetworkSettings>,
        pub(crate) serial_number: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::InputDeviceType>,
        pub(crate) uhd_device_settings: std::option::Option<crate::model::InputDeviceUhdSettings>,
    }
    impl Builder {
        /// The unique ARN of the input device.
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// The unique ARN of the input device.
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// The state of the connection between the input device and AWS.
        pub fn connection_state(mut self, input: crate::model::InputDeviceConnectionState) -> Self {
            self.connection_state = Some(input);
            self
        }
        /// The state of the connection between the input device and AWS.
        pub fn set_connection_state(
            mut self,
            input: std::option::Option<crate::model::InputDeviceConnectionState>,
        ) -> Self {
            self.connection_state = input;
            self
        }
        /// The status of the action to synchronize the device configuration. If you change the configuration of the input device (for example, the maximum bitrate), MediaLive sends the new data to the device. The device might not update itself immediately. SYNCED means the device has updated its configuration. SYNCING means that it has not updated its configuration.
        pub fn device_settings_sync_state(
            mut self,
            input: crate::model::DeviceSettingsSyncState,
        ) -> Self {
            self.device_settings_sync_state = Some(input);
            self
        }
        /// The status of the action to synchronize the device configuration. If you change the configuration of the input device (for example, the maximum bitrate), MediaLive sends the new data to the device. The device might not update itself immediately. SYNCED means the device has updated its configuration. SYNCING means that it has not updated its configuration.
        pub fn set_device_settings_sync_state(
            mut self,
            input: std::option::Option<crate::model::DeviceSettingsSyncState>,
        ) -> Self {
            self.device_settings_sync_state = input;
            self
        }
        /// The status of software on the input device.
        pub fn device_update_status(mut self, input: crate::model::DeviceUpdateStatus) -> Self {
            self.device_update_status = Some(input);
            self
        }
        /// The status of software on the input device.
        pub fn set_device_update_status(
            mut self,
            input: std::option::Option<crate::model::DeviceUpdateStatus>,
        ) -> Self {
            self.device_update_status = input;
            self
        }
        /// Settings that describe an input device that is type HD.
        pub fn hd_device_settings(mut self, input: crate::model::InputDeviceHdSettings) -> Self {
            self.hd_device_settings = Some(input);
            self
        }
        /// Settings that describe an input device that is type HD.
        pub fn set_hd_device_settings(
            mut self,
            input: std::option::Option<crate::model::InputDeviceHdSettings>,
        ) -> Self {
            self.hd_device_settings = input;
            self
        }
        /// The unique ID of the input device.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// The unique ID of the input device.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// The network MAC address of the input device.
        pub fn mac_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.mac_address = Some(input.into());
            self
        }
        /// The network MAC address of the input device.
        pub fn set_mac_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mac_address = input;
            self
        }
        /// A name that you specify for the input device.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// A name that you specify for the input device.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// The network settings for the input device.
        pub fn network_settings(mut self, input: crate::model::InputDeviceNetworkSettings) -> Self {
            self.network_settings = Some(input);
            self
        }
        /// The network settings for the input device.
        pub fn set_network_settings(
            mut self,
            input: std::option::Option<crate::model::InputDeviceNetworkSettings>,
        ) -> Self {
            self.network_settings = input;
            self
        }
        /// The unique serial number of the input device.
        pub fn serial_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.serial_number = Some(input.into());
            self
        }
        /// The unique serial number of the input device.
        pub fn set_serial_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.serial_number = input;
            self
        }
        /// The type of the input device.
        pub fn r#type(mut self, input: crate::model::InputDeviceType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// The type of the input device.
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::InputDeviceType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// Settings that describe an input device that is type UHD.
        pub fn uhd_device_settings(mut self, input: crate::model::InputDeviceUhdSettings) -> Self {
            self.uhd_device_settings = Some(input);
            self
        }
        /// Settings that describe an input device that is type UHD.
        pub fn set_uhd_device_settings(
            mut self,
            input: std::option::Option<crate::model::InputDeviceUhdSettings>,
        ) -> Self {
            self.uhd_device_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeInputDeviceOutput`](crate::output::DescribeInputDeviceOutput)
        pub fn build(self) -> crate::output::DescribeInputDeviceOutput {
            crate::output::DescribeInputDeviceOutput {
                arn: self.arn,
                connection_state: self.connection_state,
                device_settings_sync_state: self.device_settings_sync_state,
                device_update_status: self.device_update_status,
                hd_device_settings: self.hd_device_settings,
                id: self.id,
                mac_address: self.mac_address,
                name: self.name,
                network_settings: self.network_settings,
                serial_number: self.serial_number,
                r#type: self.r#type,
                uhd_device_settings: self.uhd_device_settings,
            }
        }
    }
}
impl DescribeInputDeviceOutput {
    /// Creates a new builder-style object to manufacture [`DescribeInputDeviceOutput`](crate::output::DescribeInputDeviceOutput)
    pub fn builder() -> crate::output::describe_input_device_output::Builder {
        crate::output::describe_input_device_output::Builder::default()
    }
}

/// Placeholder documentation for DescribeInputResponse
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeInputOutput {
    /// The Unique ARN of the input (generated, immutable).
    pub arn: std::option::Option<std::string::String>,
    /// A list of channel IDs that that input is attached to (currently an input can only be attached to one channel).
    pub attached_channels: std::option::Option<std::vec::Vec<std::string::String>>,
    /// A list of the destinations of the input (PUSH-type).
    pub destinations: std::option::Option<std::vec::Vec<crate::model::InputDestination>>,
    /// The generated ID of the input (unique for user account, immutable).
    pub id: std::option::Option<std::string::String>,
    /// STANDARD - MediaLive expects two sources to be connected to this input. If the channel is also STANDARD, both sources will be ingested. If the channel is SINGLE_PIPELINE, only the first source will be ingested; the second source will always be ignored, even if the first source fails.
    /// SINGLE_PIPELINE - You can connect only one source to this input. If the ChannelClass is also  SINGLE_PIPELINE, this value is valid. If the ChannelClass is STANDARD, this value is not valid because the channel requires two sources in the input.
    pub input_class: std::option::Option<crate::model::InputClass>,
    /// Settings for the input devices.
    pub input_devices: std::option::Option<std::vec::Vec<crate::model::InputDeviceSettings>>,
    /// A list of IDs for all Inputs which are partners of this one.
    pub input_partner_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// Certain pull input sources can be dynamic, meaning that they can have their URL's dynamically changes
    /// during input switch actions. Presently, this functionality only works with MP4_FILE and TS_FILE inputs.
    pub input_source_type: std::option::Option<crate::model::InputSourceType>,
    /// A list of MediaConnect Flows for this input.
    pub media_connect_flows: std::option::Option<std::vec::Vec<crate::model::MediaConnectFlow>>,
    /// The user-assigned name (This is a mutable value).
    pub name: std::option::Option<std::string::String>,
    /// The Amazon Resource Name (ARN) of the role this input assumes during and after creation.
    pub role_arn: std::option::Option<std::string::String>,
    /// A list of IDs for all the Input Security Groups attached to the input.
    pub security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
    /// A list of the sources of the input (PULL-type).
    pub sources: std::option::Option<std::vec::Vec<crate::model::InputSource>>,
    /// Placeholder documentation for InputState
    pub state: std::option::Option<crate::model::InputState>,
    /// A collection of key-value pairs.
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// The different types of inputs that AWS Elemental MediaLive supports.
    pub r#type: std::option::Option<crate::model::InputType>,
}
impl DescribeInputOutput {
    /// The Unique ARN of the input (generated, immutable).
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// A list of channel IDs that that input is attached to (currently an input can only be attached to one channel).
    pub fn attached_channels(&self) -> std::option::Option<&[std::string::String]> {
        self.attached_channels.as_deref()
    }
    /// A list of the destinations of the input (PUSH-type).
    pub fn destinations(&self) -> std::option::Option<&[crate::model::InputDestination]> {
        self.destinations.as_deref()
    }
    /// The generated ID of the input (unique for user account, immutable).
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// STANDARD - MediaLive expects two sources to be connected to this input. If the channel is also STANDARD, both sources will be ingested. If the channel is SINGLE_PIPELINE, only the first source will be ingested; the second source will always be ignored, even if the first source fails.
    /// SINGLE_PIPELINE - You can connect only one source to this input. If the ChannelClass is also  SINGLE_PIPELINE, this value is valid. If the ChannelClass is STANDARD, this value is not valid because the channel requires two sources in the input.
    pub fn input_class(&self) -> std::option::Option<&crate::model::InputClass> {
        self.input_class.as_ref()
    }
    /// Settings for the input devices.
    pub fn input_devices(&self) -> std::option::Option<&[crate::model::InputDeviceSettings]> {
        self.input_devices.as_deref()
    }
    /// A list of IDs for all Inputs which are partners of this one.
    pub fn input_partner_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.input_partner_ids.as_deref()
    }
    /// Certain pull input sources can be dynamic, meaning that they can have their URL's dynamically changes
    /// during input switch actions. Presently, this functionality only works with MP4_FILE and TS_FILE inputs.
    pub fn input_source_type(&self) -> std::option::Option<&crate::model::InputSourceType> {
        self.input_source_type.as_ref()
    }
    /// A list of MediaConnect Flows for this input.
    pub fn media_connect_flows(&self) -> std::option::Option<&[crate::model::MediaConnectFlow]> {
        self.media_connect_flows.as_deref()
    }
    /// The user-assigned name (This is a mutable value).
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// The Amazon Resource Name (ARN) of the role this input assumes during and after creation.
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// A list of IDs for all the Input Security Groups attached to the input.
    pub fn security_groups(&self) -> std::option::Option<&[std::string::String]> {
        self.security_groups.as_deref()
    }
    /// A list of the sources of the input (PULL-type).
    pub fn sources(&self) -> std::option::Option<&[crate::model::InputSource]> {
        self.sources.as_deref()
    }
    /// Placeholder documentation for InputState
    pub fn state(&self) -> std::option::Option<&crate::model::InputState> {
        self.state.as_ref()
    }
    /// A collection of key-value pairs.
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// The different types of inputs that AWS Elemental MediaLive supports.
    pub fn r#type(&self) -> std::option::Option<&crate::model::InputType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for DescribeInputOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeInputOutput");
        formatter.field("arn", &self.arn);
        formatter.field("attached_channels", &self.attached_channels);
        formatter.field("destinations", &self.destinations);
        formatter.field("id", &self.id);
        formatter.field("input_class", &self.input_class);
        formatter.field("input_devices", &self.input_devices);
        formatter.field("input_partner_ids", &self.input_partner_ids);
        formatter.field("input_source_type", &self.input_source_type);
        formatter.field("media_connect_flows", &self.media_connect_flows);
        formatter.field("name", &self.name);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("security_groups", &self.security_groups);
        formatter.field("sources", &self.sources);
        formatter.field("state", &self.state);
        formatter.field("tags", &self.tags);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`DescribeInputOutput`](crate::output::DescribeInputOutput)
pub mod describe_input_output {
    /// A builder for [`DescribeInputOutput`](crate::output::DescribeInputOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) attached_channels: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) destinations: std::option::Option<std::vec::Vec<crate::model::InputDestination>>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) input_class: std::option::Option<crate::model::InputClass>,
        pub(crate) input_devices:
            std::option::Option<std::vec::Vec<crate::model::InputDeviceSettings>>,
        pub(crate) input_partner_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) input_source_type: std::option::Option<crate::model::InputSourceType>,
        pub(crate) media_connect_flows:
            std::option::Option<std::vec::Vec<crate::model::MediaConnectFlow>>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) sources: std::option::Option<std::vec::Vec<crate::model::InputSource>>,
        pub(crate) state: std::option::Option<crate::model::InputState>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) r#type: std::option::Option<crate::model::InputType>,
    }
    impl Builder {
        /// The Unique ARN of the input (generated, immutable).
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// The Unique ARN of the input (generated, immutable).
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Appends an item to `attached_channels`.
        ///
        /// To override the contents of this collection use [`set_attached_channels`](Self::set_attached_channels).
        ///
        /// A list of channel IDs that that input is attached to (currently an input can only be attached to one channel).
        pub fn attached_channels(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.attached_channels.unwrap_or_default();
            v.push(input.into());
            self.attached_channels = Some(v);
            self
        }
        /// A list of channel IDs that that input is attached to (currently an input can only be attached to one channel).
        pub fn set_attached_channels(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.attached_channels = input;
            self
        }
        /// Appends an item to `destinations`.
        ///
        /// To override the contents of this collection use [`set_destinations`](Self::set_destinations).
        ///
        /// A list of the destinations of the input (PUSH-type).
        pub fn destinations(mut self, input: impl Into<crate::model::InputDestination>) -> Self {
            let mut v = self.destinations.unwrap_or_default();
            v.push(input.into());
            self.destinations = Some(v);
            self
        }
        /// A list of the destinations of the input (PUSH-type).
        pub fn set_destinations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InputDestination>>,
        ) -> Self {
            self.destinations = input;
            self
        }
        /// The generated ID of the input (unique for user account, immutable).
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// The generated ID of the input (unique for user account, immutable).
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// STANDARD - MediaLive expects two sources to be connected to this input. If the channel is also STANDARD, both sources will be ingested. If the channel is SINGLE_PIPELINE, only the first source will be ingested; the second source will always be ignored, even if the first source fails.
        /// SINGLE_PIPELINE - You can connect only one source to this input. If the ChannelClass is also  SINGLE_PIPELINE, this value is valid. If the ChannelClass is STANDARD, this value is not valid because the channel requires two sources in the input.
        pub fn input_class(mut self, input: crate::model::InputClass) -> Self {
            self.input_class = Some(input);
            self
        }
        /// STANDARD - MediaLive expects two sources to be connected to this input. If the channel is also STANDARD, both sources will be ingested. If the channel is SINGLE_PIPELINE, only the first source will be ingested; the second source will always be ignored, even if the first source fails.
        /// SINGLE_PIPELINE - You can connect only one source to this input. If the ChannelClass is also  SINGLE_PIPELINE, this value is valid. If the ChannelClass is STANDARD, this value is not valid because the channel requires two sources in the input.
        pub fn set_input_class(
            mut self,
            input: std::option::Option<crate::model::InputClass>,
        ) -> Self {
            self.input_class = input;
            self
        }
        /// Appends an item to `input_devices`.
        ///
        /// To override the contents of this collection use [`set_input_devices`](Self::set_input_devices).
        ///
        /// Settings for the input devices.
        pub fn input_devices(
            mut self,
            input: impl Into<crate::model::InputDeviceSettings>,
        ) -> Self {
            let mut v = self.input_devices.unwrap_or_default();
            v.push(input.into());
            self.input_devices = Some(v);
            self
        }
        /// Settings for the input devices.
        pub fn set_input_devices(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InputDeviceSettings>>,
        ) -> Self {
            self.input_devices = input;
            self
        }
        /// Appends an item to `input_partner_ids`.
        ///
        /// To override the contents of this collection use [`set_input_partner_ids`](Self::set_input_partner_ids).
        ///
        /// A list of IDs for all Inputs which are partners of this one.
        pub fn input_partner_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.input_partner_ids.unwrap_or_default();
            v.push(input.into());
            self.input_partner_ids = Some(v);
            self
        }
        /// A list of IDs for all Inputs which are partners of this one.
        pub fn set_input_partner_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.input_partner_ids = input;
            self
        }
        /// Certain pull input sources can be dynamic, meaning that they can have their URL's dynamically changes
        /// during input switch actions. Presently, this functionality only works with MP4_FILE and TS_FILE inputs.
        pub fn input_source_type(mut self, input: crate::model::InputSourceType) -> Self {
            self.input_source_type = Some(input);
            self
        }
        /// Certain pull input sources can be dynamic, meaning that they can have their URL's dynamically changes
        /// during input switch actions. Presently, this functionality only works with MP4_FILE and TS_FILE inputs.
        pub fn set_input_source_type(
            mut self,
            input: std::option::Option<crate::model::InputSourceType>,
        ) -> Self {
            self.input_source_type = input;
            self
        }
        /// Appends an item to `media_connect_flows`.
        ///
        /// To override the contents of this collection use [`set_media_connect_flows`](Self::set_media_connect_flows).
        ///
        /// A list of MediaConnect Flows for this input.
        pub fn media_connect_flows(
            mut self,
            input: impl Into<crate::model::MediaConnectFlow>,
        ) -> Self {
            let mut v = self.media_connect_flows.unwrap_or_default();
            v.push(input.into());
            self.media_connect_flows = Some(v);
            self
        }
        /// A list of MediaConnect Flows for this input.
        pub fn set_media_connect_flows(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MediaConnectFlow>>,
        ) -> Self {
            self.media_connect_flows = input;
            self
        }
        /// The user-assigned name (This is a mutable value).
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// The user-assigned name (This is a mutable value).
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// The Amazon Resource Name (ARN) of the role this input assumes during and after creation.
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) of the role this input assumes during and after creation.
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Appends an item to `security_groups`.
        ///
        /// To override the contents of this collection use [`set_security_groups`](Self::set_security_groups).
        ///
        /// A list of IDs for all the Input Security Groups attached to the input.
        pub fn security_groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_groups.unwrap_or_default();
            v.push(input.into());
            self.security_groups = Some(v);
            self
        }
        /// A list of IDs for all the Input Security Groups attached to the input.
        pub fn set_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_groups = input;
            self
        }
        /// Appends an item to `sources`.
        ///
        /// To override the contents of this collection use [`set_sources`](Self::set_sources).
        ///
        /// A list of the sources of the input (PULL-type).
        pub fn sources(mut self, input: impl Into<crate::model::InputSource>) -> Self {
            let mut v = self.sources.unwrap_or_default();
            v.push(input.into());
            self.sources = Some(v);
            self
        }
        /// A list of the sources of the input (PULL-type).
        pub fn set_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InputSource>>,
        ) -> Self {
            self.sources = input;
            self
        }
        /// Placeholder documentation for InputState
        pub fn state(mut self, input: crate::model::InputState) -> Self {
            self.state = Some(input);
            self
        }
        /// Placeholder documentation for InputState
        pub fn set_state(mut self, input: std::option::Option<crate::model::InputState>) -> Self {
            self.state = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of key-value pairs.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// A collection of key-value pairs.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// The different types of inputs that AWS Elemental MediaLive supports.
        pub fn r#type(mut self, input: crate::model::InputType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// The different types of inputs that AWS Elemental MediaLive supports.
        pub fn set_type(mut self, input: std::option::Option<crate::model::InputType>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeInputOutput`](crate::output::DescribeInputOutput)
        pub fn build(self) -> crate::output::DescribeInputOutput {
            crate::output::DescribeInputOutput {
                arn: self.arn,
                attached_channels: self.attached_channels,
                destinations: self.destinations,
                id: self.id,
                input_class: self.input_class,
                input_devices: self.input_devices,
                input_partner_ids: self.input_partner_ids,
                input_source_type: self.input_source_type,
                media_connect_flows: self.media_connect_flows,
                name: self.name,
                role_arn: self.role_arn,
                security_groups: self.security_groups,
                sources: self.sources,
                state: self.state,
                tags: self.tags,
                r#type: self.r#type,
            }
        }
    }
}
impl DescribeInputOutput {
    /// Creates a new builder-style object to manufacture [`DescribeInputOutput`](crate::output::DescribeInputOutput)
    pub fn builder() -> crate::output::describe_input_output::Builder {
        crate::output::describe_input_output::Builder::default()
    }
}

/// Placeholder documentation for DescribeChannelResponse
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeChannelOutput {
    /// The unique arn of the channel.
    pub arn: std::option::Option<std::string::String>,
    /// Specification of CDI inputs for this channel
    pub cdi_input_specification: std::option::Option<crate::model::CdiInputSpecification>,
    /// The class for this channel. STANDARD for a channel with two pipelines or SINGLE_PIPELINE for a channel with one pipeline.
    pub channel_class: std::option::Option<crate::model::ChannelClass>,
    /// A list of destinations of the channel. For UDP outputs, there is one
    /// destination per output. For other types (HLS, for example), there is
    /// one destination per packager.
    pub destinations: std::option::Option<std::vec::Vec<crate::model::OutputDestination>>,
    /// The endpoints where outgoing connections initiate from
    pub egress_endpoints: std::option::Option<std::vec::Vec<crate::model::ChannelEgressEndpoint>>,
    /// Encoder Settings
    pub encoder_settings: std::option::Option<crate::model::EncoderSettings>,
    /// The unique id of the channel.
    pub id: std::option::Option<std::string::String>,
    /// List of input attachments for channel.
    pub input_attachments: std::option::Option<std::vec::Vec<crate::model::InputAttachment>>,
    /// Specification of network and file inputs for this channel
    pub input_specification: std::option::Option<crate::model::InputSpecification>,
    /// The log level being written to CloudWatch Logs.
    pub log_level: std::option::Option<crate::model::LogLevel>,
    /// The name of the channel. (user-mutable)
    pub name: std::option::Option<std::string::String>,
    /// Runtime details for the pipelines of a running channel.
    pub pipeline_details: std::option::Option<std::vec::Vec<crate::model::PipelineDetail>>,
    /// The number of currently healthy pipelines.
    pub pipelines_running_count: i32,
    /// The Amazon Resource Name (ARN) of the role assumed when running the Channel.
    pub role_arn: std::option::Option<std::string::String>,
    /// Placeholder documentation for ChannelState
    pub state: std::option::Option<crate::model::ChannelState>,
    /// A collection of key-value pairs.
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// Settings for VPC output
    pub vpc: std::option::Option<crate::model::VpcOutputSettingsDescription>,
}
impl DescribeChannelOutput {
    /// The unique arn of the channel.
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// Specification of CDI inputs for this channel
    pub fn cdi_input_specification(
        &self,
    ) -> std::option::Option<&crate::model::CdiInputSpecification> {
        self.cdi_input_specification.as_ref()
    }
    /// The class for this channel. STANDARD for a channel with two pipelines or SINGLE_PIPELINE for a channel with one pipeline.
    pub fn channel_class(&self) -> std::option::Option<&crate::model::ChannelClass> {
        self.channel_class.as_ref()
    }
    /// A list of destinations of the channel. For UDP outputs, there is one
    /// destination per output. For other types (HLS, for example), there is
    /// one destination per packager.
    pub fn destinations(&self) -> std::option::Option<&[crate::model::OutputDestination]> {
        self.destinations.as_deref()
    }
    /// The endpoints where outgoing connections initiate from
    pub fn egress_endpoints(&self) -> std::option::Option<&[crate::model::ChannelEgressEndpoint]> {
        self.egress_endpoints.as_deref()
    }
    /// Encoder Settings
    pub fn encoder_settings(&self) -> std::option::Option<&crate::model::EncoderSettings> {
        self.encoder_settings.as_ref()
    }
    /// The unique id of the channel.
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// List of input attachments for channel.
    pub fn input_attachments(&self) -> std::option::Option<&[crate::model::InputAttachment]> {
        self.input_attachments.as_deref()
    }
    /// Specification of network and file inputs for this channel
    pub fn input_specification(&self) -> std::option::Option<&crate::model::InputSpecification> {
        self.input_specification.as_ref()
    }
    /// The log level being written to CloudWatch Logs.
    pub fn log_level(&self) -> std::option::Option<&crate::model::LogLevel> {
        self.log_level.as_ref()
    }
    /// The name of the channel. (user-mutable)
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// Runtime details for the pipelines of a running channel.
    pub fn pipeline_details(&self) -> std::option::Option<&[crate::model::PipelineDetail]> {
        self.pipeline_details.as_deref()
    }
    /// The number of currently healthy pipelines.
    pub fn pipelines_running_count(&self) -> i32 {
        self.pipelines_running_count
    }
    /// The Amazon Resource Name (ARN) of the role assumed when running the Channel.
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// Placeholder documentation for ChannelState
    pub fn state(&self) -> std::option::Option<&crate::model::ChannelState> {
        self.state.as_ref()
    }
    /// A collection of key-value pairs.
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// Settings for VPC output
    pub fn vpc(&self) -> std::option::Option<&crate::model::VpcOutputSettingsDescription> {
        self.vpc.as_ref()
    }
}
impl std::fmt::Debug for DescribeChannelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeChannelOutput");
        formatter.field("arn", &self.arn);
        formatter.field("cdi_input_specification", &self.cdi_input_specification);
        formatter.field("channel_class", &self.channel_class);
        formatter.field("destinations", &self.destinations);
        formatter.field("egress_endpoints", &self.egress_endpoints);
        formatter.field("encoder_settings", &self.encoder_settings);
        formatter.field("id", &self.id);
        formatter.field("input_attachments", &self.input_attachments);
        formatter.field("input_specification", &self.input_specification);
        formatter.field("log_level", &self.log_level);
        formatter.field("name", &self.name);
        formatter.field("pipeline_details", &self.pipeline_details);
        formatter.field("pipelines_running_count", &self.pipelines_running_count);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("state", &self.state);
        formatter.field("tags", &self.tags);
        formatter.field("vpc", &self.vpc);
        formatter.finish()
    }
}
/// See [`DescribeChannelOutput`](crate::output::DescribeChannelOutput)
pub mod describe_channel_output {
    /// A builder for [`DescribeChannelOutput`](crate::output::DescribeChannelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) cdi_input_specification:
            std::option::Option<crate::model::CdiInputSpecification>,
        pub(crate) channel_class: std::option::Option<crate::model::ChannelClass>,
        pub(crate) destinations:
            std::option::Option<std::vec::Vec<crate::model::OutputDestination>>,
        pub(crate) egress_endpoints:
            std::option::Option<std::vec::Vec<crate::model::ChannelEgressEndpoint>>,
        pub(crate) encoder_settings: std::option::Option<crate::model::EncoderSettings>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) input_attachments:
            std::option::Option<std::vec::Vec<crate::model::InputAttachment>>,
        pub(crate) input_specification: std::option::Option<crate::model::InputSpecification>,
        pub(crate) log_level: std::option::Option<crate::model::LogLevel>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) pipeline_details:
            std::option::Option<std::vec::Vec<crate::model::PipelineDetail>>,
        pub(crate) pipelines_running_count: std::option::Option<i32>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::ChannelState>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) vpc: std::option::Option<crate::model::VpcOutputSettingsDescription>,
    }
    impl Builder {
        /// The unique arn of the channel.
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// The unique arn of the channel.
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Specification of CDI inputs for this channel
        pub fn cdi_input_specification(
            mut self,
            input: crate::model::CdiInputSpecification,
        ) -> Self {
            self.cdi_input_specification = Some(input);
            self
        }
        /// Specification of CDI inputs for this channel
        pub fn set_cdi_input_specification(
            mut self,
            input: std::option::Option<crate::model::CdiInputSpecification>,
        ) -> Self {
            self.cdi_input_specification = input;
            self
        }
        /// The class for this channel. STANDARD for a channel with two pipelines or SINGLE_PIPELINE for a channel with one pipeline.
        pub fn channel_class(mut self, input: crate::model::ChannelClass) -> Self {
            self.channel_class = Some(input);
            self
        }
        /// The class for this channel. STANDARD for a channel with two pipelines or SINGLE_PIPELINE for a channel with one pipeline.
        pub fn set_channel_class(
            mut self,
            input: std::option::Option<crate::model::ChannelClass>,
        ) -> Self {
            self.channel_class = input;
            self
        }
        /// Appends an item to `destinations`.
        ///
        /// To override the contents of this collection use [`set_destinations`](Self::set_destinations).
        ///
        /// A list of destinations of the channel. For UDP outputs, there is one
        /// destination per output. For other types (HLS, for example), there is
        /// one destination per packager.
        pub fn destinations(mut self, input: impl Into<crate::model::OutputDestination>) -> Self {
            let mut v = self.destinations.unwrap_or_default();
            v.push(input.into());
            self.destinations = Some(v);
            self
        }
        /// A list of destinations of the channel. For UDP outputs, there is one
        /// destination per output. For other types (HLS, for example), there is
        /// one destination per packager.
        pub fn set_destinations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OutputDestination>>,
        ) -> Self {
            self.destinations = input;
            self
        }
        /// Appends an item to `egress_endpoints`.
        ///
        /// To override the contents of this collection use [`set_egress_endpoints`](Self::set_egress_endpoints).
        ///
        /// The endpoints where outgoing connections initiate from
        pub fn egress_endpoints(
            mut self,
            input: impl Into<crate::model::ChannelEgressEndpoint>,
        ) -> Self {
            let mut v = self.egress_endpoints.unwrap_or_default();
            v.push(input.into());
            self.egress_endpoints = Some(v);
            self
        }
        /// The endpoints where outgoing connections initiate from
        pub fn set_egress_endpoints(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ChannelEgressEndpoint>>,
        ) -> Self {
            self.egress_endpoints = input;
            self
        }
        /// Encoder Settings
        pub fn encoder_settings(mut self, input: crate::model::EncoderSettings) -> Self {
            self.encoder_settings = Some(input);
            self
        }
        /// Encoder Settings
        pub fn set_encoder_settings(
            mut self,
            input: std::option::Option<crate::model::EncoderSettings>,
        ) -> Self {
            self.encoder_settings = input;
            self
        }
        /// The unique id of the channel.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// The unique id of the channel.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Appends an item to `input_attachments`.
        ///
        /// To override the contents of this collection use [`set_input_attachments`](Self::set_input_attachments).
        ///
        /// List of input attachments for channel.
        pub fn input_attachments(
            mut self,
            input: impl Into<crate::model::InputAttachment>,
        ) -> Self {
            let mut v = self.input_attachments.unwrap_or_default();
            v.push(input.into());
            self.input_attachments = Some(v);
            self
        }
        /// List of input attachments for channel.
        pub fn set_input_attachments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InputAttachment>>,
        ) -> Self {
            self.input_attachments = input;
            self
        }
        /// Specification of network and file inputs for this channel
        pub fn input_specification(mut self, input: crate::model::InputSpecification) -> Self {
            self.input_specification = Some(input);
            self
        }
        /// Specification of network and file inputs for this channel
        pub fn set_input_specification(
            mut self,
            input: std::option::Option<crate::model::InputSpecification>,
        ) -> Self {
            self.input_specification = input;
            self
        }
        /// The log level being written to CloudWatch Logs.
        pub fn log_level(mut self, input: crate::model::LogLevel) -> Self {
            self.log_level = Some(input);
            self
        }
        /// The log level being written to CloudWatch Logs.
        pub fn set_log_level(mut self, input: std::option::Option<crate::model::LogLevel>) -> Self {
            self.log_level = input;
            self
        }
        /// The name of the channel. (user-mutable)
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// The name of the channel. (user-mutable)
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `pipeline_details`.
        ///
        /// To override the contents of this collection use [`set_pipeline_details`](Self::set_pipeline_details).
        ///
        /// Runtime details for the pipelines of a running channel.
        pub fn pipeline_details(mut self, input: impl Into<crate::model::PipelineDetail>) -> Self {
            let mut v = self.pipeline_details.unwrap_or_default();
            v.push(input.into());
            self.pipeline_details = Some(v);
            self
        }
        /// Runtime details for the pipelines of a running channel.
        pub fn set_pipeline_details(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PipelineDetail>>,
        ) -> Self {
            self.pipeline_details = input;
            self
        }
        /// The number of currently healthy pipelines.
        pub fn pipelines_running_count(mut self, input: i32) -> Self {
            self.pipelines_running_count = Some(input);
            self
        }
        /// The number of currently healthy pipelines.
        pub fn set_pipelines_running_count(mut self, input: std::option::Option<i32>) -> Self {
            self.pipelines_running_count = input;
            self
        }
        /// The Amazon Resource Name (ARN) of the role assumed when running the Channel.
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) of the role assumed when running the Channel.
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Placeholder documentation for ChannelState
        pub fn state(mut self, input: crate::model::ChannelState) -> Self {
            self.state = Some(input);
            self
        }
        /// Placeholder documentation for ChannelState
        pub fn set_state(mut self, input: std::option::Option<crate::model::ChannelState>) -> Self {
            self.state = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of key-value pairs.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// A collection of key-value pairs.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Settings for VPC output
        pub fn vpc(mut self, input: crate::model::VpcOutputSettingsDescription) -> Self {
            self.vpc = Some(input);
            self
        }
        /// Settings for VPC output
        pub fn set_vpc(
            mut self,
            input: std::option::Option<crate::model::VpcOutputSettingsDescription>,
        ) -> Self {
            self.vpc = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeChannelOutput`](crate::output::DescribeChannelOutput)
        pub fn build(self) -> crate::output::DescribeChannelOutput {
            crate::output::DescribeChannelOutput {
                arn: self.arn,
                cdi_input_specification: self.cdi_input_specification,
                channel_class: self.channel_class,
                destinations: self.destinations,
                egress_endpoints: self.egress_endpoints,
                encoder_settings: self.encoder_settings,
                id: self.id,
                input_attachments: self.input_attachments,
                input_specification: self.input_specification,
                log_level: self.log_level,
                name: self.name,
                pipeline_details: self.pipeline_details,
                pipelines_running_count: self.pipelines_running_count.unwrap_or_default(),
                role_arn: self.role_arn,
                state: self.state,
                tags: self.tags,
                vpc: self.vpc,
            }
        }
    }
}
impl DescribeChannelOutput {
    /// Creates a new builder-style object to manufacture [`DescribeChannelOutput`](crate::output::DescribeChannelOutput)
    pub fn builder() -> crate::output::describe_channel_output::Builder {
        crate::output::describe_channel_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTagsOutput {}
impl std::fmt::Debug for DeleteTagsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTagsOutput");
        formatter.finish()
    }
}
/// See [`DeleteTagsOutput`](crate::output::DeleteTagsOutput)
pub mod delete_tags_output {
    /// A builder for [`DeleteTagsOutput`](crate::output::DeleteTagsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteTagsOutput`](crate::output::DeleteTagsOutput)
        pub fn build(self) -> crate::output::DeleteTagsOutput {
            crate::output::DeleteTagsOutput {}
        }
    }
}
impl DeleteTagsOutput {
    /// Creates a new builder-style object to manufacture [`DeleteTagsOutput`](crate::output::DeleteTagsOutput)
    pub fn builder() -> crate::output::delete_tags_output::Builder {
        crate::output::delete_tags_output::Builder::default()
    }
}

/// Placeholder documentation for DeleteScheduleResponse
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteScheduleOutput {}
impl std::fmt::Debug for DeleteScheduleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteScheduleOutput");
        formatter.finish()
    }
}
/// See [`DeleteScheduleOutput`](crate::output::DeleteScheduleOutput)
pub mod delete_schedule_output {
    /// A builder for [`DeleteScheduleOutput`](crate::output::DeleteScheduleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteScheduleOutput`](crate::output::DeleteScheduleOutput)
        pub fn build(self) -> crate::output::DeleteScheduleOutput {
            crate::output::DeleteScheduleOutput {}
        }
    }
}
impl DeleteScheduleOutput {
    /// Creates a new builder-style object to manufacture [`DeleteScheduleOutput`](crate::output::DeleteScheduleOutput)
    pub fn builder() -> crate::output::delete_schedule_output::Builder {
        crate::output::delete_schedule_output::Builder::default()
    }
}

/// Placeholder documentation for DeleteReservationResponse
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteReservationOutput {
    /// Unique reservation ARN, e.g. 'arn:aws:medialive:us-west-2:123456789012:reservation:1234567'
    pub arn: std::option::Option<std::string::String>,
    /// Number of reserved resources
    pub count: i32,
    /// Currency code for usagePrice and fixedPrice in ISO-4217 format, e.g. 'USD'
    pub currency_code: std::option::Option<std::string::String>,
    /// Lease duration, e.g. '12'
    pub duration: i32,
    /// Units for duration, e.g. 'MONTHS'
    pub duration_units: std::option::Option<crate::model::OfferingDurationUnits>,
    /// Reservation UTC end date and time in ISO-8601 format, e.g. '2019-03-01T00:00:00'
    pub end: std::option::Option<std::string::String>,
    /// One-time charge for each reserved resource, e.g. '0.0' for a NO_UPFRONT offering
    pub fixed_price: f64,
    /// User specified reservation name
    pub name: std::option::Option<std::string::String>,
    /// Offering description, e.g. 'HD AVC output at 10-20 Mbps, 30 fps, and standard VQ in US West (Oregon)'
    pub offering_description: std::option::Option<std::string::String>,
    /// Unique offering ID, e.g. '87654321'
    pub offering_id: std::option::Option<std::string::String>,
    /// Offering type, e.g. 'NO_UPFRONT'
    pub offering_type: std::option::Option<crate::model::OfferingType>,
    /// AWS region, e.g. 'us-west-2'
    pub region: std::option::Option<std::string::String>,
    /// Unique reservation ID, e.g. '1234567'
    pub reservation_id: std::option::Option<std::string::String>,
    /// Resource configuration details
    pub resource_specification: std::option::Option<crate::model::ReservationResourceSpecification>,
    /// Reservation UTC start date and time in ISO-8601 format, e.g. '2018-03-01T00:00:00'
    pub start: std::option::Option<std::string::String>,
    /// Current state of reservation, e.g. 'ACTIVE'
    pub state: std::option::Option<crate::model::ReservationState>,
    /// A collection of key-value pairs
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// Recurring usage charge for each reserved resource, e.g. '157.0'
    pub usage_price: f64,
}
impl DeleteReservationOutput {
    /// Unique reservation ARN, e.g. 'arn:aws:medialive:us-west-2:123456789012:reservation:1234567'
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// Number of reserved resources
    pub fn count(&self) -> i32 {
        self.count
    }
    /// Currency code for usagePrice and fixedPrice in ISO-4217 format, e.g. 'USD'
    pub fn currency_code(&self) -> std::option::Option<&str> {
        self.currency_code.as_deref()
    }
    /// Lease duration, e.g. '12'
    pub fn duration(&self) -> i32 {
        self.duration
    }
    /// Units for duration, e.g. 'MONTHS'
    pub fn duration_units(&self) -> std::option::Option<&crate::model::OfferingDurationUnits> {
        self.duration_units.as_ref()
    }
    /// Reservation UTC end date and time in ISO-8601 format, e.g. '2019-03-01T00:00:00'
    pub fn end(&self) -> std::option::Option<&str> {
        self.end.as_deref()
    }
    /// One-time charge for each reserved resource, e.g. '0.0' for a NO_UPFRONT offering
    pub fn fixed_price(&self) -> f64 {
        self.fixed_price
    }
    /// User specified reservation name
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// Offering description, e.g. 'HD AVC output at 10-20 Mbps, 30 fps, and standard VQ in US West (Oregon)'
    pub fn offering_description(&self) -> std::option::Option<&str> {
        self.offering_description.as_deref()
    }
    /// Unique offering ID, e.g. '87654321'
    pub fn offering_id(&self) -> std::option::Option<&str> {
        self.offering_id.as_deref()
    }
    /// Offering type, e.g. 'NO_UPFRONT'
    pub fn offering_type(&self) -> std::option::Option<&crate::model::OfferingType> {
        self.offering_type.as_ref()
    }
    /// AWS region, e.g. 'us-west-2'
    pub fn region(&self) -> std::option::Option<&str> {
        self.region.as_deref()
    }
    /// Unique reservation ID, e.g. '1234567'
    pub fn reservation_id(&self) -> std::option::Option<&str> {
        self.reservation_id.as_deref()
    }
    /// Resource configuration details
    pub fn resource_specification(
        &self,
    ) -> std::option::Option<&crate::model::ReservationResourceSpecification> {
        self.resource_specification.as_ref()
    }
    /// Reservation UTC start date and time in ISO-8601 format, e.g. '2018-03-01T00:00:00'
    pub fn start(&self) -> std::option::Option<&str> {
        self.start.as_deref()
    }
    /// Current state of reservation, e.g. 'ACTIVE'
    pub fn state(&self) -> std::option::Option<&crate::model::ReservationState> {
        self.state.as_ref()
    }
    /// A collection of key-value pairs
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// Recurring usage charge for each reserved resource, e.g. '157.0'
    pub fn usage_price(&self) -> f64 {
        self.usage_price
    }
}
impl std::fmt::Debug for DeleteReservationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteReservationOutput");
        formatter.field("arn", &self.arn);
        formatter.field("count", &self.count);
        formatter.field("currency_code", &self.currency_code);
        formatter.field("duration", &self.duration);
        formatter.field("duration_units", &self.duration_units);
        formatter.field("end", &self.end);
        formatter.field("fixed_price", &self.fixed_price);
        formatter.field("name", &self.name);
        formatter.field("offering_description", &self.offering_description);
        formatter.field("offering_id", &self.offering_id);
        formatter.field("offering_type", &self.offering_type);
        formatter.field("region", &self.region);
        formatter.field("reservation_id", &self.reservation_id);
        formatter.field("resource_specification", &self.resource_specification);
        formatter.field("start", &self.start);
        formatter.field("state", &self.state);
        formatter.field("tags", &self.tags);
        formatter.field("usage_price", &self.usage_price);
        formatter.finish()
    }
}
/// See [`DeleteReservationOutput`](crate::output::DeleteReservationOutput)
pub mod delete_reservation_output {
    /// A builder for [`DeleteReservationOutput`](crate::output::DeleteReservationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) count: std::option::Option<i32>,
        pub(crate) currency_code: std::option::Option<std::string::String>,
        pub(crate) duration: std::option::Option<i32>,
        pub(crate) duration_units: std::option::Option<crate::model::OfferingDurationUnits>,
        pub(crate) end: std::option::Option<std::string::String>,
        pub(crate) fixed_price: std::option::Option<f64>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) offering_description: std::option::Option<std::string::String>,
        pub(crate) offering_id: std::option::Option<std::string::String>,
        pub(crate) offering_type: std::option::Option<crate::model::OfferingType>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) reservation_id: std::option::Option<std::string::String>,
        pub(crate) resource_specification:
            std::option::Option<crate::model::ReservationResourceSpecification>,
        pub(crate) start: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::ReservationState>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) usage_price: std::option::Option<f64>,
    }
    impl Builder {
        /// Unique reservation ARN, e.g. 'arn:aws:medialive:us-west-2:123456789012:reservation:1234567'
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// Unique reservation ARN, e.g. 'arn:aws:medialive:us-west-2:123456789012:reservation:1234567'
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Number of reserved resources
        pub fn count(mut self, input: i32) -> Self {
            self.count = Some(input);
            self
        }
        /// Number of reserved resources
        pub fn set_count(mut self, input: std::option::Option<i32>) -> Self {
            self.count = input;
            self
        }
        /// Currency code for usagePrice and fixedPrice in ISO-4217 format, e.g. 'USD'
        pub fn currency_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.currency_code = Some(input.into());
            self
        }
        /// Currency code for usagePrice and fixedPrice in ISO-4217 format, e.g. 'USD'
        pub fn set_currency_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.currency_code = input;
            self
        }
        /// Lease duration, e.g. '12'
        pub fn duration(mut self, input: i32) -> Self {
            self.duration = Some(input);
            self
        }
        /// Lease duration, e.g. '12'
        pub fn set_duration(mut self, input: std::option::Option<i32>) -> Self {
            self.duration = input;
            self
        }
        /// Units for duration, e.g. 'MONTHS'
        pub fn duration_units(mut self, input: crate::model::OfferingDurationUnits) -> Self {
            self.duration_units = Some(input);
            self
        }
        /// Units for duration, e.g. 'MONTHS'
        pub fn set_duration_units(
            mut self,
            input: std::option::Option<crate::model::OfferingDurationUnits>,
        ) -> Self {
            self.duration_units = input;
            self
        }
        /// Reservation UTC end date and time in ISO-8601 format, e.g. '2019-03-01T00:00:00'
        pub fn end(mut self, input: impl Into<std::string::String>) -> Self {
            self.end = Some(input.into());
            self
        }
        /// Reservation UTC end date and time in ISO-8601 format, e.g. '2019-03-01T00:00:00'
        pub fn set_end(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.end = input;
            self
        }
        /// One-time charge for each reserved resource, e.g. '0.0' for a NO_UPFRONT offering
        pub fn fixed_price(mut self, input: f64) -> Self {
            self.fixed_price = Some(input);
            self
        }
        /// One-time charge for each reserved resource, e.g. '0.0' for a NO_UPFRONT offering
        pub fn set_fixed_price(mut self, input: std::option::Option<f64>) -> Self {
            self.fixed_price = input;
            self
        }
        /// User specified reservation name
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// User specified reservation name
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Offering description, e.g. 'HD AVC output at 10-20 Mbps, 30 fps, and standard VQ in US West (Oregon)'
        pub fn offering_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.offering_description = Some(input.into());
            self
        }
        /// Offering description, e.g. 'HD AVC output at 10-20 Mbps, 30 fps, and standard VQ in US West (Oregon)'
        pub fn set_offering_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.offering_description = input;
            self
        }
        /// Unique offering ID, e.g. '87654321'
        pub fn offering_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.offering_id = Some(input.into());
            self
        }
        /// Unique offering ID, e.g. '87654321'
        pub fn set_offering_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.offering_id = input;
            self
        }
        /// Offering type, e.g. 'NO_UPFRONT'
        pub fn offering_type(mut self, input: crate::model::OfferingType) -> Self {
            self.offering_type = Some(input);
            self
        }
        /// Offering type, e.g. 'NO_UPFRONT'
        pub fn set_offering_type(
            mut self,
            input: std::option::Option<crate::model::OfferingType>,
        ) -> Self {
            self.offering_type = input;
            self
        }
        /// AWS region, e.g. 'us-west-2'
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// AWS region, e.g. 'us-west-2'
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// Unique reservation ID, e.g. '1234567'
        pub fn reservation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.reservation_id = Some(input.into());
            self
        }
        /// Unique reservation ID, e.g. '1234567'
        pub fn set_reservation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reservation_id = input;
            self
        }
        /// Resource configuration details
        pub fn resource_specification(
            mut self,
            input: crate::model::ReservationResourceSpecification,
        ) -> Self {
            self.resource_specification = Some(input);
            self
        }
        /// Resource configuration details
        pub fn set_resource_specification(
            mut self,
            input: std::option::Option<crate::model::ReservationResourceSpecification>,
        ) -> Self {
            self.resource_specification = input;
            self
        }
        /// Reservation UTC start date and time in ISO-8601 format, e.g. '2018-03-01T00:00:00'
        pub fn start(mut self, input: impl Into<std::string::String>) -> Self {
            self.start = Some(input.into());
            self
        }
        /// Reservation UTC start date and time in ISO-8601 format, e.g. '2018-03-01T00:00:00'
        pub fn set_start(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.start = input;
            self
        }
        /// Current state of reservation, e.g. 'ACTIVE'
        pub fn state(mut self, input: crate::model::ReservationState) -> Self {
            self.state = Some(input);
            self
        }
        /// Current state of reservation, e.g. 'ACTIVE'
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::ReservationState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of key-value pairs
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// A collection of key-value pairs
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Recurring usage charge for each reserved resource, e.g. '157.0'
        pub fn usage_price(mut self, input: f64) -> Self {
            self.usage_price = Some(input);
            self
        }
        /// Recurring usage charge for each reserved resource, e.g. '157.0'
        pub fn set_usage_price(mut self, input: std::option::Option<f64>) -> Self {
            self.usage_price = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteReservationOutput`](crate::output::DeleteReservationOutput)
        pub fn build(self) -> crate::output::DeleteReservationOutput {
            crate::output::DeleteReservationOutput {
                arn: self.arn,
                count: self.count.unwrap_or_default(),
                currency_code: self.currency_code,
                duration: self.duration.unwrap_or_default(),
                duration_units: self.duration_units,
                end: self.end,
                fixed_price: self.fixed_price.unwrap_or_default(),
                name: self.name,
                offering_description: self.offering_description,
                offering_id: self.offering_id,
                offering_type: self.offering_type,
                region: self.region,
                reservation_id: self.reservation_id,
                resource_specification: self.resource_specification,
                start: self.start,
                state: self.state,
                tags: self.tags,
                usage_price: self.usage_price.unwrap_or_default(),
            }
        }
    }
}
impl DeleteReservationOutput {
    /// Creates a new builder-style object to manufacture [`DeleteReservationOutput`](crate::output::DeleteReservationOutput)
    pub fn builder() -> crate::output::delete_reservation_output::Builder {
        crate::output::delete_reservation_output::Builder::default()
    }
}

/// Placeholder documentation for DeleteMultiplexProgramResponse
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteMultiplexProgramOutput {
    /// The MediaLive channel associated with the program.
    pub channel_id: std::option::Option<std::string::String>,
    /// The settings for this multiplex program.
    pub multiplex_program_settings: std::option::Option<crate::model::MultiplexProgramSettings>,
    /// The packet identifier map for this multiplex program.
    pub packet_identifiers_map:
        std::option::Option<crate::model::MultiplexProgramPacketIdentifiersMap>,
    /// Contains information about the current sources for the specified program in the specified multiplex. Keep in mind that each multiplex pipeline connects to both pipelines in a given source channel (the channel identified by the program). But only one of those channel pipelines is ever active at one time.
    pub pipeline_details:
        std::option::Option<std::vec::Vec<crate::model::MultiplexProgramPipelineDetail>>,
    /// The name of the multiplex program.
    pub program_name: std::option::Option<std::string::String>,
}
impl DeleteMultiplexProgramOutput {
    /// The MediaLive channel associated with the program.
    pub fn channel_id(&self) -> std::option::Option<&str> {
        self.channel_id.as_deref()
    }
    /// The settings for this multiplex program.
    pub fn multiplex_program_settings(
        &self,
    ) -> std::option::Option<&crate::model::MultiplexProgramSettings> {
        self.multiplex_program_settings.as_ref()
    }
    /// The packet identifier map for this multiplex program.
    pub fn packet_identifiers_map(
        &self,
    ) -> std::option::Option<&crate::model::MultiplexProgramPacketIdentifiersMap> {
        self.packet_identifiers_map.as_ref()
    }
    /// Contains information about the current sources for the specified program in the specified multiplex. Keep in mind that each multiplex pipeline connects to both pipelines in a given source channel (the channel identified by the program). But only one of those channel pipelines is ever active at one time.
    pub fn pipeline_details(
        &self,
    ) -> std::option::Option<&[crate::model::MultiplexProgramPipelineDetail]> {
        self.pipeline_details.as_deref()
    }
    /// The name of the multiplex program.
    pub fn program_name(&self) -> std::option::Option<&str> {
        self.program_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteMultiplexProgramOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteMultiplexProgramOutput");
        formatter.field("channel_id", &self.channel_id);
        formatter.field(
            "multiplex_program_settings",
            &self.multiplex_program_settings,
        );
        formatter.field("packet_identifiers_map", &self.packet_identifiers_map);
        formatter.field("pipeline_details", &self.pipeline_details);
        formatter.field("program_name", &self.program_name);
        formatter.finish()
    }
}
/// See [`DeleteMultiplexProgramOutput`](crate::output::DeleteMultiplexProgramOutput)
pub mod delete_multiplex_program_output {
    /// A builder for [`DeleteMultiplexProgramOutput`](crate::output::DeleteMultiplexProgramOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_id: std::option::Option<std::string::String>,
        pub(crate) multiplex_program_settings:
            std::option::Option<crate::model::MultiplexProgramSettings>,
        pub(crate) packet_identifiers_map:
            std::option::Option<crate::model::MultiplexProgramPacketIdentifiersMap>,
        pub(crate) pipeline_details:
            std::option::Option<std::vec::Vec<crate::model::MultiplexProgramPipelineDetail>>,
        pub(crate) program_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The MediaLive channel associated with the program.
        pub fn channel_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_id = Some(input.into());
            self
        }
        /// The MediaLive channel associated with the program.
        pub fn set_channel_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_id = input;
            self
        }
        /// The settings for this multiplex program.
        pub fn multiplex_program_settings(
            mut self,
            input: crate::model::MultiplexProgramSettings,
        ) -> Self {
            self.multiplex_program_settings = Some(input);
            self
        }
        /// The settings for this multiplex program.
        pub fn set_multiplex_program_settings(
            mut self,
            input: std::option::Option<crate::model::MultiplexProgramSettings>,
        ) -> Self {
            self.multiplex_program_settings = input;
            self
        }
        /// The packet identifier map for this multiplex program.
        pub fn packet_identifiers_map(
            mut self,
            input: crate::model::MultiplexProgramPacketIdentifiersMap,
        ) -> Self {
            self.packet_identifiers_map = Some(input);
            self
        }
        /// The packet identifier map for this multiplex program.
        pub fn set_packet_identifiers_map(
            mut self,
            input: std::option::Option<crate::model::MultiplexProgramPacketIdentifiersMap>,
        ) -> Self {
            self.packet_identifiers_map = input;
            self
        }
        /// Appends an item to `pipeline_details`.
        ///
        /// To override the contents of this collection use [`set_pipeline_details`](Self::set_pipeline_details).
        ///
        /// Contains information about the current sources for the specified program in the specified multiplex. Keep in mind that each multiplex pipeline connects to both pipelines in a given source channel (the channel identified by the program). But only one of those channel pipelines is ever active at one time.
        pub fn pipeline_details(
            mut self,
            input: impl Into<crate::model::MultiplexProgramPipelineDetail>,
        ) -> Self {
            let mut v = self.pipeline_details.unwrap_or_default();
            v.push(input.into());
            self.pipeline_details = Some(v);
            self
        }
        /// Contains information about the current sources for the specified program in the specified multiplex. Keep in mind that each multiplex pipeline connects to both pipelines in a given source channel (the channel identified by the program). But only one of those channel pipelines is ever active at one time.
        pub fn set_pipeline_details(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MultiplexProgramPipelineDetail>>,
        ) -> Self {
            self.pipeline_details = input;
            self
        }
        /// The name of the multiplex program.
        pub fn program_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.program_name = Some(input.into());
            self
        }
        /// The name of the multiplex program.
        pub fn set_program_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.program_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteMultiplexProgramOutput`](crate::output::DeleteMultiplexProgramOutput)
        pub fn build(self) -> crate::output::DeleteMultiplexProgramOutput {
            crate::output::DeleteMultiplexProgramOutput {
                channel_id: self.channel_id,
                multiplex_program_settings: self.multiplex_program_settings,
                packet_identifiers_map: self.packet_identifiers_map,
                pipeline_details: self.pipeline_details,
                program_name: self.program_name,
            }
        }
    }
}
impl DeleteMultiplexProgramOutput {
    /// Creates a new builder-style object to manufacture [`DeleteMultiplexProgramOutput`](crate::output::DeleteMultiplexProgramOutput)
    pub fn builder() -> crate::output::delete_multiplex_program_output::Builder {
        crate::output::delete_multiplex_program_output::Builder::default()
    }
}

/// Placeholder documentation for DeleteMultiplexResponse
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteMultiplexOutput {
    /// The unique arn of the multiplex.
    pub arn: std::option::Option<std::string::String>,
    /// A list of availability zones for the multiplex.
    pub availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
    /// A list of the multiplex output destinations.
    pub destinations: std::option::Option<std::vec::Vec<crate::model::MultiplexOutputDestination>>,
    /// The unique id of the multiplex.
    pub id: std::option::Option<std::string::String>,
    /// Configuration for a multiplex event.
    pub multiplex_settings: std::option::Option<crate::model::MultiplexSettings>,
    /// The name of the multiplex.
    pub name: std::option::Option<std::string::String>,
    /// The number of currently healthy pipelines.
    pub pipelines_running_count: i32,
    /// The number of programs in the multiplex.
    pub program_count: i32,
    /// The current state of the multiplex.
    pub state: std::option::Option<crate::model::MultiplexState>,
    /// A collection of key-value pairs.
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl DeleteMultiplexOutput {
    /// The unique arn of the multiplex.
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// A list of availability zones for the multiplex.
    pub fn availability_zones(&self) -> std::option::Option<&[std::string::String]> {
        self.availability_zones.as_deref()
    }
    /// A list of the multiplex output destinations.
    pub fn destinations(&self) -> std::option::Option<&[crate::model::MultiplexOutputDestination]> {
        self.destinations.as_deref()
    }
    /// The unique id of the multiplex.
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// Configuration for a multiplex event.
    pub fn multiplex_settings(&self) -> std::option::Option<&crate::model::MultiplexSettings> {
        self.multiplex_settings.as_ref()
    }
    /// The name of the multiplex.
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// The number of currently healthy pipelines.
    pub fn pipelines_running_count(&self) -> i32 {
        self.pipelines_running_count
    }
    /// The number of programs in the multiplex.
    pub fn program_count(&self) -> i32 {
        self.program_count
    }
    /// The current state of the multiplex.
    pub fn state(&self) -> std::option::Option<&crate::model::MultiplexState> {
        self.state.as_ref()
    }
    /// A collection of key-value pairs.
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for DeleteMultiplexOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteMultiplexOutput");
        formatter.field("arn", &self.arn);
        formatter.field("availability_zones", &self.availability_zones);
        formatter.field("destinations", &self.destinations);
        formatter.field("id", &self.id);
        formatter.field("multiplex_settings", &self.multiplex_settings);
        formatter.field("name", &self.name);
        formatter.field("pipelines_running_count", &self.pipelines_running_count);
        formatter.field("program_count", &self.program_count);
        formatter.field("state", &self.state);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`DeleteMultiplexOutput`](crate::output::DeleteMultiplexOutput)
pub mod delete_multiplex_output {
    /// A builder for [`DeleteMultiplexOutput`](crate::output::DeleteMultiplexOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) destinations:
            std::option::Option<std::vec::Vec<crate::model::MultiplexOutputDestination>>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) multiplex_settings: std::option::Option<crate::model::MultiplexSettings>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) pipelines_running_count: std::option::Option<i32>,
        pub(crate) program_count: std::option::Option<i32>,
        pub(crate) state: std::option::Option<crate::model::MultiplexState>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// The unique arn of the multiplex.
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// The unique arn of the multiplex.
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Appends an item to `availability_zones`.
        ///
        /// To override the contents of this collection use [`set_availability_zones`](Self::set_availability_zones).
        ///
        /// A list of availability zones for the multiplex.
        pub fn availability_zones(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.availability_zones.unwrap_or_default();
            v.push(input.into());
            self.availability_zones = Some(v);
            self
        }
        /// A list of availability zones for the multiplex.
        pub fn set_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.availability_zones = input;
            self
        }
        /// Appends an item to `destinations`.
        ///
        /// To override the contents of this collection use [`set_destinations`](Self::set_destinations).
        ///
        /// A list of the multiplex output destinations.
        pub fn destinations(
            mut self,
            input: impl Into<crate::model::MultiplexOutputDestination>,
        ) -> Self {
            let mut v = self.destinations.unwrap_or_default();
            v.push(input.into());
            self.destinations = Some(v);
            self
        }
        /// A list of the multiplex output destinations.
        pub fn set_destinations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MultiplexOutputDestination>>,
        ) -> Self {
            self.destinations = input;
            self
        }
        /// The unique id of the multiplex.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// The unique id of the multiplex.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Configuration for a multiplex event.
        pub fn multiplex_settings(mut self, input: crate::model::MultiplexSettings) -> Self {
            self.multiplex_settings = Some(input);
            self
        }
        /// Configuration for a multiplex event.
        pub fn set_multiplex_settings(
            mut self,
            input: std::option::Option<crate::model::MultiplexSettings>,
        ) -> Self {
            self.multiplex_settings = input;
            self
        }
        /// The name of the multiplex.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// The name of the multiplex.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// The number of currently healthy pipelines.
        pub fn pipelines_running_count(mut self, input: i32) -> Self {
            self.pipelines_running_count = Some(input);
            self
        }
        /// The number of currently healthy pipelines.
        pub fn set_pipelines_running_count(mut self, input: std::option::Option<i32>) -> Self {
            self.pipelines_running_count = input;
            self
        }
        /// The number of programs in the multiplex.
        pub fn program_count(mut self, input: i32) -> Self {
            self.program_count = Some(input);
            self
        }
        /// The number of programs in the multiplex.
        pub fn set_program_count(mut self, input: std::option::Option<i32>) -> Self {
            self.program_count = input;
            self
        }
        /// The current state of the multiplex.
        pub fn state(mut self, input: crate::model::MultiplexState) -> Self {
            self.state = Some(input);
            self
        }
        /// The current state of the multiplex.
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::MultiplexState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of key-value pairs.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// A collection of key-value pairs.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteMultiplexOutput`](crate::output::DeleteMultiplexOutput)
        pub fn build(self) -> crate::output::DeleteMultiplexOutput {
            crate::output::DeleteMultiplexOutput {
                arn: self.arn,
                availability_zones: self.availability_zones,
                destinations: self.destinations,
                id: self.id,
                multiplex_settings: self.multiplex_settings,
                name: self.name,
                pipelines_running_count: self.pipelines_running_count.unwrap_or_default(),
                program_count: self.program_count.unwrap_or_default(),
                state: self.state,
                tags: self.tags,
            }
        }
    }
}
impl DeleteMultiplexOutput {
    /// Creates a new builder-style object to manufacture [`DeleteMultiplexOutput`](crate::output::DeleteMultiplexOutput)
    pub fn builder() -> crate::output::delete_multiplex_output::Builder {
        crate::output::delete_multiplex_output::Builder::default()
    }
}

/// Placeholder documentation for DeleteInputSecurityGroupResponse
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteInputSecurityGroupOutput {}
impl std::fmt::Debug for DeleteInputSecurityGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteInputSecurityGroupOutput");
        formatter.finish()
    }
}
/// See [`DeleteInputSecurityGroupOutput`](crate::output::DeleteInputSecurityGroupOutput)
pub mod delete_input_security_group_output {
    /// A builder for [`DeleteInputSecurityGroupOutput`](crate::output::DeleteInputSecurityGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteInputSecurityGroupOutput`](crate::output::DeleteInputSecurityGroupOutput)
        pub fn build(self) -> crate::output::DeleteInputSecurityGroupOutput {
            crate::output::DeleteInputSecurityGroupOutput {}
        }
    }
}
impl DeleteInputSecurityGroupOutput {
    /// Creates a new builder-style object to manufacture [`DeleteInputSecurityGroupOutput`](crate::output::DeleteInputSecurityGroupOutput)
    pub fn builder() -> crate::output::delete_input_security_group_output::Builder {
        crate::output::delete_input_security_group_output::Builder::default()
    }
}

/// Placeholder documentation for DeleteInputResponse
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteInputOutput {}
impl std::fmt::Debug for DeleteInputOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteInputOutput");
        formatter.finish()
    }
}
/// See [`DeleteInputOutput`](crate::output::DeleteInputOutput)
pub mod delete_input_output {
    /// A builder for [`DeleteInputOutput`](crate::output::DeleteInputOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteInputOutput`](crate::output::DeleteInputOutput)
        pub fn build(self) -> crate::output::DeleteInputOutput {
            crate::output::DeleteInputOutput {}
        }
    }
}
impl DeleteInputOutput {
    /// Creates a new builder-style object to manufacture [`DeleteInputOutput`](crate::output::DeleteInputOutput)
    pub fn builder() -> crate::output::delete_input_output::Builder {
        crate::output::delete_input_output::Builder::default()
    }
}

/// Placeholder documentation for DeleteChannelResponse
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteChannelOutput {
    /// The unique arn of the channel.
    pub arn: std::option::Option<std::string::String>,
    /// Specification of CDI inputs for this channel
    pub cdi_input_specification: std::option::Option<crate::model::CdiInputSpecification>,
    /// The class for this channel. STANDARD for a channel with two pipelines or SINGLE_PIPELINE for a channel with one pipeline.
    pub channel_class: std::option::Option<crate::model::ChannelClass>,
    /// A list of destinations of the channel. For UDP outputs, there is one
    /// destination per output. For other types (HLS, for example), there is
    /// one destination per packager.
    pub destinations: std::option::Option<std::vec::Vec<crate::model::OutputDestination>>,
    /// The endpoints where outgoing connections initiate from
    pub egress_endpoints: std::option::Option<std::vec::Vec<crate::model::ChannelEgressEndpoint>>,
    /// Encoder Settings
    pub encoder_settings: std::option::Option<crate::model::EncoderSettings>,
    /// The unique id of the channel.
    pub id: std::option::Option<std::string::String>,
    /// List of input attachments for channel.
    pub input_attachments: std::option::Option<std::vec::Vec<crate::model::InputAttachment>>,
    /// Specification of network and file inputs for this channel
    pub input_specification: std::option::Option<crate::model::InputSpecification>,
    /// The log level being written to CloudWatch Logs.
    pub log_level: std::option::Option<crate::model::LogLevel>,
    /// The name of the channel. (user-mutable)
    pub name: std::option::Option<std::string::String>,
    /// Runtime details for the pipelines of a running channel.
    pub pipeline_details: std::option::Option<std::vec::Vec<crate::model::PipelineDetail>>,
    /// The number of currently healthy pipelines.
    pub pipelines_running_count: i32,
    /// The Amazon Resource Name (ARN) of the role assumed when running the Channel.
    pub role_arn: std::option::Option<std::string::String>,
    /// Placeholder documentation for ChannelState
    pub state: std::option::Option<crate::model::ChannelState>,
    /// A collection of key-value pairs.
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// Settings for VPC output
    pub vpc: std::option::Option<crate::model::VpcOutputSettingsDescription>,
}
impl DeleteChannelOutput {
    /// The unique arn of the channel.
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// Specification of CDI inputs for this channel
    pub fn cdi_input_specification(
        &self,
    ) -> std::option::Option<&crate::model::CdiInputSpecification> {
        self.cdi_input_specification.as_ref()
    }
    /// The class for this channel. STANDARD for a channel with two pipelines or SINGLE_PIPELINE for a channel with one pipeline.
    pub fn channel_class(&self) -> std::option::Option<&crate::model::ChannelClass> {
        self.channel_class.as_ref()
    }
    /// A list of destinations of the channel. For UDP outputs, there is one
    /// destination per output. For other types (HLS, for example), there is
    /// one destination per packager.
    pub fn destinations(&self) -> std::option::Option<&[crate::model::OutputDestination]> {
        self.destinations.as_deref()
    }
    /// The endpoints where outgoing connections initiate from
    pub fn egress_endpoints(&self) -> std::option::Option<&[crate::model::ChannelEgressEndpoint]> {
        self.egress_endpoints.as_deref()
    }
    /// Encoder Settings
    pub fn encoder_settings(&self) -> std::option::Option<&crate::model::EncoderSettings> {
        self.encoder_settings.as_ref()
    }
    /// The unique id of the channel.
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// List of input attachments for channel.
    pub fn input_attachments(&self) -> std::option::Option<&[crate::model::InputAttachment]> {
        self.input_attachments.as_deref()
    }
    /// Specification of network and file inputs for this channel
    pub fn input_specification(&self) -> std::option::Option<&crate::model::InputSpecification> {
        self.input_specification.as_ref()
    }
    /// The log level being written to CloudWatch Logs.
    pub fn log_level(&self) -> std::option::Option<&crate::model::LogLevel> {
        self.log_level.as_ref()
    }
    /// The name of the channel. (user-mutable)
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// Runtime details for the pipelines of a running channel.
    pub fn pipeline_details(&self) -> std::option::Option<&[crate::model::PipelineDetail]> {
        self.pipeline_details.as_deref()
    }
    /// The number of currently healthy pipelines.
    pub fn pipelines_running_count(&self) -> i32 {
        self.pipelines_running_count
    }
    /// The Amazon Resource Name (ARN) of the role assumed when running the Channel.
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// Placeholder documentation for ChannelState
    pub fn state(&self) -> std::option::Option<&crate::model::ChannelState> {
        self.state.as_ref()
    }
    /// A collection of key-value pairs.
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// Settings for VPC output
    pub fn vpc(&self) -> std::option::Option<&crate::model::VpcOutputSettingsDescription> {
        self.vpc.as_ref()
    }
}
impl std::fmt::Debug for DeleteChannelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteChannelOutput");
        formatter.field("arn", &self.arn);
        formatter.field("cdi_input_specification", &self.cdi_input_specification);
        formatter.field("channel_class", &self.channel_class);
        formatter.field("destinations", &self.destinations);
        formatter.field("egress_endpoints", &self.egress_endpoints);
        formatter.field("encoder_settings", &self.encoder_settings);
        formatter.field("id", &self.id);
        formatter.field("input_attachments", &self.input_attachments);
        formatter.field("input_specification", &self.input_specification);
        formatter.field("log_level", &self.log_level);
        formatter.field("name", &self.name);
        formatter.field("pipeline_details", &self.pipeline_details);
        formatter.field("pipelines_running_count", &self.pipelines_running_count);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("state", &self.state);
        formatter.field("tags", &self.tags);
        formatter.field("vpc", &self.vpc);
        formatter.finish()
    }
}
/// See [`DeleteChannelOutput`](crate::output::DeleteChannelOutput)
pub mod delete_channel_output {
    /// A builder for [`DeleteChannelOutput`](crate::output::DeleteChannelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) cdi_input_specification:
            std::option::Option<crate::model::CdiInputSpecification>,
        pub(crate) channel_class: std::option::Option<crate::model::ChannelClass>,
        pub(crate) destinations:
            std::option::Option<std::vec::Vec<crate::model::OutputDestination>>,
        pub(crate) egress_endpoints:
            std::option::Option<std::vec::Vec<crate::model::ChannelEgressEndpoint>>,
        pub(crate) encoder_settings: std::option::Option<crate::model::EncoderSettings>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) input_attachments:
            std::option::Option<std::vec::Vec<crate::model::InputAttachment>>,
        pub(crate) input_specification: std::option::Option<crate::model::InputSpecification>,
        pub(crate) log_level: std::option::Option<crate::model::LogLevel>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) pipeline_details:
            std::option::Option<std::vec::Vec<crate::model::PipelineDetail>>,
        pub(crate) pipelines_running_count: std::option::Option<i32>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::ChannelState>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) vpc: std::option::Option<crate::model::VpcOutputSettingsDescription>,
    }
    impl Builder {
        /// The unique arn of the channel.
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// The unique arn of the channel.
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Specification of CDI inputs for this channel
        pub fn cdi_input_specification(
            mut self,
            input: crate::model::CdiInputSpecification,
        ) -> Self {
            self.cdi_input_specification = Some(input);
            self
        }
        /// Specification of CDI inputs for this channel
        pub fn set_cdi_input_specification(
            mut self,
            input: std::option::Option<crate::model::CdiInputSpecification>,
        ) -> Self {
            self.cdi_input_specification = input;
            self
        }
        /// The class for this channel. STANDARD for a channel with two pipelines or SINGLE_PIPELINE for a channel with one pipeline.
        pub fn channel_class(mut self, input: crate::model::ChannelClass) -> Self {
            self.channel_class = Some(input);
            self
        }
        /// The class for this channel. STANDARD for a channel with two pipelines or SINGLE_PIPELINE for a channel with one pipeline.
        pub fn set_channel_class(
            mut self,
            input: std::option::Option<crate::model::ChannelClass>,
        ) -> Self {
            self.channel_class = input;
            self
        }
        /// Appends an item to `destinations`.
        ///
        /// To override the contents of this collection use [`set_destinations`](Self::set_destinations).
        ///
        /// A list of destinations of the channel. For UDP outputs, there is one
        /// destination per output. For other types (HLS, for example), there is
        /// one destination per packager.
        pub fn destinations(mut self, input: impl Into<crate::model::OutputDestination>) -> Self {
            let mut v = self.destinations.unwrap_or_default();
            v.push(input.into());
            self.destinations = Some(v);
            self
        }
        /// A list of destinations of the channel. For UDP outputs, there is one
        /// destination per output. For other types (HLS, for example), there is
        /// one destination per packager.
        pub fn set_destinations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OutputDestination>>,
        ) -> Self {
            self.destinations = input;
            self
        }
        /// Appends an item to `egress_endpoints`.
        ///
        /// To override the contents of this collection use [`set_egress_endpoints`](Self::set_egress_endpoints).
        ///
        /// The endpoints where outgoing connections initiate from
        pub fn egress_endpoints(
            mut self,
            input: impl Into<crate::model::ChannelEgressEndpoint>,
        ) -> Self {
            let mut v = self.egress_endpoints.unwrap_or_default();
            v.push(input.into());
            self.egress_endpoints = Some(v);
            self
        }
        /// The endpoints where outgoing connections initiate from
        pub fn set_egress_endpoints(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ChannelEgressEndpoint>>,
        ) -> Self {
            self.egress_endpoints = input;
            self
        }
        /// Encoder Settings
        pub fn encoder_settings(mut self, input: crate::model::EncoderSettings) -> Self {
            self.encoder_settings = Some(input);
            self
        }
        /// Encoder Settings
        pub fn set_encoder_settings(
            mut self,
            input: std::option::Option<crate::model::EncoderSettings>,
        ) -> Self {
            self.encoder_settings = input;
            self
        }
        /// The unique id of the channel.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// The unique id of the channel.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Appends an item to `input_attachments`.
        ///
        /// To override the contents of this collection use [`set_input_attachments`](Self::set_input_attachments).
        ///
        /// List of input attachments for channel.
        pub fn input_attachments(
            mut self,
            input: impl Into<crate::model::InputAttachment>,
        ) -> Self {
            let mut v = self.input_attachments.unwrap_or_default();
            v.push(input.into());
            self.input_attachments = Some(v);
            self
        }
        /// List of input attachments for channel.
        pub fn set_input_attachments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InputAttachment>>,
        ) -> Self {
            self.input_attachments = input;
            self
        }
        /// Specification of network and file inputs for this channel
        pub fn input_specification(mut self, input: crate::model::InputSpecification) -> Self {
            self.input_specification = Some(input);
            self
        }
        /// Specification of network and file inputs for this channel
        pub fn set_input_specification(
            mut self,
            input: std::option::Option<crate::model::InputSpecification>,
        ) -> Self {
            self.input_specification = input;
            self
        }
        /// The log level being written to CloudWatch Logs.
        pub fn log_level(mut self, input: crate::model::LogLevel) -> Self {
            self.log_level = Some(input);
            self
        }
        /// The log level being written to CloudWatch Logs.
        pub fn set_log_level(mut self, input: std::option::Option<crate::model::LogLevel>) -> Self {
            self.log_level = input;
            self
        }
        /// The name of the channel. (user-mutable)
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// The name of the channel. (user-mutable)
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `pipeline_details`.
        ///
        /// To override the contents of this collection use [`set_pipeline_details`](Self::set_pipeline_details).
        ///
        /// Runtime details for the pipelines of a running channel.
        pub fn pipeline_details(mut self, input: impl Into<crate::model::PipelineDetail>) -> Self {
            let mut v = self.pipeline_details.unwrap_or_default();
            v.push(input.into());
            self.pipeline_details = Some(v);
            self
        }
        /// Runtime details for the pipelines of a running channel.
        pub fn set_pipeline_details(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PipelineDetail>>,
        ) -> Self {
            self.pipeline_details = input;
            self
        }
        /// The number of currently healthy pipelines.
        pub fn pipelines_running_count(mut self, input: i32) -> Self {
            self.pipelines_running_count = Some(input);
            self
        }
        /// The number of currently healthy pipelines.
        pub fn set_pipelines_running_count(mut self, input: std::option::Option<i32>) -> Self {
            self.pipelines_running_count = input;
            self
        }
        /// The Amazon Resource Name (ARN) of the role assumed when running the Channel.
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) of the role assumed when running the Channel.
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Placeholder documentation for ChannelState
        pub fn state(mut self, input: crate::model::ChannelState) -> Self {
            self.state = Some(input);
            self
        }
        /// Placeholder documentation for ChannelState
        pub fn set_state(mut self, input: std::option::Option<crate::model::ChannelState>) -> Self {
            self.state = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of key-value pairs.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// A collection of key-value pairs.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Settings for VPC output
        pub fn vpc(mut self, input: crate::model::VpcOutputSettingsDescription) -> Self {
            self.vpc = Some(input);
            self
        }
        /// Settings for VPC output
        pub fn set_vpc(
            mut self,
            input: std::option::Option<crate::model::VpcOutputSettingsDescription>,
        ) -> Self {
            self.vpc = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteChannelOutput`](crate::output::DeleteChannelOutput)
        pub fn build(self) -> crate::output::DeleteChannelOutput {
            crate::output::DeleteChannelOutput {
                arn: self.arn,
                cdi_input_specification: self.cdi_input_specification,
                channel_class: self.channel_class,
                destinations: self.destinations,
                egress_endpoints: self.egress_endpoints,
                encoder_settings: self.encoder_settings,
                id: self.id,
                input_attachments: self.input_attachments,
                input_specification: self.input_specification,
                log_level: self.log_level,
                name: self.name,
                pipeline_details: self.pipeline_details,
                pipelines_running_count: self.pipelines_running_count.unwrap_or_default(),
                role_arn: self.role_arn,
                state: self.state,
                tags: self.tags,
                vpc: self.vpc,
            }
        }
    }
}
impl DeleteChannelOutput {
    /// Creates a new builder-style object to manufacture [`DeleteChannelOutput`](crate::output::DeleteChannelOutput)
    pub fn builder() -> crate::output::delete_channel_output::Builder {
        crate::output::delete_channel_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateTagsOutput {}
impl std::fmt::Debug for CreateTagsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateTagsOutput");
        formatter.finish()
    }
}
/// See [`CreateTagsOutput`](crate::output::CreateTagsOutput)
pub mod create_tags_output {
    /// A builder for [`CreateTagsOutput`](crate::output::CreateTagsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CreateTagsOutput`](crate::output::CreateTagsOutput)
        pub fn build(self) -> crate::output::CreateTagsOutput {
            crate::output::CreateTagsOutput {}
        }
    }
}
impl CreateTagsOutput {
    /// Creates a new builder-style object to manufacture [`CreateTagsOutput`](crate::output::CreateTagsOutput)
    pub fn builder() -> crate::output::create_tags_output::Builder {
        crate::output::create_tags_output::Builder::default()
    }
}

/// Placeholder documentation for CreatePartnerInputResponse
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePartnerInputOutput {
    /// Placeholder documentation for Input
    pub input: std::option::Option<crate::model::Input>,
}
impl CreatePartnerInputOutput {
    /// Placeholder documentation for Input
    pub fn input(&self) -> std::option::Option<&crate::model::Input> {
        self.input.as_ref()
    }
}
impl std::fmt::Debug for CreatePartnerInputOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePartnerInputOutput");
        formatter.field("input", &self.input);
        formatter.finish()
    }
}
/// See [`CreatePartnerInputOutput`](crate::output::CreatePartnerInputOutput)
pub mod create_partner_input_output {
    /// A builder for [`CreatePartnerInputOutput`](crate::output::CreatePartnerInputOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input: std::option::Option<crate::model::Input>,
    }
    impl Builder {
        /// Placeholder documentation for Input
        pub fn input(mut self, input: crate::model::Input) -> Self {
            self.input = Some(input);
            self
        }
        /// Placeholder documentation for Input
        pub fn set_input(mut self, input: std::option::Option<crate::model::Input>) -> Self {
            self.input = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePartnerInputOutput`](crate::output::CreatePartnerInputOutput)
        pub fn build(self) -> crate::output::CreatePartnerInputOutput {
            crate::output::CreatePartnerInputOutput { input: self.input }
        }
    }
}
impl CreatePartnerInputOutput {
    /// Creates a new builder-style object to manufacture [`CreatePartnerInputOutput`](crate::output::CreatePartnerInputOutput)
    pub fn builder() -> crate::output::create_partner_input_output::Builder {
        crate::output::create_partner_input_output::Builder::default()
    }
}

/// Placeholder documentation for CreateMultiplexProgramResponse
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateMultiplexProgramOutput {
    /// The newly created multiplex program.
    pub multiplex_program: std::option::Option<crate::model::MultiplexProgram>,
}
impl CreateMultiplexProgramOutput {
    /// The newly created multiplex program.
    pub fn multiplex_program(&self) -> std::option::Option<&crate::model::MultiplexProgram> {
        self.multiplex_program.as_ref()
    }
}
impl std::fmt::Debug for CreateMultiplexProgramOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateMultiplexProgramOutput");
        formatter.field("multiplex_program", &self.multiplex_program);
        formatter.finish()
    }
}
/// See [`CreateMultiplexProgramOutput`](crate::output::CreateMultiplexProgramOutput)
pub mod create_multiplex_program_output {
    /// A builder for [`CreateMultiplexProgramOutput`](crate::output::CreateMultiplexProgramOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) multiplex_program: std::option::Option<crate::model::MultiplexProgram>,
    }
    impl Builder {
        /// The newly created multiplex program.
        pub fn multiplex_program(mut self, input: crate::model::MultiplexProgram) -> Self {
            self.multiplex_program = Some(input);
            self
        }
        /// The newly created multiplex program.
        pub fn set_multiplex_program(
            mut self,
            input: std::option::Option<crate::model::MultiplexProgram>,
        ) -> Self {
            self.multiplex_program = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateMultiplexProgramOutput`](crate::output::CreateMultiplexProgramOutput)
        pub fn build(self) -> crate::output::CreateMultiplexProgramOutput {
            crate::output::CreateMultiplexProgramOutput {
                multiplex_program: self.multiplex_program,
            }
        }
    }
}
impl CreateMultiplexProgramOutput {
    /// Creates a new builder-style object to manufacture [`CreateMultiplexProgramOutput`](crate::output::CreateMultiplexProgramOutput)
    pub fn builder() -> crate::output::create_multiplex_program_output::Builder {
        crate::output::create_multiplex_program_output::Builder::default()
    }
}

/// Placeholder documentation for CreateMultiplexResponse
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateMultiplexOutput {
    /// The newly created multiplex.
    pub multiplex: std::option::Option<crate::model::Multiplex>,
}
impl CreateMultiplexOutput {
    /// The newly created multiplex.
    pub fn multiplex(&self) -> std::option::Option<&crate::model::Multiplex> {
        self.multiplex.as_ref()
    }
}
impl std::fmt::Debug for CreateMultiplexOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateMultiplexOutput");
        formatter.field("multiplex", &self.multiplex);
        formatter.finish()
    }
}
/// See [`CreateMultiplexOutput`](crate::output::CreateMultiplexOutput)
pub mod create_multiplex_output {
    /// A builder for [`CreateMultiplexOutput`](crate::output::CreateMultiplexOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) multiplex: std::option::Option<crate::model::Multiplex>,
    }
    impl Builder {
        /// The newly created multiplex.
        pub fn multiplex(mut self, input: crate::model::Multiplex) -> Self {
            self.multiplex = Some(input);
            self
        }
        /// The newly created multiplex.
        pub fn set_multiplex(
            mut self,
            input: std::option::Option<crate::model::Multiplex>,
        ) -> Self {
            self.multiplex = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateMultiplexOutput`](crate::output::CreateMultiplexOutput)
        pub fn build(self) -> crate::output::CreateMultiplexOutput {
            crate::output::CreateMultiplexOutput {
                multiplex: self.multiplex,
            }
        }
    }
}
impl CreateMultiplexOutput {
    /// Creates a new builder-style object to manufacture [`CreateMultiplexOutput`](crate::output::CreateMultiplexOutput)
    pub fn builder() -> crate::output::create_multiplex_output::Builder {
        crate::output::create_multiplex_output::Builder::default()
    }
}

/// Placeholder documentation for CreateInputSecurityGroupResponse
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateInputSecurityGroupOutput {
    /// An Input Security Group
    pub security_group: std::option::Option<crate::model::InputSecurityGroup>,
}
impl CreateInputSecurityGroupOutput {
    /// An Input Security Group
    pub fn security_group(&self) -> std::option::Option<&crate::model::InputSecurityGroup> {
        self.security_group.as_ref()
    }
}
impl std::fmt::Debug for CreateInputSecurityGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateInputSecurityGroupOutput");
        formatter.field("security_group", &self.security_group);
        formatter.finish()
    }
}
/// See [`CreateInputSecurityGroupOutput`](crate::output::CreateInputSecurityGroupOutput)
pub mod create_input_security_group_output {
    /// A builder for [`CreateInputSecurityGroupOutput`](crate::output::CreateInputSecurityGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) security_group: std::option::Option<crate::model::InputSecurityGroup>,
    }
    impl Builder {
        /// An Input Security Group
        pub fn security_group(mut self, input: crate::model::InputSecurityGroup) -> Self {
            self.security_group = Some(input);
            self
        }
        /// An Input Security Group
        pub fn set_security_group(
            mut self,
            input: std::option::Option<crate::model::InputSecurityGroup>,
        ) -> Self {
            self.security_group = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateInputSecurityGroupOutput`](crate::output::CreateInputSecurityGroupOutput)
        pub fn build(self) -> crate::output::CreateInputSecurityGroupOutput {
            crate::output::CreateInputSecurityGroupOutput {
                security_group: self.security_group,
            }
        }
    }
}
impl CreateInputSecurityGroupOutput {
    /// Creates a new builder-style object to manufacture [`CreateInputSecurityGroupOutput`](crate::output::CreateInputSecurityGroupOutput)
    pub fn builder() -> crate::output::create_input_security_group_output::Builder {
        crate::output::create_input_security_group_output::Builder::default()
    }
}

/// Placeholder documentation for CreateInputResponse
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateInputOutput {
    /// Placeholder documentation for Input
    pub input: std::option::Option<crate::model::Input>,
}
impl CreateInputOutput {
    /// Placeholder documentation for Input
    pub fn input(&self) -> std::option::Option<&crate::model::Input> {
        self.input.as_ref()
    }
}
impl std::fmt::Debug for CreateInputOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateInputOutput");
        formatter.field("input", &self.input);
        formatter.finish()
    }
}
/// See [`CreateInputOutput`](crate::output::CreateInputOutput)
pub mod create_input_output {
    /// A builder for [`CreateInputOutput`](crate::output::CreateInputOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input: std::option::Option<crate::model::Input>,
    }
    impl Builder {
        /// Placeholder documentation for Input
        pub fn input(mut self, input: crate::model::Input) -> Self {
            self.input = Some(input);
            self
        }
        /// Placeholder documentation for Input
        pub fn set_input(mut self, input: std::option::Option<crate::model::Input>) -> Self {
            self.input = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateInputOutput`](crate::output::CreateInputOutput)
        pub fn build(self) -> crate::output::CreateInputOutput {
            crate::output::CreateInputOutput { input: self.input }
        }
    }
}
impl CreateInputOutput {
    /// Creates a new builder-style object to manufacture [`CreateInputOutput`](crate::output::CreateInputOutput)
    pub fn builder() -> crate::output::create_input_output::Builder {
        crate::output::create_input_output::Builder::default()
    }
}

/// Placeholder documentation for CreateChannelResponse
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateChannelOutput {
    /// Placeholder documentation for Channel
    pub channel: std::option::Option<crate::model::Channel>,
}
impl CreateChannelOutput {
    /// Placeholder documentation for Channel
    pub fn channel(&self) -> std::option::Option<&crate::model::Channel> {
        self.channel.as_ref()
    }
}
impl std::fmt::Debug for CreateChannelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateChannelOutput");
        formatter.field("channel", &self.channel);
        formatter.finish()
    }
}
/// See [`CreateChannelOutput`](crate::output::CreateChannelOutput)
pub mod create_channel_output {
    /// A builder for [`CreateChannelOutput`](crate::output::CreateChannelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel: std::option::Option<crate::model::Channel>,
    }
    impl Builder {
        /// Placeholder documentation for Channel
        pub fn channel(mut self, input: crate::model::Channel) -> Self {
            self.channel = Some(input);
            self
        }
        /// Placeholder documentation for Channel
        pub fn set_channel(mut self, input: std::option::Option<crate::model::Channel>) -> Self {
            self.channel = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateChannelOutput`](crate::output::CreateChannelOutput)
        pub fn build(self) -> crate::output::CreateChannelOutput {
            crate::output::CreateChannelOutput {
                channel: self.channel,
            }
        }
    }
}
impl CreateChannelOutput {
    /// Creates a new builder-style object to manufacture [`CreateChannelOutput`](crate::output::CreateChannelOutput)
    pub fn builder() -> crate::output::create_channel_output::Builder {
        crate::output::create_channel_output::Builder::default()
    }
}

/// Placeholder documentation for ClaimDeviceResponse
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClaimDeviceOutput {}
impl std::fmt::Debug for ClaimDeviceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClaimDeviceOutput");
        formatter.finish()
    }
}
/// See [`ClaimDeviceOutput`](crate::output::ClaimDeviceOutput)
pub mod claim_device_output {
    /// A builder for [`ClaimDeviceOutput`](crate::output::ClaimDeviceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`ClaimDeviceOutput`](crate::output::ClaimDeviceOutput)
        pub fn build(self) -> crate::output::ClaimDeviceOutput {
            crate::output::ClaimDeviceOutput {}
        }
    }
}
impl ClaimDeviceOutput {
    /// Creates a new builder-style object to manufacture [`ClaimDeviceOutput`](crate::output::ClaimDeviceOutput)
    pub fn builder() -> crate::output::claim_device_output::Builder {
        crate::output::claim_device_output::Builder::default()
    }
}

/// Placeholder documentation for CancelInputDeviceTransferResponse
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelInputDeviceTransferOutput {}
impl std::fmt::Debug for CancelInputDeviceTransferOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelInputDeviceTransferOutput");
        formatter.finish()
    }
}
/// See [`CancelInputDeviceTransferOutput`](crate::output::CancelInputDeviceTransferOutput)
pub mod cancel_input_device_transfer_output {
    /// A builder for [`CancelInputDeviceTransferOutput`](crate::output::CancelInputDeviceTransferOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CancelInputDeviceTransferOutput`](crate::output::CancelInputDeviceTransferOutput)
        pub fn build(self) -> crate::output::CancelInputDeviceTransferOutput {
            crate::output::CancelInputDeviceTransferOutput {}
        }
    }
}
impl CancelInputDeviceTransferOutput {
    /// Creates a new builder-style object to manufacture [`CancelInputDeviceTransferOutput`](crate::output::CancelInputDeviceTransferOutput)
    pub fn builder() -> crate::output::cancel_input_device_transfer_output::Builder {
        crate::output::cancel_input_device_transfer_output::Builder::default()
    }
}

/// Placeholder documentation for BatchUpdateScheduleResponse
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchUpdateScheduleOutput {
    /// Schedule actions created in the schedule.
    pub creates: std::option::Option<crate::model::BatchScheduleActionCreateResult>,
    /// Schedule actions deleted from the schedule.
    pub deletes: std::option::Option<crate::model::BatchScheduleActionDeleteResult>,
}
impl BatchUpdateScheduleOutput {
    /// Schedule actions created in the schedule.
    pub fn creates(&self) -> std::option::Option<&crate::model::BatchScheduleActionCreateResult> {
        self.creates.as_ref()
    }
    /// Schedule actions deleted from the schedule.
    pub fn deletes(&self) -> std::option::Option<&crate::model::BatchScheduleActionDeleteResult> {
        self.deletes.as_ref()
    }
}
impl std::fmt::Debug for BatchUpdateScheduleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchUpdateScheduleOutput");
        formatter.field("creates", &self.creates);
        formatter.field("deletes", &self.deletes);
        formatter.finish()
    }
}
/// See [`BatchUpdateScheduleOutput`](crate::output::BatchUpdateScheduleOutput)
pub mod batch_update_schedule_output {
    /// A builder for [`BatchUpdateScheduleOutput`](crate::output::BatchUpdateScheduleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) creates: std::option::Option<crate::model::BatchScheduleActionCreateResult>,
        pub(crate) deletes: std::option::Option<crate::model::BatchScheduleActionDeleteResult>,
    }
    impl Builder {
        /// Schedule actions created in the schedule.
        pub fn creates(mut self, input: crate::model::BatchScheduleActionCreateResult) -> Self {
            self.creates = Some(input);
            self
        }
        /// Schedule actions created in the schedule.
        pub fn set_creates(
            mut self,
            input: std::option::Option<crate::model::BatchScheduleActionCreateResult>,
        ) -> Self {
            self.creates = input;
            self
        }
        /// Schedule actions deleted from the schedule.
        pub fn deletes(mut self, input: crate::model::BatchScheduleActionDeleteResult) -> Self {
            self.deletes = Some(input);
            self
        }
        /// Schedule actions deleted from the schedule.
        pub fn set_deletes(
            mut self,
            input: std::option::Option<crate::model::BatchScheduleActionDeleteResult>,
        ) -> Self {
            self.deletes = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchUpdateScheduleOutput`](crate::output::BatchUpdateScheduleOutput)
        pub fn build(self) -> crate::output::BatchUpdateScheduleOutput {
            crate::output::BatchUpdateScheduleOutput {
                creates: self.creates,
                deletes: self.deletes,
            }
        }
    }
}
impl BatchUpdateScheduleOutput {
    /// Creates a new builder-style object to manufacture [`BatchUpdateScheduleOutput`](crate::output::BatchUpdateScheduleOutput)
    pub fn builder() -> crate::output::batch_update_schedule_output::Builder {
        crate::output::batch_update_schedule_output::Builder::default()
    }
}

/// Placeholder documentation for BatchStopResponse
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchStopOutput {
    /// List of failed operations
    pub failed: std::option::Option<std::vec::Vec<crate::model::BatchFailedResultModel>>,
    /// List of successful operations
    pub successful: std::option::Option<std::vec::Vec<crate::model::BatchSuccessfulResultModel>>,
}
impl BatchStopOutput {
    /// List of failed operations
    pub fn failed(&self) -> std::option::Option<&[crate::model::BatchFailedResultModel]> {
        self.failed.as_deref()
    }
    /// List of successful operations
    pub fn successful(&self) -> std::option::Option<&[crate::model::BatchSuccessfulResultModel]> {
        self.successful.as_deref()
    }
}
impl std::fmt::Debug for BatchStopOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchStopOutput");
        formatter.field("failed", &self.failed);
        formatter.field("successful", &self.successful);
        formatter.finish()
    }
}
/// See [`BatchStopOutput`](crate::output::BatchStopOutput)
pub mod batch_stop_output {
    /// A builder for [`BatchStopOutput`](crate::output::BatchStopOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) failed: std::option::Option<std::vec::Vec<crate::model::BatchFailedResultModel>>,
        pub(crate) successful:
            std::option::Option<std::vec::Vec<crate::model::BatchSuccessfulResultModel>>,
    }
    impl Builder {
        /// Appends an item to `failed`.
        ///
        /// To override the contents of this collection use [`set_failed`](Self::set_failed).
        ///
        /// List of failed operations
        pub fn failed(mut self, input: impl Into<crate::model::BatchFailedResultModel>) -> Self {
            let mut v = self.failed.unwrap_or_default();
            v.push(input.into());
            self.failed = Some(v);
            self
        }
        /// List of failed operations
        pub fn set_failed(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BatchFailedResultModel>>,
        ) -> Self {
            self.failed = input;
            self
        }
        /// Appends an item to `successful`.
        ///
        /// To override the contents of this collection use [`set_successful`](Self::set_successful).
        ///
        /// List of successful operations
        pub fn successful(
            mut self,
            input: impl Into<crate::model::BatchSuccessfulResultModel>,
        ) -> Self {
            let mut v = self.successful.unwrap_or_default();
            v.push(input.into());
            self.successful = Some(v);
            self
        }
        /// List of successful operations
        pub fn set_successful(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BatchSuccessfulResultModel>>,
        ) -> Self {
            self.successful = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchStopOutput`](crate::output::BatchStopOutput)
        pub fn build(self) -> crate::output::BatchStopOutput {
            crate::output::BatchStopOutput {
                failed: self.failed,
                successful: self.successful,
            }
        }
    }
}
impl BatchStopOutput {
    /// Creates a new builder-style object to manufacture [`BatchStopOutput`](crate::output::BatchStopOutput)
    pub fn builder() -> crate::output::batch_stop_output::Builder {
        crate::output::batch_stop_output::Builder::default()
    }
}

/// Placeholder documentation for BatchStartResponse
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchStartOutput {
    /// List of failed operations
    pub failed: std::option::Option<std::vec::Vec<crate::model::BatchFailedResultModel>>,
    /// List of successful operations
    pub successful: std::option::Option<std::vec::Vec<crate::model::BatchSuccessfulResultModel>>,
}
impl BatchStartOutput {
    /// List of failed operations
    pub fn failed(&self) -> std::option::Option<&[crate::model::BatchFailedResultModel]> {
        self.failed.as_deref()
    }
    /// List of successful operations
    pub fn successful(&self) -> std::option::Option<&[crate::model::BatchSuccessfulResultModel]> {
        self.successful.as_deref()
    }
}
impl std::fmt::Debug for BatchStartOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchStartOutput");
        formatter.field("failed", &self.failed);
        formatter.field("successful", &self.successful);
        formatter.finish()
    }
}
/// See [`BatchStartOutput`](crate::output::BatchStartOutput)
pub mod batch_start_output {
    /// A builder for [`BatchStartOutput`](crate::output::BatchStartOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) failed: std::option::Option<std::vec::Vec<crate::model::BatchFailedResultModel>>,
        pub(crate) successful:
            std::option::Option<std::vec::Vec<crate::model::BatchSuccessfulResultModel>>,
    }
    impl Builder {
        /// Appends an item to `failed`.
        ///
        /// To override the contents of this collection use [`set_failed`](Self::set_failed).
        ///
        /// List of failed operations
        pub fn failed(mut self, input: impl Into<crate::model::BatchFailedResultModel>) -> Self {
            let mut v = self.failed.unwrap_or_default();
            v.push(input.into());
            self.failed = Some(v);
            self
        }
        /// List of failed operations
        pub fn set_failed(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BatchFailedResultModel>>,
        ) -> Self {
            self.failed = input;
            self
        }
        /// Appends an item to `successful`.
        ///
        /// To override the contents of this collection use [`set_successful`](Self::set_successful).
        ///
        /// List of successful operations
        pub fn successful(
            mut self,
            input: impl Into<crate::model::BatchSuccessfulResultModel>,
        ) -> Self {
            let mut v = self.successful.unwrap_or_default();
            v.push(input.into());
            self.successful = Some(v);
            self
        }
        /// List of successful operations
        pub fn set_successful(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BatchSuccessfulResultModel>>,
        ) -> Self {
            self.successful = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchStartOutput`](crate::output::BatchStartOutput)
        pub fn build(self) -> crate::output::BatchStartOutput {
            crate::output::BatchStartOutput {
                failed: self.failed,
                successful: self.successful,
            }
        }
    }
}
impl BatchStartOutput {
    /// Creates a new builder-style object to manufacture [`BatchStartOutput`](crate::output::BatchStartOutput)
    pub fn builder() -> crate::output::batch_start_output::Builder {
        crate::output::batch_start_output::Builder::default()
    }
}

/// Placeholder documentation for BatchDeleteResponse
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDeleteOutput {
    /// List of failed operations
    pub failed: std::option::Option<std::vec::Vec<crate::model::BatchFailedResultModel>>,
    /// List of successful operations
    pub successful: std::option::Option<std::vec::Vec<crate::model::BatchSuccessfulResultModel>>,
}
impl BatchDeleteOutput {
    /// List of failed operations
    pub fn failed(&self) -> std::option::Option<&[crate::model::BatchFailedResultModel]> {
        self.failed.as_deref()
    }
    /// List of successful operations
    pub fn successful(&self) -> std::option::Option<&[crate::model::BatchSuccessfulResultModel]> {
        self.successful.as_deref()
    }
}
impl std::fmt::Debug for BatchDeleteOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDeleteOutput");
        formatter.field("failed", &self.failed);
        formatter.field("successful", &self.successful);
        formatter.finish()
    }
}
/// See [`BatchDeleteOutput`](crate::output::BatchDeleteOutput)
pub mod batch_delete_output {
    /// A builder for [`BatchDeleteOutput`](crate::output::BatchDeleteOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) failed: std::option::Option<std::vec::Vec<crate::model::BatchFailedResultModel>>,
        pub(crate) successful:
            std::option::Option<std::vec::Vec<crate::model::BatchSuccessfulResultModel>>,
    }
    impl Builder {
        /// Appends an item to `failed`.
        ///
        /// To override the contents of this collection use [`set_failed`](Self::set_failed).
        ///
        /// List of failed operations
        pub fn failed(mut self, input: impl Into<crate::model::BatchFailedResultModel>) -> Self {
            let mut v = self.failed.unwrap_or_default();
            v.push(input.into());
            self.failed = Some(v);
            self
        }
        /// List of failed operations
        pub fn set_failed(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BatchFailedResultModel>>,
        ) -> Self {
            self.failed = input;
            self
        }
        /// Appends an item to `successful`.
        ///
        /// To override the contents of this collection use [`set_successful`](Self::set_successful).
        ///
        /// List of successful operations
        pub fn successful(
            mut self,
            input: impl Into<crate::model::BatchSuccessfulResultModel>,
        ) -> Self {
            let mut v = self.successful.unwrap_or_default();
            v.push(input.into());
            self.successful = Some(v);
            self
        }
        /// List of successful operations
        pub fn set_successful(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BatchSuccessfulResultModel>>,
        ) -> Self {
            self.successful = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDeleteOutput`](crate::output::BatchDeleteOutput)
        pub fn build(self) -> crate::output::BatchDeleteOutput {
            crate::output::BatchDeleteOutput {
                failed: self.failed,
                successful: self.successful,
            }
        }
    }
}
impl BatchDeleteOutput {
    /// Creates a new builder-style object to manufacture [`BatchDeleteOutput`](crate::output::BatchDeleteOutput)
    pub fn builder() -> crate::output::batch_delete_output::Builder {
        crate::output::batch_delete_output::Builder::default()
    }
}

/// Placeholder documentation for AcceptInputDeviceTransferResponse
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AcceptInputDeviceTransferOutput {}
impl std::fmt::Debug for AcceptInputDeviceTransferOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AcceptInputDeviceTransferOutput");
        formatter.finish()
    }
}
/// See [`AcceptInputDeviceTransferOutput`](crate::output::AcceptInputDeviceTransferOutput)
pub mod accept_input_device_transfer_output {
    /// A builder for [`AcceptInputDeviceTransferOutput`](crate::output::AcceptInputDeviceTransferOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AcceptInputDeviceTransferOutput`](crate::output::AcceptInputDeviceTransferOutput)
        pub fn build(self) -> crate::output::AcceptInputDeviceTransferOutput {
            crate::output::AcceptInputDeviceTransferOutput {}
        }
    }
}
impl AcceptInputDeviceTransferOutput {
    /// Creates a new builder-style object to manufacture [`AcceptInputDeviceTransferOutput`](crate::output::AcceptInputDeviceTransferOutput)
    pub fn builder() -> crate::output::accept_input_device_transfer_output::Builder {
        crate::output::accept_input_device_transfer_output::Builder::default()
    }
}
