// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AcceptInputDeviceTransfer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AcceptInputDeviceTransferError {
    /// Kind of error that occurred.
    pub kind: AcceptInputDeviceTransferErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AcceptInputDeviceTransfer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AcceptInputDeviceTransferErrorKind {
    /// Placeholder documentation for BadGatewayException
    BadGatewayException(crate::error::BadGatewayException),
    /// Placeholder documentation for BadRequestException
    BadRequestException(crate::error::BadRequestException),
    /// Placeholder documentation for ConflictException
    ConflictException(crate::error::ConflictException),
    /// Placeholder documentation for ForbiddenException
    ForbiddenException(crate::error::ForbiddenException),
    /// Placeholder documentation for GatewayTimeoutException
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// Placeholder documentation for InternalServerErrorException
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Placeholder documentation for NotFoundException
    NotFoundException(crate::error::NotFoundException),
    /// Placeholder documentation for TooManyRequestsException
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// Placeholder documentation for UnprocessableEntityException
    UnprocessableEntityException(crate::error::UnprocessableEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AcceptInputDeviceTransferError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AcceptInputDeviceTransferErrorKind::BadGatewayException(_inner) => _inner.fmt(f),
            AcceptInputDeviceTransferErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            AcceptInputDeviceTransferErrorKind::ConflictException(_inner) => _inner.fmt(f),
            AcceptInputDeviceTransferErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            AcceptInputDeviceTransferErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            AcceptInputDeviceTransferErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            AcceptInputDeviceTransferErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            AcceptInputDeviceTransferErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            AcceptInputDeviceTransferErrorKind::UnprocessableEntityException(_inner) => {
                _inner.fmt(f)
            }
            AcceptInputDeviceTransferErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AcceptInputDeviceTransferError {
    fn code(&self) -> Option<&str> {
        AcceptInputDeviceTransferError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AcceptInputDeviceTransferError {
    /// Creates a new `AcceptInputDeviceTransferError`.
    pub fn new(kind: AcceptInputDeviceTransferErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AcceptInputDeviceTransferError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AcceptInputDeviceTransferErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AcceptInputDeviceTransferError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AcceptInputDeviceTransferErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AcceptInputDeviceTransferErrorKind::BadGatewayException`.
    pub fn is_bad_gateway_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptInputDeviceTransferErrorKind::BadGatewayException(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptInputDeviceTransferErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptInputDeviceTransferErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptInputDeviceTransferErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptInputDeviceTransferErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptInputDeviceTransferErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptInputDeviceTransferErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptInputDeviceTransferErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptInputDeviceTransferErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptInputDeviceTransferErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptInputDeviceTransferErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptInputDeviceTransferErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptInputDeviceTransferErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptInputDeviceTransferErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptInputDeviceTransferErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptInputDeviceTransferErrorKind::UnprocessableEntityException`.
    pub fn is_unprocessable_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptInputDeviceTransferErrorKind::UnprocessableEntityException(_)
        )
    }
}
impl std::error::Error for AcceptInputDeviceTransferError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AcceptInputDeviceTransferErrorKind::BadGatewayException(_inner) => Some(_inner),
            AcceptInputDeviceTransferErrorKind::BadRequestException(_inner) => Some(_inner),
            AcceptInputDeviceTransferErrorKind::ConflictException(_inner) => Some(_inner),
            AcceptInputDeviceTransferErrorKind::ForbiddenException(_inner) => Some(_inner),
            AcceptInputDeviceTransferErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            AcceptInputDeviceTransferErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            AcceptInputDeviceTransferErrorKind::NotFoundException(_inner) => Some(_inner),
            AcceptInputDeviceTransferErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            AcceptInputDeviceTransferErrorKind::UnprocessableEntityException(_inner) => {
                Some(_inner)
            }
            AcceptInputDeviceTransferErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchDelete` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchDeleteError {
    /// Kind of error that occurred.
    pub kind: BatchDeleteErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchDelete` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchDeleteErrorKind {
    /// Placeholder documentation for BadGatewayException
    BadGatewayException(crate::error::BadGatewayException),
    /// Placeholder documentation for BadRequestException
    BadRequestException(crate::error::BadRequestException),
    /// Placeholder documentation for ConflictException
    ConflictException(crate::error::ConflictException),
    /// Placeholder documentation for ForbiddenException
    ForbiddenException(crate::error::ForbiddenException),
    /// Placeholder documentation for GatewayTimeoutException
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// Placeholder documentation for InternalServerErrorException
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Placeholder documentation for NotFoundException
    NotFoundException(crate::error::NotFoundException),
    /// Placeholder documentation for TooManyRequestsException
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchDeleteError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchDeleteErrorKind::BadGatewayException(_inner) => _inner.fmt(f),
            BatchDeleteErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            BatchDeleteErrorKind::ConflictException(_inner) => _inner.fmt(f),
            BatchDeleteErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            BatchDeleteErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            BatchDeleteErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            BatchDeleteErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            BatchDeleteErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            BatchDeleteErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchDeleteError {
    fn code(&self) -> Option<&str> {
        BatchDeleteError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchDeleteError {
    /// Creates a new `BatchDeleteError`.
    pub fn new(kind: BatchDeleteErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchDeleteError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchDeleteErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchDeleteError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchDeleteErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchDeleteErrorKind::BadGatewayException`.
    pub fn is_bad_gateway_exception(&self) -> bool {
        matches!(&self.kind, BatchDeleteErrorKind::BadGatewayException(_))
    }
    /// Returns `true` if the error kind is `BatchDeleteErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, BatchDeleteErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `BatchDeleteErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, BatchDeleteErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `BatchDeleteErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, BatchDeleteErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `BatchDeleteErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(&self.kind, BatchDeleteErrorKind::GatewayTimeoutException(_))
    }
    /// Returns `true` if the error kind is `BatchDeleteErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDeleteErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDeleteErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, BatchDeleteErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `BatchDeleteErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDeleteErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for BatchDeleteError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchDeleteErrorKind::BadGatewayException(_inner) => Some(_inner),
            BatchDeleteErrorKind::BadRequestException(_inner) => Some(_inner),
            BatchDeleteErrorKind::ConflictException(_inner) => Some(_inner),
            BatchDeleteErrorKind::ForbiddenException(_inner) => Some(_inner),
            BatchDeleteErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            BatchDeleteErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            BatchDeleteErrorKind::NotFoundException(_inner) => Some(_inner),
            BatchDeleteErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            BatchDeleteErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchStart` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchStartError {
    /// Kind of error that occurred.
    pub kind: BatchStartErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchStart` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchStartErrorKind {
    /// Placeholder documentation for BadGatewayException
    BadGatewayException(crate::error::BadGatewayException),
    /// Placeholder documentation for BadRequestException
    BadRequestException(crate::error::BadRequestException),
    /// Placeholder documentation for ConflictException
    ConflictException(crate::error::ConflictException),
    /// Placeholder documentation for ForbiddenException
    ForbiddenException(crate::error::ForbiddenException),
    /// Placeholder documentation for GatewayTimeoutException
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// Placeholder documentation for InternalServerErrorException
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Placeholder documentation for NotFoundException
    NotFoundException(crate::error::NotFoundException),
    /// Placeholder documentation for TooManyRequestsException
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchStartError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchStartErrorKind::BadGatewayException(_inner) => _inner.fmt(f),
            BatchStartErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            BatchStartErrorKind::ConflictException(_inner) => _inner.fmt(f),
            BatchStartErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            BatchStartErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            BatchStartErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            BatchStartErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            BatchStartErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            BatchStartErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchStartError {
    fn code(&self) -> Option<&str> {
        BatchStartError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchStartError {
    /// Creates a new `BatchStartError`.
    pub fn new(kind: BatchStartErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchStartError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchStartErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchStartError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchStartErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchStartErrorKind::BadGatewayException`.
    pub fn is_bad_gateway_exception(&self) -> bool {
        matches!(&self.kind, BatchStartErrorKind::BadGatewayException(_))
    }
    /// Returns `true` if the error kind is `BatchStartErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, BatchStartErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `BatchStartErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, BatchStartErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `BatchStartErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, BatchStartErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `BatchStartErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(&self.kind, BatchStartErrorKind::GatewayTimeoutException(_))
    }
    /// Returns `true` if the error kind is `BatchStartErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchStartErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchStartErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, BatchStartErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `BatchStartErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, BatchStartErrorKind::TooManyRequestsException(_))
    }
}
impl std::error::Error for BatchStartError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchStartErrorKind::BadGatewayException(_inner) => Some(_inner),
            BatchStartErrorKind::BadRequestException(_inner) => Some(_inner),
            BatchStartErrorKind::ConflictException(_inner) => Some(_inner),
            BatchStartErrorKind::ForbiddenException(_inner) => Some(_inner),
            BatchStartErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            BatchStartErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            BatchStartErrorKind::NotFoundException(_inner) => Some(_inner),
            BatchStartErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            BatchStartErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchStop` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchStopError {
    /// Kind of error that occurred.
    pub kind: BatchStopErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchStop` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchStopErrorKind {
    /// Placeholder documentation for BadGatewayException
    BadGatewayException(crate::error::BadGatewayException),
    /// Placeholder documentation for BadRequestException
    BadRequestException(crate::error::BadRequestException),
    /// Placeholder documentation for ConflictException
    ConflictException(crate::error::ConflictException),
    /// Placeholder documentation for ForbiddenException
    ForbiddenException(crate::error::ForbiddenException),
    /// Placeholder documentation for GatewayTimeoutException
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// Placeholder documentation for InternalServerErrorException
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Placeholder documentation for NotFoundException
    NotFoundException(crate::error::NotFoundException),
    /// Placeholder documentation for TooManyRequestsException
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchStopError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchStopErrorKind::BadGatewayException(_inner) => _inner.fmt(f),
            BatchStopErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            BatchStopErrorKind::ConflictException(_inner) => _inner.fmt(f),
            BatchStopErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            BatchStopErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            BatchStopErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            BatchStopErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            BatchStopErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            BatchStopErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchStopError {
    fn code(&self) -> Option<&str> {
        BatchStopError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchStopError {
    /// Creates a new `BatchStopError`.
    pub fn new(kind: BatchStopErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchStopError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchStopErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchStopError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchStopErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchStopErrorKind::BadGatewayException`.
    pub fn is_bad_gateway_exception(&self) -> bool {
        matches!(&self.kind, BatchStopErrorKind::BadGatewayException(_))
    }
    /// Returns `true` if the error kind is `BatchStopErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, BatchStopErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `BatchStopErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, BatchStopErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `BatchStopErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, BatchStopErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `BatchStopErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(&self.kind, BatchStopErrorKind::GatewayTimeoutException(_))
    }
    /// Returns `true` if the error kind is `BatchStopErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchStopErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchStopErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, BatchStopErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `BatchStopErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, BatchStopErrorKind::TooManyRequestsException(_))
    }
}
impl std::error::Error for BatchStopError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchStopErrorKind::BadGatewayException(_inner) => Some(_inner),
            BatchStopErrorKind::BadRequestException(_inner) => Some(_inner),
            BatchStopErrorKind::ConflictException(_inner) => Some(_inner),
            BatchStopErrorKind::ForbiddenException(_inner) => Some(_inner),
            BatchStopErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            BatchStopErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            BatchStopErrorKind::NotFoundException(_inner) => Some(_inner),
            BatchStopErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            BatchStopErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchUpdateSchedule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchUpdateScheduleError {
    /// Kind of error that occurred.
    pub kind: BatchUpdateScheduleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchUpdateSchedule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchUpdateScheduleErrorKind {
    /// Placeholder documentation for BadGatewayException
    BadGatewayException(crate::error::BadGatewayException),
    /// Placeholder documentation for BadRequestException
    BadRequestException(crate::error::BadRequestException),
    /// Placeholder documentation for ForbiddenException
    ForbiddenException(crate::error::ForbiddenException),
    /// Placeholder documentation for GatewayTimeoutException
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// Placeholder documentation for InternalServerErrorException
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Placeholder documentation for NotFoundException
    NotFoundException(crate::error::NotFoundException),
    /// Placeholder documentation for TooManyRequestsException
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// Placeholder documentation for UnprocessableEntityException
    UnprocessableEntityException(crate::error::UnprocessableEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchUpdateScheduleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchUpdateScheduleErrorKind::BadGatewayException(_inner) => _inner.fmt(f),
            BatchUpdateScheduleErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            BatchUpdateScheduleErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            BatchUpdateScheduleErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            BatchUpdateScheduleErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            BatchUpdateScheduleErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            BatchUpdateScheduleErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            BatchUpdateScheduleErrorKind::UnprocessableEntityException(_inner) => _inner.fmt(f),
            BatchUpdateScheduleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchUpdateScheduleError {
    fn code(&self) -> Option<&str> {
        BatchUpdateScheduleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchUpdateScheduleError {
    /// Creates a new `BatchUpdateScheduleError`.
    pub fn new(kind: BatchUpdateScheduleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchUpdateScheduleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchUpdateScheduleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchUpdateScheduleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchUpdateScheduleErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchUpdateScheduleErrorKind::BadGatewayException`.
    pub fn is_bad_gateway_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchUpdateScheduleErrorKind::BadGatewayException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchUpdateScheduleErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchUpdateScheduleErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchUpdateScheduleErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchUpdateScheduleErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchUpdateScheduleErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchUpdateScheduleErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchUpdateScheduleErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchUpdateScheduleErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchUpdateScheduleErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchUpdateScheduleErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchUpdateScheduleErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchUpdateScheduleErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchUpdateScheduleErrorKind::UnprocessableEntityException`.
    pub fn is_unprocessable_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchUpdateScheduleErrorKind::UnprocessableEntityException(_)
        )
    }
}
impl std::error::Error for BatchUpdateScheduleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchUpdateScheduleErrorKind::BadGatewayException(_inner) => Some(_inner),
            BatchUpdateScheduleErrorKind::BadRequestException(_inner) => Some(_inner),
            BatchUpdateScheduleErrorKind::ForbiddenException(_inner) => Some(_inner),
            BatchUpdateScheduleErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            BatchUpdateScheduleErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            BatchUpdateScheduleErrorKind::NotFoundException(_inner) => Some(_inner),
            BatchUpdateScheduleErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            BatchUpdateScheduleErrorKind::UnprocessableEntityException(_inner) => Some(_inner),
            BatchUpdateScheduleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CancelInputDeviceTransfer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CancelInputDeviceTransferError {
    /// Kind of error that occurred.
    pub kind: CancelInputDeviceTransferErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CancelInputDeviceTransfer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CancelInputDeviceTransferErrorKind {
    /// Placeholder documentation for BadGatewayException
    BadGatewayException(crate::error::BadGatewayException),
    /// Placeholder documentation for BadRequestException
    BadRequestException(crate::error::BadRequestException),
    /// Placeholder documentation for ConflictException
    ConflictException(crate::error::ConflictException),
    /// Placeholder documentation for ForbiddenException
    ForbiddenException(crate::error::ForbiddenException),
    /// Placeholder documentation for GatewayTimeoutException
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// Placeholder documentation for InternalServerErrorException
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Placeholder documentation for NotFoundException
    NotFoundException(crate::error::NotFoundException),
    /// Placeholder documentation for TooManyRequestsException
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// Placeholder documentation for UnprocessableEntityException
    UnprocessableEntityException(crate::error::UnprocessableEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CancelInputDeviceTransferError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CancelInputDeviceTransferErrorKind::BadGatewayException(_inner) => _inner.fmt(f),
            CancelInputDeviceTransferErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CancelInputDeviceTransferErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CancelInputDeviceTransferErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CancelInputDeviceTransferErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            CancelInputDeviceTransferErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            CancelInputDeviceTransferErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CancelInputDeviceTransferErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CancelInputDeviceTransferErrorKind::UnprocessableEntityException(_inner) => {
                _inner.fmt(f)
            }
            CancelInputDeviceTransferErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CancelInputDeviceTransferError {
    fn code(&self) -> Option<&str> {
        CancelInputDeviceTransferError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CancelInputDeviceTransferError {
    /// Creates a new `CancelInputDeviceTransferError`.
    pub fn new(kind: CancelInputDeviceTransferErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CancelInputDeviceTransferError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CancelInputDeviceTransferErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CancelInputDeviceTransferError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CancelInputDeviceTransferErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CancelInputDeviceTransferErrorKind::BadGatewayException`.
    pub fn is_bad_gateway_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelInputDeviceTransferErrorKind::BadGatewayException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelInputDeviceTransferErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelInputDeviceTransferErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelInputDeviceTransferErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelInputDeviceTransferErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelInputDeviceTransferErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelInputDeviceTransferErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelInputDeviceTransferErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelInputDeviceTransferErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelInputDeviceTransferErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelInputDeviceTransferErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelInputDeviceTransferErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelInputDeviceTransferErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelInputDeviceTransferErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelInputDeviceTransferErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelInputDeviceTransferErrorKind::UnprocessableEntityException`.
    pub fn is_unprocessable_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelInputDeviceTransferErrorKind::UnprocessableEntityException(_)
        )
    }
}
impl std::error::Error for CancelInputDeviceTransferError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CancelInputDeviceTransferErrorKind::BadGatewayException(_inner) => Some(_inner),
            CancelInputDeviceTransferErrorKind::BadRequestException(_inner) => Some(_inner),
            CancelInputDeviceTransferErrorKind::ConflictException(_inner) => Some(_inner),
            CancelInputDeviceTransferErrorKind::ForbiddenException(_inner) => Some(_inner),
            CancelInputDeviceTransferErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            CancelInputDeviceTransferErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            CancelInputDeviceTransferErrorKind::NotFoundException(_inner) => Some(_inner),
            CancelInputDeviceTransferErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CancelInputDeviceTransferErrorKind::UnprocessableEntityException(_inner) => {
                Some(_inner)
            }
            CancelInputDeviceTransferErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ClaimDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ClaimDeviceError {
    /// Kind of error that occurred.
    pub kind: ClaimDeviceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ClaimDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ClaimDeviceErrorKind {
    /// Placeholder documentation for BadGatewayException
    BadGatewayException(crate::error::BadGatewayException),
    /// Placeholder documentation for BadRequestException
    BadRequestException(crate::error::BadRequestException),
    /// Placeholder documentation for ForbiddenException
    ForbiddenException(crate::error::ForbiddenException),
    /// Placeholder documentation for GatewayTimeoutException
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// Placeholder documentation for InternalServerErrorException
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Placeholder documentation for NotFoundException
    NotFoundException(crate::error::NotFoundException),
    /// Placeholder documentation for TooManyRequestsException
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// Placeholder documentation for UnprocessableEntityException
    UnprocessableEntityException(crate::error::UnprocessableEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ClaimDeviceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ClaimDeviceErrorKind::BadGatewayException(_inner) => _inner.fmt(f),
            ClaimDeviceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ClaimDeviceErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ClaimDeviceErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            ClaimDeviceErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ClaimDeviceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ClaimDeviceErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ClaimDeviceErrorKind::UnprocessableEntityException(_inner) => _inner.fmt(f),
            ClaimDeviceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ClaimDeviceError {
    fn code(&self) -> Option<&str> {
        ClaimDeviceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ClaimDeviceError {
    /// Creates a new `ClaimDeviceError`.
    pub fn new(kind: ClaimDeviceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ClaimDeviceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ClaimDeviceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ClaimDeviceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ClaimDeviceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ClaimDeviceErrorKind::BadGatewayException`.
    pub fn is_bad_gateway_exception(&self) -> bool {
        matches!(&self.kind, ClaimDeviceErrorKind::BadGatewayException(_))
    }
    /// Returns `true` if the error kind is `ClaimDeviceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ClaimDeviceErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `ClaimDeviceErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, ClaimDeviceErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `ClaimDeviceErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(&self.kind, ClaimDeviceErrorKind::GatewayTimeoutException(_))
    }
    /// Returns `true` if the error kind is `ClaimDeviceErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ClaimDeviceErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ClaimDeviceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ClaimDeviceErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `ClaimDeviceErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ClaimDeviceErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `ClaimDeviceErrorKind::UnprocessableEntityException`.
    pub fn is_unprocessable_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            ClaimDeviceErrorKind::UnprocessableEntityException(_)
        )
    }
}
impl std::error::Error for ClaimDeviceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ClaimDeviceErrorKind::BadGatewayException(_inner) => Some(_inner),
            ClaimDeviceErrorKind::BadRequestException(_inner) => Some(_inner),
            ClaimDeviceErrorKind::ForbiddenException(_inner) => Some(_inner),
            ClaimDeviceErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            ClaimDeviceErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ClaimDeviceErrorKind::NotFoundException(_inner) => Some(_inner),
            ClaimDeviceErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ClaimDeviceErrorKind::UnprocessableEntityException(_inner) => Some(_inner),
            ClaimDeviceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateChannelError {
    /// Kind of error that occurred.
    pub kind: CreateChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateChannelErrorKind {
    /// Placeholder documentation for BadGatewayException
    BadGatewayException(crate::error::BadGatewayException),
    /// Placeholder documentation for BadRequestException
    BadRequestException(crate::error::BadRequestException),
    /// Placeholder documentation for ConflictException
    ConflictException(crate::error::ConflictException),
    /// Placeholder documentation for ForbiddenException
    ForbiddenException(crate::error::ForbiddenException),
    /// Placeholder documentation for GatewayTimeoutException
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// Placeholder documentation for InternalServerErrorException
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Placeholder documentation for TooManyRequestsException
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// Placeholder documentation for UnprocessableEntityException
    UnprocessableEntityException(crate::error::UnprocessableEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateChannelErrorKind::BadGatewayException(_inner) => _inner.fmt(f),
            CreateChannelErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateChannelErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateChannelErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateChannelErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            CreateChannelErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            CreateChannelErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateChannelErrorKind::UnprocessableEntityException(_inner) => _inner.fmt(f),
            CreateChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateChannelError {
    fn code(&self) -> Option<&str> {
        CreateChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateChannelError {
    /// Creates a new `CreateChannelError`.
    pub fn new(kind: CreateChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateChannelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateChannelErrorKind::BadGatewayException`.
    pub fn is_bad_gateway_exception(&self) -> bool {
        matches!(&self.kind, CreateChannelErrorKind::BadGatewayException(_))
    }
    /// Returns `true` if the error kind is `CreateChannelErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreateChannelErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `CreateChannelErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateChannelErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateChannelErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, CreateChannelErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `CreateChannelErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateChannelErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateChannelErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateChannelErrorKind::UnprocessableEntityException`.
    pub fn is_unprocessable_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelErrorKind::UnprocessableEntityException(_)
        )
    }
}
impl std::error::Error for CreateChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateChannelErrorKind::BadGatewayException(_inner) => Some(_inner),
            CreateChannelErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateChannelErrorKind::ConflictException(_inner) => Some(_inner),
            CreateChannelErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateChannelErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            CreateChannelErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            CreateChannelErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateChannelErrorKind::UnprocessableEntityException(_inner) => Some(_inner),
            CreateChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateInput` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateInputError {
    /// Kind of error that occurred.
    pub kind: CreateInputErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateInput` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateInputErrorKind {
    /// Placeholder documentation for BadGatewayException
    BadGatewayException(crate::error::BadGatewayException),
    /// Placeholder documentation for BadRequestException
    BadRequestException(crate::error::BadRequestException),
    /// Placeholder documentation for ForbiddenException
    ForbiddenException(crate::error::ForbiddenException),
    /// Placeholder documentation for GatewayTimeoutException
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// Placeholder documentation for InternalServerErrorException
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Placeholder documentation for TooManyRequestsException
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateInputError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateInputErrorKind::BadGatewayException(_inner) => _inner.fmt(f),
            CreateInputErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateInputErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateInputErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            CreateInputErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            CreateInputErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateInputErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateInputError {
    fn code(&self) -> Option<&str> {
        CreateInputError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateInputError {
    /// Creates a new `CreateInputError`.
    pub fn new(kind: CreateInputErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateInputError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateInputErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateInputError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateInputErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateInputErrorKind::BadGatewayException`.
    pub fn is_bad_gateway_exception(&self) -> bool {
        matches!(&self.kind, CreateInputErrorKind::BadGatewayException(_))
    }
    /// Returns `true` if the error kind is `CreateInputErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreateInputErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `CreateInputErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, CreateInputErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `CreateInputErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(&self.kind, CreateInputErrorKind::GatewayTimeoutException(_))
    }
    /// Returns `true` if the error kind is `CreateInputErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateInputErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateInputErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateInputErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreateInputError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateInputErrorKind::BadGatewayException(_inner) => Some(_inner),
            CreateInputErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateInputErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateInputErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            CreateInputErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            CreateInputErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateInputErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateInputSecurityGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateInputSecurityGroupError {
    /// Kind of error that occurred.
    pub kind: CreateInputSecurityGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateInputSecurityGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateInputSecurityGroupErrorKind {
    /// Placeholder documentation for BadGatewayException
    BadGatewayException(crate::error::BadGatewayException),
    /// Placeholder documentation for BadRequestException
    BadRequestException(crate::error::BadRequestException),
    /// Placeholder documentation for ForbiddenException
    ForbiddenException(crate::error::ForbiddenException),
    /// Placeholder documentation for GatewayTimeoutException
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// Placeholder documentation for InternalServerErrorException
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Placeholder documentation for TooManyRequestsException
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateInputSecurityGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateInputSecurityGroupErrorKind::BadGatewayException(_inner) => _inner.fmt(f),
            CreateInputSecurityGroupErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateInputSecurityGroupErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateInputSecurityGroupErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            CreateInputSecurityGroupErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            CreateInputSecurityGroupErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateInputSecurityGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateInputSecurityGroupError {
    fn code(&self) -> Option<&str> {
        CreateInputSecurityGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateInputSecurityGroupError {
    /// Creates a new `CreateInputSecurityGroupError`.
    pub fn new(kind: CreateInputSecurityGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateInputSecurityGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateInputSecurityGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateInputSecurityGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateInputSecurityGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateInputSecurityGroupErrorKind::BadGatewayException`.
    pub fn is_bad_gateway_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateInputSecurityGroupErrorKind::BadGatewayException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateInputSecurityGroupErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateInputSecurityGroupErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateInputSecurityGroupErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateInputSecurityGroupErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateInputSecurityGroupErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateInputSecurityGroupErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateInputSecurityGroupErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateInputSecurityGroupErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateInputSecurityGroupErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateInputSecurityGroupErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreateInputSecurityGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateInputSecurityGroupErrorKind::BadGatewayException(_inner) => Some(_inner),
            CreateInputSecurityGroupErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateInputSecurityGroupErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateInputSecurityGroupErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            CreateInputSecurityGroupErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            CreateInputSecurityGroupErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateInputSecurityGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateMultiplex` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateMultiplexError {
    /// Kind of error that occurred.
    pub kind: CreateMultiplexErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateMultiplex` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateMultiplexErrorKind {
    /// Placeholder documentation for BadGatewayException
    BadGatewayException(crate::error::BadGatewayException),
    /// Placeholder documentation for BadRequestException
    BadRequestException(crate::error::BadRequestException),
    /// Placeholder documentation for ConflictException
    ConflictException(crate::error::ConflictException),
    /// Placeholder documentation for ForbiddenException
    ForbiddenException(crate::error::ForbiddenException),
    /// Placeholder documentation for GatewayTimeoutException
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// Placeholder documentation for InternalServerErrorException
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Placeholder documentation for TooManyRequestsException
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// Placeholder documentation for UnprocessableEntityException
    UnprocessableEntityException(crate::error::UnprocessableEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateMultiplexError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateMultiplexErrorKind::BadGatewayException(_inner) => _inner.fmt(f),
            CreateMultiplexErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateMultiplexErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateMultiplexErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateMultiplexErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            CreateMultiplexErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            CreateMultiplexErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateMultiplexErrorKind::UnprocessableEntityException(_inner) => _inner.fmt(f),
            CreateMultiplexErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateMultiplexError {
    fn code(&self) -> Option<&str> {
        CreateMultiplexError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateMultiplexError {
    /// Creates a new `CreateMultiplexError`.
    pub fn new(kind: CreateMultiplexErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateMultiplexError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateMultiplexErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateMultiplexError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateMultiplexErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateMultiplexErrorKind::BadGatewayException`.
    pub fn is_bad_gateway_exception(&self) -> bool {
        matches!(&self.kind, CreateMultiplexErrorKind::BadGatewayException(_))
    }
    /// Returns `true` if the error kind is `CreateMultiplexErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreateMultiplexErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `CreateMultiplexErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateMultiplexErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateMultiplexErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, CreateMultiplexErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `CreateMultiplexErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMultiplexErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMultiplexErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMultiplexErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMultiplexErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMultiplexErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMultiplexErrorKind::UnprocessableEntityException`.
    pub fn is_unprocessable_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMultiplexErrorKind::UnprocessableEntityException(_)
        )
    }
}
impl std::error::Error for CreateMultiplexError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateMultiplexErrorKind::BadGatewayException(_inner) => Some(_inner),
            CreateMultiplexErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateMultiplexErrorKind::ConflictException(_inner) => Some(_inner),
            CreateMultiplexErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateMultiplexErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            CreateMultiplexErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            CreateMultiplexErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateMultiplexErrorKind::UnprocessableEntityException(_inner) => Some(_inner),
            CreateMultiplexErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateMultiplexProgram` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateMultiplexProgramError {
    /// Kind of error that occurred.
    pub kind: CreateMultiplexProgramErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateMultiplexProgram` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateMultiplexProgramErrorKind {
    /// Placeholder documentation for BadGatewayException
    BadGatewayException(crate::error::BadGatewayException),
    /// Placeholder documentation for BadRequestException
    BadRequestException(crate::error::BadRequestException),
    /// Placeholder documentation for ConflictException
    ConflictException(crate::error::ConflictException),
    /// Placeholder documentation for ForbiddenException
    ForbiddenException(crate::error::ForbiddenException),
    /// Placeholder documentation for GatewayTimeoutException
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// Placeholder documentation for InternalServerErrorException
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Placeholder documentation for TooManyRequestsException
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// Placeholder documentation for UnprocessableEntityException
    UnprocessableEntityException(crate::error::UnprocessableEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateMultiplexProgramError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateMultiplexProgramErrorKind::BadGatewayException(_inner) => _inner.fmt(f),
            CreateMultiplexProgramErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateMultiplexProgramErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateMultiplexProgramErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateMultiplexProgramErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            CreateMultiplexProgramErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            CreateMultiplexProgramErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateMultiplexProgramErrorKind::UnprocessableEntityException(_inner) => _inner.fmt(f),
            CreateMultiplexProgramErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateMultiplexProgramError {
    fn code(&self) -> Option<&str> {
        CreateMultiplexProgramError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateMultiplexProgramError {
    /// Creates a new `CreateMultiplexProgramError`.
    pub fn new(kind: CreateMultiplexProgramErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateMultiplexProgramError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateMultiplexProgramErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateMultiplexProgramError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateMultiplexProgramErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateMultiplexProgramErrorKind::BadGatewayException`.
    pub fn is_bad_gateway_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMultiplexProgramErrorKind::BadGatewayException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMultiplexProgramErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMultiplexProgramErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMultiplexProgramErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMultiplexProgramErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMultiplexProgramErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMultiplexProgramErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMultiplexProgramErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMultiplexProgramErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMultiplexProgramErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMultiplexProgramErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMultiplexProgramErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMultiplexProgramErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMultiplexProgramErrorKind::UnprocessableEntityException`.
    pub fn is_unprocessable_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMultiplexProgramErrorKind::UnprocessableEntityException(_)
        )
    }
}
impl std::error::Error for CreateMultiplexProgramError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateMultiplexProgramErrorKind::BadGatewayException(_inner) => Some(_inner),
            CreateMultiplexProgramErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateMultiplexProgramErrorKind::ConflictException(_inner) => Some(_inner),
            CreateMultiplexProgramErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateMultiplexProgramErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            CreateMultiplexProgramErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            CreateMultiplexProgramErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateMultiplexProgramErrorKind::UnprocessableEntityException(_inner) => Some(_inner),
            CreateMultiplexProgramErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreatePartnerInput` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreatePartnerInputError {
    /// Kind of error that occurred.
    pub kind: CreatePartnerInputErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreatePartnerInput` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreatePartnerInputErrorKind {
    /// Placeholder documentation for BadGatewayException
    BadGatewayException(crate::error::BadGatewayException),
    /// Placeholder documentation for BadRequestException
    BadRequestException(crate::error::BadRequestException),
    /// Placeholder documentation for ForbiddenException
    ForbiddenException(crate::error::ForbiddenException),
    /// Placeholder documentation for GatewayTimeoutException
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// Placeholder documentation for InternalServerErrorException
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Placeholder documentation for TooManyRequestsException
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreatePartnerInputError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreatePartnerInputErrorKind::BadGatewayException(_inner) => _inner.fmt(f),
            CreatePartnerInputErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreatePartnerInputErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreatePartnerInputErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            CreatePartnerInputErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            CreatePartnerInputErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreatePartnerInputErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreatePartnerInputError {
    fn code(&self) -> Option<&str> {
        CreatePartnerInputError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreatePartnerInputError {
    /// Creates a new `CreatePartnerInputError`.
    pub fn new(kind: CreatePartnerInputErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreatePartnerInputError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreatePartnerInputErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreatePartnerInputError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreatePartnerInputErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreatePartnerInputErrorKind::BadGatewayException`.
    pub fn is_bad_gateway_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePartnerInputErrorKind::BadGatewayException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePartnerInputErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePartnerInputErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePartnerInputErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePartnerInputErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePartnerInputErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePartnerInputErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePartnerInputErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePartnerInputErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePartnerInputErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePartnerInputErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreatePartnerInputError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreatePartnerInputErrorKind::BadGatewayException(_inner) => Some(_inner),
            CreatePartnerInputErrorKind::BadRequestException(_inner) => Some(_inner),
            CreatePartnerInputErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreatePartnerInputErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            CreatePartnerInputErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            CreatePartnerInputErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreatePartnerInputErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateTagsError {
    /// Kind of error that occurred.
    pub kind: CreateTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateTagsErrorKind {
    /// Placeholder documentation for BadRequestException
    BadRequestException(crate::error::BadRequestException),
    /// Placeholder documentation for ForbiddenException
    ForbiddenException(crate::error::ForbiddenException),
    /// Placeholder documentation for InternalServerErrorException
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Placeholder documentation for NotFoundException
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateTagsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateTagsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateTagsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            CreateTagsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateTagsError {
    fn code(&self) -> Option<&str> {
        CreateTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateTagsError {
    /// Creates a new `CreateTagsError`.
    pub fn new(kind: CreateTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateTagsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateTagsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreateTagsErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `CreateTagsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, CreateTagsErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `CreateTagsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTagsErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTagsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateTagsErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for CreateTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateTagsErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateTagsErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateTagsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            CreateTagsErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteChannelError {
    /// Kind of error that occurred.
    pub kind: DeleteChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteChannelErrorKind {
    /// Placeholder documentation for BadGatewayException
    BadGatewayException(crate::error::BadGatewayException),
    /// Placeholder documentation for BadRequestException
    BadRequestException(crate::error::BadRequestException),
    /// Placeholder documentation for ConflictException
    ConflictException(crate::error::ConflictException),
    /// Placeholder documentation for ForbiddenException
    ForbiddenException(crate::error::ForbiddenException),
    /// Placeholder documentation for GatewayTimeoutException
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// Placeholder documentation for InternalServerErrorException
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Placeholder documentation for NotFoundException
    NotFoundException(crate::error::NotFoundException),
    /// Placeholder documentation for TooManyRequestsException
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteChannelErrorKind::BadGatewayException(_inner) => _inner.fmt(f),
            DeleteChannelErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteChannelErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteChannelErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteChannelErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            DeleteChannelErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeleteChannelErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteChannelErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteChannelError {
    fn code(&self) -> Option<&str> {
        DeleteChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteChannelError {
    /// Creates a new `DeleteChannelError`.
    pub fn new(kind: DeleteChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteChannelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteChannelErrorKind::BadGatewayException`.
    pub fn is_bad_gateway_exception(&self) -> bool {
        matches!(&self.kind, DeleteChannelErrorKind::BadGatewayException(_))
    }
    /// Returns `true` if the error kind is `DeleteChannelErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteChannelErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `DeleteChannelErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteChannelErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteChannelErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, DeleteChannelErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `DeleteChannelErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteChannelErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteChannelErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteChannelErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeleteChannelErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteChannelErrorKind::BadGatewayException(_inner) => Some(_inner),
            DeleteChannelErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteChannelErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteChannelErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteChannelErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            DeleteChannelErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteChannelErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteChannelErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteInput` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteInputError {
    /// Kind of error that occurred.
    pub kind: DeleteInputErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteInput` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteInputErrorKind {
    /// Placeholder documentation for BadGatewayException
    BadGatewayException(crate::error::BadGatewayException),
    /// Placeholder documentation for BadRequestException
    BadRequestException(crate::error::BadRequestException),
    /// Placeholder documentation for ConflictException
    ConflictException(crate::error::ConflictException),
    /// Placeholder documentation for ForbiddenException
    ForbiddenException(crate::error::ForbiddenException),
    /// Placeholder documentation for GatewayTimeoutException
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// Placeholder documentation for InternalServerErrorException
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Placeholder documentation for NotFoundException
    NotFoundException(crate::error::NotFoundException),
    /// Placeholder documentation for TooManyRequestsException
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteInputError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteInputErrorKind::BadGatewayException(_inner) => _inner.fmt(f),
            DeleteInputErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteInputErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteInputErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteInputErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            DeleteInputErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeleteInputErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteInputErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteInputErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteInputError {
    fn code(&self) -> Option<&str> {
        DeleteInputError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteInputError {
    /// Creates a new `DeleteInputError`.
    pub fn new(kind: DeleteInputErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteInputError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteInputErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteInputError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteInputErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteInputErrorKind::BadGatewayException`.
    pub fn is_bad_gateway_exception(&self) -> bool {
        matches!(&self.kind, DeleteInputErrorKind::BadGatewayException(_))
    }
    /// Returns `true` if the error kind is `DeleteInputErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteInputErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `DeleteInputErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteInputErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteInputErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, DeleteInputErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `DeleteInputErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(&self.kind, DeleteInputErrorKind::GatewayTimeoutException(_))
    }
    /// Returns `true` if the error kind is `DeleteInputErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInputErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteInputErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteInputErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeleteInputErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInputErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteInputError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteInputErrorKind::BadGatewayException(_inner) => Some(_inner),
            DeleteInputErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteInputErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteInputErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteInputErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            DeleteInputErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteInputErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteInputErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteInputErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteInputSecurityGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteInputSecurityGroupError {
    /// Kind of error that occurred.
    pub kind: DeleteInputSecurityGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteInputSecurityGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteInputSecurityGroupErrorKind {
    /// Placeholder documentation for BadGatewayException
    BadGatewayException(crate::error::BadGatewayException),
    /// Placeholder documentation for BadRequestException
    BadRequestException(crate::error::BadRequestException),
    /// Placeholder documentation for ForbiddenException
    ForbiddenException(crate::error::ForbiddenException),
    /// Placeholder documentation for GatewayTimeoutException
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// Placeholder documentation for InternalServerErrorException
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Placeholder documentation for NotFoundException
    NotFoundException(crate::error::NotFoundException),
    /// Placeholder documentation for TooManyRequestsException
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteInputSecurityGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteInputSecurityGroupErrorKind::BadGatewayException(_inner) => _inner.fmt(f),
            DeleteInputSecurityGroupErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteInputSecurityGroupErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteInputSecurityGroupErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            DeleteInputSecurityGroupErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            DeleteInputSecurityGroupErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteInputSecurityGroupErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteInputSecurityGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteInputSecurityGroupError {
    fn code(&self) -> Option<&str> {
        DeleteInputSecurityGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteInputSecurityGroupError {
    /// Creates a new `DeleteInputSecurityGroupError`.
    pub fn new(kind: DeleteInputSecurityGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteInputSecurityGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteInputSecurityGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteInputSecurityGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteInputSecurityGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteInputSecurityGroupErrorKind::BadGatewayException`.
    pub fn is_bad_gateway_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInputSecurityGroupErrorKind::BadGatewayException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteInputSecurityGroupErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInputSecurityGroupErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteInputSecurityGroupErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInputSecurityGroupErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteInputSecurityGroupErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInputSecurityGroupErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteInputSecurityGroupErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInputSecurityGroupErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteInputSecurityGroupErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInputSecurityGroupErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteInputSecurityGroupErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInputSecurityGroupErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteInputSecurityGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteInputSecurityGroupErrorKind::BadGatewayException(_inner) => Some(_inner),
            DeleteInputSecurityGroupErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteInputSecurityGroupErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteInputSecurityGroupErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            DeleteInputSecurityGroupErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteInputSecurityGroupErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteInputSecurityGroupErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteInputSecurityGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteMultiplex` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteMultiplexError {
    /// Kind of error that occurred.
    pub kind: DeleteMultiplexErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteMultiplex` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteMultiplexErrorKind {
    /// Placeholder documentation for BadGatewayException
    BadGatewayException(crate::error::BadGatewayException),
    /// Placeholder documentation for BadRequestException
    BadRequestException(crate::error::BadRequestException),
    /// Placeholder documentation for ConflictException
    ConflictException(crate::error::ConflictException),
    /// Placeholder documentation for ForbiddenException
    ForbiddenException(crate::error::ForbiddenException),
    /// Placeholder documentation for GatewayTimeoutException
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// Placeholder documentation for InternalServerErrorException
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Placeholder documentation for NotFoundException
    NotFoundException(crate::error::NotFoundException),
    /// Placeholder documentation for TooManyRequestsException
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteMultiplexError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteMultiplexErrorKind::BadGatewayException(_inner) => _inner.fmt(f),
            DeleteMultiplexErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteMultiplexErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteMultiplexErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteMultiplexErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            DeleteMultiplexErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeleteMultiplexErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteMultiplexErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteMultiplexErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteMultiplexError {
    fn code(&self) -> Option<&str> {
        DeleteMultiplexError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteMultiplexError {
    /// Creates a new `DeleteMultiplexError`.
    pub fn new(kind: DeleteMultiplexErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteMultiplexError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteMultiplexErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteMultiplexError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteMultiplexErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteMultiplexErrorKind::BadGatewayException`.
    pub fn is_bad_gateway_exception(&self) -> bool {
        matches!(&self.kind, DeleteMultiplexErrorKind::BadGatewayException(_))
    }
    /// Returns `true` if the error kind is `DeleteMultiplexErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteMultiplexErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `DeleteMultiplexErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteMultiplexErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteMultiplexErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, DeleteMultiplexErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `DeleteMultiplexErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMultiplexErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMultiplexErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMultiplexErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMultiplexErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteMultiplexErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeleteMultiplexErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMultiplexErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteMultiplexError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteMultiplexErrorKind::BadGatewayException(_inner) => Some(_inner),
            DeleteMultiplexErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteMultiplexErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteMultiplexErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteMultiplexErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            DeleteMultiplexErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteMultiplexErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteMultiplexErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteMultiplexErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteMultiplexProgram` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteMultiplexProgramError {
    /// Kind of error that occurred.
    pub kind: DeleteMultiplexProgramErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteMultiplexProgram` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteMultiplexProgramErrorKind {
    /// Placeholder documentation for BadGatewayException
    BadGatewayException(crate::error::BadGatewayException),
    /// Placeholder documentation for BadRequestException
    BadRequestException(crate::error::BadRequestException),
    /// Placeholder documentation for ConflictException
    ConflictException(crate::error::ConflictException),
    /// Placeholder documentation for ForbiddenException
    ForbiddenException(crate::error::ForbiddenException),
    /// Placeholder documentation for GatewayTimeoutException
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// Placeholder documentation for InternalServerErrorException
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Placeholder documentation for NotFoundException
    NotFoundException(crate::error::NotFoundException),
    /// Placeholder documentation for TooManyRequestsException
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteMultiplexProgramError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteMultiplexProgramErrorKind::BadGatewayException(_inner) => _inner.fmt(f),
            DeleteMultiplexProgramErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteMultiplexProgramErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteMultiplexProgramErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteMultiplexProgramErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            DeleteMultiplexProgramErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeleteMultiplexProgramErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteMultiplexProgramErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteMultiplexProgramErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteMultiplexProgramError {
    fn code(&self) -> Option<&str> {
        DeleteMultiplexProgramError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteMultiplexProgramError {
    /// Creates a new `DeleteMultiplexProgramError`.
    pub fn new(kind: DeleteMultiplexProgramErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteMultiplexProgramError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteMultiplexProgramErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteMultiplexProgramError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteMultiplexProgramErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteMultiplexProgramErrorKind::BadGatewayException`.
    pub fn is_bad_gateway_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMultiplexProgramErrorKind::BadGatewayException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMultiplexProgramErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMultiplexProgramErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMultiplexProgramErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMultiplexProgramErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMultiplexProgramErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMultiplexProgramErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMultiplexProgramErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMultiplexProgramErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMultiplexProgramErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMultiplexProgramErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMultiplexProgramErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMultiplexProgramErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMultiplexProgramErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMultiplexProgramErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteMultiplexProgramError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteMultiplexProgramErrorKind::BadGatewayException(_inner) => Some(_inner),
            DeleteMultiplexProgramErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteMultiplexProgramErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteMultiplexProgramErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteMultiplexProgramErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            DeleteMultiplexProgramErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteMultiplexProgramErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteMultiplexProgramErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteMultiplexProgramErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteReservation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteReservationError {
    /// Kind of error that occurred.
    pub kind: DeleteReservationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteReservation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteReservationErrorKind {
    /// Placeholder documentation for BadGatewayException
    BadGatewayException(crate::error::BadGatewayException),
    /// Placeholder documentation for BadRequestException
    BadRequestException(crate::error::BadRequestException),
    /// Placeholder documentation for ConflictException
    ConflictException(crate::error::ConflictException),
    /// Placeholder documentation for ForbiddenException
    ForbiddenException(crate::error::ForbiddenException),
    /// Placeholder documentation for GatewayTimeoutException
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// Placeholder documentation for InternalServerErrorException
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Placeholder documentation for NotFoundException
    NotFoundException(crate::error::NotFoundException),
    /// Placeholder documentation for TooManyRequestsException
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteReservationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteReservationErrorKind::BadGatewayException(_inner) => _inner.fmt(f),
            DeleteReservationErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteReservationErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteReservationErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteReservationErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            DeleteReservationErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeleteReservationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteReservationErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteReservationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteReservationError {
    fn code(&self) -> Option<&str> {
        DeleteReservationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteReservationError {
    /// Creates a new `DeleteReservationError`.
    pub fn new(kind: DeleteReservationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteReservationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteReservationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteReservationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteReservationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteReservationErrorKind::BadGatewayException`.
    pub fn is_bad_gateway_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteReservationErrorKind::BadGatewayException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteReservationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteReservationErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteReservationErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteReservationErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteReservationErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteReservationErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteReservationErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteReservationErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteReservationErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteReservationErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteReservationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteReservationErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeleteReservationErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteReservationErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteReservationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteReservationErrorKind::BadGatewayException(_inner) => Some(_inner),
            DeleteReservationErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteReservationErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteReservationErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteReservationErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            DeleteReservationErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteReservationErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteReservationErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteReservationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteSchedule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteScheduleError {
    /// Kind of error that occurred.
    pub kind: DeleteScheduleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteSchedule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteScheduleErrorKind {
    /// Placeholder documentation for BadGatewayException
    BadGatewayException(crate::error::BadGatewayException),
    /// Placeholder documentation for BadRequestException
    BadRequestException(crate::error::BadRequestException),
    /// Placeholder documentation for ForbiddenException
    ForbiddenException(crate::error::ForbiddenException),
    /// Placeholder documentation for GatewayTimeoutException
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// Placeholder documentation for InternalServerErrorException
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Placeholder documentation for NotFoundException
    NotFoundException(crate::error::NotFoundException),
    /// Placeholder documentation for TooManyRequestsException
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteScheduleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteScheduleErrorKind::BadGatewayException(_inner) => _inner.fmt(f),
            DeleteScheduleErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteScheduleErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteScheduleErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            DeleteScheduleErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeleteScheduleErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteScheduleErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteScheduleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteScheduleError {
    fn code(&self) -> Option<&str> {
        DeleteScheduleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteScheduleError {
    /// Creates a new `DeleteScheduleError`.
    pub fn new(kind: DeleteScheduleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteScheduleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteScheduleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteScheduleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteScheduleErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteScheduleErrorKind::BadGatewayException`.
    pub fn is_bad_gateway_exception(&self) -> bool {
        matches!(&self.kind, DeleteScheduleErrorKind::BadGatewayException(_))
    }
    /// Returns `true` if the error kind is `DeleteScheduleErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteScheduleErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `DeleteScheduleErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, DeleteScheduleErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `DeleteScheduleErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteScheduleErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteScheduleErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteScheduleErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteScheduleErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteScheduleErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeleteScheduleErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteScheduleErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteScheduleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteScheduleErrorKind::BadGatewayException(_inner) => Some(_inner),
            DeleteScheduleErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteScheduleErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteScheduleErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            DeleteScheduleErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteScheduleErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteScheduleErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteScheduleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteTagsError {
    /// Kind of error that occurred.
    pub kind: DeleteTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteTagsErrorKind {
    /// Placeholder documentation for BadRequestException
    BadRequestException(crate::error::BadRequestException),
    /// Placeholder documentation for ForbiddenException
    ForbiddenException(crate::error::ForbiddenException),
    /// Placeholder documentation for InternalServerErrorException
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Placeholder documentation for NotFoundException
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteTagsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteTagsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteTagsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeleteTagsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteTagsError {
    fn code(&self) -> Option<&str> {
        DeleteTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteTagsError {
    /// Creates a new `DeleteTagsError`.
    pub fn new(kind: DeleteTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteTagsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteTagsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteTagsErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `DeleteTagsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, DeleteTagsErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `DeleteTagsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTagsErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteTagsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteTagsErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for DeleteTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteTagsErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteTagsErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteTagsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteTagsErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeChannelError {
    /// Kind of error that occurred.
    pub kind: DescribeChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeChannelErrorKind {
    /// Placeholder documentation for BadGatewayException
    BadGatewayException(crate::error::BadGatewayException),
    /// Placeholder documentation for BadRequestException
    BadRequestException(crate::error::BadRequestException),
    /// Placeholder documentation for ForbiddenException
    ForbiddenException(crate::error::ForbiddenException),
    /// Placeholder documentation for GatewayTimeoutException
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// Placeholder documentation for InternalServerErrorException
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Placeholder documentation for NotFoundException
    NotFoundException(crate::error::NotFoundException),
    /// Placeholder documentation for TooManyRequestsException
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeChannelErrorKind::BadGatewayException(_inner) => _inner.fmt(f),
            DescribeChannelErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DescribeChannelErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DescribeChannelErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            DescribeChannelErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DescribeChannelErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeChannelErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DescribeChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeChannelError {
    fn code(&self) -> Option<&str> {
        DescribeChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeChannelError {
    /// Creates a new `DescribeChannelError`.
    pub fn new(kind: DescribeChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeChannelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeChannelErrorKind::BadGatewayException`.
    pub fn is_bad_gateway_exception(&self) -> bool {
        matches!(&self.kind, DescribeChannelErrorKind::BadGatewayException(_))
    }
    /// Returns `true` if the error kind is `DescribeChannelErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DescribeChannelErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `DescribeChannelErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, DescribeChannelErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `DescribeChannelErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeChannelErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeChannelErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DescribeChannelErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DescribeChannelErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DescribeChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeChannelErrorKind::BadGatewayException(_inner) => Some(_inner),
            DescribeChannelErrorKind::BadRequestException(_inner) => Some(_inner),
            DescribeChannelErrorKind::ForbiddenException(_inner) => Some(_inner),
            DescribeChannelErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            DescribeChannelErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DescribeChannelErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeChannelErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DescribeChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeInput` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeInputError {
    /// Kind of error that occurred.
    pub kind: DescribeInputErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeInput` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeInputErrorKind {
    /// Placeholder documentation for BadGatewayException
    BadGatewayException(crate::error::BadGatewayException),
    /// Placeholder documentation for BadRequestException
    BadRequestException(crate::error::BadRequestException),
    /// Placeholder documentation for ForbiddenException
    ForbiddenException(crate::error::ForbiddenException),
    /// Placeholder documentation for GatewayTimeoutException
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// Placeholder documentation for InternalServerErrorException
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Placeholder documentation for NotFoundException
    NotFoundException(crate::error::NotFoundException),
    /// Placeholder documentation for TooManyRequestsException
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeInputError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeInputErrorKind::BadGatewayException(_inner) => _inner.fmt(f),
            DescribeInputErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DescribeInputErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DescribeInputErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            DescribeInputErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DescribeInputErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeInputErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DescribeInputErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeInputError {
    fn code(&self) -> Option<&str> {
        DescribeInputError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeInputError {
    /// Creates a new `DescribeInputError`.
    pub fn new(kind: DescribeInputErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeInputError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeInputErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeInputError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeInputErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeInputErrorKind::BadGatewayException`.
    pub fn is_bad_gateway_exception(&self) -> bool {
        matches!(&self.kind, DescribeInputErrorKind::BadGatewayException(_))
    }
    /// Returns `true` if the error kind is `DescribeInputErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DescribeInputErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `DescribeInputErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, DescribeInputErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `DescribeInputErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInputErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeInputErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInputErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeInputErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DescribeInputErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DescribeInputErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInputErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DescribeInputError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeInputErrorKind::BadGatewayException(_inner) => Some(_inner),
            DescribeInputErrorKind::BadRequestException(_inner) => Some(_inner),
            DescribeInputErrorKind::ForbiddenException(_inner) => Some(_inner),
            DescribeInputErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            DescribeInputErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DescribeInputErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeInputErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DescribeInputErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeInputDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeInputDeviceError {
    /// Kind of error that occurred.
    pub kind: DescribeInputDeviceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeInputDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeInputDeviceErrorKind {
    /// Placeholder documentation for BadGatewayException
    BadGatewayException(crate::error::BadGatewayException),
    /// Placeholder documentation for BadRequestException
    BadRequestException(crate::error::BadRequestException),
    /// Placeholder documentation for ForbiddenException
    ForbiddenException(crate::error::ForbiddenException),
    /// Placeholder documentation for GatewayTimeoutException
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// Placeholder documentation for InternalServerErrorException
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Placeholder documentation for NotFoundException
    NotFoundException(crate::error::NotFoundException),
    /// Placeholder documentation for TooManyRequestsException
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeInputDeviceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeInputDeviceErrorKind::BadGatewayException(_inner) => _inner.fmt(f),
            DescribeInputDeviceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DescribeInputDeviceErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DescribeInputDeviceErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            DescribeInputDeviceErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DescribeInputDeviceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeInputDeviceErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DescribeInputDeviceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeInputDeviceError {
    fn code(&self) -> Option<&str> {
        DescribeInputDeviceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeInputDeviceError {
    /// Creates a new `DescribeInputDeviceError`.
    pub fn new(kind: DescribeInputDeviceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeInputDeviceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeInputDeviceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeInputDeviceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeInputDeviceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeInputDeviceErrorKind::BadGatewayException`.
    pub fn is_bad_gateway_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInputDeviceErrorKind::BadGatewayException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeInputDeviceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInputDeviceErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeInputDeviceErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInputDeviceErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeInputDeviceErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInputDeviceErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeInputDeviceErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInputDeviceErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeInputDeviceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInputDeviceErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeInputDeviceErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInputDeviceErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DescribeInputDeviceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeInputDeviceErrorKind::BadGatewayException(_inner) => Some(_inner),
            DescribeInputDeviceErrorKind::BadRequestException(_inner) => Some(_inner),
            DescribeInputDeviceErrorKind::ForbiddenException(_inner) => Some(_inner),
            DescribeInputDeviceErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            DescribeInputDeviceErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DescribeInputDeviceErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeInputDeviceErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DescribeInputDeviceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeInputDeviceThumbnail` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeInputDeviceThumbnailError {
    /// Kind of error that occurred.
    pub kind: DescribeInputDeviceThumbnailErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeInputDeviceThumbnail` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeInputDeviceThumbnailErrorKind {
    /// Placeholder documentation for BadGatewayException
    BadGatewayException(crate::error::BadGatewayException),
    /// Placeholder documentation for BadRequestException
    BadRequestException(crate::error::BadRequestException),
    /// Placeholder documentation for ForbiddenException
    ForbiddenException(crate::error::ForbiddenException),
    /// Placeholder documentation for GatewayTimeoutException
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// Placeholder documentation for InternalServerErrorException
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Placeholder documentation for NotFoundException
    NotFoundException(crate::error::NotFoundException),
    /// Placeholder documentation for TooManyRequestsException
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeInputDeviceThumbnailError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeInputDeviceThumbnailErrorKind::BadGatewayException(_inner) => _inner.fmt(f),
            DescribeInputDeviceThumbnailErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DescribeInputDeviceThumbnailErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DescribeInputDeviceThumbnailErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            DescribeInputDeviceThumbnailErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            DescribeInputDeviceThumbnailErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeInputDeviceThumbnailErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            DescribeInputDeviceThumbnailErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeInputDeviceThumbnailError {
    fn code(&self) -> Option<&str> {
        DescribeInputDeviceThumbnailError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeInputDeviceThumbnailError {
    /// Creates a new `DescribeInputDeviceThumbnailError`.
    pub fn new(kind: DescribeInputDeviceThumbnailErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeInputDeviceThumbnailError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeInputDeviceThumbnailErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeInputDeviceThumbnailError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeInputDeviceThumbnailErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeInputDeviceThumbnailErrorKind::BadGatewayException`.
    pub fn is_bad_gateway_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInputDeviceThumbnailErrorKind::BadGatewayException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeInputDeviceThumbnailErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInputDeviceThumbnailErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeInputDeviceThumbnailErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInputDeviceThumbnailErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeInputDeviceThumbnailErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInputDeviceThumbnailErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeInputDeviceThumbnailErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInputDeviceThumbnailErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeInputDeviceThumbnailErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInputDeviceThumbnailErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeInputDeviceThumbnailErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInputDeviceThumbnailErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DescribeInputDeviceThumbnailError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeInputDeviceThumbnailErrorKind::BadGatewayException(_inner) => Some(_inner),
            DescribeInputDeviceThumbnailErrorKind::BadRequestException(_inner) => Some(_inner),
            DescribeInputDeviceThumbnailErrorKind::ForbiddenException(_inner) => Some(_inner),
            DescribeInputDeviceThumbnailErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            DescribeInputDeviceThumbnailErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            DescribeInputDeviceThumbnailErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeInputDeviceThumbnailErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DescribeInputDeviceThumbnailErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeInputSecurityGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeInputSecurityGroupError {
    /// Kind of error that occurred.
    pub kind: DescribeInputSecurityGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeInputSecurityGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeInputSecurityGroupErrorKind {
    /// Placeholder documentation for BadGatewayException
    BadGatewayException(crate::error::BadGatewayException),
    /// Placeholder documentation for BadRequestException
    BadRequestException(crate::error::BadRequestException),
    /// Placeholder documentation for ForbiddenException
    ForbiddenException(crate::error::ForbiddenException),
    /// Placeholder documentation for GatewayTimeoutException
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// Placeholder documentation for InternalServerErrorException
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Placeholder documentation for NotFoundException
    NotFoundException(crate::error::NotFoundException),
    /// Placeholder documentation for TooManyRequestsException
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeInputSecurityGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeInputSecurityGroupErrorKind::BadGatewayException(_inner) => _inner.fmt(f),
            DescribeInputSecurityGroupErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DescribeInputSecurityGroupErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DescribeInputSecurityGroupErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            DescribeInputSecurityGroupErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            DescribeInputSecurityGroupErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeInputSecurityGroupErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DescribeInputSecurityGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeInputSecurityGroupError {
    fn code(&self) -> Option<&str> {
        DescribeInputSecurityGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeInputSecurityGroupError {
    /// Creates a new `DescribeInputSecurityGroupError`.
    pub fn new(kind: DescribeInputSecurityGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeInputSecurityGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeInputSecurityGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeInputSecurityGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeInputSecurityGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeInputSecurityGroupErrorKind::BadGatewayException`.
    pub fn is_bad_gateway_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInputSecurityGroupErrorKind::BadGatewayException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeInputSecurityGroupErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInputSecurityGroupErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeInputSecurityGroupErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInputSecurityGroupErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeInputSecurityGroupErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInputSecurityGroupErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeInputSecurityGroupErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInputSecurityGroupErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeInputSecurityGroupErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInputSecurityGroupErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeInputSecurityGroupErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInputSecurityGroupErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DescribeInputSecurityGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeInputSecurityGroupErrorKind::BadGatewayException(_inner) => Some(_inner),
            DescribeInputSecurityGroupErrorKind::BadRequestException(_inner) => Some(_inner),
            DescribeInputSecurityGroupErrorKind::ForbiddenException(_inner) => Some(_inner),
            DescribeInputSecurityGroupErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            DescribeInputSecurityGroupErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            DescribeInputSecurityGroupErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeInputSecurityGroupErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DescribeInputSecurityGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeMultiplex` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeMultiplexError {
    /// Kind of error that occurred.
    pub kind: DescribeMultiplexErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeMultiplex` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeMultiplexErrorKind {
    /// Placeholder documentation for BadGatewayException
    BadGatewayException(crate::error::BadGatewayException),
    /// Placeholder documentation for BadRequestException
    BadRequestException(crate::error::BadRequestException),
    /// Placeholder documentation for ForbiddenException
    ForbiddenException(crate::error::ForbiddenException),
    /// Placeholder documentation for GatewayTimeoutException
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// Placeholder documentation for InternalServerErrorException
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Placeholder documentation for NotFoundException
    NotFoundException(crate::error::NotFoundException),
    /// Placeholder documentation for TooManyRequestsException
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeMultiplexError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeMultiplexErrorKind::BadGatewayException(_inner) => _inner.fmt(f),
            DescribeMultiplexErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DescribeMultiplexErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DescribeMultiplexErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            DescribeMultiplexErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DescribeMultiplexErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeMultiplexErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DescribeMultiplexErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeMultiplexError {
    fn code(&self) -> Option<&str> {
        DescribeMultiplexError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeMultiplexError {
    /// Creates a new `DescribeMultiplexError`.
    pub fn new(kind: DescribeMultiplexErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeMultiplexError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeMultiplexErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeMultiplexError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeMultiplexErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeMultiplexErrorKind::BadGatewayException`.
    pub fn is_bad_gateway_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMultiplexErrorKind::BadGatewayException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMultiplexErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMultiplexErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMultiplexErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMultiplexErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMultiplexErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMultiplexErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMultiplexErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMultiplexErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMultiplexErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DescribeMultiplexErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DescribeMultiplexErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMultiplexErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DescribeMultiplexError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeMultiplexErrorKind::BadGatewayException(_inner) => Some(_inner),
            DescribeMultiplexErrorKind::BadRequestException(_inner) => Some(_inner),
            DescribeMultiplexErrorKind::ForbiddenException(_inner) => Some(_inner),
            DescribeMultiplexErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            DescribeMultiplexErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DescribeMultiplexErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeMultiplexErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DescribeMultiplexErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeMultiplexProgram` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeMultiplexProgramError {
    /// Kind of error that occurred.
    pub kind: DescribeMultiplexProgramErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeMultiplexProgram` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeMultiplexProgramErrorKind {
    /// Placeholder documentation for BadGatewayException
    BadGatewayException(crate::error::BadGatewayException),
    /// Placeholder documentation for BadRequestException
    BadRequestException(crate::error::BadRequestException),
    /// Placeholder documentation for ForbiddenException
    ForbiddenException(crate::error::ForbiddenException),
    /// Placeholder documentation for GatewayTimeoutException
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// Placeholder documentation for InternalServerErrorException
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Placeholder documentation for NotFoundException
    NotFoundException(crate::error::NotFoundException),
    /// Placeholder documentation for TooManyRequestsException
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeMultiplexProgramError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeMultiplexProgramErrorKind::BadGatewayException(_inner) => _inner.fmt(f),
            DescribeMultiplexProgramErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DescribeMultiplexProgramErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DescribeMultiplexProgramErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            DescribeMultiplexProgramErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            DescribeMultiplexProgramErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeMultiplexProgramErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DescribeMultiplexProgramErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeMultiplexProgramError {
    fn code(&self) -> Option<&str> {
        DescribeMultiplexProgramError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeMultiplexProgramError {
    /// Creates a new `DescribeMultiplexProgramError`.
    pub fn new(kind: DescribeMultiplexProgramErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeMultiplexProgramError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeMultiplexProgramErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeMultiplexProgramError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeMultiplexProgramErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeMultiplexProgramErrorKind::BadGatewayException`.
    pub fn is_bad_gateway_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMultiplexProgramErrorKind::BadGatewayException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMultiplexProgramErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMultiplexProgramErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMultiplexProgramErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMultiplexProgramErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMultiplexProgramErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMultiplexProgramErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMultiplexProgramErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMultiplexProgramErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMultiplexProgramErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMultiplexProgramErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMultiplexProgramErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMultiplexProgramErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DescribeMultiplexProgramError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeMultiplexProgramErrorKind::BadGatewayException(_inner) => Some(_inner),
            DescribeMultiplexProgramErrorKind::BadRequestException(_inner) => Some(_inner),
            DescribeMultiplexProgramErrorKind::ForbiddenException(_inner) => Some(_inner),
            DescribeMultiplexProgramErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            DescribeMultiplexProgramErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DescribeMultiplexProgramErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeMultiplexProgramErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DescribeMultiplexProgramErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeOffering` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeOfferingError {
    /// Kind of error that occurred.
    pub kind: DescribeOfferingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeOffering` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeOfferingErrorKind {
    /// Placeholder documentation for BadGatewayException
    BadGatewayException(crate::error::BadGatewayException),
    /// Placeholder documentation for BadRequestException
    BadRequestException(crate::error::BadRequestException),
    /// Placeholder documentation for ForbiddenException
    ForbiddenException(crate::error::ForbiddenException),
    /// Placeholder documentation for GatewayTimeoutException
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// Placeholder documentation for InternalServerErrorException
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Placeholder documentation for NotFoundException
    NotFoundException(crate::error::NotFoundException),
    /// Placeholder documentation for TooManyRequestsException
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeOfferingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeOfferingErrorKind::BadGatewayException(_inner) => _inner.fmt(f),
            DescribeOfferingErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DescribeOfferingErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DescribeOfferingErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            DescribeOfferingErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DescribeOfferingErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeOfferingErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DescribeOfferingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeOfferingError {
    fn code(&self) -> Option<&str> {
        DescribeOfferingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeOfferingError {
    /// Creates a new `DescribeOfferingError`.
    pub fn new(kind: DescribeOfferingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeOfferingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeOfferingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeOfferingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeOfferingErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeOfferingErrorKind::BadGatewayException`.
    pub fn is_bad_gateway_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOfferingErrorKind::BadGatewayException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeOfferingErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOfferingErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeOfferingErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, DescribeOfferingErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `DescribeOfferingErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOfferingErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeOfferingErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOfferingErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeOfferingErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DescribeOfferingErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DescribeOfferingErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOfferingErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DescribeOfferingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeOfferingErrorKind::BadGatewayException(_inner) => Some(_inner),
            DescribeOfferingErrorKind::BadRequestException(_inner) => Some(_inner),
            DescribeOfferingErrorKind::ForbiddenException(_inner) => Some(_inner),
            DescribeOfferingErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            DescribeOfferingErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DescribeOfferingErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeOfferingErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DescribeOfferingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeReservation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeReservationError {
    /// Kind of error that occurred.
    pub kind: DescribeReservationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeReservation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeReservationErrorKind {
    /// Placeholder documentation for BadGatewayException
    BadGatewayException(crate::error::BadGatewayException),
    /// Placeholder documentation for BadRequestException
    BadRequestException(crate::error::BadRequestException),
    /// Placeholder documentation for ForbiddenException
    ForbiddenException(crate::error::ForbiddenException),
    /// Placeholder documentation for GatewayTimeoutException
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// Placeholder documentation for InternalServerErrorException
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Placeholder documentation for NotFoundException
    NotFoundException(crate::error::NotFoundException),
    /// Placeholder documentation for TooManyRequestsException
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeReservationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeReservationErrorKind::BadGatewayException(_inner) => _inner.fmt(f),
            DescribeReservationErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DescribeReservationErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DescribeReservationErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            DescribeReservationErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DescribeReservationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeReservationErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DescribeReservationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeReservationError {
    fn code(&self) -> Option<&str> {
        DescribeReservationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeReservationError {
    /// Creates a new `DescribeReservationError`.
    pub fn new(kind: DescribeReservationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeReservationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeReservationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeReservationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeReservationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeReservationErrorKind::BadGatewayException`.
    pub fn is_bad_gateway_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReservationErrorKind::BadGatewayException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeReservationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReservationErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeReservationErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReservationErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeReservationErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReservationErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeReservationErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReservationErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeReservationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReservationErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeReservationErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReservationErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DescribeReservationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeReservationErrorKind::BadGatewayException(_inner) => Some(_inner),
            DescribeReservationErrorKind::BadRequestException(_inner) => Some(_inner),
            DescribeReservationErrorKind::ForbiddenException(_inner) => Some(_inner),
            DescribeReservationErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            DescribeReservationErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DescribeReservationErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeReservationErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DescribeReservationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeSchedule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeScheduleError {
    /// Kind of error that occurred.
    pub kind: DescribeScheduleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeSchedule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeScheduleErrorKind {
    /// Placeholder documentation for BadGatewayException
    BadGatewayException(crate::error::BadGatewayException),
    /// Placeholder documentation for BadRequestException
    BadRequestException(crate::error::BadRequestException),
    /// Placeholder documentation for ForbiddenException
    ForbiddenException(crate::error::ForbiddenException),
    /// Placeholder documentation for GatewayTimeoutException
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// Placeholder documentation for InternalServerErrorException
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Placeholder documentation for NotFoundException
    NotFoundException(crate::error::NotFoundException),
    /// Placeholder documentation for TooManyRequestsException
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeScheduleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeScheduleErrorKind::BadGatewayException(_inner) => _inner.fmt(f),
            DescribeScheduleErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DescribeScheduleErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DescribeScheduleErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            DescribeScheduleErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DescribeScheduleErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeScheduleErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DescribeScheduleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeScheduleError {
    fn code(&self) -> Option<&str> {
        DescribeScheduleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeScheduleError {
    /// Creates a new `DescribeScheduleError`.
    pub fn new(kind: DescribeScheduleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeScheduleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeScheduleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeScheduleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeScheduleErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeScheduleErrorKind::BadGatewayException`.
    pub fn is_bad_gateway_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeScheduleErrorKind::BadGatewayException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeScheduleErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeScheduleErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeScheduleErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, DescribeScheduleErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `DescribeScheduleErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeScheduleErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeScheduleErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeScheduleErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeScheduleErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DescribeScheduleErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DescribeScheduleErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeScheduleErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DescribeScheduleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeScheduleErrorKind::BadGatewayException(_inner) => Some(_inner),
            DescribeScheduleErrorKind::BadRequestException(_inner) => Some(_inner),
            DescribeScheduleErrorKind::ForbiddenException(_inner) => Some(_inner),
            DescribeScheduleErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            DescribeScheduleErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DescribeScheduleErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeScheduleErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DescribeScheduleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListChannels` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListChannelsError {
    /// Kind of error that occurred.
    pub kind: ListChannelsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListChannels` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListChannelsErrorKind {
    /// Placeholder documentation for BadGatewayException
    BadGatewayException(crate::error::BadGatewayException),
    /// Placeholder documentation for BadRequestException
    BadRequestException(crate::error::BadRequestException),
    /// Placeholder documentation for ForbiddenException
    ForbiddenException(crate::error::ForbiddenException),
    /// Placeholder documentation for GatewayTimeoutException
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// Placeholder documentation for InternalServerErrorException
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Placeholder documentation for TooManyRequestsException
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListChannelsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListChannelsErrorKind::BadGatewayException(_inner) => _inner.fmt(f),
            ListChannelsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListChannelsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListChannelsErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            ListChannelsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListChannelsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListChannelsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListChannelsError {
    fn code(&self) -> Option<&str> {
        ListChannelsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListChannelsError {
    /// Creates a new `ListChannelsError`.
    pub fn new(kind: ListChannelsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListChannelsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListChannelsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListChannelsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListChannelsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListChannelsErrorKind::BadGatewayException`.
    pub fn is_bad_gateway_exception(&self) -> bool {
        matches!(&self.kind, ListChannelsErrorKind::BadGatewayException(_))
    }
    /// Returns `true` if the error kind is `ListChannelsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ListChannelsErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `ListChannelsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, ListChannelsErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `ListChannelsErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelsErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `ListChannelsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelsErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListChannelsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListChannelsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListChannelsErrorKind::BadGatewayException(_inner) => Some(_inner),
            ListChannelsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListChannelsErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListChannelsErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            ListChannelsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListChannelsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListChannelsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListInputDevices` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListInputDevicesError {
    /// Kind of error that occurred.
    pub kind: ListInputDevicesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListInputDevices` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListInputDevicesErrorKind {
    /// Placeholder documentation for BadGatewayException
    BadGatewayException(crate::error::BadGatewayException),
    /// Placeholder documentation for BadRequestException
    BadRequestException(crate::error::BadRequestException),
    /// Placeholder documentation for ForbiddenException
    ForbiddenException(crate::error::ForbiddenException),
    /// Placeholder documentation for GatewayTimeoutException
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// Placeholder documentation for InternalServerErrorException
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Placeholder documentation for TooManyRequestsException
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListInputDevicesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListInputDevicesErrorKind::BadGatewayException(_inner) => _inner.fmt(f),
            ListInputDevicesErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListInputDevicesErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListInputDevicesErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            ListInputDevicesErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListInputDevicesErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListInputDevicesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListInputDevicesError {
    fn code(&self) -> Option<&str> {
        ListInputDevicesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListInputDevicesError {
    /// Creates a new `ListInputDevicesError`.
    pub fn new(kind: ListInputDevicesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListInputDevicesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListInputDevicesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListInputDevicesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListInputDevicesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListInputDevicesErrorKind::BadGatewayException`.
    pub fn is_bad_gateway_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInputDevicesErrorKind::BadGatewayException(_)
        )
    }
    /// Returns `true` if the error kind is `ListInputDevicesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInputDevicesErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListInputDevicesErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, ListInputDevicesErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `ListInputDevicesErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInputDevicesErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `ListInputDevicesErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInputDevicesErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListInputDevicesErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInputDevicesErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListInputDevicesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListInputDevicesErrorKind::BadGatewayException(_inner) => Some(_inner),
            ListInputDevicesErrorKind::BadRequestException(_inner) => Some(_inner),
            ListInputDevicesErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListInputDevicesErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            ListInputDevicesErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListInputDevicesErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListInputDevicesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListInputDeviceTransfers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListInputDeviceTransfersError {
    /// Kind of error that occurred.
    pub kind: ListInputDeviceTransfersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListInputDeviceTransfers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListInputDeviceTransfersErrorKind {
    /// Placeholder documentation for BadGatewayException
    BadGatewayException(crate::error::BadGatewayException),
    /// Placeholder documentation for BadRequestException
    BadRequestException(crate::error::BadRequestException),
    /// Placeholder documentation for ForbiddenException
    ForbiddenException(crate::error::ForbiddenException),
    /// Placeholder documentation for GatewayTimeoutException
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// Placeholder documentation for InternalServerErrorException
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Placeholder documentation for TooManyRequestsException
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// Placeholder documentation for UnprocessableEntityException
    UnprocessableEntityException(crate::error::UnprocessableEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListInputDeviceTransfersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListInputDeviceTransfersErrorKind::BadGatewayException(_inner) => _inner.fmt(f),
            ListInputDeviceTransfersErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListInputDeviceTransfersErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListInputDeviceTransfersErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            ListInputDeviceTransfersErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            ListInputDeviceTransfersErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListInputDeviceTransfersErrorKind::UnprocessableEntityException(_inner) => {
                _inner.fmt(f)
            }
            ListInputDeviceTransfersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListInputDeviceTransfersError {
    fn code(&self) -> Option<&str> {
        ListInputDeviceTransfersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListInputDeviceTransfersError {
    /// Creates a new `ListInputDeviceTransfersError`.
    pub fn new(kind: ListInputDeviceTransfersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListInputDeviceTransfersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListInputDeviceTransfersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListInputDeviceTransfersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListInputDeviceTransfersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListInputDeviceTransfersErrorKind::BadGatewayException`.
    pub fn is_bad_gateway_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInputDeviceTransfersErrorKind::BadGatewayException(_)
        )
    }
    /// Returns `true` if the error kind is `ListInputDeviceTransfersErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInputDeviceTransfersErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListInputDeviceTransfersErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInputDeviceTransfersErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListInputDeviceTransfersErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInputDeviceTransfersErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `ListInputDeviceTransfersErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInputDeviceTransfersErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListInputDeviceTransfersErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInputDeviceTransfersErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `ListInputDeviceTransfersErrorKind::UnprocessableEntityException`.
    pub fn is_unprocessable_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInputDeviceTransfersErrorKind::UnprocessableEntityException(_)
        )
    }
}
impl std::error::Error for ListInputDeviceTransfersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListInputDeviceTransfersErrorKind::BadGatewayException(_inner) => Some(_inner),
            ListInputDeviceTransfersErrorKind::BadRequestException(_inner) => Some(_inner),
            ListInputDeviceTransfersErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListInputDeviceTransfersErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            ListInputDeviceTransfersErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListInputDeviceTransfersErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListInputDeviceTransfersErrorKind::UnprocessableEntityException(_inner) => Some(_inner),
            ListInputDeviceTransfersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListInputs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListInputsError {
    /// Kind of error that occurred.
    pub kind: ListInputsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListInputs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListInputsErrorKind {
    /// Placeholder documentation for BadGatewayException
    BadGatewayException(crate::error::BadGatewayException),
    /// Placeholder documentation for BadRequestException
    BadRequestException(crate::error::BadRequestException),
    /// Placeholder documentation for ForbiddenException
    ForbiddenException(crate::error::ForbiddenException),
    /// Placeholder documentation for GatewayTimeoutException
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// Placeholder documentation for InternalServerErrorException
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Placeholder documentation for TooManyRequestsException
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListInputsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListInputsErrorKind::BadGatewayException(_inner) => _inner.fmt(f),
            ListInputsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListInputsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListInputsErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            ListInputsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListInputsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListInputsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListInputsError {
    fn code(&self) -> Option<&str> {
        ListInputsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListInputsError {
    /// Creates a new `ListInputsError`.
    pub fn new(kind: ListInputsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListInputsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListInputsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListInputsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListInputsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListInputsErrorKind::BadGatewayException`.
    pub fn is_bad_gateway_exception(&self) -> bool {
        matches!(&self.kind, ListInputsErrorKind::BadGatewayException(_))
    }
    /// Returns `true` if the error kind is `ListInputsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ListInputsErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `ListInputsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, ListInputsErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `ListInputsErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(&self.kind, ListInputsErrorKind::GatewayTimeoutException(_))
    }
    /// Returns `true` if the error kind is `ListInputsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInputsErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListInputsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, ListInputsErrorKind::TooManyRequestsException(_))
    }
}
impl std::error::Error for ListInputsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListInputsErrorKind::BadGatewayException(_inner) => Some(_inner),
            ListInputsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListInputsErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListInputsErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            ListInputsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListInputsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListInputsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListInputSecurityGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListInputSecurityGroupsError {
    /// Kind of error that occurred.
    pub kind: ListInputSecurityGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListInputSecurityGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListInputSecurityGroupsErrorKind {
    /// Placeholder documentation for BadGatewayException
    BadGatewayException(crate::error::BadGatewayException),
    /// Placeholder documentation for BadRequestException
    BadRequestException(crate::error::BadRequestException),
    /// Placeholder documentation for ForbiddenException
    ForbiddenException(crate::error::ForbiddenException),
    /// Placeholder documentation for GatewayTimeoutException
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// Placeholder documentation for InternalServerErrorException
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Placeholder documentation for TooManyRequestsException
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListInputSecurityGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListInputSecurityGroupsErrorKind::BadGatewayException(_inner) => _inner.fmt(f),
            ListInputSecurityGroupsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListInputSecurityGroupsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListInputSecurityGroupsErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            ListInputSecurityGroupsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListInputSecurityGroupsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListInputSecurityGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListInputSecurityGroupsError {
    fn code(&self) -> Option<&str> {
        ListInputSecurityGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListInputSecurityGroupsError {
    /// Creates a new `ListInputSecurityGroupsError`.
    pub fn new(kind: ListInputSecurityGroupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListInputSecurityGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListInputSecurityGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListInputSecurityGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListInputSecurityGroupsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListInputSecurityGroupsErrorKind::BadGatewayException`.
    pub fn is_bad_gateway_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInputSecurityGroupsErrorKind::BadGatewayException(_)
        )
    }
    /// Returns `true` if the error kind is `ListInputSecurityGroupsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInputSecurityGroupsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListInputSecurityGroupsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInputSecurityGroupsErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListInputSecurityGroupsErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInputSecurityGroupsErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `ListInputSecurityGroupsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInputSecurityGroupsErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListInputSecurityGroupsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInputSecurityGroupsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListInputSecurityGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListInputSecurityGroupsErrorKind::BadGatewayException(_inner) => Some(_inner),
            ListInputSecurityGroupsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListInputSecurityGroupsErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListInputSecurityGroupsErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            ListInputSecurityGroupsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListInputSecurityGroupsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListInputSecurityGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListMultiplexes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListMultiplexesError {
    /// Kind of error that occurred.
    pub kind: ListMultiplexesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListMultiplexes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListMultiplexesErrorKind {
    /// Placeholder documentation for BadGatewayException
    BadGatewayException(crate::error::BadGatewayException),
    /// Placeholder documentation for BadRequestException
    BadRequestException(crate::error::BadRequestException),
    /// Placeholder documentation for ForbiddenException
    ForbiddenException(crate::error::ForbiddenException),
    /// Placeholder documentation for GatewayTimeoutException
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// Placeholder documentation for InternalServerErrorException
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Placeholder documentation for TooManyRequestsException
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListMultiplexesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListMultiplexesErrorKind::BadGatewayException(_inner) => _inner.fmt(f),
            ListMultiplexesErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListMultiplexesErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListMultiplexesErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            ListMultiplexesErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListMultiplexesErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListMultiplexesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListMultiplexesError {
    fn code(&self) -> Option<&str> {
        ListMultiplexesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListMultiplexesError {
    /// Creates a new `ListMultiplexesError`.
    pub fn new(kind: ListMultiplexesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListMultiplexesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListMultiplexesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListMultiplexesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListMultiplexesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListMultiplexesErrorKind::BadGatewayException`.
    pub fn is_bad_gateway_exception(&self) -> bool {
        matches!(&self.kind, ListMultiplexesErrorKind::BadGatewayException(_))
    }
    /// Returns `true` if the error kind is `ListMultiplexesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ListMultiplexesErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `ListMultiplexesErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, ListMultiplexesErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `ListMultiplexesErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMultiplexesErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMultiplexesErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMultiplexesErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMultiplexesErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMultiplexesErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListMultiplexesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListMultiplexesErrorKind::BadGatewayException(_inner) => Some(_inner),
            ListMultiplexesErrorKind::BadRequestException(_inner) => Some(_inner),
            ListMultiplexesErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListMultiplexesErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            ListMultiplexesErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListMultiplexesErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListMultiplexesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListMultiplexPrograms` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListMultiplexProgramsError {
    /// Kind of error that occurred.
    pub kind: ListMultiplexProgramsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListMultiplexPrograms` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListMultiplexProgramsErrorKind {
    /// Placeholder documentation for BadGatewayException
    BadGatewayException(crate::error::BadGatewayException),
    /// Placeholder documentation for BadRequestException
    BadRequestException(crate::error::BadRequestException),
    /// Placeholder documentation for ForbiddenException
    ForbiddenException(crate::error::ForbiddenException),
    /// Placeholder documentation for GatewayTimeoutException
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// Placeholder documentation for InternalServerErrorException
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Placeholder documentation for NotFoundException
    NotFoundException(crate::error::NotFoundException),
    /// Placeholder documentation for TooManyRequestsException
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListMultiplexProgramsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListMultiplexProgramsErrorKind::BadGatewayException(_inner) => _inner.fmt(f),
            ListMultiplexProgramsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListMultiplexProgramsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListMultiplexProgramsErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            ListMultiplexProgramsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListMultiplexProgramsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListMultiplexProgramsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListMultiplexProgramsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListMultiplexProgramsError {
    fn code(&self) -> Option<&str> {
        ListMultiplexProgramsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListMultiplexProgramsError {
    /// Creates a new `ListMultiplexProgramsError`.
    pub fn new(kind: ListMultiplexProgramsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListMultiplexProgramsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListMultiplexProgramsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListMultiplexProgramsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListMultiplexProgramsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListMultiplexProgramsErrorKind::BadGatewayException`.
    pub fn is_bad_gateway_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMultiplexProgramsErrorKind::BadGatewayException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMultiplexProgramsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMultiplexProgramsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMultiplexProgramsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMultiplexProgramsErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMultiplexProgramsErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMultiplexProgramsErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMultiplexProgramsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMultiplexProgramsErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMultiplexProgramsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMultiplexProgramsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMultiplexProgramsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMultiplexProgramsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListMultiplexProgramsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListMultiplexProgramsErrorKind::BadGatewayException(_inner) => Some(_inner),
            ListMultiplexProgramsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListMultiplexProgramsErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListMultiplexProgramsErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            ListMultiplexProgramsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListMultiplexProgramsErrorKind::NotFoundException(_inner) => Some(_inner),
            ListMultiplexProgramsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListMultiplexProgramsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListOfferings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListOfferingsError {
    /// Kind of error that occurred.
    pub kind: ListOfferingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListOfferings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListOfferingsErrorKind {
    /// Placeholder documentation for BadGatewayException
    BadGatewayException(crate::error::BadGatewayException),
    /// Placeholder documentation for BadRequestException
    BadRequestException(crate::error::BadRequestException),
    /// Placeholder documentation for ForbiddenException
    ForbiddenException(crate::error::ForbiddenException),
    /// Placeholder documentation for GatewayTimeoutException
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// Placeholder documentation for InternalServerErrorException
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Placeholder documentation for TooManyRequestsException
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListOfferingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListOfferingsErrorKind::BadGatewayException(_inner) => _inner.fmt(f),
            ListOfferingsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListOfferingsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListOfferingsErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            ListOfferingsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListOfferingsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListOfferingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListOfferingsError {
    fn code(&self) -> Option<&str> {
        ListOfferingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListOfferingsError {
    /// Creates a new `ListOfferingsError`.
    pub fn new(kind: ListOfferingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListOfferingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListOfferingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListOfferingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListOfferingsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListOfferingsErrorKind::BadGatewayException`.
    pub fn is_bad_gateway_exception(&self) -> bool {
        matches!(&self.kind, ListOfferingsErrorKind::BadGatewayException(_))
    }
    /// Returns `true` if the error kind is `ListOfferingsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ListOfferingsErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `ListOfferingsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, ListOfferingsErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `ListOfferingsErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOfferingsErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `ListOfferingsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOfferingsErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListOfferingsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOfferingsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListOfferingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListOfferingsErrorKind::BadGatewayException(_inner) => Some(_inner),
            ListOfferingsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListOfferingsErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListOfferingsErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            ListOfferingsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListOfferingsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListOfferingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListReservations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListReservationsError {
    /// Kind of error that occurred.
    pub kind: ListReservationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListReservations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListReservationsErrorKind {
    /// Placeholder documentation for BadGatewayException
    BadGatewayException(crate::error::BadGatewayException),
    /// Placeholder documentation for BadRequestException
    BadRequestException(crate::error::BadRequestException),
    /// Placeholder documentation for ForbiddenException
    ForbiddenException(crate::error::ForbiddenException),
    /// Placeholder documentation for GatewayTimeoutException
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// Placeholder documentation for InternalServerErrorException
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Placeholder documentation for TooManyRequestsException
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListReservationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListReservationsErrorKind::BadGatewayException(_inner) => _inner.fmt(f),
            ListReservationsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListReservationsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListReservationsErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            ListReservationsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListReservationsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListReservationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListReservationsError {
    fn code(&self) -> Option<&str> {
        ListReservationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListReservationsError {
    /// Creates a new `ListReservationsError`.
    pub fn new(kind: ListReservationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListReservationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListReservationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListReservationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListReservationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListReservationsErrorKind::BadGatewayException`.
    pub fn is_bad_gateway_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListReservationsErrorKind::BadGatewayException(_)
        )
    }
    /// Returns `true` if the error kind is `ListReservationsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListReservationsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListReservationsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, ListReservationsErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `ListReservationsErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListReservationsErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `ListReservationsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListReservationsErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListReservationsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListReservationsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListReservationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListReservationsErrorKind::BadGatewayException(_inner) => Some(_inner),
            ListReservationsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListReservationsErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListReservationsErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            ListReservationsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListReservationsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListReservationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// Placeholder documentation for BadRequestException
    BadRequestException(crate::error::BadRequestException),
    /// Placeholder documentation for ForbiddenException
    ForbiddenException(crate::error::ForbiddenException),
    /// Placeholder documentation for InternalServerErrorException
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Placeholder documentation for NotFoundException
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::BadRequestException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::NotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PurchaseOffering` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PurchaseOfferingError {
    /// Kind of error that occurred.
    pub kind: PurchaseOfferingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PurchaseOffering` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PurchaseOfferingErrorKind {
    /// Placeholder documentation for BadGatewayException
    BadGatewayException(crate::error::BadGatewayException),
    /// Placeholder documentation for BadRequestException
    BadRequestException(crate::error::BadRequestException),
    /// Placeholder documentation for ConflictException
    ConflictException(crate::error::ConflictException),
    /// Placeholder documentation for ForbiddenException
    ForbiddenException(crate::error::ForbiddenException),
    /// Placeholder documentation for GatewayTimeoutException
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// Placeholder documentation for InternalServerErrorException
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Placeholder documentation for NotFoundException
    NotFoundException(crate::error::NotFoundException),
    /// Placeholder documentation for TooManyRequestsException
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PurchaseOfferingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PurchaseOfferingErrorKind::BadGatewayException(_inner) => _inner.fmt(f),
            PurchaseOfferingErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            PurchaseOfferingErrorKind::ConflictException(_inner) => _inner.fmt(f),
            PurchaseOfferingErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            PurchaseOfferingErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            PurchaseOfferingErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            PurchaseOfferingErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            PurchaseOfferingErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            PurchaseOfferingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PurchaseOfferingError {
    fn code(&self) -> Option<&str> {
        PurchaseOfferingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PurchaseOfferingError {
    /// Creates a new `PurchaseOfferingError`.
    pub fn new(kind: PurchaseOfferingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PurchaseOfferingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PurchaseOfferingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PurchaseOfferingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PurchaseOfferingErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PurchaseOfferingErrorKind::BadGatewayException`.
    pub fn is_bad_gateway_exception(&self) -> bool {
        matches!(
            &self.kind,
            PurchaseOfferingErrorKind::BadGatewayException(_)
        )
    }
    /// Returns `true` if the error kind is `PurchaseOfferingErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            PurchaseOfferingErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `PurchaseOfferingErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, PurchaseOfferingErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `PurchaseOfferingErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, PurchaseOfferingErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `PurchaseOfferingErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            PurchaseOfferingErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `PurchaseOfferingErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            PurchaseOfferingErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `PurchaseOfferingErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, PurchaseOfferingErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `PurchaseOfferingErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            PurchaseOfferingErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for PurchaseOfferingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PurchaseOfferingErrorKind::BadGatewayException(_inner) => Some(_inner),
            PurchaseOfferingErrorKind::BadRequestException(_inner) => Some(_inner),
            PurchaseOfferingErrorKind::ConflictException(_inner) => Some(_inner),
            PurchaseOfferingErrorKind::ForbiddenException(_inner) => Some(_inner),
            PurchaseOfferingErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            PurchaseOfferingErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            PurchaseOfferingErrorKind::NotFoundException(_inner) => Some(_inner),
            PurchaseOfferingErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            PurchaseOfferingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RejectInputDeviceTransfer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RejectInputDeviceTransferError {
    /// Kind of error that occurred.
    pub kind: RejectInputDeviceTransferErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RejectInputDeviceTransfer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RejectInputDeviceTransferErrorKind {
    /// Placeholder documentation for BadGatewayException
    BadGatewayException(crate::error::BadGatewayException),
    /// Placeholder documentation for BadRequestException
    BadRequestException(crate::error::BadRequestException),
    /// Placeholder documentation for ConflictException
    ConflictException(crate::error::ConflictException),
    /// Placeholder documentation for ForbiddenException
    ForbiddenException(crate::error::ForbiddenException),
    /// Placeholder documentation for GatewayTimeoutException
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// Placeholder documentation for InternalServerErrorException
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Placeholder documentation for NotFoundException
    NotFoundException(crate::error::NotFoundException),
    /// Placeholder documentation for TooManyRequestsException
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// Placeholder documentation for UnprocessableEntityException
    UnprocessableEntityException(crate::error::UnprocessableEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RejectInputDeviceTransferError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RejectInputDeviceTransferErrorKind::BadGatewayException(_inner) => _inner.fmt(f),
            RejectInputDeviceTransferErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            RejectInputDeviceTransferErrorKind::ConflictException(_inner) => _inner.fmt(f),
            RejectInputDeviceTransferErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            RejectInputDeviceTransferErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            RejectInputDeviceTransferErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            RejectInputDeviceTransferErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            RejectInputDeviceTransferErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            RejectInputDeviceTransferErrorKind::UnprocessableEntityException(_inner) => {
                _inner.fmt(f)
            }
            RejectInputDeviceTransferErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RejectInputDeviceTransferError {
    fn code(&self) -> Option<&str> {
        RejectInputDeviceTransferError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RejectInputDeviceTransferError {
    /// Creates a new `RejectInputDeviceTransferError`.
    pub fn new(kind: RejectInputDeviceTransferErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RejectInputDeviceTransferError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RejectInputDeviceTransferErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RejectInputDeviceTransferError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RejectInputDeviceTransferErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RejectInputDeviceTransferErrorKind::BadGatewayException`.
    pub fn is_bad_gateway_exception(&self) -> bool {
        matches!(
            &self.kind,
            RejectInputDeviceTransferErrorKind::BadGatewayException(_)
        )
    }
    /// Returns `true` if the error kind is `RejectInputDeviceTransferErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            RejectInputDeviceTransferErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `RejectInputDeviceTransferErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            RejectInputDeviceTransferErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `RejectInputDeviceTransferErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            RejectInputDeviceTransferErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `RejectInputDeviceTransferErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            RejectInputDeviceTransferErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `RejectInputDeviceTransferErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            RejectInputDeviceTransferErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `RejectInputDeviceTransferErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RejectInputDeviceTransferErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `RejectInputDeviceTransferErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            RejectInputDeviceTransferErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `RejectInputDeviceTransferErrorKind::UnprocessableEntityException`.
    pub fn is_unprocessable_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            RejectInputDeviceTransferErrorKind::UnprocessableEntityException(_)
        )
    }
}
impl std::error::Error for RejectInputDeviceTransferError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RejectInputDeviceTransferErrorKind::BadGatewayException(_inner) => Some(_inner),
            RejectInputDeviceTransferErrorKind::BadRequestException(_inner) => Some(_inner),
            RejectInputDeviceTransferErrorKind::ConflictException(_inner) => Some(_inner),
            RejectInputDeviceTransferErrorKind::ForbiddenException(_inner) => Some(_inner),
            RejectInputDeviceTransferErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            RejectInputDeviceTransferErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            RejectInputDeviceTransferErrorKind::NotFoundException(_inner) => Some(_inner),
            RejectInputDeviceTransferErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            RejectInputDeviceTransferErrorKind::UnprocessableEntityException(_inner) => {
                Some(_inner)
            }
            RejectInputDeviceTransferErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartChannelError {
    /// Kind of error that occurred.
    pub kind: StartChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartChannelErrorKind {
    /// Placeholder documentation for BadGatewayException
    BadGatewayException(crate::error::BadGatewayException),
    /// Placeholder documentation for BadRequestException
    BadRequestException(crate::error::BadRequestException),
    /// Placeholder documentation for ConflictException
    ConflictException(crate::error::ConflictException),
    /// Placeholder documentation for ForbiddenException
    ForbiddenException(crate::error::ForbiddenException),
    /// Placeholder documentation for GatewayTimeoutException
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// Placeholder documentation for InternalServerErrorException
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Placeholder documentation for NotFoundException
    NotFoundException(crate::error::NotFoundException),
    /// Placeholder documentation for TooManyRequestsException
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartChannelErrorKind::BadGatewayException(_inner) => _inner.fmt(f),
            StartChannelErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            StartChannelErrorKind::ConflictException(_inner) => _inner.fmt(f),
            StartChannelErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            StartChannelErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            StartChannelErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            StartChannelErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            StartChannelErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            StartChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartChannelError {
    fn code(&self) -> Option<&str> {
        StartChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartChannelError {
    /// Creates a new `StartChannelError`.
    pub fn new(kind: StartChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartChannelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartChannelErrorKind::BadGatewayException`.
    pub fn is_bad_gateway_exception(&self) -> bool {
        matches!(&self.kind, StartChannelErrorKind::BadGatewayException(_))
    }
    /// Returns `true` if the error kind is `StartChannelErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, StartChannelErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `StartChannelErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, StartChannelErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `StartChannelErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, StartChannelErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `StartChannelErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartChannelErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `StartChannelErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartChannelErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `StartChannelErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, StartChannelErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `StartChannelErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartChannelErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for StartChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartChannelErrorKind::BadGatewayException(_inner) => Some(_inner),
            StartChannelErrorKind::BadRequestException(_inner) => Some(_inner),
            StartChannelErrorKind::ConflictException(_inner) => Some(_inner),
            StartChannelErrorKind::ForbiddenException(_inner) => Some(_inner),
            StartChannelErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            StartChannelErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            StartChannelErrorKind::NotFoundException(_inner) => Some(_inner),
            StartChannelErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            StartChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartMultiplex` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartMultiplexError {
    /// Kind of error that occurred.
    pub kind: StartMultiplexErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartMultiplex` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartMultiplexErrorKind {
    /// Placeholder documentation for BadGatewayException
    BadGatewayException(crate::error::BadGatewayException),
    /// Placeholder documentation for BadRequestException
    BadRequestException(crate::error::BadRequestException),
    /// Placeholder documentation for ConflictException
    ConflictException(crate::error::ConflictException),
    /// Placeholder documentation for ForbiddenException
    ForbiddenException(crate::error::ForbiddenException),
    /// Placeholder documentation for GatewayTimeoutException
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// Placeholder documentation for InternalServerErrorException
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Placeholder documentation for NotFoundException
    NotFoundException(crate::error::NotFoundException),
    /// Placeholder documentation for TooManyRequestsException
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartMultiplexError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartMultiplexErrorKind::BadGatewayException(_inner) => _inner.fmt(f),
            StartMultiplexErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            StartMultiplexErrorKind::ConflictException(_inner) => _inner.fmt(f),
            StartMultiplexErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            StartMultiplexErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            StartMultiplexErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            StartMultiplexErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            StartMultiplexErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            StartMultiplexErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartMultiplexError {
    fn code(&self) -> Option<&str> {
        StartMultiplexError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartMultiplexError {
    /// Creates a new `StartMultiplexError`.
    pub fn new(kind: StartMultiplexErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartMultiplexError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartMultiplexErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartMultiplexError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartMultiplexErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartMultiplexErrorKind::BadGatewayException`.
    pub fn is_bad_gateway_exception(&self) -> bool {
        matches!(&self.kind, StartMultiplexErrorKind::BadGatewayException(_))
    }
    /// Returns `true` if the error kind is `StartMultiplexErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, StartMultiplexErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `StartMultiplexErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, StartMultiplexErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `StartMultiplexErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, StartMultiplexErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `StartMultiplexErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartMultiplexErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `StartMultiplexErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartMultiplexErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `StartMultiplexErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, StartMultiplexErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `StartMultiplexErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartMultiplexErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for StartMultiplexError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartMultiplexErrorKind::BadGatewayException(_inner) => Some(_inner),
            StartMultiplexErrorKind::BadRequestException(_inner) => Some(_inner),
            StartMultiplexErrorKind::ConflictException(_inner) => Some(_inner),
            StartMultiplexErrorKind::ForbiddenException(_inner) => Some(_inner),
            StartMultiplexErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            StartMultiplexErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            StartMultiplexErrorKind::NotFoundException(_inner) => Some(_inner),
            StartMultiplexErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            StartMultiplexErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopChannelError {
    /// Kind of error that occurred.
    pub kind: StopChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopChannelErrorKind {
    /// Placeholder documentation for BadGatewayException
    BadGatewayException(crate::error::BadGatewayException),
    /// Placeholder documentation for BadRequestException
    BadRequestException(crate::error::BadRequestException),
    /// Placeholder documentation for ConflictException
    ConflictException(crate::error::ConflictException),
    /// Placeholder documentation for ForbiddenException
    ForbiddenException(crate::error::ForbiddenException),
    /// Placeholder documentation for GatewayTimeoutException
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// Placeholder documentation for InternalServerErrorException
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Placeholder documentation for NotFoundException
    NotFoundException(crate::error::NotFoundException),
    /// Placeholder documentation for TooManyRequestsException
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopChannelErrorKind::BadGatewayException(_inner) => _inner.fmt(f),
            StopChannelErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            StopChannelErrorKind::ConflictException(_inner) => _inner.fmt(f),
            StopChannelErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            StopChannelErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            StopChannelErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            StopChannelErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            StopChannelErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            StopChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopChannelError {
    fn code(&self) -> Option<&str> {
        StopChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopChannelError {
    /// Creates a new `StopChannelError`.
    pub fn new(kind: StopChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopChannelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StopChannelErrorKind::BadGatewayException`.
    pub fn is_bad_gateway_exception(&self) -> bool {
        matches!(&self.kind, StopChannelErrorKind::BadGatewayException(_))
    }
    /// Returns `true` if the error kind is `StopChannelErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, StopChannelErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `StopChannelErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, StopChannelErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `StopChannelErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, StopChannelErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `StopChannelErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(&self.kind, StopChannelErrorKind::GatewayTimeoutException(_))
    }
    /// Returns `true` if the error kind is `StopChannelErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopChannelErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `StopChannelErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, StopChannelErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `StopChannelErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopChannelErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for StopChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopChannelErrorKind::BadGatewayException(_inner) => Some(_inner),
            StopChannelErrorKind::BadRequestException(_inner) => Some(_inner),
            StopChannelErrorKind::ConflictException(_inner) => Some(_inner),
            StopChannelErrorKind::ForbiddenException(_inner) => Some(_inner),
            StopChannelErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            StopChannelErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            StopChannelErrorKind::NotFoundException(_inner) => Some(_inner),
            StopChannelErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            StopChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopMultiplex` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopMultiplexError {
    /// Kind of error that occurred.
    pub kind: StopMultiplexErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopMultiplex` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopMultiplexErrorKind {
    /// Placeholder documentation for BadGatewayException
    BadGatewayException(crate::error::BadGatewayException),
    /// Placeholder documentation for BadRequestException
    BadRequestException(crate::error::BadRequestException),
    /// Placeholder documentation for ConflictException
    ConflictException(crate::error::ConflictException),
    /// Placeholder documentation for ForbiddenException
    ForbiddenException(crate::error::ForbiddenException),
    /// Placeholder documentation for GatewayTimeoutException
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// Placeholder documentation for InternalServerErrorException
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Placeholder documentation for NotFoundException
    NotFoundException(crate::error::NotFoundException),
    /// Placeholder documentation for TooManyRequestsException
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopMultiplexError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopMultiplexErrorKind::BadGatewayException(_inner) => _inner.fmt(f),
            StopMultiplexErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            StopMultiplexErrorKind::ConflictException(_inner) => _inner.fmt(f),
            StopMultiplexErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            StopMultiplexErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            StopMultiplexErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            StopMultiplexErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            StopMultiplexErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            StopMultiplexErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopMultiplexError {
    fn code(&self) -> Option<&str> {
        StopMultiplexError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopMultiplexError {
    /// Creates a new `StopMultiplexError`.
    pub fn new(kind: StopMultiplexErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopMultiplexError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopMultiplexErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopMultiplexError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopMultiplexErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StopMultiplexErrorKind::BadGatewayException`.
    pub fn is_bad_gateway_exception(&self) -> bool {
        matches!(&self.kind, StopMultiplexErrorKind::BadGatewayException(_))
    }
    /// Returns `true` if the error kind is `StopMultiplexErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, StopMultiplexErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `StopMultiplexErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, StopMultiplexErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `StopMultiplexErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, StopMultiplexErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `StopMultiplexErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopMultiplexErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `StopMultiplexErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopMultiplexErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `StopMultiplexErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, StopMultiplexErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `StopMultiplexErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopMultiplexErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for StopMultiplexError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopMultiplexErrorKind::BadGatewayException(_inner) => Some(_inner),
            StopMultiplexErrorKind::BadRequestException(_inner) => Some(_inner),
            StopMultiplexErrorKind::ConflictException(_inner) => Some(_inner),
            StopMultiplexErrorKind::ForbiddenException(_inner) => Some(_inner),
            StopMultiplexErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            StopMultiplexErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            StopMultiplexErrorKind::NotFoundException(_inner) => Some(_inner),
            StopMultiplexErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            StopMultiplexErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TransferInputDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TransferInputDeviceError {
    /// Kind of error that occurred.
    pub kind: TransferInputDeviceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TransferInputDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TransferInputDeviceErrorKind {
    /// Placeholder documentation for BadGatewayException
    BadGatewayException(crate::error::BadGatewayException),
    /// Placeholder documentation for BadRequestException
    BadRequestException(crate::error::BadRequestException),
    /// Placeholder documentation for ConflictException
    ConflictException(crate::error::ConflictException),
    /// Placeholder documentation for ForbiddenException
    ForbiddenException(crate::error::ForbiddenException),
    /// Placeholder documentation for GatewayTimeoutException
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// Placeholder documentation for InternalServerErrorException
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Placeholder documentation for NotFoundException
    NotFoundException(crate::error::NotFoundException),
    /// Placeholder documentation for TooManyRequestsException
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// Placeholder documentation for UnprocessableEntityException
    UnprocessableEntityException(crate::error::UnprocessableEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TransferInputDeviceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TransferInputDeviceErrorKind::BadGatewayException(_inner) => _inner.fmt(f),
            TransferInputDeviceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            TransferInputDeviceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            TransferInputDeviceErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            TransferInputDeviceErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            TransferInputDeviceErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            TransferInputDeviceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            TransferInputDeviceErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            TransferInputDeviceErrorKind::UnprocessableEntityException(_inner) => _inner.fmt(f),
            TransferInputDeviceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TransferInputDeviceError {
    fn code(&self) -> Option<&str> {
        TransferInputDeviceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TransferInputDeviceError {
    /// Creates a new `TransferInputDeviceError`.
    pub fn new(kind: TransferInputDeviceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TransferInputDeviceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TransferInputDeviceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TransferInputDeviceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TransferInputDeviceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TransferInputDeviceErrorKind::BadGatewayException`.
    pub fn is_bad_gateway_exception(&self) -> bool {
        matches!(
            &self.kind,
            TransferInputDeviceErrorKind::BadGatewayException(_)
        )
    }
    /// Returns `true` if the error kind is `TransferInputDeviceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            TransferInputDeviceErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `TransferInputDeviceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            TransferInputDeviceErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `TransferInputDeviceErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            TransferInputDeviceErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `TransferInputDeviceErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            TransferInputDeviceErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `TransferInputDeviceErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            TransferInputDeviceErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `TransferInputDeviceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TransferInputDeviceErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `TransferInputDeviceErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            TransferInputDeviceErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `TransferInputDeviceErrorKind::UnprocessableEntityException`.
    pub fn is_unprocessable_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            TransferInputDeviceErrorKind::UnprocessableEntityException(_)
        )
    }
}
impl std::error::Error for TransferInputDeviceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TransferInputDeviceErrorKind::BadGatewayException(_inner) => Some(_inner),
            TransferInputDeviceErrorKind::BadRequestException(_inner) => Some(_inner),
            TransferInputDeviceErrorKind::ConflictException(_inner) => Some(_inner),
            TransferInputDeviceErrorKind::ForbiddenException(_inner) => Some(_inner),
            TransferInputDeviceErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            TransferInputDeviceErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            TransferInputDeviceErrorKind::NotFoundException(_inner) => Some(_inner),
            TransferInputDeviceErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            TransferInputDeviceErrorKind::UnprocessableEntityException(_inner) => Some(_inner),
            TransferInputDeviceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateChannelError {
    /// Kind of error that occurred.
    pub kind: UpdateChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateChannelErrorKind {
    /// Placeholder documentation for BadGatewayException
    BadGatewayException(crate::error::BadGatewayException),
    /// Placeholder documentation for BadRequestException
    BadRequestException(crate::error::BadRequestException),
    /// Placeholder documentation for ConflictException
    ConflictException(crate::error::ConflictException),
    /// Placeholder documentation for ForbiddenException
    ForbiddenException(crate::error::ForbiddenException),
    /// Placeholder documentation for GatewayTimeoutException
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// Placeholder documentation for InternalServerErrorException
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Placeholder documentation for UnprocessableEntityException
    UnprocessableEntityException(crate::error::UnprocessableEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateChannelErrorKind::BadGatewayException(_inner) => _inner.fmt(f),
            UpdateChannelErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateChannelErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateChannelErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdateChannelErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            UpdateChannelErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdateChannelErrorKind::UnprocessableEntityException(_inner) => _inner.fmt(f),
            UpdateChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateChannelError {
    fn code(&self) -> Option<&str> {
        UpdateChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateChannelError {
    /// Creates a new `UpdateChannelError`.
    pub fn new(kind: UpdateChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateChannelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateChannelErrorKind::BadGatewayException`.
    pub fn is_bad_gateway_exception(&self) -> bool {
        matches!(&self.kind, UpdateChannelErrorKind::BadGatewayException(_))
    }
    /// Returns `true` if the error kind is `UpdateChannelErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, UpdateChannelErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `UpdateChannelErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateChannelErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UpdateChannelErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, UpdateChannelErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `UpdateChannelErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateChannelErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateChannelErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateChannelErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateChannelErrorKind::UnprocessableEntityException`.
    pub fn is_unprocessable_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateChannelErrorKind::UnprocessableEntityException(_)
        )
    }
}
impl std::error::Error for UpdateChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateChannelErrorKind::BadGatewayException(_inner) => Some(_inner),
            UpdateChannelErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateChannelErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateChannelErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdateChannelErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            UpdateChannelErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateChannelErrorKind::UnprocessableEntityException(_inner) => Some(_inner),
            UpdateChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateChannelClass` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateChannelClassError {
    /// Kind of error that occurred.
    pub kind: UpdateChannelClassErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateChannelClass` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateChannelClassErrorKind {
    /// Placeholder documentation for BadGatewayException
    BadGatewayException(crate::error::BadGatewayException),
    /// Placeholder documentation for BadRequestException
    BadRequestException(crate::error::BadRequestException),
    /// Placeholder documentation for ConflictException
    ConflictException(crate::error::ConflictException),
    /// Placeholder documentation for ForbiddenException
    ForbiddenException(crate::error::ForbiddenException),
    /// Placeholder documentation for GatewayTimeoutException
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// Placeholder documentation for InternalServerErrorException
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Placeholder documentation for NotFoundException
    NotFoundException(crate::error::NotFoundException),
    /// Placeholder documentation for TooManyRequestsException
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// Placeholder documentation for UnprocessableEntityException
    UnprocessableEntityException(crate::error::UnprocessableEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateChannelClassError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateChannelClassErrorKind::BadGatewayException(_inner) => _inner.fmt(f),
            UpdateChannelClassErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateChannelClassErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateChannelClassErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdateChannelClassErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            UpdateChannelClassErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdateChannelClassErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateChannelClassErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateChannelClassErrorKind::UnprocessableEntityException(_inner) => _inner.fmt(f),
            UpdateChannelClassErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateChannelClassError {
    fn code(&self) -> Option<&str> {
        UpdateChannelClassError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateChannelClassError {
    /// Creates a new `UpdateChannelClassError`.
    pub fn new(kind: UpdateChannelClassErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateChannelClassError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateChannelClassErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateChannelClassError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateChannelClassErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateChannelClassErrorKind::BadGatewayException`.
    pub fn is_bad_gateway_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateChannelClassErrorKind::BadGatewayException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateChannelClassErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateChannelClassErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateChannelClassErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateChannelClassErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateChannelClassErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateChannelClassErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateChannelClassErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateChannelClassErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateChannelClassErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateChannelClassErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateChannelClassErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateChannelClassErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateChannelClassErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateChannelClassErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateChannelClassErrorKind::UnprocessableEntityException`.
    pub fn is_unprocessable_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateChannelClassErrorKind::UnprocessableEntityException(_)
        )
    }
}
impl std::error::Error for UpdateChannelClassError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateChannelClassErrorKind::BadGatewayException(_inner) => Some(_inner),
            UpdateChannelClassErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateChannelClassErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateChannelClassErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdateChannelClassErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            UpdateChannelClassErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateChannelClassErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateChannelClassErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateChannelClassErrorKind::UnprocessableEntityException(_inner) => Some(_inner),
            UpdateChannelClassErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateInput` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateInputError {
    /// Kind of error that occurred.
    pub kind: UpdateInputErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateInput` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateInputErrorKind {
    /// Placeholder documentation for BadGatewayException
    BadGatewayException(crate::error::BadGatewayException),
    /// Placeholder documentation for BadRequestException
    BadRequestException(crate::error::BadRequestException),
    /// Placeholder documentation for ConflictException
    ConflictException(crate::error::ConflictException),
    /// Placeholder documentation for ForbiddenException
    ForbiddenException(crate::error::ForbiddenException),
    /// Placeholder documentation for GatewayTimeoutException
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// Placeholder documentation for InternalServerErrorException
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Placeholder documentation for NotFoundException
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateInputError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateInputErrorKind::BadGatewayException(_inner) => _inner.fmt(f),
            UpdateInputErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateInputErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateInputErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdateInputErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            UpdateInputErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdateInputErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateInputErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateInputError {
    fn code(&self) -> Option<&str> {
        UpdateInputError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateInputError {
    /// Creates a new `UpdateInputError`.
    pub fn new(kind: UpdateInputErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateInputError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateInputErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateInputError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateInputErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateInputErrorKind::BadGatewayException`.
    pub fn is_bad_gateway_exception(&self) -> bool {
        matches!(&self.kind, UpdateInputErrorKind::BadGatewayException(_))
    }
    /// Returns `true` if the error kind is `UpdateInputErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, UpdateInputErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `UpdateInputErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateInputErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UpdateInputErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, UpdateInputErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `UpdateInputErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(&self.kind, UpdateInputErrorKind::GatewayTimeoutException(_))
    }
    /// Returns `true` if the error kind is `UpdateInputErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateInputErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateInputErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateInputErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for UpdateInputError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateInputErrorKind::BadGatewayException(_inner) => Some(_inner),
            UpdateInputErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateInputErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateInputErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdateInputErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            UpdateInputErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateInputErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateInputErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateInputDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateInputDeviceError {
    /// Kind of error that occurred.
    pub kind: UpdateInputDeviceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateInputDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateInputDeviceErrorKind {
    /// Placeholder documentation for BadGatewayException
    BadGatewayException(crate::error::BadGatewayException),
    /// Placeholder documentation for BadRequestException
    BadRequestException(crate::error::BadRequestException),
    /// Placeholder documentation for ForbiddenException
    ForbiddenException(crate::error::ForbiddenException),
    /// Placeholder documentation for GatewayTimeoutException
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// Placeholder documentation for InternalServerErrorException
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Placeholder documentation for NotFoundException
    NotFoundException(crate::error::NotFoundException),
    /// Placeholder documentation for TooManyRequestsException
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// Placeholder documentation for UnprocessableEntityException
    UnprocessableEntityException(crate::error::UnprocessableEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateInputDeviceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateInputDeviceErrorKind::BadGatewayException(_inner) => _inner.fmt(f),
            UpdateInputDeviceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateInputDeviceErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdateInputDeviceErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            UpdateInputDeviceErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdateInputDeviceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateInputDeviceErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateInputDeviceErrorKind::UnprocessableEntityException(_inner) => _inner.fmt(f),
            UpdateInputDeviceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateInputDeviceError {
    fn code(&self) -> Option<&str> {
        UpdateInputDeviceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateInputDeviceError {
    /// Creates a new `UpdateInputDeviceError`.
    pub fn new(kind: UpdateInputDeviceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateInputDeviceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateInputDeviceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateInputDeviceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateInputDeviceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateInputDeviceErrorKind::BadGatewayException`.
    pub fn is_bad_gateway_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateInputDeviceErrorKind::BadGatewayException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateInputDeviceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateInputDeviceErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateInputDeviceErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateInputDeviceErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateInputDeviceErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateInputDeviceErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateInputDeviceErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateInputDeviceErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateInputDeviceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateInputDeviceErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `UpdateInputDeviceErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateInputDeviceErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateInputDeviceErrorKind::UnprocessableEntityException`.
    pub fn is_unprocessable_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateInputDeviceErrorKind::UnprocessableEntityException(_)
        )
    }
}
impl std::error::Error for UpdateInputDeviceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateInputDeviceErrorKind::BadGatewayException(_inner) => Some(_inner),
            UpdateInputDeviceErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateInputDeviceErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdateInputDeviceErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            UpdateInputDeviceErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateInputDeviceErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateInputDeviceErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateInputDeviceErrorKind::UnprocessableEntityException(_inner) => Some(_inner),
            UpdateInputDeviceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateInputSecurityGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateInputSecurityGroupError {
    /// Kind of error that occurred.
    pub kind: UpdateInputSecurityGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateInputSecurityGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateInputSecurityGroupErrorKind {
    /// Placeholder documentation for BadGatewayException
    BadGatewayException(crate::error::BadGatewayException),
    /// Placeholder documentation for BadRequestException
    BadRequestException(crate::error::BadRequestException),
    /// Placeholder documentation for ConflictException
    ConflictException(crate::error::ConflictException),
    /// Placeholder documentation for ForbiddenException
    ForbiddenException(crate::error::ForbiddenException),
    /// Placeholder documentation for GatewayTimeoutException
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// Placeholder documentation for InternalServerErrorException
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Placeholder documentation for NotFoundException
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateInputSecurityGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateInputSecurityGroupErrorKind::BadGatewayException(_inner) => _inner.fmt(f),
            UpdateInputSecurityGroupErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateInputSecurityGroupErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateInputSecurityGroupErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdateInputSecurityGroupErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            UpdateInputSecurityGroupErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            UpdateInputSecurityGroupErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateInputSecurityGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateInputSecurityGroupError {
    fn code(&self) -> Option<&str> {
        UpdateInputSecurityGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateInputSecurityGroupError {
    /// Creates a new `UpdateInputSecurityGroupError`.
    pub fn new(kind: UpdateInputSecurityGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateInputSecurityGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateInputSecurityGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateInputSecurityGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateInputSecurityGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateInputSecurityGroupErrorKind::BadGatewayException`.
    pub fn is_bad_gateway_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateInputSecurityGroupErrorKind::BadGatewayException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateInputSecurityGroupErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateInputSecurityGroupErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateInputSecurityGroupErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateInputSecurityGroupErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateInputSecurityGroupErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateInputSecurityGroupErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateInputSecurityGroupErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateInputSecurityGroupErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateInputSecurityGroupErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateInputSecurityGroupErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateInputSecurityGroupErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateInputSecurityGroupErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateInputSecurityGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateInputSecurityGroupErrorKind::BadGatewayException(_inner) => Some(_inner),
            UpdateInputSecurityGroupErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateInputSecurityGroupErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateInputSecurityGroupErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdateInputSecurityGroupErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            UpdateInputSecurityGroupErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateInputSecurityGroupErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateInputSecurityGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateMultiplex` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateMultiplexError {
    /// Kind of error that occurred.
    pub kind: UpdateMultiplexErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateMultiplex` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateMultiplexErrorKind {
    /// Placeholder documentation for BadGatewayException
    BadGatewayException(crate::error::BadGatewayException),
    /// Placeholder documentation for BadRequestException
    BadRequestException(crate::error::BadRequestException),
    /// Placeholder documentation for ConflictException
    ConflictException(crate::error::ConflictException),
    /// Placeholder documentation for ForbiddenException
    ForbiddenException(crate::error::ForbiddenException),
    /// Placeholder documentation for GatewayTimeoutException
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// Placeholder documentation for InternalServerErrorException
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Placeholder documentation for NotFoundException
    NotFoundException(crate::error::NotFoundException),
    /// Placeholder documentation for UnprocessableEntityException
    UnprocessableEntityException(crate::error::UnprocessableEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateMultiplexError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateMultiplexErrorKind::BadGatewayException(_inner) => _inner.fmt(f),
            UpdateMultiplexErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateMultiplexErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateMultiplexErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdateMultiplexErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            UpdateMultiplexErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdateMultiplexErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateMultiplexErrorKind::UnprocessableEntityException(_inner) => _inner.fmt(f),
            UpdateMultiplexErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateMultiplexError {
    fn code(&self) -> Option<&str> {
        UpdateMultiplexError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateMultiplexError {
    /// Creates a new `UpdateMultiplexError`.
    pub fn new(kind: UpdateMultiplexErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateMultiplexError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateMultiplexErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateMultiplexError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateMultiplexErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateMultiplexErrorKind::BadGatewayException`.
    pub fn is_bad_gateway_exception(&self) -> bool {
        matches!(&self.kind, UpdateMultiplexErrorKind::BadGatewayException(_))
    }
    /// Returns `true` if the error kind is `UpdateMultiplexErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, UpdateMultiplexErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `UpdateMultiplexErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateMultiplexErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UpdateMultiplexErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, UpdateMultiplexErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `UpdateMultiplexErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMultiplexErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateMultiplexErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMultiplexErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateMultiplexErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateMultiplexErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `UpdateMultiplexErrorKind::UnprocessableEntityException`.
    pub fn is_unprocessable_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMultiplexErrorKind::UnprocessableEntityException(_)
        )
    }
}
impl std::error::Error for UpdateMultiplexError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateMultiplexErrorKind::BadGatewayException(_inner) => Some(_inner),
            UpdateMultiplexErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateMultiplexErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateMultiplexErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdateMultiplexErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            UpdateMultiplexErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateMultiplexErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateMultiplexErrorKind::UnprocessableEntityException(_inner) => Some(_inner),
            UpdateMultiplexErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateMultiplexProgram` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateMultiplexProgramError {
    /// Kind of error that occurred.
    pub kind: UpdateMultiplexProgramErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateMultiplexProgram` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateMultiplexProgramErrorKind {
    /// Placeholder documentation for BadGatewayException
    BadGatewayException(crate::error::BadGatewayException),
    /// Placeholder documentation for BadRequestException
    BadRequestException(crate::error::BadRequestException),
    /// Placeholder documentation for ConflictException
    ConflictException(crate::error::ConflictException),
    /// Placeholder documentation for ForbiddenException
    ForbiddenException(crate::error::ForbiddenException),
    /// Placeholder documentation for GatewayTimeoutException
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// Placeholder documentation for InternalServerErrorException
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Placeholder documentation for NotFoundException
    NotFoundException(crate::error::NotFoundException),
    /// Placeholder documentation for UnprocessableEntityException
    UnprocessableEntityException(crate::error::UnprocessableEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateMultiplexProgramError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateMultiplexProgramErrorKind::BadGatewayException(_inner) => _inner.fmt(f),
            UpdateMultiplexProgramErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateMultiplexProgramErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateMultiplexProgramErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdateMultiplexProgramErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            UpdateMultiplexProgramErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdateMultiplexProgramErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateMultiplexProgramErrorKind::UnprocessableEntityException(_inner) => _inner.fmt(f),
            UpdateMultiplexProgramErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateMultiplexProgramError {
    fn code(&self) -> Option<&str> {
        UpdateMultiplexProgramError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateMultiplexProgramError {
    /// Creates a new `UpdateMultiplexProgramError`.
    pub fn new(kind: UpdateMultiplexProgramErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateMultiplexProgramError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateMultiplexProgramErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateMultiplexProgramError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateMultiplexProgramErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateMultiplexProgramErrorKind::BadGatewayException`.
    pub fn is_bad_gateway_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMultiplexProgramErrorKind::BadGatewayException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateMultiplexProgramErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMultiplexProgramErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateMultiplexProgramErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMultiplexProgramErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateMultiplexProgramErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMultiplexProgramErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateMultiplexProgramErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMultiplexProgramErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateMultiplexProgramErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMultiplexProgramErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateMultiplexProgramErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMultiplexProgramErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateMultiplexProgramErrorKind::UnprocessableEntityException`.
    pub fn is_unprocessable_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMultiplexProgramErrorKind::UnprocessableEntityException(_)
        )
    }
}
impl std::error::Error for UpdateMultiplexProgramError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateMultiplexProgramErrorKind::BadGatewayException(_inner) => Some(_inner),
            UpdateMultiplexProgramErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateMultiplexProgramErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateMultiplexProgramErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdateMultiplexProgramErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            UpdateMultiplexProgramErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateMultiplexProgramErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateMultiplexProgramErrorKind::UnprocessableEntityException(_inner) => Some(_inner),
            UpdateMultiplexProgramErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateReservation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateReservationError {
    /// Kind of error that occurred.
    pub kind: UpdateReservationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateReservation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateReservationErrorKind {
    /// Placeholder documentation for BadGatewayException
    BadGatewayException(crate::error::BadGatewayException),
    /// Placeholder documentation for BadRequestException
    BadRequestException(crate::error::BadRequestException),
    /// Placeholder documentation for ConflictException
    ConflictException(crate::error::ConflictException),
    /// Placeholder documentation for ForbiddenException
    ForbiddenException(crate::error::ForbiddenException),
    /// Placeholder documentation for GatewayTimeoutException
    GatewayTimeoutException(crate::error::GatewayTimeoutException),
    /// Placeholder documentation for InternalServerErrorException
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Placeholder documentation for NotFoundException
    NotFoundException(crate::error::NotFoundException),
    /// Placeholder documentation for TooManyRequestsException
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateReservationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateReservationErrorKind::BadGatewayException(_inner) => _inner.fmt(f),
            UpdateReservationErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateReservationErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateReservationErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdateReservationErrorKind::GatewayTimeoutException(_inner) => _inner.fmt(f),
            UpdateReservationErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdateReservationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateReservationErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateReservationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateReservationError {
    fn code(&self) -> Option<&str> {
        UpdateReservationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateReservationError {
    /// Creates a new `UpdateReservationError`.
    pub fn new(kind: UpdateReservationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateReservationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateReservationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateReservationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateReservationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateReservationErrorKind::BadGatewayException`.
    pub fn is_bad_gateway_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateReservationErrorKind::BadGatewayException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateReservationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateReservationErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateReservationErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateReservationErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UpdateReservationErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateReservationErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateReservationErrorKind::GatewayTimeoutException`.
    pub fn is_gateway_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateReservationErrorKind::GatewayTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateReservationErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateReservationErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateReservationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateReservationErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `UpdateReservationErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateReservationErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateReservationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateReservationErrorKind::BadGatewayException(_inner) => Some(_inner),
            UpdateReservationErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateReservationErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateReservationErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdateReservationErrorKind::GatewayTimeoutException(_inner) => Some(_inner),
            UpdateReservationErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateReservationErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateReservationErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateReservationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Placeholder documentation for TooManyRequestsException
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyRequestsException {
    /// Placeholder documentation for __string
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyRequestsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyRequestsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyRequestsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyRequestsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyRequestsException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyRequestsException {}
/// See [`TooManyRequestsException`](crate::error::TooManyRequestsException)
pub mod too_many_requests_exception {
    /// A builder for [`TooManyRequestsException`](crate::error::TooManyRequestsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Placeholder documentation for __string
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// Placeholder documentation for __string
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyRequestsException`](crate::error::TooManyRequestsException)
        pub fn build(self) -> crate::error::TooManyRequestsException {
            crate::error::TooManyRequestsException {
                message: self.message,
            }
        }
    }
}
impl TooManyRequestsException {
    /// Creates a new builder-style object to manufacture [`TooManyRequestsException`](crate::error::TooManyRequestsException)
    pub fn builder() -> crate::error::too_many_requests_exception::Builder {
        crate::error::too_many_requests_exception::Builder::default()
    }
}

/// Placeholder documentation for NotFoundException
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotFoundException {
    /// Placeholder documentation for __string
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NotFoundException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for NotFoundException {}
/// See [`NotFoundException`](crate::error::NotFoundException)
pub mod not_found_exception {
    /// A builder for [`NotFoundException`](crate::error::NotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Placeholder documentation for __string
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// Placeholder documentation for __string
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NotFoundException`](crate::error::NotFoundException)
        pub fn build(self) -> crate::error::NotFoundException {
            crate::error::NotFoundException {
                message: self.message,
            }
        }
    }
}
impl NotFoundException {
    /// Creates a new builder-style object to manufacture [`NotFoundException`](crate::error::NotFoundException)
    pub fn builder() -> crate::error::not_found_exception::Builder {
        crate::error::not_found_exception::Builder::default()
    }
}

/// Placeholder documentation for InternalServerErrorException
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerErrorException {
    /// Placeholder documentation for __string
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServerErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerErrorException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServerErrorException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerErrorException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerErrorException {}
/// See [`InternalServerErrorException`](crate::error::InternalServerErrorException)
pub mod internal_server_error_exception {
    /// A builder for [`InternalServerErrorException`](crate::error::InternalServerErrorException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Placeholder documentation for __string
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// Placeholder documentation for __string
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerErrorException`](crate::error::InternalServerErrorException)
        pub fn build(self) -> crate::error::InternalServerErrorException {
            crate::error::InternalServerErrorException {
                message: self.message,
            }
        }
    }
}
impl InternalServerErrorException {
    /// Creates a new builder-style object to manufacture [`InternalServerErrorException`](crate::error::InternalServerErrorException)
    pub fn builder() -> crate::error::internal_server_error_exception::Builder {
        crate::error::internal_server_error_exception::Builder::default()
    }
}

/// Placeholder documentation for GatewayTimeoutException
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GatewayTimeoutException {
    /// Placeholder documentation for __string
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GatewayTimeoutException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GatewayTimeoutException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl GatewayTimeoutException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for GatewayTimeoutException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "GatewayTimeoutException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for GatewayTimeoutException {}
/// See [`GatewayTimeoutException`](crate::error::GatewayTimeoutException)
pub mod gateway_timeout_exception {
    /// A builder for [`GatewayTimeoutException`](crate::error::GatewayTimeoutException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Placeholder documentation for __string
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// Placeholder documentation for __string
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`GatewayTimeoutException`](crate::error::GatewayTimeoutException)
        pub fn build(self) -> crate::error::GatewayTimeoutException {
            crate::error::GatewayTimeoutException {
                message: self.message,
            }
        }
    }
}
impl GatewayTimeoutException {
    /// Creates a new builder-style object to manufacture [`GatewayTimeoutException`](crate::error::GatewayTimeoutException)
    pub fn builder() -> crate::error::gateway_timeout_exception::Builder {
        crate::error::gateway_timeout_exception::Builder::default()
    }
}

/// Placeholder documentation for ForbiddenException
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ForbiddenException {
    /// Placeholder documentation for __string
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ForbiddenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ForbiddenException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ForbiddenException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ForbiddenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ForbiddenException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for ForbiddenException {}
/// See [`ForbiddenException`](crate::error::ForbiddenException)
pub mod forbidden_exception {
    /// A builder for [`ForbiddenException`](crate::error::ForbiddenException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Placeholder documentation for __string
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// Placeholder documentation for __string
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ForbiddenException`](crate::error::ForbiddenException)
        pub fn build(self) -> crate::error::ForbiddenException {
            crate::error::ForbiddenException {
                message: self.message,
            }
        }
    }
}
impl ForbiddenException {
    /// Creates a new builder-style object to manufacture [`ForbiddenException`](crate::error::ForbiddenException)
    pub fn builder() -> crate::error::forbidden_exception::Builder {
        crate::error::forbidden_exception::Builder::default()
    }
}

/// Placeholder documentation for ConflictException
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    /// Placeholder documentation for __string
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Placeholder documentation for __string
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// Placeholder documentation for __string
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

/// Placeholder documentation for BadRequestException
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BadRequestException {
    /// Placeholder documentation for __string
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BadRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BadRequestException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl BadRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for BadRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "BadRequestException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for BadRequestException {}
/// See [`BadRequestException`](crate::error::BadRequestException)
pub mod bad_request_exception {
    /// A builder for [`BadRequestException`](crate::error::BadRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Placeholder documentation for __string
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// Placeholder documentation for __string
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`BadRequestException`](crate::error::BadRequestException)
        pub fn build(self) -> crate::error::BadRequestException {
            crate::error::BadRequestException {
                message: self.message,
            }
        }
    }
}
impl BadRequestException {
    /// Creates a new builder-style object to manufacture [`BadRequestException`](crate::error::BadRequestException)
    pub fn builder() -> crate::error::bad_request_exception::Builder {
        crate::error::bad_request_exception::Builder::default()
    }
}

/// Placeholder documentation for BadGatewayException
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BadGatewayException {
    /// Placeholder documentation for __string
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BadGatewayException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BadGatewayException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl BadGatewayException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for BadGatewayException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "BadGatewayException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for BadGatewayException {}
/// See [`BadGatewayException`](crate::error::BadGatewayException)
pub mod bad_gateway_exception {
    /// A builder for [`BadGatewayException`](crate::error::BadGatewayException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Placeholder documentation for __string
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// Placeholder documentation for __string
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`BadGatewayException`](crate::error::BadGatewayException)
        pub fn build(self) -> crate::error::BadGatewayException {
            crate::error::BadGatewayException {
                message: self.message,
            }
        }
    }
}
impl BadGatewayException {
    /// Creates a new builder-style object to manufacture [`BadGatewayException`](crate::error::BadGatewayException)
    pub fn builder() -> crate::error::bad_gateway_exception::Builder {
        crate::error::bad_gateway_exception::Builder::default()
    }
}

/// Placeholder documentation for UnprocessableEntityException
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnprocessableEntityException {
    /// The error message.
    pub message: std::option::Option<std::string::String>,
    /// A collection of validation error responses.
    pub validation_errors: std::option::Option<std::vec::Vec<crate::model::ValidationError>>,
}
impl UnprocessableEntityException {
    /// A collection of validation error responses.
    pub fn validation_errors(&self) -> std::option::Option<&[crate::model::ValidationError]> {
        self.validation_errors.as_deref()
    }
}
impl std::fmt::Debug for UnprocessableEntityException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnprocessableEntityException");
        formatter.field("message", &self.message);
        formatter.field("validation_errors", &self.validation_errors);
        formatter.finish()
    }
}
impl UnprocessableEntityException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnprocessableEntityException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnprocessableEntityException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnprocessableEntityException {}
/// See [`UnprocessableEntityException`](crate::error::UnprocessableEntityException)
pub mod unprocessable_entity_exception {
    /// A builder for [`UnprocessableEntityException`](crate::error::UnprocessableEntityException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) validation_errors:
            std::option::Option<std::vec::Vec<crate::model::ValidationError>>,
    }
    impl Builder {
        /// The error message.
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// The error message.
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Appends an item to `validation_errors`.
        ///
        /// To override the contents of this collection use [`set_validation_errors`](Self::set_validation_errors).
        ///
        /// A collection of validation error responses.
        pub fn validation_errors(
            mut self,
            input: impl Into<crate::model::ValidationError>,
        ) -> Self {
            let mut v = self.validation_errors.unwrap_or_default();
            v.push(input.into());
            self.validation_errors = Some(v);
            self
        }
        /// A collection of validation error responses.
        pub fn set_validation_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ValidationError>>,
        ) -> Self {
            self.validation_errors = input;
            self
        }
        /// Consumes the builder and constructs a [`UnprocessableEntityException`](crate::error::UnprocessableEntityException)
        pub fn build(self) -> crate::error::UnprocessableEntityException {
            crate::error::UnprocessableEntityException {
                message: self.message,
                validation_errors: self.validation_errors,
            }
        }
    }
}
impl UnprocessableEntityException {
    /// Creates a new builder-style object to manufacture [`UnprocessableEntityException`](crate::error::UnprocessableEntityException)
    pub fn builder() -> crate::error::unprocessable_entity_exception::Builder {
        crate::error::unprocessable_entity_exception::Builder::default()
    }
}
