// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `MediaLive`.
///
/// This client allows ergonomic access to a `MediaLive`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AcceptInputDeviceTransfer` operation.
    ///
    /// See [`AcceptInputDeviceTransfer`](crate::client::fluent_builders::AcceptInputDeviceTransfer) for more information about the
    /// operation and its arguments.
    pub fn accept_input_device_transfer(
        &self,
    ) -> fluent_builders::AcceptInputDeviceTransfer<C, M, R> {
        fluent_builders::AcceptInputDeviceTransfer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchDelete` operation.
    ///
    /// See [`BatchDelete`](crate::client::fluent_builders::BatchDelete) for more information about the
    /// operation and its arguments.
    pub fn batch_delete(&self) -> fluent_builders::BatchDelete<C, M, R> {
        fluent_builders::BatchDelete::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchStart` operation.
    ///
    /// See [`BatchStart`](crate::client::fluent_builders::BatchStart) for more information about the
    /// operation and its arguments.
    pub fn batch_start(&self) -> fluent_builders::BatchStart<C, M, R> {
        fluent_builders::BatchStart::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchStop` operation.
    ///
    /// See [`BatchStop`](crate::client::fluent_builders::BatchStop) for more information about the
    /// operation and its arguments.
    pub fn batch_stop(&self) -> fluent_builders::BatchStop<C, M, R> {
        fluent_builders::BatchStop::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchUpdateSchedule` operation.
    ///
    /// See [`BatchUpdateSchedule`](crate::client::fluent_builders::BatchUpdateSchedule) for more information about the
    /// operation and its arguments.
    pub fn batch_update_schedule(&self) -> fluent_builders::BatchUpdateSchedule<C, M, R> {
        fluent_builders::BatchUpdateSchedule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CancelInputDeviceTransfer` operation.
    ///
    /// See [`CancelInputDeviceTransfer`](crate::client::fluent_builders::CancelInputDeviceTransfer) for more information about the
    /// operation and its arguments.
    pub fn cancel_input_device_transfer(
        &self,
    ) -> fluent_builders::CancelInputDeviceTransfer<C, M, R> {
        fluent_builders::CancelInputDeviceTransfer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ClaimDevice` operation.
    ///
    /// See [`ClaimDevice`](crate::client::fluent_builders::ClaimDevice) for more information about the
    /// operation and its arguments.
    pub fn claim_device(&self) -> fluent_builders::ClaimDevice<C, M, R> {
        fluent_builders::ClaimDevice::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateChannel` operation.
    ///
    /// See [`CreateChannel`](crate::client::fluent_builders::CreateChannel) for more information about the
    /// operation and its arguments.
    pub fn create_channel(&self) -> fluent_builders::CreateChannel<C, M, R> {
        fluent_builders::CreateChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateInput` operation.
    ///
    /// See [`CreateInput`](crate::client::fluent_builders::CreateInput) for more information about the
    /// operation and its arguments.
    pub fn create_input(&self) -> fluent_builders::CreateInput<C, M, R> {
        fluent_builders::CreateInput::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateInputSecurityGroup` operation.
    ///
    /// See [`CreateInputSecurityGroup`](crate::client::fluent_builders::CreateInputSecurityGroup) for more information about the
    /// operation and its arguments.
    pub fn create_input_security_group(
        &self,
    ) -> fluent_builders::CreateInputSecurityGroup<C, M, R> {
        fluent_builders::CreateInputSecurityGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateMultiplex` operation.
    ///
    /// See [`CreateMultiplex`](crate::client::fluent_builders::CreateMultiplex) for more information about the
    /// operation and its arguments.
    pub fn create_multiplex(&self) -> fluent_builders::CreateMultiplex<C, M, R> {
        fluent_builders::CreateMultiplex::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateMultiplexProgram` operation.
    ///
    /// See [`CreateMultiplexProgram`](crate::client::fluent_builders::CreateMultiplexProgram) for more information about the
    /// operation and its arguments.
    pub fn create_multiplex_program(&self) -> fluent_builders::CreateMultiplexProgram<C, M, R> {
        fluent_builders::CreateMultiplexProgram::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreatePartnerInput` operation.
    ///
    /// See [`CreatePartnerInput`](crate::client::fluent_builders::CreatePartnerInput) for more information about the
    /// operation and its arguments.
    pub fn create_partner_input(&self) -> fluent_builders::CreatePartnerInput<C, M, R> {
        fluent_builders::CreatePartnerInput::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateTags` operation.
    ///
    /// See [`CreateTags`](crate::client::fluent_builders::CreateTags) for more information about the
    /// operation and its arguments.
    pub fn create_tags(&self) -> fluent_builders::CreateTags<C, M, R> {
        fluent_builders::CreateTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteChannel` operation.
    ///
    /// See [`DeleteChannel`](crate::client::fluent_builders::DeleteChannel) for more information about the
    /// operation and its arguments.
    pub fn delete_channel(&self) -> fluent_builders::DeleteChannel<C, M, R> {
        fluent_builders::DeleteChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteInput` operation.
    ///
    /// See [`DeleteInput`](crate::client::fluent_builders::DeleteInput) for more information about the
    /// operation and its arguments.
    pub fn delete_input(&self) -> fluent_builders::DeleteInput<C, M, R> {
        fluent_builders::DeleteInput::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteInputSecurityGroup` operation.
    ///
    /// See [`DeleteInputSecurityGroup`](crate::client::fluent_builders::DeleteInputSecurityGroup) for more information about the
    /// operation and its arguments.
    pub fn delete_input_security_group(
        &self,
    ) -> fluent_builders::DeleteInputSecurityGroup<C, M, R> {
        fluent_builders::DeleteInputSecurityGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteMultiplex` operation.
    ///
    /// See [`DeleteMultiplex`](crate::client::fluent_builders::DeleteMultiplex) for more information about the
    /// operation and its arguments.
    pub fn delete_multiplex(&self) -> fluent_builders::DeleteMultiplex<C, M, R> {
        fluent_builders::DeleteMultiplex::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteMultiplexProgram` operation.
    ///
    /// See [`DeleteMultiplexProgram`](crate::client::fluent_builders::DeleteMultiplexProgram) for more information about the
    /// operation and its arguments.
    pub fn delete_multiplex_program(&self) -> fluent_builders::DeleteMultiplexProgram<C, M, R> {
        fluent_builders::DeleteMultiplexProgram::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteReservation` operation.
    ///
    /// See [`DeleteReservation`](crate::client::fluent_builders::DeleteReservation) for more information about the
    /// operation and its arguments.
    pub fn delete_reservation(&self) -> fluent_builders::DeleteReservation<C, M, R> {
        fluent_builders::DeleteReservation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteSchedule` operation.
    ///
    /// See [`DeleteSchedule`](crate::client::fluent_builders::DeleteSchedule) for more information about the
    /// operation and its arguments.
    pub fn delete_schedule(&self) -> fluent_builders::DeleteSchedule<C, M, R> {
        fluent_builders::DeleteSchedule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteTags` operation.
    ///
    /// See [`DeleteTags`](crate::client::fluent_builders::DeleteTags) for more information about the
    /// operation and its arguments.
    pub fn delete_tags(&self) -> fluent_builders::DeleteTags<C, M, R> {
        fluent_builders::DeleteTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeChannel` operation.
    ///
    /// See [`DescribeChannel`](crate::client::fluent_builders::DescribeChannel) for more information about the
    /// operation and its arguments.
    pub fn describe_channel(&self) -> fluent_builders::DescribeChannel<C, M, R> {
        fluent_builders::DescribeChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeInput` operation.
    ///
    /// See [`DescribeInput`](crate::client::fluent_builders::DescribeInput) for more information about the
    /// operation and its arguments.
    pub fn describe_input(&self) -> fluent_builders::DescribeInput<C, M, R> {
        fluent_builders::DescribeInput::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeInputDevice` operation.
    ///
    /// See [`DescribeInputDevice`](crate::client::fluent_builders::DescribeInputDevice) for more information about the
    /// operation and its arguments.
    pub fn describe_input_device(&self) -> fluent_builders::DescribeInputDevice<C, M, R> {
        fluent_builders::DescribeInputDevice::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeInputDeviceThumbnail` operation.
    ///
    /// See [`DescribeInputDeviceThumbnail`](crate::client::fluent_builders::DescribeInputDeviceThumbnail) for more information about the
    /// operation and its arguments.
    pub fn describe_input_device_thumbnail(
        &self,
    ) -> fluent_builders::DescribeInputDeviceThumbnail<C, M, R> {
        fluent_builders::DescribeInputDeviceThumbnail::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeInputSecurityGroup` operation.
    ///
    /// See [`DescribeInputSecurityGroup`](crate::client::fluent_builders::DescribeInputSecurityGroup) for more information about the
    /// operation and its arguments.
    pub fn describe_input_security_group(
        &self,
    ) -> fluent_builders::DescribeInputSecurityGroup<C, M, R> {
        fluent_builders::DescribeInputSecurityGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeMultiplex` operation.
    ///
    /// See [`DescribeMultiplex`](crate::client::fluent_builders::DescribeMultiplex) for more information about the
    /// operation and its arguments.
    pub fn describe_multiplex(&self) -> fluent_builders::DescribeMultiplex<C, M, R> {
        fluent_builders::DescribeMultiplex::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeMultiplexProgram` operation.
    ///
    /// See [`DescribeMultiplexProgram`](crate::client::fluent_builders::DescribeMultiplexProgram) for more information about the
    /// operation and its arguments.
    pub fn describe_multiplex_program(&self) -> fluent_builders::DescribeMultiplexProgram<C, M, R> {
        fluent_builders::DescribeMultiplexProgram::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeOffering` operation.
    ///
    /// See [`DescribeOffering`](crate::client::fluent_builders::DescribeOffering) for more information about the
    /// operation and its arguments.
    pub fn describe_offering(&self) -> fluent_builders::DescribeOffering<C, M, R> {
        fluent_builders::DescribeOffering::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeReservation` operation.
    ///
    /// See [`DescribeReservation`](crate::client::fluent_builders::DescribeReservation) for more information about the
    /// operation and its arguments.
    pub fn describe_reservation(&self) -> fluent_builders::DescribeReservation<C, M, R> {
        fluent_builders::DescribeReservation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeSchedule` operation.
    ///
    /// See [`DescribeSchedule`](crate::client::fluent_builders::DescribeSchedule) for more information about the
    /// operation and its arguments.
    pub fn describe_schedule(&self) -> fluent_builders::DescribeSchedule<C, M, R> {
        fluent_builders::DescribeSchedule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListChannels` operation.
    ///
    /// See [`ListChannels`](crate::client::fluent_builders::ListChannels) for more information about the
    /// operation and its arguments.
    pub fn list_channels(&self) -> fluent_builders::ListChannels<C, M, R> {
        fluent_builders::ListChannels::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListInputDevices` operation.
    ///
    /// See [`ListInputDevices`](crate::client::fluent_builders::ListInputDevices) for more information about the
    /// operation and its arguments.
    pub fn list_input_devices(&self) -> fluent_builders::ListInputDevices<C, M, R> {
        fluent_builders::ListInputDevices::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListInputDeviceTransfers` operation.
    ///
    /// See [`ListInputDeviceTransfers`](crate::client::fluent_builders::ListInputDeviceTransfers) for more information about the
    /// operation and its arguments.
    pub fn list_input_device_transfers(
        &self,
    ) -> fluent_builders::ListInputDeviceTransfers<C, M, R> {
        fluent_builders::ListInputDeviceTransfers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListInputs` operation.
    ///
    /// See [`ListInputs`](crate::client::fluent_builders::ListInputs) for more information about the
    /// operation and its arguments.
    pub fn list_inputs(&self) -> fluent_builders::ListInputs<C, M, R> {
        fluent_builders::ListInputs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListInputSecurityGroups` operation.
    ///
    /// See [`ListInputSecurityGroups`](crate::client::fluent_builders::ListInputSecurityGroups) for more information about the
    /// operation and its arguments.
    pub fn list_input_security_groups(&self) -> fluent_builders::ListInputSecurityGroups<C, M, R> {
        fluent_builders::ListInputSecurityGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListMultiplexes` operation.
    ///
    /// See [`ListMultiplexes`](crate::client::fluent_builders::ListMultiplexes) for more information about the
    /// operation and its arguments.
    pub fn list_multiplexes(&self) -> fluent_builders::ListMultiplexes<C, M, R> {
        fluent_builders::ListMultiplexes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListMultiplexPrograms` operation.
    ///
    /// See [`ListMultiplexPrograms`](crate::client::fluent_builders::ListMultiplexPrograms) for more information about the
    /// operation and its arguments.
    pub fn list_multiplex_programs(&self) -> fluent_builders::ListMultiplexPrograms<C, M, R> {
        fluent_builders::ListMultiplexPrograms::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListOfferings` operation.
    ///
    /// See [`ListOfferings`](crate::client::fluent_builders::ListOfferings) for more information about the
    /// operation and its arguments.
    pub fn list_offerings(&self) -> fluent_builders::ListOfferings<C, M, R> {
        fluent_builders::ListOfferings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListReservations` operation.
    ///
    /// See [`ListReservations`](crate::client::fluent_builders::ListReservations) for more information about the
    /// operation and its arguments.
    pub fn list_reservations(&self) -> fluent_builders::ListReservations<C, M, R> {
        fluent_builders::ListReservations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PurchaseOffering` operation.
    ///
    /// See [`PurchaseOffering`](crate::client::fluent_builders::PurchaseOffering) for more information about the
    /// operation and its arguments.
    pub fn purchase_offering(&self) -> fluent_builders::PurchaseOffering<C, M, R> {
        fluent_builders::PurchaseOffering::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RejectInputDeviceTransfer` operation.
    ///
    /// See [`RejectInputDeviceTransfer`](crate::client::fluent_builders::RejectInputDeviceTransfer) for more information about the
    /// operation and its arguments.
    pub fn reject_input_device_transfer(
        &self,
    ) -> fluent_builders::RejectInputDeviceTransfer<C, M, R> {
        fluent_builders::RejectInputDeviceTransfer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartChannel` operation.
    ///
    /// See [`StartChannel`](crate::client::fluent_builders::StartChannel) for more information about the
    /// operation and its arguments.
    pub fn start_channel(&self) -> fluent_builders::StartChannel<C, M, R> {
        fluent_builders::StartChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartMultiplex` operation.
    ///
    /// See [`StartMultiplex`](crate::client::fluent_builders::StartMultiplex) for more information about the
    /// operation and its arguments.
    pub fn start_multiplex(&self) -> fluent_builders::StartMultiplex<C, M, R> {
        fluent_builders::StartMultiplex::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopChannel` operation.
    ///
    /// See [`StopChannel`](crate::client::fluent_builders::StopChannel) for more information about the
    /// operation and its arguments.
    pub fn stop_channel(&self) -> fluent_builders::StopChannel<C, M, R> {
        fluent_builders::StopChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopMultiplex` operation.
    ///
    /// See [`StopMultiplex`](crate::client::fluent_builders::StopMultiplex) for more information about the
    /// operation and its arguments.
    pub fn stop_multiplex(&self) -> fluent_builders::StopMultiplex<C, M, R> {
        fluent_builders::StopMultiplex::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TransferInputDevice` operation.
    ///
    /// See [`TransferInputDevice`](crate::client::fluent_builders::TransferInputDevice) for more information about the
    /// operation and its arguments.
    pub fn transfer_input_device(&self) -> fluent_builders::TransferInputDevice<C, M, R> {
        fluent_builders::TransferInputDevice::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateChannel` operation.
    ///
    /// See [`UpdateChannel`](crate::client::fluent_builders::UpdateChannel) for more information about the
    /// operation and its arguments.
    pub fn update_channel(&self) -> fluent_builders::UpdateChannel<C, M, R> {
        fluent_builders::UpdateChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateChannelClass` operation.
    ///
    /// See [`UpdateChannelClass`](crate::client::fluent_builders::UpdateChannelClass) for more information about the
    /// operation and its arguments.
    pub fn update_channel_class(&self) -> fluent_builders::UpdateChannelClass<C, M, R> {
        fluent_builders::UpdateChannelClass::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateInput` operation.
    ///
    /// See [`UpdateInput`](crate::client::fluent_builders::UpdateInput) for more information about the
    /// operation and its arguments.
    pub fn update_input(&self) -> fluent_builders::UpdateInput<C, M, R> {
        fluent_builders::UpdateInput::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateInputDevice` operation.
    ///
    /// See [`UpdateInputDevice`](crate::client::fluent_builders::UpdateInputDevice) for more information about the
    /// operation and its arguments.
    pub fn update_input_device(&self) -> fluent_builders::UpdateInputDevice<C, M, R> {
        fluent_builders::UpdateInputDevice::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateInputSecurityGroup` operation.
    ///
    /// See [`UpdateInputSecurityGroup`](crate::client::fluent_builders::UpdateInputSecurityGroup) for more information about the
    /// operation and its arguments.
    pub fn update_input_security_group(
        &self,
    ) -> fluent_builders::UpdateInputSecurityGroup<C, M, R> {
        fluent_builders::UpdateInputSecurityGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateMultiplex` operation.
    ///
    /// See [`UpdateMultiplex`](crate::client::fluent_builders::UpdateMultiplex) for more information about the
    /// operation and its arguments.
    pub fn update_multiplex(&self) -> fluent_builders::UpdateMultiplex<C, M, R> {
        fluent_builders::UpdateMultiplex::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateMultiplexProgram` operation.
    ///
    /// See [`UpdateMultiplexProgram`](crate::client::fluent_builders::UpdateMultiplexProgram) for more information about the
    /// operation and its arguments.
    pub fn update_multiplex_program(&self) -> fluent_builders::UpdateMultiplexProgram<C, M, R> {
        fluent_builders::UpdateMultiplexProgram::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateReservation` operation.
    ///
    /// See [`UpdateReservation`](crate::client::fluent_builders::UpdateReservation) for more information about the
    /// operation and its arguments.
    pub fn update_reservation(&self) -> fluent_builders::UpdateReservation<C, M, R> {
        fluent_builders::UpdateReservation::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AcceptInputDeviceTransfer`.
    ///
    /// Accept an incoming input device transfer. The ownership of the device will transfer to your AWS account.
    #[derive(std::fmt::Debug)]
    pub struct AcceptInputDeviceTransfer<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::accept_input_device_transfer_input::Builder,
    }
    impl<C, M, R> AcceptInputDeviceTransfer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AcceptInputDeviceTransfer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AcceptInputDeviceTransferOutput,
            aws_smithy_http::result::SdkError<crate::error::AcceptInputDeviceTransferError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AcceptInputDeviceTransferInputOperationOutputAlias,
                crate::output::AcceptInputDeviceTransferOutput,
                crate::error::AcceptInputDeviceTransferError,
                crate::input::AcceptInputDeviceTransferInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The unique ID of the input device to accept. For example, hd-123456789abcdef.
        pub fn input_device_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.input_device_id(inp);
            self
        }
        /// The unique ID of the input device to accept. For example, hd-123456789abcdef.
        pub fn set_input_device_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_input_device_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchDelete`.
    ///
    /// Starts delete of resources.
    #[derive(std::fmt::Debug)]
    pub struct BatchDelete<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_delete_input::Builder,
    }
    impl<C, M, R> BatchDelete<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchDelete`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchDeleteOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchDeleteError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchDeleteInputOperationOutputAlias,
                crate::output::BatchDeleteOutput,
                crate::error::BatchDeleteError,
                crate::input::BatchDeleteInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `ChannelIds`.
        ///
        /// To override the contents of this collection use [`set_channel_ids`](Self::set_channel_ids).
        ///
        /// List of channel IDs
        pub fn channel_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_ids(inp);
            self
        }
        /// List of channel IDs
        pub fn set_channel_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_channel_ids(input);
            self
        }
        /// Appends an item to `InputIds`.
        ///
        /// To override the contents of this collection use [`set_input_ids`](Self::set_input_ids).
        ///
        /// List of input IDs
        pub fn input_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.input_ids(inp);
            self
        }
        /// List of input IDs
        pub fn set_input_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_input_ids(input);
            self
        }
        /// Appends an item to `InputSecurityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_input_security_group_ids`](Self::set_input_security_group_ids).
        ///
        /// List of input security group IDs
        pub fn input_security_group_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.input_security_group_ids(inp);
            self
        }
        /// List of input security group IDs
        pub fn set_input_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_input_security_group_ids(input);
            self
        }
        /// Appends an item to `MultiplexIds`.
        ///
        /// To override the contents of this collection use [`set_multiplex_ids`](Self::set_multiplex_ids).
        ///
        /// List of multiplex IDs
        pub fn multiplex_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.multiplex_ids(inp);
            self
        }
        /// List of multiplex IDs
        pub fn set_multiplex_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_multiplex_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchStart`.
    ///
    /// Starts existing resources
    #[derive(std::fmt::Debug)]
    pub struct BatchStart<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_start_input::Builder,
    }
    impl<C, M, R> BatchStart<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchStart`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchStartOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchStartError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchStartInputOperationOutputAlias,
                crate::output::BatchStartOutput,
                crate::error::BatchStartError,
                crate::input::BatchStartInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `ChannelIds`.
        ///
        /// To override the contents of this collection use [`set_channel_ids`](Self::set_channel_ids).
        ///
        /// List of channel IDs
        pub fn channel_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_ids(inp);
            self
        }
        /// List of channel IDs
        pub fn set_channel_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_channel_ids(input);
            self
        }
        /// Appends an item to `MultiplexIds`.
        ///
        /// To override the contents of this collection use [`set_multiplex_ids`](Self::set_multiplex_ids).
        ///
        /// List of multiplex IDs
        pub fn multiplex_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.multiplex_ids(inp);
            self
        }
        /// List of multiplex IDs
        pub fn set_multiplex_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_multiplex_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchStop`.
    ///
    /// Stops running resources
    #[derive(std::fmt::Debug)]
    pub struct BatchStop<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_stop_input::Builder,
    }
    impl<C, M, R> BatchStop<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchStop`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchStopOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchStopError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchStopInputOperationOutputAlias,
                crate::output::BatchStopOutput,
                crate::error::BatchStopError,
                crate::input::BatchStopInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `ChannelIds`.
        ///
        /// To override the contents of this collection use [`set_channel_ids`](Self::set_channel_ids).
        ///
        /// List of channel IDs
        pub fn channel_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_ids(inp);
            self
        }
        /// List of channel IDs
        pub fn set_channel_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_channel_ids(input);
            self
        }
        /// Appends an item to `MultiplexIds`.
        ///
        /// To override the contents of this collection use [`set_multiplex_ids`](Self::set_multiplex_ids).
        ///
        /// List of multiplex IDs
        pub fn multiplex_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.multiplex_ids(inp);
            self
        }
        /// List of multiplex IDs
        pub fn set_multiplex_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_multiplex_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchUpdateSchedule`.
    ///
    /// Update a channel schedule
    #[derive(std::fmt::Debug)]
    pub struct BatchUpdateSchedule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_update_schedule_input::Builder,
    }
    impl<C, M, R> BatchUpdateSchedule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchUpdateSchedule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchUpdateScheduleOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchUpdateScheduleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchUpdateScheduleInputOperationOutputAlias,
                crate::output::BatchUpdateScheduleOutput,
                crate::error::BatchUpdateScheduleError,
                crate::input::BatchUpdateScheduleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Id of the channel whose schedule is being updated.
        pub fn channel_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_id(inp);
            self
        }
        /// Id of the channel whose schedule is being updated.
        pub fn set_channel_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_id(input);
            self
        }
        /// Schedule actions to create in the schedule.
        pub fn creates(mut self, inp: crate::model::BatchScheduleActionCreateRequest) -> Self {
            self.inner = self.inner.creates(inp);
            self
        }
        /// Schedule actions to create in the schedule.
        pub fn set_creates(
            mut self,
            input: std::option::Option<crate::model::BatchScheduleActionCreateRequest>,
        ) -> Self {
            self.inner = self.inner.set_creates(input);
            self
        }
        /// Schedule actions to delete from the schedule.
        pub fn deletes(mut self, inp: crate::model::BatchScheduleActionDeleteRequest) -> Self {
            self.inner = self.inner.deletes(inp);
            self
        }
        /// Schedule actions to delete from the schedule.
        pub fn set_deletes(
            mut self,
            input: std::option::Option<crate::model::BatchScheduleActionDeleteRequest>,
        ) -> Self {
            self.inner = self.inner.set_deletes(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelInputDeviceTransfer`.
    ///
    /// Cancel an input device transfer that you have requested.
    #[derive(std::fmt::Debug)]
    pub struct CancelInputDeviceTransfer<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_input_device_transfer_input::Builder,
    }
    impl<C, M, R> CancelInputDeviceTransfer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelInputDeviceTransfer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelInputDeviceTransferOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelInputDeviceTransferError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelInputDeviceTransferInputOperationOutputAlias,
                crate::output::CancelInputDeviceTransferOutput,
                crate::error::CancelInputDeviceTransferError,
                crate::input::CancelInputDeviceTransferInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The unique ID of the input device to cancel. For example, hd-123456789abcdef.
        pub fn input_device_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.input_device_id(inp);
            self
        }
        /// The unique ID of the input device to cancel. For example, hd-123456789abcdef.
        pub fn set_input_device_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_input_device_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ClaimDevice`.
    ///
    /// Send a request to claim an AWS Elemental device that you have purchased from a third-party vendor. After the request succeeds, you will own the device.
    #[derive(std::fmt::Debug)]
    pub struct ClaimDevice<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::claim_device_input::Builder,
    }
    impl<C, M, R> ClaimDevice<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ClaimDevice`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ClaimDeviceOutput,
            aws_smithy_http::result::SdkError<crate::error::ClaimDeviceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ClaimDeviceInputOperationOutputAlias,
                crate::output::ClaimDeviceOutput,
                crate::error::ClaimDeviceError,
                crate::input::ClaimDeviceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The id of the device you want to claim.
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// The id of the device you want to claim.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateChannel`.
    ///
    /// Creates a new channel
    #[derive(std::fmt::Debug)]
    pub struct CreateChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_channel_input::Builder,
    }
    impl<C, M, R> CreateChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateChannelInputOperationOutputAlias,
                crate::output::CreateChannelOutput,
                crate::error::CreateChannelError,
                crate::input::CreateChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Specification of CDI inputs for this channel
        pub fn cdi_input_specification(mut self, inp: crate::model::CdiInputSpecification) -> Self {
            self.inner = self.inner.cdi_input_specification(inp);
            self
        }
        /// Specification of CDI inputs for this channel
        pub fn set_cdi_input_specification(
            mut self,
            input: std::option::Option<crate::model::CdiInputSpecification>,
        ) -> Self {
            self.inner = self.inner.set_cdi_input_specification(input);
            self
        }
        /// The class for this channel. STANDARD for a channel with two pipelines or SINGLE_PIPELINE for a channel with one pipeline.
        pub fn channel_class(mut self, inp: crate::model::ChannelClass) -> Self {
            self.inner = self.inner.channel_class(inp);
            self
        }
        /// The class for this channel. STANDARD for a channel with two pipelines or SINGLE_PIPELINE for a channel with one pipeline.
        pub fn set_channel_class(
            mut self,
            input: std::option::Option<crate::model::ChannelClass>,
        ) -> Self {
            self.inner = self.inner.set_channel_class(input);
            self
        }
        /// Appends an item to `Destinations`.
        ///
        /// To override the contents of this collection use [`set_destinations`](Self::set_destinations).
        ///
        /// Placeholder documentation for __listOfOutputDestination
        pub fn destinations(mut self, inp: impl Into<crate::model::OutputDestination>) -> Self {
            self.inner = self.inner.destinations(inp);
            self
        }
        /// Placeholder documentation for __listOfOutputDestination
        pub fn set_destinations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OutputDestination>>,
        ) -> Self {
            self.inner = self.inner.set_destinations(input);
            self
        }
        /// Encoder Settings
        pub fn encoder_settings(mut self, inp: crate::model::EncoderSettings) -> Self {
            self.inner = self.inner.encoder_settings(inp);
            self
        }
        /// Encoder Settings
        pub fn set_encoder_settings(
            mut self,
            input: std::option::Option<crate::model::EncoderSettings>,
        ) -> Self {
            self.inner = self.inner.set_encoder_settings(input);
            self
        }
        /// Appends an item to `InputAttachments`.
        ///
        /// To override the contents of this collection use [`set_input_attachments`](Self::set_input_attachments).
        ///
        /// List of input attachments for channel.
        pub fn input_attachments(mut self, inp: impl Into<crate::model::InputAttachment>) -> Self {
            self.inner = self.inner.input_attachments(inp);
            self
        }
        /// List of input attachments for channel.
        pub fn set_input_attachments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InputAttachment>>,
        ) -> Self {
            self.inner = self.inner.set_input_attachments(input);
            self
        }
        /// Specification of network and file inputs for this channel
        pub fn input_specification(mut self, inp: crate::model::InputSpecification) -> Self {
            self.inner = self.inner.input_specification(inp);
            self
        }
        /// Specification of network and file inputs for this channel
        pub fn set_input_specification(
            mut self,
            input: std::option::Option<crate::model::InputSpecification>,
        ) -> Self {
            self.inner = self.inner.set_input_specification(input);
            self
        }
        /// The log level to write to CloudWatch Logs.
        pub fn log_level(mut self, inp: crate::model::LogLevel) -> Self {
            self.inner = self.inner.log_level(inp);
            self
        }
        /// The log level to write to CloudWatch Logs.
        pub fn set_log_level(mut self, input: std::option::Option<crate::model::LogLevel>) -> Self {
            self.inner = self.inner.set_log_level(input);
            self
        }
        /// Name of channel.
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// Name of channel.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Unique request ID to be specified. This is needed to prevent retries from
        /// creating multiple resources.
        pub fn request_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.request_id(inp);
            self
        }
        /// Unique request ID to be specified. This is needed to prevent retries from
        /// creating multiple resources.
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_request_id(input);
            self
        }
        /// Deprecated field that's only usable by whitelisted customers.
        pub fn reserved(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reserved(inp);
            self
        }
        /// Deprecated field that's only usable by whitelisted customers.
        pub fn set_reserved(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_reserved(input);
            self
        }
        /// An optional Amazon Resource Name (ARN) of the role to assume when running the Channel.
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// An optional Amazon Resource Name (ARN) of the role to assume when running the Channel.
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of key-value pairs.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// A collection of key-value pairs.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// Settings for the VPC outputs
        pub fn vpc(mut self, inp: crate::model::VpcOutputSettings) -> Self {
            self.inner = self.inner.vpc(inp);
            self
        }
        /// Settings for the VPC outputs
        pub fn set_vpc(
            mut self,
            input: std::option::Option<crate::model::VpcOutputSettings>,
        ) -> Self {
            self.inner = self.inner.set_vpc(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateInput`.
    ///
    /// Create an input
    #[derive(std::fmt::Debug)]
    pub struct CreateInput<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_input_input::Builder,
    }
    impl<C, M, R> CreateInput<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateInput`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateInputOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateInputError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateInputInputOperationOutputAlias,
                crate::output::CreateInputOutput,
                crate::error::CreateInputError,
                crate::input::CreateInputInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Destinations`.
        ///
        /// To override the contents of this collection use [`set_destinations`](Self::set_destinations).
        ///
        /// Destination settings for PUSH type inputs.
        pub fn destinations(
            mut self,
            inp: impl Into<crate::model::InputDestinationRequest>,
        ) -> Self {
            self.inner = self.inner.destinations(inp);
            self
        }
        /// Destination settings for PUSH type inputs.
        pub fn set_destinations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InputDestinationRequest>>,
        ) -> Self {
            self.inner = self.inner.set_destinations(input);
            self
        }
        /// Appends an item to `InputDevices`.
        ///
        /// To override the contents of this collection use [`set_input_devices`](Self::set_input_devices).
        ///
        /// Settings for the devices.
        pub fn input_devices(mut self, inp: impl Into<crate::model::InputDeviceSettings>) -> Self {
            self.inner = self.inner.input_devices(inp);
            self
        }
        /// Settings for the devices.
        pub fn set_input_devices(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InputDeviceSettings>>,
        ) -> Self {
            self.inner = self.inner.set_input_devices(input);
            self
        }
        /// Appends an item to `InputSecurityGroups`.
        ///
        /// To override the contents of this collection use [`set_input_security_groups`](Self::set_input_security_groups).
        ///
        /// A list of security groups referenced by IDs to attach to the input.
        pub fn input_security_groups(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.input_security_groups(inp);
            self
        }
        /// A list of security groups referenced by IDs to attach to the input.
        pub fn set_input_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_input_security_groups(input);
            self
        }
        /// Appends an item to `MediaConnectFlows`.
        ///
        /// To override the contents of this collection use [`set_media_connect_flows`](Self::set_media_connect_flows).
        ///
        /// A list of the MediaConnect Flows that you want to use in this input. You can specify as few as one
        /// Flow and presently, as many as two. The only requirement is when you have more than one is that each Flow is in a
        /// separate Availability Zone as this ensures your EML input is redundant to AZ issues.
        pub fn media_connect_flows(
            mut self,
            inp: impl Into<crate::model::MediaConnectFlowRequest>,
        ) -> Self {
            self.inner = self.inner.media_connect_flows(inp);
            self
        }
        /// A list of the MediaConnect Flows that you want to use in this input. You can specify as few as one
        /// Flow and presently, as many as two. The only requirement is when you have more than one is that each Flow is in a
        /// separate Availability Zone as this ensures your EML input is redundant to AZ issues.
        pub fn set_media_connect_flows(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MediaConnectFlowRequest>>,
        ) -> Self {
            self.inner = self.inner.set_media_connect_flows(input);
            self
        }
        /// Name of the input.
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// Name of the input.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Unique identifier of the request to ensure the request is handled
        /// exactly once in case of retries.
        pub fn request_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.request_id(inp);
            self
        }
        /// Unique identifier of the request to ensure the request is handled
        /// exactly once in case of retries.
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_request_id(input);
            self
        }
        /// The Amazon Resource Name (ARN) of the role this input assumes during and after creation.
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// The Amazon Resource Name (ARN) of the role this input assumes during and after creation.
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// Appends an item to `Sources`.
        ///
        /// To override the contents of this collection use [`set_sources`](Self::set_sources).
        ///
        /// The source URLs for a PULL-type input. Every PULL type input needs
        /// exactly two source URLs for redundancy.
        /// Only specify sources for PULL type Inputs. Leave Destinations empty.
        pub fn sources(mut self, inp: impl Into<crate::model::InputSourceRequest>) -> Self {
            self.inner = self.inner.sources(inp);
            self
        }
        /// The source URLs for a PULL-type input. Every PULL type input needs
        /// exactly two source URLs for redundancy.
        /// Only specify sources for PULL type Inputs. Leave Destinations empty.
        pub fn set_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InputSourceRequest>>,
        ) -> Self {
            self.inner = self.inner.set_sources(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of key-value pairs.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// A collection of key-value pairs.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// The different types of inputs that AWS Elemental MediaLive supports.
        pub fn r#type(mut self, inp: crate::model::InputType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// The different types of inputs that AWS Elemental MediaLive supports.
        pub fn set_type(mut self, input: std::option::Option<crate::model::InputType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// Settings for a private VPC Input.
        /// When this property is specified, the input destination addresses will be created in a VPC rather than with public Internet addresses.
        /// This property requires setting the roleArn property on Input creation.
        /// Not compatible with the inputSecurityGroups property.
        pub fn vpc(mut self, inp: crate::model::InputVpcRequest) -> Self {
            self.inner = self.inner.vpc(inp);
            self
        }
        /// Settings for a private VPC Input.
        /// When this property is specified, the input destination addresses will be created in a VPC rather than with public Internet addresses.
        /// This property requires setting the roleArn property on Input creation.
        /// Not compatible with the inputSecurityGroups property.
        pub fn set_vpc(
            mut self,
            input: std::option::Option<crate::model::InputVpcRequest>,
        ) -> Self {
            self.inner = self.inner.set_vpc(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateInputSecurityGroup`.
    ///
    /// Creates a Input Security Group
    #[derive(std::fmt::Debug)]
    pub struct CreateInputSecurityGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_input_security_group_input::Builder,
    }
    impl<C, M, R> CreateInputSecurityGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateInputSecurityGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateInputSecurityGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateInputSecurityGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateInputSecurityGroupInputOperationOutputAlias,
                crate::output::CreateInputSecurityGroupOutput,
                crate::error::CreateInputSecurityGroupError,
                crate::input::CreateInputSecurityGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of key-value pairs.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// A collection of key-value pairs.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// Appends an item to `WhitelistRules`.
        ///
        /// To override the contents of this collection use [`set_whitelist_rules`](Self::set_whitelist_rules).
        ///
        /// List of IPv4 CIDR addresses to whitelist
        pub fn whitelist_rules(
            mut self,
            inp: impl Into<crate::model::InputWhitelistRuleCidr>,
        ) -> Self {
            self.inner = self.inner.whitelist_rules(inp);
            self
        }
        /// List of IPv4 CIDR addresses to whitelist
        pub fn set_whitelist_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InputWhitelistRuleCidr>>,
        ) -> Self {
            self.inner = self.inner.set_whitelist_rules(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateMultiplex`.
    ///
    /// Create a new multiplex.
    #[derive(std::fmt::Debug)]
    pub struct CreateMultiplex<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_multiplex_input::Builder,
    }
    impl<C, M, R> CreateMultiplex<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateMultiplex`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateMultiplexOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateMultiplexError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateMultiplexInputOperationOutputAlias,
                crate::output::CreateMultiplexOutput,
                crate::error::CreateMultiplexError,
                crate::input::CreateMultiplexInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `AvailabilityZones`.
        ///
        /// To override the contents of this collection use [`set_availability_zones`](Self::set_availability_zones).
        ///
        /// A list of availability zones for the multiplex. You must specify exactly two.
        pub fn availability_zones(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.availability_zones(inp);
            self
        }
        /// A list of availability zones for the multiplex. You must specify exactly two.
        pub fn set_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_availability_zones(input);
            self
        }
        /// Configuration for a multiplex event.
        pub fn multiplex_settings(mut self, inp: crate::model::MultiplexSettings) -> Self {
            self.inner = self.inner.multiplex_settings(inp);
            self
        }
        /// Configuration for a multiplex event.
        pub fn set_multiplex_settings(
            mut self,
            input: std::option::Option<crate::model::MultiplexSettings>,
        ) -> Self {
            self.inner = self.inner.set_multiplex_settings(input);
            self
        }
        /// Name of multiplex.
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// Name of multiplex.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Unique request ID. This prevents retries from creating multiple
        /// resources.
        pub fn request_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.request_id(inp);
            self
        }
        /// Unique request ID. This prevents retries from creating multiple
        /// resources.
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_request_id(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of key-value pairs.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// A collection of key-value pairs.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateMultiplexProgram`.
    ///
    /// Create a new program in the multiplex.
    #[derive(std::fmt::Debug)]
    pub struct CreateMultiplexProgram<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_multiplex_program_input::Builder,
    }
    impl<C, M, R> CreateMultiplexProgram<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateMultiplexProgram`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateMultiplexProgramOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateMultiplexProgramError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateMultiplexProgramInputOperationOutputAlias,
                crate::output::CreateMultiplexProgramOutput,
                crate::error::CreateMultiplexProgramError,
                crate::input::CreateMultiplexProgramInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// ID of the multiplex where the program is to be created.
        pub fn multiplex_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.multiplex_id(inp);
            self
        }
        /// ID of the multiplex where the program is to be created.
        pub fn set_multiplex_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_multiplex_id(input);
            self
        }
        /// The settings for this multiplex program.
        pub fn multiplex_program_settings(
            mut self,
            inp: crate::model::MultiplexProgramSettings,
        ) -> Self {
            self.inner = self.inner.multiplex_program_settings(inp);
            self
        }
        /// The settings for this multiplex program.
        pub fn set_multiplex_program_settings(
            mut self,
            input: std::option::Option<crate::model::MultiplexProgramSettings>,
        ) -> Self {
            self.inner = self.inner.set_multiplex_program_settings(input);
            self
        }
        /// Name of multiplex program.
        pub fn program_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.program_name(inp);
            self
        }
        /// Name of multiplex program.
        pub fn set_program_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_program_name(input);
            self
        }
        /// Unique request ID. This prevents retries from creating multiple
        /// resources.
        pub fn request_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.request_id(inp);
            self
        }
        /// Unique request ID. This prevents retries from creating multiple
        /// resources.
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_request_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePartnerInput`.
    ///
    /// Create a partner input
    #[derive(std::fmt::Debug)]
    pub struct CreatePartnerInput<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_partner_input_input::Builder,
    }
    impl<C, M, R> CreatePartnerInput<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreatePartnerInput`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePartnerInputOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePartnerInputError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreatePartnerInputInputOperationOutputAlias,
                crate::output::CreatePartnerInputOutput,
                crate::error::CreatePartnerInputError,
                crate::input::CreatePartnerInputInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Unique ID of the input.
        pub fn input_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.input_id(inp);
            self
        }
        /// Unique ID of the input.
        pub fn set_input_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_input_id(input);
            self
        }
        /// Unique identifier of the request to ensure the request is handled
        /// exactly once in case of retries.
        pub fn request_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.request_id(inp);
            self
        }
        /// Unique identifier of the request to ensure the request is handled
        /// exactly once in case of retries.
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_request_id(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of key-value pairs.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// A collection of key-value pairs.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTags`.
    ///
    /// Create tags for a resource
    #[derive(std::fmt::Debug)]
    pub struct CreateTags<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_tags_input::Builder,
    }
    impl<C, M, R> CreateTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateTagsInputOperationOutputAlias,
                crate::output::CreateTagsOutput,
                crate::error::CreateTagsError,
                crate::input::CreateTagsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Placeholder documentation for __string
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// Placeholder documentation for __string
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// Placeholder documentation for Tags
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// Placeholder documentation for Tags
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteChannel`.
    ///
    /// Starts deletion of channel. The associated outputs are also deleted.
    #[derive(std::fmt::Debug)]
    pub struct DeleteChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_channel_input::Builder,
    }
    impl<C, M, R> DeleteChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteChannelInputOperationOutputAlias,
                crate::output::DeleteChannelOutput,
                crate::error::DeleteChannelError,
                crate::input::DeleteChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Unique ID of the channel.
        pub fn channel_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_id(inp);
            self
        }
        /// Unique ID of the channel.
        pub fn set_channel_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteInput`.
    ///
    /// Deletes the input end point
    #[derive(std::fmt::Debug)]
    pub struct DeleteInput<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_input_input::Builder,
    }
    impl<C, M, R> DeleteInput<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteInput`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteInputOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteInputError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteInputInputOperationOutputAlias,
                crate::output::DeleteInputOutput,
                crate::error::DeleteInputError,
                crate::input::DeleteInputInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Unique ID of the input
        pub fn input_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.input_id(inp);
            self
        }
        /// Unique ID of the input
        pub fn set_input_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_input_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteInputSecurityGroup`.
    ///
    /// Deletes an Input Security Group
    #[derive(std::fmt::Debug)]
    pub struct DeleteInputSecurityGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_input_security_group_input::Builder,
    }
    impl<C, M, R> DeleteInputSecurityGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteInputSecurityGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteInputSecurityGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteInputSecurityGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteInputSecurityGroupInputOperationOutputAlias,
                crate::output::DeleteInputSecurityGroupOutput,
                crate::error::DeleteInputSecurityGroupError,
                crate::input::DeleteInputSecurityGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The Input Security Group to delete
        pub fn input_security_group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.input_security_group_id(inp);
            self
        }
        /// The Input Security Group to delete
        pub fn set_input_security_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_input_security_group_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteMultiplex`.
    ///
    /// Delete a multiplex. The multiplex must be idle.
    #[derive(std::fmt::Debug)]
    pub struct DeleteMultiplex<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_multiplex_input::Builder,
    }
    impl<C, M, R> DeleteMultiplex<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteMultiplex`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteMultiplexOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteMultiplexError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteMultiplexInputOperationOutputAlias,
                crate::output::DeleteMultiplexOutput,
                crate::error::DeleteMultiplexError,
                crate::input::DeleteMultiplexInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the multiplex.
        pub fn multiplex_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.multiplex_id(inp);
            self
        }
        /// The ID of the multiplex.
        pub fn set_multiplex_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_multiplex_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteMultiplexProgram`.
    ///
    /// Delete a program from a multiplex.
    #[derive(std::fmt::Debug)]
    pub struct DeleteMultiplexProgram<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_multiplex_program_input::Builder,
    }
    impl<C, M, R> DeleteMultiplexProgram<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteMultiplexProgram`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteMultiplexProgramOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteMultiplexProgramError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteMultiplexProgramInputOperationOutputAlias,
                crate::output::DeleteMultiplexProgramOutput,
                crate::error::DeleteMultiplexProgramError,
                crate::input::DeleteMultiplexProgramInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the multiplex that the program belongs to.
        pub fn multiplex_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.multiplex_id(inp);
            self
        }
        /// The ID of the multiplex that the program belongs to.
        pub fn set_multiplex_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_multiplex_id(input);
            self
        }
        /// The multiplex program name.
        pub fn program_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.program_name(inp);
            self
        }
        /// The multiplex program name.
        pub fn set_program_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_program_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteReservation`.
    ///
    /// Delete an expired reservation.
    #[derive(std::fmt::Debug)]
    pub struct DeleteReservation<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_reservation_input::Builder,
    }
    impl<C, M, R> DeleteReservation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteReservation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteReservationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteReservationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteReservationInputOperationOutputAlias,
                crate::output::DeleteReservationOutput,
                crate::error::DeleteReservationError,
                crate::input::DeleteReservationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Unique reservation ID, e.g. '1234567'
        pub fn reservation_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reservation_id(inp);
            self
        }
        /// Unique reservation ID, e.g. '1234567'
        pub fn set_reservation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_reservation_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSchedule`.
    ///
    /// Delete all schedule actions on a channel.
    #[derive(std::fmt::Debug)]
    pub struct DeleteSchedule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_schedule_input::Builder,
    }
    impl<C, M, R> DeleteSchedule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteSchedule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteScheduleOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteScheduleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteScheduleInputOperationOutputAlias,
                crate::output::DeleteScheduleOutput,
                crate::error::DeleteScheduleError,
                crate::input::DeleteScheduleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Id of the channel whose schedule is being deleted.
        pub fn channel_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_id(inp);
            self
        }
        /// Id of the channel whose schedule is being deleted.
        pub fn set_channel_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTags`.
    ///
    /// Removes tags for a resource
    #[derive(std::fmt::Debug)]
    pub struct DeleteTags<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_tags_input::Builder,
    }
    impl<C, M, R> DeleteTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteTagsInputOperationOutputAlias,
                crate::output::DeleteTagsOutput,
                crate::error::DeleteTagsError,
                crate::input::DeleteTagsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Placeholder documentation for __string
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// Placeholder documentation for __string
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// An array of tag keys to delete
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// An array of tag keys to delete
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeChannel`.
    ///
    /// Gets details about a channel
    #[derive(std::fmt::Debug)]
    pub struct DescribeChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_channel_input::Builder,
    }
    impl<C, M, R> DescribeChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeChannelInputOperationOutputAlias,
                crate::output::DescribeChannelOutput,
                crate::error::DescribeChannelError,
                crate::input::DescribeChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// channel ID
        pub fn channel_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_id(inp);
            self
        }
        /// channel ID
        pub fn set_channel_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeInput`.
    ///
    /// Produces details about an input
    #[derive(std::fmt::Debug)]
    pub struct DescribeInput<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_input_input::Builder,
    }
    impl<C, M, R> DescribeInput<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeInput`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeInputOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeInputError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeInputInputOperationOutputAlias,
                crate::output::DescribeInputOutput,
                crate::error::DescribeInputError,
                crate::input::DescribeInputInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Unique ID of the input
        pub fn input_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.input_id(inp);
            self
        }
        /// Unique ID of the input
        pub fn set_input_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_input_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeInputDevice`.
    ///
    /// Gets the details for the input device
    #[derive(std::fmt::Debug)]
    pub struct DescribeInputDevice<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_input_device_input::Builder,
    }
    impl<C, M, R> DescribeInputDevice<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeInputDevice`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeInputDeviceOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeInputDeviceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeInputDeviceInputOperationOutputAlias,
                crate::output::DescribeInputDeviceOutput,
                crate::error::DescribeInputDeviceError,
                crate::input::DescribeInputDeviceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The unique ID of this input device. For example, hd-123456789abcdef.
        pub fn input_device_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.input_device_id(inp);
            self
        }
        /// The unique ID of this input device. For example, hd-123456789abcdef.
        pub fn set_input_device_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_input_device_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeInputDeviceThumbnail`.
    ///
    /// Get the latest thumbnail data for the input device.
    #[derive(std::fmt::Debug)]
    pub struct DescribeInputDeviceThumbnail<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_input_device_thumbnail_input::Builder,
    }
    impl<C, M, R> DescribeInputDeviceThumbnail<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeInputDeviceThumbnail`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeInputDeviceThumbnailOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeInputDeviceThumbnailError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeInputDeviceThumbnailInputOperationOutputAlias,
                crate::output::DescribeInputDeviceThumbnailOutput,
                crate::error::DescribeInputDeviceThumbnailError,
                crate::input::DescribeInputDeviceThumbnailInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The unique ID of this input device. For example, hd-123456789abcdef.
        pub fn input_device_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.input_device_id(inp);
            self
        }
        /// The unique ID of this input device. For example, hd-123456789abcdef.
        pub fn set_input_device_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_input_device_id(input);
            self
        }
        /// The HTTP Accept header. Indicates the requested type for the thumbnail.
        pub fn accept(mut self, inp: crate::model::AcceptHeader) -> Self {
            self.inner = self.inner.accept(inp);
            self
        }
        /// The HTTP Accept header. Indicates the requested type for the thumbnail.
        pub fn set_accept(
            mut self,
            input: std::option::Option<crate::model::AcceptHeader>,
        ) -> Self {
            self.inner = self.inner.set_accept(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeInputSecurityGroup`.
    ///
    /// Produces a summary of an Input Security Group
    #[derive(std::fmt::Debug)]
    pub struct DescribeInputSecurityGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_input_security_group_input::Builder,
    }
    impl<C, M, R> DescribeInputSecurityGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeInputSecurityGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeInputSecurityGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeInputSecurityGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeInputSecurityGroupInputOperationOutputAlias,
                crate::output::DescribeInputSecurityGroupOutput,
                crate::error::DescribeInputSecurityGroupError,
                crate::input::DescribeInputSecurityGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The id of the Input Security Group to describe
        pub fn input_security_group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.input_security_group_id(inp);
            self
        }
        /// The id of the Input Security Group to describe
        pub fn set_input_security_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_input_security_group_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeMultiplex`.
    ///
    /// Gets details about a multiplex.
    #[derive(std::fmt::Debug)]
    pub struct DescribeMultiplex<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_multiplex_input::Builder,
    }
    impl<C, M, R> DescribeMultiplex<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeMultiplex`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeMultiplexOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeMultiplexError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeMultiplexInputOperationOutputAlias,
                crate::output::DescribeMultiplexOutput,
                crate::error::DescribeMultiplexError,
                crate::input::DescribeMultiplexInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the multiplex.
        pub fn multiplex_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.multiplex_id(inp);
            self
        }
        /// The ID of the multiplex.
        pub fn set_multiplex_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_multiplex_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeMultiplexProgram`.
    ///
    /// Get the details for a program in a multiplex.
    #[derive(std::fmt::Debug)]
    pub struct DescribeMultiplexProgram<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_multiplex_program_input::Builder,
    }
    impl<C, M, R> DescribeMultiplexProgram<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeMultiplexProgram`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeMultiplexProgramOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeMultiplexProgramError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeMultiplexProgramInputOperationOutputAlias,
                crate::output::DescribeMultiplexProgramOutput,
                crate::error::DescribeMultiplexProgramError,
                crate::input::DescribeMultiplexProgramInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the multiplex that the program belongs to.
        pub fn multiplex_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.multiplex_id(inp);
            self
        }
        /// The ID of the multiplex that the program belongs to.
        pub fn set_multiplex_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_multiplex_id(input);
            self
        }
        /// The name of the program.
        pub fn program_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.program_name(inp);
            self
        }
        /// The name of the program.
        pub fn set_program_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_program_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeOffering`.
    ///
    /// Get details for an offering.
    #[derive(std::fmt::Debug)]
    pub struct DescribeOffering<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_offering_input::Builder,
    }
    impl<C, M, R> DescribeOffering<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeOffering`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeOfferingOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeOfferingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeOfferingInputOperationOutputAlias,
                crate::output::DescribeOfferingOutput,
                crate::error::DescribeOfferingError,
                crate::input::DescribeOfferingInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Unique offering ID, e.g. '87654321'
        pub fn offering_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.offering_id(inp);
            self
        }
        /// Unique offering ID, e.g. '87654321'
        pub fn set_offering_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_offering_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeReservation`.
    ///
    /// Get details for a reservation.
    #[derive(std::fmt::Debug)]
    pub struct DescribeReservation<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_reservation_input::Builder,
    }
    impl<C, M, R> DescribeReservation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeReservation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeReservationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeReservationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeReservationInputOperationOutputAlias,
                crate::output::DescribeReservationOutput,
                crate::error::DescribeReservationError,
                crate::input::DescribeReservationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Unique reservation ID, e.g. '1234567'
        pub fn reservation_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reservation_id(inp);
            self
        }
        /// Unique reservation ID, e.g. '1234567'
        pub fn set_reservation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_reservation_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSchedule`.
    ///
    /// Get a channel schedule
    #[derive(std::fmt::Debug)]
    pub struct DescribeSchedule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_schedule_input::Builder,
    }
    impl<C, M, R> DescribeSchedule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeSchedule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeScheduleOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeScheduleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeScheduleInputOperationOutputAlias,
                crate::output::DescribeScheduleOutput,
                crate::error::DescribeScheduleError,
                crate::input::DescribeScheduleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Id of the channel whose schedule is being updated.
        pub fn channel_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_id(inp);
            self
        }
        /// Id of the channel whose schedule is being updated.
        pub fn set_channel_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_id(input);
            self
        }
        /// Placeholder documentation for MaxResults
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// Placeholder documentation for MaxResults
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Placeholder documentation for __string
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// Placeholder documentation for __string
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListChannels`.
    ///
    /// Produces list of channels that have been created
    #[derive(std::fmt::Debug)]
    pub struct ListChannels<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_channels_input::Builder,
    }
    impl<C, M, R> ListChannels<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListChannels`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListChannelsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListChannelsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListChannelsInputOperationOutputAlias,
                crate::output::ListChannelsOutput,
                crate::error::ListChannelsError,
                crate::input::ListChannelsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Placeholder documentation for MaxResults
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// Placeholder documentation for MaxResults
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Placeholder documentation for __string
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// Placeholder documentation for __string
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListInputDevices`.
    ///
    /// List input devices
    #[derive(std::fmt::Debug)]
    pub struct ListInputDevices<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_input_devices_input::Builder,
    }
    impl<C, M, R> ListInputDevices<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListInputDevices`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListInputDevicesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListInputDevicesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListInputDevicesInputOperationOutputAlias,
                crate::output::ListInputDevicesOutput,
                crate::error::ListInputDevicesError,
                crate::input::ListInputDevicesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Placeholder documentation for MaxResults
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// Placeholder documentation for MaxResults
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Placeholder documentation for __string
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// Placeholder documentation for __string
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListInputDeviceTransfers`.
    ///
    /// List input devices that are currently being transferred. List input devices that you are transferring from your AWS account or input devices that another AWS account is transferring to you.
    #[derive(std::fmt::Debug)]
    pub struct ListInputDeviceTransfers<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_input_device_transfers_input::Builder,
    }
    impl<C, M, R> ListInputDeviceTransfers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListInputDeviceTransfers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListInputDeviceTransfersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListInputDeviceTransfersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListInputDeviceTransfersInputOperationOutputAlias,
                crate::output::ListInputDeviceTransfersOutput,
                crate::error::ListInputDeviceTransfersError,
                crate::input::ListInputDeviceTransfersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Placeholder documentation for MaxResults
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// Placeholder documentation for MaxResults
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Placeholder documentation for __string
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// Placeholder documentation for __string
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Placeholder documentation for __string
        pub fn transfer_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.transfer_type(inp);
            self
        }
        /// Placeholder documentation for __string
        pub fn set_transfer_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_transfer_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListInputs`.
    ///
    /// Produces list of inputs that have been created
    #[derive(std::fmt::Debug)]
    pub struct ListInputs<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_inputs_input::Builder,
    }
    impl<C, M, R> ListInputs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListInputs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListInputsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListInputsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListInputsInputOperationOutputAlias,
                crate::output::ListInputsOutput,
                crate::error::ListInputsError,
                crate::input::ListInputsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Placeholder documentation for MaxResults
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// Placeholder documentation for MaxResults
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Placeholder documentation for __string
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// Placeholder documentation for __string
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListInputSecurityGroups`.
    ///
    /// Produces a list of Input Security Groups for an account
    #[derive(std::fmt::Debug)]
    pub struct ListInputSecurityGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_input_security_groups_input::Builder,
    }
    impl<C, M, R> ListInputSecurityGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListInputSecurityGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListInputSecurityGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListInputSecurityGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListInputSecurityGroupsInputOperationOutputAlias,
                crate::output::ListInputSecurityGroupsOutput,
                crate::error::ListInputSecurityGroupsError,
                crate::input::ListInputSecurityGroupsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Placeholder documentation for MaxResults
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// Placeholder documentation for MaxResults
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Placeholder documentation for __string
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// Placeholder documentation for __string
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListMultiplexes`.
    ///
    /// Retrieve a list of the existing multiplexes.
    #[derive(std::fmt::Debug)]
    pub struct ListMultiplexes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_multiplexes_input::Builder,
    }
    impl<C, M, R> ListMultiplexes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListMultiplexes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListMultiplexesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListMultiplexesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListMultiplexesInputOperationOutputAlias,
                crate::output::ListMultiplexesOutput,
                crate::error::ListMultiplexesError,
                crate::input::ListMultiplexesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The maximum number of items to return.
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// The maximum number of items to return.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// The token to retrieve the next page of results.
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// The token to retrieve the next page of results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListMultiplexPrograms`.
    ///
    /// List the programs that currently exist for a specific multiplex.
    #[derive(std::fmt::Debug)]
    pub struct ListMultiplexPrograms<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_multiplex_programs_input::Builder,
    }
    impl<C, M, R> ListMultiplexPrograms<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListMultiplexPrograms`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListMultiplexProgramsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListMultiplexProgramsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListMultiplexProgramsInputOperationOutputAlias,
                crate::output::ListMultiplexProgramsOutput,
                crate::error::ListMultiplexProgramsError,
                crate::input::ListMultiplexProgramsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The maximum number of items to return.
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// The maximum number of items to return.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// The ID of the multiplex that the programs belong to.
        pub fn multiplex_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.multiplex_id(inp);
            self
        }
        /// The ID of the multiplex that the programs belong to.
        pub fn set_multiplex_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_multiplex_id(input);
            self
        }
        /// The token to retrieve the next page of results.
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// The token to retrieve the next page of results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListOfferings`.
    ///
    /// List offerings available for purchase.
    #[derive(std::fmt::Debug)]
    pub struct ListOfferings<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_offerings_input::Builder,
    }
    impl<C, M, R> ListOfferings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListOfferings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListOfferingsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListOfferingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListOfferingsInputOperationOutputAlias,
                crate::output::ListOfferingsOutput,
                crate::error::ListOfferingsError,
                crate::input::ListOfferingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Filter by channel class, 'STANDARD' or 'SINGLE_PIPELINE'
        pub fn channel_class(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_class(inp);
            self
        }
        /// Filter by channel class, 'STANDARD' or 'SINGLE_PIPELINE'
        pub fn set_channel_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_channel_class(input);
            self
        }
        /// Filter to offerings that match the configuration of an existing channel, e.g. '2345678' (a channel ID)
        pub fn channel_configuration(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_configuration(inp);
            self
        }
        /// Filter to offerings that match the configuration of an existing channel, e.g. '2345678' (a channel ID)
        pub fn set_channel_configuration(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_channel_configuration(input);
            self
        }
        /// Filter by codec, 'AVC', 'HEVC', 'MPEG2', 'AUDIO', or 'LINK'
        pub fn codec(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.codec(inp);
            self
        }
        /// Filter by codec, 'AVC', 'HEVC', 'MPEG2', 'AUDIO', or 'LINK'
        pub fn set_codec(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_codec(input);
            self
        }
        /// Filter by offering duration, e.g. '12'
        pub fn duration(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.duration(inp);
            self
        }
        /// Filter by offering duration, e.g. '12'
        pub fn set_duration(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_duration(input);
            self
        }
        /// Placeholder documentation for MaxResults
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// Placeholder documentation for MaxResults
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Filter by bitrate, 'MAX_10_MBPS', 'MAX_20_MBPS', or 'MAX_50_MBPS'
        pub fn maximum_bitrate(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.maximum_bitrate(inp);
            self
        }
        /// Filter by bitrate, 'MAX_10_MBPS', 'MAX_20_MBPS', or 'MAX_50_MBPS'
        pub fn set_maximum_bitrate(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_maximum_bitrate(input);
            self
        }
        /// Filter by framerate, 'MAX_30_FPS' or 'MAX_60_FPS'
        pub fn maximum_framerate(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.maximum_framerate(inp);
            self
        }
        /// Filter by framerate, 'MAX_30_FPS' or 'MAX_60_FPS'
        pub fn set_maximum_framerate(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_maximum_framerate(input);
            self
        }
        /// Placeholder documentation for __string
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// Placeholder documentation for __string
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Filter by resolution, 'SD', 'HD', 'FHD', or 'UHD'
        pub fn resolution(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resolution(inp);
            self
        }
        /// Filter by resolution, 'SD', 'HD', 'FHD', or 'UHD'
        pub fn set_resolution(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resolution(input);
            self
        }
        /// Filter by resource type, 'INPUT', 'OUTPUT', 'MULTIPLEX', or 'CHANNEL'
        pub fn resource_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_type(inp);
            self
        }
        /// Filter by resource type, 'INPUT', 'OUTPUT', 'MULTIPLEX', or 'CHANNEL'
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// Filter by special feature, 'ADVANCED_AUDIO' or 'AUDIO_NORMALIZATION'
        pub fn special_feature(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.special_feature(inp);
            self
        }
        /// Filter by special feature, 'ADVANCED_AUDIO' or 'AUDIO_NORMALIZATION'
        pub fn set_special_feature(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_special_feature(input);
            self
        }
        /// Filter by video quality, 'STANDARD', 'ENHANCED', or 'PREMIUM'
        pub fn video_quality(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.video_quality(inp);
            self
        }
        /// Filter by video quality, 'STANDARD', 'ENHANCED', or 'PREMIUM'
        pub fn set_video_quality(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_video_quality(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListReservations`.
    ///
    /// List purchased reservations.
    #[derive(std::fmt::Debug)]
    pub struct ListReservations<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_reservations_input::Builder,
    }
    impl<C, M, R> ListReservations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListReservations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListReservationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListReservationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListReservationsInputOperationOutputAlias,
                crate::output::ListReservationsOutput,
                crate::error::ListReservationsError,
                crate::input::ListReservationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Filter by channel class, 'STANDARD' or 'SINGLE_PIPELINE'
        pub fn channel_class(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_class(inp);
            self
        }
        /// Filter by channel class, 'STANDARD' or 'SINGLE_PIPELINE'
        pub fn set_channel_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_channel_class(input);
            self
        }
        /// Filter by codec, 'AVC', 'HEVC', 'MPEG2', 'AUDIO', or 'LINK'
        pub fn codec(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.codec(inp);
            self
        }
        /// Filter by codec, 'AVC', 'HEVC', 'MPEG2', 'AUDIO', or 'LINK'
        pub fn set_codec(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_codec(input);
            self
        }
        /// Placeholder documentation for MaxResults
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// Placeholder documentation for MaxResults
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Filter by bitrate, 'MAX_10_MBPS', 'MAX_20_MBPS', or 'MAX_50_MBPS'
        pub fn maximum_bitrate(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.maximum_bitrate(inp);
            self
        }
        /// Filter by bitrate, 'MAX_10_MBPS', 'MAX_20_MBPS', or 'MAX_50_MBPS'
        pub fn set_maximum_bitrate(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_maximum_bitrate(input);
            self
        }
        /// Filter by framerate, 'MAX_30_FPS' or 'MAX_60_FPS'
        pub fn maximum_framerate(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.maximum_framerate(inp);
            self
        }
        /// Filter by framerate, 'MAX_30_FPS' or 'MAX_60_FPS'
        pub fn set_maximum_framerate(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_maximum_framerate(input);
            self
        }
        /// Placeholder documentation for __string
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// Placeholder documentation for __string
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Filter by resolution, 'SD', 'HD', 'FHD', or 'UHD'
        pub fn resolution(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resolution(inp);
            self
        }
        /// Filter by resolution, 'SD', 'HD', 'FHD', or 'UHD'
        pub fn set_resolution(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resolution(input);
            self
        }
        /// Filter by resource type, 'INPUT', 'OUTPUT', 'MULTIPLEX', or 'CHANNEL'
        pub fn resource_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_type(inp);
            self
        }
        /// Filter by resource type, 'INPUT', 'OUTPUT', 'MULTIPLEX', or 'CHANNEL'
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// Filter by special feature, 'ADVANCED_AUDIO' or 'AUDIO_NORMALIZATION'
        pub fn special_feature(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.special_feature(inp);
            self
        }
        /// Filter by special feature, 'ADVANCED_AUDIO' or 'AUDIO_NORMALIZATION'
        pub fn set_special_feature(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_special_feature(input);
            self
        }
        /// Filter by video quality, 'STANDARD', 'ENHANCED', or 'PREMIUM'
        pub fn video_quality(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.video_quality(inp);
            self
        }
        /// Filter by video quality, 'STANDARD', 'ENHANCED', or 'PREMIUM'
        pub fn set_video_quality(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_video_quality(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// Produces list of tags that have been created for a resource
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Placeholder documentation for __string
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// Placeholder documentation for __string
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PurchaseOffering`.
    ///
    /// Purchase an offering and create a reservation.
    #[derive(std::fmt::Debug)]
    pub struct PurchaseOffering<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::purchase_offering_input::Builder,
    }
    impl<C, M, R> PurchaseOffering<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PurchaseOffering`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PurchaseOfferingOutput,
            aws_smithy_http::result::SdkError<crate::error::PurchaseOfferingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PurchaseOfferingInputOperationOutputAlias,
                crate::output::PurchaseOfferingOutput,
                crate::error::PurchaseOfferingError,
                crate::input::PurchaseOfferingInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Number of resources
        pub fn count(mut self, inp: i32) -> Self {
            self.inner = self.inner.count(inp);
            self
        }
        /// Number of resources
        pub fn set_count(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_count(input);
            self
        }
        /// Name for the new reservation
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// Name for the new reservation
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Offering to purchase, e.g. '87654321'
        pub fn offering_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.offering_id(inp);
            self
        }
        /// Offering to purchase, e.g. '87654321'
        pub fn set_offering_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_offering_id(input);
            self
        }
        /// Unique request ID to be specified. This is needed to prevent retries from creating multiple resources.
        pub fn request_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.request_id(inp);
            self
        }
        /// Unique request ID to be specified. This is needed to prevent retries from creating multiple resources.
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_request_id(input);
            self
        }
        /// Requested reservation start time (UTC) in ISO-8601 format. The specified time must be between the first day of the current month and one year from now. If no value is given, the default is now.
        pub fn start(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.start(inp);
            self
        }
        /// Requested reservation start time (UTC) in ISO-8601 format. The specified time must be between the first day of the current month and one year from now. If no value is given, the default is now.
        pub fn set_start(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_start(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of key-value pairs
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// A collection of key-value pairs
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RejectInputDeviceTransfer`.
    ///
    /// Reject the transfer of the specified input device to your AWS account.
    #[derive(std::fmt::Debug)]
    pub struct RejectInputDeviceTransfer<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::reject_input_device_transfer_input::Builder,
    }
    impl<C, M, R> RejectInputDeviceTransfer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RejectInputDeviceTransfer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RejectInputDeviceTransferOutput,
            aws_smithy_http::result::SdkError<crate::error::RejectInputDeviceTransferError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RejectInputDeviceTransferInputOperationOutputAlias,
                crate::output::RejectInputDeviceTransferOutput,
                crate::error::RejectInputDeviceTransferError,
                crate::input::RejectInputDeviceTransferInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The unique ID of the input device to reject. For example, hd-123456789abcdef.
        pub fn input_device_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.input_device_id(inp);
            self
        }
        /// The unique ID of the input device to reject. For example, hd-123456789abcdef.
        pub fn set_input_device_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_input_device_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartChannel`.
    ///
    /// Starts an existing channel
    #[derive(std::fmt::Debug)]
    pub struct StartChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_channel_input::Builder,
    }
    impl<C, M, R> StartChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::StartChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartChannelInputOperationOutputAlias,
                crate::output::StartChannelOutput,
                crate::error::StartChannelError,
                crate::input::StartChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// A request to start a channel
        pub fn channel_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_id(inp);
            self
        }
        /// A request to start a channel
        pub fn set_channel_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartMultiplex`.
    ///
    /// Start (run) the multiplex. Starting the multiplex does not start the channels. You must explicitly start each channel.
    #[derive(std::fmt::Debug)]
    pub struct StartMultiplex<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_multiplex_input::Builder,
    }
    impl<C, M, R> StartMultiplex<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartMultiplex`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartMultiplexOutput,
            aws_smithy_http::result::SdkError<crate::error::StartMultiplexError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartMultiplexInputOperationOutputAlias,
                crate::output::StartMultiplexOutput,
                crate::error::StartMultiplexError,
                crate::input::StartMultiplexInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the multiplex.
        pub fn multiplex_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.multiplex_id(inp);
            self
        }
        /// The ID of the multiplex.
        pub fn set_multiplex_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_multiplex_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopChannel`.
    ///
    /// Stops a running channel
    #[derive(std::fmt::Debug)]
    pub struct StopChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_channel_input::Builder,
    }
    impl<C, M, R> StopChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::StopChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopChannelInputOperationOutputAlias,
                crate::output::StopChannelOutput,
                crate::error::StopChannelError,
                crate::input::StopChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// A request to stop a running channel
        pub fn channel_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_id(inp);
            self
        }
        /// A request to stop a running channel
        pub fn set_channel_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopMultiplex`.
    ///
    /// Stops a running multiplex. If the multiplex isn't running, this action has no effect.
    #[derive(std::fmt::Debug)]
    pub struct StopMultiplex<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_multiplex_input::Builder,
    }
    impl<C, M, R> StopMultiplex<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopMultiplex`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopMultiplexOutput,
            aws_smithy_http::result::SdkError<crate::error::StopMultiplexError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopMultiplexInputOperationOutputAlias,
                crate::output::StopMultiplexOutput,
                crate::error::StopMultiplexError,
                crate::input::StopMultiplexInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the multiplex.
        pub fn multiplex_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.multiplex_id(inp);
            self
        }
        /// The ID of the multiplex.
        pub fn set_multiplex_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_multiplex_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TransferInputDevice`.
    ///
    /// Start an input device transfer to another AWS account. After you make the request, the other account must accept or reject the transfer.
    #[derive(std::fmt::Debug)]
    pub struct TransferInputDevice<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::transfer_input_device_input::Builder,
    }
    impl<C, M, R> TransferInputDevice<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TransferInputDevice`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TransferInputDeviceOutput,
            aws_smithy_http::result::SdkError<crate::error::TransferInputDeviceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TransferInputDeviceInputOperationOutputAlias,
                crate::output::TransferInputDeviceOutput,
                crate::error::TransferInputDeviceError,
                crate::input::TransferInputDeviceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The unique ID of this input device. For example, hd-123456789abcdef.
        pub fn input_device_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.input_device_id(inp);
            self
        }
        /// The unique ID of this input device. For example, hd-123456789abcdef.
        pub fn set_input_device_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_input_device_id(input);
            self
        }
        /// The AWS account ID (12 digits) for the recipient of the device transfer.
        pub fn target_customer_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_customer_id(inp);
            self
        }
        /// The AWS account ID (12 digits) for the recipient of the device transfer.
        pub fn set_target_customer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_customer_id(input);
            self
        }
        /// The target AWS region to transfer the device.
        pub fn target_region(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_region(inp);
            self
        }
        /// The target AWS region to transfer the device.
        pub fn set_target_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_region(input);
            self
        }
        /// An optional message for the recipient. Maximum 280 characters.
        pub fn transfer_message(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.transfer_message(inp);
            self
        }
        /// An optional message for the recipient. Maximum 280 characters.
        pub fn set_transfer_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_transfer_message(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateChannel`.
    ///
    /// Updates a channel.
    #[derive(std::fmt::Debug)]
    pub struct UpdateChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_channel_input::Builder,
    }
    impl<C, M, R> UpdateChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateChannelInputOperationOutputAlias,
                crate::output::UpdateChannelOutput,
                crate::error::UpdateChannelError,
                crate::input::UpdateChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Specification of CDI inputs for this channel
        pub fn cdi_input_specification(mut self, inp: crate::model::CdiInputSpecification) -> Self {
            self.inner = self.inner.cdi_input_specification(inp);
            self
        }
        /// Specification of CDI inputs for this channel
        pub fn set_cdi_input_specification(
            mut self,
            input: std::option::Option<crate::model::CdiInputSpecification>,
        ) -> Self {
            self.inner = self.inner.set_cdi_input_specification(input);
            self
        }
        /// channel ID
        pub fn channel_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_id(inp);
            self
        }
        /// channel ID
        pub fn set_channel_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_id(input);
            self
        }
        /// Appends an item to `Destinations`.
        ///
        /// To override the contents of this collection use [`set_destinations`](Self::set_destinations).
        ///
        /// A list of output destinations for this channel.
        pub fn destinations(mut self, inp: impl Into<crate::model::OutputDestination>) -> Self {
            self.inner = self.inner.destinations(inp);
            self
        }
        /// A list of output destinations for this channel.
        pub fn set_destinations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OutputDestination>>,
        ) -> Self {
            self.inner = self.inner.set_destinations(input);
            self
        }
        /// The encoder settings for this channel.
        pub fn encoder_settings(mut self, inp: crate::model::EncoderSettings) -> Self {
            self.inner = self.inner.encoder_settings(inp);
            self
        }
        /// The encoder settings for this channel.
        pub fn set_encoder_settings(
            mut self,
            input: std::option::Option<crate::model::EncoderSettings>,
        ) -> Self {
            self.inner = self.inner.set_encoder_settings(input);
            self
        }
        /// Appends an item to `InputAttachments`.
        ///
        /// To override the contents of this collection use [`set_input_attachments`](Self::set_input_attachments).
        ///
        /// Placeholder documentation for __listOfInputAttachment
        pub fn input_attachments(mut self, inp: impl Into<crate::model::InputAttachment>) -> Self {
            self.inner = self.inner.input_attachments(inp);
            self
        }
        /// Placeholder documentation for __listOfInputAttachment
        pub fn set_input_attachments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InputAttachment>>,
        ) -> Self {
            self.inner = self.inner.set_input_attachments(input);
            self
        }
        /// Specification of network and file inputs for this channel
        pub fn input_specification(mut self, inp: crate::model::InputSpecification) -> Self {
            self.inner = self.inner.input_specification(inp);
            self
        }
        /// Specification of network and file inputs for this channel
        pub fn set_input_specification(
            mut self,
            input: std::option::Option<crate::model::InputSpecification>,
        ) -> Self {
            self.inner = self.inner.set_input_specification(input);
            self
        }
        /// The log level to write to CloudWatch Logs.
        pub fn log_level(mut self, inp: crate::model::LogLevel) -> Self {
            self.inner = self.inner.log_level(inp);
            self
        }
        /// The log level to write to CloudWatch Logs.
        pub fn set_log_level(mut self, input: std::option::Option<crate::model::LogLevel>) -> Self {
            self.inner = self.inner.set_log_level(input);
            self
        }
        /// The name of the channel.
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// The name of the channel.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// An optional Amazon Resource Name (ARN) of the role to assume when running the Channel. If you do not specify this on an update call but the role was previously set that role will be removed.
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// An optional Amazon Resource Name (ARN) of the role to assume when running the Channel. If you do not specify this on an update call but the role was previously set that role will be removed.
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateChannelClass`.
    ///
    /// Changes the class of the channel.
    #[derive(std::fmt::Debug)]
    pub struct UpdateChannelClass<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_channel_class_input::Builder,
    }
    impl<C, M, R> UpdateChannelClass<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateChannelClass`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateChannelClassOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateChannelClassError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateChannelClassInputOperationOutputAlias,
                crate::output::UpdateChannelClassOutput,
                crate::error::UpdateChannelClassError,
                crate::input::UpdateChannelClassInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The channel class that you wish to update this channel to use.
        pub fn channel_class(mut self, inp: crate::model::ChannelClass) -> Self {
            self.inner = self.inner.channel_class(inp);
            self
        }
        /// The channel class that you wish to update this channel to use.
        pub fn set_channel_class(
            mut self,
            input: std::option::Option<crate::model::ChannelClass>,
        ) -> Self {
            self.inner = self.inner.set_channel_class(input);
            self
        }
        /// Channel Id of the channel whose class should be updated.
        pub fn channel_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_id(inp);
            self
        }
        /// Channel Id of the channel whose class should be updated.
        pub fn set_channel_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_id(input);
            self
        }
        /// Appends an item to `Destinations`.
        ///
        /// To override the contents of this collection use [`set_destinations`](Self::set_destinations).
        ///
        /// A list of output destinations for this channel.
        pub fn destinations(mut self, inp: impl Into<crate::model::OutputDestination>) -> Self {
            self.inner = self.inner.destinations(inp);
            self
        }
        /// A list of output destinations for this channel.
        pub fn set_destinations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OutputDestination>>,
        ) -> Self {
            self.inner = self.inner.set_destinations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateInput`.
    ///
    /// Updates an input.
    #[derive(std::fmt::Debug)]
    pub struct UpdateInput<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_input_input::Builder,
    }
    impl<C, M, R> UpdateInput<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateInput`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateInputOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateInputError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateInputInputOperationOutputAlias,
                crate::output::UpdateInputOutput,
                crate::error::UpdateInputError,
                crate::input::UpdateInputInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Destinations`.
        ///
        /// To override the contents of this collection use [`set_destinations`](Self::set_destinations).
        ///
        /// Destination settings for PUSH type inputs.
        pub fn destinations(
            mut self,
            inp: impl Into<crate::model::InputDestinationRequest>,
        ) -> Self {
            self.inner = self.inner.destinations(inp);
            self
        }
        /// Destination settings for PUSH type inputs.
        pub fn set_destinations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InputDestinationRequest>>,
        ) -> Self {
            self.inner = self.inner.set_destinations(input);
            self
        }
        /// Appends an item to `InputDevices`.
        ///
        /// To override the contents of this collection use [`set_input_devices`](Self::set_input_devices).
        ///
        /// Settings for the devices.
        pub fn input_devices(mut self, inp: impl Into<crate::model::InputDeviceRequest>) -> Self {
            self.inner = self.inner.input_devices(inp);
            self
        }
        /// Settings for the devices.
        pub fn set_input_devices(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InputDeviceRequest>>,
        ) -> Self {
            self.inner = self.inner.set_input_devices(input);
            self
        }
        /// Unique ID of the input.
        pub fn input_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.input_id(inp);
            self
        }
        /// Unique ID of the input.
        pub fn set_input_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_input_id(input);
            self
        }
        /// Appends an item to `InputSecurityGroups`.
        ///
        /// To override the contents of this collection use [`set_input_security_groups`](Self::set_input_security_groups).
        ///
        /// A list of security groups referenced by IDs to attach to the input.
        pub fn input_security_groups(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.input_security_groups(inp);
            self
        }
        /// A list of security groups referenced by IDs to attach to the input.
        pub fn set_input_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_input_security_groups(input);
            self
        }
        /// Appends an item to `MediaConnectFlows`.
        ///
        /// To override the contents of this collection use [`set_media_connect_flows`](Self::set_media_connect_flows).
        ///
        /// A list of the MediaConnect Flow ARNs that you want to use as the source of the input. You can specify as few as one
        /// Flow and presently, as many as two. The only requirement is when you have more than one is that each Flow is in a
        /// separate Availability Zone as this ensures your EML input is redundant to AZ issues.
        pub fn media_connect_flows(
            mut self,
            inp: impl Into<crate::model::MediaConnectFlowRequest>,
        ) -> Self {
            self.inner = self.inner.media_connect_flows(inp);
            self
        }
        /// A list of the MediaConnect Flow ARNs that you want to use as the source of the input. You can specify as few as one
        /// Flow and presently, as many as two. The only requirement is when you have more than one is that each Flow is in a
        /// separate Availability Zone as this ensures your EML input is redundant to AZ issues.
        pub fn set_media_connect_flows(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MediaConnectFlowRequest>>,
        ) -> Self {
            self.inner = self.inner.set_media_connect_flows(input);
            self
        }
        /// Name of the input.
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// Name of the input.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// The Amazon Resource Name (ARN) of the role this input assumes during and after creation.
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// The Amazon Resource Name (ARN) of the role this input assumes during and after creation.
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// Appends an item to `Sources`.
        ///
        /// To override the contents of this collection use [`set_sources`](Self::set_sources).
        ///
        /// The source URLs for a PULL-type input. Every PULL type input needs
        /// exactly two source URLs for redundancy.
        /// Only specify sources for PULL type Inputs. Leave Destinations empty.
        pub fn sources(mut self, inp: impl Into<crate::model::InputSourceRequest>) -> Self {
            self.inner = self.inner.sources(inp);
            self
        }
        /// The source URLs for a PULL-type input. Every PULL type input needs
        /// exactly two source URLs for redundancy.
        /// Only specify sources for PULL type Inputs. Leave Destinations empty.
        pub fn set_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InputSourceRequest>>,
        ) -> Self {
            self.inner = self.inner.set_sources(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateInputDevice`.
    ///
    /// Updates the parameters for the input device.
    #[derive(std::fmt::Debug)]
    pub struct UpdateInputDevice<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_input_device_input::Builder,
    }
    impl<C, M, R> UpdateInputDevice<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateInputDevice`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateInputDeviceOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateInputDeviceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateInputDeviceInputOperationOutputAlias,
                crate::output::UpdateInputDeviceOutput,
                crate::error::UpdateInputDeviceError,
                crate::input::UpdateInputDeviceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The settings that you want to apply to the HD input device.
        pub fn hd_device_settings(
            mut self,
            inp: crate::model::InputDeviceConfigurableSettings,
        ) -> Self {
            self.inner = self.inner.hd_device_settings(inp);
            self
        }
        /// The settings that you want to apply to the HD input device.
        pub fn set_hd_device_settings(
            mut self,
            input: std::option::Option<crate::model::InputDeviceConfigurableSettings>,
        ) -> Self {
            self.inner = self.inner.set_hd_device_settings(input);
            self
        }
        /// The unique ID of the input device. For example, hd-123456789abcdef.
        pub fn input_device_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.input_device_id(inp);
            self
        }
        /// The unique ID of the input device. For example, hd-123456789abcdef.
        pub fn set_input_device_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_input_device_id(input);
            self
        }
        /// The name that you assigned to this input device (not the unique ID).
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// The name that you assigned to this input device (not the unique ID).
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// The settings that you want to apply to the UHD input device.
        pub fn uhd_device_settings(
            mut self,
            inp: crate::model::InputDeviceConfigurableSettings,
        ) -> Self {
            self.inner = self.inner.uhd_device_settings(inp);
            self
        }
        /// The settings that you want to apply to the UHD input device.
        pub fn set_uhd_device_settings(
            mut self,
            input: std::option::Option<crate::model::InputDeviceConfigurableSettings>,
        ) -> Self {
            self.inner = self.inner.set_uhd_device_settings(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateInputSecurityGroup`.
    ///
    /// Update an Input Security Group's Whilelists.
    #[derive(std::fmt::Debug)]
    pub struct UpdateInputSecurityGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_input_security_group_input::Builder,
    }
    impl<C, M, R> UpdateInputSecurityGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateInputSecurityGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateInputSecurityGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateInputSecurityGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateInputSecurityGroupInputOperationOutputAlias,
                crate::output::UpdateInputSecurityGroupOutput,
                crate::error::UpdateInputSecurityGroupError,
                crate::input::UpdateInputSecurityGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The id of the Input Security Group to update.
        pub fn input_security_group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.input_security_group_id(inp);
            self
        }
        /// The id of the Input Security Group to update.
        pub fn set_input_security_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_input_security_group_id(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of key-value pairs.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// A collection of key-value pairs.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// Appends an item to `WhitelistRules`.
        ///
        /// To override the contents of this collection use [`set_whitelist_rules`](Self::set_whitelist_rules).
        ///
        /// List of IPv4 CIDR addresses to whitelist
        pub fn whitelist_rules(
            mut self,
            inp: impl Into<crate::model::InputWhitelistRuleCidr>,
        ) -> Self {
            self.inner = self.inner.whitelist_rules(inp);
            self
        }
        /// List of IPv4 CIDR addresses to whitelist
        pub fn set_whitelist_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InputWhitelistRuleCidr>>,
        ) -> Self {
            self.inner = self.inner.set_whitelist_rules(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateMultiplex`.
    ///
    /// Updates a multiplex.
    #[derive(std::fmt::Debug)]
    pub struct UpdateMultiplex<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_multiplex_input::Builder,
    }
    impl<C, M, R> UpdateMultiplex<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateMultiplex`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateMultiplexOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateMultiplexError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateMultiplexInputOperationOutputAlias,
                crate::output::UpdateMultiplexOutput,
                crate::error::UpdateMultiplexError,
                crate::input::UpdateMultiplexInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// ID of the multiplex to update.
        pub fn multiplex_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.multiplex_id(inp);
            self
        }
        /// ID of the multiplex to update.
        pub fn set_multiplex_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_multiplex_id(input);
            self
        }
        /// The new settings for a multiplex.
        pub fn multiplex_settings(mut self, inp: crate::model::MultiplexSettings) -> Self {
            self.inner = self.inner.multiplex_settings(inp);
            self
        }
        /// The new settings for a multiplex.
        pub fn set_multiplex_settings(
            mut self,
            input: std::option::Option<crate::model::MultiplexSettings>,
        ) -> Self {
            self.inner = self.inner.set_multiplex_settings(input);
            self
        }
        /// Name of the multiplex.
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// Name of the multiplex.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateMultiplexProgram`.
    ///
    /// Update a program in a multiplex.
    #[derive(std::fmt::Debug)]
    pub struct UpdateMultiplexProgram<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_multiplex_program_input::Builder,
    }
    impl<C, M, R> UpdateMultiplexProgram<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateMultiplexProgram`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateMultiplexProgramOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateMultiplexProgramError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateMultiplexProgramInputOperationOutputAlias,
                crate::output::UpdateMultiplexProgramOutput,
                crate::error::UpdateMultiplexProgramError,
                crate::input::UpdateMultiplexProgramInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the multiplex of the program to update.
        pub fn multiplex_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.multiplex_id(inp);
            self
        }
        /// The ID of the multiplex of the program to update.
        pub fn set_multiplex_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_multiplex_id(input);
            self
        }
        /// The new settings for a multiplex program.
        pub fn multiplex_program_settings(
            mut self,
            inp: crate::model::MultiplexProgramSettings,
        ) -> Self {
            self.inner = self.inner.multiplex_program_settings(inp);
            self
        }
        /// The new settings for a multiplex program.
        pub fn set_multiplex_program_settings(
            mut self,
            input: std::option::Option<crate::model::MultiplexProgramSettings>,
        ) -> Self {
            self.inner = self.inner.set_multiplex_program_settings(input);
            self
        }
        /// The name of the program to update.
        pub fn program_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.program_name(inp);
            self
        }
        /// The name of the program to update.
        pub fn set_program_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_program_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateReservation`.
    ///
    /// Update reservation.
    #[derive(std::fmt::Debug)]
    pub struct UpdateReservation<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_reservation_input::Builder,
    }
    impl<C, M, R> UpdateReservation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateReservation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateReservationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateReservationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateReservationInputOperationOutputAlias,
                crate::output::UpdateReservationOutput,
                crate::error::UpdateReservationError,
                crate::input::UpdateReservationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Name of the reservation
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// Name of the reservation
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Unique reservation ID, e.g. '1234567'
        pub fn reservation_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reservation_id(inp);
            self
        }
        /// Unique reservation ID, e.g. '1234567'
        pub fn set_reservation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_reservation_id(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::new(conn)
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::https()
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
